/*
 * Decompiled with CFR 0.152.
 */
package co.nstant.in.cbor.model;

import co.nstant.in.cbor.model.ChunkableDataItem;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.MajorType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Array
extends ChunkableDataItem {
    private final ArrayList<DataItem> objects;

    public Array() {
        super(MajorType.ARRAY);
        this.objects = new ArrayList();
    }

    public Array(int initialCapacity) {
        super(MajorType.ARRAY);
        this.objects = new ArrayList(initialCapacity);
    }

    public Array add(DataItem object) {
        this.objects.add(object);
        return this;
    }

    public List<DataItem> getDataItems() {
        return this.objects;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Array) {
            Array other = (Array)object;
            return super.equals(object) && this.objects.equals(other.objects);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.objects.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        if (this.isChunked()) {
            stringBuilder.append("_ ");
        }
        stringBuilder.append(Arrays.toString(this.objects.toArray()).substring(1));
        return stringBuilder.toString();
    }

    public DataItem peekLast() {
        if (this.objects.isEmpty()) {
            return null;
        }
        return this.objects.get(this.objects.size() - 1);
    }
}

