import{s as Tn,o as Un,n as yn}from"../chunks/scheduler.f7e1785c.js";import{S as Jn,i as jn,g as p,s as a,r as U,A as mn,h as M,f as t,c as n,j as Mn,u as i,x as T,k as Os,y as cn,a as s,v as y,d as J,t as j,w as m}from"../chunks/index.9f8f0838.js";import{T as wn}from"../chunks/Tip.4575d9cf.js";import{C as c}from"../chunks/CodeBlock.b3510e34.js";import{H as u}from"../chunks/Heading.6643a2f7.js";function rn(_e){let w,o="在我们的示例中，我们将使用大约 40 小时的训练数据。如果您想使用 Google Colab 免费版的 GPU 复现，需要将训练数据量减少到大约 10-15 小时，并减少训练步骤的数量。";return{c(){w=p("p"),w.textContent=o},l(r){w=M(r,"P",{"data-svelte-h":!0}),T(w)!=="svelte-az1j4w"&&(w.textContent=o)},m(r,Ae){s(r,w,Ae)},p:yn,d(r){r&&t(w)}}}function un(_e){let w,o,r,Ae,C,We,b,Ls="现在您已经熟悉了语音合成任务和 SpeechT5 模型的内部工作原理，该模型是在英语数据上预训练的，让我们看看如何将其微调到另一种语言。",Be,$,Ge,I,Ps="如果您想复现这个示例，请确保您有一个 GPU。在笔记本中，您可以使用以下命令检查：",Ye,k,ve,h,Xe,Z,Ks="您还需要一些额外的依赖：",Ee,Q,Ne,x,la="最后，不要忘记登录您的 Hugging Face 账户，以便您能够上传并与社区共享您的模型：",ze,R,Fe,g,He,A,ea=`在这个示例中，我们将使用 <a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> 数据集的荷兰语（<code>nl</code>）子集。
<a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> 是一个大规模的多语言语音语料库，包含了 2009-2020 年欧洲议会事件的录音数据。
它包含 15 种欧洲语言的带标签的音频-转写数据。虽然我们将使用荷兰语子集，但您可以自由选择其他子集。`,Se,V,ta="这是一个语音识别（ASR）数据集，所以，如前所述，它不是训练 TTS 模型的最佳选择。然而，对于这个练习来说，它已经足够好了。",qe,_,sa="让我们加载数据：",De,W,Oe,B,aa="<strong>输出：</strong>",Le,G,Pe,Y,na="20968 条数据应该足以进行微调。输入 SpeechT5 的音频数据应具有 16 kHz 的采样率，所以要确保我们的数据集满足这一要求：",Ke,v,lt,X,et,E,pa="处理器包含了分词器和特征提取器，我们需要用它们来预处理训练数据。所以我们先定义要使用的模型检查点，并加载对应的处理器：",tt,N,st,z,at,F,Ma="首先，为了处理文本，我们需要处理器的分词器部分，所以让我们来获取它：",nt,H,pt,S,Ta="让我们看一个示例：",Mt,q,Tt,D,Ua="<strong>输出：</strong>",Ut,O,it,L,ia=`您可能会注意到数据包含 <code>raw_text</code> 和 <code>normalized_text</code> 特征。在决定使用哪个特征作为文本输入时，需要注意的是 SpeechT5 分词器没有任何数字的词元。
在 <code>normalized_text</code> 中，数字被写成文本。因此，它更合适，我们应该使用 <code>normalized_text</code> 作为输入文本。`,yt,P,ya=`因为 SpeechT5 是在英语上训练的，它可能无法识别荷兰语数据集中的某些字符。如果保持原样，这些字符将被转换为 <code>&lt;unk&gt;</code> 词元。
然而，在荷兰语中，某些字符如 <code>à</code> 用于强调音节。为了保留文本的含义，我们可以将此字符替换为普通的 <code>a</code>。`,Jt,K,Ja=`要识别不支持的词元，使用 <code>SpeechT5Tokenizer</code> 提取数据集中所有独特字符，该分词器将字符视为词元。为此，我们将编写 <code>extract_all_chars</code> 映射函数，
该函数将所有数据样例的转写连接成一个字符串，然后转换为字符集。确保在 <code>dataset.map()</code> 中设置 <code>batched=True</code> 和 <code>batch_size=-1</code>，以便一次性获取所有转写并输入映射函数。`,jt,ll,mt,el,ja="现在您有两组字符：一个来自数据集，另一个来自分词器。要识别数据集中任何不支持的字符，您可以取这两组的差集，结果将包含在数据集中而不在分词器中的字符。",ct,tl,wt,sl,ma="<strong>输出：</strong>",rt,al,ut,nl,ca="为了处理上一步骤中识别的不支持字符，我们可以定义一个将这些字符映射到有效词元的函数。注意，分词器中的空格已经被替换为 <code>▁</code>，因此不需要单独处理。",ht,pl,dt,Ml,wa="现在我们处理好了文本中的特殊字符，是时候将注意力转移到音频数据上了。",ft,Tl,ot,Ul,ra=`VoxPopuli 数据集包含多个说话人的语音，但到底有多少呢？我们可以计算一下数据集中说话人的数量以及每个说话人贡献的数据量。
数据集总共有 20,968 条数据，这些信息将帮助我们更好地了解数据中的说话人和数据样例的分布。`,Ct,il,bt,yl,ua="通过绘制直方图，您可以了解每个说话人的数据量。",$t,Jl,It,d,ha='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_speakers_histogram.png" alt="Speakers histogram"/>',kt,jl,da="直方图显示，数据集中大约三分之一的说话人的数据少于 100 条，而大约十个说话人的数据超过 500 条。为了提高训练效率并平衡数据集，我们可以将数据限制在有 100 到 400 条数据的说话人之间。",Zt,ml,Qt,cl,fa="让我们检查还剩多少个说话人：",xt,wl,Rt,rl,oa="<strong>输出：</strong>",gt,ul,At,hl,Ca="让我们看看还剩多少条数据：",Vt,dl,_t,fl,ba="<strong>输出：</strong>",Wt,ol,Bt,Cl,$a="您留下了不到 10,000 条数据，来自大约 40 个独特的说话人，这应该足够用了。",Gt,bl,Ia=`请注意，如果某些数据很长，一些看似数据样例量较少的说话人可能有比预想的更多的音频数据。然而，确定每个说话人的总音频量需要扫描整个数据集，
这是一个耗时的过程，涉及加载和解码每个音频文件。因此，我们在这里选择跳过这一步。`,Yt,$l,vt,Il,ka=`为了使 TTS 模型能够区分多个说话人，您需要为每条数据创建一个说话人嵌入。说话人嵌入是模型的一个额外输入，用于描述特定说话人的声音特征。
要生成这些说话人嵌入，可以使用来自 SpeechBrain 的预训练模型 <a href="https://huggingface.co/speechbrain/spkrec-xvect-voxceleb" rel="nofollow">spkrec-xvect-voxceleb</a>。`,Xt,kl,Za="创建一个 <code>create_speaker_embedding()</code> 函数，该函数接受音频波形作为输入，并输出包含相应说话人嵌入的 512 维向量。",Et,Zl,Nt,Ql,Qa=`注意，<code>speechbrain/spkrec-xvect-voxceleb</code> 模型是在 VoxCeleb 数据集的英语语音上训练的，而这个示例训练的是荷兰语。
虽然我们相信这个模型仍然可以为我们的荷兰语数据集生成合理的说话人嵌入，但这个假设可能不总是成立。`,zt,xl,xa=`为了获得最佳结果，我们需要首先在目标语音上训练 X-Vector 模型。这将确保模型能够更好地捕捉荷兰语中存在的独特声音特征。如果您想训练自己的 X-向量模型，
可以参考 <a href="https://huggingface.co/mechanicalsea/speecht5-vc/blob/main/manifest/utils/prep_cmu_arctic_spkemb.py" rel="nofollow">此脚本</a>。`,Ft,Rl,Ht,gl,Ra="最后，让我们将数据处理成模型能够读入的格式。创建一个 <code>prepare_dataset</code> 函数，输入单个示例并使用 <code>SpeechT5Processor</code> 对象来对输入文本进行分词，并将目标音频加载成对数梅尔谱。它还应该额外输入说话人嵌入。",St,Al,qt,Vl,ga="查看单个示例来验证处理是否正确：",Dt,_l,Ot,Wl,Aa="<strong>输出：</strong>",Lt,Bl,Pt,Gl,Va="说话人嵌入应该是一个 512 维向量：",Kt,Yl,ls,vl,_a="<strong>输出：</strong>",es,Xl,ts,El,Wa="标签应该是一个有 80 个 mel 频段的对数梅尔谱。",ss,Nl,as,f,Ba='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_logmelspectrogram_1.png" alt="Log-mel spectrogram with 80 mel bins"/>',ns,zl,Ga="注：如果您看不明白这个频谱图，可能是因为您习惯将低频放在底部，高频放在顶部。然而，在使用 matplotlib 库将频谱图作为图像绘制时，y 轴是反过来的，频谱图看起来是倒置的。",ps,Fl,Ya="现在我们需要将处理函数应用于整个数据集。这将花费 5 到 10 分钟的时间。",Ms,Hl,Ts,Sl,va="您会看到一个警告说数据集中的某些数据长于模型能够处理的最大输入长度（600 词元），得从数据集中删除这些数据。在这里，我们更进一步，为了允许更大的批量大小，删除任何超过 200 词元的内容。",Us,ql,is,Dl,Xa="<strong>输出：</strong>",ys,Ol,Js,Ll,Ea="接下来，把数据集分成基本的训练/测试子集：",js,Pl,ms,Kl,cs,le,Na=`为了将多条数据组合成一个批次，您需要定义一个自定义数据整理器。这个整理器将使用填充词元填充较短的序列，确保所有示例都具有相同的长度。
对于频谱图标签，填充部分将被特殊值 <code>-100</code> 替换。这个特殊值指示模型在计算频谱图的损失函数时忽略那部分频谱图。`,ws,ee,rs,te,za=`在 SpeechT5 中，模型的解码器部分的输入减少了 2 倍（reduction factor）。换句话说，它抛弃了目标序列中每两步中的一步。然后，解码器预测一个两倍长度的序列。
由于原来的目标序列长度可能是奇数，数据整理器会确保将批次的最大长度调整为 2 的倍数。`,us,se,hs,ae,ds,ne,Fa="从与处理器相同的检查点加载预训练模型：",fs,pe,os,Me,Ha="<code>use_cache=True</code> 选项与梯度检查点不兼容。我们在训练时禁用这个选项，并在生成时重新启用缓存以加快推理：",Cs,Te,bs,Ue,Sa="定义训练参数。这里我们在训练过程中不计算任何评估指标，我们将在本章稍后讨论评估。这里，我们先只关注损失函数：",$s,ie,Is,ye,qa="实例化 <code>Trainer</code> 对象并将模型、数据集和数据整理器传递给它。",ks,Je,Zs,je,Da="有了这个，我们就准备开始训练了！训练将花费几个小时。由于 GPU 不同，当您开始训练时，可能会遇到 CUDA 报“out-of-memory”（显存不足）的错误。这时，您可以尝试将 <code>per_device_train_batch_size</code> 两倍两倍地减少，并将 <code>gradient_accumulation_steps</code> 增加到两倍以补偿。",Qs,me,xs,ce,Oa="将最终的模型上传到 🤗 Hub：",Rs,we,gs,re,As,ue,La="一旦您微调了一个模型，您就可以使用它进行推理！从 🤗 Hub 加载模型（记得在以下代码片段中使用您的账号名）：",Vs,he,_s,de,Pa="选择一个示例，这里我们将从测试数据集中取一个。获取说话人嵌入。",Ws,fe,Bs,oe,Ka="定义一些输入文本并对它进行分词。",Gs,Ce,Ys,be,ln="预处理输入文本：",vs,$e,Xs,Ie,en="实例化一个声码器并生成语音：",Es,ke,Ns,Ze,tn="准备好听结果了吗？",zs,Qe,Fs,xe,sn="用这个模型在新语言上获得的满意结果可能很有挑战性。说话人嵌入的质量可能是一个重要因素。由于 SpeechT5 是使用英语 X-Vector 预训练的，它在使用英语说话人嵌入时表现最佳。如果合成的语音听起来效果不好，尝试使用不同的说话人嵌入。",Hs,Re,an="增加训练时长也可能提高结果的质量。但即便不继续训练，语音也显然是荷兰语而不是英语，并且它确实学到了说话人的声音特征（与示例中的原始音频相比较）。另一个可以试验的是模型的配置。例如，尝试使用 <code>config.reduction_factor = 1</code> 来看是否能改善结果。",Ss,ge,nn="在下一节中，我们将讨论如何评估语音合成模型。",qs,Ve,Ds;return C=new u({props:{title:"微调 SpeechT5",local:"微调-speecht5",headingTag:"h1"}}),$=new u({props:{title:"基础准备",local:"基础准备",headingTag:"h2"}}),k=new c({props:{code:"bnZpZGlhLXNtaQ==",highlighted:"nvidia-smi",wrap:!1}}),h=new wn({props:{warning:!0,$$slots:{default:[rn]},$$scope:{ctx:_e}}}),Q=new c({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwc291bmRmaWxlJTIwc3BlZWNoYnJhaW4lMjBhY2NlbGVyYXRl",highlighted:"pip install transformers datasets soundfile speechbrain accelerate",wrap:!1}}),R=new c({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),g=new u({props:{title:"数据集",local:"数据集",headingTag:"h2"}}),W=new c({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwQXVkaW8lMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmZhY2Vib29rJTJGdm94cG9wdWxpJTIyJTJDJTIwJTIybmwlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio

dataset = load_dataset(<span class="hljs-string">&quot;facebook/voxpopuli&quot;</span>, <span class="hljs-string">&quot;nl&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-built_in">len</span>(dataset)`,wrap:!1}}),G=new c({props:{code:"MjA5Njg=",highlighted:"20968",wrap:!1}}),v=new c({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuY2FzdF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBBdWRpbyhzYW1wbGluZ19yYXRlJTNEMTYwMDApKQ==",highlighted:'dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16000</span>))',wrap:!1}}),X=new u({props:{title:"数据预处理",local:"数据预处理",headingTag:"h2"}}),N=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1UHJvY2Vzc29yJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X3R0cyUyMiUwQXByb2Nlc3NvciUyMCUzRCUyMFNwZWVjaFQ1UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5Processor

checkpoint = <span class="hljs-string">&quot;microsoft/speecht5_tts&quot;</span>
processor = SpeechT5Processor.from_pretrained(checkpoint)`,wrap:!1}}),z=new u({props:{title:"为 SpeechT5 分词进行文本清理",local:"为-speecht5-分词进行文本清理",headingTag:"h3"}}),H=new c({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwcHJvY2Vzc29yLnRva2VuaXplcg==",highlighted:"tokenizer = processor.tokenizer",wrap:!1}}),q=new c({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:'dataset[<span class="hljs-number">0</span>]',wrap:!1}}),O=new c({props:{code:"JTdCJ2F1ZGlvX2lkJyUzQSUyMCcyMDEwMDIxMC0wOTAwLVBMRU5BUlktMy1ubF8yMDEwMDIxMC0wOSUzQTA2JTNBNDNfNCclMkMlMEElMjAnbGFuZ3VhZ2UnJTNBJTIwOSUyQyUwQSUyMCdhdWRpbyclM0ElMjAlN0IncGF0aCclM0ElMjAnJTJGcm9vdCUyRi5jYWNoZSUyRmh1Z2dpbmdmYWNlJTJGZGF0YXNldHMlMkZkb3dubG9hZHMlMkZleHRyYWN0ZWQlMkYwMmVjNmExOWQ1Yjk3YzAzZTEzNzkyNTAzNzg0NTRkYmYzZmEyOTcyOTQzNTA0YTkxYzdkYTUwNDVhYTI2YTg5JTJGdHJhaW5fcGFydF8wJTJGMjAxMDAyMTAtMDkwMC1QTEVOQVJZLTMtbmxfMjAxMDAyMTAtMDklM0EwNiUzQTQzXzQud2F2JyUyQyUwQSUyMCUyMCdhcnJheSclM0ElMjBhcnJheSglNUIlMjA0LjI3MjQ2MDk0ZS0wNCUyQyUyMCUyMDEuMzEyMjU1ODZlLTAzJTJDJTIwJTIwMS4wMzc1OTc2NmUtMDMlMkMlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAtOS4xNTUyNzM0NGUtMDUlMkMlMjAlMjA3LjYyOTM5NDUzZS0wNCUyQyUyMC0yLjQ0MTQwNjI1ZS0wNCU1RCklMkMlMEElMjAlMjAnc2FtcGxpbmdfcmF0ZSclM0ElMjAxNjAwMCU3RCUyQyUwQSUyMCdyYXdfdGV4dCclM0ElMjAnRGF0JTIwa2FuJTIwbmFhciUyMG1pam4lMjBnZXZvZWwlMjBhbGxlZW4lMjBtZXQlMjBlZW4lMjBicmVkZSUyMG1lZXJkZXJoZWlkJTIwZGllJTIwd2lqJTIwc2FtZW4lMjB6b2VrZW4uJyUyQyUwQSUyMCdub3JtYWxpemVkX3RleHQnJTNBJTIwJ2RhdCUyMGthbiUyMG5hYXIlMjBtaWpuJTIwZ2V2b2VsJTIwYWxsZWVuJTIwbWV0JTIwZWVuJTIwYnJlZGUlMjBtZWVyZGVyaGVpZCUyMGRpZSUyMHdpaiUyMHNhbWVuJTIwem9la2VuLiclMkMlMEElMjAnZ2VuZGVyJyUzQSUyMCdmZW1hbGUnJTJDJTBBJTIwJ3NwZWFrZXJfaWQnJTNBJTIwJzExMjInJTJDJTBBJTIwJ2lzX2dvbGRfdHJhbnNjcmlwdCclM0ElMjBUcnVlJTJDJTBBJTIwJ2FjY2VudCclM0ElMjAnTm9uZSclN0Q=",highlighted:`{&#x27;audio_id&#x27;: &#x27;<span class="hljs-number">20100210-0900</span>-PLENARY-3-nl_<span class="hljs-number">20100210-09:06:43</span>_4&#x27;,
 &#x27;language&#x27;: <span class="hljs-number">9</span>,
 &#x27;audio&#x27;: {&#x27;path&#x27;: &#x27;/root/.cache/huggingface/datasets/downloads/extracted/02ec6a19d5b97c03e<span class="hljs-number">137925037845</span>4dbf3fa<span class="hljs-number">2972943504</span>a91c7da<span class="hljs-number">5045</span>aa26a89/train_part_0/<span class="hljs-number">20100210-0900</span>-PLENARY-3-nl_<span class="hljs-number">20100210-09:06:43</span>_4.wav&#x27;,
  &#x27;array&#x27;: array([ <span class="hljs-number">4.27246094</span>e-<span class="hljs-number">04</span>,  <span class="hljs-number">1.31225586</span>e-<span class="hljs-number">03</span>,  <span class="hljs-number">1.03759766</span>e-<span class="hljs-number">03</span>, ...,
         -<span class="hljs-number">9.15527344</span>e-<span class="hljs-number">05</span>,  <span class="hljs-number">7.62939453</span>e-<span class="hljs-number">04</span>, -<span class="hljs-number">2.44140625</span>e-<span class="hljs-number">04</span>]),
  &#x27;sampling_rate&#x27;: <span class="hljs-number">16000</span>},
 &#x27;raw_text&#x27;: &#x27;Dat kan naar mijn gevoel alleen met een brede meerderheid die wij samen zoeken.&#x27;,
 &#x27;normalized_text&#x27;: &#x27;dat kan naar mijn gevoel alleen met een brede meerderheid die wij samen zoeken.&#x27;,
 &#x27;gender&#x27;: &#x27;female&#x27;,
 &#x27;speaker_id&#x27;: &#x27;<span class="hljs-number">1122</span>&#x27;,
 &#x27;is_gold_transcript&#x27;: True,
 &#x27;accent&#x27;: &#x27;None&#x27;}`,wrap:!1}}),ll=new c({props:{code:"ZGVmJTIwZXh0cmFjdF9hbGxfY2hhcnMoYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwYWxsX3RleHQlMjAlM0QlMjAlMjIlMjAlMjIuam9pbihiYXRjaCU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCklMEElMjAlMjAlMjAlMjB2b2NhYiUyMCUzRCUyMGxpc3Qoc2V0KGFsbF90ZXh0KSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJ2b2NhYiUyMiUzQSUyMCU1QnZvY2FiJTVEJTJDJTIwJTIyYWxsX3RleHQlMjIlM0ElMjAlNUJhbGxfdGV4dCU1RCU3RCUwQSUwQSUwQXZvY2FicyUyMCUzRCUyMGRhdGFzZXQubWFwKCUwQSUyMCUyMCUyMCUyMGV4dHJhY3RfYWxsX2NoYXJzJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hlZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNELTElMkMlMEElMjAlMjAlMjAlMjBrZWVwX2luX21lbW9yeSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZW1vdmVfY29sdW1ucyUzRGRhdGFzZXQuY29sdW1uX25hbWVzJTJDJTBBKSUwQSUwQWRhdGFzZXRfdm9jYWIlMjAlM0QlMjBzZXQodm9jYWJzJTVCJTIydm9jYWIlMjIlNUQlNUIwJTVEKSUwQXRva2VuaXplcl92b2NhYiUyMCUzRCUyMCU3QmslMjBmb3IlMjBrJTJDJTIwXyUyMGluJTIwdG9rZW5pemVyLmdldF92b2NhYigpLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_all_chars</span>(<span class="hljs-params">batch</span>):
    all_text = <span class="hljs-string">&quot; &quot;</span>.join(batch[<span class="hljs-string">&quot;normalized_text&quot;</span>])
    vocab = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(all_text))
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;vocab&quot;</span>: [vocab], <span class="hljs-string">&quot;all_text&quot;</span>: [all_text]}


vocabs = dataset.<span class="hljs-built_in">map</span>(
    extract_all_chars,
    batched=<span class="hljs-literal">True</span>,
    batch_size=-<span class="hljs-number">1</span>,
    keep_in_memory=<span class="hljs-literal">True</span>,
    remove_columns=dataset.column_names,
)

dataset_vocab = <span class="hljs-built_in">set</span>(vocabs[<span class="hljs-string">&quot;vocab&quot;</span>][<span class="hljs-number">0</span>])
tokenizer_vocab = {k <span class="hljs-keyword">for</span> k, _ <span class="hljs-keyword">in</span> tokenizer.get_vocab().items()}`,wrap:!1}}),tl=new c({props:{code:"ZGF0YXNldF92b2NhYiUyMC0lMjB0b2tlbml6ZXJfdm9jYWI=",highlighted:"dataset_vocab - tokenizer_vocab",wrap:!1}}),al=new c({props:{code:"JTdCJyUyMCclMkMlMjAnJUMzJUEwJyUyQyUyMCclQzMlQTcnJTJDJTIwJyVDMyVBOCclMkMlMjAnJUMzJUFCJyUyQyUyMCclQzMlQUQnJTJDJTIwJyVDMyVBRiclMkMlMjAnJUMzJUI2JyUyQyUyMCclQzMlQkMnJTdE",highlighted:"{&#x27; &#x27;, &#x27;à&#x27;, &#x27;ç&#x27;, &#x27;è&#x27;, &#x27;ë&#x27;, &#x27;í&#x27;, &#x27;ï&#x27;, &#x27;ö&#x27;, &#x27;ü&#x27;}",wrap:!1}}),pl=new c({props:{code:"cmVwbGFjZW1lbnRzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBMCUyMiUyQyUyMCUyMmElMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBNyUyMiUyQyUyMCUyMmMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBOCUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBQiUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRCUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRiUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCNiUyMiUyQyUyMCUyMm8lMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCQyUyMiUyQyUyMCUyMnUlMjIpJTJDJTBBJTVEJTBBJTBBJTBBZGVmJTIwY2xlYW51cF90ZXh0KGlucHV0cyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBzcmMlMkMlMjBkc3QlMjBpbiUyMHJlcGxhY2VtZW50cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCUyMCUzRCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RC5yZXBsYWNlKHNyYyUyQyUyMGRzdCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dHMlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoY2xlYW51cF90ZXh0KQ==",highlighted:`replacements = [
    (<span class="hljs-string">&quot;à&quot;</span>, <span class="hljs-string">&quot;a&quot;</span>),
    (<span class="hljs-string">&quot;ç&quot;</span>, <span class="hljs-string">&quot;c&quot;</span>),
    (<span class="hljs-string">&quot;è&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
    (<span class="hljs-string">&quot;ë&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
    (<span class="hljs-string">&quot;í&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
    (<span class="hljs-string">&quot;ï&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
    (<span class="hljs-string">&quot;ö&quot;</span>, <span class="hljs-string">&quot;o&quot;</span>),
    (<span class="hljs-string">&quot;ü&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>),
]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">cleanup_text</span>(<span class="hljs-params">inputs</span>):
    <span class="hljs-keyword">for</span> src, dst <span class="hljs-keyword">in</span> replacements:
        inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>] = inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>].replace(src, dst)
    <span class="hljs-keyword">return</span> inputs


dataset = dataset.<span class="hljs-built_in">map</span>(cleanup_text)`,wrap:!1}}),Tl=new u({props:{title:"说话人",local:"说话人",headingTag:"h3"}}),il=new c({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEFzcGVha2VyX2NvdW50cyUyMCUzRCUyMGRlZmF1bHRkaWN0KGludCklMEElMEFmb3IlMjBzcGVha2VyX2lkJTIwaW4lMjBkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMHNwZWFrZXJfY291bnRzJTVCc3BlYWtlcl9pZCU1RCUyMCUyQiUzRCUyMDE=",highlighted:`<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

speaker_counts = defaultdict(<span class="hljs-built_in">int</span>)

<span class="hljs-keyword">for</span> speaker_id <span class="hljs-keyword">in</span> dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]:
    speaker_counts[speaker_id] += <span class="hljs-number">1</span>`,wrap:!1}}),Jl=new c({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5oaXN0KHNwZWFrZXJfY291bnRzLnZhbHVlcygpJTJDJTIwYmlucyUzRDIwKSUwQXBsdC55bGFiZWwoJTIyU3BlYWtlcnMlMjIpJTBBcGx0LnhsYWJlbCglMjJFeGFtcGxlcyUyMiklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

plt.figure()
plt.hist(speaker_counts.values(), bins=<span class="hljs-number">20</span>)
plt.ylabel(<span class="hljs-string">&quot;Speakers&quot;</span>)
plt.xlabel(<span class="hljs-string">&quot;Examples&quot;</span>)
plt.show()`,wrap:!1}}),ml=new c({props:{code:"ZGVmJTIwc2VsZWN0X3NwZWFrZXIoc3BlYWtlcl9pZCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAxMDAlMjAlM0MlM0QlMjBzcGVha2VyX2NvdW50cyU1QnNwZWFrZXJfaWQlNUQlMjAlM0MlM0QlMjA0MDAlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5maWx0ZXIoc2VsZWN0X3NwZWFrZXIlMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyc3BlYWtlcl9pZCUyMiU1RCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">select_speaker</span>(<span class="hljs-params">speaker_id</span>):
    <span class="hljs-keyword">return</span> <span class="hljs-number">100</span> &lt;= speaker_counts[speaker_id] &lt;= <span class="hljs-number">400</span>


dataset = dataset.<span class="hljs-built_in">filter</span>(select_speaker, input_columns=[<span class="hljs-string">&quot;speaker_id&quot;</span>])`,wrap:!1}}),wl=new c({props:{code:"bGVuKHNldChkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCkp",highlighted:'<span class="hljs-built_in">len</span>(<span class="hljs-built_in">set</span>(dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]))',wrap:!1}}),ul=new c({props:{code:"NDI=",highlighted:"42",wrap:!1}}),dl=new c({props:{code:"bGVuKGRhdGFzZXQp",highlighted:'<span class="hljs-built_in">len</span>(dataset)',wrap:!1}}),ol=new c({props:{code:"OTk3Mw==",highlighted:'<span class="hljs-number">9973</span>',wrap:!1}}),$l=new u({props:{title:"说话人嵌入",local:"说话人嵌入",headingTag:"h3"}}),Zl=new c({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBzcGVlY2hicmFpbi5wcmV0cmFpbmVkJTIwaW1wb3J0JTIwRW5jb2RlckNsYXNzaWZpZXIlMEElMEFzcGtfbW9kZWxfbmFtZSUyMCUzRCUyMCUyMnNwZWVjaGJyYWluJTJGc3BrcmVjLXh2ZWN0LXZveGNlbGViJTIyJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFzcGVha2VyX21vZGVsJTIwJTNEJTIwRW5jb2RlckNsYXNzaWZpZXIuZnJvbV9ocGFyYW1zKCUwQSUyMCUyMCUyMCUyMHNvdXJjZSUzRHNwa19tb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwcnVuX29wdHMlM0QlN0IlMjJkZXZpY2UlMjIlM0ElMjBkZXZpY2UlN0QlMkMlMEElMjAlMjAlMjAlMjBzYXZlZGlyJTNEb3MucGF0aC5qb2luKCUyMiUyRnRtcCUyMiUyQyUyMHNwa19tb2RlbF9uYW1lKSUyQyUwQSklMEElMEElMEFkZWYlMjBjcmVhdGVfc3BlYWtlcl9lbWJlZGRpbmcod2F2ZWZvcm0pJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyMCUzRCUyMHNwZWFrZXJfbW9kZWwuZW5jb2RlX2JhdGNoKHRvcmNoLnRlbnNvcih3YXZlZm9ybSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5ub3JtYWxpemUoc3BlYWtlcl9lbWJlZGRpbmdzJTJDJTIwZGltJTNEMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGVha2VyX2VtYmVkZGluZ3MlMjAlM0QlMjBzcGVha2VyX2VtYmVkZGluZ3Muc3F1ZWV6ZSgpLmNwdSgpLm51bXB5KCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzcGVha2VyX2VtYmVkZGluZ3M=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> speechbrain.pretrained <span class="hljs-keyword">import</span> EncoderClassifier

spk_model_name = <span class="hljs-string">&quot;speechbrain/spkrec-xvect-voxceleb&quot;</span>

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
speaker_model = EncoderClassifier.from_hparams(
    source=spk_model_name,
    run_opts={<span class="hljs-string">&quot;device&quot;</span>: device},
    savedir=os.path.join(<span class="hljs-string">&quot;/tmp&quot;</span>, spk_model_name),
)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_speaker_embedding</span>(<span class="hljs-params">waveform</span>):
    <span class="hljs-keyword">with</span> torch.no_grad():
        speaker_embeddings = speaker_model.encode_batch(torch.tensor(waveform))
        speaker_embeddings = torch.nn.functional.normalize(speaker_embeddings, dim=<span class="hljs-number">2</span>)
        speaker_embeddings = speaker_embeddings.squeeze().cpu().numpy()
    <span class="hljs-keyword">return</span> speaker_embeddings`,wrap:!1}}),Rl=new u({props:{title:"处理数据集",local:"处理数据集",headingTag:"h3"}}),Al=new c({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRleHQlM0RleGFtcGxlJTVCJTIybm9ybWFsaXplZF90ZXh0JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXVkaW9fdGFyZ2V0JTNEYXVkaW8lNUIlMjJhcnJheSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlM0RhdWRpbyU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm5fYXR0ZW50aW9uX21hc2slM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjAlRTUlOEUlQkIlRTYlOEUlODklRTYlODklQjklRTklODclOEYlRTUlQTQlODQlRTclOTAlODYlRTclOUElODQlRTclQkIlQjQlRTUlQkElQTYlMEElMjAlMjAlMjAlMjBleGFtcGxlJTVCJTIybGFiZWxzJTIyJTVEJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmxhYmVscyUyMiU1RCU1QjAlNUQlMEElMEElMjAlMjAlMjAlMjAlMjMlMjAlRTclOTQlQTglMjBTcGVlY2hCcmFpbiUyMCVFOCU4RSVCNyVFNSU4RiU5NiUyMFgtVmVjdG9yJTBBJTIwJTIwJTIwJTIwZXhhbXBsZSU1QiUyMnNwZWFrZXJfZW1iZWRkaW5ncyUyMiU1RCUyMCUzRCUyMGNyZWF0ZV9zcGVha2VyX2VtYmVkZGluZyhhdWRpbyU1QiUyMmFycmF5JTIyJTVEKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGV4YW1wbGU=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]

    example = processor(
        text=example[<span class="hljs-string">&quot;normalized_text&quot;</span>],
        audio_target=audio[<span class="hljs-string">&quot;array&quot;</span>],
        sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        return_attention_mask=<span class="hljs-literal">False</span>,
    )

    <span class="hljs-comment"># 去掉批量处理的维度</span>
    example[<span class="hljs-string">&quot;labels&quot;</span>] = example[<span class="hljs-string">&quot;labels&quot;</span>][<span class="hljs-number">0</span>]

    <span class="hljs-comment"># 用 SpeechBrain 获取 X-Vector</span>
    example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = create_speaker_embedding(audio[<span class="hljs-string">&quot;array&quot;</span>])

    <span class="hljs-keyword">return</span> example`,wrap:!1}}),_l=new c({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlMjAlM0QlMjBwcmVwYXJlX2RhdGFzZXQoZGF0YXNldCU1QjAlNUQpJTBBbGlzdChwcm9jZXNzZWRfZXhhbXBsZS5rZXlzKCkp",highlighted:`processed_example = prepare_dataset(dataset[<span class="hljs-number">0</span>])
<span class="hljs-built_in">list</span>(processed_example.keys())`,wrap:!1}}),Bl=new c({props:{code:"JTVCJ2lucHV0X2lkcyclMkMlMjAnbGFiZWxzJyUyQyUyMCdzdG9wX2xhYmVscyclMkMlMjAnc3BlYWtlcl9lbWJlZGRpbmdzJyU1RA==",highlighted:'[<span class="hljs-symbol">&#x27;input_ids</span>&#x27;, <span class="hljs-symbol">&#x27;labels</span>&#x27;, <span class="hljs-symbol">&#x27;stop_labels</span>&#x27;, <span class="hljs-symbol">&#x27;speaker_embeddings</span>&#x27;]',wrap:!1}}),Yl=new c({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQuc2hhcGU=",highlighted:'processed_example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>].shape',wrap:!1}}),Xl=new c({props:{code:"KDUxMiUyQyk=",highlighted:'(<span class="hljs-number">512</span><span class="hljs-punctuation">,</span>)',wrap:!1}}),Nl=new c({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5pbXNob3cocHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJsYWJlbHMlMjIlNUQuVCklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

plt.figure()
plt.imshow(processed_example[<span class="hljs-string">&quot;labels&quot;</span>].T)
plt.show()`,wrap:!1}}),Hl=new c({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKHByZXBhcmVfZGF0YXNldCUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEZGF0YXNldC5jb2x1bW5fbmFtZXMp",highlighted:'dataset = dataset.<span class="hljs-built_in">map</span>(prepare_dataset, remove_columns=dataset.column_names)',wrap:!1}}),ql=new c({props:{code:"ZGVmJTIwaXNfbm90X3Rvb19sb25nKGlucHV0X2lkcyklM0ElMEElMjAlMjAlMjAlMjBpbnB1dF9sZW5ndGglMjAlM0QlMjBsZW4oaW5wdXRfaWRzKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGlucHV0X2xlbmd0aCUyMCUzQyUyMDIwMCUwQSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmZpbHRlcihpc19ub3RfdG9vX2xvbmclMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_not_too_long</span>(<span class="hljs-params">input_ids</span>):
    input_length = <span class="hljs-built_in">len</span>(input_ids)
    <span class="hljs-keyword">return</span> input_length &lt; <span class="hljs-number">200</span>


dataset = dataset.<span class="hljs-built_in">filter</span>(is_not_too_long, input_columns=[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-built_in">len</span>(dataset)`,wrap:!1}}),Ol=new c({props:{code:"ODI1OQ==",highlighted:'<span class="hljs-number">8259</span>',wrap:!1}}),Pl=new c({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQudHJhaW5fdGVzdF9zcGxpdCh0ZXN0X3NpemUlM0QwLjEp",highlighted:'dataset = dataset.train_test_split(test_size=<span class="hljs-number">0.1</span>)',wrap:!1}}),Kl=new u({props:{title:"数据整理器",local:"数据整理器",headingTag:"h3"}}),ee=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Union</span>


<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">TTSDataCollatorWithPadding</span>:
    processor: <span class="hljs-type">Any</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">
        self, features: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Union</span>[<span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>], torch.Tensor]]]
    </span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
        input_ids = [{<span class="hljs-string">&quot;input_ids&quot;</span>: feature[<span class="hljs-string">&quot;input_ids&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        label_features = [{<span class="hljs-string">&quot;input_values&quot;</span>: feature[<span class="hljs-string">&quot;labels&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        speaker_features = [feature[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]

        <span class="hljs-comment"># 把输入数据和生成目标整合进一个批次</span>
        batch = processor.pad(
            input_ids=input_ids, labels=label_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
        )

        <span class="hljs-comment"># 把填充词元换成 -100 来正确地忽略这一部分的损失函数</span>
        batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>].masked_fill(
            batch.decoder_attention_mask.unsqueeze(-<span class="hljs-number">1</span>).ne(<span class="hljs-number">1</span>), -<span class="hljs-number">100</span>
        )

        <span class="hljs-comment"># 在微调时用不上，删了</span>
        <span class="hljs-keyword">del</span> batch[<span class="hljs-string">&quot;decoder_attention_mask&quot;</span>]

        <span class="hljs-comment"># 把目标长度下调到 reduction factor 的整数倍</span>
        <span class="hljs-keyword">if</span> model.config.reduction_factor &gt; <span class="hljs-number">1</span>:
            target_lengths = torch.tensor(
                [<span class="hljs-built_in">len</span>(feature[<span class="hljs-string">&quot;input_values&quot;</span>]) <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> label_features]
            )
            target_lengths = target_lengths.new(
                [
                    length - length % model.config.reduction_factor
                    <span class="hljs-keyword">for</span> length <span class="hljs-keyword">in</span> target_lengths
                ]
            )
            max_length = <span class="hljs-built_in">max</span>(target_lengths)
            batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>][:, :max_length]

        <span class="hljs-comment"># 加上说话人嵌入</span>
        batch[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = torch.tensor(speaker_features)

        <span class="hljs-keyword">return</span> batch`,wrap:!1}}),se=new c({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMFRUU0RhdGFDb2xsYXRvcldpdGhQYWRkaW5nKHByb2Nlc3NvciUzRHByb2Nlc3Nvcik=",highlighted:"data_collator = TTSDataCollatorWithPadding(processor=processor)",wrap:!1}}),ae=new u({props:{title:"训练模型",local:"训练模型",headingTag:"h2"}}),pe=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1Rm9yVGV4dFRvU3BlZWNoJTBBJTBBbW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5ForTextToSpeech

model = SpeechT5ForTextToSpeech.from_pretrained(checkpoint)`,wrap:!1}}),Te=new c({props:{code:"ZnJvbSUyMGZ1bmN0b29scyUyMGltcG9ydCUyMHBhcnRpYWwlMEElMEElMjMlMjAlRTUlOUMlQTglRTglQUUlQUQlRTclQkIlODMlRTYlOTclQjYlRTclQTYlODElRTclOTQlQTglRTclQkMlOTMlRTUlQUQlOTglMEFtb2RlbC5jb25maWcudXNlX2NhY2hlJTIwJTNEJTIwRmFsc2UlMEElMEElMjMlMjAlRTglQUUlQkUlRTclQkQlQUUlRTglQUYlQUQlRTglQTglODAlRTUlOTIlOEMlRTQlQkIlQkIlRTUlOEElQTElRTUlODclODYlRTUlQTQlODclRTYlOEUlQTglRTclOTAlODYlRUYlQkMlOEMlRTUlQjklQjYlRTklODclOEQlRTYlOTYlQjAlRTUlOTAlQUYlRTclOTQlQTglRTclQkMlOTMlRTUlQUQlOTglMEFtb2RlbC5nZW5lcmF0ZSUyMCUzRCUyMHBhcnRpYWwobW9kZWwuZ2VuZXJhdGUlMkMlMjB1c2VfY2FjaGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial

<span class="hljs-comment"># 在训练时禁用缓存</span>
model.config.use_cache = <span class="hljs-literal">False</span>

<span class="hljs-comment"># 设置语言和任务准备推理，并重新启用缓存</span>
model.generate = partial(model.generate, use_cache=<span class="hljs-literal">True</span>)`,wrap:!1}}),ie=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmluZ0FyZ3VtZW50cyUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBTZXEyU2VxVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMnNwZWVjaHQ1X2ZpbmV0dW5lZF92b3hwb3B1bGlfbmwlMjIlMkMlMjAlMjAlMjMlMjAlRTYlOTQlQjklRTYlODglOTAlRTYlODIlQTglRTklODAlODklRTYlOEIlQTklRTclOUElODQlRTQlQkIlOTMlRTUlQkElOTMlRTUlOTAlOEQlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNEOCUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0QxZS01JTJDJTBBJTIwJTIwJTIwJTIwd2FybXVwX3N0ZXBzJTNENTAwJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3N0ZXBzJTNENDAwMCUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2NoZWNrcG9pbnRpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZnAxNiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBldmFsdWF0aW9uX3N0cmF0ZWd5JTNEJTIyc3RlcHMlMjIlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX2V2YWxfYmF0Y2hfc2l6ZSUzRDIlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0ZXBzJTNEMTAwMCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RlcHMlM0QxMDAwJTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDI1JTJDJTBBJTIwJTIwJTIwJTIwcmVwb3J0X3RvJTNEJTVCJTIydGVuc29yYm9hcmQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2Jlc3RfbW9kZWxfYXRfZW5kJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGdyZWF0ZXJfaXNfYmV0dGVyJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBsYWJlbF9uYW1lcyUzRCU1QiUyMmxhYmVscyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHB1c2hfdG9faHViJTNEVHJ1ZSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainingArguments

training_args = Seq2SeqTrainingArguments(
    output_dir=<span class="hljs-string">&quot;speecht5_finetuned_voxpopuli_nl&quot;</span>,  <span class="hljs-comment"># 改成您选择的仓库名</span>
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    gradient_accumulation_steps=<span class="hljs-number">8</span>,
    learning_rate=<span class="hljs-number">1e-5</span>,
    warmup_steps=<span class="hljs-number">500</span>,
    max_steps=<span class="hljs-number">4000</span>,
    gradient_checkpointing=<span class="hljs-literal">True</span>,
    fp16=<span class="hljs-literal">True</span>,
    evaluation_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    per_device_eval_batch_size=<span class="hljs-number">2</span>,
    save_steps=<span class="hljs-number">1000</span>,
    eval_steps=<span class="hljs-number">1000</span>,
    logging_steps=<span class="hljs-number">25</span>,
    report_to=[<span class="hljs-string">&quot;tensorboard&quot;</span>],
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    greater_is_better=<span class="hljs-literal">False</span>,
    label_names=[<span class="hljs-string">&quot;labels&quot;</span>],
    push_to_hub=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),Je=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmVyJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNlcTJTZXFUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0RkYXRhX2NvbGxhdG9yJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEcHJvY2Vzc29yJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainer

trainer = Seq2SeqTrainer(
    args=training_args,
    model=model,
    train_dataset=dataset[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=dataset[<span class="hljs-string">&quot;test&quot;</span>],
    data_collator=data_collator,
    tokenizer=processor,
)`,wrap:!1}}),me=new c({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),we=new c({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:"trainer.push_to_hub()",wrap:!1}}),re=new u({props:{title:"推理",local:"推理",headingTag:"h2"}}),he=new c({props:{code:"bW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyJUU2JTgyJUE4JUU3JTlBJTg0JUU4JUI0JUE2JUU1JThGJUI3JTJGc3BlZWNodDVfZmluZXR1bmVkX3ZveHBvcHVsaV9ubCUyMiUwQSk=",highlighted:`model = SpeechT5ForTextToSpeech.from_pretrained(
    <span class="hljs-string">&quot;您的账号/speecht5_finetuned_voxpopuli_nl&quot;</span>
)`,wrap:!1}}),fe=new c({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCMzA0JTVEJTBBc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKGV4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQpLnVuc3F1ZWV6ZSgwKQ==",highlighted:`example = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-number">304</span>]
speaker_embeddings = torch.tensor(example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>]).unsqueeze(<span class="hljs-number">0</span>)`,wrap:!1}}),Ce=new c({props:{code:"dGV4dCUyMCUzRCUyMCUyMmhhbGxvJTIwYWxsZW1hYWwlMkMlMjBpayUyMHByYWF0JTIwbmVkZXJsYW5kcy4lMjBncm9ldGplcyUyMGFhbiUyMGllZGVyZWVuISUyMg==",highlighted:'text = <span class="hljs-string">&quot;hallo allemaal, ik praat nederlands. groetjes aan iedereen!&quot;</span>',wrap:!1}}),$e=new c({props:{code:"aW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0R0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'inputs = processor(text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),ke=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1SGlmaUdhbiUwQSUwQXZvY29kZXIlMjAlM0QlMjBTcGVlY2hUNUhpZmlHYW4uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X2hpZmlnYW4lMjIpJTBBc3BlZWNoJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGVfc3BlZWNoKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyQyUyMHZvY29kZXIlM0R2b2NvZGVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5HifiGan

vocoder = SpeechT5HifiGan.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_hifigan&quot;</span>)
speech = model.generate_speech(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], speaker_embeddings, vocoder=vocoder)`,wrap:!1}}),Qe=new c({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBQXVkaW8oc3BlZWNoLm51bXB5KCklMkMlMjByYXRlJTNEMTYwMDAp",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

Audio(speech.numpy(), rate=<span class="hljs-number">16000</span>)`,wrap:!1}}),{c(){w=p("meta"),o=a(),r=p("p"),Ae=a(),U(C.$$.fragment),We=a(),b=p("p"),b.textContent=Ls,Be=a(),U($.$$.fragment),Ge=a(),I=p("p"),I.textContent=Ps,Ye=a(),U(k.$$.fragment),ve=a(),U(h.$$.fragment),Xe=a(),Z=p("p"),Z.textContent=Ks,Ee=a(),U(Q.$$.fragment),Ne=a(),x=p("p"),x.textContent=la,ze=a(),U(R.$$.fragment),Fe=a(),U(g.$$.fragment),He=a(),A=p("p"),A.innerHTML=ea,Se=a(),V=p("p"),V.textContent=ta,qe=a(),_=p("p"),_.textContent=sa,De=a(),U(W.$$.fragment),Oe=a(),B=p("p"),B.innerHTML=aa,Le=a(),U(G.$$.fragment),Pe=a(),Y=p("p"),Y.textContent=na,Ke=a(),U(v.$$.fragment),lt=a(),U(X.$$.fragment),et=a(),E=p("p"),E.textContent=pa,tt=a(),U(N.$$.fragment),st=a(),U(z.$$.fragment),at=a(),F=p("p"),F.textContent=Ma,nt=a(),U(H.$$.fragment),pt=a(),S=p("p"),S.textContent=Ta,Mt=a(),U(q.$$.fragment),Tt=a(),D=p("p"),D.innerHTML=Ua,Ut=a(),U(O.$$.fragment),it=a(),L=p("p"),L.innerHTML=ia,yt=a(),P=p("p"),P.innerHTML=ya,Jt=a(),K=p("p"),K.innerHTML=Ja,jt=a(),U(ll.$$.fragment),mt=a(),el=p("p"),el.textContent=ja,ct=a(),U(tl.$$.fragment),wt=a(),sl=p("p"),sl.innerHTML=ma,rt=a(),U(al.$$.fragment),ut=a(),nl=p("p"),nl.innerHTML=ca,ht=a(),U(pl.$$.fragment),dt=a(),Ml=p("p"),Ml.textContent=wa,ft=a(),U(Tl.$$.fragment),ot=a(),Ul=p("p"),Ul.textContent=ra,Ct=a(),U(il.$$.fragment),bt=a(),yl=p("p"),yl.textContent=ua,$t=a(),U(Jl.$$.fragment),It=a(),d=p("div"),d.innerHTML=ha,kt=a(),jl=p("p"),jl.textContent=da,Zt=a(),U(ml.$$.fragment),Qt=a(),cl=p("p"),cl.textContent=fa,xt=a(),U(wl.$$.fragment),Rt=a(),rl=p("p"),rl.innerHTML=oa,gt=a(),U(ul.$$.fragment),At=a(),hl=p("p"),hl.textContent=Ca,Vt=a(),U(dl.$$.fragment),_t=a(),fl=p("p"),fl.innerHTML=ba,Wt=a(),U(ol.$$.fragment),Bt=a(),Cl=p("p"),Cl.textContent=$a,Gt=a(),bl=p("p"),bl.textContent=Ia,Yt=a(),U($l.$$.fragment),vt=a(),Il=p("p"),Il.innerHTML=ka,Xt=a(),kl=p("p"),kl.innerHTML=Za,Et=a(),U(Zl.$$.fragment),Nt=a(),Ql=p("p"),Ql.innerHTML=Qa,zt=a(),xl=p("p"),xl.innerHTML=xa,Ft=a(),U(Rl.$$.fragment),Ht=a(),gl=p("p"),gl.innerHTML=Ra,St=a(),U(Al.$$.fragment),qt=a(),Vl=p("p"),Vl.textContent=ga,Dt=a(),U(_l.$$.fragment),Ot=a(),Wl=p("p"),Wl.innerHTML=Aa,Lt=a(),U(Bl.$$.fragment),Pt=a(),Gl=p("p"),Gl.textContent=Va,Kt=a(),U(Yl.$$.fragment),ls=a(),vl=p("p"),vl.innerHTML=_a,es=a(),U(Xl.$$.fragment),ts=a(),El=p("p"),El.textContent=Wa,ss=a(),U(Nl.$$.fragment),as=a(),f=p("div"),f.innerHTML=Ba,ns=a(),zl=p("p"),zl.textContent=Ga,ps=a(),Fl=p("p"),Fl.textContent=Ya,Ms=a(),U(Hl.$$.fragment),Ts=a(),Sl=p("p"),Sl.textContent=va,Us=a(),U(ql.$$.fragment),is=a(),Dl=p("p"),Dl.innerHTML=Xa,ys=a(),U(Ol.$$.fragment),Js=a(),Ll=p("p"),Ll.textContent=Ea,js=a(),U(Pl.$$.fragment),ms=a(),U(Kl.$$.fragment),cs=a(),le=p("p"),le.innerHTML=Na,ws=a(),U(ee.$$.fragment),rs=a(),te=p("p"),te.textContent=za,us=a(),U(se.$$.fragment),hs=a(),U(ae.$$.fragment),ds=a(),ne=p("p"),ne.textContent=Fa,fs=a(),U(pe.$$.fragment),os=a(),Me=p("p"),Me.innerHTML=Ha,Cs=a(),U(Te.$$.fragment),bs=a(),Ue=p("p"),Ue.textContent=Sa,$s=a(),U(ie.$$.fragment),Is=a(),ye=p("p"),ye.innerHTML=qa,ks=a(),U(Je.$$.fragment),Zs=a(),je=p("p"),je.innerHTML=Da,Qs=a(),U(me.$$.fragment),xs=a(),ce=p("p"),ce.textContent=Oa,Rs=a(),U(we.$$.fragment),gs=a(),U(re.$$.fragment),As=a(),ue=p("p"),ue.textContent=La,Vs=a(),U(he.$$.fragment),_s=a(),de=p("p"),de.textContent=Pa,Ws=a(),U(fe.$$.fragment),Bs=a(),oe=p("p"),oe.textContent=Ka,Gs=a(),U(Ce.$$.fragment),Ys=a(),be=p("p"),be.textContent=ln,vs=a(),U($e.$$.fragment),Xs=a(),Ie=p("p"),Ie.textContent=en,Es=a(),U(ke.$$.fragment),Ns=a(),Ze=p("p"),Ze.textContent=tn,zs=a(),U(Qe.$$.fragment),Fs=a(),xe=p("p"),xe.textContent=sn,Hs=a(),Re=p("p"),Re.innerHTML=an,Ss=a(),ge=p("p"),ge.textContent=nn,qs=a(),Ve=p("p"),this.h()},l(l){const e=mn("svelte-u9bgzb",document.head);w=M(e,"META",{name:!0,content:!0}),e.forEach(t),o=n(l),r=M(l,"P",{}),Mn(r).forEach(t),Ae=n(l),i(C.$$.fragment,l),We=n(l),b=M(l,"P",{"data-svelte-h":!0}),T(b)!=="svelte-1mq8wfv"&&(b.textContent=Ls),Be=n(l),i($.$$.fragment,l),Ge=n(l),I=M(l,"P",{"data-svelte-h":!0}),T(I)!=="svelte-1e5vilx"&&(I.textContent=Ps),Ye=n(l),i(k.$$.fragment,l),ve=n(l),i(h.$$.fragment,l),Xe=n(l),Z=M(l,"P",{"data-svelte-h":!0}),T(Z)!=="svelte-f18nl2"&&(Z.textContent=Ks),Ee=n(l),i(Q.$$.fragment,l),Ne=n(l),x=M(l,"P",{"data-svelte-h":!0}),T(x)!=="svelte-j2pd5z"&&(x.textContent=la),ze=n(l),i(R.$$.fragment,l),Fe=n(l),i(g.$$.fragment,l),He=n(l),A=M(l,"P",{"data-svelte-h":!0}),T(A)!=="svelte-80f883"&&(A.innerHTML=ea),Se=n(l),V=M(l,"P",{"data-svelte-h":!0}),T(V)!=="svelte-1mt7w1y"&&(V.textContent=ta),qe=n(l),_=M(l,"P",{"data-svelte-h":!0}),T(_)!=="svelte-1ee133t"&&(_.textContent=sa),De=n(l),i(W.$$.fragment,l),Oe=n(l),B=M(l,"P",{"data-svelte-h":!0}),T(B)!=="svelte-1yevus4"&&(B.innerHTML=aa),Le=n(l),i(G.$$.fragment,l),Pe=n(l),Y=M(l,"P",{"data-svelte-h":!0}),T(Y)!=="svelte-14mygxn"&&(Y.textContent=na),Ke=n(l),i(v.$$.fragment,l),lt=n(l),i(X.$$.fragment,l),et=n(l),E=M(l,"P",{"data-svelte-h":!0}),T(E)!=="svelte-myc28k"&&(E.textContent=pa),tt=n(l),i(N.$$.fragment,l),st=n(l),i(z.$$.fragment,l),at=n(l),F=M(l,"P",{"data-svelte-h":!0}),T(F)!=="svelte-1k6p6xo"&&(F.textContent=Ma),nt=n(l),i(H.$$.fragment,l),pt=n(l),S=M(l,"P",{"data-svelte-h":!0}),T(S)!=="svelte-o1gog8"&&(S.textContent=Ta),Mt=n(l),i(q.$$.fragment,l),Tt=n(l),D=M(l,"P",{"data-svelte-h":!0}),T(D)!=="svelte-1yevus4"&&(D.innerHTML=Ua),Ut=n(l),i(O.$$.fragment,l),it=n(l),L=M(l,"P",{"data-svelte-h":!0}),T(L)!=="svelte-qqgwx7"&&(L.innerHTML=ia),yt=n(l),P=M(l,"P",{"data-svelte-h":!0}),T(P)!=="svelte-snkesy"&&(P.innerHTML=ya),Jt=n(l),K=M(l,"P",{"data-svelte-h":!0}),T(K)!=="svelte-zq9kvx"&&(K.innerHTML=Ja),jt=n(l),i(ll.$$.fragment,l),mt=n(l),el=M(l,"P",{"data-svelte-h":!0}),T(el)!=="svelte-1yggo6j"&&(el.textContent=ja),ct=n(l),i(tl.$$.fragment,l),wt=n(l),sl=M(l,"P",{"data-svelte-h":!0}),T(sl)!=="svelte-1yevus4"&&(sl.innerHTML=ma),rt=n(l),i(al.$$.fragment,l),ut=n(l),nl=M(l,"P",{"data-svelte-h":!0}),T(nl)!=="svelte-18q69cr"&&(nl.innerHTML=ca),ht=n(l),i(pl.$$.fragment,l),dt=n(l),Ml=M(l,"P",{"data-svelte-h":!0}),T(Ml)!=="svelte-t46ksf"&&(Ml.textContent=wa),ft=n(l),i(Tl.$$.fragment,l),ot=n(l),Ul=M(l,"P",{"data-svelte-h":!0}),T(Ul)!=="svelte-si6krf"&&(Ul.textContent=ra),Ct=n(l),i(il.$$.fragment,l),bt=n(l),yl=M(l,"P",{"data-svelte-h":!0}),T(yl)!=="svelte-1a4y7jc"&&(yl.textContent=ua),$t=n(l),i(Jl.$$.fragment,l),It=n(l),d=M(l,"DIV",{class:!0,"data-svelte-h":!0}),T(d)!=="svelte-1uufiik"&&(d.innerHTML=ha),kt=n(l),jl=M(l,"P",{"data-svelte-h":!0}),T(jl)!=="svelte-1n2xy9x"&&(jl.textContent=da),Zt=n(l),i(ml.$$.fragment,l),Qt=n(l),cl=M(l,"P",{"data-svelte-h":!0}),T(cl)!=="svelte-w4zc6g"&&(cl.textContent=fa),xt=n(l),i(wl.$$.fragment,l),Rt=n(l),rl=M(l,"P",{"data-svelte-h":!0}),T(rl)!=="svelte-1yevus4"&&(rl.innerHTML=oa),gt=n(l),i(ul.$$.fragment,l),At=n(l),hl=M(l,"P",{"data-svelte-h":!0}),T(hl)!=="svelte-3ki28v"&&(hl.textContent=Ca),Vt=n(l),i(dl.$$.fragment,l),_t=n(l),fl=M(l,"P",{"data-svelte-h":!0}),T(fl)!=="svelte-1yevus4"&&(fl.innerHTML=ba),Wt=n(l),i(ol.$$.fragment,l),Bt=n(l),Cl=M(l,"P",{"data-svelte-h":!0}),T(Cl)!=="svelte-1r0ckxv"&&(Cl.textContent=$a),Gt=n(l),bl=M(l,"P",{"data-svelte-h":!0}),T(bl)!=="svelte-115y9a6"&&(bl.textContent=Ia),Yt=n(l),i($l.$$.fragment,l),vt=n(l),Il=M(l,"P",{"data-svelte-h":!0}),T(Il)!=="svelte-1vb1v7p"&&(Il.innerHTML=ka),Xt=n(l),kl=M(l,"P",{"data-svelte-h":!0}),T(kl)!=="svelte-15d2tc9"&&(kl.innerHTML=Za),Et=n(l),i(Zl.$$.fragment,l),Nt=n(l),Ql=M(l,"P",{"data-svelte-h":!0}),T(Ql)!=="svelte-1ojzcke"&&(Ql.innerHTML=Qa),zt=n(l),xl=M(l,"P",{"data-svelte-h":!0}),T(xl)!=="svelte-vn616r"&&(xl.innerHTML=xa),Ft=n(l),i(Rl.$$.fragment,l),Ht=n(l),gl=M(l,"P",{"data-svelte-h":!0}),T(gl)!=="svelte-1blnag0"&&(gl.innerHTML=Ra),St=n(l),i(Al.$$.fragment,l),qt=n(l),Vl=M(l,"P",{"data-svelte-h":!0}),T(Vl)!=="svelte-1nl861s"&&(Vl.textContent=ga),Dt=n(l),i(_l.$$.fragment,l),Ot=n(l),Wl=M(l,"P",{"data-svelte-h":!0}),T(Wl)!=="svelte-1yevus4"&&(Wl.innerHTML=Aa),Lt=n(l),i(Bl.$$.fragment,l),Pt=n(l),Gl=M(l,"P",{"data-svelte-h":!0}),T(Gl)!=="svelte-crgj40"&&(Gl.textContent=Va),Kt=n(l),i(Yl.$$.fragment,l),ls=n(l),vl=M(l,"P",{"data-svelte-h":!0}),T(vl)!=="svelte-1yevus4"&&(vl.innerHTML=_a),es=n(l),i(Xl.$$.fragment,l),ts=n(l),El=M(l,"P",{"data-svelte-h":!0}),T(El)!=="svelte-g6mluh"&&(El.textContent=Wa),ss=n(l),i(Nl.$$.fragment,l),as=n(l),f=M(l,"DIV",{class:!0,"data-svelte-h":!0}),T(f)!=="svelte-j4o1b8"&&(f.innerHTML=Ba),ns=n(l),zl=M(l,"P",{"data-svelte-h":!0}),T(zl)!=="svelte-82ihiz"&&(zl.textContent=Ga),ps=n(l),Fl=M(l,"P",{"data-svelte-h":!0}),T(Fl)!=="svelte-61um8j"&&(Fl.textContent=Ya),Ms=n(l),i(Hl.$$.fragment,l),Ts=n(l),Sl=M(l,"P",{"data-svelte-h":!0}),T(Sl)!=="svelte-19pcez9"&&(Sl.textContent=va),Us=n(l),i(ql.$$.fragment,l),is=n(l),Dl=M(l,"P",{"data-svelte-h":!0}),T(Dl)!=="svelte-1yevus4"&&(Dl.innerHTML=Xa),ys=n(l),i(Ol.$$.fragment,l),Js=n(l),Ll=M(l,"P",{"data-svelte-h":!0}),T(Ll)!=="svelte-1aub7yi"&&(Ll.textContent=Ea),js=n(l),i(Pl.$$.fragment,l),ms=n(l),i(Kl.$$.fragment,l),cs=n(l),le=M(l,"P",{"data-svelte-h":!0}),T(le)!=="svelte-1ug6prq"&&(le.innerHTML=Na),ws=n(l),i(ee.$$.fragment,l),rs=n(l),te=M(l,"P",{"data-svelte-h":!0}),T(te)!=="svelte-n9sw30"&&(te.textContent=za),us=n(l),i(se.$$.fragment,l),hs=n(l),i(ae.$$.fragment,l),ds=n(l),ne=M(l,"P",{"data-svelte-h":!0}),T(ne)!=="svelte-kpt5ph"&&(ne.textContent=Fa),fs=n(l),i(pe.$$.fragment,l),os=n(l),Me=M(l,"P",{"data-svelte-h":!0}),T(Me)!=="svelte-7avbs0"&&(Me.innerHTML=Ha),Cs=n(l),i(Te.$$.fragment,l),bs=n(l),Ue=M(l,"P",{"data-svelte-h":!0}),T(Ue)!=="svelte-169ijvl"&&(Ue.textContent=Sa),$s=n(l),i(ie.$$.fragment,l),Is=n(l),ye=M(l,"P",{"data-svelte-h":!0}),T(ye)!=="svelte-hto4ro"&&(ye.innerHTML=qa),ks=n(l),i(Je.$$.fragment,l),Zs=n(l),je=M(l,"P",{"data-svelte-h":!0}),T(je)!=="svelte-4sfz1e"&&(je.innerHTML=Da),Qs=n(l),i(me.$$.fragment,l),xs=n(l),ce=M(l,"P",{"data-svelte-h":!0}),T(ce)!=="svelte-w4esym"&&(ce.textContent=Oa),Rs=n(l),i(we.$$.fragment,l),gs=n(l),i(re.$$.fragment,l),As=n(l),ue=M(l,"P",{"data-svelte-h":!0}),T(ue)!=="svelte-ou25m7"&&(ue.textContent=La),Vs=n(l),i(he.$$.fragment,l),_s=n(l),de=M(l,"P",{"data-svelte-h":!0}),T(de)!=="svelte-xms5tj"&&(de.textContent=Pa),Ws=n(l),i(fe.$$.fragment,l),Bs=n(l),oe=M(l,"P",{"data-svelte-h":!0}),T(oe)!=="svelte-4e57y3"&&(oe.textContent=Ka),Gs=n(l),i(Ce.$$.fragment,l),Ys=n(l),be=M(l,"P",{"data-svelte-h":!0}),T(be)!=="svelte-b1ybtn"&&(be.textContent=ln),vs=n(l),i($e.$$.fragment,l),Xs=n(l),Ie=M(l,"P",{"data-svelte-h":!0}),T(Ie)!=="svelte-m4c265"&&(Ie.textContent=en),Es=n(l),i(ke.$$.fragment,l),Ns=n(l),Ze=M(l,"P",{"data-svelte-h":!0}),T(Ze)!=="svelte-v08fsb"&&(Ze.textContent=tn),zs=n(l),i(Qe.$$.fragment,l),Fs=n(l),xe=M(l,"P",{"data-svelte-h":!0}),T(xe)!=="svelte-8y01aj"&&(xe.textContent=sn),Hs=n(l),Re=M(l,"P",{"data-svelte-h":!0}),T(Re)!=="svelte-185eq6j"&&(Re.innerHTML=an),Ss=n(l),ge=M(l,"P",{"data-svelte-h":!0}),T(ge)!=="svelte-g4ct72"&&(ge.textContent=nn),qs=n(l),Ve=M(l,"P",{}),Mn(Ve).forEach(t),this.h()},h(){Os(w,"name","hf:doc:metadata"),Os(w,"content",hn),Os(d,"class","flex justify-center"),Os(f,"class","flex justify-center")},m(l,e){cn(document.head,w),s(l,o,e),s(l,r,e),s(l,Ae,e),y(C,l,e),s(l,We,e),s(l,b,e),s(l,Be,e),y($,l,e),s(l,Ge,e),s(l,I,e),s(l,Ye,e),y(k,l,e),s(l,ve,e),y(h,l,e),s(l,Xe,e),s(l,Z,e),s(l,Ee,e),y(Q,l,e),s(l,Ne,e),s(l,x,e),s(l,ze,e),y(R,l,e),s(l,Fe,e),y(g,l,e),s(l,He,e),s(l,A,e),s(l,Se,e),s(l,V,e),s(l,qe,e),s(l,_,e),s(l,De,e),y(W,l,e),s(l,Oe,e),s(l,B,e),s(l,Le,e),y(G,l,e),s(l,Pe,e),s(l,Y,e),s(l,Ke,e),y(v,l,e),s(l,lt,e),y(X,l,e),s(l,et,e),s(l,E,e),s(l,tt,e),y(N,l,e),s(l,st,e),y(z,l,e),s(l,at,e),s(l,F,e),s(l,nt,e),y(H,l,e),s(l,pt,e),s(l,S,e),s(l,Mt,e),y(q,l,e),s(l,Tt,e),s(l,D,e),s(l,Ut,e),y(O,l,e),s(l,it,e),s(l,L,e),s(l,yt,e),s(l,P,e),s(l,Jt,e),s(l,K,e),s(l,jt,e),y(ll,l,e),s(l,mt,e),s(l,el,e),s(l,ct,e),y(tl,l,e),s(l,wt,e),s(l,sl,e),s(l,rt,e),y(al,l,e),s(l,ut,e),s(l,nl,e),s(l,ht,e),y(pl,l,e),s(l,dt,e),s(l,Ml,e),s(l,ft,e),y(Tl,l,e),s(l,ot,e),s(l,Ul,e),s(l,Ct,e),y(il,l,e),s(l,bt,e),s(l,yl,e),s(l,$t,e),y(Jl,l,e),s(l,It,e),s(l,d,e),s(l,kt,e),s(l,jl,e),s(l,Zt,e),y(ml,l,e),s(l,Qt,e),s(l,cl,e),s(l,xt,e),y(wl,l,e),s(l,Rt,e),s(l,rl,e),s(l,gt,e),y(ul,l,e),s(l,At,e),s(l,hl,e),s(l,Vt,e),y(dl,l,e),s(l,_t,e),s(l,fl,e),s(l,Wt,e),y(ol,l,e),s(l,Bt,e),s(l,Cl,e),s(l,Gt,e),s(l,bl,e),s(l,Yt,e),y($l,l,e),s(l,vt,e),s(l,Il,e),s(l,Xt,e),s(l,kl,e),s(l,Et,e),y(Zl,l,e),s(l,Nt,e),s(l,Ql,e),s(l,zt,e),s(l,xl,e),s(l,Ft,e),y(Rl,l,e),s(l,Ht,e),s(l,gl,e),s(l,St,e),y(Al,l,e),s(l,qt,e),s(l,Vl,e),s(l,Dt,e),y(_l,l,e),s(l,Ot,e),s(l,Wl,e),s(l,Lt,e),y(Bl,l,e),s(l,Pt,e),s(l,Gl,e),s(l,Kt,e),y(Yl,l,e),s(l,ls,e),s(l,vl,e),s(l,es,e),y(Xl,l,e),s(l,ts,e),s(l,El,e),s(l,ss,e),y(Nl,l,e),s(l,as,e),s(l,f,e),s(l,ns,e),s(l,zl,e),s(l,ps,e),s(l,Fl,e),s(l,Ms,e),y(Hl,l,e),s(l,Ts,e),s(l,Sl,e),s(l,Us,e),y(ql,l,e),s(l,is,e),s(l,Dl,e),s(l,ys,e),y(Ol,l,e),s(l,Js,e),s(l,Ll,e),s(l,js,e),y(Pl,l,e),s(l,ms,e),y(Kl,l,e),s(l,cs,e),s(l,le,e),s(l,ws,e),y(ee,l,e),s(l,rs,e),s(l,te,e),s(l,us,e),y(se,l,e),s(l,hs,e),y(ae,l,e),s(l,ds,e),s(l,ne,e),s(l,fs,e),y(pe,l,e),s(l,os,e),s(l,Me,e),s(l,Cs,e),y(Te,l,e),s(l,bs,e),s(l,Ue,e),s(l,$s,e),y(ie,l,e),s(l,Is,e),s(l,ye,e),s(l,ks,e),y(Je,l,e),s(l,Zs,e),s(l,je,e),s(l,Qs,e),y(me,l,e),s(l,xs,e),s(l,ce,e),s(l,Rs,e),y(we,l,e),s(l,gs,e),y(re,l,e),s(l,As,e),s(l,ue,e),s(l,Vs,e),y(he,l,e),s(l,_s,e),s(l,de,e),s(l,Ws,e),y(fe,l,e),s(l,Bs,e),s(l,oe,e),s(l,Gs,e),y(Ce,l,e),s(l,Ys,e),s(l,be,e),s(l,vs,e),y($e,l,e),s(l,Xs,e),s(l,Ie,e),s(l,Es,e),y(ke,l,e),s(l,Ns,e),s(l,Ze,e),s(l,zs,e),y(Qe,l,e),s(l,Fs,e),s(l,xe,e),s(l,Hs,e),s(l,Re,e),s(l,Ss,e),s(l,ge,e),s(l,qs,e),s(l,Ve,e),Ds=!0},p(l,[e]){const pn={};e&2&&(pn.$$scope={dirty:e,ctx:l}),h.$set(pn)},i(l){Ds||(J(C.$$.fragment,l),J($.$$.fragment,l),J(k.$$.fragment,l),J(h.$$.fragment,l),J(Q.$$.fragment,l),J(R.$$.fragment,l),J(g.$$.fragment,l),J(W.$$.fragment,l),J(G.$$.fragment,l),J(v.$$.fragment,l),J(X.$$.fragment,l),J(N.$$.fragment,l),J(z.$$.fragment,l),J(H.$$.fragment,l),J(q.$$.fragment,l),J(O.$$.fragment,l),J(ll.$$.fragment,l),J(tl.$$.fragment,l),J(al.$$.fragment,l),J(pl.$$.fragment,l),J(Tl.$$.fragment,l),J(il.$$.fragment,l),J(Jl.$$.fragment,l),J(ml.$$.fragment,l),J(wl.$$.fragment,l),J(ul.$$.fragment,l),J(dl.$$.fragment,l),J(ol.$$.fragment,l),J($l.$$.fragment,l),J(Zl.$$.fragment,l),J(Rl.$$.fragment,l),J(Al.$$.fragment,l),J(_l.$$.fragment,l),J(Bl.$$.fragment,l),J(Yl.$$.fragment,l),J(Xl.$$.fragment,l),J(Nl.$$.fragment,l),J(Hl.$$.fragment,l),J(ql.$$.fragment,l),J(Ol.$$.fragment,l),J(Pl.$$.fragment,l),J(Kl.$$.fragment,l),J(ee.$$.fragment,l),J(se.$$.fragment,l),J(ae.$$.fragment,l),J(pe.$$.fragment,l),J(Te.$$.fragment,l),J(ie.$$.fragment,l),J(Je.$$.fragment,l),J(me.$$.fragment,l),J(we.$$.fragment,l),J(re.$$.fragment,l),J(he.$$.fragment,l),J(fe.$$.fragment,l),J(Ce.$$.fragment,l),J($e.$$.fragment,l),J(ke.$$.fragment,l),J(Qe.$$.fragment,l),Ds=!0)},o(l){j(C.$$.fragment,l),j($.$$.fragment,l),j(k.$$.fragment,l),j(h.$$.fragment,l),j(Q.$$.fragment,l),j(R.$$.fragment,l),j(g.$$.fragment,l),j(W.$$.fragment,l),j(G.$$.fragment,l),j(v.$$.fragment,l),j(X.$$.fragment,l),j(N.$$.fragment,l),j(z.$$.fragment,l),j(H.$$.fragment,l),j(q.$$.fragment,l),j(O.$$.fragment,l),j(ll.$$.fragment,l),j(tl.$$.fragment,l),j(al.$$.fragment,l),j(pl.$$.fragment,l),j(Tl.$$.fragment,l),j(il.$$.fragment,l),j(Jl.$$.fragment,l),j(ml.$$.fragment,l),j(wl.$$.fragment,l),j(ul.$$.fragment,l),j(dl.$$.fragment,l),j(ol.$$.fragment,l),j($l.$$.fragment,l),j(Zl.$$.fragment,l),j(Rl.$$.fragment,l),j(Al.$$.fragment,l),j(_l.$$.fragment,l),j(Bl.$$.fragment,l),j(Yl.$$.fragment,l),j(Xl.$$.fragment,l),j(Nl.$$.fragment,l),j(Hl.$$.fragment,l),j(ql.$$.fragment,l),j(Ol.$$.fragment,l),j(Pl.$$.fragment,l),j(Kl.$$.fragment,l),j(ee.$$.fragment,l),j(se.$$.fragment,l),j(ae.$$.fragment,l),j(pe.$$.fragment,l),j(Te.$$.fragment,l),j(ie.$$.fragment,l),j(Je.$$.fragment,l),j(me.$$.fragment,l),j(we.$$.fragment,l),j(re.$$.fragment,l),j(he.$$.fragment,l),j(fe.$$.fragment,l),j(Ce.$$.fragment,l),j($e.$$.fragment,l),j(ke.$$.fragment,l),j(Qe.$$.fragment,l),Ds=!1},d(l){l&&(t(o),t(r),t(Ae),t(We),t(b),t(Be),t(Ge),t(I),t(Ye),t(ve),t(Xe),t(Z),t(Ee),t(Ne),t(x),t(ze),t(Fe),t(He),t(A),t(Se),t(V),t(qe),t(_),t(De),t(Oe),t(B),t(Le),t(Pe),t(Y),t(Ke),t(lt),t(et),t(E),t(tt),t(st),t(at),t(F),t(nt),t(pt),t(S),t(Mt),t(Tt),t(D),t(Ut),t(it),t(L),t(yt),t(P),t(Jt),t(K),t(jt),t(mt),t(el),t(ct),t(wt),t(sl),t(rt),t(ut),t(nl),t(ht),t(dt),t(Ml),t(ft),t(ot),t(Ul),t(Ct),t(bt),t(yl),t($t),t(It),t(d),t(kt),t(jl),t(Zt),t(Qt),t(cl),t(xt),t(Rt),t(rl),t(gt),t(At),t(hl),t(Vt),t(_t),t(fl),t(Wt),t(Bt),t(Cl),t(Gt),t(bl),t(Yt),t(vt),t(Il),t(Xt),t(kl),t(Et),t(Nt),t(Ql),t(zt),t(xl),t(Ft),t(Ht),t(gl),t(St),t(qt),t(Vl),t(Dt),t(Ot),t(Wl),t(Lt),t(Pt),t(Gl),t(Kt),t(ls),t(vl),t(es),t(ts),t(El),t(ss),t(as),t(f),t(ns),t(zl),t(ps),t(Fl),t(Ms),t(Ts),t(Sl),t(Us),t(is),t(Dl),t(ys),t(Js),t(Ll),t(js),t(ms),t(cs),t(le),t(ws),t(rs),t(te),t(us),t(hs),t(ds),t(ne),t(fs),t(os),t(Me),t(Cs),t(bs),t(Ue),t($s),t(Is),t(ye),t(ks),t(Zs),t(je),t(Qs),t(xs),t(ce),t(Rs),t(gs),t(As),t(ue),t(Vs),t(_s),t(de),t(Ws),t(Bs),t(oe),t(Gs),t(Ys),t(be),t(vs),t(Xs),t(Ie),t(Es),t(Ns),t(Ze),t(zs),t(Fs),t(xe),t(Hs),t(Re),t(Ss),t(ge),t(qs),t(Ve)),t(w),m(C,l),m($,l),m(k,l),m(h,l),m(Q,l),m(R,l),m(g,l),m(W,l),m(G,l),m(v,l),m(X,l),m(N,l),m(z,l),m(H,l),m(q,l),m(O,l),m(ll,l),m(tl,l),m(al,l),m(pl,l),m(Tl,l),m(il,l),m(Jl,l),m(ml,l),m(wl,l),m(ul,l),m(dl,l),m(ol,l),m($l,l),m(Zl,l),m(Rl,l),m(Al,l),m(_l,l),m(Bl,l),m(Yl,l),m(Xl,l),m(Nl,l),m(Hl,l),m(ql,l),m(Ol,l),m(Pl,l),m(Kl,l),m(ee,l),m(se,l),m(ae,l),m(pe,l),m(Te,l),m(ie,l),m(Je,l),m(me,l),m(we,l),m(re,l),m(he,l),m(fe,l),m(Ce,l),m($e,l),m(ke,l),m(Qe,l)}}}const hn='{"title":"微调 SpeechT5","local":"微调-speecht5","sections":[{"title":"基础准备","local":"基础准备","sections":[],"depth":2},{"title":"数据集","local":"数据集","sections":[],"depth":2},{"title":"数据预处理","local":"数据预处理","sections":[{"title":"为 SpeechT5 分词进行文本清理","local":"为-speecht5-分词进行文本清理","sections":[],"depth":3},{"title":"说话人","local":"说话人","sections":[],"depth":3},{"title":"说话人嵌入","local":"说话人嵌入","sections":[],"depth":3},{"title":"处理数据集","local":"处理数据集","sections":[],"depth":3},{"title":"数据整理器","local":"数据整理器","sections":[],"depth":3}],"depth":2},{"title":"训练模型","local":"训练模型","sections":[],"depth":2},{"title":"推理","local":"推理","sections":[],"depth":2}],"depth":1}';function dn(_e){return Un(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class In extends Jn{constructor(w){super(),jn(this,w,dn,un,Tn,{})}}export{In as component};
