import{s as Ae,n as He,o as ze}from"../chunks/scheduler.65852ee5.js";import{S as Qe,i as Ye,g as i,s as a,r as M,A as Fe,h as o,f as l,c as n,j as xe,u as r,x as p,k as de,y as Ee,a as s,v as J,d as w,t as d,w as m}from"../chunks/index.aa74147d.js";import{D as Se,C as u}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as wt,E as Le}from"../chunks/EditOnGithub.4eda6a96.js";function De(me){let c,ut,dt,ct,h,yt,U,Tt,f,ue='<em>Authored by: <a href="https://huggingface.co/davidberenstein1957" rel="nofollow">David Berenstein</a> and <a href="https://huggingface.co/sdiazlor" rel="nofollow">Sara Han Díaz</a></em>',ht,b,ce="Suggestions are a wonderful way to make things easier and faster for your annotation team. These preselected options will make the labeling process more efficient, as they will only need to correct the suggestions. In this example, we will demonstrate how to implement a zero-shot approach using SetFit to get some initial suggestions for a dataset in Argilla that combines two text classification tasks that include a <code>LabelQuestion</code> and a <code>MultiLabelQuestion</code>.",Ut,g,ye='<a href="https://github.com/argilla-io/argilla" rel="nofollow">Argilla</a> is a collaboration tool for AI engineers and domain experts who need to build high-quality datasets for their projects. Using Argilla, everyone can build robust language models through faster data curation using both human and machine feedback.',ft,I,Te="Feedback is a crucial part of the data curation process, and Argilla also provides a way to manage and visualize it so that the curated data can be later used to improve a language model. In this tutorial, we will show a real example of how to make our annotators’ job easier by providing them with suggestions. To achieve this, you will learn how to train zero-shot sentiment and topic classifiers using SetFit and then use them to suggest labels for the dataset.",bt,j,he="In this tutorial, we will follow these steps:",gt,C,Ue="<li>Create a dataset in Argilla.</li> <li>Train the zero-shot classifiers using SetFit.</li> <li>Get suggestions for the dataset using the trained classifiers.</li> <li>Visualize the suggestions in Argilla.</li>",It,$,fe="Let’s get started!",jt,Z,Ct,W,be='For this tutorial, you will need to have an Argilla server running. If you have already deployed Argilla, you can skip this step. Otherwise, you can quickly deploy Argilla in HF Spaces or locally following <a href="https://docs.argilla.io/latest/getting_started/quickstart/" rel="nofollow">this guide</a>. Once you do, complete the following steps:',$t,B,ge="<li>Install the Argilla client and the required third-party libraries using <code>pip</code>:</li>",Zt,k,Wt,y,Ie="<li>Make the necessary imports:</li>",Bt,G,kt,T,je="<li>If you are running Argilla using the Docker quickstart image or Hugging Face Spaces, you need to init the Argilla client with the <code>API_URL</code> and <code>API_KEY</code>:</li>",Gt,R,Rt,v,vt,X,Ce='In this example, we will load the <a href="https://huggingface.co/datasets/banking77" rel="nofollow">banking77</a> dataset, a popular open-source dataset that has customer requests in the banking domain.',Xt,V,Vt,N,$e='Argilla works with the <code>Dataset</code> class, which easily enables you to create a dataset and manage the data and feedback. The <code>Dataset</code> has first to be configured. In the <code>Settings</code>, we can specify the <em>guidelines</em>, <em>fields</em> where the data to be annotated will be added and the <em>questions</em> for the annotators. However, more features can be added. For more information, check the <a href="https://docs.argilla.io/latest/how_to_guides/dataset/" rel="nofollow">Argilla how-to guides</a>.',Nt,_,Ze="For our use case, we need a text field and two different questions. We will use the original labels of this dataset to make a multi-label classification of the topics mentioned in the request, and we will also set up a label question to classify the sentiment of the request as either “positive”, “neutral” or “negative”.",_t,q,qt,x,xt,A,We='Now, we will use the data we loaded from HF and the labels and questions we configured for our dataset to train a zero-shot text classification model for each of the questions in our dataset. As mentioned in previous sections, we will use the <a href="https://github.com/huggingface/setfit" rel="nofollow">SetFit</a> framework for few-shot fine-tuning of Sentence Transformers in both classifiers. In addition, the model we will use is <a href="https://huggingface.co/sentence-transformers/all-MiniLM-L6-v2" rel="nofollow">all-MiniLM-L6-v2</a>, a sentence embedding model fine-tuned on a 1B sentence pairs dataset using a contrastive objective.',At,H,Ht,z,zt,Q,Qt,Y,Yt,F,Be="Once the training step is over, we can make predictions over our data.",Ft,E,Et,S,St,L,Lt,D,Dt,K,ke="With the data and the predictions we have produced, we can now build records (each of the data items that will be annotated by the annotator team) that include the suggestions from our models. In the case of the <code>LabelQuestion</code> we will use the label that received the highest probability score and for the <code>MultiLabelQuestion</code> we will include all labels with a score above a certain threshold. In this case, we decided to go for <code>2/len(labels)</code>, but you can experiment with your data and decide to go for a more restrictive or more lenient threshold.",Kt,P,Ge="<p>Note that more lenient thresholds (closer or equal to <code>1/len(labels)</code>) will suggest more labels, and restrictive thresholds (between 2 and 3) will select fewer (or no) labels.</p>",Pt,O,Ot,tt,te,et,Re="Once we are happy with the result, we can log the records to the dataset that we configured above. You can now access the dataset in Argilla and visualize the suggestions.",ee,lt,le,st,ve="This is how the UI will look like with the suggestions from our models:",se,at,Xe='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/snapshot_setfit_suggestions.png" alt="Feedback Task dataset with suggestions made using SetFit"/>',ae,nt,Ve='Optionally, you can also save and load your Argilla dataset into the Hugging Face Hub. Refer to the <a href="https://docs.argilla.io/latest/how_to_guides/import_export/#hugging-face-hub" rel="nofollow">Argilla documentation</a> for more information on how to do this.',ne,it,ie,ot,oe,pt,Ne="In this tutorial, we have covered how to add suggestions to an Argilla dataset using a zero-shot approach with the SetFit library. This will help with the efficiency of the labelling process by lowering the number of decisions and edits that the annotation team must make.",pe,Mt,_e="Check out these links for more resources:",Me,rt,qe='<li><a href="https://docs.argilla.io/latest/" rel="nofollow">Argilla documentation</a></li> <li><a href="https://github.com/huggingface/setfit" rel="nofollow">SetFit repo on GitHub</a></li> <li><a href="https://huggingface.co/docs/setfit/index" rel="nofollow">SetFit documentation</a></li>',re,Jt,Je,mt,we;return h=new Se({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/labelling_feedback_setfit.ipynb"}]}}),U=new wt({props:{title:"Suggestions for Data Annotation with SetFit in Zero-shot Text Classification",local:"suggestions-for-data-annotation-with-setfit-in-zero-shot-text-classification",headingTag:"h1"}}),Z=new wt({props:{title:"Setup",local:"setup",headingTag:"h2"}}),k=new u({props:{code:"IXBpcCUyMGluc3RhbGwlMjBhcmdpbGxhJTBBIXBpcCUyMGluc3RhbGwlMjBzZXRmaXQlM0QlM0QxLjAuMyUyMHRyYW5zZm9ybWVycyUzRCUzRDQuNDAuMiUyMGh1Z2dpbmdmYWNlX2h1YiUzRCUzRDAuMjMuNQ==",highlighted:`!pip install argilla
!pip install setfit==<span class="hljs-number">1.0</span><span class="hljs-number">.3</span> transformers==<span class="hljs-number">4.40</span><span class="hljs-number">.2</span> huggingface_hub==<span class="hljs-number">0.23</span><span class="hljs-number">.5</span>`,wrap:!1}}),G=new u({props:{code:"aW1wb3J0JTIwYXJnaWxsYSUyMGFzJTIwcmclMEElMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFmcm9tJTIwc2V0Zml0JTIwaW1wb3J0JTIwU2V0Rml0TW9kZWwlMkMlMjBUcmFpbmVyJTJDJTIwZ2V0X3RlbXBsYXRlZF9kYXRhc2V0",highlighted:`<span class="hljs-keyword">import</span> argilla <span class="hljs-keyword">as</span> rg

<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel, Trainer, get_templated_dataset`,wrap:!1}}),R=new u({props:{code:"JTIzJTIwUmVwbGFjZSUyMGFwaV91cmwlMjB3aXRoJTIweW91ciUyMHVybCUyMGlmJTIwdXNpbmclMjBEb2NrZXIlMEElMjMlMjBSZXBsYWNlJTIwYXBpX2tleSUyMGlmJTIweW91JTIwY29uZmlndXJlZCUyMGElMjBjdXN0b20lMjBBUEklMjBrZXklMEElMjMlMjBVbmNvbW1lbnQlMjB0aGUlMjBsYXN0JTIwbGluZSUyMGFuZCUyMHNldCUyMHlvdXIlMjBIRl9UT0tFTiUyMGlmJTIweW91ciUyMHNwYWNlJTIwaXMlMjBwcml2YXRlJTBBY2xpZW50JTIwJTNEJTIwcmcuQXJnaWxsYSglMEElMjAlMjAlMjAlMjBhcGlfdXJsJTNEJTIyaHR0cHMlM0ElMkYlMkYlNUJ5b3VyLW93bmVyLW5hbWUlNUQtJTVCeW91cl9zcGFjZV9uYW1lJTVELmhmLnNwYWNlJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMiU1QnlvdXItYXBpLWtleSU1RCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMyUyMGhlYWRlcnMlM0QlN0IlMjJBdXRob3JpemF0aW9uJTIyJTNBJTIwZiUyMkJlYXJlciUyMCU3QkhGX1RPS0VOJTdEJTIyJTdEJTBBKQ==",highlighted:`<span class="hljs-comment"># Replace api_url with your url if using Docker</span>
<span class="hljs-comment"># Replace api_key if you configured a custom API key</span>
<span class="hljs-comment"># Uncomment the last line and set your HF_TOKEN if your space is private</span>
client = rg.Argilla(
    api_url=<span class="hljs-string">&quot;https://[your-owner-name]-[your_space_name].hf.space&quot;</span>,
    api_key=<span class="hljs-string">&quot;[your-api-key]&quot;</span>,
    <span class="hljs-comment"># headers={&quot;Authorization&quot;: f&quot;Bearer {HF_TOKEN}&quot;}</span>
)`,wrap:!1}}),v=new wt({props:{title:"Configure the dataset",local:"configure-the-dataset",headingTag:"h2"}}),V=new u({props:{code:"ZGF0YSUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJQb2x5QUklMkZiYW5raW5nNzclMjIlMkMlMjBzcGxpdCUzRCUyMnRlc3QlMjIp",highlighted:'data = load_dataset(<span class="hljs-string">&quot;PolyAI/banking77&quot;</span>, split=<span class="hljs-string">&quot;test&quot;</span>)',wrap:!1}}),q=new u({props:{code:"c2V0dGluZ3MlMjAlM0QlMjByZy5TZXR0aW5ncyglMEElMjAlMjAlMjAlMjBmaWVsZHMlM0QlNUJyZy5UZXh0RmllbGQobmFtZSUzRCUyMnRleHQlMjIpJTVEJTJDJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb25zJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmcuTXVsdGlMYWJlbFF1ZXN0aW9uKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5hbWUlM0QlMjJ0b3BpY3MlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCUyMlNlbGVjdCUyMHRoZSUyMHRvcGljKHMpJTIwb2YlMjB0aGUlMjByZXF1ZXN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFiZWxzJTNEZGF0YS5pbmZvLmZlYXR1cmVzJTVCJTIybGFiZWwlMjIlNUQubmFtZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2aXNpYmxlX2xhYmVscyUzRDEwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJnLkxhYmVsUXVlc3Rpb24oJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbmFtZSUzRCUyMnNlbnRpbWVudCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTIyV2hhdCUyMGlzJTIwdGhlJTIwc2VudGltZW50JTIwb2YlMjB0aGUlMjBtZXNzYWdlJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIycG9zaXRpdmUlMjIlMkMlMjAlMjJuZXV0cmFsJTIyJTJDJTIwJTIybmVnYXRpdmUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBKSUwQWRhdGFzZXQlMjAlM0QlMjByZy5EYXRhc2V0KCUwQSUyMCUyMCUyMCUyMG5hbWUlM0QlMjJzZXRmaXRfdHV0b3JpYWxfZGF0YXNldCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNldHRpbmdzJTNEc2V0dGluZ3MlMkMlMEEpJTBBZGF0YXNldC5jcmVhdGUoKQ==",highlighted:`settings = rg.Settings(
    fields=[rg.TextField(name=<span class="hljs-string">&quot;text&quot;</span>)],
    questions=[
        rg.MultiLabelQuestion(
            name=<span class="hljs-string">&quot;topics&quot;</span>,
            title=<span class="hljs-string">&quot;Select the topic(s) of the request&quot;</span>,
            labels=data.info.features[<span class="hljs-string">&quot;label&quot;</span>].names,
            visible_labels=<span class="hljs-number">10</span>,
        ),
        rg.LabelQuestion(
            name=<span class="hljs-string">&quot;sentiment&quot;</span>,
            title=<span class="hljs-string">&quot;What is the sentiment of the message?&quot;</span>,
            labels=[<span class="hljs-string">&quot;positive&quot;</span>, <span class="hljs-string">&quot;neutral&quot;</span>, <span class="hljs-string">&quot;negative&quot;</span>],
        ),
    ],
)
dataset = rg.Dataset(
    name=<span class="hljs-string">&quot;setfit_tutorial_dataset&quot;</span>,
    settings=settings,
)
dataset.create()`,wrap:!1}}),x=new wt({props:{title:"Train the models",local:"train-the-models",headingTag:"h2"}}),H=new u({props:{code:"ZGVmJTIwdHJhaW5fbW9kZWwocXVlc3Rpb25fbmFtZSUyQyUyMHRlbXBsYXRlJTJDJTIwbXVsdGlfbGFiZWwlM0RGYWxzZSklM0ElMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTIwJTNEJTIwZ2V0X3RlbXBsYXRlZF9kYXRhc2V0KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhbmRpZGF0ZV9sYWJlbHMlM0RkYXRhc2V0LnF1ZXN0aW9ucyU1QnF1ZXN0aW9uX25hbWUlNUQubGFiZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2FtcGxlX3NpemUlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGVtcGxhdGUlM0R0ZW1wbGF0ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG11bHRpX2xhYmVsJTNEbXVsdGlfbGFiZWwlMkMlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwVHJhaW4lMjBhJTIwbW9kZWwlMjB1c2luZyUyMHRoZSUyMHRyYWluaW5nJTIwZGF0YXNldCUyMHdlJTIwanVzdCUyMGJ1aWx0JTBBJTIwJTIwJTIwJTIwaWYlMjBtdWx0aV9sYWJlbCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTIwJTNEJTIwU2V0Rml0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNlbnRlbmNlLXRyYW5zZm9ybWVycyUyRmFsbC1NaW5pTE0tTDYtdjIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtdWx0aV90YXJnZXRfc3RyYXRlZ3klM0QlMjJvbmUtdnMtcmVzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwlMjAlM0QlMjBTZXRGaXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyc2VudGVuY2UtdHJhbnNmb3JtZXJzJTJGYWxsLU1pbmlMTS1MNi12MiUyMiklMEElMEElMjAlMjAlMjAlMjB0cmFpbmVyJTIwJTNEJTIwVHJhaW5lcihtb2RlbCUzRG1vZGVsJTJDJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQpJTBBJTIwJTIwJTIwJTIwdHJhaW5lci50cmFpbigpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbW9kZWw=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">train_model</span>(<span class="hljs-params">question_name, template, multi_label=<span class="hljs-literal">False</span></span>):
    train_dataset = get_templated_dataset(
        candidate_labels=dataset.questions[question_name].labels,
        sample_size=<span class="hljs-number">8</span>,
        template=template,
        multi_label=multi_label,
    )

    <span class="hljs-comment"># Train a model using the training dataset we just built</span>
    <span class="hljs-keyword">if</span> multi_label:
        model = SetFitModel.from_pretrained(
            <span class="hljs-string">&quot;sentence-transformers/all-MiniLM-L6-v2&quot;</span>,
            multi_target_strategy=<span class="hljs-string">&quot;one-vs-rest&quot;</span>,
        )
    <span class="hljs-keyword">else</span>:
        model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;sentence-transformers/all-MiniLM-L6-v2&quot;</span>)

    trainer = Trainer(model=model, train_dataset=train_dataset)
    trainer.train()

    <span class="hljs-keyword">return</span> model`,wrap:!1}}),z=new u({props:{code:"dG9waWNfbW9kZWwlMjAlM0QlMjB0cmFpbl9tb2RlbCglMEElMjAlMjAlMjAlMjBxdWVzdGlvbl9uYW1lJTNEJTIydG9waWNzJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGVtcGxhdGUlM0QlMjJUaGUlMjBjdXN0b21lciUyMHJlcXVlc3QlMjBpcyUyMGFib3V0JTIwJTdCJTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwbXVsdGlfbGFiZWwlM0RUcnVlJTJDJTBBKSUwQSUyMyUyMHRvcGljX21vZGVsLnNhdmVfcHJldHJhaW5lZCglMEElMjMlMjAlMjAlMjAlMjAlMjAlMjIlMkZwYXRoLXRvLXlvdXItbW9kZWxzLWZvbGRlciUyRnRvcGljX21vZGVsJTIyJTBBJTIzJTIwKQ==",highlighted:`topic_model = train_model(
    question_name=<span class="hljs-string">&quot;topics&quot;</span>,
    template=<span class="hljs-string">&quot;The customer request is about {}&quot;</span>,
    multi_label=<span class="hljs-literal">True</span>,
)
<span class="hljs-comment"># topic_model.save_pretrained(</span>
<span class="hljs-comment">#     &quot;/path-to-your-models-folder/topic_model&quot;</span>
<span class="hljs-comment"># )</span>`,wrap:!1}}),Q=new u({props:{code:"c2VudGltZW50X21vZGVsJTIwJTNEJTIwdHJhaW5fbW9kZWwocXVlc3Rpb25fbmFtZSUzRCUyMnNlbnRpbWVudCUyMiUyQyUyMHRlbXBsYXRlJTNEJTIyVGhpcyUyMG1lc3NhZ2UlMjBpcyUyMCU3QiU3RCUyMiUyQyUyMG11bHRpX2xhYmVsJTNERmFsc2UpJTBBJTIzJTIwdG9waWNfbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUwQSUyMyUyMCUyMCUyMCUyMCUyMCUyMiUyRnBhdGgtdG8teW91ci1tb2RlbHMtZm9sZGVyJTJGc2VudGltZW50X21vZGVsJTIyJTBBJTIzJTIwKQ==",highlighted:`sentiment_model = train_model(question_name=<span class="hljs-string">&quot;sentiment&quot;</span>, template=<span class="hljs-string">&quot;This message is {}&quot;</span>, multi_label=<span class="hljs-literal">False</span>)
<span class="hljs-comment"># topic_model.save_pretrained(</span>
<span class="hljs-comment">#     &quot;/path-to-your-models-folder/sentiment_model&quot;</span>
<span class="hljs-comment"># )</span>`,wrap:!1}}),Y=new wt({props:{title:"Make predictions",local:"make-predictions",headingTag:"h2"}}),E=new u({props:{code:"ZGVmJTIwZ2V0X3ByZWRpY3Rpb25zKHRleHRzJTJDJTIwbW9kZWwlMkMlMjBxdWVzdGlvbl9uYW1lKSUzQSUwQSUyMCUyMCUyMCUyMHByb2JhcyUyMCUzRCUyMG1vZGVsLnByZWRpY3RfcHJvYmEodGV4dHMlMkMlMjBhc19udW1weSUzRFRydWUpJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTIwJTNEJTIwZGF0YXNldC5xdWVzdGlvbnMlNUJxdWVzdGlvbl9uYW1lJTVELmxhYmVscyUwQSUyMCUyMCUyMCUyMGZvciUyMHByZWQlMjBpbiUyMHByb2JhcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHlpZWxkJTIwJTVCJTdCJTIybGFiZWwlMjIlM0ElMjBsYWJlbCUyQyUyMCUyMnNjb3JlJTIyJTNBJTIwc2NvcmUlN0QlMjBmb3IlMjBsYWJlbCUyQyUyMHNjb3JlJTIwaW4lMjB6aXAobGFiZWxzJTJDJTIwcHJlZCklNUQ=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_predictions</span>(<span class="hljs-params">texts, model, question_name</span>):
    probas = model.predict_proba(texts, as_numpy=<span class="hljs-literal">True</span>)
    labels = dataset.questions[question_name].labels
    <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> probas:
        <span class="hljs-keyword">yield</span> [{<span class="hljs-string">&quot;label&quot;</span>: label, <span class="hljs-string">&quot;score&quot;</span>: score} <span class="hljs-keyword">for</span> label, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(labels, pred)]`,wrap:!1}}),S=new u({props:{code:"ZGF0YSUyMCUzRCUyMGRhdGEubWFwKCUwQSUyMCUyMCUyMCUyMGxhbWJkYSUyMGJhdGNoJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydG9waWNzJTIyJTNBJTIwbGlzdChnZXRfcHJlZGljdGlvbnMoYmF0Y2glNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwdG9waWNfbW9kZWwlMkMlMjAlMjJ0b3BpY3MlMjIpKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNlbnRpbWVudCUyMiUzQSUyMGxpc3QoZ2V0X3ByZWRpY3Rpb25zKGJhdGNoJTVCJTIydGV4dCUyMiU1RCUyQyUyMHNlbnRpbWVudF9tb2RlbCUyQyUyMCUyMnNlbnRpbWVudCUyMikpJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hlZCUzRFRydWUlMkMlMEEp",highlighted:`data = data.<span class="hljs-built_in">map</span>(
    <span class="hljs-keyword">lambda</span> batch: {
        <span class="hljs-string">&quot;topics&quot;</span>: <span class="hljs-built_in">list</span>(get_predictions(batch[<span class="hljs-string">&quot;text&quot;</span>], topic_model, <span class="hljs-string">&quot;topics&quot;</span>)),
        <span class="hljs-string">&quot;sentiment&quot;</span>: <span class="hljs-built_in">list</span>(get_predictions(batch[<span class="hljs-string">&quot;text&quot;</span>], sentiment_model, <span class="hljs-string">&quot;sentiment&quot;</span>)),
    },
    batched=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),L=new u({props:{code:"ZGF0YS50b19wYW5kYXMoKS5oZWFkKCk=",highlighted:"data.to_pandas().head()",wrap:!1}}),D=new wt({props:{title:"Log the records to Argilla",local:"log-the-records-to-argilla",headingTag:"h2"}}),O=new u({props:{code:"ZGVmJTIwYWRkX3N1Z2dlc3Rpb25zKHJlY29yZCklM0ElMEElMjAlMjAlMjAlMjBzdWdnZXN0aW9ucyUyMCUzRCUyMCU1QiU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMEdldCUyMGxhYmVsJTIwd2l0aCUyMG1heCUyMHNjb3JlJTIwZm9yJTIwc2VudGltZW50JTIwcXVlc3Rpb24lMEElMjAlMjAlMjAlMjBzZW50aW1lbnQlMjAlM0QlMjBtYXgocmVjb3JkJTVCJTIyc2VudGltZW50JTIyJTVEJTJDJTIwa2V5JTNEbGFtYmRhJTIweCUzQSUyMHglNUIlMjJzY29yZSUyMiU1RCklNUIlMjJsYWJlbCUyMiU1RCUwQSUyMCUyMCUyMCUyMHN1Z2dlc3Rpb25zLmFwcGVuZChyZy5TdWdnZXN0aW9uKHF1ZXN0aW9uX25hbWUlM0QlMjJzZW50aW1lbnQlMjIlMkMlMjB2YWx1ZSUzRHNlbnRpbWVudCkpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwR2V0JTIwYWxsJTIwbGFiZWxzJTIwYWJvdmUlMjBhJTIwdGhyZXNob2xkJTIwZm9yJTIwdG9waWNzJTIwcXVlc3Rpb25zJTBBJTIwJTIwJTIwJTIwdGhyZXNob2xkJTIwJTNEJTIwMiUyMCUyRiUyMGxlbihkYXRhc2V0LnF1ZXN0aW9ucyU1QiUyMnRvcGljcyUyMiU1RC5sYWJlbHMpJTBBJTIwJTIwJTIwJTIwdG9waWNzJTIwJTNEJTIwJTVCbGFiZWwlNUIlMjJsYWJlbCUyMiU1RCUyMGZvciUyMGxhYmVsJTIwaW4lMjByZWNvcmQlNUIlMjJ0b3BpY3MlMjIlNUQlMjBpZiUyMGxhYmVsJTVCJTIyc2NvcmUlMjIlNUQlMjAlM0UlM0QlMjB0aHJlc2hvbGQlNUQlMEElMjAlMjAlMjAlMjBpZiUyMHRvcGljcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1Z2dlc3Rpb25zLmFwcGVuZChyZy5TdWdnZXN0aW9uKHF1ZXN0aW9uX25hbWUlM0QlMjJ0b3BpY3MlMjIlMkMlMjB2YWx1ZSUzRHRvcGljcykpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3VnZ2VzdGlvbnM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">add_suggestions</span>(<span class="hljs-params">record</span>):
    suggestions = []

    <span class="hljs-comment"># Get label with max score for sentiment question</span>
    sentiment = <span class="hljs-built_in">max</span>(record[<span class="hljs-string">&quot;sentiment&quot;</span>], key=<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-string">&quot;score&quot;</span>])[<span class="hljs-string">&quot;label&quot;</span>]
    suggestions.append(rg.Suggestion(question_name=<span class="hljs-string">&quot;sentiment&quot;</span>, value=sentiment))

    <span class="hljs-comment"># Get all labels above a threshold for topics questions</span>
    threshold = <span class="hljs-number">2</span> / <span class="hljs-built_in">len</span>(dataset.questions[<span class="hljs-string">&quot;topics&quot;</span>].labels)
    topics = [label[<span class="hljs-string">&quot;label&quot;</span>] <span class="hljs-keyword">for</span> label <span class="hljs-keyword">in</span> record[<span class="hljs-string">&quot;topics&quot;</span>] <span class="hljs-keyword">if</span> label[<span class="hljs-string">&quot;score&quot;</span>] &gt;= threshold]
    <span class="hljs-keyword">if</span> topics:
        suggestions.append(rg.Suggestion(question_name=<span class="hljs-string">&quot;topics&quot;</span>, value=topics))

    <span class="hljs-keyword">return</span> suggestions`,wrap:!1}}),tt=new u({props:{code:"cmVjb3JkcyUyMCUzRCUyMCU1QnJnLlJlY29yZChmaWVsZHMlM0QlN0IlMjJ0ZXh0JTIyJTNBJTIwcmVjb3JkJTVCJTIydGV4dCUyMiU1RCU3RCUyQyUyMHN1Z2dlc3Rpb25zJTNEYWRkX3N1Z2dlc3Rpb25zKHJlY29yZCkpJTIwZm9yJTIwcmVjb3JkJTIwaW4lMjBkYXRhJTVE",highlighted:'records = [rg.Record(fields={<span class="hljs-string">&quot;text&quot;</span>: record[<span class="hljs-string">&quot;text&quot;</span>]}, suggestions=add_suggestions(record)) <span class="hljs-keyword">for</span> record <span class="hljs-keyword">in</span> data]',wrap:!1}}),lt=new u({props:{code:"ZGF0YXNldC5yZWNvcmRzLmxvZyhyZWNvcmRzKQ==",highlighted:"dataset.records.log(records)",wrap:!1}}),it=new u({props:{code:"JTIzJTIwRXhwb3J0JTIwdG8lMjBIdWdnaW5nRmFjZSUyMEh1YiUwQWRhdGFzZXQudG9faHViKHJlcG9faWQlM0QlMjJhcmdpbGxhJTJGbXlfc2V0Zml0X2RhdGFzZXQlMjIpJTBBJTBBJTIzJTIwSW1wb3J0JTIwZnJvbSUyMEh1Z2dpbmdGYWNlJTIwSHViJTBBZGF0YXNldCUyMCUzRCUyMHJnLkRhdGFzZXQuZnJvbV9odWIocmVwb19pZCUzRCUyMmFyZ2lsbGElMkZteV9zZXRmaXRfZGF0YXNldCUyMik=",highlighted:`<span class="hljs-comment"># Export to HuggingFace Hub</span>
dataset.to_hub(repo_id=<span class="hljs-string">&quot;argilla/my_setfit_dataset&quot;</span>)

<span class="hljs-comment"># Import from HuggingFace Hub</span>
dataset = rg.Dataset.from_hub(repo_id=<span class="hljs-string">&quot;argilla/my_setfit_dataset&quot;</span>)`,wrap:!1}}),ot=new wt({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),Jt=new Le({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/labelling_feedback_setfit.md"}}),{c(){c=i("meta"),ut=a(),dt=i("p"),ct=a(),M(h.$$.fragment),yt=a(),M(U.$$.fragment),Tt=a(),f=i("p"),f.innerHTML=ue,ht=a(),b=i("p"),b.innerHTML=ce,Ut=a(),g=i("p"),g.innerHTML=ye,ft=a(),I=i("p"),I.textContent=Te,bt=a(),j=i("p"),j.textContent=he,gt=a(),C=i("ul"),C.innerHTML=Ue,It=a(),$=i("p"),$.textContent=fe,jt=a(),M(Z.$$.fragment),Ct=a(),W=i("p"),W.innerHTML=be,$t=a(),B=i("ol"),B.innerHTML=ge,Zt=a(),M(k.$$.fragment),Wt=a(),y=i("ol"),y.innerHTML=Ie,Bt=a(),M(G.$$.fragment),kt=a(),T=i("ol"),T.innerHTML=je,Gt=a(),M(R.$$.fragment),Rt=a(),M(v.$$.fragment),vt=a(),X=i("p"),X.innerHTML=Ce,Xt=a(),M(V.$$.fragment),Vt=a(),N=i("p"),N.innerHTML=$e,Nt=a(),_=i("p"),_.textContent=Ze,_t=a(),M(q.$$.fragment),qt=a(),M(x.$$.fragment),xt=a(),A=i("p"),A.innerHTML=We,At=a(),M(H.$$.fragment),Ht=a(),M(z.$$.fragment),zt=a(),M(Q.$$.fragment),Qt=a(),M(Y.$$.fragment),Yt=a(),F=i("p"),F.textContent=Be,Ft=a(),M(E.$$.fragment),Et=a(),M(S.$$.fragment),St=a(),M(L.$$.fragment),Lt=a(),M(D.$$.fragment),Dt=a(),K=i("p"),K.innerHTML=ke,Kt=a(),P=i("blockquote"),P.innerHTML=Ge,Pt=a(),M(O.$$.fragment),Ot=a(),M(tt.$$.fragment),te=a(),et=i("p"),et.textContent=Re,ee=a(),M(lt.$$.fragment),le=a(),st=i("p"),st.textContent=ve,se=a(),at=i("p"),at.innerHTML=Xe,ae=a(),nt=i("p"),nt.innerHTML=Ve,ne=a(),M(it.$$.fragment),ie=a(),M(ot.$$.fragment),oe=a(),pt=i("p"),pt.textContent=Ne,pe=a(),Mt=i("p"),Mt.textContent=_e,Me=a(),rt=i("ul"),rt.innerHTML=qe,re=a(),M(Jt.$$.fragment),Je=a(),mt=i("p"),this.h()},l(t){const e=Fe("svelte-u9bgzb",document.head);c=o(e,"META",{name:!0,content:!0}),e.forEach(l),ut=n(t),dt=o(t,"P",{}),xe(dt).forEach(l),ct=n(t),r(h.$$.fragment,t),yt=n(t),r(U.$$.fragment,t),Tt=n(t),f=o(t,"P",{"data-svelte-h":!0}),p(f)!=="svelte-gisfdz"&&(f.innerHTML=ue),ht=n(t),b=o(t,"P",{"data-svelte-h":!0}),p(b)!=="svelte-1dz42to"&&(b.innerHTML=ce),Ut=n(t),g=o(t,"P",{"data-svelte-h":!0}),p(g)!=="svelte-g9tqb5"&&(g.innerHTML=ye),ft=n(t),I=o(t,"P",{"data-svelte-h":!0}),p(I)!=="svelte-z3rep6"&&(I.textContent=Te),bt=n(t),j=o(t,"P",{"data-svelte-h":!0}),p(j)!=="svelte-r5bgoa"&&(j.textContent=he),gt=n(t),C=o(t,"UL",{"data-svelte-h":!0}),p(C)!=="svelte-16uywrv"&&(C.innerHTML=Ue),It=n(t),$=o(t,"P",{"data-svelte-h":!0}),p($)!=="svelte-4b3xjd"&&($.textContent=fe),jt=n(t),r(Z.$$.fragment,t),Ct=n(t),W=o(t,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1ti64gg"&&(W.innerHTML=be),$t=n(t),B=o(t,"OL",{"data-svelte-h":!0}),p(B)!=="svelte-1qu2uq8"&&(B.innerHTML=ge),Zt=n(t),r(k.$$.fragment,t),Wt=n(t),y=o(t,"OL",{start:!0,"data-svelte-h":!0}),p(y)!=="svelte-1y23822"&&(y.innerHTML=Ie),Bt=n(t),r(G.$$.fragment,t),kt=n(t),T=o(t,"OL",{start:!0,"data-svelte-h":!0}),p(T)!=="svelte-baz57d"&&(T.innerHTML=je),Gt=n(t),r(R.$$.fragment,t),Rt=n(t),r(v.$$.fragment,t),vt=n(t),X=o(t,"P",{"data-svelte-h":!0}),p(X)!=="svelte-vlotaw"&&(X.innerHTML=Ce),Xt=n(t),r(V.$$.fragment,t),Vt=n(t),N=o(t,"P",{"data-svelte-h":!0}),p(N)!=="svelte-15wrcuz"&&(N.innerHTML=$e),Nt=n(t),_=o(t,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1crpkkg"&&(_.textContent=Ze),_t=n(t),r(q.$$.fragment,t),qt=n(t),r(x.$$.fragment,t),xt=n(t),A=o(t,"P",{"data-svelte-h":!0}),p(A)!=="svelte-kekmap"&&(A.innerHTML=We),At=n(t),r(H.$$.fragment,t),Ht=n(t),r(z.$$.fragment,t),zt=n(t),r(Q.$$.fragment,t),Qt=n(t),r(Y.$$.fragment,t),Yt=n(t),F=o(t,"P",{"data-svelte-h":!0}),p(F)!=="svelte-16dkxgg"&&(F.textContent=Be),Ft=n(t),r(E.$$.fragment,t),Et=n(t),r(S.$$.fragment,t),St=n(t),r(L.$$.fragment,t),Lt=n(t),r(D.$$.fragment,t),Dt=n(t),K=o(t,"P",{"data-svelte-h":!0}),p(K)!=="svelte-drzh9e"&&(K.innerHTML=ke),Kt=n(t),P=o(t,"BLOCKQUOTE",{"data-svelte-h":!0}),p(P)!=="svelte-5ledw"&&(P.innerHTML=Ge),Pt=n(t),r(O.$$.fragment,t),Ot=n(t),r(tt.$$.fragment,t),te=n(t),et=o(t,"P",{"data-svelte-h":!0}),p(et)!=="svelte-1auljf2"&&(et.textContent=Re),ee=n(t),r(lt.$$.fragment,t),le=n(t),st=o(t,"P",{"data-svelte-h":!0}),p(st)!=="svelte-st0f7l"&&(st.textContent=ve),se=n(t),at=o(t,"P",{"data-svelte-h":!0}),p(at)!=="svelte-v1akw9"&&(at.innerHTML=Xe),ae=n(t),nt=o(t,"P",{"data-svelte-h":!0}),p(nt)!=="svelte-18ajnmf"&&(nt.innerHTML=Ve),ne=n(t),r(it.$$.fragment,t),ie=n(t),r(ot.$$.fragment,t),oe=n(t),pt=o(t,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-18majim"&&(pt.textContent=Ne),pe=n(t),Mt=o(t,"P",{"data-svelte-h":!0}),p(Mt)!=="svelte-1xmeilv"&&(Mt.textContent=_e),Me=n(t),rt=o(t,"UL",{"data-svelte-h":!0}),p(rt)!=="svelte-yirl8t"&&(rt.innerHTML=qe),re=n(t),r(Jt.$$.fragment,t),Je=n(t),mt=o(t,"P",{}),xe(mt).forEach(l),this.h()},h(){de(c,"name","hf:doc:metadata"),de(c,"content",Ke),de(y,"start","2"),de(T,"start","3")},m(t,e){Ee(document.head,c),s(t,ut,e),s(t,dt,e),s(t,ct,e),J(h,t,e),s(t,yt,e),J(U,t,e),s(t,Tt,e),s(t,f,e),s(t,ht,e),s(t,b,e),s(t,Ut,e),s(t,g,e),s(t,ft,e),s(t,I,e),s(t,bt,e),s(t,j,e),s(t,gt,e),s(t,C,e),s(t,It,e),s(t,$,e),s(t,jt,e),J(Z,t,e),s(t,Ct,e),s(t,W,e),s(t,$t,e),s(t,B,e),s(t,Zt,e),J(k,t,e),s(t,Wt,e),s(t,y,e),s(t,Bt,e),J(G,t,e),s(t,kt,e),s(t,T,e),s(t,Gt,e),J(R,t,e),s(t,Rt,e),J(v,t,e),s(t,vt,e),s(t,X,e),s(t,Xt,e),J(V,t,e),s(t,Vt,e),s(t,N,e),s(t,Nt,e),s(t,_,e),s(t,_t,e),J(q,t,e),s(t,qt,e),J(x,t,e),s(t,xt,e),s(t,A,e),s(t,At,e),J(H,t,e),s(t,Ht,e),J(z,t,e),s(t,zt,e),J(Q,t,e),s(t,Qt,e),J(Y,t,e),s(t,Yt,e),s(t,F,e),s(t,Ft,e),J(E,t,e),s(t,Et,e),J(S,t,e),s(t,St,e),J(L,t,e),s(t,Lt,e),J(D,t,e),s(t,Dt,e),s(t,K,e),s(t,Kt,e),s(t,P,e),s(t,Pt,e),J(O,t,e),s(t,Ot,e),J(tt,t,e),s(t,te,e),s(t,et,e),s(t,ee,e),J(lt,t,e),s(t,le,e),s(t,st,e),s(t,se,e),s(t,at,e),s(t,ae,e),s(t,nt,e),s(t,ne,e),J(it,t,e),s(t,ie,e),J(ot,t,e),s(t,oe,e),s(t,pt,e),s(t,pe,e),s(t,Mt,e),s(t,Me,e),s(t,rt,e),s(t,re,e),J(Jt,t,e),s(t,Je,e),s(t,mt,e),we=!0},p:He,i(t){we||(w(h.$$.fragment,t),w(U.$$.fragment,t),w(Z.$$.fragment,t),w(k.$$.fragment,t),w(G.$$.fragment,t),w(R.$$.fragment,t),w(v.$$.fragment,t),w(V.$$.fragment,t),w(q.$$.fragment,t),w(x.$$.fragment,t),w(H.$$.fragment,t),w(z.$$.fragment,t),w(Q.$$.fragment,t),w(Y.$$.fragment,t),w(E.$$.fragment,t),w(S.$$.fragment,t),w(L.$$.fragment,t),w(D.$$.fragment,t),w(O.$$.fragment,t),w(tt.$$.fragment,t),w(lt.$$.fragment,t),w(it.$$.fragment,t),w(ot.$$.fragment,t),w(Jt.$$.fragment,t),we=!0)},o(t){d(h.$$.fragment,t),d(U.$$.fragment,t),d(Z.$$.fragment,t),d(k.$$.fragment,t),d(G.$$.fragment,t),d(R.$$.fragment,t),d(v.$$.fragment,t),d(V.$$.fragment,t),d(q.$$.fragment,t),d(x.$$.fragment,t),d(H.$$.fragment,t),d(z.$$.fragment,t),d(Q.$$.fragment,t),d(Y.$$.fragment,t),d(E.$$.fragment,t),d(S.$$.fragment,t),d(L.$$.fragment,t),d(D.$$.fragment,t),d(O.$$.fragment,t),d(tt.$$.fragment,t),d(lt.$$.fragment,t),d(it.$$.fragment,t),d(ot.$$.fragment,t),d(Jt.$$.fragment,t),we=!1},d(t){t&&(l(ut),l(dt),l(ct),l(yt),l(Tt),l(f),l(ht),l(b),l(Ut),l(g),l(ft),l(I),l(bt),l(j),l(gt),l(C),l(It),l($),l(jt),l(Ct),l(W),l($t),l(B),l(Zt),l(Wt),l(y),l(Bt),l(kt),l(T),l(Gt),l(Rt),l(vt),l(X),l(Xt),l(Vt),l(N),l(Nt),l(_),l(_t),l(qt),l(xt),l(A),l(At),l(Ht),l(zt),l(Qt),l(Yt),l(F),l(Ft),l(Et),l(St),l(Lt),l(Dt),l(K),l(Kt),l(P),l(Pt),l(Ot),l(te),l(et),l(ee),l(le),l(st),l(se),l(at),l(ae),l(nt),l(ne),l(ie),l(oe),l(pt),l(pe),l(Mt),l(Me),l(rt),l(re),l(Je),l(mt)),l(c),m(h,t),m(U,t),m(Z,t),m(k,t),m(G,t),m(R,t),m(v,t),m(V,t),m(q,t),m(x,t),m(H,t),m(z,t),m(Q,t),m(Y,t),m(E,t),m(S,t),m(L,t),m(D,t),m(O,t),m(tt,t),m(lt,t),m(it,t),m(ot,t),m(Jt,t)}}}const Ke='{"title":"Suggestions for Data Annotation with SetFit in Zero-shot Text Classification","local":"suggestions-for-data-annotation-with-setfit-in-zero-shot-text-classification","sections":[{"title":"Setup","local":"setup","sections":[],"depth":2},{"title":"Configure the dataset","local":"configure-the-dataset","sections":[],"depth":2},{"title":"Train the models","local":"train-the-models","sections":[],"depth":2},{"title":"Make predictions","local":"make-predictions","sections":[],"depth":2},{"title":"Log the records to Argilla","local":"log-the-records-to-argilla","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function Pe(me){return ze(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sl extends Qe{constructor(c){super(),Ye(this,c,Pe,De,Ae,{})}}export{sl as component};
