import{s as dt,n as ht,o as jt}from"../chunks/scheduler.65852ee5.js";import{S as bt,i as gt,g as M,s,r as y,A as ft,h as i,f as l,c as a,j as mt,u as o,x as w,k as ut,y as vt,a as n,v as J,d as T,t as U,w as r}from"../chunks/index.aa74147d.js";import{D as Bt,C}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as Ye,E as kt}from"../chunks/EditOnGithub.4eda6a96.js";function At(qe){let p,se,le,ae,I,Me,c,ie,m,Fe='<em>Authored by: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',we,u,ze='<p>This tutorial is advanced. You should have notions from <a href="agents">this other cookbook</a> first!</p>',ye,d,Pe="In this notebook we will make a <strong>multi-agent web browser: an agentic system with several agents collaborating to solve problems using the web!</strong>",oe,h,De="It will be a simple hierarchy, using a <code>ManagedAgent</code> object to wrap the managed web search agent:",Je,j,Te,b,Ke="Let’s set up this system.",Ue,g,Oe='⚡️ Our agent will be powered by <a href="https://huggingface.co/meta-llama/Meta-Llama-3.1-70B-Instruct" rel="nofollow">meta-llama/Meta-Llama-3.1-70B-Instruct</a> using <code>HfApiEngine</code> class that uses HF’s Inference API: the Inference API allows to quickly and easily run any OS model.',re,f,et="Run the line below to install the required dependencies:",pe,v,Ce,B,tt='We will choose to have our model powered by <a href="https://huggingface.co/Qwen/Qwen2.5-72B-Instruct" rel="nofollow">Qwen/Qwen2.5-72B-Instruct</a> since it’s very powerful and available for free in the HF API.',Ie,k,ce,A,me,S,lt='For web browsing, we can already use our pre-existing <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/agents/search.py" rel="nofollow"><code>DuckDuckGoSearchTool</code></a> tool to provide a Google search equivalent.',ue,Z,nt=`But then we will also need to be able to peak into the page found by the <code>DuckDuckGoSearchTool</code>.
To do so, we could import the library’s built-in <code>VisitWebpageTool</code>, but we will build it again to see how it’s done.`,de,_,st="So let’s create our <code>VisitWebpageTool</code> tool from scratch using <code>markdownify</code>.",he,$,je,W,at="Ok, now let’s initialize and test our tool!",be,R,ge,Q,Mt=`Hugging Face \\- Wikipedia

[Jump to content](#bodyContent)

Main menu

Main menu
move to sidebar
hide

 Navigation
 

* [Main page](/wiki/Main_Page "Visit the main page [z]")
* [Contents](/wiki/Wikipedia:Contents "Guides to browsing Wikipedia")
* [Current events](/wiki/Portal:Current_events "Articles related to current events")
* [Random article](/wiki/Special:Random "Visit a randomly selected article [x]")
* [About Wikipedia](/wiki/Wikipedia:About "Learn about Wikipedia and how it works")
* [Co
`,fe,L,ve,G,it="Now that we have all the tools <code>search</code> and <code>visit_webpage</code>, we can use them to create the web agent.",Be,V,wt="Which configuration to choose for this agent?",ke,H,yt="<li>Web browsing is a single-timeline task that does not require parallel tool calls, so JSON tool calling works well for that. We thus choose a <code>ReactJsonAgent</code>.</li> <li>Also, since sometimes web search requires exploring many pages before finding the correct answer, we prefer to increase the number of <code>max_iterations</code> to 10.</li>",Ae,E,Se,X,ot="We then wrap this agent into a <code>ManagedAgent</code> that will make it callable by its manager agent.",Ze,x,_e,N,Jt="Finally we create a manager agent, and upon initialization we pass our managed agent to it in its <code>managed_agents</code> argument.",$e,Y,Tt="Since this agent is the one tasked with the planning and thinking, advanced reasoning will be beneficial, so a <code>ReactCodeAgent</code> will be the best choice.",We,q,Ut="Also, we want to ask a question that involves the current year: so let us add <code>additional_authorized_imports=[&quot;time&quot;, &quot;datetime&quot;]</code>",Re,F,Qe,z,rt="That’s all! Now let’s run our system! We select a question that requires some calculation and",Le,P,Ge,D,pt="Our agents managed to efficiently collaborate towards solving the task! ✅",Ve,K,Ct="💡 You can easily extend this to more agents: one does the code execution, one the web search, one handles file loadings…",He,O,It="🤔💭 One could even think of doing more complex, tree-like hierarchies, with one CEO agent handling multiple middle managers, each with several reports.",Ee,ee,ct="We could even add more intermediate layers of management, each with multiple daily meetings, lots of agile stuff with scrum masters, and each new component adds enough friction to ensure the tasks never get done… Ehm wait, no, let’s stick with our simple structure.",Xe,te,xe,ne,Ne;return I=new Bt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/multiagent_web_assistant.ipynb"}]}}),c=new Ye({props:{title:"Have several agents collaborate in a multi-agent hierarchy 🤖🤝🤖",local:"have-several-agents-collaborate-in-a-multi-agent-hierarchy-",headingTag:"h1"}}),j=new C({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTJCLS0tLS0tLS0tLS0tLS0tLSUyQiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyME1hbmFnZXIlMjBhZ2VudCUyMCUyMCU3QyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyQi0tLS0tLS0tLS0tLS0tLS0lMkIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBfX19fX19fX19fX19fX18lN0NfX19fX19fX19fX19fXyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUwQSUyMCUyMENvZGUlMjBpbnRlcnByZXRlciUyMCUyMCUyMCUyQi0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tJTJCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9vbCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1hbmFnZWQlMjBhZ2VudCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyQi0tLS0tLS0tLS0tLS0tLS0tLSUyQiUyMCUyMCUyMCUyMCUyMCUyMCU3QyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMFdlYiUyMFNlYXJjaCUyMGFnZW50JTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTJCLS0tLS0tLS0tLS0tLS0tLS0tJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwV2ViJTIwU2VhcmNoJTIwdG9vbCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFZpc2l0JTIwd2VicGFnZSUyMHRvb2wlMjAlN0MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMkItLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLSUyQg==",highlighted:`              +----------------+
              |<span class="hljs-string"> Manager agent  </span>|
              +----------------+
                       |<span class="hljs-string">
        _______________</span>|______________
       |<span class="hljs-string">                              </span>|
  Code interpreter   +--------------------------------+
       tool          |<span class="hljs-string">         Managed agent          </span>|
                     |<span class="hljs-string">      +------------------+      </span>|
                     |<span class="hljs-string">      </span>|<span class="hljs-string"> Web Search agent </span>|<span class="hljs-string">      </span>|
                     |<span class="hljs-string">      +------------------+      </span>|
                     |<span class="hljs-string">         </span>|<span class="hljs-string">            </span>|<span class="hljs-string">         </span>|
                     |<span class="hljs-string">  Web Search tool     </span>|<span class="hljs-string">         </span>|
                     |<span class="hljs-string">             Visit webpage tool </span>|
                     +--------------------------------+`,wrap:!1}}),v=new C({props:{code:"IXBpcCUyMGluc3RhbGwlMjBtYXJrZG93bmlmeSUyMGR1Y2tkdWNrZ28tc2VhcmNoJTIwJTIydHJhbnNmb3JtZXJzJTVCYWdlbnRzJTVEJTIyJTIwLS11cGdyYWRlJTIwLXE=",highlighted:'!pip install markdownify duckduckgo-search <span class="hljs-string">&quot;transformers[agents]&quot;</span> --upgrade -q',wrap:!1}}),k=new C({props:{code:"bW9kZWwlMjAlM0QlMjAlMjJRd2VuJTJGUXdlbjIuNS03MkItSW5zdHJ1Y3QlMjI=",highlighted:'model = <span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>',wrap:!1}}),A=new Ye({props:{title:"🔍 Create a web search tool",local:"-create-a-web-search-tool",headingTag:"h3"}}),$=new C({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> re
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> markdownify <span class="hljs-keyword">import</span> markdownify <span class="hljs-keyword">as</span> md
<span class="hljs-keyword">from</span> requests.exceptions <span class="hljs-keyword">import</span> RequestException
<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> tool


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">visit_webpage</span>(<span class="hljs-params">url: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Visits a webpage at the given URL and returns its content as a markdown string.

    Args:
        url: The URL of the webpage to visit.

    Returns:
        The content of the webpage converted to Markdown, or an error message if the request fails.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Send a GET request to the URL</span>
        response = requests.get(url)
        response.raise_for_status()  <span class="hljs-comment"># Raise an exception for bad status codes</span>

        <span class="hljs-comment"># Convert the HTML content to Markdown</span>
        markdown_content = md(response.text).strip()

        <span class="hljs-comment"># Remove multiple line breaks</span>
        markdown_content = re.sub(<span class="hljs-string">r&quot;\\n{3,}&quot;</span>, <span class="hljs-string">&quot;\\n\\n&quot;</span>, markdown_content)

        <span class="hljs-keyword">return</span> markdown_content

    <span class="hljs-keyword">except</span> RequestException <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching the webpage: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;An unexpected error occurred: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>`,wrap:!1}}),R=new C({props:{code:"cHJpbnQodmlzaXRfd2VicGFnZSglMjJodHRwcyUzQSUyRiUyRmVuLndpa2lwZWRpYS5vcmclMkZ3aWtpJTJGSHVnZ2luZ19GYWNlJTIyKSU1QiUzQTUwMCU1RCk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(visit_webpage(<span class="hljs-string">&quot;https://en.wikipedia.org/wiki/Hugging_Face&quot;</span>)[:<span class="hljs-number">500</span>])',wrap:!1}}),L=new Ye({props:{title:"Build our multi-agent system 🤖🤝🤖",local:"build-our-multi-agent-system-",headingTag:"h2"}}),E=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwUmVhY3RDb2RlQWdlbnQlMkMlMEElMjAlMjAlMjAlMjBSZWFjdEpzb25BZ2VudCUyQyUwQSUyMCUyMCUyMCUyMEhmQXBpRW5naW5lJTJDJTBBJTIwJTIwJTIwJTIwTWFuYWdlZEFnZW50JTJDJTBBKSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMuYWdlbnRzLnNlYXJjaCUyMGltcG9ydCUyMER1Y2tEdWNrR29TZWFyY2hUb29sJTBBJTBBbGxtX2VuZ2luZSUyMCUzRCUyMEhmQXBpRW5naW5lKG1vZGVsKSUwQSUwQXdlYl9hZ2VudCUyMCUzRCUyMFJlYWN0SnNvbkFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCRHVja0R1Y2tHb1NlYXJjaFRvb2woKSUyQyUyMHZpc2l0X3dlYnBhZ2UlNUQlMkMlMEElMjAlMjAlMjAlMjBsbG1fZW5naW5lJTNEbGxtX2VuZ2luZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9pdGVyYXRpb25zJTNEMTAlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> (
    ReactCodeAgent,
    ReactJsonAgent,
    HfApiEngine,
    ManagedAgent,
)
<span class="hljs-keyword">from</span> transformers.agents.search <span class="hljs-keyword">import</span> DuckDuckGoSearchTool

llm_engine = HfApiEngine(model)

web_agent = ReactJsonAgent(
    tools=[DuckDuckGoSearchTool(), visit_webpage],
    llm_engine=llm_engine,
    max_iterations=<span class="hljs-number">10</span>,
)`,wrap:!1}}),x=new C({props:{code:"bWFuYWdlZF93ZWJfYWdlbnQlMjAlM0QlMjBNYW5hZ2VkQWdlbnQoJTBBJTIwJTIwJTIwJTIwYWdlbnQlM0R3ZWJfYWdlbnQlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyc2VhcmNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJSdW5zJTIwd2ViJTIwc2VhcmNoZXMlMjBmb3IlMjB5b3UuJTIwR2l2ZSUyMGl0JTIweW91ciUyMHF1ZXJ5JTIwYXMlMjBhbiUyMGFyZ3VtZW50LiUyMiUyQyUwQSk=",highlighted:`managed_web_agent = ManagedAgent(
    agent=web_agent,
    name=<span class="hljs-string">&quot;search&quot;</span>,
    description=<span class="hljs-string">&quot;Runs web searches for you. Give it your query as an argument.&quot;</span>,
)`,wrap:!1}}),F=new C({props:{code:"bWFuYWdlcl9hZ2VudCUyMCUzRCUyMFJlYWN0Q29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCJTVEJTJDJTBBJTIwJTIwJTIwJTIwbGxtX2VuZ2luZSUzRGxsbV9lbmdpbmUlMkMlMEElMjAlMjAlMjAlMjBtYW5hZ2VkX2FnZW50cyUzRCU1Qm1hbmFnZWRfd2ViX2FnZW50JTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRkaXRpb25hbF9hdXRob3JpemVkX2ltcG9ydHMlM0QlNUIlMjJ0aW1lJTIyJTJDJTIwJTIyZGF0ZXRpbWUlMjIlNUQlMkMlMEEp",highlighted:`manager_agent = ReactCodeAgent(
    tools=[],
    llm_engine=llm_engine,
    managed_agents=[managed_web_agent],
    additional_authorized_imports=[<span class="hljs-string">&quot;time&quot;</span>, <span class="hljs-string">&quot;datetime&quot;</span>],
)`,wrap:!1}}),P=new C({props:{code:"bWFuYWdlcl9hZ2VudC5ydW4oJTIySG93JTIwbWFueSUyMHllYXJzJTIwYWdvJTIwd2FzJTIwU3RyaXBlJTIwZm91bmRlZCUzRiUyMik=",highlighted:'manager_agent.run(<span class="hljs-string">&quot;How many years ago was Stripe founded?&quot;</span>)',wrap:!1}}),te=new kt({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/multiagent_web_assistant.md"}}),{c(){p=M("meta"),se=s(),le=M("p"),ae=s(),y(I.$$.fragment),Me=s(),y(c.$$.fragment),ie=s(),m=M("p"),m.innerHTML=Fe,we=s(),u=M("blockquote"),u.innerHTML=ze,ye=s(),d=M("p"),d.innerHTML=Pe,oe=s(),h=M("p"),h.innerHTML=De,Je=s(),y(j.$$.fragment),Te=s(),b=M("p"),b.textContent=Ke,Ue=s(),g=M("p"),g.innerHTML=Oe,re=s(),f=M("p"),f.textContent=et,pe=s(),y(v.$$.fragment),Ce=s(),B=M("p"),B.innerHTML=tt,Ie=s(),y(k.$$.fragment),ce=s(),y(A.$$.fragment),me=s(),S=M("p"),S.innerHTML=lt,ue=s(),Z=M("p"),Z.innerHTML=nt,de=s(),_=M("p"),_.innerHTML=st,he=s(),y($.$$.fragment),je=s(),W=M("p"),W.textContent=at,be=s(),y(R.$$.fragment),ge=s(),Q=M("pre"),Q.textContent=Mt,fe=s(),y(L.$$.fragment),ve=s(),G=M("p"),G.innerHTML=it,Be=s(),V=M("p"),V.textContent=wt,ke=s(),H=M("ul"),H.innerHTML=yt,Ae=s(),y(E.$$.fragment),Se=s(),X=M("p"),X.innerHTML=ot,Ze=s(),y(x.$$.fragment),_e=s(),N=M("p"),N.innerHTML=Jt,$e=s(),Y=M("p"),Y.innerHTML=Tt,We=s(),q=M("p"),q.innerHTML=Ut,Re=s(),y(F.$$.fragment),Qe=s(),z=M("p"),z.textContent=rt,Le=s(),y(P.$$.fragment),Ge=s(),D=M("p"),D.textContent=pt,Ve=s(),K=M("p"),K.textContent=Ct,He=s(),O=M("p"),O.textContent=It,Ee=s(),ee=M("p"),ee.textContent=ct,Xe=s(),y(te.$$.fragment),xe=s(),ne=M("p"),this.h()},l(e){const t=ft("svelte-u9bgzb",document.head);p=i(t,"META",{name:!0,content:!0}),t.forEach(l),se=a(e),le=i(e,"P",{}),mt(le).forEach(l),ae=a(e),o(I.$$.fragment,e),Me=a(e),o(c.$$.fragment,e),ie=a(e),m=i(e,"P",{"data-svelte-h":!0}),w(m)!=="svelte-1xlqnsv"&&(m.innerHTML=Fe),we=a(e),u=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),w(u)!=="svelte-uy67xy"&&(u.innerHTML=ze),ye=a(e),d=i(e,"P",{"data-svelte-h":!0}),w(d)!=="svelte-45abwn"&&(d.innerHTML=Pe),oe=a(e),h=i(e,"P",{"data-svelte-h":!0}),w(h)!=="svelte-1se9mth"&&(h.innerHTML=De),Je=a(e),o(j.$$.fragment,e),Te=a(e),b=i(e,"P",{"data-svelte-h":!0}),w(b)!=="svelte-1occiln"&&(b.textContent=Ke),Ue=a(e),g=i(e,"P",{"data-svelte-h":!0}),w(g)!=="svelte-uvprla"&&(g.innerHTML=Oe),re=a(e),f=i(e,"P",{"data-svelte-h":!0}),w(f)!=="svelte-ofrdjq"&&(f.textContent=et),pe=a(e),o(v.$$.fragment,e),Ce=a(e),B=i(e,"P",{"data-svelte-h":!0}),w(B)!=="svelte-1dwdmwr"&&(B.innerHTML=tt),Ie=a(e),o(k.$$.fragment,e),ce=a(e),o(A.$$.fragment,e),me=a(e),S=i(e,"P",{"data-svelte-h":!0}),w(S)!=="svelte-1ya2chk"&&(S.innerHTML=lt),ue=a(e),Z=i(e,"P",{"data-svelte-h":!0}),w(Z)!=="svelte-n7spa8"&&(Z.innerHTML=nt),de=a(e),_=i(e,"P",{"data-svelte-h":!0}),w(_)!=="svelte-1ms2uj2"&&(_.innerHTML=st),he=a(e),o($.$$.fragment,e),je=a(e),W=i(e,"P",{"data-svelte-h":!0}),w(W)!=="svelte-hbvg5t"&&(W.textContent=at),be=a(e),o(R.$$.fragment,e),ge=a(e),Q=i(e,"PRE",{"data-svelte-h":!0}),w(Q)!=="svelte-1dfvpav"&&(Q.textContent=Mt),fe=a(e),o(L.$$.fragment,e),ve=a(e),G=i(e,"P",{"data-svelte-h":!0}),w(G)!=="svelte-5768lo"&&(G.innerHTML=it),Be=a(e),V=i(e,"P",{"data-svelte-h":!0}),w(V)!=="svelte-noa5rw"&&(V.textContent=wt),ke=a(e),H=i(e,"UL",{"data-svelte-h":!0}),w(H)!=="svelte-4uouvt"&&(H.innerHTML=yt),Ae=a(e),o(E.$$.fragment,e),Se=a(e),X=i(e,"P",{"data-svelte-h":!0}),w(X)!=="svelte-1by3x3d"&&(X.innerHTML=ot),Ze=a(e),o(x.$$.fragment,e),_e=a(e),N=i(e,"P",{"data-svelte-h":!0}),w(N)!=="svelte-12kldg5"&&(N.innerHTML=Jt),$e=a(e),Y=i(e,"P",{"data-svelte-h":!0}),w(Y)!=="svelte-julrcm"&&(Y.innerHTML=Tt),We=a(e),q=i(e,"P",{"data-svelte-h":!0}),w(q)!=="svelte-hvhtn0"&&(q.innerHTML=Ut),Re=a(e),o(F.$$.fragment,e),Qe=a(e),z=i(e,"P",{"data-svelte-h":!0}),w(z)!=="svelte-1gu46sl"&&(z.textContent=rt),Le=a(e),o(P.$$.fragment,e),Ge=a(e),D=i(e,"P",{"data-svelte-h":!0}),w(D)!=="svelte-ollz3q"&&(D.textContent=pt),Ve=a(e),K=i(e,"P",{"data-svelte-h":!0}),w(K)!=="svelte-1v517hq"&&(K.textContent=Ct),He=a(e),O=i(e,"P",{"data-svelte-h":!0}),w(O)!=="svelte-58qi1z"&&(O.textContent=It),Ee=a(e),ee=i(e,"P",{"data-svelte-h":!0}),w(ee)!=="svelte-9myor3"&&(ee.textContent=ct),Xe=a(e),o(te.$$.fragment,e),xe=a(e),ne=i(e,"P",{}),mt(ne).forEach(l),this.h()},h(){ut(p,"name","hf:doc:metadata"),ut(p,"content",St)},m(e,t){vt(document.head,p),n(e,se,t),n(e,le,t),n(e,ae,t),J(I,e,t),n(e,Me,t),J(c,e,t),n(e,ie,t),n(e,m,t),n(e,we,t),n(e,u,t),n(e,ye,t),n(e,d,t),n(e,oe,t),n(e,h,t),n(e,Je,t),J(j,e,t),n(e,Te,t),n(e,b,t),n(e,Ue,t),n(e,g,t),n(e,re,t),n(e,f,t),n(e,pe,t),J(v,e,t),n(e,Ce,t),n(e,B,t),n(e,Ie,t),J(k,e,t),n(e,ce,t),J(A,e,t),n(e,me,t),n(e,S,t),n(e,ue,t),n(e,Z,t),n(e,de,t),n(e,_,t),n(e,he,t),J($,e,t),n(e,je,t),n(e,W,t),n(e,be,t),J(R,e,t),n(e,ge,t),n(e,Q,t),n(e,fe,t),J(L,e,t),n(e,ve,t),n(e,G,t),n(e,Be,t),n(e,V,t),n(e,ke,t),n(e,H,t),n(e,Ae,t),J(E,e,t),n(e,Se,t),n(e,X,t),n(e,Ze,t),J(x,e,t),n(e,_e,t),n(e,N,t),n(e,$e,t),n(e,Y,t),n(e,We,t),n(e,q,t),n(e,Re,t),J(F,e,t),n(e,Qe,t),n(e,z,t),n(e,Le,t),J(P,e,t),n(e,Ge,t),n(e,D,t),n(e,Ve,t),n(e,K,t),n(e,He,t),n(e,O,t),n(e,Ee,t),n(e,ee,t),n(e,Xe,t),J(te,e,t),n(e,xe,t),n(e,ne,t),Ne=!0},p:ht,i(e){Ne||(T(I.$$.fragment,e),T(c.$$.fragment,e),T(j.$$.fragment,e),T(v.$$.fragment,e),T(k.$$.fragment,e),T(A.$$.fragment,e),T($.$$.fragment,e),T(R.$$.fragment,e),T(L.$$.fragment,e),T(E.$$.fragment,e),T(x.$$.fragment,e),T(F.$$.fragment,e),T(P.$$.fragment,e),T(te.$$.fragment,e),Ne=!0)},o(e){U(I.$$.fragment,e),U(c.$$.fragment,e),U(j.$$.fragment,e),U(v.$$.fragment,e),U(k.$$.fragment,e),U(A.$$.fragment,e),U($.$$.fragment,e),U(R.$$.fragment,e),U(L.$$.fragment,e),U(E.$$.fragment,e),U(x.$$.fragment,e),U(F.$$.fragment,e),U(P.$$.fragment,e),U(te.$$.fragment,e),Ne=!1},d(e){e&&(l(se),l(le),l(ae),l(Me),l(ie),l(m),l(we),l(u),l(ye),l(d),l(oe),l(h),l(Je),l(Te),l(b),l(Ue),l(g),l(re),l(f),l(pe),l(Ce),l(B),l(Ie),l(ce),l(me),l(S),l(ue),l(Z),l(de),l(_),l(he),l(je),l(W),l(be),l(ge),l(Q),l(fe),l(ve),l(G),l(Be),l(V),l(ke),l(H),l(Ae),l(Se),l(X),l(Ze),l(_e),l(N),l($e),l(Y),l(We),l(q),l(Re),l(Qe),l(z),l(Le),l(Ge),l(D),l(Ve),l(K),l(He),l(O),l(Ee),l(ee),l(Xe),l(xe),l(ne)),l(p),r(I,e),r(c,e),r(j,e),r(v,e),r(k,e),r(A,e),r($,e),r(R,e),r(L,e),r(E,e),r(x,e),r(F,e),r(P,e),r(te,e)}}}const St='{"title":"Have several agents collaborate in a multi-agent hierarchy 🤖🤝🤖","local":"have-several-agents-collaborate-in-a-multi-agent-hierarchy-","sections":[{"title":"🔍 Create a web search tool","local":"-create-a-web-search-tool","sections":[],"depth":3},{"title":"Build our multi-agent system 🤖🤝🤖","local":"build-our-multi-agent-system-","sections":[],"depth":2}],"depth":1}';function Zt(qe){return jt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qt extends bt{constructor(p){super(),gt(this,p,Zt,At,dt,{})}}export{Qt as component};
