import{s as Yn,o as zn,n as dn}from"../chunks/scheduler.6062bdaf.js";import{S as Rn,i as Nn,g as p,s as a,r,A as Sn,h as c,f as t,c as i,j as Vn,u as g,x as o,k as Xn,y as Pn,a as s,v as f,d as u,t as d,w as h}from"../chunks/index.4bca734e.js";import{H as b,g as An}from"../chunks/Heading.949e2f88.js";import{T as un}from"../chunks/Tip.b9ac1f03.js";import{C as j}from"../chunks/CodeBlock.fa01571c.js";function Fn($){let l,_='In this section, we will see methods like <a href="/docs/huggingface_hub/v0.19.2/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.pause">pause()</a>, <a href="/docs/huggingface_hub/v0.19.2/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.resume">resume()</a>, <a href="/docs/huggingface_hub/v0.19.2/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.scale_to_zero">scale_to_zero()</a>, <a href="/docs/huggingface_hub/v0.19.2/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.update">update()</a> and <a href="/docs/huggingface_hub/v0.19.2/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.delete">delete()</a>. All of those methods are aliases added to <a href="/docs/huggingface_hub/v0.19.2/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> for convenience. If you prefer, you can also use the generic methods defined in <code>HfApi</code>: <a href="/docs/huggingface_hub/v0.19.2/en/package_reference/hf_api#huggingface_hub.HfApi.pause_inference_endpoint">pause_inference_endpoint()</a>, <a href="/docs/huggingface_hub/v0.19.2/en/package_reference/hf_api#huggingface_hub.HfApi.resume_inference_endpoint">resume_inference_endpoint()</a>, <a href="/docs/huggingface_hub/v0.19.2/en/package_reference/hf_api#huggingface_hub.HfApi.scale_to_zero_inference_endpoint">scale_to_zero_inference_endpoint()</a>, <a href="/docs/huggingface_hub/v0.19.2/en/package_reference/hf_api#huggingface_hub.HfApi.update_inference_endpoint">update_inference_endpoint()</a>, and <a href="/docs/huggingface_hub/v0.19.2/en/package_reference/hf_api#huggingface_hub.HfApi.delete_inference_endpoint">delete_inference_endpoint()</a>.';return{c(){l=p("p"),l.innerHTML=_},l(m){l=c(m,"P",{"data-svelte-h":!0}),o(l)!=="svelte-1aoei81"&&(l.innerHTML=_)},m(m,y){s(m,l,y)},p:dn,d(m){m&&t(l)}}}function Kn($){let l,_='An Inference Endpoint that is <em>paused</em> or <em>scaled to zero</em> doesn’t cost anything. The difference between those two is that a <em>paused</em> endpoint needs to be explicitly <em>resumed</em> using <a href="/docs/huggingface_hub/v0.19.2/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.resume">resume()</a>. On the contrary, a <em>scaled to zero</em> endpoint will automatically start if an inference call is made to it, with an additional cold start delay. An Inference Endpoint can also be configured to scale to zero automatically after a certain period of inactivity.';return{c(){l=p("p"),l.innerHTML=_},l(m){l=c(m,"P",{"data-svelte-h":!0}),o(l)!=="svelte-lxs2me"&&(l.innerHTML=_)},m(m,y){s(m,l,y)},p:dn,d(m){m&&t(l)}}}function Dn($){let l,_="This is a non-revertible action that will completely remove the endpoint, including its configuration, logs and usage metrics. You cannot restore a deleted Inference Endpoint.";return{c(){l=p("p"),l.textContent=_},l(m){l=c(m,"P",{"data-svelte-h":!0}),o(l)!=="svelte-lscf4f"&&(l.textContent=_)},m(m,y){s(m,l,y)},p:dn,d(m){m&&t(l)}}}function On($){let l,_,m,y,I,_e,v,hn=`Inference Endpoints provides a secure production solution to easily deploy any <code>transformers</code>, <code>sentence-transformers</code>, and <code>diffusers</code> models on a dedicated and autoscaling infrastructure managed by Hugging Face. An Inference Endpoint is built from a model from the <a href="https://huggingface.co/models" rel="nofollow">Hub</a>.
In this guide, we will learn how to programmatically manage Inference Endpoints with <code>huggingface_hub</code>. For more information about the Inference Endpoints product itself, check out its <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">official documentation</a>.`,je,k,mn='This guide assumes <code>huggingface_hub</code> is correctly installed and that your machine is logged in. Check out the <a href="https://huggingface.co/docs/huggingface_hub/quick-start#quickstart" rel="nofollow">Quick Start guide</a> if that’s not the case yet. The minimal version supporting Inference Endpoints API is <code>v0.19.0</code>.',ye,T,be,E,_n='The first step is to create an Inference Endpoint using <a href="/docs/huggingface_hub/v0.19.2/en/package_reference/hf_api#huggingface_hub.HfApi.create_inference_endpoint">create_inference_endpoint()</a>:',$e,W,we,U,jn='In this example, we created a <code>protected</code> Inference Endpoint named <code>&quot;my-endpoint-name&quot;</code>, to serve <a href="https://huggingface.co/gpt2" rel="nofollow">gpt2</a> for <code>text-generation</code>. A <code>protected</code> Inference Endpoint means your token is required to access the API. We also need to provide additional information to configure the hardware requirements, such as vendor, region, accelerator, instance type, and size. You can check out the list of available resources <a href="https://api.endpoints.huggingface.cloud/#/v2%3A%3Aprovider/list_vendors" rel="nofollow">here</a>. Alternatively, you can create an Inference Endpoint manually using the <a href="https://ui.endpoints.huggingface.co/new" rel="nofollow">Web interface</a> for convenience. Refer to this <a href="https://huggingface.co/docs/inference-endpoints/guides/advanced" rel="nofollow">guide</a> for details on advanced settings and their usage.',xe,C,yn='The value returned by <a href="/docs/huggingface_hub/v0.19.2/en/package_reference/hf_api#huggingface_hub.HfApi.create_inference_endpoint">create_inference_endpoint()</a> is an <a href="/docs/huggingface_hub/v0.19.2/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> object:',Me,J,Ie,Z,bn="It’s a dataclass that holds information about the endpoint. You can access important attributes such as <code>name</code>, <code>repository</code>, <code>status</code>, <code>task</code>, <code>created_at</code>, <code>updated_at</code>, etc. If you need it, you can also access the raw response from the server with <code>endpoint.raw</code>.",ve,H,$n='Once your Inference Endpoint is created, you can find it on your <a href="https://ui.endpoints.huggingface.co/" rel="nofollow">personal dashboard</a>.',ke,q,wn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/huggingface_hub/inference_endpoints_created.png"/>',Te,B,Ee,Q,xn='In some cases, you might need to manage Inference Endpoints you created previously. If you know the name, you can fetch it using <a href="/docs/huggingface_hub/v0.19.2/en/package_reference/hf_api#huggingface_hub.HfApi.get_inference_endpoint">get_inference_endpoint()</a>, which returns an <a href="/docs/huggingface_hub/v0.19.2/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> object. Alternatively, you can use <a href="/docs/huggingface_hub/v0.19.2/en/package_reference/hf_api#huggingface_hub.HfApi.list_inference_endpoints">list_inference_endpoints()</a> to retrieve a list of all Inference Endpoints. Both methods accept an optional <code>namespace</code> parameter. You can set the <code>namespace</code> to any organization you are a part of. Otherwise, it defaults to your username.',We,L,Ue,G,Ce,V,Mn='In the rest of this guide, we will assume that we have a <a href="/docs/huggingface_hub/v0.19.2/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> object called <code>endpoint</code>. You might have noticed that the endpoint has a <code>status</code> attribute of type <a href="/docs/huggingface_hub/v0.19.2/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointStatus">InferenceEndpointStatus</a>. When the Inference Endpoint is deployed and accessible, the status should be <code>&quot;running&quot;</code> and the <code>url</code> attribute is set:',Je,X,Ze,Y,In='Before reaching a <code>&quot;running&quot;</code> state, the Inference Endpoint typically goes through an <code>&quot;initializing&quot;</code> or <code>&quot;pending&quot;</code> phase. You can fetch the new state of the endpoint by running <a href="/docs/huggingface_hub/v0.19.2/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.fetch">fetch()</a>. Like every other method from <a href="/docs/huggingface_hub/v0.19.2/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> that makes a request to the server, the internal attributes of <code>endpoint</code> are mutated in place:',He,z,qe,R,vn='Instead of fetching the Inference Endpoint status while waiting for it to run, you can directly call <a href="/docs/huggingface_hub/v0.19.2/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.wait">wait()</a>. This helper takes as input a <code>timeout</code> and a <code>fetch_every</code> parameter (in seconds) and will block the thread until the Inference Endpoint is deployed. Default values are respectively <code>None</code> (no timeout) and <code>5</code> seconds.',Be,N,Qe,S,kn="If <code>timeout</code> is set and the Inference Endpoint takes too much time to load, a <code>InferenceEndpointTimeoutError</code> timeout error is raised.",Le,P,Ge,A,Tn="Once your Inference Endpoint is up and running, you can finally run inference on it!",Ve,F,En='<a href="/docs/huggingface_hub/v0.19.2/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> has two properties <code>client</code> and <code>async_client</code> returning respectively an <a href="/docs/huggingface_hub/v0.19.2/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> and an <a href="/docs/huggingface_hub/v0.19.2/en/package_reference/inference_client#huggingface_hub.AsyncInferenceClient">AsyncInferenceClient</a> objects.',Xe,K,Ye,D,Wn='If the Inference Endpoint is not running, an <a href="/docs/huggingface_hub/v0.19.2/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError">InferenceEndpointError</a> exception is raised:',ze,O,Re,ee,Un='For more details about how to use the <a href="/docs/huggingface_hub/v0.19.2/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>, check out the <a href="../guides/inference">Inference guide</a>.',Ne,ne,Se,te,Cn="Now that we saw how to create an Inference Endpoint and run inference on it, let’s see how to manage its lifecycle.",Pe,w,Ae,se,Fe,ae,Jn='To reduce costs when your Inference Endpoint is not in use, you can choose to either pause it using <a href="/docs/huggingface_hub/v0.19.2/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.pause">pause()</a> or scale it to zero using <a href="/docs/huggingface_hub/v0.19.2/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.scale_to_zero">scale_to_zero()</a>.',Ke,x,De,ie,Oe,le,en,pe,Zn='In some cases, you might also want to update your Inference Endpoint without creating a new one. You can either update the hosted model or the hardware requirements to run the model. You can do this using <a href="/docs/huggingface_hub/v0.19.2/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.update">update()</a>:',nn,ce,tn,oe,sn,re,Hn="Finally if you won’t use the Inference Endpoint anymore, you can simply call <code>~InferenceEndpoint.delete()</code>.",an,M,ln,ge,pn,fe,qn="A typical use case of Inference Endpoints is to process a batch of jobs at once to limit the infrastructure costs. You can automate this process using what we saw in this guide:",cn,ue,on,de,Bn="Or if your Inference Endpoint already exists and is paused:",rn,he,gn,me,fn;return I=new b({props:{title:"Inference Endpoints",local:"inference-endpoints",headingTag:"h1"}}),T=new b({props:{title:"Create an Inference Endpoint",local:"create-an-inference-endpoint",headingTag:"h2"}}),W=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQlMEElMEFlbmRwb2ludCUyMCUzRCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwJTIybXktZW5kcG9pbnQtbmFtZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9zaXRvcnklM0QlMjJncHQyJTIyJTJDJTBBJTIwJTIwJTIwJTIwZnJhbWV3b3JrJTNEJTIycHl0b3JjaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvciUzRCUyMmNwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMHZlbmRvciUzRCUyMmF3cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlZ2lvbiUzRCUyMnVzLWVhc3QtMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHR5cGUlM0QlMjJwcm90ZWN0ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV9zaXplJTNEJTIybWVkaXVtJTIyJTJDJTBBJTIwJTIwJTIwJTIwaW5zdGFuY2VfdHlwZSUzRCUyMmM2aSUyMiUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_inference_endpoint

<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = create_inference_endpoint(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;my-endpoint-name&quot;</span>,
<span class="hljs-meta">... </span>    repository=<span class="hljs-string">&quot;gpt2&quot;</span>,
<span class="hljs-meta">... </span>    framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
<span class="hljs-meta">... </span>    accelerator=<span class="hljs-string">&quot;cpu&quot;</span>,
<span class="hljs-meta">... </span>    vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>    region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    instance_size=<span class="hljs-string">&quot;medium&quot;</span>,
<span class="hljs-meta">... </span>    instance_type=<span class="hljs-string">&quot;c6i&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),J=new j({props:{code:"ZW5kcG9pbnQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)`,wrap:!1}}),B=new b({props:{title:"Get or list existing Inference Endpoints",local:"get-or-list-existing-inference-endpoints",headingTag:"h3"}}),L=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9pbmZlcmVuY2VfZW5kcG9pbnQlMkMlMjBsaXN0X2luZmVyZW5jZV9lbmRwb2ludHMlMEElMEFnZXRfaW5mZXJlbmNlX2VuZHBvaW50KCUyMm15LWVuZHBvaW50LW5hbWUlMjIpJTBBJTBBbGlzdF9pbmZlcmVuY2VfZW5kcG9pbnRzKG5hbWVzcGFjZSUzRCUyMmh1Z2dpbmdmYWNlJTIyKSUwQSUwQWxpc3RfaW5mZXJlbmNlX2VuZHBvaW50cyhuYW1lc3BhY2UlM0QlMjIqJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_inference_endpoint, list_inference_endpoints

<span class="hljs-comment"># Get one</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>get_inference_endpoint(<span class="hljs-string">&quot;my-endpoint-name&quot;</span>)
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)

<span class="hljs-comment"># List all endpoints from an organization</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>list_inference_endpoints(namespace=<span class="hljs-string">&quot;huggingface&quot;</span>)
[InferenceEndpoint(name=<span class="hljs-string">&#x27;aws-starchat-beta&#x27;</span>, namespace=<span class="hljs-string">&#x27;huggingface&#x27;</span>, repository=<span class="hljs-string">&#x27;HuggingFaceH4/starchat-beta&#x27;</span>, status=<span class="hljs-string">&#x27;paused&#x27;</span>, url=<span class="hljs-literal">None</span>), ...]

<span class="hljs-comment"># List all endpoints from all organizations the user belongs to</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>list_inference_endpoints(namespace=<span class="hljs-string">&quot;*&quot;</span>)
[InferenceEndpoint(name=<span class="hljs-string">&#x27;aws-starchat-beta&#x27;</span>, namespace=<span class="hljs-string">&#x27;huggingface&#x27;</span>, repository=<span class="hljs-string">&#x27;HuggingFaceH4/starchat-beta&#x27;</span>, status=<span class="hljs-string">&#x27;paused&#x27;</span>, url=<span class="hljs-literal">None</span>), ...]`,wrap:!1}}),G=new b({props:{title:"Check deployment status",local:"check-deployment-status",headingTag:"h2"}}),X=new j({props:{code:"ZW5kcG9pbnQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;running&#x27;</span>, url=<span class="hljs-string">&#x27;https://jpj7k2q4j805b727.us-east-1.aws.endpoints.huggingface.cloud&#x27;</span>)`,wrap:!1}}),z=new j({props:{code:"ZW5kcG9pbnQuZmV0Y2goKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.fetch()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)`,wrap:!1}}),N=new j({props:{code:"ZW5kcG9pbnQlMEElMEFlbmRwb2ludC53YWl0KHRpbWVvdXQlM0QxMCklMEElMEFlbmRwb2ludC53YWl0KCk=",highlighted:`<span class="hljs-comment"># Pending endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)

<span class="hljs-comment"># Wait 10s =&gt; raises a InferenceEndpointTimeoutError</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait(timeout=<span class="hljs-number">10</span>)
    <span class="hljs-keyword">raise</span> InferenceEndpointTimeoutError(<span class="hljs-string">&quot;Timeout while waiting for Inference Endpoint to be deployed.&quot;</span>)
huggingface_hub._inference_endpoints.InferenceEndpointTimeoutError: Timeout <span class="hljs-keyword">while</span> waiting <span class="hljs-keyword">for</span> Inference Endpoint to be deployed.

<span class="hljs-comment"># Wait more</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;running&#x27;</span>, url=<span class="hljs-string">&#x27;https://jpj7k2q4j805b727.us-east-1.aws.endpoints.huggingface.cloud&#x27;</span>)`,wrap:!1}}),P=new b({props:{title:"Run inference",local:"run-inference",headingTag:"h2"}}),K=new j({props:{code:"ZW5kcG9pbnQuY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMjJJJTIwYW0lMjIpJTBBJTBBYXdhaXQlMjBlbmRwb2ludC5hc3luY19jbGllbnQudGV4dF9nZW5lcmF0aW9uKCUyMkklMjBhbSUyMik=",highlighted:`<span class="hljs-comment"># Run text_generation task:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client.text_generation(<span class="hljs-string">&quot;I am&quot;</span>)
<span class="hljs-string">&#x27; not a fan of the idea of a &quot;big-budget&quot; movie. I think it\\&#x27;s a&#x27;</span>

<span class="hljs-comment"># Or in an asyncio context:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> endpoint.async_client.text_generation(<span class="hljs-string">&quot;I am&quot;</span>)`,wrap:!1}}),O=new j({props:{code:"ZW5kcG9pbnQuY2xpZW50",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client\nhuggingface_hub._inference_endpoints.InferenceEndpointError: Cannot create a client <span class="hljs-keyword">for</span> this Inference Endpoint <span class="hljs-keyword">as</span> it <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> yet deployed. Please wait <span class="hljs-keyword">for</span> the Inference Endpoint to be deployed using `endpoint.wait()` <span class="hljs-keyword">and</span> <span class="hljs-keyword">try</span> again.',wrap:!1}}),ne=new b({props:{title:"Manage lifecycle",local:"manage-lifecycle",headingTag:"h2"}}),w=new un({props:{$$slots:{default:[Fn]},$$scope:{ctx:$}}}),se=new b({props:{title:"Pause or scale to zero",local:"pause-or-scale-to-zero",headingTag:"h3"}}),x=new un({props:{$$slots:{default:[Kn]},$$scope:{ctx:$}}}),ie=new j({props:{code:"ZW5kcG9pbnQucGF1c2UoKSUwQWVuZHBvaW50LnJlc3VtZSgpJTBBZW5kcG9pbnQud2FpdCgpLmNsaWVudC50ZXh0X2dlbmVyYXRpb24oLi4uKSUwQSUwQWVuZHBvaW50LnNjYWxlX3RvX3plcm8oKQ==",highlighted:`<span class="hljs-comment"># Pause and resume endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.pause()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;paused&#x27;</span>, url=<span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.resume()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait().client.text_generation(...)
...

<span class="hljs-comment"># Scale to zero</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.scale_to_zero()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;scaledToZero&#x27;</span>, url=<span class="hljs-string">&#x27;https://jpj7k2q4j805b727.us-east-1.aws.endpoints.huggingface.cloud&#x27;</span>)
<span class="hljs-comment"># Endpoint is not &#x27;running&#x27; but still has a URL and will restart on first call.</span>`,wrap:!1}}),le=new b({props:{title:"Update model or hardware requirements",local:"update-model-or-hardware-requirements",headingTag:"h3"}}),ce=new j({props:{code:"ZW5kcG9pbnQudXBkYXRlKHJlcG9zaXRvcnklM0QlMjJncHQyLWxhcmdlJTIyKSUwQSUwQWVuZHBvaW50LnVwZGF0ZShtaW5fcmVwbGljYSUzRDIlMkMlMjBtYXhfcmVwbGljYSUzRDYpJTBBJTBBZW5kcG9pbnQudXBkYXRlKGFjY2VsZXJhdG9yJTNEJTIyY3B1JTIyJTJDJTIwaW5zdGFuY2Vfc2l6ZSUzRCUyMmxhcmdlJTIyJTJDJTIwaW5zdGFuY2VfdHlwZSUzRCUyMmM2aSUyMik=",highlighted:`<span class="hljs-comment"># Change target model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.update(repository=<span class="hljs-string">&quot;gpt2-large&quot;</span>)
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2-large&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)

<span class="hljs-comment"># Update number of replicas</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.update(min_replica=<span class="hljs-number">2</span>, max_replica=<span class="hljs-number">6</span>)
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2-large&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)

<span class="hljs-comment"># Update to larger instance</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.update(accelerator=<span class="hljs-string">&quot;cpu&quot;</span>, instance_size=<span class="hljs-string">&quot;large&quot;</span>, instance_type=<span class="hljs-string">&quot;c6i&quot;</span>)
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2-large&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)`,wrap:!1}}),oe=new b({props:{title:"Delete the endpoint",local:"delete-the-endpoint",headingTag:"h3"}}),M=new un({props:{warning:!0,$$slots:{default:[Dn]},$$scope:{ctx:$}}}),ge=new b({props:{title:"An end-to-end example",local:"an-end-to-end-example",headingTag:"h2"}}),ue=new j({props:{code:"aW1wb3J0JTIwYXN5bmNpbyUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBjcmVhdGVfaW5mZXJlbmNlX2VuZHBvaW50JTBBJTBBZW5kcG9pbnQlMjAlM0QlMjBjcmVhdGVfaW5mZXJlbmNlX2VuZHBvaW50KG5hbWUlM0QlMjJiYXRjaC1lbmRwb2ludCUyMiUyQy4uLikud2FpdCgpJTBBJTBBY2xpZW50JTIwJTNEJTIwZW5kcG9pbnQuY2xpZW50JTBBcmVzdWx0cyUyMCUzRCUyMCU1QmNsaWVudC50ZXh0X2dlbmVyYXRpb24oLi4uKSUyMGZvciUyMGpvYiUyMGluJTIwam9icyU1RCUwQSUwQWFzeW5jX2NsaWVudCUyMCUzRCUyMGVuZHBvaW50LmFzeW5jX2NsaWVudCUwQXJlc3VsdHMlMjAlM0QlMjBhc3luY2lvLmdhdGhlcigqJTVCYXN5bmNfY2xpZW50LnRleHRfZ2VuZXJhdGlvbiguLi4pJTIwZm9yJTIwam9iJTIwaW4lMjBqb2JzJTVEKSUwQSUwQWVuZHBvaW50LnBhdXNlKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> asyncio
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_inference_endpoint

<span class="hljs-comment"># Start endpoint + wait until initialized</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = create_inference_endpoint(name=<span class="hljs-string">&quot;batch-endpoint&quot;</span>,...).wait()

<span class="hljs-comment"># Run inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = endpoint.client
<span class="hljs-meta">&gt;&gt;&gt; </span>results = [client.text_generation(...) <span class="hljs-keyword">for</span> job <span class="hljs-keyword">in</span> jobs]

<span class="hljs-comment"># Or with asyncio</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>async_client = endpoint.async_client
<span class="hljs-meta">&gt;&gt;&gt; </span>results = asyncio.gather(*[async_client.text_generation(...) <span class="hljs-keyword">for</span> job <span class="hljs-keyword">in</span> jobs])

<span class="hljs-comment"># Pause endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.pause()`,wrap:!1}}),he=new j({props:{code:"aW1wb3J0JTIwYXN5bmNpbyUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBnZXRfaW5mZXJlbmNlX2VuZHBvaW50JTBBJTBBZW5kcG9pbnQlMjAlM0QlMjBnZXRfaW5mZXJlbmNlX2VuZHBvaW50KCUyMmJhdGNoLWVuZHBvaW50JTIyKS5yZXN1bWUoKS53YWl0KCklMEElMEFhc3luY19jbGllbnQlMjAlM0QlMjBlbmRwb2ludC5hc3luY19jbGllbnQlMEFyZXN1bHRzJTIwJTNEJTIwYXN5bmNpby5nYXRoZXIoKiU1QmFzeW5jX2NsaWVudC50ZXh0X2dlbmVyYXRpb24oLi4uKSUyMGZvciUyMGpvYiUyMGluJTIwam9icyU1RCklMEElMEFlbmRwb2ludC5wYXVzZSgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> asyncio
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_inference_endpoint

<span class="hljs-comment"># Get endpoint + wait until initialized</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = get_inference_endpoint(<span class="hljs-string">&quot;batch-endpoint&quot;</span>).resume().wait()

<span class="hljs-comment"># Run inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>async_client = endpoint.async_client
<span class="hljs-meta">&gt;&gt;&gt; </span>results = asyncio.gather(*[async_client.text_generation(...) <span class="hljs-keyword">for</span> job <span class="hljs-keyword">in</span> jobs])

<span class="hljs-comment"># Pause endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.pause()`,wrap:!1}}),{c(){l=p("meta"),_=a(),m=p("p"),y=a(),r(I.$$.fragment),_e=a(),v=p("p"),v.innerHTML=hn,je=a(),k=p("p"),k.innerHTML=mn,ye=a(),r(T.$$.fragment),be=a(),E=p("p"),E.innerHTML=_n,$e=a(),r(W.$$.fragment),we=a(),U=p("p"),U.innerHTML=jn,xe=a(),C=p("p"),C.innerHTML=yn,Me=a(),r(J.$$.fragment),Ie=a(),Z=p("p"),Z.innerHTML=bn,ve=a(),H=p("p"),H.innerHTML=$n,ke=a(),q=p("p"),q.innerHTML=wn,Te=a(),r(B.$$.fragment),Ee=a(),Q=p("p"),Q.innerHTML=xn,We=a(),r(L.$$.fragment),Ue=a(),r(G.$$.fragment),Ce=a(),V=p("p"),V.innerHTML=Mn,Je=a(),r(X.$$.fragment),Ze=a(),Y=p("p"),Y.innerHTML=In,He=a(),r(z.$$.fragment),qe=a(),R=p("p"),R.innerHTML=vn,Be=a(),r(N.$$.fragment),Qe=a(),S=p("p"),S.innerHTML=kn,Le=a(),r(P.$$.fragment),Ge=a(),A=p("p"),A.textContent=Tn,Ve=a(),F=p("p"),F.innerHTML=En,Xe=a(),r(K.$$.fragment),Ye=a(),D=p("p"),D.innerHTML=Wn,ze=a(),r(O.$$.fragment),Re=a(),ee=p("p"),ee.innerHTML=Un,Ne=a(),r(ne.$$.fragment),Se=a(),te=p("p"),te.textContent=Cn,Pe=a(),r(w.$$.fragment),Ae=a(),r(se.$$.fragment),Fe=a(),ae=p("p"),ae.innerHTML=Jn,Ke=a(),r(x.$$.fragment),De=a(),r(ie.$$.fragment),Oe=a(),r(le.$$.fragment),en=a(),pe=p("p"),pe.innerHTML=Zn,nn=a(),r(ce.$$.fragment),tn=a(),r(oe.$$.fragment),sn=a(),re=p("p"),re.innerHTML=Hn,an=a(),r(M.$$.fragment),ln=a(),r(ge.$$.fragment),pn=a(),fe=p("p"),fe.textContent=qn,cn=a(),r(ue.$$.fragment),on=a(),de=p("p"),de.textContent=Bn,rn=a(),r(he.$$.fragment),gn=a(),me=p("p"),this.h()},l(e){const n=Sn("svelte-u9bgzb",document.head);l=c(n,"META",{name:!0,content:!0}),n.forEach(t),_=i(e),m=c(e,"P",{}),Vn(m).forEach(t),y=i(e),g(I.$$.fragment,e),_e=i(e),v=c(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-188e6gz"&&(v.innerHTML=hn),je=i(e),k=c(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1ds3okp"&&(k.innerHTML=mn),ye=i(e),g(T.$$.fragment,e),be=i(e),E=c(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1l9gp9r"&&(E.innerHTML=_n),$e=i(e),g(W.$$.fragment,e),we=i(e),U=c(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1stw0yf"&&(U.innerHTML=jn),xe=i(e),C=c(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-om3prk"&&(C.innerHTML=yn),Me=i(e),g(J.$$.fragment,e),Ie=i(e),Z=c(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-dxdc75"&&(Z.innerHTML=bn),ve=i(e),H=c(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1tjw294"&&(H.innerHTML=$n),ke=i(e),q=c(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1tajtyl"&&(q.innerHTML=wn),Te=i(e),g(B.$$.fragment,e),Ee=i(e),Q=c(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-11vxr6w"&&(Q.innerHTML=xn),We=i(e),g(L.$$.fragment,e),Ue=i(e),g(G.$$.fragment,e),Ce=i(e),V=c(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-dq4a0y"&&(V.innerHTML=Mn),Je=i(e),g(X.$$.fragment,e),Ze=i(e),Y=c(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-9uusqp"&&(Y.innerHTML=In),He=i(e),g(z.$$.fragment,e),qe=i(e),R=c(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-ukrxtu"&&(R.innerHTML=vn),Be=i(e),g(N.$$.fragment,e),Qe=i(e),S=c(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1g2lxsg"&&(S.innerHTML=kn),Le=i(e),g(P.$$.fragment,e),Ge=i(e),A=c(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1v80t3q"&&(A.textContent=Tn),Ve=i(e),F=c(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-t4h55j"&&(F.innerHTML=En),Xe=i(e),g(K.$$.fragment,e),Ye=i(e),D=c(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-14lkb0s"&&(D.innerHTML=Wn),ze=i(e),g(O.$$.fragment,e),Re=i(e),ee=c(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-hdlilu"&&(ee.innerHTML=Un),Ne=i(e),g(ne.$$.fragment,e),Se=i(e),te=c(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-16mqpnz"&&(te.textContent=Cn),Pe=i(e),g(w.$$.fragment,e),Ae=i(e),g(se.$$.fragment,e),Fe=i(e),ae=c(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1smbc2p"&&(ae.innerHTML=Jn),Ke=i(e),g(x.$$.fragment,e),De=i(e),g(ie.$$.fragment,e),Oe=i(e),g(le.$$.fragment,e),en=i(e),pe=c(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-1t6fupx"&&(pe.innerHTML=Zn),nn=i(e),g(ce.$$.fragment,e),tn=i(e),g(oe.$$.fragment,e),sn=i(e),re=c(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-1j2n6pp"&&(re.innerHTML=Hn),an=i(e),g(M.$$.fragment,e),ln=i(e),g(ge.$$.fragment,e),pn=i(e),fe=c(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-r11tzs"&&(fe.textContent=qn),cn=i(e),g(ue.$$.fragment,e),on=i(e),de=c(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-u5cd5i"&&(de.textContent=Bn),rn=i(e),g(he.$$.fragment,e),gn=i(e),me=c(e,"P",{}),Vn(me).forEach(t),this.h()},h(){Xn(l,"name","hf:doc:metadata"),Xn(l,"content",et)},m(e,n){Pn(document.head,l),s(e,_,n),s(e,m,n),s(e,y,n),f(I,e,n),s(e,_e,n),s(e,v,n),s(e,je,n),s(e,k,n),s(e,ye,n),f(T,e,n),s(e,be,n),s(e,E,n),s(e,$e,n),f(W,e,n),s(e,we,n),s(e,U,n),s(e,xe,n),s(e,C,n),s(e,Me,n),f(J,e,n),s(e,Ie,n),s(e,Z,n),s(e,ve,n),s(e,H,n),s(e,ke,n),s(e,q,n),s(e,Te,n),f(B,e,n),s(e,Ee,n),s(e,Q,n),s(e,We,n),f(L,e,n),s(e,Ue,n),f(G,e,n),s(e,Ce,n),s(e,V,n),s(e,Je,n),f(X,e,n),s(e,Ze,n),s(e,Y,n),s(e,He,n),f(z,e,n),s(e,qe,n),s(e,R,n),s(e,Be,n),f(N,e,n),s(e,Qe,n),s(e,S,n),s(e,Le,n),f(P,e,n),s(e,Ge,n),s(e,A,n),s(e,Ve,n),s(e,F,n),s(e,Xe,n),f(K,e,n),s(e,Ye,n),s(e,D,n),s(e,ze,n),f(O,e,n),s(e,Re,n),s(e,ee,n),s(e,Ne,n),f(ne,e,n),s(e,Se,n),s(e,te,n),s(e,Pe,n),f(w,e,n),s(e,Ae,n),f(se,e,n),s(e,Fe,n),s(e,ae,n),s(e,Ke,n),f(x,e,n),s(e,De,n),f(ie,e,n),s(e,Oe,n),f(le,e,n),s(e,en,n),s(e,pe,n),s(e,nn,n),f(ce,e,n),s(e,tn,n),f(oe,e,n),s(e,sn,n),s(e,re,n),s(e,an,n),f(M,e,n),s(e,ln,n),f(ge,e,n),s(e,pn,n),s(e,fe,n),s(e,cn,n),f(ue,e,n),s(e,on,n),s(e,de,n),s(e,rn,n),f(he,e,n),s(e,gn,n),s(e,me,n),fn=!0},p(e,[n]){const Qn={};n&2&&(Qn.$$scope={dirty:n,ctx:e}),w.$set(Qn);const Ln={};n&2&&(Ln.$$scope={dirty:n,ctx:e}),x.$set(Ln);const Gn={};n&2&&(Gn.$$scope={dirty:n,ctx:e}),M.$set(Gn)},i(e){fn||(u(I.$$.fragment,e),u(T.$$.fragment,e),u(W.$$.fragment,e),u(J.$$.fragment,e),u(B.$$.fragment,e),u(L.$$.fragment,e),u(G.$$.fragment,e),u(X.$$.fragment,e),u(z.$$.fragment,e),u(N.$$.fragment,e),u(P.$$.fragment,e),u(K.$$.fragment,e),u(O.$$.fragment,e),u(ne.$$.fragment,e),u(w.$$.fragment,e),u(se.$$.fragment,e),u(x.$$.fragment,e),u(ie.$$.fragment,e),u(le.$$.fragment,e),u(ce.$$.fragment,e),u(oe.$$.fragment,e),u(M.$$.fragment,e),u(ge.$$.fragment,e),u(ue.$$.fragment,e),u(he.$$.fragment,e),fn=!0)},o(e){d(I.$$.fragment,e),d(T.$$.fragment,e),d(W.$$.fragment,e),d(J.$$.fragment,e),d(B.$$.fragment,e),d(L.$$.fragment,e),d(G.$$.fragment,e),d(X.$$.fragment,e),d(z.$$.fragment,e),d(N.$$.fragment,e),d(P.$$.fragment,e),d(K.$$.fragment,e),d(O.$$.fragment,e),d(ne.$$.fragment,e),d(w.$$.fragment,e),d(se.$$.fragment,e),d(x.$$.fragment,e),d(ie.$$.fragment,e),d(le.$$.fragment,e),d(ce.$$.fragment,e),d(oe.$$.fragment,e),d(M.$$.fragment,e),d(ge.$$.fragment,e),d(ue.$$.fragment,e),d(he.$$.fragment,e),fn=!1},d(e){e&&(t(_),t(m),t(y),t(_e),t(v),t(je),t(k),t(ye),t(be),t(E),t($e),t(we),t(U),t(xe),t(C),t(Me),t(Ie),t(Z),t(ve),t(H),t(ke),t(q),t(Te),t(Ee),t(Q),t(We),t(Ue),t(Ce),t(V),t(Je),t(Ze),t(Y),t(He),t(qe),t(R),t(Be),t(Qe),t(S),t(Le),t(Ge),t(A),t(Ve),t(F),t(Xe),t(Ye),t(D),t(ze),t(Re),t(ee),t(Ne),t(Se),t(te),t(Pe),t(Ae),t(Fe),t(ae),t(Ke),t(De),t(Oe),t(en),t(pe),t(nn),t(tn),t(sn),t(re),t(an),t(ln),t(pn),t(fe),t(cn),t(on),t(de),t(rn),t(gn),t(me)),t(l),h(I,e),h(T,e),h(W,e),h(J,e),h(B,e),h(L,e),h(G,e),h(X,e),h(z,e),h(N,e),h(P,e),h(K,e),h(O,e),h(ne,e),h(w,e),h(se,e),h(x,e),h(ie,e),h(le,e),h(ce,e),h(oe,e),h(M,e),h(ge,e),h(ue,e),h(he,e)}}}const et='{"title":"Inference Endpoints","local":"inference-endpoints","sections":[{"title":"Create an Inference Endpoint","local":"create-an-inference-endpoint","sections":[{"title":"Get or list existing Inference Endpoints","local":"get-or-list-existing-inference-endpoints","sections":[],"depth":3}],"depth":2},{"title":"Check deployment status","local":"check-deployment-status","sections":[],"depth":2},{"title":"Run inference","local":"run-inference","sections":[],"depth":2},{"title":"Manage lifecycle","local":"manage-lifecycle","sections":[{"title":"Pause or scale to zero","local":"pause-or-scale-to-zero","sections":[],"depth":3},{"title":"Update model or hardware requirements","local":"update-model-or-hardware-requirements","sections":[],"depth":3},{"title":"Delete the endpoint","local":"delete-the-endpoint","sections":[],"depth":3}],"depth":2},{"title":"An end-to-end example","local":"an-end-to-end-example","sections":[],"depth":2}],"depth":1}';function nt($){return zn(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=An}),[]}class pt extends Rn{constructor(l){super(),Nn(this,l,nt,On,Yn,{})}}export{pt as component};
