import{s as ye,n as ue,o as Ue}from"../chunks/scheduler.6062bdaf.js";import{S as he,i as be,g as s,s as a,r as m,A as Te,h as o,f as l,c as n,j as ce,u as M,x as p,k as Ht,y as we,a as i,v as r,d,t as c,w as y}from"../chunks/index.4bca734e.js";import{C as U}from"../chunks/CodeBlock.fa01571c.js";import{H as tt}from"../chunks/Heading.723dceba.js";function fe(At){let u,it,et,at,b,nt,T,Qt='🤗 Optimum provides an <code>optimum.onnxruntime</code> package that enables you to apply graph optimization on many model hosted on the 🤗 hub using the <a href="https://github.com/microsoft/onnxruntime/tree/master/onnxruntime/python/tools/transformers" rel="nofollow">ONNX Runtime</a> model optimization tool.',st,w,ot,f,Et="The ONNX model can be directly optimized during the ONNX export using Optimum CLI, by passing the argument <code>--optimize {O1,O2,O3,O4}</code> in the CLI, for example:",pt,g,mt,j,Ft="The optimization levels are:",Mt,J,Lt="<li>O1: basic general optimizations.</li> <li>O2: basic and extended general optimizations, transformers-specific fusions.</li> <li>O3: same as O2 with GELU approximation.</li> <li>O4: same as O3 with mixed precision (fp16, GPU-only, requires <code>--device cuda</code>).</li>",rt,C,dt,z,Yt='ONNX models can be optimized with the <a href="/docs/optimum/v1.16.1/en/onnxruntime/package_reference/optimization#optimum.onnxruntime.ORTOptimizer">ORTOptimizer</a>. The class can be initialized using the <a href="/docs/optimum/v1.16.1/en/onnxruntime/package_reference/optimization#optimum.onnxruntime.ORTOptimizer.from_pretrained">from_pretrained()</a> method, which supports different checkpoint formats.',ct,G,Pt='<li>Using an already initialized <a href="/docs/optimum/v1.16.1/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a> class.</li>',yt,Z,ut,h,qt="<li>Using a local ONNX model from a directory.</li>",Ut,W,ht,I,bt,v,Kt='The <a href="/docs/optimum/v1.16.1/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.OptimizationConfig">OptimizationConfig</a> class allows to specify how the optimization should be performed by the <a href="/docs/optimum/v1.16.1/en/onnxruntime/package_reference/optimization#optimum.onnxruntime.ORTOptimizer">ORTOptimizer</a>.',Tt,B,Dt="In the optimization configuration, there are 4 possible optimization levels:",wt,R,te="<li><code>optimization_level=0</code>: to disable all optimizations</li> <li><code>optimization_level=1</code>: to enable basic optimizations such as constant folding or redundant node eliminations</li> <li><code>optimization_level=2</code>: to enable extended graph optimizations such as node fusions</li> <li><code>optimization_level=99</code>: to enable data layout optimizations</li>",ft,X,ee=`Choosing a level enables the optimizations of that level, as well as the optimizations of all preceding levels.
More information <a href="https://onnxruntime.ai/docs/performance/graph-optimizations.html" rel="nofollow">here</a>.`,gt,O,le=`<code>enable_transformers_specific_optimizations=True</code> means that <code>transformers</code>-specific graph fusion and approximation are performed in addition to the ONNX Runtime optimizations described above.
Here is a list of the possible optimizations you can enable:`,jt,_,ie="<li>Gelu fusion with <code>disable_gelu_fusion=False</code>,</li> <li>Layer Normalization fusion with <code>disable_layer_norm_fusion=False</code>,</li> <li>Attention fusion with <code>disable_attention_fusion=False</code>,</li> <li>SkipLayerNormalization fusion with <code>disable_skip_layer_norm_fusion=False</code>,</li> <li>Add Bias and SkipLayerNormalization fusion with <code>disable_bias_skip_layer_norm_fusion=False</code>,</li> <li>Add Bias and Gelu / FastGelu fusion with <code>disable_bias_gelu_fusion=False</code>,</li> <li>Gelu approximation with <code>enable_gelu_approximation=True</code>.</li>",Jt,x,ae='While <a href="/docs/optimum/v1.16.1/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.OptimizationConfig">OptimizationConfig</a> gives you full control on how to do optimization, it can be hard to know what to enable / disable. Instead, you can use <a href="/docs/optimum/v1.16.1/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.AutoOptimizationConfig">AutoOptimizationConfig</a> which provides four common optimization levels:',Ct,$,ne="<li>O1: basic general optimizations.</li> <li>O2: basic and extended general optimizations, transformers-specific fusions.</li> <li>O3: same as O2 with GELU approximation.</li> <li>O4: same as O3 with mixed precision (fp16, GPU-only).</li>",zt,N,se='Example: Loading a O2 <a href="/docs/optimum/v1.16.1/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.OptimizationConfig">OptimizationConfig</a>',Gt,k,Zt,V,oe="You can also specify custom argument that were not defined in the O2 configuration, for instance:",Wt,S,It,H,vt,A,pe='Below you will find an easy end-to-end example on how to optimize <a href="https://huggingface.co/distilbert-base-uncased-finetuned-sst-2-english" rel="nofollow">distilbert-base-uncased-finetuned-sst-2-english</a>.',Bt,Q,Rt,E,me='Below you will find an easy end-to-end example on how to optimize a Seq2Seq model <a href="https://huggingface.co/sshleifer/distilbart-cnn-12-6" rel="nofollow">sshleifer/distilbart-cnn-12-6”</a>.',Xt,F,Ot,L,_t,Y,Me="The Optimum ONNX Runtime optimization tools can be used directly through Optimum command-line interface:",xt,P,$t,q,re="Optimizing an ONNX model can be done as follows:",Nt,K,kt,D,de="This optimizes all the ONNX files in <code>onnx_model_location</code> with the basic general optimizations.",Vt,lt,St;return b=new tt({props:{title:"Optimization",local:"optimization",headingTag:"h1"}}),w=new tt({props:{title:"Optimizing a model during the ONNX export",local:"optimizing-a-model-during-the-onnx-export",headingTag:"h2"}}),g=new U({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBvbm54JTIwLS1tb2RlbCUyMGdwdDIlMjAtLW9wdGltaXplJTIwTzMlMjBncHQyX29ubnglMkY=",highlighted:'<span class="hljs-title">optimum</span>-cli ex<span class="hljs-keyword">port</span> onnx <span class="hljs-comment">--model gpt2 --optimize O3 gpt2_onnx/</span>',wrap:!1}}),C=new tt({props:{title:"Optimizing a model programmatically with ORTOptimizer",local:"optimizing-a-model-programmatically-with-ortoptimizer",headingTag:"h2"}}),Z=new U({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRPcHRpbWl6ZXIlMkMlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyJTBBKSUwQSUwQW9wdGltaXplciUyMCUzRCUyME9SVE9wdGltaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWwp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTOptimizer, ORTModelForSequenceClassification

<span class="hljs-comment"># Loading ONNX Model from the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># Create an optimizer from an ORTModelForXXX</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = ORTOptimizer.from_pretrained(model)`,wrap:!1}}),W=new U({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRPcHRpbWl6ZXIlMEElMEFvcHRpbWl6ZXIlMjAlM0QlMjBPUlRPcHRpbWl6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnBhdGglMkZ0byUyRm1vZGVsJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTOptimizer

<span class="hljs-comment"># This assumes a model.onnx exists in path/to/model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = ORTOptimizer.from_pretrained(<span class="hljs-string">&quot;path/to/model&quot;</span>)`,wrap:!1}}),I=new tt({props:{title:"Optimization Configuration",local:"optimization-configuration",headingTag:"h3"}}),k=new U({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBBdXRvT3B0aW1pemF0aW9uQ29uZmlnJTBBb3B0aW1pemF0aW9uX2NvbmZpZyUyMCUzRCUyMEF1dG9PcHRpbWl6YXRpb25Db25maWcuTzIoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> AutoOptimizationConfig
<span class="hljs-meta">&gt;&gt;&gt; </span>optimization_config = AutoOptimizationConfig.O2()`,wrap:!1}}),S=new U({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBBdXRvT3B0aW1pemF0aW9uQ29uZmlnJTBBb3B0aW1pemF0aW9uX2NvbmZpZyUyMCUzRCUyMEF1dG9PcHRpbWl6YXRpb25Db25maWcuTzIoZGlzYWJsZV9lbWJlZF9sYXllcl9ub3JtX2Z1c2lvbiUzREZhbHNlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> AutoOptimizationConfig
<span class="hljs-meta">&gt;&gt;&gt; </span>optimization_config = AutoOptimizationConfig.O2(disable_embed_layer_norm_fusion=<span class="hljs-literal">False</span>)`,wrap:!1}}),H=new tt({props:{title:"Optimization examples",local:"optimization-examples",headingTag:"h3"}}),Q=new U({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwQXV0b09wdGltaXphdGlvbkNvbmZpZyUyQyUyME9SVE9wdGltaXplciUyQyUyME9SVE1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSklMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyJTBBc2F2ZV9kaXIlMjAlM0QlMjAlMjJkaXN0aWxiZXJ0X29wdGltaXplZCUyMiUwQSUwQSUyMyUyMExvYWQlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwYW5kJTIwZXhwb3J0JTIwaXQlMjB0byUyMHRoZSUyME9OTlglMjBmb3JtYXQlMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RUcnVlKSUwQSUwQSUyMyUyMENyZWF0ZSUyMHRoZSUyMG9wdGltaXplciUwQW9wdGltaXplciUyMCUzRCUyME9SVE9wdGltaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWwpJTBBJTBBJTIzJTIwRGVmaW5lJTIwdGhlJTIwb3B0aW1pemF0aW9uJTIwc3RyYXRlZ3klMjBieSUyMGNyZWF0aW5nJTIwdGhlJTIwYXBwcm9wcmlhdGUlMjBjb25maWd1cmF0aW9uJTBBb3B0aW1pemF0aW9uX2NvbmZpZyUyMCUzRCUyMEF1dG9PcHRpbWl6YXRpb25Db25maWcuTzIoKSUwQSUwQSUyMyUyME9wdGltaXplJTIwdGhlJTIwbW9kZWwlMEFvcHRpbWl6ZXIub3B0aW1pemUoc2F2ZV9kaXIlM0RzYXZlX2RpciUyQyUyMG9wdGltaXphdGlvbl9jb25maWclM0RvcHRpbWl6YXRpb25fY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoOptimizationConfig, ORTOptimizer, ORTModelForSequenceClassification
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_dir = <span class="hljs-string">&quot;distilbert_optimized&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load a PyTorch model and export it to the ONNX format</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Create the optimizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = ORTOptimizer.from_pretrained(model)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Define the optimization strategy by creating the appropriate configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>optimization_config = AutoOptimizationConfig.O2()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Optimize the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer.optimize(save_dir=save_dir, optimization_config=optimization_config)`,wrap:!1}}),F=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyMCUyME9wdGltaXphdGlvbkNvbmZpZyUyQyUyME9SVE9wdGltaXplciUyQyUyME9SVE1vZGVsRm9yU2VxMlNlcUxNJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzc2hsZWlmZXIlMkZkaXN0aWxiYXJ0LWNubi0xMi02JTIyJTBBc2F2ZV9kaXIlMjAlM0QlMjAlMjJkaXN0aWxiYXJ0X29wdGltaXplZCUyMiUwQSUwQSUyMyUyMExvYWQlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwYW5kJTIwZXhwb3J0JTIwaXQlMjB0byUyMHRoZSUyME9OTlglMjBmb3JtYXQlMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUpJTBBJTBBJTIzJTIwQ3JlYXRlJTIwdGhlJTIwb3B0aW1pemVyJTBBb3B0aW1pemVyJTIwJTNEJTIwT1JUT3B0aW1pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbCklMEElMEElMjMlMjBEZWZpbmUlMjB0aGUlMjBvcHRpbWl6YXRpb24lMjBzdHJhdGVneSUyMGJ5JTIwY3JlYXRpbmclMjB0aGUlMjBhcHByb3ByaWF0ZSUyMGNvbmZpZ3VyYXRpb24lMEFvcHRpbWl6YXRpb25fY29uZmlnJTIwJTNEJTIwT3B0aW1pemF0aW9uQ29uZmlnKCUwQSUyMCUyMCUyMCUyMG9wdGltaXphdGlvbl9sZXZlbCUzRDIlMkMlMEElMjAlMjAlMjAlMjBlbmFibGVfdHJhbnNmb3JtZXJzX3NwZWNpZmljX29wdGltaXphdGlvbnMlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVfZm9yX2dwdSUzREZhbHNlJTJDJTBBKSUwQSUwQSUyMyUyME9wdGltaXplJTIwdGhlJTIwbW9kZWwlMEFvcHRpbWl6ZXIub3B0aW1pemUoc2F2ZV9kaXIlM0RzYXZlX2RpciUyQyUyMG9wdGltaXphdGlvbl9jb25maWclM0RvcHRpbWl6YXRpb25fY29uZmlnKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQW9wdGltaXplZF9tb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZChzYXZlX2RpciklMEF0b2tlbnMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyVGhpcyUyMGlzJTIwYSUyMHNhbXBsZSUyMGlucHV0JTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXRwdXRzJTIwJTNEJTIwb3B0aW1pemVkX21vZGVsLmdlbmVyYXRlKCoqdG9rZW5zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span>  OptimizationConfig, ORTOptimizer, ORTModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;sshleifer/distilbart-cnn-12-6&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_dir = <span class="hljs-string">&quot;distilbart_optimized&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load a PyTorch model and export it to the ONNX format</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSeq2SeqLM.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Create the optimizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = ORTOptimizer.from_pretrained(model)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Define the optimization strategy by creating the appropriate configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>optimization_config = OptimizationConfig(
<span class="hljs-meta">... </span>    optimization_level=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    enable_transformers_specific_optimizations=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    optimize_for_gpu=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Optimize the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer.optimize(save_dir=save_dir, optimization_config=optimization_config)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>optimized_model = ORTModelForSeq2SeqLM.from_pretrained(save_dir)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokens = tokenizer(<span class="hljs-string">&quot;This is a sample input&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = optimized_model.generate(**tokens)`,wrap:!1}}),L=new tt({props:{title:"Optimizing a model with Optimum CLI",local:"optimizing-a-model-with-optimum-cli",headingTag:"h2"}}),P=new U({props:{code:"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",highlighted:`optimum-cli onnxruntime optimize --<span class="hljs-built_in">help</span>
usage: optimum-cli &lt;<span class="hljs-built_in">command</span>&gt; [&lt;args&gt;] onnxruntime optimize [-h] --onnx_model ONNX_MODEL -o OUTPUT (-O1 | -O2 | -O3 | -O4 | -c CONFIG)

options:
  -h, --<span class="hljs-built_in">help</span>            show this <span class="hljs-built_in">help</span> message and <span class="hljs-built_in">exit</span>
  -O1                   Basic general optimizations (see: https://huggingface.co/docs/optimum/onnxruntime/usage_guides/optimization <span class="hljs-keyword">for</span> more details).
  -O2                   Basic and extended general optimizations, transformers-specific fusions (see: https://huggingface.co/docs/optimum/onnxruntime/usage_guides/optimization <span class="hljs-keyword">for</span> more
                        details).
  -O3                   Same as O2 with Gelu approximation (see: https://huggingface.co/docs/optimum/onnxruntime/usage_guides/optimization <span class="hljs-keyword">for</span> more details).
  -O4                   Same as O3 with mixed precision (see: https://huggingface.co/docs/optimum/onnxruntime/usage_guides/optimization <span class="hljs-keyword">for</span> more details).
  -c CONFIG, --config CONFIG
                        \`ORTConfig\` file to use to optimize the model.

Required arguments:
  --onnx_model ONNX_MODEL
                        Path to the repository <span class="hljs-built_in">where</span> the ONNX models to optimize are located.
  -o OUTPUT, --output OUTPUT
                        Path to the directory <span class="hljs-built_in">where</span> to store generated ONNX model.`,wrap:!1}}),K=new U({props:{code:"JTIwb3B0aW11bS1jbGklMjBvbm54cnVudGltZSUyMG9wdGltaXplJTIwLS1vbm54X21vZGVsJTIwb25ueF9tb2RlbF9sb2NhdGlvbiUyRiUyMC1PMSUyMC1vJTIwb3B0aW1pemVkX21vZGVsJTJG",highlighted:" optimum-cli onnxruntime optimize --onnx_model onnx_model_location/ -O1 -o optimized_model/",wrap:!1}}),{c(){u=s("meta"),it=a(),et=s("p"),at=a(),m(b.$$.fragment),nt=a(),T=s("p"),T.innerHTML=Qt,st=a(),m(w.$$.fragment),ot=a(),f=s("p"),f.innerHTML=Et,pt=a(),m(g.$$.fragment),mt=a(),j=s("p"),j.textContent=Ft,Mt=a(),J=s("ul"),J.innerHTML=Lt,rt=a(),m(C.$$.fragment),dt=a(),z=s("p"),z.innerHTML=Yt,ct=a(),G=s("ol"),G.innerHTML=Pt,yt=a(),m(Z.$$.fragment),ut=a(),h=s("ol"),h.innerHTML=qt,Ut=a(),m(W.$$.fragment),ht=a(),m(I.$$.fragment),bt=a(),v=s("p"),v.innerHTML=Kt,Tt=a(),B=s("p"),B.textContent=Dt,wt=a(),R=s("ul"),R.innerHTML=te,ft=a(),X=s("p"),X.innerHTML=ee,gt=a(),O=s("p"),O.innerHTML=le,jt=a(),_=s("ul"),_.innerHTML=ie,Jt=a(),x=s("p"),x.innerHTML=ae,Ct=a(),$=s("ul"),$.innerHTML=ne,zt=a(),N=s("p"),N.innerHTML=se,Gt=a(),m(k.$$.fragment),Zt=a(),V=s("p"),V.textContent=oe,Wt=a(),m(S.$$.fragment),It=a(),m(H.$$.fragment),vt=a(),A=s("p"),A.innerHTML=pe,Bt=a(),m(Q.$$.fragment),Rt=a(),E=s("p"),E.innerHTML=me,Xt=a(),m(F.$$.fragment),Ot=a(),m(L.$$.fragment),_t=a(),Y=s("p"),Y.textContent=Me,xt=a(),m(P.$$.fragment),$t=a(),q=s("p"),q.textContent=re,Nt=a(),m(K.$$.fragment),kt=a(),D=s("p"),D.innerHTML=de,Vt=a(),lt=s("p"),this.h()},l(t){const e=Te("svelte-u9bgzb",document.head);u=o(e,"META",{name:!0,content:!0}),e.forEach(l),it=n(t),et=o(t,"P",{}),ce(et).forEach(l),at=n(t),M(b.$$.fragment,t),nt=n(t),T=o(t,"P",{"data-svelte-h":!0}),p(T)!=="svelte-d5af43"&&(T.innerHTML=Qt),st=n(t),M(w.$$.fragment,t),ot=n(t),f=o(t,"P",{"data-svelte-h":!0}),p(f)!=="svelte-o2at96"&&(f.innerHTML=Et),pt=n(t),M(g.$$.fragment,t),mt=n(t),j=o(t,"P",{"data-svelte-h":!0}),p(j)!=="svelte-1o0731n"&&(j.textContent=Ft),Mt=n(t),J=o(t,"UL",{"data-svelte-h":!0}),p(J)!=="svelte-1r3jeqb"&&(J.innerHTML=Lt),rt=n(t),M(C.$$.fragment,t),dt=n(t),z=o(t,"P",{"data-svelte-h":!0}),p(z)!=="svelte-xf84id"&&(z.innerHTML=Yt),ct=n(t),G=o(t,"OL",{"data-svelte-h":!0}),p(G)!=="svelte-5z3szr"&&(G.innerHTML=Pt),yt=n(t),M(Z.$$.fragment,t),ut=n(t),h=o(t,"OL",{start:!0,"data-svelte-h":!0}),p(h)!=="svelte-s0fljy"&&(h.innerHTML=qt),Ut=n(t),M(W.$$.fragment,t),ht=n(t),M(I.$$.fragment,t),bt=n(t),v=o(t,"P",{"data-svelte-h":!0}),p(v)!=="svelte-sxviic"&&(v.innerHTML=Kt),Tt=n(t),B=o(t,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1dpoxba"&&(B.textContent=Dt),wt=n(t),R=o(t,"UL",{"data-svelte-h":!0}),p(R)!=="svelte-o45rsi"&&(R.innerHTML=te),ft=n(t),X=o(t,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1dyt65t"&&(X.innerHTML=ee),gt=n(t),O=o(t,"P",{"data-svelte-h":!0}),p(O)!=="svelte-4bipj7"&&(O.innerHTML=le),jt=n(t),_=o(t,"UL",{"data-svelte-h":!0}),p(_)!=="svelte-19j884u"&&(_.innerHTML=ie),Jt=n(t),x=o(t,"P",{"data-svelte-h":!0}),p(x)!=="svelte-rx7cb4"&&(x.innerHTML=ae),Ct=n(t),$=o(t,"UL",{"data-svelte-h":!0}),p($)!=="svelte-1okf1dh"&&($.innerHTML=ne),zt=n(t),N=o(t,"P",{"data-svelte-h":!0}),p(N)!=="svelte-ldhm1w"&&(N.innerHTML=se),Gt=n(t),M(k.$$.fragment,t),Zt=n(t),V=o(t,"P",{"data-svelte-h":!0}),p(V)!=="svelte-12zpihs"&&(V.textContent=oe),Wt=n(t),M(S.$$.fragment,t),It=n(t),M(H.$$.fragment,t),vt=n(t),A=o(t,"P",{"data-svelte-h":!0}),p(A)!=="svelte-np22ir"&&(A.innerHTML=pe),Bt=n(t),M(Q.$$.fragment,t),Rt=n(t),E=o(t,"P",{"data-svelte-h":!0}),p(E)!=="svelte-ypkmtu"&&(E.innerHTML=me),Xt=n(t),M(F.$$.fragment,t),Ot=n(t),M(L.$$.fragment,t),_t=n(t),Y=o(t,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-k6kyac"&&(Y.textContent=Me),xt=n(t),M(P.$$.fragment,t),$t=n(t),q=o(t,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1ucr6zy"&&(q.textContent=re),Nt=n(t),M(K.$$.fragment,t),kt=n(t),D=o(t,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1e94zh6"&&(D.innerHTML=de),Vt=n(t),lt=o(t,"P",{}),ce(lt).forEach(l),this.h()},h(){Ht(u,"name","hf:doc:metadata"),Ht(u,"content",ge),Ht(h,"start","2")},m(t,e){we(document.head,u),i(t,it,e),i(t,et,e),i(t,at,e),r(b,t,e),i(t,nt,e),i(t,T,e),i(t,st,e),r(w,t,e),i(t,ot,e),i(t,f,e),i(t,pt,e),r(g,t,e),i(t,mt,e),i(t,j,e),i(t,Mt,e),i(t,J,e),i(t,rt,e),r(C,t,e),i(t,dt,e),i(t,z,e),i(t,ct,e),i(t,G,e),i(t,yt,e),r(Z,t,e),i(t,ut,e),i(t,h,e),i(t,Ut,e),r(W,t,e),i(t,ht,e),r(I,t,e),i(t,bt,e),i(t,v,e),i(t,Tt,e),i(t,B,e),i(t,wt,e),i(t,R,e),i(t,ft,e),i(t,X,e),i(t,gt,e),i(t,O,e),i(t,jt,e),i(t,_,e),i(t,Jt,e),i(t,x,e),i(t,Ct,e),i(t,$,e),i(t,zt,e),i(t,N,e),i(t,Gt,e),r(k,t,e),i(t,Zt,e),i(t,V,e),i(t,Wt,e),r(S,t,e),i(t,It,e),r(H,t,e),i(t,vt,e),i(t,A,e),i(t,Bt,e),r(Q,t,e),i(t,Rt,e),i(t,E,e),i(t,Xt,e),r(F,t,e),i(t,Ot,e),r(L,t,e),i(t,_t,e),i(t,Y,e),i(t,xt,e),r(P,t,e),i(t,$t,e),i(t,q,e),i(t,Nt,e),r(K,t,e),i(t,kt,e),i(t,D,e),i(t,Vt,e),i(t,lt,e),St=!0},p:ue,i(t){St||(d(b.$$.fragment,t),d(w.$$.fragment,t),d(g.$$.fragment,t),d(C.$$.fragment,t),d(Z.$$.fragment,t),d(W.$$.fragment,t),d(I.$$.fragment,t),d(k.$$.fragment,t),d(S.$$.fragment,t),d(H.$$.fragment,t),d(Q.$$.fragment,t),d(F.$$.fragment,t),d(L.$$.fragment,t),d(P.$$.fragment,t),d(K.$$.fragment,t),St=!0)},o(t){c(b.$$.fragment,t),c(w.$$.fragment,t),c(g.$$.fragment,t),c(C.$$.fragment,t),c(Z.$$.fragment,t),c(W.$$.fragment,t),c(I.$$.fragment,t),c(k.$$.fragment,t),c(S.$$.fragment,t),c(H.$$.fragment,t),c(Q.$$.fragment,t),c(F.$$.fragment,t),c(L.$$.fragment,t),c(P.$$.fragment,t),c(K.$$.fragment,t),St=!1},d(t){t&&(l(it),l(et),l(at),l(nt),l(T),l(st),l(ot),l(f),l(pt),l(mt),l(j),l(Mt),l(J),l(rt),l(dt),l(z),l(ct),l(G),l(yt),l(ut),l(h),l(Ut),l(ht),l(bt),l(v),l(Tt),l(B),l(wt),l(R),l(ft),l(X),l(gt),l(O),l(jt),l(_),l(Jt),l(x),l(Ct),l($),l(zt),l(N),l(Gt),l(Zt),l(V),l(Wt),l(It),l(vt),l(A),l(Bt),l(Rt),l(E),l(Xt),l(Ot),l(_t),l(Y),l(xt),l($t),l(q),l(Nt),l(kt),l(D),l(Vt),l(lt)),l(u),y(b,t),y(w,t),y(g,t),y(C,t),y(Z,t),y(W,t),y(I,t),y(k,t),y(S,t),y(H,t),y(Q,t),y(F,t),y(L,t),y(P,t),y(K,t)}}}const ge='{"title":"Optimization","local":"optimization","sections":[{"title":"Optimizing a model during the ONNX export","local":"optimizing-a-model-during-the-onnx-export","sections":[],"depth":2},{"title":"Optimizing a model programmatically with ORTOptimizer","local":"optimizing-a-model-programmatically-with-ortoptimizer","sections":[{"title":"Optimization Configuration","local":"optimization-configuration","sections":[],"depth":3},{"title":"Optimization examples","local":"optimization-examples","sections":[],"depth":3}],"depth":2},{"title":"Optimizing a model with Optimum CLI","local":"optimizing-a-model-with-optimum-cli","sections":[],"depth":2}],"depth":1}';function je(At){return Ue(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ze extends he{constructor(u){super(),be(this,u,je,fe,ye,{})}}export{Ze as component};
