import{s as ue,n as we,o as ge}from"../chunks/scheduler.85c25b89.js";import{S as Je,i as je,g as l,s as o,u as c,A as fe,h as n,f as e,c as p,j as h,v as d,y as m,k as i,o as r,a,w as y,d as M,t as u,x as w}from"../chunks/index.9633332f.js";import{I as rt}from"../chunks/IconCopyLink.a4acffac.js";import{C as et}from"../chunks/CodeBlock.00597c71.js";function Te(zt){let g,ht,st,mt,J,v,at,I,St,q,Ht="(Legacy) SE-ResNeXt",ct,$,Yt='<strong>SE ResNeXt</strong> is a variant of a <a href="https://www.paperswithcode.com/method/resnext" rel="nofollow">ResNeXt</a> that employs <a href="https://paperswithcode.com/method/squeeze-and-excitation-block" rel="nofollow">squeeze-and-excitation blocks</a> to enable the network to perform dynamic channel-wise feature recalibration.',dt,j,U,lt,N,Xt,D,Ft="How do I use this model on an image?",yt,Z,Lt="To load a pretrained model:",Mt,W,ut,E,Pt="To load and preprocess the image:",wt,_,gt,G,qt="To get the model predictions:",Jt,B,jt,V,Dt="To get the top-5 predictions class names:",ft,S,Tt,X,Kt="Replace the model name with the variant you want to use, e.g. <code>legacy_seresnext101_32x4d</code>. You can find the IDs in the model summaries at the top of this page.",bt,Q,Ot='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',vt,f,C,nt,A,Qt,K,te="How do I finetune this model?",Ut,R,ee="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",Ct,z,xt,H,se=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,kt,T,x,ot,Y,At,O,ae="How do I train this model?",It,F,le='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',$t,b,k,pt,L,Rt,tt,ne="Citation",Nt,P,Zt,it,Wt;return I=new rt({}),N=new rt({}),W=new et({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2xlZ2FjeV9zZXJlc25leHQxMDFfMzJ4NGQnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;legacy_seresnext101_32x4d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),_=new et({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),B=new et({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),S=new et({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),A=new rt({}),z=new et({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnbGVnYWN5X3NlcmVzbmV4dDEwMV8zMng0ZCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;legacy_seresnext101_32x4d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),Y=new rt({}),L=new rt({}),P=new et({props:{code:"JTQwbWlzYyU3Qmh1MjAxOXNxdWVlemVhbmRleGNpdGF0aW9uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JTcXVlZXplLWFuZC1FeGNpdGF0aW9uJTIwTmV0d29ya3MlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JKaWUlMjBIdSUyMGFuZCUyMExpJTIwU2hlbiUyMGFuZCUyMFNhbXVlbCUyMEFsYmFuaWUlMjBhbmQlMjBHYW5nJTIwU3VuJTIwYW5kJTIwRW5odWElMjBXdSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHllYXIlM0QlN0IyMDE5JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwZXByaW50JTNEJTdCMTcwOS4wMTUwNyU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGFyY2hpdmVQcmVmaXglM0QlN0JhclhpdiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHByaW1hcnlDbGFzcyUzRCU3QmNzLkNWJTdEJTBBJTdE",highlighted:`@misc{hu2019squeezeandexcitation,
      title={Squeeze-<span class="hljs-keyword">and-Excitation </span>Networks}, 
      author={<span class="hljs-keyword">Jie </span>Hu <span class="hljs-keyword">and </span>Li <span class="hljs-keyword">Shen </span><span class="hljs-keyword">and </span>Samuel Albanie <span class="hljs-keyword">and </span>Gang Sun <span class="hljs-keyword">and </span>Enhua Wu},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1709</span>.<span class="hljs-number">01507</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`}}),{c(){g=l("meta"),ht=o(),st=l("p"),mt=o(),J=l("h1"),v=l("a"),at=l("span"),c(I.$$.fragment),St=o(),q=l("span"),q.textContent=Ht,ct=o(),$=l("p"),$.innerHTML=Yt,dt=o(),j=l("h2"),U=l("a"),lt=l("span"),c(N.$$.fragment),Xt=o(),D=l("span"),D.textContent=Ft,yt=o(),Z=l("p"),Z.textContent=Lt,Mt=o(),c(W.$$.fragment),ut=o(),E=l("p"),E.textContent=Pt,wt=o(),c(_.$$.fragment),gt=o(),G=l("p"),G.textContent=qt,Jt=o(),c(B.$$.fragment),jt=o(),V=l("p"),V.textContent=Dt,ft=o(),c(S.$$.fragment),Tt=o(),X=l("p"),X.innerHTML=Kt,bt=o(),Q=l("p"),Q.innerHTML=Ot,vt=o(),f=l("h2"),C=l("a"),nt=l("span"),c(A.$$.fragment),Qt=o(),K=l("span"),K.textContent=te,Ut=o(),R=l("p"),R.textContent=ee,Ct=o(),c(z.$$.fragment),xt=o(),H=l("p"),H.innerHTML=se,kt=o(),T=l("h2"),x=l("a"),ot=l("span"),c(Y.$$.fragment),At=o(),O=l("span"),O.textContent=ae,It=o(),F=l("p"),F.innerHTML=le,$t=o(),b=l("h2"),k=l("a"),pt=l("span"),c(L.$$.fragment),Rt=o(),tt=l("span"),tt.textContent=ne,Nt=o(),c(P.$$.fragment),Zt=o(),it=l("p"),this.h()},l(t){const s=fe("svelte-1phssyn",document.head);g=n(s,"META",{name:!0,content:!0}),s.forEach(e),ht=p(t),st=n(t,"P",{}),h(st).forEach(e),mt=p(t),J=n(t,"H1",{class:!0});var Et=h(J);v=n(Et,"A",{id:!0,class:!0,href:!0});var oe=h(v);at=n(oe,"SPAN",{});var pe=h(at);d(I.$$.fragment,pe),pe.forEach(e),oe.forEach(e),St=p(Et),q=n(Et,"SPAN",{"data-svelte-h":!0}),m(q)!=="svelte-1jujtib"&&(q.textContent=Ht),Et.forEach(e),ct=p(t),$=n(t,"P",{"data-svelte-h":!0}),m($)!=="svelte-1r2b6ta"&&($.innerHTML=Yt),dt=p(t),j=n(t,"H2",{class:!0});var _t=h(j);U=n(_t,"A",{id:!0,class:!0,href:!0});var ie=h(U);lt=n(ie,"SPAN",{});var re=h(lt);d(N.$$.fragment,re),re.forEach(e),ie.forEach(e),Xt=p(_t),D=n(_t,"SPAN",{"data-svelte-h":!0}),m(D)!=="svelte-1c1hspn"&&(D.textContent=Ft),_t.forEach(e),yt=p(t),Z=n(t,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-18ywhxh"&&(Z.textContent=Lt),Mt=p(t),d(W.$$.fragment,t),ut=p(t),E=n(t,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1c2ipa8"&&(E.textContent=Pt),wt=p(t),d(_.$$.fragment,t),gt=p(t),G=n(t,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1n9qsq1"&&(G.textContent=qt),Jt=p(t),d(B.$$.fragment,t),jt=p(t),V=n(t,"P",{"data-svelte-h":!0}),m(V)!=="svelte-19cnvx1"&&(V.textContent=Dt),ft=p(t),d(S.$$.fragment,t),Tt=p(t),X=n(t,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1uvqczn"&&(X.innerHTML=Kt),bt=p(t),Q=n(t,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1wmi3ea"&&(Q.innerHTML=Ot),vt=p(t),f=n(t,"H2",{class:!0});var Gt=h(f);C=n(Gt,"A",{id:!0,class:!0,href:!0});var he=h(C);nt=n(he,"SPAN",{});var me=h(nt);d(A.$$.fragment,me),me.forEach(e),he.forEach(e),Qt=p(Gt),K=n(Gt,"SPAN",{"data-svelte-h":!0}),m(K)!=="svelte-1viv4qv"&&(K.textContent=te),Gt.forEach(e),Ut=p(t),R=n(t,"P",{"data-svelte-h":!0}),m(R)!=="svelte-9sr7nh"&&(R.textContent=ee),Ct=p(t),d(z.$$.fragment,t),xt=p(t),H=n(t,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1kguc51"&&(H.innerHTML=se),kt=p(t),T=n(t,"H2",{class:!0});var Bt=h(T);x=n(Bt,"A",{id:!0,class:!0,href:!0});var ce=h(x);ot=n(ce,"SPAN",{});var de=h(ot);d(Y.$$.fragment,de),de.forEach(e),ce.forEach(e),At=p(Bt),O=n(Bt,"SPAN",{"data-svelte-h":!0}),m(O)!=="svelte-1ce591d"&&(O.textContent=ae),Bt.forEach(e),It=p(t),F=n(t,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1n0coha"&&(F.innerHTML=le),$t=p(t),b=n(t,"H2",{class:!0});var Vt=h(b);k=n(Vt,"A",{id:!0,class:!0,href:!0});var ye=h(k);pt=n(ye,"SPAN",{});var Me=h(pt);d(L.$$.fragment,Me),Me.forEach(e),ye.forEach(e),Rt=p(Vt),tt=n(Vt,"SPAN",{"data-svelte-h":!0}),m(tt)!=="svelte-15mb3gy"&&(tt.textContent=ne),Vt.forEach(e),Nt=p(t),d(P.$$.fragment,t),Zt=p(t),it=n(t,"P",{}),h(it).forEach(e),this.h()},h(){i(g,"name","hf:doc:metadata"),i(g,"content",JSON.stringify(be)),i(v,"id","legacy-seresnext"),i(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(v,"href","#legacy-seresnext"),i(J,"class","relative group"),i(U,"id","how-do-i-use-this-model-on-an-image"),i(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(U,"href","#how-do-i-use-this-model-on-an-image"),i(j,"class","relative group"),i(C,"id","how-do-i-finetune-this-model"),i(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(C,"href","#how-do-i-finetune-this-model"),i(f,"class","relative group"),i(x,"id","how-do-i-train-this-model"),i(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(x,"href","#how-do-i-train-this-model"),i(T,"class","relative group"),i(k,"id","citation"),i(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(k,"href","#citation"),i(b,"class","relative group")},m(t,s){r(document.head,g),a(t,ht,s),a(t,st,s),a(t,mt,s),a(t,J,s),r(J,v),r(v,at),y(I,at,null),r(J,St),r(J,q),a(t,ct,s),a(t,$,s),a(t,dt,s),a(t,j,s),r(j,U),r(U,lt),y(N,lt,null),r(j,Xt),r(j,D),a(t,yt,s),a(t,Z,s),a(t,Mt,s),y(W,t,s),a(t,ut,s),a(t,E,s),a(t,wt,s),y(_,t,s),a(t,gt,s),a(t,G,s),a(t,Jt,s),y(B,t,s),a(t,jt,s),a(t,V,s),a(t,ft,s),y(S,t,s),a(t,Tt,s),a(t,X,s),a(t,bt,s),a(t,Q,s),a(t,vt,s),a(t,f,s),r(f,C),r(C,nt),y(A,nt,null),r(f,Qt),r(f,K),a(t,Ut,s),a(t,R,s),a(t,Ct,s),y(z,t,s),a(t,xt,s),a(t,H,s),a(t,kt,s),a(t,T,s),r(T,x),r(x,ot),y(Y,ot,null),r(T,At),r(T,O),a(t,It,s),a(t,F,s),a(t,$t,s),a(t,b,s),r(b,k),r(k,pt),y(L,pt,null),r(b,Rt),r(b,tt),a(t,Nt,s),y(P,t,s),a(t,Zt,s),a(t,it,s),Wt=!0},p:we,i(t){Wt||(M(I.$$.fragment,t),M(N.$$.fragment,t),M(W.$$.fragment,t),M(_.$$.fragment,t),M(B.$$.fragment,t),M(S.$$.fragment,t),M(A.$$.fragment,t),M(z.$$.fragment,t),M(Y.$$.fragment,t),M(L.$$.fragment,t),M(P.$$.fragment,t),Wt=!0)},o(t){u(I.$$.fragment,t),u(N.$$.fragment,t),u(W.$$.fragment,t),u(_.$$.fragment,t),u(B.$$.fragment,t),u(S.$$.fragment,t),u(A.$$.fragment,t),u(z.$$.fragment,t),u(Y.$$.fragment,t),u(L.$$.fragment,t),u(P.$$.fragment,t),Wt=!1},d(t){t&&(e(ht),e(st),e(mt),e(J),e(ct),e($),e(dt),e(j),e(yt),e(Z),e(Mt),e(ut),e(E),e(wt),e(gt),e(G),e(Jt),e(jt),e(V),e(ft),e(Tt),e(X),e(bt),e(Q),e(vt),e(f),e(Ut),e(R),e(Ct),e(xt),e(H),e(kt),e(T),e(It),e(F),e($t),e(b),e(Nt),e(Zt),e(it)),e(g),w(I),w(N),w(W,t),w(_,t),w(B,t),w(S,t),w(A),w(z,t),w(Y),w(L),w(P,t)}}}const be={local:"legacy-seresnext",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"(Legacy) SE-ResNeXt"};function ve(zt){return ge(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ie extends Je{constructor(g){super(),je(this,g,ve,Te,ue,{})}}export{Ie as component};
