import{s as gt,o as vt,n as Mt}from"../chunks/scheduler.9bc65507.js";import{S as jt,i as _t,g as i,s as l,u as d,A as xt,h as o,f as s,c as n,j as v,v as c,y as r,k as h,o as m,a,w as f,d as y,t as u,x as w}from"../chunks/index.78c82d43.js";import{T as bt}from"../chunks/Tip.87d55b76.js";import{I as Ve}from"../chunks/IconCopyLink.bedaa44d.js";import{C}from"../chunks/CodeBlock.48618ec2.js";function kt(me){let p,T="Note that the randomly created model is initialized with “empty” tensors, which take the space in memory without filling it (thus the random values are whatever was in this chunk of memory at a given time). The random initialization following the appropriate distribution for the kind of model/parameters instantiated (like a normal distribution for instance) is only performed after step 3 on the non-initialized weights, to be as fast as possible!";return{c(){p=i("p"),p.textContent=T},l(g){p=o(g,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1e2x1qo"&&(p.textContent=T)},m(g,ae){a(g,p,ae)},p:Mt,d(g){g&&s(p)}}}function $t(me){let p,T,g,ae,M,x,oe,U,Ae,le,Fe="Instantiating a big model",de,J,qe=`When you want to use a very big pretrained model, one challenge is to minimize the use of the RAM. The usual workflow
from PyTorch is:`,ce,Z,Qe="<li>Create your model with random weights.</li> <li>Load your pretrained weights.</li> <li>Put those pretrained weights in your random model.</li>",fe,B,Ye="Step 1 and 2 both require a full version of the model in memory, which is not a problem in most cases, but if your model starts weighing several GigaBytes, those two copies can make you get out of RAM. Even worse, if you are using <code>torch.distributed</code> to launch a distributed training, each process will load the pretrained model and store these two copies in RAM.",ye,b,ue,R,Ke="In this guide, we explore the solutions Transformers offer to deal with this issue. Note that this is an area of active development, so the APIs explained here may change slightly in the future.",we,j,k,re,I,Ee,ne,De="Sharded checkpoints",ge,G,Oe="Since version 4.18.0, model checkpoints that end up taking more than 10GB of space are automatically sharded in smaller pieces. In terms of having one single checkpoint when you do <code>model.save_pretrained(save_dir)</code>, you will end up with several partial checkpoints (each of which being of size &lt; 10GB) and an index that maps parameter names to the files they are stored in.",ve,S,et="You can control the maximum size before sharding with the <code>max_shard_size</code> parameter, so for the sake of an example, we’ll use a normal-size models with a small shard size: let’s take a traditional BERT model.",Me,X,je,W,tt='If you save it using <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, you will get a new folder with two files: the config of the model and its weights:',_e,H,xe,L,st="Now let’s use a maximum shard size of 200MB:",be,z,ke,P,at='On top of the configuration of the model, we see three different weights files, and an <code>index.json</code> file which is our index. A checkpoint like this can be fully reloaded using the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method:',$e,A,Ce,E,lt="The main advantage of doing this for big models is that during step 2 of the workflow shown above, each shard of the checkpoint is loaded after the previous one, capping the memory usage in RAM to the model size plus the size of the biggest shard.",Te,N,nt="Behind the scenes, the index file is used to determine which keys are in the checkpoint, and where the corresponding weights are stored. We can load that index like any json and get a dictionary:",Ue,V,Je,F,it="The metadata just consists of the total size of the model for now. We plan to add other information in the future:",Ze,q,Be,Q,ot="The weights map is the main part of this index, which maps each parameter name (as usually found in a PyTorch model <code>state_dict</code>) to the file it’s stored in:",Re,Y,Ie,K,rt='If you want to directly load such a sharded checkpoint inside a model without using <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> (like you would do <code>model.load_state_dict()</code> for a full checkpoint) you should use <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.modeling_utils.load_sharded_checkpoint">load_sharded_checkpoint()</a>:',Ge,D,Se,_,$,pe,O,Ne,ie,pt="Low memory loading",Xe,ee,ht="Sharded checkpoints reduce the memory usage during step 2 of the workflow mentioned above, but in order to use that model in a low memory setting, we recommend leveraging our tools based on the Accelerate library.",We,te,mt='Please read the following guide for more information: <a href="./main_classes/model#large-model-loading">Large model loading using Accelerate</a>',He,he,Le;return U=new Ve({}),b=new bt({props:{$$slots:{default:[kt]},$$scope:{ctx:me}}}),I=new Ve({}),X=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel

model = AutoModel.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)`}}),H=new C({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0ZW1wZmlsZSUwQSUwQXdpdGglMjB0ZW1wZmlsZS5UZW1wb3JhcnlEaXJlY3RvcnkoKSUyMGFzJTIwdG1wX2RpciUzQSUwQSUyMCUyMCUyMCUyMG1vZGVsLnNhdmVfcHJldHJhaW5lZCh0bXBfZGlyKSUwQSUyMCUyMCUyMCUyMHByaW50KHNvcnRlZChvcy5saXN0ZGlyKHRtcF9kaXIpKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tempfile

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> tempfile.TemporaryDirectory() <span class="hljs-keyword">as</span> tmp_dir:
<span class="hljs-meta">... </span>    model.save_pretrained(tmp_dir)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-built_in">sorted</span>(os.listdir(tmp_dir)))
[<span class="hljs-string">&#x27;config.json&#x27;</span>, <span class="hljs-string">&#x27;pytorch_model.bin&#x27;</span>]`}}),z=new C({props:{code:"d2l0aCUyMHRlbXBmaWxlLlRlbXBvcmFyeURpcmVjdG9yeSgpJTIwYXMlMjB0bXBfZGlyJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKHRtcF9kaXIlMkMlMjBtYXhfc2hhcmRfc2l6ZSUzRCUyMjIwME1CJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KHNvcnRlZChvcy5saXN0ZGlyKHRtcF9kaXIpKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> tempfile.TemporaryDirectory() <span class="hljs-keyword">as</span> tmp_dir:
<span class="hljs-meta">... </span>    model.save_pretrained(tmp_dir, max_shard_size=<span class="hljs-string">&quot;200MB&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-built_in">sorted</span>(os.listdir(tmp_dir)))
[<span class="hljs-string">&#x27;config.json&#x27;</span>, <span class="hljs-string">&#x27;pytorch_model-00001-of-00003.bin&#x27;</span>, <span class="hljs-string">&#x27;pytorch_model-00002-of-00003.bin&#x27;</span>, <span class="hljs-string">&#x27;pytorch_model-00003-of-00003.bin&#x27;</span>, <span class="hljs-string">&#x27;pytorch_model.bin.index.json&#x27;</span>]`}}),A=new C({props:{code:"d2l0aCUyMHRlbXBmaWxlLlRlbXBvcmFyeURpcmVjdG9yeSgpJTIwYXMlMjB0bXBfZGlyJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKHRtcF9kaXIlMkMlMjBtYXhfc2hhcmRfc2l6ZSUzRCUyMjIwME1CJTIyKSUwQSUyMCUyMCUyMCUyMG5ld19tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQodG1wX2Rpcik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> tempfile.TemporaryDirectory() <span class="hljs-keyword">as</span> tmp_dir:
<span class="hljs-meta">... </span>    model.save_pretrained(tmp_dir, max_shard_size=<span class="hljs-string">&quot;200MB&quot;</span>)
<span class="hljs-meta">... </span>    new_model = AutoModel.from_pretrained(tmp_dir)`}}),V=new C({props:{code:"aW1wb3J0JTIwanNvbiUwQSUwQXdpdGglMjB0ZW1wZmlsZS5UZW1wb3JhcnlEaXJlY3RvcnkoKSUyMGFzJTIwdG1wX2RpciUzQSUwQSUyMCUyMCUyMCUyMG1vZGVsLnNhdmVfcHJldHJhaW5lZCh0bXBfZGlyJTJDJTIwbWF4X3NoYXJkX3NpemUlM0QlMjIyMDBNQiUyMiklMEElMjAlMjAlMjAlMjB3aXRoJTIwb3Blbihvcy5wYXRoLmpvaW4odG1wX2RpciUyQyUyMCUyMnB5dG9yY2hfbW9kZWwuYmluLmluZGV4Lmpzb24lMjIpJTJDJTIwJTIyciUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbmRleCUyMCUzRCUyMGpzb24ubG9hZChmKSUwQSUwQXByaW50KGluZGV4LmtleXMoKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> json

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> tempfile.TemporaryDirectory() <span class="hljs-keyword">as</span> tmp_dir:
<span class="hljs-meta">... </span>    model.save_pretrained(tmp_dir, max_shard_size=<span class="hljs-string">&quot;200MB&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(os.path.join(tmp_dir, <span class="hljs-string">&quot;pytorch_model.bin.index.json&quot;</span>), <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>        index = json.load(f)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(index.keys())
dict_keys([<span class="hljs-string">&#x27;metadata&#x27;</span>, <span class="hljs-string">&#x27;weight_map&#x27;</span>])`}}),q=new C({props:{code:"aW5kZXglNUIlMjJtZXRhZGF0YSUyMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>index[<span class="hljs-string">&quot;metadata&quot;</span>]
{<span class="hljs-string">&#x27;total_size&#x27;</span>: <span class="hljs-number">433245184</span>}`}}),Y=new C({props:{code:"aW5kZXglNUIlMjJ3ZWlnaHRfbWFwJTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>index[<span class="hljs-string">&quot;weight_map&quot;</span>]
{<span class="hljs-string">&#x27;embeddings.LayerNorm.bias&#x27;</span>: <span class="hljs-string">&#x27;pytorch_model-00001-of-00003.bin&#x27;</span>,
 <span class="hljs-string">&#x27;embeddings.LayerNorm.weight&#x27;</span>: <span class="hljs-string">&#x27;pytorch_model-00001-of-00003.bin&#x27;</span>,
 ...`}}),D=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5tb2RlbGluZ191dGlscyUyMGltcG9ydCUyMGxvYWRfc2hhcmRlZF9jaGVja3BvaW50JTBBJTBBd2l0aCUyMHRlbXBmaWxlLlRlbXBvcmFyeURpcmVjdG9yeSgpJTIwYXMlMjB0bXBfZGlyJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKHRtcF9kaXIlMkMlMjBtYXhfc2hhcmRfc2l6ZSUzRCUyMjIwME1CJTIyKSUwQSUyMCUyMCUyMCUyMGxvYWRfc2hhcmRlZF9jaGVja3BvaW50KG1vZGVsJTJDJTIwdG1wX2Rpcik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.modeling_utils <span class="hljs-keyword">import</span> load_sharded_checkpoint

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> tempfile.TemporaryDirectory() <span class="hljs-keyword">as</span> tmp_dir:
<span class="hljs-meta">... </span>    model.save_pretrained(tmp_dir, max_shard_size=<span class="hljs-string">&quot;200MB&quot;</span>)
<span class="hljs-meta">... </span>    load_sharded_checkpoint(model, tmp_dir)`}}),O=new Ve({}),{c(){p=i("meta"),T=l(),g=i("p"),ae=l(),M=i("h1"),x=i("a"),oe=i("span"),d(U.$$.fragment),Ae=l(),le=i("span"),le.textContent=Fe,de=l(),J=i("p"),J.textContent=qe,ce=l(),Z=i("ol"),Z.innerHTML=Qe,fe=l(),B=i("p"),B.innerHTML=Ye,ye=l(),d(b.$$.fragment),ue=l(),R=i("p"),R.textContent=Ke,we=l(),j=i("h2"),k=i("a"),re=i("span"),d(I.$$.fragment),Ee=l(),ne=i("span"),ne.textContent=De,ge=l(),G=i("p"),G.innerHTML=Oe,ve=l(),S=i("p"),S.innerHTML=et,Me=l(),d(X.$$.fragment),je=l(),W=i("p"),W.innerHTML=tt,_e=l(),d(H.$$.fragment),xe=l(),L=i("p"),L.textContent=st,be=l(),d(z.$$.fragment),ke=l(),P=i("p"),P.innerHTML=at,$e=l(),d(A.$$.fragment),Ce=l(),E=i("p"),E.textContent=lt,Te=l(),N=i("p"),N.textContent=nt,Ue=l(),d(V.$$.fragment),Je=l(),F=i("p"),F.textContent=it,Ze=l(),d(q.$$.fragment),Be=l(),Q=i("p"),Q.innerHTML=ot,Re=l(),d(Y.$$.fragment),Ie=l(),K=i("p"),K.innerHTML=rt,Ge=l(),d(D.$$.fragment),Se=l(),_=i("h2"),$=i("a"),pe=i("span"),d(O.$$.fragment),Ne=l(),ie=i("span"),ie.textContent=pt,Xe=l(),ee=i("p"),ee.textContent=ht,We=l(),te=i("p"),te.innerHTML=mt,He=l(),he=i("p"),this.h()},l(e){const t=xt("svelte-1phssyn",document.head);p=o(t,"META",{name:!0,content:!0}),t.forEach(s),T=n(e),g=o(e,"P",{}),v(g).forEach(s),ae=n(e),M=o(e,"H1",{class:!0});var se=v(M);x=o(se,"A",{id:!0,class:!0,href:!0});var dt=v(x);oe=o(dt,"SPAN",{});var ct=v(oe);c(U.$$.fragment,ct),ct.forEach(s),dt.forEach(s),Ae=n(se),le=o(se,"SPAN",{"data-svelte-h":!0}),r(le)!=="svelte-x7cw7w"&&(le.textContent=Fe),se.forEach(s),de=n(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-tq7fyu"&&(J.textContent=qe),ce=n(e),Z=o(e,"OL",{"data-svelte-h":!0}),r(Z)!=="svelte-zd4gvw"&&(Z.innerHTML=Qe),fe=n(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-jgtxxx"&&(B.innerHTML=Ye),ye=n(e),c(b.$$.fragment,e),ue=n(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1371yn4"&&(R.textContent=Ke),we=n(e),j=o(e,"H2",{class:!0});var ze=v(j);k=o(ze,"A",{id:!0,class:!0,href:!0});var ft=v(k);re=o(ft,"SPAN",{});var yt=v(re);c(I.$$.fragment,yt),yt.forEach(s),ft.forEach(s),Ee=n(ze),ne=o(ze,"SPAN",{"data-svelte-h":!0}),r(ne)!=="svelte-fjglj1"&&(ne.textContent=De),ze.forEach(s),ge=n(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-ojzv91"&&(G.innerHTML=Oe),ve=n(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-359nk0"&&(S.innerHTML=et),Me=n(e),c(X.$$.fragment,e),je=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1k41kop"&&(W.innerHTML=tt),_e=n(e),c(H.$$.fragment,e),xe=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1iiexi6"&&(L.textContent=st),be=n(e),c(z.$$.fragment,e),ke=n(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-8gspiw"&&(P.innerHTML=at),$e=n(e),c(A.$$.fragment,e),Ce=n(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-15d1ip4"&&(E.textContent=lt),Te=n(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-13hv0w1"&&(N.textContent=nt),Ue=n(e),c(V.$$.fragment,e),Je=n(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1j0lyu1"&&(F.textContent=it),Ze=n(e),c(q.$$.fragment,e),Be=n(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-pjyzcz"&&(Q.innerHTML=ot),Re=n(e),c(Y.$$.fragment,e),Ie=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1vs2zl7"&&(K.innerHTML=rt),Ge=n(e),c(D.$$.fragment,e),Se=n(e),_=o(e,"H2",{class:!0});var Pe=v(_);$=o(Pe,"A",{id:!0,class:!0,href:!0});var ut=v($);pe=o(ut,"SPAN",{});var wt=v(pe);c(O.$$.fragment,wt),wt.forEach(s),ut.forEach(s),Ne=n(Pe),ie=o(Pe,"SPAN",{"data-svelte-h":!0}),r(ie)!=="svelte-45wrlq"&&(ie.textContent=pt),Pe.forEach(s),Xe=n(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1knub2o"&&(ee.textContent=ht),We=n(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-112uj1w"&&(te.innerHTML=mt),He=n(e),he=o(e,"P",{}),v(he).forEach(s),this.h()},h(){h(p,"name","hf:doc:metadata"),h(p,"content",JSON.stringify(Ct)),h(x,"id","instantiating-a-big-model"),h(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(x,"href","#instantiating-a-big-model"),h(M,"class","relative group"),h(k,"id","sharded-checkpoints"),h(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(k,"href","#sharded-checkpoints"),h(j,"class","relative group"),h($,"id","low-memory-loading"),h($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h($,"href","#low-memory-loading"),h(_,"class","relative group")},m(e,t){m(document.head,p),a(e,T,t),a(e,g,t),a(e,ae,t),a(e,M,t),m(M,x),m(x,oe),f(U,oe,null),m(M,Ae),m(M,le),a(e,de,t),a(e,J,t),a(e,ce,t),a(e,Z,t),a(e,fe,t),a(e,B,t),a(e,ye,t),f(b,e,t),a(e,ue,t),a(e,R,t),a(e,we,t),a(e,j,t),m(j,k),m(k,re),f(I,re,null),m(j,Ee),m(j,ne),a(e,ge,t),a(e,G,t),a(e,ve,t),a(e,S,t),a(e,Me,t),f(X,e,t),a(e,je,t),a(e,W,t),a(e,_e,t),f(H,e,t),a(e,xe,t),a(e,L,t),a(e,be,t),f(z,e,t),a(e,ke,t),a(e,P,t),a(e,$e,t),f(A,e,t),a(e,Ce,t),a(e,E,t),a(e,Te,t),a(e,N,t),a(e,Ue,t),f(V,e,t),a(e,Je,t),a(e,F,t),a(e,Ze,t),f(q,e,t),a(e,Be,t),a(e,Q,t),a(e,Re,t),f(Y,e,t),a(e,Ie,t),a(e,K,t),a(e,Ge,t),f(D,e,t),a(e,Se,t),a(e,_,t),m(_,$),m($,pe),f(O,pe,null),m(_,Ne),m(_,ie),a(e,Xe,t),a(e,ee,t),a(e,We,t),a(e,te,t),a(e,He,t),a(e,he,t),Le=!0},p(e,[t]){const se={};t&2&&(se.$$scope={dirty:t,ctx:e}),b.$set(se)},i(e){Le||(y(U.$$.fragment,e),y(b.$$.fragment,e),y(I.$$.fragment,e),y(X.$$.fragment,e),y(H.$$.fragment,e),y(z.$$.fragment,e),y(A.$$.fragment,e),y(V.$$.fragment,e),y(q.$$.fragment,e),y(Y.$$.fragment,e),y(D.$$.fragment,e),y(O.$$.fragment,e),Le=!0)},o(e){u(U.$$.fragment,e),u(b.$$.fragment,e),u(I.$$.fragment,e),u(X.$$.fragment,e),u(H.$$.fragment,e),u(z.$$.fragment,e),u(A.$$.fragment,e),u(V.$$.fragment,e),u(q.$$.fragment,e),u(Y.$$.fragment,e),u(D.$$.fragment,e),u(O.$$.fragment,e),Le=!1},d(e){e&&(s(T),s(g),s(ae),s(M),s(de),s(J),s(ce),s(Z),s(fe),s(B),s(ye),s(ue),s(R),s(we),s(j),s(ge),s(G),s(ve),s(S),s(Me),s(je),s(W),s(_e),s(xe),s(L),s(be),s(ke),s(P),s($e),s(Ce),s(E),s(Te),s(N),s(Ue),s(Je),s(F),s(Ze),s(Be),s(Q),s(Re),s(Ie),s(K),s(Ge),s(Se),s(_),s(Xe),s(ee),s(We),s(te),s(He),s(he)),s(p),w(U),w(b,e),w(I),w(X,e),w(H,e),w(z,e),w(A,e),w(V,e),w(q,e),w(Y,e),w(D,e),w(O)}}}const Ct={local:"instantiating-a-big-model",sections:[{local:"sharded-checkpoints",title:"Sharded checkpoints"},{local:"low-memory-loading",title:"Low memory loading"}],title:"Instantiating a big model"};function Tt(me){return vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class It extends jt{constructor(p){super(),_t(this,p,Tt,$t,gt,{})}}export{It as component};
