import{s as Ci,o as zi,n as z}from"../chunks/scheduler.9bc65507.js";import{S as Fi,i as Ji,g as o,s as a,u as g,m as Ei,A as ji,h as s,f as n,c as i,j as f,v as _,y as u,n as xi,k as h,o as t,a as p,w as y,d as b,t as v,x as T}from"../chunks/index.78c82d43.js";import{T as be}from"../chunks/Tip.87d55b76.js";import{D as E}from"../chunks/Docstring.f3d04bd2.js";import{C as st}from"../chunks/CodeBlock.48618ec2.js";import{I as C}from"../chunks/IconCopyLink.bedaa44d.js";import{E as Yt}from"../chunks/ExampleCodeBlock.872b014d.js";function Li(w){let r,k="Examples:",c,m,M;return m=new st({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEVybmllQ29uZmlnJTJDJTIwRXJuaWVNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBFUk5JRSUyMG5naHV5b25nJTJGZXJuaWUtMy4wLWJhc2UtemglMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwRXJuaWVDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwbmdodXlvbmclMkZlcm5pZS0zLjAtYmFzZS16aCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwRXJuaWVNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ErnieConfig, ErnieModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a ERNIE nghuyong/ernie-3.0-base-zh style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = ErnieConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the nghuyong/ernie-3.0-base-zh style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ErnieModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`}}),{c(){r=o("p"),r.textContent=k,c=a(),g(m.$$.fragment)},l(d){r=s(d,"P",{"data-svelte-h":!0}),u(r)!=="svelte-kvfsh7"&&(r.textContent=k),c=i(d),_(m.$$.fragment,d)},m(d,$){p(d,r,$),p(d,c,$),y(m,d,$),M=!0},p:z,i(d){M||(b(m.$$.fragment,d),M=!0)},o(d){v(m.$$.fragment,d),M=!1},d(d){d&&(n(r),n(c)),T(m,d)}}}function Ii(w){let r,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=o("p"),r.innerHTML=k},l(c){r=s(c,"P",{"data-svelte-h":!0}),u(r)!=="svelte-fincs2"&&(r.innerHTML=k)},m(c,m){p(c,r,m)},p:z,d(c){c&&n(r)}}}function Ni(w){let r,k="Example:",c,m,M;return m=new st({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBFcm5pZU1vZGVsJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJuZ2h1eW9uZyUyRmVybmllLTEuMC1iYXNlLXpoJTIyKSUwQW1vZGVsJTIwJTNEJTIwRXJuaWVNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIybmdodXlvbmclMkZlcm5pZS0xLjAtYmFzZS16aCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ErnieModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;nghuyong/ernie-1.0-base-zh&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ErnieModel.from_pretrained(<span class="hljs-string">&quot;nghuyong/ernie-1.0-base-zh&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`}}),{c(){r=o("p"),r.textContent=k,c=a(),g(m.$$.fragment)},l(d){r=s(d,"P",{"data-svelte-h":!0}),u(r)!=="svelte-11lpom8"&&(r.textContent=k),c=i(d),_(m.$$.fragment,d)},m(d,$){p(d,r,$),p(d,c,$),y(m,d,$),M=!0},p:z,i(d){M||(b(m.$$.fragment,d),M=!0)},o(d){v(m.$$.fragment,d),M=!1},d(d){d&&(n(r),n(c)),T(m,d)}}}function Pi(w){let r,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=o("p"),r.innerHTML=k},l(c){r=s(c,"P",{"data-svelte-h":!0}),u(r)!=="svelte-fincs2"&&(r.innerHTML=k)},m(c,m){p(c,r,m)},p:z,d(c){c&&n(r)}}}function qi(w){let r,k="Example:",c,m,M;return m=new st({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBFcm5pZUZvclByZVRyYWluaW5nJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJuZ2h1eW9uZyUyRmVybmllLTEuMC1iYXNlLXpoJTIyKSUwQW1vZGVsJTIwJTNEJTIwRXJuaWVGb3JQcmVUcmFpbmluZy5mcm9tX3ByZXRyYWluZWQoJTIybmdodXlvbmclMkZlcm5pZS0xLjAtYmFzZS16aCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQXByZWRpY3Rpb25fbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5wcmVkaWN0aW9uX2xvZ2l0cyUwQXNlcV9yZWxhdGlvbnNoaXBfbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5zZXFfcmVsYXRpb25zaGlwX2xvZ2l0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ErnieForPreTraining
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;nghuyong/ernie-1.0-base-zh&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ErnieForPreTraining.from_pretrained(<span class="hljs-string">&quot;nghuyong/ernie-1.0-base-zh&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>prediction_logits = outputs.prediction_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>seq_relationship_logits = outputs.seq_relationship_logits`}}),{c(){r=o("p"),r.textContent=k,c=a(),g(m.$$.fragment)},l(d){r=s(d,"P",{"data-svelte-h":!0}),u(r)!=="svelte-11lpom8"&&(r.textContent=k),c=i(d),_(m.$$.fragment,d)},m(d,$){p(d,r,$),p(d,c,$),y(m,d,$),M=!0},p:z,i(d){M||(b(m.$$.fragment,d),M=!0)},o(d){v(m.$$.fragment,d),M=!1},d(d){d&&(n(r),n(c)),T(m,d)}}}function Ui(w){let r,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=o("p"),r.innerHTML=k},l(c){r=s(c,"P",{"data-svelte-h":!0}),u(r)!=="svelte-fincs2"&&(r.innerHTML=k)},m(c,m){p(c,r,m)},p:z,d(c){c&&n(r)}}}function Wi(w){let r,k="Example:",c,m,M;return m=new st({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEVybmllRm9yQ2F1c2FsTE0lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJuZ2h1eW9uZyUyRmVybmllLTEuMC1iYXNlLXpoJTIyKSUwQW1vZGVsJTIwJTNEJTIwRXJuaWVGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybmdodXlvbmclMkZlcm5pZS0xLjAtYmFzZS16aCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwbGFiZWxzJTNEaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ErnieForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;nghuyong/ernie-1.0-base-zh&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ErnieForCausalLM.from_pretrained(<span class="hljs-string">&quot;nghuyong/ernie-1.0-base-zh&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`}}),{c(){r=o("p"),r.textContent=k,c=a(),g(m.$$.fragment)},l(d){r=s(d,"P",{"data-svelte-h":!0}),u(r)!=="svelte-11lpom8"&&(r.textContent=k),c=i(d),_(m.$$.fragment,d)},m(d,$){p(d,r,$),p(d,c,$),y(m,d,$),M=!0},p:z,i(d){M||(b(m.$$.fragment,d),M=!0)},o(d){v(m.$$.fragment,d),M=!1},d(d){d&&(n(r),n(c)),T(m,d)}}}function Hi(w){let r,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=o("p"),r.innerHTML=k},l(c){r=s(c,"P",{"data-svelte-h":!0}),u(r)!=="svelte-fincs2"&&(r.innerHTML=k)},m(c,m){p(c,r,m)},p:z,d(c){c&&n(r)}}}function Zi(w){let r,k="Example:",c,m,M;return m=new st({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBFcm5pZUZvck1hc2tlZExNJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJuZ2h1eW9uZyUyRmVybmllLTEuMC1iYXNlLXpoJTIyKSUwQW1vZGVsJTIwJTNEJTIwRXJuaWVGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIybmdodXlvbmclMkZlcm5pZS0xLjAtYmFzZS16aCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjAlNUJNQVNLJTVELiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEElMjMlMjByZXRyaWV2ZSUyMGluZGV4JTIwb2YlMjAlNUJNQVNLJTVEJTBBbWFza190b2tlbl9pbmRleCUyMCUzRCUyMChpbnB1dHMuaW5wdXRfaWRzJTIwJTNEJTNEJTIwdG9rZW5pemVyLm1hc2tfdG9rZW5faWQpJTVCMCU1RC5ub256ZXJvKGFzX3R1cGxlJTNEVHJ1ZSklNUIwJTVEJTBBJTBBcHJlZGljdGVkX3Rva2VuX2lkJTIwJTNEJTIwbG9naXRzJTVCMCUyQyUyMG1hc2tfdG9rZW5faW5kZXglNUQuYXJnbWF4KGF4aXMlM0QtMSklMEF0b2tlbml6ZXIuZGVjb2RlKHByZWRpY3RlZF90b2tlbl9pZCklMEElMEFsYWJlbHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSU1QiUyMmlucHV0X2lkcyUyMiU1RCUwQSUyMyUyMG1hc2slMjBsYWJlbHMlMjBvZiUyMG5vbi0lNUJNQVNLJTVEJTIwdG9rZW5zJTBBbGFiZWxzJTIwJTNEJTIwdG9yY2gud2hlcmUoaW5wdXRzLmlucHV0X2lkcyUyMCUzRCUzRCUyMHRva2VuaXplci5tYXNrX3Rva2VuX2lkJTJDJTIwbGFiZWxzJTJDJTIwLTEwMCklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpJTBBcm91bmQob3V0cHV0cy5sb3NzLml0ZW0oKSUyQyUyMDIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ErnieForMaskedLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;nghuyong/ernie-1.0-base-zh&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ErnieForMaskedLM.from_pretrained(<span class="hljs-string">&quot;nghuyong/ernie-1.0-base-zh&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;The capital of France is [MASK].&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># retrieve index of [MASK]</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_token_index = (inputs.input_ids == tokenizer.mask_token_id)[<span class="hljs-number">0</span>].nonzero(as_tuple=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_token_id = logits[<span class="hljs-number">0</span>, mask_token_index].argmax(axis=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(predicted_token_id)
<span class="hljs-string">&#x27;paris&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(<span class="hljs-string">&quot;The capital of France is Paris.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># mask labels of non-[MASK] tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.where(inputs.input_ids == tokenizer.mask_token_id, labels, -<span class="hljs-number">100</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(outputs.loss.item(), <span class="hljs-number">2</span>)
<span class="hljs-number">0.88</span>`}}),{c(){r=o("p"),r.textContent=k,c=a(),g(m.$$.fragment)},l(d){r=s(d,"P",{"data-svelte-h":!0}),u(r)!=="svelte-11lpom8"&&(r.textContent=k),c=i(d),_(m.$$.fragment,d)},m(d,$){p(d,r,$),p(d,c,$),y(m,d,$),M=!0},p:z,i(d){M||(b(m.$$.fragment,d),M=!0)},o(d){v(m.$$.fragment,d),M=!1},d(d){d&&(n(r),n(c)),T(m,d)}}}function Si(w){let r,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=o("p"),r.innerHTML=k},l(c){r=s(c,"P",{"data-svelte-h":!0}),u(r)!=="svelte-fincs2"&&(r.innerHTML=k)},m(c,m){p(c,r,m)},p:z,d(c){c&&n(r)}}}function Ai(w){let r,k="Example:",c,m,M;return m=new st({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBFcm5pZUZvck5leHRTZW50ZW5jZVByZWRpY3Rpb24lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm5naHV5b25nJTJGZXJuaWUtMS4wLWJhc2UtemglMjIpJTBBbW9kZWwlMjAlM0QlMjBFcm5pZUZvck5leHRTZW50ZW5jZVByZWRpY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm5naHV5b25nJTJGZXJuaWUtMS4wLWJhc2UtemglMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIySW4lMjBJdGFseSUyQyUyMHBpenphJTIwc2VydmVkJTIwaW4lMjBmb3JtYWwlMjBzZXR0aW5ncyUyQyUyMHN1Y2glMjBhcyUyMGF0JTIwYSUyMHJlc3RhdXJhbnQlMkMlMjBpcyUyMHByZXNlbnRlZCUyMHVuc2xpY2VkLiUyMiUwQW5leHRfc2VudGVuY2UlMjAlM0QlMjAlMjJUaGUlMjBza3klMjBpcyUyMGJsdWUlMjBkdWUlMjB0byUyMHRoZSUyMHNob3J0ZXIlMjB3YXZlbGVuZ3RoJTIwb2YlMjBibHVlJTIwbGlnaHQuJTIyJTBBZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwbmV4dF9zZW50ZW5jZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqZW5jb2RpbmclMkMlMjBsYWJlbHMlM0R0b3JjaC5Mb25nVGVuc29yKCU1QjElNUQpKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBYXNzZXJ0JTIwbG9naXRzJTVCMCUyQyUyMDAlNUQlMjAlM0MlMjBsb2dpdHMlNUIwJTJDJTIwMSU1RCUyMCUyMCUyMyUyMG5leHQlMjBzZW50ZW5jZSUyMHdhcyUyMHJhbmRvbQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ErnieForNextSentencePrediction
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;nghuyong/ernie-1.0-base-zh&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ErnieForNextSentencePrediction.from_pretrained(<span class="hljs-string">&quot;nghuyong/ernie-1.0-base-zh&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;In Italy, pizza served in formal settings, such as at a restaurant, is presented unsliced.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>next_sentence = <span class="hljs-string">&quot;The sky is blue due to the shorter wavelength of blue light.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = tokenizer(prompt, next_sentence, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**encoding, labels=torch.LongTensor([<span class="hljs-number">1</span>]))
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> logits[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>] &lt; logits[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>]  <span class="hljs-comment"># next sentence was random</span>`}}),{c(){r=o("p"),r.textContent=k,c=a(),g(m.$$.fragment)},l(d){r=s(d,"P",{"data-svelte-h":!0}),u(r)!=="svelte-11lpom8"&&(r.textContent=k),c=i(d),_(m.$$.fragment,d)},m(d,$){p(d,r,$),p(d,c,$),y(m,d,$),M=!0},p:z,i(d){M||(b(m.$$.fragment,d),M=!0)},o(d){v(m.$$.fragment,d),M=!1},d(d){d&&(n(r),n(c)),T(m,d)}}}function Bi(w){let r,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=o("p"),r.innerHTML=k},l(c){r=s(c,"P",{"data-svelte-h":!0}),u(r)!=="svelte-fincs2"&&(r.innerHTML=k)},m(c,m){p(c,r,m)},p:z,d(c){c&&n(r)}}}function Ri(w){let r,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=o("p"),r.innerHTML=k},l(c){r=s(c,"P",{"data-svelte-h":!0}),u(r)!=="svelte-fincs2"&&(r.innerHTML=k)},m(c,m){p(c,r,m)},p:z,d(c){c&&n(r)}}}function Oi(w){let r,k="Example:",c,m,M;return m=new st({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBFcm5pZUZvck11bHRpcGxlQ2hvaWNlJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJuZ2h1eW9uZyUyRmVybmllLTEuMC1iYXNlLXpoJTIyKSUwQW1vZGVsJTIwJTNEJTIwRXJuaWVGb3JNdWx0aXBsZUNob2ljZS5mcm9tX3ByZXRyYWluZWQoJTIybmdodXlvbmclMkZlcm5pZS0xLjAtYmFzZS16aCUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJJbiUyMEl0YWx5JTJDJTIwcGl6emElMjBzZXJ2ZWQlMjBpbiUyMGZvcm1hbCUyMHNldHRpbmdzJTJDJTIwc3VjaCUyMGFzJTIwYXQlMjBhJTIwcmVzdGF1cmFudCUyQyUyMGlzJTIwcHJlc2VudGVkJTIwdW5zbGljZWQuJTIyJTBBY2hvaWNlMCUyMCUzRCUyMCUyMkl0JTIwaXMlMjBlYXRlbiUyMHdpdGglMjBhJTIwZm9yayUyMGFuZCUyMGElMjBrbmlmZS4lMjIlMEFjaG9pY2UxJTIwJTNEJTIwJTIySXQlMjBpcyUyMGVhdGVuJTIwd2hpbGUlMjBoZWxkJTIwaW4lMjB0aGUlMjBoYW5kLiUyMiUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvcigwKS51bnNxdWVlemUoMCklMjAlMjAlMjMlMjBjaG9pY2UwJTIwaXMlMjBjb3JyZWN0JTIwKGFjY29yZGluZyUyMHRvJTIwV2lraXBlZGlhJTIwJTNCKSklMkMlMjBiYXRjaCUyMHNpemUlMjAxJTBBJTBBZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIoJTVCcHJvbXB0JTJDJTIwcHJvbXB0JTVEJTJDJTIwJTVCY2hvaWNlMCUyQyUyMGNob2ljZTElNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqJTdCayUzQSUyMHYudW5zcXVlZXplKDApJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGVuY29kaW5nLml0ZW1zKCklN0QlMkMlMjBsYWJlbHMlM0RsYWJlbHMpJTIwJTIwJTIzJTIwYmF0Y2glMjBzaXplJTIwaXMlMjAxJTBBJTBBJTIzJTIwdGhlJTIwbGluZWFyJTIwY2xhc3NpZmllciUyMHN0aWxsJTIwbmVlZHMlMjB0byUyMGJlJTIwdHJhaW5lZCUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ErnieForMultipleChoice
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;nghuyong/ernie-1.0-base-zh&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ErnieForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;nghuyong/ernie-1.0-base-zh&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;In Italy, pizza served in formal settings, such as at a restaurant, is presented unsliced.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>choice0 = <span class="hljs-string">&quot;It is eaten with a fork and a knife.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>choice1 = <span class="hljs-string">&quot;It is eaten while held in the hand.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor(<span class="hljs-number">0</span>).unsqueeze(<span class="hljs-number">0</span>)  <span class="hljs-comment"># choice0 is correct (according to Wikipedia ;)), batch size 1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = tokenizer([prompt, prompt], [choice0, choice1], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**{k: v.unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> encoding.items()}, labels=labels)  <span class="hljs-comment"># batch size is 1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the linear classifier still needs to be trained</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`}}),{c(){r=o("p"),r.textContent=k,c=a(),g(m.$$.fragment)},l(d){r=s(d,"P",{"data-svelte-h":!0}),u(r)!=="svelte-11lpom8"&&(r.textContent=k),c=i(d),_(m.$$.fragment,d)},m(d,$){p(d,r,$),p(d,c,$),y(m,d,$),M=!0},p:z,i(d){M||(b(m.$$.fragment,d),M=!0)},o(d){v(m.$$.fragment,d),M=!1},d(d){d&&(n(r),n(c)),T(m,d)}}}function Vi(w){let r,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=o("p"),r.innerHTML=k},l(c){r=s(c,"P",{"data-svelte-h":!0}),u(r)!=="svelte-fincs2"&&(r.innerHTML=k)},m(c,m){p(c,r,m)},p:z,d(c){c&&n(r)}}}function Xi(w){let r,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=o("p"),r.innerHTML=k},l(c){r=s(c,"P",{"data-svelte-h":!0}),u(r)!=="svelte-fincs2"&&(r.innerHTML=k)},m(c,m){p(c,r,m)},p:z,d(c){c&&n(r)}}}function Gi(w){let r,k,c,m,M,d,$,rt,Ms,Kt,Dr="ERNIE",Lo,oe,ve,ao,at,ws,en,Yr="Overview",Io,it,Kr='These models are contributed by <a href="https://huggingface.co/nghuyong" rel="nofollow">nghuyong</a> and the official code can be found in <a href="https://github.com/PaddlePaddle/PaddleNLP" rel="nofollow">PaddleNLP</a> (in PaddlePaddle).',No,se,Te,io,dt,$s,tn,ea="How to use",Po,lt,qo,re,ke,lo,ct,Es,nn,ta="Supported Models",Uo,pt,na='<thead><tr><th align="center">Model Name</th> <th align="center">Language</th> <th align="center">Description</th></tr></thead> <tbody><tr><td align="center">ernie-1.0-base-zh</td> <td align="center">Chinese</td> <td align="center">Layer:12, Heads:12, Hidden:768</td></tr> <tr><td align="center">ernie-2.0-base-en</td> <td align="center">English</td> <td align="center">Layer:12, Heads:12, Hidden:768</td></tr> <tr><td align="center">ernie-2.0-large-en</td> <td align="center">English</td> <td align="center">Layer:24, Heads:16, Hidden:1024</td></tr> <tr><td align="center">ernie-3.0-base-zh</td> <td align="center">Chinese</td> <td align="center">Layer:12, Heads:12, Hidden:768</td></tr> <tr><td align="center">ernie-3.0-medium-zh</td> <td align="center">Chinese</td> <td align="center">Layer:6, Heads:12, Hidden:768</td></tr> <tr><td align="center">ernie-3.0-mini-zh</td> <td align="center">Chinese</td> <td align="center">Layer:6, Heads:12, Hidden:384</td></tr> <tr><td align="center">ernie-3.0-micro-zh</td> <td align="center">Chinese</td> <td align="center">Layer:4, Heads:12, Hidden:384</td></tr> <tr><td align="center">ernie-3.0-nano-zh</td> <td align="center">Chinese</td> <td align="center">Layer:4, Heads:12, Hidden:312</td></tr> <tr><td align="center">ernie-health-zh</td> <td align="center">Chinese</td> <td align="center">Layer:12, Heads:12, Hidden:768</td></tr> <tr><td align="center">ernie-gram-zh</td> <td align="center">Chinese</td> <td align="center">Layer:12, Heads:12, Hidden:768</td></tr></tbody>',Wo,ht,oa=`You can find all the supported models from huggingface’s model hub: <a href="https://huggingface.co/nghuyong" rel="nofollow">huggingface.co/nghuyong</a>, and model details from paddle’s official
repo: <a href="https://paddlenlp.readthedocs.io/zh/latest/model_zoo/transformers/ERNIE/contents.html" rel="nofollow">PaddleNLP</a>
and <a href="https://github.com/PaddlePaddle/ERNIE/blob/repro" rel="nofollow">ERNIE</a>.`,Ho,ae,Me,co,mt,xs,on,sa="Documentation resources",Zo,ut,ra='<li><a href="../tasks/sequence_classification">Text classification task guide</a></li> <li><a href="../tasks/token_classification">Token classification task guide</a></li> <li><a href="../tasks/question_answering">Question answering task guide</a></li> <li><a href="../tasks/language_modeling">Causal language modeling task guide</a></li> <li><a href="../tasks/masked_language_modeling">Masked language modeling task guide</a></li> <li><a href="../tasks/multiple_choice">Multiple choice task guide</a></li>',So,ie,we,po,ft,Cs,sn,aa="ErnieConfig",Ao,W,gt,zs,rn,ia=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.33.3/en/model_doc/ernie#transformers.ErnieModel">ErnieModel</a> or a <code>TFErnieModel</code>. It is used to
instantiate a ERNIE model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the ERNIE
<a href="https://huggingface.co/nghuyong/ernie-3.0-base-zh" rel="nofollow">nghuyong/ernie-3.0-base-zh</a> architecture.`,Fs,an,da=`Configuration objects inherit from <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Js,$e,Bo,de,Ee,ho,_t,js,dn,la="Ernie specific outputs",Ro,le,yt,Ls,ln,ca='Output type of <a href="/docs/transformers/v4.33.3/en/model_doc/ernie#transformers.ErnieForPreTraining">ErnieForPreTraining</a>.',Oo,ce,xe,mo,bt,Is,cn,pa="ErnieModel",Vo,x,vt,Ns,pn,ha="The bare Ernie Model transformer outputting raw hidden-states without any specific head on top.",Ps,hn,ma=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,qs,mn,ua=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Us,un,fa=`The model can behave as an encoder (with only self-attention) as well as a decoder, in which case a layer of
cross-attention is added between the self-attention layers, following the architecture described in <a href="https://arxiv.org/abs/1706.03762" rel="nofollow">Attention is
all you need</a> by Ashish Vaswani, Noam Shazeer, Niki Parmar, Jakob Uszkoreit,
Llion Jones, Aidan N. Gomez, Lukasz Kaiser and Illia Polosukhin.`,Ws,fn,ga=`To behave as an decoder the model needs to be initialized with the <code>is_decoder</code> argument of the configuration set
to <code>True</code>. To be used in a Seq2Seq model, the model needs to initialized with both <code>is_decoder</code> argument and
<code>add_cross_attention</code> set to <code>True</code>; an <code>encoder_hidden_states</code> is then expected as an input to the forward pass.`,Hs,H,Tt,Zs,gn,_a='The <a href="/docs/transformers/v4.33.3/en/model_doc/ernie#transformers.ErnieModel">ErnieModel</a> forward method, overrides the <code>__call__</code> special method.',Ss,Ce,As,ze,Xo,pe,Fe,uo,kt,Bs,_n,ya="ErnieForPreTraining",Go,F,Mt,Rs,yn,ba="Ernie Model with two heads on top as done during the pretraining: a <code>masked language modeling</code> head and a <code>next sentence prediction (classification)</code> head.",Os,bn,va=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Vs,vn,Ta=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Xs,Z,wt,Gs,Tn,ka='The <a href="/docs/transformers/v4.33.3/en/model_doc/ernie#transformers.ErnieForPreTraining">ErnieForPreTraining</a> forward method, overrides the <code>__call__</code> special method.',Qs,Je,Ds,je,Qo,he,Le,fo,$t,Ys,kn,Ma="ErnieForCausalLM",Do,J,Et,Ks,Mn,wa="Ernie Model with a <code>language modeling</code> head on top for CLM fine-tuning.",er,wn,$a=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,tr,$n,Ea=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,nr,S,xt,or,En,xa='The <a href="/docs/transformers/v4.33.3/en/model_doc/ernie#transformers.ErnieForCausalLM">ErnieForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',sr,Ie,rr,Ne,Yo,me,Pe,go,Ct,ar,xn,Ca="ErnieForMaskedLM",Ko,j,zt,ir,Cn,za="Ernie Model with a <code>language modeling</code> head on top.",dr,zn,Fa=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,lr,Fn,Ja=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,cr,A,Ft,pr,Jn,ja='The <a href="/docs/transformers/v4.33.3/en/model_doc/ernie#transformers.ErnieForMaskedLM">ErnieForMaskedLM</a> forward method, overrides the <code>__call__</code> special method.',hr,qe,mr,Ue,es,ue,We,_o,Jt,ur,jn,La="ErnieForNextSentencePrediction",ts,L,jt,fr,Ln,Ia="Ernie Model with a <code>next sentence prediction (classification)</code> head on top.",gr,In,Na=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,_r,Nn,Pa=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,yr,B,Lt,br,Pn,qa='The <a href="/docs/transformers/v4.33.3/en/model_doc/ernie#transformers.ErnieForNextSentencePrediction">ErnieForNextSentencePrediction</a> forward method, overrides the <code>__call__</code> special method.',vr,He,Tr,Ze,ns,fe,Se,yo,It,kr,qn,Ua="ErnieForSequenceClassification",os,I,Nt,Mr,Un,Wa=`Ernie Model transformer with a sequence classification/regression head on top (a linear layer on top of the pooled
output) e.g. for GLUE tasks.`,wr,Wn,Ha=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,$r,Hn,Za=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Er,O,Pt,xr,Zn,Sa='The <a href="/docs/transformers/v4.33.3/en/model_doc/ernie#transformers.ErnieForSequenceClassification">ErnieForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',Cr,Ae,ss,ge,Be,bo,qt,zr,Sn,Aa="ErnieForMultipleChoice",rs,N,Ut,Fr,An,Ba=`Ernie Model with a multiple choice classification head on top (a linear layer on top of the pooled output and a
softmax) e.g. for RocStories/SWAG tasks.`,Jr,Bn,Ra=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,jr,Rn,Oa=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Lr,R,Wt,Ir,On,Va='The <a href="/docs/transformers/v4.33.3/en/model_doc/ernie#transformers.ErnieForMultipleChoice">ErnieForMultipleChoice</a> forward method, overrides the <code>__call__</code> special method.',Nr,Re,Pr,Oe,as,_e,Ve,vo,Ht,qr,Vn,Xa="ErnieForTokenClassification",is,P,Zt,Ur,Xn,Ga=`Ernie Model with a token classification head on top (a linear layer on top of the hidden-states output) e.g. for
Named-Entity-Recognition (NER) tasks.`,Wr,Gn,Qa=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Hr,Qn,Da=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Zr,V,St,Sr,Dn,Ya='The <a href="/docs/transformers/v4.33.3/en/model_doc/ernie#transformers.ErnieForTokenClassification">ErnieForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',Ar,Xe,ds,ye,Ge,To,At,Br,Yn,Ka="ErnieForQuestionAnswering",ls,q,Bt,Rr,Kn,ei=`Ernie Model with a span classification head on top for extractive question-answering tasks like SQuAD (a linear
layers on top of the hidden-states output to compute <code>span start logits</code> and <code>span end logits</code>).`,Or,eo,ti=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Vr,to,ni=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Xr,X,Rt,Gr,no,oi='The <a href="/docs/transformers/v4.33.3/en/model_doc/ernie#transformers.ErnieForQuestionAnswering">ErnieForQuestionAnswering</a> forward method, overrides the <code>__call__</code> special method.',Qr,Qe,cs,ko,ps;return rt=new C({}),at=new C({}),dt=new C({}),lt=new st({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWwlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJuZ2h1eW9uZyUyRmVybmllLTEuMC1iYXNlLXpoJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJuZ2h1eW9uZyUyRmVybmllLTEuMC1iYXNlLXpoJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModel
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;nghuyong/ernie-1.0-base-zh&quot;</span>)
model = AutoModel.from_pretrained(<span class="hljs-string">&quot;nghuyong/ernie-1.0-base-zh&quot;</span>)`}}),ct=new C({}),mt=new C({}),ft=new C({}),gt=new E({props:{name:"class transformers.ErnieConfig",anchor:"transformers.ErnieConfig",parameters:[{name:"vocab_size",val:" = 30522"},{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.1"},{name:"attention_probs_dropout_prob",val:" = 0.1"},{name:"max_position_embeddings",val:" = 512"},{name:"type_vocab_size",val:" = 2"},{name:"task_type_vocab_size",val:" = 3"},{name:"use_task_id",val:" = False"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"pad_token_id",val:" = 0"},{name:"position_embedding_type",val:" = 'absolute'"},{name:"use_cache",val:" = True"},{name:"classifier_dropout",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ErnieConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 30522) &#x2014;
Vocabulary size of the ERNIE model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/v4.33.3/en/model_doc/ernie#transformers.ErnieModel">ErnieModel</a> or <code>TFErnieModel</code>.`,name:"vocab_size"},{anchor:"transformers.ErnieConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.ErnieConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.ErnieConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.ErnieConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.ErnieConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>Callable</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.ErnieConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.ErnieConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.ErnieConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.ErnieConfig.type_vocab_size",description:`<strong>type_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The vocabulary size of the <code>token_type_ids</code> passed when calling <a href="/docs/transformers/v4.33.3/en/model_doc/ernie#transformers.ErnieModel">ErnieModel</a> or <code>TFErnieModel</code>.`,name:"type_vocab_size"},{anchor:"transformers.ErnieConfig.task_type_vocab_size",description:`<strong>task_type_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The vocabulary size of the <code>task_type_ids</code> for ERNIE2.0/ERNIE3.0 model`,name:"task_type_vocab_size"},{anchor:"transformers.ErnieConfig.use_task_id",description:`<strong>use_task_id</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the model support <code>task_type_ids</code>`,name:"use_task_id"},{anchor:"transformers.ErnieConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.ErnieConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.ErnieConfig.position_embedding_type",description:`<strong>position_embedding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;absolute&quot;</code>) &#x2014;
Type of position embedding. Choose one of <code>&quot;absolute&quot;</code>, <code>&quot;relative_key&quot;</code>, <code>&quot;relative_key_query&quot;</code>. For
positional embeddings use <code>&quot;absolute&quot;</code>. For more information on <code>&quot;relative_key&quot;</code>, please refer to
<a href="https://arxiv.org/abs/1803.02155" rel="nofollow">Self-Attention with Relative Position Representations (Shaw et al.)</a>.
For more information on <code>&quot;relative_key_query&quot;</code>, please refer to <em>Method 4</em> in <a href="https://arxiv.org/abs/2009.13658" rel="nofollow">Improve Transformer Models
with Better Relative Position Embeddings (Huang et al.)</a>.`,name:"position_embedding_type"},{anchor:"transformers.ErnieConfig.is_decoder",description:`<strong>is_decoder</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model is used as a decoder or not. If <code>False</code>, the model is used as an encoder.`,name:"is_decoder"},{anchor:"transformers.ErnieConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.ErnieConfig.classifier_dropout",description:`<strong>classifier_dropout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The dropout ratio for the classification head.`,name:"classifier_dropout"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie/configuration_ernie.py#L41"}}),$e=new Yt({props:{anchor:"transformers.ErnieConfig.example",$$slots:{default:[Li]},$$scope:{ctx:w}}}),_t=new C({}),yt=new E({props:{name:"class transformers.models.ernie.modeling_ernie.ErnieForPreTrainingOutput",anchor:"transformers.models.ernie.modeling_ernie.ErnieForPreTrainingOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prediction_logits",val:": FloatTensor = None"},{name:"seq_relationship_logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.ernie.modeling_ernie.ErnieForPreTrainingOutput.loss",description:`<strong>loss</strong> (<em>optional</em>, returned when <code>labels</code> is provided, <code>torch.FloatTensor</code> of shape <code>(1,)</code>) &#x2014;
Total loss as the sum of the masked language modeling loss and the next sequence prediction
(classification) loss.`,name:"loss"},{anchor:"transformers.models.ernie.modeling_ernie.ErnieForPreTrainingOutput.prediction_logits",description:`<strong>prediction_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"prediction_logits"},{anchor:"transformers.models.ernie.modeling_ernie.ErnieForPreTrainingOutput.seq_relationship_logits",description:`<strong>seq_relationship_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2)</code>) &#x2014;
Prediction scores of the next sequence prediction (classification) head (scores of True/False continuation
before SoftMax).`,name:"seq_relationship_logits"},{anchor:"transformers.models.ernie.modeling_ernie.ErnieForPreTrainingOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.ernie.modeling_ernie.ErnieForPreTrainingOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie/modeling_ernie.py#L690"}}),bt=new C({}),vt=new E({props:{name:"class transformers.ErnieModel",anchor:"transformers.ErnieModel",parameters:[{name:"config",val:""},{name:"add_pooling_layer",val:" = True"}],parametersDescription:[{anchor:"transformers.ErnieModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/ernie#transformers.ErnieConfig">ErnieConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie/modeling_ernie.py#L798"}}),Tt=new E({props:{name:"forward",anchor:"transformers.ErnieModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"task_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.ErnieModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ErnieModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ErnieModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.ErnieModel.forward.task_type_ids",description:`<strong>task_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Task type embedding is a special embedding to represent the characteristic of different tasks, such as
word-aware pre-training task, structure-aware pre-training task and semantic-aware pre-training task. We
assign a <code>task_type_id</code> to each task and the <code>task_type_id</code> is in the range \`[0,
config.task_type_vocab_size-1]`,name:"task_type_ids"},{anchor:"transformers.ErnieModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ErnieModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ErnieModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ErnieModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ErnieModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ErnieModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ErnieModel.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong>  (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder. Used in the cross-attention if
the model is configured as a decoder.`,name:"encoder_hidden_states"},{anchor:"transformers.ErnieModel.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on the padding token indices of the encoder input. This mask is used in
the cross-attention if the model is configured as a decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>`,name:"encoder_attention_mask"},{anchor:"transformers.ErnieModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.ErnieModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie/modeling_ernie.py#L841",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/ernie#transformers.ErnieConfig"
>ErnieConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Ce=new be({props:{$$slots:{default:[Ii]},$$scope:{ctx:w}}}),ze=new Yt({props:{anchor:"transformers.ErnieModel.forward.example",$$slots:{default:[Ni]},$$scope:{ctx:w}}}),kt=new C({}),Mt=new E({props:{name:"class transformers.ErnieForPreTraining",anchor:"transformers.ErnieForPreTraining",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ErnieForPreTraining.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/ernie#transformers.ErnieConfig">ErnieConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie/modeling_ernie.py#L987"}}),wt=new E({props:{name:"forward",anchor:"transformers.ErnieForPreTraining.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"task_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"next_sentence_label",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.ErnieForPreTraining.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ErnieForPreTraining.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ErnieForPreTraining.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.ErnieForPreTraining.forward.task_type_ids",description:`<strong>task_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Task type embedding is a special embedding to represent the characteristic of different tasks, such as
word-aware pre-training task, structure-aware pre-training task and semantic-aware pre-training task. We
assign a <code>task_type_id</code> to each task and the <code>task_type_id</code> is in the range \`[0,
config.task_type_vocab_size-1]`,name:"task_type_ids"},{anchor:"transformers.ErnieForPreTraining.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ErnieForPreTraining.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ErnieForPreTraining.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ErnieForPreTraining.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ErnieForPreTraining.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ErnieForPreTraining.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.</p>
<p>labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should be in <code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_ids</code> docstring) Tokens with indices set to <code>-100</code> are ignored (masked),
the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>
next_sentence_label (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>):
Labels for computing the next sequence prediction (classification) loss. Input should be a sequence
pair (see <code>input_ids</code> docstring) Indices should be in <code>[0, 1]</code>:</p>
<ul>
<li>0 indicates sequence B is a continuation of sequence A,</li>
<li>1 indicates sequence B is a random sequence.
kwargs (<code>Dict[str, any]</code>, optional, defaults to <em>{}</em>):
Used to hide legacy arguments that have been deprecated.</li>
</ul>`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie/modeling_ernie.py#L1008",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/model_doc/ernie#transformers.models.ernie.modeling_ernie.ErnieForPreTrainingOutput"
>transformers.models.ernie.modeling_ernie.ErnieForPreTrainingOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/ernie#transformers.ErnieConfig"
>ErnieConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<em>optional</em>, returned when <code>labels</code> is provided, <code>torch.FloatTensor</code> of shape <code>(1,)</code>) — Total loss as the sum of the masked language modeling loss and the next sequence prediction
(classification) loss.</p>
</li>
<li>
<p><strong>prediction_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>seq_relationship_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2)</code>) — Prediction scores of the next sequence prediction (classification) head (scores of True/False continuation
before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/model_doc/ernie#transformers.models.ernie.modeling_ernie.ErnieForPreTrainingOutput"
>transformers.models.ernie.modeling_ernie.ErnieForPreTrainingOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Je=new be({props:{$$slots:{default:[Pi]},$$scope:{ctx:w}}}),je=new Yt({props:{anchor:"transformers.ErnieForPreTraining.forward.example",$$slots:{default:[qi]},$$scope:{ctx:w}}}),$t=new C({}),Et=new E({props:{name:"class transformers.ErnieForCausalLM",anchor:"transformers.ErnieForCausalLM",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ErnieForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/ernie#transformers.ErnieConfig">ErnieConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie/modeling_ernie.py#L1098"}}),xt=new E({props:{name:"forward",anchor:"transformers.ErnieForCausalLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"task_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.ErnieForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ErnieForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ErnieForCausalLM.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.ErnieForCausalLM.forward.task_type_ids",description:`<strong>task_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Task type embedding is a special embedding to represent the characteristic of different tasks, such as
word-aware pre-training task, structure-aware pre-training task and semantic-aware pre-training task. We
assign a <code>task_type_id</code> to each task and the <code>task_type_id</code> is in the range \`[0,
config.task_type_vocab_size-1]`,name:"task_type_ids"},{anchor:"transformers.ErnieForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ErnieForCausalLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ErnieForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ErnieForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ErnieForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ErnieForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ErnieForCausalLM.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong>  (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder. Used in the cross-attention if
the model is configured as a decoder.`,name:"encoder_hidden_states"},{anchor:"transformers.ErnieForCausalLM.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on the padding token indices of the encoder input. This mask is used in
the cross-attention if the model is configured as a decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>`,name:"encoder_attention_mask"},{anchor:"transformers.ErnieForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the left-to-right language modeling loss (next word prediction). Indices should be in
<code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_ids</code> docstring) Tokens with indices set to <code>-100</code> are
ignored (masked), the loss is only computed for the tokens with labels n <code>[0, ..., config.vocab_size]</code>`,name:"labels"},{anchor:"transformers.ErnieForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.ErnieForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie/modeling_ernie.py#L1122",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/ernie#transformers.ErnieConfig"
>ErnieConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Cross attentions weights after the attention softmax, used to compute the weighted average in the
cross-attention heads.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>torch.FloatTensor</code> tuples of length <code>config.n_layers</code>, with each tuple containing the cached key,
value states of the self-attention and the cross-attention layers if model is used in encoder-decoder
setting. Only relevant if <code>config.is_decoder = True</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Ie=new be({props:{$$slots:{default:[Ui]},$$scope:{ctx:w}}}),Ne=new Yt({props:{anchor:"transformers.ErnieForCausalLM.forward.example",$$slots:{default:[Wi]},$$scope:{ctx:w}}}),Ct=new C({}),zt=new E({props:{name:"class transformers.ErnieForMaskedLM",anchor:"transformers.ErnieForMaskedLM",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ErnieForMaskedLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/ernie#transformers.ErnieConfig">ErnieConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie/modeling_ernie.py#L1244"}}),Ft=new E({props:{name:"forward",anchor:"transformers.ErnieForMaskedLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"task_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.ErnieForMaskedLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ErnieForMaskedLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ErnieForMaskedLM.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.ErnieForMaskedLM.forward.task_type_ids",description:`<strong>task_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Task type embedding is a special embedding to represent the characteristic of different tasks, such as
word-aware pre-training task, structure-aware pre-training task and semantic-aware pre-training task. We
assign a <code>task_type_id</code> to each task and the <code>task_type_id</code> is in the range \`[0,
config.task_type_vocab_size-1]`,name:"task_type_ids"},{anchor:"transformers.ErnieForMaskedLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ErnieForMaskedLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ErnieForMaskedLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ErnieForMaskedLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ErnieForMaskedLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ErnieForMaskedLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ErnieForMaskedLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should be in <code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_ids</code> docstring) Tokens with indices set to <code>-100</code> are ignored (masked), the
loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie/modeling_ernie.py#L1271",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/ernie#transformers.ErnieConfig"
>ErnieConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Masked language modeling (MLM) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),qe=new be({props:{$$slots:{default:[Hi]},$$scope:{ctx:w}}}),Ue=new Yt({props:{anchor:"transformers.ErnieForMaskedLM.forward.example",$$slots:{default:[Zi]},$$scope:{ctx:w}}}),Jt=new C({}),jt=new E({props:{name:"class transformers.ErnieForNextSentencePrediction",anchor:"transformers.ErnieForNextSentencePrediction",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ErnieForNextSentencePrediction.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/ernie#transformers.ErnieConfig">ErnieConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie/modeling_ernie.py#L1360"}}),Lt=new E({props:{name:"forward",anchor:"transformers.ErnieForNextSentencePrediction.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"task_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ErnieForNextSentencePrediction.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ErnieForNextSentencePrediction.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ErnieForNextSentencePrediction.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.ErnieForNextSentencePrediction.forward.task_type_ids",description:`<strong>task_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Task type embedding is a special embedding to represent the characteristic of different tasks, such as
word-aware pre-training task, structure-aware pre-training task and semantic-aware pre-training task. We
assign a <code>task_type_id</code> to each task and the <code>task_type_id</code> is in the range \`[0,
config.task_type_vocab_size-1]`,name:"task_type_ids"},{anchor:"transformers.ErnieForNextSentencePrediction.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ErnieForNextSentencePrediction.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ErnieForNextSentencePrediction.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ErnieForNextSentencePrediction.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ErnieForNextSentencePrediction.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ErnieForNextSentencePrediction.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ErnieForNextSentencePrediction.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the next sequence prediction (classification) loss. Input should be a sequence pair
(see <code>input_ids</code> docstring). Indices should be in <code>[0, 1]</code>:</p>
<ul>
<li>0 indicates sequence B is a continuation of sequence A,</li>
<li>1 indicates sequence B is a random sequence.</li>
</ul>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie/modeling_ernie.py#L1371",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.NextSentencePredictorOutput"
>transformers.modeling_outputs.NextSentencePredictorOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/ernie#transformers.ErnieConfig"
>ErnieConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>next_sentence_label</code> is provided) — Next sequence prediction (classification) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2)</code>) — Prediction scores of the next sequence prediction (classification) head (scores of True/False continuation
before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.NextSentencePredictorOutput"
>transformers.modeling_outputs.NextSentencePredictorOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),He=new be({props:{$$slots:{default:[Si]},$$scope:{ctx:w}}}),Ze=new Yt({props:{anchor:"transformers.ErnieForNextSentencePrediction.forward.example",$$slots:{default:[Ai]},$$scope:{ctx:w}}}),It=new C({}),Nt=new E({props:{name:"class transformers.ErnieForSequenceClassification",anchor:"transformers.ErnieForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ErnieForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/ernie#transformers.ErnieConfig">ErnieConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie/modeling_ernie.py#L1468"}}),Pt=new E({props:{name:"forward",anchor:"transformers.ErnieForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"task_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.ErnieForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ErnieForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ErnieForSequenceClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.ErnieForSequenceClassification.forward.task_type_ids",description:`<strong>task_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Task type embedding is a special embedding to represent the characteristic of different tasks, such as
word-aware pre-training task, structure-aware pre-training task and semantic-aware pre-training task. We
assign a <code>task_type_id</code> to each task and the <code>task_type_id</code> is in the range \`[0,
config.task_type_vocab_size-1]`,name:"task_type_ids"},{anchor:"transformers.ErnieForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ErnieForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ErnieForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ErnieForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ErnieForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ErnieForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ErnieForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie/modeling_ernie.py#L1485"}}),Ae=new be({props:{$$slots:{default:[Bi]},$$scope:{ctx:w}}}),qt=new C({}),Ut=new E({props:{name:"class transformers.ErnieForMultipleChoice",anchor:"transformers.ErnieForMultipleChoice",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ErnieForMultipleChoice.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/ernie#transformers.ErnieConfig">ErnieConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie/modeling_ernie.py#L1567"}}),Wt=new E({props:{name:"forward",anchor:"transformers.ErnieForMultipleChoice.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"task_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.ErnieForMultipleChoice.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ErnieForMultipleChoice.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ErnieForMultipleChoice.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.ErnieForMultipleChoice.forward.task_type_ids",description:`<strong>task_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Task type embedding is a special embedding to represent the characteristic of different tasks, such as
word-aware pre-training task, structure-aware pre-training task and semantic-aware pre-training task. We
assign a <code>task_type_id</code> to each task and the <code>task_type_id</code> is in the range \`[0,
config.task_type_vocab_size-1]`,name:"task_type_ids"},{anchor:"transformers.ErnieForMultipleChoice.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ErnieForMultipleChoice.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ErnieForMultipleChoice.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ErnieForMultipleChoice.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ErnieForMultipleChoice.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ErnieForMultipleChoice.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ErnieForMultipleChoice.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the multiple choice classification loss. Indices should be in <code>[0, ..., num_choices-1]</code> where <code>num_choices</code> is the size of the second dimension of the input tensors. (See
<code>input_ids</code> above)`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie/modeling_ernie.py#L1582",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.MultipleChoiceModelOutput"
>transformers.modeling_outputs.MultipleChoiceModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/ernie#transformers.ErnieConfig"
>ErnieConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <em>(1,)</em>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices)</code>) — <em>num_choices</em> is the second dimension of the input tensors. (see <em>input_ids</em> above).</p>
<p>Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.MultipleChoiceModelOutput"
>transformers.modeling_outputs.MultipleChoiceModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Re=new be({props:{$$slots:{default:[Ri]},$$scope:{ctx:w}}}),Oe=new Yt({props:{anchor:"transformers.ErnieForMultipleChoice.forward.example",$$slots:{default:[Oi]},$$scope:{ctx:w}}}),Ht=new C({}),Zt=new E({props:{name:"class transformers.ErnieForTokenClassification",anchor:"transformers.ErnieForTokenClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ErnieForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/ernie#transformers.ErnieConfig">ErnieConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie/modeling_ernie.py#L1664"}}),St=new E({props:{name:"forward",anchor:"transformers.ErnieForTokenClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"task_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.ErnieForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ErnieForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ErnieForTokenClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.ErnieForTokenClassification.forward.task_type_ids",description:`<strong>task_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Task type embedding is a special embedding to represent the characteristic of different tasks, such as
word-aware pre-training task, structure-aware pre-training task and semantic-aware pre-training task. We
assign a <code>task_type_id</code> to each task and the <code>task_type_id</code> is in the range \`[0,
config.task_type_vocab_size-1]`,name:"task_type_ids"},{anchor:"transformers.ErnieForTokenClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ErnieForTokenClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ErnieForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ErnieForTokenClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ErnieForTokenClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ErnieForTokenClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ErnieForTokenClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the token classification loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie/modeling_ernie.py#L1680"}}),Xe=new be({props:{$$slots:{default:[Vi]},$$scope:{ctx:w}}}),At=new C({}),Bt=new E({props:{name:"class transformers.ErnieForQuestionAnswering",anchor:"transformers.ErnieForQuestionAnswering",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ErnieForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/ernie#transformers.ErnieConfig">ErnieConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie/modeling_ernie.py#L1743"}}),Rt=new E({props:{name:"forward",anchor:"transformers.ErnieForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"task_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"start_positions",val:": typing.Optional[torch.Tensor] = None"},{name:"end_positions",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.ErnieForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ErnieForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ErnieForQuestionAnswering.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.ErnieForQuestionAnswering.forward.task_type_ids",description:`<strong>task_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Task type embedding is a special embedding to represent the characteristic of different tasks, such as
word-aware pre-training task, structure-aware pre-training task and semantic-aware pre-training task. We
assign a <code>task_type_id</code> to each task and the <code>task_type_id</code> is in the range \`[0,
config.task_type_vocab_size-1]`,name:"task_type_ids"},{anchor:"transformers.ErnieForQuestionAnswering.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ErnieForQuestionAnswering.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ErnieForQuestionAnswering.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ErnieForQuestionAnswering.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ErnieForQuestionAnswering.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ErnieForQuestionAnswering.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ErnieForQuestionAnswering.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the start of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.ErnieForQuestionAnswering.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the end of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"end_positions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie/modeling_ernie.py#L1755"}}),Qe=new be({props:{$$slots:{default:[Xi]},$$scope:{ctx:w}}}),{c(){r=o("meta"),k=a(),c=o("p"),m=a(),M=o("h1"),d=o("a"),$=o("span"),g(rt.$$.fragment),Ms=a(),Kt=o("span"),Kt.textContent=Dr,Lo=a(),oe=o("h2"),ve=o("a"),ao=o("span"),g(at.$$.fragment),ws=a(),en=o("span"),en.textContent=Yr,Io=Ei(`

ERNIE is a series of powerful models proposed by baidu, especially in Chinese tasks,
including [ERNIE1.0](https://arxiv.org/abs/1904.09223), [ERNIE2.0](https://ojs.aaai.org/index.php/AAAI/article/view/6428),
[ERNIE3.0](https://arxiv.org/abs/2107.02137), [ERNIE-Gram](https://arxiv.org/abs/2010.12148), [ERNIE-health](https://arxiv.org/abs/2110.07244), etc.
`),it=o("p"),it.innerHTML=Kr,No=a(),se=o("h3"),Te=o("a"),io=o("span"),g(dt.$$.fragment),$s=a(),tn=o("span"),tn.textContent=ea,Po=Ei(`

Take \`ernie-1.0-base-zh\` as an example:

	`),g(lt.$$.fragment),qo=a(),re=o("h3"),ke=o("a"),lo=o("span"),g(ct.$$.fragment),Es=a(),nn=o("span"),nn.textContent=ta,Uo=a(),pt=o("table"),pt.innerHTML=na,Wo=a(),ht=o("p"),ht.innerHTML=oa,Ho=a(),ae=o("h2"),Me=o("a"),co=o("span"),g(mt.$$.fragment),xs=a(),on=o("span"),on.textContent=sa,Zo=a(),ut=o("ul"),ut.innerHTML=ra,So=a(),ie=o("h2"),we=o("a"),po=o("span"),g(ft.$$.fragment),Cs=a(),sn=o("span"),sn.textContent=aa,Ao=a(),W=o("div"),g(gt.$$.fragment),zs=a(),rn=o("p"),rn.innerHTML=ia,Fs=a(),an=o("p"),an.innerHTML=da,Js=a(),g($e.$$.fragment),Bo=a(),de=o("h2"),Ee=o("a"),ho=o("span"),g(_t.$$.fragment),js=a(),dn=o("span"),dn.textContent=la,Ro=a(),le=o("div"),g(yt.$$.fragment),Ls=a(),ln=o("p"),ln.innerHTML=ca,Oo=a(),ce=o("h2"),xe=o("a"),mo=o("span"),g(bt.$$.fragment),Is=a(),cn=o("span"),cn.textContent=pa,Vo=a(),x=o("div"),g(vt.$$.fragment),Ns=a(),pn=o("p"),pn.textContent=ha,Ps=a(),hn=o("p"),hn.innerHTML=ma,qs=a(),mn=o("p"),mn.innerHTML=ua,Us=a(),un=o("p"),un.innerHTML=fa,Ws=a(),fn=o("p"),fn.innerHTML=ga,Hs=a(),H=o("div"),g(Tt.$$.fragment),Zs=a(),gn=o("p"),gn.innerHTML=_a,Ss=a(),g(Ce.$$.fragment),As=a(),g(ze.$$.fragment),Xo=a(),pe=o("h2"),Fe=o("a"),uo=o("span"),g(kt.$$.fragment),Bs=a(),_n=o("span"),_n.textContent=ya,Go=a(),F=o("div"),g(Mt.$$.fragment),Rs=a(),yn=o("p"),yn.innerHTML=ba,Os=a(),bn=o("p"),bn.innerHTML=va,Vs=a(),vn=o("p"),vn.innerHTML=Ta,Xs=a(),Z=o("div"),g(wt.$$.fragment),Gs=a(),Tn=o("p"),Tn.innerHTML=ka,Qs=a(),g(Je.$$.fragment),Ds=a(),g(je.$$.fragment),Qo=a(),he=o("h2"),Le=o("a"),fo=o("span"),g($t.$$.fragment),Ys=a(),kn=o("span"),kn.textContent=Ma,Do=a(),J=o("div"),g(Et.$$.fragment),Ks=a(),Mn=o("p"),Mn.innerHTML=wa,er=a(),wn=o("p"),wn.innerHTML=$a,tr=a(),$n=o("p"),$n.innerHTML=Ea,nr=a(),S=o("div"),g(xt.$$.fragment),or=a(),En=o("p"),En.innerHTML=xa,sr=a(),g(Ie.$$.fragment),rr=a(),g(Ne.$$.fragment),Yo=a(),me=o("h2"),Pe=o("a"),go=o("span"),g(Ct.$$.fragment),ar=a(),xn=o("span"),xn.textContent=Ca,Ko=a(),j=o("div"),g(zt.$$.fragment),ir=a(),Cn=o("p"),Cn.innerHTML=za,dr=a(),zn=o("p"),zn.innerHTML=Fa,lr=a(),Fn=o("p"),Fn.innerHTML=Ja,cr=a(),A=o("div"),g(Ft.$$.fragment),pr=a(),Jn=o("p"),Jn.innerHTML=ja,hr=a(),g(qe.$$.fragment),mr=a(),g(Ue.$$.fragment),es=a(),ue=o("h2"),We=o("a"),_o=o("span"),g(Jt.$$.fragment),ur=a(),jn=o("span"),jn.textContent=La,ts=a(),L=o("div"),g(jt.$$.fragment),fr=a(),Ln=o("p"),Ln.innerHTML=Ia,gr=a(),In=o("p"),In.innerHTML=Na,_r=a(),Nn=o("p"),Nn.innerHTML=Pa,yr=a(),B=o("div"),g(Lt.$$.fragment),br=a(),Pn=o("p"),Pn.innerHTML=qa,vr=a(),g(He.$$.fragment),Tr=a(),g(Ze.$$.fragment),ns=a(),fe=o("h2"),Se=o("a"),yo=o("span"),g(It.$$.fragment),kr=a(),qn=o("span"),qn.textContent=Ua,os=a(),I=o("div"),g(Nt.$$.fragment),Mr=a(),Un=o("p"),Un.textContent=Wa,wr=a(),Wn=o("p"),Wn.innerHTML=Ha,$r=a(),Hn=o("p"),Hn.innerHTML=Za,Er=a(),O=o("div"),g(Pt.$$.fragment),xr=a(),Zn=o("p"),Zn.innerHTML=Sa,Cr=a(),g(Ae.$$.fragment),ss=a(),ge=o("h2"),Be=o("a"),bo=o("span"),g(qt.$$.fragment),zr=a(),Sn=o("span"),Sn.textContent=Aa,rs=a(),N=o("div"),g(Ut.$$.fragment),Fr=a(),An=o("p"),An.textContent=Ba,Jr=a(),Bn=o("p"),Bn.innerHTML=Ra,jr=a(),Rn=o("p"),Rn.innerHTML=Oa,Lr=a(),R=o("div"),g(Wt.$$.fragment),Ir=a(),On=o("p"),On.innerHTML=Va,Nr=a(),g(Re.$$.fragment),Pr=a(),g(Oe.$$.fragment),as=a(),_e=o("h2"),Ve=o("a"),vo=o("span"),g(Ht.$$.fragment),qr=a(),Vn=o("span"),Vn.textContent=Xa,is=a(),P=o("div"),g(Zt.$$.fragment),Ur=a(),Xn=o("p"),Xn.textContent=Ga,Wr=a(),Gn=o("p"),Gn.innerHTML=Qa,Hr=a(),Qn=o("p"),Qn.innerHTML=Da,Zr=a(),V=o("div"),g(St.$$.fragment),Sr=a(),Dn=o("p"),Dn.innerHTML=Ya,Ar=a(),g(Xe.$$.fragment),ds=a(),ye=o("h2"),Ge=o("a"),To=o("span"),g(At.$$.fragment),Br=a(),Yn=o("span"),Yn.textContent=Ka,ls=a(),q=o("div"),g(Bt.$$.fragment),Rr=a(),Kn=o("p"),Kn.innerHTML=ei,Or=a(),eo=o("p"),eo.innerHTML=ti,Vr=a(),to=o("p"),to.innerHTML=ni,Xr=a(),X=o("div"),g(Rt.$$.fragment),Gr=a(),no=o("p"),no.innerHTML=oi,Qr=a(),g(Qe.$$.fragment),cs=a(),ko=o("p"),this.h()},l(e){const l=ji("svelte-1phssyn",document.head);r=s(l,"META",{name:!0,content:!0}),l.forEach(n),k=i(e),c=s(e,"P",{}),f(c).forEach(n),m=i(e),M=s(e,"H1",{class:!0});var Ot=f(M);d=s(Ot,"A",{id:!0,class:!0,href:!0});var Mo=f(d);$=s(Mo,"SPAN",{});var wo=f($);_(rt.$$.fragment,wo),wo.forEach(n),Mo.forEach(n),Ms=i(Ot),Kt=s(Ot,"SPAN",{"data-svelte-h":!0}),u(Kt)!=="svelte-2z4whi"&&(Kt.textContent=Dr),Ot.forEach(n),Lo=i(e),oe=s(e,"H2",{class:!0});var Vt=f(oe);ve=s(Vt,"A",{id:!0,class:!0,href:!0});var $o=f(ve);ao=s($o,"SPAN",{});var Eo=f(ao);_(at.$$.fragment,Eo),Eo.forEach(n),$o.forEach(n),ws=i(Vt),en=s(Vt,"SPAN",{"data-svelte-h":!0}),u(en)!=="svelte-1jsw1pg"&&(en.textContent=Yr),Vt.forEach(n),Io=xi(e,`

ERNIE is a series of powerful models proposed by baidu, especially in Chinese tasks,
including [ERNIE1.0](https://arxiv.org/abs/1904.09223), [ERNIE2.0](https://ojs.aaai.org/index.php/AAAI/article/view/6428),
[ERNIE3.0](https://arxiv.org/abs/2107.02137), [ERNIE-Gram](https://arxiv.org/abs/2010.12148), [ERNIE-health](https://arxiv.org/abs/2110.07244), etc.
`),it=s(e,"P",{"data-svelte-h":!0}),u(it)!=="svelte-1fthuba"&&(it.innerHTML=Kr),No=i(e),se=s(e,"H3",{class:!0});var Xt=f(se);Te=s(Xt,"A",{id:!0,class:!0,href:!0});var xo=f(Te);io=s(xo,"SPAN",{});var Co=f(io);_(dt.$$.fragment,Co),Co.forEach(n),xo.forEach(n),$s=i(Xt),tn=s(Xt,"SPAN",{"data-svelte-h":!0}),u(tn)!=="svelte-2d5skl"&&(tn.textContent=ea),Xt.forEach(n),Po=xi(e,`

Take \`ernie-1.0-base-zh\` as an example:

	`),_(lt.$$.fragment,e),qo=i(e),re=s(e,"H3",{class:!0});var Gt=f(re);ke=s(Gt,"A",{id:!0,class:!0,href:!0});var zo=f(ke);lo=s(zo,"SPAN",{});var Fo=f(lo);_(ct.$$.fragment,Fo),Fo.forEach(n),zo.forEach(n),Es=i(Gt),nn=s(Gt,"SPAN",{"data-svelte-h":!0}),u(nn)!=="svelte-11edgc9"&&(nn.textContent=ta),Gt.forEach(n),Uo=i(e),pt=s(e,"TABLE",{"data-svelte-h":!0}),u(pt)!=="svelte-nh20hi"&&(pt.innerHTML=na),Wo=i(e),ht=s(e,"P",{"data-svelte-h":!0}),u(ht)!=="svelte-10dq6fe"&&(ht.innerHTML=oa),Ho=i(e),ae=s(e,"H2",{class:!0});var Qt=f(ae);Me=s(Qt,"A",{id:!0,class:!0,href:!0});var Jo=f(Me);co=s(Jo,"SPAN",{});var jo=f(co);_(mt.$$.fragment,jo),jo.forEach(n),Jo.forEach(n),xs=i(Qt),on=s(Qt,"SPAN",{"data-svelte-h":!0}),u(on)!=="svelte-n3f0j0"&&(on.textContent=sa),Qt.forEach(n),Zo=i(e),ut=s(e,"UL",{"data-svelte-h":!0}),u(ut)!=="svelte-p1b16m"&&(ut.innerHTML=ra),So=i(e),ie=s(e,"H2",{class:!0});var Dt=f(ie);we=s(Dt,"A",{id:!0,class:!0,href:!0});var si=f(we);po=s(si,"SPAN",{});var ri=f(po);_(ft.$$.fragment,ri),ri.forEach(n),si.forEach(n),Cs=i(Dt),sn=s(Dt,"SPAN",{"data-svelte-h":!0}),u(sn)!=="svelte-1ouy1e8"&&(sn.textContent=aa),Dt.forEach(n),Ao=i(e),W=s(e,"DIV",{class:!0});var De=f(W);_(gt.$$.fragment,De),zs=i(De),rn=s(De,"P",{"data-svelte-h":!0}),u(rn)!=="svelte-akuef"&&(rn.innerHTML=ia),Fs=i(De),an=s(De,"P",{"data-svelte-h":!0}),u(an)!=="svelte-cfh5wl"&&(an.innerHTML=da),Js=i(De),_($e.$$.fragment,De),De.forEach(n),Bo=i(e),de=s(e,"H2",{class:!0});var hs=f(de);Ee=s(hs,"A",{id:!0,class:!0,href:!0});var ai=f(Ee);ho=s(ai,"SPAN",{});var ii=f(ho);_(_t.$$.fragment,ii),ii.forEach(n),ai.forEach(n),js=i(hs),dn=s(hs,"SPAN",{"data-svelte-h":!0}),u(dn)!=="svelte-7hh796"&&(dn.textContent=la),hs.forEach(n),Ro=i(e),le=s(e,"DIV",{class:!0});var ms=f(le);_(yt.$$.fragment,ms),Ls=i(ms),ln=s(ms,"P",{"data-svelte-h":!0}),u(ln)!=="svelte-quclmk"&&(ln.innerHTML=ca),ms.forEach(n),Oo=i(e),ce=s(e,"H2",{class:!0});var us=f(ce);xe=s(us,"A",{id:!0,class:!0,href:!0});var di=f(xe);mo=s(di,"SPAN",{});var li=f(mo);_(bt.$$.fragment,li),li.forEach(n),di.forEach(n),Is=i(us),cn=s(us,"SPAN",{"data-svelte-h":!0}),u(cn)!=="svelte-38z55r"&&(cn.textContent=pa),us.forEach(n),Vo=i(e),x=s(e,"DIV",{class:!0});var U=f(x);_(vt.$$.fragment,U),Ns=i(U),pn=s(U,"P",{"data-svelte-h":!0}),u(pn)!=="svelte-1t6amlg"&&(pn.textContent=ha),Ps=i(U),hn=s(U,"P",{"data-svelte-h":!0}),u(hn)!=="svelte-ev63c"&&(hn.innerHTML=ma),qs=i(U),mn=s(U,"P",{"data-svelte-h":!0}),u(mn)!=="svelte-hswkmf"&&(mn.innerHTML=ua),Us=i(U),un=s(U,"P",{"data-svelte-h":!0}),u(un)!=="svelte-1du13oj"&&(un.innerHTML=fa),Ws=i(U),fn=s(U,"P",{"data-svelte-h":!0}),u(fn)!=="svelte-174erte"&&(fn.innerHTML=ga),Hs=i(U),H=s(U,"DIV",{class:!0});var Ye=f(H);_(Tt.$$.fragment,Ye),Zs=i(Ye),gn=s(Ye,"P",{"data-svelte-h":!0}),u(gn)!=="svelte-l434ha"&&(gn.innerHTML=_a),Ss=i(Ye),_(Ce.$$.fragment,Ye),As=i(Ye),_(ze.$$.fragment,Ye),Ye.forEach(n),U.forEach(n),Xo=i(e),pe=s(e,"H2",{class:!0});var fs=f(pe);Fe=s(fs,"A",{id:!0,class:!0,href:!0});var ci=f(Fe);uo=s(ci,"SPAN",{});var pi=f(uo);_(kt.$$.fragment,pi),pi.forEach(n),ci.forEach(n),Bs=i(fs),_n=s(fs,"SPAN",{"data-svelte-h":!0}),u(_n)!=="svelte-1coxhp8"&&(_n.textContent=ya),fs.forEach(n),Go=i(e),F=s(e,"DIV",{class:!0});var G=f(F);_(Mt.$$.fragment,G),Rs=i(G),yn=s(G,"P",{"data-svelte-h":!0}),u(yn)!=="svelte-ltv6uf"&&(yn.innerHTML=ba),Os=i(G),bn=s(G,"P",{"data-svelte-h":!0}),u(bn)!=="svelte-ev63c"&&(bn.innerHTML=va),Vs=i(G),vn=s(G,"P",{"data-svelte-h":!0}),u(vn)!=="svelte-hswkmf"&&(vn.innerHTML=Ta),Xs=i(G),Z=s(G,"DIV",{class:!0});var Ke=f(Z);_(wt.$$.fragment,Ke),Gs=i(Ke),Tn=s(Ke,"P",{"data-svelte-h":!0}),u(Tn)!=="svelte-zamal2"&&(Tn.innerHTML=ka),Qs=i(Ke),_(Je.$$.fragment,Ke),Ds=i(Ke),_(je.$$.fragment,Ke),Ke.forEach(n),G.forEach(n),Qo=i(e),he=s(e,"H2",{class:!0});var gs=f(he);Le=s(gs,"A",{id:!0,class:!0,href:!0});var hi=f(Le);fo=s(hi,"SPAN",{});var mi=f(fo);_($t.$$.fragment,mi),mi.forEach(n),hi.forEach(n),Ys=i(gs),kn=s(gs,"SPAN",{"data-svelte-h":!0}),u(kn)!=="svelte-1cvcx4f"&&(kn.textContent=Ma),gs.forEach(n),Do=i(e),J=s(e,"DIV",{class:!0});var Q=f(J);_(Et.$$.fragment,Q),Ks=i(Q),Mn=s(Q,"P",{"data-svelte-h":!0}),u(Mn)!=="svelte-ts4qhc"&&(Mn.innerHTML=wa),er=i(Q),wn=s(Q,"P",{"data-svelte-h":!0}),u(wn)!=="svelte-ev63c"&&(wn.innerHTML=$a),tr=i(Q),$n=s(Q,"P",{"data-svelte-h":!0}),u($n)!=="svelte-hswkmf"&&($n.innerHTML=Ea),nr=i(Q),S=s(Q,"DIV",{class:!0});var et=f(S);_(xt.$$.fragment,et),or=i(et),En=s(et,"P",{"data-svelte-h":!0}),u(En)!=="svelte-4bosxi"&&(En.innerHTML=xa),sr=i(et),_(Ie.$$.fragment,et),rr=i(et),_(Ne.$$.fragment,et),et.forEach(n),Q.forEach(n),Yo=i(e),me=s(e,"H2",{class:!0});var _s=f(me);Pe=s(_s,"A",{id:!0,class:!0,href:!0});var ui=f(Pe);go=s(ui,"SPAN",{});var fi=f(go);_(Ct.$$.fragment,fi),fi.forEach(n),ui.forEach(n),ar=i(_s),xn=s(_s,"SPAN",{"data-svelte-h":!0}),u(xn)!=="svelte-17im7ef"&&(xn.textContent=Ca),_s.forEach(n),Ko=i(e),j=s(e,"DIV",{class:!0});var D=f(j);_(zt.$$.fragment,D),ir=i(D),Cn=s(D,"P",{"data-svelte-h":!0}),u(Cn)!=="svelte-1e378t3"&&(Cn.innerHTML=za),dr=i(D),zn=s(D,"P",{"data-svelte-h":!0}),u(zn)!=="svelte-ev63c"&&(zn.innerHTML=Fa),lr=i(D),Fn=s(D,"P",{"data-svelte-h":!0}),u(Fn)!=="svelte-hswkmf"&&(Fn.innerHTML=Ja),cr=i(D),A=s(D,"DIV",{class:!0});var tt=f(A);_(Ft.$$.fragment,tt),pr=i(tt),Jn=s(tt,"P",{"data-svelte-h":!0}),u(Jn)!=="svelte-a3yl1q"&&(Jn.innerHTML=ja),hr=i(tt),_(qe.$$.fragment,tt),mr=i(tt),_(Ue.$$.fragment,tt),tt.forEach(n),D.forEach(n),es=i(e),ue=s(e,"H2",{class:!0});var ys=f(ue);We=s(ys,"A",{id:!0,class:!0,href:!0});var gi=f(We);_o=s(gi,"SPAN",{});var _i=f(_o);_(Jt.$$.fragment,_i),_i.forEach(n),gi.forEach(n),ur=i(ys),jn=s(ys,"SPAN",{"data-svelte-h":!0}),u(jn)!=="svelte-1mvtnzq"&&(jn.textContent=La),ys.forEach(n),ts=i(e),L=s(e,"DIV",{class:!0});var Y=f(L);_(jt.$$.fragment,Y),fr=i(Y),Ln=s(Y,"P",{"data-svelte-h":!0}),u(Ln)!=="svelte-139sre"&&(Ln.innerHTML=Ia),gr=i(Y),In=s(Y,"P",{"data-svelte-h":!0}),u(In)!=="svelte-ev63c"&&(In.innerHTML=Na),_r=i(Y),Nn=s(Y,"P",{"data-svelte-h":!0}),u(Nn)!=="svelte-hswkmf"&&(Nn.innerHTML=Pa),yr=i(Y),B=s(Y,"DIV",{class:!0});var nt=f(B);_(Lt.$$.fragment,nt),br=i(nt),Pn=s(nt,"P",{"data-svelte-h":!0}),u(Pn)!=="svelte-3bj2gk"&&(Pn.innerHTML=qa),vr=i(nt),_(He.$$.fragment,nt),Tr=i(nt),_(Ze.$$.fragment,nt),nt.forEach(n),Y.forEach(n),ns=i(e),fe=s(e,"H2",{class:!0});var bs=f(fe);Se=s(bs,"A",{id:!0,class:!0,href:!0});var yi=f(Se);yo=s(yi,"SPAN",{});var bi=f(yo);_(It.$$.fragment,bi),bi.forEach(n),yi.forEach(n),kr=i(bs),qn=s(bs,"SPAN",{"data-svelte-h":!0}),u(qn)!=="svelte-1nih3im"&&(qn.textContent=Ua),bs.forEach(n),os=i(e),I=s(e,"DIV",{class:!0});var K=f(I);_(Nt.$$.fragment,K),Mr=i(K),Un=s(K,"P",{"data-svelte-h":!0}),u(Un)!=="svelte-129pehz"&&(Un.textContent=Wa),wr=i(K),Wn=s(K,"P",{"data-svelte-h":!0}),u(Wn)!=="svelte-ev63c"&&(Wn.innerHTML=Ha),$r=i(K),Hn=s(K,"P",{"data-svelte-h":!0}),u(Hn)!=="svelte-hswkmf"&&(Hn.innerHTML=Za),Er=i(K),O=s(K,"DIV",{class:!0});var oo=f(O);_(Pt.$$.fragment,oo),xr=i(oo),Zn=s(oo,"P",{"data-svelte-h":!0}),u(Zn)!=="svelte-yafync"&&(Zn.innerHTML=Sa),Cr=i(oo),_(Ae.$$.fragment,oo),oo.forEach(n),K.forEach(n),ss=i(e),ge=s(e,"H2",{class:!0});var vs=f(ge);Be=s(vs,"A",{id:!0,class:!0,href:!0});var vi=f(Be);bo=s(vi,"SPAN",{});var Ti=f(bo);_(qt.$$.fragment,Ti),Ti.forEach(n),vi.forEach(n),zr=i(vs),Sn=s(vs,"SPAN",{"data-svelte-h":!0}),u(Sn)!=="svelte-1h7o0cs"&&(Sn.textContent=Aa),vs.forEach(n),rs=i(e),N=s(e,"DIV",{class:!0});var ee=f(N);_(Ut.$$.fragment,ee),Fr=i(ee),An=s(ee,"P",{"data-svelte-h":!0}),u(An)!=="svelte-kvp7gr"&&(An.textContent=Ba),Jr=i(ee),Bn=s(ee,"P",{"data-svelte-h":!0}),u(Bn)!=="svelte-ev63c"&&(Bn.innerHTML=Ra),jr=i(ee),Rn=s(ee,"P",{"data-svelte-h":!0}),u(Rn)!=="svelte-hswkmf"&&(Rn.innerHTML=Oa),Lr=i(ee),R=s(ee,"DIV",{class:!0});var ot=f(R);_(Wt.$$.fragment,ot),Ir=i(ot),On=s(ot,"P",{"data-svelte-h":!0}),u(On)!=="svelte-1pqe2zo"&&(On.innerHTML=Va),Nr=i(ot),_(Re.$$.fragment,ot),Pr=i(ot),_(Oe.$$.fragment,ot),ot.forEach(n),ee.forEach(n),as=i(e),_e=s(e,"H2",{class:!0});var Ts=f(_e);Ve=s(Ts,"A",{id:!0,class:!0,href:!0});var ki=f(Ve);vo=s(ki,"SPAN",{});var Mi=f(vo);_(Ht.$$.fragment,Mi),Mi.forEach(n),ki.forEach(n),qr=i(Ts),Vn=s(Ts,"SPAN",{"data-svelte-h":!0}),u(Vn)!=="svelte-ppj6fy"&&(Vn.textContent=Xa),Ts.forEach(n),is=i(e),P=s(e,"DIV",{class:!0});var te=f(P);_(Zt.$$.fragment,te),Ur=i(te),Xn=s(te,"P",{"data-svelte-h":!0}),u(Xn)!=="svelte-1wydhty"&&(Xn.textContent=Ga),Wr=i(te),Gn=s(te,"P",{"data-svelte-h":!0}),u(Gn)!=="svelte-ev63c"&&(Gn.innerHTML=Qa),Hr=i(te),Qn=s(te,"P",{"data-svelte-h":!0}),u(Qn)!=="svelte-hswkmf"&&(Qn.innerHTML=Da),Zr=i(te),V=s(te,"DIV",{class:!0});var so=f(V);_(St.$$.fragment,so),Sr=i(so),Dn=s(so,"P",{"data-svelte-h":!0}),u(Dn)!=="svelte-xs127u"&&(Dn.innerHTML=Ya),Ar=i(so),_(Xe.$$.fragment,so),so.forEach(n),te.forEach(n),ds=i(e),ye=s(e,"H2",{class:!0});var ks=f(ye);Ge=s(ks,"A",{id:!0,class:!0,href:!0});var wi=f(Ge);To=s(wi,"SPAN",{});var $i=f(To);_(At.$$.fragment,$i),$i.forEach(n),wi.forEach(n),Br=i(ks),Yn=s(ks,"SPAN",{"data-svelte-h":!0}),u(Yn)!=="svelte-7hmpe1"&&(Yn.textContent=Ka),ks.forEach(n),ls=i(e),q=s(e,"DIV",{class:!0});var ne=f(q);_(Bt.$$.fragment,ne),Rr=i(ne),Kn=s(ne,"P",{"data-svelte-h":!0}),u(Kn)!=="svelte-1fvax6s"&&(Kn.innerHTML=ei),Or=i(ne),eo=s(ne,"P",{"data-svelte-h":!0}),u(eo)!=="svelte-ev63c"&&(eo.innerHTML=ti),Vr=i(ne),to=s(ne,"P",{"data-svelte-h":!0}),u(to)!=="svelte-hswkmf"&&(to.innerHTML=ni),Xr=i(ne),X=s(ne,"DIV",{class:!0});var ro=f(X);_(Rt.$$.fragment,ro),Gr=i(ro),no=s(ro,"P",{"data-svelte-h":!0}),u(no)!=="svelte-i4disu"&&(no.innerHTML=oi),Qr=i(ro),_(Qe.$$.fragment,ro),ro.forEach(n),ne.forEach(n),cs=i(e),ko=s(e,"P",{}),f(ko).forEach(n),this.h()},h(){h(r,"name","hf:doc:metadata"),h(r,"content",JSON.stringify(Qi)),h(d,"id","ernie"),h(d,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(d,"href","#ernie"),h(M,"class","relative group"),h(ve,"id","overview"),h(ve,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(ve,"href","#overview"),h(oe,"class","relative group"),h(Te,"id","how-to-use"),h(Te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(Te,"href","#how-to-use"),h(se,"class","relative group"),h(ke,"id","supported-models"),h(ke,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(ke,"href","#supported-models"),h(re,"class","relative group"),h(Me,"id","documentation-resources"),h(Me,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(Me,"href","#documentation-resources"),h(ae,"class","relative group"),h(we,"id","transformers.ErnieConfig"),h(we,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(we,"href","#transformers.ErnieConfig"),h(ie,"class","relative group"),h(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ee,"id","transformers.models.ernie.modeling_ernie.ErnieForPreTrainingOutput"),h(Ee,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(Ee,"href","#transformers.models.ernie.modeling_ernie.ErnieForPreTrainingOutput"),h(de,"class","relative group"),h(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(xe,"id","transformers.ErnieModel"),h(xe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(xe,"href","#transformers.ErnieModel"),h(ce,"class","relative group"),h(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Fe,"id","transformers.ErnieForPreTraining"),h(Fe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(Fe,"href","#transformers.ErnieForPreTraining"),h(pe,"class","relative group"),h(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Le,"id","transformers.ErnieForCausalLM"),h(Le,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(Le,"href","#transformers.ErnieForCausalLM"),h(he,"class","relative group"),h(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Pe,"id","transformers.ErnieForMaskedLM"),h(Pe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(Pe,"href","#transformers.ErnieForMaskedLM"),h(me,"class","relative group"),h(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(We,"id","transformers.ErnieForNextSentencePrediction"),h(We,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(We,"href","#transformers.ErnieForNextSentencePrediction"),h(ue,"class","relative group"),h(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Se,"id","transformers.ErnieForSequenceClassification"),h(Se,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(Se,"href","#transformers.ErnieForSequenceClassification"),h(fe,"class","relative group"),h(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Be,"id","transformers.ErnieForMultipleChoice"),h(Be,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(Be,"href","#transformers.ErnieForMultipleChoice"),h(ge,"class","relative group"),h(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ve,"id","transformers.ErnieForTokenClassification"),h(Ve,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(Ve,"href","#transformers.ErnieForTokenClassification"),h(_e,"class","relative group"),h(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ge,"id","transformers.ErnieForQuestionAnswering"),h(Ge,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(Ge,"href","#transformers.ErnieForQuestionAnswering"),h(ye,"class","relative group"),h(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,l){t(document.head,r),p(e,k,l),p(e,c,l),p(e,m,l),p(e,M,l),t(M,d),t(d,$),y(rt,$,null),t(M,Ms),t(M,Kt),p(e,Lo,l),p(e,oe,l),t(oe,ve),t(ve,ao),y(at,ao,null),t(oe,ws),t(oe,en),p(e,Io,l),p(e,it,l),p(e,No,l),p(e,se,l),t(se,Te),t(Te,io),y(dt,io,null),t(se,$s),t(se,tn),p(e,Po,l),y(lt,e,l),p(e,qo,l),p(e,re,l),t(re,ke),t(ke,lo),y(ct,lo,null),t(re,Es),t(re,nn),p(e,Uo,l),p(e,pt,l),p(e,Wo,l),p(e,ht,l),p(e,Ho,l),p(e,ae,l),t(ae,Me),t(Me,co),y(mt,co,null),t(ae,xs),t(ae,on),p(e,Zo,l),p(e,ut,l),p(e,So,l),p(e,ie,l),t(ie,we),t(we,po),y(ft,po,null),t(ie,Cs),t(ie,sn),p(e,Ao,l),p(e,W,l),y(gt,W,null),t(W,zs),t(W,rn),t(W,Fs),t(W,an),t(W,Js),y($e,W,null),p(e,Bo,l),p(e,de,l),t(de,Ee),t(Ee,ho),y(_t,ho,null),t(de,js),t(de,dn),p(e,Ro,l),p(e,le,l),y(yt,le,null),t(le,Ls),t(le,ln),p(e,Oo,l),p(e,ce,l),t(ce,xe),t(xe,mo),y(bt,mo,null),t(ce,Is),t(ce,cn),p(e,Vo,l),p(e,x,l),y(vt,x,null),t(x,Ns),t(x,pn),t(x,Ps),t(x,hn),t(x,qs),t(x,mn),t(x,Us),t(x,un),t(x,Ws),t(x,fn),t(x,Hs),t(x,H),y(Tt,H,null),t(H,Zs),t(H,gn),t(H,Ss),y(Ce,H,null),t(H,As),y(ze,H,null),p(e,Xo,l),p(e,pe,l),t(pe,Fe),t(Fe,uo),y(kt,uo,null),t(pe,Bs),t(pe,_n),p(e,Go,l),p(e,F,l),y(Mt,F,null),t(F,Rs),t(F,yn),t(F,Os),t(F,bn),t(F,Vs),t(F,vn),t(F,Xs),t(F,Z),y(wt,Z,null),t(Z,Gs),t(Z,Tn),t(Z,Qs),y(Je,Z,null),t(Z,Ds),y(je,Z,null),p(e,Qo,l),p(e,he,l),t(he,Le),t(Le,fo),y($t,fo,null),t(he,Ys),t(he,kn),p(e,Do,l),p(e,J,l),y(Et,J,null),t(J,Ks),t(J,Mn),t(J,er),t(J,wn),t(J,tr),t(J,$n),t(J,nr),t(J,S),y(xt,S,null),t(S,or),t(S,En),t(S,sr),y(Ie,S,null),t(S,rr),y(Ne,S,null),p(e,Yo,l),p(e,me,l),t(me,Pe),t(Pe,go),y(Ct,go,null),t(me,ar),t(me,xn),p(e,Ko,l),p(e,j,l),y(zt,j,null),t(j,ir),t(j,Cn),t(j,dr),t(j,zn),t(j,lr),t(j,Fn),t(j,cr),t(j,A),y(Ft,A,null),t(A,pr),t(A,Jn),t(A,hr),y(qe,A,null),t(A,mr),y(Ue,A,null),p(e,es,l),p(e,ue,l),t(ue,We),t(We,_o),y(Jt,_o,null),t(ue,ur),t(ue,jn),p(e,ts,l),p(e,L,l),y(jt,L,null),t(L,fr),t(L,Ln),t(L,gr),t(L,In),t(L,_r),t(L,Nn),t(L,yr),t(L,B),y(Lt,B,null),t(B,br),t(B,Pn),t(B,vr),y(He,B,null),t(B,Tr),y(Ze,B,null),p(e,ns,l),p(e,fe,l),t(fe,Se),t(Se,yo),y(It,yo,null),t(fe,kr),t(fe,qn),p(e,os,l),p(e,I,l),y(Nt,I,null),t(I,Mr),t(I,Un),t(I,wr),t(I,Wn),t(I,$r),t(I,Hn),t(I,Er),t(I,O),y(Pt,O,null),t(O,xr),t(O,Zn),t(O,Cr),y(Ae,O,null),p(e,ss,l),p(e,ge,l),t(ge,Be),t(Be,bo),y(qt,bo,null),t(ge,zr),t(ge,Sn),p(e,rs,l),p(e,N,l),y(Ut,N,null),t(N,Fr),t(N,An),t(N,Jr),t(N,Bn),t(N,jr),t(N,Rn),t(N,Lr),t(N,R),y(Wt,R,null),t(R,Ir),t(R,On),t(R,Nr),y(Re,R,null),t(R,Pr),y(Oe,R,null),p(e,as,l),p(e,_e,l),t(_e,Ve),t(Ve,vo),y(Ht,vo,null),t(_e,qr),t(_e,Vn),p(e,is,l),p(e,P,l),y(Zt,P,null),t(P,Ur),t(P,Xn),t(P,Wr),t(P,Gn),t(P,Hr),t(P,Qn),t(P,Zr),t(P,V),y(St,V,null),t(V,Sr),t(V,Dn),t(V,Ar),y(Xe,V,null),p(e,ds,l),p(e,ye,l),t(ye,Ge),t(Ge,To),y(At,To,null),t(ye,Br),t(ye,Yn),p(e,ls,l),p(e,q,l),y(Bt,q,null),t(q,Rr),t(q,Kn),t(q,Or),t(q,eo),t(q,Vr),t(q,to),t(q,Xr),t(q,X),y(Rt,X,null),t(X,Gr),t(X,no),t(X,Qr),y(Qe,X,null),p(e,cs,l),p(e,ko,l),ps=!0},p(e,[l]){const Ot={};l&2&&(Ot.$$scope={dirty:l,ctx:e}),$e.$set(Ot);const Mo={};l&2&&(Mo.$$scope={dirty:l,ctx:e}),Ce.$set(Mo);const wo={};l&2&&(wo.$$scope={dirty:l,ctx:e}),ze.$set(wo);const Vt={};l&2&&(Vt.$$scope={dirty:l,ctx:e}),Je.$set(Vt);const $o={};l&2&&($o.$$scope={dirty:l,ctx:e}),je.$set($o);const Eo={};l&2&&(Eo.$$scope={dirty:l,ctx:e}),Ie.$set(Eo);const Xt={};l&2&&(Xt.$$scope={dirty:l,ctx:e}),Ne.$set(Xt);const xo={};l&2&&(xo.$$scope={dirty:l,ctx:e}),qe.$set(xo);const Co={};l&2&&(Co.$$scope={dirty:l,ctx:e}),Ue.$set(Co);const Gt={};l&2&&(Gt.$$scope={dirty:l,ctx:e}),He.$set(Gt);const zo={};l&2&&(zo.$$scope={dirty:l,ctx:e}),Ze.$set(zo);const Fo={};l&2&&(Fo.$$scope={dirty:l,ctx:e}),Ae.$set(Fo);const Qt={};l&2&&(Qt.$$scope={dirty:l,ctx:e}),Re.$set(Qt);const Jo={};l&2&&(Jo.$$scope={dirty:l,ctx:e}),Oe.$set(Jo);const jo={};l&2&&(jo.$$scope={dirty:l,ctx:e}),Xe.$set(jo);const Dt={};l&2&&(Dt.$$scope={dirty:l,ctx:e}),Qe.$set(Dt)},i(e){ps||(b(rt.$$.fragment,e),b(at.$$.fragment,e),b(dt.$$.fragment,e),b(lt.$$.fragment,e),b(ct.$$.fragment,e),b(mt.$$.fragment,e),b(ft.$$.fragment,e),b(gt.$$.fragment,e),b($e.$$.fragment,e),b(_t.$$.fragment,e),b(yt.$$.fragment,e),b(bt.$$.fragment,e),b(vt.$$.fragment,e),b(Tt.$$.fragment,e),b(Ce.$$.fragment,e),b(ze.$$.fragment,e),b(kt.$$.fragment,e),b(Mt.$$.fragment,e),b(wt.$$.fragment,e),b(Je.$$.fragment,e),b(je.$$.fragment,e),b($t.$$.fragment,e),b(Et.$$.fragment,e),b(xt.$$.fragment,e),b(Ie.$$.fragment,e),b(Ne.$$.fragment,e),b(Ct.$$.fragment,e),b(zt.$$.fragment,e),b(Ft.$$.fragment,e),b(qe.$$.fragment,e),b(Ue.$$.fragment,e),b(Jt.$$.fragment,e),b(jt.$$.fragment,e),b(Lt.$$.fragment,e),b(He.$$.fragment,e),b(Ze.$$.fragment,e),b(It.$$.fragment,e),b(Nt.$$.fragment,e),b(Pt.$$.fragment,e),b(Ae.$$.fragment,e),b(qt.$$.fragment,e),b(Ut.$$.fragment,e),b(Wt.$$.fragment,e),b(Re.$$.fragment,e),b(Oe.$$.fragment,e),b(Ht.$$.fragment,e),b(Zt.$$.fragment,e),b(St.$$.fragment,e),b(Xe.$$.fragment,e),b(At.$$.fragment,e),b(Bt.$$.fragment,e),b(Rt.$$.fragment,e),b(Qe.$$.fragment,e),ps=!0)},o(e){v(rt.$$.fragment,e),v(at.$$.fragment,e),v(dt.$$.fragment,e),v(lt.$$.fragment,e),v(ct.$$.fragment,e),v(mt.$$.fragment,e),v(ft.$$.fragment,e),v(gt.$$.fragment,e),v($e.$$.fragment,e),v(_t.$$.fragment,e),v(yt.$$.fragment,e),v(bt.$$.fragment,e),v(vt.$$.fragment,e),v(Tt.$$.fragment,e),v(Ce.$$.fragment,e),v(ze.$$.fragment,e),v(kt.$$.fragment,e),v(Mt.$$.fragment,e),v(wt.$$.fragment,e),v(Je.$$.fragment,e),v(je.$$.fragment,e),v($t.$$.fragment,e),v(Et.$$.fragment,e),v(xt.$$.fragment,e),v(Ie.$$.fragment,e),v(Ne.$$.fragment,e),v(Ct.$$.fragment,e),v(zt.$$.fragment,e),v(Ft.$$.fragment,e),v(qe.$$.fragment,e),v(Ue.$$.fragment,e),v(Jt.$$.fragment,e),v(jt.$$.fragment,e),v(Lt.$$.fragment,e),v(He.$$.fragment,e),v(Ze.$$.fragment,e),v(It.$$.fragment,e),v(Nt.$$.fragment,e),v(Pt.$$.fragment,e),v(Ae.$$.fragment,e),v(qt.$$.fragment,e),v(Ut.$$.fragment,e),v(Wt.$$.fragment,e),v(Re.$$.fragment,e),v(Oe.$$.fragment,e),v(Ht.$$.fragment,e),v(Zt.$$.fragment,e),v(St.$$.fragment,e),v(Xe.$$.fragment,e),v(At.$$.fragment,e),v(Bt.$$.fragment,e),v(Rt.$$.fragment,e),v(Qe.$$.fragment,e),ps=!1},d(e){e&&(n(k),n(c),n(m),n(M),n(Lo),n(oe),n(Io),n(it),n(No),n(se),n(Po),n(qo),n(re),n(Uo),n(pt),n(Wo),n(ht),n(Ho),n(ae),n(Zo),n(ut),n(So),n(ie),n(Ao),n(W),n(Bo),n(de),n(Ro),n(le),n(Oo),n(ce),n(Vo),n(x),n(Xo),n(pe),n(Go),n(F),n(Qo),n(he),n(Do),n(J),n(Yo),n(me),n(Ko),n(j),n(es),n(ue),n(ts),n(L),n(ns),n(fe),n(os),n(I),n(ss),n(ge),n(rs),n(N),n(as),n(_e),n(is),n(P),n(ds),n(ye),n(ls),n(q),n(cs),n(ko)),n(r),T(rt),T(at),T(dt),T(lt,e),T(ct),T(mt),T(ft),T(gt),T($e),T(_t),T(yt),T(bt),T(vt),T(Tt),T(Ce),T(ze),T(kt),T(Mt),T(wt),T(Je),T(je),T($t),T(Et),T(xt),T(Ie),T(Ne),T(Ct),T(zt),T(Ft),T(qe),T(Ue),T(Jt),T(jt),T(Lt),T(He),T(Ze),T(It),T(Nt),T(Pt),T(Ae),T(qt),T(Ut),T(Wt),T(Re),T(Oe),T(Ht),T(Zt),T(St),T(Xe),T(At),T(Bt),T(Rt),T(Qe)}}}const Qi={local:"ernie",sections:[{local:"overview",sections:[{local:"how-to-use",title:"How to use"},{local:"supported-models",title:"Supported Models"}],title:"Overview"},{local:"documentation-resources",title:"Documentation resources"},{local:"transformers.ErnieConfig",title:"ErnieConfig"},{local:"transformers.models.ernie.modeling_ernie.ErnieForPreTrainingOutput",title:"Ernie specific outputs"},{local:"transformers.ErnieModel",title:"ErnieModel"},{local:"transformers.ErnieForPreTraining",title:"ErnieForPreTraining"},{local:"transformers.ErnieForCausalLM",title:"ErnieForCausalLM"},{local:"transformers.ErnieForMaskedLM",title:"ErnieForMaskedLM"},{local:"transformers.ErnieForNextSentencePrediction",title:"ErnieForNextSentencePrediction"},{local:"transformers.ErnieForSequenceClassification",title:"ErnieForSequenceClassification"},{local:"transformers.ErnieForMultipleChoice",title:"ErnieForMultipleChoice"},{local:"transformers.ErnieForTokenClassification",title:"ErnieForTokenClassification"},{local:"transformers.ErnieForQuestionAnswering",title:"ErnieForQuestionAnswering"}],title:"ERNIE"};function Di(w){return zi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class rd extends Fi{constructor(r){super(),Ji(this,r,Di,Gi,Ci,{})}}export{rd as component};
