import{s as ds,f as cs,o as ms,n as Oe}from"../chunks/scheduler.9bc65507.js";import{S as ps,i as gs,g as n,s as r,u as f,A as hs,h as s,f as t,c as i,j as u,v as _,y as p,k as m,o,a as l,w as y,d as T,t as v,x as b}from"../chunks/index.78c82d43.js";import{T as cn}from"../chunks/Tip.87d55b76.js";import{D as U}from"../chunks/Docstring.f3d04bd2.js";import{C as Mo}from"../chunks/CodeBlock.48618ec2.js";import{I as V}from"../chunks/IconCopyLink.bedaa44d.js";import{E as Io}from"../chunks/ExampleCodeBlock.872b014d.js";import{P as us}from"../chunks/PipelineTag.75b0f707.js";function fs(P){let c,I="Example:",g,h,w;return h=new Mo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEltYWdlR1BUQ29uZmlnJTJDJTIwSW1hZ2VHUFRNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBJbWFnZUdQVCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwSW1hZ2VHUFRDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwSW1hZ2VHUFRNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ImageGPTConfig, ImageGPTModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a ImageGPT configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = ImageGPTConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ImageGPTModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`}}),{c(){c=n("p"),c.textContent=I,g=r(),f(h.$$.fragment)},l(d){c=s(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-11lpom8"&&(c.textContent=I),g=i(d),_(h.$$.fragment,d)},m(d,M){l(d,c,M),l(d,g,M),y(h,d,M),w=!0},p:Oe,i(d){w||(T(h.$$.fragment,d),w=!0)},o(d){v(h.$$.fragment,d),w=!1},d(d){d&&(t(c),t(g)),b(h,d)}}}function _s(P){let c,I=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=n("p"),c.innerHTML=I},l(g){c=s(g,"P",{"data-svelte-h":!0}),p(c)!=="svelte-fincs2"&&(c.innerHTML=I)},m(g,h){l(g,c,h)},p:Oe,d(g){g&&t(c)}}}function ys(P){let c,I="Examples:",g,h,w;return h=new Mo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEltYWdlR1BUTW9kZWwlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haSUyRmltYWdlZ3B0LXNtYWxsJTIyKSUwQW1vZGVsJTIwJTNEJTIwSW1hZ2VHUFRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGaW1hZ2VncHQtc21hbGwlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, ImageGPTModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;openai/imagegpt-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ImageGPTModel.from_pretrained(<span class="hljs-string">&quot;openai/imagegpt-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`}}),{c(){c=n("p"),c.textContent=I,g=r(),f(h.$$.fragment)},l(d){c=s(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=I),g=i(d),_(h.$$.fragment,d)},m(d,M){l(d,c,M),l(d,g,M),y(h,d,M),w=!0},p:Oe,i(d){w||(T(h.$$.fragment,d),w=!0)},o(d){v(h.$$.fragment,d),w=!1},d(d){d&&(t(c),t(g)),b(h,d)}}}function Ts(P){let c,I=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=n("p"),c.innerHTML=I},l(g){c=s(g,"P",{"data-svelte-h":!0}),p(c)!=="svelte-fincs2"&&(c.innerHTML=I)},m(g,h){l(g,c,h)},p:Oe,d(g){g&&t(c)}}}function vs(P){let c,I="Examples:",g,h,w;return h=new Mo({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, ImageGPTForCausalImageModeling
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;openai/imagegpt-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ImageGPTForCausalImageModeling.from_pretrained(<span class="hljs-string">&quot;openai/imagegpt-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># unconditional generation of 8 images</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>batch_size = <span class="hljs-number">4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>context = torch.full((batch_size, <span class="hljs-number">1</span>), model.config.vocab_size - <span class="hljs-number">1</span>)  <span class="hljs-comment"># initialize with SOS token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>context = context.to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(
<span class="hljs-meta">... </span>    input_ids=context, max_length=model.config.n_positions + <span class="hljs-number">1</span>, temperature=<span class="hljs-number">1.0</span>, do_sample=<span class="hljs-literal">True</span>, top_k=<span class="hljs-number">40</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>clusters = image_processor.clusters
<span class="hljs-meta">&gt;&gt;&gt; </span>height = image_processor.size[<span class="hljs-string">&quot;height&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>width = image_processor.size[<span class="hljs-string">&quot;width&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>samples = output[:, <span class="hljs-number">1</span>:].cpu().detach().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>samples_img = [
<span class="hljs-meta">... </span>    np.reshape(np.rint(<span class="hljs-number">127.5</span> * (clusters[s] + <span class="hljs-number">1.0</span>)), [height, width, <span class="hljs-number">3</span>]).astype(np.uint8) <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> samples
<span class="hljs-meta">... </span>]  <span class="hljs-comment"># convert color cluster tokens back to pixels</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>f, axes = plt.subplots(<span class="hljs-number">1</span>, batch_size, dpi=<span class="hljs-number">300</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> img, ax <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(samples_img, axes):
<span class="hljs-meta">... </span>    ax.axis(<span class="hljs-string">&quot;off&quot;</span>)
<span class="hljs-meta">... </span>    ax.imshow(img)`}}),{c(){c=n("p"),c.textContent=I,g=r(),f(h.$$.fragment)},l(d){c=s(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=I),g=i(d),_(h.$$.fragment,d)},m(d,M){l(d,c,M),l(d,g,M),y(h,d,M),w=!0},p:Oe,i(d){w||(T(h.$$.fragment,d),w=!0)},o(d){v(h.$$.fragment,d),w=!1},d(d){d&&(t(c),t(g)),b(h,d)}}}function bs(P){let c,I=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=n("p"),c.innerHTML=I},l(g){c=s(g,"P",{"data-svelte-h":!0}),p(c)!=="svelte-fincs2"&&(c.innerHTML=I)},m(g,h){l(g,c,h)},p:Oe,d(g){g&&t(c)}}}function ws(P){let c,I="Examples:",g,h,w;return h=new Mo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEltYWdlR1BURm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGaW1hZ2VncHQtc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBJbWFnZUdQVEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haSUyRmltYWdlZ3B0LXNtYWxsJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, ImageGPTForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;openai/imagegpt-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ImageGPTForImageClassification.from_pretrained(<span class="hljs-string">&quot;openai/imagegpt-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`}}),{c(){c=n("p"),c.textContent=I,g=r(),f(h.$$.fragment)},l(d){c=s(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=I),g=i(d),_(h.$$.fragment,d)},m(d,M){l(d,c,M),l(d,g,M),y(h,d,M),w=!0},p:Oe,i(d){w||(T(h.$$.fragment,d),w=!0)},o(d){v(h.$$.fragment,d),w=!1},d(d){d&&(t(c),t(g)),b(h,d)}}}function Is(P){let c,I,g,h,w,d,M,fe,Po,Ye,mn="ImageGPT",qt,q,X,Pt,_e,Co,Ke,pn="Overview",Zt,ye,gn=`The ImageGPT model was proposed in <a href="https://openai.com/blog/image-gpt" rel="nofollow">Generative Pretraining from Pixels</a> by Mark
Chen, Alec Radford, Rewon Child, Jeffrey Wu, Heewoo Jun, David Luan, Ilya Sutskever. ImageGPT (iGPT) is a GPT-2-like
model trained to predict the next pixel value, allowing for both unconditional and conditional image generation.`,Rt,Te,hn="The abstract from the paper is the following:",Et,ve,un=`<em>Inspired by progress in unsupervised representation learning for natural language, we examine whether similar models
can learn useful representations for images. We train a sequence Transformer to auto-regressively predict pixels,
without incorporating knowledge of the 2D input structure. Despite training on low-resolution ImageNet without labels,
we find that a GPT-2 scale model learns strong image representations as measured by linear probing, fine-tuning, and
low-data classification. On CIFAR-10, we achieve 96.3% accuracy with a linear probe, outperforming a supervised Wide
ResNet, and 99.0% accuracy with full fine-tuning, matching the top supervised pre-trained models. We are also
competitive with self-supervised benchmarks on ImageNet when substituting pixels for a VQVAE encoding, achieving 69.0%
top-1 accuracy on a linear probe of our features.</em>`,Bt,Q,fn,St,be,_n="Summary of the approach. Taken from the [original paper](https://cdn.openai.com/papers/Generative_Pretraining_from_Pixels_V2.pdf).",Lt,we,yn=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>, based on <a href="https://github.com/openai/image-gpt/issues/7" rel="nofollow">this issue</a>. The original code can be found
<a href="https://github.com/openai/image-gpt" rel="nofollow">here</a>.`,At,Ie,Tn="Tips:",Ht,Me,vn=`<li>ImageGPT is almost exactly the same as <a href="gpt2">GPT-2</a>, with the exception that a different activation
function is used (namely “quick gelu”), and the layer normalization layers don’t mean center the inputs. ImageGPT
also doesn’t have tied input- and output embeddings.</li> <li>As the time- and memory requirements of the attention mechanism of Transformers scales quadratically in the sequence
length, the authors pre-trained ImageGPT on smaller input resolutions, such as 32x32 and 64x64. However, feeding a
sequence of 32x32x3=3072 tokens from 0..255 into a Transformer is still prohibitively large. Therefore, the authors
applied k-means clustering to the (R,G,B) pixel values with k=512. This way, we only have a 32*32 = 1024-long
sequence, but now of integers in the range 0..511. So we are shrinking the sequence length at the cost of a bigger
embedding matrix. In other words, the vocabulary size of ImageGPT is 512, + 1 for a special “start of sentence” (SOS)
token, used at the beginning of every sequence. One can use <a href="/docs/transformers/v4.33.3/en/model_doc/imagegpt#transformers.ImageGPTImageProcessor">ImageGPTImageProcessor</a> to prepare
images for the model.</li> <li>Despite being pre-trained entirely unsupervised (i.e. without the use of any labels), ImageGPT produces fairly
performant image features useful for downstream tasks, such as image classification. The authors showed that the
features in the middle of the network are the most performant, and can be used as-is to train a linear model (such as
a sklearn logistic regression model for example). This is also referred to as “linear probing”. Features can be
easily obtained by first forwarding the image through the model, then specifying <code>output_hidden_states=True</code>, and
then average-pool the hidden states at whatever layer you like.</li> <li>Alternatively, one can further fine-tune the entire model on a downstream dataset, similar to BERT. For this, you can
use <a href="/docs/transformers/v4.33.3/en/model_doc/imagegpt#transformers.ImageGPTForImageClassification">ImageGPTForImageClassification</a>.</li> <li>ImageGPT comes in different sizes: there’s ImageGPT-small, ImageGPT-medium and ImageGPT-large. The authors did also
train an XL variant, which they didn’t release. The differences in size are summarized in the following table:</li>`,Vt,Pe,bn="<thead><tr><th><strong>Model variant</strong></th> <th><strong>Depths</strong></th> <th><strong>Hidden sizes</strong></th> <th><strong>Decoder hidden size</strong></th> <th><strong>Params (M)</strong></th> <th><strong>ImageNet-1k Top 1</strong></th></tr></thead> <tbody><tr><td>MiT-b0</td> <td>[2, 2, 2, 2]</td> <td>[32, 64, 160, 256]</td> <td>256</td> <td>3.7</td> <td>70.5</td></tr> <tr><td>MiT-b1</td> <td>[2, 2, 2, 2]</td> <td>[64, 128, 320, 512]</td> <td>256</td> <td>14.0</td> <td>78.7</td></tr> <tr><td>MiT-b2</td> <td>[3, 4, 6, 3]</td> <td>[64, 128, 320, 512]</td> <td>768</td> <td>25.4</td> <td>81.6</td></tr> <tr><td>MiT-b3</td> <td>[3, 4, 18, 3]</td> <td>[64, 128, 320, 512]</td> <td>768</td> <td>45.2</td> <td>83.1</td></tr> <tr><td>MiT-b4</td> <td>[3, 8, 27, 3]</td> <td>[64, 128, 320, 512]</td> <td>768</td> <td>62.6</td> <td>83.6</td></tr> <tr><td>MiT-b5</td> <td>[3, 6, 40, 3]</td> <td>[64, 128, 320, 512]</td> <td>768</td> <td>82.0</td> <td>83.8</td></tr></tbody>",Xt,Z,D,Ct,Ce,ko,et,wn="Resources",Qt,ke,In="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with ImageGPT.",Dt,$e,Ot,xe,Mn='<li>Demo notebooks for ImageGPT can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/ImageGPT" rel="nofollow">here</a>.</li> <li><a href="/docs/transformers/v4.33.3/en/model_doc/imagegpt#transformers.ImageGPTForImageClassification">ImageGPTForImageClassification</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/image-classification" rel="nofollow">example script</a> and <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/image_classification.ipynb" rel="nofollow">notebook</a>.</li> <li>See also: <a href="../tasks/image_classification">Image classification task guide</a></li>',Yt,Ge,Pn="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",Kt,R,O,kt,ze,$o,tt,Cn="ImageGPTConfig",eo,x,je,xo,ot,kn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.33.3/en/model_doc/imagegpt#transformers.ImageGPTModel">ImageGPTModel</a> or a <code>TFImageGPTModel</code>. It is
used to instantiate a GPT-2 model according to the specified arguments, defining the model architecture.
Instantiating a configuration with the defaults will yield a similar configuration to that of the ImageGPT
<a href="https://huggingface.co/openai/imagegpt-small" rel="nofollow">openai/imagegpt-small</a> architecture.`,Go,nt,$n=`Configuration objects inherit from <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,zo,Y,to,E,K,$t,Fe,jo,st,xn="ImageGPTFeatureExtractor",oo,B,Ue,Fo,ee,Je,Uo,at,Gn="Preprocess an image or a batch of images.",no,S,te,xt,We,Jo,rt,zn="ImageGPTImageProcessor",so,F,Ne,Wo,it,jn=`Constructs a ImageGPT image processor. This image processor can be used to resize images to a smaller resolution
(such as 32x32 or 64x64), normalize them and finally color quantize them to obtain sequences of “pixel values”
(color clusters).`,No,oe,qe,qo,lt,Fn="Preprocess an image or batch of images.",ao,L,ne,Gt,Ze,Zo,dt,Un="ImageGPTModel",ro,C,Re,Ro,ct,Jn="The bare ImageGPT Model transformer outputting raw hidden-states without any specific head on top.",Eo,mt,Wn=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Bo,pt,Nn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,So,G,Ee,Lo,gt,qn='The <a href="/docs/transformers/v4.33.3/en/model_doc/imagegpt#transformers.ImageGPTModel">ImageGPTModel</a> forward method, overrides the <code>__call__</code> special method.',Ao,se,Ho,ae,io,A,re,zt,Be,Vo,ht,Zn="ImageGPTForCausalImageModeling",lo,k,Se,Xo,ut,Rn=`The ImageGPT Model transformer with a language modeling head on top (linear layer with weights tied to the input
embeddings).`,Qo,ft,En=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Do,_t,Bn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Oo,z,Le,Yo,yt,Sn='The <a href="/docs/transformers/v4.33.3/en/model_doc/imagegpt#transformers.ImageGPTForCausalImageModeling">ImageGPTForCausalImageModeling</a> forward method, overrides the <code>__call__</code> special method.',Ko,ie,en,le,co,H,de,jt,Ae,tn,Tt,Ln="ImageGPTForImageClassification",mo,$,He,on,vt,An=`The ImageGPT Model transformer with an image classification head on top (linear layer).
<a href="/docs/transformers/v4.33.3/en/model_doc/imagegpt#transformers.ImageGPTForImageClassification">ImageGPTForImageClassification</a> average-pools the hidden states in order to do the classification.`,nn,bt,Hn=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,sn,wt,Vn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,an,j,Ve,rn,It,Xn='The <a href="/docs/transformers/v4.33.3/en/model_doc/imagegpt#transformers.ImageGPTForImageClassification">ImageGPTForImageClassification</a> forward method, overrides the <code>__call__</code> special method.',ln,ce,dn,me,po,Ft,go;return fe=new V({}),_e=new V({}),Ce=new V({}),$e=new us({props:{pipeline:"image-classification"}}),ze=new V({}),je=new U({props:{name:"class transformers.ImageGPTConfig",anchor:"transformers.ImageGPTConfig",parameters:[{name:"vocab_size",val:" = 513"},{name:"n_positions",val:" = 1024"},{name:"n_embd",val:" = 512"},{name:"n_layer",val:" = 24"},{name:"n_head",val:" = 8"},{name:"n_inner",val:" = None"},{name:"activation_function",val:" = 'quick_gelu'"},{name:"resid_pdrop",val:" = 0.1"},{name:"embd_pdrop",val:" = 0.1"},{name:"attn_pdrop",val:" = 0.1"},{name:"layer_norm_epsilon",val:" = 1e-05"},{name:"initializer_range",val:" = 0.02"},{name:"scale_attn_weights",val:" = True"},{name:"use_cache",val:" = True"},{name:"tie_word_embeddings",val:" = False"},{name:"scale_attn_by_inverse_layer_idx",val:" = False"},{name:"reorder_and_upcast_attn",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ImageGPTConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Vocabulary size of the GPT-2 model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/v4.33.3/en/model_doc/imagegpt#transformers.ImageGPTModel">ImageGPTModel</a> or <code>TFImageGPTModel</code>.`,name:"vocab_size"},{anchor:"transformers.ImageGPTConfig.n_positions",description:`<strong>n_positions</strong> (<code>int</code>, <em>optional</em>, defaults to 32*32) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"n_positions"},{anchor:"transformers.ImageGPTConfig.n_embd",description:`<strong>n_embd</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimensionality of the embeddings and hidden states.`,name:"n_embd"},{anchor:"transformers.ImageGPTConfig.n_layer",description:`<strong>n_layer</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"n_layer"},{anchor:"transformers.ImageGPTConfig.n_head",description:`<strong>n_head</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"n_head"},{anchor:"transformers.ImageGPTConfig.n_inner",description:`<strong>n_inner</strong> (<code>int</code>, <em>optional</em>, defaults to None) &#x2014;
Dimensionality of the inner feed-forward layers. <code>None</code> will set it to 4 times n_embd`,name:"n_inner"},{anchor:"transformers.ImageGPTConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;quick_gelu&quot;</code>) &#x2014;
Activation function (can be one of the activation functions defined in src/transformers/activations.py).
Defaults to &#x201C;quick_gelu&#x201D;.`,name:"activation_function"},{anchor:"transformers.ImageGPTConfig.resid_pdrop",description:`<strong>resid_pdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"resid_pdrop"},{anchor:"transformers.ImageGPTConfig.embd_pdrop",description:`<strong>embd_pdrop</strong> (<code>int</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the embeddings.`,name:"embd_pdrop"},{anchor:"transformers.ImageGPTConfig.attn_pdrop",description:`<strong>attn_pdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention.`,name:"attn_pdrop"},{anchor:"transformers.ImageGPTConfig.layer_norm_epsilon",description:`<strong>layer_norm_epsilon</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-5) &#x2014;
The epsilon to use in the layer normalization layers.`,name:"layer_norm_epsilon"},{anchor:"transformers.ImageGPTConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.ImageGPTConfig.scale_attn_weights",description:`<strong>scale_attn_weights</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Scale attention weights by dividing by sqrt(hidden_size)..`,name:"scale_attn_weights"},{anchor:"transformers.ImageGPTConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models).`,name:"use_cache"},{anchor:"transformers.ImageGPTConfig.scale_attn_by_inverse_layer_idx",description:`<strong>scale_attn_by_inverse_layer_idx</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to additionally scale attention weights by <code>1 / layer_idx + 1</code>.`,name:"scale_attn_by_inverse_layer_idx"},{anchor:"transformers.ImageGPTConfig.reorder_and_upcast_attn",description:`<strong>reorder_and_upcast_attn</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to scale keys (K) prior to computing attention (dot-product) and upcast attention
dot-product/softmax to float() when training with mixed precision.`,name:"reorder_and_upcast_attn"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/imagegpt/configuration_imagegpt.py#L37"}}),Y=new Io({props:{anchor:"transformers.ImageGPTConfig.example",$$slots:{default:[fs]},$$scope:{ctx:P}}}),Fe=new V({}),Ue=new U({props:{name:"class transformers.ImageGPTFeatureExtractor",anchor:"transformers.ImageGPTFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/imagegpt/feature_extraction_imagegpt.py#L26"}}),Je=new U({props:{name:"__call__",anchor:"transformers.ImageGPTFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/image_processing_utils.py#L544"}}),We=new V({}),Ne=new U({props:{name:"class transformers.ImageGPTImageProcessor",anchor:"transformers.ImageGPTImageProcessor",parameters:[{name:"clusters",val:": typing.Union[typing.List[typing.List[int]], numpy.ndarray, NoneType] = None"},{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_normalize",val:": bool = True"},{name:"do_color_quantize",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ImageGPTImageProcessor.clusters",description:`<strong>clusters</strong> (<code>np.ndarray</code> or <code>List[List[int]]</code>, <em>optional</em>) &#x2014;
The color clusters to use, of shape <code>(n_clusters, 3)</code> when color quantizing. Can be overriden by <code>clusters</code>
in <code>preprocess</code>.`,name:"clusters"},{anchor:"transformers.ImageGPTImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s dimensions to <code>(size[&quot;height&quot;], size[&quot;width&quot;])</code>. Can be overridden by
<code>do_resize</code> in <code>preprocess</code>.`,name:"do_resize"},{anchor:"transformers.ImageGPTImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 256, &quot;width&quot;: 256}</code>):
Size of the image after resizing. Can be overridden by <code>size</code> in <code>preprocess</code>.`,name:"size"},{anchor:"transformers.ImageGPTImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in <code>preprocess</code>.`,name:"resample"},{anchor:"transformers.ImageGPTImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image pixel value to between [-1, 1]. Can be overridden by <code>do_normalize</code> in
<code>preprocess</code>.`,name:"do_normalize"},{anchor:"transformers.ImageGPTImageProcessor.do_color_quantize",description:`<strong>do_color_quantize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to color quantize the image. Can be overridden by <code>do_color_quantize</code> in <code>preprocess</code>.`,name:"do_color_quantize"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/imagegpt/image_processing_imagegpt.py#L58"}}),qe=new U({props:{name:"preprocess",anchor:"transformers.ImageGPTImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"do_resize",val:": bool = None"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = None"},{name:"do_normalize",val:": bool = None"},{name:"do_color_quantize",val:": typing.Optional[bool] = None"},{name:"clusters",val:": typing.Union[typing.List[typing.List[int]], numpy.ndarray, NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ImageGPTImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_normalize=False</code>.`,name:"images"},{anchor:"transformers.ImageGPTImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.ImageGPTImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing.`,name:"size"},{anchor:"transformers.ImageGPTImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>, Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.ImageGPTImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image`,name:"do_normalize"},{anchor:"transformers.ImageGPTImageProcessor.preprocess.do_color_quantize",description:`<strong>do_color_quantize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_color_quantize</code>) &#x2014;
Whether to color quantize the image.`,name:"do_color_quantize"},{anchor:"transformers.ImageGPTImageProcessor.preprocess.clusters",description:`<strong>clusters</strong> (<code>np.ndarray</code> or <code>List[List[int]]</code>, <em>optional</em>, defaults to <code>self.clusters</code>) &#x2014;
Clusters used to quantize the image of shape <code>(n_clusters, 3)</code>. Only has an effect if
<code>do_color_quantize</code> is set to <code>True</code>.`,name:"clusters"},{anchor:"transformers.ImageGPTImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.ImageGPTImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.
Only has an effect if <code>do_color_quantize</code> is set to <code>False</code>.</li>
</ul>`,name:"data_format"},{anchor:"transformers.ImageGPTImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/imagegpt/image_processing_imagegpt.py#L175"}}),Ze=new V({}),Re=new U({props:{name:"class transformers.ImageGPTModel",anchor:"transformers.ImageGPTModel",parameters:[{name:"config",val:": ImageGPTConfig"}],parametersDescription:[{anchor:"transformers.ImageGPTModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/imagegpt#transformers.ImageGPTConfig">ImageGPTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/imagegpt/modeling_imagegpt.py#L616"}}),Ee=new U({props:{name:"forward",anchor:"transformers.ImageGPTModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:": typing.Any"}],parametersDescription:[{anchor:"transformers.ImageGPTModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else
<code>past_key_values[0][0].shape[-2]</code> (<code>sequence_length</code> of input past key value states). Indices of input
sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.33.3/en/model_doc/mobilevit#transformers.MobileViTFeatureExtractor.__call__">ImageGPTImageProcessor.<strong>call</strong>()</a> for details.`,name:"input_ids"},{anchor:"transformers.ImageGPTModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.Tensor]]</code> of length <code>config.n_layers</code>) &#x2014;
Contains precomputed hidden-states (key and values in the attention blocks) as computed by the model (see
<code>past_key_values</code> output below). Can be used to speed up sequential decoding. The <code>input_ids</code> which have
their past given to this model should not be passed as <code>input_ids</code> as they have already been computed.`,name:"past_key_values"},{anchor:"transformers.ImageGPTModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ImageGPTModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.ImageGPTModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ImageGPTModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ImageGPTModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>inputs_embeds</code> have to be input (see
<code>past_key_values</code>).`,name:"inputs_embeds"},{anchor:"transformers.ImageGPTModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.ImageGPTModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ImageGPTModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ImageGPTModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ImageGPTModel.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/imagegpt/modeling_imagegpt.py#L649",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/imagegpt#transformers.ImageGPTConfig"
>ImageGPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),se=new cn({props:{$$slots:{default:[_s]},$$scope:{ctx:P}}}),ae=new Io({props:{anchor:"transformers.ImageGPTModel.forward.example",$$slots:{default:[ys]},$$scope:{ctx:P}}}),Be=new V({}),Se=new U({props:{name:"class transformers.ImageGPTForCausalImageModeling",anchor:"transformers.ImageGPTForCausalImageModeling",parameters:[{name:"config",val:": ImageGPTConfig"}],parametersDescription:[{anchor:"transformers.ImageGPTForCausalImageModeling.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/imagegpt#transformers.ImageGPTConfig">ImageGPTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/imagegpt/modeling_imagegpt.py#L895"}}),Le=new U({props:{name:"forward",anchor:"transformers.ImageGPTForCausalImageModeling.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:": typing.Any"}],parametersDescription:[{anchor:"transformers.ImageGPTForCausalImageModeling.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else
<code>past_key_values[0][0].shape[-2]</code> (<code>sequence_length</code> of input past key value states). Indices of input
sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.33.3/en/model_doc/mobilevit#transformers.MobileViTFeatureExtractor.__call__">ImageGPTImageProcessor.<strong>call</strong>()</a> for details.`,name:"input_ids"},{anchor:"transformers.ImageGPTForCausalImageModeling.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.Tensor]]</code> of length <code>config.n_layers</code>) &#x2014;
Contains precomputed hidden-states (key and values in the attention blocks) as computed by the model (see
<code>past_key_values</code> output below). Can be used to speed up sequential decoding. The <code>input_ids</code> which have
their past given to this model should not be passed as <code>input_ids</code> as they have already been computed.`,name:"past_key_values"},{anchor:"transformers.ImageGPTForCausalImageModeling.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ImageGPTForCausalImageModeling.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.ImageGPTForCausalImageModeling.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ImageGPTForCausalImageModeling.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ImageGPTForCausalImageModeling.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>inputs_embeds</code> have to be input (see
<code>past_key_values</code>).`,name:"inputs_embeds"},{anchor:"transformers.ImageGPTForCausalImageModeling.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.ImageGPTForCausalImageModeling.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ImageGPTForCausalImageModeling.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ImageGPTForCausalImageModeling.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ImageGPTForCausalImageModeling.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/imagegpt/modeling_imagegpt.py#L943",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/imagegpt#transformers.ImageGPTConfig"
>ImageGPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Cross attentions weights after the attention softmax, used to compute the weighted average in the
cross-attention heads.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>torch.FloatTensor</code> tuples of length <code>config.n_layers</code>, with each tuple containing the cached key,
value states of the self-attention and the cross-attention layers if model is used in encoder-decoder
setting. Only relevant if <code>config.is_decoder = True</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ie=new cn({props:{$$slots:{default:[Ts]},$$scope:{ctx:P}}}),le=new Io({props:{anchor:"transformers.ImageGPTForCausalImageModeling.forward.example",$$slots:{default:[vs]},$$scope:{ctx:P}}}),Ae=new V({}),He=new U({props:{name:"class transformers.ImageGPTForImageClassification",anchor:"transformers.ImageGPTForImageClassification",parameters:[{name:"config",val:": ImageGPTConfig"}],parametersDescription:[{anchor:"transformers.ImageGPTForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/imagegpt#transformers.ImageGPTConfig">ImageGPTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/imagegpt/modeling_imagegpt.py#L1086"}}),Ve=new U({props:{name:"forward",anchor:"transformers.ImageGPTForImageClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:": typing.Any"}],parametersDescription:[{anchor:"transformers.ImageGPTForImageClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else
<code>past_key_values[0][0].shape[-2]</code> (<code>sequence_length</code> of input past key value states). Indices of input
sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.33.3/en/model_doc/mobilevit#transformers.MobileViTFeatureExtractor.__call__">ImageGPTImageProcessor.<strong>call</strong>()</a> for details.`,name:"input_ids"},{anchor:"transformers.ImageGPTForImageClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.Tensor]]</code> of length <code>config.n_layers</code>) &#x2014;
Contains precomputed hidden-states (key and values in the attention blocks) as computed by the model (see
<code>past_key_values</code> output below). Can be used to speed up sequential decoding. The <code>input_ids</code> which have
their past given to this model should not be passed as <code>input_ids</code> as they have already been computed.`,name:"past_key_values"},{anchor:"transformers.ImageGPTForImageClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ImageGPTForImageClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.ImageGPTForImageClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ImageGPTForImageClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ImageGPTForImageClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>inputs_embeds</code> have to be input (see
<code>past_key_values</code>).`,name:"inputs_embeds"},{anchor:"transformers.ImageGPTForImageClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.ImageGPTForImageClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ImageGPTForImageClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ImageGPTForImageClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ImageGPTForImageClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/imagegpt/modeling_imagegpt.py#L1096",returnDescription:`
<p>A <code>transformers.modeling_outputs.SequenceClassifierOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/imagegpt#transformers.ImageGPTConfig"
>ImageGPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><code>transformers.modeling_outputs.SequenceClassifierOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ce=new cn({props:{$$slots:{default:[bs]},$$scope:{ctx:P}}}),me=new Io({props:{anchor:"transformers.ImageGPTForImageClassification.forward.example",$$slots:{default:[ws]},$$scope:{ctx:P}}}),{c(){c=n("meta"),I=r(),g=n("p"),h=r(),w=n("h1"),d=n("a"),M=n("span"),f(fe.$$.fragment),Po=r(),Ye=n("span"),Ye.textContent=mn,qt=r(),q=n("h2"),X=n("a"),Pt=n("span"),f(_e.$$.fragment),Co=r(),Ke=n("span"),Ke.textContent=pn,Zt=r(),ye=n("p"),ye.innerHTML=gn,Rt=r(),Te=n("p"),Te.textContent=hn,Et=r(),ve=n("p"),ve.innerHTML=un,Bt=r(),Q=n("img"),St=r(),be=n("small"),be.textContent=_n,Lt=r(),we=n("p"),we.innerHTML=yn,At=r(),Ie=n("p"),Ie.textContent=Tn,Ht=r(),Me=n("ul"),Me.innerHTML=vn,Vt=r(),Pe=n("table"),Pe.innerHTML=bn,Xt=r(),Z=n("h2"),D=n("a"),Ct=n("span"),f(Ce.$$.fragment),ko=r(),et=n("span"),et.textContent=wn,Qt=r(),ke=n("p"),ke.textContent=In,Dt=r(),f($e.$$.fragment),Ot=r(),xe=n("ul"),xe.innerHTML=Mn,Yt=r(),Ge=n("p"),Ge.textContent=Pn,Kt=r(),R=n("h2"),O=n("a"),kt=n("span"),f(ze.$$.fragment),$o=r(),tt=n("span"),tt.textContent=Cn,eo=r(),x=n("div"),f(je.$$.fragment),xo=r(),ot=n("p"),ot.innerHTML=kn,Go=r(),nt=n("p"),nt.innerHTML=$n,zo=r(),f(Y.$$.fragment),to=r(),E=n("h2"),K=n("a"),$t=n("span"),f(Fe.$$.fragment),jo=r(),st=n("span"),st.textContent=xn,oo=r(),B=n("div"),f(Ue.$$.fragment),Fo=r(),ee=n("div"),f(Je.$$.fragment),Uo=r(),at=n("p"),at.textContent=Gn,no=r(),S=n("h2"),te=n("a"),xt=n("span"),f(We.$$.fragment),Jo=r(),rt=n("span"),rt.textContent=zn,so=r(),F=n("div"),f(Ne.$$.fragment),Wo=r(),it=n("p"),it.textContent=jn,No=r(),oe=n("div"),f(qe.$$.fragment),qo=r(),lt=n("p"),lt.textContent=Fn,ao=r(),L=n("h2"),ne=n("a"),Gt=n("span"),f(Ze.$$.fragment),Zo=r(),dt=n("span"),dt.textContent=Un,ro=r(),C=n("div"),f(Re.$$.fragment),Ro=r(),ct=n("p"),ct.textContent=Jn,Eo=r(),mt=n("p"),mt.innerHTML=Wn,Bo=r(),pt=n("p"),pt.innerHTML=Nn,So=r(),G=n("div"),f(Ee.$$.fragment),Lo=r(),gt=n("p"),gt.innerHTML=qn,Ao=r(),f(se.$$.fragment),Ho=r(),f(ae.$$.fragment),io=r(),A=n("h2"),re=n("a"),zt=n("span"),f(Be.$$.fragment),Vo=r(),ht=n("span"),ht.textContent=Zn,lo=r(),k=n("div"),f(Se.$$.fragment),Xo=r(),ut=n("p"),ut.textContent=Rn,Qo=r(),ft=n("p"),ft.innerHTML=En,Do=r(),_t=n("p"),_t.innerHTML=Bn,Oo=r(),z=n("div"),f(Le.$$.fragment),Yo=r(),yt=n("p"),yt.innerHTML=Sn,Ko=r(),f(ie.$$.fragment),en=r(),f(le.$$.fragment),co=r(),H=n("h2"),de=n("a"),jt=n("span"),f(Ae.$$.fragment),tn=r(),Tt=n("span"),Tt.textContent=Ln,mo=r(),$=n("div"),f(He.$$.fragment),on=r(),vt=n("p"),vt.innerHTML=An,nn=r(),bt=n("p"),bt.innerHTML=Hn,sn=r(),wt=n("p"),wt.innerHTML=Vn,an=r(),j=n("div"),f(Ve.$$.fragment),rn=r(),It=n("p"),It.innerHTML=Xn,ln=r(),f(ce.$$.fragment),dn=r(),f(me.$$.fragment),po=r(),Ft=n("p"),this.h()},l(e){const a=hs("svelte-1phssyn",document.head);c=s(a,"META",{name:!0,content:!0}),a.forEach(t),I=i(e),g=s(e,"P",{}),u(g).forEach(t),h=i(e),w=s(e,"H1",{class:!0});var Xe=u(w);d=s(Xe,"A",{id:!0,class:!0,href:!0});var Ut=u(d);M=s(Ut,"SPAN",{});var Jt=u(M);_(fe.$$.fragment,Jt),Jt.forEach(t),Ut.forEach(t),Po=i(Xe),Ye=s(Xe,"SPAN",{"data-svelte-h":!0}),p(Ye)!=="svelte-7xiq23"&&(Ye.textContent=mn),Xe.forEach(t),qt=i(e),q=s(e,"H2",{class:!0});var Qe=u(q);X=s(Qe,"A",{id:!0,class:!0,href:!0});var Wt=u(X);Pt=s(Wt,"SPAN",{});var Nt=u(Pt);_(_e.$$.fragment,Nt),Nt.forEach(t),Wt.forEach(t),Co=i(Qe),Ke=s(Qe,"SPAN",{"data-svelte-h":!0}),p(Ke)!=="svelte-1jsw1pg"&&(Ke.textContent=pn),Qe.forEach(t),Zt=i(e),ye=s(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-thwva5"&&(ye.innerHTML=gn),Rt=i(e),Te=s(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-vfdo9a"&&(Te.textContent=hn),Et=i(e),ve=s(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-1nknq39"&&(ve.innerHTML=un),Bt=i(e),Q=s(e,"IMG",{src:!0,alt:!0,width:!0}),St=i(e),be=s(e,"SMALL",{"data-svelte-h":!0}),p(be)!=="svelte-1yh5y0e"&&(be.textContent=_n),Lt=i(e),we=s(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1y5dk1"&&(we.innerHTML=yn),At=i(e),Ie=s(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-axv494"&&(Ie.textContent=Tn),Ht=i(e),Me=s(e,"UL",{"data-svelte-h":!0}),p(Me)!=="svelte-1nk6v3t"&&(Me.innerHTML=vn),Vt=i(e),Pe=s(e,"TABLE",{"data-svelte-h":!0}),p(Pe)!=="svelte-631n1h"&&(Pe.innerHTML=bn),Xt=i(e),Z=s(e,"H2",{class:!0});var De=u(Z);D=s(De,"A",{id:!0,class:!0,href:!0});var Qn=u(D);Ct=s(Qn,"SPAN",{});var Dn=u(Ct);_(Ce.$$.fragment,Dn),Dn.forEach(t),Qn.forEach(t),ko=i(De),et=s(De,"SPAN",{"data-svelte-h":!0}),p(et)!=="svelte-w4zzv6"&&(et.textContent=wn),De.forEach(t),Qt=i(e),ke=s(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-34o9qd"&&(ke.textContent=In),Dt=i(e),_($e.$$.fragment,e),Ot=i(e),xe=s(e,"UL",{"data-svelte-h":!0}),p(xe)!=="svelte-1mnifpl"&&(xe.innerHTML=Mn),Yt=i(e),Ge=s(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-1xesile"&&(Ge.textContent=Pn),Kt=i(e),R=s(e,"H2",{class:!0});var ho=u(R);O=s(ho,"A",{id:!0,class:!0,href:!0});var On=u(O);kt=s(On,"SPAN",{});var Yn=u(kt);_(ze.$$.fragment,Yn),Yn.forEach(t),On.forEach(t),$o=i(ho),tt=s(ho,"SPAN",{"data-svelte-h":!0}),p(tt)!=="svelte-146p1l5"&&(tt.textContent=Cn),ho.forEach(t),eo=i(e),x=s(e,"DIV",{class:!0});var pe=u(x);_(je.$$.fragment,pe),xo=i(pe),ot=s(pe,"P",{"data-svelte-h":!0}),p(ot)!=="svelte-urzyfz"&&(ot.innerHTML=kn),Go=i(pe),nt=s(pe,"P",{"data-svelte-h":!0}),p(nt)!=="svelte-cfh5wl"&&(nt.innerHTML=$n),zo=i(pe),_(Y.$$.fragment,pe),pe.forEach(t),to=i(e),E=s(e,"H2",{class:!0});var uo=u(E);K=s(uo,"A",{id:!0,class:!0,href:!0});var Kn=u(K);$t=s(Kn,"SPAN",{});var es=u($t);_(Fe.$$.fragment,es),es.forEach(t),Kn.forEach(t),jo=i(uo),st=s(uo,"SPAN",{"data-svelte-h":!0}),p(st)!=="svelte-lnnke5"&&(st.textContent=xn),uo.forEach(t),oo=i(e),B=s(e,"DIV",{class:!0});var fo=u(B);_(Ue.$$.fragment,fo),Fo=i(fo),ee=s(fo,"DIV",{class:!0});var _o=u(ee);_(Je.$$.fragment,_o),Uo=i(_o),at=s(_o,"P",{"data-svelte-h":!0}),p(at)!=="svelte-khengj"&&(at.textContent=Gn),_o.forEach(t),fo.forEach(t),no=i(e),S=s(e,"H2",{class:!0});var yo=u(S);te=s(yo,"A",{id:!0,class:!0,href:!0});var ts=u(te);xt=s(ts,"SPAN",{});var os=u(xt);_(We.$$.fragment,os),os.forEach(t),ts.forEach(t),Jo=i(yo),rt=s(yo,"SPAN",{"data-svelte-h":!0}),p(rt)!=="svelte-vy24em"&&(rt.textContent=zn),yo.forEach(t),so=i(e),F=s(e,"DIV",{class:!0});var Mt=u(F);_(Ne.$$.fragment,Mt),Wo=i(Mt),it=s(Mt,"P",{"data-svelte-h":!0}),p(it)!=="svelte-4cfp03"&&(it.textContent=jn),No=i(Mt),oe=s(Mt,"DIV",{class:!0});var To=u(oe);_(qe.$$.fragment,To),qo=i(To),lt=s(To,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-1x3yxsa"&&(lt.textContent=Fn),To.forEach(t),Mt.forEach(t),ao=i(e),L=s(e,"H2",{class:!0});var vo=u(L);ne=s(vo,"A",{id:!0,class:!0,href:!0});var ns=u(ne);Gt=s(ns,"SPAN",{});var ss=u(Gt);_(Ze.$$.fragment,ss),ss.forEach(t),ns.forEach(t),Zo=i(vo),dt=s(vo,"SPAN",{"data-svelte-h":!0}),p(dt)!=="svelte-1u27gvo"&&(dt.textContent=Un),vo.forEach(t),ro=i(e),C=s(e,"DIV",{class:!0});var J=u(C);_(Re.$$.fragment,J),Ro=i(J),ct=s(J,"P",{"data-svelte-h":!0}),p(ct)!=="svelte-fy7x11"&&(ct.textContent=Jn),Eo=i(J),mt=s(J,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-ev63c"&&(mt.innerHTML=Wn),Bo=i(J),pt=s(J,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-hswkmf"&&(pt.innerHTML=Nn),So=i(J),G=s(J,"DIV",{class:!0});var ge=u(G);_(Ee.$$.fragment,ge),Lo=i(ge),gt=s(ge,"P",{"data-svelte-h":!0}),p(gt)!=="svelte-11zz933"&&(gt.innerHTML=qn),Ao=i(ge),_(se.$$.fragment,ge),Ho=i(ge),_(ae.$$.fragment,ge),ge.forEach(t),J.forEach(t),io=i(e),A=s(e,"H2",{class:!0});var bo=u(A);re=s(bo,"A",{id:!0,class:!0,href:!0});var as=u(re);zt=s(as,"SPAN",{});var rs=u(zt);_(Be.$$.fragment,rs),rs.forEach(t),as.forEach(t),Vo=i(bo),ht=s(bo,"SPAN",{"data-svelte-h":!0}),p(ht)!=="svelte-wvp7tz"&&(ht.textContent=Zn),bo.forEach(t),lo=i(e),k=s(e,"DIV",{class:!0});var W=u(k);_(Se.$$.fragment,W),Xo=i(W),ut=s(W,"P",{"data-svelte-h":!0}),p(ut)!=="svelte-1jpvdp1"&&(ut.textContent=Rn),Qo=i(W),ft=s(W,"P",{"data-svelte-h":!0}),p(ft)!=="svelte-ev63c"&&(ft.innerHTML=En),Do=i(W),_t=s(W,"P",{"data-svelte-h":!0}),p(_t)!=="svelte-hswkmf"&&(_t.innerHTML=Bn),Oo=i(W),z=s(W,"DIV",{class:!0});var he=u(z);_(Le.$$.fragment,he),Yo=i(he),yt=s(he,"P",{"data-svelte-h":!0}),p(yt)!=="svelte-1gcentf"&&(yt.innerHTML=Sn),Ko=i(he),_(ie.$$.fragment,he),en=i(he),_(le.$$.fragment,he),he.forEach(t),W.forEach(t),co=i(e),H=s(e,"H2",{class:!0});var wo=u(H);de=s(wo,"A",{id:!0,class:!0,href:!0});var is=u(de);jt=s(is,"SPAN",{});var ls=u(jt);_(Ae.$$.fragment,ls),ls.forEach(t),is.forEach(t),tn=i(wo),Tt=s(wo,"SPAN",{"data-svelte-h":!0}),p(Tt)!=="svelte-1wcg0zv"&&(Tt.textContent=Ln),wo.forEach(t),mo=i(e),$=s(e,"DIV",{class:!0});var N=u($);_(He.$$.fragment,N),on=i(N),vt=s(N,"P",{"data-svelte-h":!0}),p(vt)!=="svelte-79e0c9"&&(vt.innerHTML=An),nn=i(N),bt=s(N,"P",{"data-svelte-h":!0}),p(bt)!=="svelte-ev63c"&&(bt.innerHTML=Hn),sn=i(N),wt=s(N,"P",{"data-svelte-h":!0}),p(wt)!=="svelte-hswkmf"&&(wt.innerHTML=Vn),an=i(N),j=s(N,"DIV",{class:!0});var ue=u(j);_(Ve.$$.fragment,ue),rn=i(ue),It=s(ue,"P",{"data-svelte-h":!0}),p(It)!=="svelte-1iympwb"&&(It.innerHTML=Xn),ln=i(ue),_(ce.$$.fragment,ue),dn=i(ue),_(me.$$.fragment,ue),ue.forEach(t),N.forEach(t),po=i(e),Ft=s(e,"P",{}),u(Ft).forEach(t),this.h()},h(){m(c,"name","hf:doc:metadata"),m(c,"content",JSON.stringify(Ms)),m(d,"id","imagegpt"),m(d,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(d,"href","#imagegpt"),m(w,"class","relative group"),m(X,"id","overview"),m(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(X,"href","#overview"),m(q,"class","relative group"),cs(Q.src,fn="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/imagegpt_architecture.png")||m(Q,"src",fn),m(Q,"alt","drawing"),m(Q,"width","600"),m(D,"id","resources"),m(D,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(D,"href","#resources"),m(Z,"class","relative group"),m(O,"id","transformers.ImageGPTConfig"),m(O,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(O,"href","#transformers.ImageGPTConfig"),m(R,"class","relative group"),m(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(K,"id","transformers.ImageGPTFeatureExtractor"),m(K,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(K,"href","#transformers.ImageGPTFeatureExtractor"),m(E,"class","relative group"),m(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(te,"id","transformers.ImageGPTImageProcessor"),m(te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(te,"href","#transformers.ImageGPTImageProcessor"),m(S,"class","relative group"),m(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(ne,"id","transformers.ImageGPTModel"),m(ne,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(ne,"href","#transformers.ImageGPTModel"),m(L,"class","relative group"),m(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(re,"id","transformers.ImageGPTForCausalImageModeling"),m(re,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(re,"href","#transformers.ImageGPTForCausalImageModeling"),m(A,"class","relative group"),m(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(de,"id","transformers.ImageGPTForImageClassification"),m(de,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(de,"href","#transformers.ImageGPTForImageClassification"),m(H,"class","relative group"),m(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){o(document.head,c),l(e,I,a),l(e,g,a),l(e,h,a),l(e,w,a),o(w,d),o(d,M),y(fe,M,null),o(w,Po),o(w,Ye),l(e,qt,a),l(e,q,a),o(q,X),o(X,Pt),y(_e,Pt,null),o(q,Co),o(q,Ke),l(e,Zt,a),l(e,ye,a),l(e,Rt,a),l(e,Te,a),l(e,Et,a),l(e,ve,a),l(e,Bt,a),l(e,Q,a),l(e,St,a),l(e,be,a),l(e,Lt,a),l(e,we,a),l(e,At,a),l(e,Ie,a),l(e,Ht,a),l(e,Me,a),l(e,Vt,a),l(e,Pe,a),l(e,Xt,a),l(e,Z,a),o(Z,D),o(D,Ct),y(Ce,Ct,null),o(Z,ko),o(Z,et),l(e,Qt,a),l(e,ke,a),l(e,Dt,a),y($e,e,a),l(e,Ot,a),l(e,xe,a),l(e,Yt,a),l(e,Ge,a),l(e,Kt,a),l(e,R,a),o(R,O),o(O,kt),y(ze,kt,null),o(R,$o),o(R,tt),l(e,eo,a),l(e,x,a),y(je,x,null),o(x,xo),o(x,ot),o(x,Go),o(x,nt),o(x,zo),y(Y,x,null),l(e,to,a),l(e,E,a),o(E,K),o(K,$t),y(Fe,$t,null),o(E,jo),o(E,st),l(e,oo,a),l(e,B,a),y(Ue,B,null),o(B,Fo),o(B,ee),y(Je,ee,null),o(ee,Uo),o(ee,at),l(e,no,a),l(e,S,a),o(S,te),o(te,xt),y(We,xt,null),o(S,Jo),o(S,rt),l(e,so,a),l(e,F,a),y(Ne,F,null),o(F,Wo),o(F,it),o(F,No),o(F,oe),y(qe,oe,null),o(oe,qo),o(oe,lt),l(e,ao,a),l(e,L,a),o(L,ne),o(ne,Gt),y(Ze,Gt,null),o(L,Zo),o(L,dt),l(e,ro,a),l(e,C,a),y(Re,C,null),o(C,Ro),o(C,ct),o(C,Eo),o(C,mt),o(C,Bo),o(C,pt),o(C,So),o(C,G),y(Ee,G,null),o(G,Lo),o(G,gt),o(G,Ao),y(se,G,null),o(G,Ho),y(ae,G,null),l(e,io,a),l(e,A,a),o(A,re),o(re,zt),y(Be,zt,null),o(A,Vo),o(A,ht),l(e,lo,a),l(e,k,a),y(Se,k,null),o(k,Xo),o(k,ut),o(k,Qo),o(k,ft),o(k,Do),o(k,_t),o(k,Oo),o(k,z),y(Le,z,null),o(z,Yo),o(z,yt),o(z,Ko),y(ie,z,null),o(z,en),y(le,z,null),l(e,co,a),l(e,H,a),o(H,de),o(de,jt),y(Ae,jt,null),o(H,tn),o(H,Tt),l(e,mo,a),l(e,$,a),y(He,$,null),o($,on),o($,vt),o($,nn),o($,bt),o($,sn),o($,wt),o($,an),o($,j),y(Ve,j,null),o(j,rn),o(j,It),o(j,ln),y(ce,j,null),o(j,dn),y(me,j,null),l(e,po,a),l(e,Ft,a),go=!0},p(e,[a]){const Xe={};a&2&&(Xe.$$scope={dirty:a,ctx:e}),Y.$set(Xe);const Ut={};a&2&&(Ut.$$scope={dirty:a,ctx:e}),se.$set(Ut);const Jt={};a&2&&(Jt.$$scope={dirty:a,ctx:e}),ae.$set(Jt);const Qe={};a&2&&(Qe.$$scope={dirty:a,ctx:e}),ie.$set(Qe);const Wt={};a&2&&(Wt.$$scope={dirty:a,ctx:e}),le.$set(Wt);const Nt={};a&2&&(Nt.$$scope={dirty:a,ctx:e}),ce.$set(Nt);const De={};a&2&&(De.$$scope={dirty:a,ctx:e}),me.$set(De)},i(e){go||(T(fe.$$.fragment,e),T(_e.$$.fragment,e),T(Ce.$$.fragment,e),T($e.$$.fragment,e),T(ze.$$.fragment,e),T(je.$$.fragment,e),T(Y.$$.fragment,e),T(Fe.$$.fragment,e),T(Ue.$$.fragment,e),T(Je.$$.fragment,e),T(We.$$.fragment,e),T(Ne.$$.fragment,e),T(qe.$$.fragment,e),T(Ze.$$.fragment,e),T(Re.$$.fragment,e),T(Ee.$$.fragment,e),T(se.$$.fragment,e),T(ae.$$.fragment,e),T(Be.$$.fragment,e),T(Se.$$.fragment,e),T(Le.$$.fragment,e),T(ie.$$.fragment,e),T(le.$$.fragment,e),T(Ae.$$.fragment,e),T(He.$$.fragment,e),T(Ve.$$.fragment,e),T(ce.$$.fragment,e),T(me.$$.fragment,e),go=!0)},o(e){v(fe.$$.fragment,e),v(_e.$$.fragment,e),v(Ce.$$.fragment,e),v($e.$$.fragment,e),v(ze.$$.fragment,e),v(je.$$.fragment,e),v(Y.$$.fragment,e),v(Fe.$$.fragment,e),v(Ue.$$.fragment,e),v(Je.$$.fragment,e),v(We.$$.fragment,e),v(Ne.$$.fragment,e),v(qe.$$.fragment,e),v(Ze.$$.fragment,e),v(Re.$$.fragment,e),v(Ee.$$.fragment,e),v(se.$$.fragment,e),v(ae.$$.fragment,e),v(Be.$$.fragment,e),v(Se.$$.fragment,e),v(Le.$$.fragment,e),v(ie.$$.fragment,e),v(le.$$.fragment,e),v(Ae.$$.fragment,e),v(He.$$.fragment,e),v(Ve.$$.fragment,e),v(ce.$$.fragment,e),v(me.$$.fragment,e),go=!1},d(e){e&&(t(I),t(g),t(h),t(w),t(qt),t(q),t(Zt),t(ye),t(Rt),t(Te),t(Et),t(ve),t(Bt),t(Q),t(St),t(be),t(Lt),t(we),t(At),t(Ie),t(Ht),t(Me),t(Vt),t(Pe),t(Xt),t(Z),t(Qt),t(ke),t(Dt),t(Ot),t(xe),t(Yt),t(Ge),t(Kt),t(R),t(eo),t(x),t(to),t(E),t(oo),t(B),t(no),t(S),t(so),t(F),t(ao),t(L),t(ro),t(C),t(io),t(A),t(lo),t(k),t(co),t(H),t(mo),t($),t(po),t(Ft)),t(c),b(fe),b(_e),b(Ce),b($e,e),b(ze),b(je),b(Y),b(Fe),b(Ue),b(Je),b(We),b(Ne),b(qe),b(Ze),b(Re),b(Ee),b(se),b(ae),b(Be),b(Se),b(Le),b(ie),b(le),b(Ae),b(He),b(Ve),b(ce),b(me)}}}const Ms={local:"imagegpt",sections:[{local:"overview",title:"Overview"},{local:"resources",title:"Resources"},{local:"transformers.ImageGPTConfig",title:"ImageGPTConfig"},{local:"transformers.ImageGPTFeatureExtractor",title:"ImageGPTFeatureExtractor"},{local:"transformers.ImageGPTImageProcessor",title:"ImageGPTImageProcessor"},{local:"transformers.ImageGPTModel",title:"ImageGPTModel"},{local:"transformers.ImageGPTForCausalImageModeling",title:"ImageGPTForCausalImageModeling"},{local:"transformers.ImageGPTForImageClassification",title:"ImageGPTForImageClassification"}],title:"ImageGPT"};function Ps(P){return ms(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Us extends ps{constructor(c){super(),gs(this,c,Ps,Is,ds,{})}}export{Us as component};
