import{s as it,n as ot,o as rt}from"../chunks/scheduler.9bc65507.js";import{S as ct,i as dt,g as p,s as a,u as d,A as Mt,h as i,f as s,c as n,j as M,v as h,y as o,k as r,o as c,a as l,w as y,d as u,t as m,x as w}from"../chunks/index.78c82d43.js";import{I as ws}from"../chunks/IconCopyLink.bedaa44d.js";import{C as T}from"../chunks/CodeBlock.48618ec2.js";function ht(Us){let J,Ie,Te,Be,j,I,Je,k,Ts,ye,bs="How to create a custom pipeline?",Ce,g,Is=`In this guide, we will see how to create a custom pipeline and share it on the <a href="hf.co/models">Hub</a> or add it to the
🤗 Transformers library.`,_e,v,Bs=`First and foremost, you need to decide the raw entries the pipeline will be able to take. It can be strings, raw bytes,
dictionaries or whatever seems to be the most likely desired input. Try to keep these inputs as pure Python as possible
as it makes compatibility easier (even through other languages via JSON). Those will be the <code>inputs</code> of the
pipeline (<code>preprocess</code>).`,ke,Z,Cs=`Then define the <code>outputs</code>. Same policy as the <code>inputs</code>. The simpler, the better. Those will be the outputs of
<code>postprocess</code> method.`,ge,A,_s=`Start by inheriting the base class <code>Pipeline</code> with the 4 methods needed to implement <code>preprocess</code>,
<code>_forward</code>, <code>postprocess</code>, and <code>_sanitize_parameters</code>.`,ve,G,Ze,H,ks=`The structure of this breakdown is to support relatively seamless support for CPU/GPU, while supporting doing
pre/postprocessing on the CPU on different threads`,Ae,N,gs=`<code>preprocess</code> will take the originally defined inputs, and turn them into something feedable to the model. It might
contain more information and is usually a <code>Dict</code>.`,Ge,V,vs=`<code>_forward</code> is the implementation detail and is not meant to be called directly. <code>forward</code> is the preferred
called method as it contains safeguards to make sure everything is working on the expected device. If anything is
linked to a real model it belongs in the <code>_forward</code> method, anything else is in the preprocess/postprocess.`,He,X,Zs=`<code>postprocess</code> methods will take the output of <code>_forward</code> and turn it into the final output that was decided
earlier.`,Ne,W,As=`<code>_sanitize_parameters</code> exists to allow users to pass any parameters whenever they wish, be it at initialization
time <code>pipeline(...., maybe_arg=4)</code> or at call time <code>pipe = pipeline(...); output = pipe(...., maybe_arg=4)</code>.`,Ve,R,Gs=`The returns of <code>_sanitize_parameters</code> are the 3 dicts of kwargs that will be passed directly to <code>preprocess</code>,
<code>_forward</code>, and <code>postprocess</code>. Don’t fill anything if the caller didn’t call with any extra parameter. That
allows to keep the default arguments in the function definition which is always more “natural”.`,Xe,E,Hs="A classic example would be a <code>top_k</code> argument in the post processing in classification tasks.",We,q,Re,x,Ns=`In order to achieve that, we’ll update our <code>postprocess</code> method with a default parameter to <code>5</code>. and edit
<code>_sanitize_parameters</code> to allow this new parameter.`,Ee,z,qe,$,Vs=`Try to keep the inputs/outputs very simple and ideally JSON-serializable as it makes the pipeline usage very easy
without requiring users to understand new kind of objects. It’s also relatively common to support many different types
of arguments for ease of use (audio files, can be filenames, URLs or pure bytes)`,xe,f,B,je,Y,Js,ue,Xs="Adding it to the list of supported tasks",ze,S,Ws="To register your <code>new-task</code> to the list of supported tasks, you have to add it to the <code>PIPELINE_REGISTRY</code>:",$e,F,Ye,Q,Rs="You can specify a default model if you want, in which case it should come with a specific revision (which can be the name of a branch or a commit hash, here we took <code>&quot;abcdef&quot;</code>) as well as the type:",Se,P,Fe,U,C,fe,L,js,me,Es="Share your pipeline on the Hub",Qe,K,qs=`To share your custom pipeline on the Hub, you just have to save the custom code of your <code>Pipeline</code> subclass in a
python file. For instance, let’s say we want to use a custom pipeline for sentence pair classification like this:`,Pe,D,Le,O,xs=`The implementation is framework agnostic, and will work for PyTorch and TensorFlow models. If we have saved this in
a file named <code>pair_classification.py</code>, we can then import it and register it like this:`,Ke,ee,De,se,zs=`Once this is done, we can use it with a pretrained model. For instance <code>sgugger/finetuned-bert-mrpc</code> has been
fine-tuned on the MRPC dataset, which classifies pairs of sentences as paraphrases or not.`,Oe,te,es,le,$s="Then we can share it on the Hub by using the <code>save_pretrained</code> method in a <code>Repository</code>:",ss,ae,ts,ne,Ys=`This will copy the file where you defined <code>PairClassificationPipeline</code> inside the folder <code>&quot;test-dynamic-pipeline&quot;</code>,
along with saving the model and tokenizer of the pipeline, before pushing everything in the repository
<code>{your_username}/test-dynamic-pipeline</code>. After that anyone can use it as long as they provide the option
<code>trust_remote_code=True</code>:`,ls,pe,as,b,_,Ue,ie,fs,we,Ss="Add the pipeline to 🤗 Transformers",ns,oe,Fs=`If you want to contribute your pipeline to 🤗 Transformers, you will need to add a new module in the <code>pipelines</code> submodule
with the code of your pipeline, then add it in the list of tasks defined in <code>pipelines/__init__.py</code>.`,ps,re,Qs="Then you will need to add tests. Create a new file <code>tests/test_pipelines_MY_PIPELINE.py</code> with example with the other tests.",is,ce,Ps=`The <code>run_pipeline_test</code> function will be very generic and run on small random models on every possible
architecture as defined by <code>model_mapping</code> and <code>tf_model_mapping</code>.`,os,de,Ls=`This is very important to test future compatibility, meaning if someone adds a new model for
<code>XXXForQuestionAnswering</code> then the pipeline test will attempt to run on it. Because the models are random it’s
impossible to check for actual values, that’s why there is a helper <code>ANY</code> that will simply attempt to match the
output of the pipeline TYPE.`,rs,Me,Ks="You also <em>need</em> to implement 2 (ideally 4) tests.",cs,he,Ds=`<li><code>test_small_model_pt</code> : Define 1 small model for this pipeline (doesn’t matter if the results don’t make sense)
and test the pipeline outputs. The results should be the same as <code>test_small_model_tf</code>.</li> <li><code>test_small_model_tf</code> : Define 1 small model for this pipeline (doesn’t matter if the results don’t make sense)
and test the pipeline outputs. The results should be the same as <code>test_small_model_pt</code>.</li> <li><code>test_large_model_pt</code> (<code>optional</code>): Tests the pipeline on a real pipeline where the results are supposed to
make sense. These tests are slow and should be marked as such. Here the goal is to showcase the pipeline and to make
sure there is no drift in future releases.</li> <li><code>test_large_model_tf</code> (<code>optional</code>): Tests the pipeline on a real pipeline where the results are supposed to
make sense. These tests are slow and should be marked as such. Here the goal is to showcase the pipeline and to make
sure there is no drift in future releases.</li>`,ds,be,Ms;return k=new ws({}),G=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBpcGVsaW5lJTBBJTBBJTBBY2xhc3MlMjBNeVBpcGVsaW5lKFBpcGVsaW5lKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9zYW5pdGl6ZV9wYXJhbWV0ZXJzKHNlbGYlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVwcm9jZXNzX2t3YXJncyUyMCUzRCUyMCU3QiU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwJTIybWF5YmVfYXJnJTIyJTIwaW4lMjBrd2FyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVwcm9jZXNzX2t3YXJncyU1QiUyMm1heWJlX2FyZyUyMiU1RCUyMCUzRCUyMGt3YXJncyU1QiUyMm1heWJlX2FyZyUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHByZXByb2Nlc3Nfa3dhcmdzJTJDJTIwJTdCJTdEJTJDJTIwJTdCJTdEJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcHJlcHJvY2VzcyhzZWxmJTJDJTIwaW5wdXRzJTJDJTIwbWF5YmVfYXJnJTNEMiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9pbnB1dCUyMCUzRCUyMFRlbnNvcihpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybW9kZWxfaW5wdXQlMjIlM0ElMjBtb2RlbF9pbnB1dCU3RCUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9mb3J3YXJkKHNlbGYlMkMlMjBtb2RlbF9pbnB1dHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbW9kZWxfaW5wdXRzJTIwJTNEJTNEJTIwJTdCJTIybW9kZWxfaW5wdXQlMjIlM0ElMjBtb2RlbF9pbnB1dCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBzZWxmLm1vZGVsKCoqbW9kZWxfaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyME1heWJlJTIwJTdCJTIybG9naXRzJTIyJTNBJTIwVGVuc29yKC4uLiklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBvdXRwdXRzJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcG9zdHByb2Nlc3Moc2VsZiUyQyUyMG1vZGVsX291dHB1dHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmVzdF9jbGFzcyUyMCUzRCUyMG1vZGVsX291dHB1dHMlNUIlMjJsb2dpdHMlMjIlNUQuc29mdG1heCgtMSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBiZXN0X2NsYXNz",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyPipeline</span>(<span class="hljs-title class_ inherited__">Pipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
        preprocess_kwargs = {}
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;maybe_arg&quot;</span> <span class="hljs-keyword">in</span> kwargs:
            preprocess_kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>] = kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>]
        <span class="hljs-keyword">return</span> preprocess_kwargs, {}, {}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess</span>(<span class="hljs-params">self, inputs, maybe_arg=<span class="hljs-number">2</span></span>):
        model_input = Tensor(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;model_input&quot;</span>: model_input}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, model_inputs</span>):
        <span class="hljs-comment"># model_inputs == {&quot;model_input&quot;: model_input}</span>
        outputs = self.model(**model_inputs)
        <span class="hljs-comment"># Maybe {&quot;logits&quot;: Tensor(...)}</span>
        <span class="hljs-keyword">return</span> outputs

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs</span>):
        best_class = model_outputs[<span class="hljs-string">&quot;logits&quot;</span>].softmax(-<span class="hljs-number">1</span>)
        <span class="hljs-keyword">return</span> best_class`}}),q=new T({props:{code:"cGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMm15LW5ldy10YXNrJTIyKSUwQXBpcGUoJTIyVGhpcyUyMGlzJTIwYSUyMHRlc3QlMjIpJTBBJTBBcGlwZSglMjJUaGlzJTIwaXMlMjBhJTIwdGVzdCUyMiUyQyUyMHRvcF9rJTNEMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;my-new-task&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(<span class="hljs-string">&quot;This is a test&quot;</span>)
[{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;1-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.8</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;2-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.1</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;3-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.05</span>}
{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;4-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.025</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;5-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.025</span>}]

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(<span class="hljs-string">&quot;This is a test&quot;</span>, top_k=<span class="hljs-number">2</span>)
[{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;1-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.8</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;2-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.1</span>}]`}}),z=new T({props:{code:"ZGVmJTIwcG9zdHByb2Nlc3Moc2VsZiUyQyUyMG1vZGVsX291dHB1dHMlMkMlMjB0b3BfayUzRDUpJTNBJTBBJTIwJTIwJTIwJTIwYmVzdF9jbGFzcyUyMCUzRCUyMG1vZGVsX291dHB1dHMlNUIlMjJsb2dpdHMlMjIlNUQuc29mdG1heCgtMSklMEElMjAlMjAlMjAlMjAlMjMlMjBBZGQlMjBsb2dpYyUyMHRvJTIwaGFuZGxlJTIwdG9wX2slMEElMjAlMjAlMjAlMjByZXR1cm4lMjBiZXN0X2NsYXNzJTBBJTBBJTBBZGVmJTIwX3Nhbml0aXplX3BhcmFtZXRlcnMoc2VsZiUyQyUyMCoqa3dhcmdzKSUzQSUwQSUyMCUyMCUyMCUyMHByZXByb2Nlc3Nfa3dhcmdzJTIwJTNEJTIwJTdCJTdEJTBBJTIwJTIwJTIwJTIwaWYlMjAlMjJtYXliZV9hcmclMjIlMjBpbiUyMGt3YXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByZXByb2Nlc3Nfa3dhcmdzJTVCJTIybWF5YmVfYXJnJTIyJTVEJTIwJTNEJTIwa3dhcmdzJTVCJTIybWF5YmVfYXJnJTIyJTVEJTBBJTBBJTIwJTIwJTIwJTIwcG9zdHByb2Nlc3Nfa3dhcmdzJTIwJTNEJTIwJTdCJTdEJTBBJTIwJTIwJTIwJTIwaWYlMjAlMjJ0b3BfayUyMiUyMGluJTIwa3dhcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcG9zdHByb2Nlc3Nfa3dhcmdzJTVCJTIydG9wX2slMjIlNUQlMjAlM0QlMjBrd2FyZ3MlNUIlMjJ0b3BfayUyMiU1RCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHByZXByb2Nlc3Nfa3dhcmdzJTJDJTIwJTdCJTdEJTJDJTIwcG9zdHByb2Nlc3Nfa3dhcmdz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs, top_k=<span class="hljs-number">5</span></span>):
    best_class = model_outputs[<span class="hljs-string">&quot;logits&quot;</span>].softmax(-<span class="hljs-number">1</span>)
    <span class="hljs-comment"># Add logic to handle top_k</span>
    <span class="hljs-keyword">return</span> best_class


<span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
    preprocess_kwargs = {}
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;maybe_arg&quot;</span> <span class="hljs-keyword">in</span> kwargs:
        preprocess_kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>] = kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>]

    postprocess_kwargs = {}
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;top_k&quot;</span> <span class="hljs-keyword">in</span> kwargs:
        postprocess_kwargs[<span class="hljs-string">&quot;top_k&quot;</span>] = kwargs[<span class="hljs-string">&quot;top_k&quot;</span>]
    <span class="hljs-keyword">return</span> preprocess_kwargs, {}, postprocess_kwargs`}}),Y=new ws({}),F=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5waXBlbGluZXMlMjBpbXBvcnQlMjBQSVBFTElORV9SRUdJU1RSWSUwQSUwQVBJUEVMSU5FX1JFR0lTVFJZLnJlZ2lzdGVyX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMm5ldy10YXNrJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGlwZWxpbmVfY2xhc3MlM0RNeVBpcGVsaW5lJTJDJTBBJTIwJTIwJTIwJTIwcHRfbW9kZWwlM0RBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers.pipelines <span class="hljs-keyword">import</span> PIPELINE_REGISTRY

PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;new-task&quot;</span>,
    pipeline_class=MyPipeline,
    pt_model=AutoModelForSequenceClassification,
)`}}),P=new T({props:{code:"UElQRUxJTkVfUkVHSVNUUlkucmVnaXN0ZXJfcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIybmV3LXRhc2slMjIlMkMlMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUzRE15UGlwZWxpbmUlMkMlMEElMjAlMjAlMjAlMjBwdF9tb2RlbCUzREF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMEElMjAlMjAlMjAlMjBkZWZhdWx0JTNEJTdCJTIycHQlMjIlM0ElMjAoJTIydXNlciUyRmF3ZXNvbWVfbW9kZWwlMjIlMkMlMjAlMjJhYmNkZWYlMjIpJTdEJTJDJTBBJTIwJTIwJTIwJTIwdHlwZSUzRCUyMnRleHQlMjIlMkMlMjAlMjAlMjMlMjBjdXJyZW50JTIwc3VwcG9ydCUyMHR5cGUlM0ElMjB0ZXh0JTJDJTIwYXVkaW8lMkMlMjBpbWFnZSUyQyUyMG11bHRpbW9kYWwlMEEp",highlighted:`PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;new-task&quot;</span>,
    pipeline_class=MyPipeline,
    pt_model=AutoModelForSequenceClassification,
    default={<span class="hljs-string">&quot;pt&quot;</span>: (<span class="hljs-string">&quot;user/awesome_model&quot;</span>, <span class="hljs-string">&quot;abcdef&quot;</span>)},
    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;text&quot;</span>,  <span class="hljs-comment"># current support type: text, audio, image, multimodal</span>
)`}}),L=new ws({}),D=new T({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBpcGVsaW5lJTBBJTBBJTBBZGVmJTIwc29mdG1heChvdXRwdXRzKSUzQSUwQSUyMCUyMCUyMCUyMG1heGVzJTIwJTNEJTIwbnAubWF4KG91dHB1dHMlMkMlMjBheGlzJTNELTElMkMlMjBrZWVwZGltcyUzRFRydWUpJTBBJTIwJTIwJTIwJTIwc2hpZnRlZF9leHAlMjAlM0QlMjBucC5leHAob3V0cHV0cyUyMC0lMjBtYXhlcyklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzaGlmdGVkX2V4cCUyMCUyRiUyMHNoaWZ0ZWRfZXhwLnN1bShheGlzJTNELTElMkMlMjBrZWVwZGltcyUzRFRydWUpJTBBJTBBJTBBY2xhc3MlMjBQYWlyQ2xhc3NpZmljYXRpb25QaXBlbGluZShQaXBlbGluZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfc2FuaXRpemVfcGFyYW1ldGVycyhzZWxmJTJDJTIwKiprd2FyZ3MpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJlcHJvY2Vzc19rd2FyZ3MlMjAlM0QlMjAlN0IlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMCUyMnNlY29uZF90ZXh0JTIyJTIwaW4lMjBrd2FyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVwcm9jZXNzX2t3YXJncyU1QiUyMnNlY29uZF90ZXh0JTIyJTVEJTIwJTNEJTIwa3dhcmdzJTVCJTIyc2Vjb25kX3RleHQlMjIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBwcmVwcm9jZXNzX2t3YXJncyUyQyUyMCU3QiU3RCUyQyUyMCU3QiU3RCUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMHByZXByb2Nlc3Moc2VsZiUyQyUyMHRleHQlMkMlMjBzZWNvbmRfdGV4dCUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2VsZi50b2tlbml6ZXIodGV4dCUyQyUyMHRleHRfcGFpciUzRHNlY29uZF90ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0RzZWxmLmZyYW1ld29yayklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfZm9yd2FyZChzZWxmJTJDJTIwbW9kZWxfaW5wdXRzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYubW9kZWwoKiptb2RlbF9pbnB1dHMpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcG9zdHByb2Nlc3Moc2VsZiUyQyUyMG1vZGVsX291dHB1dHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWxfb3V0cHV0cy5sb2dpdHMlNUIwJTVELm51bXB5KCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9iYWJpbGl0aWVzJTIwJTNEJTIwc29mdG1heChsb2dpdHMpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmVzdF9jbGFzcyUyMCUzRCUyMG5wLmFyZ21heChwcm9iYWJpbGl0aWVzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxhYmVsJTIwJTNEJTIwc2VsZi5tb2RlbC5jb25maWcuaWQybGFiZWwlNUJiZXN0X2NsYXNzJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2NvcmUlMjAlM0QlMjBwcm9iYWJpbGl0aWVzJTVCYmVzdF9jbGFzcyU1RC5pdGVtKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBsb2dpdHMudG9saXN0KCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJsYWJlbCUyMiUzQSUyMGxhYmVsJTJDJTIwJTIyc2NvcmUlMjIlM0ElMjBzY29yZSUyQyUyMCUyMmxvZ2l0cyUyMiUzQSUyMGxvZ2l0cyU3RA==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline


<span class="hljs-keyword">def</span> <span class="hljs-title function_">softmax</span>(<span class="hljs-params">outputs</span>):
    maxes = np.<span class="hljs-built_in">max</span>(outputs, axis=-<span class="hljs-number">1</span>, keepdims=<span class="hljs-literal">True</span>)
    shifted_exp = np.exp(outputs - maxes)
    <span class="hljs-keyword">return</span> shifted_exp / shifted_exp.<span class="hljs-built_in">sum</span>(axis=-<span class="hljs-number">1</span>, keepdims=<span class="hljs-literal">True</span>)


<span class="hljs-keyword">class</span> <span class="hljs-title class_">PairClassificationPipeline</span>(<span class="hljs-title class_ inherited__">Pipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
        preprocess_kwargs = {}
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;second_text&quot;</span> <span class="hljs-keyword">in</span> kwargs:
            preprocess_kwargs[<span class="hljs-string">&quot;second_text&quot;</span>] = kwargs[<span class="hljs-string">&quot;second_text&quot;</span>]
        <span class="hljs-keyword">return</span> preprocess_kwargs, {}, {}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess</span>(<span class="hljs-params">self, text, second_text=<span class="hljs-literal">None</span></span>):
        <span class="hljs-keyword">return</span> self.tokenizer(text, text_pair=second_text, return_tensors=self.framework)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, model_inputs</span>):
        <span class="hljs-keyword">return</span> self.model(**model_inputs)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs</span>):
        logits = model_outputs.logits[<span class="hljs-number">0</span>].numpy()
        probabilities = softmax(logits)

        best_class = np.argmax(probabilities)
        label = self.model.config.id2label[best_class]
        score = probabilities[best_class].item()
        logits = logits.tolist()
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;label&quot;</span>: label, <span class="hljs-string">&quot;score&quot;</span>: score, <span class="hljs-string">&quot;logits&quot;</span>: logits}`}}),ee=new T({props:{code:"ZnJvbSUyMHBhaXJfY2xhc3NpZmljYXRpb24lMjBpbXBvcnQlMjBQYWlyQ2xhc3NpZmljYXRpb25QaXBlbGluZSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMucGlwZWxpbmVzJTIwaW1wb3J0JTIwUElQRUxJTkVfUkVHSVNUUlklMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyQyUyMFRGQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQVBJUEVMSU5FX1JFR0lTVFJZLnJlZ2lzdGVyX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMnBhaXItY2xhc3NpZmljYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUzRFBhaXJDbGFzc2lmaWNhdGlvblBpcGVsaW5lJTJDJTBBJTIwJTIwJTIwJTIwcHRfbW9kZWwlM0RBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTBBJTIwJTIwJTIwJTIwdGZfbW9kZWwlM0RURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> pair_classification <span class="hljs-keyword">import</span> PairClassificationPipeline
<span class="hljs-keyword">from</span> transformers.pipelines <span class="hljs-keyword">import</span> PIPELINE_REGISTRY
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, TFAutoModelForSequenceClassification

PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;pair-classification&quot;</span>,
    pipeline_class=PairClassificationPipeline,
    pt_model=AutoModelForSequenceClassification,
    tf_model=TFAutoModelForSequenceClassification,
)`}}),te=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUyMnBhaXItY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMnNndWdnZXIlMkZmaW5ldHVuZWQtYmVydC1tcnBjJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(<span class="hljs-string">&quot;pair-classification&quot;</span>, model=<span class="hljs-string">&quot;sgugger/finetuned-bert-mrpc&quot;</span>)`}}),ae=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEElMEFyZXBvJTIwJTNEJTIwUmVwb3NpdG9yeSglMjJ0ZXN0LWR5bmFtaWMtcGlwZWxpbmUlMjIlMkMlMjBjbG9uZV9mcm9tJTNEJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRnRlc3QtZHluYW1pYy1waXBlbGluZSUyMiklMEFjbGFzc2lmaWVyLnNhdmVfcHJldHJhaW5lZCglMjJ0ZXN0LWR5bmFtaWMtcGlwZWxpbmUlMjIpJTBBcmVwby5wdXNoX3RvX2h1Yigp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository

repo = Repository(<span class="hljs-string">&quot;test-dynamic-pipeline&quot;</span>, clone_from=<span class="hljs-string">&quot;{your_username}/test-dynamic-pipeline&quot;</span>)
classifier.save_pretrained(<span class="hljs-string">&quot;test-dynamic-pipeline&quot;</span>)
repo.push_to_hub()`}}),pe=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRnRlc3QtZHluYW1pYy1waXBlbGluZSUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(model=<span class="hljs-string">&quot;{your_username}/test-dynamic-pipeline&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`}}),ie=new ws({}),{c(){J=p("meta"),Ie=a(),Te=p("p"),Be=a(),j=p("h1"),I=p("a"),Je=p("span"),d(k.$$.fragment),Ts=a(),ye=p("span"),ye.textContent=bs,Ce=a(),g=p("p"),g.innerHTML=Is,_e=a(),v=p("p"),v.innerHTML=Bs,ke=a(),Z=p("p"),Z.innerHTML=Cs,ge=a(),A=p("p"),A.innerHTML=_s,ve=a(),d(G.$$.fragment),Ze=a(),H=p("p"),H.textContent=ks,Ae=a(),N=p("p"),N.innerHTML=gs,Ge=a(),V=p("p"),V.innerHTML=vs,He=a(),X=p("p"),X.innerHTML=Zs,Ne=a(),W=p("p"),W.innerHTML=As,Ve=a(),R=p("p"),R.innerHTML=Gs,Xe=a(),E=p("p"),E.innerHTML=Hs,We=a(),d(q.$$.fragment),Re=a(),x=p("p"),x.innerHTML=Ns,Ee=a(),d(z.$$.fragment),qe=a(),$=p("p"),$.textContent=Vs,xe=a(),f=p("h2"),B=p("a"),je=p("span"),d(Y.$$.fragment),Js=a(),ue=p("span"),ue.textContent=Xs,ze=a(),S=p("p"),S.innerHTML=Ws,$e=a(),d(F.$$.fragment),Ye=a(),Q=p("p"),Q.innerHTML=Rs,Se=a(),d(P.$$.fragment),Fe=a(),U=p("h2"),C=p("a"),fe=p("span"),d(L.$$.fragment),js=a(),me=p("span"),me.textContent=Es,Qe=a(),K=p("p"),K.innerHTML=qs,Pe=a(),d(D.$$.fragment),Le=a(),O=p("p"),O.innerHTML=xs,Ke=a(),d(ee.$$.fragment),De=a(),se=p("p"),se.innerHTML=zs,Oe=a(),d(te.$$.fragment),es=a(),le=p("p"),le.innerHTML=$s,ss=a(),d(ae.$$.fragment),ts=a(),ne=p("p"),ne.innerHTML=Ys,ls=a(),d(pe.$$.fragment),as=a(),b=p("h2"),_=p("a"),Ue=p("span"),d(ie.$$.fragment),fs=a(),we=p("span"),we.textContent=Ss,ns=a(),oe=p("p"),oe.innerHTML=Fs,ps=a(),re=p("p"),re.innerHTML=Qs,is=a(),ce=p("p"),ce.innerHTML=Ps,os=a(),de=p("p"),de.innerHTML=Ls,rs=a(),Me=p("p"),Me.innerHTML=Ks,cs=a(),he=p("ul"),he.innerHTML=Ds,ds=a(),be=p("p"),this.h()},l(e){const t=Mt("svelte-1phssyn",document.head);J=i(t,"META",{name:!0,content:!0}),t.forEach(s),Ie=n(e),Te=i(e,"P",{}),M(Te).forEach(s),Be=n(e),j=i(e,"H1",{class:!0});var hs=M(j);I=i(hs,"A",{id:!0,class:!0,href:!0});var Os=M(I);Je=i(Os,"SPAN",{});var et=M(Je);h(k.$$.fragment,et),et.forEach(s),Os.forEach(s),Ts=n(hs),ye=i(hs,"SPAN",{"data-svelte-h":!0}),o(ye)!=="svelte-2386fj"&&(ye.textContent=bs),hs.forEach(s),Ce=n(e),g=i(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-b9qm9y"&&(g.innerHTML=Is),_e=n(e),v=i(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-oxa02l"&&(v.innerHTML=Bs),ke=n(e),Z=i(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-6dmyza"&&(Z.innerHTML=Cs),ge=n(e),A=i(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-yoim0k"&&(A.innerHTML=_s),ve=n(e),h(G.$$.fragment,e),Ze=n(e),H=i(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-byrozk"&&(H.textContent=ks),Ae=n(e),N=i(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1f1lssz"&&(N.innerHTML=gs),Ge=n(e),V=i(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-12jiwrp"&&(V.innerHTML=vs),He=n(e),X=i(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1ev1pra"&&(X.innerHTML=Zs),Ne=n(e),W=i(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-wbhsl3"&&(W.innerHTML=As),Ve=n(e),R=i(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1rxvpik"&&(R.innerHTML=Gs),Xe=n(e),E=i(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1jbvi33"&&(E.innerHTML=Hs),We=n(e),h(q.$$.fragment,e),Re=n(e),x=i(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-nsc0of"&&(x.innerHTML=Ns),Ee=n(e),h(z.$$.fragment,e),qe=n(e),$=i(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1tofwxd"&&($.textContent=Vs),xe=n(e),f=i(e,"H2",{class:!0});var ys=M(f);B=i(ys,"A",{id:!0,class:!0,href:!0});var st=M(B);je=i(st,"SPAN",{});var tt=M(je);h(Y.$$.fragment,tt),tt.forEach(s),st.forEach(s),Js=n(ys),ue=i(ys,"SPAN",{"data-svelte-h":!0}),o(ue)!=="svelte-1wulgoa"&&(ue.textContent=Xs),ys.forEach(s),ze=n(e),S=i(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-3jotdg"&&(S.innerHTML=Ws),$e=n(e),h(F.$$.fragment,e),Ye=n(e),Q=i(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-491gz1"&&(Q.innerHTML=Rs),Se=n(e),h(P.$$.fragment,e),Fe=n(e),U=i(e,"H2",{class:!0});var us=M(U);C=i(us,"A",{id:!0,class:!0,href:!0});var lt=M(C);fe=i(lt,"SPAN",{});var at=M(fe);h(L.$$.fragment,at),at.forEach(s),lt.forEach(s),js=n(us),me=i(us,"SPAN",{"data-svelte-h":!0}),o(me)!=="svelte-1tfzh8a"&&(me.textContent=Es),us.forEach(s),Qe=n(e),K=i(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-12i9yqr"&&(K.innerHTML=qs),Pe=n(e),h(D.$$.fragment,e),Le=n(e),O=i(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-fgifeg"&&(O.innerHTML=xs),Ke=n(e),h(ee.$$.fragment,e),De=n(e),se=i(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1o1fy6m"&&(se.innerHTML=zs),Oe=n(e),h(te.$$.fragment,e),es=n(e),le=i(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-1769ktt"&&(le.innerHTML=$s),ss=n(e),h(ae.$$.fragment,e),ts=n(e),ne=i(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-10hpecu"&&(ne.innerHTML=Ys),ls=n(e),h(pe.$$.fragment,e),as=n(e),b=i(e,"H2",{class:!0});var ms=M(b);_=i(ms,"A",{id:!0,class:!0,href:!0});var nt=M(_);Ue=i(nt,"SPAN",{});var pt=M(Ue);h(ie.$$.fragment,pt),pt.forEach(s),nt.forEach(s),fs=n(ms),we=i(ms,"SPAN",{"data-svelte-h":!0}),o(we)!=="svelte-10rq17x"&&(we.textContent=Ss),ms.forEach(s),ns=n(e),oe=i(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-1v6jncf"&&(oe.innerHTML=Fs),ps=n(e),re=i(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-163bboa"&&(re.innerHTML=Qs),is=n(e),ce=i(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-1by38ya"&&(ce.innerHTML=Ps),os=n(e),de=i(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-1cftve5"&&(de.innerHTML=Ls),rs=n(e),Me=i(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-17fu767"&&(Me.innerHTML=Ks),cs=n(e),he=i(e,"UL",{"data-svelte-h":!0}),o(he)!=="svelte-9p61si"&&(he.innerHTML=Ds),ds=n(e),be=i(e,"P",{}),M(be).forEach(s),this.h()},h(){r(J,"name","hf:doc:metadata"),r(J,"content",JSON.stringify(yt)),r(I,"id","how-to-create-a-custom-pipeline"),r(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(I,"href","#how-to-create-a-custom-pipeline"),r(j,"class","relative group"),r(B,"id","adding-it-to-the-list-of-supported-tasks"),r(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(B,"href","#adding-it-to-the-list-of-supported-tasks"),r(f,"class","relative group"),r(C,"id","share-your-pipeline-on-the-hub"),r(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(C,"href","#share-your-pipeline-on-the-hub"),r(U,"class","relative group"),r(_,"id","add-the-pipeline-to-transformers"),r(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(_,"href","#add-the-pipeline-to-transformers"),r(b,"class","relative group")},m(e,t){c(document.head,J),l(e,Ie,t),l(e,Te,t),l(e,Be,t),l(e,j,t),c(j,I),c(I,Je),y(k,Je,null),c(j,Ts),c(j,ye),l(e,Ce,t),l(e,g,t),l(e,_e,t),l(e,v,t),l(e,ke,t),l(e,Z,t),l(e,ge,t),l(e,A,t),l(e,ve,t),y(G,e,t),l(e,Ze,t),l(e,H,t),l(e,Ae,t),l(e,N,t),l(e,Ge,t),l(e,V,t),l(e,He,t),l(e,X,t),l(e,Ne,t),l(e,W,t),l(e,Ve,t),l(e,R,t),l(e,Xe,t),l(e,E,t),l(e,We,t),y(q,e,t),l(e,Re,t),l(e,x,t),l(e,Ee,t),y(z,e,t),l(e,qe,t),l(e,$,t),l(e,xe,t),l(e,f,t),c(f,B),c(B,je),y(Y,je,null),c(f,Js),c(f,ue),l(e,ze,t),l(e,S,t),l(e,$e,t),y(F,e,t),l(e,Ye,t),l(e,Q,t),l(e,Se,t),y(P,e,t),l(e,Fe,t),l(e,U,t),c(U,C),c(C,fe),y(L,fe,null),c(U,js),c(U,me),l(e,Qe,t),l(e,K,t),l(e,Pe,t),y(D,e,t),l(e,Le,t),l(e,O,t),l(e,Ke,t),y(ee,e,t),l(e,De,t),l(e,se,t),l(e,Oe,t),y(te,e,t),l(e,es,t),l(e,le,t),l(e,ss,t),y(ae,e,t),l(e,ts,t),l(e,ne,t),l(e,ls,t),y(pe,e,t),l(e,as,t),l(e,b,t),c(b,_),c(_,Ue),y(ie,Ue,null),c(b,fs),c(b,we),l(e,ns,t),l(e,oe,t),l(e,ps,t),l(e,re,t),l(e,is,t),l(e,ce,t),l(e,os,t),l(e,de,t),l(e,rs,t),l(e,Me,t),l(e,cs,t),l(e,he,t),l(e,ds,t),l(e,be,t),Ms=!0},p:ot,i(e){Ms||(u(k.$$.fragment,e),u(G.$$.fragment,e),u(q.$$.fragment,e),u(z.$$.fragment,e),u(Y.$$.fragment,e),u(F.$$.fragment,e),u(P.$$.fragment,e),u(L.$$.fragment,e),u(D.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(pe.$$.fragment,e),u(ie.$$.fragment,e),Ms=!0)},o(e){m(k.$$.fragment,e),m(G.$$.fragment,e),m(q.$$.fragment,e),m(z.$$.fragment,e),m(Y.$$.fragment,e),m(F.$$.fragment,e),m(P.$$.fragment,e),m(L.$$.fragment,e),m(D.$$.fragment,e),m(ee.$$.fragment,e),m(te.$$.fragment,e),m(ae.$$.fragment,e),m(pe.$$.fragment,e),m(ie.$$.fragment,e),Ms=!1},d(e){e&&(s(Ie),s(Te),s(Be),s(j),s(Ce),s(g),s(_e),s(v),s(ke),s(Z),s(ge),s(A),s(ve),s(Ze),s(H),s(Ae),s(N),s(Ge),s(V),s(He),s(X),s(Ne),s(W),s(Ve),s(R),s(Xe),s(E),s(We),s(Re),s(x),s(Ee),s(qe),s($),s(xe),s(f),s(ze),s(S),s($e),s(Ye),s(Q),s(Se),s(Fe),s(U),s(Qe),s(K),s(Pe),s(Le),s(O),s(Ke),s(De),s(se),s(Oe),s(es),s(le),s(ss),s(ts),s(ne),s(ls),s(as),s(b),s(ns),s(oe),s(ps),s(re),s(is),s(ce),s(os),s(de),s(rs),s(Me),s(cs),s(he),s(ds),s(be)),s(J),w(k),w(G,e),w(q,e),w(z,e),w(Y),w(F,e),w(P,e),w(L),w(D,e),w(ee,e),w(te,e),w(ae,e),w(pe,e),w(ie)}}}const yt={local:"how-to-create-a-custom-pipeline",sections:[{local:"adding-it-to-the-list-of-supported-tasks",title:"Adding it to the list of supported tasks"},{local:"share-your-pipeline-on-the-hub",title:"Share your pipeline on the Hub"},{local:"add-the-pipeline-to-transformers",title:"Add the pipeline to 🤗 Transformers"}],title:"How to create a custom pipeline?"};function ut(Us){return rt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jt extends ct{constructor(J){super(),dt(this,J,ut,ht,it,{})}}export{jt as component};
