import{s as Xl,n as Rl,o as xl}from"../chunks/scheduler.c57aa7ef.js";import{S as El,i as Il,g as o,s as a,r as p,A as Gl,h as s,f as l,c as i,j as Ul,u as m,x as r,k as Fl,y as Al,a as n,v as f,d as u,t as d,w as h}from"../chunks/index.394f8801.js";import{C as c}from"../chunks/CodeBlock.b5488637.js";import{H as M,E as Hl}from"../chunks/index.e8dc6d69.js";function Nl(Oe){let b,Bt,kt,Ut,y,Ft,g,tl="Quantization represents data with fewer bits, making it a useful technique for reducing memory-usage and accelerating inference especially when it comes to large language models (LLMs). There are several ways to quantize a model including:",Xt,w,el='<li>optimizing which model weights are quantized with the <a href="https://hf.co/papers/2306.00978" rel="nofollow">AWQ</a> algorithm</li> <li>independently quantizing each row of a weight matrix with the <a href="https://hf.co/papers/2210.17323" rel="nofollow">GPTQ</a> algorithm</li> <li>quantizing to 8-bit and 4-bit precision with the <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> library</li> <li>quantizing to as low as 2-bit precision with the <a href="https://arxiv.org/abs/2401.06118" rel="nofollow">AQLM</a> algorithm</li>',Rt,T,ll='However, after a model is quantized it isn’t typically further trained for downstream tasks because training can be unstable due to the lower precision of the weights and activations. But since PEFT methods only add <em>extra</em> trainable parameters, this allows you to train a quantized model with a PEFT adapter on top! Combining quantization with PEFT can be a good strategy for training even the largest models on a single GPU. For example, <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> is a method that quantizes a model to 4-bits and then trains it with LoRA. This method allows you to finetune a 65B parameter model on a single 48GB GPU!',xt,J,nl="In this guide, you’ll see how to quantize a model to 4-bits and train it with LoRA.",Et,$,It,_,al='<a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> is a quantization library with a Transformers integration. With this integration, you can quantize a model to 8 or 4-bits and enable many other options by configuring the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">BitsAndBytesConfig</a> class. For example, you can:',Gt,q,il="<li>set <code>load_in_4bit=True</code> to quantize the model to 4-bits when you load it</li> <li>set <code>bnb_4bit_quant_type=&quot;nf4&quot;</code> to use a special 4-bit data type for weights initialized from a normal distribution</li> <li>set <code>bnb_4bit_use_double_quant=True</code> to use a nested quantization scheme to quantize the already quantized weights</li> <li>set <code>bnb_4bit_compute_dtype=torch.bfloat16</code> to use bfloat16 for faster computation</li>",At,v,Ht,j,ol='Pass the <code>config</code> to the <a href="https://huggingface.co/docs/transformers/main/en/model_doc/auto#transformers.AutoModelForCausalLM.from_pretrained" rel="nofollow">from_pretrained</a> method.',Nt,Z,Vt,C,sl='Next, you should call the <a href="/docs/peft/main/en/package_reference/peft_model#peft.prepare_model_for_kbit_training">prepare_model_for_kbit_training()</a> function to preprocess the quantized model for training.',Pt,z,Yt,W,rl="Now that the quantized model is ready, let’s set up a configuration.",St,Q,Dt,k,pl='Create a <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> with the following parameters (or choose your own):',Kt,L,Ot,B,ml='Then use the <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> function to create a <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> from the quantized model and configuration.',te,U,ee,F,fl="You’re all set for training with whichever training method you prefer!",le,X,ne,R,ul='<a href="https://hf.co/papers/2310.08659" rel="nofollow">LoftQ</a> initializes LoRA weights such that the quantization error is minimized, and it can improve performance when training quantized models. To get started, follow <a href="https://github.com/huggingface/peft/tree/main/examples/loftq_finetuning" rel="nofollow">these instructions</a>.',ae,x,dl="In general, for LoftQ to work best, it is recommended to target as many layers with LoRA as possible, since those not targeted cannot have LoftQ applied. This means that passing <code>LoraConfig(..., target_modules=&quot;all-linear&quot;)</code> will most likely give the best results. Also, you should use <code>nf4</code> as quant type in your quantization config when using 4bit quantization, i.e. <code>BitsAndBytesConfig(load_in_4bit=True, bnb_4bit_quant_type=&quot;nf4&quot;)</code>.",ie,E,oe,I,hl="QLoRA adds trainable weights to all the linear layers in the transformer architecture. Since the attribute names for these linear layers can vary across architectures, set <code>target_modules</code> to <code>&quot;all-linear&quot;</code> to add LoRA to all the linear layers:",se,G,re,A,pe,H,cl='You can learn more about gptq based <code>[2, 3, 4, 8]</code> bits quantization at <a href="https://github.com/ModelCloud/GPTQModel" rel="nofollow">GPTQModel</a> and the Transformers <a href="https://huggingface.co/docs/transformers/quantization/gptq" rel="nofollow">GPTQ</a> doc. Post-quant training, PEFT can use both <a href="https://github.com/ModelCloud/GPTQModel" rel="nofollow">GPTQModel</a> or <a href="https://github.com/autogptq/autogptq" rel="nofollow">AutoGPTQ</a> libraries, but we recommend GPTQModel because AutoGPTQ will be deprecated in a future release.',me,N,fe,V,ue,P,Ml="Once quantized, you can post-train GPTQ models with PEFT APIs.",de,Y,he,S,bl='Additive Quantization of Language Models (<a href="https://arxiv.org/abs/2401.06118" rel="nofollow">AQLM</a>) is a Large Language Models compression method. It quantizes multiple weights together and takes advantage of interdependencies between them. AQLM represents groups of 8-16 weights as a sum of multiple vector codes. This allows it to compress models down to as low as 2-bit with considerably low accuracy losses.',ce,D,yl='Since the AQLM quantization process is computationally expensive, a use of prequantized models is recommended. A partial list of available models can be found in the official aqlm <a href="https://github.com/Vahe1994/AQLM" rel="nofollow">repository</a>.',Me,K,gl="The models support LoRA adapter tuning. To tune the quantized model you’ll need to install the <code>aqlm</code> inference library: <code>pip install aqlm&gt;=1.0.2</code>. Finetuned LoRA adapters shall be saved separately, as merging them with AQLM quantized weights is not possible.",be,O,ye,tt,wl='You can refer to the <a href="https://colab.research.google.com/drive/12GTp1FCj5_0SnnNQH18h_2XFh9vS_guX?usp=sharing" rel="nofollow">Google Colab</a> example for an overview of AQLM+LoRA finetuning.',ge,et,we,lt,Tl='You can also perform LoRA fine-tuning on EETQ quantized models. <a href="https://github.com/NetEase-FuXi/EETQ" rel="nofollow">EETQ</a> package offers simple and efficient way to perform 8-bit quantization, which is claimed to be faster than the <code>LLM.int8()</code> algorithm. First, make sure that you have a transformers version that is compatible with EETQ (e.g. by installing it from latest pypi or from source).',Te,nt,Je,at,Jl='Pass the <code>config</code> to the <a href="https://huggingface.co/docs/transformers/main/en/model_doc/auto#transformers.AutoModelForCausalLM.from_pretrained" rel="nofollow">from_pretrained</a> method.',$e,it,_e,ot,$l="and create a <code>LoraConfig</code> and pass it to <code>get_peft_model</code>:",qe,st,ve,rt,je,pt,_l='The models that are quantized using Half-Quadratic Quantization of Large Machine Learning Models (<a href="https://mobiusml.github.io/hqq_blog/" rel="nofollow">HQQ</a>) support LoRA adapter tuning. To tune the quantized model, you’ll need to install the <code>hqq</code> library with: <code>pip install hqq</code>.',Ze,mt,Ce,ft,ql="Or using transformers version that is compatible with HQQ (e.g. by installing it from latest pypi or from source).",ze,ut,We,dt,Qe,ht,vl='PEFT supports models quantized with <a href="https://github.com/pytorch/ao" rel="nofollow">torchao</a> (“ao”) for int8 quantization.',ke,ct,Le,Mt,Be,bt,jl="<li>Use the most recent versions of torchao (&gt;= v0.4.0) and transformers (&gt; 4.42).</li> <li>Only linear layers are currently supported.</li> <li><code>quant_type = &quot;int4_weight_only&quot;</code> is currently not supported.</li> <li><code>NF4</code> is not implemented in transformers as of yet and is thus also not supported.</li> <li>DoRA only works with <code>quant_type = &quot;int8_weight_only&quot;</code> at the moment.</li> <li>There is explicit support for torchao when used with LoRA. However, when torchao quantizes a layer, its class does not change, only the type of the underlying tensor. For this reason, PEFT methods other than LoRA will generally also work with torchao, even if not explicitly supported. Be aware, however, that <strong>merging only works correctly with LoRA and with <code>quant_type = &quot;int8_weight_only&quot;</code></strong>. If you use a different PEFT method or dtype, merging will likely result in an error, and even it doesn’t, the results will still be incorrect.</li>",Ue,yt,Fe,gt,Zl=`Intel Neural Compressor (<a href="https://github.com/intel/neural-compressor" rel="nofollow">INC</a>) enables model quantization for various devices,
including Intel Gaudi accelerators (also known as HPU devices). You can perform LoRA fine-tuning on models that have been
quantized using INC. To use INC with PyTorch models, install the library with: <code>pip install neural-compressor[pt]</code>.
Quantizing a model to FP8 precision for HPU devices can be done with the following single-step quantization workflow:`,Xe,wt,Re,Tt,Cl=`Pass the config to the <code>prepare</code> method, run inference to gather calibration stats, and call <code>finalize_calibration</code>
and <code>convert</code> methods to quantize model to FP8 precision:`,xe,Jt,Ee,$t,zl=`An example demonstrating how to load a PEFT LoRA adapter into an INC-quantized FLUX text-to-image model for HPU
devices is provided <a href="https://github.com/huggingface/peft/blob/main/examples/stable_diffusion/inc_flux_lora_hpu.py" rel="nofollow">here</a>.`,Ie,_t,Ge,qt,Wl="<li><code>merge()</code> and <code>unmerge()</code> methods are currently not supported for INC-quantized models.</li> <li>Currently, only <strong>Linear</strong> INC-quantized layers are supported when loading PEFT adapters.</li>",Ae,vt,He,jt,Ql="Besides LoRA, the following PEFT methods also support quantization:",Ne,Zt,kl="<li><strong>VeRA</strong> (supports bitsandbytes quantization)</li> <li><strong>AdaLoRA</strong> (supports both bitsandbytes and GPTQ quantization)</li> <li><strong>(IA)³</strong> (supports bitsandbytes quantization)</li>",Ve,Ct,Pe,zt,Ll="If you’re interested in learning more about quantization, the following may be helpful:",Ye,Wt,Bl='<li>Learn more details about QLoRA and check out some benchmarks on its impact in the <a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">Making LLMs even more accessible with bitsandbytes, 4-bit quantization and QLoRA</a> blog post.</li> <li>Read more about different quantization schemes in the Transformers <a href="https://hf.co/docs/transformers/main/quantization" rel="nofollow">Quantization</a> guide.</li>',Se,Qt,De,Lt,Ke;return y=new M({props:{title:"Quantization",local:"quantization",headingTag:"h1"}}),$=new M({props:{title:"Quantize a model",local:"quantize-a-model",headingTag:"h2"}}),v=new c({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9jb21wdXRlX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
)`,wrap:!1}}),Z=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, quantization_config=config)`,wrap:!1}}),z=new c({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nJTBBJTBBbW9kZWwlMjAlM0QlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nKG1vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> prepare_model_for_kbit_training

model = prepare_model_for_kbit_training(model)`,wrap:!1}}),Q=new M({props:{title:"LoraConfig",local:"loraconfig",headingTag:"h2"}}),L=new c({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIya19wcm9qJTIyJTJDJTIwJTIydl9wcm9qJTIyJTJDJTIwJTIyb19wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4wNSUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">8</span>,
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>],
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)`,wrap:!1}}),U=new c({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBjb25maWcp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model

model = get_peft_model(model, config)`,wrap:!1}}),X=new M({props:{title:"LoftQ initialization",local:"loftq-initialization",headingTag:"h3"}}),E=new M({props:{title:"QLoRA-style training",local:"qlora-style-training",headingTag:"h3"}}),G=new c({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMjAuLi4p",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>, ...)',wrap:!1}}),A=new M({props:{title:"GPTQ quantization",local:"gptq-quantization",headingTag:"h2"}}),N=new c({props:{code:"JTIzJTIwZ3B0cW1vZGVsJTIwaW5zdGFsbCUwQXBpcCUyMGluc3RhbGwlMjBncHRxbW9kZWwlMjAtLW5vLWJ1aWxkLWlzb2xhdGlvbg==",highlighted:`<span class="hljs-comment"># gptqmodel install</span>
pip install gptqmodel --no-build-isolation`,wrap:!1}}),V=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMEdQVFFDb25maWclMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMmZhY2Vib29rJTJGb3B0LTEyNW0lMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMEFncHRxX2NvbmZpZyUyMCUzRCUyMEdQVFFDb25maWcoYml0cyUzRDQlMkMlMjBncm91cF9zaXplJTNEMTI4JTJDJTIwZGF0YXNldCUzRCUyMndpa2l0ZXh0MiUyMiUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciklMEElMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0RncHRxX2NvbmZpZyklMEElMEElMjMlMjBzYXZlJTIwcXVhbnRpemVkJTIwbW9kZWwlMEFxdWFudGl6ZWRfbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMi4lMkZvcHQtMTI1bS1ncHRxJTIyKSUwQXRva2VuaXplci5zYXZlX3ByZXRyYWluZWQoJTIyLiUyRm9wdC0xMjVtLWdwdHElMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, GPTQConfig

model_id = <span class="hljs-string">&quot;facebook/opt-125m&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)

gptq_config = GPTQConfig(bits=<span class="hljs-number">4</span>, group_size=<span class="hljs-number">128</span>, dataset=<span class="hljs-string">&quot;wikitext2&quot;</span>, tokenizer=tokenizer)

quantized_model = AutoModelForCausalLM.from_pretrained(model_id, device_map=<span class="hljs-string">&quot;auto&quot;</span>, quantization_config=gptq_config)

<span class="hljs-comment"># save quantized model</span>
quantized_model.save_pretrained(<span class="hljs-string">&quot;./opt-125m-gptq&quot;</span>)
tokenizer.save_pretrained(<span class="hljs-string">&quot;./opt-125m-gptq&quot;</span>)`,wrap:!1}}),Y=new M({props:{title:"AQLM quantization",local:"aqlm-quantization",headingTag:"h2"}}),O=new c({props:{code:"cXVhbnRpemVkX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkJsYWNrU2Ftb3JleiUyRk1peHRyYWwtOHg3Yi1BUUxNLTJCaXQtMXgxNi1oZi10ZXN0LWRpc3BhdGNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0QlMjJhdXRvJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUlMkMlMEEpJTBBJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiklMEElMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChxdWFudGl6ZWRfbW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyk=",highlighted:`quantized_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;BlackSamorez/Mixtral-8x7b-AQLM-2Bit-1x16-hf-test-dispatch&quot;</span>,
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, low_cpu_mem_usage=<span class="hljs-literal">True</span>,
)

peft_config = LoraConfig(...)

quantized_model = get_peft_model(quantized_model, peft_config)`,wrap:!1}}),et=new M({props:{title:"EETQ quantization",local:"eetq-quantization",headingTag:"h2"}}),nt=new c({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwRWV0cUNvbmZpZyUwQSUwQWNvbmZpZyUyMCUzRCUyMEVldHFDb25maWcoJTIyaW50OCUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> EetqConfig

config = EetqConfig(<span class="hljs-string">&quot;int8&quot;</span>)`,wrap:!1}}),it=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, quantization_config=config)`,wrap:!1}}),st=new c({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0Q4JTJDJTBBJTIwJTIwJTIwJTIwdGFyZ2V0X21vZHVsZXMlM0QlNUIlMjJxX3Byb2olMjIlMkMlMjAlMjJrX3Byb2olMjIlMkMlMjAlMjJ2X3Byb2olMjIlMkMlMjAlMjJvX3Byb2olMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjA1JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIlMEEpJTBBJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">8</span>,
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>],
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)

model = get_peft_model(model, config)`,wrap:!1}}),rt=new M({props:{title:"HQQ quantization",local:"hqq-quantization",headingTag:"h2"}}),mt=new c({props:{code:"ZnJvbSUyMGhxcS5lbmdpbmUuaGYlMjBpbXBvcnQlMjBIUVFNb2RlbEZvckNhdXNhbExNJTBBJTBBcXVhbnRpemVkX21vZGVsJTIwJTNEJTIwSFFRTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3F1YW50aXplZChzYXZlX2Rpcl9vcl9oZmh1YiUyQyUyMGRldmljZSUzRCdjdWRhJyklMEFwZWZ0X2NvbmZpZyUyMCUzRCUyMExvcmFDb25maWcoLi4uKSUwQXF1YW50aXplZF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKHF1YW50aXplZF9tb2RlbCUyQyUyMHBlZnRfY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> hqq.engine.hf <span class="hljs-keyword">import</span> HQQModelForCausalLM

quantized_model = HQQModelForCausalLM.from_quantized(save_dir_or_hfhub, device=<span class="hljs-string">&#x27;cuda&#x27;</span>)
peft_config = LoraConfig(...)
quantized_model = get_peft_model(quantized_model, peft_config)`,wrap:!1}}),ut=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEhxcUNvbmZpZyUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwSHFxQ29uZmlnKG5iaXRzJTNENCUyQyUyMGdyb3VwX3NpemUlM0Q2NCklMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoc2F2ZV9kaXJfb3JfaGZodWIlMkMlMjBkZXZpY2VfbWFwJTNEZGV2aWNlX21hcCUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWcpJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiklMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChxdWFudGl6ZWRfbW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> HqqConfig, AutoModelForCausalLM

quant_config = HqqConfig(nbits=<span class="hljs-number">4</span>, group_size=<span class="hljs-number">64</span>)
quantized_model = AutoModelForCausalLM.from_pretrained(save_dir_or_hfhub, device_map=device_map, quantization_config=quant_config)
peft_config = LoraConfig(...)
quantized_model = get_peft_model(quantized_model, peft_config)`,wrap:!1}}),dt=new M({props:{title:"torchao (PyTorch Architecture Optimization)",local:"torchao-pytorch-architecture-optimization",headingTag:"h2"}}),ct=new c({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBUb3JjaEFvQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAuLi4lMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwVG9yY2hBb0NvbmZpZyhxdWFudF90eXBlJTNEJTIyaW50OF93ZWlnaHRfb25seSUyMiklMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWcpJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiklMEFtb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, TorchAoConfig

model_id = ...
quantization_config = TorchAoConfig(quant_type=<span class="hljs-string">&quot;int8_weight_only&quot;</span>)
base_model = AutoModelForCausalLM.from_pretrained(model_id, quantization_config=quantization_config)
peft_config = LoraConfig(...)
model = get_peft_model(base_model, peft_config)`,wrap:!1}}),Mt=new M({props:{title:"Caveats:",local:"caveats",headingTag:"h3"}}),yt=new M({props:{title:"INC quantization",local:"inc-quantization",headingTag:"h2"}}),wt=new c({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwbmV1cmFsX2NvbXByZXNzb3IudG9yY2gucXVhbnRpemF0aW9uJTIwaW1wb3J0JTIwRlA4Q29uZmlnJTJDJTIwY29udmVydCUyQyUyMGZpbmFsaXplX2NhbGlicmF0aW9uJTJDJTIwcHJlcGFyZSUwQXF1YW50X2NvbmZpZ3MlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAuLi4lMEElN0QlMEFjb25maWclMjAlM0QlMjBGUDhDb25maWcoKipxdWFudF9jb25maWdzKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> neural_compressor.torch.quantization <span class="hljs-keyword">import</span> FP8Config, convert, finalize_calibration, prepare
quant_configs = {
    ...
}
config = FP8Config(**quant_configs)`,wrap:!1}}),Jt=new c({props:{code:"",highlighted:`model = prepare(model, config)
<span class="hljs-comment"># Run inference to collect calibration statistics</span>
...
<span class="hljs-comment"># Finalize calibration and convert the model to FP8 precision</span>
finalize_calibration(model)
model = convert(model)
<span class="hljs-comment"># Load PEFT LoRA adapter as usual</span>
...`,wrap:!1}}),_t=new M({props:{title:"Caveats:",local:"caveats",headingTag:"h3"}}),vt=new M({props:{title:"Other Supported PEFT Methods",local:"other-supported-peft-methods",headingTag:"h2"}}),Ct=new M({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),Qt=new Hl({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/quantization.md"}}),{c(){b=o("meta"),Bt=a(),kt=o("p"),Ut=a(),p(y.$$.fragment),Ft=a(),g=o("p"),g.textContent=tl,Xt=a(),w=o("ul"),w.innerHTML=el,Rt=a(),T=o("p"),T.innerHTML=ll,xt=a(),J=o("p"),J.textContent=nl,Et=a(),p($.$$.fragment),It=a(),_=o("p"),_.innerHTML=al,Gt=a(),q=o("ul"),q.innerHTML=il,At=a(),p(v.$$.fragment),Ht=a(),j=o("p"),j.innerHTML=ol,Nt=a(),p(Z.$$.fragment),Vt=a(),C=o("p"),C.innerHTML=sl,Pt=a(),p(z.$$.fragment),Yt=a(),W=o("p"),W.textContent=rl,St=a(),p(Q.$$.fragment),Dt=a(),k=o("p"),k.innerHTML=pl,Kt=a(),p(L.$$.fragment),Ot=a(),B=o("p"),B.innerHTML=ml,te=a(),p(U.$$.fragment),ee=a(),F=o("p"),F.textContent=fl,le=a(),p(X.$$.fragment),ne=a(),R=o("p"),R.innerHTML=ul,ae=a(),x=o("p"),x.innerHTML=dl,ie=a(),p(E.$$.fragment),oe=a(),I=o("p"),I.innerHTML=hl,se=a(),p(G.$$.fragment),re=a(),p(A.$$.fragment),pe=a(),H=o("p"),H.innerHTML=cl,me=a(),p(N.$$.fragment),fe=a(),p(V.$$.fragment),ue=a(),P=o("p"),P.textContent=Ml,de=a(),p(Y.$$.fragment),he=a(),S=o("p"),S.innerHTML=bl,ce=a(),D=o("p"),D.innerHTML=yl,Me=a(),K=o("p"),K.innerHTML=gl,be=a(),p(O.$$.fragment),ye=a(),tt=o("p"),tt.innerHTML=wl,ge=a(),p(et.$$.fragment),we=a(),lt=o("p"),lt.innerHTML=Tl,Te=a(),p(nt.$$.fragment),Je=a(),at=o("p"),at.innerHTML=Jl,$e=a(),p(it.$$.fragment),_e=a(),ot=o("p"),ot.innerHTML=$l,qe=a(),p(st.$$.fragment),ve=a(),p(rt.$$.fragment),je=a(),pt=o("p"),pt.innerHTML=_l,Ze=a(),p(mt.$$.fragment),Ce=a(),ft=o("p"),ft.textContent=ql,ze=a(),p(ut.$$.fragment),We=a(),p(dt.$$.fragment),Qe=a(),ht=o("p"),ht.innerHTML=vl,ke=a(),p(ct.$$.fragment),Le=a(),p(Mt.$$.fragment),Be=a(),bt=o("ul"),bt.innerHTML=jl,Ue=a(),p(yt.$$.fragment),Fe=a(),gt=o("p"),gt.innerHTML=Zl,Xe=a(),p(wt.$$.fragment),Re=a(),Tt=o("p"),Tt.innerHTML=Cl,xe=a(),p(Jt.$$.fragment),Ee=a(),$t=o("p"),$t.innerHTML=zl,Ie=a(),p(_t.$$.fragment),Ge=a(),qt=o("ul"),qt.innerHTML=Wl,Ae=a(),p(vt.$$.fragment),He=a(),jt=o("p"),jt.textContent=Ql,Ne=a(),Zt=o("ul"),Zt.innerHTML=kl,Ve=a(),p(Ct.$$.fragment),Pe=a(),zt=o("p"),zt.textContent=Ll,Ye=a(),Wt=o("ul"),Wt.innerHTML=Bl,Se=a(),p(Qt.$$.fragment),De=a(),Lt=o("p"),this.h()},l(t){const e=Gl("svelte-u9bgzb",document.head);b=s(e,"META",{name:!0,content:!0}),e.forEach(l),Bt=i(t),kt=s(t,"P",{}),Ul(kt).forEach(l),Ut=i(t),m(y.$$.fragment,t),Ft=i(t),g=s(t,"P",{"data-svelte-h":!0}),r(g)!=="svelte-famg4s"&&(g.textContent=tl),Xt=i(t),w=s(t,"UL",{"data-svelte-h":!0}),r(w)!=="svelte-27c91"&&(w.innerHTML=el),Rt=i(t),T=s(t,"P",{"data-svelte-h":!0}),r(T)!=="svelte-142xot4"&&(T.innerHTML=ll),xt=i(t),J=s(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1demhiu"&&(J.textContent=nl),Et=i(t),m($.$$.fragment,t),It=i(t),_=s(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-p0gbf4"&&(_.innerHTML=al),Gt=i(t),q=s(t,"UL",{"data-svelte-h":!0}),r(q)!=="svelte-hfynw8"&&(q.innerHTML=il),At=i(t),m(v.$$.fragment,t),Ht=i(t),j=s(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-pxonbi"&&(j.innerHTML=ol),Nt=i(t),m(Z.$$.fragment,t),Vt=i(t),C=s(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1i20kxq"&&(C.innerHTML=sl),Pt=i(t),m(z.$$.fragment,t),Yt=i(t),W=s(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-11mx7fc"&&(W.textContent=rl),St=i(t),m(Q.$$.fragment,t),Dt=i(t),k=s(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-16xpk8c"&&(k.innerHTML=pl),Kt=i(t),m(L.$$.fragment,t),Ot=i(t),B=s(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-rnh6oi"&&(B.innerHTML=ml),te=i(t),m(U.$$.fragment,t),ee=i(t),F=s(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-xd402n"&&(F.textContent=fl),le=i(t),m(X.$$.fragment,t),ne=i(t),R=s(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-f32n60"&&(R.innerHTML=ul),ae=i(t),x=s(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-7f0aai"&&(x.innerHTML=dl),ie=i(t),m(E.$$.fragment,t),oe=i(t),I=s(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1c7jiea"&&(I.innerHTML=hl),se=i(t),m(G.$$.fragment,t),re=i(t),m(A.$$.fragment,t),pe=i(t),H=s(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-waooev"&&(H.innerHTML=cl),me=i(t),m(N.$$.fragment,t),fe=i(t),m(V.$$.fragment,t),ue=i(t),P=s(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-lqq230"&&(P.textContent=Ml),de=i(t),m(Y.$$.fragment,t),he=i(t),S=s(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-h7ytse"&&(S.innerHTML=bl),ce=i(t),D=s(t,"P",{"data-svelte-h":!0}),r(D)!=="svelte-120mr43"&&(D.innerHTML=yl),Me=i(t),K=s(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-wlm3ol"&&(K.innerHTML=gl),be=i(t),m(O.$$.fragment,t),ye=i(t),tt=s(t,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-1f1bzer"&&(tt.innerHTML=wl),ge=i(t),m(et.$$.fragment,t),we=i(t),lt=s(t,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-16tz5mo"&&(lt.innerHTML=Tl),Te=i(t),m(nt.$$.fragment,t),Je=i(t),at=s(t,"P",{"data-svelte-h":!0}),r(at)!=="svelte-pxonbi"&&(at.innerHTML=Jl),$e=i(t),m(it.$$.fragment,t),_e=i(t),ot=s(t,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-1wgonl8"&&(ot.innerHTML=$l),qe=i(t),m(st.$$.fragment,t),ve=i(t),m(rt.$$.fragment,t),je=i(t),pt=s(t,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-1yzgecf"&&(pt.innerHTML=_l),Ze=i(t),m(mt.$$.fragment,t),Ce=i(t),ft=s(t,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-p9acs7"&&(ft.textContent=ql),ze=i(t),m(ut.$$.fragment,t),We=i(t),m(dt.$$.fragment,t),Qe=i(t),ht=s(t,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-gynv46"&&(ht.innerHTML=vl),ke=i(t),m(ct.$$.fragment,t),Le=i(t),m(Mt.$$.fragment,t),Be=i(t),bt=s(t,"UL",{"data-svelte-h":!0}),r(bt)!=="svelte-4si0iy"&&(bt.innerHTML=jl),Ue=i(t),m(yt.$$.fragment,t),Fe=i(t),gt=s(t,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-8d7dps"&&(gt.innerHTML=Zl),Xe=i(t),m(wt.$$.fragment,t),Re=i(t),Tt=s(t,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-10yr85u"&&(Tt.innerHTML=Cl),xe=i(t),m(Jt.$$.fragment,t),Ee=i(t),$t=s(t,"P",{"data-svelte-h":!0}),r($t)!=="svelte-1ugpcug"&&($t.innerHTML=zl),Ie=i(t),m(_t.$$.fragment,t),Ge=i(t),qt=s(t,"UL",{"data-svelte-h":!0}),r(qt)!=="svelte-h65blx"&&(qt.innerHTML=Wl),Ae=i(t),m(vt.$$.fragment,t),He=i(t),jt=s(t,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-14evo3v"&&(jt.textContent=Ql),Ne=i(t),Zt=s(t,"UL",{"data-svelte-h":!0}),r(Zt)!=="svelte-ro48c4"&&(Zt.innerHTML=kl),Ve=i(t),m(Ct.$$.fragment,t),Pe=i(t),zt=s(t,"P",{"data-svelte-h":!0}),r(zt)!=="svelte-agdyn7"&&(zt.textContent=Ll),Ye=i(t),Wt=s(t,"UL",{"data-svelte-h":!0}),r(Wt)!=="svelte-10zqaf7"&&(Wt.innerHTML=Bl),Se=i(t),m(Qt.$$.fragment,t),De=i(t),Lt=s(t,"P",{}),Ul(Lt).forEach(l),this.h()},h(){Fl(b,"name","hf:doc:metadata"),Fl(b,"content",Vl)},m(t,e){Al(document.head,b),n(t,Bt,e),n(t,kt,e),n(t,Ut,e),f(y,t,e),n(t,Ft,e),n(t,g,e),n(t,Xt,e),n(t,w,e),n(t,Rt,e),n(t,T,e),n(t,xt,e),n(t,J,e),n(t,Et,e),f($,t,e),n(t,It,e),n(t,_,e),n(t,Gt,e),n(t,q,e),n(t,At,e),f(v,t,e),n(t,Ht,e),n(t,j,e),n(t,Nt,e),f(Z,t,e),n(t,Vt,e),n(t,C,e),n(t,Pt,e),f(z,t,e),n(t,Yt,e),n(t,W,e),n(t,St,e),f(Q,t,e),n(t,Dt,e),n(t,k,e),n(t,Kt,e),f(L,t,e),n(t,Ot,e),n(t,B,e),n(t,te,e),f(U,t,e),n(t,ee,e),n(t,F,e),n(t,le,e),f(X,t,e),n(t,ne,e),n(t,R,e),n(t,ae,e),n(t,x,e),n(t,ie,e),f(E,t,e),n(t,oe,e),n(t,I,e),n(t,se,e),f(G,t,e),n(t,re,e),f(A,t,e),n(t,pe,e),n(t,H,e),n(t,me,e),f(N,t,e),n(t,fe,e),f(V,t,e),n(t,ue,e),n(t,P,e),n(t,de,e),f(Y,t,e),n(t,he,e),n(t,S,e),n(t,ce,e),n(t,D,e),n(t,Me,e),n(t,K,e),n(t,be,e),f(O,t,e),n(t,ye,e),n(t,tt,e),n(t,ge,e),f(et,t,e),n(t,we,e),n(t,lt,e),n(t,Te,e),f(nt,t,e),n(t,Je,e),n(t,at,e),n(t,$e,e),f(it,t,e),n(t,_e,e),n(t,ot,e),n(t,qe,e),f(st,t,e),n(t,ve,e),f(rt,t,e),n(t,je,e),n(t,pt,e),n(t,Ze,e),f(mt,t,e),n(t,Ce,e),n(t,ft,e),n(t,ze,e),f(ut,t,e),n(t,We,e),f(dt,t,e),n(t,Qe,e),n(t,ht,e),n(t,ke,e),f(ct,t,e),n(t,Le,e),f(Mt,t,e),n(t,Be,e),n(t,bt,e),n(t,Ue,e),f(yt,t,e),n(t,Fe,e),n(t,gt,e),n(t,Xe,e),f(wt,t,e),n(t,Re,e),n(t,Tt,e),n(t,xe,e),f(Jt,t,e),n(t,Ee,e),n(t,$t,e),n(t,Ie,e),f(_t,t,e),n(t,Ge,e),n(t,qt,e),n(t,Ae,e),f(vt,t,e),n(t,He,e),n(t,jt,e),n(t,Ne,e),n(t,Zt,e),n(t,Ve,e),f(Ct,t,e),n(t,Pe,e),n(t,zt,e),n(t,Ye,e),n(t,Wt,e),n(t,Se,e),f(Qt,t,e),n(t,De,e),n(t,Lt,e),Ke=!0},p:Rl,i(t){Ke||(u(y.$$.fragment,t),u($.$$.fragment,t),u(v.$$.fragment,t),u(Z.$$.fragment,t),u(z.$$.fragment,t),u(Q.$$.fragment,t),u(L.$$.fragment,t),u(U.$$.fragment,t),u(X.$$.fragment,t),u(E.$$.fragment,t),u(G.$$.fragment,t),u(A.$$.fragment,t),u(N.$$.fragment,t),u(V.$$.fragment,t),u(Y.$$.fragment,t),u(O.$$.fragment,t),u(et.$$.fragment,t),u(nt.$$.fragment,t),u(it.$$.fragment,t),u(st.$$.fragment,t),u(rt.$$.fragment,t),u(mt.$$.fragment,t),u(ut.$$.fragment,t),u(dt.$$.fragment,t),u(ct.$$.fragment,t),u(Mt.$$.fragment,t),u(yt.$$.fragment,t),u(wt.$$.fragment,t),u(Jt.$$.fragment,t),u(_t.$$.fragment,t),u(vt.$$.fragment,t),u(Ct.$$.fragment,t),u(Qt.$$.fragment,t),Ke=!0)},o(t){d(y.$$.fragment,t),d($.$$.fragment,t),d(v.$$.fragment,t),d(Z.$$.fragment,t),d(z.$$.fragment,t),d(Q.$$.fragment,t),d(L.$$.fragment,t),d(U.$$.fragment,t),d(X.$$.fragment,t),d(E.$$.fragment,t),d(G.$$.fragment,t),d(A.$$.fragment,t),d(N.$$.fragment,t),d(V.$$.fragment,t),d(Y.$$.fragment,t),d(O.$$.fragment,t),d(et.$$.fragment,t),d(nt.$$.fragment,t),d(it.$$.fragment,t),d(st.$$.fragment,t),d(rt.$$.fragment,t),d(mt.$$.fragment,t),d(ut.$$.fragment,t),d(dt.$$.fragment,t),d(ct.$$.fragment,t),d(Mt.$$.fragment,t),d(yt.$$.fragment,t),d(wt.$$.fragment,t),d(Jt.$$.fragment,t),d(_t.$$.fragment,t),d(vt.$$.fragment,t),d(Ct.$$.fragment,t),d(Qt.$$.fragment,t),Ke=!1},d(t){t&&(l(Bt),l(kt),l(Ut),l(Ft),l(g),l(Xt),l(w),l(Rt),l(T),l(xt),l(J),l(Et),l(It),l(_),l(Gt),l(q),l(At),l(Ht),l(j),l(Nt),l(Vt),l(C),l(Pt),l(Yt),l(W),l(St),l(Dt),l(k),l(Kt),l(Ot),l(B),l(te),l(ee),l(F),l(le),l(ne),l(R),l(ae),l(x),l(ie),l(oe),l(I),l(se),l(re),l(pe),l(H),l(me),l(fe),l(ue),l(P),l(de),l(he),l(S),l(ce),l(D),l(Me),l(K),l(be),l(ye),l(tt),l(ge),l(we),l(lt),l(Te),l(Je),l(at),l($e),l(_e),l(ot),l(qe),l(ve),l(je),l(pt),l(Ze),l(Ce),l(ft),l(ze),l(We),l(Qe),l(ht),l(ke),l(Le),l(Be),l(bt),l(Ue),l(Fe),l(gt),l(Xe),l(Re),l(Tt),l(xe),l(Ee),l($t),l(Ie),l(Ge),l(qt),l(Ae),l(He),l(jt),l(Ne),l(Zt),l(Ve),l(Pe),l(zt),l(Ye),l(Wt),l(Se),l(De),l(Lt)),l(b),h(y,t),h($,t),h(v,t),h(Z,t),h(z,t),h(Q,t),h(L,t),h(U,t),h(X,t),h(E,t),h(G,t),h(A,t),h(N,t),h(V,t),h(Y,t),h(O,t),h(et,t),h(nt,t),h(it,t),h(st,t),h(rt,t),h(mt,t),h(ut,t),h(dt,t),h(ct,t),h(Mt,t),h(yt,t),h(wt,t),h(Jt,t),h(_t,t),h(vt,t),h(Ct,t),h(Qt,t)}}}const Vl='{"title":"Quantization","local":"quantization","sections":[{"title":"Quantize a model","local":"quantize-a-model","sections":[],"depth":2},{"title":"LoraConfig","local":"loraconfig","sections":[{"title":"LoftQ initialization","local":"loftq-initialization","sections":[],"depth":3},{"title":"QLoRA-style training","local":"qlora-style-training","sections":[],"depth":3}],"depth":2},{"title":"GPTQ quantization","local":"gptq-quantization","sections":[],"depth":2},{"title":"AQLM quantization","local":"aqlm-quantization","sections":[],"depth":2},{"title":"EETQ quantization","local":"eetq-quantization","sections":[],"depth":2},{"title":"HQQ quantization","local":"hqq-quantization","sections":[],"depth":2},{"title":"torchao (PyTorch Architecture Optimization)","local":"torchao-pytorch-architecture-optimization","sections":[{"title":"Caveats:","local":"caveats","sections":[],"depth":3}],"depth":2},{"title":"INC quantization","local":"inc-quantization","sections":[{"title":"Caveats:","local":"caveats","sections":[],"depth":3}],"depth":2},{"title":"Other Supported PEFT Methods","local":"other-supported-peft-methods","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Pl(Oe){return xl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ol extends El{constructor(b){super(),Il(this,b,Pl,Nl,Xl,{})}}export{Ol as component};
