import{s as w0,o as J0,n as gI}from"../chunks/scheduler.9bc65507.js";import{S as U0,i as m0,g as a,s as p,u as c,A as f0,h as n,f as e,c as o,j as r,v as h,y as i,k as M,o as u,a as l,w as y,d as j,t as d,x as T}from"../chunks/index.78c82d43.js";import{T as AI}from"../chunks/Tip.87d55b76.js";import{D as I0}from"../chunks/Docstring.f3d04bd2.js";import{C as w}from"../chunks/CodeBlock.48618ec2.js";import{I as J}from"../chunks/IconCopyLink.bedaa44d.js";function C0(qt){let U,v="This section is a must-read";return{c(){U=a("p"),U.textContent=v},l(m){U=n(m,"P",{"data-svelte-h":!0}),i(U)!=="svelte-10scaxe"&&(U.textContent=v)},m(m,I){l(m,U,I)},p:gI,d(m){m&&e(U)}}}function v0(qt){let U,v="As of <code>deepspeed==0.6.0</code> the bf16 support is new and experimental.",m,I,_='If you use <a href="#gradient-accumulation">gradient accumulation</a> with bf16-enabled, you need to be aware that it’ll accumulate gradients in bf16, which may not be what you want due to this format’s low precision, as it may lead to a lossy accumulation.',b,A,x="A work is being done to fix that and provide an option to use a higher precision <code>dtype</code> (fp16 or fp32).";return{c(){U=a("p"),U.innerHTML=v,m=p(),I=a("p"),I.innerHTML=_,b=p(),A=a("p"),A.innerHTML=x},l(f){U=n(f,"P",{"data-svelte-h":!0}),i(U)!=="svelte-zhd1i5"&&(U.innerHTML=v),m=o(f),I=n(f,"P",{"data-svelte-h":!0}),i(I)!=="svelte-1330j3o"&&(I.innerHTML=_),b=o(f),A=n(f,"P",{"data-svelte-h":!0}),i(A)!=="svelte-1efu1t3"&&(A.innerHTML=x)},m(f,B){l(f,U,B),l(f,m,B),l(f,I,B),l(f,b,B),l(f,A,B)},p:gI,d(f){f&&(e(U),e(m),e(I),e(b),e(A))}}}function b0(qt){let U,v=`Note, that once <code>load_state_dict_from_zero_checkpoint</code> was run, the <code>model</code> will no longer be usable in the
DeepSpeed context of the same application. i.e. you will need to re-initialize the deepspeed engine, since
<code>model.load_state_dict(state_dict)</code> will remove all the DeepSpeed magic from it. So do this only at the very end
of the training.`;return{c(){U=a("p"),U.innerHTML=v},l(m){U=n(m,"P",{"data-svelte-h":!0}),i(U)!=="svelte-1jfwcm8"&&(U.innerHTML=v)},m(m,I){l(m,U,I)},p:gI,d(m){m&&e(U)}}}function A0(qt){let U,v,m,I,_,b,A,x,f,B,_I="DeepSpeed Integration",qc,Ne,BI='<a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a> implements everything described in the <a href="https://arxiv.org/abs/1910.02054" rel="nofollow">ZeRO paper</a>. Currently it provides full support for:',kc,ze,ZI="<li>Optimizer state partitioning (ZeRO stage 1)</li> <li>Gradient partitioning (ZeRO stage 2)</li> <li>Parameter partitioning (ZeRO stage 3)</li> <li>Custom mixed precision training handling</li> <li>A range of fast CUDA-extension-based optimizers</li> <li>ZeRO-Offload to CPU and NVMe</li>",Sc,Ee,xI=`ZeRO-Offload has its own dedicated paper: <a href="https://arxiv.org/abs/2101.06840" rel="nofollow">ZeRO-Offload: Democratizing Billion-Scale Model Training</a>. And NVMe-support is described in the paper <a href="https://arxiv.org/abs/2104.07857" rel="nofollow">ZeRO-Infinity: Breaking the GPU
Memory Wall for Extreme Scale Deep Learning</a>.`,$c,Ge,qI="DeepSpeed ZeRO-2 is primarily used only for training, as its features are of no use to inference.",Nc,We,kI=`DeepSpeed ZeRO-3 can be used for inference as well, since it allows huge models to be loaded on multiple GPUs, which
won’t be possible on a single GPU.`,zc,Re,SI='🤗 Transformers integrates <a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a> via 2 options:',Ec,Xe,$I=`<li>Integration of the core DeepSpeed features via <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a>. This is an everything-done-for-you type
of integration - just supply your custom config file or use our template and you have nothing else to do. Most of
this document is focused on this feature.</li> <li>If you don’t use <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> and want to use your own Trainer where you integrated DeepSpeed
yourself, core functionality functions like <code>from_pretrained</code> and <code>from_config</code> include integration of essential
parts of DeepSpeed like <code>zero.Init</code> for ZeRO stage 3 and higher. To tap into this feature read the docs on
<a href="#nontrainer-deepspeed-integration">non-Trainer DeepSpeed Integration</a>.</li>`,Gc,He,NI="What is integrated:",Wc,Qe,zI="Training:",Rc,Ve,EI="<li>DeepSpeed ZeRO training supports the full ZeRO stages 1, 2 and 3 with ZeRO-Infinity (CPU and NVME offload).</li>",Xc,Ye,GI="Inference:",Hc,Le,WI=`<li>DeepSpeed ZeRO Inference supports ZeRO stage 3 with ZeRO-Infinity. It uses the same ZeRO protocol as training, but
it doesn’t use an optimizer and a lr scheduler and only stage 3 is relevant. For more details see:
<a href="#zero-inference">zero-inference</a>.</li>`,Qc,Fe,RI=`There is also DeepSpeed Inference - this is a totally different technology which uses Tensor Parallelism instead of
ZeRO (coming soon).`,Vc,LM,Yc,q,kt,Zr,Pe,Tf,FM,XI="Trainer Deepspeed Integration",Lc,PM,Fc,k,St,xr,De,wf,DM,HI="Installation",Pc,Oe,QI="Install the library via pypi:",Dc,Ke,Oc,ts,VI="or via <code>transformers</code>’ <code>extras</code>:",Kc,es,th,ss,YI=`or find more details on <a href="https://github.com/microsoft/deepspeed#installation" rel="nofollow">the DeepSpeed’s GitHub page</a> and
<a href="https://www.deepspeed.ai/tutorials/advanced-install/" rel="nofollow">advanced install</a>.`,eh,ls,LI='If you’re still struggling with the build, first make sure to read <a href="trainer#cuda-extension-installation-notes">CUDA Extension Installation Notes</a>.',sh,as,FI=`If you don’t prebuild the extensions and rely on them to be built at run time and you tried all of the above solutions
to no avail, the next thing to try is to pre-build the modules before installing them.`,lh,ns,PI="To make a local build for DeepSpeed:",ah,ps,nh,os,DI=`If you intend to use NVMe offload you will also need to include <code>DS_BUILD_AIO=1</code> in the instructions above (and also
install <em>libaio-dev</em> system-wide).`,ph,is,OI=`Edit <code>TORCH_CUDA_ARCH_LIST</code> to insert the code for the architectures of the GPU cards you intend to use. Assuming all
your cards are the same you can get the arch via:`,oh,Ms,ih,us,KI=`So if you get <code>8, 6</code>, then use <code>TORCH_CUDA_ARCH_LIST=&quot;8.6&quot;</code>. If you have multiple different cards, you can list all
of them like so <code>TORCH_CUDA_ARCH_LIST=&quot;6.1;8.6&quot;</code>`,Mh,rs,tC="If you need to use the same setup on multiple machines, make a binary wheel:",uh,cs,rh,hs,eC=`it will generate something like <code>dist/deepspeed-0.3.13+8cd046f-cp38-cp38-linux_x86_64.whl</code> which now you can install
as <code>pip install deepspeed-0.3.13+8cd046f-cp38-cp38-linux_x86_64.whl</code> locally or on any other machine.`,ch,ys,sC="Again, remember to ensure to adjust <code>TORCH_CUDA_ARCH_LIST</code> to the target architectures.",hh,js,lC=`You can find the complete list of NVIDIA GPUs and their corresponding <strong>Compute Capabilities</strong> (same as arch in this
context) <a href="https://developer.nvidia.com/cuda-gpus" rel="nofollow">here</a>.`,yh,ds,aC="You can check the archs pytorch was built with using:",jh,Ts,dh,ws,nC="Here is how to find out the arch for one of the installed GPUs. For example, for GPU 0:",Th,Js,wh,Us,pC="If the output is:",Jh,ms,Uh,fs,oC="then you know that this card’s arch is <code>8.6</code>.",mh,Is,iC=`You can also leave <code>TORCH_CUDA_ARCH_LIST</code> out completely and then the build program will automatically query the
architecture of the GPUs the build is made on. This may or may not match the GPUs on the target machines, that’s why
it’s best to specify the desired archs explicitly.`,fh,Cs,MC=`If after trying everything suggested you still encounter build issues, please, proceed with the GitHub Issue of
<a href="https://github.com/microsoft/DeepSpeed/issues" rel="nofollow">Deepspeed</a>,`,Ih,OM,Ch,S,$t,qr,vs,Jf,KM,uC="Deployment with multiple GPUs",vh,bs,rC=`To deploy the DeepSpeed integration adjust the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> command line arguments to include a new argument <code>--deepspeed ds_config.json</code>, where <code>ds_config.json</code> is the DeepSpeed configuration file as
documented <a href="https://www.deepspeed.ai/docs/config-json/" rel="nofollow">here</a>. The file naming is up to you.
It’s recommended to use DeepSpeed’s <code>add_config_arguments</code> utility to add the necessary command line arguments to your code.
For more information please see <a href="https://deepspeed.readthedocs.io/en/latest/initialize.html#argument-parsing" rel="nofollow">DeepSpeed’s Argument Parsing</a> doc.`,bh,As,cC="You can use a launcher of your choice here. You can continue using the pytorch launcher:",Ah,gs,gh,_s,hC="or use the launcher provided by <code>deepspeed</code>:",_h,Bs,Bh,Zs,yC=`As you can see the arguments aren’t the same, but for most needs either of them works. The
full details on how to configure various nodes and GPUs can be found <a href="https://www.deepspeed.ai/getting-started/#resource-configuration-multi-node" rel="nofollow">here</a>.`,Zh,xs,jC="When you use the <code>deepspeed</code> launcher and you want to use all available gpus you can just omit the <code>--num_gpus</code> flag.",xh,qs,dC="Here is an example of running <code>run_translation.py</code> under DeepSpeed deploying all available GPUs:",qh,ks,kh,Ss,TC=`Note that in the DeepSpeed documentation you are likely to see <code>--deepspeed --deepspeed_config ds_config.json</code> - i.e.
two DeepSpeed-related arguments, but for the sake of simplicity, and since there are already so many arguments to deal
with, we combined the two into a single argument.`,Sh,$s,wC='For some practical usage examples, please, see this <a href="https://github.com/huggingface/transformers/issues/8771#issuecomment-759248400" rel="nofollow">post</a>.',$h,tu,Nh,$,Nt,kr,Ns,Uf,eu,JC="Deployment with one GPU",zh,zs,UC='To deploy DeepSpeed with one GPU adjust the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> command line arguments as follows:',Eh,Es,Gh,Gs,mC=`This is almost the same as with multiple-GPUs, but here we tell DeepSpeed explicitly to use just one GPU via
<code>--num_gpus=1</code>. By default, DeepSpeed deploys all GPUs it can see on the given node. If you have only 1 GPU to start
with, then you don’t need this argument. The following <a href="https://www.deepspeed.ai/getting-started/#resource-configuration-multi-node" rel="nofollow">documentation</a> discusses the launcher options.`,Wh,Ws,fC="Why would you want to use DeepSpeed with just one GPU?",Rh,Rs,IC=`<li>It has a ZeRO-offload feature which can delegate some computations and memory to the host’s CPU and RAM, and thus
leave more GPU resources for model’s needs - e.g. larger batch size, or enabling a fitting of a very big model which
normally won’t fit.</li> <li>It provides a smart GPU memory management system, that minimizes memory fragmentation, which again allows you to fit
bigger models and data batches.</li>`,Xh,Xs,CC=`While we are going to discuss the configuration in details next, the key to getting a huge improvement on a single GPU
with DeepSpeed is to have at least the following configuration in the configuration file:`,Hh,Hs,Qh,Qs,vC=`which enables optimizer offload and some other important features. You may experiment with the buffer sizes, you will
find more details in the discussion below.`,Vh,Vs,bC='For a practical usage example of this type of deployment, please, see this <a href="https://github.com/huggingface/transformers/issues/8771#issuecomment-759176685" rel="nofollow">post</a>.',Yh,Ys,AC="You may also try the ZeRO-3 with CPU and NVMe offload as explained further in this document.",Lh,Ls,gC="Notes:",Fh,su,N,lu,_C=`if you need to run on a specific GPU, which is different from GPU 0, you can’t use <code>CUDA_VISIBLE_DEVICES</code> to limit
the visible scope of available GPUs. Instead, you have to use the following syntax:`,mf,Fs,ff,au,BC="In this example, we tell DeepSpeed to use GPU 1 (second gpu).",Ph,nu,Dh,z,zt,Sr,Ps,If,pu,ZC="Deployment with multiple Nodes",Oh,Ds,xC="The information in this section isn’t not specific to the DeepSpeed integration and is applicable to any multi-node program. But DeepSpeed provides a <code>deepspeed</code> launcher that is easier to use than other launchers unless you are in a SLURM environment.",Kh,Os,qC="For the duration of this section let’s assume that you have 2 nodes with 8 gpus each. And you can reach the first node with <code>ssh hostname1</code> and second node with <code>ssh hostname2</code>, and both must be able to reach each other via ssh locally without a password. Of course, you will need to rename these host (node) names to the actual host names you are working with.",ty,E,Et,$r,Ks,Cf,ou,kC="The torch.distributed.run launcher",ey,tl,SC="For example, to use <code>torch.distributed.run</code>, you could do:",sy,el,ly,sl,$C="You have to ssh to each node and run this same command on each one of them! There is no rush, the launcher will wait until both nodes will synchronize.",ay,ll,NC='For more information please see <a href="https://pytorch.org/docs/stable/elastic/run.html" rel="nofollow">torchrun</a>. Incidentally, this is also the launcher that replaced <code>torch.distributed.launch</code> a few pytorch versions back.',ny,G,Gt,Nr,al,vf,iu,zC="The deepspeed launcher",py,nl,EC="To use the <code>deepspeed</code> launcher instead, you have to first create a <code>hostfile</code> file:",oy,pl,iy,ol,GC="and then you can launch it as:",My,il,uy,Ml,WC="Unlike the <code>torch.distributed.run</code> launcher, <code>deepspeed</code> will automatically launch this command on both nodes!",ry,ul,RC='For more information please see <a href="https://www.deepspeed.ai/getting-started/#resource-configuration-multi-node" rel="nofollow">Resource Configuration (multi-node)</a>.',cy,W,Wt,zr,rl,bf,Mu,XC="Launching in a SLURM environment",hy,cl,HC="In the SLURM environment the following approach can be used. The following is a slurm script <code>launch.slurm</code> which you will need to adapt it to your specific SLURM environment.",yy,hl,jy,yl,QC="All is left is to schedule it to run:",dy,jl,Ty,dl,VC="<code>srun</code> will take care of launching the program simultaneously on all nodes.",wy,R,Rt,Er,Tl,Af,uu,YC="Use of Non-shared filesystem",Jy,wl,LC='By default DeepSpeed expects that a multi-node environment uses a shared storage. If this is not the case and each node can only see the local filesystem, you need to adjust the config file to include a  <a href="https://www.deepspeed.ai/docs/config-json/#checkpoint-options" rel="nofollow"><code>checkpoint</code>_section</a> with the following setting:',Uy,Jl,my,Ul,FC='Alternatively, you can also use the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a>’s <code>--save_on_each_node</code> argument, and the above config will be added automatically for you.',fy,ru,Iy,X,Xt,Gr,ml,gf,cu,PC="Deployment in Notebooks",Cy,fl,DC=`The problem with running notebook cells as a script is that there is no normal <code>deepspeed</code> launcher to rely on, so
under certain setups we have to emulate it.`,vy,Il,OC="If you’re using only 1 GPU, here is how you’d have to adjust your training code in the notebook to use DeepSpeed.",by,Cl,Ay,vl,KC="Note: <code>...</code> stands for the normal arguments that you’d pass to the functions.",gy,bl,tv=`If you want to use more than 1 GPU, you must use a multi-process environment for DeepSpeed to work. That is, you have
to use the launcher for that purpose and this cannot be accomplished by emulating the distributed environment presented
at the beginning of this section.`,_y,Al,ev=`If you want to create the config file on the fly in the notebook in the current directory, you could have a dedicated
cell with:`,By,gl,Zy,_l,sv=`If the training script is in a normal file and not in the notebook cells, you can launch <code>deepspeed</code> normally via
shell from a cell. For example, to use <code>run_translation.py</code> you would launch it with:`,xy,Bl,qy,Zl,lv="or with <code>%%bash</code> magic, where you can write a multi-line code for the shell program to run:",ky,xl,Sy,ql,av="In such case you don’t need any of the code presented at the beginning of this section.",$y,kl,nv=`Note: While <code>%%bash</code> magic is neat, but currently it buffers the output so you won’t see the logs until the process
completes.`,Ny,hu,zy,H,Ht,Wr,Sl,_f,yu,pv="Configuration",Ey,$l,ov=`For the complete guide to the DeepSpeed configuration options that can be used in its configuration file please refer
to the <a href="https://www.deepspeed.ai/docs/config-json/" rel="nofollow">following documentation</a>.`,Gy,Nl,iv=`You can find dozens of DeepSpeed configuration examples that address various practical needs in <a href="https://github.com/microsoft/DeepSpeedExamples" rel="nofollow">the DeepSpeedExamples
repo</a>:`,Wy,zl,Ry,El,Mv=`Continuing the code from above, let’s say you’re looking to configure the Lamb optimizer. So you can search through the
example <code>.json</code> files with:`,Xy,Gl,Hy,Wl,uv='Some more examples are to be found in the <a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">main repo</a> as well.',Qy,Rl,rv=`When using DeepSpeed you always need to supply a DeepSpeed configuration file, yet some configuration parameters have
to be configured via the command line. You will find the nuances in the rest of this guide.`,Vy,Xl,cv=`To get an idea of what DeepSpeed configuration file looks like, here is one that activates ZeRO stage 2 features,
including optimizer states cpu offload, uses <code>AdamW</code> optimizer and <code>WarmupLR</code> scheduler and will enable mixed
precision training if <code>--fp16</code> is passed:`,Yy,Hl,Ly,Ql,hv=`When you execute the program, DeepSpeed will log the configuration it received from the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a>
to the console, so you can see exactly what was the final configuration passed to it.`,Fy,ju,Py,Q,Qt,Rr,Vl,Bf,du,yv="Passing Configuration",Dy,Yl,jv=`As discussed in this document normally the DeepSpeed configuration is passed as a path to a json file, but if you’re
not using the command line interface to configure the training, and instead instantiate the
<a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> via <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> then for the <code>deepspeed</code> argument you can
pass a nested <code>dict</code>. This allows you to create the configuration on the fly and doesn’t require you to write it to
the file system before passing it to <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>.`,Oy,Ll,dv="To summarize you can do:",Ky,Fl,tj,Pl,Tv="or:",ej,Dl,sj,Tu,lj,V,Vt,Xr,Ol,Zf,wu,wv="Shared Configuration",aj,Yt,nj,Kl,Jv=`Some configuration values are required by both the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> and DeepSpeed to function correctly,
therefore, to prevent conflicting definitions, which could lead to hard to detect errors, we chose to configure those
via the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> command line arguments.`,pj,ta,Uv=`Additionally, some configuration values are derived automatically based on the model’s configuration, so instead of
remembering to manually adjust multiple values, it’s the best to let the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> do the majority
of configuration for you.`,oj,ea,mv=`Therefore, in the rest of this guide you will find a special configuration value: <code>auto</code>, which when set will be
automatically replaced with the correct or most efficient value. Please feel free to choose to ignore this
recommendation and set the values explicitly, in which case be very careful that your the
<a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> arguments and DeepSpeed configurations agree. For example, are you using the same
learning rate, or batch size, or gradient accumulation settings? if these mismatch the training may fail in very
difficult to detect ways. You have been warned.`,ij,sa,fv=`There are multiple other values that are specific to DeepSpeed-only and those you will have to set manually to suit
your needs.`,Mj,la,Iv=`In your own programs, you can also use the following approach if you’d like to modify the DeepSpeed config as a master
and configure <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> based on that. The steps are:`,uj,aa,Cv='<li>Create or load the DeepSpeed configuration to be used as a master configuration</li> <li>Create the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> object based on these values</li>',rj,na,vv=`Do note that some values, such as <code>scheduler.params.total_num_steps</code> are calculated by
<a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> during <code>train</code>, but you can of course do the math yourself.`,cj,Ju,hj,Y,Lt,Hr,pa,xf,Uu,bv="ZeRO",yj,oa,Av=`<a href="https://www.deepspeed.ai/tutorials/zero/" rel="nofollow">Zero Redundancy Optimizer (ZeRO)</a> is the workhorse of DeepSpeed. It
supports 3 different levels (stages) of optimization. The first one is not quite interesting for scalability purposes,
therefore this document focuses on stages 2 and 3. Stage 3 is further improved by the latest addition of ZeRO-Infinity.
You will find more indepth information in the DeepSpeed documentation.`,jj,ia,gv=`The <code>zero_optimization</code> section of the configuration file is the most important part (<a href="https://www.deepspeed.ai/docs/config-json/#zero-optimizations-for-fp16-training" rel="nofollow">docs</a>), since that is where you define
which ZeRO stages you want to enable and how to configure them. You will find the explanation for each parameter in the
DeepSpeed docs.`,dj,Ma,_v=`This section has to be configured exclusively via DeepSpeed configuration - the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> provides
no equivalent command line arguments.`,Tj,ua,Bv=`Note: currently DeepSpeed doesn’t validate parameter names, so if you misspell any, it’ll use the default setting for
the parameter that got misspelled. You can watch the DeepSpeed engine start up log messages to see what values it is
going to use.`,wj,mu,Jj,L,Ft,Qr,ra,qf,fu,Zv="ZeRO-2 Config",Uj,ca,xv="The following is an example of configuration for ZeRO stage 2:",mj,ha,fj,ya,qv="<strong>Performance tuning:</strong>",Ij,ja,kv=`<li>enabling <code>offload_optimizer</code> should reduce GPU RAM usage (it requires <code>&quot;stage&quot;: 2</code>)</li> <li><code>&quot;overlap_comm&quot;: true</code> trades off increased GPU RAM usage to lower all-reduce latency. <code>overlap_comm</code> uses 4.5x
the <code>allgather_bucket_size</code> and <code>reduce_bucket_size</code> values. So if they are set to 5e8, this requires a 9GB
footprint (<code>5e8 x 2Bytes x 2 x 4.5</code>). Therefore, if you have a GPU with 8GB or less RAM, to avoid getting
OOM-errors you will need to reduce those parameters to about <code>2e8</code>, which would require 3.6GB. You will want to do
the same on larger capacity GPU as well, if you’re starting to hit OOM.</li> <li>when reducing these buffers you’re trading communication speed to avail more GPU RAM. The smaller the buffer size is,
the slower the communication gets, and the more GPU RAM will be available to other tasks. So if a bigger batch size is
important, getting a slightly slower training time could be a good trade.</li>`,Cj,da,Sv="Additionally, <code>deepspeed==0.4.4</code> added a new option <code>round_robin_gradients</code> which you can enable with:",vj,Ta,bj,wa,$v="This is a stage 2 optimization for CPU offloading that parallelizes gradient copying to CPU memory among ranks by fine-grained gradient partitioning. Performance benefit grows with gradient accumulation steps (more copying between optimizer steps) or GPU count (increased parallelism).",Aj,Iu,gj,F,Pt,Vr,Ja,kf,Cu,Nv="ZeRO-3 Config",_j,Ua,zv="The following is an example of configuration for ZeRO stage 3:",Bj,ma,Zj,fa,Ev=`If you are getting OOMs, because your model or activations don’t fit into the GPU memory and you have unutilized CPU
memory offloading the optimizer states and parameters to CPU memory with <code>&quot;device&quot;: &quot;cpu&quot;</code> may solve this limitation.
If you don’t want to offload to CPU memory, use <code>none</code> instead of <code>cpu</code> for the <code>device</code> entry. Offloading to
NVMe is discussed further down.`,xj,Ia,Gv=`Pinned memory is enabled with <code>pin_memory</code> set to <code>true</code>. This feature can improve the throughput at the cost of
making less memory available to other processes. Pinned memory is set aside to the specific process that requested it
and its typically accessed much faster than normal CPU memory.`,qj,Ca,Wv="<strong>Performance tuning:</strong>",kj,va,Rv="<li><code>stage3_max_live_parameters</code>: <code>1e9</code></li> <li><code>stage3_max_reuse_distance</code>: <code>1e9</code></li>",Sj,ba,Xv=`If hitting OOM reduce <code>stage3_max_live_parameters</code> and <code>stage3_max_reuse_distance</code>. They should have minimal impact
on performance unless you are doing activation checkpointing. <code>1e9</code> would consume ~2GB. The memory is shared by
<code>stage3_max_live_parameters</code> and <code>stage3_max_reuse_distance</code>, so it’s not additive, it’s just 2GB total.`,$j,Aa,Hv=`<code>stage3_max_live_parameters</code> is the upper limit on how many full parameters you want to keep on the GPU at any given
time. “reuse distance” is a metric we are using to figure out when will a parameter be used again in the future, and we
use the <code>stage3_max_reuse_distance</code> to decide whether to throw away the parameter or to keep it. If a parameter is
going to be used again in near future (less than <code>stage3_max_reuse_distance</code>) then we keep it to reduce communication
overhead. This is super helpful when you have activation checkpointing enabled, where we do a forward recompute and
backward passes a single layer granularity and want to keep the parameter in the forward recompute till the backward`,Nj,ga,Qv="The following configuration values depend on the model’s hidden size:",zj,_a,Vv="<li><code>reduce_bucket_size</code>: <code>hidden_size*hidden_size</code></li> <li><code>stage3_prefetch_bucket_size</code>: <code>0.9 * hidden_size * hidden_size</code></li> <li><code>stage3_param_persistence_threshold</code>: <code>10 * hidden_size</code></li>",Ej,Ba,Yv=`therefore set these values to <code>auto</code> and the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> will automatically assign the recommended
values. But, of course, feel free to set these explicitly as well.`,Gj,Za,Lv=`<code>stage3_gather_16bit_weights_on_model_save</code> enables model fp16 weights consolidation when model gets saved. With large
models and multiple GPUs this is an expensive operation both in terms of memory and speed. It’s currently required if
you plan to resume the training. Watch out for future updates that will remove this limitation and make things more
flexible.`,Wj,xa,Fv=`If you’re migrating from ZeRO-2 configuration note that <code>allgather_partitions</code>, <code>allgather_bucket_size</code> and
<code>reduce_scatter</code> configuration parameters are not used in ZeRO-3. If you keep these in the config file they will just
be ignored.`,Rj,qa,Pv="<li><code>sub_group_size</code>: <code>1e9</code></li>",Xj,ka,Dv=`<code>sub_group_size</code> controls the granularity in which parameters are updated during optimizer steps. Parameters are
grouped into buckets of <code>sub_group_size</code> and each buckets is updated one at a time. When used with NVMe offload in
ZeRO-Infinity, <code>sub_group_size</code> therefore controls the granularity in which model states are moved in and out of CPU
memory from NVMe during the optimizer step. This prevents running out of CPU memory for extremely large models.`,Hj,Sa,Ov=`You can leave <code>sub_group_size</code> to its default value of <em>1e9</em> when not using NVMe offload. You may want to change its
default value in the following cases:`,Qj,$a,Kv=`<li>Running into OOM during optimizer step: Reduce <code>sub_group_size</code> to reduce memory utilization of temporary buffers</li> <li>Optimizer Step is taking a long time: Increase <code>sub_group_size</code> to improve bandwidth utilization as a result of
the increased data buffers.</li>`,Vj,P,Dt,Yr,Na,Sf,vu,t1="ZeRO-0 Config",Yj,za,e1="Note that we’re listing Stage 0 and 1 last since they are rarely used.",Lj,Ea,s1="Stage 0 is disabling all types of sharding and just using DeepSpeed as DDP. You can turn it on with:",Fj,Ga,Pj,Wa,l1="This will essentially disable ZeRO without you needing to change anything else.",Dj,D,Ot,Lr,Ra,$f,bu,a1="ZeRO-1 Config",Oj,Xa,n1="Stage 1 is Stage 2 minus gradient sharding. You can always try it to speed things a tiny bit to only shard the optimizer states with:",Kj,Ha,td,Au,ed,O,Kt,Fr,Qa,Nf,gu,p1="NVMe Support",sd,Va,o1=`ZeRO-Infinity allows for training incredibly large models by extending GPU and CPU memory with NVMe memory. Thanks to
smart partitioning and tiling algorithms each GPU needs to send and receive very small amounts of data during
offloading so modern NVMe proved to be fit to allow for an even larger total memory pool available to your training
process. ZeRO-Infinity requires ZeRO-3 enabled.`,ld,Ya,i1="The following configuration example enables NVMe to offload both optimizer states and the params:",ad,La,nd,Fa,M1=`You can choose to offload both optimizer states and params to NVMe, or just one of them or none. For example, if you
have copious amounts of CPU memory available, by all means offload to CPU memory only as it’d be faster (hint:
<em>“device”: “cpu”</em>).`,pd,Pa,u1='Here is the full documentation for offloading <a href="https://www.deepspeed.ai/docs/config-json/#optimizer-offloading" rel="nofollow">optimizer states</a> and <a href="https://www.deepspeed.ai/docs/config-json/#parameter-offloading" rel="nofollow">parameters</a>.',od,Da,r1=`Make sure that your <code>nvme_path</code> is actually an NVMe, since it will work with the normal hard drive or SSD, but it’ll
be much much slower. The fast scalable training was designed with modern NVMe transfer speeds in mind (as of this
writing one can have ~3.5GB/s read, ~3GB/s write peak speeds).`,id,Oa,c1=`In order to figure out the optimal <code>aio</code> configuration block you must run a benchmark on your target setup, as
<a href="https://github.com/microsoft/DeepSpeed/issues/998" rel="nofollow">explained here</a>.`,Md,_u,ud,K,te,Pr,Ka,zf,Bu,h1="ZeRO-2 vs ZeRO-3 Performance",rd,tn,y1=`ZeRO-3 is likely to be slower than ZeRO-2 if everything else is configured the same because the former has to gather
model weights in addition to what ZeRO-2 does. If ZeRO-2 meets your needs and you don’t need to scale beyond a few GPUs
then you may choose to stick to it. It’s important to understand that ZeRO-3 enables a much higher scalability capacity
at a cost of speed.`,cd,en,j1="It’s possible to adjust ZeRO-3 configuration to make it perform closer to ZeRO-2:",hd,sn,d1="<li>set <code>stage3_param_persistence_threshold</code> to a very large number - larger than the largest parameter, e.g., <code>6 * hidden_size * hidden_size</code>. This will keep the parameters on the GPUs.</li> <li>turn off <code>offload_params</code> since ZeRO-2 doesn’t have that option.</li>",yd,ln,T1=`The performance will likely improve significantly with just <code>offload_params</code> turned off, even if you don’t change
<code>stage3_param_persistence_threshold</code>. Of course, these changes will impact the size of the model you can train. So
these help you to trade scalability for speed depending on your needs.`,jd,Zu,dd,tt,ee,Dr,an,Ef,xu,w1="ZeRO-2 Example",Td,nn,J1="Here is a full ZeRO-2 auto-configuration file <code>ds_config_zero2.json</code>:",wd,pn,Jd,on,U1=`Here is a full ZeRO-2 all-enabled manually set configuration file. It is here mainly for you to see what the typical
values look like, but we highly recommend using the one with multiple <code>auto</code> settings in it.`,Ud,Mn,md,qu,fd,et,se,Or,un,Gf,ku,m1="ZeRO-3 Example",Id,rn,f1="Here is a full ZeRO-3 auto-configuration file <code>ds_config_zero3.json</code>:",Cd,cn,vd,hn,I1=`Here is a full ZeRO-3 all-enabled manually set configuration file. It is here mainly for you to see what the typical
values look like, but we highly recommend using the one with multiple <code>auto</code> settings in it.`,bd,yn,Ad,st,le,Kr,jn,Wf,Su,C1="How to Choose Which ZeRO Stage and Offloads To Use For Best Performance",gd,dn,v1="So now you know there are all these different stages. How to decide which of them to use? This section will attempt to address this question.",_d,Tn,b1="In general the following applies:",Bd,wn,A1="<li>Speed-wise (left is faster than right)</li>",Zd,Jn,g1="Stage 0 (DDP) > Stage 1 > Stage 2 > Stage 2 + offload > Stage 3 > Stage 3 + offloads",xd,Un,_1="<li>GPU Memory usage-wise (right is more GPU memory efficient than left)</li>",qd,mn,B1="Stage 0 (DDP) < Stage 1 < Stage 2 < Stage 2 + offload < Stage 3 < Stage 3 + offloads",kd,fn,Z1="So when you want to get the fastest execution while fitting into minimal number of GPUs, here is the process you could follow. We start with the fastest approach and if running into GPU OOM we then go to the next slower approach, but which will use less GPU memory. And so on and so forth.",Sd,In,x1="First of all set batch size to 1 (you can always use gradient accumulation for any desired effective batch size).",$d,Cn,q1="<li><p>Enable <code>--gradient_checkpointing 1</code> (HF Trainer) or directly <code>model.gradient_checkpointing_enable()</code> - if OOM then</p></li> <li><p>Try ZeRO stage 2 first. if OOM then</p></li> <li><p>Try ZeRO stage 2 + <code>offload_optimizer</code> - if OOM then</p></li> <li><p>Switch to ZeRO stage 3 - if OOM then</p></li> <li><p>Enable <code>offload_param</code> to <code>cpu</code> - if OOM then</p></li> <li><p>Enable <code>offload_optimizer</code> to <code>cpu</code> - if OOM then</p></li> <li><p>If you still can’t fit a batch size of 1 first check various default values and lower them if you can. For example, if you use <code>generate</code> and you don’t use a wide search beam make it narrower as it’d take a lot of memory.</p></li> <li><p>Definitely use mixed half-precision over fp32 - so bf16 on Ampere and higher GPUs and fp16 on older gpu architectures.</p></li> <li><p>If you still OOM you could add more hardware or enable ZeRO-Infinity - that is switch offloads <code>offload_param</code> and  <code>offload_optimizer</code> to <code>nvme</code>. You need to make sure it’s a very fast nvme. As an anecdote I was able to infer BLOOM-176B on a tiny GPU using ZeRO-Infinity except it was extremely slow. But it worked!</p></li>",Nd,vn,k1="You can, of course, work through these steps in reverse by starting with the most GPU memory efficient config and then going backwards. Or try bi-secting it.",zd,bn,S1="Once you have your batch size 1 not leading to OOM, measure your effective throughput.",Ed,An,$1="Next try to increase the batch size to as large as you can, since the higher the batch size the more efficient the GPUs are as they perform the best when matrices they multiply are huge.",Gd,gn,N1="Now the performance optimization game starts. You can turn off some offload features or step down in ZeRO stages and increase/decrease batch size and again measure your effective throughput. Rinse and repeat until satisfied.",Wd,_n,z1="Don’t spend forever on it, but if you’re about to start a 3 months training - do spend a few days on it to find the most effective throughput-wise setup. So that your training cost will be the lowest and you will finish training faster. In the current crazy-paced ML world, if it takes you an extra month to train something you are likely to miss a golden opportunity. Of course, this is only me sharing an observation and in no way I’m trying to rush you. Before beginning to train BLOOM-176B I spent 2 days on this process and was able to increase throughput from 90 to 150 TFLOPs! This effort saved us more than one month of training time.",Rd,Bn,E1='These notes were written primarily for the training mode, but they should mostly apply for inference as well. For example, during inference Gradient Checkpointing is a no-op since it is only useful during training. Additionally, we found out that if you are doing a multi-GPU inference and not using <a href="https://www.deepspeed.ai/tutorials/inference-tutorial/" rel="nofollow">DeepSpeed-Inference</a>, <a href="https://huggingface.co/blog/bloom-inference-pytorch-scripts" rel="nofollow">Accelerate</a> should provide a superior performance.',Xd,Zn,G1="Other quick related performance notes:",Hd,xn,W1='<li>if you are training something from scratch always try to have tensors with shapes that are divisible by 16 (e.g. hidden size). For batch size try divisible by 2 at least. There are <a href="https://developer.nvidia.com/blog/optimizing-gpu-performance-tensor-cores/" rel="nofollow">wave and tile quanitization</a> divisibility that is hardware-specific if you want to squeeze even higher performance from your GPUs.</li>',Qd,lt,ae,tc,qn,Rf,$u,R1="Activation Checkpointing or Gradient Checkpointing",Vd,kn,X1="Activation checkpointing and gradient checkpointing are two distinct terms that refer to the same methodology. It’s very confusing but this is how it is.",Yd,Sn,H1="Gradient checkpointing allows one to trade speed for GPU memory, which either allows one to overcome a GPU OOM, or increase their batch size, which often leads to a better performance.",Ld,$n,Q1="HF Transformers models don’t know anything about DeepSpeed’s activation checkpointing, so if you try to enable that feature in the DeepSpeed config file, nothing will happen.",Fd,Nn,V1="Therefore you have two ways to take advantage of this very beneficial feature:",Pd,zn,Y1='<li>If you want to use a HF Transformers models you can do <code>model.gradient_checkpointing_enable()</code> or use <code>--gradient_checkpointing</code> in the HF Trainer, which will automatically enable this for you. <code>torch.utils.checkpoint</code> is used there.</li> <li>If you write your own model and you want to use DeepSpeed’s activation checkpointing you can use the <a href="https://deepspeed.readthedocs.io/en/latest/activation-checkpointing.html" rel="nofollow">API prescribed there</a>. You can also take the HF Transformers modeling code and replace <code>torch.utils.checkpoint</code> with the DeepSpeed’s API. The latter is more flexible since it allows you to offload the forward activations to the CPU memory instead of recalculating them.</li>',Dd,at,ne,ec,En,Xf,Nu,L1="Optimizer and Scheduler",Od,Gn,F1=`As long as you don’t enable <code>offload_optimizer</code> you can mix and match DeepSpeed and HuggingFace schedulers and
optimizers, with the exception of using the combination of HuggingFace scheduler and DeepSpeed optimizer:`,Kd,Wn,P1=`| Combos       | HF Scheduler | DS Scheduler |
| HF Optimizer | Yes          | Yes          |
| DS Optimizer | No           | Yes          |`,tT,Rn,D1=`It is possible to use a non-DeepSpeed optimizer when <code>offload_optimizer</code> is enabled, as long as it has both CPU and
GPU implementation (except LAMB).`,eT,zu,sT,nt,pe,sc,Xn,Hf,Eu,O1="Optimizer",lT,Hn,K1=`DeepSpeed’s main optimizers are Adam, AdamW, OneBitAdam, and Lamb. These have been thoroughly tested with ZeRO and are
thus recommended to be used. It, however, can import other optimizers from <code>torch</code>. The full documentation is <a href="https://www.deepspeed.ai/docs/config-json/#optimizer-parameters" rel="nofollow">here</a>.`,aT,Qn,tb=`If you don’t configure the <code>optimizer</code> entry in the configuration file, the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> will
automatically set it to <code>AdamW</code> and will use the supplied values or the defaults for the following command line
arguments: <code>--learning_rate</code>, <code>--adam_beta1</code>, <code>--adam_beta2</code>, <code>--adam_epsilon</code> and <code>--weight_decay</code>.`,nT,Vn,eb="Here is an example of the auto-configured <code>optimizer</code> entry for <code>AdamW</code>:",pT,Yn,oT,Ln,sb=`Note that the command line arguments will set the values in the configuration file. This is so that there is one
definitive source of the values and to avoid hard to find errors when for example, the learning rate is set to
different values in different places. Command line rules. The values that get overridden are:`,iT,Fn,lb="<li><code>lr</code> with the value of <code>--learning_rate</code></li> <li><code>betas</code> with the value of <code>--adam_beta1 --adam_beta2</code></li> <li><code>eps</code> with the value of <code>--adam_epsilon</code></li> <li><code>weight_decay</code> with the value of <code>--weight_decay</code></li>",MT,Pn,ab="Therefore please remember to tune the shared hyperparameters on the command line.",uT,Dn,nb="You can also set the values explicitly:",rT,On,cT,Kn,pb=`But then you’re on your own synchronizing the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> command line arguments and the DeepSpeed
configuration.`,hT,tp,ob="If you want to use another optimizer which is not listed above, you will have to add to the top level configuration.",yT,ep,jT,sp,ib="Similarly to <code>AdamW</code>, you can configure other officially supported optimizers. Just remember that those may have different config values. e.g. for Adam you will want <code>weight_decay</code> around <code>0.01</code>.",dT,lp,Mb="Additionally, offload works the best when it’s used with Deepspeed’s CPU Adam optimizer. If you want to use a different optimizer with offload, since <code>deepspeed==0.8.3</code> you need to also add:",TT,ap,wT,np,ub="to the top level configuration.",JT,Gu,UT,pt,oe,lc,pp,Qf,Wu,rb="Scheduler",mT,op,cb=`DeepSpeed supports <code>LRRangeTest</code>, <code>OneCycle</code>, <code>WarmupLR</code> and <code>WarmupDecayLR</code> learning rate schedulers. The full
documentation is <a href="https://www.deepspeed.ai/docs/config-json/#scheduler-parameters" rel="nofollow">here</a>.`,fT,ip,hb="Here is where the schedulers overlap between 🤗 Transformers and DeepSpeed:",IT,Mp,yb=`<li><code>WarmupLR</code> via <code>--lr_scheduler_type constant_with_warmup</code></li> <li><code>WarmupDecayLR</code> via <code>--lr_scheduler_type linear</code>. This is also the default value for <code>--lr_scheduler_type</code>,
therefore, if you don’t configure the scheduler this is scheduler that will get configured by default.</li>`,CT,up,jb=`If you don’t configure the <code>scheduler</code> entry in the configuration file, the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> will use
the values of <code>--lr_scheduler_type</code>, <code>--learning_rate</code> and <code>--warmup_steps</code> or <code>--warmup_ratio</code> to configure a
🤗 Transformers version of it.`,vT,rp,db="Here is an example of the auto-configured <code>scheduler</code> entry for <code>WarmupLR</code>:",bT,cp,AT,hp,Tb=`Since <em>“auto”</em> is used the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> arguments will set the correct values in the configuration
file. This is so that there is one definitive source of the values and to avoid hard to find errors when, for example,
the learning rate is set to different values in different places. Command line rules. The values that get set are:`,gT,yp,wb=`<li><code>warmup_min_lr</code> with the value of <code>0</code>.</li> <li><code>warmup_max_lr</code> with the value of <code>--learning_rate</code>.</li> <li><code>warmup_num_steps</code> with the value of <code>--warmup_steps</code> if provided. Otherwise will use <code>--warmup_ratio</code>
multiplied by the number of training steps and rounded up.</li> <li><code>total_num_steps</code> with either the value of <code>--max_steps</code> or if it is not provided, derived automatically at run
time based on the environment and the size of the dataset and other command line arguments (needed for
<code>WarmupDecayLR</code>).</li>`,_T,jp,Jb="You can, of course, take over any or all of the configuration values and set those yourself:",BT,dp,ZT,Tp,Ub=`But then you’re on your own synchronizing the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> command line arguments and the DeepSpeed
configuration.`,xT,wp,mb="For example, for <code>WarmupDecayLR</code>, you can use the following entry:",qT,Jp,kT,Up,fb="and <code>total_num_steps</code>, <code>warmup_max_lr</code>, <code>warmup_num_steps</code> and <code>total_num_steps</code> will be set at loading time.",ST,Ru,$T,ot,ie,ac,mp,Vf,Xu,Ib="fp32 Precision",NT,fp,Cb="Deepspeed supports the full fp32 and the fp16 mixed precision.",zT,Ip,vb=`Because of the much reduced memory needs and faster speed one gets with the fp16 mixed precision, the only time you
will want to not use it is when the model you’re using doesn’t behave well under this training mode. Typically this
happens when the model wasn’t pretrained in the fp16 mixed precision (e.g. often this happens with bf16-pretrained
models). Such models may overflow or underflow leading to <code>NaN</code> loss. If this is your case then you will want to use
the full fp32 mode, by explicitly disabling the otherwise default fp16 mixed precision mode with:`,ET,Cp,GT,vp,bb=`If you’re using the Ampere-architecture based GPU, pytorch version 1.7 and higher will automatically switch to using
the much more efficient tf32 format for some operations, but the results will still be in fp32. For details and
benchmarks, please, see <a href="https://pytorch.org/docs/stable/notes/cuda.html#tensorfloat-32-tf32-on-ampere-devices" rel="nofollow">TensorFloat-32(TF32) on Ampere devices</a>. The document includes
instructions on how to disable this automatic conversion if for some reason you prefer not to use it.`,WT,bp,Ab="With the 🤗 Trainer you can use <code>--tf32</code> to enable it, or disable it with <code>--tf32 0</code> or <code>--no_tf32</code>. By default the PyTorch default is used.",RT,Hu,XT,it,Me,nc,Ap,Yf,Qu,gb="Automatic Mixed Precision",HT,gp,_b="You can use automatic mixed precision with either a pytorch-like AMP way or the apex-like way:",QT,Mt,ue,pc,_p,Lf,Vu,Bb="fp16",VT,Bp,Zb="To configure pytorch AMP-like mode with fp16 (float16) set:",YT,Zp,LT,xp,xb=`and the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> will automatically enable or disable it based on the value of
<code>args.fp16_backend</code>. The rest of config values are up to you.`,FT,qp,qb="This mode gets enabled when <code>--fp16 --fp16_backend amp</code> or <code>--fp16_full_eval</code> command line args are passed.",PT,kp,kb="You can also enable/disable this mode explicitly:",DT,Sp,OT,$p,Sb=`But then you’re on your own synchronizing the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> command line arguments and the DeepSpeed
configuration.`,KT,Np,$b='Here is the <a href="https://www.deepspeed.ai/docs/config-json/#fp16-training-options" rel="nofollow">documentation</a>.',tw,ut,re,oc,zp,Ff,Yu,Nb="bf16",ew,Ep,zb="If bf16 (bfloat16) is desired instead of fp16 then the following configuration section is to be used:",sw,Gp,lw,Wp,Eb="bf16 has the same dynamic range as fp32 and thus doesn’t require loss scaling.",aw,Rp,Gb="This mode gets enabled when <code>--bf16</code> or <code>--bf16_full_eval</code> command line args are passed.",nw,Xp,Wb="You can also enable/disable this mode explicitly:",pw,Hp,ow,ce,iw,rt,he,ic,Qp,Pf,Lu,Rb="NCCL Collectives",Mw,Vp,Xb="There is the <code>dtype</code> of the training regime and there is a separate <code>dtype</code> that is used for communication collectives like various reduction and gathering/scattering operations.",uw,Yp,Hb="All gather/scatter ops are performed in the same <code>dtype</code> the data is in, so if you’re using bf16 training regime it gets gathered in bf16 - gathering is a non-lossy operation.",rw,Lp,Qb="Various reduce operations can be quite lossy, for example when gradients are averaged across multiple-gpus, if the communications are done in fp16 or bf16 the outcome is likely be lossy - since when one ads multiple numbers in low precision the result isn’t exact. More so with bf16 as it has a lower precision than fp16. Often fp16 is good enough as the loss is minimal when averaging grads which are typically very small. Therefore, by default for half precision training fp16 is used as the default for reduction operations. But you have full control over this functionality and if you choose you can add a small overhead and ensure that reductions will be using fp32 as the accumulation dtype and only when the result is ready it’ll get downcast to the half precision <code>dtype</code> you’re training in.",cw,Fp,Vb="In order to override the default you simply add a new configuration entry:",hw,Pp,yw,Dp,Yb="The valid values as of this writing are “fp16”, “bfp16”, “fp32”.",jw,Op,Lb="note: stage zero 3 had a bug with regards to bf16 comm dtype that was fixed in <code>deepspeed==0.8.1</code>",dw,ct,ye,Mc,Kp,Df,Fu,Fb="apex",Tw,to,Pb="To configure apex AMP-like mode set:",ww,eo,Jw,so,Db=`and the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> will automatically configure it based on the values of <code>args.fp16_backend</code> and
<code>args.fp16_opt_level</code>.`,Uw,lo,Ob="This mode gets enabled when <code>--fp16 --fp16_backend apex --fp16_opt_level 01</code> command line args are passed.",mw,ao,Kb="You can also configure this mode explicitly:",fw,no,Iw,po,tA=`But then you’re on your own synchronizing the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> command line arguments and the DeepSpeed
configuration.`,Cw,oo,eA='Here is the <a href="https://www.deepspeed.ai/docs/config-json/#automatic-mixed-precision-amp-training-options" rel="nofollow">documentation</a>.',vw,Pu,bw,ht,je,uc,io,Of,Du,sA="Batch Size",Aw,Mo,lA="To configure batch size, use:",gw,uo,_w,ro,aA=`and the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> will automatically set <code>train_micro_batch_size_per_gpu</code> to the value of
<code>args.per_device_train_batch_size</code> and <code>train_batch_size</code> to <code>args.world_size * args.per_device_train_batch_size * args.gradient_accumulation_steps</code>.`,Bw,co,nA="You can also set the values explicitly:",Zw,ho,xw,yo,pA=`But then you’re on your own synchronizing the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> command line arguments and the DeepSpeed
configuration.`,qw,Ou,kw,yt,de,rc,jo,Kf,Ku,oA="Gradient Accumulation",Sw,To,iA="To configure gradient accumulation set:",$w,wo,Nw,Jo,MA='and the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> will automatically set it to the value of <code>args.gradient_accumulation_steps</code>.',zw,Uo,uA="You can also set the value explicitly:",Ew,mo,Gw,fo,rA=`But then you’re on your own synchronizing the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> command line arguments and the DeepSpeed
configuration.`,Ww,tr,Rw,jt,Te,cc,Io,tI,er,cA="Gradient Clipping",Xw,Co,hA="To configure gradient gradient clipping set:",Hw,vo,Qw,bo,yA='and the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> will automatically set it to the value of <code>args.max_grad_norm</code>.',Vw,Ao,jA="You can also set the value explicitly:",Yw,go,Lw,_o,dA=`But then you’re on your own synchronizing the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> command line arguments and the DeepSpeed
configuration.`,Fw,sr,Pw,dt,we,hc,Bo,eI,lr,TA="Getting The Model Weights Out",Dw,Zo,wA=`As long as you continue training and resuming using DeepSpeed you don’t need to worry about anything. DeepSpeed stores
fp32 master weights in its custom checkpoint optimizer files, which are <code>global_step*/*optim_states.pt</code> (this is glob
pattern), and are saved under the normal checkpoint.`,Ow,xo,JA="<strong>FP16 Weights:</strong>",Kw,qo,UA=`When a model is saved under ZeRO-2, you end up having the normal <code>pytorch_model.bin</code> file with the model weights, but
they are only the fp16 version of the weights.`,tJ,ko,mA=`Under ZeRO-3, things are much more complicated, since the model weights are partitioned out over multiple GPUs,
therefore <code>&quot;stage3_gather_16bit_weights_on_model_save&quot;: true</code> is required to get the <code>Trainer</code> to save the fp16
version of the weights. If this setting is <code>False</code> <code>pytorch_model.bin</code> won’t be created. This is because by default DeepSpeed’s <code>state_dict</code> contains a placeholder and not the real weights. If we were to save this <code>state_dict</code> it won’t be possible to load it back.`,eJ,So,sJ,$o,fA="<strong>FP32 Weights:</strong>",lJ,No,IA=`While the fp16 weights are fine for resuming training, if you finished finetuning your model and want to upload it to
the <a href="https://huggingface.co/models" rel="nofollow">models hub</a> or pass it to someone else you most likely will want to get the fp32
weights. This ideally shouldn’t be done during training since this is a process that requires a lot of memory, and
therefore best to be performed offline after the training is complete. But if desired and you have plenty of free CPU
memory it can be done in the same training script. The following sections will discuss both approaches.`,aJ,zo,CA="<strong>Live FP32 Weights Recovery:</strong>",nJ,Eo,vA="This approach may not work if you model is large and you have little free CPU memory left, at the end of the training.",pJ,Go,bA="If you have saved at least one checkpoint, and you want to use the latest one, you can do the following:",oJ,Wo,iJ,Ro,AA=`If you’re using the <code>--load_best_model_at_end</code> class:<em>~transformers.TrainingArguments</em> argument (to track the best
checkpoint), then you can finish the training by first saving the final model explicitly and then do the same as above:`,MJ,Xo,uJ,Je,rJ,Ho,gA=`Of course, you don’t have to use class:<em>~transformers.Trainer</em> and you can adjust the examples above to your own
trainer.`,cJ,Qo,_A=`If for some reason you want more refinement, you can also extract the fp32 <code>state_dict</code> of the weights and apply
these yourself as is shown in the following example:`,hJ,Vo,yJ,Yo,BA="<strong>Offline FP32 Weights Recovery:</strong>",jJ,Lo,ZA=`DeepSpeed creates a special conversion script <code>zero_to_fp32.py</code> which it places in the top-level of the checkpoint
folder. Using this script you can extract the weights at any point. The script is standalone and you no longer need to
have the configuration file or a <code>Trainer</code> to do the extraction.`,dJ,Fo,xA="Let’s say your checkpoint folder looks like this:",TJ,Po,wJ,Do,qA=`In this example there is just one DeepSpeed checkpoint sub-folder <em>global_step1</em>. Therefore to reconstruct the fp32
weights just run:`,JJ,Oo,UJ,Ko,kA="This is it. <code>pytorch_model.bin</code> will now contain the full fp32 model weights consolidated from multiple GPUs.",mJ,ti,SA="The script will automatically be able to handle either a ZeRO-2 or ZeRO-3 checkpoint.",fJ,ei,$A="<code>python zero_to_fp32.py -h</code> will give you usage details.",IJ,si,NA=`The script will auto-discover the deepspeed sub-folder using the contents of the file <code>latest</code>, which in the current
example will contain <code>global_step1</code>.`,CJ,li,zA="Note: currently the script requires 2x general RAM of the final fp32 model weights.",vJ,Tt,Ue,yc,ai,sI,ar,EA="ZeRO-3 and Infinity Nuances",bJ,ni,GA="ZeRO-3 is quite different from ZeRO-2 because of its param sharding feature.",AJ,pi,WA="ZeRO-Infinity further extends ZeRO-3 to support NVMe memory and multiple other speed and scalability improvements.",gJ,oi,RA=`While all the efforts were made for things to just work without needing any special changes to your models, in certain
circumstances you may find the following information to be needed.`,_J,wt,me,jc,ii,lI,nr,XA="Constructing Massive Models",BJ,Mi,HA=`DeepSpeed/ZeRO-3 can handle models with Trillions of parameters which may not fit onto the existing RAM. In such cases,
but also if you want the initialization to happen much faster, initialize the model using <em>deepspeed.zero.Init()</em>
context manager (which is also a function decorator), like so:`,ZJ,ui,xJ,ri,QA="As you can see this gives you a randomly initialized model.",qJ,ci,VA=`If you want to use a pretrained model, <code>model_class.from_pretrained</code> will activate this feature as long as
<code>is_deepspeed_zero3_enabled()</code> returns <code>True</code>, which currently is setup by the
<a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> object if the passed DeepSpeed configuration file contains ZeRO-3 config
section. Thus you must create the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> object <strong>before</strong> calling
<code>from_pretrained</code>. Here is an example of a possible sequence:`,kJ,hi,SJ,yi,YA=`If you’re using the official example scripts and your command line arguments include <code>--deepspeed ds_config.json</code>
with ZeRO-3 config enabled, then everything is already done for you, since this is how example scripts are written.`,$J,ji,LA="Note: If the fp16 weights of the model can’t fit onto the memory of a single GPU this feature must be used.",NJ,di,FA='For full details on this method and other related features please refer to <a href="https://deepspeed.readthedocs.io/en/latest/zero3.html#constructing-massive-models" rel="nofollow">Constructing Massive Models</a>.',zJ,Ti,PA=`Also when loading fp16-pretrained models, you will want to tell <code>from_pretrained</code> to use
<code>torch_dtype=torch.float16</code>. For details, please, see <a href="#from_pretrained-torch-dtype">from_pretrained-torch-dtype</a>.`,EJ,Jt,fe,dc,wi,aI,pr,DA="Gathering Parameters",GJ,Ji,OA=`Under ZeRO-3 on multiple GPUs no single GPU has all the parameters unless it’s the parameters for the currently
executing layer. So if you need to access all parameters from all layers at once there is a specific method to do it.
Most likely you won’t need it, but if you do please refer to <a href="https://deepspeed.readthedocs.io/en/latest/zero3.html#manual-parameter-coordination" rel="nofollow">Gathering Parameters</a>`,WJ,Ui,KA=`We do however use it internally in several places, one such example is when loading pretrained model weights in
<code>from_pretrained</code>. We load one layer at a time and immediately partition it to all participating GPUs, as for very
large models it won’t be possible to load it on one GPU and then spread it out to multiple GPUs, due to memory
limitations.`,RJ,mi,tg="Also under ZeRO-3, if you write your own code and run into a model parameter weight that looks like:",XJ,fi,HJ,Ii,eg=`stress on <code>tensor([1.])</code>, or if you get an error where it says the parameter is of size <code>1</code>, instead of some much
larger multi-dimensional shape, this means that the parameter is partitioned and what you see is a ZeRO-3 placeholder.`,QJ,or,VJ,Ut,Ie,Tc,Ci,nI,ir,sg="ZeRO Inference",YJ,vi,lg=`ZeRO Inference uses the same config as ZeRO-3 Training. You just don’t need the optimizer and scheduler sections. In
fact you can leave these in the config file if you want to share the same one with the training. They will just be
ignored.`,LJ,bi,ag='Otherwise you just need to pass the usual <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> arguments. For example:',FJ,Ai,PJ,gi,ng=`The only important thing is that you need to use a ZeRO-3 configuration, since ZeRO-2 provides no benefit whatsoever
for the inference as only ZeRO-3 performs sharding of parameters, whereas ZeRO-1 shards gradients and optimizer states.`,DJ,_i,pg="Here is an example of running <code>run_translation.py</code> under DeepSpeed deploying all available GPUs:",OJ,Bi,KJ,Zi,og=`Since for inference there is no need for additional large memory used by the optimizer states and the gradients you
should be able to fit much larger batches and/or sequence length onto the same hardware.`,tU,xi,ig=`Additionally DeepSpeed is currently developing a related product called Deepspeed-Inference which has no relationship
to the ZeRO technology, but instead uses tensor parallelism to scale models that can’t fit onto a single GPU. This is a
work in progress and we will provide the integration once that product is complete.`,eU,mt,Ce,wc,qi,pI,Mr,Mg="Memory Requirements",sU,ki,ug="Since Deepspeed ZeRO can offload memory to CPU (and NVMe) the framework provides utils that allow one to tell how much CPU and GPU memory will be needed depending on the number of GPUs being used.",lU,Si,rg="Let’s estimate how much memory is needed to finetune “bigscience/T0_3B” on a single GPU:",aU,$i,nU,Ni,cg="So you can fit it on a single 80GB GPU and no CPU offload, or a tiny 8GB GPU but then need ~60GB of CPU memory. (Remember this is just the memory for params, optimizer states and gradients - you will need a bit more memory for cuda kernels, activations and temps.)",pU,zi,hg="Then it’s a tradeoff of cost vs speed. It’ll be cheaper to buy/rent a smaller GPU (or less GPUs since you can use multiple GPUs with Deepspeed ZeRO. But then it’ll be slower, so even if you don’t care about how fast something will be done, the slowdown has a direct impact on the duration of using the GPU and thus bigger cost. So experiment and compare which works the best.",oU,Ei,yg="If you have enough GPU memory make sure to disable the CPU/NVMe offload as it’ll make everything faster.",iU,Gi,jg="For example, let’s repeat the same for 2 GPUs:",MU,Wi,uU,Ri,dg="So here you’d want 2x 32GB GPUs or higher without offloading to CPU.",rU,Xi,Tg='For full information please see <a href="https://deepspeed.readthedocs.io/en/latest/memory.html" rel="nofollow">memory estimators</a>.',cU,ft,ve,Jc,Hi,oI,ur,wg="Filing Issues",hU,Qi,Jg="Here is how to file an issue so that we could quickly get to the bottom of the issue and help you to unblock your work.",yU,Vi,Ug="In your report please always include:",jU,C,rr,mg="<p>the full Deepspeed config file in the report</p>",iI,cr,fg=`<p>either the command line arguments if you were using the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> or
<a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> arguments if you were scripting the Trainer setup yourself. Please do not
dump the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> as it has dozens of entries that are irrelevant.</p>`,MI,Yi,hr,Ig="Output of:",uI,Li,rI,yr,Cg=`<p>If possible include a link to a Google Colab notebook that we can reproduce the problem with. You can use this
<a href="https://github.com/stas00/porting/blob/master/transformers/deepspeed/DeepSpeed_on_colab_CLI.ipynb" rel="nofollow">notebook</a> as
a starting point.</p>`,cI,jr,vg="<p>Unless it’s impossible please always use a standard dataset that we can use and not something custom.</p>",hI,dr,bg='<p>If possible try to use one of the existing <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch" rel="nofollow">examples</a> to reproduce the problem with.</p>',dU,Fi,Ag="Things to consider:",TU,Pi,gg=`<li><p>Deepspeed is often not the cause of the problem.</p> <p>Some of the filed issues proved to be Deepspeed-unrelated. That is once Deepspeed was removed from the setup, the
problem was still there.</p> <p>Therefore, if it’s not absolutely obvious it’s a DeepSpeed-related problem, as in you can see that there is an
exception and you can see that DeepSpeed modules are involved, first re-test your setup without DeepSpeed in it.
And only if the problem persists then do mentioned Deepspeed and supply all the required details.</p></li> <li><p>If it’s clear to you that the issue is in the DeepSpeed core and not the integration part, please file the Issue
directly with <a href="https://github.com/microsoft/DeepSpeed/" rel="nofollow">Deepspeed</a>. If you aren’t sure, please do not worry,
either Issue tracker will do, we will figure it out once you posted it and redirect you to another Issue tracker if
need be.</p></li>`,wU,It,be,Uc,Di,yI,Tr,_g="Troubleshooting",JU,Ct,Ae,mc,Oi,jI,wr,Bg="the <code>deepspeed</code> process gets killed at startup without a traceback",UU,Ki,Zg=`If the <code>deepspeed</code> process gets killed at launch time without a traceback, that usually means that the program tried
to allocate more CPU memory than your system has or your process is allowed to allocate and the OS kernel killed that
process. This is because your configuration file most likely has either <code>offload_optimizer</code> or <code>offload_param</code> or
both configured to offload to <code>cpu</code>. If you have NVMe, experiment with offloading to NVMe if you’re running under
ZeRO-3. Here is how you can <a href="https://deepspeed.readthedocs.io/en/latest/memory.html" rel="nofollow">estimate how much memory is needed for a specific model</a>.`,mU,vt,ge,fc,tM,dI,Jr,xg="training and/or eval/predict loss is <code>NaN</code>",fU,eM,qg="This often happens when one takes a model pre-trained in bf16 mixed precision mode and tries to use it under fp16 (with or without mixed precision). Most models trained on TPU and often the ones released by Google are in this category (e.g. almost all t5-based models). Here the solution is to either use fp32 or bf16 if your hardware supports it (TPU, Ampere GPUs or newer).",IU,sM,kg="The other problem may have to do with using fp16. When you configure this section:",CU,lM,vU,aM,Sg="and you see in your log that Deepspeed reports <code>OVERFLOW!</code> as follows:",bU,nM,AU,pM,$g="that means that the Deepspeed loss scaler can’t figure out a scaling co-efficient that overcomes loss overflow.",gU,oM,Ng="(the log was massaged to be more readable here.)",_U,iM,zg="In this case you usually need to raise the value of <code>initial_scale_power</code>. Setting it to <code>&quot;initial_scale_power&quot;: 32</code> will typically resolve the problem.",BU,bt,_e,Ic,MM,TI,Ur,Eg="Notes",ZU,uM,Gg=`<li>DeepSpeed works with the PyTorch <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> but not TF <code>TFTrainer</code>.</li> <li>While DeepSpeed has a pip installable PyPI package, it is highly recommended that it gets installed from <a href="https://github.com/microsoft/deepspeed#installation" rel="nofollow">source</a> to best match your hardware and also if you need to enable
certain features, like 1-bit Adam, which aren’t available in the pypi distribution.</li> <li>You don’t have to use the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> to use DeepSpeed with 🤗 Transformers - you can use any model
with your own trainer, and you will have to adapt the latter according to <a href="https://www.deepspeed.ai/getting-started/#writing-deepspeed-models" rel="nofollow">the DeepSpeed integration instructions</a>.</li>`,xU,At,Be,Cc,rM,wI,mr,Wg="Non-Trainer Deepspeed Integration",qU,cM,Rg=`The <a href="/docs/transformers/v4.33.3/en/main_classes/deepspeed#transformers.integrations.HfDeepSpeedConfig">HfDeepSpeedConfig</a> is used to integrate Deepspeed into the 🤗 Transformers core
functionality, when <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> is not used. The only thing that it does is handling Deepspeed ZeRO-3 param gathering and automatically splitting the model onto multiple gpus during <code>from_pretrained</code> call. Everything else you have to do by yourself.`,kU,hM,Xg='When using <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> everything is automatically taken care of.',SU,yM,Hg=`When not using <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a>, to efficiently deploy DeepSpeed ZeRO-3, you must instantiate the
<a href="/docs/transformers/v4.33.3/en/main_classes/deepspeed#transformers.integrations.HfDeepSpeedConfig">HfDeepSpeedConfig</a> object before instantiating the model and keep that object alive.`,$U,jM,Qg="If you’re using Deepspeed ZeRO-1 or ZeRO-2 you don’t need to use <code>HfDeepSpeedConfig</code> at all.",NU,dM,Vg="For example for a pretrained model:",zU,TM,EU,wM,Yg="or for non-pretrained model:",GU,JM,WU,UM,Lg='Please note that if you’re not using the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> integration, you’re completely on your own. Basically follow the documentation on the <a href="https://www.deepspeed.ai/" rel="nofollow">Deepspeed</a> website. Also you have to configure explicitly the config file - you can’t use <code>&quot;auto&quot;</code> values and you will have to put real values instead.',RU,gt,Ze,vc,mM,JI,fr,Fg="HfDeepSpeedConfig",XU,g,fM,UI,Ir,Pg="This object contains a DeepSpeed configuration dictionary and can be quickly queried for things like zero stage.",mI,Cr,Dg=`A <code>weakref</code> of this object is stored in the module’s globals to be able to access the config from areas where
things like the Trainer object is not available (e.g. <code>from_pretrained</code> and <code>_get_resized_embeddings</code>). Therefore
it’s important that this object remains alive while the program is still running.`,fI,vr,Og=`<a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> uses the <code>HfTrainerDeepSpeedConfig</code> subclass instead. That subclass has logic to sync the configuration
with values of <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> by replacing special placeholder values: <code>&quot;auto&quot;</code>. Without this special logic
the DeepSpeed configuration is not modified in any way.`,HU,_t,xe,bc,IM,II,br,Kg="Custom DeepSpeed ZeRO Inference",QU,CM,t_='Here is an example of how one could do DeepSpeed ZeRO Inference without using <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> when one can’t fit a model onto a single GPU. The solution includes using additional GPUs or/and offloading GPU memory to CPU memory.',VU,vM,e_="The important nuance to understand here is that the way ZeRO is designed you can process different inputs on different GPUs in parallel.",YU,bM,s_="The example has copious notes and is self-documenting.",LU,AM,l_="Make sure to:",FU,gM,a_="<li>disable CPU offload if you have enough GPU memory (since it slows things down)</li> <li>enable bf16 if you own an Ampere or a newer GPU to make things faster. If you don’t have that hardware you may enable fp16 as long as you don’t use any model that was pre-trained in bf16 mixed precision (such as most t5 models). These usually overflow in fp16 and you will see garbage as output.</li>",PU,_M,DU,BM,n_="Let’s save it as <code>t0.py</code> and run it:",OU,ZM,KU,xM,p_="This was a very basic example and you will want to adapt it to your needs.",tm,Bt,qe,Ac,qM,CI,Ar,o_="<code>generate</code> nuances",em,kM,i_="When using multiple GPUs with ZeRO Stage-3, one has to synchronize the GPUs by calling <code>generate(..., synced_gpus=True)</code>. If this is not done if one GPU finished generating before other GPUs the whole system will hang as the rest of the GPUs will not be able to received the shard of weights from the GPU that stopped generating.",sm,SM,M_="Starting from <code>transformers&gt;=4.28</code>, if <code>synced_gpus</code> isn’t explicitly specified, it’ll be set to <code>True</code> automatically if these conditions are detected. But you can still override the value of <code>synced_gpus</code> if need to.",lm,Zt,ke,gc,$M,vI,gr,u_="Testing Deepspeed Integration",am,NM,r_="If you submit a PR that involves DeepSpeed integration please note our CircleCI PR CI setup has no GPUs, so we only run tests requiring gpus on a different CI nightly. Therefore if you get a green CI report in your PR it doesn’t mean DeepSpeed tests pass.",nm,zM,c_="To run DeepSpeed tests, please run at least:",pm,EM,om,GM,h_="If you changed any of the modeling or pytorch examples code, then run the model zoo tests as well. The following will run all DeepSpeed tests:",im,WM,Mm,xt,Se,_c,RM,bI,_r,y_="Main DeepSpeed Resources",um,XM,j_='<li><a href="https://github.com/microsoft/deepspeed" rel="nofollow">Project’s github</a></li> <li><a href="https://www.deepspeed.ai/getting-started/" rel="nofollow">Usage docs</a></li> <li><a href="https://deepspeed.readthedocs.io/en/latest/index.html" rel="nofollow">API docs</a></li> <li><a href="https://www.microsoft.com/en-us/research/search/?q=deepspeed" rel="nofollow">Blog posts</a></li>',rm,HM,d_="Papers:",cm,QM,T_='<li><a href="https://arxiv.org/abs/1910.02054" rel="nofollow">ZeRO: Memory Optimizations Toward Training Trillion Parameter Models</a></li> <li><a href="https://arxiv.org/abs/2101.06840" rel="nofollow">ZeRO-Offload: Democratizing Billion-Scale Model Training</a></li> <li><a href="https://arxiv.org/abs/2104.07857" rel="nofollow">ZeRO-Infinity: Breaking the GPU Memory Wall for Extreme Scale Deep Learning</a></li>',hm,VM,w_=`Finally, please, remember that, HuggingFace <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> only integrates DeepSpeed, therefore if you
have any problems or questions with regards to DeepSpeed usage, please, file an issue with <a href="https://github.com/microsoft/DeepSpeed/issues" rel="nofollow">DeepSpeed GitHub</a>.`,ym,Bc,jm;return x=new J({}),Pe=new J({}),De=new J({}),Ke=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRlZXBzcGVlZA==",highlighted:"pip install deepspeed"}}),es=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyU1QmRlZXBzcGVlZCU1RA==",highlighted:"pip install transformers[deepspeed]"}}),ps=new w({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZtaWNyb3NvZnQlMkZEZWVwU3BlZWQlMkYlMEFjZCUyMERlZXBTcGVlZCUwQXJtJTIwLXJmJTIwYnVpbGQlMEFUT1JDSF9DVURBX0FSQ0hfTElTVCUzRCUyMjguNiUyMiUyMERTX0JVSUxEX0NQVV9BREFNJTNEMSUyMERTX0JVSUxEX1VUSUxTJTNEMSUyMHBpcCUyMGluc3RhbGwlMjAuJTIwJTVDJTBBLS1nbG9iYWwtb3B0aW9uJTNEJTIyYnVpbGRfZXh0JTIyJTIwLS1nbG9iYWwtb3B0aW9uJTNEJTIyLWo4JTIyJTIwLS1uby1jYWNoZSUyMC12JTIwJTVDJTBBLS1kaXNhYmxlLXBpcC12ZXJzaW9uLWNoZWNrJTIwMiUzRSUyNjElMjAlN0MlMjB0ZWUlMjBidWlsZC5sb2c=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/microsoft/DeepSpeed/
<span class="hljs-built_in">cd</span> DeepSpeed
<span class="hljs-built_in">rm</span> -rf build
TORCH_CUDA_ARCH_LIST=<span class="hljs-string">&quot;8.6&quot;</span> DS_BUILD_CPU_ADAM=1 DS_BUILD_UTILS=1 pip install . \\
--global-option=<span class="hljs-string">&quot;build_ext&quot;</span> --global-option=<span class="hljs-string">&quot;-j8&quot;</span> --no-cache -v \\
--disable-pip-version-check 2&gt;&amp;1 | <span class="hljs-built_in">tee</span> build.log`}}),Ms=new w({props:{code:"Q1VEQV9WSVNJQkxFX0RFVklDRVMlM0QwJTIwcHl0aG9uJTIwLWMlMjAlMjJpbXBvcnQlMjB0b3JjaCUzQiUyMHByaW50KHRvcmNoLmN1ZGEuZ2V0X2RldmljZV9jYXBhYmlsaXR5KCkpJTIy",highlighted:'CUDA_VISIBLE_DEVICES=0 python -c <span class="hljs-string">&quot;import torch; print(torch.cuda.get_device_capability())&quot;</span>'}}),cs=new w({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZtaWNyb3NvZnQlMkZEZWVwU3BlZWQlMkYlMEFjZCUyMERlZXBTcGVlZCUwQXJtJTIwLXJmJTIwYnVpbGQlMEFUT1JDSF9DVURBX0FSQ0hfTElTVCUzRCUyMjguNiUyMiUyMERTX0JVSUxEX0NQVV9BREFNJTNEMSUyMERTX0JVSUxEX1VUSUxTJTNEMSUyMCU1QyUwQXB5dGhvbiUyMHNldHVwLnB5JTIwYnVpbGRfZXh0JTIwLWo4JTIwYmRpc3Rfd2hlZWw=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/microsoft/DeepSpeed/
<span class="hljs-built_in">cd</span> DeepSpeed
<span class="hljs-built_in">rm</span> -rf build
TORCH_CUDA_ARCH_LIST=<span class="hljs-string">&quot;8.6&quot;</span> DS_BUILD_CPU_ADAM=1 DS_BUILD_UTILS=1 \\
python setup.py build_ext -j8 bdist_wheel`}}),Ts=new w({props:{code:"cHl0aG9uJTIwLWMlMjAlMjJpbXBvcnQlMjB0b3JjaCUzQiUyMHByaW50KHRvcmNoLmN1ZGEuZ2V0X2FyY2hfbGlzdCgpKSUyMg==",highlighted:'python -c <span class="hljs-string">&quot;import torch; print(torch.cuda.get_arch_list())&quot;</span>'}}),Js=new w({props:{code:"Q1VEQV9WSVNJQkxFX0RFVklDRVMlM0QwJTIwcHl0aG9uJTIwLWMlMjAlMjJpbXBvcnQlMjB0b3JjaCUzQiUyMCU1QyUwQXByaW50KHRvcmNoLmN1ZGEuZ2V0X2RldmljZV9wcm9wZXJ0aWVzKHRvcmNoLmRldmljZSgnY3VkYScpKSklMjI=",highlighted:`CUDA_VISIBLE_DEVICES=0 python -c <span class="hljs-string">&quot;import torch; \\
print(torch.cuda.get_device_properties(torch.device(&#x27;cuda&#x27;)))&quot;</span>`}}),ms=new w({props:{code:"X0N1ZGFEZXZpY2VQcm9wZXJ0aWVzKG5hbWUlM0QnR2VGb3JjZSUyMFJUWCUyMDMwOTAnJTJDJTIwbWFqb3IlM0Q4JTJDJTIwbWlub3IlM0Q2JTJDJTIwdG90YWxfbWVtb3J5JTNEMjQyNjhNQiUyQyUyMG11bHRpX3Byb2Nlc3Nvcl9jb3VudCUzRDgyKQ==",highlighted:'_CudaDeviceProperties(name=<span class="hljs-string">&#x27;GeForce RTX 3090&#x27;</span>, major=8, minor=6, total_memory=24268MB, multi_processor_count=82)'}}),vs=new J({}),gs=new w({props:{code:"dG9yY2guZGlzdHJpYnV0ZWQucnVuJTIwLS1ucHJvY19wZXJfbm9kZSUzRDIlMjB5b3VyX3Byb2dyYW0ucHklMjAlM0Nub3JtYWwlMjBjbCUyMGFyZ3MlM0UlMjAtLWRlZXBzcGVlZCUyMGRzX2NvbmZpZy5qc29u",highlighted:"torch.distributed.run --nproc_per_node=2 your_program.py &lt;normal cl args&gt; --deepspeed ds_config.json"}}),Bs=new w({props:{code:"ZGVlcHNwZWVkJTIwLS1udW1fZ3B1cyUzRDIlMjB5b3VyX3Byb2dyYW0ucHklMjAlM0Nub3JtYWwlMjBjbCUyMGFyZ3MlM0UlMjAtLWRlZXBzcGVlZCUyMGRzX2NvbmZpZy5qc29u",highlighted:"deepspeed --num_gpus=2 your_program.py &lt;normal cl args&gt; --deepspeed ds_config.json"}}),ks=new w({props:{code:"ZGVlcHNwZWVkJTIwZXhhbXBsZXMlMkZweXRvcmNoJTJGdHJhbnNsYXRpb24lMkZydW5fdHJhbnNsYXRpb24ucHklMjAlNUMlMEEtLWRlZXBzcGVlZCUyMHRlc3RzJTJGZGVlcHNwZWVkJTJGZHNfY29uZmlnX3plcm8zLmpzb24lMjAlNUMlMEEtLW1vZGVsX25hbWVfb3JfcGF0aCUyMHQ1LXNtYWxsJTIwLS1wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjAxJTIwJTVDJTBBLS1vdXRwdXRfZGlyJTIwb3V0cHV0X2RpciUyMC0tb3ZlcndyaXRlX291dHB1dF9kaXIlMjAtLWZwMTYlMjAlNUMlMEEtLWRvX3RyYWluJTIwLS1tYXhfdHJhaW5fc2FtcGxlcyUyMDUwMCUyMC0tbnVtX3RyYWluX2Vwb2NocyUyMDElMjAlNUMlMEEtLWRhdGFzZXRfbmFtZSUyMHdtdDE2JTIwLS1kYXRhc2V0X2NvbmZpZyUyMCUyMnJvLWVuJTIyJTIwJTVDJTBBLS1zb3VyY2VfbGFuZyUyMGVuJTIwLS10YXJnZXRfbGFuZyUyMHJv",highlighted:`deepspeed examples/pytorch/translation/run_translation.py \\
--deepspeed tests/deepspeed/ds_config_zero3.json \\
--model_name_or_path t5-small --per_device_train_batch_size 1 \\
--output_dir output_dir --overwrite_output_dir --fp16 \\
--do_train --max_train_samples 500 --num_train_epochs 1 \\
--dataset_name wmt16 --dataset_config <span class="hljs-string">&quot;ro-en&quot;</span> \\
--source_lang en --target_lang ro`}}),Ns=new J({}),Es=new w({props:{code:"ZGVlcHNwZWVkJTIwLS1udW1fZ3B1cyUzRDElMjBleGFtcGxlcyUyRnB5dG9yY2glMkZ0cmFuc2xhdGlvbiUyRnJ1bl90cmFuc2xhdGlvbi5weSUyMCU1QyUwQS0tZGVlcHNwZWVkJTIwdGVzdHMlMkZkZWVwc3BlZWQlMkZkc19jb25maWdfemVybzIuanNvbiUyMCU1QyUwQS0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwdDUtc21hbGwlMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDElMjAlNUMlMEEtLW91dHB1dF9kaXIlMjBvdXRwdXRfZGlyJTIwLS1vdmVyd3JpdGVfb3V0cHV0X2RpciUyMC0tZnAxNiUyMCU1QyUwQS0tZG9fdHJhaW4lMjAtLW1heF90cmFpbl9zYW1wbGVzJTIwNTAwJTIwLS1udW1fdHJhaW5fZXBvY2hzJTIwMSUyMCU1QyUwQS0tZGF0YXNldF9uYW1lJTIwd210MTYlMjAtLWRhdGFzZXRfY29uZmlnJTIwJTIycm8tZW4lMjIlMjAlNUMlMEEtLXNvdXJjZV9sYW5nJTIwZW4lMjAtLXRhcmdldF9sYW5nJTIwcm8=",highlighted:`deepspeed --num_gpus=1 examples/pytorch/translation/run_translation.py \\
--deepspeed tests/deepspeed/ds_config_zero2.json \\
--model_name_or_path t5-small --per_device_train_batch_size 1 \\
--output_dir output_dir --overwrite_output_dir --fp16 \\
--do_train --max_train_samples 500 --num_train_epochs 1 \\
--dataset_name wmt16 --dataset_config <span class="hljs-string">&quot;ro-en&quot;</span> \\
--source_lang en --target_lang ro`}}),Hs=new w({props:{code:"JTdCJTBBJTIwJTIwJTIyemVyb19vcHRpbWl6YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjJzdGFnZSUyMiUzQSUyMDIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjJvZmZsb2FkX29wdGltaXplciUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRldmljZSUyMiUzQSUyMCUyMmNwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBpbl9tZW1vcnklMjIlM0ElMjB0cnVlJTBBJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIyYWxsZ2F0aGVyX3BhcnRpdGlvbnMlMjIlM0ElMjB0cnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIyYWxsZ2F0aGVyX2J1Y2tldF9zaXplJTIyJTNBJTIwMmU4JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIycmVkdWNlX3NjYXR0ZXIlMjIlM0ElMjB0cnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIycmVkdWNlX2J1Y2tldF9zaXplJTIyJTNBJTIwMmU4JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIyb3ZlcmxhcF9jb21tJTIyJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMmNvbnRpZ3VvdXNfZ3JhZGllbnRzJTIyJTNBJTIwdHJ1ZSUwQSUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
     <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
     <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
         <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
         <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
     <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
     <span class="hljs-attr">&quot;allgather_partitions&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
     <span class="hljs-attr">&quot;allgather_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2e8</span><span class="hljs-punctuation">,</span>
     <span class="hljs-attr">&quot;reduce_scatter&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
     <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2e8</span><span class="hljs-punctuation">,</span>
     <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
     <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`}}),Fs=new w({props:{code:"ZGVlcHNwZWVkJTIwLS1pbmNsdWRlJTIwbG9jYWxob3N0JTNBMSUyMGV4YW1wbGVzJTJGcHl0b3JjaCUyRnRyYW5zbGF0aW9uJTJGcnVuX3RyYW5zbGF0aW9uLnB5JTIwLi4u",highlighted:"deepspeed --include localhost:1 examples/pytorch/translation/run_translation.py ..."}}),Ps=new J({}),Ks=new J({}),el=new w({props:{code:"cHl0aG9uJTIwLW0lMjB0b3JjaC5kaXN0cmlidXRlZC5ydW4lMjAtLW5wcm9jX3Blcl9ub2RlJTNEOCUyMC0tbm5vZGUlM0QyJTIwLS1ub2RlX3JhbmslM0QwJTIwLS1tYXN0ZXJfYWRkciUzRGhvc3RuYW1lMSUyMCU1QyUwQS0tbWFzdGVyX3BvcnQlM0Q5OTAxJTIweW91cl9wcm9ncmFtLnB5JTIwJTNDbm9ybWFsJTIwY2wlMjBhcmdzJTNFJTIwLS1kZWVwc3BlZWQlMjBkc19jb25maWcuanNvbg==",highlighted:`python -m torch.distributed.run --nproc_per_node=8 --nnode=2 --node_rank=0 --master_addr=hostname1 \\
--master_port=9901 your_program.py &lt;normal cl args&gt; --deepspeed ds_config.json`}}),al=new J({}),pl=new w({props:{code:"aG9zdG5hbWUxJTIwc2xvdHMlM0Q4JTBBaG9zdG5hbWUyJTIwc2xvdHMlM0Q4",highlighted:`hostname1 <span class="hljs-attribute">slots</span>=8
hostname2 <span class="hljs-attribute">slots</span>=8`}}),il=new w({props:{code:"ZGVlcHNwZWVkJTIwLS1udW1fZ3B1cyUyMDglMjAtLW51bV9ub2RlcyUyMDIlMjAtLWhvc3RmaWxlJTIwaG9zdGZpbGUlMjAtLW1hc3Rlcl9hZGRyJTIwaG9zdG5hbWUxJTIwLS1tYXN0ZXJfcG9ydCUzRDk5MDElMjAlNUMlMEF5b3VyX3Byb2dyYW0ucHklMjAlM0Nub3JtYWwlMjBjbCUyMGFyZ3MlM0UlMjAtLWRlZXBzcGVlZCUyMGRzX2NvbmZpZy5qc29u",highlighted:`deepspeed --num_gpus 8 --num_nodes 2 --hostfile hostfile --master_addr hostname1 --master_port=9901 \\
your_program.py &lt;normal cl args&gt; --deepspeed ds_config.json`}}),rl=new J({}),hl=new w({props:{code:"JTIzU0JBVENIJTIwLS1qb2ItbmFtZSUzRHRlc3Qtbm9kZXMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBuYW1lJTBBJTIzU0JBVENIJTIwLS1ub2RlcyUzRDIlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBub2RlcyUwQSUyM1NCQVRDSCUyMC0tbnRhc2tzLXBlci1ub2RlJTNEMSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMGNydWNpYWwlMjAtJTIwb25seSUyMDElMjB0YXNrJTIwcGVyJTIwZGlzdCUyMHBlciUyMG5vZGUhJTBBJTIzU0JBVENIJTIwLS1jcHVzLXBlci10YXNrJTNEMTAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBudW1iZXIlMjBvZiUyMGNvcmVzJTIwcGVyJTIwdGFza3MlMEElMjNTQkFUQ0glMjAtLWdyZXMlM0RncHUlM0E4JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbnVtYmVyJTIwb2YlMjBncHVzJTBBJTIzU0JBVENIJTIwLS10aW1lJTIwMjAlM0EwMCUzQTAwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbWF4aW11bSUyMGV4ZWN1dGlvbiUyMHRpbWUlMjAoSEglM0FNTSUzQVNTKSUwQSUyM1NCQVRDSCUyMC0tb3V0cHV0JTNEJTI1eC0lMjVqLm91dCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMG91dHB1dCUyMGZpbGUlMjBuYW1lJTBBJTBBZXhwb3J0JTIwR1BVU19QRVJfTk9ERSUzRDglMEFleHBvcnQlMjBNQVNURVJfQUREUiUzRCUyNChzY29udHJvbCUyMHNob3clMjBob3N0bmFtZXMlMjAlMjRTTFVSTV9KT0JfTk9ERUxJU1QlMjAlN0MlMjBoZWFkJTIwLW4lMjAxKSUwQWV4cG9ydCUyME1BU1RFUl9QT1JUJTNEOTkwMSUwQSUwQXNydW4lMjAtLWpvYmlkJTIwJTI0U0xVUk1fSk9CSUQlMjBiYXNoJTIwLWMlMjAncHl0aG9uJTIwLW0lMjB0b3JjaC5kaXN0cmlidXRlZC5ydW4lMjAlNUMlMEElMjAtLW5wcm9jX3Blcl9ub2RlJTIwJTI0R1BVU19QRVJfTk9ERSUyMC0tbm5vZGVzJTIwJTI0U0xVUk1fTk5PREVTJTIwLS1ub2RlX3JhbmslMjAlMjRTTFVSTV9QUk9DSUQlMjAlNUMlMEElMjAtLW1hc3Rlcl9hZGRyJTIwJTI0TUFTVEVSX0FERFIlMjAtLW1hc3Rlcl9wb3J0JTIwJTI0TUFTVEVSX1BPUlQlMjAlNUMlMEF5b3VyX3Byb2dyYW0ucHklMjAlM0Nub3JtYWwlMjBjbCUyMGFyZ3MlM0UlMjAtLWRlZXBzcGVlZCUyMGRzX2NvbmZpZy5qc29uJw==",highlighted:`<span class="hljs-comment">#SBATCH --job-name=test-nodes        # name</span>
<span class="hljs-comment">#SBATCH --nodes=2                    # nodes</span>
<span class="hljs-comment">#SBATCH --ntasks-per-node=1          # crucial - only 1 task per dist per node!</span>
<span class="hljs-comment">#SBATCH --cpus-per-task=10           # number of cores per tasks</span>
<span class="hljs-comment">#SBATCH --gres=gpu:8                 # number of gpus</span>
<span class="hljs-comment">#SBATCH --time 20:00:00              # maximum execution time (HH:MM:SS)</span>
<span class="hljs-comment">#SBATCH --output=%x-%j.out           # output file name</span>

<span class="hljs-built_in">export</span> GPUS_PER_NODE=8
<span class="hljs-built_in">export</span> MASTER_ADDR=$(scontrol show hostnames <span class="hljs-variable">$SLURM_JOB_NODELIST</span> | <span class="hljs-built_in">head</span> -n 1)
<span class="hljs-built_in">export</span> MASTER_PORT=9901

srun --jobid <span class="hljs-variable">$SLURM_JOBID</span> bash -c <span class="hljs-string">&#x27;python -m torch.distributed.run \\
 --nproc_per_node $GPUS_PER_NODE --nnodes $SLURM_NNODES --node_rank $SLURM_PROCID \\
 --master_addr $MASTER_ADDR --master_port $MASTER_PORT \\
your_program.py &lt;normal cl args&gt; --deepspeed ds_config.json&#x27;</span>`}}),jl=new w({props:{code:"c2JhdGNoJTIwbGF1bmNoLnNsdXJt",highlighted:"sbatch launch.slurm"}}),Tl=new J({}),Jl=new w({props:{code:"JTdCJTBBJTIwJTIwJTIyY2hlY2twb2ludCUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnVzZV9ub2RlX2xvY2FsX3N0b3JhZ2UlMjIlM0ElMjB0cnVlJTBBJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;checkpoint&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;use_node_local_storage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`}}),ml=new J({}),Cl=new w({props:{code:"JTIzJTIwRGVlcFNwZWVkJTIwcmVxdWlyZXMlMjBhJTIwZGlzdHJpYnV0ZWQlMjBlbnZpcm9ubWVudCUyMGV2ZW4lMjB3aGVuJTIwb25seSUyMG9uZSUyMHByb2Nlc3MlMjBpcyUyMHVzZWQuJTBBJTIzJTIwVGhpcyUyMGVtdWxhdGVzJTIwYSUyMGxhdW5jaGVyJTIwaW4lMjB0aGUlMjBub3RlYm9vayUwQWltcG9ydCUyMG9zJTBBJTBBb3MuZW52aXJvbiU1QiUyMk1BU1RFUl9BRERSJTIyJTVEJTIwJTNEJTIwJTIybG9jYWxob3N0JTIyJTBBb3MuZW52aXJvbiU1QiUyMk1BU1RFUl9QT1JUJTIyJTVEJTIwJTNEJTIwJTIyOTk5NCUyMiUyMCUyMCUyMyUyMG1vZGlmeSUyMGlmJTIwUnVudGltZUVycm9yJTNBJTIwQWRkcmVzcyUyMGFscmVhZHklMjBpbiUyMHVzZSUwQW9zLmVudmlyb24lNUIlMjJSQU5LJTIyJTVEJTIwJTNEJTIwJTIyMCUyMiUwQW9zLmVudmlyb24lNUIlMjJMT0NBTF9SQU5LJTIyJTVEJTIwJTNEJTIwJTIyMCUyMiUwQW9zLmVudmlyb24lNUIlMjJXT1JMRF9TSVpFJTIyJTVEJTIwJTNEJTIwJTIyMSUyMiUwQSUwQSUyMyUyME5vdyUyMHByb2NlZWQlMjBhcyUyMG5vcm1hbCUyQyUyMHBsdXMlMjBwYXNzJTIwdGhlJTIwZGVlcHNwZWVkJTIwY29uZmlnJTIwZmlsZSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyguLi4lMkMlMjBkZWVwc3BlZWQlM0QlMjJkc19jb25maWdfemVybzMuanNvbiUyMiklMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciguLi4pJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-comment"># DeepSpeed requires a distributed environment even when only one process is used.</span>
<span class="hljs-comment"># This emulates a launcher in the notebook</span>
<span class="hljs-keyword">import</span> os

os.environ[<span class="hljs-string">&quot;MASTER_ADDR&quot;</span>] = <span class="hljs-string">&quot;localhost&quot;</span>
os.environ[<span class="hljs-string">&quot;MASTER_PORT&quot;</span>] = <span class="hljs-string">&quot;9994&quot;</span>  <span class="hljs-comment"># modify if RuntimeError: Address already in use</span>
os.environ[<span class="hljs-string">&quot;RANK&quot;</span>] = <span class="hljs-string">&quot;0&quot;</span>
os.environ[<span class="hljs-string">&quot;LOCAL_RANK&quot;</span>] = <span class="hljs-string">&quot;0&quot;</span>
os.environ[<span class="hljs-string">&quot;WORLD_SIZE&quot;</span>] = <span class="hljs-string">&quot;1&quot;</span>

<span class="hljs-comment"># Now proceed as normal, plus pass the deepspeed config file</span>
training_args = TrainingArguments(..., deepspeed=<span class="hljs-string">&quot;ds_config_zero3.json&quot;</span>)
trainer = Trainer(...)
trainer.train()`}}),gl=new w({props:{code:"JTI1JTI1YmFzaCUwQWNhdCUyMCUzQyUzQydFT1QnJTIwJTNFJTIwZHNfY29uZmlnX3plcm8zLmpzb24lMEElN0IlMEElMjAlMjAlMjAlMjAlMjJmcDE2JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW5hYmxlZCUyMiUzQSUyMCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsb3NzX3NjYWxlJTIyJTNBJTIwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxvc3Nfc2NhbGVfd2luZG93JTIyJTNBJTIwMTAwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmluaXRpYWxfc2NhbGVfcG93ZXIlMjIlM0ElMjAxNiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmh5c3RlcmVzaXMlMjIlM0ElMjAyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWluX2xvc3Nfc2NhbGUlMjIlM0ElMjAxJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTBBJTIwJTIwJTIwJTIwJTIyb3B0aW1pemVyJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMkFkYW1XJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGFyYW1zJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybHIlMjIlM0ElMjAlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYmV0YXMlMjIlM0ElMjAlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZXBzJTIyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMndlaWdodF9kZWNheSUyMiUzQSUyMCUyMmF1dG8lMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMEElMjAlMjAlMjAlMjAlMjJzY2hlZHVsZXIlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyV2FybXVwTFIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwYXJhbXMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ3YXJtdXBfbWluX2xyJTIyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMndhcm11cF9tYXhfbHIlMjIlM0ElMjAlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyd2FybXVwX251bV9zdGVwcyUyMiUzQSUyMCUyMmF1dG8lMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMEElMjAlMjAlMjAlMjAlMjJ6ZXJvX29wdGltaXphdGlvbiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN0YWdlJTIyJTNBJTIwMyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm9mZmxvYWRfb3B0aW1pemVyJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGV2aWNlJTIyJTNBJTIwJTIyY3B1JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGluX21lbW9yeSUyMiUzQSUyMHRydWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJvZmZsb2FkX3BhcmFtJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGV2aWNlJTIyJTNBJTIwJTIyY3B1JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGluX21lbW9yeSUyMiUzQSUyMHRydWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJvdmVybGFwX2NvbW0lMjIlM0ElMjB0cnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGlndW91c19ncmFkaWVudHMlMjIlM0ElMjB0cnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3ViX2dyb3VwX3NpemUlMjIlM0ElMjAxZTklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyZWR1Y2VfYnVja2V0X3NpemUlMjIlM0ElMjAlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3RhZ2UzX3ByZWZldGNoX2J1Y2tldF9zaXplJTIyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN0YWdlM19wYXJhbV9wZXJzaXN0ZW5jZV90aHJlc2hvbGQlMjIlM0ElMjAlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3RhZ2UzX21heF9saXZlX3BhcmFtZXRlcnMlMjIlM0ElMjAxZTklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFnZTNfbWF4X3JldXNlX2Rpc3RhbmNlJTIyJTNBJTIwMWU5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3RhZ2UzX2dhdGhlcl8xNmJpdF93ZWlnaHRzX29uX21vZGVsX3NhdmUlMjIlM0ElMjB0cnVlJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTBBJTIwJTIwJTIwJTIwJTIyZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTIyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmdyYWRpZW50X2NsaXBwaW5nJTIyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnN0ZXBzX3Blcl9wcmludCUyMiUzQSUyMDIwMDAlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFpbl9iYXRjaF9zaXplJTIyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnRyYWluX21pY3JvX2JhdGNoX3NpemVfcGVyX2dwdSUyMiUzQSUyMCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ3YWxsX2Nsb2NrX2JyZWFrZG93biUyMiUzQSUyMGZhbHNlJTBBJTdEJTBBRU9U",highlighted:`%%bash
cat &lt;&lt;<span class="hljs-string">&#x27;EOT&#x27;</span> &gt; ds_config_zero3.json
{
    <span class="hljs-string">&quot;fp16&quot;</span>: {
        <span class="hljs-string">&quot;enabled&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
        <span class="hljs-string">&quot;loss_scale&quot;</span>: <span class="hljs-number">0</span>,
        <span class="hljs-string">&quot;loss_scale_window&quot;</span>: <span class="hljs-number">1000</span>,
        <span class="hljs-string">&quot;initial_scale_power&quot;</span>: <span class="hljs-number">16</span>,
        <span class="hljs-string">&quot;hysteresis&quot;</span>: <span class="hljs-number">2</span>,
        <span class="hljs-string">&quot;min_loss_scale&quot;</span>: <span class="hljs-number">1</span>
    },

    <span class="hljs-string">&quot;optimizer&quot;</span>: {
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;AdamW&quot;</span>,
        <span class="hljs-string">&quot;params&quot;</span>: {
            <span class="hljs-string">&quot;lr&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
            <span class="hljs-string">&quot;betas&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
            <span class="hljs-string">&quot;eps&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
            <span class="hljs-string">&quot;weight_decay&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>
        }
    },

    <span class="hljs-string">&quot;scheduler&quot;</span>: {
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;WarmupLR&quot;</span>,
        <span class="hljs-string">&quot;params&quot;</span>: {
            <span class="hljs-string">&quot;warmup_min_lr&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
            <span class="hljs-string">&quot;warmup_max_lr&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
            <span class="hljs-string">&quot;warmup_num_steps&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>
        }
    },

    <span class="hljs-string">&quot;zero_optimization&quot;</span>: {
        <span class="hljs-string">&quot;stage&quot;</span>: <span class="hljs-number">3</span>,
        <span class="hljs-string">&quot;offload_optimizer&quot;</span>: {
            <span class="hljs-string">&quot;device&quot;</span>: <span class="hljs-string">&quot;cpu&quot;</span>,
            <span class="hljs-string">&quot;pin_memory&quot;</span>: true
        },
        <span class="hljs-string">&quot;offload_param&quot;</span>: {
            <span class="hljs-string">&quot;device&quot;</span>: <span class="hljs-string">&quot;cpu&quot;</span>,
            <span class="hljs-string">&quot;pin_memory&quot;</span>: true
        },
        <span class="hljs-string">&quot;overlap_comm&quot;</span>: true,
        <span class="hljs-string">&quot;contiguous_gradients&quot;</span>: true,
        <span class="hljs-string">&quot;sub_group_size&quot;</span>: <span class="hljs-number">1e9</span>,
        <span class="hljs-string">&quot;reduce_bucket_size&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
        <span class="hljs-string">&quot;stage3_prefetch_bucket_size&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
        <span class="hljs-string">&quot;stage3_param_persistence_threshold&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
        <span class="hljs-string">&quot;stage3_max_live_parameters&quot;</span>: <span class="hljs-number">1e9</span>,
        <span class="hljs-string">&quot;stage3_max_reuse_distance&quot;</span>: <span class="hljs-number">1e9</span>,
        <span class="hljs-string">&quot;stage3_gather_16bit_weights_on_model_save&quot;</span>: true
    },

    <span class="hljs-string">&quot;gradient_accumulation_steps&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
    <span class="hljs-string">&quot;gradient_clipping&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
    <span class="hljs-string">&quot;steps_per_print&quot;</span>: <span class="hljs-number">2000</span>,
    <span class="hljs-string">&quot;train_batch_size&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
    <span class="hljs-string">&quot;train_micro_batch_size_per_gpu&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>,
    <span class="hljs-string">&quot;wall_clock_breakdown&quot;</span>: false
}
EOT`}}),Bl=new w({props:{code:"IWdpdCUyMGNsb25lJTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMlMEEhY2QlMjB0cmFuc2Zvcm1lcnMlM0IlMjBkZWVwc3BlZWQlMjBleGFtcGxlcyUyRnB5dG9yY2glMkZ0cmFuc2xhdGlvbiUyRnJ1bl90cmFuc2xhdGlvbi5weSUyMC4uLg==",highlighted:`!git clone https://github.com/huggingface/transformers
!cd transformers; deepspeed examples/pytorch/translation/run_translation.py ...`}}),xl=new w({props:{code:"JTI1JTI1YmFzaCUwQSUwQWdpdCUyMGNsb25lJTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMlMEFjZCUyMHRyYW5zZm9ybWVycyUwQWRlZXBzcGVlZCUyMGV4YW1wbGVzJTJGcHl0b3JjaCUyRnRyYW5zbGF0aW9uJTJGcnVuX3RyYW5zbGF0aW9uLnB5JTIwLi4u",highlighted:`%%bash

git clone https://github.com/huggingface/transformers
cd transformers
deepspeed examples/pytorch/translation/run_translation.py ...`}}),Sl=new J({}),zl=new w({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZtaWNyb3NvZnQlMkZEZWVwU3BlZWRFeGFtcGxlcyUwQWNkJTIwRGVlcFNwZWVkRXhhbXBsZXMlMEFmaW5kJTIwLiUyMC1uYW1lJTIwJypqc29uJw==",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/microsoft/DeepSpeedExamples
<span class="hljs-built_in">cd</span> DeepSpeedExamples
find . -name <span class="hljs-string">&#x27;*json&#x27;</span>`}}),Gl=new w({props:{code:"Z3JlcCUyMC1pJTIwTGFtYiUyMCUyNChmaW5kJTIwLiUyMC1uYW1lJTIwJypqc29uJyk=",highlighted:'grep -i Lamb $(find . -name <span class="hljs-string">&#x27;*json&#x27;</span>)'}}),Hl=new w({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;fp16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale_window&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1000</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;initial_scale_power&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">16</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hysteresis&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;min_loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;AdamW&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;betas&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;eps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;weight_decay&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WarmupLR&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;warmup_min_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_max_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;allgather_partitions&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;allgather_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2e8</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_scatter&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2e8</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;gradient_accumulation_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;gradient_clipping&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_batch_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_micro_batch_size_per_gpu&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
<span class="hljs-punctuation">}</span>`}}),Vl=new J({}),Fl=new w({props:{code:"VHJhaW5pbmdBcmd1bWVudHMoLi4uJTJDJTIwZGVlcHNwZWVkJTNEJTIyJTJGcGF0aCUyRnRvJTJGZHNfY29uZmlnLmpzb24lMjIp",highlighted:'TrainingArguments(..., deepspeed=<span class="hljs-string">&quot;/path/to/ds_config.json&quot;</span>)'}}),Dl=new w({props:{code:"ZHNfY29uZmlnX2RpY3QlMjAlM0QlMjBkaWN0KHNjaGVkdWxlciUzRHNjaGVkdWxlcl9wYXJhbXMlMkMlMjBvcHRpbWl6ZXIlM0RvcHRpbWl6ZXJfcGFyYW1zKSUwQVRyYWluaW5nQXJndW1lbnRzKC4uLiUyQyUyMGRlZXBzcGVlZCUzRGRzX2NvbmZpZ19kaWN0KQ==",highlighted:`ds_config_dict = <span class="hljs-built_in">dict</span>(scheduler=scheduler_params, optimizer=optimizer_params)
TrainingArguments(..., deepspeed=ds_config_dict)`}}),Ol=new J({}),Yt=new AI({props:{warning:!0,$$slots:{default:[C0]},$$scope:{ctx:qt}}}),pa=new J({}),ra=new J({}),ha=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyemVyb19vcHRpbWl6YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFnZSUyMiUzQSUyMDIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJvZmZsb2FkX29wdGltaXplciUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRldmljZSUyMiUzQSUyMCUyMmNwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBpbl9tZW1vcnklMjIlM0ElMjB0cnVlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYWxsZ2F0aGVyX3BhcnRpdGlvbnMlMjIlM0ElMjB0cnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYWxsZ2F0aGVyX2J1Y2tldF9zaXplJTIyJTNBJTIwNWU4JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyb3ZlcmxhcF9jb21tJTIyJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlZHVjZV9zY2F0dGVyJTIyJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlZHVjZV9idWNrZXRfc2l6ZSUyMiUzQSUyMDVlOCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRpZ3VvdXNfZ3JhZGllbnRzJTIyJTNBJTIwdHJ1ZSUwQSUyMCUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;allgather_partitions&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;allgather_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">5e8</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_scatter&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">5e8</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`}}),Ta=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyemVyb19vcHRpbWl6YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb3VuZF9yb2Jpbl9ncmFkaWVudHMlMjIlM0ElMjB0cnVlJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;round_robin_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`}}),Ja=new J({}),ma=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyemVyb19vcHRpbWl6YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFnZSUyMiUzQSUyMDMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJvZmZsb2FkX29wdGltaXplciUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRldmljZSUyMiUzQSUyMCUyMmNwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBpbl9tZW1vcnklMjIlM0ElMjB0cnVlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyb2ZmbG9hZF9wYXJhbSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRldmljZSUyMiUzQSUyMCUyMmNwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBpbl9tZW1vcnklMjIlM0ElMjB0cnVlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyb3ZlcmxhcF9jb21tJTIyJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRpZ3VvdXNfZ3JhZGllbnRzJTIyJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN1Yl9ncm91cF9zaXplJTIyJTNBJTIwMWU5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycmVkdWNlX2J1Y2tldF9zaXplJTIyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN0YWdlM19wcmVmZXRjaF9idWNrZXRfc2l6ZSUyMiUzQSUyMCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFnZTNfcGFyYW1fcGVyc2lzdGVuY2VfdGhyZXNob2xkJTIyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN0YWdlM19tYXhfbGl2ZV9wYXJhbWV0ZXJzJTIyJTNBJTIwMWU5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3RhZ2UzX21heF9yZXVzZV9kaXN0YW5jZSUyMiUzQSUyMDFlOSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN0YWdlM19nYXRoZXJfMTZiaXRfd2VpZ2h0c19vbl9tb2RlbF9zYXZlJTIyJTNBJTIwdHJ1ZSUwQSUyMCUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_param&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;sub_group_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_prefetch_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_param_persistence_threshold&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_max_live_parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_max_reuse_distance&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_gather_16bit_weights_on_model_save&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`}}),Na=new J({}),Ga=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyemVyb19vcHRpbWl6YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFnZSUyMiUzQSUyMDAlMEElMjAlMjAlMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`}}),Ra=new J({}),Ha=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyemVyb19vcHRpbWl6YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFnZSUyMiUzQSUyMDElMEElMjAlMjAlMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`}}),Qa=new J({}),La=new w({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;nvme&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;nvme_path&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;/local_nvme&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;buffer_count&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">4</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;fast_init&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_param&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;nvme&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;nvme_path&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;/local_nvme&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;buffer_count&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">5</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;buffer_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e8</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;max_in_cpu&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;aio&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;block_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">262144</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;queue_depth&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">32</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;thread_count&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;single_submit&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;overlap_events&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;sub_group_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_prefetch_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_param_persistence_threshold&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_max_live_parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_max_reuse_distance&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_gather_16bit_weights_on_model_save&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
<span class="hljs-punctuation">}</span>`}}),Ka=new J({}),an=new J({}),pn=new w({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;fp16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale_window&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1000</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;initial_scale_power&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">16</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hysteresis&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;min_loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;AdamW&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;betas&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;eps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;weight_decay&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WarmupLR&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;warmup_min_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_max_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;allgather_partitions&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;allgather_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2e8</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_scatter&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2e8</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;gradient_accumulation_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;gradient_clipping&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;steps_per_print&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2000</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_batch_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_micro_batch_size_per_gpu&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;wall_clock_breakdown&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
<span class="hljs-punctuation">}</span>`}}),Mn=new w({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;fp16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale_window&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1000</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;initial_scale_power&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">16</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hysteresis&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;min_loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;AdamW&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3e-5</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;betas&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">0.8</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.999</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;eps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e-8</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;weight_decay&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3e-7</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WarmupLR&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;warmup_min_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_max_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3e-5</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">500</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;allgather_partitions&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;allgather_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2e8</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_scatter&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2e8</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;steps_per_print&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2000</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;wall_clock_breakdown&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
<span class="hljs-punctuation">}</span>`}}),un=new J({}),cn=new w({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;fp16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale_window&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1000</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;initial_scale_power&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">16</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hysteresis&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;min_loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;AdamW&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;betas&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;eps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;weight_decay&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WarmupLR&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;warmup_min_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_max_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_param&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;sub_group_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_prefetch_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_param_persistence_threshold&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_max_live_parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_max_reuse_distance&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_gather_16bit_weights_on_model_save&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;gradient_accumulation_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;gradient_clipping&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;steps_per_print&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2000</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_batch_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_micro_batch_size_per_gpu&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;wall_clock_breakdown&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
<span class="hljs-punctuation">}</span>`}}),yn=new w({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;fp16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale_window&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1000</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;initial_scale_power&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">16</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hysteresis&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;min_loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;AdamW&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3e-5</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;betas&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">0.8</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.999</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;eps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e-8</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;weight_decay&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3e-7</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WarmupLR&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;warmup_min_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_max_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3e-5</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">500</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_param&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;sub_group_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e6</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_prefetch_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.94e6</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_param_persistence_threshold&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e4</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_max_live_parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_max_reuse_distance&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_gather_16bit_weights_on_model_save&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>

    <span class="hljs-attr">&quot;steps_per_print&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2000</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;wall_clock_breakdown&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
<span class="hljs-punctuation">}</span>`}}),jn=new J({}),qn=new J({}),En=new J({}),Xn=new J({}),Yn=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIyb3B0aW1pemVyJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMkFkYW1XJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGFyYW1zJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybHIlMjIlM0ElMjAlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYmV0YXMlMjIlM0ElMjAlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZXBzJTIyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMndlaWdodF9kZWNheSUyMiUzQSUyMCUyMmF1dG8lMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
   <span class="hljs-attr">&quot;optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
       <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;AdamW&quot;</span><span class="hljs-punctuation">,</span>
       <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
         <span class="hljs-attr">&quot;lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
         <span class="hljs-attr">&quot;betas&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
         <span class="hljs-attr">&quot;eps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
         <span class="hljs-attr">&quot;weight_decay&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
       <span class="hljs-punctuation">}</span>
   <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`}}),On=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIyb3B0aW1pemVyJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMkFkYW1XJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGFyYW1zJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybHIlMjIlM0ElMjAwLjAwMSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmJldGFzJTIyJTNBJTIwJTVCMC44JTJDJTIwMC45OTklNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlcHMlMjIlM0ElMjAxZS04JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyd2VpZ2h0X2RlY2F5JTIyJTNBJTIwM2UtNyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
   <span class="hljs-attr">&quot;optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
       <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;AdamW&quot;</span><span class="hljs-punctuation">,</span>
       <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
         <span class="hljs-attr">&quot;lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.001</span><span class="hljs-punctuation">,</span>
         <span class="hljs-attr">&quot;betas&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">0.8</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.999</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
         <span class="hljs-attr">&quot;eps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e-8</span><span class="hljs-punctuation">,</span>
         <span class="hljs-attr">&quot;weight_decay&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3e-7</span>
       <span class="hljs-punctuation">}</span>
   <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`}}),ep=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIyemVyb19hbGxvd191bnRlc3RlZF9vcHRpbWl6ZXIlMjIlM0ElMjB0cnVlJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
   <span class="hljs-attr">&quot;zero_allow_untested_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
<span class="hljs-punctuation">}</span>`}}),ap=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIyemVyb19mb3JjZV9kc19jcHVfb3B0aW1pemVyJTIyJTNBJTIwZmFsc2UlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
   <span class="hljs-attr">&quot;zero_force_ds_cpu_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
<span class="hljs-punctuation">}</span>`}}),pp=new J({}),cp=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIyc2NoZWR1bGVyJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMldhcm11cExSJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGFyYW1zJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyd2FybXVwX21pbl9sciUyMiUzQSUyMCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ3YXJtdXBfbWF4X2xyJTIyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMndhcm11cF9udW1fc3RlcHMlMjIlM0ElMjAlMjJhdXRvJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
   <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
         <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WarmupLR&quot;</span><span class="hljs-punctuation">,</span>
         <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
             <span class="hljs-attr">&quot;warmup_min_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
             <span class="hljs-attr">&quot;warmup_max_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
             <span class="hljs-attr">&quot;warmup_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
         <span class="hljs-punctuation">}</span>
     <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`}}),dp=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIyc2NoZWR1bGVyJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMldhcm11cExSJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGFyYW1zJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyd2FybXVwX21pbl9sciUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ3YXJtdXBfbWF4X2xyJTIyJTNBJTIwMC4wMDElMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ3YXJtdXBfbnVtX3N0ZXBzJTIyJTNBJTIwMTAwMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
   <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
         <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WarmupLR&quot;</span><span class="hljs-punctuation">,</span>
         <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
             <span class="hljs-attr">&quot;warmup_min_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
             <span class="hljs-attr">&quot;warmup_max_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.001</span><span class="hljs-punctuation">,</span>
             <span class="hljs-attr">&quot;warmup_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1000</span>
         <span class="hljs-punctuation">}</span>
     <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`}}),Jp=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIyc2NoZWR1bGVyJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMldhcm11cERlY2F5TFIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwYXJhbXMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsYXN0X2JhdGNoX2l0ZXJhdGlvbiUyMiUzQSUyMC0xJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydG90YWxfbnVtX3N0ZXBzJTIyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMndhcm11cF9taW5fbHIlMjIlM0ElMjAlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyd2FybXVwX21heF9sciUyMiUzQSUyMCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ3YXJtdXBfbnVtX3N0ZXBzJTIyJTNBJTIwJTIyYXV0byUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
   <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
         <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WarmupDecayLR&quot;</span><span class="hljs-punctuation">,</span>
         <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
             <span class="hljs-attr">&quot;last_batch_iteration&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">-1</span><span class="hljs-punctuation">,</span>
             <span class="hljs-attr">&quot;total_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
             <span class="hljs-attr">&quot;warmup_min_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
             <span class="hljs-attr">&quot;warmup_max_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
             <span class="hljs-attr">&quot;warmup_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
         <span class="hljs-punctuation">}</span>
     <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`}}),mp=new J({}),Cp=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyZnAxNiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVuYWJsZWQlMjIlM0ElMjBmYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;fp16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span><span class="hljs-punctuation">,</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`}}),Ap=new J({}),_p=new J({}),Zp=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyZnAxNiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVuYWJsZWQlMjIlM0ElMjAlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybG9zc19zY2FsZSUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsb3NzX3NjYWxlX3dpbmRvdyUyMiUzQSUyMDEwMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbml0aWFsX3NjYWxlX3Bvd2VyJTIyJTNBJTIwMTYlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoeXN0ZXJlc2lzJTIyJTNBJTIwMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1pbl9sb3NzX3NjYWxlJTIyJTNBJTIwMSUwQSUyMCUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;fp16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale_window&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1000</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;initial_scale_power&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">16</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hysteresis&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;min_loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`}}),Sp=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyZnAxNiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVuYWJsZWQlMjIlM0ElMjB0cnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybG9zc19zY2FsZSUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsb3NzX3NjYWxlX3dpbmRvdyUyMiUzQSUyMDEwMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbml0aWFsX3NjYWxlX3Bvd2VyJTIyJTNBJTIwMTYlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoeXN0ZXJlc2lzJTIyJTNBJTIwMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1pbl9sb3NzX3NjYWxlJTIyJTNBJTIwMSUwQSUyMCUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;fp16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale_window&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1000</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;initial_scale_power&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">16</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hysteresis&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;min_loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`}}),zp=new J({}),Gp=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyYmYxNiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVuYWJsZWQlMjIlM0ElMjAlMjJhdXRvJTIyJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;bf16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`}}),Hp=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyYmYxNiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVuYWJsZWQlMjIlM0ElMjB0cnVlJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;bf16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`}}),ce=new AI({props:{$$slots:{default:[v0]},$$scope:{ctx:qt}}}),Qp=new J({}),Pp=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyY29tbXVuaWNhdGlvbl9kYXRhX3R5cGUlMjIlM0ElMjAlMjJmcDMyJTIyJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;communication_data_type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;fp32&quot;</span>
<span class="hljs-punctuation">}</span>`}}),Kp=new J({}),eo=new w({props:{code:"JTIyYW1wJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyZW5hYmxlZCUyMiUzQSUyMCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJvcHRfbGV2ZWwlMjIlM0ElMjAlMjJhdXRvJTIyJTBBJTdE",highlighted:`<span class="hljs-attr">&quot;amp&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;opt_level&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
<span class="hljs-punctuation">}</span>`}}),no=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyYW1wJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW5hYmxlZCUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJvcHRfbGV2ZWwlMjIlM0ElMjAlMjJPMSUyMiUwQSUyMCUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;amp&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;opt_level&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;O1&quot;</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`}}),io=new J({}),uo=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIydHJhaW5fYmF0Y2hfc2l6ZSUyMiUzQSUyMCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFpbl9taWNyb19iYXRjaF9zaXplX3Blcl9ncHUlMjIlM0ElMjAlMjJhdXRvJTIyJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;train_batch_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_micro_batch_size_per_gpu&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
<span class="hljs-punctuation">}</span>`}}),ho=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIydHJhaW5fYmF0Y2hfc2l6ZSUyMiUzQSUyMDEyJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhaW5fbWljcm9fYmF0Y2hfc2l6ZV9wZXJfZ3B1JTIyJTNBJTIwNCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;train_batch_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">12</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_micro_batch_size_per_gpu&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">4</span>
<span class="hljs-punctuation">}</span>`}}),jo=new J({}),wo=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTIyJTNBJTIwJTIyYXV0byUyMiUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;gradient_accumulation_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
<span class="hljs-punctuation">}</span>`}}),mo=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTIyJTNBJTIwMyUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;gradient_accumulation_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3</span>
<span class="hljs-punctuation">}</span>`}}),Io=new J({}),vo=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyZ3JhZGllbnRfY2xpcHBpbmclMjIlM0ElMjAlMjJhdXRvJTIyJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;gradient_clipping&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
<span class="hljs-punctuation">}</span>`}}),go=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyZ3JhZGllbnRfY2xpcHBpbmclMjIlM0ElMjAxLjAlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;gradient_clipping&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1.0</span>
<span class="hljs-punctuation">}</span>`}}),Bo=new J({}),So=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyemVyb19vcHRpbWl6YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFnZTNfZ2F0aGVyXzE2Yml0X3dlaWdodHNfb25fbW9kZWxfc2F2ZSUyMiUzQSUyMHRydWUlMEElMjAlMjAlMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage3_gather_16bit_weights_on_model_save&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`}}),Wo=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy50cmFpbmVyX3V0aWxzJTIwaW1wb3J0JTIwZ2V0X2xhc3RfY2hlY2twb2ludCUwQWZyb20lMjBkZWVwc3BlZWQudXRpbHMuemVyb190b19mcDMyJTIwaW1wb3J0JTIwbG9hZF9zdGF0ZV9kaWN0X2Zyb21femVyb19jaGVja3BvaW50JTBBJTBBY2hlY2twb2ludF9kaXIlMjAlM0QlMjBnZXRfbGFzdF9jaGVja3BvaW50KHRyYWluZXIuYXJncy5vdXRwdXRfZGlyKSUwQWZwMzJfbW9kZWwlMjAlM0QlMjBsb2FkX3N0YXRlX2RpY3RfZnJvbV96ZXJvX2NoZWNrcG9pbnQodHJhaW5lci5tb2RlbCUyQyUyMGNoZWNrcG9pbnRfZGlyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers.trainer_utils <span class="hljs-keyword">import</span> get_last_checkpoint
<span class="hljs-keyword">from</span> deepspeed.utils.zero_to_fp32 <span class="hljs-keyword">import</span> load_state_dict_from_zero_checkpoint

checkpoint_dir = get_last_checkpoint(trainer.args.output_dir)
fp32_model = load_state_dict_from_zero_checkpoint(trainer.model, checkpoint_dir)`}}),Xo=new w({props:{code:"ZnJvbSUyMGRlZXBzcGVlZC51dGlscy56ZXJvX3RvX2ZwMzIlMjBpbXBvcnQlMjBsb2FkX3N0YXRlX2RpY3RfZnJvbV96ZXJvX2NoZWNrcG9pbnQlMEElMEFjaGVja3BvaW50X2RpciUyMCUzRCUyMG9zLnBhdGguam9pbih0cmFpbmVyLmFyZ3Mub3V0cHV0X2RpciUyQyUyMCUyMmNoZWNrcG9pbnQtZmluYWwlMjIpJTBBdHJhaW5lci5kZWVwc3BlZWQuc2F2ZV9jaGVja3BvaW50KGNoZWNrcG9pbnRfZGlyKSUwQWZwMzJfbW9kZWwlMjAlM0QlMjBsb2FkX3N0YXRlX2RpY3RfZnJvbV96ZXJvX2NoZWNrcG9pbnQodHJhaW5lci5tb2RlbCUyQyUyMGNoZWNrcG9pbnRfZGlyKQ==",highlighted:`<span class="hljs-keyword">from</span> deepspeed.utils.zero_to_fp32 <span class="hljs-keyword">import</span> load_state_dict_from_zero_checkpoint

checkpoint_dir = os.path.join(trainer.args.output_dir, <span class="hljs-string">&quot;checkpoint-final&quot;</span>)
trainer.deepspeed.save_checkpoint(checkpoint_dir)
fp32_model = load_state_dict_from_zero_checkpoint(trainer.model, checkpoint_dir)`}}),Je=new AI({props:{$$slots:{default:[b0]},$$scope:{ctx:qt}}}),Vo=new w({props:{code:"ZnJvbSUyMGRlZXBzcGVlZC51dGlscy56ZXJvX3RvX2ZwMzIlMjBpbXBvcnQlMjBnZXRfZnAzMl9zdGF0ZV9kaWN0X2Zyb21femVyb19jaGVja3BvaW50JTBBJTBBc3RhdGVfZGljdCUyMCUzRCUyMGdldF9mcDMyX3N0YXRlX2RpY3RfZnJvbV96ZXJvX2NoZWNrcG9pbnQoY2hlY2twb2ludF9kaXIpJTIwJTIwJTIzJTIwYWxyZWFkeSUyMG9uJTIwY3B1JTBBbW9kZWwlMjAlM0QlMjBtb2RlbC5jcHUoKSUwQW1vZGVsLmxvYWRfc3RhdGVfZGljdChzdGF0ZV9kaWN0KQ==",highlighted:`<span class="hljs-keyword">from</span> deepspeed.utils.zero_to_fp32 <span class="hljs-keyword">import</span> get_fp32_state_dict_from_zero_checkpoint

state_dict = get_fp32_state_dict_from_zero_checkpoint(checkpoint_dir)  <span class="hljs-comment"># already on cpu</span>
model = model.cpu()
model.load_state_dict(state_dict)`}}),Po=new w({props:{code:"JTI0JTIwbHMlMjAtbCUyMG91dHB1dF9kaXIlMkZjaGVja3BvaW50LTElMkYlMEEtcnctcnctci0tJTIwMSUyMHN0YXMlMjBzdGFzJTIwMS40SyUyME1hciUyMDI3JTIwMjAlM0E0MiUyMGNvbmZpZy5qc29uJTBBZHJ3eHJ3eHIteCUyMDIlMjBzdGFzJTIwc3RhcyUyMDQuMEslMjBNYXIlMjAyNSUyMDE5JTNBNTIlMjBnbG9iYWxfc3RlcDElMkYlMEEtcnctcnctci0tJTIwMSUyMHN0YXMlMjBzdGFzJTIwJTIwJTIwMTIlMjBNYXIlMjAyNyUyMDEzJTNBMTYlMjBsYXRlc3QlMEEtcnctcnctci0tJTIwMSUyMHN0YXMlMjBzdGFzJTIwODI3SyUyME1hciUyMDI3JTIwMjAlM0E0MiUyMG9wdGltaXplci5wdCUwQS1ydy1ydy1yLS0lMjAxJTIwc3RhcyUyMHN0YXMlMjAyMzFNJTIwTWFyJTIwMjclMjAyMCUzQTQyJTIwcHl0b3JjaF9tb2RlbC5iaW4lMEEtcnctcnctci0tJTIwMSUyMHN0YXMlMjBzdGFzJTIwJTIwNjIzJTIwTWFyJTIwMjclMjAyMCUzQTQyJTIwc2NoZWR1bGVyLnB0JTBBLXJ3LXJ3LXItLSUyMDElMjBzdGFzJTIwc3RhcyUyMDEuOEslMjBNYXIlMjAyNyUyMDIwJTNBNDIlMjBzcGVjaWFsX3Rva2Vuc19tYXAuanNvbiUwQS1ydy1ydy1yLS0lMjAxJTIwc3RhcyUyMHN0YXMlMjA3NzRLJTIwTWFyJTIwMjclMjAyMCUzQTQyJTIwc3BpZWNlLm1vZGVsJTBBLXJ3LXJ3LXItLSUyMDElMjBzdGFzJTIwc3RhcyUyMDEuOUslMjBNYXIlMjAyNyUyMDIwJTNBNDIlMjB0b2tlbml6ZXJfY29uZmlnLmpzb24lMEEtcnctcnctci0tJTIwMSUyMHN0YXMlMjBzdGFzJTIwJTIwMzM5JTIwTWFyJTIwMjclMjAyMCUzQTQyJTIwdHJhaW5lcl9zdGF0ZS5qc29uJTBBLXJ3LXJ3LXItLSUyMDElMjBzdGFzJTIwc3RhcyUyMDIuM0slMjBNYXIlMjAyNyUyMDIwJTNBNDIlMjB0cmFpbmluZ19hcmdzLmJpbiUwQS1yd3hydy1yLS0lMjAxJTIwc3RhcyUyMHN0YXMlMjA1LjVLJTIwTWFyJTIwMjclMjAxMyUzQTE2JTIwemVyb190b19mcDMyLnB5Kg==",highlighted:`$ <span class="hljs-built_in">ls</span> -l output_dir/checkpoint-1/
-rw-rw-r-- 1 stas stas 1.4K Mar 27 20:42 config.json
drwxrwxr-x 2 stas stas 4.0K Mar 25 19:52 global_step1/
-rw-rw-r-- 1 stas stas   12 Mar 27 13:16 latest
-rw-rw-r-- 1 stas stas 827K Mar 27 20:42 optimizer.pt
-rw-rw-r-- 1 stas stas 231M Mar 27 20:42 pytorch_model.bin
-rw-rw-r-- 1 stas stas  623 Mar 27 20:42 scheduler.pt
-rw-rw-r-- 1 stas stas 1.8K Mar 27 20:42 special_tokens_map.json
-rw-rw-r-- 1 stas stas 774K Mar 27 20:42 spiece.model
-rw-rw-r-- 1 stas stas 1.9K Mar 27 20:42 tokenizer_config.json
-rw-rw-r-- 1 stas stas  339 Mar 27 20:42 trainer_state.json
-rw-rw-r-- 1 stas stas 2.3K Mar 27 20:42 training_args.bin
-rwxrw-r-- 1 stas stas 5.5K Mar 27 13:16 zero_to_fp32.py*`}}),Oo=new w({props:{code:"cHl0aG9uJTIwemVyb190b19mcDMyLnB5JTIwLiUyMHB5dG9yY2hfbW9kZWwuYmlu",highlighted:"python zero_to_fp32.py . pytorch_model.bin"}}),ai=new J({}),ii=new J({}),ui=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTIwVDVDb25maWclMEFpbXBvcnQlMjBkZWVwc3BlZWQlMEElMEF3aXRoJTIwZGVlcHNwZWVkLnplcm8uSW5pdCgpJTNBJTBBJTIwJTIwJTIwJTIwY29uZmlnJTIwJTNEJTIwVDVDb25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMnQ1LXNtYWxsJTIyKSUwQSUyMCUyMCUyMCUyMG1vZGVsJTIwJTNEJTIwVDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24oY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5ForConditionalGeneration, T5Config
<span class="hljs-keyword">import</span> deepspeed

<span class="hljs-keyword">with</span> deepspeed.zero.Init():
    config = T5Config.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)
    model = T5ForConditionalGeneration(config)`}}),hi=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUyQyUyMFRyYWluZXIlMkMlMjBUcmFpbmluZ0FyZ3VtZW50cyUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyguLi4lMkMlMjBkZWVwc3BlZWQlM0Rkc19jb25maWcpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnQ1LXNtYWxsJTIyKSUwQXRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKG1vZGVsJTNEbW9kZWwlMkMlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUyMC4uLik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel, Trainer, TrainingArguments

training_args = TrainingArguments(..., deepspeed=ds_config)
model = AutoModel.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)
trainer = Trainer(model=model, args=training_args, ...)`}}),wi=new J({}),fi=new w({props:{code:"dGVuc29yKCU1QjEuMCU1RCUyQyUyMGRldmljZSUzRCUyMmN1ZGElM0EwJTIyJTJDJTIwZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwcmVxdWlyZXNfZ3JhZCUzRFRydWUp",highlighted:'tensor([<span class="hljs-number">1.0</span>], device=<span class="hljs-string">&quot;cuda:0&quot;</span>, dtype=torch.float16, requires_grad=<span class="hljs-literal">True</span>)'}}),Ci=new J({}),Ai=new w({props:{code:"ZGVlcHNwZWVkJTIwLS1udW1fZ3B1cyUzRDIlMjB5b3VyX3Byb2dyYW0ucHklMjAlM0Nub3JtYWwlMjBjbCUyMGFyZ3MlM0UlMjAtLWRvX2V2YWwlMjAtLWRlZXBzcGVlZCUyMGRzX2NvbmZpZy5qc29u",highlighted:"deepspeed --num_gpus=2 your_program.py &lt;normal cl args&gt; --do_eval --deepspeed ds_config.json"}}),Bi=new w({props:{code:"ZGVlcHNwZWVkJTIwZXhhbXBsZXMlMkZweXRvcmNoJTJGdHJhbnNsYXRpb24lMkZydW5fdHJhbnNsYXRpb24ucHklMjAlNUMlMEEtLWRlZXBzcGVlZCUyMHRlc3RzJTJGZGVlcHNwZWVkJTJGZHNfY29uZmlnX3plcm8zLmpzb24lMjAlNUMlMEEtLW1vZGVsX25hbWVfb3JfcGF0aCUyMHQ1LXNtYWxsJTIwLS1vdXRwdXRfZGlyJTIwb3V0cHV0X2RpciUyMCU1QyUwQS0tZG9fZXZhbCUyMC0tbWF4X2V2YWxfc2FtcGxlcyUyMDUwJTIwLS13YXJtdXBfc3RlcHMlMjA1MCUyMCUyMCU1QyUwQS0tbWF4X3NvdXJjZV9sZW5ndGglMjAxMjglMjAtLXZhbF9tYXhfdGFyZ2V0X2xlbmd0aCUyMDEyOCUyMCU1QyUwQS0tb3ZlcndyaXRlX291dHB1dF9kaXIlMjAtLXBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplJTIwNCUyMCU1QyUwQS0tcHJlZGljdF93aXRoX2dlbmVyYXRlJTIwLS1kYXRhc2V0X2NvbmZpZyUyMCUyMnJvLWVuJTIyJTIwLS1mcDE2JTIwJTVDJTBBLS1zb3VyY2VfbGFuZyUyMGVuJTIwLS10YXJnZXRfbGFuZyUyMHJvJTIwLS1kYXRhc2V0X25hbWUlMjB3bXQxNiUyMCU1QyUwQS0tc291cmNlX3ByZWZpeCUyMCUyMnRyYW5zbGF0ZSUyMEVuZ2xpc2glMjB0byUyMFJvbWFuaWFuJTNBJTIwJTIy",highlighted:`deepspeed examples/pytorch/translation/run_translation.py \\
--deepspeed tests/deepspeed/ds_config_zero3.json \\
--model_name_or_path t5-small --output_dir output_dir \\
--do_eval --max_eval_samples 50 --warmup_steps 50  \\
--max_source_length 128 --val_max_target_length 128 \\
--overwrite_output_dir --per_device_eval_batch_size 4 \\
--predict_with_generate --dataset_config <span class="hljs-string">&quot;ro-en&quot;</span> --fp16 \\
--source_lang en --target_lang ro --dataset_name wmt16 \\
--source_prefix <span class="hljs-string">&quot;translate English to Romanian: &quot;</span>`}}),qi=new J({}),$i=new w({props:{code:"JTI0JTIwcHl0aG9uJTIwLWMlMjAnZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUzQiUyMCU1QyUwQWZyb20lMjBkZWVwc3BlZWQucnVudGltZS56ZXJvLnN0YWdlMyUyMGltcG9ydCUyMGVzdGltYXRlX3plcm8zX21vZGVsX3N0YXRlc19tZW1fbmVlZHNfYWxsX2xpdmUlM0IlMjAlNUMlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyYmlnc2NpZW5jZSUyRlQwXzNCJTIyKSUzQiUyMCU1QyUwQWVzdGltYXRlX3plcm8zX21vZGVsX3N0YXRlc19tZW1fbmVlZHNfYWxsX2xpdmUobW9kZWwlMkMlMjBudW1fZ3B1c19wZXJfbm9kZSUzRDElMkMlMjBudW1fbm9kZXMlM0QxKSclMEElNUIuLi4lNUQlMEFFc3RpbWF0ZWQlMjBtZW1vcnklMjBuZWVkZWQlMjBmb3IlMjBwYXJhbXMlMkMlMjBvcHRpbSUyMHN0YXRlcyUyMGFuZCUyMGdyYWRpZW50cyUyMGZvciUyMGElM0ElMEFIVyUzQSUyMFNldHVwJTIwd2l0aCUyMDElMjBub2RlJTJDJTIwMSUyMEdQVSUyMHBlciUyMG5vZGUuJTBBU1clM0ElMjBNb2RlbCUyMHdpdGglMjAyNzgzTSUyMHRvdGFsJTIwcGFyYW1zJTJDJTIwNjVNJTIwbGFyZ2VzdCUyMGxheWVyJTIwcGFyYW1zLiUwQSUyMCUyMHBlciUyMENQVSUyMCUyMCU3QyUyMCUyMHBlciUyMEdQVSUyMCU3QyUyMCUyMCUyME9wdGlvbnMlMEElMjAlMjAlMjA3MC4wMEdCJTIwJTdDJTIwJTIwJTIwMC4yNUdCJTIwJTdDJTIwb2ZmbG9hZF9wYXJhbSUzRGNwdSUyMCUyQyUyMG9mZmxvYWRfb3B0aW1pemVyJTNEY3B1JTIwJTJDJTIwemVyb19pbml0JTNEMSUwQSUyMCUyMCUyMDcwLjAwR0IlMjAlN0MlMjAlMjAlMjAwLjI1R0IlMjAlN0MlMjBvZmZsb2FkX3BhcmFtJTNEY3B1JTIwJTJDJTIwb2ZmbG9hZF9vcHRpbWl6ZXIlM0RjcHUlMjAlMkMlMjB6ZXJvX2luaXQlM0QwJTBBJTIwJTIwJTIwNjIuMjNHQiUyMCU3QyUyMCUyMCUyMDUuNDNHQiUyMCU3QyUyMG9mZmxvYWRfcGFyYW0lM0Rub25lJTJDJTIwb2ZmbG9hZF9vcHRpbWl6ZXIlM0RjcHUlMjAlMkMlMjB6ZXJvX2luaXQlM0QxJTBBJTIwJTIwJTIwNjIuMjNHQiUyMCU3QyUyMCUyMCUyMDUuNDNHQiUyMCU3QyUyMG9mZmxvYWRfcGFyYW0lM0Rub25lJTJDJTIwb2ZmbG9hZF9vcHRpbWl6ZXIlM0RjcHUlMjAlMkMlMjB6ZXJvX2luaXQlM0QwJTBBJTIwJTIwJTIwJTIwMC4zN0dCJTIwJTdDJTIwJTIwNDYuOTFHQiUyMCU3QyUyMG9mZmxvYWRfcGFyYW0lM0Rub25lJTJDJTIwb2ZmbG9hZF9vcHRpbWl6ZXIlM0Rub25lJTJDJTIwemVyb19pbml0JTNEMSUwQSUyMCUyMCUyMDE1LjU2R0IlMjAlN0MlMjAlMjA0Ni45MUdCJTIwJTdDJTIwb2ZmbG9hZF9wYXJhbSUzRG5vbmUlMkMlMjBvZmZsb2FkX29wdGltaXplciUzRG5vbmUlMkMlMjB6ZXJvX2luaXQlM0Qw",highlighted:`$ python -c <span class="hljs-string">&#x27;from transformers import AutoModel; \\
from deepspeed.runtime.zero.stage3 import estimate_zero3_model_states_mem_needs_all_live; \\
model = AutoModel.from_pretrained(&quot;bigscience/T0_3B&quot;); \\
estimate_zero3_model_states_mem_needs_all_live(model, num_gpus_per_node=1, num_nodes=1)&#x27;</span>
[...]
Estimated memory needed <span class="hljs-keyword">for</span> params, optim states and gradients <span class="hljs-keyword">for</span> a:
HW: Setup with 1 node, 1 GPU per node.
SW: Model with 2783M total params, 65M largest layer params.
  per CPU  |  per GPU |   Options
   70.00GB |   0.25GB | offload_param=cpu , offload_optimizer=cpu , zero_init=1
   70.00GB |   0.25GB | offload_param=cpu , offload_optimizer=cpu , zero_init=0
   62.23GB |   5.43GB | offload_param=none, offload_optimizer=cpu , zero_init=1
   62.23GB |   5.43GB | offload_param=none, offload_optimizer=cpu , zero_init=0
    0.37GB |  46.91GB | offload_param=none, offload_optimizer=none, zero_init=1
   15.56GB |  46.91GB | offload_param=none, offload_optimizer=none, zero_init=0`}}),Wi=new w({props:{code:"JTI0JTIwcHl0aG9uJTIwLWMlMjAnZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUzQiUyMCU1QyUwQWZyb20lMjBkZWVwc3BlZWQucnVudGltZS56ZXJvLnN0YWdlMyUyMGltcG9ydCUyMGVzdGltYXRlX3plcm8zX21vZGVsX3N0YXRlc19tZW1fbmVlZHNfYWxsX2xpdmUlM0IlMjAlNUMlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyYmlnc2NpZW5jZSUyRlQwXzNCJTIyKSUzQiUyMCU1QyUwQWVzdGltYXRlX3plcm8zX21vZGVsX3N0YXRlc19tZW1fbmVlZHNfYWxsX2xpdmUobW9kZWwlMkMlMjBudW1fZ3B1c19wZXJfbm9kZSUzRDIlMkMlMjBudW1fbm9kZXMlM0QxKSclMEElNUIuLi4lNUQlMEFFc3RpbWF0ZWQlMjBtZW1vcnklMjBuZWVkZWQlMjBmb3IlMjBwYXJhbXMlMkMlMjBvcHRpbSUyMHN0YXRlcyUyMGFuZCUyMGdyYWRpZW50cyUyMGZvciUyMGElM0ElMEFIVyUzQSUyMFNldHVwJTIwd2l0aCUyMDElMjBub2RlJTJDJTIwMiUyMEdQVXMlMjBwZXIlMjBub2RlLiUwQVNXJTNBJTIwTW9kZWwlMjB3aXRoJTIwMjc4M00lMjB0b3RhbCUyMHBhcmFtcyUyQyUyMDY1TSUyMGxhcmdlc3QlMjBsYXllciUyMHBhcmFtcy4lMEElMjAlMjBwZXIlMjBDUFUlMjAlMjAlN0MlMjAlMjBwZXIlMjBHUFUlMjAlN0MlMjAlMjAlMjBPcHRpb25zJTBBJTIwJTIwJTIwNzAuMDBHQiUyMCU3QyUyMCUyMCUyMDAuMjVHQiUyMCU3QyUyMG9mZmxvYWRfcGFyYW0lM0RjcHUlMjAlMkMlMjBvZmZsb2FkX29wdGltaXplciUzRGNwdSUyMCUyQyUyMHplcm9faW5pdCUzRDElMEElMjAlMjAlMjA3MC4wMEdCJTIwJTdDJTIwJTIwJTIwMC4yNUdCJTIwJTdDJTIwb2ZmbG9hZF9wYXJhbSUzRGNwdSUyMCUyQyUyMG9mZmxvYWRfb3B0aW1pemVyJTNEY3B1JTIwJTJDJTIwemVyb19pbml0JTNEMCUwQSUyMCUyMCUyMDYyLjIzR0IlMjAlN0MlMjAlMjAlMjAyLjg0R0IlMjAlN0MlMjBvZmZsb2FkX3BhcmFtJTNEbm9uZSUyQyUyMG9mZmxvYWRfb3B0aW1pemVyJTNEY3B1JTIwJTJDJTIwemVyb19pbml0JTNEMSUwQSUyMCUyMCUyMDYyLjIzR0IlMjAlN0MlMjAlMjAlMjAyLjg0R0IlMjAlN0MlMjBvZmZsb2FkX3BhcmFtJTNEbm9uZSUyQyUyMG9mZmxvYWRfb3B0aW1pemVyJTNEY3B1JTIwJTJDJTIwemVyb19pbml0JTNEMCUwQSUyMCUyMCUyMCUyMDAuNzRHQiUyMCU3QyUyMCUyMDIzLjU4R0IlMjAlN0MlMjBvZmZsb2FkX3BhcmFtJTNEbm9uZSUyQyUyMG9mZmxvYWRfb3B0aW1pemVyJTNEbm9uZSUyQyUyMHplcm9faW5pdCUzRDElMEElMjAlMjAlMjAzMS4xMUdCJTIwJTdDJTIwJTIwMjMuNThHQiUyMCU3QyUyMG9mZmxvYWRfcGFyYW0lM0Rub25lJTJDJTIwb2ZmbG9hZF9vcHRpbWl6ZXIlM0Rub25lJTJDJTIwemVyb19pbml0JTNEMCUwQQ==",highlighted:`$ python -c <span class="hljs-string">&#x27;from transformers import AutoModel; \\
from deepspeed.runtime.zero.stage3 import estimate_zero3_model_states_mem_needs_all_live; \\
model = AutoModel.from_pretrained(&quot;bigscience/T0_3B&quot;); \\
estimate_zero3_model_states_mem_needs_all_live(model, num_gpus_per_node=2, num_nodes=1)&#x27;</span>
[...]
Estimated memory needed <span class="hljs-keyword">for</span> params, optim states and gradients <span class="hljs-keyword">for</span> a:
HW: Setup with 1 node, 2 GPUs per node.
SW: Model with 2783M total params, 65M largest layer params.
  per CPU  |  per GPU |   Options
   70.00GB |   0.25GB | offload_param=cpu , offload_optimizer=cpu , zero_init=1
   70.00GB |   0.25GB | offload_param=cpu , offload_optimizer=cpu , zero_init=0
   62.23GB |   2.84GB | offload_param=none, offload_optimizer=cpu , zero_init=1
   62.23GB |   2.84GB | offload_param=none, offload_optimizer=cpu , zero_init=0
    0.74GB |  23.58GB | offload_param=none, offload_optimizer=none, zero_init=1
   31.11GB |  23.58GB | offload_param=none, offload_optimizer=none, zero_init=0
`}}),Hi=new J({}),Li=new w({props:{code:"cHl0aG9uJTIwLWMlMjAnaW1wb3J0JTIwdG9yY2glM0IlMjBwcmludChmJTIydG9yY2glM0ElMjAlN0J0b3JjaC5fX3ZlcnNpb25fXyU3RCUyMiknJTBBcHl0aG9uJTIwLWMlMjAnaW1wb3J0JTIwdHJhbnNmb3JtZXJzJTNCJTIwcHJpbnQoZiUyMnRyYW5zZm9ybWVycyUzQSUyMCU3QnRyYW5zZm9ybWVycy5fX3ZlcnNpb25fXyU3RCUyMiknJTBBcHl0aG9uJTIwLWMlMjAnaW1wb3J0JTIwZGVlcHNwZWVkJTNCJTIwcHJpbnQoZiUyMmRlZXBzcGVlZCUzQSUyMCU3QmRlZXBzcGVlZC5fX3ZlcnNpb25fXyU3RCUyMikn",highlighted:`python -c <span class="hljs-string">&#x27;import torch; print(f&quot;torch: {torch.__version__}&quot;)&#x27;</span>
python -c <span class="hljs-string">&#x27;import transformers; print(f&quot;transformers: {transformers.__version__}&quot;)&#x27;</span>
python -c <span class="hljs-string">&#x27;import deepspeed; print(f&quot;deepspeed: {deepspeed.__version__}&quot;)&#x27;</span>`}}),Di=new J({}),Oi=new J({}),tM=new J({}),lM=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyZnAxNiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVuYWJsZWQlMjIlM0ElMjAlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybG9zc19zY2FsZSUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsb3NzX3NjYWxlX3dpbmRvdyUyMiUzQSUyMDEwMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbml0aWFsX3NjYWxlX3Bvd2VyJTIyJTNBJTIwMTYlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoeXN0ZXJlc2lzJTIyJTNBJTIwMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1pbl9sb3NzX3NjYWxlJTIyJTNBJTIwMSUwQSUyMCUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;fp16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale_window&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1000</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;initial_scale_power&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">16</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hysteresis&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;min_loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`}}),nM=new w({props:{code:"MCUyNSU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMDAlMkYxODklMjAlNUIwMCUzQTAwJTNDJTNGJTJDJTIwJTNGaXQlMkZzJTVEJTBBJTIwJTVCZGVlcHNjYWxlJTVEJTIwT1ZFUkZMT1chJTIwUmFuayUyMDAlMjBTa2lwcGluZyUyMHN0ZXAuJTIwQXR0ZW1wdGVkJTIwbG9zcyUyMHNjYWxlJTNBJTIwMjYyMTQ0JTJDJTIwcmVkdWNpbmclMjB0byUyMDI2MjE0NCUwQSUyMCUyMDElMjUlN0MlRTIlOTYlOEMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAxJTJGMTg5JTIwJTVCMDAlM0EwMCUzQzAxJTNBMjYlMkMlMjAlMjAyLjE3aXQlMkZzJTVEJTBBJTIwJTVCZGVlcHNjYWxlJTVEJTIwT1ZFUkZMT1chJTIwUmFuayUyMDAlMjBTa2lwcGluZyUyMHN0ZXAuJTIwQXR0ZW1wdGVkJTIwbG9zcyUyMHNjYWxlJTNBJTIwMjYyMTQ0JTJDJTIwcmVkdWNpbmclMjB0byUyMDEzMTA3Mi4wJTBBJTIwJTIwMSUyNSU3QyVFMiU5NiU4OCVFMiU5NiU4RiUwQSUyMCU1Qi4uLiU1RCUwQSUyMCU1QmRlZXBzY2FsZSU1RCUyME9WRVJGTE9XISUyMFJhbmslMjAwJTIwU2tpcHBpbmclMjBzdGVwLiUyMEF0dGVtcHRlZCUyMGxvc3MlMjBzY2FsZSUzQSUyMDElMkMlMjByZWR1Y2luZyUyMHRvJTIwMSUwQSUyMDE0JTI1JTdDJUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JThDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwMjclMkYxODklMjAlNUIwMCUzQTE0JTNDMDElM0ExMyUyQyUyMCUyMDIuMjFpdCUyRnMlNUQlMEElMjAlNUJkZWVwc2NhbGUlNUQlMjBPVkVSRkxPVyElMjBSYW5rJTIwMCUyMFNraXBwaW5nJTIwc3RlcC4lMjBBdHRlbXB0ZWQlMjBsb3NzJTIwc2NhbGUlM0ElMjAxJTJDJTIwcmVkdWNpbmclMjB0byUyMDElMEElMjAxNSUyNSU3QyVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4RiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMDI4JTJGMTg5JTIwJTVCMDAlM0ExNCUzQzAxJTNBMTMlMkMlMjAlMjAyLjE4aXQlMkZzJTVEJTBBJTIwJTVCZGVlcHNjYWxlJTVEJTIwT1ZFUkZMT1chJTIwUmFuayUyMDAlMjBTa2lwcGluZyUyMHN0ZXAuJTIwQXR0ZW1wdGVkJTIwbG9zcyUyMHNjYWxlJTNBJTIwMSUyQyUyMHJlZHVjaW5nJTIwdG8lMjAxJTBBJTIwMTUlMjUlN0MlRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlODglRTIlOTYlOEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAyOSUyRjE4OSUyMCU1QjAwJTNBMTUlM0MwMSUzQTEzJTJDJTIwJTIwMi4xOGl0JTJGcyU1RCUwQSUyMCU1QmRlZXBzY2FsZSU1RCUyME9WRVJGTE9XISUyMFJhbmslMjAwJTIwU2tpcHBpbmclMjBzdGVwLiUyMEF0dGVtcHRlZCUyMGxvc3MlMjBzY2FsZSUzQSUyMDElMkMlMjByZWR1Y2luZyUyMHRvJTIwMSUwQSU1Qi4uLiU1RA==",highlighted:`<span class="hljs-number">0</span><span class="hljs-comment">%|                                                                                                                             | 0/189 [00:00&lt;?, ?it/s]</span>
 [deepscale] <span class="hljs-symbol">OVERFLOW</span>! <span class="hljs-symbol">Rank</span> <span class="hljs-number">0</span> <span class="hljs-symbol">Skipping</span> step. <span class="hljs-symbol">Attempted</span> loss scale: <span class="hljs-number">262144</span>, reducing to <span class="hljs-number">262144</span>
  <span class="hljs-number">1</span><span class="hljs-comment">%|▌                                                                                                                    | 1/189 [00:00&lt;01:26,  2.17it/s]</span>
 [deepscale] <span class="hljs-symbol">OVERFLOW</span>! <span class="hljs-symbol">Rank</span> <span class="hljs-number">0</span> <span class="hljs-symbol">Skipping</span> step. <span class="hljs-symbol">Attempted</span> loss scale: <span class="hljs-number">262144</span>, reducing to <span class="hljs-number">131072.0</span>
  <span class="hljs-number">1</span><span class="hljs-comment">%|█▏</span>
 [...]
 [deepscale] <span class="hljs-symbol">OVERFLOW</span>! <span class="hljs-symbol">Rank</span> <span class="hljs-number">0</span> <span class="hljs-symbol">Skipping</span> step. <span class="hljs-symbol">Attempted</span> loss scale: <span class="hljs-number">1</span>, reducing to <span class="hljs-number">1</span>
 <span class="hljs-number">14</span><span class="hljs-comment">%|████████████████▌                                                                                                   | 27/189 [00:14&lt;01:13,  2.21it/s]</span>
 [deepscale] <span class="hljs-symbol">OVERFLOW</span>! <span class="hljs-symbol">Rank</span> <span class="hljs-number">0</span> <span class="hljs-symbol">Skipping</span> step. <span class="hljs-symbol">Attempted</span> loss scale: <span class="hljs-number">1</span>, reducing to <span class="hljs-number">1</span>
 <span class="hljs-number">15</span><span class="hljs-comment">%|█████████████████▏                                                                                                  | 28/189 [00:14&lt;01:13,  2.18it/s]</span>
 [deepscale] <span class="hljs-symbol">OVERFLOW</span>! <span class="hljs-symbol">Rank</span> <span class="hljs-number">0</span> <span class="hljs-symbol">Skipping</span> step. <span class="hljs-symbol">Attempted</span> loss scale: <span class="hljs-number">1</span>, reducing to <span class="hljs-number">1</span>
 <span class="hljs-number">15</span><span class="hljs-comment">%|█████████████████▊                                                                                                  | 29/189 [00:15&lt;01:13,  2.18it/s]</span>
 [deepscale] <span class="hljs-symbol">OVERFLOW</span>! <span class="hljs-symbol">Rank</span> <span class="hljs-number">0</span> <span class="hljs-symbol">Skipping</span> step. <span class="hljs-symbol">Attempted</span> loss scale: <span class="hljs-number">1</span>, reducing to <span class="hljs-number">1</span>
[...]`}}),MM=new J({}),rM=new J({}),TM=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5pbnRlZ3JhdGlvbnMlMjBpbXBvcnQlMjBIZkRlZXBTcGVlZENvbmZpZyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvTW9kZWwlMEFpbXBvcnQlMjBkZWVwc3BlZWQlMEElMEFkc19jb25maWclMjAlM0QlMjAlN0IuLi4lN0QlMjAlMjAlMjMlMjBkZWVwc3BlZWQlMjBjb25maWclMjBvYmplY3QlMjBvciUyMHBhdGglMjB0byUyMHRoZSUyMGZpbGUlMEElMjMlMjBtdXN0JTIwcnVuJTIwYmVmb3JlJTIwaW5zdGFudGlhdGluZyUyMHRoZSUyMG1vZGVsJTIwdG8lMjBkZXRlY3QlMjB6ZXJvJTIwMyUwQWRzY2hmJTIwJTNEJTIwSGZEZWVwU3BlZWRDb25maWcoZHNfY29uZmlnKSUyMCUyMCUyMyUyMGtlZXAlMjB0aGlzJTIwb2JqZWN0JTIwYWxpdmUlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFlbmdpbmUlMjAlM0QlMjBkZWVwc3BlZWQuaW5pdGlhbGl6ZShtb2RlbCUzRG1vZGVsJTJDJTIwY29uZmlnX3BhcmFtcyUzRGRzX2NvbmZpZyUyQyUyMC4uLik=",highlighted:`<span class="hljs-keyword">from</span> transformers.integrations <span class="hljs-keyword">import</span> HfDeepSpeedConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel
<span class="hljs-keyword">import</span> deepspeed

ds_config = {...}  <span class="hljs-comment"># deepspeed config object or path to the file</span>
<span class="hljs-comment"># must run before instantiating the model to detect zero 3</span>
dschf = HfDeepSpeedConfig(ds_config)  <span class="hljs-comment"># keep this object alive</span>
model = AutoModel.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
engine = deepspeed.initialize(model=model, config_params=ds_config, ...)`}}),JM=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5pbnRlZ3JhdGlvbnMlMjBpbXBvcnQlMjBIZkRlZXBTcGVlZENvbmZpZyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvTW9kZWwlMkMlMjBBdXRvQ29uZmlnJTBBaW1wb3J0JTIwZGVlcHNwZWVkJTBBJTBBZHNfY29uZmlnJTIwJTNEJTIwJTdCLi4uJTdEJTIwJTIwJTIzJTIwZGVlcHNwZWVkJTIwY29uZmlnJTIwb2JqZWN0JTIwb3IlMjBwYXRoJTIwdG8lMjB0aGUlMjBmaWxlJTBBJTIzJTIwbXVzdCUyMHJ1biUyMGJlZm9yZSUyMGluc3RhbnRpYXRpbmclMjB0aGUlMjBtb2RlbCUyMHRvJTIwZGV0ZWN0JTIwemVybyUyMDMlMEFkc2NoZiUyMCUzRCUyMEhmRGVlcFNwZWVkQ29uZmlnKGRzX2NvbmZpZyklMjAlMjAlMjMlMjBrZWVwJTIwdGhpcyUyMG9iamVjdCUyMGFsaXZlJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX2NvbmZpZyhjb25maWcpJTBBZW5naW5lJTIwJTNEJTIwZGVlcHNwZWVkLmluaXRpYWxpemUobW9kZWwlM0Rtb2RlbCUyQyUyMGNvbmZpZ19wYXJhbXMlM0Rkc19jb25maWclMkMlMjAuLi4p",highlighted:`<span class="hljs-keyword">from</span> transformers.integrations <span class="hljs-keyword">import</span> HfDeepSpeedConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel, AutoConfig
<span class="hljs-keyword">import</span> deepspeed

ds_config = {...}  <span class="hljs-comment"># deepspeed config object or path to the file</span>
<span class="hljs-comment"># must run before instantiating the model to detect zero 3</span>
dschf = HfDeepSpeedConfig(ds_config)  <span class="hljs-comment"># keep this object alive</span>
config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
model = AutoModel.from_config(config)
engine = deepspeed.initialize(model=model, config_params=ds_config, ...)`}}),mM=new J({}),fM=new I0({props:{name:"class transformers.integrations.HfDeepSpeedConfig",anchor:"transformers.integrations.HfDeepSpeedConfig",parameters:[{name:"config_file_or_dict",val:""}],parametersDescription:[{anchor:"transformers.integrations.HfDeepSpeedConfig.config_file_or_dict",description:"<strong>config_file_or_dict</strong> (<code>Union[str, Dict]</code>) &#x2014; path to DeepSpeed config file or dict.",name:"config_file_or_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/integrations/deepspeed.py#L46"}}),IM=new J({}),_M=new w({props:{code:"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",highlighted:`<span class="hljs-comment">#!/usr/bin/env python</span>

<span class="hljs-comment"># This script demonstrates how to use Deepspeed ZeRO in an inference mode when one can&#x27;t fit a model</span>
<span class="hljs-comment"># into a single GPU</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># 1. Use 1 GPU with CPU offload</span>
<span class="hljs-comment"># 2. Or use multiple GPUs instead</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># First you need to install deepspeed: pip install deepspeed</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># Here we use a 3B &quot;bigscience/T0_3B&quot; model which needs about 15GB GPU RAM - so 1 largish or 2</span>
<span class="hljs-comment"># small GPUs can handle it. or 1 small GPU and a lot of CPU memory.</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># To use a larger model like &quot;bigscience/T0&quot; which needs about 50GB, unless you have an 80GB GPU -</span>
<span class="hljs-comment"># you will need 2-4 gpus. And then you can adapt the script to handle more gpus if you want to</span>
<span class="hljs-comment"># process multiple inputs at once.</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># The provided deepspeed config also activates CPU memory offloading, so chances are that if you</span>
<span class="hljs-comment"># have a lot of available CPU memory and you don&#x27;t mind a slowdown you should be able to load a</span>
<span class="hljs-comment"># model that doesn&#x27;t normally fit into a single GPU. If you have enough GPU memory the program will</span>
<span class="hljs-comment"># run faster if you don&#x27;t want offload to CPU - so disable that section then.</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># To deploy on 1 gpu:</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># deepspeed --num_gpus 1 t0.py</span>
<span class="hljs-comment"># or:</span>
<span class="hljs-comment"># python -m torch.distributed.run --nproc_per_node=1 t0.py</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># To deploy on 2 gpus:</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># deepspeed --num_gpus 2 t0.py</span>
<span class="hljs-comment"># or:</span>
<span class="hljs-comment"># python -m torch.distributed.run --nproc_per_node=2 t0.py</span>


<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoConfig, AutoModelForSeq2SeqLM
<span class="hljs-keyword">from</span> transformers.integrations <span class="hljs-keyword">import</span> HfDeepSpeedConfig
<span class="hljs-keyword">import</span> deepspeed
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> torch

os.environ[<span class="hljs-string">&quot;TOKENIZERS_PARALLELISM&quot;</span>] = <span class="hljs-string">&quot;false&quot;</span>  <span class="hljs-comment"># To avoid warnings about parallelism in tokenizers</span>

<span class="hljs-comment"># distributed setup</span>
local_rank = <span class="hljs-built_in">int</span>(os.getenv(<span class="hljs-string">&quot;LOCAL_RANK&quot;</span>, <span class="hljs-string">&quot;0&quot;</span>))
world_size = <span class="hljs-built_in">int</span>(os.getenv(<span class="hljs-string">&quot;WORLD_SIZE&quot;</span>, <span class="hljs-string">&quot;1&quot;</span>))
torch.cuda.set_device(local_rank)
deepspeed.init_distributed()

model_name = <span class="hljs-string">&quot;bigscience/T0_3B&quot;</span>

config = AutoConfig.from_pretrained(model_name)
model_hidden_size = config.d_model

<span class="hljs-comment"># batch size has to be divisible by world_size, but can be bigger than world_size</span>
train_batch_size = <span class="hljs-number">1</span> * world_size

<span class="hljs-comment"># ds_config notes</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># - enable bf16 if you use Ampere or higher GPU - this will run in mixed precision and will be</span>
<span class="hljs-comment"># faster.</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># - for older GPUs you can enable fp16, but it&#x27;ll only work for non-bf16 pretrained models - e.g.</span>
<span class="hljs-comment"># all official t5 models are bf16-pretrained</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># - set offload_param.device to &quot;none&quot; or completely remove the \`offload_param\` section if you don&#x27;t</span>
<span class="hljs-comment"># - want CPU offload</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># - if using \`offload_param\` you can manually finetune stage3_param_persistence_threshold to control</span>
<span class="hljs-comment"># - which params should remain on gpus - the larger the value the smaller the offload size</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># For indepth info on Deepspeed config see</span>
<span class="hljs-comment"># https://huggingface.co/docs/transformers/main/main_classes/deepspeed</span>

<span class="hljs-comment"># keeping the same format as json for consistency, except it uses lower case for true/false</span>
<span class="hljs-comment"># fmt: off</span>
ds_config = {
    <span class="hljs-string">&quot;fp16&quot;</span>: {
        <span class="hljs-string">&quot;enabled&quot;</span>: <span class="hljs-literal">False</span>
    },
    <span class="hljs-string">&quot;bf16&quot;</span>: {
        <span class="hljs-string">&quot;enabled&quot;</span>: <span class="hljs-literal">False</span>
    },
    <span class="hljs-string">&quot;zero_optimization&quot;</span>: {
        <span class="hljs-string">&quot;stage&quot;</span>: <span class="hljs-number">3</span>,
        <span class="hljs-string">&quot;offload_param&quot;</span>: {
            <span class="hljs-string">&quot;device&quot;</span>: <span class="hljs-string">&quot;cpu&quot;</span>,
            <span class="hljs-string">&quot;pin_memory&quot;</span>: <span class="hljs-literal">True</span>
        },
        <span class="hljs-string">&quot;overlap_comm&quot;</span>: <span class="hljs-literal">True</span>,
        <span class="hljs-string">&quot;contiguous_gradients&quot;</span>: <span class="hljs-literal">True</span>,
        <span class="hljs-string">&quot;reduce_bucket_size&quot;</span>: model_hidden_size * model_hidden_size,
        <span class="hljs-string">&quot;stage3_prefetch_bucket_size&quot;</span>: <span class="hljs-number">0.9</span> * model_hidden_size * model_hidden_size,
        <span class="hljs-string">&quot;stage3_param_persistence_threshold&quot;</span>: <span class="hljs-number">10</span> * model_hidden_size
    },
    <span class="hljs-string">&quot;steps_per_print&quot;</span>: <span class="hljs-number">2000</span>,
    <span class="hljs-string">&quot;train_batch_size&quot;</span>: train_batch_size,
    <span class="hljs-string">&quot;train_micro_batch_size_per_gpu&quot;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&quot;wall_clock_breakdown&quot;</span>: <span class="hljs-literal">False</span>
}
<span class="hljs-comment"># fmt: on</span>

<span class="hljs-comment"># next line instructs transformers to partition the model directly over multiple gpus using</span>
<span class="hljs-comment"># deepspeed.zero.Init when model&#x27;s \`from_pretrained\` method is called.</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># **it has to be run before loading the model AutoModelForSeq2SeqLM.from_pretrained(model_name)**</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># otherwise the model will first be loaded normally and only partitioned at forward time which is</span>
<span class="hljs-comment"># less efficient and when there is little CPU RAM may fail</span>
dschf = HfDeepSpeedConfig(ds_config)  <span class="hljs-comment"># keep this object alive</span>

<span class="hljs-comment"># now a model can be loaded.</span>
model = AutoModelForSeq2SeqLM.from_pretrained(model_name)

<span class="hljs-comment"># initialise Deepspeed ZeRO and store only the engine object</span>
ds_engine = deepspeed.initialize(model=model, config_params=ds_config)[<span class="hljs-number">0</span>]
ds_engine.module.<span class="hljs-built_in">eval</span>()  <span class="hljs-comment"># inference</span>

<span class="hljs-comment"># Deepspeed ZeRO can process unrelated inputs on each GPU. So for 2 gpus you process 2 inputs at once.</span>
<span class="hljs-comment"># If you use more GPUs adjust for more.</span>
<span class="hljs-comment"># And of course if you have just one input to process you then need to pass the same string to both gpus</span>
<span class="hljs-comment"># If you use only one GPU, then you will have only rank 0.</span>
rank = torch.distributed.get_rank()
<span class="hljs-keyword">if</span> rank == <span class="hljs-number">0</span>:
    text_in = <span class="hljs-string">&quot;Is this review positive or negative? Review: this is the best cast iron skillet you will ever buy&quot;</span>
<span class="hljs-keyword">elif</span> rank == <span class="hljs-number">1</span>:
    text_in = <span class="hljs-string">&quot;Is this review positive or negative? Review: this is the worst restaurant ever&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(model_name)
inputs = tokenizer.encode(text_in, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device=local_rank)
<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = ds_engine.module.generate(inputs, synced_gpus=<span class="hljs-literal">True</span>)
text_out = tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;rank<span class="hljs-subst">{rank}</span>:\\n   in=<span class="hljs-subst">{text_in}</span>\\n  out=<span class="hljs-subst">{text_out}</span>&quot;</span>)`}}),ZM=new w({props:{code:"JTI0JTIwZGVlcHNwZWVkJTIwLS1udW1fZ3B1cyUyMDIlMjB0MC5weSUwQXJhbmswJTNBJTBBJTIwJTIwJTIwaW4lM0RJcyUyMHRoaXMlMjByZXZpZXclMjBwb3NpdGl2ZSUyMG9yJTIwbmVnYXRpdmUlM0YlMjBSZXZpZXclM0ElMjB0aGlzJTIwaXMlMjB0aGUlMjBiZXN0JTIwY2FzdCUyMGlyb24lMjBza2lsbGV0JTIweW91JTIwd2lsbCUyMGV2ZXIlMjBidXklMEElMjAlMjBvdXQlM0RQb3NpdGl2ZSUwQXJhbmsxJTNBJTBBJTIwJTIwJTIwaW4lM0RJcyUyMHRoaXMlMjByZXZpZXclMjBwb3NpdGl2ZSUyMG9yJTIwbmVnYXRpdmUlM0YlMjBSZXZpZXclM0ElMjB0aGlzJTIwaXMlMjB0aGUlMjB3b3JzdCUyMHJlc3RhdXJhbnQlMjBldmVyJTBBJTIwJTIwb3V0JTNEbmVnYXRpdmU=",highlighted:`$ deepspeed --num_gpus <span class="hljs-number">2</span> t0.py
rank0:
   <span class="hljs-keyword">in</span>=Is <span class="hljs-keyword">this</span> review positive or negative? Review: <span class="hljs-keyword">this</span> <span class="hljs-keyword">is</span> the best cast iron skillet you will ever buy
  <span class="hljs-keyword">out</span>=Positive
rank1:
   <span class="hljs-keyword">in</span>=Is <span class="hljs-keyword">this</span> review positive or negative? Review: <span class="hljs-keyword">this</span> <span class="hljs-keyword">is</span> the worst restaurant ever
  <span class="hljs-keyword">out</span>=negative`}}),qM=new J({}),$M=new J({}),EM=new w({props:{code:"UlVOX1NMT1clM0QxJTIwcHl0ZXN0JTIwdGVzdHMlMkZkZWVwc3BlZWQlMkZ0ZXN0X2RlZXBzcGVlZC5weQ==",highlighted:'RUN_SLOW=<span class="hljs-number">1</span> pytest tests<span class="hljs-regexp">/deepspeed/</span>test_deepspeed.py'}}),WM=new w({props:{code:"UlVOX1NMT1clM0QxJTIwcHl0ZXN0JTIwdGVzdHMlMkZkZWVwc3BlZWQ=",highlighted:'<span class="hljs-attr">RUN_SLOW</span>=<span class="hljs-number">1</span> pytest tests/deepspeed'}}),RM=new J({}),{c(){U=a("meta"),v=p(),m=a("p"),I=p(),_=a("h1"),b=a("a"),A=a("span"),c(x.$$.fragment),f=p(),B=a("span"),B.textContent=_I,qc=p(),Ne=a("p"),Ne.innerHTML=BI,kc=p(),ze=a("ol"),ze.innerHTML=ZI,Sc=p(),Ee=a("p"),Ee.innerHTML=xI,$c=p(),Ge=a("p"),Ge.textContent=qI,Nc=p(),We=a("p"),We.textContent=kI,zc=p(),Re=a("p"),Re.innerHTML=SI,Ec=p(),Xe=a("ol"),Xe.innerHTML=$I,Gc=p(),He=a("p"),He.textContent=NI,Wc=p(),Qe=a("p"),Qe.textContent=zI,Rc=p(),Ve=a("ol"),Ve.innerHTML=EI,Xc=p(),Ye=a("p"),Ye.textContent=GI,Hc=p(),Le=a("ol"),Le.innerHTML=WI,Qc=p(),Fe=a("p"),Fe.textContent=RI,Vc=p(),LM=a("a"),Yc=p(),q=a("h2"),kt=a("a"),Zr=a("span"),c(Pe.$$.fragment),Tf=p(),FM=a("span"),FM.textContent=XI,Lc=p(),PM=a("a"),Fc=p(),k=a("h3"),St=a("a"),xr=a("span"),c(De.$$.fragment),wf=p(),DM=a("span"),DM.textContent=HI,Pc=p(),Oe=a("p"),Oe.textContent=QI,Dc=p(),c(Ke.$$.fragment),Oc=p(),ts=a("p"),ts.innerHTML=VI,Kc=p(),c(es.$$.fragment),th=p(),ss=a("p"),ss.innerHTML=YI,eh=p(),ls=a("p"),ls.innerHTML=LI,sh=p(),as=a("p"),as.textContent=FI,lh=p(),ns=a("p"),ns.textContent=PI,ah=p(),c(ps.$$.fragment),nh=p(),os=a("p"),os.innerHTML=DI,ph=p(),is=a("p"),is.innerHTML=OI,oh=p(),c(Ms.$$.fragment),ih=p(),us=a("p"),us.innerHTML=KI,Mh=p(),rs=a("p"),rs.textContent=tC,uh=p(),c(cs.$$.fragment),rh=p(),hs=a("p"),hs.innerHTML=eC,ch=p(),ys=a("p"),ys.innerHTML=sC,hh=p(),js=a("p"),js.innerHTML=lC,yh=p(),ds=a("p"),ds.textContent=aC,jh=p(),c(Ts.$$.fragment),dh=p(),ws=a("p"),ws.textContent=nC,Th=p(),c(Js.$$.fragment),wh=p(),Us=a("p"),Us.textContent=pC,Jh=p(),c(ms.$$.fragment),Uh=p(),fs=a("p"),fs.innerHTML=oC,mh=p(),Is=a("p"),Is.innerHTML=iC,fh=p(),Cs=a("p"),Cs.innerHTML=MC,Ih=p(),OM=a("a"),Ch=p(),S=a("h3"),$t=a("a"),qr=a("span"),c(vs.$$.fragment),Jf=p(),KM=a("span"),KM.textContent=uC,vh=p(),bs=a("p"),bs.innerHTML=rC,bh=p(),As=a("p"),As.textContent=cC,Ah=p(),c(gs.$$.fragment),gh=p(),_s=a("p"),_s.innerHTML=hC,_h=p(),c(Bs.$$.fragment),Bh=p(),Zs=a("p"),Zs.innerHTML=yC,Zh=p(),xs=a("p"),xs.innerHTML=jC,xh=p(),qs=a("p"),qs.innerHTML=dC,qh=p(),c(ks.$$.fragment),kh=p(),Ss=a("p"),Ss.innerHTML=TC,Sh=p(),$s=a("p"),$s.innerHTML=wC,$h=p(),tu=a("a"),Nh=p(),$=a("h3"),Nt=a("a"),kr=a("span"),c(Ns.$$.fragment),Uf=p(),eu=a("span"),eu.textContent=JC,zh=p(),zs=a("p"),zs.innerHTML=UC,Eh=p(),c(Es.$$.fragment),Gh=p(),Gs=a("p"),Gs.innerHTML=mC,Wh=p(),Ws=a("p"),Ws.textContent=fC,Rh=p(),Rs=a("ol"),Rs.innerHTML=IC,Xh=p(),Xs=a("p"),Xs.textContent=CC,Hh=p(),c(Hs.$$.fragment),Qh=p(),Qs=a("p"),Qs.textContent=vC,Vh=p(),Vs=a("p"),Vs.innerHTML=bC,Yh=p(),Ys=a("p"),Ys.textContent=AC,Lh=p(),Ls=a("p"),Ls.textContent=gC,Fh=p(),su=a("ul"),N=a("li"),lu=a("p"),lu.innerHTML=_C,mf=p(),c(Fs.$$.fragment),ff=p(),au=a("p"),au.textContent=BC,Ph=p(),nu=a("a"),Dh=p(),z=a("h3"),zt=a("a"),Sr=a("span"),c(Ps.$$.fragment),If=p(),pu=a("span"),pu.textContent=ZC,Oh=p(),Ds=a("p"),Ds.innerHTML=xC,Kh=p(),Os=a("p"),Os.innerHTML=qC,ty=p(),E=a("h4"),Et=a("a"),$r=a("span"),c(Ks.$$.fragment),Cf=p(),ou=a("span"),ou.textContent=kC,ey=p(),tl=a("p"),tl.innerHTML=SC,sy=p(),c(el.$$.fragment),ly=p(),sl=a("p"),sl.textContent=$C,ay=p(),ll=a("p"),ll.innerHTML=NC,ny=p(),G=a("h4"),Gt=a("a"),Nr=a("span"),c(al.$$.fragment),vf=p(),iu=a("span"),iu.textContent=zC,py=p(),nl=a("p"),nl.innerHTML=EC,oy=p(),c(pl.$$.fragment),iy=p(),ol=a("p"),ol.textContent=GC,My=p(),c(il.$$.fragment),uy=p(),Ml=a("p"),Ml.innerHTML=WC,ry=p(),ul=a("p"),ul.innerHTML=RC,cy=p(),W=a("h4"),Wt=a("a"),zr=a("span"),c(rl.$$.fragment),bf=p(),Mu=a("span"),Mu.textContent=XC,hy=p(),cl=a("p"),cl.innerHTML=HC,yy=p(),c(hl.$$.fragment),jy=p(),yl=a("p"),yl.textContent=QC,dy=p(),c(jl.$$.fragment),Ty=p(),dl=a("p"),dl.innerHTML=VC,wy=p(),R=a("h4"),Rt=a("a"),Er=a("span"),c(Tl.$$.fragment),Af=p(),uu=a("span"),uu.textContent=YC,Jy=p(),wl=a("p"),wl.innerHTML=LC,Uy=p(),c(Jl.$$.fragment),my=p(),Ul=a("p"),Ul.innerHTML=FC,fy=p(),ru=a("a"),Iy=p(),X=a("h3"),Xt=a("a"),Gr=a("span"),c(ml.$$.fragment),gf=p(),cu=a("span"),cu.textContent=PC,Cy=p(),fl=a("p"),fl.innerHTML=DC,vy=p(),Il=a("p"),Il.textContent=OC,by=p(),c(Cl.$$.fragment),Ay=p(),vl=a("p"),vl.innerHTML=KC,gy=p(),bl=a("p"),bl.textContent=tv,_y=p(),Al=a("p"),Al.textContent=ev,By=p(),c(gl.$$.fragment),Zy=p(),_l=a("p"),_l.innerHTML=sv,xy=p(),c(Bl.$$.fragment),qy=p(),Zl=a("p"),Zl.innerHTML=lv,ky=p(),c(xl.$$.fragment),Sy=p(),ql=a("p"),ql.textContent=av,$y=p(),kl=a("p"),kl.innerHTML=nv,Ny=p(),hu=a("a"),zy=p(),H=a("h3"),Ht=a("a"),Wr=a("span"),c(Sl.$$.fragment),_f=p(),yu=a("span"),yu.textContent=pv,Ey=p(),$l=a("p"),$l.innerHTML=ov,Gy=p(),Nl=a("p"),Nl.innerHTML=iv,Wy=p(),c(zl.$$.fragment),Ry=p(),El=a("p"),El.innerHTML=Mv,Xy=p(),c(Gl.$$.fragment),Hy=p(),Wl=a("p"),Wl.innerHTML=uv,Qy=p(),Rl=a("p"),Rl.textContent=rv,Vy=p(),Xl=a("p"),Xl.innerHTML=cv,Yy=p(),c(Hl.$$.fragment),Ly=p(),Ql=a("p"),Ql.innerHTML=hv,Fy=p(),ju=a("a"),Py=p(),Q=a("h3"),Qt=a("a"),Rr=a("span"),c(Vl.$$.fragment),Bf=p(),du=a("span"),du.textContent=yv,Dy=p(),Yl=a("p"),Yl.innerHTML=jv,Oy=p(),Ll=a("p"),Ll.textContent=dv,Ky=p(),c(Fl.$$.fragment),tj=p(),Pl=a("p"),Pl.textContent=Tv,ej=p(),c(Dl.$$.fragment),sj=p(),Tu=a("a"),lj=p(),V=a("h3"),Vt=a("a"),Xr=a("span"),c(Ol.$$.fragment),Zf=p(),wu=a("span"),wu.textContent=wv,aj=p(),c(Yt.$$.fragment),nj=p(),Kl=a("p"),Kl.innerHTML=Jv,pj=p(),ta=a("p"),ta.innerHTML=Uv,oj=p(),ea=a("p"),ea.innerHTML=mv,ij=p(),sa=a("p"),sa.textContent=fv,Mj=p(),la=a("p"),la.innerHTML=Iv,uj=p(),aa=a("ol"),aa.innerHTML=Cv,rj=p(),na=a("p"),na.innerHTML=vv,cj=p(),Ju=a("a"),hj=p(),Y=a("h3"),Lt=a("a"),Hr=a("span"),c(pa.$$.fragment),xf=p(),Uu=a("span"),Uu.textContent=bv,yj=p(),oa=a("p"),oa.innerHTML=Av,jj=p(),ia=a("p"),ia.innerHTML=gv,dj=p(),Ma=a("p"),Ma.innerHTML=_v,Tj=p(),ua=a("p"),ua.textContent=Bv,wj=p(),mu=a("a"),Jj=p(),L=a("h4"),Ft=a("a"),Qr=a("span"),c(ra.$$.fragment),qf=p(),fu=a("span"),fu.textContent=Zv,Uj=p(),ca=a("p"),ca.textContent=xv,mj=p(),c(ha.$$.fragment),fj=p(),ya=a("p"),ya.innerHTML=qv,Ij=p(),ja=a("ul"),ja.innerHTML=kv,Cj=p(),da=a("p"),da.innerHTML=Sv,vj=p(),c(Ta.$$.fragment),bj=p(),wa=a("p"),wa.textContent=$v,Aj=p(),Iu=a("a"),gj=p(),F=a("h4"),Pt=a("a"),Vr=a("span"),c(Ja.$$.fragment),kf=p(),Cu=a("span"),Cu.textContent=Nv,_j=p(),Ua=a("p"),Ua.textContent=zv,Bj=p(),c(ma.$$.fragment),Zj=p(),fa=a("p"),fa.innerHTML=Ev,xj=p(),Ia=a("p"),Ia.innerHTML=Gv,qj=p(),Ca=a("p"),Ca.innerHTML=Wv,kj=p(),va=a("ul"),va.innerHTML=Rv,Sj=p(),ba=a("p"),ba.innerHTML=Xv,$j=p(),Aa=a("p"),Aa.innerHTML=Hv,Nj=p(),ga=a("p"),ga.textContent=Qv,zj=p(),_a=a("ul"),_a.innerHTML=Vv,Ej=p(),Ba=a("p"),Ba.innerHTML=Yv,Gj=p(),Za=a("p"),Za.innerHTML=Lv,Wj=p(),xa=a("p"),xa.innerHTML=Fv,Rj=p(),qa=a("ul"),qa.innerHTML=Pv,Xj=p(),ka=a("p"),ka.innerHTML=Dv,Hj=p(),Sa=a("p"),Sa.innerHTML=Ov,Qj=p(),$a=a("ol"),$a.innerHTML=Kv,Vj=p(),P=a("h4"),Dt=a("a"),Yr=a("span"),c(Na.$$.fragment),Sf=p(),vu=a("span"),vu.textContent=t1,Yj=p(),za=a("p"),za.textContent=e1,Lj=p(),Ea=a("p"),Ea.textContent=s1,Fj=p(),c(Ga.$$.fragment),Pj=p(),Wa=a("p"),Wa.textContent=l1,Dj=p(),D=a("h4"),Ot=a("a"),Lr=a("span"),c(Ra.$$.fragment),$f=p(),bu=a("span"),bu.textContent=a1,Oj=p(),Xa=a("p"),Xa.textContent=n1,Kj=p(),c(Ha.$$.fragment),td=p(),Au=a("a"),ed=p(),O=a("h3"),Kt=a("a"),Fr=a("span"),c(Qa.$$.fragment),Nf=p(),gu=a("span"),gu.textContent=p1,sd=p(),Va=a("p"),Va.textContent=o1,ld=p(),Ya=a("p"),Ya.textContent=i1,ad=p(),c(La.$$.fragment),nd=p(),Fa=a("p"),Fa.innerHTML=M1,pd=p(),Pa=a("p"),Pa.innerHTML=u1,od=p(),Da=a("p"),Da.innerHTML=r1,id=p(),Oa=a("p"),Oa.innerHTML=c1,Md=p(),_u=a("a"),ud=p(),K=a("h4"),te=a("a"),Pr=a("span"),c(Ka.$$.fragment),zf=p(),Bu=a("span"),Bu.textContent=h1,rd=p(),tn=a("p"),tn.textContent=y1,cd=p(),en=a("p"),en.textContent=j1,hd=p(),sn=a("ul"),sn.innerHTML=d1,yd=p(),ln=a("p"),ln.innerHTML=T1,jd=p(),Zu=a("a"),dd=p(),tt=a("h4"),ee=a("a"),Dr=a("span"),c(an.$$.fragment),Ef=p(),xu=a("span"),xu.textContent=w1,Td=p(),nn=a("p"),nn.innerHTML=J1,wd=p(),c(pn.$$.fragment),Jd=p(),on=a("p"),on.innerHTML=U1,Ud=p(),c(Mn.$$.fragment),md=p(),qu=a("a"),fd=p(),et=a("h4"),se=a("a"),Or=a("span"),c(un.$$.fragment),Gf=p(),ku=a("span"),ku.textContent=m1,Id=p(),rn=a("p"),rn.innerHTML=f1,Cd=p(),c(cn.$$.fragment),vd=p(),hn=a("p"),hn.innerHTML=I1,bd=p(),c(yn.$$.fragment),Ad=p(),st=a("h4"),le=a("a"),Kr=a("span"),c(jn.$$.fragment),Wf=p(),Su=a("span"),Su.textContent=C1,gd=p(),dn=a("p"),dn.textContent=v1,_d=p(),Tn=a("p"),Tn.textContent=b1,Bd=p(),wn=a("ul"),wn.innerHTML=A1,Zd=p(),Jn=a("p"),Jn.textContent=g1,xd=p(),Un=a("ul"),Un.innerHTML=_1,qd=p(),mn=a("p"),mn.textContent=B1,kd=p(),fn=a("p"),fn.textContent=Z1,Sd=p(),In=a("p"),In.textContent=x1,$d=p(),Cn=a("ol"),Cn.innerHTML=q1,Nd=p(),vn=a("p"),vn.textContent=k1,zd=p(),bn=a("p"),bn.textContent=S1,Ed=p(),An=a("p"),An.textContent=$1,Gd=p(),gn=a("p"),gn.textContent=N1,Wd=p(),_n=a("p"),_n.textContent=z1,Rd=p(),Bn=a("p"),Bn.innerHTML=E1,Xd=p(),Zn=a("p"),Zn.textContent=G1,Hd=p(),xn=a("ul"),xn.innerHTML=W1,Qd=p(),lt=a("h3"),ae=a("a"),tc=a("span"),c(qn.$$.fragment),Rf=p(),$u=a("span"),$u.textContent=R1,Vd=p(),kn=a("p"),kn.textContent=X1,Yd=p(),Sn=a("p"),Sn.textContent=H1,Ld=p(),$n=a("p"),$n.textContent=Q1,Fd=p(),Nn=a("p"),Nn.textContent=V1,Pd=p(),zn=a("ol"),zn.innerHTML=Y1,Dd=p(),at=a("h3"),ne=a("a"),ec=a("span"),c(En.$$.fragment),Xf=p(),Nu=a("span"),Nu.textContent=L1,Od=p(),Gn=a("p"),Gn.innerHTML=F1,Kd=p(),Wn=a("p"),Wn.textContent=P1,tT=p(),Rn=a("p"),Rn.innerHTML=D1,eT=p(),zu=a("a"),sT=p(),nt=a("h4"),pe=a("a"),sc=a("span"),c(Xn.$$.fragment),Hf=p(),Eu=a("span"),Eu.textContent=O1,lT=p(),Hn=a("p"),Hn.innerHTML=K1,aT=p(),Qn=a("p"),Qn.innerHTML=tb,nT=p(),Vn=a("p"),Vn.innerHTML=eb,pT=p(),c(Yn.$$.fragment),oT=p(),Ln=a("p"),Ln.textContent=sb,iT=p(),Fn=a("ul"),Fn.innerHTML=lb,MT=p(),Pn=a("p"),Pn.textContent=ab,uT=p(),Dn=a("p"),Dn.textContent=nb,rT=p(),c(On.$$.fragment),cT=p(),Kn=a("p"),Kn.innerHTML=pb,hT=p(),tp=a("p"),tp.textContent=ob,yT=p(),c(ep.$$.fragment),jT=p(),sp=a("p"),sp.innerHTML=ib,dT=p(),lp=a("p"),lp.innerHTML=Mb,TT=p(),c(ap.$$.fragment),wT=p(),np=a("p"),np.textContent=ub,JT=p(),Gu=a("a"),UT=p(),pt=a("h4"),oe=a("a"),lc=a("span"),c(pp.$$.fragment),Qf=p(),Wu=a("span"),Wu.textContent=rb,mT=p(),op=a("p"),op.innerHTML=cb,fT=p(),ip=a("p"),ip.textContent=hb,IT=p(),Mp=a("ul"),Mp.innerHTML=yb,CT=p(),up=a("p"),up.innerHTML=jb,vT=p(),rp=a("p"),rp.innerHTML=db,bT=p(),c(cp.$$.fragment),AT=p(),hp=a("p"),hp.innerHTML=Tb,gT=p(),yp=a("ul"),yp.innerHTML=wb,_T=p(),jp=a("p"),jp.textContent=Jb,BT=p(),c(dp.$$.fragment),ZT=p(),Tp=a("p"),Tp.innerHTML=Ub,xT=p(),wp=a("p"),wp.innerHTML=mb,qT=p(),c(Jp.$$.fragment),kT=p(),Up=a("p"),Up.innerHTML=fb,ST=p(),Ru=a("a"),$T=p(),ot=a("h3"),ie=a("a"),ac=a("span"),c(mp.$$.fragment),Vf=p(),Xu=a("span"),Xu.textContent=Ib,NT=p(),fp=a("p"),fp.textContent=Cb,zT=p(),Ip=a("p"),Ip.innerHTML=vb,ET=p(),c(Cp.$$.fragment),GT=p(),vp=a("p"),vp.innerHTML=bb,WT=p(),bp=a("p"),bp.innerHTML=Ab,RT=p(),Hu=a("a"),XT=p(),it=a("h3"),Me=a("a"),nc=a("span"),c(Ap.$$.fragment),Yf=p(),Qu=a("span"),Qu.textContent=gb,HT=p(),gp=a("p"),gp.textContent=_b,QT=p(),Mt=a("h3"),ue=a("a"),pc=a("span"),c(_p.$$.fragment),Lf=p(),Vu=a("span"),Vu.textContent=Bb,VT=p(),Bp=a("p"),Bp.textContent=Zb,YT=p(),c(Zp.$$.fragment),LT=p(),xp=a("p"),xp.innerHTML=xb,FT=p(),qp=a("p"),qp.innerHTML=qb,PT=p(),kp=a("p"),kp.textContent=kb,DT=p(),c(Sp.$$.fragment),OT=p(),$p=a("p"),$p.innerHTML=Sb,KT=p(),Np=a("p"),Np.innerHTML=$b,tw=p(),ut=a("h3"),re=a("a"),oc=a("span"),c(zp.$$.fragment),Ff=p(),Yu=a("span"),Yu.textContent=Nb,ew=p(),Ep=a("p"),Ep.textContent=zb,sw=p(),c(Gp.$$.fragment),lw=p(),Wp=a("p"),Wp.textContent=Eb,aw=p(),Rp=a("p"),Rp.innerHTML=Gb,nw=p(),Xp=a("p"),Xp.textContent=Wb,pw=p(),c(Hp.$$.fragment),ow=p(),c(ce.$$.fragment),iw=p(),rt=a("h3"),he=a("a"),ic=a("span"),c(Qp.$$.fragment),Pf=p(),Lu=a("span"),Lu.textContent=Rb,Mw=p(),Vp=a("p"),Vp.innerHTML=Xb,uw=p(),Yp=a("p"),Yp.innerHTML=Hb,rw=p(),Lp=a("p"),Lp.innerHTML=Qb,cw=p(),Fp=a("p"),Fp.textContent=Vb,hw=p(),c(Pp.$$.fragment),yw=p(),Dp=a("p"),Dp.textContent=Yb,jw=p(),Op=a("p"),Op.innerHTML=Lb,dw=p(),ct=a("h3"),ye=a("a"),Mc=a("span"),c(Kp.$$.fragment),Df=p(),Fu=a("span"),Fu.textContent=Fb,Tw=p(),to=a("p"),to.textContent=Pb,ww=p(),c(eo.$$.fragment),Jw=p(),so=a("p"),so.innerHTML=Db,Uw=p(),lo=a("p"),lo.innerHTML=Ob,mw=p(),ao=a("p"),ao.textContent=Kb,fw=p(),c(no.$$.fragment),Iw=p(),po=a("p"),po.innerHTML=tA,Cw=p(),oo=a("p"),oo.innerHTML=eA,vw=p(),Pu=a("a"),bw=p(),ht=a("h3"),je=a("a"),uc=a("span"),c(io.$$.fragment),Of=p(),Du=a("span"),Du.textContent=sA,Aw=p(),Mo=a("p"),Mo.textContent=lA,gw=p(),c(uo.$$.fragment),_w=p(),ro=a("p"),ro.innerHTML=aA,Bw=p(),co=a("p"),co.textContent=nA,Zw=p(),c(ho.$$.fragment),xw=p(),yo=a("p"),yo.innerHTML=pA,qw=p(),Ou=a("a"),kw=p(),yt=a("h3"),de=a("a"),rc=a("span"),c(jo.$$.fragment),Kf=p(),Ku=a("span"),Ku.textContent=oA,Sw=p(),To=a("p"),To.textContent=iA,$w=p(),c(wo.$$.fragment),Nw=p(),Jo=a("p"),Jo.innerHTML=MA,zw=p(),Uo=a("p"),Uo.textContent=uA,Ew=p(),c(mo.$$.fragment),Gw=p(),fo=a("p"),fo.innerHTML=rA,Ww=p(),tr=a("a"),Rw=p(),jt=a("h3"),Te=a("a"),cc=a("span"),c(Io.$$.fragment),tI=p(),er=a("span"),er.textContent=cA,Xw=p(),Co=a("p"),Co.textContent=hA,Hw=p(),c(vo.$$.fragment),Qw=p(),bo=a("p"),bo.innerHTML=yA,Vw=p(),Ao=a("p"),Ao.textContent=jA,Yw=p(),c(go.$$.fragment),Lw=p(),_o=a("p"),_o.innerHTML=dA,Fw=p(),sr=a("a"),Pw=p(),dt=a("h3"),we=a("a"),hc=a("span"),c(Bo.$$.fragment),eI=p(),lr=a("span"),lr.textContent=TA,Dw=p(),Zo=a("p"),Zo.innerHTML=wA,Ow=p(),xo=a("p"),xo.innerHTML=JA,Kw=p(),qo=a("p"),qo.innerHTML=UA,tJ=p(),ko=a("p"),ko.innerHTML=mA,eJ=p(),c(So.$$.fragment),sJ=p(),$o=a("p"),$o.innerHTML=fA,lJ=p(),No=a("p"),No.innerHTML=IA,aJ=p(),zo=a("p"),zo.innerHTML=CA,nJ=p(),Eo=a("p"),Eo.textContent=vA,pJ=p(),Go=a("p"),Go.textContent=bA,oJ=p(),c(Wo.$$.fragment),iJ=p(),Ro=a("p"),Ro.innerHTML=AA,MJ=p(),c(Xo.$$.fragment),uJ=p(),c(Je.$$.fragment),rJ=p(),Ho=a("p"),Ho.innerHTML=gA,cJ=p(),Qo=a("p"),Qo.innerHTML=_A,hJ=p(),c(Vo.$$.fragment),yJ=p(),Yo=a("p"),Yo.innerHTML=BA,jJ=p(),Lo=a("p"),Lo.innerHTML=ZA,dJ=p(),Fo=a("p"),Fo.textContent=xA,TJ=p(),c(Po.$$.fragment),wJ=p(),Do=a("p"),Do.innerHTML=qA,JJ=p(),c(Oo.$$.fragment),UJ=p(),Ko=a("p"),Ko.innerHTML=kA,mJ=p(),ti=a("p"),ti.textContent=SA,fJ=p(),ei=a("p"),ei.innerHTML=$A,IJ=p(),si=a("p"),si.innerHTML=NA,CJ=p(),li=a("p"),li.textContent=zA,vJ=p(),Tt=a("h3"),Ue=a("a"),yc=a("span"),c(ai.$$.fragment),sI=p(),ar=a("span"),ar.textContent=EA,bJ=p(),ni=a("p"),ni.textContent=GA,AJ=p(),pi=a("p"),pi.textContent=WA,gJ=p(),oi=a("p"),oi.textContent=RA,_J=p(),wt=a("h4"),me=a("a"),jc=a("span"),c(ii.$$.fragment),lI=p(),nr=a("span"),nr.textContent=XA,BJ=p(),Mi=a("p"),Mi.innerHTML=HA,ZJ=p(),c(ui.$$.fragment),xJ=p(),ri=a("p"),ri.textContent=QA,qJ=p(),ci=a("p"),ci.innerHTML=VA,kJ=p(),c(hi.$$.fragment),SJ=p(),yi=a("p"),yi.innerHTML=YA,$J=p(),ji=a("p"),ji.textContent=LA,NJ=p(),di=a("p"),di.innerHTML=FA,zJ=p(),Ti=a("p"),Ti.innerHTML=PA,EJ=p(),Jt=a("h4"),fe=a("a"),dc=a("span"),c(wi.$$.fragment),aI=p(),pr=a("span"),pr.textContent=DA,GJ=p(),Ji=a("p"),Ji.innerHTML=OA,WJ=p(),Ui=a("p"),Ui.innerHTML=KA,RJ=p(),mi=a("p"),mi.textContent=tg,XJ=p(),c(fi.$$.fragment),HJ=p(),Ii=a("p"),Ii.innerHTML=eg,QJ=p(),or=a("a"),VJ=p(),Ut=a("h3"),Ie=a("a"),Tc=a("span"),c(Ci.$$.fragment),nI=p(),ir=a("span"),ir.textContent=sg,YJ=p(),vi=a("p"),vi.textContent=lg,LJ=p(),bi=a("p"),bi.innerHTML=ag,FJ=p(),c(Ai.$$.fragment),PJ=p(),gi=a("p"),gi.textContent=ng,DJ=p(),_i=a("p"),_i.innerHTML=pg,OJ=p(),c(Bi.$$.fragment),KJ=p(),Zi=a("p"),Zi.textContent=og,tU=p(),xi=a("p"),xi.textContent=ig,eU=p(),mt=a("h3"),Ce=a("a"),wc=a("span"),c(qi.$$.fragment),pI=p(),Mr=a("span"),Mr.textContent=Mg,sU=p(),ki=a("p"),ki.textContent=ug,lU=p(),Si=a("p"),Si.textContent=rg,aU=p(),c($i.$$.fragment),nU=p(),Ni=a("p"),Ni.textContent=cg,pU=p(),zi=a("p"),zi.textContent=hg,oU=p(),Ei=a("p"),Ei.textContent=yg,iU=p(),Gi=a("p"),Gi.textContent=jg,MU=p(),c(Wi.$$.fragment),uU=p(),Ri=a("p"),Ri.textContent=dg,rU=p(),Xi=a("p"),Xi.innerHTML=Tg,cU=p(),ft=a("h3"),ve=a("a"),Jc=a("span"),c(Hi.$$.fragment),oI=p(),ur=a("span"),ur.textContent=wg,hU=p(),Qi=a("p"),Qi.textContent=Jg,yU=p(),Vi=a("p"),Vi.textContent=Ug,jU=p(),C=a("ol"),rr=a("li"),rr.innerHTML=mg,iI=p(),cr=a("li"),cr.innerHTML=fg,MI=p(),Yi=a("li"),hr=a("p"),hr.textContent=Ig,uI=p(),c(Li.$$.fragment),rI=p(),yr=a("li"),yr.innerHTML=Cg,cI=p(),jr=a("li"),jr.innerHTML=vg,hI=p(),dr=a("li"),dr.innerHTML=bg,dU=p(),Fi=a("p"),Fi.textContent=Ag,TU=p(),Pi=a("ul"),Pi.innerHTML=gg,wU=p(),It=a("h3"),be=a("a"),Uc=a("span"),c(Di.$$.fragment),yI=p(),Tr=a("span"),Tr.textContent=_g,JU=p(),Ct=a("h4"),Ae=a("a"),mc=a("span"),c(Oi.$$.fragment),jI=p(),wr=a("span"),wr.innerHTML=Bg,UU=p(),Ki=a("p"),Ki.innerHTML=Zg,mU=p(),vt=a("h4"),ge=a("a"),fc=a("span"),c(tM.$$.fragment),dI=p(),Jr=a("span"),Jr.innerHTML=xg,fU=p(),eM=a("p"),eM.textContent=qg,IU=p(),sM=a("p"),sM.textContent=kg,CU=p(),c(lM.$$.fragment),vU=p(),aM=a("p"),aM.innerHTML=Sg,bU=p(),c(nM.$$.fragment),AU=p(),pM=a("p"),pM.textContent=$g,gU=p(),oM=a("p"),oM.textContent=Ng,_U=p(),iM=a("p"),iM.innerHTML=zg,BU=p(),bt=a("h3"),_e=a("a"),Ic=a("span"),c(MM.$$.fragment),TI=p(),Ur=a("span"),Ur.textContent=Eg,ZU=p(),uM=a("ul"),uM.innerHTML=Gg,xU=p(),At=a("h2"),Be=a("a"),Cc=a("span"),c(rM.$$.fragment),wI=p(),mr=a("span"),mr.textContent=Wg,qU=p(),cM=a("p"),cM.innerHTML=Rg,kU=p(),hM=a("p"),hM.innerHTML=Xg,SU=p(),yM=a("p"),yM.innerHTML=Hg,$U=p(),jM=a("p"),jM.innerHTML=Qg,NU=p(),dM=a("p"),dM.textContent=Vg,zU=p(),c(TM.$$.fragment),EU=p(),wM=a("p"),wM.textContent=Yg,GU=p(),c(JM.$$.fragment),WU=p(),UM=a("p"),UM.innerHTML=Lg,RU=p(),gt=a("h2"),Ze=a("a"),vc=a("span"),c(mM.$$.fragment),JI=p(),fr=a("span"),fr.textContent=Fg,XU=p(),g=a("div"),c(fM.$$.fragment),UI=p(),Ir=a("p"),Ir.textContent=Pg,mI=p(),Cr=a("p"),Cr.innerHTML=Dg,fI=p(),vr=a("p"),vr.innerHTML=Og,HU=p(),_t=a("h3"),xe=a("a"),bc=a("span"),c(IM.$$.fragment),II=p(),br=a("span"),br.textContent=Kg,QU=p(),CM=a("p"),CM.innerHTML=t_,VU=p(),vM=a("p"),vM.textContent=e_,YU=p(),bM=a("p"),bM.textContent=s_,LU=p(),AM=a("p"),AM.textContent=l_,FU=p(),gM=a("ol"),gM.innerHTML=a_,PU=p(),c(_M.$$.fragment),DU=p(),BM=a("p"),BM.innerHTML=n_,OU=p(),c(ZM.$$.fragment),KU=p(),xM=a("p"),xM.textContent=p_,tm=p(),Bt=a("h3"),qe=a("a"),Ac=a("span"),c(qM.$$.fragment),CI=p(),Ar=a("span"),Ar.innerHTML=o_,em=p(),kM=a("p"),kM.innerHTML=i_,sm=p(),SM=a("p"),SM.innerHTML=M_,lm=p(),Zt=a("h2"),ke=a("a"),gc=a("span"),c($M.$$.fragment),vI=p(),gr=a("span"),gr.textContent=u_,am=p(),NM=a("p"),NM.textContent=r_,nm=p(),zM=a("p"),zM.textContent=c_,pm=p(),c(EM.$$.fragment),om=p(),GM=a("p"),GM.textContent=h_,im=p(),c(WM.$$.fragment),Mm=p(),xt=a("h2"),Se=a("a"),_c=a("span"),c(RM.$$.fragment),bI=p(),_r=a("span"),_r.textContent=y_,um=p(),XM=a("ul"),XM.innerHTML=j_,rm=p(),HM=a("p"),HM.textContent=d_,cm=p(),QM=a("ul"),QM.innerHTML=T_,hm=p(),VM=a("p"),VM.innerHTML=w_,ym=p(),Bc=a("p"),this.h()},l(t){const s=f0("svelte-1phssyn",document.head);U=n(s,"META",{name:!0,content:!0}),s.forEach(e),v=o(t),m=n(t,"P",{}),r(m).forEach(e),I=o(t),_=n(t,"H1",{class:!0});var YM=r(_);b=n(YM,"A",{id:!0,class:!0,href:!0});var Zc=r(b);A=n(Zc,"SPAN",{});var xc=r(A);h(x.$$.fragment,xc),xc.forEach(e),Zc.forEach(e),f=o(YM),B=n(YM,"SPAN",{"data-svelte-h":!0}),i(B)!=="svelte-1lic8f4"&&(B.textContent=_I),YM.forEach(e),qc=o(t),Ne=n(t,"P",{"data-svelte-h":!0}),i(Ne)!=="svelte-4c3rde"&&(Ne.innerHTML=BI),kc=o(t),ze=n(t,"OL",{"data-svelte-h":!0}),i(ze)!=="svelte-12k6of1"&&(ze.innerHTML=ZI),Sc=o(t),Ee=n(t,"P",{"data-svelte-h":!0}),i(Ee)!=="svelte-1ipy5tt"&&(Ee.innerHTML=xI),$c=o(t),Ge=n(t,"P",{"data-svelte-h":!0}),i(Ge)!=="svelte-iaccrf"&&(Ge.textContent=qI),Nc=o(t),We=n(t,"P",{"data-svelte-h":!0}),i(We)!=="svelte-1jckdpk"&&(We.textContent=kI),zc=o(t),Re=n(t,"P",{"data-svelte-h":!0}),i(Re)!=="svelte-k3r8dh"&&(Re.innerHTML=SI),Ec=o(t),Xe=n(t,"OL",{"data-svelte-h":!0}),i(Xe)!=="svelte-37nnw5"&&(Xe.innerHTML=$I),Gc=o(t),He=n(t,"P",{"data-svelte-h":!0}),i(He)!=="svelte-1j61y1r"&&(He.textContent=NI),Wc=o(t),Qe=n(t,"P",{"data-svelte-h":!0}),i(Qe)!=="svelte-1igpel8"&&(Qe.textContent=zI),Rc=o(t),Ve=n(t,"OL",{"data-svelte-h":!0}),i(Ve)!=="svelte-lihws0"&&(Ve.innerHTML=EI),Xc=o(t),Ye=n(t,"P",{"data-svelte-h":!0}),i(Ye)!=="svelte-1i9b1jx"&&(Ye.textContent=GI),Hc=o(t),Le=n(t,"OL",{"data-svelte-h":!0}),i(Le)!=="svelte-ipbdbn"&&(Le.innerHTML=WI),Qc=o(t),Fe=n(t,"P",{"data-svelte-h":!0}),i(Fe)!=="svelte-1nlnufl"&&(Fe.textContent=RI),Vc=o(t),LM=n(t,"A",{id:!0}),r(LM).forEach(e),Yc=o(t),q=n(t,"H2",{class:!0});var dm=r(q);kt=n(dm,"A",{id:!0,class:!0,href:!0});var J_=r(kt);Zr=n(J_,"SPAN",{});var U_=r(Zr);h(Pe.$$.fragment,U_),U_.forEach(e),J_.forEach(e),Tf=o(dm),FM=n(dm,"SPAN",{"data-svelte-h":!0}),i(FM)!=="svelte-1wimwyd"&&(FM.textContent=XI),dm.forEach(e),Lc=o(t),PM=n(t,"A",{id:!0}),r(PM).forEach(e),Fc=o(t),k=n(t,"H3",{class:!0});var Tm=r(k);St=n(Tm,"A",{id:!0,class:!0,href:!0});var m_=r(St);xr=n(m_,"SPAN",{});var f_=r(xr);h(De.$$.fragment,f_),f_.forEach(e),m_.forEach(e),wf=o(Tm),DM=n(Tm,"SPAN",{"data-svelte-h":!0}),i(DM)!=="svelte-99g31l"&&(DM.textContent=HI),Tm.forEach(e),Pc=o(t),Oe=n(t,"P",{"data-svelte-h":!0}),i(Oe)!=="svelte-1vqjc6p"&&(Oe.textContent=QI),Dc=o(t),h(Ke.$$.fragment,t),Oc=o(t),ts=n(t,"P",{"data-svelte-h":!0}),i(ts)!=="svelte-1t82ll5"&&(ts.innerHTML=VI),Kc=o(t),h(es.$$.fragment,t),th=o(t),ss=n(t,"P",{"data-svelte-h":!0}),i(ss)!=="svelte-1cphooc"&&(ss.innerHTML=YI),eh=o(t),ls=n(t,"P",{"data-svelte-h":!0}),i(ls)!=="svelte-122yejb"&&(ls.innerHTML=LI),sh=o(t),as=n(t,"P",{"data-svelte-h":!0}),i(as)!=="svelte-1cymhp5"&&(as.textContent=FI),lh=o(t),ns=n(t,"P",{"data-svelte-h":!0}),i(ns)!=="svelte-168m9gp"&&(ns.textContent=PI),ah=o(t),h(ps.$$.fragment,t),nh=o(t),os=n(t,"P",{"data-svelte-h":!0}),i(os)!=="svelte-a7t4f9"&&(os.innerHTML=DI),ph=o(t),is=n(t,"P",{"data-svelte-h":!0}),i(is)!=="svelte-gl7s3y"&&(is.innerHTML=OI),oh=o(t),h(Ms.$$.fragment,t),ih=o(t),us=n(t,"P",{"data-svelte-h":!0}),i(us)!=="svelte-yu99fb"&&(us.innerHTML=KI),Mh=o(t),rs=n(t,"P",{"data-svelte-h":!0}),i(rs)!=="svelte-1ldirwe"&&(rs.textContent=tC),uh=o(t),h(cs.$$.fragment,t),rh=o(t),hs=n(t,"P",{"data-svelte-h":!0}),i(hs)!=="svelte-17wmgg8"&&(hs.innerHTML=eC),ch=o(t),ys=n(t,"P",{"data-svelte-h":!0}),i(ys)!=="svelte-1rxyat4"&&(ys.innerHTML=sC),hh=o(t),js=n(t,"P",{"data-svelte-h":!0}),i(js)!=="svelte-x5qy10"&&(js.innerHTML=lC),yh=o(t),ds=n(t,"P",{"data-svelte-h":!0}),i(ds)!=="svelte-1mgjr9n"&&(ds.textContent=aC),jh=o(t),h(Ts.$$.fragment,t),dh=o(t),ws=n(t,"P",{"data-svelte-h":!0}),i(ws)!=="svelte-5piew1"&&(ws.textContent=nC),Th=o(t),h(Js.$$.fragment,t),wh=o(t),Us=n(t,"P",{"data-svelte-h":!0}),i(Us)!=="svelte-1jhj7gz"&&(Us.textContent=pC),Jh=o(t),h(ms.$$.fragment,t),Uh=o(t),fs=n(t,"P",{"data-svelte-h":!0}),i(fs)!=="svelte-wulif7"&&(fs.innerHTML=oC),mh=o(t),Is=n(t,"P",{"data-svelte-h":!0}),i(Is)!=="svelte-1m52oc1"&&(Is.innerHTML=iC),fh=o(t),Cs=n(t,"P",{"data-svelte-h":!0}),i(Cs)!=="svelte-1bgh2n5"&&(Cs.innerHTML=MC),Ih=o(t),OM=n(t,"A",{id:!0}),r(OM).forEach(e),Ch=o(t),S=n(t,"H3",{class:!0});var wm=r(S);$t=n(wm,"A",{id:!0,class:!0,href:!0});var I_=r($t);qr=n(I_,"SPAN",{});var C_=r(qr);h(vs.$$.fragment,C_),C_.forEach(e),I_.forEach(e),Jf=o(wm),KM=n(wm,"SPAN",{"data-svelte-h":!0}),i(KM)!=="svelte-c8x1m1"&&(KM.textContent=uC),wm.forEach(e),vh=o(t),bs=n(t,"P",{"data-svelte-h":!0}),i(bs)!=="svelte-6fz81d"&&(bs.innerHTML=rC),bh=o(t),As=n(t,"P",{"data-svelte-h":!0}),i(As)!=="svelte-18nicry"&&(As.textContent=cC),Ah=o(t),h(gs.$$.fragment,t),gh=o(t),_s=n(t,"P",{"data-svelte-h":!0}),i(_s)!=="svelte-1xbc0kp"&&(_s.innerHTML=hC),_h=o(t),h(Bs.$$.fragment,t),Bh=o(t),Zs=n(t,"P",{"data-svelte-h":!0}),i(Zs)!=="svelte-14y0009"&&(Zs.innerHTML=yC),Zh=o(t),xs=n(t,"P",{"data-svelte-h":!0}),i(xs)!=="svelte-4y3pxo"&&(xs.innerHTML=jC),xh=o(t),qs=n(t,"P",{"data-svelte-h":!0}),i(qs)!=="svelte-1jem9f9"&&(qs.innerHTML=dC),qh=o(t),h(ks.$$.fragment,t),kh=o(t),Ss=n(t,"P",{"data-svelte-h":!0}),i(Ss)!=="svelte-1hk3m2d"&&(Ss.innerHTML=TC),Sh=o(t),$s=n(t,"P",{"data-svelte-h":!0}),i($s)!=="svelte-1r95sq9"&&($s.innerHTML=wC),$h=o(t),tu=n(t,"A",{id:!0}),r(tu).forEach(e),Nh=o(t),$=n(t,"H3",{class:!0});var Jm=r($);Nt=n(Jm,"A",{id:!0,class:!0,href:!0});var v_=r(Nt);kr=n(v_,"SPAN",{});var b_=r(kr);h(Ns.$$.fragment,b_),b_.forEach(e),v_.forEach(e),Uf=o(Jm),eu=n(Jm,"SPAN",{"data-svelte-h":!0}),i(eu)!=="svelte-1uq9afk"&&(eu.textContent=JC),Jm.forEach(e),zh=o(t),zs=n(t,"P",{"data-svelte-h":!0}),i(zs)!=="svelte-1l4w8w"&&(zs.innerHTML=UC),Eh=o(t),h(Es.$$.fragment,t),Gh=o(t),Gs=n(t,"P",{"data-svelte-h":!0}),i(Gs)!=="svelte-1xjofrh"&&(Gs.innerHTML=mC),Wh=o(t),Ws=n(t,"P",{"data-svelte-h":!0}),i(Ws)!=="svelte-3lttbu"&&(Ws.textContent=fC),Rh=o(t),Rs=n(t,"OL",{"data-svelte-h":!0}),i(Rs)!=="svelte-11yg5ud"&&(Rs.innerHTML=IC),Xh=o(t),Xs=n(t,"P",{"data-svelte-h":!0}),i(Xs)!=="svelte-1ynxwf6"&&(Xs.textContent=CC),Hh=o(t),h(Hs.$$.fragment,t),Qh=o(t),Qs=n(t,"P",{"data-svelte-h":!0}),i(Qs)!=="svelte-1w20i2l"&&(Qs.textContent=vC),Vh=o(t),Vs=n(t,"P",{"data-svelte-h":!0}),i(Vs)!=="svelte-1cjih2x"&&(Vs.innerHTML=bC),Yh=o(t),Ys=n(t,"P",{"data-svelte-h":!0}),i(Ys)!=="svelte-1vjeo35"&&(Ys.textContent=AC),Lh=o(t),Ls=n(t,"P",{"data-svelte-h":!0}),i(Ls)!=="svelte-1biq3pv"&&(Ls.textContent=gC),Fh=o(t),su=n(t,"UL",{});var A_=r(su);N=n(A_,"LI",{});var Br=r(N);lu=n(Br,"P",{"data-svelte-h":!0}),i(lu)!=="svelte-t6dru4"&&(lu.innerHTML=_C),mf=o(Br),h(Fs.$$.fragment,Br),ff=o(Br),au=n(Br,"P",{"data-svelte-h":!0}),i(au)!=="svelte-1qlwfj"&&(au.textContent=BC),Br.forEach(e),A_.forEach(e),Ph=o(t),nu=n(t,"A",{id:!0}),r(nu).forEach(e),Dh=o(t),z=n(t,"H3",{class:!0});var Um=r(z);zt=n(Um,"A",{id:!0,class:!0,href:!0});var g_=r(zt);Sr=n(g_,"SPAN",{});var __=r(Sr);h(Ps.$$.fragment,__),__.forEach(e),g_.forEach(e),If=o(Um),pu=n(Um,"SPAN",{"data-svelte-h":!0}),i(pu)!=="svelte-7bes0v"&&(pu.textContent=ZC),Um.forEach(e),Oh=o(t),Ds=n(t,"P",{"data-svelte-h":!0}),i(Ds)!=="svelte-1qsnpa1"&&(Ds.innerHTML=xC),Kh=o(t),Os=n(t,"P",{"data-svelte-h":!0}),i(Os)!=="svelte-84g6lv"&&(Os.innerHTML=qC),ty=o(t),E=n(t,"H4",{class:!0});var mm=r(E);Et=n(mm,"A",{id:!0,class:!0,href:!0});var B_=r(Et);$r=n(B_,"SPAN",{});var Z_=r($r);h(Ks.$$.fragment,Z_),Z_.forEach(e),B_.forEach(e),Cf=o(mm),ou=n(mm,"SPAN",{"data-svelte-h":!0}),i(ou)!=="svelte-nkssis"&&(ou.textContent=kC),mm.forEach(e),ey=o(t),tl=n(t,"P",{"data-svelte-h":!0}),i(tl)!=="svelte-dh13n7"&&(tl.innerHTML=SC),sy=o(t),h(el.$$.fragment,t),ly=o(t),sl=n(t,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-kk9ioq"&&(sl.textContent=$C),ay=o(t),ll=n(t,"P",{"data-svelte-h":!0}),i(ll)!=="svelte-bk7isu"&&(ll.innerHTML=NC),ny=o(t),G=n(t,"H4",{class:!0});var fm=r(G);Gt=n(fm,"A",{id:!0,class:!0,href:!0});var x_=r(Gt);Nr=n(x_,"SPAN",{});var q_=r(Nr);h(al.$$.fragment,q_),q_.forEach(e),x_.forEach(e),vf=o(fm),iu=n(fm,"SPAN",{"data-svelte-h":!0}),i(iu)!=="svelte-1o366dr"&&(iu.textContent=zC),fm.forEach(e),py=o(t),nl=n(t,"P",{"data-svelte-h":!0}),i(nl)!=="svelte-1u51h9h"&&(nl.innerHTML=EC),oy=o(t),h(pl.$$.fragment,t),iy=o(t),ol=n(t,"P",{"data-svelte-h":!0}),i(ol)!=="svelte-1ipwpw9"&&(ol.textContent=GC),My=o(t),h(il.$$.fragment,t),uy=o(t),Ml=n(t,"P",{"data-svelte-h":!0}),i(Ml)!=="svelte-1c219ul"&&(Ml.innerHTML=WC),ry=o(t),ul=n(t,"P",{"data-svelte-h":!0}),i(ul)!=="svelte-1pc2cg3"&&(ul.innerHTML=RC),cy=o(t),W=n(t,"H4",{class:!0});var Im=r(W);Wt=n(Im,"A",{id:!0,class:!0,href:!0});var k_=r(Wt);zr=n(k_,"SPAN",{});var S_=r(zr);h(rl.$$.fragment,S_),S_.forEach(e),k_.forEach(e),bf=o(Im),Mu=n(Im,"SPAN",{"data-svelte-h":!0}),i(Mu)!=="svelte-1cfopbu"&&(Mu.textContent=XC),Im.forEach(e),hy=o(t),cl=n(t,"P",{"data-svelte-h":!0}),i(cl)!=="svelte-7vonjg"&&(cl.innerHTML=HC),yy=o(t),h(hl.$$.fragment,t),jy=o(t),yl=n(t,"P",{"data-svelte-h":!0}),i(yl)!=="svelte-yis0vn"&&(yl.textContent=QC),dy=o(t),h(jl.$$.fragment,t),Ty=o(t),dl=n(t,"P",{"data-svelte-h":!0}),i(dl)!=="svelte-5wrpqf"&&(dl.innerHTML=VC),wy=o(t),R=n(t,"H4",{class:!0});var Cm=r(R);Rt=n(Cm,"A",{id:!0,class:!0,href:!0});var $_=r(Rt);Er=n($_,"SPAN",{});var N_=r(Er);h(Tl.$$.fragment,N_),N_.forEach(e),$_.forEach(e),Af=o(Cm),uu=n(Cm,"SPAN",{"data-svelte-h":!0}),i(uu)!=="svelte-pziohz"&&(uu.textContent=YC),Cm.forEach(e),Jy=o(t),wl=n(t,"P",{"data-svelte-h":!0}),i(wl)!=="svelte-10606ys"&&(wl.innerHTML=LC),Uy=o(t),h(Jl.$$.fragment,t),my=o(t),Ul=n(t,"P",{"data-svelte-h":!0}),i(Ul)!=="svelte-ktgnld"&&(Ul.innerHTML=FC),fy=o(t),ru=n(t,"A",{id:!0}),r(ru).forEach(e),Iy=o(t),X=n(t,"H3",{class:!0});var vm=r(X);Xt=n(vm,"A",{id:!0,class:!0,href:!0});var z_=r(Xt);Gr=n(z_,"SPAN",{});var E_=r(Gr);h(ml.$$.fragment,E_),E_.forEach(e),z_.forEach(e),gf=o(vm),cu=n(vm,"SPAN",{"data-svelte-h":!0}),i(cu)!=="svelte-15l4irb"&&(cu.textContent=PC),vm.forEach(e),Cy=o(t),fl=n(t,"P",{"data-svelte-h":!0}),i(fl)!=="svelte-1gplil1"&&(fl.innerHTML=DC),vy=o(t),Il=n(t,"P",{"data-svelte-h":!0}),i(Il)!=="svelte-rsdc5h"&&(Il.textContent=OC),by=o(t),h(Cl.$$.fragment,t),Ay=o(t),vl=n(t,"P",{"data-svelte-h":!0}),i(vl)!=="svelte-1ehkqs4"&&(vl.innerHTML=KC),gy=o(t),bl=n(t,"P",{"data-svelte-h":!0}),i(bl)!=="svelte-1valkuq"&&(bl.textContent=tv),_y=o(t),Al=n(t,"P",{"data-svelte-h":!0}),i(Al)!=="svelte-1714474"&&(Al.textContent=ev),By=o(t),h(gl.$$.fragment,t),Zy=o(t),_l=n(t,"P",{"data-svelte-h":!0}),i(_l)!=="svelte-nh20cz"&&(_l.innerHTML=sv),xy=o(t),h(Bl.$$.fragment,t),qy=o(t),Zl=n(t,"P",{"data-svelte-h":!0}),i(Zl)!=="svelte-2zmg66"&&(Zl.innerHTML=lv),ky=o(t),h(xl.$$.fragment,t),Sy=o(t),ql=n(t,"P",{"data-svelte-h":!0}),i(ql)!=="svelte-tgm4xl"&&(ql.textContent=av),$y=o(t),kl=n(t,"P",{"data-svelte-h":!0}),i(kl)!=="svelte-5k5wyb"&&(kl.innerHTML=nv),Ny=o(t),hu=n(t,"A",{id:!0}),r(hu).forEach(e),zy=o(t),H=n(t,"H3",{class:!0});var bm=r(H);Ht=n(bm,"A",{id:!0,class:!0,href:!0});var G_=r(Ht);Wr=n(G_,"SPAN",{});var W_=r(Wr);h(Sl.$$.fragment,W_),W_.forEach(e),G_.forEach(e),_f=o(bm),yu=n(bm,"SPAN",{"data-svelte-h":!0}),i(yu)!=="svelte-13rze9p"&&(yu.textContent=pv),bm.forEach(e),Ey=o(t),$l=n(t,"P",{"data-svelte-h":!0}),i($l)!=="svelte-1twydg2"&&($l.innerHTML=ov),Gy=o(t),Nl=n(t,"P",{"data-svelte-h":!0}),i(Nl)!=="svelte-1mc0tbi"&&(Nl.innerHTML=iv),Wy=o(t),h(zl.$$.fragment,t),Ry=o(t),El=n(t,"P",{"data-svelte-h":!0}),i(El)!=="svelte-jyv2rl"&&(El.innerHTML=Mv),Xy=o(t),h(Gl.$$.fragment,t),Hy=o(t),Wl=n(t,"P",{"data-svelte-h":!0}),i(Wl)!=="svelte-1cqg1x2"&&(Wl.innerHTML=uv),Qy=o(t),Rl=n(t,"P",{"data-svelte-h":!0}),i(Rl)!=="svelte-1ledwpo"&&(Rl.textContent=rv),Vy=o(t),Xl=n(t,"P",{"data-svelte-h":!0}),i(Xl)!=="svelte-1hl5ia"&&(Xl.innerHTML=cv),Yy=o(t),h(Hl.$$.fragment,t),Ly=o(t),Ql=n(t,"P",{"data-svelte-h":!0}),i(Ql)!=="svelte-1xjzvon"&&(Ql.innerHTML=hv),Fy=o(t),ju=n(t,"A",{id:!0}),r(ju).forEach(e),Py=o(t),Q=n(t,"H3",{class:!0});var Am=r(Q);Qt=n(Am,"A",{id:!0,class:!0,href:!0});var R_=r(Qt);Rr=n(R_,"SPAN",{});var X_=r(Rr);h(Vl.$$.fragment,X_),X_.forEach(e),R_.forEach(e),Bf=o(Am),du=n(Am,"SPAN",{"data-svelte-h":!0}),i(du)!=="svelte-1b2d1ni"&&(du.textContent=yv),Am.forEach(e),Dy=o(t),Yl=n(t,"P",{"data-svelte-h":!0}),i(Yl)!=="svelte-bt1le2"&&(Yl.innerHTML=jv),Oy=o(t),Ll=n(t,"P",{"data-svelte-h":!0}),i(Ll)!=="svelte-1ixfnm8"&&(Ll.textContent=dv),Ky=o(t),h(Fl.$$.fragment,t),tj=o(t),Pl=n(t,"P",{"data-svelte-h":!0}),i(Pl)!=="svelte-ylttvt"&&(Pl.textContent=Tv),ej=o(t),h(Dl.$$.fragment,t),sj=o(t),Tu=n(t,"A",{id:!0}),r(Tu).forEach(e),lj=o(t),V=n(t,"H3",{class:!0});var gm=r(V);Vt=n(gm,"A",{id:!0,class:!0,href:!0});var H_=r(Vt);Xr=n(H_,"SPAN",{});var Q_=r(Xr);h(Ol.$$.fragment,Q_),Q_.forEach(e),H_.forEach(e),Zf=o(gm),wu=n(gm,"SPAN",{"data-svelte-h":!0}),i(wu)!=="svelte-6ijmbs"&&(wu.textContent=wv),gm.forEach(e),aj=o(t),h(Yt.$$.fragment,t),nj=o(t),Kl=n(t,"P",{"data-svelte-h":!0}),i(Kl)!=="svelte-qc8pco"&&(Kl.innerHTML=Jv),pj=o(t),ta=n(t,"P",{"data-svelte-h":!0}),i(ta)!=="svelte-tuthc4"&&(ta.innerHTML=Uv),oj=o(t),ea=n(t,"P",{"data-svelte-h":!0}),i(ea)!=="svelte-1uzrs78"&&(ea.innerHTML=mv),ij=o(t),sa=n(t,"P",{"data-svelte-h":!0}),i(sa)!=="svelte-969ltr"&&(sa.textContent=fv),Mj=o(t),la=n(t,"P",{"data-svelte-h":!0}),i(la)!=="svelte-o4tec"&&(la.innerHTML=Iv),uj=o(t),aa=n(t,"OL",{"data-svelte-h":!0}),i(aa)!=="svelte-corzwe"&&(aa.innerHTML=Cv),rj=o(t),na=n(t,"P",{"data-svelte-h":!0}),i(na)!=="svelte-3vclli"&&(na.innerHTML=vv),cj=o(t),Ju=n(t,"A",{id:!0}),r(Ju).forEach(e),hj=o(t),Y=n(t,"H3",{class:!0});var _m=r(Y);Lt=n(_m,"A",{id:!0,class:!0,href:!0});var V_=r(Lt);Hr=n(V_,"SPAN",{});var Y_=r(Hr);h(pa.$$.fragment,Y_),Y_.forEach(e),V_.forEach(e),xf=o(_m),Uu=n(_m,"SPAN",{"data-svelte-h":!0}),i(Uu)!=="svelte-1a8ad23"&&(Uu.textContent=bv),_m.forEach(e),yj=o(t),oa=n(t,"P",{"data-svelte-h":!0}),i(oa)!=="svelte-24gsuk"&&(oa.innerHTML=Av),jj=o(t),ia=n(t,"P",{"data-svelte-h":!0}),i(ia)!=="svelte-878q4m"&&(ia.innerHTML=gv),dj=o(t),Ma=n(t,"P",{"data-svelte-h":!0}),i(Ma)!=="svelte-1euozwd"&&(Ma.innerHTML=_v),Tj=o(t),ua=n(t,"P",{"data-svelte-h":!0}),i(ua)!=="svelte-107618e"&&(ua.textContent=Bv),wj=o(t),mu=n(t,"A",{id:!0}),r(mu).forEach(e),Jj=o(t),L=n(t,"H4",{class:!0});var Bm=r(L);Ft=n(Bm,"A",{id:!0,class:!0,href:!0});var L_=r(Ft);Qr=n(L_,"SPAN",{});var F_=r(Qr);h(ra.$$.fragment,F_),F_.forEach(e),L_.forEach(e),qf=o(Bm),fu=n(Bm,"SPAN",{"data-svelte-h":!0}),i(fu)!=="svelte-1avgapi"&&(fu.textContent=Zv),Bm.forEach(e),Uj=o(t),ca=n(t,"P",{"data-svelte-h":!0}),i(ca)!=="svelte-15jy11l"&&(ca.textContent=xv),mj=o(t),h(ha.$$.fragment,t),fj=o(t),ya=n(t,"P",{"data-svelte-h":!0}),i(ya)!=="svelte-1fr2k06"&&(ya.innerHTML=qv),Ij=o(t),ja=n(t,"UL",{"data-svelte-h":!0}),i(ja)!=="svelte-1dbs24o"&&(ja.innerHTML=kv),Cj=o(t),da=n(t,"P",{"data-svelte-h":!0}),i(da)!=="svelte-qsswlv"&&(da.innerHTML=Sv),vj=o(t),h(Ta.$$.fragment,t),bj=o(t),wa=n(t,"P",{"data-svelte-h":!0}),i(wa)!=="svelte-1w7z5ow"&&(wa.textContent=$v),Aj=o(t),Iu=n(t,"A",{id:!0}),r(Iu).forEach(e),gj=o(t),F=n(t,"H4",{class:!0});var Zm=r(F);Pt=n(Zm,"A",{id:!0,class:!0,href:!0});var P_=r(Pt);Vr=n(P_,"SPAN",{});var D_=r(Vr);h(Ja.$$.fragment,D_),D_.forEach(e),P_.forEach(e),kf=o(Zm),Cu=n(Zm,"SPAN",{"data-svelte-h":!0}),i(Cu)!=="svelte-13g2wsv"&&(Cu.textContent=Nv),Zm.forEach(e),_j=o(t),Ua=n(t,"P",{"data-svelte-h":!0}),i(Ua)!=="svelte-1tebs8m"&&(Ua.textContent=zv),Bj=o(t),h(ma.$$.fragment,t),Zj=o(t),fa=n(t,"P",{"data-svelte-h":!0}),i(fa)!=="svelte-1g2nab0"&&(fa.innerHTML=Ev),xj=o(t),Ia=n(t,"P",{"data-svelte-h":!0}),i(Ia)!=="svelte-ko8r4h"&&(Ia.innerHTML=Gv),qj=o(t),Ca=n(t,"P",{"data-svelte-h":!0}),i(Ca)!=="svelte-1fr2k06"&&(Ca.innerHTML=Wv),kj=o(t),va=n(t,"UL",{"data-svelte-h":!0}),i(va)!=="svelte-l43e63"&&(va.innerHTML=Rv),Sj=o(t),ba=n(t,"P",{"data-svelte-h":!0}),i(ba)!=="svelte-pylq8y"&&(ba.innerHTML=Xv),$j=o(t),Aa=n(t,"P",{"data-svelte-h":!0}),i(Aa)!=="svelte-1x1c6u9"&&(Aa.innerHTML=Hv),Nj=o(t),ga=n(t,"P",{"data-svelte-h":!0}),i(ga)!=="svelte-p0gfl6"&&(ga.textContent=Qv),zj=o(t),_a=n(t,"UL",{"data-svelte-h":!0}),i(_a)!=="svelte-1iwv2ux"&&(_a.innerHTML=Vv),Ej=o(t),Ba=n(t,"P",{"data-svelte-h":!0}),i(Ba)!=="svelte-4fqkxc"&&(Ba.innerHTML=Yv),Gj=o(t),Za=n(t,"P",{"data-svelte-h":!0}),i(Za)!=="svelte-2klf7u"&&(Za.innerHTML=Lv),Wj=o(t),xa=n(t,"P",{"data-svelte-h":!0}),i(xa)!=="svelte-qdu2k0"&&(xa.innerHTML=Fv),Rj=o(t),qa=n(t,"UL",{"data-svelte-h":!0}),i(qa)!=="svelte-1a9ucw0"&&(qa.innerHTML=Pv),Xj=o(t),ka=n(t,"P",{"data-svelte-h":!0}),i(ka)!=="svelte-1h39ux0"&&(ka.innerHTML=Dv),Hj=o(t),Sa=n(t,"P",{"data-svelte-h":!0}),i(Sa)!=="svelte-1ykp0a6"&&(Sa.innerHTML=Ov),Qj=o(t),$a=n(t,"OL",{"data-svelte-h":!0}),i($a)!=="svelte-184i5cb"&&($a.innerHTML=Kv),Vj=o(t),P=n(t,"H4",{class:!0});var xm=r(P);Dt=n(xm,"A",{id:!0,class:!0,href:!0});var O_=r(Dt);Yr=n(O_,"SPAN",{});var K_=r(Yr);h(Na.$$.fragment,K_),K_.forEach(e),O_.forEach(e),Sf=o(xm),vu=n(xm,"SPAN",{"data-svelte-h":!0}),i(vu)!=="svelte-qzbsqk"&&(vu.textContent=t1),xm.forEach(e),Yj=o(t),za=n(t,"P",{"data-svelte-h":!0}),i(za)!=="svelte-d6yedb"&&(za.textContent=e1),Lj=o(t),Ea=n(t,"P",{"data-svelte-h":!0}),i(Ea)!=="svelte-1vpgrfa"&&(Ea.textContent=s1),Fj=o(t),h(Ga.$$.fragment,t),Pj=o(t),Wa=n(t,"P",{"data-svelte-h":!0}),i(Wa)!=="svelte-1o9ymaq"&&(Wa.textContent=l1),Dj=o(t),D=n(t,"H4",{class:!0});var qm=r(D);Ot=n(qm,"A",{id:!0,class:!0,href:!0});var t2=r(Ot);Lr=n(t2,"SPAN",{});var e2=r(Lr);h(Ra.$$.fragment,e2),e2.forEach(e),t2.forEach(e),$f=o(qm),bu=n(qm,"SPAN",{"data-svelte-h":!0}),i(bu)!=="svelte-f23gg5"&&(bu.textContent=a1),qm.forEach(e),Oj=o(t),Xa=n(t,"P",{"data-svelte-h":!0}),i(Xa)!=="svelte-1mxfzxv"&&(Xa.textContent=n1),Kj=o(t),h(Ha.$$.fragment,t),td=o(t),Au=n(t,"A",{id:!0}),r(Au).forEach(e),ed=o(t),O=n(t,"H3",{class:!0});var km=r(O);Kt=n(km,"A",{id:!0,class:!0,href:!0});var s2=r(Kt);Fr=n(s2,"SPAN",{});var l2=r(Fr);h(Qa.$$.fragment,l2),l2.forEach(e),s2.forEach(e),Nf=o(km),gu=n(km,"SPAN",{"data-svelte-h":!0}),i(gu)!=="svelte-14ywl3a"&&(gu.textContent=p1),km.forEach(e),sd=o(t),Va=n(t,"P",{"data-svelte-h":!0}),i(Va)!=="svelte-169yzfh"&&(Va.textContent=o1),ld=o(t),Ya=n(t,"P",{"data-svelte-h":!0}),i(Ya)!=="svelte-4qz2m"&&(Ya.textContent=i1),ad=o(t),h(La.$$.fragment,t),nd=o(t),Fa=n(t,"P",{"data-svelte-h":!0}),i(Fa)!=="svelte-6el816"&&(Fa.innerHTML=M1),pd=o(t),Pa=n(t,"P",{"data-svelte-h":!0}),i(Pa)!=="svelte-muwnvs"&&(Pa.innerHTML=u1),od=o(t),Da=n(t,"P",{"data-svelte-h":!0}),i(Da)!=="svelte-1xgzrsc"&&(Da.innerHTML=r1),id=o(t),Oa=n(t,"P",{"data-svelte-h":!0}),i(Oa)!=="svelte-f73cj8"&&(Oa.innerHTML=c1),Md=o(t),_u=n(t,"A",{id:!0}),r(_u).forEach(e),ud=o(t),K=n(t,"H4",{class:!0});var Sm=r(K);te=n(Sm,"A",{id:!0,class:!0,href:!0});var a2=r(te);Pr=n(a2,"SPAN",{});var n2=r(Pr);h(Ka.$$.fragment,n2),n2.forEach(e),a2.forEach(e),zf=o(Sm),Bu=n(Sm,"SPAN",{"data-svelte-h":!0}),i(Bu)!=="svelte-13y7y3t"&&(Bu.textContent=h1),Sm.forEach(e),rd=o(t),tn=n(t,"P",{"data-svelte-h":!0}),i(tn)!=="svelte-q8gcrr"&&(tn.textContent=y1),cd=o(t),en=n(t,"P",{"data-svelte-h":!0}),i(en)!=="svelte-zjlf7h"&&(en.textContent=j1),hd=o(t),sn=n(t,"UL",{"data-svelte-h":!0}),i(sn)!=="svelte-11ygmoj"&&(sn.innerHTML=d1),yd=o(t),ln=n(t,"P",{"data-svelte-h":!0}),i(ln)!=="svelte-jwn0zz"&&(ln.innerHTML=T1),jd=o(t),Zu=n(t,"A",{id:!0}),r(Zu).forEach(e),dd=o(t),tt=n(t,"H4",{class:!0});var $m=r(tt);ee=n($m,"A",{id:!0,class:!0,href:!0});var p2=r(ee);Dr=n(p2,"SPAN",{});var o2=r(Dr);h(an.$$.fragment,o2),o2.forEach(e),p2.forEach(e),Ef=o($m),xu=n($m,"SPAN",{"data-svelte-h":!0}),i(xu)!=="svelte-19b1hxk"&&(xu.textContent=w1),$m.forEach(e),Td=o(t),nn=n(t,"P",{"data-svelte-h":!0}),i(nn)!=="svelte-kggmat"&&(nn.innerHTML=J1),wd=o(t),h(pn.$$.fragment,t),Jd=o(t),on=n(t,"P",{"data-svelte-h":!0}),i(on)!=="svelte-1iwd1rz"&&(on.innerHTML=U1),Ud=o(t),h(Mn.$$.fragment,t),md=o(t),qu=n(t,"A",{id:!0}),r(qu).forEach(e),fd=o(t),et=n(t,"H4",{class:!0});var Nm=r(et);se=n(Nm,"A",{id:!0,class:!0,href:!0});var i2=r(se);Or=n(i2,"SPAN",{});var M2=r(Or);h(un.$$.fragment,M2),M2.forEach(e),i2.forEach(e),Gf=o(Nm),ku=n(Nm,"SPAN",{"data-svelte-h":!0}),i(ku)!=="svelte-1fgzuzl"&&(ku.textContent=m1),Nm.forEach(e),Id=o(t),rn=n(t,"P",{"data-svelte-h":!0}),i(rn)!=="svelte-1rafa19"&&(rn.innerHTML=f1),Cd=o(t),h(cn.$$.fragment,t),vd=o(t),hn=n(t,"P",{"data-svelte-h":!0}),i(hn)!=="svelte-1enkn00"&&(hn.innerHTML=I1),bd=o(t),h(yn.$$.fragment,t),Ad=o(t),st=n(t,"H4",{class:!0});var zm=r(st);le=n(zm,"A",{id:!0,class:!0,href:!0});var u2=r(le);Kr=n(u2,"SPAN",{});var r2=r(Kr);h(jn.$$.fragment,r2),r2.forEach(e),u2.forEach(e),Wf=o(zm),Su=n(zm,"SPAN",{"data-svelte-h":!0}),i(Su)!=="svelte-nk1vj8"&&(Su.textContent=C1),zm.forEach(e),gd=o(t),dn=n(t,"P",{"data-svelte-h":!0}),i(dn)!=="svelte-qfhyy9"&&(dn.textContent=v1),_d=o(t),Tn=n(t,"P",{"data-svelte-h":!0}),i(Tn)!=="svelte-16uf65b"&&(Tn.textContent=b1),Bd=o(t),wn=n(t,"UL",{"data-svelte-h":!0}),i(wn)!=="svelte-1j4sbsl"&&(wn.innerHTML=A1),Zd=o(t),Jn=n(t,"P",{"data-svelte-h":!0}),i(Jn)!=="svelte-1ab7r8x"&&(Jn.textContent=g1),xd=o(t),Un=n(t,"UL",{"data-svelte-h":!0}),i(Un)!=="svelte-covk0c"&&(Un.innerHTML=_1),qd=o(t),mn=n(t,"P",{"data-svelte-h":!0}),i(mn)!=="svelte-4dwozd"&&(mn.textContent=B1),kd=o(t),fn=n(t,"P",{"data-svelte-h":!0}),i(fn)!=="svelte-1dr92i0"&&(fn.textContent=Z1),Sd=o(t),In=n(t,"P",{"data-svelte-h":!0}),i(In)!=="svelte-t7pxdh"&&(In.textContent=x1),$d=o(t),Cn=n(t,"OL",{"data-svelte-h":!0}),i(Cn)!=="svelte-287qs6"&&(Cn.innerHTML=q1),Nd=o(t),vn=n(t,"P",{"data-svelte-h":!0}),i(vn)!=="svelte-16perix"&&(vn.textContent=k1),zd=o(t),bn=n(t,"P",{"data-svelte-h":!0}),i(bn)!=="svelte-1dtmptu"&&(bn.textContent=S1),Ed=o(t),An=n(t,"P",{"data-svelte-h":!0}),i(An)!=="svelte-1sz5y3k"&&(An.textContent=$1),Gd=o(t),gn=n(t,"P",{"data-svelte-h":!0}),i(gn)!=="svelte-1yer2s4"&&(gn.textContent=N1),Wd=o(t),_n=n(t,"P",{"data-svelte-h":!0}),i(_n)!=="svelte-1my41ql"&&(_n.textContent=z1),Rd=o(t),Bn=n(t,"P",{"data-svelte-h":!0}),i(Bn)!=="svelte-10a65tx"&&(Bn.innerHTML=E1),Xd=o(t),Zn=n(t,"P",{"data-svelte-h":!0}),i(Zn)!=="svelte-11pyqnf"&&(Zn.textContent=G1),Hd=o(t),xn=n(t,"UL",{"data-svelte-h":!0}),i(xn)!=="svelte-1d88xai"&&(xn.innerHTML=W1),Qd=o(t),lt=n(t,"H3",{class:!0});var Em=r(lt);ae=n(Em,"A",{id:!0,class:!0,href:!0});var c2=r(ae);tc=n(c2,"SPAN",{});var h2=r(tc);h(qn.$$.fragment,h2),h2.forEach(e),c2.forEach(e),Rf=o(Em),$u=n(Em,"SPAN",{"data-svelte-h":!0}),i($u)!=="svelte-15r7meo"&&($u.textContent=R1),Em.forEach(e),Vd=o(t),kn=n(t,"P",{"data-svelte-h":!0}),i(kn)!=="svelte-10cvgi7"&&(kn.textContent=X1),Yd=o(t),Sn=n(t,"P",{"data-svelte-h":!0}),i(Sn)!=="svelte-1w613qh"&&(Sn.textContent=H1),Ld=o(t),$n=n(t,"P",{"data-svelte-h":!0}),i($n)!=="svelte-s4wgap"&&($n.textContent=Q1),Fd=o(t),Nn=n(t,"P",{"data-svelte-h":!0}),i(Nn)!=="svelte-c067ql"&&(Nn.textContent=V1),Pd=o(t),zn=n(t,"OL",{"data-svelte-h":!0}),i(zn)!=="svelte-cglkiv"&&(zn.innerHTML=Y1),Dd=o(t),at=n(t,"H3",{class:!0});var Gm=r(at);ne=n(Gm,"A",{id:!0,class:!0,href:!0});var y2=r(ne);ec=n(y2,"SPAN",{});var j2=r(ec);h(En.$$.fragment,j2),j2.forEach(e),y2.forEach(e),Xf=o(Gm),Nu=n(Gm,"SPAN",{"data-svelte-h":!0}),i(Nu)!=="svelte-1s1py7o"&&(Nu.textContent=L1),Gm.forEach(e),Od=o(t),Gn=n(t,"P",{"data-svelte-h":!0}),i(Gn)!=="svelte-1l8r1qw"&&(Gn.innerHTML=F1),Kd=o(t),Wn=n(t,"P",{"data-svelte-h":!0}),i(Wn)!=="svelte-1j4yh77"&&(Wn.textContent=P1),tT=o(t),Rn=n(t,"P",{"data-svelte-h":!0}),i(Rn)!=="svelte-10k5ql"&&(Rn.innerHTML=D1),eT=o(t),zu=n(t,"A",{id:!0}),r(zu).forEach(e),sT=o(t),nt=n(t,"H4",{class:!0});var Wm=r(nt);pe=n(Wm,"A",{id:!0,class:!0,href:!0});var d2=r(pe);sc=n(d2,"SPAN",{});var T2=r(sc);h(Xn.$$.fragment,T2),T2.forEach(e),d2.forEach(e),Hf=o(Wm),Eu=n(Wm,"SPAN",{"data-svelte-h":!0}),i(Eu)!=="svelte-1dh6glo"&&(Eu.textContent=O1),Wm.forEach(e),lT=o(t),Hn=n(t,"P",{"data-svelte-h":!0}),i(Hn)!=="svelte-zvvps7"&&(Hn.innerHTML=K1),aT=o(t),Qn=n(t,"P",{"data-svelte-h":!0}),i(Qn)!=="svelte-mfztmq"&&(Qn.innerHTML=tb),nT=o(t),Vn=n(t,"P",{"data-svelte-h":!0}),i(Vn)!=="svelte-qqxtuf"&&(Vn.innerHTML=eb),pT=o(t),h(Yn.$$.fragment,t),oT=o(t),Ln=n(t,"P",{"data-svelte-h":!0}),i(Ln)!=="svelte-1fu4tok"&&(Ln.textContent=sb),iT=o(t),Fn=n(t,"UL",{"data-svelte-h":!0}),i(Fn)!=="svelte-hhd3hb"&&(Fn.innerHTML=lb),MT=o(t),Pn=n(t,"P",{"data-svelte-h":!0}),i(Pn)!=="svelte-an845p"&&(Pn.textContent=ab),uT=o(t),Dn=n(t,"P",{"data-svelte-h":!0}),i(Dn)!=="svelte-ho8hoo"&&(Dn.textContent=nb),rT=o(t),h(On.$$.fragment,t),cT=o(t),Kn=n(t,"P",{"data-svelte-h":!0}),i(Kn)!=="svelte-5c9un9"&&(Kn.innerHTML=pb),hT=o(t),tp=n(t,"P",{"data-svelte-h":!0}),i(tp)!=="svelte-iuz4k6"&&(tp.textContent=ob),yT=o(t),h(ep.$$.fragment,t),jT=o(t),sp=n(t,"P",{"data-svelte-h":!0}),i(sp)!=="svelte-1f0ysyu"&&(sp.innerHTML=ib),dT=o(t),lp=n(t,"P",{"data-svelte-h":!0}),i(lp)!=="svelte-1o7ogjk"&&(lp.innerHTML=Mb),TT=o(t),h(ap.$$.fragment,t),wT=o(t),np=n(t,"P",{"data-svelte-h":!0}),i(np)!=="svelte-qrzd6x"&&(np.textContent=ub),JT=o(t),Gu=n(t,"A",{id:!0}),r(Gu).forEach(e),UT=o(t),pt=n(t,"H4",{class:!0});var Rm=r(pt);oe=n(Rm,"A",{id:!0,class:!0,href:!0});var w2=r(oe);lc=n(w2,"SPAN",{});var J2=r(lc);h(pp.$$.fragment,J2),J2.forEach(e),w2.forEach(e),Qf=o(Rm),Wu=n(Rm,"SPAN",{"data-svelte-h":!0}),i(Wu)!=="svelte-233ys6"&&(Wu.textContent=rb),Rm.forEach(e),mT=o(t),op=n(t,"P",{"data-svelte-h":!0}),i(op)!=="svelte-1bm7jil"&&(op.innerHTML=cb),fT=o(t),ip=n(t,"P",{"data-svelte-h":!0}),i(ip)!=="svelte-1cqsh10"&&(ip.textContent=hb),IT=o(t),Mp=n(t,"UL",{"data-svelte-h":!0}),i(Mp)!=="svelte-zirrsg"&&(Mp.innerHTML=yb),CT=o(t),up=n(t,"P",{"data-svelte-h":!0}),i(up)!=="svelte-1hqc6tg"&&(up.innerHTML=jb),vT=o(t),rp=n(t,"P",{"data-svelte-h":!0}),i(rp)!=="svelte-w55f7f"&&(rp.innerHTML=db),bT=o(t),h(cp.$$.fragment,t),AT=o(t),hp=n(t,"P",{"data-svelte-h":!0}),i(hp)!=="svelte-jaab18"&&(hp.innerHTML=Tb),gT=o(t),yp=n(t,"UL",{"data-svelte-h":!0}),i(yp)!=="svelte-gr31mi"&&(yp.innerHTML=wb),_T=o(t),jp=n(t,"P",{"data-svelte-h":!0}),i(jp)!=="svelte-17pyaox"&&(jp.textContent=Jb),BT=o(t),h(dp.$$.fragment,t),ZT=o(t),Tp=n(t,"P",{"data-svelte-h":!0}),i(Tp)!=="svelte-5c9un9"&&(Tp.innerHTML=Ub),xT=o(t),wp=n(t,"P",{"data-svelte-h":!0}),i(wp)!=="svelte-1lf5l3z"&&(wp.innerHTML=mb),qT=o(t),h(Jp.$$.fragment,t),kT=o(t),Up=n(t,"P",{"data-svelte-h":!0}),i(Up)!=="svelte-qnxoz2"&&(Up.innerHTML=fb),ST=o(t),Ru=n(t,"A",{id:!0}),r(Ru).forEach(e),$T=o(t),ot=n(t,"H3",{class:!0});var Xm=r(ot);ie=n(Xm,"A",{id:!0,class:!0,href:!0});var U2=r(ie);ac=n(U2,"SPAN",{});var m2=r(ac);h(mp.$$.fragment,m2),m2.forEach(e),U2.forEach(e),Vf=o(Xm),Xu=n(Xm,"SPAN",{"data-svelte-h":!0}),i(Xu)!=="svelte-qod654"&&(Xu.textContent=Ib),Xm.forEach(e),NT=o(t),fp=n(t,"P",{"data-svelte-h":!0}),i(fp)!=="svelte-1dvil4m"&&(fp.textContent=Cb),zT=o(t),Ip=n(t,"P",{"data-svelte-h":!0}),i(Ip)!=="svelte-m827p9"&&(Ip.innerHTML=vb),ET=o(t),h(Cp.$$.fragment,t),GT=o(t),vp=n(t,"P",{"data-svelte-h":!0}),i(vp)!=="svelte-bdy26k"&&(vp.innerHTML=bb),WT=o(t),bp=n(t,"P",{"data-svelte-h":!0}),i(bp)!=="svelte-kydp6d"&&(bp.innerHTML=Ab),RT=o(t),Hu=n(t,"A",{id:!0}),r(Hu).forEach(e),XT=o(t),it=n(t,"H3",{class:!0});var Hm=r(it);Me=n(Hm,"A",{id:!0,class:!0,href:!0});var f2=r(Me);nc=n(f2,"SPAN",{});var I2=r(nc);h(Ap.$$.fragment,I2),I2.forEach(e),f2.forEach(e),Yf=o(Hm),Qu=n(Hm,"SPAN",{"data-svelte-h":!0}),i(Qu)!=="svelte-dud1dr"&&(Qu.textContent=gb),Hm.forEach(e),HT=o(t),gp=n(t,"P",{"data-svelte-h":!0}),i(gp)!=="svelte-kybyhn"&&(gp.textContent=_b),QT=o(t),Mt=n(t,"H3",{class:!0});var Qm=r(Mt);ue=n(Qm,"A",{id:!0,class:!0,href:!0});var C2=r(ue);pc=n(C2,"SPAN",{});var v2=r(pc);h(_p.$$.fragment,v2),v2.forEach(e),C2.forEach(e),Lf=o(Qm),Vu=n(Qm,"SPAN",{"data-svelte-h":!0}),i(Vu)!=="svelte-1pscsni"&&(Vu.textContent=Bb),Qm.forEach(e),VT=o(t),Bp=n(t,"P",{"data-svelte-h":!0}),i(Bp)!=="svelte-cwa3yk"&&(Bp.textContent=Zb),YT=o(t),h(Zp.$$.fragment,t),LT=o(t),xp=n(t,"P",{"data-svelte-h":!0}),i(xp)!=="svelte-17nyuae"&&(xp.innerHTML=xb),FT=o(t),qp=n(t,"P",{"data-svelte-h":!0}),i(qp)!=="svelte-pmyaoj"&&(qp.innerHTML=qb),PT=o(t),kp=n(t,"P",{"data-svelte-h":!0}),i(kp)!=="svelte-1nyp904"&&(kp.textContent=kb),DT=o(t),h(Sp.$$.fragment,t),OT=o(t),$p=n(t,"P",{"data-svelte-h":!0}),i($p)!=="svelte-5c9un9"&&($p.innerHTML=Sb),KT=o(t),Np=n(t,"P",{"data-svelte-h":!0}),i(Np)!=="svelte-12xhtcc"&&(Np.innerHTML=$b),tw=o(t),ut=n(t,"H3",{class:!0});var Vm=r(ut);re=n(Vm,"A",{id:!0,class:!0,href:!0});var b2=r(re);oc=n(b2,"SPAN",{});var A2=r(oc);h(zp.$$.fragment,A2),A2.forEach(e),b2.forEach(e),Ff=o(Vm),Yu=n(Vm,"SPAN",{"data-svelte-h":!0}),i(Yu)!=="svelte-1e6xq08"&&(Yu.textContent=Nb),Vm.forEach(e),ew=o(t),Ep=n(t,"P",{"data-svelte-h":!0}),i(Ep)!=="svelte-169tzv7"&&(Ep.textContent=zb),sw=o(t),h(Gp.$$.fragment,t),lw=o(t),Wp=n(t,"P",{"data-svelte-h":!0}),i(Wp)!=="svelte-5n7z7p"&&(Wp.textContent=Eb),aw=o(t),Rp=n(t,"P",{"data-svelte-h":!0}),i(Rp)!=="svelte-1nldlad"&&(Rp.innerHTML=Gb),nw=o(t),Xp=n(t,"P",{"data-svelte-h":!0}),i(Xp)!=="svelte-1nyp904"&&(Xp.textContent=Wb),pw=o(t),h(Hp.$$.fragment,t),ow=o(t),h(ce.$$.fragment,t),iw=o(t),rt=n(t,"H3",{class:!0});var Ym=r(rt);he=n(Ym,"A",{id:!0,class:!0,href:!0});var g2=r(he);ic=n(g2,"SPAN",{});var _2=r(ic);h(Qp.$$.fragment,_2),_2.forEach(e),g2.forEach(e),Pf=o(Ym),Lu=n(Ym,"SPAN",{"data-svelte-h":!0}),i(Lu)!=="svelte-1q2hkne"&&(Lu.textContent=Rb),Ym.forEach(e),Mw=o(t),Vp=n(t,"P",{"data-svelte-h":!0}),i(Vp)!=="svelte-1u92iuj"&&(Vp.innerHTML=Xb),uw=o(t),Yp=n(t,"P",{"data-svelte-h":!0}),i(Yp)!=="svelte-86oqji"&&(Yp.innerHTML=Hb),rw=o(t),Lp=n(t,"P",{"data-svelte-h":!0}),i(Lp)!=="svelte-qbyzy7"&&(Lp.innerHTML=Qb),cw=o(t),Fp=n(t,"P",{"data-svelte-h":!0}),i(Fp)!=="svelte-jwyw4f"&&(Fp.textContent=Vb),hw=o(t),h(Pp.$$.fragment,t),yw=o(t),Dp=n(t,"P",{"data-svelte-h":!0}),i(Dp)!=="svelte-1o8aerk"&&(Dp.textContent=Yb),jw=o(t),Op=n(t,"P",{"data-svelte-h":!0}),i(Op)!=="svelte-1i0626v"&&(Op.innerHTML=Lb),dw=o(t),ct=n(t,"H3",{class:!0});var Lm=r(ct);ye=n(Lm,"A",{id:!0,class:!0,href:!0});var B2=r(ye);Mc=n(B2,"SPAN",{});var Z2=r(Mc);h(Kp.$$.fragment,Z2),Z2.forEach(e),B2.forEach(e),Df=o(Lm),Fu=n(Lm,"SPAN",{"data-svelte-h":!0}),i(Fu)!=="svelte-selbk5"&&(Fu.textContent=Fb),Lm.forEach(e),Tw=o(t),to=n(t,"P",{"data-svelte-h":!0}),i(to)!=="svelte-1iq1d9w"&&(to.textContent=Pb),ww=o(t),h(eo.$$.fragment,t),Jw=o(t),so=n(t,"P",{"data-svelte-h":!0}),i(so)!=="svelte-3cxpnx"&&(so.innerHTML=Db),Uw=o(t),lo=n(t,"P",{"data-svelte-h":!0}),i(lo)!=="svelte-1dbs7ls"&&(lo.innerHTML=Ob),mw=o(t),ao=n(t,"P",{"data-svelte-h":!0}),i(ao)!=="svelte-1h83nqw"&&(ao.textContent=Kb),fw=o(t),h(no.$$.fragment,t),Iw=o(t),po=n(t,"P",{"data-svelte-h":!0}),i(po)!=="svelte-5c9un9"&&(po.innerHTML=tA),Cw=o(t),oo=n(t,"P",{"data-svelte-h":!0}),i(oo)!=="svelte-5l4nm8"&&(oo.innerHTML=eA),vw=o(t),Pu=n(t,"A",{id:!0}),r(Pu).forEach(e),bw=o(t),ht=n(t,"H3",{class:!0});var Fm=r(ht);je=n(Fm,"A",{id:!0,class:!0,href:!0});var x2=r(je);uc=n(x2,"SPAN",{});var q2=r(uc);h(io.$$.fragment,q2),q2.forEach(e),x2.forEach(e),Of=o(Fm),Du=n(Fm,"SPAN",{"data-svelte-h":!0}),i(Du)!=="svelte-58t26m"&&(Du.textContent=sA),Fm.forEach(e),Aw=o(t),Mo=n(t,"P",{"data-svelte-h":!0}),i(Mo)!=="svelte-xs1yap"&&(Mo.textContent=lA),gw=o(t),h(uo.$$.fragment,t),_w=o(t),ro=n(t,"P",{"data-svelte-h":!0}),i(ro)!=="svelte-1fo4rub"&&(ro.innerHTML=aA),Bw=o(t),co=n(t,"P",{"data-svelte-h":!0}),i(co)!=="svelte-ho8hoo"&&(co.textContent=nA),Zw=o(t),h(ho.$$.fragment,t),xw=o(t),yo=n(t,"P",{"data-svelte-h":!0}),i(yo)!=="svelte-5c9un9"&&(yo.innerHTML=pA),qw=o(t),Ou=n(t,"A",{id:!0}),r(Ou).forEach(e),kw=o(t),yt=n(t,"H3",{class:!0});var Pm=r(yt);de=n(Pm,"A",{id:!0,class:!0,href:!0});var k2=r(de);rc=n(k2,"SPAN",{});var S2=r(rc);h(jo.$$.fragment,S2),S2.forEach(e),k2.forEach(e),Kf=o(Pm),Ku=n(Pm,"SPAN",{"data-svelte-h":!0}),i(Ku)!=="svelte-1hbfta0"&&(Ku.textContent=oA),Pm.forEach(e),Sw=o(t),To=n(t,"P",{"data-svelte-h":!0}),i(To)!=="svelte-117mynk"&&(To.textContent=iA),$w=o(t),h(wo.$$.fragment,t),Nw=o(t),Jo=n(t,"P",{"data-svelte-h":!0}),i(Jo)!=="svelte-ab7yny"&&(Jo.innerHTML=MA),zw=o(t),Uo=n(t,"P",{"data-svelte-h":!0}),i(Uo)!=="svelte-1ml0uo7"&&(Uo.textContent=uA),Ew=o(t),h(mo.$$.fragment,t),Gw=o(t),fo=n(t,"P",{"data-svelte-h":!0}),i(fo)!=="svelte-5c9un9"&&(fo.innerHTML=rA),Ww=o(t),tr=n(t,"A",{id:!0}),r(tr).forEach(e),Rw=o(t),jt=n(t,"H3",{class:!0});var Dm=r(jt);Te=n(Dm,"A",{id:!0,class:!0,href:!0});var $2=r(Te);cc=n($2,"SPAN",{});var N2=r(cc);h(Io.$$.fragment,N2),N2.forEach(e),$2.forEach(e),tI=o(Dm),er=n(Dm,"SPAN",{"data-svelte-h":!0}),i(er)!=="svelte-1bn076x"&&(er.textContent=cA),Dm.forEach(e),Xw=o(t),Co=n(t,"P",{"data-svelte-h":!0}),i(Co)!=="svelte-5w86or"&&(Co.textContent=hA),Hw=o(t),h(vo.$$.fragment,t),Qw=o(t),bo=n(t,"P",{"data-svelte-h":!0}),i(bo)!=="svelte-3undk2"&&(bo.innerHTML=yA),Vw=o(t),Ao=n(t,"P",{"data-svelte-h":!0}),i(Ao)!=="svelte-1ml0uo7"&&(Ao.textContent=jA),Yw=o(t),h(go.$$.fragment,t),Lw=o(t),_o=n(t,"P",{"data-svelte-h":!0}),i(_o)!=="svelte-5c9un9"&&(_o.innerHTML=dA),Fw=o(t),sr=n(t,"A",{id:!0}),r(sr).forEach(e),Pw=o(t),dt=n(t,"H3",{class:!0});var Om=r(dt);we=n(Om,"A",{id:!0,class:!0,href:!0});var z2=r(we);hc=n(z2,"SPAN",{});var E2=r(hc);h(Bo.$$.fragment,E2),E2.forEach(e),z2.forEach(e),eI=o(Om),lr=n(Om,"SPAN",{"data-svelte-h":!0}),i(lr)!=="svelte-1oekivk"&&(lr.textContent=TA),Om.forEach(e),Dw=o(t),Zo=n(t,"P",{"data-svelte-h":!0}),i(Zo)!=="svelte-17ht9wx"&&(Zo.innerHTML=wA),Ow=o(t),xo=n(t,"P",{"data-svelte-h":!0}),i(xo)!=="svelte-1w3rd8v"&&(xo.innerHTML=JA),Kw=o(t),qo=n(t,"P",{"data-svelte-h":!0}),i(qo)!=="svelte-skbdco"&&(qo.innerHTML=UA),tJ=o(t),ko=n(t,"P",{"data-svelte-h":!0}),i(ko)!=="svelte-1bhjkyj"&&(ko.innerHTML=mA),eJ=o(t),h(So.$$.fragment,t),sJ=o(t),$o=n(t,"P",{"data-svelte-h":!0}),i($o)!=="svelte-smfkl9"&&($o.innerHTML=fA),lJ=o(t),No=n(t,"P",{"data-svelte-h":!0}),i(No)!=="svelte-dunk9g"&&(No.innerHTML=IA),aJ=o(t),zo=n(t,"P",{"data-svelte-h":!0}),i(zo)!=="svelte-1lyq672"&&(zo.innerHTML=CA),nJ=o(t),Eo=n(t,"P",{"data-svelte-h":!0}),i(Eo)!=="svelte-1alw0cq"&&(Eo.textContent=vA),pJ=o(t),Go=n(t,"P",{"data-svelte-h":!0}),i(Go)!=="svelte-vnz9bj"&&(Go.textContent=bA),oJ=o(t),h(Wo.$$.fragment,t),iJ=o(t),Ro=n(t,"P",{"data-svelte-h":!0}),i(Ro)!=="svelte-1kitce"&&(Ro.innerHTML=AA),MJ=o(t),h(Xo.$$.fragment,t),uJ=o(t),h(Je.$$.fragment,t),rJ=o(t),Ho=n(t,"P",{"data-svelte-h":!0}),i(Ho)!=="svelte-46af4q"&&(Ho.innerHTML=gA),cJ=o(t),Qo=n(t,"P",{"data-svelte-h":!0}),i(Qo)!=="svelte-1k7xvv3"&&(Qo.innerHTML=_A),hJ=o(t),h(Vo.$$.fragment,t),yJ=o(t),Yo=n(t,"P",{"data-svelte-h":!0}),i(Yo)!=="svelte-75olud"&&(Yo.innerHTML=BA),jJ=o(t),Lo=n(t,"P",{"data-svelte-h":!0}),i(Lo)!=="svelte-1c769bq"&&(Lo.innerHTML=ZA),dJ=o(t),Fo=n(t,"P",{"data-svelte-h":!0}),i(Fo)!=="svelte-x82t5s"&&(Fo.textContent=xA),TJ=o(t),h(Po.$$.fragment,t),wJ=o(t),Do=n(t,"P",{"data-svelte-h":!0}),i(Do)!=="svelte-nly9am"&&(Do.innerHTML=qA),JJ=o(t),h(Oo.$$.fragment,t),UJ=o(t),Ko=n(t,"P",{"data-svelte-h":!0}),i(Ko)!=="svelte-1y5jgb5"&&(Ko.innerHTML=kA),mJ=o(t),ti=n(t,"P",{"data-svelte-h":!0}),i(ti)!=="svelte-3pqf1n"&&(ti.textContent=SA),fJ=o(t),ei=n(t,"P",{"data-svelte-h":!0}),i(ei)!=="svelte-9879ii"&&(ei.innerHTML=$A),IJ=o(t),si=n(t,"P",{"data-svelte-h":!0}),i(si)!=="svelte-13yg7dv"&&(si.innerHTML=NA),CJ=o(t),li=n(t,"P",{"data-svelte-h":!0}),i(li)!=="svelte-1wfe5kh"&&(li.textContent=zA),vJ=o(t),Tt=n(t,"H3",{class:!0});var Km=r(Tt);Ue=n(Km,"A",{id:!0,class:!0,href:!0});var G2=r(Ue);yc=n(G2,"SPAN",{});var W2=r(yc);h(ai.$$.fragment,W2),W2.forEach(e),G2.forEach(e),sI=o(Km),ar=n(Km,"SPAN",{"data-svelte-h":!0}),i(ar)!=="svelte-1mcdd7d"&&(ar.textContent=EA),Km.forEach(e),bJ=o(t),ni=n(t,"P",{"data-svelte-h":!0}),i(ni)!=="svelte-1m0vnge"&&(ni.textContent=GA),AJ=o(t),pi=n(t,"P",{"data-svelte-h":!0}),i(pi)!=="svelte-1vst44s"&&(pi.textContent=WA),gJ=o(t),oi=n(t,"P",{"data-svelte-h":!0}),i(oi)!=="svelte-zk7rbv"&&(oi.textContent=RA),_J=o(t),wt=n(t,"H4",{class:!0});var tf=r(wt);me=n(tf,"A",{id:!0,class:!0,href:!0});var R2=r(me);jc=n(R2,"SPAN",{});var X2=r(jc);h(ii.$$.fragment,X2),X2.forEach(e),R2.forEach(e),lI=o(tf),nr=n(tf,"SPAN",{"data-svelte-h":!0}),i(nr)!=="svelte-cgslgi"&&(nr.textContent=XA),tf.forEach(e),BJ=o(t),Mi=n(t,"P",{"data-svelte-h":!0}),i(Mi)!=="svelte-17kyo4r"&&(Mi.innerHTML=HA),ZJ=o(t),h(ui.$$.fragment,t),xJ=o(t),ri=n(t,"P",{"data-svelte-h":!0}),i(ri)!=="svelte-12v8sdv"&&(ri.textContent=QA),qJ=o(t),ci=n(t,"P",{"data-svelte-h":!0}),i(ci)!=="svelte-ptyjza"&&(ci.innerHTML=VA),kJ=o(t),h(hi.$$.fragment,t),SJ=o(t),yi=n(t,"P",{"data-svelte-h":!0}),i(yi)!=="svelte-1citdyb"&&(yi.innerHTML=YA),$J=o(t),ji=n(t,"P",{"data-svelte-h":!0}),i(ji)!=="svelte-1iltlt8"&&(ji.textContent=LA),NJ=o(t),di=n(t,"P",{"data-svelte-h":!0}),i(di)!=="svelte-lvtfhp"&&(di.innerHTML=FA),zJ=o(t),Ti=n(t,"P",{"data-svelte-h":!0}),i(Ti)!=="svelte-ifovwy"&&(Ti.innerHTML=PA),EJ=o(t),Jt=n(t,"H4",{class:!0});var ef=r(Jt);fe=n(ef,"A",{id:!0,class:!0,href:!0});var H2=r(fe);dc=n(H2,"SPAN",{});var Q2=r(dc);h(wi.$$.fragment,Q2),Q2.forEach(e),H2.forEach(e),aI=o(ef),pr=n(ef,"SPAN",{"data-svelte-h":!0}),i(pr)!=="svelte-nyz9cc"&&(pr.textContent=DA),ef.forEach(e),GJ=o(t),Ji=n(t,"P",{"data-svelte-h":!0}),i(Ji)!=="svelte-1m7dsvx"&&(Ji.innerHTML=OA),WJ=o(t),Ui=n(t,"P",{"data-svelte-h":!0}),i(Ui)!=="svelte-zsc548"&&(Ui.innerHTML=KA),RJ=o(t),mi=n(t,"P",{"data-svelte-h":!0}),i(mi)!=="svelte-112tcb5"&&(mi.textContent=tg),XJ=o(t),h(fi.$$.fragment,t),HJ=o(t),Ii=n(t,"P",{"data-svelte-h":!0}),i(Ii)!=="svelte-1hh79bp"&&(Ii.innerHTML=eg),QJ=o(t),or=n(t,"A",{id:!0}),r(or).forEach(e),VJ=o(t),Ut=n(t,"H3",{class:!0});var sf=r(Ut);Ie=n(sf,"A",{id:!0,class:!0,href:!0});var V2=r(Ie);Tc=n(V2,"SPAN",{});var Y2=r(Tc);h(Ci.$$.fragment,Y2),Y2.forEach(e),V2.forEach(e),nI=o(sf),ir=n(sf,"SPAN",{"data-svelte-h":!0}),i(ir)!=="svelte-ierylu"&&(ir.textContent=sg),sf.forEach(e),YJ=o(t),vi=n(t,"P",{"data-svelte-h":!0}),i(vi)!=="svelte-1kc5zro"&&(vi.textContent=lg),LJ=o(t),bi=n(t,"P",{"data-svelte-h":!0}),i(bi)!=="svelte-1mqz4tv"&&(bi.innerHTML=ag),FJ=o(t),h(Ai.$$.fragment,t),PJ=o(t),gi=n(t,"P",{"data-svelte-h":!0}),i(gi)!=="svelte-y0v7ku"&&(gi.textContent=ng),DJ=o(t),_i=n(t,"P",{"data-svelte-h":!0}),i(_i)!=="svelte-1jem9f9"&&(_i.innerHTML=pg),OJ=o(t),h(Bi.$$.fragment,t),KJ=o(t),Zi=n(t,"P",{"data-svelte-h":!0}),i(Zi)!=="svelte-1dep852"&&(Zi.textContent=og),tU=o(t),xi=n(t,"P",{"data-svelte-h":!0}),i(xi)!=="svelte-j75mu1"&&(xi.textContent=ig),eU=o(t),mt=n(t,"H3",{class:!0});var lf=r(mt);Ce=n(lf,"A",{id:!0,class:!0,href:!0});var L2=r(Ce);wc=n(L2,"SPAN",{});var F2=r(wc);h(qi.$$.fragment,F2),F2.forEach(e),L2.forEach(e),pI=o(lf),Mr=n(lf,"SPAN",{"data-svelte-h":!0}),i(Mr)!=="svelte-1k8rd0q"&&(Mr.textContent=Mg),lf.forEach(e),sU=o(t),ki=n(t,"P",{"data-svelte-h":!0}),i(ki)!=="svelte-ezkzj2"&&(ki.textContent=ug),lU=o(t),Si=n(t,"P",{"data-svelte-h":!0}),i(Si)!=="svelte-1ugusnt"&&(Si.textContent=rg),aU=o(t),h($i.$$.fragment,t),nU=o(t),Ni=n(t,"P",{"data-svelte-h":!0}),i(Ni)!=="svelte-ct9ez8"&&(Ni.textContent=cg),pU=o(t),zi=n(t,"P",{"data-svelte-h":!0}),i(zi)!=="svelte-s1px3l"&&(zi.textContent=hg),oU=o(t),Ei=n(t,"P",{"data-svelte-h":!0}),i(Ei)!=="svelte-bmrnhs"&&(Ei.textContent=yg),iU=o(t),Gi=n(t,"P",{"data-svelte-h":!0}),i(Gi)!=="svelte-g2c16a"&&(Gi.textContent=jg),MU=o(t),h(Wi.$$.fragment,t),uU=o(t),Ri=n(t,"P",{"data-svelte-h":!0}),i(Ri)!=="svelte-9c1q51"&&(Ri.textContent=dg),rU=o(t),Xi=n(t,"P",{"data-svelte-h":!0}),i(Xi)!=="svelte-24xeo5"&&(Xi.innerHTML=Tg),cU=o(t),ft=n(t,"H3",{class:!0});var af=r(ft);ve=n(af,"A",{id:!0,class:!0,href:!0});var P2=r(ve);Jc=n(P2,"SPAN",{});var D2=r(Jc);h(Hi.$$.fragment,D2),D2.forEach(e),P2.forEach(e),oI=o(af),ur=n(af,"SPAN",{"data-svelte-h":!0}),i(ur)!=="svelte-1jkp0y0"&&(ur.textContent=wg),af.forEach(e),hU=o(t),Qi=n(t,"P",{"data-svelte-h":!0}),i(Qi)!=="svelte-1kab485"&&(Qi.textContent=Jg),yU=o(t),Vi=n(t,"P",{"data-svelte-h":!0}),i(Vi)!=="svelte-1oebycv"&&(Vi.textContent=Ug),jU=o(t),C=n(t,"OL",{});var Z=r(C);rr=n(Z,"LI",{"data-svelte-h":!0}),i(rr)!=="svelte-rrz71w"&&(rr.innerHTML=mg),iI=o(Z),cr=n(Z,"LI",{"data-svelte-h":!0}),i(cr)!=="svelte-iidpty"&&(cr.innerHTML=fg),MI=o(Z),Yi=n(Z,"LI",{});var nf=r(Yi);hr=n(nf,"P",{"data-svelte-h":!0}),i(hr)!=="svelte-1ncrygs"&&(hr.textContent=Ig),uI=o(nf),h(Li.$$.fragment,nf),nf.forEach(e),rI=o(Z),yr=n(Z,"LI",{"data-svelte-h":!0}),i(yr)!=="svelte-tdhskc"&&(yr.innerHTML=Cg),cI=o(Z),jr=n(Z,"LI",{"data-svelte-h":!0}),i(jr)!=="svelte-1bwmgyk"&&(jr.innerHTML=vg),hI=o(Z),dr=n(Z,"LI",{"data-svelte-h":!0}),i(dr)!=="svelte-ql9qyt"&&(dr.innerHTML=bg),Z.forEach(e),dU=o(t),Fi=n(t,"P",{"data-svelte-h":!0}),i(Fi)!=="svelte-3g72th"&&(Fi.textContent=Ag),TU=o(t),Pi=n(t,"UL",{"data-svelte-h":!0}),i(Pi)!=="svelte-2bwbor"&&(Pi.innerHTML=gg),wU=o(t),It=n(t,"H3",{class:!0});var pf=r(It);be=n(pf,"A",{id:!0,class:!0,href:!0});var O2=r(be);Uc=n(O2,"SPAN",{});var K2=r(Uc);h(Di.$$.fragment,K2),K2.forEach(e),O2.forEach(e),yI=o(pf),Tr=n(pf,"SPAN",{"data-svelte-h":!0}),i(Tr)!=="svelte-15jwmb1"&&(Tr.textContent=_g),pf.forEach(e),JU=o(t),Ct=n(t,"H4",{class:!0});var of=r(Ct);Ae=n(of,"A",{id:!0,class:!0,href:!0});var t0=r(Ae);mc=n(t0,"SPAN",{});var e0=r(mc);h(Oi.$$.fragment,e0),e0.forEach(e),t0.forEach(e),jI=o(of),wr=n(of,"SPAN",{"data-svelte-h":!0}),i(wr)!=="svelte-yt9y6g"&&(wr.innerHTML=Bg),of.forEach(e),UU=o(t),Ki=n(t,"P",{"data-svelte-h":!0}),i(Ki)!=="svelte-1uwonxy"&&(Ki.innerHTML=Zg),mU=o(t),vt=n(t,"H4",{class:!0});var Mf=r(vt);ge=n(Mf,"A",{id:!0,class:!0,href:!0});var s0=r(ge);fc=n(s0,"SPAN",{});var l0=r(fc);h(tM.$$.fragment,l0),l0.forEach(e),s0.forEach(e),dI=o(Mf),Jr=n(Mf,"SPAN",{"data-svelte-h":!0}),i(Jr)!=="svelte-octopl"&&(Jr.innerHTML=xg),Mf.forEach(e),fU=o(t),eM=n(t,"P",{"data-svelte-h":!0}),i(eM)!=="svelte-6et3o9"&&(eM.textContent=qg),IU=o(t),sM=n(t,"P",{"data-svelte-h":!0}),i(sM)!=="svelte-zoxbhu"&&(sM.textContent=kg),CU=o(t),h(lM.$$.fragment,t),vU=o(t),aM=n(t,"P",{"data-svelte-h":!0}),i(aM)!=="svelte-ivzk1k"&&(aM.innerHTML=Sg),bU=o(t),h(nM.$$.fragment,t),AU=o(t),pM=n(t,"P",{"data-svelte-h":!0}),i(pM)!=="svelte-ee4ukj"&&(pM.textContent=$g),gU=o(t),oM=n(t,"P",{"data-svelte-h":!0}),i(oM)!=="svelte-7t5s0l"&&(oM.textContent=Ng),_U=o(t),iM=n(t,"P",{"data-svelte-h":!0}),i(iM)!=="svelte-1dvgk5f"&&(iM.innerHTML=zg),BU=o(t),bt=n(t,"H3",{class:!0});var uf=r(bt);_e=n(uf,"A",{id:!0,class:!0,href:!0});var a0=r(_e);Ic=n(a0,"SPAN",{});var n0=r(Ic);h(MM.$$.fragment,n0),n0.forEach(e),a0.forEach(e),TI=o(uf),Ur=n(uf,"SPAN",{"data-svelte-h":!0}),i(Ur)!=="svelte-hao89y"&&(Ur.textContent=Eg),uf.forEach(e),ZU=o(t),uM=n(t,"UL",{"data-svelte-h":!0}),i(uM)!=="svelte-11wz6he"&&(uM.innerHTML=Gg),xU=o(t),At=n(t,"H2",{class:!0});var rf=r(At);Be=n(rf,"A",{id:!0,class:!0,href:!0});var p0=r(Be);Cc=n(p0,"SPAN",{});var o0=r(Cc);h(rM.$$.fragment,o0),o0.forEach(e),p0.forEach(e),wI=o(rf),mr=n(rf,"SPAN",{"data-svelte-h":!0}),i(mr)!=="svelte-jvuhiv"&&(mr.textContent=Wg),rf.forEach(e),qU=o(t),cM=n(t,"P",{"data-svelte-h":!0}),i(cM)!=="svelte-nog5hb"&&(cM.innerHTML=Rg),kU=o(t),hM=n(t,"P",{"data-svelte-h":!0}),i(hM)!=="svelte-1us4497"&&(hM.innerHTML=Xg),SU=o(t),yM=n(t,"P",{"data-svelte-h":!0}),i(yM)!=="svelte-ino9ey"&&(yM.innerHTML=Hg),$U=o(t),jM=n(t,"P",{"data-svelte-h":!0}),i(jM)!=="svelte-1g6cule"&&(jM.innerHTML=Qg),NU=o(t),dM=n(t,"P",{"data-svelte-h":!0}),i(dM)!=="svelte-1l1ss1c"&&(dM.textContent=Vg),zU=o(t),h(TM.$$.fragment,t),EU=o(t),wM=n(t,"P",{"data-svelte-h":!0}),i(wM)!=="svelte-1svk6rj"&&(wM.textContent=Yg),GU=o(t),h(JM.$$.fragment,t),WU=o(t),UM=n(t,"P",{"data-svelte-h":!0}),i(UM)!=="svelte-smxvvq"&&(UM.innerHTML=Lg),RU=o(t),gt=n(t,"H2",{class:!0});var cf=r(gt);Ze=n(cf,"A",{id:!0,class:!0,href:!0});var i0=r(Ze);vc=n(i0,"SPAN",{});var M0=r(vc);h(mM.$$.fragment,M0),M0.forEach(e),i0.forEach(e),JI=o(cf),fr=n(cf,"SPAN",{"data-svelte-h":!0}),i(fr)!=="svelte-1vc8zl6"&&(fr.textContent=Fg),cf.forEach(e),XU=o(t),g=n(t,"DIV",{class:!0});var $e=r(g);h(fM.$$.fragment,$e),UI=o($e),Ir=n($e,"P",{"data-svelte-h":!0}),i(Ir)!=="svelte-g6t8ro"&&(Ir.textContent=Pg),mI=o($e),Cr=n($e,"P",{"data-svelte-h":!0}),i(Cr)!=="svelte-xzx2jk"&&(Cr.innerHTML=Dg),fI=o($e),vr=n($e,"P",{"data-svelte-h":!0}),i(vr)!=="svelte-1osq51u"&&(vr.innerHTML=Og),$e.forEach(e),HU=o(t),_t=n(t,"H3",{class:!0});var hf=r(_t);xe=n(hf,"A",{id:!0,class:!0,href:!0});var u0=r(xe);bc=n(u0,"SPAN",{});var r0=r(bc);h(IM.$$.fragment,r0),r0.forEach(e),u0.forEach(e),II=o(hf),br=n(hf,"SPAN",{"data-svelte-h":!0}),i(br)!=="svelte-1tbkbt8"&&(br.textContent=Kg),hf.forEach(e),QU=o(t),CM=n(t,"P",{"data-svelte-h":!0}),i(CM)!=="svelte-zrwdft"&&(CM.innerHTML=t_),VU=o(t),vM=n(t,"P",{"data-svelte-h":!0}),i(vM)!=="svelte-1kok2zl"&&(vM.textContent=e_),YU=o(t),bM=n(t,"P",{"data-svelte-h":!0}),i(bM)!=="svelte-2awh2l"&&(bM.textContent=s_),LU=o(t),AM=n(t,"P",{"data-svelte-h":!0}),i(AM)!=="svelte-o4r1i6"&&(AM.textContent=l_),FU=o(t),gM=n(t,"OL",{"data-svelte-h":!0}),i(gM)!=="svelte-1kuo9hl"&&(gM.innerHTML=a_),PU=o(t),h(_M.$$.fragment,t),DU=o(t),BM=n(t,"P",{"data-svelte-h":!0}),i(BM)!=="svelte-1boyjju"&&(BM.innerHTML=n_),OU=o(t),h(ZM.$$.fragment,t),KU=o(t),xM=n(t,"P",{"data-svelte-h":!0}),i(xM)!=="svelte-1ezcpn"&&(xM.textContent=p_),tm=o(t),Bt=n(t,"H3",{class:!0});var yf=r(Bt);qe=n(yf,"A",{id:!0,class:!0,href:!0});var c0=r(qe);Ac=n(c0,"SPAN",{});var h0=r(Ac);h(qM.$$.fragment,h0),h0.forEach(e),c0.forEach(e),CI=o(yf),Ar=n(yf,"SPAN",{"data-svelte-h":!0}),i(Ar)!=="svelte-1g2jojg"&&(Ar.innerHTML=o_),yf.forEach(e),em=o(t),kM=n(t,"P",{"data-svelte-h":!0}),i(kM)!=="svelte-1blwf7x"&&(kM.innerHTML=i_),sm=o(t),SM=n(t,"P",{"data-svelte-h":!0}),i(SM)!=="svelte-h0s2m6"&&(SM.innerHTML=M_),lm=o(t),Zt=n(t,"H2",{class:!0});var jf=r(Zt);ke=n(jf,"A",{id:!0,class:!0,href:!0});var y0=r(ke);gc=n(y0,"SPAN",{});var j0=r(gc);h($M.$$.fragment,j0),j0.forEach(e),y0.forEach(e),vI=o(jf),gr=n(jf,"SPAN",{"data-svelte-h":!0}),i(gr)!=="svelte-1eqs1do"&&(gr.textContent=u_),jf.forEach(e),am=o(t),NM=n(t,"P",{"data-svelte-h":!0}),i(NM)!=="svelte-14hjhxw"&&(NM.textContent=r_),nm=o(t),zM=n(t,"P",{"data-svelte-h":!0}),i(zM)!=="svelte-59lrmj"&&(zM.textContent=c_),pm=o(t),h(EM.$$.fragment,t),om=o(t),GM=n(t,"P",{"data-svelte-h":!0}),i(GM)!=="svelte-xyk76s"&&(GM.textContent=h_),im=o(t),h(WM.$$.fragment,t),Mm=o(t),xt=n(t,"H2",{class:!0});var df=r(xt);Se=n(df,"A",{id:!0,class:!0,href:!0});var d0=r(Se);_c=n(d0,"SPAN",{});var T0=r(_c);h(RM.$$.fragment,T0),T0.forEach(e),d0.forEach(e),bI=o(df),_r=n(df,"SPAN",{"data-svelte-h":!0}),i(_r)!=="svelte-4nyhou"&&(_r.textContent=y_),df.forEach(e),um=o(t),XM=n(t,"UL",{"data-svelte-h":!0}),i(XM)!=="svelte-qibs9v"&&(XM.innerHTML=j_),rm=o(t),HM=n(t,"P",{"data-svelte-h":!0}),i(HM)!=="svelte-1pnpyer"&&(HM.textContent=d_),cm=o(t),QM=n(t,"UL",{"data-svelte-h":!0}),i(QM)!=="svelte-teaul9"&&(QM.innerHTML=T_),hm=o(t),VM=n(t,"P",{"data-svelte-h":!0}),i(VM)!=="svelte-19krwot"&&(VM.innerHTML=w_),ym=o(t),Bc=n(t,"P",{}),r(Bc).forEach(e),this.h()},h(){M(U,"name","hf:doc:metadata"),M(U,"content",JSON.stringify(g0)),M(b,"id","deepspeed-integration"),M(b,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(b,"href","#deepspeed-integration"),M(_,"class","relative group"),M(LM,"id","deepspeed-trainer-integration"),M(kt,"id","trainer-deepspeed-integration"),M(kt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(kt,"href","#trainer-deepspeed-integration"),M(q,"class","relative group"),M(PM,"id","deepspeed-installation"),M(St,"id","installation"),M(St,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(St,"href","#installation"),M(k,"class","relative group"),M(OM,"id","deepspeed-multi-gpu"),M($t,"id","deployment-with-multiple-gpus"),M($t,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M($t,"href","#deployment-with-multiple-gpus"),M(S,"class","relative group"),M(tu,"id","deepspeed-one-gpu"),M(Nt,"id","deployment-with-one-gpu"),M(Nt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(Nt,"href","#deployment-with-one-gpu"),M($,"class","relative group"),M(nu,"id","deepspeed-multi-node"),M(zt,"id","deployment-with-multiple-nodes"),M(zt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(zt,"href","#deployment-with-multiple-nodes"),M(z,"class","relative group"),M(Et,"id","the-torchdistributedrun-launcher"),M(Et,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(Et,"href","#the-torchdistributedrun-launcher"),M(E,"class","relative group"),M(Gt,"id","the-deepspeed-launcher"),M(Gt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(Gt,"href","#the-deepspeed-launcher"),M(G,"class","relative group"),M(Wt,"id","launching-in-a-slurm-environment"),M(Wt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(Wt,"href","#launching-in-a-slurm-environment"),M(W,"class","relative group"),M(Rt,"id","use-of-nonshared-filesystem"),M(Rt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(Rt,"href","#use-of-nonshared-filesystem"),M(R,"class","relative group"),M(ru,"id","deepspeed-notebook"),M(Xt,"id","deployment-in-notebooks"),M(Xt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(Xt,"href","#deployment-in-notebooks"),M(X,"class","relative group"),M(hu,"id","deepspeed-config"),M(Ht,"id","configuration"),M(Ht,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(Ht,"href","#configuration"),M(H,"class","relative group"),M(ju,"id","deepspeed-config-passing"),M(Qt,"id","passing-configuration"),M(Qt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(Qt,"href","#passing-configuration"),M(Q,"class","relative group"),M(Tu,"id","deepspeed-config-shared"),M(Vt,"id","shared-configuration"),M(Vt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(Vt,"href","#shared-configuration"),M(V,"class","relative group"),M(Ju,"id","deepspeed-zero"),M(Lt,"id","zero"),M(Lt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(Lt,"href","#zero"),M(Y,"class","relative group"),M(mu,"id","deepspeed-zero2-config"),M(Ft,"id","zero2-config"),M(Ft,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(Ft,"href","#zero2-config"),M(L,"class","relative group"),M(Iu,"id","deepspeed-zero3-config"),M(Pt,"id","zero3-config"),M(Pt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(Pt,"href","#zero3-config"),M(F,"class","relative group"),M(Dt,"id","zero0-config"),M(Dt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(Dt,"href","#zero0-config"),M(P,"class","relative group"),M(Ot,"id","zero1-config"),M(Ot,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(Ot,"href","#zero1-config"),M(D,"class","relative group"),M(Au,"id","deepspeed-nvme"),M(Kt,"id","nvme-support"),M(Kt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(Kt,"href","#nvme-support"),M(O,"class","relative group"),M(_u,"id","deepspeed-zero2-zero3-performance"),M(te,"id","zero2-vs-zero3-performance"),M(te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(te,"href","#zero2-vs-zero3-performance"),M(K,"class","relative group"),M(Zu,"id","deepspeed-zero2-example"),M(ee,"id","zero2-example"),M(ee,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(ee,"href","#zero2-example"),M(tt,"class","relative group"),M(qu,"id","deepspeed-zero3-example"),M(se,"id","zero3-example"),M(se,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(se,"href","#zero3-example"),M(et,"class","relative group"),M(le,"id","how-to-choose-which-zero-stage-and-offloads-to-use-for-best-performance"),M(le,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(le,"href","#how-to-choose-which-zero-stage-and-offloads-to-use-for-best-performance"),M(st,"class","relative group"),M(ae,"id","activation-checkpointing-or-gradient-checkpointing"),M(ae,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(ae,"href","#activation-checkpointing-or-gradient-checkpointing"),M(lt,"class","relative group"),M(ne,"id","optimizer-and-scheduler"),M(ne,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(ne,"href","#optimizer-and-scheduler"),M(at,"class","relative group"),M(zu,"id","deepspeed-optimizer"),M(pe,"id","optimizer"),M(pe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(pe,"href","#optimizer"),M(nt,"class","relative group"),M(Gu,"id","deepspeed-scheduler"),M(oe,"id","scheduler"),M(oe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(oe,"href","#scheduler"),M(pt,"class","relative group"),M(Ru,"id","deepspeed-fp32"),M(ie,"id","fp32-precision"),M(ie,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(ie,"href","#fp32-precision"),M(ot,"class","relative group"),M(Hu,"id","deepspeed-amp"),M(Me,"id","automatic-mixed-precision"),M(Me,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(Me,"href","#automatic-mixed-precision"),M(it,"class","relative group"),M(ue,"id","fp16"),M(ue,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(ue,"href","#fp16"),M(Mt,"class","relative group"),M(re,"id","bf16"),M(re,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(re,"href","#bf16"),M(ut,"class","relative group"),M(he,"id","nccl-collectives"),M(he,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(he,"href","#nccl-collectives"),M(rt,"class","relative group"),M(ye,"id","apex"),M(ye,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(ye,"href","#apex"),M(ct,"class","relative group"),M(Pu,"id","deepspeed-bs"),M(je,"id","batch-size"),M(je,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(je,"href","#batch-size"),M(ht,"class","relative group"),M(Ou,"id","deepspeed-grad-acc"),M(de,"id","gradient-accumulation"),M(de,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(de,"href","#gradient-accumulation"),M(yt,"class","relative group"),M(tr,"id","deepspeed-grad-clip"),M(Te,"id","gradient-clipping"),M(Te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(Te,"href","#gradient-clipping"),M(jt,"class","relative group"),M(sr,"id","deepspeed-weight-extraction"),M(we,"id","getting-the-model-weights-out"),M(we,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(we,"href","#getting-the-model-weights-out"),M(dt,"class","relative group"),M(Ue,"id","zero3-and-infinity-nuances"),M(Ue,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(Ue,"href","#zero3-and-infinity-nuances"),M(Tt,"class","relative group"),M(me,"id","constructing-massive-models"),M(me,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(me,"href","#constructing-massive-models"),M(wt,"class","relative group"),M(fe,"id","gathering-parameters"),M(fe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(fe,"href","#gathering-parameters"),M(Jt,"class","relative group"),M(or,"id","deepspeed-zero-inference"),M(Ie,"id","zero-inference"),M(Ie,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(Ie,"href","#zero-inference"),M(Ut,"class","relative group"),M(Ce,"id","memory-requirements"),M(Ce,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(Ce,"href","#memory-requirements"),M(mt,"class","relative group"),M(ve,"id","filing-issues"),M(ve,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(ve,"href","#filing-issues"),M(ft,"class","relative group"),M(be,"id","troubleshooting"),M(be,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(be,"href","#troubleshooting"),M(It,"class","relative group"),M(Ae,"id","the-deepspeed-process-gets-killed-at-startup-without-a-traceback"),M(Ae,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(Ae,"href","#the-deepspeed-process-gets-killed-at-startup-without-a-traceback"),M(Ct,"class","relative group"),M(ge,"id","training-andor-evalpredict-loss-is-nan"),M(ge,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(ge,"href","#training-andor-evalpredict-loss-is-nan"),M(vt,"class","relative group"),M(_e,"id","notes"),M(_e,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(_e,"href","#notes"),M(bt,"class","relative group"),M(Be,"id","nontrainer-deepspeed-integration"),M(Be,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(Be,"href","#nontrainer-deepspeed-integration"),M(At,"class","relative group"),M(Ze,"id","transformers.integrations.HfDeepSpeedConfig"),M(Ze,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(Ze,"href","#transformers.integrations.HfDeepSpeedConfig"),M(gt,"class","relative group"),M(g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xe,"id","custom-deepspeed-zero-inference"),M(xe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(xe,"href","#custom-deepspeed-zero-inference"),M(_t,"class","relative group"),M(qe,"id","generate-nuances"),M(qe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(qe,"href","#generate-nuances"),M(Bt,"class","relative group"),M(ke,"id","testing-deepspeed-integration"),M(ke,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(ke,"href","#testing-deepspeed-integration"),M(Zt,"class","relative group"),M(Se,"id","main-deepspeed-resources"),M(Se,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(Se,"href","#main-deepspeed-resources"),M(xt,"class","relative group")},m(t,s){u(document.head,U),l(t,v,s),l(t,m,s),l(t,I,s),l(t,_,s),u(_,b),u(b,A),y(x,A,null),u(_,f),u(_,B),l(t,qc,s),l(t,Ne,s),l(t,kc,s),l(t,ze,s),l(t,Sc,s),l(t,Ee,s),l(t,$c,s),l(t,Ge,s),l(t,Nc,s),l(t,We,s),l(t,zc,s),l(t,Re,s),l(t,Ec,s),l(t,Xe,s),l(t,Gc,s),l(t,He,s),l(t,Wc,s),l(t,Qe,s),l(t,Rc,s),l(t,Ve,s),l(t,Xc,s),l(t,Ye,s),l(t,Hc,s),l(t,Le,s),l(t,Qc,s),l(t,Fe,s),l(t,Vc,s),l(t,LM,s),l(t,Yc,s),l(t,q,s),u(q,kt),u(kt,Zr),y(Pe,Zr,null),u(q,Tf),u(q,FM),l(t,Lc,s),l(t,PM,s),l(t,Fc,s),l(t,k,s),u(k,St),u(St,xr),y(De,xr,null),u(k,wf),u(k,DM),l(t,Pc,s),l(t,Oe,s),l(t,Dc,s),y(Ke,t,s),l(t,Oc,s),l(t,ts,s),l(t,Kc,s),y(es,t,s),l(t,th,s),l(t,ss,s),l(t,eh,s),l(t,ls,s),l(t,sh,s),l(t,as,s),l(t,lh,s),l(t,ns,s),l(t,ah,s),y(ps,t,s),l(t,nh,s),l(t,os,s),l(t,ph,s),l(t,is,s),l(t,oh,s),y(Ms,t,s),l(t,ih,s),l(t,us,s),l(t,Mh,s),l(t,rs,s),l(t,uh,s),y(cs,t,s),l(t,rh,s),l(t,hs,s),l(t,ch,s),l(t,ys,s),l(t,hh,s),l(t,js,s),l(t,yh,s),l(t,ds,s),l(t,jh,s),y(Ts,t,s),l(t,dh,s),l(t,ws,s),l(t,Th,s),y(Js,t,s),l(t,wh,s),l(t,Us,s),l(t,Jh,s),y(ms,t,s),l(t,Uh,s),l(t,fs,s),l(t,mh,s),l(t,Is,s),l(t,fh,s),l(t,Cs,s),l(t,Ih,s),l(t,OM,s),l(t,Ch,s),l(t,S,s),u(S,$t),u($t,qr),y(vs,qr,null),u(S,Jf),u(S,KM),l(t,vh,s),l(t,bs,s),l(t,bh,s),l(t,As,s),l(t,Ah,s),y(gs,t,s),l(t,gh,s),l(t,_s,s),l(t,_h,s),y(Bs,t,s),l(t,Bh,s),l(t,Zs,s),l(t,Zh,s),l(t,xs,s),l(t,xh,s),l(t,qs,s),l(t,qh,s),y(ks,t,s),l(t,kh,s),l(t,Ss,s),l(t,Sh,s),l(t,$s,s),l(t,$h,s),l(t,tu,s),l(t,Nh,s),l(t,$,s),u($,Nt),u(Nt,kr),y(Ns,kr,null),u($,Uf),u($,eu),l(t,zh,s),l(t,zs,s),l(t,Eh,s),y(Es,t,s),l(t,Gh,s),l(t,Gs,s),l(t,Wh,s),l(t,Ws,s),l(t,Rh,s),l(t,Rs,s),l(t,Xh,s),l(t,Xs,s),l(t,Hh,s),y(Hs,t,s),l(t,Qh,s),l(t,Qs,s),l(t,Vh,s),l(t,Vs,s),l(t,Yh,s),l(t,Ys,s),l(t,Lh,s),l(t,Ls,s),l(t,Fh,s),l(t,su,s),u(su,N),u(N,lu),u(N,mf),y(Fs,N,null),u(N,ff),u(N,au),l(t,Ph,s),l(t,nu,s),l(t,Dh,s),l(t,z,s),u(z,zt),u(zt,Sr),y(Ps,Sr,null),u(z,If),u(z,pu),l(t,Oh,s),l(t,Ds,s),l(t,Kh,s),l(t,Os,s),l(t,ty,s),l(t,E,s),u(E,Et),u(Et,$r),y(Ks,$r,null),u(E,Cf),u(E,ou),l(t,ey,s),l(t,tl,s),l(t,sy,s),y(el,t,s),l(t,ly,s),l(t,sl,s),l(t,ay,s),l(t,ll,s),l(t,ny,s),l(t,G,s),u(G,Gt),u(Gt,Nr),y(al,Nr,null),u(G,vf),u(G,iu),l(t,py,s),l(t,nl,s),l(t,oy,s),y(pl,t,s),l(t,iy,s),l(t,ol,s),l(t,My,s),y(il,t,s),l(t,uy,s),l(t,Ml,s),l(t,ry,s),l(t,ul,s),l(t,cy,s),l(t,W,s),u(W,Wt),u(Wt,zr),y(rl,zr,null),u(W,bf),u(W,Mu),l(t,hy,s),l(t,cl,s),l(t,yy,s),y(hl,t,s),l(t,jy,s),l(t,yl,s),l(t,dy,s),y(jl,t,s),l(t,Ty,s),l(t,dl,s),l(t,wy,s),l(t,R,s),u(R,Rt),u(Rt,Er),y(Tl,Er,null),u(R,Af),u(R,uu),l(t,Jy,s),l(t,wl,s),l(t,Uy,s),y(Jl,t,s),l(t,my,s),l(t,Ul,s),l(t,fy,s),l(t,ru,s),l(t,Iy,s),l(t,X,s),u(X,Xt),u(Xt,Gr),y(ml,Gr,null),u(X,gf),u(X,cu),l(t,Cy,s),l(t,fl,s),l(t,vy,s),l(t,Il,s),l(t,by,s),y(Cl,t,s),l(t,Ay,s),l(t,vl,s),l(t,gy,s),l(t,bl,s),l(t,_y,s),l(t,Al,s),l(t,By,s),y(gl,t,s),l(t,Zy,s),l(t,_l,s),l(t,xy,s),y(Bl,t,s),l(t,qy,s),l(t,Zl,s),l(t,ky,s),y(xl,t,s),l(t,Sy,s),l(t,ql,s),l(t,$y,s),l(t,kl,s),l(t,Ny,s),l(t,hu,s),l(t,zy,s),l(t,H,s),u(H,Ht),u(Ht,Wr),y(Sl,Wr,null),u(H,_f),u(H,yu),l(t,Ey,s),l(t,$l,s),l(t,Gy,s),l(t,Nl,s),l(t,Wy,s),y(zl,t,s),l(t,Ry,s),l(t,El,s),l(t,Xy,s),y(Gl,t,s),l(t,Hy,s),l(t,Wl,s),l(t,Qy,s),l(t,Rl,s),l(t,Vy,s),l(t,Xl,s),l(t,Yy,s),y(Hl,t,s),l(t,Ly,s),l(t,Ql,s),l(t,Fy,s),l(t,ju,s),l(t,Py,s),l(t,Q,s),u(Q,Qt),u(Qt,Rr),y(Vl,Rr,null),u(Q,Bf),u(Q,du),l(t,Dy,s),l(t,Yl,s),l(t,Oy,s),l(t,Ll,s),l(t,Ky,s),y(Fl,t,s),l(t,tj,s),l(t,Pl,s),l(t,ej,s),y(Dl,t,s),l(t,sj,s),l(t,Tu,s),l(t,lj,s),l(t,V,s),u(V,Vt),u(Vt,Xr),y(Ol,Xr,null),u(V,Zf),u(V,wu),l(t,aj,s),y(Yt,t,s),l(t,nj,s),l(t,Kl,s),l(t,pj,s),l(t,ta,s),l(t,oj,s),l(t,ea,s),l(t,ij,s),l(t,sa,s),l(t,Mj,s),l(t,la,s),l(t,uj,s),l(t,aa,s),l(t,rj,s),l(t,na,s),l(t,cj,s),l(t,Ju,s),l(t,hj,s),l(t,Y,s),u(Y,Lt),u(Lt,Hr),y(pa,Hr,null),u(Y,xf),u(Y,Uu),l(t,yj,s),l(t,oa,s),l(t,jj,s),l(t,ia,s),l(t,dj,s),l(t,Ma,s),l(t,Tj,s),l(t,ua,s),l(t,wj,s),l(t,mu,s),l(t,Jj,s),l(t,L,s),u(L,Ft),u(Ft,Qr),y(ra,Qr,null),u(L,qf),u(L,fu),l(t,Uj,s),l(t,ca,s),l(t,mj,s),y(ha,t,s),l(t,fj,s),l(t,ya,s),l(t,Ij,s),l(t,ja,s),l(t,Cj,s),l(t,da,s),l(t,vj,s),y(Ta,t,s),l(t,bj,s),l(t,wa,s),l(t,Aj,s),l(t,Iu,s),l(t,gj,s),l(t,F,s),u(F,Pt),u(Pt,Vr),y(Ja,Vr,null),u(F,kf),u(F,Cu),l(t,_j,s),l(t,Ua,s),l(t,Bj,s),y(ma,t,s),l(t,Zj,s),l(t,fa,s),l(t,xj,s),l(t,Ia,s),l(t,qj,s),l(t,Ca,s),l(t,kj,s),l(t,va,s),l(t,Sj,s),l(t,ba,s),l(t,$j,s),l(t,Aa,s),l(t,Nj,s),l(t,ga,s),l(t,zj,s),l(t,_a,s),l(t,Ej,s),l(t,Ba,s),l(t,Gj,s),l(t,Za,s),l(t,Wj,s),l(t,xa,s),l(t,Rj,s),l(t,qa,s),l(t,Xj,s),l(t,ka,s),l(t,Hj,s),l(t,Sa,s),l(t,Qj,s),l(t,$a,s),l(t,Vj,s),l(t,P,s),u(P,Dt),u(Dt,Yr),y(Na,Yr,null),u(P,Sf),u(P,vu),l(t,Yj,s),l(t,za,s),l(t,Lj,s),l(t,Ea,s),l(t,Fj,s),y(Ga,t,s),l(t,Pj,s),l(t,Wa,s),l(t,Dj,s),l(t,D,s),u(D,Ot),u(Ot,Lr),y(Ra,Lr,null),u(D,$f),u(D,bu),l(t,Oj,s),l(t,Xa,s),l(t,Kj,s),y(Ha,t,s),l(t,td,s),l(t,Au,s),l(t,ed,s),l(t,O,s),u(O,Kt),u(Kt,Fr),y(Qa,Fr,null),u(O,Nf),u(O,gu),l(t,sd,s),l(t,Va,s),l(t,ld,s),l(t,Ya,s),l(t,ad,s),y(La,t,s),l(t,nd,s),l(t,Fa,s),l(t,pd,s),l(t,Pa,s),l(t,od,s),l(t,Da,s),l(t,id,s),l(t,Oa,s),l(t,Md,s),l(t,_u,s),l(t,ud,s),l(t,K,s),u(K,te),u(te,Pr),y(Ka,Pr,null),u(K,zf),u(K,Bu),l(t,rd,s),l(t,tn,s),l(t,cd,s),l(t,en,s),l(t,hd,s),l(t,sn,s),l(t,yd,s),l(t,ln,s),l(t,jd,s),l(t,Zu,s),l(t,dd,s),l(t,tt,s),u(tt,ee),u(ee,Dr),y(an,Dr,null),u(tt,Ef),u(tt,xu),l(t,Td,s),l(t,nn,s),l(t,wd,s),y(pn,t,s),l(t,Jd,s),l(t,on,s),l(t,Ud,s),y(Mn,t,s),l(t,md,s),l(t,qu,s),l(t,fd,s),l(t,et,s),u(et,se),u(se,Or),y(un,Or,null),u(et,Gf),u(et,ku),l(t,Id,s),l(t,rn,s),l(t,Cd,s),y(cn,t,s),l(t,vd,s),l(t,hn,s),l(t,bd,s),y(yn,t,s),l(t,Ad,s),l(t,st,s),u(st,le),u(le,Kr),y(jn,Kr,null),u(st,Wf),u(st,Su),l(t,gd,s),l(t,dn,s),l(t,_d,s),l(t,Tn,s),l(t,Bd,s),l(t,wn,s),l(t,Zd,s),l(t,Jn,s),l(t,xd,s),l(t,Un,s),l(t,qd,s),l(t,mn,s),l(t,kd,s),l(t,fn,s),l(t,Sd,s),l(t,In,s),l(t,$d,s),l(t,Cn,s),l(t,Nd,s),l(t,vn,s),l(t,zd,s),l(t,bn,s),l(t,Ed,s),l(t,An,s),l(t,Gd,s),l(t,gn,s),l(t,Wd,s),l(t,_n,s),l(t,Rd,s),l(t,Bn,s),l(t,Xd,s),l(t,Zn,s),l(t,Hd,s),l(t,xn,s),l(t,Qd,s),l(t,lt,s),u(lt,ae),u(ae,tc),y(qn,tc,null),u(lt,Rf),u(lt,$u),l(t,Vd,s),l(t,kn,s),l(t,Yd,s),l(t,Sn,s),l(t,Ld,s),l(t,$n,s),l(t,Fd,s),l(t,Nn,s),l(t,Pd,s),l(t,zn,s),l(t,Dd,s),l(t,at,s),u(at,ne),u(ne,ec),y(En,ec,null),u(at,Xf),u(at,Nu),l(t,Od,s),l(t,Gn,s),l(t,Kd,s),l(t,Wn,s),l(t,tT,s),l(t,Rn,s),l(t,eT,s),l(t,zu,s),l(t,sT,s),l(t,nt,s),u(nt,pe),u(pe,sc),y(Xn,sc,null),u(nt,Hf),u(nt,Eu),l(t,lT,s),l(t,Hn,s),l(t,aT,s),l(t,Qn,s),l(t,nT,s),l(t,Vn,s),l(t,pT,s),y(Yn,t,s),l(t,oT,s),l(t,Ln,s),l(t,iT,s),l(t,Fn,s),l(t,MT,s),l(t,Pn,s),l(t,uT,s),l(t,Dn,s),l(t,rT,s),y(On,t,s),l(t,cT,s),l(t,Kn,s),l(t,hT,s),l(t,tp,s),l(t,yT,s),y(ep,t,s),l(t,jT,s),l(t,sp,s),l(t,dT,s),l(t,lp,s),l(t,TT,s),y(ap,t,s),l(t,wT,s),l(t,np,s),l(t,JT,s),l(t,Gu,s),l(t,UT,s),l(t,pt,s),u(pt,oe),u(oe,lc),y(pp,lc,null),u(pt,Qf),u(pt,Wu),l(t,mT,s),l(t,op,s),l(t,fT,s),l(t,ip,s),l(t,IT,s),l(t,Mp,s),l(t,CT,s),l(t,up,s),l(t,vT,s),l(t,rp,s),l(t,bT,s),y(cp,t,s),l(t,AT,s),l(t,hp,s),l(t,gT,s),l(t,yp,s),l(t,_T,s),l(t,jp,s),l(t,BT,s),y(dp,t,s),l(t,ZT,s),l(t,Tp,s),l(t,xT,s),l(t,wp,s),l(t,qT,s),y(Jp,t,s),l(t,kT,s),l(t,Up,s),l(t,ST,s),l(t,Ru,s),l(t,$T,s),l(t,ot,s),u(ot,ie),u(ie,ac),y(mp,ac,null),u(ot,Vf),u(ot,Xu),l(t,NT,s),l(t,fp,s),l(t,zT,s),l(t,Ip,s),l(t,ET,s),y(Cp,t,s),l(t,GT,s),l(t,vp,s),l(t,WT,s),l(t,bp,s),l(t,RT,s),l(t,Hu,s),l(t,XT,s),l(t,it,s),u(it,Me),u(Me,nc),y(Ap,nc,null),u(it,Yf),u(it,Qu),l(t,HT,s),l(t,gp,s),l(t,QT,s),l(t,Mt,s),u(Mt,ue),u(ue,pc),y(_p,pc,null),u(Mt,Lf),u(Mt,Vu),l(t,VT,s),l(t,Bp,s),l(t,YT,s),y(Zp,t,s),l(t,LT,s),l(t,xp,s),l(t,FT,s),l(t,qp,s),l(t,PT,s),l(t,kp,s),l(t,DT,s),y(Sp,t,s),l(t,OT,s),l(t,$p,s),l(t,KT,s),l(t,Np,s),l(t,tw,s),l(t,ut,s),u(ut,re),u(re,oc),y(zp,oc,null),u(ut,Ff),u(ut,Yu),l(t,ew,s),l(t,Ep,s),l(t,sw,s),y(Gp,t,s),l(t,lw,s),l(t,Wp,s),l(t,aw,s),l(t,Rp,s),l(t,nw,s),l(t,Xp,s),l(t,pw,s),y(Hp,t,s),l(t,ow,s),y(ce,t,s),l(t,iw,s),l(t,rt,s),u(rt,he),u(he,ic),y(Qp,ic,null),u(rt,Pf),u(rt,Lu),l(t,Mw,s),l(t,Vp,s),l(t,uw,s),l(t,Yp,s),l(t,rw,s),l(t,Lp,s),l(t,cw,s),l(t,Fp,s),l(t,hw,s),y(Pp,t,s),l(t,yw,s),l(t,Dp,s),l(t,jw,s),l(t,Op,s),l(t,dw,s),l(t,ct,s),u(ct,ye),u(ye,Mc),y(Kp,Mc,null),u(ct,Df),u(ct,Fu),l(t,Tw,s),l(t,to,s),l(t,ww,s),y(eo,t,s),l(t,Jw,s),l(t,so,s),l(t,Uw,s),l(t,lo,s),l(t,mw,s),l(t,ao,s),l(t,fw,s),y(no,t,s),l(t,Iw,s),l(t,po,s),l(t,Cw,s),l(t,oo,s),l(t,vw,s),l(t,Pu,s),l(t,bw,s),l(t,ht,s),u(ht,je),u(je,uc),y(io,uc,null),u(ht,Of),u(ht,Du),l(t,Aw,s),l(t,Mo,s),l(t,gw,s),y(uo,t,s),l(t,_w,s),l(t,ro,s),l(t,Bw,s),l(t,co,s),l(t,Zw,s),y(ho,t,s),l(t,xw,s),l(t,yo,s),l(t,qw,s),l(t,Ou,s),l(t,kw,s),l(t,yt,s),u(yt,de),u(de,rc),y(jo,rc,null),u(yt,Kf),u(yt,Ku),l(t,Sw,s),l(t,To,s),l(t,$w,s),y(wo,t,s),l(t,Nw,s),l(t,Jo,s),l(t,zw,s),l(t,Uo,s),l(t,Ew,s),y(mo,t,s),l(t,Gw,s),l(t,fo,s),l(t,Ww,s),l(t,tr,s),l(t,Rw,s),l(t,jt,s),u(jt,Te),u(Te,cc),y(Io,cc,null),u(jt,tI),u(jt,er),l(t,Xw,s),l(t,Co,s),l(t,Hw,s),y(vo,t,s),l(t,Qw,s),l(t,bo,s),l(t,Vw,s),l(t,Ao,s),l(t,Yw,s),y(go,t,s),l(t,Lw,s),l(t,_o,s),l(t,Fw,s),l(t,sr,s),l(t,Pw,s),l(t,dt,s),u(dt,we),u(we,hc),y(Bo,hc,null),u(dt,eI),u(dt,lr),l(t,Dw,s),l(t,Zo,s),l(t,Ow,s),l(t,xo,s),l(t,Kw,s),l(t,qo,s),l(t,tJ,s),l(t,ko,s),l(t,eJ,s),y(So,t,s),l(t,sJ,s),l(t,$o,s),l(t,lJ,s),l(t,No,s),l(t,aJ,s),l(t,zo,s),l(t,nJ,s),l(t,Eo,s),l(t,pJ,s),l(t,Go,s),l(t,oJ,s),y(Wo,t,s),l(t,iJ,s),l(t,Ro,s),l(t,MJ,s),y(Xo,t,s),l(t,uJ,s),y(Je,t,s),l(t,rJ,s),l(t,Ho,s),l(t,cJ,s),l(t,Qo,s),l(t,hJ,s),y(Vo,t,s),l(t,yJ,s),l(t,Yo,s),l(t,jJ,s),l(t,Lo,s),l(t,dJ,s),l(t,Fo,s),l(t,TJ,s),y(Po,t,s),l(t,wJ,s),l(t,Do,s),l(t,JJ,s),y(Oo,t,s),l(t,UJ,s),l(t,Ko,s),l(t,mJ,s),l(t,ti,s),l(t,fJ,s),l(t,ei,s),l(t,IJ,s),l(t,si,s),l(t,CJ,s),l(t,li,s),l(t,vJ,s),l(t,Tt,s),u(Tt,Ue),u(Ue,yc),y(ai,yc,null),u(Tt,sI),u(Tt,ar),l(t,bJ,s),l(t,ni,s),l(t,AJ,s),l(t,pi,s),l(t,gJ,s),l(t,oi,s),l(t,_J,s),l(t,wt,s),u(wt,me),u(me,jc),y(ii,jc,null),u(wt,lI),u(wt,nr),l(t,BJ,s),l(t,Mi,s),l(t,ZJ,s),y(ui,t,s),l(t,xJ,s),l(t,ri,s),l(t,qJ,s),l(t,ci,s),l(t,kJ,s),y(hi,t,s),l(t,SJ,s),l(t,yi,s),l(t,$J,s),l(t,ji,s),l(t,NJ,s),l(t,di,s),l(t,zJ,s),l(t,Ti,s),l(t,EJ,s),l(t,Jt,s),u(Jt,fe),u(fe,dc),y(wi,dc,null),u(Jt,aI),u(Jt,pr),l(t,GJ,s),l(t,Ji,s),l(t,WJ,s),l(t,Ui,s),l(t,RJ,s),l(t,mi,s),l(t,XJ,s),y(fi,t,s),l(t,HJ,s),l(t,Ii,s),l(t,QJ,s),l(t,or,s),l(t,VJ,s),l(t,Ut,s),u(Ut,Ie),u(Ie,Tc),y(Ci,Tc,null),u(Ut,nI),u(Ut,ir),l(t,YJ,s),l(t,vi,s),l(t,LJ,s),l(t,bi,s),l(t,FJ,s),y(Ai,t,s),l(t,PJ,s),l(t,gi,s),l(t,DJ,s),l(t,_i,s),l(t,OJ,s),y(Bi,t,s),l(t,KJ,s),l(t,Zi,s),l(t,tU,s),l(t,xi,s),l(t,eU,s),l(t,mt,s),u(mt,Ce),u(Ce,wc),y(qi,wc,null),u(mt,pI),u(mt,Mr),l(t,sU,s),l(t,ki,s),l(t,lU,s),l(t,Si,s),l(t,aU,s),y($i,t,s),l(t,nU,s),l(t,Ni,s),l(t,pU,s),l(t,zi,s),l(t,oU,s),l(t,Ei,s),l(t,iU,s),l(t,Gi,s),l(t,MU,s),y(Wi,t,s),l(t,uU,s),l(t,Ri,s),l(t,rU,s),l(t,Xi,s),l(t,cU,s),l(t,ft,s),u(ft,ve),u(ve,Jc),y(Hi,Jc,null),u(ft,oI),u(ft,ur),l(t,hU,s),l(t,Qi,s),l(t,yU,s),l(t,Vi,s),l(t,jU,s),l(t,C,s),u(C,rr),u(C,iI),u(C,cr),u(C,MI),u(C,Yi),u(Yi,hr),u(Yi,uI),y(Li,Yi,null),u(C,rI),u(C,yr),u(C,cI),u(C,jr),u(C,hI),u(C,dr),l(t,dU,s),l(t,Fi,s),l(t,TU,s),l(t,Pi,s),l(t,wU,s),l(t,It,s),u(It,be),u(be,Uc),y(Di,Uc,null),u(It,yI),u(It,Tr),l(t,JU,s),l(t,Ct,s),u(Ct,Ae),u(Ae,mc),y(Oi,mc,null),u(Ct,jI),u(Ct,wr),l(t,UU,s),l(t,Ki,s),l(t,mU,s),l(t,vt,s),u(vt,ge),u(ge,fc),y(tM,fc,null),u(vt,dI),u(vt,Jr),l(t,fU,s),l(t,eM,s),l(t,IU,s),l(t,sM,s),l(t,CU,s),y(lM,t,s),l(t,vU,s),l(t,aM,s),l(t,bU,s),y(nM,t,s),l(t,AU,s),l(t,pM,s),l(t,gU,s),l(t,oM,s),l(t,_U,s),l(t,iM,s),l(t,BU,s),l(t,bt,s),u(bt,_e),u(_e,Ic),y(MM,Ic,null),u(bt,TI),u(bt,Ur),l(t,ZU,s),l(t,uM,s),l(t,xU,s),l(t,At,s),u(At,Be),u(Be,Cc),y(rM,Cc,null),u(At,wI),u(At,mr),l(t,qU,s),l(t,cM,s),l(t,kU,s),l(t,hM,s),l(t,SU,s),l(t,yM,s),l(t,$U,s),l(t,jM,s),l(t,NU,s),l(t,dM,s),l(t,zU,s),y(TM,t,s),l(t,EU,s),l(t,wM,s),l(t,GU,s),y(JM,t,s),l(t,WU,s),l(t,UM,s),l(t,RU,s),l(t,gt,s),u(gt,Ze),u(Ze,vc),y(mM,vc,null),u(gt,JI),u(gt,fr),l(t,XU,s),l(t,g,s),y(fM,g,null),u(g,UI),u(g,Ir),u(g,mI),u(g,Cr),u(g,fI),u(g,vr),l(t,HU,s),l(t,_t,s),u(_t,xe),u(xe,bc),y(IM,bc,null),u(_t,II),u(_t,br),l(t,QU,s),l(t,CM,s),l(t,VU,s),l(t,vM,s),l(t,YU,s),l(t,bM,s),l(t,LU,s),l(t,AM,s),l(t,FU,s),l(t,gM,s),l(t,PU,s),y(_M,t,s),l(t,DU,s),l(t,BM,s),l(t,OU,s),y(ZM,t,s),l(t,KU,s),l(t,xM,s),l(t,tm,s),l(t,Bt,s),u(Bt,qe),u(qe,Ac),y(qM,Ac,null),u(Bt,CI),u(Bt,Ar),l(t,em,s),l(t,kM,s),l(t,sm,s),l(t,SM,s),l(t,lm,s),l(t,Zt,s),u(Zt,ke),u(ke,gc),y($M,gc,null),u(Zt,vI),u(Zt,gr),l(t,am,s),l(t,NM,s),l(t,nm,s),l(t,zM,s),l(t,pm,s),y(EM,t,s),l(t,om,s),l(t,GM,s),l(t,im,s),y(WM,t,s),l(t,Mm,s),l(t,xt,s),u(xt,Se),u(Se,_c),y(RM,_c,null),u(xt,bI),u(xt,_r),l(t,um,s),l(t,XM,s),l(t,rm,s),l(t,HM,s),l(t,cm,s),l(t,QM,s),l(t,hm,s),l(t,VM,s),l(t,ym,s),l(t,Bc,s),jm=!0},p(t,[s]){const YM={};s&2&&(YM.$$scope={dirty:s,ctx:t}),Yt.$set(YM);const Zc={};s&2&&(Zc.$$scope={dirty:s,ctx:t}),ce.$set(Zc);const xc={};s&2&&(xc.$$scope={dirty:s,ctx:t}),Je.$set(xc)},i(t){jm||(j(x.$$.fragment,t),j(Pe.$$.fragment,t),j(De.$$.fragment,t),j(Ke.$$.fragment,t),j(es.$$.fragment,t),j(ps.$$.fragment,t),j(Ms.$$.fragment,t),j(cs.$$.fragment,t),j(Ts.$$.fragment,t),j(Js.$$.fragment,t),j(ms.$$.fragment,t),j(vs.$$.fragment,t),j(gs.$$.fragment,t),j(Bs.$$.fragment,t),j(ks.$$.fragment,t),j(Ns.$$.fragment,t),j(Es.$$.fragment,t),j(Hs.$$.fragment,t),j(Fs.$$.fragment,t),j(Ps.$$.fragment,t),j(Ks.$$.fragment,t),j(el.$$.fragment,t),j(al.$$.fragment,t),j(pl.$$.fragment,t),j(il.$$.fragment,t),j(rl.$$.fragment,t),j(hl.$$.fragment,t),j(jl.$$.fragment,t),j(Tl.$$.fragment,t),j(Jl.$$.fragment,t),j(ml.$$.fragment,t),j(Cl.$$.fragment,t),j(gl.$$.fragment,t),j(Bl.$$.fragment,t),j(xl.$$.fragment,t),j(Sl.$$.fragment,t),j(zl.$$.fragment,t),j(Gl.$$.fragment,t),j(Hl.$$.fragment,t),j(Vl.$$.fragment,t),j(Fl.$$.fragment,t),j(Dl.$$.fragment,t),j(Ol.$$.fragment,t),j(Yt.$$.fragment,t),j(pa.$$.fragment,t),j(ra.$$.fragment,t),j(ha.$$.fragment,t),j(Ta.$$.fragment,t),j(Ja.$$.fragment,t),j(ma.$$.fragment,t),j(Na.$$.fragment,t),j(Ga.$$.fragment,t),j(Ra.$$.fragment,t),j(Ha.$$.fragment,t),j(Qa.$$.fragment,t),j(La.$$.fragment,t),j(Ka.$$.fragment,t),j(an.$$.fragment,t),j(pn.$$.fragment,t),j(Mn.$$.fragment,t),j(un.$$.fragment,t),j(cn.$$.fragment,t),j(yn.$$.fragment,t),j(jn.$$.fragment,t),j(qn.$$.fragment,t),j(En.$$.fragment,t),j(Xn.$$.fragment,t),j(Yn.$$.fragment,t),j(On.$$.fragment,t),j(ep.$$.fragment,t),j(ap.$$.fragment,t),j(pp.$$.fragment,t),j(cp.$$.fragment,t),j(dp.$$.fragment,t),j(Jp.$$.fragment,t),j(mp.$$.fragment,t),j(Cp.$$.fragment,t),j(Ap.$$.fragment,t),j(_p.$$.fragment,t),j(Zp.$$.fragment,t),j(Sp.$$.fragment,t),j(zp.$$.fragment,t),j(Gp.$$.fragment,t),j(Hp.$$.fragment,t),j(ce.$$.fragment,t),j(Qp.$$.fragment,t),j(Pp.$$.fragment,t),j(Kp.$$.fragment,t),j(eo.$$.fragment,t),j(no.$$.fragment,t),j(io.$$.fragment,t),j(uo.$$.fragment,t),j(ho.$$.fragment,t),j(jo.$$.fragment,t),j(wo.$$.fragment,t),j(mo.$$.fragment,t),j(Io.$$.fragment,t),j(vo.$$.fragment,t),j(go.$$.fragment,t),j(Bo.$$.fragment,t),j(So.$$.fragment,t),j(Wo.$$.fragment,t),j(Xo.$$.fragment,t),j(Je.$$.fragment,t),j(Vo.$$.fragment,t),j(Po.$$.fragment,t),j(Oo.$$.fragment,t),j(ai.$$.fragment,t),j(ii.$$.fragment,t),j(ui.$$.fragment,t),j(hi.$$.fragment,t),j(wi.$$.fragment,t),j(fi.$$.fragment,t),j(Ci.$$.fragment,t),j(Ai.$$.fragment,t),j(Bi.$$.fragment,t),j(qi.$$.fragment,t),j($i.$$.fragment,t),j(Wi.$$.fragment,t),j(Hi.$$.fragment,t),j(Li.$$.fragment,t),j(Di.$$.fragment,t),j(Oi.$$.fragment,t),j(tM.$$.fragment,t),j(lM.$$.fragment,t),j(nM.$$.fragment,t),j(MM.$$.fragment,t),j(rM.$$.fragment,t),j(TM.$$.fragment,t),j(JM.$$.fragment,t),j(mM.$$.fragment,t),j(fM.$$.fragment,t),j(IM.$$.fragment,t),j(_M.$$.fragment,t),j(ZM.$$.fragment,t),j(qM.$$.fragment,t),j($M.$$.fragment,t),j(EM.$$.fragment,t),j(WM.$$.fragment,t),j(RM.$$.fragment,t),jm=!0)},o(t){d(x.$$.fragment,t),d(Pe.$$.fragment,t),d(De.$$.fragment,t),d(Ke.$$.fragment,t),d(es.$$.fragment,t),d(ps.$$.fragment,t),d(Ms.$$.fragment,t),d(cs.$$.fragment,t),d(Ts.$$.fragment,t),d(Js.$$.fragment,t),d(ms.$$.fragment,t),d(vs.$$.fragment,t),d(gs.$$.fragment,t),d(Bs.$$.fragment,t),d(ks.$$.fragment,t),d(Ns.$$.fragment,t),d(Es.$$.fragment,t),d(Hs.$$.fragment,t),d(Fs.$$.fragment,t),d(Ps.$$.fragment,t),d(Ks.$$.fragment,t),d(el.$$.fragment,t),d(al.$$.fragment,t),d(pl.$$.fragment,t),d(il.$$.fragment,t),d(rl.$$.fragment,t),d(hl.$$.fragment,t),d(jl.$$.fragment,t),d(Tl.$$.fragment,t),d(Jl.$$.fragment,t),d(ml.$$.fragment,t),d(Cl.$$.fragment,t),d(gl.$$.fragment,t),d(Bl.$$.fragment,t),d(xl.$$.fragment,t),d(Sl.$$.fragment,t),d(zl.$$.fragment,t),d(Gl.$$.fragment,t),d(Hl.$$.fragment,t),d(Vl.$$.fragment,t),d(Fl.$$.fragment,t),d(Dl.$$.fragment,t),d(Ol.$$.fragment,t),d(Yt.$$.fragment,t),d(pa.$$.fragment,t),d(ra.$$.fragment,t),d(ha.$$.fragment,t),d(Ta.$$.fragment,t),d(Ja.$$.fragment,t),d(ma.$$.fragment,t),d(Na.$$.fragment,t),d(Ga.$$.fragment,t),d(Ra.$$.fragment,t),d(Ha.$$.fragment,t),d(Qa.$$.fragment,t),d(La.$$.fragment,t),d(Ka.$$.fragment,t),d(an.$$.fragment,t),d(pn.$$.fragment,t),d(Mn.$$.fragment,t),d(un.$$.fragment,t),d(cn.$$.fragment,t),d(yn.$$.fragment,t),d(jn.$$.fragment,t),d(qn.$$.fragment,t),d(En.$$.fragment,t),d(Xn.$$.fragment,t),d(Yn.$$.fragment,t),d(On.$$.fragment,t),d(ep.$$.fragment,t),d(ap.$$.fragment,t),d(pp.$$.fragment,t),d(cp.$$.fragment,t),d(dp.$$.fragment,t),d(Jp.$$.fragment,t),d(mp.$$.fragment,t),d(Cp.$$.fragment,t),d(Ap.$$.fragment,t),d(_p.$$.fragment,t),d(Zp.$$.fragment,t),d(Sp.$$.fragment,t),d(zp.$$.fragment,t),d(Gp.$$.fragment,t),d(Hp.$$.fragment,t),d(ce.$$.fragment,t),d(Qp.$$.fragment,t),d(Pp.$$.fragment,t),d(Kp.$$.fragment,t),d(eo.$$.fragment,t),d(no.$$.fragment,t),d(io.$$.fragment,t),d(uo.$$.fragment,t),d(ho.$$.fragment,t),d(jo.$$.fragment,t),d(wo.$$.fragment,t),d(mo.$$.fragment,t),d(Io.$$.fragment,t),d(vo.$$.fragment,t),d(go.$$.fragment,t),d(Bo.$$.fragment,t),d(So.$$.fragment,t),d(Wo.$$.fragment,t),d(Xo.$$.fragment,t),d(Je.$$.fragment,t),d(Vo.$$.fragment,t),d(Po.$$.fragment,t),d(Oo.$$.fragment,t),d(ai.$$.fragment,t),d(ii.$$.fragment,t),d(ui.$$.fragment,t),d(hi.$$.fragment,t),d(wi.$$.fragment,t),d(fi.$$.fragment,t),d(Ci.$$.fragment,t),d(Ai.$$.fragment,t),d(Bi.$$.fragment,t),d(qi.$$.fragment,t),d($i.$$.fragment,t),d(Wi.$$.fragment,t),d(Hi.$$.fragment,t),d(Li.$$.fragment,t),d(Di.$$.fragment,t),d(Oi.$$.fragment,t),d(tM.$$.fragment,t),d(lM.$$.fragment,t),d(nM.$$.fragment,t),d(MM.$$.fragment,t),d(rM.$$.fragment,t),d(TM.$$.fragment,t),d(JM.$$.fragment,t),d(mM.$$.fragment,t),d(fM.$$.fragment,t),d(IM.$$.fragment,t),d(_M.$$.fragment,t),d(ZM.$$.fragment,t),d(qM.$$.fragment,t),d($M.$$.fragment,t),d(EM.$$.fragment,t),d(WM.$$.fragment,t),d(RM.$$.fragment,t),jm=!1},d(t){t&&(e(v),e(m),e(I),e(_),e(qc),e(Ne),e(kc),e(ze),e(Sc),e(Ee),e($c),e(Ge),e(Nc),e(We),e(zc),e(Re),e(Ec),e(Xe),e(Gc),e(He),e(Wc),e(Qe),e(Rc),e(Ve),e(Xc),e(Ye),e(Hc),e(Le),e(Qc),e(Fe),e(Vc),e(LM),e(Yc),e(q),e(Lc),e(PM),e(Fc),e(k),e(Pc),e(Oe),e(Dc),e(Oc),e(ts),e(Kc),e(th),e(ss),e(eh),e(ls),e(sh),e(as),e(lh),e(ns),e(ah),e(nh),e(os),e(ph),e(is),e(oh),e(ih),e(us),e(Mh),e(rs),e(uh),e(rh),e(hs),e(ch),e(ys),e(hh),e(js),e(yh),e(ds),e(jh),e(dh),e(ws),e(Th),e(wh),e(Us),e(Jh),e(Uh),e(fs),e(mh),e(Is),e(fh),e(Cs),e(Ih),e(OM),e(Ch),e(S),e(vh),e(bs),e(bh),e(As),e(Ah),e(gh),e(_s),e(_h),e(Bh),e(Zs),e(Zh),e(xs),e(xh),e(qs),e(qh),e(kh),e(Ss),e(Sh),e($s),e($h),e(tu),e(Nh),e($),e(zh),e(zs),e(Eh),e(Gh),e(Gs),e(Wh),e(Ws),e(Rh),e(Rs),e(Xh),e(Xs),e(Hh),e(Qh),e(Qs),e(Vh),e(Vs),e(Yh),e(Ys),e(Lh),e(Ls),e(Fh),e(su),e(Ph),e(nu),e(Dh),e(z),e(Oh),e(Ds),e(Kh),e(Os),e(ty),e(E),e(ey),e(tl),e(sy),e(ly),e(sl),e(ay),e(ll),e(ny),e(G),e(py),e(nl),e(oy),e(iy),e(ol),e(My),e(uy),e(Ml),e(ry),e(ul),e(cy),e(W),e(hy),e(cl),e(yy),e(jy),e(yl),e(dy),e(Ty),e(dl),e(wy),e(R),e(Jy),e(wl),e(Uy),e(my),e(Ul),e(fy),e(ru),e(Iy),e(X),e(Cy),e(fl),e(vy),e(Il),e(by),e(Ay),e(vl),e(gy),e(bl),e(_y),e(Al),e(By),e(Zy),e(_l),e(xy),e(qy),e(Zl),e(ky),e(Sy),e(ql),e($y),e(kl),e(Ny),e(hu),e(zy),e(H),e(Ey),e($l),e(Gy),e(Nl),e(Wy),e(Ry),e(El),e(Xy),e(Hy),e(Wl),e(Qy),e(Rl),e(Vy),e(Xl),e(Yy),e(Ly),e(Ql),e(Fy),e(ju),e(Py),e(Q),e(Dy),e(Yl),e(Oy),e(Ll),e(Ky),e(tj),e(Pl),e(ej),e(sj),e(Tu),e(lj),e(V),e(aj),e(nj),e(Kl),e(pj),e(ta),e(oj),e(ea),e(ij),e(sa),e(Mj),e(la),e(uj),e(aa),e(rj),e(na),e(cj),e(Ju),e(hj),e(Y),e(yj),e(oa),e(jj),e(ia),e(dj),e(Ma),e(Tj),e(ua),e(wj),e(mu),e(Jj),e(L),e(Uj),e(ca),e(mj),e(fj),e(ya),e(Ij),e(ja),e(Cj),e(da),e(vj),e(bj),e(wa),e(Aj),e(Iu),e(gj),e(F),e(_j),e(Ua),e(Bj),e(Zj),e(fa),e(xj),e(Ia),e(qj),e(Ca),e(kj),e(va),e(Sj),e(ba),e($j),e(Aa),e(Nj),e(ga),e(zj),e(_a),e(Ej),e(Ba),e(Gj),e(Za),e(Wj),e(xa),e(Rj),e(qa),e(Xj),e(ka),e(Hj),e(Sa),e(Qj),e($a),e(Vj),e(P),e(Yj),e(za),e(Lj),e(Ea),e(Fj),e(Pj),e(Wa),e(Dj),e(D),e(Oj),e(Xa),e(Kj),e(td),e(Au),e(ed),e(O),e(sd),e(Va),e(ld),e(Ya),e(ad),e(nd),e(Fa),e(pd),e(Pa),e(od),e(Da),e(id),e(Oa),e(Md),e(_u),e(ud),e(K),e(rd),e(tn),e(cd),e(en),e(hd),e(sn),e(yd),e(ln),e(jd),e(Zu),e(dd),e(tt),e(Td),e(nn),e(wd),e(Jd),e(on),e(Ud),e(md),e(qu),e(fd),e(et),e(Id),e(rn),e(Cd),e(vd),e(hn),e(bd),e(Ad),e(st),e(gd),e(dn),e(_d),e(Tn),e(Bd),e(wn),e(Zd),e(Jn),e(xd),e(Un),e(qd),e(mn),e(kd),e(fn),e(Sd),e(In),e($d),e(Cn),e(Nd),e(vn),e(zd),e(bn),e(Ed),e(An),e(Gd),e(gn),e(Wd),e(_n),e(Rd),e(Bn),e(Xd),e(Zn),e(Hd),e(xn),e(Qd),e(lt),e(Vd),e(kn),e(Yd),e(Sn),e(Ld),e($n),e(Fd),e(Nn),e(Pd),e(zn),e(Dd),e(at),e(Od),e(Gn),e(Kd),e(Wn),e(tT),e(Rn),e(eT),e(zu),e(sT),e(nt),e(lT),e(Hn),e(aT),e(Qn),e(nT),e(Vn),e(pT),e(oT),e(Ln),e(iT),e(Fn),e(MT),e(Pn),e(uT),e(Dn),e(rT),e(cT),e(Kn),e(hT),e(tp),e(yT),e(jT),e(sp),e(dT),e(lp),e(TT),e(wT),e(np),e(JT),e(Gu),e(UT),e(pt),e(mT),e(op),e(fT),e(ip),e(IT),e(Mp),e(CT),e(up),e(vT),e(rp),e(bT),e(AT),e(hp),e(gT),e(yp),e(_T),e(jp),e(BT),e(ZT),e(Tp),e(xT),e(wp),e(qT),e(kT),e(Up),e(ST),e(Ru),e($T),e(ot),e(NT),e(fp),e(zT),e(Ip),e(ET),e(GT),e(vp),e(WT),e(bp),e(RT),e(Hu),e(XT),e(it),e(HT),e(gp),e(QT),e(Mt),e(VT),e(Bp),e(YT),e(LT),e(xp),e(FT),e(qp),e(PT),e(kp),e(DT),e(OT),e($p),e(KT),e(Np),e(tw),e(ut),e(ew),e(Ep),e(sw),e(lw),e(Wp),e(aw),e(Rp),e(nw),e(Xp),e(pw),e(ow),e(iw),e(rt),e(Mw),e(Vp),e(uw),e(Yp),e(rw),e(Lp),e(cw),e(Fp),e(hw),e(yw),e(Dp),e(jw),e(Op),e(dw),e(ct),e(Tw),e(to),e(ww),e(Jw),e(so),e(Uw),e(lo),e(mw),e(ao),e(fw),e(Iw),e(po),e(Cw),e(oo),e(vw),e(Pu),e(bw),e(ht),e(Aw),e(Mo),e(gw),e(_w),e(ro),e(Bw),e(co),e(Zw),e(xw),e(yo),e(qw),e(Ou),e(kw),e(yt),e(Sw),e(To),e($w),e(Nw),e(Jo),e(zw),e(Uo),e(Ew),e(Gw),e(fo),e(Ww),e(tr),e(Rw),e(jt),e(Xw),e(Co),e(Hw),e(Qw),e(bo),e(Vw),e(Ao),e(Yw),e(Lw),e(_o),e(Fw),e(sr),e(Pw),e(dt),e(Dw),e(Zo),e(Ow),e(xo),e(Kw),e(qo),e(tJ),e(ko),e(eJ),e(sJ),e($o),e(lJ),e(No),e(aJ),e(zo),e(nJ),e(Eo),e(pJ),e(Go),e(oJ),e(iJ),e(Ro),e(MJ),e(uJ),e(rJ),e(Ho),e(cJ),e(Qo),e(hJ),e(yJ),e(Yo),e(jJ),e(Lo),e(dJ),e(Fo),e(TJ),e(wJ),e(Do),e(JJ),e(UJ),e(Ko),e(mJ),e(ti),e(fJ),e(ei),e(IJ),e(si),e(CJ),e(li),e(vJ),e(Tt),e(bJ),e(ni),e(AJ),e(pi),e(gJ),e(oi),e(_J),e(wt),e(BJ),e(Mi),e(ZJ),e(xJ),e(ri),e(qJ),e(ci),e(kJ),e(SJ),e(yi),e($J),e(ji),e(NJ),e(di),e(zJ),e(Ti),e(EJ),e(Jt),e(GJ),e(Ji),e(WJ),e(Ui),e(RJ),e(mi),e(XJ),e(HJ),e(Ii),e(QJ),e(or),e(VJ),e(Ut),e(YJ),e(vi),e(LJ),e(bi),e(FJ),e(PJ),e(gi),e(DJ),e(_i),e(OJ),e(KJ),e(Zi),e(tU),e(xi),e(eU),e(mt),e(sU),e(ki),e(lU),e(Si),e(aU),e(nU),e(Ni),e(pU),e(zi),e(oU),e(Ei),e(iU),e(Gi),e(MU),e(uU),e(Ri),e(rU),e(Xi),e(cU),e(ft),e(hU),e(Qi),e(yU),e(Vi),e(jU),e(C),e(dU),e(Fi),e(TU),e(Pi),e(wU),e(It),e(JU),e(Ct),e(UU),e(Ki),e(mU),e(vt),e(fU),e(eM),e(IU),e(sM),e(CU),e(vU),e(aM),e(bU),e(AU),e(pM),e(gU),e(oM),e(_U),e(iM),e(BU),e(bt),e(ZU),e(uM),e(xU),e(At),e(qU),e(cM),e(kU),e(hM),e(SU),e(yM),e($U),e(jM),e(NU),e(dM),e(zU),e(EU),e(wM),e(GU),e(WU),e(UM),e(RU),e(gt),e(XU),e(g),e(HU),e(_t),e(QU),e(CM),e(VU),e(vM),e(YU),e(bM),e(LU),e(AM),e(FU),e(gM),e(PU),e(DU),e(BM),e(OU),e(KU),e(xM),e(tm),e(Bt),e(em),e(kM),e(sm),e(SM),e(lm),e(Zt),e(am),e(NM),e(nm),e(zM),e(pm),e(om),e(GM),e(im),e(Mm),e(xt),e(um),e(XM),e(rm),e(HM),e(cm),e(QM),e(hm),e(VM),e(ym),e(Bc)),e(U),T(x),T(Pe),T(De),T(Ke,t),T(es,t),T(ps,t),T(Ms,t),T(cs,t),T(Ts,t),T(Js,t),T(ms,t),T(vs),T(gs,t),T(Bs,t),T(ks,t),T(Ns),T(Es,t),T(Hs,t),T(Fs),T(Ps),T(Ks),T(el,t),T(al),T(pl,t),T(il,t),T(rl),T(hl,t),T(jl,t),T(Tl),T(Jl,t),T(ml),T(Cl,t),T(gl,t),T(Bl,t),T(xl,t),T(Sl),T(zl,t),T(Gl,t),T(Hl,t),T(Vl),T(Fl,t),T(Dl,t),T(Ol),T(Yt,t),T(pa),T(ra),T(ha,t),T(Ta,t),T(Ja),T(ma,t),T(Na),T(Ga,t),T(Ra),T(Ha,t),T(Qa),T(La,t),T(Ka),T(an),T(pn,t),T(Mn,t),T(un),T(cn,t),T(yn,t),T(jn),T(qn),T(En),T(Xn),T(Yn,t),T(On,t),T(ep,t),T(ap,t),T(pp),T(cp,t),T(dp,t),T(Jp,t),T(mp),T(Cp,t),T(Ap),T(_p),T(Zp,t),T(Sp,t),T(zp),T(Gp,t),T(Hp,t),T(ce,t),T(Qp),T(Pp,t),T(Kp),T(eo,t),T(no,t),T(io),T(uo,t),T(ho,t),T(jo),T(wo,t),T(mo,t),T(Io),T(vo,t),T(go,t),T(Bo),T(So,t),T(Wo,t),T(Xo,t),T(Je,t),T(Vo,t),T(Po,t),T(Oo,t),T(ai),T(ii),T(ui,t),T(hi,t),T(wi),T(fi,t),T(Ci),T(Ai,t),T(Bi,t),T(qi),T($i,t),T(Wi,t),T(Hi),T(Li),T(Di),T(Oi),T(tM),T(lM,t),T(nM,t),T(MM),T(rM),T(TM,t),T(JM,t),T(mM),T(fM),T(IM),T(_M,t),T(ZM,t),T(qM),T($M),T(EM,t),T(WM,t),T(RM)}}}const g0={local:"deepspeed-integration",sections:[{local:"trainer-deepspeed-integration",sections:[{local:"installation",title:"Installation"},{local:"deployment-with-multiple-gpus",title:"Deployment with multiple GPUs"},{local:"deployment-with-one-gpu",title:"Deployment with one GPU"},{local:"deployment-with-multiple-nodes",sections:[{local:"the-torchdistributedrun-launcher",title:"The torch.distributed.run launcher"},{local:"the-deepspeed-launcher",title:"The deepspeed launcher"},{local:"launching-in-a-slurm-environment",title:"Launching in a SLURM environment"},{local:"use-of-nonshared-filesystem",title:"Use of Non-shared filesystem"}],title:"Deployment with multiple Nodes"},{local:"deployment-in-notebooks",title:"Deployment in Notebooks"},{local:"configuration",title:"Configuration"},{local:"passing-configuration",title:"Passing Configuration"},{local:"shared-configuration",title:"Shared Configuration"},{local:"zero",sections:[{local:"zero2-config",title:"ZeRO-2 Config"},{local:"zero3-config",title:"ZeRO-3 Config"},{local:"zero0-config",title:"ZeRO-0 Config"},{local:"zero1-config",title:"ZeRO-1 Config"}],title:"ZeRO"},{local:"nvme-support",sections:[{local:"zero2-vs-zero3-performance",title:"ZeRO-2 vs ZeRO-3 Performance"},{local:"zero2-example",title:"ZeRO-2 Example"},{local:"zero3-example",title:"ZeRO-3 Example"},{local:"how-to-choose-which-zero-stage-and-offloads-to-use-for-best-performance",title:"How to Choose Which ZeRO Stage and Offloads To Use For Best Performance"}],title:"NVMe Support"},{local:"activation-checkpointing-or-gradient-checkpointing",title:"Activation Checkpointing or Gradient Checkpointing"},{local:"optimizer-and-scheduler",sections:[{local:"optimizer",title:"Optimizer"},{local:"scheduler",title:"Scheduler"}],title:"Optimizer and Scheduler"},{local:"fp32-precision",title:"fp32 Precision"},{local:"automatic-mixed-precision",title:"Automatic Mixed Precision"},{local:"fp16",title:"fp16"},{local:"bf16",title:"bf16"},{local:"nccl-collectives",title:"NCCL Collectives"},{local:"apex",title:"apex"},{local:"batch-size",title:"Batch Size"},{local:"gradient-accumulation",title:"Gradient Accumulation"},{local:"gradient-clipping",title:"Gradient Clipping"},{local:"getting-the-model-weights-out",title:"Getting The Model Weights Out"},{local:"zero3-and-infinity-nuances",sections:[{local:"constructing-massive-models",title:"Constructing Massive Models"},{local:"gathering-parameters",title:"Gathering Parameters"}],title:"ZeRO-3 and Infinity Nuances"},{local:"zero-inference",title:"ZeRO Inference"},{local:"memory-requirements",title:"Memory Requirements"},{local:"filing-issues",title:"Filing Issues"},{local:"troubleshooting",sections:[{local:"the-deepspeed-process-gets-killed-at-startup-without-a-traceback",title:"the `deepspeed` process gets killed at startup without a traceback"},{local:"training-andor-evalpredict-loss-is-nan",title:"training and/or eval/predict loss is `NaN`"}],title:"Troubleshooting"},{local:"notes",title:"Notes"}],title:"Trainer Deepspeed Integration"},{local:"nontrainer-deepspeed-integration",title:"Non-Trainer Deepspeed Integration"},{local:"transformers.integrations.HfDeepSpeedConfig",sections:[{local:"custom-deepspeed-zero-inference",title:"Custom DeepSpeed ZeRO Inference"},{local:"generate-nuances",title:"`generate` nuances"}],title:"HfDeepSpeedConfig"},{local:"testing-deepspeed-integration",title:"Testing Deepspeed Integration"},{local:"main-deepspeed-resources",title:"Main DeepSpeed Resources"}],title:"DeepSpeed Integration"};function _0(qt){return J0(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $0 extends U0{constructor(U){super(),m0(this,U,_0,A0,w0,{})}}export{$0 as component};
