import{s as jt,o as wt,n as Tt}from"../chunks/scheduler.37c15a92.js";import{S as Ut,i as ht,g as M,s,r as i,A as ft,h as m,f as t,c as n,j as ut,u as o,x as u,k as yt,y as Ct,a,v as r,d as p,t as c,w as d,m as It,n as Zt}from"../chunks/index.2bf4358c.js";import{T as bt}from"../chunks/Tip.363c041f.js";import{Y as Jt}from"../chunks/Youtube.1e50a667.js";import{C as y}from"../chunks/CodeBlock.4f5fc1ad.js";import{D as Bt}from"../chunks/DocNotebookDropdown.d9dfeb24.js";import{H as Ge}from"../chunks/Heading.8ada512a.js";function gt(Ze){let b,J="✏️ <strong>Prova tu!</strong> Modifica il ciclo di addestramento precedente per affinare il modello sul dataset SST-2.";return{c(){b=M("p"),b.innerHTML=J},l(j){b=m(j,"P",{"data-svelte-h":!0}),u(b)!=="svelte-1tob4ng"&&(b.innerHTML=J)},m(j,Be){a(j,b,Be)},p:Tt,d(j){j&&t(b)}}}function Gt(Ze){let b;return{c(){b=It('⚠️ Per poter beneficiare dell\'accelerazione offerta da Cloud TPUs, è raccomandabile applicare padding ad una lunghezza fissa tramite gli argomenti `padding="max_length"` e `max_length` del tokenizer.')},l(J){b=Zt(J,'⚠️ Per poter beneficiare dell\'accelerazione offerta da Cloud TPUs, è raccomandabile applicare padding ad una lunghezza fissa tramite gli argomenti `padding="max_length"` e `max_length` del tokenizer.')},m(J,j){a(J,b,j)},d(J){J&&t(b)}}}function vt(Ze){let b,J,j,Be,U,ve,h,$e,f,ke,C,Yl="Ora vedremo come ottenere gli stessi risultati della sezione precedente senza utilizzare la classe <code>Trainer</code>. Ancora una volta, aver compiuto il processing dei dati spiegato nella sezione 2 è un prerequisito. Ecco un riassunto di tutto ciò di cui avrete bisogno:",ze,I,Xe,Z,We,B,Vl="Prima di cominciare a scrivere il nostro ciclo di addestramento, dobbiamo definire alcuni oggetti. Per prima cosa, i dataloaders (caricatori di dati) che useremo per iterare sulle batch. Ma prima di poter definire i dataloaders, dobbiamo applicare un po’ di postprocessing ai nostri <code>tokenized_datasets</code>, per compiere alcune operazione che <code>Trainer</code> gestiva in automatico per noi. Nello specifico dobbiamo:",_e,g,Nl="<li>Rimuovere le colonne corrispondente a valori che il modello non si aspetta (come ad esempio le colonne <code>sentence1</code> e <code>sentence2 </code>).</li> <li>Rinominare la colonna <code>label</code> a <code>labels</code> (perché il modello si aspetta questo nome).</li> <li>Fissare il formato dei datasets in modo che restituiscano tensori Pytorch invece di liste.</li>",Re,G,Al="L’oggetto <code>tokenized_datasets</code> ha un metodo per ciascuno di questi punti:",Ye,v,Ve,$,El="Possiamo poi controllare che il risultato ha solo solo colonne che saranno accettate dal nostro modello:",Ne,k,Ae,z,Fl="Ora che questo è fatto, possiamo finalmente definire i dataloaders in maniera semplice:",Ee,X,Fe,W,Ql="Per controllare velocemente che non ci sono errori nel processing dei dati, possiamo ispezionare una batch in questo modo:",Qe,_,He,R,xe,Y,Hl="È importante sottolineare che i valori di shape (forma) potrebbero essere leggermente diversi per voi, poiché abbiamo fissato <code>shuffle=True</code> (rimescolamento attivo) per i dataloader di apprendimento, e stiamo applicando padding alla lunghezza massima all’interno della batch.",Se,V,xl="Ora che il preprocessing dei dati è completato (uno scopo soddisfacente ma elusivo per qualunque praticante di ML), focalizziamoci sul modello. Lo istanziamo esattamente come avevamo fatto nella sezione precedente:",qe,N,Le,A,Sl="Per assicurarci che tutto andrà bene durante l’addestramento, passiamo la batch al modello:",Ke,E,Pe,F,De,Q,ql="Tutti i modelli 🤗 Transformers restituiscono il valore obiettivo quando vengono fornite loro le <code>labels</code>, e anche i logits (due per ciascun input della batch, quindi un tensore di dimensioni 8 x 2).",Oe,H,Ll='Siamo quasi pronti a scrivere il ciclo di addestramento! Mancano solo due cose: un ottimizzatore e un learning rate scheduler. Poiché stiamo tentando di replicare a mano ciò che viene fatto dal <code>Trainer</code>, utilizzeremo gli stessi valori di default. L’ottimizzatore utilizzato dal <code>Trainer</code> è <code>AdamW</code>, che è lo stesso di Adam ma con una variazione per quanto riguarda la regolarizzazione del decadimento dei pesi (rif. <a href="https://arxiv.org/abs/1711.05101" rel="nofollow">“Decoupled Weight Decay Regularization”</a> di Ilya Loshchilov e Frank Hutter):',el,x,ll,S,Kl="Infine, il learning rate scheduler usato di default è solo un decadimento lineare dal valore massimo (5e-5) fino a 0. Per definirlo correttamente, dobbiamo sapere il numero di iterazioni per l’addestramento, che è dato dal numero di epoche che vogliamo eseguire moltiplicato per il numero di batch per l’addestramento (ovverosia la lunghezza del dataloader). Il <code>Trainer</code> usa 3 epoche di default, quindi:",tl,q,al,L,sl,K,nl,P,Pl="Un’ultima cosa: se si ha accesso ad una GPU è consigliato usarla (su una CPU, l’addestramento potrebbe richiedere svariate ore invece di un paio di minuti). Per usare la GPU, definiamo un <code>device</code> su cui spostare il modello e le batch:",il,D,ol,O,rl,ee,Dl="Siamo pronti per l’addestramento! Per avere un’intuizione di quando sarà finito, aggiungiamo una barra di progresso sul numero di iterazioni di addestramento, usando la libreria <code>tqdm</code>:",pl,le,cl,te,Ol="Potete vedere che il nocciolo del ciclo di addestramento è molto simile a quello nell’introduzione. Non abbiamo chiesto nessun report, quindi il ciclo non ci informerà su come si sta comportando il modello. Dobbiamo aggiungere un ciclo di valutazione per quello.",dl,ae,Ml,se,et="Come fatto in precedenza, utilizzeremo una metrica fornita dalla libreria 🤗 Datasets. Abbiamo già visto il metodo <code>metric.compute()</code>, ma le metriche possono automaticamente accumulare le batch nel ciclo di predizione col metodo <code>add_batch()</code>. Una volta accumulate tutte le batch, possiamo ottenere il risultato finale con <code>metric.compute()</code>. Ecco come implementare tutto ciò in un ciclo di valutazione:",ml,ne,ul,ie,yl,oe,lt="Ancora una volta, i vostri risultati potrebbero essere leggermente diversi a causa della casualità nell’inizializzazione della testa del modello e del ricombinamento dei dati, ma dovrebbero essere nello stesso ordine di grandezza.",bl,w,Jl,re,jl,pe,wl,ce,tt='Il ciclo di addestramento che abbiamo definito prima funziona bene per una sola CPU o GPU. Ma grazie alla libreria <a href="https://github.com/huggingface/accelerate" rel="nofollow">🤗 Accelerate</a>, con alcuni aggiustamenti possiamo attivare l’addestramento distribuito su svariate GPU o TPU. Partendo dalla creazione dei dataloaders di addestramento e validazione, ecco l’aspetto del nostro ciclo di addestramento manuale:',Tl,de,Ul,Me,at="Ecco i cambiamenti necessari:",hl,me,fl,ue,st="Prima di tutto bisogna inserire la linea di importazione. La seconda linea istanzia un oggetto di tipo <code>Accelerator</code> che controllerà e inizializzerà il corretto ambiente distribuito. 🤗 Accelerate gestice il posizionamento sui dispositivi per voi, quindi potete togliere le linee che spostavano il modello sul dispositivo (o, se preferite, cambiare in modo da usare <code>acceleratore.device</code> invece di <code>device</code>).",Cl,ye,nt="Dopodiché la maggior parte del lavoro è fatta dalla linea che invia i dataloaders, il modello e gli ottimizzatori a <code>accelerator.prepare()</code>. Ciò serve a incapsulare queli oggetti nei contenitori appropriati per far sì che l’addestramento distribuito funzioni correttamente. I cambiamenti rimanenti sono la rimozione della linea che sposta la batch sul <code>device</code> (dispositivo) (di nuovo, se volete tenerlo potete semplicemente cambiarlo con <code>accelerator.device</code>) e lo scambio di <code>loss.backward()</code> con <code>accelerator.backward(loss)</code>.",Il,T,Zl,be,it="Se volete copiare e incollare il codice per giocarci, ecco un ciclo di addestramento completo che usa 🤗 Accelerate:",Bl,Je,gl,je,ot="Mettere questo codice in uno script <code>train.py</code> lo renderà eseguibile su qualsiasi ambiente distribuito. Per provarlo nel vostro ambiente distribuito, eseguite:",Gl,we,vl,Te,rt="che vi chiederà di rispondere ad alcune domande e inserirà le vostre risposte in un documento di configurazione usato dal comando:",$l,Ue,kl,he,pt="che eseguirà l’addestramento distribuito.",zl,fe,ct="Se volete provarlo in un Notebook (ad esempio, per testarlo con le TPUs su Colab), incollate il codice in una <code>training_function()</code> ed eseguite l’ultima cella con:",Xl,Ce,Wl,Ie,dt='Potete trovare altri esempi nella <a href="https://github.com/huggingface/accelerate/tree/main/examples" rel="nofollow">🤗 Accelerate repo</a>.',_l,ge,Rl;return U=new Ge({props:{title:"Un addestramento completo",local:"un-addestramento-completo",headingTag:"h1"}}),h=new Bt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/it/chapter3/section4.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/it/chapter3/section4.ipynb"}]}}),f=new Jt({props:{id:"Dh9CL8fyG80"}}),I=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DataCollatorWithPadding

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
checkpoint = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;sentence1&quot;</span>], example[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)
data_collator = DataCollatorWithPadding(tokenizer=tokenizer)`,wrap:!1}}),Z=new Ge({props:{title:"Preparazione all’addestramento",local:"preparazione-alladdestramento",headingTag:"h3"}}),v=new y({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzLnJlbW92ZV9jb2x1bW5zKCU1QiUyMnNlbnRlbmNlMSUyMiUyQyUyMCUyMnNlbnRlbmNlMiUyMiUyQyUyMCUyMmlkeCUyMiU1RCklMEF0b2tlbml6ZWRfZGF0YXNldHMlMjAlM0QlMjB0b2tlbml6ZWRfZGF0YXNldHMucmVuYW1lX2NvbHVtbiglMjJsYWJlbCUyMiUyQyUyMCUyMmxhYmVscyUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMuc2V0X2Zvcm1hdCglMjJ0b3JjaCUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ0cmFpbiUyMiU1RC5jb2x1bW5fbmFtZXM=",highlighted:`tokenized_datasets = tokenized_datasets.remove_columns([<span class="hljs-string">&quot;sentence1&quot;</span>, <span class="hljs-string">&quot;sentence2&quot;</span>, <span class="hljs-string">&quot;idx&quot;</span>])
tokenized_datasets = tokenized_datasets.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)
tokenized_datasets.set_format(<span class="hljs-string">&quot;torch&quot;</span>)
tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>].column_names`,wrap:!1}}),k=new y({props:{code:"JTVCJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJpbnB1dF9pZHMlMjIlMkMlMjAlMjJsYWJlbHMlMjIlMkMlMjAlMjJ0b2tlbl90eXBlX2lkcyUyMiU1RA==",highlighted:'[<span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>]',wrap:!1}}),X=new y({props:{code:"ZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBJTBBdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMjBzaHVmZmxlJTNEVHJ1ZSUyQyUyMGJhdGNoX3NpemUlM0Q4JTJDJTIwY29sbGF0ZV9mbiUzRGRhdGFfY29sbGF0b3IlMEEpJTBBZXZhbF9kYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlciglMEElMjAlMjAlMjAlMjB0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTIwYmF0Y2hfc2l6ZSUzRDglMkMlMjBjb2xsYXRlX2ZuJTNEZGF0YV9jb2xsYXRvciUwQSk=",highlighted:`<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader

train_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>], shuffle=<span class="hljs-literal">True</span>, batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)
eval_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>], batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)`,wrap:!1}}),_=new y({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBicmVhayUwQSU3QmslM0ElMjB2LnNoYXBlJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
    <span class="hljs-keyword">break</span>
{k: v.shape <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}`,wrap:!1}}),R=new y({props:{code:"JTdCJ2F0dGVudGlvbl9tYXNrJyUzQSUyMHRvcmNoLlNpemUoJTVCOCUyQyUyMDY1JTVEKSUyQyUwQSUyMCdpbnB1dF9pZHMnJTNBJTIwdG9yY2guU2l6ZSglNUI4JTJDJTIwNjUlNUQpJTJDJTBBJTIwJ2xhYmVscyclM0ElMjB0b3JjaC5TaXplKCU1QjglNUQpJTJDJTBBJTIwJ3Rva2VuX3R5cGVfaWRzJyUzQSUyMHRvcmNoLlNpemUoJTVCOCUyQyUyMDY1JTVEKSU3RA==",highlighted:`{<span class="hljs-string">&#x27;attention_mask&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
 <span class="hljs-string">&#x27;input_ids&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
 <span class="hljs-string">&#x27;labels&#x27;</span>: torch.Size([<span class="hljs-number">8</span>]),
 <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>])}`,wrap:!1}}),N=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),E=new y({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBcHJpbnQob3V0cHV0cy5sb3NzJTJDJTIwb3V0cHV0cy5sb2dpdHMuc2hhcGUp",highlighted:`outputs = model(**batch)
<span class="hljs-built_in">print</span>(outputs.loss, outputs.logits.shape)`,wrap:!1}}),F=new y({props:{code:"dGVuc29yKDAuNTQ0MSUyQyUyMGdyYWRfZm4lM0QlM0NObGxMb3NzQmFja3dhcmQlM0UpJTIwdG9yY2guU2l6ZSglNUI4JTJDJTIwMiU1RCk=",highlighted:'tensor(<span class="hljs-number">0.5441</span>, grad_fn=&lt;NllLossBackward&gt;) torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">2</span>])',wrap:!1}}),x=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEFkYW1XJTBBJTBBb3B0aW1pemVyJTIwJTNEJTIwQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0Q1ZS01KQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AdamW

optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">5e-5</span>)`,wrap:!1}}),q=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGdldF9zY2hlZHVsZXIlMEElMEFudW1fZXBvY2hzJTIwJTNEJTIwMyUwQW51bV90cmFpbmluZ19zdGVwcyUyMCUzRCUyMG51bV9lcG9jaHMlMjAqJTIwbGVuKHRyYWluX2RhdGFsb2FkZXIpJTBBbHJfc2NoZWR1bGVyJTIwJTNEJTIwZ2V0X3NjaGVkdWxlciglMEElMjAlMjAlMjAlMjAlMjJsaW5lYXIlMjIlMkMlMEElMjAlMjAlMjAlMjBvcHRpbWl6ZXIlM0RvcHRpbWl6ZXIlMkMlMEElMjAlMjAlMjAlMjBudW1fd2FybXVwX3N0ZXBzJTNEMCUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbmluZ19zdGVwcyUzRG51bV90cmFpbmluZ19zdGVwcyUyQyUwQSklMEFwcmludChudW1fdHJhaW5pbmdfc3RlcHMp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> get_scheduler

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)
<span class="hljs-built_in">print</span>(num_training_steps)`,wrap:!1}}),L=new y({props:{code:"MTM3Nw==",highlighted:'<span class="hljs-number">1377</span>',wrap:!1}}),K=new Ge({props:{title:"Il ciclo di addestramento",local:"il-ciclo-di-addestramento",headingTag:"h3"}}),D=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEFtb2RlbC50byhkZXZpY2UpJTBBZGV2aWNl",highlighted:`<span class="hljs-keyword">import</span> torch

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
model.to(device)
device`,wrap:!1}}),O=new y({props:{code:"ZGV2aWNlKHR5cGUlM0QnY3VkYScp",highlighted:'device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&#x27;cuda&#x27;</span>)',wrap:!1}}),le=new y({props:{code:"ZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEFwcm9ncmVzc19iYXIlMjAlM0QlMjB0cWRtKHJhbmdlKG51bV90cmFpbmluZ19zdGVwcykpJTBBJTBBbW9kZWwudHJhaW4oKSUwQWZvciUyMGVwb2NoJTIwaW4lMjByYW5nZShudW1fZXBvY2hzKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbl9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        loss.backward()

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),ae=new Ge({props:{title:"Il ciclo di valutazione",local:"il-ciclo-di-valutazione",headingTag:"h3"}}),ne=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9tZXRyaWMlMEElMEFtZXRyaWMlMjAlM0QlMjBsb2FkX21ldHJpYyglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFtb2RlbC5ldmFsKCklMEFmb3IlMjBiYXRjaCUyMGluJTIwZXZhbF9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjB3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEElMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUyMCUzRCUyMHRvcmNoLmFyZ21heChsb2dpdHMlMkMlMjBkaW0lM0QtMSklMEElMjAlMjAlMjAlMjBtZXRyaWMuYWRkX2JhdGNoKHByZWRpY3Rpb25zJTNEcHJlZGljdGlvbnMlMkMlMjByZWZlcmVuY2VzJTNEYmF0Y2glNUIlMjJsYWJlbHMlMjIlNUQpJTBBJTBBbWV0cmljLmNvbXB1dGUoKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_metric

metric = load_metric(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
model.<span class="hljs-built_in">eval</span>()
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> eval_dataloader:
    batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
    <span class="hljs-keyword">with</span> torch.no_grad():
        outputs = model(**batch)

    logits = outputs.logits
    predictions = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)
    metric.add_batch(predictions=predictions, references=batch[<span class="hljs-string">&quot;labels&quot;</span>])

metric.compute()`,wrap:!1}}),ie=new y({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuODQzMTM3MjU0OTAxOTYwOCUyQyUyMCdmMSclM0ElMjAwLjg5MDc4NDk4MjkzNTE1MzUlN0Q=",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8431372549019608</span>, <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.8907849829351535</span>}',wrap:!1}}),w=new bt({props:{$$slots:{default:[gt]},$$scope:{ctx:Ze}}}),re=new Ge({props:{title:"Potenzia il tuo ciclo di addestramento con 🤗 Accelerate",local:"potenzia-il-tuo-ciclo-di-addestramento-con--accelerate",headingTag:"h3"}}),pe=new Jt({props:{id:"s7dy8QRgjJ0"}}),de=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEFkYW1XJTJDJTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyQyUyMGdldF9zY2hlZHVsZXIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMiklMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDNlLTUpJTBBJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElMjIpJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMHRvcmNoLmRldmljZSglMjJjcHUlMjIpJTBBbW9kZWwudG8oZGV2aWNlKSUwQSUwQW51bV9lcG9jaHMlMjAlM0QlMjAzJTBBbnVtX3RyYWluaW5nX3N0ZXBzJTIwJTNEJTIwbnVtX2Vwb2NocyUyMColMjBsZW4odHJhaW5fZGF0YWxvYWRlciklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmJhdGNoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzLmJhY2t3YXJkKCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2dyZXNzX2Jhci51cGRhdGUoMSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AdamW, AutoModelForSequenceClassification, get_scheduler

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
model.to(device)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        loss.backward()

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),me=new y({props:{code:"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",highlighted:`<span class="hljs-addition">+ from accelerate import Accelerator</span>
  from transformers import AdamW, AutoModelForSequenceClassification, get_scheduler

<span class="hljs-addition">+ accelerator = Accelerator()</span>

  model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=2)
  optimizer = AdamW(model.parameters(), lr=3e-5)

<span class="hljs-deletion">- device = torch.device(&quot;cuda&quot;) if torch.cuda.is_available() else torch.device(&quot;cpu&quot;)</span>
<span class="hljs-deletion">- model.to(device)</span>

<span class="hljs-addition">+ train_dataloader, eval_dataloader, model, optimizer = accelerator.prepare(</span>
<span class="hljs-addition">+     train_dataloader, eval_dataloader, model, optimizer</span>
<span class="hljs-addition">+ )</span>

  num_epochs = 3
  num_training_steps = num_epochs * len(train_dataloader)
  lr_scheduler = get_scheduler(
      &quot;linear&quot;,
      optimizer=optimizer,
      num_warmup_steps=0,
      num_training_steps=num_training_steps
  )

  progress_bar = tqdm(range(num_training_steps))

  model.train()
  for epoch in range(num_epochs):
      for batch in train_dataloader:
<span class="hljs-deletion">-         batch = {k: v.to(device) for k, v in batch.items()}</span>
          outputs = model(**batch)
          loss = outputs.loss
<span class="hljs-deletion">-         loss.backward()</span>
<span class="hljs-addition">+         accelerator.backward(loss)</span>

          optimizer.step()
          lr_scheduler.step()
          optimizer.zero_grad()
          progress_bar.update(1)`,wrap:!1}}),T=new bt({props:{$$slots:{default:[Gt]},$$scope:{ctx:Ze}}}),Je=new y({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBZGFtVyUyQyUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMjBnZXRfc2NoZWR1bGVyJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50JTJDJTIwbnVtX2xhYmVscyUzRDIpJTBBb3B0aW1pemVyJTIwJTNEJTIwQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0QzZS01KSUwQSUwQXRyYWluX2RsJTJDJTIwZXZhbF9kbCUyQyUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMEEpJTBBJTBBbnVtX2Vwb2NocyUyMCUzRCUyMDMlMEFudW1fdHJhaW5pbmdfc3RlcHMlMjAlM0QlMjBudW1fZXBvY2hzJTIwKiUyMGxlbih0cmFpbl9kbCklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RsJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AdamW, AutoModelForSequenceClassification, get_scheduler

accelerator = Accelerator()

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

train_dl, eval_dl, model, optimizer = accelerator.prepare(
    train_dataloader, eval_dataloader, model, optimizer
)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dl)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dl:
        outputs = model(**batch)
        loss = outputs.loss
        accelerator.backward(loss)

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),we=new y({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),Ue=new y({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluLnB5",highlighted:'accelerate <span class="hljs-built_in">launch</span> train.py',wrap:!1}}),Ce=new y({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlciUwQSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluaW5nX2Z1bmN0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher

notebook_launcher(training_function)`,wrap:!1}}),{c(){b=M("meta"),J=s(),j=M("p"),Be=s(),i(U.$$.fragment),ve=s(),i(h.$$.fragment),$e=s(),i(f.$$.fragment),ke=s(),C=M("p"),C.innerHTML=Yl,ze=s(),i(I.$$.fragment),Xe=s(),i(Z.$$.fragment),We=s(),B=M("p"),B.innerHTML=Vl,_e=s(),g=M("ul"),g.innerHTML=Nl,Re=s(),G=M("p"),G.innerHTML=Al,Ye=s(),i(v.$$.fragment),Ve=s(),$=M("p"),$.textContent=El,Ne=s(),i(k.$$.fragment),Ae=s(),z=M("p"),z.textContent=Fl,Ee=s(),i(X.$$.fragment),Fe=s(),W=M("p"),W.textContent=Ql,Qe=s(),i(_.$$.fragment),He=s(),i(R.$$.fragment),xe=s(),Y=M("p"),Y.innerHTML=Hl,Se=s(),V=M("p"),V.textContent=xl,qe=s(),i(N.$$.fragment),Le=s(),A=M("p"),A.textContent=Sl,Ke=s(),i(E.$$.fragment),Pe=s(),i(F.$$.fragment),De=s(),Q=M("p"),Q.innerHTML=ql,Oe=s(),H=M("p"),H.innerHTML=Ll,el=s(),i(x.$$.fragment),ll=s(),S=M("p"),S.innerHTML=Kl,tl=s(),i(q.$$.fragment),al=s(),i(L.$$.fragment),sl=s(),i(K.$$.fragment),nl=s(),P=M("p"),P.innerHTML=Pl,il=s(),i(D.$$.fragment),ol=s(),i(O.$$.fragment),rl=s(),ee=M("p"),ee.innerHTML=Dl,pl=s(),i(le.$$.fragment),cl=s(),te=M("p"),te.textContent=Ol,dl=s(),i(ae.$$.fragment),Ml=s(),se=M("p"),se.innerHTML=et,ml=s(),i(ne.$$.fragment),ul=s(),i(ie.$$.fragment),yl=s(),oe=M("p"),oe.textContent=lt,bl=s(),i(w.$$.fragment),Jl=s(),i(re.$$.fragment),jl=s(),i(pe.$$.fragment),wl=s(),ce=M("p"),ce.innerHTML=tt,Tl=s(),i(de.$$.fragment),Ul=s(),Me=M("p"),Me.textContent=at,hl=s(),i(me.$$.fragment),fl=s(),ue=M("p"),ue.innerHTML=st,Cl=s(),ye=M("p"),ye.innerHTML=nt,Il=s(),i(T.$$.fragment),Zl=s(),be=M("p"),be.textContent=it,Bl=s(),i(Je.$$.fragment),gl=s(),je=M("p"),je.innerHTML=ot,Gl=s(),i(we.$$.fragment),vl=s(),Te=M("p"),Te.textContent=rt,$l=s(),i(Ue.$$.fragment),kl=s(),he=M("p"),he.textContent=pt,zl=s(),fe=M("p"),fe.innerHTML=ct,Xl=s(),i(Ce.$$.fragment),Wl=s(),Ie=M("p"),Ie.innerHTML=dt,_l=s(),ge=M("p"),this.h()},l(e){const l=ft("svelte-u9bgzb",document.head);b=m(l,"META",{name:!0,content:!0}),l.forEach(t),J=n(e),j=m(e,"P",{}),ut(j).forEach(t),Be=n(e),o(U.$$.fragment,e),ve=n(e),o(h.$$.fragment,e),$e=n(e),o(f.$$.fragment,e),ke=n(e),C=m(e,"P",{"data-svelte-h":!0}),u(C)!=="svelte-1us6pmo"&&(C.innerHTML=Yl),ze=n(e),o(I.$$.fragment,e),Xe=n(e),o(Z.$$.fragment,e),We=n(e),B=m(e,"P",{"data-svelte-h":!0}),u(B)!=="svelte-1r5rhw5"&&(B.innerHTML=Vl),_e=n(e),g=m(e,"UL",{"data-svelte-h":!0}),u(g)!=="svelte-1soygtz"&&(g.innerHTML=Nl),Re=n(e),G=m(e,"P",{"data-svelte-h":!0}),u(G)!=="svelte-109i7es"&&(G.innerHTML=Al),Ye=n(e),o(v.$$.fragment,e),Ve=n(e),$=m(e,"P",{"data-svelte-h":!0}),u($)!=="svelte-ouxzs3"&&($.textContent=El),Ne=n(e),o(k.$$.fragment,e),Ae=n(e),z=m(e,"P",{"data-svelte-h":!0}),u(z)!=="svelte-9dsd8e"&&(z.textContent=Fl),Ee=n(e),o(X.$$.fragment,e),Fe=n(e),W=m(e,"P",{"data-svelte-h":!0}),u(W)!=="svelte-10x8m39"&&(W.textContent=Ql),Qe=n(e),o(_.$$.fragment,e),He=n(e),o(R.$$.fragment,e),xe=n(e),Y=m(e,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-1vy1r30"&&(Y.innerHTML=Hl),Se=n(e),V=m(e,"P",{"data-svelte-h":!0}),u(V)!=="svelte-tvclea"&&(V.textContent=xl),qe=n(e),o(N.$$.fragment,e),Le=n(e),A=m(e,"P",{"data-svelte-h":!0}),u(A)!=="svelte-17r0l89"&&(A.textContent=Sl),Ke=n(e),o(E.$$.fragment,e),Pe=n(e),o(F.$$.fragment,e),De=n(e),Q=m(e,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-14z3wqu"&&(Q.innerHTML=ql),Oe=n(e),H=m(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-1tiesbf"&&(H.innerHTML=Ll),el=n(e),o(x.$$.fragment,e),ll=n(e),S=m(e,"P",{"data-svelte-h":!0}),u(S)!=="svelte-agqccw"&&(S.innerHTML=Kl),tl=n(e),o(q.$$.fragment,e),al=n(e),o(L.$$.fragment,e),sl=n(e),o(K.$$.fragment,e),nl=n(e),P=m(e,"P",{"data-svelte-h":!0}),u(P)!=="svelte-1wb397t"&&(P.innerHTML=Pl),il=n(e),o(D.$$.fragment,e),ol=n(e),o(O.$$.fragment,e),rl=n(e),ee=m(e,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-1xyrr8b"&&(ee.innerHTML=Dl),pl=n(e),o(le.$$.fragment,e),cl=n(e),te=m(e,"P",{"data-svelte-h":!0}),u(te)!=="svelte-k27sq5"&&(te.textContent=Ol),dl=n(e),o(ae.$$.fragment,e),Ml=n(e),se=m(e,"P",{"data-svelte-h":!0}),u(se)!=="svelte-vqhpoz"&&(se.innerHTML=et),ml=n(e),o(ne.$$.fragment,e),ul=n(e),o(ie.$$.fragment,e),yl=n(e),oe=m(e,"P",{"data-svelte-h":!0}),u(oe)!=="svelte-rz5cet"&&(oe.textContent=lt),bl=n(e),o(w.$$.fragment,e),Jl=n(e),o(re.$$.fragment,e),jl=n(e),o(pe.$$.fragment,e),wl=n(e),ce=m(e,"P",{"data-svelte-h":!0}),u(ce)!=="svelte-mgnuhl"&&(ce.innerHTML=tt),Tl=n(e),o(de.$$.fragment,e),Ul=n(e),Me=m(e,"P",{"data-svelte-h":!0}),u(Me)!=="svelte-hyicis"&&(Me.textContent=at),hl=n(e),o(me.$$.fragment,e),fl=n(e),ue=m(e,"P",{"data-svelte-h":!0}),u(ue)!=="svelte-c6nglj"&&(ue.innerHTML=st),Cl=n(e),ye=m(e,"P",{"data-svelte-h":!0}),u(ye)!=="svelte-curkr2"&&(ye.innerHTML=nt),Il=n(e),o(T.$$.fragment,e),Zl=n(e),be=m(e,"P",{"data-svelte-h":!0}),u(be)!=="svelte-81d5ez"&&(be.textContent=it),Bl=n(e),o(Je.$$.fragment,e),gl=n(e),je=m(e,"P",{"data-svelte-h":!0}),u(je)!=="svelte-1s4avns"&&(je.innerHTML=ot),Gl=n(e),o(we.$$.fragment,e),vl=n(e),Te=m(e,"P",{"data-svelte-h":!0}),u(Te)!=="svelte-5f8y46"&&(Te.textContent=rt),$l=n(e),o(Ue.$$.fragment,e),kl=n(e),he=m(e,"P",{"data-svelte-h":!0}),u(he)!=="svelte-h9xzji"&&(he.textContent=pt),zl=n(e),fe=m(e,"P",{"data-svelte-h":!0}),u(fe)!=="svelte-142b7g5"&&(fe.innerHTML=ct),Xl=n(e),o(Ce.$$.fragment,e),Wl=n(e),Ie=m(e,"P",{"data-svelte-h":!0}),u(Ie)!=="svelte-zmmr5l"&&(Ie.innerHTML=dt),_l=n(e),ge=m(e,"P",{}),ut(ge).forEach(t),this.h()},h(){yt(b,"name","hf:doc:metadata"),yt(b,"content",$t)},m(e,l){Ct(document.head,b),a(e,J,l),a(e,j,l),a(e,Be,l),r(U,e,l),a(e,ve,l),r(h,e,l),a(e,$e,l),r(f,e,l),a(e,ke,l),a(e,C,l),a(e,ze,l),r(I,e,l),a(e,Xe,l),r(Z,e,l),a(e,We,l),a(e,B,l),a(e,_e,l),a(e,g,l),a(e,Re,l),a(e,G,l),a(e,Ye,l),r(v,e,l),a(e,Ve,l),a(e,$,l),a(e,Ne,l),r(k,e,l),a(e,Ae,l),a(e,z,l),a(e,Ee,l),r(X,e,l),a(e,Fe,l),a(e,W,l),a(e,Qe,l),r(_,e,l),a(e,He,l),r(R,e,l),a(e,xe,l),a(e,Y,l),a(e,Se,l),a(e,V,l),a(e,qe,l),r(N,e,l),a(e,Le,l),a(e,A,l),a(e,Ke,l),r(E,e,l),a(e,Pe,l),r(F,e,l),a(e,De,l),a(e,Q,l),a(e,Oe,l),a(e,H,l),a(e,el,l),r(x,e,l),a(e,ll,l),a(e,S,l),a(e,tl,l),r(q,e,l),a(e,al,l),r(L,e,l),a(e,sl,l),r(K,e,l),a(e,nl,l),a(e,P,l),a(e,il,l),r(D,e,l),a(e,ol,l),r(O,e,l),a(e,rl,l),a(e,ee,l),a(e,pl,l),r(le,e,l),a(e,cl,l),a(e,te,l),a(e,dl,l),r(ae,e,l),a(e,Ml,l),a(e,se,l),a(e,ml,l),r(ne,e,l),a(e,ul,l),r(ie,e,l),a(e,yl,l),a(e,oe,l),a(e,bl,l),r(w,e,l),a(e,Jl,l),r(re,e,l),a(e,jl,l),r(pe,e,l),a(e,wl,l),a(e,ce,l),a(e,Tl,l),r(de,e,l),a(e,Ul,l),a(e,Me,l),a(e,hl,l),r(me,e,l),a(e,fl,l),a(e,ue,l),a(e,Cl,l),a(e,ye,l),a(e,Il,l),r(T,e,l),a(e,Zl,l),a(e,be,l),a(e,Bl,l),r(Je,e,l),a(e,gl,l),a(e,je,l),a(e,Gl,l),r(we,e,l),a(e,vl,l),a(e,Te,l),a(e,$l,l),r(Ue,e,l),a(e,kl,l),a(e,he,l),a(e,zl,l),a(e,fe,l),a(e,Xl,l),r(Ce,e,l),a(e,Wl,l),a(e,Ie,l),a(e,_l,l),a(e,ge,l),Rl=!0},p(e,[l]){const Mt={};l&2&&(Mt.$$scope={dirty:l,ctx:e}),w.$set(Mt);const mt={};l&2&&(mt.$$scope={dirty:l,ctx:e}),T.$set(mt)},i(e){Rl||(p(U.$$.fragment,e),p(h.$$.fragment,e),p(f.$$.fragment,e),p(I.$$.fragment,e),p(Z.$$.fragment,e),p(v.$$.fragment,e),p(k.$$.fragment,e),p(X.$$.fragment,e),p(_.$$.fragment,e),p(R.$$.fragment,e),p(N.$$.fragment,e),p(E.$$.fragment,e),p(F.$$.fragment,e),p(x.$$.fragment,e),p(q.$$.fragment,e),p(L.$$.fragment,e),p(K.$$.fragment,e),p(D.$$.fragment,e),p(O.$$.fragment,e),p(le.$$.fragment,e),p(ae.$$.fragment,e),p(ne.$$.fragment,e),p(ie.$$.fragment,e),p(w.$$.fragment,e),p(re.$$.fragment,e),p(pe.$$.fragment,e),p(de.$$.fragment,e),p(me.$$.fragment,e),p(T.$$.fragment,e),p(Je.$$.fragment,e),p(we.$$.fragment,e),p(Ue.$$.fragment,e),p(Ce.$$.fragment,e),Rl=!0)},o(e){c(U.$$.fragment,e),c(h.$$.fragment,e),c(f.$$.fragment,e),c(I.$$.fragment,e),c(Z.$$.fragment,e),c(v.$$.fragment,e),c(k.$$.fragment,e),c(X.$$.fragment,e),c(_.$$.fragment,e),c(R.$$.fragment,e),c(N.$$.fragment,e),c(E.$$.fragment,e),c(F.$$.fragment,e),c(x.$$.fragment,e),c(q.$$.fragment,e),c(L.$$.fragment,e),c(K.$$.fragment,e),c(D.$$.fragment,e),c(O.$$.fragment,e),c(le.$$.fragment,e),c(ae.$$.fragment,e),c(ne.$$.fragment,e),c(ie.$$.fragment,e),c(w.$$.fragment,e),c(re.$$.fragment,e),c(pe.$$.fragment,e),c(de.$$.fragment,e),c(me.$$.fragment,e),c(T.$$.fragment,e),c(Je.$$.fragment,e),c(we.$$.fragment,e),c(Ue.$$.fragment,e),c(Ce.$$.fragment,e),Rl=!1},d(e){e&&(t(J),t(j),t(Be),t(ve),t($e),t(ke),t(C),t(ze),t(Xe),t(We),t(B),t(_e),t(g),t(Re),t(G),t(Ye),t(Ve),t($),t(Ne),t(Ae),t(z),t(Ee),t(Fe),t(W),t(Qe),t(He),t(xe),t(Y),t(Se),t(V),t(qe),t(Le),t(A),t(Ke),t(Pe),t(De),t(Q),t(Oe),t(H),t(el),t(ll),t(S),t(tl),t(al),t(sl),t(nl),t(P),t(il),t(ol),t(rl),t(ee),t(pl),t(cl),t(te),t(dl),t(Ml),t(se),t(ml),t(ul),t(yl),t(oe),t(bl),t(Jl),t(jl),t(wl),t(ce),t(Tl),t(Ul),t(Me),t(hl),t(fl),t(ue),t(Cl),t(ye),t(Il),t(Zl),t(be),t(Bl),t(gl),t(je),t(Gl),t(vl),t(Te),t($l),t(kl),t(he),t(zl),t(fe),t(Xl),t(Wl),t(Ie),t(_l),t(ge)),t(b),d(U,e),d(h,e),d(f,e),d(I,e),d(Z,e),d(v,e),d(k,e),d(X,e),d(_,e),d(R,e),d(N,e),d(E,e),d(F,e),d(x,e),d(q,e),d(L,e),d(K,e),d(D,e),d(O,e),d(le,e),d(ae,e),d(ne,e),d(ie,e),d(w,e),d(re,e),d(pe,e),d(de,e),d(me,e),d(T,e),d(Je,e),d(we,e),d(Ue,e),d(Ce,e)}}}const $t='{"title":"Un addestramento completo","local":"un-addestramento-completo","sections":[{"title":"Preparazione all’addestramento","local":"preparazione-alladdestramento","sections":[],"depth":3},{"title":"Il ciclo di addestramento","local":"il-ciclo-di-addestramento","sections":[],"depth":3},{"title":"Il ciclo di valutazione","local":"il-ciclo-di-valutazione","sections":[],"depth":3},{"title":"Potenzia il tuo ciclo di addestramento con 🤗 Accelerate","local":"potenzia-il-tuo-ciclo-di-addestramento-con--accelerate","sections":[],"depth":3}],"depth":1}';function kt(Ze){return wt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Nt extends Ut{constructor(b){super(),ht(this,b,kt,vt,jt,{})}}export{Nt as component};
