import{s as _t,o as Tt,n as De}from"../chunks/scheduler.9bc65507.js";import{S as wt,i as Jt,g as d,s,r as h,A as xt,h as c,f as n,c as a,j as oe,u as f,x as m,k as se,y as i,a as r,v as g,d as b,t as M,w as y}from"../chunks/index.707bf1b6.js";import{T as Mt}from"../chunks/Tip.c2ecdbf4.js";import{D as be}from"../chunks/Docstring.17db21ae.js";import{C as Me}from"../chunks/CodeBlock.54a9f38d.js";import{E as yt}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as fe}from"../chunks/Heading.342b1fa6.js";function vt($){let o,T="Example:",p,u,_;return u=new Me({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERicnhDb25maWclMkMlMjBEYnJ4TW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwRGJyeCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwRGJyeENvbmZpZyhuX2xheWVycyUzRDIlMkMlMjBkX21vZGVsJTNEMjU2JTJDJTIwbl9oZWFkcyUzRDglMkMlMjB2b2NhYl9zaXplJTNEMTI4KSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwRGJyeE1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DbrxConfig, DbrxModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Dbrx configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = DbrxConfig(n_layers=<span class="hljs-number">2</span>, d_model=<span class="hljs-number">256</span>, n_heads=<span class="hljs-number">8</span>, vocab_size=<span class="hljs-number">128</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DbrxModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){o=d("p"),o.textContent=T,p=s(),h(u.$$.fragment)},l(l){o=c(l,"P",{"data-svelte-h":!0}),m(o)!=="svelte-11lpom8"&&(o.textContent=T),p=a(l),f(u.$$.fragment,l)},m(l,w){r(l,o,w),r(l,p,w),g(u,l,w),_=!0},p:De,i(l){_||(b(u.$$.fragment,l),_=!0)},o(l){M(u.$$.fragment,l),_=!1},d(l){l&&(n(o),n(p)),y(u,l)}}}function Ut($){let o,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=d("p"),o.innerHTML=T},l(p){o=c(p,"P",{"data-svelte-h":!0}),m(o)!=="svelte-fincs2"&&(o.innerHTML=T)},m(p,u){r(p,o,u)},p:De,d(p){p&&n(o)}}}function kt($){let o,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=d("p"),o.innerHTML=T},l(p){o=c(p,"P",{"data-svelte-h":!0}),m(o)!=="svelte-fincs2"&&(o.innerHTML=T)},m(p,u){r(p,o,u)},p:De,d(p){p&&n(o)}}}function jt($){let o,T="Example:",p,u,_;return u=new Me({props:{code:"JTNFJTNFJTIwZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYnJ4Rm9yQ2F1c2FsTE0lMEElMEElM0UlM0UlMjBtb2RlbCUyMCUzRCUyMERicnhGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZGF0YWJyaWNrcyUyRmRicngtaW5zdHJ1Y3QlMjIpJTBBJTNFJTNFJTIwdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZGF0YWJyaWNrcyUyRmRicngtaW5zdHJ1Y3QlMjIpJTBBJTBBJTNFJTNFJTIwcHJvbXB0JTIwJTNEJTIwJTIySGV5JTJDJTIwYXJlJTIweW91JTIwY29uc2Npb3VzJTNGJTIwQ2FuJTIweW91JTIwdGFsayUyMHRvJTIwbWUlM0YlMjIlMEElM0UlM0UlMjBpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElM0UlM0UlMjAlMjMlMjBHZW5lcmF0ZSUwQSUzRSUzRSUyMGdlbmVyYXRlX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cy5pbnB1dF9pZHMlMkMlMjBtYXhfbGVuZ3RoJTNEMzApJTBBJTNFJTNFJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZV9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSUyQyUyMGNsZWFuX3VwX3Rva2VuaXphdGlvbl9zcGFjZXMlM0RGYWxzZSklNUIwJTVEJTBBJTIySGV5JTJDJTIwYXJlJTIweW91JTIwY29uc2Npb3VzJTNGJTIwQ2FuJTIweW91JTIwdGFsayUyMHRvJTIwbWUlM0YlNUNuSSdtJTIwbm90JTIwY29uc2Npb3VzJTJDJTIwYnV0JTIwSSUyMGNhbiUyMHRhbGslMjB0byUyMHlvdS4lMjI=",highlighted:`&gt;&gt; <span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DbrxForCausalLM

&gt;&gt; model = DbrxForCausalLM.from_pretrained(<span class="hljs-string">&quot;databricks/dbrx-instruct&quot;</span>)
&gt;&gt; tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;databricks/dbrx-instruct&quot;</span>)

&gt;&gt; prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
&gt;&gt; inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

&gt;&gt; <span class="hljs-comment"># Generate</span>
&gt;&gt; generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
&gt;&gt; tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?\\nI&#x27;m not conscious, but I can talk to you.&quot;</span>`,wrap:!1}}),{c(){o=d("p"),o.textContent=T,p=s(),h(u.$$.fragment)},l(l){o=c(l,"P",{"data-svelte-h":!0}),m(o)!=="svelte-11lpom8"&&(o.textContent=T),p=a(l),f(u.$$.fragment,l)},m(l,w){r(l,o,w),r(l,p,w),g(u,l,w),_=!0},p:De,i(l){_||(b(u.$$.fragment,l),_=!0)},o(l){M(u.$$.fragment,l),_=!1},d(l){l&&(n(o),n(p)),y(u,l)}}}function Ct($){let o,T,p,u,_,l,w,ye,D,tt=`DBRX is a <a href="https://www.isattentionallyouneed.com/" rel="nofollow">transformer-based</a> decoder-only large language model (LLM) that was trained using next-token prediction.
It uses a <em>fine-grained</em> mixture-of-experts (MoE) architecture with 132B total parameters of which 36B parameters are active on any input.
It was pre-trained on 12T tokens of text and code data.
Compared to other open MoE models like Mixtral-8x7B and Grok-1, DBRX is fine-grained, meaning it uses a larger number of smaller experts. DBRX has 16 experts and chooses 4, while Mixtral-8x7B and Grok-1 have 8 experts and choose 2.
This provides 65x more possible combinations of experts and we found that this improves model quality.
DBRX uses rotary position encodings (RoPE), gated linear units (GLU), and grouped query attention (GQA).
It is a BPE based model and uses the GPT-4 tokenizer as described in the <a href="https://github.com/openai/tiktoken" rel="nofollow">tiktoken</a> repository.
We made these choices based on exhaustive evaluation and scaling experiments.`,_e,N,nt=`DBRX was pretrained on 12T tokens of carefully curated data and a maximum context length of 32K tokens.
We estimate that this data is at least 2x better token-for-token than the data we used to pretrain the MPT family of models.
This new dataset was developed using the full suite of Databricks tools, including Apache Spark™ and Databricks notebooks for data processing, and Unity Catalog for data management and governance.
We used curriculum learning for pretraining, changing the data mix during training in ways we found to substantially improve model quality.`,Te,E,ot='More detailed information about DBRX Instruct and DBRX Base can be found in our <a href="https://www.databricks.com/blog/introducing-dbrx-new-state-art-open-llm" rel="nofollow">technical blog post</a>.',we,W,st='This model was contributed by <a href="https://huggingface.co/eitanturok" rel="nofollow">eitan-turok</a> and <a href="https://huggingface.co/abhi-db" rel="nofollow">abhi-db</a>. The original code can be found <a href="https://github.com/databricks/dbrx-instruct" rel="nofollow">here</a>.',Je,V,xe,B,at="The <code>generate()</code> method can be used to generate text using DBRX. You can generate using the standard attention implementation, flash-attention, and the PyTorch scaled dot product attention. The last two attention implementations give speed ups.",ve,q,Ue,H,rt='If you have flash-attention installed (<code>pip install flash-attn</code>), it is possible to generate faster. (The HuggingFace documentation for flash-attention can be found <a href="https://huggingface.co/docs/transformers/perf_infer_gpu_one#flashattention-2" rel="nofollow">here</a>.)',ke,Q,je,Y,lt='You can also generate faster using the PyTorch scaled dot product attention. (The HuggingFace documentation for scaled dot product attention can be found <a href="https://huggingface.co/docs/transformers/perf_infer_gpu_one#pytorch-scaled-dot-product-attention" rel="nofollow">here</a>.)',Ce,L,$e,S,Ie,v,P,Ne,ae,it=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.40.0/en/model_doc/dbrx#transformers.DbrxModel">DbrxModel</a>. It is used to instantiate a Dbrx model according to the
specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a different configuration to that of the <a href="https://huggingface.co/databricks/dbrx-instruct" rel="nofollow">databricks/dbrx-instruct</a> architecture.`,Ee,re,dt=`Configuration objects inherit from <a href="/docs/transformers/v4.40.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.40.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,We,G,Re,A,Ze,J,O,Ve,le,ct=`The bare DBRX Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/v4.40.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Be,ie,pt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,qe,de,ut="Transformer decoder consisting of <em>config.num_hidden_layers</em>. Each layer is a <code>DbrxBlock</code> layer.",He,I,K,Qe,ce,mt='The <a href="/docs/transformers/v4.40.0/en/model_doc/dbrx#transformers.DbrxModel">DbrxModel</a> forward method, overrides the <code>__call__</code> special method.',Ye,X,Ge,ee,Xe,U,te,Le,pe,ht=`The DBRX Model transformer for causal language modeling.
This model inherits from <a href="/docs/transformers/v4.40.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Se,ue,ft=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Pe,x,ne,Ae,me,gt='The <a href="/docs/transformers/v4.40.0/en/model_doc/dbrx#transformers.DbrxForCausalLM">DbrxForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',Oe,z,Ke,he,bt="Forward function for causal language modeling.",et,F,ze,ge,Fe;return _=new fe({props:{title:"DBRX",local:"dbrx",headingTag:"h1"}}),w=new fe({props:{title:"Overview",local:"overview",headingTag:"h2"}}),V=new fe({props:{title:"Usage Examples",local:"usage-examples",headingTag:"h2"}}),q=new Me({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERicnhGb3JDYXVzYWxMTSUyQyUyMEF1dG9Ub2tlbml6ZXIlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRhdGFicmlja3MlMkZkYnJ4LWluc3RydWN0JTIyJTJDJTIwdG9rZW4lM0QlMjJZT1VSX0hGX1RPS0VOJTIyKSUwQW1vZGVsJTIwJTNEJTIwRGJyeEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJkYXRhYnJpY2tzJTJGZGJyeC1pbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHRva2VuJTNEJTIyWU9VUl9IRl9UT0tFTiUyMiUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEFpbnB1dF90ZXh0JTIwJTNEJTIwJTIyV2hhdCUyMGRvZXMlMjBpdCUyMHRha2UlMjB0byUyMGJ1aWxkJTIwYSUyMGdyZWF0JTIwTExNJTNGJTIyJTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjBpbnB1dF90ZXh0JTdEJTVEJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjByZXR1cm5fZGljdCUzRFRydWUlMkMlMjB0b2tlbml6ZSUzRFRydWUlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dF9pZHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwMCklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dHMlNUIwJTVEKSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DbrxForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;databricks/dbrx-instruct&quot;</span>, token=<span class="hljs-string">&quot;YOUR_HF_TOKEN&quot;</span>)
model = DbrxForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;databricks/dbrx-instruct&quot;</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=torch.bfloat16,
    token=<span class="hljs-string">&quot;YOUR_HF_TOKEN&quot;</span>,
    )

input_text = <span class="hljs-string">&quot;What does it take to build a great LLM?&quot;</span>
messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: input_text}]
input_ids = tokenizer.apply_chat_template(messages, return_dict=<span class="hljs-literal">True</span>, tokenize=<span class="hljs-literal">True</span>, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

outputs = model.generate(**input_ids, max_new_tokens=<span class="hljs-number">200</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>]))`,wrap:!1}}),Q=new Me({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERicnhGb3JDYXVzYWxMTSUyQyUyMEF1dG9Ub2tlbml6ZXIlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRhdGFicmlja3MlMkZkYnJ4LWluc3RydWN0JTIyJTJDJTIwdG9rZW4lM0QlMjJZT1VSX0hGX1RPS0VOJTIyKSUwQW1vZGVsJTIwJTNEJTIwRGJyeEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJkYXRhYnJpY2tzJTJGZGJyeC1pbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHRva2VuJTNEJTIyWU9VUl9IRl9UT0tFTiUyMiUyQyUwQSUyMCUyMCUyMCUyMGF0dG5faW1wbGVtZW50YXRpb24lM0QlMjJmbGFzaF9hdHRlbnRpb25fMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEFpbnB1dF90ZXh0JTIwJTNEJTIwJTIyV2hhdCUyMGRvZXMlMjBpdCUyMHRha2UlMjB0byUyMGJ1aWxkJTIwYSUyMGdyZWF0JTIwTExNJTNGJTIyJTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjBpbnB1dF90ZXh0JTdEJTVEJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjByZXR1cm5fZGljdCUzRFRydWUlMkMlMjB0b2tlbml6ZSUzRFRydWUlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dF9pZHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwMCklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dHMlNUIwJTVEKSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DbrxForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;databricks/dbrx-instruct&quot;</span>, token=<span class="hljs-string">&quot;YOUR_HF_TOKEN&quot;</span>)
model = DbrxForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;databricks/dbrx-instruct&quot;</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=torch.bfloat16,
    token=<span class="hljs-string">&quot;YOUR_HF_TOKEN&quot;</span>,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
    )

input_text = <span class="hljs-string">&quot;What does it take to build a great LLM?&quot;</span>
messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: input_text}]
input_ids = tokenizer.apply_chat_template(messages, return_dict=<span class="hljs-literal">True</span>, tokenize=<span class="hljs-literal">True</span>, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

outputs = model.generate(**input_ids, max_new_tokens=<span class="hljs-number">200</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>]))`,wrap:!1}}),L=new Me({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERicnhGb3JDYXVzYWxMTSUyQyUyMEF1dG9Ub2tlbml6ZXIlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRhdGFicmlja3MlMkZkYnJ4LWluc3RydWN0JTIyJTJDJTIwdG9rZW4lM0QlMjJZT1VSX0hGX1RPS0VOJTIyKSUwQW1vZGVsJTIwJTNEJTIwRGJyeEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJkYXRhYnJpY2tzJTJGZGJyeC1pbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHRva2VuJTNEJTIyWU9VUl9IRl9UT0tFTiUyMiUyQyUwQSUyMCUyMCUyMCUyMGF0dG5faW1wbGVtZW50YXRpb24lM0QlMjJzZHBhJTIyJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUwQWlucHV0X3RleHQlMjAlM0QlMjAlMjJXaGF0JTIwZG9lcyUyMGl0JTIwdGFrZSUyMHRvJTIwYnVpbGQlMjBhJTIwZ3JlYXQlMjBMTE0lM0YlMjIlMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMGlucHV0X3RleHQlN0QlNUQlMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShtZXNzYWdlcyUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSUyQyUyMHRva2VuaXplJTNEVHJ1ZSUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0X2lkcyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjAwKSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0cyU1QjAlNUQpKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DbrxForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;databricks/dbrx-instruct&quot;</span>, token=<span class="hljs-string">&quot;YOUR_HF_TOKEN&quot;</span>)
model = DbrxForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;databricks/dbrx-instruct&quot;</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=torch.bfloat16,
    token=<span class="hljs-string">&quot;YOUR_HF_TOKEN&quot;</span>,
    attn_implementation=<span class="hljs-string">&quot;sdpa&quot;</span>,
    )

input_text = <span class="hljs-string">&quot;What does it take to build a great LLM?&quot;</span>
messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: input_text}]
input_ids = tokenizer.apply_chat_template(messages, return_dict=<span class="hljs-literal">True</span>, tokenize=<span class="hljs-literal">True</span>, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

outputs = model.generate(**input_ids, max_new_tokens=<span class="hljs-number">200</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>]))`,wrap:!1}}),S=new fe({props:{title:"DbrxConfig",local:"transformers.DbrxConfig",headingTag:"h2"}}),P=new be({props:{name:"class transformers.DbrxConfig",anchor:"transformers.DbrxConfig",parameters:[{name:"d_model",val:": int = 2048"},{name:"n_heads",val:": int = 16"},{name:"n_layers",val:": int = 24"},{name:"max_seq_len",val:": int = 2048"},{name:"vocab_size",val:": int = 32000"},{name:"resid_pdrop",val:": float = 0.0"},{name:"emb_pdrop",val:": float = 0.0"},{name:"attn_config",val:": Optional = None"},{name:"ffn_config",val:": Optional = None"},{name:"use_cache",val:": bool = True"},{name:"initializer_range",val:": float = 0.02"},{name:"output_router_logits",val:": bool = False"},{name:"**kwargs",val:": Any"}],parametersDescription:[{anchor:"transformers.DbrxConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimensionality of the embeddings and hidden states.`,name:"d_model"},{anchor:"transformers.DbrxConfig.n_heads",description:`<strong>n_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"n_heads"},{anchor:"transformers.DbrxConfig.n_layers",description:`<strong>n_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"n_layers"},{anchor:"transformers.DbrxConfig.max_seq_len",description:`<strong>max_seq_len</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The maximum sequence length of the model.`,name:"max_seq_len"},{anchor:"transformers.DbrxConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
Vocabulary size of the Dbrx model. Defines the maximum number of different tokens that can be represented by
the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/v4.40.0/en/model_doc/dbrx#transformers.DbrxModel">DbrxModel</a>.`,name:"vocab_size"},{anchor:"transformers.DbrxConfig.resid_pdrop",description:`<strong>resid_pdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability applied to the attention output before combining with residual.`,name:"resid_pdrop"},{anchor:"transformers.DbrxConfig.emb_pdrop",description:`<strong>emb_pdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for the embedding layer.`,name:"emb_pdrop"},{anchor:"transformers.DbrxConfig.attn_config",description:`<strong>attn_config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A dictionary used to configure the model&#x2019;s attention module.`,name:"attn_config"},{anchor:"transformers.DbrxConfig.ffn_config",description:`<strong>ffn_config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A dictionary used to configure the model&#x2019;s FFN module.`,name:"ffn_config"},{anchor:"transformers.DbrxConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models).`,name:"use_cache"},{anchor:"transformers.DbrxConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.DbrxConfig.output_router_logits",description:`<strong>output_router_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the router logits should be returned by the model. Enabling this will also
allow the model to output the auxiliary loss. See <a href>here</a> for more details.`,name:"output_router_logits"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/dbrx/configuration_dbrx.py#L149"}}),G=new yt({props:{anchor:"transformers.DbrxConfig.example",$$slots:{default:[vt]},$$scope:{ctx:$}}}),A=new fe({props:{title:"DbrxModel",local:"transformers.DbrxModel",headingTag:"h2"}}),O=new be({props:{name:"class transformers.DbrxModel",anchor:"transformers.DbrxModel",parameters:[{name:"config",val:": DbrxConfig"}],parametersDescription:[{anchor:"transformers.DbrxModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.40.0/en/model_doc/dbrx#transformers.DbrxConfig">DbrxConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.40.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.DbrxModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.40.0/en/model_doc/dbrx#transformers.DbrxConfig">DbrxConfig</a>) &#x2014; Model configuration class with all parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.40.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/dbrx/modeling_dbrx.py#L1060"}}),K=new be({props:{name:"forward",anchor:"transformers.DbrxModel.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"output_router_logits",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"cache_position",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.DbrxModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.40.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.40.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.40.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.DbrxModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.40.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.40.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.40.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.DbrxModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.DbrxModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.DbrxModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.DbrxModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.DbrxModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DbrxModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DbrxModel.forward.output_router_logits",description:`<strong>output_router_logits</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the logits of all the routers. They are useful for computing the router loss, and
should not be returned during inference.`,name:"output_router_logits"},{anchor:"transformers.DbrxModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.40.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.DbrxModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/dbrx/modeling_dbrx.py#L1093"}}),X=new Mt({props:{$$slots:{default:[Ut]},$$scope:{ctx:$}}}),ee=new fe({props:{title:"DbrxForCausalLM",local:"transformers.DbrxForCausalLM",headingTag:"h2"}}),te=new be({props:{name:"class transformers.DbrxForCausalLM",anchor:"transformers.DbrxForCausalLM",parameters:[{name:"config",val:": DbrxConfig"}],parametersDescription:[{anchor:"transformers.DbrxForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.40.0/en/model_doc/dbrx#transformers.DbrxConfig">DbrxConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.40.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/dbrx/modeling_dbrx.py#L1291"}}),ne=new be({props:{name:"forward",anchor:"transformers.DbrxForCausalLM.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"output_router_logits",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"cache_position",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.DbrxForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.`,name:"input_ids"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/dbrx/modeling_dbrx.py#L1323",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.MoeCausalLMOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.40.0/en/model_doc/dbrx#transformers.DbrxConfig"
>DbrxConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>aux_loss</strong> (<code>torch.FloatTensor</code>, <em>optional</em>, returned when <code>labels</code> is provided) — aux_loss for the sparse modules.</p>
</li>
<li>
<p><strong>router_logits</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_router_probs=True</code> and <code>config.add_router_probs=True</code> is passed or when <code>config.output_router_probs=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, sequence_length, num_experts)</code>.</p>
<p>Raw router logtis (post-softmax) that are computed by MoE routers, these terms are used to compute the auxiliary
loss for Mixture of Experts models.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.MoeCausalLMOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),z=new Mt({props:{$$slots:{default:[kt]},$$scope:{ctx:$}}}),F=new yt({props:{anchor:"transformers.DbrxForCausalLM.forward.example",$$slots:{default:[jt]},$$scope:{ctx:$}}}),{c(){o=d("meta"),T=s(),p=d("p"),u=s(),h(_.$$.fragment),l=s(),h(w.$$.fragment),ye=s(),D=d("p"),D.innerHTML=tt,_e=s(),N=d("p"),N.textContent=nt,Te=s(),E=d("p"),E.innerHTML=ot,we=s(),W=d("p"),W.innerHTML=st,Je=s(),h(V.$$.fragment),xe=s(),B=d("p"),B.innerHTML=at,ve=s(),h(q.$$.fragment),Ue=s(),H=d("p"),H.innerHTML=rt,ke=s(),h(Q.$$.fragment),je=s(),Y=d("p"),Y.innerHTML=lt,Ce=s(),h(L.$$.fragment),$e=s(),h(S.$$.fragment),Ie=s(),v=d("div"),h(P.$$.fragment),Ne=s(),ae=d("p"),ae.innerHTML=it,Ee=s(),re=d("p"),re.innerHTML=dt,We=s(),h(G.$$.fragment),Re=s(),h(A.$$.fragment),Ze=s(),J=d("div"),h(O.$$.fragment),Ve=s(),le=d("p"),le.innerHTML=ct,Be=s(),ie=d("p"),ie.innerHTML=pt,qe=s(),de=d("p"),de.innerHTML=ut,He=s(),I=d("div"),h(K.$$.fragment),Qe=s(),ce=d("p"),ce.innerHTML=mt,Ye=s(),h(X.$$.fragment),Ge=s(),h(ee.$$.fragment),Xe=s(),U=d("div"),h(te.$$.fragment),Le=s(),pe=d("p"),pe.innerHTML=ht,Se=s(),ue=d("p"),ue.innerHTML=ft,Pe=s(),x=d("div"),h(ne.$$.fragment),Ae=s(),me=d("p"),me.innerHTML=gt,Oe=s(),h(z.$$.fragment),Ke=s(),he=d("p"),he.textContent=bt,et=s(),h(F.$$.fragment),ze=s(),ge=d("p"),this.h()},l(e){const t=xt("svelte-u9bgzb",document.head);o=c(t,"META",{name:!0,content:!0}),t.forEach(n),T=a(e),p=c(e,"P",{}),oe(p).forEach(n),u=a(e),f(_.$$.fragment,e),l=a(e),f(w.$$.fragment,e),ye=a(e),D=c(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-14fqb4b"&&(D.innerHTML=tt),_e=a(e),N=c(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-6tnpsh"&&(N.textContent=nt),Te=a(e),E=c(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-p78060"&&(E.innerHTML=ot),we=a(e),W=c(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-6n38fp"&&(W.innerHTML=st),Je=a(e),f(V.$$.fragment,e),xe=a(e),B=c(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1n2ymew"&&(B.innerHTML=at),ve=a(e),f(q.$$.fragment,e),Ue=a(e),H=c(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-45m1hv"&&(H.innerHTML=rt),ke=a(e),f(Q.$$.fragment,e),je=a(e),Y=c(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-1cyfh2c"&&(Y.innerHTML=lt),Ce=a(e),f(L.$$.fragment,e),$e=a(e),f(S.$$.fragment,e),Ie=a(e),v=c(e,"DIV",{class:!0});var j=oe(v);f(P.$$.fragment,j),Ne=a(j),ae=c(j,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-m7s8zc"&&(ae.innerHTML=it),Ee=a(j),re=c(j,"P",{"data-svelte-h":!0}),m(re)!=="svelte-1pfahiz"&&(re.innerHTML=dt),We=a(j),f(G.$$.fragment,j),j.forEach(n),Re=a(e),f(A.$$.fragment,e),Ze=a(e),J=c(e,"DIV",{class:!0});var k=oe(J);f(O.$$.fragment,k),Ve=a(k),le=c(k,"P",{"data-svelte-h":!0}),m(le)!=="svelte-opszql"&&(le.innerHTML=ct),Be=a(k),ie=c(k,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-hswkmf"&&(ie.innerHTML=pt),qe=a(k),de=c(k,"P",{"data-svelte-h":!0}),m(de)!=="svelte-hglq5y"&&(de.innerHTML=ut),He=a(k),I=c(k,"DIV",{class:!0});var Z=oe(I);f(K.$$.fragment,Z),Qe=a(Z),ce=c(Z,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-1hqqwxu"&&(ce.innerHTML=mt),Ye=a(Z),f(X.$$.fragment,Z),Z.forEach(n),k.forEach(n),Ge=a(e),f(ee.$$.fragment,e),Xe=a(e),U=c(e,"DIV",{class:!0});var C=oe(U);f(te.$$.fragment,C),Le=a(C),pe=c(C,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-13zko13"&&(pe.innerHTML=ht),Se=a(C),ue=c(C,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-hswkmf"&&(ue.innerHTML=ft),Pe=a(C),x=c(C,"DIV",{class:!0});var R=oe(x);f(ne.$$.fragment,R),Ae=a(R),me=c(R,"P",{"data-svelte-h":!0}),m(me)!=="svelte-1cw6ykm"&&(me.innerHTML=gt),Oe=a(R),f(z.$$.fragment,R),Ke=a(R),he=c(R,"P",{"data-svelte-h":!0}),m(he)!=="svelte-9dp5h6"&&(he.textContent=bt),et=a(R),f(F.$$.fragment,R),R.forEach(n),C.forEach(n),ze=a(e),ge=c(e,"P",{}),oe(ge).forEach(n),this.h()},h(){se(o,"name","hf:doc:metadata"),se(o,"content",$t),se(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),se(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),se(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),se(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),se(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){i(document.head,o),r(e,T,t),r(e,p,t),r(e,u,t),g(_,e,t),r(e,l,t),g(w,e,t),r(e,ye,t),r(e,D,t),r(e,_e,t),r(e,N,t),r(e,Te,t),r(e,E,t),r(e,we,t),r(e,W,t),r(e,Je,t),g(V,e,t),r(e,xe,t),r(e,B,t),r(e,ve,t),g(q,e,t),r(e,Ue,t),r(e,H,t),r(e,ke,t),g(Q,e,t),r(e,je,t),r(e,Y,t),r(e,Ce,t),g(L,e,t),r(e,$e,t),g(S,e,t),r(e,Ie,t),r(e,v,t),g(P,v,null),i(v,Ne),i(v,ae),i(v,Ee),i(v,re),i(v,We),g(G,v,null),r(e,Re,t),g(A,e,t),r(e,Ze,t),r(e,J,t),g(O,J,null),i(J,Ve),i(J,le),i(J,Be),i(J,ie),i(J,qe),i(J,de),i(J,He),i(J,I),g(K,I,null),i(I,Qe),i(I,ce),i(I,Ye),g(X,I,null),r(e,Ge,t),g(ee,e,t),r(e,Xe,t),r(e,U,t),g(te,U,null),i(U,Le),i(U,pe),i(U,Se),i(U,ue),i(U,Pe),i(U,x),g(ne,x,null),i(x,Ae),i(x,me),i(x,Oe),g(z,x,null),i(x,Ke),i(x,he),i(x,et),g(F,x,null),r(e,ze,t),r(e,ge,t),Fe=!0},p(e,[t]){const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),G.$set(j);const k={};t&2&&(k.$$scope={dirty:t,ctx:e}),X.$set(k);const Z={};t&2&&(Z.$$scope={dirty:t,ctx:e}),z.$set(Z);const C={};t&2&&(C.$$scope={dirty:t,ctx:e}),F.$set(C)},i(e){Fe||(b(_.$$.fragment,e),b(w.$$.fragment,e),b(V.$$.fragment,e),b(q.$$.fragment,e),b(Q.$$.fragment,e),b(L.$$.fragment,e),b(S.$$.fragment,e),b(P.$$.fragment,e),b(G.$$.fragment,e),b(A.$$.fragment,e),b(O.$$.fragment,e),b(K.$$.fragment,e),b(X.$$.fragment,e),b(ee.$$.fragment,e),b(te.$$.fragment,e),b(ne.$$.fragment,e),b(z.$$.fragment,e),b(F.$$.fragment,e),Fe=!0)},o(e){M(_.$$.fragment,e),M(w.$$.fragment,e),M(V.$$.fragment,e),M(q.$$.fragment,e),M(Q.$$.fragment,e),M(L.$$.fragment,e),M(S.$$.fragment,e),M(P.$$.fragment,e),M(G.$$.fragment,e),M(A.$$.fragment,e),M(O.$$.fragment,e),M(K.$$.fragment,e),M(X.$$.fragment,e),M(ee.$$.fragment,e),M(te.$$.fragment,e),M(ne.$$.fragment,e),M(z.$$.fragment,e),M(F.$$.fragment,e),Fe=!1},d(e){e&&(n(T),n(p),n(u),n(l),n(ye),n(D),n(_e),n(N),n(Te),n(E),n(we),n(W),n(Je),n(xe),n(B),n(ve),n(Ue),n(H),n(ke),n(je),n(Y),n(Ce),n($e),n(Ie),n(v),n(Re),n(Ze),n(J),n(Ge),n(Xe),n(U),n(ze),n(ge)),n(o),y(_,e),y(w,e),y(V,e),y(q,e),y(Q,e),y(L,e),y(S,e),y(P),y(G),y(A,e),y(O),y(K),y(X),y(ee,e),y(te),y(ne),y(z),y(F)}}}const $t='{"title":"DBRX","local":"dbrx","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage Examples","local":"usage-examples","sections":[],"depth":2},{"title":"DbrxConfig","local":"transformers.DbrxConfig","sections":[],"depth":2},{"title":"DbrxModel","local":"transformers.DbrxModel","sections":[],"depth":2},{"title":"DbrxForCausalLM","local":"transformers.DbrxForCausalLM","sections":[],"depth":2}],"depth":1}';function It($){return Tt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Nt extends wt{constructor(o){super(),Jt(this,o,It,Ct,_t,{})}}export{Nt as component};
