import{s as bt,f as Mt,o as wt,n as Ke}from"../chunks/scheduler.9bc65507.js";import{S as Tt,i as jt,g as i,s as a,r as g,A as _t,h as p,f as n,c as o,j as me,u,x as m,k as W,y as d,a as s,v as f,d as y,t as b,w as M}from"../chunks/index.707bf1b6.js";import{T as Jt}from"../chunks/Tip.c2ecdbf4.js";import{D as De}from"../chunks/Docstring.17db21ae.js";import{C as Re}from"../chunks/CodeBlock.54a9f38d.js";import{E as yt}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as E}from"../chunks/Heading.342b1fa6.js";function vt(U){let r,_="Example:",c,h,w;return h=new Re({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlcHRoQW55dGhpbmdDb25maWclMkMlMjBEZXB0aEFueXRoaW5nRm9yRGVwdGhFc3RpbWF0aW9uJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMERlcHRoQW55dGhpbmclMjBzbWFsbCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBEZXB0aEFueXRoaW5nQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjBmcm9tJTIwdGhlJTIwRGVwdGhBbnl0aGluZyUyMHNtYWxsJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBEZXB0aEFueXRoaW5nRm9yRGVwdGhFc3RpbWF0aW9uKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DepthAnythingConfig, DepthAnythingForDepthEstimation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a DepthAnything small style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = DepthAnythingConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the DepthAnything small style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DepthAnythingForDepthEstimation(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){r=i("p"),r.textContent=_,c=a(),g(h.$$.fragment)},l(l){r=p(l,"P",{"data-svelte-h":!0}),m(r)!=="svelte-11lpom8"&&(r.textContent=_),c=o(l),u(h.$$.fragment,l)},m(l,T){s(l,r,T),s(l,c,T),f(h,l,T),w=!0},p:Ke,i(l){w||(y(h.$$.fragment,l),w=!0)},o(l){b(h.$$.fragment,l),w=!1},d(l){l&&(n(r),n(c)),M(h,l)}}}function $t(U){let r,_=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=i("p"),r.innerHTML=_},l(c){r=p(c,"P",{"data-svelte-h":!0}),m(r)!=="svelte-fincs2"&&(r.innerHTML=_)},m(c,h){s(c,r,h)},p:Ke,d(c){c&&n(r)}}}function Bt(U){let r,_="Examples:",c,h,w;return h=new Re({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJMaWhlWW91bmclMkZkZXB0aC1hbnl0aGluZy1zbWFsbC1oZiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyTGloZVlvdW5nJTJGZGVwdGgtYW55dGhpbmctc21hbGwtaGYlMjIpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGltYWdlJTIwZm9yJTIwdGhlJTIwbW9kZWwlMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTIwJTIwJTIwJTIwcHJlZGljdGVkX2RlcHRoJTIwJTNEJTIwb3V0cHV0cy5wcmVkaWN0ZWRfZGVwdGglMEElMEElMjMlMjBpbnRlcnBvbGF0ZSUyMHRvJTIwb3JpZ2luYWwlMjBzaXplJTBBcHJlZGljdGlvbiUyMCUzRCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwuaW50ZXJwb2xhdGUoJTBBJTIwJTIwJTIwJTIwcHJlZGljdGVkX2RlcHRoLnVuc3F1ZWV6ZSgxKSUyQyUwQSUyMCUyMCUyMCUyMHNpemUlM0RpbWFnZS5zaXplJTVCJTNBJTNBLTElNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlJTNEJTIyYmljdWJpYyUyMiUyQyUwQSUyMCUyMCUyMCUyMGFsaWduX2Nvcm5lcnMlM0RGYWxzZSUyQyUwQSklMEElMEElMjMlMjB2aXN1YWxpemUlMjB0aGUlMjBwcmVkaWN0aW9uJTBBb3V0cHV0JTIwJTNEJTIwcHJlZGljdGlvbi5zcXVlZXplKCkuY3B1KCkubnVtcHkoKSUwQWZvcm1hdHRlZCUyMCUzRCUyMChvdXRwdXQlMjAqJTIwMjU1JTIwJTJGJTIwbnAubWF4KG91dHB1dCkpLmFzdHlwZSglMjJ1aW50OCUyMiklMEFkZXB0aCUyMCUzRCUyMEltYWdlLmZyb21hcnJheShmb3JtYXR0ZWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;LiheYoung/depth-anything-small-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;LiheYoung/depth-anything-small-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    predicted_depth = outputs.predicted_depth

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># interpolate to original size</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prediction = torch.nn.functional.interpolate(
<span class="hljs-meta">... </span>    predicted_depth.unsqueeze(<span class="hljs-number">1</span>),
<span class="hljs-meta">... </span>    size=image.size[::-<span class="hljs-number">1</span>],
<span class="hljs-meta">... </span>    mode=<span class="hljs-string">&quot;bicubic&quot;</span>,
<span class="hljs-meta">... </span>    align_corners=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># visualize the prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = prediction.squeeze().cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>formatted = (output * <span class="hljs-number">255</span> / np.<span class="hljs-built_in">max</span>(output)).astype(<span class="hljs-string">&quot;uint8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(formatted)`,wrap:!1}}),{c(){r=i("p"),r.textContent=_,c=a(),g(h.$$.fragment)},l(l){r=p(l,"P",{"data-svelte-h":!0}),m(r)!=="svelte-kvfsh7"&&(r.textContent=_),c=o(l),u(h.$$.fragment,l)},m(l,T){s(l,r,T),s(l,c,T),f(h,l,T),w=!0},p:Ke,i(l){w||(y(h.$$.fragment,l),w=!0)},o(l){b(h.$$.fragment,l),w=!1},d(l){l&&(n(r),n(c)),M(h,l)}}}function Wt(U){let r,_,c,h,w,l,T,ue,z,Oe='The Depth Anything model was proposed in <a href="https://arxiv.org/abs/2401.10891" rel="nofollow">Depth Anything: Unleashing the Power of Large-Scale Unlabeled Data</a> by Lihe Yang, Bingyi Kang, Zilong Huang, Xiaogang Xu, Jiashi Feng, Hengshuang Zhao. Depth Anything is based on the <a href="dpt">DPT</a> architecture, trained on ~62 million images, obtaining state-of-the-art results for both relative and absolute depth estimation.',fe,x,et="The abstract from the paper is the following:",ye,D,tt="<em>This work presents Depth Anything, a highly practical solution for robust monocular depth estimation. Without pursuing novel technical modules, we aim to build a simple yet powerful foundation model dealing with any images under any circumstances. To this end, we scale up the dataset by designing a data engine to collect and automatically annotate large-scale unlabeled data (~62M), which significantly enlarges the data coverage and thus is able to reduce the generalization error. We investigate two simple yet effective strategies that make data scaling-up promising. First, a more challenging optimization target is created by leveraging data augmentation tools. It compels the model to actively seek extra visual knowledge and acquire robust representations. Second, an auxiliary supervision is developed to enforce the model to inherit rich semantic priors from pre-trained encoders. We evaluate its zero-shot capabilities extensively, including six public datasets and randomly captured photos. It demonstrates impressive generalization ability. Further, through fine-tuning it with metric depth information from NYUv2 and KITTI, new SOTAs are set. Our better depth model also results in a better depth-conditioned ControlNet.</em>",be,C,nt,Me,R,st='Depth Anything overview. Taken from the <a href="https://arxiv.org/abs/2401.10891">original paper</a>.',we,F,at=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>.
The original code can be found <a href="https://github.com/LiheYoung/Depth-Anything" rel="nofollow">here</a>.`,Te,H,je,V,ot="There are 2 main ways to use Depth Anything: either using the pipeline API, which abstracts away all the complexity for you, or by using the <code>DepthAnythingForDepthEstimation</code> class yourself.",_e,N,Je,X,lt="The pipeline allows to use the model in a few lines of code:",ve,Y,$e,L,Be,P,rt="If you want to do the pre- and postprocessing yourself, here’s how to do that:",We,S,Ue,q,Ce,Q,it="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with Depth Anything.",ke,K,pt='<li><a href="../tasks/depth_estimation">Monocular depth estimation task guide</a></li> <li>A notebook showcasing inference with <a href="/docs/transformers/v4.40.0/en/model_doc/depth_anything#transformers.DepthAnythingForDepthEstimation">DepthAnythingForDepthEstimation</a> can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/blob/master/Depth%20Anything/Predicting_depth_in_an_image_with_Depth_Anything.ipynb" rel="nofollow">here</a>. 🌎</li>',Ze,O,ht="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",Ge,ee,Ie,j,te,Fe,re,ct=`This is the configuration class to store the configuration of a <code>DepthAnythingModel</code>. It is used to instantiate an DepthAnything
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the DepthAnything
<a href="https://huggingface.co/LiheYoung/depth-anything-small-hf" rel="nofollow">LiheYoung/depth-anything-small-hf</a> architecture.`,He,ie,dt=`Configuration objects inherit from <a href="/docs/transformers/v4.40.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.40.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Ve,k,Ne,Z,ne,Xe,pe,mt=`Serializes this instance to a Python dictionary. Override the default <a href="/docs/transformers/v4.40.0/en/main_classes/configuration#transformers.PretrainedConfig.to_dict">to_dict()</a>. Returns:
<code>Dict[str, any]</code>: Dictionary of all the attributes that make up this configuration instance,`,Ae,se,Ee,J,ae,Ye,he,gt="Depth Anything Model with a depth estimation head on top (consisting of 3 convolutional layers) e.g. for KITTI, NYUv2.",Le,ce,ut=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Pe,$,oe,Se,de,ft='The <a href="/docs/transformers/v4.40.0/en/model_doc/depth_anything#transformers.DepthAnythingForDepthEstimation">DepthAnythingForDepthEstimation</a> forward method, overrides the <code>__call__</code> special method.',qe,G,Qe,I,ze,ge,xe;return w=new E({props:{title:"Depth Anything",local:"depth-anything",headingTag:"h1"}}),T=new E({props:{title:"Overview",local:"overview",headingTag:"h2"}}),H=new E({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),N=new E({props:{title:"Pipeline API",local:"pipeline-api",headingTag:"h3"}}),Y=new Re({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEElMjMlMjBsb2FkJTIwcGlwZSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyZGVwdGgtZXN0aW1hdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyTGloZVlvdW5nJTJGZGVwdGgtYW55dGhpbmctc21hbGwtaGYlMjIpJTBBJTBBJTIzJTIwbG9hZCUyMGltYWdlJTBBdXJsJTIwJTNEJTIwJ2h0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGcnJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBJTIzJTIwaW5mZXJlbmNlJTBBZGVwdGglMjAlM0QlMjBwaXBlKGltYWdlKSU1QiUyMmRlcHRoJTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load pipe</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(task=<span class="hljs-string">&quot;depth-estimation&quot;</span>, model=<span class="hljs-string">&quot;LiheYoung/depth-anything-small-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&#x27;http://images.cocodataset.org/val2017/000000039769.jpg&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = pipe(image)[<span class="hljs-string">&quot;depth&quot;</span>]`,wrap:!1}}),L=new E({props:{title:"Using the model yourself",local:"using-the-model-yourself",headingTag:"h3"}}),S=new Re({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJMaWhlWW91bmclMkZkZXB0aC1hbnl0aGluZy1zbWFsbC1oZiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyTGloZVlvdW5nJTJGZGVwdGgtYW55dGhpbmctc21hbGwtaGYlMjIpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGltYWdlJTIwZm9yJTIwdGhlJTIwbW9kZWwlMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTIwJTIwJTIwJTIwcHJlZGljdGVkX2RlcHRoJTIwJTNEJTIwb3V0cHV0cy5wcmVkaWN0ZWRfZGVwdGglMEElMEElMjMlMjBpbnRlcnBvbGF0ZSUyMHRvJTIwb3JpZ2luYWwlMjBzaXplJTBBcHJlZGljdGlvbiUyMCUzRCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwuaW50ZXJwb2xhdGUoJTBBJTIwJTIwJTIwJTIwcHJlZGljdGVkX2RlcHRoLnVuc3F1ZWV6ZSgxKSUyQyUwQSUyMCUyMCUyMCUyMHNpemUlM0RpbWFnZS5zaXplJTVCJTNBJTNBLTElNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlJTNEJTIyYmljdWJpYyUyMiUyQyUwQSUyMCUyMCUyMCUyMGFsaWduX2Nvcm5lcnMlM0RGYWxzZSUyQyUwQSklMEElMEElMjMlMjB2aXN1YWxpemUlMjB0aGUlMjBwcmVkaWN0aW9uJTBBb3V0cHV0JTIwJTNEJTIwcHJlZGljdGlvbi5zcXVlZXplKCkuY3B1KCkubnVtcHkoKSUwQWZvcm1hdHRlZCUyMCUzRCUyMChvdXRwdXQlMjAqJTIwMjU1JTIwJTJGJTIwbnAubWF4KG91dHB1dCkpLmFzdHlwZSglMjJ1aW50OCUyMiklMEFkZXB0aCUyMCUzRCUyMEltYWdlLmZyb21hcnJheShmb3JtYXR0ZWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;LiheYoung/depth-anything-small-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;LiheYoung/depth-anything-small-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    predicted_depth = outputs.predicted_depth

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># interpolate to original size</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prediction = torch.nn.functional.interpolate(
<span class="hljs-meta">... </span>    predicted_depth.unsqueeze(<span class="hljs-number">1</span>),
<span class="hljs-meta">... </span>    size=image.size[::-<span class="hljs-number">1</span>],
<span class="hljs-meta">... </span>    mode=<span class="hljs-string">&quot;bicubic&quot;</span>,
<span class="hljs-meta">... </span>    align_corners=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># visualize the prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = prediction.squeeze().cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>formatted = (output * <span class="hljs-number">255</span> / np.<span class="hljs-built_in">max</span>(output)).astype(<span class="hljs-string">&quot;uint8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(formatted)`,wrap:!1}}),q=new E({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ee=new E({props:{title:"DepthAnythingConfig",local:"transformers.DepthAnythingConfig",headingTag:"h2"}}),te=new De({props:{name:"class transformers.DepthAnythingConfig",anchor:"transformers.DepthAnythingConfig",parameters:[{name:"backbone_config",val:" = None"},{name:"backbone",val:" = None"},{name:"use_pretrained_backbone",val:" = False"},{name:"patch_size",val:" = 14"},{name:"initializer_range",val:" = 0.02"},{name:"reassemble_hidden_size",val:" = 384"},{name:"reassemble_factors",val:" = [4, 2, 1, 0.5]"},{name:"neck_hidden_sizes",val:" = [48, 96, 192, 384]"},{name:"fusion_hidden_size",val:" = 64"},{name:"head_in_index",val:" = -1"},{name:"head_hidden_size",val:" = 32"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DepthAnythingConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>Union[Dict[str, Any], PretrainedConfig]</code>, <em>optional</em>) &#x2014;
The configuration of the backbone model. Only used in case <code>is_hybrid</code> is <code>True</code> or in case you want to
leverage the <a href="/docs/transformers/v4.40.0/en/main_classes/backbones#transformers.AutoBackbone">AutoBackbone</a> API.`,name:"backbone_config"},{anchor:"transformers.DepthAnythingConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of backbone to use when <code>backbone_config</code> is <code>None</code>. If <code>use_pretrained_backbone</code> is <code>True</code>, this
will load the corresponding pretrained weights from the timm or transformers library. If <code>use_pretrained_backbone</code>
is <code>False</code>, this loads the backbone&#x2019;s config and uses that to initialize the backbone with random weights.`,name:"backbone"},{anchor:"transformers.DepthAnythingConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use pretrained weights for the backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.DepthAnythingConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 14) &#x2014;
The size of the patches to extract from the backbone features.`,name:"patch_size"},{anchor:"transformers.DepthAnythingConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.DepthAnythingConfig.reassemble_hidden_size",description:`<strong>reassemble_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 384) &#x2014;
The number of input channels of the reassemble layers.`,name:"reassemble_hidden_size"},{anchor:"transformers.DepthAnythingConfig.reassemble_factors",description:`<strong>reassemble_factors</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[4, 2, 1, 0.5]</code>) &#x2014;
The up/downsampling factors of the reassemble layers.`,name:"reassemble_factors"},{anchor:"transformers.DepthAnythingConfig.neck_hidden_sizes",description:`<strong>neck_hidden_sizes</strong> (<code>List[str]</code>, <em>optional</em>, defaults to <code>[48, 96, 192, 384]</code>) &#x2014;
The hidden sizes to project to for the feature maps of the backbone.`,name:"neck_hidden_sizes"},{anchor:"transformers.DepthAnythingConfig.fusion_hidden_size",description:`<strong>fusion_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
The number of channels before fusion.`,name:"fusion_hidden_size"},{anchor:"transformers.DepthAnythingConfig.head_in_index",description:`<strong>head_in_index</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
The index of the features to use in the depth estimation head.`,name:"head_in_index"},{anchor:"transformers.DepthAnythingConfig.head_hidden_size",description:`<strong>head_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The number of output channels in the second convolution of the depth estimation head.`,name:"head_hidden_size"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/depth_anything/configuration_depth_anything.py#L30"}}),k=new yt({props:{anchor:"transformers.DepthAnythingConfig.example",$$slots:{default:[vt]},$$scope:{ctx:U}}}),ne=new De({props:{name:"to_dict",anchor:"transformers.DepthAnythingConfig.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/depth_anything/configuration_depth_anything.py#L134"}}),se=new E({props:{title:"DepthAnythingForDepthEstimation",local:"transformers.DepthAnythingForDepthEstimation",headingTag:"h2"}}),ae=new De({props:{name:"class transformers.DepthAnythingForDepthEstimation",anchor:"transformers.DepthAnythingForDepthEstimation",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.DepthAnythingForDepthEstimation.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.40.0/en/model_doc/depth_anything#transformers.DepthAnythingConfig">DepthAnythingConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.40.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/depth_anything/modeling_depth_anything.py#L360"}}),oe=new De({props:{name:"forward",anchor:"transformers.DepthAnythingForDepthEstimation.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"labels",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.DepthAnythingForDepthEstimation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.40.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.40.0/en/model_doc/fuyu#transformers.FuyuImageProcessor.__call__">DPTImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.DepthAnythingForDepthEstimation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DepthAnythingForDepthEstimation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DepthAnythingForDepthEstimation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.40.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.DepthAnythingForDepthEstimation.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Ground truth depth estimation maps for computing the loss.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/models/depth_anything/modeling_depth_anything.py#L377",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.40.0/en/main_classes/output#transformers.modeling_outputs.DepthEstimatorOutput"
>transformers.modeling_outputs.DepthEstimatorOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.40.0/en/model_doc/depth_anything#transformers.DepthAnythingConfig"
>DepthAnythingConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>predicted_depth</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, height, width)</code>) — Predicted depth for each pixel.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, num_channels, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.40.0/en/main_classes/output#transformers.modeling_outputs.DepthEstimatorOutput"
>transformers.modeling_outputs.DepthEstimatorOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),G=new Jt({props:{$$slots:{default:[$t]},$$scope:{ctx:U}}}),I=new yt({props:{anchor:"transformers.DepthAnythingForDepthEstimation.forward.example",$$slots:{default:[Bt]},$$scope:{ctx:U}}}),{c(){r=i("meta"),_=a(),c=i("p"),h=a(),g(w.$$.fragment),l=a(),g(T.$$.fragment),ue=a(),z=i("p"),z.innerHTML=Oe,fe=a(),x=i("p"),x.textContent=et,ye=a(),D=i("p"),D.innerHTML=tt,be=a(),C=i("img"),Me=a(),R=i("small"),R.innerHTML=st,we=a(),F=i("p"),F.innerHTML=at,Te=a(),g(H.$$.fragment),je=a(),V=i("p"),V.innerHTML=ot,_e=a(),g(N.$$.fragment),Je=a(),X=i("p"),X.textContent=lt,ve=a(),g(Y.$$.fragment),$e=a(),g(L.$$.fragment),Be=a(),P=i("p"),P.textContent=rt,We=a(),g(S.$$.fragment),Ue=a(),g(q.$$.fragment),Ce=a(),Q=i("p"),Q.textContent=it,ke=a(),K=i("ul"),K.innerHTML=pt,Ze=a(),O=i("p"),O.textContent=ht,Ge=a(),g(ee.$$.fragment),Ie=a(),j=i("div"),g(te.$$.fragment),Fe=a(),re=i("p"),re.innerHTML=ct,He=a(),ie=i("p"),ie.innerHTML=dt,Ve=a(),g(k.$$.fragment),Ne=a(),Z=i("div"),g(ne.$$.fragment),Xe=a(),pe=i("p"),pe.innerHTML=mt,Ae=a(),g(se.$$.fragment),Ee=a(),J=i("div"),g(ae.$$.fragment),Ye=a(),he=i("p"),he.textContent=gt,Le=a(),ce=i("p"),ce.innerHTML=ut,Pe=a(),$=i("div"),g(oe.$$.fragment),Se=a(),de=i("p"),de.innerHTML=ft,qe=a(),g(G.$$.fragment),Qe=a(),g(I.$$.fragment),ze=a(),ge=i("p"),this.h()},l(e){const t=_t("svelte-u9bgzb",document.head);r=p(t,"META",{name:!0,content:!0}),t.forEach(n),_=o(e),c=p(e,"P",{}),me(c).forEach(n),h=o(e),u(w.$$.fragment,e),l=o(e),u(T.$$.fragment,e),ue=o(e),z=p(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-sr5hsf"&&(z.innerHTML=Oe),fe=o(e),x=p(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-vfdo9a"&&(x.textContent=et),ye=o(e),D=p(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-fbevff"&&(D.innerHTML=tt),be=o(e),C=p(e,"IMG",{src:!0,alt:!0,width:!0}),Me=o(e),R=p(e,"SMALL",{"data-svelte-h":!0}),m(R)!=="svelte-1ldczql"&&(R.innerHTML=st),we=o(e),F=p(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1a1ahjb"&&(F.innerHTML=at),Te=o(e),u(H.$$.fragment,e),je=o(e),V=p(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1ffao6h"&&(V.innerHTML=ot),_e=o(e),u(N.$$.fragment,e),Je=o(e),X=p(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1yjxirq"&&(X.textContent=lt),ve=o(e),u(Y.$$.fragment,e),$e=o(e),u(L.$$.fragment,e),Be=o(e),P=p(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-eza9ob"&&(P.textContent=rt),We=o(e),u(S.$$.fragment,e),Ue=o(e),u(q.$$.fragment,e),Ce=o(e),Q=p(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-msamn6"&&(Q.textContent=it),ke=o(e),K=p(e,"UL",{"data-svelte-h":!0}),m(K)!=="svelte-ndzl0g"&&(K.innerHTML=pt),Ze=o(e),O=p(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-1xesile"&&(O.textContent=ht),Ge=o(e),u(ee.$$.fragment,e),Ie=o(e),j=p(e,"DIV",{class:!0});var v=me(j);u(te.$$.fragment,v),Fe=o(v),re=p(v,"P",{"data-svelte-h":!0}),m(re)!=="svelte-t94a1n"&&(re.innerHTML=ct),He=o(v),ie=p(v,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-1pfahiz"&&(ie.innerHTML=dt),Ve=o(v),u(k.$$.fragment,v),Ne=o(v),Z=p(v,"DIV",{class:!0});var le=me(Z);u(ne.$$.fragment,le),Xe=o(le),pe=p(le,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-8eiw81"&&(pe.innerHTML=mt),le.forEach(n),v.forEach(n),Ae=o(e),u(se.$$.fragment,e),Ee=o(e),J=p(e,"DIV",{class:!0});var B=me(J);u(ae.$$.fragment,B),Ye=o(B),he=p(B,"P",{"data-svelte-h":!0}),m(he)!=="svelte-1lyww6q"&&(he.textContent=gt),Le=o(B),ce=p(B,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-1gjh92c"&&(ce.innerHTML=ut),Pe=o(B),$=p(B,"DIV",{class:!0});var A=me($);u(oe.$$.fragment,A),Se=o(A),de=p(A,"P",{"data-svelte-h":!0}),m(de)!=="svelte-1afgqtu"&&(de.innerHTML=ft),qe=o(A),u(G.$$.fragment,A),Qe=o(A),u(I.$$.fragment,A),A.forEach(n),B.forEach(n),ze=o(e),ge=p(e,"P",{}),me(ge).forEach(n),this.h()},h(){W(r,"name","hf:doc:metadata"),W(r,"content",Ut),Mt(C.src,nt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/depth_anything_overview.jpg")||W(C,"src",nt),W(C,"alt","drawing"),W(C,"width","600"),W(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){d(document.head,r),s(e,_,t),s(e,c,t),s(e,h,t),f(w,e,t),s(e,l,t),f(T,e,t),s(e,ue,t),s(e,z,t),s(e,fe,t),s(e,x,t),s(e,ye,t),s(e,D,t),s(e,be,t),s(e,C,t),s(e,Me,t),s(e,R,t),s(e,we,t),s(e,F,t),s(e,Te,t),f(H,e,t),s(e,je,t),s(e,V,t),s(e,_e,t),f(N,e,t),s(e,Je,t),s(e,X,t),s(e,ve,t),f(Y,e,t),s(e,$e,t),f(L,e,t),s(e,Be,t),s(e,P,t),s(e,We,t),f(S,e,t),s(e,Ue,t),f(q,e,t),s(e,Ce,t),s(e,Q,t),s(e,ke,t),s(e,K,t),s(e,Ze,t),s(e,O,t),s(e,Ge,t),f(ee,e,t),s(e,Ie,t),s(e,j,t),f(te,j,null),d(j,Fe),d(j,re),d(j,He),d(j,ie),d(j,Ve),f(k,j,null),d(j,Ne),d(j,Z),f(ne,Z,null),d(Z,Xe),d(Z,pe),s(e,Ae,t),f(se,e,t),s(e,Ee,t),s(e,J,t),f(ae,J,null),d(J,Ye),d(J,he),d(J,Le),d(J,ce),d(J,Pe),d(J,$),f(oe,$,null),d($,Se),d($,de),d($,qe),f(G,$,null),d($,Qe),f(I,$,null),s(e,ze,t),s(e,ge,t),xe=!0},p(e,[t]){const v={};t&2&&(v.$$scope={dirty:t,ctx:e}),k.$set(v);const le={};t&2&&(le.$$scope={dirty:t,ctx:e}),G.$set(le);const B={};t&2&&(B.$$scope={dirty:t,ctx:e}),I.$set(B)},i(e){xe||(y(w.$$.fragment,e),y(T.$$.fragment,e),y(H.$$.fragment,e),y(N.$$.fragment,e),y(Y.$$.fragment,e),y(L.$$.fragment,e),y(S.$$.fragment,e),y(q.$$.fragment,e),y(ee.$$.fragment,e),y(te.$$.fragment,e),y(k.$$.fragment,e),y(ne.$$.fragment,e),y(se.$$.fragment,e),y(ae.$$.fragment,e),y(oe.$$.fragment,e),y(G.$$.fragment,e),y(I.$$.fragment,e),xe=!0)},o(e){b(w.$$.fragment,e),b(T.$$.fragment,e),b(H.$$.fragment,e),b(N.$$.fragment,e),b(Y.$$.fragment,e),b(L.$$.fragment,e),b(S.$$.fragment,e),b(q.$$.fragment,e),b(ee.$$.fragment,e),b(te.$$.fragment,e),b(k.$$.fragment,e),b(ne.$$.fragment,e),b(se.$$.fragment,e),b(ae.$$.fragment,e),b(oe.$$.fragment,e),b(G.$$.fragment,e),b(I.$$.fragment,e),xe=!1},d(e){e&&(n(_),n(c),n(h),n(l),n(ue),n(z),n(fe),n(x),n(ye),n(D),n(be),n(C),n(Me),n(R),n(we),n(F),n(Te),n(je),n(V),n(_e),n(Je),n(X),n(ve),n($e),n(Be),n(P),n(We),n(Ue),n(Ce),n(Q),n(ke),n(K),n(Ze),n(O),n(Ge),n(Ie),n(j),n(Ae),n(Ee),n(J),n(ze),n(ge)),n(r),M(w,e),M(T,e),M(H,e),M(N,e),M(Y,e),M(L,e),M(S,e),M(q,e),M(ee,e),M(te),M(k),M(ne),M(se,e),M(ae),M(oe),M(G),M(I)}}}const Ut='{"title":"Depth Anything","local":"depth-anything","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"Pipeline API","local":"pipeline-api","sections":[],"depth":3},{"title":"Using the model yourself","local":"using-the-model-yourself","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"DepthAnythingConfig","local":"transformers.DepthAnythingConfig","sections":[],"depth":2},{"title":"DepthAnythingForDepthEstimation","local":"transformers.DepthAnythingForDepthEstimation","sections":[],"depth":2}],"depth":1}';function Ct(U){return wt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xt extends Tt{constructor(r){super(),jt(this,r,Ct,Wt,bt,{})}}export{xt as component};
