import{s as vw,o as Mw,n as x}from"../chunks/scheduler.9bc65507.js";import{S as ww,i as $w,g as a,s as n,r as p,A as kw,h as l,f as s,c as o,j as T,u as m,x as y,k as v,y as t,a as d,v as g,d as u,t as h,w as f}from"../chunks/index.707bf1b6.js";import{T as bn}from"../chunks/Tip.c2ecdbf4.js";import{D as M}from"../chunks/Docstring.17db21ae.js";import{C as J}from"../chunks/CodeBlock.54a9f38d.js";import{E as B}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as K}from"../chunks/Heading.342b1fa6.js";function jw(j){let i,k=`This logits processor is exclusively compatible with
<a href="https://huggingface.co/docs/transformers/en/model_doc/bark" rel="nofollow">Bark</a>’s fine submodel. See the model documentation
for examples.`;return{c(){i=a("p"),i.innerHTML=k},l(b){i=l(b,"P",{"data-svelte-h":!0}),y(i)!=="svelte-nbt45a"&&(i.innerHTML=k)},m(b,_){d(b,i,_)},p:x,d(b){b&&s(i)}}}function xw(j){let i,k=`This logits processor is exclusively compatible with
<a href="https://huggingface.co/docs/transformers/main/en/model_doc/musicgen" rel="nofollow">MusicGen</a>`;return{c(){i=a("p"),i.innerHTML=k},l(b){i=l(b,"P",{"data-svelte-h":!0}),y(i)!=="svelte-1uojnuk"&&(i.innerHTML=k)},m(b,_){d(b,i,_)},p:x,d(b){b&&s(i)}}}function Jw(j){let i,k="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoJTBBJTIwJTIwJTIwJTIwdGV4dCUzRCU1QiUyMjgwcyUyMHBvcCUyMHRyYWNrJTIwd2l0aCUyMGJhc3N5JTIwZHJ1bXMlMjBhbmQlMjBzeW50aCUyMiUyQyUyMCUyMjkwcyUyMHJvY2slMjBzb25nJTIwd2l0aCUyMGxvdWQlMjBndWl0YXJzJTIwYW5kJTIwaGVhdnklMjBkcnVtcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSklMEFhdWRpb192YWx1ZXMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1Nik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s pop track with bassy drums and synth&quot;</span>, <span class="hljs-string">&quot;90s rock song with loud guitars and heavy drums&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),{c(){i=a("p"),i.textContent=k,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=k),b=o(r),m(_.$$.fragment,r)},m(r,$){d(r,i,$),d(r,b,$),g(_,r,$),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function Uw(j){let i,k="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkFsaWNlJTNBJTIwSSUyMGxvdmUlMjBjYXRzLiUyMFdoYXQlMjBkbyUyMHlvdSUyMGxvdmUlM0YlNUNuQm9iJTNBJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwZ3JlZWR5JTIwZGVjb2RpbmclMkMlMjB3ZSUyMHNlZSUyMEJvYiUyMHJlcGVhdGluZyUyMEFsaWNlJ3MlMjBvcGluaW9uLiUyMElmJTIwQm9iJTIwd2FzJTIwYSUyMGNoYXRib3QlMkMlMjBpdCUyMHdvdWxkJTIwYmUlMjBhJTIwcG9vciUyMG9uZS4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwdGhpcyUyMGxvZ2l0cyUyMHByb2Nlc3NvciUyQyUyMHdlJTIwY2FuJTIwcHJldmVudCUyMEJvYiUyMGZyb20lMjByZXBlYXRpbmclMjBBbGljZSdzJTIwb3Bpbmlvbi4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBlbmNvZGVyX25vX3JlcGVhdF9uZ3JhbV9zaXplJTNEMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Alice: I love cats. What do you love?\\nBob:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With greedy decoding, we see Bob repeating Alice&#x27;s opinion. If Bob was a chatbot, it would be a poor one.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice: I love cats. What do you love?
Bob: I love cats. What do you

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With this logits processor, we can prevent Bob from repeating Alice&#x27;s opinion.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, encoder_no_repeat_ngram_size=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice: I love cats. What do you love?
Bob: My cats are very cute.`,wrap:!1}}),{c(){i=a("p"),i.textContent=k,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=k),b=o(r),m(_.$$.fragment,r)},m(r,$){d(r,i,$),d(r,b,$),g(_,r,$),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function Bw(j){let i,k="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkFsaWNlJTIwYW5kJTIwQm9iLiUyMFRoZSUyMHRoaXJkJTIwbWVtYmVyJ3MlMjBuYW1lJTIwd2FzJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwdGhlJTIwJTYwZW5jb2Rlcl9yZXBldGl0aW9uX3BlbmFsdHklNjAlMjBhcmd1bWVudCUyMHdlJTIwY2FuJTIwdHJpZ2dlciUyMHRoaXMlMjBsb2dpdHMlMjBwcm9jZXNzb3IlMjBpbiUyMCU2MGdlbmVyYXRlJTYwJTJDJTIwd2hpY2glMjBjYW4lMEElMjMlMjBwcm9tb3RlJTIwdGhlJTIwdXNlJTIwb2YlMjBwcm9tcHQlMjB0b2tlbnMlMjAoJTIyQm9iJTIyJTIwaW4lMjB0aGlzJTIwZXhhbXBsZSklMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBlbmNvZGVyX3JlcGV0aXRpb25fcGVuYWx0eSUzRDEuMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Alice and Bob. The third member&#x27;s name was&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob. The third membe<span class="hljs-string">r&#x27;s name was not mentioned.

&gt;&gt;&gt; # With the \`encoder_repetition_penalty\` argument we can trigger this logits processor in \`generate\`, which can
&gt;&gt;&gt; # promote the use of prompt tokens (&quot;Bob&quot; in this example)
&gt;&gt;&gt; gen_out = model.generate(**inputs, encoder_repetition_penalty=1.2)
&gt;&gt;&gt; print(tokenizer.batch_decode(gen_out, skip_special_tokens=True)[0])
Alice and Bob. The third member&#x27;</span>s name was Bob. The third membe<span class="hljs-string">r&#x27;s name was Bob.</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=k,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=k),b=o(r),m(_.$$.fragment,r)},m(r,$){d(r,i,$),d(r,b,$),g(_,r,$),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function Iw(j){let i,k="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMGVwc2lsb24lMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGdldHMlMjByZXN0cmljdGVkJTIwdG8lMjBoaWdoLXByb2JhYmlsaXR5JTIwdG9rZW5zLiUyME5vdGUlMjB0aGF0JTIwdGhpcyUyMGlzJTIwc2ltaWxhciUyMHRvJTBBJTIzJTIwVG9wJTIwUCUyMHNhbXBsaW5nJTJDJTIwd2hpY2glMjByZXN0cmljdHMlMjB0b2tlbnMlMjBiYXNlZCUyMG9uJTIwdGhlaXIlMjBjdW11bGF0aXZlJTIwcHJvYmFiaWxpdHkuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwVGhlJTIwcGFwZXIlMjByZWNvbWVuZHMlMjB1c2luZyUyMCU2MGVwc2lsb25fY3V0b2ZmJTYwJTIwdmFsdWVzJTIwYmV0d2VlbiUyMDNlLTQlMjBhbmQlMjA5ZS00JTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMGVwc2lsb25fY3V0b2ZmJTNEMC4xKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> | &lt; <span class="hljs-number">4</span> (left-hand pointer) ;
&lt;BLANKLINE&gt;
&lt;BLANKLINE&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With epsilon sampling, the output gets restricted to high-probability tokens. Note that this is similar to</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Top P sampling, which restricts tokens based on their cumulative probability.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: The paper recomends using \`epsilon_cutoff\` values between 3e-4 and 9e-4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, epsilon_cutoff=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=k,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=k),b=o(r),m(_.$$.fragment,r)},m(r,$){d(r,i,$),d(r,b,$),g(_,r,$),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function Zw(j){let i,k="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMGV0YSUyMHNhbXBsaW5nJTJDJTIwdGhlJTIwb3V0cHV0JTIwZ2V0cyUyMHJlc3RyaWN0ZWQlMjB0byUyMGhpZ2gtcHJvYmFiaWxpdHklMjB0b2tlbnMuJTIwWW91JTIwY2FuJTIwc2VlJTIwaXQlMjBhcyUyMGElMjBkeW5hbWljJTIwZm9ybSUyMG9mJTBBJTIzJTIwZXBzaWxvbiUyMHNhbXBsaW5nJTIwdGhhdCUyMGFkYXB0cyUyMGl0cyUyMGN1dG9mZiUyMHByb2JhYmlsaXR5JTIwYmFzZWQlMjBvbiUyMHRoZSUyMGVudHJvcHklMjAoaGlnaCUyMGVudHJvcHklMjAlM0QlMjBsb3dlciUyMGN1dG9mZikuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwVGhlJTIwcGFwZXIlMjByZWNvbWVuZHMlMjB1c2luZyUyMCU2MGV0YV9jdXRvZmYlNjAlMjB2YWx1ZXMlMjBiZXR3ZWVuJTIwM2UtNCUyMHRvJTIwNGUtMyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBldGFfY3V0b2ZmJTNEMC4xKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> | &lt; <span class="hljs-number">4</span> (left-hand pointer) ;
&lt;BLANKLINE&gt;
&lt;BLANKLINE&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With eta sampling, the output gets restricted to high-probability tokens. You can see it as a dynamic form of</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># epsilon sampling that adapts its cutoff probability based on the entropy (high entropy = lower cutoff).</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: The paper recomends using \`eta_cutoff\` values between 3e-4 to 4e-3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, eta_cutoff=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=k,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=k),b=o(r),m(_.$$.fragment,r)},m(r,$){d(r,i,$),d(r,b,$),g(_,r,$),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function zw(j){let i,k="Examples:",b,_,w;return _=new J({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;Just wanted to let you know, I&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Let&#x27;s consider that we want short sentences, so we limit \`max_length=30\`. However, we observe that the answer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># tends to end abruptly.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.9</span>, max_length=<span class="hljs-number">30</span>, pad_token_id=<span class="hljs-number">50256</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network which was
published <span class="hljs-keyword">in</span> <span class="hljs-number">2010.</span> Although

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To promote the appearance of the EOS token at the right time, we add the \`exponential_decay_length_penalty =</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># (start_index, decay_factor)\`. Instead of cutting at max_tokens, the output comes to an end before and usually</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with more meaning. What happens is that starting from \`start_index\` the EOS token score will be increased</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># by \`decay_factor\` exponentially. However, if you set a high decay factor, you may also end up with abruptly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># ending sequences.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.9</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    pad_token_id=<span class="hljs-number">50256</span>,
<span class="hljs-meta">... </span>    exponential_decay_length_penalty=(<span class="hljs-number">15</span>, <span class="hljs-number">1.6</span>),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network
which&lt;|endoftext|&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With a small decay factor, you will have a higher chance of getting a meaningful sequence.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.9</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    pad_token_id=<span class="hljs-number">50256</span>,
<span class="hljs-meta">... </span>    exponential_decay_length_penalty=(<span class="hljs-number">15</span>, <span class="hljs-number">1.01</span>),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network which was
published <span class="hljs-keyword">in</span> <span class="hljs-number">2010.</span>&lt;|endoftext|&gt;`,wrap:!1}}),{c(){i=a("p"),i.textContent=k,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=k),b=o(r),m(_.$$.fragment,r)},m(r,$){d(r,i,$),d(r,b,$),g(_,r,$),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function Ww(j){let i,k="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZmxhbi10NS1zbWFsbCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZmbGFuLXQ1LXNtYWxsJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJUcmFuc2xhdGUlMjBmcm9tJTIwRW5nbGlzaCUyMHRvJTIwR2VybWFuJTNBJTIwSSUyMGxvdmUlMjBjYXRzLiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwQnklMjBkZWZhdWx0JTJDJTIwaXQlMjBjb250aW51ZXMlMjBnZW5lcmF0aW5nJTIwYWNjb3JkaW5nJTIwdG8lMjB0aGUlMjBtb2RlbCdzJTIwbG9naXRzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMpJTVCMCU1RCklMEElMEElMjMlMjBXZSUyMGNhbiUyMHVzZSUyMCU2MGZvcmNlZF9ib3NfdG9rZW5faWQlNjAlMjB0byUyMGZvcmNlJTIwdGhlJTIwc3RhcnQlMjBvZiUyMGdlbmVyYXRpb24lMjB3aXRoJTIwYW4lMjBlbmNvZGVyLWRlY29kZXIlMjBtb2RlbCUwQSUyMyUyMChpbmNsdWRpbmclMjBmb3JjaW5nJTIwaXQlMjB0byUyMGVuZCUyMHN0cmFpZ2h0JTIwYXdheSUyMHdpdGglMjBhbiUyMEVPUyUyMHRva2VuKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAlMkMlMjBmb3JjZWRfYm9zX3Rva2VuX2lkJTNEdG9rZW5pemVyLmVvc190b2tlbl9pZCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Translate from English to German: I love cats.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
&lt;pad&gt; Ich liebe Kitty.&lt;/s&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can use \`forced_bos_token_id\` to force the start of generation with an encoder-decoder model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># (including forcing it to end straight away with an EOS token)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, forced_bos_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
&lt;pad&gt;&lt;/s&gt;`,wrap:!1}}),{c(){i=a("p"),i.textContent=k,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=k),b=o(r),m(_.$$.fragment,r)},m(r,$){d(r,i,$),d(r,b,$),g(_,r,$),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function Lw(j){let i,k="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJBJTIwc2VxdWVuY2UlM0ElMjAxJTJDJTIwMiUyQyUyMDMlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMEJ5JTIwZGVmYXVsdCUyQyUyMGl0JTIwY29udGludWVzJTIwZ2VuZXJhdGluZyUyMGFjY29yZGluZyUyMHRvJTIwdGhlJTIwbW9kZWwncyUyMGxvZ2l0cyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTApJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzKSU1QjAlNUQpJTBBJTBBJTIzJTIwJTYwZm9yY2VkX2Vvc190b2tlbl9pZCU2MCUyMGVuc3VyZXMlMjB0aGUlMjBnZW5lcmF0aW9uJTIwZW5kcyUyMHdpdGglMjBhJTIwRU9TJTIwdG9rZW4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwJTJDJTIwZm9yY2VkX2Vvc190b2tlbl9pZCUzRHRva2VuaXplci5lb3NfdG9rZW5faWQpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># \`forced_eos_token_id\` ensures the generation ends with a EOS token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, forced_eos_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>,&lt;|endoftext|&gt;`,wrap:!1}}),{c(){i=a("p"),i.textContent=k,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=k),b=o(r),m(_.$$.fragment,r)},m(r,$){d(r,i,$),d(r,b,$),g(_,r,$),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function Cw(j){let i,k="Examples:",b,_,w;return _=new J({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initialize the model and tokenizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># A long text about the solar system</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;The Solar System is a gravitationally bound system comprising the Sun and the objects that orbit it, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;either directly or indirectly. Of the objects that orbit the Sun directly, the largest are the eight &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;planets, with the remainder being smaller objects, such as the five dwarf planets and small Solar System &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;bodies. The Solar System formed 4.6 billion years ago from the gravitational collapse of a giant &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;interstellar molecular cloud.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;summarize: &quot;</span> + text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate diverse summary</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs_diverse = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    num_beam_groups=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    diversity_penalty=<span class="hljs-number">10.0</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summaries_diverse = tokenizer.batch_decode(outputs_diverse, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate non-diverse summary</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs_non_diverse = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_non_diverse = tokenizer.batch_decode(outputs_non_diverse, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`diversity_penalty\`, the resulting beams are much more diverse</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(summary_non_diverse)
[<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>,
<span class="hljs-string">&#x27;the Solar System formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(summaries_diverse)
[<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>,
<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets. the rest of the objects are smaller objects, such as the five dwarf planets and small solar system bodies.&#x27;</span>]`,wrap:!1}}),{c(){i=a("p"),i.textContent=k,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=k),b=o(r),m(_.$$.fragment,r)},m(r,$){d(r,i,$),d(r,b,$),g(_,r,$),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function Vw(j){let i,k="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsYmVydCUyRmRpc3RpbGdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsYmVydCUyRmRpc3RpbGdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBzZXF1ZW5jZSUzQSUyMDElMkMlMjAyJTJDJTIwMyUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwQnklMjBkZWZhdWx0JTJDJTIwdGhlJTIwc2NvcmVzJTIwYXJlJTIwbm90JTIwbm9ybWFsaXplZCUyMC0tJTIwdGhlJTIwc3VtJTIwb2YlMjB0aGVpciUyMGV4cG9uZW50aWFscyUyMGlzJTIwTk9UJTIwYSUyMG5vcm1hbGl6ZWQlMjBwcm9iYWJpbGl0eSUwQSUyMyUyMGRpc3RyaWJ1dGlvbiUyQyUyMHN1bW1pbmclMjB0byUyMDElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZXR1cm5fZGljdF9pbl9nZW5lcmF0ZSUzRFRydWUlMkMlMjBvdXRwdXRfc2NvcmVzJTNEVHJ1ZSklMEFwcmludCh0b3JjaC5hbGxjbG9zZSh0b3JjaC5zdW0odG9yY2guZXhwKG91dHB1dHMuc2NvcmVzJTVCLTElNUQpKSUyQyUyMHRvcmNoLlRlbnNvcigoMS4wMDAlMkMpKSUyQyUyMHJ0b2wlM0QxZS00KSklMEElMEElMjMlMjBOb3JtYWxpemluZyUyMHRoZW0lMjBtYXklMjBoYXZlJTIwYSUyMHBvc2l0aXZlJTIwaW1wYWN0JTIwb24lMjBiZWFtJTIwbWV0aG9kcyUyQyUyMG9yJTIwd2hlbiUyMHVzaW5nJTIwdGhlJTIwc2NvcmVzJTIwb24lMjB5b3VyJTIwYXBwbGljYXRpb24lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZW5vcm1hbGl6ZV9sb2dpdHMlM0RUcnVlJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUpJTBBcHJpbnQodG9yY2guYWxsY2xvc2UodG9yY2guc3VtKHRvcmNoLmV4cChvdXRwdXRzLnNjb3JlcyU1Qi0xJTVEKSklMkMlMjB0b3JjaC5UZW5zb3IoKDEuMDAwJTJDKSklMkMlMjBydG9sJTNEMWUtNCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the scores are not normalized -- the sum of their exponentials is NOT a normalized probability</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># distribution, summing to 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(torch.allclose(torch.<span class="hljs-built_in">sum</span>(torch.exp(outputs.scores[-<span class="hljs-number">1</span>])), torch.Tensor((<span class="hljs-number">1.000</span>,)), rtol=<span class="hljs-number">1e-4</span>))
<span class="hljs-literal">False</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Normalizing them may have a positive impact on beam methods, or when using the scores on your application</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, renormalize_logits=<span class="hljs-literal">True</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(torch.allclose(torch.<span class="hljs-built_in">sum</span>(torch.exp(outputs.scores[-<span class="hljs-number">1</span>])), torch.Tensor((<span class="hljs-number">1.000</span>,)), rtol=<span class="hljs-number">1e-4</span>))
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=k,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=k),b=o(r),m(_.$$.fragment,r)},m(r,$){d(r,i,$),d(r,b,$),g(_,r,$),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function Fw(j){let i,k="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBudW1iZXIlM0ElMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMHNldHRpbmclMjAlNjBtaW5fbGVuZ3RoJTYwJTIwdG8lMjBhJTIwdmFsdWUlMjBzbWFsbGVyJTIwdGhhbiUyMHRoZSUyMHVuY29udHJvbGxlZCUyMG91dHB1dCUyMGxlbmd0aCUyMGhhcyUyMG5vJTIwaW1wYWN0JTBBZ2VuX291dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWluX2xlbmd0aCUzRDMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBzZXR0aW5nJTIwYSUyMGxhcmdlciUyMCU2MG1pbl9sZW5ndGglNjAlMjB3aWxsJTIwZm9yY2UlMjB0aGUlMjBtb2RlbCUyMHRvJTIwZ2VuZXJhdGUlMjBiZXlvbmQlMjBpdHMlMjBuYXR1cmFsJTIwZW5kaW5nJTIwcG9pbnQlMkMlMjB3aGljaCUyMGlzJTIwbm90JTBBJTIzJTIwbmVjZXNzYXJpbHklMjBpbmNvcnJlY3QlMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtaW5fbGVuZ3RoJTNEMTApJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A number:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting \`min_length\` to a value smaller than the uncontrolled output length has no impact</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_length=<span class="hljs-number">3</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting a larger \`min_length\` will force the model to generate beyond its natural ending point, which is not</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># necessarily incorrect</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_length=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one thousand, nine hundred <span class="hljs-keyword">and</span> ninety-four`,wrap:!1}}),{c(){i=a("p"),i.textContent=k,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=k),b=o(r),m(_.$$.fragment,r)},m(r,$){d(r,i,$),d(r,b,$),g(_,r,$),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function Gw(j){let i,k="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkElMjBudW1iZXIlM0ElMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMHNldHRpbmclMjAlNjBtaW5fbmV3X3Rva2VucyU2MCUyMHdpbGwlMjBmb3JjZSUyMHRoZSUyMG1vZGVsJTIwdG8lMjBnZW5lcmF0ZSUyMGJleW9uZCUyMGl0cyUyMG5hdHVyYWwlMjBlbmRpbmclMjBwb2ludCUyQyUyMHdoaWNoJTIwaXMlMjBub3QlMEElMjMlMjBuZWNlc3NhcmlseSUyMGluY29ycmVjdCUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1pbl9uZXdfdG9rZW5zJTNEMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;A number:&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting \`min_new_tokens\` will force the model to generate beyond its natural ending point, which is not</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># necessarily incorrect</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_new_tokens=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one thousand`,wrap:!1}}),{c(){i=a("p"),i.textContent=k,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=k),b=o(r),m(_.$$.fragment,r)},m(r,$){d(r,i,$),d(r,b,$),g(_,r,$),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function Xw(j){let i,k=`In order to get the token ids of the words that should not appear in the generated text, make sure to set
<code>add_prefix_space=True</code> when initializing the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The <code>add_prefix_space</code> argument is only supported for some slow tokenizers,
as fast tokenizers’ prefixing behaviours come from <code>pre tokenizers</code>. Read more
<a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`;return{c(){i=a("p"),i.innerHTML=k},l(b){i=l(b,"P",{"data-svelte-h":!0}),y(i)!=="svelte-15bvr1j"&&(i.innerHTML=k)},m(b,_){d(b,i,_)},p:x,d(b){b&&s(i)}}}function Rw(j){let i,k="Examples:",b,_,w;return _=new J({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;In a word, the cake is a&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">5</span>, pad_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(output_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a mess.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s take the bad words out. Please note that the tokenizer is initialized differently</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_with_prefix_space = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens_as_list</span>(<span class="hljs-params">word_list</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Converts a sequence of words into a list of tokens&quot;</span>
<span class="hljs-meta">... </span>    tokens_list = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_list:
<span class="hljs-meta">... </span>        tokenized_word = tokenizer_with_prefix_space([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>        tokens_list.append(tokenized_word)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokens_list


<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = get_tokens_as_list(word_list=[<span class="hljs-string">&quot;mess&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>output_ids = model.generate(
<span class="hljs-meta">... </span>    inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">5</span>, bad_words_ids=bad_words_ids, pad_token_id=tokenizer.eos_token_id
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(output_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a surprise.`,wrap:!1}}),{c(){i=a("p"),i.textContent=k,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=k),b=o(r),m(_.$$.fragment,r)},m(r,$){d(r,i,$),d(r,b,$),g(_,r,$),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function Sw(j){let i,k=`Use n-gram penalties with care. For instance, penalizing 2-grams (bigrams) in an article about the city of New York
might lead to undesirable outcomes where the city’s name appears only once in the entire text.
<a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">Reference</a>`;return{c(){i=a("p"),i.innerHTML=k},l(b){i=l(b,"P",{"data-svelte-h":!0}),y(i)!=="svelte-5zfsi9"&&(i.innerHTML=k)},m(b,_){d(b,i,_)},p:x,d(b){b&&s(i)}}}function Nw(j){let i,k="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJUb2RheSUyMEklMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0JTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElMEElMjMlMjBOb3clMjBsZXQncyUyMGFkZCUyMG5ncmFtJTIwc2l6ZSUyMHVzaW5nJTIwJTYwbm9fcmVwZWF0X25ncmFtX3NpemUlNjAuJTIwVGhpcyUyMHN0b3BzJTIwdGhlJTIwcmVwZXRpdGlvbnMlMjAoJTIySSVFMiU4MCU5OW0lMjIpJTIwaW4lMjB0aGUlMjBvdXRwdXQuJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBub19yZXBlYXRfbmdyYW1fc2l6ZSUzRDIpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXQlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today I&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Today I’m <span class="hljs-keyword">not</span> sure <span class="hljs-keyword">if</span> I’m going to be able to do it.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s add ngram size using \`no_repeat_ngram_size\`. This stops the repetitions (&quot;I’m&quot;) in the output.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs, no_repeat_ngram_size=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Today I’m <span class="hljs-keyword">not</span> sure <span class="hljs-keyword">if</span> I can get a better understanding of the nature of this issue`,wrap:!1}}),{c(){i=a("p"),i.textContent=k,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=k),b=o(r),m(_.$$.fragment,r)},m(r,$){d(r,i,$),d(r,b,$),g(_,r,$),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function Ew(j){let i,k="Examples:",b,_,w;return _=new J({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Alice and Bob&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob are friends

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can contrain it with \`prefix_allowed_tokens_fn\` to force a certain behavior based on a prefix.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For instance, we can force an entire entity to be generated when its beginning is detected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>entity = tokenizer(<span class="hljs-string">&quot; Bob Marley&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids[<span class="hljs-number">0</span>]  <span class="hljs-comment"># 3 tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">prefix_allowed_tokens_fn</span>(<span class="hljs-params">batch_id, input_ids</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Attempts to generate &#x27;Bob Marley&#x27; when &#x27;Bob&#x27; is detected.
<span class="hljs-meta">... </span>    In this case, \`batch_id\` is not used, but you can set rules for each batch member.
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> input_ids[-<span class="hljs-number">1</span>] == entity[<span class="hljs-number">0</span>]:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> [entity[<span class="hljs-number">1</span>].item()]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">elif</span> input_ids[-<span class="hljs-number">2</span>] == entity[<span class="hljs-number">0</span>] <span class="hljs-keyword">and</span> input_ids[-<span class="hljs-number">1</span>] == entity[<span class="hljs-number">1</span>]:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> [entity[<span class="hljs-number">2</span>].item()]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> <span class="hljs-built_in">list</span>(<span class="hljs-built_in">range</span>(tokenizer.vocab_size))  <span class="hljs-comment"># If no match, allow all tokens</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>, prefix_allowed_tokens_fn=prefix_allowed_tokens_fn)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob Marley`,wrap:!1}}),{c(){i=a("p"),i.textContent=k,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=k),b=o(r),m(_.$$.fragment,r)},m(r,$){d(r,i,$),d(r,b,$),g(_,r,$),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function Hw(j){let i,k="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMHRoZSUyMG1vZGVsJTIwYW5kJTIwdG9rZW5pemVyJTIwZm9yJTIwaXQlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIySSdtJTIwbm90JTIwZ29pbmclMjB0byUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwVGhpcyUyMHNob3dzJTIwYSUyMG5vcm1hbCUyMGdlbmVyYXRlJTIwd2l0aG91dCUyMGFueSUyMHNwZWNpZmljJTIwcGFyYW1ldGVycyUwQXN1bW1hcnlfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShzdW1tYXJ5X2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwVGhpcyUyMGdlbmVyYXRlcyUyMGElMjBwZW5hbHR5JTIwZm9yJTIwcmVwZWF0ZWQlMjB0b2tlbnMlMEFwZW5hbGl6ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZXBldGl0aW9uX3BlbmFsdHklM0QxLjEpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShwZW5hbGl6ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing the model and tokenizer for it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;I&#x27;m not going to&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This shows a normal generate without any specific parameters</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to be able to do that. I&#x27;</span>m going to be able to do that

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This generates a penalty for repeated tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>penalized_ids = model.generate(**inputs, repetition_penalty=<span class="hljs-number">1.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(penalized_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to be able to do that. I&#x27;</span>ll just have to go out <span class="hljs-keyword">and</span> play`,wrap:!1}}),{c(){i=a("p"),i.textContent=k,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=k),b=o(r),m(_.$$.fragment,r)},m(r,$){d(r,i,$),d(r,b,$),g(_,r,$),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function qw(j){let i,k=`In order to get the token ids of the sequences that you want to bias, make sure to set <code>add_prefix_space=True</code> when
initializing the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The
<code>add_prefix_space</code> argument is only supported for some slow tokenizers, as fast tokenizers’ prefixing behaviours
come from <code>pre tokenizers</code>. Read more <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`;return{c(){i=a("p"),i.innerHTML=k},l(b){i=l(b,"P",{"data-svelte-h":!0}),y(i)!=="svelte-16cusgy"&&(i.innerHTML=k)},m(b,_){d(b,i,_)},p:x,d(b){b&&s(i)}}}function Dw(j){let i,k="Examples:",b,_,w;return _=new J({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;The full name of Donald is Donald&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald J. Trump Jr

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s control generation through a bias. Please note that the tokenizer is initialized differently!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_with_prefix_space = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens_as_tuple</span>(<span class="hljs-params">word</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> <span class="hljs-built_in">tuple</span>(tokenizer_with_prefix_space([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>])


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we add a negative bias without beam search, it may become &quot;stuck&quot; in a prefix without good continuations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = {get_tokens_as_tuple(<span class="hljs-string">&quot;Trump&quot;</span>): -<span class="hljs-number">10.0</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald J. Donald,

<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, num_beams=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald Rumsfeld,

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can also add a positive bias to nudge the model towards specific tokens or continuations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = {get_tokens_as_tuple(<span class="hljs-string">&quot;Donald Duck&quot;</span>): <span class="hljs-number">10.0</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, num_beams=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald Duck.`,wrap:!1}}),{c(){i=a("p"),i.textContent=k,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=k),b=o(r),m(_.$$.fragment,r)},m(r,$){d(r,i,$),d(r,b,$),g(_,r,$),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function Pw(j){let i,k="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBXaGlzcGVyRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2hpc3BlciUyMGhhcyUyMCU2MGJlZ2luX3N1cHByZXNzX3Rva2VucyU2MCUyMHNldCUyMGJ5JTIwZGVmYXVsdCUyMCglM0QlMjAlNjAlNUIyMjAlMkMlMjA1MDI1NiU1RCU2MCkuJTIwNTAyNTYlMjBpcyUyMHRoZSUyMEVPUyUyMHRva2VuJTJDJTIwc28lMjB0aGlzJTIwbWVhbnMlMEElMjMlMjBpdCUyMGNhbid0JTIwZ2VuZXJhdGUlMjBhbmQlMjBFT1MlMjB0b2tlbiUyMGluJTIwdGhlJTIwZmlyc3QlMjBpdGVyYXRpb24lMkMlMjBidXQlMjBpdCUyMGNhbiUyMGluJTIwdGhlJTIwb3RoZXJzLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSUyQyUyMG91dHB1dF9zY29yZXMlM0RUcnVlKSUwQXByaW50KG91dHB1dHMuc2NvcmVzJTVCMCU1RCU1QjAlMkMlMjA1MDI1NiU1RCklMEFwcmludChvdXRwdXRzLnNjb3JlcyU1Qi0xJTVEJTVCMCUyQyUyMDUwMjU2JTVEKSUyMCUyMCUyMyUyMGluJTIwb3RoZXIlMjBwbGFjZXMlMjB3ZSUyMGNhbiUyMHNlZSUyMHNvbWUlMjBwcm9iYWJpbGl0eSUyMG1hc3MlMjBmb3IlMjBFT1MlMEElMEElMjMlMjBJZiUyMHdlJTIwZGlzYWJsZSUyMCU2MGJlZ2luX3N1cHByZXNzX3Rva2VucyU2MCUyQyUyMHdlJTIwY2FuJTIwZ2VuZXJhdGUlMjBFT1MlMjBpbiUyMHRoZSUyMGZpcnN0JTIwaXRlcmF0aW9uLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAqKmlucHV0cyUyQyUyMHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSUyQyUyMG91dHB1dF9zY29yZXMlM0RUcnVlJTJDJTIwYmVnaW5fc3VwcHJlc3NfdG9rZW5zJTNETm9uZSUwQSklMEFwcmludChvdXRwdXRzLnNjb3JlcyU1QjAlNUQlNUIwJTJDJTIwNTAyNTYlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Whisper has \`begin_suppress_tokens\` set by default (= \`[220, 50256]\`). 50256 is the EOS token, so this means</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># it can&#x27;t generate and EOS token in the first iteration, but it can in the others.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])
tensor(-inf)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[-<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])  <span class="hljs-comment"># in other places we can see some probability mass for EOS</span>
tensor(<span class="hljs-number">29.9010</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we disable \`begin_suppress_tokens\`, we can generate EOS in the first iteration.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>, begin_suppress_tokens=<span class="hljs-literal">None</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])
tensor(<span class="hljs-number">11.2027</span>)`,wrap:!1}}),{c(){i=a("p"),i.textContent=k,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=k),b=o(r),m(_.$$.fragment,r)},m(r,$){d(r,i,$),d(r,b,$),g(_,r,$),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function Qw(j){let i,k="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBXaGlzcGVyRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2hpc3BlciUyMGhhcyUyMGElMjBsb25nJTIwbGlzdCUyMG9mJTIwc3VwcHJlc3NlZCUyMHRva2Vucy4lMjBGb3IlMjBpbnN0YW5jZSUyQyUyMGluJTIwdGhpcyUyMGNhc2UlMkMlMjB0aGUlMjB0b2tlbiUyMDElMjBpcyUyMHN1cHByZXNzZWQlMjBieSUyMGRlZmF1bHQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUpJTBBcHJpbnQob3V0cHV0cy5zY29yZXMlNUIxJTVEJTVCMCUyQyUyMDElNUQpJTIwJTIwJTIzJTIwMSUyMChhbmQlMjBub3QlMjAwKSUyMGlzJTIwdGhlJTIwZmlyc3QlMjBmcmVlbHklMjBnZW5lcmF0ZWQlMjB0b2tlbiUwQSUwQSUyMyUyMElmJTIwd2UlMjBkaXNhYmxlJTIwJTYwc3VwcHJlc3NfdG9rZW5zJTYwJTJDJTIwd2UlMjBjYW4lMjBnZW5lcmF0ZSUyMGl0LiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSUyQyUyMG91dHB1dF9zY29yZXMlM0RUcnVlJTJDJTIwc3VwcHJlc3NfdG9rZW5zJTNETm9uZSklMEFwcmludChvdXRwdXRzLnNjb3JlcyU1QjElNUQlNUIwJTJDJTIwMSU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Whisper has a long list of suppressed tokens. For instance, in this case, the token 1 is suppressed by default.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])  <span class="hljs-comment"># 1 (and not 0) is the first freely generated token</span>
tensor(-inf)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we disable \`suppress_tokens\`, we can generate it.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>, suppress_tokens=<span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])
tensor(<span class="hljs-number">6.0678</span>)`,wrap:!1}}),{c(){i=a("p"),i.textContent=k,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=k),b=o(r),m(_.$$.fragment,r)},m(r,$){d(r,i,$),d(r,b,$),g(_,r,$),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function Yw(j){let i,k=`Make sure that <code>do_sample=True</code> is included in the <code>generate</code> arguments otherwise the temperature value won’t have
any effect.`;return{c(){i=a("p"),i.innerHTML=k},l(b){i=l(b,"P",{"data-svelte-h":!0}),y(i)!=="svelte-1byeoum"&&(i.innerHTML=k)},m(b,_){d(b,i,_)},p:x,d(b){b&&s(i)}}}function Aw(j){let i,k="Examples:",b,_,w;return _=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwc2V0X3NlZWQlMEElMEFzZXRfc2VlZCgwKSUyMCUyMCUyMyUyMGZvciUyMHJlcHJvZHVjaWJpbGl0eSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsLmNvbmZpZy5wYWRfdG9rZW5faWQlMjAlM0QlMjBtb2RlbC5jb25maWcuZW9zX3Rva2VuX2lkJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkh1Z2dpbmclMjBGYWNlJTIwQ29tcGFueSUyMGlzJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwdGVtcGVyYXR1cmUlM0QxLjAlMkMlMjB0aGUlMjBkZWZhdWx0JTJDJTIwd2UlMjBjb25zaXN0ZW50bHklMjBnZXQlMjByYW5kb20lMjBvdXRwdXRzJTIwZHVlJTIwdG8lMjByYW5kb20lMjBzYW1wbGluZy4lMEFnZW5lcmF0ZV9rd2FyZ3MlMjAlM0QlMjAlN0IlMjJtYXhfbmV3X3Rva2VucyUyMiUzQSUyMDEwJTJDJTIwJTIyZG9fc2FtcGxlJTIyJTNBJTIwVHJ1ZSUyQyUyMCUyMnRlbXBlcmF0dXJlJTIyJTNBJTIwMS4wJTJDJTIwJTIybnVtX3JldHVybl9zZXF1ZW5jZXMlMjIlM0ElMjAyJTdEJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwKipnZW5lcmF0ZV9rd2FyZ3MpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKSUwQSUwQSUyMyUyMEhvd2V2ZXIlMkMlMjB3aXRoJTIwdGVtcGVyYXR1cmUlMjBjbG9zZSUyMHRvJTIwMCUyQyUyMGl0JTIwYXBwcm94aW1hdGVzJTIwZ3JlZWR5JTIwZGVjb2RpbmclMjBzdHJhdGVnaWVzJTIwKGludmFyaWFudCklMEFnZW5lcmF0ZV9rd2FyZ3MlNUIlMjJ0ZW1wZXJhdHVyZSUyMiU1RCUyMCUzRCUyMDAuMDAwMSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMCoqZ2VuZXJhdGVfa3dhcmdzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)  <span class="hljs-comment"># for reproducibility</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Hugging Face Company is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With temperature=1.0, the default, we consistently get random outputs due to random sampling.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_kwargs = {<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">10</span>, <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">1.0</span>, <span class="hljs-string">&quot;num_return_sequences&quot;</span>: <span class="hljs-number">2</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, **generate_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Hugging Face Company is one of these companies that is going to take a&#x27;</span>,
<span class="hljs-string">&quot;Hugging Face Company is a brand created by Brian A. O&#x27;Neil&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># However, with temperature close to 0, it approximates greedy decoding strategies (invariant)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_kwargs[<span class="hljs-string">&quot;temperature&quot;</span>] = <span class="hljs-number">0.0001</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, **generate_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Hugging Face Company is a company that has been around for over 20 years&#x27;</span>,
<span class="hljs-string">&#x27;Hugging Face Company is a company that has been around for over 20 years&#x27;</span>]`,wrap:!1}}),{c(){i=a("p"),i.textContent=k,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=k),b=o(r),m(_.$$.fragment,r)},m(r,$){d(r,i,$),d(r,b,$),g(_,r,$),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function Ow(j){let i,k="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwQSUyQyUyMEIlMkMlMjBDJTJDJTIwRCUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2l0aCUyMHNhbXBsaW5nJTJDJTIwdGhlJTIwb3V0cHV0JTIwaXMlMjB1bmV4cGVjdGVkJTIwLS0lMjBzb21ldGltZXMlMjB0b28lMjB1bmV4cGVjdGVkLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwJTYwdG9wX2slNjAlMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGdldHMlMjByZXN0cmljdGVkJTIwdGhlJTIwayUyMG1vc3QlMjBsaWtlbHklMjB0b2tlbnMuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwSW4lMjBwcmFjdGljZSUyQyUyMExMTXMlMjB1c2UlMjAlNjB0b3BfayU2MCUyMGluJTIwdGhlJTIwNS01MCUyMHJhbmdlLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjB0b3BfayUzRDIpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: A, B, C, D&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: A, B, C, D, E — S — O, P — R

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`top_k\` sampling, the output gets restricted the k most likely tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`top_k\` in the 5-50 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, top_k=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: A, B, C, D, E, F, G, H, I`,wrap:!1}}),{c(){i=a("p"),i.textContent=k,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=k),b=o(r),m(_.$$.fragment,r)},m(r,$){d(r,i,$),d(r,b,$),g(_,r,$),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function Kw(j){let i,k="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMCU2MHRvcF9wJTYwJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBnZXRzJTIwcmVzdHJpY3RlZCUyMHRvJTIwaGlnaC1wcm9iYWJpbGl0eSUyMHRva2Vucy4lMEElMjMlMjBQcm8lMjB0aXAlM0ElMjBJbiUyMHByYWN0aWNlJTJDJTIwTExNcyUyMHVzZSUyMCU2MHRvcF9wJTYwJTIwaW4lMjB0aGUlMjAwLjktMC45NSUyMHJhbmdlLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjB0b3BfcCUzRDAuMSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> | &lt; <span class="hljs-number">4</span> (left-hand pointer) ;
&lt;BLANKLINE&gt;
&lt;BLANKLINE&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`top_p\` sampling, the output gets restricted to high-probability tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`top_p\` in the 0.9-0.95 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=k,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=k),b=o(r),m(_.$$.fragment,r)},m(r,$){d(r,i,$),d(r,b,$),g(_,r,$),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function e$(j){let i,k="Examples:",b,_,w;return _=new J({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can see that greedy decoding produces a sequence of numbers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>, <span class="hljs-number">10</span>,

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For this particular seed, we can see that sampling produces nearly the same low-information (= low entropy)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sequence</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">18</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span> <span class="hljs-keyword">and</span> <span class="hljs-number">10</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`typical_p\` set, the most obvious sequence is no longer produced, which may be good for your problem</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">18</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs, do_sample=<span class="hljs-literal">True</span>, typical_p=<span class="hljs-number">0.1</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs.sequences, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> <span class="hljs-keyword">and</span> <span class="hljs-number">5</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can see that the token corresponding to &quot;4&quot; (token 934) in the second position, the most likely token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># as seen with greedy decoding, was entirely blocked out</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">934</span>])
tensor(-inf)`,wrap:!1}}),{c(){i=a("p"),i.textContent=k,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=k),b=o(r),m(_.$$.fragment,r)},m(r,$){d(r,i,$),d(r,b,$),g(_,r,$),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function t$(j){let i,k="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJUb2RheSUyQyUyMGElMjBkcmFnb24lMjBmbGV3JTIwb3ZlciUyMFBhcmlzJTJDJTIwRnJhbmNlJTJDJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDEuNSklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQlMEElMEElMjMlMjB3aXRoJTIwYSUyMG5lZ2F0aXZlJTIwcHJvbXB0JTBBbmVnX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJBJTIwdmVyeSUyMGhhcHB5JTIwZXZlbnQlMjBoYXBwZW5lZCUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QyJTJDJTIwbmVnYXRpdmVfcHJvbXB0X2lkcyUzRG5lZ19pbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwd2l0aCUyMGElMjBwb3NpdGl2ZSUyMHByb21wdCUwQW5lZ19pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyQSUyMHZlcnklMjBoYXBweSUyMGV2ZW50JTIwaGFwcGVuZWQlMkMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMCUyQyUyMG5lZ2F0aXZlX3Byb21wdF9pZHMlM0RuZWdfaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today, a dragon flew over Paris, France,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">1.5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Today, a dragon flew over Paris, France, killing at least 50 people and injuring more than 100&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a negative prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">2</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Today, a dragon flew over Paris, France, killing at least 130 people. French media reported that&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a positive prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">0</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Today, a dragon flew over Paris, France, and I&#x27;m very happy to be here. I&quot;</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=k,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=k),b=o(r),m(_.$$.fragment,r)},m(r,$){d(r,i,$),d(r,b,$),g(_,r,$),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function s$(j){let i,k="Examples:",b,_,w;return _=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMFdoaXNwZXJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBHZW5lcmF0aW9uQ29uZmlnJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIzJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRfZmVhdHVyZXMlMjAlM0QlMjBpbnB1dHMuaW5wdXRfZmVhdHVyZXMlMEElMEElMjNEaXNwbGF5aW5nJTIwdGltZXN0YW1wcyUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlM0RpbnB1dF9mZWF0dXJlcyUyQyUyMHJldHVybl90aW1lc3RhbXBzJTNEVHJ1ZSklMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwZGVjb2RlX3dpdGhfdGltZXN0YW1wcyUzRFRydWUpJTVCMCU1RCUwQXByaW50KCUyMlRyYW5zY3JpcHRpb24lM0ElMjIlMkMlMjB0cmFuc2NyaXB0aW9uKSUwQSUwQSUwQSUyM05vJTIwdGltZXN0YW1wcyUyMCUyNiUyMGNoYW5nZSUyMEVPUyUzQSUwQSUyM1RoaXMlMjBhbGxvd3MlMjB0aGUlMjB1c2VyJTIwdG8lMjBzZWxlY3QlMjBhJTIwc3BlY2lmaWMlMjB0b2tlbiUyMHRvJTIwdGVybWluYXRlJTIwdGhlJTIwc2VxdWVuY2UlMjBvbiUyQyUyMGluJTIwdGhpcyUyMGNhc2UlMjBpdCdzJTIwdGhlJTIwd29yZCUyMCUyMmNhbiUyMig0NjApJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcuZW9zX3Rva2VuX2lkJTIwJTNEJTIwNDYwJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyUzRGlucHV0X2ZlYXR1cmVzJTJDcmV0dXJuX3RpbWVzdGFtcHMlM0RGYWxzZSklMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQXByaW50KCUyMlRyYW5zY3JpcHRpb24lM0ElMjIlMkMlMjB0cmFuc2NyaXB0aW9uKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration, GenerationConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">3</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_features = inputs.input_features

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment">#Displaying timestamps</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(inputs=input_features, return_timestamps=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(generated_ids, decode_with_timestamps=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Transcription:&quot;</span>, transcription)
Transcription: &lt;|startoftranscript|&gt;&lt;|<span class="hljs-number">0.00</span>|&gt; He has grave doubts whether Sir Frederick Layton<span class="hljs-string">&#x27;s work is really Greek after all, and can&lt;|6.44|&gt;&lt;|6.44|&gt; discover in it but little of rocky Ithaca.&lt;|9.44|&gt;&lt;|endoftext|&gt;


&gt;&gt;&gt; #No timestamps &amp; change EOS:
&gt;&gt;&gt; #This allows the user to select a specific token to terminate the sequence on, in this case it&#x27;</span>s the word <span class="hljs-string">&quot;can&quot;</span>(<span class="hljs-number">460</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.eos_token_id = <span class="hljs-number">460</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(inputs=input_features,return_timestamps=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Transcription:&quot;</span>, transcription)
Transcription:  He has grave doubts whether Sir Frederick Layton<span class="hljs-string">&#x27;s work is really Greek after all and can</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=k,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=k),b=o(r),m(_.$$.fragment,r)},m(r,$){d(r,i,$),d(r,b,$),g(_,r,$),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function n$(j){let i,k;return i=new J({props:{code:"Y29tcGxldGVkJTIwJTNEJTIwRmFsc2UlMEF3aGlsZSUyMG5vdCUyMGNvbXBsZXRlZCUzQSUwQSUyMCUyMCUyMCUyMF8lMkMlMjBjb21wbGV0ZWQlMjAlM0QlMjBjb25zdHJhaW50LnVwZGF0ZShjb25zdHJhaW50LmFkdmFuY2UoKSk=",highlighted:`completed = <span class="hljs-literal">False</span>
<span class="hljs-keyword">while</span> <span class="hljs-keyword">not</span> completed:
    _, completed = constraint.update(constraint.advance())`,wrap:!1}}),{c(){p(i.$$.fragment)},l(b){m(i.$$.fragment,b)},m(b,_){g(i,b,_),k=!0},p:x,i(b){k||(u(i.$$.fragment,b),k=!0)},o(b){h(i.$$.fragment,b),k=!1},d(b){f(i,b)}}}function o$(j){let i,k="The API for the streamer classes is still under development and may change in the future.";return{c(){i=a("p"),i.textContent=k},l(b){i=l(b,"P",{"data-svelte-h":!0}),y(i)!=="svelte-gv2g1g"&&(i.textContent=k)},m(b,_){d(b,i,_)},p:x,d(b){b&&s(i)}}}function r$(j){let i,k="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRTdHJlYW1lciUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRvayglNUIlMjJBbiUyMGluY3JlYXNpbmclMjBzZXF1ZW5jZSUzQSUyMG9uZSUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBc3RyZWFtZXIlMjAlM0QlMjBUZXh0U3RyZWFtZXIodG9rKSUwQSUwQSUyMyUyMERlc3BpdGUlMjByZXR1cm5pbmclMjB0aGUlMjB1c3VhbCUyMG91dHB1dCUyQyUyMHRoZSUyMHN0cmVhbWVyJTIwd2lsbCUyMGFsc28lMjBwcmludCUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMjB0byUyMHN0ZG91dC4lMEFfJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBzdHJlYW1lciUzRHN0cmVhbWVyJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextStreamer

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Despite returning the usual output, the streamer will also print the generated text to stdout.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>_ = model.generate(**inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,`,wrap:!1}}),{c(){i=a("p"),i.textContent=k,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=k),b=o(r),m(_.$$.fragment,r)},m(r,$){d(r,i,$),d(r,b,$),g(_,r,$),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function a$(j){let i,k="The API for the streamer classes is still under development and may change in the future.";return{c(){i=a("p"),i.textContent=k},l(b){i=l(b,"P",{"data-svelte-h":!0}),y(i)!=="svelte-gv2g1g"&&(i.textContent=k)},m(b,_){d(b,i,_)},p:x,d(b){b&&s(i)}}}function l$(j){let i,k="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRJdGVyYXRvclN0cmVhbWVyJTBBZnJvbSUyMHRocmVhZGluZyUyMGltcG9ydCUyMFRocmVhZCUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRvayglNUIlMjJBbiUyMGluY3JlYXNpbmclMjBzZXF1ZW5jZSUzQSUyMG9uZSUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBc3RyZWFtZXIlMjAlM0QlMjBUZXh0SXRlcmF0b3JTdHJlYW1lcih0b2spJTBBJTBBJTIzJTIwUnVuJTIwdGhlJTIwZ2VuZXJhdGlvbiUyMGluJTIwYSUyMHNlcGFyYXRlJTIwdGhyZWFkJTJDJTIwc28lMjB0aGF0JTIwd2UlMjBjYW4lMjBmZXRjaCUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMjBpbiUyMGElMjBub24tYmxvY2tpbmclMjB3YXkuJTBBZ2VuZXJhdGlvbl9rd2FyZ3MlMjAlM0QlMjBkaWN0KGlucHV0cyUyQyUyMHN0cmVhbWVyJTNEc3RyZWFtZXIlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKSUwQXRocmVhZCUyMCUzRCUyMFRocmVhZCh0YXJnZXQlM0Rtb2RlbC5nZW5lcmF0ZSUyQyUyMGt3YXJncyUzRGdlbmVyYXRpb25fa3dhcmdzKSUwQXRocmVhZC5zdGFydCgpJTBBZ2VuZXJhdGVkX3RleHQlMjAlM0QlMjAlMjIlMjIlMEFmb3IlMjBuZXdfdGV4dCUyMGluJTIwc3RyZWFtZXIlM0ElMEElMjAlMjAlMjAlMjBnZW5lcmF0ZWRfdGV4dCUyMCUyQiUzRCUyMG5ld190ZXh0JTBBZ2VuZXJhdGVkX3RleHQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextIteratorStreamer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> threading <span class="hljs-keyword">import</span> Thread

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextIteratorStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run the generation in a separate thread, so that we can fetch the generated text in a non-blocking way.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_kwargs = <span class="hljs-built_in">dict</span>(inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread = Thread(target=model.generate, kwargs=generation_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread.start()
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = <span class="hljs-string">&quot;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> new_text <span class="hljs-keyword">in</span> streamer:
<span class="hljs-meta">... </span>    generated_text += new_text
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text
<span class="hljs-string">&#x27;An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,&#x27;</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=k,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=k),b=o(r),m(_.$$.fragment,r)},m(r,$){d(r,i,$),d(r,b,$),g(_,r,$),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function c$(j){let i,k,b,_,w,r,$,vT='This page lists all the utility functions used by <a href="/docs/transformers/v4.40.0/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>.',wm,yn,$m,Tn,MT=`The output of <a href="/docs/transformers/v4.40.0/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> is an instance of a subclass of
<a href="/docs/transformers/v4.40.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a>. This output is a data structure containing all the information returned
by <a href="/docs/transformers/v4.40.0/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>, but that can also be used as tuple or dictionary.`,km,vn,wT="Here’s an example:",jm,Mn,xm,wn,$T=`The <code>generation_output</code> object is a <a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.generation.GenerateDecoderOnlyOutput">GenerateDecoderOnlyOutput</a>, as we can
see in the documentation of that class below, it means it has the following attributes:`,Jm,$n,kT="<li><code>sequences</code>: the generated sequences of tokens</li> <li><code>scores</code> (optional): the prediction scores of the language modelling head, for each generation step</li> <li><code>hidden_states</code> (optional): the hidden states of the model, for each generation step</li> <li><code>attentions</code> (optional): the attention weights of the model, for each generation step</li>",Um,kn,jT=`Here we have the <code>scores</code> since we passed along <code>output_scores=True</code>, but we don’t have <code>hidden_states</code> and
<code>attentions</code> because we didn’t pass <code>output_hidden_states=True</code> or <code>output_attentions=True</code>.`,Bm,jn,xT=`You can access each attribute as you would usually do, and if that attribute has not been returned by the model, you
will get <code>None</code>. Here for instance <code>generation_output.scores</code> are all the generated prediction scores of the
language modeling head, and <code>generation_output.attentions</code> is <code>None</code>.`,Im,xn,JT=`When using our <code>generation_output</code> object as a tuple, it only keeps the attributes that don’t have <code>None</code> values.
Here, for instance, it has two elements, <code>loss</code> then <code>logits</code>, so`,Zm,Jn,zm,Un,UT="will return the tuple <code>(generation_output.sequences, generation_output.scores)</code> for instance.",Wm,Bn,BT=`When using our <code>generation_output</code> object as a dictionary, it only keeps the attributes that don’t have <code>None</code>
values. Here, for instance, it has two keys that are <code>sequences</code> and <code>scores</code>.`,Lm,In,IT="We document here all output types.",Cm,Zn,Vm,kt,zn,gh,Fl,ZT="Outputs of decoder-only generation models, when using non-beam methods.",Fm,jt,Wn,uh,Gl,zT="Outputs of encoder-decoder generation models, when using non-beam methods.",Gm,xt,Ln,hh,Xl,WT="Outputs of decoder-only generation models, when using beam methods.",Xm,Jt,Cn,fh,Rl,LT="Outputs of encoder-decoder generation models, when using beam methods.",Rm,Vn,Sm,Ut,Fn,_h,Sl,CT=`Base class for outputs of encoder-decoder generation models using greedy search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,Nm,Bt,Gn,bh,Nl,VT="Base class for outputs of decoder-only generation models using greedy search.",Em,It,Xn,yh,El,FT=`Base class for outputs of encoder-decoder generation models using sampling. Hidden states and attention weights of
the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,Hm,Zt,Rn,Th,Hl,GT="Base class for outputs of decoder-only generation models using sampling.",qm,zt,Sn,vh,ql,XT=`Base class for outputs of encoder-decoder generation models using beam search. Hidden states and attention weights
of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,Dm,Wt,Nn,Mh,Dl,RT="Base class for outputs of decoder-only generation models using beam search.",Pm,Lt,En,wh,Pl,ST=`Base class for outputs of encoder-decoder generation models using beam sampling. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,Qm,Ct,Hn,$h,Ql,NT="Base class for outputs of decoder-only generation models using beam sample.",Ym,Vt,qn,kh,Yl,ET=`Base class for outputs of encoder-decoder generation models using contrastive search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,Am,Ft,Dn,jh,Al,HT="Base class for outputs of decoder-only generation models using contrastive search.",Om,Pn,Km,je,Qn,xh,Ol,qT="Flax Base class for outputs of decoder-only generation models using sampling.",Jh,Ht,Yn,Uh,Kl,DT="“Returns a new object replacing the specified fields with new values.",eg,xe,An,Bh,ec,PT="Flax Base class for outputs of decoder-only generation models using greedy search.",Ih,qt,On,Zh,tc,QT="“Returns a new object replacing the specified fields with new values.",tg,Je,Kn,zh,sc,YT="Flax Base class for outputs of decoder-only generation models using greedy search.",Wh,Dt,eo,Lh,nc,AT="“Returns a new object replacing the specified fields with new values.",sg,to,ng,so,OT=`A <a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> can be used to modify the prediction scores of a language model head for
generation.`,og,no,rg,ee,oo,Ch,oc,KT='<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing alternated generation between the two codebooks of Bark.',Vh,Pt,Fh,rc,ro,ag,W,ao,Gh,ac,ev=`<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for classifier free guidance (CFG). The scores are split over the batch dimension,
where the first half correspond to the conditional logits (predicted from the input prompt) and the second half
correspond to the unconditional logits (predicted from an empty or ‘null’ prompt). The processor computes a
weighted average across the conditional and unconditional logits, parameterised by the <code>guidance_scale</code>.`,Xh,lc,tv='See <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">the paper</a> for more information.',Rh,Qt,Sh,Yt,Nh,cc,lo,lg,X,co,Eh,ic,sv=`<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that works similarly to <a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.NoRepeatNGramLogitsProcessor">NoRepeatNGramLogitsProcessor</a>, but applied exclusively to prevent
the repetition of n-grams present in the prompt.`,Hh,dc,nv=`It was designed to promote chattiness in a language model, by preventing the generation of n-grams present in
previous conversation rounds.`,qh,At,Dh,pc,io,cg,R,po,Ph,mc,ov=`<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that works similarly to <a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.RepetitionPenaltyLogitsProcessor">RepetitionPenaltyLogitsProcessor</a>, but with an <em>inverse</em> penalty
that is applied to the tokens present in the prompt. In other words, a penalty above 1.0 increases the odds of
selecting tokens that were present in the prompt.`,Qh,gc,rv=`It was designed to avoid hallucination in input-grounded tasks, like summarization. Although originally intended
for encoder-decoder models, it can also be used with decoder-only models like LLMs.`,Yh,Ot,Ah,uc,mo,ig,te,go,Oh,hc,av=`<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs epsilon-sampling, i.e. restricting to tokens with <code>prob &gt;= epsilon</code>. Takes the
largest min_tokens_to_keep tokens if no tokens satisfy this constraint. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more information.`,Kh,Kt,ef,fc,uo,dg,se,ho,tf,_c,lv=`<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs eta-sampling, a technique to filter out tokens with probabilities below a dynamic
cutoff value, <code>eta</code>, which is calculated based on a combination of the hyperparameter <code>epsilon</code> and the entropy of
the token probabilities, i.e. <code>eta := min(epsilon, sqrt(epsilon * e^-entropy(probabilities)))</code>. Takes the largest
min_tokens_to_keep tokens if no tokens satisfy this constraint. It addresses the issue of poor quality in long
samples of text generated by neural language models leading to more coherent and fluent text. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation
Sampling as Language Model Desmoothing</a> for more information. Note: <code>do_sample</code>
must be set to <code>True</code> for this <code>LogitsWarper</code> to work.`,sf,es,nf,bc,fo,pg,ne,_o,of,yc,cv=`<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that exponentially increases the score of the <code>eos_token_id</code> after <code>start_index</code> has been
reached. This allows generating shorter sequences without having a hard cutoff, allowing the <code>eos_token</code> to be
predicted in a meaningful position.`,rf,ts,af,Tc,bo,mg,oe,yo,lf,vc,iv=`<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces the specified token as the first generated token. Used with encoder-decoder
models.`,cf,ss,df,Mc,To,gg,re,vo,pf,wc,dv='<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',mf,ns,gf,$c,Mo,ug,Ue,wo,uf,kc,pv=`This processor takes a list of pairs of integers which indicates a mapping from generation indices to token
indices that will be forced before generation. The processor will set their log probs to <code>inf</code> so that they are
sampled at their corresponding index. Originally created for
<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.`,hf,jc,$o,hg,L,ko,ff,xc,mv='<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces diverse beam search.',_f,Jc,gv=`Note that this logits processor is only effective for <code>PreTrainedModel.group_beam_search()</code>. See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">Diverse Beam
Search: Decoding Diverse Solutions from Neural Sequence Models</a> for more
details.`,bf,Uc,uv=`Traditional beam search often generates very similar sequences across different beams.
<code>HammingDiversityLogitsProcessor</code> addresses this by penalizing beams that generate tokens already chosen by other
beams in the same time step.`,yf,os,Tf,Bc,jo,fg,ae,xo,vf,Ic,hv=`<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that removes all <code>nan</code> and <code>inf</code> values to avoid the generation method to fail. Note that using
the logits processor should only be used if necessary since it can slow down the generation method.`,Mf,Zc,fv=`This logits processor has no <code>generate</code> example, as there shouldn’t be a correct combination of flags that warrants
its use.`,wf,zc,Jo,_g,le,Uo,$f,Wc,_v=`<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> and <a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for normalizing the scores using log-softmax. It’s important to normalize
the scores during beam search, after applying the logits processors or warpers, since the search algorithm used in
this library doesn’t do it (it only does it before, but they may need re-normalization) but it still supposes that
the scores are normalized when comparing the hypotheses.`,kf,rs,jf,Lc,Bo,bg,Be,Io,xf,Cc,bv="Abstract base class for all logit processors that can be applied during generation.",Jf,Vc,Zo,yg,Ie,zo,Uf,Fc,yv=`This class can be used to create a list of <a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> or <a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> to subsequently process a
<code>scores</code> input tensor. This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each
<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> or <a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> to the inputs.`,Bf,Gc,Wo,Tg,Ze,Lo,If,Xc,Tv="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",Zf,Rc,Co,vg,ce,Vo,zf,Sc,vv=`<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing a min-length by setting EOS probability to 0. Note that, for decoder-only models
like most LLMs, the length includes the prompt.`,Wf,as,Lf,Nc,Fo,Mg,ie,Go,Cf,Ec,Mv=`<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing a min-length of new tokens by setting EOS (End-Of-Sequence) token probability to 0.
Contrarily to <a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.MinLengthLogitsProcessor">MinLengthLogitsProcessor</a>, this processor ignores the prompt.`,Vf,ls,Ff,Hc,Xo,wg,S,Ro,Gf,qc,wv='<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces that specified sequences will never be selected.',Xf,cs,Rf,is,Sf,Dc,So,$g,N,No,Nf,Pc,$v=`N-grams are groups of “n” consecutive words, characters, or tokens taken from a sequence of text. Given the
sentence: “She runs fast”, the bi-grams (n=2) would be (“she”, “runs”) and (“runs”, “fast”). In text generation,
avoiding repetitions of word sequences provides a more diverse output. This <a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforces no
repetition of n-grams by setting the scores of banned tokens to negative infinity which eliminates those tokens
from consideration when further processing the scores. Note that, for decoder-only models like most LLMs, the
prompt is also considered to obtain the n-grams.
<a href="https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345" rel="nofollow">Fairseq</a>.`,Ef,ds,Hf,ps,qf,Qc,Eo,kg,de,Ho,Df,Yc,kv=`<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces constrained generation and is useful for prefix-conditioned constrained
generation. See <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity Retrieval</a> for more information.`,Pf,ms,Qf,Ac,qo,jg,E,Do,Yf,Oc,jv=`<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that prevents the repetition of previous tokens through a penalty. This penalty is applied at
most once per token. Note that, for decoder-only models like most LLMs, the considered tokens include the prompt.`,Af,Kc,xv=`In the original <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">paper</a>, the authors suggest the use of a penalty of around
1.2 to achieve a good balance between truthful generation and lack of repetition. To penalize and reduce
repetition, use <code>penalty</code> values above 1.0, where a higher value penalizes more strongly. To reward and encourage
repetition, use <code>penalty</code> values between 0.0 and 1.0, where a lower value rewards more strongly.`,Of,gs,Kf,ei,Po,xg,H,Qo,e_,ti,Jv=`<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that applies an additive bias on sequences. The bias is applied to the last token of a sequence
when the next generated token can complete it. Consequently, to take the most of biasing sequences with more than
one token, consider using beam methods (to gracefully work around partially completed sequences that have a
negative bias) and applying the bias to their prefixes (to ensure the bias is applied earlier).`,t_,us,s_,hs,n_,si,Yo,Jg,pe,Ao,o_,ni,Uv=`<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.SuppressTokensAtBeginLogitsProcessor">SuppressTokensAtBeginLogitsProcessor</a> supresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> are
not generated at the begining. Originally created for
<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.`,r_,fs,a_,oi,Oo,Ug,me,Ko,l_,ri,Bv=`This processor can be used to suppress a list of tokens. The processor will set their log probs to <code>-inf</code> so
that they are not generated. Originally created for
<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.`,c_,_s,i_,ai,er,Bg,q,tr,d_,li,Iv=`<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> for temperature (exponential scaling output probability distribution), which effectively means
that it can control the randomness of the predicted tokens. Often used together with <a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.TopPLogitsWarper">TopPLogitsWarper</a> and
<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.TopKLogitsWarper">TopKLogitsWarper</a>.`,p_,bs,m_,ys,g_,ci,sr,Ig,ge,nr,u_,ii,Zv=`<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements. Often used together
with <a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.TemperatureLogitsWarper">TemperatureLogitsWarper</a> and <a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.TopPLogitsWarper">TopPLogitsWarper</a>.`,h_,Ts,f_,di,or,Zg,ue,rr,__,pi,zv=`<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to prob_cut_off &lt;= prob_cut_off. Often
used together with <a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.TemperatureLogitsWarper">TemperatureLogitsWarper</a> and <a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.TopKLogitsWarper">TopKLogitsWarper</a>.`,b_,vs,y_,mi,ar,zg,D,lr,T_,gi,Wv=`<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs typical decoding. Inspired on how humans use language, it prioritizes tokens whose
log probability is close to the entropy of the token probability distribution. This means that the most likely
tokens may be discarded in the process.`,v_,ui,Lv='See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language Generation</a> for more information.',M_,Ms,w_,hi,cr,Wg,P,ir,$_,fi,Cv=`Logits processor for Classifier-Free Guidance (CFG). The processors computes a weighted average across scores
from prompt conditional and prompt unconditional (or negative) logits, parameterized by the <code>guidance_scale</code>.
The unconditional scores are computed internally by prompting <code>model</code> with the <code>unconditional_ids</code> branch.`,k_,_i,Vv='See <a href="https://arxiv.org/abs/2306.17806" rel="nofollow">the paper</a> for more information.',j_,ws,x_,bi,dr,Lg,Q,pr,J_,yi,Fv=`<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that modifies the logits for the generation of timestamps in the transcription. When the input
tokens are at a specific threshold, the processor sets the scores to negative infinity. The processor makes sure
that timestamp tokens appear in pairs, by masking out the logits that would break this pairing pattern. This is
done to maintain the consistency and structure of generated timestamps. It also ensures that when the predicted
probability of sampling any of the timestamp token is greater than any individual non-timestamp token, those
non-timestamp logits are set to negative infinity. This is done to ensure the generation of timestamps over other
potential tokens.`,U_,Ti,Gv='See <a href="https://arxiv.org/abs/2212.04356" rel="nofollow">the paper</a> for more information.',B_,$s,I_,vi,mr,Cg,gr,Vg,ze,ur,Z_,Mi,Xv='<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces the specified token as the first generated token.',z_,wi,hr,Fg,We,fr,W_,$i,Rv='<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',L_,ki,_r,Gg,Le,br,C_,ji,Sv=`This processor takes a list of pairs of integers which indicates a mapping from generation indices to token
indices that will be forced before sampling. The processor will set their log probs to <code>0</code> and all other tokens to
<code>-inf</code> so that they are sampled at their corresponding index.`,V_,xi,yr,Xg,Ce,Tr,F_,Ji,Nv="Abstract base class for all logit processors that can be applied during generation.",G_,ks,vr,X_,Ui,Ev="TF method for processing logits.",Rg,Ve,Mr,R_,Bi,Hv=`This class can be used to create a list of <a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> to subsequently process a <code>scores</code> input tensor.
This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each <a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> to the
inputs.`,S_,Ii,wr,Sg,Fe,$r,N_,Zi,qv="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",E_,js,kr,H_,zi,Dv="TF method for warping logits.",Ng,Ge,jr,q_,Wi,Pv='<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',D_,Li,xr,Eg,Xe,Jr,P_,Ci,Qv='<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces that specified sequences will never be sampled.',Q_,Vi,Ur,Hg,Re,Br,Y_,Fi,Yv=`<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces no repetition of n-grams. See
<a href="https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345" rel="nofollow">Fairseq</a>.`,A_,Gi,Ir,qg,Se,Zr,O_,Xi,Av='<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> enforcing an exponential penalty on repeated sequences.',K_,Ri,zr,Dg,Ne,Wr,eb,Si,Ov=`<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.TFSuppressTokensAtBeginLogitsProcessor">TFSuppressTokensAtBeginLogitsProcessor</a> suppresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> at not
sampled at the begining of the generation.`,tb,Ni,Lr,Pg,Ee,Cr,sb,Ei,Kv=`This processor can be used to suppress a list of tokens. The processor will set their log probs to <code>-inf</code> so that they
are not sampled.`,nb,Hi,Vr,Qg,He,Fr,ob,qi,eM='<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> for temperature (exponential scaling output probability distribution).',rb,Di,Gr,Yg,qe,Xr,ab,Pi,tM='<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',lb,Qi,Rr,Ag,De,Sr,cb,Yi,sM='<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to &lt;= prob_cut_off.',ib,Ai,Nr,Og,Er,Kg,Pe,Hr,db,Oi,nM='<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that enforces the specified token as the first generated token.',pb,Ki,qr,eu,Qe,Dr,mb,ed,oM='<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',gb,td,Pr,tu,Ye,Qr,ub,sd,rM=`<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that takes a list of pairs of integers which indicates a mapping from generation indices to
token indices that will be forced before sampling. The processor will set their log probs to 0 and all other tokens
to <code>-inf</code> so that they are sampled at their corresponding index.`,hb,nd,Yr,su,Ae,Ar,fb,od,aM="Abstract base class for all logit processors that can be applied during generation.",_b,xs,Or,bb,rd,lM="Flax method for processing logits.",nu,Oe,Kr,yb,ad,cM=`This class can be used to create a list of <a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> or <a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> to subsequently process
a <code>scores</code> input tensor. This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each
<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> or <a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> to the inputs.`,Tb,ld,ea,ou,Ke,ta,vb,cd,iM="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",Mb,Js,sa,wb,id,dM="Flax method for warping logits.",ru,et,na,$b,dd,pM='<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',kb,pd,oa,au,tt,ra,jb,md,mM=`<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> supressing a list of tokens as soon as the <code>generate</code> function starts generating using
<code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> are not sampled at the
begining of the generation.`,xb,gd,aa,lu,st,la,Jb,ud,gM=`<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> suppressing a list of tokens at each decoding step. The processor will set their log probs
to be <code>-inf</code> so they are not sampled.`,Ub,hd,ca,cu,nt,ia,Bb,fd,uM='<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> for temperature (exponential scaling output probability distribution).',Ib,_d,da,iu,ot,pa,Zb,bd,hM='<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',zb,yd,ma,du,rt,ga,Wb,Td,fM='<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to prob_cut_off &lt;= prob_cut_off.',Lb,vd,ua,pu,at,ha,Cb,Md,_M=`Whisper specific Processor. This processor can be used to force a list of tokens. The processor will set their log
probs to <code>inf</code> so that they are sampled at their corresponding index.`,Vb,wd,fa,mu,_a,gu,ba,bM='A <a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a> can be used to change when to stop generation (other than EOS token). Please note that this is exclusively available to our PyTorch implementations.',uu,he,ya,Fb,$d,yM="Abstract base class for all stopping criteria that can be applied during generation.",Gb,kd,TM="If your stopping criteria depends on the <code>scores</code> input, make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.",Xb,jd,Ta,hu,Gt,va,Rb,xd,Ma,fu,lt,wa,Sb,Jd,vM=`This class can be used to stop generation whenever the full generated number of tokens exceeds <code>max_length</code>. Keep
in mind for decoder-only type of transformers, this will include the initial prompted tokens.`,Nb,Ud,$a,_u,ct,ka,Eb,Bd,MM=`This class can be used to stop generation whenever the full generation exceeds some amount of time. By default, the
time will start being counted when you initialize this function. You can override this by passing an
<code>initial_time</code>.`,Hb,Id,ja,bu,xa,yu,Ja,wM='A <a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.Constraint">Constraint</a> can be used to force the generation to include specific tokens or sequences in the output. Please note that this is exclusively available to our PyTorch implementations.',Tu,U,Ua,qb,Zd,$M=`Abstract base class for all constraints that can be applied during generation.
It must define how the constraint can be satisfied.`,Db,zd,kM="All classes that inherit Constraint must follow the requirement that",Pb,Us,Qb,Wd,jM="will always terminate (halt).",Yb,Bs,Ba,Ab,Ld,xM="When called, returns the token that would take this constraint one step closer to being fulfilled.",Ob,Is,Ia,Kb,Cd,JM="Creates a new instance of this constraint.",ey,Zs,Za,ty,Vd,UM="Reads in a token and returns whether it creates progress.",sy,zs,za,ny,Fd,BM="Returns the number of remaining steps of <code>advance()</code> in order to complete this constraint.",oy,Ws,Wa,ry,Gd,IM=`Resets the state of this constraint to its initialization. We would call this in cases where the fulfillment of
a constraint is abrupted by an unwanted token.`,ay,Ls,La,ly,Xd,ZM="Tests whether this constraint has been properly defined.",cy,ht,Ca,iy,Rd,zM=`Reads in a token and returns booleans that indicate the progress made by it. This function will update the
state of this object unlikes <code>does_advance(self, token_id: int)</code>.`,dy,Sd,WM=`This isn’t to test whether a certain token will advance the progress; it’s to update its state as if it has
been generated. This becomes important if token_id != desired token (refer to else statement in
PhrasalConstraint)`,vu,Xt,Va,py,Nd,LM='<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.Constraint">Constraint</a> enforcing that an ordered sequence of tokens is included in the output.',Mu,Rt,Fa,my,Ed,CM='A special <a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.Constraint">Constraint</a> that is fulfilled by fulfilling just one of several constraints.',wu,fe,Ga,gy,Hd,VM="A class for beam scorers to track its progress through a list of constraints.",uy,F,Xa,hy,qd,FM=`The list of tokens to generate such that we can make progress.
By “list” we don’t mean the list of token that will fully fulfill a constraint.`,fy,Dd,GM=`Given constraints <code>c_i = {t_ij | j == # of tokens}</code>, If we’re not in the middle of progressing through a
specific constraint <code>c_i</code>, we return:`,_y,Pd,XM="<code>[t_k1 for k in indices of unfulfilled constraints]</code>",by,Qd,RM=`If we are in the middle of a constraint, then we return:
<code>[t_ij]</code>, where <code>i</code> is the index of the inprogress constraint, <code>j</code> is the next step for the constraint.`,yy,Yd,SM=`Though we don’t care which constraint is fulfilled first, if we are in the progress of fulfilling a constraint,
that’s the only one we’ll return.`,Ty,Cs,Ra,vy,Ad,NM="token_ids: the tokens generated thus far to reset the state of the progress through constraints.",$u,Sa,ku,_e,Na,My,Od,EM=`Abstract base class for all beam scorers that are used for <code>beam_search()</code> and
<code>beam_sample()</code>.`,wy,Kd,Ea,$y,ep,Ha,ju,C,qa,ky,tp,HM='<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> implementing standard beam search decoding.',jy,sp,qM=`Adapted in part from <a href="https://github.com/facebookresearch/XLM/blob/9e6f6814d17be4fe5b15f2e6c43eb2b2d76daeb4/src/model/transformer.py#L529" rel="nofollow">Facebook’s XLM beam search
code</a>.`,xy,np,DM=`Reference for the diverse beam search algorithm and implementation <a href="https://github.com/ashwinkalyan/dbs/blob/master/dbs/beam_utils.lua" rel="nofollow">Ashwin Kalyan’s DBS
implementation</a>`,Jy,op,Da,Uy,rp,Pa,xu,be,Qa,By,ap,PM='<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> implementing constrained beam search decoding.',Iy,lp,Ya,Zy,cp,Aa,Ju,Oa,Uu,z,Ka,zy,ip,QM="Simple text streamer that prints the token(s) to stdout as soon as entire words are formed.",Wy,Vs,Ly,Fs,Cy,Gs,el,Vy,dp,YM="Flushes any remaining cache and prints a newline to stdout.",Fy,Xs,tl,Gy,pp,AM="Prints the new text to stdout. If the stream is ending, also prints a newline.",Xy,Rs,sl,Ry,mp,OM="Receives tokens, decodes them, and prints them to stdout as soon as they form entire words.",Bu,Y,nl,Sy,gp,KM=`Streamer that stores print-ready text in a queue, to be used by a downstream application as an iterator. This is
useful for applications that benefit from acessing the generated text in a non-blocking way (e.g. in an interactive
Gradio demo).`,Ny,Ss,Ey,Ns,Hy,Es,ol,qy,up,e0="Put the new text in the queue. If the stream is ending, also put a stop signal in the queue.",Iu,rl,Zu,it,al,Dy,hp,t0="Base, abstract class for all caches. The actual data structure is specific to each subclass.",Py,Hs,ll,Qy,fp,s0="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",zu,Z,cl,Yy,_p,n0="A cache that grows dynamically as more tokens are generated. This is the default for generative models.",Ay,bp,o0=`It stores the Key and Value states as a list of tensors, one for each layer. The expected shape for each tensor is
<code>[batch_size, num_heads, seq_len, head_dim]</code>.`,Oy,qs,il,Ky,yp,r0="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",eT,Ds,dl,tT,Tp,a0="Returns the sequence length of the cached states. A layer index can be optionally passed.",sT,Ps,pl,nT,vp,l0="Reorders the cache for beam search, given the selected beam indices.",oT,Qs,ml,rT,Mp,c0="Converts the <code>DynamicCache</code> instance into the its equivalent in the legacy cache format.",aT,Ys,gl,lT,wp,i0="Converts a cache in the legacy cache format into an equivalent <code>DynamicCache</code>.",Wu,V,ul,cT,$p,d0=`A cache that as described in the <a href="https://arxiv.org/abs/2309.17453" rel="nofollow">Attention Sinks paper</a>. It allows the model to
generate beyond the length of its context window, without losing fluency in the conversation. As it discards past
tokens, the model will lose the ability to generate tokens that depend on the context that was discarded.`,iT,kp,p0=`It stores the Key and Value states as a list of tensors, one for each layer. The expected shape for each tensor is
<code>[batch_size, num_heads, seq_len, head_dim]</code>.`,dT,As,hl,pT,jp,m0="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",mT,Os,fl,gT,xp,g0="Returns the sequence length of the cached states. A layer index can be optionally passed.",uT,Ks,_l,hT,Jp,u0="Reorders the cache for beam search, given the selected beam indices.",Lu,ye,bl,fT,Up,h0="Static Cache class to be used with <code>torch.compile(model)</code>.",_T,en,yl,bT,Bp,f0=`Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.
It is VERY important to index using a tensor, otherwise you introduce a copy to the device.`,yT,tn,Tl,TT,Ip,_0="Returns the sequence length of the cached states that were seen by the model. <code>layer_idx</code> kept for BC",Cu,um,Vu;return w=new K({props:{title:"Utilities for Generation",local:"utilities-for-generation",headingTag:"h1"}}),yn=new K({props:{title:"Generate Outputs",local:"generate-outputs",headingTag:"h2"}}),Mn=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJUb2tlbml6ZXIlMkMlMjBHUFQyTE1IZWFkTW9kZWwlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBHUFQyVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktY29tbXVuaXR5JTJGZ3B0MiUyMiklMEFtb2RlbCUyMCUzRCUyMEdQVDJMTUhlYWRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjBhbmQlMjAlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbmVyYXRpb25fb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZXR1cm5fZGljdF9pbl9nZW5lcmF0ZSUzRFRydWUlMkMlMjBvdXRwdXRfc2NvcmVzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, GPT2LMHeadModel

tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
model = GPT2LMHeadModel.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute and &quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
generation_output = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)`,wrap:!1}}),Jn=new J({props:{code:"Z2VuZXJhdGlvbl9vdXRwdXQlNUIlM0EyJTVE",highlighted:'generation_output[:<span class="hljs-number">2</span>]',wrap:!1}}),Zn=new K({props:{title:"PyTorch",local:"transformers.generation.GenerateDecoderOnlyOutput",headingTag:"h3"}}),zn=new M({props:{name:"class transformers.generation.GenerateDecoderOnlyOutput",anchor:"transformers.generation.GenerateDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": Optional = None"},{name:"logits",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code> is passed or when <code>config.output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
NOTE: some models have a different <code>past_key_values</code> format, confirm with the model&#x2019;s documentation.
Usually a Tuple (one element for each layer of the decoder) of tuples (two elements, key tensor and value
tensor). The first Tuple is of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/utils.py#L101"}}),Wn=new M({props:{name:"class transformers.generation.GenerateEncoderDecoderOutput",anchor:"transformers.generation.GenerateEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": Optional = None"},{name:"logits",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code> is passed or when <code>config.output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
NOTE: some models have a different <code>past_key_values</code> format, confirm with the model&#x2019;s documentation.
Usually a Tuple (one element for each layer of the decoder) of tuples (two elements, key tensor and value
tensor). The first Tuple is of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/utils.py#L141"}}),Ln=new M({props:{name:"class transformers.generation.GenerateBeamDecoderOnlyOutput",anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"logits",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code> is passed or when <code>config.output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
NOTE: some models have a different <code>past_key_values</code> format, confirm with the model&#x2019;s documentation.
Usually a Tuple (one element for each layer of the decoder) of tuples (two elements, key tensor and value
tensor). The first Tuple is of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/utils.py#L193"}}),Cn=new M({props:{name:"class transformers.generation.GenerateBeamEncoderDecoderOutput",anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"logits",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code> is passed or when <code>config.output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
NOTE: some models have a different <code>past_key_values</code> format, confirm with the model&#x2019;s documentation.
Usually a Tuple (one element for each layer of the decoder) of tuples (two elements, key tensor and value
tensor). The first Tuple is of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/utils.py#L241"}}),Vn=new K({props:{title:"TensorFlow",local:"transformers.generation.TFGreedySearchEncoderDecoderOutput",headingTag:"h3"}}),Fn=new M({props:{name:"class transformers.generation.TFGreedySearchEncoderDecoderOutput",anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_utils.py#L85"}}),Gn=new M({props:{name:"class transformers.generation.TFGreedySearchDecoderOnlyOutput",anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_utils.py#L57"}}),Xn=new M({props:{name:"class transformers.generation.TFSampleEncoderDecoderOutput",anchor:"transformers.generation.TFSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size*num_return_sequences, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_utils.py#L155"}}),Rn=new M({props:{name:"class transformers.generation.TFSampleDecoderOnlyOutput",anchor:"transformers.generation.TFSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_utils.py#L127"}}),Sn=new M({props:{name:"class transformers.generation.TFBeamSearchEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. <code>Tuple of </code>tf.Tensor<code>with up to</code>max_new_tokens<code>elements (one element for each generated token), with each tensor of shape</code>(batch_size*num_beams, config.vocab_size)\`.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_utils.py#L232"}}),Nn=new M({props:{name:"class transformers.generation.TFBeamSearchDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_utils.py#L197"}}),En=new M({props:{name:"class transformers.generation.TFBeamSampleEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_utils.py#L317"}}),Hn=new M({props:{name:"class transformers.generation.TFBeamSampleDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_utils.py#L282"}}),qn=new M({props:{name:"class transformers.generation.TFContrastiveSearchEncoderDecoderOutput",anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_utils.py#L393"}}),Dn=new M({props:{name:"class transformers.generation.TFContrastiveSearchDecoderOnlyOutput",anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_utils.py#L366"}}),Pn=new K({props:{title:"FLAX",local:"transformers.generation.FlaxSampleOutput",headingTag:"h3"}}),Qn=new M({props:{name:"class transformers.generation.FlaxSampleOutput",anchor:"transformers.generation.FlaxSampleOutput",parameters:[{name:"sequences",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxSampleOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/flax_utils.py#L69"}}),Yn=new M({props:{name:"replace",anchor:"transformers.generation.FlaxSampleOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/flax/struct.py#L111"}}),An=new M({props:{name:"class transformers.generation.FlaxGreedySearchOutput",anchor:"transformers.generation.FlaxGreedySearchOutput",parameters:[{name:"sequences",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxGreedySearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/flax_utils.py#L55"}}),On=new M({props:{name:"replace",anchor:"transformers.generation.FlaxGreedySearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/flax/struct.py#L111"}}),Kn=new M({props:{name:"class transformers.generation.FlaxBeamSearchOutput",anchor:"transformers.generation.FlaxBeamSearchOutput",parameters:[{name:"sequences",val:": Array = None"},{name:"scores",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxBeamSearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"},{anchor:"transformers.generation.FlaxBeamSearchOutput.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size,)</code>) &#x2014;
The scores (log probabilities) of the generated sequences.`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/flax_utils.py#L83"}}),eo=new M({props:{name:"replace",anchor:"transformers.generation.FlaxBeamSearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/flax/struct.py#L111"}}),to=new K({props:{title:"LogitsProcessor",local:"logitsprocessor",headingTag:"h2"}}),no=new K({props:{title:"PyTorch",local:"transformers.AlternatingCodebooksLogitsProcessor",headingTag:"h3"}}),oo=new M({props:{name:"class transformers.AlternatingCodebooksLogitsProcessor",anchor:"transformers.AlternatingCodebooksLogitsProcessor",parameters:[{name:"input_start_len",val:": int"},{name:"semantic_vocab_size",val:": int"},{name:"codebook_size",val:": int"}],parametersDescription:[{anchor:"transformers.AlternatingCodebooksLogitsProcessor.input_start_len",description:`<strong>input_start_len</strong> (<code>int</code>) &#x2014;
The length of the initial input sequence.`,name:"input_start_len"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.semantic_vocab_size",description:`<strong>semantic_vocab_size</strong> (<code>int</code>) &#x2014;
Vocabulary size of the semantic part, i.e number of tokens associated to the semantic vocabulary.`,name:"semantic_vocab_size"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.codebook_size",description:`<strong>codebook_size</strong> (<code>int</code>) &#x2014;
Number of tokens associated to the codebook.`,name:"codebook_size"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L2020"}}),Pt=new bn({props:{warning:!0,$$slots:{default:[jw]},$$scope:{ctx:j}}}),ro=new M({props:{name:"__call__",anchor:"transformers.AlternatingCodebooksLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L2049"}}),ao=new M({props:{name:"class transformers.ClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:""}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (float) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale &gt; 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality.`,name:"guidance_scale"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L1956"}}),Qt=new bn({props:{warning:!0,$$slots:{default:[xw]},$$scope:{ctx:j}}}),Yt=new B({props:{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.example",$$slots:{default:[Jw]},$$scope:{ctx:j}}}),lo=new M({props:{name:"__call__",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L2004",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),co=new M({props:{name:"class transformers.EncoderNoRepeatNGramLogitsProcessor",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor",parameters:[{name:"encoder_ngram_size",val:": int"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_ngram_size",description:`<strong>encoder_ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur within the encoder input ids.`,name:"encoder_ngram_size"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>int</code>) &#x2014;
The encoder_input_ids that should not be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L887"}}),At=new B({props:{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.example",$$slots:{default:[Uw]},$$scope:{ctx:j}}}),io=new M({props:{name:"__call__",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L936",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),po=new M({props:{name:"class transformers.EncoderRepetitionPenaltyLogitsProcessor",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.penalty",description:`<strong>penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. Above 1.0 rewards prompt tokens. Between 0.0
and 1.0 penalizes prompt tokens.`,name:"penalty"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
The encoder_input_ids that should be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L348"}}),Ot=new B({props:{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.example",$$slots:{default:[Bw]},$$scope:{ctx:j}}}),mo=new M({props:{name:"__call__",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L392",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),go=new M({props:{name:"class transformers.EpsilonLogitsWarper",anchor:"transformers.EpsilonLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
If set to &gt; 0, only the most tokens with probabilities <code>epsilon</code> or higher are kept for generation.`,name:"epsilon"},{anchor:"transformers.EpsilonLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.EpsilonLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L611"}}),Kt=new B({props:{anchor:"transformers.EpsilonLogitsWarper.example",$$slots:{default:[Iw]},$$scope:{ctx:j}}}),uo=new M({props:{name:"__call__",anchor:"transformers.EpsilonLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EpsilonLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L666",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ho=new M({props:{name:"class transformers.EtaLogitsWarper",anchor:"transformers.EtaLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
A float value in the range (0, 1). Hyperparameter used to calculate the dynamic cutoff value, <code>eta</code>. The
suggested values from the paper ranges from 3e-4 to 4e-3 depending on the size of the model.`,name:"epsilon"},{anchor:"transformers.EtaLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All values that are found to be below the dynamic cutoff value, <code>eta</code>, are set to this float value. This
parameter is useful when logits need to be modified for very low probability tokens that should be excluded
from generation entirely.`,name:"filter_value"},{anchor:"transformers.EtaLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Specifies the minimum number of tokens that must be kept for generation, regardless of their probabilities.
For example, if <code>min_tokens_to_keep</code> is set to 1, at least one token will always be kept for generation,
even if all tokens have probabilities below the cutoff <code>eta</code>.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L680"}}),es=new B({props:{anchor:"transformers.EtaLogitsWarper.example",$$slots:{default:[Zw]},$$scope:{ctx:j}}}),fo=new M({props:{name:"__call__",anchor:"transformers.EtaLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EtaLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L745",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),_o=new M({props:{name:"class transformers.ExponentialDecayLengthPenalty",anchor:"transformers.ExponentialDecayLengthPenalty",parameters:[{name:"exponential_decay_length_penalty",val:": Tuple"},{name:"eos_token_id",val:": Union"},{name:"input_ids_seq_length",val:": int"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.exponential_decay_length_penalty",description:`<strong>exponential_decay_length_penalty</strong> (<code>tuple(int, float)</code>) &#x2014;
This tuple shall consist of: <code>(start_index, decay_factor)</code> where <code>start_index</code> indicates where penalty
starts and <code>decay_factor</code> represents the factor of exponential decay`,name:"exponential_decay_length_penalty"},{anchor:"transformers.ExponentialDecayLengthPenalty.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.ExponentialDecayLengthPenalty.input_ids_seq_length",description:`<strong>input_ids_seq_length</strong> (<code>int</code>) &#x2014;
The length of the input sequence.`,name:"input_ids_seq_length"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L1511"}}),ts=new B({props:{anchor:"transformers.ExponentialDecayLengthPenalty.example",$$slots:{default:[zw]},$$scope:{ctx:j}}}),bo=new M({props:{name:"__call__",anchor:"transformers.ExponentialDecayLengthPenalty.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L1591",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),yo=new M({props:{name:"class transformers.ForcedBOSTokenLogitsProcessor",anchor:"transformers.ForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L1396"}}),ss=new B({props:{anchor:"transformers.ForcedBOSTokenLogitsProcessor.example",$$slots:{default:[Ww]},$$scope:{ctx:j}}}),To=new M({props:{name:"__call__",anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L1431",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),vo=new M({props:{name:"class transformers.ForcedEOSTokenLogitsProcessor",anchor:"transformers.ForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": Union"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached. Optionally, use a
list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L1441"}}),ns=new B({props:{anchor:"transformers.ForcedEOSTokenLogitsProcessor.example",$$slots:{default:[Lw]},$$scope:{ctx:j}}}),Mo=new M({props:{name:"__call__",anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L1480",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),wo=new M({props:{name:"class transformers.ForceTokensLogitsProcessor",anchor:"transformers.ForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:": List"},{name:"_has_warned",val:": Optional = False"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L1738"}}),$o=new M({props:{name:"__call__",anchor:"transformers.ForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForceTokensLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForceTokensLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L1755",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ko=new M({props:{name:"class transformers.HammingDiversityLogitsProcessor",anchor:"transformers.HammingDiversityLogitsProcessor",parameters:[{name:"diversity_penalty",val:": float"},{name:"num_beams",val:": int"},{name:"num_beam_groups",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.diversity_penalty",description:`<strong>diversity_penalty</strong> (<code>float</code>) &#x2014;
This value is subtracted from a beam&#x2019;s score if it generates a token same as any beam from other group at a
particular time. A higher <code>diversity_penalty</code> will enforce greater diversity among the beams. Adjusting
this value can help strike a balance between diversity and natural likelihood.`,name:"diversity_penalty"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search. 1 means no beam search.`,name:"num_beams"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
<a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L1260"}}),os=new B({props:{anchor:"transformers.HammingDiversityLogitsProcessor.example",$$slots:{default:[Cw]},$$scope:{ctx:j}}}),jo=new M({props:{name:"__call__",anchor:"transformers.HammingDiversityLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"current_tokens",val:": LongTensor"},{name:"beam_group_idx",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.current_tokens",description:`<strong>current_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary, corresponding to the tokens selected by the other
beam groups in the current generation step.`,name:"current_tokens"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.beam_group_idx",description:`<strong>beam_group_idx</strong> (<code>int</code>) &#x2014;
The index of the beam group currently being processed.`,name:"beam_group_idx"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L1347",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),xo=new M({props:{name:"class transformers.InfNanRemoveLogitsProcessor",anchor:"transformers.InfNanRemoveLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L1490"}}),Jo=new M({props:{name:"__call__",anchor:"transformers.InfNanRemoveLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L1499",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Uo=new M({props:{name:"class transformers.LogitNormalization",anchor:"transformers.LogitNormalization",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L1606"}}),rs=new B({props:{anchor:"transformers.LogitNormalization.example",$$slots:{default:[Vw]},$$scope:{ctx:j}}}),Bo=new M({props:{name:"__call__",anchor:"transformers.LogitNormalization.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitNormalization.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitNormalization.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L1637",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Io=new M({props:{name:"class transformers.LogitsProcessor",anchor:"transformers.LogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L45"}}),Zo=new M({props:{name:"__call__",anchor:"transformers.LogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L48",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),zo=new M({props:{name:"class transformers.LogitsProcessorList",anchor:"transformers.LogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L65"}}),Wo=new M({props:{name:"__call__",anchor:"transformers.LogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.LogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional kwargs that are specific to a logits processor.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L72",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Lo=new M({props:{name:"class transformers.LogitsWarper",anchor:"transformers.LogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L55"}}),Co=new M({props:{name:"__call__",anchor:"transformers.LogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L58",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Vo=new M({props:{name:"class transformers.MinLengthLogitsProcessor",anchor:"transformers.MinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": Union"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.MinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L103"}}),as=new B({props:{anchor:"transformers.MinLengthLogitsProcessor.example",$$slots:{default:[Fw]},$$scope:{ctx:j}}}),Fo=new M({props:{name:"__call__",anchor:"transformers.MinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L152",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Go=new M({props:{name:"class transformers.MinNewTokensLengthLogitsProcessor",anchor:"transformers.MinNewTokensLengthLogitsProcessor",parameters:[{name:"prompt_length_to_skip",val:": int"},{name:"min_new_tokens",val:": int"},{name:"eos_token_id",val:": Union"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.prompt_length_to_skip",description:`<strong>prompt_length_to_skip</strong> (<code>int</code>) &#x2014;
The input tokens length. Not a valid argument when used with <code>generate</code> as it will automatically assign the
input length.`,name:"prompt_length_to_skip"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>) &#x2014;
The minimum <em>new</em> tokens length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_new_tokens"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L163"}}),ls=new B({props:{anchor:"transformers.MinNewTokensLengthLogitsProcessor.example",$$slots:{default:[Gw]},$$scope:{ctx:j}}}),Xo=new M({props:{name:"__call__",anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L215",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ro=new M({props:{name:"class transformers.NoBadWordsLogitsProcessor",anchor:"transformers.NoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": List"},{name:"eos_token_id",val:": Union"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated.`,name:"bad_words_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L1104"}}),cs=new bn({props:{$$slots:{default:[Xw]},$$scope:{ctx:j}}}),is=new B({props:{anchor:"transformers.NoBadWordsLogitsProcessor.example",$$slots:{default:[Rw]},$$scope:{ctx:j}}}),So=new M({props:{name:"__call__",anchor:"transformers.NoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L1027",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),No=new M({props:{name:"class transformers.NoRepeatNGramLogitsProcessor",anchor:"transformers.NoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L828"}}),ds=new bn({props:{$$slots:{default:[Sw]},$$scope:{ctx:j}}}),ps=new B({props:{anchor:"transformers.NoRepeatNGramLogitsProcessor.example",$$slots:{default:[Nw]},$$scope:{ctx:j}}}),Eo=new M({props:{name:"__call__",anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L875",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ho=new M({props:{name:"class transformers.PrefixConstrainedLogitsProcessor",anchor:"transformers.PrefixConstrainedLogitsProcessor",parameters:[{name:"prefix_allowed_tokens_fn",val:": Callable"},{name:"num_beams",val:": int"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>) &#x2014;
This function constraints the beam search to allowed tokens only at each step. This function takes 2
arguments <code>inputs_ids</code> and the batch ID <code>batch_id</code>. It has to return a list with the allowed tokens for the
next generation step conditioned on the previously generated tokens <code>inputs_ids</code> and the batch ID
<code>batch_id</code>.`,name:"prefix_allowed_tokens_fn"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L1191"}}),ms=new B({props:{anchor:"transformers.PrefixConstrainedLogitsProcessor.example",$$slots:{default:[Ew]},$$scope:{ctx:j}}}),qo=new M({props:{name:"__call__",anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L1242",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Do=new M({props:{name:"class transformers.RepetitionPenaltyLogitsProcessor",anchor:"transformers.RepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.penalty",description:`<strong>penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. Above 1.0 penalizes previously generated
tokens. Between 0.0 and 1.0 rewards previously generated tokens.`,name:"penalty"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L294"}}),gs=new B({props:{anchor:"transformers.RepetitionPenaltyLogitsProcessor.example",$$slots:{default:[Hw]},$$scope:{ctx:j}}}),Po=new M({props:{name:"__call__",anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L337",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Qo=new M({props:{name:"class transformers.SequenceBiasLogitsProcessor",anchor:"transformers.SequenceBiasLogitsProcessor",parameters:[{name:"sequence_bias",val:": Dict"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.sequence_bias",description:`<strong>sequence_bias</strong> (<code>Dict[Tuple[int], float]</code>) &#x2014;
Dictionary that maps a sequence of tokens to its bias term. Positive biases increase the odds of the
sequence being selected, while negative biases do the opposite. If a sequence has a length of 1, its bias
will always be applied. Otherwise, the bias will only be applied if the sequence in question is about to be
completed (in the token selection step after this processor is applied).`,name:"sequence_bias"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L956"}}),us=new bn({props:{$$slots:{default:[qw]},$$scope:{ctx:j}}}),hs=new B({props:{anchor:"transformers.SequenceBiasLogitsProcessor.example",$$slots:{default:[Dw]},$$scope:{ctx:j}}}),Yo=new M({props:{name:"__call__",anchor:"transformers.SequenceBiasLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L1027",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ao=new M({props:{name:"class transformers.SuppressTokensAtBeginLogitsProcessor",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L1643"}}),fs=new B({props:{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.example",$$slots:{default:[Pw]},$$scope:{ctx:j}}}),Oo=new M({props:{name:"__call__",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L1685",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ko=new M({props:{name:"class transformers.SuppressTokensLogitsProcessor",anchor:"transformers.SuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L1697"}}),_s=new B({props:{anchor:"transformers.SuppressTokensLogitsProcessor.example",$$slots:{default:[Qw]},$$scope:{ctx:j}}}),er=new M({props:{name:"__call__",anchor:"transformers.SuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L1729",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),tr=new M({props:{name:"class transformers.TemperatureLogitsWarper",anchor:"transformers.TemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
Strictly positive float value used to modulate the logits distribution. A value smaller than <code>1</code> decreases
randomness (and vice versa), with <code>0</code> being equivalent to shifting all probability mass to the most likely
token.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L228"}}),bs=new bn({props:{$$slots:{default:[Yw]},$$scope:{ctx:j}}}),ys=new B({props:{anchor:"transformers.TemperatureLogitsWarper.example",$$slots:{default:[Aw]},$$scope:{ctx:j}}}),sr=new M({props:{name:"__call__",anchor:"transformers.TemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TemperatureLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L288",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),nr=new M({props:{name:"class transformers.TopKLogitsWarper",anchor:"transformers.TopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L470"}}),Ts=new B({props:{anchor:"transformers.TopKLogitsWarper.example",$$slots:{default:[Ow]},$$scope:{ctx:j}}}),or=new M({props:{name:"__call__",anchor:"transformers.TopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopKLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L514",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),rr=new M({props:{name:"class transformers.TopPLogitsWarper",anchor:"transformers.TopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L403"}}),vs=new B({props:{anchor:"transformers.TopPLogitsWarper.example",$$slots:{default:[Kw]},$$scope:{ctx:j}}}),ar=new M({props:{name:"__call__",anchor:"transformers.TopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopPLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L454",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),lr=new M({props:{name:"class transformers.TypicalLogitsWarper",anchor:"transformers.TypicalLogitsWarper",parameters:[{name:"mass",val:": float = 0.9"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.mass",description:`<strong>mass</strong> (<code>float</code>, <em>optional</em>, defaults to 0.9) &#x2014;
Value of typical_p between 0 and 1 inclusive, defaults to 0.9.`,name:"mass"},{anchor:"transformers.TypicalLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TypicalLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L523"}}),Ms=new B({props:{anchor:"transformers.TypicalLogitsWarper.example",$$slots:{default:[e$]},$$scope:{ctx:j}}}),cr=new M({props:{name:"__call__",anchor:"transformers.TypicalLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TypicalLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L587",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ir=new M({props:{name:"class transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:": float"},{name:"model",val:""},{name:"unconditional_ids",val:": Optional = None"},{name:"unconditional_attention_mask",val:": Optional = None"},{name:"use_cache",val:": Optional = True"}],parametersDescription:[{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale != 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality. A value smaller than 1 has the opposite effect, while
making the negative prompt provided with negative_prompt_ids (if any) act as a positive prompt.`,name:"guidance_scale"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.model",description:`<strong>model</strong> (<code>PreTrainedModel</code>) &#x2014;
The model computing the unconditional scores. Supposedly the same as the one computing the conditional
scores. Both models must use the same tokenizer.`,name:"model"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_ids",description:`<strong>unconditional_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary for the unconditional branch. If unset, will default to
the last token of the prompt.`,name:"unconditional_ids"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_attention_mask",description:`<strong>unconditional_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Attention mask for unconditional_ids.`,name:"unconditional_attention_mask"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to cache key/values during the negative prompt forward pass.`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L2065"}}),ws=new B({props:{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.example",$$slots:{default:[t$]},$$scope:{ctx:j}}}),dr=new M({props:{name:"__call__",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L2171"}}),pr=new M({props:{name:"class transformers.WhisperTimeStampLogitsProcessor",anchor:"transformers.WhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""},{name:"begin_index",val:": Optional = None"},{name:"_detect_timestamp_from_logprob",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"},{anchor:"transformers.WhisperTimeStampLogitsProcessor.begin_index",description:"<strong>begin_index</strong> (<code>Optional</code>, <em>optional</em>) &#x2014; Token index of the first token that is generated by the model.",name:"begin_index"},{anchor:"transformers.WhisperTimeStampLogitsProcessor._detect_timestamp_from_logprob",description:"<strong>_detect_timestamp_from_logprob</strong> (<code>bool</code>, <em>optional</em>) &#x2014; Whether timestamps can be predicted from logprobs over all timestamps.",name:"_detect_timestamp_from_logprob"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L1766"}}),$s=new B({props:{anchor:"transformers.WhisperTimeStampLogitsProcessor.example",$$slots:{default:[s$]},$$scope:{ctx:j}}}),mr=new M({props:{name:"__call__",anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/logits_process.py#L1848",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),gr=new K({props:{title:"TensorFlow",local:"transformers.TFForcedBOSTokenLogitsProcessor",headingTag:"h3"}}),ur=new M({props:{name:"class transformers.TFForcedBOSTokenLogitsProcessor",anchor:"transformers.TFForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_logits_process.py#L448"}}),hr=new M({props:{name:"__call__",anchor:"transformers.TFForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_logits_process.py#L462"}}),fr=new M({props:{name:"class transformers.TFForcedEOSTokenLogitsProcessor",anchor:"transformers.TFForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_logits_process.py#L478"}}),_r=new M({props:{name:"__call__",anchor:"transformers.TFForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_logits_process.py#L495"}}),br=new M({props:{name:"class transformers.TFForceTokensLogitsProcessor",anchor:"transformers.TFForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:": List"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_logits_process.py#L551"}}),yr=new M({props:{name:"__call__",anchor:"transformers.TFForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_logits_process.py#L567"}}),Tr=new M({props:{name:"class transformers.TFLogitsProcessor",anchor:"transformers.TFLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_logits_process.py#L53"}}),vr=new M({props:{name:"__call__",anchor:"transformers.TFLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.40.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.40.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.40.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessor.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_logits_process.py#L56",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Mr=new M({props:{name:"class transformers.TFLogitsProcessorList",anchor:"transformers.TFLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_logits_process.py#L75"}}),wr=new M({props:{name:"__call__",anchor:"transformers.TFLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.40.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.40.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.40.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessorList.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_logits_process.py#L82",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),$r=new M({props:{name:"class transformers.TFLogitsWarper",anchor:"transformers.TFLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_logits_process.py#L64"}}),kr=new M({props:{name:"__call__",anchor:"transformers.TFLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.40.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.40.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.40.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsWarper.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_logits_process.py#L67",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),jr=new M({props:{name:"class transformers.TFMinLengthLogitsProcessor",anchor:"transformers.TFMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.TFMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_logits_process.py#L202"}}),xr=new M({props:{name:"__call__",anchor:"transformers.TFMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_logits_process.py#L228"}}),Jr=new M({props:{name:"class transformers.TFNoBadWordsLogitsProcessor",anchor:"transformers.TFNoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": List"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated. In order to get the tokens of the words
that should not appear in the generated text, make sure to set <code>add_prefix_space=True</code> when initializing
the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The <code>add_prefix_space</code>
argument is only supported for some slow tokenizers, as fast tokenizers&#x2019; prefixing behaviours come from
<code>pre tokenizers</code>. Read more <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`,name:"bad_words_ids"},{anchor:"transformers.TFNoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_logits_process.py#L288"}}),Ur=new M({props:{name:"__call__",anchor:"transformers.TFNoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_logits_process.py#L367"}}),Br=new M({props:{name:"class transformers.TFNoRepeatNGramLogitsProcessor",anchor:"transformers.TFNoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_logits_process.py#L388"}}),Ir=new M({props:{name:"__call__",anchor:"transformers.TFNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_logits_process.py#L427"}}),Zr=new M({props:{name:"class transformers.TFRepetitionPenaltyLogitsProcessor",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"}],parametersDescription:[{anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_logits_process.py#L238"}}),zr=new M({props:{name:"__call__",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_logits_process.py#L280"}}),Wr=new M({props:{name:"class transformers.TFSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_logits_process.py#L511"}}),Lr=new M({props:{name:"__call__",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_logits_process.py#L522"}}),Cr=new M({props:{name:"class transformers.TFSuppressTokensLogitsProcessor",anchor:"transformers.TFSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_logits_process.py#L535"}}),Vr=new M({props:{name:"__call__",anchor:"transformers.TFSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_logits_process.py#L542"}}),Fr=new M({props:{name:"class transformers.TFTemperatureLogitsWarper",anchor:"transformers.TFTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TFTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_logits_process.py#L98"}}),Gr=new M({props:{name:"__call__",anchor:"transformers.TFTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_logits_process.py#L113"}}),Xr=new M({props:{name:"class transformers.TFTopKLogitsWarper",anchor:"transformers.TFTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TFTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_logits_process.py#L118"}}),Rr=new M({props:{name:"__call__",anchor:"transformers.TFTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_logits_process.py#L138"}}),Sr=new M({props:{name:"class transformers.TFTopPLogitsWarper",anchor:"transformers.TFTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TFTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_logits_process.py#L146"}}),Nr=new M({props:{name:"__call__",anchor:"transformers.TFTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/tf_logits_process.py#L170"}}),Er=new K({props:{title:"FLAX",local:"transformers.FlaxForcedBOSTokenLogitsProcessor",headingTag:"h3"}}),Hr=new M({props:{name:"class transformers.FlaxForcedBOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/flax_logits_process.py#L195"}}),qr=new M({props:{name:"__call__",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/flax_logits_process.py#L207"}}),Dr=new M({props:{name:"class transformers.FlaxForcedEOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/flax_logits_process.py#L217"}}),Pr=new M({props:{name:"__call__",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/flax_logits_process.py#L232"}}),Qr=new M({props:{name:"class transformers.FlaxForceTokensLogitsProcessor",anchor:"transformers.FlaxForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:""}],parametersDescription:[{anchor:"transformers.FlaxForceTokensLogitsProcessor.force_token_map",description:`<strong>force_token_map</strong> (<code>list</code>) &#x2014;
Map giving token ids and indices where they will be forced to be sampled.`,name:"force_token_map"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/flax_logits_process.py#L316"}}),Yr=new M({props:{name:"__call__",anchor:"transformers.FlaxForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/flax_logits_process.py#L338"}}),Ar=new M({props:{name:"class transformers.FlaxLogitsProcessor",anchor:"transformers.FlaxLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/flax_logits_process.py#L51"}}),Or=new M({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.40.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.40.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.40.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/flax_logits_process.py#L54",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Kr=new M({props:{name:"class transformers.FlaxLogitsProcessorList",anchor:"transformers.FlaxLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/flax_logits_process.py#L73"}}),ea=new M({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.40.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.40.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.40.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/flax_logits_process.py#L80",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ta=new M({props:{name:"class transformers.FlaxLogitsWarper",anchor:"transformers.FlaxLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/flax_logits_process.py#L62"}}),sa=new M({props:{name:"__call__",anchor:"transformers.FlaxLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.40.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.40.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.40.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/flax_logits_process.py#L65",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),na=new M({props:{name:"class transformers.FlaxMinLengthLogitsProcessor",anchor:"transformers.FlaxMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.FlaxMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/flax_logits_process.py#L242"}}),oa=new M({props:{name:"__call__",anchor:"transformers.FlaxMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/flax_logits_process.py#L263"}}),ra=new M({props:{name:"class transformers.FlaxSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_suppress_tokens",description:`<strong>begin_suppress_tokens</strong> (<code>List[int]</code>) &#x2014;
Tokens to not sample.`,name:"begin_suppress_tokens"},{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_index",description:`<strong>begin_index</strong> (<code>int</code>) &#x2014;
Index where the tokens are suppressed.`,name:"begin_index"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/flax_logits_process.py#L272"}}),aa=new M({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/flax_logits_process.py#L289"}}),la=new M({props:{name:"class transformers.FlaxSuppressTokensLogitsProcessor",anchor:"transformers.FlaxSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:": list"}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensLogitsProcessor.suppress_tokens",description:`<strong>suppress_tokens</strong> (<code>list</code>) &#x2014;
Tokens to not sample.`,name:"suppress_tokens"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/flax_logits_process.py#L297"}}),ca=new M({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/flax_logits_process.py#L310"}}),ia=new M({props:{name:"class transformers.FlaxTemperatureLogitsWarper",anchor:"transformers.FlaxTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.FlaxTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/flax_logits_process.py#L96"}}),da=new M({props:{name:"__call__",anchor:"transformers.FlaxTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/flax_logits_process.py#L111"}}),pa=new M({props:{name:"class transformers.FlaxTopKLogitsWarper",anchor:"transformers.FlaxTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.FlaxTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/flax_logits_process.py#L160"}}),ma=new M({props:{name:"__call__",anchor:"transformers.FlaxTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/flax_logits_process.py#L180"}}),ga=new M({props:{name:"class transformers.FlaxTopPLogitsWarper",anchor:"transformers.FlaxTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.FlaxTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/flax_logits_process.py#L116"}}),ua=new M({props:{name:"__call__",anchor:"transformers.FlaxTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/flax_logits_process.py#L140"}}),ha=new M({props:{name:"class transformers.FlaxWhisperTimeStampLogitsProcessor",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""},{name:"model_config",val:""},{name:"decoder_input_length",val:""}],parametersDescription:[{anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/flax_logits_process.py#L364"}}),fa=new M({props:{name:"__call__",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/flax_logits_process.py#L398"}}),_a=new K({props:{title:"StoppingCriteria",local:"transformers.StoppingCriteria",headingTag:"h2"}}),ya=new M({props:{name:"class transformers.StoppingCriteria",anchor:"transformers.StoppingCriteria",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/stopping_criteria.py#L38"}}),Ta=new M({props:{name:"__call__",anchor:"transformers.StoppingCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.40.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.40.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.40.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.StoppingCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/stopping_criteria.py#L45",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),va=new M({props:{name:"class transformers.StoppingCriteriaList",anchor:"transformers.StoppingCriteriaList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/stopping_criteria.py#L153"}}),Ma=new M({props:{name:"__call__",anchor:"transformers.StoppingCriteriaList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteriaList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.40.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.40.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.40.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteriaList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.StoppingCriteriaList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/stopping_criteria.py#L154",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),wa=new M({props:{name:"class transformers.MaxLengthCriteria",anchor:"transformers.MaxLengthCriteria",parameters:[{name:"max_length",val:": int"},{name:"max_position_embeddings",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length that the output sequence can have in number of tokens.`,name:"max_length"},{anchor:"transformers.MaxLengthCriteria.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum model length, as defined by the model&#x2019;s <code>config.max_position_embeddings</code> attribute.`,name:"max_position_embeddings"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/stopping_criteria.py#L50"}}),$a=new M({props:{name:"__call__",anchor:"transformers.MaxLengthCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.40.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.40.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.40.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxLengthCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.MaxLengthCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/stopping_criteria.py#L66",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),ka=new M({props:{name:"class transformers.MaxTimeCriteria",anchor:"transformers.MaxTimeCriteria",parameters:[{name:"max_time",val:": float"},{name:"initial_timestamp",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.max_time",description:`<strong>max_time</strong> (<code>float</code>) &#x2014;
The maximum allowed time in seconds for the generation.`,name:"max_time"},{anchor:"transformers.MaxTimeCriteria.initial_time",description:`<strong>initial_time</strong> (<code>float</code>, <em>optional</em>, defaults to <code>time.time()</code>) &#x2014;
The start of the generation allowed time.`,name:"initial_time"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/stopping_criteria.py#L109"}}),ja=new M({props:{name:"__call__",anchor:"transformers.MaxTimeCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.40.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.40.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.40.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxTimeCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.MaxTimeCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/stopping_criteria.py#L126",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),xa=new K({props:{title:"Constraints",local:"transformers.Constraint",headingTag:"h2"}}),Ua=new M({props:{name:"class transformers.Constraint",anchor:"transformers.Constraint",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/beam_constraints.py#L5"}}),Us=new B({props:{anchor:"transformers.Constraint.example",$$slots:{default:[n$]},$$scope:{ctx:j}}}),Ba=new M({props:{name:"advance",anchor:"transformers.Constraint.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/beam_constraints.py#L48",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Must be a tensor of a list of indexable tokens, not some integer.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>token_ids(<code>torch.tensor</code>)</p>
`}}),Ia=new M({props:{name:"copy",anchor:"transformers.Constraint.copy",parameters:[{name:"stateful",val:" = False"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/beam_constraints.py#L113",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The same constraint as the one being called from.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>constraint(<code>Constraint</code>)</p>
`}}),Za=new M({props:{name:"does_advance",anchor:"transformers.Constraint.does_advance",parameters:[{name:"token_id",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/beam_constraints.py#L60"}}),za=new M({props:{name:"remaining",anchor:"transformers.Constraint.remaining",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/beam_constraints.py#L104"}}),Wa=new M({props:{name:"reset",anchor:"transformers.Constraint.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/beam_constraints.py#L94"}}),La=new M({props:{name:"test",anchor:"transformers.Constraint.test",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/beam_constraints.py#L24"}}),Ca=new M({props:{name:"update",anchor:"transformers.Constraint.update",parameters:[{name:"token_id",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/beam_constraints.py#L69",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Whether this constraint has become one step closer to being fulfuilled.
completed(<code>bool</code>):
Whether this constraint has been completely fulfilled by this token being generated.
reset (<code>bool</code>):
Whether this constraint has reset its progress by this token being generated.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>stepped(<code>bool</code>)</p>
`}}),Va=new M({props:{name:"class transformers.PhrasalConstraint",anchor:"transformers.PhrasalConstraint",parameters:[{name:"token_ids",val:": List"}],parametersDescription:[{anchor:"transformers.PhrasalConstraint.token_ids",description:`<strong>token_ids</strong> (<code>List[int]</code>) &#x2014;
The id of the token that must be generated by the output.`,name:"token_ids"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/beam_constraints.py#L129"}}),Fa=new M({props:{name:"class transformers.DisjunctiveConstraint",anchor:"transformers.DisjunctiveConstraint",parameters:[{name:"nested_token_ids",val:": List"}],parametersDescription:[{anchor:"transformers.DisjunctiveConstraint.nested_token_ids",description:`<strong>nested_token_ids</strong> (<code>List[List[int]]</code>) &#x2014;
A list of words, where each word is a list of ids. This constraint is fulfilled by generating just one from
the list of words.`,name:"nested_token_ids"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/beam_constraints.py#L261"}}),Ga=new M({props:{name:"class transformers.ConstraintListState",anchor:"transformers.ConstraintListState",parameters:[{name:"constraints",val:": List"}],parametersDescription:[{anchor:"transformers.ConstraintListState.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of <a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.Constraint">Constraint</a> objects that must be fulfilled by the beam scorer.`,name:"constraints"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/beam_constraints.py#L351"}}),Xa=new M({props:{name:"advance",anchor:"transformers.ConstraintListState.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/beam_constraints.py#L383"}}),Ra=new M({props:{name:"reset",anchor:"transformers.ConstraintListState.reset",parameters:[{name:"token_ids",val:": Optional"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/beam_constraints.py#L418"}}),Sa=new K({props:{title:"BeamSearch",local:"transformers.BeamScorer",headingTag:"h2"}}),Na=new M({props:{name:"class transformers.BeamScorer",anchor:"transformers.BeamScorer",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/beam_search.py#L91"}}),Ea=new M({props:{name:"process",anchor:"transformers.BeamScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/v4.40.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/v4.40.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/v4.40.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.BeamScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.BeamScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.BeamScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.BeamScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"},{anchor:"transformers.BeamScorer.process.group_index",description:`<strong>group_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The index of the group of beams. Used with <code>group_beam_search()</code>.`,name:"group_index"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/beam_search.py#L97",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Updated scores of all
non-finished beams.</li>
<li><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Next tokens to be added
to the non-finished beam_hypotheses.</li>
<li><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Beam indices
indicating to which beam the next tokens shall be added.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>UserDict</code></p>
`}}),Ha=new M({props:{name:"finalize",anchor:"transformers.BeamScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.finalize.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/v4.40.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/v4.40.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/v4.40.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.finalize.final_beam_scores",description:`<strong>final_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The final scores of all non-finished beams.`,name:"final_beam_scores"},{anchor:"transformers.BeamScorer.finalize.final_beam_tokens",description:`<strong>final_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The last tokens to be added to the non-finished beam_hypotheses.`,name:"final_beam_tokens"},{anchor:"transformers.BeamScorer.finalize.final_beam_indices",description:`<strong>final_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The beam indices indicating to which beam the <code>final_beam_tokens</code> shall be added.`,name:"final_beam_indices"},{anchor:"transformers.BeamScorer.finalize.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.finalize.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/beam_search.py#L109",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated sequences.
The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter if all batches finished early
due to the <code>eos_token_id</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.LongTensor</code> of shape <code>(batch_size * num_return_sequences, sequence_length)</code></p>
`}}),qa=new M({props:{name:"class transformers.BeamSearchScorer",anchor:"transformers.BeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"device",val:": device"},{name:"length_penalty",val:": Optional = 1.0"},{name:"do_early_stopping",val:": Union = False"},{name:"num_beam_hyps_to_keep",val:": Optional = 1"},{name:"num_beam_groups",val:": Optional = 1"},{name:"max_length",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.BeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.BeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.BeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.BeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.BeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.BeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.BeamSearchScorer.finalize">finalize()</a>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.BeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.BeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/beam_search.py#L123"}}),Da=new M({props:{name:"process",anchor:"transformers.BeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"pad_token_id",val:": Optional = None"},{name:"eos_token_id",val:": Union = None"},{name:"beam_indices",val:": Optional = None"},{name:"group_index",val:": Optional = 0"},{name:"decoder_prompt_len",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/beam_search.py#L215"}}),Pa=new M({props:{name:"finalize",anchor:"transformers.BeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": Optional = None"},{name:"eos_token_id",val:": Union = None"},{name:"beam_indices",val:": Optional = None"},{name:"decoder_prompt_len",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/beam_search.py#L318"}}),Qa=new M({props:{name:"class transformers.ConstrainedBeamSearchScorer",anchor:"transformers.ConstrainedBeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"constraints",val:": List"},{name:"device",val:": device"},{name:"length_penalty",val:": Optional = 1.0"},{name:"do_early_stopping",val:": Union = False"},{name:"num_beam_hyps_to_keep",val:": Optional = 1"},{name:"num_beam_groups",val:": Optional = 1"},{name:"max_length",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.ConstrainedBeamSearchScorer.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of positive constraints represented as <code>Constraint</code> objects that must be fulfilled in the generation
output. For more information, the documentation of <a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.Constraint">Constraint</a> should be read.`,name:"constraints"},{anchor:"transformers.ConstrainedBeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.ConstrainedBeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.ConstrainedBeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<a href="/docs/transformers/v4.40.0/en/internal/generation_utils#transformers.BeamSearchScorer.finalize">finalize()</a>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.ConstrainedBeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/beam_search.py#L415"}}),Ya=new M({props:{name:"process",anchor:"transformers.ConstrainedBeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"scores_for_all_vocab",val:": FloatTensor"},{name:"pad_token_id",val:": Optional = None"},{name:"eos_token_id",val:": Union = None"},{name:"beam_indices",val:": Optional = None"},{name:"decoder_prompt_len",val:": Optional = 0"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/v4.40.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/v4.40.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/v4.40.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.scores_for_all_vocab",description:`<strong>scores_for_all_vocab</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
The scores of all tokens in the vocabulary for each of the beam hypotheses.`,name:"scores_for_all_vocab"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.decoder_prompt_len",description:`<strong>decoder_prompt_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The length of prompt that is included in the input to decoder.`,name:"decoder_prompt_len"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/beam_search.py#L509",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li>
<p><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Updated scores of
all
non-finished beams.</p>
</li>
<li>
<p><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Next tokens to be
added
to the non-finished beam_hypotheses.</p>
</li>
<li>
<p><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Beam indices
indicating to which beam the next tokens shall be added.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>UserDict</code></p>
`}}),Aa=new M({props:{name:"finalize",anchor:"transformers.ConstrainedBeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": Optional = None"},{name:"eos_token_id",val:": Union = None"},{name:"beam_indices",val:": Optional = None"},{name:"decoder_prompt_len",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/beam_search.py#L807"}}),Oa=new K({props:{title:"Streamers",local:"transformers.TextStreamer",headingTag:"h2"}}),Ka=new M({props:{name:"class transformers.TextStreamer",anchor:"transformers.TextStreamer",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"skip_prompt",val:": bool = False"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/streamers.py#L38"}}),Vs=new bn({props:{warning:!0,$$slots:{default:[o$]},$$scope:{ctx:j}}}),Fs=new B({props:{anchor:"transformers.TextStreamer.example",$$slots:{default:[r$]},$$scope:{ctx:j}}}),el=new M({props:{name:"end",anchor:"transformers.TextStreamer.end",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/streamers.py#L116"}}),tl=new M({props:{name:"on_finalized_text",anchor:"transformers.TextStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/streamers.py#L130"}}),sl=new M({props:{name:"put",anchor:"transformers.TextStreamer.put",parameters:[{name:"value",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/streamers.py#L82"}}),nl=new M({props:{name:"class transformers.TextIteratorStreamer",anchor:"transformers.TextIteratorStreamer",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"skip_prompt",val:": bool = False"},{name:"timeout",val:": Optional = None"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextIteratorStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextIteratorStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextIteratorStreamer.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The timeout for the text queue. If <code>None</code>, the queue will block indefinitely. Useful to handle exceptions
in <code>.generate()</code>, when it is called in a separate thread.`,name:"timeout"},{anchor:"transformers.TextIteratorStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/streamers.py#L159"}}),Ss=new bn({props:{warning:!0,$$slots:{default:[a$]},$$scope:{ctx:j}}}),Ns=new B({props:{anchor:"transformers.TextIteratorStreamer.example",$$slots:{default:[l$]},$$scope:{ctx:j}}}),ol=new M({props:{name:"on_finalized_text",anchor:"transformers.TextIteratorStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/generation/streamers.py#L213"}}),rl=new K({props:{title:"Caches",local:"transformers.Cache",headingTag:"h2"}}),al=new M({props:{name:"class transformers.Cache",anchor:"transformers.Cache",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/cache_utils.py#L13"}}),ll=new M({props:{name:"update",anchor:"transformers.Cache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Cache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.Cache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.Cache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.Cache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. These are specific to each subclass and allow new types of
cache to be created.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/cache_utils.py#L19",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),cl=new M({props:{name:"class transformers.DynamicCache",anchor:"transformers.DynamicCache",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/cache_utils.py#L76"}}),il=new M({props:{name:"update",anchor:"transformers.DynamicCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.DynamicCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.DynamicCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.DynamicCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.DynamicCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. No additional arguments are used in <code>DynamicCache</code>.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/cache_utils.py#L114",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),dl=new M({props:{name:"get_seq_length",anchor:"transformers.DynamicCache.get_seq_length",parameters:[{name:"layer_idx",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/cache_utils.py#L151"}}),pl=new M({props:{name:"reorder_cache",anchor:"transformers.DynamicCache.reorder_cache",parameters:[{name:"beam_idx",val:": LongTensor"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/cache_utils.py#L161"}}),ml=new M({props:{name:"to_legacy_cache",anchor:"transformers.DynamicCache.to_legacy_cache",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/cache_utils.py#L169"}}),gl=new M({props:{name:"from_legacy_cache",anchor:"transformers.DynamicCache.from_legacy_cache",parameters:[{name:"past_key_values",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/cache_utils.py#L176"}}),ul=new M({props:{name:"class transformers.SinkCache",anchor:"transformers.SinkCache",parameters:[{name:"window_length",val:": int"},{name:"num_sink_tokens",val:": int"}],parametersDescription:[{anchor:"transformers.SinkCache.window_length",description:`<strong>window_length</strong> (<code>int</code>) &#x2014;
The length of the context window.`,name:"window_length"},{anchor:"transformers.SinkCache.num_sink_tokens",description:`<strong>num_sink_tokens</strong> (<code>int</code>) &#x2014;
The number of sink tokens. See the original paper for more information.`,name:"num_sink_tokens"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/cache_utils.py#L187"}}),hl=new M({props:{name:"update",anchor:"transformers.SinkCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.SinkCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.SinkCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.SinkCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.SinkCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. The following arguments can be used in <code>SinkCache</code>: <code>sin</code>,
<code>cos</code> and <code>partial_rotation_size</code>. These arguments are used with models using RoPE, to recompute the
rotation as the tokens are shifted.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/cache_utils.py#L256",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),fl=new M({props:{name:"get_seq_length",anchor:"transformers.SinkCache.get_seq_length",parameters:[{name:"layer_idx",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/cache_utils.py#L245"}}),_l=new M({props:{name:"reorder_cache",anchor:"transformers.SinkCache.reorder_cache",parameters:[{name:"beam_idx",val:": LongTensor"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/cache_utils.py#L335"}}),bl=new M({props:{name:"class transformers.StaticCache",anchor:"transformers.StaticCache",parameters:[{name:"config",val:": PretrainedConfig"},{name:"max_batch_size",val:": int"},{name:"max_cache_len",val:": int"},{name:"device",val:""},{name:"dtype",val:" = None"}],parametersDescription:[{anchor:"transformers.StaticCache.config",description:"<strong>config</strong> (<code>PretrainedConfig) -- The configuration file defining the </code>max_position_embeddings<code>, </code>hidden_size<code>and</code>num_attention_heads`\nrequired to initialize the static cache.",name:"config"},{anchor:"transformers.StaticCache.max_batch_size",description:`<strong>max_batch_size</strong> (<code>int</code>) &#x2014;
The maximum batch size with which the model will be used.`,name:"max_batch_size"},{anchor:"transformers.StaticCache.max_cache_len",description:`<strong>max_cache_len</strong> (<code>int</code>) &#x2014;
The maximum sequence length with which the model will be used.`,name:"max_cache_len"},{anchor:"transformers.StaticCache.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
The device on which the cache should be initialized. Should be the same as the layer.`,name:"device"},{anchor:"transformers.StaticCache.dtype",description:`<strong>dtype</strong> (<em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
The default <code>dtype</code> to use when initializing the layer.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/cache_utils.py#L344"}}),yl=new M({props:{name:"update",anchor:"transformers.StaticCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.StaticCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.StaticCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.StaticCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for. Kept for backward compatibility`,name:"layer_idx"},{anchor:"transformers.StaticCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. The <code>StaticCache</code> just needs the <code>q_len</code>
to know how much of the cache it should overwrite.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/cache_utils.py#L380",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),Tl=new M({props:{name:"get_seq_length",anchor:"transformers.StaticCache.get_seq_length",parameters:[{name:"layer_idx",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/cache_utils.py#L414"}}),{c(){i=a("meta"),k=n(),b=a("p"),_=n(),p(w.$$.fragment),r=n(),$=a("p"),$.innerHTML=vT,wm=n(),p(yn.$$.fragment),$m=n(),Tn=a("p"),Tn.innerHTML=MT,km=n(),vn=a("p"),vn.textContent=wT,jm=n(),p(Mn.$$.fragment),xm=n(),wn=a("p"),wn.innerHTML=$T,Jm=n(),$n=a("ul"),$n.innerHTML=kT,Um=n(),kn=a("p"),kn.innerHTML=jT,Bm=n(),jn=a("p"),jn.innerHTML=xT,Im=n(),xn=a("p"),xn.innerHTML=JT,Zm=n(),p(Jn.$$.fragment),zm=n(),Un=a("p"),Un.innerHTML=UT,Wm=n(),Bn=a("p"),Bn.innerHTML=BT,Lm=n(),In=a("p"),In.textContent=IT,Cm=n(),p(Zn.$$.fragment),Vm=n(),kt=a("div"),p(zn.$$.fragment),gh=n(),Fl=a("p"),Fl.textContent=ZT,Fm=n(),jt=a("div"),p(Wn.$$.fragment),uh=n(),Gl=a("p"),Gl.textContent=zT,Gm=n(),xt=a("div"),p(Ln.$$.fragment),hh=n(),Xl=a("p"),Xl.textContent=WT,Xm=n(),Jt=a("div"),p(Cn.$$.fragment),fh=n(),Rl=a("p"),Rl.textContent=LT,Rm=n(),p(Vn.$$.fragment),Sm=n(),Ut=a("div"),p(Fn.$$.fragment),_h=n(),Sl=a("p"),Sl.textContent=CT,Nm=n(),Bt=a("div"),p(Gn.$$.fragment),bh=n(),Nl=a("p"),Nl.textContent=VT,Em=n(),It=a("div"),p(Xn.$$.fragment),yh=n(),El=a("p"),El.textContent=FT,Hm=n(),Zt=a("div"),p(Rn.$$.fragment),Th=n(),Hl=a("p"),Hl.textContent=GT,qm=n(),zt=a("div"),p(Sn.$$.fragment),vh=n(),ql=a("p"),ql.textContent=XT,Dm=n(),Wt=a("div"),p(Nn.$$.fragment),Mh=n(),Dl=a("p"),Dl.textContent=RT,Pm=n(),Lt=a("div"),p(En.$$.fragment),wh=n(),Pl=a("p"),Pl.textContent=ST,Qm=n(),Ct=a("div"),p(Hn.$$.fragment),$h=n(),Ql=a("p"),Ql.textContent=NT,Ym=n(),Vt=a("div"),p(qn.$$.fragment),kh=n(),Yl=a("p"),Yl.textContent=ET,Am=n(),Ft=a("div"),p(Dn.$$.fragment),jh=n(),Al=a("p"),Al.textContent=HT,Om=n(),p(Pn.$$.fragment),Km=n(),je=a("div"),p(Qn.$$.fragment),xh=n(),Ol=a("p"),Ol.textContent=qT,Jh=n(),Ht=a("div"),p(Yn.$$.fragment),Uh=n(),Kl=a("p"),Kl.textContent=DT,eg=n(),xe=a("div"),p(An.$$.fragment),Bh=n(),ec=a("p"),ec.textContent=PT,Ih=n(),qt=a("div"),p(On.$$.fragment),Zh=n(),tc=a("p"),tc.textContent=QT,tg=n(),Je=a("div"),p(Kn.$$.fragment),zh=n(),sc=a("p"),sc.textContent=YT,Wh=n(),Dt=a("div"),p(eo.$$.fragment),Lh=n(),nc=a("p"),nc.textContent=AT,sg=n(),p(to.$$.fragment),ng=n(),so=a("p"),so.innerHTML=OT,og=n(),p(no.$$.fragment),rg=n(),ee=a("div"),p(oo.$$.fragment),Ch=n(),oc=a("p"),oc.innerHTML=KT,Vh=n(),p(Pt.$$.fragment),Fh=n(),rc=a("div"),p(ro.$$.fragment),ag=n(),W=a("div"),p(ao.$$.fragment),Gh=n(),ac=a("p"),ac.innerHTML=ev,Xh=n(),lc=a("p"),lc.innerHTML=tv,Rh=n(),p(Qt.$$.fragment),Sh=n(),p(Yt.$$.fragment),Nh=n(),cc=a("div"),p(lo.$$.fragment),lg=n(),X=a("div"),p(co.$$.fragment),Eh=n(),ic=a("p"),ic.innerHTML=sv,Hh=n(),dc=a("p"),dc.textContent=nv,qh=n(),p(At.$$.fragment),Dh=n(),pc=a("div"),p(io.$$.fragment),cg=n(),R=a("div"),p(po.$$.fragment),Ph=n(),mc=a("p"),mc.innerHTML=ov,Qh=n(),gc=a("p"),gc.textContent=rv,Yh=n(),p(Ot.$$.fragment),Ah=n(),uc=a("div"),p(mo.$$.fragment),ig=n(),te=a("div"),p(go.$$.fragment),Oh=n(),hc=a("p"),hc.innerHTML=av,Kh=n(),p(Kt.$$.fragment),ef=n(),fc=a("div"),p(uo.$$.fragment),dg=n(),se=a("div"),p(ho.$$.fragment),tf=n(),_c=a("p"),_c.innerHTML=lv,sf=n(),p(es.$$.fragment),nf=n(),bc=a("div"),p(fo.$$.fragment),pg=n(),ne=a("div"),p(_o.$$.fragment),of=n(),yc=a("p"),yc.innerHTML=cv,rf=n(),p(ts.$$.fragment),af=n(),Tc=a("div"),p(bo.$$.fragment),mg=n(),oe=a("div"),p(yo.$$.fragment),lf=n(),vc=a("p"),vc.innerHTML=iv,cf=n(),p(ss.$$.fragment),df=n(),Mc=a("div"),p(To.$$.fragment),gg=n(),re=a("div"),p(vo.$$.fragment),pf=n(),wc=a("p"),wc.innerHTML=dv,mf=n(),p(ns.$$.fragment),gf=n(),$c=a("div"),p(Mo.$$.fragment),ug=n(),Ue=a("div"),p(wo.$$.fragment),uf=n(),kc=a("p"),kc.innerHTML=pv,hf=n(),jc=a("div"),p($o.$$.fragment),hg=n(),L=a("div"),p(ko.$$.fragment),ff=n(),xc=a("p"),xc.innerHTML=mv,_f=n(),Jc=a("p"),Jc.innerHTML=gv,bf=n(),Uc=a("p"),Uc.innerHTML=uv,yf=n(),p(os.$$.fragment),Tf=n(),Bc=a("div"),p(jo.$$.fragment),fg=n(),ae=a("div"),p(xo.$$.fragment),vf=n(),Ic=a("p"),Ic.innerHTML=hv,Mf=n(),Zc=a("p"),Zc.innerHTML=fv,wf=n(),zc=a("div"),p(Jo.$$.fragment),_g=n(),le=a("div"),p(Uo.$$.fragment),$f=n(),Wc=a("p"),Wc.innerHTML=_v,kf=n(),p(rs.$$.fragment),jf=n(),Lc=a("div"),p(Bo.$$.fragment),bg=n(),Be=a("div"),p(Io.$$.fragment),xf=n(),Cc=a("p"),Cc.textContent=bv,Jf=n(),Vc=a("div"),p(Zo.$$.fragment),yg=n(),Ie=a("div"),p(zo.$$.fragment),Uf=n(),Fc=a("p"),Fc.innerHTML=yv,Bf=n(),Gc=a("div"),p(Wo.$$.fragment),Tg=n(),Ze=a("div"),p(Lo.$$.fragment),If=n(),Xc=a("p"),Xc.textContent=Tv,Zf=n(),Rc=a("div"),p(Co.$$.fragment),vg=n(),ce=a("div"),p(Vo.$$.fragment),zf=n(),Sc=a("p"),Sc.innerHTML=vv,Wf=n(),p(as.$$.fragment),Lf=n(),Nc=a("div"),p(Fo.$$.fragment),Mg=n(),ie=a("div"),p(Go.$$.fragment),Cf=n(),Ec=a("p"),Ec.innerHTML=Mv,Vf=n(),p(ls.$$.fragment),Ff=n(),Hc=a("div"),p(Xo.$$.fragment),wg=n(),S=a("div"),p(Ro.$$.fragment),Gf=n(),qc=a("p"),qc.innerHTML=wv,Xf=n(),p(cs.$$.fragment),Rf=n(),p(is.$$.fragment),Sf=n(),Dc=a("div"),p(So.$$.fragment),$g=n(),N=a("div"),p(No.$$.fragment),Nf=n(),Pc=a("p"),Pc.innerHTML=$v,Ef=n(),p(ds.$$.fragment),Hf=n(),p(ps.$$.fragment),qf=n(),Qc=a("div"),p(Eo.$$.fragment),kg=n(),de=a("div"),p(Ho.$$.fragment),Df=n(),Yc=a("p"),Yc.innerHTML=kv,Pf=n(),p(ms.$$.fragment),Qf=n(),Ac=a("div"),p(qo.$$.fragment),jg=n(),E=a("div"),p(Do.$$.fragment),Yf=n(),Oc=a("p"),Oc.innerHTML=jv,Af=n(),Kc=a("p"),Kc.innerHTML=xv,Of=n(),p(gs.$$.fragment),Kf=n(),ei=a("div"),p(Po.$$.fragment),xg=n(),H=a("div"),p(Qo.$$.fragment),e_=n(),ti=a("p"),ti.innerHTML=Jv,t_=n(),p(us.$$.fragment),s_=n(),p(hs.$$.fragment),n_=n(),si=a("div"),p(Yo.$$.fragment),Jg=n(),pe=a("div"),p(Ao.$$.fragment),o_=n(),ni=a("p"),ni.innerHTML=Uv,r_=n(),p(fs.$$.fragment),a_=n(),oi=a("div"),p(Oo.$$.fragment),Ug=n(),me=a("div"),p(Ko.$$.fragment),l_=n(),ri=a("p"),ri.innerHTML=Bv,c_=n(),p(_s.$$.fragment),i_=n(),ai=a("div"),p(er.$$.fragment),Bg=n(),q=a("div"),p(tr.$$.fragment),d_=n(),li=a("p"),li.innerHTML=Iv,p_=n(),p(bs.$$.fragment),m_=n(),p(ys.$$.fragment),g_=n(),ci=a("div"),p(sr.$$.fragment),Ig=n(),ge=a("div"),p(nr.$$.fragment),u_=n(),ii=a("p"),ii.innerHTML=Zv,h_=n(),p(Ts.$$.fragment),f_=n(),di=a("div"),p(or.$$.fragment),Zg=n(),ue=a("div"),p(rr.$$.fragment),__=n(),pi=a("p"),pi.innerHTML=zv,b_=n(),p(vs.$$.fragment),y_=n(),mi=a("div"),p(ar.$$.fragment),zg=n(),D=a("div"),p(lr.$$.fragment),T_=n(),gi=a("p"),gi.innerHTML=Wv,v_=n(),ui=a("p"),ui.innerHTML=Lv,M_=n(),p(Ms.$$.fragment),w_=n(),hi=a("div"),p(cr.$$.fragment),Wg=n(),P=a("div"),p(ir.$$.fragment),$_=n(),fi=a("p"),fi.innerHTML=Cv,k_=n(),_i=a("p"),_i.innerHTML=Vv,j_=n(),p(ws.$$.fragment),x_=n(),bi=a("div"),p(dr.$$.fragment),Lg=n(),Q=a("div"),p(pr.$$.fragment),J_=n(),yi=a("p"),yi.innerHTML=Fv,U_=n(),Ti=a("p"),Ti.innerHTML=Gv,B_=n(),p($s.$$.fragment),I_=n(),vi=a("div"),p(mr.$$.fragment),Cg=n(),p(gr.$$.fragment),Vg=n(),ze=a("div"),p(ur.$$.fragment),Z_=n(),Mi=a("p"),Mi.innerHTML=Xv,z_=n(),wi=a("div"),p(hr.$$.fragment),Fg=n(),We=a("div"),p(fr.$$.fragment),W_=n(),$i=a("p"),$i.innerHTML=Rv,L_=n(),ki=a("div"),p(_r.$$.fragment),Gg=n(),Le=a("div"),p(br.$$.fragment),C_=n(),ji=a("p"),ji.innerHTML=Sv,V_=n(),xi=a("div"),p(yr.$$.fragment),Xg=n(),Ce=a("div"),p(Tr.$$.fragment),F_=n(),Ji=a("p"),Ji.textContent=Nv,G_=n(),ks=a("div"),p(vr.$$.fragment),X_=n(),Ui=a("p"),Ui.textContent=Ev,Rg=n(),Ve=a("div"),p(Mr.$$.fragment),R_=n(),Bi=a("p"),Bi.innerHTML=Hv,S_=n(),Ii=a("div"),p(wr.$$.fragment),Sg=n(),Fe=a("div"),p($r.$$.fragment),N_=n(),Zi=a("p"),Zi.textContent=qv,E_=n(),js=a("div"),p(kr.$$.fragment),H_=n(),zi=a("p"),zi.textContent=Dv,Ng=n(),Ge=a("div"),p(jr.$$.fragment),q_=n(),Wi=a("p"),Wi.innerHTML=Pv,D_=n(),Li=a("div"),p(xr.$$.fragment),Eg=n(),Xe=a("div"),p(Jr.$$.fragment),P_=n(),Ci=a("p"),Ci.innerHTML=Qv,Q_=n(),Vi=a("div"),p(Ur.$$.fragment),Hg=n(),Re=a("div"),p(Br.$$.fragment),Y_=n(),Fi=a("p"),Fi.innerHTML=Yv,A_=n(),Gi=a("div"),p(Ir.$$.fragment),qg=n(),Se=a("div"),p(Zr.$$.fragment),O_=n(),Xi=a("p"),Xi.innerHTML=Av,K_=n(),Ri=a("div"),p(zr.$$.fragment),Dg=n(),Ne=a("div"),p(Wr.$$.fragment),eb=n(),Si=a("p"),Si.innerHTML=Ov,tb=n(),Ni=a("div"),p(Lr.$$.fragment),Pg=n(),Ee=a("div"),p(Cr.$$.fragment),sb=n(),Ei=a("p"),Ei.innerHTML=Kv,nb=n(),Hi=a("div"),p(Vr.$$.fragment),Qg=n(),He=a("div"),p(Fr.$$.fragment),ob=n(),qi=a("p"),qi.innerHTML=eM,rb=n(),Di=a("div"),p(Gr.$$.fragment),Yg=n(),qe=a("div"),p(Xr.$$.fragment),ab=n(),Pi=a("p"),Pi.innerHTML=tM,lb=n(),Qi=a("div"),p(Rr.$$.fragment),Ag=n(),De=a("div"),p(Sr.$$.fragment),cb=n(),Yi=a("p"),Yi.innerHTML=sM,ib=n(),Ai=a("div"),p(Nr.$$.fragment),Og=n(),p(Er.$$.fragment),Kg=n(),Pe=a("div"),p(Hr.$$.fragment),db=n(),Oi=a("p"),Oi.innerHTML=nM,pb=n(),Ki=a("div"),p(qr.$$.fragment),eu=n(),Qe=a("div"),p(Dr.$$.fragment),mb=n(),ed=a("p"),ed.innerHTML=oM,gb=n(),td=a("div"),p(Pr.$$.fragment),tu=n(),Ye=a("div"),p(Qr.$$.fragment),ub=n(),sd=a("p"),sd.innerHTML=rM,hb=n(),nd=a("div"),p(Yr.$$.fragment),su=n(),Ae=a("div"),p(Ar.$$.fragment),fb=n(),od=a("p"),od.textContent=aM,_b=n(),xs=a("div"),p(Or.$$.fragment),bb=n(),rd=a("p"),rd.textContent=lM,nu=n(),Oe=a("div"),p(Kr.$$.fragment),yb=n(),ad=a("p"),ad.innerHTML=cM,Tb=n(),ld=a("div"),p(ea.$$.fragment),ou=n(),Ke=a("div"),p(ta.$$.fragment),vb=n(),cd=a("p"),cd.textContent=iM,Mb=n(),Js=a("div"),p(sa.$$.fragment),wb=n(),id=a("p"),id.textContent=dM,ru=n(),et=a("div"),p(na.$$.fragment),$b=n(),dd=a("p"),dd.innerHTML=pM,kb=n(),pd=a("div"),p(oa.$$.fragment),au=n(),tt=a("div"),p(ra.$$.fragment),jb=n(),md=a("p"),md.innerHTML=mM,xb=n(),gd=a("div"),p(aa.$$.fragment),lu=n(),st=a("div"),p(la.$$.fragment),Jb=n(),ud=a("p"),ud.innerHTML=gM,Ub=n(),hd=a("div"),p(ca.$$.fragment),cu=n(),nt=a("div"),p(ia.$$.fragment),Bb=n(),fd=a("p"),fd.innerHTML=uM,Ib=n(),_d=a("div"),p(da.$$.fragment),iu=n(),ot=a("div"),p(pa.$$.fragment),Zb=n(),bd=a("p"),bd.innerHTML=hM,zb=n(),yd=a("div"),p(ma.$$.fragment),du=n(),rt=a("div"),p(ga.$$.fragment),Wb=n(),Td=a("p"),Td.innerHTML=fM,Lb=n(),vd=a("div"),p(ua.$$.fragment),pu=n(),at=a("div"),p(ha.$$.fragment),Cb=n(),Md=a("p"),Md.innerHTML=_M,Vb=n(),wd=a("div"),p(fa.$$.fragment),mu=n(),p(_a.$$.fragment),gu=n(),ba=a("p"),ba.innerHTML=bM,uu=n(),he=a("div"),p(ya.$$.fragment),Fb=n(),$d=a("p"),$d.textContent=yM,Gb=n(),kd=a("p"),kd.innerHTML=TM,Xb=n(),jd=a("div"),p(Ta.$$.fragment),hu=n(),Gt=a("div"),p(va.$$.fragment),Rb=n(),xd=a("div"),p(Ma.$$.fragment),fu=n(),lt=a("div"),p(wa.$$.fragment),Sb=n(),Jd=a("p"),Jd.innerHTML=vM,Nb=n(),Ud=a("div"),p($a.$$.fragment),_u=n(),ct=a("div"),p(ka.$$.fragment),Eb=n(),Bd=a("p"),Bd.innerHTML=MM,Hb=n(),Id=a("div"),p(ja.$$.fragment),bu=n(),p(xa.$$.fragment),yu=n(),Ja=a("p"),Ja.innerHTML=wM,Tu=n(),U=a("div"),p(Ua.$$.fragment),qb=n(),Zd=a("p"),Zd.textContent=$M,Db=n(),zd=a("p"),zd.textContent=kM,Pb=n(),p(Us.$$.fragment),Qb=n(),Wd=a("p"),Wd.textContent=jM,Yb=n(),Bs=a("div"),p(Ba.$$.fragment),Ab=n(),Ld=a("p"),Ld.textContent=xM,Ob=n(),Is=a("div"),p(Ia.$$.fragment),Kb=n(),Cd=a("p"),Cd.textContent=JM,ey=n(),Zs=a("div"),p(Za.$$.fragment),ty=n(),Vd=a("p"),Vd.textContent=UM,sy=n(),zs=a("div"),p(za.$$.fragment),ny=n(),Fd=a("p"),Fd.innerHTML=BM,oy=n(),Ws=a("div"),p(Wa.$$.fragment),ry=n(),Gd=a("p"),Gd.textContent=IM,ay=n(),Ls=a("div"),p(La.$$.fragment),ly=n(),Xd=a("p"),Xd.textContent=ZM,cy=n(),ht=a("div"),p(Ca.$$.fragment),iy=n(),Rd=a("p"),Rd.innerHTML=zM,dy=n(),Sd=a("p"),Sd.textContent=WM,vu=n(),Xt=a("div"),p(Va.$$.fragment),py=n(),Nd=a("p"),Nd.innerHTML=LM,Mu=n(),Rt=a("div"),p(Fa.$$.fragment),my=n(),Ed=a("p"),Ed.innerHTML=CM,wu=n(),fe=a("div"),p(Ga.$$.fragment),gy=n(),Hd=a("p"),Hd.textContent=VM,uy=n(),F=a("div"),p(Xa.$$.fragment),hy=n(),qd=a("p"),qd.textContent=FM,fy=n(),Dd=a("p"),Dd.innerHTML=GM,_y=n(),Pd=a("p"),Pd.innerHTML=XM,by=n(),Qd=a("p"),Qd.innerHTML=RM,yy=n(),Yd=a("p"),Yd.textContent=SM,Ty=n(),Cs=a("div"),p(Ra.$$.fragment),vy=n(),Ad=a("p"),Ad.textContent=NM,$u=n(),p(Sa.$$.fragment),ku=n(),_e=a("div"),p(Na.$$.fragment),My=n(),Od=a("p"),Od.innerHTML=EM,wy=n(),Kd=a("div"),p(Ea.$$.fragment),$y=n(),ep=a("div"),p(Ha.$$.fragment),ju=n(),C=a("div"),p(qa.$$.fragment),ky=n(),tp=a("p"),tp.innerHTML=HM,jy=n(),sp=a("p"),sp.innerHTML=qM,xy=n(),np=a("p"),np.innerHTML=DM,Jy=n(),op=a("div"),p(Da.$$.fragment),Uy=n(),rp=a("div"),p(Pa.$$.fragment),xu=n(),be=a("div"),p(Qa.$$.fragment),By=n(),ap=a("p"),ap.innerHTML=PM,Iy=n(),lp=a("div"),p(Ya.$$.fragment),Zy=n(),cp=a("div"),p(Aa.$$.fragment),Ju=n(),p(Oa.$$.fragment),Uu=n(),z=a("div"),p(Ka.$$.fragment),zy=n(),ip=a("p"),ip.textContent=QM,Wy=n(),p(Vs.$$.fragment),Ly=n(),p(Fs.$$.fragment),Cy=n(),Gs=a("div"),p(el.$$.fragment),Vy=n(),dp=a("p"),dp.textContent=YM,Fy=n(),Xs=a("div"),p(tl.$$.fragment),Gy=n(),pp=a("p"),pp.textContent=AM,Xy=n(),Rs=a("div"),p(sl.$$.fragment),Ry=n(),mp=a("p"),mp.textContent=OM,Bu=n(),Y=a("div"),p(nl.$$.fragment),Sy=n(),gp=a("p"),gp.textContent=KM,Ny=n(),p(Ss.$$.fragment),Ey=n(),p(Ns.$$.fragment),Hy=n(),Es=a("div"),p(ol.$$.fragment),qy=n(),up=a("p"),up.textContent=e0,Iu=n(),p(rl.$$.fragment),Zu=n(),it=a("div"),p(al.$$.fragment),Dy=n(),hp=a("p"),hp.textContent=t0,Py=n(),Hs=a("div"),p(ll.$$.fragment),Qy=n(),fp=a("p"),fp.innerHTML=s0,zu=n(),Z=a("div"),p(cl.$$.fragment),Yy=n(),_p=a("p"),_p.textContent=n0,Ay=n(),bp=a("p"),bp.innerHTML=o0,Oy=n(),qs=a("div"),p(il.$$.fragment),Ky=n(),yp=a("p"),yp.innerHTML=r0,eT=n(),Ds=a("div"),p(dl.$$.fragment),tT=n(),Tp=a("p"),Tp.textContent=a0,sT=n(),Ps=a("div"),p(pl.$$.fragment),nT=n(),vp=a("p"),vp.textContent=l0,oT=n(),Qs=a("div"),p(ml.$$.fragment),rT=n(),Mp=a("p"),Mp.innerHTML=c0,aT=n(),Ys=a("div"),p(gl.$$.fragment),lT=n(),wp=a("p"),wp.innerHTML=i0,Wu=n(),V=a("div"),p(ul.$$.fragment),cT=n(),$p=a("p"),$p.innerHTML=d0,iT=n(),kp=a("p"),kp.innerHTML=p0,dT=n(),As=a("div"),p(hl.$$.fragment),pT=n(),jp=a("p"),jp.innerHTML=m0,mT=n(),Os=a("div"),p(fl.$$.fragment),gT=n(),xp=a("p"),xp.textContent=g0,uT=n(),Ks=a("div"),p(_l.$$.fragment),hT=n(),Jp=a("p"),Jp.textContent=u0,Lu=n(),ye=a("div"),p(bl.$$.fragment),fT=n(),Up=a("p"),Up.innerHTML=h0,_T=n(),en=a("div"),p(yl.$$.fragment),bT=n(),Bp=a("p"),Bp.innerHTML=f0,yT=n(),tn=a("div"),p(Tl.$$.fragment),TT=n(),Ip=a("p"),Ip.innerHTML=_0,Cu=n(),um=a("p"),this.h()},l(e){const c=kw("svelte-u9bgzb",document.head);i=l(c,"META",{name:!0,content:!0}),c.forEach(s),k=o(e),b=l(e,"P",{}),T(b).forEach(s),_=o(e),m(w.$$.fragment,e),r=o(e),$=l(e,"P",{"data-svelte-h":!0}),y($)!=="svelte-11a5dbl"&&($.innerHTML=vT),wm=o(e),m(yn.$$.fragment,e),$m=o(e),Tn=l(e,"P",{"data-svelte-h":!0}),y(Tn)!=="svelte-4rk6a1"&&(Tn.innerHTML=MT),km=o(e),vn=l(e,"P",{"data-svelte-h":!0}),y(vn)!=="svelte-wwwyth"&&(vn.textContent=wT),jm=o(e),m(Mn.$$.fragment,e),xm=o(e),wn=l(e,"P",{"data-svelte-h":!0}),y(wn)!=="svelte-1iau2mm"&&(wn.innerHTML=$T),Jm=o(e),$n=l(e,"UL",{"data-svelte-h":!0}),y($n)!=="svelte-1arpy9m"&&($n.innerHTML=kT),Um=o(e),kn=l(e,"P",{"data-svelte-h":!0}),y(kn)!=="svelte-xh59rv"&&(kn.innerHTML=jT),Bm=o(e),jn=l(e,"P",{"data-svelte-h":!0}),y(jn)!=="svelte-rqavqw"&&(jn.innerHTML=xT),Im=o(e),xn=l(e,"P",{"data-svelte-h":!0}),y(xn)!=="svelte-qr02he"&&(xn.innerHTML=JT),Zm=o(e),m(Jn.$$.fragment,e),zm=o(e),Un=l(e,"P",{"data-svelte-h":!0}),y(Un)!=="svelte-114v74y"&&(Un.innerHTML=UT),Wm=o(e),Bn=l(e,"P",{"data-svelte-h":!0}),y(Bn)!=="svelte-13knclg"&&(Bn.innerHTML=BT),Lm=o(e),In=l(e,"P",{"data-svelte-h":!0}),y(In)!=="svelte-gz8gow"&&(In.textContent=IT),Cm=o(e),m(Zn.$$.fragment,e),Vm=o(e),kt=l(e,"DIV",{class:!0});var vl=T(kt);m(zn.$$.fragment,vl),gh=o(vl),Fl=l(vl,"P",{"data-svelte-h":!0}),y(Fl)!=="svelte-k7oes3"&&(Fl.textContent=ZT),vl.forEach(s),Fm=o(e),jt=l(e,"DIV",{class:!0});var Ml=T(jt);m(Wn.$$.fragment,Ml),uh=o(Ml),Gl=l(Ml,"P",{"data-svelte-h":!0}),y(Gl)!=="svelte-111f3sj"&&(Gl.textContent=zT),Ml.forEach(s),Gm=o(e),xt=l(e,"DIV",{class:!0});var wl=T(xt);m(Ln.$$.fragment,wl),hh=o(wl),Xl=l(wl,"P",{"data-svelte-h":!0}),y(Xl)!=="svelte-1j3b9cp"&&(Xl.textContent=WT),wl.forEach(s),Xm=o(e),Jt=l(e,"DIV",{class:!0});var $l=T(Jt);m(Cn.$$.fragment,$l),fh=o($l),Rl=l($l,"P",{"data-svelte-h":!0}),y(Rl)!=="svelte-16r5px1"&&(Rl.textContent=LT),$l.forEach(s),Rm=o(e),m(Vn.$$.fragment,e),Sm=o(e),Ut=l(e,"DIV",{class:!0});var kl=T(Ut);m(Fn.$$.fragment,kl),_h=o(kl),Sl=l(kl,"P",{"data-svelte-h":!0}),y(Sl)!=="svelte-1bnrp61"&&(Sl.textContent=CT),kl.forEach(s),Nm=o(e),Bt=l(e,"DIV",{class:!0});var jl=T(Bt);m(Gn.$$.fragment,jl),bh=o(jl),Nl=l(jl,"P",{"data-svelte-h":!0}),y(Nl)!=="svelte-fenhkk"&&(Nl.textContent=VT),jl.forEach(s),Em=o(e),It=l(e,"DIV",{class:!0});var xl=T(It);m(Xn.$$.fragment,xl),yh=o(xl),El=l(xl,"P",{"data-svelte-h":!0}),y(El)!=="svelte-1dqtgq4"&&(El.textContent=FT),xl.forEach(s),Hm=o(e),Zt=l(e,"DIV",{class:!0});var Jl=T(Zt);m(Rn.$$.fragment,Jl),Th=o(Jl),Hl=l(Jl,"P",{"data-svelte-h":!0}),y(Hl)!=="svelte-10orfv5"&&(Hl.textContent=GT),Jl.forEach(s),qm=o(e),zt=l(e,"DIV",{class:!0});var Ul=T(zt);m(Sn.$$.fragment,Ul),vh=o(Ul),ql=l(Ul,"P",{"data-svelte-h":!0}),y(ql)!=="svelte-jg8udg"&&(ql.textContent=XT),Ul.forEach(s),Dm=o(e),Wt=l(e,"DIV",{class:!0});var Bl=T(Wt);m(Nn.$$.fragment,Bl),Mh=o(Bl),Dl=l(Bl,"P",{"data-svelte-h":!0}),y(Dl)!=="svelte-1i40667"&&(Dl.textContent=RT),Bl.forEach(s),Pm=o(e),Lt=l(e,"DIV",{class:!0});var Il=T(Lt);m(En.$$.fragment,Il),wh=o(Il),Pl=l(Il,"P",{"data-svelte-h":!0}),y(Pl)!=="svelte-n5fi8x"&&(Pl.textContent=ST),Il.forEach(s),Qm=o(e),Ct=l(e,"DIV",{class:!0});var Zl=T(Ct);m(Hn.$$.fragment,Zl),$h=o(Zl),Ql=l(Zl,"P",{"data-svelte-h":!0}),y(Ql)!=="svelte-h5pj3l"&&(Ql.textContent=NT),Zl.forEach(s),Ym=o(e),Vt=l(e,"DIV",{class:!0});var zl=T(Vt);m(qn.$$.fragment,zl),kh=o(zl),Yl=l(zl,"P",{"data-svelte-h":!0}),y(Yl)!=="svelte-b9zq6n"&&(Yl.textContent=ET),zl.forEach(s),Am=o(e),Ft=l(e,"DIV",{class:!0});var Wl=T(Ft);m(Dn.$$.fragment,Wl),jh=o(Wl),Al=l(Wl,"P",{"data-svelte-h":!0}),y(Al)!=="svelte-pru3ks"&&(Al.textContent=HT),Wl.forEach(s),Om=o(e),m(Pn.$$.fragment,e),Km=o(e),je=l(e,"DIV",{class:!0});var St=T(je);m(Qn.$$.fragment,St),xh=o(St),Ol=l(St,"P",{"data-svelte-h":!0}),y(Ol)!=="svelte-qoov36"&&(Ol.textContent=qT),Jh=o(St),Ht=l(St,"DIV",{class:!0});var Ll=T(Ht);m(Yn.$$.fragment,Ll),Uh=o(Ll),Kl=l(Ll,"P",{"data-svelte-h":!0}),y(Kl)!=="svelte-5ihtpa"&&(Kl.textContent=DT),Ll.forEach(s),St.forEach(s),eg=o(e),xe=l(e,"DIV",{class:!0});var Nt=T(xe);m(An.$$.fragment,Nt),Bh=o(Nt),ec=l(Nt,"P",{"data-svelte-h":!0}),y(ec)!=="svelte-1tz7qrd"&&(ec.textContent=PT),Ih=o(Nt),qt=l(Nt,"DIV",{class:!0});var Cl=T(qt);m(On.$$.fragment,Cl),Zh=o(Cl),tc=l(Cl,"P",{"data-svelte-h":!0}),y(tc)!=="svelte-5ihtpa"&&(tc.textContent=QT),Cl.forEach(s),Nt.forEach(s),tg=o(e),Je=l(e,"DIV",{class:!0});var Et=T(Je);m(Kn.$$.fragment,Et),zh=o(Et),sc=l(Et,"P",{"data-svelte-h":!0}),y(sc)!=="svelte-1tz7qrd"&&(sc.textContent=YT),Wh=o(Et),Dt=l(Et,"DIV",{class:!0});var Vl=T(Dt);m(eo.$$.fragment,Vl),Lh=o(Vl),nc=l(Vl,"P",{"data-svelte-h":!0}),y(nc)!=="svelte-5ihtpa"&&(nc.textContent=AT),Vl.forEach(s),Et.forEach(s),sg=o(e),m(to.$$.fragment,e),ng=o(e),so=l(e,"P",{"data-svelte-h":!0}),y(so)!=="svelte-ov9xew"&&(so.innerHTML=OT),og=o(e),m(no.$$.fragment,e),rg=o(e),ee=l(e,"DIV",{class:!0});var dt=T(ee);m(oo.$$.fragment,dt),Ch=o(dt),oc=l(dt,"P",{"data-svelte-h":!0}),y(oc)!=="svelte-ejyvcf"&&(oc.innerHTML=KT),Vh=o(dt),m(Pt.$$.fragment,dt),Fh=o(dt),rc=l(dt,"DIV",{class:!0});var hm=T(rc);m(ro.$$.fragment,hm),hm.forEach(s),dt.forEach(s),ag=o(e),W=l(e,"DIV",{class:!0});var A=T(W);m(ao.$$.fragment,A),Gh=o(A),ac=l(A,"P",{"data-svelte-h":!0}),y(ac)!=="svelte-1yqc81m"&&(ac.innerHTML=ev),Xh=o(A),lc=l(A,"P",{"data-svelte-h":!0}),y(lc)!=="svelte-lu7kru"&&(lc.innerHTML=tv),Rh=o(A),m(Qt.$$.fragment,A),Sh=o(A),m(Yt.$$.fragment,A),Nh=o(A),cc=l(A,"DIV",{class:!0});var fm=T(cc);m(lo.$$.fragment,fm),fm.forEach(s),A.forEach(s),lg=o(e),X=l(e,"DIV",{class:!0});var Te=T(X);m(co.$$.fragment,Te),Eh=o(Te),ic=l(Te,"P",{"data-svelte-h":!0}),y(ic)!=="svelte-wr3pat"&&(ic.innerHTML=sv),Hh=o(Te),dc=l(Te,"P",{"data-svelte-h":!0}),y(dc)!=="svelte-mpy00q"&&(dc.textContent=nv),qh=o(Te),m(At.$$.fragment,Te),Dh=o(Te),pc=l(Te,"DIV",{class:!0});var _m=T(pc);m(io.$$.fragment,_m),_m.forEach(s),Te.forEach(s),cg=o(e),R=l(e,"DIV",{class:!0});var ve=T(R);m(po.$$.fragment,ve),Ph=o(ve),mc=l(ve,"P",{"data-svelte-h":!0}),y(mc)!=="svelte-xmww4r"&&(mc.innerHTML=ov),Qh=o(ve),gc=l(ve,"P",{"data-svelte-h":!0}),y(gc)!=="svelte-3qpgm7"&&(gc.textContent=rv),Yh=o(ve),m(Ot.$$.fragment,ve),Ah=o(ve),uc=l(ve,"DIV",{class:!0});var bm=T(uc);m(mo.$$.fragment,bm),bm.forEach(s),ve.forEach(s),ig=o(e),te=l(e,"DIV",{class:!0});var pt=T(te);m(go.$$.fragment,pt),Oh=o(pt),hc=l(pt,"P",{"data-svelte-h":!0}),y(hc)!=="svelte-nxnrcl"&&(hc.innerHTML=av),Kh=o(pt),m(Kt.$$.fragment,pt),ef=o(pt),fc=l(pt,"DIV",{class:!0});var ym=T(fc);m(uo.$$.fragment,ym),ym.forEach(s),pt.forEach(s),dg=o(e),se=l(e,"DIV",{class:!0});var mt=T(se);m(ho.$$.fragment,mt),tf=o(mt),_c=l(mt,"P",{"data-svelte-h":!0}),y(_c)!=="svelte-ahzcw9"&&(_c.innerHTML=lv),sf=o(mt),m(es.$$.fragment,mt),nf=o(mt),bc=l(mt,"DIV",{class:!0});var Tm=T(bc);m(fo.$$.fragment,Tm),Tm.forEach(s),mt.forEach(s),pg=o(e),ne=l(e,"DIV",{class:!0});var gt=T(ne);m(_o.$$.fragment,gt),of=o(gt),yc=l(gt,"P",{"data-svelte-h":!0}),y(yc)!=="svelte-yqcpuw"&&(yc.innerHTML=cv),rf=o(gt),m(ts.$$.fragment,gt),af=o(gt),Tc=l(gt,"DIV",{class:!0});var vm=T(Tc);m(bo.$$.fragment,vm),vm.forEach(s),gt.forEach(s),mg=o(e),oe=l(e,"DIV",{class:!0});var ut=T(oe);m(yo.$$.fragment,ut),lf=o(ut),vc=l(ut,"P",{"data-svelte-h":!0}),y(vc)!=="svelte-v3jsck"&&(vc.innerHTML=iv),cf=o(ut),m(ss.$$.fragment,ut),df=o(ut),Mc=l(ut,"DIV",{class:!0});var Mm=T(Mc);m(To.$$.fragment,Mm),Mm.forEach(s),ut.forEach(s),gg=o(e),re=l(e,"DIV",{class:!0});var sn=T(re);m(vo.$$.fragment,sn),pf=o(sn),wc=l(sn,"P",{"data-svelte-h":!0}),y(wc)!=="svelte-zzzbx4"&&(wc.innerHTML=dv),mf=o(sn),m(ns.$$.fragment,sn),gf=o(sn),$c=l(sn,"DIV",{class:!0});var b0=T($c);m(Mo.$$.fragment,b0),b0.forEach(s),sn.forEach(s),ug=o(e),Ue=l(e,"DIV",{class:!0});var Zp=T(Ue);m(wo.$$.fragment,Zp),uf=o(Zp),kc=l(Zp,"P",{"data-svelte-h":!0}),y(kc)!=="svelte-lpfxi8"&&(kc.innerHTML=pv),hf=o(Zp),jc=l(Zp,"DIV",{class:!0});var y0=T(jc);m($o.$$.fragment,y0),y0.forEach(s),Zp.forEach(s),hg=o(e),L=l(e,"DIV",{class:!0});var Me=T(L);m(ko.$$.fragment,Me),ff=o(Me),xc=l(Me,"P",{"data-svelte-h":!0}),y(xc)!=="svelte-xw4pee"&&(xc.innerHTML=mv),_f=o(Me),Jc=l(Me,"P",{"data-svelte-h":!0}),y(Jc)!=="svelte-wp24j3"&&(Jc.innerHTML=gv),bf=o(Me),Uc=l(Me,"P",{"data-svelte-h":!0}),y(Uc)!=="svelte-2fpu88"&&(Uc.innerHTML=uv),yf=o(Me),m(os.$$.fragment,Me),Tf=o(Me),Bc=l(Me,"DIV",{class:!0});var T0=T(Bc);m(jo.$$.fragment,T0),T0.forEach(s),Me.forEach(s),fg=o(e),ae=l(e,"DIV",{class:!0});var nn=T(ae);m(xo.$$.fragment,nn),vf=o(nn),Ic=l(nn,"P",{"data-svelte-h":!0}),y(Ic)!=="svelte-1i9mqc9"&&(Ic.innerHTML=hv),Mf=o(nn),Zc=l(nn,"P",{"data-svelte-h":!0}),y(Zc)!=="svelte-1v3r596"&&(Zc.innerHTML=fv),wf=o(nn),zc=l(nn,"DIV",{class:!0});var v0=T(zc);m(Jo.$$.fragment,v0),v0.forEach(s),nn.forEach(s),_g=o(e),le=l(e,"DIV",{class:!0});var on=T(le);m(Uo.$$.fragment,on),$f=o(on),Wc=l(on,"P",{"data-svelte-h":!0}),y(Wc)!=="svelte-197kki3"&&(Wc.innerHTML=_v),kf=o(on),m(rs.$$.fragment,on),jf=o(on),Lc=l(on,"DIV",{class:!0});var M0=T(Lc);m(Bo.$$.fragment,M0),M0.forEach(s),on.forEach(s),bg=o(e),Be=l(e,"DIV",{class:!0});var zp=T(Be);m(Io.$$.fragment,zp),xf=o(zp),Cc=l(zp,"P",{"data-svelte-h":!0}),y(Cc)!=="svelte-y1kta5"&&(Cc.textContent=bv),Jf=o(zp),Vc=l(zp,"DIV",{class:!0});var w0=T(Vc);m(Zo.$$.fragment,w0),w0.forEach(s),zp.forEach(s),yg=o(e),Ie=l(e,"DIV",{class:!0});var Wp=T(Ie);m(zo.$$.fragment,Wp),Uf=o(Wp),Fc=l(Wp,"P",{"data-svelte-h":!0}),y(Fc)!=="svelte-ep4n57"&&(Fc.innerHTML=yv),Bf=o(Wp),Gc=l(Wp,"DIV",{class:!0});var $0=T(Gc);m(Wo.$$.fragment,$0),$0.forEach(s),Wp.forEach(s),Tg=o(e),Ze=l(e,"DIV",{class:!0});var Lp=T(Ze);m(Lo.$$.fragment,Lp),If=o(Lp),Xc=l(Lp,"P",{"data-svelte-h":!0}),y(Xc)!=="svelte-th82mu"&&(Xc.textContent=Tv),Zf=o(Lp),Rc=l(Lp,"DIV",{class:!0});var k0=T(Rc);m(Co.$$.fragment,k0),k0.forEach(s),Lp.forEach(s),vg=o(e),ce=l(e,"DIV",{class:!0});var rn=T(ce);m(Vo.$$.fragment,rn),zf=o(rn),Sc=l(rn,"P",{"data-svelte-h":!0}),y(Sc)!=="svelte-fq38g4"&&(Sc.innerHTML=vv),Wf=o(rn),m(as.$$.fragment,rn),Lf=o(rn),Nc=l(rn,"DIV",{class:!0});var j0=T(Nc);m(Fo.$$.fragment,j0),j0.forEach(s),rn.forEach(s),Mg=o(e),ie=l(e,"DIV",{class:!0});var an=T(ie);m(Go.$$.fragment,an),Cf=o(an),Ec=l(an,"P",{"data-svelte-h":!0}),y(Ec)!=="svelte-541tib"&&(Ec.innerHTML=Mv),Vf=o(an),m(ls.$$.fragment,an),Ff=o(an),Hc=l(an,"DIV",{class:!0});var x0=T(Hc);m(Xo.$$.fragment,x0),x0.forEach(s),an.forEach(s),wg=o(e),S=l(e,"DIV",{class:!0});var ft=T(S);m(Ro.$$.fragment,ft),Gf=o(ft),qc=l(ft,"P",{"data-svelte-h":!0}),y(qc)!=="svelte-n26qtg"&&(qc.innerHTML=wv),Xf=o(ft),m(cs.$$.fragment,ft),Rf=o(ft),m(is.$$.fragment,ft),Sf=o(ft),Dc=l(ft,"DIV",{class:!0});var J0=T(Dc);m(So.$$.fragment,J0),J0.forEach(s),ft.forEach(s),$g=o(e),N=l(e,"DIV",{class:!0});var _t=T(N);m(No.$$.fragment,_t),Nf=o(_t),Pc=l(_t,"P",{"data-svelte-h":!0}),y(Pc)!=="svelte-uh8per"&&(Pc.innerHTML=$v),Ef=o(_t),m(ds.$$.fragment,_t),Hf=o(_t),m(ps.$$.fragment,_t),qf=o(_t),Qc=l(_t,"DIV",{class:!0});var U0=T(Qc);m(Eo.$$.fragment,U0),U0.forEach(s),_t.forEach(s),kg=o(e),de=l(e,"DIV",{class:!0});var ln=T(de);m(Ho.$$.fragment,ln),Df=o(ln),Yc=l(ln,"P",{"data-svelte-h":!0}),y(Yc)!=="svelte-15nbnjg"&&(Yc.innerHTML=kv),Pf=o(ln),m(ms.$$.fragment,ln),Qf=o(ln),Ac=l(ln,"DIV",{class:!0});var B0=T(Ac);m(qo.$$.fragment,B0),B0.forEach(s),ln.forEach(s),jg=o(e),E=l(e,"DIV",{class:!0});var bt=T(E);m(Do.$$.fragment,bt),Yf=o(bt),Oc=l(bt,"P",{"data-svelte-h":!0}),y(Oc)!=="svelte-17zwt2k"&&(Oc.innerHTML=jv),Af=o(bt),Kc=l(bt,"P",{"data-svelte-h":!0}),y(Kc)!=="svelte-qhda5i"&&(Kc.innerHTML=xv),Of=o(bt),m(gs.$$.fragment,bt),Kf=o(bt),ei=l(bt,"DIV",{class:!0});var I0=T(ei);m(Po.$$.fragment,I0),I0.forEach(s),bt.forEach(s),xg=o(e),H=l(e,"DIV",{class:!0});var yt=T(H);m(Qo.$$.fragment,yt),e_=o(yt),ti=l(yt,"P",{"data-svelte-h":!0}),y(ti)!=="svelte-ymltj5"&&(ti.innerHTML=Jv),t_=o(yt),m(us.$$.fragment,yt),s_=o(yt),m(hs.$$.fragment,yt),n_=o(yt),si=l(yt,"DIV",{class:!0});var Z0=T(si);m(Yo.$$.fragment,Z0),Z0.forEach(s),yt.forEach(s),Jg=o(e),pe=l(e,"DIV",{class:!0});var cn=T(pe);m(Ao.$$.fragment,cn),o_=o(cn),ni=l(cn,"P",{"data-svelte-h":!0}),y(ni)!=="svelte-1gtj6il"&&(ni.innerHTML=Uv),r_=o(cn),m(fs.$$.fragment,cn),a_=o(cn),oi=l(cn,"DIV",{class:!0});var z0=T(oi);m(Oo.$$.fragment,z0),z0.forEach(s),cn.forEach(s),Ug=o(e),me=l(e,"DIV",{class:!0});var dn=T(me);m(Ko.$$.fragment,dn),l_=o(dn),ri=l(dn,"P",{"data-svelte-h":!0}),y(ri)!=="svelte-kp6ubc"&&(ri.innerHTML=Bv),c_=o(dn),m(_s.$$.fragment,dn),i_=o(dn),ai=l(dn,"DIV",{class:!0});var W0=T(ai);m(er.$$.fragment,W0),W0.forEach(s),dn.forEach(s),Bg=o(e),q=l(e,"DIV",{class:!0});var Tt=T(q);m(tr.$$.fragment,Tt),d_=o(Tt),li=l(Tt,"P",{"data-svelte-h":!0}),y(li)!=="svelte-dy0z4a"&&(li.innerHTML=Iv),p_=o(Tt),m(bs.$$.fragment,Tt),m_=o(Tt),m(ys.$$.fragment,Tt),g_=o(Tt),ci=l(Tt,"DIV",{class:!0});var L0=T(ci);m(sr.$$.fragment,L0),L0.forEach(s),Tt.forEach(s),Ig=o(e),ge=l(e,"DIV",{class:!0});var pn=T(ge);m(nr.$$.fragment,pn),u_=o(pn),ii=l(pn,"P",{"data-svelte-h":!0}),y(ii)!=="svelte-8lsij8"&&(ii.innerHTML=Zv),h_=o(pn),m(Ts.$$.fragment,pn),f_=o(pn),di=l(pn,"DIV",{class:!0});var C0=T(di);m(or.$$.fragment,C0),C0.forEach(s),pn.forEach(s),Zg=o(e),ue=l(e,"DIV",{class:!0});var mn=T(ue);m(rr.$$.fragment,mn),__=o(mn),pi=l(mn,"P",{"data-svelte-h":!0}),y(pi)!=="svelte-qib4gc"&&(pi.innerHTML=zv),b_=o(mn),m(vs.$$.fragment,mn),y_=o(mn),mi=l(mn,"DIV",{class:!0});var V0=T(mi);m(ar.$$.fragment,V0),V0.forEach(s),mn.forEach(s),zg=o(e),D=l(e,"DIV",{class:!0});var vt=T(D);m(lr.$$.fragment,vt),T_=o(vt),gi=l(vt,"P",{"data-svelte-h":!0}),y(gi)!=="svelte-ufnf8b"&&(gi.innerHTML=Wv),v_=o(vt),ui=l(vt,"P",{"data-svelte-h":!0}),y(ui)!=="svelte-1qmimno"&&(ui.innerHTML=Lv),M_=o(vt),m(Ms.$$.fragment,vt),w_=o(vt),hi=l(vt,"DIV",{class:!0});var F0=T(hi);m(cr.$$.fragment,F0),F0.forEach(s),vt.forEach(s),Wg=o(e),P=l(e,"DIV",{class:!0});var Mt=T(P);m(ir.$$.fragment,Mt),$_=o(Mt),fi=l(Mt,"P",{"data-svelte-h":!0}),y(fi)!=="svelte-1dewsn6"&&(fi.innerHTML=Cv),k_=o(Mt),_i=l(Mt,"P",{"data-svelte-h":!0}),y(_i)!=="svelte-5qs7tv"&&(_i.innerHTML=Vv),j_=o(Mt),m(ws.$$.fragment,Mt),x_=o(Mt),bi=l(Mt,"DIV",{class:!0});var G0=T(bi);m(dr.$$.fragment,G0),G0.forEach(s),Mt.forEach(s),Lg=o(e),Q=l(e,"DIV",{class:!0});var wt=T(Q);m(pr.$$.fragment,wt),J_=o(wt),yi=l(wt,"P",{"data-svelte-h":!0}),y(yi)!=="svelte-1pt6cni"&&(yi.innerHTML=Fv),U_=o(wt),Ti=l(wt,"P",{"data-svelte-h":!0}),y(Ti)!=="svelte-qmmn5t"&&(Ti.innerHTML=Gv),B_=o(wt),m($s.$$.fragment,wt),I_=o(wt),vi=l(wt,"DIV",{class:!0});var X0=T(vi);m(mr.$$.fragment,X0),X0.forEach(s),wt.forEach(s),Cg=o(e),m(gr.$$.fragment,e),Vg=o(e),ze=l(e,"DIV",{class:!0});var Cp=T(ze);m(ur.$$.fragment,Cp),Z_=o(Cp),Mi=l(Cp,"P",{"data-svelte-h":!0}),y(Mi)!=="svelte-1jjyp3g"&&(Mi.innerHTML=Xv),z_=o(Cp),wi=l(Cp,"DIV",{class:!0});var R0=T(wi);m(hr.$$.fragment,R0),R0.forEach(s),Cp.forEach(s),Fg=o(e),We=l(e,"DIV",{class:!0});var Vp=T(We);m(fr.$$.fragment,Vp),W_=o(Vp),$i=l(Vp,"P",{"data-svelte-h":!0}),y($i)!=="svelte-g3yz20"&&($i.innerHTML=Rv),L_=o(Vp),ki=l(Vp,"DIV",{class:!0});var S0=T(ki);m(_r.$$.fragment,S0),S0.forEach(s),Vp.forEach(s),Gg=o(e),Le=l(e,"DIV",{class:!0});var Fp=T(Le);m(br.$$.fragment,Fp),C_=o(Fp),ji=l(Fp,"P",{"data-svelte-h":!0}),y(ji)!=="svelte-1557waw"&&(ji.innerHTML=Sv),V_=o(Fp),xi=l(Fp,"DIV",{class:!0});var N0=T(xi);m(yr.$$.fragment,N0),N0.forEach(s),Fp.forEach(s),Xg=o(e),Ce=l(e,"DIV",{class:!0});var Gp=T(Ce);m(Tr.$$.fragment,Gp),F_=o(Gp),Ji=l(Gp,"P",{"data-svelte-h":!0}),y(Ji)!=="svelte-y1kta5"&&(Ji.textContent=Nv),G_=o(Gp),ks=l(Gp,"DIV",{class:!0});var Fu=T(ks);m(vr.$$.fragment,Fu),X_=o(Fu),Ui=l(Fu,"P",{"data-svelte-h":!0}),y(Ui)!=="svelte-5aspnb"&&(Ui.textContent=Ev),Fu.forEach(s),Gp.forEach(s),Rg=o(e),Ve=l(e,"DIV",{class:!0});var Xp=T(Ve);m(Mr.$$.fragment,Xp),R_=o(Xp),Bi=l(Xp,"P",{"data-svelte-h":!0}),y(Bi)!=="svelte-18wpk1v"&&(Bi.innerHTML=Hv),S_=o(Xp),Ii=l(Xp,"DIV",{class:!0});var E0=T(Ii);m(wr.$$.fragment,E0),E0.forEach(s),Xp.forEach(s),Sg=o(e),Fe=l(e,"DIV",{class:!0});var Rp=T(Fe);m($r.$$.fragment,Rp),N_=o(Rp),Zi=l(Rp,"P",{"data-svelte-h":!0}),y(Zi)!=="svelte-th82mu"&&(Zi.textContent=qv),E_=o(Rp),js=l(Rp,"DIV",{class:!0});var Gu=T(js);m(kr.$$.fragment,Gu),H_=o(Gu),zi=l(Gu,"P",{"data-svelte-h":!0}),y(zi)!=="svelte-hcoglc"&&(zi.textContent=Dv),Gu.forEach(s),Rp.forEach(s),Ng=o(e),Ge=l(e,"DIV",{class:!0});var Sp=T(Ge);m(jr.$$.fragment,Sp),q_=o(Sp),Wi=l(Sp,"P",{"data-svelte-h":!0}),y(Wi)!=="svelte-1m7x3l0"&&(Wi.innerHTML=Pv),D_=o(Sp),Li=l(Sp,"DIV",{class:!0});var H0=T(Li);m(xr.$$.fragment,H0),H0.forEach(s),Sp.forEach(s),Eg=o(e),Xe=l(e,"DIV",{class:!0});var Np=T(Xe);m(Jr.$$.fragment,Np),P_=o(Np),Ci=l(Np,"P",{"data-svelte-h":!0}),y(Ci)!=="svelte-155r707"&&(Ci.innerHTML=Qv),Q_=o(Np),Vi=l(Np,"DIV",{class:!0});var q0=T(Vi);m(Ur.$$.fragment,q0),q0.forEach(s),Np.forEach(s),Hg=o(e),Re=l(e,"DIV",{class:!0});var Ep=T(Re);m(Br.$$.fragment,Ep),Y_=o(Ep),Fi=l(Ep,"P",{"data-svelte-h":!0}),y(Fi)!=="svelte-1e63jef"&&(Fi.innerHTML=Yv),A_=o(Ep),Gi=l(Ep,"DIV",{class:!0});var D0=T(Gi);m(Ir.$$.fragment,D0),D0.forEach(s),Ep.forEach(s),qg=o(e),Se=l(e,"DIV",{class:!0});var Hp=T(Se);m(Zr.$$.fragment,Hp),O_=o(Hp),Xi=l(Hp,"P",{"data-svelte-h":!0}),y(Xi)!=="svelte-1s08ha8"&&(Xi.innerHTML=Av),K_=o(Hp),Ri=l(Hp,"DIV",{class:!0});var P0=T(Ri);m(zr.$$.fragment,P0),P0.forEach(s),Hp.forEach(s),Dg=o(e),Ne=l(e,"DIV",{class:!0});var qp=T(Ne);m(Wr.$$.fragment,qp),eb=o(qp),Si=l(qp,"P",{"data-svelte-h":!0}),y(Si)!=="svelte-4qpzld"&&(Si.innerHTML=Ov),tb=o(qp),Ni=l(qp,"DIV",{class:!0});var Q0=T(Ni);m(Lr.$$.fragment,Q0),Q0.forEach(s),qp.forEach(s),Pg=o(e),Ee=l(e,"DIV",{class:!0});var Dp=T(Ee);m(Cr.$$.fragment,Dp),sb=o(Dp),Ei=l(Dp,"P",{"data-svelte-h":!0}),y(Ei)!=="svelte-a554sd"&&(Ei.innerHTML=Kv),nb=o(Dp),Hi=l(Dp,"DIV",{class:!0});var Y0=T(Hi);m(Vr.$$.fragment,Y0),Y0.forEach(s),Dp.forEach(s),Qg=o(e),He=l(e,"DIV",{class:!0});var Pp=T(He);m(Fr.$$.fragment,Pp),ob=o(Pp),qi=l(Pp,"P",{"data-svelte-h":!0}),y(qi)!=="svelte-1fk5ix"&&(qi.innerHTML=eM),rb=o(Pp),Di=l(Pp,"DIV",{class:!0});var A0=T(Di);m(Gr.$$.fragment,A0),A0.forEach(s),Pp.forEach(s),Yg=o(e),qe=l(e,"DIV",{class:!0});var Qp=T(qe);m(Xr.$$.fragment,Qp),ab=o(Qp),Pi=l(Qp,"P",{"data-svelte-h":!0}),y(Pi)!=="svelte-2esmoy"&&(Pi.innerHTML=tM),lb=o(Qp),Qi=l(Qp,"DIV",{class:!0});var O0=T(Qi);m(Rr.$$.fragment,O0),O0.forEach(s),Qp.forEach(s),Ag=o(e),De=l(e,"DIV",{class:!0});var Yp=T(De);m(Sr.$$.fragment,Yp),cb=o(Yp),Yi=l(Yp,"P",{"data-svelte-h":!0}),y(Yi)!=="svelte-fbg3ks"&&(Yi.innerHTML=sM),ib=o(Yp),Ai=l(Yp,"DIV",{class:!0});var K0=T(Ai);m(Nr.$$.fragment,K0),K0.forEach(s),Yp.forEach(s),Og=o(e),m(Er.$$.fragment,e),Kg=o(e),Pe=l(e,"DIV",{class:!0});var Ap=T(Pe);m(Hr.$$.fragment,Ap),db=o(Ap),Oi=l(Ap,"P",{"data-svelte-h":!0}),y(Oi)!=="svelte-15kd1k4"&&(Oi.innerHTML=nM),pb=o(Ap),Ki=l(Ap,"DIV",{class:!0});var ew=T(Ki);m(qr.$$.fragment,ew),ew.forEach(s),Ap.forEach(s),eu=o(e),Qe=l(e,"DIV",{class:!0});var Op=T(Qe);m(Dr.$$.fragment,Op),mb=o(Op),ed=l(Op,"P",{"data-svelte-h":!0}),y(ed)!=="svelte-1j4d3og"&&(ed.innerHTML=oM),gb=o(Op),td=l(Op,"DIV",{class:!0});var tw=T(td);m(Pr.$$.fragment,tw),tw.forEach(s),Op.forEach(s),tu=o(e),Ye=l(e,"DIV",{class:!0});var Kp=T(Ye);m(Qr.$$.fragment,Kp),ub=o(Kp),sd=l(Kp,"P",{"data-svelte-h":!0}),y(sd)!=="svelte-1lwbgar"&&(sd.innerHTML=rM),hb=o(Kp),nd=l(Kp,"DIV",{class:!0});var sw=T(nd);m(Yr.$$.fragment,sw),sw.forEach(s),Kp.forEach(s),su=o(e),Ae=l(e,"DIV",{class:!0});var em=T(Ae);m(Ar.$$.fragment,em),fb=o(em),od=l(em,"P",{"data-svelte-h":!0}),y(od)!=="svelte-y1kta5"&&(od.textContent=aM),_b=o(em),xs=l(em,"DIV",{class:!0});var Xu=T(xs);m(Or.$$.fragment,Xu),bb=o(Xu),rd=l(Xu,"P",{"data-svelte-h":!0}),y(rd)!=="svelte-1l17mwc"&&(rd.textContent=lM),Xu.forEach(s),em.forEach(s),nu=o(e),Oe=l(e,"DIV",{class:!0});var tm=T(Oe);m(Kr.$$.fragment,tm),yb=o(tm),ad=l(tm,"P",{"data-svelte-h":!0}),y(ad)!=="svelte-sjoe2b"&&(ad.innerHTML=cM),Tb=o(tm),ld=l(tm,"DIV",{class:!0});var nw=T(ld);m(ea.$$.fragment,nw),nw.forEach(s),tm.forEach(s),ou=o(e),Ke=l(e,"DIV",{class:!0});var sm=T(Ke);m(ta.$$.fragment,sm),vb=o(sm),cd=l(sm,"P",{"data-svelte-h":!0}),y(cd)!=="svelte-th82mu"&&(cd.textContent=iM),Mb=o(sm),Js=l(sm,"DIV",{class:!0});var Ru=T(Js);m(sa.$$.fragment,Ru),wb=o(Ru),id=l(Ru,"P",{"data-svelte-h":!0}),y(id)!=="svelte-1tcb5cf"&&(id.textContent=dM),Ru.forEach(s),sm.forEach(s),ru=o(e),et=l(e,"DIV",{class:!0});var nm=T(et);m(na.$$.fragment,nm),$b=o(nm),dd=l(nm,"P",{"data-svelte-h":!0}),y(dd)!=="svelte-1q9gsrg"&&(dd.innerHTML=pM),kb=o(nm),pd=l(nm,"DIV",{class:!0});var ow=T(pd);m(oa.$$.fragment,ow),ow.forEach(s),nm.forEach(s),au=o(e),tt=l(e,"DIV",{class:!0});var om=T(tt);m(ra.$$.fragment,om),jb=o(om),md=l(om,"P",{"data-svelte-h":!0}),y(md)!=="svelte-1cictio"&&(md.innerHTML=mM),xb=o(om),gd=l(om,"DIV",{class:!0});var rw=T(gd);m(aa.$$.fragment,rw),rw.forEach(s),om.forEach(s),lu=o(e),st=l(e,"DIV",{class:!0});var rm=T(st);m(la.$$.fragment,rm),Jb=o(rm),ud=l(rm,"P",{"data-svelte-h":!0}),y(ud)!=="svelte-1a14rg6"&&(ud.innerHTML=gM),Ub=o(rm),hd=l(rm,"DIV",{class:!0});var aw=T(hd);m(ca.$$.fragment,aw),aw.forEach(s),rm.forEach(s),cu=o(e),nt=l(e,"DIV",{class:!0});var am=T(nt);m(ia.$$.fragment,am),Bb=o(am),fd=l(am,"P",{"data-svelte-h":!0}),y(fd)!=="svelte-raxh23"&&(fd.innerHTML=uM),Ib=o(am),_d=l(am,"DIV",{class:!0});var lw=T(_d);m(da.$$.fragment,lw),lw.forEach(s),am.forEach(s),iu=o(e),ot=l(e,"DIV",{class:!0});var lm=T(ot);m(pa.$$.fragment,lm),Zb=o(lm),bd=l(lm,"P",{"data-svelte-h":!0}),y(bd)!=="svelte-1xju5yw"&&(bd.innerHTML=hM),zb=o(lm),yd=l(lm,"DIV",{class:!0});var cw=T(yd);m(ma.$$.fragment,cw),cw.forEach(s),lm.forEach(s),du=o(e),rt=l(e,"DIV",{class:!0});var cm=T(rt);m(ga.$$.fragment,cm),Wb=o(cm),Td=l(cm,"P",{"data-svelte-h":!0}),y(Td)!=="svelte-lcqpee"&&(Td.innerHTML=fM),Lb=o(cm),vd=l(cm,"DIV",{class:!0});var iw=T(vd);m(ua.$$.fragment,iw),iw.forEach(s),cm.forEach(s),pu=o(e),at=l(e,"DIV",{class:!0});var im=T(at);m(ha.$$.fragment,im),Cb=o(im),Md=l(im,"P",{"data-svelte-h":!0}),y(Md)!=="svelte-1sygpwz"&&(Md.innerHTML=_M),Vb=o(im),wd=l(im,"DIV",{class:!0});var dw=T(wd);m(fa.$$.fragment,dw),dw.forEach(s),im.forEach(s),mu=o(e),m(_a.$$.fragment,e),gu=o(e),ba=l(e,"P",{"data-svelte-h":!0}),y(ba)!=="svelte-1pdvxgm"&&(ba.innerHTML=bM),uu=o(e),he=l(e,"DIV",{class:!0});var gn=T(he);m(ya.$$.fragment,gn),Fb=o(gn),$d=l(gn,"P",{"data-svelte-h":!0}),y($d)!=="svelte-rfvu1k"&&($d.textContent=yM),Gb=o(gn),kd=l(gn,"P",{"data-svelte-h":!0}),y(kd)!=="svelte-e1lytz"&&(kd.innerHTML=TM),Xb=o(gn),jd=l(gn,"DIV",{class:!0});var pw=T(jd);m(Ta.$$.fragment,pw),pw.forEach(s),gn.forEach(s),hu=o(e),Gt=l(e,"DIV",{class:!0});var Su=T(Gt);m(va.$$.fragment,Su),Rb=o(Su),xd=l(Su,"DIV",{class:!0});var mw=T(xd);m(Ma.$$.fragment,mw),mw.forEach(s),Su.forEach(s),fu=o(e),lt=l(e,"DIV",{class:!0});var dm=T(lt);m(wa.$$.fragment,dm),Sb=o(dm),Jd=l(dm,"P",{"data-svelte-h":!0}),y(Jd)!=="svelte-4hfu96"&&(Jd.innerHTML=vM),Nb=o(dm),Ud=l(dm,"DIV",{class:!0});var gw=T(Ud);m($a.$$.fragment,gw),gw.forEach(s),dm.forEach(s),_u=o(e),ct=l(e,"DIV",{class:!0});var pm=T(ct);m(ka.$$.fragment,pm),Eb=o(pm),Bd=l(pm,"P",{"data-svelte-h":!0}),y(Bd)!=="svelte-q5v59n"&&(Bd.innerHTML=MM),Hb=o(pm),Id=l(pm,"DIV",{class:!0});var uw=T(Id);m(ja.$$.fragment,uw),uw.forEach(s),pm.forEach(s),bu=o(e),m(xa.$$.fragment,e),yu=o(e),Ja=l(e,"P",{"data-svelte-h":!0}),y(Ja)!=="svelte-acweac"&&(Ja.innerHTML=wM),Tu=o(e),U=l(e,"DIV",{class:!0});var I=T(U);m(Ua.$$.fragment,I),qb=o(I),Zd=l(I,"P",{"data-svelte-h":!0}),y(Zd)!=="svelte-1kh5y5v"&&(Zd.textContent=$M),Db=o(I),zd=l(I,"P",{"data-svelte-h":!0}),y(zd)!=="svelte-1ygkifj"&&(zd.textContent=kM),Pb=o(I),m(Us.$$.fragment,I),Qb=o(I),Wd=l(I,"P",{"data-svelte-h":!0}),y(Wd)!=="svelte-7kbd1a"&&(Wd.textContent=jM),Yb=o(I),Bs=l(I,"DIV",{class:!0});var Nu=T(Bs);m(Ba.$$.fragment,Nu),Ab=o(Nu),Ld=l(Nu,"P",{"data-svelte-h":!0}),y(Ld)!=="svelte-691079"&&(Ld.textContent=xM),Nu.forEach(s),Ob=o(I),Is=l(I,"DIV",{class:!0});var Eu=T(Is);m(Ia.$$.fragment,Eu),Kb=o(Eu),Cd=l(Eu,"P",{"data-svelte-h":!0}),y(Cd)!=="svelte-dtkk01"&&(Cd.textContent=JM),Eu.forEach(s),ey=o(I),Zs=l(I,"DIV",{class:!0});var Hu=T(Zs);m(Za.$$.fragment,Hu),ty=o(Hu),Vd=l(Hu,"P",{"data-svelte-h":!0}),y(Vd)!=="svelte-11pa7k0"&&(Vd.textContent=UM),Hu.forEach(s),sy=o(I),zs=l(I,"DIV",{class:!0});var qu=T(zs);m(za.$$.fragment,qu),ny=o(qu),Fd=l(qu,"P",{"data-svelte-h":!0}),y(Fd)!=="svelte-57vcuk"&&(Fd.innerHTML=BM),qu.forEach(s),oy=o(I),Ws=l(I,"DIV",{class:!0});var Du=T(Ws);m(Wa.$$.fragment,Du),ry=o(Du),Gd=l(Du,"P",{"data-svelte-h":!0}),y(Gd)!=="svelte-e342dt"&&(Gd.textContent=IM),Du.forEach(s),ay=o(I),Ls=l(I,"DIV",{class:!0});var Pu=T(Ls);m(La.$$.fragment,Pu),ly=o(Pu),Xd=l(Pu,"P",{"data-svelte-h":!0}),y(Xd)!=="svelte-vbd5xj"&&(Xd.textContent=ZM),Pu.forEach(s),cy=o(I),ht=l(I,"DIV",{class:!0});var mm=T(ht);m(Ca.$$.fragment,mm),iy=o(mm),Rd=l(mm,"P",{"data-svelte-h":!0}),y(Rd)!=="svelte-1c2dshy"&&(Rd.innerHTML=zM),dy=o(mm),Sd=l(mm,"P",{"data-svelte-h":!0}),y(Sd)!=="svelte-1qvu1un"&&(Sd.textContent=WM),mm.forEach(s),I.forEach(s),vu=o(e),Xt=l(e,"DIV",{class:!0});var Qu=T(Xt);m(Va.$$.fragment,Qu),py=o(Qu),Nd=l(Qu,"P",{"data-svelte-h":!0}),y(Nd)!=="svelte-b5urq"&&(Nd.innerHTML=LM),Qu.forEach(s),Mu=o(e),Rt=l(e,"DIV",{class:!0});var Yu=T(Rt);m(Fa.$$.fragment,Yu),my=o(Yu),Ed=l(Yu,"P",{"data-svelte-h":!0}),y(Ed)!=="svelte-3mxut3"&&(Ed.innerHTML=CM),Yu.forEach(s),wu=o(e),fe=l(e,"DIV",{class:!0});var un=T(fe);m(Ga.$$.fragment,un),gy=o(un),Hd=l(un,"P",{"data-svelte-h":!0}),y(Hd)!=="svelte-rxlesw"&&(Hd.textContent=VM),uy=o(un),F=l(un,"DIV",{class:!0});var we=T(F);m(Xa.$$.fragment,we),hy=o(we),qd=l(we,"P",{"data-svelte-h":!0}),y(qd)!=="svelte-15hhlou"&&(qd.textContent=FM),fy=o(we),Dd=l(we,"P",{"data-svelte-h":!0}),y(Dd)!=="svelte-x0d0uq"&&(Dd.innerHTML=GM),_y=o(we),Pd=l(we,"P",{"data-svelte-h":!0}),y(Pd)!=="svelte-1w36vm3"&&(Pd.innerHTML=XM),by=o(we),Qd=l(we,"P",{"data-svelte-h":!0}),y(Qd)!=="svelte-1niq0qw"&&(Qd.innerHTML=RM),yy=o(we),Yd=l(we,"P",{"data-svelte-h":!0}),y(Yd)!=="svelte-af4g6f"&&(Yd.textContent=SM),we.forEach(s),Ty=o(un),Cs=l(un,"DIV",{class:!0});var Au=T(Cs);m(Ra.$$.fragment,Au),vy=o(Au),Ad=l(Au,"P",{"data-svelte-h":!0}),y(Ad)!=="svelte-eab6jp"&&(Ad.textContent=NM),Au.forEach(s),un.forEach(s),$u=o(e),m(Sa.$$.fragment,e),ku=o(e),_e=l(e,"DIV",{class:!0});var hn=T(_e);m(Na.$$.fragment,hn),My=o(hn),Od=l(hn,"P",{"data-svelte-h":!0}),y(Od)!=="svelte-1ey02pr"&&(Od.innerHTML=EM),wy=o(hn),Kd=l(hn,"DIV",{class:!0});var hw=T(Kd);m(Ea.$$.fragment,hw),hw.forEach(s),$y=o(hn),ep=l(hn,"DIV",{class:!0});var fw=T(ep);m(Ha.$$.fragment,fw),fw.forEach(s),hn.forEach(s),ju=o(e),C=l(e,"DIV",{class:!0});var $e=T(C);m(qa.$$.fragment,$e),ky=o($e),tp=l($e,"P",{"data-svelte-h":!0}),y(tp)!=="svelte-vf8q73"&&(tp.innerHTML=HM),jy=o($e),sp=l($e,"P",{"data-svelte-h":!0}),y(sp)!=="svelte-19qrwo1"&&(sp.innerHTML=qM),xy=o($e),np=l($e,"P",{"data-svelte-h":!0}),y(np)!=="svelte-l79sbt"&&(np.innerHTML=DM),Jy=o($e),op=l($e,"DIV",{class:!0});var _w=T(op);m(Da.$$.fragment,_w),_w.forEach(s),Uy=o($e),rp=l($e,"DIV",{class:!0});var bw=T(rp);m(Pa.$$.fragment,bw),bw.forEach(s),$e.forEach(s),xu=o(e),be=l(e,"DIV",{class:!0});var fn=T(be);m(Qa.$$.fragment,fn),By=o(fn),ap=l(fn,"P",{"data-svelte-h":!0}),y(ap)!=="svelte-1j2z3zq"&&(ap.innerHTML=PM),Iy=o(fn),lp=l(fn,"DIV",{class:!0});var yw=T(lp);m(Ya.$$.fragment,yw),yw.forEach(s),Zy=o(fn),cp=l(fn,"DIV",{class:!0});var Tw=T(cp);m(Aa.$$.fragment,Tw),Tw.forEach(s),fn.forEach(s),Ju=o(e),m(Oa.$$.fragment,e),Uu=o(e),z=l(e,"DIV",{class:!0});var O=T(z);m(Ka.$$.fragment,O),zy=o(O),ip=l(O,"P",{"data-svelte-h":!0}),y(ip)!=="svelte-5jvlz5"&&(ip.textContent=QM),Wy=o(O),m(Vs.$$.fragment,O),Ly=o(O),m(Fs.$$.fragment,O),Cy=o(O),Gs=l(O,"DIV",{class:!0});var Ou=T(Gs);m(el.$$.fragment,Ou),Vy=o(Ou),dp=l(Ou,"P",{"data-svelte-h":!0}),y(dp)!=="svelte-10d94rs"&&(dp.textContent=YM),Ou.forEach(s),Fy=o(O),Xs=l(O,"DIV",{class:!0});var Ku=T(Xs);m(tl.$$.fragment,Ku),Gy=o(Ku),pp=l(Ku,"P",{"data-svelte-h":!0}),y(pp)!=="svelte-tm945r"&&(pp.textContent=AM),Ku.forEach(s),Xy=o(O),Rs=l(O,"DIV",{class:!0});var eh=T(Rs);m(sl.$$.fragment,eh),Ry=o(eh),mp=l(eh,"P",{"data-svelte-h":!0}),y(mp)!=="svelte-1i1356p"&&(mp.textContent=OM),eh.forEach(s),O.forEach(s),Bu=o(e),Y=l(e,"DIV",{class:!0});var $t=T(Y);m(nl.$$.fragment,$t),Sy=o($t),gp=l($t,"P",{"data-svelte-h":!0}),y(gp)!=="svelte-190fodr"&&(gp.textContent=KM),Ny=o($t),m(Ss.$$.fragment,$t),Ey=o($t),m(Ns.$$.fragment,$t),Hy=o($t),Es=l($t,"DIV",{class:!0});var th=T(Es);m(ol.$$.fragment,th),qy=o(th),up=l(th,"P",{"data-svelte-h":!0}),y(up)!=="svelte-16i5iz"&&(up.textContent=e0),th.forEach(s),$t.forEach(s),Iu=o(e),m(rl.$$.fragment,e),Zu=o(e),it=l(e,"DIV",{class:!0});var gm=T(it);m(al.$$.fragment,gm),Dy=o(gm),hp=l(gm,"P",{"data-svelte-h":!0}),y(hp)!=="svelte-15qehu2"&&(hp.textContent=t0),Py=o(gm),Hs=l(gm,"DIV",{class:!0});var sh=T(Hs);m(ll.$$.fragment,sh),Qy=o(sh),fp=l(sh,"P",{"data-svelte-h":!0}),y(fp)!=="svelte-dfcv5s"&&(fp.innerHTML=s0),sh.forEach(s),gm.forEach(s),zu=o(e),Z=l(e,"DIV",{class:!0});var G=T(Z);m(cl.$$.fragment,G),Yy=o(G),_p=l(G,"P",{"data-svelte-h":!0}),y(_p)!=="svelte-11w7j52"&&(_p.textContent=n0),Ay=o(G),bp=l(G,"P",{"data-svelte-h":!0}),y(bp)!=="svelte-1f9j82e"&&(bp.innerHTML=o0),Oy=o(G),qs=l(G,"DIV",{class:!0});var nh=T(qs);m(il.$$.fragment,nh),Ky=o(nh),yp=l(nh,"P",{"data-svelte-h":!0}),y(yp)!=="svelte-dfcv5s"&&(yp.innerHTML=r0),nh.forEach(s),eT=o(G),Ds=l(G,"DIV",{class:!0});var oh=T(Ds);m(dl.$$.fragment,oh),tT=o(oh),Tp=l(oh,"P",{"data-svelte-h":!0}),y(Tp)!=="svelte-1nftdf9"&&(Tp.textContent=a0),oh.forEach(s),sT=o(G),Ps=l(G,"DIV",{class:!0});var rh=T(Ps);m(pl.$$.fragment,rh),nT=o(rh),vp=l(rh,"P",{"data-svelte-h":!0}),y(vp)!=="svelte-114iuj0"&&(vp.textContent=l0),rh.forEach(s),oT=o(G),Qs=l(G,"DIV",{class:!0});var ah=T(Qs);m(ml.$$.fragment,ah),rT=o(ah),Mp=l(ah,"P",{"data-svelte-h":!0}),y(Mp)!=="svelte-4hau7v"&&(Mp.innerHTML=c0),ah.forEach(s),aT=o(G),Ys=l(G,"DIV",{class:!0});var lh=T(Ys);m(gl.$$.fragment,lh),lT=o(lh),wp=l(lh,"P",{"data-svelte-h":!0}),y(wp)!=="svelte-sp3ts6"&&(wp.innerHTML=i0),lh.forEach(s),G.forEach(s),Wu=o(e),V=l(e,"DIV",{class:!0});var ke=T(V);m(ul.$$.fragment,ke),cT=o(ke),$p=l(ke,"P",{"data-svelte-h":!0}),y($p)!=="svelte-ldcea6"&&($p.innerHTML=d0),iT=o(ke),kp=l(ke,"P",{"data-svelte-h":!0}),y(kp)!=="svelte-1f9j82e"&&(kp.innerHTML=p0),dT=o(ke),As=l(ke,"DIV",{class:!0});var ch=T(As);m(hl.$$.fragment,ch),pT=o(ch),jp=l(ch,"P",{"data-svelte-h":!0}),y(jp)!=="svelte-dfcv5s"&&(jp.innerHTML=m0),ch.forEach(s),mT=o(ke),Os=l(ke,"DIV",{class:!0});var ih=T(Os);m(fl.$$.fragment,ih),gT=o(ih),xp=l(ih,"P",{"data-svelte-h":!0}),y(xp)!=="svelte-1nftdf9"&&(xp.textContent=g0),ih.forEach(s),uT=o(ke),Ks=l(ke,"DIV",{class:!0});var dh=T(Ks);m(_l.$$.fragment,dh),hT=o(dh),Jp=l(dh,"P",{"data-svelte-h":!0}),y(Jp)!=="svelte-114iuj0"&&(Jp.textContent=u0),dh.forEach(s),ke.forEach(s),Lu=o(e),ye=l(e,"DIV",{class:!0});var _n=T(ye);m(bl.$$.fragment,_n),fT=o(_n),Up=l(_n,"P",{"data-svelte-h":!0}),y(Up)!=="svelte-109wkq1"&&(Up.innerHTML=h0),_T=o(_n),en=l(_n,"DIV",{class:!0});var ph=T(en);m(yl.$$.fragment,ph),bT=o(ph),Bp=l(ph,"P",{"data-svelte-h":!0}),y(Bp)!=="svelte-vi6d54"&&(Bp.innerHTML=f0),ph.forEach(s),yT=o(_n),tn=l(_n,"DIV",{class:!0});var mh=T(tn);m(Tl.$$.fragment,mh),TT=o(mh),Ip=l(mh,"P",{"data-svelte-h":!0}),y(Ip)!=="svelte-18x5t5d"&&(Ip.innerHTML=_0),mh.forEach(s),_n.forEach(s),Cu=o(e),um=l(e,"P",{}),T(um).forEach(s),this.h()},h(){v(i,"name","hf:doc:metadata"),v(i,"content",i$),v(kt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(It,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ht,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(qt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Dt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(rc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(cc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(pc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(uc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(fc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(bc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Tc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Mc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(jc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Bc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(zc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Lc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Vc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Gc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Rc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Nc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Hc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Dc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Qc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ac,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ei,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(si,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(oi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ai,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ci,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(di,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(mi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(hi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(bi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(vi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(wi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ki,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(xi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ks,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ii,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(js,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Li,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Vi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Gi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ri,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ni,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Hi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Di,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Qi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ai,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ki,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(td,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(nd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(xs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ld,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Js,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(pd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(gd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(hd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(_d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(yd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(vd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(wd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(at,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(jd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(xd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ud,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Id,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Bs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Is,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Zs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(zs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ws,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ls,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ht,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Cs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Kd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ep,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(op,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(rp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(lp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(cp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Gs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Xs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Rs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Es,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Hs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(it,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(qs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ds,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ps,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Qs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ys,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(As,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Os,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ks,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(en,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){t(document.head,i),d(e,k,c),d(e,b,c),d(e,_,c),g(w,e,c),d(e,r,c),d(e,$,c),d(e,wm,c),g(yn,e,c),d(e,$m,c),d(e,Tn,c),d(e,km,c),d(e,vn,c),d(e,jm,c),g(Mn,e,c),d(e,xm,c),d(e,wn,c),d(e,Jm,c),d(e,$n,c),d(e,Um,c),d(e,kn,c),d(e,Bm,c),d(e,jn,c),d(e,Im,c),d(e,xn,c),d(e,Zm,c),g(Jn,e,c),d(e,zm,c),d(e,Un,c),d(e,Wm,c),d(e,Bn,c),d(e,Lm,c),d(e,In,c),d(e,Cm,c),g(Zn,e,c),d(e,Vm,c),d(e,kt,c),g(zn,kt,null),t(kt,gh),t(kt,Fl),d(e,Fm,c),d(e,jt,c),g(Wn,jt,null),t(jt,uh),t(jt,Gl),d(e,Gm,c),d(e,xt,c),g(Ln,xt,null),t(xt,hh),t(xt,Xl),d(e,Xm,c),d(e,Jt,c),g(Cn,Jt,null),t(Jt,fh),t(Jt,Rl),d(e,Rm,c),g(Vn,e,c),d(e,Sm,c),d(e,Ut,c),g(Fn,Ut,null),t(Ut,_h),t(Ut,Sl),d(e,Nm,c),d(e,Bt,c),g(Gn,Bt,null),t(Bt,bh),t(Bt,Nl),d(e,Em,c),d(e,It,c),g(Xn,It,null),t(It,yh),t(It,El),d(e,Hm,c),d(e,Zt,c),g(Rn,Zt,null),t(Zt,Th),t(Zt,Hl),d(e,qm,c),d(e,zt,c),g(Sn,zt,null),t(zt,vh),t(zt,ql),d(e,Dm,c),d(e,Wt,c),g(Nn,Wt,null),t(Wt,Mh),t(Wt,Dl),d(e,Pm,c),d(e,Lt,c),g(En,Lt,null),t(Lt,wh),t(Lt,Pl),d(e,Qm,c),d(e,Ct,c),g(Hn,Ct,null),t(Ct,$h),t(Ct,Ql),d(e,Ym,c),d(e,Vt,c),g(qn,Vt,null),t(Vt,kh),t(Vt,Yl),d(e,Am,c),d(e,Ft,c),g(Dn,Ft,null),t(Ft,jh),t(Ft,Al),d(e,Om,c),g(Pn,e,c),d(e,Km,c),d(e,je,c),g(Qn,je,null),t(je,xh),t(je,Ol),t(je,Jh),t(je,Ht),g(Yn,Ht,null),t(Ht,Uh),t(Ht,Kl),d(e,eg,c),d(e,xe,c),g(An,xe,null),t(xe,Bh),t(xe,ec),t(xe,Ih),t(xe,qt),g(On,qt,null),t(qt,Zh),t(qt,tc),d(e,tg,c),d(e,Je,c),g(Kn,Je,null),t(Je,zh),t(Je,sc),t(Je,Wh),t(Je,Dt),g(eo,Dt,null),t(Dt,Lh),t(Dt,nc),d(e,sg,c),g(to,e,c),d(e,ng,c),d(e,so,c),d(e,og,c),g(no,e,c),d(e,rg,c),d(e,ee,c),g(oo,ee,null),t(ee,Ch),t(ee,oc),t(ee,Vh),g(Pt,ee,null),t(ee,Fh),t(ee,rc),g(ro,rc,null),d(e,ag,c),d(e,W,c),g(ao,W,null),t(W,Gh),t(W,ac),t(W,Xh),t(W,lc),t(W,Rh),g(Qt,W,null),t(W,Sh),g(Yt,W,null),t(W,Nh),t(W,cc),g(lo,cc,null),d(e,lg,c),d(e,X,c),g(co,X,null),t(X,Eh),t(X,ic),t(X,Hh),t(X,dc),t(X,qh),g(At,X,null),t(X,Dh),t(X,pc),g(io,pc,null),d(e,cg,c),d(e,R,c),g(po,R,null),t(R,Ph),t(R,mc),t(R,Qh),t(R,gc),t(R,Yh),g(Ot,R,null),t(R,Ah),t(R,uc),g(mo,uc,null),d(e,ig,c),d(e,te,c),g(go,te,null),t(te,Oh),t(te,hc),t(te,Kh),g(Kt,te,null),t(te,ef),t(te,fc),g(uo,fc,null),d(e,dg,c),d(e,se,c),g(ho,se,null),t(se,tf),t(se,_c),t(se,sf),g(es,se,null),t(se,nf),t(se,bc),g(fo,bc,null),d(e,pg,c),d(e,ne,c),g(_o,ne,null),t(ne,of),t(ne,yc),t(ne,rf),g(ts,ne,null),t(ne,af),t(ne,Tc),g(bo,Tc,null),d(e,mg,c),d(e,oe,c),g(yo,oe,null),t(oe,lf),t(oe,vc),t(oe,cf),g(ss,oe,null),t(oe,df),t(oe,Mc),g(To,Mc,null),d(e,gg,c),d(e,re,c),g(vo,re,null),t(re,pf),t(re,wc),t(re,mf),g(ns,re,null),t(re,gf),t(re,$c),g(Mo,$c,null),d(e,ug,c),d(e,Ue,c),g(wo,Ue,null),t(Ue,uf),t(Ue,kc),t(Ue,hf),t(Ue,jc),g($o,jc,null),d(e,hg,c),d(e,L,c),g(ko,L,null),t(L,ff),t(L,xc),t(L,_f),t(L,Jc),t(L,bf),t(L,Uc),t(L,yf),g(os,L,null),t(L,Tf),t(L,Bc),g(jo,Bc,null),d(e,fg,c),d(e,ae,c),g(xo,ae,null),t(ae,vf),t(ae,Ic),t(ae,Mf),t(ae,Zc),t(ae,wf),t(ae,zc),g(Jo,zc,null),d(e,_g,c),d(e,le,c),g(Uo,le,null),t(le,$f),t(le,Wc),t(le,kf),g(rs,le,null),t(le,jf),t(le,Lc),g(Bo,Lc,null),d(e,bg,c),d(e,Be,c),g(Io,Be,null),t(Be,xf),t(Be,Cc),t(Be,Jf),t(Be,Vc),g(Zo,Vc,null),d(e,yg,c),d(e,Ie,c),g(zo,Ie,null),t(Ie,Uf),t(Ie,Fc),t(Ie,Bf),t(Ie,Gc),g(Wo,Gc,null),d(e,Tg,c),d(e,Ze,c),g(Lo,Ze,null),t(Ze,If),t(Ze,Xc),t(Ze,Zf),t(Ze,Rc),g(Co,Rc,null),d(e,vg,c),d(e,ce,c),g(Vo,ce,null),t(ce,zf),t(ce,Sc),t(ce,Wf),g(as,ce,null),t(ce,Lf),t(ce,Nc),g(Fo,Nc,null),d(e,Mg,c),d(e,ie,c),g(Go,ie,null),t(ie,Cf),t(ie,Ec),t(ie,Vf),g(ls,ie,null),t(ie,Ff),t(ie,Hc),g(Xo,Hc,null),d(e,wg,c),d(e,S,c),g(Ro,S,null),t(S,Gf),t(S,qc),t(S,Xf),g(cs,S,null),t(S,Rf),g(is,S,null),t(S,Sf),t(S,Dc),g(So,Dc,null),d(e,$g,c),d(e,N,c),g(No,N,null),t(N,Nf),t(N,Pc),t(N,Ef),g(ds,N,null),t(N,Hf),g(ps,N,null),t(N,qf),t(N,Qc),g(Eo,Qc,null),d(e,kg,c),d(e,de,c),g(Ho,de,null),t(de,Df),t(de,Yc),t(de,Pf),g(ms,de,null),t(de,Qf),t(de,Ac),g(qo,Ac,null),d(e,jg,c),d(e,E,c),g(Do,E,null),t(E,Yf),t(E,Oc),t(E,Af),t(E,Kc),t(E,Of),g(gs,E,null),t(E,Kf),t(E,ei),g(Po,ei,null),d(e,xg,c),d(e,H,c),g(Qo,H,null),t(H,e_),t(H,ti),t(H,t_),g(us,H,null),t(H,s_),g(hs,H,null),t(H,n_),t(H,si),g(Yo,si,null),d(e,Jg,c),d(e,pe,c),g(Ao,pe,null),t(pe,o_),t(pe,ni),t(pe,r_),g(fs,pe,null),t(pe,a_),t(pe,oi),g(Oo,oi,null),d(e,Ug,c),d(e,me,c),g(Ko,me,null),t(me,l_),t(me,ri),t(me,c_),g(_s,me,null),t(me,i_),t(me,ai),g(er,ai,null),d(e,Bg,c),d(e,q,c),g(tr,q,null),t(q,d_),t(q,li),t(q,p_),g(bs,q,null),t(q,m_),g(ys,q,null),t(q,g_),t(q,ci),g(sr,ci,null),d(e,Ig,c),d(e,ge,c),g(nr,ge,null),t(ge,u_),t(ge,ii),t(ge,h_),g(Ts,ge,null),t(ge,f_),t(ge,di),g(or,di,null),d(e,Zg,c),d(e,ue,c),g(rr,ue,null),t(ue,__),t(ue,pi),t(ue,b_),g(vs,ue,null),t(ue,y_),t(ue,mi),g(ar,mi,null),d(e,zg,c),d(e,D,c),g(lr,D,null),t(D,T_),t(D,gi),t(D,v_),t(D,ui),t(D,M_),g(Ms,D,null),t(D,w_),t(D,hi),g(cr,hi,null),d(e,Wg,c),d(e,P,c),g(ir,P,null),t(P,$_),t(P,fi),t(P,k_),t(P,_i),t(P,j_),g(ws,P,null),t(P,x_),t(P,bi),g(dr,bi,null),d(e,Lg,c),d(e,Q,c),g(pr,Q,null),t(Q,J_),t(Q,yi),t(Q,U_),t(Q,Ti),t(Q,B_),g($s,Q,null),t(Q,I_),t(Q,vi),g(mr,vi,null),d(e,Cg,c),g(gr,e,c),d(e,Vg,c),d(e,ze,c),g(ur,ze,null),t(ze,Z_),t(ze,Mi),t(ze,z_),t(ze,wi),g(hr,wi,null),d(e,Fg,c),d(e,We,c),g(fr,We,null),t(We,W_),t(We,$i),t(We,L_),t(We,ki),g(_r,ki,null),d(e,Gg,c),d(e,Le,c),g(br,Le,null),t(Le,C_),t(Le,ji),t(Le,V_),t(Le,xi),g(yr,xi,null),d(e,Xg,c),d(e,Ce,c),g(Tr,Ce,null),t(Ce,F_),t(Ce,Ji),t(Ce,G_),t(Ce,ks),g(vr,ks,null),t(ks,X_),t(ks,Ui),d(e,Rg,c),d(e,Ve,c),g(Mr,Ve,null),t(Ve,R_),t(Ve,Bi),t(Ve,S_),t(Ve,Ii),g(wr,Ii,null),d(e,Sg,c),d(e,Fe,c),g($r,Fe,null),t(Fe,N_),t(Fe,Zi),t(Fe,E_),t(Fe,js),g(kr,js,null),t(js,H_),t(js,zi),d(e,Ng,c),d(e,Ge,c),g(jr,Ge,null),t(Ge,q_),t(Ge,Wi),t(Ge,D_),t(Ge,Li),g(xr,Li,null),d(e,Eg,c),d(e,Xe,c),g(Jr,Xe,null),t(Xe,P_),t(Xe,Ci),t(Xe,Q_),t(Xe,Vi),g(Ur,Vi,null),d(e,Hg,c),d(e,Re,c),g(Br,Re,null),t(Re,Y_),t(Re,Fi),t(Re,A_),t(Re,Gi),g(Ir,Gi,null),d(e,qg,c),d(e,Se,c),g(Zr,Se,null),t(Se,O_),t(Se,Xi),t(Se,K_),t(Se,Ri),g(zr,Ri,null),d(e,Dg,c),d(e,Ne,c),g(Wr,Ne,null),t(Ne,eb),t(Ne,Si),t(Ne,tb),t(Ne,Ni),g(Lr,Ni,null),d(e,Pg,c),d(e,Ee,c),g(Cr,Ee,null),t(Ee,sb),t(Ee,Ei),t(Ee,nb),t(Ee,Hi),g(Vr,Hi,null),d(e,Qg,c),d(e,He,c),g(Fr,He,null),t(He,ob),t(He,qi),t(He,rb),t(He,Di),g(Gr,Di,null),d(e,Yg,c),d(e,qe,c),g(Xr,qe,null),t(qe,ab),t(qe,Pi),t(qe,lb),t(qe,Qi),g(Rr,Qi,null),d(e,Ag,c),d(e,De,c),g(Sr,De,null),t(De,cb),t(De,Yi),t(De,ib),t(De,Ai),g(Nr,Ai,null),d(e,Og,c),g(Er,e,c),d(e,Kg,c),d(e,Pe,c),g(Hr,Pe,null),t(Pe,db),t(Pe,Oi),t(Pe,pb),t(Pe,Ki),g(qr,Ki,null),d(e,eu,c),d(e,Qe,c),g(Dr,Qe,null),t(Qe,mb),t(Qe,ed),t(Qe,gb),t(Qe,td),g(Pr,td,null),d(e,tu,c),d(e,Ye,c),g(Qr,Ye,null),t(Ye,ub),t(Ye,sd),t(Ye,hb),t(Ye,nd),g(Yr,nd,null),d(e,su,c),d(e,Ae,c),g(Ar,Ae,null),t(Ae,fb),t(Ae,od),t(Ae,_b),t(Ae,xs),g(Or,xs,null),t(xs,bb),t(xs,rd),d(e,nu,c),d(e,Oe,c),g(Kr,Oe,null),t(Oe,yb),t(Oe,ad),t(Oe,Tb),t(Oe,ld),g(ea,ld,null),d(e,ou,c),d(e,Ke,c),g(ta,Ke,null),t(Ke,vb),t(Ke,cd),t(Ke,Mb),t(Ke,Js),g(sa,Js,null),t(Js,wb),t(Js,id),d(e,ru,c),d(e,et,c),g(na,et,null),t(et,$b),t(et,dd),t(et,kb),t(et,pd),g(oa,pd,null),d(e,au,c),d(e,tt,c),g(ra,tt,null),t(tt,jb),t(tt,md),t(tt,xb),t(tt,gd),g(aa,gd,null),d(e,lu,c),d(e,st,c),g(la,st,null),t(st,Jb),t(st,ud),t(st,Ub),t(st,hd),g(ca,hd,null),d(e,cu,c),d(e,nt,c),g(ia,nt,null),t(nt,Bb),t(nt,fd),t(nt,Ib),t(nt,_d),g(da,_d,null),d(e,iu,c),d(e,ot,c),g(pa,ot,null),t(ot,Zb),t(ot,bd),t(ot,zb),t(ot,yd),g(ma,yd,null),d(e,du,c),d(e,rt,c),g(ga,rt,null),t(rt,Wb),t(rt,Td),t(rt,Lb),t(rt,vd),g(ua,vd,null),d(e,pu,c),d(e,at,c),g(ha,at,null),t(at,Cb),t(at,Md),t(at,Vb),t(at,wd),g(fa,wd,null),d(e,mu,c),g(_a,e,c),d(e,gu,c),d(e,ba,c),d(e,uu,c),d(e,he,c),g(ya,he,null),t(he,Fb),t(he,$d),t(he,Gb),t(he,kd),t(he,Xb),t(he,jd),g(Ta,jd,null),d(e,hu,c),d(e,Gt,c),g(va,Gt,null),t(Gt,Rb),t(Gt,xd),g(Ma,xd,null),d(e,fu,c),d(e,lt,c),g(wa,lt,null),t(lt,Sb),t(lt,Jd),t(lt,Nb),t(lt,Ud),g($a,Ud,null),d(e,_u,c),d(e,ct,c),g(ka,ct,null),t(ct,Eb),t(ct,Bd),t(ct,Hb),t(ct,Id),g(ja,Id,null),d(e,bu,c),g(xa,e,c),d(e,yu,c),d(e,Ja,c),d(e,Tu,c),d(e,U,c),g(Ua,U,null),t(U,qb),t(U,Zd),t(U,Db),t(U,zd),t(U,Pb),g(Us,U,null),t(U,Qb),t(U,Wd),t(U,Yb),t(U,Bs),g(Ba,Bs,null),t(Bs,Ab),t(Bs,Ld),t(U,Ob),t(U,Is),g(Ia,Is,null),t(Is,Kb),t(Is,Cd),t(U,ey),t(U,Zs),g(Za,Zs,null),t(Zs,ty),t(Zs,Vd),t(U,sy),t(U,zs),g(za,zs,null),t(zs,ny),t(zs,Fd),t(U,oy),t(U,Ws),g(Wa,Ws,null),t(Ws,ry),t(Ws,Gd),t(U,ay),t(U,Ls),g(La,Ls,null),t(Ls,ly),t(Ls,Xd),t(U,cy),t(U,ht),g(Ca,ht,null),t(ht,iy),t(ht,Rd),t(ht,dy),t(ht,Sd),d(e,vu,c),d(e,Xt,c),g(Va,Xt,null),t(Xt,py),t(Xt,Nd),d(e,Mu,c),d(e,Rt,c),g(Fa,Rt,null),t(Rt,my),t(Rt,Ed),d(e,wu,c),d(e,fe,c),g(Ga,fe,null),t(fe,gy),t(fe,Hd),t(fe,uy),t(fe,F),g(Xa,F,null),t(F,hy),t(F,qd),t(F,fy),t(F,Dd),t(F,_y),t(F,Pd),t(F,by),t(F,Qd),t(F,yy),t(F,Yd),t(fe,Ty),t(fe,Cs),g(Ra,Cs,null),t(Cs,vy),t(Cs,Ad),d(e,$u,c),g(Sa,e,c),d(e,ku,c),d(e,_e,c),g(Na,_e,null),t(_e,My),t(_e,Od),t(_e,wy),t(_e,Kd),g(Ea,Kd,null),t(_e,$y),t(_e,ep),g(Ha,ep,null),d(e,ju,c),d(e,C,c),g(qa,C,null),t(C,ky),t(C,tp),t(C,jy),t(C,sp),t(C,xy),t(C,np),t(C,Jy),t(C,op),g(Da,op,null),t(C,Uy),t(C,rp),g(Pa,rp,null),d(e,xu,c),d(e,be,c),g(Qa,be,null),t(be,By),t(be,ap),t(be,Iy),t(be,lp),g(Ya,lp,null),t(be,Zy),t(be,cp),g(Aa,cp,null),d(e,Ju,c),g(Oa,e,c),d(e,Uu,c),d(e,z,c),g(Ka,z,null),t(z,zy),t(z,ip),t(z,Wy),g(Vs,z,null),t(z,Ly),g(Fs,z,null),t(z,Cy),t(z,Gs),g(el,Gs,null),t(Gs,Vy),t(Gs,dp),t(z,Fy),t(z,Xs),g(tl,Xs,null),t(Xs,Gy),t(Xs,pp),t(z,Xy),t(z,Rs),g(sl,Rs,null),t(Rs,Ry),t(Rs,mp),d(e,Bu,c),d(e,Y,c),g(nl,Y,null),t(Y,Sy),t(Y,gp),t(Y,Ny),g(Ss,Y,null),t(Y,Ey),g(Ns,Y,null),t(Y,Hy),t(Y,Es),g(ol,Es,null),t(Es,qy),t(Es,up),d(e,Iu,c),g(rl,e,c),d(e,Zu,c),d(e,it,c),g(al,it,null),t(it,Dy),t(it,hp),t(it,Py),t(it,Hs),g(ll,Hs,null),t(Hs,Qy),t(Hs,fp),d(e,zu,c),d(e,Z,c),g(cl,Z,null),t(Z,Yy),t(Z,_p),t(Z,Ay),t(Z,bp),t(Z,Oy),t(Z,qs),g(il,qs,null),t(qs,Ky),t(qs,yp),t(Z,eT),t(Z,Ds),g(dl,Ds,null),t(Ds,tT),t(Ds,Tp),t(Z,sT),t(Z,Ps),g(pl,Ps,null),t(Ps,nT),t(Ps,vp),t(Z,oT),t(Z,Qs),g(ml,Qs,null),t(Qs,rT),t(Qs,Mp),t(Z,aT),t(Z,Ys),g(gl,Ys,null),t(Ys,lT),t(Ys,wp),d(e,Wu,c),d(e,V,c),g(ul,V,null),t(V,cT),t(V,$p),t(V,iT),t(V,kp),t(V,dT),t(V,As),g(hl,As,null),t(As,pT),t(As,jp),t(V,mT),t(V,Os),g(fl,Os,null),t(Os,gT),t(Os,xp),t(V,uT),t(V,Ks),g(_l,Ks,null),t(Ks,hT),t(Ks,Jp),d(e,Lu,c),d(e,ye,c),g(bl,ye,null),t(ye,fT),t(ye,Up),t(ye,_T),t(ye,en),g(yl,en,null),t(en,bT),t(en,Bp),t(ye,yT),t(ye,tn),g(Tl,tn,null),t(tn,TT),t(tn,Ip),d(e,Cu,c),d(e,um,c),Vu=!0},p(e,[c]){const vl={};c&2&&(vl.$$scope={dirty:c,ctx:e}),Pt.$set(vl);const Ml={};c&2&&(Ml.$$scope={dirty:c,ctx:e}),Qt.$set(Ml);const wl={};c&2&&(wl.$$scope={dirty:c,ctx:e}),Yt.$set(wl);const $l={};c&2&&($l.$$scope={dirty:c,ctx:e}),At.$set($l);const kl={};c&2&&(kl.$$scope={dirty:c,ctx:e}),Ot.$set(kl);const jl={};c&2&&(jl.$$scope={dirty:c,ctx:e}),Kt.$set(jl);const xl={};c&2&&(xl.$$scope={dirty:c,ctx:e}),es.$set(xl);const Jl={};c&2&&(Jl.$$scope={dirty:c,ctx:e}),ts.$set(Jl);const Ul={};c&2&&(Ul.$$scope={dirty:c,ctx:e}),ss.$set(Ul);const Bl={};c&2&&(Bl.$$scope={dirty:c,ctx:e}),ns.$set(Bl);const Il={};c&2&&(Il.$$scope={dirty:c,ctx:e}),os.$set(Il);const Zl={};c&2&&(Zl.$$scope={dirty:c,ctx:e}),rs.$set(Zl);const zl={};c&2&&(zl.$$scope={dirty:c,ctx:e}),as.$set(zl);const Wl={};c&2&&(Wl.$$scope={dirty:c,ctx:e}),ls.$set(Wl);const St={};c&2&&(St.$$scope={dirty:c,ctx:e}),cs.$set(St);const Ll={};c&2&&(Ll.$$scope={dirty:c,ctx:e}),is.$set(Ll);const Nt={};c&2&&(Nt.$$scope={dirty:c,ctx:e}),ds.$set(Nt);const Cl={};c&2&&(Cl.$$scope={dirty:c,ctx:e}),ps.$set(Cl);const Et={};c&2&&(Et.$$scope={dirty:c,ctx:e}),ms.$set(Et);const Vl={};c&2&&(Vl.$$scope={dirty:c,ctx:e}),gs.$set(Vl);const dt={};c&2&&(dt.$$scope={dirty:c,ctx:e}),us.$set(dt);const hm={};c&2&&(hm.$$scope={dirty:c,ctx:e}),hs.$set(hm);const A={};c&2&&(A.$$scope={dirty:c,ctx:e}),fs.$set(A);const fm={};c&2&&(fm.$$scope={dirty:c,ctx:e}),_s.$set(fm);const Te={};c&2&&(Te.$$scope={dirty:c,ctx:e}),bs.$set(Te);const _m={};c&2&&(_m.$$scope={dirty:c,ctx:e}),ys.$set(_m);const ve={};c&2&&(ve.$$scope={dirty:c,ctx:e}),Ts.$set(ve);const bm={};c&2&&(bm.$$scope={dirty:c,ctx:e}),vs.$set(bm);const pt={};c&2&&(pt.$$scope={dirty:c,ctx:e}),Ms.$set(pt);const ym={};c&2&&(ym.$$scope={dirty:c,ctx:e}),ws.$set(ym);const mt={};c&2&&(mt.$$scope={dirty:c,ctx:e}),$s.$set(mt);const Tm={};c&2&&(Tm.$$scope={dirty:c,ctx:e}),Us.$set(Tm);const gt={};c&2&&(gt.$$scope={dirty:c,ctx:e}),Vs.$set(gt);const vm={};c&2&&(vm.$$scope={dirty:c,ctx:e}),Fs.$set(vm);const ut={};c&2&&(ut.$$scope={dirty:c,ctx:e}),Ss.$set(ut);const Mm={};c&2&&(Mm.$$scope={dirty:c,ctx:e}),Ns.$set(Mm)},i(e){Vu||(u(w.$$.fragment,e),u(yn.$$.fragment,e),u(Mn.$$.fragment,e),u(Jn.$$.fragment,e),u(Zn.$$.fragment,e),u(zn.$$.fragment,e),u(Wn.$$.fragment,e),u(Ln.$$.fragment,e),u(Cn.$$.fragment,e),u(Vn.$$.fragment,e),u(Fn.$$.fragment,e),u(Gn.$$.fragment,e),u(Xn.$$.fragment,e),u(Rn.$$.fragment,e),u(Sn.$$.fragment,e),u(Nn.$$.fragment,e),u(En.$$.fragment,e),u(Hn.$$.fragment,e),u(qn.$$.fragment,e),u(Dn.$$.fragment,e),u(Pn.$$.fragment,e),u(Qn.$$.fragment,e),u(Yn.$$.fragment,e),u(An.$$.fragment,e),u(On.$$.fragment,e),u(Kn.$$.fragment,e),u(eo.$$.fragment,e),u(to.$$.fragment,e),u(no.$$.fragment,e),u(oo.$$.fragment,e),u(Pt.$$.fragment,e),u(ro.$$.fragment,e),u(ao.$$.fragment,e),u(Qt.$$.fragment,e),u(Yt.$$.fragment,e),u(lo.$$.fragment,e),u(co.$$.fragment,e),u(At.$$.fragment,e),u(io.$$.fragment,e),u(po.$$.fragment,e),u(Ot.$$.fragment,e),u(mo.$$.fragment,e),u(go.$$.fragment,e),u(Kt.$$.fragment,e),u(uo.$$.fragment,e),u(ho.$$.fragment,e),u(es.$$.fragment,e),u(fo.$$.fragment,e),u(_o.$$.fragment,e),u(ts.$$.fragment,e),u(bo.$$.fragment,e),u(yo.$$.fragment,e),u(ss.$$.fragment,e),u(To.$$.fragment,e),u(vo.$$.fragment,e),u(ns.$$.fragment,e),u(Mo.$$.fragment,e),u(wo.$$.fragment,e),u($o.$$.fragment,e),u(ko.$$.fragment,e),u(os.$$.fragment,e),u(jo.$$.fragment,e),u(xo.$$.fragment,e),u(Jo.$$.fragment,e),u(Uo.$$.fragment,e),u(rs.$$.fragment,e),u(Bo.$$.fragment,e),u(Io.$$.fragment,e),u(Zo.$$.fragment,e),u(zo.$$.fragment,e),u(Wo.$$.fragment,e),u(Lo.$$.fragment,e),u(Co.$$.fragment,e),u(Vo.$$.fragment,e),u(as.$$.fragment,e),u(Fo.$$.fragment,e),u(Go.$$.fragment,e),u(ls.$$.fragment,e),u(Xo.$$.fragment,e),u(Ro.$$.fragment,e),u(cs.$$.fragment,e),u(is.$$.fragment,e),u(So.$$.fragment,e),u(No.$$.fragment,e),u(ds.$$.fragment,e),u(ps.$$.fragment,e),u(Eo.$$.fragment,e),u(Ho.$$.fragment,e),u(ms.$$.fragment,e),u(qo.$$.fragment,e),u(Do.$$.fragment,e),u(gs.$$.fragment,e),u(Po.$$.fragment,e),u(Qo.$$.fragment,e),u(us.$$.fragment,e),u(hs.$$.fragment,e),u(Yo.$$.fragment,e),u(Ao.$$.fragment,e),u(fs.$$.fragment,e),u(Oo.$$.fragment,e),u(Ko.$$.fragment,e),u(_s.$$.fragment,e),u(er.$$.fragment,e),u(tr.$$.fragment,e),u(bs.$$.fragment,e),u(ys.$$.fragment,e),u(sr.$$.fragment,e),u(nr.$$.fragment,e),u(Ts.$$.fragment,e),u(or.$$.fragment,e),u(rr.$$.fragment,e),u(vs.$$.fragment,e),u(ar.$$.fragment,e),u(lr.$$.fragment,e),u(Ms.$$.fragment,e),u(cr.$$.fragment,e),u(ir.$$.fragment,e),u(ws.$$.fragment,e),u(dr.$$.fragment,e),u(pr.$$.fragment,e),u($s.$$.fragment,e),u(mr.$$.fragment,e),u(gr.$$.fragment,e),u(ur.$$.fragment,e),u(hr.$$.fragment,e),u(fr.$$.fragment,e),u(_r.$$.fragment,e),u(br.$$.fragment,e),u(yr.$$.fragment,e),u(Tr.$$.fragment,e),u(vr.$$.fragment,e),u(Mr.$$.fragment,e),u(wr.$$.fragment,e),u($r.$$.fragment,e),u(kr.$$.fragment,e),u(jr.$$.fragment,e),u(xr.$$.fragment,e),u(Jr.$$.fragment,e),u(Ur.$$.fragment,e),u(Br.$$.fragment,e),u(Ir.$$.fragment,e),u(Zr.$$.fragment,e),u(zr.$$.fragment,e),u(Wr.$$.fragment,e),u(Lr.$$.fragment,e),u(Cr.$$.fragment,e),u(Vr.$$.fragment,e),u(Fr.$$.fragment,e),u(Gr.$$.fragment,e),u(Xr.$$.fragment,e),u(Rr.$$.fragment,e),u(Sr.$$.fragment,e),u(Nr.$$.fragment,e),u(Er.$$.fragment,e),u(Hr.$$.fragment,e),u(qr.$$.fragment,e),u(Dr.$$.fragment,e),u(Pr.$$.fragment,e),u(Qr.$$.fragment,e),u(Yr.$$.fragment,e),u(Ar.$$.fragment,e),u(Or.$$.fragment,e),u(Kr.$$.fragment,e),u(ea.$$.fragment,e),u(ta.$$.fragment,e),u(sa.$$.fragment,e),u(na.$$.fragment,e),u(oa.$$.fragment,e),u(ra.$$.fragment,e),u(aa.$$.fragment,e),u(la.$$.fragment,e),u(ca.$$.fragment,e),u(ia.$$.fragment,e),u(da.$$.fragment,e),u(pa.$$.fragment,e),u(ma.$$.fragment,e),u(ga.$$.fragment,e),u(ua.$$.fragment,e),u(ha.$$.fragment,e),u(fa.$$.fragment,e),u(_a.$$.fragment,e),u(ya.$$.fragment,e),u(Ta.$$.fragment,e),u(va.$$.fragment,e),u(Ma.$$.fragment,e),u(wa.$$.fragment,e),u($a.$$.fragment,e),u(ka.$$.fragment,e),u(ja.$$.fragment,e),u(xa.$$.fragment,e),u(Ua.$$.fragment,e),u(Us.$$.fragment,e),u(Ba.$$.fragment,e),u(Ia.$$.fragment,e),u(Za.$$.fragment,e),u(za.$$.fragment,e),u(Wa.$$.fragment,e),u(La.$$.fragment,e),u(Ca.$$.fragment,e),u(Va.$$.fragment,e),u(Fa.$$.fragment,e),u(Ga.$$.fragment,e),u(Xa.$$.fragment,e),u(Ra.$$.fragment,e),u(Sa.$$.fragment,e),u(Na.$$.fragment,e),u(Ea.$$.fragment,e),u(Ha.$$.fragment,e),u(qa.$$.fragment,e),u(Da.$$.fragment,e),u(Pa.$$.fragment,e),u(Qa.$$.fragment,e),u(Ya.$$.fragment,e),u(Aa.$$.fragment,e),u(Oa.$$.fragment,e),u(Ka.$$.fragment,e),u(Vs.$$.fragment,e),u(Fs.$$.fragment,e),u(el.$$.fragment,e),u(tl.$$.fragment,e),u(sl.$$.fragment,e),u(nl.$$.fragment,e),u(Ss.$$.fragment,e),u(Ns.$$.fragment,e),u(ol.$$.fragment,e),u(rl.$$.fragment,e),u(al.$$.fragment,e),u(ll.$$.fragment,e),u(cl.$$.fragment,e),u(il.$$.fragment,e),u(dl.$$.fragment,e),u(pl.$$.fragment,e),u(ml.$$.fragment,e),u(gl.$$.fragment,e),u(ul.$$.fragment,e),u(hl.$$.fragment,e),u(fl.$$.fragment,e),u(_l.$$.fragment,e),u(bl.$$.fragment,e),u(yl.$$.fragment,e),u(Tl.$$.fragment,e),Vu=!0)},o(e){h(w.$$.fragment,e),h(yn.$$.fragment,e),h(Mn.$$.fragment,e),h(Jn.$$.fragment,e),h(Zn.$$.fragment,e),h(zn.$$.fragment,e),h(Wn.$$.fragment,e),h(Ln.$$.fragment,e),h(Cn.$$.fragment,e),h(Vn.$$.fragment,e),h(Fn.$$.fragment,e),h(Gn.$$.fragment,e),h(Xn.$$.fragment,e),h(Rn.$$.fragment,e),h(Sn.$$.fragment,e),h(Nn.$$.fragment,e),h(En.$$.fragment,e),h(Hn.$$.fragment,e),h(qn.$$.fragment,e),h(Dn.$$.fragment,e),h(Pn.$$.fragment,e),h(Qn.$$.fragment,e),h(Yn.$$.fragment,e),h(An.$$.fragment,e),h(On.$$.fragment,e),h(Kn.$$.fragment,e),h(eo.$$.fragment,e),h(to.$$.fragment,e),h(no.$$.fragment,e),h(oo.$$.fragment,e),h(Pt.$$.fragment,e),h(ro.$$.fragment,e),h(ao.$$.fragment,e),h(Qt.$$.fragment,e),h(Yt.$$.fragment,e),h(lo.$$.fragment,e),h(co.$$.fragment,e),h(At.$$.fragment,e),h(io.$$.fragment,e),h(po.$$.fragment,e),h(Ot.$$.fragment,e),h(mo.$$.fragment,e),h(go.$$.fragment,e),h(Kt.$$.fragment,e),h(uo.$$.fragment,e),h(ho.$$.fragment,e),h(es.$$.fragment,e),h(fo.$$.fragment,e),h(_o.$$.fragment,e),h(ts.$$.fragment,e),h(bo.$$.fragment,e),h(yo.$$.fragment,e),h(ss.$$.fragment,e),h(To.$$.fragment,e),h(vo.$$.fragment,e),h(ns.$$.fragment,e),h(Mo.$$.fragment,e),h(wo.$$.fragment,e),h($o.$$.fragment,e),h(ko.$$.fragment,e),h(os.$$.fragment,e),h(jo.$$.fragment,e),h(xo.$$.fragment,e),h(Jo.$$.fragment,e),h(Uo.$$.fragment,e),h(rs.$$.fragment,e),h(Bo.$$.fragment,e),h(Io.$$.fragment,e),h(Zo.$$.fragment,e),h(zo.$$.fragment,e),h(Wo.$$.fragment,e),h(Lo.$$.fragment,e),h(Co.$$.fragment,e),h(Vo.$$.fragment,e),h(as.$$.fragment,e),h(Fo.$$.fragment,e),h(Go.$$.fragment,e),h(ls.$$.fragment,e),h(Xo.$$.fragment,e),h(Ro.$$.fragment,e),h(cs.$$.fragment,e),h(is.$$.fragment,e),h(So.$$.fragment,e),h(No.$$.fragment,e),h(ds.$$.fragment,e),h(ps.$$.fragment,e),h(Eo.$$.fragment,e),h(Ho.$$.fragment,e),h(ms.$$.fragment,e),h(qo.$$.fragment,e),h(Do.$$.fragment,e),h(gs.$$.fragment,e),h(Po.$$.fragment,e),h(Qo.$$.fragment,e),h(us.$$.fragment,e),h(hs.$$.fragment,e),h(Yo.$$.fragment,e),h(Ao.$$.fragment,e),h(fs.$$.fragment,e),h(Oo.$$.fragment,e),h(Ko.$$.fragment,e),h(_s.$$.fragment,e),h(er.$$.fragment,e),h(tr.$$.fragment,e),h(bs.$$.fragment,e),h(ys.$$.fragment,e),h(sr.$$.fragment,e),h(nr.$$.fragment,e),h(Ts.$$.fragment,e),h(or.$$.fragment,e),h(rr.$$.fragment,e),h(vs.$$.fragment,e),h(ar.$$.fragment,e),h(lr.$$.fragment,e),h(Ms.$$.fragment,e),h(cr.$$.fragment,e),h(ir.$$.fragment,e),h(ws.$$.fragment,e),h(dr.$$.fragment,e),h(pr.$$.fragment,e),h($s.$$.fragment,e),h(mr.$$.fragment,e),h(gr.$$.fragment,e),h(ur.$$.fragment,e),h(hr.$$.fragment,e),h(fr.$$.fragment,e),h(_r.$$.fragment,e),h(br.$$.fragment,e),h(yr.$$.fragment,e),h(Tr.$$.fragment,e),h(vr.$$.fragment,e),h(Mr.$$.fragment,e),h(wr.$$.fragment,e),h($r.$$.fragment,e),h(kr.$$.fragment,e),h(jr.$$.fragment,e),h(xr.$$.fragment,e),h(Jr.$$.fragment,e),h(Ur.$$.fragment,e),h(Br.$$.fragment,e),h(Ir.$$.fragment,e),h(Zr.$$.fragment,e),h(zr.$$.fragment,e),h(Wr.$$.fragment,e),h(Lr.$$.fragment,e),h(Cr.$$.fragment,e),h(Vr.$$.fragment,e),h(Fr.$$.fragment,e),h(Gr.$$.fragment,e),h(Xr.$$.fragment,e),h(Rr.$$.fragment,e),h(Sr.$$.fragment,e),h(Nr.$$.fragment,e),h(Er.$$.fragment,e),h(Hr.$$.fragment,e),h(qr.$$.fragment,e),h(Dr.$$.fragment,e),h(Pr.$$.fragment,e),h(Qr.$$.fragment,e),h(Yr.$$.fragment,e),h(Ar.$$.fragment,e),h(Or.$$.fragment,e),h(Kr.$$.fragment,e),h(ea.$$.fragment,e),h(ta.$$.fragment,e),h(sa.$$.fragment,e),h(na.$$.fragment,e),h(oa.$$.fragment,e),h(ra.$$.fragment,e),h(aa.$$.fragment,e),h(la.$$.fragment,e),h(ca.$$.fragment,e),h(ia.$$.fragment,e),h(da.$$.fragment,e),h(pa.$$.fragment,e),h(ma.$$.fragment,e),h(ga.$$.fragment,e),h(ua.$$.fragment,e),h(ha.$$.fragment,e),h(fa.$$.fragment,e),h(_a.$$.fragment,e),h(ya.$$.fragment,e),h(Ta.$$.fragment,e),h(va.$$.fragment,e),h(Ma.$$.fragment,e),h(wa.$$.fragment,e),h($a.$$.fragment,e),h(ka.$$.fragment,e),h(ja.$$.fragment,e),h(xa.$$.fragment,e),h(Ua.$$.fragment,e),h(Us.$$.fragment,e),h(Ba.$$.fragment,e),h(Ia.$$.fragment,e),h(Za.$$.fragment,e),h(za.$$.fragment,e),h(Wa.$$.fragment,e),h(La.$$.fragment,e),h(Ca.$$.fragment,e),h(Va.$$.fragment,e),h(Fa.$$.fragment,e),h(Ga.$$.fragment,e),h(Xa.$$.fragment,e),h(Ra.$$.fragment,e),h(Sa.$$.fragment,e),h(Na.$$.fragment,e),h(Ea.$$.fragment,e),h(Ha.$$.fragment,e),h(qa.$$.fragment,e),h(Da.$$.fragment,e),h(Pa.$$.fragment,e),h(Qa.$$.fragment,e),h(Ya.$$.fragment,e),h(Aa.$$.fragment,e),h(Oa.$$.fragment,e),h(Ka.$$.fragment,e),h(Vs.$$.fragment,e),h(Fs.$$.fragment,e),h(el.$$.fragment,e),h(tl.$$.fragment,e),h(sl.$$.fragment,e),h(nl.$$.fragment,e),h(Ss.$$.fragment,e),h(Ns.$$.fragment,e),h(ol.$$.fragment,e),h(rl.$$.fragment,e),h(al.$$.fragment,e),h(ll.$$.fragment,e),h(cl.$$.fragment,e),h(il.$$.fragment,e),h(dl.$$.fragment,e),h(pl.$$.fragment,e),h(ml.$$.fragment,e),h(gl.$$.fragment,e),h(ul.$$.fragment,e),h(hl.$$.fragment,e),h(fl.$$.fragment,e),h(_l.$$.fragment,e),h(bl.$$.fragment,e),h(yl.$$.fragment,e),h(Tl.$$.fragment,e),Vu=!1},d(e){e&&(s(k),s(b),s(_),s(r),s($),s(wm),s($m),s(Tn),s(km),s(vn),s(jm),s(xm),s(wn),s(Jm),s($n),s(Um),s(kn),s(Bm),s(jn),s(Im),s(xn),s(Zm),s(zm),s(Un),s(Wm),s(Bn),s(Lm),s(In),s(Cm),s(Vm),s(kt),s(Fm),s(jt),s(Gm),s(xt),s(Xm),s(Jt),s(Rm),s(Sm),s(Ut),s(Nm),s(Bt),s(Em),s(It),s(Hm),s(Zt),s(qm),s(zt),s(Dm),s(Wt),s(Pm),s(Lt),s(Qm),s(Ct),s(Ym),s(Vt),s(Am),s(Ft),s(Om),s(Km),s(je),s(eg),s(xe),s(tg),s(Je),s(sg),s(ng),s(so),s(og),s(rg),s(ee),s(ag),s(W),s(lg),s(X),s(cg),s(R),s(ig),s(te),s(dg),s(se),s(pg),s(ne),s(mg),s(oe),s(gg),s(re),s(ug),s(Ue),s(hg),s(L),s(fg),s(ae),s(_g),s(le),s(bg),s(Be),s(yg),s(Ie),s(Tg),s(Ze),s(vg),s(ce),s(Mg),s(ie),s(wg),s(S),s($g),s(N),s(kg),s(de),s(jg),s(E),s(xg),s(H),s(Jg),s(pe),s(Ug),s(me),s(Bg),s(q),s(Ig),s(ge),s(Zg),s(ue),s(zg),s(D),s(Wg),s(P),s(Lg),s(Q),s(Cg),s(Vg),s(ze),s(Fg),s(We),s(Gg),s(Le),s(Xg),s(Ce),s(Rg),s(Ve),s(Sg),s(Fe),s(Ng),s(Ge),s(Eg),s(Xe),s(Hg),s(Re),s(qg),s(Se),s(Dg),s(Ne),s(Pg),s(Ee),s(Qg),s(He),s(Yg),s(qe),s(Ag),s(De),s(Og),s(Kg),s(Pe),s(eu),s(Qe),s(tu),s(Ye),s(su),s(Ae),s(nu),s(Oe),s(ou),s(Ke),s(ru),s(et),s(au),s(tt),s(lu),s(st),s(cu),s(nt),s(iu),s(ot),s(du),s(rt),s(pu),s(at),s(mu),s(gu),s(ba),s(uu),s(he),s(hu),s(Gt),s(fu),s(lt),s(_u),s(ct),s(bu),s(yu),s(Ja),s(Tu),s(U),s(vu),s(Xt),s(Mu),s(Rt),s(wu),s(fe),s($u),s(ku),s(_e),s(ju),s(C),s(xu),s(be),s(Ju),s(Uu),s(z),s(Bu),s(Y),s(Iu),s(Zu),s(it),s(zu),s(Z),s(Wu),s(V),s(Lu),s(ye),s(Cu),s(um)),s(i),f(w,e),f(yn,e),f(Mn,e),f(Jn,e),f(Zn,e),f(zn),f(Wn),f(Ln),f(Cn),f(Vn,e),f(Fn),f(Gn),f(Xn),f(Rn),f(Sn),f(Nn),f(En),f(Hn),f(qn),f(Dn),f(Pn,e),f(Qn),f(Yn),f(An),f(On),f(Kn),f(eo),f(to,e),f(no,e),f(oo),f(Pt),f(ro),f(ao),f(Qt),f(Yt),f(lo),f(co),f(At),f(io),f(po),f(Ot),f(mo),f(go),f(Kt),f(uo),f(ho),f(es),f(fo),f(_o),f(ts),f(bo),f(yo),f(ss),f(To),f(vo),f(ns),f(Mo),f(wo),f($o),f(ko),f(os),f(jo),f(xo),f(Jo),f(Uo),f(rs),f(Bo),f(Io),f(Zo),f(zo),f(Wo),f(Lo),f(Co),f(Vo),f(as),f(Fo),f(Go),f(ls),f(Xo),f(Ro),f(cs),f(is),f(So),f(No),f(ds),f(ps),f(Eo),f(Ho),f(ms),f(qo),f(Do),f(gs),f(Po),f(Qo),f(us),f(hs),f(Yo),f(Ao),f(fs),f(Oo),f(Ko),f(_s),f(er),f(tr),f(bs),f(ys),f(sr),f(nr),f(Ts),f(or),f(rr),f(vs),f(ar),f(lr),f(Ms),f(cr),f(ir),f(ws),f(dr),f(pr),f($s),f(mr),f(gr,e),f(ur),f(hr),f(fr),f(_r),f(br),f(yr),f(Tr),f(vr),f(Mr),f(wr),f($r),f(kr),f(jr),f(xr),f(Jr),f(Ur),f(Br),f(Ir),f(Zr),f(zr),f(Wr),f(Lr),f(Cr),f(Vr),f(Fr),f(Gr),f(Xr),f(Rr),f(Sr),f(Nr),f(Er,e),f(Hr),f(qr),f(Dr),f(Pr),f(Qr),f(Yr),f(Ar),f(Or),f(Kr),f(ea),f(ta),f(sa),f(na),f(oa),f(ra),f(aa),f(la),f(ca),f(ia),f(da),f(pa),f(ma),f(ga),f(ua),f(ha),f(fa),f(_a,e),f(ya),f(Ta),f(va),f(Ma),f(wa),f($a),f(ka),f(ja),f(xa,e),f(Ua),f(Us),f(Ba),f(Ia),f(Za),f(za),f(Wa),f(La),f(Ca),f(Va),f(Fa),f(Ga),f(Xa),f(Ra),f(Sa,e),f(Na),f(Ea),f(Ha),f(qa),f(Da),f(Pa),f(Qa),f(Ya),f(Aa),f(Oa,e),f(Ka),f(Vs),f(Fs),f(el),f(tl),f(sl),f(nl),f(Ss),f(Ns),f(ol),f(rl,e),f(al),f(ll),f(cl),f(il),f(dl),f(pl),f(ml),f(gl),f(ul),f(hl),f(fl),f(_l),f(bl),f(yl),f(Tl)}}}const i$='{"title":"Utilities for Generation","local":"utilities-for-generation","sections":[{"title":"Generate Outputs","local":"generate-outputs","sections":[{"title":"PyTorch","local":"transformers.generation.GenerateDecoderOnlyOutput","sections":[],"depth":3},{"title":"TensorFlow","local":"transformers.generation.TFGreedySearchEncoderDecoderOutput","sections":[],"depth":3},{"title":"FLAX","local":"transformers.generation.FlaxSampleOutput","sections":[],"depth":3}],"depth":2},{"title":"LogitsProcessor","local":"logitsprocessor","sections":[{"title":"PyTorch","local":"transformers.AlternatingCodebooksLogitsProcessor","sections":[],"depth":3},{"title":"TensorFlow","local":"transformers.TFForcedBOSTokenLogitsProcessor","sections":[],"depth":3},{"title":"FLAX","local":"transformers.FlaxForcedBOSTokenLogitsProcessor","sections":[],"depth":3}],"depth":2},{"title":"StoppingCriteria","local":"transformers.StoppingCriteria","sections":[],"depth":2},{"title":"Constraints","local":"transformers.Constraint","sections":[],"depth":2},{"title":"BeamSearch","local":"transformers.BeamScorer","sections":[],"depth":2},{"title":"Streamers","local":"transformers.TextStreamer","sections":[],"depth":2},{"title":"Caches","local":"transformers.Cache","sections":[],"depth":2}],"depth":1}';function d$(j){return Mw(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class b$ extends ww{constructor(i){super(),$w(this,i,d$,c$,vw,{})}}export{b$ as component};
