import{s as Ql,o as Hl,n as ss}from"../chunks/scheduler.9bc65507.js";import{S as Al,i as zl,g as U,s as c,r as g,A as El,h as $,f as e,c as i,j as Nl,u as y,x as W,k as Jl,y as Sl,a as t,v as J,d as f,t as w,w as u}from"../chunks/index.707bf1b6.js";import{T as fl}from"../chunks/Tip.c2ecdbf4.js";import{Y as Ll}from"../chunks/Youtube.e1129c6f.js";import{C as X}from"../chunks/CodeBlock.54a9f38d.js";import{D as ql}from"../chunks/DocNotebookDropdown.41f65cb5.js";import{F as os,M as Ms}from"../chunks/Markdown.8ab98a13.js";import{H as vs}from"../chunks/Heading.342b1fa6.js";function Dl(Z){let a,M="このチュートリアルで説明するタスクは、次のモデル アーキテクチャでサポートされています。",l,r,h='<a href="../model_doc/beit">BEiT</a>, <a href="../model_doc/data2vec-vision">Data2VecVision</a>, <a href="../model_doc/dpt">DPT</a>, <a href="../model_doc/mobilenet_v2">MobileNetV2</a>, <a href="../model_doc/mobilevit">MobileViT</a>, <a href="../model_doc/mobilevitv2">MobileViTV2</a>, <a href="../model_doc/segformer">SegFormer</a>, <a href="../model_doc/upernet">UPerNet</a>';return{c(){a=U("p"),a.textContent=M,l=c(),r=U("p"),r.innerHTML=h},l(d){a=$(d,"P",{"data-svelte-h":!0}),W(a)!=="svelte-16ydqtq"&&(a.textContent=M),l=i(d),r=$(d,"P",{"data-svelte-h":!0}),W(r)!=="svelte-19l83ao"&&(r.innerHTML=h)},m(d,k){t(d,a,k),t(d,l,k),t(d,r,k)},p:ss,d(d){d&&(e(a),e(l),e(r))}}}function Kl(Z){let a,M='モデルを過学習に対してより堅牢にするために、画像データセットにいくつかのデータ拡張を適用するのが一般的です。このガイドでは、<a href="https://pytorch.org/vision/stable/index.html" rel="nofollow">torchvision</a> の <a href="https://pytorch.org/vision/stable/generated/torchvision.transforms.ColorJitter.html" rel="nofollow"><code>ColorJitter</code></a> 関数を使用します。 ) を使用して画像の色のプロパティをランダムに変更しますが、任意の画像ライブラリを使用することもできます。',l,r,h,d,k="次に、モデルの画像と注釈を準備するための 2 つの前処理関数を作成します。これらの関数は、画像を<code>pixel_values</code>に変換し、注釈を<code>labels</code>に変換します。トレーニング セットの場合、画像を画像プロセッサに提供する前に <code>jitter</code> が適用されます。テスト セットの場合、テスト中にデータ拡張が適用されないため、画像プロセッサは<code>images</code>を切り取って正規化し、<code>ラベル</code>のみを切り取ります。",B,I,R,C,Y="データセット全体に<code>jitter</code>を適用するには、🤗 Datasets <code>set_transform</code> 関数を使用します。変換はオンザフライで適用されるため、高速で消費するディスク容量が少なくなります。",v,b,V;return r=new X({props:{code:"ZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjBDb2xvckppdHRlciUwQSUwQWppdHRlciUyMCUzRCUyMENvbG9ySml0dGVyKGJyaWdodG5lc3MlM0QwLjI1JTJDJTIwY29udHJhc3QlM0QwLjI1JTJDJTIwc2F0dXJhdGlvbiUzRDAuMjUlMkMlMjBodWUlM0QwLjEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> ColorJitter

<span class="hljs-meta">&gt;&gt;&gt; </span>jitter = ColorJitter(brightness=<span class="hljs-number">0.25</span>, contrast=<span class="hljs-number">0.25</span>, saturation=<span class="hljs-number">0.25</span>, hue=<span class="hljs-number">0.1</span>)`,wrap:!1}}),I=new X({props:{code:"ZGVmJTIwdHJhaW5fdHJhbnNmb3JtcyhleGFtcGxlX2JhdGNoKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlcyUyMCUzRCUyMCU1QmppdHRlcih4KSUyMGZvciUyMHglMjBpbiUyMGV4YW1wbGVfYmF0Y2glNUIlMjJpbWFnZSUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMGxhYmVscyUyMCUzRCUyMCU1QnglMjBmb3IlMjB4JTIwaW4lMjBleGFtcGxlX2JhdGNoJTVCJTIyYW5ub3RhdGlvbiUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW5wdXRzJTBBJTBBJTBBZGVmJTIwdmFsX3RyYW5zZm9ybXMoZXhhbXBsZV9iYXRjaCklM0ElMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjAlNUJ4JTIwZm9yJTIweCUyMGluJTIwZXhhbXBsZV9iYXRjaCU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTIwJTNEJTIwJTVCeCUyMGZvciUyMHglMjBpbiUyMGV4YW1wbGVfYmF0Y2glNUIlMjJhbm5vdGF0aW9uJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlcyUyQyUyMGxhYmVscyklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">train_transforms</span>(<span class="hljs-params">example_batch</span>):
<span class="hljs-meta">... </span>    images = [jitter(x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">... </span>    labels = [x <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;annotation&quot;</span>]]
<span class="hljs-meta">... </span>    inputs = image_processor(images, labels)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> inputs


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">val_transforms</span>(<span class="hljs-params">example_batch</span>):
<span class="hljs-meta">... </span>    images = [x <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">... </span>    labels = [x <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;annotation&quot;</span>]]
<span class="hljs-meta">... </span>    inputs = image_processor(images, labels)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> inputs`,wrap:!1}}),b=new X({props:{code:"dHJhaW5fZHMuc2V0X3RyYW5zZm9ybSh0cmFpbl90cmFuc2Zvcm1zKSUwQXRlc3RfZHMuc2V0X3RyYW5zZm9ybSh2YWxfdHJhbnNmb3Jtcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>train_ds.set_transform(train_transforms)
<span class="hljs-meta">&gt;&gt;&gt; </span>test_ds.set_transform(val_transforms)`,wrap:!1}}),{c(){a=U("p"),a.innerHTML=M,l=c(),g(r.$$.fragment),h=c(),d=U("p"),d.innerHTML=k,B=c(),g(I.$$.fragment),R=c(),C=U("p"),C.innerHTML=Y,v=c(),g(b.$$.fragment)},l(m){a=$(m,"P",{"data-svelte-h":!0}),W(a)!=="svelte-14eknvb"&&(a.innerHTML=M),l=i(m),y(r.$$.fragment,m),h=i(m),d=$(m,"P",{"data-svelte-h":!0}),W(d)!=="svelte-166rb6n"&&(d.innerHTML=k),B=i(m),y(I.$$.fragment,m),R=i(m),C=$(m,"P",{"data-svelte-h":!0}),W(C)!=="svelte-wbpxor"&&(C.innerHTML=Y),v=i(m),y(b.$$.fragment,m)},m(m,T){t(m,a,T),t(m,l,T),J(r,m,T),t(m,h,T),t(m,d,T),t(m,B,T),J(I,m,T),t(m,R,T),t(m,C,T),t(m,v,T),J(b,m,T),V=!0},p:ss,i(m){V||(f(r.$$.fragment,m),f(I.$$.fragment,m),f(b.$$.fragment,m),V=!0)},o(m){w(r.$$.fragment,m),w(I.$$.fragment,m),w(b.$$.fragment,m),V=!1},d(m){m&&(e(a),e(l),e(h),e(d),e(B),e(R),e(C),e(v)),u(r,m),u(I,m),u(b,m)}}}function Pl(Z){let a,M;return a=new Ms({props:{$$slots:{default:[Kl]},$$scope:{ctx:Z}}}),{c(){g(a.$$.fragment)},l(l){y(a.$$.fragment,l)},m(l,r){J(a,l,r),M=!0},p(l,r){const h={};r&2&&(h.$$scope={dirty:r,ctx:l}),a.$set(h)},i(l){M||(f(a.$$.fragment,l),M=!0)},o(l){w(a.$$.fragment,l),M=!1},d(l){u(a,l)}}}function Ol(Z){let a,M=`モデルを過学習に対してより堅牢にするために、画像データセットにいくつかのデータ拡張を適用するのが一般的です。
このガイドでは、<a href="https://www.tensorflow.org/api_docs/python/tf/image" rel="nofollow"><code>tf.image</code></a> を使用して画像の色のプロパティをランダムに変更しますが、任意のプロパティを使用することもできます。画像
好きな図書館。
2 つの別々の変換関数を定義します。`,l,r,h="<li>画像拡張を含むトレーニング データ変換</li> <li>🤗 Transformers のコンピューター ビジョン モデルはチャネル優先のレイアウトを想定しているため、画像を転置するだけの検証データ変換</li>",d,k,B,I,R=`次に、モデルの画像と注釈のバッチを準備する 2 つの前処理関数を作成します。これらの機能が適用されます
画像変換を行い、以前にロードされた <code>image_processor</code> を使用して画像を <code>pixel_values</code> に変換し、
<code>labels</code>への注釈。 <code>ImageProcessor</code> は、画像のサイズ変更と正規化も処理します。`,C,Y,v,b,V=`データセット全体に前処理変換を適用するには、🤗 Datasets <code>set_transform</code> 関数を使用します。
変換はオンザフライで適用されるため、高速で消費するディスク容量が少なくなります。`,m,T,F;return k=new X({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEElMEElMEFkZWYlMjBhdWdfdHJhbnNmb3JtcyhpbWFnZSklM0ElMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHRmLmtlcmFzLnV0aWxzLmltZ190b19hcnJheShpbWFnZSklMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHRmLmltYWdlLnJhbmRvbV9icmlnaHRuZXNzKGltYWdlJTJDJTIwMC4yNSklMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHRmLmltYWdlLnJhbmRvbV9jb250cmFzdChpbWFnZSUyQyUyMDAuNSUyQyUyMDIuMCklMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHRmLmltYWdlLnJhbmRvbV9zYXR1cmF0aW9uKGltYWdlJTJDJTIwMC43NSUyQyUyMDEuMjUpJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjB0Zi5pbWFnZS5yYW5kb21faHVlKGltYWdlJTJDJTIwMC4xKSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwdGYudHJhbnNwb3NlKGltYWdlJTJDJTIwKDIlMkMlMjAwJTJDJTIwMSkpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW1hZ2UlMEElMEElMEFkZWYlMjB0cmFuc2Zvcm1zKGltYWdlKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwdGYua2VyYXMudXRpbHMuaW1nX3RvX2FycmF5KGltYWdlKSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwdGYudHJhbnNwb3NlKGltYWdlJTJDJTIwKDIlMkMlMjAwJTJDJTIwMSkpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW1hZ2U=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">aug_transforms</span>(<span class="hljs-params">image</span>):
<span class="hljs-meta">... </span>    image = tf.keras.utils.img_to_array(image)
<span class="hljs-meta">... </span>    image = tf.image.random_brightness(image, <span class="hljs-number">0.25</span>)
<span class="hljs-meta">... </span>    image = tf.image.random_contrast(image, <span class="hljs-number">0.5</span>, <span class="hljs-number">2.0</span>)
<span class="hljs-meta">... </span>    image = tf.image.random_saturation(image, <span class="hljs-number">0.75</span>, <span class="hljs-number">1.25</span>)
<span class="hljs-meta">... </span>    image = tf.image.random_hue(image, <span class="hljs-number">0.1</span>)
<span class="hljs-meta">... </span>    image = tf.transpose(image, (<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>))
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> image


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">transforms</span>(<span class="hljs-params">image</span>):
<span class="hljs-meta">... </span>    image = tf.keras.utils.img_to_array(image)
<span class="hljs-meta">... </span>    image = tf.transpose(image, (<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>))
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> image`,wrap:!1}}),Y=new X({props:{code:"ZGVmJTIwdHJhaW5fdHJhbnNmb3JtcyhleGFtcGxlX2JhdGNoKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlcyUyMCUzRCUyMCU1QmF1Z190cmFuc2Zvcm1zKHguY29udmVydCglMjJSR0IlMjIpKSUyMGZvciUyMHglMjBpbiUyMGV4YW1wbGVfYmF0Y2glNUIlMjJpbWFnZSUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMGxhYmVscyUyMCUzRCUyMCU1QnglMjBmb3IlMjB4JTIwaW4lMjBleGFtcGxlX2JhdGNoJTVCJTIyYW5ub3RhdGlvbiUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW5wdXRzJTBBJTBBJTBBZGVmJTIwdmFsX3RyYW5zZm9ybXMoZXhhbXBsZV9iYXRjaCklM0ElMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjAlNUJ0cmFuc2Zvcm1zKHguY29udmVydCglMjJSR0IlMjIpKSUyMGZvciUyMHglMjBpbiUyMGV4YW1wbGVfYmF0Y2glNUIlMjJpbWFnZSUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMGxhYmVscyUyMCUzRCUyMCU1QnglMjBmb3IlMjB4JTIwaW4lMjBleGFtcGxlX2JhdGNoJTVCJTIyYW5ub3RhdGlvbiUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW5wdXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">train_transforms</span>(<span class="hljs-params">example_batch</span>):
<span class="hljs-meta">... </span>    images = [aug_transforms(x.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">... </span>    labels = [x <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;annotation&quot;</span>]]
<span class="hljs-meta">... </span>    inputs = image_processor(images, labels)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> inputs


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">val_transforms</span>(<span class="hljs-params">example_batch</span>):
<span class="hljs-meta">... </span>    images = [transforms(x.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">... </span>    labels = [x <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;annotation&quot;</span>]]
<span class="hljs-meta">... </span>    inputs = image_processor(images, labels)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> inputs`,wrap:!1}}),T=new X({props:{code:"dHJhaW5fZHMuc2V0X3RyYW5zZm9ybSh0cmFpbl90cmFuc2Zvcm1zKSUwQXRlc3RfZHMuc2V0X3RyYW5zZm9ybSh2YWxfdHJhbnNmb3Jtcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>train_ds.set_transform(train_transforms)
<span class="hljs-meta">&gt;&gt;&gt; </span>test_ds.set_transform(val_transforms)`,wrap:!1}}),{c(){a=U("p"),a.innerHTML=M,l=c(),r=U("ul"),r.innerHTML=h,d=c(),g(k.$$.fragment),B=c(),I=U("p"),I.innerHTML=R,C=c(),g(Y.$$.fragment),v=c(),b=U("p"),b.innerHTML=V,m=c(),g(T.$$.fragment)},l(j){a=$(j,"P",{"data-svelte-h":!0}),W(a)!=="svelte-1gdpu9e"&&(a.innerHTML=M),l=i(j),r=$(j,"UL",{"data-svelte-h":!0}),W(r)!=="svelte-1fzyemf"&&(r.innerHTML=h),d=i(j),y(k.$$.fragment,j),B=i(j),I=$(j,"P",{"data-svelte-h":!0}),W(I)!=="svelte-t1b9t8"&&(I.innerHTML=R),C=i(j),y(Y.$$.fragment,j),v=i(j),b=$(j,"P",{"data-svelte-h":!0}),W(b)!=="svelte-1tl8xez"&&(b.innerHTML=V),m=i(j),y(T.$$.fragment,j)},m(j,G){t(j,a,G),t(j,l,G),t(j,r,G),t(j,d,G),J(k,j,G),t(j,B,G),t(j,I,G),t(j,C,G),J(Y,j,G),t(j,v,G),t(j,b,G),t(j,m,G),J(T,j,G),F=!0},p:ss,i(j){F||(f(k.$$.fragment,j),f(Y.$$.fragment,j),f(T.$$.fragment,j),F=!0)},o(j){w(k.$$.fragment,j),w(Y.$$.fragment,j),w(T.$$.fragment,j),F=!1},d(j){j&&(e(a),e(l),e(r),e(d),e(B),e(I),e(C),e(v),e(b),e(m)),u(k,j),u(Y,j),u(T,j)}}}function sa(Z){let a,M;return a=new Ms({props:{$$slots:{default:[Ol]},$$scope:{ctx:Z}}}),{c(){g(a.$$.fragment)},l(l){y(a.$$.fragment,l)},m(l,r){J(a,l,r),M=!0},p(l,r){const h={};r&2&&(h.$$scope={dirty:r,ctx:l}),a.$set(h)},i(l){M||(f(a.$$.fragment,l),M=!0)},o(l){w(a.$$.fragment,l),M=!1},d(l){u(a,l)}}}function la(Z){let a,M;return a=new X({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdG9yY2glMjBpbXBvcnQlMjBubiUwQSUwQWRlZiUyMGNvbXB1dGVfbWV0cmljcyhldmFsX3ByZWQpJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvZ2l0cyUyQyUyMGxhYmVscyUyMCUzRCUyMGV2YWxfcHJlZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvZ2l0c190ZW5zb3IlMjAlM0QlMjB0b3JjaC5mcm9tX251bXB5KGxvZ2l0cyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb2dpdHNfdGVuc29yJTIwJTNEJTIwbm4uZnVuY3Rpb25hbC5pbnRlcnBvbGF0ZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb2dpdHNfdGVuc29yJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2l6ZSUzRGxhYmVscy5zaGFwZSU1Qi0yJTNBJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZSUzRCUyMmJpbGluZWFyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWxpZ25fY29ybmVycyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKS5hcmdtYXgoZGltJTNEMSklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVkX2xhYmVscyUyMCUzRCUyMGxvZ2l0c190ZW5zb3IuZGV0YWNoKCkuY3B1KCkubnVtcHkoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1ldHJpY3MlMjAlM0QlMjBtZXRyaWMuY29tcHV0ZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUzRHByZWRfbGFiZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVmZXJlbmNlcyUzRGxhYmVscyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWdub3JlX2luZGV4JTNEMjU1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVkdWNlX2xhYmVscyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGtleSUyQyUyMHZhbHVlJTIwaW4lMjBtZXRyaWNzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHR5cGUodmFsdWUpJTIwaXMlMjBucC5uZGFycmF5JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWV0cmljcyU1QmtleSU1RCUyMCUzRCUyMHZhbHVlLnRvbGlzdCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbWV0cmljcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        logits, labels = eval_pred
<span class="hljs-meta">... </span>        logits_tensor = torch.from_numpy(logits)
<span class="hljs-meta">... </span>        logits_tensor = nn.functional.interpolate(
<span class="hljs-meta">... </span>            logits_tensor,
<span class="hljs-meta">... </span>            size=labels.shape[-<span class="hljs-number">2</span>:],
<span class="hljs-meta">... </span>            mode=<span class="hljs-string">&quot;bilinear&quot;</span>,
<span class="hljs-meta">... </span>            align_corners=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>        ).argmax(dim=<span class="hljs-number">1</span>)

<span class="hljs-meta">... </span>        pred_labels = logits_tensor.detach().cpu().numpy()
<span class="hljs-meta">... </span>        metrics = metric.compute(
<span class="hljs-meta">... </span>            predictions=pred_labels,
<span class="hljs-meta">... </span>            references=labels,
<span class="hljs-meta">... </span>            num_labels=num_labels,
<span class="hljs-meta">... </span>            ignore_index=<span class="hljs-number">255</span>,
<span class="hljs-meta">... </span>            reduce_labels=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>        )
<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> key, value <span class="hljs-keyword">in</span> metrics.items():
<span class="hljs-meta">... </span>            <span class="hljs-keyword">if</span> <span class="hljs-built_in">type</span>(value) <span class="hljs-keyword">is</span> np.ndarray:
<span class="hljs-meta">... </span>                metrics[key] = value.tolist()
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> metrics`,wrap:!1}}),{c(){g(a.$$.fragment)},l(l){y(a.$$.fragment,l)},m(l,r){J(a,l,r),M=!0},p:ss,i(l){M||(f(a.$$.fragment,l),M=!0)},o(l){w(a.$$.fragment,l),M=!1},d(l){u(a,l)}}}function aa(Z){let a,M;return a=new Ms({props:{$$slots:{default:[la]},$$scope:{ctx:Z}}}),{c(){g(a.$$.fragment)},l(l){y(a.$$.fragment,l)},m(l,r){J(a,l,r),M=!0},p(l,r){const h={};r&2&&(h.$$scope={dirty:r,ctx:l}),a.$set(h)},i(l){M||(f(a.$$.fragment,l),M=!0)},o(l){w(a.$$.fragment,l),M=!1},d(l){u(a,l)}}}function ea(Z){let a,M;return a=new X({props:{code:"ZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMkMlMjBsYWJlbHMlMjAlM0QlMjBldmFsX3ByZWQlMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjB0Zi50cmFuc3Bvc2UobG9naXRzJTJDJTIwcGVybSUzRCU1QjAlMkMlMjAyJTJDJTIwMyUyQyUyMDElNUQpJTBBJTIwJTIwJTIwJTIwbG9naXRzX3Jlc2l6ZWQlMjAlM0QlMjB0Zi5pbWFnZS5yZXNpemUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2l6ZSUzRHRmLnNoYXBlKGxhYmVscyklNUIxJTNBJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWV0aG9kJTNEJTIyYmlsaW5lYXIlMjIlMkMlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwcHJlZF9sYWJlbHMlMjAlM0QlMjB0Zi5hcmdtYXgobG9naXRzX3Jlc2l6ZWQlMkMlMjBheGlzJTNELTEpJTBBJTIwJTIwJTIwJTIwbWV0cmljcyUyMCUzRCUyMG1ldHJpYy5jb21wdXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTNEcHJlZF9sYWJlbHMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZWZlcmVuY2VzJTNEbGFiZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2xhYmVscyUzRG51bV9sYWJlbHMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZ25vcmVfaW5kZXglM0QtMSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlZHVjZV9sYWJlbHMlM0RpbWFnZV9wcm9jZXNzb3IuZG9fcmVkdWNlX2xhYmVscyUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjBwZXJfY2F0ZWdvcnlfYWNjdXJhY3klMjAlM0QlMjBtZXRyaWNzLnBvcCglMjJwZXJfY2F0ZWdvcnlfYWNjdXJhY3klMjIpLnRvbGlzdCgpJTBBJTIwJTIwJTIwJTIwcGVyX2NhdGVnb3J5X2lvdSUyMCUzRCUyMG1ldHJpY3MucG9wKCUyMnBlcl9jYXRlZ29yeV9pb3UlMjIpLnRvbGlzdCgpJTBBJTBBJTIwJTIwJTIwJTIwbWV0cmljcy51cGRhdGUoJTdCZiUyMmFjY3VyYWN5XyU3QmlkMmxhYmVsJTVCaSU1RCU3RCUyMiUzQSUyMHYlMjBmb3IlMjBpJTJDJTIwdiUyMGluJTIwZW51bWVyYXRlKHBlcl9jYXRlZ29yeV9hY2N1cmFjeSklN0QpJTBBJTIwJTIwJTIwJTIwbWV0cmljcy51cGRhdGUoJTdCZiUyMmlvdV8lN0JpZDJsYWJlbCU1QmklNUQlN0QlMjIlM0ElMjB2JTIwZm9yJTIwaSUyQyUyMHYlMjBpbiUyMGVudW1lcmF0ZShwZXJfY2F0ZWdvcnlfaW91KSU3RCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJ2YWxfJTIyJTIwJTJCJTIwayUzQSUyMHYlMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwbWV0cmljcy5pdGVtcygpJTdE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
<span class="hljs-meta">... </span>    logits, labels = eval_pred
<span class="hljs-meta">... </span>    logits = tf.transpose(logits, perm=[<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>])
<span class="hljs-meta">... </span>    logits_resized = tf.image.resize(
<span class="hljs-meta">... </span>        logits,
<span class="hljs-meta">... </span>        size=tf.shape(labels)[<span class="hljs-number">1</span>:],
<span class="hljs-meta">... </span>        method=<span class="hljs-string">&quot;bilinear&quot;</span>,
<span class="hljs-meta">... </span>    )

<span class="hljs-meta">... </span>    pred_labels = tf.argmax(logits_resized, axis=-<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    metrics = metric.compute(
<span class="hljs-meta">... </span>        predictions=pred_labels,
<span class="hljs-meta">... </span>        references=labels,
<span class="hljs-meta">... </span>        num_labels=num_labels,
<span class="hljs-meta">... </span>        ignore_index=-<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>        reduce_labels=image_processor.do_reduce_labels,
<span class="hljs-meta">... </span>    )

<span class="hljs-meta">... </span>    per_category_accuracy = metrics.pop(<span class="hljs-string">&quot;per_category_accuracy&quot;</span>).tolist()
<span class="hljs-meta">... </span>    per_category_iou = metrics.pop(<span class="hljs-string">&quot;per_category_iou&quot;</span>).tolist()

<span class="hljs-meta">... </span>    metrics.update({<span class="hljs-string">f&quot;accuracy_<span class="hljs-subst">{id2label[i]}</span>&quot;</span>: v <span class="hljs-keyword">for</span> i, v <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(per_category_accuracy)})
<span class="hljs-meta">... </span>    metrics.update({<span class="hljs-string">f&quot;iou_<span class="hljs-subst">{id2label[i]}</span>&quot;</span>: v <span class="hljs-keyword">for</span> i, v <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(per_category_iou)})
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;val_&quot;</span> + k: v <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> metrics.items()}`,wrap:!1}}),{c(){g(a.$$.fragment)},l(l){y(a.$$.fragment,l)},m(l,r){J(a,l,r),M=!0},p:ss,i(l){M||(f(a.$$.fragment,l),M=!0)},o(l){w(a.$$.fragment,l),M=!1},d(l){u(a,l)}}}function ta(Z){let a,M;return a=new Ms({props:{$$slots:{default:[ea]},$$scope:{ctx:Z}}}),{c(){g(a.$$.fragment)},l(l){y(a.$$.fragment,l)},m(l,r){J(a,l,r),M=!0},p(l,r){const h={};r&2&&(h.$$scope={dirty:r,ctx:l}),a.$set(h)},i(l){M||(f(a.$$.fragment,l),M=!0)},o(l){w(a.$$.fragment,l),M=!1},d(l){u(a,l)}}}function na(Z){let a,M='<a href="/docs/transformers/v4.40.0/ja/main_classes/trainer#transformers.Trainer">Trainer</a> を使用したモデルの微調整に慣れていない場合は、<a href="../training#finetune-with-trainer">ここ</a> の基本的なチュートリアルをご覧ください。';return{c(){a=U("p"),a.innerHTML=M},l(l){a=$(l,"P",{"data-svelte-h":!0}),W(a)!=="svelte-cmnyl7"&&(a.innerHTML=M)},m(l,r){t(l,a,r)},p:ss,d(l){l&&e(a)}}}function pa(Z){let a,M,l,r='これでモデルのトレーニングを開始する準備が整いました。 <a href="/docs/transformers/v4.40.0/ja/model_doc/auto#transformers.AutoModelForSemanticSegmentation">AutoModelForSemanticSegmentation</a> を使用して SegFormer をロードし、ラベル ID とラベル クラス間のマッピングをモデルに渡します。',h,d,k,B,I="この時点で残っている手順は次の 3 つだけです。",R,C,Y='<li><a href="/docs/transformers/v4.40.0/ja/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> でトレーニング ハイパーパラメータを定義します。 <code>image</code> 列が削除されるため、未使用の列を削除しないことが重要です。 <code>image</code> 列がないと、<code>pixel_values</code> を作成できません。この動作を防ぐには、<code>remove_unused_columns=False</code>を設定してください。他に必要なパラメータは、モデルの保存場所を指定する <code>output_dir</code> だけです。 <code>push_to_hub=True</code>を設定して、このモデルをハブにプッシュします (モデルをアップロードするには、Hugging Face にサインインする必要があります)。各エポックの終了時に、<a href="/docs/transformers/v4.40.0/ja/main_classes/trainer#transformers.Trainer">Trainer</a> は IoU メトリックを評価し、トレーニング チェックポイントを保存します。</li> <li>トレーニング引数を、モデル、データセット、トークナイザー、データ照合器、および <code>compute_metrics</code> 関数とともに <a href="/docs/transformers/v4.40.0/ja/main_classes/trainer#transformers.Trainer">Trainer</a> に渡します。</li> <li><a href="/docs/transformers/v4.40.0/ja/main_classes/trainer#transformers.Trainer.train">train()</a> を呼び出してモデルを微調整します。</li>',v,b,V,m,T='トレーニングが完了したら、 <a href="/docs/transformers/v4.40.0/ja/main_classes/trainer#transformers.Trainer.push_to_hub">push_to_hub()</a> メソッドを使用してモデルをハブに共有し、誰もがモデルを使用できるようにします。',F,j,G;return a=new fl({props:{$$slots:{default:[na]},$$scope:{ctx:Z}}}),d=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlbWFudGljU2VnbWVudGF0aW9uJTJDJTIwVHJhaW5pbmdBcmd1bWVudHMlMkMlMjBUcmFpbmVyJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCUyQyUyMGlkMmxhYmVsJTNEaWQybGFiZWwlMkMlMjBsYWJlbDJpZCUzRGxhYmVsMmlkKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSemanticSegmentation, TrainingArguments, Trainer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSemanticSegmentation.from_pretrained(checkpoint, id2label=id2label, label2id=label2id)`,wrap:!1}}),b=new X({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjJzZWdmb3JtZXItYjAtc2NlbmUtcGFyc2UtMTUwJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDZlLTUlMkMlMEElMjAlMjAlMjAlMjBudW1fdHJhaW5fZXBvY2hzJTNENTAlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0QyJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV9ldmFsX2JhdGNoX3NpemUlM0QyJTJDJTBBJTIwJTIwJTIwJTIwc2F2ZV90b3RhbF9saW1pdCUzRDMlMkMlMEElMjAlMjAlMjAlMjBldmFsdWF0aW9uX3N0cmF0ZWd5JTNEJTIyc3RlcHMlMjIlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0cmF0ZWd5JTNEJTIyc3RlcHMlMjIlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0ZXBzJTNEMjAlMkMlMEElMjAlMjAlMjAlMjBldmFsX3N0ZXBzJTNEMjAlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMSUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfYWNjdW11bGF0aW9uX3N0ZXBzJTNENSUyQyUwQSUyMCUyMCUyMCUyMHJlbW92ZV91bnVzZWRfY29sdW1ucyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kcyUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRHRlc3RfZHMlMkMlMEElMjAlMjAlMjAlMjBjb21wdXRlX21ldHJpY3MlM0Rjb21wdXRlX21ldHJpY3MlMkMlMEEpJTBBJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(
<span class="hljs-meta">... </span>    output_dir=<span class="hljs-string">&quot;segformer-b0-scene-parse-150&quot;</span>,
<span class="hljs-meta">... </span>    learning_rate=<span class="hljs-number">6e-5</span>,
<span class="hljs-meta">... </span>    num_train_epochs=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    per_device_train_batch_size=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    per_device_eval_batch_size=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    save_total_limit=<span class="hljs-number">3</span>,
<span class="hljs-meta">... </span>    evaluation_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
<span class="hljs-meta">... </span>    save_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
<span class="hljs-meta">... </span>    save_steps=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    eval_steps=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    logging_steps=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    eval_accumulation_steps=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>    remove_unused_columns=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    push_to_hub=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    train_dataset=train_ds,
<span class="hljs-meta">... </span>    eval_dataset=test_ds,
<span class="hljs-meta">... </span>    compute_metrics=compute_metrics,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()`,wrap:!1}}),j=new X({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.push_to_hub()',wrap:!1}}),{c(){g(a.$$.fragment),M=c(),l=U("p"),l.innerHTML=r,h=c(),g(d.$$.fragment),k=c(),B=U("p"),B.textContent=I,R=c(),C=U("ol"),C.innerHTML=Y,v=c(),g(b.$$.fragment),V=c(),m=U("p"),m.innerHTML=T,F=c(),g(j.$$.fragment)},l(p){y(a.$$.fragment,p),M=i(p),l=$(p,"P",{"data-svelte-h":!0}),W(l)!=="svelte-18qi21"&&(l.innerHTML=r),h=i(p),y(d.$$.fragment,p),k=i(p),B=$(p,"P",{"data-svelte-h":!0}),W(B)!=="svelte-1j8bgyv"&&(B.textContent=I),R=i(p),C=$(p,"OL",{"data-svelte-h":!0}),W(C)!=="svelte-3ksm2j"&&(C.innerHTML=Y),v=i(p),y(b.$$.fragment,p),V=i(p),m=$(p,"P",{"data-svelte-h":!0}),W(m)!=="svelte-1dgjmok"&&(m.innerHTML=T),F=i(p),y(j.$$.fragment,p)},m(p,_){J(a,p,_),t(p,M,_),t(p,l,_),t(p,h,_),J(d,p,_),t(p,k,_),t(p,B,_),t(p,R,_),t(p,C,_),t(p,v,_),J(b,p,_),t(p,V,_),t(p,m,_),t(p,F,_),J(j,p,_),G=!0},p(p,_){const E={};_&2&&(E.$$scope={dirty:_,ctx:p}),a.$set(E)},i(p){G||(f(a.$$.fragment,p),f(d.$$.fragment,p),f(b.$$.fragment,p),f(j.$$.fragment,p),G=!0)},o(p){w(a.$$.fragment,p),w(d.$$.fragment,p),w(b.$$.fragment,p),w(j.$$.fragment,p),G=!1},d(p){p&&(e(M),e(l),e(h),e(k),e(B),e(R),e(C),e(v),e(V),e(m),e(F)),u(a,p),u(d,p),u(b,p),u(j,p)}}}function ma(Z){let a,M;return a=new Ms({props:{$$slots:{default:[pa]},$$scope:{ctx:Z}}}),{c(){g(a.$$.fragment)},l(l){y(a.$$.fragment,l)},m(l,r){J(a,l,r),M=!0},p(l,r){const h={};r&2&&(h.$$scope={dirty:r,ctx:l}),a.$set(h)},i(l){M||(f(a.$$.fragment,l),M=!0)},o(l){w(a.$$.fragment,l),M=!1},d(l){u(a,l)}}}function ra(Z){let a,M='Keras を使用したモデルの微調整に慣れていない場合は、まず <a href="./training#train-a-tensorflow-model-with-keras">基本チュートリアル</a> を確認してください。';return{c(){a=U("p"),a.innerHTML=M},l(l){a=$(l,"P",{"data-svelte-h":!0}),W(a)!=="svelte-m0v6mc"&&(a.innerHTML=M)},m(l,r){t(l,a,r)},p:ss,d(l){l&&e(a)}}}function ca(Z){let a,M,l,r="TensorFlow でモデルを微調整するには、次の手順に従います。",h,d,k="<li>トレーニングのハイパーパラメータを定義し、オプティマイザーと学習率スケジュールを設定します。</li> <li>事前トレーニングされたモデルをインスタンス化します。</li> <li>🤗 データセットを <code>tf.data.Dataset</code> に変換します。</li> <li>モデルをコンパイルします。</li> <li>コールバックを追加してメトリクスを計算し、モデルを 🤗 Hub にアップロードします</li> <li><code>fit()</code> メソッドを使用してトレーニングを実行します。</li>",B,I,R="まず、ハイパーパラメーター、オプティマイザー、学習率スケジュールを定義します。",C,Y,v,b,V=`次に、ラベル マッピングとともに <a href="/docs/transformers/v4.40.0/ja/model_doc/auto#transformers.TFAutoModelForSemanticSegmentation">TFAutoModelForSemanticSegmentation</a> を使用して SegFormer をロードし、それをコンパイルします。
オプティマイザ。 Transformers モデルにはすべてデフォルトのタスク関連の損失関数があるため、次の場合を除き、損失関数を指定する必要はないことに注意してください。`,m,T,F,j,G="<code>to_tf_dataset</code> と <code>DefaultDataCollat​​or</code> を使用して、データセットを <code>tf.data.Dataset</code> 形式に変換します。",p,_,E,A,S=`予測から精度を計算し、モデルを 🤗 ハブにプッシュするには、<a href="../main_classes/keras_callbacks">Keras callbacks</a> を使用します。
<code>compute_metrics</code> 関数を <a href="/docs/transformers/v4.40.0/ja/main_classes/keras_callbacks#transformers.KerasMetricCallback">KerasMetricCallback</a> に渡します。
そして <a href="/docs/transformers/v4.40.0/ja/main_classes/keras_callbacks#transformers.PushToHubCallback">PushToHubCallback</a> を使用してモデルをアップロードします。`,D,N,js,z,L=`ついに、モデルをトレーニングする準備が整いました。トレーニングおよび検証データセット、エポック数、
モデルを微調整するためのコールバック:`,K,Q,P,H,Xs="おめでとう！モデルを微調整し、🤗 Hub で共有しました。これで推論に使用できるようになりました。",O;return a=new fl({props:{$$slots:{default:[ra]},$$scope:{ctx:Z}}}),Y=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGNyZWF0ZV9vcHRpbWl6ZXIlMEElMEFiYXRjaF9zaXplJTIwJTNEJTIwMiUwQW51bV9lcG9jaHMlMjAlM0QlMjA1MCUwQW51bV90cmFpbl9zdGVwcyUyMCUzRCUyMGxlbih0cmFpbl9kcyklMjAqJTIwbnVtX2Vwb2NocyUwQWxlYXJuaW5nX3JhdGUlMjAlM0QlMjA2ZS01JTBBd2VpZ2h0X2RlY2F5X3JhdGUlMjAlM0QlMjAwLjAxJTBBJTBBb3B0aW1pemVyJTJDJTIwbHJfc2NoZWR1bGUlMjAlM0QlMjBjcmVhdGVfb3B0aW1pemVyKCUwQSUyMCUyMCUyMCUyMGluaXRfbHIlM0RsZWFybmluZ19yYXRlJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluX3N0ZXBzJTNEbnVtX3RyYWluX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwd2VpZ2h0X2RlY2F5X3JhdGUlM0R3ZWlnaHRfZGVjYXlfcmF0ZSUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> create_optimizer

<span class="hljs-meta">&gt;&gt;&gt; </span>batch_size = <span class="hljs-number">2</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_epochs = <span class="hljs-number">50</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_train_steps = <span class="hljs-built_in">len</span>(train_ds) * num_epochs
<span class="hljs-meta">&gt;&gt;&gt; </span>learning_rate = <span class="hljs-number">6e-5</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>weight_decay_rate = <span class="hljs-number">0.01</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer, lr_schedule = create_optimizer(
<span class="hljs-meta">... </span>    init_lr=learning_rate,
<span class="hljs-meta">... </span>    num_train_steps=num_train_steps,
<span class="hljs-meta">... </span>    weight_decay_rate=weight_decay_rate,
<span class="hljs-meta">... </span>    num_warmup_steps=<span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),T=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRGQXV0b01vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMGNoZWNrcG9pbnQlMkMlMEElMjAlMjAlMjAlMjBpZDJsYWJlbCUzRGlkMmxhYmVsJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCUyQyUwQSklMEFtb2RlbC5jb21waWxlKG9wdGltaXplciUzRG9wdGltaXplciklMjAlMjAlMjMlMjBObyUyMGxvc3MlMjBhcmd1bWVudCE=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TFAutoModelForSemanticSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSemanticSegmentation.from_pretrained(
<span class="hljs-meta">... </span>    checkpoint,
<span class="hljs-meta">... </span>    id2label=id2label,
<span class="hljs-meta">... </span>    label2id=label2id,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">compile</span>(optimizer=optimizer)  <span class="hljs-comment"># No loss argument!</span>`,wrap:!1}}),_=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlZmF1bHREYXRhQ29sbGF0b3IlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGVmYXVsdERhdGFDb2xsYXRvcihyZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKSUwQSUwQXRmX3RyYWluX2RhdGFzZXQlMjAlM0QlMjB0cmFpbl9kcy50b190Zl9kYXRhc2V0KCUwQSUyMCUyMCUyMCUyMGNvbHVtbnMlM0QlNUIlMjJwaXhlbF92YWx1ZXMlMjIlMkMlMjAlMjJsYWJlbCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHNodWZmbGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUlMkMlMEElMjAlMjAlMjAlMjBjb2xsYXRlX2ZuJTNEZGF0YV9jb2xsYXRvciUyQyUwQSklMEElMEF0Zl9ldmFsX2RhdGFzZXQlMjAlM0QlMjB0ZXN0X2RzLnRvX3RmX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwY29sdW1ucyUzRCU1QiUyMnBpeGVsX3ZhbHVlcyUyMiUyQyUyMCUyMmxhYmVsJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwc2h1ZmZsZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMGNvbGxhdGVfZm4lM0RkYXRhX2NvbGxhdG9yJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DefaultDataCollator

<span class="hljs-meta">&gt;&gt;&gt; </span>data_collator = DefaultDataCollator(return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tf_train_dataset = train_ds.to_tf_dataset(
<span class="hljs-meta">... </span>    columns=[<span class="hljs-string">&quot;pixel_values&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>],
<span class="hljs-meta">... </span>    shuffle=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    batch_size=batch_size,
<span class="hljs-meta">... </span>    collate_fn=data_collator,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tf_eval_dataset = test_ds.to_tf_dataset(
<span class="hljs-meta">... </span>    columns=[<span class="hljs-string">&quot;pixel_values&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>],
<span class="hljs-meta">... </span>    shuffle=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    batch_size=batch_size,
<span class="hljs-meta">... </span>    collate_fn=data_collator,
<span class="hljs-meta">... </span>)`,wrap:!1}}),N=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5rZXJhc19jYWxsYmFja3MlMjBpbXBvcnQlMjBLZXJhc01ldHJpY0NhbGxiYWNrJTJDJTIwUHVzaFRvSHViQ2FsbGJhY2slMEElMEFtZXRyaWNfY2FsbGJhY2slMjAlM0QlMjBLZXJhc01ldHJpY0NhbGxiYWNrKCUwQSUyMCUyMCUyMCUyMG1ldHJpY19mbiUzRGNvbXB1dGVfbWV0cmljcyUyQyUyMGV2YWxfZGF0YXNldCUzRHRmX2V2YWxfZGF0YXNldCUyQyUyMGJhdGNoX3NpemUlM0RiYXRjaF9zaXplJTJDJTIwbGFiZWxfY29scyUzRCU1QiUyMmxhYmVscyUyMiU1RCUwQSklMEElMEFwdXNoX3RvX2h1Yl9jYWxsYmFjayUyMCUzRCUyMFB1c2hUb0h1YkNhbGxiYWNrKG91dHB1dF9kaXIlM0QlMjJzY2VuZV9zZWdtZW50YXRpb24lMjIlMkMlMjB0b2tlbml6ZXIlM0RpbWFnZV9wcm9jZXNzb3IpJTBBJTBBY2FsbGJhY2tzJTIwJTNEJTIwJTVCbWV0cmljX2NhbGxiYWNrJTJDJTIwcHVzaF90b19odWJfY2FsbGJhY2slNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.keras_callbacks <span class="hljs-keyword">import</span> KerasMetricCallback, PushToHubCallback

<span class="hljs-meta">&gt;&gt;&gt; </span>metric_callback = KerasMetricCallback(
<span class="hljs-meta">... </span>    metric_fn=compute_metrics, eval_dataset=tf_eval_dataset, batch_size=batch_size, label_cols=[<span class="hljs-string">&quot;labels&quot;</span>]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>push_to_hub_callback = PushToHubCallback(output_dir=<span class="hljs-string">&quot;scene_segmentation&quot;</span>, tokenizer=image_processor)

<span class="hljs-meta">&gt;&gt;&gt; </span>callbacks = [metric_callback, push_to_hub_callback]`,wrap:!1}}),Q=new X({props:{code:"bW9kZWwuZml0KCUwQSUyMCUyMCUyMCUyMHRmX3RyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjB2YWxpZGF0aW9uX2RhdGElM0R0Zl9ldmFsX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBjYWxsYmFja3MlM0RjYWxsYmFja3MlMkMlMEElMjAlMjAlMjAlMjBlcG9jaHMlM0RudW1fZXBvY2hzJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model.fit(
<span class="hljs-meta">... </span>    tf_train_dataset,
<span class="hljs-meta">... </span>    validation_data=tf_eval_dataset,
<span class="hljs-meta">... </span>    callbacks=callbacks,
<span class="hljs-meta">... </span>    epochs=num_epochs,
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){g(a.$$.fragment),M=c(),l=U("p"),l.textContent=r,h=c(),d=U("ol"),d.innerHTML=k,B=c(),I=U("p"),I.textContent=R,C=c(),g(Y.$$.fragment),v=c(),b=U("p"),b.innerHTML=V,m=c(),g(T.$$.fragment),F=c(),j=U("p"),j.innerHTML=G,p=c(),g(_.$$.fragment),E=c(),A=U("p"),A.innerHTML=S,D=c(),g(N.$$.fragment),js=c(),z=U("p"),z.textContent=L,K=c(),g(Q.$$.fragment),P=c(),H=U("p"),H.textContent=Xs},l(o){y(a.$$.fragment,o),M=i(o),l=$(o,"P",{"data-svelte-h":!0}),W(l)!=="svelte-a44fb"&&(l.textContent=r),h=i(o),d=$(o,"OL",{"data-svelte-h":!0}),W(d)!=="svelte-23fvp6"&&(d.innerHTML=k),B=i(o),I=$(o,"P",{"data-svelte-h":!0}),W(I)!=="svelte-1u4w84l"&&(I.textContent=R),C=i(o),y(Y.$$.fragment,o),v=i(o),b=$(o,"P",{"data-svelte-h":!0}),W(b)!=="svelte-nns0dk"&&(b.innerHTML=V),m=i(o),y(T.$$.fragment,o),F=i(o),j=$(o,"P",{"data-svelte-h":!0}),W(j)!=="svelte-ye4n86"&&(j.innerHTML=G),p=i(o),y(_.$$.fragment,o),E=i(o),A=$(o,"P",{"data-svelte-h":!0}),W(A)!=="svelte-5pa1q0"&&(A.innerHTML=S),D=i(o),y(N.$$.fragment,o),js=i(o),z=$(o,"P",{"data-svelte-h":!0}),W(z)!=="svelte-bif4s6"&&(z.textContent=L),K=i(o),y(Q.$$.fragment,o),P=i(o),H=$(o,"P",{"data-svelte-h":!0}),W(H)!=="svelte-f4xo0m"&&(H.textContent=Xs)},m(o,x){J(a,o,x),t(o,M,x),t(o,l,x),t(o,h,x),t(o,d,x),t(o,B,x),t(o,I,x),t(o,C,x),J(Y,o,x),t(o,v,x),t(o,b,x),t(o,m,x),J(T,o,x),t(o,F,x),t(o,j,x),t(o,p,x),J(_,o,x),t(o,E,x),t(o,A,x),t(o,D,x),J(N,o,x),t(o,js,x),t(o,z,x),t(o,K,x),J(Q,o,x),t(o,P,x),t(o,H,x),O=!0},p(o,x){const q={};x&2&&(q.$$scope={dirty:x,ctx:o}),a.$set(q)},i(o){O||(f(a.$$.fragment,o),f(Y.$$.fragment,o),f(T.$$.fragment,o),f(_.$$.fragment,o),f(N.$$.fragment,o),f(Q.$$.fragment,o),O=!0)},o(o){w(a.$$.fragment,o),w(Y.$$.fragment,o),w(T.$$.fragment,o),w(_.$$.fragment,o),w(N.$$.fragment,o),w(Q.$$.fragment,o),O=!1},d(o){o&&(e(M),e(l),e(h),e(d),e(B),e(I),e(C),e(v),e(b),e(m),e(F),e(j),e(p),e(E),e(A),e(D),e(js),e(z),e(K),e(P),e(H)),u(a,o),u(Y,o),u(T,o),u(_,o),u(N,o),u(Q,o)}}}function ia(Z){let a,M;return a=new Ms({props:{$$slots:{default:[ca]},$$scope:{ctx:Z}}}),{c(){g(a.$$.fragment)},l(l){y(a.$$.fragment,l)},m(l,r){J(a,l,r),M=!0},p(l,r){const h={};r&2&&(h.$$scope={dirty:r,ctx:l}),a.$set(h)},i(l){M||(f(a.$$.fragment,l),M=!0)},o(l){w(a.$$.fragment,l),M=!1},d(l){u(a,l)}}}function oa(Z){let a,M='推論用に微調整されたモデルを試す最も簡単な方法は、それを <a href="/docs/transformers/v4.40.0/ja/main_classes/pipelines#transformers.pipeline">pipeline()</a> で使用することです。モデルを使用して画像セグメンテーション用の <code>pipeline</code>をインスタンス化し、それに画像を渡します。',l,r,h,d,k="必要に応じて、<code>pipeline</code>の結果を手動で複製することもできます。画像を画像プロセッサで処理し、<code>pixel_values</code> を GPU に配置します。",B,I,R,C,Y="入力をモデルに渡し、<code>logits</code>を返します。",v,b,V,m,T="次に、ロジットを元の画像サイズに再スケールします。",F,j,G;return r=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBc2VnbWVudGVyJTIwJTNEJTIwcGlwZWxpbmUoJTIyaW1hZ2Utc2VnbWVudGF0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJteV9hd2Vzb21lX3NlZ19tb2RlbCUyMiklMEFzZWdtZW50ZXIoaW1hZ2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>segmenter = pipeline(<span class="hljs-string">&quot;image-segmentation&quot;</span>, model=<span class="hljs-string">&quot;my_awesome_seg_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>segmenter(image)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-literal">None</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;wall&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=640x427 at <span class="hljs-number">0x7FD5B2062690</span>&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-literal">None</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;sky&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=640x427 at <span class="hljs-number">0x7FD5B2062A50</span>&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-literal">None</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;floor&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=640x427 at <span class="hljs-number">0x7FD5B2062B50</span>&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-literal">None</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;ceiling&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=640x427 at <span class="hljs-number">0x7FD5B2062A10</span>&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-literal">None</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;bed &#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=640x427 at <span class="hljs-number">0x7FD5B2062E90</span>&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-literal">None</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;windowpane&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=640x427 at <span class="hljs-number">0x7FD5B2062390</span>&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-literal">None</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cabinet&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=640x427 at <span class="hljs-number">0x7FD5B2062550</span>&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-literal">None</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;chair&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=640x427 at <span class="hljs-number">0x7FD5B2062D90</span>&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-literal">None</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;armchair&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=640x427 at <span class="hljs-number">0x7FD5B2062E10</span>&gt;}]`,wrap:!1}}),I=new X({props:{code:"ZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElMjIlMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3B1JTIyKSUyMCUyMCUyMyUyMHVzZSUyMEdQVSUyMGlmJTIwYXZhaWxhYmxlJTJDJTIwb3RoZXJ3aXNlJTIwdXNlJTIwYSUyMENQVSUwQWVuY29kaW5nJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFwaXhlbF92YWx1ZXMlMjAlM0QlMjBlbmNvZGluZy5waXhlbF92YWx1ZXMudG8oZGV2aWNlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>)  <span class="hljs-comment"># use GPU if available, otherwise use a CPU</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = encoding.pixel_values.to(device)`,wrap:!1}}),b=new X({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKHBpeGVsX3ZhbHVlcyUzRHBpeGVsX3ZhbHVlcyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cy5jcHUoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(pixel_values=pixel_values)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits.cpu()`,wrap:!1}}),j=new X({props:{code:"dXBzYW1wbGVkX2xvZ2l0cyUyMCUzRCUyMG5uLmZ1bmN0aW9uYWwuaW50ZXJwb2xhdGUoJTBBJTIwJTIwJTIwJTIwbG9naXRzJTJDJTBBJTIwJTIwJTIwJTIwc2l6ZSUzRGltYWdlLnNpemUlNUIlM0ElM0EtMSU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGUlM0QlMjJiaWxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMGFsaWduX2Nvcm5lcnMlM0RGYWxzZSUyQyUwQSklMEElMEFwcmVkX3NlZyUyMCUzRCUyMHVwc2FtcGxlZF9sb2dpdHMuYXJnbWF4KGRpbSUzRDEpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>upsampled_logits = nn.functional.interpolate(
<span class="hljs-meta">... </span>    logits,
<span class="hljs-meta">... </span>    size=image.size[::-<span class="hljs-number">1</span>],
<span class="hljs-meta">... </span>    mode=<span class="hljs-string">&quot;bilinear&quot;</span>,
<span class="hljs-meta">... </span>    align_corners=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pred_seg = upsampled_logits.argmax(dim=<span class="hljs-number">1</span>)[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){a=U("p"),a.innerHTML=M,l=c(),g(r.$$.fragment),h=c(),d=U("p"),d.innerHTML=k,B=c(),g(I.$$.fragment),R=c(),C=U("p"),C.innerHTML=Y,v=c(),g(b.$$.fragment),V=c(),m=U("p"),m.textContent=T,F=c(),g(j.$$.fragment)},l(p){a=$(p,"P",{"data-svelte-h":!0}),W(a)!=="svelte-m98vxr"&&(a.innerHTML=M),l=i(p),y(r.$$.fragment,p),h=i(p),d=$(p,"P",{"data-svelte-h":!0}),W(d)!=="svelte-fs04zi"&&(d.innerHTML=k),B=i(p),y(I.$$.fragment,p),R=i(p),C=$(p,"P",{"data-svelte-h":!0}),W(C)!=="svelte-1rvunpz"&&(C.innerHTML=Y),v=i(p),y(b.$$.fragment,p),V=i(p),m=$(p,"P",{"data-svelte-h":!0}),W(m)!=="svelte-oolpf2"&&(m.textContent=T),F=i(p),y(j.$$.fragment,p)},m(p,_){t(p,a,_),t(p,l,_),J(r,p,_),t(p,h,_),t(p,d,_),t(p,B,_),J(I,p,_),t(p,R,_),t(p,C,_),t(p,v,_),J(b,p,_),t(p,V,_),t(p,m,_),t(p,F,_),J(j,p,_),G=!0},p:ss,i(p){G||(f(r.$$.fragment,p),f(I.$$.fragment,p),f(b.$$.fragment,p),f(j.$$.fragment,p),G=!0)},o(p){w(r.$$.fragment,p),w(I.$$.fragment,p),w(b.$$.fragment,p),w(j.$$.fragment,p),G=!1},d(p){p&&(e(a),e(l),e(h),e(d),e(B),e(R),e(C),e(v),e(V),e(m),e(F)),u(r,p),u(I,p),u(b,p),u(j,p)}}}function Ma(Z){let a,M;return a=new Ms({props:{$$slots:{default:[oa]},$$scope:{ctx:Z}}}),{c(){g(a.$$.fragment)},l(l){y(a.$$.fragment,l)},m(l,r){J(a,l,r),M=!0},p(l,r){const h={};r&2&&(h.$$scope={dirty:r,ctx:l}),a.$set(h)},i(l){M||(f(a.$$.fragment,l),M=!0)},o(l){w(a.$$.fragment,l),M=!1},d(l){u(a,l)}}}function ja(Z){let a,M="画像プロセッサをロードして画像を前処理し、入力を TensorFlow テンソルとして返します。",l,r,h,d,k="入力をモデルに渡し、<code>logits</code>を返します。",B,I,R,C,Y="次に、ロジットを元の画像サイズに再スケールし、クラス次元に argmax を適用します。",v,b,V;return r=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyTWFyaWFLJTJGc2NlbmVfc2VnbWVudGF0aW9uJTIyKSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;MariaK/scene_segmentation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)`,wrap:!1}}),I=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRGQXV0b01vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMk1hcmlhSyUyRnNjZW5lX3NlZ21lbnRhdGlvbiUyMiklMEFsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TFAutoModelForSemanticSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;MariaK/scene_segmentation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs).logits`,wrap:!1}}),b=new X({props:{code:"bG9naXRzJTIwJTNEJTIwdGYudHJhbnNwb3NlKGxvZ2l0cyUyQyUyMCU1QjAlMkMlMjAyJTJDJTIwMyUyQyUyMDElNUQpJTBBJTBBdXBzYW1wbGVkX2xvZ2l0cyUyMCUzRCUyMHRmLmltYWdlLnJlc2l6ZSglMEElMjAlMjAlMjAlMjBsb2dpdHMlMkMlMEElMjAlMjAlMjAlMjAlMjMlMjBXZSUyMHJldmVyc2UlMjB0aGUlMjBzaGFwZSUyMG9mJTIwJTYwaW1hZ2UlNjAlMjBiZWNhdXNlJTIwJTYwaW1hZ2Uuc2l6ZSU2MCUyMHJldHVybnMlMjB3aWR0aCUyMGFuZCUyMGhlaWdodC4lMEElMjAlMjAlMjAlMjBpbWFnZS5zaXplJTVCJTNBJTNBLTElNUQlMkMlMEEpJTBBJTBBcHJlZF9zZWclMjAlM0QlMjB0Zi5tYXRoLmFyZ21heCh1cHNhbXBsZWRfbG9naXRzJTJDJTIwYXhpcyUzRC0xKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>logits = tf.transpose(logits, [<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>upsampled_logits = tf.image.resize(
<span class="hljs-meta">... </span>    logits,
<span class="hljs-meta">... </span>    <span class="hljs-comment"># We reverse the shape of \`image\` because \`image.size\` returns width and height.</span>
<span class="hljs-meta">... </span>    image.size[::-<span class="hljs-number">1</span>],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pred_seg = tf.math.argmax(upsampled_logits, axis=-<span class="hljs-number">1</span>)[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){a=U("p"),a.textContent=M,l=c(),g(r.$$.fragment),h=c(),d=U("p"),d.innerHTML=k,B=c(),g(I.$$.fragment),R=c(),C=U("p"),C.textContent=Y,v=c(),g(b.$$.fragment)},l(m){a=$(m,"P",{"data-svelte-h":!0}),W(a)!=="svelte-7m1b4a"&&(a.textContent=M),l=i(m),y(r.$$.fragment,m),h=i(m),d=$(m,"P",{"data-svelte-h":!0}),W(d)!=="svelte-1rvunpz"&&(d.innerHTML=k),B=i(m),y(I.$$.fragment,m),R=i(m),C=$(m,"P",{"data-svelte-h":!0}),W(C)!=="svelte-3qm4xh"&&(C.textContent=Y),v=i(m),y(b.$$.fragment,m)},m(m,T){t(m,a,T),t(m,l,T),J(r,m,T),t(m,h,T),t(m,d,T),t(m,B,T),J(I,m,T),t(m,R,T),t(m,C,T),t(m,v,T),J(b,m,T),V=!0},p:ss,i(m){V||(f(r.$$.fragment,m),f(I.$$.fragment,m),f(b.$$.fragment,m),V=!0)},o(m){w(r.$$.fragment,m),w(I.$$.fragment,m),w(b.$$.fragment,m),V=!1},d(m){m&&(e(a),e(l),e(h),e(d),e(B),e(R),e(C),e(v)),u(r,m),u(I,m),u(b,m)}}}function ha(Z){let a,M;return a=new Ms({props:{$$slots:{default:[ja]},$$scope:{ctx:Z}}}),{c(){g(a.$$.fragment)},l(l){y(a.$$.fragment,l)},m(l,r){J(a,l,r),M=!0},p(l,r){const h={};r&2&&(h.$$scope={dirty:r,ctx:l}),a.$set(h)},i(l){M||(f(a.$$.fragment,l),M=!0)},o(l){w(a.$$.fragment,l),M=!1},d(l){u(a,l)}}}function ga(Z){let a,M,l,r,h,d,k,B,I,R,C,Y="セマンティック セグメンテーションでは、画像の個々のピクセルにラベルまたはクラスを割り当てます。セグメンテーションにはいくつかのタイプがありますが、セマンティック セグメンテーションの場合、同じオブジェクトの一意のインスタンス間の区別は行われません。両方のオブジェクトに同じラベルが付けられます (たとえば、<code>car-1</code>と<code>car-2</code>の代わりに<code>car</code>)。セマンティック セグメンテーションの一般的な現実世界のアプリケーションには、歩行者や重要な交通情報を識別するための自動運転車のトレーニング、医療画像内の細胞と異常の識別、衛星画像からの環境変化の監視などが含まれます。",v,b,V="このガイドでは、次の方法を説明します。",m,T,F='<li><a href="https://huggingface.co/datasets/scene_parse_150" rel="nofollow">SceneParse150</a> データセットの <a href="https://huggingface.co/docs/transformers/main/en/model_doc/segformer#segformer" rel="nofollow">SegFormer</a> を微調整します。</li> <li>微調整したモデルを推論に使用します。</li>',j,G,p,_,E="始める前に、必要なライブラリがすべてインストールされていることを確認してください。",A,S,D,N,js="モデルをアップロードしてコミュニティと共有できるように、Hugging Face アカウントにログインすることをお勧めします。プロンプトが表示されたら、トークンを入力してログインします。",z,L,K,Q,P,H,Xs="まず、SceneParse150 データセットの小さいサブセットを 🤗 データセット ライブラリから読み込みます。これにより、完全なデータセットのトレーニングにさらに時間を費やす前に、実験してすべてが機能することを確認する機会が得られます。",O,o,x,q,wl="<code>train_test_split</code> メソッドを使用して、データセットの <code>train</code> 分割をトレイン セットとテスト セットに分割します。",Ys,hs,Vs,gs,ul="次に、例を見てみましょう。",Fs,ys,Ns,Js,dl="<li><code>image</code>: シーンの PIL イメージ。</li> <li><code>annotation</code>: セグメンテーション マップの PIL イメージ。モデルのターゲットでもあります。</li> <li><code>scene_category</code>: “kitchen”や”office”などの画像シーンを説明するカテゴリ ID。このガイドでは、<code>image</code>と<code>annotation</code>のみが必要になります。どちらも PIL イメージです。</li>",Qs,fs,bl="また、ラベル ID をラベル クラスにマップする辞書を作成することもできます。これは、後でモデルを設定するときに役立ちます。ハブからマッピングをダウンロードし、<code>id2label</code> および <code>label2id</code> ディクショナリを作成します。",Hs,ws,As,us,zs,ds,Tl="次のステップでは、SegFormer 画像プロセッサをロードして、モデルの画像と注釈を準備します。このデータセットのような一部のデータセットは、バックグラウンド クラスとしてゼロインデックスを使用します。ただし、実際には背景クラスは 150 個のクラスに含まれていないため、<code>reduce_labels=True</code>を設定してすべてのラベルから 1 つを引く必要があります。ゼロインデックスは <code>255</code> に置き換えられるため、SegFormer の損失関数によって無視されます。",Es,bs,Ss,ls,Ls,as,qs,Ts,Ds,Us,Ul='トレーニング中にメトリクスを含めると、多くの場合、モデルのパフォーマンスを評価するのに役立ちます。 🤗 <a href="https://huggingface.co/docs/evaluate/index" rel="nofollow">Evaluate</a> ライブラリを使用して、評価メソッドをすばやくロードできます。このタスクでは、<a href="https://huggingface.co/spaces/evaluate-metric/accuracy" rel="nofollow">Mean Intersection over Union</a> (IoU) メトリックをロードします (🤗 Evaluate <a href="https://huggingface.co/docs/evaluate/a_quick_tour" rel="nofollow">クイック ツアー</a> を参照して、メトリクスをロードして計算する方法の詳細を確認してください)。',Ks,$s,Ps,Is,$l=`次に、メトリクスを <code>compute</code> する関数を作成します。予測を次のように変換する必要があります
最初にロジットを作成し、次に <code>compute</code> を呼び出す前にラベルのサイズに一致するように再形成します。`,Os,es,sl,ts,ll,_s,Il="これで<code>compute_metrics</code>関数の準備が整いました。トレーニングをセットアップするときにこの関数に戻ります。",al,Cs,el,ns,tl,ps,nl,Ws,pl,Zs,_l="モデルを微調整したので、それを推論に使用できるようになりました。",ml,Bs,Cl="推論のために画像をロードします。",rl,ks,cl,ms,Wl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/semantic-seg-image.png" alt="Image of bedroom"/>',il,rs,ol,cs,Ml,Gs,Zl='結果を視覚化するには、<a href="https://github.com/tensorflow/models/blob/3f1ca33afe3c1631b733ea7e40c294273b9e406d/research/deeplab/utils/get_dataset_colormap.py#L51" rel="nofollow">データセット カラー パレット</a> を、それぞれをマップする <code>ade_palette()</code> としてロードします。クラスを RGB 値に変換します。次に、画像と予測されたセグメンテーション マップを組み合わせてプロットできます。',jl,xs,hl,is,Bl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/semantic-seg-preds.png" alt="Image of bedroom overlaid with segmentation map"/>',gl,Rs,yl;return h=new vs({props:{title:"Semantic segmentation",local:"semantic-segmentation",headingTag:"h1"}}),k=new ql({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/semantic_segmentation.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/pytorch/semantic_segmentation.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/tensorflow/semantic_segmentation.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/semantic_segmentation.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/pytorch/semantic_segmentation.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/tensorflow/semantic_segmentation.ipynb"}]}}),I=new Ll({props:{id:"dKE8SIt9C-w"}}),G=new fl({props:{$$slots:{default:[Dl]},$$scope:{ctx:Z}}}),S=new X({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwZGF0YXNldHMlMjB0cmFuc2Zvcm1lcnMlMjBldmFsdWF0ZQ==",highlighted:"pip install -q datasets transformers evaluate",wrap:!1}}),L=new X({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),Q=new vs({props:{title:"Load SceneParse150 dataset",local:"load-sceneparse150-dataset",headingTag:"h2"}}),o=new X({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyc2NlbmVfcGFyc2VfMTUwJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiU1QiUzQTUwJTVEJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;scene_parse_150&quot;</span>, split=<span class="hljs-string">&quot;train[:50]&quot;</span>)`,wrap:!1}}),hs=new X({props:{code:"ZHMlMjAlM0QlMjBkcy50cmFpbl90ZXN0X3NwbGl0KHRlc3Rfc2l6ZSUzRDAuMiklMEF0cmFpbl9kcyUyMCUzRCUyMGRzJTVCJTIydHJhaW4lMjIlNUQlMEF0ZXN0X2RzJTIwJTNEJTIwZHMlNUIlMjJ0ZXN0JTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.train_test_split(test_size=<span class="hljs-number">0.2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>train_ds = ds[<span class="hljs-string">&quot;train&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>test_ds = ds[<span class="hljs-string">&quot;test&quot;</span>]`,wrap:!1}}),ys=new X({props:{code:"dHJhaW5fZHMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>train_ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=512x683 at <span class="hljs-number">0x7F9B0C201F90</span>&gt;,
 <span class="hljs-string">&#x27;annotation&#x27;</span>: &lt;PIL.PngImagePlugin.PngImageFile image mode=L size=512x683 at <span class="hljs-number">0x7F9B0C201DD0</span>&gt;,
 <span class="hljs-string">&#x27;scene_category&#x27;</span>: <span class="hljs-number">368</span>}`,wrap:!1}}),ws=new X({props:{code:"aW1wb3J0JTIwanNvbiUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBjYWNoZWRfZG93bmxvYWQlMkMlMjBoZl9odWJfdXJsJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMmh1Z2dpbmdmYWNlJTJGbGFiZWwtZmlsZXMlMjIlMEFmaWxlbmFtZSUyMCUzRCUyMCUyMmFkZTIway1pZDJsYWJlbC5qc29uJTIyJTBBaWQybGFiZWwlMjAlM0QlMjBqc29uLmxvYWQob3BlbihjYWNoZWRfZG93bmxvYWQoaGZfaHViX3VybChyZXBvX2lkJTJDJTIwZmlsZW5hbWUlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKSklMkMlMjAlMjJyJTIyKSklMEFpZDJsYWJlbCUyMCUzRCUyMCU3QmludChrKSUzQSUyMHYlMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaWQybGFiZWwuaXRlbXMoKSU3RCUwQWxhYmVsMmlkJTIwJTNEJTIwJTdCdiUzQSUyMGslMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaWQybGFiZWwuaXRlbXMoKSU3RCUwQW51bV9sYWJlbHMlMjAlM0QlMjBsZW4oaWQybGFiZWwp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> json
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> cached_download, hf_hub_url

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;huggingface/label-files&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>filename = <span class="hljs-string">&quot;ade20k-id2label.json&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>id2label = json.load(<span class="hljs-built_in">open</span>(cached_download(hf_hub_url(repo_id, filename, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)), <span class="hljs-string">&quot;r&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>id2label = {<span class="hljs-built_in">int</span>(k): v <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> id2label.items()}
<span class="hljs-meta">&gt;&gt;&gt; </span>label2id = {v: k <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> id2label.items()}
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(id2label)`,wrap:!1}}),us=new vs({props:{title:"Preprocess",local:"preprocess",headingTag:"h2"}}),bs=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJudmlkaWElMkZtaXQtYjAlMjIlMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjByZWR1Y2VfbGFiZWxzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;nvidia/mit-b0&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(checkpoint, reduce_labels=<span class="hljs-literal">True</span>)`,wrap:!1}}),ls=new os({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[Pl]},$$scope:{ctx:Z}}}),as=new os({props:{pytorch:!1,tensorflow:!0,jax:!1,$$slots:{tensorflow:[sa]},$$scope:{ctx:Z}}}),Ts=new vs({props:{title:"Evaluate",local:"evaluate",headingTag:"h2"}}),$s=new X({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMm1lYW5faW91JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> evaluate

<span class="hljs-meta">&gt;&gt;&gt; </span>metric = evaluate.load(<span class="hljs-string">&quot;mean_iou&quot;</span>)`,wrap:!1}}),es=new os({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[aa]},$$scope:{ctx:Z}}}),ts=new os({props:{pytorch:!1,tensorflow:!0,jax:!1,$$slots:{tensorflow:[ta]},$$scope:{ctx:Z}}}),Cs=new vs({props:{title:"Train",local:"train",headingTag:"h2"}}),ns=new os({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[ma]},$$scope:{ctx:Z}}}),ps=new os({props:{pytorch:!1,tensorflow:!0,jax:!1,$$slots:{tensorflow:[ia]},$$scope:{ctx:Z}}}),Ws=new vs({props:{title:"Inference",local:"inference",headingTag:"h2"}}),ks=new X({props:{code:"aW1hZ2UlMjAlM0QlMjBkcyU1QjAlNUQlNUIlMjJpbWFnZSUyMiU1RCUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>image = ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;image&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),rs=new os({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[Ma]},$$scope:{ctx:Z}}}),cs=new os({props:{pytorch:!1,tensorflow:!0,jax:!1,$$slots:{tensorflow:[ha]},$$scope:{ctx:Z}}}),xs=new X({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQSUwQWNvbG9yX3NlZyUyMCUzRCUyMG5wLnplcm9zKChwcmVkX3NlZy5zaGFwZSU1QjAlNUQlMkMlMjBwcmVkX3NlZy5zaGFwZSU1QjElNUQlMkMlMjAzKSUyQyUyMGR0eXBlJTNEbnAudWludDgpJTBBcGFsZXR0ZSUyMCUzRCUyMG5wLmFycmF5KGFkZV9wYWxldHRlKCkpJTBBZm9yJTIwbGFiZWwlMkMlMjBjb2xvciUyMGluJTIwZW51bWVyYXRlKHBhbGV0dGUpJTNBJTBBJTIwJTIwJTIwJTIwY29sb3Jfc2VnJTVCcHJlZF9zZWclMjAlM0QlM0QlMjBsYWJlbCUyQyUyMCUzQSU1RCUyMCUzRCUyMGNvbG9yJTBBY29sb3Jfc2VnJTIwJTNEJTIwY29sb3Jfc2VnJTVCLi4uJTJDJTIwJTNBJTNBLTElNUQlMjAlMjAlMjMlMjBjb252ZXJ0JTIwdG8lMjBCR1IlMEElMEFpbWclMjAlM0QlMjBucC5hcnJheShpbWFnZSklMjAqJTIwMC41JTIwJTJCJTIwY29sb3Jfc2VnJTIwKiUyMDAuNSUyMCUyMCUyMyUyMHBsb3QlMjB0aGUlMjBpbWFnZSUyMHdpdGglMjB0aGUlMjBzZWdtZW50YXRpb24lMjBtYXAlMEFpbWclMjAlM0QlMjBpbWcuYXN0eXBlKG5wLnVpbnQ4KSUwQSUwQXBsdC5maWd1cmUoZmlnc2l6ZSUzRCgxNSUyQyUyMDEwKSklMEFwbHQuaW1zaG93KGltZyklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>color_seg = np.zeros((pred_seg.shape[<span class="hljs-number">0</span>], pred_seg.shape[<span class="hljs-number">1</span>], <span class="hljs-number">3</span>), dtype=np.uint8)
<span class="hljs-meta">&gt;&gt;&gt; </span>palette = np.array(ade_palette())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> label, color <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(palette):
<span class="hljs-meta">... </span>    color_seg[pred_seg == label, :] = color
<span class="hljs-meta">&gt;&gt;&gt; </span>color_seg = color_seg[..., ::-<span class="hljs-number">1</span>]  <span class="hljs-comment"># convert to BGR</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>img = np.array(image) * <span class="hljs-number">0.5</span> + color_seg * <span class="hljs-number">0.5</span>  <span class="hljs-comment"># plot the image with the segmentation map</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>img = img.astype(np.uint8)

<span class="hljs-meta">&gt;&gt;&gt; </span>plt.figure(figsize=(<span class="hljs-number">15</span>, <span class="hljs-number">10</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.imshow(img)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()`,wrap:!1}}),{c(){a=U("meta"),M=c(),l=U("p"),r=c(),g(h.$$.fragment),d=c(),g(k.$$.fragment),B=c(),g(I.$$.fragment),R=c(),C=U("p"),C.innerHTML=Y,v=c(),b=U("p"),b.textContent=V,m=c(),T=U("ol"),T.innerHTML=F,j=c(),g(G.$$.fragment),p=c(),_=U("p"),_.textContent=E,A=c(),g(S.$$.fragment),D=c(),N=U("p"),N.textContent=js,z=c(),g(L.$$.fragment),K=c(),g(Q.$$.fragment),P=c(),H=U("p"),H.textContent=Xs,O=c(),g(o.$$.fragment),x=c(),q=U("p"),q.innerHTML=wl,Ys=c(),g(hs.$$.fragment),Vs=c(),gs=U("p"),gs.textContent=ul,Fs=c(),g(ys.$$.fragment),Ns=c(),Js=U("ul"),Js.innerHTML=dl,Qs=c(),fs=U("p"),fs.innerHTML=bl,Hs=c(),g(ws.$$.fragment),As=c(),g(us.$$.fragment),zs=c(),ds=U("p"),ds.innerHTML=Tl,Es=c(),g(bs.$$.fragment),Ss=c(),g(ls.$$.fragment),Ls=c(),g(as.$$.fragment),qs=c(),g(Ts.$$.fragment),Ds=c(),Us=U("p"),Us.innerHTML=Ul,Ks=c(),g($s.$$.fragment),Ps=c(),Is=U("p"),Is.innerHTML=$l,Os=c(),g(es.$$.fragment),sl=c(),g(ts.$$.fragment),ll=c(),_s=U("p"),_s.innerHTML=Il,al=c(),g(Cs.$$.fragment),el=c(),g(ns.$$.fragment),tl=c(),g(ps.$$.fragment),nl=c(),g(Ws.$$.fragment),pl=c(),Zs=U("p"),Zs.textContent=_l,ml=c(),Bs=U("p"),Bs.textContent=Cl,rl=c(),g(ks.$$.fragment),cl=c(),ms=U("div"),ms.innerHTML=Wl,il=c(),g(rs.$$.fragment),ol=c(),g(cs.$$.fragment),Ml=c(),Gs=U("p"),Gs.innerHTML=Zl,jl=c(),g(xs.$$.fragment),hl=c(),is=U("div"),is.innerHTML=Bl,gl=c(),Rs=U("p"),this.h()},l(s){const n=El("svelte-u9bgzb",document.head);a=$(n,"META",{name:!0,content:!0}),n.forEach(e),M=i(s),l=$(s,"P",{}),Nl(l).forEach(e),r=i(s),y(h.$$.fragment,s),d=i(s),y(k.$$.fragment,s),B=i(s),y(I.$$.fragment,s),R=i(s),C=$(s,"P",{"data-svelte-h":!0}),W(C)!=="svelte-aptwcv"&&(C.innerHTML=Y),v=i(s),b=$(s,"P",{"data-svelte-h":!0}),W(b)!=="svelte-w5jzhi"&&(b.textContent=V),m=i(s),T=$(s,"OL",{"data-svelte-h":!0}),W(T)!=="svelte-1jiwjp7"&&(T.innerHTML=F),j=i(s),y(G.$$.fragment,s),p=i(s),_=$(s,"P",{"data-svelte-h":!0}),W(_)!=="svelte-1lya3k8"&&(_.textContent=E),A=i(s),y(S.$$.fragment,s),D=i(s),N=$(s,"P",{"data-svelte-h":!0}),W(N)!=="svelte-193zy02"&&(N.textContent=js),z=i(s),y(L.$$.fragment,s),K=i(s),y(Q.$$.fragment,s),P=i(s),H=$(s,"P",{"data-svelte-h":!0}),W(H)!=="svelte-1q1mg88"&&(H.textContent=Xs),O=i(s),y(o.$$.fragment,s),x=i(s),q=$(s,"P",{"data-svelte-h":!0}),W(q)!=="svelte-m4w3yq"&&(q.innerHTML=wl),Ys=i(s),y(hs.$$.fragment,s),Vs=i(s),gs=$(s,"P",{"data-svelte-h":!0}),W(gs)!=="svelte-1r6oj5w"&&(gs.textContent=ul),Fs=i(s),y(ys.$$.fragment,s),Ns=i(s),Js=$(s,"UL",{"data-svelte-h":!0}),W(Js)!=="svelte-1qjmioa"&&(Js.innerHTML=dl),Qs=i(s),fs=$(s,"P",{"data-svelte-h":!0}),W(fs)!=="svelte-aqhl7k"&&(fs.innerHTML=bl),Hs=i(s),y(ws.$$.fragment,s),As=i(s),y(us.$$.fragment,s),zs=i(s),ds=$(s,"P",{"data-svelte-h":!0}),W(ds)!=="svelte-hryy6n"&&(ds.innerHTML=Tl),Es=i(s),y(bs.$$.fragment,s),Ss=i(s),y(ls.$$.fragment,s),Ls=i(s),y(as.$$.fragment,s),qs=i(s),y(Ts.$$.fragment,s),Ds=i(s),Us=$(s,"P",{"data-svelte-h":!0}),W(Us)!=="svelte-cdztvg"&&(Us.innerHTML=Ul),Ks=i(s),y($s.$$.fragment,s),Ps=i(s),Is=$(s,"P",{"data-svelte-h":!0}),W(Is)!=="svelte-1d4c85c"&&(Is.innerHTML=$l),Os=i(s),y(es.$$.fragment,s),sl=i(s),y(ts.$$.fragment,s),ll=i(s),_s=$(s,"P",{"data-svelte-h":!0}),W(_s)!=="svelte-18cw5xr"&&(_s.innerHTML=Il),al=i(s),y(Cs.$$.fragment,s),el=i(s),y(ns.$$.fragment,s),tl=i(s),y(ps.$$.fragment,s),nl=i(s),y(Ws.$$.fragment,s),pl=i(s),Zs=$(s,"P",{"data-svelte-h":!0}),W(Zs)!=="svelte-cyrfc8"&&(Zs.textContent=_l),ml=i(s),Bs=$(s,"P",{"data-svelte-h":!0}),W(Bs)!=="svelte-21b5vl"&&(Bs.textContent=Cl),rl=i(s),y(ks.$$.fragment,s),cl=i(s),ms=$(s,"DIV",{class:!0,"data-svelte-h":!0}),W(ms)!=="svelte-11jfm1f"&&(ms.innerHTML=Wl),il=i(s),y(rs.$$.fragment,s),ol=i(s),y(cs.$$.fragment,s),Ml=i(s),Gs=$(s,"P",{"data-svelte-h":!0}),W(Gs)!=="svelte-e1i4a5"&&(Gs.innerHTML=Zl),jl=i(s),y(xs.$$.fragment,s),hl=i(s),is=$(s,"DIV",{class:!0,"data-svelte-h":!0}),W(is)!=="svelte-nsecok"&&(is.innerHTML=Bl),gl=i(s),Rs=$(s,"P",{}),Nl(Rs).forEach(e),this.h()},h(){Jl(a,"name","hf:doc:metadata"),Jl(a,"content",ya),Jl(ms,"class","flex justify-center"),Jl(is,"class","flex justify-center")},m(s,n){Sl(document.head,a),t(s,M,n),t(s,l,n),t(s,r,n),J(h,s,n),t(s,d,n),J(k,s,n),t(s,B,n),J(I,s,n),t(s,R,n),t(s,C,n),t(s,v,n),t(s,b,n),t(s,m,n),t(s,T,n),t(s,j,n),J(G,s,n),t(s,p,n),t(s,_,n),t(s,A,n),J(S,s,n),t(s,D,n),t(s,N,n),t(s,z,n),J(L,s,n),t(s,K,n),J(Q,s,n),t(s,P,n),t(s,H,n),t(s,O,n),J(o,s,n),t(s,x,n),t(s,q,n),t(s,Ys,n),J(hs,s,n),t(s,Vs,n),t(s,gs,n),t(s,Fs,n),J(ys,s,n),t(s,Ns,n),t(s,Js,n),t(s,Qs,n),t(s,fs,n),t(s,Hs,n),J(ws,s,n),t(s,As,n),J(us,s,n),t(s,zs,n),t(s,ds,n),t(s,Es,n),J(bs,s,n),t(s,Ss,n),J(ls,s,n),t(s,Ls,n),J(as,s,n),t(s,qs,n),J(Ts,s,n),t(s,Ds,n),t(s,Us,n),t(s,Ks,n),J($s,s,n),t(s,Ps,n),t(s,Is,n),t(s,Os,n),J(es,s,n),t(s,sl,n),J(ts,s,n),t(s,ll,n),t(s,_s,n),t(s,al,n),J(Cs,s,n),t(s,el,n),J(ns,s,n),t(s,tl,n),J(ps,s,n),t(s,nl,n),J(Ws,s,n),t(s,pl,n),t(s,Zs,n),t(s,ml,n),t(s,Bs,n),t(s,rl,n),J(ks,s,n),t(s,cl,n),t(s,ms,n),t(s,il,n),J(rs,s,n),t(s,ol,n),J(cs,s,n),t(s,Ml,n),t(s,Gs,n),t(s,jl,n),J(xs,s,n),t(s,hl,n),t(s,is,n),t(s,gl,n),t(s,Rs,n),yl=!0},p(s,[n]){const kl={};n&2&&(kl.$$scope={dirty:n,ctx:s}),G.$set(kl);const Gl={};n&2&&(Gl.$$scope={dirty:n,ctx:s}),ls.$set(Gl);const xl={};n&2&&(xl.$$scope={dirty:n,ctx:s}),as.$set(xl);const vl={};n&2&&(vl.$$scope={dirty:n,ctx:s}),es.$set(vl);const Xl={};n&2&&(Xl.$$scope={dirty:n,ctx:s}),ts.$set(Xl);const Rl={};n&2&&(Rl.$$scope={dirty:n,ctx:s}),ns.$set(Rl);const Yl={};n&2&&(Yl.$$scope={dirty:n,ctx:s}),ps.$set(Yl);const Vl={};n&2&&(Vl.$$scope={dirty:n,ctx:s}),rs.$set(Vl);const Fl={};n&2&&(Fl.$$scope={dirty:n,ctx:s}),cs.$set(Fl)},i(s){yl||(f(h.$$.fragment,s),f(k.$$.fragment,s),f(I.$$.fragment,s),f(G.$$.fragment,s),f(S.$$.fragment,s),f(L.$$.fragment,s),f(Q.$$.fragment,s),f(o.$$.fragment,s),f(hs.$$.fragment,s),f(ys.$$.fragment,s),f(ws.$$.fragment,s),f(us.$$.fragment,s),f(bs.$$.fragment,s),f(ls.$$.fragment,s),f(as.$$.fragment,s),f(Ts.$$.fragment,s),f($s.$$.fragment,s),f(es.$$.fragment,s),f(ts.$$.fragment,s),f(Cs.$$.fragment,s),f(ns.$$.fragment,s),f(ps.$$.fragment,s),f(Ws.$$.fragment,s),f(ks.$$.fragment,s),f(rs.$$.fragment,s),f(cs.$$.fragment,s),f(xs.$$.fragment,s),yl=!0)},o(s){w(h.$$.fragment,s),w(k.$$.fragment,s),w(I.$$.fragment,s),w(G.$$.fragment,s),w(S.$$.fragment,s),w(L.$$.fragment,s),w(Q.$$.fragment,s),w(o.$$.fragment,s),w(hs.$$.fragment,s),w(ys.$$.fragment,s),w(ws.$$.fragment,s),w(us.$$.fragment,s),w(bs.$$.fragment,s),w(ls.$$.fragment,s),w(as.$$.fragment,s),w(Ts.$$.fragment,s),w($s.$$.fragment,s),w(es.$$.fragment,s),w(ts.$$.fragment,s),w(Cs.$$.fragment,s),w(ns.$$.fragment,s),w(ps.$$.fragment,s),w(Ws.$$.fragment,s),w(ks.$$.fragment,s),w(rs.$$.fragment,s),w(cs.$$.fragment,s),w(xs.$$.fragment,s),yl=!1},d(s){s&&(e(M),e(l),e(r),e(d),e(B),e(R),e(C),e(v),e(b),e(m),e(T),e(j),e(p),e(_),e(A),e(D),e(N),e(z),e(K),e(P),e(H),e(O),e(x),e(q),e(Ys),e(Vs),e(gs),e(Fs),e(Ns),e(Js),e(Qs),e(fs),e(Hs),e(As),e(zs),e(ds),e(Es),e(Ss),e(Ls),e(qs),e(Ds),e(Us),e(Ks),e(Ps),e(Is),e(Os),e(sl),e(ll),e(_s),e(al),e(el),e(tl),e(nl),e(pl),e(Zs),e(ml),e(Bs),e(rl),e(cl),e(ms),e(il),e(ol),e(Ml),e(Gs),e(jl),e(hl),e(is),e(gl),e(Rs)),e(a),u(h,s),u(k,s),u(I,s),u(G,s),u(S,s),u(L,s),u(Q,s),u(o,s),u(hs,s),u(ys,s),u(ws,s),u(us,s),u(bs,s),u(ls,s),u(as,s),u(Ts,s),u($s,s),u(es,s),u(ts,s),u(Cs,s),u(ns,s),u(ps,s),u(Ws,s),u(ks,s),u(rs,s),u(cs,s),u(xs,s)}}}const ya='{"title":"Semantic segmentation","local":"semantic-segmentation","sections":[{"title":"Load SceneParse150 dataset","local":"load-sceneparse150-dataset","sections":[],"depth":2},{"title":"Preprocess","local":"preprocess","sections":[],"depth":2},{"title":"Evaluate","local":"evaluate","sections":[],"depth":2},{"title":"Train","local":"train","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function Ja(Z){return Hl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ia extends Al{constructor(a){super(),zl(this,a,Ja,ga,Ql,{})}}export{Ia as component};
