import{s as jt,f as Jt,o as vt,n as Ne}from"../chunks/scheduler.25b97de1.js";import{S as $t,i as Bt,g as r,s as o,r as d,A as kt,h as p,f as n,c as l,j as ue,u as m,x as b,k as Z,y as w,a as s,v as g,d as u,t as f,w as y}from"../chunks/index.d9030fc9.js";import{T as Mt}from"../chunks/Tip.baa67368.js";import{D as Ve}from"../chunks/Docstring.ffac8efa.js";import{C as Xe}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Tt}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as x,E as Wt}from"../chunks/EditOnGithub.91d95064.js";function Zt(W){let a,M='<a href="depth_anything_v2">Depth Anything V2</a> was released in June 2024. It uses the same architecture as Depth Anything and therefore it is compatible with all code examples and existing workflows. However, it leverages synthetic data and a larger capacity teacher model to achieve much finer and robust depth predictions.';return{c(){a=r("p"),a.innerHTML=M},l(h){a=p(h,"P",{"data-svelte-h":!0}),b(a)!=="svelte-1s2kjzv"&&(a.innerHTML=M)},m(h,c){s(h,a,c)},p:Ne,d(h){h&&n(a)}}}function Ct(W){let a,M="Example:",h,c,_;return c=new Xe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlcHRoQW55dGhpbmdDb25maWclMkMlMjBEZXB0aEFueXRoaW5nRm9yRGVwdGhFc3RpbWF0aW9uJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMERlcHRoQW55dGhpbmclMjBzbWFsbCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBEZXB0aEFueXRoaW5nQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjBmcm9tJTIwdGhlJTIwRGVwdGhBbnl0aGluZyUyMHNtYWxsJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBEZXB0aEFueXRoaW5nRm9yRGVwdGhFc3RpbWF0aW9uKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DepthAnythingConfig, DepthAnythingForDepthEstimation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a DepthAnything small style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = DepthAnythingConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the DepthAnything small style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DepthAnythingForDepthEstimation(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){a=r("p"),a.textContent=M,h=o(),d(c.$$.fragment)},l(i){a=p(i,"P",{"data-svelte-h":!0}),b(a)!=="svelte-11lpom8"&&(a.textContent=M),h=l(i),m(c.$$.fragment,i)},m(i,T){s(i,a,T),s(i,h,T),g(c,i,T),_=!0},p:Ne,i(i){_||(u(c.$$.fragment,i),_=!0)},o(i){f(c.$$.fragment,i),_=!1},d(i){i&&(n(a),n(h)),y(c,i)}}}function Ut(W){let a,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=r("p"),a.innerHTML=M},l(h){a=p(h,"P",{"data-svelte-h":!0}),b(a)!=="svelte-fincs2"&&(a.innerHTML=M)},m(h,c){s(h,a,c)},p:Ne,d(h){h&&n(a)}}}function Gt(W){let a,M="Examples:",h,c,_;return c=new Xe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJMaWhlWW91bmclMkZkZXB0aC1hbnl0aGluZy1zbWFsbC1oZiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyTGloZVlvdW5nJTJGZGVwdGgtYW55dGhpbmctc21hbGwtaGYlMjIpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGltYWdlJTIwZm9yJTIwdGhlJTIwbW9kZWwlMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBJTIzJTIwaW50ZXJwb2xhdGUlMjB0byUyMG9yaWdpbmFsJTIwc2l6ZSUwQXBvc3RfcHJvY2Vzc2VkX291dHB1dCUyMCUzRCUyMGltYWdlX3Byb2Nlc3Nvci5wb3N0X3Byb2Nlc3NfZGVwdGhfZXN0aW1hdGlvbiglMEElMjAlMjAlMjAlMjBvdXRwdXRzJTJDJTBBJTIwJTIwJTIwJTIwdGFyZ2V0X3NpemVzJTNEJTVCKGltYWdlLmhlaWdodCUyQyUyMGltYWdlLndpZHRoKSU1RCUyQyUwQSklMEElMEElMjMlMjB2aXN1YWxpemUlMjB0aGUlMjBwcmVkaWN0aW9uJTBBcHJlZGljdGVkX2RlcHRoJTIwJTNEJTIwcG9zdF9wcm9jZXNzZWRfb3V0cHV0JTVCMCU1RCU1QiUyMnByZWRpY3RlZF9kZXB0aCUyMiU1RCUwQWRlcHRoJTIwJTNEJTIwcHJlZGljdGVkX2RlcHRoJTIwKiUyMDI1NSUyMCUyRiUyMHByZWRpY3RlZF9kZXB0aC5tYXgoKSUwQWRlcHRoJTIwJTNEJTIwZGVwdGguZGV0YWNoKCkuY3B1KCkubnVtcHkoKSUwQWRlcHRoJTIwJTNEJTIwSW1hZ2UuZnJvbWFycmF5KGRlcHRoLmFzdHlwZSglMjJ1aW50OCUyMikp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;LiheYoung/depth-anything-small-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;LiheYoung/depth-anything-small-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># interpolate to original size</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>post_processed_output = image_processor.post_process_depth_estimation(
<span class="hljs-meta">... </span>    outputs,
<span class="hljs-meta">... </span>    target_sizes=[(image.height, image.width)],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># visualize the prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_depth = post_processed_output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;predicted_depth&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = predicted_depth * <span class="hljs-number">255</span> / predicted_depth.<span class="hljs-built_in">max</span>()
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = depth.detach().cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(depth.astype(<span class="hljs-string">&quot;uint8&quot;</span>))`,wrap:!1}}),{c(){a=r("p"),a.textContent=M,h=o(),d(c.$$.fragment)},l(i){a=p(i,"P",{"data-svelte-h":!0}),b(a)!=="svelte-kvfsh7"&&(a.textContent=M),h=l(i),m(c.$$.fragment,i)},m(i,T){s(i,a,T),s(i,h,T),g(c,i,T),_=!0},p:Ne,i(i){_||(u(c.$$.fragment,i),_=!0)},o(i){f(c.$$.fragment,i),_=!1},d(i){i&&(n(a),n(h)),y(c,i)}}}function It(W){let a,M,h,c,_,i,T,ye,D,st='The Depth Anything model was proposed in <a href="https://arxiv.org/abs/2401.10891" rel="nofollow">Depth Anything: Unleashing the Power of Large-Scale Unlabeled Data</a> by Lihe Yang, Bingyi Kang, Zilong Huang, Xiaogang Xu, Jiashi Feng, Hengshuang Zhao. Depth Anything is based on the <a href="dpt">DPT</a> architecture, trained on ~62 million images, obtaining state-of-the-art results for both relative and absolute depth estimation.',be,C,we,E,at="The abstract from the paper is the following:",_e,F,ot="<em>This work presents Depth Anything, a highly practical solution for robust monocular depth estimation. Without pursuing novel technical modules, we aim to build a simple yet powerful foundation model dealing with any images under any circumstances. To this end, we scale up the dataset by designing a data engine to collect and automatically annotate large-scale unlabeled data (~62M), which significantly enlarges the data coverage and thus is able to reduce the generalization error. We investigate two simple yet effective strategies that make data scaling-up promising. First, a more challenging optimization target is created by leveraging data augmentation tools. It compels the model to actively seek extra visual knowledge and acquire robust representations. Second, an auxiliary supervision is developed to enforce the model to inherit rich semantic priors from pre-trained encoders. We evaluate its zero-shot capabilities extensively, including six public datasets and randomly captured photos. It demonstrates impressive generalization ability. Further, through fine-tuning it with metric depth information from NYUv2 and KITTI, new SOTAs are set. Our better depth model also results in a better depth-conditioned ControlNet.</em>",Me,U,lt,Te,z,it='Depth Anything overview. Taken from the <a href="https://arxiv.org/abs/2401.10891">original paper</a>.',je,H,rt=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>.
The original code can be found <a href="https://github.com/LiheYoung/Depth-Anything" rel="nofollow">here</a>.`,Je,V,ve,X,pt="There are 2 main ways to use Depth Anything: either using the pipeline API, which abstracts away all the complexity for you, or by using the <code>DepthAnythingForDepthEstimation</code> class yourself.",$e,N,Be,Y,ht="The pipeline allows to use the model in a few lines of code:",ke,L,We,P,Ze,S,ct="If you want to do the pre- and postprocessing yourself, here’s how to do that:",Ce,q,Ue,Q,Ge,K,dt="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with Depth Anything.",Ie,O,mt='<li><a href="../tasks/monocular_depth_estimation">Monocular depth estimation task guide</a></li> <li>A notebook showcasing inference with <a href="/docs/transformers/main/en/model_doc/depth_anything#transformers.DepthAnythingForDepthEstimation">DepthAnythingForDepthEstimation</a> can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/blob/master/Depth%20Anything/Predicting_depth_in_an_image_with_Depth_Anything.ipynb" rel="nofollow">here</a>. 🌎</li>',Ae,ee,gt="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",Re,te,xe,j,ne,Ye,pe,ut=`This is the configuration class to store the configuration of a <code>DepthAnythingModel</code>. It is used to instantiate a DepthAnything
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the DepthAnything
<a href="https://huggingface.co/LiheYoung/depth-anything-small-hf" rel="nofollow">LiheYoung/depth-anything-small-hf</a> architecture.`,Le,he,ft=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Pe,G,Se,I,se,qe,ce,yt=`Serializes this instance to a Python dictionary. Override the default <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig.to_dict">to_dict()</a>. Returns:
<code>Dict[str, any]</code>: Dictionary of all the attributes that make up this configuration instance,`,De,ae,Ee,J,oe,Qe,de,bt="Depth Anything Model with a depth estimation head on top (consisting of 3 convolutional layers) e.g. for KITTI, NYUv2.",Ke,me,wt=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Oe,$,le,et,ge,_t='The <a href="/docs/transformers/main/en/model_doc/depth_anything#transformers.DepthAnythingForDepthEstimation">DepthAnythingForDepthEstimation</a> forward method, overrides the <code>__call__</code> special method.',tt,A,nt,R,Fe,ie,ze,fe,He;return _=new x({props:{title:"Depth Anything",local:"depth-anything",headingTag:"h1"}}),T=new x({props:{title:"Overview",local:"overview",headingTag:"h2"}}),C=new Mt({props:{$$slots:{default:[Zt]},$$scope:{ctx:W}}}),V=new x({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),N=new x({props:{title:"Pipeline API",local:"pipeline-api",headingTag:"h3"}}),L=new Xe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEElMjMlMjBsb2FkJTIwcGlwZSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyZGVwdGgtZXN0aW1hdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyTGloZVlvdW5nJTJGZGVwdGgtYW55dGhpbmctc21hbGwtaGYlMjIpJTBBJTBBJTIzJTIwbG9hZCUyMGltYWdlJTBBdXJsJTIwJTNEJTIwJ2h0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGcnJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBJTIzJTIwaW5mZXJlbmNlJTBBZGVwdGglMjAlM0QlMjBwaXBlKGltYWdlKSU1QiUyMmRlcHRoJTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load pipe</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(task=<span class="hljs-string">&quot;depth-estimation&quot;</span>, model=<span class="hljs-string">&quot;LiheYoung/depth-anything-small-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&#x27;http://images.cocodataset.org/val2017/000000039769.jpg&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = pipe(image)[<span class="hljs-string">&quot;depth&quot;</span>]`,wrap:!1}}),P=new x({props:{title:"Using the model yourself",local:"using-the-model-yourself",headingTag:"h3"}}),q=new Xe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJMaWhlWW91bmclMkZkZXB0aC1hbnl0aGluZy1zbWFsbC1oZiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyTGloZVlvdW5nJTJGZGVwdGgtYW55dGhpbmctc21hbGwtaGYlMjIpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGltYWdlJTIwZm9yJTIwdGhlJTIwbW9kZWwlMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBJTIzJTIwaW50ZXJwb2xhdGUlMjB0byUyMG9yaWdpbmFsJTIwc2l6ZSUyMGFuZCUyMHZpc3VhbGl6ZSUyMHRoZSUyMHByZWRpY3Rpb24lMEFwb3N0X3Byb2Nlc3NlZF9vdXRwdXQlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IucG9zdF9wcm9jZXNzX2RlcHRoX2VzdGltYXRpb24oJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9zaXplcyUzRCU1QihpbWFnZS5oZWlnaHQlMkMlMjBpbWFnZS53aWR0aCklNUQlMkMlMEEpJTBBJTBBcHJlZGljdGVkX2RlcHRoJTIwJTNEJTIwcG9zdF9wcm9jZXNzZWRfb3V0cHV0JTVCMCU1RCU1QiUyMnByZWRpY3RlZF9kZXB0aCUyMiU1RCUwQWRlcHRoJTIwJTNEJTIwKHByZWRpY3RlZF9kZXB0aCUyMC0lMjBwcmVkaWN0ZWRfZGVwdGgubWluKCkpJTIwJTJGJTIwKHByZWRpY3RlZF9kZXB0aC5tYXgoKSUyMC0lMjBwcmVkaWN0ZWRfZGVwdGgubWluKCkpJTBBZGVwdGglMjAlM0QlMjBkZXB0aC5kZXRhY2goKS5jcHUoKS5udW1weSgpJTIwKiUyMDI1NSUwQWRlcHRoJTIwJTNEJTIwSW1hZ2UuZnJvbWFycmF5KGRlcHRoLmFzdHlwZSglMjJ1aW50OCUyMikp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;LiheYoung/depth-anything-small-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;LiheYoung/depth-anything-small-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># interpolate to original size and visualize the prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>post_processed_output = image_processor.post_process_depth_estimation(
<span class="hljs-meta">... </span>    outputs,
<span class="hljs-meta">... </span>    target_sizes=[(image.height, image.width)],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_depth = post_processed_output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;predicted_depth&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = (predicted_depth - predicted_depth.<span class="hljs-built_in">min</span>()) / (predicted_depth.<span class="hljs-built_in">max</span>() - predicted_depth.<span class="hljs-built_in">min</span>())
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = depth.detach().cpu().numpy() * <span class="hljs-number">255</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(depth.astype(<span class="hljs-string">&quot;uint8&quot;</span>))`,wrap:!1}}),Q=new x({props:{title:"Resources",local:"resources",headingTag:"h2"}}),te=new x({props:{title:"DepthAnythingConfig",local:"transformers.DepthAnythingConfig",headingTag:"h2"}}),ne=new Ve({props:{name:"class transformers.DepthAnythingConfig",anchor:"transformers.DepthAnythingConfig",parameters:[{name:"backbone_config",val:" = None"},{name:"backbone",val:" = None"},{name:"use_pretrained_backbone",val:" = False"},{name:"use_timm_backbone",val:" = False"},{name:"backbone_kwargs",val:" = None"},{name:"patch_size",val:" = 14"},{name:"initializer_range",val:" = 0.02"},{name:"reassemble_hidden_size",val:" = 384"},{name:"reassemble_factors",val:" = [4, 2, 1, 0.5]"},{name:"neck_hidden_sizes",val:" = [48, 96, 192, 384]"},{name:"fusion_hidden_size",val:" = 64"},{name:"head_in_index",val:" = -1"},{name:"head_hidden_size",val:" = 32"},{name:"depth_estimation_type",val:" = 'relative'"},{name:"max_depth",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DepthAnythingConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>Union[Dict[str, Any], PretrainedConfig]</code>, <em>optional</em>) &#x2014;
The configuration of the backbone model. Only used in case <code>is_hybrid</code> is <code>True</code> or in case you want to
leverage the <a href="/docs/transformers/main/en/main_classes/backbones#transformers.AutoBackbone">AutoBackbone</a> API.`,name:"backbone_config"},{anchor:"transformers.DepthAnythingConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of backbone to use when <code>backbone_config</code> is <code>None</code>. If <code>use_pretrained_backbone</code> is <code>True</code>, this
will load the corresponding pretrained weights from the timm or transformers library. If <code>use_pretrained_backbone</code>
is <code>False</code>, this loads the backbone&#x2019;s config and uses that to initialize the backbone with random weights.`,name:"backbone"},{anchor:"transformers.DepthAnythingConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use pretrained weights for the backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.DepthAnythingConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use the <code>timm</code> library for the backbone. If set to <code>False</code>, will use the <a href="/docs/transformers/main/en/main_classes/backbones#transformers.AutoBackbone">AutoBackbone</a>
API.`,name:"use_timm_backbone"},{anchor:"transformers.DepthAnythingConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Keyword arguments to be passed to AutoBackbone when loading from a checkpoint
e.g. <code>{&apos;out_indices&apos;: (0, 1, 2, 3)}</code>. Cannot be specified if <code>backbone_config</code> is set.`,name:"backbone_kwargs"},{anchor:"transformers.DepthAnythingConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 14) &#x2014;
The size of the patches to extract from the backbone features.`,name:"patch_size"},{anchor:"transformers.DepthAnythingConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.DepthAnythingConfig.reassemble_hidden_size",description:`<strong>reassemble_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 384) &#x2014;
The number of input channels of the reassemble layers.`,name:"reassemble_hidden_size"},{anchor:"transformers.DepthAnythingConfig.reassemble_factors",description:`<strong>reassemble_factors</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[4, 2, 1, 0.5]</code>) &#x2014;
The up/downsampling factors of the reassemble layers.`,name:"reassemble_factors"},{anchor:"transformers.DepthAnythingConfig.neck_hidden_sizes",description:`<strong>neck_hidden_sizes</strong> (<code>List[str]</code>, <em>optional</em>, defaults to <code>[48, 96, 192, 384]</code>) &#x2014;
The hidden sizes to project to for the feature maps of the backbone.`,name:"neck_hidden_sizes"},{anchor:"transformers.DepthAnythingConfig.fusion_hidden_size",description:`<strong>fusion_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
The number of channels before fusion.`,name:"fusion_hidden_size"},{anchor:"transformers.DepthAnythingConfig.head_in_index",description:`<strong>head_in_index</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
The index of the features to use in the depth estimation head.`,name:"head_in_index"},{anchor:"transformers.DepthAnythingConfig.head_hidden_size",description:`<strong>head_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The number of output channels in the second convolution of the depth estimation head.`,name:"head_hidden_size"},{anchor:"transformers.DepthAnythingConfig.depth_estimation_type",description:`<strong>depth_estimation_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;relative&quot;</code>) &#x2014;
The type of depth estimation to use. Can be one of <code>[&quot;relative&quot;, &quot;metric&quot;]</code>.`,name:"depth_estimation_type"},{anchor:"transformers.DepthAnythingConfig.max_depth",description:`<strong>max_depth</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The maximum depth to use for the &#x201C;metric&#x201D; depth estimation head. 20 should be used for indoor models
and 80 for outdoor models. For &#x201C;relative&#x201D; depth estimation, this value is ignored.`,name:"max_depth"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_anything/configuration_depth_anything.py#L28"}}),G=new Tt({props:{anchor:"transformers.DepthAnythingConfig.example",$$slots:{default:[Ct]},$$scope:{ctx:W}}}),se=new Ve({props:{name:"to_dict",anchor:"transformers.DepthAnythingConfig.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_anything/configuration_depth_anything.py#L154"}}),ae=new x({props:{title:"DepthAnythingForDepthEstimation",local:"transformers.DepthAnythingForDepthEstimation",headingTag:"h2"}}),oe=new Ve({props:{name:"class transformers.DepthAnythingForDepthEstimation",anchor:"transformers.DepthAnythingForDepthEstimation",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.DepthAnythingForDepthEstimation.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/depth_anything#transformers.DepthAnythingConfig">DepthAnythingConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_anything/modeling_depth_anything.py#L362"}}),le=new Ve({props:{name:"forward",anchor:"transformers.DepthAnythingForDepthEstimation.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.DepthAnythingForDepthEstimation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">DPTImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.DepthAnythingForDepthEstimation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DepthAnythingForDepthEstimation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DepthAnythingForDepthEstimation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.DepthAnythingForDepthEstimation.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Ground truth depth estimation maps for computing the loss.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_anything/modeling_depth_anything.py#L381",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.DepthEstimatorOutput"
>transformers.modeling_outputs.DepthEstimatorOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/depth_anything#transformers.DepthAnythingConfig"
>DepthAnythingConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>predicted_depth</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, height, width)</code>) — Predicted depth for each pixel.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, num_channels, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.DepthEstimatorOutput"
>transformers.modeling_outputs.DepthEstimatorOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),A=new Mt({props:{$$slots:{default:[Ut]},$$scope:{ctx:W}}}),R=new Tt({props:{anchor:"transformers.DepthAnythingForDepthEstimation.forward.example",$$slots:{default:[Gt]},$$scope:{ctx:W}}}),ie=new Wt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/depth_anything.md"}}),{c(){a=r("meta"),M=o(),h=r("p"),c=o(),d(_.$$.fragment),i=o(),d(T.$$.fragment),ye=o(),D=r("p"),D.innerHTML=st,be=o(),d(C.$$.fragment),we=o(),E=r("p"),E.textContent=at,_e=o(),F=r("p"),F.innerHTML=ot,Me=o(),U=r("img"),Te=o(),z=r("small"),z.innerHTML=it,je=o(),H=r("p"),H.innerHTML=rt,Je=o(),d(V.$$.fragment),ve=o(),X=r("p"),X.innerHTML=pt,$e=o(),d(N.$$.fragment),Be=o(),Y=r("p"),Y.textContent=ht,ke=o(),d(L.$$.fragment),We=o(),d(P.$$.fragment),Ze=o(),S=r("p"),S.textContent=ct,Ce=o(),d(q.$$.fragment),Ue=o(),d(Q.$$.fragment),Ge=o(),K=r("p"),K.textContent=dt,Ie=o(),O=r("ul"),O.innerHTML=mt,Ae=o(),ee=r("p"),ee.textContent=gt,Re=o(),d(te.$$.fragment),xe=o(),j=r("div"),d(ne.$$.fragment),Ye=o(),pe=r("p"),pe.innerHTML=ut,Le=o(),he=r("p"),he.innerHTML=ft,Pe=o(),d(G.$$.fragment),Se=o(),I=r("div"),d(se.$$.fragment),qe=o(),ce=r("p"),ce.innerHTML=yt,De=o(),d(ae.$$.fragment),Ee=o(),J=r("div"),d(oe.$$.fragment),Qe=o(),de=r("p"),de.textContent=bt,Ke=o(),me=r("p"),me.innerHTML=wt,Oe=o(),$=r("div"),d(le.$$.fragment),et=o(),ge=r("p"),ge.innerHTML=_t,tt=o(),d(A.$$.fragment),nt=o(),d(R.$$.fragment),Fe=o(),d(ie.$$.fragment),ze=o(),fe=r("p"),this.h()},l(e){const t=kt("svelte-u9bgzb",document.head);a=p(t,"META",{name:!0,content:!0}),t.forEach(n),M=l(e),h=p(e,"P",{}),ue(h).forEach(n),c=l(e),m(_.$$.fragment,e),i=l(e),m(T.$$.fragment,e),ye=l(e),D=p(e,"P",{"data-svelte-h":!0}),b(D)!=="svelte-sr5hsf"&&(D.innerHTML=st),be=l(e),m(C.$$.fragment,e),we=l(e),E=p(e,"P",{"data-svelte-h":!0}),b(E)!=="svelte-vfdo9a"&&(E.textContent=at),_e=l(e),F=p(e,"P",{"data-svelte-h":!0}),b(F)!=="svelte-fbevff"&&(F.innerHTML=ot),Me=l(e),U=p(e,"IMG",{src:!0,alt:!0,width:!0}),Te=l(e),z=p(e,"SMALL",{"data-svelte-h":!0}),b(z)!=="svelte-1ldczql"&&(z.innerHTML=it),je=l(e),H=p(e,"P",{"data-svelte-h":!0}),b(H)!=="svelte-1a1ahjb"&&(H.innerHTML=rt),Je=l(e),m(V.$$.fragment,e),ve=l(e),X=p(e,"P",{"data-svelte-h":!0}),b(X)!=="svelte-1ffao6h"&&(X.innerHTML=pt),$e=l(e),m(N.$$.fragment,e),Be=l(e),Y=p(e,"P",{"data-svelte-h":!0}),b(Y)!=="svelte-1yjxirq"&&(Y.textContent=ht),ke=l(e),m(L.$$.fragment,e),We=l(e),m(P.$$.fragment,e),Ze=l(e),S=p(e,"P",{"data-svelte-h":!0}),b(S)!=="svelte-eza9ob"&&(S.textContent=ct),Ce=l(e),m(q.$$.fragment,e),Ue=l(e),m(Q.$$.fragment,e),Ge=l(e),K=p(e,"P",{"data-svelte-h":!0}),b(K)!=="svelte-msamn6"&&(K.textContent=dt),Ie=l(e),O=p(e,"UL",{"data-svelte-h":!0}),b(O)!=="svelte-gkv1qe"&&(O.innerHTML=mt),Ae=l(e),ee=p(e,"P",{"data-svelte-h":!0}),b(ee)!=="svelte-1xesile"&&(ee.textContent=gt),Re=l(e),m(te.$$.fragment,e),xe=l(e),j=p(e,"DIV",{class:!0});var v=ue(j);m(ne.$$.fragment,v),Ye=l(v),pe=p(v,"P",{"data-svelte-h":!0}),b(pe)!=="svelte-30ivap"&&(pe.innerHTML=ut),Le=l(v),he=p(v,"P",{"data-svelte-h":!0}),b(he)!=="svelte-o55m63"&&(he.innerHTML=ft),Pe=l(v),m(G.$$.fragment,v),Se=l(v),I=p(v,"DIV",{class:!0});var re=ue(I);m(se.$$.fragment,re),qe=l(re),ce=p(re,"P",{"data-svelte-h":!0}),b(ce)!=="svelte-f91b28"&&(ce.innerHTML=yt),re.forEach(n),v.forEach(n),De=l(e),m(ae.$$.fragment,e),Ee=l(e),J=p(e,"DIV",{class:!0});var B=ue(J);m(oe.$$.fragment,B),Qe=l(B),de=p(B,"P",{"data-svelte-h":!0}),b(de)!=="svelte-1lyww6q"&&(de.textContent=bt),Ke=l(B),me=p(B,"P",{"data-svelte-h":!0}),b(me)!=="svelte-1gjh92c"&&(me.innerHTML=wt),Oe=l(B),$=p(B,"DIV",{class:!0});var k=ue($);m(le.$$.fragment,k),et=l(k),ge=p(k,"P",{"data-svelte-h":!0}),b(ge)!=="svelte-tvw6fn"&&(ge.innerHTML=_t),tt=l(k),m(A.$$.fragment,k),nt=l(k),m(R.$$.fragment,k),k.forEach(n),B.forEach(n),Fe=l(e),m(ie.$$.fragment,e),ze=l(e),fe=p(e,"P",{}),ue(fe).forEach(n),this.h()},h(){Z(a,"name","hf:doc:metadata"),Z(a,"content",At),Jt(U.src,lt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/depth_anything_overview.jpg")||Z(U,"src",lt),Z(U,"alt","drawing"),Z(U,"width","600"),Z(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){w(document.head,a),s(e,M,t),s(e,h,t),s(e,c,t),g(_,e,t),s(e,i,t),g(T,e,t),s(e,ye,t),s(e,D,t),s(e,be,t),g(C,e,t),s(e,we,t),s(e,E,t),s(e,_e,t),s(e,F,t),s(e,Me,t),s(e,U,t),s(e,Te,t),s(e,z,t),s(e,je,t),s(e,H,t),s(e,Je,t),g(V,e,t),s(e,ve,t),s(e,X,t),s(e,$e,t),g(N,e,t),s(e,Be,t),s(e,Y,t),s(e,ke,t),g(L,e,t),s(e,We,t),g(P,e,t),s(e,Ze,t),s(e,S,t),s(e,Ce,t),g(q,e,t),s(e,Ue,t),g(Q,e,t),s(e,Ge,t),s(e,K,t),s(e,Ie,t),s(e,O,t),s(e,Ae,t),s(e,ee,t),s(e,Re,t),g(te,e,t),s(e,xe,t),s(e,j,t),g(ne,j,null),w(j,Ye),w(j,pe),w(j,Le),w(j,he),w(j,Pe),g(G,j,null),w(j,Se),w(j,I),g(se,I,null),w(I,qe),w(I,ce),s(e,De,t),g(ae,e,t),s(e,Ee,t),s(e,J,t),g(oe,J,null),w(J,Qe),w(J,de),w(J,Ke),w(J,me),w(J,Oe),w(J,$),g(le,$,null),w($,et),w($,ge),w($,tt),g(A,$,null),w($,nt),g(R,$,null),s(e,Fe,t),g(ie,e,t),s(e,ze,t),s(e,fe,t),He=!0},p(e,[t]){const v={};t&2&&(v.$$scope={dirty:t,ctx:e}),C.$set(v);const re={};t&2&&(re.$$scope={dirty:t,ctx:e}),G.$set(re);const B={};t&2&&(B.$$scope={dirty:t,ctx:e}),A.$set(B);const k={};t&2&&(k.$$scope={dirty:t,ctx:e}),R.$set(k)},i(e){He||(u(_.$$.fragment,e),u(T.$$.fragment,e),u(C.$$.fragment,e),u(V.$$.fragment,e),u(N.$$.fragment,e),u(L.$$.fragment,e),u(P.$$.fragment,e),u(q.$$.fragment,e),u(Q.$$.fragment,e),u(te.$$.fragment,e),u(ne.$$.fragment,e),u(G.$$.fragment,e),u(se.$$.fragment,e),u(ae.$$.fragment,e),u(oe.$$.fragment,e),u(le.$$.fragment,e),u(A.$$.fragment,e),u(R.$$.fragment,e),u(ie.$$.fragment,e),He=!0)},o(e){f(_.$$.fragment,e),f(T.$$.fragment,e),f(C.$$.fragment,e),f(V.$$.fragment,e),f(N.$$.fragment,e),f(L.$$.fragment,e),f(P.$$.fragment,e),f(q.$$.fragment,e),f(Q.$$.fragment,e),f(te.$$.fragment,e),f(ne.$$.fragment,e),f(G.$$.fragment,e),f(se.$$.fragment,e),f(ae.$$.fragment,e),f(oe.$$.fragment,e),f(le.$$.fragment,e),f(A.$$.fragment,e),f(R.$$.fragment,e),f(ie.$$.fragment,e),He=!1},d(e){e&&(n(M),n(h),n(c),n(i),n(ye),n(D),n(be),n(we),n(E),n(_e),n(F),n(Me),n(U),n(Te),n(z),n(je),n(H),n(Je),n(ve),n(X),n($e),n(Be),n(Y),n(ke),n(We),n(Ze),n(S),n(Ce),n(Ue),n(Ge),n(K),n(Ie),n(O),n(Ae),n(ee),n(Re),n(xe),n(j),n(De),n(Ee),n(J),n(Fe),n(ze),n(fe)),n(a),y(_,e),y(T,e),y(C,e),y(V,e),y(N,e),y(L,e),y(P,e),y(q,e),y(Q,e),y(te,e),y(ne),y(G),y(se),y(ae,e),y(oe),y(le),y(A),y(R),y(ie,e)}}}const At='{"title":"Depth Anything","local":"depth-anything","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"Pipeline API","local":"pipeline-api","sections":[],"depth":3},{"title":"Using the model yourself","local":"using-the-model-yourself","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"DepthAnythingConfig","local":"transformers.DepthAnythingConfig","sections":[],"depth":2},{"title":"DepthAnythingForDepthEstimation","local":"transformers.DepthAnythingForDepthEstimation","sections":[],"depth":2}],"depth":1}';function Rt(W){return vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xt extends $t{constructor(a){super(),Bt(this,a,Rt,It,jt,{})}}export{Xt as component};
