import{s as Us,f as Is,o as xs,n as ft}from"../chunks/scheduler.25b97de1.js";import{S as zs,i as Js,g as r,s as n,r as m,A as Rs,h as i,f as o,c as a,j as I,u as h,x as p,k as M,y as c,a as s,v as g,d as f,t as u,w as _}from"../chunks/index.d9030fc9.js";import{T as Cs}from"../chunks/Tip.baa67368.js";import{D as W}from"../chunks/Docstring.ffac8efa.js";import{C as O}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Eo}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as z,E as Fs}from"../chunks/EditOnGithub.91d95064.js";function Zs(C){let l,v="Example:",b,y,w;return y=new O({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlcHRoUHJvQ29uZmlnJTJDJTIwRGVwdGhQcm9Nb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBEZXB0aFBybyUyMGFwcGxlJTJGRGVwdGhQcm8lMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwRGVwdGhQcm9Db25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwYXBwbGUlMkZEZXB0aFBybyUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwRGVwdGhQcm9Nb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DepthProConfig, DepthProModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a DepthPro apple/DepthPro style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = DepthProConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the apple/DepthPro style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DepthProModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){l=r("p"),l.textContent=v,b=n(),m(y.$$.fragment)},l(d){l=i(d,"P",{"data-svelte-h":!0}),p(l)!=="svelte-11lpom8"&&(l.textContent=v),b=a(d),h(y.$$.fragment,d)},m(d,T){s(d,l,T),s(d,b,T),g(y,d,T),w=!0},p:ft,i(d){w||(f(y.$$.fragment,d),w=!0)},o(d){u(y.$$.fragment,d),w=!1},d(d){d&&(o(l),o(b)),_(y,d)}}}function Ws(C){let l,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=r("p"),l.innerHTML=v},l(b){l=i(b,"P",{"data-svelte-h":!0}),p(l)!=="svelte-fincs2"&&(l.innerHTML=v)},m(b,y){s(b,l,y)},p:ft,d(b){b&&o(l)}}}function Bs(C){let l,v="Examples:",b,y,w;return y=new O({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvUHJvY2Vzc29yJTJDJTIwRGVwdGhQcm9Nb2RlbCUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGd3d3LmlsYW5rZWxtYW4ub3JnJTJGc3RvcHNpZ25zJTJGYXVzdHJhbGlhLmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJhcHBsZSUyRkRlcHRoUHJvLWhmJTIyJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFtb2RlbCUyMCUzRCUyMERlcHRoUHJvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGltYWdlJTIwZm9yJTIwdGhlJTIwbW9kZWwlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXQlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFvdXRwdXQubGFzdF9oaWRkZW5fc3RhdGUuc2hhcGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, DepthProModel

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://www.ilankelman.org/stopsigns/australia.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;apple/DepthPro-hf&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DepthProModel.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    output = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>output.last_hidden_state.shape
torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">35</span>, <span class="hljs-number">577</span>, <span class="hljs-number">1024</span>])`,wrap:!1}}),{c(){l=r("p"),l.textContent=v,b=n(),m(y.$$.fragment)},l(d){l=i(d,"P",{"data-svelte-h":!0}),p(l)!=="svelte-kvfsh7"&&(l.textContent=v),b=a(d),h(y.$$.fragment,d)},m(d,T){s(d,l,T),s(d,b,T),g(y,d,T),w=!0},p:ft,i(d){w||(f(y.$$.fragment,d),w=!0)},o(d){u(y.$$.fragment,d),w=!1},d(d){d&&(o(l),o(b)),_(y,d)}}}function ks(C){let l,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=r("p"),l.innerHTML=v},l(b){l=i(b,"P",{"data-svelte-h":!0}),p(l)!=="svelte-fincs2"&&(l.innerHTML=v)},m(b,y){s(b,l,y)},p:ft,d(b){b&&o(l)}}}function Es(C){let l,v="Examples:",b,y,w;return y=new O({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, DepthProForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;apple/DepthPro-hf&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoImageProcessor.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DepthProForDepthEstimation.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># interpolate to original size</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>post_processed_output = processor.post_process_depth_estimation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[(image.height, image.width)],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># get the field of view (fov) predictions</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>field_of_view = post_processed_output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;field_of_view&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>focal_length = post_processed_output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;focal_length&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># visualize the prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_depth = post_processed_output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;predicted_depth&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = predicted_depth * <span class="hljs-number">255</span> / predicted_depth.<span class="hljs-built_in">max</span>()
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = depth.detach().cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(depth.astype(<span class="hljs-string">&quot;uint8&quot;</span>))`,wrap:!1}}),{c(){l=r("p"),l.textContent=v,b=n(),m(y.$$.fragment)},l(d){l=i(d,"P",{"data-svelte-h":!0}),p(l)!=="svelte-kvfsh7"&&(l.textContent=v),b=a(d),h(y.$$.fragment,d)},m(d,T){s(d,l,T),s(d,b,T),g(y,d,T),w=!0},p:ft,i(d){w||(f(y.$$.fragment,d),w=!0)},o(d){u(y.$$.fragment,d),w=!1},d(d){d&&(o(l),o(b)),_(y,d)}}}function Hs(C){let l,v,b,y,w,d,T,ut,K,Ho='The DepthPro model was proposed in <a href="https://arxiv.org/abs/2410.02073" rel="nofollow">Depth Pro: Sharp Monocular Metric Depth in Less Than a Second</a> by Aleksei Bochkovskii, Amaël Delaunoy, Hugo Germain, Marcel Santos, Yichao Zhou, Stephan R. Richter, Vladlen Koltun.',_t,ee,Go="DepthPro is a foundation model for zero-shot metric monocular depth estimation, designed to generate high-resolution depth maps with remarkable sharpness and fine-grained details. It employs a multi-scale Vision Transformer (ViT)-based architecture, where images are downsampled, divided into patches, and processed using a shared Dinov2 encoder. The extracted patch-level features are merged, upsampled, and refined using a DPT-like fusion stage, enabling precise depth estimation.",bt,te,No="The abstract from the paper is the following:",yt,oe,Vo="<em>We present a foundation model for zero-shot metric monocular depth estimation. Our model, Depth Pro, synthesizes high-resolution depth maps with unparalleled sharpness and high-frequency details. The predictions are metric, with absolute scale, without relying on the availability of metadata such as camera intrinsics. And the model is fast, producing a 2.25-megapixel depth map in 0.3 seconds on a standard GPU. These characteristics are enabled by a number of technical contributions, including an efficient multi-scale vision transformer for dense prediction, a training protocol that combines real and synthetic datasets to achieve high metric accuracy alongside fine boundary tracing, dedicated evaluation metrics for boundary accuracy in estimated depth maps, and state-of-the-art focal length estimation from a single image. Extensive experiments analyze specific design choices and demonstrate that Depth Pro outperforms prior work along multiple dimensions.</em>",wt,B,Lo,vt,se,So='DepthPro Outputs. Taken from the <a href="https://github.com/apple/ml-depth-pro" target="_blank">official code</a>.',Tt,ne,Xo='This model was contributed by <a href="https://github.com/geetu040" rel="nofollow">geetu040</a>. The original code can be found <a href="https://github.com/apple/ml-depth-pro" rel="nofollow">here</a>.',Mt,ae,Pt,re,qo="The DepthPro model processes an input image by first downsampling it at multiple scales and splitting each scaled version into patches. These patches are then encoded using a shared Vision Transformer (ViT)-based Dinov2 patch encoder, while the full image is processed by a separate image encoder. The extracted patch features are merged into feature maps, upsampled, and fused using a DPT-like decoder to generate the final depth estimation. If enabled, an additional Field of View (FOV) encoder processes the image for estimating the camera’s field of view, aiding in depth accuracy.",Dt,ie,$t,le,jt,k,Qo,It,de,Ao='DepthPro architecture. Taken from the <a href="https://arxiv.org/abs/2410.02073" target="_blank">original paper</a>.',Ct,ce,Yo="The <code>DepthProForDepthEstimation</code> model uses a <code>DepthProEncoder</code>, for encoding the input image and a <code>FeatureFusionStage</code> for fusing the output features from encoder.",Ut,pe,Oo="The <code>DepthProEncoder</code> further uses two encoders:",xt,me,Ko="<li><code>patch_encoder</code><ul><li>Input image is scaled with multiple ratios, as specified in the <code>scaled_images_ratios</code> configuration.</li> <li>Each scaled image is split into smaller <strong>patches</strong> of size <code>patch_size</code> with overlapping areas determined by <code>scaled_images_overlap_ratios</code>.</li> <li>These patches are processed by the <strong><code>patch_encoder</code></strong></li></ul></li> <li><code>image_encoder</code><ul><li>Input image is also rescaled to <code>patch_size</code> and processed by the <strong><code>image_encoder</code></strong></li></ul></li>",zt,he,es="Both these encoders can be configured via <code>patch_model_config</code> and <code>image_model_config</code> respectively, both of which are seperate <code>Dinov2Model</code> by default.",Jt,ge,ts="Outputs from both encoders (<code>last_hidden_state</code>) and selected intermediate states (<code>hidden_states</code>) from <strong><code>patch_encoder</code></strong> are fused by a <code>DPT</code>-based <code>FeatureFusionStage</code> for depth estimation.",Rt,fe,Ft,ue,os="The network is supplemented with a focal length estimation head. A small convolutional head ingests frozen features from the depth estimation network and task-specific features from a separate ViT image encoder to predict the horizontal angular field-of-view.",Zt,_e,ss="The <code>use_fov_model</code> parameter in <code>DepthProConfig</code> controls whether <strong>FOV prediction</strong> is enabled. By default, it is set to <code>False</code> to conserve memory and computation. When enabled, the <strong>FOV encoder</strong> is instantiated based on the <code>fov_model_config</code> parameter, which defaults to a <code>Dinov2Model</code>. The <code>use_fov_model</code> parameter can also be passed when initializing the <code>DepthProForDepthEstimation</code> model.",Wt,be,ns="The pretrained model at checkpoint <code>apple/DepthPro-hf</code> uses the FOV encoder. To use the pretrained-model without FOV encoder, set <code>use_fov_model=False</code> when loading the model, which saves computation.",Bt,ye,kt,we,as="To instantiate a new model with FOV encoder, set <code>use_fov_model=True</code> in the config.",Et,ve,Ht,Te,rs="Or set <code>use_fov_model=True</code> when initializing the model, which overrides the value in config.",Gt,Me,Nt,Pe,Vt,De,is=`PyTorch includes a native scaled dot-product attention (SDPA) operator as part of <code>torch.nn.functional</code>. This function
encompasses several implementations that can be applied depending on the inputs and the hardware in use. See the
<a href="https://pytorch.org/docs/stable/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">official documentation</a>
or the <a href="https://huggingface.co/docs/transformers/main/en/perf_infer_gpu_one#pytorch-scaled-dot-product-attention" rel="nofollow">GPU Inference</a>
page for more information.`,Lt,$e,ls=`SDPA is used by default for <code>torch&gt;=2.1.1</code> when an implementation is available, but you may also set
<code>attn_implementation=&quot;sdpa&quot;</code> in <code>from_pretrained()</code> to explicitly request SDPA to be used.`,St,je,Xt,Ie,ds="For the best speedups, we recommend loading the model in half-precision (e.g. <code>torch.float16</code> or <code>torch.bfloat16</code>).",qt,Ce,cs="On a local benchmark (A100-40GB, PyTorch 2.3.0, OS Ubuntu 22.04) with <code>float32</code> and <code>google/vit-base-patch16-224</code> model, we saw the following speedups during inference.",Qt,Ue,ps="<thead><tr><th>Batch size</th> <th>Average inference time (ms), eager mode</th> <th>Average inference time (ms), sdpa model</th> <th>Speed up, Sdpa / Eager (x)</th></tr></thead> <tbody><tr><td>1</td> <td>7</td> <td>6</td> <td>1.17</td></tr> <tr><td>2</td> <td>8</td> <td>6</td> <td>1.33</td></tr> <tr><td>4</td> <td>8</td> <td>6</td> <td>1.33</td></tr> <tr><td>8</td> <td>8</td> <td>6</td> <td>1.33</td></tr></tbody>",At,xe,Yt,ze,ms="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with DepthPro:",Ot,Je,hs='<li>Research Paper: <a href="https://arxiv.org/pdf/2410.02073" rel="nofollow">Depth Pro: Sharp Monocular Metric Depth in Less Than a Second</a></li> <li>Official Implementation: <a href="https://github.com/apple/ml-depth-pro" rel="nofollow">apple/ml-depth-pro</a></li> <li>DepthPro Inference Notebook: <a href="https://github.com/qubvel/transformers-notebooks/blob/main/notebooks/DepthPro_inference.ipynb" rel="nofollow">DepthPro Inference</a></li> <li>DepthPro for Super Resolution and Image Segmentation<ul><li>Read blog on Medium: <a href="https://medium.com/@raoarmaghanshakir040/depth-pro-beyond-depth-9d822fc557ba" rel="nofollow">Depth Pro: Beyond Depth</a></li> <li>Code on Github: <a href="https://github.com/geetu040/depthpro-beyond-depth" rel="nofollow">geetu040/depthpro-beyond-depth</a></li></ul></li>',Kt,Re,gs="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",eo,Fe,to,P,Ze,uo,et,fs=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/depth_pro#transformers.DepthProModel">DepthProModel</a>. It is used to instantiate a
DepthPro model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the DepthPro
<a href="https://huggingface.co/apple/DepthPro" rel="nofollow">apple/DepthPro</a> architecture.`,_o,tt,us=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,bo,E,oo,We,so,D,Be,yo,ot,_s="Constructs a DepthPro image processor.",wo,H,ke,vo,st,bs="Preprocess an image or batch of images.",To,G,Ee,Mo,nt,ys=`Post-processes the raw depth predictions from the model to generate
final depth predictions which is caliberated using the field of view if provided
and resized to specified target sizes if provided.`,no,He,ao,$,Ge,Po,at,ws="Constructs a fast DepthPro image processor.",Do,N,Ne,$o,rt,vs="Preprocess an image or batch of images.",jo,V,Ve,Io,it,Ts=`Post-processes the raw depth predictions from the model to generate
final depth predictions which is caliberated using the field of view if provided
and resized to specified target sizes if provided.`,ro,Le,io,J,Se,Co,lt,Ms=`The bare DepthPro Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Uo,U,Xe,xo,dt,Ps='The <a href="/docs/transformers/main/en/model_doc/depth_pro#transformers.DepthProModel">DepthProModel</a> forward method, overrides the <code>__call__</code> special method.',zo,L,Jo,S,lo,qe,co,j,Qe,Ro,ct,Ds="DepthPro Model with a depth estimation head on top (consisting of 3 convolutional layers).",Fo,pt,$s=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Zo,x,Ae,Wo,mt,js='The <a href="/docs/transformers/main/en/model_doc/depth_pro#transformers.DepthProForDepthEstimation">DepthProForDepthEstimation</a> forward method, overrides the <code>__call__</code> special method.',Bo,X,ko,q,po,Ye,mo,gt,ho;return w=new z({props:{title:"DepthPro",local:"depthpro",headingTag:"h1"}}),T=new z({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ae=new z({props:{title:"Usage Tips",local:"usage-tips",headingTag:"h2"}}),ie=new O({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBEZXB0aFByb0ltYWdlUHJvY2Vzc29yRmFzdCUyQyUyMERlcHRoUHJvRm9yRGVwdGhFc3RpbWF0aW9uJTBBJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElMjIlMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3B1JTIyKSUwQSUwQXVybCUyMCUzRCUyMCdodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJyUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMERlcHRoUHJvSW1hZ2VQcm9jZXNzb3JGYXN0LmZyb21fcHJldHJhaW5lZCglMjJhcHBsZSUyRkRlcHRoUHJvLWhmJTIyKSUwQW1vZGVsJTIwJTNEJTIwRGVwdGhQcm9Gb3JEZXB0aEVzdGltYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmFwcGxlJTJGRGVwdGhQcm8taGYlMjIpLnRvKGRldmljZSklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhkZXZpY2UpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFwb3N0X3Byb2Nlc3NlZF9vdXRwdXQlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IucG9zdF9wcm9jZXNzX2RlcHRoX2VzdGltYXRpb24oJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyQyUyMHRhcmdldF9zaXplcyUzRCU1QihpbWFnZS5oZWlnaHQlMkMlMjBpbWFnZS53aWR0aCklNUQlMkMlMEEpJTBBJTBBZmllbGRfb2ZfdmlldyUyMCUzRCUyMHBvc3RfcHJvY2Vzc2VkX291dHB1dCU1QjAlNUQlNUIlMjJmaWVsZF9vZl92aWV3JTIyJTVEJTBBZm9jYWxfbGVuZ3RoJTIwJTNEJTIwcG9zdF9wcm9jZXNzZWRfb3V0cHV0JTVCMCU1RCU1QiUyMmZvY2FsX2xlbmd0aCUyMiU1RCUwQWRlcHRoJTIwJTNEJTIwcG9zdF9wcm9jZXNzZWRfb3V0cHV0JTVCMCU1RCU1QiUyMnByZWRpY3RlZF9kZXB0aCUyMiU1RCUwQWRlcHRoJTIwJTNEJTIwKGRlcHRoJTIwLSUyMGRlcHRoLm1pbigpKSUyMCUyRiUyMGRlcHRoLm1heCgpJTBBZGVwdGglMjAlM0QlMjBkZXB0aCUyMColMjAyNTUuJTBBZGVwdGglMjAlM0QlMjBkZXB0aC5kZXRhY2goKS5jcHUoKS5udW1weSgpJTBBZGVwdGglMjAlM0QlMjBJbWFnZS5mcm9tYXJyYXkoZGVwdGguYXN0eXBlKCUyMnVpbnQ4JTIyKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DepthProImageProcessorFast, DepthProForDepthEstimation

<span class="hljs-meta">&gt;&gt;&gt; </span>device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&#x27;http://images.cocodataset.org/val2017/000000039769.jpg&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = DepthProImageProcessorFast.from_pretrained(<span class="hljs-string">&quot;apple/DepthPro-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DepthProForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;apple/DepthPro-hf&quot;</span>).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>post_processed_output = image_processor.post_process_depth_estimation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[(image.height, image.width)],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>field_of_view = post_processed_output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;field_of_view&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>focal_length = post_processed_output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;focal_length&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = post_processed_output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;predicted_depth&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = (depth - depth.<span class="hljs-built_in">min</span>()) / depth.<span class="hljs-built_in">max</span>()
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = depth * <span class="hljs-number">255.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = depth.detach().cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(depth.astype(<span class="hljs-string">&quot;uint8&quot;</span>))`,wrap:!1}}),le=new z({props:{title:"Architecture and Configuration",local:"architecture-and-configuration",headingTag:"h3"}}),fe=new z({props:{title:"Field-of-View (FOV) Prediction",local:"field-of-view-fov-prediction",headingTag:"h3"}}),ye=new O({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlcHRoUHJvRm9yRGVwdGhFc3RpbWF0aW9uJTBBbW9kZWwlMjAlM0QlMjBEZXB0aFByb0ZvckRlcHRoRXN0aW1hdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYXBwbGUlMkZEZXB0aFByby1oZiUyMiUyQyUyMHVzZV9mb3ZfbW9kZWwlM0RGYWxzZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DepthProForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DepthProForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;apple/DepthPro-hf&quot;</span>, use_fov_model=<span class="hljs-literal">False</span>)`,wrap:!1}}),ve=new O({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlcHRoUHJvQ29uZmlnJTJDJTIwRGVwdGhQcm9Gb3JEZXB0aEVzdGltYXRpb24lMEFjb25maWclMjAlM0QlMjBEZXB0aFByb0NvbmZpZyh1c2VfZm92X21vZGVsJTNEVHJ1ZSklMEFtb2RlbCUyMCUzRCUyMERlcHRoUHJvRm9yRGVwdGhFc3RpbWF0aW9uKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DepthProConfig, DepthProForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span>config = DepthProConfig(use_fov_model=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DepthProForDepthEstimation(config)`,wrap:!1}}),Me=new O({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlcHRoUHJvQ29uZmlnJTJDJTIwRGVwdGhQcm9Gb3JEZXB0aEVzdGltYXRpb24lMEFjb25maWclMjAlM0QlMjBEZXB0aFByb0NvbmZpZygpJTBBbW9kZWwlMjAlM0QlMjBEZXB0aFByb0ZvckRlcHRoRXN0aW1hdGlvbihjb25maWclMkMlMjB1c2VfZm92X21vZGVsJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DepthProConfig, DepthProForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span>config = DepthProConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DepthProForDepthEstimation(config, use_fov_model=<span class="hljs-literal">True</span>)`,wrap:!1}}),Pe=new z({props:{title:"Using Scaled Dot Product Attention (SDPA)",local:"using-scaled-dot-product-attention-sdpa",headingTag:"h3"}}),je=new O({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlcHRoUHJvRm9yRGVwdGhFc3RpbWF0aW9uJTBBbW9kZWwlMjAlM0QlMjBEZXB0aFByb0ZvckRlcHRoRXN0aW1hdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYXBwbGUlMkZEZXB0aFByby1oZiUyMiUyQyUyMGF0dG5faW1wbGVtZW50YXRpb24lM0QlMjJzZHBhJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DepthProForDepthEstimation
model = DepthProForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;apple/DepthPro-hf&quot;</span>, attn_implementation=<span class="hljs-string">&quot;sdpa&quot;</span>, torch_dtype=torch.float16)`,wrap:!1}}),xe=new z({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Fe=new z({props:{title:"DepthProConfig",local:"transformers.DepthProConfig",headingTag:"h2"}}),Ze=new W({props:{name:"class transformers.DepthProConfig",anchor:"transformers.DepthProConfig",parameters:[{name:"fusion_hidden_size",val:" = 256"},{name:"patch_size",val:" = 384"},{name:"initializer_range",val:" = 0.02"},{name:"intermediate_hook_ids",val:" = [11, 5]"},{name:"intermediate_feature_dims",val:" = [256, 256]"},{name:"scaled_images_ratios",val:" = [0.25, 0.5, 1]"},{name:"scaled_images_overlap_ratios",val:" = [0.0, 0.5, 0.25]"},{name:"scaled_images_feature_dims",val:" = [1024, 1024, 512]"},{name:"merge_padding_value",val:" = 3"},{name:"use_batch_norm_in_fusion_residual",val:" = False"},{name:"use_bias_in_fusion_residual",val:" = True"},{name:"use_fov_model",val:" = False"},{name:"num_fov_head_layers",val:" = 2"},{name:"image_model_config",val:" = None"},{name:"patch_model_config",val:" = None"},{name:"fov_model_config",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DepthProConfig.fusion_hidden_size",description:`<strong>fusion_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The number of channels before fusion.`,name:"fusion_hidden_size"},{anchor:"transformers.DepthProConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 384) &#x2014;
The size (resolution) of each patch. This is also the image_size for backbone model.`,name:"patch_size"},{anchor:"transformers.DepthProConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.DepthProConfig.intermediate_hook_ids",description:`<strong>intermediate_hook_ids</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[11, 5]</code>) &#x2014;
Indices of the intermediate hidden states from the patch encoder to use for fusion.`,name:"intermediate_hook_ids"},{anchor:"transformers.DepthProConfig.intermediate_feature_dims",description:`<strong>intermediate_feature_dims</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[256, 256]</code>) &#x2014;
Hidden state dimensions during upsampling for each intermediate hidden state in <code>intermediate_hook_ids</code>.`,name:"intermediate_feature_dims"},{anchor:"transformers.DepthProConfig.scaled_images_ratios",description:`<strong>scaled_images_ratios</strong> (<code>List[float]</code>, <em>optional</em>, defaults to <code>[0.25, 0.5, 1]</code>) &#x2014;
Ratios of scaled images to be used by the patch encoder.`,name:"scaled_images_ratios"},{anchor:"transformers.DepthProConfig.scaled_images_overlap_ratios",description:`<strong>scaled_images_overlap_ratios</strong> (<code>List[float]</code>, <em>optional</em>, defaults to <code>[0.0, 0.5, 0.25]</code>) &#x2014;
Overlap ratios between patches for each scaled image in <code>scaled_images_ratios</code>.`,name:"scaled_images_overlap_ratios"},{anchor:"transformers.DepthProConfig.scaled_images_feature_dims",description:`<strong>scaled_images_feature_dims</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[1024, 1024, 512]</code>) &#x2014;
Hidden state dimensions during upsampling for each scaled image in <code>scaled_images_ratios</code>.`,name:"scaled_images_feature_dims"},{anchor:"transformers.DepthProConfig.merge_padding_value",description:`<strong>merge_padding_value</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
When merging smaller patches back to the image size, overlapping sections of this size are removed.`,name:"merge_padding_value"},{anchor:"transformers.DepthProConfig.use_batch_norm_in_fusion_residual",description:`<strong>use_batch_norm_in_fusion_residual</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use batch normalization in the pre-activate residual units of the fusion blocks.`,name:"use_batch_norm_in_fusion_residual"},{anchor:"transformers.DepthProConfig.use_bias_in_fusion_residual",description:`<strong>use_bias_in_fusion_residual</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use bias in the pre-activate residual units of the fusion blocks.`,name:"use_bias_in_fusion_residual"},{anchor:"transformers.DepthProConfig.use_fov_model",description:`<strong>use_fov_model</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use <code>DepthProFovModel</code> to generate the field of view.`,name:"use_fov_model"},{anchor:"transformers.DepthProConfig.num_fov_head_layers",description:`<strong>num_fov_head_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Number of convolution layers in the head of <code>DepthProFovModel</code>.`,name:"num_fov_head_layers"},{anchor:"transformers.DepthProConfig.image_model_config",description:`<strong>image_model_config</strong> (<code>Union[Dict[str, Any], PretrainedConfig]</code>, <em>optional</em>) &#x2014;
The configuration of the image encoder model, which is loaded using the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoModel">AutoModel</a> API.
By default, Dinov2 model is used as backbone.`,name:"image_model_config"},{anchor:"transformers.DepthProConfig.patch_model_config",description:`<strong>patch_model_config</strong> (<code>Union[Dict[str, Any], PretrainedConfig]</code>, <em>optional</em>) &#x2014;
The configuration of the patch encoder model, which is loaded using the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoModel">AutoModel</a> API.
By default, Dinov2 model is used as backbone.`,name:"patch_model_config"},{anchor:"transformers.DepthProConfig.fov_model_config",description:`<strong>fov_model_config</strong> (<code>Union[Dict[str, Any], PretrainedConfig]</code>, <em>optional</em>) &#x2014;
The configuration of the fov encoder model, which is loaded using the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoModel">AutoModel</a> API.
By default, Dinov2 model is used as backbone.`,name:"fov_model_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_pro/configuration_depth_pro.py#L27"}}),E=new Eo({props:{anchor:"transformers.DepthProConfig.example",$$slots:{default:[Zs]},$$scope:{ctx:C}}}),We=new z({props:{title:"DepthProImageProcessor",local:"transformers.DepthProImageProcessor",headingTag:"h2"}}),Be=new W({props:{name:"class transformers.DepthProImageProcessor",anchor:"transformers.DepthProImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DepthProImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>(size[&quot;height&quot;], size[&quot;width&quot;])</code>. Can be overridden by the <code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.DepthProImageProcessor.size",description:`<strong>size</strong> (<code>dict</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 1536, &quot;width&quot;: 1536}</code>):
Size of the output image after resizing. Can be overridden by the <code>size</code> parameter in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.DepthProImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by the <code>resample</code> parameter in the
<code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.DepthProImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.DepthProImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter in the
<code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.DepthProImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.DepthProImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.DepthProImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_pro/image_processing_depth_pro.py#L56"}}),ke=new W({props:{name:"preprocess",anchor:"transformers.DepthProImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": typing.Optional[PIL.Image.Resampling] = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.DepthProImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.DepthProImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.DepthProImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Dictionary in the format <code>{&quot;height&quot;: h, &quot;width&quot;: w}</code> specifying the size of the output image after
resizing.`,name:"size"},{anchor:"transformers.DepthProImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code> filter, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
<code>PILImageResampling</code> filter to use if resizing the image e.g. <code>PILImageResampling.BILINEAR</code>. Only has
an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.DepthProImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.DepthProImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.DepthProImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.DepthProImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.DepthProImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_std"},{anchor:"transformers.DepthProImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.DepthProImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.DepthProImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_pro/image_processing_depth_pro.py#L191"}}),Ee=new W({props:{name:"post_process_depth_estimation",anchor:"transformers.DepthProImageProcessor.post_process_depth_estimation",parameters:[{name:"outputs",val:": DepthProDepthEstimatorOutput"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple[int, int]], NoneType] = None"}],parametersDescription:[{anchor:"transformers.DepthProImageProcessor.post_process_depth_estimation.outputs",description:`<strong>outputs</strong> (<code>DepthProDepthEstimatorOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.DepthProImageProcessor.post_process_depth_estimation.target_sizes",description:`<strong>target_sizes</strong> (<code>Optional[Union[TensorType, List[Tuple[int, int]], None]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Target sizes to resize the depth predictions. Can be a tensor of shape <code>(batch_size, 2)</code>
or a list of tuples <code>(height, width)</code> for each image in the batch. If <code>None</code>, no resizing
is performed.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_pro/image_processing_depth_pro.py#L317",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries of tensors representing the processed depth
predictions, and field of view (degrees) and focal length (pixels) if <code>field_of_view</code> is given in <code>outputs</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict[str, TensorType]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> —
If the lengths of <code>predicted_depths</code>, <code>fovs</code>, or <code>target_sizes</code> are mismatched.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),He=new z({props:{title:"DepthProImageProcessorFast",local:"transformers.DepthProImageProcessorFast",headingTag:"h2"}}),Ge=new W({props:{name:"class transformers.DepthProImageProcessorFast",anchor:"transformers.DepthProImageProcessorFast",parameters:[{name:"**kwargs",val:": typing_extensions.Unpack[transformers.image_processing_utils_fast.DefaultFastImageProcessorInitKwargs]"}],parametersDescription:[{anchor:"transformers.DepthProImageProcessorFast.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by the
<code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.DepthProImageProcessorFast.size",description:`<strong>size</strong> (<code>dict</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the output image after resizing. Can be overridden by the <code>size</code> parameter in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.DepthProImageProcessorFast.default_to_square",description:`<strong>default_to_square</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.default_to_square</code>) &#x2014;
Whether to default to a square image when resizing, if size is an int.`,name:"default_to_square"},{anchor:"transformers.DepthProImageProcessorFast.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. Only has an effect if <code>do_resize</code> is set to <code>True</code>. Can be
overridden by the <code>resample</code> parameter in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.DepthProImageProcessorFast.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by <code>do_center_crop</code> in the
<code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.DepthProImageProcessorFast.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the output image after applying <code>center_crop</code>. Can be overridden by <code>crop_size</code> in the <code>preprocess</code>
method.`,name:"crop_size"},{anchor:"transformers.DepthProImageProcessorFast.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the
<code>do_rescale</code> parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.DepthProImageProcessorFast.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Scale factor to use if rescaling the image. Only has an effect if <code>do_rescale</code> is set to <code>True</code>. Can be
overridden by the <code>rescale_factor</code> parameter in the <code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.DepthProImageProcessorFast.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.DepthProImageProcessorFast.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method. Can be
overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.DepthProImageProcessorFast.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.DepthProImageProcessorFast.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_pro/image_processing_depth_pro_fast.py#L62"}}),Ne=new W({props:{name:"preprocess",anchor:"transformers.DepthProImageProcessorFast.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.image_processing_utils_fast.DefaultFastImageProcessorPreprocessKwargs]"}],parametersDescription:[{anchor:"transformers.DepthProImageProcessorFast.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Describes the maximum input dimensions to the model.`,name:"size"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code> or <code>InterpolationMode</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the output image after applying <code>center_crop</code>.`,name:"crop_size"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.return_tensors",description:"<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;\nReturns stacked tensors if set to `pt, otherwise returns a list of tensors.",name:"return_tensors"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.DepthProImageProcessorFast.preprocess.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/image_processing_utils_fast.py#L552"}}),Ve=new W({props:{name:"post_process_depth_estimation",anchor:"transformers.DepthProImageProcessorFast.post_process_depth_estimation",parameters:[{name:"outputs",val:": DepthProDepthEstimatorOutput"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple[int, int]], NoneType] = None"}],parametersDescription:[{anchor:"transformers.DepthProImageProcessorFast.post_process_depth_estimation.outputs",description:`<strong>outputs</strong> (<code>DepthProDepthEstimatorOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.DepthProImageProcessorFast.post_process_depth_estimation.target_sizes",description:`<strong>target_sizes</strong> (<code>Optional[Union[TensorType, List[Tuple[int, int]], None]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Target sizes to resize the depth predictions. Can be a tensor of shape <code>(batch_size, 2)</code>
or a list of tuples <code>(height, width)</code> for each image in the batch. If <code>None</code>, no resizing
is performed.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_pro/image_processing_depth_pro_fast.py#L115",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries of tensors representing the processed depth
predictions, and field of view (degrees) and focal length (pixels) if <code>field_of_view</code> is given in <code>outputs</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict[str, TensorType]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> —
If the lengths of <code>predicted_depths</code>, <code>fovs</code>, or <code>target_sizes</code> are mismatched.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),Le=new z({props:{title:"DepthProModel",local:"transformers.DepthProModel",headingTag:"h2"}}),Se=new W({props:{name:"class transformers.DepthProModel",anchor:"transformers.DepthProModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.DepthProModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/depth_pro#transformers.DepthProConfig">DepthProConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_pro/modeling_depth_pro.py#L715"}}),Xe=new W({props:{name:"forward",anchor:"transformers.DepthProModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.DepthProModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">DPTImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.DepthProModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.DepthProModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DepthProModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DepthProModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_pro/modeling_depth_pro.py#L731",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/depth_pro#transformers.DepthProConfig"
>DepthProConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),L=new Cs({props:{$$slots:{default:[Ws]},$$scope:{ctx:C}}}),S=new Eo({props:{anchor:"transformers.DepthProModel.forward.example",$$slots:{default:[Bs]},$$scope:{ctx:C}}}),qe=new z({props:{title:"DepthProForDepthEstimation",local:"transformers.DepthProForDepthEstimation",headingTag:"h2"}}),Qe=new W({props:{name:"class transformers.DepthProForDepthEstimation",anchor:"transformers.DepthProForDepthEstimation",parameters:[{name:"config",val:""},{name:"use_fov_model",val:" = None"}],parametersDescription:[{anchor:"transformers.DepthProForDepthEstimation.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/depth_pro#transformers.DepthProConfig">DepthProConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.DepthProForDepthEstimation.use_fov_model",description:`<strong>use_fov_model</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use <code>DepthProFovModel</code> to generate the field of view.`,name:"use_fov_model"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_pro/modeling_depth_pro.py#L1090"}}),Ae=new W({props:{name:"forward",anchor:"transformers.DepthProForDepthEstimation.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.DepthProForDepthEstimation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">DPTImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.DepthProForDepthEstimation.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.DepthProForDepthEstimation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DepthProForDepthEstimation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DepthProForDepthEstimation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.DepthProForDepthEstimation.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Ground truth depth estimation maps for computing the loss.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_pro/modeling_depth_pro.py#L1117",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.depth_pro.modeling_depth_pro.DepthProDepthEstimatorOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/depth_pro#transformers.DepthProConfig"
>DepthProConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>predicted_depth</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, height, width)</code>) — Predicted depth for each pixel.</p>
</li>
<li>
<p><strong>field_of_view</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>, returned when <code>use_fov_model</code> is provided) — Field of View Scaler.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, n_patches_per_batch, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer and the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, n_patches_per_batch, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.depth_pro.modeling_depth_pro.DepthProDepthEstimatorOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),X=new Cs({props:{$$slots:{default:[ks]},$$scope:{ctx:C}}}),q=new Eo({props:{anchor:"transformers.DepthProForDepthEstimation.forward.example",$$slots:{default:[Es]},$$scope:{ctx:C}}}),Ye=new Fs({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/depth_pro.md"}}),{c(){l=r("meta"),v=n(),b=r("p"),y=n(),m(w.$$.fragment),d=n(),m(T.$$.fragment),ut=n(),K=r("p"),K.innerHTML=Ho,_t=n(),ee=r("p"),ee.textContent=Go,bt=n(),te=r("p"),te.textContent=No,yt=n(),oe=r("p"),oe.innerHTML=Vo,wt=n(),B=r("img"),vt=n(),se=r("small"),se.innerHTML=So,Tt=n(),ne=r("p"),ne.innerHTML=Xo,Mt=n(),m(ae.$$.fragment),Pt=n(),re=r("p"),re.textContent=qo,Dt=n(),m(ie.$$.fragment),$t=n(),m(le.$$.fragment),jt=n(),k=r("img"),It=n(),de=r("small"),de.innerHTML=Ao,Ct=n(),ce=r("p"),ce.innerHTML=Yo,Ut=n(),pe=r("p"),pe.innerHTML=Oo,xt=n(),me=r("ul"),me.innerHTML=Ko,zt=n(),he=r("p"),he.innerHTML=es,Jt=n(),ge=r("p"),ge.innerHTML=ts,Rt=n(),m(fe.$$.fragment),Ft=n(),ue=r("p"),ue.textContent=os,Zt=n(),_e=r("p"),_e.innerHTML=ss,Wt=n(),be=r("p"),be.innerHTML=ns,Bt=n(),m(ye.$$.fragment),kt=n(),we=r("p"),we.innerHTML=as,Et=n(),m(ve.$$.fragment),Ht=n(),Te=r("p"),Te.innerHTML=rs,Gt=n(),m(Me.$$.fragment),Nt=n(),m(Pe.$$.fragment),Vt=n(),De=r("p"),De.innerHTML=is,Lt=n(),$e=r("p"),$e.innerHTML=ls,St=n(),m(je.$$.fragment),Xt=n(),Ie=r("p"),Ie.innerHTML=ds,qt=n(),Ce=r("p"),Ce.innerHTML=cs,Qt=n(),Ue=r("table"),Ue.innerHTML=ps,At=n(),m(xe.$$.fragment),Yt=n(),ze=r("p"),ze.textContent=ms,Ot=n(),Je=r("ul"),Je.innerHTML=hs,Kt=n(),Re=r("p"),Re.textContent=gs,eo=n(),m(Fe.$$.fragment),to=n(),P=r("div"),m(Ze.$$.fragment),uo=n(),et=r("p"),et.innerHTML=fs,_o=n(),tt=r("p"),tt.innerHTML=us,bo=n(),m(E.$$.fragment),oo=n(),m(We.$$.fragment),so=n(),D=r("div"),m(Be.$$.fragment),yo=n(),ot=r("p"),ot.textContent=_s,wo=n(),H=r("div"),m(ke.$$.fragment),vo=n(),st=r("p"),st.textContent=bs,To=n(),G=r("div"),m(Ee.$$.fragment),Mo=n(),nt=r("p"),nt.textContent=ys,no=n(),m(He.$$.fragment),ao=n(),$=r("div"),m(Ge.$$.fragment),Po=n(),at=r("p"),at.textContent=ws,Do=n(),N=r("div"),m(Ne.$$.fragment),$o=n(),rt=r("p"),rt.textContent=vs,jo=n(),V=r("div"),m(Ve.$$.fragment),Io=n(),it=r("p"),it.textContent=Ts,ro=n(),m(Le.$$.fragment),io=n(),J=r("div"),m(Se.$$.fragment),Co=n(),lt=r("p"),lt.innerHTML=Ms,Uo=n(),U=r("div"),m(Xe.$$.fragment),xo=n(),dt=r("p"),dt.innerHTML=Ps,zo=n(),m(L.$$.fragment),Jo=n(),m(S.$$.fragment),lo=n(),m(qe.$$.fragment),co=n(),j=r("div"),m(Qe.$$.fragment),Ro=n(),ct=r("p"),ct.textContent=Ds,Fo=n(),pt=r("p"),pt.innerHTML=$s,Zo=n(),x=r("div"),m(Ae.$$.fragment),Wo=n(),mt=r("p"),mt.innerHTML=js,Bo=n(),m(X.$$.fragment),ko=n(),m(q.$$.fragment),po=n(),m(Ye.$$.fragment),mo=n(),gt=r("p"),this.h()},l(e){const t=Rs("svelte-u9bgzb",document.head);l=i(t,"META",{name:!0,content:!0}),t.forEach(o),v=a(e),b=i(e,"P",{}),I(b).forEach(o),y=a(e),h(w.$$.fragment,e),d=a(e),h(T.$$.fragment,e),ut=a(e),K=i(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-17nz7v2"&&(K.innerHTML=Ho),_t=a(e),ee=i(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-iw0dw2"&&(ee.textContent=Go),bt=a(e),te=i(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-vfdo9a"&&(te.textContent=No),yt=a(e),oe=i(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1nlf61n"&&(oe.innerHTML=Vo),wt=a(e),B=i(e,"IMG",{src:!0,alt:!0,width:!0}),vt=a(e),se=i(e,"SMALL",{"data-svelte-h":!0}),p(se)!=="svelte-v29z6c"&&(se.innerHTML=So),Tt=a(e),ne=i(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-l2shq"&&(ne.innerHTML=Xo),Mt=a(e),h(ae.$$.fragment,e),Pt=a(e),re=i(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-186igip"&&(re.textContent=qo),Dt=a(e),h(ie.$$.fragment,e),$t=a(e),h(le.$$.fragment,e),jt=a(e),k=i(e,"IMG",{src:!0,alt:!0,width:!0}),It=a(e),de=i(e,"SMALL",{"data-svelte-h":!0}),p(de)!=="svelte-1ru2d7g"&&(de.innerHTML=Ao),Ct=a(e),ce=i(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-tuav9r"&&(ce.innerHTML=Yo),Ut=a(e),pe=i(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1j3kmo3"&&(pe.innerHTML=Oo),xt=a(e),me=i(e,"UL",{"data-svelte-h":!0}),p(me)!=="svelte-z5afbx"&&(me.innerHTML=Ko),zt=a(e),he=i(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-1tmhlgp"&&(he.innerHTML=es),Jt=a(e),ge=i(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-52bz7i"&&(ge.innerHTML=ts),Rt=a(e),h(fe.$$.fragment,e),Ft=a(e),ue=i(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1ndzez1"&&(ue.textContent=os),Zt=a(e),_e=i(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-g9cm15"&&(_e.innerHTML=ss),Wt=a(e),be=i(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-a9hyvq"&&(be.innerHTML=ns),Bt=a(e),h(ye.$$.fragment,e),kt=a(e),we=i(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1npevgz"&&(we.innerHTML=as),Et=a(e),h(ve.$$.fragment,e),Ht=a(e),Te=i(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-1becr2q"&&(Te.innerHTML=rs),Gt=a(e),h(Me.$$.fragment,e),Nt=a(e),h(Pe.$$.fragment,e),Vt=a(e),De=i(e,"P",{"data-svelte-h":!0}),p(De)!=="svelte-1cid2pe"&&(De.innerHTML=is),Lt=a(e),$e=i(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-1x11lxg"&&($e.innerHTML=ls),St=a(e),h(je.$$.fragment,e),Xt=a(e),Ie=i(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-djb2w0"&&(Ie.innerHTML=ds),qt=a(e),Ce=i(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-18g4o0h"&&(Ce.innerHTML=cs),Qt=a(e),Ue=i(e,"TABLE",{"data-svelte-h":!0}),p(Ue)!=="svelte-vyu660"&&(Ue.innerHTML=ps),At=a(e),h(xe.$$.fragment,e),Yt=a(e),ze=i(e,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-1ub7hfb"&&(ze.textContent=ms),Ot=a(e),Je=i(e,"UL",{"data-svelte-h":!0}),p(Je)!=="svelte-yhgtws"&&(Je.innerHTML=hs),Kt=a(e),Re=i(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-1xesile"&&(Re.textContent=gs),eo=a(e),h(Fe.$$.fragment,e),to=a(e),P=i(e,"DIV",{class:!0});var R=I(P);h(Ze.$$.fragment,R),uo=a(R),et=i(R,"P",{"data-svelte-h":!0}),p(et)!=="svelte-160h4tq"&&(et.innerHTML=fs),_o=a(R),tt=i(R,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-o55m63"&&(tt.innerHTML=us),bo=a(R),h(E.$$.fragment,R),R.forEach(o),oo=a(e),h(We.$$.fragment,e),so=a(e),D=i(e,"DIV",{class:!0});var F=I(D);h(Be.$$.fragment,F),yo=a(F),ot=i(F,"P",{"data-svelte-h":!0}),p(ot)!=="svelte-1s0ef1w"&&(ot.textContent=_s),wo=a(F),H=i(F,"DIV",{class:!0});var Oe=I(H);h(ke.$$.fragment,Oe),vo=a(Oe),st=i(Oe,"P",{"data-svelte-h":!0}),p(st)!=="svelte-1x3yxsa"&&(st.textContent=bs),Oe.forEach(o),To=a(F),G=i(F,"DIV",{class:!0});var Ke=I(G);h(Ee.$$.fragment,Ke),Mo=a(Ke),nt=i(Ke,"P",{"data-svelte-h":!0}),p(nt)!=="svelte-nc01ic"&&(nt.textContent=ys),Ke.forEach(o),F.forEach(o),no=a(e),h(He.$$.fragment,e),ao=a(e),$=i(e,"DIV",{class:!0});var Z=I($);h(Ge.$$.fragment,Z),Po=a(Z),at=i(Z,"P",{"data-svelte-h":!0}),p(at)!=="svelte-4bjcxg"&&(at.textContent=ws),Do=a(Z),N=i(Z,"DIV",{class:!0});var go=I(N);h(Ne.$$.fragment,go),$o=a(go),rt=i(go,"P",{"data-svelte-h":!0}),p(rt)!=="svelte-1x3yxsa"&&(rt.textContent=vs),go.forEach(o),jo=a(Z),V=i(Z,"DIV",{class:!0});var fo=I(V);h(Ve.$$.fragment,fo),Io=a(fo),it=i(fo,"P",{"data-svelte-h":!0}),p(it)!=="svelte-nc01ic"&&(it.textContent=Ts),fo.forEach(o),Z.forEach(o),ro=a(e),h(Le.$$.fragment,e),io=a(e),J=i(e,"DIV",{class:!0});var ht=I(J);h(Se.$$.fragment,ht),Co=a(ht),lt=i(ht,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-xejpql"&&(lt.innerHTML=Ms),Uo=a(ht),U=i(ht,"DIV",{class:!0});var Q=I(U);h(Xe.$$.fragment,Q),xo=a(Q),dt=i(Q,"P",{"data-svelte-h":!0}),p(dt)!=="svelte-y3si4a"&&(dt.innerHTML=Ps),zo=a(Q),h(L.$$.fragment,Q),Jo=a(Q),h(S.$$.fragment,Q),Q.forEach(o),ht.forEach(o),lo=a(e),h(qe.$$.fragment,e),co=a(e),j=i(e,"DIV",{class:!0});var A=I(j);h(Qe.$$.fragment,A),Ro=a(A),ct=i(A,"P",{"data-svelte-h":!0}),p(ct)!=="svelte-1nk4p0z"&&(ct.textContent=Ds),Fo=a(A),pt=i(A,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-1gjh92c"&&(pt.innerHTML=$s),Zo=a(A),x=i(A,"DIV",{class:!0});var Y=I(x);h(Ae.$$.fragment,Y),Wo=a(Y),mt=i(Y,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-1n6bje0"&&(mt.innerHTML=js),Bo=a(Y),h(X.$$.fragment,Y),ko=a(Y),h(q.$$.fragment,Y),Y.forEach(o),A.forEach(o),po=a(e),h(Ye.$$.fragment,e),mo=a(e),gt=i(e,"P",{}),I(gt).forEach(o),this.h()},h(){M(l,"name","hf:doc:metadata"),M(l,"content",Gs),Is(B.src,Lo="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/depth_pro_teaser.png")||M(B,"src",Lo),M(B,"alt","drawing"),M(B,"width","600"),Is(k.src,Qo="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/depth_pro_architecture.png")||M(k,"src",Qo),M(k,"alt","drawing"),M(k,"width","600"),M(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){c(document.head,l),s(e,v,t),s(e,b,t),s(e,y,t),g(w,e,t),s(e,d,t),g(T,e,t),s(e,ut,t),s(e,K,t),s(e,_t,t),s(e,ee,t),s(e,bt,t),s(e,te,t),s(e,yt,t),s(e,oe,t),s(e,wt,t),s(e,B,t),s(e,vt,t),s(e,se,t),s(e,Tt,t),s(e,ne,t),s(e,Mt,t),g(ae,e,t),s(e,Pt,t),s(e,re,t),s(e,Dt,t),g(ie,e,t),s(e,$t,t),g(le,e,t),s(e,jt,t),s(e,k,t),s(e,It,t),s(e,de,t),s(e,Ct,t),s(e,ce,t),s(e,Ut,t),s(e,pe,t),s(e,xt,t),s(e,me,t),s(e,zt,t),s(e,he,t),s(e,Jt,t),s(e,ge,t),s(e,Rt,t),g(fe,e,t),s(e,Ft,t),s(e,ue,t),s(e,Zt,t),s(e,_e,t),s(e,Wt,t),s(e,be,t),s(e,Bt,t),g(ye,e,t),s(e,kt,t),s(e,we,t),s(e,Et,t),g(ve,e,t),s(e,Ht,t),s(e,Te,t),s(e,Gt,t),g(Me,e,t),s(e,Nt,t),g(Pe,e,t),s(e,Vt,t),s(e,De,t),s(e,Lt,t),s(e,$e,t),s(e,St,t),g(je,e,t),s(e,Xt,t),s(e,Ie,t),s(e,qt,t),s(e,Ce,t),s(e,Qt,t),s(e,Ue,t),s(e,At,t),g(xe,e,t),s(e,Yt,t),s(e,ze,t),s(e,Ot,t),s(e,Je,t),s(e,Kt,t),s(e,Re,t),s(e,eo,t),g(Fe,e,t),s(e,to,t),s(e,P,t),g(Ze,P,null),c(P,uo),c(P,et),c(P,_o),c(P,tt),c(P,bo),g(E,P,null),s(e,oo,t),g(We,e,t),s(e,so,t),s(e,D,t),g(Be,D,null),c(D,yo),c(D,ot),c(D,wo),c(D,H),g(ke,H,null),c(H,vo),c(H,st),c(D,To),c(D,G),g(Ee,G,null),c(G,Mo),c(G,nt),s(e,no,t),g(He,e,t),s(e,ao,t),s(e,$,t),g(Ge,$,null),c($,Po),c($,at),c($,Do),c($,N),g(Ne,N,null),c(N,$o),c(N,rt),c($,jo),c($,V),g(Ve,V,null),c(V,Io),c(V,it),s(e,ro,t),g(Le,e,t),s(e,io,t),s(e,J,t),g(Se,J,null),c(J,Co),c(J,lt),c(J,Uo),c(J,U),g(Xe,U,null),c(U,xo),c(U,dt),c(U,zo),g(L,U,null),c(U,Jo),g(S,U,null),s(e,lo,t),g(qe,e,t),s(e,co,t),s(e,j,t),g(Qe,j,null),c(j,Ro),c(j,ct),c(j,Fo),c(j,pt),c(j,Zo),c(j,x),g(Ae,x,null),c(x,Wo),c(x,mt),c(x,Bo),g(X,x,null),c(x,ko),g(q,x,null),s(e,po,t),g(Ye,e,t),s(e,mo,t),s(e,gt,t),ho=!0},p(e,[t]){const R={};t&2&&(R.$$scope={dirty:t,ctx:e}),E.$set(R);const F={};t&2&&(F.$$scope={dirty:t,ctx:e}),L.$set(F);const Oe={};t&2&&(Oe.$$scope={dirty:t,ctx:e}),S.$set(Oe);const Ke={};t&2&&(Ke.$$scope={dirty:t,ctx:e}),X.$set(Ke);const Z={};t&2&&(Z.$$scope={dirty:t,ctx:e}),q.$set(Z)},i(e){ho||(f(w.$$.fragment,e),f(T.$$.fragment,e),f(ae.$$.fragment,e),f(ie.$$.fragment,e),f(le.$$.fragment,e),f(fe.$$.fragment,e),f(ye.$$.fragment,e),f(ve.$$.fragment,e),f(Me.$$.fragment,e),f(Pe.$$.fragment,e),f(je.$$.fragment,e),f(xe.$$.fragment,e),f(Fe.$$.fragment,e),f(Ze.$$.fragment,e),f(E.$$.fragment,e),f(We.$$.fragment,e),f(Be.$$.fragment,e),f(ke.$$.fragment,e),f(Ee.$$.fragment,e),f(He.$$.fragment,e),f(Ge.$$.fragment,e),f(Ne.$$.fragment,e),f(Ve.$$.fragment,e),f(Le.$$.fragment,e),f(Se.$$.fragment,e),f(Xe.$$.fragment,e),f(L.$$.fragment,e),f(S.$$.fragment,e),f(qe.$$.fragment,e),f(Qe.$$.fragment,e),f(Ae.$$.fragment,e),f(X.$$.fragment,e),f(q.$$.fragment,e),f(Ye.$$.fragment,e),ho=!0)},o(e){u(w.$$.fragment,e),u(T.$$.fragment,e),u(ae.$$.fragment,e),u(ie.$$.fragment,e),u(le.$$.fragment,e),u(fe.$$.fragment,e),u(ye.$$.fragment,e),u(ve.$$.fragment,e),u(Me.$$.fragment,e),u(Pe.$$.fragment,e),u(je.$$.fragment,e),u(xe.$$.fragment,e),u(Fe.$$.fragment,e),u(Ze.$$.fragment,e),u(E.$$.fragment,e),u(We.$$.fragment,e),u(Be.$$.fragment,e),u(ke.$$.fragment,e),u(Ee.$$.fragment,e),u(He.$$.fragment,e),u(Ge.$$.fragment,e),u(Ne.$$.fragment,e),u(Ve.$$.fragment,e),u(Le.$$.fragment,e),u(Se.$$.fragment,e),u(Xe.$$.fragment,e),u(L.$$.fragment,e),u(S.$$.fragment,e),u(qe.$$.fragment,e),u(Qe.$$.fragment,e),u(Ae.$$.fragment,e),u(X.$$.fragment,e),u(q.$$.fragment,e),u(Ye.$$.fragment,e),ho=!1},d(e){e&&(o(v),o(b),o(y),o(d),o(ut),o(K),o(_t),o(ee),o(bt),o(te),o(yt),o(oe),o(wt),o(B),o(vt),o(se),o(Tt),o(ne),o(Mt),o(Pt),o(re),o(Dt),o($t),o(jt),o(k),o(It),o(de),o(Ct),o(ce),o(Ut),o(pe),o(xt),o(me),o(zt),o(he),o(Jt),o(ge),o(Rt),o(Ft),o(ue),o(Zt),o(_e),o(Wt),o(be),o(Bt),o(kt),o(we),o(Et),o(Ht),o(Te),o(Gt),o(Nt),o(Vt),o(De),o(Lt),o($e),o(St),o(Xt),o(Ie),o(qt),o(Ce),o(Qt),o(Ue),o(At),o(Yt),o(ze),o(Ot),o(Je),o(Kt),o(Re),o(eo),o(to),o(P),o(oo),o(so),o(D),o(no),o(ao),o($),o(ro),o(io),o(J),o(lo),o(co),o(j),o(po),o(mo),o(gt)),o(l),_(w,e),_(T,e),_(ae,e),_(ie,e),_(le,e),_(fe,e),_(ye,e),_(ve,e),_(Me,e),_(Pe,e),_(je,e),_(xe,e),_(Fe,e),_(Ze),_(E),_(We,e),_(Be),_(ke),_(Ee),_(He,e),_(Ge),_(Ne),_(Ve),_(Le,e),_(Se),_(Xe),_(L),_(S),_(qe,e),_(Qe),_(Ae),_(X),_(q),_(Ye,e)}}}const Gs='{"title":"DepthPro","local":"depthpro","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage Tips","local":"usage-tips","sections":[{"title":"Architecture and Configuration","local":"architecture-and-configuration","sections":[],"depth":3},{"title":"Field-of-View (FOV) Prediction","local":"field-of-view-fov-prediction","sections":[],"depth":3},{"title":"Using Scaled Dot Product Attention (SDPA)","local":"using-scaled-dot-product-attention-sdpa","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"DepthProConfig","local":"transformers.DepthProConfig","sections":[],"depth":2},{"title":"DepthProImageProcessor","local":"transformers.DepthProImageProcessor","sections":[],"depth":2},{"title":"DepthProImageProcessorFast","local":"transformers.DepthProImageProcessorFast","sections":[],"depth":2},{"title":"DepthProModel","local":"transformers.DepthProModel","sections":[],"depth":2},{"title":"DepthProForDepthEstimation","local":"transformers.DepthProForDepthEstimation","sections":[],"depth":2}],"depth":1}';function Ns(C){return xs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ys extends zs{constructor(l){super(),Js(this,l,Ns,Hs,Us,{})}}export{Ys as component};
