import{s as gt,o as ht,n as ye}from"../chunks/scheduler.25b97de1.js";import{S as ut,i as _t,g as m,s as a,r as g,A as bt,h as f,f as s,c as r,j as W,u as h,x as w,k as F,y as d,a as i,v as u,d as _,t as b,w as y}from"../chunks/index.d9030fc9.js";import{T as pt}from"../chunks/Tip.baa67368.js";import{D as ie}from"../chunks/Docstring.ffac8efa.js";import{C as Ke}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Oe}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as _e,E as yt}from"../chunks/EditOnGithub.91d95064.js";function vt(E){let t,v="Example:",c,l,p;return l=new Ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEVmZmljaWVudE5ldENvbmZpZyUyQyUyMEVmZmljaWVudE5ldE1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMEVmZmljaWVudE5ldCUyMGVmZmljaWVudG5ldC1iNyUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBFZmZpY2llbnROZXRDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwZWZmaWNpZW50bmV0LWI3JTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBFZmZpY2llbnROZXRNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> EfficientNetConfig, EfficientNetModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a EfficientNet efficientnet-b7 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = EfficientNetConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the efficientnet-b7 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = EfficientNetModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=m("p"),t.textContent=v,c=a(),g(l.$$.fragment)},l(o){t=f(o,"P",{"data-svelte-h":!0}),w(t)!=="svelte-11lpom8"&&(t.textContent=v),c=r(o),h(l.$$.fragment,o)},m(o,N){i(o,t,N),i(o,c,N),u(l,o,N),p=!0},p:ye,i(o){p||(_(l.$$.fragment,o),p=!0)},o(o){b(l.$$.fragment,o),p=!1},d(o){o&&(s(t),s(c)),y(l,o)}}}function Nt(E){let t,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=v},l(c){t=f(c,"P",{"data-svelte-h":!0}),w(t)!=="svelte-fincs2"&&(t.innerHTML=v)},m(c,l){i(c,t,l)},p:ye,d(c){c&&s(t)}}}function wt(E){let t,v="Example:",c,l,p;return l=new Ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEVmZmljaWVudE5ldE1vZGVsJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmh1Z2dpbmdmYWNlJTJGY2F0cy1pbWFnZSUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSklMEFpbWFnZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCJTIyaW1hZ2UlMjIlNUQlNUIwJTVEJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZlZmZpY2llbnRuZXQtYjclMjIpJTBBbW9kZWwlMjAlM0QlMjBFZmZpY2llbnROZXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZWZmaWNpZW50bmV0LWI3JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRlJTBBbGlzdChsYXN0X2hpZGRlbl9zdGF0ZXMuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, EfficientNetModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/efficientnet-b7&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = EfficientNetModel.from_pretrained(<span class="hljs-string">&quot;google/efficientnet-b7&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">768</span>, <span class="hljs-number">7</span>, <span class="hljs-number">7</span>]`,wrap:!1}}),{c(){t=m("p"),t.textContent=v,c=a(),g(l.$$.fragment)},l(o){t=f(o,"P",{"data-svelte-h":!0}),w(t)!=="svelte-11lpom8"&&(t.textContent=v),c=r(o),h(l.$$.fragment,o)},m(o,N){i(o,t,N),i(o,c,N),u(l,o,N),p=!0},p:ye,i(o){p||(_(l.$$.fragment,o),p=!0)},o(o){b(l.$$.fragment,o),p=!1},d(o){o&&(s(t),s(c)),y(l,o)}}}function $t(E){let t,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=v},l(c){t=f(c,"P",{"data-svelte-h":!0}),w(t)!=="svelte-fincs2"&&(t.innerHTML=v)},m(c,l){i(c,t,l)},p:ye,d(c){c&&s(t)}}}function Mt(E){let t,v="Example:",c,l,p;return l=new Ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEVmZmljaWVudE5ldEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaHVnZ2luZ2ZhY2UlMkZjYXRzLWltYWdlJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUwQWltYWdlJTIwJTNEJTIwZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlNUIlMjJpbWFnZSUyMiU1RCU1QjAlNUQlMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmVmZmljaWVudG5ldC1iNyUyMiklMEFtb2RlbCUyMCUzRCUyMEVmZmljaWVudE5ldEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmVmZmljaWVudG5ldC1iNyUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBJTIzJTIwbW9kZWwlMjBwcmVkaWN0cyUyMG9uZSUyMG9mJTIwdGhlJTIwMTAwMCUyMEltYWdlTmV0JTIwY2xhc3NlcyUwQXByZWRpY3RlZF9sYWJlbCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByaW50KG1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnByZWRpY3RlZF9sYWJlbCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, EfficientNetForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/efficientnet-b7&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = EfficientNetForImageClassification.from_pretrained(<span class="hljs-string">&quot;google/efficientnet-b7&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
tabby, tabby cat`,wrap:!1}}),{c(){t=m("p"),t.textContent=v,c=a(),g(l.$$.fragment)},l(o){t=f(o,"P",{"data-svelte-h":!0}),w(t)!=="svelte-11lpom8"&&(t.textContent=v),c=r(o),h(l.$$.fragment,o)},m(o,N){i(o,t,N),i(o,c,N),u(l,o,N),p=!0},p:ye,i(o){p||(_(l.$$.fragment,o),p=!0)},o(o){b(l.$$.fragment,o),p=!1},d(o){o&&(s(t),s(c)),y(l,o)}}}function Et(E){let t,v,c,l,p,o,N,ve,G,et=`The EfficientNet model was proposed in <a href="https://arxiv.org/abs/1905.11946" rel="nofollow">EfficientNet: Rethinking Model Scaling for Convolutional Neural Networks</a>
by Mingxing Tan and Quoc V. Le. EfficientNets are a family of image classification models, which achieve state-of-the-art accuracy, yet being an order-of-magnitude smaller and faster than previous models.`,Ne,S,tt="The abstract from the paper is the following:",we,X,ot=`<em>Convolutional Neural Networks (ConvNets) are commonly developed at a fixed resource budget, and then scaled up for better accuracy if more resources are available. In this paper, we systematically study model scaling and identify that carefully balancing network depth, width, and resolution can lead to better performance. Based on this observation, we propose a new scaling method that uniformly scales all dimensions of depth/width/resolution using a simple yet highly effective compound coefficient. We demonstrate the effectiveness of this method on scaling up MobileNets and ResNet.
To go even further, we use neural architecture search to design a new baseline network and scale it up to obtain a family of models, called EfficientNets, which achieve much better accuracy and efficiency than previous ConvNets. In particular, our EfficientNet-B7 achieves state-of-the-art 84.3% top-1 accuracy on ImageNet, while being 8.4x smaller and 6.1x faster on inference than the best existing ConvNet. Our EfficientNets also transfer well and achieve state-of-the-art accuracy on CIFAR-100 (91.7%), Flowers (98.8%), and 3 other transfer learning datasets, with an order of magnitude fewer parameters.</em>`,$e,Q,nt=`This model was contributed by <a href="https://huggingface.co/adirik" rel="nofollow">adirik</a>.
The original code can be found <a href="https://github.com/tensorflow/tpu/tree/master/models/official/efficientnet" rel="nofollow">here</a>.`,Me,A,Ee,$,H,Fe,ce,st=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/efficientnet#transformers.EfficientNetModel">EfficientNetModel</a>. It is used to instantiate an
EfficientNet model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the EfficientNet
<a href="https://huggingface.co/google/efficientnet-b7" rel="nofollow">google/efficientnet-b7</a> architecture.`,Pe,le,at=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Re,P,Te,Y,Ce,x,D,ke,de,rt="Constructs a EfficientNet image processor.",Je,R,O,Le,me,it="Preprocess an image or batch of images.",xe,K,Ie,I,ee,Ve,fe,ct=`The bare EfficientNet model outputting raw features without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,qe,T,te,Be,pe,lt='The <a href="/docs/transformers/main/en/model_doc/efficientnet#transformers.EfficientNetModel">EfficientNetModel</a> forward method, overrides the <code>__call__</code> special method.',Ge,k,Se,J,je,oe,ze,M,ne,Xe,ge,dt=`EfficientNet Model with an image classification head on top (a linear layer on top of the pooled features), e.g.
for ImageNet.`,Qe,he,mt=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Ae,C,se,He,ue,ft='The <a href="/docs/transformers/main/en/model_doc/efficientnet#transformers.EfficientNetForImageClassification">EfficientNetForImageClassification</a> forward method, overrides the <code>__call__</code> special method.',Ye,L,De,V,Ze,ae,Ue,be,We;return p=new _e({props:{title:"EfficientNet",local:"efficientnet",headingTag:"h1"}}),N=new _e({props:{title:"Overview",local:"overview",headingTag:"h2"}}),A=new _e({props:{title:"EfficientNetConfig",local:"transformers.EfficientNetConfig",headingTag:"h2"}}),H=new ie({props:{name:"class transformers.EfficientNetConfig",anchor:"transformers.EfficientNetConfig",parameters:[{name:"num_channels",val:": int = 3"},{name:"image_size",val:": int = 600"},{name:"width_coefficient",val:": float = 2.0"},{name:"depth_coefficient",val:": float = 3.1"},{name:"depth_divisor",val:": int = 8"},{name:"kernel_sizes",val:": typing.List[int] = [3, 3, 5, 3, 5, 5, 3]"},{name:"in_channels",val:": typing.List[int] = [32, 16, 24, 40, 80, 112, 192]"},{name:"out_channels",val:": typing.List[int] = [16, 24, 40, 80, 112, 192, 320]"},{name:"depthwise_padding",val:": typing.List[int] = []"},{name:"strides",val:": typing.List[int] = [1, 2, 2, 2, 1, 2, 1]"},{name:"num_block_repeats",val:": typing.List[int] = [1, 2, 2, 3, 3, 4, 1]"},{name:"expand_ratios",val:": typing.List[int] = [1, 6, 6, 6, 6, 6, 6]"},{name:"squeeze_expansion_ratio",val:": float = 0.25"},{name:"hidden_act",val:": str = 'swish'"},{name:"hidden_dim",val:": int = 2560"},{name:"pooling_type",val:": str = 'mean'"},{name:"initializer_range",val:": float = 0.02"},{name:"batch_norm_eps",val:": float = 0.001"},{name:"batch_norm_momentum",val:": float = 0.99"},{name:"dropout_rate",val:": float = 0.5"},{name:"drop_connect_rate",val:": float = 0.2"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.EfficientNetConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.EfficientNetConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 600) &#x2014;
The input image size.`,name:"image_size"},{anchor:"transformers.EfficientNetConfig.width_coefficient",description:`<strong>width_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 2.0) &#x2014;
Scaling coefficient for network width at each stage.`,name:"width_coefficient"},{anchor:"transformers.EfficientNetConfig.depth_coefficient",description:`<strong>depth_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 3.1) &#x2014;
Scaling coefficient for network depth at each stage.`,name:"depth_coefficient"},{anchor:"transformers.EfficientNetConfig.depth_divisor",description:`<strong>depth_divisor</strong> <code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
A unit of network width.`,name:"depth_divisor"},{anchor:"transformers.EfficientNetConfig.kernel_sizes",description:`<strong>kernel_sizes</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[3, 3, 5, 3, 5, 5, 3]</code>) &#x2014;
List of kernel sizes to be used in each block.`,name:"kernel_sizes"},{anchor:"transformers.EfficientNetConfig.in_channels",description:`<strong>in_channels</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[32, 16, 24, 40, 80, 112, 192]</code>) &#x2014;
List of input channel sizes to be used in each block for convolutional layers.`,name:"in_channels"},{anchor:"transformers.EfficientNetConfig.out_channels",description:`<strong>out_channels</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[16, 24, 40, 80, 112, 192, 320]</code>) &#x2014;
List of output channel sizes to be used in each block for convolutional layers.`,name:"out_channels"},{anchor:"transformers.EfficientNetConfig.depthwise_padding",description:`<strong>depthwise_padding</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[]</code>) &#x2014;
List of block indices with square padding.`,name:"depthwise_padding"},{anchor:"transformers.EfficientNetConfig.strides",description:`<strong>strides</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[1, 2, 2, 2, 1, 2, 1]</code>) &#x2014;
List of stride sizes to be used in each block for convolutional layers.`,name:"strides"},{anchor:"transformers.EfficientNetConfig.num_block_repeats",description:`<strong>num_block_repeats</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[1, 2, 2, 3, 3, 4, 1]</code>) &#x2014;
List of the number of times each block is to repeated.`,name:"num_block_repeats"},{anchor:"transformers.EfficientNetConfig.expand_ratios",description:`<strong>expand_ratios</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[1, 6, 6, 6, 6, 6, 6]</code>) &#x2014;
List of scaling coefficient of each block.`,name:"expand_ratios"},{anchor:"transformers.EfficientNetConfig.squeeze_expansion_ratio",description:`<strong>squeeze_expansion_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 0.25) &#x2014;
Squeeze expansion ratio.`,name:"squeeze_expansion_ratio"},{anchor:"transformers.EfficientNetConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in each block. If string, <code>&quot;gelu&quot;</code>, <code>&quot;relu&quot;</code>,
<code>&quot;selu&quot;, </code>&#x201C;gelu_new&#x201D;<code>, </code>&#x201C;silu&#x201D;<code>and</code>&#x201C;mish&#x201D;\` are supported.`,name:"hidden_act"},{anchor:"transformers.EfficientNetConfig.hiddem_dim",description:`<strong>hiddem_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 1280) &#x2014;
The hidden dimension of the layer before the classification head.`,name:"hiddem_dim"},{anchor:"transformers.EfficientNetConfig.pooling_type",description:`<strong>pooling_type</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;mean&quot;</code>) &#x2014;
Type of final pooling to be applied before the dense classification head. Available options are [<code>&quot;mean&quot;</code>,
<code>&quot;max&quot;</code>]`,name:"pooling_type"},{anchor:"transformers.EfficientNetConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.EfficientNetConfig.batch_norm_eps",description:`<strong>batch_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-3) &#x2014;
The epsilon used by the batch normalization layers.`,name:"batch_norm_eps"},{anchor:"transformers.EfficientNetConfig.batch_norm_momentum",description:`<strong>batch_norm_momentum</strong> (<code>float</code>, <em>optional</em>, defaults to 0.99) &#x2014;
The momentum used by the batch normalization layers.`,name:"batch_norm_momentum"},{anchor:"transformers.EfficientNetConfig.dropout_rate",description:`<strong>dropout_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The dropout rate to be applied before final classifier layer.`,name:"dropout_rate"},{anchor:"transformers.EfficientNetConfig.drop_connect_rate",description:`<strong>drop_connect_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.2) &#x2014;
The drop rate for skip connections.`,name:"drop_connect_rate"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/efficientnet/configuration_efficientnet.py#L30"}}),P=new Oe({props:{anchor:"transformers.EfficientNetConfig.example",$$slots:{default:[vt]},$$scope:{ctx:E}}}),Y=new _e({props:{title:"EfficientNetImageProcessor",local:"transformers.EfficientNetImageProcessor",headingTag:"h2"}}),D=new ie({props:{name:"class transformers.EfficientNetImageProcessor",anchor:"transformers.EfficientNetImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = 0"},{name:"do_center_crop",val:": bool = False"},{name:"crop_size",val:": typing.Dict[str, int] = None"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"rescale_offset",val:": bool = False"},{name:"do_rescale",val:": bool = True"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"include_top",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.EfficientNetImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by
<code>do_resize</code> in <code>preprocess</code>.`,name:"do_resize"},{anchor:"transformers.EfficientNetImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 346, &quot;width&quot;: 346}</code>):
Size of the image after <code>resize</code>. Can be overridden by <code>size</code> in <code>preprocess</code>.`,name:"size"},{anchor:"transformers.EfficientNetImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code> filter, <em>optional</em>, defaults to 0) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in <code>preprocess</code>.`,name:"resample"},{anchor:"transformers.EfficientNetImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to center crop the image. If the input size is smaller than <code>crop_size</code> along any edge, the image
is padded with 0&#x2019;s and then center cropped. Can be overridden by <code>do_center_crop</code> in <code>preprocess</code>.`,name:"do_center_crop"},{anchor:"transformers.EfficientNetImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 289, &quot;width&quot;: 289}</code>):
Desired output size when applying center-cropping. Can be overridden by <code>crop_size</code> in <code>preprocess</code>.`,name:"crop_size"},{anchor:"transformers.EfficientNetImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter in the
<code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.EfficientNetImageProcessor.rescale_offset",description:`<strong>rescale_offset</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to rescale the image between [-scale_range, scale_range] instead of [0, scale_range]. Can be
overridden by the <code>rescale_factor</code> parameter in the <code>preprocess</code> method.`,name:"rescale_offset"},{anchor:"transformers.EfficientNetImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.EfficientNetImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.EfficientNetImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.EfficientNetImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.EfficientNetImageProcessor.include_top",description:`<strong>include_top</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image again. Should be set to True if the inputs are used for image classification.`,name:"include_top"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/efficientnet/image_processing_efficientnet.py#L46"}}),O=new ie({props:{name:"preprocess",anchor:"transformers.EfficientNetImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"do_resize",val:": bool = None"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:" = None"},{name:"do_center_crop",val:": bool = None"},{name:"crop_size",val:": typing.Dict[str, int] = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"rescale_offset",val:": bool = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"include_top",val:": bool = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.EfficientNetImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.EfficientNetImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.EfficientNetImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after <code>resize</code>.`,name:"size"},{anchor:"transformers.EfficientNetImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
PILImageResampling filter to use if resizing the image Only has an effect if <code>do_resize</code> is set to
<code>True</code>.`,name:"resample"},{anchor:"transformers.EfficientNetImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.EfficientNetImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the image after center crop. If one edge the image is smaller than <code>crop_size</code>, it will be
padded with zeros and then cropped`,name:"crop_size"},{anchor:"transformers.EfficientNetImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.EfficientNetImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.EfficientNetImageProcessor.preprocess.rescale_offset",description:`<strong>rescale_offset</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.rescale_offset</code>) &#x2014;
Whether to rescale the image between [-scale_range, scale_range] instead of [0, scale_range].`,name:"rescale_offset"},{anchor:"transformers.EfficientNetImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.EfficientNetImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean.`,name:"image_mean"},{anchor:"transformers.EfficientNetImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation.`,name:"image_std"},{anchor:"transformers.EfficientNetImageProcessor.preprocess.include_top",description:`<strong>include_top</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.include_top</code>) &#x2014;
Rescales the image again for image classification if set to True.`,name:"include_top"},{anchor:"transformers.EfficientNetImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li><code>None</code>: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.EfficientNetImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
</ul>`,name:"data_format"},{anchor:"transformers.EfficientNetImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/efficientnet/image_processing_efficientnet.py#L211"}}),K=new _e({props:{title:"EfficientNetModel",local:"transformers.EfficientNetModel",headingTag:"h2"}}),ee=new ie({props:{name:"class transformers.EfficientNetModel",anchor:"transformers.EfficientNetModel",parameters:[{name:"config",val:": EfficientNetConfig"}],parametersDescription:[{anchor:"transformers.EfficientNetModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/efficientnet#transformers.EfficientNetConfig">EfficientNetConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/efficientnet/modeling_efficientnet.py#L498"}}),te=new ie({props:{name:"forward",anchor:"transformers.EfficientNetModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.EfficientNetModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<code>AutoImageProcessor.__call__()</code> for details.`,name:"pixel_values"},{anchor:"transformers.EfficientNetModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.EfficientNetModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/efficientnet/modeling_efficientnet.py#L520",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.BaseModelOutputWithPoolingAndNoAttention</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/efficientnet#transformers.EfficientNetConfig"
>EfficientNetConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state after a pooling operation on the spatial dimensions.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, num_channels, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.BaseModelOutputWithPoolingAndNoAttention</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),k=new pt({props:{$$slots:{default:[Nt]},$$scope:{ctx:E}}}),J=new Oe({props:{anchor:"transformers.EfficientNetModel.forward.example",$$slots:{default:[wt]},$$scope:{ctx:E}}}),oe=new _e({props:{title:"EfficientNetForImageClassification",local:"transformers.EfficientNetForImageClassification",headingTag:"h2"}}),ne=new ie({props:{name:"class transformers.EfficientNetForImageClassification",anchor:"transformers.EfficientNetForImageClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.EfficientNetForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/efficientnet#transformers.EfficientNetConfig">EfficientNetConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/efficientnet/modeling_efficientnet.py#L565"}}),se=new ie({props:{name:"forward",anchor:"transformers.EfficientNetForImageClassification.forward",parameters:[{name:"pixel_values",val:": FloatTensor = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.EfficientNetForImageClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<code>AutoImageProcessor.__call__()</code> for details.`,name:"pixel_values"},{anchor:"transformers.EfficientNetForImageClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.EfficientNetForImageClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.EfficientNetForImageClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/efficientnet/modeling_efficientnet.py#L585",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutputWithNoAttention"
>transformers.modeling_outputs.ImageClassifierOutputWithNoAttention</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/efficientnet#transformers.EfficientNetConfig"
>EfficientNetConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also
called feature maps) of the model at the output of each stage.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutputWithNoAttention"
>transformers.modeling_outputs.ImageClassifierOutputWithNoAttention</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),L=new pt({props:{$$slots:{default:[$t]},$$scope:{ctx:E}}}),V=new Oe({props:{anchor:"transformers.EfficientNetForImageClassification.forward.example",$$slots:{default:[Mt]},$$scope:{ctx:E}}}),ae=new yt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/efficientnet.md"}}),{c(){t=m("meta"),v=a(),c=m("p"),l=a(),g(p.$$.fragment),o=a(),g(N.$$.fragment),ve=a(),G=m("p"),G.innerHTML=et,Ne=a(),S=m("p"),S.textContent=tt,we=a(),X=m("p"),X.innerHTML=ot,$e=a(),Q=m("p"),Q.innerHTML=nt,Me=a(),g(A.$$.fragment),Ee=a(),$=m("div"),g(H.$$.fragment),Fe=a(),ce=m("p"),ce.innerHTML=st,Pe=a(),le=m("p"),le.innerHTML=at,Re=a(),g(P.$$.fragment),Te=a(),g(Y.$$.fragment),Ce=a(),x=m("div"),g(D.$$.fragment),ke=a(),de=m("p"),de.textContent=rt,Je=a(),R=m("div"),g(O.$$.fragment),Le=a(),me=m("p"),me.textContent=it,xe=a(),g(K.$$.fragment),Ie=a(),I=m("div"),g(ee.$$.fragment),Ve=a(),fe=m("p"),fe.innerHTML=ct,qe=a(),T=m("div"),g(te.$$.fragment),Be=a(),pe=m("p"),pe.innerHTML=lt,Ge=a(),g(k.$$.fragment),Se=a(),g(J.$$.fragment),je=a(),g(oe.$$.fragment),ze=a(),M=m("div"),g(ne.$$.fragment),Xe=a(),ge=m("p"),ge.textContent=dt,Qe=a(),he=m("p"),he.innerHTML=mt,Ae=a(),C=m("div"),g(se.$$.fragment),He=a(),ue=m("p"),ue.innerHTML=ft,Ye=a(),g(L.$$.fragment),De=a(),g(V.$$.fragment),Ze=a(),g(ae.$$.fragment),Ue=a(),be=m("p"),this.h()},l(e){const n=bt("svelte-u9bgzb",document.head);t=f(n,"META",{name:!0,content:!0}),n.forEach(s),v=r(e),c=f(e,"P",{}),W(c).forEach(s),l=r(e),h(p.$$.fragment,e),o=r(e),h(N.$$.fragment,e),ve=r(e),G=f(e,"P",{"data-svelte-h":!0}),w(G)!=="svelte-n65u7l"&&(G.innerHTML=et),Ne=r(e),S=f(e,"P",{"data-svelte-h":!0}),w(S)!=="svelte-vfdo9a"&&(S.textContent=tt),we=r(e),X=f(e,"P",{"data-svelte-h":!0}),w(X)!=="svelte-1ljdnse"&&(X.innerHTML=ot),$e=r(e),Q=f(e,"P",{"data-svelte-h":!0}),w(Q)!=="svelte-vnjq51"&&(Q.innerHTML=nt),Me=r(e),h(A.$$.fragment,e),Ee=r(e),$=f(e,"DIV",{class:!0});var j=W($);h(H.$$.fragment,j),Fe=r(j),ce=f(j,"P",{"data-svelte-h":!0}),w(ce)!=="svelte-10t9xmp"&&(ce.innerHTML=st),Pe=r(j),le=f(j,"P",{"data-svelte-h":!0}),w(le)!=="svelte-o55m63"&&(le.innerHTML=at),Re=r(j),h(P.$$.fragment,j),j.forEach(s),Te=r(e),h(Y.$$.fragment,e),Ce=r(e),x=f(e,"DIV",{class:!0});var Z=W(x);h(D.$$.fragment,Z),ke=r(Z),de=f(Z,"P",{"data-svelte-h":!0}),w(de)!=="svelte-6r2o1m"&&(de.textContent=rt),Je=r(Z),R=f(Z,"DIV",{class:!0});var re=W(R);h(O.$$.fragment,re),Le=r(re),me=f(re,"P",{"data-svelte-h":!0}),w(me)!=="svelte-1x3yxsa"&&(me.textContent=it),re.forEach(s),Z.forEach(s),xe=r(e),h(K.$$.fragment,e),Ie=r(e),I=f(e,"DIV",{class:!0});var U=W(I);h(ee.$$.fragment,U),Ve=r(U),fe=f(U,"P",{"data-svelte-h":!0}),w(fe)!=="svelte-vy75gc"&&(fe.innerHTML=ct),qe=r(U),T=f(U,"DIV",{class:!0});var z=W(T);h(te.$$.fragment,z),Be=r(z),pe=f(z,"P",{"data-svelte-h":!0}),w(pe)!=="svelte-16k1eox"&&(pe.innerHTML=lt),Ge=r(z),h(k.$$.fragment,z),Se=r(z),h(J.$$.fragment,z),z.forEach(s),U.forEach(s),je=r(e),h(oe.$$.fragment,e),ze=r(e),M=f(e,"DIV",{class:!0});var q=W(M);h(ne.$$.fragment,q),Xe=r(q),ge=f(q,"P",{"data-svelte-h":!0}),w(ge)!=="svelte-im74tq"&&(ge.textContent=dt),Qe=r(q),he=f(q,"P",{"data-svelte-h":!0}),w(he)!=="svelte-1gjh92c"&&(he.innerHTML=mt),Ae=r(q),C=f(q,"DIV",{class:!0});var B=W(C);h(se.$$.fragment,B),He=r(B),ue=f(B,"P",{"data-svelte-h":!0}),w(ue)!=="svelte-1ogaw9p"&&(ue.innerHTML=ft),Ye=r(B),h(L.$$.fragment,B),De=r(B),h(V.$$.fragment,B),B.forEach(s),q.forEach(s),Ze=r(e),h(ae.$$.fragment,e),Ue=r(e),be=f(e,"P",{}),W(be).forEach(s),this.h()},h(){F(t,"name","hf:doc:metadata"),F(t,"content",Tt),F($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){d(document.head,t),i(e,v,n),i(e,c,n),i(e,l,n),u(p,e,n),i(e,o,n),u(N,e,n),i(e,ve,n),i(e,G,n),i(e,Ne,n),i(e,S,n),i(e,we,n),i(e,X,n),i(e,$e,n),i(e,Q,n),i(e,Me,n),u(A,e,n),i(e,Ee,n),i(e,$,n),u(H,$,null),d($,Fe),d($,ce),d($,Pe),d($,le),d($,Re),u(P,$,null),i(e,Te,n),u(Y,e,n),i(e,Ce,n),i(e,x,n),u(D,x,null),d(x,ke),d(x,de),d(x,Je),d(x,R),u(O,R,null),d(R,Le),d(R,me),i(e,xe,n),u(K,e,n),i(e,Ie,n),i(e,I,n),u(ee,I,null),d(I,Ve),d(I,fe),d(I,qe),d(I,T),u(te,T,null),d(T,Be),d(T,pe),d(T,Ge),u(k,T,null),d(T,Se),u(J,T,null),i(e,je,n),u(oe,e,n),i(e,ze,n),i(e,M,n),u(ne,M,null),d(M,Xe),d(M,ge),d(M,Qe),d(M,he),d(M,Ae),d(M,C),u(se,C,null),d(C,He),d(C,ue),d(C,Ye),u(L,C,null),d(C,De),u(V,C,null),i(e,Ze,n),u(ae,e,n),i(e,Ue,n),i(e,be,n),We=!0},p(e,[n]){const j={};n&2&&(j.$$scope={dirty:n,ctx:e}),P.$set(j);const Z={};n&2&&(Z.$$scope={dirty:n,ctx:e}),k.$set(Z);const re={};n&2&&(re.$$scope={dirty:n,ctx:e}),J.$set(re);const U={};n&2&&(U.$$scope={dirty:n,ctx:e}),L.$set(U);const z={};n&2&&(z.$$scope={dirty:n,ctx:e}),V.$set(z)},i(e){We||(_(p.$$.fragment,e),_(N.$$.fragment,e),_(A.$$.fragment,e),_(H.$$.fragment,e),_(P.$$.fragment,e),_(Y.$$.fragment,e),_(D.$$.fragment,e),_(O.$$.fragment,e),_(K.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(k.$$.fragment,e),_(J.$$.fragment,e),_(oe.$$.fragment,e),_(ne.$$.fragment,e),_(se.$$.fragment,e),_(L.$$.fragment,e),_(V.$$.fragment,e),_(ae.$$.fragment,e),We=!0)},o(e){b(p.$$.fragment,e),b(N.$$.fragment,e),b(A.$$.fragment,e),b(H.$$.fragment,e),b(P.$$.fragment,e),b(Y.$$.fragment,e),b(D.$$.fragment,e),b(O.$$.fragment,e),b(K.$$.fragment,e),b(ee.$$.fragment,e),b(te.$$.fragment,e),b(k.$$.fragment,e),b(J.$$.fragment,e),b(oe.$$.fragment,e),b(ne.$$.fragment,e),b(se.$$.fragment,e),b(L.$$.fragment,e),b(V.$$.fragment,e),b(ae.$$.fragment,e),We=!1},d(e){e&&(s(v),s(c),s(l),s(o),s(ve),s(G),s(Ne),s(S),s(we),s(X),s($e),s(Q),s(Me),s(Ee),s($),s(Te),s(Ce),s(x),s(xe),s(Ie),s(I),s(je),s(ze),s(M),s(Ze),s(Ue),s(be)),s(t),y(p,e),y(N,e),y(A,e),y(H),y(P),y(Y,e),y(D),y(O),y(K,e),y(ee),y(te),y(k),y(J),y(oe,e),y(ne),y(se),y(L),y(V),y(ae,e)}}}const Tt='{"title":"EfficientNet","local":"efficientnet","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"EfficientNetConfig","local":"transformers.EfficientNetConfig","sections":[],"depth":2},{"title":"EfficientNetImageProcessor","local":"transformers.EfficientNetImageProcessor","sections":[],"depth":2},{"title":"EfficientNetModel","local":"transformers.EfficientNetModel","sections":[],"depth":2},{"title":"EfficientNetForImageClassification","local":"transformers.EfficientNetForImageClassification","sections":[],"depth":2}],"depth":1}';function Ct(E){return ht(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ft extends ut{constructor(t){super(),_t(this,t,Ct,Et,gt,{})}}export{Ft as component};
