import{s as Gt,n as Rt,o as Xt}from"../chunks/scheduler.25b97de1.js";import{S as At,i as Ht,g as o,s as n,r as M,A as $t,h as i,f as l,c as a,j as Wt,u as r,x as p,k as Bt,y as St,a as s,v as y,d as c,t as m,w as d}from"../chunks/index.d9030fc9.js";import{C as ie}from"../chunks/CodeBlock.e6cd0d95.js";import{H as w,E as Qt}from"../chunks/EditOnGithub.91d95064.js";function Vt(st){let h,re,pe,ye,T,ce,J,nt='The <a href="https://github.com/huggingface/transformers" rel="nofollow">🤗 Transformers</a> library offers a collection of pre-trained models and tools for natural language processing, vision, and beyond. While these models cover a wide range of applications, you might encounter use cases that aren’t supported out of the box. Customizing models can unlock new possibilities, such as adding new layers, altering architectures, or optimizing attention mechanisms. This guide will show you how to modify existing Transformers models to fit your specific needs. The great thing is, you don’t have to step away from the Transformers framework to make these changes. You can actually modify models directly in Transformers and still take advantage of features like the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer" rel="nofollow">Trainer API</a>, <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel" rel="nofollow">PreTrainedModel</a>, and efficient fine-tuning with tools like <a href="https://huggingface.co/docs/peft/index" rel="nofollow">PEFT</a>.',me,u,at="In this guide, we’ll walk you through how to customize existing Transformers models to meet your requirements—without losing the benefits of the ecosystem.",de,U,ot="You’ll learn how to:",we,f,it="<li>Modify a model’s architecture by changing its attention mechanism.</li> <li>Apply techniques like Low-Rank Adaptation (LoRA) to specific model components.</li>",he,j,pt="We encourage you to contribute your own hacks and share them here with the community!",Te,C,Je,I,Mt="When modifying model code, you’ll often need to test your changes without restarting your Python session. The <code>clear_import_cache()</code> utility helps with this workflow, especially during model development and contribution when you need to frequently test and compare model outputs:",ue,b,Ue,g,rt="This is particularly useful when:",fe,k,yt="<li>Iteratively modifying model architectures</li> <li>Debugging model implementations</li> <li>Testing changes during model development</li> <li>Comparing outputs between original and modified versions</li> <li>Working on model contributions</li>",je,Z,ct="The <code>clear_import_cache()</code> function removes all cached Transformers modules and allows Python to reload the modified code. This enables rapid development cycles without constantly restarting your environment.",Ce,v,mt='This workflow is especially valuable when implementing new models, where you need to frequently compare outputs between the original implementation and your Transformers version (as described in the <a href="https://huggingface.co/docs/transformers/add_new_model" rel="nofollow">Add New Model</a> guide).',Ie,_,be,W,dt="The <strong>Segment Anything Model (SAM)</strong> is a state-of-the-art model for image segmentation. In its default implementation, SAM uses a combined query-key-value (<code>qkv</code>) projection in its attention mechanism. However, you might want to fine-tune only specific components of the attention mechanism, such as the query (<code>q</code>) and value (<code>v</code>) projections, to reduce the number of trainable parameters and computational resources required.",ge,B,ke,G,wt="By splitting the combined <code>qkv</code> projection into separate <code>q</code>, <code>k</code>, and <code>v</code> projections, you can apply techniques like <strong>LoRA</strong> (Low-Rank Adaptation) to only the <code>q</code> and <code>v</code> projections. This approach allows you to:",Ze,R,ht="<li>Fine-tune fewer parameters, reducing computational overhead.</li> <li>Potentially achieve better performance by focusing on specific components.</li> <li>Experiment with different adaptation strategies in the attention mechanism.</li>",ve,X,_e,A,We,H,Tt="Next, subclass the original <code>SamVisionAttention</code> class and modify it to have separate <code>q</code>, <code>k</code>, and <code>v</code> projections.",Be,$,Ge,S,Jt="<strong>Explanation:</strong>",Re,Q,ut="<li><strong>Separate Projections:</strong> The combined <code>qkv</code> projection is removed, and separate <code>q</code>, <code>k</code>, and <code>v</code> linear layers are created.</li> <li><strong>Weight Loading Hook:</strong> The <code>_split_qkv_load_hook</code> method splits the pre-trained <code>qkv</code> weights into separate <code>q</code>, <code>k</code>, and <code>v</code> weights when loading the model. This ensures compatibility with any pre-trained model.</li> <li><strong>Forward Pass:</strong> Queries, keys, and values are computed separately, and the attention mechanism proceeds as usual.</li>",Xe,V,Ae,Y,Ut="Replace the original <code>SamVisionAttention</code> class with your custom class so that the model uses the modified attention mechanism.",He,N,$e,x,ft="<strong>Explanation:</strong>",Se,z,jt="<li><strong>Class Replacement:</strong> By assigning your custom class to <code>modeling_sam.SamVisionAttention</code>, any instances of <code>SamVisionAttention</code> in the model will use the modified version. Thus when you call <code>SamModel</code>, it will use the newly defined <code>SamVisionAttentionSplit</code>.</li> <li><strong>Model Loading:</strong> The model is loaded using <code>from_pretrained</code>, and the custom attention mechanism is integrated.</li>",Qe,L,Ve,E,Ct="With separate <code>q</code>, <code>k</code>, and <code>v</code> projections, you can now apply LoRA to specific components, such as the <code>q</code> and <code>v</code> projections.",Ye,q,Ne,F,It="<strong>Explanation:</strong>",xe,D,bt="<li><strong>LoRA Configuration:</strong> The <code>LoraConfig</code> specifies the rank <code>r</code>, scaling factor <code>lora_alpha</code>, target modules (<code>&quot;q&quot;</code> and <code>&quot;v&quot;</code>), dropout, and task type.</li> <li><strong>Applying LoRA:</strong> The <code>get_peft_model</code> function applies LoRA to the specified modules in the model.</li> <li><strong>Parameter Reduction:</strong> By focusing on <code>q</code> and <code>v</code>, you reduce the number of trainable parameters, leading to faster training and lower memory usage.</li>",ze,P,Le,K,gt="It’s simple to verify the number of trainable parameters and see what impact your modification had.",Ee,O,qe,ee,kt="<strong>Expected Output:</strong>",Fe,te,De,le,Pe,se,Zt="Modifying pre-trained models can open up new avenues for research and application. By understanding and adjusting the internal mechanisms of models like SAM, you can tailor them to your specific needs, optimize performance, and experiment with new ideas.",Ke,ne,vt="If you’ve developed your own hacks for Transformers models and would like to share them, consider contributing to this doc.",Oe,ae,_t="<li><strong>Open a Pull Request:</strong> Share your code changes and improvements directly in the repository.</li> <li><strong>Write Documentation:</strong> Provide clear explanations and examples of your modifications.</li> <li><strong>Engage with the Community:</strong> Discuss your ideas and get feedback from other developers and researchers by opening an issue.</li>",et,oe,tt,Me,lt;return T=new w({props:{title:"How to Hack Any Transformers Model",local:"how-to-hack-any-transformers-model",headingTag:"h1"}}),C=new w({props:{title:"Efficient Development Workflow",local:"efficient-development-workflow",headingTag:"h2"}}),b=new ie({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEElMEElMjMlMjBNYWtlJTIwbW9kaWZpY2F0aW9ucyUyMHRvJTIwdGhlJTIwdHJhbnNmb3JtZXJzJTIwY29kZS4uLiUwQSUwQSUyMyUyMENsZWFyJTIwdGhlJTIwY2FjaGUlMjB0byUyMHJlbG9hZCUyMHRoZSUyMG1vZGlmaWVkJTIwY29kZSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMudXRpbHMuaW1wb3J0X3V0aWxzJTIwaW1wb3J0JTIwY2xlYXJfaW1wb3J0X2NhY2hlJTBBY2xlYXJfaW1wb3J0X2NhY2hlKCklMEElMEElMjMlMjBSZWltcG9ydCUyMHRvJTIwZ2V0JTIwdGhlJTIwY2hhbmdlcyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvTW9kZWwlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIpJTIwJTIwJTIzJTIwV2lsbCUyMHVzZSUyMHVwZGF0ZWQlMjBjb2Rl",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel
model = AutoModel.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)

<span class="hljs-comment"># Make modifications to the transformers code...</span>

<span class="hljs-comment"># Clear the cache to reload the modified code</span>
<span class="hljs-keyword">from</span> transformers.utils.import_utils <span class="hljs-keyword">import</span> clear_import_cache
clear_import_cache()

<span class="hljs-comment"># Reimport to get the changes</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel
model = AutoModel.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)  <span class="hljs-comment"># Will use updated code</span>`,wrap:!1}}),_=new w({props:{title:"Example: Modifying the Attention Mechanism in the Segment Anything Model (SAM)",local:"example-modifying-the-attention-mechanism-in-the-segment-anything-model-sam",headingTag:"h2"}}),B=new w({props:{title:"Motivation",local:"motivation",headingTag:"h3"}}),X=new w({props:{title:"Implementation",local:"implementation",headingTag:"h3"}}),A=new w({props:{title:"Step 1: Create a Custom Attention Class",local:"step-1-create-a-custom-attention-class",headingTag:"h4"}}),$=new ie({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">from</span> transformers.models.sam.modeling_sam <span class="hljs-keyword">import</span> SamVisionAttention

<span class="hljs-keyword">class</span> <span class="hljs-title class_">SamVisionAttentionSplit</span>(SamVisionAttention, nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config, window_size</span>):
        <span class="hljs-built_in">super</span>().__init__(config, window_size)
        <span class="hljs-keyword">del</span> self.qkv
        <span class="hljs-comment"># Separate q, k, v projections</span>
        self.q = nn.Linear(config.hidden_size, config.hidden_size, bias=config.qkv_bias)
        self.k = nn.Linear(config.hidden_size, config.hidden_size, bias=config.qkv_bias)
        self.v = nn.Linear(config.hidden_size, config.hidden_size, bias=config.qkv_bias)
        self._register_load_state_dict_pre_hook(self.split_q_k_v_load_hook)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">split_q_k_v_load_hook</span>(<span class="hljs-params">self, state_dict, prefix, *args</span>):
        keys_to_delete = []
        <span class="hljs-keyword">for</span> key <span class="hljs-keyword">in</span> <span class="hljs-built_in">list</span>(state_dict.keys()):
            <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;qkv.&quot;</span> <span class="hljs-keyword">in</span> key:
                <span class="hljs-comment"># Split q, k, v from the combined projection</span>
                q, k, v = state_dict[key].chunk(<span class="hljs-number">3</span>, dim=<span class="hljs-number">0</span>)
                <span class="hljs-comment"># Replace with individual q, k, v projections</span>
                state_dict[key.replace(<span class="hljs-string">&quot;qkv.&quot;</span>, <span class="hljs-string">&quot;q.&quot;</span>)] = q
                state_dict[key.replace(<span class="hljs-string">&quot;qkv.&quot;</span>, <span class="hljs-string">&quot;k.&quot;</span>)] = k
                state_dict[key.replace(<span class="hljs-string">&quot;qkv.&quot;</span>, <span class="hljs-string">&quot;v.&quot;</span>)] = v
                <span class="hljs-comment"># Mark the old qkv key for deletion</span>
                keys_to_delete.append(key)
        
        <span class="hljs-comment"># Remove old qkv keys</span>
        <span class="hljs-keyword">for</span> key <span class="hljs-keyword">in</span> keys_to_delete:
            <span class="hljs-keyword">del</span> state_dict[key]

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, hidden_states: torch.Tensor, output_attentions=<span class="hljs-literal">False</span></span>) -&gt; torch.Tensor:
        batch_size, height, width, _ = hidden_states.shape
        qkv_shapes = (batch_size *  self.num_attention_heads,  height * width, -<span class="hljs-number">1</span>)
        query = self.q(hidden_states).reshape((batch_size,  height * width,self.num_attention_heads, -<span class="hljs-number">1</span>)).permute(<span class="hljs-number">0</span>,<span class="hljs-number">2</span>,<span class="hljs-number">1</span>,<span class="hljs-number">3</span>).reshape(qkv_shapes)
        key = self.k(hidden_states).reshape((batch_size,  height * width,self.num_attention_heads, -<span class="hljs-number">1</span>)).permute(<span class="hljs-number">0</span>,<span class="hljs-number">2</span>,<span class="hljs-number">1</span>,<span class="hljs-number">3</span>).reshape(qkv_shapes)
        value = self.v(hidden_states).reshape((batch_size,  height * width,self.num_attention_heads, -<span class="hljs-number">1</span>)).permute(<span class="hljs-number">0</span>,<span class="hljs-number">2</span>,<span class="hljs-number">1</span>,<span class="hljs-number">3</span>).reshape(qkv_shapes)

        attn_weights = (query * self.scale) @ key.transpose(-<span class="hljs-number">2</span>, -<span class="hljs-number">1</span>)

        <span class="hljs-keyword">if</span> self.use_rel_pos:
            attn_weights = self.add_decomposed_rel_pos(
                attn_weights, query, self.rel_pos_h, self.rel_pos_w, (height, width), (height, width)
            )

        attn_weights = torch.nn.functional.softmax(attn_weights, dtype=torch.float32, dim=-<span class="hljs-number">1</span>).to(query.dtype)
        attn_probs = nn.functional.dropout(attn_weights, p=self.dropout, training=self.training)
        attn_output = (attn_probs @ value).reshape(batch_size, self.num_attention_heads, height, width, -<span class="hljs-number">1</span>)
        attn_output = attn_output.permute(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>, <span class="hljs-number">4</span>).reshape(batch_size, height, width, -<span class="hljs-number">1</span>)
        attn_output = self.proj(attn_output)

        <span class="hljs-keyword">if</span> output_attentions:
            outputs = (attn_output, attn_weights)
        <span class="hljs-keyword">else</span>:
            outputs = (attn_output, <span class="hljs-literal">None</span>)
        <span class="hljs-keyword">return</span> outputs`,wrap:!1}}),V=new w({props:{title:"Step 2: Replace the Original Attention Class",local:"step-2-replace-the-original-attention-class",headingTag:"h4"}}),N=new ie({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNhbU1vZGVsJTBBZnJvbSUyMHRyYW5zZm9ybWVycy5tb2RlbHMuc2FtJTIwaW1wb3J0JTIwbW9kZWxpbmdfc2FtJTBBJTBBJTIzJTIwUmVwbGFjZSUyMHRoZSUyMGF0dGVudGlvbiUyMGNsYXNzJTIwaW4lMjB0aGUlMjBtb2RlbGluZ19zYW0lMjBtb2R1bGUlMEFtb2RlbGluZ19zYW0uU2FtVmlzaW9uQXR0ZW50aW9uJTIwJTNEJTIwU2FtVmlzaW9uQXR0ZW50aW9uU3BsaXQlMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwcHJlLXRyYWluZWQlMjBTQU0lMjBtb2RlbCUwQW1vZGVsJTIwJTNEJTIwU2FtTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGc2FtLXZpdC1iYXNlJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SamModel
<span class="hljs-keyword">from</span> transformers.models.sam <span class="hljs-keyword">import</span> modeling_sam

<span class="hljs-comment"># Replace the attention class in the modeling_sam module</span>
modeling_sam.SamVisionAttention = SamVisionAttentionSplit

<span class="hljs-comment"># Load the pre-trained SAM model</span>
model = SamModel.from_pretrained(<span class="hljs-string">&quot;facebook/sam-vit-base&quot;</span>)`,wrap:!1}}),L=new w({props:{title:"Step 3: Apply LoRA to Specific Projections",local:"step-3-apply-lora-to-specific-projections",headingTag:"h4"}}),q=new ie({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QzMiUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycSUyMiUyQyUyMCUyMnYlMjIlNUQlMkMlMjAlMjAlMjMlMjBBcHBseSUyMExvUkElMjB0byUyMHElMjBhbmQlMjB2JTIwcHJvamVjdGlvbnMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjElMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJtYXNrLWdlbmVyYXRpb24lMjIlMEEpJTBBJTBBJTIzJTIwQXBwbHklMjBMb1JBJTIwdG8lMjB0aGUlMjBtb2RlbCUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBjb25maWcp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    target_modules=[<span class="hljs-string">&quot;q&quot;</span>, <span class="hljs-string">&quot;v&quot;</span>],  <span class="hljs-comment"># Apply LoRA to q and v projections</span>
    lora_dropout=<span class="hljs-number">0.1</span>,
    task_type=<span class="hljs-string">&quot;mask-generation&quot;</span>
)

<span class="hljs-comment"># Apply LoRA to the model</span>
model = get_peft_model(model, config)`,wrap:!1}}),P=new w({props:{title:"Step 4: Verify the Number of Trainable Parameters",local:"step-4-verify-the-number-of-trainable-parameters",headingTag:"h4"}}),O=new ie({props:{code:"bW9kZWwucHJpbnRfdHJhaW5hYmxlX3BhcmFtZXRlcnMoKQ==",highlighted:"model.print_trainable_parameters()",wrap:!1}}),te=new ie({props:{code:"dHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwNjA4JTJDMjU2JTIwJTdDJTdDJTIwYWxsJTIwcGFyYW1zJTNBJTIwOTQlMkMzNDMlMkM3MjglMjAlN0MlN0MlMjB0cmFpbmFibGUlMjUlM0ElMjAwLjY0NDclMEF0cmFpbmFibGUlMjBwYXJhbXMlM0ElMjA5MTIlMkMzODQlMjAlN0MlN0MlMjBhbGwlMjBwYXJhbXMlM0ElMjA5NCUyQzY0NyUyQzg1NiUyMCU3QyU3QyUyMHRyYWluYWJsZSUyNSUzQSUyMDAuOTY0MCUyMCUyMyUyMHdpdGglMjBrJTIw",highlighted:`<span class="hljs-attribute">trainable</span> params: <span class="hljs-number">608</span>,<span class="hljs-number">256</span> || <span class="hljs-literal">all</span> params: <span class="hljs-number">94</span>,<span class="hljs-number">343</span>,<span class="hljs-number">728</span> || trainable%: <span class="hljs-number">0</span>.<span class="hljs-number">6447</span>
<span class="hljs-attribute">trainable</span> params: <span class="hljs-number">912</span>,<span class="hljs-number">384</span> || <span class="hljs-literal">all</span> params: <span class="hljs-number">94</span>,<span class="hljs-number">647</span>,<span class="hljs-number">856</span> || trainable%: <span class="hljs-number">0</span>.<span class="hljs-number">9640</span> # with k `,wrap:!1}}),le=new w({props:{title:"Contributing Your Own Hacks",local:"contributing-your-own-hacks",headingTag:"h2"}}),oe=new Qt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/how_to_hack_models.md"}}),{c(){h=o("meta"),re=n(),pe=o("p"),ye=n(),M(T.$$.fragment),ce=n(),J=o("p"),J.innerHTML=nt,me=n(),u=o("p"),u.textContent=at,de=n(),U=o("p"),U.textContent=ot,we=n(),f=o("ul"),f.innerHTML=it,he=n(),j=o("p"),j.textContent=pt,Te=n(),M(C.$$.fragment),Je=n(),I=o("p"),I.innerHTML=Mt,ue=n(),M(b.$$.fragment),Ue=n(),g=o("p"),g.textContent=rt,fe=n(),k=o("ul"),k.innerHTML=yt,je=n(),Z=o("p"),Z.innerHTML=ct,Ce=n(),v=o("p"),v.innerHTML=mt,Ie=n(),M(_.$$.fragment),be=n(),W=o("p"),W.innerHTML=dt,ge=n(),M(B.$$.fragment),ke=n(),G=o("p"),G.innerHTML=wt,Ze=n(),R=o("ul"),R.innerHTML=ht,ve=n(),M(X.$$.fragment),_e=n(),M(A.$$.fragment),We=n(),H=o("p"),H.innerHTML=Tt,Be=n(),M($.$$.fragment),Ge=n(),S=o("p"),S.innerHTML=Jt,Re=n(),Q=o("ul"),Q.innerHTML=ut,Xe=n(),M(V.$$.fragment),Ae=n(),Y=o("p"),Y.innerHTML=Ut,He=n(),M(N.$$.fragment),$e=n(),x=o("p"),x.innerHTML=ft,Se=n(),z=o("ul"),z.innerHTML=jt,Qe=n(),M(L.$$.fragment),Ve=n(),E=o("p"),E.innerHTML=Ct,Ye=n(),M(q.$$.fragment),Ne=n(),F=o("p"),F.innerHTML=It,xe=n(),D=o("ul"),D.innerHTML=bt,ze=n(),M(P.$$.fragment),Le=n(),K=o("p"),K.textContent=gt,Ee=n(),M(O.$$.fragment),qe=n(),ee=o("p"),ee.innerHTML=kt,Fe=n(),M(te.$$.fragment),De=n(),M(le.$$.fragment),Pe=n(),se=o("p"),se.textContent=Zt,Ke=n(),ne=o("p"),ne.textContent=vt,Oe=n(),ae=o("ul"),ae.innerHTML=_t,et=n(),M(oe.$$.fragment),tt=n(),Me=o("p"),this.h()},l(e){const t=$t("svelte-u9bgzb",document.head);h=i(t,"META",{name:!0,content:!0}),t.forEach(l),re=a(e),pe=i(e,"P",{}),Wt(pe).forEach(l),ye=a(e),r(T.$$.fragment,e),ce=a(e),J=i(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-4p0w22"&&(J.innerHTML=nt),me=a(e),u=i(e,"P",{"data-svelte-h":!0}),p(u)!=="svelte-1kaw87e"&&(u.textContent=at),de=a(e),U=i(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-16olrhx"&&(U.textContent=ot),we=a(e),f=i(e,"UL",{"data-svelte-h":!0}),p(f)!=="svelte-1219jh3"&&(f.innerHTML=it),he=a(e),j=i(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-viaaio"&&(j.textContent=pt),Te=a(e),r(C.$$.fragment,e),Je=a(e),I=i(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1ib71ng"&&(I.innerHTML=Mt),ue=a(e),r(b.$$.fragment,e),Ue=a(e),g=i(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-1nzhrrw"&&(g.textContent=rt),fe=a(e),k=i(e,"UL",{"data-svelte-h":!0}),p(k)!=="svelte-12gm7es"&&(k.innerHTML=yt),je=a(e),Z=i(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1cz62wa"&&(Z.innerHTML=ct),Ce=a(e),v=i(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1bnr3o2"&&(v.innerHTML=mt),Ie=a(e),r(_.$$.fragment,e),be=a(e),W=i(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-pqt08"&&(W.innerHTML=dt),ge=a(e),r(B.$$.fragment,e),ke=a(e),G=i(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1fee5zh"&&(G.innerHTML=wt),Ze=a(e),R=i(e,"UL",{"data-svelte-h":!0}),p(R)!=="svelte-ajxk4v"&&(R.innerHTML=ht),ve=a(e),r(X.$$.fragment,e),_e=a(e),r(A.$$.fragment,e),We=a(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-183kvjr"&&(H.innerHTML=Tt),Be=a(e),r($.$$.fragment,e),Ge=a(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-qcx91s"&&(S.innerHTML=Jt),Re=a(e),Q=i(e,"UL",{"data-svelte-h":!0}),p(Q)!=="svelte-17qbtt1"&&(Q.innerHTML=ut),Xe=a(e),r(V.$$.fragment,e),Ae=a(e),Y=i(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-sp0tsy"&&(Y.innerHTML=Ut),He=a(e),r(N.$$.fragment,e),$e=a(e),x=i(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-qcx91s"&&(x.innerHTML=ft),Se=a(e),z=i(e,"UL",{"data-svelte-h":!0}),p(z)!=="svelte-1qee5e9"&&(z.innerHTML=jt),Qe=a(e),r(L.$$.fragment,e),Ve=a(e),E=i(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-14bh2vd"&&(E.innerHTML=Ct),Ye=a(e),r(q.$$.fragment,e),Ne=a(e),F=i(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-qcx91s"&&(F.innerHTML=It),xe=a(e),D=i(e,"UL",{"data-svelte-h":!0}),p(D)!=="svelte-ampkeh"&&(D.innerHTML=bt),ze=a(e),r(P.$$.fragment,e),Le=a(e),K=i(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-a867g8"&&(K.textContent=gt),Ee=a(e),r(O.$$.fragment,e),qe=a(e),ee=i(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-cry7xq"&&(ee.innerHTML=kt),Fe=a(e),r(te.$$.fragment,e),De=a(e),r(le.$$.fragment,e),Pe=a(e),se=i(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1rmqfnq"&&(se.textContent=Zt),Ke=a(e),ne=i(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1vdc3k7"&&(ne.textContent=vt),Oe=a(e),ae=i(e,"UL",{"data-svelte-h":!0}),p(ae)!=="svelte-1934g57"&&(ae.innerHTML=_t),et=a(e),r(oe.$$.fragment,e),tt=a(e),Me=i(e,"P",{}),Wt(Me).forEach(l),this.h()},h(){Bt(h,"name","hf:doc:metadata"),Bt(h,"content",Yt)},m(e,t){St(document.head,h),s(e,re,t),s(e,pe,t),s(e,ye,t),y(T,e,t),s(e,ce,t),s(e,J,t),s(e,me,t),s(e,u,t),s(e,de,t),s(e,U,t),s(e,we,t),s(e,f,t),s(e,he,t),s(e,j,t),s(e,Te,t),y(C,e,t),s(e,Je,t),s(e,I,t),s(e,ue,t),y(b,e,t),s(e,Ue,t),s(e,g,t),s(e,fe,t),s(e,k,t),s(e,je,t),s(e,Z,t),s(e,Ce,t),s(e,v,t),s(e,Ie,t),y(_,e,t),s(e,be,t),s(e,W,t),s(e,ge,t),y(B,e,t),s(e,ke,t),s(e,G,t),s(e,Ze,t),s(e,R,t),s(e,ve,t),y(X,e,t),s(e,_e,t),y(A,e,t),s(e,We,t),s(e,H,t),s(e,Be,t),y($,e,t),s(e,Ge,t),s(e,S,t),s(e,Re,t),s(e,Q,t),s(e,Xe,t),y(V,e,t),s(e,Ae,t),s(e,Y,t),s(e,He,t),y(N,e,t),s(e,$e,t),s(e,x,t),s(e,Se,t),s(e,z,t),s(e,Qe,t),y(L,e,t),s(e,Ve,t),s(e,E,t),s(e,Ye,t),y(q,e,t),s(e,Ne,t),s(e,F,t),s(e,xe,t),s(e,D,t),s(e,ze,t),y(P,e,t),s(e,Le,t),s(e,K,t),s(e,Ee,t),y(O,e,t),s(e,qe,t),s(e,ee,t),s(e,Fe,t),y(te,e,t),s(e,De,t),y(le,e,t),s(e,Pe,t),s(e,se,t),s(e,Ke,t),s(e,ne,t),s(e,Oe,t),s(e,ae,t),s(e,et,t),y(oe,e,t),s(e,tt,t),s(e,Me,t),lt=!0},p:Rt,i(e){lt||(c(T.$$.fragment,e),c(C.$$.fragment,e),c(b.$$.fragment,e),c(_.$$.fragment,e),c(B.$$.fragment,e),c(X.$$.fragment,e),c(A.$$.fragment,e),c($.$$.fragment,e),c(V.$$.fragment,e),c(N.$$.fragment,e),c(L.$$.fragment,e),c(q.$$.fragment,e),c(P.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),c(le.$$.fragment,e),c(oe.$$.fragment,e),lt=!0)},o(e){m(T.$$.fragment,e),m(C.$$.fragment,e),m(b.$$.fragment,e),m(_.$$.fragment,e),m(B.$$.fragment,e),m(X.$$.fragment,e),m(A.$$.fragment,e),m($.$$.fragment,e),m(V.$$.fragment,e),m(N.$$.fragment,e),m(L.$$.fragment,e),m(q.$$.fragment,e),m(P.$$.fragment,e),m(O.$$.fragment,e),m(te.$$.fragment,e),m(le.$$.fragment,e),m(oe.$$.fragment,e),lt=!1},d(e){e&&(l(re),l(pe),l(ye),l(ce),l(J),l(me),l(u),l(de),l(U),l(we),l(f),l(he),l(j),l(Te),l(Je),l(I),l(ue),l(Ue),l(g),l(fe),l(k),l(je),l(Z),l(Ce),l(v),l(Ie),l(be),l(W),l(ge),l(ke),l(G),l(Ze),l(R),l(ve),l(_e),l(We),l(H),l(Be),l(Ge),l(S),l(Re),l(Q),l(Xe),l(Ae),l(Y),l(He),l($e),l(x),l(Se),l(z),l(Qe),l(Ve),l(E),l(Ye),l(Ne),l(F),l(xe),l(D),l(ze),l(Le),l(K),l(Ee),l(qe),l(ee),l(Fe),l(De),l(Pe),l(se),l(Ke),l(ne),l(Oe),l(ae),l(et),l(tt),l(Me)),l(h),d(T,e),d(C,e),d(b,e),d(_,e),d(B,e),d(X,e),d(A,e),d($,e),d(V,e),d(N,e),d(L,e),d(q,e),d(P,e),d(O,e),d(te,e),d(le,e),d(oe,e)}}}const Yt='{"title":"How to Hack Any Transformers Model","local":"how-to-hack-any-transformers-model","sections":[{"title":"Efficient Development Workflow","local":"efficient-development-workflow","sections":[],"depth":2},{"title":"Example: Modifying the Attention Mechanism in the Segment Anything Model (SAM)","local":"example-modifying-the-attention-mechanism-in-the-segment-anything-model-sam","sections":[{"title":"Motivation","local":"motivation","sections":[],"depth":3},{"title":"Implementation","local":"implementation","sections":[{"title":"Step 1: Create a Custom Attention Class","local":"step-1-create-a-custom-attention-class","sections":[],"depth":4},{"title":"Step 2: Replace the Original Attention Class","local":"step-2-replace-the-original-attention-class","sections":[],"depth":4},{"title":"Step 3: Apply LoRA to Specific Projections","local":"step-3-apply-lora-to-specific-projections","sections":[],"depth":4},{"title":"Step 4: Verify the Number of Trainable Parameters","local":"step-4-verify-the-number-of-trainable-parameters","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Contributing Your Own Hacks","local":"contributing-your-own-hacks","sections":[],"depth":2}],"depth":1}';function Nt(st){return Xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qt extends At{constructor(h){super(),Ht(this,h,Nt,Vt,Gt,{})}}export{qt as component};
