import{s as Ae,n as Ge,o as Ve}from"../chunks/scheduler.25b97de1.js";import{S as Xe,i as He,g as p,s as a,r,A as qe,h as i,f as l,c as n,j as ge,u as c,x as o,k as Ze,y as We,a as t,v as M,d,t as y,w as u}from"../chunks/index.d9030fc9.js";import{C as w}from"../chunks/CodeBlock.e6cd0d95.js";import{H as se,E as Ne}from"../chunks/EditOnGithub.91d95064.js";function Re(ee){let T,os,ps,rs,m,cs,h,le=`In this guide, we will see how to create a custom pipeline and share it on the <a href="https://hf.co/models" rel="nofollow">Hub</a> or add it to the
🤗 Transformers library.`,Ms,J,te=`First and foremost, you need to decide the raw entries the pipeline will be able to take. It can be strings, raw bytes,
dictionaries or whatever seems to be the most likely desired input. Try to keep these inputs as pure Python as possible
as it makes compatibility easier (even through other languages via JSON). Those will be the <code>inputs</code> of the
pipeline (<code>preprocess</code>).`,ds,j,ae=`Then define the <code>outputs</code>. Same policy as the <code>inputs</code>. The simpler, the better. Those will be the outputs of
<code>postprocess</code> method.`,ys,f,ne=`Start by inheriting the base class <code>Pipeline</code> with the 4 methods needed to implement <code>preprocess</code>,
<code>_forward</code>, <code>postprocess</code>, and <code>_sanitize_parameters</code>.`,us,U,ws,I,pe=`The structure of this breakdown is to support relatively seamless support for CPU/GPU, while supporting doing
pre/postprocessing on the CPU on different threads`,Ts,b,ie=`<code>preprocess</code> will take the originally defined inputs, and turn them into something feedable to the model. It might
contain more information and is usually a <code>Dict</code>.`,ms,B,oe=`<code>_forward</code> is the implementation detail and is not meant to be called directly. <code>forward</code> is the preferred
called method as it contains safeguards to make sure everything is working on the expected device. If anything is
linked to a real model it belongs in the <code>_forward</code> method, anything else is in the preprocess/postprocess.`,hs,C,re=`<code>postprocess</code> methods will take the output of <code>_forward</code> and turn it into the final output that was decided
earlier.`,Js,_,ce=`<code>_sanitize_parameters</code> exists to allow users to pass any parameters whenever they wish, be it at initialization
time <code>pipeline(...., maybe_arg=4)</code> or at call time <code>pipe = pipeline(...); output = pipe(...., maybe_arg=4)</code>.`,js,k,Me=`The returns of <code>_sanitize_parameters</code> are the 3 dicts of kwargs that will be passed directly to <code>preprocess</code>,
<code>_forward</code>, and <code>postprocess</code>. Don’t fill anything if the caller didn’t call with any extra parameter. That
allows to keep the default arguments in the function definition which is always more “natural”.`,fs,g,de="A classic example would be a <code>top_k</code> argument in the post processing in classification tasks.",Us,Z,Is,A,ye=`In order to achieve that, we’ll update our <code>postprocess</code> method with a default parameter to <code>5</code>. and edit
<code>_sanitize_parameters</code> to allow this new parameter.`,bs,G,Bs,V,ue=`Try to keep the inputs/outputs very simple and ideally JSON-serializable as it makes the pipeline usage very easy
without requiring users to understand new kinds of objects. It’s also relatively common to support many different types
of arguments for ease of use (audio files, which can be filenames, URLs or pure bytes)`,Cs,X,_s,H,we="To register your <code>new-task</code> to the list of supported tasks, you have to add it to the <code>PIPELINE_REGISTRY</code>:",ks,q,gs,W,Te="You can specify a default model if you want, in which case it should come with a specific revision (which can be the name of a branch or a commit hash, here we took <code>&quot;abcdef&quot;</code>) as well as the type:",Zs,N,As,R,Gs,v,me=`To share your custom pipeline on the Hub, you just have to save the custom code of your <code>Pipeline</code> subclass in a
python file. For instance, let’s say we want to use a custom pipeline for sentence pair classification like this:`,Vs,E,Xs,$,he=`The implementation is framework agnostic, and will work for PyTorch and TensorFlow models. If we have saved this in
a file named <code>pair_classification.py</code>, we can then import it and register it like this.`,Hs,z,qs,x,Je='The <a href="https://github.com/huggingface/transformers/blob/9feae5fb0164e89d4998e5776897c16f7330d3df/src/transformers/pipelines/base.py#L1387" rel="nofollow">register_pipeline</a> function registers the pipeline details (task type, pipeline class, supported backends) to a models <code>config.json</code> file.',Ws,Y,Ns,Q,je=`Once this is done, we can use it with a pretrained model. For instance <code>sgugger/finetuned-bert-mrpc</code> has been
fine-tuned on the MRPC dataset, which classifies pairs of sentences as paraphrases or not.`,Rs,F,vs,S,fe="Then we can share it on the Hub by using the <code>push_to_hub</code> method:",Es,L,$s,P,Ue=`This will copy the file where you defined <code>PairClassificationPipeline</code> inside the folder <code>&quot;test-dynamic-pipeline&quot;</code>,
along with saving the model and tokenizer of the pipeline, before pushing everything into the repository
<code>{your_username}/test-dynamic-pipeline</code>. After that, anyone can use it as long as they provide the option
<code>trust_remote_code=True</code>:`,zs,D,xs,K,Ys,O,Ie=`If you want to contribute your pipeline to 🤗 Transformers, you will need to add a new module in the <code>pipelines</code> submodule
with the code of your pipeline, then add it to the list of tasks defined in <code>pipelines/__init__.py</code>.`,Qs,ss,be="Then you will need to add tests. Create a new file <code>tests/test_pipelines_MY_PIPELINE.py</code> with examples of the other tests.",Fs,es,Be=`The <code>run_pipeline_test</code> function will be very generic and run on small random models on every possible
architecture as defined by <code>model_mapping</code> and <code>tf_model_mapping</code>.`,Ss,ls,Ce=`This is very important to test future compatibility, meaning if someone adds a new model for
<code>XXXForQuestionAnswering</code> then the pipeline test will attempt to run on it. Because the models are random it’s
impossible to check for actual values, that’s why there is a helper <code>ANY</code> that will simply attempt to match the
output of the pipeline TYPE.`,Ls,ts,_e="You also <em>need</em> to implement 2 (ideally 4) tests.",Ps,as,ke=`<li><code>test_small_model_pt</code> : Define 1 small model for this pipeline (doesn’t matter if the results don’t make sense)
and test the pipeline outputs. The results should be the same as <code>test_small_model_tf</code>.</li> <li><code>test_small_model_tf</code> : Define 1 small model for this pipeline (doesn’t matter if the results don’t make sense)
and test the pipeline outputs. The results should be the same as <code>test_small_model_pt</code>.</li> <li><code>test_large_model_pt</code> (<code>optional</code>): Tests the pipeline on a real pipeline where the results are supposed to
make sense. These tests are slow and should be marked as such. Here the goal is to showcase the pipeline and to make
sure there is no drift in future releases.</li> <li><code>test_large_model_tf</code> (<code>optional</code>): Tests the pipeline on a real pipeline where the results are supposed to
make sense. These tests are slow and should be marked as such. Here the goal is to showcase the pipeline and to make
sure there is no drift in future releases.</li>`,Ds,ns,Ks,is,Os;return m=new se({props:{title:"How to create a custom pipeline?",local:"how-to-create-a-custom-pipeline",headingTag:"h1"}}),U=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBpcGVsaW5lJTBBJTBBJTBBY2xhc3MlMjBNeVBpcGVsaW5lKFBpcGVsaW5lKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9zYW5pdGl6ZV9wYXJhbWV0ZXJzKHNlbGYlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVwcm9jZXNzX2t3YXJncyUyMCUzRCUyMCU3QiU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwJTIybWF5YmVfYXJnJTIyJTIwaW4lMjBrd2FyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVwcm9jZXNzX2t3YXJncyU1QiUyMm1heWJlX2FyZyUyMiU1RCUyMCUzRCUyMGt3YXJncyU1QiUyMm1heWJlX2FyZyUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHByZXByb2Nlc3Nfa3dhcmdzJTJDJTIwJTdCJTdEJTJDJTIwJTdCJTdEJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcHJlcHJvY2VzcyhzZWxmJTJDJTIwaW5wdXRzJTJDJTIwbWF5YmVfYXJnJTNEMiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9pbnB1dCUyMCUzRCUyMFRlbnNvcihpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybW9kZWxfaW5wdXQlMjIlM0ElMjBtb2RlbF9pbnB1dCU3RCUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9mb3J3YXJkKHNlbGYlMkMlMjBtb2RlbF9pbnB1dHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbW9kZWxfaW5wdXRzJTIwJTNEJTNEJTIwJTdCJTIybW9kZWxfaW5wdXQlMjIlM0ElMjBtb2RlbF9pbnB1dCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBzZWxmLm1vZGVsKCoqbW9kZWxfaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyME1heWJlJTIwJTdCJTIybG9naXRzJTIyJTNBJTIwVGVuc29yKC4uLiklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBvdXRwdXRzJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcG9zdHByb2Nlc3Moc2VsZiUyQyUyMG1vZGVsX291dHB1dHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmVzdF9jbGFzcyUyMCUzRCUyMG1vZGVsX291dHB1dHMlNUIlMjJsb2dpdHMlMjIlNUQuc29mdG1heCgtMSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBiZXN0X2NsYXNz",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyPipeline</span>(<span class="hljs-title class_ inherited__">Pipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
        preprocess_kwargs = {}
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;maybe_arg&quot;</span> <span class="hljs-keyword">in</span> kwargs:
            preprocess_kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>] = kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>]
        <span class="hljs-keyword">return</span> preprocess_kwargs, {}, {}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess</span>(<span class="hljs-params">self, inputs, maybe_arg=<span class="hljs-number">2</span></span>):
        model_input = Tensor(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;model_input&quot;</span>: model_input}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, model_inputs</span>):
        <span class="hljs-comment"># model_inputs == {&quot;model_input&quot;: model_input}</span>
        outputs = self.model(**model_inputs)
        <span class="hljs-comment"># Maybe {&quot;logits&quot;: Tensor(...)}</span>
        <span class="hljs-keyword">return</span> outputs

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs</span>):
        best_class = model_outputs[<span class="hljs-string">&quot;logits&quot;</span>].softmax(-<span class="hljs-number">1</span>)
        <span class="hljs-keyword">return</span> best_class`,wrap:!1}}),Z=new w({props:{code:"cGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMm15LW5ldy10YXNrJTIyKSUwQXBpcGUoJTIyVGhpcyUyMGlzJTIwYSUyMHRlc3QlMjIpJTBBJTBBcGlwZSglMjJUaGlzJTIwaXMlMjBhJTIwdGVzdCUyMiUyQyUyMHRvcF9rJTNEMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;my-new-task&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(<span class="hljs-string">&quot;This is a test&quot;</span>)
[{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;1-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.8</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;2-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.1</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;3-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.05</span>}
{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;4-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.025</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;5-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.025</span>}]

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(<span class="hljs-string">&quot;This is a test&quot;</span>, top_k=<span class="hljs-number">2</span>)
[{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;1-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.8</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;2-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.1</span>}]`,wrap:!1}}),G=new w({props:{code:"ZGVmJTIwcG9zdHByb2Nlc3Moc2VsZiUyQyUyMG1vZGVsX291dHB1dHMlMkMlMjB0b3BfayUzRDUpJTNBJTBBJTIwJTIwJTIwJTIwYmVzdF9jbGFzcyUyMCUzRCUyMG1vZGVsX291dHB1dHMlNUIlMjJsb2dpdHMlMjIlNUQuc29mdG1heCgtMSklMEElMjAlMjAlMjAlMjAlMjMlMjBBZGQlMjBsb2dpYyUyMHRvJTIwaGFuZGxlJTIwdG9wX2slMEElMjAlMjAlMjAlMjByZXR1cm4lMjBiZXN0X2NsYXNzJTBBJTBBJTBBZGVmJTIwX3Nhbml0aXplX3BhcmFtZXRlcnMoc2VsZiUyQyUyMCoqa3dhcmdzKSUzQSUwQSUyMCUyMCUyMCUyMHByZXByb2Nlc3Nfa3dhcmdzJTIwJTNEJTIwJTdCJTdEJTBBJTIwJTIwJTIwJTIwaWYlMjAlMjJtYXliZV9hcmclMjIlMjBpbiUyMGt3YXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByZXByb2Nlc3Nfa3dhcmdzJTVCJTIybWF5YmVfYXJnJTIyJTVEJTIwJTNEJTIwa3dhcmdzJTVCJTIybWF5YmVfYXJnJTIyJTVEJTBBJTBBJTIwJTIwJTIwJTIwcG9zdHByb2Nlc3Nfa3dhcmdzJTIwJTNEJTIwJTdCJTdEJTBBJTIwJTIwJTIwJTIwaWYlMjAlMjJ0b3BfayUyMiUyMGluJTIwa3dhcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcG9zdHByb2Nlc3Nfa3dhcmdzJTVCJTIydG9wX2slMjIlNUQlMjAlM0QlMjBrd2FyZ3MlNUIlMjJ0b3BfayUyMiU1RCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHByZXByb2Nlc3Nfa3dhcmdzJTJDJTIwJTdCJTdEJTJDJTIwcG9zdHByb2Nlc3Nfa3dhcmdz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs, top_k=<span class="hljs-number">5</span></span>):
    best_class = model_outputs[<span class="hljs-string">&quot;logits&quot;</span>].softmax(-<span class="hljs-number">1</span>)
    <span class="hljs-comment"># Add logic to handle top_k</span>
    <span class="hljs-keyword">return</span> best_class


<span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
    preprocess_kwargs = {}
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;maybe_arg&quot;</span> <span class="hljs-keyword">in</span> kwargs:
        preprocess_kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>] = kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>]

    postprocess_kwargs = {}
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;top_k&quot;</span> <span class="hljs-keyword">in</span> kwargs:
        postprocess_kwargs[<span class="hljs-string">&quot;top_k&quot;</span>] = kwargs[<span class="hljs-string">&quot;top_k&quot;</span>]
    <span class="hljs-keyword">return</span> preprocess_kwargs, {}, postprocess_kwargs`,wrap:!1}}),X=new se({props:{title:"Adding it to the list of supported tasks",local:"adding-it-to-the-list-of-supported-tasks",headingTag:"h2"}}),q=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5waXBlbGluZXMlMjBpbXBvcnQlMjBQSVBFTElORV9SRUdJU1RSWSUwQSUwQVBJUEVMSU5FX1JFR0lTVFJZLnJlZ2lzdGVyX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMm5ldy10YXNrJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGlwZWxpbmVfY2xhc3MlM0RNeVBpcGVsaW5lJTJDJTBBJTIwJTIwJTIwJTIwcHRfbW9kZWwlM0RBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers.pipelines <span class="hljs-keyword">import</span> PIPELINE_REGISTRY

PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;new-task&quot;</span>,
    pipeline_class=MyPipeline,
    pt_model=AutoModelForSequenceClassification,
)`,wrap:!1}}),N=new w({props:{code:"UElQRUxJTkVfUkVHSVNUUlkucmVnaXN0ZXJfcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIybmV3LXRhc2slMjIlMkMlMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUzRE15UGlwZWxpbmUlMkMlMEElMjAlMjAlMjAlMjBwdF9tb2RlbCUzREF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMEElMjAlMjAlMjAlMjBkZWZhdWx0JTNEJTdCJTIycHQlMjIlM0ElMjAoJTIydXNlciUyRmF3ZXNvbWVfbW9kZWwlMjIlMkMlMjAlMjJhYmNkZWYlMjIpJTdEJTJDJTBBJTIwJTIwJTIwJTIwdHlwZSUzRCUyMnRleHQlMjIlMkMlMjAlMjAlMjMlMjBjdXJyZW50JTIwc3VwcG9ydCUyMHR5cGUlM0ElMjB0ZXh0JTJDJTIwYXVkaW8lMkMlMjBpbWFnZSUyQyUyMG11bHRpbW9kYWwlMEEp",highlighted:`PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;new-task&quot;</span>,
    pipeline_class=MyPipeline,
    pt_model=AutoModelForSequenceClassification,
    default={<span class="hljs-string">&quot;pt&quot;</span>: (<span class="hljs-string">&quot;user/awesome_model&quot;</span>, <span class="hljs-string">&quot;abcdef&quot;</span>)},
    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;text&quot;</span>,  <span class="hljs-comment"># current support type: text, audio, image, multimodal</span>
)`,wrap:!1}}),R=new se({props:{title:"Share your pipeline on the Hub",local:"share-your-pipeline-on-the-hub",headingTag:"h2"}}),E=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline


<span class="hljs-keyword">def</span> <span class="hljs-title function_">softmax</span>(<span class="hljs-params">outputs</span>):
    maxes = np.<span class="hljs-built_in">max</span>(outputs, axis=-<span class="hljs-number">1</span>, keepdims=<span class="hljs-literal">True</span>)
    shifted_exp = np.exp(outputs - maxes)
    <span class="hljs-keyword">return</span> shifted_exp / shifted_exp.<span class="hljs-built_in">sum</span>(axis=-<span class="hljs-number">1</span>, keepdims=<span class="hljs-literal">True</span>)


<span class="hljs-keyword">class</span> <span class="hljs-title class_">PairClassificationPipeline</span>(<span class="hljs-title class_ inherited__">Pipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
        preprocess_kwargs = {}
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;second_text&quot;</span> <span class="hljs-keyword">in</span> kwargs:
            preprocess_kwargs[<span class="hljs-string">&quot;second_text&quot;</span>] = kwargs[<span class="hljs-string">&quot;second_text&quot;</span>]
        <span class="hljs-keyword">return</span> preprocess_kwargs, {}, {}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess</span>(<span class="hljs-params">self, text, second_text=<span class="hljs-literal">None</span></span>):
        <span class="hljs-keyword">return</span> self.tokenizer(text, text_pair=second_text, return_tensors=self.framework)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, model_inputs</span>):
        <span class="hljs-keyword">return</span> self.model(**model_inputs)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs</span>):
        logits = model_outputs.logits[<span class="hljs-number">0</span>].numpy()
        probabilities = softmax(logits)

        best_class = np.argmax(probabilities)
        label = self.model.config.id2label[best_class]
        score = probabilities[best_class].item()
        logits = logits.tolist()
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;label&quot;</span>: label, <span class="hljs-string">&quot;score&quot;</span>: score, <span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),z=new w({props:{code:"ZnJvbSUyMHBhaXJfY2xhc3NpZmljYXRpb24lMjBpbXBvcnQlMjBQYWlyQ2xhc3NpZmljYXRpb25QaXBlbGluZSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMucGlwZWxpbmVzJTIwaW1wb3J0JTIwUElQRUxJTkVfUkVHSVNUUlklMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyQyUyMFRGQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQVBJUEVMSU5FX1JFR0lTVFJZLnJlZ2lzdGVyX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMnBhaXItY2xhc3NpZmljYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUzRFBhaXJDbGFzc2lmaWNhdGlvblBpcGVsaW5lJTJDJTBBJTIwJTIwJTIwJTIwcHRfbW9kZWwlM0RBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTBBJTIwJTIwJTIwJTIwdGZfbW9kZWwlM0RURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> pair_classification <span class="hljs-keyword">import</span> PairClassificationPipeline
<span class="hljs-keyword">from</span> transformers.pipelines <span class="hljs-keyword">import</span> PIPELINE_REGISTRY
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, TFAutoModelForSequenceClassification

PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;pair-classification&quot;</span>,
    pipeline_class=PairClassificationPipeline,
    pt_model=AutoModelForSequenceClassification,
    tf_model=TFAutoModelForSequenceClassification,
)`,wrap:!1}}),Y=new w({props:{code:"JTIwJTIwJTIyY3VzdG9tX3BpcGVsaW5lcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnBhaXItY2xhc3NpZmljYXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJpbXBsJTIyJTNBJTIwJTIycGFpcl9jbGFzc2lmaWNhdGlvbi5QYWlyQ2xhc3NpZmljYXRpb25QaXBlbGluZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnB0JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnRmJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyVEZBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTdEJTJD",highlighted:`  <span class="hljs-attr">&quot;custom_pipelines&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;pair-classification&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;impl&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;pair_classification.PairClassificationPipeline&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;pt&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-string">&quot;AutoModelForSequenceClassification&quot;</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;tf&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-string">&quot;TFAutoModelForSequenceClassification&quot;</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>`,wrap:!1}}),F=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUyMnBhaXItY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMnNndWdnZXIlMkZmaW5ldHVuZWQtYmVydC1tcnBjJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(<span class="hljs-string">&quot;pair-classification&quot;</span>, model=<span class="hljs-string">&quot;sgugger/finetuned-bert-mrpc&quot;</span>)`,wrap:!1}}),L=new w({props:{code:"Y2xhc3NpZmllci5wdXNoX3RvX2h1YiglMjJ0ZXN0LWR5bmFtaWMtcGlwZWxpbmUlMjIp",highlighted:'classifier.push_to_hub(<span class="hljs-string">&quot;test-dynamic-pipeline&quot;</span>)',wrap:!1}}),D=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRnRlc3QtZHluYW1pYy1waXBlbGluZSUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(model=<span class="hljs-string">&quot;{your_username}/test-dynamic-pipeline&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),K=new se({props:{title:"Add the pipeline to 🤗 Transformers",local:"add-the-pipeline-to--transformers",headingTag:"h2"}}),ns=new Ne({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/add_new_pipeline.md"}}),{c(){T=p("meta"),os=a(),ps=p("p"),rs=a(),r(m.$$.fragment),cs=a(),h=p("p"),h.innerHTML=le,Ms=a(),J=p("p"),J.innerHTML=te,ds=a(),j=p("p"),j.innerHTML=ae,ys=a(),f=p("p"),f.innerHTML=ne,us=a(),r(U.$$.fragment),ws=a(),I=p("p"),I.textContent=pe,Ts=a(),b=p("p"),b.innerHTML=ie,ms=a(),B=p("p"),B.innerHTML=oe,hs=a(),C=p("p"),C.innerHTML=re,Js=a(),_=p("p"),_.innerHTML=ce,js=a(),k=p("p"),k.innerHTML=Me,fs=a(),g=p("p"),g.innerHTML=de,Us=a(),r(Z.$$.fragment),Is=a(),A=p("p"),A.innerHTML=ye,bs=a(),r(G.$$.fragment),Bs=a(),V=p("p"),V.textContent=ue,Cs=a(),r(X.$$.fragment),_s=a(),H=p("p"),H.innerHTML=we,ks=a(),r(q.$$.fragment),gs=a(),W=p("p"),W.innerHTML=Te,Zs=a(),r(N.$$.fragment),As=a(),r(R.$$.fragment),Gs=a(),v=p("p"),v.innerHTML=me,Vs=a(),r(E.$$.fragment),Xs=a(),$=p("p"),$.innerHTML=he,Hs=a(),r(z.$$.fragment),qs=a(),x=p("p"),x.innerHTML=Je,Ws=a(),r(Y.$$.fragment),Ns=a(),Q=p("p"),Q.innerHTML=je,Rs=a(),r(F.$$.fragment),vs=a(),S=p("p"),S.innerHTML=fe,Es=a(),r(L.$$.fragment),$s=a(),P=p("p"),P.innerHTML=Ue,zs=a(),r(D.$$.fragment),xs=a(),r(K.$$.fragment),Ys=a(),O=p("p"),O.innerHTML=Ie,Qs=a(),ss=p("p"),ss.innerHTML=be,Fs=a(),es=p("p"),es.innerHTML=Be,Ss=a(),ls=p("p"),ls.innerHTML=Ce,Ls=a(),ts=p("p"),ts.innerHTML=_e,Ps=a(),as=p("ul"),as.innerHTML=ke,Ds=a(),r(ns.$$.fragment),Ks=a(),is=p("p"),this.h()},l(s){const e=qe("svelte-u9bgzb",document.head);T=i(e,"META",{name:!0,content:!0}),e.forEach(l),os=n(s),ps=i(s,"P",{}),ge(ps).forEach(l),rs=n(s),c(m.$$.fragment,s),cs=n(s),h=i(s,"P",{"data-svelte-h":!0}),o(h)!=="svelte-rbtu2p"&&(h.innerHTML=le),Ms=n(s),J=i(s,"P",{"data-svelte-h":!0}),o(J)!=="svelte-oxa02l"&&(J.innerHTML=te),ds=n(s),j=i(s,"P",{"data-svelte-h":!0}),o(j)!=="svelte-6dmyza"&&(j.innerHTML=ae),ys=n(s),f=i(s,"P",{"data-svelte-h":!0}),o(f)!=="svelte-yoim0k"&&(f.innerHTML=ne),us=n(s),c(U.$$.fragment,s),ws=n(s),I=i(s,"P",{"data-svelte-h":!0}),o(I)!=="svelte-byrozk"&&(I.textContent=pe),Ts=n(s),b=i(s,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1f1lssz"&&(b.innerHTML=ie),ms=n(s),B=i(s,"P",{"data-svelte-h":!0}),o(B)!=="svelte-12jiwrp"&&(B.innerHTML=oe),hs=n(s),C=i(s,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1ev1pra"&&(C.innerHTML=re),Js=n(s),_=i(s,"P",{"data-svelte-h":!0}),o(_)!=="svelte-wbhsl3"&&(_.innerHTML=ce),js=n(s),k=i(s,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1rxvpik"&&(k.innerHTML=Me),fs=n(s),g=i(s,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1jbvi33"&&(g.innerHTML=de),Us=n(s),c(Z.$$.fragment,s),Is=n(s),A=i(s,"P",{"data-svelte-h":!0}),o(A)!=="svelte-nsc0of"&&(A.innerHTML=ye),bs=n(s),c(G.$$.fragment,s),Bs=n(s),V=i(s,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1r0sy2p"&&(V.textContent=ue),Cs=n(s),c(X.$$.fragment,s),_s=n(s),H=i(s,"P",{"data-svelte-h":!0}),o(H)!=="svelte-3jotdg"&&(H.innerHTML=we),ks=n(s),c(q.$$.fragment,s),gs=n(s),W=i(s,"P",{"data-svelte-h":!0}),o(W)!=="svelte-491gz1"&&(W.innerHTML=Te),Zs=n(s),c(N.$$.fragment,s),As=n(s),c(R.$$.fragment,s),Gs=n(s),v=i(s,"P",{"data-svelte-h":!0}),o(v)!=="svelte-12i9yqr"&&(v.innerHTML=me),Vs=n(s),c(E.$$.fragment,s),Xs=n(s),$=i(s,"P",{"data-svelte-h":!0}),o($)!=="svelte-79m3fw"&&($.innerHTML=he),Hs=n(s),c(z.$$.fragment,s),qs=n(s),x=i(s,"P",{"data-svelte-h":!0}),o(x)!=="svelte-14qyyu6"&&(x.innerHTML=Je),Ws=n(s),c(Y.$$.fragment,s),Ns=n(s),Q=i(s,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1o1fy6m"&&(Q.innerHTML=je),Rs=n(s),c(F.$$.fragment,s),vs=n(s),S=i(s,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1rhc9p2"&&(S.innerHTML=fe),Es=n(s),c(L.$$.fragment,s),$s=n(s),P=i(s,"P",{"data-svelte-h":!0}),o(P)!=="svelte-m8nvb"&&(P.innerHTML=Ue),zs=n(s),c(D.$$.fragment,s),xs=n(s),c(K.$$.fragment,s),Ys=n(s),O=i(s,"P",{"data-svelte-h":!0}),o(O)!=="svelte-wriqax"&&(O.innerHTML=Ie),Qs=n(s),ss=i(s,"P",{"data-svelte-h":!0}),o(ss)!=="svelte-1wx7ut0"&&(ss.innerHTML=be),Fs=n(s),es=i(s,"P",{"data-svelte-h":!0}),o(es)!=="svelte-1by38ya"&&(es.innerHTML=Be),Ss=n(s),ls=i(s,"P",{"data-svelte-h":!0}),o(ls)!=="svelte-1cftve5"&&(ls.innerHTML=Ce),Ls=n(s),ts=i(s,"P",{"data-svelte-h":!0}),o(ts)!=="svelte-17fu767"&&(ts.innerHTML=_e),Ps=n(s),as=i(s,"UL",{"data-svelte-h":!0}),o(as)!=="svelte-9p61si"&&(as.innerHTML=ke),Ds=n(s),c(ns.$$.fragment,s),Ks=n(s),is=i(s,"P",{}),ge(is).forEach(l),this.h()},h(){Ze(T,"name","hf:doc:metadata"),Ze(T,"content",ve)},m(s,e){We(document.head,T),t(s,os,e),t(s,ps,e),t(s,rs,e),M(m,s,e),t(s,cs,e),t(s,h,e),t(s,Ms,e),t(s,J,e),t(s,ds,e),t(s,j,e),t(s,ys,e),t(s,f,e),t(s,us,e),M(U,s,e),t(s,ws,e),t(s,I,e),t(s,Ts,e),t(s,b,e),t(s,ms,e),t(s,B,e),t(s,hs,e),t(s,C,e),t(s,Js,e),t(s,_,e),t(s,js,e),t(s,k,e),t(s,fs,e),t(s,g,e),t(s,Us,e),M(Z,s,e),t(s,Is,e),t(s,A,e),t(s,bs,e),M(G,s,e),t(s,Bs,e),t(s,V,e),t(s,Cs,e),M(X,s,e),t(s,_s,e),t(s,H,e),t(s,ks,e),M(q,s,e),t(s,gs,e),t(s,W,e),t(s,Zs,e),M(N,s,e),t(s,As,e),M(R,s,e),t(s,Gs,e),t(s,v,e),t(s,Vs,e),M(E,s,e),t(s,Xs,e),t(s,$,e),t(s,Hs,e),M(z,s,e),t(s,qs,e),t(s,x,e),t(s,Ws,e),M(Y,s,e),t(s,Ns,e),t(s,Q,e),t(s,Rs,e),M(F,s,e),t(s,vs,e),t(s,S,e),t(s,Es,e),M(L,s,e),t(s,$s,e),t(s,P,e),t(s,zs,e),M(D,s,e),t(s,xs,e),M(K,s,e),t(s,Ys,e),t(s,O,e),t(s,Qs,e),t(s,ss,e),t(s,Fs,e),t(s,es,e),t(s,Ss,e),t(s,ls,e),t(s,Ls,e),t(s,ts,e),t(s,Ps,e),t(s,as,e),t(s,Ds,e),M(ns,s,e),t(s,Ks,e),t(s,is,e),Os=!0},p:Ge,i(s){Os||(d(m.$$.fragment,s),d(U.$$.fragment,s),d(Z.$$.fragment,s),d(G.$$.fragment,s),d(X.$$.fragment,s),d(q.$$.fragment,s),d(N.$$.fragment,s),d(R.$$.fragment,s),d(E.$$.fragment,s),d(z.$$.fragment,s),d(Y.$$.fragment,s),d(F.$$.fragment,s),d(L.$$.fragment,s),d(D.$$.fragment,s),d(K.$$.fragment,s),d(ns.$$.fragment,s),Os=!0)},o(s){y(m.$$.fragment,s),y(U.$$.fragment,s),y(Z.$$.fragment,s),y(G.$$.fragment,s),y(X.$$.fragment,s),y(q.$$.fragment,s),y(N.$$.fragment,s),y(R.$$.fragment,s),y(E.$$.fragment,s),y(z.$$.fragment,s),y(Y.$$.fragment,s),y(F.$$.fragment,s),y(L.$$.fragment,s),y(D.$$.fragment,s),y(K.$$.fragment,s),y(ns.$$.fragment,s),Os=!1},d(s){s&&(l(os),l(ps),l(rs),l(cs),l(h),l(Ms),l(J),l(ds),l(j),l(ys),l(f),l(us),l(ws),l(I),l(Ts),l(b),l(ms),l(B),l(hs),l(C),l(Js),l(_),l(js),l(k),l(fs),l(g),l(Us),l(Is),l(A),l(bs),l(Bs),l(V),l(Cs),l(_s),l(H),l(ks),l(gs),l(W),l(Zs),l(As),l(Gs),l(v),l(Vs),l(Xs),l($),l(Hs),l(qs),l(x),l(Ws),l(Ns),l(Q),l(Rs),l(vs),l(S),l(Es),l($s),l(P),l(zs),l(xs),l(Ys),l(O),l(Qs),l(ss),l(Fs),l(es),l(Ss),l(ls),l(Ls),l(ts),l(Ps),l(as),l(Ds),l(Ks),l(is)),l(T),u(m,s),u(U,s),u(Z,s),u(G,s),u(X,s),u(q,s),u(N,s),u(R,s),u(E,s),u(z,s),u(Y,s),u(F,s),u(L,s),u(D,s),u(K,s),u(ns,s)}}}const ve='{"title":"How to create a custom pipeline?","local":"how-to-create-a-custom-pipeline","sections":[{"title":"Adding it to the list of supported tasks","local":"adding-it-to-the-list-of-supported-tasks","sections":[],"depth":2},{"title":"Share your pipeline on the Hub","local":"share-your-pipeline-on-the-hub","sections":[],"depth":2},{"title":"Add the pipeline to 🤗 Transformers","local":"add-the-pipeline-to--transformers","sections":[],"depth":2}],"depth":1}';function Ee(ee){return Ve(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qe extends Xe{constructor(T){super(),He(this,T,Ee,Re,Ae,{})}}export{Qe as component};
