import{s as xw,o as Jw,n as x}from"../chunks/scheduler.9bc65507.js";import{S as Uw,i as Bw,g as a,s as n,r as p,A as Iw,h as l,f as s,c as r,j as T,u as m,x as y,k as v,y as t,a as d,v as u,d as g,t as h,w as f}from"../chunks/index.707bf1b6.js";import{T as bn}from"../chunks/Tip.c2ecdbf4.js";import{D as M}from"../chunks/Docstring.17db21ae.js";import{C as J}from"../chunks/CodeBlock.54a9f38d.js";import{E as B}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as O}from"../chunks/Heading.342b1fa6.js";function Zw(j){let i,$=`This logits processor is exclusively compatible with
<a href="https://huggingface.co/docs/transformers/en/model_doc/bark" rel="nofollow">Bark</a>’s fine submodel. See the model documentation
for examples.`;return{c(){i=a("p"),i.innerHTML=$},l(b){i=l(b,"P",{"data-svelte-h":!0}),y(i)!=="svelte-nbt45a"&&(i.innerHTML=$)},m(b,_){d(b,i,_)},p:x,d(b){b&&s(i)}}}function zw(j){let i,$=`This logits processor is exclusively compatible with
<a href="https://huggingface.co/docs/transformers/main/en/model_doc/musicgen" rel="nofollow">MusicGen</a>`;return{c(){i=a("p"),i.innerHTML=$},l(b){i=l(b,"P",{"data-svelte-h":!0}),y(i)!=="svelte-1uojnuk"&&(i.innerHTML=$)},m(b,_){d(b,i,_)},p:x,d(b){b&&s(i)}}}function Ww(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoJTBBJTIwJTIwJTIwJTIwdGV4dCUzRCU1QiUyMjgwcyUyMHBvcCUyMHRyYWNrJTIwd2l0aCUyMGJhc3N5JTIwZHJ1bXMlMjBhbmQlMjBzeW50aCUyMiUyQyUyMCUyMjkwcyUyMHJvY2slMjBzb25nJTIwd2l0aCUyMGxvdWQlMjBndWl0YXJzJTIwYW5kJTIwaGVhdnklMjBkcnVtcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSklMEFhdWRpb192YWx1ZXMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1Nik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s pop track with bassy drums and synth&quot;</span>, <span class="hljs-string">&quot;90s rock song with loud guitars and heavy drums&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,b,k),u(_,o,k),w=!0},p:x,i(o){w||(g(_.$$.fragment,o),w=!0)},o(o){h(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(b)),f(_,o)}}}function Vw(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkFsaWNlJTNBJTIwSSUyMGxvdmUlMjBjYXRzLiUyMFdoYXQlMjBkbyUyMHlvdSUyMGxvdmUlM0YlNUNuQm9iJTNBJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwZ3JlZWR5JTIwZGVjb2RpbmclMkMlMjB3ZSUyMHNlZSUyMEJvYiUyMHJlcGVhdGluZyUyMEFsaWNlJ3MlMjBvcGluaW9uLiUyMElmJTIwQm9iJTIwd2FzJTIwYSUyMGNoYXRib3QlMkMlMjBpdCUyMHdvdWxkJTIwYmUlMjBhJTIwcG9vciUyMG9uZS4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwdGhpcyUyMGxvZ2l0cyUyMHByb2Nlc3NvciUyQyUyMHdlJTIwY2FuJTIwcHJldmVudCUyMEJvYiUyMGZyb20lMjByZXBlYXRpbmclMjBBbGljZSdzJTIwb3Bpbmlvbi4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBlbmNvZGVyX25vX3JlcGVhdF9uZ3JhbV9zaXplJTNEMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Alice: I love cats. What do you love?\\nBob:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With greedy decoding, we see Bob repeating Alice&#x27;s opinion. If Bob was a chatbot, it would be a poor one.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice: I love cats. What do you love?
Bob: I love cats. What do you

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With this logits processor, we can prevent Bob from repeating Alice&#x27;s opinion.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, encoder_no_repeat_ngram_size=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice: I love cats. What do you love?
Bob: My cats are very cute.`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,b,k),u(_,o,k),w=!0},p:x,i(o){w||(g(_.$$.fragment,o),w=!0)},o(o){h(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(b)),f(_,o)}}}function Lw(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkFsaWNlJTIwYW5kJTIwQm9iLiUyMFRoZSUyMHRoaXJkJTIwbWVtYmVyJ3MlMjBuYW1lJTIwd2FzJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwdGhlJTIwJTYwZW5jb2Rlcl9yZXBldGl0aW9uX3BlbmFsdHklNjAlMjBhcmd1bWVudCUyMHdlJTIwY2FuJTIwdHJpZ2dlciUyMHRoaXMlMjBsb2dpdHMlMjBwcm9jZXNzb3IlMjBpbiUyMCU2MGdlbmVyYXRlJTYwJTJDJTIwd2hpY2glMjBjYW4lMEElMjMlMjBwcm9tb3RlJTIwdGhlJTIwdXNlJTIwb2YlMjBwcm9tcHQlMjB0b2tlbnMlMjAoJTIyQm9iJTIyJTIwaW4lMjB0aGlzJTIwZXhhbXBsZSklMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBlbmNvZGVyX3JlcGV0aXRpb25fcGVuYWx0eSUzRDEuMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Alice and Bob. The third member&#x27;s name was&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob. The third membe<span class="hljs-string">r&#x27;s name was not mentioned.

&gt;&gt;&gt; # With the \`encoder_repetition_penalty\` argument we can trigger this logits processor in \`generate\`, which can
&gt;&gt;&gt; # promote the use of prompt tokens (&quot;Bob&quot; in this example)
&gt;&gt;&gt; gen_out = model.generate(**inputs, encoder_repetition_penalty=1.2)
&gt;&gt;&gt; print(tokenizer.batch_decode(gen_out, skip_special_tokens=True)[0])
Alice and Bob. The third member&#x27;</span>s name was Bob. The third membe<span class="hljs-string">r&#x27;s name was Bob.</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,b,k),u(_,o,k),w=!0},p:x,i(o){w||(g(_.$$.fragment,o),w=!0)},o(o){h(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(b)),f(_,o)}}}function Cw(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBzZXF1ZW5jZSUzQSUyMDElMkMlMjAyJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBpcyUyMHVuZXhwZWN0ZWQlMjAtLSUyMHNvbWV0aW1lcyUyMHRvbyUyMHVuZXhwZWN0ZWQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMFdpdGglMjBlcHNpbG9uJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBnZXRzJTIwcmVzdHJpY3RlZCUyMHRvJTIwaGlnaC1wcm9iYWJpbGl0eSUyMHRva2Vucy4lMjBOb3RlJTIwdGhhdCUyMHRoaXMlMjBpcyUyMHNpbWlsYXIlMjB0byUwQSUyMyUyMFRvcCUyMFAlMjBzYW1wbGluZyUyQyUyMHdoaWNoJTIwcmVzdHJpY3RzJTIwdG9rZW5zJTIwYmFzZWQlMjBvbiUyMHRoZWlyJTIwY3VtdWxhdGl2ZSUyMHByb2JhYmlsaXR5LiUwQSUyMyUyMFBybyUyMHRpcCUzQSUyMFRoZSUyMHBhcGVyJTIwcmVjb21lbmRzJTIwdXNpbmclMjAlNjBlcHNpbG9uX2N1dG9mZiU2MCUyMHZhbHVlcyUyMGJldHdlZW4lMjAzZS00JTIwYW5kJTIwOWUtNCUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBlcHNpbG9uX2N1dG9mZiUzRDAuMSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2.</span> <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With epsilon sampling, the output gets restricted to high-probability tokens. Note that this is similar to</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Top P sampling, which restricts tokens based on their cumulative probability.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: The paper recomends using \`epsilon_cutoff\` values between 3e-4 and 9e-4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, epsilon_cutoff=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,b,k),u(_,o,k),w=!0},p:x,i(o){w||(g(_.$$.fragment,o),w=!0)},o(o){h(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(b)),f(_,o)}}}function Fw(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBzZXF1ZW5jZSUzQSUyMDElMkMlMjAyJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBpcyUyMHVuZXhwZWN0ZWQlMjAtLSUyMHNvbWV0aW1lcyUyMHRvbyUyMHVuZXhwZWN0ZWQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMFdpdGglMjBldGElMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGdldHMlMjByZXN0cmljdGVkJTIwdG8lMjBoaWdoLXByb2JhYmlsaXR5JTIwdG9rZW5zLiUyMFlvdSUyMGNhbiUyMHNlZSUyMGl0JTIwYXMlMjBhJTIwZHluYW1pYyUyMGZvcm0lMjBvZiUwQSUyMyUyMGVwc2lsb24lMjBzYW1wbGluZyUyMHRoYXQlMjBhZGFwdHMlMjBpdHMlMjBjdXRvZmYlMjBwcm9iYWJpbGl0eSUyMGJhc2VkJTIwb24lMjB0aGUlMjBlbnRyb3B5JTIwKGhpZ2glMjBlbnRyb3B5JTIwJTNEJTIwbG93ZXIlMjBjdXRvZmYpLiUwQSUyMyUyMFBybyUyMHRpcCUzQSUyMFRoZSUyMHBhcGVyJTIwcmVjb21lbmRzJTIwdXNpbmclMjAlNjBldGFfY3V0b2ZmJTYwJTIwdmFsdWVzJTIwYmV0d2VlbiUyMDNlLTQlMjB0byUyMDRlLTMlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwZXRhX2N1dG9mZiUzRDAuMSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2.</span> <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With eta sampling, the output gets restricted to high-probability tokens. You can see it as a dynamic form of</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># epsilon sampling that adapts its cutoff probability based on the entropy (high entropy = lower cutoff).</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: The paper recomends using \`eta_cutoff\` values between 3e-4 to 4e-3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, eta_cutoff=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,b,k),u(_,o,k),w=!0},p:x,i(o){w||(g(_.$$.fragment,o),w=!0)},o(o){h(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(b)),f(_,o)}}}function Gw(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;Just wanted to let you know, I&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Let&#x27;s consider that we want short sentences, so we limit \`max_length=30\`. However, we observe that the answer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># tends to end abruptly.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.9</span>, max_length=<span class="hljs-number">30</span>, pad_token_id=<span class="hljs-number">50256</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network which was
published <span class="hljs-keyword">in</span> <span class="hljs-number">2010.</span> Although

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To promote the appearance of the EOS token at the right time, we add the \`exponential_decay_length_penalty =</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># (start_index, decay_factor)\`. Instead of cutting at max_tokens, the output comes to an end before and usually</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with more meaning. What happens is that starting from \`start_index\` the EOS token score will be increased</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># by \`decay_factor\` exponentially. However, if you set a high decay factor, you may also end up with abruptly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># ending sequences.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.9</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    pad_token_id=<span class="hljs-number">50256</span>,
<span class="hljs-meta">... </span>    exponential_decay_length_penalty=(<span class="hljs-number">15</span>, <span class="hljs-number">1.6</span>),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network
which&lt;|endoftext|&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With a small decay factor, you will have a higher chance of getting a meaningful sequence.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.9</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    pad_token_id=<span class="hljs-number">50256</span>,
<span class="hljs-meta">... </span>    exponential_decay_length_penalty=(<span class="hljs-number">15</span>, <span class="hljs-number">1.01</span>),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network which was
published <span class="hljs-keyword">in</span> <span class="hljs-number">2010.</span>&lt;|endoftext|&gt;`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,b,k),u(_,o,k),w=!0},p:x,i(o){w||(g(_.$$.fragment,o),w=!0)},o(o){h(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(b)),f(_,o)}}}function Xw(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZmxhbi10NS1zbWFsbCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZmbGFuLXQ1LXNtYWxsJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJUcmFuc2xhdGUlMjBmcm9tJTIwRW5nbGlzaCUyMHRvJTIwR2VybWFuJTNBJTIwSSUyMGxvdmUlMjBjYXRzLiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwQnklMjBkZWZhdWx0JTJDJTIwaXQlMjBjb250aW51ZXMlMjBnZW5lcmF0aW5nJTIwYWNjb3JkaW5nJTIwdG8lMjB0aGUlMjBtb2RlbCdzJTIwbG9naXRzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMpJTVCMCU1RCklMEElMEElMjMlMjBXZSUyMGNhbiUyMHVzZSUyMCU2MGZvcmNlZF9ib3NfdG9rZW5faWQlNjAlMjB0byUyMGZvcmNlJTIwdGhlJTIwc3RhcnQlMjBvZiUyMGdlbmVyYXRpb24lMjB3aXRoJTIwYW4lMjBlbmNvZGVyLWRlY29kZXIlMjBtb2RlbCUwQSUyMyUyMChpbmNsdWRpbmclMjBmb3JjaW5nJTIwaXQlMjB0byUyMGVuZCUyMHN0cmFpZ2h0JTIwYXdheSUyMHdpdGglMjBhbiUyMEVPUyUyMHRva2VuKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAlMkMlMjBmb3JjZWRfYm9zX3Rva2VuX2lkJTNEdG9rZW5pemVyLmVvc190b2tlbl9pZCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Translate from English to German: I love cats.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
&lt;pad&gt; Ich liebe Kitty.&lt;/s&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can use \`forced_bos_token_id\` to force the start of generation with an encoder-decoder model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># (including forcing it to end straight away with an EOS token)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, forced_bos_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
&lt;pad&gt;&lt;/s&gt;`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,b,k),u(_,o,k),w=!0},p:x,i(o){w||(g(_.$$.fragment,o),w=!0)},o(o){h(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(b)),f(_,o)}}}function Rw(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMkMlMjAzJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBCeSUyMGRlZmF1bHQlMkMlMjBpdCUyMGNvbnRpbnVlcyUyMGdlbmVyYXRpbmclMjBhY2NvcmRpbmclMjB0byUyMHRoZSUyMG1vZGVsJ3MlMjBsb2dpdHMlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyklNUIwJTVEKSUwQSUwQSUyMyUyMCU2MGZvcmNlZF9lb3NfdG9rZW5faWQlNjAlMjBlbnN1cmVzJTIwdGhlJTIwZ2VuZXJhdGlvbiUyMGVuZHMlMjB3aXRoJTIwYSUyMEVPUyUyMHRva2VuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCUyQyUyMGZvcmNlZF9lb3NfdG9rZW5faWQlM0R0b2tlbml6ZXIuZW9zX3Rva2VuX2lkKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># \`forced_eos_token_id\` ensures the generation ends with a EOS token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, forced_eos_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>,&lt;|endoftext|&gt;`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,b,k),u(_,o,k),w=!0},p:x,i(o){w||(g(_.$$.fragment,o),w=!0)},o(o){h(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(b)),f(_,o)}}}function Ew(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This Whisper model forces the generation to start with \`50362\` at the first position by default, i.e.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># \`&quot;forced_decoder_ids&quot;: [[1, 50362]]\`. This means all other tokens are masked out.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>    <span class="hljs-built_in">all</span>(outputs.scores[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>, i] == <span class="hljs-built_in">float</span>(<span class="hljs-string">&quot;-inf&quot;</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(processor.tokenizer.vocab_size) <span class="hljs-keyword">if</span> i != <span class="hljs-number">50362</span>)
<span class="hljs-meta">... </span>)
<span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50362</span>])
tensor(<span class="hljs-number">0.</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we disable \`forced_decoder_ids\`, we stop seeing that effect</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>, forced_decoder_ids=<span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>    <span class="hljs-built_in">all</span>(outputs.scores[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>, i] == <span class="hljs-built_in">float</span>(<span class="hljs-string">&quot;-inf&quot;</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(processor.tokenizer.vocab_size) <span class="hljs-keyword">if</span> i != <span class="hljs-number">50362</span>)
<span class="hljs-meta">... </span>)
<span class="hljs-literal">False</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50362</span>])
tensor(<span class="hljs-number">19.3140</span>)`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,b,k),u(_,o,k),w=!0},p:x,i(o){w||(g(_.$$.fragment,o),w=!0)},o(o){h(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(b)),f(_,o)}}}function Nw(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initialize the model and tokenizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># A long text about the solar system</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;The Solar System is a gravitationally bound system comprising the Sun and the objects that orbit it, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;either directly or indirectly. Of the objects that orbit the Sun directly, the largest are the eight &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;planets, with the remainder being smaller objects, such as the five dwarf planets and small Solar System &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;bodies. The Solar System formed 4.6 billion years ago from the gravitational collapse of a giant &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;interstellar molecular cloud.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;summarize: &quot;</span> + text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate diverse summary</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs_diverse = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    num_beam_groups=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    diversity_penalty=<span class="hljs-number">10.0</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summaries_diverse = tokenizer.batch_decode(outputs_diverse, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate non-diverse summary</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs_non_diverse = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_non_diverse = tokenizer.batch_decode(outputs_non_diverse, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`diversity_penalty\`, the resulting beams are much more diverse</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(summary_non_diverse)
[<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>,
<span class="hljs-string">&#x27;the Solar System formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(summaries_diverse)
[<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>,
<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets. the rest of the objects are smaller objects, such as the five dwarf planets and small solar system bodies.&#x27;</span>]`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,b,k),u(_,o,k),w=!0},p:x,i(o){w||(g(_.$$.fragment,o),w=!0)},o(o){h(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(b)),f(_,o)}}}function Sw(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxncHQyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJBJTIwc2VxdWVuY2UlM0ElMjAxJTJDJTIwMiUyQyUyMDMlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMEJ5JTIwZGVmYXVsdCUyQyUyMHRoZSUyMHNjb3JlcyUyMGFyZSUyMG5vdCUyMG5vcm1hbGl6ZWQlMjAtLSUyMHRoZSUyMHN1bSUyMG9mJTIwdGhlaXIlMjBleHBvbmVudGlhbHMlMjBpcyUyME5PVCUyMGElMjBub3JtYWxpemVkJTIwcHJvYmFiaWxpdHklMEElMjMlMjBkaXN0cmlidXRpb24lMkMlMjBzdW1taW5nJTIwdG8lMjAxJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUpJTBBcHJpbnQodG9yY2guc3VtKHRvcmNoLmV4cChvdXRwdXRzLnNjb3JlcyU1Qi0xJTVEKSkpJTBBJTBBJTIzJTIwTm9ybWFsaXppbmclMjB0aGVtJTIwbWF5JTIwaGF2ZSUyMGElMjBwb3NpdGl2ZSUyMGltcGFjdCUyMG9uJTIwYmVhbSUyMG1ldGhvZHMlMkMlMjBvciUyMHdoZW4lMjB1c2luZyUyMHRoZSUyMHNjb3JlcyUyMG9uJTIweW91ciUyMGFwcGxpY2F0aW9uJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwcmVub3JtYWxpemVfbG9naXRzJTNEVHJ1ZSUyQyUyMHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSUyQyUyMG91dHB1dF9zY29yZXMlM0RUcnVlKSUwQXByaW50KHRvcmNoLnN1bSh0b3JjaC5leHAob3V0cHV0cy5zY29yZXMlNUItMSU1RCkpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the scores are not normalized -- the sum of their exponentials is NOT a normalized probability</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># distribution, summing to 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(torch.<span class="hljs-built_in">sum</span>(torch.exp(outputs.scores[-<span class="hljs-number">1</span>])))
tensor(<span class="hljs-number">816.3250</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Normalizing them may have a positive impact on beam methods, or when using the scores on your application</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, renormalize_logits=<span class="hljs-literal">True</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(torch.<span class="hljs-built_in">sum</span>(torch.exp(outputs.scores[-<span class="hljs-number">1</span>])))
tensor(<span class="hljs-number">1.0000</span>)`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,b,k),u(_,o,k),w=!0},p:x,i(o){w||(g(_.$$.fragment,o),w=!0)},o(o){h(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(b)),f(_,o)}}}function qw(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBudW1iZXIlM0ElMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMHNldHRpbmclMjAlNjBtaW5fbGVuZ3RoJTYwJTIwdG8lMjBhJTIwdmFsdWUlMjBzbWFsbGVyJTIwdGhhbiUyMHRoZSUyMHVuY29udHJvbGxlZCUyMG91dHB1dCUyMGxlbmd0aCUyMGhhcyUyMG5vJTIwaW1wYWN0JTBBZ2VuX291dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWluX2xlbmd0aCUzRDMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBzZXR0aW5nJTIwYSUyMGxhcmdlciUyMCU2MG1pbl9sZW5ndGglNjAlMjB3aWxsJTIwZm9yY2UlMjB0aGUlMjBtb2RlbCUyMHRvJTIwZ2VuZXJhdGUlMjBiZXlvbmQlMjBpdHMlMjBuYXR1cmFsJTIwZW5kaW5nJTIwcG9pbnQlMkMlMjB3aGljaCUyMGlzJTIwbm90JTBBJTIzJTIwbmVjZXNzYXJpbHklMjBpbmNvcnJlY3QlMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtaW5fbGVuZ3RoJTNEMTApJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A number:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting \`min_length\` to a value smaller than the uncontrolled output length has no impact</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_length=<span class="hljs-number">3</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting a larger \`min_length\` will force the model to generate beyond its natural ending point, which is not</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># necessarily incorrect</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_length=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one thousand, nine hundred <span class="hljs-keyword">and</span> ninety-four`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,b,k),u(_,o,k),w=!0},p:x,i(o){w||(g(_.$$.fragment,o),w=!0)},o(o){h(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(b)),f(_,o)}}}function Hw(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkElMjBudW1iZXIlM0ElMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMHNldHRpbmclMjAlNjBtaW5fbmV3X3Rva2VucyU2MCUyMHdpbGwlMjBmb3JjZSUyMHRoZSUyMG1vZGVsJTIwdG8lMjBnZW5lcmF0ZSUyMGJleW9uZCUyMGl0cyUyMG5hdHVyYWwlMjBlbmRpbmclMjBwb2ludCUyQyUyMHdoaWNoJTIwaXMlMjBub3QlMEElMjMlMjBuZWNlc3NhcmlseSUyMGluY29ycmVjdCUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1pbl9uZXdfdG9rZW5zJTNEMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;A number:&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting \`min_new_tokens\` will force the model to generate beyond its natural ending point, which is not</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># necessarily incorrect</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_new_tokens=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one thousand`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,b,k),u(_,o,k),w=!0},p:x,i(o){w||(g(_.$$.fragment,o),w=!0)},o(o){h(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(b)),f(_,o)}}}function Dw(j){let i,$=`In order to get the token ids of the words that should not appear in the generated text, make sure to set
<code>add_prefix_space=True</code> when initializing the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The <code>add_prefix_space</code> argument is only supported for some slow tokenizers,
as fast tokenizers’ prefixing behaviours come from <code>pre tokenizers</code>. Read more
<a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`;return{c(){i=a("p"),i.innerHTML=$},l(b){i=l(b,"P",{"data-svelte-h":!0}),y(i)!=="svelte-15bvr1j"&&(i.innerHTML=$)},m(b,_){d(b,i,_)},p:x,d(b){b&&s(i)}}}function Pw(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;In a word, the cake is a&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">5</span>, pad_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(output_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a mess.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s take the bad words out. Please note that the tokenizer is initialized differently</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_with_prefix_space = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens_as_list</span>(<span class="hljs-params">word_list</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Converts a sequence of words into a list of tokens&quot;</span>
<span class="hljs-meta">... </span>    tokens_list = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_list:
<span class="hljs-meta">... </span>        tokenized_word = tokenizer_with_prefix_space([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>        tokens_list.append(tokenized_word)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokens_list


<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = get_tokens_as_list(word_list=[<span class="hljs-string">&quot;mess&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>output_ids = model.generate(
<span class="hljs-meta">... </span>    inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">5</span>, bad_words_ids=bad_words_ids, pad_token_id=tokenizer.eos_token_id
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(output_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a surprise.`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,b,k),u(_,o,k),w=!0},p:x,i(o){w||(g(_.$$.fragment,o),w=!0)},o(o){h(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(b)),f(_,o)}}}function Qw(j){let i,$=`Use n-gram penalties with care. For instance, penalizing 2-grams (bigrams) in an article about the city of New York
might lead to undesirable outcomes where the city’s name appears only once in the entire text.
<a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">Reference</a>`;return{c(){i=a("p"),i.innerHTML=$},l(b){i=l(b,"P",{"data-svelte-h":!0}),y(i)!=="svelte-5zfsi9"&&(i.innerHTML=$)},m(b,_){d(b,i,_)},p:x,d(b){b&&s(i)}}}function Yw(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyVG9kYXklMjBJJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dCU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkpJTBBJTBBJTIzJTIwTm93JTIwbGV0J3MlMjBhZGQlMjBuZ3JhbSUyMHNpemUlMjB1c2luZyUyMCU2MG5vX3JlcGVhdF9uZ3JhbV9zaXplJTYwLiUyMFRoaXMlMjBzdG9wcyUyMHRoZSUyMHJlcGV0aXRpb25zJTIwKCUyMkklRTIlODAlOTltJTIyKSUyMGluJTIwdGhlJTIwb3V0cHV0LiUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbm9fcmVwZWF0X25ncmFtX3NpemUlM0QyKSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0JTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today I&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Today I’m <span class="hljs-keyword">not</span> sure <span class="hljs-keyword">if</span> I’m going to be able to do it.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s add ngram size using \`no_repeat_ngram_size\`. This stops the repetitions (&quot;I’m&quot;) in the output.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs, no_repeat_ngram_size=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Today I’m <span class="hljs-keyword">not</span> sure <span class="hljs-keyword">if</span> I can get a better understanding of the nature of this issue`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,b,k),u(_,o,k),w=!0},p:x,i(o){w||(g(_.$$.fragment,o),w=!0)},o(o){h(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(b)),f(_,o)}}}function Aw(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Alice and Bob&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob are friends

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can contrain it with \`prefix_allowed_tokens_fn\` to force a certain behavior based on a prefix.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For instance, we can force an entire entity to be generated when its beginning is detected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>entity =  tokenizer(<span class="hljs-string">&quot; Bob Marley&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids[<span class="hljs-number">0</span>]  <span class="hljs-comment"># 3 tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">prefix_allowed_tokens_fn</span>(<span class="hljs-params">batch_id, input_ids</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Attempts to generate &#x27;Bob Marley&#x27; when &#x27;Bob&#x27; is detected.
<span class="hljs-meta">... </span>    In this case, \`batch_id\` is not used, but you can set rules for each batch member.
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> input_ids[-<span class="hljs-number">1</span>] == entity[<span class="hljs-number">0</span>]:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> entity[<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">elif</span> input_ids[-<span class="hljs-number">2</span>] == entity[<span class="hljs-number">0</span>] <span class="hljs-keyword">and</span> input_ids[-<span class="hljs-number">1</span>] == entity[<span class="hljs-number">1</span>]:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> entity[<span class="hljs-number">2</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> <span class="hljs-built_in">list</span>(<span class="hljs-built_in">range</span>(tokenizer.vocab_size))  <span class="hljs-comment"># If no match, allow all tokens</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>, prefix_allowed_tokens_fn=prefix_allowed_tokens_fn)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob Marley`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,b,k),u(_,o,k),w=!0},p:x,i(o){w||(g(_.$$.fragment,o),w=!0)},o(o){h(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(b)),f(_,o)}}}function Ow(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMHRoZSUyMG1vZGVsJTIwYW5kJTIwdG9rZW5pemVyJTIwZm9yJTIwaXQlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkknbSUyMG5vdCUyMGdvaW5nJTIwdG8lMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFRoaXMlMjBzaG93cyUyMGElMjBub3JtYWwlMjBnZW5lcmF0ZSUyMHdpdGhvdXQlMjBhbnklMjBzcGVjaWZpYyUyMHBhcmFtZXRlcnMlMEFzdW1tYXJ5X2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUoc3VtbWFyeV9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMFRoaXMlMjBnZW5lcmF0ZXMlMjBhJTIwcGVuYWx0eSUyMGZvciUyMHJlcGVhdGVkJTIwdG9rZW5zJTBBcGVuYWxpemVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwcmVwZXRpdGlvbl9wZW5hbHR5JTNEMS4xKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUocGVuYWxpemVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing the model and tokenizer for it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;I&#x27;m not going to&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This shows a normal generate without any specific parameters</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to be able to do that. I&#x27;</span>m going to be able to do that

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This generates a penalty for repeated tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>penalized_ids = model.generate(**inputs, repetition_penalty=<span class="hljs-number">1.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(penalized_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to be able to do that. I&#x27;</span>ll just have to go out <span class="hljs-keyword">and</span> play`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,b,k),u(_,o,k),w=!0},p:x,i(o){w||(g(_.$$.fragment,o),w=!0)},o(o){h(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(b)),f(_,o)}}}function Kw(j){let i,$=`In order to get the token ids of the sequences that you want to bias, make sure to set <code>add_prefix_space=True</code> when
initializing the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The
<code>add_prefix_space</code> argument is only supported for some slow tokenizers, as fast tokenizers’ prefixing behaviours
come from <code>pre tokenizers</code>. Read more <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`;return{c(){i=a("p"),i.innerHTML=$},l(b){i=l(b,"P",{"data-svelte-h":!0}),y(i)!=="svelte-16cusgy"&&(i.innerHTML=$)},m(b,_){d(b,i,_)},p:x,d(b){b&&s(i)}}}function ek(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;The full name of Donald is Donald&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald J. Trump Jr

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s control generation through a bias. Please note that the tokenizer is initialized differently!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_with_prefix_space = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens_as_tuple</span>(<span class="hljs-params">word</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> <span class="hljs-built_in">tuple</span>(tokenizer_with_prefix_space([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>])


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we add a negative bias without beam search, it may become &quot;stuck&quot; in a prefix without good continuations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = {get_tokens_as_tuple(<span class="hljs-string">&quot;Trump&quot;</span>): -<span class="hljs-number">10.0</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald J. Donald,

<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, num_beams=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald Rumsfeld,

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can also add a positive bias to nudge the model towards specific tokens or continuations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = {get_tokens_as_tuple(<span class="hljs-string">&quot;Donald Duck&quot;</span>): <span class="hljs-number">10.0</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, num_beams=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald Duck.`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,b,k),u(_,o,k),w=!0},p:x,i(o){w||(g(_.$$.fragment,o),w=!0)},o(o){h(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(b)),f(_,o)}}}function tk(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Whisper has \`begin_suppress_tokens\` set by default (= \`[220, 50256]\`). 50256 is the EOS token, so this means</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># it can&#x27;t generate and EOS token in the first iteration, but it can in the others.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])  <span class="hljs-comment"># 1 (and not 0) is the first freely generated token</span>
tensor(-inf)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[-<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])  <span class="hljs-comment"># in other places we can see some probability mass for EOS</span>
tensor(<span class="hljs-number">29.9010</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we disable \`begin_suppress_tokens\`, we can generate EOS in the first iteration.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>, begin_suppress_tokens=<span class="hljs-literal">None</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])
tensor(<span class="hljs-number">11.2027</span>)`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,b,k),u(_,o,k),w=!0},p:x,i(o){w||(g(_.$$.fragment,o),w=!0)},o(o){h(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(b)),f(_,o)}}}function sk(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBXaGlzcGVyRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2hpc3BlciUyMGhhcyUyMGElMjBsb25nJTIwbGlzdCUyMG9mJTIwc3VwcHJlc3NlZCUyMHRva2Vucy4lMjBGb3IlMjBpbnN0YW5jZSUyQyUyMGluJTIwdGhpcyUyMGNhc2UlMkMlMjB0aGUlMjB0b2tlbiUyMDElMjBpcyUyMHN1cHByZXNzZWQlMjBieSUyMGRlZmF1bHQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUpJTBBcHJpbnQob3V0cHV0cy5zY29yZXMlNUIxJTVEJTVCMCUyQyUyMDElNUQpJTIwJTIwJTIzJTIwMSUyMChhbmQlMjBub3QlMjAwKSUyMGlzJTIwdGhlJTIwZmlyc3QlMjBmcmVlbHklMjBnZW5lcmF0ZWQlMjB0b2tlbiUwQSUwQSUyMyUyMElmJTIwd2UlMjBkaXNhYmxlJTIwJTYwc3VwcHJlc3NfdG9rZW5zJTYwJTJDJTIwd2UlMjBjYW4lMjBnZW5lcmF0ZSUyMGl0LiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSUyQyUyMG91dHB1dF9zY29yZXMlM0RUcnVlJTJDJTIwc3VwcHJlc3NfdG9rZW5zJTNETm9uZSklMEFwcmludChvdXRwdXRzLnNjb3JlcyU1QjElNUQlNUIwJTJDJTIwMSU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Whisper has a long list of suppressed tokens. For instance, in this case, the token 1 is suppressed by default.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])  <span class="hljs-comment"># 1 (and not 0) is the first freely generated token</span>
tensor(-inf)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we disable \`suppress_tokens\`, we can generate it.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>, suppress_tokens=<span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])
tensor(<span class="hljs-number">5.7738</span>)`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,b,k),u(_,o,k),w=!0},p:x,i(o){w||(g(_.$$.fragment,o),w=!0)},o(o){h(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(b)),f(_,o)}}}function nk(j){let i,$=`Make sure that <code>do_sample=True</code> is included in the <code>generate</code> arguments otherwise the temperature value won’t have
any effect.`;return{c(){i=a("p"),i.innerHTML=$},l(b){i=l(b,"P",{"data-svelte-h":!0}),y(i)!=="svelte-1byeoum"&&(i.innerHTML=$)},m(b,_){d(b,i,_)},p:x,d(b){b&&s(i)}}}function rk(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwc2V0X3NlZWQlMEElMEFzZXRfc2VlZCgwKSUyMCUyMCUyMyUyMGZvciUyMHJlcHJvZHVjaWJpbGl0eSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFtb2RlbC5jb25maWcucGFkX3Rva2VuX2lkJTIwJTNEJTIwbW9kZWwuY29uZmlnLmVvc190b2tlbl9pZCUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJIdWdnaW5nJTIwRmFjZSUyMENvbXBhbnklMjBpcyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2l0aCUyMHRlbXBlcmF0dXJlJTNEMS4wJTJDJTIwdGhlJTIwZGVmYXVsdCUyQyUyMHdlJTIwY29uc2lzdGVudGx5JTIwZ2V0JTIwcmFuZG9tJTIwb3V0cHV0cyUyMGR1ZSUyMHRvJTIwcmFuZG9tJTIwc2FtcGxpbmcuJTBBZ2VuZXJhdGVfa3dhcmdzJTIwJTNEJTIwJTdCJTIybWF4X25ld190b2tlbnMlMjIlM0ElMjAxMCUyQyUyMCUyMmRvX3NhbXBsZSUyMiUzQSUyMFRydWUlMkMlMjAlMjJ0ZW1wZXJhdHVyZSUyMiUzQSUyMDEuMCUyQyUyMCUyMm51bV9yZXR1cm5fc2VxdWVuY2VzJTIyJTNBJTIwMiU3RCUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMCoqZ2VuZXJhdGVfa3dhcmdzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElMEElMjMlMjBIb3dldmVyJTJDJTIwd2l0aCUyMHRlbXBlcmF0dXJlJTIwY2xvc2UlMjB0byUyMDAlMkMlMjBpdCUyMGFwcHJveGltYXRlcyUyMGdyZWVkeSUyMGRlY29kaW5nJTIwc3RyYXRlZ2llcyUyMChpbnZhcmlhbnQpJTBBZ2VuZXJhdGVfa3dhcmdzJTVCJTIydGVtcGVyYXR1cmUlMjIlNUQlMjAlM0QlMjAwLjAwMDElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjAqKmdlbmVyYXRlX2t3YXJncyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)  <span class="hljs-comment"># for reproducibility</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Hugging Face Company is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With temperature=1.0, the default, we consistently get random outputs due to random sampling.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_kwargs = {<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">10</span>, <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">1.0</span>, <span class="hljs-string">&quot;num_return_sequences&quot;</span>: <span class="hljs-number">2</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, **generate_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Hugging Face Company is a joint venture between GEO Group, one of&#x27;</span>,
<span class="hljs-string">&#x27;Hugging Face Company is not an exact science – but what we believe does&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># However, with temperature close to 0, it approximates greedy decoding strategies (invariant)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_kwargs[<span class="hljs-string">&quot;temperature&quot;</span>] = <span class="hljs-number">0.0001</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, **generate_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Hugging Face Company is a company that has been around for over 20 years&#x27;</span>,
<span class="hljs-string">&#x27;Hugging Face Company is a company that has been around for over 20 years&#x27;</span>]`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,b,k),u(_,o,k),w=!0},p:x,i(o){w||(g(_.$$.fragment,o),w=!0)},o(o){h(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(b)),f(_,o)}}}function ok(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBzZXF1ZW5jZSUzQSUyMEElMkMlMjBCJTJDJTIwQyUyQyUyMEQlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMCU2MHRvcF9rJTYwJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBnZXRzJTIwcmVzdHJpY3RlZCUyMHRoZSUyMGslMjBtb3N0JTIwbGlrZWx5JTIwdG9rZW5zLiUwQSUyMyUyMFBybyUyMHRpcCUzQSUyMEluJTIwcHJhY3RpY2UlMkMlMjBMTE1zJTIwdXNlJTIwJTYwdG9wX2slNjAlMjBpbiUyMHRoZSUyMDUtNTAlMjByYW5nZS4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwdG9wX2slM0QyKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: A, B, C, D&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: A, B, C, D, G, H, I. A, M

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`top_k\` sampling, the output gets restricted the k most likely tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`top_k\` in the 5-50 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, top_k=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: A, B, C, D, E, F, G, H, I`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,b,k),u(_,o,k),w=!0},p:x,i(o){w||(g(_.$$.fragment,o),w=!0)},o(o){h(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(b)),f(_,o)}}}function ak(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBzZXF1ZW5jZSUzQSUyMDElMkMlMjAyJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBpcyUyMHVuZXhwZWN0ZWQlMjAtLSUyMHNvbWV0aW1lcyUyMHRvbyUyMHVuZXhwZWN0ZWQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMFdpdGglMjAlNjB0b3BfcCU2MCUyMHNhbXBsaW5nJTJDJTIwdGhlJTIwb3V0cHV0JTIwZ2V0cyUyMHJlc3RyaWN0ZWQlMjB0byUyMGhpZ2gtcHJvYmFiaWxpdHklMjB0b2tlbnMuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwSW4lMjBwcmFjdGljZSUyQyUyMExMTXMlMjB1c2UlMjAlNjB0b3BfcCU2MCUyMGluJTIwdGhlJTIwMC45LTAuOTUlMjByYW5nZS4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwdG9wX3AlM0QwLjEpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2.</span> <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`top_p\` sampling, the output gets restricted to high-probability tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`top_p\` in the 0.9-0.95 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,b,k),u(_,o,k),w=!0},p:x,i(o){w||(g(_.$$.fragment,o),w=!0)},o(o){h(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(b)),f(_,o)}}}function lk(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can see that greedy decoding produces a sequence of numbers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>, <span class="hljs-number">10</span>,

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For this particular seed, we can see that sampling produces nearly the same low-information (= low entropy)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sequence</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">18</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span> <span class="hljs-keyword">and</span> <span class="hljs-number">10</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`typical_p\` set, the most obvious sequence is no longer produced, which may be good for your problem</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">18</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs, do_sample=<span class="hljs-literal">True</span>, typical_p=<span class="hljs-number">0.1</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs.sequences, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> <span class="hljs-keyword">and</span> <span class="hljs-number">5</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can see that the token corresponding to &quot;4&quot; (token 934) in the second position, the most likely token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># as seen with greedy decoding, was entirely blocked out</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">934</span>])
tensor(-inf)`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,b,k),u(_,o,k),w=!0},p:x,i(o){w||(g(_.$$.fragment,o),w=!0)},o(o){h(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(b)),f(_,o)}}}function ck(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyVG9kYXklMkMlMjBhJTIwZHJhZ29uJTIwZmxldyUyMG92ZXIlMjBQYXJpcyUyQyUyMEZyYW5jZSUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QxLjUpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwd2l0aCUyMGElMjBuZWdhdGl2ZSUyMHByb21wdCUwQW5lZ19pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyQSUyMHZlcnklMjBoYXBweSUyMGV2ZW50JTIwaGFwcGVuZWQlMkMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMiUyQyUyMG5lZ2F0aXZlX3Byb21wdF9pZHMlM0RuZWdfaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQSUwQSUyMyUyMHdpdGglMjBhJTIwcG9zaXRpdmUlMjBwcm9tcHQlMEFuZWdfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkElMjB2ZXJ5JTIwaGFwcHklMjBldmVudCUyMGhhcHBlbmVkJTJDJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDAlMkMlMjBuZWdhdGl2ZV9wcm9tcHRfaWRzJTNEbmVnX2lucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today, a dragon flew over Paris, France,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">1.5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Today, a dragon flew over Paris, France, killing at least 50 people and injuring more than 100&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a negative prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">2</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Today, a dragon flew over Paris, France, killing at least 130 people. French media reported that&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a positive prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">0</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Today, a dragon flew over Paris, France, and I&#x27;m very happy to be here. I&quot;</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,b,k),u(_,o,k),w=!0},p:x,i(o){w||(g(_.$$.fragment,o),w=!0)},o(o){h(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(b)),f(_,o)}}}function ik(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMFdoaXNwZXJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBHZW5lcmF0aW9uQ29uZmlnJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIzJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRfZmVhdHVyZXMlMjAlM0QlMjBpbnB1dHMuaW5wdXRfZmVhdHVyZXMlMEElMEElMjNEaXNwbGF5aW5nJTIwdGltZXN0YW1wcyUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlM0RpbnB1dF9mZWF0dXJlcyUyQyUyMHJldHVybl90aW1lc3RhbXBzJTNEVHJ1ZSklMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwZGVjb2RlX3dpdGhfdGltZXN0YW1wcyUzRFRydWUpJTVCMCU1RCUwQXByaW50KCUyMlRyYW5zY3JpcHRpb24lM0ElMjIlMkMlMjB0cmFuc2NyaXB0aW9uKSUwQSUwQSUwQSUyM05vJTIwdGltZXN0YW1wcyUyMCUyNiUyMGNoYW5nZSUyMEVPUyUzQSUwQSUyM1RoaXMlMjBhbGxvd3MlMjB0aGUlMjB1c2VyJTIwdG8lMjBzZWxlY3QlMjBhJTIwc3BlY2lmaWMlMjB0b2tlbiUyMHRvJTIwdGVybWluYXRlJTIwdGhlJTIwc2VxdWVuY2UlMjBvbiUyQyUyMGluJTIwdGhpcyUyMGNhc2UlMjBpdCdzJTIwdGhlJTIwd29yZCUyMCUyMmNhbiUyMig0NjApJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcuZW9zX3Rva2VuX2lkJTIwJTNEJTIwNDYwJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyUzRGlucHV0X2ZlYXR1cmVzJTJDcmV0dXJuX3RpbWVzdGFtcHMlM0RGYWxzZSklMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQXByaW50KCUyMlRyYW5zY3JpcHRpb24lM0ElMjIlMkMlMjB0cmFuc2NyaXB0aW9uKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration, GenerationConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">3</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_features = inputs.input_features

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment">#Displaying timestamps</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(inputs=input_features, return_timestamps=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(generated_ids, decode_with_timestamps=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Transcription:&quot;</span>, transcription)
Transcription: &lt;|startoftranscript|&gt;&lt;|<span class="hljs-number">0.00</span>|&gt; He has grave doubts whether Sir Frederick Layton<span class="hljs-string">&#x27;s work is really Greek after all, and can&lt;|6.44|&gt;&lt;|6.44|&gt; discover in it but little of rocky Ithaca.&lt;|9.44|&gt;&lt;|endoftext|&gt;


&gt;&gt;&gt; #No timestamps &amp; change EOS:
&gt;&gt;&gt; #This allows the user to select a specific token to terminate the sequence on, in this case it&#x27;</span>s the word <span class="hljs-string">&quot;can&quot;</span>(<span class="hljs-number">460</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.eos_token_id = <span class="hljs-number">460</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(inputs=input_features,return_timestamps=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Transcription:&quot;</span>, transcription)
Transcription:  He has grave doubts whether Sir Frederick Layton<span class="hljs-string">&#x27;s work is really Greek after all and can</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,b,k),u(_,o,k),w=!0},p:x,i(o){w||(g(_.$$.fragment,o),w=!0)},o(o){h(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(b)),f(_,o)}}}function dk(j){let i,$;return i=new J({props:{code:"Y29tcGxldGVkJTIwJTNEJTIwRmFsc2UlMEF3aGlsZSUyMG5vdCUyMGNvbXBsZXRlZCUzQSUwQSUyMCUyMCUyMCUyMF8lMkMlMjBjb21wbGV0ZWQlMjAlM0QlMjBjb25zdHJhaW50LnVwZGF0ZShjb25zdHJhaW50LmFkdmFuY2UoKSk=",highlighted:`completed = <span class="hljs-literal">False</span>
<span class="hljs-keyword">while</span> <span class="hljs-keyword">not</span> completed:
    _, completed = constraint.update(constraint.advance())`,wrap:!1}}),{c(){p(i.$$.fragment)},l(b){m(i.$$.fragment,b)},m(b,_){u(i,b,_),$=!0},p:x,i(b){$||(g(i.$$.fragment,b),$=!0)},o(b){h(i.$$.fragment,b),$=!1},d(b){f(i,b)}}}function pk(j){let i,$="The API for the streamer classes is still under development and may change in the future.";return{c(){i=a("p"),i.textContent=$},l(b){i=l(b,"P",{"data-svelte-h":!0}),y(i)!=="svelte-gv2g1g"&&(i.textContent=$)},m(b,_){d(b,i,_)},p:x,d(b){b&&s(i)}}}function mk(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRTdHJlYW1lciUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2soJTVCJTIyQW4lMjBpbmNyZWFzaW5nJTIwc2VxdWVuY2UlM0ElMjBvbmUlMkMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXN0cmVhbWVyJTIwJTNEJTIwVGV4dFN0cmVhbWVyKHRvayklMEElMEElMjMlMjBEZXNwaXRlJTIwcmV0dXJuaW5nJTIwdGhlJTIwdXN1YWwlMjBvdXRwdXQlMkMlMjB0aGUlMjBzdHJlYW1lciUyMHdpbGwlMjBhbHNvJTIwcHJpbnQlMjB0aGUlMjBnZW5lcmF0ZWQlMjB0ZXh0JTIwdG8lMjBzdGRvdXQuJTBBXyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwc3RyZWFtZXIlM0RzdHJlYW1lciUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextStreamer

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Despite returning the usual output, the streamer will also print the generated text to stdout.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>_ = model.generate(**inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,b,k),u(_,o,k),w=!0},p:x,i(o){w||(g(_.$$.fragment,o),w=!0)},o(o){h(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(b)),f(_,o)}}}function uk(j){let i,$="The API for the streamer classes is still under development and may change in the future.";return{c(){i=a("p"),i.textContent=$},l(b){i=l(b,"P",{"data-svelte-h":!0}),y(i)!=="svelte-gv2g1g"&&(i.textContent=$)},m(b,_){d(b,i,_)},p:x,d(b){b&&s(i)}}}function gk(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRJdGVyYXRvclN0cmVhbWVyJTBBZnJvbSUyMHRocmVhZGluZyUyMGltcG9ydCUyMFRocmVhZCUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2soJTVCJTIyQW4lMjBpbmNyZWFzaW5nJTIwc2VxdWVuY2UlM0ElMjBvbmUlMkMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXN0cmVhbWVyJTIwJTNEJTIwVGV4dEl0ZXJhdG9yU3RyZWFtZXIodG9rKSUwQSUwQSUyMyUyMFJ1biUyMHRoZSUyMGdlbmVyYXRpb24lMjBpbiUyMGElMjBzZXBhcmF0ZSUyMHRocmVhZCUyQyUyMHNvJTIwdGhhdCUyMHdlJTIwY2FuJTIwZmV0Y2glMjB0aGUlMjBnZW5lcmF0ZWQlMjB0ZXh0JTIwaW4lMjBhJTIwbm9uLWJsb2NraW5nJTIwd2F5LiUwQWdlbmVyYXRpb25fa3dhcmdzJTIwJTNEJTIwZGljdChpbnB1dHMlMkMlMjBzdHJlYW1lciUzRHN0cmVhbWVyJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCklMEF0aHJlYWQlMjAlM0QlMjBUaHJlYWQodGFyZ2V0JTNEbW9kZWwuZ2VuZXJhdGUlMkMlMjBrd2FyZ3MlM0RnZW5lcmF0aW9uX2t3YXJncyklMEF0aHJlYWQuc3RhcnQoKSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwJTIyJTIyJTBBZm9yJTIwbmV3X3RleHQlMjBpbiUyMHN0cmVhbWVyJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVkX3RleHQlMjAlMkIlM0QlMjBuZXdfdGV4dCUwQWdlbmVyYXRlZF90ZXh0",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextIteratorStreamer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> threading <span class="hljs-keyword">import</span> Thread

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextIteratorStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run the generation in a separate thread, so that we can fetch the generated text in a non-blocking way.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_kwargs = <span class="hljs-built_in">dict</span>(inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread = Thread(target=model.generate, kwargs=generation_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread.start()
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = <span class="hljs-string">&quot;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> new_text <span class="hljs-keyword">in</span> streamer:
<span class="hljs-meta">... </span>    generated_text += new_text
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text
<span class="hljs-string">&#x27;An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,&#x27;</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,b,k),u(_,o,k),w=!0},p:x,i(o){w||(g(_.$$.fragment,o),w=!0)},o(o){h(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(b)),f(_,o)}}}function hk(j){let i,$,b,_,w,o,k,$T=`This page lists all the utility functions used by <a href="/docs/transformers/v4.37.2/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>,
<a href="/docs/transformers/v4.37.2/en/main_classes/text_generation#transformers.GenerationMixin.greedy_search">greedy_search()</a>,
<a href="/docs/transformers/v4.37.2/en/main_classes/text_generation#transformers.GenerationMixin.contrastive_search">contrastive_search()</a>,
<a href="/docs/transformers/v4.37.2/en/main_classes/text_generation#transformers.GenerationMixin.sample">sample()</a>,
<a href="/docs/transformers/v4.37.2/en/main_classes/text_generation#transformers.GenerationMixin.beam_search">beam_search()</a>,
<a href="/docs/transformers/v4.37.2/en/main_classes/text_generation#transformers.GenerationMixin.beam_sample">beam_sample()</a>,
<a href="/docs/transformers/v4.37.2/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search">group_beam_search()</a>, and
<a href="/docs/transformers/v4.37.2/en/main_classes/text_generation#transformers.GenerationMixin.constrained_beam_search">constrained_beam_search()</a>.`,jm,yn,jT="Most of those are only useful if you are studying the code of the generate methods in the library.",xm,Tn,Jm,vn,xT=`The output of <a href="/docs/transformers/v4.37.2/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> is an instance of a subclass of
<a href="/docs/transformers/v4.37.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a>. This output is a data structure containing all the information returned
by <a href="/docs/transformers/v4.37.2/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>, but that can also be used as tuple or dictionary.`,Um,Mn,JT="Here’s an example:",Bm,wn,Im,kn,UT=`The <code>generation_output</code> object is a <a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.generation.GenerateDecoderOnlyOutput">GenerateDecoderOnlyOutput</a>, as we can
see in the documentation of that class below, it means it has the following attributes:`,Zm,$n,BT="<li><code>sequences</code>: the generated sequences of tokens</li> <li><code>scores</code> (optional): the prediction scores of the language modelling head, for each generation step</li> <li><code>hidden_states</code> (optional): the hidden states of the model, for each generation step</li> <li><code>attentions</code> (optional): the attention weights of the model, for each generation step</li>",zm,jn,IT=`Here we have the <code>scores</code> since we passed along <code>output_scores=True</code>, but we don’t have <code>hidden_states</code> and
<code>attentions</code> because we didn’t pass <code>output_hidden_states=True</code> or <code>output_attentions=True</code>.`,Wm,xn,ZT=`You can access each attribute as you would usually do, and if that attribute has not been returned by the model, you
will get <code>None</code>. Here for instance <code>generation_output.scores</code> are all the generated prediction scores of the
language modeling head, and <code>generation_output.attentions</code> is <code>None</code>.`,Vm,Jn,zT=`When using our <code>generation_output</code> object as a tuple, it only keeps the attributes that don’t have <code>None</code> values.
Here, for instance, it has two elements, <code>loss</code> then <code>logits</code>, so`,Lm,Un,Cm,Bn,WT="will return the tuple <code>(generation_output.sequences, generation_output.scores)</code> for instance.",Fm,In,VT=`When using our <code>generation_output</code> object as a dictionary, it only keeps the attributes that don’t have <code>None</code>
values. Here, for instance, it has two keys that are <code>sequences</code> and <code>scores</code>.`,Gm,Zn,LT="We document here all output types.",Xm,zn,Rm,xt,Wn,_h,Gl,CT="Outputs of decoder-only generation models, when using non-beam methods.",Em,Jt,Vn,bh,Xl,FT="Outputs of encoder-decider generation models, when using non-beam methods.",Nm,Ut,Ln,yh,Rl,GT="Outputs of decoder-only generation models, when using beam methods.",Sm,Bt,Cn,Th,El,XT="Outputs of encoder-decoder generation models, when using beam methods.",qm,Fn,Hm,It,Gn,vh,Nl,RT=`Base class for outputs of encoder-decoder generation models using greedy search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,Dm,Zt,Xn,Mh,Sl,ET="Base class for outputs of decoder-only generation models using greedy search.",Pm,zt,Rn,wh,ql,NT=`Base class for outputs of encoder-decoder generation models using sampling. Hidden states and attention weights of
the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,Qm,Wt,En,kh,Hl,ST="Base class for outputs of decoder-only generation models using sampling.",Ym,Vt,Nn,$h,Dl,qT=`Base class for outputs of encoder-decoder generation models using beam search. Hidden states and attention weights
of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,Am,Lt,Sn,jh,Pl,HT="Base class for outputs of decoder-only generation models using beam search.",Om,Ct,qn,xh,Ql,DT=`Base class for outputs of encoder-decoder generation models using beam sampling. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,Km,Ft,Hn,Jh,Yl,PT="Base class for outputs of decoder-only generation models using beam sample.",eu,Gt,Dn,Uh,Al,QT=`Base class for outputs of encoder-decoder generation models using contrastive search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,tu,Xt,Pn,Bh,Ol,YT="Base class for outputs of decoder-only generation models using contrastive search.",su,Qn,nu,je,Yn,Ih,Kl,AT="Flax Base class for outputs of decoder-only generation models using sampling.",Zh,Dt,An,zh,ec,OT="“Returns a new object replacing the specified fields with new values.",ru,xe,On,Wh,tc,KT="Flax Base class for outputs of decoder-only generation models using greedy search.",Vh,Pt,Kn,Lh,sc,ev="“Returns a new object replacing the specified fields with new values.",ou,Je,er,Ch,nc,tv="Flax Base class for outputs of decoder-only generation models using greedy search.",Fh,Qt,tr,Gh,rc,sv="“Returns a new object replacing the specified fields with new values.",au,sr,lu,nr,nv=`A <a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> can be used to modify the prediction scores of a language model head for
generation.`,cu,rr,iu,ee,or,Xh,oc,rv='<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing alternated generation between the two codebooks of Bark.',Rh,Yt,Eh,ac,ar,du,W,lr,Nh,lc,ov=`<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for classifier free guidance (CFG). The scores are split over the batch dimension,
where the first half correspond to the conditional logits (predicted from the input prompt) and the second half
correspond to the unconditional logits (predicted from an empty or ‘null’ prompt). The processor computes a
weighted average across the conditional and unconditional logits, parameterised by the <code>guidance_scale</code>.`,Sh,cc,av='See <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">the paper</a> for more information.',qh,At,Hh,Ot,Dh,ic,cr,pu,X,ir,Ph,dc,lv=`<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that works similarly to <a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.NoRepeatNGramLogitsProcessor">NoRepeatNGramLogitsProcessor</a>, but applied exclusively to prevent
the repetition of n-grams present in the prompt.`,Qh,pc,cv=`It was designed to promote chattiness in a language model, by preventing the generation of n-grams present in
previous conversation rounds.`,Yh,Kt,Ah,mc,dr,mu,R,pr,Oh,uc,iv=`<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that works similarly to <a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.RepetitionPenaltyLogitsProcessor">RepetitionPenaltyLogitsProcessor</a>, but with an <em>inverse</em> penalty
that is applied to the tokens present in the prompt. In other words, a penalty above 1.0 increases the odds of
selecting tokens that were present in the prompt.`,Kh,gc,dv=`It was designed to avoid hallucination in input-grounded tasks, like summarization. Although originally intended
for encoder-decoder models, it can also be used with decoder-only models like LLMs.`,ef,es,tf,hc,mr,uu,te,ur,sf,fc,pv=`<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs epsilon-sampling, i.e. restricting to tokens with <code>prob &gt;= epsilon</code>. Takes the
largest min_tokens_to_keep tokens if no tokens satisfy this constraint. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more information.`,nf,ts,rf,_c,gr,gu,se,hr,of,bc,mv=`<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs eta-sampling, a technique to filter out tokens with probabilities below a dynamic
cutoff value, <code>eta</code>, which is calculated based on a combination of the hyperparameter <code>epsilon</code> and the entropy of
the token probabilities, i.e. <code>eta := min(epsilon, sqrt(epsilon * e^-entropy(probabilities)))</code>. Takes the largest
min_tokens_to_keep tokens if no tokens satisfy this constraint. It addresses the issue of poor quality in long
samples of text generated by neural language models leading to more coherent and fluent text. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation
Sampling as Language Model Desmoothing</a> for more information. Note: <code>do_sample</code>
must be set to <code>True</code> for this <code>LogitsWarper</code> to work.`,af,ss,lf,yc,fr,hu,ne,_r,cf,Tc,uv=`<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that exponentially increases the score of the <code>eos_token_id</code> after <code>start_index</code> has been
reached. This allows generating shorter sequences without having a hard cutoff, allowing the <code>eos_token</code> to be
predicted in a meaningful position.`,df,ns,pf,vc,br,fu,re,yr,mf,Mc,gv=`<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces the specified token as the first generated token. Used with encoder-decoder
models.`,uf,rs,gf,wc,Tr,_u,oe,vr,hf,kc,hv='<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',ff,os,_f,$c,Mr,bu,ae,wr,bf,jc,fv=`This processor takes a list of pairs of integers which indicates a mapping from generation indices to token
indices that will be forced before generation. The processor will set their log probs to <code>inf</code> so that they are
sampled at their corresponding index. Originally created for
<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.`,yf,as,Tf,xc,kr,yu,V,$r,vf,Jc,_v='<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces diverse beam search.',Mf,Uc,bv=`Note that this logits processor is only effective for <a href="/docs/transformers/v4.37.2/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search">PreTrainedModel.group_beam_search()</a>. See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">Diverse Beam
Search: Decoding Diverse Solutions from Neural Sequence Models</a> for more
details.`,wf,Bc,yv=`Traditional beam search often generates very similar sequences across different beams.
<code>HammingDiversityLogitsProcessor</code> addresses this by penalizing beams that generate tokens already chosen by other
beams in the same time step.`,kf,ls,$f,Ic,jr,Tu,le,xr,jf,Zc,Tv=`<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that removes all <code>nan</code> and <code>inf</code> values to avoid the generation method to fail. Note that using
the logits processor should only be used if necessary since it can slow down the generation method.`,xf,zc,vv=`This logits processor has no <code>generate</code> example, as there shouldn’t be a correct combination of flags that warrants
its use.`,Jf,Wc,Jr,vu,ce,Ur,Uf,Vc,Mv=`<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> and <a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for normalizing the scores using log-softmax. It’s important to normalize
the scores during beam search, after applying the logits processors or warpers, since the search algorithm used in
this library doesn’t do it (it only does it before, but they may need re-normalization) but it still supposes that
the scores are normalized when comparing the hypotheses.`,Bf,cs,If,Lc,Br,Mu,Ue,Ir,Zf,Cc,wv="Abstract base class for all logit processors that can be applied during generation.",zf,Fc,Zr,wu,Be,zr,Wf,Gc,kv=`This class can be used to create a list of <a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> or <a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> to subsequently process a
<code>scores</code> input tensor. This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each
<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> or <a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> to the inputs.`,Vf,Xc,Wr,ku,Ie,Vr,Lf,Rc,$v="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",Cf,Ec,Lr,$u,ie,Cr,Ff,Nc,jv=`<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing a min-length by setting EOS probability to 0. Note that, for decoder-only models
like most LLMs, the length includes the prompt.`,Gf,is,Xf,Sc,Fr,ju,de,Gr,Rf,qc,xv=`<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing a min-length of new tokens by setting EOS (End-Of-Sequence) token probability to 0.
Contrarily to <a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.MinLengthLogitsProcessor">MinLengthLogitsProcessor</a>, this processor ignores the prompt.`,Ef,ds,Nf,Hc,Xr,xu,E,Rr,Sf,Dc,Jv='<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces that specified sequences will never be selected.',qf,ps,Hf,ms,Df,Pc,Er,Ju,N,Nr,Pf,Qc,Uv=`N-grams are groups of “n” consecutive words, characters, or tokens taken from a sequence of text. Given the
sentence: “She runs fast”, the bi-grams (n=2) would be (“she”, “runs”) and (“runs”, “fast”). In text generation,
avoiding repetitions of word sequences provides a more diverse output. This <a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforces no
repetition of n-grams by setting the scores of banned tokens to negative infinity which eliminates those tokens
from consideration when further processing the scores. Note that, for decoder-only models like most LLMs, the
prompt is also considered to obtain the n-grams.
<a href="https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345" rel="nofollow">Fairseq</a>.`,Qf,us,Yf,gs,Af,Yc,Sr,Uu,pe,qr,Of,Ac,Bv=`<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces constrained generation and is useful for prefix-conditioned constrained
generation. See <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity Retrieval</a> for more information.`,Kf,hs,e_,Oc,Hr,Bu,S,Dr,t_,Kc,Iv=`<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that prevents the repetition of previous tokens through a penalty. This penalty is applied at
most once per token. Note that, for decoder-only models like most LLMs, the considered tokens include the prompt.`,s_,ei,Zv=`In the original <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">paper</a>, the authors suggest the use of a penalty of around
1.2 to achieve a good balance between truthful generation and lack of repetition. To penalize and reduce
repetition, use <code>penalty</code> values above 1.0, where a higher value penalizes more strongly. To reward and encourage
repetition, use <code>penalty</code> values between 0.0 and 1.0, where a lower value rewards more strongly.`,n_,fs,r_,ti,Pr,Iu,q,Qr,o_,si,zv=`<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that applies an additive bias on sequences. The bias is applied to the last token of a sequence
when the next generated token can complete it. Consequently, to take the most of biasing sequences with more than
one token, consider using beam methods (to gracefully work around partially completed sequences that have a
negative bias) and applying the bias to their prefixes (to ensure the bias is applied earlier).`,a_,_s,l_,bs,c_,ni,Yr,Zu,me,Ar,i_,ri,Wv=`<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.SuppressTokensAtBeginLogitsProcessor">SuppressTokensAtBeginLogitsProcessor</a> supresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> are
not generated at the begining. Originally created for
<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.`,d_,ys,p_,oi,Or,zu,ue,Kr,m_,ai,Vv=`This processor can be used to suppress a list of tokens. The processor will set their log probs to <code>-inf</code> so
that they are not generated. Originally created for
<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.`,u_,Ts,g_,li,eo,Wu,H,to,h_,ci,Lv=`<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> for temperature (exponential scaling output probability distribution), which effectively means
that it can control the randomness of the predicted tokens. Often used together with <a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.TopPLogitsWarper">TopPLogitsWarper</a> and
<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.TopKLogitsWarper">TopKLogitsWarper</a>.`,f_,vs,__,Ms,b_,ii,so,Vu,ge,no,y_,di,Cv=`<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements. Often used together
with <a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.TemperatureLogitsWarper">TemperatureLogitsWarper</a> and <a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.TopPLogitsWarper">TopPLogitsWarper</a>.`,T_,ws,v_,pi,ro,Lu,he,oo,M_,mi,Fv=`<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to prob_cut_off &lt;= prob_cut_off. Often
used together with <a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.TemperatureLogitsWarper">TemperatureLogitsWarper</a> and <a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.TopKLogitsWarper">TopKLogitsWarper</a>.`,w_,ks,k_,ui,ao,Cu,D,lo,$_,gi,Gv=`<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs typical decoding. Inspired on how humans use language, it prioritizes tokens whose
log probability is close to the entropy of the token probability distribution. This means that the most likely
tokens may be discarded in the process.`,j_,hi,Xv='See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language Generation</a> for more information.',x_,$s,J_,fi,co,Fu,P,io,U_,_i,Rv=`Logits processor for Classifier-Free Guidance (CFG). The processors computes a weighted average across scores
from prompt conditional and prompt unconditional (or negative) logits, parameterized by the <code>guidance_scale</code>.
The unconditional scores are computed internally by prompting <code>model</code> with the <code>unconditional_ids</code> branch.`,B_,bi,Ev='See <a href="https://arxiv.org/abs/2306.17806" rel="nofollow">the paper</a> for more information.',I_,js,Z_,yi,po,Gu,Q,mo,z_,Ti,Nv=`<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that modifies the logits for the generation of timestamps in the transcription. When the input
tokens are at a specific threshold, the processor sets the scores to negative infinity. The processor makes sure
that timestamp tokens appear in pairs, by masking out the logits that would break this pairing pattern. This is
done to maintain the consistency and structure of generated timestamps. It also ensures that when the predicted
probability of sampling any of the timestamp token is greater than any individual non-timestamp token, those
non-timestamp logits are set to negative infinity. This is done to ensure the generation of timestamps over other
potential tokens.`,W_,vi,Sv='See <a href="https://arxiv.org/abs/2212.04356" rel="nofollow">the paper</a> for more information.',V_,xs,L_,Mi,uo,Xu,go,Ru,Ze,ho,C_,wi,qv='<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces the specified token as the first generated token.',F_,ki,fo,Eu,ze,_o,G_,$i,Hv='<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',X_,ji,bo,Nu,We,yo,R_,xi,Dv=`This processor takes a list of pairs of integers which indicates a mapping from generation indices to token
indices that will be forced before sampling. The processor will set their log probs to <code>0</code> and all other tokens to
<code>-inf</code> so that they are sampled at their corresponding index.`,E_,Ji,To,Su,Ve,vo,N_,Ui,Pv="Abstract base class for all logit processors that can be applied during generation.",S_,Js,Mo,q_,Bi,Qv="TF method for processing logits.",qu,Le,wo,H_,Ii,Yv=`This class can be used to create a list of <a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> to subsequently process a <code>scores</code> input tensor.
This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each <a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> to the
inputs.`,D_,Zi,ko,Hu,Ce,$o,P_,zi,Av="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",Q_,Us,jo,Y_,Wi,Ov="TF method for warping logits.",Du,Fe,xo,A_,Vi,Kv='<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',O_,Li,Jo,Pu,Ge,Uo,K_,Ci,eM='<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces that specified sequences will never be sampled.',eb,Fi,Bo,Qu,Xe,Io,tb,Gi,tM=`<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces no repetition of n-grams. See
<a href="https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345" rel="nofollow">Fairseq</a>.`,sb,Xi,Zo,Yu,Re,zo,nb,Ri,sM='<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> enforcing an exponential penalty on repeated sequences.',rb,Ei,Wo,Au,Ee,Vo,ob,Ni,nM=`<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.TFSuppressTokensAtBeginLogitsProcessor">TFSuppressTokensAtBeginLogitsProcessor</a> suppresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> at not
sampled at the begining of the generation.`,ab,Si,Lo,Ou,Ne,Co,lb,qi,rM=`This processor can be used to suppress a list of tokens. The processor will set their log probs to <code>-inf</code> so that they
are not sampled.`,cb,Hi,Fo,Ku,Se,Go,ib,Di,oM='<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> for temperature (exponential scaling output probability distribution).',db,Pi,Xo,eg,qe,Ro,pb,Qi,aM='<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',mb,Yi,Eo,tg,He,No,ub,Ai,lM='<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to &lt;= prob_cut_off.',gb,Oi,So,sg,qo,ng,De,Ho,hb,Ki,cM='<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that enforces the specified token as the first generated token.',fb,ed,Do,rg,Pe,Po,_b,td,iM='<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',bb,sd,Qo,og,Qe,Yo,yb,nd,dM=`<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that takes a list of pairs of integers which indicates a mapping from generation indices to
token indices that will be forced before sampling. The processor will set their log probs to 0 and all other tokens
to <code>-inf</code> so that they are sampled at their corresponding index.`,Tb,rd,Ao,ag,Ye,Oo,vb,od,pM="Abstract base class for all logit processors that can be applied during generation.",Mb,Bs,Ko,wb,ad,mM="Flax method for processing logits.",lg,Ae,ea,kb,ld,uM=`This class can be used to create a list of <a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> or <a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> to subsequently process
a <code>scores</code> input tensor. This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each
<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> or <a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> to the inputs.`,$b,cd,ta,cg,Oe,sa,jb,id,gM="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",xb,Is,na,Jb,dd,hM="Flax method for warping logits.",ig,Ke,ra,Ub,pd,fM='<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',Bb,md,oa,dg,et,aa,Ib,ud,_M=`<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> supressing a list of tokens as soon as the <code>generate</code> function starts generating using
<code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> are not sampled at the
begining of the generation.`,Zb,gd,la,pg,tt,ca,zb,hd,bM=`<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> suppressing a list of tokens at each decoding step. The processor will set their log probs
to be <code>-inf</code> so they are not sampled.`,Wb,fd,ia,mg,st,da,Vb,_d,yM='<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> for temperature (exponential scaling output probability distribution).',Lb,bd,pa,ug,nt,ma,Cb,yd,TM='<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',Fb,Td,ua,gg,rt,ga,Gb,vd,vM='<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to prob_cut_off &lt;= prob_cut_off.',Xb,Md,ha,hg,ot,fa,Rb,wd,MM=`Whisper specific Processor. This processor can be used to force a list of tokens. The processor will set their log
probs to <code>inf</code> so that they are sampled at their corresponding index.`,Eb,kd,_a,fg,ba,_g,ya,wM='A <a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a> can be used to change when to stop generation (other than EOS token). Please note that this is exclusively available to our PyTorch implementations.',bg,fe,Ta,Nb,$d,kM="Abstract base class for all stopping criteria that can be applied during generation.",Sb,jd,$M="If your stopping criteria depends on the <code>scores</code> input, make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.",qb,xd,va,yg,Rt,Ma,Hb,Jd,wa,Tg,at,ka,Db,Ud,jM=`This class can be used to stop generation whenever the full generated number of tokens exceeds <code>max_length</code>. Keep
in mind for decoder-only type of transformers, this will include the initial prompted tokens.`,Pb,Bd,$a,vg,lt,ja,Qb,Id,xM=`This class can be used to stop generation whenever the full generation exceeds some amount of time. By default, the
time will start being counted when you initialize this function. You can override this by passing an
<code>initial_time</code>.`,Yb,Zd,xa,Mg,Ja,wg,Ua,JM='A <a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.Constraint">Constraint</a> can be used to force the generation to include specific tokens or sequences in the output. Please note that this is exclusively available to our PyTorch implementations.',kg,U,Ba,Ab,zd,UM=`Abstract base class for all constraints that can be applied during generation.
It must define how the constraint can be satisfied.`,Ob,Wd,BM="All classes that inherit Constraint must follow the requirement that",Kb,Zs,ey,Vd,IM="will always terminate (halt).",ty,zs,Ia,sy,Ld,ZM="When called, returns the token that would take this constraint one step closer to being fulfilled.",ny,Ws,Za,ry,Cd,zM="Creates a new instance of this constraint.",oy,Vs,za,ay,Fd,WM="Reads in a token and returns whether it creates progress.",ly,Ls,Wa,cy,Gd,VM="Returns the number of remaining steps of <code>advance()</code> in order to complete this constraint.",iy,Cs,Va,dy,Xd,LM=`Resets the state of this constraint to its initialization. We would call this in cases where the fulfillment of
a constraint is abrupted by an unwanted token.`,py,Fs,La,my,Rd,CM="Tests whether this constraint has been properly defined.",uy,_t,Ca,gy,Ed,FM=`Reads in a token and returns booleans that indicate the progress made by it. This function will update the
state of this object unlikes <code>does_advance(self, token_id: int)</code>.`,hy,Nd,GM=`This isn’t to test whether a certain token will advance the progress; it’s to update its state as if it has
been generated. This becomes important if token_id != desired token (refer to else statement in
PhrasalConstraint)`,$g,Et,Fa,fy,Sd,XM='<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.Constraint">Constraint</a> enforcing that an ordered sequence of tokens is included in the output.',jg,Nt,Ga,_y,qd,RM='A special <a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.Constraint">Constraint</a> that is fulfilled by fulfilling just one of several constraints.',xg,_e,Xa,by,Hd,EM="A class for beam scorers to track its progress through a list of constraints.",yy,F,Ra,Ty,Dd,NM=`The list of tokens to generate such that we can make progress.
By “list” we don’t mean the list of token that will fully fulfill a constraint.`,vy,Pd,SM=`Given constraints <code>c_i = {t_ij | j == # of tokens}</code>, If we’re not in the middle of progressing through a
specific constraint <code>c_i</code>, we return:`,My,Qd,qM="<code>[t_k1 for k in indices of unfulfilled constraints]</code>",wy,Yd,HM=`If we are in the middle of a constraint, then we return:
<code>[t_ij]</code>, where <code>i</code> is the index of the inprogress constraint, <code>j</code> is the next step for the constraint.`,ky,Ad,DM=`Though we don’t care which constraint is fulfilled first, if we are in the progress of fulfilling a constraint,
that’s the only one we’ll return.`,$y,Gs,Ea,jy,Od,PM="token_ids: the tokens generated thus far to reset the state of the progress through constraints.",Jg,Na,Ug,be,Sa,xy,Kd,QM=`Abstract base class for all beam scorers that are used for <a href="/docs/transformers/v4.37.2/en/main_classes/text_generation#transformers.GenerationMixin.beam_search">beam_search()</a> and
<a href="/docs/transformers/v4.37.2/en/main_classes/text_generation#transformers.GenerationMixin.beam_sample">beam_sample()</a>.`,Jy,ep,qa,Uy,tp,Ha,Bg,L,Da,By,sp,YM='<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> implementing standard beam search decoding.',Iy,np,AM=`Adapted in part from <a href="https://github.com/facebookresearch/XLM/blob/9e6f6814d17be4fe5b15f2e6c43eb2b2d76daeb4/src/model/transformer.py#L529" rel="nofollow">Facebook’s XLM beam search
code</a>.`,Zy,rp,OM=`Reference for the diverse beam search algorithm and implementation <a href="https://github.com/ashwinkalyan/dbs/blob/master/dbs/beam_utils.lua" rel="nofollow">Ashwin Kalyan’s DBS
implementation</a>`,zy,op,Pa,Wy,ap,Qa,Ig,ye,Ya,Vy,lp,KM='<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> implementing constrained beam search decoding.',Ly,cp,Aa,Cy,ip,Oa,Zg,Ka,zg,ct,el,Fy,dp,e2="Filter a distribution of logits using top-k and/or nucleus (top-p) filtering",Gy,pp,t2='From: <a href="https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317" rel="nofollow">https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317</a>',Wg,it,tl,Xy,mp,s2="Filter a distribution of logits using top-k and/or nucleus (top-p) filtering",Ry,up,n2='From: <a href="https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317" rel="nofollow">https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317</a>',Vg,sl,Lg,z,nl,Ey,gp,r2="Simple text streamer that prints the token(s) to stdout as soon as entire words are formed.",Ny,Xs,Sy,Rs,qy,Es,rl,Hy,hp,o2="Flushes any remaining cache and prints a newline to stdout.",Dy,Ns,ol,Py,fp,a2="Prints the new text to stdout. If the stream is ending, also prints a newline.",Qy,Ss,al,Yy,_p,l2="Receives tokens, decodes them, and prints them to stdout as soon as they form entire words.",Cg,Y,ll,Ay,bp,c2=`Streamer that stores print-ready text in a queue, to be used by a downstream application as an iterator. This is
useful for applications that benefit from acessing the generated text in a non-blocking way (e.g. in an interactive
Gradio demo).`,Oy,qs,Ky,Hs,eT,Ds,cl,tT,yp,i2="Put the new text in the queue. If the stream is ending, also put a stop signal in the queue.",Fg,il,Gg,dt,dl,sT,Tp,d2="Base, abstract class for all caches. The actual data structure is specific to each subclass.",nT,Ps,pl,rT,vp,p2="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",Xg,Z,ml,oT,Mp,m2="A cache that grows dynamically as more tokens are generated. This is the default for generative models.",aT,wp,u2=`It stores the Key and Value states as a list of tensors, one for each layer. The expected shape for each tensor is
<code>[batch_size, num_heads, seq_len, head_dim]</code>.`,lT,Qs,ul,cT,kp,g2="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",iT,Ys,gl,dT,$p,h2="Returns the sequence length of the cached states. A layer index can be optionally passed.",pT,As,hl,mT,jp,f2="Reorders the cache for beam search, given the selected beam indices.",uT,Os,fl,gT,xp,_2="Converts the <code>DynamicCache</code> instance into the its equivalent in the legacy cache format.",hT,Ks,_l,fT,Jp,b2="Converts a cache in the legacy cache format into an equivalent <code>DynamicCache</code>.",Rg,C,bl,_T,Up,y2=`A cache that as described in the <a href="https://arxiv.org/abs/2309.17453" rel="nofollow">Attention Sinks paper</a>. It allows the model to
generate beyond the length of its context window, without losing fluency in the conversation. As it discards past
tokens, the model will lose the ability to generate tokens that depend on the context that was discarded.`,bT,Bp,T2=`It stores the Key and Value states as a list of tensors, one for each layer. The expected shape for each tensor is
<code>[batch_size, num_heads, seq_len, head_dim]</code>.`,yT,en,yl,TT,Ip,v2="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",vT,tn,Tl,MT,Zp,M2="Returns the sequence length of the cached states. A layer index can be optionally passed.",wT,sn,vl,kT,zp,w2="Reorders the cache for beam search, given the selected beam indices.",Eg,_m,Ng;return w=new O({props:{title:"Utilities for Generation",local:"utilities-for-generation",headingTag:"h1"}}),Tn=new O({props:{title:"Generate Outputs",local:"generate-outputs",headingTag:"h2"}}),wn=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJUb2tlbml6ZXIlMkMlMjBHUFQyTE1IZWFkTW9kZWwlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBHUFQyVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwR1BUMkxNSGVhZE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIwYW5kJTIwJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFnZW5lcmF0aW9uX291dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, GPT2LMHeadModel

tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
model = GPT2LMHeadModel.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute and &quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
generation_output = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)`,wrap:!1}}),Un=new J({props:{code:"Z2VuZXJhdGlvbl9vdXRwdXQlNUIlM0EyJTVE",highlighted:'generation_output[:<span class="hljs-number">2</span>]',wrap:!1}}),zn=new O({props:{title:"PyTorch",local:"transformers.generation.GenerateDecoderOnlyOutput",headingTag:"h3"}}),Wn=new M({props:{name:"class transformers.generation.GenerateDecoderOnlyOutput",anchor:"transformers.generation.GenerateDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
NOTE: some models have a different <code>past_key_values</code> format, confirm with the model&#x2019;s documentation.
Usually a Tuple (one element for each layer of the decoder) of tuples (two elements, key tensor and value
tensor). The first Tuple is of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/utils.py#L96"}}),Vn=new M({props:{name:"class transformers.generation.GenerateEncoderDecoderOutput",anchor:"transformers.generation.GenerateEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
NOTE: some models have a different <code>past_key_values</code> format, confirm with the model&#x2019;s documentation.
Usually a Tuple (one element for each layer of the decoder) of tuples (two elements, key tensor and value
tensor). The first Tuple is of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/utils.py#L131"}}),Ln=new M({props:{name:"class transformers.generation.GenerateBeamDecoderOnlyOutput",anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
NOTE: some models have a different <code>past_key_values</code> format, confirm with the model&#x2019;s documentation.
Usually a Tuple (one element for each layer of the decoder) of tuples (two elements, key tensor and value
tensor). The first Tuple is of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/utils.py#L178"}}),Cn=new M({props:{name:"class transformers.generation.GenerateBeamEncoderDecoderOutput",anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
NOTE: some models have a different <code>past_key_values</code> format, confirm with the model&#x2019;s documentation.
Usually a Tuple (one element for each layer of the decoder) of tuples (two elements, key tensor and value
tensor). The first Tuple is of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/utils.py#L221"}}),Fn=new O({props:{title:"TensorFlow",local:"transformers.generation.TFGreedySearchEncoderDecoderOutput",headingTag:"h3"}}),Gn=new M({props:{name:"class transformers.generation.TFGreedySearchEncoderDecoderOutput",anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_utils.py#L85"}}),Xn=new M({props:{name:"class transformers.generation.TFGreedySearchDecoderOnlyOutput",anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_utils.py#L57"}}),Rn=new M({props:{name:"class transformers.generation.TFSampleEncoderDecoderOutput",anchor:"transformers.generation.TFSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size*num_return_sequences, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_utils.py#L155"}}),En=new M({props:{name:"class transformers.generation.TFSampleDecoderOnlyOutput",anchor:"transformers.generation.TFSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_utils.py#L127"}}),Nn=new M({props:{name:"class transformers.generation.TFBeamSearchEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. <code>Tuple of </code>tf.Tensor<code>with up to</code>max_new_tokens<code>elements (one element for each generated token), with each tensor of shape</code>(batch_size*num_beams, config.vocab_size)\`.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_utils.py#L232"}}),Sn=new M({props:{name:"class transformers.generation.TFBeamSearchDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_utils.py#L197"}}),qn=new M({props:{name:"class transformers.generation.TFBeamSampleEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_utils.py#L317"}}),Hn=new M({props:{name:"class transformers.generation.TFBeamSampleDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_utils.py#L282"}}),Dn=new M({props:{name:"class transformers.generation.TFContrastiveSearchEncoderDecoderOutput",anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_utils.py#L393"}}),Pn=new M({props:{name:"class transformers.generation.TFContrastiveSearchDecoderOnlyOutput",anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_utils.py#L366"}}),Qn=new O({props:{title:"FLAX",local:"transformers.generation.FlaxSampleOutput",headingTag:"h3"}}),Yn=new M({props:{name:"class transformers.generation.FlaxSampleOutput",anchor:"transformers.generation.FlaxSampleOutput",parameters:[{name:"sequences",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxSampleOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/flax_utils.py#L68"}}),An=new M({props:{name:"replace",anchor:"transformers.generation.FlaxSampleOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/flax/struct.py#L111"}}),On=new M({props:{name:"class transformers.generation.FlaxGreedySearchOutput",anchor:"transformers.generation.FlaxGreedySearchOutput",parameters:[{name:"sequences",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxGreedySearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/flax_utils.py#L54"}}),Kn=new M({props:{name:"replace",anchor:"transformers.generation.FlaxGreedySearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/flax/struct.py#L111"}}),er=new M({props:{name:"class transformers.generation.FlaxBeamSearchOutput",anchor:"transformers.generation.FlaxBeamSearchOutput",parameters:[{name:"sequences",val:": Array = None"},{name:"scores",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxBeamSearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"},{anchor:"transformers.generation.FlaxBeamSearchOutput.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size,)</code>) &#x2014;
The scores (log probabilities) of the generated sequences.`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/flax_utils.py#L82"}}),tr=new M({props:{name:"replace",anchor:"transformers.generation.FlaxBeamSearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/flax/struct.py#L111"}}),sr=new O({props:{title:"LogitsProcessor",local:"logitsprocessor",headingTag:"h2"}}),rr=new O({props:{title:"PyTorch",local:"transformers.AlternatingCodebooksLogitsProcessor",headingTag:"h3"}}),or=new M({props:{name:"class transformers.AlternatingCodebooksLogitsProcessor",anchor:"transformers.AlternatingCodebooksLogitsProcessor",parameters:[{name:"input_start_len",val:": int"},{name:"semantic_vocab_size",val:": int"},{name:"codebook_size",val:": int"}],parametersDescription:[{anchor:"transformers.AlternatingCodebooksLogitsProcessor.input_start_len",description:`<strong>input_start_len</strong> (<code>int</code>) &#x2014;
The length of the initial input sequence.`,name:"input_start_len"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.semantic_vocab_size",description:`<strong>semantic_vocab_size</strong> (<code>int</code>) &#x2014;
Vocabulary size of the semantic part, i.e number of tokens associated to the semantic vocabulary.`,name:"semantic_vocab_size"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.codebook_size",description:`<strong>codebook_size</strong> (<code>int</code>) &#x2014;
Number of tokens associated to the codebook.`,name:"codebook_size"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L2011"}}),Yt=new bn({props:{warning:!0,$$slots:{default:[Zw]},$$scope:{ctx:j}}}),ar=new M({props:{name:"__call__",anchor:"transformers.AlternatingCodebooksLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L2040"}}),lr=new M({props:{name:"class transformers.ClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:""}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (float) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale &gt; 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality.`,name:"guidance_scale"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L1947"}}),At=new bn({props:{warning:!0,$$slots:{default:[zw]},$$scope:{ctx:j}}}),Ot=new B({props:{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.example",$$slots:{default:[Ww]},$$scope:{ctx:j}}}),cr=new M({props:{name:"__call__",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L1995",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ir=new M({props:{name:"class transformers.EncoderNoRepeatNGramLogitsProcessor",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor",parameters:[{name:"encoder_ngram_size",val:": int"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_ngram_size",description:`<strong>encoder_ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur within the encoder input ids.`,name:"encoder_ngram_size"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>int</code>) &#x2014;
The encoder_input_ids that should not be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L874"}}),Kt=new B({props:{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.example",$$slots:{default:[Vw]},$$scope:{ctx:j}}}),dr=new M({props:{name:"__call__",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L923",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),pr=new M({props:{name:"class transformers.EncoderRepetitionPenaltyLogitsProcessor",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.penalty",description:`<strong>penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. Above 1.0 rewards prompt tokens. Between 0.0
and 1.0 penalizes prompt tokens.`,name:"penalty"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
The encoder_input_ids that should be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L342"}}),es=new B({props:{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.example",$$slots:{default:[Lw]},$$scope:{ctx:j}}}),mr=new M({props:{name:"__call__",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L386",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ur=new M({props:{name:"class transformers.EpsilonLogitsWarper",anchor:"transformers.EpsilonLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
If set to &gt; 0, only the most tokens with probabilities <code>epsilon</code> or higher are kept for generation.`,name:"epsilon"},{anchor:"transformers.EpsilonLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.EpsilonLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L603"}}),ts=new B({props:{anchor:"transformers.EpsilonLogitsWarper.example",$$slots:{default:[Cw]},$$scope:{ctx:j}}}),gr=new M({props:{name:"__call__",anchor:"transformers.EpsilonLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EpsilonLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L656",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),hr=new M({props:{name:"class transformers.EtaLogitsWarper",anchor:"transformers.EtaLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
A float value in the range (0, 1). Hyperparameter used to calculate the dynamic cutoff value, <code>eta</code>. The
suggested values from the paper ranges from 3e-4 to 4e-3 depending on the size of the model.`,name:"epsilon"},{anchor:"transformers.EtaLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All values that are found to be below the dynamic cutoff value, <code>eta</code>, are set to this float value. This
parameter is useful when logits need to be modified for very low probability tokens that should be excluded
from generation entirely.`,name:"filter_value"},{anchor:"transformers.EtaLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Specifies the minimum number of tokens that must be kept for generation, regardless of their probabilities.
For example, if <code>min_tokens_to_keep</code> is set to 1, at least one token will always be kept for generation,
even if all tokens have probabilities below the cutoff <code>eta</code>.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L670"}}),ss=new B({props:{anchor:"transformers.EtaLogitsWarper.example",$$slots:{default:[Fw]},$$scope:{ctx:j}}}),fr=new M({props:{name:"__call__",anchor:"transformers.EtaLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EtaLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L733",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),_r=new M({props:{name:"class transformers.ExponentialDecayLengthPenalty",anchor:"transformers.ExponentialDecayLengthPenalty",parameters:[{name:"exponential_decay_length_penalty",val:": Tuple"},{name:"eos_token_id",val:": Union"},{name:"input_ids_seq_length",val:": int"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.exponential_decay_length_penalty",description:`<strong>exponential_decay_length_penalty</strong> (<code>tuple(int, float)</code>) &#x2014;
This tuple shall consist of: <code>(start_index, decay_factor)</code> where <code>start_index</code> indicates where penalty
starts and <code>decay_factor</code> represents the factor of exponential decay`,name:"exponential_decay_length_penalty"},{anchor:"transformers.ExponentialDecayLengthPenalty.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.ExponentialDecayLengthPenalty.input_ids_seq_length",description:`<strong>input_ids_seq_length</strong> (<code>int</code>) &#x2014;
The length of the input sequence.`,name:"input_ids_seq_length"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L1494"}}),ns=new B({props:{anchor:"transformers.ExponentialDecayLengthPenalty.example",$$slots:{default:[Gw]},$$scope:{ctx:j}}}),br=new M({props:{name:"__call__",anchor:"transformers.ExponentialDecayLengthPenalty.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L1574",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),yr=new M({props:{name:"class transformers.ForcedBOSTokenLogitsProcessor",anchor:"transformers.ForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L1378"}}),rs=new B({props:{anchor:"transformers.ForcedBOSTokenLogitsProcessor.example",$$slots:{default:[Xw]},$$scope:{ctx:j}}}),Tr=new M({props:{name:"__call__",anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L1413",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),vr=new M({props:{name:"class transformers.ForcedEOSTokenLogitsProcessor",anchor:"transformers.ForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": Union"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached. Optionally, use a
list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L1423"}}),os=new B({props:{anchor:"transformers.ForcedEOSTokenLogitsProcessor.example",$$slots:{default:[Rw]},$$scope:{ctx:j}}}),Mr=new M({props:{name:"__call__",anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L1462",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),wr=new M({props:{name:"class transformers.ForceTokensLogitsProcessor",anchor:"transformers.ForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:": List"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L1710"}}),as=new B({props:{anchor:"transformers.ForceTokensLogitsProcessor.example",$$slots:{default:[Ew]},$$scope:{ctx:j}}}),kr=new M({props:{name:"__call__",anchor:"transformers.ForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForceTokensLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForceTokensLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L1751",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),$r=new M({props:{name:"class transformers.HammingDiversityLogitsProcessor",anchor:"transformers.HammingDiversityLogitsProcessor",parameters:[{name:"diversity_penalty",val:": float"},{name:"num_beams",val:": int"},{name:"num_beam_groups",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.diversity_penalty",description:`<strong>diversity_penalty</strong> (<code>float</code>) &#x2014;
This value is subtracted from a beam&#x2019;s score if it generates a token same as any beam from other group at a
particular time. A higher <code>diversity_penalty</code> will enforce greater diversity among the beams. Adjusting
this value can help strike a balance between diversity and natural likelihood.`,name:"diversity_penalty"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search. 1 means no beam search.`,name:"num_beams"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
<a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L1245"}}),ls=new B({props:{anchor:"transformers.HammingDiversityLogitsProcessor.example",$$slots:{default:[Nw]},$$scope:{ctx:j}}}),jr=new M({props:{name:"__call__",anchor:"transformers.HammingDiversityLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"current_tokens",val:": LongTensor"},{name:"beam_group_idx",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.current_tokens",description:`<strong>current_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary, corresponding to the tokens selected by the other
beam groups in the current generation step.`,name:"current_tokens"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.beam_group_idx",description:`<strong>beam_group_idx</strong> (<code>int</code>) &#x2014;
The index of the beam group currently being processed.`,name:"beam_group_idx"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L1332",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),xr=new M({props:{name:"class transformers.InfNanRemoveLogitsProcessor",anchor:"transformers.InfNanRemoveLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L1473"}}),Jr=new M({props:{name:"__call__",anchor:"transformers.InfNanRemoveLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L1482",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ur=new M({props:{name:"class transformers.LogitNormalization",anchor:"transformers.LogitNormalization",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L1585"}}),cs=new B({props:{anchor:"transformers.LogitNormalization.example",$$slots:{default:[Sw]},$$scope:{ctx:j}}}),Br=new M({props:{name:"__call__",anchor:"transformers.LogitNormalization.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitNormalization.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitNormalization.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L1616",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ir=new M({props:{name:"class transformers.LogitsProcessor",anchor:"transformers.LogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L44"}}),Zr=new M({props:{name:"__call__",anchor:"transformers.LogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L47",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),zr=new M({props:{name:"class transformers.LogitsProcessorList",anchor:"transformers.LogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L64"}}),Wr=new M({props:{name:"__call__",anchor:"transformers.LogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.LogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional kwargs that are specific to a logits processor.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L71",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Vr=new M({props:{name:"class transformers.LogitsWarper",anchor:"transformers.LogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L54"}}),Lr=new M({props:{name:"__call__",anchor:"transformers.LogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L57",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Cr=new M({props:{name:"class transformers.MinLengthLogitsProcessor",anchor:"transformers.MinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": Union"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.MinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L102"}}),is=new B({props:{anchor:"transformers.MinLengthLogitsProcessor.example",$$slots:{default:[qw]},$$scope:{ctx:j}}}),Fr=new M({props:{name:"__call__",anchor:"transformers.MinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L151",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Gr=new M({props:{name:"class transformers.MinNewTokensLengthLogitsProcessor",anchor:"transformers.MinNewTokensLengthLogitsProcessor",parameters:[{name:"prompt_length_to_skip",val:": int"},{name:"min_new_tokens",val:": int"},{name:"eos_token_id",val:": Union"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.prompt_length_to_skip",description:`<strong>prompt_length_to_skip</strong> (<code>int</code>) &#x2014;
The input tokens length. Not a valid argument when used with <code>generate</code> as it will automatically assign the
input length.`,name:"prompt_length_to_skip"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>) &#x2014;
The minimum <em>new</em> tokens length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_new_tokens"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L160"}}),ds=new B({props:{anchor:"transformers.MinNewTokensLengthLogitsProcessor.example",$$slots:{default:[Hw]},$$scope:{ctx:j}}}),Xr=new M({props:{name:"__call__",anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L212",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Rr=new M({props:{name:"class transformers.NoBadWordsLogitsProcessor",anchor:"transformers.NoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": List"},{name:"eos_token_id",val:": Union"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated.`,name:"bad_words_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L1090"}}),ps=new bn({props:{$$slots:{default:[Dw]},$$scope:{ctx:j}}}),ms=new B({props:{anchor:"transformers.NoBadWordsLogitsProcessor.example",$$slots:{default:[Pw]},$$scope:{ctx:j}}}),Er=new M({props:{name:"__call__",anchor:"transformers.NoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L1013",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Nr=new M({props:{name:"class transformers.NoRepeatNGramLogitsProcessor",anchor:"transformers.NoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L816"}}),us=new bn({props:{$$slots:{default:[Qw]},$$scope:{ctx:j}}}),gs=new B({props:{anchor:"transformers.NoRepeatNGramLogitsProcessor.example",$$slots:{default:[Yw]},$$scope:{ctx:j}}}),Sr=new M({props:{name:"__call__",anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L863",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),qr=new M({props:{name:"class transformers.PrefixConstrainedLogitsProcessor",anchor:"transformers.PrefixConstrainedLogitsProcessor",parameters:[{name:"prefix_allowed_tokens_fn",val:": Callable"},{name:"num_beams",val:": int"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>) &#x2014;
This function constraints the beam search to allowed tokens only at each step. This function takes 2
arguments <code>inputs_ids</code> and the batch ID <code>batch_id</code>. It has to return a list with the allowed tokens for the
next generation step conditioned on the previously generated tokens <code>inputs_ids</code> and the batch ID
<code>batch_id</code>.`,name:"prefix_allowed_tokens_fn"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L1177"}}),hs=new B({props:{anchor:"transformers.PrefixConstrainedLogitsProcessor.example",$$slots:{default:[Aw]},$$scope:{ctx:j}}}),Hr=new M({props:{name:"__call__",anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L1228",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Dr=new M({props:{name:"class transformers.RepetitionPenaltyLogitsProcessor",anchor:"transformers.RepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.penalty",description:`<strong>penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. Above 1.0 penalizes previously generated
tokens. Between 0.0 and 1.0 rewards previously generated tokens.`,name:"penalty"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L288"}}),fs=new B({props:{anchor:"transformers.RepetitionPenaltyLogitsProcessor.example",$$slots:{default:[Ow]},$$scope:{ctx:j}}}),Pr=new M({props:{name:"__call__",anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L331",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Qr=new M({props:{name:"class transformers.SequenceBiasLogitsProcessor",anchor:"transformers.SequenceBiasLogitsProcessor",parameters:[{name:"sequence_bias",val:": Dict"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.sequence_bias",description:`<strong>sequence_bias</strong> (<code>Dict[Tuple[int], float]</code>) &#x2014;
Dictionary that maps a sequence of tokens to its bias term. Positive biases increase the odds of the
sequence being selected, while negative biases do the opposite. If a sequence has a length of 1, its bias
will always be applied. Otherwise, the bias will only be applied if the sequence in question is about to be
completed (in the token selection step after this processor is applied).`,name:"sequence_bias"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L942"}}),_s=new bn({props:{$$slots:{default:[Kw]},$$scope:{ctx:j}}}),bs=new B({props:{anchor:"transformers.SequenceBiasLogitsProcessor.example",$$slots:{default:[ek]},$$scope:{ctx:j}}}),Yr=new M({props:{name:"__call__",anchor:"transformers.SequenceBiasLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L1013",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ar=new M({props:{name:"class transformers.SuppressTokensAtBeginLogitsProcessor",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L1622"}}),ys=new B({props:{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.example",$$slots:{default:[tk]},$$scope:{ctx:j}}}),Or=new M({props:{name:"__call__",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L1664",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Kr=new M({props:{name:"class transformers.SuppressTokensLogitsProcessor",anchor:"transformers.SuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L1672"}}),Ts=new B({props:{anchor:"transformers.SuppressTokensLogitsProcessor.example",$$slots:{default:[sk]},$$scope:{ctx:j}}}),eo=new M({props:{name:"__call__",anchor:"transformers.SuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L1704",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),to=new M({props:{name:"class transformers.TemperatureLogitsWarper",anchor:"transformers.TemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
Strictly positive float value used to modulate the logits distribution. A value smaller than <code>1</code> decreases
randomness (and vice versa), with <code>0</code> being equivalent to shifting all probability mass to the most likely
token.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L222"}}),vs=new bn({props:{$$slots:{default:[nk]},$$scope:{ctx:j}}}),Ms=new B({props:{anchor:"transformers.TemperatureLogitsWarper.example",$$slots:{default:[rk]},$$scope:{ctx:j}}}),so=new M({props:{name:"__call__",anchor:"transformers.TemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TemperatureLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L282",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),no=new M({props:{name:"class transformers.TopKLogitsWarper",anchor:"transformers.TopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L462"}}),ws=new B({props:{anchor:"transformers.TopKLogitsWarper.example",$$slots:{default:[ok]},$$scope:{ctx:j}}}),ro=new M({props:{name:"__call__",anchor:"transformers.TopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopKLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L506",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),oo=new M({props:{name:"class transformers.TopPLogitsWarper",anchor:"transformers.TopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L397"}}),ks=new B({props:{anchor:"transformers.TopPLogitsWarper.example",$$slots:{default:[ak]},$$scope:{ctx:j}}}),ao=new M({props:{name:"__call__",anchor:"transformers.TopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopPLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L446",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),lo=new M({props:{name:"class transformers.TypicalLogitsWarper",anchor:"transformers.TypicalLogitsWarper",parameters:[{name:"mass",val:": float = 0.9"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.mass",description:`<strong>mass</strong> (<code>float</code>, <em>optional</em>, defaults to 0.9) &#x2014;
Value of typical_p between 0 and 1 inclusive, defaults to 0.9.`,name:"mass"},{anchor:"transformers.TypicalLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TypicalLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L515"}}),$s=new B({props:{anchor:"transformers.TypicalLogitsWarper.example",$$slots:{default:[lk]},$$scope:{ctx:j}}}),co=new M({props:{name:"__call__",anchor:"transformers.TypicalLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TypicalLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L579",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),io=new M({props:{name:"class transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:": float"},{name:"model",val:""},{name:"unconditional_ids",val:": Optional = None"},{name:"unconditional_attention_mask",val:": Optional = None"},{name:"use_cache",val:": Optional = True"}],parametersDescription:[{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale != 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality. A value smaller than 1 has the opposite effect, while
making the negative prompt provided with negative_prompt_ids (if any) act as a positive prompt.`,name:"guidance_scale"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.model",description:`<strong>model</strong> (<code>PreTrainedModel</code>) &#x2014;
The model computing the unconditional scores. Supposedly the same as the one computing the conditional
scores. Both models must use the same tokenizer.`,name:"model"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_ids",description:`<strong>unconditional_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary for the unconditional branch. If unset, will default to
the last token of the prompt.`,name:"unconditional_ids"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_attention_mask",description:`<strong>unconditional_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Attention mask for unconditional_ids.`,name:"unconditional_attention_mask"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to cache key/values during the negative prompt forward pass.`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L2055"}}),js=new B({props:{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.example",$$slots:{default:[ck]},$$scope:{ctx:j}}}),po=new M({props:{name:"__call__",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L2161"}}),mo=new M({props:{name:"class transformers.WhisperTimeStampLogitsProcessor",anchor:"transformers.WhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""},{name:"begin_index",val:": Optional = None"},{name:"_detect_timestamp_from_logprob",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"},{anchor:"transformers.WhisperTimeStampLogitsProcessor.begin_index",description:"<strong>begin_index</strong> (<code>Optional</code>, <em>optional</em>) &#x2014; Token index of the first token that is generated by the model.",name:"begin_index"},{anchor:"transformers.WhisperTimeStampLogitsProcessor._detect_timestamp_from_logprob",description:"<strong>_detect_timestamp_from_logprob</strong> (<code>bool</code>, <em>optional</em>) &#x2014; Whether timestamps can be predicted from logprobs over all timestamps.",name:"_detect_timestamp_from_logprob"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L1761"}}),xs=new B({props:{anchor:"transformers.WhisperTimeStampLogitsProcessor.example",$$slots:{default:[ik]},$$scope:{ctx:j}}}),uo=new M({props:{name:"__call__",anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/logits_process.py#L1843",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),go=new O({props:{title:"TensorFlow",local:"transformers.TFForcedBOSTokenLogitsProcessor",headingTag:"h3"}}),ho=new M({props:{name:"class transformers.TFForcedBOSTokenLogitsProcessor",anchor:"transformers.TFForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_logits_process.py#L448"}}),fo=new M({props:{name:"__call__",anchor:"transformers.TFForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_logits_process.py#L462"}}),_o=new M({props:{name:"class transformers.TFForcedEOSTokenLogitsProcessor",anchor:"transformers.TFForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_logits_process.py#L478"}}),bo=new M({props:{name:"__call__",anchor:"transformers.TFForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_logits_process.py#L495"}}),yo=new M({props:{name:"class transformers.TFForceTokensLogitsProcessor",anchor:"transformers.TFForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:": List"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_logits_process.py#L551"}}),To=new M({props:{name:"__call__",anchor:"transformers.TFForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_logits_process.py#L567"}}),vo=new M({props:{name:"class transformers.TFLogitsProcessor",anchor:"transformers.TFLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_logits_process.py#L53"}}),Mo=new M({props:{name:"__call__",anchor:"transformers.TFLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.37.2/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.37.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.37.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessor.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_logits_process.py#L56",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),wo=new M({props:{name:"class transformers.TFLogitsProcessorList",anchor:"transformers.TFLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_logits_process.py#L75"}}),ko=new M({props:{name:"__call__",anchor:"transformers.TFLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.37.2/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.37.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.37.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessorList.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_logits_process.py#L82",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),$o=new M({props:{name:"class transformers.TFLogitsWarper",anchor:"transformers.TFLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_logits_process.py#L64"}}),jo=new M({props:{name:"__call__",anchor:"transformers.TFLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.37.2/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.37.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.37.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsWarper.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_logits_process.py#L67",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),xo=new M({props:{name:"class transformers.TFMinLengthLogitsProcessor",anchor:"transformers.TFMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.TFMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_logits_process.py#L202"}}),Jo=new M({props:{name:"__call__",anchor:"transformers.TFMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_logits_process.py#L228"}}),Uo=new M({props:{name:"class transformers.TFNoBadWordsLogitsProcessor",anchor:"transformers.TFNoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": List"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated. In order to get the tokens of the words
that should not appear in the generated text, make sure to set <code>add_prefix_space=True</code> when initializing
the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The <code>add_prefix_space</code>
argument is only supported for some slow tokenizers, as fast tokenizers&#x2019; prefixing behaviours come from
<code>pre tokenizers</code>. Read more <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`,name:"bad_words_ids"},{anchor:"transformers.TFNoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_logits_process.py#L288"}}),Bo=new M({props:{name:"__call__",anchor:"transformers.TFNoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_logits_process.py#L367"}}),Io=new M({props:{name:"class transformers.TFNoRepeatNGramLogitsProcessor",anchor:"transformers.TFNoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_logits_process.py#L388"}}),Zo=new M({props:{name:"__call__",anchor:"transformers.TFNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_logits_process.py#L427"}}),zo=new M({props:{name:"class transformers.TFRepetitionPenaltyLogitsProcessor",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"}],parametersDescription:[{anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_logits_process.py#L238"}}),Wo=new M({props:{name:"__call__",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_logits_process.py#L280"}}),Vo=new M({props:{name:"class transformers.TFSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_logits_process.py#L511"}}),Lo=new M({props:{name:"__call__",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_logits_process.py#L522"}}),Co=new M({props:{name:"class transformers.TFSuppressTokensLogitsProcessor",anchor:"transformers.TFSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_logits_process.py#L535"}}),Fo=new M({props:{name:"__call__",anchor:"transformers.TFSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_logits_process.py#L542"}}),Go=new M({props:{name:"class transformers.TFTemperatureLogitsWarper",anchor:"transformers.TFTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TFTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_logits_process.py#L98"}}),Xo=new M({props:{name:"__call__",anchor:"transformers.TFTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_logits_process.py#L113"}}),Ro=new M({props:{name:"class transformers.TFTopKLogitsWarper",anchor:"transformers.TFTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TFTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_logits_process.py#L118"}}),Eo=new M({props:{name:"__call__",anchor:"transformers.TFTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_logits_process.py#L138"}}),No=new M({props:{name:"class transformers.TFTopPLogitsWarper",anchor:"transformers.TFTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TFTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_logits_process.py#L146"}}),So=new M({props:{name:"__call__",anchor:"transformers.TFTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_logits_process.py#L170"}}),qo=new O({props:{title:"FLAX",local:"transformers.FlaxForcedBOSTokenLogitsProcessor",headingTag:"h3"}}),Ho=new M({props:{name:"class transformers.FlaxForcedBOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/flax_logits_process.py#L194"}}),Do=new M({props:{name:"__call__",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/flax_logits_process.py#L206"}}),Po=new M({props:{name:"class transformers.FlaxForcedEOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/flax_logits_process.py#L216"}}),Qo=new M({props:{name:"__call__",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/flax_logits_process.py#L231"}}),Yo=new M({props:{name:"class transformers.FlaxForceTokensLogitsProcessor",anchor:"transformers.FlaxForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:""}],parametersDescription:[{anchor:"transformers.FlaxForceTokensLogitsProcessor.force_token_map",description:`<strong>force_token_map</strong> (<code>list</code>) &#x2014;
Map giving token ids and indices where they will be forced to be sampled.`,name:"force_token_map"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/flax_logits_process.py#L315"}}),Ao=new M({props:{name:"__call__",anchor:"transformers.FlaxForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/flax_logits_process.py#L337"}}),Oo=new M({props:{name:"class transformers.FlaxLogitsProcessor",anchor:"transformers.FlaxLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/flax_logits_process.py#L50"}}),Ko=new M({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.37.2/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.37.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.37.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/flax_logits_process.py#L53",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ea=new M({props:{name:"class transformers.FlaxLogitsProcessorList",anchor:"transformers.FlaxLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/flax_logits_process.py#L72"}}),ta=new M({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.37.2/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.37.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.37.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/flax_logits_process.py#L79",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),sa=new M({props:{name:"class transformers.FlaxLogitsWarper",anchor:"transformers.FlaxLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/flax_logits_process.py#L61"}}),na=new M({props:{name:"__call__",anchor:"transformers.FlaxLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.37.2/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.37.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.37.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/flax_logits_process.py#L64",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ra=new M({props:{name:"class transformers.FlaxMinLengthLogitsProcessor",anchor:"transformers.FlaxMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.FlaxMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/flax_logits_process.py#L241"}}),oa=new M({props:{name:"__call__",anchor:"transformers.FlaxMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/flax_logits_process.py#L262"}}),aa=new M({props:{name:"class transformers.FlaxSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_suppress_tokens",description:`<strong>begin_suppress_tokens</strong> (<code>List[int]</code>) &#x2014;
Tokens to not sample.`,name:"begin_suppress_tokens"},{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_index",description:`<strong>begin_index</strong> (<code>int</code>) &#x2014;
Index where the tokens are suppressed.`,name:"begin_index"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/flax_logits_process.py#L271"}}),la=new M({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/flax_logits_process.py#L288"}}),ca=new M({props:{name:"class transformers.FlaxSuppressTokensLogitsProcessor",anchor:"transformers.FlaxSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:": list"}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensLogitsProcessor.suppress_tokens",description:`<strong>suppress_tokens</strong> (<code>list</code>) &#x2014;
Tokens to not sample.`,name:"suppress_tokens"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/flax_logits_process.py#L296"}}),ia=new M({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/flax_logits_process.py#L309"}}),da=new M({props:{name:"class transformers.FlaxTemperatureLogitsWarper",anchor:"transformers.FlaxTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.FlaxTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/flax_logits_process.py#L95"}}),pa=new M({props:{name:"__call__",anchor:"transformers.FlaxTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/flax_logits_process.py#L110"}}),ma=new M({props:{name:"class transformers.FlaxTopKLogitsWarper",anchor:"transformers.FlaxTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.FlaxTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/flax_logits_process.py#L159"}}),ua=new M({props:{name:"__call__",anchor:"transformers.FlaxTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/flax_logits_process.py#L179"}}),ga=new M({props:{name:"class transformers.FlaxTopPLogitsWarper",anchor:"transformers.FlaxTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.FlaxTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/flax_logits_process.py#L115"}}),ha=new M({props:{name:"__call__",anchor:"transformers.FlaxTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/flax_logits_process.py#L139"}}),fa=new M({props:{name:"class transformers.FlaxWhisperTimeStampLogitsProcessor",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""},{name:"model_config",val:""},{name:"decoder_input_length",val:""}],parametersDescription:[{anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/flax_logits_process.py#L363"}}),_a=new M({props:{name:"__call__",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/flax_logits_process.py#L397"}}),ba=new O({props:{title:"StoppingCriteria",local:"transformers.StoppingCriteria",headingTag:"h2"}}),Ta=new M({props:{name:"class transformers.StoppingCriteria",anchor:"transformers.StoppingCriteria",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/stopping_criteria.py#L37"}}),va=new M({props:{name:"__call__",anchor:"transformers.StoppingCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.37.2/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.37.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.37.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.StoppingCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/stopping_criteria.py#L44",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code>. <code>False</code> indicates we should continue, <code>True</code> indicates we should stop.</p>
`}}),Ma=new M({props:{name:"class transformers.StoppingCriteriaList",anchor:"transformers.StoppingCriteriaList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/stopping_criteria.py#L129"}}),wa=new M({props:{name:"__call__",anchor:"transformers.StoppingCriteriaList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteriaList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.37.2/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.37.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.37.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteriaList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.StoppingCriteriaList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/stopping_criteria.py#L130",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code>. <code>False</code> indicates we should continue, <code>True</code> indicates we should stop.</p>
`}}),ka=new M({props:{name:"class transformers.MaxLengthCriteria",anchor:"transformers.MaxLengthCriteria",parameters:[{name:"max_length",val:": int"},{name:"max_position_embeddings",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length that the output sequence can have in number of tokens.`,name:"max_length"},{anchor:"transformers.MaxLengthCriteria.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum model length, as defined by the model&#x2019;s <code>config.max_position_embeddings</code> attribute.`,name:"max_position_embeddings"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/stopping_criteria.py#L49"}}),$a=new M({props:{name:"__call__",anchor:"transformers.MaxLengthCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.37.2/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.37.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.37.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxLengthCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.MaxLengthCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/stopping_criteria.py#L65",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code>. <code>False</code> indicates we should continue, <code>True</code> indicates we should stop.</p>
`}}),ja=new M({props:{name:"class transformers.MaxTimeCriteria",anchor:"transformers.MaxTimeCriteria",parameters:[{name:"max_time",val:": float"},{name:"initial_timestamp",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.max_time",description:`<strong>max_time</strong> (<code>float</code>) &#x2014;
The maximum allowed time in seconds for the generation.`,name:"max_time"},{anchor:"transformers.MaxTimeCriteria.initial_time",description:`<strong>initial_time</strong> (<code>float</code>, <em>optional</em>, defaults to <code>time.time()</code>) &#x2014;
The start of the generation allowed time.`,name:"initial_time"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/stopping_criteria.py#L107"}}),xa=new M({props:{name:"__call__",anchor:"transformers.MaxTimeCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.37.2/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.37.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.37.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxTimeCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.MaxTimeCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/stopping_criteria.py#L124",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code>. <code>False</code> indicates we should continue, <code>True</code> indicates we should stop.</p>
`}}),Ja=new O({props:{title:"Constraints",local:"transformers.Constraint",headingTag:"h2"}}),Ba=new M({props:{name:"class transformers.Constraint",anchor:"transformers.Constraint",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/beam_constraints.py#L5"}}),Zs=new B({props:{anchor:"transformers.Constraint.example",$$slots:{default:[dk]},$$scope:{ctx:j}}}),Ia=new M({props:{name:"advance",anchor:"transformers.Constraint.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/beam_constraints.py#L48",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Must be a tensor of a list of indexable tokens, not some integer.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>token_ids(<code>torch.tensor</code>)</p>
`}}),Za=new M({props:{name:"copy",anchor:"transformers.Constraint.copy",parameters:[{name:"stateful",val:" = False"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/beam_constraints.py#L113",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The same constraint as the one being called from.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>constraint(<code>Constraint</code>)</p>
`}}),za=new M({props:{name:"does_advance",anchor:"transformers.Constraint.does_advance",parameters:[{name:"token_id",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/beam_constraints.py#L60"}}),Wa=new M({props:{name:"remaining",anchor:"transformers.Constraint.remaining",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/beam_constraints.py#L104"}}),Va=new M({props:{name:"reset",anchor:"transformers.Constraint.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/beam_constraints.py#L94"}}),La=new M({props:{name:"test",anchor:"transformers.Constraint.test",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/beam_constraints.py#L24"}}),Ca=new M({props:{name:"update",anchor:"transformers.Constraint.update",parameters:[{name:"token_id",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/beam_constraints.py#L69",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Whether this constraint has become one step closer to being fulfuilled.
completed(<code>bool</code>):
Whether this constraint has been completely fulfilled by this token being generated.
reset (<code>bool</code>):
Whether this constraint has reset its progress by this token being generated.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>stepped(<code>bool</code>)</p>
`}}),Fa=new M({props:{name:"class transformers.PhrasalConstraint",anchor:"transformers.PhrasalConstraint",parameters:[{name:"token_ids",val:": List"}],parametersDescription:[{anchor:"transformers.PhrasalConstraint.token_ids",description:`<strong>token_ids</strong> (<code>List[int]</code>) &#x2014;
The id of the token that must be generated by the output.`,name:"token_ids"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/beam_constraints.py#L129"}}),Ga=new M({props:{name:"class transformers.DisjunctiveConstraint",anchor:"transformers.DisjunctiveConstraint",parameters:[{name:"nested_token_ids",val:": List"}],parametersDescription:[{anchor:"transformers.DisjunctiveConstraint.nested_token_ids",description:`<strong>nested_token_ids</strong> (<code>List[List[int]]</code>) &#x2014;
A list of words, where each word is a list of ids. This constraint is fulfilled by generating just one from
the list of words.`,name:"nested_token_ids"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/beam_constraints.py#L261"}}),Xa=new M({props:{name:"class transformers.ConstraintListState",anchor:"transformers.ConstraintListState",parameters:[{name:"constraints",val:": List"}],parametersDescription:[{anchor:"transformers.ConstraintListState.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of <a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.Constraint">Constraint</a> objects that must be fulfilled by the beam scorer.`,name:"constraints"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/beam_constraints.py#L351"}}),Ra=new M({props:{name:"advance",anchor:"transformers.ConstraintListState.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/beam_constraints.py#L383"}}),Ea=new M({props:{name:"reset",anchor:"transformers.ConstraintListState.reset",parameters:[{name:"token_ids",val:": Optional"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/beam_constraints.py#L418"}}),Na=new O({props:{title:"BeamSearch",local:"transformers.BeamScorer",headingTag:"h2"}}),Sa=new M({props:{name:"class transformers.BeamScorer",anchor:"transformers.BeamScorer",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/beam_search.py#L91"}}),qa=new M({props:{name:"process",anchor:"transformers.BeamScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/v4.37.2/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/v4.37.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/v4.37.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.BeamScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.BeamScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.BeamScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.BeamScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"},{anchor:"transformers.BeamScorer.process.group_index",description:`<strong>group_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The index of the group of beams. Used with <a href="/docs/transformers/v4.37.2/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search">group_beam_search()</a>.`,name:"group_index"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/beam_search.py#L97",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Updated scores of all
non-finished beams.</li>
<li><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Next tokens to be added
to the non-finished beam_hypotheses.</li>
<li><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Beam indices
indicating to which beam the next tokens shall be added.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>UserDict</code></p>
`}}),Ha=new M({props:{name:"finalize",anchor:"transformers.BeamScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.finalize.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/v4.37.2/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/v4.37.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/v4.37.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.finalize.final_beam_scores",description:`<strong>final_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The final scores of all non-finished beams.`,name:"final_beam_scores"},{anchor:"transformers.BeamScorer.finalize.final_beam_tokens",description:`<strong>final_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The last tokens to be added to the non-finished beam_hypotheses.`,name:"final_beam_tokens"},{anchor:"transformers.BeamScorer.finalize.final_beam_indices",description:`<strong>final_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The beam indices indicating to which beam the <code>final_beam_tokens</code> shall be added.`,name:"final_beam_indices"},{anchor:"transformers.BeamScorer.finalize.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.finalize.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/beam_search.py#L109",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated sequences.
The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter if all batches finished early
due to the <code>eos_token_id</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.LongTensor</code> of shape <code>(batch_size * num_return_sequences, sequence_length)</code></p>
`}}),Da=new M({props:{name:"class transformers.BeamSearchScorer",anchor:"transformers.BeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"device",val:": device"},{name:"length_penalty",val:": Optional = 1.0"},{name:"do_early_stopping",val:": Union = False"},{name:"num_beam_hyps_to_keep",val:": Optional = 1"},{name:"num_beam_groups",val:": Optional = 1"},{name:"max_length",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.BeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.BeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.BeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.BeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.BeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.BeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.BeamSearchScorer.finalize">finalize()</a>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.BeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.BeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/beam_search.py#L123"}}),Pa=new M({props:{name:"process",anchor:"transformers.BeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"pad_token_id",val:": Optional = None"},{name:"eos_token_id",val:": Union = None"},{name:"beam_indices",val:": Optional = None"},{name:"group_index",val:": Optional = 0"},{name:"decoder_prompt_len",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/beam_search.py#L215"}}),Qa=new M({props:{name:"finalize",anchor:"transformers.BeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": Optional = None"},{name:"eos_token_id",val:": Union = None"},{name:"beam_indices",val:": Optional = None"},{name:"decoder_prompt_len",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/beam_search.py#L318"}}),Ya=new M({props:{name:"class transformers.ConstrainedBeamSearchScorer",anchor:"transformers.ConstrainedBeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"constraints",val:": List"},{name:"device",val:": device"},{name:"length_penalty",val:": Optional = 1.0"},{name:"do_early_stopping",val:": Union = False"},{name:"num_beam_hyps_to_keep",val:": Optional = 1"},{name:"num_beam_groups",val:": Optional = 1"},{name:"max_length",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.ConstrainedBeamSearchScorer.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of positive constraints represented as <code>Constraint</code> objects that must be fulfilled in the generation
output. For more information, the documentation of <a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.Constraint">Constraint</a> should be read.`,name:"constraints"},{anchor:"transformers.ConstrainedBeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.ConstrainedBeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.ConstrainedBeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<a href="/docs/transformers/v4.37.2/en/internal/generation_utils#transformers.BeamSearchScorer.finalize">finalize()</a>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.ConstrainedBeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/beam_search.py#L415"}}),Aa=new M({props:{name:"process",anchor:"transformers.ConstrainedBeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"scores_for_all_vocab",val:": FloatTensor"},{name:"pad_token_id",val:": Optional = None"},{name:"eos_token_id",val:": Union = None"},{name:"beam_indices",val:": Optional = None"},{name:"decoder_prompt_len",val:": Optional = 0"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/v4.37.2/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/v4.37.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/v4.37.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.scores_for_all_vocab",description:`<strong>scores_for_all_vocab</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
The scores of all tokens in the vocabulary for each of the beam hypotheses.`,name:"scores_for_all_vocab"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.decoder_prompt_len",description:`<strong>decoder_prompt_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The length of prompt that is included in the input to decoder.`,name:"decoder_prompt_len"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/beam_search.py#L509",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li>
<p><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Updated scores of
all
non-finished beams.</p>
</li>
<li>
<p><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Next tokens to be
added
to the non-finished beam_hypotheses.</p>
</li>
<li>
<p><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Beam indices
indicating to which beam the next tokens shall be added.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>UserDict</code></p>
`}}),Oa=new M({props:{name:"finalize",anchor:"transformers.ConstrainedBeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": Optional = None"},{name:"eos_token_id",val:": Union = None"},{name:"beam_indices",val:": Optional = None"},{name:"decoder_prompt_len",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/beam_search.py#L807"}}),Ka=new O({props:{title:"Utilities",local:"transformers.top_k_top_p_filtering",headingTag:"h2"}}),el=new M({props:{name:"transformers.top_k_top_p_filtering",anchor:"transformers.top_k_top_p_filtering",parameters:[{name:"logits",val:": FloatTensor"},{name:"top_k",val:": int = 0"},{name:"top_p",val:": float = 1.0"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.top_k_top_p_filtering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If &gt; 0, only keep the top k tokens with highest probability (top-k filtering)`,name:"top_k"},{anchor:"transformers.top_k_top_p_filtering.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
If &lt; 1.0, only keep the top tokens with cumulative probability &gt;= top_p (nucleus filtering). Nucleus
filtering is described in Holtzman et al. (<a href="http://arxiv.org/abs/1904.09751" rel="nofollow">http://arxiv.org/abs/1904.09751</a>)`,name:"top_p"},{anchor:"transformers.top_k_top_p_filtering.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimumber of tokens we keep per batch example in the output.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/utils.py#L4610"}}),tl=new M({props:{name:"transformers.tf_top_k_top_p_filtering",anchor:"transformers.tf_top_k_top_p_filtering",parameters:[{name:"logits",val:""},{name:"top_k",val:" = 0"},{name:"top_p",val:" = 1.0"},{name:"filter_value",val:" = -inf"},{name:"min_tokens_to_keep",val:" = 1"}],parametersDescription:[{anchor:"transformers.tf_top_k_top_p_filtering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If &gt; 0, only keep the top k tokens with highest probability (top-k filtering)`,name:"top_k"},{anchor:"transformers.tf_top_k_top_p_filtering.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
If &lt; 1.0, only keep the top tokens with cumulative probability &gt;= top_p (nucleus filtering). Nucleus
filtering is described in Holtzman et al. (<a href="http://arxiv.org/abs/1904.09751" rel="nofollow">http://arxiv.org/abs/1904.09751</a>)`,name:"top_p"},{anchor:"transformers.tf_top_k_top_p_filtering.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimumber of tokens we keep per batch example in the output.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/tf_utils.py#L3092"}}),sl=new O({props:{title:"Streamers",local:"transformers.TextStreamer",headingTag:"h2"}}),nl=new M({props:{name:"class transformers.TextStreamer",anchor:"transformers.TextStreamer",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"skip_prompt",val:": bool = False"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/streamers.py#L38"}}),Xs=new bn({props:{warning:!0,$$slots:{default:[pk]},$$scope:{ctx:j}}}),Rs=new B({props:{anchor:"transformers.TextStreamer.example",$$slots:{default:[mk]},$$scope:{ctx:j}}}),rl=new M({props:{name:"end",anchor:"transformers.TextStreamer.end",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/streamers.py#L116"}}),ol=new M({props:{name:"on_finalized_text",anchor:"transformers.TextStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/streamers.py#L130"}}),al=new M({props:{name:"put",anchor:"transformers.TextStreamer.put",parameters:[{name:"value",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/streamers.py#L82"}}),ll=new M({props:{name:"class transformers.TextIteratorStreamer",anchor:"transformers.TextIteratorStreamer",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"skip_prompt",val:": bool = False"},{name:"timeout",val:": Optional = None"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextIteratorStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextIteratorStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextIteratorStreamer.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The timeout for the text queue. If <code>None</code>, the queue will block indefinitely. Useful to handle exceptions
in <code>.generate()</code>, when it is called in a separate thread.`,name:"timeout"},{anchor:"transformers.TextIteratorStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/streamers.py#L159"}}),qs=new bn({props:{warning:!0,$$slots:{default:[uk]},$$scope:{ctx:j}}}),Hs=new B({props:{anchor:"transformers.TextIteratorStreamer.example",$$slots:{default:[gk]},$$scope:{ctx:j}}}),cl=new M({props:{name:"on_finalized_text",anchor:"transformers.TextIteratorStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/generation/streamers.py#L213"}}),il=new O({props:{title:"Caches",local:"transformers.Cache",headingTag:"h2"}}),dl=new M({props:{name:"class transformers.Cache",anchor:"transformers.Cache",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/cache_utils.py#L6"}}),pl=new M({props:{name:"update",anchor:"transformers.Cache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Cache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.Cache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.Cache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.Cache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. These are specific to each subclass and allow new types of
cache to be created.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/cache_utils.py#L11",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),ml=new M({props:{name:"class transformers.DynamicCache",anchor:"transformers.DynamicCache",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/cache_utils.py#L57"}}),ul=new M({props:{name:"update",anchor:"transformers.DynamicCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.DynamicCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.DynamicCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.DynamicCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.DynamicCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. No additional arguments are used in <code>DynamicCache</code>.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/cache_utils.py#L95",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),gl=new M({props:{name:"get_seq_length",anchor:"transformers.DynamicCache.get_seq_length",parameters:[{name:"layer_idx",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/cache_utils.py#L132"}}),hl=new M({props:{name:"reorder_cache",anchor:"transformers.DynamicCache.reorder_cache",parameters:[{name:"beam_idx",val:": LongTensor"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/cache_utils.py#L142"}}),fl=new M({props:{name:"to_legacy_cache",anchor:"transformers.DynamicCache.to_legacy_cache",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/cache_utils.py#L150"}}),_l=new M({props:{name:"from_legacy_cache",anchor:"transformers.DynamicCache.from_legacy_cache",parameters:[{name:"past_key_values",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/cache_utils.py#L157"}}),bl=new M({props:{name:"class transformers.SinkCache",anchor:"transformers.SinkCache",parameters:[{name:"window_length",val:": int"},{name:"num_sink_tokens",val:": int"}],parametersDescription:[{anchor:"transformers.SinkCache.window_length",description:`<strong>window_length</strong> (<code>int</code>) &#x2014;
The length of the context window.`,name:"window_length"},{anchor:"transformers.SinkCache.num_sink_tokens",description:`<strong>num_sink_tokens</strong> (<code>int</code>) &#x2014;
The number of sink tokens. See the original paper for more information.`,name:"num_sink_tokens"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/cache_utils.py#L168"}}),yl=new M({props:{name:"update",anchor:"transformers.SinkCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.SinkCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.SinkCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.SinkCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.SinkCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. The following arguments can be used in <code>SinkCache</code>: <code>sin</code>,
<code>cos</code> and <code>partial_rotation_size</code>. These arguments are used with models using RoPE, to recompute the
rotation as the tokens are shifted.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/cache_utils.py#L237",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),Tl=new M({props:{name:"get_seq_length",anchor:"transformers.SinkCache.get_seq_length",parameters:[{name:"layer_idx",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/cache_utils.py#L226"}}),vl=new M({props:{name:"reorder_cache",anchor:"transformers.SinkCache.reorder_cache",parameters:[{name:"beam_idx",val:": LongTensor"}],source:"https://github.com/huggingface/transformers/blob/v4.37.2/src/transformers/cache_utils.py#L316"}}),{c(){i=a("meta"),$=n(),b=a("p"),_=n(),p(w.$$.fragment),o=n(),k=a("p"),k.innerHTML=$T,jm=n(),yn=a("p"),yn.textContent=jT,xm=n(),p(Tn.$$.fragment),Jm=n(),vn=a("p"),vn.innerHTML=xT,Um=n(),Mn=a("p"),Mn.textContent=JT,Bm=n(),p(wn.$$.fragment),Im=n(),kn=a("p"),kn.innerHTML=UT,Zm=n(),$n=a("ul"),$n.innerHTML=BT,zm=n(),jn=a("p"),jn.innerHTML=IT,Wm=n(),xn=a("p"),xn.innerHTML=ZT,Vm=n(),Jn=a("p"),Jn.innerHTML=zT,Lm=n(),p(Un.$$.fragment),Cm=n(),Bn=a("p"),Bn.innerHTML=WT,Fm=n(),In=a("p"),In.innerHTML=VT,Gm=n(),Zn=a("p"),Zn.textContent=LT,Xm=n(),p(zn.$$.fragment),Rm=n(),xt=a("div"),p(Wn.$$.fragment),_h=n(),Gl=a("p"),Gl.textContent=CT,Em=n(),Jt=a("div"),p(Vn.$$.fragment),bh=n(),Xl=a("p"),Xl.textContent=FT,Nm=n(),Ut=a("div"),p(Ln.$$.fragment),yh=n(),Rl=a("p"),Rl.textContent=GT,Sm=n(),Bt=a("div"),p(Cn.$$.fragment),Th=n(),El=a("p"),El.textContent=XT,qm=n(),p(Fn.$$.fragment),Hm=n(),It=a("div"),p(Gn.$$.fragment),vh=n(),Nl=a("p"),Nl.textContent=RT,Dm=n(),Zt=a("div"),p(Xn.$$.fragment),Mh=n(),Sl=a("p"),Sl.textContent=ET,Pm=n(),zt=a("div"),p(Rn.$$.fragment),wh=n(),ql=a("p"),ql.textContent=NT,Qm=n(),Wt=a("div"),p(En.$$.fragment),kh=n(),Hl=a("p"),Hl.textContent=ST,Ym=n(),Vt=a("div"),p(Nn.$$.fragment),$h=n(),Dl=a("p"),Dl.textContent=qT,Am=n(),Lt=a("div"),p(Sn.$$.fragment),jh=n(),Pl=a("p"),Pl.textContent=HT,Om=n(),Ct=a("div"),p(qn.$$.fragment),xh=n(),Ql=a("p"),Ql.textContent=DT,Km=n(),Ft=a("div"),p(Hn.$$.fragment),Jh=n(),Yl=a("p"),Yl.textContent=PT,eu=n(),Gt=a("div"),p(Dn.$$.fragment),Uh=n(),Al=a("p"),Al.textContent=QT,tu=n(),Xt=a("div"),p(Pn.$$.fragment),Bh=n(),Ol=a("p"),Ol.textContent=YT,su=n(),p(Qn.$$.fragment),nu=n(),je=a("div"),p(Yn.$$.fragment),Ih=n(),Kl=a("p"),Kl.textContent=AT,Zh=n(),Dt=a("div"),p(An.$$.fragment),zh=n(),ec=a("p"),ec.textContent=OT,ru=n(),xe=a("div"),p(On.$$.fragment),Wh=n(),tc=a("p"),tc.textContent=KT,Vh=n(),Pt=a("div"),p(Kn.$$.fragment),Lh=n(),sc=a("p"),sc.textContent=ev,ou=n(),Je=a("div"),p(er.$$.fragment),Ch=n(),nc=a("p"),nc.textContent=tv,Fh=n(),Qt=a("div"),p(tr.$$.fragment),Gh=n(),rc=a("p"),rc.textContent=sv,au=n(),p(sr.$$.fragment),lu=n(),nr=a("p"),nr.innerHTML=nv,cu=n(),p(rr.$$.fragment),iu=n(),ee=a("div"),p(or.$$.fragment),Xh=n(),oc=a("p"),oc.innerHTML=rv,Rh=n(),p(Yt.$$.fragment),Eh=n(),ac=a("div"),p(ar.$$.fragment),du=n(),W=a("div"),p(lr.$$.fragment),Nh=n(),lc=a("p"),lc.innerHTML=ov,Sh=n(),cc=a("p"),cc.innerHTML=av,qh=n(),p(At.$$.fragment),Hh=n(),p(Ot.$$.fragment),Dh=n(),ic=a("div"),p(cr.$$.fragment),pu=n(),X=a("div"),p(ir.$$.fragment),Ph=n(),dc=a("p"),dc.innerHTML=lv,Qh=n(),pc=a("p"),pc.textContent=cv,Yh=n(),p(Kt.$$.fragment),Ah=n(),mc=a("div"),p(dr.$$.fragment),mu=n(),R=a("div"),p(pr.$$.fragment),Oh=n(),uc=a("p"),uc.innerHTML=iv,Kh=n(),gc=a("p"),gc.textContent=dv,ef=n(),p(es.$$.fragment),tf=n(),hc=a("div"),p(mr.$$.fragment),uu=n(),te=a("div"),p(ur.$$.fragment),sf=n(),fc=a("p"),fc.innerHTML=pv,nf=n(),p(ts.$$.fragment),rf=n(),_c=a("div"),p(gr.$$.fragment),gu=n(),se=a("div"),p(hr.$$.fragment),of=n(),bc=a("p"),bc.innerHTML=mv,af=n(),p(ss.$$.fragment),lf=n(),yc=a("div"),p(fr.$$.fragment),hu=n(),ne=a("div"),p(_r.$$.fragment),cf=n(),Tc=a("p"),Tc.innerHTML=uv,df=n(),p(ns.$$.fragment),pf=n(),vc=a("div"),p(br.$$.fragment),fu=n(),re=a("div"),p(yr.$$.fragment),mf=n(),Mc=a("p"),Mc.innerHTML=gv,uf=n(),p(rs.$$.fragment),gf=n(),wc=a("div"),p(Tr.$$.fragment),_u=n(),oe=a("div"),p(vr.$$.fragment),hf=n(),kc=a("p"),kc.innerHTML=hv,ff=n(),p(os.$$.fragment),_f=n(),$c=a("div"),p(Mr.$$.fragment),bu=n(),ae=a("div"),p(wr.$$.fragment),bf=n(),jc=a("p"),jc.innerHTML=fv,yf=n(),p(as.$$.fragment),Tf=n(),xc=a("div"),p(kr.$$.fragment),yu=n(),V=a("div"),p($r.$$.fragment),vf=n(),Jc=a("p"),Jc.innerHTML=_v,Mf=n(),Uc=a("p"),Uc.innerHTML=bv,wf=n(),Bc=a("p"),Bc.innerHTML=yv,kf=n(),p(ls.$$.fragment),$f=n(),Ic=a("div"),p(jr.$$.fragment),Tu=n(),le=a("div"),p(xr.$$.fragment),jf=n(),Zc=a("p"),Zc.innerHTML=Tv,xf=n(),zc=a("p"),zc.innerHTML=vv,Jf=n(),Wc=a("div"),p(Jr.$$.fragment),vu=n(),ce=a("div"),p(Ur.$$.fragment),Uf=n(),Vc=a("p"),Vc.innerHTML=Mv,Bf=n(),p(cs.$$.fragment),If=n(),Lc=a("div"),p(Br.$$.fragment),Mu=n(),Ue=a("div"),p(Ir.$$.fragment),Zf=n(),Cc=a("p"),Cc.textContent=wv,zf=n(),Fc=a("div"),p(Zr.$$.fragment),wu=n(),Be=a("div"),p(zr.$$.fragment),Wf=n(),Gc=a("p"),Gc.innerHTML=kv,Vf=n(),Xc=a("div"),p(Wr.$$.fragment),ku=n(),Ie=a("div"),p(Vr.$$.fragment),Lf=n(),Rc=a("p"),Rc.textContent=$v,Cf=n(),Ec=a("div"),p(Lr.$$.fragment),$u=n(),ie=a("div"),p(Cr.$$.fragment),Ff=n(),Nc=a("p"),Nc.innerHTML=jv,Gf=n(),p(is.$$.fragment),Xf=n(),Sc=a("div"),p(Fr.$$.fragment),ju=n(),de=a("div"),p(Gr.$$.fragment),Rf=n(),qc=a("p"),qc.innerHTML=xv,Ef=n(),p(ds.$$.fragment),Nf=n(),Hc=a("div"),p(Xr.$$.fragment),xu=n(),E=a("div"),p(Rr.$$.fragment),Sf=n(),Dc=a("p"),Dc.innerHTML=Jv,qf=n(),p(ps.$$.fragment),Hf=n(),p(ms.$$.fragment),Df=n(),Pc=a("div"),p(Er.$$.fragment),Ju=n(),N=a("div"),p(Nr.$$.fragment),Pf=n(),Qc=a("p"),Qc.innerHTML=Uv,Qf=n(),p(us.$$.fragment),Yf=n(),p(gs.$$.fragment),Af=n(),Yc=a("div"),p(Sr.$$.fragment),Uu=n(),pe=a("div"),p(qr.$$.fragment),Of=n(),Ac=a("p"),Ac.innerHTML=Bv,Kf=n(),p(hs.$$.fragment),e_=n(),Oc=a("div"),p(Hr.$$.fragment),Bu=n(),S=a("div"),p(Dr.$$.fragment),t_=n(),Kc=a("p"),Kc.innerHTML=Iv,s_=n(),ei=a("p"),ei.innerHTML=Zv,n_=n(),p(fs.$$.fragment),r_=n(),ti=a("div"),p(Pr.$$.fragment),Iu=n(),q=a("div"),p(Qr.$$.fragment),o_=n(),si=a("p"),si.innerHTML=zv,a_=n(),p(_s.$$.fragment),l_=n(),p(bs.$$.fragment),c_=n(),ni=a("div"),p(Yr.$$.fragment),Zu=n(),me=a("div"),p(Ar.$$.fragment),i_=n(),ri=a("p"),ri.innerHTML=Wv,d_=n(),p(ys.$$.fragment),p_=n(),oi=a("div"),p(Or.$$.fragment),zu=n(),ue=a("div"),p(Kr.$$.fragment),m_=n(),ai=a("p"),ai.innerHTML=Vv,u_=n(),p(Ts.$$.fragment),g_=n(),li=a("div"),p(eo.$$.fragment),Wu=n(),H=a("div"),p(to.$$.fragment),h_=n(),ci=a("p"),ci.innerHTML=Lv,f_=n(),p(vs.$$.fragment),__=n(),p(Ms.$$.fragment),b_=n(),ii=a("div"),p(so.$$.fragment),Vu=n(),ge=a("div"),p(no.$$.fragment),y_=n(),di=a("p"),di.innerHTML=Cv,T_=n(),p(ws.$$.fragment),v_=n(),pi=a("div"),p(ro.$$.fragment),Lu=n(),he=a("div"),p(oo.$$.fragment),M_=n(),mi=a("p"),mi.innerHTML=Fv,w_=n(),p(ks.$$.fragment),k_=n(),ui=a("div"),p(ao.$$.fragment),Cu=n(),D=a("div"),p(lo.$$.fragment),$_=n(),gi=a("p"),gi.innerHTML=Gv,j_=n(),hi=a("p"),hi.innerHTML=Xv,x_=n(),p($s.$$.fragment),J_=n(),fi=a("div"),p(co.$$.fragment),Fu=n(),P=a("div"),p(io.$$.fragment),U_=n(),_i=a("p"),_i.innerHTML=Rv,B_=n(),bi=a("p"),bi.innerHTML=Ev,I_=n(),p(js.$$.fragment),Z_=n(),yi=a("div"),p(po.$$.fragment),Gu=n(),Q=a("div"),p(mo.$$.fragment),z_=n(),Ti=a("p"),Ti.innerHTML=Nv,W_=n(),vi=a("p"),vi.innerHTML=Sv,V_=n(),p(xs.$$.fragment),L_=n(),Mi=a("div"),p(uo.$$.fragment),Xu=n(),p(go.$$.fragment),Ru=n(),Ze=a("div"),p(ho.$$.fragment),C_=n(),wi=a("p"),wi.innerHTML=qv,F_=n(),ki=a("div"),p(fo.$$.fragment),Eu=n(),ze=a("div"),p(_o.$$.fragment),G_=n(),$i=a("p"),$i.innerHTML=Hv,X_=n(),ji=a("div"),p(bo.$$.fragment),Nu=n(),We=a("div"),p(yo.$$.fragment),R_=n(),xi=a("p"),xi.innerHTML=Dv,E_=n(),Ji=a("div"),p(To.$$.fragment),Su=n(),Ve=a("div"),p(vo.$$.fragment),N_=n(),Ui=a("p"),Ui.textContent=Pv,S_=n(),Js=a("div"),p(Mo.$$.fragment),q_=n(),Bi=a("p"),Bi.textContent=Qv,qu=n(),Le=a("div"),p(wo.$$.fragment),H_=n(),Ii=a("p"),Ii.innerHTML=Yv,D_=n(),Zi=a("div"),p(ko.$$.fragment),Hu=n(),Ce=a("div"),p($o.$$.fragment),P_=n(),zi=a("p"),zi.textContent=Av,Q_=n(),Us=a("div"),p(jo.$$.fragment),Y_=n(),Wi=a("p"),Wi.textContent=Ov,Du=n(),Fe=a("div"),p(xo.$$.fragment),A_=n(),Vi=a("p"),Vi.innerHTML=Kv,O_=n(),Li=a("div"),p(Jo.$$.fragment),Pu=n(),Ge=a("div"),p(Uo.$$.fragment),K_=n(),Ci=a("p"),Ci.innerHTML=eM,eb=n(),Fi=a("div"),p(Bo.$$.fragment),Qu=n(),Xe=a("div"),p(Io.$$.fragment),tb=n(),Gi=a("p"),Gi.innerHTML=tM,sb=n(),Xi=a("div"),p(Zo.$$.fragment),Yu=n(),Re=a("div"),p(zo.$$.fragment),nb=n(),Ri=a("p"),Ri.innerHTML=sM,rb=n(),Ei=a("div"),p(Wo.$$.fragment),Au=n(),Ee=a("div"),p(Vo.$$.fragment),ob=n(),Ni=a("p"),Ni.innerHTML=nM,ab=n(),Si=a("div"),p(Lo.$$.fragment),Ou=n(),Ne=a("div"),p(Co.$$.fragment),lb=n(),qi=a("p"),qi.innerHTML=rM,cb=n(),Hi=a("div"),p(Fo.$$.fragment),Ku=n(),Se=a("div"),p(Go.$$.fragment),ib=n(),Di=a("p"),Di.innerHTML=oM,db=n(),Pi=a("div"),p(Xo.$$.fragment),eg=n(),qe=a("div"),p(Ro.$$.fragment),pb=n(),Qi=a("p"),Qi.innerHTML=aM,mb=n(),Yi=a("div"),p(Eo.$$.fragment),tg=n(),He=a("div"),p(No.$$.fragment),ub=n(),Ai=a("p"),Ai.innerHTML=lM,gb=n(),Oi=a("div"),p(So.$$.fragment),sg=n(),p(qo.$$.fragment),ng=n(),De=a("div"),p(Ho.$$.fragment),hb=n(),Ki=a("p"),Ki.innerHTML=cM,fb=n(),ed=a("div"),p(Do.$$.fragment),rg=n(),Pe=a("div"),p(Po.$$.fragment),_b=n(),td=a("p"),td.innerHTML=iM,bb=n(),sd=a("div"),p(Qo.$$.fragment),og=n(),Qe=a("div"),p(Yo.$$.fragment),yb=n(),nd=a("p"),nd.innerHTML=dM,Tb=n(),rd=a("div"),p(Ao.$$.fragment),ag=n(),Ye=a("div"),p(Oo.$$.fragment),vb=n(),od=a("p"),od.textContent=pM,Mb=n(),Bs=a("div"),p(Ko.$$.fragment),wb=n(),ad=a("p"),ad.textContent=mM,lg=n(),Ae=a("div"),p(ea.$$.fragment),kb=n(),ld=a("p"),ld.innerHTML=uM,$b=n(),cd=a("div"),p(ta.$$.fragment),cg=n(),Oe=a("div"),p(sa.$$.fragment),jb=n(),id=a("p"),id.textContent=gM,xb=n(),Is=a("div"),p(na.$$.fragment),Jb=n(),dd=a("p"),dd.textContent=hM,ig=n(),Ke=a("div"),p(ra.$$.fragment),Ub=n(),pd=a("p"),pd.innerHTML=fM,Bb=n(),md=a("div"),p(oa.$$.fragment),dg=n(),et=a("div"),p(aa.$$.fragment),Ib=n(),ud=a("p"),ud.innerHTML=_M,Zb=n(),gd=a("div"),p(la.$$.fragment),pg=n(),tt=a("div"),p(ca.$$.fragment),zb=n(),hd=a("p"),hd.innerHTML=bM,Wb=n(),fd=a("div"),p(ia.$$.fragment),mg=n(),st=a("div"),p(da.$$.fragment),Vb=n(),_d=a("p"),_d.innerHTML=yM,Lb=n(),bd=a("div"),p(pa.$$.fragment),ug=n(),nt=a("div"),p(ma.$$.fragment),Cb=n(),yd=a("p"),yd.innerHTML=TM,Fb=n(),Td=a("div"),p(ua.$$.fragment),gg=n(),rt=a("div"),p(ga.$$.fragment),Gb=n(),vd=a("p"),vd.innerHTML=vM,Xb=n(),Md=a("div"),p(ha.$$.fragment),hg=n(),ot=a("div"),p(fa.$$.fragment),Rb=n(),wd=a("p"),wd.innerHTML=MM,Eb=n(),kd=a("div"),p(_a.$$.fragment),fg=n(),p(ba.$$.fragment),_g=n(),ya=a("p"),ya.innerHTML=wM,bg=n(),fe=a("div"),p(Ta.$$.fragment),Nb=n(),$d=a("p"),$d.textContent=kM,Sb=n(),jd=a("p"),jd.innerHTML=$M,qb=n(),xd=a("div"),p(va.$$.fragment),yg=n(),Rt=a("div"),p(Ma.$$.fragment),Hb=n(),Jd=a("div"),p(wa.$$.fragment),Tg=n(),at=a("div"),p(ka.$$.fragment),Db=n(),Ud=a("p"),Ud.innerHTML=jM,Pb=n(),Bd=a("div"),p($a.$$.fragment),vg=n(),lt=a("div"),p(ja.$$.fragment),Qb=n(),Id=a("p"),Id.innerHTML=xM,Yb=n(),Zd=a("div"),p(xa.$$.fragment),Mg=n(),p(Ja.$$.fragment),wg=n(),Ua=a("p"),Ua.innerHTML=JM,kg=n(),U=a("div"),p(Ba.$$.fragment),Ab=n(),zd=a("p"),zd.textContent=UM,Ob=n(),Wd=a("p"),Wd.textContent=BM,Kb=n(),p(Zs.$$.fragment),ey=n(),Vd=a("p"),Vd.textContent=IM,ty=n(),zs=a("div"),p(Ia.$$.fragment),sy=n(),Ld=a("p"),Ld.textContent=ZM,ny=n(),Ws=a("div"),p(Za.$$.fragment),ry=n(),Cd=a("p"),Cd.textContent=zM,oy=n(),Vs=a("div"),p(za.$$.fragment),ay=n(),Fd=a("p"),Fd.textContent=WM,ly=n(),Ls=a("div"),p(Wa.$$.fragment),cy=n(),Gd=a("p"),Gd.innerHTML=VM,iy=n(),Cs=a("div"),p(Va.$$.fragment),dy=n(),Xd=a("p"),Xd.textContent=LM,py=n(),Fs=a("div"),p(La.$$.fragment),my=n(),Rd=a("p"),Rd.textContent=CM,uy=n(),_t=a("div"),p(Ca.$$.fragment),gy=n(),Ed=a("p"),Ed.innerHTML=FM,hy=n(),Nd=a("p"),Nd.textContent=GM,$g=n(),Et=a("div"),p(Fa.$$.fragment),fy=n(),Sd=a("p"),Sd.innerHTML=XM,jg=n(),Nt=a("div"),p(Ga.$$.fragment),_y=n(),qd=a("p"),qd.innerHTML=RM,xg=n(),_e=a("div"),p(Xa.$$.fragment),by=n(),Hd=a("p"),Hd.textContent=EM,yy=n(),F=a("div"),p(Ra.$$.fragment),Ty=n(),Dd=a("p"),Dd.textContent=NM,vy=n(),Pd=a("p"),Pd.innerHTML=SM,My=n(),Qd=a("p"),Qd.innerHTML=qM,wy=n(),Yd=a("p"),Yd.innerHTML=HM,ky=n(),Ad=a("p"),Ad.textContent=DM,$y=n(),Gs=a("div"),p(Ea.$$.fragment),jy=n(),Od=a("p"),Od.textContent=PM,Jg=n(),p(Na.$$.fragment),Ug=n(),be=a("div"),p(Sa.$$.fragment),xy=n(),Kd=a("p"),Kd.innerHTML=QM,Jy=n(),ep=a("div"),p(qa.$$.fragment),Uy=n(),tp=a("div"),p(Ha.$$.fragment),Bg=n(),L=a("div"),p(Da.$$.fragment),By=n(),sp=a("p"),sp.innerHTML=YM,Iy=n(),np=a("p"),np.innerHTML=AM,Zy=n(),rp=a("p"),rp.innerHTML=OM,zy=n(),op=a("div"),p(Pa.$$.fragment),Wy=n(),ap=a("div"),p(Qa.$$.fragment),Ig=n(),ye=a("div"),p(Ya.$$.fragment),Vy=n(),lp=a("p"),lp.innerHTML=KM,Ly=n(),cp=a("div"),p(Aa.$$.fragment),Cy=n(),ip=a("div"),p(Oa.$$.fragment),Zg=n(),p(Ka.$$.fragment),zg=n(),ct=a("div"),p(el.$$.fragment),Fy=n(),dp=a("p"),dp.textContent=e2,Gy=n(),pp=a("p"),pp.innerHTML=t2,Wg=n(),it=a("div"),p(tl.$$.fragment),Xy=n(),mp=a("p"),mp.textContent=s2,Ry=n(),up=a("p"),up.innerHTML=n2,Vg=n(),p(sl.$$.fragment),Lg=n(),z=a("div"),p(nl.$$.fragment),Ey=n(),gp=a("p"),gp.textContent=r2,Ny=n(),p(Xs.$$.fragment),Sy=n(),p(Rs.$$.fragment),qy=n(),Es=a("div"),p(rl.$$.fragment),Hy=n(),hp=a("p"),hp.textContent=o2,Dy=n(),Ns=a("div"),p(ol.$$.fragment),Py=n(),fp=a("p"),fp.textContent=a2,Qy=n(),Ss=a("div"),p(al.$$.fragment),Yy=n(),_p=a("p"),_p.textContent=l2,Cg=n(),Y=a("div"),p(ll.$$.fragment),Ay=n(),bp=a("p"),bp.textContent=c2,Oy=n(),p(qs.$$.fragment),Ky=n(),p(Hs.$$.fragment),eT=n(),Ds=a("div"),p(cl.$$.fragment),tT=n(),yp=a("p"),yp.textContent=i2,Fg=n(),p(il.$$.fragment),Gg=n(),dt=a("div"),p(dl.$$.fragment),sT=n(),Tp=a("p"),Tp.textContent=d2,nT=n(),Ps=a("div"),p(pl.$$.fragment),rT=n(),vp=a("p"),vp.innerHTML=p2,Xg=n(),Z=a("div"),p(ml.$$.fragment),oT=n(),Mp=a("p"),Mp.textContent=m2,aT=n(),wp=a("p"),wp.innerHTML=u2,lT=n(),Qs=a("div"),p(ul.$$.fragment),cT=n(),kp=a("p"),kp.innerHTML=g2,iT=n(),Ys=a("div"),p(gl.$$.fragment),dT=n(),$p=a("p"),$p.textContent=h2,pT=n(),As=a("div"),p(hl.$$.fragment),mT=n(),jp=a("p"),jp.textContent=f2,uT=n(),Os=a("div"),p(fl.$$.fragment),gT=n(),xp=a("p"),xp.innerHTML=_2,hT=n(),Ks=a("div"),p(_l.$$.fragment),fT=n(),Jp=a("p"),Jp.innerHTML=b2,Rg=n(),C=a("div"),p(bl.$$.fragment),_T=n(),Up=a("p"),Up.innerHTML=y2,bT=n(),Bp=a("p"),Bp.innerHTML=T2,yT=n(),en=a("div"),p(yl.$$.fragment),TT=n(),Ip=a("p"),Ip.innerHTML=v2,vT=n(),tn=a("div"),p(Tl.$$.fragment),MT=n(),Zp=a("p"),Zp.textContent=M2,wT=n(),sn=a("div"),p(vl.$$.fragment),kT=n(),zp=a("p"),zp.textContent=w2,Eg=n(),_m=a("p"),this.h()},l(e){const c=Iw("svelte-u9bgzb",document.head);i=l(c,"META",{name:!0,content:!0}),c.forEach(s),$=r(e),b=l(e,"P",{}),T(b).forEach(s),_=r(e),m(w.$$.fragment,e),o=r(e),k=l(e,"P",{"data-svelte-h":!0}),y(k)!=="svelte-gqh8ew"&&(k.innerHTML=$T),jm=r(e),yn=l(e,"P",{"data-svelte-h":!0}),y(yn)!=="svelte-1blns9e"&&(yn.textContent=jT),xm=r(e),m(Tn.$$.fragment,e),Jm=r(e),vn=l(e,"P",{"data-svelte-h":!0}),y(vn)!=="svelte-16kgsxx"&&(vn.innerHTML=xT),Um=r(e),Mn=l(e,"P",{"data-svelte-h":!0}),y(Mn)!=="svelte-wwwyth"&&(Mn.textContent=JT),Bm=r(e),m(wn.$$.fragment,e),Im=r(e),kn=l(e,"P",{"data-svelte-h":!0}),y(kn)!=="svelte-vit8ki"&&(kn.innerHTML=UT),Zm=r(e),$n=l(e,"UL",{"data-svelte-h":!0}),y($n)!=="svelte-1arpy9m"&&($n.innerHTML=BT),zm=r(e),jn=l(e,"P",{"data-svelte-h":!0}),y(jn)!=="svelte-xh59rv"&&(jn.innerHTML=IT),Wm=r(e),xn=l(e,"P",{"data-svelte-h":!0}),y(xn)!=="svelte-rqavqw"&&(xn.innerHTML=ZT),Vm=r(e),Jn=l(e,"P",{"data-svelte-h":!0}),y(Jn)!=="svelte-qr02he"&&(Jn.innerHTML=zT),Lm=r(e),m(Un.$$.fragment,e),Cm=r(e),Bn=l(e,"P",{"data-svelte-h":!0}),y(Bn)!=="svelte-114v74y"&&(Bn.innerHTML=WT),Fm=r(e),In=l(e,"P",{"data-svelte-h":!0}),y(In)!=="svelte-13knclg"&&(In.innerHTML=VT),Gm=r(e),Zn=l(e,"P",{"data-svelte-h":!0}),y(Zn)!=="svelte-gz8gow"&&(Zn.textContent=LT),Xm=r(e),m(zn.$$.fragment,e),Rm=r(e),xt=l(e,"DIV",{class:!0});var Ml=T(xt);m(Wn.$$.fragment,Ml),_h=r(Ml),Gl=l(Ml,"P",{"data-svelte-h":!0}),y(Gl)!=="svelte-k7oes3"&&(Gl.textContent=CT),Ml.forEach(s),Em=r(e),Jt=l(e,"DIV",{class:!0});var wl=T(Jt);m(Vn.$$.fragment,wl),bh=r(wl),Xl=l(wl,"P",{"data-svelte-h":!0}),y(Xl)!=="svelte-1srbh9p"&&(Xl.textContent=FT),wl.forEach(s),Nm=r(e),Ut=l(e,"DIV",{class:!0});var kl=T(Ut);m(Ln.$$.fragment,kl),yh=r(kl),Rl=l(kl,"P",{"data-svelte-h":!0}),y(Rl)!=="svelte-1j3b9cp"&&(Rl.textContent=GT),kl.forEach(s),Sm=r(e),Bt=l(e,"DIV",{class:!0});var $l=T(Bt);m(Cn.$$.fragment,$l),Th=r($l),El=l($l,"P",{"data-svelte-h":!0}),y(El)!=="svelte-16r5px1"&&(El.textContent=XT),$l.forEach(s),qm=r(e),m(Fn.$$.fragment,e),Hm=r(e),It=l(e,"DIV",{class:!0});var jl=T(It);m(Gn.$$.fragment,jl),vh=r(jl),Nl=l(jl,"P",{"data-svelte-h":!0}),y(Nl)!=="svelte-1bnrp61"&&(Nl.textContent=RT),jl.forEach(s),Dm=r(e),Zt=l(e,"DIV",{class:!0});var xl=T(Zt);m(Xn.$$.fragment,xl),Mh=r(xl),Sl=l(xl,"P",{"data-svelte-h":!0}),y(Sl)!=="svelte-fenhkk"&&(Sl.textContent=ET),xl.forEach(s),Pm=r(e),zt=l(e,"DIV",{class:!0});var Jl=T(zt);m(Rn.$$.fragment,Jl),wh=r(Jl),ql=l(Jl,"P",{"data-svelte-h":!0}),y(ql)!=="svelte-1dqtgq4"&&(ql.textContent=NT),Jl.forEach(s),Qm=r(e),Wt=l(e,"DIV",{class:!0});var Ul=T(Wt);m(En.$$.fragment,Ul),kh=r(Ul),Hl=l(Ul,"P",{"data-svelte-h":!0}),y(Hl)!=="svelte-10orfv5"&&(Hl.textContent=ST),Ul.forEach(s),Ym=r(e),Vt=l(e,"DIV",{class:!0});var Bl=T(Vt);m(Nn.$$.fragment,Bl),$h=r(Bl),Dl=l(Bl,"P",{"data-svelte-h":!0}),y(Dl)!=="svelte-jg8udg"&&(Dl.textContent=qT),Bl.forEach(s),Am=r(e),Lt=l(e,"DIV",{class:!0});var Il=T(Lt);m(Sn.$$.fragment,Il),jh=r(Il),Pl=l(Il,"P",{"data-svelte-h":!0}),y(Pl)!=="svelte-1i40667"&&(Pl.textContent=HT),Il.forEach(s),Om=r(e),Ct=l(e,"DIV",{class:!0});var Zl=T(Ct);m(qn.$$.fragment,Zl),xh=r(Zl),Ql=l(Zl,"P",{"data-svelte-h":!0}),y(Ql)!=="svelte-n5fi8x"&&(Ql.textContent=DT),Zl.forEach(s),Km=r(e),Ft=l(e,"DIV",{class:!0});var zl=T(Ft);m(Hn.$$.fragment,zl),Jh=r(zl),Yl=l(zl,"P",{"data-svelte-h":!0}),y(Yl)!=="svelte-h5pj3l"&&(Yl.textContent=PT),zl.forEach(s),eu=r(e),Gt=l(e,"DIV",{class:!0});var Wl=T(Gt);m(Dn.$$.fragment,Wl),Uh=r(Wl),Al=l(Wl,"P",{"data-svelte-h":!0}),y(Al)!=="svelte-b9zq6n"&&(Al.textContent=QT),Wl.forEach(s),tu=r(e),Xt=l(e,"DIV",{class:!0});var Vl=T(Xt);m(Pn.$$.fragment,Vl),Bh=r(Vl),Ol=l(Vl,"P",{"data-svelte-h":!0}),y(Ol)!=="svelte-pru3ks"&&(Ol.textContent=YT),Vl.forEach(s),su=r(e),m(Qn.$$.fragment,e),nu=r(e),je=l(e,"DIV",{class:!0});var St=T(je);m(Yn.$$.fragment,St),Ih=r(St),Kl=l(St,"P",{"data-svelte-h":!0}),y(Kl)!=="svelte-qoov36"&&(Kl.textContent=AT),Zh=r(St),Dt=l(St,"DIV",{class:!0});var Ll=T(Dt);m(An.$$.fragment,Ll),zh=r(Ll),ec=l(Ll,"P",{"data-svelte-h":!0}),y(ec)!=="svelte-5ihtpa"&&(ec.textContent=OT),Ll.forEach(s),St.forEach(s),ru=r(e),xe=l(e,"DIV",{class:!0});var qt=T(xe);m(On.$$.fragment,qt),Wh=r(qt),tc=l(qt,"P",{"data-svelte-h":!0}),y(tc)!=="svelte-1tz7qrd"&&(tc.textContent=KT),Vh=r(qt),Pt=l(qt,"DIV",{class:!0});var Cl=T(Pt);m(Kn.$$.fragment,Cl),Lh=r(Cl),sc=l(Cl,"P",{"data-svelte-h":!0}),y(sc)!=="svelte-5ihtpa"&&(sc.textContent=ev),Cl.forEach(s),qt.forEach(s),ou=r(e),Je=l(e,"DIV",{class:!0});var Ht=T(Je);m(er.$$.fragment,Ht),Ch=r(Ht),nc=l(Ht,"P",{"data-svelte-h":!0}),y(nc)!=="svelte-1tz7qrd"&&(nc.textContent=tv),Fh=r(Ht),Qt=l(Ht,"DIV",{class:!0});var Fl=T(Qt);m(tr.$$.fragment,Fl),Gh=r(Fl),rc=l(Fl,"P",{"data-svelte-h":!0}),y(rc)!=="svelte-5ihtpa"&&(rc.textContent=sv),Fl.forEach(s),Ht.forEach(s),au=r(e),m(sr.$$.fragment,e),lu=r(e),nr=l(e,"P",{"data-svelte-h":!0}),y(nr)!=="svelte-3kio2k"&&(nr.innerHTML=nv),cu=r(e),m(rr.$$.fragment,e),iu=r(e),ee=l(e,"DIV",{class:!0});var pt=T(ee);m(or.$$.fragment,pt),Xh=r(pt),oc=l(pt,"P",{"data-svelte-h":!0}),y(oc)!=="svelte-1qwyhjn"&&(oc.innerHTML=rv),Rh=r(pt),m(Yt.$$.fragment,pt),Eh=r(pt),ac=l(pt,"DIV",{class:!0});var bm=T(ac);m(ar.$$.fragment,bm),bm.forEach(s),pt.forEach(s),du=r(e),W=l(e,"DIV",{class:!0});var A=T(W);m(lr.$$.fragment,A),Nh=r(A),lc=l(A,"P",{"data-svelte-h":!0}),y(lc)!=="svelte-lpja8q"&&(lc.innerHTML=ov),Sh=r(A),cc=l(A,"P",{"data-svelte-h":!0}),y(cc)!=="svelte-lu7kru"&&(cc.innerHTML=av),qh=r(A),m(At.$$.fragment,A),Hh=r(A),m(Ot.$$.fragment,A),Dh=r(A),ic=l(A,"DIV",{class:!0});var ym=T(ic);m(cr.$$.fragment,ym),ym.forEach(s),A.forEach(s),pu=r(e),X=l(e,"DIV",{class:!0});var Te=T(X);m(ir.$$.fragment,Te),Ph=r(Te),dc=l(Te,"P",{"data-svelte-h":!0}),y(dc)!=="svelte-mb21w5"&&(dc.innerHTML=lv),Qh=r(Te),pc=l(Te,"P",{"data-svelte-h":!0}),y(pc)!=="svelte-mpy00q"&&(pc.textContent=cv),Yh=r(Te),m(Kt.$$.fragment,Te),Ah=r(Te),mc=l(Te,"DIV",{class:!0});var Tm=T(mc);m(dr.$$.fragment,Tm),Tm.forEach(s),Te.forEach(s),mu=r(e),R=l(e,"DIV",{class:!0});var ve=T(R);m(pr.$$.fragment,ve),Oh=r(ve),uc=l(ve,"P",{"data-svelte-h":!0}),y(uc)!=="svelte-c38z17"&&(uc.innerHTML=iv),Kh=r(ve),gc=l(ve,"P",{"data-svelte-h":!0}),y(gc)!=="svelte-3qpgm7"&&(gc.textContent=dv),ef=r(ve),m(es.$$.fragment,ve),tf=r(ve),hc=l(ve,"DIV",{class:!0});var vm=T(hc);m(mr.$$.fragment,vm),vm.forEach(s),ve.forEach(s),uu=r(e),te=l(e,"DIV",{class:!0});var mt=T(te);m(ur.$$.fragment,mt),sf=r(mt),fc=l(mt,"P",{"data-svelte-h":!0}),y(fc)!=="svelte-xqvhhx"&&(fc.innerHTML=pv),nf=r(mt),m(ts.$$.fragment,mt),rf=r(mt),_c=l(mt,"DIV",{class:!0});var Mm=T(_c);m(gr.$$.fragment,Mm),Mm.forEach(s),mt.forEach(s),gu=r(e),se=l(e,"DIV",{class:!0});var ut=T(se);m(hr.$$.fragment,ut),of=r(ut),bc=l(ut,"P",{"data-svelte-h":!0}),y(bc)!=="svelte-mu1xrd"&&(bc.innerHTML=mv),af=r(ut),m(ss.$$.fragment,ut),lf=r(ut),yc=l(ut,"DIV",{class:!0});var wm=T(yc);m(fr.$$.fragment,wm),wm.forEach(s),ut.forEach(s),hu=r(e),ne=l(e,"DIV",{class:!0});var gt=T(ne);m(_r.$$.fragment,gt),cf=r(gt),Tc=l(gt,"P",{"data-svelte-h":!0}),y(Tc)!=="svelte-1pxrh70"&&(Tc.innerHTML=uv),df=r(gt),m(ns.$$.fragment,gt),pf=r(gt),vc=l(gt,"DIV",{class:!0});var km=T(vc);m(br.$$.fragment,km),km.forEach(s),gt.forEach(s),fu=r(e),re=l(e,"DIV",{class:!0});var ht=T(re);m(yr.$$.fragment,ht),mf=r(ht),Mc=l(ht,"P",{"data-svelte-h":!0}),y(Mc)!=="svelte-210ey0"&&(Mc.innerHTML=gv),uf=r(ht),m(rs.$$.fragment,ht),gf=r(ht),wc=l(ht,"DIV",{class:!0});var $m=T(wc);m(Tr.$$.fragment,$m),$m.forEach(s),ht.forEach(s),_u=r(e),oe=l(e,"DIV",{class:!0});var ft=T(oe);m(vr.$$.fragment,ft),hf=r(ft),kc=l(ft,"P",{"data-svelte-h":!0}),y(kc)!=="svelte-11b1px8"&&(kc.innerHTML=hv),ff=r(ft),m(os.$$.fragment,ft),_f=r(ft),$c=l(ft,"DIV",{class:!0});var k2=T($c);m(Mr.$$.fragment,k2),k2.forEach(s),ft.forEach(s),bu=r(e),ae=l(e,"DIV",{class:!0});var nn=T(ae);m(wr.$$.fragment,nn),bf=r(nn),jc=l(nn,"P",{"data-svelte-h":!0}),y(jc)!=="svelte-lpfxi8"&&(jc.innerHTML=fv),yf=r(nn),m(as.$$.fragment,nn),Tf=r(nn),xc=l(nn,"DIV",{class:!0});var $2=T(xc);m(kr.$$.fragment,$2),$2.forEach(s),nn.forEach(s),yu=r(e),V=l(e,"DIV",{class:!0});var Me=T(V);m($r.$$.fragment,Me),vf=r(Me),Jc=l(Me,"P",{"data-svelte-h":!0}),y(Jc)!=="svelte-9ef2t2"&&(Jc.innerHTML=_v),Mf=r(Me),Uc=l(Me,"P",{"data-svelte-h":!0}),y(Uc)!=="svelte-i3glr3"&&(Uc.innerHTML=bv),wf=r(Me),Bc=l(Me,"P",{"data-svelte-h":!0}),y(Bc)!=="svelte-2fpu88"&&(Bc.innerHTML=yv),kf=r(Me),m(ls.$$.fragment,Me),$f=r(Me),Ic=l(Me,"DIV",{class:!0});var j2=T(Ic);m(jr.$$.fragment,j2),j2.forEach(s),Me.forEach(s),Tu=r(e),le=l(e,"DIV",{class:!0});var rn=T(le);m(xr.$$.fragment,rn),jf=r(rn),Zc=l(rn,"P",{"data-svelte-h":!0}),y(Zc)!=="svelte-p2xvqx"&&(Zc.innerHTML=Tv),xf=r(rn),zc=l(rn,"P",{"data-svelte-h":!0}),y(zc)!=="svelte-1v3r596"&&(zc.innerHTML=vv),Jf=r(rn),Wc=l(rn,"DIV",{class:!0});var x2=T(Wc);m(Jr.$$.fragment,x2),x2.forEach(s),rn.forEach(s),vu=r(e),ce=l(e,"DIV",{class:!0});var on=T(ce);m(Ur.$$.fragment,on),Uf=r(on),Vc=l(on,"P",{"data-svelte-h":!0}),y(Vc)!=="svelte-1ln3psv"&&(Vc.innerHTML=Mv),Bf=r(on),m(cs.$$.fragment,on),If=r(on),Lc=l(on,"DIV",{class:!0});var J2=T(Lc);m(Br.$$.fragment,J2),J2.forEach(s),on.forEach(s),Mu=r(e),Ue=l(e,"DIV",{class:!0});var Wp=T(Ue);m(Ir.$$.fragment,Wp),Zf=r(Wp),Cc=l(Wp,"P",{"data-svelte-h":!0}),y(Cc)!=="svelte-y1kta5"&&(Cc.textContent=wv),zf=r(Wp),Fc=l(Wp,"DIV",{class:!0});var U2=T(Fc);m(Zr.$$.fragment,U2),U2.forEach(s),Wp.forEach(s),wu=r(e),Be=l(e,"DIV",{class:!0});var Vp=T(Be);m(zr.$$.fragment,Vp),Wf=r(Vp),Gc=l(Vp,"P",{"data-svelte-h":!0}),y(Gc)!=="svelte-1nn0n0b"&&(Gc.innerHTML=kv),Vf=r(Vp),Xc=l(Vp,"DIV",{class:!0});var B2=T(Xc);m(Wr.$$.fragment,B2),B2.forEach(s),Vp.forEach(s),ku=r(e),Ie=l(e,"DIV",{class:!0});var Lp=T(Ie);m(Vr.$$.fragment,Lp),Lf=r(Lp),Rc=l(Lp,"P",{"data-svelte-h":!0}),y(Rc)!=="svelte-th82mu"&&(Rc.textContent=$v),Cf=r(Lp),Ec=l(Lp,"DIV",{class:!0});var I2=T(Ec);m(Lr.$$.fragment,I2),I2.forEach(s),Lp.forEach(s),$u=r(e),ie=l(e,"DIV",{class:!0});var an=T(ie);m(Cr.$$.fragment,an),Ff=r(an),Nc=l(an,"P",{"data-svelte-h":!0}),y(Nc)!=="svelte-1l81pew"&&(Nc.innerHTML=jv),Gf=r(an),m(is.$$.fragment,an),Xf=r(an),Sc=l(an,"DIV",{class:!0});var Z2=T(Sc);m(Fr.$$.fragment,Z2),Z2.forEach(s),an.forEach(s),ju=r(e),de=l(e,"DIV",{class:!0});var ln=T(de);m(Gr.$$.fragment,ln),Rf=r(ln),qc=l(ln,"P",{"data-svelte-h":!0}),y(qc)!=="svelte-1kyvjuf"&&(qc.innerHTML=xv),Ef=r(ln),m(ds.$$.fragment,ln),Nf=r(ln),Hc=l(ln,"DIV",{class:!0});var z2=T(Hc);m(Xr.$$.fragment,z2),z2.forEach(s),ln.forEach(s),xu=r(e),E=l(e,"DIV",{class:!0});var bt=T(E);m(Rr.$$.fragment,bt),Sf=r(bt),Dc=l(bt,"P",{"data-svelte-h":!0}),y(Dc)!=="svelte-1t0rfe0"&&(Dc.innerHTML=Jv),qf=r(bt),m(ps.$$.fragment,bt),Hf=r(bt),m(ms.$$.fragment,bt),Df=r(bt),Pc=l(bt,"DIV",{class:!0});var W2=T(Pc);m(Er.$$.fragment,W2),W2.forEach(s),bt.forEach(s),Ju=r(e),N=l(e,"DIV",{class:!0});var yt=T(N);m(Nr.$$.fragment,yt),Pf=r(yt),Qc=l(yt,"P",{"data-svelte-h":!0}),y(Qc)!=="svelte-1w08xfn"&&(Qc.innerHTML=Uv),Qf=r(yt),m(us.$$.fragment,yt),Yf=r(yt),m(gs.$$.fragment,yt),Af=r(yt),Yc=l(yt,"DIV",{class:!0});var V2=T(Yc);m(Sr.$$.fragment,V2),V2.forEach(s),yt.forEach(s),Uu=r(e),pe=l(e,"DIV",{class:!0});var cn=T(pe);m(qr.$$.fragment,cn),Of=r(cn),Ac=l(cn,"P",{"data-svelte-h":!0}),y(Ac)!=="svelte-1jmmxow"&&(Ac.innerHTML=Bv),Kf=r(cn),m(hs.$$.fragment,cn),e_=r(cn),Oc=l(cn,"DIV",{class:!0});var L2=T(Oc);m(Hr.$$.fragment,L2),L2.forEach(s),cn.forEach(s),Bu=r(e),S=l(e,"DIV",{class:!0});var Tt=T(S);m(Dr.$$.fragment,Tt),t_=r(Tt),Kc=l(Tt,"P",{"data-svelte-h":!0}),y(Kc)!=="svelte-vnop5c"&&(Kc.innerHTML=Iv),s_=r(Tt),ei=l(Tt,"P",{"data-svelte-h":!0}),y(ei)!=="svelte-qhda5i"&&(ei.innerHTML=Zv),n_=r(Tt),m(fs.$$.fragment,Tt),r_=r(Tt),ti=l(Tt,"DIV",{class:!0});var C2=T(ti);m(Pr.$$.fragment,C2),C2.forEach(s),Tt.forEach(s),Iu=r(e),q=l(e,"DIV",{class:!0});var vt=T(q);m(Qr.$$.fragment,vt),o_=r(vt),si=l(vt,"P",{"data-svelte-h":!0}),y(si)!=="svelte-19cf2ld"&&(si.innerHTML=zv),a_=r(vt),m(_s.$$.fragment,vt),l_=r(vt),m(bs.$$.fragment,vt),c_=r(vt),ni=l(vt,"DIV",{class:!0});var F2=T(ni);m(Yr.$$.fragment,F2),F2.forEach(s),vt.forEach(s),Zu=r(e),me=l(e,"DIV",{class:!0});var dn=T(me);m(Ar.$$.fragment,dn),i_=r(dn),ri=l(dn,"P",{"data-svelte-h":!0}),y(ri)!=="svelte-1d3x471"&&(ri.innerHTML=Wv),d_=r(dn),m(ys.$$.fragment,dn),p_=r(dn),oi=l(dn,"DIV",{class:!0});var G2=T(oi);m(Or.$$.fragment,G2),G2.forEach(s),dn.forEach(s),zu=r(e),ue=l(e,"DIV",{class:!0});var pn=T(ue);m(Kr.$$.fragment,pn),m_=r(pn),ai=l(pn,"P",{"data-svelte-h":!0}),y(ai)!=="svelte-kp6ubc"&&(ai.innerHTML=Vv),u_=r(pn),m(Ts.$$.fragment,pn),g_=r(pn),li=l(pn,"DIV",{class:!0});var X2=T(li);m(eo.$$.fragment,X2),X2.forEach(s),pn.forEach(s),Wu=r(e),H=l(e,"DIV",{class:!0});var Mt=T(H);m(to.$$.fragment,Mt),h_=r(Mt),ci=l(Mt,"P",{"data-svelte-h":!0}),y(ci)!=="svelte-1qt2c52"&&(ci.innerHTML=Lv),f_=r(Mt),m(vs.$$.fragment,Mt),__=r(Mt),m(Ms.$$.fragment,Mt),b_=r(Mt),ii=l(Mt,"DIV",{class:!0});var R2=T(ii);m(so.$$.fragment,R2),R2.forEach(s),Mt.forEach(s),Vu=r(e),ge=l(e,"DIV",{class:!0});var mn=T(ge);m(no.$$.fragment,mn),y_=r(mn),di=l(mn,"P",{"data-svelte-h":!0}),y(di)!=="svelte-1r2c31s"&&(di.innerHTML=Cv),T_=r(mn),m(ws.$$.fragment,mn),v_=r(mn),pi=l(mn,"DIV",{class:!0});var E2=T(pi);m(ro.$$.fragment,E2),E2.forEach(s),mn.forEach(s),Lu=r(e),he=l(e,"DIV",{class:!0});var un=T(he);m(oo.$$.fragment,un),M_=r(un),mi=l(un,"P",{"data-svelte-h":!0}),y(mi)!=="svelte-tbesfk"&&(mi.innerHTML=Fv),w_=r(un),m(ks.$$.fragment,un),k_=r(un),ui=l(un,"DIV",{class:!0});var N2=T(ui);m(ao.$$.fragment,N2),N2.forEach(s),un.forEach(s),Cu=r(e),D=l(e,"DIV",{class:!0});var wt=T(D);m(lo.$$.fragment,wt),$_=r(wt),gi=l(wt,"P",{"data-svelte-h":!0}),y(gi)!=="svelte-1gj90tr"&&(gi.innerHTML=Gv),j_=r(wt),hi=l(wt,"P",{"data-svelte-h":!0}),y(hi)!=="svelte-1qmimno"&&(hi.innerHTML=Xv),x_=r(wt),m($s.$$.fragment,wt),J_=r(wt),fi=l(wt,"DIV",{class:!0});var S2=T(fi);m(co.$$.fragment,S2),S2.forEach(s),wt.forEach(s),Fu=r(e),P=l(e,"DIV",{class:!0});var kt=T(P);m(io.$$.fragment,kt),U_=r(kt),_i=l(kt,"P",{"data-svelte-h":!0}),y(_i)!=="svelte-1dewsn6"&&(_i.innerHTML=Rv),B_=r(kt),bi=l(kt,"P",{"data-svelte-h":!0}),y(bi)!=="svelte-5qs7tv"&&(bi.innerHTML=Ev),I_=r(kt),m(js.$$.fragment,kt),Z_=r(kt),yi=l(kt,"DIV",{class:!0});var q2=T(yi);m(po.$$.fragment,q2),q2.forEach(s),kt.forEach(s),Gu=r(e),Q=l(e,"DIV",{class:!0});var $t=T(Q);m(mo.$$.fragment,$t),z_=r($t),Ti=l($t,"P",{"data-svelte-h":!0}),y(Ti)!=="svelte-lkbe26"&&(Ti.innerHTML=Nv),W_=r($t),vi=l($t,"P",{"data-svelte-h":!0}),y(vi)!=="svelte-qmmn5t"&&(vi.innerHTML=Sv),V_=r($t),m(xs.$$.fragment,$t),L_=r($t),Mi=l($t,"DIV",{class:!0});var H2=T(Mi);m(uo.$$.fragment,H2),H2.forEach(s),$t.forEach(s),Xu=r(e),m(go.$$.fragment,e),Ru=r(e),Ze=l(e,"DIV",{class:!0});var Cp=T(Ze);m(ho.$$.fragment,Cp),C_=r(Cp),wi=l(Cp,"P",{"data-svelte-h":!0}),y(wi)!=="svelte-1gnkbzk"&&(wi.innerHTML=qv),F_=r(Cp),ki=l(Cp,"DIV",{class:!0});var D2=T(ki);m(fo.$$.fragment,D2),D2.forEach(s),Cp.forEach(s),Eu=r(e),ze=l(e,"DIV",{class:!0});var Fp=T(ze);m(_o.$$.fragment,Fp),G_=r(Fp),$i=l(Fp,"P",{"data-svelte-h":!0}),y($i)!=="svelte-1byqc4c"&&($i.innerHTML=Hv),X_=r(Fp),ji=l(Fp,"DIV",{class:!0});var P2=T(ji);m(bo.$$.fragment,P2),P2.forEach(s),Fp.forEach(s),Nu=r(e),We=l(e,"DIV",{class:!0});var Gp=T(We);m(yo.$$.fragment,Gp),R_=r(Gp),xi=l(Gp,"P",{"data-svelte-h":!0}),y(xi)!=="svelte-1557waw"&&(xi.innerHTML=Dv),E_=r(Gp),Ji=l(Gp,"DIV",{class:!0});var Q2=T(Ji);m(To.$$.fragment,Q2),Q2.forEach(s),Gp.forEach(s),Su=r(e),Ve=l(e,"DIV",{class:!0});var Xp=T(Ve);m(vo.$$.fragment,Xp),N_=r(Xp),Ui=l(Xp,"P",{"data-svelte-h":!0}),y(Ui)!=="svelte-y1kta5"&&(Ui.textContent=Pv),S_=r(Xp),Js=l(Xp,"DIV",{class:!0});var Sg=T(Js);m(Mo.$$.fragment,Sg),q_=r(Sg),Bi=l(Sg,"P",{"data-svelte-h":!0}),y(Bi)!=="svelte-5aspnb"&&(Bi.textContent=Qv),Sg.forEach(s),Xp.forEach(s),qu=r(e),Le=l(e,"DIV",{class:!0});var Rp=T(Le);m(wo.$$.fragment,Rp),H_=r(Rp),Ii=l(Rp,"P",{"data-svelte-h":!0}),y(Ii)!=="svelte-1833zr3"&&(Ii.innerHTML=Yv),D_=r(Rp),Zi=l(Rp,"DIV",{class:!0});var Y2=T(Zi);m(ko.$$.fragment,Y2),Y2.forEach(s),Rp.forEach(s),Hu=r(e),Ce=l(e,"DIV",{class:!0});var Ep=T(Ce);m($o.$$.fragment,Ep),P_=r(Ep),zi=l(Ep,"P",{"data-svelte-h":!0}),y(zi)!=="svelte-th82mu"&&(zi.textContent=Av),Q_=r(Ep),Us=l(Ep,"DIV",{class:!0});var qg=T(Us);m(jo.$$.fragment,qg),Y_=r(qg),Wi=l(qg,"P",{"data-svelte-h":!0}),y(Wi)!=="svelte-hcoglc"&&(Wi.textContent=Ov),qg.forEach(s),Ep.forEach(s),Du=r(e),Fe=l(e,"DIV",{class:!0});var Np=T(Fe);m(xo.$$.fragment,Np),A_=r(Np),Vi=l(Np,"P",{"data-svelte-h":!0}),y(Vi)!=="svelte-1j5e5oo"&&(Vi.innerHTML=Kv),O_=r(Np),Li=l(Np,"DIV",{class:!0});var A2=T(Li);m(Jo.$$.fragment,A2),A2.forEach(s),Np.forEach(s),Pu=r(e),Ge=l(e,"DIV",{class:!0});var Sp=T(Ge);m(Uo.$$.fragment,Sp),K_=r(Sp),Ci=l(Sp,"P",{"data-svelte-h":!0}),y(Ci)!=="svelte-123oyaj"&&(Ci.innerHTML=eM),eb=r(Sp),Fi=l(Sp,"DIV",{class:!0});var O2=T(Fi);m(Bo.$$.fragment,O2),O2.forEach(s),Sp.forEach(s),Qu=r(e),Xe=l(e,"DIV",{class:!0});var qp=T(Xe);m(Io.$$.fragment,qp),tb=r(qp),Gi=l(qp,"P",{"data-svelte-h":!0}),y(Gi)!=="svelte-1ydnqsb"&&(Gi.innerHTML=tM),sb=r(qp),Xi=l(qp,"DIV",{class:!0});var K2=T(Xi);m(Zo.$$.fragment,K2),K2.forEach(s),qp.forEach(s),Yu=r(e),Re=l(e,"DIV",{class:!0});var Hp=T(Re);m(zo.$$.fragment,Hp),nb=r(Hp),Ri=l(Hp,"P",{"data-svelte-h":!0}),y(Ri)!=="svelte-1dy7lic"&&(Ri.innerHTML=sM),rb=r(Hp),Ei=l(Hp,"DIV",{class:!0});var ew=T(Ei);m(Wo.$$.fragment,ew),ew.forEach(s),Hp.forEach(s),Au=r(e),Ee=l(e,"DIV",{class:!0});var Dp=T(Ee);m(Vo.$$.fragment,Dp),ob=r(Dp),Ni=l(Dp,"P",{"data-svelte-h":!0}),y(Ni)!=="svelte-v1z5zl"&&(Ni.innerHTML=nM),ab=r(Dp),Si=l(Dp,"DIV",{class:!0});var tw=T(Si);m(Lo.$$.fragment,tw),tw.forEach(s),Dp.forEach(s),Ou=r(e),Ne=l(e,"DIV",{class:!0});var Pp=T(Ne);m(Co.$$.fragment,Pp),lb=r(Pp),qi=l(Pp,"P",{"data-svelte-h":!0}),y(qi)!=="svelte-a554sd"&&(qi.innerHTML=rM),cb=r(Pp),Hi=l(Pp,"DIV",{class:!0});var sw=T(Hi);m(Fo.$$.fragment,sw),sw.forEach(s),Pp.forEach(s),Ku=r(e),Se=l(e,"DIV",{class:!0});var Qp=T(Se);m(Go.$$.fragment,Qp),ib=r(Qp),Di=l(Qp,"P",{"data-svelte-h":!0}),y(Di)!=="svelte-1xct0ux"&&(Di.innerHTML=oM),db=r(Qp),Pi=l(Qp,"DIV",{class:!0});var nw=T(Pi);m(Xo.$$.fragment,nw),nw.forEach(s),Qp.forEach(s),eg=r(e),qe=l(e,"DIV",{class:!0});var Yp=T(qe);m(Ro.$$.fragment,Yp),pb=r(Yp),Qi=l(Yp,"P",{"data-svelte-h":!0}),y(Qi)!=="svelte-1wgtz9e"&&(Qi.innerHTML=aM),mb=r(Yp),Yi=l(Yp,"DIV",{class:!0});var rw=T(Yi);m(Eo.$$.fragment,rw),rw.forEach(s),Yp.forEach(s),tg=r(e),He=l(e,"DIV",{class:!0});var Ap=T(He);m(No.$$.fragment,Ap),ub=r(Ap),Ai=l(Ap,"P",{"data-svelte-h":!0}),y(Ai)!=="svelte-1j1dio0"&&(Ai.innerHTML=lM),gb=r(Ap),Oi=l(Ap,"DIV",{class:!0});var ow=T(Oi);m(So.$$.fragment,ow),ow.forEach(s),Ap.forEach(s),sg=r(e),m(qo.$$.fragment,e),ng=r(e),De=l(e,"DIV",{class:!0});var Op=T(De);m(Ho.$$.fragment,Op),hb=r(Op),Ki=l(Op,"P",{"data-svelte-h":!0}),y(Ki)!=="svelte-136dgco"&&(Ki.innerHTML=cM),fb=r(Op),ed=l(Op,"DIV",{class:!0});var aw=T(ed);m(Do.$$.fragment,aw),aw.forEach(s),Op.forEach(s),rg=r(e),Pe=l(e,"DIV",{class:!0});var Kp=T(Pe);m(Po.$$.fragment,Kp),_b=r(Kp),td=l(Kp,"P",{"data-svelte-h":!0}),y(td)!=="svelte-ex6s90"&&(td.innerHTML=iM),bb=r(Kp),sd=l(Kp,"DIV",{class:!0});var lw=T(sd);m(Qo.$$.fragment,lw),lw.forEach(s),Kp.forEach(s),og=r(e),Qe=l(e,"DIV",{class:!0});var em=T(Qe);m(Yo.$$.fragment,em),yb=r(em),nd=l(em,"P",{"data-svelte-h":!0}),y(nd)!=="svelte-1ojn0fr"&&(nd.innerHTML=dM),Tb=r(em),rd=l(em,"DIV",{class:!0});var cw=T(rd);m(Ao.$$.fragment,cw),cw.forEach(s),em.forEach(s),ag=r(e),Ye=l(e,"DIV",{class:!0});var tm=T(Ye);m(Oo.$$.fragment,tm),vb=r(tm),od=l(tm,"P",{"data-svelte-h":!0}),y(od)!=="svelte-y1kta5"&&(od.textContent=pM),Mb=r(tm),Bs=l(tm,"DIV",{class:!0});var Hg=T(Bs);m(Ko.$$.fragment,Hg),wb=r(Hg),ad=l(Hg,"P",{"data-svelte-h":!0}),y(ad)!=="svelte-1l17mwc"&&(ad.textContent=mM),Hg.forEach(s),tm.forEach(s),lg=r(e),Ae=l(e,"DIV",{class:!0});var sm=T(Ae);m(ea.$$.fragment,sm),kb=r(sm),ld=l(sm,"P",{"data-svelte-h":!0}),y(ld)!=="svelte-7uu9eb"&&(ld.innerHTML=uM),$b=r(sm),cd=l(sm,"DIV",{class:!0});var iw=T(cd);m(ta.$$.fragment,iw),iw.forEach(s),sm.forEach(s),cg=r(e),Oe=l(e,"DIV",{class:!0});var nm=T(Oe);m(sa.$$.fragment,nm),jb=r(nm),id=l(nm,"P",{"data-svelte-h":!0}),y(id)!=="svelte-th82mu"&&(id.textContent=gM),xb=r(nm),Is=l(nm,"DIV",{class:!0});var Dg=T(Is);m(na.$$.fragment,Dg),Jb=r(Dg),dd=l(Dg,"P",{"data-svelte-h":!0}),y(dd)!=="svelte-1tcb5cf"&&(dd.textContent=hM),Dg.forEach(s),nm.forEach(s),ig=r(e),Ke=l(e,"DIV",{class:!0});var rm=T(Ke);m(ra.$$.fragment,rm),Ub=r(rm),pd=l(rm,"P",{"data-svelte-h":!0}),y(pd)!=="svelte-uya5vk"&&(pd.innerHTML=fM),Bb=r(rm),md=l(rm,"DIV",{class:!0});var dw=T(md);m(oa.$$.fragment,dw),dw.forEach(s),rm.forEach(s),dg=r(e),et=l(e,"DIV",{class:!0});var om=T(et);m(aa.$$.fragment,om),Ib=r(om),ud=l(om,"P",{"data-svelte-h":!0}),y(ud)!=="svelte-1ec8444"&&(ud.innerHTML=_M),Zb=r(om),gd=l(om,"DIV",{class:!0});var pw=T(gd);m(la.$$.fragment,pw),pw.forEach(s),om.forEach(s),pg=r(e),tt=l(e,"DIV",{class:!0});var am=T(tt);m(ca.$$.fragment,am),zb=r(am),hd=l(am,"P",{"data-svelte-h":!0}),y(hd)!=="svelte-5px9ee"&&(hd.innerHTML=bM),Wb=r(am),fd=l(am,"DIV",{class:!0});var mw=T(fd);m(ia.$$.fragment,mw),mw.forEach(s),am.forEach(s),mg=r(e),st=l(e,"DIV",{class:!0});var lm=T(st);m(da.$$.fragment,lm),Vb=r(lm),_d=l(lm,"P",{"data-svelte-h":!0}),y(_d)!=="svelte-yd1hkf"&&(_d.innerHTML=yM),Lb=r(lm),bd=l(lm,"DIV",{class:!0});var uw=T(bd);m(pa.$$.fragment,uw),uw.forEach(s),lm.forEach(s),ug=r(e),nt=l(e,"DIV",{class:!0});var cm=T(nt);m(ma.$$.fragment,cm),Cb=r(cm),yd=l(cm,"P",{"data-svelte-h":!0}),y(yd)!=="svelte-1mnvwd8"&&(yd.innerHTML=TM),Fb=r(cm),Td=l(cm,"DIV",{class:!0});var gw=T(Td);m(ua.$$.fragment,gw),gw.forEach(s),cm.forEach(s),gg=r(e),rt=l(e,"DIV",{class:!0});var im=T(rt);m(ga.$$.fragment,im),Gb=r(im),vd=l(im,"P",{"data-svelte-h":!0}),y(vd)!=="svelte-1vw54s6"&&(vd.innerHTML=vM),Xb=r(im),Md=l(im,"DIV",{class:!0});var hw=T(Md);m(ha.$$.fragment,hw),hw.forEach(s),im.forEach(s),hg=r(e),ot=l(e,"DIV",{class:!0});var dm=T(ot);m(fa.$$.fragment,dm),Rb=r(dm),wd=l(dm,"P",{"data-svelte-h":!0}),y(wd)!=="svelte-1sygpwz"&&(wd.innerHTML=MM),Eb=r(dm),kd=l(dm,"DIV",{class:!0});var fw=T(kd);m(_a.$$.fragment,fw),fw.forEach(s),dm.forEach(s),fg=r(e),m(ba.$$.fragment,e),_g=r(e),ya=l(e,"P",{"data-svelte-h":!0}),y(ya)!=="svelte-u1lkau"&&(ya.innerHTML=wM),bg=r(e),fe=l(e,"DIV",{class:!0});var gn=T(fe);m(Ta.$$.fragment,gn),Nb=r(gn),$d=l(gn,"P",{"data-svelte-h":!0}),y($d)!=="svelte-rfvu1k"&&($d.textContent=kM),Sb=r(gn),jd=l(gn,"P",{"data-svelte-h":!0}),y(jd)!=="svelte-e1lytz"&&(jd.innerHTML=$M),qb=r(gn),xd=l(gn,"DIV",{class:!0});var _w=T(xd);m(va.$$.fragment,_w),_w.forEach(s),gn.forEach(s),yg=r(e),Rt=l(e,"DIV",{class:!0});var Pg=T(Rt);m(Ma.$$.fragment,Pg),Hb=r(Pg),Jd=l(Pg,"DIV",{class:!0});var bw=T(Jd);m(wa.$$.fragment,bw),bw.forEach(s),Pg.forEach(s),Tg=r(e),at=l(e,"DIV",{class:!0});var pm=T(at);m(ka.$$.fragment,pm),Db=r(pm),Ud=l(pm,"P",{"data-svelte-h":!0}),y(Ud)!=="svelte-4hfu96"&&(Ud.innerHTML=jM),Pb=r(pm),Bd=l(pm,"DIV",{class:!0});var yw=T(Bd);m($a.$$.fragment,yw),yw.forEach(s),pm.forEach(s),vg=r(e),lt=l(e,"DIV",{class:!0});var mm=T(lt);m(ja.$$.fragment,mm),Qb=r(mm),Id=l(mm,"P",{"data-svelte-h":!0}),y(Id)!=="svelte-q5v59n"&&(Id.innerHTML=xM),Yb=r(mm),Zd=l(mm,"DIV",{class:!0});var Tw=T(Zd);m(xa.$$.fragment,Tw),Tw.forEach(s),mm.forEach(s),Mg=r(e),m(Ja.$$.fragment,e),wg=r(e),Ua=l(e,"P",{"data-svelte-h":!0}),y(Ua)!=="svelte-108260"&&(Ua.innerHTML=JM),kg=r(e),U=l(e,"DIV",{class:!0});var I=T(U);m(Ba.$$.fragment,I),Ab=r(I),zd=l(I,"P",{"data-svelte-h":!0}),y(zd)!=="svelte-1kh5y5v"&&(zd.textContent=UM),Ob=r(I),Wd=l(I,"P",{"data-svelte-h":!0}),y(Wd)!=="svelte-1ygkifj"&&(Wd.textContent=BM),Kb=r(I),m(Zs.$$.fragment,I),ey=r(I),Vd=l(I,"P",{"data-svelte-h":!0}),y(Vd)!=="svelte-7kbd1a"&&(Vd.textContent=IM),ty=r(I),zs=l(I,"DIV",{class:!0});var Qg=T(zs);m(Ia.$$.fragment,Qg),sy=r(Qg),Ld=l(Qg,"P",{"data-svelte-h":!0}),y(Ld)!=="svelte-691079"&&(Ld.textContent=ZM),Qg.forEach(s),ny=r(I),Ws=l(I,"DIV",{class:!0});var Yg=T(Ws);m(Za.$$.fragment,Yg),ry=r(Yg),Cd=l(Yg,"P",{"data-svelte-h":!0}),y(Cd)!=="svelte-dtkk01"&&(Cd.textContent=zM),Yg.forEach(s),oy=r(I),Vs=l(I,"DIV",{class:!0});var Ag=T(Vs);m(za.$$.fragment,Ag),ay=r(Ag),Fd=l(Ag,"P",{"data-svelte-h":!0}),y(Fd)!=="svelte-11pa7k0"&&(Fd.textContent=WM),Ag.forEach(s),ly=r(I),Ls=l(I,"DIV",{class:!0});var Og=T(Ls);m(Wa.$$.fragment,Og),cy=r(Og),Gd=l(Og,"P",{"data-svelte-h":!0}),y(Gd)!=="svelte-57vcuk"&&(Gd.innerHTML=VM),Og.forEach(s),iy=r(I),Cs=l(I,"DIV",{class:!0});var Kg=T(Cs);m(Va.$$.fragment,Kg),dy=r(Kg),Xd=l(Kg,"P",{"data-svelte-h":!0}),y(Xd)!=="svelte-e342dt"&&(Xd.textContent=LM),Kg.forEach(s),py=r(I),Fs=l(I,"DIV",{class:!0});var eh=T(Fs);m(La.$$.fragment,eh),my=r(eh),Rd=l(eh,"P",{"data-svelte-h":!0}),y(Rd)!=="svelte-vbd5xj"&&(Rd.textContent=CM),eh.forEach(s),uy=r(I),_t=l(I,"DIV",{class:!0});var um=T(_t);m(Ca.$$.fragment,um),gy=r(um),Ed=l(um,"P",{"data-svelte-h":!0}),y(Ed)!=="svelte-1c2dshy"&&(Ed.innerHTML=FM),hy=r(um),Nd=l(um,"P",{"data-svelte-h":!0}),y(Nd)!=="svelte-1qvu1un"&&(Nd.textContent=GM),um.forEach(s),I.forEach(s),$g=r(e),Et=l(e,"DIV",{class:!0});var th=T(Et);m(Fa.$$.fragment,th),fy=r(th),Sd=l(th,"P",{"data-svelte-h":!0}),y(Sd)!=="svelte-170i4ti"&&(Sd.innerHTML=XM),th.forEach(s),jg=r(e),Nt=l(e,"DIV",{class:!0});var sh=T(Nt);m(Ga.$$.fragment,sh),_y=r(sh),qd=l(sh,"P",{"data-svelte-h":!0}),y(qd)!=="svelte-1dyyx4b"&&(qd.innerHTML=RM),sh.forEach(s),xg=r(e),_e=l(e,"DIV",{class:!0});var hn=T(_e);m(Xa.$$.fragment,hn),by=r(hn),Hd=l(hn,"P",{"data-svelte-h":!0}),y(Hd)!=="svelte-rxlesw"&&(Hd.textContent=EM),yy=r(hn),F=l(hn,"DIV",{class:!0});var we=T(F);m(Ra.$$.fragment,we),Ty=r(we),Dd=l(we,"P",{"data-svelte-h":!0}),y(Dd)!=="svelte-15hhlou"&&(Dd.textContent=NM),vy=r(we),Pd=l(we,"P",{"data-svelte-h":!0}),y(Pd)!=="svelte-x0d0uq"&&(Pd.innerHTML=SM),My=r(we),Qd=l(we,"P",{"data-svelte-h":!0}),y(Qd)!=="svelte-1w36vm3"&&(Qd.innerHTML=qM),wy=r(we),Yd=l(we,"P",{"data-svelte-h":!0}),y(Yd)!=="svelte-1niq0qw"&&(Yd.innerHTML=HM),ky=r(we),Ad=l(we,"P",{"data-svelte-h":!0}),y(Ad)!=="svelte-af4g6f"&&(Ad.textContent=DM),we.forEach(s),$y=r(hn),Gs=l(hn,"DIV",{class:!0});var nh=T(Gs);m(Ea.$$.fragment,nh),jy=r(nh),Od=l(nh,"P",{"data-svelte-h":!0}),y(Od)!=="svelte-eab6jp"&&(Od.textContent=PM),nh.forEach(s),hn.forEach(s),Jg=r(e),m(Na.$$.fragment,e),Ug=r(e),be=l(e,"DIV",{class:!0});var fn=T(be);m(Sa.$$.fragment,fn),xy=r(fn),Kd=l(fn,"P",{"data-svelte-h":!0}),y(Kd)!=="svelte-z841jh"&&(Kd.innerHTML=QM),Jy=r(fn),ep=l(fn,"DIV",{class:!0});var vw=T(ep);m(qa.$$.fragment,vw),vw.forEach(s),Uy=r(fn),tp=l(fn,"DIV",{class:!0});var Mw=T(tp);m(Ha.$$.fragment,Mw),Mw.forEach(s),fn.forEach(s),Bg=r(e),L=l(e,"DIV",{class:!0});var ke=T(L);m(Da.$$.fragment,ke),By=r(ke),sp=l(ke,"P",{"data-svelte-h":!0}),y(sp)!=="svelte-wmi8eb"&&(sp.innerHTML=YM),Iy=r(ke),np=l(ke,"P",{"data-svelte-h":!0}),y(np)!=="svelte-19qrwo1"&&(np.innerHTML=AM),Zy=r(ke),rp=l(ke,"P",{"data-svelte-h":!0}),y(rp)!=="svelte-l79sbt"&&(rp.innerHTML=OM),zy=r(ke),op=l(ke,"DIV",{class:!0});var ww=T(op);m(Pa.$$.fragment,ww),ww.forEach(s),Wy=r(ke),ap=l(ke,"DIV",{class:!0});var kw=T(ap);m(Qa.$$.fragment,kw),kw.forEach(s),ke.forEach(s),Ig=r(e),ye=l(e,"DIV",{class:!0});var _n=T(ye);m(Ya.$$.fragment,_n),Vy=r(_n),lp=l(_n,"P",{"data-svelte-h":!0}),y(lp)!=="svelte-errlxy"&&(lp.innerHTML=KM),Ly=r(_n),cp=l(_n,"DIV",{class:!0});var $w=T(cp);m(Aa.$$.fragment,$w),$w.forEach(s),Cy=r(_n),ip=l(_n,"DIV",{class:!0});var jw=T(ip);m(Oa.$$.fragment,jw),jw.forEach(s),_n.forEach(s),Zg=r(e),m(Ka.$$.fragment,e),zg=r(e),ct=l(e,"DIV",{class:!0});var gm=T(ct);m(el.$$.fragment,gm),Fy=r(gm),dp=l(gm,"P",{"data-svelte-h":!0}),y(dp)!=="svelte-1aiwpx2"&&(dp.textContent=e2),Gy=r(gm),pp=l(gm,"P",{"data-svelte-h":!0}),y(pp)!=="svelte-ts4ue3"&&(pp.innerHTML=t2),gm.forEach(s),Wg=r(e),it=l(e,"DIV",{class:!0});var hm=T(it);m(tl.$$.fragment,hm),Xy=r(hm),mp=l(hm,"P",{"data-svelte-h":!0}),y(mp)!=="svelte-1aiwpx2"&&(mp.textContent=s2),Ry=r(hm),up=l(hm,"P",{"data-svelte-h":!0}),y(up)!=="svelte-ts4ue3"&&(up.innerHTML=n2),hm.forEach(s),Vg=r(e),m(sl.$$.fragment,e),Lg=r(e),z=l(e,"DIV",{class:!0});var K=T(z);m(nl.$$.fragment,K),Ey=r(K),gp=l(K,"P",{"data-svelte-h":!0}),y(gp)!=="svelte-5jvlz5"&&(gp.textContent=r2),Ny=r(K),m(Xs.$$.fragment,K),Sy=r(K),m(Rs.$$.fragment,K),qy=r(K),Es=l(K,"DIV",{class:!0});var rh=T(Es);m(rl.$$.fragment,rh),Hy=r(rh),hp=l(rh,"P",{"data-svelte-h":!0}),y(hp)!=="svelte-10d94rs"&&(hp.textContent=o2),rh.forEach(s),Dy=r(K),Ns=l(K,"DIV",{class:!0});var oh=T(Ns);m(ol.$$.fragment,oh),Py=r(oh),fp=l(oh,"P",{"data-svelte-h":!0}),y(fp)!=="svelte-tm945r"&&(fp.textContent=a2),oh.forEach(s),Qy=r(K),Ss=l(K,"DIV",{class:!0});var ah=T(Ss);m(al.$$.fragment,ah),Yy=r(ah),_p=l(ah,"P",{"data-svelte-h":!0}),y(_p)!=="svelte-1i1356p"&&(_p.textContent=l2),ah.forEach(s),K.forEach(s),Cg=r(e),Y=l(e,"DIV",{class:!0});var jt=T(Y);m(ll.$$.fragment,jt),Ay=r(jt),bp=l(jt,"P",{"data-svelte-h":!0}),y(bp)!=="svelte-190fodr"&&(bp.textContent=c2),Oy=r(jt),m(qs.$$.fragment,jt),Ky=r(jt),m(Hs.$$.fragment,jt),eT=r(jt),Ds=l(jt,"DIV",{class:!0});var lh=T(Ds);m(cl.$$.fragment,lh),tT=r(lh),yp=l(lh,"P",{"data-svelte-h":!0}),y(yp)!=="svelte-16i5iz"&&(yp.textContent=i2),lh.forEach(s),jt.forEach(s),Fg=r(e),m(il.$$.fragment,e),Gg=r(e),dt=l(e,"DIV",{class:!0});var fm=T(dt);m(dl.$$.fragment,fm),sT=r(fm),Tp=l(fm,"P",{"data-svelte-h":!0}),y(Tp)!=="svelte-15qehu2"&&(Tp.textContent=d2),nT=r(fm),Ps=l(fm,"DIV",{class:!0});var ch=T(Ps);m(pl.$$.fragment,ch),rT=r(ch),vp=l(ch,"P",{"data-svelte-h":!0}),y(vp)!=="svelte-dfcv5s"&&(vp.innerHTML=p2),ch.forEach(s),fm.forEach(s),Xg=r(e),Z=l(e,"DIV",{class:!0});var G=T(Z);m(ml.$$.fragment,G),oT=r(G),Mp=l(G,"P",{"data-svelte-h":!0}),y(Mp)!=="svelte-11w7j52"&&(Mp.textContent=m2),aT=r(G),wp=l(G,"P",{"data-svelte-h":!0}),y(wp)!=="svelte-1f9j82e"&&(wp.innerHTML=u2),lT=r(G),Qs=l(G,"DIV",{class:!0});var ih=T(Qs);m(ul.$$.fragment,ih),cT=r(ih),kp=l(ih,"P",{"data-svelte-h":!0}),y(kp)!=="svelte-dfcv5s"&&(kp.innerHTML=g2),ih.forEach(s),iT=r(G),Ys=l(G,"DIV",{class:!0});var dh=T(Ys);m(gl.$$.fragment,dh),dT=r(dh),$p=l(dh,"P",{"data-svelte-h":!0}),y($p)!=="svelte-1nftdf9"&&($p.textContent=h2),dh.forEach(s),pT=r(G),As=l(G,"DIV",{class:!0});var ph=T(As);m(hl.$$.fragment,ph),mT=r(ph),jp=l(ph,"P",{"data-svelte-h":!0}),y(jp)!=="svelte-114iuj0"&&(jp.textContent=f2),ph.forEach(s),uT=r(G),Os=l(G,"DIV",{class:!0});var mh=T(Os);m(fl.$$.fragment,mh),gT=r(mh),xp=l(mh,"P",{"data-svelte-h":!0}),y(xp)!=="svelte-4hau7v"&&(xp.innerHTML=_2),mh.forEach(s),hT=r(G),Ks=l(G,"DIV",{class:!0});var uh=T(Ks);m(_l.$$.fragment,uh),fT=r(uh),Jp=l(uh,"P",{"data-svelte-h":!0}),y(Jp)!=="svelte-sp3ts6"&&(Jp.innerHTML=b2),uh.forEach(s),G.forEach(s),Rg=r(e),C=l(e,"DIV",{class:!0});var $e=T(C);m(bl.$$.fragment,$e),_T=r($e),Up=l($e,"P",{"data-svelte-h":!0}),y(Up)!=="svelte-ldcea6"&&(Up.innerHTML=y2),bT=r($e),Bp=l($e,"P",{"data-svelte-h":!0}),y(Bp)!=="svelte-1f9j82e"&&(Bp.innerHTML=T2),yT=r($e),en=l($e,"DIV",{class:!0});var gh=T(en);m(yl.$$.fragment,gh),TT=r(gh),Ip=l(gh,"P",{"data-svelte-h":!0}),y(Ip)!=="svelte-dfcv5s"&&(Ip.innerHTML=v2),gh.forEach(s),vT=r($e),tn=l($e,"DIV",{class:!0});var hh=T(tn);m(Tl.$$.fragment,hh),MT=r(hh),Zp=l(hh,"P",{"data-svelte-h":!0}),y(Zp)!=="svelte-1nftdf9"&&(Zp.textContent=M2),hh.forEach(s),wT=r($e),sn=l($e,"DIV",{class:!0});var fh=T(sn);m(vl.$$.fragment,fh),kT=r(fh),zp=l(fh,"P",{"data-svelte-h":!0}),y(zp)!=="svelte-114iuj0"&&(zp.textContent=w2),fh.forEach(s),$e.forEach(s),Eg=r(e),_m=l(e,"P",{}),T(_m).forEach(s),this.h()},h(){v(i,"name","hf:doc:metadata"),v(i,"content",fk),v(xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(It,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Dt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Pt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Qt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ac,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ic,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(mc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(hc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(_c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(yc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(vc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(wc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(xc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ic,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Wc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Lc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Fc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Xc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ec,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Sc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Hc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Pc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Yc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Oc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ti,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ni,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(oi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(li,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ii,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(pi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ui,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(fi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(yi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Mi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ki,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ji,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ji,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Js,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Zi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Us,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Li,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Fi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Xi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ei,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Si,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Hi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Pi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Yi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Oi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ed,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(sd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(rd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Bs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(cd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Is,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(md,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(gd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(fd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(bd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Td,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Md,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(kd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(xd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Jd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Bd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(at,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Zd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(zs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ws,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Vs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ls,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Cs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Fs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(_t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Gs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ep,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(tp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(op,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ap,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(cp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ip,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(it,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Es,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ns,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ss,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ds,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ps,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(dt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Qs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ys,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(As,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Os,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ks,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(en,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(sn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){t(document.head,i),d(e,$,c),d(e,b,c),d(e,_,c),u(w,e,c),d(e,o,c),d(e,k,c),d(e,jm,c),d(e,yn,c),d(e,xm,c),u(Tn,e,c),d(e,Jm,c),d(e,vn,c),d(e,Um,c),d(e,Mn,c),d(e,Bm,c),u(wn,e,c),d(e,Im,c),d(e,kn,c),d(e,Zm,c),d(e,$n,c),d(e,zm,c),d(e,jn,c),d(e,Wm,c),d(e,xn,c),d(e,Vm,c),d(e,Jn,c),d(e,Lm,c),u(Un,e,c),d(e,Cm,c),d(e,Bn,c),d(e,Fm,c),d(e,In,c),d(e,Gm,c),d(e,Zn,c),d(e,Xm,c),u(zn,e,c),d(e,Rm,c),d(e,xt,c),u(Wn,xt,null),t(xt,_h),t(xt,Gl),d(e,Em,c),d(e,Jt,c),u(Vn,Jt,null),t(Jt,bh),t(Jt,Xl),d(e,Nm,c),d(e,Ut,c),u(Ln,Ut,null),t(Ut,yh),t(Ut,Rl),d(e,Sm,c),d(e,Bt,c),u(Cn,Bt,null),t(Bt,Th),t(Bt,El),d(e,qm,c),u(Fn,e,c),d(e,Hm,c),d(e,It,c),u(Gn,It,null),t(It,vh),t(It,Nl),d(e,Dm,c),d(e,Zt,c),u(Xn,Zt,null),t(Zt,Mh),t(Zt,Sl),d(e,Pm,c),d(e,zt,c),u(Rn,zt,null),t(zt,wh),t(zt,ql),d(e,Qm,c),d(e,Wt,c),u(En,Wt,null),t(Wt,kh),t(Wt,Hl),d(e,Ym,c),d(e,Vt,c),u(Nn,Vt,null),t(Vt,$h),t(Vt,Dl),d(e,Am,c),d(e,Lt,c),u(Sn,Lt,null),t(Lt,jh),t(Lt,Pl),d(e,Om,c),d(e,Ct,c),u(qn,Ct,null),t(Ct,xh),t(Ct,Ql),d(e,Km,c),d(e,Ft,c),u(Hn,Ft,null),t(Ft,Jh),t(Ft,Yl),d(e,eu,c),d(e,Gt,c),u(Dn,Gt,null),t(Gt,Uh),t(Gt,Al),d(e,tu,c),d(e,Xt,c),u(Pn,Xt,null),t(Xt,Bh),t(Xt,Ol),d(e,su,c),u(Qn,e,c),d(e,nu,c),d(e,je,c),u(Yn,je,null),t(je,Ih),t(je,Kl),t(je,Zh),t(je,Dt),u(An,Dt,null),t(Dt,zh),t(Dt,ec),d(e,ru,c),d(e,xe,c),u(On,xe,null),t(xe,Wh),t(xe,tc),t(xe,Vh),t(xe,Pt),u(Kn,Pt,null),t(Pt,Lh),t(Pt,sc),d(e,ou,c),d(e,Je,c),u(er,Je,null),t(Je,Ch),t(Je,nc),t(Je,Fh),t(Je,Qt),u(tr,Qt,null),t(Qt,Gh),t(Qt,rc),d(e,au,c),u(sr,e,c),d(e,lu,c),d(e,nr,c),d(e,cu,c),u(rr,e,c),d(e,iu,c),d(e,ee,c),u(or,ee,null),t(ee,Xh),t(ee,oc),t(ee,Rh),u(Yt,ee,null),t(ee,Eh),t(ee,ac),u(ar,ac,null),d(e,du,c),d(e,W,c),u(lr,W,null),t(W,Nh),t(W,lc),t(W,Sh),t(W,cc),t(W,qh),u(At,W,null),t(W,Hh),u(Ot,W,null),t(W,Dh),t(W,ic),u(cr,ic,null),d(e,pu,c),d(e,X,c),u(ir,X,null),t(X,Ph),t(X,dc),t(X,Qh),t(X,pc),t(X,Yh),u(Kt,X,null),t(X,Ah),t(X,mc),u(dr,mc,null),d(e,mu,c),d(e,R,c),u(pr,R,null),t(R,Oh),t(R,uc),t(R,Kh),t(R,gc),t(R,ef),u(es,R,null),t(R,tf),t(R,hc),u(mr,hc,null),d(e,uu,c),d(e,te,c),u(ur,te,null),t(te,sf),t(te,fc),t(te,nf),u(ts,te,null),t(te,rf),t(te,_c),u(gr,_c,null),d(e,gu,c),d(e,se,c),u(hr,se,null),t(se,of),t(se,bc),t(se,af),u(ss,se,null),t(se,lf),t(se,yc),u(fr,yc,null),d(e,hu,c),d(e,ne,c),u(_r,ne,null),t(ne,cf),t(ne,Tc),t(ne,df),u(ns,ne,null),t(ne,pf),t(ne,vc),u(br,vc,null),d(e,fu,c),d(e,re,c),u(yr,re,null),t(re,mf),t(re,Mc),t(re,uf),u(rs,re,null),t(re,gf),t(re,wc),u(Tr,wc,null),d(e,_u,c),d(e,oe,c),u(vr,oe,null),t(oe,hf),t(oe,kc),t(oe,ff),u(os,oe,null),t(oe,_f),t(oe,$c),u(Mr,$c,null),d(e,bu,c),d(e,ae,c),u(wr,ae,null),t(ae,bf),t(ae,jc),t(ae,yf),u(as,ae,null),t(ae,Tf),t(ae,xc),u(kr,xc,null),d(e,yu,c),d(e,V,c),u($r,V,null),t(V,vf),t(V,Jc),t(V,Mf),t(V,Uc),t(V,wf),t(V,Bc),t(V,kf),u(ls,V,null),t(V,$f),t(V,Ic),u(jr,Ic,null),d(e,Tu,c),d(e,le,c),u(xr,le,null),t(le,jf),t(le,Zc),t(le,xf),t(le,zc),t(le,Jf),t(le,Wc),u(Jr,Wc,null),d(e,vu,c),d(e,ce,c),u(Ur,ce,null),t(ce,Uf),t(ce,Vc),t(ce,Bf),u(cs,ce,null),t(ce,If),t(ce,Lc),u(Br,Lc,null),d(e,Mu,c),d(e,Ue,c),u(Ir,Ue,null),t(Ue,Zf),t(Ue,Cc),t(Ue,zf),t(Ue,Fc),u(Zr,Fc,null),d(e,wu,c),d(e,Be,c),u(zr,Be,null),t(Be,Wf),t(Be,Gc),t(Be,Vf),t(Be,Xc),u(Wr,Xc,null),d(e,ku,c),d(e,Ie,c),u(Vr,Ie,null),t(Ie,Lf),t(Ie,Rc),t(Ie,Cf),t(Ie,Ec),u(Lr,Ec,null),d(e,$u,c),d(e,ie,c),u(Cr,ie,null),t(ie,Ff),t(ie,Nc),t(ie,Gf),u(is,ie,null),t(ie,Xf),t(ie,Sc),u(Fr,Sc,null),d(e,ju,c),d(e,de,c),u(Gr,de,null),t(de,Rf),t(de,qc),t(de,Ef),u(ds,de,null),t(de,Nf),t(de,Hc),u(Xr,Hc,null),d(e,xu,c),d(e,E,c),u(Rr,E,null),t(E,Sf),t(E,Dc),t(E,qf),u(ps,E,null),t(E,Hf),u(ms,E,null),t(E,Df),t(E,Pc),u(Er,Pc,null),d(e,Ju,c),d(e,N,c),u(Nr,N,null),t(N,Pf),t(N,Qc),t(N,Qf),u(us,N,null),t(N,Yf),u(gs,N,null),t(N,Af),t(N,Yc),u(Sr,Yc,null),d(e,Uu,c),d(e,pe,c),u(qr,pe,null),t(pe,Of),t(pe,Ac),t(pe,Kf),u(hs,pe,null),t(pe,e_),t(pe,Oc),u(Hr,Oc,null),d(e,Bu,c),d(e,S,c),u(Dr,S,null),t(S,t_),t(S,Kc),t(S,s_),t(S,ei),t(S,n_),u(fs,S,null),t(S,r_),t(S,ti),u(Pr,ti,null),d(e,Iu,c),d(e,q,c),u(Qr,q,null),t(q,o_),t(q,si),t(q,a_),u(_s,q,null),t(q,l_),u(bs,q,null),t(q,c_),t(q,ni),u(Yr,ni,null),d(e,Zu,c),d(e,me,c),u(Ar,me,null),t(me,i_),t(me,ri),t(me,d_),u(ys,me,null),t(me,p_),t(me,oi),u(Or,oi,null),d(e,zu,c),d(e,ue,c),u(Kr,ue,null),t(ue,m_),t(ue,ai),t(ue,u_),u(Ts,ue,null),t(ue,g_),t(ue,li),u(eo,li,null),d(e,Wu,c),d(e,H,c),u(to,H,null),t(H,h_),t(H,ci),t(H,f_),u(vs,H,null),t(H,__),u(Ms,H,null),t(H,b_),t(H,ii),u(so,ii,null),d(e,Vu,c),d(e,ge,c),u(no,ge,null),t(ge,y_),t(ge,di),t(ge,T_),u(ws,ge,null),t(ge,v_),t(ge,pi),u(ro,pi,null),d(e,Lu,c),d(e,he,c),u(oo,he,null),t(he,M_),t(he,mi),t(he,w_),u(ks,he,null),t(he,k_),t(he,ui),u(ao,ui,null),d(e,Cu,c),d(e,D,c),u(lo,D,null),t(D,$_),t(D,gi),t(D,j_),t(D,hi),t(D,x_),u($s,D,null),t(D,J_),t(D,fi),u(co,fi,null),d(e,Fu,c),d(e,P,c),u(io,P,null),t(P,U_),t(P,_i),t(P,B_),t(P,bi),t(P,I_),u(js,P,null),t(P,Z_),t(P,yi),u(po,yi,null),d(e,Gu,c),d(e,Q,c),u(mo,Q,null),t(Q,z_),t(Q,Ti),t(Q,W_),t(Q,vi),t(Q,V_),u(xs,Q,null),t(Q,L_),t(Q,Mi),u(uo,Mi,null),d(e,Xu,c),u(go,e,c),d(e,Ru,c),d(e,Ze,c),u(ho,Ze,null),t(Ze,C_),t(Ze,wi),t(Ze,F_),t(Ze,ki),u(fo,ki,null),d(e,Eu,c),d(e,ze,c),u(_o,ze,null),t(ze,G_),t(ze,$i),t(ze,X_),t(ze,ji),u(bo,ji,null),d(e,Nu,c),d(e,We,c),u(yo,We,null),t(We,R_),t(We,xi),t(We,E_),t(We,Ji),u(To,Ji,null),d(e,Su,c),d(e,Ve,c),u(vo,Ve,null),t(Ve,N_),t(Ve,Ui),t(Ve,S_),t(Ve,Js),u(Mo,Js,null),t(Js,q_),t(Js,Bi),d(e,qu,c),d(e,Le,c),u(wo,Le,null),t(Le,H_),t(Le,Ii),t(Le,D_),t(Le,Zi),u(ko,Zi,null),d(e,Hu,c),d(e,Ce,c),u($o,Ce,null),t(Ce,P_),t(Ce,zi),t(Ce,Q_),t(Ce,Us),u(jo,Us,null),t(Us,Y_),t(Us,Wi),d(e,Du,c),d(e,Fe,c),u(xo,Fe,null),t(Fe,A_),t(Fe,Vi),t(Fe,O_),t(Fe,Li),u(Jo,Li,null),d(e,Pu,c),d(e,Ge,c),u(Uo,Ge,null),t(Ge,K_),t(Ge,Ci),t(Ge,eb),t(Ge,Fi),u(Bo,Fi,null),d(e,Qu,c),d(e,Xe,c),u(Io,Xe,null),t(Xe,tb),t(Xe,Gi),t(Xe,sb),t(Xe,Xi),u(Zo,Xi,null),d(e,Yu,c),d(e,Re,c),u(zo,Re,null),t(Re,nb),t(Re,Ri),t(Re,rb),t(Re,Ei),u(Wo,Ei,null),d(e,Au,c),d(e,Ee,c),u(Vo,Ee,null),t(Ee,ob),t(Ee,Ni),t(Ee,ab),t(Ee,Si),u(Lo,Si,null),d(e,Ou,c),d(e,Ne,c),u(Co,Ne,null),t(Ne,lb),t(Ne,qi),t(Ne,cb),t(Ne,Hi),u(Fo,Hi,null),d(e,Ku,c),d(e,Se,c),u(Go,Se,null),t(Se,ib),t(Se,Di),t(Se,db),t(Se,Pi),u(Xo,Pi,null),d(e,eg,c),d(e,qe,c),u(Ro,qe,null),t(qe,pb),t(qe,Qi),t(qe,mb),t(qe,Yi),u(Eo,Yi,null),d(e,tg,c),d(e,He,c),u(No,He,null),t(He,ub),t(He,Ai),t(He,gb),t(He,Oi),u(So,Oi,null),d(e,sg,c),u(qo,e,c),d(e,ng,c),d(e,De,c),u(Ho,De,null),t(De,hb),t(De,Ki),t(De,fb),t(De,ed),u(Do,ed,null),d(e,rg,c),d(e,Pe,c),u(Po,Pe,null),t(Pe,_b),t(Pe,td),t(Pe,bb),t(Pe,sd),u(Qo,sd,null),d(e,og,c),d(e,Qe,c),u(Yo,Qe,null),t(Qe,yb),t(Qe,nd),t(Qe,Tb),t(Qe,rd),u(Ao,rd,null),d(e,ag,c),d(e,Ye,c),u(Oo,Ye,null),t(Ye,vb),t(Ye,od),t(Ye,Mb),t(Ye,Bs),u(Ko,Bs,null),t(Bs,wb),t(Bs,ad),d(e,lg,c),d(e,Ae,c),u(ea,Ae,null),t(Ae,kb),t(Ae,ld),t(Ae,$b),t(Ae,cd),u(ta,cd,null),d(e,cg,c),d(e,Oe,c),u(sa,Oe,null),t(Oe,jb),t(Oe,id),t(Oe,xb),t(Oe,Is),u(na,Is,null),t(Is,Jb),t(Is,dd),d(e,ig,c),d(e,Ke,c),u(ra,Ke,null),t(Ke,Ub),t(Ke,pd),t(Ke,Bb),t(Ke,md),u(oa,md,null),d(e,dg,c),d(e,et,c),u(aa,et,null),t(et,Ib),t(et,ud),t(et,Zb),t(et,gd),u(la,gd,null),d(e,pg,c),d(e,tt,c),u(ca,tt,null),t(tt,zb),t(tt,hd),t(tt,Wb),t(tt,fd),u(ia,fd,null),d(e,mg,c),d(e,st,c),u(da,st,null),t(st,Vb),t(st,_d),t(st,Lb),t(st,bd),u(pa,bd,null),d(e,ug,c),d(e,nt,c),u(ma,nt,null),t(nt,Cb),t(nt,yd),t(nt,Fb),t(nt,Td),u(ua,Td,null),d(e,gg,c),d(e,rt,c),u(ga,rt,null),t(rt,Gb),t(rt,vd),t(rt,Xb),t(rt,Md),u(ha,Md,null),d(e,hg,c),d(e,ot,c),u(fa,ot,null),t(ot,Rb),t(ot,wd),t(ot,Eb),t(ot,kd),u(_a,kd,null),d(e,fg,c),u(ba,e,c),d(e,_g,c),d(e,ya,c),d(e,bg,c),d(e,fe,c),u(Ta,fe,null),t(fe,Nb),t(fe,$d),t(fe,Sb),t(fe,jd),t(fe,qb),t(fe,xd),u(va,xd,null),d(e,yg,c),d(e,Rt,c),u(Ma,Rt,null),t(Rt,Hb),t(Rt,Jd),u(wa,Jd,null),d(e,Tg,c),d(e,at,c),u(ka,at,null),t(at,Db),t(at,Ud),t(at,Pb),t(at,Bd),u($a,Bd,null),d(e,vg,c),d(e,lt,c),u(ja,lt,null),t(lt,Qb),t(lt,Id),t(lt,Yb),t(lt,Zd),u(xa,Zd,null),d(e,Mg,c),u(Ja,e,c),d(e,wg,c),d(e,Ua,c),d(e,kg,c),d(e,U,c),u(Ba,U,null),t(U,Ab),t(U,zd),t(U,Ob),t(U,Wd),t(U,Kb),u(Zs,U,null),t(U,ey),t(U,Vd),t(U,ty),t(U,zs),u(Ia,zs,null),t(zs,sy),t(zs,Ld),t(U,ny),t(U,Ws),u(Za,Ws,null),t(Ws,ry),t(Ws,Cd),t(U,oy),t(U,Vs),u(za,Vs,null),t(Vs,ay),t(Vs,Fd),t(U,ly),t(U,Ls),u(Wa,Ls,null),t(Ls,cy),t(Ls,Gd),t(U,iy),t(U,Cs),u(Va,Cs,null),t(Cs,dy),t(Cs,Xd),t(U,py),t(U,Fs),u(La,Fs,null),t(Fs,my),t(Fs,Rd),t(U,uy),t(U,_t),u(Ca,_t,null),t(_t,gy),t(_t,Ed),t(_t,hy),t(_t,Nd),d(e,$g,c),d(e,Et,c),u(Fa,Et,null),t(Et,fy),t(Et,Sd),d(e,jg,c),d(e,Nt,c),u(Ga,Nt,null),t(Nt,_y),t(Nt,qd),d(e,xg,c),d(e,_e,c),u(Xa,_e,null),t(_e,by),t(_e,Hd),t(_e,yy),t(_e,F),u(Ra,F,null),t(F,Ty),t(F,Dd),t(F,vy),t(F,Pd),t(F,My),t(F,Qd),t(F,wy),t(F,Yd),t(F,ky),t(F,Ad),t(_e,$y),t(_e,Gs),u(Ea,Gs,null),t(Gs,jy),t(Gs,Od),d(e,Jg,c),u(Na,e,c),d(e,Ug,c),d(e,be,c),u(Sa,be,null),t(be,xy),t(be,Kd),t(be,Jy),t(be,ep),u(qa,ep,null),t(be,Uy),t(be,tp),u(Ha,tp,null),d(e,Bg,c),d(e,L,c),u(Da,L,null),t(L,By),t(L,sp),t(L,Iy),t(L,np),t(L,Zy),t(L,rp),t(L,zy),t(L,op),u(Pa,op,null),t(L,Wy),t(L,ap),u(Qa,ap,null),d(e,Ig,c),d(e,ye,c),u(Ya,ye,null),t(ye,Vy),t(ye,lp),t(ye,Ly),t(ye,cp),u(Aa,cp,null),t(ye,Cy),t(ye,ip),u(Oa,ip,null),d(e,Zg,c),u(Ka,e,c),d(e,zg,c),d(e,ct,c),u(el,ct,null),t(ct,Fy),t(ct,dp),t(ct,Gy),t(ct,pp),d(e,Wg,c),d(e,it,c),u(tl,it,null),t(it,Xy),t(it,mp),t(it,Ry),t(it,up),d(e,Vg,c),u(sl,e,c),d(e,Lg,c),d(e,z,c),u(nl,z,null),t(z,Ey),t(z,gp),t(z,Ny),u(Xs,z,null),t(z,Sy),u(Rs,z,null),t(z,qy),t(z,Es),u(rl,Es,null),t(Es,Hy),t(Es,hp),t(z,Dy),t(z,Ns),u(ol,Ns,null),t(Ns,Py),t(Ns,fp),t(z,Qy),t(z,Ss),u(al,Ss,null),t(Ss,Yy),t(Ss,_p),d(e,Cg,c),d(e,Y,c),u(ll,Y,null),t(Y,Ay),t(Y,bp),t(Y,Oy),u(qs,Y,null),t(Y,Ky),u(Hs,Y,null),t(Y,eT),t(Y,Ds),u(cl,Ds,null),t(Ds,tT),t(Ds,yp),d(e,Fg,c),u(il,e,c),d(e,Gg,c),d(e,dt,c),u(dl,dt,null),t(dt,sT),t(dt,Tp),t(dt,nT),t(dt,Ps),u(pl,Ps,null),t(Ps,rT),t(Ps,vp),d(e,Xg,c),d(e,Z,c),u(ml,Z,null),t(Z,oT),t(Z,Mp),t(Z,aT),t(Z,wp),t(Z,lT),t(Z,Qs),u(ul,Qs,null),t(Qs,cT),t(Qs,kp),t(Z,iT),t(Z,Ys),u(gl,Ys,null),t(Ys,dT),t(Ys,$p),t(Z,pT),t(Z,As),u(hl,As,null),t(As,mT),t(As,jp),t(Z,uT),t(Z,Os),u(fl,Os,null),t(Os,gT),t(Os,xp),t(Z,hT),t(Z,Ks),u(_l,Ks,null),t(Ks,fT),t(Ks,Jp),d(e,Rg,c),d(e,C,c),u(bl,C,null),t(C,_T),t(C,Up),t(C,bT),t(C,Bp),t(C,yT),t(C,en),u(yl,en,null),t(en,TT),t(en,Ip),t(C,vT),t(C,tn),u(Tl,tn,null),t(tn,MT),t(tn,Zp),t(C,wT),t(C,sn),u(vl,sn,null),t(sn,kT),t(sn,zp),d(e,Eg,c),d(e,_m,c),Ng=!0},p(e,[c]){const Ml={};c&2&&(Ml.$$scope={dirty:c,ctx:e}),Yt.$set(Ml);const wl={};c&2&&(wl.$$scope={dirty:c,ctx:e}),At.$set(wl);const kl={};c&2&&(kl.$$scope={dirty:c,ctx:e}),Ot.$set(kl);const $l={};c&2&&($l.$$scope={dirty:c,ctx:e}),Kt.$set($l);const jl={};c&2&&(jl.$$scope={dirty:c,ctx:e}),es.$set(jl);const xl={};c&2&&(xl.$$scope={dirty:c,ctx:e}),ts.$set(xl);const Jl={};c&2&&(Jl.$$scope={dirty:c,ctx:e}),ss.$set(Jl);const Ul={};c&2&&(Ul.$$scope={dirty:c,ctx:e}),ns.$set(Ul);const Bl={};c&2&&(Bl.$$scope={dirty:c,ctx:e}),rs.$set(Bl);const Il={};c&2&&(Il.$$scope={dirty:c,ctx:e}),os.$set(Il);const Zl={};c&2&&(Zl.$$scope={dirty:c,ctx:e}),as.$set(Zl);const zl={};c&2&&(zl.$$scope={dirty:c,ctx:e}),ls.$set(zl);const Wl={};c&2&&(Wl.$$scope={dirty:c,ctx:e}),cs.$set(Wl);const Vl={};c&2&&(Vl.$$scope={dirty:c,ctx:e}),is.$set(Vl);const St={};c&2&&(St.$$scope={dirty:c,ctx:e}),ds.$set(St);const Ll={};c&2&&(Ll.$$scope={dirty:c,ctx:e}),ps.$set(Ll);const qt={};c&2&&(qt.$$scope={dirty:c,ctx:e}),ms.$set(qt);const Cl={};c&2&&(Cl.$$scope={dirty:c,ctx:e}),us.$set(Cl);const Ht={};c&2&&(Ht.$$scope={dirty:c,ctx:e}),gs.$set(Ht);const Fl={};c&2&&(Fl.$$scope={dirty:c,ctx:e}),hs.$set(Fl);const pt={};c&2&&(pt.$$scope={dirty:c,ctx:e}),fs.$set(pt);const bm={};c&2&&(bm.$$scope={dirty:c,ctx:e}),_s.$set(bm);const A={};c&2&&(A.$$scope={dirty:c,ctx:e}),bs.$set(A);const ym={};c&2&&(ym.$$scope={dirty:c,ctx:e}),ys.$set(ym);const Te={};c&2&&(Te.$$scope={dirty:c,ctx:e}),Ts.$set(Te);const Tm={};c&2&&(Tm.$$scope={dirty:c,ctx:e}),vs.$set(Tm);const ve={};c&2&&(ve.$$scope={dirty:c,ctx:e}),Ms.$set(ve);const vm={};c&2&&(vm.$$scope={dirty:c,ctx:e}),ws.$set(vm);const mt={};c&2&&(mt.$$scope={dirty:c,ctx:e}),ks.$set(mt);const Mm={};c&2&&(Mm.$$scope={dirty:c,ctx:e}),$s.$set(Mm);const ut={};c&2&&(ut.$$scope={dirty:c,ctx:e}),js.$set(ut);const wm={};c&2&&(wm.$$scope={dirty:c,ctx:e}),xs.$set(wm);const gt={};c&2&&(gt.$$scope={dirty:c,ctx:e}),Zs.$set(gt);const km={};c&2&&(km.$$scope={dirty:c,ctx:e}),Xs.$set(km);const ht={};c&2&&(ht.$$scope={dirty:c,ctx:e}),Rs.$set(ht);const $m={};c&2&&($m.$$scope={dirty:c,ctx:e}),qs.$set($m);const ft={};c&2&&(ft.$$scope={dirty:c,ctx:e}),Hs.$set(ft)},i(e){Ng||(g(w.$$.fragment,e),g(Tn.$$.fragment,e),g(wn.$$.fragment,e),g(Un.$$.fragment,e),g(zn.$$.fragment,e),g(Wn.$$.fragment,e),g(Vn.$$.fragment,e),g(Ln.$$.fragment,e),g(Cn.$$.fragment,e),g(Fn.$$.fragment,e),g(Gn.$$.fragment,e),g(Xn.$$.fragment,e),g(Rn.$$.fragment,e),g(En.$$.fragment,e),g(Nn.$$.fragment,e),g(Sn.$$.fragment,e),g(qn.$$.fragment,e),g(Hn.$$.fragment,e),g(Dn.$$.fragment,e),g(Pn.$$.fragment,e),g(Qn.$$.fragment,e),g(Yn.$$.fragment,e),g(An.$$.fragment,e),g(On.$$.fragment,e),g(Kn.$$.fragment,e),g(er.$$.fragment,e),g(tr.$$.fragment,e),g(sr.$$.fragment,e),g(rr.$$.fragment,e),g(or.$$.fragment,e),g(Yt.$$.fragment,e),g(ar.$$.fragment,e),g(lr.$$.fragment,e),g(At.$$.fragment,e),g(Ot.$$.fragment,e),g(cr.$$.fragment,e),g(ir.$$.fragment,e),g(Kt.$$.fragment,e),g(dr.$$.fragment,e),g(pr.$$.fragment,e),g(es.$$.fragment,e),g(mr.$$.fragment,e),g(ur.$$.fragment,e),g(ts.$$.fragment,e),g(gr.$$.fragment,e),g(hr.$$.fragment,e),g(ss.$$.fragment,e),g(fr.$$.fragment,e),g(_r.$$.fragment,e),g(ns.$$.fragment,e),g(br.$$.fragment,e),g(yr.$$.fragment,e),g(rs.$$.fragment,e),g(Tr.$$.fragment,e),g(vr.$$.fragment,e),g(os.$$.fragment,e),g(Mr.$$.fragment,e),g(wr.$$.fragment,e),g(as.$$.fragment,e),g(kr.$$.fragment,e),g($r.$$.fragment,e),g(ls.$$.fragment,e),g(jr.$$.fragment,e),g(xr.$$.fragment,e),g(Jr.$$.fragment,e),g(Ur.$$.fragment,e),g(cs.$$.fragment,e),g(Br.$$.fragment,e),g(Ir.$$.fragment,e),g(Zr.$$.fragment,e),g(zr.$$.fragment,e),g(Wr.$$.fragment,e),g(Vr.$$.fragment,e),g(Lr.$$.fragment,e),g(Cr.$$.fragment,e),g(is.$$.fragment,e),g(Fr.$$.fragment,e),g(Gr.$$.fragment,e),g(ds.$$.fragment,e),g(Xr.$$.fragment,e),g(Rr.$$.fragment,e),g(ps.$$.fragment,e),g(ms.$$.fragment,e),g(Er.$$.fragment,e),g(Nr.$$.fragment,e),g(us.$$.fragment,e),g(gs.$$.fragment,e),g(Sr.$$.fragment,e),g(qr.$$.fragment,e),g(hs.$$.fragment,e),g(Hr.$$.fragment,e),g(Dr.$$.fragment,e),g(fs.$$.fragment,e),g(Pr.$$.fragment,e),g(Qr.$$.fragment,e),g(_s.$$.fragment,e),g(bs.$$.fragment,e),g(Yr.$$.fragment,e),g(Ar.$$.fragment,e),g(ys.$$.fragment,e),g(Or.$$.fragment,e),g(Kr.$$.fragment,e),g(Ts.$$.fragment,e),g(eo.$$.fragment,e),g(to.$$.fragment,e),g(vs.$$.fragment,e),g(Ms.$$.fragment,e),g(so.$$.fragment,e),g(no.$$.fragment,e),g(ws.$$.fragment,e),g(ro.$$.fragment,e),g(oo.$$.fragment,e),g(ks.$$.fragment,e),g(ao.$$.fragment,e),g(lo.$$.fragment,e),g($s.$$.fragment,e),g(co.$$.fragment,e),g(io.$$.fragment,e),g(js.$$.fragment,e),g(po.$$.fragment,e),g(mo.$$.fragment,e),g(xs.$$.fragment,e),g(uo.$$.fragment,e),g(go.$$.fragment,e),g(ho.$$.fragment,e),g(fo.$$.fragment,e),g(_o.$$.fragment,e),g(bo.$$.fragment,e),g(yo.$$.fragment,e),g(To.$$.fragment,e),g(vo.$$.fragment,e),g(Mo.$$.fragment,e),g(wo.$$.fragment,e),g(ko.$$.fragment,e),g($o.$$.fragment,e),g(jo.$$.fragment,e),g(xo.$$.fragment,e),g(Jo.$$.fragment,e),g(Uo.$$.fragment,e),g(Bo.$$.fragment,e),g(Io.$$.fragment,e),g(Zo.$$.fragment,e),g(zo.$$.fragment,e),g(Wo.$$.fragment,e),g(Vo.$$.fragment,e),g(Lo.$$.fragment,e),g(Co.$$.fragment,e),g(Fo.$$.fragment,e),g(Go.$$.fragment,e),g(Xo.$$.fragment,e),g(Ro.$$.fragment,e),g(Eo.$$.fragment,e),g(No.$$.fragment,e),g(So.$$.fragment,e),g(qo.$$.fragment,e),g(Ho.$$.fragment,e),g(Do.$$.fragment,e),g(Po.$$.fragment,e),g(Qo.$$.fragment,e),g(Yo.$$.fragment,e),g(Ao.$$.fragment,e),g(Oo.$$.fragment,e),g(Ko.$$.fragment,e),g(ea.$$.fragment,e),g(ta.$$.fragment,e),g(sa.$$.fragment,e),g(na.$$.fragment,e),g(ra.$$.fragment,e),g(oa.$$.fragment,e),g(aa.$$.fragment,e),g(la.$$.fragment,e),g(ca.$$.fragment,e),g(ia.$$.fragment,e),g(da.$$.fragment,e),g(pa.$$.fragment,e),g(ma.$$.fragment,e),g(ua.$$.fragment,e),g(ga.$$.fragment,e),g(ha.$$.fragment,e),g(fa.$$.fragment,e),g(_a.$$.fragment,e),g(ba.$$.fragment,e),g(Ta.$$.fragment,e),g(va.$$.fragment,e),g(Ma.$$.fragment,e),g(wa.$$.fragment,e),g(ka.$$.fragment,e),g($a.$$.fragment,e),g(ja.$$.fragment,e),g(xa.$$.fragment,e),g(Ja.$$.fragment,e),g(Ba.$$.fragment,e),g(Zs.$$.fragment,e),g(Ia.$$.fragment,e),g(Za.$$.fragment,e),g(za.$$.fragment,e),g(Wa.$$.fragment,e),g(Va.$$.fragment,e),g(La.$$.fragment,e),g(Ca.$$.fragment,e),g(Fa.$$.fragment,e),g(Ga.$$.fragment,e),g(Xa.$$.fragment,e),g(Ra.$$.fragment,e),g(Ea.$$.fragment,e),g(Na.$$.fragment,e),g(Sa.$$.fragment,e),g(qa.$$.fragment,e),g(Ha.$$.fragment,e),g(Da.$$.fragment,e),g(Pa.$$.fragment,e),g(Qa.$$.fragment,e),g(Ya.$$.fragment,e),g(Aa.$$.fragment,e),g(Oa.$$.fragment,e),g(Ka.$$.fragment,e),g(el.$$.fragment,e),g(tl.$$.fragment,e),g(sl.$$.fragment,e),g(nl.$$.fragment,e),g(Xs.$$.fragment,e),g(Rs.$$.fragment,e),g(rl.$$.fragment,e),g(ol.$$.fragment,e),g(al.$$.fragment,e),g(ll.$$.fragment,e),g(qs.$$.fragment,e),g(Hs.$$.fragment,e),g(cl.$$.fragment,e),g(il.$$.fragment,e),g(dl.$$.fragment,e),g(pl.$$.fragment,e),g(ml.$$.fragment,e),g(ul.$$.fragment,e),g(gl.$$.fragment,e),g(hl.$$.fragment,e),g(fl.$$.fragment,e),g(_l.$$.fragment,e),g(bl.$$.fragment,e),g(yl.$$.fragment,e),g(Tl.$$.fragment,e),g(vl.$$.fragment,e),Ng=!0)},o(e){h(w.$$.fragment,e),h(Tn.$$.fragment,e),h(wn.$$.fragment,e),h(Un.$$.fragment,e),h(zn.$$.fragment,e),h(Wn.$$.fragment,e),h(Vn.$$.fragment,e),h(Ln.$$.fragment,e),h(Cn.$$.fragment,e),h(Fn.$$.fragment,e),h(Gn.$$.fragment,e),h(Xn.$$.fragment,e),h(Rn.$$.fragment,e),h(En.$$.fragment,e),h(Nn.$$.fragment,e),h(Sn.$$.fragment,e),h(qn.$$.fragment,e),h(Hn.$$.fragment,e),h(Dn.$$.fragment,e),h(Pn.$$.fragment,e),h(Qn.$$.fragment,e),h(Yn.$$.fragment,e),h(An.$$.fragment,e),h(On.$$.fragment,e),h(Kn.$$.fragment,e),h(er.$$.fragment,e),h(tr.$$.fragment,e),h(sr.$$.fragment,e),h(rr.$$.fragment,e),h(or.$$.fragment,e),h(Yt.$$.fragment,e),h(ar.$$.fragment,e),h(lr.$$.fragment,e),h(At.$$.fragment,e),h(Ot.$$.fragment,e),h(cr.$$.fragment,e),h(ir.$$.fragment,e),h(Kt.$$.fragment,e),h(dr.$$.fragment,e),h(pr.$$.fragment,e),h(es.$$.fragment,e),h(mr.$$.fragment,e),h(ur.$$.fragment,e),h(ts.$$.fragment,e),h(gr.$$.fragment,e),h(hr.$$.fragment,e),h(ss.$$.fragment,e),h(fr.$$.fragment,e),h(_r.$$.fragment,e),h(ns.$$.fragment,e),h(br.$$.fragment,e),h(yr.$$.fragment,e),h(rs.$$.fragment,e),h(Tr.$$.fragment,e),h(vr.$$.fragment,e),h(os.$$.fragment,e),h(Mr.$$.fragment,e),h(wr.$$.fragment,e),h(as.$$.fragment,e),h(kr.$$.fragment,e),h($r.$$.fragment,e),h(ls.$$.fragment,e),h(jr.$$.fragment,e),h(xr.$$.fragment,e),h(Jr.$$.fragment,e),h(Ur.$$.fragment,e),h(cs.$$.fragment,e),h(Br.$$.fragment,e),h(Ir.$$.fragment,e),h(Zr.$$.fragment,e),h(zr.$$.fragment,e),h(Wr.$$.fragment,e),h(Vr.$$.fragment,e),h(Lr.$$.fragment,e),h(Cr.$$.fragment,e),h(is.$$.fragment,e),h(Fr.$$.fragment,e),h(Gr.$$.fragment,e),h(ds.$$.fragment,e),h(Xr.$$.fragment,e),h(Rr.$$.fragment,e),h(ps.$$.fragment,e),h(ms.$$.fragment,e),h(Er.$$.fragment,e),h(Nr.$$.fragment,e),h(us.$$.fragment,e),h(gs.$$.fragment,e),h(Sr.$$.fragment,e),h(qr.$$.fragment,e),h(hs.$$.fragment,e),h(Hr.$$.fragment,e),h(Dr.$$.fragment,e),h(fs.$$.fragment,e),h(Pr.$$.fragment,e),h(Qr.$$.fragment,e),h(_s.$$.fragment,e),h(bs.$$.fragment,e),h(Yr.$$.fragment,e),h(Ar.$$.fragment,e),h(ys.$$.fragment,e),h(Or.$$.fragment,e),h(Kr.$$.fragment,e),h(Ts.$$.fragment,e),h(eo.$$.fragment,e),h(to.$$.fragment,e),h(vs.$$.fragment,e),h(Ms.$$.fragment,e),h(so.$$.fragment,e),h(no.$$.fragment,e),h(ws.$$.fragment,e),h(ro.$$.fragment,e),h(oo.$$.fragment,e),h(ks.$$.fragment,e),h(ao.$$.fragment,e),h(lo.$$.fragment,e),h($s.$$.fragment,e),h(co.$$.fragment,e),h(io.$$.fragment,e),h(js.$$.fragment,e),h(po.$$.fragment,e),h(mo.$$.fragment,e),h(xs.$$.fragment,e),h(uo.$$.fragment,e),h(go.$$.fragment,e),h(ho.$$.fragment,e),h(fo.$$.fragment,e),h(_o.$$.fragment,e),h(bo.$$.fragment,e),h(yo.$$.fragment,e),h(To.$$.fragment,e),h(vo.$$.fragment,e),h(Mo.$$.fragment,e),h(wo.$$.fragment,e),h(ko.$$.fragment,e),h($o.$$.fragment,e),h(jo.$$.fragment,e),h(xo.$$.fragment,e),h(Jo.$$.fragment,e),h(Uo.$$.fragment,e),h(Bo.$$.fragment,e),h(Io.$$.fragment,e),h(Zo.$$.fragment,e),h(zo.$$.fragment,e),h(Wo.$$.fragment,e),h(Vo.$$.fragment,e),h(Lo.$$.fragment,e),h(Co.$$.fragment,e),h(Fo.$$.fragment,e),h(Go.$$.fragment,e),h(Xo.$$.fragment,e),h(Ro.$$.fragment,e),h(Eo.$$.fragment,e),h(No.$$.fragment,e),h(So.$$.fragment,e),h(qo.$$.fragment,e),h(Ho.$$.fragment,e),h(Do.$$.fragment,e),h(Po.$$.fragment,e),h(Qo.$$.fragment,e),h(Yo.$$.fragment,e),h(Ao.$$.fragment,e),h(Oo.$$.fragment,e),h(Ko.$$.fragment,e),h(ea.$$.fragment,e),h(ta.$$.fragment,e),h(sa.$$.fragment,e),h(na.$$.fragment,e),h(ra.$$.fragment,e),h(oa.$$.fragment,e),h(aa.$$.fragment,e),h(la.$$.fragment,e),h(ca.$$.fragment,e),h(ia.$$.fragment,e),h(da.$$.fragment,e),h(pa.$$.fragment,e),h(ma.$$.fragment,e),h(ua.$$.fragment,e),h(ga.$$.fragment,e),h(ha.$$.fragment,e),h(fa.$$.fragment,e),h(_a.$$.fragment,e),h(ba.$$.fragment,e),h(Ta.$$.fragment,e),h(va.$$.fragment,e),h(Ma.$$.fragment,e),h(wa.$$.fragment,e),h(ka.$$.fragment,e),h($a.$$.fragment,e),h(ja.$$.fragment,e),h(xa.$$.fragment,e),h(Ja.$$.fragment,e),h(Ba.$$.fragment,e),h(Zs.$$.fragment,e),h(Ia.$$.fragment,e),h(Za.$$.fragment,e),h(za.$$.fragment,e),h(Wa.$$.fragment,e),h(Va.$$.fragment,e),h(La.$$.fragment,e),h(Ca.$$.fragment,e),h(Fa.$$.fragment,e),h(Ga.$$.fragment,e),h(Xa.$$.fragment,e),h(Ra.$$.fragment,e),h(Ea.$$.fragment,e),h(Na.$$.fragment,e),h(Sa.$$.fragment,e),h(qa.$$.fragment,e),h(Ha.$$.fragment,e),h(Da.$$.fragment,e),h(Pa.$$.fragment,e),h(Qa.$$.fragment,e),h(Ya.$$.fragment,e),h(Aa.$$.fragment,e),h(Oa.$$.fragment,e),h(Ka.$$.fragment,e),h(el.$$.fragment,e),h(tl.$$.fragment,e),h(sl.$$.fragment,e),h(nl.$$.fragment,e),h(Xs.$$.fragment,e),h(Rs.$$.fragment,e),h(rl.$$.fragment,e),h(ol.$$.fragment,e),h(al.$$.fragment,e),h(ll.$$.fragment,e),h(qs.$$.fragment,e),h(Hs.$$.fragment,e),h(cl.$$.fragment,e),h(il.$$.fragment,e),h(dl.$$.fragment,e),h(pl.$$.fragment,e),h(ml.$$.fragment,e),h(ul.$$.fragment,e),h(gl.$$.fragment,e),h(hl.$$.fragment,e),h(fl.$$.fragment,e),h(_l.$$.fragment,e),h(bl.$$.fragment,e),h(yl.$$.fragment,e),h(Tl.$$.fragment,e),h(vl.$$.fragment,e),Ng=!1},d(e){e&&(s($),s(b),s(_),s(o),s(k),s(jm),s(yn),s(xm),s(Jm),s(vn),s(Um),s(Mn),s(Bm),s(Im),s(kn),s(Zm),s($n),s(zm),s(jn),s(Wm),s(xn),s(Vm),s(Jn),s(Lm),s(Cm),s(Bn),s(Fm),s(In),s(Gm),s(Zn),s(Xm),s(Rm),s(xt),s(Em),s(Jt),s(Nm),s(Ut),s(Sm),s(Bt),s(qm),s(Hm),s(It),s(Dm),s(Zt),s(Pm),s(zt),s(Qm),s(Wt),s(Ym),s(Vt),s(Am),s(Lt),s(Om),s(Ct),s(Km),s(Ft),s(eu),s(Gt),s(tu),s(Xt),s(su),s(nu),s(je),s(ru),s(xe),s(ou),s(Je),s(au),s(lu),s(nr),s(cu),s(iu),s(ee),s(du),s(W),s(pu),s(X),s(mu),s(R),s(uu),s(te),s(gu),s(se),s(hu),s(ne),s(fu),s(re),s(_u),s(oe),s(bu),s(ae),s(yu),s(V),s(Tu),s(le),s(vu),s(ce),s(Mu),s(Ue),s(wu),s(Be),s(ku),s(Ie),s($u),s(ie),s(ju),s(de),s(xu),s(E),s(Ju),s(N),s(Uu),s(pe),s(Bu),s(S),s(Iu),s(q),s(Zu),s(me),s(zu),s(ue),s(Wu),s(H),s(Vu),s(ge),s(Lu),s(he),s(Cu),s(D),s(Fu),s(P),s(Gu),s(Q),s(Xu),s(Ru),s(Ze),s(Eu),s(ze),s(Nu),s(We),s(Su),s(Ve),s(qu),s(Le),s(Hu),s(Ce),s(Du),s(Fe),s(Pu),s(Ge),s(Qu),s(Xe),s(Yu),s(Re),s(Au),s(Ee),s(Ou),s(Ne),s(Ku),s(Se),s(eg),s(qe),s(tg),s(He),s(sg),s(ng),s(De),s(rg),s(Pe),s(og),s(Qe),s(ag),s(Ye),s(lg),s(Ae),s(cg),s(Oe),s(ig),s(Ke),s(dg),s(et),s(pg),s(tt),s(mg),s(st),s(ug),s(nt),s(gg),s(rt),s(hg),s(ot),s(fg),s(_g),s(ya),s(bg),s(fe),s(yg),s(Rt),s(Tg),s(at),s(vg),s(lt),s(Mg),s(wg),s(Ua),s(kg),s(U),s($g),s(Et),s(jg),s(Nt),s(xg),s(_e),s(Jg),s(Ug),s(be),s(Bg),s(L),s(Ig),s(ye),s(Zg),s(zg),s(ct),s(Wg),s(it),s(Vg),s(Lg),s(z),s(Cg),s(Y),s(Fg),s(Gg),s(dt),s(Xg),s(Z),s(Rg),s(C),s(Eg),s(_m)),s(i),f(w,e),f(Tn,e),f(wn,e),f(Un,e),f(zn,e),f(Wn),f(Vn),f(Ln),f(Cn),f(Fn,e),f(Gn),f(Xn),f(Rn),f(En),f(Nn),f(Sn),f(qn),f(Hn),f(Dn),f(Pn),f(Qn,e),f(Yn),f(An),f(On),f(Kn),f(er),f(tr),f(sr,e),f(rr,e),f(or),f(Yt),f(ar),f(lr),f(At),f(Ot),f(cr),f(ir),f(Kt),f(dr),f(pr),f(es),f(mr),f(ur),f(ts),f(gr),f(hr),f(ss),f(fr),f(_r),f(ns),f(br),f(yr),f(rs),f(Tr),f(vr),f(os),f(Mr),f(wr),f(as),f(kr),f($r),f(ls),f(jr),f(xr),f(Jr),f(Ur),f(cs),f(Br),f(Ir),f(Zr),f(zr),f(Wr),f(Vr),f(Lr),f(Cr),f(is),f(Fr),f(Gr),f(ds),f(Xr),f(Rr),f(ps),f(ms),f(Er),f(Nr),f(us),f(gs),f(Sr),f(qr),f(hs),f(Hr),f(Dr),f(fs),f(Pr),f(Qr),f(_s),f(bs),f(Yr),f(Ar),f(ys),f(Or),f(Kr),f(Ts),f(eo),f(to),f(vs),f(Ms),f(so),f(no),f(ws),f(ro),f(oo),f(ks),f(ao),f(lo),f($s),f(co),f(io),f(js),f(po),f(mo),f(xs),f(uo),f(go,e),f(ho),f(fo),f(_o),f(bo),f(yo),f(To),f(vo),f(Mo),f(wo),f(ko),f($o),f(jo),f(xo),f(Jo),f(Uo),f(Bo),f(Io),f(Zo),f(zo),f(Wo),f(Vo),f(Lo),f(Co),f(Fo),f(Go),f(Xo),f(Ro),f(Eo),f(No),f(So),f(qo,e),f(Ho),f(Do),f(Po),f(Qo),f(Yo),f(Ao),f(Oo),f(Ko),f(ea),f(ta),f(sa),f(na),f(ra),f(oa),f(aa),f(la),f(ca),f(ia),f(da),f(pa),f(ma),f(ua),f(ga),f(ha),f(fa),f(_a),f(ba,e),f(Ta),f(va),f(Ma),f(wa),f(ka),f($a),f(ja),f(xa),f(Ja,e),f(Ba),f(Zs),f(Ia),f(Za),f(za),f(Wa),f(Va),f(La),f(Ca),f(Fa),f(Ga),f(Xa),f(Ra),f(Ea),f(Na,e),f(Sa),f(qa),f(Ha),f(Da),f(Pa),f(Qa),f(Ya),f(Aa),f(Oa),f(Ka,e),f(el),f(tl),f(sl,e),f(nl),f(Xs),f(Rs),f(rl),f(ol),f(al),f(ll),f(qs),f(Hs),f(cl),f(il,e),f(dl),f(pl),f(ml),f(ul),f(gl),f(hl),f(fl),f(_l),f(bl),f(yl),f(Tl),f(vl)}}}const fk='{"title":"Utilities for Generation","local":"utilities-for-generation","sections":[{"title":"Generate Outputs","local":"generate-outputs","sections":[{"title":"PyTorch","local":"transformers.generation.GenerateDecoderOnlyOutput","sections":[],"depth":3},{"title":"TensorFlow","local":"transformers.generation.TFGreedySearchEncoderDecoderOutput","sections":[],"depth":3},{"title":"FLAX","local":"transformers.generation.FlaxSampleOutput","sections":[],"depth":3}],"depth":2},{"title":"LogitsProcessor","local":"logitsprocessor","sections":[{"title":"PyTorch","local":"transformers.AlternatingCodebooksLogitsProcessor","sections":[],"depth":3},{"title":"TensorFlow","local":"transformers.TFForcedBOSTokenLogitsProcessor","sections":[],"depth":3},{"title":"FLAX","local":"transformers.FlaxForcedBOSTokenLogitsProcessor","sections":[],"depth":3}],"depth":2},{"title":"StoppingCriteria","local":"transformers.StoppingCriteria","sections":[],"depth":2},{"title":"Constraints","local":"transformers.Constraint","sections":[],"depth":2},{"title":"BeamSearch","local":"transformers.BeamScorer","sections":[],"depth":2},{"title":"Utilities","local":"transformers.top_k_top_p_filtering","sections":[],"depth":2},{"title":"Streamers","local":"transformers.TextStreamer","sections":[],"depth":2},{"title":"Caches","local":"transformers.Cache","sections":[],"depth":2}],"depth":1}';function _k(j){return Jw(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $k extends Uw{constructor(i){super(),Bw(this,i,_k,hk,xw,{})}}export{$k as component};
