import{s as lt,o as rt,n as Fe}from"../chunks/scheduler.6062bdaf.js";import{S as it,i as dt,g as i,s as n,r as m,A as ct,h as d,f as t,c as o,j as x,u as g,x as M,k as J,y as a,a as p,v as u,d as f,t as _,w as b}from"../chunks/index.4bca734e.js";import{T as st}from"../chunks/Tip.b9ac1f03.js";import{D as k}from"../chunks/Docstring.ed07512f.js";import{C as Ea}from"../chunks/CodeBlock.fa01571c.js";import{E as Za}from"../chunks/ExampleCodeBlock.823fb173.js";import{H as Ge}from"../chunks/Heading.723dceba.js";function pt($){let s,j="Example:",c,h,v;return h=new Ea({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelHubMixin

<span class="hljs-comment"># Inherit from ModelHubMixin</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">MyCustomModel</span>(
<span class="hljs-meta">... </span>        ModelHubMixin,
<span class="hljs-meta">... </span>        library_name=<span class="hljs-string">&quot;my-library&quot;</span>,
<span class="hljs-meta">... </span>        tags=[<span class="hljs-string">&quot;x-custom-tag&quot;</span>],
<span class="hljs-meta">... </span>        repo_url=<span class="hljs-string">&quot;https://github.com/huggingface/my-cool-library&quot;</span>,
<span class="hljs-meta">... </span>        docs_url=<span class="hljs-string">&quot;https://huggingface.co/docs/my-cool-library&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-comment"># ^ optional metadata to generate model card</span>
<span class="hljs-meta">... </span>    ):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, size: <span class="hljs-built_in">int</span> = <span class="hljs-number">512</span>, device: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;cpu&quot;</span></span>):
<span class="hljs-meta">... </span>        <span class="hljs-comment"># define how to initialize your model</span>
<span class="hljs-meta">... </span>        <span class="hljs-built_in">super</span>().__init__()
<span class="hljs-meta">... </span>        ...
...
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_save_pretrained</span>(<span class="hljs-params">self, save_directory: Path</span>) -&gt; <span class="hljs-literal">None</span>:
<span class="hljs-meta">... </span>        <span class="hljs-comment"># define how to serialize your model</span>
<span class="hljs-meta">... </span>        ...
...
<span class="hljs-meta">... </span>    @<span class="hljs-built_in">classmethod</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">from_pretrained</span>(<span class="hljs-params">
<span class="hljs-meta">... </span>        cls: <span class="hljs-type">Type</span>[T],
<span class="hljs-meta">... </span>        pretrained_model_name_or_path: <span class="hljs-type">Union</span>[<span class="hljs-built_in">str</span>, Path],
<span class="hljs-meta">... </span>        *,
<span class="hljs-meta">... </span>        force_download: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>        resume_download: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>        proxies: <span class="hljs-type">Optional</span>[<span class="hljs-type">Dict</span>] = <span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>        token: <span class="hljs-type">Optional</span>[<span class="hljs-type">Union</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">bool</span>]] = <span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>        cache_dir: <span class="hljs-type">Optional</span>[<span class="hljs-type">Union</span>[<span class="hljs-built_in">str</span>, Path]] = <span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>        local_files_only: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>        revision: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>] = <span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>        **model_kwargs,
<span class="hljs-meta">... </span>    </span>) -&gt; T:
<span class="hljs-meta">... </span>        <span class="hljs-comment"># define how to deserialize your model</span>
<span class="hljs-meta">... </span>        ...

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyCustomModel(size=<span class="hljs-number">256</span>, device=<span class="hljs-string">&quot;gpu&quot;</span>)

<span class="hljs-comment"># Save model weights to local directory</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># Push model weights to the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># Download and initialize weights from the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>reloaded_model = MyCustomModel.from_pretrained(<span class="hljs-string">&quot;username/my-awesome-model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>reloaded_model.size
<span class="hljs-number">256</span>

<span class="hljs-comment"># Model card has been correctly populated</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelCard
<span class="hljs-meta">&gt;&gt;&gt; </span>card = ModelCard.load(<span class="hljs-string">&quot;username/my-awesome-model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>card.data.tags
[<span class="hljs-string">&quot;x-custom-tag&quot;</span>, <span class="hljs-string">&quot;pytorch_model_hub_mixin&quot;</span>, <span class="hljs-string">&quot;model_hub_mixin&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>card.data.library_name
<span class="hljs-string">&quot;my-library&quot;</span>`,wrap:!1}}),{c(){s=i("p"),s.textContent=j,c=n(),m(h.$$.fragment)},l(r){s=d(r,"P",{"data-svelte-h":!0}),M(s)!=="svelte-11lpom8"&&(s.textContent=j),c=o(r),g(h.$$.fragment,r)},m(r,T){p(r,s,T),p(r,c,T),u(h,r,T),v=!0},p:Fe,i(r){v||(f(h.$$.fragment,r),v=!0)},o(r){_(h.$$.fragment,r),v=!1},d(r){r&&(t(s),t(c)),b(h,r)}}}function ht($){let s,j="Example:",c,h,v;return h=new Ea({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwUHlUb3JjaE1vZGVsSHViTWl4aW4lMEElMEFjbGFzcyUyME15TW9kZWwoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm4uTW9kdWxlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwUHlUb3JjaE1vZGVsSHViTWl4aW4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsaWJyYXJ5X25hbWUlM0QlMjJrZXJhcy1ubHAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX3VybCUzRCUyMmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmtlcmFzLXRlYW0lMkZrZXJhcy1ubHAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkb2NzX3VybCUzRCUyMmh0dHBzJTNBJTJGJTJGa2VyYXMuaW8lMkZrZXJhc19ubHAlMkYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjAlNUUlMjBvcHRpb25hbCUyMG1ldGFkYXRhJTIwdG8lMjBnZW5lcmF0ZSUyMG1vZGVsJTIwY2FyZCUwQSUyMCUyMCUyMCUyMCklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwaGlkZGVuX3NpemUlM0ElMjBpbnQlMjAlM0QlMjA1MTIlMkMlMjB2b2NhYl9zaXplJTNBJTIwaW50JTIwJTNEJTIwMzAwMDAlMkMlMjBvdXRwdXRfc2l6ZSUzQSUyMGludCUyMCUzRCUyMDQpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5wYXJhbSUyMCUzRCUyMG5uLlBhcmFtZXRlcih0b3JjaC5yYW5kKGhpZGRlbl9zaXplJTJDJTIwdm9jYWJfc2l6ZSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5saW5lYXIlMjAlM0QlMjBubi5MaW5lYXIob3V0cHV0X3NpemUlMkMlMjB2b2NhYl9zaXplKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2VsZi5saW5lYXIoeCUyMCUyQiUyMHNlbGYucGFyYW0pJTBBbW9kZWwlMjAlM0QlMjBNeU1vZGVsKGhpZGRlbl9zaXplJTNEMjU2KSUwQSUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJteS1hd2Vzb21lLW1vZGVsJTIyKSUwQSUwQW1vZGVsLnB1c2hfdG9faHViKCUyMm15LWF3ZXNvbWUtbW9kZWwlMjIpJTBBJTBBbW9kZWwlMjAlM0QlMjBNeU1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJ1c2VybmFtZSUyRm15LWF3ZXNvbWUtbW9kZWwlMjIpJTBBbW9kZWwuaGlkZGVuX3NpemU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> PyTorchModelHubMixin

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModel</span>(
<span class="hljs-meta">... </span>        nn.Module,
<span class="hljs-meta">... </span>        PyTorchModelHubMixin,
<span class="hljs-meta">... </span>        library_name=<span class="hljs-string">&quot;keras-nlp&quot;</span>,
<span class="hljs-meta">... </span>        repo_url=<span class="hljs-string">&quot;https://github.com/keras-team/keras-nlp&quot;</span>,
<span class="hljs-meta">... </span>        docs_url=<span class="hljs-string">&quot;https://keras.io/keras_nlp/&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-comment"># ^ optional metadata to generate model card</span>
<span class="hljs-meta">... </span>    ):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, hidden_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">512</span>, vocab_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">30000</span>, output_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">4</span></span>):
<span class="hljs-meta">... </span>        <span class="hljs-built_in">super</span>().__init__()
<span class="hljs-meta">... </span>        self.param = nn.Parameter(torch.rand(hidden_size, vocab_size))
<span class="hljs-meta">... </span>        self.linear = nn.Linear(output_size, vocab_size)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> self.linear(x + self.param)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel(hidden_size=<span class="hljs-number">256</span>)

<span class="hljs-comment"># Save model weights to local directory</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># Push model weights to the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># Download and initialize weights from the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel.from_pretrained(<span class="hljs-string">&quot;username/my-awesome-model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.hidden_size
<span class="hljs-number">256</span>`,wrap:!1}}),{c(){s=i("p"),s.textContent=j,c=n(),m(h.$$.fragment)},l(r){s=d(r,"P",{"data-svelte-h":!0}),M(s)!=="svelte-11lpom8"&&(s.textContent=j),c=o(r),g(h.$$.fragment,r)},m(r,T){p(r,s,T),p(r,c,T),u(h,r,T),v=!0},p:Fe,i(r){v||(f(h.$$.fragment,r),v=!0)},o(r){_(h.$$.fragment,r),v=!1},d(r){r&&(t(s),t(c)),b(h,r)}}}function mt($){let s,j;return s=new Ea({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwS2VyYXNNb2RlbEh1Yk1peGluJTBBJTBBJTBBY2xhc3MlMjBNeU1vZGVsKHRmLmtlcmFzLk1vZGVsJTJDJTIwS2VyYXNNb2RlbEh1Yk1peGluKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmNvbmZpZyUyMCUzRCUyMGt3YXJncy5wb3AoJTIyY29uZmlnJTIyJTJDJTIwTm9uZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmR1bW15X2lucHV0cyUyMCUzRCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubGF5ZXIlMjAlM0QlMjAuLi4lMEElMEElMjAlMjAlMjAlMjBkZWYlMjBjYWxsKHNlbGYlMkMlMjAqYXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAuLi4lMEElMEElMEElMjMlMjBJbml0aWFsaXplJTIwYW5kJTIwY29tcGlsZSUyMHRoZSUyMG1vZGVsJTIwYXMlMjB5b3UlMjBub3JtYWxseSUyMHdvdWxkJTBBbW9kZWwlMjAlM0QlMjBNeU1vZGVsKCklMEFtb2RlbC5jb21waWxlKC4uLiklMEElMjMlMjBCdWlsZCUyMHRoZSUyMGdyYXBoJTIwYnklMjB0cmFpbmluZyUyMGl0JTIwb3IlMjBwYXNzaW5nJTIwZHVtbXklMjBpbnB1dHMlMEFfJTIwJTNEJTIwbW9kZWwobW9kZWwuZHVtbXlfaW5wdXRzKSUwQSUyMyUyMFNhdmUlMjBtb2RlbCUyMHdlaWdodHMlMjB0byUyMGxvY2FsJTIwZGlyZWN0b3J5JTBBbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMm15LWF3ZXNvbWUtbW9kZWwlMjIpJTBBJTIzJTIwUHVzaCUyMG1vZGVsJTIwd2VpZ2h0cyUyMHRvJTIwdGhlJTIwSHViJTBBbW9kZWwucHVzaF90b19odWIoJTIybXktYXdlc29tZS1tb2RlbCUyMiklMEElMjMlMjBEb3dubG9hZCUyMGFuZCUyMGluaXRpYWxpemUlMjB3ZWlnaHRzJTIwZnJvbSUyMHRoZSUyMEh1YiUwQW1vZGVsJTIwJTNEJTIwTXlNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIydXNlcm5hbWUlMkZzdXBlci1jb29sLW1vZGVsJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> KerasModelHubMixin


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModel</span>(tf.keras.Model, KerasModelHubMixin):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, **kwargs</span>):
<span class="hljs-meta">... </span>        <span class="hljs-built_in">super</span>().__init__()
<span class="hljs-meta">... </span>        self.config = kwargs.pop(<span class="hljs-string">&quot;config&quot;</span>, <span class="hljs-literal">None</span>)
<span class="hljs-meta">... </span>        self.dummy_inputs = ...
<span class="hljs-meta">... </span>        self.layer = ...

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">call</span>(<span class="hljs-params">self, *args</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> ...


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initialize and compile the model as you normally would</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel()
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">compile</span>(...)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Build the graph by training it or passing dummy inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>_ = model(model.dummy_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Save model weights to local directory</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Push model weights to the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download and initialize weights from the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel.from_pretrained(<span class="hljs-string">&quot;username/super-cool-model&quot;</span>)`,wrap:!1}}),{c(){m(s.$$.fragment)},l(c){g(s.$$.fragment,c)},m(c,h){u(s,c,h),j=!0},p:Fe,i(c){j||(f(s.$$.fragment,c),j=!0)},o(c){_(s.$$.fragment,c),j=!1},d(c){b(s,c)}}}function gt($){let s,j=`Passing <code>token=True</code> is required when you want to use a private
model.`;return{c(){s=i("p"),s.innerHTML=j},l(c){s=d(c,"P",{"data-svelte-h":!0}),M(s)!=="svelte-1j5fb81"&&(s.innerHTML=j)},m(c,h){p(c,s,h)},p:Fe,d(c){c&&t(s)}}}function ut($){let s,j="Raises the following error:",c,h,v=`<li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><em>ValueError</em></a>
if the user is not log on to the Hugging Face Hub.</li>`;return{c(){s=i("p"),s.textContent=j,c=n(),h=i("ul"),h.innerHTML=v},l(r){s=d(r,"P",{"data-svelte-h":!0}),M(s)!=="svelte-1f6kjc7"&&(s.textContent=j),c=o(r),h=d(r,"UL",{"data-svelte-h":!0}),M(h)!=="svelte-qftit0"&&(h.innerHTML=v)},m(r,T){p(r,s,T),p(r,c,T),p(r,h,T)},p:Fe,d(r){r&&(t(s),t(c),t(h))}}}function ft($){let s,j,c,h,v,r,T,Ve,Q,Na=`The <code>huggingface_hub</code> library offers a range of mixins that can be used as a parent class for your objects, in order to
provide simple uploading and downloading functions. Check out our <a href="../guides/integrations">integration guide</a> to learn
how to integrate any ML framework with the Hub.`,Le,q,Se,w,D,la,ue,Ga="A generic mixin to integrate ANY machine learning framework with the Hub.",ra,fe,za=`To integrate your framework, your model class must inherit from this class. Custom logic for saving/loading models
have to be overwritten in  <code>_from_pretrained</code> and <code>_save_pretrained</code>. <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.PyTorchModelHubMixin">PyTorchModelHubMixin</a> is a good example
of mixin integration with the Hub. Check out our <a href="../guides/integrations">integration guide</a> for more instructions.`,ia,_e,Fa=`When inheriting from <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>, you can define class-level attributes. These attributes are not passed to
<code>__init__</code> but to the class definition itself. This is useful to define metadata about the library integrating
<a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>.`,da,z,ca,F,K,pa,be,Va=`Overwrite this method in subclass to define how to save your model.
Check out our <a href="../guides/integrations">integration guide</a> for instructions.`,ha,I,O,ma,Me,La="Overwrite this method in subclass to define how to load your model from pretrained.",ga,we,Sa=`Use <a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a> or <a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a> to download files from the Hub before loading them. Most
args taken as input can be directly passed to those 2 methods. If needed, you can add more arguments to this
method using “model_kwargs”. For example <code>PyTorchModelHubMixin._from_pretrained()</code> takes as input a <code>map_location</code>
parameter to set on which device the model should be loaded.`,ua,ye,Xa='Check out our <a href="../guides/integrations">integration guide</a> for more instructions.',fa,V,ee,_a,je,Ya="Download a model from the Huggingface Hub and instantiate it.",ba,Z,ae,Ma,ve,Ra="Upload model checkpoint to the Hub.",wa,Te,Pa=`Use <code>allow_patterns</code> and <code>ignore_patterns</code> to precisely filter which files should be pushed to the hub. Use
<code>delete_patterns</code> to delete existing remote files in the same commit. See <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> reference for more
details.`,ya,L,te,ja,xe,Qa="Save weights in local directory.",Xe,ne,Ye,H,oe,va,Je,qa=`Implementation of <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> to provide model Hub upload/download capabilities to PyTorch models. The model
is set in evaluation mode by default using <code>model.eval()</code> (dropout modules are deactivated). To train the model,
you should first set it back in training mode with <code>model.train()</code>.`,Ta,S,Re,se,Pe,C,le,xa,Ue,Da=`Implementation of <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> to provide model Hub upload/download
capabilities to Keras models.`,Ja,X,Qe,A,re,Ua,ke,Ka=`Instantiate a pretrained Keras model from a pre-trained model from the Hub.
The model is expected to be in <code>SavedModel</code> format.`,ka,Y,qe,W,ie,$a,$e,Oa="Upload model checkpoint to the Hub.",Ia,Ie,et=`Use <code>allow_patterns</code> and <code>ignore_patterns</code> to precisely filter which files should be pushed to the hub. Use
<code>delete_patterns</code> to delete existing remote files in the same commit. See <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> reference for more
details.`,De,E,de,Ha,He,at=`Saves a Keras model to save_directory in SavedModel format. Use this if
you’re using the Functional or Sequential APIs.`,Ke,ce,Oe,N,pe,Ca,Ce,tt="Load pretrained fastai model from the Hub or from a local directory.",ea,U,he,Aa,Ae,nt="Upload learner checkpoint files to the Hub.",Wa,We,ot=`Use <em>allow_patterns</em> and <em>ignore_patterns</em> to precisely filter which files should be pushed to the hub. Use
<em>delete_patterns</em> to delete existing remote files in the same commit. See [<em>upload_folder</em>] reference for more
details.`,Ba,R,aa,ze,ta;return v=new Ge({props:{title:"Mixins & serialization methods",local:"mixins--serialization-methods",headingTag:"h1"}}),T=new Ge({props:{title:"Mixins",local:"mixins",headingTag:"h2"}}),q=new Ge({props:{title:"Generic",local:"huggingface_hub.ModelHubMixin",headingTag:"h3"}}),D=new k({props:{name:"class huggingface_hub.ModelHubMixin",anchor:"huggingface_hub.ModelHubMixin",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.ModelHubMixin.library_name",description:`<strong>library_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of the library integrating ModelHubMixin. Used to generate model card.`,name:"library_name"},{anchor:"huggingface_hub.ModelHubMixin.tags",description:`<strong>tags</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Tags to be added to the model card. Used to generate model card.`,name:"tags"},{anchor:"huggingface_hub.ModelHubMixin.repo_url",description:`<strong>repo_url</strong> (<code>str</code>, <em>optional</em>) &#x2014;
URL of the library repository. Used to generate model card.`,name:"repo_url"},{anchor:"huggingface_hub.ModelHubMixin.docs_url",description:`<strong>docs_url</strong> (<code>str</code>, <em>optional</em>) &#x2014;
URL of the library documentation. Used to generate model card.`,name:"docs_url"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py#L61"}}),z=new Za({props:{anchor:"huggingface_hub.ModelHubMixin.example",$$slots:{default:[pt]},$$scope:{ctx:$}}}),K=new k({props:{name:"_save_pretrained",anchor:"huggingface_hub.ModelHubMixin._save_pretrained",parameters:[{name:"save_directory",val:": Path"}],parametersDescription:[{anchor:"huggingface_hub.ModelHubMixin._save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>Path</code>) &#x2014;
Path to directory in which the model weights and configuration will be saved.`,name:"save_directory"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py#L298"}}),O=new k({props:{name:"_from_pretrained",anchor:"huggingface_hub.ModelHubMixin._from_pretrained",parameters:[{name:"model_id",val:": str"},{name:"revision",val:": Optional"},{name:"cache_dir",val:": Union"},{name:"force_download",val:": bool"},{name:"proxies",val:": Optional"},{name:"resume_download",val:": bool"},{name:"local_files_only",val:": bool"},{name:"token",val:": Union"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.ModelHubMixin._from_pretrained.model_id",description:`<strong>model_id</strong> (<code>str</code>) &#x2014;
ID of the model to load from the Huggingface Hub (e.g. <code>bigscience/bloom</code>).`,name:"model_id"},{anchor:"huggingface_hub.ModelHubMixin._from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Revision of the model on the Hub. Can be a branch name, a git tag or any commit id. Defaults to the
latest commit on <code>main</code> branch.`,name:"revision"},{anchor:"huggingface_hub.ModelHubMixin._from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to force (re-)downloading the model weights and configuration files from the Hub, overriding
the existing cache.`,name:"force_download"},{anchor:"huggingface_hub.ModelHubMixin._from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to delete incompletely received files. Will attempt to resume the download if such a file exists.`,name:"resume_download"},{anchor:"huggingface_hub.ModelHubMixin._from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint (e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>).`,name:"proxies"},{anchor:"huggingface_hub.ModelHubMixin._from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. By default, it will use the token
cached when running <code>huggingface-cli login</code>.`,name:"token"},{anchor:"huggingface_hub.ModelHubMixin._from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code>, <code>Path</code>, <em>optional</em>) &#x2014;
Path to the folder where cached files are stored.`,name:"cache_dir"},{anchor:"huggingface_hub.ModelHubMixin._from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, avoid downloading the file and return the path to the local cached file if it exists.
model_kwargs &#x2014;
Additional keyword arguments passed along to the <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin._from_pretrained">_from_pretrained()</a> method.`,name:"local_files_only"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py#L438"}}),ee=new k({props:{name:"from_pretrained",anchor:"huggingface_hub.ModelHubMixin.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"force_download",val:": bool = False"},{name:"resume_download",val:": bool = False"},{name:"proxies",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"cache_dir",val:": Union = None"},{name:"local_files_only",val:": bool = False"},{name:"revision",val:": Optional = None"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code>, <code>Path</code>) &#x2014;<ul>
<li>Either the <code>model_id</code> (string) of a model hosted on the Hub, e.g. <code>bigscience/bloom</code>.</li>
<li>Or a path to a <code>directory</code> containing model weights saved using
<a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained" rel="nofollow">save_pretrained</a>, e.g., <code>../path/to/my_model_directory/</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Revision of the model on the Hub. Can be a branch name, a git tag or any commit id.
Defaults to the latest commit on <code>main</code> branch.`,name:"revision"},{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to force (re-)downloading the model weights and configuration files from the Hub, overriding
the existing cache.`,name:"force_download"},{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to delete incompletely received files. Will attempt to resume the download if such a file exists.`,name:"resume_download"},{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on every request.`,name:"proxies"},{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. By default, it will use the token
cached when running <code>huggingface-cli login</code>.`,name:"token"},{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code>, <code>Path</code>, <em>optional</em>) &#x2014;
Path to the folder where cached files are stored.`,name:"cache_dir"},{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, avoid downloading the file and return the path to the local cached file if it exists.`,name:"local_files_only"},{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.model_kwargs",description:`<strong>model_kwargs</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Additional kwargs to pass to the model during initialization.`,name:"model_kwargs"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py#L309"}}),ae=new k({props:{name:"push_to_hub",anchor:"huggingface_hub.ModelHubMixin.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"config",val:": Union = None"},{name:"commit_message",val:": str = 'Push model using huggingface_hub.'"},{name:"private",val:": bool = False"},{name:"token",val:": Optional = None"},{name:"branch",val:": Optional = None"},{name:"create_pr",val:": Optional = None"},{name:"allow_patterns",val:": Union = None"},{name:"ignore_patterns",val:": Union = None"},{name:"delete_patterns",val:": Union = None"}],parametersDescription:[{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repository to push to (example: <code>&quot;username/my-model&quot;</code>).`,name:"repo_id"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.config",description:`<strong>config</strong> (<code>dict</code> or <code>DataclassInstance</code>, <em>optional</em>) &#x2014;
Model configuration specified as a key/value dictionary or a dataclass instance.`,name:"config"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing.`,name:"commit_message"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the repository created should be private.`,name:"private"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. By default, it will use the token
cached when running <code>huggingface-cli login</code>.`,name:"token"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.branch",description:`<strong>branch</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git branch on which to push the model. This defaults to <code>&quot;main&quot;</code>.`,name:"branch"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request from <code>branch</code> with that commit. Defaults to <code>False</code>.`,name:"create_pr"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.allow_patterns",description:`<strong>allow_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, only files matching at least one pattern are pushed.`,name:"allow_patterns"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.ignore_patterns",description:`<strong>ignore_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, files matching any of the patterns are not pushed.`,name:"ignore_patterns"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.delete_patterns",description:`<strong>delete_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, remote files matching any of the patterns will be deleted from the repo.`,name:"delete_patterns"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py#L487",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The url of the commit of your model in the given repository.</p>
`}}),te=new k({props:{name:"save_pretrained",anchor:"huggingface_hub.ModelHubMixin.save_pretrained",parameters:[{name:"save_directory",val:": Union"},{name:"config",val:": Union = None"},{name:"repo_id",val:": Optional = None"},{name:"push_to_hub",val:": bool = False"},{name:"**push_to_hub_kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.ModelHubMixin.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>Path</code>) &#x2014;
Path to directory in which the model weights and configuration will be saved.`,name:"save_directory"},{anchor:"huggingface_hub.ModelHubMixin.save_pretrained.config",description:`<strong>config</strong> (<code>dict</code> or <code>DataclassInstance</code>, <em>optional</em>) &#x2014;
Model configuration specified as a key/value dictionary or a dataclass instance.`,name:"config"},{anchor:"huggingface_hub.ModelHubMixin.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Huggingface Hub after saving it.`,name:"push_to_hub"},{anchor:"huggingface_hub.ModelHubMixin.save_pretrained.repo_id",description:`<strong>repo_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
ID of your repository on the Hub. Used only if <code>push_to_hub=True</code>. Will default to the folder name if
not provided.
kwargs &#x2014;
Additional key word arguments passed along to the <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"repo_id"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py#L236"}}),ne=new Ge({props:{title:"PyTorch",local:"huggingface_hub.PyTorchModelHubMixin",headingTag:"h3"}}),oe=new k({props:{name:"class huggingface_hub.PyTorchModelHubMixin",anchor:"huggingface_hub.PyTorchModelHubMixin",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py#L562"}}),S=new Za({props:{anchor:"huggingface_hub.PyTorchModelHubMixin.example",$$slots:{default:[ht]},$$scope:{ctx:$}}}),se=new Ge({props:{title:"Keras",local:"huggingface_hub.KerasModelHubMixin",headingTag:"h3"}}),le=new k({props:{name:"class huggingface_hub.KerasModelHubMixin",anchor:"huggingface_hub.KerasModelHubMixin",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/keras_mixin.py#L422"}}),X=new Za({props:{anchor:"huggingface_hub.KerasModelHubMixin.example",$$slots:{default:[mt]},$$scope:{ctx:$}}}),re=new k({props:{name:"huggingface_hub.from_pretrained_keras",anchor:"huggingface_hub.from_pretrained_keras",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.from_pretrained_keras.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:<ul>
<li>A string, the <code>model id</code> of a pretrained model hosted inside a
model repo on huggingface.co. Valid model ids can be located
at the root-level, like <code>bert-base-uncased</code>, or namespaced
under a user or organization name, like
<code>dbmdz/bert-base-german-cased</code>.</li>
<li>You can add <code>revision</code> by appending <code>@</code> at the end of model_id
simply like this: <code>dbmdz/bert-base-german-cased@main</code> Revision
is the specific model version to use. It can be a branch name,
a tag name, or a commit id, since we use a git-based system
for storing models and other artifacts on huggingface.co, so
<code>revision</code> can be any identifier allowed by git.</li>
<li>A path to a <code>directory</code> containing model weights saved using
<a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained" rel="nofollow">save_pretrained</a>, e.g.,
<code>./my_model_directory/</code>.</li>
<li><code>None</code> if you are both providing the configuration and state
dictionary (resp. with keyword arguments <code>config</code> and
<code>state_dict</code>).</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"huggingface_hub.from_pretrained_keras.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to force the (re-)download of the model weights and
configuration files, overriding the cached versions if they exist.`,name:"force_download"},{anchor:"huggingface_hub.from_pretrained_keras.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to delete incompletely received files. Will attempt to
resume the download if such a file exists.`,name:"resume_download"},{anchor:"huggingface_hub.from_pretrained_keras.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g.,
<code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The
proxies are used on each request.`,name:"proxies"},{anchor:"huggingface_hub.from_pretrained_keras.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If
<code>True</code>, will use the token generated when running <code>transformers-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"huggingface_hub.from_pretrained_keras.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model
configuration should be cached if the standard cache should not be
used.`,name:"cache_dir"},{anchor:"huggingface_hub.from_pretrained_keras.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only look at local files (i.e., do not try to download
the model).`,name:"local_files_only(bool,"},{anchor:"huggingface_hub.from_pretrained_keras.model_kwargs",description:`<strong>model_kwargs</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
model_kwargs will be passed to the model during initialization`,name:"model_kwargs"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/keras_mixin.py#L240"}}),Y=new st({props:{$$slots:{default:[gt]},$$scope:{ctx:$}}}),ie=new k({props:{name:"huggingface_hub.push_to_hub_keras",anchor:"huggingface_hub.push_to_hub_keras",parameters:[{name:"model",val:""},{name:"repo_id",val:": str"},{name:"config",val:": Optional = None"},{name:"commit_message",val:": str = 'Push Keras model using huggingface_hub.'"},{name:"private",val:": bool = False"},{name:"api_endpoint",val:": Optional = None"},{name:"token",val:": Optional = None"},{name:"branch",val:": Optional = None"},{name:"create_pr",val:": Optional = None"},{name:"allow_patterns",val:": Union = None"},{name:"ignore_patterns",val:": Union = None"},{name:"delete_patterns",val:": Union = None"},{name:"log_dir",val:": Optional = None"},{name:"include_optimizer",val:": bool = False"},{name:"tags",val:": Union = None"},{name:"plot_model",val:": bool = True"},{name:"**model_save_kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.push_to_hub_keras.model",description:`<strong>model</strong> (<code>Keras.Model</code>) &#x2014;
The <a href="%60https://www.tensorflow.org/api_docs/python/tf/keras/Model%60">Keras model</a> you&#x2019;d like to push to the
Hub. The model must be compiled and built.`,name:"model"},{anchor:"huggingface_hub.push_to_hub_keras.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repository to push to (example: <code>&quot;username/my-model&quot;</code>).`,name:"repo_id"},{anchor:"huggingface_hub.push_to_hub_keras.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201C;Add Keras model&#x201D;) &#x2014;
Message to commit while pushing.`,name:"commit_message"},{anchor:"huggingface_hub.push_to_hub_keras.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the repository created should be private.`,name:"private"},{anchor:"huggingface_hub.push_to_hub_keras.api_endpoint",description:`<strong>api_endpoint</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The API endpoint to use when pushing the model to the hub.`,name:"api_endpoint"},{anchor:"huggingface_hub.push_to_hub_keras.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If
not set, will use the token set when logging in with
<code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"huggingface_hub.push_to_hub_keras.branch",description:`<strong>branch</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git branch on which to push the model. This defaults to
the default branch as specified in your repository, which
defaults to <code>&quot;main&quot;</code>.`,name:"branch"},{anchor:"huggingface_hub.push_to_hub_keras.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request from <code>branch</code> with that commit.
Defaults to <code>False</code>.`,name:"create_pr"},{anchor:"huggingface_hub.push_to_hub_keras.config",description:`<strong>config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Configuration object to be saved alongside the model weights.`,name:"config"},{anchor:"huggingface_hub.push_to_hub_keras.allow_patterns",description:`<strong>allow_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, only files matching at least one pattern are pushed.`,name:"allow_patterns"},{anchor:"huggingface_hub.push_to_hub_keras.ignore_patterns",description:`<strong>ignore_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, files matching any of the patterns are not pushed.`,name:"ignore_patterns"},{anchor:"huggingface_hub.push_to_hub_keras.delete_patterns",description:`<strong>delete_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, remote files matching any of the patterns will be deleted from the repo.`,name:"delete_patterns"},{anchor:"huggingface_hub.push_to_hub_keras.log_dir",description:`<strong>log_dir</strong> (<code>str</code>, <em>optional</em>) &#x2014;
TensorBoard logging directory to be pushed. The Hub automatically
hosts and displays a TensorBoard instance if log files are included
in the repository.`,name:"log_dir"},{anchor:"huggingface_hub.push_to_hub_keras.include_optimizer",description:`<strong>include_optimizer</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to include optimizer during serialization.`,name:"include_optimizer"},{anchor:"huggingface_hub.push_to_hub_keras.tags",description:`<strong>tags</strong> (Union[<code>list</code>, <code>str</code>], <em>optional</em>) &#x2014;
List of tags that are related to model or string of a single tag. See example tags
<a href="https://github.com/huggingface/hub-docs/blob/main/modelcard.md?plain=1" rel="nofollow">here</a>.`,name:"tags"},{anchor:"huggingface_hub.push_to_hub_keras.plot_model",description:`<strong>plot_model</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Setting this to <code>True</code> will plot the model and put it in the model
card. Requires graphviz and pydot to be installed.`,name:"plot_model"},{anchor:"huggingface_hub.push_to_hub_keras.model_save_kwargs(dict,",description:`<strong>model_save_kwargs(<code>dict</code>,</strong> <em>optional</em>) &#x2014;
model_save_kwargs will be passed to
<a href="https://www.tensorflow.org/api_docs/python/tf/keras/models/save_model" rel="nofollow"><code>tf.keras.models.save_model()</code></a>.`,name:"model_save_kwargs(dict,"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/keras_mixin.py#L299",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The url of the commit of your model in the given repository.</p>
`}}),de=new k({props:{name:"huggingface_hub.save_pretrained_keras",anchor:"huggingface_hub.save_pretrained_keras",parameters:[{name:"model",val:""},{name:"save_directory",val:": Union"},{name:"config",val:": Optional = None"},{name:"include_optimizer",val:": bool = False"},{name:"plot_model",val:": bool = True"},{name:"tags",val:": Union = None"},{name:"**model_save_kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.save_pretrained_keras.model",description:`<strong>model</strong> (<code>Keras.Model</code>) &#x2014;
The <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">Keras
model</a>
you&#x2019;d like to save. The model must be compiled and built.`,name:"model"},{anchor:"huggingface_hub.save_pretrained_keras.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>Path</code>) &#x2014;
Specify directory in which you want to save the Keras model.`,name:"save_directory"},{anchor:"huggingface_hub.save_pretrained_keras.config",description:`<strong>config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Configuration object to be saved alongside the model weights.`,name:"config"},{anchor:"huggingface_hub.save_pretrained_keras.include_optimizer(bool,",description:`<strong>include_optimizer(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to include optimizer in serialization.`,name:"include_optimizer(bool,"},{anchor:"huggingface_hub.save_pretrained_keras.plot_model",description:`<strong>plot_model</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Setting this to <code>True</code> will plot the model and put it in the model
card. Requires graphviz and pydot to be installed.`,name:"plot_model"},{anchor:"huggingface_hub.save_pretrained_keras.tags",description:`<strong>tags</strong> (Union[<code>str</code>,<code>list</code>], <em>optional</em>) &#x2014;
List of tags that are related to model or string of a single tag. See example tags
<a href="https://github.com/huggingface/hub-docs/blob/main/modelcard.md?plain=1" rel="nofollow">here</a>.`,name:"tags"},{anchor:"huggingface_hub.save_pretrained_keras.model_save_kwargs(dict,",description:`<strong>model_save_kwargs(<code>dict</code>,</strong> <em>optional</em>) &#x2014;
model_save_kwargs will be passed to
<a href="https://www.tensorflow.org/api_docs/python/tf/keras/models/save_model" rel="nofollow"><code>tf.keras.models.save_model()</code></a>.`,name:"model_save_kwargs(dict,"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/keras_mixin.py#L156"}}),ce=new Ge({props:{title:"Fastai",local:"huggingface_hub.from_pretrained_fastai",headingTag:"h3"}}),pe=new k({props:{name:"huggingface_hub.from_pretrained_fastai",anchor:"huggingface_hub.from_pretrained_fastai",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.from_pretrained_fastai.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The location where the pickled fastai.Learner is. It can be either of the two:<ul>
<li>Hosted on the Hugging Face Hub. E.g.: &#x2018;espejelomar/fatai-pet-breeds-classification&#x2019; or &#x2018;distilgpt2&#x2019;.
You can add a <code>revision</code> by appending <code>@</code> at the end of <code>repo_id</code>. E.g.: <code>dbmdz/bert-base-german-cased@main</code>.
Revision is the specific model version to use. Since we use a git-based system for storing models and other
artifacts on the Hugging Face Hub, it can be a branch name, a tag name, or a commit id.</li>
<li>Hosted locally. <code>repo_id</code> would be a directory containing the pickle and a pyproject.toml
indicating the fastai and fastcore versions used to build the <code>fastai.Learner</code>. E.g.: <code>./my_model_directory/</code>.</li>
</ul>`,name:"repo_id"},{anchor:"huggingface_hub.from_pretrained_fastai.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Revision at which the repo&#x2019;s files are downloaded. See documentation of <code>snapshot_download</code>.`,name:"revision"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/fastai_utils.py#L298",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The <code>fastai.Learner</code> model in the <code>repo_id</code> repo.</p>
`}}),he=new k({props:{name:"huggingface_hub.push_to_hub_fastai",anchor:"huggingface_hub.push_to_hub_fastai",parameters:[{name:"learner",val:""},{name:"repo_id",val:": str"},{name:"commit_message",val:": str = 'Push FastAI model using huggingface_hub.'"},{name:"private",val:": bool = False"},{name:"token",val:": Optional = None"},{name:"config",val:": Optional = None"},{name:"branch",val:": Optional = None"},{name:"create_pr",val:": Optional = None"},{name:"allow_patterns",val:": Union = None"},{name:"ignore_patterns",val:": Union = None"},{name:"delete_patterns",val:": Union = None"},{name:"api_endpoint",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.push_to_hub_fastai.learner",description:`<strong>learner</strong> (<em>Learner</em>) &#x2014;
The *fastai.Learner&#x2019; you&#x2019;d like to push to the Hub.`,name:"learner"},{anchor:"huggingface_hub.push_to_hub_fastai.repo_id",description:`<strong>repo_id</strong> (<em>str</em>) &#x2014;
The repository id for your model in Hub in the format of &#x201C;namespace/repo_name&#x201D;. The namespace can be your individual account or an organization to which you have write access (for example, &#x2018;stanfordnlp/stanza-de&#x2019;).`,name:"repo_id"},{anchor:"huggingface_hub.push_to_hub_fastai.commit_message",description:"<strong>commit_message</strong> (<em>str`, </em>optional*) &#x2014; Message to commit while pushing. Will default to <code>&quot;add model&quot;</code>.",name:"commit_message"},{anchor:"huggingface_hub.push_to_hub_fastai.private",description:`<strong>private</strong> (<em>bool</em>, <em>optional</em>, defaults to <em>False</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"huggingface_hub.push_to_hub_fastai.token",description:`<strong>token</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The Hugging Face account token to use as HTTP bearer authorization for remote files. If <code>None</code>, the token will be asked by a prompt.`,name:"token"},{anchor:"huggingface_hub.push_to_hub_fastai.config",description:`<strong>config</strong> (<em>dict</em>, <em>optional</em>) &#x2014;
Configuration object to be saved alongside the model weights.`,name:"config"},{anchor:"huggingface_hub.push_to_hub_fastai.branch",description:`<strong>branch</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The git branch on which to push the model. This defaults to
the default branch as specified in your repository, which
defaults to <em>&#x201C;main&#x201D;</em>.`,name:"branch"},{anchor:"huggingface_hub.push_to_hub_fastai.create_pr",description:`<strong>create_pr</strong> (<em>boolean</em>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request from <em>branch</em> with that commit.
Defaults to <em>False</em>.`,name:"create_pr"},{anchor:"huggingface_hub.push_to_hub_fastai.api_endpoint",description:`<strong>api_endpoint</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The API endpoint to use when pushing the model to the hub.`,name:"api_endpoint"},{anchor:"huggingface_hub.push_to_hub_fastai.allow_patterns",description:`<strong>allow_patterns</strong> (<em>List[str]</em> or <em>str</em>, <em>optional</em>) &#x2014;
If provided, only files matching at least one pattern are pushed.`,name:"allow_patterns"},{anchor:"huggingface_hub.push_to_hub_fastai.ignore_patterns",description:`<strong>ignore_patterns</strong> (<em>List[str]</em> or <em>str</em>, <em>optional</em>) &#x2014;
If provided, files matching any of the patterns are not pushed.`,name:"ignore_patterns"},{anchor:"huggingface_hub.push_to_hub_fastai.delete_patterns",description:`<strong>delete_patterns</strong> (<em>List[str]</em> or <em>str</em>, <em>optional</em>) &#x2014;
If provided, remote files matching any of the patterns will be deleted from the repo.`,name:"delete_patterns"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/fastai_utils.py#L343",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The url of the commit of your model in the given repository.</p>
`}}),R=new st({props:{$$slots:{default:[ut]},$$scope:{ctx:$}}}),{c(){s=i("meta"),j=n(),c=i("p"),h=n(),m(v.$$.fragment),r=n(),m(T.$$.fragment),Ve=n(),Q=i("p"),Q.innerHTML=Na,Le=n(),m(q.$$.fragment),Se=n(),w=i("div"),m(D.$$.fragment),la=n(),ue=i("p"),ue.textContent=Ga,ra=n(),fe=i("p"),fe.innerHTML=za,ia=n(),_e=i("p"),_e.innerHTML=Fa,da=n(),m(z.$$.fragment),ca=n(),F=i("div"),m(K.$$.fragment),pa=n(),be=i("p"),be.innerHTML=Va,ha=n(),I=i("div"),m(O.$$.fragment),ma=n(),Me=i("p"),Me.textContent=La,ga=n(),we=i("p"),we.innerHTML=Sa,ua=n(),ye=i("p"),ye.innerHTML=Xa,fa=n(),V=i("div"),m(ee.$$.fragment),_a=n(),je=i("p"),je.textContent=Ya,ba=n(),Z=i("div"),m(ae.$$.fragment),Ma=n(),ve=i("p"),ve.textContent=Ra,wa=n(),Te=i("p"),Te.innerHTML=Pa,ya=n(),L=i("div"),m(te.$$.fragment),ja=n(),xe=i("p"),xe.textContent=Qa,Xe=n(),m(ne.$$.fragment),Ye=n(),H=i("div"),m(oe.$$.fragment),va=n(),Je=i("p"),Je.innerHTML=qa,Ta=n(),m(S.$$.fragment),Re=n(),m(se.$$.fragment),Pe=n(),C=i("div"),m(le.$$.fragment),xa=n(),Ue=i("p"),Ue.innerHTML=Da,Ja=n(),m(X.$$.fragment),Qe=n(),A=i("div"),m(re.$$.fragment),Ua=n(),ke=i("p"),ke.innerHTML=Ka,ka=n(),m(Y.$$.fragment),qe=n(),W=i("div"),m(ie.$$.fragment),$a=n(),$e=i("p"),$e.textContent=Oa,Ia=n(),Ie=i("p"),Ie.innerHTML=et,De=n(),E=i("div"),m(de.$$.fragment),Ha=n(),He=i("p"),He.textContent=at,Ke=n(),m(ce.$$.fragment),Oe=n(),N=i("div"),m(pe.$$.fragment),Ca=n(),Ce=i("p"),Ce.textContent=tt,ea=n(),U=i("div"),m(he.$$.fragment),Aa=n(),Ae=i("p"),Ae.textContent=nt,Wa=n(),We=i("p"),We.innerHTML=ot,Ba=n(),m(R.$$.fragment),aa=n(),ze=i("p"),this.h()},l(e){const l=ct("svelte-u9bgzb",document.head);s=d(l,"META",{name:!0,content:!0}),l.forEach(t),j=o(e),c=d(e,"P",{}),x(c).forEach(t),h=o(e),g(v.$$.fragment,e),r=o(e),g(T.$$.fragment,e),Ve=o(e),Q=d(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-by7ppc"&&(Q.innerHTML=Na),Le=o(e),g(q.$$.fragment,e),Se=o(e),w=d(e,"DIV",{class:!0});var y=x(w);g(D.$$.fragment,y),la=o(y),ue=d(y,"P",{"data-svelte-h":!0}),M(ue)!=="svelte-1q74itk"&&(ue.textContent=Ga),ra=o(y),fe=d(y,"P",{"data-svelte-h":!0}),M(fe)!=="svelte-1g82wpt"&&(fe.innerHTML=za),ia=o(y),_e=d(y,"P",{"data-svelte-h":!0}),M(_e)!=="svelte-llbfhb"&&(_e.innerHTML=Fa),da=o(y),g(z.$$.fragment,y),ca=o(y),F=d(y,"DIV",{class:!0});var me=x(F);g(K.$$.fragment,me),pa=o(me),be=d(me,"P",{"data-svelte-h":!0}),M(be)!=="svelte-1fdydm0"&&(be.innerHTML=Va),me.forEach(t),ha=o(y),I=d(y,"DIV",{class:!0});var B=x(I);g(O.$$.fragment,B),ma=o(B),Me=d(B,"P",{"data-svelte-h":!0}),M(Me)!=="svelte-1totzue"&&(Me.textContent=La),ga=o(B),we=d(B,"P",{"data-svelte-h":!0}),M(we)!=="svelte-90qthw"&&(we.innerHTML=Sa),ua=o(B),ye=d(B,"P",{"data-svelte-h":!0}),M(ye)!=="svelte-1xccgfy"&&(ye.innerHTML=Xa),B.forEach(t),fa=o(y),V=d(y,"DIV",{class:!0});var ge=x(V);g(ee.$$.fragment,ge),_a=o(ge),je=d(ge,"P",{"data-svelte-h":!0}),M(je)!=="svelte-ydwjgk"&&(je.textContent=Ya),ge.forEach(t),ba=o(y),Z=d(y,"DIV",{class:!0});var G=x(Z);g(ae.$$.fragment,G),Ma=o(G),ve=d(G,"P",{"data-svelte-h":!0}),M(ve)!=="svelte-skcyeb"&&(ve.textContent=Ra),wa=o(G),Te=d(G,"P",{"data-svelte-h":!0}),M(Te)!=="svelte-mlktc5"&&(Te.innerHTML=Pa),G.forEach(t),ya=o(y),L=d(y,"DIV",{class:!0});var na=x(L);g(te.$$.fragment,na),ja=o(na),xe=d(na,"P",{"data-svelte-h":!0}),M(xe)!=="svelte-usyekl"&&(xe.textContent=Qa),na.forEach(t),y.forEach(t),Xe=o(e),g(ne.$$.fragment,e),Ye=o(e),H=d(e,"DIV",{class:!0});var Be=x(H);g(oe.$$.fragment,Be),va=o(Be),Je=d(Be,"P",{"data-svelte-h":!0}),M(Je)!=="svelte-1gq77ie"&&(Je.innerHTML=qa),Ta=o(Be),g(S.$$.fragment,Be),Be.forEach(t),Re=o(e),g(se.$$.fragment,e),Pe=o(e),C=d(e,"DIV",{class:!0});var Ze=x(C);g(le.$$.fragment,Ze),xa=o(Ze),Ue=d(Ze,"P",{"data-svelte-h":!0}),M(Ue)!=="svelte-1ldd987"&&(Ue.innerHTML=Da),Ja=o(Ze),g(X.$$.fragment,Ze),Ze.forEach(t),Qe=o(e),A=d(e,"DIV",{class:!0});var Ee=x(A);g(re.$$.fragment,Ee),Ua=o(Ee),ke=d(Ee,"P",{"data-svelte-h":!0}),M(ke)!=="svelte-13dzwpk"&&(ke.innerHTML=Ka),ka=o(Ee),g(Y.$$.fragment,Ee),Ee.forEach(t),qe=o(e),W=d(e,"DIV",{class:!0});var Ne=x(W);g(ie.$$.fragment,Ne),$a=o(Ne),$e=d(Ne,"P",{"data-svelte-h":!0}),M($e)!=="svelte-skcyeb"&&($e.textContent=Oa),Ia=o(Ne),Ie=d(Ne,"P",{"data-svelte-h":!0}),M(Ie)!=="svelte-mlktc5"&&(Ie.innerHTML=et),Ne.forEach(t),De=o(e),E=d(e,"DIV",{class:!0});var oa=x(E);g(de.$$.fragment,oa),Ha=o(oa),He=d(oa,"P",{"data-svelte-h":!0}),M(He)!=="svelte-1y1rkkk"&&(He.textContent=at),oa.forEach(t),Ke=o(e),g(ce.$$.fragment,e),Oe=o(e),N=d(e,"DIV",{class:!0});var sa=x(N);g(pe.$$.fragment,sa),Ca=o(sa),Ce=d(sa,"P",{"data-svelte-h":!0}),M(Ce)!=="svelte-1fexh91"&&(Ce.textContent=tt),sa.forEach(t),ea=o(e),U=d(e,"DIV",{class:!0});var P=x(U);g(he.$$.fragment,P),Aa=o(P),Ae=d(P,"P",{"data-svelte-h":!0}),M(Ae)!=="svelte-18c83zg"&&(Ae.textContent=nt),Wa=o(P),We=d(P,"P",{"data-svelte-h":!0}),M(We)!=="svelte-1jbgd9l"&&(We.innerHTML=ot),Ba=o(P),g(R.$$.fragment,P),P.forEach(t),aa=o(e),ze=d(e,"P",{}),x(ze).forEach(t),this.h()},h(){J(s,"name","hf:doc:metadata"),J(s,"content",_t),J(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,l){a(document.head,s),p(e,j,l),p(e,c,l),p(e,h,l),u(v,e,l),p(e,r,l),u(T,e,l),p(e,Ve,l),p(e,Q,l),p(e,Le,l),u(q,e,l),p(e,Se,l),p(e,w,l),u(D,w,null),a(w,la),a(w,ue),a(w,ra),a(w,fe),a(w,ia),a(w,_e),a(w,da),u(z,w,null),a(w,ca),a(w,F),u(K,F,null),a(F,pa),a(F,be),a(w,ha),a(w,I),u(O,I,null),a(I,ma),a(I,Me),a(I,ga),a(I,we),a(I,ua),a(I,ye),a(w,fa),a(w,V),u(ee,V,null),a(V,_a),a(V,je),a(w,ba),a(w,Z),u(ae,Z,null),a(Z,Ma),a(Z,ve),a(Z,wa),a(Z,Te),a(w,ya),a(w,L),u(te,L,null),a(L,ja),a(L,xe),p(e,Xe,l),u(ne,e,l),p(e,Ye,l),p(e,H,l),u(oe,H,null),a(H,va),a(H,Je),a(H,Ta),u(S,H,null),p(e,Re,l),u(se,e,l),p(e,Pe,l),p(e,C,l),u(le,C,null),a(C,xa),a(C,Ue),a(C,Ja),u(X,C,null),p(e,Qe,l),p(e,A,l),u(re,A,null),a(A,Ua),a(A,ke),a(A,ka),u(Y,A,null),p(e,qe,l),p(e,W,l),u(ie,W,null),a(W,$a),a(W,$e),a(W,Ia),a(W,Ie),p(e,De,l),p(e,E,l),u(de,E,null),a(E,Ha),a(E,He),p(e,Ke,l),u(ce,e,l),p(e,Oe,l),p(e,N,l),u(pe,N,null),a(N,Ca),a(N,Ce),p(e,ea,l),p(e,U,l),u(he,U,null),a(U,Aa),a(U,Ae),a(U,Wa),a(U,We),a(U,Ba),u(R,U,null),p(e,aa,l),p(e,ze,l),ta=!0},p(e,[l]){const y={};l&2&&(y.$$scope={dirty:l,ctx:e}),z.$set(y);const me={};l&2&&(me.$$scope={dirty:l,ctx:e}),S.$set(me);const B={};l&2&&(B.$$scope={dirty:l,ctx:e}),X.$set(B);const ge={};l&2&&(ge.$$scope={dirty:l,ctx:e}),Y.$set(ge);const G={};l&2&&(G.$$scope={dirty:l,ctx:e}),R.$set(G)},i(e){ta||(f(v.$$.fragment,e),f(T.$$.fragment,e),f(q.$$.fragment,e),f(D.$$.fragment,e),f(z.$$.fragment,e),f(K.$$.fragment,e),f(O.$$.fragment,e),f(ee.$$.fragment,e),f(ae.$$.fragment,e),f(te.$$.fragment,e),f(ne.$$.fragment,e),f(oe.$$.fragment,e),f(S.$$.fragment,e),f(se.$$.fragment,e),f(le.$$.fragment,e),f(X.$$.fragment,e),f(re.$$.fragment,e),f(Y.$$.fragment,e),f(ie.$$.fragment,e),f(de.$$.fragment,e),f(ce.$$.fragment,e),f(pe.$$.fragment,e),f(he.$$.fragment,e),f(R.$$.fragment,e),ta=!0)},o(e){_(v.$$.fragment,e),_(T.$$.fragment,e),_(q.$$.fragment,e),_(D.$$.fragment,e),_(z.$$.fragment,e),_(K.$$.fragment,e),_(O.$$.fragment,e),_(ee.$$.fragment,e),_(ae.$$.fragment,e),_(te.$$.fragment,e),_(ne.$$.fragment,e),_(oe.$$.fragment,e),_(S.$$.fragment,e),_(se.$$.fragment,e),_(le.$$.fragment,e),_(X.$$.fragment,e),_(re.$$.fragment,e),_(Y.$$.fragment,e),_(ie.$$.fragment,e),_(de.$$.fragment,e),_(ce.$$.fragment,e),_(pe.$$.fragment,e),_(he.$$.fragment,e),_(R.$$.fragment,e),ta=!1},d(e){e&&(t(j),t(c),t(h),t(r),t(Ve),t(Q),t(Le),t(Se),t(w),t(Xe),t(Ye),t(H),t(Re),t(Pe),t(C),t(Qe),t(A),t(qe),t(W),t(De),t(E),t(Ke),t(Oe),t(N),t(ea),t(U),t(aa),t(ze)),t(s),b(v,e),b(T,e),b(q,e),b(D),b(z),b(K),b(O),b(ee),b(ae),b(te),b(ne,e),b(oe),b(S),b(se,e),b(le),b(X),b(re),b(Y),b(ie),b(de),b(ce,e),b(pe),b(he),b(R)}}}const _t='{"title":"Mixins & serialization methods","local":"mixins--serialization-methods","sections":[{"title":"Mixins","local":"mixins","sections":[{"title":"Generic","local":"huggingface_hub.ModelHubMixin","sections":[],"depth":3},{"title":"PyTorch","local":"huggingface_hub.PyTorchModelHubMixin","sections":[],"depth":3},{"title":"Keras","local":"huggingface_hub.KerasModelHubMixin","sections":[],"depth":3},{"title":"Fastai","local":"huggingface_hub.from_pretrained_fastai","sections":[],"depth":3}],"depth":2}],"depth":1}';function bt($){return rt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Jt extends it{constructor(s){super(),dt(this,s,bt,ft,lt,{})}}export{Jt as component};
