import{s as vt,o as jt,n as De}from"../chunks/scheduler.182ea377.js";import{S as gt,i as Ct,g as p,s as i,r as f,A as Zt,h as o,f as l,c as n,j as _t,u as d,x as r,k as $t,y as Gt,a as s,v as u,d as m,t as M,w as h}from"../chunks/index.abf12888.js";import{T as Qe}from"../chunks/Tip.230e2334.js";import{C as w}from"../chunks/CodeBlock.57fe6e13.js";import{H as Ae}from"../chunks/Heading.16916d63.js";function It(T){let a,y='To learn more, take a look at the <a href="https://huggingface.co/docs/accelerate/en/usage_guides/distributed_inference#distributed-inference-with-accelerate" rel="nofollow">Distributed Inference with 🤗 Accelerate</a> guide.';return{c(){a=p("p"),a.innerHTML=y},l(c){a=o(c,"P",{"data-svelte-h":!0}),r(a)!=="svelte-c8rg1s"&&(a.innerHTML=y)},m(c,b){s(c,a,b)},p:De,d(c){c&&l(a)}}}function kt(T){let a,y="This feature is experimental and its APIs might change in the future.";return{c(){a=p("p"),a.textContent=y},l(c){a=o(c,"P",{"data-svelte-h":!0}),r(a)!=="svelte-1o311ve"&&(a.textContent=y)},m(c,b){s(c,a,b)},p:De,d(c){c&&l(a)}}}function Wt(T){let a,y="Only the “balanced” strategy is supported at the moment, and we plan to support additional mapping strategies in the future.";return{c(){a=p("p"),a.textContent=y},l(c){a=o(c,"P",{"data-svelte-h":!0}),r(a)!=="svelte-qgg1n4"&&(a.textContent=y)},m(c,b){s(c,a,b)},p:De,d(c){c&&l(a)}}}function xt(T){let a,y,c,b,$,oe,v,Ke='On distributed setups, you can run inference across multiple GPUs with 🤗 <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate</a> or <a href="https://pytorch.org/tutorials/beginner/dist_overview.html" rel="nofollow">PyTorch Distributed</a>, which is useful for generating with multiple prompts in parallel.',re,j,Oe="This guide will show you how to use 🤗 Accelerate and PyTorch Distributed for distributed inference.",ce,g,fe,C,et='🤗 <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate</a> is a library designed to make it easy to train or run inference across distributed setups. It simplifies the process of setting up the distributed environment, allowing you to focus on your PyTorch code.',de,Z,tt='To begin, create a Python file and initialize an <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/state#accelerate.PartialState" rel="nofollow">accelerate.PartialState</a> to create a distributed environment; your setup is automatically detected so you don’t need to explicitly define the <code>rank</code> or <code>world_size</code>. Move the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to <code>distributed_state.device</code> to assign a GPU to each process.',ue,G,lt='Now use the <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/state#accelerate.PartialState.split_between_processes" rel="nofollow">split_between_processes</a> utility as a context manager to automatically distribute the prompts between the number of processes.',me,I,Me,k,st="Use the <code>--num_processes</code> argument to specify the number of GPUs to use, and call <code>accelerate launch</code> to run the script:",he,W,ye,J,we,x,be,U,Te,P,it="With Accelerate, you can use the <code>device_map</code> to determine how to distribute the models of a pipeline across multiple devices. This is useful in situations where you have more than one GPU.",Je,H,nt='For example, if you have two 8GB GPUs, then using <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> may not work so well because:',Ue,E,at='<li>it only works on a single GPU</li> <li>a single model might not fit on a single GPU (<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a> might work but it will be extremely slow and it is also limited to a single GPU)</li>',_e,R,pt="To make use of both GPUs, you can use the “balanced” device placement strategy which splits the models across all available GPUs.",$e,_,ve,z,je,B,ot="You can also pass a dictionary to enforce the maximum GPU memory that can be used on each device:",ge,N,Ce,V,rt="If a device is not present in <code>max_memory</code>, then it will be completely ignored and will not participate in the device placement.",Ze,X,ct='By default, Diffusers uses the maximum memory of all devices. If the models don’t fit on the GPUs, they are offloaded to the CPU. If the CPU doesn’t have enough memory, then you might see an error. In that case, you could defer to using <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a> and <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a>.',Ge,S,ft='Call <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.reset_device_map">reset_device_map()</a> to reset the <code>device_map</code> of a pipeline. This is also necessary if you want to use methods like <code>to()</code>, <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a>, and <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> on a pipeline that was device-mapped.',Ie,Y,ke,q,dt="Once a pipeline has been device-mapped, you can also access its device map via <code>hf_device_map</code>:",We,L,xe,F,ut="An example device map would look like so:",Pe,A,He,Q,Ee,D,mt='PyTorch supports <a href="https://pytorch.org/docs/stable/generated/torch.nn.parallel.DistributedDataParallel.html" rel="nofollow"><code>DistributedDataParallel</code></a> which enables data parallelism.',Re,K,Mt='To start, create a Python file and import <code>torch.distributed</code> and <code>torch.multiprocessing</code> to set up the distributed process group and to spawn the processes for inference on each GPU. You should also initialize a <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>:',ze,O,Be,ee,ht='You’ll want to create a function to run inference; <a href="https://pytorch.org/docs/stable/distributed.html?highlight=init_process_group#torch.distributed.init_process_group" rel="nofollow"><code>init_process_group</code></a> handles creating a distributed environment with the type of backend to use, the <code>rank</code> of the current process, and the <code>world_size</code> or the number of processes participating. If you’re running inference in parallel over 2 GPUs, then the <code>world_size</code> is 2.',Ne,te,yt='Move the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to <code>rank</code> and use <code>get_rank</code> to assign a GPU to each process, where each process handles a different prompt:',Ve,le,Xe,se,wt='To run the distributed inference, call <a href="https://pytorch.org/docs/stable/multiprocessing.html#torch.multiprocessing.spawn" rel="nofollow"><code>mp.spawn</code></a> to run the <code>run_inference</code> function on the number of GPUs defined in <code>world_size</code>:',Se,ie,Ye,ne,bt="Once you’ve completed the inference script, use the <code>--nproc_per_node</code> argument to specify the number of GPUs to use and call <code>torchrun</code> to run the script:",qe,ae,Le,pe,Fe;return $=new Ae({props:{title:"Distributed inference with multiple GPUs",local:"distributed-inference-with-multiple-gpus",headingTag:"h1"}}),g=new Ae({props:{title:"🤗 Accelerate",local:"-accelerate",headingTag:"h2"}}),I=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwYWNjZWxlcmF0ZSUyMGltcG9ydCUyMFBhcnRpYWxTdGF0ZSUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBEaWZmdXNpb25QaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFkaXN0cmlidXRlZF9zdGF0ZSUyMCUzRCUyMFBhcnRpYWxTdGF0ZSgpJTBBcGlwZWxpbmUudG8oZGlzdHJpYnV0ZWRfc3RhdGUuZGV2aWNlKSUwQSUwQXdpdGglMjBkaXN0cmlidXRlZF9zdGF0ZS5zcGxpdF9iZXR3ZWVuX3Byb2Nlc3NlcyglNUIlMjJhJTIwZG9nJTIyJTJDJTIwJTIyYSUyMGNhdCUyMiU1RCklMjBhcyUyMHByb21wdCUzQSUwQSUyMCUyMCUyMCUyMHJlc3VsdCUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCkuaW1hZ2VzJTVCMCU1RCUwQSUyMCUyMCUyMCUyMHJlc3VsdC5zYXZlKGYlMjJyZXN1bHRfJTdCZGlzdHJpYnV0ZWRfc3RhdGUucHJvY2Vzc19pbmRleCU3RC5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> PartialState
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
distributed_state = PartialState()
pipeline.to(distributed_state.device)

<span class="hljs-keyword">with</span> distributed_state.split_between_processes([<span class="hljs-string">&quot;a dog&quot;</span>, <span class="hljs-string">&quot;a cat&quot;</span>]) <span class="hljs-keyword">as</span> prompt:
    result = pipeline(prompt).images[<span class="hljs-number">0</span>]
    result.save(<span class="hljs-string">f&quot;result_<span class="hljs-subst">{distributed_state.process_index}</span>.png&quot;</span>)`,wrap:!1}}),W=new w({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHJ1bl9kaXN0cmlidXRlZC5weSUyMC0tbnVtX3Byb2Nlc3NlcyUzRDI=",highlighted:"accelerate launch run_distributed.py --num_processes=2",wrap:!1}}),J=new Qe({props:{$$slots:{default:[It]},$$scope:{ctx:T}}}),x=new Ae({props:{title:"Device placement",local:"device-placement",headingTag:"h3"}}),U=new Qe({props:{warning:!0,$$slots:{default:[kt]},$$scope:{ctx:T}}}),_=new Qe({props:{warning:!0,$$slots:{default:[Wt]},$$scope:{ctx:T}}}),z=new w({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEEtJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTJDJTBBJTJCJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTJDJTIwZGV2aWNlX21hcCUzRCUyMmJhbGFuY2VkJTIyJTBBKSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTIyYSUyMGRvZyUyMikuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`from diffusers import DiffusionPipeline
import torch

pipeline = DiffusionPipeline.from_pretrained(
<span class="hljs-deletion">-    &quot;runwayml/stable-diffusion-v1-5&quot;, torch_dtype=torch.float16, use_safetensors=True,</span>
<span class="hljs-addition">+    &quot;runwayml/stable-diffusion-v1-5&quot;, torch_dtype=torch.float16, use_safetensors=True, device_map=&quot;balanced&quot;</span>
)
image = pipeline(&quot;a dog&quot;).images[0]
image`,wrap:!1}}),N=new w({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtYXhfbWVtb3J5JTIwJTNEJTIwJTdCMCUzQSUyMjFHQiUyMiUyQyUyMDElM0ElMjIxR0IlMjIlN0QlMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMCUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMjAlMEElMjAlMjAlMjAlMjBkZXZpY2VfbWFwJTNEJTIyYmFsYW5jZWQlMjIlMkMlMEElMkIlMjAlMjAlMjBtYXhfbWVtb3J5JTNEbWF4X21lbW9yeSUwQSklMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUyMmElMjBkb2clMjIpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`from diffusers import DiffusionPipeline
import torch

max_memory = {0:&quot;1GB&quot;, 1:&quot;1GB&quot;}
pipeline = DiffusionPipeline.from_pretrained(
    &quot;runwayml/stable-diffusion-v1-5&quot;,
    torch_dtype=torch.float16, 
    use_safetensors=True, 
    device_map=&quot;balanced&quot;,
<span class="hljs-addition">+   max_memory=max_memory</span>
)
image = pipeline(&quot;a dog&quot;).images[0]
image`,wrap:!1}}),Y=new w({props:{code:"cGlwZWxpbmUucmVzZXRfZGV2aWNlX21hcCgp",highlighted:"pipeline.reset_device_map()",wrap:!1}}),L=new w({props:{code:"cHJpbnQocGlwZWxpbmUuaGZfZGV2aWNlX21hcCk=",highlighted:'<span class="hljs-built_in">print</span>(pipeline.hf_device_map)',wrap:!1}}),A=new w({props:{code:"JTdCJ3VuZXQnJTNBJTIwMSUyQyUyMCd2YWUnJTNBJTIwMSUyQyUyMCdzYWZldHlfY2hlY2tlciclM0ElMjAwJTJDJTIwJ3RleHRfZW5jb2RlciclM0ElMjAwJTdE",highlighted:'{<span class="hljs-string">&#x27;unet&#x27;</span>: 1, <span class="hljs-string">&#x27;vae&#x27;</span>: 1, <span class="hljs-string">&#x27;safety_checker&#x27;</span>: 0, <span class="hljs-string">&#x27;text_encoder&#x27;</span>: 0}',wrap:!1}}),Q=new Ae({props:{title:"PyTorch Distributed",local:"pytorch-distributed",headingTag:"h2"}}),O=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5kaXN0cmlidXRlZCUyMGFzJTIwZGlzdCUwQWltcG9ydCUyMHRvcmNoLm11bHRpcHJvY2Vzc2luZyUyMGFzJTIwbXAlMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFzZCUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.distributed <span class="hljs-keyword">as</span> dist
<span class="hljs-keyword">import</span> torch.multiprocessing <span class="hljs-keyword">as</span> mp

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

sd = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),le=new w({props:{code:"ZGVmJTIwcnVuX2luZmVyZW5jZShyYW5rJTJDJTIwd29ybGRfc2l6ZSklM0ElMEElMjAlMjAlMjAlMjBkaXN0LmluaXRfcHJvY2Vzc19ncm91cCglMjJuY2NsJTIyJTJDJTIwcmFuayUzRHJhbmslMkMlMjB3b3JsZF9zaXplJTNEd29ybGRfc2l6ZSklMEElMEElMjAlMjAlMjAlMjBzZC50byhyYW5rKSUwQSUwQSUyMCUyMCUyMCUyMGlmJTIwdG9yY2guZGlzdHJpYnV0ZWQuZ2V0X3JhbmsoKSUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9tcHQlMjAlM0QlMjAlMjJhJTIwZG9nJTIyJTBBJTIwJTIwJTIwJTIwZWxpZiUyMHRvcmNoLmRpc3RyaWJ1dGVkLmdldF9yYW5rKCklMjAlM0QlM0QlMjAxJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGNhdCUyMiUwQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwc2QocHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwaW1hZ2Uuc2F2ZShmJTIyLiUyRiU3QidfJy5qb2luKHByb21wdCklN0QucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_inference</span>(<span class="hljs-params">rank, world_size</span>):
    dist.init_process_group(<span class="hljs-string">&quot;nccl&quot;</span>, rank=rank, world_size=world_size)

    sd.to(rank)

    <span class="hljs-keyword">if</span> torch.distributed.get_rank() == <span class="hljs-number">0</span>:
        prompt = <span class="hljs-string">&quot;a dog&quot;</span>
    <span class="hljs-keyword">elif</span> torch.distributed.get_rank() == <span class="hljs-number">1</span>:
        prompt = <span class="hljs-string">&quot;a cat&quot;</span>

    image = sd(prompt).images[<span class="hljs-number">0</span>]
    image.save(<span class="hljs-string">f&quot;./<span class="hljs-subst">{<span class="hljs-string">&#x27;_&#x27;</span>.join(prompt)}</span>.png&quot;</span>)`,wrap:!1}}),ie=new w({props:{code:"ZGVmJTIwbWFpbigpJTNBJTBBJTIwJTIwJTIwJTIwd29ybGRfc2l6ZSUyMCUzRCUyMDIlMEElMjAlMjAlMjAlMjBtcC5zcGF3bihydW5faW5mZXJlbmNlJTJDJTIwYXJncyUzRCh3b3JsZF9zaXplJTJDKSUyQyUyMG5wcm9jcyUzRHdvcmxkX3NpemUlMkMlMjBqb2luJTNEVHJ1ZSklMEElMEElMEFpZiUyMF9fbmFtZV9fJTIwJTNEJTNEJTIwJTIyX19tYWluX18lMjIlM0ElMEElMjAlMjAlMjAlMjBtYWluKCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
    world_size = <span class="hljs-number">2</span>
    mp.spawn(run_inference, args=(world_size,), nprocs=world_size, join=<span class="hljs-literal">True</span>)


<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    main()`,wrap:!1}}),ae=new w({props:{code:"dG9yY2hydW4lMjBydW5fZGlzdHJpYnV0ZWQucHklMjAtLW5wcm9jX3Blcl9ub2RlJTNEMg==",highlighted:"torchrun run_distributed.py --nproc_per_node=2",wrap:!1}}),{c(){a=p("meta"),y=i(),c=p("p"),b=i(),f($.$$.fragment),oe=i(),v=p("p"),v.innerHTML=Ke,re=i(),j=p("p"),j.textContent=Oe,ce=i(),f(g.$$.fragment),fe=i(),C=p("p"),C.innerHTML=et,de=i(),Z=p("p"),Z.innerHTML=tt,ue=i(),G=p("p"),G.innerHTML=lt,me=i(),f(I.$$.fragment),Me=i(),k=p("p"),k.innerHTML=st,he=i(),f(W.$$.fragment),ye=i(),f(J.$$.fragment),we=i(),f(x.$$.fragment),be=i(),f(U.$$.fragment),Te=i(),P=p("p"),P.innerHTML=it,Je=i(),H=p("p"),H.innerHTML=nt,Ue=i(),E=p("ul"),E.innerHTML=at,_e=i(),R=p("p"),R.textContent=pt,$e=i(),f(_.$$.fragment),ve=i(),f(z.$$.fragment),je=i(),B=p("p"),B.textContent=ot,ge=i(),f(N.$$.fragment),Ce=i(),V=p("p"),V.innerHTML=rt,Ze=i(),X=p("p"),X.innerHTML=ct,Ge=i(),S=p("p"),S.innerHTML=ft,Ie=i(),f(Y.$$.fragment),ke=i(),q=p("p"),q.innerHTML=dt,We=i(),f(L.$$.fragment),xe=i(),F=p("p"),F.textContent=ut,Pe=i(),f(A.$$.fragment),He=i(),f(Q.$$.fragment),Ee=i(),D=p("p"),D.innerHTML=mt,Re=i(),K=p("p"),K.innerHTML=Mt,ze=i(),f(O.$$.fragment),Be=i(),ee=p("p"),ee.innerHTML=ht,Ne=i(),te=p("p"),te.innerHTML=yt,Ve=i(),f(le.$$.fragment),Xe=i(),se=p("p"),se.innerHTML=wt,Se=i(),f(ie.$$.fragment),Ye=i(),ne=p("p"),ne.innerHTML=bt,qe=i(),f(ae.$$.fragment),Le=i(),pe=p("p"),this.h()},l(e){const t=Zt("svelte-u9bgzb",document.head);a=o(t,"META",{name:!0,content:!0}),t.forEach(l),y=n(e),c=o(e,"P",{}),_t(c).forEach(l),b=n(e),d($.$$.fragment,e),oe=n(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-a7bv7i"&&(v.innerHTML=Ke),re=n(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1qu3csy"&&(j.textContent=Oe),ce=n(e),d(g.$$.fragment,e),fe=n(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-13uq1g2"&&(C.innerHTML=et),de=n(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-qwrp8g"&&(Z.innerHTML=tt),ue=n(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1iuwz8b"&&(G.innerHTML=lt),me=n(e),d(I.$$.fragment,e),Me=n(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1ohh8as"&&(k.innerHTML=st),he=n(e),d(W.$$.fragment,e),ye=n(e),d(J.$$.fragment,e),we=n(e),d(x.$$.fragment,e),be=n(e),d(U.$$.fragment,e),Te=n(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1y4i1fz"&&(P.innerHTML=it),Je=n(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-11sq7ul"&&(H.innerHTML=nt),Ue=n(e),E=o(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-wjj3fr"&&(E.innerHTML=at),_e=n(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-awezto"&&(R.textContent=pt),$e=n(e),d(_.$$.fragment,e),ve=n(e),d(z.$$.fragment,e),je=n(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1y8b6l8"&&(B.textContent=ot),ge=n(e),d(N.$$.fragment,e),Ce=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-pzd1ok"&&(V.innerHTML=rt),Ze=n(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-izwtcw"&&(X.innerHTML=ct),Ge=n(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-dkgqfm"&&(S.innerHTML=ft),Ie=n(e),d(Y.$$.fragment,e),ke=n(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-17pbny5"&&(q.innerHTML=dt),We=n(e),d(L.$$.fragment,e),xe=n(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-18o6tiw"&&(F.textContent=ut),Pe=n(e),d(A.$$.fragment,e),He=n(e),d(Q.$$.fragment,e),Ee=n(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-jtiddl"&&(D.innerHTML=mt),Re=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-q18o27"&&(K.innerHTML=Mt),ze=n(e),d(O.$$.fragment,e),Be=n(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-qkdvuf"&&(ee.innerHTML=ht),Ne=n(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1rcgdqq"&&(te.innerHTML=yt),Ve=n(e),d(le.$$.fragment,e),Xe=n(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1ecd3vq"&&(se.innerHTML=wt),Se=n(e),d(ie.$$.fragment,e),Ye=n(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-ykaora"&&(ne.innerHTML=bt),qe=n(e),d(ae.$$.fragment,e),Le=n(e),pe=o(e,"P",{}),_t(pe).forEach(l),this.h()},h(){$t(a,"name","hf:doc:metadata"),$t(a,"content",Pt)},m(e,t){Gt(document.head,a),s(e,y,t),s(e,c,t),s(e,b,t),u($,e,t),s(e,oe,t),s(e,v,t),s(e,re,t),s(e,j,t),s(e,ce,t),u(g,e,t),s(e,fe,t),s(e,C,t),s(e,de,t),s(e,Z,t),s(e,ue,t),s(e,G,t),s(e,me,t),u(I,e,t),s(e,Me,t),s(e,k,t),s(e,he,t),u(W,e,t),s(e,ye,t),u(J,e,t),s(e,we,t),u(x,e,t),s(e,be,t),u(U,e,t),s(e,Te,t),s(e,P,t),s(e,Je,t),s(e,H,t),s(e,Ue,t),s(e,E,t),s(e,_e,t),s(e,R,t),s(e,$e,t),u(_,e,t),s(e,ve,t),u(z,e,t),s(e,je,t),s(e,B,t),s(e,ge,t),u(N,e,t),s(e,Ce,t),s(e,V,t),s(e,Ze,t),s(e,X,t),s(e,Ge,t),s(e,S,t),s(e,Ie,t),u(Y,e,t),s(e,ke,t),s(e,q,t),s(e,We,t),u(L,e,t),s(e,xe,t),s(e,F,t),s(e,Pe,t),u(A,e,t),s(e,He,t),u(Q,e,t),s(e,Ee,t),s(e,D,t),s(e,Re,t),s(e,K,t),s(e,ze,t),u(O,e,t),s(e,Be,t),s(e,ee,t),s(e,Ne,t),s(e,te,t),s(e,Ve,t),u(le,e,t),s(e,Xe,t),s(e,se,t),s(e,Se,t),u(ie,e,t),s(e,Ye,t),s(e,ne,t),s(e,qe,t),u(ae,e,t),s(e,Le,t),s(e,pe,t),Fe=!0},p(e,[t]){const Tt={};t&2&&(Tt.$$scope={dirty:t,ctx:e}),J.$set(Tt);const Jt={};t&2&&(Jt.$$scope={dirty:t,ctx:e}),U.$set(Jt);const Ut={};t&2&&(Ut.$$scope={dirty:t,ctx:e}),_.$set(Ut)},i(e){Fe||(m($.$$.fragment,e),m(g.$$.fragment,e),m(I.$$.fragment,e),m(W.$$.fragment,e),m(J.$$.fragment,e),m(x.$$.fragment,e),m(U.$$.fragment,e),m(_.$$.fragment,e),m(z.$$.fragment,e),m(N.$$.fragment,e),m(Y.$$.fragment,e),m(L.$$.fragment,e),m(A.$$.fragment,e),m(Q.$$.fragment,e),m(O.$$.fragment,e),m(le.$$.fragment,e),m(ie.$$.fragment,e),m(ae.$$.fragment,e),Fe=!0)},o(e){M($.$$.fragment,e),M(g.$$.fragment,e),M(I.$$.fragment,e),M(W.$$.fragment,e),M(J.$$.fragment,e),M(x.$$.fragment,e),M(U.$$.fragment,e),M(_.$$.fragment,e),M(z.$$.fragment,e),M(N.$$.fragment,e),M(Y.$$.fragment,e),M(L.$$.fragment,e),M(A.$$.fragment,e),M(Q.$$.fragment,e),M(O.$$.fragment,e),M(le.$$.fragment,e),M(ie.$$.fragment,e),M(ae.$$.fragment,e),Fe=!1},d(e){e&&(l(y),l(c),l(b),l(oe),l(v),l(re),l(j),l(ce),l(fe),l(C),l(de),l(Z),l(ue),l(G),l(me),l(Me),l(k),l(he),l(ye),l(we),l(be),l(Te),l(P),l(Je),l(H),l(Ue),l(E),l(_e),l(R),l($e),l(ve),l(je),l(B),l(ge),l(Ce),l(V),l(Ze),l(X),l(Ge),l(S),l(Ie),l(ke),l(q),l(We),l(xe),l(F),l(Pe),l(He),l(Ee),l(D),l(Re),l(K),l(ze),l(Be),l(ee),l(Ne),l(te),l(Ve),l(Xe),l(se),l(Se),l(Ye),l(ne),l(qe),l(Le),l(pe)),l(a),h($,e),h(g,e),h(I,e),h(W,e),h(J,e),h(x,e),h(U,e),h(_,e),h(z,e),h(N,e),h(Y,e),h(L,e),h(A,e),h(Q,e),h(O,e),h(le,e),h(ie,e),h(ae,e)}}}const Pt='{"title":"Distributed inference with multiple GPUs","local":"distributed-inference-with-multiple-gpus","sections":[{"title":"🤗 Accelerate","local":"-accelerate","sections":[{"title":"Device placement","local":"device-placement","sections":[],"depth":3}],"depth":2},{"title":"PyTorch Distributed","local":"pytorch-distributed","sections":[],"depth":2}],"depth":1}';function Ht(T){return jt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vt extends gt{constructor(a){super(),Ct(this,a,Ht,xt,vt,{})}}export{Vt as component};
