import{s as Us,o as Is,n as Wl}from"../chunks/scheduler.182ea377.js";import{S as Zs,i as Cs,g as i,s as a,r as c,A as Ws,h as o,f as l,c as n,j as js,u as m,x as p,k as w,y as vs,a as s,v as M,d,t as y,w as u}from"../chunks/index.abf12888.js";import{T as Cl}from"../chunks/Tip.230e2334.js";import{C as f}from"../chunks/CodeBlock.57fe6e13.js";import{D as Bs}from"../chunks/DocNotebookDropdown.5fa27ace.js";import{H as g}from"../chunks/Heading.16916d63.js";function ks(T){let r,J="This is not an exhaustive guide on prompt engineering, but it will help you understand the necessary parts of a good prompt. We encourage you to continue experimenting with different prompts and combine them in new ways to see what works best. As you write more prompts, you’ll develop an intuition for what works and what doesn’t!";return{c(){r=i("p"),r.textContent=J},l(h){r=o(h,"P",{"data-svelte-h":!0}),p(r)!=="svelte-18ymcu1"&&(r.textContent=J)},m(h,b){s(h,r,b)},p:Wl,d(h){h&&l(r)}}}function _s(T){let r,J='You should also use a <a href="https://www.crosslabs.org//blog/diffusion-with-offset-noise" rel="nofollow"><em>offset noise</em></a> LoRA to improve the contrast in bright and dark images and create better lighting overall. This <a href="https://hf.co/stabilityai/stable-diffusion-xl-base-1.0/blob/main/sd_xl_offset_example-lora_1.0.safetensors" rel="nofollow">LoRA</a> is available from <a href="https://hf.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>.';return{c(){r=i("p"),r.innerHTML=J},l(h){r=o(h,"P",{"data-svelte-h":!0}),p(r)!=="svelte-14yr5uj"&&(r.innerHTML=J)},m(h,b){s(h,r,b)},p:Wl,d(h){h&&l(r)}}}function Gs(T){let r,J='If your favorite pipeline doesn’t have a <code>prompt_embeds</code> parameter, please open an <a href="https://github.com/huggingface/diffusers/issues/new/choose" rel="nofollow">issue</a> so we can add it!';return{c(){r=i("p"),r.innerHTML=J},l(h){r=o(h,"P",{"data-svelte-h":!0}),p(r)!=="svelte-nya19q"&&(r.innerHTML=J)},m(h,b){s(h,r,b)},p:Wl,d(h){h&&l(r)}}}function Xs(T){let r,J="<code>+</code> corresponds to the value <code>1.1</code>, <code>++</code> corresponds to <code>1.1^2</code>, and so on. Similarly, <code>-</code> corresponds to <code>0.9</code> and <code>--</code> corresponds to <code>0.9^2</code>. Feel free to experiment with adding more <code>+</code> or <code>-</code> in your prompt!";return{c(){r=i("p"),r.innerHTML=J},l(h){r=o(h,"P",{"data-svelte-h":!0}),p(r)!=="svelte-1dn4vb7"&&(r.innerHTML=J)},m(h,b){s(h,r,b)},p:Wl,d(h){h&&l(r)}}}function $s(T){let r,J,h,b,x,Ke,q,Oe,H,vl="Prompts are important because they describe what you want a diffusion model to generate. The best prompts are detailed, specific, and well-structured to help the model realize your vision. But crafting a great prompt takes time and effort and sometimes it may not be enough because language and words can be imprecise. This is where you need to boost your prompt with other techniques, such as prompt enhancing and prompt weighting, to get the results you want.",et,Q,Bl="This guide will show you how you can use these prompt techniques to generate high-quality images with lower effort and adjust the weight of certain keywords in a prompt.",tt,N,lt,j,st,Y,kl="New diffusion models do a pretty good job of generating high-quality images from a basic prompt, but it is still important to create a well-written prompt to get the best results. Here are a few tips for writing a good prompt:",at,F,_l="<li>What is the image <em>medium</em>? Is it a photo, a painting, a 3D illustration, or something else?</li> <li>What is the image <em>subject</em>? Is it a person, animal, object, or scene?</li> <li>What <em>details</em> would you like to see in the image? This is where you can get really creative and have a lot of fun experimenting with different words to bring your image to life. For example, what is the lighting like? What is the vibe and aesthetic? What kind of art or illustration style are you looking for? The more specific and precise words you use, the better the model will understand what you want to generate.</li>",nt,U,Gl='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/plain-prompt.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">&quot;A photo of a banana-shaped couch in a living room&quot;</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/detail-prompt.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">&quot;A vibrant yellow banana-shaped couch sits in a cozy living room, its curve cradling a pile of colorful cushions. on the wooden floor, a patterned rug adds a touch of eclectic charm, and a potted plant sits in the corner, reaching towards the sunlight filtering through the windows&quot;</figcaption></div>',it,E,ot,z,Xl="Prompt enhancing is a technique for quickly improving prompt quality without spending too much effort constructing one. It uses a model like GPT2 pretrained on Stable Diffusion text prompts to automatically enrich a prompt with additional important keywords to generate high-quality images.",pt,S,$l="The technique works by curating a list of specific keywords and forcing the model to generate those words to enhance the original prompt. This way, your prompt can be “a cat” and GPT2 can enhance the prompt to “cinematic film still of a cat basking in the sun on a roof in Turkey, highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain quality sharp focus beautiful detailed intricate stunning amazing epic”.",rt,I,ct,A,Vl='Start by defining certain styles and a list of words (you can check out a more comprehensive list of <a href="https://hf.co/LykosAI/GPT-Prompt-Expansion-Fooocus-v2/blob/main/positive.txt" rel="nofollow">words</a> and <a href="https://github.com/lllyasviel/Fooocus/tree/main/sdxl_styles" rel="nofollow">styles</a> used by Fooocus) to enhance a prompt with.',mt,L,Mt,D,Rl="You may have noticed in the <code>words</code> list, there are certain words that can be paired together to create something more meaningful. For example, the words “high” and “quality” can be combined to create “high quality”. Let’s pair these words together and remove the words that can’t be paired.",dt,P,yt,K,xl='Next, implement a custom <a href="https://huggingface.co/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor" rel="nofollow">LogitsProcessor</a> class that assigns tokens in the <code>words</code> list a value of 0 and assigns tokens not in the <code>words</code> list a negative value so they aren’t picked during generation. This way, generation is biased towards words in the <code>words</code> list. After a word from the list is used, it is also assigned a negative value so it isn’t picked again.',ut,O,ht,ee,ql="Combine the prompt and the <code>cinematic</code> style prompt defined in the <code>styles</code> dictionary earlier.",ft,te,Jt,le,Hl='Load a GPT2 tokenizer and model from the <a href="https://huggingface.co/Gustavosta/MagicPrompt-Stable-Diffusion" rel="nofollow">Gustavosta/MagicPrompt-Stable-Diffusion</a> checkpoint (this specific checkpoint is trained to generate prompts) to enhance the prompt.',wt,se,bt,ae,Ql="Then you can combine the input prompt and the generated prompt. Feel free to take a look at what the generated prompt (<code>generated_part</code>) is, the word pairs that were found (<code>pairs</code>), and the remaining words (<code>words</code>). This is all packed together in the <code>enhanced_prompt</code>.",Tt,ne,gt,ie,Nl="Finally, load a pipeline and the offset noise LoRA with a <em>low weight</em> to generate an image with the enhanced prompt.",jt,oe,Ut,Z,Yl='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/non-enhanced-prompt.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">&quot;a cat basking in the sun on a roof in Turkey&quot;</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/enhanced-prompt.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">&quot;cinematic film still of a cat basking in the sun on a roof in Turkey, highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain&quot;</figcaption></div>',It,pe,Zt,re,Fl='Prompt weighting provides a way to emphasize or de-emphasize certain parts of a prompt, allowing for more control over the generated image. A prompt can include several concepts, which gets turned into contextualized text embeddings. The embeddings are used by the model to condition its cross-attention layers to generate an image (read the Stable Diffusion <a href="https://huggingface.co/blog/stable_diffusion" rel="nofollow">blog post</a> to learn more about how it works).',Ct,ce,El='Prompt weighting works by increasing or decreasing the scale of the text embedding vector that corresponds to its concept in the prompt because you may not necessarily want the model to focus on all concepts equally. The easiest way to prepare the prompt-weighted embeddings is to use <a href="https://github.com/damian0815/compel" rel="nofollow">Compel</a>, a text prompt-weighting and blending library. Once you have the prompt-weighted embeddings, you can pass them to any pipeline that has a <a href="https://huggingface.co/docs/diffusers/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline.__call__.prompt_embeds" rel="nofollow"><code>prompt_embeds</code></a> (and optionally <a href="https://huggingface.co/docs/diffusers/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline.__call__.negative_prompt_embeds" rel="nofollow"><code>negative_prompt_embeds</code></a>) parameter, such as <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>, <a href="/docs/diffusers/main/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline">StableDiffusionControlNetPipeline</a>, and <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a>.',Wt,C,vt,me,zl="This guide will show you how to weight and blend your prompts with Compel in 🤗 Diffusers.",Bt,Me,Sl="Before you begin, make sure you have the latest version of Compel installed:",kt,de,_t,ye,Al='For this guide, let’s generate an image with the prompt <code>&quot;a red cat playing with a ball&quot;</code> using the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>:',Gt,ue,Xt,W,Ll='<img class="rounded-xl" src="https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/compel/forest_0.png"/>',$t,he,Vt,fe,Dl='You’ll notice there is no “ball” in the image! Let’s use compel to upweight the concept of “ball” in the prompt. Create a <a href="https://github.com/damian0815/compel/blob/main/doc/compel.md#compel-objects" rel="nofollow"><code>Compel</code></a> object, and pass it a tokenizer and text encoder:',Rt,Je,xt,we,Pl="compel uses <code>+</code> or <code>-</code> to increase or decrease the weight of a word in the prompt. To increase the weight of “ball”:",qt,v,Ht,be,Qt,Te,Kl="Pass the prompt to <code>compel_proc</code> to create the new prompt embeddings which are passed to the pipeline:",Nt,ge,Yt,B,Ol='<img class="rounded-xl" src="https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/compel/forest_1.png"/>',Ft,je,es="To downweight parts of the prompt, use the <code>-</code> suffix:",Et,Ue,zt,k,ts='<img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/compel-neg.png"/>',St,Ie,ls="You can even up or downweight multiple concepts in the same prompt:",At,Ze,Lt,_,ss='<img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/compel-pos-neg.png"/>',Dt,Ce,Pt,We,as="You can also create a weighted <em>blend</em> of prompts by adding <code>.blend()</code> to a list of prompts and passing it some weights. Your blend may not always produce the result you expect because it breaks some assumptions about how the text encoder functions, so just have fun and experiment with it!",Kt,ve,Ot,G,ns='<img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/compel-blend.png"/>',el,Be,tl,ke,is="A conjunction diffuses each prompt independently and concatenates their results by their weighted sum. Add <code>.and()</code> to the end of a list of prompts to create a conjunction:",ll,_e,sl,X,os='<img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/compel-conj.png"/>',al,Ge,nl,Xe,ps='<a href="../training/text_inversion">Textual inversion</a> is a technique for learning a specific concept from some images which you can use to generate new images conditioned on that concept.',il,$e,rs='Create a pipeline and use the <a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> function to load the textual inversion embeddings (feel free to browse the <a href="https://huggingface.co/spaces/sd-concepts-library/stable-diffusion-conceptualizer" rel="nofollow">Stable Diffusion Conceptualizer</a> for 100+ trained concepts):',ol,Ve,pl,Re,cs="Compel provides a <code>DiffusersTextualInversionManager</code> class to simplify prompt weighting with textual inversion. Instantiate <code>DiffusersTextualInversionManager</code> and pass it to the <code>Compel</code> class:",rl,xe,cl,qe,ms="Incorporate the concept to condition a prompt with using the <code>&lt;concept&gt;</code> syntax:",ml,He,Ml,$,Ms='<img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/compel-text-inversion.png"/>',dl,Qe,yl,Ne,ds='<a href="../training/dreambooth">DreamBooth</a> is a technique for generating contextualized images of a subject given just a few images of the subject to train on. It is similar to textual inversion, but DreamBooth trains the full model whereas textual inversion only fine-tunes the text embeddings. This means you should use <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> to load the DreamBooth model (feel free to browse the <a href="https://huggingface.co/sd-dreambooth-library" rel="nofollow">Stable Diffusion Dreambooth Concepts Library</a> for 100+ trained models):',ul,Ye,hl,Fe,ys="Create a <code>Compel</code> class with a tokenizer and text encoder, and pass your prompt to it. Depending on the model you use, you’ll need to incorporate the model’s unique identifier into your prompt. For example, the <code>dndcoverart-v1</code> model uses the identifier <code>dndcoverart</code>:",fl,Ee,Jl,V,us='<img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/compel-dreambooth.png"/>',wl,ze,bl,Se,hs="Stable Diffusion XL (SDXL) has two tokenizers and text encoders so it’s usage is a bit different. To address this, you should pass both tokenizers and encoders to the <code>Compel</code> class:",Tl,Ae,gl,Le,fs='This time, let’s upweight “ball” by a factor of 1.5 for the first prompt, and downweight “ball” by 0.6 for the second prompt. The <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a> also requires <a href="https://huggingface.co/docs/diffusers/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLInpaintPipeline.__call__.pooled_prompt_embeds" rel="nofollow"><code>pooled_prompt_embeds</code></a> (and optionally <a href="https://huggingface.co/docs/diffusers/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLInpaintPipeline.__call__.negative_pooled_prompt_embeds" rel="nofollow"><code>negative_pooled_prompt_embeds</code></a>) so you should pass those to the pipeline along with the conditioning tensors:',jl,De,Ul,R,Js='<div><img class="rounded-xl" src="https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/compel/sdxl_ball1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">&quot;a red cat playing with a (ball)1.5&quot;</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/compel/sdxl_ball2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">&quot;a red cat playing with a (ball)0.6&quot;</figcaption></div>',Il,Pe,Zl;return x=new g({props:{title:"Prompt techniques",local:"prompt-techniques",headingTag:"h1"}}),q=new Bs({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/weighted_prompts.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/weighted_prompts.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/weighted_prompts.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/weighted_prompts.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/weighted_prompts.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/weighted_prompts.ipynb"}]}}),N=new g({props:{title:"Prompt engineering",local:"prompt-engineering",headingTag:"h2"}}),j=new Cl({props:{warning:!1,$$slots:{default:[ks]},$$scope:{ctx:T}}}),E=new g({props:{title:"Prompt enhancing with GPT2",local:"prompt-enhancing-with-gpt2",headingTag:"h2"}}),I=new Cl({props:{warning:!1,$$slots:{default:[_s]},$$scope:{ctx:T}}}),L=new f({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GenerationConfig, GPT2LMHeadModel, GPT2Tokenizer, LogitsProcessor, LogitsProcessorList
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

styles = {
    <span class="hljs-string">&quot;cinematic&quot;</span>: <span class="hljs-string">&quot;cinematic film still of {prompt}, highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain&quot;</span>,
    <span class="hljs-string">&quot;anime&quot;</span>: <span class="hljs-string">&quot;anime artwork of {prompt}, anime style, key visual, vibrant, studio anime, highly detailed&quot;</span>,
    <span class="hljs-string">&quot;photographic&quot;</span>: <span class="hljs-string">&quot;cinematic photo of {prompt}, 35mm photograph, film, professional, 4k, highly detailed&quot;</span>,
    <span class="hljs-string">&quot;comic&quot;</span>: <span class="hljs-string">&quot;comic of {prompt}, graphic illustration, comic art, graphic novel art, vibrant, highly detailed&quot;</span>,
    <span class="hljs-string">&quot;lineart&quot;</span>: <span class="hljs-string">&quot;line art drawing {prompt}, professional, sleek, modern, minimalist, graphic, line art, vector graphics&quot;</span>,
    <span class="hljs-string">&quot;pixelart&quot;</span>: <span class="hljs-string">&quot; pixel-art {prompt}, low-res, blocky, pixel art style, 8-bit graphics&quot;</span>,
}

words = [
    <span class="hljs-string">&quot;aesthetic&quot;</span>, <span class="hljs-string">&quot;astonishing&quot;</span>, <span class="hljs-string">&quot;beautiful&quot;</span>, <span class="hljs-string">&quot;breathtaking&quot;</span>, <span class="hljs-string">&quot;composition&quot;</span>, <span class="hljs-string">&quot;contrasted&quot;</span>, <span class="hljs-string">&quot;epic&quot;</span>, <span class="hljs-string">&quot;moody&quot;</span>, <span class="hljs-string">&quot;enhanced&quot;</span>,
    <span class="hljs-string">&quot;exceptional&quot;</span>, <span class="hljs-string">&quot;fascinating&quot;</span>, <span class="hljs-string">&quot;flawless&quot;</span>, <span class="hljs-string">&quot;glamorous&quot;</span>, <span class="hljs-string">&quot;glorious&quot;</span>, <span class="hljs-string">&quot;illumination&quot;</span>, <span class="hljs-string">&quot;impressive&quot;</span>, <span class="hljs-string">&quot;improved&quot;</span>,
    <span class="hljs-string">&quot;inspirational&quot;</span>, <span class="hljs-string">&quot;magnificent&quot;</span>, <span class="hljs-string">&quot;majestic&quot;</span>, <span class="hljs-string">&quot;hyperrealistic&quot;</span>, <span class="hljs-string">&quot;smooth&quot;</span>, <span class="hljs-string">&quot;sharp&quot;</span>, <span class="hljs-string">&quot;focus&quot;</span>, <span class="hljs-string">&quot;stunning&quot;</span>, <span class="hljs-string">&quot;detailed&quot;</span>,
    <span class="hljs-string">&quot;intricate&quot;</span>, <span class="hljs-string">&quot;dramatic&quot;</span>, <span class="hljs-string">&quot;high&quot;</span>, <span class="hljs-string">&quot;quality&quot;</span>, <span class="hljs-string">&quot;perfect&quot;</span>, <span class="hljs-string">&quot;light&quot;</span>, <span class="hljs-string">&quot;ultra&quot;</span>, <span class="hljs-string">&quot;highly&quot;</span>, <span class="hljs-string">&quot;radiant&quot;</span>, <span class="hljs-string">&quot;satisfying&quot;</span>,
    <span class="hljs-string">&quot;soothing&quot;</span>, <span class="hljs-string">&quot;sophisticated&quot;</span>, <span class="hljs-string">&quot;stylish&quot;</span>, <span class="hljs-string">&quot;sublime&quot;</span>, <span class="hljs-string">&quot;terrific&quot;</span>, <span class="hljs-string">&quot;touching&quot;</span>, <span class="hljs-string">&quot;timeless&quot;</span>, <span class="hljs-string">&quot;wonderful&quot;</span>, <span class="hljs-string">&quot;unbelievable&quot;</span>,
    <span class="hljs-string">&quot;elegant&quot;</span>, <span class="hljs-string">&quot;awesome&quot;</span>, <span class="hljs-string">&quot;amazing&quot;</span>, <span class="hljs-string">&quot;dynamic&quot;</span>, <span class="hljs-string">&quot;trendy&quot;</span>,
]`,wrap:!1}}),P=new f({props:{code:"d29yZF9wYWlycyUyMCUzRCUyMCU1QiUyMmhpZ2hseSUyMGRldGFpbGVkJTIyJTJDJTIwJTIyaGlnaCUyMHF1YWxpdHklMjIlMkMlMjAlMjJlbmhhbmNlZCUyMHF1YWxpdHklMjIlMkMlMjAlMjJwZXJmZWN0JTIwY29tcG9zaXRpb24lMjIlMkMlMjAlMjJkeW5hbWljJTIwbGlnaHQlMjIlNUQlMEElMEFkZWYlMjBmaW5kX2FuZF9vcmRlcl9wYWlycyhzJTJDJTIwcGFpcnMpJTNBJTBBJTIwJTIwJTIwJTIwd29yZHMlMjAlM0QlMjBzLnNwbGl0KCklMEElMjAlMjAlMjAlMjBmb3VuZF9wYWlycyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMjBpbiUyMHBhaXJzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGFpcl93b3JkcyUyMCUzRCUyMHBhaXIuc3BsaXQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwcGFpcl93b3JkcyU1QjAlNUQlMjBpbiUyMHdvcmRzJTIwYW5kJTIwcGFpcl93b3JkcyU1QjElNUQlMjBpbiUyMHdvcmRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm91bmRfcGFpcnMuYXBwZW5kKHBhaXIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd29yZHMucmVtb3ZlKHBhaXJfd29yZHMlNUIwJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdvcmRzLnJlbW92ZShwYWlyX3dvcmRzJTVCMSU1RCklMEElMEElMjAlMjAlMjAlMjBmb3IlMjB3b3JkJTIwaW4lMjB3b3JkcyU1QiUzQSU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMjBpbiUyMHBhaXJzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjB3b3JkJTIwaW4lMjBwYWlyLnNwbGl0KCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3b3Jkcy5yZW1vdmUod29yZCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBicmVhayUwQSUyMCUyMCUyMCUyMG9yZGVyZWRfcGFpcnMlMjAlM0QlMjAlMjIlMkMlMjAlMjIuam9pbihmb3VuZF9wYWlycyklMEElMjAlMjAlMjAlMjByZW1haW5pbmdfcyUyMCUzRCUyMCUyMiUyQyUyMCUyMi5qb2luKHdvcmRzKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG9yZGVyZWRfcGFpcnMlMkMlMjByZW1haW5pbmdfcw==",highlighted:`word_pairs = [<span class="hljs-string">&quot;highly detailed&quot;</span>, <span class="hljs-string">&quot;high quality&quot;</span>, <span class="hljs-string">&quot;enhanced quality&quot;</span>, <span class="hljs-string">&quot;perfect composition&quot;</span>, <span class="hljs-string">&quot;dynamic light&quot;</span>]

<span class="hljs-keyword">def</span> <span class="hljs-title function_">find_and_order_pairs</span>(<span class="hljs-params">s, pairs</span>):
    words = s.split()
    found_pairs = []
    <span class="hljs-keyword">for</span> pair <span class="hljs-keyword">in</span> pairs:
        pair_words = pair.split()
        <span class="hljs-keyword">if</span> pair_words[<span class="hljs-number">0</span>] <span class="hljs-keyword">in</span> words <span class="hljs-keyword">and</span> pair_words[<span class="hljs-number">1</span>] <span class="hljs-keyword">in</span> words:
            found_pairs.append(pair)
            words.remove(pair_words[<span class="hljs-number">0</span>])
            words.remove(pair_words[<span class="hljs-number">1</span>])

    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> words[:]:
        <span class="hljs-keyword">for</span> pair <span class="hljs-keyword">in</span> pairs:
            <span class="hljs-keyword">if</span> word <span class="hljs-keyword">in</span> pair.split():
                words.remove(word)
                <span class="hljs-keyword">break</span>
    ordered_pairs = <span class="hljs-string">&quot;, &quot;</span>.join(found_pairs)
    remaining_s = <span class="hljs-string">&quot;, &quot;</span>.join(words)
    <span class="hljs-keyword">return</span> ordered_pairs, remaining_s`,wrap:!1}}),O=new f({props:{code:"Y2xhc3MlMjBDdXN0b21Mb2dpdHNQcm9jZXNzb3IoTG9naXRzUHJvY2Vzc29yKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBiaWFzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuYmlhcyUyMCUzRCUyMGJpYXMlMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2NhbGxfXyhzZWxmJTJDJTIwaW5wdXRfaWRzJTJDJTIwc2NvcmVzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbGVuKGlucHV0X2lkcy5zaGFwZSklMjAlM0QlM0QlMjAyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFzdF90b2tlbl9pZCUyMCUzRCUyMGlucHV0X2lkcyU1QjAlMkMlMjAtMSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuYmlhcyU1Qmxhc3RfdG9rZW5faWQlNUQlMjAlM0QlMjAtMWUxMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNjb3JlcyUyMCUyQiUyMHNlbGYuYmlhcyUwQSUwQXdvcmRfaWRzJTIwJTNEJTIwJTVCdG9rZW5pemVyLmVuY29kZSh3b3JkJTJDJTIwYWRkX3ByZWZpeF9zcGFjZSUzRFRydWUpJTVCMCU1RCUyMGZvciUyMHdvcmQlMjBpbiUyMHdvcmRzJTVEJTBBYmlhcyUyMCUzRCUyMHRvcmNoLmZ1bGwoKHRva2VuaXplci52b2NhYl9zaXplJTJDKSUyQyUyMC1mbG9hdCglMjJJbmYlMjIpKS50byglMjJjdWRhJTIyKSUwQWJpYXMlNUJ3b3JkX2lkcyU1RCUyMCUzRCUyMDAlMEFwcm9jZXNzb3IlMjAlM0QlMjBDdXN0b21Mb2dpdHNQcm9jZXNzb3IoYmlhcyklMEFwcm9jZXNzb3JfbGlzdCUyMCUzRCUyMExvZ2l0c1Byb2Nlc3Nvckxpc3QoJTVCcHJvY2Vzc29yJTVEKQ==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">CustomLogitsProcessor</span>(<span class="hljs-title class_ inherited__">LogitsProcessor</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, bias</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.bias = bias

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, input_ids, scores</span>):
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(input_ids.shape) == <span class="hljs-number">2</span>:
            last_token_id = input_ids[<span class="hljs-number">0</span>, -<span class="hljs-number">1</span>]
            self.bias[last_token_id] = -<span class="hljs-number">1e10</span>
        <span class="hljs-keyword">return</span> scores + self.bias

word_ids = [tokenizer.encode(word, add_prefix_space=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>] <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> words]
bias = torch.full((tokenizer.vocab_size,), -<span class="hljs-built_in">float</span>(<span class="hljs-string">&quot;Inf&quot;</span>)).to(<span class="hljs-string">&quot;cuda&quot;</span>)
bias[word_ids] = <span class="hljs-number">0</span>
processor = CustomLogitsProcessor(bias)
processor_list = LogitsProcessorList([processor])`,wrap:!1}}),te=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYSUyMGNhdCUyMGJhc2tpbmclMjBpbiUyMHRoZSUyMHN1biUyMG9uJTIwYSUyMHJvb2YlMjBpbiUyMFR1cmtleSUyMiUwQXN0eWxlJTIwJTNEJTIwJTIyY2luZW1hdGljJTIyJTBBJTBBcHJvbXB0JTIwJTNEJTIwc3R5bGVzJTVCc3R5bGUlNUQuZm9ybWF0KHByb21wdCUzRHByb21wdCklMEFwcm9tcHQlMEElMjJjaW5lbWF0aWMlMjBmaWxtJTIwc3RpbGwlMjBvZiUyMGElMjBjYXQlMjBiYXNraW5nJTIwaW4lMjB0aGUlMjBzdW4lMjBvbiUyMGElMjByb29mJTIwaW4lMjBUdXJrZXklMkMlMjBoaWdobHklMjBkZXRhaWxlZCUyQyUyMGhpZ2glMjBidWRnZXQlMjBob2xseXdvb2QlMjBtb3ZpZSUyQyUyMGNpbmVtYXNjb3BlJTJDJTIwbW9vZHklMkMlMjBlcGljJTJDJTIwZ29yZ2VvdXMlMkMlMjBmaWxtJTIwZ3JhaW4lMjI=",highlighted:`prompt = <span class="hljs-string">&quot;a cat basking in the sun on a roof in Turkey&quot;</span>
style = <span class="hljs-string">&quot;cinematic&quot;</span>

prompt = styles[style].<span class="hljs-built_in">format</span>(prompt=prompt)
prompt
<span class="hljs-string">&quot;cinematic film still of a cat basking in the sun on a roof in Turkey, highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain&quot;</span>`,wrap:!1}}),se=new f({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwR1BUMlRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyR3VzdGF2b3N0YSUyRk1hZ2ljUHJvbXB0LVN0YWJsZS1EaWZmdXNpb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBHUFQyTE1IZWFkTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMkd1c3Rhdm9zdGElMkZNYWdpY1Byb21wdC1TdGFibGUtRGlmZnVzaW9uJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KS50byglMEElMjAlMjAlMjAlMjAlMjJjdWRhJTIyJTBBKSUwQW1vZGVsLmV2YWwoKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQXRva2VuX2NvdW50JTIwJTNEJTIwaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVELnNoYXBlJTVCMSU1RCUwQW1heF9uZXdfdG9rZW5zJTIwJTNEJTIwNTAlMjAtJTIwdG9rZW5fY291bnQlMEElMEFnZW5lcmF0aW9uX2NvbmZpZyUyMCUzRCUyMEdlbmVyYXRpb25Db25maWcoJTBBJTIwJTIwJTIwJTIwcGVuYWx0eV9hbHBoYSUzRDAuNyUyQyUwQSUyMCUyMCUyMCUyMHRvcF9rJTNENTAlMkMlMEElMjAlMjAlMjAlMjBlb3NfdG9rZW5faWQlM0Rtb2RlbC5jb25maWcuZW9zX3Rva2VuX2lkJTJDJTBBJTIwJTIwJTIwJTIwcGFkX3Rva2VuX2lkJTNEbW9kZWwuY29uZmlnLmVvc190b2tlbl9pZCUyQyUwQSUyMCUyMCUyMCUyMHBhZF90b2tlbiUzRG1vZGVsLmNvbmZpZy5wYWRfdG9rZW5faWQlMkMlMEElMjAlMjAlMjAlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTBBKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRfaWRzJTNEaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXR0ZW50aW9uX21hc2slM0RpbnB1dHMlNUIlMjJhdHRlbnRpb25fbWFzayUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEbWF4X25ld190b2tlbnMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnZW5lcmF0aW9uX2NvbmZpZyUzRGdlbmVyYXRpb25fY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzX3Byb2Nlc3NvciUzRHByb2NjZXNvcl9saXN0JTJDJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;Gustavosta/MagicPrompt-Stable-Diffusion&quot;</span>)
model = GPT2LMHeadModel.from_pretrained(<span class="hljs-string">&quot;Gustavosta/MagicPrompt-Stable-Diffusion&quot;</span>, torch_dtype=torch.float16).to(
    <span class="hljs-string">&quot;cuda&quot;</span>
)
model.<span class="hljs-built_in">eval</span>()

inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
token_count = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[<span class="hljs-number">1</span>]
max_new_tokens = <span class="hljs-number">50</span> - token_count

generation_config = GenerationConfig(
    penalty_alpha=<span class="hljs-number">0.7</span>,
    top_k=<span class="hljs-number">50</span>,
    eos_token_id=model.config.eos_token_id,
    pad_token_id=model.config.eos_token_id,
    pad_token=model.config.pad_token_id,
    do_sample=<span class="hljs-literal">True</span>,
)

<span class="hljs-keyword">with</span> torch.no_grad():
    generated_ids = model.generate(
        input_ids=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>],
        attention_mask=inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>],
        max_new_tokens=max_new_tokens,
        generation_config=generation_config,
        logits_processor=proccesor_list,
    )`,wrap:!1}}),ne=new f({props:{code:"b3V0cHV0X3Rva2VucyUyMCUzRCUyMCU1QnRva2VuaXplci5kZWNvZGUoZ2VuZXJhdGVkX2lkJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTIwZm9yJTIwZ2VuZXJhdGVkX2lkJTIwaW4lMjBnZW5lcmF0ZWRfaWRzJTVEJTBBaW5wdXRfcGFydCUyQyUyMGdlbmVyYXRlZF9wYXJ0JTIwJTNEJTIwb3V0cHV0X3Rva2VucyU1QjAlNUQlNUIlM0ElMjBsZW4ocHJvbXB0KSU1RCUyQyUyMG91dHB1dF90b2tlbnMlNUIwJTVEJTVCbGVuKHByb21wdCklMjAlM0ElNUQlMEFwYWlycyUyQyUyMHdvcmRzJTIwJTNEJTIwZmluZF9hbmRfb3JkZXJfcGFpcnMoZ2VuZXJhdGVkX3BhcnQlMkMlMjB3b3JkX3BhaXJzKSUwQWZvcm1hdHRlZF9nZW5lcmF0ZWRfcGFydCUyMCUzRCUyMHBhaXJzJTIwJTJCJTIwJTIyJTJDJTIwJTIyJTIwJTJCJTIwd29yZHMlMEFlbmhhbmNlZF9wcm9tcHQlMjAlM0QlMjBpbnB1dF9wYXJ0JTIwJTJCJTIwJTIyJTJDJTIwJTIyJTIwJTJCJTIwZm9ybWF0dGVkX2dlbmVyYXRlZF9wYXJ0JTBBZW5oYW5jZWRfcHJvbXB0JTBBJTVCJTIyY2luZW1hdGljJTIwZmlsbSUyMHN0aWxsJTIwb2YlMjBhJTIwY2F0JTIwYmFza2luZyUyMGluJTIwdGhlJTIwc3VuJTIwb24lMjBhJTIwcm9vZiUyMGluJTIwVHVya2V5JTJDJTIwaGlnaGx5JTIwZGV0YWlsZWQlMkMlMjBoaWdoJTIwYnVkZ2V0JTIwaG9sbHl3b29kJTIwbW92aWUlMkMlMjBjaW5lbWFzY29wZSUyQyUyMG1vb2R5JTJDJTIwZXBpYyUyQyUyMGdvcmdlb3VzJTJDJTIwZmlsbSUyMGdyYWluJTIwcXVhbGl0eSUyMHNoYXJwJTIwZm9jdXMlMjBiZWF1dGlmdWwlMjBkZXRhaWxlZCUyMGludHJpY2F0ZSUyMHN0dW5uaW5nJTIwYW1hemluZyUyMGVwaWMlMjIlNUQ=",highlighted:`output_tokens = [tokenizer.decode(generated_id, skip_special_tokens=<span class="hljs-literal">True</span>) <span class="hljs-keyword">for</span> generated_id <span class="hljs-keyword">in</span> generated_ids]
input_part, generated_part = output_tokens[<span class="hljs-number">0</span>][: <span class="hljs-built_in">len</span>(prompt)], output_tokens[<span class="hljs-number">0</span>][<span class="hljs-built_in">len</span>(prompt) :]
pairs, words = find_and_order_pairs(generated_part, word_pairs)
formatted_generated_part = pairs + <span class="hljs-string">&quot;, &quot;</span> + words
enhanced_prompt = input_part + <span class="hljs-string">&quot;, &quot;</span> + formatted_generated_part
enhanced_prompt
[<span class="hljs-string">&quot;cinematic film still of a cat basking in the sun on a roof in Turkey, highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain quality sharp focus beautiful detailed intricate stunning amazing epic&quot;</span>]`,wrap:!1}}),oe=new f({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJSdW5EaWZmdXNpb24lMkZKdWdnZXJuYXV0LVhMLXY5JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcGlwZWxpbmUubG9hZF9sb3JhX3dlaWdodHMoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwd2VpZ2h0X25hbWUlM0QlMjJzZF94bF9vZmZzZXRfZXhhbXBsZS1sb3JhXzEuMC5zYWZldGVuc29ycyUyMiUyQyUwQSUyMCUyMCUyMCUyMGFkYXB0ZXJfbmFtZSUzRCUyMm9mZnNldCUyMiUyQyUwQSklMEFwaXBlbGluZS5zZXRfYWRhcHRlcnMoJTVCJTIyb2Zmc2V0JTIyJTVEJTJDJTIwYWRhcHRlcl93ZWlnaHRzJTNEJTVCMC4yJTVEKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwZW5oYW5jZWRfcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0QxMTUyJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNEODk2JTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q3LjUlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjUlMkMlMEEpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;RunDiffusion/Juggernaut-XL-v9&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipeline.load_lora_weights(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    weight_name=<span class="hljs-string">&quot;sd_xl_offset_example-lora_1.0.safetensors&quot;</span>,
    adapter_name=<span class="hljs-string">&quot;offset&quot;</span>,
)
pipeline.set_adapters([<span class="hljs-string">&quot;offset&quot;</span>], adapter_weights=[<span class="hljs-number">0.2</span>])

image = pipeline(
    enhanced_prompt,
    width=<span class="hljs-number">1152</span>,
    height=<span class="hljs-number">896</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),pe=new g({props:{title:"Prompt weighting",local:"prompt-weighting",headingTag:"h2"}}),C=new Cl({props:{$$slots:{default:[Gs]},$$scope:{ctx:T}}}),de=new f({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwaW4lMjBDb2xhYiUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwY29tcGVsJTIwLS11cGdyYWRl",highlighted:`<span class="hljs-comment"># uncomment to install in Colab</span>
<span class="hljs-comment">#!pip install compel --upgrade</span>`,wrap:!1}}),ue=new f({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTJDJTIwVW5pUENNdWx0aXN0ZXBTY2hlZHVsZXIlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNCUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjByZWQlMjBjYXQlMjBwbGF5aW5nJTIwd2l0aCUyMGElMjBiYWxsJTIyJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoMzMpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyMCkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, UniPCMultistepScheduler
<span class="hljs-keyword">import</span> torch

pipe = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)
pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;a red cat playing with a ball&quot;</span>

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">33</span>)

image = pipe(prompt, generator=generator, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),he=new g({props:{title:"Weighting",local:"weighting",headingTag:"h3"}}),Je=new f({props:{code:"ZnJvbSUyMGNvbXBlbCUyMGltcG9ydCUyMENvbXBlbCUwQSUwQWNvbXBlbF9wcm9jJTIwJTNEJTIwQ29tcGVsKHRva2VuaXplciUzRHBpcGUudG9rZW5pemVyJTJDJTIwdGV4dF9lbmNvZGVyJTNEcGlwZS50ZXh0X2VuY29kZXIp",highlighted:`<span class="hljs-keyword">from</span> compel <span class="hljs-keyword">import</span> Compel

compel_proc = Compel(tokenizer=pipe.tokenizer, text_encoder=pipe.text_encoder)`,wrap:!1}}),v=new Cl({props:{$$slots:{default:[Xs]},$$scope:{ctx:T}}}),be=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYSUyMHJlZCUyMGNhdCUyMHBsYXlpbmclMjB3aXRoJTIwYSUyMGJhbGwlMkIlMkIlMjI=",highlighted:'prompt = <span class="hljs-string">&quot;a red cat playing with a ball++&quot;</span>',wrap:!1}}),ge=new f({props:{code:"cHJvbXB0X2VtYmVkcyUyMCUzRCUyMGNvbXBlbF9wcm9jKHByb21wdCklMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCgzMyklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0X2VtYmVkcyUzRHByb21wdF9lbWJlZHMlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjApLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`prompt_embeds = compel_proc(prompt)
generator = torch.manual_seed(<span class="hljs-number">33</span>)

image = pipe(prompt_embeds=prompt_embeds, generator=generator, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Ue=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYSUyMHJlZC0tLS0tLS0lMjBjYXQlMjBwbGF5aW5nJTIwd2l0aCUyMGElMjBiYWxsJTIyJTBBcHJvbXB0X2VtYmVkcyUyMCUzRCUyMGNvbXBlbF9wcm9jKHByb21wdCklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCgzMyklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0X2VtYmVkcyUzRHByb21wdF9lbWJlZHMlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjApLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`prompt = <span class="hljs-string">&quot;a red------- cat playing with a ball&quot;</span>
prompt_embeds = compel_proc(prompt)

generator = torch.manual_seed(<span class="hljs-number">33</span>)

image = pipe(prompt_embeds=prompt_embeds, generator=generator, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Ze=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYSUyMHJlZCUyMGNhdCUyQiUyQiUyMHBsYXlpbmclMjB3aXRoJTIwYSUyMGJhbGwtLS0tJTIyJTBBcHJvbXB0X2VtYmVkcyUyMCUzRCUyMGNvbXBlbF9wcm9jKHByb21wdCklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCgzMyklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0X2VtYmVkcyUzRHByb21wdF9lbWJlZHMlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjApLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`prompt = <span class="hljs-string">&quot;a red cat++ playing with a ball----&quot;</span>
prompt_embeds = compel_proc(prompt)

generator = torch.manual_seed(<span class="hljs-number">33</span>)

image = pipe(prompt_embeds=prompt_embeds, generator=generator, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Ce=new g({props:{title:"Blending",local:"blending",headingTag:"h3"}}),ve=new f({props:{code:"cHJvbXB0X2VtYmVkcyUyMCUzRCUyMGNvbXBlbF9wcm9jKCcoJTIyYSUyMHJlZCUyMGNhdCUyMHBsYXlpbmclMjB3aXRoJTIwYSUyMGJhbGwlMjIlMkMlMjAlMjJqdW5nbGUlMjIpLmJsZW5kKDAuNyUyQyUyMDAuOCknKSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjdWRhJTIyKS5tYW51YWxfc2VlZCgzMyklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0X2VtYmVkcyUzRHByb21wdF9lbWJlZHMlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjApLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`prompt_embeds = compel_proc(<span class="hljs-string">&#x27;(&quot;a red cat playing with a ball&quot;, &quot;jungle&quot;).blend(0.7, 0.8)&#x27;</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">33</span>)

image = pipe(prompt_embeds=prompt_embeds, generator=generator, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Be=new g({props:{title:"Conjunction",local:"conjunction",headingTag:"h3"}}),_e=new f({props:{code:"cHJvbXB0X2VtYmVkcyUyMCUzRCUyMGNvbXBlbF9wcm9jKCclNUIlMjJhJTIwcmVkJTIwY2F0JTIyJTJDJTIwJTIycGxheWluZyUyMHdpdGglMjBhJTIyJTJDJTIwJTIyYmFsbCUyMiU1RC5hbmQoKScpJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDU1KSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHRfZW1iZWRzJTNEcHJvbXB0X2VtYmVkcyUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyMCkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`prompt_embeds = compel_proc(<span class="hljs-string">&#x27;[&quot;a red cat&quot;, &quot;playing with a&quot;, &quot;ball&quot;].and()&#x27;</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">55</span>)

image = pipe(prompt_embeds=prompt_embeds, generator=generator, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Ge=new g({props:{title:"Textual inversion",local:"textual-inversion",headingTag:"h3"}}),Ve=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwY29tcGVsJTIwaW1wb3J0JTIwQ29tcGVsJTJDJTIwRGlmZnVzZXJzVGV4dHVhbEludmVyc2lvbk1hbmFnZXIlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyKS50byglMjJjdWRhJTIyKSUwQXBpcGUubG9hZF90ZXh0dWFsX2ludmVyc2lvbiglMjJzZC1jb25jZXB0cy1saWJyYXJ5JTJGbWlkam91cm5leS1zdHlsZSUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">from</span> compel <span class="hljs-keyword">import</span> Compel, DiffusersTextualInversionManager

pipe = StableDiffusionPipeline.from_pretrained(
  <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16,
  use_safetensors=<span class="hljs-literal">True</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/midjourney-style&quot;</span>)`,wrap:!1}}),xe=new f({props:{code:"dGV4dHVhbF9pbnZlcnNpb25fbWFuYWdlciUyMCUzRCUyMERpZmZ1c2Vyc1RleHR1YWxJbnZlcnNpb25NYW5hZ2VyKHBpcGUpJTBBY29tcGVsX3Byb2MlMjAlM0QlMjBDb21wZWwoJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEcGlwZS50b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjB0ZXh0X2VuY29kZXIlM0RwaXBlLnRleHRfZW5jb2RlciUyQyUwQSUyMCUyMCUyMCUyMHRleHR1YWxfaW52ZXJzaW9uX21hbmFnZXIlM0R0ZXh0dWFsX2ludmVyc2lvbl9tYW5hZ2VyKQ==",highlighted:`textual_inversion_manager = DiffusersTextualInversionManager(pipe)
compel_proc = Compel(
    tokenizer=pipe.tokenizer,
    text_encoder=pipe.text_encoder,
    textual_inversion_manager=textual_inversion_manager)`,wrap:!1}}),He=new f({props:{code:"cHJvbXB0X2VtYmVkcyUyMCUzRCUyMGNvbXBlbF9wcm9jKCcoJTIyQSUyMHJlZCUyMGNhdCUyQiUyQiUyMHBsYXlpbmclMjB3aXRoJTIwYSUyMGJhbGwlMjAlM0NtaWRqb3VybmV5LXN0eWxlJTNFJTIyKScpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdF9lbWJlZHMlM0Rwcm9tcHRfZW1iZWRzKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`prompt_embeds = compel_proc(<span class="hljs-string">&#x27;(&quot;A red cat++ playing with a ball &lt;midjourney-style&gt;&quot;)&#x27;</span>)

image = pipe(prompt_embeds=prompt_embeds).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Qe=new g({props:{title:"DreamBooth",local:"dreambooth",headingTag:"h3"}}),Ye=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlciUwQWZyb20lMjBjb21wZWwlMjBpbXBvcnQlMjBDb21wZWwlMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkLWRyZWFtYm9vdGgtbGlicmFyeSUyRmRuZGNvdmVyYXJ0LXYxJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KS50byglMjJjdWRhJTIyKSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwVW5pUENNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, UniPCMultistepScheduler
<span class="hljs-keyword">from</span> compel <span class="hljs-keyword">import</span> Compel

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;sd-dreambooth-library/dndcoverart-v1&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)`,wrap:!1}}),Ee=new f({props:{code:"Y29tcGVsX3Byb2MlMjAlM0QlMjBDb21wZWwodG9rZW5pemVyJTNEcGlwZS50b2tlbml6ZXIlMkMlMjB0ZXh0X2VuY29kZXIlM0RwaXBlLnRleHRfZW5jb2RlciklMEFwcm9tcHRfZW1iZWRzJTIwJTNEJTIwY29tcGVsX3Byb2MoJyglMjJtYWdhemluZSUyMGNvdmVyJTIwb2YlMjBhJTIwZG5kY292ZXJhcnQlMjBkcmFnb24lMkMlMjBoaWdoJTIwcXVhbGl0eSUyQyUyMGludHJpY2F0ZSUyMGRldGFpbHMlMkMlMjBsYXJyeSUyMGVsbW9yZSUyMGFydCUyMHN0eWxlJTIyKS5hbmQoKScpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdF9lbWJlZHMlM0Rwcm9tcHRfZW1iZWRzKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`compel_proc = Compel(tokenizer=pipe.tokenizer, text_encoder=pipe.text_encoder)
prompt_embeds = compel_proc(<span class="hljs-string">&#x27;(&quot;magazine cover of a dndcoverart dragon, high quality, intricate details, larry elmore art style&quot;).and()&#x27;</span>)
image = pipe(prompt_embeds=prompt_embeds).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),ze=new g({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h3"}}),Ae=new f({props:{code:"ZnJvbSUyMGNvbXBlbCUyMGltcG9ydCUyMENvbXBlbCUyQyUyMFJldHVybmVkRW1iZWRkaW5nc1R5cGUlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUwQSUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEElMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBY29tcGVsJTIwJTNEJTIwQ29tcGVsKCUwQSUyMCUyMHRva2VuaXplciUzRCU1QnBpcGVsaW5lLnRva2VuaXplciUyQyUyMHBpcGVsaW5lLnRva2VuaXplcl8yJTVEJTIwJTJDJTBBJTIwJTIwdGV4dF9lbmNvZGVyJTNEJTVCcGlwZWxpbmUudGV4dF9lbmNvZGVyJTJDJTIwcGlwZWxpbmUudGV4dF9lbmNvZGVyXzIlNUQlMkMlMEElMjAlMjByZXR1cm5lZF9lbWJlZGRpbmdzX3R5cGUlM0RSZXR1cm5lZEVtYmVkZGluZ3NUeXBlLlBFTlVMVElNQVRFX0hJRERFTl9TVEFURVNfTk9OX05PUk1BTElaRUQlMkMlMEElMjAlMjByZXF1aXJlc19wb29sZWQlM0QlNUJGYWxzZSUyQyUyMFRydWUlNUQlMEEp",highlighted:`<span class="hljs-keyword">from</span> compel <span class="hljs-keyword">import</span> Compel, ReturnedEmbeddingsType
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid
<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(
  <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
  variant=<span class="hljs-string">&quot;fp16&quot;</span>,
  use_safetensors=<span class="hljs-literal">True</span>,
  torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

compel = Compel(
  tokenizer=[pipeline.tokenizer, pipeline.tokenizer_2] ,
  text_encoder=[pipeline.text_encoder, pipeline.text_encoder_2],
  returned_embeddings_type=ReturnedEmbeddingsType.PENULTIMATE_HIDDEN_STATES_NON_NORMALIZED,
  requires_pooled=[<span class="hljs-literal">False</span>, <span class="hljs-literal">True</span>]
)`,wrap:!1}}),De=new f({props:{code:"JTIzJTIwYXBwbHklMjB3ZWlnaHRzJTBBcHJvbXB0JTIwJTNEJTIwJTVCJTIyYSUyMHJlZCUyMGNhdCUyMHBsYXlpbmclMjB3aXRoJTIwYSUyMChiYWxsKTEuNSUyMiUyQyUyMCUyMmElMjByZWQlMjBjYXQlMjBwbGF5aW5nJTIwd2l0aCUyMGElMjAoYmFsbCkwLjYlMjIlNUQlMEFjb25kaXRpb25pbmclMkMlMjBwb29sZWQlMjAlM0QlMjBjb21wZWwocHJvbXB0KSUwQSUwQSUyMyUyMGdlbmVyYXRlJTIwaW1hZ2UlMEFnZW5lcmF0b3IlMjAlM0QlMjAlNUJ0b3JjaC5HZW5lcmF0b3IoKS5tYW51YWxfc2VlZCgzMyklMjBmb3IlMjBfJTIwaW4lMjByYW5nZShsZW4ocHJvbXB0KSklNUQlMEFpbWFnZXMlMjAlM0QlMjBwaXBlbGluZShwcm9tcHRfZW1iZWRzJTNEY29uZGl0aW9uaW5nJTJDJTIwcG9vbGVkX3Byb21wdF9lbWJlZHMlM0Rwb29sZWQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMzApLmltYWdlcyUwQW1ha2VfaW1hZ2VfZ3JpZChpbWFnZXMlMkMlMjByb3dzJTNEMSUyQyUyMGNvbHMlM0QyKQ==",highlighted:`<span class="hljs-comment"># apply weights</span>
prompt = [<span class="hljs-string">&quot;a red cat playing with a (ball)1.5&quot;</span>, <span class="hljs-string">&quot;a red cat playing with a (ball)0.6&quot;</span>]
conditioning, pooled = compel(prompt)

<span class="hljs-comment"># generate image</span>
generator = [torch.Generator().manual_seed(<span class="hljs-number">33</span>) <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(prompt))]
images = pipeline(prompt_embeds=conditioning, pooled_prompt_embeds=pooled, generator=generator, num_inference_steps=<span class="hljs-number">30</span>).images
make_image_grid(images, rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),{c(){r=i("meta"),J=a(),h=i("p"),b=a(),c(x.$$.fragment),Ke=a(),c(q.$$.fragment),Oe=a(),H=i("p"),H.textContent=vl,et=a(),Q=i("p"),Q.textContent=Bl,tt=a(),c(N.$$.fragment),lt=a(),c(j.$$.fragment),st=a(),Y=i("p"),Y.textContent=kl,at=a(),F=i("ol"),F.innerHTML=_l,nt=a(),U=i("div"),U.innerHTML=Gl,it=a(),c(E.$$.fragment),ot=a(),z=i("p"),z.textContent=Xl,pt=a(),S=i("p"),S.textContent=$l,rt=a(),c(I.$$.fragment),ct=a(),A=i("p"),A.innerHTML=Vl,mt=a(),c(L.$$.fragment),Mt=a(),D=i("p"),D.innerHTML=Rl,dt=a(),c(P.$$.fragment),yt=a(),K=i("p"),K.innerHTML=xl,ut=a(),c(O.$$.fragment),ht=a(),ee=i("p"),ee.innerHTML=ql,ft=a(),c(te.$$.fragment),Jt=a(),le=i("p"),le.innerHTML=Hl,wt=a(),c(se.$$.fragment),bt=a(),ae=i("p"),ae.innerHTML=Ql,Tt=a(),c(ne.$$.fragment),gt=a(),ie=i("p"),ie.innerHTML=Nl,jt=a(),c(oe.$$.fragment),Ut=a(),Z=i("div"),Z.innerHTML=Yl,It=a(),c(pe.$$.fragment),Zt=a(),re=i("p"),re.innerHTML=Fl,Ct=a(),ce=i("p"),ce.innerHTML=El,Wt=a(),c(C.$$.fragment),vt=a(),me=i("p"),me.textContent=zl,Bt=a(),Me=i("p"),Me.textContent=Sl,kt=a(),c(de.$$.fragment),_t=a(),ye=i("p"),ye.innerHTML=Al,Gt=a(),c(ue.$$.fragment),Xt=a(),W=i("div"),W.innerHTML=Ll,$t=a(),c(he.$$.fragment),Vt=a(),fe=i("p"),fe.innerHTML=Dl,Rt=a(),c(Je.$$.fragment),xt=a(),we=i("p"),we.innerHTML=Pl,qt=a(),c(v.$$.fragment),Ht=a(),c(be.$$.fragment),Qt=a(),Te=i("p"),Te.innerHTML=Kl,Nt=a(),c(ge.$$.fragment),Yt=a(),B=i("div"),B.innerHTML=Ol,Ft=a(),je=i("p"),je.innerHTML=es,Et=a(),c(Ue.$$.fragment),zt=a(),k=i("div"),k.innerHTML=ts,St=a(),Ie=i("p"),Ie.textContent=ls,At=a(),c(Ze.$$.fragment),Lt=a(),_=i("div"),_.innerHTML=ss,Dt=a(),c(Ce.$$.fragment),Pt=a(),We=i("p"),We.innerHTML=as,Kt=a(),c(ve.$$.fragment),Ot=a(),G=i("div"),G.innerHTML=ns,el=a(),c(Be.$$.fragment),tl=a(),ke=i("p"),ke.innerHTML=is,ll=a(),c(_e.$$.fragment),sl=a(),X=i("div"),X.innerHTML=os,al=a(),c(Ge.$$.fragment),nl=a(),Xe=i("p"),Xe.innerHTML=ps,il=a(),$e=i("p"),$e.innerHTML=rs,ol=a(),c(Ve.$$.fragment),pl=a(),Re=i("p"),Re.innerHTML=cs,rl=a(),c(xe.$$.fragment),cl=a(),qe=i("p"),qe.innerHTML=ms,ml=a(),c(He.$$.fragment),Ml=a(),$=i("div"),$.innerHTML=Ms,dl=a(),c(Qe.$$.fragment),yl=a(),Ne=i("p"),Ne.innerHTML=ds,ul=a(),c(Ye.$$.fragment),hl=a(),Fe=i("p"),Fe.innerHTML=ys,fl=a(),c(Ee.$$.fragment),Jl=a(),V=i("div"),V.innerHTML=us,wl=a(),c(ze.$$.fragment),bl=a(),Se=i("p"),Se.innerHTML=hs,Tl=a(),c(Ae.$$.fragment),gl=a(),Le=i("p"),Le.innerHTML=fs,jl=a(),c(De.$$.fragment),Ul=a(),R=i("div"),R.innerHTML=Js,Il=a(),Pe=i("p"),this.h()},l(e){const t=Ws("svelte-u9bgzb",document.head);r=o(t,"META",{name:!0,content:!0}),t.forEach(l),J=n(e),h=o(e,"P",{}),js(h).forEach(l),b=n(e),m(x.$$.fragment,e),Ke=n(e),m(q.$$.fragment,e),Oe=n(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1kbqxv6"&&(H.textContent=vl),et=n(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-6johch"&&(Q.textContent=Bl),tt=n(e),m(N.$$.fragment,e),lt=n(e),m(j.$$.fragment,e),st=n(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1c7rxt1"&&(Y.textContent=kl),at=n(e),F=o(e,"OL",{"data-svelte-h":!0}),p(F)!=="svelte-1cs1rnw"&&(F.innerHTML=_l),nt=n(e),U=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(U)!=="svelte-ahartp"&&(U.innerHTML=Gl),it=n(e),m(E.$$.fragment,e),ot=n(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-dttsfg"&&(z.textContent=Xl),pt=n(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-j8rp3s"&&(S.textContent=$l),rt=n(e),m(I.$$.fragment,e),ct=n(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-l7cdn9"&&(A.innerHTML=Vl),mt=n(e),m(L.$$.fragment,e),Mt=n(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-i0sn10"&&(D.innerHTML=Rl),dt=n(e),m(P.$$.fragment,e),yt=n(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-117it8a"&&(K.innerHTML=xl),ut=n(e),m(O.$$.fragment,e),ht=n(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-3e511v"&&(ee.innerHTML=ql),ft=n(e),m(te.$$.fragment,e),Jt=n(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1kowtsg"&&(le.innerHTML=Hl),wt=n(e),m(se.$$.fragment,e),bt=n(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-r4gy79"&&(ae.innerHTML=Ql),Tt=n(e),m(ne.$$.fragment,e),gt=n(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-14szpok"&&(ie.innerHTML=Nl),jt=n(e),m(oe.$$.fragment,e),Ut=n(e),Z=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(Z)!=="svelte-12k1k80"&&(Z.innerHTML=Yl),It=n(e),m(pe.$$.fragment,e),Zt=n(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1tre73w"&&(re.innerHTML=Fl),Ct=n(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1xwkuku"&&(ce.innerHTML=El),Wt=n(e),m(C.$$.fragment,e),vt=n(e),me=o(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-xw5jy8"&&(me.textContent=zl),Bt=n(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1tbon0u"&&(Me.textContent=Sl),kt=n(e),m(de.$$.fragment,e),_t=n(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-166vpmt"&&(ye.innerHTML=Al),Gt=n(e),m(ue.$$.fragment,e),Xt=n(e),W=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(W)!=="svelte-1brza9b"&&(W.innerHTML=Ll),$t=n(e),m(he.$$.fragment,e),Vt=n(e),fe=o(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-137cdqc"&&(fe.innerHTML=Dl),Rt=n(e),m(Je.$$.fragment,e),xt=n(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-18ay2r3"&&(we.innerHTML=Pl),qt=n(e),m(v.$$.fragment,e),Ht=n(e),m(be.$$.fragment,e),Qt=n(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-vulem2"&&(Te.innerHTML=Kl),Nt=n(e),m(ge.$$.fragment,e),Yt=n(e),B=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(B)!=="svelte-17zkpq4"&&(B.innerHTML=Ol),Ft=n(e),je=o(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-gxkdpi"&&(je.innerHTML=es),Et=n(e),m(Ue.$$.fragment,e),zt=n(e),k=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(k)!=="svelte-1d7lfen"&&(k.innerHTML=ts),St=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-1f6exw0"&&(Ie.textContent=ls),At=n(e),m(Ze.$$.fragment,e),Lt=n(e),_=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(_)!=="svelte-1qezu4q"&&(_.innerHTML=ss),Dt=n(e),m(Ce.$$.fragment,e),Pt=n(e),We=o(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-1oxm60"&&(We.innerHTML=as),Kt=n(e),m(ve.$$.fragment,e),Ot=n(e),G=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(G)!=="svelte-8v41o8"&&(G.innerHTML=ns),el=n(e),m(Be.$$.fragment,e),tl=n(e),ke=o(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-tjkp7t"&&(ke.innerHTML=is),ll=n(e),m(_e.$$.fragment,e),sl=n(e),X=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(X)!=="svelte-1ycuwub"&&(X.innerHTML=os),al=n(e),m(Ge.$$.fragment,e),nl=n(e),Xe=o(e,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-lcas44"&&(Xe.innerHTML=ps),il=n(e),$e=o(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-1lpoeb9"&&($e.innerHTML=rs),ol=n(e),m(Ve.$$.fragment,e),pl=n(e),Re=o(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-h0g1y9"&&(Re.innerHTML=cs),rl=n(e),m(xe.$$.fragment,e),cl=n(e),qe=o(e,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-1fkpura"&&(qe.innerHTML=ms),ml=n(e),m(He.$$.fragment,e),Ml=n(e),$=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p($)!=="svelte-1awripq"&&($.innerHTML=Ms),dl=n(e),m(Qe.$$.fragment,e),yl=n(e),Ne=o(e,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-d93hmf"&&(Ne.innerHTML=ds),ul=n(e),m(Ye.$$.fragment,e),hl=n(e),Fe=o(e,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-1le33cx"&&(Fe.innerHTML=ys),fl=n(e),m(Ee.$$.fragment,e),Jl=n(e),V=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(V)!=="svelte-zvft88"&&(V.innerHTML=us),wl=n(e),m(ze.$$.fragment,e),bl=n(e),Se=o(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-xo93eu"&&(Se.innerHTML=hs),Tl=n(e),m(Ae.$$.fragment,e),gl=n(e),Le=o(e,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-1jwx5o2"&&(Le.innerHTML=fs),jl=n(e),m(De.$$.fragment,e),Ul=n(e),R=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(R)!=="svelte-idvlgw"&&(R.innerHTML=Js),Il=n(e),Pe=o(e,"P",{}),js(Pe).forEach(l),this.h()},h(){w(r,"name","hf:doc:metadata"),w(r,"content",Vs),w(U,"class","flex gap-4"),w(Z,"class","flex gap-4"),w(W,"class","flex justify-center"),w(B,"class","flex justify-center"),w(k,"class","flex justify-center"),w(_,"class","flex justify-center"),w(G,"class","flex justify-center"),w(X,"class","flex justify-center"),w($,"class","flex justify-center"),w(V,"class","flex justify-center"),w(R,"class","flex gap-4")},m(e,t){vs(document.head,r),s(e,J,t),s(e,h,t),s(e,b,t),M(x,e,t),s(e,Ke,t),M(q,e,t),s(e,Oe,t),s(e,H,t),s(e,et,t),s(e,Q,t),s(e,tt,t),M(N,e,t),s(e,lt,t),M(j,e,t),s(e,st,t),s(e,Y,t),s(e,at,t),s(e,F,t),s(e,nt,t),s(e,U,t),s(e,it,t),M(E,e,t),s(e,ot,t),s(e,z,t),s(e,pt,t),s(e,S,t),s(e,rt,t),M(I,e,t),s(e,ct,t),s(e,A,t),s(e,mt,t),M(L,e,t),s(e,Mt,t),s(e,D,t),s(e,dt,t),M(P,e,t),s(e,yt,t),s(e,K,t),s(e,ut,t),M(O,e,t),s(e,ht,t),s(e,ee,t),s(e,ft,t),M(te,e,t),s(e,Jt,t),s(e,le,t),s(e,wt,t),M(se,e,t),s(e,bt,t),s(e,ae,t),s(e,Tt,t),M(ne,e,t),s(e,gt,t),s(e,ie,t),s(e,jt,t),M(oe,e,t),s(e,Ut,t),s(e,Z,t),s(e,It,t),M(pe,e,t),s(e,Zt,t),s(e,re,t),s(e,Ct,t),s(e,ce,t),s(e,Wt,t),M(C,e,t),s(e,vt,t),s(e,me,t),s(e,Bt,t),s(e,Me,t),s(e,kt,t),M(de,e,t),s(e,_t,t),s(e,ye,t),s(e,Gt,t),M(ue,e,t),s(e,Xt,t),s(e,W,t),s(e,$t,t),M(he,e,t),s(e,Vt,t),s(e,fe,t),s(e,Rt,t),M(Je,e,t),s(e,xt,t),s(e,we,t),s(e,qt,t),M(v,e,t),s(e,Ht,t),M(be,e,t),s(e,Qt,t),s(e,Te,t),s(e,Nt,t),M(ge,e,t),s(e,Yt,t),s(e,B,t),s(e,Ft,t),s(e,je,t),s(e,Et,t),M(Ue,e,t),s(e,zt,t),s(e,k,t),s(e,St,t),s(e,Ie,t),s(e,At,t),M(Ze,e,t),s(e,Lt,t),s(e,_,t),s(e,Dt,t),M(Ce,e,t),s(e,Pt,t),s(e,We,t),s(e,Kt,t),M(ve,e,t),s(e,Ot,t),s(e,G,t),s(e,el,t),M(Be,e,t),s(e,tl,t),s(e,ke,t),s(e,ll,t),M(_e,e,t),s(e,sl,t),s(e,X,t),s(e,al,t),M(Ge,e,t),s(e,nl,t),s(e,Xe,t),s(e,il,t),s(e,$e,t),s(e,ol,t),M(Ve,e,t),s(e,pl,t),s(e,Re,t),s(e,rl,t),M(xe,e,t),s(e,cl,t),s(e,qe,t),s(e,ml,t),M(He,e,t),s(e,Ml,t),s(e,$,t),s(e,dl,t),M(Qe,e,t),s(e,yl,t),s(e,Ne,t),s(e,ul,t),M(Ye,e,t),s(e,hl,t),s(e,Fe,t),s(e,fl,t),M(Ee,e,t),s(e,Jl,t),s(e,V,t),s(e,wl,t),M(ze,e,t),s(e,bl,t),s(e,Se,t),s(e,Tl,t),M(Ae,e,t),s(e,gl,t),s(e,Le,t),s(e,jl,t),M(De,e,t),s(e,Ul,t),s(e,R,t),s(e,Il,t),s(e,Pe,t),Zl=!0},p(e,[t]){const ws={};t&2&&(ws.$$scope={dirty:t,ctx:e}),j.$set(ws);const bs={};t&2&&(bs.$$scope={dirty:t,ctx:e}),I.$set(bs);const Ts={};t&2&&(Ts.$$scope={dirty:t,ctx:e}),C.$set(Ts);const gs={};t&2&&(gs.$$scope={dirty:t,ctx:e}),v.$set(gs)},i(e){Zl||(d(x.$$.fragment,e),d(q.$$.fragment,e),d(N.$$.fragment,e),d(j.$$.fragment,e),d(E.$$.fragment,e),d(I.$$.fragment,e),d(L.$$.fragment,e),d(P.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(se.$$.fragment,e),d(ne.$$.fragment,e),d(oe.$$.fragment,e),d(pe.$$.fragment,e),d(C.$$.fragment,e),d(de.$$.fragment,e),d(ue.$$.fragment,e),d(he.$$.fragment,e),d(Je.$$.fragment,e),d(v.$$.fragment,e),d(be.$$.fragment,e),d(ge.$$.fragment,e),d(Ue.$$.fragment,e),d(Ze.$$.fragment,e),d(Ce.$$.fragment,e),d(ve.$$.fragment,e),d(Be.$$.fragment,e),d(_e.$$.fragment,e),d(Ge.$$.fragment,e),d(Ve.$$.fragment,e),d(xe.$$.fragment,e),d(He.$$.fragment,e),d(Qe.$$.fragment,e),d(Ye.$$.fragment,e),d(Ee.$$.fragment,e),d(ze.$$.fragment,e),d(Ae.$$.fragment,e),d(De.$$.fragment,e),Zl=!0)},o(e){y(x.$$.fragment,e),y(q.$$.fragment,e),y(N.$$.fragment,e),y(j.$$.fragment,e),y(E.$$.fragment,e),y(I.$$.fragment,e),y(L.$$.fragment,e),y(P.$$.fragment,e),y(O.$$.fragment,e),y(te.$$.fragment,e),y(se.$$.fragment,e),y(ne.$$.fragment,e),y(oe.$$.fragment,e),y(pe.$$.fragment,e),y(C.$$.fragment,e),y(de.$$.fragment,e),y(ue.$$.fragment,e),y(he.$$.fragment,e),y(Je.$$.fragment,e),y(v.$$.fragment,e),y(be.$$.fragment,e),y(ge.$$.fragment,e),y(Ue.$$.fragment,e),y(Ze.$$.fragment,e),y(Ce.$$.fragment,e),y(ve.$$.fragment,e),y(Be.$$.fragment,e),y(_e.$$.fragment,e),y(Ge.$$.fragment,e),y(Ve.$$.fragment,e),y(xe.$$.fragment,e),y(He.$$.fragment,e),y(Qe.$$.fragment,e),y(Ye.$$.fragment,e),y(Ee.$$.fragment,e),y(ze.$$.fragment,e),y(Ae.$$.fragment,e),y(De.$$.fragment,e),Zl=!1},d(e){e&&(l(J),l(h),l(b),l(Ke),l(Oe),l(H),l(et),l(Q),l(tt),l(lt),l(st),l(Y),l(at),l(F),l(nt),l(U),l(it),l(ot),l(z),l(pt),l(S),l(rt),l(ct),l(A),l(mt),l(Mt),l(D),l(dt),l(yt),l(K),l(ut),l(ht),l(ee),l(ft),l(Jt),l(le),l(wt),l(bt),l(ae),l(Tt),l(gt),l(ie),l(jt),l(Ut),l(Z),l(It),l(Zt),l(re),l(Ct),l(ce),l(Wt),l(vt),l(me),l(Bt),l(Me),l(kt),l(_t),l(ye),l(Gt),l(Xt),l(W),l($t),l(Vt),l(fe),l(Rt),l(xt),l(we),l(qt),l(Ht),l(Qt),l(Te),l(Nt),l(Yt),l(B),l(Ft),l(je),l(Et),l(zt),l(k),l(St),l(Ie),l(At),l(Lt),l(_),l(Dt),l(Pt),l(We),l(Kt),l(Ot),l(G),l(el),l(tl),l(ke),l(ll),l(sl),l(X),l(al),l(nl),l(Xe),l(il),l($e),l(ol),l(pl),l(Re),l(rl),l(cl),l(qe),l(ml),l(Ml),l($),l(dl),l(yl),l(Ne),l(ul),l(hl),l(Fe),l(fl),l(Jl),l(V),l(wl),l(bl),l(Se),l(Tl),l(gl),l(Le),l(jl),l(Ul),l(R),l(Il),l(Pe)),l(r),u(x,e),u(q,e),u(N,e),u(j,e),u(E,e),u(I,e),u(L,e),u(P,e),u(O,e),u(te,e),u(se,e),u(ne,e),u(oe,e),u(pe,e),u(C,e),u(de,e),u(ue,e),u(he,e),u(Je,e),u(v,e),u(be,e),u(ge,e),u(Ue,e),u(Ze,e),u(Ce,e),u(ve,e),u(Be,e),u(_e,e),u(Ge,e),u(Ve,e),u(xe,e),u(He,e),u(Qe,e),u(Ye,e),u(Ee,e),u(ze,e),u(Ae,e),u(De,e)}}}const Vs='{"title":"Prompt techniques","local":"prompt-techniques","sections":[{"title":"Prompt engineering","local":"prompt-engineering","sections":[],"depth":2},{"title":"Prompt enhancing with GPT2","local":"prompt-enhancing-with-gpt2","sections":[],"depth":2},{"title":"Prompt weighting","local":"prompt-weighting","sections":[{"title":"Weighting","local":"weighting","sections":[],"depth":3},{"title":"Blending","local":"blending","sections":[],"depth":3},{"title":"Conjunction","local":"conjunction","sections":[],"depth":3},{"title":"Textual inversion","local":"textual-inversion","sections":[],"depth":3},{"title":"DreamBooth","local":"dreambooth","sections":[],"depth":3},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[],"depth":3}],"depth":2}],"depth":1}';function Rs(T){return Is(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fs extends Zs{constructor(r){super(),Cs(this,r,Rs,$s,Us,{})}}export{Fs as component};
