import{s as Eo,o as No,n as ae}from"../chunks/scheduler.182ea377.js";import{S as Fo,i as Do,g as r,s as a,r as g,A as Ro,h as l,f as i,c as o,j as M,u,x as y,k as I,y as t,a as p,v as f,d as _,t as h,w as b}from"../chunks/index.abf12888.js";import{T as Bo}from"../chunks/Tip.230e2334.js";import{D as P}from"../chunks/Docstring.93f6f462.js";import{C as xe}from"../chunks/CodeBlock.57fe6e13.js";import{E as Te}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as N}from"../chunks/Heading.16916d63.js";function Qo(T){let s,w='Check out the <a href="https://huggingface.co/kandinsky-community" rel="nofollow">Kandinsky Community</a> organization on the Hub for the official model checkpoints for tasks like text-to-image, image-to-image, and inpainting.';return{c(){s=r("p"),s.innerHTML=w},l(m){s=l(m,"P",{"data-svelte-h":!0}),y(s)!=="svelte-1nfky5i"&&(s.innerHTML=w)},m(m,c){p(m,s,c)},p:ae,d(m){m&&i(s)}}}function Xo(T){let s,w='Make sure to check out the schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){s=r("p"),s.innerHTML=w},l(m){s=l(m,"P",{"data-svelte-h":!0}),y(s)!=="svelte-1rr33yw"&&(s.innerHTML=w)},m(m,c){p(m,s,c)},p:ae,d(m){m&&i(s)}}}function zo(T){let s,w="Examples:",m,c,k;return c=new xe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVYyMlBpcGVsaW5lJTJDJTIwS2FuZGluc2t5VjIyUHJpb3JQaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZV9wcmlvciUyMCUzRCUyMEthbmRpbnNreVYyMlByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLXByaW9yJTIyKSUwQXBpcGVfcHJpb3IudG8oJTIyY3VkYSUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJyZWQlMjBjYXQlMkMlMjA0ayUyMHBob3RvJTIyJTBBaW1hZ2VfZW1iJTJDJTIwbmVnYXRpdmVfaW1hZ2VfZW1iJTIwJTNEJTIwcGlwZV9wcmlvcihwcm9tcHQpLnRvX3R1cGxlKCklMEElMEFwaXBlJTIwJTNEJTIwS2FuZGluc2t5VjIyUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLWRlY29kZXIlMjIpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBpbWFnZV9lbWJlZHMlM0RpbWFnZV9lbWIlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9pbWFnZV9lbWJlZHMlM0RuZWdhdGl2ZV9pbWFnZV9lbWIlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0Q3NjglMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDc2OCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2UlNUIwJTVELnNhdmUoJTIyY2F0LnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyV22Pipeline, KandinskyV22PriorPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyV22PriorPipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-prior&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;red cat, 4k photo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb, negative_image_emb = pipe_prior(prompt).to_tuple()

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyV22Pipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=negative_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).images
<span class="hljs-meta">&gt;&gt;&gt; </span>image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;cat.png&quot;</span>)`,wrap:!1}}),{c(){s=r("p"),s.textContent=w,m=a(),g(c.$$.fragment)},l(n){s=l(n,"P",{"data-svelte-h":!0}),y(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=o(n),u(c.$$.fragment,n)},m(n,v){p(n,s,v),p(n,m,v),f(c,n,v),k=!0},p:ae,i(n){k||(_(c.$$.fragment,n),k=!0)},o(n){h(c.$$.fragment,n),k=!1},d(n){n&&(i(s),i(m)),b(c,n)}}}function Yo(T){let s,w="Examples:",m,c,k;return c=new xe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVYyMlByaW9yUGlwZWxpbmUlMkMlMjBLYW5kaW5za3lWMjJQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBaW1wb3J0JTIwUElMJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdG9yY2h2aXNpb24lMjBpbXBvcnQlMjB0cmFuc2Zvcm1zJTBBJTBBcGlwZV9wcmlvciUyMCUzRCUyMEthbmRpbnNreVYyMlByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLXByaW9yJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGVfcHJpb3IudG8oJTIyY3VkYSUyMiklMEFpbWcxJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTIyJTBBJTIwJTIwJTIwJTIwJTIyJTJGa2FuZGluc2t5JTJGY2F0LnBuZyUyMiUwQSklMEFpbWcyJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTIyJTBBJTIwJTIwJTIwJTIwJTIyJTJGa2FuZGluc2t5JTJGc3RhcnJ5X25pZ2h0LmpwZWclMjIlMEEpJTBBaW1hZ2VzX3RleHRzJTIwJTNEJTIwJTVCJTIyYSUyMGNhdCUyMiUyQyUyMGltZzElMkMlMjBpbWcyJTVEJTBBd2VpZ2h0cyUyMCUzRCUyMCU1QjAuMyUyQyUyMDAuMyUyQyUyMDAuNCU1RCUwQW91dCUyMCUzRCUyMHBpcGVfcHJpb3IuaW50ZXJwb2xhdGUoaW1hZ2VzX3RleHRzJTJDJTIwd2VpZ2h0cyklMEFwaXBlJTIwJTNEJTIwS2FuZGluc2t5VjIyUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLWRlY29kZXIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBpbWFnZV9lbWJlZHMlM0RvdXQuaW1hZ2VfZW1iZWRzJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfaW1hZ2VfZW1iZWRzJTNEb3V0Lm5lZ2F0aXZlX2ltYWdlX2VtYmVkcyUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDc2OCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJzdGFycnlfY2F0LnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyV22PriorPipeline, KandinskyV22Pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision <span class="hljs-keyword">import</span> transforms

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyV22PriorPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-prior&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>img1 = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/cat.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>img2 = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/starry_night.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>images_texts = [<span class="hljs-string">&quot;a cat&quot;</span>, img1, img2]
<span class="hljs-meta">&gt;&gt;&gt; </span>weights = [<span class="hljs-number">0.3</span>, <span class="hljs-number">0.3</span>, <span class="hljs-number">0.4</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>out = pipe_prior.interpolate(images_texts, weights)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyV22Pipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    image_embeds=out.image_embeds,
<span class="hljs-meta">... </span>    negative_image_embeds=out.negative_image_embeds,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;starry_cat.png&quot;</span>)`,wrap:!1}}),{c(){s=r("p"),s.textContent=w,m=a(),g(c.$$.fragment)},l(n){s=l(n,"P",{"data-svelte-h":!0}),y(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=o(n),u(c.$$.fragment,n)},m(n,v){p(n,s,v),p(n,m,v),f(c,n,v),k=!0},p:ae,i(n){k||(_(c.$$.fragment,n),k=!0)},o(n){h(c.$$.fragment,n),k=!1},d(n){n&&(i(s),i(m)),b(c,n)}}}function So(T){let s,w="Examples:",m,c,k;return c=new xe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVYyMlBpcGVsaW5lJTJDJTIwS2FuZGluc2t5VjIyUHJpb3JQaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZV9wcmlvciUyMCUzRCUyMEthbmRpbnNreVYyMlByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLXByaW9yJTIyKSUwQXBpcGVfcHJpb3IudG8oJTIyY3VkYSUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJyZWQlMjBjYXQlMkMlMjA0ayUyMHBob3RvJTIyJTBBb3V0JTIwJTNEJTIwcGlwZV9wcmlvcihwcm9tcHQpJTBBaW1hZ2VfZW1iJTIwJTNEJTIwb3V0LmltYWdlX2VtYmVkcyUwQXplcm9faW1hZ2VfZW1iJTIwJTNEJTIwb3V0Lm5lZ2F0aXZlX2ltYWdlX2VtYmVkcyUwQXBpcGUlMjAlM0QlMjBLYW5kaW5za3lWMjJQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIya2FuZGluc2t5LWNvbW11bml0eSUyRmthbmRpbnNreS0yLTItZGVjb2RlciUyMiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMGltYWdlX2VtYmVkcyUzRGltYWdlX2VtYiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX2ltYWdlX2VtYmVkcyUzRHplcm9faW1hZ2VfZW1iJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0Q3NjglMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEEpLmltYWdlcyUwQWltYWdlJTVCMCU1RC5zYXZlKCUyMmNhdC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyV22Pipeline, KandinskyV22PriorPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyV22PriorPipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-prior&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;red cat, 4k photo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>out = pipe_prior(prompt)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb = out.image_embeds
<span class="hljs-meta">&gt;&gt;&gt; </span>zero_image_emb = out.negative_image_embeds
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyV22Pipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=zero_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).images
<span class="hljs-meta">&gt;&gt;&gt; </span>image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;cat.png&quot;</span>)`,wrap:!1}}),{c(){s=r("p"),s.textContent=w,m=a(),g(c.$$.fragment)},l(n){s=l(n,"P",{"data-svelte-h":!0}),y(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=o(n),u(c.$$.fragment,n)},m(n,v){p(n,s,v),p(n,m,v),f(c,n,v),k=!0},p:ae,i(n){k||(_(c.$$.fragment,n),k=!0)},o(n){h(c.$$.fragment,n),k=!1},d(n){n&&(i(s),i(m)),b(c,n)}}}function Ho(T){let s,w="Examples:",m,c,k;return c=new xe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1kZWNvZGVyJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwbGlvbiUyMGluJTIwZ2FsYXhpZXMlMkMlMjBzcGlyYWxzJTJDJTIwbmVidWxhZSUyQyUyMHN0YXJzJTJDJTIwc21va2UlMkMlMjBpcmlkZXNjZW50JTJDJTIwaW50cmljYXRlJTIwZGV0YWlsJTJDJTIwb2N0YW5lJTIwcmVuZGVyJTJDJTIwOGslMjIlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI1KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipe = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16
)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A lion in galaxies, spirals, nebulae, stars, smoke, iridescent, intricate detail, octane render, 8k&quot;</span>

image = pipe(prompt=prompt, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){s=r("p"),s.textContent=w,m=a(),g(c.$$.fragment)},l(n){s=l(n,"P",{"data-svelte-h":!0}),y(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=o(n),u(c.$$.fragment,n)},m(n,v){p(n,s,v),p(n,m,v),f(c,n,v),k=!0},p:ae,i(n){k||(_(c.$$.fragment,n),k=!0)},o(n){h(c.$$.fragment,n),k=!1},d(n){n&&(i(s),i(m)),b(c,n)}}}function Ao(T){let s,w="Examples:",m,c,k;return c=new xe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVYyMlBpcGVsaW5lJTJDJTIwS2FuZGluc2t5VjIyUHJpb3JFbWIyRW1iUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVfcHJpb3IlMjAlM0QlMjBLYW5kaW5za3lQcmlvclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1wcmlvciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlX3ByaW9yLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIycmVkJTIwY2F0JTJDJTIwNGslMjBwaG90byUyMiUwQWltZyUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyMiUwQSUyMCUyMCUyMCUyMCUyMiUyRmthbmRpbnNreSUyRmNhdC5wbmclMjIlMEEpJTBBaW1hZ2VfZW1iJTJDJTIwbmFnYXRpdmVfaW1hZ2VfZW1iJTIwJTNEJTIwcGlwZV9wcmlvcihwcm9tcHQlMkMlMjBpbWFnZSUzRGltZyUyQyUyMHN0cmVuZ3RoJTNEMC4yKS50b190dXBsZSgpJTBBJTBBcGlwZSUyMCUzRCUyMEthbmRpbnNreVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1kZWNvZGVyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTIyJTBBKSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwaW1hZ2VfZW1iZWRzJTNEaW1hZ2VfZW1iJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfaW1hZ2VfZW1iZWRzJTNEbmVnYXRpdmVfaW1hZ2VfZW1iJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0Q3NjglMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMTAwJTJDJTBBKS5pbWFnZXMlMEElMEFpbWFnZSU1QjAlNUQuc2F2ZSglMjJjYXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyV22Pipeline, KandinskyV22PriorEmb2EmbPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyPriorPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-prior&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;red cat, 4k photo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>img = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/cat.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb, nagative_image_emb = pipe_prior(prompt, image=img, strength=<span class="hljs-number">0.2</span>).to_tuple()

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder, torch_dtype=torch.float16&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=negative_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;cat.png&quot;</span>)`,wrap:!1}}),{c(){s=r("p"),s.textContent=w,m=a(),g(c.$$.fragment)},l(n){s=l(n,"P",{"data-svelte-h":!0}),y(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=o(n),u(c.$$.fragment,n)},m(n,v){p(n,s,v),p(n,m,v),f(c,n,v),k=!0},p:ae,i(n){k||(_(c.$$.fragment,n),k=!0)},o(n){h(c.$$.fragment,n),k=!1},d(n){n&&(i(s),i(m)),b(c,n)}}}function Oo(T){let s,w="Examples:",m,c,k;return c=new xe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVYyMlByaW9yRW1iMkVtYlBpcGVsaW5lJTJDJTIwS2FuZGluc2t5VjIyUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMFBJTCUwQSUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMHRvcmNodmlzaW9uJTIwaW1wb3J0JTIwdHJhbnNmb3JtcyUwQSUwQXBpcGVfcHJpb3IlMjAlM0QlMjBLYW5kaW5za3lWMjJQcmlvclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1wcmlvciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlX3ByaW9yLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1nMSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyMiUwQSUyMCUyMCUyMCUyMCUyMiUyRmthbmRpbnNreSUyRmNhdC5wbmclMjIlMEEpJTBBJTBBaW1nMiUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyMiUwQSUyMCUyMCUyMCUyMCUyMiUyRmthbmRpbnNreSUyRnN0YXJyeV9uaWdodC5qcGVnJTIyJTBBKSUwQSUwQWltYWdlc190ZXh0cyUyMCUzRCUyMCU1QiUyMmElMjBjYXQlMjIlMkMlMjBpbWcxJTJDJTIwaW1nMiU1RCUwQXdlaWdodHMlMjAlM0QlMjAlNUIwLjMlMkMlMjAwLjMlMkMlMjAwLjQlNUQlMEFpbWFnZV9lbWIlMkMlMjB6ZXJvX2ltYWdlX2VtYiUyMCUzRCUyMHBpcGVfcHJpb3IuaW50ZXJwb2xhdGUoaW1hZ2VzX3RleHRzJTJDJTIwd2VpZ2h0cyklMEElMEFwaXBlJTIwJTNEJTIwS2FuZGluc2t5VjIyUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLWRlY29kZXIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBpbWFnZV9lbWJlZHMlM0RpbWFnZV9lbWIlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9pbWFnZV9lbWJlZHMlM0R6ZXJvX2ltYWdlX2VtYiUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDc2OCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDE1MCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQSUwQWltYWdlLnNhdmUoJTIyc3RhcnJ5X2NhdC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyV22PriorEmb2EmbPipeline, KandinskyV22Pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision <span class="hljs-keyword">import</span> transforms

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyV22PriorPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-prior&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>img1 = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/cat.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>img2 = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/starry_night.jpeg&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>images_texts = [<span class="hljs-string">&quot;a cat&quot;</span>, img1, img2]
<span class="hljs-meta">&gt;&gt;&gt; </span>weights = [<span class="hljs-number">0.3</span>, <span class="hljs-number">0.3</span>, <span class="hljs-number">0.4</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb, zero_image_emb = pipe_prior.interpolate(images_texts, weights)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyV22Pipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=zero_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">150</span>,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;starry_cat.png&quot;</span>)`,wrap:!1}}),{c(){s=r("p"),s.textContent=w,m=a(),g(c.$$.fragment)},l(n){s=l(n,"P",{"data-svelte-h":!0}),y(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=o(n),u(c.$$.fragment,n)},m(n,v){p(n,s,v),p(n,m,v),f(c,n,v),k=!0},p:ae,i(n){k||(_(c.$$.fragment,n),k=!0)},o(n){h(c.$$.fragment,n),k=!1},d(n){n&&(i(s),i(m)),b(c,n)}}}function ei(T){let s,w="Examples:",m,c,k;return c=new xe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjBvcyUwQSUwQXBpcGUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIya2FuZGluc2t5LWNvbW11bml0eSUyRmthbmRpbnNreS0yLTItZGVjb2RlciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGZhbnRhc3klMjBsYW5kc2NhcGUlMkMlMjBDaW5lbWF0aWMlMjBsaWdodGluZyUyMiUwQW5lZ2F0aXZlX3Byb21wdCUyMCUzRCUyMCUyMmxvdyUyMHF1YWxpdHklMkMlMjBiYWQlMjBxdWFsaXR5JTIyJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24lMkZtYWluJTJGYXNzZXRzJTJGc3RhYmxlLXNhbXBsZXMlMkZpbWcyaW1nJTJGc2tldGNoLW1vdW50YWlucy1pbnB1dC5qcGclMjIlMEElMEFyZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLmdldCh1cmwpJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQWltYWdlLnRodW1ibmFpbCgoNzY4JTJDJTIwNzY4KSklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0RvcmlnaW5hbF9pbWFnZSUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> os

pipe = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16
)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A fantasy landscape, Cinematic lighting&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, bad quality&quot;</span>

url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

response = requests.get(url)
image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
image.thumbnail((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))

image = pipe(prompt=prompt, image=original_image, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){s=r("p"),s.textContent=w,m=a(),g(c.$$.fragment)},l(n){s=l(n,"P",{"data-svelte-h":!0}),y(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=o(n),u(c.$$.fragment,n)},m(n,v){p(n,s,v),p(n,m,v),f(c,n,v),k=!0},p:ae,i(n){k||(_(c.$$.fragment,n),k=!0)},o(n){h(c.$$.fragment,n),k=!1},d(n){n&&(i(s),i(m)),b(c,n)}}}function ni(T){let s,w="Examples:",m,c,k;return c=new xe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmclMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBcGlwZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLWRlY29kZXItaW5wYWludCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGZhbnRhc3klMjBsYW5kc2NhcGUlMkMlMjBDaW5lbWF0aWMlMjBsaWdodGluZyUyMiUwQW5lZ2F0aXZlX3Byb21wdCUyMCUzRCUyMCUyMmxvdyUyMHF1YWxpdHklMkMlMjBiYWQlMjBxdWFsaXR5JTIyJTBBJTBBb3JpZ2luYWxfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmhmLWludGVybmFsLXRlc3RpbmclMkZkaWZmdXNlcnMtaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMjIlMjAlMjIlMkZrYW5kaW5za3klMkZjYXQucG5nJTIyJTBBKSUwQSUwQW1hc2slMjAlM0QlMjBucC56ZXJvcygoNzY4JTJDJTIwNzY4KSUyQyUyMGR0eXBlJTNEbnAuZmxvYXQzMiklMEElMjMlMjBMZXQncyUyMG1hc2slMjBvdXQlMjBhbiUyMGFyZWElMjBhYm92ZSUyMHRoZSUyMGNhdCdzJTIwaGVhZCUwQW1hc2slNUIlM0EyNTAlMkMlMjAyNTAlM0EtMjUwJTVEJTIwJTNEJTIwMSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRG9yaWdpbmFsX2ltYWdlJTJDJTIwbWFza19pbWFnZSUzRG1hc2slMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjUpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

pipe = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder-inpaint&quot;</span>, torch_dtype=torch.float16
)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A fantasy landscape, Cinematic lighting&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, bad quality&quot;</span>

original_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span> <span class="hljs-string">&quot;/kandinsky/cat.png&quot;</span>
)

mask = np.zeros((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>), dtype=np.float32)
<span class="hljs-comment"># Let&#x27;s mask out an area above the cat&#x27;s head</span>
mask[:<span class="hljs-number">250</span>, <span class="hljs-number">250</span>:-<span class="hljs-number">250</span>] = <span class="hljs-number">1</span>

image = pipe(prompt=prompt, image=original_image, mask_image=mask, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){s=r("p"),s.textContent=w,m=a(),g(c.$$.fragment)},l(n){s=l(n,"P",{"data-svelte-h":!0}),y(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=o(n),u(c.$$.fragment,n)},m(n,v){p(n,s,v),p(n,m,v),f(c,n,v),k=!0},p:ae,i(n){k||(_(c.$$.fragment,n),k=!0)},o(n){h(c.$$.fragment,n),k=!1},d(n){n&&(i(s),i(m)),b(c,n)}}}function ti(T){let s,w,m,c,k,n,v,Ya='Kandinsky 2.2 is created by <a href="https://github.com/cene555" rel="nofollow">Arseniy Shakhmatov</a>, <a href="https://github.com/razzant" rel="nofollow">Anton Razzhigaev</a>, <a href="https://github.com/AlexWortega" rel="nofollow">Aleksandr Nikolich</a>, <a href="https://github.com/oriBetelgeuse" rel="nofollow">Vladimir Arkhipkin</a>, <a href="https://github.com/boomb0om" rel="nofollow">Igor Pavlov</a>, <a href="https://github.com/kuznetsoffandrey" rel="nofollow">Andrey Kuznetsov</a>, and <a href="https://github.com/denndimitrov" rel="nofollow">Denis Dimitrov</a>.',dt,Ce,Sa="The description from it’s GitHub page is:",ct,Ve,Ha="<em>Kandinsky 2.2 brings substantial improvements upon its predecessor, Kandinsky 2.1, by introducing a new, more powerful image encoder - CLIP-ViT-G and the ControlNet support. The switch to CLIP-ViT-G as the image encoder significantly increases the model’s capability to generate more aesthetic pictures and better understand text, thus enhancing the model’s overall performance. The addition of the ControlNet mechanism allows the model to effectively control the process of generating images. This leads to more accurate and visually appealing outputs and opens new possibilities for text-guided image manipulation.</em>",pt,Je,Aa='The original codebase can be found at <a href="https://github.com/ai-forever/Kandinsky-2" rel="nofollow">ai-forever/Kandinsky-2</a>.',mt,de,gt,ce,ut,je,ft,C,Ue,Lt,fn,Oa="Pipeline for generating image prior for Kandinsky",Bt,_n,eo=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Et,F,$e,Nt,hn,no="Function invoked when calling the pipeline for generation.",Ft,pe,Dt,D,Ze,Rt,bn,to="Function invoked when using the prior pipeline for interpolation.",Qt,me,_t,We,ht,U,Ke,Xt,yn,ao="Pipeline for text-to-image generation using Kandinsky",zt,kn,oo=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Yt,R,Ge,St,vn,io="Function invoked when calling the pipeline for generation.",Ht,ge,bt,qe,yt,V,Le,At,wn,so="Combined Pipeline for text-to-image generation using Kandinsky",Ot,Mn,ro=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,ea,Q,Be,na,In,lo="Function invoked when calling the pipeline for generation.",ta,ue,aa,fe,Ee,oa,Pn,co=`Offloads all models to CPU using accelerate, significantly reducing memory usage. When called, unet,
text_encoder, vae and safety checker have their state dicts saved to CPU and then are moved to a
<code>torch.device(&#39;meta&#39;) and loaded to GPU only when their specific submodule has its </code>forward<code>method called. Note that offloading happens on a submodule basis. Memory savings are higher than with</code>enable_model_cpu_offload\`, but performance is lower.`,kt,Ne,vt,$,Fe,ia,Tn,po="Pipeline for text-to-image generation using Kandinsky",sa,xn,mo=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,ra,X,De,la,Cn,go="Function invoked when calling the pipeline for generation.",da,Vn,uo="Examples:",wt,Re,Mt,J,Qe,ca,Jn,fo="Pipeline for generating image prior for Kandinsky",pa,jn,_o=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,ma,z,Xe,ga,Un,ho="Function invoked when calling the pipeline for generation.",ua,_e,fa,Y,ze,_a,$n,bo="Function invoked when using the prior pipeline for interpolation.",ha,he,It,Ye,Pt,Z,Se,ba,Zn,yo="Pipeline for image-to-image generation using Kandinsky",ya,Wn,ko=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,ka,S,He,va,Kn,vo="Function invoked when calling the pipeline for generation.",wa,Gn,wo="Examples:",Tt,Ae,xt,x,Oe,Ma,qn,Mo="Combined Pipeline for image-to-image generation using Kandinsky",Ia,Ln,Io=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Pa,H,en,Ta,Bn,Po="Function invoked when calling the pipeline for generation.",xa,be,Ca,ye,nn,Va,En,To=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the GPU when its <code>forward</code>
method is called, and the model remains in GPU until the next model runs. Memory savings are lower than with
<code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution of the <code>unet</code>.`,Ja,ke,tn,ja,Nn,xo=`Offloads all models to CPU using accelerate, significantly reducing memory usage. When called, unet,
text_encoder, vae and safety checker have their state dicts saved to CPU and then are moved to a
<code>torch.device(&#39;meta&#39;) and loaded to GPU only when their specific submodule has its </code>forward<code>method called. Note that offloading happens on a submodule basis. Memory savings are higher than with</code>enable_model_cpu_offload\`, but performance is lower.`,Ct,an,Vt,W,on,Ua,Fn,Co="Pipeline for image-to-image generation using Kandinsky",$a,Dn,Vo=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Za,A,sn,Wa,Rn,Jo="Function invoked when calling the pipeline for generation.",Ka,Qn,jo="Examples:",Jt,rn,jt,K,ln,Ga,Xn,Uo="Pipeline for text-guided image inpainting using Kandinsky2.1",qa,zn,$o=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,La,O,dn,Ba,Yn,Zo="Function invoked when calling the pipeline for generation.",Ea,Sn,Wo="Examples:",Ut,cn,$t,j,pn,Na,Hn,Ko="Combined Pipeline for inpainting generation using Kandinsky",Fa,An,Go=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Da,ee,mn,Ra,On,qo="Function invoked when calling the pipeline for generation.",Qa,ve,Xa,we,gn,za,et,Lo=`Offloads all models to CPU using accelerate, significantly reducing memory usage. When called, unet,
text_encoder, vae and safety checker have their state dicts saved to CPU and then are moved to a
<code>torch.device(&#39;meta&#39;) and loaded to GPU only when their specific submodule has its </code>forward<code>method called. Note that offloading happens on a submodule basis. Memory savings are higher than with</code>enable_model_cpu_offload\`, but performance is lower.`,Zt,lt,Wt;return k=new N({props:{title:"Kandinsky 2.2",local:"kandinsky-22",headingTag:"h1"}}),de=new Bo({props:{$$slots:{default:[Qo]},$$scope:{ctx:T}}}),ce=new Bo({props:{$$slots:{default:[Xo]},$$scope:{ctx:T}}}),je=new N({props:{title:"KandinskyV22PriorPipeline",local:"diffusers.KandinskyV22PriorPipeline",headingTag:"h2"}}),Ue=new P({props:{name:"class diffusers.KandinskyV22PriorPipeline",anchor:"diffusers.KandinskyV22PriorPipeline",parameters:[{name:"prior",val:": PriorTransformer"},{name:"image_encoder",val:": CLIPVisionModelWithProjection"},{name:"text_encoder",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": UnCLIPScheduler"},{name:"image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyV22PriorPipeline.prior",description:`<strong>prior</strong> (<a href="/docs/diffusers/main/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonical unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior"},{anchor:"diffusers.KandinskyV22PriorPipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"image_encoder"},{anchor:"diffusers.KandinskyV22PriorPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.KandinskyV22PriorPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.KandinskyV22PriorPipeline.scheduler",description:`<strong>scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22PriorPipeline.image_processor",description:`<strong>image_processor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
A image_processor to be used to preprocess image from clip.`,name:"image_processor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_prior.py#L84"}}),$e=new P({props:{name:"__call__",anchor:"diffusers.KandinskyV22PriorPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"guidance_scale",val:": float = 4.0"},{name:"output_type",val:": Optional = 'pt'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"}],parametersDescription:[{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pt&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;np&quot;</code> (<code>np.array</code>) or <code>&quot;pt&quot;</code>
(<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_prior.py#L370",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>KandinskyPriorPipelineOutput</code> or <code>tuple</code></p>
`}}),pe=new Te({props:{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.example",$$slots:{default:[zo]},$$scope:{ctx:T}}}),Ze=new P({props:{name:"interpolate",anchor:"diffusers.KandinskyV22PriorPipeline.interpolate",parameters:[{name:"images_and_prompts",val:": List"},{name:"weights",val:": List"},{name:"num_images_per_prompt",val:": int = 1"},{name:"num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"negative_prior_prompt",val:": Optional = None"},{name:"negative_prompt",val:": str = ''"},{name:"guidance_scale",val:": float = 4.0"},{name:"device",val:" = None"}],parametersDescription:[{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.images_and_prompts",description:`<strong>images_and_prompts</strong> (<code>List[Union[str, PIL.Image.Image, torch.FloatTensor]]</code>) &#x2014;
list of prompts and images to guide the image generation.
weights &#x2014; (<code>List[float]</code>):
list of weights for each condition in <code>images_and_prompts</code>`,name:"images_and_prompts"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.negative_prior_prompt",description:`<strong>negative_prior_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The prompt not to guide the prior diffusion process. Ignored when not using guidance (i.e., ignored if
<code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prior_prompt"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt not to guide the image generation. Ignored when not using guidance (i.e., ignored if
<code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_prior.py#L131",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>KandinskyPriorPipelineOutput</code> or <code>tuple</code></p>
`}}),me=new Te({props:{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.example",$$slots:{default:[Yo]},$$scope:{ctx:T}}}),We=new N({props:{title:"KandinskyV22Pipeline",local:"diffusers.KandinskyV22Pipeline",headingTag:"h2"}}),Ke=new P({props:{name:"class diffusers.KandinskyV22Pipeline",anchor:"diffusers.KandinskyV22Pipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"}],parametersDescription:[{anchor:"diffusers.KandinskyV22Pipeline.scheduler",description:`<strong>scheduler</strong> (Union[<code>DDIMScheduler</code>,<code>DDPMScheduler</code>]) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22Pipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22Pipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2.py#L64"}}),Ge=new P({props:{name:"__call__",anchor:"diffusers.KandinskyV22Pipeline.__call__",parameters:[{name:"image_embeds",val:": Union"},{name:"negative_image_embeds",val:": Union"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.KandinskyV22Pipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2.py#L122",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),ge=new Te({props:{anchor:"diffusers.KandinskyV22Pipeline.__call__.example",$$slots:{default:[So]},$$scope:{ctx:T}}}),qe=new N({props:{title:"KandinskyV22CombinedPipeline",local:"diffusers.KandinskyV22CombinedPipeline",headingTag:"h2"}}),Le=new P({props:{name:"class diffusers.KandinskyV22CombinedPipeline",anchor:"diffusers.KandinskyV22CombinedPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"},{name:"prior_prior",val:": PriorTransformer"},{name:"prior_image_encoder",val:": CLIPVisionModelWithProjection"},{name:"prior_text_encoder",val:": CLIPTextModelWithProjection"},{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_scheduler",val:": UnCLIPScheduler"},{name:"prior_image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyV22CombinedPipeline.scheduler",description:`<strong>scheduler</strong> (Union[<code>DDIMScheduler</code>,<code>DDPMScheduler</code>]) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22CombinedPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22CombinedPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"},{anchor:"diffusers.KandinskyV22CombinedPipeline.prior_prior",description:`<strong>prior_prior</strong> (<a href="/docs/diffusers/main/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonical unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior_prior"},{anchor:"diffusers.KandinskyV22CombinedPipeline.prior_image_encoder",description:`<strong>prior_image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"prior_image_encoder"},{anchor:"diffusers.KandinskyV22CombinedPipeline.prior_text_encoder",description:`<strong>prior_text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"prior_text_encoder"},{anchor:"diffusers.KandinskyV22CombinedPipeline.prior_tokenizer",description:`<strong>prior_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"prior_tokenizer"},{anchor:"diffusers.KandinskyV22CombinedPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"prior_scheduler"},{anchor:"diffusers.KandinskyV22CombinedPipeline.prior_image_processor",description:`<strong>prior_image_processor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
A image_processor to be used to preprocess image from clip.`,name:"prior_image_processor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L107"}}),Be=new P({props:{name:"__call__",anchor:"diffusers.KandinskyV22CombinedPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"prior_num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"},{name:"prior_callback_on_step_end",val:": Optional = None"},{name:"prior_callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"}],parametersDescription:[{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"prior_guidance_scale"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"prior_num_inference_steps"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.prior_callback_on_step_end",description:`<strong>prior_callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference of the prior pipeline.
The function is called with the following arguments: <code>prior_callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>.`,name:"prior_callback_on_step_end"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.prior_callback_on_step_end_tensor_inputs",description:`<strong>prior_callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>prior_callback_on_step_end</code> function. The tensors specified in the
list will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in
the <code>._callback_tensor_inputs</code> attribute of your prior pipeline class.`,name:"prior_callback_on_step_end_tensor_inputs"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference of the decoder pipeline.
The function is called with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors
as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L202",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),ue=new Te({props:{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.example",$$slots:{default:[Ho]},$$scope:{ctx:T}}}),Ee=new P({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.KandinskyV22CombinedPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:": Optional = None"},{name:"device",val:": Union = 'cuda'"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L182"}}),Ne=new N({props:{title:"KandinskyV22ControlnetPipeline",local:"diffusers.KandinskyV22ControlnetPipeline",headingTag:"h2"}}),Fe=new P({props:{name:"class diffusers.KandinskyV22ControlnetPipeline",anchor:"diffusers.KandinskyV22ControlnetPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"}],parametersDescription:[{anchor:"diffusers.KandinskyV22ControlnetPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_controlnet.py#L106"}}),De=new P({props:{name:"__call__",anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__",parameters:[{name:"image_embeds",val:": Union"},{name:"negative_image_embeds",val:": Union"},{name:"hint",val:": FloatTensor"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.hint",description:`<strong>hint</strong> (<code>torch.FloatTensor</code>) &#x2014;
The controlnet condition.`,name:"hint"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_controlnet.py#L151",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),Re=new N({props:{title:"KandinskyV22PriorEmb2EmbPipeline",local:"diffusers.KandinskyV22PriorEmb2EmbPipeline",headingTag:"h2"}}),Qe=new P({props:{name:"class diffusers.KandinskyV22PriorEmb2EmbPipeline",anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline",parameters:[{name:"prior",val:": PriorTransformer"},{name:"image_encoder",val:": CLIPVisionModelWithProjection"},{name:"text_encoder",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": UnCLIPScheduler"},{name:"image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.prior",description:`<strong>prior</strong> (<a href="/docs/diffusers/main/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonical unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"image_encoder"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.scheduler",description:`<strong>scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_prior_emb2emb.py#L102"}}),Xe=new P({props:{name:"__call__",anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"image",val:": Union"},{name:"strength",val:": float = 0.3"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"guidance_scale",val:": float = 4.0"},{name:"output_type",val:": Optional = 'pt'"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Conceptually, indicates how much to transform the reference <code>emb</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added.`,name:"strength"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.emb",description:`<strong>emb</strong> (<code>torch.FloatTensor</code>) &#x2014;
The image embedding.`,name:"emb"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pt&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;np&quot;</code> (<code>np.array</code>) or <code>&quot;pt&quot;</code>
(<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_prior_emb2emb.py#L396",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>KandinskyPriorPipelineOutput</code> or <code>tuple</code></p>
`}}),_e=new Te({props:{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.example",$$slots:{default:[Ao]},$$scope:{ctx:T}}}),ze=new P({props:{name:"interpolate",anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate",parameters:[{name:"images_and_prompts",val:": List"},{name:"weights",val:": List"},{name:"num_images_per_prompt",val:": int = 1"},{name:"num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"negative_prior_prompt",val:": Optional = None"},{name:"negative_prompt",val:": str = ''"},{name:"guidance_scale",val:": float = 4.0"},{name:"device",val:" = None"}],parametersDescription:[{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.images_and_prompts",description:`<strong>images_and_prompts</strong> (<code>List[Union[str, PIL.Image.Image, torch.FloatTensor]]</code>) &#x2014;
list of prompts and images to guide the image generation.
weights &#x2014; (<code>List[float]</code>):
list of weights for each condition in <code>images_and_prompts</code>`,name:"images_and_prompts"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.negative_prior_prompt",description:`<strong>negative_prior_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The prompt not to guide the prior diffusion process. Ignored when not using guidance (i.e., ignored if
<code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prior_prompt"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt not to guide the image generation. Ignored when not using guidance (i.e., ignored if
<code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_prior_emb2emb.py#L155",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>KandinskyPriorPipelineOutput</code> or <code>tuple</code></p>
`}}),he=new Te({props:{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.example",$$slots:{default:[Oo]},$$scope:{ctx:T}}}),Ye=new N({props:{title:"KandinskyV22Img2ImgPipeline",local:"diffusers.KandinskyV22Img2ImgPipeline",headingTag:"h2"}}),Se=new P({props:{name:"class diffusers.KandinskyV22Img2ImgPipeline",anchor:"diffusers.KandinskyV22Img2ImgPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"}],parametersDescription:[{anchor:"diffusers.KandinskyV22Img2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_img2img.py#L92"}}),He=new P({props:{name:"__call__",anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__",parameters:[{name:"image_embeds",val:": Union"},{name:"image",val:": Union"},{name:"negative_image_embeds",val:": Union"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"strength",val:": float = 0.3"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, that will be used as the starting point for the
process. Can also accept image latents as <code>image</code>, if passing latents directly, it will not be encoded
again.`,name:"image"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_img2img.py#L190",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),Ae=new N({props:{title:"KandinskyV22Img2ImgCombinedPipeline",local:"diffusers.KandinskyV22Img2ImgCombinedPipeline",headingTag:"h2"}}),Oe=new P({props:{name:"class diffusers.KandinskyV22Img2ImgCombinedPipeline",anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"},{name:"prior_prior",val:": PriorTransformer"},{name:"prior_image_encoder",val:": CLIPVisionModelWithProjection"},{name:"prior_text_encoder",val:": CLIPTextModelWithProjection"},{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_scheduler",val:": UnCLIPScheduler"},{name:"prior_image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.scheduler",description:`<strong>scheduler</strong> (Union[<code>DDIMScheduler</code>,<code>DDPMScheduler</code>]) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.prior_prior",description:`<strong>prior_prior</strong> (<a href="/docs/diffusers/main/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonical unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior_prior"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.prior_image_encoder",description:`<strong>prior_image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"prior_image_encoder"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.prior_text_encoder",description:`<strong>prior_text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"prior_text_encoder"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.prior_tokenizer",description:`<strong>prior_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"prior_tokenizer"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"prior_scheduler"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.prior_image_processor",description:`<strong>prior_image_processor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
A image_processor to be used to preprocess image from clip.`,name:"prior_image_processor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L335"}}),en=new P({props:{name:"__call__",anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"image",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"strength",val:": float = 0.3"},{name:"num_images_per_prompt",val:": int = 1"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"prior_num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"},{name:"prior_callback_on_step_end",val:": Optional = None"},{name:"prior_callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"}],parametersDescription:[{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, that will be used as the starting point for the
process. Can also accept image latents as <code>image</code>, if passing latents directly, it will not be encoded
again.`,name:"image"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.3) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"prior_guidance_scale"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"prior_num_inference_steps"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L440",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),be=new Te({props:{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.example",$$slots:{default:[ei]},$$scope:{ctx:T}}}),nn=new P({props:{name:"enable_model_cpu_offload",anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:": Optional = None"},{name:"device",val:": Union = 'cuda'"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L410"}}),tn=new P({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:": Optional = None"},{name:"device",val:": Union = 'cuda'"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L420"}}),an=new N({props:{title:"KandinskyV22ControlnetImg2ImgPipeline",local:"diffusers.KandinskyV22ControlnetImg2ImgPipeline",headingTag:"h2"}}),on=new P({props:{name:"class diffusers.KandinskyV22ControlnetImg2ImgPipeline",anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"}],parametersDescription:[{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_controlnet_img2img.py#L120"}}),sn=new P({props:{name:"__call__",anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__",parameters:[{name:"image_embeds",val:": Union"},{name:"image",val:": Union"},{name:"negative_image_embeds",val:": Union"},{name:"hint",val:": FloatTensor"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"strength",val:": float = 0.3"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, that will be used as the starting point for the
process. Can also accept image latents as <code>image</code>, if passing latents directly, it will not be encoded
again.`,name:"image"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.hint",description:`<strong>hint</strong> (<code>torch.FloatTensor</code>) &#x2014;
The controlnet condition.`,name:"hint"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_controlnet_img2img.py#L206",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),rn=new N({props:{title:"KandinskyV22InpaintPipeline",local:"diffusers.KandinskyV22InpaintPipeline",headingTag:"h2"}}),ln=new P({props:{name:"class diffusers.KandinskyV22InpaintPipeline",anchor:"diffusers.KandinskyV22InpaintPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"}],parametersDescription:[{anchor:"diffusers.KandinskyV22InpaintPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22InpaintPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22InpaintPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_inpainting.py#L235"}}),dn=new P({props:{name:"__call__",anchor:"diffusers.KandinskyV22InpaintPipeline.__call__",parameters:[{name:"image_embeds",val:": Union"},{name:"image",val:": Union"},{name:"mask_image",val:": Union"},{name:"negative_image_embeds",val:": Union"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch which will be inpainted, <em>i.e.</em> parts of the image will
be masked out with <code>mask_image</code> and repainted according to <code>prompt</code>.`,name:"image"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>np.array</code>) &#x2014;
Tensor representing an image batch, to mask <code>image</code>. White pixels in the mask will be repainted, while
black pixels will be preserved. If <code>mask_image</code> is a PIL image, it will be converted to a single
channel (luminance) before use. If it&#x2019;s a tensor, it should contain one color channel (L) instead of 3,
so the expected shape would be <code>(B, H, W, 1)</code>.`,name:"mask_image"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_inpainting.py#L294",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),cn=new N({props:{title:"KandinskyV22InpaintCombinedPipeline",local:"diffusers.KandinskyV22InpaintCombinedPipeline",headingTag:"h2"}}),pn=new P({props:{name:"class diffusers.KandinskyV22InpaintCombinedPipeline",anchor:"diffusers.KandinskyV22InpaintCombinedPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"},{name:"prior_prior",val:": PriorTransformer"},{name:"prior_image_encoder",val:": CLIPVisionModelWithProjection"},{name:"prior_text_encoder",val:": CLIPTextModelWithProjection"},{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_scheduler",val:": UnCLIPScheduler"},{name:"prior_image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.scheduler",description:`<strong>scheduler</strong> (Union[<code>DDIMScheduler</code>,<code>DDPMScheduler</code>]) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.prior_prior",description:`<strong>prior_prior</strong> (<a href="/docs/diffusers/main/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonical unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior_prior"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.prior_image_encoder",description:`<strong>prior_image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"prior_image_encoder"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.prior_text_encoder",description:`<strong>prior_text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"prior_text_encoder"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.prior_tokenizer",description:`<strong>prior_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"prior_tokenizer"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"prior_scheduler"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.prior_image_processor",description:`<strong>prior_image_processor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
A image_processor to be used to preprocess image from clip.`,name:"prior_image_processor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L584"}}),mn=new P({props:{name:"__call__",anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"image",val:": Union"},{name:"mask_image",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"prior_num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"prior_callback_on_step_end",val:": Optional = None"},{name:"prior_callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, that will be used as the starting point for the
process. Can also accept image latents as <code>image</code>, if passing latents directly, it will not be encoded
again.`,name:"image"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>np.array</code>) &#x2014;
Tensor representing an image batch, to mask <code>image</code>. White pixels in the mask will be repainted, while
black pixels will be preserved. If <code>mask_image</code> is a PIL image, it will be converted to a single
channel (luminance) before use. If it&#x2019;s a tensor, it should contain one color channel (L) instead of 3,
so the expected shape would be <code>(B, H, W, 1)</code>.`,name:"mask_image"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"prior_guidance_scale"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"prior_num_inference_steps"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.prior_callback_on_step_end",description:`<strong>prior_callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>prior_callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>.`,name:"prior_callback_on_step_end"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.prior_callback_on_step_end_tensor_inputs",description:`<strong>prior_callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>prior_callback_on_step_end</code> function. The tensors specified in the
list will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in
the <code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"prior_callback_on_step_end_tensor_inputs"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L679",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),ve=new Te({props:{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.example",$$slots:{default:[ni]},$$scope:{ctx:T}}}),gn=new P({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:": Optional = None"},{name:"device",val:": Union = 'cuda'"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L659"}}),{c(){s=r("meta"),w=a(),m=r("p"),c=a(),g(k.$$.fragment),n=a(),v=r("p"),v.innerHTML=Ya,dt=a(),Ce=r("p"),Ce.textContent=Sa,ct=a(),Ve=r("p"),Ve.innerHTML=Ha,pt=a(),Je=r("p"),Je.innerHTML=Aa,mt=a(),g(de.$$.fragment),gt=a(),g(ce.$$.fragment),ut=a(),g(je.$$.fragment),ft=a(),C=r("div"),g(Ue.$$.fragment),Lt=a(),fn=r("p"),fn.textContent=Oa,Bt=a(),_n=r("p"),_n.innerHTML=eo,Et=a(),F=r("div"),g($e.$$.fragment),Nt=a(),hn=r("p"),hn.textContent=no,Ft=a(),g(pe.$$.fragment),Dt=a(),D=r("div"),g(Ze.$$.fragment),Rt=a(),bn=r("p"),bn.textContent=to,Qt=a(),g(me.$$.fragment),_t=a(),g(We.$$.fragment),ht=a(),U=r("div"),g(Ke.$$.fragment),Xt=a(),yn=r("p"),yn.textContent=ao,zt=a(),kn=r("p"),kn.innerHTML=oo,Yt=a(),R=r("div"),g(Ge.$$.fragment),St=a(),vn=r("p"),vn.textContent=io,Ht=a(),g(ge.$$.fragment),bt=a(),g(qe.$$.fragment),yt=a(),V=r("div"),g(Le.$$.fragment),At=a(),wn=r("p"),wn.textContent=so,Ot=a(),Mn=r("p"),Mn.innerHTML=ro,ea=a(),Q=r("div"),g(Be.$$.fragment),na=a(),In=r("p"),In.textContent=lo,ta=a(),g(ue.$$.fragment),aa=a(),fe=r("div"),g(Ee.$$.fragment),oa=a(),Pn=r("p"),Pn.innerHTML=co,kt=a(),g(Ne.$$.fragment),vt=a(),$=r("div"),g(Fe.$$.fragment),ia=a(),Tn=r("p"),Tn.textContent=po,sa=a(),xn=r("p"),xn.innerHTML=mo,ra=a(),X=r("div"),g(De.$$.fragment),la=a(),Cn=r("p"),Cn.textContent=go,da=a(),Vn=r("p"),Vn.textContent=uo,wt=a(),g(Re.$$.fragment),Mt=a(),J=r("div"),g(Qe.$$.fragment),ca=a(),Jn=r("p"),Jn.textContent=fo,pa=a(),jn=r("p"),jn.innerHTML=_o,ma=a(),z=r("div"),g(Xe.$$.fragment),ga=a(),Un=r("p"),Un.textContent=ho,ua=a(),g(_e.$$.fragment),fa=a(),Y=r("div"),g(ze.$$.fragment),_a=a(),$n=r("p"),$n.textContent=bo,ha=a(),g(he.$$.fragment),It=a(),g(Ye.$$.fragment),Pt=a(),Z=r("div"),g(Se.$$.fragment),ba=a(),Zn=r("p"),Zn.textContent=yo,ya=a(),Wn=r("p"),Wn.innerHTML=ko,ka=a(),S=r("div"),g(He.$$.fragment),va=a(),Kn=r("p"),Kn.textContent=vo,wa=a(),Gn=r("p"),Gn.textContent=wo,Tt=a(),g(Ae.$$.fragment),xt=a(),x=r("div"),g(Oe.$$.fragment),Ma=a(),qn=r("p"),qn.textContent=Mo,Ia=a(),Ln=r("p"),Ln.innerHTML=Io,Pa=a(),H=r("div"),g(en.$$.fragment),Ta=a(),Bn=r("p"),Bn.textContent=Po,xa=a(),g(be.$$.fragment),Ca=a(),ye=r("div"),g(nn.$$.fragment),Va=a(),En=r("p"),En.innerHTML=To,Ja=a(),ke=r("div"),g(tn.$$.fragment),ja=a(),Nn=r("p"),Nn.innerHTML=xo,Ct=a(),g(an.$$.fragment),Vt=a(),W=r("div"),g(on.$$.fragment),Ua=a(),Fn=r("p"),Fn.textContent=Co,$a=a(),Dn=r("p"),Dn.innerHTML=Vo,Za=a(),A=r("div"),g(sn.$$.fragment),Wa=a(),Rn=r("p"),Rn.textContent=Jo,Ka=a(),Qn=r("p"),Qn.textContent=jo,Jt=a(),g(rn.$$.fragment),jt=a(),K=r("div"),g(ln.$$.fragment),Ga=a(),Xn=r("p"),Xn.textContent=Uo,qa=a(),zn=r("p"),zn.innerHTML=$o,La=a(),O=r("div"),g(dn.$$.fragment),Ba=a(),Yn=r("p"),Yn.textContent=Zo,Ea=a(),Sn=r("p"),Sn.textContent=Wo,Ut=a(),g(cn.$$.fragment),$t=a(),j=r("div"),g(pn.$$.fragment),Na=a(),Hn=r("p"),Hn.textContent=Ko,Fa=a(),An=r("p"),An.innerHTML=Go,Da=a(),ee=r("div"),g(mn.$$.fragment),Ra=a(),On=r("p"),On.textContent=qo,Qa=a(),g(ve.$$.fragment),Xa=a(),we=r("div"),g(gn.$$.fragment),za=a(),et=r("p"),et.innerHTML=Lo,Zt=a(),lt=r("p"),this.h()},l(e){const d=Ro("svelte-u9bgzb",document.head);s=l(d,"META",{name:!0,content:!0}),d.forEach(i),w=o(e),m=l(e,"P",{}),M(m).forEach(i),c=o(e),u(k.$$.fragment,e),n=o(e),v=l(e,"P",{"data-svelte-h":!0}),y(v)!=="svelte-1a9feuc"&&(v.innerHTML=Ya),dt=o(e),Ce=l(e,"P",{"data-svelte-h":!0}),y(Ce)!=="svelte-1og8lwg"&&(Ce.textContent=Sa),ct=o(e),Ve=l(e,"P",{"data-svelte-h":!0}),y(Ve)!=="svelte-xseaz5"&&(Ve.innerHTML=Ha),pt=o(e),Je=l(e,"P",{"data-svelte-h":!0}),y(Je)!=="svelte-14rg3yz"&&(Je.innerHTML=Aa),mt=o(e),u(de.$$.fragment,e),gt=o(e),u(ce.$$.fragment,e),ut=o(e),u(je.$$.fragment,e),ft=o(e),C=l(e,"DIV",{class:!0});var G=M(C);u(Ue.$$.fragment,G),Lt=o(G),fn=l(G,"P",{"data-svelte-h":!0}),y(fn)!=="svelte-gfz7tn"&&(fn.textContent=Oa),Bt=o(G),_n=l(G,"P",{"data-svelte-h":!0}),y(_n)!=="svelte-wu1jmh"&&(_n.innerHTML=eo),Et=o(G),F=l(G,"DIV",{class:!0});var oe=M(F);u($e.$$.fragment,oe),Nt=o(oe),hn=l(oe,"P",{"data-svelte-h":!0}),y(hn)!=="svelte-v78lg8"&&(hn.textContent=no),Ft=o(oe),u(pe.$$.fragment,oe),oe.forEach(i),Dt=o(G),D=l(G,"DIV",{class:!0});var ie=M(D);u(Ze.$$.fragment,ie),Rt=o(ie),bn=l(ie,"P",{"data-svelte-h":!0}),y(bn)!=="svelte-1k7d7q8"&&(bn.textContent=to),Qt=o(ie),u(me.$$.fragment,ie),ie.forEach(i),G.forEach(i),_t=o(e),u(We.$$.fragment,e),ht=o(e),U=l(e,"DIV",{class:!0});var B=M(U);u(Ke.$$.fragment,B),Xt=o(B),yn=l(B,"P",{"data-svelte-h":!0}),y(yn)!=="svelte-jhhofy"&&(yn.textContent=ao),zt=o(B),kn=l(B,"P",{"data-svelte-h":!0}),y(kn)!=="svelte-wu1jmh"&&(kn.innerHTML=oo),Yt=o(B),R=l(B,"DIV",{class:!0});var se=M(R);u(Ge.$$.fragment,se),St=o(se),vn=l(se,"P",{"data-svelte-h":!0}),y(vn)!=="svelte-v78lg8"&&(vn.textContent=io),Ht=o(se),u(ge.$$.fragment,se),se.forEach(i),B.forEach(i),bt=o(e),u(qe.$$.fragment,e),yt=o(e),V=l(e,"DIV",{class:!0});var q=M(V);u(Le.$$.fragment,q),At=o(q),wn=l(q,"P",{"data-svelte-h":!0}),y(wn)!=="svelte-1spbql3"&&(wn.textContent=so),Ot=o(q),Mn=l(q,"P",{"data-svelte-h":!0}),y(Mn)!=="svelte-wu1jmh"&&(Mn.innerHTML=ro),ea=o(q),Q=l(q,"DIV",{class:!0});var re=M(Q);u(Be.$$.fragment,re),na=o(re),In=l(re,"P",{"data-svelte-h":!0}),y(In)!=="svelte-v78lg8"&&(In.textContent=lo),ta=o(re),u(ue.$$.fragment,re),re.forEach(i),aa=o(q),fe=l(q,"DIV",{class:!0});var un=M(fe);u(Ee.$$.fragment,un),oa=o(un),Pn=l(un,"P",{"data-svelte-h":!0}),y(Pn)!=="svelte-1ff7ilh"&&(Pn.innerHTML=co),un.forEach(i),q.forEach(i),kt=o(e),u(Ne.$$.fragment,e),vt=o(e),$=l(e,"DIV",{class:!0});var E=M($);u(Fe.$$.fragment,E),ia=o(E),Tn=l(E,"P",{"data-svelte-h":!0}),y(Tn)!=="svelte-jhhofy"&&(Tn.textContent=po),sa=o(E),xn=l(E,"P",{"data-svelte-h":!0}),y(xn)!=="svelte-wu1jmh"&&(xn.innerHTML=mo),ra=o(E),X=l(E,"DIV",{class:!0});var le=M(X);u(De.$$.fragment,le),la=o(le),Cn=l(le,"P",{"data-svelte-h":!0}),y(Cn)!=="svelte-v78lg8"&&(Cn.textContent=go),da=o(le),Vn=l(le,"P",{"data-svelte-h":!0}),y(Vn)!=="svelte-kvfsh7"&&(Vn.textContent=uo),le.forEach(i),E.forEach(i),wt=o(e),u(Re.$$.fragment,e),Mt=o(e),J=l(e,"DIV",{class:!0});var ne=M(J);u(Qe.$$.fragment,ne),ca=o(ne),Jn=l(ne,"P",{"data-svelte-h":!0}),y(Jn)!=="svelte-gfz7tn"&&(Jn.textContent=fo),pa=o(ne),jn=l(ne,"P",{"data-svelte-h":!0}),y(jn)!=="svelte-wu1jmh"&&(jn.innerHTML=_o),ma=o(ne),z=l(ne,"DIV",{class:!0});var nt=M(z);u(Xe.$$.fragment,nt),ga=o(nt),Un=l(nt,"P",{"data-svelte-h":!0}),y(Un)!=="svelte-v78lg8"&&(Un.textContent=ho),ua=o(nt),u(_e.$$.fragment,nt),nt.forEach(i),fa=o(ne),Y=l(ne,"DIV",{class:!0});var tt=M(Y);u(ze.$$.fragment,tt),_a=o(tt),$n=l(tt,"P",{"data-svelte-h":!0}),y($n)!=="svelte-1k7d7q8"&&($n.textContent=bo),ha=o(tt),u(he.$$.fragment,tt),tt.forEach(i),ne.forEach(i),It=o(e),u(Ye.$$.fragment,e),Pt=o(e),Z=l(e,"DIV",{class:!0});var Me=M(Z);u(Se.$$.fragment,Me),ba=o(Me),Zn=l(Me,"P",{"data-svelte-h":!0}),y(Zn)!=="svelte-1nm2rj2"&&(Zn.textContent=yo),ya=o(Me),Wn=l(Me,"P",{"data-svelte-h":!0}),y(Wn)!=="svelte-wu1jmh"&&(Wn.innerHTML=ko),ka=o(Me),S=l(Me,"DIV",{class:!0});var at=M(S);u(He.$$.fragment,at),va=o(at),Kn=l(at,"P",{"data-svelte-h":!0}),y(Kn)!=="svelte-v78lg8"&&(Kn.textContent=vo),wa=o(at),Gn=l(at,"P",{"data-svelte-h":!0}),y(Gn)!=="svelte-kvfsh7"&&(Gn.textContent=wo),at.forEach(i),Me.forEach(i),Tt=o(e),u(Ae.$$.fragment,e),xt=o(e),x=l(e,"DIV",{class:!0});var L=M(x);u(Oe.$$.fragment,L),Ma=o(L),qn=l(L,"P",{"data-svelte-h":!0}),y(qn)!=="svelte-1ql3mrb"&&(qn.textContent=Mo),Ia=o(L),Ln=l(L,"P",{"data-svelte-h":!0}),y(Ln)!=="svelte-wu1jmh"&&(Ln.innerHTML=Io),Pa=o(L),H=l(L,"DIV",{class:!0});var ot=M(H);u(en.$$.fragment,ot),Ta=o(ot),Bn=l(ot,"P",{"data-svelte-h":!0}),y(Bn)!=="svelte-v78lg8"&&(Bn.textContent=Po),xa=o(ot),u(be.$$.fragment,ot),ot.forEach(i),Ca=o(L),ye=l(L,"DIV",{class:!0});var Kt=M(ye);u(nn.$$.fragment,Kt),Va=o(Kt),En=l(Kt,"P",{"data-svelte-h":!0}),y(En)!=="svelte-d7vywi"&&(En.innerHTML=To),Kt.forEach(i),Ja=o(L),ke=l(L,"DIV",{class:!0});var Gt=M(ke);u(tn.$$.fragment,Gt),ja=o(Gt),Nn=l(Gt,"P",{"data-svelte-h":!0}),y(Nn)!=="svelte-1ff7ilh"&&(Nn.innerHTML=xo),Gt.forEach(i),L.forEach(i),Ct=o(e),u(an.$$.fragment,e),Vt=o(e),W=l(e,"DIV",{class:!0});var Ie=M(W);u(on.$$.fragment,Ie),Ua=o(Ie),Fn=l(Ie,"P",{"data-svelte-h":!0}),y(Fn)!=="svelte-1nm2rj2"&&(Fn.textContent=Co),$a=o(Ie),Dn=l(Ie,"P",{"data-svelte-h":!0}),y(Dn)!=="svelte-wu1jmh"&&(Dn.innerHTML=Vo),Za=o(Ie),A=l(Ie,"DIV",{class:!0});var it=M(A);u(sn.$$.fragment,it),Wa=o(it),Rn=l(it,"P",{"data-svelte-h":!0}),y(Rn)!=="svelte-v78lg8"&&(Rn.textContent=Jo),Ka=o(it),Qn=l(it,"P",{"data-svelte-h":!0}),y(Qn)!=="svelte-kvfsh7"&&(Qn.textContent=jo),it.forEach(i),Ie.forEach(i),Jt=o(e),u(rn.$$.fragment,e),jt=o(e),K=l(e,"DIV",{class:!0});var Pe=M(K);u(ln.$$.fragment,Pe),Ga=o(Pe),Xn=l(Pe,"P",{"data-svelte-h":!0}),y(Xn)!=="svelte-2p9m8a"&&(Xn.textContent=Uo),qa=o(Pe),zn=l(Pe,"P",{"data-svelte-h":!0}),y(zn)!=="svelte-wu1jmh"&&(zn.innerHTML=$o),La=o(Pe),O=l(Pe,"DIV",{class:!0});var st=M(O);u(dn.$$.fragment,st),Ba=o(st),Yn=l(st,"P",{"data-svelte-h":!0}),y(Yn)!=="svelte-v78lg8"&&(Yn.textContent=Zo),Ea=o(st),Sn=l(st,"P",{"data-svelte-h":!0}),y(Sn)!=="svelte-kvfsh7"&&(Sn.textContent=Wo),st.forEach(i),Pe.forEach(i),Ut=o(e),u(cn.$$.fragment,e),$t=o(e),j=l(e,"DIV",{class:!0});var te=M(j);u(pn.$$.fragment,te),Na=o(te),Hn=l(te,"P",{"data-svelte-h":!0}),y(Hn)!=="svelte-ydcvxp"&&(Hn.textContent=Ko),Fa=o(te),An=l(te,"P",{"data-svelte-h":!0}),y(An)!=="svelte-wu1jmh"&&(An.innerHTML=Go),Da=o(te),ee=l(te,"DIV",{class:!0});var rt=M(ee);u(mn.$$.fragment,rt),Ra=o(rt),On=l(rt,"P",{"data-svelte-h":!0}),y(On)!=="svelte-v78lg8"&&(On.textContent=qo),Qa=o(rt),u(ve.$$.fragment,rt),rt.forEach(i),Xa=o(te),we=l(te,"DIV",{class:!0});var qt=M(we);u(gn.$$.fragment,qt),za=o(qt),et=l(qt,"P",{"data-svelte-h":!0}),y(et)!=="svelte-1ff7ilh"&&(et.innerHTML=Lo),qt.forEach(i),te.forEach(i),Zt=o(e),lt=l(e,"P",{}),M(lt).forEach(i),this.h()},h(){I(s,"name","hf:doc:metadata"),I(s,"content",ai),I(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,d){t(document.head,s),p(e,w,d),p(e,m,d),p(e,c,d),f(k,e,d),p(e,n,d),p(e,v,d),p(e,dt,d),p(e,Ce,d),p(e,ct,d),p(e,Ve,d),p(e,pt,d),p(e,Je,d),p(e,mt,d),f(de,e,d),p(e,gt,d),f(ce,e,d),p(e,ut,d),f(je,e,d),p(e,ft,d),p(e,C,d),f(Ue,C,null),t(C,Lt),t(C,fn),t(C,Bt),t(C,_n),t(C,Et),t(C,F),f($e,F,null),t(F,Nt),t(F,hn),t(F,Ft),f(pe,F,null),t(C,Dt),t(C,D),f(Ze,D,null),t(D,Rt),t(D,bn),t(D,Qt),f(me,D,null),p(e,_t,d),f(We,e,d),p(e,ht,d),p(e,U,d),f(Ke,U,null),t(U,Xt),t(U,yn),t(U,zt),t(U,kn),t(U,Yt),t(U,R),f(Ge,R,null),t(R,St),t(R,vn),t(R,Ht),f(ge,R,null),p(e,bt,d),f(qe,e,d),p(e,yt,d),p(e,V,d),f(Le,V,null),t(V,At),t(V,wn),t(V,Ot),t(V,Mn),t(V,ea),t(V,Q),f(Be,Q,null),t(Q,na),t(Q,In),t(Q,ta),f(ue,Q,null),t(V,aa),t(V,fe),f(Ee,fe,null),t(fe,oa),t(fe,Pn),p(e,kt,d),f(Ne,e,d),p(e,vt,d),p(e,$,d),f(Fe,$,null),t($,ia),t($,Tn),t($,sa),t($,xn),t($,ra),t($,X),f(De,X,null),t(X,la),t(X,Cn),t(X,da),t(X,Vn),p(e,wt,d),f(Re,e,d),p(e,Mt,d),p(e,J,d),f(Qe,J,null),t(J,ca),t(J,Jn),t(J,pa),t(J,jn),t(J,ma),t(J,z),f(Xe,z,null),t(z,ga),t(z,Un),t(z,ua),f(_e,z,null),t(J,fa),t(J,Y),f(ze,Y,null),t(Y,_a),t(Y,$n),t(Y,ha),f(he,Y,null),p(e,It,d),f(Ye,e,d),p(e,Pt,d),p(e,Z,d),f(Se,Z,null),t(Z,ba),t(Z,Zn),t(Z,ya),t(Z,Wn),t(Z,ka),t(Z,S),f(He,S,null),t(S,va),t(S,Kn),t(S,wa),t(S,Gn),p(e,Tt,d),f(Ae,e,d),p(e,xt,d),p(e,x,d),f(Oe,x,null),t(x,Ma),t(x,qn),t(x,Ia),t(x,Ln),t(x,Pa),t(x,H),f(en,H,null),t(H,Ta),t(H,Bn),t(H,xa),f(be,H,null),t(x,Ca),t(x,ye),f(nn,ye,null),t(ye,Va),t(ye,En),t(x,Ja),t(x,ke),f(tn,ke,null),t(ke,ja),t(ke,Nn),p(e,Ct,d),f(an,e,d),p(e,Vt,d),p(e,W,d),f(on,W,null),t(W,Ua),t(W,Fn),t(W,$a),t(W,Dn),t(W,Za),t(W,A),f(sn,A,null),t(A,Wa),t(A,Rn),t(A,Ka),t(A,Qn),p(e,Jt,d),f(rn,e,d),p(e,jt,d),p(e,K,d),f(ln,K,null),t(K,Ga),t(K,Xn),t(K,qa),t(K,zn),t(K,La),t(K,O),f(dn,O,null),t(O,Ba),t(O,Yn),t(O,Ea),t(O,Sn),p(e,Ut,d),f(cn,e,d),p(e,$t,d),p(e,j,d),f(pn,j,null),t(j,Na),t(j,Hn),t(j,Fa),t(j,An),t(j,Da),t(j,ee),f(mn,ee,null),t(ee,Ra),t(ee,On),t(ee,Qa),f(ve,ee,null),t(j,Xa),t(j,we),f(gn,we,null),t(we,za),t(we,et),p(e,Zt,d),p(e,lt,d),Wt=!0},p(e,[d]){const G={};d&2&&(G.$$scope={dirty:d,ctx:e}),de.$set(G);const oe={};d&2&&(oe.$$scope={dirty:d,ctx:e}),ce.$set(oe);const ie={};d&2&&(ie.$$scope={dirty:d,ctx:e}),pe.$set(ie);const B={};d&2&&(B.$$scope={dirty:d,ctx:e}),me.$set(B);const se={};d&2&&(se.$$scope={dirty:d,ctx:e}),ge.$set(se);const q={};d&2&&(q.$$scope={dirty:d,ctx:e}),ue.$set(q);const re={};d&2&&(re.$$scope={dirty:d,ctx:e}),_e.$set(re);const un={};d&2&&(un.$$scope={dirty:d,ctx:e}),he.$set(un);const E={};d&2&&(E.$$scope={dirty:d,ctx:e}),be.$set(E);const le={};d&2&&(le.$$scope={dirty:d,ctx:e}),ve.$set(le)},i(e){Wt||(_(k.$$.fragment,e),_(de.$$.fragment,e),_(ce.$$.fragment,e),_(je.$$.fragment,e),_(Ue.$$.fragment,e),_($e.$$.fragment,e),_(pe.$$.fragment,e),_(Ze.$$.fragment,e),_(me.$$.fragment,e),_(We.$$.fragment,e),_(Ke.$$.fragment,e),_(Ge.$$.fragment,e),_(ge.$$.fragment,e),_(qe.$$.fragment,e),_(Le.$$.fragment,e),_(Be.$$.fragment,e),_(ue.$$.fragment,e),_(Ee.$$.fragment,e),_(Ne.$$.fragment,e),_(Fe.$$.fragment,e),_(De.$$.fragment,e),_(Re.$$.fragment,e),_(Qe.$$.fragment,e),_(Xe.$$.fragment,e),_(_e.$$.fragment,e),_(ze.$$.fragment,e),_(he.$$.fragment,e),_(Ye.$$.fragment,e),_(Se.$$.fragment,e),_(He.$$.fragment,e),_(Ae.$$.fragment,e),_(Oe.$$.fragment,e),_(en.$$.fragment,e),_(be.$$.fragment,e),_(nn.$$.fragment,e),_(tn.$$.fragment,e),_(an.$$.fragment,e),_(on.$$.fragment,e),_(sn.$$.fragment,e),_(rn.$$.fragment,e),_(ln.$$.fragment,e),_(dn.$$.fragment,e),_(cn.$$.fragment,e),_(pn.$$.fragment,e),_(mn.$$.fragment,e),_(ve.$$.fragment,e),_(gn.$$.fragment,e),Wt=!0)},o(e){h(k.$$.fragment,e),h(de.$$.fragment,e),h(ce.$$.fragment,e),h(je.$$.fragment,e),h(Ue.$$.fragment,e),h($e.$$.fragment,e),h(pe.$$.fragment,e),h(Ze.$$.fragment,e),h(me.$$.fragment,e),h(We.$$.fragment,e),h(Ke.$$.fragment,e),h(Ge.$$.fragment,e),h(ge.$$.fragment,e),h(qe.$$.fragment,e),h(Le.$$.fragment,e),h(Be.$$.fragment,e),h(ue.$$.fragment,e),h(Ee.$$.fragment,e),h(Ne.$$.fragment,e),h(Fe.$$.fragment,e),h(De.$$.fragment,e),h(Re.$$.fragment,e),h(Qe.$$.fragment,e),h(Xe.$$.fragment,e),h(_e.$$.fragment,e),h(ze.$$.fragment,e),h(he.$$.fragment,e),h(Ye.$$.fragment,e),h(Se.$$.fragment,e),h(He.$$.fragment,e),h(Ae.$$.fragment,e),h(Oe.$$.fragment,e),h(en.$$.fragment,e),h(be.$$.fragment,e),h(nn.$$.fragment,e),h(tn.$$.fragment,e),h(an.$$.fragment,e),h(on.$$.fragment,e),h(sn.$$.fragment,e),h(rn.$$.fragment,e),h(ln.$$.fragment,e),h(dn.$$.fragment,e),h(cn.$$.fragment,e),h(pn.$$.fragment,e),h(mn.$$.fragment,e),h(ve.$$.fragment,e),h(gn.$$.fragment,e),Wt=!1},d(e){e&&(i(w),i(m),i(c),i(n),i(v),i(dt),i(Ce),i(ct),i(Ve),i(pt),i(Je),i(mt),i(gt),i(ut),i(ft),i(C),i(_t),i(ht),i(U),i(bt),i(yt),i(V),i(kt),i(vt),i($),i(wt),i(Mt),i(J),i(It),i(Pt),i(Z),i(Tt),i(xt),i(x),i(Ct),i(Vt),i(W),i(Jt),i(jt),i(K),i(Ut),i($t),i(j),i(Zt),i(lt)),i(s),b(k,e),b(de,e),b(ce,e),b(je,e),b(Ue),b($e),b(pe),b(Ze),b(me),b(We,e),b(Ke),b(Ge),b(ge),b(qe,e),b(Le),b(Be),b(ue),b(Ee),b(Ne,e),b(Fe),b(De),b(Re,e),b(Qe),b(Xe),b(_e),b(ze),b(he),b(Ye,e),b(Se),b(He),b(Ae,e),b(Oe),b(en),b(be),b(nn),b(tn),b(an,e),b(on),b(sn),b(rn,e),b(ln),b(dn),b(cn,e),b(pn),b(mn),b(ve),b(gn)}}}const ai='{"title":"Kandinsky 2.2","local":"kandinsky-22","sections":[{"title":"KandinskyV22PriorPipeline","local":"diffusers.KandinskyV22PriorPipeline","sections":[],"depth":2},{"title":"KandinskyV22Pipeline","local":"diffusers.KandinskyV22Pipeline","sections":[],"depth":2},{"title":"KandinskyV22CombinedPipeline","local":"diffusers.KandinskyV22CombinedPipeline","sections":[],"depth":2},{"title":"KandinskyV22ControlnetPipeline","local":"diffusers.KandinskyV22ControlnetPipeline","sections":[],"depth":2},{"title":"KandinskyV22PriorEmb2EmbPipeline","local":"diffusers.KandinskyV22PriorEmb2EmbPipeline","sections":[],"depth":2},{"title":"KandinskyV22Img2ImgPipeline","local":"diffusers.KandinskyV22Img2ImgPipeline","sections":[],"depth":2},{"title":"KandinskyV22Img2ImgCombinedPipeline","local":"diffusers.KandinskyV22Img2ImgCombinedPipeline","sections":[],"depth":2},{"title":"KandinskyV22ControlnetImg2ImgPipeline","local":"diffusers.KandinskyV22ControlnetImg2ImgPipeline","sections":[],"depth":2},{"title":"KandinskyV22InpaintPipeline","local":"diffusers.KandinskyV22InpaintPipeline","sections":[],"depth":2},{"title":"KandinskyV22InpaintCombinedPipeline","local":"diffusers.KandinskyV22InpaintCombinedPipeline","sections":[],"depth":2}],"depth":1}';function oi(T){return No(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class mi extends Fo{constructor(s){super(),Do(this,s,oi,ti,Eo,{})}}export{mi as component};
