import{s as Dl,o as Pl}from"../chunks/scheduler.9bc65507.js";import{S as Kl,i as Ol,g as i,s as a,r,A as ea,h as p,f as s,c as n,j as El,u as M,x as o,k as Ll,y as ta,a as l,v as m,d as h,t as c,w as y,m as sa,n as la}from"../chunks/index.707bf1b6.js";import{T as aa}from"../chunks/Tip.c2ecdbf4.js";import{C as d}from"../chunks/CodeBlock.54a9f38d.js";import{H as u}from"../chunks/Heading.342b1fa6.js";function na(pt){let J;return{c(){J=sa(`If you're fine-tuning a model for chat, in addition to setting a chat template, you should probably add any new chat
control tokens as special tokens in the tokenizer. Special tokens are never split, 
ensuring that your control tokens are always handled as single tokens rather than being tokenized in pieces. You 
should also set the tokenizer's \`eos_token\` attribute to the token that marks the end of assistant generations in your
template. This will ensure that text generation tools can correctly figure out when to stop generating text.`)},l(U){J=la(U,`If you're fine-tuning a model for chat, in addition to setting a chat template, you should probably add any new chat
control tokens as special tokens in the tokenizer. Special tokens are never split, 
ensuring that your control tokens are always handled as single tokens rather than being tokenized in pieces. You 
should also set the tokenizer's \`eos_token\` attribute to the token that marks the end of assistant generations in your
template. This will ensure that text generation tools can correctly figure out when to stop generating text.`)},m(U,j){l(U,J,j)},d(U){U&&s(J)}}}function ia(pt){let J,U,j,ot,g,rt,w,Mt,f,Ds=`An increasingly common use case for LLMs is <strong>chat</strong>. In a chat context, rather than continuing a single string
of text (as is the case with a standard language model), the model instead continues a conversation that consists
of one or more <strong>messages</strong>, each of which includes a <strong>role</strong>, like “user” or “assistant”, as well as message text.`,mt,I,Ps=`Much like tokenization, different models expect very different input formats for chat. This is the reason we added
<strong>chat templates</strong> as a feature. Chat templates are part of the tokenizer. They specify how to convert conversations,
represented as lists of messages, into a single tokenizable string in the format that the model expects.`,ht,b,Ks=`Let’s make this concrete with a quick example using the <code>BlenderBot</code> model. BlenderBot has an extremely simple default
template, which mostly just adds whitespace between rounds of dialogue:`,ct,C,yt,x,Os=`Notice how the entire chat is condensed into a single string. If we use <code>tokenize=True</code>, which is the default setting,
that string will also be tokenized for us. To see a more complex template in action, though, let’s use the
<code>mistralai/Mistral-7B-Instruct-v0.1</code> model.`,dt,k,ut,N,el=`Note that this time, the tokenizer has added the control tokens [INST] and [/INST] to indicate the start and end of
user messages (but not assistant messages!). Mistral-instruct was trained with these tokens, but BlenderBot was not.`,Jt,G,Ut,Z,tl=`As you can see in the example above, chat templates are easy to use. Simply build a list of messages, with <code>role</code>
and <code>content</code> keys, and then pass it to the <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a> method. Once you do that,
you’ll get output that’s ready to go! When using chat templates as input for model generation, it’s also a good idea
to use <code>add_generation_prompt=True</code> to add a <a href="#what-are-generation-prompts">generation prompt</a>.`,Tt,$,sl="Here’s an example of preparing input for <code>model.generate()</code>, using the <code>Zephyr</code> assistant model:",jt,v,gt,Q,ll="This will yield a string in the input format that Zephyr expects.",wt,B,ft,W,al="Now that our input is formatted correctly for Zephyr, we can use the model to generate a response to the user’s question:",It,z,bt,S,nl="This will yield:",Ct,V,xt,_,il="Arr, ‘twas easy after all!",kt,R,Nt,A,pl=`Yes, there is! Our text generation pipelines support chat inputs, which makes it easy to use chat models. In the past,
we used to use a dedicated “ConversationalPipeline” class, but this has now been deprecated and its functionality
has been merged into the <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>. Let’s try the <code>Zephyr</code> example again, but this time using
a pipeline:`,Gt,q,Zt,H,$t,X,ol=`The pipeline will take care of all the details of tokenization and calling <code>apply_chat_template</code> for you -
once the model has a chat template, all you need to do is initialize the pipeline and pass it the list of messages!`,vt,F,Qt,Y,rl=`You may have noticed that the <code>apply_chat_template</code> method has an <code>add_generation_prompt</code> argument. This argument tells
the template to add tokens that indicate the start of a bot response. For example, consider the following chat:`,Bt,E,Wt,L,Ml="Here’s what this will look like without a generation prompt, using the ChatML template we saw in the Zephyr example:",zt,D,St,P,ml="And here’s what it looks like <strong>with</strong> a generation prompt:",Vt,K,_t,O,hl=`Note that this time, we’ve added the tokens that indicate the start of a bot response. This ensures that when the model
generates text it will write a bot response instead of doing something unexpected, like continuing the user’s
message. Remember, chat models are still just language models - they’re trained to continue text, and chat is just a
special kind of text to them! You need to guide them with appropriate control tokens, so they know what they’re
supposed to be doing.`,Rt,ee,cl=`Not all models require generation prompts. Some models, like BlenderBot and LLaMA, don’t have any
special tokens before bot responses. In these cases, the <code>add_generation_prompt</code> argument will have no effect. The exact
effect that <code>add_generation_prompt</code> has will depend on the template being used.`,At,te,qt,se,yl=`Yes! We recommend that you apply the chat template as a preprocessing step for your dataset. After this, you
can simply continue like any other language model training task. When training, you should usually set
<code>add_generation_prompt=False</code>, because the added tokens to prompt an assistant response will not be helpful during
training. Let’s see an example:`,Ht,le,Xt,ae,dl="And we get:",Ft,ne,Yt,ie,ul="From here, just continue training like you would with a standard language modelling task, using the <code>formatted_chat</code> column.",Et,pe,Lt,oe,Jl=`The chat template for a model is stored on the <code>tokenizer.chat_template</code> attribute. If no chat template is set, the
default template for that model class is used instead. Let’s take a look at the template for <code>BlenderBot</code>:`,Dt,re,Pt,Me,Ul=`That’s kind of intimidating. Let’s add some newlines and indentation to make it more readable. Note that the first
newline after each block as well as any preceding whitespace before a block are ignored by default, using the
Jinja <code>trim_blocks</code> and <code>lstrip_blocks</code> flags. However, be cautious - although leading whitespace on each
line is stripped, spaces between blocks on the same line are not. We strongly recommend checking that your template
isn’t printing extra spaces where it shouldn’t be!`,Kt,me,Ot,he,Tl=`If you’ve never seen one of these before, this is a <a href="https://jinja.palletsprojects.com/en/3.1.x/templates/" rel="nofollow">Jinja template</a>.
Jinja is a templating language that allows you to write simple code that generates text. In many ways, the code and
syntax resembles Python. In pure Python, this template would look something like this:`,es,ce,ts,ye,jl="Effectively, the template does three things:",ss,de,gl="<li>For each message, if the message is a user message, add a blank space before it, otherwise print nothing.</li> <li>Add the message content</li> <li>If the message is not the last message, add two spaces after it. After the final message, print the EOS token.</li>",ls,ue,wl=`This is a pretty simple template - it doesn’t add any control tokens, and it doesn’t support “system” messages, which
are a common way to give the model directives about how it should behave in the subsequent conversation.
But Jinja gives you a lot of flexibility to do those things! Let’s see a Jinja template that can format inputs
similarly to the way LLaMA formats them (note that the real LLaMA template includes handling for default system
messages and slightly different system message handling in general - don’t use this one in your actual code!)`,as,Je,ns,Ue,fl=`Hopefully if you stare at this for a little bit you can see what this template is doing - it adds specific tokens based
on the “role” of each message, which represents who sent it. User, assistant and system messages are clearly
distinguishable to the model because of the tokens they’re wrapped in.`,is,Te,ps,je,os,ge,Il=`Simple, just write a jinja template and set <code>tokenizer.chat_template</code>. You may find it easier to start with an
existing template from another model and simply edit it for your needs! For example, we could take the LLaMA template
above and add ”[ASST]” and ”[/ASST]” to assistant messages:`,rs,we,Ms,fe,bl=`Now, simply set the <code>tokenizer.chat_template</code> attribute. Next time you use <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>, it will
use your new template! This attribute will be saved in the <code>tokenizer_config.json</code> file, so you can use
<a href="/docs/transformers/main/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> to upload your new template to the Hub and make sure everyone’s using the right
template for your model!`,ms,Ie,hs,be,Cl=`The method <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a> which uses your chat template is called by the <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a> class, so
once you set the correct chat template, your model will automatically become compatible with <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>.`,cs,T,ys,Ce,ds,xe,xl=`Before the introduction of chat templates, chat handling was hardcoded at the model class level. For backwards
compatibility, we have retained this class-specific handling as default templates, also set at the class level. If a
model does not have a chat template set, but there is a default template for its model class, the <code>TextGenerationPipeline</code>
class and methods like <code>apply_chat_template</code> will use the class template instead. You can find out what the default
template for your tokenizer is by checking the <code>tokenizer.default_chat_template</code> attribute.`,us,ke,kl=`This is something we do purely for backward compatibility reasons, to avoid breaking any existing workflows. Even when
the class template is appropriate for your model, we strongly recommend overriding the default template by
setting the <code>chat_template</code> attribute explicitly to make it clear to users that your model has been correctly configured
for chat.`,Js,Ne,Nl=`Now that actual chat templates have been adopted more widely, default templates have been deprecated and will be
removed in a future release. We strongly recommend setting the <code>chat_template</code> attribute for any tokenizers that
still depend on them!`,Us,Ge,Ts,Ze,Gl=`When setting the template for a model that’s already been trained for chat, you should ensure that the template
exactly matches the message formatting that the model saw during training, or else you will probably experience
performance degradation. This is true even if you’re training the model further - you will probably get the best
performance if you keep the chat tokens constant. This is very analogous to tokenization - you generally get the
best performance for inference or fine-tuning when you precisely match the tokenization used during training.`,js,$e,Zl=`If you’re training a model from scratch, or fine-tuning a base language model for chat, on the other hand,
you have a lot of freedom to choose an appropriate template! LLMs are smart enough to learn to handle lots of different
input formats. One popular choice is the <code>ChatML</code> format, and this is a good, flexible choice for many use-cases.
It looks like this:`,gs,ve,ws,Qe,$l=`If you like this one, here it is in one-liner form, ready to copy into your code. The one-liner also includes
handy support for <a href="#what-are-generation-prompts">generation prompts</a>, but note that it doesn’t add BOS or EOS tokens!
If your model expects those, they won’t be added automatically by <code>apply_chat_template</code> - in other words, the
text will be tokenized with <code>add_special_tokens=False</code>. This is to avoid potential conflicts between the template and
the <code>add_special_tokens</code> logic. If your model expects special tokens, make sure to add them to the template!`,fs,Be,Is,We,vl=`This template wraps each message in <code>&lt;|im_start|&gt;</code> and <code>&lt;|im_end|&gt;</code> tokens, and simply writes the role as a string, which
allows for flexibility in the roles you train with. The output looks like this:`,bs,ze,Cs,Se,Ql=`The “user”, “system” and “assistant” roles are the standard for chat, and we recommend using them when it makes sense,
particularly if you want your model to operate well with <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>. However, you are not limited
to these roles - templating is extremely flexible, and any string can be a role.`,xs,Ve,ks,_e,Bl=`If you have any chat models, you should set their <code>tokenizer.chat_template</code> attribute and test it using
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>, then push the updated tokenizer to the Hub. This applies even if you’re
not the model owner - if you’re using a model with an empty chat template, or one that’s still using the default class
template, please open a <a href="https://huggingface.co/docs/hub/repositories-pull-requests-discussions" rel="nofollow">pull request</a> to the model repository so that this attribute can be set properly!`,Ns,Re,Wl=`Once the attribute is set, that’s it, you’re done! <code>tokenizer.apply_chat_template</code> will now work correctly for that
model, which means it is also automatically supported in places like <code>TextGenerationPipeline</code>!`,Gs,Ae,zl=`By ensuring that models have this attribute, we can make sure that the whole community gets to use the full power of
open-source models. Formatting mismatches have been haunting the field and silently harming performance for too long -
it’s time to put an end to them!`,Zs,qe,$s,He,Sl=`If you’re unfamiliar with Jinja, we generally find that the easiest way to write a chat template is to first
write a short Python script that formats messages the way you want, and then convert that script into a template.`,vs,Xe,Vl=`Remember that the template handler will receive the conversation history as a variable called <code>messages</code>. Each
message is a dictionary with two keys, <code>role</code> and <code>content</code>. You will be able to access <code>messages</code> in your template
just like you can in Python, which means you can loop over it with <code>{% for message in messages %}</code> or access
individual messages with, for example, <code>{{ messages[0] }}</code>.`,Qs,Fe,_l="You can also use the following tips to convert your code to Jinja:",Bs,Ye,Ws,Ee,Rl="For loops in Jinja look like this:",zs,Le,Ss,De,Al=`Note that whatever’s inside the {{ expression block }} will be printed to the output. You can use operators like
<code>+</code> to combine strings inside expression blocks.`,Vs,Pe,_s,Ke,ql="If statements in Jinja look like this:",Rs,Oe,As,et,Hl=`Note how where Python uses whitespace to mark the beginnings and ends of <code>for</code> and <code>if</code> blocks, Jinja requires you
to explicitly end them with <code>{% endfor %}</code> and <code>{% endif %}</code>.`,qs,tt,Hs,st,Xl=`Inside your template, you will have access to the list of <code>messages</code>, but you can also access several other special
variables. These include special tokens like <code>bos_token</code> and <code>eos_token</code>, as well as the <code>add_generation_prompt</code>
variable that we discussed above. You can also use the <code>loop</code> variable to access information about the current loop
iteration, for example  using <code>{% if loop.last %}</code> to check if the current message is the last message in the
conversation. Here’s an example that puts these ideas together to add a generation prompt at the end of the
conversation if add_generation_prompt is <code>True</code>:`,Xs,lt,Fs,at,Ys,nt,Fl=`As much as possible, we’ve tried to get Jinja to ignore whitespace outside of {{ expressions }}. However, be aware
that Jinja is a general-purpose templating engine, and it may treat whitespace between blocks on the same line
as significant and print it to the output. We <strong>strongly</strong> recommend checking that your template isn’t printing extra
spaces where it shouldn’t be before you upload it!`,Es,it,Ls;return g=new u({props:{title:"Templates for Chat Models",local:"templates-for-chat-models",headingTag:"h1"}}),w=new u({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),C=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmJsZW5kZXJib3QtNDAwTS1kaXN0aWxsJTIyKSUwQSUwQWNoYXQlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIZWxsbyUyQyUyMGhvdyUyMGFyZSUyMHlvdSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdtJTIwZG9pbmclMjBncmVhdC4lMjBIb3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUyMHRvZGF5JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdkJTIwbGlrZSUyMHRvJTIwc2hvdyUyMG9mZiUyMGhvdyUyMGNoYXQlMjB0ZW1wbGF0aW5nJTIwd29ya3MhJTIyJTdEJTJDJTBBJTVEJTBBJTBBdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoY2hhdCUyQyUyMHRva2VuaXplJTNERmFsc2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/blenderbot-400M-distill&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>chat = [
<span class="hljs-meta">... </span>   {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>   {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>   {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot; Hello, how are you?  I&#x27;m doing great. How can I help you today?   I&#x27;d like to show off how chat templating works!&lt;/s&gt;&quot;</span>`,wrap:!1}}),k=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLUluc3RydWN0LXYwLjElMjIpJTBBJTBBY2hhdCUyMCUzRCUyMCU1QiUwQSUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJJ20lMjBkb2luZyUyMGdyZWF0LiUyMEhvdyUyMGNhbiUyMEklMjBoZWxwJTIweW91JTIwdG9kYXklM0YlMjIlN0QlMkMlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJJ2QlMjBsaWtlJTIwdG8lMjBzaG93JTIwb2ZmJTIwaG93JTIwY2hhdCUyMHRlbXBsYXRpbmclMjB3b3JrcyElMjIlN0QlMkMlMEElNUQlMEElMEF0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShjaGF0JTJDJTIwdG9rZW5pemUlM0RGYWxzZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-Instruct-v0.1&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>chat = [
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&lt;s&gt;[INST] Hello, how are you? [/INST]I&#x27;m doing great. How can I help you today?&lt;/s&gt; [INST] I&#x27;d like to show off how chat templating works! [/INST]&quot;</span>`,wrap:!1}}),G=new u({props:{title:"How do I use chat templates?",local:"how-do-i-use-chat-templates",headingTag:"h2"}}),v=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGElMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTIwJTIwJTIzJTIwWW91JTIwbWF5JTIwd2FudCUyMHRvJTIwdXNlJTIwYmZsb2F0MTYlMjBhbmQlMkZvciUyMG1vdmUlMjB0byUyMEdQVSUyMGhlcmUlMEElMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMG1hbnklMjBoZWxpY29wdGVycyUyMGNhbiUyMGElMjBodW1hbiUyMGVhdCUyMGluJTIwb25lJTIwc2l0dGluZyUzRiUyMiU3RCUyQyUwQSUyMCU1RCUwQXRva2VuaXplZF9jaGF0JTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzRFRydWUlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKHRva2VuaXplZF9jaGF0JTVCMCU1RCkp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

checkpoint = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)
model = AutoModelForCausalLM.from_pretrained(checkpoint)  <span class="hljs-comment"># You may want to use bfloat16 and/or move to GPU here</span>

messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>,
    },
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
 ]
tokenized_chat = tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">True</span>, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(tokenized_chat[<span class="hljs-number">0</span>]))`,wrap:!1}}),B=new d({props:{code:"JTNDJTdDc3lzdGVtJTdDJTNFJTBBWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUzQyUyRnMlM0UlMjAlMEElM0MlN0N1c2VyJTdDJTNFJTBBSG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTNDJTJGcyUzRSUyMCUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRQ==",highlighted:`&lt;|system|&gt;
You are a friendly chatbot who always responds in the style of a pirate&lt;/s&gt; 
&lt;|user|&gt;
How many helicopters can a human eat in one sitting?&lt;/s&gt; 
&lt;|assistant|&gt;`,wrap:!1}}),z=new d({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKHRva2VuaXplZF9jaGF0JTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTIwJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXRzJTVCMCU1RCkp",highlighted:`outputs = model.generate(tokenized_chat, max_new_tokens=<span class="hljs-number">128</span>) 
<span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>]))`,wrap:!1}}),V=new d({props:{code:"JTNDJTdDc3lzdGVtJTdDJTNFJTBBWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUzQyUyRnMlM0UlMjAlMEElM0MlN0N1c2VyJTdDJTNFJTBBSG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTNDJTJGcyUzRSUyMCUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRSUwQU1hdGV5JTJDJTIwSSdtJTIwYWZyYWlkJTIwSSUyMG11c3QlMjBpbmZvcm0lMjB5ZSUyMHRoYXQlMjBodW1hbnMlMjBjYW5ub3QlMjBlYXQlMjBoZWxpY29wdGVycy4lMjBIZWxpY29wdGVycyUyMGFyZSUyMG5vdCUyMGZvb2QlMkMlMjB0aGV5JTIwYXJlJTIwZmx5aW5nJTIwbWFjaGluZXMuJTIwRm9vZCUyMGlzJTIwbWVhbnQlMjB0byUyMGJlJTIwZWF0ZW4lMkMlMjBsaWtlJTIwYSUyMGhlYXJ0eSUyMHBsYXRlJTIwbyclMjBncm9nJTJDJTIwYSUyMHNhdm9yeSUyMGJvd2wlMjBvJyUyMHN0ZXclMkMlMjBvciUyMGElMjBkZWxpY2lvdXMlMjBsb2FmJTIwbyclMjBicmVhZC4lMjBCdXQlMjBoZWxpY29wdGVycyUyQyUyMHRoZXklMjBiZSUyMGZvciUyMHRyYW5zcG9ydGluJyUyMGFuZCUyMG1vdmluJyUyMGFyb3VuZCUyQyUyMG5vdCUyMGZvciUyMGVhdGluJy4lMjBTbyUyQyUyMEknZCUyMHNheSUyMG5vbmUlMkMlMjBtZSUyMGhlYXJ0aWVzLiUyME5vbmUlMjBhdCUyMGFsbC4=",highlighted:`&lt;|system|&gt;
You are a friendly chatbot who always responds in the style of a pirate&lt;/s&gt; 
&lt;|user|&gt;
How many helicopters can a human eat in one sitting?&lt;/s&gt; 
&lt;|assistant|&gt;
Matey, I&#x27;m afraid I must inform ye that humans cannot eat helicopters. Helicopters are not food, they are flying machines. Food is meant to be eaten, like a hearty plate o&#x27; grog, a savory bowl o&#x27; stew, or a delicious loaf o&#x27; bread. But helicopters, they be for transportin&#x27; and movin&#x27; around, not for eatin&#x27;. So, I&#x27;d say none, me hearties. None at all.`,wrap:!1}}),R=new u({props:{title:"Is there an automated pipeline for chat?",local:"is-there-an-automated-pipeline-for-chat",headingTag:"h2"}}),q=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMCUyMkh1Z2dpbmdGYWNlSDQlMkZ6ZXBoeXItN2ItYmV0YSUyMiklMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMG1hbnklMjBoZWxpY29wdGVycyUyMGNhbiUyMGElMjBodW1hbiUyMGVhdCUyMGluJTIwb25lJTIwc2l0dGluZyUzRiUyMiU3RCUyQyUwQSU1RCUwQXByaW50KHBpcGUobWVzc2FnZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEyOCklNUIwJTVEJTVCJ2dlbmVyYXRlZF90ZXh0JyU1RCU1Qi0xJTVEKSUyMCUyMCUyMyUyMFByaW50JTIwdGhlJTIwYXNzaXN0YW50J3MlMjByZXNwb25zZQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>)
messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>,
    },
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
]
<span class="hljs-built_in">print</span>(pipe(messages, max_new_tokens=<span class="hljs-number">128</span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;generated_text&#x27;</span>][-<span class="hljs-number">1</span>])  <span class="hljs-comment"># Print the assistant&#x27;s response</span>`,wrap:!1}}),H=new d({props:{code:"JTdCJ3JvbGUnJTNBJTIwJ2Fzc2lzdGFudCclMkMlMjAnY29udGVudCclM0ElMjAlMjJNYXRleSUyQyUyMEknbSUyMGFmcmFpZCUyMEklMjBtdXN0JTIwaW5mb3JtJTIweWUlMjB0aGF0JTIwaHVtYW5zJTIwY2Fubm90JTIwZWF0JTIwaGVsaWNvcHRlcnMuJTIwSGVsaWNvcHRlcnMlMjBhcmUlMjBub3QlMjBmb29kJTJDJTIwdGhleSUyMGFyZSUyMGZseWluZyUyMG1hY2hpbmVzLiUyMEZvb2QlMjBpcyUyMG1lYW50JTIwdG8lMjBiZSUyMGVhdGVuJTJDJTIwbGlrZSUyMGElMjBoZWFydHklMjBwbGF0ZSUyMG8nJTIwZ3JvZyUyQyUyMGElMjBzYXZvcnklMjBib3dsJTIwbyclMjBzdGV3JTJDJTIwb3IlMjBhJTIwZGVsaWNpb3VzJTIwbG9hZiUyMG8nJTIwYnJlYWQuJTIwQnV0JTIwaGVsaWNvcHRlcnMlMkMlMjB0aGV5JTIwYmUlMjBmb3IlMjB0cmFuc3BvcnRpbiclMjBhbmQlMjBtb3ZpbiclMjBhcm91bmQlMkMlMjBub3QlMjBmb3IlMjBlYXRpbicuJTIwU28lMkMlMjBJJ2QlMjBzYXklMjBub25lJTJDJTIwbWUlMjBoZWFydGllcy4lMjBOb25lJTIwYXQlMjBhbGwuJTIyJTdE",highlighted:"{&#x27;role&#x27;: &#x27;assistant&#x27;, &#x27;content&#x27;: &quot;Matey, I&#x27;m afraid I must inform ye that humans cannot eat helicopters. Helicopters are not food, they are flying machines. Food is meant to be eaten, like a hearty plate o&#x27; grog, a savory bowl o&#x27; stew, or a delicious loaf o&#x27; bread. But helicopters, they be for transportin&#x27; and movin&#x27; around, not for eatin&#x27;. So, I&#x27;d say none, me hearties. None at all.&quot;}",wrap:!1}}),F=new u({props:{title:"What are “generation prompts”?",local:"what-are-generation-prompts",headingTag:"h2"}}),E=new d({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIaSUyMHRoZXJlISUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyTmljZSUyMHRvJTIwbWVldCUyMHlvdSElMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTIyJTdEJTBBJTVE",highlighted:`messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hi there!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Nice to meet you!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can I ask a question?&quot;</span>}
]`,wrap:!1}}),D=new d({props:{code:"dG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNERmFsc2UpJTBBJTIyJTIyJTIyJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSGklMjB0aGVyZSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRWFzc2lzdGFudCUwQU5pY2UlMjB0byUyMG1lZXQlMjB5b3UhJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBQ2FuJTIwSSUyMGFzayUyMGElMjBxdWVzdGlvbiUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUyMiUyMiUyMg==",highlighted:`tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),K=new d({props:{code:"dG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSklMEElMjIlMjIlMjIlM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFIaSUyMHRoZXJlISUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBTmljZSUyMHRvJTIwbWVldCUyMHlvdSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEElMjIlMjIlMjI=",highlighted:`tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
&quot;&quot;&quot;</span>`,wrap:!1}}),te=new u({props:{title:"Can I use chat templates in training?",local:"can-i-use-chat-templates-in-training",headingTag:"h2"}}),le=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBEYXRhc2V0JTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci03Yi1iZXRhJTIyKSUwQSUwQWNoYXQxJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBpcyUyMGJpZ2dlciUyQyUyMHRoZSUyMG1vb24lMjBvciUyMHRoZSUyMHN1biUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyVGhlJTIwc3VuLiUyMiU3RCUwQSU1RCUwQWNoYXQyJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBpcyUyMGJpZ2dlciUyQyUyMGElMjB2aXJ1cyUyMG9yJTIwYSUyMGJhY3Rlcml1bSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQSUyMGJhY3Rlcml1bS4lMjIlN0QlMEElNUQlMEElMEFkYXRhc2V0JTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyY2hhdCUyMiUzQSUyMCU1QmNoYXQxJTJDJTIwY2hhdDIlNUQlN0QpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKGxhbWJkYSUyMHglM0ElMjAlN0IlMjJmb3JtYXR0ZWRfY2hhdCUyMiUzQSUyMHRva2VuaXplci5hcHBseV9jaGF0X3RlbXBsYXRlKHglNUIlMjJjaGF0JTIyJTVEJTJDJTIwdG9rZW5pemUlM0RGYWxzZSUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzREZhbHNlKSU3RCklMEFwcmludChkYXRhc2V0JTVCJ2Zvcm1hdHRlZF9jaGF0JyU1RCU1QjAlNUQp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>)

chat1 = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Which is bigger, the moon or the sun?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;The sun.&quot;</span>}
]
chat2 = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Which is bigger, a virus or a bacterium?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;A bacterium.&quot;</span>}
]

dataset = Dataset.from_dict({<span class="hljs-string">&quot;chat&quot;</span>: [chat1, chat2]})
dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> x: {<span class="hljs-string">&quot;formatted_chat&quot;</span>: tokenizer.apply_chat_template(x[<span class="hljs-string">&quot;chat&quot;</span>], tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)})
<span class="hljs-built_in">print</span>(dataset[<span class="hljs-string">&#x27;formatted_chat&#x27;</span>][<span class="hljs-number">0</span>])`,wrap:!1}}),ne=new d({props:{code:"JTNDJTdDdXNlciU3QyUzRSUwQVdoaWNoJTIwaXMlMjBiaWdnZXIlMkMlMjB0aGUlMjBtb29uJTIwb3IlMjB0aGUlMjBzdW4lM0YlM0MlMkZzJTNFJTBBJTNDJTdDYXNzaXN0YW50JTdDJTNFJTBBVGhlJTIwc3VuLiUzQyUyRnMlM0U=",highlighted:`&lt;|user|&gt;
Which is bigger, the moon or the sun?&lt;/s&gt;
&lt;|assistant|&gt;
The sun.&lt;/s&gt;`,wrap:!1}}),pe=new u({props:{title:"Advanced: How do chat templates work?",local:"advanced-how-do-chat-templates-work",headingTag:"h2"}}),re=new d({props:{code:"JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmJsZW5kZXJib3QtNDAwTS1kaXN0aWxsJTIyKSUwQSUwQXRva2VuaXplci5kZWZhdWx0X2NoYXRfdGVtcGxhdGU=",highlighted:`
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/blenderbot-400M-distill&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.default_chat_template
<span class="hljs-string">&quot;{% for message in messages %}{% if message[&#x27;role&#x27;] == &#x27;user&#x27; %}{{ &#x27; &#x27; }}{% endif %}{{ message[&#x27;content&#x27;] }}{% if not loop.last %}{{ &#x27;  &#x27; }}{% endif %}{% endfor %}{{ eos_token }}&quot;</span>`,wrap:!1}}),me=new d({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjAnJTIwJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGlmJTIwbm90JTIwbG9vcC5sYXN0JTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyUyMCUyMCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbmRpZiUyMCUyNSU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RCUwQSU3QiU3QiUyMGVvc190b2tlbiUyMCU3RCU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27; &#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{ message[<span class="hljs-string">&#x27;content&#x27;</span>] }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> not loop.last <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;  &#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ eos_token }}</span>`,wrap:!1}}),ce=new d({props:{code:"Zm9yJTIwaWR4JTJDJTIwbWVzc2FnZSUyMGluJTIwZW51bWVyYXRlKG1lc3NhZ2VzKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCclMjAnKSUwQSUyMCUyMCUyMCUyMHByaW50KG1lc3NhZ2UlNUInY29udGVudCclNUQpJTBBJTIwJTIwJTIwJTIwaWYlMjBub3QlMjBpZHglMjAlM0QlM0QlMjBsZW4obWVzc2FnZXMpJTIwLSUyMDElM0ElMjAlMjAlMjMlMjBDaGVjayUyMGZvciUyMHRoZSUyMGxhc3QlMjBtZXNzYWdlJTIwaW4lMjB0aGUlMjBjb252ZXJzYXRpb24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludCgnJTIwJTIwJyklMEFwcmludChlb3NfdG9rZW4p",highlighted:`<span class="hljs-keyword">for</span> idx, message <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(messages):
    <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27; &#x27;</span>)
    <span class="hljs-built_in">print</span>(message[<span class="hljs-string">&#x27;content&#x27;</span>])
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> idx == <span class="hljs-built_in">len</span>(messages) - <span class="hljs-number">1</span>:  <span class="hljs-comment"># Check for the last message in the conversation</span>
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;  &#x27;</span>)
<span class="hljs-built_in">print</span>(eos_token)`,wrap:!1}}),Je=new d({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwJyUyMCU1QiUyRklOU1QlNUQnJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1JTIwZWxpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAnc3lzdGVtJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3QiUyMCclM0MlM0NTWVMlM0UlM0UlNUMlNUNuJyUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTVDJTVDbiUzQyUzQyUyRlNZUyUzRSUzRSU1QyU1Q24lNUMlNUNuJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVsaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ2Fzc2lzdGFudCclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjAnJTIwJyUyMCUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTIwJyUyMCUyQiUyMGVvc190b2tlbiUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27; &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; &#x27;</span> + eos_token }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),Te=new u({props:{title:"Advanced: Adding and editing chat templates",local:"advanced-adding-and-editing-chat-templates",headingTag:"h2"}}),je=new u({props:{title:"How do I create a chat template?",local:"how-do-i-create-a-chat-template",headingTag:"h3"}}),we=new d({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVELnN0cmlwKCklMjAlMkIlMjAnJTIwJTVCJTJGSU5TVCU1RCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdzeXN0ZW0nJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyUzQyUzQ1NZUyUzRSUzRSU1QyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RC5zdHJpcCgpJTIwJTJCJTIwJyU1QyU1Q24lM0MlM0MlMkZTWVMlM0UlM0UlNUMlNUNuJTVDJTVDbiclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdhc3Npc3RhbnQnJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyU1QkFTU1QlNUQlMjAnJTIwJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclMjAlNUIlMkZBU1NUJTVEJyUyMCUyQiUyMGVvc190b2tlbiUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].strip() + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].strip() + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;[ASST] &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/ASST]&#x27;</span> + eos_token }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),Ie=new d({props:{code:"dGVtcGxhdGUlMjAlM0QlMjB0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUwQXRlbXBsYXRlJTIwJTNEJTIwdGVtcGxhdGUucmVwbGFjZSglMjJTWVMlMjIlMkMlMjAlMjJTWVNURU0lMjIpJTIwJTIwJTIzJTIwQ2hhbmdlJTIwdGhlJTIwc3lzdGVtJTIwdG9rZW4lMEF0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUyMCUzRCUyMHRlbXBsYXRlJTIwJTIwJTIzJTIwU2V0JTIwdGhlJTIwbmV3JTIwdGVtcGxhdGUlMEF0b2tlbml6ZXIucHVzaF90b19odWIoJTIybW9kZWxfbmFtZSUyMiklMjAlMjAlMjMlMjBVcGxvYWQlMjB5b3VyJTIwbmV3JTIwdGVtcGxhdGUlMjB0byUyMHRoZSUyMEh1YiE=",highlighted:`template = tokenizer.chat_template
template = template.replace(<span class="hljs-string">&quot;SYS&quot;</span>, <span class="hljs-string">&quot;SYSTEM&quot;</span>)  <span class="hljs-comment"># Change the system token</span>
tokenizer.chat_template = template  <span class="hljs-comment"># Set the new template</span>
tokenizer.push_to_hub(<span class="hljs-string">&quot;model_name&quot;</span>)  <span class="hljs-comment"># Upload your new template to the Hub!</span>`,wrap:!1}}),T=new aa({props:{$$slots:{default:[na]},$$scope:{ctx:pt}}}),Ce=new u({props:{title:"What are “default” templates?",local:"what-are-default-templates",headingTag:"h3"}}),Ge=new u({props:{title:"What template should I use?",local:"what-template-should-i-use",headingTag:"h3"}}),ve=new d({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlN0InJTNDJTdDaW1fc3RhcnQlN0MlM0UnJTIwJTJCJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUyQiUyMCclNUNuJyUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTNDJTdDaW1fZW5kJTdDJTNFJyUyMCUyQiUyMCclNUNuJyU3RCU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{<span class="hljs-string">&#x27;&lt;|im_start|&gt;&#x27;</span> + message[<span class="hljs-string">&#x27;role&#x27;</span>] + <span class="hljs-string">&#x27;\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;&lt;|im_end|&gt;&#x27;</span> + <span class="hljs-string">&#x27;\\n&#x27;</span>}}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),Be=new d({props:{code:"dG9rZW5pemVyLmNoYXRfdGVtcGxhdGUlMjAlM0QlMjAlMjIlN0IlMjUlMjBpZiUyMG5vdCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMGlzJTIwZGVmaW5lZCUyMCUyNSU3RCU3QiUyNSUyMHNldCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMCUzRCUyMGZhbHNlJTIwJTI1JTdEJTdCJTI1JTIwZW5kaWYlMjAlMjUlN0QlN0IlMjUlMjBmb3IlMjBtZXNzYWdlJTIwaW4lMjBtZXNzYWdlcyUyMCUyNSU3RCU3QiU3QiclM0MlN0NpbV9zdGFydCU3QyUzRSclMjAlMkIlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwJyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclM0MlN0NpbV9lbmQlN0MlM0UnJTIwJTJCJTIwJyU1Q24nJTdEJTdEJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdEJTdCJTI1JTIwaWYlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlMjUlN0QlN0IlN0IlMjAnJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlNUNuJyUyMCU3RCU3RCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTIy",highlighted:'tokenizer.chat_template = <span class="hljs-string">&quot;{% if not add_generation_prompt is defined %}{% set add_generation_prompt = false %}{% endif %}{% for message in messages %}{{&#x27;&lt;|im_start|&gt;&#x27; + message[&#x27;role&#x27;] + &#x27;\\n&#x27; + message[&#x27;content&#x27;] + &#x27;&lt;|im_end|&gt;&#x27; + &#x27;\\n&#x27;}}{% endfor %}{% if add_generation_prompt %}{{ &#x27;&lt;|im_start|&gt;assistant\\n&#x27; }}{% endif %}&quot;</span>',wrap:!1}}),ze=new d({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lMEFZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGNoYXRib3QlMjB0aGF0JTIwd2lsbCUyMGRvJTIwaXRzJTIwYmVzdCUyMG5vdCUyMHRvJTIwc2F5JTIwYW55dGhpbmclMjBzbyUyMHN0dXBpZCUyMHRoYXQlMjBwZW9wbGUlMjB0d2VldCUyMGFib3V0JTIwaXQuJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSG93JTIwYXJlJTIweW91JTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEFJJ20lMjBkb2luZyUyMGdyZWF0ISUzQyU3Q2ltX2VuZCU3QyUzRQ==",highlighted:`&lt;|im_start|&gt;system
You are a helpful chatbot that will do its best not to say anything so stupid that people tweet about it.&lt;|im_end|&gt;
&lt;|im_start|&gt;user
How are you?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
I&#x27;m doing great!&lt;|im_end|&gt;`,wrap:!1}}),Ve=new u({props:{title:"I want to add some chat templates! How should I get started?",local:"i-want-to-add-some-chat-templates-how-should-i-get-started",headingTag:"h3"}}),qe=new u({props:{title:"Advanced: Template writing tips",local:"advanced-template-writing-tips",headingTag:"h2"}}),Ye=new u({props:{title:"For loops",local:"for-loops",headingTag:"h3"}}),Le=new d({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElN0IlN0IlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTdEJTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">for</span></span> message <span class="hljs-keyword">in</span> messages %}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ message[&#x27;content&#x27;] }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">endfor</span></span> %}</span>`,wrap:!1}}),Pe=new u({props:{title:"If statements",local:"if-statements",headingTag:"h3"}}),Oe=new d({props:{code:"JTdCJTI1JTIwaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ3VzZXInJTIwJTI1JTdEJTBBJTdCJTdCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUwQSU3QiUyNSUyMGVuZGlmJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ message[<span class="hljs-string">&#x27;content&#x27;</span>] }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),tt=new u({props:{title:"Special variables",local:"special-variables",headingTag:"h3"}}),lt=new d({props:{code:"JTdCJTI1JTIwaWYlMjBsb29wLmxhc3QlMjBhbmQlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlMjUlN0QlMEElN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnQXNzaXN0YW50JTNBJTVDbiclMjAlN0QlN0QlMEElN0IlMjUlMjBlbmRpZiUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">if</span></span> loop.last and add_generation_prompt %}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ bos_token + &#x27;Assistant:\\n&#x27; }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">endif</span></span> %}</span>`,wrap:!1}}),at=new u({props:{title:"Notes on whitespace",local:"notes-on-whitespace",headingTag:"h3"}}),{c(){J=i("meta"),U=a(),j=i("p"),ot=a(),r(g.$$.fragment),rt=a(),r(w.$$.fragment),Mt=a(),f=i("p"),f.innerHTML=Ds,mt=a(),I=i("p"),I.innerHTML=Ps,ht=a(),b=i("p"),b.innerHTML=Ks,ct=a(),r(C.$$.fragment),yt=a(),x=i("p"),x.innerHTML=Os,dt=a(),r(k.$$.fragment),ut=a(),N=i("p"),N.textContent=el,Jt=a(),r(G.$$.fragment),Ut=a(),Z=i("p"),Z.innerHTML=tl,Tt=a(),$=i("p"),$.innerHTML=sl,jt=a(),r(v.$$.fragment),gt=a(),Q=i("p"),Q.textContent=ll,wt=a(),r(B.$$.fragment),ft=a(),W=i("p"),W.textContent=al,It=a(),r(z.$$.fragment),bt=a(),S=i("p"),S.textContent=nl,Ct=a(),r(V.$$.fragment),xt=a(),_=i("p"),_.textContent=il,kt=a(),r(R.$$.fragment),Nt=a(),A=i("p"),A.innerHTML=pl,Gt=a(),r(q.$$.fragment),Zt=a(),r(H.$$.fragment),$t=a(),X=i("p"),X.innerHTML=ol,vt=a(),r(F.$$.fragment),Qt=a(),Y=i("p"),Y.innerHTML=rl,Bt=a(),r(E.$$.fragment),Wt=a(),L=i("p"),L.textContent=Ml,zt=a(),r(D.$$.fragment),St=a(),P=i("p"),P.innerHTML=ml,Vt=a(),r(K.$$.fragment),_t=a(),O=i("p"),O.textContent=hl,Rt=a(),ee=i("p"),ee.innerHTML=cl,At=a(),r(te.$$.fragment),qt=a(),se=i("p"),se.innerHTML=yl,Ht=a(),r(le.$$.fragment),Xt=a(),ae=i("p"),ae.textContent=dl,Ft=a(),r(ne.$$.fragment),Yt=a(),ie=i("p"),ie.innerHTML=ul,Et=a(),r(pe.$$.fragment),Lt=a(),oe=i("p"),oe.innerHTML=Jl,Dt=a(),r(re.$$.fragment),Pt=a(),Me=i("p"),Me.innerHTML=Ul,Kt=a(),r(me.$$.fragment),Ot=a(),he=i("p"),he.innerHTML=Tl,es=a(),r(ce.$$.fragment),ts=a(),ye=i("p"),ye.textContent=jl,ss=a(),de=i("ol"),de.innerHTML=gl,ls=a(),ue=i("p"),ue.textContent=wl,as=a(),r(Je.$$.fragment),ns=a(),Ue=i("p"),Ue.textContent=fl,is=a(),r(Te.$$.fragment),ps=a(),r(je.$$.fragment),os=a(),ge=i("p"),ge.innerHTML=Il,rs=a(),r(we.$$.fragment),Ms=a(),fe=i("p"),fe.innerHTML=bl,ms=a(),r(Ie.$$.fragment),hs=a(),be=i("p"),be.innerHTML=Cl,cs=a(),r(T.$$.fragment),ys=a(),r(Ce.$$.fragment),ds=a(),xe=i("p"),xe.innerHTML=xl,us=a(),ke=i("p"),ke.innerHTML=kl,Js=a(),Ne=i("p"),Ne.innerHTML=Nl,Us=a(),r(Ge.$$.fragment),Ts=a(),Ze=i("p"),Ze.textContent=Gl,js=a(),$e=i("p"),$e.innerHTML=Zl,gs=a(),r(ve.$$.fragment),ws=a(),Qe=i("p"),Qe.innerHTML=$l,fs=a(),r(Be.$$.fragment),Is=a(),We=i("p"),We.innerHTML=vl,bs=a(),r(ze.$$.fragment),Cs=a(),Se=i("p"),Se.innerHTML=Ql,xs=a(),r(Ve.$$.fragment),ks=a(),_e=i("p"),_e.innerHTML=Bl,Ns=a(),Re=i("p"),Re.innerHTML=Wl,Gs=a(),Ae=i("p"),Ae.textContent=zl,Zs=a(),r(qe.$$.fragment),$s=a(),He=i("p"),He.textContent=Sl,vs=a(),Xe=i("p"),Xe.innerHTML=Vl,Qs=a(),Fe=i("p"),Fe.textContent=_l,Bs=a(),r(Ye.$$.fragment),Ws=a(),Ee=i("p"),Ee.textContent=Rl,zs=a(),r(Le.$$.fragment),Ss=a(),De=i("p"),De.innerHTML=Al,Vs=a(),r(Pe.$$.fragment),_s=a(),Ke=i("p"),Ke.textContent=ql,Rs=a(),r(Oe.$$.fragment),As=a(),et=i("p"),et.innerHTML=Hl,qs=a(),r(tt.$$.fragment),Hs=a(),st=i("p"),st.innerHTML=Xl,Xs=a(),r(lt.$$.fragment),Fs=a(),r(at.$$.fragment),Ys=a(),nt=i("p"),nt.innerHTML=Fl,Es=a(),it=i("p"),this.h()},l(e){const t=ea("svelte-u9bgzb",document.head);J=p(t,"META",{name:!0,content:!0}),t.forEach(s),U=n(e),j=p(e,"P",{}),El(j).forEach(s),ot=n(e),M(g.$$.fragment,e),rt=n(e),M(w.$$.fragment,e),Mt=n(e),f=p(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-ydi30o"&&(f.innerHTML=Ds),mt=n(e),I=p(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1p8dq8"&&(I.innerHTML=Ps),ht=n(e),b=p(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1n6wf0k"&&(b.innerHTML=Ks),ct=n(e),M(C.$$.fragment,e),yt=n(e),x=p(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1e3bvfs"&&(x.innerHTML=Os),dt=n(e),M(k.$$.fragment,e),ut=n(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-15k3bj3"&&(N.textContent=el),Jt=n(e),M(G.$$.fragment,e),Ut=n(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1qjxrus"&&(Z.innerHTML=tl),Tt=n(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-gmslqw"&&($.innerHTML=sl),jt=n(e),M(v.$$.fragment,e),gt=n(e),Q=p(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1vy7akj"&&(Q.textContent=ll),wt=n(e),M(B.$$.fragment,e),ft=n(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-hj60o5"&&(W.textContent=al),It=n(e),M(z.$$.fragment,e),bt=n(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1bfcqd3"&&(S.textContent=nl),Ct=n(e),M(V.$$.fragment,e),xt=n(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-k9m2iy"&&(_.textContent=il),kt=n(e),M(R.$$.fragment,e),Nt=n(e),A=p(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-znnkjx"&&(A.innerHTML=pl),Gt=n(e),M(q.$$.fragment,e),Zt=n(e),M(H.$$.fragment,e),$t=n(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-5umvde"&&(X.innerHTML=ol),vt=n(e),M(F.$$.fragment,e),Qt=n(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-rhnu79"&&(Y.innerHTML=rl),Bt=n(e),M(E.$$.fragment,e),Wt=n(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1g5nifq"&&(L.textContent=Ml),zt=n(e),M(D.$$.fragment,e),St=n(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-61bp3d"&&(P.innerHTML=ml),Vt=n(e),M(K.$$.fragment,e),_t=n(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-inq88f"&&(O.textContent=hl),Rt=n(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-76qw2e"&&(ee.innerHTML=cl),At=n(e),M(te.$$.fragment,e),qt=n(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-i6ltb0"&&(se.innerHTML=yl),Ht=n(e),M(le.$$.fragment,e),Xt=n(e),ae=p(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-13505nn"&&(ae.textContent=dl),Ft=n(e),M(ne.$$.fragment,e),Yt=n(e),ie=p(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-ziuqkt"&&(ie.innerHTML=ul),Et=n(e),M(pe.$$.fragment,e),Lt=n(e),oe=p(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-9hx4bd"&&(oe.innerHTML=Jl),Dt=n(e),M(re.$$.fragment,e),Pt=n(e),Me=p(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-gucfz7"&&(Me.innerHTML=Ul),Kt=n(e),M(me.$$.fragment,e),Ot=n(e),he=p(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-zet1qo"&&(he.innerHTML=Tl),es=n(e),M(ce.$$.fragment,e),ts=n(e),ye=p(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-9bdwn1"&&(ye.textContent=jl),ss=n(e),de=p(e,"OL",{"data-svelte-h":!0}),o(de)!=="svelte-yy2gop"&&(de.innerHTML=gl),ls=n(e),ue=p(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-jxu6rq"&&(ue.textContent=wl),as=n(e),M(Je.$$.fragment,e),ns=n(e),Ue=p(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-dqaxjt"&&(Ue.textContent=fl),is=n(e),M(Te.$$.fragment,e),ps=n(e),M(je.$$.fragment,e),os=n(e),ge=p(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-1ubxgh9"&&(ge.innerHTML=Il),rs=n(e),M(we.$$.fragment,e),Ms=n(e),fe=p(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-t74z56"&&(fe.innerHTML=bl),ms=n(e),M(Ie.$$.fragment,e),hs=n(e),be=p(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-pl6d88"&&(be.innerHTML=Cl),cs=n(e),M(T.$$.fragment,e),ys=n(e),M(Ce.$$.fragment,e),ds=n(e),xe=p(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-wev7i6"&&(xe.innerHTML=xl),us=n(e),ke=p(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-1o0lzen"&&(ke.innerHTML=kl),Js=n(e),Ne=p(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-1o7n9tk"&&(Ne.innerHTML=Nl),Us=n(e),M(Ge.$$.fragment,e),Ts=n(e),Ze=p(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-5u6sqi"&&(Ze.textContent=Gl),js=n(e),$e=p(e,"P",{"data-svelte-h":!0}),o($e)!=="svelte-ffreiw"&&($e.innerHTML=Zl),gs=n(e),M(ve.$$.fragment,e),ws=n(e),Qe=p(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-1cj1ql7"&&(Qe.innerHTML=$l),fs=n(e),M(Be.$$.fragment,e),Is=n(e),We=p(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-soh9qu"&&(We.innerHTML=vl),bs=n(e),M(ze.$$.fragment,e),Cs=n(e),Se=p(e,"P",{"data-svelte-h":!0}),o(Se)!=="svelte-14p3dvw"&&(Se.innerHTML=Ql),xs=n(e),M(Ve.$$.fragment,e),ks=n(e),_e=p(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-12av8vh"&&(_e.innerHTML=Bl),Ns=n(e),Re=p(e,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-kn2i6o"&&(Re.innerHTML=Wl),Gs=n(e),Ae=p(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-197jyne"&&(Ae.textContent=zl),Zs=n(e),M(qe.$$.fragment,e),$s=n(e),He=p(e,"P",{"data-svelte-h":!0}),o(He)!=="svelte-64od1c"&&(He.textContent=Sl),vs=n(e),Xe=p(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-155y3gc"&&(Xe.innerHTML=Vl),Qs=n(e),Fe=p(e,"P",{"data-svelte-h":!0}),o(Fe)!=="svelte-1hxm0m6"&&(Fe.textContent=_l),Bs=n(e),M(Ye.$$.fragment,e),Ws=n(e),Ee=p(e,"P",{"data-svelte-h":!0}),o(Ee)!=="svelte-1mepej5"&&(Ee.textContent=Rl),zs=n(e),M(Le.$$.fragment,e),Ss=n(e),De=p(e,"P",{"data-svelte-h":!0}),o(De)!=="svelte-rw0syz"&&(De.innerHTML=Al),Vs=n(e),M(Pe.$$.fragment,e),_s=n(e),Ke=p(e,"P",{"data-svelte-h":!0}),o(Ke)!=="svelte-audzqy"&&(Ke.textContent=ql),Rs=n(e),M(Oe.$$.fragment,e),As=n(e),et=p(e,"P",{"data-svelte-h":!0}),o(et)!=="svelte-gc7ich"&&(et.innerHTML=Hl),qs=n(e),M(tt.$$.fragment,e),Hs=n(e),st=p(e,"P",{"data-svelte-h":!0}),o(st)!=="svelte-1ky9l6m"&&(st.innerHTML=Xl),Xs=n(e),M(lt.$$.fragment,e),Fs=n(e),M(at.$$.fragment,e),Ys=n(e),nt=p(e,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-qra3hk"&&(nt.innerHTML=Fl),Es=n(e),it=p(e,"P",{}),El(it).forEach(s),this.h()},h(){Ll(J,"name","hf:doc:metadata"),Ll(J,"content",pa)},m(e,t){ta(document.head,J),l(e,U,t),l(e,j,t),l(e,ot,t),m(g,e,t),l(e,rt,t),m(w,e,t),l(e,Mt,t),l(e,f,t),l(e,mt,t),l(e,I,t),l(e,ht,t),l(e,b,t),l(e,ct,t),m(C,e,t),l(e,yt,t),l(e,x,t),l(e,dt,t),m(k,e,t),l(e,ut,t),l(e,N,t),l(e,Jt,t),m(G,e,t),l(e,Ut,t),l(e,Z,t),l(e,Tt,t),l(e,$,t),l(e,jt,t),m(v,e,t),l(e,gt,t),l(e,Q,t),l(e,wt,t),m(B,e,t),l(e,ft,t),l(e,W,t),l(e,It,t),m(z,e,t),l(e,bt,t),l(e,S,t),l(e,Ct,t),m(V,e,t),l(e,xt,t),l(e,_,t),l(e,kt,t),m(R,e,t),l(e,Nt,t),l(e,A,t),l(e,Gt,t),m(q,e,t),l(e,Zt,t),m(H,e,t),l(e,$t,t),l(e,X,t),l(e,vt,t),m(F,e,t),l(e,Qt,t),l(e,Y,t),l(e,Bt,t),m(E,e,t),l(e,Wt,t),l(e,L,t),l(e,zt,t),m(D,e,t),l(e,St,t),l(e,P,t),l(e,Vt,t),m(K,e,t),l(e,_t,t),l(e,O,t),l(e,Rt,t),l(e,ee,t),l(e,At,t),m(te,e,t),l(e,qt,t),l(e,se,t),l(e,Ht,t),m(le,e,t),l(e,Xt,t),l(e,ae,t),l(e,Ft,t),m(ne,e,t),l(e,Yt,t),l(e,ie,t),l(e,Et,t),m(pe,e,t),l(e,Lt,t),l(e,oe,t),l(e,Dt,t),m(re,e,t),l(e,Pt,t),l(e,Me,t),l(e,Kt,t),m(me,e,t),l(e,Ot,t),l(e,he,t),l(e,es,t),m(ce,e,t),l(e,ts,t),l(e,ye,t),l(e,ss,t),l(e,de,t),l(e,ls,t),l(e,ue,t),l(e,as,t),m(Je,e,t),l(e,ns,t),l(e,Ue,t),l(e,is,t),m(Te,e,t),l(e,ps,t),m(je,e,t),l(e,os,t),l(e,ge,t),l(e,rs,t),m(we,e,t),l(e,Ms,t),l(e,fe,t),l(e,ms,t),m(Ie,e,t),l(e,hs,t),l(e,be,t),l(e,cs,t),m(T,e,t),l(e,ys,t),m(Ce,e,t),l(e,ds,t),l(e,xe,t),l(e,us,t),l(e,ke,t),l(e,Js,t),l(e,Ne,t),l(e,Us,t),m(Ge,e,t),l(e,Ts,t),l(e,Ze,t),l(e,js,t),l(e,$e,t),l(e,gs,t),m(ve,e,t),l(e,ws,t),l(e,Qe,t),l(e,fs,t),m(Be,e,t),l(e,Is,t),l(e,We,t),l(e,bs,t),m(ze,e,t),l(e,Cs,t),l(e,Se,t),l(e,xs,t),m(Ve,e,t),l(e,ks,t),l(e,_e,t),l(e,Ns,t),l(e,Re,t),l(e,Gs,t),l(e,Ae,t),l(e,Zs,t),m(qe,e,t),l(e,$s,t),l(e,He,t),l(e,vs,t),l(e,Xe,t),l(e,Qs,t),l(e,Fe,t),l(e,Bs,t),m(Ye,e,t),l(e,Ws,t),l(e,Ee,t),l(e,zs,t),m(Le,e,t),l(e,Ss,t),l(e,De,t),l(e,Vs,t),m(Pe,e,t),l(e,_s,t),l(e,Ke,t),l(e,Rs,t),m(Oe,e,t),l(e,As,t),l(e,et,t),l(e,qs,t),m(tt,e,t),l(e,Hs,t),l(e,st,t),l(e,Xs,t),m(lt,e,t),l(e,Fs,t),m(at,e,t),l(e,Ys,t),l(e,nt,t),l(e,Es,t),l(e,it,t),Ls=!0},p(e,[t]){const Yl={};t&2&&(Yl.$$scope={dirty:t,ctx:e}),T.$set(Yl)},i(e){Ls||(h(g.$$.fragment,e),h(w.$$.fragment,e),h(C.$$.fragment,e),h(k.$$.fragment,e),h(G.$$.fragment,e),h(v.$$.fragment,e),h(B.$$.fragment,e),h(z.$$.fragment,e),h(V.$$.fragment,e),h(R.$$.fragment,e),h(q.$$.fragment,e),h(H.$$.fragment,e),h(F.$$.fragment,e),h(E.$$.fragment,e),h(D.$$.fragment,e),h(K.$$.fragment,e),h(te.$$.fragment,e),h(le.$$.fragment,e),h(ne.$$.fragment,e),h(pe.$$.fragment,e),h(re.$$.fragment,e),h(me.$$.fragment,e),h(ce.$$.fragment,e),h(Je.$$.fragment,e),h(Te.$$.fragment,e),h(je.$$.fragment,e),h(we.$$.fragment,e),h(Ie.$$.fragment,e),h(T.$$.fragment,e),h(Ce.$$.fragment,e),h(Ge.$$.fragment,e),h(ve.$$.fragment,e),h(Be.$$.fragment,e),h(ze.$$.fragment,e),h(Ve.$$.fragment,e),h(qe.$$.fragment,e),h(Ye.$$.fragment,e),h(Le.$$.fragment,e),h(Pe.$$.fragment,e),h(Oe.$$.fragment,e),h(tt.$$.fragment,e),h(lt.$$.fragment,e),h(at.$$.fragment,e),Ls=!0)},o(e){c(g.$$.fragment,e),c(w.$$.fragment,e),c(C.$$.fragment,e),c(k.$$.fragment,e),c(G.$$.fragment,e),c(v.$$.fragment,e),c(B.$$.fragment,e),c(z.$$.fragment,e),c(V.$$.fragment,e),c(R.$$.fragment,e),c(q.$$.fragment,e),c(H.$$.fragment,e),c(F.$$.fragment,e),c(E.$$.fragment,e),c(D.$$.fragment,e),c(K.$$.fragment,e),c(te.$$.fragment,e),c(le.$$.fragment,e),c(ne.$$.fragment,e),c(pe.$$.fragment,e),c(re.$$.fragment,e),c(me.$$.fragment,e),c(ce.$$.fragment,e),c(Je.$$.fragment,e),c(Te.$$.fragment,e),c(je.$$.fragment,e),c(we.$$.fragment,e),c(Ie.$$.fragment,e),c(T.$$.fragment,e),c(Ce.$$.fragment,e),c(Ge.$$.fragment,e),c(ve.$$.fragment,e),c(Be.$$.fragment,e),c(ze.$$.fragment,e),c(Ve.$$.fragment,e),c(qe.$$.fragment,e),c(Ye.$$.fragment,e),c(Le.$$.fragment,e),c(Pe.$$.fragment,e),c(Oe.$$.fragment,e),c(tt.$$.fragment,e),c(lt.$$.fragment,e),c(at.$$.fragment,e),Ls=!1},d(e){e&&(s(U),s(j),s(ot),s(rt),s(Mt),s(f),s(mt),s(I),s(ht),s(b),s(ct),s(yt),s(x),s(dt),s(ut),s(N),s(Jt),s(Ut),s(Z),s(Tt),s($),s(jt),s(gt),s(Q),s(wt),s(ft),s(W),s(It),s(bt),s(S),s(Ct),s(xt),s(_),s(kt),s(Nt),s(A),s(Gt),s(Zt),s($t),s(X),s(vt),s(Qt),s(Y),s(Bt),s(Wt),s(L),s(zt),s(St),s(P),s(Vt),s(_t),s(O),s(Rt),s(ee),s(At),s(qt),s(se),s(Ht),s(Xt),s(ae),s(Ft),s(Yt),s(ie),s(Et),s(Lt),s(oe),s(Dt),s(Pt),s(Me),s(Kt),s(Ot),s(he),s(es),s(ts),s(ye),s(ss),s(de),s(ls),s(ue),s(as),s(ns),s(Ue),s(is),s(ps),s(os),s(ge),s(rs),s(Ms),s(fe),s(ms),s(hs),s(be),s(cs),s(ys),s(ds),s(xe),s(us),s(ke),s(Js),s(Ne),s(Us),s(Ts),s(Ze),s(js),s($e),s(gs),s(ws),s(Qe),s(fs),s(Is),s(We),s(bs),s(Cs),s(Se),s(xs),s(ks),s(_e),s(Ns),s(Re),s(Gs),s(Ae),s(Zs),s($s),s(He),s(vs),s(Xe),s(Qs),s(Fe),s(Bs),s(Ws),s(Ee),s(zs),s(Ss),s(De),s(Vs),s(_s),s(Ke),s(Rs),s(As),s(et),s(qs),s(Hs),s(st),s(Xs),s(Fs),s(Ys),s(nt),s(Es),s(it)),s(J),y(g,e),y(w,e),y(C,e),y(k,e),y(G,e),y(v,e),y(B,e),y(z,e),y(V,e),y(R,e),y(q,e),y(H,e),y(F,e),y(E,e),y(D,e),y(K,e),y(te,e),y(le,e),y(ne,e),y(pe,e),y(re,e),y(me,e),y(ce,e),y(Je,e),y(Te,e),y(je,e),y(we,e),y(Ie,e),y(T,e),y(Ce,e),y(Ge,e),y(ve,e),y(Be,e),y(ze,e),y(Ve,e),y(qe,e),y(Ye,e),y(Le,e),y(Pe,e),y(Oe,e),y(tt,e),y(lt,e),y(at,e)}}}const pa='{"title":"Templates for Chat Models","local":"templates-for-chat-models","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"How do I use chat templates?","local":"how-do-i-use-chat-templates","sections":[],"depth":2},{"title":"Is there an automated pipeline for chat?","local":"is-there-an-automated-pipeline-for-chat","sections":[],"depth":2},{"title":"What are “generation prompts”?","local":"what-are-generation-prompts","sections":[],"depth":2},{"title":"Can I use chat templates in training?","local":"can-i-use-chat-templates-in-training","sections":[],"depth":2},{"title":"Advanced: How do chat templates work?","local":"advanced-how-do-chat-templates-work","sections":[],"depth":2},{"title":"Advanced: Adding and editing chat templates","local":"advanced-adding-and-editing-chat-templates","sections":[{"title":"How do I create a chat template?","local":"how-do-i-create-a-chat-template","sections":[],"depth":3},{"title":"What are “default” templates?","local":"what-are-default-templates","sections":[],"depth":3},{"title":"What template should I use?","local":"what-template-should-i-use","sections":[],"depth":3},{"title":"I want to add some chat templates! How should I get started?","local":"i-want-to-add-some-chat-templates-how-should-i-get-started","sections":[],"depth":3}],"depth":2},{"title":"Advanced: Template writing tips","local":"advanced-template-writing-tips","sections":[{"title":"For loops","local":"for-loops","sections":[],"depth":3},{"title":"If statements","local":"if-statements","sections":[],"depth":3},{"title":"Special variables","local":"special-variables","sections":[],"depth":3},{"title":"Notes on whitespace","local":"notes-on-whitespace","sections":[],"depth":3}],"depth":2}],"depth":1}';function oa(pt){return Pl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ya extends Kl{constructor(J){super(),Ol(this,J,oa,ia,Dl,{})}}export{ya as component};
