import{s as Ot,o as Dt,n as je}from"../chunks/scheduler.9bc65507.js";import{S as Kt,i as en,g as l,s as o,r as u,A as tn,h as d,f as n,c as a,j as I,u as f,x as p,k as q,y as i,a as r,v as g,d as _,t as b,w as y}from"../chunks/index.707bf1b6.js";import{T as St}from"../chunks/Tip.c2ecdbf4.js";import{D as _e}from"../chunks/Docstring.17db21ae.js";import{C as We}from"../chunks/CodeBlock.54a9f38d.js";import{E as Yt}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as U}from"../chunks/Heading.342b1fa6.js";function nn(C){let s,T="Example:",m,h,w;return h=new We({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFN0YWJsZUxtTW9kZWwlMkMlMjBTdGFibGVMbUNvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBTdGFibGVMTSUyMHN0YWJsZWxtLTNiJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFN0YWJsZUxtQ29uZmlnKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> StableLmModel, StableLmConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a StableLM stablelm-3b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = StableLmConfig()`,wrap:!1}}),{c(){s=l("p"),s.textContent=T,m=o(),u(h.$$.fragment)},l(c){s=d(c,"P",{"data-svelte-h":!0}),p(s)!=="svelte-11lpom8"&&(s.textContent=T),m=a(c),f(h.$$.fragment,c)},m(c,k){r(c,s,k),r(c,m,k),g(h,c,k),w=!0},p:je,i(c){w||(_(h.$$.fragment,c),w=!0)},o(c){b(h.$$.fragment,c),w=!1},d(c){c&&(n(s),n(m)),y(h,c)}}}function on(C){let s,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=l("p"),s.innerHTML=T},l(m){s=d(m,"P",{"data-svelte-h":!0}),p(s)!=="svelte-fincs2"&&(s.innerHTML=T)},m(m,h){r(m,s,h)},p:je,d(m){m&&n(s)}}}function an(C){let s,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=l("p"),s.innerHTML=T},l(m){s=d(m,"P",{"data-svelte-h":!0}),p(s)!=="svelte-fincs2"&&(s.innerHTML=T)},m(m,h){r(m,s,h)},p:je,d(m){m&&n(s)}}}function sn(C){let s,T="Example:",m,h,w;return h=new We({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBTdGFibGVMbUZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBTdGFibGVMbUZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZWxtLTNiLTRlMXQlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGVsbS0zYi00ZTF0JTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMlRoZSUyMHdlYXRoZXIlMjBpcyUyMGFsd2F5cyUyMHdvbmRlcmZ1bCUyMGluJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwR2VuZXJhdGUlMEFnZW5lcmF0ZV9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMuaW5wdXRfaWRzJTJDJTIwbWF4X2xlbmd0aCUzRDMwKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, StableLmForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = StableLmForCausalLM.from_pretrained(<span class="hljs-string">&quot;stabilityai/stablelm-3b-4e1t&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;stabilityai/stablelm-3b-4e1t&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;The weather is always wonderful in&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;The weather is always wonderful in the summer in the city of San Diego. The city is located on the coast of the Pacific Ocean and is surrounded by&#x27;</span>`,wrap:!1}}),{c(){s=l("p"),s.textContent=T,m=o(),u(h.$$.fragment)},l(c){s=d(c,"P",{"data-svelte-h":!0}),p(s)!=="svelte-11lpom8"&&(s.textContent=T),m=a(c),f(h.$$.fragment,c)},m(c,k){r(c,s,k),r(c,m,k),g(h,c,k),w=!0},p:je,i(c){w||(_(h.$$.fragment,c),w=!0)},o(c){b(h.$$.fragment,c),w=!1},d(c){c&&(n(s),n(m)),y(h,c)}}}function rn(C){let s,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=l("p"),s.innerHTML=T},l(m){s=d(m,"P",{"data-svelte-h":!0}),p(s)!=="svelte-fincs2"&&(s.innerHTML=T)},m(m,h){r(m,s,h)},p:je,d(m){m&&n(s)}}}function ln(C){let s,T,m,h,w,c,k,Ze,V,Ct='<code>StableLM 3B 4E1T</code> was proposed in <a href="https://stability.wandb.io/stability-llm/stable-lm/reports/StableLM-3B-4E1T--VmlldzoyMjU4?accessToken=u3zujipenkx5g7rtcj9qojjgxpconyjktjkli2po09nffrffdhhchq045vp0wyfo" rel="nofollow"><code>StableLM 3B 4E1T</code>: Technical Report</a> by Stability AI and is the first model in a series of multi-epoch pre-trained language models.',Ie,H,qe,X,zt=`<code>StableLM 3B 4E1T</code> is a decoder-only base language model pre-trained on 1 trillion tokens of diverse English and code datasets for four epochs.
The model architecture is transformer-based with partial Rotary Position Embeddings, SwiGLU activation, LayerNorm, etc.`,Ue,A,xt="We also provide <code>StableLM Zephyr 3B</code>, an instruction fine-tuned version of the model that can be used for chat-based applications.",Re,E,Ge,Q,Ft='<li>The architecture is similar to LLaMA but with RoPE applied to 25% of head embedding dimensions, LayerNorm instead of RMSNorm, and optional QKV bias terms.</li> <li><code>StableLM 3B 4E1T</code>-based models uses the same tokenizer as <a href="/docs/transformers/main/en/model_doc/gpt_neox#transformers.GPTNeoXTokenizerFast">GPTNeoXTokenizerFast</a>.</li>',Pe,Y,Jt='<code>StableLM 3B 4E1T</code> and <code>StableLM Zephyr 3B</code> can be found on the <a href="https://huggingface.co/stabilityai" rel="nofollow">Huggingface Hub</a>',Be,O,Wt="The following code snippet demonstrates how to use <code>StableLM 3B 4E1T</code> for inference:",Ne,D,Ve,K,He,ee,jt="First, make sure to install the latest version of Flash Attention v2.",Xe,te,Ae,ne,Zt='Also make sure that your hardware is compatible with Flash-Attention 2. Read more about it in the official documentation of the <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow"><code>flash-attn</code></a> repository. Note: you must load your model in half-precision (e.g. <code>torch.bfloat16</code>).',Ee,oe,It="Now, to run the model with Flash Attention 2, refer to the snippet below:",Qe,ae,Ye,se,Oe,$,re,rt,be,qt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/stablelm#transformers.StableLmModel">~StableLmModel</a>.
It is used to instantiate an StableLM model according to the specified arguments, defining the model
architecture. Instantiating a configuration with the defaults will yield a similar configuration to that of
the StableLM <a href="https://huggingface.co/stabilityai/stablelm-3b-4e1t" rel="nofollow">stabilityai/stablelm-3b-4e1t</a> architecture.`,it,ye,Ut=`Configuration objects inherit from  <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used
to control the model outputs. Read the documentation from  <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>
for more information.`,lt,R,De,ie,Ke,M,le,dt,Te,Rt=`The bare StableLm Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ct,ve,Gt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,mt,we,Pt="Transformer decoder consisting of <em>config.num_hidden_layers</em> layers. Each layer is a <code>StableLmDecoderLayer</code>",pt,J,de,ht,ke,Bt='The <a href="/docs/transformers/main/en/model_doc/stablelm#transformers.StableLmModel">StableLmModel</a> forward method, overrides the <code>__call__</code> special method.',ut,G,et,ce,tt,j,me,ft,z,pe,gt,Me,Nt='The <a href="/docs/transformers/main/en/model_doc/stablelm#transformers.StableLmForCausalLM">StableLmForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',_t,P,bt,B,nt,he,ot,v,ue,yt,Le,Vt="The StableLm transformer with a sequence classification head on top (linear layer).",Tt,$e,Ht=`<a href="/docs/transformers/main/en/model_doc/stablelm#transformers.StableLmForSequenceClassification">StableLmForSequenceClassification</a> uses the last token in order to do the classification, as other causal
models (e.g. GPT-2) do.`,vt,Se,Xt=`Since it does classification on the last token, it requires to know the position of the last token. If a
<code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row. If
no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,wt,Ce,At=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,kt,ze,Et=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Mt,W,fe,Lt,xe,Qt='The <a href="/docs/transformers/main/en/model_doc/stablelm#transformers.StableLmForSequenceClassification">StableLmForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',$t,N,at,Je,st;return w=new U({props:{title:"StableLM",local:"stablelm",headingTag:"h1"}}),k=new U({props:{title:"Overview",local:"overview",headingTag:"h2"}}),H=new U({props:{title:"Model Details",local:"model-details",headingTag:"h3"}}),E=new U({props:{title:"Usage Tips",local:"usage-tips",headingTag:"h3"}}),D=new We({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMHNldF9zZWVkJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMCUyMyUyMHRoZSUyMGRldmljZSUyMHRvJTIwbG9hZCUyMHRoZSUyMG1vZGVsJTIwb250byUwQSUwQXNldF9zZWVkKDApJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGVsbS0zYi00ZTF0JTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlbG0tM2ItNGUxdCUyMiklMEFtb2RlbC50byhkZXZpY2UpJTBBbW9kZWxfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMHdlYXRoZXIlMjBpcyUyMGFsd2F5cyUyMHdvbmRlcmZ1bCUyMGluJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8obW9kZWwuZGV2aWNlKSUwQSUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyUyQyUyMG1heF9sZW5ndGglM0QzMiUyQyUyMGRvX3NhbXBsZSUzRFRydWUpJTBBcmVzcG9uc2VzJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBcmVzcG9uc2Vz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-comment"># the device to load the model onto</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;stabilityai/stablelm-3b-4e1t&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;stabilityai/stablelm-3b-4e1t&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer(<span class="hljs-string">&quot;The weather is always wonderful in&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, max_length=<span class="hljs-number">32</span>, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>responses = tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>responses
[<span class="hljs-string">&#x27;The weather is always wonderful in Costa Rica, which makes it a prime destination for retirees. That’s where the Pensionado program comes in, offering&#x27;</span>]`,wrap:!1}}),K=new U({props:{title:"Combining StableLM and Flash Attention 2",local:"combining-stablelm-and-flash-attention-2",headingTag:"h2"}}),te=new We({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0biUyMC0tbm8tYnVpbGQtaXNvbGF0aW9u",highlighted:"pip install -U flash-attn --no-build-isolation",wrap:!1}}),ae=new We({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTJDJTIwc2V0X3NlZWQlMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTIwJTIzJTIwdGhlJTIwZGV2aWNlJTIwdG8lMjBsb2FkJTIwdGhlJTIwbW9kZWwlMjBvbnRvJTBBJTBBc2V0X3NlZWQoMCklMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZWxtLTNiLTRlMXQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGVsbS0zYi00ZTF0JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMGF0dG5faW1wbGVtZW50YXRpb24lM0QlMjJmbGFzaF9hdHRlbnRpb25fMiUyMiklMEFtb2RlbC50byhkZXZpY2UpJTBBbW9kZWxfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMHdlYXRoZXIlMjBpcyUyMGFsd2F5cyUyMHdvbmRlcmZ1bCUyMGluJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8obW9kZWwuZGV2aWNlKSUwQSUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyUyQyUyMG1heF9sZW5ndGglM0QzMiUyQyUyMGRvX3NhbXBsZSUzRFRydWUpJTBBcmVzcG9uc2VzJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBcmVzcG9uc2Vz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-comment"># the device to load the model onto</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;stabilityai/stablelm-3b-4e1t&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;stabilityai/stablelm-3b-4e1t&quot;</span>, torch_dtype=torch.bfloat16, attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer(<span class="hljs-string">&quot;The weather is always wonderful in&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, max_length=<span class="hljs-number">32</span>, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>responses = tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>responses
[<span class="hljs-string">&#x27;The weather is always wonderful in Costa Rica, which makes it a prime destination for retirees. That’s where the Pensionado program comes in, offering&#x27;</span>]`,wrap:!1}}),se=new U({props:{title:"StableLmConfig",local:"transformers.StableLmConfig",headingTag:"h2"}}),re=new _e({props:{name:"class transformers.StableLmConfig",anchor:"transformers.StableLmConfig",parameters:[{name:"vocab_size",val:" = 50304"},{name:"intermediate_size",val:" = 6912"},{name:"hidden_size",val:" = 2560"},{name:"num_hidden_layers",val:" = 32"},{name:"num_attention_heads",val:" = 32"},{name:"num_key_value_heads",val:" = 32"},{name:"hidden_act",val:" = 'silu'"},{name:"max_position_embeddings",val:" = 4096"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"use_cache",val:" = True"},{name:"tie_word_embeddings",val:" = False"},{name:"rope_theta",val:" = 10000"},{name:"rope_scaling",val:" = None"},{name:"use_qkv_bias",val:" = False"},{name:"qk_layernorm",val:" = False"},{name:"use_parallel_residual",val:" = False"},{name:"hidden_dropout",val:" = 0.0"},{name:"attention_dropout",val:" = 0.0"},{name:"partial_rotary_factor",val:" = 0.25"},{name:"bos_token_id",val:" = 0"},{name:"eos_token_id",val:" = 0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StableLmConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 50304) &#x2014;
Vocabulary size of the StableLM model. Defines the number of different tokens that
can be represented by the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/stablelm#transformers.StableLmModel">StableLmModel</a>.`,name:"vocab_size"},{anchor:"transformers.StableLmConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 6912) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.StableLmConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2560) &#x2014;
Number of hidden layers in the Transformer decoder.`,name:"hidden_size"},{anchor:"transformers.StableLmConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of hidden layers in the Transformer decoder.`,name:"num_hidden_layers"},{anchor:"transformers.StableLmConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.StableLmConfig.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1 the model will use Multi Query Attention (MQA) otherwise GQA is used. When converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed by meanpooling all the original heads within that group. For more details checkout [this paper](https://arxiv.org/pdf/2305.13245.pdf). If it is not specified, will default to </code>num_attention_heads\`.`,name:"num_key_value_heads"},{anchor:"transformers.StableLmConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string).`,name:"hidden_act"},{anchor:"transformers.StableLmConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
The maximum sequence length that this model might ever be used with.
Typically set this to something large just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.StableLmConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing
all weight matrices.`,name:"initializer_range"},{anchor:"transformers.StableLmConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.StableLmConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions
(not used by all models). Only relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.StableLmConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model&#x2019;s input and output word embeddings should be tied.`,name:"tie_word_embeddings"},{anchor:"transformers.StableLmConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to <code>10000.0</code>) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.StableLmConfig.rope_scaling",description:`<strong>rope_scaling</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Dictionary containing the scaling configuration for the RoPE embeddings. Currently supports two scaling
strategies: linear and dynamic. Their scaling factor must be a float greater than 1. The expected format is
<code>{&quot;type&quot;: strategy name, &quot;factor&quot;: scaling factor}</code>. When using this flag, don&#x2019;t update
<code>max_position_embeddings</code> to the expected new maximum. See the following thread for more information on how
these scaling strategies behave:
<a href="https://www.reddit.com/r/LocalLLaMA/comments/14mrgpr/dynamically_scaled_rope_further_increases/" rel="nofollow">https://www.reddit.com/r/LocalLLaMA/comments/14mrgpr/dynamically_scaled_rope_further_increases/</a>. This
is an experimental feature, subject to breaking API changes in future versions.`,name:"rope_scaling"},{anchor:"transformers.StableLmConfig.use_qkv_bias",description:`<strong>use_qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the model should use bias for qkv layers.`,name:"use_qkv_bias"},{anchor:"transformers.StableLmConfig.qk_layernorm",description:`<strong>qk_layernorm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to normalize, per head, the Queries and Keys after projecting the hidden states.`,name:"qk_layernorm"},{anchor:"transformers.StableLmConfig.use_parallel_residual",description:`<strong>use_parallel_residual</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a &#x201C;parallel&#x201D; formulation in each Transformer layer, which can provide a slight training
speedup at large scales.`,name:"use_parallel_residual"},{anchor:"transformers.StableLmConfig.hidden_dropout",description:`<strong>hidden_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio after applying the MLP to the hidden states.`,name:"hidden_dropout"},{anchor:"transformers.StableLmConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.StableLmConfig.partial_rotary_factor",description:`<strong>partial_rotary_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.25) &#x2014;
Percentage of the query and keys which will have rotary embedding.`,name:"partial_rotary_factor"},{anchor:"transformers.StableLmConfig.bos_token_id",description:`<strong>bos_token_id</strong> (int, <em>optional</em>, defaults to 0) &#x2014;
The id of the <code>BOS</code> token in the vocabulary.`,name:"bos_token_id"},{anchor:"transformers.StableLmConfig.eos_token_id",description:`<strong>eos_token_id</strong> (int, <em>optional</em>, defaults to 0) &#x2014;
The id of the <code>EOS</code> token in the vocabulary.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/stablelm/configuration_stablelm.py#L27"}}),R=new Yt({props:{anchor:"transformers.StableLmConfig.example",$$slots:{default:[nn]},$$scope:{ctx:C}}}),ie=new U({props:{title:"StableLmModel",local:"transformers.StableLmModel",headingTag:"h2"}}),le=new _e({props:{name:"class transformers.StableLmModel",anchor:"transformers.StableLmModel",parameters:[{name:"config",val:": StableLmConfig"}],parametersDescription:[{anchor:"transformers.StableLmModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/stablelm#transformers.StableLmConfig">StableLmConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.
config &#x2014; StableLmConfig`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/stablelm/modeling_stablelm.py#L908"}}),de=new _e({props:{name:"forward",anchor:"transformers.StableLmModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.StableLmModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StableLmModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.StableLmModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.StableLmModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.StableLmModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.StableLmModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.StableLmModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.StableLmModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.StableLmModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/stablelm/modeling_stablelm.py#L942"}}),G=new St({props:{$$slots:{default:[on]},$$scope:{ctx:C}}}),ce=new U({props:{title:"StableLmForCausalLM",local:"transformers.StableLmForCausalLM",headingTag:"h2"}}),me=new _e({props:{name:"class transformers.StableLmForCausalLM",anchor:"transformers.StableLmForCausalLM",parameters:[{name:"config",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/stablelm/modeling_stablelm.py#L1073"}}),pe=new _e({props:{name:"forward",anchor:"transformers.StableLmForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.StableLmForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StableLmForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.StableLmForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.StableLmForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.StableLmForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.StableLmForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.StableLmForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.StableLmForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.StableLmForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.</p>
<p>Args &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/stablelm/modeling_stablelm.py#L1110",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/stablelm#transformers.StableLmConfig"
>StableLmConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),P=new St({props:{$$slots:{default:[an]},$$scope:{ctx:C}}}),B=new Yt({props:{anchor:"transformers.StableLmForCausalLM.forward.example",$$slots:{default:[sn]},$$scope:{ctx:C}}}),he=new U({props:{title:"StableLmForSequenceClassification",local:"transformers.StableLmForSequenceClassification",headingTag:"h2"}}),ue=new _e({props:{name:"class transformers.StableLmForSequenceClassification",anchor:"transformers.StableLmForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.StableLmForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/stablelm#transformers.StableLmConfig">StableLmConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/stablelm/modeling_stablelm.py#L1264"}}),fe=new _e({props:{name:"forward",anchor:"transformers.StableLmForSequenceClassification.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.StableLmForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StableLmForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.StableLmForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.StableLmForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.StableLmForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.StableLmForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.StableLmForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.StableLmForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.StableLmForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.StableLmForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/stablelm/modeling_stablelm.py#L1296"}}),N=new St({props:{$$slots:{default:[rn]},$$scope:{ctx:C}}}),{c(){s=l("meta"),T=o(),m=l("p"),h=o(),u(w.$$.fragment),c=o(),u(k.$$.fragment),Ze=o(),V=l("p"),V.innerHTML=Ct,Ie=o(),u(H.$$.fragment),qe=o(),X=l("p"),X.innerHTML=zt,Ue=o(),A=l("p"),A.innerHTML=xt,Re=o(),u(E.$$.fragment),Ge=o(),Q=l("ul"),Q.innerHTML=Ft,Pe=o(),Y=l("p"),Y.innerHTML=Jt,Be=o(),O=l("p"),O.innerHTML=Wt,Ne=o(),u(D.$$.fragment),Ve=o(),u(K.$$.fragment),He=o(),ee=l("p"),ee.textContent=jt,Xe=o(),u(te.$$.fragment),Ae=o(),ne=l("p"),ne.innerHTML=Zt,Ee=o(),oe=l("p"),oe.textContent=It,Qe=o(),u(ae.$$.fragment),Ye=o(),u(se.$$.fragment),Oe=o(),$=l("div"),u(re.$$.fragment),rt=o(),be=l("p"),be.innerHTML=qt,it=o(),ye=l("p"),ye.innerHTML=Ut,lt=o(),u(R.$$.fragment),De=o(),u(ie.$$.fragment),Ke=o(),M=l("div"),u(le.$$.fragment),dt=o(),Te=l("p"),Te.innerHTML=Rt,ct=o(),ve=l("p"),ve.innerHTML=Gt,mt=o(),we=l("p"),we.innerHTML=Pt,pt=o(),J=l("div"),u(de.$$.fragment),ht=o(),ke=l("p"),ke.innerHTML=Bt,ut=o(),u(G.$$.fragment),et=o(),u(ce.$$.fragment),tt=o(),j=l("div"),u(me.$$.fragment),ft=o(),z=l("div"),u(pe.$$.fragment),gt=o(),Me=l("p"),Me.innerHTML=Nt,_t=o(),u(P.$$.fragment),bt=o(),u(B.$$.fragment),nt=o(),u(he.$$.fragment),ot=o(),v=l("div"),u(ue.$$.fragment),yt=o(),Le=l("p"),Le.textContent=Vt,Tt=o(),$e=l("p"),$e.innerHTML=Ht,vt=o(),Se=l("p"),Se.innerHTML=Xt,wt=o(),Ce=l("p"),Ce.innerHTML=At,kt=o(),ze=l("p"),ze.innerHTML=Et,Mt=o(),W=l("div"),u(fe.$$.fragment),Lt=o(),xe=l("p"),xe.innerHTML=Qt,$t=o(),u(N.$$.fragment),at=o(),Je=l("p"),this.h()},l(e){const t=tn("svelte-u9bgzb",document.head);s=d(t,"META",{name:!0,content:!0}),t.forEach(n),T=a(e),m=d(e,"P",{}),I(m).forEach(n),h=a(e),f(w.$$.fragment,e),c=a(e),f(k.$$.fragment,e),Ze=a(e),V=d(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-p70wk3"&&(V.innerHTML=Ct),Ie=a(e),f(H.$$.fragment,e),qe=a(e),X=d(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-13e6wpg"&&(X.innerHTML=zt),Ue=a(e),A=d(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-ecv3xy"&&(A.innerHTML=xt),Re=a(e),f(E.$$.fragment,e),Ge=a(e),Q=d(e,"UL",{"data-svelte-h":!0}),p(Q)!=="svelte-1lxeakf"&&(Q.innerHTML=Ft),Pe=a(e),Y=d(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1a9jefj"&&(Y.innerHTML=Jt),Be=a(e),O=d(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-udtc57"&&(O.innerHTML=Wt),Ne=a(e),f(D.$$.fragment,e),Ve=a(e),f(K.$$.fragment,e),He=a(e),ee=d(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-pstkbw"&&(ee.textContent=jt),Xe=a(e),f(te.$$.fragment,e),Ae=a(e),ne=d(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-8b9qy3"&&(ne.innerHTML=Zt),Ee=a(e),oe=d(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1w2ttra"&&(oe.textContent=It),Qe=a(e),f(ae.$$.fragment,e),Ye=a(e),f(se.$$.fragment,e),Oe=a(e),$=d(e,"DIV",{class:!0});var x=I($);f(re.$$.fragment,x),rt=a(x),be=d(x,"P",{"data-svelte-h":!0}),p(be)!=="svelte-m2vol3"&&(be.innerHTML=qt),it=a(x),ye=d(x,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-thm8xj"&&(ye.innerHTML=Ut),lt=a(x),f(R.$$.fragment,x),x.forEach(n),De=a(e),f(ie.$$.fragment,e),Ke=a(e),M=d(e,"DIV",{class:!0});var S=I(M);f(le.$$.fragment,S),dt=a(S),Te=d(S,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-1gvw3z2"&&(Te.innerHTML=Rt),ct=a(S),ve=d(S,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-hswkmf"&&(ve.innerHTML=Gt),mt=a(S),we=d(S,"P",{"data-svelte-h":!0}),p(we)!=="svelte-12wkov7"&&(we.innerHTML=Pt),pt=a(S),J=d(S,"DIV",{class:!0});var Z=I(J);f(de.$$.fragment,Z),ht=a(Z),ke=d(Z,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-nx0vhf"&&(ke.innerHTML=Bt),ut=a(Z),f(G.$$.fragment,Z),Z.forEach(n),S.forEach(n),et=a(e),f(ce.$$.fragment,e),tt=a(e),j=d(e,"DIV",{class:!0});var ge=I(j);f(me.$$.fragment,ge),ft=a(ge),z=d(ge,"DIV",{class:!0});var F=I(z);f(pe.$$.fragment,F),gt=a(F),Me=d(F,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-jv1ouv"&&(Me.innerHTML=Nt),_t=a(F),f(P.$$.fragment,F),bt=a(F),f(B.$$.fragment,F),F.forEach(n),ge.forEach(n),nt=a(e),f(he.$$.fragment,e),ot=a(e),v=d(e,"DIV",{class:!0});var L=I(v);f(ue.$$.fragment,L),yt=a(L),Le=d(L,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-1r4bxkh"&&(Le.textContent=Vt),Tt=a(L),$e=d(L,"P",{"data-svelte-h":!0}),p($e)!=="svelte-y2qvum"&&($e.innerHTML=Ht),vt=a(L),Se=d(L,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-10ugs3m"&&(Se.innerHTML=Xt),wt=a(L),Ce=d(L,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-6pahdo"&&(Ce.innerHTML=At),kt=a(L),ze=d(L,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-hswkmf"&&(ze.innerHTML=Et),Mt=a(L),W=d(L,"DIV",{class:!0});var Fe=I(W);f(fe.$$.fragment,Fe),Lt=a(Fe),xe=d(Fe,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-3mka3v"&&(xe.innerHTML=Qt),$t=a(Fe),f(N.$$.fragment,Fe),Fe.forEach(n),L.forEach(n),at=a(e),Je=d(e,"P",{}),I(Je).forEach(n),this.h()},h(){q(s,"name","hf:doc:metadata"),q(s,"content",dn),q($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){i(document.head,s),r(e,T,t),r(e,m,t),r(e,h,t),g(w,e,t),r(e,c,t),g(k,e,t),r(e,Ze,t),r(e,V,t),r(e,Ie,t),g(H,e,t),r(e,qe,t),r(e,X,t),r(e,Ue,t),r(e,A,t),r(e,Re,t),g(E,e,t),r(e,Ge,t),r(e,Q,t),r(e,Pe,t),r(e,Y,t),r(e,Be,t),r(e,O,t),r(e,Ne,t),g(D,e,t),r(e,Ve,t),g(K,e,t),r(e,He,t),r(e,ee,t),r(e,Xe,t),g(te,e,t),r(e,Ae,t),r(e,ne,t),r(e,Ee,t),r(e,oe,t),r(e,Qe,t),g(ae,e,t),r(e,Ye,t),g(se,e,t),r(e,Oe,t),r(e,$,t),g(re,$,null),i($,rt),i($,be),i($,it),i($,ye),i($,lt),g(R,$,null),r(e,De,t),g(ie,e,t),r(e,Ke,t),r(e,M,t),g(le,M,null),i(M,dt),i(M,Te),i(M,ct),i(M,ve),i(M,mt),i(M,we),i(M,pt),i(M,J),g(de,J,null),i(J,ht),i(J,ke),i(J,ut),g(G,J,null),r(e,et,t),g(ce,e,t),r(e,tt,t),r(e,j,t),g(me,j,null),i(j,ft),i(j,z),g(pe,z,null),i(z,gt),i(z,Me),i(z,_t),g(P,z,null),i(z,bt),g(B,z,null),r(e,nt,t),g(he,e,t),r(e,ot,t),r(e,v,t),g(ue,v,null),i(v,yt),i(v,Le),i(v,Tt),i(v,$e),i(v,vt),i(v,Se),i(v,wt),i(v,Ce),i(v,kt),i(v,ze),i(v,Mt),i(v,W),g(fe,W,null),i(W,Lt),i(W,xe),i(W,$t),g(N,W,null),r(e,at,t),r(e,Je,t),st=!0},p(e,[t]){const x={};t&2&&(x.$$scope={dirty:t,ctx:e}),R.$set(x);const S={};t&2&&(S.$$scope={dirty:t,ctx:e}),G.$set(S);const Z={};t&2&&(Z.$$scope={dirty:t,ctx:e}),P.$set(Z);const ge={};t&2&&(ge.$$scope={dirty:t,ctx:e}),B.$set(ge);const F={};t&2&&(F.$$scope={dirty:t,ctx:e}),N.$set(F)},i(e){st||(_(w.$$.fragment,e),_(k.$$.fragment,e),_(H.$$.fragment,e),_(E.$$.fragment,e),_(D.$$.fragment,e),_(K.$$.fragment,e),_(te.$$.fragment,e),_(ae.$$.fragment,e),_(se.$$.fragment,e),_(re.$$.fragment,e),_(R.$$.fragment,e),_(ie.$$.fragment,e),_(le.$$.fragment,e),_(de.$$.fragment,e),_(G.$$.fragment,e),_(ce.$$.fragment,e),_(me.$$.fragment,e),_(pe.$$.fragment,e),_(P.$$.fragment,e),_(B.$$.fragment,e),_(he.$$.fragment,e),_(ue.$$.fragment,e),_(fe.$$.fragment,e),_(N.$$.fragment,e),st=!0)},o(e){b(w.$$.fragment,e),b(k.$$.fragment,e),b(H.$$.fragment,e),b(E.$$.fragment,e),b(D.$$.fragment,e),b(K.$$.fragment,e),b(te.$$.fragment,e),b(ae.$$.fragment,e),b(se.$$.fragment,e),b(re.$$.fragment,e),b(R.$$.fragment,e),b(ie.$$.fragment,e),b(le.$$.fragment,e),b(de.$$.fragment,e),b(G.$$.fragment,e),b(ce.$$.fragment,e),b(me.$$.fragment,e),b(pe.$$.fragment,e),b(P.$$.fragment,e),b(B.$$.fragment,e),b(he.$$.fragment,e),b(ue.$$.fragment,e),b(fe.$$.fragment,e),b(N.$$.fragment,e),st=!1},d(e){e&&(n(T),n(m),n(h),n(c),n(Ze),n(V),n(Ie),n(qe),n(X),n(Ue),n(A),n(Re),n(Ge),n(Q),n(Pe),n(Y),n(Be),n(O),n(Ne),n(Ve),n(He),n(ee),n(Xe),n(Ae),n(ne),n(Ee),n(oe),n(Qe),n(Ye),n(Oe),n($),n(De),n(Ke),n(M),n(et),n(tt),n(j),n(nt),n(ot),n(v),n(at),n(Je)),n(s),y(w,e),y(k,e),y(H,e),y(E,e),y(D,e),y(K,e),y(te,e),y(ae,e),y(se,e),y(re),y(R),y(ie,e),y(le),y(de),y(G),y(ce,e),y(me),y(pe),y(P),y(B),y(he,e),y(ue),y(fe),y(N)}}}const dn='{"title":"StableLM","local":"stablelm","sections":[{"title":"Overview","local":"overview","sections":[{"title":"Model Details","local":"model-details","sections":[],"depth":3},{"title":"Usage Tips","local":"usage-tips","sections":[],"depth":3}],"depth":2},{"title":"Combining StableLM and Flash Attention 2","local":"combining-stablelm-and-flash-attention-2","sections":[],"depth":2},{"title":"StableLmConfig","local":"transformers.StableLmConfig","sections":[],"depth":2},{"title":"StableLmModel","local":"transformers.StableLmModel","sections":[],"depth":2},{"title":"StableLmForCausalLM","local":"transformers.StableLmForCausalLM","sections":[],"depth":2},{"title":"StableLmForSequenceClassification","local":"transformers.StableLmForSequenceClassification","sections":[],"depth":2}],"depth":1}';function cn(C){return Dt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bn extends Kt{constructor(s){super(),en(this,s,cn,ln,Ot,{})}}export{bn as component};
