import{s as ts,o as ns,n as de}from"../chunks/scheduler.9bc65507.js";import{S as ls,i as os,g as c,s as o,r as h,A as rs,h as p,f as n,c as r,j as se,u as M,x as b,k as ae,y as f,a as l,v as u,d as g,t as y,w as j}from"../chunks/index.707bf1b6.js";import{T as as}from"../chunks/Tip.c2ecdbf4.js";import{D as pe}from"../chunks/Docstring.17db21ae.js";import{C as Ne}from"../chunks/CodeBlock.54a9f38d.js";import{E as ze}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as te}from"../chunks/Heading.342b1fa6.js";function is(U){let a,T="Example:",i,m,d;return m=new Ne({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRpbWVzZm9ybWVyQ29uZmlnJTJDJTIwVGltZXNmb3JtZXJNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBUaW1lU2Zvcm1lciUyMHRpbWVzZm9ybWVyLWJhc2UlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwVGltZXNmb3JtZXJDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBUaW1lc2Zvcm1lck1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TimesformerConfig, TimesformerModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a TimeSformer timesformer-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = TimesformerConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TimesformerModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){a=c("p"),a.textContent=T,i=o(),h(m.$$.fragment)},l(t){a=p(t,"P",{"data-svelte-h":!0}),b(a)!=="svelte-11lpom8"&&(a.textContent=T),i=r(t),M(m.$$.fragment,t)},m(t,w){l(t,a,w),l(t,i,w),u(m,t,w),d=!0},p:de,i(t){d||(g(m.$$.fragment,t),d=!0)},o(t){y(m.$$.fragment,t),d=!1},d(t){t&&(n(a),n(i)),j(m,t)}}}function ms(U){let a,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=c("p"),a.innerHTML=T},l(i){a=p(i,"P",{"data-svelte-h":!0}),b(a)!=="svelte-fincs2"&&(a.innerHTML=T)},m(i,m){l(i,a,m)},p:de,d(i){i&&n(a)}}}function cs(U){let a,T="Examples:",i,m,d;return m=new Ne({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> av
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TimesformerModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

<span class="hljs-meta">&gt;&gt;&gt; </span>np.random.seed(<span class="hljs-number">0</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">read_video_pyav</span>(<span class="hljs-params">container, indices</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Decode the video with PyAV decoder.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        container (\`av.container.input.InputContainer\`): PyAV container.
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of frame indices to decode.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        result (np.ndarray): np array of decoded frames of shape (num_frames, height, width, 3).
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    frames = []
<span class="hljs-meta">... </span>    container.seek(<span class="hljs-number">0</span>)
<span class="hljs-meta">... </span>    start_index = indices[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>    end_index = indices[-<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, frame <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(container.decode(video=<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt; end_index:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">break</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt;= start_index <span class="hljs-keyword">and</span> i <span class="hljs-keyword">in</span> indices:
<span class="hljs-meta">... </span>            frames.append(frame)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> np.stack([x.to_ndarray(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;rgb24&quot;</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> frames])


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">sample_frame_indices</span>(<span class="hljs-params">clip_len, frame_sample_rate, seg_len</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Sample a given number of frame indices from the video.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        clip_len (\`int\`): Total number of frames to sample.
<span class="hljs-meta">... </span>        frame_sample_rate (\`int\`): Sample every n-th frame.
<span class="hljs-meta">... </span>        seg_len (\`int\`): Maximum allowed index of sample&#x27;s last frame.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of sampled frame indices
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    converted_len = <span class="hljs-built_in">int</span>(clip_len * frame_sample_rate)
<span class="hljs-meta">... </span>    end_idx = np.random.randint(converted_len, seg_len)
<span class="hljs-meta">... </span>    start_idx = end_idx - converted_len
<span class="hljs-meta">... </span>    indices = np.linspace(start_idx, end_idx, num=clip_len)
<span class="hljs-meta">... </span>    indices = np.clip(indices, start_idx, end_idx - <span class="hljs-number">1</span>).astype(np.int64)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> indices


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># video clip consists of 300 frames (10 seconds at 30 FPS)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>file_path = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;nielsr/video-demo&quot;</span>, filename=<span class="hljs-string">&quot;eating_spaghetti.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>container = av.<span class="hljs-built_in">open</span>(file_path)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sample 8 frames</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>indices = sample_frame_indices(clip_len=<span class="hljs-number">8</span>, frame_sample_rate=<span class="hljs-number">4</span>, seg_len=container.streams.video[<span class="hljs-number">0</span>].frames)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = read_video_pyav(container, indices)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;MCG-NJU/videomae-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TimesformerModel.from_pretrained(<span class="hljs-string">&quot;facebook/timesformer-base-finetuned-k400&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare video for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(<span class="hljs-built_in">list</span>(video), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">1569</span>, <span class="hljs-number">768</span>]`,wrap:!1}}),{c(){a=c("p"),a.textContent=T,i=o(),h(m.$$.fragment)},l(t){a=p(t,"P",{"data-svelte-h":!0}),b(a)!=="svelte-kvfsh7"&&(a.textContent=T),i=r(t),M(m.$$.fragment,t)},m(t,w){l(t,a,w),l(t,i,w),u(m,t,w),d=!0},p:de,i(t){d||(g(m.$$.fragment,t),d=!0)},o(t){y(m.$$.fragment,t),d=!1},d(t){t&&(n(a),n(i)),j(m,t)}}}function ps(U){let a,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=c("p"),a.innerHTML=T},l(i){a=p(i,"P",{"data-svelte-h":!0}),b(a)!=="svelte-fincs2"&&(a.innerHTML=T)},m(i,m){l(i,a,m)},p:de,d(i){i&&n(a)}}}function ds(U){let a,T="Examples:",i,m,d;return m=new Ne({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> av
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TimesformerForVideoClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

<span class="hljs-meta">&gt;&gt;&gt; </span>np.random.seed(<span class="hljs-number">0</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">read_video_pyav</span>(<span class="hljs-params">container, indices</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Decode the video with PyAV decoder.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        container (\`av.container.input.InputContainer\`): PyAV container.
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of frame indices to decode.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        result (np.ndarray): np array of decoded frames of shape (num_frames, height, width, 3).
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    frames = []
<span class="hljs-meta">... </span>    container.seek(<span class="hljs-number">0</span>)
<span class="hljs-meta">... </span>    start_index = indices[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>    end_index = indices[-<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, frame <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(container.decode(video=<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt; end_index:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">break</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt;= start_index <span class="hljs-keyword">and</span> i <span class="hljs-keyword">in</span> indices:
<span class="hljs-meta">... </span>            frames.append(frame)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> np.stack([x.to_ndarray(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;rgb24&quot;</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> frames])


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">sample_frame_indices</span>(<span class="hljs-params">clip_len, frame_sample_rate, seg_len</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Sample a given number of frame indices from the video.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        clip_len (\`int\`): Total number of frames to sample.
<span class="hljs-meta">... </span>        frame_sample_rate (\`int\`): Sample every n-th frame.
<span class="hljs-meta">... </span>        seg_len (\`int\`): Maximum allowed index of sample&#x27;s last frame.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of sampled frame indices
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    converted_len = <span class="hljs-built_in">int</span>(clip_len * frame_sample_rate)
<span class="hljs-meta">... </span>    end_idx = np.random.randint(converted_len, seg_len)
<span class="hljs-meta">... </span>    start_idx = end_idx - converted_len
<span class="hljs-meta">... </span>    indices = np.linspace(start_idx, end_idx, num=clip_len)
<span class="hljs-meta">... </span>    indices = np.clip(indices, start_idx, end_idx - <span class="hljs-number">1</span>).astype(np.int64)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> indices


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># video clip consists of 300 frames (10 seconds at 30 FPS)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>file_path = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;nielsr/video-demo&quot;</span>, filename=<span class="hljs-string">&quot;eating_spaghetti.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>container = av.<span class="hljs-built_in">open</span>(file_path)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sample 8 frames</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>indices = sample_frame_indices(clip_len=<span class="hljs-number">8</span>, frame_sample_rate=<span class="hljs-number">1</span>, seg_len=container.streams.video[<span class="hljs-number">0</span>].frames)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = read_video_pyav(container, indices)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;MCG-NJU/videomae-base-finetuned-kinetics&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TimesformerForVideoClassification.from_pretrained(<span class="hljs-string">&quot;facebook/timesformer-base-finetuned-k400&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(<span class="hljs-built_in">list</span>(video), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    logits = outputs.logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 400 Kinetics-400 classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
eating spaghetti`,wrap:!1}}),{c(){a=c("p"),a.textContent=T,i=o(),h(m.$$.fragment)},l(t){a=p(t,"P",{"data-svelte-h":!0}),b(a)!=="svelte-kvfsh7"&&(a.textContent=T),i=r(t),M(m.$$.fragment,t)},m(t,w){l(t,a,w),l(t,i,w),u(m,t,w),d=!0},p:de,i(t){d||(g(m.$$.fragment,t),d=!0)},o(t){y(m.$$.fragment,t),d=!1},d(t){t&&(n(a),n(i)),j(m,t)}}}function fs(U){let a,T,i,m,d,t,w,fe,X,Re=`The TimeSformer model was proposed in <a href="https://arxiv.org/abs/2102.05095" rel="nofollow">TimeSformer: Is Space-Time Attention All You Need for Video Understanding?</a> by Facebook Research.
This work is a milestone in action-recognition field being the first video transformer. It inspired many transformer based video understanding and classification papers.`,he,S,Qe="The abstract from the paper is the following:",Me,E,Ye='<em>We present a convolution-free approach to video classification built exclusively on self-attention over space and time. Our method, named “TimeSformer,” adapts the standard Transformer architecture to video by enabling spatiotemporal feature learning directly from a sequence of frame-level patches. Our experimental study compares different self-attention schemes and suggests that “divided attention,” where temporal attention and spatial attention are separately applied within each block, leads to the best video classification accuracy among the design choices considered. Despite the radically new design, TimeSformer achieves state-of-the-art results on several action recognition benchmarks, including the best reported accuracy on Kinetics-400 and Kinetics-600. Finally, compared to 3D convolutional networks, our model is faster to train, it can achieve dramatically higher test efficiency (at a small drop in accuracy), and it can also be applied to much longer video clips (over one minute long). Code and models are available at: <a href="https://github.com/facebookresearch/TimeSformer" rel="nofollow">this https URL</a>.</em>',ue,z,He=`This model was contributed by <a href="https://huggingface.co/fcakyon" rel="nofollow">fcakyon</a>.
The original code can be found <a href="https://github.com/facebookresearch/TimeSformer" rel="nofollow">here</a>.`,ge,N,ye,R,Le=`There are many pretrained variants. Select your pretrained model based on the dataset it is trained on. Moreover,
the number of input frames per clip changes based on the model size so you should consider this parameter while selecting your pretrained model.`,je,Q,Te,Y,qe='<li><a href="../tasks/video_classification">Video classification task guide</a></li>',we,H,be,J,L,ve,ne,Ke=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/timesformer#transformers.TimesformerModel">TimesformerModel</a>. It is used to instantiate a
TimeSformer model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the TimeSformer
<a href="https://huggingface.co/facebook/timesformer-base-finetuned-k600" rel="nofollow">facebook/timesformer-base-finetuned-k600</a>
architecture.`,Be,le,Pe=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,We,k,Je,q,Ue,C,K,Ge,oe,De=`The bare TimeSformer Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Ve,_,P,ke,re,Oe='The <a href="/docs/transformers/main/en/model_doc/timesformer#transformers.TimesformerModel">TimesformerModel</a> forward method, overrides the <code>__call__</code> special method.',$e,$,xe,x,_e,D,Ze,I,O,Ae,ie,es=`TimeSformer Model transformer with a video classification head on top (a linear layer on top of the final hidden state
of the [CLS] token) e.g. for ImageNet.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Fe,Z,ee,Xe,me,ss='The <a href="/docs/transformers/main/en/model_doc/timesformer#transformers.TimesformerForVideoClassification">TimesformerForVideoClassification</a> forward method, overrides the <code>__call__</code> special method.',Se,A,Ee,F,Ce,ce,Ie;return d=new te({props:{title:"TimeSformer",local:"timesformer",headingTag:"h1"}}),w=new te({props:{title:"Overview",local:"overview",headingTag:"h2"}}),N=new te({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),Q=new te({props:{title:"Resources",local:"resources",headingTag:"h2"}}),H=new te({props:{title:"TimesformerConfig",local:"transformers.TimesformerConfig",headingTag:"h2"}}),L=new pe({props:{name:"class transformers.TimesformerConfig",anchor:"transformers.TimesformerConfig",parameters:[{name:"image_size",val:" = 224"},{name:"patch_size",val:" = 16"},{name:"num_channels",val:" = 3"},{name:"num_frames",val:" = 8"},{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-06"},{name:"qkv_bias",val:" = True"},{name:"attention_type",val:" = 'divided_space_time'"},{name:"drop_path_rate",val:" = 0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TimesformerConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.TimesformerConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.TimesformerConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.TimesformerConfig.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
The number of frames in each video.`,name:"num_frames"},{anchor:"transformers.TimesformerConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.TimesformerConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.TimesformerConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.TimesformerConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.TimesformerConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.TimesformerConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.TimesformerConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.TimesformerConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.TimesformerConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-06) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.TimesformerConfig.qkv_bias",description:`<strong>qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a bias to the queries, keys and values.`,name:"qkv_bias"},{anchor:"transformers.TimesformerConfig.attention_type",description:`<strong>attention_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;divided_space_time&quot;</code>) &#x2014;
The attention type to use. Must be one of <code>&quot;divided_space_time&quot;</code>, <code>&quot;space_only&quot;</code>, <code>&quot;joint_space_time&quot;</code>.`,name:"attention_type"},{anchor:"transformers.TimesformerConfig.drop_path_rate",description:`<strong>drop_path_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0) &#x2014;
The dropout ratio for stochastic depth.`,name:"drop_path_rate"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/timesformer/configuration_timesformer.py#L27"}}),k=new ze({props:{anchor:"transformers.TimesformerConfig.example",$$slots:{default:[is]},$$scope:{ctx:U}}}),q=new te({props:{title:"TimesformerModel",local:"transformers.TimesformerModel",headingTag:"h2"}}),K=new pe({props:{name:"class transformers.TimesformerModel",anchor:"transformers.TimesformerModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.TimesformerModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/timesformer#transformers.TimesformerConfig">TimesformerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/timesformer/modeling_timesformer.py#L519"}}),P=new pe({props:{name:"forward",anchor:"transformers.TimesformerModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.TimesformerModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_frames, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/main/en/model_doc/videomae#transformers.VideoMAEImageProcessor.preprocess">VideoMAEImageProcessor.preprocess()</a> for details.`,name:"pixel_values"},{anchor:"transformers.TimesformerModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TimesformerModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TimesformerModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/timesformer/modeling_timesformer.py#L547",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/timesformer#transformers.TimesformerConfig"
>TimesformerConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),$=new as({props:{$$slots:{default:[ms]},$$scope:{ctx:U}}}),x=new ze({props:{anchor:"transformers.TimesformerModel.forward.example",$$slots:{default:[cs]},$$scope:{ctx:U}}}),D=new te({props:{title:"TimesformerForVideoClassification",local:"transformers.TimesformerForVideoClassification",headingTag:"h2"}}),O=new pe({props:{name:"class transformers.TimesformerForVideoClassification",anchor:"transformers.TimesformerForVideoClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.TimesformerForVideoClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/timesformer#transformers.TimesformerConfig">TimesformerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/timesformer/modeling_timesformer.py#L660"}}),ee=new pe({props:{name:"forward",anchor:"transformers.TimesformerForVideoClassification.forward",parameters:[{name:"pixel_values",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.TimesformerForVideoClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_frames, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/main/en/model_doc/videomae#transformers.VideoMAEImageProcessor.preprocess">VideoMAEImageProcessor.preprocess()</a> for details.`,name:"pixel_values"},{anchor:"transformers.TimesformerForVideoClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TimesformerForVideoClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TimesformerForVideoClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TimesformerForVideoClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/timesformer/modeling_timesformer.py#L678",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/timesformer#transformers.TimesformerConfig"
>TimesformerConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states
(also called feature maps) of the model at the output of each stage.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),A=new as({props:{$$slots:{default:[ps]},$$scope:{ctx:U}}}),F=new ze({props:{anchor:"transformers.TimesformerForVideoClassification.forward.example",$$slots:{default:[ds]},$$scope:{ctx:U}}}),{c(){a=c("meta"),T=o(),i=c("p"),m=o(),h(d.$$.fragment),t=o(),h(w.$$.fragment),fe=o(),X=c("p"),X.innerHTML=Re,he=o(),S=c("p"),S.textContent=Qe,Me=o(),E=c("p"),E.innerHTML=Ye,ue=o(),z=c("p"),z.innerHTML=He,ge=o(),h(N.$$.fragment),ye=o(),R=c("p"),R.textContent=Le,je=o(),h(Q.$$.fragment),Te=o(),Y=c("ul"),Y.innerHTML=qe,we=o(),h(H.$$.fragment),be=o(),J=c("div"),h(L.$$.fragment),ve=o(),ne=c("p"),ne.innerHTML=Ke,Be=o(),le=c("p"),le.innerHTML=Pe,We=o(),h(k.$$.fragment),Je=o(),h(q.$$.fragment),Ue=o(),C=c("div"),h(K.$$.fragment),Ge=o(),oe=c("p"),oe.innerHTML=De,Ve=o(),_=c("div"),h(P.$$.fragment),ke=o(),re=c("p"),re.innerHTML=Oe,$e=o(),h($.$$.fragment),xe=o(),h(x.$$.fragment),_e=o(),h(D.$$.fragment),Ze=o(),I=c("div"),h(O.$$.fragment),Ae=o(),ie=c("p"),ie.innerHTML=es,Fe=o(),Z=c("div"),h(ee.$$.fragment),Xe=o(),me=c("p"),me.innerHTML=ss,Se=o(),h(A.$$.fragment),Ee=o(),h(F.$$.fragment),Ce=o(),ce=c("p"),this.h()},l(e){const s=rs("svelte-u9bgzb",document.head);a=p(s,"META",{name:!0,content:!0}),s.forEach(n),T=r(e),i=p(e,"P",{}),se(i).forEach(n),m=r(e),M(d.$$.fragment,e),t=r(e),M(w.$$.fragment,e),fe=r(e),X=p(e,"P",{"data-svelte-h":!0}),b(X)!=="svelte-i6ab1x"&&(X.innerHTML=Re),he=r(e),S=p(e,"P",{"data-svelte-h":!0}),b(S)!=="svelte-vfdo9a"&&(S.textContent=Qe),Me=r(e),E=p(e,"P",{"data-svelte-h":!0}),b(E)!=="svelte-j68dli"&&(E.innerHTML=Ye),ue=r(e),z=p(e,"P",{"data-svelte-h":!0}),b(z)!=="svelte-1wsudhb"&&(z.innerHTML=He),ge=r(e),M(N.$$.fragment,e),ye=r(e),R=p(e,"P",{"data-svelte-h":!0}),b(R)!=="svelte-4vsm4f"&&(R.textContent=Le),je=r(e),M(Q.$$.fragment,e),Te=r(e),Y=p(e,"UL",{"data-svelte-h":!0}),b(Y)!=="svelte-gz9vpw"&&(Y.innerHTML=qe),we=r(e),M(H.$$.fragment,e),be=r(e),J=p(e,"DIV",{class:!0});var v=se(J);M(L.$$.fragment,v),ve=r(v),ne=p(v,"P",{"data-svelte-h":!0}),b(ne)!=="svelte-1tut788"&&(ne.innerHTML=Ke),Be=r(v),le=p(v,"P",{"data-svelte-h":!0}),b(le)!=="svelte-o55m63"&&(le.innerHTML=Pe),We=r(v),M(k.$$.fragment,v),v.forEach(n),Je=r(e),M(q.$$.fragment,e),Ue=r(e),C=p(e,"DIV",{class:!0});var G=se(C);M(K.$$.fragment,G),Ge=r(G),oe=p(G,"P",{"data-svelte-h":!0}),b(oe)!=="svelte-gln3qs"&&(oe.innerHTML=De),Ve=r(G),_=p(G,"DIV",{class:!0});var B=se(_);M(P.$$.fragment,B),ke=r(B),re=p(B,"P",{"data-svelte-h":!0}),b(re)!=="svelte-1jb2rp8"&&(re.innerHTML=Oe),$e=r(B),M($.$$.fragment,B),xe=r(B),M(x.$$.fragment,B),B.forEach(n),G.forEach(n),_e=r(e),M(D.$$.fragment,e),Ze=r(e),I=p(e,"DIV",{class:!0});var V=se(I);M(O.$$.fragment,V),Ae=r(V),ie=p(V,"P",{"data-svelte-h":!0}),b(ie)!=="svelte-1ancuo0"&&(ie.innerHTML=es),Fe=r(V),Z=p(V,"DIV",{class:!0});var W=se(Z);M(ee.$$.fragment,W),Xe=r(W),me=p(W,"P",{"data-svelte-h":!0}),b(me)!=="svelte-o1v560"&&(me.innerHTML=ss),Se=r(W),M(A.$$.fragment,W),Ee=r(W),M(F.$$.fragment,W),W.forEach(n),V.forEach(n),Ce=r(e),ce=p(e,"P",{}),se(ce).forEach(n),this.h()},h(){ae(a,"name","hf:doc:metadata"),ae(a,"content",hs),ae(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ae(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ae(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ae(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ae(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){f(document.head,a),l(e,T,s),l(e,i,s),l(e,m,s),u(d,e,s),l(e,t,s),u(w,e,s),l(e,fe,s),l(e,X,s),l(e,he,s),l(e,S,s),l(e,Me,s),l(e,E,s),l(e,ue,s),l(e,z,s),l(e,ge,s),u(N,e,s),l(e,ye,s),l(e,R,s),l(e,je,s),u(Q,e,s),l(e,Te,s),l(e,Y,s),l(e,we,s),u(H,e,s),l(e,be,s),l(e,J,s),u(L,J,null),f(J,ve),f(J,ne),f(J,Be),f(J,le),f(J,We),u(k,J,null),l(e,Je,s),u(q,e,s),l(e,Ue,s),l(e,C,s),u(K,C,null),f(C,Ge),f(C,oe),f(C,Ve),f(C,_),u(P,_,null),f(_,ke),f(_,re),f(_,$e),u($,_,null),f(_,xe),u(x,_,null),l(e,_e,s),u(D,e,s),l(e,Ze,s),l(e,I,s),u(O,I,null),f(I,Ae),f(I,ie),f(I,Fe),f(I,Z),u(ee,Z,null),f(Z,Xe),f(Z,me),f(Z,Se),u(A,Z,null),f(Z,Ee),u(F,Z,null),l(e,Ce,s),l(e,ce,s),Ie=!0},p(e,[s]){const v={};s&2&&(v.$$scope={dirty:s,ctx:e}),k.$set(v);const G={};s&2&&(G.$$scope={dirty:s,ctx:e}),$.$set(G);const B={};s&2&&(B.$$scope={dirty:s,ctx:e}),x.$set(B);const V={};s&2&&(V.$$scope={dirty:s,ctx:e}),A.$set(V);const W={};s&2&&(W.$$scope={dirty:s,ctx:e}),F.$set(W)},i(e){Ie||(g(d.$$.fragment,e),g(w.$$.fragment,e),g(N.$$.fragment,e),g(Q.$$.fragment,e),g(H.$$.fragment,e),g(L.$$.fragment,e),g(k.$$.fragment,e),g(q.$$.fragment,e),g(K.$$.fragment,e),g(P.$$.fragment,e),g($.$$.fragment,e),g(x.$$.fragment,e),g(D.$$.fragment,e),g(O.$$.fragment,e),g(ee.$$.fragment,e),g(A.$$.fragment,e),g(F.$$.fragment,e),Ie=!0)},o(e){y(d.$$.fragment,e),y(w.$$.fragment,e),y(N.$$.fragment,e),y(Q.$$.fragment,e),y(H.$$.fragment,e),y(L.$$.fragment,e),y(k.$$.fragment,e),y(q.$$.fragment,e),y(K.$$.fragment,e),y(P.$$.fragment,e),y($.$$.fragment,e),y(x.$$.fragment,e),y(D.$$.fragment,e),y(O.$$.fragment,e),y(ee.$$.fragment,e),y(A.$$.fragment,e),y(F.$$.fragment,e),Ie=!1},d(e){e&&(n(T),n(i),n(m),n(t),n(fe),n(X),n(he),n(S),n(Me),n(E),n(ue),n(z),n(ge),n(ye),n(R),n(je),n(Te),n(Y),n(we),n(be),n(J),n(Je),n(Ue),n(C),n(_e),n(Ze),n(I),n(Ce),n(ce)),n(a),j(d,e),j(w,e),j(N,e),j(Q,e),j(H,e),j(L),j(k),j(q,e),j(K),j(P),j($),j(x),j(D,e),j(O),j(ee),j(A),j(F)}}}const hs='{"title":"TimeSformer","local":"timesformer","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"TimesformerConfig","local":"transformers.TimesformerConfig","sections":[],"depth":2},{"title":"TimesformerModel","local":"transformers.TimesformerModel","sections":[],"depth":2},{"title":"TimesformerForVideoClassification","local":"transformers.TimesformerForVideoClassification","sections":[],"depth":2}],"depth":1}';function Ms(U){return ns(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Js extends ls{constructor(a){super(),os(this,a,Ms,fs,ts,{})}}export{Js as component};
