import{s as Ne,o as qe,n as Le}from"../chunks/scheduler.182ea377.js";import{S as De,i as Ke,g as a,s,r,A as Oe,h as p,f as t,c as n,j as ze,u,x as o,k as L,y as el,a as i,v as c,d as f,t as d,w as y}from"../chunks/index.abf12888.js";import{T as ll}from"../chunks/Tip.230e2334.js";import{C as J}from"../chunks/CodeBlock.57fe6e13.js";import{H as Ge}from"../chunks/Heading.16916d63.js";function tl(D){let m,Z='Take a look at the <a href="./pipelines/auto_pipeline">AutoPipeline</a> reference to see which tasks are supported. Currently, it supports text-to-image, image-to-image, and inpainting.';return{c(){m=a("p"),m.innerHTML=Z},l(h){m=p(h,"P",{"data-svelte-h":!0}),o(m)!=="svelte-11jlydb"&&(m.innerHTML=Z)},m(h,N){i(h,m,N)},p:Le,d(h){h&&t(m)}}}function il(D){let m,Z,h,N,T,K,U,ke='🤗 Diffusers is able to complete many different tasks, and you can often reuse the same pretrained weights for multiple tasks such as text-to-image, image-to-image, and inpainting. If you’re new to the library and diffusion models though, it may be difficult to know which pipeline to use for a task. For example, if you’re using the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">runwayml/stable-diffusion-v1-5</a> checkpoint for text-to-image, you might not know that you could also use it for image-to-image and inpainting by loading the checkpoint with the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline">StableDiffusionImg2ImgPipeline</a> and <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline">StableDiffusionInpaintPipeline</a> classes respectively.',O,j,Be="The <code>AutoPipeline</code> class is designed to simplify the variety of pipelines in 🤗 Diffusers. It is a generic, <em>task-first</em> pipeline that lets you focus on the task. The <code>AutoPipeline</code> automatically detects the correct pipeline class to use, which makes it easier to load a checkpoint for a task without knowing the specific pipeline class name.",ee,M,le,I,_e="This tutorial shows you how to use an <code>AutoPipeline</code> to automatically infer the pipeline class to load for a specific task, given the pretrained weights.",te,W,ie,G,Xe='Start by picking a checkpoint. For example, if you’re interested in text-to-image with the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">runwayml/stable-diffusion-v1-5</a> checkpoint, use <a href="/docs/diffusers/main/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForText2Image">AutoPipelineForText2Image</a>:',se,k,ne,g,Ve='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/autopipeline-text2img.png" alt="generated image of peasant fighting dragon in wood cutting style"/>',ae,B,ve='Under the hood, <a href="/docs/diffusers/main/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForText2Image">AutoPipelineForText2Image</a>:',pe,_,Fe='<li>automatically detects a <code>&quot;stable-diffusion&quot;</code> class from the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5/blob/main/model_index.json" rel="nofollow"><code>model_index.json</code></a> file</li> <li>loads the corresponding text-to-image <code>StableDiffusionPipline</code> based on the <code>&quot;stable-diffusion&quot;</code> class name</li>',oe,X,Re='Likewise, for image-to-image, <a href="/docs/diffusers/main/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image">AutoPipelineForImage2Image</a> detects a <code>&quot;stable-diffusion&quot;</code> checkpoint from the <code>model_index.json</code> file and it’ll load the corresponding <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline">StableDiffusionImg2ImgPipeline</a> behind the scenes. You can also pass any additional arguments specific to the pipeline class such as <code>strength</code>, which determines the amount of noise or variation added to an input image:',me,V,re,b,$e='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/autopipeline-img2img.png" alt="generated image of a vermeer portrait of a dog wearing a pearl earring"/>',ue,v,xe='And if you want to do inpainting, then <a href="/docs/diffusers/main/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForInpainting">AutoPipelineForInpainting</a> loads the underlying <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline">StableDiffusionInpaintPipeline</a> class in the same way:',ce,F,fe,w,Se='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/autopipeline-inpaint.png" alt="generated image of a tiger sitting on a bench"/>',de,R,Qe="If you try to load an unsupported checkpoint, it’ll throw an error:",ye,$,he,x,Me,S,He='For some workflows or if you’re loading many pipelines, it is more memory-efficient to reuse the same components from a checkpoint instead of reloading them which would unnecessarily consume additional memory. For example, if you’re using a checkpoint for text-to-image and you want to use it again for image-to-image, use the <a href="/docs/diffusers/main/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image.from_pipe">from_pipe()</a> method. This method creates a new pipeline from the components of a previously loaded pipeline at no additional memory cost.',ge,Q,Ye='The <a href="/docs/diffusers/main/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image.from_pipe">from_pipe()</a> method detects the original pipeline class and maps it to the new pipeline class corresponding to the task you want to do. For example, if you load a <code>&quot;stable-diffusion&quot;</code> class pipeline for text-to-image:',be,H,we,Y,Ae='Then <a href="/docs/diffusers/main/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image.from_pipe">from_pipe()</a> maps the original <code>&quot;stable-diffusion&quot;</code> pipeline class to <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline">StableDiffusionImg2ImgPipeline</a>:',Je,A,Ze,P,Pe="If you passed an optional argument - like disabling the safety checker - to the original pipeline, this argument is also passed on to the new pipeline:",Te,E,Ue,C,Ee="You can overwrite any of the arguments and even configuration from the original pipeline if you want to change the behavior of the new pipeline. For example, to turn the safety checker back on and add the <code>strength</code> argument:",je,z,Ie,q,We;return T=new Ge({props:{title:"AutoPipeline",local:"autopipeline",headingTag:"h1"}}),M=new ll({props:{$$slots:{default:[tl]},$$scope:{ctx:D}}}),W=new Ge({props:{title:"Choose an AutoPipeline for your task",local:"choose-an-autopipeline-for-your-task",headingTag:"h2"}}),k=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKS50byglMjJjdWRhJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMnBlYXNhbnQlMjBhbmQlMjBkcmFnb24lMjBjb21iYXQlMkMlMjB3b29kJTIwY3V0dGluZyUyMHN0eWxlJTJDJTIwdmlraW5nJTIwZXJhJTJDJTIwYmV2ZWwlMjB3aXRoJTIwcnVuZSUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI1KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
prompt = <span class="hljs-string">&quot;peasant and dragon combat, wood cutting style, viking era, bevel with rune&quot;</span>

image = pipeline(prompt, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),V=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTJDJTBBKS50byglMjJjdWRhJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBwb3J0cmFpdCUyMG9mJTIwYSUyMGRvZyUyMHdlYXJpbmclMjBhJTIwcGVhcmwlMjBlYXJyaW5nJTIyJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ1cGxvYWQud2lraW1lZGlhLm9yZyUyRndpa2lwZWRpYSUyRmNvbW1vbnMlMkZ0aHVtYiUyRjAlMkYwZiUyRjE2NjVfR2lybF93aXRoX2FfUGVhcmxfRWFycmluZy5qcGclMkY4MDBweC0xNjY1X0dpcmxfd2l0aF9hX1BlYXJsX0VhcnJpbmcuanBnJTIyJTBBJTBBcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFpbWFnZS50aHVtYm5haWwoKDc2OCUyQyUyMDc2OCkpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBpbWFnZSUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyMDAlMkMlMjBzdHJlbmd0aCUzRDAuNzUlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDEwLjUpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
prompt = <span class="hljs-string">&quot;a portrait of a dog wearing a pearl earring&quot;</span>

url = <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/0/0f/1665_Girl_with_a_Pearl_Earring.jpg/800px-1665_Girl_with_a_Pearl_Earring.jpg&quot;</span>

response = requests.get(url)
image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
image.thumbnail((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))

image = pipeline(prompt, image, num_inference_steps=<span class="hljs-number">200</span>, strength=<span class="hljs-number">0.75</span>, guidance_scale=<span class="hljs-number">10.5</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),F=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmclMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZy5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRmxhdGVudC1kaWZmdXNpb24lMkZtYWluJTJGZGF0YSUyRmlucGFpbnRpbmdfZXhhbXBsZXMlMkZvdmVydHVyZS1jcmVhdGlvbnMtNXNJNmZRZ1lJdW8ucG5nJTIyJTBBbWFza191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1b19tYXNrLnBuZyUyMiUwQSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKGltZ191cmwpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQW1hc2tfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKG1hc2tfdXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwbWFqZXN0aWMlMjB0aWdlciUyMHNpdHRpbmclMjBvbiUyMGElMjBiZW5jaCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSUzRG1hc2tfaW1hZ2UlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMjBzdHJlbmd0aCUzRDAuODApLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

init_image = load_image(img_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
mask_image = load_image(mask_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

prompt = <span class="hljs-string">&quot;A majestic tiger sitting on a bench&quot;</span>
image = pipeline(prompt, image=init_image, mask_image=mask_image, num_inference_steps=<span class="hljs-number">50</span>, strength=<span class="hljs-number">0.80</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),$=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJvcGVuYWklMkZzaGFwLWUtaW1nMmltZyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBJTIyVmFsdWVFcnJvciUzQSUyMEF1dG9QaXBlbGluZSUyMGNhbid0JTIwZmluZCUyMGElMjBwaXBlbGluZSUyMGxpbmtlZCUyMHRvJTIwU2hhcEVJbWcySW1nUGlwZWxpbmUlMjBmb3IlMjBOb25lJTIy",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;openai/shap-e-img2img&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
<span class="hljs-string">&quot;ValueError: AutoPipeline can&#x27;t find a pipeline linked to ShapEImg2ImgPipeline for None&quot;</span>`,wrap:!1}}),x=new Ge({props:{title:"Use multiple pipelines",local:"use-multiple-pipelines",headingTag:"h2"}}),H=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMkMlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZSUwQSUwQXBpcGVsaW5lX3RleHQyaW1nJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQXByaW50KHR5cGUocGlwZWxpbmVfdGV4dDJpbWcpKSUwQSUyMiUzQ2NsYXNzJTIwJ2RpZmZ1c2Vycy5waXBlbGluZXMuc3RhYmxlX2RpZmZ1c2lvbi5waXBlbGluZV9zdGFibGVfZGlmZnVzaW9uLlN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJyUzRSUyMg==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, AutoPipelineForImage2Image

pipeline_text2img = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">type</span>(pipeline_text2img))
<span class="hljs-string">&quot;&lt;class &#x27;diffusers.pipelines.stable_diffusion.pipeline_stable_diffusion.StableDiffusionPipeline&#x27;&gt;&quot;</span>`,wrap:!1}}),A=new J({props:{code:"cGlwZWxpbmVfaW1nMmltZyUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcGlwZShwaXBlbGluZV90ZXh0MmltZyklMEFwcmludCh0eXBlKHBpcGVsaW5lX2ltZzJpbWcpKSUwQSUyMiUzQ2NsYXNzJTIwJ2RpZmZ1c2Vycy5waXBlbGluZXMuc3RhYmxlX2RpZmZ1c2lvbi5waXBlbGluZV9zdGFibGVfZGlmZnVzaW9uX2ltZzJpbWcuU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJyUzRSUyMg==",highlighted:`pipeline_img2img = AutoPipelineForImage2Image.from_pipe(pipeline_text2img)
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">type</span>(pipeline_img2img))
<span class="hljs-string">&quot;&lt;class &#x27;diffusers.pipelines.stable_diffusion.pipeline_stable_diffusion_img2img.StableDiffusionImg2ImgPipeline&#x27;&gt;&quot;</span>`,wrap:!1}}),E=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMkMlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZSUwQSUwQXBpcGVsaW5lX3RleHQyaW1nJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcmVxdWlyZXNfc2FmZXR5X2NoZWNrZXIlM0RGYWxzZSUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlbGluZV9pbWcyaW1nJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9waXBlKHBpcGVsaW5lX3RleHQyaW1nKSUwQXByaW50KHBpcGUuY29uZmlnLnJlcXVpcmVzX3NhZmV0eV9jaGVja2VyKSUwQSUyMkZhbHNlJTIy",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, AutoPipelineForImage2Image

pipeline_text2img = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
    requires_safety_checker=<span class="hljs-literal">False</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipeline_img2img = AutoPipelineForImage2Image.from_pipe(pipeline_text2img)
<span class="hljs-built_in">print</span>(pipe.config.requires_safety_checker)
<span class="hljs-string">&quot;False&quot;</span>`,wrap:!1}}),z=new J({props:{code:"cGlwZWxpbmVfaW1nMmltZyUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcGlwZShwaXBlbGluZV90ZXh0MmltZyUyQyUyMHJlcXVpcmVzX3NhZmV0eV9jaGVja2VyJTNEVHJ1ZSUyQyUyMHN0cmVuZ3RoJTNEMC4zKQ==",highlighted:'pipeline_img2img = AutoPipelineForImage2Image.from_pipe(pipeline_text2img, requires_safety_checker=<span class="hljs-literal">True</span>, strength=<span class="hljs-number">0.3</span>)',wrap:!1}}),{c(){m=a("meta"),Z=s(),h=a("p"),N=s(),r(T.$$.fragment),K=s(),U=a("p"),U.innerHTML=ke,O=s(),j=a("p"),j.innerHTML=Be,ee=s(),r(M.$$.fragment),le=s(),I=a("p"),I.innerHTML=_e,te=s(),r(W.$$.fragment),ie=s(),G=a("p"),G.innerHTML=Xe,se=s(),r(k.$$.fragment),ne=s(),g=a("div"),g.innerHTML=Ve,ae=s(),B=a("p"),B.innerHTML=ve,pe=s(),_=a("ol"),_.innerHTML=Fe,oe=s(),X=a("p"),X.innerHTML=Re,me=s(),r(V.$$.fragment),re=s(),b=a("div"),b.innerHTML=$e,ue=s(),v=a("p"),v.innerHTML=xe,ce=s(),r(F.$$.fragment),fe=s(),w=a("div"),w.innerHTML=Se,de=s(),R=a("p"),R.textContent=Qe,ye=s(),r($.$$.fragment),he=s(),r(x.$$.fragment),Me=s(),S=a("p"),S.innerHTML=He,ge=s(),Q=a("p"),Q.innerHTML=Ye,be=s(),r(H.$$.fragment),we=s(),Y=a("p"),Y.innerHTML=Ae,Je=s(),r(A.$$.fragment),Ze=s(),P=a("p"),P.textContent=Pe,Te=s(),r(E.$$.fragment),Ue=s(),C=a("p"),C.innerHTML=Ee,je=s(),r(z.$$.fragment),Ie=s(),q=a("p"),this.h()},l(e){const l=Oe("svelte-u9bgzb",document.head);m=p(l,"META",{name:!0,content:!0}),l.forEach(t),Z=n(e),h=p(e,"P",{}),ze(h).forEach(t),N=n(e),u(T.$$.fragment,e),K=n(e),U=p(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1jx8tcc"&&(U.innerHTML=ke),O=n(e),j=p(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-1unhzn0"&&(j.innerHTML=Be),ee=n(e),u(M.$$.fragment,e),le=n(e),I=p(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-wmnxi6"&&(I.innerHTML=_e),te=n(e),u(W.$$.fragment,e),ie=n(e),G=p(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-uc6093"&&(G.innerHTML=Xe),se=n(e),u(k.$$.fragment,e),ne=n(e),g=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(g)!=="svelte-1yzwly4"&&(g.innerHTML=Ve),ae=n(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1cqgod4"&&(B.innerHTML=ve),pe=n(e),_=p(e,"OL",{"data-svelte-h":!0}),o(_)!=="svelte-py8iz"&&(_.innerHTML=Fe),oe=n(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-179skak"&&(X.innerHTML=Re),me=n(e),u(V.$$.fragment,e),re=n(e),b=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(b)!=="svelte-9fi2fw"&&(b.innerHTML=$e),ue=n(e),v=p(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1f7ebrk"&&(v.innerHTML=xe),ce=n(e),u(F.$$.fragment,e),fe=n(e),w=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-1id5o5z"&&(w.innerHTML=Se),de=n(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-77swfd"&&(R.textContent=Qe),ye=n(e),u($.$$.fragment,e),he=n(e),u(x.$$.fragment,e),Me=n(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1wvq10j"&&(S.innerHTML=He),ge=n(e),Q=p(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-z6wdos"&&(Q.innerHTML=Ye),be=n(e),u(H.$$.fragment,e),we=n(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1g07jwq"&&(Y.innerHTML=Ae),Je=n(e),u(A.$$.fragment,e),Ze=n(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-kxf2pi"&&(P.textContent=Pe),Te=n(e),u(E.$$.fragment,e),Ue=n(e),C=p(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-wave52"&&(C.innerHTML=Ee),je=n(e),u(z.$$.fragment,e),Ie=n(e),q=p(e,"P",{}),ze(q).forEach(t),this.h()},h(){L(m,"name","hf:doc:metadata"),L(m,"content",sl),L(g,"class","flex justify-center"),L(b,"class","flex justify-center"),L(w,"class","flex justify-center")},m(e,l){el(document.head,m),i(e,Z,l),i(e,h,l),i(e,N,l),c(T,e,l),i(e,K,l),i(e,U,l),i(e,O,l),i(e,j,l),i(e,ee,l),c(M,e,l),i(e,le,l),i(e,I,l),i(e,te,l),c(W,e,l),i(e,ie,l),i(e,G,l),i(e,se,l),c(k,e,l),i(e,ne,l),i(e,g,l),i(e,ae,l),i(e,B,l),i(e,pe,l),i(e,_,l),i(e,oe,l),i(e,X,l),i(e,me,l),c(V,e,l),i(e,re,l),i(e,b,l),i(e,ue,l),i(e,v,l),i(e,ce,l),c(F,e,l),i(e,fe,l),i(e,w,l),i(e,de,l),i(e,R,l),i(e,ye,l),c($,e,l),i(e,he,l),c(x,e,l),i(e,Me,l),i(e,S,l),i(e,ge,l),i(e,Q,l),i(e,be,l),c(H,e,l),i(e,we,l),i(e,Y,l),i(e,Je,l),c(A,e,l),i(e,Ze,l),i(e,P,l),i(e,Te,l),c(E,e,l),i(e,Ue,l),i(e,C,l),i(e,je,l),c(z,e,l),i(e,Ie,l),i(e,q,l),We=!0},p(e,[l]){const Ce={};l&2&&(Ce.$$scope={dirty:l,ctx:e}),M.$set(Ce)},i(e){We||(f(T.$$.fragment,e),f(M.$$.fragment,e),f(W.$$.fragment,e),f(k.$$.fragment,e),f(V.$$.fragment,e),f(F.$$.fragment,e),f($.$$.fragment,e),f(x.$$.fragment,e),f(H.$$.fragment,e),f(A.$$.fragment,e),f(E.$$.fragment,e),f(z.$$.fragment,e),We=!0)},o(e){d(T.$$.fragment,e),d(M.$$.fragment,e),d(W.$$.fragment,e),d(k.$$.fragment,e),d(V.$$.fragment,e),d(F.$$.fragment,e),d($.$$.fragment,e),d(x.$$.fragment,e),d(H.$$.fragment,e),d(A.$$.fragment,e),d(E.$$.fragment,e),d(z.$$.fragment,e),We=!1},d(e){e&&(t(Z),t(h),t(N),t(K),t(U),t(O),t(j),t(ee),t(le),t(I),t(te),t(ie),t(G),t(se),t(ne),t(g),t(ae),t(B),t(pe),t(_),t(oe),t(X),t(me),t(re),t(b),t(ue),t(v),t(ce),t(fe),t(w),t(de),t(R),t(ye),t(he),t(Me),t(S),t(ge),t(Q),t(be),t(we),t(Y),t(Je),t(Ze),t(P),t(Te),t(Ue),t(C),t(je),t(Ie),t(q)),t(m),y(T,e),y(M,e),y(W,e),y(k,e),y(V,e),y(F,e),y($,e),y(x,e),y(H,e),y(A,e),y(E,e),y(z,e)}}}const sl='{"title":"AutoPipeline","local":"autopipeline","sections":[{"title":"Choose an AutoPipeline for your task","local":"choose-an-autopipeline-for-your-task","sections":[],"depth":2},{"title":"Use multiple pipelines","local":"use-multiple-pipelines","sections":[],"depth":2}],"depth":1}';function nl(D){return qe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ul extends De{constructor(m){super(),Ke(this,m,nl,il,Ne,{})}}export{ul as component};
