import{s as Ho,o as Yo,n as z}from"../chunks/scheduler.182ea377.js";import{S as qo,i as Ao,g as a,s as i,r as h,A as Xo,h as r,f as d,c as s,j as M,u as _,x as p,k as D,y as n,a as v,v as b,d as y,t as x,w}from"../chunks/index.abf12888.js";import{T as ro}from"../chunks/Tip.230e2334.js";import{D as P}from"../chunks/Docstring.93f6f462.js";import{C as Ae}from"../chunks/CodeBlock.57fe6e13.js";import{E as qe}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as jt}from"../chunks/Heading.16916d63.js";function Qo(S){let o,T='Make sure to check out the Stable Diffusion <a href="overview#tips">Tips</a> section to learn how to explore the tradeoff between scheduler speed and quality, and how to reuse pipeline components efficiently!',c,l,u='If you’re interested in using one of the official checkpoints for a task, explore the <a href="https://huggingface.co/CompVis" rel="nofollow">CompVis</a>, <a href="https://huggingface.co/runwayml" rel="nofollow">Runway</a>, and <a href="https://huggingface.co/stabilityai" rel="nofollow">Stability AI</a> Hub organizations!';return{c(){o=a("p"),o.innerHTML=T,c=i(),l=a("p"),l.innerHTML=u},l(t){o=r(t,"P",{"data-svelte-h":!0}),p(o)!=="svelte-1ue9xpl"&&(o.innerHTML=T),c=s(t),l=r(t,"P",{"data-svelte-h":!0}),p(l)!=="svelte-z4pn9c"&&(l.innerHTML=u)},m(t,$){v(t,o,$),v(t,c,$),v(t,l,$)},p:z,d(t){t&&(d(o),d(c),d(l))}}}function Oo(S){let o,T="Examples:",c,l,u;return l=new Ae({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=a("p"),o.textContent=T,c=i(),h(l.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=T),c=s(t),_(l.$$.fragment,t)},m(t,$){v(t,o,$),v(t,c,$),b(l,t,$),u=!0},p:z,i(t){u||(y(l.$$.fragment,t),u=!0)},o(t){x(l.$$.fragment,t),u=!1},d(t){t&&(d(o),d(c)),w(l,t)}}}function Ko(S){let o,T=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){o=a("p"),o.innerHTML=T},l(c){o=r(c,"P",{"data-svelte-h":!0}),p(o)!=="svelte-ackzsn"&&(o.innerHTML=T)},m(c,l){v(c,o,l)},p:z,d(c){c&&d(o)}}}function ei(S){let o,T="Examples:",c,l,u;return l=new Ae({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=a("p"),o.textContent=T,c=i(),h(l.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=T),c=s(t),_(l.$$.fragment,t)},m(t,$){v(t,o,$),v(t,c,$),b(l,t,$),u=!0},p:z,i(t){u||(y(l.$$.fragment,t),u=!0)},o(t){x(l.$$.fragment,t),u=!1},d(t){t&&(d(o),d(c)),w(l,t)}}}function ti(S){let o,T=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){o=a("p"),o.textContent=T},l(c){o=r(c,"P",{"data-svelte-h":!0}),p(o)!=="svelte-17p1lpg"&&(o.textContent=T)},m(c,l){v(c,o,l)},p:z,d(c){c&&d(o)}}}function ni(S){let o,T="Examples:",c,l,u;return l=new Ae({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){o=a("p"),o.textContent=T,c=i(),h(l.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=T),c=s(t),_(l.$$.fragment,t)},m(t,$){v(t,o,$),v(t,c,$),b(l,t,$),u=!0},p:z,i(t){u||(y(l.$$.fragment,t),u=!0)},o(t){x(l.$$.fragment,t),u=!1},d(t){t&&(d(o),d(c)),w(l,t)}}}function oi(S){let o,T="To load a textual inversion embedding vector in 🤗 Diffusers format:",c,l,u;return l=new Ae({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMCUzQ2NhdC10b3klM0UlMjBiYWNrcGFjayUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdC1iYWNrcGFjay5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)

prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; backpack&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-backpack.png&quot;</span>)`,wrap:!1}}),{c(){o=a("p"),o.textContent=T,c=i(),h(l.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),p(o)!=="svelte-1y13ww6"&&(o.textContent=T),c=s(t),_(l.$$.fragment,t)},m(t,$){v(t,o,$),v(t,c,$),b(l,t,$),u=!0},p:z,i(t){u||(y(l.$$.fragment,t),u=!0)},o(t){x(l.$$.fragment,t),u=!1},d(t){t&&(d(o),d(c)),w(l,t)}}}function ii(S){let o,T="locally:",c,l,u;return l=new Ae({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyLiUyRmNoYXJ0dXJuZXJ2Mi5wdCUyMiUyQyUyMHRva2VuJTNEJTIyY2hhcnR1cm5lcnYyJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNoYXJ0dXJuZXJ2MiUyQyUyMG11bHRpcGxlJTIwdmlld3MlMjBvZiUyMHRoZSUyMHNhbWUlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZSUyMHNhbWUlMjBvdXRmaXQlMkMlMjBhJTIwY2hhcmFjdGVyJTIwdHVybmFyb3VuZCUyMG9mJTIwYSUyMHdvbWFuJTIwd2VhcmluZyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMHJlZCUyMHNoaXJ0JTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBpbnRyaWNhdGUlMjBkZXRhaWxzLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoYXJhY3Rlci5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, token=<span class="hljs-string">&quot;charturnerv2&quot;</span>)

prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround of a woman wearing a black jacket and red shirt, best quality, intricate details.&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;character.png&quot;</span>)`,wrap:!1}}),{c(){o=a("p"),o.textContent=T,c=i(),h(l.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),p(o)!=="svelte-4c75kq"&&(o.textContent=T),c=s(t),_(l.$$.fragment,t)},m(t,$){v(t,o,$),v(t,c,$),b(l,t,$),u=!0},p:z,i(t){u||(y(l.$$.fragment,t),u=!0)},o(t){x(l.$$.fragment,t),u=!1},d(t){t&&(d(o),d(c)),w(l,t)}}}function si(S){let o,T="Examples:",c,l,u;return l=new Ae({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGV2Fycmlvck1hbWE3NzclMkZPcmFuZ2VNaXhzJTJGYmxvYiUyRm1haW4lMkZNb2RlbHMlMkZBYnlzc09yYW5nZU1peCUyRkFieXNzT3JhbmdlTWl4LnNhZmV0ZW5zb3JzJTIyJTBBKSUwQSUwQSUyMyUyMERvd25sb2FkJTIwcGlwZWxpbmUlMjBmcm9tJTIwbG9jYWwlMjBmaWxlJTBBJTIzJTIwZmlsZSUyMGlzJTIwZG93bmxvYWRlZCUyMHVuZGVyJTIwLiUyRnYxLTUtcHJ1bmVkLWVtYW9ubHkuY2twdCUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZSglMjIuJTJGdjEtNS1wcnVuZWQtZW1hb25seSUyMiklMEElMEElMjMlMjBFbmFibGUlMjBmbG9hdDE2JTIwYW5kJTIwbW92ZSUyMHRvJTIwR1BVJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRmJsb2IlMkZtYWluJTJGdjEtNS1wcnVuZWQtZW1hb25seS5ja3B0JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQXBpcGVsaW5lLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/WarriorMama777/OrangeMixs/blob/main/Models/AbyssOrangeMix/AbyssOrangeMix.safetensors&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from local file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># file is downloaded under ./v1-5-pruned-emaonly.ckpt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(<span class="hljs-string">&quot;./v1-5-pruned-emaonly&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Enable float16 and move to GPU</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/runwayml/stable-diffusion-v1-5/blob/main/v1-5-pruned-emaonly.ckpt&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),{c(){o=a("p"),o.textContent=T,c=i(),h(l.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=T),c=s(t),_(l.$$.fragment,t)},m(t,$){v(t,o,$),v(t,c,$),b(l,t,$),u=!0},p:z,i(t){u||(y(l.$$.fragment,t),u=!0)},o(t){x(l.$$.fragment,t),u=!1},d(t){t&&(d(o),d(c)),w(l,t)}}}function ai(S){let o,T="Examples:",c,l,u;return l=new Ae({props:{code:"aW1wb3J0JTIwamF4JTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGZsYXguamF4X3V0aWxzJTIwaW1wb3J0JTIwcmVwbGljYXRlJTBBZnJvbSUyMGZsYXgudHJhaW5pbmcuY29tbW9uX3V0aWxzJTIwaW1wb3J0JTIwc2hhcmQlMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmxheFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMkMlMjBwYXJhbXMlMjAlM0QlMjBGbGF4U3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwcmV2aXNpb24lM0QlMjJiZjE2JTIyJTJDJTIwZHR5cGUlM0RqYXgubnVtcHkuYmZsb2F0MTYlMEEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQSUwQXBybmdfc2VlZCUyMCUzRCUyMGpheC5yYW5kb20uUFJOR0tleSgwKSUwQW51bV9pbmZlcmVuY2Vfc3RlcHMlMjAlM0QlMjA1MCUwQSUwQW51bV9zYW1wbGVzJTIwJTNEJTIwamF4LmRldmljZV9jb3VudCgpJTBBcHJvbXB0JTIwJTNEJTIwbnVtX3NhbXBsZXMlMjAqJTIwJTVCcHJvbXB0JTVEJTBBcHJvbXB0X2lkcyUyMCUzRCUyMHBpcGVsaW5lLnByZXBhcmVfaW5wdXRzKHByb21wdCklMEElMEFwYXJhbXMlMjAlM0QlMjByZXBsaWNhdGUocGFyYW1zKSUwQXBybmdfc2VlZCUyMCUzRCUyMGpheC5yYW5kb20uc3BsaXQocHJuZ19zZWVkJTJDJTIwamF4LmRldmljZV9jb3VudCgpKSUwQXByb21wdF9pZHMlMjAlM0QlMjBzaGFyZChwcm9tcHRfaWRzKSUwQSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKHByb21wdF9pZHMlMkMlMjBwYXJhbXMlMkMlMjBwcm5nX3NlZWQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTJDJTIwaml0JTNEVHJ1ZSkuaW1hZ2VzJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUubnVtcHlfdG9fcGlsKG5wLmFzYXJyYXkoaW1hZ2VzLnJlc2hhcGUoKG51bV9zYW1wbGVzJTJDKSUyMCUyQiUyMGltYWdlcy5zaGFwZSU1Qi0zJTNBJTVEKSkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax.jax_utils <span class="hljs-keyword">import</span> replicate
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax.training.common_utils <span class="hljs-keyword">import</span> shard

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxStableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline, params = FlaxStableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, revision=<span class="hljs-string">&quot;bf16&quot;</span>, dtype=jax.numpy.bfloat16
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>prng_seed = jax.random.PRNGKey(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>num_inference_steps = <span class="hljs-number">50</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>num_samples = jax.device_count()
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = num_samples * [prompt]
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_ids = pipeline.prepare_inputs(prompt)
<span class="hljs-comment"># shard inputs and rng</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>params = replicate(params)
<span class="hljs-meta">&gt;&gt;&gt; </span>prng_seed = jax.random.split(prng_seed, jax.device_count())
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_ids = shard(prompt_ids)

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipeline(prompt_ids, params, prng_seed, num_inference_steps, jit=<span class="hljs-literal">True</span>).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipeline.numpy_to_pil(np.asarray(images.reshape((num_samples,) + images.shape[-<span class="hljs-number">3</span>:])))`,wrap:!1}}),{c(){o=a("p"),o.textContent=T,c=i(),h(l.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=T),c=s(t),_(l.$$.fragment,t)},m(t,$){v(t,o,$),v(t,c,$),b(l,t,$),u=!0},p:z,i(t){u||(y(l.$$.fragment,t),u=!0)},o(t){x(l.$$.fragment,t),u=!1},d(t){t&&(d(o),d(c)),w(l,t)}}}function ri(S){let o,T,c,l,u,t,$,lo='The Stable Diffusion model was created by researchers and engineers from <a href="https://github.com/CompVis" rel="nofollow">CompVis</a>, <a href="https://stability.ai/" rel="nofollow">Stability AI</a>, <a href="https://github.com/runwayml" rel="nofollow">Runway</a>, and <a href="https://laion.ai/" rel="nofollow">LAION</a>. The <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> is capable of generating photorealistic images given any text input. It’s trained on 512x512 images from a subset of the LAION-5B dataset. This model uses a frozen CLIP ViT-L/14 text encoder to condition the model on text prompts. With its 860M UNet and 123M text encoder, the model is relatively lightweight and can run on consumer GPUs. Latent diffusion is the research on top of which Stable Diffusion was built. It was proposed in <a href="https://huggingface.co/papers/2112.10752" rel="nofollow">High-Resolution Image Synthesis with Latent Diffusion Models</a> by Robin Rombach, Andreas Blattmann, Dominik Lorenz, Patrick Esser, Björn Ommer.',Zt,ue,co="The abstract from the paper is:",Lt,ge,fo='<em>By decomposing the image formation process into a sequential application of denoising autoencoders, diffusion models (DMs) achieve state-of-the-art synthesis results on image data and beyond. Additionally, their formulation allows for a guiding mechanism to control the image generation process without retraining. However, since these models typically operate directly in pixel space, optimization of powerful DMs often consumes hundreds of GPU days and inference is expensive due to sequential evaluations. To enable DM training on limited computational resources while retaining their quality and flexibility, we apply them in the latent space of powerful pretrained autoencoders. In contrast to previous work, training diffusion models on such a representation allows for the first time to reach a near-optimal point between complexity reduction and detail preservation, greatly boosting visual fidelity. By introducing cross-attention layers into the model architecture, we turn diffusion models into powerful and flexible generators for general conditioning inputs such as text or bounding boxes and high-resolution synthesis becomes possible in a convolutional manner. Our latent diffusion models (LDMs) achieve a new state of the art for image inpainting and highly competitive performance on various tasks, including unconditional image generation, semantic scene synthesis, and super-resolution, while significantly reducing computational requirements compared to pixel-based DMs. Code is available at <a href="https://github.com/CompVis/latent-diffusion" rel="nofollow">https://github.com/CompVis/latent-diffusion</a>.</em>',Wt,H,Gt,he,Ft,m,_e,Kt,Xe,po="Pipeline for text-to-image generation using Stable Diffusion.",en,Qe,mo=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,tn,Oe,uo="The pipeline also inherits the following loading methods:",nn,Ke,go='<li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.StableDiffusionDepth2ImgPipeline.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.StableDiffusionDepth2ImgPipeline.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li>',on,N,be,sn,et,ho="The call function to the pipeline for generation.",an,Y,rn,I,ye,ln,tt,_o=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,dn,q,cn,A,fn,X,xe,pn,nt,bo=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,mn,Q,we,un,ot,yo=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,gn,O,ve,hn,it,xo=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,_n,U,$e,bn,st,wo=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,yn,K,xn,ee,wn,te,Te,vn,at,vo='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',$n,ne,Me,Tn,rt,$o=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Mn,oe,De,Dn,lt,To=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Sn,J,Se,Pn,dt,Mo=`Load textual inversion embeddings into the text encoder of <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> (both 🤗 Diffusers and
Automatic1111 formats are supported).`,Jn,ct,Do="Example:",kn,ie,Cn,ft,So=`To load a textual inversion embedding vector in Automatic1111 format, make sure to download the vector first
(for example from <a href="https://civitai.com/models/3036?modelVersionId=9857" rel="nofollow">civitAI</a>) and then load the vector`,In,se,Un,B,Pe,jn,pt,Po=`Instantiate a <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> from pretrained pipeline weights saved in the <code>.ckpt</code> or <code>.safetensors</code>
format. The pipeline is set in evaluation mode (<code>model.eval()</code>) by default.`,Zn,ae,Ln,k,Je,Wn,mt,Jo=`Load LoRA weights specified in <code>pretrained_model_name_or_path_or_dict</code> into <code>self.unet</code> and
<code>self.text_encoder</code>.`,Gn,ut,ko="All kwargs are forwarded to <code>self.lora_state_dict</code>.",Fn,gt,Co='See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a> for more details on how the state dict is loaded.',Nn,ht,Io=`See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.load_lora_into_unet">load_lora_into_unet()</a> for more details on how the state dict is loaded into
<code>self.unet</code>.`,Bn,_t,Uo=`See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder">load_lora_into_text_encoder()</a> for more details on how the state dict is loaded
into <code>self.text_encoder</code>.`,Vn,re,ke,zn,bt,jo="Save the LoRA parameters corresponding to the UNet and text encoder.",En,le,Ce,Rn,yt,Zo="Disables the FreeU mechanism if enabled.",Hn,j,Ie,Yn,xt,Lo='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',qn,wt,Wo="The suffixes after the scaling factors represent the stages where they are being applied.",An,vt,Go=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,Xn,de,Ue,Qn,$t,Fo="Encodes the prompt into text encoder hidden states.",Nt,je,Bt,E,Ze,On,Tt,No="Output class for Stable Diffusion pipelines.",Vt,Le,zt,C,We,Kn,Mt,Bo="Flax-based pipeline for text-to-image generation using Stable Diffusion.",eo,Dt,Vo=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline">FlaxDiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,to,V,Ge,no,St,zo="The call function to the pipeline for generation.",oo,ce,Et,Fe,Rt,W,Ne,io,Pt,Eo="Output class for Flax-based Stable Diffusion pipelines.",so,fe,Be,ao,Jt,Ro="“Returns a new object replacing the specified fields with new values.",Ht,Ut,Yt;return u=new jt({props:{title:"Text-to-image",local:"text-to-image",headingTag:"h1"}}),H=new ro({props:{$$slots:{default:[Qo]},$$scope:{ctx:S}}}),he=new jt({props:{title:"StableDiffusionPipeline",local:"diffusers.StableDiffusionPipeline",headingTag:"h2"}}),_e=new P({props:{name:"class diffusers.StableDiffusionPipeline",anchor:"diffusers.StableDiffusionPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L73"}}),be=new P({props:{name:"__call__",anchor:"diffusers.StableDiffusionPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableDiffusionPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance rescale factor from <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a>. Guidance rescale factor should fix overexposure when
using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"diffusers.StableDiffusionPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L573",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),Y=new qe({props:{anchor:"diffusers.StableDiffusionPipeline.__call__.example",$$slots:{default:[Oo]},$$scope:{ctx:S}}}),ye=new P({props:{name:"enable_attention_slicing",anchor:"diffusers.StableDiffusionPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": typing.Union[str, int, NoneType] = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1925"}}),q=new ro({props:{warning:!0,$$slots:{default:[Ko]},$$scope:{ctx:S}}}),A=new qe({props:{anchor:"diffusers.StableDiffusionPipeline.enable_attention_slicing.example",$$slots:{default:[ei]},$$scope:{ctx:S}}}),xe=new P({props:{name:"disable_attention_slicing",anchor:"diffusers.StableDiffusionPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1965"}}),we=new P({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L199"}}),ve=new P({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L206"}}),$e=new P({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": typing.Optional[typing.Callable] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1864"}}),K=new ro({props:{warning:!0,$$slots:{default:[ti]},$$scope:{ctx:S}}}),ee=new qe({props:{anchor:"diffusers.StableDiffusionPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[ni]},$$scope:{ctx:S}}}),Te=new P({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1899"}}),Me=new P({props:{name:"enable_vae_tiling",anchor:"diffusers.StableDiffusionPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L213"}}),De=new P({props:{name:"disable_vae_tiling",anchor:"diffusers.StableDiffusionPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L221"}}),Se=new P({props:{name:"load_textual_inversion",anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, typing.List[str], typing.Dict[str, torch.Tensor], typing.List[typing.Dict[str, torch.Tensor]]]"},{name:"token",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[ForwardRef('PreTrainedTokenizer')] = None"},{name:"text_encoder",val:": typing.Optional[ForwardRef('PreTrainedModel')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code> or <code>List[str or os.PathLike]</code> or <code>Dict</code> or <code>List[Dict]</code>) &#x2014;
Can be either one of the following or a list of them:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>sd-concepts-library/low-poly-hd-logos-icons</code>) of a
pretrained model hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_text_inversion_directory/</code>) containing the textual
inversion weights.</li>
<li>A path to a <em>file</em> (for example <code>./my_text_inversions.pt</code>) containing textual inversion weights.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Override the token to use for the textual inversion weights. If <code>pretrained_model_name_or_path</code> is a
list, then <code>token</code> must also be a list of equal length.`,name:"token"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).
If not specified, function will take self.tokenizer.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text. If not specified, function will take self.tokenizer.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.weight_name",description:`<strong>weight_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of a custom weight file. This should be used when:</p>
<ul>
<li>The saved textual inversion file is in &#x1F917; Diffusers format, but was saved under a specific weight
name such as <code>text_inv.bin</code>.</li>
<li>The saved textual inversion file is in the Automatic1111 format.</li>
</ul>`,name:"weight_name"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L984"}}),ie=new qe({props:{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.example",$$slots:{default:[oi]},$$scope:{ctx:S}}}),se=new qe({props:{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.example-2",$$slots:{default:[ii]},$$scope:{ctx:S}}}),Pe=new P({props:{name:"from_single_file",anchor:"diffusers.StableDiffusionPipeline.from_single_file",parameters:[{name:"pretrained_model_link_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.from_single_file.pretrained_model_link_or_path",description:`<strong>pretrained_model_link_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:<ul>
<li>A link to the <code>.ckpt</code> file (for example
<code>&quot;https://huggingface.co/&lt;repo_id&gt;/blob/main/&lt;path_to_file&gt;.ckpt&quot;</code>) on the Hub.</li>
<li>A path to a <em>file</em> containing all pipeline weights.</li>
</ul>`,name:"pretrained_model_link_or_path"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype. If <code>&quot;auto&quot;</code> is passed, the
dtype is automatically derived from the model&#x2019;s weights.`,name:"torch_dtype"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.extract_ema",description:`<strong>extract_ema</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to extract the EMA weights or not. Pass <code>True</code> to extract the EMA weights which usually yield
higher quality images for inference. Non-EMA weights are usually better for continuing finetuning.`,name:"extract_ema"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.upcast_attention",description:`<strong>upcast_attention</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether the attention computation should always be upcasted.`,name:"upcast_attention"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The image size the model was trained on. Use 512 for all Stable Diffusion v1 models and the Stable
Diffusion v2 base model. Use 768 for Stable Diffusion v2.`,name:"image_size"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.prediction_type",description:`<strong>prediction_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The prediction type the model was trained on. Use <code>&apos;epsilon&apos;</code> for all Stable Diffusion v1 models and
the Stable Diffusion v2 base model. Use <code>&apos;v_prediction&apos;</code> for Stable Diffusion v2.`,name:"prediction_type"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.num_in_channels",description:`<strong>num_in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The number of input channels. If <code>None</code>, it is automatically inferred.`,name:"num_in_channels"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.scheduler_type",description:`<strong>scheduler_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pndm&quot;</code>) &#x2014;
Type of scheduler to use. Should be one of <code>[&quot;pndm&quot;, &quot;lms&quot;, &quot;heun&quot;, &quot;euler&quot;, &quot;euler-ancestral&quot;, &quot;dpm&quot;, &quot;ddim&quot;]</code>.`,name:"scheduler_type"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.load_safety_checker",description:`<strong>load_safety_checker</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to load the safety checker or not.`,name:"load_safety_checker"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
An instance of <code>CLIPTextModel</code> to use, specifically the
<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant. If this
parameter is <code>None</code>, the function loads a new instance of <code>CLIPTextModel</code> by itself if needed.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.vae",description:`<strong>vae</strong> (<code>AutoencoderKL</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations. If
this parameter is <code>None</code>, the function will load a new instance of [CLIP] by itself, if needed.`,name:"vae"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
An instance of <code>CLIPTokenizer</code> to use. If this parameter is <code>None</code>, the function loads a new instance
of <code>CLIPTokenizer</code> by itself if needed.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.original_config_file",description:`<strong>original_config_file</strong> (<code>str</code>) &#x2014;
Path to <code>.yaml</code> config file corresponding to the original architecture. If <code>None</code>, will be
automatically inferred by looking for a key that only exists in SD2.0 models.`,name:"original_config_file"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (for example the pipeline components of the
specific pipeline class). The overwritten components are directly passed to the pipelines <code>__init__</code>
method. See example below for more information.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L2610"}}),ae=new qe({props:{anchor:"diffusers.StableDiffusionPipeline.from_single_file.example",$$slots:{default:[si]},$$scope:{ctx:S}}}),Je=new P({props:{name:"load_lora_weights",anchor:"diffusers.StableDiffusionPipeline.load_lora_weights",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": typing.Union[str, typing.Dict[str, torch.Tensor]]"},{name:"adapter_name",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.load_lora_weights.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.StableDiffusionPipeline.load_lora_weights.kwargs",description:`<strong>kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"kwargs"},{anchor:"diffusers.StableDiffusionPipeline.load_lora_weights.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L1173"}}),ke=new P({props:{name:"save_lora_weights",anchor:"diffusers.StableDiffusionPipeline.save_lora_weights",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"unet_lora_layers",val:": typing.Dict[str, typing.Union[torch.nn.modules.module.Module, torch.Tensor]] = None"},{name:"text_encoder_lora_layers",val:": typing.Dict[str, torch.nn.modules.module.Module] = None"},{name:"is_main_process",val:": bool = True"},{name:"weight_name",val:": str = None"},{name:"save_function",val:": typing.Callable = None"},{name:"safe_serialization",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save LoRA parameters to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.unet_lora_layers",description:`<strong>unet_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>unet</code>.`,name:"unet_lora_layers"},{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.text_encoder_lora_layers",description:`<strong>text_encoder_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>text_encoder</code>. Must explicitly pass the text
encoder LoRA state dict because it comes from &#x1F917; Transformers.`,name:"text_encoder_lora_layers"},{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.save_function",description:`<strong>save_function</strong> (<code>Callable</code>) &#x2014;
The function to use to save the state dictionary. Useful during distributed training when you need to
replace <code>torch.save</code> with another method. Can be configured with the environment variable
<code>DIFFUSERS_SAVE_MODE</code>.`,name:"save_function"},{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L1964"}}),Ce=new P({props:{name:"disable_freeu",anchor:"diffusers.StableDiffusionPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L569"}}),Ie=new P({props:{name:"enable_freeu",anchor:"diffusers.StableDiffusionPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L547"}}),Ue=new P({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L260"}}),je=new jt({props:{title:"StableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",headingTag:"h2"}}),Ze=new P({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"},{name:"nsfw_content_detected",val:": typing.Optional[typing.List[bool]]"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L11"}}),Le=new jt({props:{title:"FlaxStableDiffusionPipeline",local:"diffusers.FlaxStableDiffusionPipeline",headingTag:"h2"}}),We=new P({props:{name:"class diffusers.FlaxStableDiffusionPipeline",anchor:"diffusers.FlaxStableDiffusionPipeline",parameters:[{name:"vae",val:": FlaxAutoencoderKL"},{name:"text_encoder",val:": FlaxCLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": FlaxUNet2DConditionModel"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim_flax.FlaxDDIMScheduler, diffusers.schedulers.scheduling_pndm_flax.FlaxPNDMScheduler, diffusers.schedulers.scheduling_lms_discrete_flax.FlaxLMSDiscreteScheduler, diffusers.schedulers.scheduling_dpmsolver_multistep_flax.FlaxDPMSolverMultistepScheduler]"},{name:"safety_checker",val:": FlaxStableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"}],parametersDescription:[{anchor:"diffusers.FlaxStableDiffusionPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.FlaxAutoencoderKL">FlaxAutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.FlaxStableDiffusionPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.FlaxCLIPTextModel" rel="nofollow">FlaxCLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.FlaxStableDiffusionPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.FlaxStableDiffusionPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.FlaxUNet2DConditionModel">FlaxUNet2DConditionModel</a>) &#x2014;
A <code>FlaxUNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.FlaxStableDiffusionPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<code>FlaxDDIMScheduler</code>, <code>FlaxLMSDiscreteScheduler</code>, <code>FlaxPNDMScheduler</code>, or
<code>FlaxDPMSolverMultistepScheduler</code>.`,name:"scheduler"},{anchor:"diffusers.FlaxStableDiffusionPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>FlaxStableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.FlaxStableDiffusionPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_flax_stable_diffusion.py#L81"}}),Ge=new P({props:{name:"__call__",anchor:"diffusers.FlaxStableDiffusionPipeline.__call__",parameters:[{name:"prompt_ids",val:": array"},{name:"params",val:": typing.Union[typing.Dict, flax.core.frozen_dict.FrozenDict]"},{name:"prng_seed",val:": Array"},{name:"num_inference_steps",val:": int = 50"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"guidance_scale",val:": typing.Union[float, jax.Array] = 7.5"},{name:"latents",val:": Array = None"},{name:"neg_prompt_ids",val:": Array = None"},{name:"return_dict",val:": bool = True"},{name:"jit",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation.`,name:"prompt"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.latents",description:`<strong>latents</strong> (<code>jnp.ndarray</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
array is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.jit",description:`<strong>jit</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to run <code>pmap</code> versions of the generation and safety scoring functions.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>This argument exists because <code>__call__</code> is not yet end-to-end pmap-able. It will be removed in a
future release.</p>

					</div>`,name:"jit"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput">FlaxStableDiffusionPipelineOutput</a> instead of
a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_flax_stable_diffusion.py#L310",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"
>FlaxStableDiffusionPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated images
and the second element is a list of <code>bool</code>s indicating whether the corresponding generated image
contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"
>FlaxStableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),ce=new qe({props:{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.example",$$slots:{default:[ai]},$$scope:{ctx:S}}}),Fe=new jt({props:{title:"FlaxStableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",headingTag:"h2"}}),Ne=new P({props:{name:"class diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",parameters:[{name:"images",val:": ndarray"},{name:"nsfw_content_detected",val:": typing.List[bool]"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>np.ndarray</code>) &#x2014;
Denoised images of array shape of <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content
or <code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L32"}}),Be=new P({props:{name:"replace",anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/flax/struct.py#L111"}}),{c(){o=a("meta"),T=i(),c=a("p"),l=i(),h(u.$$.fragment),t=i(),$=a("p"),$.innerHTML=lo,Zt=i(),ue=a("p"),ue.textContent=co,Lt=i(),ge=a("p"),ge.innerHTML=fo,Wt=i(),h(H.$$.fragment),Gt=i(),h(he.$$.fragment),Ft=i(),m=a("div"),h(_e.$$.fragment),Kt=i(),Xe=a("p"),Xe.textContent=po,en=i(),Qe=a("p"),Qe.innerHTML=mo,tn=i(),Oe=a("p"),Oe.textContent=uo,nn=i(),Ke=a("ul"),Ke.innerHTML=go,on=i(),N=a("div"),h(be.$$.fragment),sn=i(),et=a("p"),et.textContent=ho,an=i(),h(Y.$$.fragment),rn=i(),I=a("div"),h(ye.$$.fragment),ln=i(),tt=a("p"),tt.textContent=_o,dn=i(),h(q.$$.fragment),cn=i(),h(A.$$.fragment),fn=i(),X=a("div"),h(xe.$$.fragment),pn=i(),nt=a("p"),nt.innerHTML=bo,mn=i(),Q=a("div"),h(we.$$.fragment),un=i(),ot=a("p"),ot.textContent=yo,gn=i(),O=a("div"),h(ve.$$.fragment),hn=i(),it=a("p"),it.innerHTML=xo,_n=i(),U=a("div"),h($e.$$.fragment),bn=i(),st=a("p"),st.innerHTML=wo,yn=i(),h(K.$$.fragment),xn=i(),h(ee.$$.fragment),wn=i(),te=a("div"),h(Te.$$.fragment),vn=i(),at=a("p"),at.innerHTML=vo,$n=i(),ne=a("div"),h(Me.$$.fragment),Tn=i(),rt=a("p"),rt.textContent=$o,Mn=i(),oe=a("div"),h(De.$$.fragment),Dn=i(),lt=a("p"),lt.innerHTML=To,Sn=i(),J=a("div"),h(Se.$$.fragment),Pn=i(),dt=a("p"),dt.innerHTML=Mo,Jn=i(),ct=a("p"),ct.textContent=Do,kn=i(),h(ie.$$.fragment),Cn=i(),ft=a("p"),ft.innerHTML=So,In=i(),h(se.$$.fragment),Un=i(),B=a("div"),h(Pe.$$.fragment),jn=i(),pt=a("p"),pt.innerHTML=Po,Zn=i(),h(ae.$$.fragment),Ln=i(),k=a("div"),h(Je.$$.fragment),Wn=i(),mt=a("p"),mt.innerHTML=Jo,Gn=i(),ut=a("p"),ut.innerHTML=ko,Fn=i(),gt=a("p"),gt.innerHTML=Co,Nn=i(),ht=a("p"),ht.innerHTML=Io,Bn=i(),_t=a("p"),_t.innerHTML=Uo,Vn=i(),re=a("div"),h(ke.$$.fragment),zn=i(),bt=a("p"),bt.textContent=jo,En=i(),le=a("div"),h(Ce.$$.fragment),Rn=i(),yt=a("p"),yt.textContent=Zo,Hn=i(),j=a("div"),h(Ie.$$.fragment),Yn=i(),xt=a("p"),xt.innerHTML=Lo,qn=i(),wt=a("p"),wt.textContent=Wo,An=i(),vt=a("p"),vt.innerHTML=Go,Xn=i(),de=a("div"),h(Ue.$$.fragment),Qn=i(),$t=a("p"),$t.textContent=Fo,Nt=i(),h(je.$$.fragment),Bt=i(),E=a("div"),h(Ze.$$.fragment),On=i(),Tt=a("p"),Tt.textContent=No,Vt=i(),h(Le.$$.fragment),zt=i(),C=a("div"),h(We.$$.fragment),Kn=i(),Mt=a("p"),Mt.textContent=Bo,eo=i(),Dt=a("p"),Dt.innerHTML=Vo,to=i(),V=a("div"),h(Ge.$$.fragment),no=i(),St=a("p"),St.textContent=zo,oo=i(),h(ce.$$.fragment),Et=i(),h(Fe.$$.fragment),Rt=i(),W=a("div"),h(Ne.$$.fragment),io=i(),Pt=a("p"),Pt.textContent=Eo,so=i(),fe=a("div"),h(Be.$$.fragment),ao=i(),Jt=a("p"),Jt.textContent=Ro,Ht=i(),Ut=a("p"),this.h()},l(e){const f=Xo("svelte-u9bgzb",document.head);o=r(f,"META",{name:!0,content:!0}),f.forEach(d),T=s(e),c=r(e,"P",{}),M(c).forEach(d),l=s(e),_(u.$$.fragment,e),t=s(e),$=r(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1p4bu1q"&&($.innerHTML=lo),Zt=s(e),ue=r(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1cwsb16"&&(ue.textContent=co),Lt=s(e),ge=r(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-1xoozhu"&&(ge.innerHTML=fo),Wt=s(e),_(H.$$.fragment,e),Gt=s(e),_(he.$$.fragment,e),Ft=s(e),m=r(e,"DIV",{class:!0});var g=M(m);_(_e.$$.fragment,g),Kt=s(g),Xe=r(g,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-35p306"&&(Xe.textContent=po),en=s(g),Qe=r(g,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-496sm0"&&(Qe.innerHTML=mo),tn=s(g),Oe=r(g,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-14s6m4u"&&(Oe.textContent=uo),nn=s(g),Ke=r(g,"UL",{"data-svelte-h":!0}),p(Ke)!=="svelte-gld6ny"&&(Ke.innerHTML=go),on=s(g),N=r(g,"DIV",{class:!0});var R=M(N);_(be.$$.fragment,R),sn=s(R),et=r(R,"P",{"data-svelte-h":!0}),p(et)!=="svelte-50j04k"&&(et.textContent=ho),an=s(R),_(Y.$$.fragment,R),R.forEach(d),rn=s(g),I=r(g,"DIV",{class:!0});var G=M(I);_(ye.$$.fragment,G),ln=s(G),tt=r(G,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-10jaql7"&&(tt.textContent=_o),dn=s(G),_(q.$$.fragment,G),cn=s(G),_(A.$$.fragment,G),G.forEach(d),fn=s(g),X=r(g,"DIV",{class:!0});var Ve=M(X);_(xe.$$.fragment,Ve),pn=s(Ve),nt=r(Ve,"P",{"data-svelte-h":!0}),p(nt)!=="svelte-1lh0nh5"&&(nt.innerHTML=bo),Ve.forEach(d),mn=s(g),Q=r(g,"DIV",{class:!0});var ze=M(Q);_(we.$$.fragment,ze),un=s(ze),ot=r(ze,"P",{"data-svelte-h":!0}),p(ot)!=="svelte-14bnrb6"&&(ot.textContent=yo),ze.forEach(d),gn=s(g),O=r(g,"DIV",{class:!0});var Ee=M(O);_(ve.$$.fragment,Ee),hn=s(Ee),it=r(Ee,"P",{"data-svelte-h":!0}),p(it)!=="svelte-1s3c06i"&&(it.innerHTML=xo),Ee.forEach(d),_n=s(g),U=r(g,"DIV",{class:!0});var F=M(U);_($e.$$.fragment,F),bn=s(F),st=r(F,"P",{"data-svelte-h":!0}),p(st)!=="svelte-e03q3e"&&(st.innerHTML=wo),yn=s(F),_(K.$$.fragment,F),xn=s(F),_(ee.$$.fragment,F),F.forEach(d),wn=s(g),te=r(g,"DIV",{class:!0});var Re=M(te);_(Te.$$.fragment,Re),vn=s(Re),at=r(Re,"P",{"data-svelte-h":!0}),p(at)!=="svelte-1vfte1e"&&(at.innerHTML=vo),Re.forEach(d),$n=s(g),ne=r(g,"DIV",{class:!0});var He=M(ne);_(Me.$$.fragment,He),Tn=s(He),rt=r(He,"P",{"data-svelte-h":!0}),p(rt)!=="svelte-1xwrf7t"&&(rt.textContent=$o),He.forEach(d),Mn=s(g),oe=r(g,"DIV",{class:!0});var Ye=M(oe);_(De.$$.fragment,Ye),Dn=s(Ye),lt=r(Ye,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-pkn4ui"&&(lt.innerHTML=To),Ye.forEach(d),Sn=s(g),J=r(g,"DIV",{class:!0});var Z=M(J);_(Se.$$.fragment,Z),Pn=s(Z),dt=r(Z,"P",{"data-svelte-h":!0}),p(dt)!=="svelte-617c7s"&&(dt.innerHTML=Mo),Jn=s(Z),ct=r(Z,"P",{"data-svelte-h":!0}),p(ct)!=="svelte-11lpom8"&&(ct.textContent=Do),kn=s(Z),_(ie.$$.fragment,Z),Cn=s(Z),ft=r(Z,"P",{"data-svelte-h":!0}),p(ft)!=="svelte-2gddoh"&&(ft.innerHTML=So),In=s(Z),_(se.$$.fragment,Z),Z.forEach(d),Un=s(g),B=r(g,"DIV",{class:!0});var kt=M(B);_(Pe.$$.fragment,kt),jn=s(kt),pt=r(kt,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-pmqrln"&&(pt.innerHTML=Po),Zn=s(kt),_(ae.$$.fragment,kt),kt.forEach(d),Ln=s(g),k=r(g,"DIV",{class:!0});var L=M(k);_(Je.$$.fragment,L),Wn=s(L),mt=r(L,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-vs7s0z"&&(mt.innerHTML=Jo),Gn=s(L),ut=r(L,"P",{"data-svelte-h":!0}),p(ut)!=="svelte-15b960v"&&(ut.innerHTML=ko),Fn=s(L),gt=r(L,"P",{"data-svelte-h":!0}),p(gt)!=="svelte-qj05o3"&&(gt.innerHTML=Co),Nn=s(L),ht=r(L,"P",{"data-svelte-h":!0}),p(ht)!=="svelte-ot29jq"&&(ht.innerHTML=Io),Bn=s(L),_t=r(L,"P",{"data-svelte-h":!0}),p(_t)!=="svelte-1ah097o"&&(_t.innerHTML=Uo),L.forEach(d),Vn=s(g),re=r(g,"DIV",{class:!0});var qt=M(re);_(ke.$$.fragment,qt),zn=s(qt),bt=r(qt,"P",{"data-svelte-h":!0}),p(bt)!=="svelte-1ufq5ot"&&(bt.textContent=jo),qt.forEach(d),En=s(g),le=r(g,"DIV",{class:!0});var At=M(le);_(Ce.$$.fragment,At),Rn=s(At),yt=r(At,"P",{"data-svelte-h":!0}),p(yt)!=="svelte-psupw6"&&(yt.textContent=Zo),At.forEach(d),Hn=s(g),j=r(g,"DIV",{class:!0});var pe=M(j);_(Ie.$$.fragment,pe),Yn=s(pe),xt=r(pe,"P",{"data-svelte-h":!0}),p(xt)!=="svelte-1f3tmq1"&&(xt.innerHTML=Lo),qn=s(pe),wt=r(pe,"P",{"data-svelte-h":!0}),p(wt)!=="svelte-xjijlp"&&(wt.textContent=Wo),An=s(pe),vt=r(pe,"P",{"data-svelte-h":!0}),p(vt)!=="svelte-hy0nzs"&&(vt.innerHTML=Go),pe.forEach(d),Xn=s(g),de=r(g,"DIV",{class:!0});var Xt=M(de);_(Ue.$$.fragment,Xt),Qn=s(Xt),$t=r(Xt,"P",{"data-svelte-h":!0}),p($t)!=="svelte-16q0ax1"&&($t.textContent=Fo),Xt.forEach(d),g.forEach(d),Nt=s(e),_(je.$$.fragment,e),Bt=s(e),E=r(e,"DIV",{class:!0});var Qt=M(E);_(Ze.$$.fragment,Qt),On=s(Qt),Tt=r(Qt,"P",{"data-svelte-h":!0}),p(Tt)!=="svelte-1qpjiuf"&&(Tt.textContent=No),Qt.forEach(d),Vt=s(e),_(Le.$$.fragment,e),zt=s(e),C=r(e,"DIV",{class:!0});var me=M(C);_(We.$$.fragment,me),Kn=s(me),Mt=r(me,"P",{"data-svelte-h":!0}),p(Mt)!=="svelte-d05p75"&&(Mt.textContent=Bo),eo=s(me),Dt=r(me,"P",{"data-svelte-h":!0}),p(Dt)!=="svelte-knddhk"&&(Dt.innerHTML=Vo),to=s(me),V=r(me,"DIV",{class:!0});var Ct=M(V);_(Ge.$$.fragment,Ct),no=s(Ct),St=r(Ct,"P",{"data-svelte-h":!0}),p(St)!=="svelte-50j04k"&&(St.textContent=zo),oo=s(Ct),_(ce.$$.fragment,Ct),Ct.forEach(d),me.forEach(d),Et=s(e),_(Fe.$$.fragment,e),Rt=s(e),W=r(e,"DIV",{class:!0});var It=M(W);_(Ne.$$.fragment,It),io=s(It),Pt=r(It,"P",{"data-svelte-h":!0}),p(Pt)!=="svelte-wzv2jc"&&(Pt.textContent=Eo),so=s(It),fe=r(It,"DIV",{class:!0});var Ot=M(fe);_(Be.$$.fragment,Ot),ao=s(Ot),Jt=r(Ot,"P",{"data-svelte-h":!0}),p(Jt)!=="svelte-5ihtpa"&&(Jt.textContent=Ro),Ot.forEach(d),It.forEach(d),Ht=s(e),Ut=r(e,"P",{}),M(Ut).forEach(d),this.h()},h(){D(o,"name","hf:doc:metadata"),D(o,"content",li),D(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,f){n(document.head,o),v(e,T,f),v(e,c,f),v(e,l,f),b(u,e,f),v(e,t,f),v(e,$,f),v(e,Zt,f),v(e,ue,f),v(e,Lt,f),v(e,ge,f),v(e,Wt,f),b(H,e,f),v(e,Gt,f),b(he,e,f),v(e,Ft,f),v(e,m,f),b(_e,m,null),n(m,Kt),n(m,Xe),n(m,en),n(m,Qe),n(m,tn),n(m,Oe),n(m,nn),n(m,Ke),n(m,on),n(m,N),b(be,N,null),n(N,sn),n(N,et),n(N,an),b(Y,N,null),n(m,rn),n(m,I),b(ye,I,null),n(I,ln),n(I,tt),n(I,dn),b(q,I,null),n(I,cn),b(A,I,null),n(m,fn),n(m,X),b(xe,X,null),n(X,pn),n(X,nt),n(m,mn),n(m,Q),b(we,Q,null),n(Q,un),n(Q,ot),n(m,gn),n(m,O),b(ve,O,null),n(O,hn),n(O,it),n(m,_n),n(m,U),b($e,U,null),n(U,bn),n(U,st),n(U,yn),b(K,U,null),n(U,xn),b(ee,U,null),n(m,wn),n(m,te),b(Te,te,null),n(te,vn),n(te,at),n(m,$n),n(m,ne),b(Me,ne,null),n(ne,Tn),n(ne,rt),n(m,Mn),n(m,oe),b(De,oe,null),n(oe,Dn),n(oe,lt),n(m,Sn),n(m,J),b(Se,J,null),n(J,Pn),n(J,dt),n(J,Jn),n(J,ct),n(J,kn),b(ie,J,null),n(J,Cn),n(J,ft),n(J,In),b(se,J,null),n(m,Un),n(m,B),b(Pe,B,null),n(B,jn),n(B,pt),n(B,Zn),b(ae,B,null),n(m,Ln),n(m,k),b(Je,k,null),n(k,Wn),n(k,mt),n(k,Gn),n(k,ut),n(k,Fn),n(k,gt),n(k,Nn),n(k,ht),n(k,Bn),n(k,_t),n(m,Vn),n(m,re),b(ke,re,null),n(re,zn),n(re,bt),n(m,En),n(m,le),b(Ce,le,null),n(le,Rn),n(le,yt),n(m,Hn),n(m,j),b(Ie,j,null),n(j,Yn),n(j,xt),n(j,qn),n(j,wt),n(j,An),n(j,vt),n(m,Xn),n(m,de),b(Ue,de,null),n(de,Qn),n(de,$t),v(e,Nt,f),b(je,e,f),v(e,Bt,f),v(e,E,f),b(Ze,E,null),n(E,On),n(E,Tt),v(e,Vt,f),b(Le,e,f),v(e,zt,f),v(e,C,f),b(We,C,null),n(C,Kn),n(C,Mt),n(C,eo),n(C,Dt),n(C,to),n(C,V),b(Ge,V,null),n(V,no),n(V,St),n(V,oo),b(ce,V,null),v(e,Et,f),b(Fe,e,f),v(e,Rt,f),v(e,W,f),b(Ne,W,null),n(W,io),n(W,Pt),n(W,so),n(W,fe),b(Be,fe,null),n(fe,ao),n(fe,Jt),v(e,Ht,f),v(e,Ut,f),Yt=!0},p(e,[f]){const g={};f&2&&(g.$$scope={dirty:f,ctx:e}),H.$set(g);const R={};f&2&&(R.$$scope={dirty:f,ctx:e}),Y.$set(R);const G={};f&2&&(G.$$scope={dirty:f,ctx:e}),q.$set(G);const Ve={};f&2&&(Ve.$$scope={dirty:f,ctx:e}),A.$set(Ve);const ze={};f&2&&(ze.$$scope={dirty:f,ctx:e}),K.$set(ze);const Ee={};f&2&&(Ee.$$scope={dirty:f,ctx:e}),ee.$set(Ee);const F={};f&2&&(F.$$scope={dirty:f,ctx:e}),ie.$set(F);const Re={};f&2&&(Re.$$scope={dirty:f,ctx:e}),se.$set(Re);const He={};f&2&&(He.$$scope={dirty:f,ctx:e}),ae.$set(He);const Ye={};f&2&&(Ye.$$scope={dirty:f,ctx:e}),ce.$set(Ye)},i(e){Yt||(y(u.$$.fragment,e),y(H.$$.fragment,e),y(he.$$.fragment,e),y(_e.$$.fragment,e),y(be.$$.fragment,e),y(Y.$$.fragment,e),y(ye.$$.fragment,e),y(q.$$.fragment,e),y(A.$$.fragment,e),y(xe.$$.fragment,e),y(we.$$.fragment,e),y(ve.$$.fragment,e),y($e.$$.fragment,e),y(K.$$.fragment,e),y(ee.$$.fragment,e),y(Te.$$.fragment,e),y(Me.$$.fragment,e),y(De.$$.fragment,e),y(Se.$$.fragment,e),y(ie.$$.fragment,e),y(se.$$.fragment,e),y(Pe.$$.fragment,e),y(ae.$$.fragment,e),y(Je.$$.fragment,e),y(ke.$$.fragment,e),y(Ce.$$.fragment,e),y(Ie.$$.fragment,e),y(Ue.$$.fragment,e),y(je.$$.fragment,e),y(Ze.$$.fragment,e),y(Le.$$.fragment,e),y(We.$$.fragment,e),y(Ge.$$.fragment,e),y(ce.$$.fragment,e),y(Fe.$$.fragment,e),y(Ne.$$.fragment,e),y(Be.$$.fragment,e),Yt=!0)},o(e){x(u.$$.fragment,e),x(H.$$.fragment,e),x(he.$$.fragment,e),x(_e.$$.fragment,e),x(be.$$.fragment,e),x(Y.$$.fragment,e),x(ye.$$.fragment,e),x(q.$$.fragment,e),x(A.$$.fragment,e),x(xe.$$.fragment,e),x(we.$$.fragment,e),x(ve.$$.fragment,e),x($e.$$.fragment,e),x(K.$$.fragment,e),x(ee.$$.fragment,e),x(Te.$$.fragment,e),x(Me.$$.fragment,e),x(De.$$.fragment,e),x(Se.$$.fragment,e),x(ie.$$.fragment,e),x(se.$$.fragment,e),x(Pe.$$.fragment,e),x(ae.$$.fragment,e),x(Je.$$.fragment,e),x(ke.$$.fragment,e),x(Ce.$$.fragment,e),x(Ie.$$.fragment,e),x(Ue.$$.fragment,e),x(je.$$.fragment,e),x(Ze.$$.fragment,e),x(Le.$$.fragment,e),x(We.$$.fragment,e),x(Ge.$$.fragment,e),x(ce.$$.fragment,e),x(Fe.$$.fragment,e),x(Ne.$$.fragment,e),x(Be.$$.fragment,e),Yt=!1},d(e){e&&(d(T),d(c),d(l),d(t),d($),d(Zt),d(ue),d(Lt),d(ge),d(Wt),d(Gt),d(Ft),d(m),d(Nt),d(Bt),d(E),d(Vt),d(zt),d(C),d(Et),d(Rt),d(W),d(Ht),d(Ut)),d(o),w(u,e),w(H,e),w(he,e),w(_e),w(be),w(Y),w(ye),w(q),w(A),w(xe),w(we),w(ve),w($e),w(K),w(ee),w(Te),w(Me),w(De),w(Se),w(ie),w(se),w(Pe),w(ae),w(Je),w(ke),w(Ce),w(Ie),w(Ue),w(je,e),w(Ze),w(Le,e),w(We),w(Ge),w(ce),w(Fe,e),w(Ne),w(Be)}}}const li='{"title":"Text-to-image","local":"text-to-image","sections":[{"title":"StableDiffusionPipeline","local":"diffusers.StableDiffusionPipeline","sections":[],"depth":2},{"title":"StableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput","sections":[],"depth":2},{"title":"FlaxStableDiffusionPipeline","local":"diffusers.FlaxStableDiffusionPipeline","sections":[],"depth":2},{"title":"FlaxStableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput","sections":[],"depth":2}],"depth":1}';function di(S){return Yo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _i extends qo{constructor(o){super(),Ao(this,o,di,ri,Ho,{})}}export{_i as component};
