import{s as qe,o as Pe,n as Ye}from"../chunks/scheduler.182ea377.js";import{S as Ae,i as Ke,g as i,s as n,r as m,A as Oe,h as p,f as s,c as a,j as Le,u as f,x as o,k as De,y as et,a as l,v as u,d as c,t as M,w as d}from"../chunks/index.abf12888.js";import{T as tt}from"../chunks/Tip.230e2334.js";import{C as q}from"../chunks/CodeBlock.57fe6e13.js";import{D as st}from"../chunks/DocNotebookDropdown.d9060979.js";import{H as $e}from"../chunks/Heading.16916d63.js";function lt(Y){let r,y="Disable the FreeU mechanism by calling <code>disable_freeu()</code> on a pipeline.";return{c(){r=i("p"),r.innerHTML=y},l(h){r=p(h,"P",{"data-svelte-h":!0}),o(r)!=="svelte-vhfeba"&&(r.innerHTML=y)},m(h,D){l(h,r,D)},p:Ye,d(h){h&&s(r)}}}function nt(Y){let r,y,h,D,g,A,J,K,w,ke="The UNet is responsible for denoising during the reverse diffusion process, and there are two distinct features in its architecture:",O,j,We="<li>Backbone features primarily contribute to the denoising process</li> <li>Skip features mainly introduce high-frequency features into the decoder module and can make the network overlook the semantics in the backbone features</li>",ee,T,Ge='However, the skip connection can sometimes introduce unnatural image details. <a href="https://hf.co/papers/2309.11497" rel="nofollow">FreeU</a> is a technique for improving image quality by rebalancing the contributions from the UNet’s skip connections and backbone feature maps.',te,U,_e="FreeU is applied during inference and it does not require any additional training. The technique works for different tasks such as text-to-image, image-to-image, and text-to-video.",se,Z,Ce='In this guide, you will apply FreeU to the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>, <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a>, and <a href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.TextToVideoSDPipeline">TextToVideoSDPipeline</a>.',le,v,ne,$,Be="Load the pipeline:",ae,k,ie,W,xe="Then enable the FreeU mechanism with the FreeU-specific hyperparameters. These values are scaling factors for the backbone and skip features.",pe,G,oe,_,Ve='The values above are from the official FreeU <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">code repository</a> where you can also find <a href="https://github.com/ChenyangSi/FreeU#range-for-more-parameters" rel="nofollow">reference hyperparameters</a> for different models.',re,b,me,C,Se="And then run inference:",fe,B,ue,x,Ee="The figure below compares non-FreeU and FreeU results respectively for the same hyperparameters used above (<code>prompt</code> and <code>seed</code>):",ce,V,Ie='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/freeu/sdv1_5_freeu.jpg"/>',Me,S,He="Let’s see how Stable Diffusion 2 results are impacted:",de,E,he,I,Ne='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/freeu/sdv2_1_freeu.jpg"/>',be,H,ye,N,Re="Finally, let’s take a look at how FreeU affects Stable Diffusion XL results:",ge,R,Je,z,ze='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/freeu/sdxl_freeu.jpg"/>',we,X,je,Q,Xe="FreeU can also be used to improve video quality:",Te,F,Ue,L,Qe='Thanks to <a href="https://github.com/kadirnar/" rel="nofollow">kadirnar</a> for helping to integrate the feature, and to <a href="https://github.com/justindujardin" rel="nofollow">justindujardin</a> for the helpful discussions.',Ze,P,ve;return g=new $e({props:{title:"Improve generation quality with FreeU",local:"improve-generation-quality-with-freeu",headingTag:"h1"}}),J=new st({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/freeu.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/freeu.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/freeu.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/freeu.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/freeu.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/freeu.ipynb"}]}}),v=new $e({props:{title:"StableDiffusionPipeline",local:"stablediffusionpipeline",headingTag:"h2"}}),k=new q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMjAlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHNhZmV0eV9jaGVja2VyJTNETm9uZSUwQSkudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch 

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, safety_checker=<span class="hljs-literal">None</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),G=new q({props:{code:"cGlwZWxpbmUuZW5hYmxlX2ZyZWV1KHMxJTNEMC45JTJDJTIwczIlM0QwLjIlMkMlMjBiMSUzRDEuMiUyQyUyMGIyJTNEMS40KQ==",highlighted:'pipeline.enable_freeu(s1=<span class="hljs-number">0.9</span>, s2=<span class="hljs-number">0.2</span>, b1=<span class="hljs-number">1.2</span>, b2=<span class="hljs-number">1.4</span>)',wrap:!1}}),b=new tt({props:{$$slots:{default:[lt]},$$scope:{ctx:Y}}}),B=new q({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyQSUyMHNxdWlycmVsJTIwZWF0aW5nJTIwYSUyMGJ1cmdlciUyMiUwQXNlZWQlMjAlM0QlMjAyMDIzJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0R0b3JjaC5tYW51YWxfc2VlZChzZWVkKSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`prompt = <span class="hljs-string">&quot;A squirrel eating a burger&quot;</span>
seed = <span class="hljs-number">2023</span>
image = pipeline(prompt, generator=torch.manual_seed(seed)).images[<span class="hljs-number">0</span>]`,wrap:!1}}),E=new q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMjAlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMi0xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwc2FmZXR5X2NoZWNrZXIlM0ROb25lJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBzcXVpcnJlbCUyMGVhdGluZyUyMGElMjBidXJnZXIlMjIlMEFzZWVkJTIwJTNEJTIwMjAyMyUwQSUwQXBpcGVsaW5lLmVuYWJsZV9mcmVldShzMSUzRDAuOSUyQyUyMHMyJTNEMC4yJTJDJTIwYjElM0QxLjElMkMlMjBiMiUzRDEuMiklMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMGdlbmVyYXRvciUzRHRvcmNoLm1hbnVhbF9zZWVkKHNlZWQpKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch 

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16, safety_checker=<span class="hljs-literal">None</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A squirrel eating a burger&quot;</span>
seed = <span class="hljs-number">2023</span>

pipeline.enable_freeu(s1=<span class="hljs-number">0.9</span>, s2=<span class="hljs-number">0.2</span>, b1=<span class="hljs-number">1.1</span>, b2=<span class="hljs-number">1.2</span>)
image = pipeline(prompt, generator=torch.manual_seed(seed)).images[<span class="hljs-number">0</span>]`,wrap:!1}}),H=new $e({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h2"}}),R=new q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMjAlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMHNxdWlycmVsJTIwZWF0aW5nJTIwYSUyMGJ1cmdlciUyMiUwQXNlZWQlMjAlM0QlMjAyMDIzJTBBJTBBJTIzJTIwQ29tZXMlMjBmcm9tJTIwJTBBJTIzJTIwaHR0cHMlM0ElMkYlMkZ3YW5kYi5haSUyRm5hc2lyazI0JTJGVU5FVC1GcmVlVS1TRFhMJTJGcmVwb3J0cyUyRkZyZWVVLVNEWEwtT3B0aW1hbC1QYXJhbWV0ZXJzLS1WbWxsZHpvMU5EZzROVFV3JTBBcGlwZWxpbmUuZW5hYmxlX2ZyZWV1KHMxJTNEMC42JTJDJTIwczIlM0QwLjQlMkMlMjBiMSUzRDEuMSUyQyUyMGIyJTNEMS4yKSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwZ2VuZXJhdG9yJTNEdG9yY2gubWFudWFsX3NlZWQoc2VlZCkpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch 

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A squirrel eating a burger&quot;</span>
seed = <span class="hljs-number">2023</span>

<span class="hljs-comment"># Comes from </span>
<span class="hljs-comment"># https://wandb.ai/nasirk24/UNET-FreeU-SDXL/reports/FreeU-SDXL-Optimal-Parameters--Vmlldzo1NDg4NTUw</span>
pipeline.enable_freeu(s1=<span class="hljs-number">0.6</span>, s2=<span class="hljs-number">0.4</span>, b1=<span class="hljs-number">1.1</span>, b2=<span class="hljs-number">1.2</span>)
image = pipeline(prompt, generator=torch.manual_seed(seed)).images[<span class="hljs-number">0</span>]`,wrap:!1}}),X=new $e({props:{title:"Text-to-video generation",local:"text-to-video-generation",headingTag:"h2"}}),F=new q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b192aWRlbyUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJjZXJzcGVuc2UlMkZ6ZXJvc2NvcGVfdjJfNTc2dyUyMiUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyY2Vyc3BlbnNlJTJGemVyb3Njb3BlX3YyXzU3NnclMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQXNlZWQlMjAlM0QlMjAyMDIzJTBBJTBBJTIzJTIwVGhlJTIwdmFsdWVzJTIwY29tZSUyMGZyb20lMEElMjMlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZseW4tcmdiJTJGRnJlZVVfRGlmZnVzZXJzJTIzdmlkZW8tcGlwZWxpbmVzJTBBcGlwZS5lbmFibGVfZnJlZXUoYjElM0QxLjIlMkMlMjBiMiUzRDEuNCUyQyUyMHMxJTNEMC45JTJDJTIwczIlM0QwLjIpJTBBdmlkZW9fZnJhbWVzJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBoZWlnaHQlM0QzMjAlMkMlMjB3aWR0aCUzRDU3NiUyQyUyMG51bV9mcmFtZXMlM0QzMCUyQyUyMGdlbmVyYXRvciUzRHRvcmNoLm1hbnVhbF9zZWVkKHNlZWQpKS5mcmFtZXMlMEFleHBvcnRfdG9fdmlkZW8odmlkZW9fZnJhbWVzJTJDJTIwJTIyYXN0cm9uYXV0X3JpZGVzX2hvcnNlLm1wNCUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;cerspense/zeroscope_v2_576w&quot;</span>
pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;cerspense/zeroscope_v2_576w&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;an astronaut riding a horse on mars&quot;</span>
seed = <span class="hljs-number">2023</span>

<span class="hljs-comment"># The values come from</span>
<span class="hljs-comment"># https://github.com/lyn-rgb/FreeU_Diffusers#video-pipelines</span>
pipe.enable_freeu(b1=<span class="hljs-number">1.2</span>, b2=<span class="hljs-number">1.4</span>, s1=<span class="hljs-number">0.9</span>, s2=<span class="hljs-number">0.2</span>)
video_frames = pipe(prompt, height=<span class="hljs-number">320</span>, width=<span class="hljs-number">576</span>, num_frames=<span class="hljs-number">30</span>, generator=torch.manual_seed(seed)).frames
export_to_video(video_frames, <span class="hljs-string">&quot;astronaut_rides_horse.mp4&quot;</span>)`,wrap:!1}}),{c(){r=i("meta"),y=n(),h=i("p"),D=n(),m(g.$$.fragment),A=n(),m(J.$$.fragment),K=n(),w=i("p"),w.textContent=ke,O=n(),j=i("ol"),j.innerHTML=We,ee=n(),T=i("p"),T.innerHTML=Ge,te=n(),U=i("p"),U.textContent=_e,se=n(),Z=i("p"),Z.innerHTML=Ce,le=n(),m(v.$$.fragment),ne=n(),$=i("p"),$.textContent=Be,ae=n(),m(k.$$.fragment),ie=n(),W=i("p"),W.textContent=xe,pe=n(),m(G.$$.fragment),oe=n(),_=i("p"),_.innerHTML=Ve,re=n(),m(b.$$.fragment),me=n(),C=i("p"),C.textContent=Se,fe=n(),m(B.$$.fragment),ue=n(),x=i("p"),x.innerHTML=Ee,ce=n(),V=i("p"),V.innerHTML=Ie,Me=n(),S=i("p"),S.textContent=He,de=n(),m(E.$$.fragment),he=n(),I=i("p"),I.innerHTML=Ne,be=n(),m(H.$$.fragment),ye=n(),N=i("p"),N.textContent=Re,ge=n(),m(R.$$.fragment),Je=n(),z=i("p"),z.innerHTML=ze,we=n(),m(X.$$.fragment),je=n(),Q=i("p"),Q.textContent=Xe,Te=n(),m(F.$$.fragment),Ue=n(),L=i("p"),L.innerHTML=Qe,Ze=n(),P=i("p"),this.h()},l(e){const t=Oe("svelte-u9bgzb",document.head);r=p(t,"META",{name:!0,content:!0}),t.forEach(s),y=a(e),h=p(e,"P",{}),Le(h).forEach(s),D=a(e),f(g.$$.fragment,e),A=a(e),f(J.$$.fragment,e),K=a(e),w=p(e,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1h0uz5e"&&(w.textContent=ke),O=a(e),j=p(e,"OL",{"data-svelte-h":!0}),o(j)!=="svelte-8wamr8"&&(j.innerHTML=We),ee=a(e),T=p(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-bc3x6q"&&(T.innerHTML=Ge),te=a(e),U=p(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1l2549u"&&(U.textContent=_e),se=a(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-gfmz2i"&&(Z.innerHTML=Ce),le=a(e),f(v.$$.fragment,e),ne=a(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1br27f9"&&($.textContent=Be),ae=a(e),f(k.$$.fragment,e),ie=a(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1kfovwo"&&(W.textContent=xe),pe=a(e),f(G.$$.fragment,e),oe=a(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-gb72tw"&&(_.innerHTML=Ve),re=a(e),f(b.$$.fragment,e),me=a(e),C=p(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-yyi4rw"&&(C.textContent=Se),fe=a(e),f(B.$$.fragment,e),ue=a(e),x=p(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-u90fev"&&(x.innerHTML=Ee),ce=a(e),V=p(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-gexrkr"&&(V.innerHTML=Ie),Me=a(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-61gii3"&&(S.textContent=He),de=a(e),f(E.$$.fragment,e),he=a(e),I=p(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-evvlf0"&&(I.innerHTML=Ne),be=a(e),f(H.$$.fragment,e),ye=a(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-2ehsm1"&&(N.textContent=Re),ge=a(e),f(R.$$.fragment,e),Je=a(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1vig68s"&&(z.innerHTML=ze),we=a(e),f(X.$$.fragment,e),je=a(e),Q=p(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-pga2sp"&&(Q.textContent=Xe),Te=a(e),f(F.$$.fragment,e),Ue=a(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1cx6l39"&&(L.innerHTML=Qe),Ze=a(e),P=p(e,"P",{}),Le(P).forEach(s),this.h()},h(){De(r,"name","hf:doc:metadata"),De(r,"content",at)},m(e,t){et(document.head,r),l(e,y,t),l(e,h,t),l(e,D,t),u(g,e,t),l(e,A,t),u(J,e,t),l(e,K,t),l(e,w,t),l(e,O,t),l(e,j,t),l(e,ee,t),l(e,T,t),l(e,te,t),l(e,U,t),l(e,se,t),l(e,Z,t),l(e,le,t),u(v,e,t),l(e,ne,t),l(e,$,t),l(e,ae,t),u(k,e,t),l(e,ie,t),l(e,W,t),l(e,pe,t),u(G,e,t),l(e,oe,t),l(e,_,t),l(e,re,t),u(b,e,t),l(e,me,t),l(e,C,t),l(e,fe,t),u(B,e,t),l(e,ue,t),l(e,x,t),l(e,ce,t),l(e,V,t),l(e,Me,t),l(e,S,t),l(e,de,t),u(E,e,t),l(e,he,t),l(e,I,t),l(e,be,t),u(H,e,t),l(e,ye,t),l(e,N,t),l(e,ge,t),u(R,e,t),l(e,Je,t),l(e,z,t),l(e,we,t),u(X,e,t),l(e,je,t),l(e,Q,t),l(e,Te,t),u(F,e,t),l(e,Ue,t),l(e,L,t),l(e,Ze,t),l(e,P,t),ve=!0},p(e,[t]){const Fe={};t&2&&(Fe.$$scope={dirty:t,ctx:e}),b.$set(Fe)},i(e){ve||(c(g.$$.fragment,e),c(J.$$.fragment,e),c(v.$$.fragment,e),c(k.$$.fragment,e),c(G.$$.fragment,e),c(b.$$.fragment,e),c(B.$$.fragment,e),c(E.$$.fragment,e),c(H.$$.fragment,e),c(R.$$.fragment,e),c(X.$$.fragment,e),c(F.$$.fragment,e),ve=!0)},o(e){M(g.$$.fragment,e),M(J.$$.fragment,e),M(v.$$.fragment,e),M(k.$$.fragment,e),M(G.$$.fragment,e),M(b.$$.fragment,e),M(B.$$.fragment,e),M(E.$$.fragment,e),M(H.$$.fragment,e),M(R.$$.fragment,e),M(X.$$.fragment,e),M(F.$$.fragment,e),ve=!1},d(e){e&&(s(y),s(h),s(D),s(A),s(K),s(w),s(O),s(j),s(ee),s(T),s(te),s(U),s(se),s(Z),s(le),s(ne),s($),s(ae),s(ie),s(W),s(pe),s(oe),s(_),s(re),s(me),s(C),s(fe),s(ue),s(x),s(ce),s(V),s(Me),s(S),s(de),s(he),s(I),s(be),s(ye),s(N),s(ge),s(Je),s(z),s(we),s(je),s(Q),s(Te),s(Ue),s(L),s(Ze),s(P)),s(r),d(g,e),d(J,e),d(v,e),d(k,e),d(G,e),d(b,e),d(B,e),d(E,e),d(H,e),d(R,e),d(X,e),d(F,e)}}}const at='{"title":"Improve generation quality with FreeU","local":"improve-generation-quality-with-freeu","sections":[{"title":"StableDiffusionPipeline","local":"stablediffusionpipeline","sections":[],"depth":2},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[],"depth":2},{"title":"Text-to-video generation","local":"text-to-video-generation","sections":[],"depth":2}],"depth":1}';function it(Y){return Pe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ct extends Ae{constructor(r){super(),Ke(this,r,it,nt,qe,{})}}export{ct as component};
