import{s as ys,o as bs,n as ws}from"../chunks/scheduler.182ea377.js";import{S as Zs,i as js,g as i,s as n,r as c,A as gs,h as r,f as s,c as a,j as fs,u,x as p,k as C,y as Us,a as t,v as d,d as m,t as M,w as h}from"../chunks/index.abf12888.js";import{T as Js}from"../chunks/Tip.230e2334.js";import{C as f}from"../chunks/CodeBlock.57fe6e13.js";import{D as Ts}from"../chunks/DocNotebookDropdown.d9060979.js";import{H as ve}from"../chunks/Heading.16916d63.js";function $s(Ce){let o,V="The following Flax schedulers are <em>not yet compatible</em> with the Flax Stable Diffusion Pipeline:",Z,b,j="<li><code>FlaxLMSDiscreteScheduler</code></li> <li><code>FlaxDDPMScheduler</code></li>";return{c(){o=i("p"),o.innerHTML=V,Z=n(),b=i("ul"),b.innerHTML=j},l(y){o=r(y,"P",{"data-svelte-h":!0}),p(o)!=="svelte-18uc691"&&(o.innerHTML=V),Z=a(y),b=r(y,"UL",{"data-svelte-h":!0}),p(b)!=="svelte-pfgls0"&&(b.innerHTML=j)},m(y,w){t(y,o,w),t(y,Z,w),t(y,b,w)},p:ws,d(y){y&&(s(o),s(Z),s(b))}}}function vs(Ce){let o,V,Z,b,j,y,w,Ve,k,Bl=`Diffusion pipelines are inherently a collection of diffusion models and schedulers that are partly independent from each other. This means that one is able to switch out parts of the pipeline to better customize
a pipeline to one’s use case. The best example of this is the <a href="../api/schedulers/overview.md">Schedulers</a>.`,ke,W,Xl=`Whereas diffusion models usually simply define the forward pass from noise to a less noisy sample,
schedulers define the whole denoising process, <em>i.e.</em>:`,We,_,Sl="<li>How many denoising steps?</li> <li>Stochastic or deterministic?</li> <li>What algorithm to use to find the denoised sample</li>",_e,x,Il=`They can be quite complex and often define a trade-off between <strong>denoising speed</strong> and <strong>denoising quality</strong>.
It is extremely difficult to measure quantitatively which scheduler works best for a given diffusion pipeline, so it is often recommended to simply try out which works best.`,xe,B,Nl="The following paragraphs show how to do so with the 🧨 Diffusers library.",Be,X,Xe,S,El='Let’s start by loading the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a> model in the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>:',Se,I,Ie,N,Hl="Next, we move it to GPU:",Ne,E,Ee,H,He,R,Rl=`The scheduler is always one of the components of the pipeline and is usually called <code>&quot;scheduler&quot;</code>.
So it can be accessed via the <code>&quot;scheduler&quot;</code> property.`,Re,F,Fe,A,Fl="<strong>Output</strong>:",Ae,z,ze,L,Al=`We can see that the scheduler is of type <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.
Cool, now let’s compare the scheduler in its performance to other schedulers.
First we define a prompt on which we will test all the different schedulers:`,Le,D,De,Y,zl="Next, we create a generator from a random seed that will ensure that we can generate similar images as well as run the pipeline:",Ye,Q,Qe,g,Ll='<br/> <img src="https://huggingface.co/datasets/patrickvonplaten/images/resolve/main/diffusers_docs/astronaut_pndm.png" width="400"/> <br/>',qe,q,Pe,P,Dl=`Now we show how easy it is to change the scheduler of a pipeline. Every scheduler has a property <code>SchedulerMixin.compatibles</code>
which defines all compatible schedulers. You can take a look at all available, compatible schedulers for the Stable Diffusion pipeline as follows.`,Ke,K,Oe,O,Yl="<strong>Output</strong>:",el,ee,ll,le,Ql="Cool, lots of schedulers to look at. Feel free to have a look at their respective class definitions:",sl,se,ql='<li><a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>,</li> <li><a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>,</li> <li><a href="/docs/diffusers/main/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a>,</li> <li><a href="/docs/diffusers/main/en/api/schedulers/euler#diffusers.EulerDiscreteScheduler">EulerDiscreteScheduler</a>,</li> <li><a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>,</li> <li><a href="/docs/diffusers/main/en/api/schedulers/ddpm#diffusers.DDPMScheduler">DDPMScheduler</a>,</li> <li><a href="/docs/diffusers/main/en/api/schedulers/euler_ancestral#diffusers.EulerAncestralDiscreteScheduler">EulerAncestralDiscreteScheduler</a>.</li>',tl,te,Pl=`We will now compare the input prompt with all other schedulers. To change the scheduler of the pipeline you can make use of the
convenient <code>ConfigMixin.config</code> property in combination with the <a href="/docs/diffusers/main/en/api/configuration#diffusers.ConfigMixin.from_config">ConfigMixin.from_config()</a> function.`,nl,ne,al,ae,Kl="returns a dictionary of the configuration of the scheduler:",il,ie,Ol="<strong>Output</strong>:",rl,re,pl,pe,es=`This configuration can then be used to instantiate a scheduler
of a different class that is compatible with the pipeline. Here,
we change the scheduler to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>.`,cl,ce,ul,ue,ls="Cool, now we can run the pipeline again to compare the generation quality.",dl,de,ml,U,ss='<br/> <img src="https://huggingface.co/datasets/patrickvonplaten/images/resolve/main/diffusers_docs/astronaut_ddim.png" width="400"/> <br/>',Ml,me,ts='If you are a JAX/Flax user, please check <a href="#changing-the-scheduler-in-flax">this section</a> instead.',hl,Me,ol,he,ns=`So far we have tried running the stable diffusion pipeline with two schedulers: <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a> and <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>.
A number of better schedulers have been released that can be run with much fewer steps, let’s compare them here:`,fl,oe,as='<a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a> usually leads to better results:',yl,fe,bl,J,is='<br/> <img src="https://huggingface.co/datasets/patrickvonplaten/images/resolve/main/diffusers_docs/astronaut_lms.png" width="400"/> <br/>',wl,ye,rs='<a href="/docs/diffusers/main/en/api/schedulers/euler#diffusers.EulerDiscreteScheduler">EulerDiscreteScheduler</a> and <a href="/docs/diffusers/main/en/api/schedulers/euler_ancestral#diffusers.EulerAncestralDiscreteScheduler">EulerAncestralDiscreteScheduler</a> can generate high quality results with as little as 30 steps.',Zl,be,jl,T,ps='<br/> <img src="https://huggingface.co/datasets/patrickvonplaten/images/resolve/main/diffusers_docs/astronaut_euler_discrete.png" width="400"/> <br/>',gl,we,cs="and:",Ul,Ze,Jl,$,us='<br/> <img src="https://huggingface.co/datasets/patrickvonplaten/images/resolve/main/diffusers_docs/astronaut_euler_ancestral.png" width="400"/> <br/>',Tl,je,ds=`At the time of writing this doc <a href="/docs/diffusers/main/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a> gives arguably the best speed/quality trade-off and can be run with as little
as 20 steps.`,$l,ge,vl,v,ms='<br/> <img src="https://huggingface.co/datasets/patrickvonplaten/images/resolve/main/diffusers_docs/astronaut_dpm.png" width="400"/> <br/>',Gl,Ue,Ms=`As you can see most images look very similar and are arguably of very similar quality. It often really depends on the specific use case which scheduler to choose. A good approach is always to run multiple different
schedulers to compare results.`,Cl,Je,Vl,Te,hs='If you are a JAX/Flax user, you can also change the default pipeline scheduler. This is a complete example of how to run inference using the Flax Stable Diffusion pipeline and the super-fast <a href="../api/schedulers/multistep_dpm_solver">DDPM-Solver++ scheduler</a>:',kl,$e,Wl,G,_l,Ge,xl;return j=new ve({props:{title:"Schedulers",local:"schedulers",headingTag:"h1"}}),w=new Ts({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/schedulers.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/schedulers.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/schedulers.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/schedulers.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/schedulers.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/schedulers.ipynb"}]}}),X=new ve({props:{title:"Load pipeline",local:"load-pipeline",headingTag:"h2"}}),I=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFsb2dpbigpJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

login()

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),E=new f({props:{code:"cGlwZWxpbmUudG8oJTIyY3VkYSUyMik=",highlighted:'pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)',wrap:!1}}),H=new ve({props:{title:"Access the scheduler",local:"access-the-scheduler",headingTag:"h2"}}),F=new f({props:{code:"cGlwZWxpbmUuc2NoZWR1bGVy",highlighted:"pipeline.scheduler",wrap:!1}}),z=new f({props:{code:"UE5ETVNjaGVkdWxlciUyMCU3QiUwQSUyMCUyMCUyMl9jbGFzc19uYW1lJTIyJTNBJTIwJTIyUE5ETVNjaGVkdWxlciUyMiUyQyUwQSUyMCUyMCUyMl9kaWZmdXNlcnNfdmVyc2lvbiUyMiUzQSUyMCUyMjAuOC4wLmRldjAlMjIlMkMlMEElMjAlMjAlMjJiZXRhX2VuZCUyMiUzQSUyMDAuMDEyJTJDJTBBJTIwJTIwJTIyYmV0YV9zY2hlZHVsZSUyMiUzQSUyMCUyMnNjYWxlZF9saW5lYXIlMjIlMkMlMEElMjAlMjAlMjJiZXRhX3N0YXJ0JTIyJTNBJTIwMC4wMDA4NSUyQyUwQSUyMCUyMCUyMmNsaXBfc2FtcGxlJTIyJTNBJTIwZmFsc2UlMkMlMEElMjAlMjAlMjJudW1fdHJhaW5fdGltZXN0ZXBzJTIyJTNBJTIwMTAwMCUyQyUwQSUyMCUyMCUyMnNldF9hbHBoYV90b19vbmUlMjIlM0ElMjBmYWxzZSUyQyUwQSUyMCUyMCUyMnNraXBfcHJrX3N0ZXBzJTIyJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMnN0ZXBzX29mZnNldCUyMiUzQSUyMDElMkMlMEElMjAlMjAlMjJ0cmFpbmVkX2JldGFzJTIyJTNBJTIwbnVsbCUwQSU3RA==",highlighted:`PNDMScheduler {
  <span class="hljs-string">&quot;_class_name&quot;</span>: <span class="hljs-string">&quot;PNDMScheduler&quot;</span>,
  <span class="hljs-string">&quot;_diffusers_version&quot;</span>: <span class="hljs-string">&quot;0.8.0.dev0&quot;</span>,
  <span class="hljs-string">&quot;beta_end&quot;</span>: <span class="hljs-number">0.012</span>,
  <span class="hljs-string">&quot;beta_schedule&quot;</span>: <span class="hljs-string">&quot;scaled_linear&quot;</span>,
  <span class="hljs-string">&quot;beta_start&quot;</span>: <span class="hljs-number">0.00085</span>,
  <span class="hljs-string">&quot;clip_sample&quot;</span>: <span class="hljs-literal">false</span>,
  <span class="hljs-string">&quot;num_train_timesteps&quot;</span>: <span class="hljs-number">1000</span>,
  <span class="hljs-string">&quot;set_alpha_to_one&quot;</span>: <span class="hljs-literal">false</span>,
  <span class="hljs-string">&quot;skip_prk_steps&quot;</span>: <span class="hljs-literal">true</span>,
  <span class="hljs-string">&quot;steps_offset&quot;</span>: <span class="hljs-number">1</span>,
  <span class="hljs-string">&quot;trained_betas&quot;</span>: <span class="hljs-literal">null</span>
}`,wrap:!1}}),D=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyQSUyMHBob3RvZ3JhcGglMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBNYXJzJTJDJTIwaGlnaCUyMHJlc29sdXRpb24lMkMlMjBoaWdoJTIwZGVmaW5pdGlvbi4lMjI=",highlighted:'prompt = <span class="hljs-string">&quot;A photograph of an astronaut riding a horse on Mars, high resolution, high definition.&quot;</span>',wrap:!1}}),Q=new f({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDgpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">8</span>)
image = pipeline(prompt, generator=generator).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),q=new ve({props:{title:"Changing the scheduler",local:"changing-the-scheduler",headingTag:"h2"}}),K=new f({props:{code:"cGlwZWxpbmUuc2NoZWR1bGVyLmNvbXBhdGlibGVz",highlighted:"pipeline.scheduler.compatibles",wrap:!1}}),ee=new f({props:{code:"JTVCZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19sbXNfZGlzY3JldGUuTE1TRGlzY3JldGVTY2hlZHVsZXIlMkMlMEElMjBkaWZmdXNlcnMuc2NoZWR1bGVycy5zY2hlZHVsaW5nX2RkaW0uRERJTVNjaGVkdWxlciUyQyUwQSUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfZHBtc29sdmVyX211bHRpc3RlcC5EUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIlMkMlMEElMjBkaWZmdXNlcnMuc2NoZWR1bGVycy5zY2hlZHVsaW5nX2V1bGVyX2Rpc2NyZXRlLkV1bGVyRGlzY3JldGVTY2hlZHVsZXIlMkMlMEElMjBkaWZmdXNlcnMuc2NoZWR1bGVycy5zY2hlZHVsaW5nX3BuZG0uUE5ETVNjaGVkdWxlciUyQyUwQSUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfZGRwbS5ERFBNU2NoZWR1bGVyJTJDJTBBJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19ldWxlcl9hbmNlc3RyYWxfZGlzY3JldGUuRXVsZXJBbmNlc3RyYWxEaXNjcmV0ZVNjaGVkdWxlciU1RA==",highlighted:`[<span class="hljs-keyword">diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_ddim.DDIMScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_dpmsolver_multistep.DPMSolverMultistepScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_euler_discrete.EulerDiscreteScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_pndm.PNDMScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_ddpm.DDPMScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_euler_ancestral_discrete.EulerAncestralDiscreteScheduler]</span>`,wrap:!1}}),ne=new f({props:{code:"cGlwZWxpbmUuc2NoZWR1bGVyLmNvbmZpZw==",highlighted:"pipeline.scheduler.config",wrap:!1}}),re=new f({props:{code:"RnJvemVuRGljdCglNUIoJ251bV90cmFpbl90aW1lc3RlcHMnJTJDJTIwMTAwMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoJ2JldGFfc3RhcnQnJTJDJTIwMC4wMDA4NSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoJ2JldGFfZW5kJyUyQyUyMDAuMDEyKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCgnYmV0YV9zY2hlZHVsZSclMkMlMjAnc2NhbGVkX2xpbmVhcicpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKCd0cmFpbmVkX2JldGFzJyUyQyUyME5vbmUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKCdza2lwX3Bya19zdGVwcyclMkMlMjBUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCgnc2V0X2FscGhhX3RvX29uZSclMkMlMjBGYWxzZSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoJ3N0ZXBzX29mZnNldCclMkMlMjAxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCgnX2NsYXNzX25hbWUnJTJDJTIwJ1BORE1TY2hlZHVsZXInKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCgnX2RpZmZ1c2Vyc192ZXJzaW9uJyUyQyUyMCcwLjguMC5kZXYwJyklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoJ2NsaXBfc2FtcGxlJyUyQyUyMEZhbHNlKSU1RCk=",highlighted:`FrozenDict([(&#x27;num_train_timesteps&#x27;, <span class="hljs-number">1000</span>),
            (&#x27;beta_start&#x27;, <span class="hljs-number">0.00085</span>),
            (&#x27;beta_end&#x27;, <span class="hljs-number">0.012</span>),
            (&#x27;beta_schedule&#x27;, &#x27;scaled_linear&#x27;),
            (&#x27;trained_betas&#x27;, None),
            (&#x27;skip_prk_steps&#x27;, True),
            (&#x27;set_alpha_to_one&#x27;, False),
            (&#x27;steps_offset&#x27;, <span class="hljs-number">1</span>),
            (&#x27;_class_name&#x27;, &#x27;PNDMScheduler&#x27;),
            (&#x27;_diffusers_version&#x27;, &#x27;<span class="hljs-number">0.8</span>.<span class="hljs-number">0</span>.dev0&#x27;),
            (&#x27;clip_sample&#x27;, False)])`,wrap:!1}}),ce=new f({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERESU1TY2hlZHVsZXIlMEElMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMScheduler

pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)`,wrap:!1}}),de=new f({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDgpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">8</span>)
image = pipeline(prompt, generator=generator).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Me=new ve({props:{title:"Compare schedulers",local:"compare-schedulers",headingTag:"h2"}}),fe=new f({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMExNU0Rpc2NyZXRlU2NoZWR1bGVyJTBBJTBBcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwTE1TRGlzY3JldGVTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZWxpbmUuc2NoZWR1bGVyLmNvbmZpZyklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3VkYSUyMikubWFudWFsX3NlZWQoOCklMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvcikuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LMSDiscreteScheduler

pipeline.scheduler = LMSDiscreteScheduler.from_config(pipeline.scheduler.config)

generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">8</span>)
image = pipeline(prompt, generator=generator).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),be=new f({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEV1bGVyRGlzY3JldGVTY2hlZHVsZXIlMEElMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBFdWxlckRpc2NyZXRlU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDgpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMzApLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> EulerDiscreteScheduler

pipeline.scheduler = EulerDiscreteScheduler.from_config(pipeline.scheduler.config)

generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">8</span>)
image = pipeline(prompt, generator=generator, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Ze=new f({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEV1bGVyQW5jZXN0cmFsRGlzY3JldGVTY2hlZHVsZXIlMEElMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBFdWxlckFuY2VzdHJhbERpc2NyZXRlU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDgpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMzApLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> EulerAncestralDiscreteScheduler

pipeline.scheduler = EulerAncestralDiscreteScheduler.from_config(pipeline.scheduler.config)

generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">8</span>)
image = pipeline(prompt, generator=generator, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),ge=new f({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUwQSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjdWRhJTIyKS5tYW51YWxfc2VlZCg4KSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDIwKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DPMSolverMultistepScheduler

pipeline.scheduler = DPMSolverMultistepScheduler.from_config(pipeline.scheduler.config)

generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">8</span>)
image = pipeline(prompt, generator=generator, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Je=new ve({props:{title:"Changing the Scheduler in Flax",local:"changing-the-scheduler-in-flax",headingTag:"h2"}}),$e=new f({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> jax
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> flax.jax_utils <span class="hljs-keyword">import</span> replicate
<span class="hljs-keyword">from</span> flax.training.common_utils <span class="hljs-keyword">import</span> shard

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxStableDiffusionPipeline, FlaxDPMSolverMultistepScheduler

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
scheduler, scheduler_state = FlaxDPMSolverMultistepScheduler.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>
)
pipeline, params = FlaxStableDiffusionPipeline.from_pretrained(
    model_id,
    scheduler=scheduler,
    revision=<span class="hljs-string">&quot;bf16&quot;</span>,
    dtype=jax.numpy.bfloat16,
)
params[<span class="hljs-string">&quot;scheduler&quot;</span>] = scheduler_state

<span class="hljs-comment"># Generate 1 image per parallel device (8 on TPUv2-8 or TPUv3-8)</span>
prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
num_samples = jax.device_count()
prompt_ids = pipeline.prepare_inputs([prompt] * num_samples)

prng_seed = jax.random.PRNGKey(<span class="hljs-number">0</span>)
num_inference_steps = <span class="hljs-number">25</span>

<span class="hljs-comment"># shard inputs and rng</span>
params = replicate(params)
prng_seed = jax.random.split(prng_seed, jax.device_count())
prompt_ids = shard(prompt_ids)

images = pipeline(prompt_ids, params, prng_seed, num_inference_steps, jit=<span class="hljs-literal">True</span>).images
images = pipeline.numpy_to_pil(np.asarray(images.reshape((num_samples,) + images.shape[-<span class="hljs-number">3</span>:])))`,wrap:!1}}),G=new Js({props:{warning:!0,$$slots:{default:[$s]},$$scope:{ctx:Ce}}}),{c(){o=i("meta"),V=n(),Z=i("p"),b=n(),c(j.$$.fragment),y=n(),c(w.$$.fragment),Ve=n(),k=i("p"),k.innerHTML=Bl,ke=n(),W=i("p"),W.innerHTML=Xl,We=n(),_=i("ul"),_.innerHTML=Sl,_e=n(),x=i("p"),x.innerHTML=Il,xe=n(),B=i("p"),B.textContent=Nl,Be=n(),c(X.$$.fragment),Xe=n(),S=i("p"),S.innerHTML=El,Se=n(),c(I.$$.fragment),Ie=n(),N=i("p"),N.textContent=Hl,Ne=n(),c(E.$$.fragment),Ee=n(),c(H.$$.fragment),He=n(),R=i("p"),R.innerHTML=Rl,Re=n(),c(F.$$.fragment),Fe=n(),A=i("p"),A.innerHTML=Fl,Ae=n(),c(z.$$.fragment),ze=n(),L=i("p"),L.innerHTML=Al,Le=n(),c(D.$$.fragment),De=n(),Y=i("p"),Y.textContent=zl,Ye=n(),c(Q.$$.fragment),Qe=n(),g=i("p"),g.innerHTML=Ll,qe=n(),c(q.$$.fragment),Pe=n(),P=i("p"),P.innerHTML=Dl,Ke=n(),c(K.$$.fragment),Oe=n(),O=i("p"),O.innerHTML=Yl,el=n(),c(ee.$$.fragment),ll=n(),le=i("p"),le.textContent=Ql,sl=n(),se=i("ul"),se.innerHTML=ql,tl=n(),te=i("p"),te.innerHTML=Pl,nl=n(),c(ne.$$.fragment),al=n(),ae=i("p"),ae.textContent=Kl,il=n(),ie=i("p"),ie.innerHTML=Ol,rl=n(),c(re.$$.fragment),pl=n(),pe=i("p"),pe.innerHTML=es,cl=n(),c(ce.$$.fragment),ul=n(),ue=i("p"),ue.textContent=ls,dl=n(),c(de.$$.fragment),ml=n(),U=i("p"),U.innerHTML=ss,Ml=n(),me=i("p"),me.innerHTML=ts,hl=n(),c(Me.$$.fragment),ol=n(),he=i("p"),he.innerHTML=ns,fl=n(),oe=i("p"),oe.innerHTML=as,yl=n(),c(fe.$$.fragment),bl=n(),J=i("p"),J.innerHTML=is,wl=n(),ye=i("p"),ye.innerHTML=rs,Zl=n(),c(be.$$.fragment),jl=n(),T=i("p"),T.innerHTML=ps,gl=n(),we=i("p"),we.textContent=cs,Ul=n(),c(Ze.$$.fragment),Jl=n(),$=i("p"),$.innerHTML=us,Tl=n(),je=i("p"),je.innerHTML=ds,$l=n(),c(ge.$$.fragment),vl=n(),v=i("p"),v.innerHTML=ms,Gl=n(),Ue=i("p"),Ue.textContent=Ms,Cl=n(),c(Je.$$.fragment),Vl=n(),Te=i("p"),Te.innerHTML=hs,kl=n(),c($e.$$.fragment),Wl=n(),c(G.$$.fragment),_l=n(),Ge=i("p"),this.h()},l(e){const l=gs("svelte-u9bgzb",document.head);o=r(l,"META",{name:!0,content:!0}),l.forEach(s),V=a(e),Z=r(e,"P",{}),fs(Z).forEach(s),b=a(e),u(j.$$.fragment,e),y=a(e),u(w.$$.fragment,e),Ve=a(e),k=r(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-6tohfm"&&(k.innerHTML=Bl),ke=a(e),W=r(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-pj1fnh"&&(W.innerHTML=Xl),We=a(e),_=r(e,"UL",{"data-svelte-h":!0}),p(_)!=="svelte-90ru"&&(_.innerHTML=Sl),_e=a(e),x=r(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-7vywvj"&&(x.innerHTML=Il),xe=a(e),B=r(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1h9ag03"&&(B.textContent=Nl),Be=a(e),u(X.$$.fragment,e),Xe=a(e),S=r(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1pkuhgi"&&(S.innerHTML=El),Se=a(e),u(I.$$.fragment,e),Ie=a(e),N=r(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1pntiyw"&&(N.textContent=Hl),Ne=a(e),u(E.$$.fragment,e),Ee=a(e),u(H.$$.fragment,e),He=a(e),R=r(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-ifniwj"&&(R.innerHTML=Rl),Re=a(e),u(F.$$.fragment,e),Fe=a(e),A=r(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-jl1fz0"&&(A.innerHTML=Fl),Ae=a(e),u(z.$$.fragment,e),ze=a(e),L=r(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-hpwiea"&&(L.innerHTML=Al),Le=a(e),u(D.$$.fragment,e),De=a(e),Y=r(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1crup8"&&(Y.textContent=zl),Ye=a(e),u(Q.$$.fragment,e),Qe=a(e),g=r(e,"P",{align:!0,"data-svelte-h":!0}),p(g)!=="svelte-4ve60e"&&(g.innerHTML=Ll),qe=a(e),u(q.$$.fragment,e),Pe=a(e),P=r(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1a3waqy"&&(P.innerHTML=Dl),Ke=a(e),u(K.$$.fragment,e),Oe=a(e),O=r(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-jl1fz0"&&(O.innerHTML=Yl),el=a(e),u(ee.$$.fragment,e),ll=a(e),le=r(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-4cs0p7"&&(le.textContent=Ql),sl=a(e),se=r(e,"UL",{"data-svelte-h":!0}),p(se)!=="svelte-1ju0d8c"&&(se.innerHTML=ql),tl=a(e),te=r(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1oil2u9"&&(te.innerHTML=Pl),nl=a(e),u(ne.$$.fragment,e),al=a(e),ae=r(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-sih4ln"&&(ae.textContent=Kl),il=a(e),ie=r(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-jl1fz0"&&(ie.innerHTML=Ol),rl=a(e),u(re.$$.fragment,e),pl=a(e),pe=r(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1dvqgs9"&&(pe.innerHTML=es),cl=a(e),u(ce.$$.fragment,e),ul=a(e),ue=r(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-zqrmvv"&&(ue.textContent=ls),dl=a(e),u(de.$$.fragment,e),ml=a(e),U=r(e,"P",{align:!0,"data-svelte-h":!0}),p(U)!=="svelte-cbz2yl"&&(U.innerHTML=ss),Ml=a(e),me=r(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-1g5sqb9"&&(me.innerHTML=ts),hl=a(e),u(Me.$$.fragment,e),ol=a(e),he=r(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-1xzyvuj"&&(he.innerHTML=ns),fl=a(e),oe=r(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1wgmwzp"&&(oe.innerHTML=as),yl=a(e),u(fe.$$.fragment,e),bl=a(e),J=r(e,"P",{align:!0,"data-svelte-h":!0}),p(J)!=="svelte-1grq2s7"&&(J.innerHTML=is),wl=a(e),ye=r(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-qncfah"&&(ye.innerHTML=rs),Zl=a(e),u(be.$$.fragment,e),jl=a(e),T=r(e,"P",{align:!0,"data-svelte-h":!0}),p(T)!=="svelte-49gzme"&&(T.innerHTML=ps),gl=a(e),we=r(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1x72rsv"&&(we.textContent=cs),Ul=a(e),u(Ze.$$.fragment,e),Jl=a(e),$=r(e,"P",{align:!0,"data-svelte-h":!0}),p($)!=="svelte-14z2yp4"&&($.innerHTML=us),Tl=a(e),je=r(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-1xwnkyq"&&(je.innerHTML=ds),$l=a(e),u(ge.$$.fragment,e),vl=a(e),v=r(e,"P",{align:!0,"data-svelte-h":!0}),p(v)!=="svelte-y1ydb2"&&(v.innerHTML=ms),Gl=a(e),Ue=r(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-nd0f1w"&&(Ue.textContent=Ms),Cl=a(e),u(Je.$$.fragment,e),Vl=a(e),Te=r(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-1knbg37"&&(Te.innerHTML=hs),kl=a(e),u($e.$$.fragment,e),Wl=a(e),u(G.$$.fragment,e),_l=a(e),Ge=r(e,"P",{}),fs(Ge).forEach(s),this.h()},h(){C(o,"name","hf:doc:metadata"),C(o,"content",Gs),C(g,"align","center"),C(U,"align","center"),C(J,"align","center"),C(T,"align","center"),C($,"align","center"),C(v,"align","center")},m(e,l){Us(document.head,o),t(e,V,l),t(e,Z,l),t(e,b,l),d(j,e,l),t(e,y,l),d(w,e,l),t(e,Ve,l),t(e,k,l),t(e,ke,l),t(e,W,l),t(e,We,l),t(e,_,l),t(e,_e,l),t(e,x,l),t(e,xe,l),t(e,B,l),t(e,Be,l),d(X,e,l),t(e,Xe,l),t(e,S,l),t(e,Se,l),d(I,e,l),t(e,Ie,l),t(e,N,l),t(e,Ne,l),d(E,e,l),t(e,Ee,l),d(H,e,l),t(e,He,l),t(e,R,l),t(e,Re,l),d(F,e,l),t(e,Fe,l),t(e,A,l),t(e,Ae,l),d(z,e,l),t(e,ze,l),t(e,L,l),t(e,Le,l),d(D,e,l),t(e,De,l),t(e,Y,l),t(e,Ye,l),d(Q,e,l),t(e,Qe,l),t(e,g,l),t(e,qe,l),d(q,e,l),t(e,Pe,l),t(e,P,l),t(e,Ke,l),d(K,e,l),t(e,Oe,l),t(e,O,l),t(e,el,l),d(ee,e,l),t(e,ll,l),t(e,le,l),t(e,sl,l),t(e,se,l),t(e,tl,l),t(e,te,l),t(e,nl,l),d(ne,e,l),t(e,al,l),t(e,ae,l),t(e,il,l),t(e,ie,l),t(e,rl,l),d(re,e,l),t(e,pl,l),t(e,pe,l),t(e,cl,l),d(ce,e,l),t(e,ul,l),t(e,ue,l),t(e,dl,l),d(de,e,l),t(e,ml,l),t(e,U,l),t(e,Ml,l),t(e,me,l),t(e,hl,l),d(Me,e,l),t(e,ol,l),t(e,he,l),t(e,fl,l),t(e,oe,l),t(e,yl,l),d(fe,e,l),t(e,bl,l),t(e,J,l),t(e,wl,l),t(e,ye,l),t(e,Zl,l),d(be,e,l),t(e,jl,l),t(e,T,l),t(e,gl,l),t(e,we,l),t(e,Ul,l),d(Ze,e,l),t(e,Jl,l),t(e,$,l),t(e,Tl,l),t(e,je,l),t(e,$l,l),d(ge,e,l),t(e,vl,l),t(e,v,l),t(e,Gl,l),t(e,Ue,l),t(e,Cl,l),d(Je,e,l),t(e,Vl,l),t(e,Te,l),t(e,kl,l),d($e,e,l),t(e,Wl,l),d(G,e,l),t(e,_l,l),t(e,Ge,l),xl=!0},p(e,[l]){const os={};l&2&&(os.$$scope={dirty:l,ctx:e}),G.$set(os)},i(e){xl||(m(j.$$.fragment,e),m(w.$$.fragment,e),m(X.$$.fragment,e),m(I.$$.fragment,e),m(E.$$.fragment,e),m(H.$$.fragment,e),m(F.$$.fragment,e),m(z.$$.fragment,e),m(D.$$.fragment,e),m(Q.$$.fragment,e),m(q.$$.fragment,e),m(K.$$.fragment,e),m(ee.$$.fragment,e),m(ne.$$.fragment,e),m(re.$$.fragment,e),m(ce.$$.fragment,e),m(de.$$.fragment,e),m(Me.$$.fragment,e),m(fe.$$.fragment,e),m(be.$$.fragment,e),m(Ze.$$.fragment,e),m(ge.$$.fragment,e),m(Je.$$.fragment,e),m($e.$$.fragment,e),m(G.$$.fragment,e),xl=!0)},o(e){M(j.$$.fragment,e),M(w.$$.fragment,e),M(X.$$.fragment,e),M(I.$$.fragment,e),M(E.$$.fragment,e),M(H.$$.fragment,e),M(F.$$.fragment,e),M(z.$$.fragment,e),M(D.$$.fragment,e),M(Q.$$.fragment,e),M(q.$$.fragment,e),M(K.$$.fragment,e),M(ee.$$.fragment,e),M(ne.$$.fragment,e),M(re.$$.fragment,e),M(ce.$$.fragment,e),M(de.$$.fragment,e),M(Me.$$.fragment,e),M(fe.$$.fragment,e),M(be.$$.fragment,e),M(Ze.$$.fragment,e),M(ge.$$.fragment,e),M(Je.$$.fragment,e),M($e.$$.fragment,e),M(G.$$.fragment,e),xl=!1},d(e){e&&(s(V),s(Z),s(b),s(y),s(Ve),s(k),s(ke),s(W),s(We),s(_),s(_e),s(x),s(xe),s(B),s(Be),s(Xe),s(S),s(Se),s(Ie),s(N),s(Ne),s(Ee),s(He),s(R),s(Re),s(Fe),s(A),s(Ae),s(ze),s(L),s(Le),s(De),s(Y),s(Ye),s(Qe),s(g),s(qe),s(Pe),s(P),s(Ke),s(Oe),s(O),s(el),s(ll),s(le),s(sl),s(se),s(tl),s(te),s(nl),s(al),s(ae),s(il),s(ie),s(rl),s(pl),s(pe),s(cl),s(ul),s(ue),s(dl),s(ml),s(U),s(Ml),s(me),s(hl),s(ol),s(he),s(fl),s(oe),s(yl),s(bl),s(J),s(wl),s(ye),s(Zl),s(jl),s(T),s(gl),s(we),s(Ul),s(Jl),s($),s(Tl),s(je),s($l),s(vl),s(v),s(Gl),s(Ue),s(Cl),s(Vl),s(Te),s(kl),s(Wl),s(_l),s(Ge)),s(o),h(j,e),h(w,e),h(X,e),h(I,e),h(E,e),h(H,e),h(F,e),h(z,e),h(D,e),h(Q,e),h(q,e),h(K,e),h(ee,e),h(ne,e),h(re,e),h(ce,e),h(de,e),h(Me,e),h(fe,e),h(be,e),h(Ze,e),h(ge,e),h(Je,e),h($e,e),h(G,e)}}}const Gs='{"title":"Schedulers","local":"schedulers","sections":[{"title":"Load pipeline","local":"load-pipeline","sections":[],"depth":2},{"title":"Access the scheduler","local":"access-the-scheduler","sections":[],"depth":2},{"title":"Changing the scheduler","local":"changing-the-scheduler","sections":[],"depth":2},{"title":"Compare schedulers","local":"compare-schedulers","sections":[],"depth":2},{"title":"Changing the Scheduler in Flax","local":"changing-the-scheduler-in-flax","sections":[],"depth":2}],"depth":1}';function Cs(Ce){return bs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xs extends Zs{constructor(o){super(),js(this,o,Cs,vs,ys,{})}}export{Xs as component};
