import{s as Sl,f as Hl,o as Yl,n as $}from"../chunks/scheduler.9bc65507.js";import{S as Ll,i as Pl,g as c,s as r,r as T,A as Dl,h as p,f as n,c as i,j as z,u as y,x as u,k as q,y as h,a as l,v as _,d as w,t as b,w as j}from"../chunks/index.707bf1b6.js";import{T as ue}from"../chunks/Tip.c2ecdbf4.js";import{D as x}from"../chunks/Docstring.17db21ae.js";import{C as R}from"../chunks/CodeBlock.54a9f38d.js";import{F as oa,M as ss}from"../chunks/Markdown.8ab98a13.js";import{E as ve}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H}from"../chunks/Heading.342b1fa6.js";function Ol(k){let s,m="Initializing a model with a pre-trained base and randomly initialized classification heads from the hub can be done as shown below.",t,a,f,o,g='Of course, you don’t necessarily have to follow one of these three ways in which TAPAS was fine-tuned. You can also experiment by defining any hyperparameters you want when initializing <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a>, and then create a <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasForQuestionAnswering">TapasForQuestionAnswering</a> based on that configuration. For example, if you have a dataset that has both conversational questions and questions that might involve aggregation, then you can do it this way. Here’s an example:',Z,J,v;return a=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRhcGFzQ29uZmlnJTJDJTIwVGFwYXNGb3JRdWVzdGlvbkFuc3dlcmluZyUwQSUwQSUyMyUyMGZvciUyMGV4YW1wbGUlMkMlMjB0aGUlMjBiYXNlJTIwc2l6ZWQlMjBtb2RlbCUyMHdpdGglMjBkZWZhdWx0JTIwU1FBJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwVGFwYXNGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdGFwYXMtYmFzZSUyMiklMEElMEElMjMlMjBvciUyQyUyMHRoZSUyMGJhc2UlMjBzaXplZCUyMG1vZGVsJTIwd2l0aCUyMFdUUSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWclMjAlM0QlMjBUYXBhc0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdGFwYXMtYmFzZS1maW5ldHVuZWQtd3RxJTIyKSUwQW1vZGVsJTIwJTNEJTIwVGFwYXNGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdGFwYXMtYmFzZSUyMiUyQyUyMGNvbmZpZyUzRGNvbmZpZyklMEElMEElMjMlMjBvciUyQyUyMHRoZSUyMGJhc2UlMjBzaXplZCUyMG1vZGVsJTIwd2l0aCUyMFdpa2lTUUwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlnJTIwJTNEJTIwVGFwYXNDb25maWcoJTIyZ29vZ2xlLWJhc2UtZmluZXR1bmVkLXdpa2lzcWwtc3VwZXJ2aXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFRhcGFzRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UlMjIlMkMlMjBjb25maWclM0Rjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TapasConfig, TapasForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># for example, the base sized model with default SQA configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># or, the base sized model with WTQ configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = TapasConfig.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>, config=config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># or, the base sized model with WikiSQL configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = TapasConfig(<span class="hljs-string">&quot;google-base-finetuned-wikisql-supervised&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>, config=config)`,wrap:!1}}),J=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRhcGFzQ29uZmlnJTJDJTIwVGFwYXNGb3JRdWVzdGlvbkFuc3dlcmluZyUwQSUwQSUyMyUyMHlvdSUyMGNhbiUyMGluaXRpYWxpemUlMjB0aGUlMjBjbGFzc2lmaWNhdGlvbiUyMGhlYWRzJTIwYW55JTIwd2F5JTIweW91JTIwd2FudCUyMChzZWUlMjBkb2NzJTIwb2YlMjBUYXBhc0NvbmZpZyklMEFjb25maWclMjAlM0QlMjBUYXBhc0NvbmZpZyhudW1fYWdncmVnYXRpb25fbGFiZWxzJTNEMyUyQyUyMGF2ZXJhZ2VfbG9naXRzX3Blcl9jZWxsJTNEVHJ1ZSklMEElMjMlMjBpbml0aWFsaXppbmclMjB0aGUlMjBwcmUtdHJhaW5lZCUyMGJhc2UlMjBzaXplZCUyMG1vZGVsJTIwd2l0aCUyMG91ciUyMGN1c3RvbSUyMGNsYXNzaWZpY2F0aW9uJTIwaGVhZHMlMEFtb2RlbCUyMCUzRCUyMFRhcGFzRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UlMjIlMkMlMjBjb25maWclM0Rjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TapasConfig, TapasForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can initialize the classification heads any way you want (see docs of TapasConfig)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = TapasConfig(num_aggregation_labels=<span class="hljs-number">3</span>, average_logits_per_cell=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># initializing the pre-trained base sized model with our custom classification heads</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>, config=config)`,wrap:!1}}),{c(){s=c("p"),s.textContent=m,t=r(),T(a.$$.fragment),f=r(),o=c("p"),o.innerHTML=g,Z=r(),T(J.$$.fragment)},l(U){s=p(U,"P",{"data-svelte-h":!0}),u(s)!=="svelte-4jdzmp"&&(s.textContent=m),t=i(U),y(a.$$.fragment,U),f=i(U),o=p(U,"P",{"data-svelte-h":!0}),u(o)!=="svelte-15p09y4"&&(o.innerHTML=g),Z=i(U),y(J.$$.fragment,U)},m(U,C){l(U,s,C),l(U,t,C),_(a,U,C),l(U,f,C),l(U,o,C),l(U,Z,C),_(J,U,C),v=!0},p:$,i(U){v||(w(a.$$.fragment,U),w(J.$$.fragment,U),v=!0)},o(U){b(a.$$.fragment,U),b(J.$$.fragment,U),v=!1},d(U){U&&(n(s),n(t),n(f),n(o),n(Z)),j(a,U),j(J,U)}}}function Kl(k){let s,m;return s=new ss({props:{$$slots:{default:[Ol]},$$scope:{ctx:k}}}),{c(){T(s.$$.fragment)},l(t){y(s.$$.fragment,t)},m(t,a){_(s,t,a),m=!0},p(t,a){const f={};a&2&&(f.$$scope={dirty:a,ctx:t}),s.$set(f)},i(t){m||(w(s.$$.fragment,t),m=!0)},o(t){b(s.$$.fragment,t),m=!1},d(t){j(s,t)}}}function er(k){let s,m='Initializing a model with a pre-trained base and randomly initialized classification heads from the hub can be done as shown below. Be sure to have installed the <a href="https://github.com/tensorflow/probability" rel="nofollow">tensorflow_probability</a> dependency:',t,a,f,o,g='Of course, you don’t necessarily have to follow one of these three ways in which TAPAS was fine-tuned. You can also experiment by defining any hyperparameters you want when initializing <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a>, and then create a <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TFTapasForQuestionAnswering">TFTapasForQuestionAnswering</a> based on that configuration. For example, if you have a dataset that has both conversational questions and questions that might involve aggregation, then you can do it this way. Here’s an example:',Z,J,v;return a=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRhcGFzQ29uZmlnJTJDJTIwVEZUYXBhc0ZvclF1ZXN0aW9uQW5zd2VyaW5nJTBBJTBBJTIzJTIwZm9yJTIwZXhhbXBsZSUyQyUyMHRoZSUyMGJhc2UlMjBzaXplZCUyMG1vZGVsJTIwd2l0aCUyMGRlZmF1bHQlMjBTUUElMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBURlRhcGFzRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UlMjIpJTBBJTBBJTIzJTIwb3IlMkMlMjB0aGUlMjBiYXNlJTIwc2l6ZWQlMjBtb2RlbCUyMHdpdGglMjBXVFElMjBjb25maWd1cmF0aW9uJTBBY29uZmlnJTIwJTNEJTIwVGFwYXNDb25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMiklMEFtb2RlbCUyMCUzRCUyMFRGVGFwYXNGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdGFwYXMtYmFzZSUyMiUyQyUyMGNvbmZpZyUzRGNvbmZpZyklMEElMEElMjMlMjBvciUyQyUyMHRoZSUyMGJhc2UlMjBzaXplZCUyMG1vZGVsJTIwd2l0aCUyMFdpa2lTUUwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlnJTIwJTNEJTIwVGFwYXNDb25maWcoJTIyZ29vZ2xlLWJhc2UtZmluZXR1bmVkLXdpa2lzcWwtc3VwZXJ2aXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGVGFwYXNGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdGFwYXMtYmFzZSUyMiUyQyUyMGNvbmZpZyUzRGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TapasConfig, TFTapasForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># for example, the base sized model with default SQA configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFTapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># or, the base sized model with WTQ configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = TapasConfig.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFTapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>, config=config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># or, the base sized model with WikiSQL configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = TapasConfig(<span class="hljs-string">&quot;google-base-finetuned-wikisql-supervised&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFTapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>, config=config)`,wrap:!1}}),J=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRhcGFzQ29uZmlnJTJDJTIwVEZUYXBhc0ZvclF1ZXN0aW9uQW5zd2VyaW5nJTBBJTBBJTIzJTIweW91JTIwY2FuJTIwaW5pdGlhbGl6ZSUyMHRoZSUyMGNsYXNzaWZpY2F0aW9uJTIwaGVhZHMlMjBhbnklMjB3YXklMjB5b3UlMjB3YW50JTIwKHNlZSUyMGRvY3MlMjBvZiUyMFRhcGFzQ29uZmlnKSUwQWNvbmZpZyUyMCUzRCUyMFRhcGFzQ29uZmlnKG51bV9hZ2dyZWdhdGlvbl9sYWJlbHMlM0QzJTJDJTIwYXZlcmFnZV9sb2dpdHNfcGVyX2NlbGwlM0RUcnVlKSUwQSUyMyUyMGluaXRpYWxpemluZyUyMHRoZSUyMHByZS10cmFpbmVkJTIwYmFzZSUyMHNpemVkJTIwbW9kZWwlMjB3aXRoJTIwb3VyJTIwY3VzdG9tJTIwY2xhc3NpZmljYXRpb24lMjBoZWFkcyUwQW1vZGVsJTIwJTNEJTIwVEZUYXBhc0ZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlJTIyJTJDJTIwY29uZmlnJTNEY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TapasConfig, TFTapasForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can initialize the classification heads any way you want (see docs of TapasConfig)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = TapasConfig(num_aggregation_labels=<span class="hljs-number">3</span>, average_logits_per_cell=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># initializing the pre-trained base sized model with our custom classification heads</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFTapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>, config=config)`,wrap:!1}}),{c(){s=c("p"),s.innerHTML=m,t=r(),T(a.$$.fragment),f=r(),o=c("p"),o.innerHTML=g,Z=r(),T(J.$$.fragment)},l(U){s=p(U,"P",{"data-svelte-h":!0}),u(s)!=="svelte-1b9vztz"&&(s.innerHTML=m),t=i(U),y(a.$$.fragment,U),f=i(U),o=p(U,"P",{"data-svelte-h":!0}),u(o)!=="svelte-1sfzrl0"&&(o.innerHTML=g),Z=i(U),y(J.$$.fragment,U)},m(U,C){l(U,s,C),l(U,t,C),_(a,U,C),l(U,f,C),l(U,o,C),l(U,Z,C),_(J,U,C),v=!0},p:$,i(U){v||(w(a.$$.fragment,U),w(J.$$.fragment,U),v=!0)},o(U){b(a.$$.fragment,U),b(J.$$.fragment,U),v=!1},d(U){U&&(n(s),n(t),n(f),n(o),n(Z)),j(a,U),j(J,U)}}}function sr(k){let s,m;return s=new ss({props:{$$slots:{default:[er]},$$scope:{ctx:k}}}),{c(){T(s.$$.fragment)},l(t){y(s.$$.fragment,t)},m(t,a){_(s,t,a),m=!0},p(t,a){const f={};a&2&&(f.$$scope={dirty:a,ctx:t}),s.$set(f)},i(t){m||(w(s.$$.fragment,t),m=!0)},o(t){b(s.$$.fragment,t),m=!1},d(t){j(s,t)}}}function tr(k){let s,m=`Third, given that you’ve prepared your data in this TSV/CSV format (and corresponding CSV files containing the tabular data), you can then use <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a> to convert table-question pairs into <code>input_ids</code>, <code>attention_mask</code>, <code>token_type_ids</code> and so on. Again, based on which of the three cases you picked above, <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasForQuestionAnswering">TapasForQuestionAnswering</a> requires different
inputs to be fine-tuned:`,t,a,f="<thead><tr><th><strong>Task</strong></th> <th><strong>Required inputs</strong></th></tr></thead> <tbody><tr><td>Conversational</td> <td><code>input_ids</code>, <code>attention_mask</code>, <code>token_type_ids</code>, <code>labels</code></td></tr> <tr><td>Weak supervision for aggregation</td> <td><code>input_ids</code>, <code>attention_mask</code>, <code>token_type_ids</code>, <code>labels</code>, <code>numeric_values</code>, <code>numeric_values_scale</code>, <code>float_answer</code></td></tr> <tr><td>Strong supervision for aggregation</td> <td><code>input ids</code>, <code>attention mask</code>, <code>token type ids</code>, <code>labels</code>, <code>aggregation_labels</code></td></tr></tbody>",o,g,Z='<a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a> creates the <code>labels</code>, <code>numeric_values</code> and <code>numeric_values_scale</code> based on the <code>answer_coordinates</code> and <code>answer_text</code> columns of the TSV file. The <code>float_answer</code> and <code>aggregation_labels</code> are already in the TSV file of step 2. Here’s an example:',J,v,U,C,A=`Note that <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a> expects the data of the table to be <strong>text-only</strong>. You can use <code>.astype(str)</code> on a dataframe to turn it into text-only data.
Of course, this only shows how to encode a single training example. It is advised to create a dataloader to iterate over batches:`,W,M,F;return v=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRhcGFzVG9rZW5pemVyJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQW1vZGVsX25hbWUlMjAlM0QlMjAlMjJnb29nbGUlMkZ0YXBhcy1iYXNlJTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwVGFwYXNUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWUpJTBBJTBBZGF0YSUyMCUzRCUyMCU3QiUyMkFjdG9ycyUyMiUzQSUyMCU1QiUyMkJyYWQlMjBQaXR0JTIyJTJDJTIwJTIyTGVvbmFyZG8lMjBEaSUyMENhcHJpbyUyMiUyQyUyMCUyMkdlb3JnZSUyMENsb29uZXklMjIlNUQlMkMlMjAlMjJOdW1iZXIlMjBvZiUyMG1vdmllcyUyMiUzQSUyMCU1QiUyMjg3JTIyJTJDJTIwJTIyNTMlMjIlMkMlMjAlMjI2OSUyMiU1RCU3RCUwQXF1ZXJpZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBuYW1lJTIwb2YlMjB0aGUlMjBmaXJzdCUyMGFjdG9yJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIySG93JTIwbWFueSUyMG1vdmllcyUyMGhhcyUyMEdlb3JnZSUyMENsb29uZXklMjBwbGF5ZWQlMjBpbiUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMldoYXQlMjBpcyUyMHRoZSUyMHRvdGFsJTIwbnVtYmVyJTIwb2YlMjBtb3ZpZXMlM0YlMjIlMkMlMEElNUQlMEFhbnN3ZXJfY29vcmRpbmF0ZXMlMjAlM0QlMjAlNUIlNUIoMCUyQyUyMDApJTVEJTJDJTIwJTVCKDIlMkMlMjAxKSU1RCUyQyUyMCU1QigwJTJDJTIwMSklMkMlMjAoMSUyQyUyMDEpJTJDJTIwKDIlMkMlMjAxKSU1RCU1RCUwQWFuc3dlcl90ZXh0JTIwJTNEJTIwJTVCJTVCJTIyQnJhZCUyMFBpdHQlMjIlNUQlMkMlMjAlNUIlMjI2OSUyMiU1RCUyQyUyMCU1QiUyMjIwOSUyMiU1RCU1RCUwQXRhYmxlJTIwJTNEJTIwcGQuRGF0YUZyYW1lLmZyb21fZGljdChkYXRhKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjB0YWJsZSUzRHRhYmxlJTJDJTBBJTIwJTIwJTIwJTIwcXVlcmllcyUzRHF1ZXJpZXMlMkMlMEElMjAlMjAlMjAlMjBhbnN3ZXJfY29vcmRpbmF0ZXMlM0RhbnN3ZXJfY29vcmRpbmF0ZXMlMkMlMEElMjAlMjAlMjAlMjBhbnN3ZXJfdGV4dCUzRGFuc3dlcl90ZXh0JTJDJTBBJTIwJTIwJTIwJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTBBKSUwQWlucHV0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TapasTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>model_name = <span class="hljs-string">&quot;google/tapas-base&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = TapasTokenizer.from_pretrained(model_name)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {<span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>], <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>queries = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;What is the name of the first actor?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;How many movies has George Clooney played in?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;What is the total number of movies?&quot;</span>,
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>answer_coordinates = [[(<span class="hljs-number">0</span>, <span class="hljs-number">0</span>)], [(<span class="hljs-number">2</span>, <span class="hljs-number">1</span>)], [(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>), (<span class="hljs-number">1</span>, <span class="hljs-number">1</span>), (<span class="hljs-number">2</span>, <span class="hljs-number">1</span>)]]
<span class="hljs-meta">&gt;&gt;&gt; </span>answer_text = [[<span class="hljs-string">&quot;Brad Pitt&quot;</span>], [<span class="hljs-string">&quot;69&quot;</span>], [<span class="hljs-string">&quot;209&quot;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    table=table,
<span class="hljs-meta">... </span>    queries=queries,
<span class="hljs-meta">... </span>    answer_coordinates=answer_coordinates,
<span class="hljs-meta">... </span>    answer_text=answer_text,
<span class="hljs-meta">... </span>    padding=<span class="hljs-string">&quot;max_length&quot;</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs
{<span class="hljs-string">&#x27;input_ids&#x27;</span>: tensor([[ ... ]]), <span class="hljs-string">&#x27;attention_mask&#x27;</span>: tensor([[...]]), <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: tensor([[[...]]]),
<span class="hljs-string">&#x27;numeric_values&#x27;</span>: tensor([[ ... ]]), <span class="hljs-string">&#x27;numeric_values_scale: tensor([[ ... ]]), labels: tensor([[ ... ]])}</span>`,wrap:!1}}),M=new R({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>tsv_path = <span class="hljs-string">&quot;your_path_to_the_tsv_file&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>table_csv_path = <span class="hljs-string">&quot;your_path_to_a_directory_containing_all_csv_files&quot;</span>


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">TableDataset</span>(torch.utils.data.Dataset):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, data, tokenizer</span>):
<span class="hljs-meta">... </span>        self.data = data
<span class="hljs-meta">... </span>        self.tokenizer = tokenizer

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__getitem__</span>(<span class="hljs-params">self, idx</span>):
<span class="hljs-meta">... </span>        item = data.iloc[idx]
<span class="hljs-meta">... </span>        table = pd.read_csv(table_csv_path + item.table_file).astype(
<span class="hljs-meta">... </span>            <span class="hljs-built_in">str</span>
<span class="hljs-meta">... </span>        )  <span class="hljs-comment"># be sure to make your table data text only</span>
<span class="hljs-meta">... </span>        encoding = self.tokenizer(
<span class="hljs-meta">... </span>            table=table,
<span class="hljs-meta">... </span>            queries=item.question,
<span class="hljs-meta">... </span>            answer_coordinates=item.answer_coordinates,
<span class="hljs-meta">... </span>            answer_text=item.answer_text,
<span class="hljs-meta">... </span>            truncation=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>            padding=<span class="hljs-string">&quot;max_length&quot;</span>,
<span class="hljs-meta">... </span>            return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>        )
<span class="hljs-meta">... </span>        <span class="hljs-comment"># remove the batch dimension which the tokenizer adds by default</span>
<span class="hljs-meta">... </span>        encoding = {key: val.squeeze(<span class="hljs-number">0</span>) <span class="hljs-keyword">for</span> key, val <span class="hljs-keyword">in</span> encoding.items()}
<span class="hljs-meta">... </span>        <span class="hljs-comment"># add the float_answer which is also required (weak supervision for aggregation case)</span>
<span class="hljs-meta">... </span>        encoding[<span class="hljs-string">&quot;float_answer&quot;</span>] = torch.tensor(item.float_answer)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> encoding

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__len__</span>(<span class="hljs-params">self</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> <span class="hljs-built_in">len</span>(self.data)


<span class="hljs-meta">&gt;&gt;&gt; </span>data = pd.read_csv(tsv_path, sep=<span class="hljs-string">&quot;\\t&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataset = TableDataset(data, tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataloader = torch.utils.data.DataLoader(train_dataset, batch_size=<span class="hljs-number">32</span>)`,wrap:!1}}),{c(){s=c("p"),s.innerHTML=m,t=r(),a=c("table"),a.innerHTML=f,o=r(),g=c("p"),g.innerHTML=Z,J=r(),T(v.$$.fragment),U=r(),C=c("p"),C.innerHTML=A,W=r(),T(M.$$.fragment)},l(I){s=p(I,"P",{"data-svelte-h":!0}),u(s)!=="svelte-1658ubq"&&(s.innerHTML=m),t=i(I),a=p(I,"TABLE",{"data-svelte-h":!0}),u(a)!=="svelte-1f72bji"&&(a.innerHTML=f),o=i(I),g=p(I,"P",{"data-svelte-h":!0}),u(g)!=="svelte-1e8w5iu"&&(g.innerHTML=Z),J=i(I),y(v.$$.fragment,I),U=i(I),C=p(I,"P",{"data-svelte-h":!0}),u(C)!=="svelte-1yzoea5"&&(C.innerHTML=A),W=i(I),y(M.$$.fragment,I)},m(I,B){l(I,s,B),l(I,t,B),l(I,a,B),l(I,o,B),l(I,g,B),l(I,J,B),_(v,I,B),l(I,U,B),l(I,C,B),l(I,W,B),_(M,I,B),F=!0},p:$,i(I){F||(w(v.$$.fragment,I),w(M.$$.fragment,I),F=!0)},o(I){b(v.$$.fragment,I),b(M.$$.fragment,I),F=!1},d(I){I&&(n(s),n(t),n(a),n(o),n(g),n(J),n(U),n(C),n(W)),j(v,I),j(M,I)}}}function nr(k){let s,m;return s=new ss({props:{$$slots:{default:[tr]},$$scope:{ctx:k}}}),{c(){T(s.$$.fragment)},l(t){y(s.$$.fragment,t)},m(t,a){_(s,t,a),m=!0},p(t,a){const f={};a&2&&(f.$$scope={dirty:a,ctx:t}),s.$set(f)},i(t){m||(w(s.$$.fragment,t),m=!0)},o(t){b(s.$$.fragment,t),m=!1},d(t){j(s,t)}}}function ar(k){let s,m=`Third, given that you’ve prepared your data in this TSV/CSV format (and corresponding CSV files containing the tabular data), you can then use <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a> to convert table-question pairs into <code>input_ids</code>, <code>attention_mask</code>, <code>token_type_ids</code> and so on. Again, based on which of the three cases you picked above, <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TFTapasForQuestionAnswering">TFTapasForQuestionAnswering</a> requires different
inputs to be fine-tuned:`,t,a,f="<thead><tr><th><strong>Task</strong></th> <th><strong>Required inputs</strong></th></tr></thead> <tbody><tr><td>Conversational</td> <td><code>input_ids</code>, <code>attention_mask</code>, <code>token_type_ids</code>, <code>labels</code></td></tr> <tr><td>Weak supervision for aggregation</td> <td><code>input_ids</code>, <code>attention_mask</code>, <code>token_type_ids</code>, <code>labels</code>, <code>numeric_values</code>, <code>numeric_values_scale</code>, <code>float_answer</code></td></tr> <tr><td>Strong supervision for aggregation</td> <td><code>input ids</code>, <code>attention mask</code>, <code>token type ids</code>, <code>labels</code>, <code>aggregation_labels</code></td></tr></tbody>",o,g,Z='<a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a> creates the <code>labels</code>, <code>numeric_values</code> and <code>numeric_values_scale</code> based on the <code>answer_coordinates</code> and <code>answer_text</code> columns of the TSV file. The <code>float_answer</code> and <code>aggregation_labels</code> are already in the TSV file of step 2. Here’s an example:',J,v,U,C,A=`Note that <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a> expects the data of the table to be <strong>text-only</strong>. You can use <code>.astype(str)</code> on a dataframe to turn it into text-only data.
Of course, this only shows how to encode a single training example. It is advised to create a dataloader to iterate over batches:`,W,M,F;return v=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRhcGFzVG9rZW5pemVyJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQW1vZGVsX25hbWUlMjAlM0QlMjAlMjJnb29nbGUlMkZ0YXBhcy1iYXNlJTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwVGFwYXNUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWUpJTBBJTBBZGF0YSUyMCUzRCUyMCU3QiUyMkFjdG9ycyUyMiUzQSUyMCU1QiUyMkJyYWQlMjBQaXR0JTIyJTJDJTIwJTIyTGVvbmFyZG8lMjBEaSUyMENhcHJpbyUyMiUyQyUyMCUyMkdlb3JnZSUyMENsb29uZXklMjIlNUQlMkMlMjAlMjJOdW1iZXIlMjBvZiUyMG1vdmllcyUyMiUzQSUyMCU1QiUyMjg3JTIyJTJDJTIwJTIyNTMlMjIlMkMlMjAlMjI2OSUyMiU1RCU3RCUwQXF1ZXJpZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBuYW1lJTIwb2YlMjB0aGUlMjBmaXJzdCUyMGFjdG9yJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIySG93JTIwbWFueSUyMG1vdmllcyUyMGhhcyUyMEdlb3JnZSUyMENsb29uZXklMjBwbGF5ZWQlMjBpbiUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMldoYXQlMjBpcyUyMHRoZSUyMHRvdGFsJTIwbnVtYmVyJTIwb2YlMjBtb3ZpZXMlM0YlMjIlMkMlMEElNUQlMEFhbnN3ZXJfY29vcmRpbmF0ZXMlMjAlM0QlMjAlNUIlNUIoMCUyQyUyMDApJTVEJTJDJTIwJTVCKDIlMkMlMjAxKSU1RCUyQyUyMCU1QigwJTJDJTIwMSklMkMlMjAoMSUyQyUyMDEpJTJDJTIwKDIlMkMlMjAxKSU1RCU1RCUwQWFuc3dlcl90ZXh0JTIwJTNEJTIwJTVCJTVCJTIyQnJhZCUyMFBpdHQlMjIlNUQlMkMlMjAlNUIlMjI2OSUyMiU1RCUyQyUyMCU1QiUyMjIwOSUyMiU1RCU1RCUwQXRhYmxlJTIwJTNEJTIwcGQuRGF0YUZyYW1lLmZyb21fZGljdChkYXRhKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjB0YWJsZSUzRHRhYmxlJTJDJTBBJTIwJTIwJTIwJTIwcXVlcmllcyUzRHF1ZXJpZXMlMkMlMEElMjAlMjAlMjAlMjBhbnN3ZXJfY29vcmRpbmF0ZXMlM0RhbnN3ZXJfY29vcmRpbmF0ZXMlMkMlMEElMjAlMjAlMjAlMjBhbnN3ZXJfdGV4dCUzRGFuc3dlcl90ZXh0JTJDJTBBJTIwJTIwJTIwJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyJTJDJTBBKSUwQWlucHV0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TapasTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>model_name = <span class="hljs-string">&quot;google/tapas-base&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = TapasTokenizer.from_pretrained(model_name)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {<span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>], <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>queries = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;What is the name of the first actor?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;How many movies has George Clooney played in?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;What is the total number of movies?&quot;</span>,
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>answer_coordinates = [[(<span class="hljs-number">0</span>, <span class="hljs-number">0</span>)], [(<span class="hljs-number">2</span>, <span class="hljs-number">1</span>)], [(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>), (<span class="hljs-number">1</span>, <span class="hljs-number">1</span>), (<span class="hljs-number">2</span>, <span class="hljs-number">1</span>)]]
<span class="hljs-meta">&gt;&gt;&gt; </span>answer_text = [[<span class="hljs-string">&quot;Brad Pitt&quot;</span>], [<span class="hljs-string">&quot;69&quot;</span>], [<span class="hljs-string">&quot;209&quot;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    table=table,
<span class="hljs-meta">... </span>    queries=queries,
<span class="hljs-meta">... </span>    answer_coordinates=answer_coordinates,
<span class="hljs-meta">... </span>    answer_text=answer_text,
<span class="hljs-meta">... </span>    padding=<span class="hljs-string">&quot;max_length&quot;</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;tf&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs
{<span class="hljs-string">&#x27;input_ids&#x27;</span>: tensor([[ ... ]]), <span class="hljs-string">&#x27;attention_mask&#x27;</span>: tensor([[...]]), <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: tensor([[[...]]]),
<span class="hljs-string">&#x27;numeric_values&#x27;</span>: tensor([[ ... ]]), <span class="hljs-string">&#x27;numeric_values_scale: tensor([[ ... ]]), labels: tensor([[ ... ]])}</span>`,wrap:!1}}),M=new R({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>tsv_path = <span class="hljs-string">&quot;your_path_to_the_tsv_file&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>table_csv_path = <span class="hljs-string">&quot;your_path_to_a_directory_containing_all_csv_files&quot;</span>


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">TableDataset</span>:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, data, tokenizer</span>):
<span class="hljs-meta">... </span>        self.data = data
<span class="hljs-meta">... </span>        self.tokenizer = tokenizer

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__iter__</span>(<span class="hljs-params">self</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(self.__len__()):
<span class="hljs-meta">... </span>            item = self.data.iloc[idx]
<span class="hljs-meta">... </span>            table = pd.read_csv(table_csv_path + item.table_file).astype(
<span class="hljs-meta">... </span>                <span class="hljs-built_in">str</span>
<span class="hljs-meta">... </span>            )  <span class="hljs-comment"># be sure to make your table data text only</span>
<span class="hljs-meta">... </span>            encoding = self.tokenizer(
<span class="hljs-meta">... </span>                table=table,
<span class="hljs-meta">... </span>                queries=item.question,
<span class="hljs-meta">... </span>                answer_coordinates=item.answer_coordinates,
<span class="hljs-meta">... </span>                answer_text=item.answer_text,
<span class="hljs-meta">... </span>                truncation=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>                padding=<span class="hljs-string">&quot;max_length&quot;</span>,
<span class="hljs-meta">... </span>                return_tensors=<span class="hljs-string">&quot;tf&quot;</span>,
<span class="hljs-meta">... </span>            )
<span class="hljs-meta">... </span>            <span class="hljs-comment"># remove the batch dimension which the tokenizer adds by default</span>
<span class="hljs-meta">... </span>            encoding = {key: tf.squeeze(val, <span class="hljs-number">0</span>) <span class="hljs-keyword">for</span> key, val <span class="hljs-keyword">in</span> encoding.items()}
<span class="hljs-meta">... </span>            <span class="hljs-comment"># add the float_answer which is also required (weak supervision for aggregation case)</span>
<span class="hljs-meta">... </span>            encoding[<span class="hljs-string">&quot;float_answer&quot;</span>] = tf.convert_to_tensor(item.float_answer, dtype=tf.float32)
<span class="hljs-meta">... </span>            <span class="hljs-keyword">yield</span> encoding[<span class="hljs-string">&quot;input_ids&quot;</span>], encoding[<span class="hljs-string">&quot;attention_mask&quot;</span>], encoding[<span class="hljs-string">&quot;numeric_values&quot;</span>], encoding[
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;numeric_values_scale&quot;</span>
<span class="hljs-meta">... </span>            ], encoding[<span class="hljs-string">&quot;token_type_ids&quot;</span>], encoding[<span class="hljs-string">&quot;labels&quot;</span>], encoding[<span class="hljs-string">&quot;float_answer&quot;</span>]

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__len__</span>(<span class="hljs-params">self</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> <span class="hljs-built_in">len</span>(self.data)


<span class="hljs-meta">&gt;&gt;&gt; </span>data = pd.read_csv(tsv_path, sep=<span class="hljs-string">&quot;\\t&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataset = TableDataset(data, tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>output_signature = (
<span class="hljs-meta">... </span>    tf.TensorSpec(shape=(<span class="hljs-number">512</span>,), dtype=tf.int32),
<span class="hljs-meta">... </span>    tf.TensorSpec(shape=(<span class="hljs-number">512</span>,), dtype=tf.int32),
<span class="hljs-meta">... </span>    tf.TensorSpec(shape=(<span class="hljs-number">512</span>,), dtype=tf.float32),
<span class="hljs-meta">... </span>    tf.TensorSpec(shape=(<span class="hljs-number">512</span>,), dtype=tf.float32),
<span class="hljs-meta">... </span>    tf.TensorSpec(shape=(<span class="hljs-number">512</span>, <span class="hljs-number">7</span>), dtype=tf.int32),
<span class="hljs-meta">... </span>    tf.TensorSpec(shape=(<span class="hljs-number">512</span>,), dtype=tf.int32),
<span class="hljs-meta">... </span>    tf.TensorSpec(shape=(<span class="hljs-number">512</span>,), dtype=tf.float32),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataloader = tf.data.Dataset.from_generator(train_dataset, output_signature=output_signature).batch(<span class="hljs-number">32</span>)`,wrap:!1}}),{c(){s=c("p"),s.innerHTML=m,t=r(),a=c("table"),a.innerHTML=f,o=r(),g=c("p"),g.innerHTML=Z,J=r(),T(v.$$.fragment),U=r(),C=c("p"),C.innerHTML=A,W=r(),T(M.$$.fragment)},l(I){s=p(I,"P",{"data-svelte-h":!0}),u(s)!=="svelte-1kqsosu"&&(s.innerHTML=m),t=i(I),a=p(I,"TABLE",{"data-svelte-h":!0}),u(a)!=="svelte-1f72bji"&&(a.innerHTML=f),o=i(I),g=p(I,"P",{"data-svelte-h":!0}),u(g)!=="svelte-1e8w5iu"&&(g.innerHTML=Z),J=i(I),y(v.$$.fragment,I),U=i(I),C=p(I,"P",{"data-svelte-h":!0}),u(C)!=="svelte-1yzoea5"&&(C.innerHTML=A),W=i(I),y(M.$$.fragment,I)},m(I,B){l(I,s,B),l(I,t,B),l(I,a,B),l(I,o,B),l(I,g,B),l(I,J,B),_(v,I,B),l(I,U,B),l(I,C,B),l(I,W,B),_(M,I,B),F=!0},p:$,i(I){F||(w(v.$$.fragment,I),w(M.$$.fragment,I),F=!0)},o(I){b(v.$$.fragment,I),b(M.$$.fragment,I),F=!1},d(I){I&&(n(s),n(t),n(a),n(o),n(g),n(J),n(U),n(C),n(W)),j(v,I),j(M,I)}}}function or(k){let s,m;return s=new ss({props:{$$slots:{default:[ar]},$$scope:{ctx:k}}}),{c(){T(s.$$.fragment)},l(t){y(s.$$.fragment,t)},m(t,a){_(s,t,a),m=!0},p(t,a){const f={};a&2&&(f.$$scope={dirty:a,ctx:t}),s.$set(f)},i(t){m||(w(s.$$.fragment,t),m=!0)},o(t){b(s.$$.fragment,t),m=!1},d(t){j(s,t)}}}function lr(k){let s,m='You can then fine-tune <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasForQuestionAnswering">TapasForQuestionAnswering</a> as follows (shown here for the weak supervision for aggregation case):',t,a,f;return a=new R({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TapasConfig, TapasForQuestionAnswering, AdamW

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># this is the default WTQ configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = TapasConfig(
<span class="hljs-meta">... </span>    num_aggregation_labels=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    use_answer_as_supervision=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    answer_loss_cutoff=<span class="hljs-number">0.664694</span>,
<span class="hljs-meta">... </span>    cell_selection_preference=<span class="hljs-number">0.207951</span>,
<span class="hljs-meta">... </span>    huber_loss_delta=<span class="hljs-number">0.121194</span>,
<span class="hljs-meta">... </span>    init_cell_selection_weights_to_zero=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    select_one_column=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    allow_empty_column_selection=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.0352513</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>, config=config)

<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">5e-5</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model.train()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">2</span>):  <span class="hljs-comment"># loop over the dataset multiple times</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
<span class="hljs-meta">... </span>        <span class="hljs-comment"># get the inputs;</span>
<span class="hljs-meta">... </span>        input_ids = batch[<span class="hljs-string">&quot;input_ids&quot;</span>]
<span class="hljs-meta">... </span>        attention_mask = batch[<span class="hljs-string">&quot;attention_mask&quot;</span>]
<span class="hljs-meta">... </span>        token_type_ids = batch[<span class="hljs-string">&quot;token_type_ids&quot;</span>]
<span class="hljs-meta">... </span>        labels = batch[<span class="hljs-string">&quot;labels&quot;</span>]
<span class="hljs-meta">... </span>        numeric_values = batch[<span class="hljs-string">&quot;numeric_values&quot;</span>]
<span class="hljs-meta">... </span>        numeric_values_scale = batch[<span class="hljs-string">&quot;numeric_values_scale&quot;</span>]
<span class="hljs-meta">... </span>        float_answer = batch[<span class="hljs-string">&quot;float_answer&quot;</span>]

<span class="hljs-meta">... </span>        <span class="hljs-comment"># zero the parameter gradients</span>
<span class="hljs-meta">... </span>        optimizer.zero_grad()

<span class="hljs-meta">... </span>        <span class="hljs-comment"># forward + backward + optimize</span>
<span class="hljs-meta">... </span>        outputs = model(
<span class="hljs-meta">... </span>            input_ids=input_ids,
<span class="hljs-meta">... </span>            attention_mask=attention_mask,
<span class="hljs-meta">... </span>            token_type_ids=token_type_ids,
<span class="hljs-meta">... </span>            labels=labels,
<span class="hljs-meta">... </span>            numeric_values=numeric_values,
<span class="hljs-meta">... </span>            numeric_values_scale=numeric_values_scale,
<span class="hljs-meta">... </span>            float_answer=float_answer,
<span class="hljs-meta">... </span>        )
<span class="hljs-meta">... </span>        loss = outputs.loss
<span class="hljs-meta">... </span>        loss.backward()
<span class="hljs-meta">... </span>        optimizer.step()`,wrap:!1}}),{c(){s=c("p"),s.innerHTML=m,t=r(),T(a.$$.fragment)},l(o){s=p(o,"P",{"data-svelte-h":!0}),u(s)!=="svelte-1t925kl"&&(s.innerHTML=m),t=i(o),y(a.$$.fragment,o)},m(o,g){l(o,s,g),l(o,t,g),_(a,o,g),f=!0},p:$,i(o){f||(w(a.$$.fragment,o),f=!0)},o(o){b(a.$$.fragment,o),f=!1},d(o){o&&(n(s),n(t)),j(a,o)}}}function rr(k){let s,m;return s=new ss({props:{$$slots:{default:[lr]},$$scope:{ctx:k}}}),{c(){T(s.$$.fragment)},l(t){y(s.$$.fragment,t)},m(t,a){_(s,t,a),m=!0},p(t,a){const f={};a&2&&(f.$$scope={dirty:a,ctx:t}),s.$set(f)},i(t){m||(w(s.$$.fragment,t),m=!0)},o(t){b(s.$$.fragment,t),m=!1},d(t){j(s,t)}}}function ir(k){let s,m='You can then fine-tune <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TFTapasForQuestionAnswering">TFTapasForQuestionAnswering</a> as follows (shown here for the weak supervision for aggregation case):',t,a,f;return a=new R({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TapasConfig, TFTapasForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># this is the default WTQ configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = TapasConfig(
<span class="hljs-meta">... </span>    num_aggregation_labels=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    use_answer_as_supervision=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    answer_loss_cutoff=<span class="hljs-number">0.664694</span>,
<span class="hljs-meta">... </span>    cell_selection_preference=<span class="hljs-number">0.207951</span>,
<span class="hljs-meta">... </span>    huber_loss_delta=<span class="hljs-number">0.121194</span>,
<span class="hljs-meta">... </span>    init_cell_selection_weights_to_zero=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    select_one_column=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    allow_empty_column_selection=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.0352513</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFTapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>, config=config)

<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = tf.keras.optimizers.Adam(learning_rate=<span class="hljs-number">5e-5</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">2</span>):  <span class="hljs-comment"># loop over the dataset multiple times</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
<span class="hljs-meta">... </span>        <span class="hljs-comment"># get the inputs;</span>
<span class="hljs-meta">... </span>        input_ids = batch[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>        attention_mask = batch[<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>        token_type_ids = batch[<span class="hljs-number">4</span>]
<span class="hljs-meta">... </span>        labels = batch[-<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>        numeric_values = batch[<span class="hljs-number">2</span>]
<span class="hljs-meta">... </span>        numeric_values_scale = batch[<span class="hljs-number">3</span>]
<span class="hljs-meta">... </span>        float_answer = batch[<span class="hljs-number">6</span>]

<span class="hljs-meta">... </span>        <span class="hljs-comment"># forward + backward + optimize</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">with</span> tf.GradientTape() <span class="hljs-keyword">as</span> tape:
<span class="hljs-meta">... </span>            outputs = model(
<span class="hljs-meta">... </span>                input_ids=input_ids,
<span class="hljs-meta">... </span>                attention_mask=attention_mask,
<span class="hljs-meta">... </span>                token_type_ids=token_type_ids,
<span class="hljs-meta">... </span>                labels=labels,
<span class="hljs-meta">... </span>                numeric_values=numeric_values,
<span class="hljs-meta">... </span>                numeric_values_scale=numeric_values_scale,
<span class="hljs-meta">... </span>                float_answer=float_answer,
<span class="hljs-meta">... </span>            )
<span class="hljs-meta">... </span>        grads = tape.gradient(outputs.loss, model.trainable_weights)
<span class="hljs-meta">... </span>        optimizer.apply_gradients(<span class="hljs-built_in">zip</span>(grads, model.trainable_weights))`,wrap:!1}}),{c(){s=c("p"),s.innerHTML=m,t=r(),T(a.$$.fragment)},l(o){s=p(o,"P",{"data-svelte-h":!0}),u(s)!=="svelte-1em5oel"&&(s.innerHTML=m),t=i(o),y(a.$$.fragment,o)},m(o,g){l(o,s,g),l(o,t,g),_(a,o,g),f=!0},p:$,i(o){f||(w(a.$$.fragment,o),f=!0)},o(o){b(a.$$.fragment,o),f=!1},d(o){o&&(n(s),n(t)),j(a,o)}}}function dr(k){let s,m;return s=new ss({props:{$$slots:{default:[ir]},$$scope:{ctx:k}}}),{c(){T(s.$$.fragment)},l(t){y(s.$$.fragment,t)},m(t,a){_(s,t,a),m=!0},p(t,a){const f={};a&2&&(f.$$scope={dirty:a,ctx:t}),s.$set(f)},i(t){m||(w(s.$$.fragment,t),m=!0)},o(t){b(s.$$.fragment,t),m=!1},d(t){j(s,t)}}}function cr(k){let s,m='Here we explain how you can use <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasForQuestionAnswering">TapasForQuestionAnswering</a> or <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TFTapasForQuestionAnswering">TFTapasForQuestionAnswering</a> for inference (i.e. making predictions on new data). For inference, only <code>input_ids</code>, <code>attention_mask</code> and <code>token_type_ids</code> (which you can obtain using <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a>) have to be provided to the model to obtain the logits. Next, you can use the handy <code>~models.tapas.tokenization_tapas.convert_logits_to_predictions</code> method to convert these into predicted coordinates and optional aggregation indices.',t,a,f="However, note that inference is <strong>different</strong> depending on whether or not the setup is conversational. In a non-conversational set-up, inference can be done in parallel on all table-question pairs of a batch. Here’s an example of that:",o,g,Z;return g=new R({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TapasTokenizer, TapasForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>model_name = <span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForQuestionAnswering.from_pretrained(model_name)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = TapasTokenizer.from_pretrained(model_name)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {<span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>], <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>queries = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;What is the name of the first actor?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;How many movies has George Clooney played in?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;What is the total number of movies?&quot;</span>,
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(table=table, queries=queries, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_answer_coordinates, predicted_aggregation_indices = tokenizer.convert_logits_to_predictions(
<span class="hljs-meta">... </span>    inputs, outputs.logits.detach(), outputs.logits_aggregation.detach()
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># let&#x27;s print out the results:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>id2aggregation = {<span class="hljs-number">0</span>: <span class="hljs-string">&quot;NONE&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;SUM&quot;</span>, <span class="hljs-number">2</span>: <span class="hljs-string">&quot;AVERAGE&quot;</span>, <span class="hljs-number">3</span>: <span class="hljs-string">&quot;COUNT&quot;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>aggregation_predictions_string = [id2aggregation[x] <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> predicted_aggregation_indices]

<span class="hljs-meta">&gt;&gt;&gt; </span>answers = []
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> coordinates <span class="hljs-keyword">in</span> predicted_answer_coordinates:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(coordinates) == <span class="hljs-number">1</span>:
<span class="hljs-meta">... </span>        <span class="hljs-comment"># only a single cell:</span>
<span class="hljs-meta">... </span>        answers.append(table.iat[coordinates[<span class="hljs-number">0</span>]])
<span class="hljs-meta">... </span>    <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>        <span class="hljs-comment"># multiple cells</span>
<span class="hljs-meta">... </span>        cell_values = []
<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> coordinate <span class="hljs-keyword">in</span> coordinates:
<span class="hljs-meta">... </span>            cell_values.append(table.iat[coordinate])
<span class="hljs-meta">... </span>        answers.append(<span class="hljs-string">&quot;, &quot;</span>.join(cell_values))

<span class="hljs-meta">&gt;&gt;&gt; </span>display(table)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> query, answer, predicted_agg <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(queries, answers, aggregation_predictions_string):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(query)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> predicted_agg == <span class="hljs-string">&quot;NONE&quot;</span>:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted answer: &quot;</span> + answer)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted answer: &quot;</span> + predicted_agg + <span class="hljs-string">&quot; &gt; &quot;</span> + answer)
What <span class="hljs-keyword">is</span> the name of the first actor?
Predicted answer: Brad Pitt
How many movies has George Clooney played <span class="hljs-keyword">in</span>?
Predicted answer: COUNT &gt; <span class="hljs-number">69</span>
What <span class="hljs-keyword">is</span> the total number of movies?
Predicted answer: SUM &gt; <span class="hljs-number">87</span>, <span class="hljs-number">53</span>, <span class="hljs-number">69</span>`,wrap:!1}}),{c(){s=c("p"),s.innerHTML=m,t=r(),a=c("p"),a.innerHTML=f,o=r(),T(g.$$.fragment)},l(J){s=p(J,"P",{"data-svelte-h":!0}),u(s)!=="svelte-1wqsjj2"&&(s.innerHTML=m),t=i(J),a=p(J,"P",{"data-svelte-h":!0}),u(a)!=="svelte-1xx2q6p"&&(a.innerHTML=f),o=i(J),y(g.$$.fragment,J)},m(J,v){l(J,s,v),l(J,t,v),l(J,a,v),l(J,o,v),_(g,J,v),Z=!0},p:$,i(J){Z||(w(g.$$.fragment,J),Z=!0)},o(J){b(g.$$.fragment,J),Z=!1},d(J){J&&(n(s),n(t),n(a),n(o)),j(g,J)}}}function pr(k){let s,m;return s=new ss({props:{$$slots:{default:[cr]},$$scope:{ctx:k}}}),{c(){T(s.$$.fragment)},l(t){y(s.$$.fragment,t)},m(t,a){_(s,t,a),m=!0},p(t,a){const f={};a&2&&(f.$$scope={dirty:a,ctx:t}),s.$set(f)},i(t){m||(w(s.$$.fragment,t),m=!0)},o(t){b(s.$$.fragment,t),m=!1},d(t){j(s,t)}}}function mr(k){let s,m='Here we explain how you can use <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TFTapasForQuestionAnswering">TFTapasForQuestionAnswering</a> for inference (i.e. making predictions on new data). For inference, only <code>input_ids</code>, <code>attention_mask</code> and <code>token_type_ids</code> (which you can obtain using <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a>) have to be provided to the model to obtain the logits. Next, you can use the handy <code>~models.tapas.tokenization_tapas.convert_logits_to_predictions</code> method to convert these into predicted coordinates and optional aggregation indices.',t,a,f="However, note that inference is <strong>different</strong> depending on whether or not the setup is conversational. In a non-conversational set-up, inference can be done in parallel on all table-question pairs of a batch. Here’s an example of that:",o,g,Z;return g=new R({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TapasTokenizer, TFTapasForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>model_name = <span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFTapasForQuestionAnswering.from_pretrained(model_name)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = TapasTokenizer.from_pretrained(model_name)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {<span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>], <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>queries = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;What is the name of the first actor?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;How many movies has George Clooney played in?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;What is the total number of movies?&quot;</span>,
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(table=table, queries=queries, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_answer_coordinates, predicted_aggregation_indices = tokenizer.convert_logits_to_predictions(
<span class="hljs-meta">... </span>    inputs, outputs.logits, outputs.logits_aggregation
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># let&#x27;s print out the results:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>id2aggregation = {<span class="hljs-number">0</span>: <span class="hljs-string">&quot;NONE&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;SUM&quot;</span>, <span class="hljs-number">2</span>: <span class="hljs-string">&quot;AVERAGE&quot;</span>, <span class="hljs-number">3</span>: <span class="hljs-string">&quot;COUNT&quot;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>aggregation_predictions_string = [id2aggregation[x] <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> predicted_aggregation_indices]

<span class="hljs-meta">&gt;&gt;&gt; </span>answers = []
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> coordinates <span class="hljs-keyword">in</span> predicted_answer_coordinates:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(coordinates) == <span class="hljs-number">1</span>:
<span class="hljs-meta">... </span>        <span class="hljs-comment"># only a single cell:</span>
<span class="hljs-meta">... </span>        answers.append(table.iat[coordinates[<span class="hljs-number">0</span>]])
<span class="hljs-meta">... </span>    <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>        <span class="hljs-comment"># multiple cells</span>
<span class="hljs-meta">... </span>        cell_values = []
<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> coordinate <span class="hljs-keyword">in</span> coordinates:
<span class="hljs-meta">... </span>            cell_values.append(table.iat[coordinate])
<span class="hljs-meta">... </span>        answers.append(<span class="hljs-string">&quot;, &quot;</span>.join(cell_values))

<span class="hljs-meta">&gt;&gt;&gt; </span>display(table)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> query, answer, predicted_agg <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(queries, answers, aggregation_predictions_string):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(query)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> predicted_agg == <span class="hljs-string">&quot;NONE&quot;</span>:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted answer: &quot;</span> + answer)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted answer: &quot;</span> + predicted_agg + <span class="hljs-string">&quot; &gt; &quot;</span> + answer)
What <span class="hljs-keyword">is</span> the name of the first actor?
Predicted answer: Brad Pitt
How many movies has George Clooney played <span class="hljs-keyword">in</span>?
Predicted answer: COUNT &gt; <span class="hljs-number">69</span>
What <span class="hljs-keyword">is</span> the total number of movies?
Predicted answer: SUM &gt; <span class="hljs-number">87</span>, <span class="hljs-number">53</span>, <span class="hljs-number">69</span>`,wrap:!1}}),{c(){s=c("p"),s.innerHTML=m,t=r(),a=c("p"),a.innerHTML=f,o=r(),T(g.$$.fragment)},l(J){s=p(J,"P",{"data-svelte-h":!0}),u(s)!=="svelte-l3ew9v"&&(s.innerHTML=m),t=i(J),a=p(J,"P",{"data-svelte-h":!0}),u(a)!=="svelte-1xx2q6p"&&(a.innerHTML=f),o=i(J),y(g.$$.fragment,J)},m(J,v){l(J,s,v),l(J,t,v),l(J,a,v),l(J,o,v),_(g,J,v),Z=!0},p:$,i(J){Z||(w(g.$$.fragment,J),Z=!0)},o(J){b(g.$$.fragment,J),Z=!1},d(J){J&&(n(s),n(t),n(a),n(o)),j(g,J)}}}function hr(k){let s,m;return s=new ss({props:{$$slots:{default:[mr]},$$scope:{ctx:k}}}),{c(){T(s.$$.fragment)},l(t){y(s.$$.fragment,t)},m(t,a){_(s,t,a),m=!0},p(t,a){const f={};a&2&&(f.$$scope={dirty:a,ctx:t}),s.$set(f)},i(t){m||(w(s.$$.fragment,t),m=!0)},o(t){b(s.$$.fragment,t),m=!1},d(t){j(s,t)}}}function ur(k){let s,m="Example:",t,a,f;return a=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRhcGFzTW9kZWwlMkMlMjBUYXBhc0NvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBkZWZhdWx0JTIwKFNRQSklMjBUYXBhcyUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwVGFwYXNDb25maWcoKSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBUYXBhc01vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TapasModel, TapasConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a default (SQA) Tapas configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = TapasConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasModel(configuration)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){s=c("p"),s.textContent=m,t=r(),T(a.$$.fragment)},l(o){s=p(o,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11lpom8"&&(s.textContent=m),t=i(o),y(a.$$.fragment,o)},m(o,g){l(o,s,g),l(o,t,g),_(a,o,g),f=!0},p:$,i(o){f||(w(a.$$.fragment,o),f=!0)},o(o){b(a.$$.fragment,o),f=!1},d(o){o&&(n(s),n(t)),j(a,o)}}}function gr(k){let s,m=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=c("p"),s.innerHTML=m},l(t){s=p(t,"P",{"data-svelte-h":!0}),u(s)!=="svelte-fincs2"&&(s.innerHTML=m)},m(t,a){l(t,s,a)},p:$,d(t){t&&n(s)}}}function fr(k){let s,m="Examples:",t,a,f;return a=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBUYXBhc01vZGVsJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBUYXBhc01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlJTIyKSUwQSUwQWRhdGElMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJBY3RvcnMlMjIlM0ElMjAlNUIlMjJCcmFkJTIwUGl0dCUyMiUyQyUyMCUyMkxlb25hcmRvJTIwRGklMjBDYXByaW8lMjIlMkMlMjAlMjJHZW9yZ2UlMjBDbG9vbmV5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyQWdlJTIyJTNBJTIwJTVCJTIyNTYlMjIlMkMlMjAlMjI0NSUyMiUyQyUyMCUyMjU5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyTnVtYmVyJTIwb2YlMjBtb3ZpZXMlMjIlM0ElMjAlNUIlMjI4NyUyMiUyQyUyMCUyMjUzJTIyJTJDJTIwJTIyNjklMjIlNUQlMkMlMEElN0QlMEF0YWJsZSUyMCUzRCUyMHBkLkRhdGFGcmFtZS5mcm9tX2RpY3QoZGF0YSklMEFxdWVyaWVzJTIwJTNEJTIwJTVCJTIySG93JTIwbWFueSUyMG1vdmllcyUyMGhhcyUyMEdlb3JnZSUyMENsb29uZXklMjBwbGF5ZWQlMjBpbiUzRiUyMiUyQyUyMCUyMkhvdyUyMG9sZCUyMGlzJTIwQnJhZCUyMFBpdHQlM0YlMjIlNUQlMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIodGFibGUlM0R0YWJsZSUyQyUyMHF1ZXJpZXMlM0RxdWVyaWVzJTJDJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TapasModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasModel.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Age&quot;</span>: [<span class="hljs-string">&quot;56&quot;</span>, <span class="hljs-string">&quot;45&quot;</span>, <span class="hljs-string">&quot;59&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>queries = [<span class="hljs-string">&quot;How many movies has George Clooney played in?&quot;</span>, <span class="hljs-string">&quot;How old is Brad Pitt?&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(table=table, queries=queries, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){s=c("p"),s.textContent=m,t=r(),T(a.$$.fragment)},l(o){s=p(o,"P",{"data-svelte-h":!0}),u(s)!=="svelte-kvfsh7"&&(s.textContent=m),t=i(o),y(a.$$.fragment,o)},m(o,g){l(o,s,g),l(o,t,g),_(a,o,g),f=!0},p:$,i(o){f||(w(a.$$.fragment,o),f=!0)},o(o){b(a.$$.fragment,o),f=!1},d(o){o&&(n(s),n(t)),j(a,o)}}}function Mr(k){let s,m=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=c("p"),s.innerHTML=m},l(t){s=p(t,"P",{"data-svelte-h":!0}),u(s)!=="svelte-fincs2"&&(s.innerHTML=m)},m(t,a){l(t,s,a)},p:$,d(t){t&&n(s)}}}function Tr(k){let s,m="Examples:",t,a,f;return a=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBUYXBhc0Zvck1hc2tlZExNJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBUYXBhc0Zvck1hc2tlZExNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlJTIyKSUwQSUwQWRhdGElMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJBY3RvcnMlMjIlM0ElMjAlNUIlMjJCcmFkJTIwUGl0dCUyMiUyQyUyMCUyMkxlb25hcmRvJTIwRGklMjBDYXByaW8lMjIlMkMlMjAlMjJHZW9yZ2UlMjBDbG9vbmV5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyQWdlJTIyJTNBJTIwJTVCJTIyNTYlMjIlMkMlMjAlMjI0NSUyMiUyQyUyMCUyMjU5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyTnVtYmVyJTIwb2YlMjBtb3ZpZXMlMjIlM0ElMjAlNUIlMjI4NyUyMiUyQyUyMCUyMjUzJTIyJTJDJTIwJTIyNjklMjIlNUQlMkMlMEElN0QlMEF0YWJsZSUyMCUzRCUyMHBkLkRhdGFGcmFtZS5mcm9tX2RpY3QoZGF0YSklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwdGFibGUlM0R0YWJsZSUyQyUyMHF1ZXJpZXMlM0QlMjJIb3clMjBtYW55JTIwJTVCTUFTSyU1RCUyMGhhcyUyMEdlb3JnZSUyMCU1Qk1BU0slNUQlMjBwbGF5ZWQlMjBpbiUzRiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpJTBBbGFiZWxzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMHRhYmxlJTNEdGFibGUlMkMlMjBxdWVyaWVzJTNEJTIySG93JTIwbWFueSUyMG1vdmllcyUyMGhhcyUyMEdlb3JnZSUyMENsb29uZXklMjBwbGF5ZWQlMjBpbiUzRiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwbGFiZWxzJTNEbGFiZWxzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TapasForMaskedLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForMaskedLM.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Age&quot;</span>: [<span class="hljs-string">&quot;56&quot;</span>, <span class="hljs-string">&quot;45&quot;</span>, <span class="hljs-string">&quot;59&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    table=table, queries=<span class="hljs-string">&quot;How many [MASK] has George [MASK] played in?&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(
<span class="hljs-meta">... </span>    table=table, queries=<span class="hljs-string">&quot;How many movies has George Clooney played in?&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){s=c("p"),s.textContent=m,t=r(),T(a.$$.fragment)},l(o){s=p(o,"P",{"data-svelte-h":!0}),u(s)!=="svelte-kvfsh7"&&(s.textContent=m),t=i(o),y(a.$$.fragment,o)},m(o,g){l(o,s,g),l(o,t,g),_(a,o,g),f=!0},p:$,i(o){f||(w(a.$$.fragment,o),f=!0)},o(o){b(a.$$.fragment,o),f=!1},d(o){o&&(n(s),n(t)),j(a,o)}}}function yr(k){let s,m=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=c("p"),s.innerHTML=m},l(t){s=p(t,"P",{"data-svelte-h":!0}),u(s)!=="svelte-fincs2"&&(s.innerHTML=m)},m(t,a){l(t,s,a)},p:$,d(t){t&&n(s)}}}function _r(k){let s,m="Examples:",t,a,f;return a=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBUYXBhc0ZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFpbXBvcnQlMjB0b3JjaCUwQWltcG9ydCUyMHBhbmRhcyUyMGFzJTIwcGQlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlLWZpbmV0dW5lZC10YWJmYWN0JTIyKSUwQW1vZGVsJTIwJTNEJTIwVGFwYXNGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlLWZpbmV0dW5lZC10YWJmYWN0JTIyKSUwQSUwQWRhdGElMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJBY3RvcnMlMjIlM0ElMjAlNUIlMjJCcmFkJTIwUGl0dCUyMiUyQyUyMCUyMkxlb25hcmRvJTIwRGklMjBDYXByaW8lMjIlMkMlMjAlMjJHZW9yZ2UlMjBDbG9vbmV5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyQWdlJTIyJTNBJTIwJTVCJTIyNTYlMjIlMkMlMjAlMjI0NSUyMiUyQyUyMCUyMjU5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyTnVtYmVyJTIwb2YlMjBtb3ZpZXMlMjIlM0ElMjAlNUIlMjI4NyUyMiUyQyUyMCUyMjUzJTIyJTJDJTIwJTIyNjklMjIlNUQlMkMlMEElN0QlMEF0YWJsZSUyMCUzRCUyMHBkLkRhdGFGcmFtZS5mcm9tX2RpY3QoZGF0YSklMEFxdWVyaWVzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyVGhlcmUlMjBpcyUyMG9ubHklMjBvbmUlMjBhY3RvciUyMHdobyUyMGlzJTIwNDUlMjB5ZWFycyUyMG9sZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlRoZXJlJTIwYXJlJTIwMyUyMGFjdG9ycyUyMHdoaWNoJTIwcGxheWVkJTIwaW4lMjBtb3JlJTIwdGhhbiUyMDYwJTIwbW92aWVzJTIyJTJDJTBBJTVEJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRhYmxlJTNEdGFibGUlMkMlMjBxdWVyaWVzJTNEcXVlcmllcyUyQyUyMHBhZGRpbmclM0QlMjJtYXhfbGVuZ3RoJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFsYWJlbHMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCMSUyQyUyMDAlNUQpJTIwJTIwJTIzJTIwMSUyMG1lYW5zJTIwZW50YWlsZWQlMkMlMjAwJTIwbWVhbnMlMjByZWZ1dGVkJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwbGFiZWxzJTNEbGFiZWxzKSUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TapasForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-tabfact&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-tabfact&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Age&quot;</span>: [<span class="hljs-string">&quot;56&quot;</span>, <span class="hljs-string">&quot;45&quot;</span>, <span class="hljs-string">&quot;59&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>queries = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;There is only one actor who is 45 years old&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;There are 3 actors which played in more than 60 movies&quot;</span>,
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(table=table, queries=queries, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>, <span class="hljs-number">0</span>])  <span class="hljs-comment"># 1 means entailed, 0 means refuted</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){s=c("p"),s.textContent=m,t=r(),T(a.$$.fragment)},l(o){s=p(o,"P",{"data-svelte-h":!0}),u(s)!=="svelte-kvfsh7"&&(s.textContent=m),t=i(o),y(a.$$.fragment,o)},m(o,g){l(o,s,g),l(o,t,g),_(a,o,g),f=!0},p:$,i(o){f||(w(a.$$.fragment,o),f=!0)},o(o){b(a.$$.fragment,o),f=!1},d(o){o&&(n(s),n(t)),j(a,o)}}}function wr(k){let s,m=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=c("p"),s.innerHTML=m},l(t){s=p(t,"P",{"data-svelte-h":!0}),u(s)!=="svelte-fincs2"&&(s.innerHTML=m)},m(t,a){l(t,s,a)},p:$,d(t){t&&n(s)}}}function br(k){let s,m="Examples:",t,a,f;return a=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBUYXBhc0ZvclF1ZXN0aW9uQW5zd2VyaW5nJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMiklMEFtb2RlbCUyMCUzRCUyMFRhcGFzRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMiklMEElMEFkYXRhJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyQWN0b3JzJTIyJTNBJTIwJTVCJTIyQnJhZCUyMFBpdHQlMjIlMkMlMjAlMjJMZW9uYXJkbyUyMERpJTIwQ2FwcmlvJTIyJTJDJTIwJTIyR2VvcmdlJTIwQ2xvb25leSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMkFnZSUyMiUzQSUyMCU1QiUyMjU2JTIyJTJDJTIwJTIyNDUlMjIlMkMlMjAlMjI1OSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMk51bWJlciUyMG9mJTIwbW92aWVzJTIyJTNBJTIwJTVCJTIyODclMjIlMkMlMjAlMjI1MyUyMiUyQyUyMCUyMjY5JTIyJTVEJTJDJTBBJTdEJTBBdGFibGUlMjAlM0QlMjBwZC5EYXRhRnJhbWUuZnJvbV9kaWN0KGRhdGEpJTBBcXVlcmllcyUyMCUzRCUyMCU1QiUyMkhvdyUyMG1hbnklMjBtb3ZpZXMlMjBoYXMlMjBHZW9yZ2UlMjBDbG9vbmV5JTIwcGxheWVkJTIwaW4lM0YlMjIlMkMlMjAlMjJIb3clMjBvbGQlMjBpcyUyMEJyYWQlMjBQaXR0JTNGJTIyJTVEJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRhYmxlJTNEdGFibGUlMkMlMjBxdWVyaWVzJTNEcXVlcmllcyUyQyUyMHBhZGRpbmclM0QlMjJtYXhfbGVuZ3RoJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEFsb2dpdHNfYWdncmVnYXRpb24lMjAlM0QlMjBvdXRwdXRzLmxvZ2l0c19hZ2dyZWdhdGlvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TapasForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Age&quot;</span>: [<span class="hljs-string">&quot;56&quot;</span>, <span class="hljs-string">&quot;45&quot;</span>, <span class="hljs-string">&quot;59&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>queries = [<span class="hljs-string">&quot;How many movies has George Clooney played in?&quot;</span>, <span class="hljs-string">&quot;How old is Brad Pitt?&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(table=table, queries=queries, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_aggregation = outputs.logits_aggregation`,wrap:!1}}),{c(){s=c("p"),s.textContent=m,t=r(),T(a.$$.fragment)},l(o){s=p(o,"P",{"data-svelte-h":!0}),u(s)!=="svelte-kvfsh7"&&(s.textContent=m),t=i(o),y(a.$$.fragment,o)},m(o,g){l(o,s,g),l(o,t,g),_(a,o,g),f=!0},p:$,i(o){f||(w(a.$$.fragment,o),f=!0)},o(o){b(a.$$.fragment,o),f=!1},d(o){o&&(n(s),n(t)),j(a,o)}}}function jr(k){let s,m="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",t,a,f="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",o,g,Z=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,J,v,U=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,C,A,W=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){s=c("p"),s.innerHTML=m,t=r(),a=c("ul"),a.innerHTML=f,o=r(),g=c("p"),g.innerHTML=Z,J=r(),v=c("ul"),v.innerHTML=U,C=r(),A=c("p"),A.innerHTML=W},l(M){s=p(M,"P",{"data-svelte-h":!0}),u(s)!=="svelte-1ajbfxg"&&(s.innerHTML=m),t=i(M),a=p(M,"UL",{"data-svelte-h":!0}),u(a)!=="svelte-qm1t26"&&(a.innerHTML=f),o=i(M),g=p(M,"P",{"data-svelte-h":!0}),u(g)!=="svelte-1v9qsc5"&&(g.innerHTML=Z),J=i(M),v=p(M,"UL",{"data-svelte-h":!0}),u(v)!=="svelte-15scerc"&&(v.innerHTML=U),C=i(M),A=p(M,"P",{"data-svelte-h":!0}),u(A)!=="svelte-1an3odd"&&(A.innerHTML=W)},m(M,F){l(M,s,F),l(M,t,F),l(M,a,F),l(M,o,F),l(M,g,F),l(M,J,F),l(M,v,F),l(M,C,F),l(M,A,F)},p:$,d(M){M&&(n(s),n(t),n(a),n(o),n(g),n(J),n(v),n(C),n(A))}}}function Jr(k){let s,m=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=c("p"),s.innerHTML=m},l(t){s=p(t,"P",{"data-svelte-h":!0}),u(s)!=="svelte-fincs2"&&(s.innerHTML=m)},m(t,a){l(t,s,a)},p:$,d(t){t&&n(s)}}}function Ur(k){let s,m="Examples:",t,a,f;return a=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBUYXBhc01vZGVsJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBUYXBhc01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlJTIyKSUwQSUwQWRhdGElMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJBY3RvcnMlMjIlM0ElMjAlNUIlMjJCcmFkJTIwUGl0dCUyMiUyQyUyMCUyMkxlb25hcmRvJTIwRGklMjBDYXByaW8lMjIlMkMlMjAlMjJHZW9yZ2UlMjBDbG9vbmV5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyQWdlJTIyJTNBJTIwJTVCJTIyNTYlMjIlMkMlMjAlMjI0NSUyMiUyQyUyMCUyMjU5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyTnVtYmVyJTIwb2YlMjBtb3ZpZXMlMjIlM0ElMjAlNUIlMjI4NyUyMiUyQyUyMCUyMjUzJTIyJTJDJTIwJTIyNjklMjIlNUQlMkMlMEElN0QlMEF0YWJsZSUyMCUzRCUyMHBkLkRhdGFGcmFtZS5mcm9tX2RpY3QoZGF0YSklMEFxdWVyaWVzJTIwJTNEJTIwJTVCJTIySG93JTIwbWFueSUyMG1vdmllcyUyMGhhcyUyMEdlb3JnZSUyMENsb29uZXklMjBwbGF5ZWQlMjBpbiUzRiUyMiUyQyUyMCUyMkhvdyUyMG9sZCUyMGlzJTIwQnJhZCUyMFBpdHQlM0YlMjIlNUQlMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIodGFibGUlM0R0YWJsZSUyQyUyMHF1ZXJpZXMlM0RxdWVyaWVzJTJDJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TapasModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasModel.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Age&quot;</span>: [<span class="hljs-string">&quot;56&quot;</span>, <span class="hljs-string">&quot;45&quot;</span>, <span class="hljs-string">&quot;59&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>queries = [<span class="hljs-string">&quot;How many movies has George Clooney played in?&quot;</span>, <span class="hljs-string">&quot;How old is Brad Pitt?&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(table=table, queries=queries, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){s=c("p"),s.textContent=m,t=r(),T(a.$$.fragment)},l(o){s=p(o,"P",{"data-svelte-h":!0}),u(s)!=="svelte-kvfsh7"&&(s.textContent=m),t=i(o),y(a.$$.fragment,o)},m(o,g){l(o,s,g),l(o,t,g),_(a,o,g),f=!0},p:$,i(o){f||(w(a.$$.fragment,o),f=!0)},o(o){b(a.$$.fragment,o),f=!1},d(o){o&&(n(s),n(t)),j(a,o)}}}function kr(k){let s,m="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",t,a,f="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",o,g,Z=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,J,v,U=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,C,A,W=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){s=c("p"),s.innerHTML=m,t=r(),a=c("ul"),a.innerHTML=f,o=r(),g=c("p"),g.innerHTML=Z,J=r(),v=c("ul"),v.innerHTML=U,C=r(),A=c("p"),A.innerHTML=W},l(M){s=p(M,"P",{"data-svelte-h":!0}),u(s)!=="svelte-1ajbfxg"&&(s.innerHTML=m),t=i(M),a=p(M,"UL",{"data-svelte-h":!0}),u(a)!=="svelte-qm1t26"&&(a.innerHTML=f),o=i(M),g=p(M,"P",{"data-svelte-h":!0}),u(g)!=="svelte-1v9qsc5"&&(g.innerHTML=Z),J=i(M),v=p(M,"UL",{"data-svelte-h":!0}),u(v)!=="svelte-15scerc"&&(v.innerHTML=U),C=i(M),A=p(M,"P",{"data-svelte-h":!0}),u(A)!=="svelte-1an3odd"&&(A.innerHTML=W)},m(M,F){l(M,s,F),l(M,t,F),l(M,a,F),l(M,o,F),l(M,g,F),l(M,J,F),l(M,v,F),l(M,C,F),l(M,A,F)},p:$,d(M){M&&(n(s),n(t),n(a),n(o),n(g),n(J),n(v),n(C),n(A))}}}function vr(k){let s,m=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=c("p"),s.innerHTML=m},l(t){s=p(t,"P",{"data-svelte-h":!0}),u(s)!=="svelte-fincs2"&&(s.innerHTML=m)},m(t,a){l(t,s,a)},p:$,d(t){t&&n(s)}}}function Ir(k){let s,m="Examples:",t,a,f;return a=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBUYXBhc0Zvck1hc2tlZExNJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBUYXBhc0Zvck1hc2tlZExNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlJTIyKSUwQSUwQWRhdGElMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJBY3RvcnMlMjIlM0ElMjAlNUIlMjJCcmFkJTIwUGl0dCUyMiUyQyUyMCUyMkxlb25hcmRvJTIwRGklMjBDYXByaW8lMjIlMkMlMjAlMjJHZW9yZ2UlMjBDbG9vbmV5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyQWdlJTIyJTNBJTIwJTVCJTIyNTYlMjIlMkMlMjAlMjI0NSUyMiUyQyUyMCUyMjU5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyTnVtYmVyJTIwb2YlMjBtb3ZpZXMlMjIlM0ElMjAlNUIlMjI4NyUyMiUyQyUyMCUyMjUzJTIyJTJDJTIwJTIyNjklMjIlNUQlMkMlMEElN0QlMEF0YWJsZSUyMCUzRCUyMHBkLkRhdGFGcmFtZS5mcm9tX2RpY3QoZGF0YSklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwdGFibGUlM0R0YWJsZSUyQyUyMHF1ZXJpZXMlM0QlMjJIb3clMjBtYW55JTIwJTVCTUFTSyU1RCUyMGhhcyUyMEdlb3JnZSUyMCU1Qk1BU0slNUQlMjBwbGF5ZWQlMjBpbiUzRiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIlMEEpJTBBbGFiZWxzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMHRhYmxlJTNEdGFibGUlMkMlMjBxdWVyaWVzJTNEJTIySG93JTIwbWFueSUyMG1vdmllcyUyMGhhcyUyMEdlb3JnZSUyMENsb29uZXklMjBwbGF5ZWQlMjBpbiUzRiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIlMEEpJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwbGFiZWxzJTNEbGFiZWxzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TapasForMaskedLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForMaskedLM.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Age&quot;</span>: [<span class="hljs-string">&quot;56&quot;</span>, <span class="hljs-string">&quot;45&quot;</span>, <span class="hljs-string">&quot;59&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    table=table, queries=<span class="hljs-string">&quot;How many [MASK] has George [MASK] played in?&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(
<span class="hljs-meta">... </span>    table=table, queries=<span class="hljs-string">&quot;How many movies has George Clooney played in?&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>
<span class="hljs-meta">... </span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){s=c("p"),s.textContent=m,t=r(),T(a.$$.fragment)},l(o){s=p(o,"P",{"data-svelte-h":!0}),u(s)!=="svelte-kvfsh7"&&(s.textContent=m),t=i(o),y(a.$$.fragment,o)},m(o,g){l(o,s,g),l(o,t,g),_(a,o,g),f=!0},p:$,i(o){f||(w(a.$$.fragment,o),f=!0)},o(o){b(a.$$.fragment,o),f=!1},d(o){o&&(n(s),n(t)),j(a,o)}}}function Cr(k){let s,m="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",t,a,f="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",o,g,Z=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,J,v,U=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,C,A,W=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){s=c("p"),s.innerHTML=m,t=r(),a=c("ul"),a.innerHTML=f,o=r(),g=c("p"),g.innerHTML=Z,J=r(),v=c("ul"),v.innerHTML=U,C=r(),A=c("p"),A.innerHTML=W},l(M){s=p(M,"P",{"data-svelte-h":!0}),u(s)!=="svelte-1ajbfxg"&&(s.innerHTML=m),t=i(M),a=p(M,"UL",{"data-svelte-h":!0}),u(a)!=="svelte-qm1t26"&&(a.innerHTML=f),o=i(M),g=p(M,"P",{"data-svelte-h":!0}),u(g)!=="svelte-1v9qsc5"&&(g.innerHTML=Z),J=i(M),v=p(M,"UL",{"data-svelte-h":!0}),u(v)!=="svelte-15scerc"&&(v.innerHTML=U),C=i(M),A=p(M,"P",{"data-svelte-h":!0}),u(A)!=="svelte-1an3odd"&&(A.innerHTML=W)},m(M,F){l(M,s,F),l(M,t,F),l(M,a,F),l(M,o,F),l(M,g,F),l(M,J,F),l(M,v,F),l(M,C,F),l(M,A,F)},p:$,d(M){M&&(n(s),n(t),n(a),n(o),n(g),n(J),n(v),n(C),n(A))}}}function Fr(k){let s,m=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=c("p"),s.innerHTML=m},l(t){s=p(t,"P",{"data-svelte-h":!0}),u(s)!=="svelte-fincs2"&&(s.innerHTML=m)},m(t,a){l(t,s,a)},p:$,d(t){t&&n(s)}}}function Zr(k){let s,m="Examples:",t,a,f;return a=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBUYXBhc0ZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFpbXBvcnQlMjB0ZW5zb3JmbG93JTIwYXMlMjB0ZiUwQWltcG9ydCUyMHBhbmRhcyUyMGFzJTIwcGQlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlLWZpbmV0dW5lZC10YWJmYWN0JTIyKSUwQW1vZGVsJTIwJTNEJTIwVGFwYXNGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlLWZpbmV0dW5lZC10YWJmYWN0JTIyKSUwQSUwQWRhdGElMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJBY3RvcnMlMjIlM0ElMjAlNUIlMjJCcmFkJTIwUGl0dCUyMiUyQyUyMCUyMkxlb25hcmRvJTIwRGklMjBDYXByaW8lMjIlMkMlMjAlMjJHZW9yZ2UlMjBDbG9vbmV5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyQWdlJTIyJTNBJTIwJTVCJTIyNTYlMjIlMkMlMjAlMjI0NSUyMiUyQyUyMCUyMjU5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyTnVtYmVyJTIwb2YlMjBtb3ZpZXMlMjIlM0ElMjAlNUIlMjI4NyUyMiUyQyUyMCUyMjUzJTIyJTJDJTIwJTIyNjklMjIlNUQlMkMlMEElN0QlMEF0YWJsZSUyMCUzRCUyMHBkLkRhdGFGcmFtZS5mcm9tX2RpY3QoZGF0YSklMEFxdWVyaWVzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyVGhlcmUlMjBpcyUyMG9ubHklMjBvbmUlMjBhY3RvciUyMHdobyUyMGlzJTIwNDUlMjB5ZWFycyUyMG9sZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlRoZXJlJTIwYXJlJTIwMyUyMGFjdG9ycyUyMHdoaWNoJTIwcGxheWVkJTIwaW4lMjBtb3JlJTIwdGhhbiUyMDYwJTIwbW92aWVzJTIyJTJDJTBBJTVEJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRhYmxlJTNEdGFibGUlMkMlMjBxdWVyaWVzJTNEcXVlcmllcyUyQyUyMHBhZGRpbmclM0QlMjJtYXhfbGVuZ3RoJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklMEFsYWJlbHMlMjAlM0QlMjB0Zi5jb252ZXJ0X3RvX3RlbnNvciglNUIxJTJDJTIwMCU1RCklMjAlMjAlMjMlMjAxJTIwbWVhbnMlMjBlbnRhaWxlZCUyQyUyMDAlMjBtZWFucyUyMHJlZnV0ZWQlMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpJTBBbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TapasForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-tabfact&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-tabfact&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Age&quot;</span>: [<span class="hljs-string">&quot;56&quot;</span>, <span class="hljs-string">&quot;45&quot;</span>, <span class="hljs-string">&quot;59&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>queries = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;There is only one actor who is 45 years old&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;There are 3 actors which played in more than 60 movies&quot;</span>,
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(table=table, queries=queries, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tf.convert_to_tensor([<span class="hljs-number">1</span>, <span class="hljs-number">0</span>])  <span class="hljs-comment"># 1 means entailed, 0 means refuted</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){s=c("p"),s.textContent=m,t=r(),T(a.$$.fragment)},l(o){s=p(o,"P",{"data-svelte-h":!0}),u(s)!=="svelte-kvfsh7"&&(s.textContent=m),t=i(o),y(a.$$.fragment,o)},m(o,g){l(o,s,g),l(o,t,g),_(a,o,g),f=!0},p:$,i(o){f||(w(a.$$.fragment,o),f=!0)},o(o){b(a.$$.fragment,o),f=!1},d(o){o&&(n(s),n(t)),j(a,o)}}}function Ar(k){let s,m="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",t,a,f="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",o,g,Z=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,J,v,U=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,C,A,W=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){s=c("p"),s.innerHTML=m,t=r(),a=c("ul"),a.innerHTML=f,o=r(),g=c("p"),g.innerHTML=Z,J=r(),v=c("ul"),v.innerHTML=U,C=r(),A=c("p"),A.innerHTML=W},l(M){s=p(M,"P",{"data-svelte-h":!0}),u(s)!=="svelte-1ajbfxg"&&(s.innerHTML=m),t=i(M),a=p(M,"UL",{"data-svelte-h":!0}),u(a)!=="svelte-qm1t26"&&(a.innerHTML=f),o=i(M),g=p(M,"P",{"data-svelte-h":!0}),u(g)!=="svelte-1v9qsc5"&&(g.innerHTML=Z),J=i(M),v=p(M,"UL",{"data-svelte-h":!0}),u(v)!=="svelte-15scerc"&&(v.innerHTML=U),C=i(M),A=p(M,"P",{"data-svelte-h":!0}),u(A)!=="svelte-1an3odd"&&(A.innerHTML=W)},m(M,F){l(M,s,F),l(M,t,F),l(M,a,F),l(M,o,F),l(M,g,F),l(M,J,F),l(M,v,F),l(M,C,F),l(M,A,F)},p:$,d(M){M&&(n(s),n(t),n(a),n(o),n(g),n(J),n(v),n(C),n(A))}}}function Br(k){let s,m=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=c("p"),s.innerHTML=m},l(t){s=p(t,"P",{"data-svelte-h":!0}),u(s)!=="svelte-fincs2"&&(s.innerHTML=m)},m(t,a){l(t,s,a)},p:$,d(t){t&&n(s)}}}function $r(k){let s,m="Examples:",t,a,f;return a=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBUYXBhc0ZvclF1ZXN0aW9uQW5zd2VyaW5nJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMiklMEFtb2RlbCUyMCUzRCUyMFRhcGFzRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMiklMEElMEFkYXRhJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyQWN0b3JzJTIyJTNBJTIwJTVCJTIyQnJhZCUyMFBpdHQlMjIlMkMlMjAlMjJMZW9uYXJkbyUyMERpJTIwQ2FwcmlvJTIyJTJDJTIwJTIyR2VvcmdlJTIwQ2xvb25leSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMkFnZSUyMiUzQSUyMCU1QiUyMjU2JTIyJTJDJTIwJTIyNDUlMjIlMkMlMjAlMjI1OSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMk51bWJlciUyMG9mJTIwbW92aWVzJTIyJTNBJTIwJTVCJTIyODclMjIlMkMlMjAlMjI1MyUyMiUyQyUyMCUyMjY5JTIyJTVEJTJDJTBBJTdEJTBBdGFibGUlMjAlM0QlMjBwZC5EYXRhRnJhbWUuZnJvbV9kaWN0KGRhdGEpJTBBcXVlcmllcyUyMCUzRCUyMCU1QiUyMkhvdyUyMG1hbnklMjBtb3ZpZXMlMjBoYXMlMjBHZW9yZ2UlMjBDbG9vbmV5JTIwcGxheWVkJTIwaW4lM0YlMjIlMkMlMjAlMjJIb3clMjBvbGQlMjBpcyUyMEJyYWQlMjBQaXR0JTNGJTIyJTVEJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRhYmxlJTNEdGFibGUlMkMlMjBxdWVyaWVzJTNEcXVlcmllcyUyQyUyMHBhZGRpbmclM0QlMjJtYXhfbGVuZ3RoJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEFsb2dpdHNfYWdncmVnYXRpb24lMjAlM0QlMjBvdXRwdXRzLmxvZ2l0c19hZ2dyZWdhdGlvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TapasForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Age&quot;</span>: [<span class="hljs-string">&quot;56&quot;</span>, <span class="hljs-string">&quot;45&quot;</span>, <span class="hljs-string">&quot;59&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>queries = [<span class="hljs-string">&quot;How many movies has George Clooney played in?&quot;</span>, <span class="hljs-string">&quot;How old is Brad Pitt?&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(table=table, queries=queries, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_aggregation = outputs.logits_aggregation`,wrap:!1}}),{c(){s=c("p"),s.textContent=m,t=r(),T(a.$$.fragment)},l(o){s=p(o,"P",{"data-svelte-h":!0}),u(s)!=="svelte-kvfsh7"&&(s.textContent=m),t=i(o),y(a.$$.fragment,o)},m(o,g){l(o,s,g),l(o,t,g),_(a,o,g),f=!0},p:$,i(o){f||(w(a.$$.fragment,o),f=!0)},o(o){b(a.$$.fragment,o),f=!1},d(o){o&&(n(s),n(t)),j(a,o)}}}function qr(k){let s,m,t,a,f,o,g,Z,J,v=`The TAPAS model was proposed in <a href="https://www.aclweb.org/anthology/2020.acl-main.398" rel="nofollow">TAPAS: Weakly Supervised Table Parsing via Pre-training</a>
by Jonathan Herzig, Paweł Krzysztof Nowak, Thomas Müller, Francesco Piccinno and Julian Martin Eisenschlos. It’s a BERT-based model specifically
designed (and pre-trained) for answering questions about tabular data. Compared to BERT, TAPAS uses relative position embeddings and has 7
token types that encode tabular structure. TAPAS is pre-trained on the masked language modeling (MLM) objective on a large dataset comprising
millions of tables from English Wikipedia and corresponding texts.`,U,C,A="For question answering, TAPAS has 2 heads on top: a cell selection head and an aggregation head, for (optionally) performing aggregations (such as counting or summing) among selected cells. TAPAS has been fine-tuned on several datasets:",W,M,F='<li><a href="https://www.microsoft.com/en-us/download/details.aspx?id=54253" rel="nofollow">SQA</a> (Sequential Question Answering by Microsoft)</li> <li><a href="https://github.com/ppasupat/WikiTableQuestions" rel="nofollow">WTQ</a> (Wiki Table Questions by Stanford University)</li> <li><a href="https://github.com/salesforce/WikiSQL" rel="nofollow">WikiSQL</a> (by Salesforce).</li>',I,B,Io="It achieves state-of-the-art on both SQA and WTQ, while having comparable performance to SOTA on WikiSQL, with a much simpler architecture.",tn,ts,Co="The abstract from the paper is the following:",nn,ns,Fo="<em>Answering natural language questions over tables is usually seen as a semantic parsing task. To alleviate the collection cost of full logical forms, one popular approach focuses on weak supervision consisting of denotations instead of logical forms. However, training semantic parsers from weak supervision poses difficulties, and in addition, the generated logical forms are only used as an intermediate step prior to retrieving the denotation. In this paper, we present TAPAS, an approach to question answering over tables without generating logical forms. TAPAS trains from weak supervision, and predicts the denotation by selecting table cells and optionally applying a corresponding aggregation operator to such selection. TAPAS extends BERT’s architecture to encode tables as input, initializes from an effective joint pre-training of text segments and tables crawled from Wikipedia, and is trained end-to-end. We experiment with three different semantic parsing datasets, and find that TAPAS outperforms or rivals semantic parsing models by improving state-of-the-art accuracy on SQA from 55.1 to 67.2 and performing on par with the state-of-the-art on WIKISQL and WIKITQ, but with a simpler model architecture. We additionally find that transfer learning, which is trivial in our setting, from WIKISQL to WIKITQ, yields 48.7 accuracy, 4.2 points above the state-of-the-art.</em>",an,as,Zo='In addition, the authors have further pre-trained TAPAS to recognize <strong>table entailment</strong>, by creating a balanced dataset of millions of automatically created training examples which are learned in an intermediate step prior to fine-tuning. The authors of TAPAS call this further pre-training intermediate pre-training (since TAPAS is first pre-trained on MLM, and then on another dataset). They found that intermediate pre-training further improves performance on SQA, achieving a new state-of-the-art as well as state-of-the-art on <a href="https://github.com/wenhuchen/Table-Fact-Checking" rel="nofollow">TabFact</a>, a large-scale dataset with 16k Wikipedia tables for table entailment (a binary classification task). For more details, see their follow-up paper: <a href="https://www.aclweb.org/anthology/2020.findings-emnlp.27/" rel="nofollow">Understanding tables with intermediate pre-training</a> by Julian Martin Eisenschlos, Syrine Krichene and Thomas Müller.',on,Ie,Ao,ln,os,Bo='TAPAS architecture. Taken from the <a href="https://ai.googleblog.com/2020/04/using-neural-networks-to-find-answers.html">original blog post</a>.',rn,ls,$o='This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The Tensorflow version of this model was contributed by <a href="https://huggingface.co/kamalkraj" rel="nofollow">kamalkraj</a>. The original code can be found <a href="https://github.com/google-research/tapas" rel="nofollow">here</a>.',dn,rs,qo="Tips:",cn,is,Wo='<li>TAPAS is a model that uses relative position embeddings by default (restarting the position embeddings at every cell of the table). Note that this is something that was added after the publication of the original TAPAS paper. According to the authors, this usually results in a slightly better performance, and allows you to encode longer sequences without running out of embeddings. This is reflected in the <code>reset_position_index_per_cell</code> parameter of <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a>, which is set to <code>True</code> by default. The default versions of the models available on the <a href="https://huggingface.co/models?search=tapas" rel="nofollow">hub</a> all use relative position embeddings. You can still use the ones with absolute position embeddings by passing in an additional argument <code>revision=&quot;no_reset&quot;</code> when calling the <code>from_pretrained()</code> method. Note that it’s usually advised to pad the inputs on the right rather than the left.</li> <li>TAPAS is based on BERT, so <code>TAPAS-base</code> for example corresponds to a <code>BERT-base</code> architecture. Of course, <code>TAPAS-large</code> will result in the best performance (the results reported in the paper are from <code>TAPAS-large</code>). Results of the various sized models are shown on the <a href="https://github.com/google-research/tapas%3E" rel="nofollow">original Github repository</a>.</li> <li>TAPAS has checkpoints fine-tuned on SQA, which are capable of answering questions related to a table in a conversational set-up. This means that you can ask follow-up questions such as “what is his age?” related to the previous question. Note that the forward pass of TAPAS is a bit different in case of a conversational set-up: in that case, you have to feed every table-question pair one by one to the model, such that the <code>prev_labels</code> token type ids can be overwritten by the predicted <code>labels</code> of the model to the previous question. See “Usage” section for more info.</li> <li>TAPAS is similar to BERT and therefore relies on the masked language modeling (MLM) objective. It is therefore efficient at predicting masked tokens and at NLU in general, but is not optimal for text generation. Models trained with a causal language modeling (CLM) objective are better in that regard. Note that TAPAS can be used as an encoder in the EncoderDecoderModel framework, to combine it with an autoregressive text decoder such as GPT-2.</li>',pn,ds,mn,cs,zo='Here we explain how you can fine-tune <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasForQuestionAnswering">TapasForQuestionAnswering</a> on your own dataset.',hn,ps,xo="<strong>STEP 1: Choose one of the 3 ways in which you can use TAPAS - or experiment</strong>",un,ms,Go='Basically, there are 3 different ways in which one can fine-tune <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasForQuestionAnswering">TapasForQuestionAnswering</a>, corresponding to the different datasets on which Tapas was fine-tuned:',gn,hs,Ro="<li>SQA: if you’re interested in asking follow-up questions related to a table, in a conversational set-up. For example if you first ask “what’s the name of the first actor?” then you can ask a follow-up question such as “how old is he?“. Here, questions do not involve any aggregation (all questions are cell selection questions).</li> <li>WTQ: if you’re not interested in asking questions in a conversational set-up, but rather just asking questions related to a table, which might involve aggregation, such as counting a number of rows, summing up cell values or averaging cell values. You can then for example ask “what’s the total number of goals Cristiano Ronaldo made in his career?“. This case is also called <strong>weak supervision</strong>, since the model itself must learn the appropriate aggregation operator (SUM/COUNT/AVERAGE/NONE) given only the answer to the question as supervision.</li> <li>WikiSQL-supervised: this dataset is based on WikiSQL with the model being given the ground truth aggregation operator during training. This is also called <strong>strong supervision</strong>. Here, learning the appropriate aggregation operator is much easier.</li>",fn,us,Qo="To summarize:",Mn,gs,No="<thead><tr><th><strong>Task</strong></th> <th><strong>Example dataset</strong></th> <th><strong>Description</strong></th></tr></thead> <tbody><tr><td>Conversational</td> <td>SQA</td> <td>Conversational, only cell selection questions</td></tr> <tr><td>Weak supervision for aggregation</td> <td>WTQ</td> <td>Questions might involve aggregation, and the model must learn this given only the answer as supervision</td></tr> <tr><td>Strong supervision for aggregation</td> <td>WikiSQL-supervised</td> <td>Questions might involve aggregation, and the model must learn this given the gold aggregation operator</td></tr></tbody>",Tn,Ce,yn,fs,Vo='What you can also do is start from an already fine-tuned checkpoint. A note here is that the already fine-tuned checkpoint on WTQ has some issues due to the L2-loss which is somewhat brittle. See <a href="https://github.com/google-research/tapas/issues/91#issuecomment-735719340" rel="nofollow">here</a> for more info.',_n,Ms,Xo='For a list of all pre-trained and fine-tuned TAPAS checkpoints available on HuggingFace’s  hub, see <a href="https://huggingface.co/models?search=tapas" rel="nofollow">here</a>.',wn,Ts,Eo="<strong>STEP 2: Prepare your data in the SQA format</strong>",bn,ys,So='Second, no matter what you picked above, you should prepare your dataset in the <a href="https://www.microsoft.com/en-us/download/details.aspx?id=54253" rel="nofollow">SQA</a> format. This format is a TSV/CSV file with the following columns:',jn,_s,Ho="<li><code>id</code>: optional, id of the table-question pair, for bookkeeping purposes.</li> <li><code>annotator</code>: optional, id of the person who annotated the table-question pair, for bookkeeping purposes.</li> <li><code>position</code>: integer indicating if the question is the first, second, third,… related to the table. Only required in case of conversational setup (SQA). You don’t need this column in case you’re going for WTQ/WikiSQL-supervised.</li> <li><code>question</code>: string</li> <li><code>table_file</code>: string, name of a csv file containing the tabular data</li> <li><code>answer_coordinates</code>: list of one or more tuples (each tuple being a cell coordinate, i.e. row, column pair that is part of the answer)</li> <li><code>answer_text</code>: list of one or more strings (each string being a cell value that is part of the answer)</li> <li><code>aggregation_label</code>: index of the aggregation operator. Only required in case of strong supervision for aggregation (the WikiSQL-supervised case)</li> <li><code>float_answer</code>: the float answer to the question, if there is one (np.nan if there isn’t). Only required in case of weak supervision for aggregation (such as WTQ and WikiSQL)</li>",Jn,ws,Yo='The tables themselves should be present in a folder, each table being a separate csv file. Note that the authors of the TAPAS algorithm used conversion scripts with some automated logic to convert the other datasets (WTQ, WikiSQL) into the SQA format. The author explains this <a href="https://github.com/google-research/tapas/issues/50#issuecomment-705465960" rel="nofollow">here</a>. A conversion of this script that works with HuggingFace’s implementation can be found <a href="https://github.com/NielsRogge/tapas_utils" rel="nofollow">here</a>. Interestingly, these conversion scripts are not perfect (the <code>answer_coordinates</code> and <code>float_answer</code> fields are populated based on the <code>answer_text</code>), meaning that WTQ and WikiSQL results could actually be improved.',Un,bs,Lo="<strong>STEP 3: Convert your data into tensors using TapasTokenizer</strong>",kn,Fe,vn,js,Po=`Note that here, we encode each table-question pair independently. This is fine as long as your dataset is <strong>not conversational</strong>. In case your dataset involves conversational questions (such as in SQA), then you should first group together the <code>queries</code>, <code>answer_coordinates</code> and <code>answer_text</code> per table (in the order of their <code>position</code>
index) and batch encode each table with its questions. This will make sure that the <code>prev_labels</code> token types (see docs of <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a>) are set correctly. See <a href="https://github.com/NielsRogge/Transformers-Tutorials/blob/master/TAPAS/Fine_tuning_TapasForQuestionAnswering_on_SQA.ipynb" rel="nofollow">this notebook</a> for more info. See <a href="https://github.com/kamalkraj/Tapas-Tutorial/blob/master/TAPAS/Fine_tuning_TapasForQuestionAnswering_on_SQA.ipynb" rel="nofollow">this notebook</a> for more info regarding using the TensorFlow model.`,In,Js,Do="**STEP 4: Train (fine-tune) the model",Cn,Ze,Fn,Us,Zn,Ae,An,ks,Oo='In case of a conversational set-up, then each table-question pair must be provided <strong>sequentially</strong> to the model, such that the <code>prev_labels</code> token types can be overwritten by the predicted <code>labels</code> of the previous table-question pair. Again, more info can be found in <a href="https://github.com/NielsRogge/Transformers-Tutorials/blob/master/TAPAS/Fine_tuning_TapasForQuestionAnswering_on_SQA.ipynb" rel="nofollow">this notebook</a> (for PyTorch) and <a href="https://github.com/kamalkraj/Tapas-Tutorial/blob/master/TAPAS/Fine_tuning_TapasForQuestionAnswering_on_SQA.ipynb" rel="nofollow">this notebook</a> (for TensorFlow).',Bn,vs,$n,Is,Ko='<li><a href="../tasks/sequence_classification">Text classification task guide</a></li> <li><a href="../tasks/masked_language_modeling">Masked language modeling task guide</a></li>',qn,Cs,Wn,Ue,Fs,la,ct,el='Output type of <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasForQuestionAnswering">TapasForQuestionAnswering</a>.',zn,Zs,xn,Y,As,ra,pt,sl=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasModel">TapasModel</a>. It is used to instantiate a TAPAS
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the TAPAS
<a href="https://huggingface.co/google/tapas-base-finetuned-sqa" rel="nofollow">google/tapas-base-finetuned-sqa</a> architecture.`,ia,mt,tl=`Configuration objects inherit from <code>PreTrainedConfig</code> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,da,ht,nl=`Hyperparameters additional to BERT are taken from run_task_main.py and hparam_utils.py of the original
implementation. Original implementation available at <a href="https://github.com/google-research/tapas/tree/master" rel="nofollow">https://github.com/google-research/tapas/tree/master</a>.`,ca,Be,Gn,Bs,Rn,G,$s,pa,ut,al=`Construct a TAPAS tokenizer. Based on WordPiece. Flattens a table and one or more related sentences to be used by
TAPAS models.`,ma,gt,ol=`This tokenizer inherits from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods. <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a> creates several token type ids to
encode tabular structure. To be more precise, it adds 7 token type ids, in the following order: <code>segment_ids</code>,
<code>column_ids</code>, <code>row_ids</code>, <code>prev_labels</code>, <code>column_ranks</code>, <code>inv_column_ranks</code> and <code>numeric_relations</code>:`,ha,ft,ll=`<li>segment_ids: indicate whether a token belongs to the question (0) or the table (1). 0 for special tokens and
padding.</li> <li>column_ids: indicate to which column of the table a token belongs (starting from 1). Is 0 for all question
tokens, special tokens and padding.</li> <li>row_ids: indicate to which row of the table a token belongs (starting from 1). Is 0 for all question tokens,
special tokens and padding. Tokens of column headers are also 0.</li> <li>prev_labels: indicate whether a token was (part of) an answer to the previous question (1) or not (0). Useful in
a conversational setup (such as SQA).</li> <li>column_ranks: indicate the rank of a table token relative to a column, if applicable. For example, if you have a
column “number of movies” with values 87, 53 and 69, then the column ranks of these tokens are 3, 1 and 2
respectively. 0 for all question tokens, special tokens and padding.</li> <li>inv_column_ranks: indicate the inverse rank of a table token relative to a column, if applicable. For example, if
you have a column “number of movies” with values 87, 53 and 69, then the inverse column ranks of these tokens are
1, 3 and 2 respectively. 0 for all question tokens, special tokens and padding.</li> <li>numeric_relations: indicate numeric relations between the question and the tokens of the table. 0 for all
question tokens, special tokens and padding.</li>`,ua,Mt,rl=`<a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a> runs end-to-end tokenization on a table and associated sentences: punctuation splitting and
wordpiece.`,ga,$e,qs,fa,Tt,il="Main method to tokenize and prepare for the model one or several sequence(s) related to a table.",Ma,Je,Ws,Ta,yt,dl=`Converts logits of <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasForQuestionAnswering">TapasForQuestionAnswering</a> to actual predicted answer coordinates and optional
aggregation indices.`,ya,_t,cl=`The original implementation, on which this function is based, can be found
<a href="https://github.com/google-research/tapas/blob/4908213eb4df7aa988573350278b44c4dbe3f71b/tapas/experiments/prediction_utils.py#L288" rel="nofollow">here</a>.`,_a,wt,zs,Qn,xs,Nn,N,Gs,wa,bt,pl=`The bare Tapas Model transformer outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its models (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ba,jt,ml=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ja,Jt,hl='This class is a small change compared to <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertModel">BertModel</a>, taking into account the additional token type ids.',Ja,Ut,ul=`The model can behave as an encoder (with only self-attention) as well as a decoder, in which case a layer of
cross-attention is added between the self-attention layers, following the architecture described in <a href="https://arxiv.org/abs/1706.03762" rel="nofollow">Attention is
all you need</a> by Ashish Vaswani, Noam Shazeer, Niki Parmar, Jakob Uszkoreit,
Llion Jones, Aidan N. Gomez, Lukasz Kaiser and Illia Polosukhin.`,Ua,le,Rs,ka,kt,gl='The <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasModel">TapasModel</a> forward method, overrides the <code>__call__</code> special method.',va,qe,Ia,We,Vn,Qs,Xn,te,Ns,Ca,vt,fl=`Tapas Model with a <code>language modeling</code> head on top.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its models (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Fa,It,Ml=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Za,re,Vs,Aa,Ct,Tl='The <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasForMaskedLM">TapasForMaskedLM</a> forward method, overrides the <code>__call__</code> special method.',Ba,ze,$a,xe,En,Xs,Sn,L,Es,qa,Ft,yl=`Tapas Model with a sequence classification head on top (a linear layer on top of the pooled output), e.g. for table
entailment tasks, such as TabFact (Chen et al., 2020).`,Wa,Zt,_l=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its models (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,za,At,wl=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,xa,ie,Ss,Ga,Bt,bl='The <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasForSequenceClassification">TapasForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',Ra,Ge,Qa,Re,Hn,Hs,Yn,P,Ys,Na,$t,jl=`Tapas Model with a cell selection head and optional aggregation head on top for question-answering tasks on tables
(linear layers on top of the hidden-states output to compute <code>logits</code> and optional <code>logits_aggregation</code>), e.g. for
SQA, WTQ or WikiSQL-supervised tasks.`,Va,qt,Jl=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its models (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Xa,Wt,Ul=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ea,de,Ls,Sa,zt,kl='The <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasForQuestionAnswering">TapasForQuestionAnswering</a> forward method, overrides the <code>__call__</code> special method.',Ha,Qe,Ya,Ne,Ln,Ps,Pn,V,Ds,La,xt,vl="The bare Tapas Model transformer outputting raw hidden-states without any specific head on top.",Pa,Gt,Il=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Da,Rt,Cl=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">tf.keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,Oa,Ve,Ka,ce,Os,eo,Qt,Fl='The <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TFTapasModel">TFTapasModel</a> forward method, overrides the <code>__call__</code> special method.',so,Xe,to,Ee,Dn,Ks,On,X,et,no,Nt,Zl="Tapas Model with a <code>language modeling</code> head on top.",ao,Vt,Al=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,oo,Xt,Bl=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">tf.keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,lo,Se,ro,pe,st,io,Et,$l='The <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TFTapasForMaskedLM">TFTapasForMaskedLM</a> forward method, overrides the <code>__call__</code> special method.',co,He,po,Ye,Kn,tt,ea,E,nt,mo,St,ql=`Tapas Model with a sequence classification head on top (a linear layer on top of the pooled output), e.g. for table
entailment tasks, such as TabFact (Chen et al., 2020).`,ho,Ht,Wl=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,uo,Yt,zl=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">tf.keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,go,Le,fo,me,at,Mo,Lt,xl='The <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TFTapasForSequenceClassification">TFTapasForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',To,Pe,yo,De,sa,ot,ta,S,lt,_o,Pt,Gl=`Tapas Model with a cell selection head and optional aggregation head on top for question-answering tasks on tables
(linear layers on top of the hidden-states output to compute <code>logits</code> and optional <code>logits_aggregation</code>), e.g. for
SQA, WTQ or WikiSQL-supervised tasks.`,wo,Dt,Rl=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,bo,Ot,Ql=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">tf.keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,jo,Oe,Jo,he,rt,Uo,Kt,Nl='The <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TFTapasForQuestionAnswering">TFTapasForQuestionAnswering</a> forward method, overrides the <code>__call__</code> special method.',ko,Ke,vo,es,na,en,aa;return f=new H({props:{title:"TAPAS",local:"tapas",headingTag:"h1"}}),g=new H({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ds=new H({props:{title:"Usage: fine-tuning",local:"usage-fine-tuning",headingTag:"h2"}}),Ce=new oa({props:{pytorch:!0,tensorflow:!0,jax:!1,$$slots:{tensorflow:[sr],pytorch:[Kl]},$$scope:{ctx:k}}}),Fe=new oa({props:{pytorch:!0,tensorflow:!0,jax:!1,$$slots:{tensorflow:[or],pytorch:[nr]},$$scope:{ctx:k}}}),Ze=new oa({props:{pytorch:!0,tensorflow:!0,jax:!1,$$slots:{tensorflow:[dr],pytorch:[rr]},$$scope:{ctx:k}}}),Us=new H({props:{title:"Usage: inference",local:"usage-inference",headingTag:"h2"}}),Ae=new oa({props:{pytorch:!0,tensorflow:!0,jax:!1,$$slots:{tensorflow:[hr],pytorch:[pr]},$$scope:{ctx:k}}}),vs=new H({props:{title:"Documentation resources",local:"documentation-resources",headingTag:"h2"}}),Cs=new H({props:{title:"TAPAS specific outputs",local:"transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput",headingTag:"h2"}}),Fs=new x({props:{name:"class transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput",anchor:"transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"logits_aggregation",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> (and possibly <code>answer</code>, <code>aggregation_labels</code>, <code>numeric_values</code> and <code>numeric_values_scale</code> are provided)) &#x2014;
Total loss as the sum of the hierarchical cell selection log-likelihood loss and (optionally) the
semi-supervised regression loss and (optionally) supervised loss for aggregations.`,name:"loss"},{anchor:"transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Prediction scores of the cell selection head, for every token.`,name:"logits"},{anchor:"transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput.logits_aggregation",description:`<strong>logits_aggregation</strong> (<code>torch.FloatTensor</code>, <em>optional</em>, of shape <code>(batch_size, num_aggregation_labels)</code>) &#x2014;
Prediction scores of the aggregation head, for every aggregation operator.`,name:"logits_aggregation"},{anchor:"transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/tapas/modeling_tapas.py#L98"}}),Zs=new H({props:{title:"TapasConfig",local:"transformers.TapasConfig",headingTag:"h2"}}),As=new x({props:{name:"class transformers.TapasConfig",anchor:"transformers.TapasConfig",parameters:[{name:"vocab_size",val:" = 30522"},{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.1"},{name:"attention_probs_dropout_prob",val:" = 0.1"},{name:"max_position_embeddings",val:" = 1024"},{name:"type_vocab_sizes",val:" = [3, 256, 256, 2, 256, 256, 10]"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"pad_token_id",val:" = 0"},{name:"positive_label_weight",val:" = 10.0"},{name:"num_aggregation_labels",val:" = 0"},{name:"aggregation_loss_weight",val:" = 1.0"},{name:"use_answer_as_supervision",val:" = None"},{name:"answer_loss_importance",val:" = 1.0"},{name:"use_normalized_answer_loss",val:" = False"},{name:"huber_loss_delta",val:" = None"},{name:"temperature",val:" = 1.0"},{name:"aggregation_temperature",val:" = 1.0"},{name:"use_gumbel_for_cells",val:" = False"},{name:"use_gumbel_for_aggregation",val:" = False"},{name:"average_approximation_function",val:" = 'ratio'"},{name:"cell_selection_preference",val:" = None"},{name:"answer_loss_cutoff",val:" = None"},{name:"max_num_rows",val:" = 64"},{name:"max_num_columns",val:" = 32"},{name:"average_logits_per_cell",val:" = False"},{name:"select_one_column",val:" = True"},{name:"allow_empty_column_selection",val:" = False"},{name:"init_cell_selection_weights_to_zero",val:" = False"},{name:"reset_position_index_per_cell",val:" = True"},{name:"disable_per_token_loss",val:" = False"},{name:"aggregation_labels",val:" = None"},{name:"no_aggregation_label_index",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TapasConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 30522) &#x2014;
Vocabulary size of the TAPAS model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasModel">TapasModel</a>.`,name:"vocab_size"},{anchor:"transformers.TapasConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.TapasConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.TapasConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.TapasConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.TapasConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>Callable</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;swish&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.TapasConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.TapasConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.TapasConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.TapasConfig.type_vocab_sizes",description:`<strong>type_vocab_sizes</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[3, 256, 256, 2, 256, 256, 10]</code>) &#x2014;
The vocabulary sizes of the <code>token_type_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasModel">TapasModel</a>.`,name:"type_vocab_sizes"},{anchor:"transformers.TapasConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.TapasConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.TapasConfig.positive_label_weight",description:`<strong>positive_label_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 10.0) &#x2014;
Weight for positive labels.`,name:"positive_label_weight"},{anchor:"transformers.TapasConfig.num_aggregation_labels",description:`<strong>num_aggregation_labels</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The number of aggregation operators to predict.`,name:"num_aggregation_labels"},{anchor:"transformers.TapasConfig.aggregation_loss_weight",description:`<strong>aggregation_loss_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Importance weight for the aggregation loss.`,name:"aggregation_loss_weight"},{anchor:"transformers.TapasConfig.use_answer_as_supervision",description:`<strong>use_answer_as_supervision</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use the answer as the only supervision for aggregation examples.`,name:"use_answer_as_supervision"},{anchor:"transformers.TapasConfig.answer_loss_importance",description:`<strong>answer_loss_importance</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Importance weight for the regression loss.`,name:"answer_loss_importance"},{anchor:"transformers.TapasConfig.use_normalized_answer_loss",description:`<strong>use_normalized_answer_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to normalize the answer loss by the maximum of the predicted and expected value.`,name:"use_normalized_answer_loss"},{anchor:"transformers.TapasConfig.huber_loss_delta",description:`<strong>huber_loss_delta</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Delta parameter used to calculate the regression loss.`,name:"huber_loss_delta"},{anchor:"transformers.TapasConfig.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Value used to control (OR change) the skewness of cell logits probabilities.`,name:"temperature"},{anchor:"transformers.TapasConfig.aggregation_temperature",description:`<strong>aggregation_temperature</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Scales aggregation logits to control the skewness of probabilities.`,name:"aggregation_temperature"},{anchor:"transformers.TapasConfig.use_gumbel_for_cells",description:`<strong>use_gumbel_for_cells</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to apply Gumbel-Softmax to cell selection.`,name:"use_gumbel_for_cells"},{anchor:"transformers.TapasConfig.use_gumbel_for_aggregation",description:`<strong>use_gumbel_for_aggregation</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to apply Gumbel-Softmax to aggregation selection.`,name:"use_gumbel_for_aggregation"},{anchor:"transformers.TapasConfig.average_approximation_function",description:`<strong>average_approximation_function</strong> (<code>string</code>, <em>optional</em>, defaults to <code>&quot;ratio&quot;</code>) &#x2014;
Method to calculate the expected average of cells in the weak supervision case. One of <code>&quot;ratio&quot;</code>,
<code>&quot;first_order&quot;</code> or <code>&quot;second_order&quot;</code>.`,name:"average_approximation_function"},{anchor:"transformers.TapasConfig.cell_selection_preference",description:`<strong>cell_selection_preference</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Preference for cell selection in ambiguous cases. Only applicable in case of weak supervision for
aggregation (WTQ, WikiSQL). If the total mass of the aggregation probabilities (excluding the &#x201C;NONE&#x201D;
operator) is higher than this hyperparameter, then aggregation is predicted for an example.`,name:"cell_selection_preference"},{anchor:"transformers.TapasConfig.answer_loss_cutoff",description:`<strong>answer_loss_cutoff</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Ignore examples with answer loss larger than cutoff.`,name:"answer_loss_cutoff"},{anchor:"transformers.TapasConfig.max_num_rows",description:`<strong>max_num_rows</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Maximum number of rows.`,name:"max_num_rows"},{anchor:"transformers.TapasConfig.max_num_columns",description:`<strong>max_num_columns</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Maximum number of columns.`,name:"max_num_columns"},{anchor:"transformers.TapasConfig.average_logits_per_cell",description:`<strong>average_logits_per_cell</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to average logits per cell.`,name:"average_logits_per_cell"},{anchor:"transformers.TapasConfig.select_one_column",description:`<strong>select_one_column</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to constrain the model to only select cells from a single column.`,name:"select_one_column"},{anchor:"transformers.TapasConfig.allow_empty_column_selection",description:`<strong>allow_empty_column_selection</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to allow not to select any column.`,name:"allow_empty_column_selection"},{anchor:"transformers.TapasConfig.init_cell_selection_weights_to_zero",description:`<strong>init_cell_selection_weights_to_zero</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to initialize cell selection weights to 0 so that the initial probabilities are 50%.`,name:"init_cell_selection_weights_to_zero"},{anchor:"transformers.TapasConfig.reset_position_index_per_cell",description:`<strong>reset_position_index_per_cell</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to restart position indexes at every cell (i.e. use relative position embeddings).`,name:"reset_position_index_per_cell"},{anchor:"transformers.TapasConfig.disable_per_token_loss",description:`<strong>disable_per_token_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to disable any (strong or weak) supervision on cells.`,name:"disable_per_token_loss"},{anchor:"transformers.TapasConfig.aggregation_labels",description:`<strong>aggregation_labels</strong> (<code>Dict[int, label]</code>, <em>optional</em>) &#x2014;
The aggregation labels used to aggregate the results. For example, the WTQ models have the following
aggregation labels: <code>{0: &quot;NONE&quot;, 1: &quot;SUM&quot;, 2: &quot;AVERAGE&quot;, 3: &quot;COUNT&quot;}</code>`,name:"aggregation_labels"},{anchor:"transformers.TapasConfig.no_aggregation_label_index",description:`<strong>no_aggregation_label_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If the aggregation labels are defined and one of these labels represents &#x201C;No aggregation&#x201D;, this should be
set to its index. For example, the WTQ models have the &#x201C;NONE&#x201D; aggregation label at index 0, so that value
should be set to 0 for these models.`,name:"no_aggregation_label_index"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/tapas/configuration_tapas.py#L45"}}),Be=new ve({props:{anchor:"transformers.TapasConfig.example",$$slots:{default:[ur]},$$scope:{ctx:k}}}),Bs=new H({props:{title:"TapasTokenizer",local:"transformers.TapasTokenizer",headingTag:"h2"}}),$s=new x({props:{name:"class transformers.TapasTokenizer",anchor:"transformers.TapasTokenizer",parameters:[{name:"vocab_file",val:""},{name:"do_lower_case",val:" = True"},{name:"do_basic_tokenize",val:" = True"},{name:"never_split",val:" = None"},{name:"unk_token",val:" = '[UNK]'"},{name:"sep_token",val:" = '[SEP]'"},{name:"pad_token",val:" = '[PAD]'"},{name:"cls_token",val:" = '[CLS]'"},{name:"mask_token",val:" = '[MASK]'"},{name:"empty_token",val:" = '[EMPTY]'"},{name:"tokenize_chinese_chars",val:" = True"},{name:"strip_accents",val:" = None"},{name:"cell_trim_length",val:": int = -1"},{name:"max_column_id",val:": int = None"},{name:"max_row_id",val:": int = None"},{name:"strip_column_names",val:": bool = False"},{name:"update_answer_coordinates",val:": bool = False"},{name:"min_question_length",val:" = None"},{name:"max_question_length",val:" = None"},{name:"model_max_length",val:": int = 512"},{name:"additional_special_tokens",val:": typing.Optional[typing.List[str]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TapasTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
File containing the vocabulary.`,name:"vocab_file"},{anchor:"transformers.TapasTokenizer.do_lower_case",description:`<strong>do_lower_case</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to lowercase the input when tokenizing.`,name:"do_lower_case"},{anchor:"transformers.TapasTokenizer.do_basic_tokenize",description:`<strong>do_basic_tokenize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to do basic tokenization before WordPiece.`,name:"do_basic_tokenize"},{anchor:"transformers.TapasTokenizer.never_split",description:`<strong>never_split</strong> (<code>Iterable</code>, <em>optional</em>) &#x2014;
Collection of tokens which will never be split during tokenization. Only has an effect when
<code>do_basic_tokenize=True</code>`,name:"never_split"},{anchor:"transformers.TapasTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[UNK]&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.TapasTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[SEP]&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.TapasTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[PAD]&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.TapasTokenizer.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[CLS]&quot;</code>) &#x2014;
The classifier token which is used when doing sequence classification (classification of the whole sequence
instead of per-token classification). It is the first token of the sequence when built with special tokens.`,name:"cls_token"},{anchor:"transformers.TapasTokenizer.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[MASK]&quot;</code>) &#x2014;
The token used for masking values. This is the token used when training this model with masked language
modeling. This is the token which the model will try to predict.`,name:"mask_token"},{anchor:"transformers.TapasTokenizer.empty_token",description:`<strong>empty_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[EMPTY]&quot;</code>) &#x2014;
The token used for empty cell values in a table. Empty cell values include &quot;&quot;, &#x201C;n/a&#x201D;, &#x201C;nan&#x201D; and &#x201D;?&#x201C;.`,name:"empty_token"},{anchor:"transformers.TapasTokenizer.tokenize_chinese_chars",description:`<strong>tokenize_chinese_chars</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to tokenize Chinese characters. This should likely be deactivated for Japanese (see this
<a href="https://github.com/huggingface/transformers/issues/328" rel="nofollow">issue</a>).`,name:"tokenize_chinese_chars"},{anchor:"transformers.TapasTokenizer.strip_accents",description:`<strong>strip_accents</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to strip all accents. If this option is not specified, then it will be determined by the
value for <code>lowercase</code> (as in the original BERT).`,name:"strip_accents"},{anchor:"transformers.TapasTokenizer.cell_trim_length",description:`<strong>cell_trim_length</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
If &gt; 0: Trim cells so that the length is &lt;= this value. Also disables further cell trimming, should thus be
used with <code>truncation</code> set to <code>True</code>.`,name:"cell_trim_length"},{anchor:"transformers.TapasTokenizer.max_column_id",description:`<strong>max_column_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Max column id to extract.`,name:"max_column_id"},{anchor:"transformers.TapasTokenizer.max_row_id",description:`<strong>max_row_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Max row id to extract.`,name:"max_row_id"},{anchor:"transformers.TapasTokenizer.strip_column_names",description:`<strong>strip_column_names</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to add empty strings instead of column names.`,name:"strip_column_names"},{anchor:"transformers.TapasTokenizer.update_answer_coordinates",description:`<strong>update_answer_coordinates</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to recompute the answer coordinates from the answer text.`,name:"update_answer_coordinates"},{anchor:"transformers.TapasTokenizer.min_question_length",description:`<strong>min_question_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Minimum length of each question in terms of tokens (will be skipped otherwise).`,name:"min_question_length"},{anchor:"transformers.TapasTokenizer.max_question_length",description:`<strong>max_question_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum length of each question in terms of tokens (will be skipped otherwise).`,name:"max_question_length"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/tapas/tokenization_tapas.py#L237"}}),qs=new x({props:{name:"__call__",anchor:"transformers.TapasTokenizer.__call__",parameters:[{name:"table",val:": pd.DataFrame"},{name:"queries",val:": typing.Union[str, typing.List[str], typing.List[int], typing.List[typing.List[str]], typing.List[typing.List[int]], NoneType] = None"},{name:"answer_coordinates",val:": typing.Union[typing.List[typing.Tuple], typing.List[typing.List[typing.Tuple]], NoneType] = None"},{name:"answer_text",val:": typing.Union[typing.List[str], typing.List[typing.List[str]], NoneType] = None"},{name:"add_special_tokens",val:": bool = True"},{name:"padding",val:": typing.Union[bool, str, transformers.utils.generic.PaddingStrategy] = False"},{name:"truncation",val:": typing.Union[bool, str, transformers.models.tapas.tokenization_tapas.TapasTruncationStrategy] = False"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_to_multiple_of",val:": typing.Optional[int] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"return_token_type_ids",val:": typing.Optional[bool] = None"},{name:"return_attention_mask",val:": typing.Optional[bool] = None"},{name:"return_overflowing_tokens",val:": bool = False"},{name:"return_special_tokens_mask",val:": bool = False"},{name:"return_offsets_mapping",val:": bool = False"},{name:"return_length",val:": bool = False"},{name:"verbose",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TapasTokenizer.__call__.table",description:`<strong>table</strong> (<code>pd.DataFrame</code>) &#x2014;
Table containing tabular data. Note that all cell values must be text. Use <em>.astype(str)</em> on a Pandas
dataframe to convert it to string.`,name:"table"},{anchor:"transformers.TapasTokenizer.__call__.queries",description:`<strong>queries</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
Question or batch of questions related to a table to be encoded. Note that in case of a batch, all
questions must refer to the <strong>same</strong> table.`,name:"queries"},{anchor:"transformers.TapasTokenizer.__call__.answer_coordinates",description:`<strong>answer_coordinates</strong> (<code>List[Tuple]</code> or <code>List[List[Tuple]]</code>, <em>optional</em>) &#x2014;
Answer coordinates of each table-question pair in the batch. In case only a single table-question pair
is provided, then the answer_coordinates must be a single list of one or more tuples. Each tuple must
be a (row_index, column_index) pair. The first data row (not the column header row) has index 0. The
first column has index 0. In case a batch of table-question pairs is provided, then the
answer_coordinates must be a list of lists of tuples (each list corresponding to a single
table-question pair).`,name:"answer_coordinates"},{anchor:"transformers.TapasTokenizer.__call__.answer_text",description:`<strong>answer_text</strong> (<code>List[str]</code> or <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
Answer text of each table-question pair in the batch. In case only a single table-question pair is
provided, then the answer_text must be a single list of one or more strings. Each string must be the
answer text of a corresponding answer coordinate. In case a batch of table-question pairs is provided,
then the answer_coordinates must be a list of lists of strings (each list corresponding to a single
table-question pair).`,name:"answer_text"},{anchor:"transformers.TapasTokenizer.__call__.add_special_tokens",description:`<strong>add_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to encode the sequences with the special tokens relative to their model.`,name:"add_special_tokens"},{anchor:"transformers.TapasTokenizer.__call__.padding",description:`<strong>padding</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls padding. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest&apos;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</li>
<li><code>&apos;max_length&apos;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</li>
<li><code>False</code> or <code>&apos;do_not_pad&apos;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).</li>
</ul>`,name:"padding"},{anchor:"transformers.TapasTokenizer.__call__.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <code>str</code> or <code>TapasTruncationStrategy</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls truncation. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;drop_rows_to_fit&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code>
or to the maximum acceptable input length for the model if that argument is not provided. This will
truncate row by row, removing rows from the table.</li>
<li><code>False</code> or <code>&apos;do_not_truncate&apos;</code> (default): No truncation (i.e., can output batch with sequence lengths
greater than the model maximum admissible input size).</li>
</ul>`,name:"truncation"},{anchor:"transformers.TapasTokenizer.__call__.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Controls the maximum length to use by one of the truncation/padding parameters.</p>
<p>If left unset or set to <code>None</code>, this will use the predefined model maximum length if a maximum length
is required by one of the truncation/padding parameters. If the model has no specific maximum input
length (like XLNet) truncation/padding to a maximum length will be deactivated.`,name:"max_length"},{anchor:"transformers.TapasTokenizer.__call__.is_split_into_words",description:`<strong>is_split_into_words</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the input is already pre-tokenized (e.g., split into words). If set to <code>True</code>, the
tokenizer assumes the input is already split into words (for instance, by splitting it on whitespace)
which it will tokenize. This is useful for NER or token classification.`,name:"is_split_into_words"},{anchor:"transformers.TapasTokenizer.__call__.pad_to_multiple_of",description:`<strong>pad_to_multiple_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If set will pad the sequence to a multiple of the provided value. This is especially useful to enable
the use of Tensor Cores on NVIDIA hardware with compute capability <code>&gt;= 7.5</code> (Volta).`,name:"pad_to_multiple_of"},{anchor:"transformers.TapasTokenizer.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of list of python integers. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return Numpy <code>np.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/tapas/tokenization_tapas.py#L588"}}),Ws=new x({props:{name:"convert_logits_to_predictions",anchor:"transformers.TapasTokenizer.convert_logits_to_predictions",parameters:[{name:"data",val:""},{name:"logits",val:""},{name:"logits_agg",val:" = None"},{name:"cell_classification_threshold",val:" = 0.5"}],parametersDescription:[{anchor:"transformers.TapasTokenizer.convert_logits_to_predictions.data",description:`<strong>data</strong> (<code>dict</code>) &#x2014;
Dictionary mapping features to actual values. Should be created using <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a>.`,name:"data"},{anchor:"transformers.TapasTokenizer.convert_logits_to_predictions.logits",description:`<strong>logits</strong> (<code>torch.Tensor</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Tensor containing the logits at the token level.`,name:"logits"},{anchor:"transformers.TapasTokenizer.convert_logits_to_predictions.logits_agg",description:`<strong>logits_agg</strong> (<code>torch.Tensor</code> or <code>tf.Tensor</code> of shape <code>(batch_size, num_aggregation_labels)</code>, <em>optional</em>) &#x2014;
Tensor containing the aggregation logits.`,name:"logits_agg"},{anchor:"transformers.TapasTokenizer.convert_logits_to_predictions.cell_classification_threshold",description:`<strong>cell_classification_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to be used for cell selection. All table cells for which their probability is larger than
this threshold will be selected.`,name:"cell_classification_threshold"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/tapas/tokenization_tapas.py#L1951",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>predicted_answer_coordinates (<code>List[List[[tuple]]</code> of length <code>batch_size</code>): Predicted answer coordinates
as a list of lists of tuples. Each element in the list contains the predicted answer coordinates of a
single example in the batch, as a list of tuples. Each tuple is a cell, i.e. (row index, column index).</li>
<li>predicted_aggregation_indices (<code>List[int]</code>of length <code>batch_size</code>, <em>optional</em>, returned when
<code>logits_aggregation</code> is provided): Predicted aggregation operator indices of the aggregation head.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tuple</code> comprising various elements depending on the inputs</p>
`}}),zs=new x({props:{name:"save_vocabulary",anchor:"transformers.TapasTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": typing.Optional[str] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/tapas/tokenization_tapas.py#L456"}}),xs=new H({props:{title:"TapasModel",local:"transformers.TapasModel",headingTag:"h2"}}),Gs=new x({props:{name:"class transformers.TapasModel",anchor:"transformers.TapasModel",parameters:[{name:"config",val:""},{name:"add_pooling_layer",val:" = True"}],parametersDescription:[{anchor:"transformers.TapasModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/tapas/modeling_tapas.py#L848"}}),Rs=new x({props:{name:"forward",anchor:"transformers.TapasModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.TapasModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TapasModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TapasModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, 7)</code>, <em>optional</em>) &#x2014;
Token indices that encode tabular structure. Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See this
class for more info.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TapasModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. If
<code>reset_position_index_per_cell</code> of <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> is set to <code>True</code>, relative position embeddings will be
used. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TapasModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>: - 1
indicates the head is <strong>not masked</strong>, - 0 indicates the head is <strong>masked</strong>.`,name:"head_mask"},{anchor:"transformers.TapasModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TapasModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TapasModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TapasModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/tapas/modeling_tapas.py#L885",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasConfig"
>TapasConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),qe=new ue({props:{$$slots:{default:[gr]},$$scope:{ctx:k}}}),We=new ve({props:{anchor:"transformers.TapasModel.forward.example",$$slots:{default:[fr]},$$scope:{ctx:k}}}),Qs=new H({props:{title:"TapasForMaskedLM",local:"transformers.TapasForMaskedLM",headingTag:"h2"}}),Ns=new x({props:{name:"class transformers.TapasForMaskedLM",anchor:"transformers.TapasForMaskedLM",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.TapasForMaskedLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/tapas/modeling_tapas.py#L1001"}}),Vs=new x({props:{name:"forward",anchor:"transformers.TapasForMaskedLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TapasForMaskedLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TapasForMaskedLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TapasForMaskedLM.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, 7)</code>, <em>optional</em>) &#x2014;
Token indices that encode tabular structure. Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See this
class for more info.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TapasForMaskedLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. If
<code>reset_position_index_per_cell</code> of <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> is set to <code>True</code>, relative position embeddings will be
used. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TapasForMaskedLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>: - 1
indicates the head is <strong>not masked</strong>, - 0 indicates the head is <strong>masked</strong>.`,name:"head_mask"},{anchor:"transformers.TapasForMaskedLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TapasForMaskedLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TapasForMaskedLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TapasForMaskedLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TapasForMaskedLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should be in <code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_ids</code> docstring) Tokens with indices set to <code>-100</code> are ignored (masked), the
loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/tapas/modeling_tapas.py#L1021",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasConfig"
>TapasConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Masked language modeling (MLM) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ze=new ue({props:{$$slots:{default:[Mr]},$$scope:{ctx:k}}}),xe=new ve({props:{anchor:"transformers.TapasForMaskedLM.forward.example",$$slots:{default:[Tr]},$$scope:{ctx:k}}}),Xs=new H({props:{title:"TapasForSequenceClassification",local:"transformers.TapasForSequenceClassification",headingTag:"h2"}}),Es=new x({props:{name:"class transformers.TapasForSequenceClassification",anchor:"transformers.TapasForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.TapasForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/tapas/modeling_tapas.py#L1462"}}),Ss=new x({props:{name:"forward",anchor:"transformers.TapasForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.TapasForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TapasForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TapasForSequenceClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, 7)</code>, <em>optional</em>) &#x2014;
Token indices that encode tabular structure. Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See this
class for more info.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TapasForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. If
<code>reset_position_index_per_cell</code> of <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> is set to <code>True</code>, relative position embeddings will be
used. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TapasForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>: - 1
indicates the head is <strong>not masked</strong>, - 0 indicates the head is <strong>masked</strong>.`,name:"head_mask"},{anchor:"transformers.TapasForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TapasForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TapasForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TapasForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TapasForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy). Note: this is called
&#x201C;classification_class_index&#x201D; in the original implementation.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/tapas/modeling_tapas.py#L1474",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasConfig"
>TapasConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Ge=new ue({props:{$$slots:{default:[yr]},$$scope:{ctx:k}}}),Re=new ve({props:{anchor:"transformers.TapasForSequenceClassification.forward.example",$$slots:{default:[_r]},$$scope:{ctx:k}}}),Hs=new H({props:{title:"TapasForQuestionAnswering",local:"transformers.TapasForQuestionAnswering",headingTag:"h2"}}),Ys=new x({props:{name:"class transformers.TapasForQuestionAnswering",anchor:"transformers.TapasForQuestionAnswering",parameters:[{name:"config",val:": TapasConfig"}],parametersDescription:[{anchor:"transformers.TapasForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/tapas/modeling_tapas.py#L1117"}}),Ls=new x({props:{name:"forward",anchor:"transformers.TapasForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"table_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"aggregation_labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"float_answer",val:": typing.Optional[torch.FloatTensor] = None"},{name:"numeric_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"numeric_values_scale",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.TapasForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TapasForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TapasForQuestionAnswering.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, 7)</code>, <em>optional</em>) &#x2014;
Token indices that encode tabular structure. Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See this
class for more info.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TapasForQuestionAnswering.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. If
<code>reset_position_index_per_cell</code> of <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> is set to <code>True</code>, relative position embeddings will be
used. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TapasForQuestionAnswering.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>: - 1
indicates the head is <strong>not masked</strong>, - 0 indicates the head is <strong>masked</strong>.`,name:"head_mask"},{anchor:"transformers.TapasForQuestionAnswering.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TapasForQuestionAnswering.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TapasForQuestionAnswering.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TapasForQuestionAnswering.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TapasForQuestionAnswering.forward.table_mask",description:`<strong>table_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, seq_length)</code>, <em>optional</em>) &#x2014;
Mask for the table. Indicates which tokens belong to the table (1). Question tokens, table headers and
padding are 0.`,name:"table_mask"},{anchor:"transformers.TapasForQuestionAnswering.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, seq_length)</code>, <em>optional</em>) &#x2014;
Labels per token for computing the hierarchical cell selection loss. This encodes the positions of the
answer appearing in the table. Can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>.</p>
<ul>
<li>1 for tokens that are <strong>part of the answer</strong>,</li>
<li>0 for tokens that are <strong>not part of the answer</strong>.</li>
</ul>`,name:"labels"},{anchor:"transformers.TapasForQuestionAnswering.forward.aggregation_labels",description:`<strong>aggregation_labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, )</code>, <em>optional</em>) &#x2014;
Aggregation function index for every example in the batch for computing the aggregation loss. Indices
should be in <code>[0, ..., config.num_aggregation_labels - 1]</code>. Only required in case of strong supervision for
aggregation (WikiSQL-supervised).`,name:"aggregation_labels"},{anchor:"transformers.TapasForQuestionAnswering.forward.float_answer",description:`<strong>float_answer</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, )</code>, <em>optional</em>) &#x2014;
Float answer for every example in the batch. Set to <em>float(&#x2018;nan&#x2019;)</em> for cell selection questions. Only
required in case of weak supervision (WTQ) to calculate the aggregate mask and regression loss.`,name:"float_answer"},{anchor:"transformers.TapasForQuestionAnswering.forward.numeric_values",description:`<strong>numeric_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, seq_length)</code>, <em>optional</em>) &#x2014;
Numeric values of every token, NaN for tokens which are not numeric values. Can be obtained using
<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. Only required in case of weak supervision for aggregation (WTQ) to calculate the
regression loss.`,name:"numeric_values"},{anchor:"transformers.TapasForQuestionAnswering.forward.numeric_values_scale",description:`<strong>numeric_values_scale</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, seq_length)</code>, <em>optional</em>) &#x2014;
Scale of the numeric values of every token. Can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. Only required in case
of weak supervision for aggregation (WTQ) to calculate the regression loss.`,name:"numeric_values_scale"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/tapas/modeling_tapas.py#L1152",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/tapas#transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput"
>transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasConfig"
>TapasConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> (and possibly <code>answer</code>, <code>aggregation_labels</code>, <code>numeric_values</code> and <code>numeric_values_scale</code> are provided)) — Total loss as the sum of the hierarchical cell selection log-likelihood loss and (optionally) the
semi-supervised regression loss and (optionally) supervised loss for aggregations.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Prediction scores of the cell selection head, for every token.</li>
<li><strong>logits_aggregation</strong> (<code>torch.FloatTensor</code>, <em>optional</em>, of shape <code>(batch_size, num_aggregation_labels)</code>) — Prediction scores of the aggregation head, for every aggregation operator.</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/tapas#transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput"
>transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Qe=new ue({props:{$$slots:{default:[wr]},$$scope:{ctx:k}}}),Ne=new ve({props:{anchor:"transformers.TapasForQuestionAnswering.forward.example",$$slots:{default:[br]},$$scope:{ctx:k}}}),Ps=new H({props:{title:"TFTapasModel",local:"transformers.TFTapasModel",headingTag:"h2"}}),Ds=new x({props:{name:"class transformers.TFTapasModel",anchor:"transformers.TFTapasModel",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFTapasModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/tapas/modeling_tf_tapas.py#L974"}}),Ve=new ue({props:{$$slots:{default:[jr]},$$scope:{ctx:k}}}),Os=new x({props:{name:"call",anchor:"transformers.TFTapasModel.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"token_type_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFTapasModel.call.input_ids",description:`<strong>input_ids</strong> (<code>np.ndarray</code>, <code>tf.Tensor</code>, <code>List[tf.Tensor]</code> \`<code>Dict[str, tf.Tensor]</code> or <code>Dict[str, np.ndarray]</code> and each example must have the shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFTapasModel.call.attention_mask",description:`<strong>attention_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFTapasModel.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, 7)</code>, <em>optional</em>) &#x2014;
Token indices that encode tabular structure. Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See this
class for more info.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFTapasModel.call.position_ids",description:`<strong>position_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. If
<code>reset_position_index_per_cell</code> of <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> is set to <code>True</code>, relative position embeddings will be
used. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFTapasModel.call.head_mask",description:`<strong>head_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFTapasModel.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFTapasModel.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFTapasModel.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFTapasModel.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFTapasModel.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to \`False&#x201C;) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/tapas/modeling_tf_tapas.py#L980",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling"
>transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasConfig"
>TapasConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) further processed by a
Linear layer and a Tanh activation function. The Linear layer weights are trained from the next sentence
prediction (classification) objective during pretraining.</p>
<p>This output is usually <em>not</em> a good summary of the semantic content of the input, you’re often better with
averaging or pooling the sequence of hidden-states for the whole input sequence.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling"
>transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling</a> or <code>tuple(tf.Tensor)</code></p>
`}}),Xe=new ue({props:{$$slots:{default:[Jr]},$$scope:{ctx:k}}}),Ee=new ve({props:{anchor:"transformers.TFTapasModel.call.example",$$slots:{default:[Ur]},$$scope:{ctx:k}}}),Ks=new H({props:{title:"TFTapasForMaskedLM",local:"transformers.TFTapasForMaskedLM",headingTag:"h2"}}),et=new x({props:{name:"class transformers.TFTapasForMaskedLM",anchor:"transformers.TFTapasForMaskedLM",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFTapasForMaskedLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/tapas/modeling_tf_tapas.py#L1038"}}),Se=new ue({props:{$$slots:{default:[kr]},$$scope:{ctx:k}}}),st=new x({props:{name:"call",anchor:"transformers.TFTapasForMaskedLM.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"token_type_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"labels",val:": np.ndarray | tf.Tensor | None = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFTapasForMaskedLM.call.input_ids",description:`<strong>input_ids</strong> (<code>np.ndarray</code>, <code>tf.Tensor</code>, <code>List[tf.Tensor]</code> \`<code>Dict[str, tf.Tensor]</code> or <code>Dict[str, np.ndarray]</code> and each example must have the shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFTapasForMaskedLM.call.attention_mask",description:`<strong>attention_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFTapasForMaskedLM.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, 7)</code>, <em>optional</em>) &#x2014;
Token indices that encode tabular structure. Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See this
class for more info.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFTapasForMaskedLM.call.position_ids",description:`<strong>position_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. If
<code>reset_position_index_per_cell</code> of <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> is set to <code>True</code>, relative position embeddings will be
used. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFTapasForMaskedLM.call.head_mask",description:`<strong>head_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFTapasForMaskedLM.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFTapasForMaskedLM.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFTapasForMaskedLM.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFTapasForMaskedLM.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFTapasForMaskedLM.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to \`False&#x201C;) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"},{anchor:"transformers.TFTapasForMaskedLM.call.labels",description:`<strong>labels</strong> (<code>tf.Tensor</code> or <code>np.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should be in <code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_ids</code> docstring) Tokens with indices set to <code>-100</code> are ignored (masked), the
loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/tapas/modeling_tf_tapas.py#L1054",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFMaskedLMOutput"
>transformers.modeling_tf_outputs.TFMaskedLMOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasConfig"
>TapasConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of non-masked labels, returned when <code>labels</code> is provided) — Masked language modeling (MLM) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFMaskedLMOutput"
>transformers.modeling_tf_outputs.TFMaskedLMOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),He=new ue({props:{$$slots:{default:[vr]},$$scope:{ctx:k}}}),Ye=new ve({props:{anchor:"transformers.TFTapasForMaskedLM.call.example",$$slots:{default:[Ir]},$$scope:{ctx:k}}}),tt=new H({props:{title:"TFTapasForSequenceClassification",local:"transformers.TFTapasForSequenceClassification",headingTag:"h2"}}),nt=new x({props:{name:"class transformers.TFTapasForSequenceClassification",anchor:"transformers.TFTapasForSequenceClassification",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFTapasForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/tapas/modeling_tf_tapas.py#L1563"}}),Le=new ue({props:{$$slots:{default:[Cr]},$$scope:{ctx:k}}}),at=new x({props:{name:"call",anchor:"transformers.TFTapasForSequenceClassification.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"token_type_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"labels",val:": np.ndarray | tf.Tensor | None = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFTapasForSequenceClassification.call.input_ids",description:`<strong>input_ids</strong> (<code>np.ndarray</code>, <code>tf.Tensor</code>, <code>List[tf.Tensor]</code> \`<code>Dict[str, tf.Tensor]</code> or <code>Dict[str, np.ndarray]</code> and each example must have the shape <code>(batch_size, num_choices, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFTapasForSequenceClassification.call.attention_mask",description:`<strong>attention_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFTapasForSequenceClassification.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, num_choices, sequence_length, 7)</code>, <em>optional</em>) &#x2014;
Token indices that encode tabular structure. Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See this
class for more info.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFTapasForSequenceClassification.call.position_ids",description:`<strong>position_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. If
<code>reset_position_index_per_cell</code> of <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> is set to <code>True</code>, relative position embeddings will be
used. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFTapasForSequenceClassification.call.head_mask",description:`<strong>head_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFTapasForSequenceClassification.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, num_choices, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFTapasForSequenceClassification.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFTapasForSequenceClassification.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFTapasForSequenceClassification.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFTapasForSequenceClassification.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to \`False&#x201C;) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"},{anchor:"transformers.TFTapasForSequenceClassification.call.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy). Note: this is called
&#x201C;classification_class_index&#x201D; in the original implementation.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/tapas/modeling_tf_tapas.py#L1574",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFSequenceClassifierOutput"
>transformers.modeling_tf_outputs.TFSequenceClassifierOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasConfig"
>TapasConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, )</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFSequenceClassifierOutput"
>transformers.modeling_tf_outputs.TFSequenceClassifierOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),Pe=new ue({props:{$$slots:{default:[Fr]},$$scope:{ctx:k}}}),De=new ve({props:{anchor:"transformers.TFTapasForSequenceClassification.call.example",$$slots:{default:[Zr]},$$scope:{ctx:k}}}),ot=new H({props:{title:"TFTapasForQuestionAnswering",local:"transformers.TFTapasForQuestionAnswering",headingTag:"h2"}}),lt=new x({props:{name:"class transformers.TFTapasForQuestionAnswering",anchor:"transformers.TFTapasForQuestionAnswering",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFTapasForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/tapas/modeling_tf_tapas.py#L1238"}}),Oe=new ue({props:{$$slots:{default:[Ar]},$$scope:{ctx:k}}}),rt=new x({props:{name:"call",anchor:"transformers.TFTapasForQuestionAnswering.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"token_type_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"table_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"aggregation_labels",val:": np.ndarray | tf.Tensor | None = None"},{name:"float_answer",val:": np.ndarray | tf.Tensor | None = None"},{name:"numeric_values",val:": np.ndarray | tf.Tensor | None = None"},{name:"numeric_values_scale",val:": np.ndarray | tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"labels",val:": np.ndarray | tf.Tensor | None = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFTapasForQuestionAnswering.call.input_ids",description:`<strong>input_ids</strong> (<code>np.ndarray</code>, <code>tf.Tensor</code>, <code>List[tf.Tensor]</code> \`<code>Dict[str, tf.Tensor]</code> or <code>Dict[str, np.ndarray]</code> and each example must have the shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFTapasForQuestionAnswering.call.attention_mask",description:`<strong>attention_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFTapasForQuestionAnswering.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, 7)</code>, <em>optional</em>) &#x2014;
Token indices that encode tabular structure. Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See this
class for more info.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFTapasForQuestionAnswering.call.position_ids",description:`<strong>position_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. If
<code>reset_position_index_per_cell</code> of <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> is set to <code>True</code>, relative position embeddings will be
used. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFTapasForQuestionAnswering.call.head_mask",description:`<strong>head_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFTapasForQuestionAnswering.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFTapasForQuestionAnswering.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFTapasForQuestionAnswering.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFTapasForQuestionAnswering.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFTapasForQuestionAnswering.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to \`False&#x201C;) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"},{anchor:"transformers.TFTapasForQuestionAnswering.call.table_mask",description:`<strong>table_mask</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, seq_length)</code>, <em>optional</em>) &#x2014;
Mask for the table. Indicates which tokens belong to the table (1). Question tokens, table headers and
padding are 0.`,name:"table_mask"},{anchor:"transformers.TFTapasForQuestionAnswering.call.labels",description:`<strong>labels</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, seq_length)</code>, <em>optional</em>) &#x2014;
Labels per token for computing the hierarchical cell selection loss. This encodes the positions of the
answer appearing in the table. Can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>.</p>
<ul>
<li>1 for tokens that are <strong>part of the answer</strong>,</li>
<li>0 for tokens that are <strong>not part of the answer</strong>.</li>
</ul>`,name:"labels"},{anchor:"transformers.TFTapasForQuestionAnswering.call.aggregation_labels",description:`<strong>aggregation_labels</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, )</code>, <em>optional</em>) &#x2014;
Aggregation function index for every example in the batch for computing the aggregation loss. Indices
should be in <code>[0, ..., config.num_aggregation_labels - 1]</code>. Only required in case of strong supervision for
aggregation (WikiSQL-supervised).`,name:"aggregation_labels"},{anchor:"transformers.TFTapasForQuestionAnswering.call.float_answer",description:`<strong>float_answer</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, )</code>, <em>optional</em>) &#x2014;
Float answer for every example in the batch. Set to <em>float(&#x2018;nan&#x2019;)</em> for cell selection questions. Only
required in case of weak supervision (WTQ) to calculate the aggregate mask and regression loss.`,name:"float_answer"},{anchor:"transformers.TFTapasForQuestionAnswering.call.numeric_values",description:`<strong>numeric_values</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, seq_length)</code>, <em>optional</em>) &#x2014;
Numeric values of every token, NaN for tokens which are not numeric values. Can be obtained using
<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. Only required in case of weak supervision for aggregation (WTQ) to calculate the
regression loss.`,name:"numeric_values"},{anchor:"transformers.TFTapasForQuestionAnswering.call.numeric_values_scale",description:`<strong>numeric_values_scale</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, seq_length)</code>, <em>optional</em>) &#x2014;
Scale of the numeric values of every token. Can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. Only required in case
of weak supervision for aggregation (WTQ) to calculate the regression loss.`,name:"numeric_values_scale"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/tapas/modeling_tf_tapas.py#L1260",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.tapas.modeling_tf_tapas.TFTableQuestionAnsweringOutput</code> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasConfig"
>TapasConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> (and possibly <code>answer</code>, <code>aggregation_labels</code>, <code>numeric_values</code> and <code>numeric_values_scale</code> are provided)) — Total loss as the sum of the hierarchical cell selection log-likelihood loss and (optionally) the
semi-supervised regression loss and (optionally) supervised loss for aggregations.</li>
<li><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) — Prediction scores of the cell selection head, for every token.</li>
<li><strong>logits_aggregation</strong> (<code>tf.Tensor</code>, <em>optional</em>, of shape <code>(batch_size, num_aggregation_labels)</code>) — Prediction scores of the aggregation head, for every aggregation operator.</li>
<li><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer plus
the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.tapas.modeling_tf_tapas.TFTableQuestionAnsweringOutput</code> or <code>tuple(tf.Tensor)</code></p>
`}}),Ke=new ue({props:{$$slots:{default:[Br]},$$scope:{ctx:k}}}),es=new ve({props:{anchor:"transformers.TFTapasForQuestionAnswering.call.example",$$slots:{default:[$r]},$$scope:{ctx:k}}}),{c(){s=c("meta"),m=r(),t=c("p"),a=r(),T(f.$$.fragment),o=r(),T(g.$$.fragment),Z=r(),J=c("p"),J.innerHTML=v,U=r(),C=c("p"),C.textContent=A,W=r(),M=c("ul"),M.innerHTML=F,I=r(),B=c("p"),B.textContent=Io,tn=r(),ts=c("p"),ts.textContent=Co,nn=r(),ns=c("p"),ns.innerHTML=Fo,an=r(),as=c("p"),as.innerHTML=Zo,on=r(),Ie=c("img"),ln=r(),os=c("small"),os.innerHTML=Bo,rn=r(),ls=c("p"),ls.innerHTML=$o,dn=r(),rs=c("p"),rs.textContent=qo,cn=r(),is=c("ul"),is.innerHTML=Wo,pn=r(),T(ds.$$.fragment),mn=r(),cs=c("p"),cs.innerHTML=zo,hn=r(),ps=c("p"),ps.innerHTML=xo,un=r(),ms=c("p"),ms.innerHTML=Go,gn=r(),hs=c("ol"),hs.innerHTML=Ro,fn=r(),us=c("p"),us.textContent=Qo,Mn=r(),gs=c("table"),gs.innerHTML=No,Tn=r(),T(Ce.$$.fragment),yn=r(),fs=c("p"),fs.innerHTML=Vo,_n=r(),Ms=c("p"),Ms.innerHTML=Xo,wn=r(),Ts=c("p"),Ts.innerHTML=Eo,bn=r(),ys=c("p"),ys.innerHTML=So,jn=r(),_s=c("ul"),_s.innerHTML=Ho,Jn=r(),ws=c("p"),ws.innerHTML=Yo,Un=r(),bs=c("p"),bs.innerHTML=Lo,kn=r(),T(Fe.$$.fragment),vn=r(),js=c("p"),js.innerHTML=Po,In=r(),Js=c("p"),Js.textContent=Do,Cn=r(),T(Ze.$$.fragment),Fn=r(),T(Us.$$.fragment),Zn=r(),T(Ae.$$.fragment),An=r(),ks=c("p"),ks.innerHTML=Oo,Bn=r(),T(vs.$$.fragment),$n=r(),Is=c("ul"),Is.innerHTML=Ko,qn=r(),T(Cs.$$.fragment),Wn=r(),Ue=c("div"),T(Fs.$$.fragment),la=r(),ct=c("p"),ct.innerHTML=el,zn=r(),T(Zs.$$.fragment),xn=r(),Y=c("div"),T(As.$$.fragment),ra=r(),pt=c("p"),pt.innerHTML=sl,ia=r(),mt=c("p"),mt.innerHTML=tl,da=r(),ht=c("p"),ht.innerHTML=nl,ca=r(),T(Be.$$.fragment),Gn=r(),T(Bs.$$.fragment),Rn=r(),G=c("div"),T($s.$$.fragment),pa=r(),ut=c("p"),ut.textContent=al,ma=r(),gt=c("p"),gt.innerHTML=ol,ha=r(),ft=c("ul"),ft.innerHTML=ll,ua=r(),Mt=c("p"),Mt.innerHTML=rl,ga=r(),$e=c("div"),T(qs.$$.fragment),fa=r(),Tt=c("p"),Tt.textContent=il,Ma=r(),Je=c("div"),T(Ws.$$.fragment),Ta=r(),yt=c("p"),yt.innerHTML=dl,ya=r(),_t=c("p"),_t.innerHTML=cl,_a=r(),wt=c("div"),T(zs.$$.fragment),Qn=r(),T(xs.$$.fragment),Nn=r(),N=c("div"),T(Gs.$$.fragment),wa=r(),bt=c("p"),bt.innerHTML=pl,ba=r(),jt=c("p"),jt.innerHTML=ml,ja=r(),Jt=c("p"),Jt.innerHTML=hl,Ja=r(),Ut=c("p"),Ut.innerHTML=ul,Ua=r(),le=c("div"),T(Rs.$$.fragment),ka=r(),kt=c("p"),kt.innerHTML=gl,va=r(),T(qe.$$.fragment),Ia=r(),T(We.$$.fragment),Vn=r(),T(Qs.$$.fragment),Xn=r(),te=c("div"),T(Ns.$$.fragment),Ca=r(),vt=c("p"),vt.innerHTML=fl,Fa=r(),It=c("p"),It.innerHTML=Ml,Za=r(),re=c("div"),T(Vs.$$.fragment),Aa=r(),Ct=c("p"),Ct.innerHTML=Tl,Ba=r(),T(ze.$$.fragment),$a=r(),T(xe.$$.fragment),En=r(),T(Xs.$$.fragment),Sn=r(),L=c("div"),T(Es.$$.fragment),qa=r(),Ft=c("p"),Ft.textContent=yl,Wa=r(),Zt=c("p"),Zt.innerHTML=_l,za=r(),At=c("p"),At.innerHTML=wl,xa=r(),ie=c("div"),T(Ss.$$.fragment),Ga=r(),Bt=c("p"),Bt.innerHTML=bl,Ra=r(),T(Ge.$$.fragment),Qa=r(),T(Re.$$.fragment),Hn=r(),T(Hs.$$.fragment),Yn=r(),P=c("div"),T(Ys.$$.fragment),Na=r(),$t=c("p"),$t.innerHTML=jl,Va=r(),qt=c("p"),qt.innerHTML=Jl,Xa=r(),Wt=c("p"),Wt.innerHTML=Ul,Ea=r(),de=c("div"),T(Ls.$$.fragment),Sa=r(),zt=c("p"),zt.innerHTML=kl,Ha=r(),T(Qe.$$.fragment),Ya=r(),T(Ne.$$.fragment),Ln=r(),T(Ps.$$.fragment),Pn=r(),V=c("div"),T(Ds.$$.fragment),La=r(),xt=c("p"),xt.textContent=vl,Pa=r(),Gt=c("p"),Gt.innerHTML=Il,Da=r(),Rt=c("p"),Rt.innerHTML=Cl,Oa=r(),T(Ve.$$.fragment),Ka=r(),ce=c("div"),T(Os.$$.fragment),eo=r(),Qt=c("p"),Qt.innerHTML=Fl,so=r(),T(Xe.$$.fragment),to=r(),T(Ee.$$.fragment),Dn=r(),T(Ks.$$.fragment),On=r(),X=c("div"),T(et.$$.fragment),no=r(),Nt=c("p"),Nt.innerHTML=Zl,ao=r(),Vt=c("p"),Vt.innerHTML=Al,oo=r(),Xt=c("p"),Xt.innerHTML=Bl,lo=r(),T(Se.$$.fragment),ro=r(),pe=c("div"),T(st.$$.fragment),io=r(),Et=c("p"),Et.innerHTML=$l,co=r(),T(He.$$.fragment),po=r(),T(Ye.$$.fragment),Kn=r(),T(tt.$$.fragment),ea=r(),E=c("div"),T(nt.$$.fragment),mo=r(),St=c("p"),St.textContent=ql,ho=r(),Ht=c("p"),Ht.innerHTML=Wl,uo=r(),Yt=c("p"),Yt.innerHTML=zl,go=r(),T(Le.$$.fragment),fo=r(),me=c("div"),T(at.$$.fragment),Mo=r(),Lt=c("p"),Lt.innerHTML=xl,To=r(),T(Pe.$$.fragment),yo=r(),T(De.$$.fragment),sa=r(),T(ot.$$.fragment),ta=r(),S=c("div"),T(lt.$$.fragment),_o=r(),Pt=c("p"),Pt.innerHTML=Gl,wo=r(),Dt=c("p"),Dt.innerHTML=Rl,bo=r(),Ot=c("p"),Ot.innerHTML=Ql,jo=r(),T(Oe.$$.fragment),Jo=r(),he=c("div"),T(rt.$$.fragment),Uo=r(),Kt=c("p"),Kt.innerHTML=Nl,ko=r(),T(Ke.$$.fragment),vo=r(),T(es.$$.fragment),na=r(),en=c("p"),this.h()},l(e){const d=Dl("svelte-u9bgzb",document.head);s=p(d,"META",{name:!0,content:!0}),d.forEach(n),m=i(e),t=p(e,"P",{}),z(t).forEach(n),a=i(e),y(f.$$.fragment,e),o=i(e),y(g.$$.fragment,e),Z=i(e),J=p(e,"P",{"data-svelte-h":!0}),u(J)!=="svelte-am6ou9"&&(J.innerHTML=v),U=i(e),C=p(e,"P",{"data-svelte-h":!0}),u(C)!=="svelte-1snuwkh"&&(C.textContent=A),W=i(e),M=p(e,"UL",{"data-svelte-h":!0}),u(M)!=="svelte-1aokkv"&&(M.innerHTML=F),I=i(e),B=p(e,"P",{"data-svelte-h":!0}),u(B)!=="svelte-1pk4od4"&&(B.textContent=Io),tn=i(e),ts=p(e,"P",{"data-svelte-h":!0}),u(ts)!=="svelte-vfdo9a"&&(ts.textContent=Co),nn=i(e),ns=p(e,"P",{"data-svelte-h":!0}),u(ns)!=="svelte-1oi615j"&&(ns.innerHTML=Fo),an=i(e),as=p(e,"P",{"data-svelte-h":!0}),u(as)!=="svelte-1fjg7gp"&&(as.innerHTML=Zo),on=i(e),Ie=p(e,"IMG",{src:!0,alt:!0,width:!0}),ln=i(e),os=p(e,"SMALL",{"data-svelte-h":!0}),u(os)!=="svelte-1fxzkn1"&&(os.innerHTML=Bo),rn=i(e),ls=p(e,"P",{"data-svelte-h":!0}),u(ls)!=="svelte-1kjfplh"&&(ls.innerHTML=$o),dn=i(e),rs=p(e,"P",{"data-svelte-h":!0}),u(rs)!=="svelte-axv494"&&(rs.textContent=qo),cn=i(e),is=p(e,"UL",{"data-svelte-h":!0}),u(is)!=="svelte-1nxvih9"&&(is.innerHTML=Wo),pn=i(e),y(ds.$$.fragment,e),mn=i(e),cs=p(e,"P",{"data-svelte-h":!0}),u(cs)!=="svelte-18597l5"&&(cs.innerHTML=zo),hn=i(e),ps=p(e,"P",{"data-svelte-h":!0}),u(ps)!=="svelte-1u8kyba"&&(ps.innerHTML=xo),un=i(e),ms=p(e,"P",{"data-svelte-h":!0}),u(ms)!=="svelte-1ew92j9"&&(ms.innerHTML=Go),gn=i(e),hs=p(e,"OL",{"data-svelte-h":!0}),u(hs)!=="svelte-tuiuxn"&&(hs.innerHTML=Ro),fn=i(e),us=p(e,"P",{"data-svelte-h":!0}),u(us)!=="svelte-qp6rba"&&(us.textContent=Qo),Mn=i(e),gs=p(e,"TABLE",{"data-svelte-h":!0}),u(gs)!=="svelte-b5t657"&&(gs.innerHTML=No),Tn=i(e),y(Ce.$$.fragment,e),yn=i(e),fs=p(e,"P",{"data-svelte-h":!0}),u(fs)!=="svelte-1lvt4t7"&&(fs.innerHTML=Vo),_n=i(e),Ms=p(e,"P",{"data-svelte-h":!0}),u(Ms)!=="svelte-11t6wp"&&(Ms.innerHTML=Xo),wn=i(e),Ts=p(e,"P",{"data-svelte-h":!0}),u(Ts)!=="svelte-pu8jy3"&&(Ts.innerHTML=Eo),bn=i(e),ys=p(e,"P",{"data-svelte-h":!0}),u(ys)!=="svelte-1nqdyw2"&&(ys.innerHTML=So),jn=i(e),_s=p(e,"UL",{"data-svelte-h":!0}),u(_s)!=="svelte-1togvt3"&&(_s.innerHTML=Ho),Jn=i(e),ws=p(e,"P",{"data-svelte-h":!0}),u(ws)!=="svelte-1e5s2fl"&&(ws.innerHTML=Yo),Un=i(e),bs=p(e,"P",{"data-svelte-h":!0}),u(bs)!=="svelte-1gz8ozq"&&(bs.innerHTML=Lo),kn=i(e),y(Fe.$$.fragment,e),vn=i(e),js=p(e,"P",{"data-svelte-h":!0}),u(js)!=="svelte-1kzns6e"&&(js.innerHTML=Po),In=i(e),Js=p(e,"P",{"data-svelte-h":!0}),u(Js)!=="svelte-t321cw"&&(Js.textContent=Do),Cn=i(e),y(Ze.$$.fragment,e),Fn=i(e),y(Us.$$.fragment,e),Zn=i(e),y(Ae.$$.fragment,e),An=i(e),ks=p(e,"P",{"data-svelte-h":!0}),u(ks)!=="svelte-6imxw1"&&(ks.innerHTML=Oo),Bn=i(e),y(vs.$$.fragment,e),$n=i(e),Is=p(e,"UL",{"data-svelte-h":!0}),u(Is)!=="svelte-1cf57f1"&&(Is.innerHTML=Ko),qn=i(e),y(Cs.$$.fragment,e),Wn=i(e),Ue=p(e,"DIV",{class:!0});var it=z(Ue);y(Fs.$$.fragment,it),la=i(it),ct=p(it,"P",{"data-svelte-h":!0}),u(ct)!=="svelte-tdj86a"&&(ct.innerHTML=el),it.forEach(n),zn=i(e),y(Zs.$$.fragment,e),xn=i(e),Y=p(e,"DIV",{class:!0});var ne=z(Y);y(As.$$.fragment,ne),ra=i(ne),pt=p(ne,"P",{"data-svelte-h":!0}),u(pt)!=="svelte-1bbvls8"&&(pt.innerHTML=sl),ia=i(ne),mt=p(ne,"P",{"data-svelte-h":!0}),u(mt)!=="svelte-1gjmgih"&&(mt.innerHTML=tl),da=i(ne),ht=p(ne,"P",{"data-svelte-h":!0}),u(ht)!=="svelte-n4fsha"&&(ht.innerHTML=nl),ca=i(ne),y(Be.$$.fragment,ne),ne.forEach(n),Gn=i(e),y(Bs.$$.fragment,e),Rn=i(e),G=p(e,"DIV",{class:!0});var Q=z(G);y($s.$$.fragment,Q),pa=i(Q),ut=p(Q,"P",{"data-svelte-h":!0}),u(ut)!=="svelte-1hmtb4d"&&(ut.textContent=al),ma=i(Q),gt=p(Q,"P",{"data-svelte-h":!0}),u(gt)!=="svelte-mwx5b3"&&(gt.innerHTML=ol),ha=i(Q),ft=p(Q,"UL",{"data-svelte-h":!0}),u(ft)!=="svelte-hp7g7u"&&(ft.innerHTML=ll),ua=i(Q),Mt=p(Q,"P",{"data-svelte-h":!0}),u(Mt)!=="svelte-1uvtk9o"&&(Mt.innerHTML=rl),ga=i(Q),$e=p(Q,"DIV",{class:!0});var dt=z($e);y(qs.$$.fragment,dt),fa=i(dt),Tt=p(dt,"P",{"data-svelte-h":!0}),u(Tt)!=="svelte-1j6vv4o"&&(Tt.textContent=il),dt.forEach(n),Ma=i(Q),Je=p(Q,"DIV",{class:!0});var ke=z(Je);y(Ws.$$.fragment,ke),Ta=i(ke),yt=p(ke,"P",{"data-svelte-h":!0}),u(yt)!=="svelte-1i7tcl5"&&(yt.innerHTML=dl),ya=i(ke),_t=p(ke,"P",{"data-svelte-h":!0}),u(_t)!=="svelte-1yeewnh"&&(_t.innerHTML=cl),ke.forEach(n),_a=i(Q),wt=p(Q,"DIV",{class:!0});var sn=z(wt);y(zs.$$.fragment,sn),sn.forEach(n),Q.forEach(n),Qn=i(e),y(xs.$$.fragment,e),Nn=i(e),N=p(e,"DIV",{class:!0});var D=z(N);y(Gs.$$.fragment,D),wa=i(D),bt=p(D,"P",{"data-svelte-h":!0}),u(bt)!=="svelte-12zn18j"&&(bt.innerHTML=pl),ba=i(D),jt=p(D,"P",{"data-svelte-h":!0}),u(jt)!=="svelte-hswkmf"&&(jt.innerHTML=ml),ja=i(D),Jt=p(D,"P",{"data-svelte-h":!0}),u(Jt)!=="svelte-1s3fxg6"&&(Jt.innerHTML=hl),Ja=i(D),Ut=p(D,"P",{"data-svelte-h":!0}),u(Ut)!=="svelte-1du13oj"&&(Ut.innerHTML=ul),Ua=i(D),le=p(D,"DIV",{class:!0});var ge=z(le);y(Rs.$$.fragment,ge),ka=i(ge),kt=p(ge,"P",{"data-svelte-h":!0}),u(kt)!=="svelte-rf0u72"&&(kt.innerHTML=gl),va=i(ge),y(qe.$$.fragment,ge),Ia=i(ge),y(We.$$.fragment,ge),ge.forEach(n),D.forEach(n),Vn=i(e),y(Qs.$$.fragment,e),Xn=i(e),te=p(e,"DIV",{class:!0});var fe=z(te);y(Ns.$$.fragment,fe),Ca=i(fe),vt=p(fe,"P",{"data-svelte-h":!0}),u(vt)!=="svelte-umae1e"&&(vt.innerHTML=fl),Fa=i(fe),It=p(fe,"P",{"data-svelte-h":!0}),u(It)!=="svelte-hswkmf"&&(It.innerHTML=Ml),Za=i(fe),re=p(fe,"DIV",{class:!0});var Me=z(re);y(Vs.$$.fragment,Me),Aa=i(Me),Ct=p(Me,"P",{"data-svelte-h":!0}),u(Ct)!=="svelte-byhdj2"&&(Ct.innerHTML=Tl),Ba=i(Me),y(ze.$$.fragment,Me),$a=i(Me),y(xe.$$.fragment,Me),Me.forEach(n),fe.forEach(n),En=i(e),y(Xs.$$.fragment,e),Sn=i(e),L=p(e,"DIV",{class:!0});var ae=z(L);y(Es.$$.fragment,ae),qa=i(ae),Ft=p(ae,"P",{"data-svelte-h":!0}),u(Ft)!=="svelte-1ez74bv"&&(Ft.textContent=yl),Wa=i(ae),Zt=p(ae,"P",{"data-svelte-h":!0}),u(Zt)!=="svelte-10y4lap"&&(Zt.innerHTML=_l),za=i(ae),At=p(ae,"P",{"data-svelte-h":!0}),u(At)!=="svelte-hswkmf"&&(At.innerHTML=wl),xa=i(ae),ie=p(ae,"DIV",{class:!0});var Te=z(ie);y(Ss.$$.fragment,Te),Ga=i(Te),Bt=p(Te,"P",{"data-svelte-h":!0}),u(Bt)!=="svelte-pwdnus"&&(Bt.innerHTML=bl),Ra=i(Te),y(Ge.$$.fragment,Te),Qa=i(Te),y(Re.$$.fragment,Te),Te.forEach(n),ae.forEach(n),Hn=i(e),y(Hs.$$.fragment,e),Yn=i(e),P=p(e,"DIV",{class:!0});var oe=z(P);y(Ys.$$.fragment,oe),Na=i(oe),$t=p(oe,"P",{"data-svelte-h":!0}),u($t)!=="svelte-5p7316"&&($t.innerHTML=jl),Va=i(oe),qt=p(oe,"P",{"data-svelte-h":!0}),u(qt)!=="svelte-10y4lap"&&(qt.innerHTML=Jl),Xa=i(oe),Wt=p(oe,"P",{"data-svelte-h":!0}),u(Wt)!=="svelte-hswkmf"&&(Wt.innerHTML=Ul),Ea=i(oe),de=p(oe,"DIV",{class:!0});var ye=z(de);y(Ls.$$.fragment,ye),Sa=i(ye),zt=p(ye,"P",{"data-svelte-h":!0}),u(zt)!=="svelte-l7mbwq"&&(zt.innerHTML=kl),Ha=i(ye),y(Qe.$$.fragment,ye),Ya=i(ye),y(Ne.$$.fragment,ye),ye.forEach(n),oe.forEach(n),Ln=i(e),y(Ps.$$.fragment,e),Pn=i(e),V=p(e,"DIV",{class:!0});var O=z(V);y(Ds.$$.fragment,O),La=i(O),xt=p(O,"P",{"data-svelte-h":!0}),u(xt)!=="svelte-a941xg"&&(xt.textContent=vl),Pa=i(O),Gt=p(O,"P",{"data-svelte-h":!0}),u(Gt)!=="svelte-1qaxm70"&&(Gt.innerHTML=Il),Da=i(O),Rt=p(O,"P",{"data-svelte-h":!0}),u(Rt)!=="svelte-1ivrf8m"&&(Rt.innerHTML=Cl),Oa=i(O),y(Ve.$$.fragment,O),Ka=i(O),ce=p(O,"DIV",{class:!0});var _e=z(ce);y(Os.$$.fragment,_e),eo=i(_e),Qt=p(_e,"P",{"data-svelte-h":!0}),u(Qt)!=="svelte-1q2ksru"&&(Qt.innerHTML=Fl),so=i(_e),y(Xe.$$.fragment,_e),to=i(_e),y(Ee.$$.fragment,_e),_e.forEach(n),O.forEach(n),Dn=i(e),y(Ks.$$.fragment,e),On=i(e),X=p(e,"DIV",{class:!0});var K=z(X);y(et.$$.fragment,K),no=i(K),Nt=p(K,"P",{"data-svelte-h":!0}),u(Nt)!=="svelte-1e80fxn"&&(Nt.innerHTML=Zl),ao=i(K),Vt=p(K,"P",{"data-svelte-h":!0}),u(Vt)!=="svelte-1qaxm70"&&(Vt.innerHTML=Al),oo=i(K),Xt=p(K,"P",{"data-svelte-h":!0}),u(Xt)!=="svelte-1ivrf8m"&&(Xt.innerHTML=Bl),lo=i(K),y(Se.$$.fragment,K),ro=i(K),pe=p(K,"DIV",{class:!0});var we=z(pe);y(st.$$.fragment,we),io=i(we),Et=p(we,"P",{"data-svelte-h":!0}),u(Et)!=="svelte-hkwnqy"&&(Et.innerHTML=$l),co=i(we),y(He.$$.fragment,we),po=i(we),y(Ye.$$.fragment,we),we.forEach(n),K.forEach(n),Kn=i(e),y(tt.$$.fragment,e),ea=i(e),E=p(e,"DIV",{class:!0});var ee=z(E);y(nt.$$.fragment,ee),mo=i(ee),St=p(ee,"P",{"data-svelte-h":!0}),u(St)!=="svelte-1ez74bv"&&(St.textContent=ql),ho=i(ee),Ht=p(ee,"P",{"data-svelte-h":!0}),u(Ht)!=="svelte-1qaxm70"&&(Ht.innerHTML=Wl),uo=i(ee),Yt=p(ee,"P",{"data-svelte-h":!0}),u(Yt)!=="svelte-1ivrf8m"&&(Yt.innerHTML=zl),go=i(ee),y(Le.$$.fragment,ee),fo=i(ee),me=p(ee,"DIV",{class:!0});var be=z(me);y(at.$$.fragment,be),Mo=i(be),Lt=p(be,"P",{"data-svelte-h":!0}),u(Lt)!=="svelte-13wemgk"&&(Lt.innerHTML=xl),To=i(be),y(Pe.$$.fragment,be),yo=i(be),y(De.$$.fragment,be),be.forEach(n),ee.forEach(n),sa=i(e),y(ot.$$.fragment,e),ta=i(e),S=p(e,"DIV",{class:!0});var se=z(S);y(lt.$$.fragment,se),_o=i(se),Pt=p(se,"P",{"data-svelte-h":!0}),u(Pt)!=="svelte-5p7316"&&(Pt.innerHTML=Gl),wo=i(se),Dt=p(se,"P",{"data-svelte-h":!0}),u(Dt)!=="svelte-1qaxm70"&&(Dt.innerHTML=Rl),bo=i(se),Ot=p(se,"P",{"data-svelte-h":!0}),u(Ot)!=="svelte-1ivrf8m"&&(Ot.innerHTML=Ql),jo=i(se),y(Oe.$$.fragment,se),Jo=i(se),he=p(se,"DIV",{class:!0});var je=z(he);y(rt.$$.fragment,je),Uo=i(je),Kt=p(je,"P",{"data-svelte-h":!0}),u(Kt)!=="svelte-fu6csi"&&(Kt.innerHTML=Nl),ko=i(je),y(Ke.$$.fragment,je),vo=i(je),y(es.$$.fragment,je),je.forEach(n),se.forEach(n),na=i(e),en=p(e,"P",{}),z(en).forEach(n),this.h()},h(){q(s,"name","hf:doc:metadata"),q(s,"content",Wr),Hl(Ie.src,Ao="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/tapas_architecture.png")||q(Ie,"src",Ao),q(Ie,"alt","drawing"),q(Ie,"width","600"),q(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,d){h(document.head,s),l(e,m,d),l(e,t,d),l(e,a,d),_(f,e,d),l(e,o,d),_(g,e,d),l(e,Z,d),l(e,J,d),l(e,U,d),l(e,C,d),l(e,W,d),l(e,M,d),l(e,I,d),l(e,B,d),l(e,tn,d),l(e,ts,d),l(e,nn,d),l(e,ns,d),l(e,an,d),l(e,as,d),l(e,on,d),l(e,Ie,d),l(e,ln,d),l(e,os,d),l(e,rn,d),l(e,ls,d),l(e,dn,d),l(e,rs,d),l(e,cn,d),l(e,is,d),l(e,pn,d),_(ds,e,d),l(e,mn,d),l(e,cs,d),l(e,hn,d),l(e,ps,d),l(e,un,d),l(e,ms,d),l(e,gn,d),l(e,hs,d),l(e,fn,d),l(e,us,d),l(e,Mn,d),l(e,gs,d),l(e,Tn,d),_(Ce,e,d),l(e,yn,d),l(e,fs,d),l(e,_n,d),l(e,Ms,d),l(e,wn,d),l(e,Ts,d),l(e,bn,d),l(e,ys,d),l(e,jn,d),l(e,_s,d),l(e,Jn,d),l(e,ws,d),l(e,Un,d),l(e,bs,d),l(e,kn,d),_(Fe,e,d),l(e,vn,d),l(e,js,d),l(e,In,d),l(e,Js,d),l(e,Cn,d),_(Ze,e,d),l(e,Fn,d),_(Us,e,d),l(e,Zn,d),_(Ae,e,d),l(e,An,d),l(e,ks,d),l(e,Bn,d),_(vs,e,d),l(e,$n,d),l(e,Is,d),l(e,qn,d),_(Cs,e,d),l(e,Wn,d),l(e,Ue,d),_(Fs,Ue,null),h(Ue,la),h(Ue,ct),l(e,zn,d),_(Zs,e,d),l(e,xn,d),l(e,Y,d),_(As,Y,null),h(Y,ra),h(Y,pt),h(Y,ia),h(Y,mt),h(Y,da),h(Y,ht),h(Y,ca),_(Be,Y,null),l(e,Gn,d),_(Bs,e,d),l(e,Rn,d),l(e,G,d),_($s,G,null),h(G,pa),h(G,ut),h(G,ma),h(G,gt),h(G,ha),h(G,ft),h(G,ua),h(G,Mt),h(G,ga),h(G,$e),_(qs,$e,null),h($e,fa),h($e,Tt),h(G,Ma),h(G,Je),_(Ws,Je,null),h(Je,Ta),h(Je,yt),h(Je,ya),h(Je,_t),h(G,_a),h(G,wt),_(zs,wt,null),l(e,Qn,d),_(xs,e,d),l(e,Nn,d),l(e,N,d),_(Gs,N,null),h(N,wa),h(N,bt),h(N,ba),h(N,jt),h(N,ja),h(N,Jt),h(N,Ja),h(N,Ut),h(N,Ua),h(N,le),_(Rs,le,null),h(le,ka),h(le,kt),h(le,va),_(qe,le,null),h(le,Ia),_(We,le,null),l(e,Vn,d),_(Qs,e,d),l(e,Xn,d),l(e,te,d),_(Ns,te,null),h(te,Ca),h(te,vt),h(te,Fa),h(te,It),h(te,Za),h(te,re),_(Vs,re,null),h(re,Aa),h(re,Ct),h(re,Ba),_(ze,re,null),h(re,$a),_(xe,re,null),l(e,En,d),_(Xs,e,d),l(e,Sn,d),l(e,L,d),_(Es,L,null),h(L,qa),h(L,Ft),h(L,Wa),h(L,Zt),h(L,za),h(L,At),h(L,xa),h(L,ie),_(Ss,ie,null),h(ie,Ga),h(ie,Bt),h(ie,Ra),_(Ge,ie,null),h(ie,Qa),_(Re,ie,null),l(e,Hn,d),_(Hs,e,d),l(e,Yn,d),l(e,P,d),_(Ys,P,null),h(P,Na),h(P,$t),h(P,Va),h(P,qt),h(P,Xa),h(P,Wt),h(P,Ea),h(P,de),_(Ls,de,null),h(de,Sa),h(de,zt),h(de,Ha),_(Qe,de,null),h(de,Ya),_(Ne,de,null),l(e,Ln,d),_(Ps,e,d),l(e,Pn,d),l(e,V,d),_(Ds,V,null),h(V,La),h(V,xt),h(V,Pa),h(V,Gt),h(V,Da),h(V,Rt),h(V,Oa),_(Ve,V,null),h(V,Ka),h(V,ce),_(Os,ce,null),h(ce,eo),h(ce,Qt),h(ce,so),_(Xe,ce,null),h(ce,to),_(Ee,ce,null),l(e,Dn,d),_(Ks,e,d),l(e,On,d),l(e,X,d),_(et,X,null),h(X,no),h(X,Nt),h(X,ao),h(X,Vt),h(X,oo),h(X,Xt),h(X,lo),_(Se,X,null),h(X,ro),h(X,pe),_(st,pe,null),h(pe,io),h(pe,Et),h(pe,co),_(He,pe,null),h(pe,po),_(Ye,pe,null),l(e,Kn,d),_(tt,e,d),l(e,ea,d),l(e,E,d),_(nt,E,null),h(E,mo),h(E,St),h(E,ho),h(E,Ht),h(E,uo),h(E,Yt),h(E,go),_(Le,E,null),h(E,fo),h(E,me),_(at,me,null),h(me,Mo),h(me,Lt),h(me,To),_(Pe,me,null),h(me,yo),_(De,me,null),l(e,sa,d),_(ot,e,d),l(e,ta,d),l(e,S,d),_(lt,S,null),h(S,_o),h(S,Pt),h(S,wo),h(S,Dt),h(S,bo),h(S,Ot),h(S,jo),_(Oe,S,null),h(S,Jo),h(S,he),_(rt,he,null),h(he,Uo),h(he,Kt),h(he,ko),_(Ke,he,null),h(he,vo),_(es,he,null),l(e,na,d),l(e,en,d),aa=!0},p(e,[d]){const it={};d&2&&(it.$$scope={dirty:d,ctx:e}),Ce.$set(it);const ne={};d&2&&(ne.$$scope={dirty:d,ctx:e}),Fe.$set(ne);const Q={};d&2&&(Q.$$scope={dirty:d,ctx:e}),Ze.$set(Q);const dt={};d&2&&(dt.$$scope={dirty:d,ctx:e}),Ae.$set(dt);const ke={};d&2&&(ke.$$scope={dirty:d,ctx:e}),Be.$set(ke);const sn={};d&2&&(sn.$$scope={dirty:d,ctx:e}),qe.$set(sn);const D={};d&2&&(D.$$scope={dirty:d,ctx:e}),We.$set(D);const ge={};d&2&&(ge.$$scope={dirty:d,ctx:e}),ze.$set(ge);const fe={};d&2&&(fe.$$scope={dirty:d,ctx:e}),xe.$set(fe);const Me={};d&2&&(Me.$$scope={dirty:d,ctx:e}),Ge.$set(Me);const ae={};d&2&&(ae.$$scope={dirty:d,ctx:e}),Re.$set(ae);const Te={};d&2&&(Te.$$scope={dirty:d,ctx:e}),Qe.$set(Te);const oe={};d&2&&(oe.$$scope={dirty:d,ctx:e}),Ne.$set(oe);const ye={};d&2&&(ye.$$scope={dirty:d,ctx:e}),Ve.$set(ye);const O={};d&2&&(O.$$scope={dirty:d,ctx:e}),Xe.$set(O);const _e={};d&2&&(_e.$$scope={dirty:d,ctx:e}),Ee.$set(_e);const K={};d&2&&(K.$$scope={dirty:d,ctx:e}),Se.$set(K);const we={};d&2&&(we.$$scope={dirty:d,ctx:e}),He.$set(we);const ee={};d&2&&(ee.$$scope={dirty:d,ctx:e}),Ye.$set(ee);const be={};d&2&&(be.$$scope={dirty:d,ctx:e}),Le.$set(be);const se={};d&2&&(se.$$scope={dirty:d,ctx:e}),Pe.$set(se);const je={};d&2&&(je.$$scope={dirty:d,ctx:e}),De.$set(je);const Vl={};d&2&&(Vl.$$scope={dirty:d,ctx:e}),Oe.$set(Vl);const Xl={};d&2&&(Xl.$$scope={dirty:d,ctx:e}),Ke.$set(Xl);const El={};d&2&&(El.$$scope={dirty:d,ctx:e}),es.$set(El)},i(e){aa||(w(f.$$.fragment,e),w(g.$$.fragment,e),w(ds.$$.fragment,e),w(Ce.$$.fragment,e),w(Fe.$$.fragment,e),w(Ze.$$.fragment,e),w(Us.$$.fragment,e),w(Ae.$$.fragment,e),w(vs.$$.fragment,e),w(Cs.$$.fragment,e),w(Fs.$$.fragment,e),w(Zs.$$.fragment,e),w(As.$$.fragment,e),w(Be.$$.fragment,e),w(Bs.$$.fragment,e),w($s.$$.fragment,e),w(qs.$$.fragment,e),w(Ws.$$.fragment,e),w(zs.$$.fragment,e),w(xs.$$.fragment,e),w(Gs.$$.fragment,e),w(Rs.$$.fragment,e),w(qe.$$.fragment,e),w(We.$$.fragment,e),w(Qs.$$.fragment,e),w(Ns.$$.fragment,e),w(Vs.$$.fragment,e),w(ze.$$.fragment,e),w(xe.$$.fragment,e),w(Xs.$$.fragment,e),w(Es.$$.fragment,e),w(Ss.$$.fragment,e),w(Ge.$$.fragment,e),w(Re.$$.fragment,e),w(Hs.$$.fragment,e),w(Ys.$$.fragment,e),w(Ls.$$.fragment,e),w(Qe.$$.fragment,e),w(Ne.$$.fragment,e),w(Ps.$$.fragment,e),w(Ds.$$.fragment,e),w(Ve.$$.fragment,e),w(Os.$$.fragment,e),w(Xe.$$.fragment,e),w(Ee.$$.fragment,e),w(Ks.$$.fragment,e),w(et.$$.fragment,e),w(Se.$$.fragment,e),w(st.$$.fragment,e),w(He.$$.fragment,e),w(Ye.$$.fragment,e),w(tt.$$.fragment,e),w(nt.$$.fragment,e),w(Le.$$.fragment,e),w(at.$$.fragment,e),w(Pe.$$.fragment,e),w(De.$$.fragment,e),w(ot.$$.fragment,e),w(lt.$$.fragment,e),w(Oe.$$.fragment,e),w(rt.$$.fragment,e),w(Ke.$$.fragment,e),w(es.$$.fragment,e),aa=!0)},o(e){b(f.$$.fragment,e),b(g.$$.fragment,e),b(ds.$$.fragment,e),b(Ce.$$.fragment,e),b(Fe.$$.fragment,e),b(Ze.$$.fragment,e),b(Us.$$.fragment,e),b(Ae.$$.fragment,e),b(vs.$$.fragment,e),b(Cs.$$.fragment,e),b(Fs.$$.fragment,e),b(Zs.$$.fragment,e),b(As.$$.fragment,e),b(Be.$$.fragment,e),b(Bs.$$.fragment,e),b($s.$$.fragment,e),b(qs.$$.fragment,e),b(Ws.$$.fragment,e),b(zs.$$.fragment,e),b(xs.$$.fragment,e),b(Gs.$$.fragment,e),b(Rs.$$.fragment,e),b(qe.$$.fragment,e),b(We.$$.fragment,e),b(Qs.$$.fragment,e),b(Ns.$$.fragment,e),b(Vs.$$.fragment,e),b(ze.$$.fragment,e),b(xe.$$.fragment,e),b(Xs.$$.fragment,e),b(Es.$$.fragment,e),b(Ss.$$.fragment,e),b(Ge.$$.fragment,e),b(Re.$$.fragment,e),b(Hs.$$.fragment,e),b(Ys.$$.fragment,e),b(Ls.$$.fragment,e),b(Qe.$$.fragment,e),b(Ne.$$.fragment,e),b(Ps.$$.fragment,e),b(Ds.$$.fragment,e),b(Ve.$$.fragment,e),b(Os.$$.fragment,e),b(Xe.$$.fragment,e),b(Ee.$$.fragment,e),b(Ks.$$.fragment,e),b(et.$$.fragment,e),b(Se.$$.fragment,e),b(st.$$.fragment,e),b(He.$$.fragment,e),b(Ye.$$.fragment,e),b(tt.$$.fragment,e),b(nt.$$.fragment,e),b(Le.$$.fragment,e),b(at.$$.fragment,e),b(Pe.$$.fragment,e),b(De.$$.fragment,e),b(ot.$$.fragment,e),b(lt.$$.fragment,e),b(Oe.$$.fragment,e),b(rt.$$.fragment,e),b(Ke.$$.fragment,e),b(es.$$.fragment,e),aa=!1},d(e){e&&(n(m),n(t),n(a),n(o),n(Z),n(J),n(U),n(C),n(W),n(M),n(I),n(B),n(tn),n(ts),n(nn),n(ns),n(an),n(as),n(on),n(Ie),n(ln),n(os),n(rn),n(ls),n(dn),n(rs),n(cn),n(is),n(pn),n(mn),n(cs),n(hn),n(ps),n(un),n(ms),n(gn),n(hs),n(fn),n(us),n(Mn),n(gs),n(Tn),n(yn),n(fs),n(_n),n(Ms),n(wn),n(Ts),n(bn),n(ys),n(jn),n(_s),n(Jn),n(ws),n(Un),n(bs),n(kn),n(vn),n(js),n(In),n(Js),n(Cn),n(Fn),n(Zn),n(An),n(ks),n(Bn),n($n),n(Is),n(qn),n(Wn),n(Ue),n(zn),n(xn),n(Y),n(Gn),n(Rn),n(G),n(Qn),n(Nn),n(N),n(Vn),n(Xn),n(te),n(En),n(Sn),n(L),n(Hn),n(Yn),n(P),n(Ln),n(Pn),n(V),n(Dn),n(On),n(X),n(Kn),n(ea),n(E),n(sa),n(ta),n(S),n(na),n(en)),n(s),j(f,e),j(g,e),j(ds,e),j(Ce,e),j(Fe,e),j(Ze,e),j(Us,e),j(Ae,e),j(vs,e),j(Cs,e),j(Fs),j(Zs,e),j(As),j(Be),j(Bs,e),j($s),j(qs),j(Ws),j(zs),j(xs,e),j(Gs),j(Rs),j(qe),j(We),j(Qs,e),j(Ns),j(Vs),j(ze),j(xe),j(Xs,e),j(Es),j(Ss),j(Ge),j(Re),j(Hs,e),j(Ys),j(Ls),j(Qe),j(Ne),j(Ps,e),j(Ds),j(Ve),j(Os),j(Xe),j(Ee),j(Ks,e),j(et),j(Se),j(st),j(He),j(Ye),j(tt,e),j(nt),j(Le),j(at),j(Pe),j(De),j(ot,e),j(lt),j(Oe),j(rt),j(Ke),j(es)}}}const Wr='{"title":"TAPAS","local":"tapas","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage: fine-tuning","local":"usage-fine-tuning","sections":[],"depth":2},{"title":"Usage: inference","local":"usage-inference","sections":[],"depth":2},{"title":"Documentation resources","local":"documentation-resources","sections":[],"depth":2},{"title":"TAPAS specific outputs","local":"transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput","sections":[],"depth":2},{"title":"TapasConfig","local":"transformers.TapasConfig","sections":[],"depth":2},{"title":"TapasTokenizer","local":"transformers.TapasTokenizer","sections":[],"depth":2},{"title":"TapasModel","local":"transformers.TapasModel","sections":[],"depth":2},{"title":"TapasForMaskedLM","local":"transformers.TapasForMaskedLM","sections":[],"depth":2},{"title":"TapasForSequenceClassification","local":"transformers.TapasForSequenceClassification","sections":[],"depth":2},{"title":"TapasForQuestionAnswering","local":"transformers.TapasForQuestionAnswering","sections":[],"depth":2},{"title":"TFTapasModel","local":"transformers.TFTapasModel","sections":[],"depth":2},{"title":"TFTapasForMaskedLM","local":"transformers.TFTapasForMaskedLM","sections":[],"depth":2},{"title":"TFTapasForSequenceClassification","local":"transformers.TFTapasForSequenceClassification","sections":[],"depth":2},{"title":"TFTapasForQuestionAnswering","local":"transformers.TFTapasForQuestionAnswering","sections":[],"depth":2}],"depth":1}';function zr(k){return Yl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Sr extends Ll{constructor(s){super(),Pl(this,s,zr,qr,Sl,{})}}export{Sr as component};
