import{s as aw,o as iw,n as U}from"../chunks/scheduler.9bc65507.js";import{S as cw,i as lw,g as r,s,r as l,A as dw,h as a,f as n,c as o,j as _,u as d,x as y,k as b,y as t,a as c,v as p,d as m,t as g,w as u}from"../chunks/index.707bf1b6.js";import{T as qn}from"../chunks/Tip.c2ecdbf4.js";import{D as T}from"../chunks/Docstring.17db21ae.js";import{C}from"../chunks/CodeBlock.54a9f38d.js";import{E as G}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as X}from"../chunks/Heading.342b1fa6.js";function pw(M){let f,x="Examples:",$,v,w;return v=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBzZXF1ZW5jZSUzQSUyMDElMkMlMjAyJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBpcyUyMHVuZXhwZWN0ZWQlMjAtLSUyMHNvbWV0aW1lcyUyMHRvbyUyMHVuZXhwZWN0ZWQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMFdpdGglMjBlcHNpbG9uJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBnZXRzJTIwcmVzdHJpY3RlZCUyMHRvJTIwaGlnaC1wcm9iYWJpbGl0eSUyMHRva2Vucy4lMjBOb3RlJTIwdGhhdCUyMHRoaXMlMjBpcyUyMHNpbWlsYXIlMjB0byUwQSUyMyUyMFRvcCUyMFAlMjBzYW1wbGluZyUyQyUyMHdoaWNoJTIwcmVzdHJpY3RzJTIwdG9rZW5zJTIwYmFzZWQlMjBvbiUyMHRoZWlyJTIwY3VtdWxhdGl2ZSUyMHByb2JhYmlsaXR5LiUwQSUyMyUyMFBybyUyMHRpcCUzQSUyMFRoZSUyMHBhcGVyJTIwcmVjb21lbmRzJTIwdXNpbmclMjAlNjBlcHNpbG9uX2N1dG9mZiU2MCUyMHZhbHVlcyUyMGJldHdlZW4lMjAzZS00JTIwYW5kJTIwOWUtNCUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBlcHNpbG9uX2N1dG9mZiUzRDAuMSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2.</span> <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With epsilon sampling, the output gets restricted to high-probability tokens. Note that this is similar to</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Top P sampling, which restricts tokens based on their cumulative probability.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: The paper recomends using \`epsilon_cutoff\` values between 3e-4 and 9e-4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, epsilon_cutoff=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){f=r("p"),f.textContent=x,$=s(),l(v.$$.fragment)},l(h){f=a(h,"P",{"data-svelte-h":!0}),y(f)!=="svelte-kvfsh7"&&(f.textContent=x),$=o(h),d(v.$$.fragment,h)},m(h,k){c(h,f,k),c(h,$,k),p(v,h,k),w=!0},p:U,i(h){w||(m(v.$$.fragment,h),w=!0)},o(h){g(v.$$.fragment,h),w=!1},d(h){h&&(n(f),n($)),u(v,h)}}}function mw(M){let f,x="Examples:",$,v,w;return v=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBzZXF1ZW5jZSUzQSUyMDElMkMlMjAyJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBpcyUyMHVuZXhwZWN0ZWQlMjAtLSUyMHNvbWV0aW1lcyUyMHRvbyUyMHVuZXhwZWN0ZWQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMFdpdGglMjBldGElMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGdldHMlMjByZXN0cmljdGVkJTIwdG8lMjBoaWdoLXByb2JhYmlsaXR5JTIwdG9rZW5zLiUyMFlvdSUyMGNhbiUyMHNlZSUyMGl0JTIwYXMlMjBhJTIwZHluYW1pYyUyMGZvcm0lMjBvZiUwQSUyMyUyMGVwc2lsb24lMjBzYW1wbGluZyUyMHRoYXQlMjBhZGFwdHMlMjBpdHMlMjBjdXRvZmYlMjBwcm9iYWJpbGl0eSUyMGJhc2VkJTIwb24lMjB0aGUlMjBlbnRyb3B5JTIwKGhpZ2glMjBlbnRyb3B5JTIwJTNEJTIwbG93ZXIlMjBjdXRvZmYpLiUwQSUyMyUyMFBybyUyMHRpcCUzQSUyMFRoZSUyMHBhcGVyJTIwcmVjb21lbmRzJTIwdXNpbmclMjAlNjBldGFfY3V0b2ZmJTYwJTIwdmFsdWVzJTIwYmV0d2VlbiUyMDNlLTQlMjB0byUyMDRlLTMlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwZXRhX2N1dG9mZiUzRDAuMSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2.</span> <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With eta sampling, the output gets restricted to high-probability tokens. You can see it as a dynamic form of</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># epsilon sampling that adapts its cutoff probability based on the entropy (high entropy = lower cutoff).</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: The paper recomends using \`eta_cutoff\` values between 3e-4 to 4e-3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, eta_cutoff=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){f=r("p"),f.textContent=x,$=s(),l(v.$$.fragment)},l(h){f=a(h,"P",{"data-svelte-h":!0}),y(f)!=="svelte-kvfsh7"&&(f.textContent=x),$=o(h),d(v.$$.fragment,h)},m(h,k){c(h,f,k),c(h,$,k),p(v,h,k),w=!0},p:U,i(h){w||(m(v.$$.fragment,h),w=!0)},o(h){g(v.$$.fragment,h),w=!1},d(h){h&&(n(f),n($)),u(v,h)}}}function gw(M){let f,x="Examples:",$,v,w;return v=new C({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;Just wanted to let you know, I&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate sequences without exponential penalty. We want short sentences, so we limit max_length=30</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># see that the answer tends to end abruptly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.9</span>, max_length=<span class="hljs-number">30</span>, pad_token_id=<span class="hljs-number">50256</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I<span class="hljs-string">&#x27;m not even a lawyer. I&#x27;</span>m a man. I have no real knowledge of politics. I<span class="hljs-string">&#x27;m a

&gt;&gt;&gt; # Generate sequences with exponential penalty, we add the exponential_decay_length_penalty=(start_index, decay_factor)
&gt;&gt;&gt; # We see that instead of cutting at max_tokens, the output comes to an end before (at 25 tokens) and with more meaning
&gt;&gt;&gt; # What happens is that starting from \`start_index\` the EOS token score will be increased by decay_factor exponentially
&gt;&gt;&gt; outputs = model.generate(
...     **inputs,
...     do_sample=True,
...     temperature=0.9,
...     max_length=30,
...     pad_token_id=50256,
...     exponential_decay_length_penalty=(15, 1.6),
... )
&gt;&gt;&gt; print(tokenizer.batch_decode(outputs)[0])
Just wanted to let you know, I&#x27;</span>ve got a very cool t-shirt educating people on how to use the Internet&lt;|endoftext|&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate sequences with smaller decay_factor, still improving the hard cutoff mid-sentence</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.9</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    pad_token_id=<span class="hljs-number">50256</span>,
<span class="hljs-meta">... </span>    exponential_decay_length_penalty=(<span class="hljs-number">15</span>, <span class="hljs-number">1.05</span>),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I<span class="hljs-string">&#x27;ve been working on it for about 6 months and now it&#x27;</span>s <span class="hljs-keyword">in</span> Alpha.&lt;|endoftext|&gt;`,wrap:!1}}),{c(){f=r("p"),f.textContent=x,$=s(),l(v.$$.fragment)},l(h){f=a(h,"P",{"data-svelte-h":!0}),y(f)!=="svelte-kvfsh7"&&(f.textContent=x),$=o(h),d(v.$$.fragment,h)},m(h,k){c(h,f,k),c(h,$,k),p(v,h,k),w=!0},p:U,i(h){w||(m(v.$$.fragment,h),w=!0)},o(h){g(v.$$.fragment,h),w=!1},d(h){h&&(n(f),n($)),u(v,h)}}}function uw(M){let f,x=`Diverse beam search can be particularly useful in scenarios where a variety of different outputs is desired, rather
than multiple similar sequences. It allows the model to explore different generation paths and provides a broader
coverage of possible outputs.`;return{c(){f=r("p"),f.textContent=x},l($){f=a($,"P",{"data-svelte-h":!0}),y(f)!=="svelte-xttj3z"&&(f.textContent=x)},m($,v){c($,f,v)},p:U,d($){$&&n(f)}}}function hw(M){let f,x="This logits processor can be resource-intensive, especially when using large models or long sequences.";return{c(){f=r("p"),f.textContent=x},l($){f=a($,"P",{"data-svelte-h":!0}),y(f)!=="svelte-6lf7c0"&&(f.textContent=x)},m($,v){c($,f,v)},p:U,d($){$&&n(f)}}}function fw(M){let f,x="Examples:",$,v,w;return v=new C({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initialize the model and tokenizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># A long text about the solar system</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;The Solar System is a gravitationally bound system comprising the Sun and the objects that orbit it, either directly or indirectly. Of the objects that orbit the Sun directly, the largest are the eight planets, with the remainder being smaller objects, such as the five dwarf planets and small Solar System bodies. The Solar System formed 4.6 billion years ago from the gravitational collapse of a giant interstellar molecular cloud.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;summarize: &quot;</span> + text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate diverse summary</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs_diverse = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    num_beam_groups=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    diversity_penalty=<span class="hljs-number">10.0</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summaries_diverse = tokenizer.batch_decode(outputs_diverse, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate non-diverse summary</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs_non_diverse = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_non_diverse = tokenizer.batch_decode(outputs_non_diverse, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`diversity_penalty\`, the resulting beams are much more diverse</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(summary_non_diverse)
[<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>,
<span class="hljs-string">&#x27;the Solar System formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(summaries_diverse)
[<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>,
<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets. the rest of the objects are smaller objects, such as the five dwarf planets and small solar system bodies.&#x27;</span>]`,wrap:!1}}),{c(){f=r("p"),f.textContent=x,$=s(),l(v.$$.fragment)},l(h){f=a(h,"P",{"data-svelte-h":!0}),y(f)!=="svelte-kvfsh7"&&(f.textContent=x),$=o(h),d(v.$$.fragment,h)},m(h,k){c(h,f,k),c(h,$,k),p(v,h,k),w=!0},p:U,i(h){w||(m(v.$$.fragment,h),w=!0)},o(h){g(v.$$.fragment,h),w=!1},d(h){h&&(n(f),n($)),u(v,h)}}}function _w(M){let f,x="Examples:",$,v,w;return v=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsZ3B0MiUyMiklMEFtb2RlbC5jb25maWcucGFkX3Rva2VuX2lkJTIwJTNEJTIwbW9kZWwuY29uZmlnLmVvc190b2tlbl9pZCUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJIdWdnaW5nJTIwRmFjZSUyMENvbXBhbnklMjBpcyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwSWYlMjB0aGUlMjBtYXhpbXVtJTIwbGVuZ3RoJTIwKGRlZmF1bHQlMjAlM0QlMjAyMCklMjBpcyUyMHNtYWxsZXIlMjB0aGFuJTIwdGhlJTIwbWluaW11bSUyMGxlbmd0aCUyMGNvbnN0cmFpbnQlMkMlMjB0aGUlMjBsYXR0ZXIlMjBpcyUyMGlnbm9yZWQhJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWluX25ld190b2tlbnMlM0QzMCklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dHMlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKSUwQSUwQSUyMyUyMEZvciUyMHRlc3RpbmclMjBwdXJwb3NlcyUyQyUyMGxldCdzJTIwc2V0JTIwJTYwZW9zX3Rva2VuJTYwJTIwdG8lMjAlNjAlMjJjb21wYW55JTIyJTYwJTJDJTIwdGhlJTIwZmlyc3QlMjBnZW5lcmF0ZWQlMjB0b2tlbi4lMjBUaGlzJTIwd2lsbCUyMG1ha2UlMEElMjMlMjBnZW5lcmF0aW9uJTIwZW5kJTIwdGhlcmUuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZW9zX3Rva2VuX2lkJTNEMTY2NCklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dHMlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKSUwQSUwQSUyMyUyMEluY3JlYXNpbmclMjAlNjBtaW5fbmV3X3Rva2VucyU2MCUyMHdpbGwlMjBtYWtlJTIwZ2VuZXJhdGlvbiUyMGlnbm9yZSUyMG9jY3VyZW5jZXMlMjAlNjAlMjJjb21wYW55JTIyJTYwJTIwKGVvcyUyMHRva2VuKSUyMGJlZm9yZSUyMHRoZSUwQSUyMyUyMG1pbmltdW0lMjBsZW5ndGglMjBjb25kaXRpb24lMjBpcyUyMGhvbm9yZWQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWluX25ld190b2tlbnMlM0QyJTJDJTIwZW9zX3Rva2VuX2lkJTNEMTY2NCklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dHMlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Hugging Face Company is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If the maximum length (default = 20) is smaller than the minimum length constraint, the latter is ignored!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, min_new_tokens=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Hugging Face Company <span class="hljs-keyword">is</span> a company that has been working on a new product <span class="hljs-keyword">for</span> the past year.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For testing purposes, let&#x27;s set \`eos_token\` to \`&quot;company&quot;\`, the first generated token. This will make</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># generation end there.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, eos_token_id=<span class="hljs-number">1664</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Hugging Face Company <span class="hljs-keyword">is</span> a company

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Increasing \`min_new_tokens\` will make generation ignore occurences \`&quot;company&quot;\` (eos token) before the</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># minimum length condition is honored.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, min_new_tokens=<span class="hljs-number">2</span>, eos_token_id=<span class="hljs-number">1664</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Hugging Face Company <span class="hljs-keyword">is</span> a new company`,wrap:!1}}),{c(){f=r("p"),f.textContent=x,$=s(),l(v.$$.fragment)},l(h){f=a(h,"P",{"data-svelte-h":!0}),y(f)!=="svelte-kvfsh7"&&(f.textContent=x),$=o(h),d(v.$$.fragment,h)},m(h,k){c(h,f,k),c(h,$,k),p(v,h,k),w=!0},p:U,i(h){w||(m(v.$$.fragment,h),w=!0)},o(h){g(v.$$.fragment,h),w=!1},d(h){h&&(n(f),n($)),u(v,h)}}}function bw(M){let f,x=`In order to get the token ids of the words that should not appear in the generated text, make sure to set
<code>add_prefix_space=True</code> when initializing the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The <code>add_prefix_space</code> argument is only supported for some slow tokenizers,
as fast tokenizers’ prefixing behaviours come from <code>pre tokenizers</code>. Read more
<a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`;return{c(){f=r("p"),f.innerHTML=x},l($){f=a($,"P",{"data-svelte-h":!0}),y(f)!=="svelte-15bvr1j"&&(f.innerHTML=x)},m($,v){c($,f,v)},p:U,d($){$&&n(f)}}}function Tw(M){let f,x="Examples:",$,v,w;return v=new C({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;In a word, the cake is a&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">5</span>, pad_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(output_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a mess.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s take the bad words out. Please note that the tokenizer is initialized differently</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_with_prefix_space = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens_as_list</span>(<span class="hljs-params">word_list</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Converts a sequence of words into a list of tokens&quot;</span>
<span class="hljs-meta">... </span>    tokens_list = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_list:
<span class="hljs-meta">... </span>        tokenized_word = tokenizer_with_prefix_space([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>        tokens_list.append(tokenized_word)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokens_list


<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = get_tokens_as_list(word_list=[<span class="hljs-string">&quot;mess&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>output_ids = model.generate(
<span class="hljs-meta">... </span>    inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">5</span>, bad_words_ids=bad_words_ids, pad_token_id=tokenizer.eos_token_id
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(output_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a surprise.`,wrap:!1}}),{c(){f=r("p"),f.textContent=x,$=s(),l(v.$$.fragment)},l(h){f=a(h,"P",{"data-svelte-h":!0}),y(f)!=="svelte-kvfsh7"&&(f.textContent=x),$=o(h),d(v.$$.fragment,h)},m(h,k){c(h,f,k),c(h,$,k),p(v,h,k),w=!0},p:U,i(h){w||(m(v.$$.fragment,h),w=!0)},o(h){g(v.$$.fragment,h),w=!1},d(h){h&&(n(f),n($)),u(v,h)}}}function yw(M){let f,x=`Use n-gram penalties with care. For instance, penalizing 2-grams (bigrams) in an article about the city of New York
might lead to undesirable outcomes where the city’s name appears only once in the entire text.
<a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">Reference</a>`;return{c(){f=r("p"),f.innerHTML=x},l($){f=a($,"P",{"data-svelte-h":!0}),y(f)!=="svelte-5zfsi9"&&(f.innerHTML=x)},m($,v){c($,f,v)},p:U,d($){$&&n(f)}}}function vw(M){let f,x="Examples:",$,v,w;return v=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyVG9kYXklMjBJJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dCU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkpJTBBJTBBJTIzJTIwTm93JTIwbGV0J3MlMjBhZGQlMjBuZ3JhbSUyMHNpemUlMjB1c2luZyUyMCU2MG5vX3JlcGVhdF9uZ3JhbV9zaXplJTYwLiUyMFRoaXMlMjBzdG9wcyUyMHRoZSUyMHJlcGV0aXRpb25zJTIwKCUyMkklRTIlODAlOTltJTIyKSUyMGluJTIwdGhlJTIwb3V0cHV0LiUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbm9fcmVwZWF0X25ncmFtX3NpemUlM0QyKSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0JTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today I&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Today I’m <span class="hljs-keyword">not</span> sure <span class="hljs-keyword">if</span> I’m going to be able to do it.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s add ngram size using \`no_repeat_ngram_size\`. This stops the repetitions (&quot;I’m&quot;) in the output.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs, no_repeat_ngram_size=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Today I’m <span class="hljs-keyword">not</span> sure <span class="hljs-keyword">if</span> I can get a better understanding of the nature of this issue`,wrap:!1}}),{c(){f=r("p"),f.textContent=x,$=s(),l(v.$$.fragment)},l(h){f=a(h,"P",{"data-svelte-h":!0}),y(f)!=="svelte-kvfsh7"&&(f.textContent=x),$=o(h),d(v.$$.fragment,h)},m(h,k){c(h,f,k),c(h,$,k),p(v,h,k),w=!0},p:U,i(h){w||(m(v.$$.fragment,h),w=!0)},o(h){g(v.$$.fragment,h),w=!1},d(h){h&&(n(f),n($)),u(v,h)}}}function $w(M){let f,x="Examples:",$,v,w;return v=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMHRoZSUyMG1vZGVsJTIwYW5kJTIwdG9rZW5pemVyJTIwZm9yJTIwaXQlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkknbSUyMG5vdCUyMGdvaW5nJTIwdG8lMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFRoaXMlMjBzaG93cyUyMGElMjBub3JtYWwlMjBnZW5lcmF0ZSUyMHdpdGhvdXQlMjBhbnklMjBzcGVjaWZpYyUyMHBhcmFtZXRlcnMlMEFzdW1tYXJ5X2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUoc3VtbWFyeV9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMFRoaXMlMjBnZW5lcmF0ZXMlMjBhJTIwcGVuYWx0eSUyMGZvciUyMHJlcGVhdGVkJTIwdG9rZW5zJTBBcGVuYWxpemVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwcmVwZXRpdGlvbl9wZW5hbHR5JTNEMS4xKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUocGVuYWxpemVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing the model and tokenizer for it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;I&#x27;m not going to&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This shows a normal generate without any specific parameters</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to be able to do that. I&#x27;</span>m going to be able to do that

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This generates a penalty for repeated tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>penalized_ids = model.generate(**inputs, repetition_penalty=<span class="hljs-number">1.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(penalized_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to be able to do that. I&#x27;</span>ll just have to go out <span class="hljs-keyword">and</span> play`,wrap:!1}}),{c(){f=r("p"),f.textContent=x,$=s(),l(v.$$.fragment)},l(h){f=a(h,"P",{"data-svelte-h":!0}),y(f)!=="svelte-kvfsh7"&&(f.textContent=x),$=o(h),d(v.$$.fragment,h)},m(h,k){c(h,f,k),c(h,$,k),p(v,h,k),w=!0},p:U,i(h){w||(m(v.$$.fragment,h),w=!0)},o(h){g(v.$$.fragment,h),w=!1},d(h){h&&(n(f),n($)),u(v,h)}}}function ww(M){let f,x=`In order to get the token ids of the sequences that you want to bias, make sure to set <code>add_prefix_space=True</code> when
initializing the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The
<code>add_prefix_space</code> argument is only supported for some slow tokenizers, as fast tokenizers’ prefixing behaviours
come from <code>pre tokenizers</code>. Read more <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`;return{c(){f=r("p"),f.innerHTML=x},l($){f=a($,"P",{"data-svelte-h":!0}),y(f)!=="svelte-16cusgy"&&(f.innerHTML=x)},m($,v){c($,f,v)},p:U,d($){$&&n(f)}}}function xw(M){let f,x="Examples:",$,v,w;return v=new C({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;The full name of Donald is Donald&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald J. Trump Jr

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s control generation through a bias. Please note that the tokenizer is initialized differently!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_with_prefix_space = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens_as_tuple</span>(<span class="hljs-params">word</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> <span class="hljs-built_in">tuple</span>(tokenizer_with_prefix_space([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>])


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we add a negative bias without beam search, it may become &quot;stuck&quot; in a prefix without good continuations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = {get_tokens_as_tuple(<span class="hljs-string">&quot;Trump&quot;</span>): -<span class="hljs-number">10.0</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald J. Donald,

<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, num_beams=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald Rumsfeld,

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can also add a positive bias to nudge the model towards specific tokens or continuations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = {get_tokens_as_tuple(<span class="hljs-string">&quot;Donald Duck&quot;</span>): <span class="hljs-number">10.0</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, num_beams=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald Duck.`,wrap:!1}}),{c(){f=r("p"),f.textContent=x,$=s(),l(v.$$.fragment)},l(h){f=a(h,"P",{"data-svelte-h":!0}),y(f)!=="svelte-kvfsh7"&&(f.textContent=x),$=o(h),d(v.$$.fragment,h)},m(h,k){c(h,f,k),c(h,$,k),p(v,h,k),w=!0},p:U,i(h){w||(m(v.$$.fragment,h),w=!0)},o(h){g(v.$$.fragment,h),w=!1},d(h){h&&(n(f),n($)),u(v,h)}}}function kw(M){let f,x=`Make sure that <code>do_sample=True</code> is included in the <code>generate</code> arguments otherwise the temperature value won’t have
any effect.`;return{c(){f=r("p"),f.innerHTML=x},l($){f=a($,"P",{"data-svelte-h":!0}),y(f)!=="svelte-1byeoum"&&(f.innerHTML=x)},m($,v){c($,f,v)},p:U,d($){$&&n(f)}}}function Mw(M){let f,x="Examples:",$,v,w;return v=new C({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwc2V0X3NlZWQlMEElMEFzZXRfc2VlZCgwKSUyMCUyMCUyMyUyMGZvciUyMHJlcHJvZHVjaWJpbGl0eSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFtb2RlbC5jb25maWcucGFkX3Rva2VuX2lkJTIwJTNEJTIwbW9kZWwuY29uZmlnLmVvc190b2tlbl9pZCUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJIdWdnaW5nJTIwRmFjZSUyMENvbXBhbnklMjBpcyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2l0aCUyMHRlbXBlcmF0dXJlJTNEMS4wJTJDJTIwdGhlJTIwZGVmYXVsdCUyQyUyMHdlJTIwY29uc2lzdGVudGx5JTIwZ2V0JTIwcmFuZG9tJTIwb3V0cHV0cyUyMGR1ZSUyMHRvJTIwcmFuZG9tJTIwc2FtcGxpbmcuJTBBZ2VuZXJhdGVfa3dhcmdzJTIwJTNEJTIwJTdCJTIybWF4X25ld190b2tlbnMlMjIlM0ElMjAxMCUyQyUyMCUyMmRvX3NhbXBsZSUyMiUzQSUyMFRydWUlMkMlMjAlMjJ0ZW1wZXJhdHVyZSUyMiUzQSUyMDEuMCUyQyUyMCUyMm51bV9yZXR1cm5fc2VxdWVuY2VzJTIyJTNBJTIwMiU3RCUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMCoqZ2VuZXJhdGVfa3dhcmdzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElMEElMjMlMjBIb3dldmVyJTJDJTIwd2l0aCUyMHRlbXBlcmF0dXJlJTIwY2xvc2UlMjB0byUyMDAlMkMlMjBpdCUyMGFwcHJveGltYXRlcyUyMGdyZWVkeSUyMGRlY29kaW5nJTIwc3RyYXRlZ2llcyUyMChpbnZhcmlhbnQpJTBBZ2VuZXJhdGVfa3dhcmdzJTVCJTIydGVtcGVyYXR1cmUlMjIlNUQlMjAlM0QlMjAwLjAwMDElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjAqKmdlbmVyYXRlX2t3YXJncyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)  <span class="hljs-comment"># for reproducibility</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Hugging Face Company is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With temperature=1.0, the default, we consistently get random outputs due to random sampling.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_kwargs = {<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">10</span>, <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">1.0</span>, <span class="hljs-string">&quot;num_return_sequences&quot;</span>: <span class="hljs-number">2</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, **generate_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Hugging Face Company is a joint venture between GEO Group, one of&#x27;</span>,
<span class="hljs-string">&#x27;Hugging Face Company is not an exact science – but what we believe does&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># However, with temperature close to 0, it approximates greedy decoding strategies (invariant)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_kwargs[<span class="hljs-string">&quot;temperature&quot;</span>] = <span class="hljs-number">0.0001</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, **generate_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Hugging Face Company is a company that has been around for over 20 years&#x27;</span>,
<span class="hljs-string">&#x27;Hugging Face Company is a company that has been around for over 20 years&#x27;</span>]`,wrap:!1}}),{c(){f=r("p"),f.textContent=x,$=s(),l(v.$$.fragment)},l(h){f=a(h,"P",{"data-svelte-h":!0}),y(f)!=="svelte-kvfsh7"&&(f.textContent=x),$=o(h),d(v.$$.fragment,h)},m(h,k){c(h,f,k),c(h,$,k),p(v,h,k),w=!0},p:U,i(h){w||(m(v.$$.fragment,h),w=!0)},o(h){g(v.$$.fragment,h),w=!1},d(h){h&&(n(f),n($)),u(v,h)}}}function jw(M){let f,x="Examples:",$,v,w;return v=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBzZXF1ZW5jZSUzQSUyMDElMkMlMjAyJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBpcyUyMHVuZXhwZWN0ZWQlMjAtLSUyMHNvbWV0aW1lcyUyMHRvbyUyMHVuZXhwZWN0ZWQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMFdpdGglMjAlNjB0b3BfcCU2MCUyMHNhbXBsaW5nJTJDJTIwdGhlJTIwb3V0cHV0JTIwZ2V0cyUyMHJlc3RyaWN0ZWQlMjB0byUyMGhpZ2gtcHJvYmFiaWxpdHklMjB0b2tlbnMuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwSW4lMjBwcmFjdGljZSUyQyUyMExMTXMlMjB1c2UlMjAlNjB0b3BfcCU2MCUyMGluJTIwdGhlJTIwMC45LTAuOTUlMjByYW5nZS4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwdG9wX3AlM0QwLjEpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2.</span> <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`top_p\` sampling, the output gets restricted to high-probability tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`top_p\` in the 0.9-0.95 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){f=r("p"),f.textContent=x,$=s(),l(v.$$.fragment)},l(h){f=a(h,"P",{"data-svelte-h":!0}),y(f)!=="svelte-kvfsh7"&&(f.textContent=x),$=o(h),d(v.$$.fragment,h)},m(h,k){c(h,f,k),c(h,$,k),p(v,h,k),w=!0},p:U,i(h){w||(m(v.$$.fragment,h),w=!0)},o(h){g(v.$$.fragment,h),w=!1},d(h){h&&(n(f),n($)),u(v,h)}}}function Lw(M){let f,x="Examples:",$,v,w;return v=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyVG9kYXklMkMlMjBhJTIwZHJhZ29uJTIwZmxldyUyMG92ZXIlMjBQYXJpcyUyQyUyMEZyYW5jZSUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QxLjUpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwd2l0aCUyMGElMjBuZWdhdGl2ZSUyMHByb21wdCUwQW5lZ19pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyQSUyMHZlcnklMjBoYXBweSUyMGV2ZW50JTIwaGFwcGVuZWQlMkMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMiUyQyUyMG5lZ2F0aXZlX3Byb21wdF9pZHMlM0RuZWdfaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQSUwQSUyMyUyMHdpdGglMjBhJTIwcG9zaXRpdmUlMjBwcm9tcHQlMEFuZWdfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkElMjB2ZXJ5JTIwaGFwcHklMjBldmVudCUyMGhhcHBlbmVkJTJDJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDAlMkMlMjBuZWdhdGl2ZV9wcm9tcHRfaWRzJTNEbmVnX2lucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today, a dragon flew over Paris, France,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">1.5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Today, a dragon flew over Paris, France, killing at least 50 people and injuring more than 100&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a negative prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">2</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Today, a dragon flew over Paris, France, killing at least 130 people. French media reported that&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a positive prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">0</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Today, a dragon flew over Paris, France, and I&#x27;m very happy to be here. I&quot;</span>`,wrap:!1}}),{c(){f=r("p"),f.textContent=x,$=s(),l(v.$$.fragment)},l(h){f=a(h,"P",{"data-svelte-h":!0}),y(f)!=="svelte-kvfsh7"&&(f.textContent=x),$=o(h),d(v.$$.fragment,h)},m(h,k){c(h,f,k),c(h,$,k),p(v,h,k),w=!0},p:U,i(h){w||(m(v.$$.fragment,h),w=!0)},o(h){g(v.$$.fragment,h),w=!1},d(h){h&&(n(f),n($)),u(v,h)}}}function Fw(M){let f,x;return f=new C({props:{code:"Y29tcGxldGVkJTIwJTNEJTIwRmFsc2UlMEF3aGlsZSUyMG5vdCUyMGNvbXBsZXRlZCUzQSUwQSUyMCUyMCUyMCUyMF8lMkMlMjBjb21wbGV0ZWQlMjAlM0QlMjBjb25zdHJhaW50LnVwZGF0ZShjb25zdHJhaW50LmFkdmFuY2UoKSk=",highlighted:`completed = <span class="hljs-literal">False</span>
<span class="hljs-keyword">while</span> <span class="hljs-keyword">not</span> completed:
    _, completed = constraint.update(constraint.advance())`,wrap:!1}}),{c(){l(f.$$.fragment)},l($){d(f.$$.fragment,$)},m($,v){p(f,$,v),x=!0},p:U,i($){x||(m(f.$$.fragment,$),x=!0)},o($){g(f.$$.fragment,$),x=!1},d($){u(f,$)}}}function zw(M){let f,x="The API for the streamer classes is still under development and may change in the future.";return{c(){f=r("p"),f.textContent=x},l($){f=a($,"P",{"data-svelte-h":!0}),y(f)!=="svelte-gv2g1g"&&(f.textContent=x)},m($,v){c($,f,v)},p:U,d($){$&&n(f)}}}function Uw(M){let f,x="Examples:",$,v,w;return v=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRTdHJlYW1lciUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2soJTVCJTIyQW4lMjBpbmNyZWFzaW5nJTIwc2VxdWVuY2UlM0ElMjBvbmUlMkMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXN0cmVhbWVyJTIwJTNEJTIwVGV4dFN0cmVhbWVyKHRvayklMEElMEElMjMlMjBEZXNwaXRlJTIwcmV0dXJuaW5nJTIwdGhlJTIwdXN1YWwlMjBvdXRwdXQlMkMlMjB0aGUlMjBzdHJlYW1lciUyMHdpbGwlMjBhbHNvJTIwcHJpbnQlMjB0aGUlMjBnZW5lcmF0ZWQlMjB0ZXh0JTIwdG8lMjBzdGRvdXQuJTBBXyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwc3RyZWFtZXIlM0RzdHJlYW1lciUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextStreamer

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Despite returning the usual output, the streamer will also print the generated text to stdout.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>_ = model.generate(**inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,`,wrap:!1}}),{c(){f=r("p"),f.textContent=x,$=s(),l(v.$$.fragment)},l(h){f=a(h,"P",{"data-svelte-h":!0}),y(f)!=="svelte-kvfsh7"&&(f.textContent=x),$=o(h),d(v.$$.fragment,h)},m(h,k){c(h,f,k),c(h,$,k),p(v,h,k),w=!0},p:U,i(h){w||(m(v.$$.fragment,h),w=!0)},o(h){g(v.$$.fragment,h),w=!1},d(h){h&&(n(f),n($)),u(v,h)}}}function Jw(M){let f,x="The API for the streamer classes is still under development and may change in the future.";return{c(){f=r("p"),f.textContent=x},l($){f=a($,"P",{"data-svelte-h":!0}),y(f)!=="svelte-gv2g1g"&&(f.textContent=x)},m($,v){c($,f,v)},p:U,d($){$&&n(f)}}}function Iw(M){let f,x="Examples:",$,v,w;return v=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRJdGVyYXRvclN0cmVhbWVyJTBBZnJvbSUyMHRocmVhZGluZyUyMGltcG9ydCUyMFRocmVhZCUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2soJTVCJTIyQW4lMjBpbmNyZWFzaW5nJTIwc2VxdWVuY2UlM0ElMjBvbmUlMkMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXN0cmVhbWVyJTIwJTNEJTIwVGV4dEl0ZXJhdG9yU3RyZWFtZXIodG9rKSUwQSUwQSUyMyUyMFJ1biUyMHRoZSUyMGdlbmVyYXRpb24lMjBpbiUyMGElMjBzZXBhcmF0ZSUyMHRocmVhZCUyQyUyMHNvJTIwdGhhdCUyMHdlJTIwY2FuJTIwZmV0Y2glMjB0aGUlMjBnZW5lcmF0ZWQlMjB0ZXh0JTIwaW4lMjBhJTIwbm9uLWJsb2NraW5nJTIwd2F5LiUwQWdlbmVyYXRpb25fa3dhcmdzJTIwJTNEJTIwZGljdChpbnB1dHMlMkMlMjBzdHJlYW1lciUzRHN0cmVhbWVyJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCklMEF0aHJlYWQlMjAlM0QlMjBUaHJlYWQodGFyZ2V0JTNEbW9kZWwuZ2VuZXJhdGUlMkMlMjBrd2FyZ3MlM0RnZW5lcmF0aW9uX2t3YXJncyklMEF0aHJlYWQuc3RhcnQoKSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwJTIyJTIyJTBBZm9yJTIwbmV3X3RleHQlMjBpbiUyMHN0cmVhbWVyJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVkX3RleHQlMjAlMkIlM0QlMjBuZXdfdGV4dCUwQWdlbmVyYXRlZF90ZXh0",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextIteratorStreamer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> threading <span class="hljs-keyword">import</span> Thread

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextIteratorStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run the generation in a separate thread, so that we can fetch the generated text in a non-blocking way.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_kwargs = <span class="hljs-built_in">dict</span>(inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread = Thread(target=model.generate, kwargs=generation_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread.start()
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = <span class="hljs-string">&quot;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> new_text <span class="hljs-keyword">in</span> streamer:
<span class="hljs-meta">... </span>    generated_text += new_text
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text
<span class="hljs-string">&#x27;An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,&#x27;</span>`,wrap:!1}}),{c(){f=r("p"),f.textContent=x,$=s(),l(v.$$.fragment)},l(h){f=a(h,"P",{"data-svelte-h":!0}),y(f)!=="svelte-kvfsh7"&&(f.textContent=x),$=o(h),d(v.$$.fragment,h)},m(h,k){c(h,f,k),c(h,$,k),p(v,h,k),w=!0},p:U,i(h){w||(m(v.$$.fragment,h),w=!0)},o(h){g(v.$$.fragment,h),w=!1},d(h){h&&(n(f),n($)),u(v,h)}}}function Cw(M){let f,x,$,v,w,h,k,sT=`This page lists all the utility functions used by <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>,
<a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.greedy_search">greedy_search()</a>,
<a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.contrastive_search">contrastive_search()</a>,
<a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.sample">sample()</a>,
<a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.beam_search">beam_search()</a>,
<a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.beam_sample">beam_sample()</a>,
<a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search">group_beam_search()</a>, and
<a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.constrained_beam_search">constrained_beam_search()</a>.`,Sp,Wn,oT="Most of those are only useful if you are studying the code of the generate methods in the library.",Zp,Vn,Dp,Sn,rT=`The output of <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> is an instance of a subclass of
<a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a>. This output is a data structure containing all the information returned
by <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>, but that can also be used as tuple or dictionary.`,Pp,Zn,aT="Here’s an example:",Gp,Dn,Ep,Pn,iT=`The <code>generation_output</code> object is a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.GreedySearchDecoderOnlyOutput">GreedySearchDecoderOnlyOutput</a>, as we can
see in the documentation of that class below, it means it has the following attributes:`,Xp,Gn,cT="<li><code>sequences</code>: the generated sequences of tokens</li> <li><code>scores</code> (optional): the prediction scores of the language modelling head, for each generation step</li> <li><code>hidden_states</code> (optional): the hidden states of the model, for each generation step</li> <li><code>attentions</code> (optional): the attention weights of the model, for each generation step</li>",Np,En,lT=`Here we have the <code>scores</code> since we passed along <code>output_scores=True</code>, but we don’t have <code>hidden_states</code> and
<code>attentions</code> because we didn’t pass <code>output_hidden_states=True</code> or <code>output_attentions=True</code>.`,Hp,Xn,dT=`You can access each attribute as you would usually do, and if that attribute has not been returned by the model, you
will get <code>None</code>. Here for instance <code>generation_output.scores</code> are all the generated prediction scores of the
language modeling head, and <code>generation_output.attentions</code> is <code>None</code>.`,Rp,Nn,pT=`When using our <code>generation_output</code> object as a tuple, it only keeps the attributes that don’t have <code>None</code> values.
Here, for instance, it has two elements, <code>loss</code> then <code>logits</code>, so`,Op,Hn,Qp,Rn,mT="will return the tuple <code>(generation_output.sequences, generation_output.scores)</code> for instance.",Ap,On,gT=`When using our <code>generation_output</code> object as a dictionary, it only keeps the attributes that don’t have <code>None</code>
values. Here, for instance, it has two keys that are <code>sequences</code> and <code>scores</code>.`,Yp,Qn,uT="We document here all output types.",Kp,An,em,pt,Yn,ku,ei,hT=`Base class for outputs of encoder-decoder generation models using greedy search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,tm,mt,Kn,Mu,ti,fT="Base class for outputs of decoder-only generation models using greedy search.",nm,gt,es,ju,ni,_T=`Base class for outputs of encoder-decoder generation models using sampling. Hidden states and attention weights of
the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,sm,ut,ts,Lu,si,bT="Base class for outputs of decoder-only generation models using sampling.",om,ht,ns,Fu,oi,TT=`Base class for outputs of encoder-decoder generation models using beam search. Hidden states and attention weights
of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,rm,ft,ss,zu,ri,yT="Base class for outputs of decoder-only generation models using beam search.",am,_t,os,Uu,ai,vT=`Base class for outputs of encoder-decoder generation models using beam sampling. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,im,bt,rs,Ju,ii,$T="Base class for outputs of decoder-only generation models using beam sample.",cm,Tt,as,Iu,ci,wT="Base class for outputs of decoder-only generation models using contrastive search.",lm,yt,is,Cu,li,xT="Base class for outputs of decoder-only generation models using contrastive search.",dm,cs,pm,vt,ls,Bu,di,kT=`Base class for outputs of encoder-decoder generation models using greedy search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,mm,$t,ds,qu,pi,MT="Base class for outputs of decoder-only generation models using greedy search.",gm,wt,ps,Wu,mi,jT=`Base class for outputs of encoder-decoder generation models using sampling. Hidden states and attention weights of
the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,um,xt,ms,Vu,gi,LT="Base class for outputs of decoder-only generation models using sampling.",hm,kt,gs,Su,ui,FT=`Base class for outputs of encoder-decoder generation models using beam search. Hidden states and attention weights
of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,fm,Mt,us,Zu,hi,zT="Base class for outputs of decoder-only generation models using beam search.",_m,jt,hs,Du,fi,UT=`Base class for outputs of encoder-decoder generation models using beam sampling. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,bm,Lt,fs,Pu,_i,JT="Base class for outputs of decoder-only generation models using beam sample.",Tm,Ft,_s,Gu,bi,IT=`Base class for outputs of encoder-decoder generation models using contrastive search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,ym,zt,bs,Eu,Ti,CT="Base class for outputs of decoder-only generation models using contrastive search.",vm,Ts,$m,ae,ys,Xu,yi,BT="Flax Base class for outputs of decoder-only generation models using sampling.",Nu,qt,vs,Hu,vi,qT="“Returns a new object replacing the specified fields with new values.",wm,ie,$s,Ru,$i,WT="Flax Base class for outputs of decoder-only generation models using greedy search.",Ou,Wt,ws,Qu,wi,VT="“Returns a new object replacing the specified fields with new values.",xm,ce,xs,Au,xi,ST="Flax Base class for outputs of decoder-only generation models using greedy search.",Yu,Vt,ks,Ku,ki,ZT="“Returns a new object replacing the specified fields with new values.",km,Ms,Mm,js,DT=`A <a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> can be used to modify the prediction scores of a language model head for
generation.`,jm,Ls,Lm,le,Fs,eh,Mi,PT='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing alternated generation between the two codebooks of <code>Bark</code>’s fine submodel.',th,ji,zs,Fm,N,Us,nh,Li,GT=`Logits processor for classifier free guidance (CFG). The scores are split over the batch dimension,
where the first half correspond to the conditional logits (predicted from the input prompt) and the second half
correspond to the unconditional logits (predicted from an empty or ‘null’ prompt). The processor computes a
weighted average across the conditional and unconditional logits, parameterised by the <code>guidance_scale</code>.`,sh,Fi,ET='See <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">the paper</a> for more information.',oh,zi,Js,zm,de,Is,rh,Ui,XT=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces no repetition of encoder input ids n-grams for the decoder ids. See
<a href="https://github.com/facebookresearch/ParlAI/blob/master/parlai/core/torch_generator_agent.py#L1350" rel="nofollow">ParlAI</a>.`,ah,Ji,Cs,Um,H,Bs,ih,Ii,NT=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that avoids hallucination by boosting the probabilities of tokens found within the original
input.`,ch,Ci,HT=`This technique can also be used to reward and thus encourage hallucination (or creativity) in a similar manner. To
penalize and reduce hallucination, use <code>penalty</code> values above 1.0, where a higher value penalizes more strongly. To
reward and encourage hallucination, use <code>penalty</code> values between 0.0 and 1.0, where a lower value rewards more
strongly.`,lh,Bi,qs,Jm,R,Ws,dh,qi,RT=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs epsilon-sampling, i.e. restricting to tokens with <code>prob &gt;= epsilon</code>. Takes the
largest min_tokens_to_keep tokens if no tokens satisfy this constraint. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more information.`,ph,St,mh,Wi,Vs,Im,O,Ss,gh,Vi,OT=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs eta-sampling, a technique to filter out tokens with probabilities below a dynamic
cutoff value, <code>eta</code>, which is calculated based on a combination of the hyperparameter <code>epsilon</code> and the entropy of
the token probabilities, i.e. <code>eta := min(epsilon, sqrt(epsilon * e^-entropy(probabilities)))</code>. Takes the largest
min_tokens_to_keep tokens if no tokens satisfy this constraint. It addresses the issue of poor quality in long
samples of text generated by neural language models leading to more coherent and fluent text. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation
Sampling as Language Model Desmoothing</a> for more information. Note: <code>do_sample</code>
must be set to <code>True</code> for this <code>LogitsWarper</code> to work.`,uh,Zt,hh,Si,Zs,Cm,Q,Ds,fh,Zi,QT=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that exponentially increases the score of the <code>eos_token_id</code> after <code>start_index</code> has been
reached. This allows generating shorter sequences without having a hard cutoff, allowing the <code>eos_token</code> to be
predicted in a meaningful position.`,_h,Dt,bh,Di,Ps,Bm,pe,Gs,Th,Pi,AT='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces the specified token as the first generated token.',yh,Gi,Es,qm,me,Xs,vh,Ei,YT='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',$h,Xi,Ns,Wm,ge,Hs,wh,Ni,KT=`This processor takes a list of pairs of integers which indicates a mapping from generation indices to token
indices that will be forced before sampling. The processor will set their log probs to <code>inf</code> so that they are
sampled at their corresponding index.`,xh,Hi,Rs,Vm,j,Os,kh,Ri,ey='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces diverse beam search.',Mh,Oi,ty=`Note that this logits processor is only effective for <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search">PreTrainedModel.group_beam_search()</a>. See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">Diverse Beam
Search: Decoding Diverse Solutions from Neural Sequence Models</a> for more
details.`,jh,Pt,Lh,Gt,Fh,Qi,ny=`Traditional beam search often generates very similar sequences across different beams.
<code>HammingDiversityLogitsProcessor</code> addresses this by penalizing beams that generate tokens already chosen by other
beams in the same time step.`,zh,Ai,sy="How It Works:",Uh,Yi,oy=`<li><strong>Grouping Beams</strong>: Beams are divided into groups. Each group selects tokens independently of the others.</li> <li><strong>Penalizing Repeated Tokens</strong>: If a beam in a group selects a token already chosen by another group in the
same step, a penalty is applied to that token’s score.</li> <li><strong>Promoting Diversity</strong>: This penalty discourages beams within a group from selecting the same tokens as
beams in other groups.</li>`,Jh,Ki,ry="Benefits:",Ih,ec,ay="<li><strong>Diverse Outputs</strong>: Produces a variety of different sequences.</li> <li><strong>Exploration</strong>: Allows the model to explore different paths.</li>",Ch,Et,Bh,tc,Qs,Sm,ue,As,qh,nc,iy=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that removes all <code>nan</code> and <code>inf</code> values to avoid the generation method to fail. Note that using
the logits processor should only be used if necessary since it can slow down the generation method.`,Wh,sc,Ys,Zm,he,Ks,Vh,oc,cy=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> and <a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for normalizing the scores using log-softmax. It’s important to normalize
the scores during beam search, after applying the logits processors or warpers, since the search algorithm used in
this library doesn’t do it (it only does it before, but they may need re-normalization) but it still supposes that
the scores are normalized when comparing the hypotheses.`,Sh,rc,eo,Dm,fe,to,Zh,ac,ly="Abstract base class for all logit processors that can be applied during generation.",Dh,ic,no,Pm,_e,so,Ph,cc,dy=`This class can be used to create a list of <a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> or <a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> to subsequently process a
<code>scores</code> input tensor. This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each
<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> or <a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> to the inputs.`,Gh,lc,oo,Gm,be,ro,Eh,dc,py="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",Xh,pc,ao,Em,Te,io,Nh,mc,my='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',Hh,gc,co,Xm,A,lo,Rh,uc,gy=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing a min-length of new tokens by setting EOS (End-Of-Sequence) token probability to 0.
Note that for decoder-only models, such as Llama2, <code>min_length</code> will compute the length of <code>prompt + newly generated tokens</code> whereas for other models it will behave as <code>min_new_tokens</code>, that is, taking only into account
the newly generated ones.`,Oh,Xt,Qh,hc,po,Nm,q,mo,Ah,fc,uy='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces that specified sequences will never be selected.',Yh,Nt,Kh,Ht,ef,_c,go,Hm,W,uo,tf,bc,hy=`N-grams are groups of “n” consecutive words, characters, or tokens taken from a sequence of text. Given the
sentence: “She runs fast”, the bi-grams (n=2) would be (“she”, “runs”) and (“runs”, “fast”). In text generation,
avoiding repetitions of word sequences provides a more diverse output. This <a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforces no
repetition of n-grams by setting the scores of banned tokens to negative infinity which eliminates those tokens
from consideration when further processing the scores.
<a href="https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345" rel="nofollow">Fairseq</a>.`,nf,Rt,sf,Ot,of,Tc,ho,Rm,ye,fo,rf,yc,fy=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces constrained generation and is useful for prefix-conditioned constrained
generation. See <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity Retrieval</a> for more information.`,af,vc,_o,Om,V,bo,cf,$c,_y=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that prevents the repetition of previous tokens through an exponential penalty. This technique
shares some similarities with coverage mechanisms and other aimed at reducing repetition. During the text
generation process, the probability distribution for the next token is determined using a formula that incorporates
token scores based on their occurrence in the generated sequence. Tokens with higher scores are more likely to be
selected. The formula can be seen in the original <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">paper</a>. According to the
paper a penalty of around 1.2 yields a good balance between truthful generation and lack of repetition.`,lf,wc,by=`This technique can also be used to reward and thus encourage repetition in a similar manner. To penalize and reduce
repetition, use <code>penalty</code> values above 1.0, where a higher value penalizes more strongly. To reward and encourage
repetition, use <code>penalty</code> values between 0.0 and 1.0, where a lower value rewards more strongly.`,df,Qt,pf,xc,To,Qm,S,yo,mf,kc,Ty=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that applies an additive bias on sequences. The bias is applied to the last token of a sequence
when the next generated token can complete it. Consequently, to take the most of biasing sequences with more than
one token, consider using beam methods (to gracefully work around partially completed sequences that have a
negative bias) and applying the bias to their prefixes (to ensure the bias is applied earlier).`,gf,At,uf,Yt,hf,Mc,vo,Am,ve,$o,ff,jc,yy=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.SuppressTokensAtBeginLogitsProcessor">SuppressTokensAtBeginLogitsProcessor</a> supresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> at not
sampled at the begining of the generation.`,_f,Lc,wo,Ym,$e,xo,bf,Fc,vy=`This processor can be used to suppress a list of tokens. The processor will set their log probs to <code>-inf</code> so that they
are not sampled.`,Tf,zc,ko,Km,Z,Mo,yf,Uc,$y=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> for temperature (exponential scaling output probability distribution), which effectively means
that it can control the randomness of the predicted tokens.`,vf,Kt,$f,en,wf,Jc,jo,eg,we,Lo,xf,Ic,wy='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',kf,Cc,Fo,tg,Y,zo,Mf,Bc,xy='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to prob_cut_off &lt;= prob_cut_off.',jf,tn,Lf,qc,Uo,ng,xe,Jo,Ff,Wc,ky=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs typical decoding. See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language
Generation</a> for more information.`,zf,Vc,Io,sg,D,Co,Uf,Sc,My=`Logits processor for Classifier-Free Guidance (CFG). The processors
computes a weighted average across scores from prompt conditional and prompt unconditional (or negative) logits,
parameterized by the <code>guidance_scale</code>. The unconditional scores are computed internally by prompting <code>model</code> with
the <code>unconditional_ids</code> branch.`,Jf,Zc,jy='See <a href="https://arxiv.org/abs/2306.17806" rel="nofollow">the paper</a> for more information.',If,nn,Cf,Dc,Bo,og,K,qo,Bf,Pc,Ly=`Whisper specific Processor. This processor can be used to force a list of tokens. The processor will set their log
probs to <code>inf</code> so that they are sampled at their corresponding index.`,qf,Gc,Fy='See <a href="https://arxiv.org/abs/2212.04356" rel="nofollow">the paper</a> for more information.',Wf,Ec,Wo,rg,Vo,ag,ke,So,Vf,Xc,zy='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces the specified token as the first generated token.',Sf,Nc,Zo,ig,Me,Do,Zf,Hc,Uy='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',Df,Rc,Po,cg,je,Go,Pf,Oc,Jy=`This processor takes a list of pairs of integers which indicates a mapping from generation indices to token
indices that will be forced before sampling. The processor will set their log probs to <code>0</code> and all other tokens to
<code>-inf</code> so that they are sampled at their corresponding index.`,Gf,Qc,Eo,lg,Le,Xo,Ef,Ac,Iy="Abstract base class for all logit processors that can be applied during generation.",Xf,sn,No,Nf,Yc,Cy="TF method for processing logits.",dg,Fe,Ho,Hf,Kc,By=`This class can be used to create a list of <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> to subsequently process a <code>scores</code> input tensor.
This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> to the
inputs.`,Rf,el,Ro,pg,ze,Oo,Of,tl,qy="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",Qf,on,Qo,Af,nl,Wy="TF method for warping logits.",mg,Ue,Ao,Yf,sl,Vy='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',Kf,ol,Yo,gg,Je,Ko,e_,rl,Sy='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces that specified sequences will never be sampled.',t_,al,er,ug,Ie,tr,n_,il,Zy=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces no repetition of n-grams. See
<a href="https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345" rel="nofollow">Fairseq</a>.`,s_,cl,nr,hg,Ce,sr,o_,ll,Dy='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> enforcing an exponential penalty on repeated sequences.',r_,dl,or,fg,Be,rr,a_,pl,Py=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFSuppressTokensAtBeginLogitsProcessor">TFSuppressTokensAtBeginLogitsProcessor</a> suppresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> at not
sampled at the begining of the generation.`,i_,ml,ar,_g,qe,ir,c_,gl,Gy=`This processor can be used to suppress a list of tokens. The processor will set their log probs to <code>-inf</code> so that they
are not sampled.`,l_,ul,cr,bg,We,lr,d_,hl,Ey='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> for temperature (exponential scaling output probability distribution).',p_,fl,dr,Tg,Ve,pr,m_,_l,Xy='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',g_,bl,mr,yg,Se,gr,u_,Tl,Ny='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to &lt;= prob_cut_off.',h_,yl,ur,vg,hr,$g,Ze,fr,f_,vl,Hy='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that enforces the specified token as the first generated token.',__,$l,_r,wg,De,br,b_,wl,Ry='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',T_,xl,Tr,xg,Pe,yr,y_,kl,Oy=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that takes a list of pairs of integers which indicates a mapping from generation indices to
token indices that will be forced before sampling. The processor will set their log probs to 0 and all other tokens
to <code>-inf</code> so that they are sampled at their corresponding index.`,v_,Ml,vr,kg,Ge,$r,$_,jl,Qy="Abstract base class for all logit processors that can be applied during generation.",w_,rn,wr,x_,Ll,Ay="Flax method for processing logits.",Mg,Ee,xr,k_,Fl,Yy=`This class can be used to create a list of <a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> or <a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> to subsequently process
a <code>scores</code> input tensor. This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each
<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> or <a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> to the inputs.`,M_,zl,kr,jg,Xe,Mr,j_,Ul,Ky="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",L_,an,jr,F_,Jl,ev="Flax method for warping logits.",Lg,Ne,Lr,z_,Il,tv='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',U_,Cl,Fr,Fg,He,zr,J_,Bl,nv=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> supressing a list of tokens as soon as the <code>generate</code> function starts generating using
<code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> are not sampled at the
begining of the generation.`,I_,ql,Ur,zg,Re,Jr,C_,Wl,sv=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> suppressing a list of tokens at each decoding step. The processor will set their log probs
to be <code>-inf</code> so they are not sampled.`,B_,Vl,Ir,Ug,Oe,Cr,q_,Sl,ov='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> for temperature (exponential scaling output probability distribution).',W_,Zl,Br,Jg,Qe,qr,V_,Dl,rv='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',S_,Pl,Wr,Ig,Ae,Vr,Z_,Gl,av='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to prob_cut_off &lt;= prob_cut_off.',D_,El,Sr,Cg,Ye,Zr,P_,Xl,iv=`Whisper specific Processor. This processor can be used to force a list of tokens. The processor will set their log
probs to <code>inf</code> so that they are sampled at their corresponding index.`,G_,Nl,Dr,Bg,Pr,qg,Gr,cv='A <a href="/docs/transformers/main/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a> can be used to change when to stop generation (other than EOS token). Please note that this is exclusivelly available to our PyTorch implementations.',Wg,ee,Er,E_,Hl,lv="Abstract base class for all stopping criteria that can be applied during generation.",X_,Rl,dv="If your stopping criteria depends on the <code>scores</code> input, make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.",N_,Ol,Xr,Vg,Ut,Nr,H_,Ql,Hr,Sg,Ke,Rr,R_,Al,pv=`This class can be used to stop generation whenever the full generated number of tokens exceeds <code>max_length</code>. Keep
in mind for decoder-only type of transformers, this will include the initial prompted tokens.`,O_,Yl,Or,Zg,et,Qr,Q_,Kl,mv=`This class can be used to stop generation whenever the full generation exceeds some amount of time. By default, the
time will start being counted when you initialize this function. You can override this by passing an
<code>initial_time</code>.`,A_,ed,Ar,Dg,Yr,Pg,Kr,gv='A <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Constraint">Constraint</a> can be used to force the generation to include specific tokens or sequences in the output. Please note that this is exclusivelly available to our PyTorch implementations.',Gg,L,ea,Y_,td,uv=`Abstract base class for all constraints that can be applied during generation.
It must define how the constraint can be satisfied.`,K_,nd,hv="All classes that inherit Constraint must follow the requirement that",eb,cn,tb,sd,fv="will always terminate (halt).",nb,ln,ta,sb,od,_v="When called, returns the token that would take this constraint one step closer to being fulfilled.",ob,dn,na,rb,rd,bv="Creates a new instance of this constraint.",ab,pn,sa,ib,ad,Tv="Reads in a token and returns whether it creates progress.",cb,mn,oa,lb,id,yv="Returns the number of remaining steps of <code>advance()</code> in order to complete this constraint.",db,gn,ra,pb,cd,vv=`Resets the state of this constraint to its initialization. We would call this in cases where the fulfillment of
a constraint is abrupted by an unwanted token.`,mb,un,aa,gb,ld,$v="Tests whether this constraint has been properly defined.",ub,st,ia,hb,dd,wv=`Reads in a token and returns booleans that indicate the progress made by it. This function will update the
state of this object unlikes <code>does_advance(self, token_id: int)</code>.`,fb,pd,xv=`This isn’t to test whether a certain token will advance the progress; it’s to update its state as if it has
been generated. This becomes important if token_id != desired token (refer to else statement in
PhrasalConstraint)`,Eg,Jt,ca,_b,md,kv='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.Constraint">Constraint</a> enforcing that an ordered sequence of tokens is included in the output.',Xg,It,la,bb,gd,Mv='A special <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Constraint">Constraint</a> that is fulfilled by fulfilling just one of several constraints.',Ng,te,da,Tb,ud,jv="A class for beam scorers to track its progress through a list of constraints.",yb,B,pa,vb,hd,Lv=`The list of tokens to generate such that we can make progress.
By “list” we don’t mean the list of token that will fully fulfill a constraint.`,$b,fd,Fv=`Given constraints <code>c_i = {t_ij | j == # of tokens}</code>, If we’re not in the middle of progressing through a
specific constraint <code>c_i</code>, we return:`,wb,_d,zv="<code>[t_k1 for k in indices of unfulfilled constraints]</code>",xb,bd,Uv=`If we are in the middle of a constraint, then we return:
<code>[t_ij]</code>, where <code>i</code> is the index of the inprogress constraint, <code>j</code> is the next step for the constraint.`,kb,Td,Jv=`Though we don’t care which constraint is fulfilled first, if we are in the progress of fulfilling a constraint,
that’s the only one we’ll return.`,Mb,hn,ma,jb,yd,Iv="token_ids: the tokens generated thus far to reset the state of the progress through constraints.",Hg,ga,Rg,ne,ua,Lb,vd,Cv=`Abstract base class for all beam scorers that are used for <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.beam_search">beam_search()</a> and
<a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.beam_sample">beam_sample()</a>.`,Fb,$d,ha,zb,wd,fa,Og,I,_a,Ub,xd,Bv='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> implementing standard beam search decoding.',Jb,kd,qv=`Adapted in part from <a href="https://github.com/facebookresearch/XLM/blob/9e6f6814d17be4fe5b15f2e6c43eb2b2d76daeb4/src/model/transformer.py#L529" rel="nofollow">Facebook’s XLM beam search
code</a>.`,Ib,Md,Wv=`Reference for the diverse beam search algorithm and implementation <a href="https://github.com/ashwinkalyan/dbs/blob/master/dbs/beam_utils.lua" rel="nofollow">Ashwin Kalyan’s DBS
implementation</a>`,Cb,jd,ba,Bb,Ld,Ta,Qg,se,ya,qb,Fd,Vv='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> implementing constrained beam search decoding.',Wb,zd,va,Vb,Ud,$a,Ag,wa,Yg,tt,xa,Sb,Jd,Sv="Filter a distribution of logits using top-k and/or nucleus (top-p) filtering",Zb,Id,Zv='From: <a href="https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317" rel="nofollow">https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317</a>',Kg,nt,ka,Db,Cd,Dv="Filter a distribution of logits using top-k and/or nucleus (top-p) filtering",Pb,Bd,Pv='From: <a href="https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317" rel="nofollow">https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317</a>',eu,Ma,tu,J,ja,Gb,qd,Gv="Simple text streamer that prints the token(s) to stdout as soon as entire words are formed.",Eb,fn,Xb,_n,Nb,bn,La,Hb,Wd,Ev="Flushes any remaining cache and prints a newline to stdout.",Rb,Tn,Fa,Ob,Vd,Xv="Prints the new text to stdout. If the stream is ending, also prints a newline.",Qb,yn,za,Ab,Sd,Nv="Receives tokens, decodes them, and prints them to stdout as soon as they form entire words.",nu,P,Ua,Yb,Zd,Hv=`Streamer that stores print-ready text in a queue, to be used by a downstream application as an iterator. This is
useful for applications that benefit from acessing the generated text in a non-blocking way (e.g. in an interactive
Gradio demo).`,Kb,vn,eT,$n,tT,wn,Ja,nT,Dd,Rv="Put the new text in the queue. If the stream is ending, also put a stop signal in the queue.",su,Vp,ou;return w=new X({props:{title:"Utilities for Generation",local:"utilities-for-generation",headingTag:"h1"}}),Vn=new X({props:{title:"Generate Outputs",local:"generate-outputs",headingTag:"h2"}}),Dn=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJUb2tlbml6ZXIlMkMlMjBHUFQyTE1IZWFkTW9kZWwlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBHUFQyVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwR1BUMkxNSGVhZE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIwYW5kJTIwJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFnZW5lcmF0aW9uX291dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, GPT2LMHeadModel

tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
model = GPT2LMHeadModel.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute and &quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
generation_output = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)`,wrap:!1}}),Hn=new C({props:{code:"Z2VuZXJhdGlvbl9vdXRwdXQlNUIlM0EyJTVE",highlighted:'generation_output[:<span class="hljs-number">2</span>]',wrap:!1}}),An=new X({props:{title:"PyTorch",local:"transformers.generation.GreedySearchEncoderDecoderOutput",headingTag:"h3"}}),Yn=new T({props:{name:"class transformers.generation.GreedySearchEncoderDecoderOutput",anchor:"transformers.generation.GreedySearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L184"}}),Kn=new T({props:{name:"class transformers.generation.GreedySearchDecoderOnlyOutput",anchor:"transformers.generation.GreedySearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.GreedySearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GreedySearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GreedySearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.GreedySearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L88"}}),es=new T({props:{name:"class transformers.generation.SampleEncoderDecoderOutput",anchor:"transformers.generation.SampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.SampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.SampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.SampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape
<code>(batch_size*num_return_sequences, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.SampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.SampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.SampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.SampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L255"}}),ts=new T({props:{name:"class transformers.generation.SampleDecoderOnlyOutput",anchor:"transformers.generation.SampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.SampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.SampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.SampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(num_return_sequences*batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.SampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(num_return_sequences*batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L226"}}),ns=new T({props:{name:"class transformers.generation.BeamSearchEncoderDecoderOutput",anchor:"transformers.generation.BeamSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": typing.Optional[torch.FloatTensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L333"}}),ss=new T({props:{name:"class transformers.generation.BeamSearchDecoderOnlyOutput",anchor:"transformers.generation.BeamSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": typing.Optional[torch.FloatTensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.BeamSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.BeamSearchDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.BeamSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.BeamSearchDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.BeamSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.BeamSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L298"}}),os=new T({props:{name:"class transformers.generation.BeamSampleEncoderDecoderOutput",anchor:"transformers.generation.BeamSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": typing.Optional[torch.FloatTensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_beams, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>).`,name:"scores"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size*num_beams, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L418"}}),rs=new T({props:{name:"class transformers.generation.BeamSampleDecoderOnlyOutput",anchor:"transformers.generation.BeamSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": typing.Optional[torch.FloatTensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.BeamSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.BeamSampleDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.BeamSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.BeamSampleDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.BeamSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.BeamSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L383"}}),as=new T({props:{name:"class transformers.generation.ContrastiveSearchEncoderDecoderOutput",anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L116"}}),is=new T({props:{name:"class transformers.generation.ContrastiveSearchDecoderOnlyOutput",anchor:"transformers.generation.ContrastiveSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.ContrastiveSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.ContrastiveSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when &#x2014;
<code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.ContrastiveSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.ContrastiveSearchDecoderOnlyOutput.hidden_states",description:"<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is &#x2014;",name:"hidden_states"},{anchor:"transformers.generation.ContrastiveSearchDecoderOnlyOutput.passed",description:`<strong>passed</strong> or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"passed"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L155"}}),cs=new X({props:{title:"TensorFlow",local:"transformers.generation.TFGreedySearchEncoderDecoderOutput",headingTag:"h3"}}),ls=new T({props:{name:"class transformers.generation.TFGreedySearchEncoderDecoderOutput",anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L86"}}),ds=new T({props:{name:"class transformers.generation.TFGreedySearchDecoderOnlyOutput",anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L58"}}),ps=new T({props:{name:"class transformers.generation.TFSampleEncoderDecoderOutput",anchor:"transformers.generation.TFSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size*num_return_sequences, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L156"}}),ms=new T({props:{name:"class transformers.generation.TFSampleDecoderOnlyOutput",anchor:"transformers.generation.TFSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L128"}}),gs=new T({props:{name:"class transformers.generation.TFBeamSearchEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. <code>Tuple of </code>tf.Tensor<code>with up to</code>max_new_tokens<code>elements (one element for each generated token), with each tensor of shape</code>(batch_size*num_beams, config.vocab_size)\`.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L233"}}),us=new T({props:{name:"class transformers.generation.TFBeamSearchDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L198"}}),hs=new T({props:{name:"class transformers.generation.TFBeamSampleEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L318"}}),fs=new T({props:{name:"class transformers.generation.TFBeamSampleDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L283"}}),_s=new T({props:{name:"class transformers.generation.TFContrastiveSearchEncoderDecoderOutput",anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L394"}}),bs=new T({props:{name:"class transformers.generation.TFContrastiveSearchDecoderOnlyOutput",anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L367"}}),Ts=new X({props:{title:"FLAX",local:"transformers.generation.FlaxSampleOutput",headingTag:"h3"}}),ys=new T({props:{name:"class transformers.generation.FlaxSampleOutput",anchor:"transformers.generation.FlaxSampleOutput",parameters:[{name:"sequences",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxSampleOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_utils.py#L69"}}),vs=new T({props:{name:"replace",anchor:"transformers.generation.FlaxSampleOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),$s=new T({props:{name:"class transformers.generation.FlaxGreedySearchOutput",anchor:"transformers.generation.FlaxGreedySearchOutput",parameters:[{name:"sequences",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxGreedySearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_utils.py#L55"}}),ws=new T({props:{name:"replace",anchor:"transformers.generation.FlaxGreedySearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),xs=new T({props:{name:"class transformers.generation.FlaxBeamSearchOutput",anchor:"transformers.generation.FlaxBeamSearchOutput",parameters:[{name:"sequences",val:": Array = None"},{name:"scores",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxBeamSearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"},{anchor:"transformers.generation.FlaxBeamSearchOutput.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size,)</code>) &#x2014;
The scores (log probabilities) of the generated sequences.`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_utils.py#L83"}}),ks=new T({props:{name:"replace",anchor:"transformers.generation.FlaxBeamSearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),Ms=new X({props:{title:"LogitsProcessor",local:"logitsprocessor",headingTag:"h2"}}),Ls=new X({props:{title:"PyTorch",local:"transformers.AlternatingCodebooksLogitsProcessor",headingTag:"h3"}}),Fs=new T({props:{name:"class transformers.AlternatingCodebooksLogitsProcessor",anchor:"transformers.AlternatingCodebooksLogitsProcessor",parameters:[{name:"input_start_len",val:": int"},{name:"semantic_vocab_size",val:": int"},{name:"codebook_size",val:": int"}],parametersDescription:[{anchor:"transformers.AlternatingCodebooksLogitsProcessor.input_start_len",description:`<strong>input_start_len</strong> (<code>int</code>) &#x2014;
The length of the initial input sequence.`,name:"input_start_len"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.semantic_vocab_size",description:`<strong>semantic_vocab_size</strong> (<code>int</code>) &#x2014;
Vocabulary size of the semantic part, i.e number of tokens associated to the semantic vocabulary.`,name:"semantic_vocab_size"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.codebook_size",description:`<strong>codebook_size</strong> (<code>int</code>) &#x2014;
Number of tokens associated to the codebook.`,name:"codebook_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1565"}}),zs=new T({props:{name:"__call__",anchor:"transformers.AlternatingCodebooksLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1586"}}),Us=new T({props:{name:"class transformers.ClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:""}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (float) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale &gt; 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality.`,name:"guidance_scale"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1525"}}),Js=new T({props:{name:"__call__",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1549",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Is=new T({props:{name:"class transformers.EncoderNoRepeatNGramLogitsProcessor",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor",parameters:[{name:"encoder_ngram_size",val:": int"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_ngram_size",description:`<strong>encoder_ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur within the encoder input ids.`,name:"encoder_ngram_size"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>int</code>) &#x2014;
The encoder_input_ids that should not be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L775"}}),Cs=new T({props:{name:"__call__",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L798",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Bs=new T({props:{name:"class transformers.EncoderRepetitionPenaltyLogitsProcessor",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.penalty",description:`<strong>penalty</strong> (<code>float</code>) &#x2014;
The parameter for hallucination penalty. 1.0 means no penalty. Above 1.0 penalizes hallucination. Between
0.0 and 1.0 rewards hallucination.`,name:"penalty"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
The encoder_input_ids that should be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L328"}}),qs=new T({props:{name:"__call__",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L353",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ws=new T({props:{name:"class transformers.EpsilonLogitsWarper",anchor:"transformers.EpsilonLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
If set to &gt; 0, only the most tokens with probabilities <code>epsilon</code> or higher are kept for generation.`,name:"epsilon"},{anchor:"transformers.EpsilonLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.EpsilonLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L505"}}),St=new G({props:{anchor:"transformers.EpsilonLogitsWarper.example",$$slots:{default:[pw]},$$scope:{ctx:M}}}),Vs=new T({props:{name:"__call__",anchor:"transformers.EpsilonLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EpsilonLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L558",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ss=new T({props:{name:"class transformers.EtaLogitsWarper",anchor:"transformers.EtaLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
A float value in the range (0, 1). Hyperparameter used to calculate the dynamic cutoff value, <code>eta</code>. The
suggested values from the paper ranges from 3e-4 to 4e-3 depending on the size of the model.`,name:"epsilon"},{anchor:"transformers.EtaLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All values that are found to be below the dynamic cutoff value, <code>eta</code>, are set to this float value. This
parameter is useful when logits need to be modified for very low probability tokens that should be excluded
from generation entirely.`,name:"filter_value"},{anchor:"transformers.EtaLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Specifies the minimum number of tokens that must be kept for generation, regardless of their probabilities.
For example, if <code>min_tokens_to_keep</code> is set to 1, at least one token will always be kept for generation,
even if all tokens have probabilities below the cutoff <code>eta</code>.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L572"}}),Zt=new G({props:{anchor:"transformers.EtaLogitsWarper.example",$$slots:{default:[mw]},$$scope:{ctx:M}}}),Zs=new T({props:{name:"__call__",anchor:"transformers.EtaLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EtaLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L635",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ds=new T({props:{name:"class transformers.ExponentialDecayLengthPenalty",anchor:"transformers.ExponentialDecayLengthPenalty",parameters:[{name:"exponential_decay_length_penalty",val:": typing.Tuple[int, float]"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int]]"},{name:"input_ids_seq_length",val:": int"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.exponential_decay_length_penalty",description:`<strong>exponential_decay_length_penalty</strong> (<code>tuple(int, float)</code>) &#x2014;
This tuple shall consist of: <code>(start_index, decay_factor)</code> where <code>start_index</code> indicates where penalty
starts and <code>decay_factor</code> represents the factor of exponential decay`,name:"exponential_decay_length_penalty"},{anchor:"transformers.ExponentialDecayLengthPenalty.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.ExponentialDecayLengthPenalty.input_ids_seq_length",description:`<strong>input_ids_seq_length</strong> (<code>int</code>) &#x2014;
The length of the input sequence.`,name:"input_ids_seq_length"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1310"}}),Dt=new G({props:{anchor:"transformers.ExponentialDecayLengthPenalty.example",$$slots:{default:[gw]},$$scope:{ctx:M}}}),Ps=new T({props:{name:"__call__",anchor:"transformers.ExponentialDecayLengthPenalty.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1383",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Gs=new T({props:{name:"class transformers.ForcedBOSTokenLogitsProcessor",anchor:"transformers.ForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1242"}}),Es=new T({props:{name:"__call__",anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1254",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Xs=new T({props:{name:"class transformers.ForcedEOSTokenLogitsProcessor",anchor:"transformers.ForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int]]"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached. Optionally, use a
list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1264"}}),Ns=new T({props:{name:"__call__",anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1282",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Hs=new T({props:{name:"class transformers.ForceTokensLogitsProcessor",anchor:"transformers.ForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:": typing.List[typing.List[int]]"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1440"}}),Rs=new T({props:{name:"__call__",anchor:"transformers.ForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForceTokensLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForceTokensLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1448",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Os=new T({props:{name:"class transformers.HammingDiversityLogitsProcessor",anchor:"transformers.HammingDiversityLogitsProcessor",parameters:[{name:"diversity_penalty",val:": float"},{name:"num_beams",val:": int"},{name:"num_beam_groups",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.diversity_penalty",description:`<strong>diversity_penalty</strong> (<code>float</code>) &#x2014;
This value is subtracted from a beam&#x2019;s score if it generates a token same as any beam from other group at a
particular time. Note that <code>diversity_penalty</code> is only effective if group beam search is enabled. The
penalty applied to a beam&#x2019;s score when it generates a token that has already been chosen by another beam
within the same group during the same time step. A higher <code>diversity_penalty</code> will enforce greater
diversity among the beams, making it less likely for multiple beams to choose the same token. Conversely, a
lower penalty will allow beams to more freely choose similar tokens. Adjusting this value can help strike a
balance between diversity and natural likelihood.`,name:"diversity_penalty"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams used for group beam search. Beam search is a method used that maintains beams (or &#x201C;multiple
hypotheses&#x201D;) at each step, expanding each one and keeping the top-scoring sequences. A higher <code>num_beams</code>
will explore more potential sequences. This can increase chances of finding a high-quality output but also
increases computational cost.`,name:"num_beams"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
Each group of beams will operate independently, selecting tokens without considering the choices of other
groups. This division promotes diversity by ensuring that beams within different groups explore different
paths. For instance, if <code>num_beams</code> is 6 and <code>num_beam_groups</code> is 2, there will be 2 groups each containing
3 beams. The choice of <code>num_beam_groups</code> should be made considering the desired level of output diversity
and the total number of beams. See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1079"}}),Pt=new qn({props:{$$slots:{default:[uw]},$$scope:{ctx:M}}}),Gt=new qn({props:{warning:!0,$$slots:{default:[hw]},$$scope:{ctx:M}}}),Et=new G({props:{anchor:"transformers.HammingDiversityLogitsProcessor.example",$$slots:{default:[fw]},$$scope:{ctx:M}}}),Qs=new T({props:{name:"__call__",anchor:"transformers.HammingDiversityLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"current_tokens",val:": LongTensor"},{name:"beam_group_idx",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.current_tokens",description:`<strong>current_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary, corresponding to the tokens selected by the other
beam groups in the current generation step.`,name:"current_tokens"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.beam_group_idx",description:`<strong>beam_group_idx</strong> (<code>int</code>) &#x2014;
The index of the beam group currently being processed.`,name:"beam_group_idx"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1196",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),As=new T({props:{name:"class transformers.InfNanRemoveLogitsProcessor",anchor:"transformers.InfNanRemoveLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1293"}}),Ys=new T({props:{name:"__call__",anchor:"transformers.InfNanRemoveLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1299",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ks=new T({props:{name:"class transformers.LogitNormalization",anchor:"transformers.LogitNormalization",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1394"}}),eo=new T({props:{name:"__call__",anchor:"transformers.LogitNormalization.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitNormalization.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitNormalization.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1402",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),to=new T({props:{name:"class transformers.LogitsProcessor",anchor:"transformers.LogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L44"}}),no=new T({props:{name:"__call__",anchor:"transformers.LogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L47",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),so=new T({props:{name:"class transformers.LogitsProcessorList",anchor:"transformers.LogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L64"}}),oo=new T({props:{name:"__call__",anchor:"transformers.LogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.LogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional kwargs that are specific to a logits processor.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L71",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ro=new T({props:{name:"class transformers.LogitsWarper",anchor:"transformers.LogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L54"}}),ao=new T({props:{name:"__call__",anchor:"transformers.LogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L57",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),io=new T({props:{name:"class transformers.MinLengthLogitsProcessor",anchor:"transformers.MinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int]]"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.MinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L101"}}),co=new T({props:{name:"__call__",anchor:"transformers.MinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L124",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),lo=new T({props:{name:"class transformers.MinNewTokensLengthLogitsProcessor",anchor:"transformers.MinNewTokensLengthLogitsProcessor",parameters:[{name:"prompt_length_to_skip",val:": int"},{name:"min_new_tokens",val:": int"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int]]"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.prompt_length_to_skip",description:`<strong>prompt_length_to_skip</strong> (<code>int</code>) &#x2014;
The input tokens length. Not a valid argument when used with <code>generate</code> as it will automatically assign the
input length.`,name:"prompt_length_to_skip"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>) &#x2014;
The minimum <em>new</em> tokens length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_new_tokens"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L133"}}),Xt=new G({props:{anchor:"transformers.MinNewTokensLengthLogitsProcessor.example",$$slots:{default:[_w]},$$scope:{ctx:M}}}),po=new T({props:{name:"__call__",anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L195",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),mo=new T({props:{name:"class transformers.NoBadWordsLogitsProcessor",anchor:"transformers.NoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": typing.List[typing.List[int]]"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int]]"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated.`,name:"bad_words_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L965"}}),Nt=new qn({props:{$$slots:{default:[bw]},$$scope:{ctx:M}}}),Ht=new G({props:{anchor:"transformers.NoBadWordsLogitsProcessor.example",$$slots:{default:[Tw]},$$scope:{ctx:M}}}),go=new T({props:{name:"__call__",anchor:"transformers.NoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L888",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),uo=new T({props:{name:"class transformers.NoRepeatNGramLogitsProcessor",anchor:"transformers.NoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L718"}}),Rt=new qn({props:{$$slots:{default:[yw]},$$scope:{ctx:M}}}),Ot=new G({props:{anchor:"transformers.NoRepeatNGramLogitsProcessor.example",$$slots:{default:[vw]},$$scope:{ctx:M}}}),ho=new T({props:{name:"__call__",anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L764",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),fo=new T({props:{name:"class transformers.PrefixConstrainedLogitsProcessor",anchor:"transformers.PrefixConstrainedLogitsProcessor",parameters:[{name:"prefix_allowed_tokens_fn",val:": typing.Callable[[int, torch.Tensor], typing.List[int]]"},{name:"num_beams",val:": int"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>) &#x2014;
This function constraints the beam search to allowed tokens only at each step. This function takes 2
arguments <code>inputs_ids</code> and the batch ID <code>batch_id</code>. It has to return a list with the allowed tokens for the
next generation step conditioned on the previously generated tokens <code>inputs_ids</code> and the batch ID
<code>batch_id</code>.`,name:"prefix_allowed_tokens_fn"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1052"}}),_o=new T({props:{name:"__call__",anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1069",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),bo=new T({props:{name:"class transformers.RepetitionPenaltyLogitsProcessor",anchor:"transformers.RepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.penalty",description:`<strong>penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. Above 1.0 penalizes previously generated
tokens. Between 0.0 and 1.0 rewards previously generated tokens. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"penalty"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L270"}}),Qt=new G({props:{anchor:"transformers.RepetitionPenaltyLogitsProcessor.example",$$slots:{default:[$w]},$$scope:{ctx:M}}}),To=new T({props:{name:"__call__",anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L317",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),yo=new T({props:{name:"class transformers.SequenceBiasLogitsProcessor",anchor:"transformers.SequenceBiasLogitsProcessor",parameters:[{name:"sequence_bias",val:": typing.Dict[typing.Tuple[int], float]"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.sequence_bias",description:`<strong>sequence_bias</strong> (<code>Dict[Tuple[int], float]</code>) &#x2014;
Dictionary that maps a sequence of tokens to its bias term. Positive biases increase the odds of the
sequence being selected, while negative biases do the opposite. If a sequence has a length of 1, its bias
will always be applied. Otherwise, the bias will only be applied if the sequence in question is about to be
completed (in the token selection step after this processor is applied).`,name:"sequence_bias"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L817"}}),At=new qn({props:{$$slots:{default:[ww]},$$scope:{ctx:M}}}),Yt=new G({props:{anchor:"transformers.SequenceBiasLogitsProcessor.example",$$slots:{default:[xw]},$$scope:{ctx:M}}}),vo=new T({props:{name:"__call__",anchor:"transformers.SequenceBiasLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L888",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),$o=new T({props:{name:"class transformers.SuppressTokensAtBeginLogitsProcessor",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1408"}}),wo=new T({props:{name:"__call__",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1419",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),xo=new T({props:{name:"class transformers.SuppressTokensLogitsProcessor",anchor:"transformers.SuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1427"}}),ko=new T({props:{name:"__call__",anchor:"transformers.SuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1434",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Mo=new T({props:{name:"class transformers.TemperatureLogitsWarper",anchor:"transformers.TemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
Strictly positive float value used to modulate the logits distribution. A value smaller than <code>1</code> decreases
randomness (and vice versa), with <code>0</code> being equivalent to shifting all probability mass to the most likely
token.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L205"}}),Kt=new qn({props:{$$slots:{default:[kw]},$$scope:{ctx:M}}}),en=new G({props:{anchor:"transformers.TemperatureLogitsWarper.example",$$slots:{default:[Mw]},$$scope:{ctx:M}}}),jo=new T({props:{name:"__call__",anchor:"transformers.TemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TemperatureLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L264",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Lo=new T({props:{name:"class transformers.TopKLogitsWarper",anchor:"transformers.TopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L427"}}),Fo=new T({props:{name:"__call__",anchor:"transformers.TopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopKLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L447",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),zo=new T({props:{name:"class transformers.TopPLogitsWarper",anchor:"transformers.TopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L364"}}),tn=new G({props:{anchor:"transformers.TopPLogitsWarper.example",$$slots:{default:[jw]},$$scope:{ctx:M}}}),Uo=new T({props:{name:"__call__",anchor:"transformers.TopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopPLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L411",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Jo=new T({props:{name:"class transformers.TypicalLogitsWarper",anchor:"transformers.TypicalLogitsWarper",parameters:[{name:"mass",val:": float = 0.9"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.mass",description:`<strong>mass</strong> (<code>float</code>, <em>optional</em>, defaults to 0.9) &#x2014;
Value of typical_p between 0 and 1 inclusive, defaults to 0.9.`,name:"mass"},{anchor:"transformers.TypicalLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TypicalLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L456"}}),Io=new T({props:{name:"__call__",anchor:"transformers.TypicalLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TypicalLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L481",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Co=new T({props:{name:"class transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:": float"},{name:"model",val:""},{name:"unconditional_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"unconditional_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = True"}],parametersDescription:[{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale != 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality. A value smaller than 1 has the opposite effect, while
making the negative prompt provided with negative_prompt_ids (if any) act as a positive prompt.`,name:"guidance_scale"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.model",description:`<strong>model</strong> (<code>PreTrainedModel</code>) &#x2014;
The model computing the unconditional scores. Supposedly the same as the one computing the conditional
scores. Both models must use the same tokenizer.`,name:"model"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_ids",description:`<strong>unconditional_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary for the unconditional branch. If unset, will default to
the last token of the prompt.`,name:"unconditional_ids"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_attention_mask",description:`<strong>unconditional_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Attention mask for unconditional_ids.`,name:"unconditional_attention_mask"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to cache key/values during the negative prompt forward pass.`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1601"}}),nn=new G({props:{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.example",$$slots:{default:[Lw]},$$scope:{ctx:M}}}),Bo=new T({props:{name:"__call__",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1707"}}),qo=new T({props:{name:"class transformers.WhisperTimeStampLogitsProcessor",anchor:"transformers.WhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1458"}}),Wo=new T({props:{name:"__call__",anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1487",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Vo=new X({props:{title:"TensorFlow",local:"transformers.TFForcedBOSTokenLogitsProcessor",headingTag:"h3"}}),So=new T({props:{name:"class transformers.TFForcedBOSTokenLogitsProcessor",anchor:"transformers.TFForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L448"}}),Zo=new T({props:{name:"__call__",anchor:"transformers.TFForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L462"}}),Do=new T({props:{name:"class transformers.TFForcedEOSTokenLogitsProcessor",anchor:"transformers.TFForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L478"}}),Po=new T({props:{name:"__call__",anchor:"transformers.TFForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L495"}}),Go=new T({props:{name:"class transformers.TFForceTokensLogitsProcessor",anchor:"transformers.TFForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:": typing.List[typing.List[int]]"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L551"}}),Eo=new T({props:{name:"__call__",anchor:"transformers.TFForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L567"}}),Xo=new T({props:{name:"class transformers.TFLogitsProcessor",anchor:"transformers.TFLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L53"}}),No=new T({props:{name:"__call__",anchor:"transformers.TFLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessor.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L56",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ho=new T({props:{name:"class transformers.TFLogitsProcessorList",anchor:"transformers.TFLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L75"}}),Ro=new T({props:{name:"__call__",anchor:"transformers.TFLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessorList.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L82",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Oo=new T({props:{name:"class transformers.TFLogitsWarper",anchor:"transformers.TFLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L64"}}),Qo=new T({props:{name:"__call__",anchor:"transformers.TFLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsWarper.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L67",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ao=new T({props:{name:"class transformers.TFMinLengthLogitsProcessor",anchor:"transformers.TFMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.TFMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L202"}}),Yo=new T({props:{name:"__call__",anchor:"transformers.TFMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L228"}}),Ko=new T({props:{name:"class transformers.TFNoBadWordsLogitsProcessor",anchor:"transformers.TFNoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": typing.List[typing.List[int]]"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated. In order to get the tokens of the words
that should not appear in the generated text, make sure to set <code>add_prefix_space=True</code> when initializing
the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The <code>add_prefix_space</code>
argument is only supported for some slow tokenizers, as fast tokenizers&#x2019; prefixing behaviours come from
<code>pre tokenizers</code>. Read more <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`,name:"bad_words_ids"},{anchor:"transformers.TFNoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L288"}}),er=new T({props:{name:"__call__",anchor:"transformers.TFNoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L367"}}),tr=new T({props:{name:"class transformers.TFNoRepeatNGramLogitsProcessor",anchor:"transformers.TFNoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L388"}}),nr=new T({props:{name:"__call__",anchor:"transformers.TFNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L427"}}),sr=new T({props:{name:"class transformers.TFRepetitionPenaltyLogitsProcessor",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"}],parametersDescription:[{anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L238"}}),or=new T({props:{name:"__call__",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L280"}}),rr=new T({props:{name:"class transformers.TFSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L511"}}),ar=new T({props:{name:"__call__",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L522"}}),ir=new T({props:{name:"class transformers.TFSuppressTokensLogitsProcessor",anchor:"transformers.TFSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L535"}}),cr=new T({props:{name:"__call__",anchor:"transformers.TFSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L542"}}),lr=new T({props:{name:"class transformers.TFTemperatureLogitsWarper",anchor:"transformers.TFTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TFTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L98"}}),dr=new T({props:{name:"__call__",anchor:"transformers.TFTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L113"}}),pr=new T({props:{name:"class transformers.TFTopKLogitsWarper",anchor:"transformers.TFTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TFTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L118"}}),mr=new T({props:{name:"__call__",anchor:"transformers.TFTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L138"}}),gr=new T({props:{name:"class transformers.TFTopPLogitsWarper",anchor:"transformers.TFTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TFTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L146"}}),ur=new T({props:{name:"__call__",anchor:"transformers.TFTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L170"}}),hr=new X({props:{title:"FLAX",local:"transformers.FlaxForcedBOSTokenLogitsProcessor",headingTag:"h3"}}),fr=new T({props:{name:"class transformers.FlaxForcedBOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L194"}}),_r=new T({props:{name:"__call__",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L206"}}),br=new T({props:{name:"class transformers.FlaxForcedEOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L216"}}),Tr=new T({props:{name:"__call__",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L231"}}),yr=new T({props:{name:"class transformers.FlaxForceTokensLogitsProcessor",anchor:"transformers.FlaxForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:""}],parametersDescription:[{anchor:"transformers.FlaxForceTokensLogitsProcessor.force_token_map",description:`<strong>force_token_map</strong> (<code>list</code>) &#x2014;
Map giving token ids and indices where they will be forced to be sampled.`,name:"force_token_map"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L315"}}),vr=new T({props:{name:"__call__",anchor:"transformers.FlaxForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L337"}}),$r=new T({props:{name:"class transformers.FlaxLogitsProcessor",anchor:"transformers.FlaxLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L50"}}),wr=new T({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L53",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),xr=new T({props:{name:"class transformers.FlaxLogitsProcessorList",anchor:"transformers.FlaxLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L72"}}),kr=new T({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L79",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Mr=new T({props:{name:"class transformers.FlaxLogitsWarper",anchor:"transformers.FlaxLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L61"}}),jr=new T({props:{name:"__call__",anchor:"transformers.FlaxLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L64",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Lr=new T({props:{name:"class transformers.FlaxMinLengthLogitsProcessor",anchor:"transformers.FlaxMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.FlaxMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L241"}}),Fr=new T({props:{name:"__call__",anchor:"transformers.FlaxMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L262"}}),zr=new T({props:{name:"class transformers.FlaxSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_suppress_tokens",description:`<strong>begin_suppress_tokens</strong> (<code>List[int]</code>) &#x2014;
Tokens to not sample.`,name:"begin_suppress_tokens"},{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_index",description:`<strong>begin_index</strong> (<code>int</code>) &#x2014;
Index where the tokens are suppressed.`,name:"begin_index"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L271"}}),Ur=new T({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L288"}}),Jr=new T({props:{name:"class transformers.FlaxSuppressTokensLogitsProcessor",anchor:"transformers.FlaxSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:": list"}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensLogitsProcessor.suppress_tokens",description:`<strong>suppress_tokens</strong> (<code>list</code>) &#x2014;
Tokens to not sample.`,name:"suppress_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L296"}}),Ir=new T({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L309"}}),Cr=new T({props:{name:"class transformers.FlaxTemperatureLogitsWarper",anchor:"transformers.FlaxTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.FlaxTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L95"}}),Br=new T({props:{name:"__call__",anchor:"transformers.FlaxTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L110"}}),qr=new T({props:{name:"class transformers.FlaxTopKLogitsWarper",anchor:"transformers.FlaxTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.FlaxTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L159"}}),Wr=new T({props:{name:"__call__",anchor:"transformers.FlaxTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L179"}}),Vr=new T({props:{name:"class transformers.FlaxTopPLogitsWarper",anchor:"transformers.FlaxTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.FlaxTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L115"}}),Sr=new T({props:{name:"__call__",anchor:"transformers.FlaxTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L139"}}),Zr=new T({props:{name:"class transformers.FlaxWhisperTimeStampLogitsProcessor",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""},{name:"model_config",val:""},{name:"decoder_input_length",val:""}],parametersDescription:[{anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L363"}}),Dr=new T({props:{name:"__call__",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L397"}}),Pr=new X({props:{title:"StoppingCriteria",local:"transformers.StoppingCriteria",headingTag:"h2"}}),Er=new T({props:{name:"class transformers.StoppingCriteria",anchor:"transformers.StoppingCriteria",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L37"}}),Xr=new T({props:{name:"__call__",anchor:"transformers.StoppingCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.StoppingCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L44",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code>. <code>False</code> indicates we should continue, <code>True</code> indicates we should stop.</p>
`}}),Nr=new T({props:{name:"class transformers.StoppingCriteriaList",anchor:"transformers.StoppingCriteriaList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L129"}}),Hr=new T({props:{name:"__call__",anchor:"transformers.StoppingCriteriaList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteriaList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteriaList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.StoppingCriteriaList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L130",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code>. <code>False</code> indicates we should continue, <code>True</code> indicates we should stop.</p>
`}}),Rr=new T({props:{name:"class transformers.MaxLengthCriteria",anchor:"transformers.MaxLengthCriteria",parameters:[{name:"max_length",val:": int"},{name:"max_position_embeddings",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length that the output sequence can have in number of tokens.`,name:"max_length"},{anchor:"transformers.MaxLengthCriteria.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum model length, as defined by the model&#x2019;s <code>config.max_position_embeddings</code> attribute.`,name:"max_position_embeddings"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L49"}}),Or=new T({props:{name:"__call__",anchor:"transformers.MaxLengthCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxLengthCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.MaxLengthCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L65",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code>. <code>False</code> indicates we should continue, <code>True</code> indicates we should stop.</p>
`}}),Qr=new T({props:{name:"class transformers.MaxTimeCriteria",anchor:"transformers.MaxTimeCriteria",parameters:[{name:"max_time",val:": float"},{name:"initial_timestamp",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.max_time",description:`<strong>max_time</strong> (<code>float</code>) &#x2014;
The maximum allowed time in seconds for the generation.`,name:"max_time"},{anchor:"transformers.MaxTimeCriteria.initial_time",description:`<strong>initial_time</strong> (<code>float</code>, <em>optional</em>, defaults to <code>time.time()</code>) &#x2014;
The start of the generation allowed time.`,name:"initial_time"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L107"}}),Ar=new T({props:{name:"__call__",anchor:"transformers.MaxTimeCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxTimeCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.MaxTimeCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L124",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code>. <code>False</code> indicates we should continue, <code>True</code> indicates we should stop.</p>
`}}),Yr=new X({props:{title:"Constraints",local:"transformers.Constraint",headingTag:"h2"}}),ea=new T({props:{name:"class transformers.Constraint",anchor:"transformers.Constraint",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L5"}}),cn=new G({props:{anchor:"transformers.Constraint.example",$$slots:{default:[Fw]},$$scope:{ctx:M}}}),ta=new T({props:{name:"advance",anchor:"transformers.Constraint.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L48",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Must be a tensor of a list of indexable tokens, not some integer.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>token_ids(<code>torch.tensor</code>)</p>
`}}),na=new T({props:{name:"copy",anchor:"transformers.Constraint.copy",parameters:[{name:"stateful",val:" = False"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L113",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The same constraint as the one being called from.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>constraint(<code>Constraint</code>)</p>
`}}),sa=new T({props:{name:"does_advance",anchor:"transformers.Constraint.does_advance",parameters:[{name:"token_id",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L60"}}),oa=new T({props:{name:"remaining",anchor:"transformers.Constraint.remaining",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L104"}}),ra=new T({props:{name:"reset",anchor:"transformers.Constraint.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L94"}}),aa=new T({props:{name:"test",anchor:"transformers.Constraint.test",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L24"}}),ia=new T({props:{name:"update",anchor:"transformers.Constraint.update",parameters:[{name:"token_id",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L69",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Whether this constraint has become one step closer to being fulfuilled.
completed(<code>bool</code>):
Whether this constraint has been completely fulfilled by this token being generated.
reset (<code>bool</code>):
Whether this constraint has reset its progress by this token being generated.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>stepped(<code>bool</code>)</p>
`}}),ca=new T({props:{name:"class transformers.PhrasalConstraint",anchor:"transformers.PhrasalConstraint",parameters:[{name:"token_ids",val:": typing.List[int]"}],parametersDescription:[{anchor:"transformers.PhrasalConstraint.token_ids",description:`<strong>token_ids</strong> (<code>List[int]</code>) &#x2014;
The id of the token that must be generated by the output.`,name:"token_ids"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L129"}}),la=new T({props:{name:"class transformers.DisjunctiveConstraint",anchor:"transformers.DisjunctiveConstraint",parameters:[{name:"nested_token_ids",val:": typing.List[typing.List[int]]"}],parametersDescription:[{anchor:"transformers.DisjunctiveConstraint.nested_token_ids",description:`<strong>nested_token_ids</strong> (<code>List[List[int]]</code>) &#x2014;
A list of words, where each word is a list of ids. This constraint is fulfilled by generating just one from
the list of words.`,name:"nested_token_ids"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L261"}}),da=new T({props:{name:"class transformers.ConstraintListState",anchor:"transformers.ConstraintListState",parameters:[{name:"constraints",val:": typing.List[transformers.generation.beam_constraints.Constraint]"}],parametersDescription:[{anchor:"transformers.ConstraintListState.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Constraint">Constraint</a> objects that must be fulfilled by the beam scorer.`,name:"constraints"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L351"}}),pa=new T({props:{name:"advance",anchor:"transformers.ConstraintListState.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L383"}}),ma=new T({props:{name:"reset",anchor:"transformers.ConstraintListState.reset",parameters:[{name:"token_ids",val:": typing.Optional[typing.List[int]]"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L418"}}),ga=new X({props:{title:"BeamSearch",local:"transformers.BeamScorer",headingTag:"h2"}}),ua=new T({props:{name:"class transformers.BeamScorer",anchor:"transformers.BeamScorer",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L91"}}),ha=new T({props:{name:"process",anchor:"transformers.BeamScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.BeamScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.BeamScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.BeamScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.BeamScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"},{anchor:"transformers.BeamScorer.process.group_index",description:`<strong>group_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The index of the group of beams. Used with <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search">group_beam_search()</a>.`,name:"group_index"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L97",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Updated scores of all
non-finished beams.</li>
<li><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Next tokens to be added
to the non-finished beam_hypotheses.</li>
<li><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Beam indices
indicating to which beam the next tokens shall be added.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>UserDict</code></p>
`}}),fa=new T({props:{name:"finalize",anchor:"transformers.BeamScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.finalize.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.finalize.final_beam_scores",description:`<strong>final_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The final scores of all non-finished beams.`,name:"final_beam_scores"},{anchor:"transformers.BeamScorer.finalize.final_beam_tokens",description:`<strong>final_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The last tokens to be added to the non-finished beam_hypotheses.`,name:"final_beam_tokens"},{anchor:"transformers.BeamScorer.finalize.final_beam_indices",description:`<strong>final_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The beam indices indicating to which beam the <code>final_beam_tokens</code> shall be added.`,name:"final_beam_indices"},{anchor:"transformers.BeamScorer.finalize.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.finalize.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L109",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated sequences.
The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter if all batches finished early
due to the <code>eos_token_id</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.LongTensor</code> of shape <code>(batch_size * num_return_sequences, sequence_length)</code></p>
`}}),_a=new T({props:{name:"class transformers.BeamSearchScorer",anchor:"transformers.BeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"device",val:": device"},{name:"length_penalty",val:": typing.Optional[float] = 1.0"},{name:"do_early_stopping",val:": typing.Union[str, bool, NoneType] = False"},{name:"num_beam_hyps_to_keep",val:": typing.Optional[int] = 1"},{name:"num_beam_groups",val:": typing.Optional[int] = 1"},{name:"max_length",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"transformers.BeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.BeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.BeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.BeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.BeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.BeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<code>~transformer.BeamSearchScorer.finalize</code>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.BeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.BeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L123"}}),ba=new T({props:{name:"process",anchor:"transformers.BeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"group_index",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L215"}}),Ta=new T({props:{name:"finalize",anchor:"transformers.BeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L315"}}),ya=new T({props:{name:"class transformers.ConstrainedBeamSearchScorer",anchor:"transformers.ConstrainedBeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"constraints",val:": typing.List[transformers.generation.beam_constraints.Constraint]"},{name:"device",val:": device"},{name:"length_penalty",val:": typing.Optional[float] = 1.0"},{name:"do_early_stopping",val:": typing.Union[str, bool, NoneType] = False"},{name:"num_beam_hyps_to_keep",val:": typing.Optional[int] = 1"},{name:"num_beam_groups",val:": typing.Optional[int] = 1"},{name:"max_length",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.ConstrainedBeamSearchScorer.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of positive constraints represented as <code>Constraint</code> objects that must be fulfilled in the generation
output. For more information, the documentation of <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Constraint">Constraint</a> should be read.`,name:"constraints"},{anchor:"transformers.ConstrainedBeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.ConstrainedBeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.ConstrainedBeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<code>~transformer.BeamSearchScorer.finalize</code>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.ConstrainedBeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L410"}}),va=new T({props:{name:"process",anchor:"transformers.ConstrainedBeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"scores_for_all_vocab",val:": FloatTensor"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.scores_for_all_vocab",description:`<strong>scores_for_all_vocab</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
The scores of all tokens in the vocabulary for each of the beam hypotheses.`,name:"scores_for_all_vocab"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L504",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li>
<p><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Updated scores of
all
non-finished beams.</p>
</li>
<li>
<p><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Next tokens to be
added
to the non-finished beam_hypotheses.</p>
</li>
<li>
<p><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Beam indices
indicating to which beam the next tokens shall be added.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>UserDict</code></p>
`}}),$a=new T({props:{name:"finalize",anchor:"transformers.ConstrainedBeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L798"}}),wa=new X({props:{title:"Utilities",local:"transformers.top_k_top_p_filtering",headingTag:"h2"}}),xa=new T({props:{name:"transformers.top_k_top_p_filtering",anchor:"transformers.top_k_top_p_filtering",parameters:[{name:"logits",val:": FloatTensor"},{name:"top_k",val:": int = 0"},{name:"top_p",val:": float = 1.0"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.top_k_top_p_filtering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If &gt; 0, only keep the top k tokens with highest probability (top-k filtering)`,name:"top_k"},{anchor:"transformers.top_k_top_p_filtering.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
If &lt; 1.0, only keep the top tokens with cumulative probability &gt;= top_p (nucleus filtering). Nucleus
filtering is described in Holtzman et al. (<a href="http://arxiv.org/abs/1904.09751" rel="nofollow">http://arxiv.org/abs/1904.09751</a>)`,name:"top_p"},{anchor:"transformers.top_k_top_p_filtering.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimumber of tokens we keep per batch example in the output.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L4732"}}),ka=new T({props:{name:"transformers.tf_top_k_top_p_filtering",anchor:"transformers.tf_top_k_top_p_filtering",parameters:[{name:"logits",val:""},{name:"top_k",val:" = 0"},{name:"top_p",val:" = 1.0"},{name:"filter_value",val:" = -inf"},{name:"min_tokens_to_keep",val:" = 1"}],parametersDescription:[{anchor:"transformers.tf_top_k_top_p_filtering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If &gt; 0, only keep the top k tokens with highest probability (top-k filtering)`,name:"top_k"},{anchor:"transformers.tf_top_k_top_p_filtering.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
If &lt; 1.0, only keep the top tokens with cumulative probability &gt;= top_p (nucleus filtering). Nucleus
filtering is described in Holtzman et al. (<a href="http://arxiv.org/abs/1904.09751" rel="nofollow">http://arxiv.org/abs/1904.09751</a>)`,name:"top_p"},{anchor:"transformers.tf_top_k_top_p_filtering.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimumber of tokens we keep per batch example in the output.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L3068"}}),Ma=new X({props:{title:"Streamers",local:"transformers.TextStreamer",headingTag:"h2"}}),ja=new T({props:{name:"class transformers.TextStreamer",anchor:"transformers.TextStreamer",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"skip_prompt",val:": bool = False"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L38"}}),fn=new qn({props:{warning:!0,$$slots:{default:[zw]},$$scope:{ctx:M}}}),_n=new G({props:{anchor:"transformers.TextStreamer.example",$$slots:{default:[Uw]},$$scope:{ctx:M}}}),La=new T({props:{name:"end",anchor:"transformers.TextStreamer.end",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L116"}}),Fa=new T({props:{name:"on_finalized_text",anchor:"transformers.TextStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L130"}}),za=new T({props:{name:"put",anchor:"transformers.TextStreamer.put",parameters:[{name:"value",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L82"}}),Ua=new T({props:{name:"class transformers.TextIteratorStreamer",anchor:"transformers.TextIteratorStreamer",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"skip_prompt",val:": bool = False"},{name:"timeout",val:": typing.Optional[float] = None"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextIteratorStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextIteratorStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextIteratorStreamer.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The timeout for the text queue. If <code>None</code>, the queue will block indefinitely. Useful to handle exceptions
in <code>.generate()</code>, when it is called in a separate thread.`,name:"timeout"},{anchor:"transformers.TextIteratorStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L159"}}),vn=new qn({props:{warning:!0,$$slots:{default:[Jw]},$$scope:{ctx:M}}}),$n=new G({props:{anchor:"transformers.TextIteratorStreamer.example",$$slots:{default:[Iw]},$$scope:{ctx:M}}}),Ja=new T({props:{name:"on_finalized_text",anchor:"transformers.TextIteratorStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L213"}}),{c(){f=r("meta"),x=s(),$=r("p"),v=s(),l(w.$$.fragment),h=s(),k=r("p"),k.innerHTML=sT,Sp=s(),Wn=r("p"),Wn.textContent=oT,Zp=s(),l(Vn.$$.fragment),Dp=s(),Sn=r("p"),Sn.innerHTML=rT,Pp=s(),Zn=r("p"),Zn.textContent=aT,Gp=s(),l(Dn.$$.fragment),Ep=s(),Pn=r("p"),Pn.innerHTML=iT,Xp=s(),Gn=r("ul"),Gn.innerHTML=cT,Np=s(),En=r("p"),En.innerHTML=lT,Hp=s(),Xn=r("p"),Xn.innerHTML=dT,Rp=s(),Nn=r("p"),Nn.innerHTML=pT,Op=s(),l(Hn.$$.fragment),Qp=s(),Rn=r("p"),Rn.innerHTML=mT,Ap=s(),On=r("p"),On.innerHTML=gT,Yp=s(),Qn=r("p"),Qn.textContent=uT,Kp=s(),l(An.$$.fragment),em=s(),pt=r("div"),l(Yn.$$.fragment),ku=s(),ei=r("p"),ei.textContent=hT,tm=s(),mt=r("div"),l(Kn.$$.fragment),Mu=s(),ti=r("p"),ti.textContent=fT,nm=s(),gt=r("div"),l(es.$$.fragment),ju=s(),ni=r("p"),ni.textContent=_T,sm=s(),ut=r("div"),l(ts.$$.fragment),Lu=s(),si=r("p"),si.textContent=bT,om=s(),ht=r("div"),l(ns.$$.fragment),Fu=s(),oi=r("p"),oi.textContent=TT,rm=s(),ft=r("div"),l(ss.$$.fragment),zu=s(),ri=r("p"),ri.textContent=yT,am=s(),_t=r("div"),l(os.$$.fragment),Uu=s(),ai=r("p"),ai.textContent=vT,im=s(),bt=r("div"),l(rs.$$.fragment),Ju=s(),ii=r("p"),ii.textContent=$T,cm=s(),Tt=r("div"),l(as.$$.fragment),Iu=s(),ci=r("p"),ci.textContent=wT,lm=s(),yt=r("div"),l(is.$$.fragment),Cu=s(),li=r("p"),li.textContent=xT,dm=s(),l(cs.$$.fragment),pm=s(),vt=r("div"),l(ls.$$.fragment),Bu=s(),di=r("p"),di.textContent=kT,mm=s(),$t=r("div"),l(ds.$$.fragment),qu=s(),pi=r("p"),pi.textContent=MT,gm=s(),wt=r("div"),l(ps.$$.fragment),Wu=s(),mi=r("p"),mi.textContent=jT,um=s(),xt=r("div"),l(ms.$$.fragment),Vu=s(),gi=r("p"),gi.textContent=LT,hm=s(),kt=r("div"),l(gs.$$.fragment),Su=s(),ui=r("p"),ui.textContent=FT,fm=s(),Mt=r("div"),l(us.$$.fragment),Zu=s(),hi=r("p"),hi.textContent=zT,_m=s(),jt=r("div"),l(hs.$$.fragment),Du=s(),fi=r("p"),fi.textContent=UT,bm=s(),Lt=r("div"),l(fs.$$.fragment),Pu=s(),_i=r("p"),_i.textContent=JT,Tm=s(),Ft=r("div"),l(_s.$$.fragment),Gu=s(),bi=r("p"),bi.textContent=IT,ym=s(),zt=r("div"),l(bs.$$.fragment),Eu=s(),Ti=r("p"),Ti.textContent=CT,vm=s(),l(Ts.$$.fragment),$m=s(),ae=r("div"),l(ys.$$.fragment),Xu=s(),yi=r("p"),yi.textContent=BT,Nu=s(),qt=r("div"),l(vs.$$.fragment),Hu=s(),vi=r("p"),vi.textContent=qT,wm=s(),ie=r("div"),l($s.$$.fragment),Ru=s(),$i=r("p"),$i.textContent=WT,Ou=s(),Wt=r("div"),l(ws.$$.fragment),Qu=s(),wi=r("p"),wi.textContent=VT,xm=s(),ce=r("div"),l(xs.$$.fragment),Au=s(),xi=r("p"),xi.textContent=ST,Yu=s(),Vt=r("div"),l(ks.$$.fragment),Ku=s(),ki=r("p"),ki.textContent=ZT,km=s(),l(Ms.$$.fragment),Mm=s(),js=r("p"),js.innerHTML=DT,jm=s(),l(Ls.$$.fragment),Lm=s(),le=r("div"),l(Fs.$$.fragment),eh=s(),Mi=r("p"),Mi.innerHTML=PT,th=s(),ji=r("div"),l(zs.$$.fragment),Fm=s(),N=r("div"),l(Us.$$.fragment),nh=s(),Li=r("p"),Li.innerHTML=GT,sh=s(),Fi=r("p"),Fi.innerHTML=ET,oh=s(),zi=r("div"),l(Js.$$.fragment),zm=s(),de=r("div"),l(Is.$$.fragment),rh=s(),Ui=r("p"),Ui.innerHTML=XT,ah=s(),Ji=r("div"),l(Cs.$$.fragment),Um=s(),H=r("div"),l(Bs.$$.fragment),ih=s(),Ii=r("p"),Ii.innerHTML=NT,ch=s(),Ci=r("p"),Ci.innerHTML=HT,lh=s(),Bi=r("div"),l(qs.$$.fragment),Jm=s(),R=r("div"),l(Ws.$$.fragment),dh=s(),qi=r("p"),qi.innerHTML=RT,ph=s(),l(St.$$.fragment),mh=s(),Wi=r("div"),l(Vs.$$.fragment),Im=s(),O=r("div"),l(Ss.$$.fragment),gh=s(),Vi=r("p"),Vi.innerHTML=OT,uh=s(),l(Zt.$$.fragment),hh=s(),Si=r("div"),l(Zs.$$.fragment),Cm=s(),Q=r("div"),l(Ds.$$.fragment),fh=s(),Zi=r("p"),Zi.innerHTML=QT,_h=s(),l(Dt.$$.fragment),bh=s(),Di=r("div"),l(Ps.$$.fragment),Bm=s(),pe=r("div"),l(Gs.$$.fragment),Th=s(),Pi=r("p"),Pi.innerHTML=AT,yh=s(),Gi=r("div"),l(Es.$$.fragment),qm=s(),me=r("div"),l(Xs.$$.fragment),vh=s(),Ei=r("p"),Ei.innerHTML=YT,$h=s(),Xi=r("div"),l(Ns.$$.fragment),Wm=s(),ge=r("div"),l(Hs.$$.fragment),wh=s(),Ni=r("p"),Ni.innerHTML=KT,xh=s(),Hi=r("div"),l(Rs.$$.fragment),Vm=s(),j=r("div"),l(Os.$$.fragment),kh=s(),Ri=r("p"),Ri.innerHTML=ey,Mh=s(),Oi=r("p"),Oi.innerHTML=ty,jh=s(),l(Pt.$$.fragment),Lh=s(),l(Gt.$$.fragment),Fh=s(),Qi=r("p"),Qi.innerHTML=ny,zh=s(),Ai=r("p"),Ai.textContent=sy,Uh=s(),Yi=r("ul"),Yi.innerHTML=oy,Jh=s(),Ki=r("p"),Ki.textContent=ry,Ih=s(),ec=r("ul"),ec.innerHTML=ay,Ch=s(),l(Et.$$.fragment),Bh=s(),tc=r("div"),l(Qs.$$.fragment),Sm=s(),ue=r("div"),l(As.$$.fragment),qh=s(),nc=r("p"),nc.innerHTML=iy,Wh=s(),sc=r("div"),l(Ys.$$.fragment),Zm=s(),he=r("div"),l(Ks.$$.fragment),Vh=s(),oc=r("p"),oc.innerHTML=cy,Sh=s(),rc=r("div"),l(eo.$$.fragment),Dm=s(),fe=r("div"),l(to.$$.fragment),Zh=s(),ac=r("p"),ac.textContent=ly,Dh=s(),ic=r("div"),l(no.$$.fragment),Pm=s(),_e=r("div"),l(so.$$.fragment),Ph=s(),cc=r("p"),cc.innerHTML=dy,Gh=s(),lc=r("div"),l(oo.$$.fragment),Gm=s(),be=r("div"),l(ro.$$.fragment),Eh=s(),dc=r("p"),dc.textContent=py,Xh=s(),pc=r("div"),l(ao.$$.fragment),Em=s(),Te=r("div"),l(io.$$.fragment),Nh=s(),mc=r("p"),mc.innerHTML=my,Hh=s(),gc=r("div"),l(co.$$.fragment),Xm=s(),A=r("div"),l(lo.$$.fragment),Rh=s(),uc=r("p"),uc.innerHTML=gy,Oh=s(),l(Xt.$$.fragment),Qh=s(),hc=r("div"),l(po.$$.fragment),Nm=s(),q=r("div"),l(mo.$$.fragment),Ah=s(),fc=r("p"),fc.innerHTML=uy,Yh=s(),l(Nt.$$.fragment),Kh=s(),l(Ht.$$.fragment),ef=s(),_c=r("div"),l(go.$$.fragment),Hm=s(),W=r("div"),l(uo.$$.fragment),tf=s(),bc=r("p"),bc.innerHTML=hy,nf=s(),l(Rt.$$.fragment),sf=s(),l(Ot.$$.fragment),of=s(),Tc=r("div"),l(ho.$$.fragment),Rm=s(),ye=r("div"),l(fo.$$.fragment),rf=s(),yc=r("p"),yc.innerHTML=fy,af=s(),vc=r("div"),l(_o.$$.fragment),Om=s(),V=r("div"),l(bo.$$.fragment),cf=s(),$c=r("p"),$c.innerHTML=_y,lf=s(),wc=r("p"),wc.innerHTML=by,df=s(),l(Qt.$$.fragment),pf=s(),xc=r("div"),l(To.$$.fragment),Qm=s(),S=r("div"),l(yo.$$.fragment),mf=s(),kc=r("p"),kc.innerHTML=Ty,gf=s(),l(At.$$.fragment),uf=s(),l(Yt.$$.fragment),hf=s(),Mc=r("div"),l(vo.$$.fragment),Am=s(),ve=r("div"),l($o.$$.fragment),ff=s(),jc=r("p"),jc.innerHTML=yy,_f=s(),Lc=r("div"),l(wo.$$.fragment),Ym=s(),$e=r("div"),l(xo.$$.fragment),bf=s(),Fc=r("p"),Fc.innerHTML=vy,Tf=s(),zc=r("div"),l(ko.$$.fragment),Km=s(),Z=r("div"),l(Mo.$$.fragment),yf=s(),Uc=r("p"),Uc.innerHTML=$y,vf=s(),l(Kt.$$.fragment),$f=s(),l(en.$$.fragment),wf=s(),Jc=r("div"),l(jo.$$.fragment),eg=s(),we=r("div"),l(Lo.$$.fragment),xf=s(),Ic=r("p"),Ic.innerHTML=wy,kf=s(),Cc=r("div"),l(Fo.$$.fragment),tg=s(),Y=r("div"),l(zo.$$.fragment),Mf=s(),Bc=r("p"),Bc.innerHTML=xy,jf=s(),l(tn.$$.fragment),Lf=s(),qc=r("div"),l(Uo.$$.fragment),ng=s(),xe=r("div"),l(Jo.$$.fragment),Ff=s(),Wc=r("p"),Wc.innerHTML=ky,zf=s(),Vc=r("div"),l(Io.$$.fragment),sg=s(),D=r("div"),l(Co.$$.fragment),Uf=s(),Sc=r("p"),Sc.innerHTML=My,Jf=s(),Zc=r("p"),Zc.innerHTML=jy,If=s(),l(nn.$$.fragment),Cf=s(),Dc=r("div"),l(Bo.$$.fragment),og=s(),K=r("div"),l(qo.$$.fragment),Bf=s(),Pc=r("p"),Pc.innerHTML=Ly,qf=s(),Gc=r("p"),Gc.innerHTML=Fy,Wf=s(),Ec=r("div"),l(Wo.$$.fragment),rg=s(),l(Vo.$$.fragment),ag=s(),ke=r("div"),l(So.$$.fragment),Vf=s(),Xc=r("p"),Xc.innerHTML=zy,Sf=s(),Nc=r("div"),l(Zo.$$.fragment),ig=s(),Me=r("div"),l(Do.$$.fragment),Zf=s(),Hc=r("p"),Hc.innerHTML=Uy,Df=s(),Rc=r("div"),l(Po.$$.fragment),cg=s(),je=r("div"),l(Go.$$.fragment),Pf=s(),Oc=r("p"),Oc.innerHTML=Jy,Gf=s(),Qc=r("div"),l(Eo.$$.fragment),lg=s(),Le=r("div"),l(Xo.$$.fragment),Ef=s(),Ac=r("p"),Ac.textContent=Iy,Xf=s(),sn=r("div"),l(No.$$.fragment),Nf=s(),Yc=r("p"),Yc.textContent=Cy,dg=s(),Fe=r("div"),l(Ho.$$.fragment),Hf=s(),Kc=r("p"),Kc.innerHTML=By,Rf=s(),el=r("div"),l(Ro.$$.fragment),pg=s(),ze=r("div"),l(Oo.$$.fragment),Of=s(),tl=r("p"),tl.textContent=qy,Qf=s(),on=r("div"),l(Qo.$$.fragment),Af=s(),nl=r("p"),nl.textContent=Wy,mg=s(),Ue=r("div"),l(Ao.$$.fragment),Yf=s(),sl=r("p"),sl.innerHTML=Vy,Kf=s(),ol=r("div"),l(Yo.$$.fragment),gg=s(),Je=r("div"),l(Ko.$$.fragment),e_=s(),rl=r("p"),rl.innerHTML=Sy,t_=s(),al=r("div"),l(er.$$.fragment),ug=s(),Ie=r("div"),l(tr.$$.fragment),n_=s(),il=r("p"),il.innerHTML=Zy,s_=s(),cl=r("div"),l(nr.$$.fragment),hg=s(),Ce=r("div"),l(sr.$$.fragment),o_=s(),ll=r("p"),ll.innerHTML=Dy,r_=s(),dl=r("div"),l(or.$$.fragment),fg=s(),Be=r("div"),l(rr.$$.fragment),a_=s(),pl=r("p"),pl.innerHTML=Py,i_=s(),ml=r("div"),l(ar.$$.fragment),_g=s(),qe=r("div"),l(ir.$$.fragment),c_=s(),gl=r("p"),gl.innerHTML=Gy,l_=s(),ul=r("div"),l(cr.$$.fragment),bg=s(),We=r("div"),l(lr.$$.fragment),d_=s(),hl=r("p"),hl.innerHTML=Ey,p_=s(),fl=r("div"),l(dr.$$.fragment),Tg=s(),Ve=r("div"),l(pr.$$.fragment),m_=s(),_l=r("p"),_l.innerHTML=Xy,g_=s(),bl=r("div"),l(mr.$$.fragment),yg=s(),Se=r("div"),l(gr.$$.fragment),u_=s(),Tl=r("p"),Tl.innerHTML=Ny,h_=s(),yl=r("div"),l(ur.$$.fragment),vg=s(),l(hr.$$.fragment),$g=s(),Ze=r("div"),l(fr.$$.fragment),f_=s(),vl=r("p"),vl.innerHTML=Hy,__=s(),$l=r("div"),l(_r.$$.fragment),wg=s(),De=r("div"),l(br.$$.fragment),b_=s(),wl=r("p"),wl.innerHTML=Ry,T_=s(),xl=r("div"),l(Tr.$$.fragment),xg=s(),Pe=r("div"),l(yr.$$.fragment),y_=s(),kl=r("p"),kl.innerHTML=Oy,v_=s(),Ml=r("div"),l(vr.$$.fragment),kg=s(),Ge=r("div"),l($r.$$.fragment),$_=s(),jl=r("p"),jl.textContent=Qy,w_=s(),rn=r("div"),l(wr.$$.fragment),x_=s(),Ll=r("p"),Ll.textContent=Ay,Mg=s(),Ee=r("div"),l(xr.$$.fragment),k_=s(),Fl=r("p"),Fl.innerHTML=Yy,M_=s(),zl=r("div"),l(kr.$$.fragment),jg=s(),Xe=r("div"),l(Mr.$$.fragment),j_=s(),Ul=r("p"),Ul.textContent=Ky,L_=s(),an=r("div"),l(jr.$$.fragment),F_=s(),Jl=r("p"),Jl.textContent=ev,Lg=s(),Ne=r("div"),l(Lr.$$.fragment),z_=s(),Il=r("p"),Il.innerHTML=tv,U_=s(),Cl=r("div"),l(Fr.$$.fragment),Fg=s(),He=r("div"),l(zr.$$.fragment),J_=s(),Bl=r("p"),Bl.innerHTML=nv,I_=s(),ql=r("div"),l(Ur.$$.fragment),zg=s(),Re=r("div"),l(Jr.$$.fragment),C_=s(),Wl=r("p"),Wl.innerHTML=sv,B_=s(),Vl=r("div"),l(Ir.$$.fragment),Ug=s(),Oe=r("div"),l(Cr.$$.fragment),q_=s(),Sl=r("p"),Sl.innerHTML=ov,W_=s(),Zl=r("div"),l(Br.$$.fragment),Jg=s(),Qe=r("div"),l(qr.$$.fragment),V_=s(),Dl=r("p"),Dl.innerHTML=rv,S_=s(),Pl=r("div"),l(Wr.$$.fragment),Ig=s(),Ae=r("div"),l(Vr.$$.fragment),Z_=s(),Gl=r("p"),Gl.innerHTML=av,D_=s(),El=r("div"),l(Sr.$$.fragment),Cg=s(),Ye=r("div"),l(Zr.$$.fragment),P_=s(),Xl=r("p"),Xl.innerHTML=iv,G_=s(),Nl=r("div"),l(Dr.$$.fragment),Bg=s(),l(Pr.$$.fragment),qg=s(),Gr=r("p"),Gr.innerHTML=cv,Wg=s(),ee=r("div"),l(Er.$$.fragment),E_=s(),Hl=r("p"),Hl.textContent=lv,X_=s(),Rl=r("p"),Rl.innerHTML=dv,N_=s(),Ol=r("div"),l(Xr.$$.fragment),Vg=s(),Ut=r("div"),l(Nr.$$.fragment),H_=s(),Ql=r("div"),l(Hr.$$.fragment),Sg=s(),Ke=r("div"),l(Rr.$$.fragment),R_=s(),Al=r("p"),Al.innerHTML=pv,O_=s(),Yl=r("div"),l(Or.$$.fragment),Zg=s(),et=r("div"),l(Qr.$$.fragment),Q_=s(),Kl=r("p"),Kl.innerHTML=mv,A_=s(),ed=r("div"),l(Ar.$$.fragment),Dg=s(),l(Yr.$$.fragment),Pg=s(),Kr=r("p"),Kr.innerHTML=gv,Gg=s(),L=r("div"),l(ea.$$.fragment),Y_=s(),td=r("p"),td.textContent=uv,K_=s(),nd=r("p"),nd.textContent=hv,eb=s(),l(cn.$$.fragment),tb=s(),sd=r("p"),sd.textContent=fv,nb=s(),ln=r("div"),l(ta.$$.fragment),sb=s(),od=r("p"),od.textContent=_v,ob=s(),dn=r("div"),l(na.$$.fragment),rb=s(),rd=r("p"),rd.textContent=bv,ab=s(),pn=r("div"),l(sa.$$.fragment),ib=s(),ad=r("p"),ad.textContent=Tv,cb=s(),mn=r("div"),l(oa.$$.fragment),lb=s(),id=r("p"),id.innerHTML=yv,db=s(),gn=r("div"),l(ra.$$.fragment),pb=s(),cd=r("p"),cd.textContent=vv,mb=s(),un=r("div"),l(aa.$$.fragment),gb=s(),ld=r("p"),ld.textContent=$v,ub=s(),st=r("div"),l(ia.$$.fragment),hb=s(),dd=r("p"),dd.innerHTML=wv,fb=s(),pd=r("p"),pd.textContent=xv,Eg=s(),Jt=r("div"),l(ca.$$.fragment),_b=s(),md=r("p"),md.innerHTML=kv,Xg=s(),It=r("div"),l(la.$$.fragment),bb=s(),gd=r("p"),gd.innerHTML=Mv,Ng=s(),te=r("div"),l(da.$$.fragment),Tb=s(),ud=r("p"),ud.textContent=jv,yb=s(),B=r("div"),l(pa.$$.fragment),vb=s(),hd=r("p"),hd.textContent=Lv,$b=s(),fd=r("p"),fd.innerHTML=Fv,wb=s(),_d=r("p"),_d.innerHTML=zv,xb=s(),bd=r("p"),bd.innerHTML=Uv,kb=s(),Td=r("p"),Td.textContent=Jv,Mb=s(),hn=r("div"),l(ma.$$.fragment),jb=s(),yd=r("p"),yd.textContent=Iv,Hg=s(),l(ga.$$.fragment),Rg=s(),ne=r("div"),l(ua.$$.fragment),Lb=s(),vd=r("p"),vd.innerHTML=Cv,Fb=s(),$d=r("div"),l(ha.$$.fragment),zb=s(),wd=r("div"),l(fa.$$.fragment),Og=s(),I=r("div"),l(_a.$$.fragment),Ub=s(),xd=r("p"),xd.innerHTML=Bv,Jb=s(),kd=r("p"),kd.innerHTML=qv,Ib=s(),Md=r("p"),Md.innerHTML=Wv,Cb=s(),jd=r("div"),l(ba.$$.fragment),Bb=s(),Ld=r("div"),l(Ta.$$.fragment),Qg=s(),se=r("div"),l(ya.$$.fragment),qb=s(),Fd=r("p"),Fd.innerHTML=Vv,Wb=s(),zd=r("div"),l(va.$$.fragment),Vb=s(),Ud=r("div"),l($a.$$.fragment),Ag=s(),l(wa.$$.fragment),Yg=s(),tt=r("div"),l(xa.$$.fragment),Sb=s(),Jd=r("p"),Jd.textContent=Sv,Zb=s(),Id=r("p"),Id.innerHTML=Zv,Kg=s(),nt=r("div"),l(ka.$$.fragment),Db=s(),Cd=r("p"),Cd.textContent=Dv,Pb=s(),Bd=r("p"),Bd.innerHTML=Pv,eu=s(),l(Ma.$$.fragment),tu=s(),J=r("div"),l(ja.$$.fragment),Gb=s(),qd=r("p"),qd.textContent=Gv,Eb=s(),l(fn.$$.fragment),Xb=s(),l(_n.$$.fragment),Nb=s(),bn=r("div"),l(La.$$.fragment),Hb=s(),Wd=r("p"),Wd.textContent=Ev,Rb=s(),Tn=r("div"),l(Fa.$$.fragment),Ob=s(),Vd=r("p"),Vd.textContent=Xv,Qb=s(),yn=r("div"),l(za.$$.fragment),Ab=s(),Sd=r("p"),Sd.textContent=Nv,nu=s(),P=r("div"),l(Ua.$$.fragment),Yb=s(),Zd=r("p"),Zd.textContent=Hv,Kb=s(),l(vn.$$.fragment),eT=s(),l($n.$$.fragment),tT=s(),wn=r("div"),l(Ja.$$.fragment),nT=s(),Dd=r("p"),Dd.textContent=Rv,su=s(),Vp=r("p"),this.h()},l(e){const i=dw("svelte-u9bgzb",document.head);f=a(i,"META",{name:!0,content:!0}),i.forEach(n),x=o(e),$=a(e,"P",{}),_($).forEach(n),v=o(e),d(w.$$.fragment,e),h=o(e),k=a(e,"P",{"data-svelte-h":!0}),y(k)!=="svelte-1ovwyvm"&&(k.innerHTML=sT),Sp=o(e),Wn=a(e,"P",{"data-svelte-h":!0}),y(Wn)!=="svelte-1blns9e"&&(Wn.textContent=oT),Zp=o(e),d(Vn.$$.fragment,e),Dp=o(e),Sn=a(e,"P",{"data-svelte-h":!0}),y(Sn)!=="svelte-18ep3y6"&&(Sn.innerHTML=rT),Pp=o(e),Zn=a(e,"P",{"data-svelte-h":!0}),y(Zn)!=="svelte-wwwyth"&&(Zn.textContent=aT),Gp=o(e),d(Dn.$$.fragment,e),Ep=o(e),Pn=a(e,"P",{"data-svelte-h":!0}),y(Pn)!=="svelte-jxxg53"&&(Pn.innerHTML=iT),Xp=o(e),Gn=a(e,"UL",{"data-svelte-h":!0}),y(Gn)!=="svelte-1arpy9m"&&(Gn.innerHTML=cT),Np=o(e),En=a(e,"P",{"data-svelte-h":!0}),y(En)!=="svelte-xh59rv"&&(En.innerHTML=lT),Hp=o(e),Xn=a(e,"P",{"data-svelte-h":!0}),y(Xn)!=="svelte-rqavqw"&&(Xn.innerHTML=dT),Rp=o(e),Nn=a(e,"P",{"data-svelte-h":!0}),y(Nn)!=="svelte-qr02he"&&(Nn.innerHTML=pT),Op=o(e),d(Hn.$$.fragment,e),Qp=o(e),Rn=a(e,"P",{"data-svelte-h":!0}),y(Rn)!=="svelte-114v74y"&&(Rn.innerHTML=mT),Ap=o(e),On=a(e,"P",{"data-svelte-h":!0}),y(On)!=="svelte-13knclg"&&(On.innerHTML=gT),Yp=o(e),Qn=a(e,"P",{"data-svelte-h":!0}),y(Qn)!=="svelte-gz8gow"&&(Qn.textContent=uT),Kp=o(e),d(An.$$.fragment,e),em=o(e),pt=a(e,"DIV",{class:!0});var Ia=_(pt);d(Yn.$$.fragment,Ia),ku=o(Ia),ei=a(Ia,"P",{"data-svelte-h":!0}),y(ei)!=="svelte-1bnrp61"&&(ei.textContent=hT),Ia.forEach(n),tm=o(e),mt=a(e,"DIV",{class:!0});var Ca=_(mt);d(Kn.$$.fragment,Ca),Mu=o(Ca),ti=a(Ca,"P",{"data-svelte-h":!0}),y(ti)!=="svelte-fenhkk"&&(ti.textContent=fT),Ca.forEach(n),nm=o(e),gt=a(e,"DIV",{class:!0});var Ba=_(gt);d(es.$$.fragment,Ba),ju=o(Ba),ni=a(Ba,"P",{"data-svelte-h":!0}),y(ni)!=="svelte-1dqtgq4"&&(ni.textContent=_T),Ba.forEach(n),sm=o(e),ut=a(e,"DIV",{class:!0});var qa=_(ut);d(ts.$$.fragment,qa),Lu=o(qa),si=a(qa,"P",{"data-svelte-h":!0}),y(si)!=="svelte-10orfv5"&&(si.textContent=bT),qa.forEach(n),om=o(e),ht=a(e,"DIV",{class:!0});var Wa=_(ht);d(ns.$$.fragment,Wa),Fu=o(Wa),oi=a(Wa,"P",{"data-svelte-h":!0}),y(oi)!=="svelte-jg8udg"&&(oi.textContent=TT),Wa.forEach(n),rm=o(e),ft=a(e,"DIV",{class:!0});var Va=_(ft);d(ss.$$.fragment,Va),zu=o(Va),ri=a(Va,"P",{"data-svelte-h":!0}),y(ri)!=="svelte-1i40667"&&(ri.textContent=yT),Va.forEach(n),am=o(e),_t=a(e,"DIV",{class:!0});var Sa=_(_t);d(os.$$.fragment,Sa),Uu=o(Sa),ai=a(Sa,"P",{"data-svelte-h":!0}),y(ai)!=="svelte-n5fi8x"&&(ai.textContent=vT),Sa.forEach(n),im=o(e),bt=a(e,"DIV",{class:!0});var Za=_(bt);d(rs.$$.fragment,Za),Ju=o(Za),ii=a(Za,"P",{"data-svelte-h":!0}),y(ii)!=="svelte-h5pj3l"&&(ii.textContent=$T),Za.forEach(n),cm=o(e),Tt=a(e,"DIV",{class:!0});var Da=_(Tt);d(as.$$.fragment,Da),Iu=o(Da),ci=a(Da,"P",{"data-svelte-h":!0}),y(ci)!=="svelte-pru3ks"&&(ci.textContent=wT),Da.forEach(n),lm=o(e),yt=a(e,"DIV",{class:!0});var Pa=_(yt);d(is.$$.fragment,Pa),Cu=o(Pa),li=a(Pa,"P",{"data-svelte-h":!0}),y(li)!=="svelte-pru3ks"&&(li.textContent=xT),Pa.forEach(n),dm=o(e),d(cs.$$.fragment,e),pm=o(e),vt=a(e,"DIV",{class:!0});var Ga=_(vt);d(ls.$$.fragment,Ga),Bu=o(Ga),di=a(Ga,"P",{"data-svelte-h":!0}),y(di)!=="svelte-1bnrp61"&&(di.textContent=kT),Ga.forEach(n),mm=o(e),$t=a(e,"DIV",{class:!0});var Ea=_($t);d(ds.$$.fragment,Ea),qu=o(Ea),pi=a(Ea,"P",{"data-svelte-h":!0}),y(pi)!=="svelte-fenhkk"&&(pi.textContent=MT),Ea.forEach(n),gm=o(e),wt=a(e,"DIV",{class:!0});var Xa=_(wt);d(ps.$$.fragment,Xa),Wu=o(Xa),mi=a(Xa,"P",{"data-svelte-h":!0}),y(mi)!=="svelte-1dqtgq4"&&(mi.textContent=jT),Xa.forEach(n),um=o(e),xt=a(e,"DIV",{class:!0});var Na=_(xt);d(ms.$$.fragment,Na),Vu=o(Na),gi=a(Na,"P",{"data-svelte-h":!0}),y(gi)!=="svelte-10orfv5"&&(gi.textContent=LT),Na.forEach(n),hm=o(e),kt=a(e,"DIV",{class:!0});var Ha=_(kt);d(gs.$$.fragment,Ha),Su=o(Ha),ui=a(Ha,"P",{"data-svelte-h":!0}),y(ui)!=="svelte-jg8udg"&&(ui.textContent=FT),Ha.forEach(n),fm=o(e),Mt=a(e,"DIV",{class:!0});var Ra=_(Mt);d(us.$$.fragment,Ra),Zu=o(Ra),hi=a(Ra,"P",{"data-svelte-h":!0}),y(hi)!=="svelte-1i40667"&&(hi.textContent=zT),Ra.forEach(n),_m=o(e),jt=a(e,"DIV",{class:!0});var Oa=_(jt);d(hs.$$.fragment,Oa),Du=o(Oa),fi=a(Oa,"P",{"data-svelte-h":!0}),y(fi)!=="svelte-n5fi8x"&&(fi.textContent=UT),Oa.forEach(n),bm=o(e),Lt=a(e,"DIV",{class:!0});var Qa=_(Lt);d(fs.$$.fragment,Qa),Pu=o(Qa),_i=a(Qa,"P",{"data-svelte-h":!0}),y(_i)!=="svelte-h5pj3l"&&(_i.textContent=JT),Qa.forEach(n),Tm=o(e),Ft=a(e,"DIV",{class:!0});var Aa=_(Ft);d(_s.$$.fragment,Aa),Gu=o(Aa),bi=a(Aa,"P",{"data-svelte-h":!0}),y(bi)!=="svelte-b9zq6n"&&(bi.textContent=IT),Aa.forEach(n),ym=o(e),zt=a(e,"DIV",{class:!0});var Ya=_(zt);d(bs.$$.fragment,Ya),Eu=o(Ya),Ti=a(Ya,"P",{"data-svelte-h":!0}),y(Ti)!=="svelte-pru3ks"&&(Ti.textContent=CT),Ya.forEach(n),vm=o(e),d(Ts.$$.fragment,e),$m=o(e),ae=a(e,"DIV",{class:!0});var Ct=_(ae);d(ys.$$.fragment,Ct),Xu=o(Ct),yi=a(Ct,"P",{"data-svelte-h":!0}),y(yi)!=="svelte-qoov36"&&(yi.textContent=BT),Nu=o(Ct),qt=a(Ct,"DIV",{class:!0});var Ka=_(qt);d(vs.$$.fragment,Ka),Hu=o(Ka),vi=a(Ka,"P",{"data-svelte-h":!0}),y(vi)!=="svelte-5ihtpa"&&(vi.textContent=qT),Ka.forEach(n),Ct.forEach(n),wm=o(e),ie=a(e,"DIV",{class:!0});var Bt=_(ie);d($s.$$.fragment,Bt),Ru=o(Bt),$i=a(Bt,"P",{"data-svelte-h":!0}),y($i)!=="svelte-1tz7qrd"&&($i.textContent=WT),Ou=o(Bt),Wt=a(Bt,"DIV",{class:!0});var ru=_(Wt);d(ws.$$.fragment,ru),Qu=o(ru),wi=a(ru,"P",{"data-svelte-h":!0}),y(wi)!=="svelte-5ihtpa"&&(wi.textContent=VT),ru.forEach(n),Bt.forEach(n),xm=o(e),ce=a(e,"DIV",{class:!0});var Pd=_(ce);d(xs.$$.fragment,Pd),Au=o(Pd),xi=a(Pd,"P",{"data-svelte-h":!0}),y(xi)!=="svelte-1tz7qrd"&&(xi.textContent=ST),Yu=o(Pd),Vt=a(Pd,"DIV",{class:!0});var au=_(Vt);d(ks.$$.fragment,au),Ku=o(au),ki=a(au,"P",{"data-svelte-h":!0}),y(ki)!=="svelte-5ihtpa"&&(ki.textContent=ZT),au.forEach(n),Pd.forEach(n),km=o(e),d(Ms.$$.fragment,e),Mm=o(e),js=a(e,"P",{"data-svelte-h":!0}),y(js)!=="svelte-1mhr04t"&&(js.innerHTML=DT),jm=o(e),d(Ls.$$.fragment,e),Lm=o(e),le=a(e,"DIV",{class:!0});var Gd=_(le);d(Fs.$$.fragment,Gd),eh=o(Gd),Mi=a(Gd,"P",{"data-svelte-h":!0}),y(Mi)!=="svelte-1et1p3k"&&(Mi.innerHTML=PT),th=o(Gd),ji=a(Gd,"DIV",{class:!0});var Ov=_(ji);d(zs.$$.fragment,Ov),Ov.forEach(n),Gd.forEach(n),Fm=o(e),N=a(e,"DIV",{class:!0});var xn=_(N);d(Us.$$.fragment,xn),nh=o(xn),Li=a(xn,"P",{"data-svelte-h":!0}),y(Li)!=="svelte-151ju3h"&&(Li.innerHTML=GT),sh=o(xn),Fi=a(xn,"P",{"data-svelte-h":!0}),y(Fi)!=="svelte-lu7kru"&&(Fi.innerHTML=ET),oh=o(xn),zi=a(xn,"DIV",{class:!0});var Qv=_(zi);d(Js.$$.fragment,Qv),Qv.forEach(n),xn.forEach(n),zm=o(e),de=a(e,"DIV",{class:!0});var Ed=_(de);d(Is.$$.fragment,Ed),rh=o(Ed),Ui=a(Ed,"P",{"data-svelte-h":!0}),y(Ui)!=="svelte-ara8t9"&&(Ui.innerHTML=XT),ah=o(Ed),Ji=a(Ed,"DIV",{class:!0});var Av=_(Ji);d(Cs.$$.fragment,Av),Av.forEach(n),Ed.forEach(n),Um=o(e),H=a(e,"DIV",{class:!0});var kn=_(H);d(Bs.$$.fragment,kn),ih=o(kn),Ii=a(kn,"P",{"data-svelte-h":!0}),y(Ii)!=="svelte-hnhlbo"&&(Ii.innerHTML=NT),ch=o(kn),Ci=a(kn,"P",{"data-svelte-h":!0}),y(Ci)!=="svelte-16c70nt"&&(Ci.innerHTML=HT),lh=o(kn),Bi=a(kn,"DIV",{class:!0});var Yv=_(Bi);d(qs.$$.fragment,Yv),Yv.forEach(n),kn.forEach(n),Jm=o(e),R=a(e,"DIV",{class:!0});var Mn=_(R);d(Ws.$$.fragment,Mn),dh=o(Mn),qi=a(Mn,"P",{"data-svelte-h":!0}),y(qi)!=="svelte-axmqko"&&(qi.innerHTML=RT),ph=o(Mn),d(St.$$.fragment,Mn),mh=o(Mn),Wi=a(Mn,"DIV",{class:!0});var Kv=_(Wi);d(Vs.$$.fragment,Kv),Kv.forEach(n),Mn.forEach(n),Im=o(e),O=a(e,"DIV",{class:!0});var jn=_(O);d(Ss.$$.fragment,jn),gh=o(jn),Vi=a(jn,"P",{"data-svelte-h":!0}),y(Vi)!=="svelte-nvfh7w"&&(Vi.innerHTML=OT),uh=o(jn),d(Zt.$$.fragment,jn),hh=o(jn),Si=a(jn,"DIV",{class:!0});var e$=_(Si);d(Zs.$$.fragment,e$),e$.forEach(n),jn.forEach(n),Cm=o(e),Q=a(e,"DIV",{class:!0});var Ln=_(Q);d(Ds.$$.fragment,Ln),fh=o(Ln),Zi=a(Ln,"P",{"data-svelte-h":!0}),y(Zi)!=="svelte-zac23"&&(Zi.innerHTML=QT),_h=o(Ln),d(Dt.$$.fragment,Ln),bh=o(Ln),Di=a(Ln,"DIV",{class:!0});var t$=_(Di);d(Ps.$$.fragment,t$),t$.forEach(n),Ln.forEach(n),Bm=o(e),pe=a(e,"DIV",{class:!0});var Xd=_(pe);d(Gs.$$.fragment,Xd),Th=o(Xd),Pi=a(Xd,"P",{"data-svelte-h":!0}),y(Pi)!=="svelte-zo7rwv"&&(Pi.innerHTML=AT),yh=o(Xd),Gi=a(Xd,"DIV",{class:!0});var n$=_(Gi);d(Es.$$.fragment,n$),n$.forEach(n),Xd.forEach(n),qm=o(e),me=a(e,"DIV",{class:!0});var Nd=_(me);d(Xs.$$.fragment,Nd),vh=o(Nd),Ei=a(Nd,"P",{"data-svelte-h":!0}),y(Ei)!=="svelte-1ideb0b"&&(Ei.innerHTML=YT),$h=o(Nd),Xi=a(Nd,"DIV",{class:!0});var s$=_(Xi);d(Ns.$$.fragment,s$),s$.forEach(n),Nd.forEach(n),Wm=o(e),ge=a(e,"DIV",{class:!0});var Hd=_(ge);d(Hs.$$.fragment,Hd),wh=o(Hd),Ni=a(Hd,"P",{"data-svelte-h":!0}),y(Ni)!=="svelte-lka4kd"&&(Ni.innerHTML=KT),xh=o(Hd),Hi=a(Hd,"DIV",{class:!0});var o$=_(Hi);d(Rs.$$.fragment,o$),o$.forEach(n),Hd.forEach(n),Vm=o(e),j=a(e,"DIV",{class:!0});var F=_(j);d(Os.$$.fragment,F),kh=o(F),Ri=a(F,"P",{"data-svelte-h":!0}),y(Ri)!=="svelte-gr8gnh"&&(Ri.innerHTML=ey),Mh=o(F),Oi=a(F,"P",{"data-svelte-h":!0}),y(Oi)!=="svelte-1whn8gg"&&(Oi.innerHTML=ty),jh=o(F),d(Pt.$$.fragment,F),Lh=o(F),d(Gt.$$.fragment,F),Fh=o(F),Qi=a(F,"P",{"data-svelte-h":!0}),y(Qi)!=="svelte-2fpu88"&&(Qi.innerHTML=ny),zh=o(F),Ai=a(F,"P",{"data-svelte-h":!0}),y(Ai)!=="svelte-1nj4y15"&&(Ai.textContent=sy),Uh=o(F),Yi=a(F,"UL",{"data-svelte-h":!0}),y(Yi)!=="svelte-1knkx0p"&&(Yi.innerHTML=oy),Jh=o(F),Ki=a(F,"P",{"data-svelte-h":!0}),y(Ki)!=="svelte-5xwkxe"&&(Ki.textContent=ry),Ih=o(F),ec=a(F,"UL",{"data-svelte-h":!0}),y(ec)!=="svelte-7rlln8"&&(ec.innerHTML=ay),Ch=o(F),d(Et.$$.fragment,F),Bh=o(F),tc=a(F,"DIV",{class:!0});var r$=_(tc);d(Qs.$$.fragment,r$),r$.forEach(n),F.forEach(n),Sm=o(e),ue=a(e,"DIV",{class:!0});var Rd=_(ue);d(As.$$.fragment,Rd),qh=o(Rd),nc=a(Rd,"P",{"data-svelte-h":!0}),y(nc)!=="svelte-19509do"&&(nc.innerHTML=iy),Wh=o(Rd),sc=a(Rd,"DIV",{class:!0});var a$=_(sc);d(Ys.$$.fragment,a$),a$.forEach(n),Rd.forEach(n),Zm=o(e),he=a(e,"DIV",{class:!0});var Od=_(he);d(Ks.$$.fragment,Od),Vh=o(Od),oc=a(Od,"P",{"data-svelte-h":!0}),y(oc)!=="svelte-3ldoeh"&&(oc.innerHTML=cy),Sh=o(Od),rc=a(Od,"DIV",{class:!0});var i$=_(rc);d(eo.$$.fragment,i$),i$.forEach(n),Od.forEach(n),Dm=o(e),fe=a(e,"DIV",{class:!0});var Qd=_(fe);d(to.$$.fragment,Qd),Zh=o(Qd),ac=a(Qd,"P",{"data-svelte-h":!0}),y(ac)!=="svelte-y1kta5"&&(ac.textContent=ly),Dh=o(Qd),ic=a(Qd,"DIV",{class:!0});var c$=_(ic);d(no.$$.fragment,c$),c$.forEach(n),Qd.forEach(n),Pm=o(e),_e=a(e,"DIV",{class:!0});var Ad=_(_e);d(so.$$.fragment,Ad),Ph=o(Ad),cc=a(Ad,"P",{"data-svelte-h":!0}),y(cc)!=="svelte-hiao6z"&&(cc.innerHTML=dy),Gh=o(Ad),lc=a(Ad,"DIV",{class:!0});var l$=_(lc);d(oo.$$.fragment,l$),l$.forEach(n),Ad.forEach(n),Gm=o(e),be=a(e,"DIV",{class:!0});var Yd=_(be);d(ro.$$.fragment,Yd),Eh=o(Yd),dc=a(Yd,"P",{"data-svelte-h":!0}),y(dc)!=="svelte-th82mu"&&(dc.textContent=py),Xh=o(Yd),pc=a(Yd,"DIV",{class:!0});var d$=_(pc);d(ao.$$.fragment,d$),d$.forEach(n),Yd.forEach(n),Em=o(e),Te=a(e,"DIV",{class:!0});var Kd=_(Te);d(io.$$.fragment,Kd),Nh=o(Kd),mc=a(Kd,"P",{"data-svelte-h":!0}),y(mc)!=="svelte-1453g2v"&&(mc.innerHTML=my),Hh=o(Kd),gc=a(Kd,"DIV",{class:!0});var p$=_(gc);d(co.$$.fragment,p$),p$.forEach(n),Kd.forEach(n),Xm=o(e),A=a(e,"DIV",{class:!0});var Fn=_(A);d(lo.$$.fragment,Fn),Rh=o(Fn),uc=a(Fn,"P",{"data-svelte-h":!0}),y(uc)!=="svelte-1b8tr66"&&(uc.innerHTML=gy),Oh=o(Fn),d(Xt.$$.fragment,Fn),Qh=o(Fn),hc=a(Fn,"DIV",{class:!0});var m$=_(hc);d(po.$$.fragment,m$),m$.forEach(n),Fn.forEach(n),Nm=o(e),q=a(e,"DIV",{class:!0});var ot=_(q);d(mo.$$.fragment,ot),Ah=o(ot),fc=a(ot,"P",{"data-svelte-h":!0}),y(fc)!=="svelte-1j8exuv"&&(fc.innerHTML=uy),Yh=o(ot),d(Nt.$$.fragment,ot),Kh=o(ot),d(Ht.$$.fragment,ot),ef=o(ot),_c=a(ot,"DIV",{class:!0});var g$=_(_c);d(go.$$.fragment,g$),g$.forEach(n),ot.forEach(n),Hm=o(e),W=a(e,"DIV",{class:!0});var rt=_(W);d(uo.$$.fragment,rt),tf=o(rt),bc=a(rt,"P",{"data-svelte-h":!0}),y(bc)!=="svelte-8pl1ad"&&(bc.innerHTML=hy),nf=o(rt),d(Rt.$$.fragment,rt),sf=o(rt),d(Ot.$$.fragment,rt),of=o(rt),Tc=a(rt,"DIV",{class:!0});var u$=_(Tc);d(ho.$$.fragment,u$),u$.forEach(n),rt.forEach(n),Rm=o(e),ye=a(e,"DIV",{class:!0});var ep=_(ye);d(fo.$$.fragment,ep),rf=o(ep),yc=a(ep,"P",{"data-svelte-h":!0}),y(yc)!=="svelte-8lc5bj"&&(yc.innerHTML=fy),af=o(ep),vc=a(ep,"DIV",{class:!0});var h$=_(vc);d(_o.$$.fragment,h$),h$.forEach(n),ep.forEach(n),Om=o(e),V=a(e,"DIV",{class:!0});var at=_(V);d(bo.$$.fragment,at),cf=o(at),$c=a(at,"P",{"data-svelte-h":!0}),y($c)!=="svelte-1wxtxxm"&&($c.innerHTML=_y),lf=o(at),wc=a(at,"P",{"data-svelte-h":!0}),y(wc)!=="svelte-pdslql"&&(wc.innerHTML=by),df=o(at),d(Qt.$$.fragment,at),pf=o(at),xc=a(at,"DIV",{class:!0});var f$=_(xc);d(To.$$.fragment,f$),f$.forEach(n),at.forEach(n),Qm=o(e),S=a(e,"DIV",{class:!0});var it=_(S);d(yo.$$.fragment,it),mf=o(it),kc=a(it,"P",{"data-svelte-h":!0}),y(kc)!=="svelte-wdblk4"&&(kc.innerHTML=Ty),gf=o(it),d(At.$$.fragment,it),uf=o(it),d(Yt.$$.fragment,it),hf=o(it),Mc=a(it,"DIV",{class:!0});var _$=_(Mc);d(vo.$$.fragment,_$),_$.forEach(n),it.forEach(n),Am=o(e),ve=a(e,"DIV",{class:!0});var tp=_(ve);d($o.$$.fragment,tp),ff=o(tp),jc=a(tp,"P",{"data-svelte-h":!0}),y(jc)!=="svelte-em432o"&&(jc.innerHTML=yy),_f=o(tp),Lc=a(tp,"DIV",{class:!0});var b$=_(Lc);d(wo.$$.fragment,b$),b$.forEach(n),tp.forEach(n),Ym=o(e),$e=a(e,"DIV",{class:!0});var np=_($e);d(xo.$$.fragment,np),bf=o(np),Fc=a(np,"P",{"data-svelte-h":!0}),y(Fc)!=="svelte-a554sd"&&(Fc.innerHTML=vy),Tf=o(np),zc=a(np,"DIV",{class:!0});var T$=_(zc);d(ko.$$.fragment,T$),T$.forEach(n),np.forEach(n),Km=o(e),Z=a(e,"DIV",{class:!0});var ct=_(Z);d(Mo.$$.fragment,ct),yf=o(ct),Uc=a(ct,"P",{"data-svelte-h":!0}),y(Uc)!=="svelte-1alkcqx"&&(Uc.innerHTML=$y),vf=o(ct),d(Kt.$$.fragment,ct),$f=o(ct),d(en.$$.fragment,ct),wf=o(ct),Jc=a(ct,"DIV",{class:!0});var y$=_(Jc);d(jo.$$.fragment,y$),y$.forEach(n),ct.forEach(n),eg=o(e),we=a(e,"DIV",{class:!0});var sp=_(we);d(Lo.$$.fragment,sp),xf=o(sp),Ic=a(sp,"P",{"data-svelte-h":!0}),y(Ic)!=="svelte-1w1duep"&&(Ic.innerHTML=wy),kf=o(sp),Cc=a(sp,"DIV",{class:!0});var v$=_(Cc);d(Fo.$$.fragment,v$),v$.forEach(n),sp.forEach(n),tg=o(e),Y=a(e,"DIV",{class:!0});var zn=_(Y);d(zo.$$.fragment,zn),Mf=o(zn),Bc=a(zn,"P",{"data-svelte-h":!0}),y(Bc)!=="svelte-niui2b"&&(Bc.innerHTML=xy),jf=o(zn),d(tn.$$.fragment,zn),Lf=o(zn),qc=a(zn,"DIV",{class:!0});var $$=_(qc);d(Uo.$$.fragment,$$),$$.forEach(n),zn.forEach(n),ng=o(e),xe=a(e,"DIV",{class:!0});var op=_(xe);d(Jo.$$.fragment,op),Ff=o(op),Wc=a(op,"P",{"data-svelte-h":!0}),y(Wc)!=="svelte-1pu97t8"&&(Wc.innerHTML=ky),zf=o(op),Vc=a(op,"DIV",{class:!0});var w$=_(Vc);d(Io.$$.fragment,w$),w$.forEach(n),op.forEach(n),sg=o(e),D=a(e,"DIV",{class:!0});var lt=_(D);d(Co.$$.fragment,lt),Uf=o(lt),Sc=a(lt,"P",{"data-svelte-h":!0}),y(Sc)!=="svelte-pi0cpg"&&(Sc.innerHTML=My),Jf=o(lt),Zc=a(lt,"P",{"data-svelte-h":!0}),y(Zc)!=="svelte-5qs7tv"&&(Zc.innerHTML=jy),If=o(lt),d(nn.$$.fragment,lt),Cf=o(lt),Dc=a(lt,"DIV",{class:!0});var x$=_(Dc);d(Bo.$$.fragment,x$),x$.forEach(n),lt.forEach(n),og=o(e),K=a(e,"DIV",{class:!0});var Un=_(K);d(qo.$$.fragment,Un),Bf=o(Un),Pc=a(Un,"P",{"data-svelte-h":!0}),y(Pc)!=="svelte-1sygpwz"&&(Pc.innerHTML=Ly),qf=o(Un),Gc=a(Un,"P",{"data-svelte-h":!0}),y(Gc)!=="svelte-qmmn5t"&&(Gc.innerHTML=Fy),Wf=o(Un),Ec=a(Un,"DIV",{class:!0});var k$=_(Ec);d(Wo.$$.fragment,k$),k$.forEach(n),Un.forEach(n),rg=o(e),d(Vo.$$.fragment,e),ag=o(e),ke=a(e,"DIV",{class:!0});var rp=_(ke);d(So.$$.fragment,rp),Vf=o(rp),Xc=a(rp,"P",{"data-svelte-h":!0}),y(Xc)!=="svelte-1r9g8lr"&&(Xc.innerHTML=zy),Sf=o(rp),Nc=a(rp,"DIV",{class:!0});var M$=_(Nc);d(Zo.$$.fragment,M$),M$.forEach(n),rp.forEach(n),ig=o(e),Me=a(e,"DIV",{class:!0});var ap=_(Me);d(Do.$$.fragment,ap),Zf=o(ap),Hc=a(ap,"P",{"data-svelte-h":!0}),y(Hc)!=="svelte-1o8otjv"&&(Hc.innerHTML=Uy),Df=o(ap),Rc=a(ap,"DIV",{class:!0});var j$=_(Rc);d(Po.$$.fragment,j$),j$.forEach(n),ap.forEach(n),cg=o(e),je=a(e,"DIV",{class:!0});var ip=_(je);d(Go.$$.fragment,ip),Pf=o(ip),Oc=a(ip,"P",{"data-svelte-h":!0}),y(Oc)!=="svelte-1557waw"&&(Oc.innerHTML=Jy),Gf=o(ip),Qc=a(ip,"DIV",{class:!0});var L$=_(Qc);d(Eo.$$.fragment,L$),L$.forEach(n),ip.forEach(n),lg=o(e),Le=a(e,"DIV",{class:!0});var cp=_(Le);d(Xo.$$.fragment,cp),Ef=o(cp),Ac=a(cp,"P",{"data-svelte-h":!0}),y(Ac)!=="svelte-y1kta5"&&(Ac.textContent=Iy),Xf=o(cp),sn=a(cp,"DIV",{class:!0});var iu=_(sn);d(No.$$.fragment,iu),Nf=o(iu),Yc=a(iu,"P",{"data-svelte-h":!0}),y(Yc)!=="svelte-5aspnb"&&(Yc.textContent=Cy),iu.forEach(n),cp.forEach(n),dg=o(e),Fe=a(e,"DIV",{class:!0});var lp=_(Fe);d(Ho.$$.fragment,lp),Hf=o(lp),Kc=a(lp,"P",{"data-svelte-h":!0}),y(Kc)!=="svelte-wv649x"&&(Kc.innerHTML=By),Rf=o(lp),el=a(lp,"DIV",{class:!0});var F$=_(el);d(Ro.$$.fragment,F$),F$.forEach(n),lp.forEach(n),pg=o(e),ze=a(e,"DIV",{class:!0});var dp=_(ze);d(Oo.$$.fragment,dp),Of=o(dp),tl=a(dp,"P",{"data-svelte-h":!0}),y(tl)!=="svelte-th82mu"&&(tl.textContent=qy),Qf=o(dp),on=a(dp,"DIV",{class:!0});var cu=_(on);d(Qo.$$.fragment,cu),Af=o(cu),nl=a(cu,"P",{"data-svelte-h":!0}),y(nl)!=="svelte-hcoglc"&&(nl.textContent=Wy),cu.forEach(n),dp.forEach(n),mg=o(e),Ue=a(e,"DIV",{class:!0});var pp=_(Ue);d(Ao.$$.fragment,pp),Yf=o(pp),sl=a(pp,"P",{"data-svelte-h":!0}),y(sl)!=="svelte-d6heh3"&&(sl.innerHTML=Vy),Kf=o(pp),ol=a(pp,"DIV",{class:!0});var z$=_(ol);d(Yo.$$.fragment,z$),z$.forEach(n),pp.forEach(n),gg=o(e),Je=a(e,"DIV",{class:!0});var mp=_(Je);d(Ko.$$.fragment,mp),e_=o(mp),rl=a(mp,"P",{"data-svelte-h":!0}),y(rl)!=="svelte-gt0dvy"&&(rl.innerHTML=Sy),t_=o(mp),al=a(mp,"DIV",{class:!0});var U$=_(al);d(er.$$.fragment,U$),U$.forEach(n),mp.forEach(n),ug=o(e),Ie=a(e,"DIV",{class:!0});var gp=_(Ie);d(tr.$$.fragment,gp),n_=o(gp),il=a(gp,"P",{"data-svelte-h":!0}),y(il)!=="svelte-e8ez2m"&&(il.innerHTML=Zy),s_=o(gp),cl=a(gp,"DIV",{class:!0});var J$=_(cl);d(nr.$$.fragment,J$),J$.forEach(n),gp.forEach(n),hg=o(e),Ce=a(e,"DIV",{class:!0});var up=_(Ce);d(sr.$$.fragment,up),o_=o(up),ll=a(up,"P",{"data-svelte-h":!0}),y(ll)!=="svelte-1sr1lwj"&&(ll.innerHTML=Dy),r_=o(up),dl=a(up,"DIV",{class:!0});var I$=_(dl);d(or.$$.fragment,I$),I$.forEach(n),up.forEach(n),fg=o(e),Be=a(e,"DIV",{class:!0});var hp=_(Be);d(rr.$$.fragment,hp),a_=o(hp),pl=a(hp,"P",{"data-svelte-h":!0}),y(pl)!=="svelte-16ddbx0"&&(pl.innerHTML=Py),i_=o(hp),ml=a(hp,"DIV",{class:!0});var C$=_(ml);d(ar.$$.fragment,C$),C$.forEach(n),hp.forEach(n),_g=o(e),qe=a(e,"DIV",{class:!0});var fp=_(qe);d(ir.$$.fragment,fp),c_=o(fp),gl=a(fp,"P",{"data-svelte-h":!0}),y(gl)!=="svelte-a554sd"&&(gl.innerHTML=Gy),l_=o(fp),ul=a(fp,"DIV",{class:!0});var B$=_(ul);d(cr.$$.fragment,B$),B$.forEach(n),fp.forEach(n),bg=o(e),We=a(e,"DIV",{class:!0});var _p=_(We);d(lr.$$.fragment,_p),d_=o(_p),hl=a(_p,"P",{"data-svelte-h":!0}),y(hl)!=="svelte-m0ovbw"&&(hl.innerHTML=Ey),p_=o(_p),fl=a(_p,"DIV",{class:!0});var q$=_(fl);d(dr.$$.fragment,q$),q$.forEach(n),_p.forEach(n),Tg=o(e),Ve=a(e,"DIV",{class:!0});var bp=_(Ve);d(pr.$$.fragment,bp),m_=o(bp),_l=a(bp,"P",{"data-svelte-h":!0}),y(_l)!=="svelte-v0j3k9"&&(_l.innerHTML=Xy),g_=o(bp),bl=a(bp,"DIV",{class:!0});var W$=_(bl);d(mr.$$.fragment,W$),W$.forEach(n),bp.forEach(n),yg=o(e),Se=a(e,"DIV",{class:!0});var Tp=_(Se);d(gr.$$.fragment,Tp),u_=o(Tp),Tl=a(Tp,"P",{"data-svelte-h":!0}),y(Tl)!=="svelte-1kdstb"&&(Tl.innerHTML=Ny),h_=o(Tp),yl=a(Tp,"DIV",{class:!0});var V$=_(yl);d(ur.$$.fragment,V$),V$.forEach(n),Tp.forEach(n),vg=o(e),d(hr.$$.fragment,e),$g=o(e),Ze=a(e,"DIV",{class:!0});var yp=_(Ze);d(fr.$$.fragment,yp),f_=o(yp),vl=a(yp,"P",{"data-svelte-h":!0}),y(vl)!=="svelte-115xumf"&&(vl.innerHTML=Hy),__=o(yp),$l=a(yp,"DIV",{class:!0});var S$=_($l);d(_r.$$.fragment,S$),S$.forEach(n),yp.forEach(n),wg=o(e),De=a(e,"DIV",{class:!0});var vp=_(De);d(br.$$.fragment,vp),b_=o(vp),wl=a(vp,"P",{"data-svelte-h":!0}),y(wl)!=="svelte-nirf9f"&&(wl.innerHTML=Ry),T_=o(vp),xl=a(vp,"DIV",{class:!0});var Z$=_(xl);d(Tr.$$.fragment,Z$),Z$.forEach(n),vp.forEach(n),xg=o(e),Pe=a(e,"DIV",{class:!0});var $p=_(Pe);d(yr.$$.fragment,$p),y_=o($p),kl=a($p,"P",{"data-svelte-h":!0}),y(kl)!=="svelte-klyckq"&&(kl.innerHTML=Oy),v_=o($p),Ml=a($p,"DIV",{class:!0});var D$=_(Ml);d(vr.$$.fragment,D$),D$.forEach(n),$p.forEach(n),kg=o(e),Ge=a(e,"DIV",{class:!0});var wp=_(Ge);d($r.$$.fragment,wp),$_=o(wp),jl=a(wp,"P",{"data-svelte-h":!0}),y(jl)!=="svelte-y1kta5"&&(jl.textContent=Qy),w_=o(wp),rn=a(wp,"DIV",{class:!0});var lu=_(rn);d(wr.$$.fragment,lu),x_=o(lu),Ll=a(lu,"P",{"data-svelte-h":!0}),y(Ll)!=="svelte-1l17mwc"&&(Ll.textContent=Ay),lu.forEach(n),wp.forEach(n),Mg=o(e),Ee=a(e,"DIV",{class:!0});var xp=_(Ee);d(xr.$$.fragment,xp),k_=o(xp),Fl=a(xp,"P",{"data-svelte-h":!0}),y(Fl)!=="svelte-8dgktv"&&(Fl.innerHTML=Yy),M_=o(xp),zl=a(xp,"DIV",{class:!0});var P$=_(zl);d(kr.$$.fragment,P$),P$.forEach(n),xp.forEach(n),jg=o(e),Xe=a(e,"DIV",{class:!0});var kp=_(Xe);d(Mr.$$.fragment,kp),j_=o(kp),Ul=a(kp,"P",{"data-svelte-h":!0}),y(Ul)!=="svelte-th82mu"&&(Ul.textContent=Ky),L_=o(kp),an=a(kp,"DIV",{class:!0});var du=_(an);d(jr.$$.fragment,du),F_=o(du),Jl=a(du,"P",{"data-svelte-h":!0}),y(Jl)!=="svelte-1tcb5cf"&&(Jl.textContent=ev),du.forEach(n),kp.forEach(n),Lg=o(e),Ne=a(e,"DIV",{class:!0});var Mp=_(Ne);d(Lr.$$.fragment,Mp),z_=o(Mp),Il=a(Mp,"P",{"data-svelte-h":!0}),y(Il)!=="svelte-18yq2lb"&&(Il.innerHTML=tv),U_=o(Mp),Cl=a(Mp,"DIV",{class:!0});var G$=_(Cl);d(Fr.$$.fragment,G$),G$.forEach(n),Mp.forEach(n),Fg=o(e),He=a(e,"DIV",{class:!0});var jp=_(He);d(zr.$$.fragment,jp),J_=o(jp),Bl=a(jp,"P",{"data-svelte-h":!0}),y(Bl)!=="svelte-rwiser"&&(Bl.innerHTML=nv),I_=o(jp),ql=a(jp,"DIV",{class:!0});var E$=_(ql);d(Ur.$$.fragment,E$),E$.forEach(n),jp.forEach(n),zg=o(e),Re=a(e,"DIV",{class:!0});var Lp=_(Re);d(Jr.$$.fragment,Lp),C_=o(Lp),Wl=a(Lp,"P",{"data-svelte-h":!0}),y(Wl)!=="svelte-vt3rxp"&&(Wl.innerHTML=sv),B_=o(Lp),Vl=a(Lp,"DIV",{class:!0});var X$=_(Vl);d(Ir.$$.fragment,X$),X$.forEach(n),Lp.forEach(n),Ug=o(e),Oe=a(e,"DIV",{class:!0});var Fp=_(Oe);d(Cr.$$.fragment,Fp),q_=o(Fp),Sl=a(Fp,"P",{"data-svelte-h":!0}),y(Sl)!=="svelte-15abw8y"&&(Sl.innerHTML=ov),W_=o(Fp),Zl=a(Fp,"DIV",{class:!0});var N$=_(Zl);d(Br.$$.fragment,N$),N$.forEach(n),Fp.forEach(n),Jg=o(e),Qe=a(e,"DIV",{class:!0});var zp=_(Qe);d(qr.$$.fragment,zp),V_=o(zp),Dl=a(zp,"P",{"data-svelte-h":!0}),y(Dl)!=="svelte-1oo0biz"&&(Dl.innerHTML=rv),S_=o(zp),Pl=a(zp,"DIV",{class:!0});var H$=_(Pl);d(Wr.$$.fragment,H$),H$.forEach(n),zp.forEach(n),Ig=o(e),Ae=a(e,"DIV",{class:!0});var Up=_(Ae);d(Vr.$$.fragment,Up),Z_=o(Up),Gl=a(Up,"P",{"data-svelte-h":!0}),y(Gl)!=="svelte-1j5ogr1"&&(Gl.innerHTML=av),D_=o(Up),El=a(Up,"DIV",{class:!0});var R$=_(El);d(Sr.$$.fragment,R$),R$.forEach(n),Up.forEach(n),Cg=o(e),Ye=a(e,"DIV",{class:!0});var Jp=_(Ye);d(Zr.$$.fragment,Jp),P_=o(Jp),Xl=a(Jp,"P",{"data-svelte-h":!0}),y(Xl)!=="svelte-1sygpwz"&&(Xl.innerHTML=iv),G_=o(Jp),Nl=a(Jp,"DIV",{class:!0});var O$=_(Nl);d(Dr.$$.fragment,O$),O$.forEach(n),Jp.forEach(n),Bg=o(e),d(Pr.$$.fragment,e),qg=o(e),Gr=a(e,"P",{"data-svelte-h":!0}),y(Gr)!=="svelte-u7lg8p"&&(Gr.innerHTML=cv),Wg=o(e),ee=a(e,"DIV",{class:!0});var Jn=_(ee);d(Er.$$.fragment,Jn),E_=o(Jn),Hl=a(Jn,"P",{"data-svelte-h":!0}),y(Hl)!=="svelte-rfvu1k"&&(Hl.textContent=lv),X_=o(Jn),Rl=a(Jn,"P",{"data-svelte-h":!0}),y(Rl)!=="svelte-e1lytz"&&(Rl.innerHTML=dv),N_=o(Jn),Ol=a(Jn,"DIV",{class:!0});var Q$=_(Ol);d(Xr.$$.fragment,Q$),Q$.forEach(n),Jn.forEach(n),Vg=o(e),Ut=a(e,"DIV",{class:!0});var pu=_(Ut);d(Nr.$$.fragment,pu),H_=o(pu),Ql=a(pu,"DIV",{class:!0});var A$=_(Ql);d(Hr.$$.fragment,A$),A$.forEach(n),pu.forEach(n),Sg=o(e),Ke=a(e,"DIV",{class:!0});var Ip=_(Ke);d(Rr.$$.fragment,Ip),R_=o(Ip),Al=a(Ip,"P",{"data-svelte-h":!0}),y(Al)!=="svelte-4hfu96"&&(Al.innerHTML=pv),O_=o(Ip),Yl=a(Ip,"DIV",{class:!0});var Y$=_(Yl);d(Or.$$.fragment,Y$),Y$.forEach(n),Ip.forEach(n),Zg=o(e),et=a(e,"DIV",{class:!0});var Cp=_(et);d(Qr.$$.fragment,Cp),Q_=o(Cp),Kl=a(Cp,"P",{"data-svelte-h":!0}),y(Kl)!=="svelte-q5v59n"&&(Kl.innerHTML=mv),A_=o(Cp),ed=a(Cp,"DIV",{class:!0});var K$=_(ed);d(Ar.$$.fragment,K$),K$.forEach(n),Cp.forEach(n),Dg=o(e),d(Yr.$$.fragment,e),Pg=o(e),Kr=a(e,"P",{"data-svelte-h":!0}),y(Kr)!=="svelte-2r4l4j"&&(Kr.innerHTML=gv),Gg=o(e),L=a(e,"DIV",{class:!0});var z=_(L);d(ea.$$.fragment,z),Y_=o(z),td=a(z,"P",{"data-svelte-h":!0}),y(td)!=="svelte-1kh5y5v"&&(td.textContent=uv),K_=o(z),nd=a(z,"P",{"data-svelte-h":!0}),y(nd)!=="svelte-1ygkifj"&&(nd.textContent=hv),eb=o(z),d(cn.$$.fragment,z),tb=o(z),sd=a(z,"P",{"data-svelte-h":!0}),y(sd)!=="svelte-7kbd1a"&&(sd.textContent=fv),nb=o(z),ln=a(z,"DIV",{class:!0});var mu=_(ln);d(ta.$$.fragment,mu),sb=o(mu),od=a(mu,"P",{"data-svelte-h":!0}),y(od)!=="svelte-691079"&&(od.textContent=_v),mu.forEach(n),ob=o(z),dn=a(z,"DIV",{class:!0});var gu=_(dn);d(na.$$.fragment,gu),rb=o(gu),rd=a(gu,"P",{"data-svelte-h":!0}),y(rd)!=="svelte-dtkk01"&&(rd.textContent=bv),gu.forEach(n),ab=o(z),pn=a(z,"DIV",{class:!0});var uu=_(pn);d(sa.$$.fragment,uu),ib=o(uu),ad=a(uu,"P",{"data-svelte-h":!0}),y(ad)!=="svelte-11pa7k0"&&(ad.textContent=Tv),uu.forEach(n),cb=o(z),mn=a(z,"DIV",{class:!0});var hu=_(mn);d(oa.$$.fragment,hu),lb=o(hu),id=a(hu,"P",{"data-svelte-h":!0}),y(id)!=="svelte-57vcuk"&&(id.innerHTML=yv),hu.forEach(n),db=o(z),gn=a(z,"DIV",{class:!0});var fu=_(gn);d(ra.$$.fragment,fu),pb=o(fu),cd=a(fu,"P",{"data-svelte-h":!0}),y(cd)!=="svelte-e342dt"&&(cd.textContent=vv),fu.forEach(n),mb=o(z),un=a(z,"DIV",{class:!0});var _u=_(un);d(aa.$$.fragment,_u),gb=o(_u),ld=a(_u,"P",{"data-svelte-h":!0}),y(ld)!=="svelte-vbd5xj"&&(ld.textContent=$v),_u.forEach(n),ub=o(z),st=a(z,"DIV",{class:!0});var Bp=_(st);d(ia.$$.fragment,Bp),hb=o(Bp),dd=a(Bp,"P",{"data-svelte-h":!0}),y(dd)!=="svelte-1c2dshy"&&(dd.innerHTML=wv),fb=o(Bp),pd=a(Bp,"P",{"data-svelte-h":!0}),y(pd)!=="svelte-1qvu1un"&&(pd.textContent=xv),Bp.forEach(n),z.forEach(n),Eg=o(e),Jt=a(e,"DIV",{class:!0});var bu=_(Jt);d(ca.$$.fragment,bu),_b=o(bu),md=a(bu,"P",{"data-svelte-h":!0}),y(md)!=="svelte-1rymat9"&&(md.innerHTML=kv),bu.forEach(n),Xg=o(e),It=a(e,"DIV",{class:!0});var Tu=_(It);d(la.$$.fragment,Tu),bb=o(Tu),gd=a(Tu,"P",{"data-svelte-h":!0}),y(gd)!=="svelte-1obuarm"&&(gd.innerHTML=Mv),Tu.forEach(n),Ng=o(e),te=a(e,"DIV",{class:!0});var In=_(te);d(da.$$.fragment,In),Tb=o(In),ud=a(In,"P",{"data-svelte-h":!0}),y(ud)!=="svelte-rxlesw"&&(ud.textContent=jv),yb=o(In),B=a(In,"DIV",{class:!0});var oe=_(B);d(pa.$$.fragment,oe),vb=o(oe),hd=a(oe,"P",{"data-svelte-h":!0}),y(hd)!=="svelte-15hhlou"&&(hd.textContent=Lv),$b=o(oe),fd=a(oe,"P",{"data-svelte-h":!0}),y(fd)!=="svelte-x0d0uq"&&(fd.innerHTML=Fv),wb=o(oe),_d=a(oe,"P",{"data-svelte-h":!0}),y(_d)!=="svelte-1w36vm3"&&(_d.innerHTML=zv),xb=o(oe),bd=a(oe,"P",{"data-svelte-h":!0}),y(bd)!=="svelte-1niq0qw"&&(bd.innerHTML=Uv),kb=o(oe),Td=a(oe,"P",{"data-svelte-h":!0}),y(Td)!=="svelte-af4g6f"&&(Td.textContent=Jv),oe.forEach(n),Mb=o(In),hn=a(In,"DIV",{class:!0});var yu=_(hn);d(ma.$$.fragment,yu),jb=o(yu),yd=a(yu,"P",{"data-svelte-h":!0}),y(yd)!=="svelte-eab6jp"&&(yd.textContent=Iv),yu.forEach(n),In.forEach(n),Hg=o(e),d(ga.$$.fragment,e),Rg=o(e),ne=a(e,"DIV",{class:!0});var Cn=_(ne);d(ua.$$.fragment,Cn),Lb=o(Cn),vd=a(Cn,"P",{"data-svelte-h":!0}),y(vd)!=="svelte-1785ysj"&&(vd.innerHTML=Cv),Fb=o(Cn),$d=a(Cn,"DIV",{class:!0});var ew=_($d);d(ha.$$.fragment,ew),ew.forEach(n),zb=o(Cn),wd=a(Cn,"DIV",{class:!0});var tw=_(wd);d(fa.$$.fragment,tw),tw.forEach(n),Cn.forEach(n),Og=o(e),I=a(e,"DIV",{class:!0});var re=_(I);d(_a.$$.fragment,re),Ub=o(re),xd=a(re,"P",{"data-svelte-h":!0}),y(xd)!=="svelte-1lvowm"&&(xd.innerHTML=Bv),Jb=o(re),kd=a(re,"P",{"data-svelte-h":!0}),y(kd)!=="svelte-19qrwo1"&&(kd.innerHTML=qv),Ib=o(re),Md=a(re,"P",{"data-svelte-h":!0}),y(Md)!=="svelte-l79sbt"&&(Md.innerHTML=Wv),Cb=o(re),jd=a(re,"DIV",{class:!0});var nw=_(jd);d(ba.$$.fragment,nw),nw.forEach(n),Bb=o(re),Ld=a(re,"DIV",{class:!0});var sw=_(Ld);d(Ta.$$.fragment,sw),sw.forEach(n),re.forEach(n),Qg=o(e),se=a(e,"DIV",{class:!0});var Bn=_(se);d(ya.$$.fragment,Bn),qb=o(Bn),Fd=a(Bn,"P",{"data-svelte-h":!0}),y(Fd)!=="svelte-cvew4t"&&(Fd.innerHTML=Vv),Wb=o(Bn),zd=a(Bn,"DIV",{class:!0});var ow=_(zd);d(va.$$.fragment,ow),ow.forEach(n),Vb=o(Bn),Ud=a(Bn,"DIV",{class:!0});var rw=_(Ud);d($a.$$.fragment,rw),rw.forEach(n),Bn.forEach(n),Ag=o(e),d(wa.$$.fragment,e),Yg=o(e),tt=a(e,"DIV",{class:!0});var qp=_(tt);d(xa.$$.fragment,qp),Sb=o(qp),Jd=a(qp,"P",{"data-svelte-h":!0}),y(Jd)!=="svelte-1aiwpx2"&&(Jd.textContent=Sv),Zb=o(qp),Id=a(qp,"P",{"data-svelte-h":!0}),y(Id)!=="svelte-ts4ue3"&&(Id.innerHTML=Zv),qp.forEach(n),Kg=o(e),nt=a(e,"DIV",{class:!0});var Wp=_(nt);d(ka.$$.fragment,Wp),Db=o(Wp),Cd=a(Wp,"P",{"data-svelte-h":!0}),y(Cd)!=="svelte-1aiwpx2"&&(Cd.textContent=Dv),Pb=o(Wp),Bd=a(Wp,"P",{"data-svelte-h":!0}),y(Bd)!=="svelte-ts4ue3"&&(Bd.innerHTML=Pv),Wp.forEach(n),eu=o(e),d(Ma.$$.fragment,e),tu=o(e),J=a(e,"DIV",{class:!0});var E=_(J);d(ja.$$.fragment,E),Gb=o(E),qd=a(E,"P",{"data-svelte-h":!0}),y(qd)!=="svelte-5jvlz5"&&(qd.textContent=Gv),Eb=o(E),d(fn.$$.fragment,E),Xb=o(E),d(_n.$$.fragment,E),Nb=o(E),bn=a(E,"DIV",{class:!0});var vu=_(bn);d(La.$$.fragment,vu),Hb=o(vu),Wd=a(vu,"P",{"data-svelte-h":!0}),y(Wd)!=="svelte-10d94rs"&&(Wd.textContent=Ev),vu.forEach(n),Rb=o(E),Tn=a(E,"DIV",{class:!0});var $u=_(Tn);d(Fa.$$.fragment,$u),Ob=o($u),Vd=a($u,"P",{"data-svelte-h":!0}),y(Vd)!=="svelte-tm945r"&&(Vd.textContent=Xv),$u.forEach(n),Qb=o(E),yn=a(E,"DIV",{class:!0});var wu=_(yn);d(za.$$.fragment,wu),Ab=o(wu),Sd=a(wu,"P",{"data-svelte-h":!0}),y(Sd)!=="svelte-1i1356p"&&(Sd.textContent=Nv),wu.forEach(n),E.forEach(n),nu=o(e),P=a(e,"DIV",{class:!0});var dt=_(P);d(Ua.$$.fragment,dt),Yb=o(dt),Zd=a(dt,"P",{"data-svelte-h":!0}),y(Zd)!=="svelte-190fodr"&&(Zd.textContent=Hv),Kb=o(dt),d(vn.$$.fragment,dt),eT=o(dt),d($n.$$.fragment,dt),tT=o(dt),wn=a(dt,"DIV",{class:!0});var xu=_(wn);d(Ja.$$.fragment,xu),nT=o(xu),Dd=a(xu,"P",{"data-svelte-h":!0}),y(Dd)!=="svelte-16i5iz"&&(Dd.textContent=Rv),xu.forEach(n),dt.forEach(n),su=o(e),Vp=a(e,"P",{}),_(Vp).forEach(n),this.h()},h(){b(f,"name","hf:doc:metadata"),b(f,"content",Bw),b(pt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ht,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(_t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(yt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b($t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(kt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(qt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ji,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(zi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ji,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Bi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Wi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Si,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Di,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Gi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Xi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Hi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(tc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(sc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(rc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ic,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(lc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(pc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(gc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(hc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(_c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Tc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(vc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(xc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Mc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Lc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(zc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Jc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Cc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(qc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Vc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Dc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ec,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Nc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Rc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Qc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(sn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(el,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(on,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ol,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(al,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(cl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(dl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ml,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ul,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(fl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(bl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(yl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b($l,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(xl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ml,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(rn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(zl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(an,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Cl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ql,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Vl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Zl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Pl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(El,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Nl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ol,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ql,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Yl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ed,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ln,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(pn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(gn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(It,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b($d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(wd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(jd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ld,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(zd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ud,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(bn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(yn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(wn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){t(document.head,f),c(e,x,i),c(e,$,i),c(e,v,i),p(w,e,i),c(e,h,i),c(e,k,i),c(e,Sp,i),c(e,Wn,i),c(e,Zp,i),p(Vn,e,i),c(e,Dp,i),c(e,Sn,i),c(e,Pp,i),c(e,Zn,i),c(e,Gp,i),p(Dn,e,i),c(e,Ep,i),c(e,Pn,i),c(e,Xp,i),c(e,Gn,i),c(e,Np,i),c(e,En,i),c(e,Hp,i),c(e,Xn,i),c(e,Rp,i),c(e,Nn,i),c(e,Op,i),p(Hn,e,i),c(e,Qp,i),c(e,Rn,i),c(e,Ap,i),c(e,On,i),c(e,Yp,i),c(e,Qn,i),c(e,Kp,i),p(An,e,i),c(e,em,i),c(e,pt,i),p(Yn,pt,null),t(pt,ku),t(pt,ei),c(e,tm,i),c(e,mt,i),p(Kn,mt,null),t(mt,Mu),t(mt,ti),c(e,nm,i),c(e,gt,i),p(es,gt,null),t(gt,ju),t(gt,ni),c(e,sm,i),c(e,ut,i),p(ts,ut,null),t(ut,Lu),t(ut,si),c(e,om,i),c(e,ht,i),p(ns,ht,null),t(ht,Fu),t(ht,oi),c(e,rm,i),c(e,ft,i),p(ss,ft,null),t(ft,zu),t(ft,ri),c(e,am,i),c(e,_t,i),p(os,_t,null),t(_t,Uu),t(_t,ai),c(e,im,i),c(e,bt,i),p(rs,bt,null),t(bt,Ju),t(bt,ii),c(e,cm,i),c(e,Tt,i),p(as,Tt,null),t(Tt,Iu),t(Tt,ci),c(e,lm,i),c(e,yt,i),p(is,yt,null),t(yt,Cu),t(yt,li),c(e,dm,i),p(cs,e,i),c(e,pm,i),c(e,vt,i),p(ls,vt,null),t(vt,Bu),t(vt,di),c(e,mm,i),c(e,$t,i),p(ds,$t,null),t($t,qu),t($t,pi),c(e,gm,i),c(e,wt,i),p(ps,wt,null),t(wt,Wu),t(wt,mi),c(e,um,i),c(e,xt,i),p(ms,xt,null),t(xt,Vu),t(xt,gi),c(e,hm,i),c(e,kt,i),p(gs,kt,null),t(kt,Su),t(kt,ui),c(e,fm,i),c(e,Mt,i),p(us,Mt,null),t(Mt,Zu),t(Mt,hi),c(e,_m,i),c(e,jt,i),p(hs,jt,null),t(jt,Du),t(jt,fi),c(e,bm,i),c(e,Lt,i),p(fs,Lt,null),t(Lt,Pu),t(Lt,_i),c(e,Tm,i),c(e,Ft,i),p(_s,Ft,null),t(Ft,Gu),t(Ft,bi),c(e,ym,i),c(e,zt,i),p(bs,zt,null),t(zt,Eu),t(zt,Ti),c(e,vm,i),p(Ts,e,i),c(e,$m,i),c(e,ae,i),p(ys,ae,null),t(ae,Xu),t(ae,yi),t(ae,Nu),t(ae,qt),p(vs,qt,null),t(qt,Hu),t(qt,vi),c(e,wm,i),c(e,ie,i),p($s,ie,null),t(ie,Ru),t(ie,$i),t(ie,Ou),t(ie,Wt),p(ws,Wt,null),t(Wt,Qu),t(Wt,wi),c(e,xm,i),c(e,ce,i),p(xs,ce,null),t(ce,Au),t(ce,xi),t(ce,Yu),t(ce,Vt),p(ks,Vt,null),t(Vt,Ku),t(Vt,ki),c(e,km,i),p(Ms,e,i),c(e,Mm,i),c(e,js,i),c(e,jm,i),p(Ls,e,i),c(e,Lm,i),c(e,le,i),p(Fs,le,null),t(le,eh),t(le,Mi),t(le,th),t(le,ji),p(zs,ji,null),c(e,Fm,i),c(e,N,i),p(Us,N,null),t(N,nh),t(N,Li),t(N,sh),t(N,Fi),t(N,oh),t(N,zi),p(Js,zi,null),c(e,zm,i),c(e,de,i),p(Is,de,null),t(de,rh),t(de,Ui),t(de,ah),t(de,Ji),p(Cs,Ji,null),c(e,Um,i),c(e,H,i),p(Bs,H,null),t(H,ih),t(H,Ii),t(H,ch),t(H,Ci),t(H,lh),t(H,Bi),p(qs,Bi,null),c(e,Jm,i),c(e,R,i),p(Ws,R,null),t(R,dh),t(R,qi),t(R,ph),p(St,R,null),t(R,mh),t(R,Wi),p(Vs,Wi,null),c(e,Im,i),c(e,O,i),p(Ss,O,null),t(O,gh),t(O,Vi),t(O,uh),p(Zt,O,null),t(O,hh),t(O,Si),p(Zs,Si,null),c(e,Cm,i),c(e,Q,i),p(Ds,Q,null),t(Q,fh),t(Q,Zi),t(Q,_h),p(Dt,Q,null),t(Q,bh),t(Q,Di),p(Ps,Di,null),c(e,Bm,i),c(e,pe,i),p(Gs,pe,null),t(pe,Th),t(pe,Pi),t(pe,yh),t(pe,Gi),p(Es,Gi,null),c(e,qm,i),c(e,me,i),p(Xs,me,null),t(me,vh),t(me,Ei),t(me,$h),t(me,Xi),p(Ns,Xi,null),c(e,Wm,i),c(e,ge,i),p(Hs,ge,null),t(ge,wh),t(ge,Ni),t(ge,xh),t(ge,Hi),p(Rs,Hi,null),c(e,Vm,i),c(e,j,i),p(Os,j,null),t(j,kh),t(j,Ri),t(j,Mh),t(j,Oi),t(j,jh),p(Pt,j,null),t(j,Lh),p(Gt,j,null),t(j,Fh),t(j,Qi),t(j,zh),t(j,Ai),t(j,Uh),t(j,Yi),t(j,Jh),t(j,Ki),t(j,Ih),t(j,ec),t(j,Ch),p(Et,j,null),t(j,Bh),t(j,tc),p(Qs,tc,null),c(e,Sm,i),c(e,ue,i),p(As,ue,null),t(ue,qh),t(ue,nc),t(ue,Wh),t(ue,sc),p(Ys,sc,null),c(e,Zm,i),c(e,he,i),p(Ks,he,null),t(he,Vh),t(he,oc),t(he,Sh),t(he,rc),p(eo,rc,null),c(e,Dm,i),c(e,fe,i),p(to,fe,null),t(fe,Zh),t(fe,ac),t(fe,Dh),t(fe,ic),p(no,ic,null),c(e,Pm,i),c(e,_e,i),p(so,_e,null),t(_e,Ph),t(_e,cc),t(_e,Gh),t(_e,lc),p(oo,lc,null),c(e,Gm,i),c(e,be,i),p(ro,be,null),t(be,Eh),t(be,dc),t(be,Xh),t(be,pc),p(ao,pc,null),c(e,Em,i),c(e,Te,i),p(io,Te,null),t(Te,Nh),t(Te,mc),t(Te,Hh),t(Te,gc),p(co,gc,null),c(e,Xm,i),c(e,A,i),p(lo,A,null),t(A,Rh),t(A,uc),t(A,Oh),p(Xt,A,null),t(A,Qh),t(A,hc),p(po,hc,null),c(e,Nm,i),c(e,q,i),p(mo,q,null),t(q,Ah),t(q,fc),t(q,Yh),p(Nt,q,null),t(q,Kh),p(Ht,q,null),t(q,ef),t(q,_c),p(go,_c,null),c(e,Hm,i),c(e,W,i),p(uo,W,null),t(W,tf),t(W,bc),t(W,nf),p(Rt,W,null),t(W,sf),p(Ot,W,null),t(W,of),t(W,Tc),p(ho,Tc,null),c(e,Rm,i),c(e,ye,i),p(fo,ye,null),t(ye,rf),t(ye,yc),t(ye,af),t(ye,vc),p(_o,vc,null),c(e,Om,i),c(e,V,i),p(bo,V,null),t(V,cf),t(V,$c),t(V,lf),t(V,wc),t(V,df),p(Qt,V,null),t(V,pf),t(V,xc),p(To,xc,null),c(e,Qm,i),c(e,S,i),p(yo,S,null),t(S,mf),t(S,kc),t(S,gf),p(At,S,null),t(S,uf),p(Yt,S,null),t(S,hf),t(S,Mc),p(vo,Mc,null),c(e,Am,i),c(e,ve,i),p($o,ve,null),t(ve,ff),t(ve,jc),t(ve,_f),t(ve,Lc),p(wo,Lc,null),c(e,Ym,i),c(e,$e,i),p(xo,$e,null),t($e,bf),t($e,Fc),t($e,Tf),t($e,zc),p(ko,zc,null),c(e,Km,i),c(e,Z,i),p(Mo,Z,null),t(Z,yf),t(Z,Uc),t(Z,vf),p(Kt,Z,null),t(Z,$f),p(en,Z,null),t(Z,wf),t(Z,Jc),p(jo,Jc,null),c(e,eg,i),c(e,we,i),p(Lo,we,null),t(we,xf),t(we,Ic),t(we,kf),t(we,Cc),p(Fo,Cc,null),c(e,tg,i),c(e,Y,i),p(zo,Y,null),t(Y,Mf),t(Y,Bc),t(Y,jf),p(tn,Y,null),t(Y,Lf),t(Y,qc),p(Uo,qc,null),c(e,ng,i),c(e,xe,i),p(Jo,xe,null),t(xe,Ff),t(xe,Wc),t(xe,zf),t(xe,Vc),p(Io,Vc,null),c(e,sg,i),c(e,D,i),p(Co,D,null),t(D,Uf),t(D,Sc),t(D,Jf),t(D,Zc),t(D,If),p(nn,D,null),t(D,Cf),t(D,Dc),p(Bo,Dc,null),c(e,og,i),c(e,K,i),p(qo,K,null),t(K,Bf),t(K,Pc),t(K,qf),t(K,Gc),t(K,Wf),t(K,Ec),p(Wo,Ec,null),c(e,rg,i),p(Vo,e,i),c(e,ag,i),c(e,ke,i),p(So,ke,null),t(ke,Vf),t(ke,Xc),t(ke,Sf),t(ke,Nc),p(Zo,Nc,null),c(e,ig,i),c(e,Me,i),p(Do,Me,null),t(Me,Zf),t(Me,Hc),t(Me,Df),t(Me,Rc),p(Po,Rc,null),c(e,cg,i),c(e,je,i),p(Go,je,null),t(je,Pf),t(je,Oc),t(je,Gf),t(je,Qc),p(Eo,Qc,null),c(e,lg,i),c(e,Le,i),p(Xo,Le,null),t(Le,Ef),t(Le,Ac),t(Le,Xf),t(Le,sn),p(No,sn,null),t(sn,Nf),t(sn,Yc),c(e,dg,i),c(e,Fe,i),p(Ho,Fe,null),t(Fe,Hf),t(Fe,Kc),t(Fe,Rf),t(Fe,el),p(Ro,el,null),c(e,pg,i),c(e,ze,i),p(Oo,ze,null),t(ze,Of),t(ze,tl),t(ze,Qf),t(ze,on),p(Qo,on,null),t(on,Af),t(on,nl),c(e,mg,i),c(e,Ue,i),p(Ao,Ue,null),t(Ue,Yf),t(Ue,sl),t(Ue,Kf),t(Ue,ol),p(Yo,ol,null),c(e,gg,i),c(e,Je,i),p(Ko,Je,null),t(Je,e_),t(Je,rl),t(Je,t_),t(Je,al),p(er,al,null),c(e,ug,i),c(e,Ie,i),p(tr,Ie,null),t(Ie,n_),t(Ie,il),t(Ie,s_),t(Ie,cl),p(nr,cl,null),c(e,hg,i),c(e,Ce,i),p(sr,Ce,null),t(Ce,o_),t(Ce,ll),t(Ce,r_),t(Ce,dl),p(or,dl,null),c(e,fg,i),c(e,Be,i),p(rr,Be,null),t(Be,a_),t(Be,pl),t(Be,i_),t(Be,ml),p(ar,ml,null),c(e,_g,i),c(e,qe,i),p(ir,qe,null),t(qe,c_),t(qe,gl),t(qe,l_),t(qe,ul),p(cr,ul,null),c(e,bg,i),c(e,We,i),p(lr,We,null),t(We,d_),t(We,hl),t(We,p_),t(We,fl),p(dr,fl,null),c(e,Tg,i),c(e,Ve,i),p(pr,Ve,null),t(Ve,m_),t(Ve,_l),t(Ve,g_),t(Ve,bl),p(mr,bl,null),c(e,yg,i),c(e,Se,i),p(gr,Se,null),t(Se,u_),t(Se,Tl),t(Se,h_),t(Se,yl),p(ur,yl,null),c(e,vg,i),p(hr,e,i),c(e,$g,i),c(e,Ze,i),p(fr,Ze,null),t(Ze,f_),t(Ze,vl),t(Ze,__),t(Ze,$l),p(_r,$l,null),c(e,wg,i),c(e,De,i),p(br,De,null),t(De,b_),t(De,wl),t(De,T_),t(De,xl),p(Tr,xl,null),c(e,xg,i),c(e,Pe,i),p(yr,Pe,null),t(Pe,y_),t(Pe,kl),t(Pe,v_),t(Pe,Ml),p(vr,Ml,null),c(e,kg,i),c(e,Ge,i),p($r,Ge,null),t(Ge,$_),t(Ge,jl),t(Ge,w_),t(Ge,rn),p(wr,rn,null),t(rn,x_),t(rn,Ll),c(e,Mg,i),c(e,Ee,i),p(xr,Ee,null),t(Ee,k_),t(Ee,Fl),t(Ee,M_),t(Ee,zl),p(kr,zl,null),c(e,jg,i),c(e,Xe,i),p(Mr,Xe,null),t(Xe,j_),t(Xe,Ul),t(Xe,L_),t(Xe,an),p(jr,an,null),t(an,F_),t(an,Jl),c(e,Lg,i),c(e,Ne,i),p(Lr,Ne,null),t(Ne,z_),t(Ne,Il),t(Ne,U_),t(Ne,Cl),p(Fr,Cl,null),c(e,Fg,i),c(e,He,i),p(zr,He,null),t(He,J_),t(He,Bl),t(He,I_),t(He,ql),p(Ur,ql,null),c(e,zg,i),c(e,Re,i),p(Jr,Re,null),t(Re,C_),t(Re,Wl),t(Re,B_),t(Re,Vl),p(Ir,Vl,null),c(e,Ug,i),c(e,Oe,i),p(Cr,Oe,null),t(Oe,q_),t(Oe,Sl),t(Oe,W_),t(Oe,Zl),p(Br,Zl,null),c(e,Jg,i),c(e,Qe,i),p(qr,Qe,null),t(Qe,V_),t(Qe,Dl),t(Qe,S_),t(Qe,Pl),p(Wr,Pl,null),c(e,Ig,i),c(e,Ae,i),p(Vr,Ae,null),t(Ae,Z_),t(Ae,Gl),t(Ae,D_),t(Ae,El),p(Sr,El,null),c(e,Cg,i),c(e,Ye,i),p(Zr,Ye,null),t(Ye,P_),t(Ye,Xl),t(Ye,G_),t(Ye,Nl),p(Dr,Nl,null),c(e,Bg,i),p(Pr,e,i),c(e,qg,i),c(e,Gr,i),c(e,Wg,i),c(e,ee,i),p(Er,ee,null),t(ee,E_),t(ee,Hl),t(ee,X_),t(ee,Rl),t(ee,N_),t(ee,Ol),p(Xr,Ol,null),c(e,Vg,i),c(e,Ut,i),p(Nr,Ut,null),t(Ut,H_),t(Ut,Ql),p(Hr,Ql,null),c(e,Sg,i),c(e,Ke,i),p(Rr,Ke,null),t(Ke,R_),t(Ke,Al),t(Ke,O_),t(Ke,Yl),p(Or,Yl,null),c(e,Zg,i),c(e,et,i),p(Qr,et,null),t(et,Q_),t(et,Kl),t(et,A_),t(et,ed),p(Ar,ed,null),c(e,Dg,i),p(Yr,e,i),c(e,Pg,i),c(e,Kr,i),c(e,Gg,i),c(e,L,i),p(ea,L,null),t(L,Y_),t(L,td),t(L,K_),t(L,nd),t(L,eb),p(cn,L,null),t(L,tb),t(L,sd),t(L,nb),t(L,ln),p(ta,ln,null),t(ln,sb),t(ln,od),t(L,ob),t(L,dn),p(na,dn,null),t(dn,rb),t(dn,rd),t(L,ab),t(L,pn),p(sa,pn,null),t(pn,ib),t(pn,ad),t(L,cb),t(L,mn),p(oa,mn,null),t(mn,lb),t(mn,id),t(L,db),t(L,gn),p(ra,gn,null),t(gn,pb),t(gn,cd),t(L,mb),t(L,un),p(aa,un,null),t(un,gb),t(un,ld),t(L,ub),t(L,st),p(ia,st,null),t(st,hb),t(st,dd),t(st,fb),t(st,pd),c(e,Eg,i),c(e,Jt,i),p(ca,Jt,null),t(Jt,_b),t(Jt,md),c(e,Xg,i),c(e,It,i),p(la,It,null),t(It,bb),t(It,gd),c(e,Ng,i),c(e,te,i),p(da,te,null),t(te,Tb),t(te,ud),t(te,yb),t(te,B),p(pa,B,null),t(B,vb),t(B,hd),t(B,$b),t(B,fd),t(B,wb),t(B,_d),t(B,xb),t(B,bd),t(B,kb),t(B,Td),t(te,Mb),t(te,hn),p(ma,hn,null),t(hn,jb),t(hn,yd),c(e,Hg,i),p(ga,e,i),c(e,Rg,i),c(e,ne,i),p(ua,ne,null),t(ne,Lb),t(ne,vd),t(ne,Fb),t(ne,$d),p(ha,$d,null),t(ne,zb),t(ne,wd),p(fa,wd,null),c(e,Og,i),c(e,I,i),p(_a,I,null),t(I,Ub),t(I,xd),t(I,Jb),t(I,kd),t(I,Ib),t(I,Md),t(I,Cb),t(I,jd),p(ba,jd,null),t(I,Bb),t(I,Ld),p(Ta,Ld,null),c(e,Qg,i),c(e,se,i),p(ya,se,null),t(se,qb),t(se,Fd),t(se,Wb),t(se,zd),p(va,zd,null),t(se,Vb),t(se,Ud),p($a,Ud,null),c(e,Ag,i),p(wa,e,i),c(e,Yg,i),c(e,tt,i),p(xa,tt,null),t(tt,Sb),t(tt,Jd),t(tt,Zb),t(tt,Id),c(e,Kg,i),c(e,nt,i),p(ka,nt,null),t(nt,Db),t(nt,Cd),t(nt,Pb),t(nt,Bd),c(e,eu,i),p(Ma,e,i),c(e,tu,i),c(e,J,i),p(ja,J,null),t(J,Gb),t(J,qd),t(J,Eb),p(fn,J,null),t(J,Xb),p(_n,J,null),t(J,Nb),t(J,bn),p(La,bn,null),t(bn,Hb),t(bn,Wd),t(J,Rb),t(J,Tn),p(Fa,Tn,null),t(Tn,Ob),t(Tn,Vd),t(J,Qb),t(J,yn),p(za,yn,null),t(yn,Ab),t(yn,Sd),c(e,nu,i),c(e,P,i),p(Ua,P,null),t(P,Yb),t(P,Zd),t(P,Kb),p(vn,P,null),t(P,eT),p($n,P,null),t(P,tT),t(P,wn),p(Ja,wn,null),t(wn,nT),t(wn,Dd),c(e,su,i),c(e,Vp,i),ou=!0},p(e,[i]){const Ia={};i&2&&(Ia.$$scope={dirty:i,ctx:e}),St.$set(Ia);const Ca={};i&2&&(Ca.$$scope={dirty:i,ctx:e}),Zt.$set(Ca);const Ba={};i&2&&(Ba.$$scope={dirty:i,ctx:e}),Dt.$set(Ba);const qa={};i&2&&(qa.$$scope={dirty:i,ctx:e}),Pt.$set(qa);const Wa={};i&2&&(Wa.$$scope={dirty:i,ctx:e}),Gt.$set(Wa);const Va={};i&2&&(Va.$$scope={dirty:i,ctx:e}),Et.$set(Va);const Sa={};i&2&&(Sa.$$scope={dirty:i,ctx:e}),Xt.$set(Sa);const Za={};i&2&&(Za.$$scope={dirty:i,ctx:e}),Nt.$set(Za);const Da={};i&2&&(Da.$$scope={dirty:i,ctx:e}),Ht.$set(Da);const Pa={};i&2&&(Pa.$$scope={dirty:i,ctx:e}),Rt.$set(Pa);const Ga={};i&2&&(Ga.$$scope={dirty:i,ctx:e}),Ot.$set(Ga);const Ea={};i&2&&(Ea.$$scope={dirty:i,ctx:e}),Qt.$set(Ea);const Xa={};i&2&&(Xa.$$scope={dirty:i,ctx:e}),At.$set(Xa);const Na={};i&2&&(Na.$$scope={dirty:i,ctx:e}),Yt.$set(Na);const Ha={};i&2&&(Ha.$$scope={dirty:i,ctx:e}),Kt.$set(Ha);const Ra={};i&2&&(Ra.$$scope={dirty:i,ctx:e}),en.$set(Ra);const Oa={};i&2&&(Oa.$$scope={dirty:i,ctx:e}),tn.$set(Oa);const Qa={};i&2&&(Qa.$$scope={dirty:i,ctx:e}),nn.$set(Qa);const Aa={};i&2&&(Aa.$$scope={dirty:i,ctx:e}),cn.$set(Aa);const Ya={};i&2&&(Ya.$$scope={dirty:i,ctx:e}),fn.$set(Ya);const Ct={};i&2&&(Ct.$$scope={dirty:i,ctx:e}),_n.$set(Ct);const Ka={};i&2&&(Ka.$$scope={dirty:i,ctx:e}),vn.$set(Ka);const Bt={};i&2&&(Bt.$$scope={dirty:i,ctx:e}),$n.$set(Bt)},i(e){ou||(m(w.$$.fragment,e),m(Vn.$$.fragment,e),m(Dn.$$.fragment,e),m(Hn.$$.fragment,e),m(An.$$.fragment,e),m(Yn.$$.fragment,e),m(Kn.$$.fragment,e),m(es.$$.fragment,e),m(ts.$$.fragment,e),m(ns.$$.fragment,e),m(ss.$$.fragment,e),m(os.$$.fragment,e),m(rs.$$.fragment,e),m(as.$$.fragment,e),m(is.$$.fragment,e),m(cs.$$.fragment,e),m(ls.$$.fragment,e),m(ds.$$.fragment,e),m(ps.$$.fragment,e),m(ms.$$.fragment,e),m(gs.$$.fragment,e),m(us.$$.fragment,e),m(hs.$$.fragment,e),m(fs.$$.fragment,e),m(_s.$$.fragment,e),m(bs.$$.fragment,e),m(Ts.$$.fragment,e),m(ys.$$.fragment,e),m(vs.$$.fragment,e),m($s.$$.fragment,e),m(ws.$$.fragment,e),m(xs.$$.fragment,e),m(ks.$$.fragment,e),m(Ms.$$.fragment,e),m(Ls.$$.fragment,e),m(Fs.$$.fragment,e),m(zs.$$.fragment,e),m(Us.$$.fragment,e),m(Js.$$.fragment,e),m(Is.$$.fragment,e),m(Cs.$$.fragment,e),m(Bs.$$.fragment,e),m(qs.$$.fragment,e),m(Ws.$$.fragment,e),m(St.$$.fragment,e),m(Vs.$$.fragment,e),m(Ss.$$.fragment,e),m(Zt.$$.fragment,e),m(Zs.$$.fragment,e),m(Ds.$$.fragment,e),m(Dt.$$.fragment,e),m(Ps.$$.fragment,e),m(Gs.$$.fragment,e),m(Es.$$.fragment,e),m(Xs.$$.fragment,e),m(Ns.$$.fragment,e),m(Hs.$$.fragment,e),m(Rs.$$.fragment,e),m(Os.$$.fragment,e),m(Pt.$$.fragment,e),m(Gt.$$.fragment,e),m(Et.$$.fragment,e),m(Qs.$$.fragment,e),m(As.$$.fragment,e),m(Ys.$$.fragment,e),m(Ks.$$.fragment,e),m(eo.$$.fragment,e),m(to.$$.fragment,e),m(no.$$.fragment,e),m(so.$$.fragment,e),m(oo.$$.fragment,e),m(ro.$$.fragment,e),m(ao.$$.fragment,e),m(io.$$.fragment,e),m(co.$$.fragment,e),m(lo.$$.fragment,e),m(Xt.$$.fragment,e),m(po.$$.fragment,e),m(mo.$$.fragment,e),m(Nt.$$.fragment,e),m(Ht.$$.fragment,e),m(go.$$.fragment,e),m(uo.$$.fragment,e),m(Rt.$$.fragment,e),m(Ot.$$.fragment,e),m(ho.$$.fragment,e),m(fo.$$.fragment,e),m(_o.$$.fragment,e),m(bo.$$.fragment,e),m(Qt.$$.fragment,e),m(To.$$.fragment,e),m(yo.$$.fragment,e),m(At.$$.fragment,e),m(Yt.$$.fragment,e),m(vo.$$.fragment,e),m($o.$$.fragment,e),m(wo.$$.fragment,e),m(xo.$$.fragment,e),m(ko.$$.fragment,e),m(Mo.$$.fragment,e),m(Kt.$$.fragment,e),m(en.$$.fragment,e),m(jo.$$.fragment,e),m(Lo.$$.fragment,e),m(Fo.$$.fragment,e),m(zo.$$.fragment,e),m(tn.$$.fragment,e),m(Uo.$$.fragment,e),m(Jo.$$.fragment,e),m(Io.$$.fragment,e),m(Co.$$.fragment,e),m(nn.$$.fragment,e),m(Bo.$$.fragment,e),m(qo.$$.fragment,e),m(Wo.$$.fragment,e),m(Vo.$$.fragment,e),m(So.$$.fragment,e),m(Zo.$$.fragment,e),m(Do.$$.fragment,e),m(Po.$$.fragment,e),m(Go.$$.fragment,e),m(Eo.$$.fragment,e),m(Xo.$$.fragment,e),m(No.$$.fragment,e),m(Ho.$$.fragment,e),m(Ro.$$.fragment,e),m(Oo.$$.fragment,e),m(Qo.$$.fragment,e),m(Ao.$$.fragment,e),m(Yo.$$.fragment,e),m(Ko.$$.fragment,e),m(er.$$.fragment,e),m(tr.$$.fragment,e),m(nr.$$.fragment,e),m(sr.$$.fragment,e),m(or.$$.fragment,e),m(rr.$$.fragment,e),m(ar.$$.fragment,e),m(ir.$$.fragment,e),m(cr.$$.fragment,e),m(lr.$$.fragment,e),m(dr.$$.fragment,e),m(pr.$$.fragment,e),m(mr.$$.fragment,e),m(gr.$$.fragment,e),m(ur.$$.fragment,e),m(hr.$$.fragment,e),m(fr.$$.fragment,e),m(_r.$$.fragment,e),m(br.$$.fragment,e),m(Tr.$$.fragment,e),m(yr.$$.fragment,e),m(vr.$$.fragment,e),m($r.$$.fragment,e),m(wr.$$.fragment,e),m(xr.$$.fragment,e),m(kr.$$.fragment,e),m(Mr.$$.fragment,e),m(jr.$$.fragment,e),m(Lr.$$.fragment,e),m(Fr.$$.fragment,e),m(zr.$$.fragment,e),m(Ur.$$.fragment,e),m(Jr.$$.fragment,e),m(Ir.$$.fragment,e),m(Cr.$$.fragment,e),m(Br.$$.fragment,e),m(qr.$$.fragment,e),m(Wr.$$.fragment,e),m(Vr.$$.fragment,e),m(Sr.$$.fragment,e),m(Zr.$$.fragment,e),m(Dr.$$.fragment,e),m(Pr.$$.fragment,e),m(Er.$$.fragment,e),m(Xr.$$.fragment,e),m(Nr.$$.fragment,e),m(Hr.$$.fragment,e),m(Rr.$$.fragment,e),m(Or.$$.fragment,e),m(Qr.$$.fragment,e),m(Ar.$$.fragment,e),m(Yr.$$.fragment,e),m(ea.$$.fragment,e),m(cn.$$.fragment,e),m(ta.$$.fragment,e),m(na.$$.fragment,e),m(sa.$$.fragment,e),m(oa.$$.fragment,e),m(ra.$$.fragment,e),m(aa.$$.fragment,e),m(ia.$$.fragment,e),m(ca.$$.fragment,e),m(la.$$.fragment,e),m(da.$$.fragment,e),m(pa.$$.fragment,e),m(ma.$$.fragment,e),m(ga.$$.fragment,e),m(ua.$$.fragment,e),m(ha.$$.fragment,e),m(fa.$$.fragment,e),m(_a.$$.fragment,e),m(ba.$$.fragment,e),m(Ta.$$.fragment,e),m(ya.$$.fragment,e),m(va.$$.fragment,e),m($a.$$.fragment,e),m(wa.$$.fragment,e),m(xa.$$.fragment,e),m(ka.$$.fragment,e),m(Ma.$$.fragment,e),m(ja.$$.fragment,e),m(fn.$$.fragment,e),m(_n.$$.fragment,e),m(La.$$.fragment,e),m(Fa.$$.fragment,e),m(za.$$.fragment,e),m(Ua.$$.fragment,e),m(vn.$$.fragment,e),m($n.$$.fragment,e),m(Ja.$$.fragment,e),ou=!0)},o(e){g(w.$$.fragment,e),g(Vn.$$.fragment,e),g(Dn.$$.fragment,e),g(Hn.$$.fragment,e),g(An.$$.fragment,e),g(Yn.$$.fragment,e),g(Kn.$$.fragment,e),g(es.$$.fragment,e),g(ts.$$.fragment,e),g(ns.$$.fragment,e),g(ss.$$.fragment,e),g(os.$$.fragment,e),g(rs.$$.fragment,e),g(as.$$.fragment,e),g(is.$$.fragment,e),g(cs.$$.fragment,e),g(ls.$$.fragment,e),g(ds.$$.fragment,e),g(ps.$$.fragment,e),g(ms.$$.fragment,e),g(gs.$$.fragment,e),g(us.$$.fragment,e),g(hs.$$.fragment,e),g(fs.$$.fragment,e),g(_s.$$.fragment,e),g(bs.$$.fragment,e),g(Ts.$$.fragment,e),g(ys.$$.fragment,e),g(vs.$$.fragment,e),g($s.$$.fragment,e),g(ws.$$.fragment,e),g(xs.$$.fragment,e),g(ks.$$.fragment,e),g(Ms.$$.fragment,e),g(Ls.$$.fragment,e),g(Fs.$$.fragment,e),g(zs.$$.fragment,e),g(Us.$$.fragment,e),g(Js.$$.fragment,e),g(Is.$$.fragment,e),g(Cs.$$.fragment,e),g(Bs.$$.fragment,e),g(qs.$$.fragment,e),g(Ws.$$.fragment,e),g(St.$$.fragment,e),g(Vs.$$.fragment,e),g(Ss.$$.fragment,e),g(Zt.$$.fragment,e),g(Zs.$$.fragment,e),g(Ds.$$.fragment,e),g(Dt.$$.fragment,e),g(Ps.$$.fragment,e),g(Gs.$$.fragment,e),g(Es.$$.fragment,e),g(Xs.$$.fragment,e),g(Ns.$$.fragment,e),g(Hs.$$.fragment,e),g(Rs.$$.fragment,e),g(Os.$$.fragment,e),g(Pt.$$.fragment,e),g(Gt.$$.fragment,e),g(Et.$$.fragment,e),g(Qs.$$.fragment,e),g(As.$$.fragment,e),g(Ys.$$.fragment,e),g(Ks.$$.fragment,e),g(eo.$$.fragment,e),g(to.$$.fragment,e),g(no.$$.fragment,e),g(so.$$.fragment,e),g(oo.$$.fragment,e),g(ro.$$.fragment,e),g(ao.$$.fragment,e),g(io.$$.fragment,e),g(co.$$.fragment,e),g(lo.$$.fragment,e),g(Xt.$$.fragment,e),g(po.$$.fragment,e),g(mo.$$.fragment,e),g(Nt.$$.fragment,e),g(Ht.$$.fragment,e),g(go.$$.fragment,e),g(uo.$$.fragment,e),g(Rt.$$.fragment,e),g(Ot.$$.fragment,e),g(ho.$$.fragment,e),g(fo.$$.fragment,e),g(_o.$$.fragment,e),g(bo.$$.fragment,e),g(Qt.$$.fragment,e),g(To.$$.fragment,e),g(yo.$$.fragment,e),g(At.$$.fragment,e),g(Yt.$$.fragment,e),g(vo.$$.fragment,e),g($o.$$.fragment,e),g(wo.$$.fragment,e),g(xo.$$.fragment,e),g(ko.$$.fragment,e),g(Mo.$$.fragment,e),g(Kt.$$.fragment,e),g(en.$$.fragment,e),g(jo.$$.fragment,e),g(Lo.$$.fragment,e),g(Fo.$$.fragment,e),g(zo.$$.fragment,e),g(tn.$$.fragment,e),g(Uo.$$.fragment,e),g(Jo.$$.fragment,e),g(Io.$$.fragment,e),g(Co.$$.fragment,e),g(nn.$$.fragment,e),g(Bo.$$.fragment,e),g(qo.$$.fragment,e),g(Wo.$$.fragment,e),g(Vo.$$.fragment,e),g(So.$$.fragment,e),g(Zo.$$.fragment,e),g(Do.$$.fragment,e),g(Po.$$.fragment,e),g(Go.$$.fragment,e),g(Eo.$$.fragment,e),g(Xo.$$.fragment,e),g(No.$$.fragment,e),g(Ho.$$.fragment,e),g(Ro.$$.fragment,e),g(Oo.$$.fragment,e),g(Qo.$$.fragment,e),g(Ao.$$.fragment,e),g(Yo.$$.fragment,e),g(Ko.$$.fragment,e),g(er.$$.fragment,e),g(tr.$$.fragment,e),g(nr.$$.fragment,e),g(sr.$$.fragment,e),g(or.$$.fragment,e),g(rr.$$.fragment,e),g(ar.$$.fragment,e),g(ir.$$.fragment,e),g(cr.$$.fragment,e),g(lr.$$.fragment,e),g(dr.$$.fragment,e),g(pr.$$.fragment,e),g(mr.$$.fragment,e),g(gr.$$.fragment,e),g(ur.$$.fragment,e),g(hr.$$.fragment,e),g(fr.$$.fragment,e),g(_r.$$.fragment,e),g(br.$$.fragment,e),g(Tr.$$.fragment,e),g(yr.$$.fragment,e),g(vr.$$.fragment,e),g($r.$$.fragment,e),g(wr.$$.fragment,e),g(xr.$$.fragment,e),g(kr.$$.fragment,e),g(Mr.$$.fragment,e),g(jr.$$.fragment,e),g(Lr.$$.fragment,e),g(Fr.$$.fragment,e),g(zr.$$.fragment,e),g(Ur.$$.fragment,e),g(Jr.$$.fragment,e),g(Ir.$$.fragment,e),g(Cr.$$.fragment,e),g(Br.$$.fragment,e),g(qr.$$.fragment,e),g(Wr.$$.fragment,e),g(Vr.$$.fragment,e),g(Sr.$$.fragment,e),g(Zr.$$.fragment,e),g(Dr.$$.fragment,e),g(Pr.$$.fragment,e),g(Er.$$.fragment,e),g(Xr.$$.fragment,e),g(Nr.$$.fragment,e),g(Hr.$$.fragment,e),g(Rr.$$.fragment,e),g(Or.$$.fragment,e),g(Qr.$$.fragment,e),g(Ar.$$.fragment,e),g(Yr.$$.fragment,e),g(ea.$$.fragment,e),g(cn.$$.fragment,e),g(ta.$$.fragment,e),g(na.$$.fragment,e),g(sa.$$.fragment,e),g(oa.$$.fragment,e),g(ra.$$.fragment,e),g(aa.$$.fragment,e),g(ia.$$.fragment,e),g(ca.$$.fragment,e),g(la.$$.fragment,e),g(da.$$.fragment,e),g(pa.$$.fragment,e),g(ma.$$.fragment,e),g(ga.$$.fragment,e),g(ua.$$.fragment,e),g(ha.$$.fragment,e),g(fa.$$.fragment,e),g(_a.$$.fragment,e),g(ba.$$.fragment,e),g(Ta.$$.fragment,e),g(ya.$$.fragment,e),g(va.$$.fragment,e),g($a.$$.fragment,e),g(wa.$$.fragment,e),g(xa.$$.fragment,e),g(ka.$$.fragment,e),g(Ma.$$.fragment,e),g(ja.$$.fragment,e),g(fn.$$.fragment,e),g(_n.$$.fragment,e),g(La.$$.fragment,e),g(Fa.$$.fragment,e),g(za.$$.fragment,e),g(Ua.$$.fragment,e),g(vn.$$.fragment,e),g($n.$$.fragment,e),g(Ja.$$.fragment,e),ou=!1},d(e){e&&(n(x),n($),n(v),n(h),n(k),n(Sp),n(Wn),n(Zp),n(Dp),n(Sn),n(Pp),n(Zn),n(Gp),n(Ep),n(Pn),n(Xp),n(Gn),n(Np),n(En),n(Hp),n(Xn),n(Rp),n(Nn),n(Op),n(Qp),n(Rn),n(Ap),n(On),n(Yp),n(Qn),n(Kp),n(em),n(pt),n(tm),n(mt),n(nm),n(gt),n(sm),n(ut),n(om),n(ht),n(rm),n(ft),n(am),n(_t),n(im),n(bt),n(cm),n(Tt),n(lm),n(yt),n(dm),n(pm),n(vt),n(mm),n($t),n(gm),n(wt),n(um),n(xt),n(hm),n(kt),n(fm),n(Mt),n(_m),n(jt),n(bm),n(Lt),n(Tm),n(Ft),n(ym),n(zt),n(vm),n($m),n(ae),n(wm),n(ie),n(xm),n(ce),n(km),n(Mm),n(js),n(jm),n(Lm),n(le),n(Fm),n(N),n(zm),n(de),n(Um),n(H),n(Jm),n(R),n(Im),n(O),n(Cm),n(Q),n(Bm),n(pe),n(qm),n(me),n(Wm),n(ge),n(Vm),n(j),n(Sm),n(ue),n(Zm),n(he),n(Dm),n(fe),n(Pm),n(_e),n(Gm),n(be),n(Em),n(Te),n(Xm),n(A),n(Nm),n(q),n(Hm),n(W),n(Rm),n(ye),n(Om),n(V),n(Qm),n(S),n(Am),n(ve),n(Ym),n($e),n(Km),n(Z),n(eg),n(we),n(tg),n(Y),n(ng),n(xe),n(sg),n(D),n(og),n(K),n(rg),n(ag),n(ke),n(ig),n(Me),n(cg),n(je),n(lg),n(Le),n(dg),n(Fe),n(pg),n(ze),n(mg),n(Ue),n(gg),n(Je),n(ug),n(Ie),n(hg),n(Ce),n(fg),n(Be),n(_g),n(qe),n(bg),n(We),n(Tg),n(Ve),n(yg),n(Se),n(vg),n($g),n(Ze),n(wg),n(De),n(xg),n(Pe),n(kg),n(Ge),n(Mg),n(Ee),n(jg),n(Xe),n(Lg),n(Ne),n(Fg),n(He),n(zg),n(Re),n(Ug),n(Oe),n(Jg),n(Qe),n(Ig),n(Ae),n(Cg),n(Ye),n(Bg),n(qg),n(Gr),n(Wg),n(ee),n(Vg),n(Ut),n(Sg),n(Ke),n(Zg),n(et),n(Dg),n(Pg),n(Kr),n(Gg),n(L),n(Eg),n(Jt),n(Xg),n(It),n(Ng),n(te),n(Hg),n(Rg),n(ne),n(Og),n(I),n(Qg),n(se),n(Ag),n(Yg),n(tt),n(Kg),n(nt),n(eu),n(tu),n(J),n(nu),n(P),n(su),n(Vp)),n(f),u(w,e),u(Vn,e),u(Dn,e),u(Hn,e),u(An,e),u(Yn),u(Kn),u(es),u(ts),u(ns),u(ss),u(os),u(rs),u(as),u(is),u(cs,e),u(ls),u(ds),u(ps),u(ms),u(gs),u(us),u(hs),u(fs),u(_s),u(bs),u(Ts,e),u(ys),u(vs),u($s),u(ws),u(xs),u(ks),u(Ms,e),u(Ls,e),u(Fs),u(zs),u(Us),u(Js),u(Is),u(Cs),u(Bs),u(qs),u(Ws),u(St),u(Vs),u(Ss),u(Zt),u(Zs),u(Ds),u(Dt),u(Ps),u(Gs),u(Es),u(Xs),u(Ns),u(Hs),u(Rs),u(Os),u(Pt),u(Gt),u(Et),u(Qs),u(As),u(Ys),u(Ks),u(eo),u(to),u(no),u(so),u(oo),u(ro),u(ao),u(io),u(co),u(lo),u(Xt),u(po),u(mo),u(Nt),u(Ht),u(go),u(uo),u(Rt),u(Ot),u(ho),u(fo),u(_o),u(bo),u(Qt),u(To),u(yo),u(At),u(Yt),u(vo),u($o),u(wo),u(xo),u(ko),u(Mo),u(Kt),u(en),u(jo),u(Lo),u(Fo),u(zo),u(tn),u(Uo),u(Jo),u(Io),u(Co),u(nn),u(Bo),u(qo),u(Wo),u(Vo,e),u(So),u(Zo),u(Do),u(Po),u(Go),u(Eo),u(Xo),u(No),u(Ho),u(Ro),u(Oo),u(Qo),u(Ao),u(Yo),u(Ko),u(er),u(tr),u(nr),u(sr),u(or),u(rr),u(ar),u(ir),u(cr),u(lr),u(dr),u(pr),u(mr),u(gr),u(ur),u(hr,e),u(fr),u(_r),u(br),u(Tr),u(yr),u(vr),u($r),u(wr),u(xr),u(kr),u(Mr),u(jr),u(Lr),u(Fr),u(zr),u(Ur),u(Jr),u(Ir),u(Cr),u(Br),u(qr),u(Wr),u(Vr),u(Sr),u(Zr),u(Dr),u(Pr,e),u(Er),u(Xr),u(Nr),u(Hr),u(Rr),u(Or),u(Qr),u(Ar),u(Yr,e),u(ea),u(cn),u(ta),u(na),u(sa),u(oa),u(ra),u(aa),u(ia),u(ca),u(la),u(da),u(pa),u(ma),u(ga,e),u(ua),u(ha),u(fa),u(_a),u(ba),u(Ta),u(ya),u(va),u($a),u(wa,e),u(xa),u(ka),u(Ma,e),u(ja),u(fn),u(_n),u(La),u(Fa),u(za),u(Ua),u(vn),u($n),u(Ja)}}}const Bw='{"title":"Utilities for Generation","local":"utilities-for-generation","sections":[{"title":"Generate Outputs","local":"generate-outputs","sections":[{"title":"PyTorch","local":"transformers.generation.GreedySearchEncoderDecoderOutput","sections":[],"depth":3},{"title":"TensorFlow","local":"transformers.generation.TFGreedySearchEncoderDecoderOutput","sections":[],"depth":3},{"title":"FLAX","local":"transformers.generation.FlaxSampleOutput","sections":[],"depth":3}],"depth":2},{"title":"LogitsProcessor","local":"logitsprocessor","sections":[{"title":"PyTorch","local":"transformers.AlternatingCodebooksLogitsProcessor","sections":[],"depth":3},{"title":"TensorFlow","local":"transformers.TFForcedBOSTokenLogitsProcessor","sections":[],"depth":3},{"title":"FLAX","local":"transformers.FlaxForcedBOSTokenLogitsProcessor","sections":[],"depth":3}],"depth":2},{"title":"StoppingCriteria","local":"transformers.StoppingCriteria","sections":[],"depth":2},{"title":"Constraints","local":"transformers.Constraint","sections":[],"depth":2},{"title":"BeamSearch","local":"transformers.BeamScorer","sections":[],"depth":2},{"title":"Utilities","local":"transformers.top_k_top_p_filtering","sections":[],"depth":2},{"title":"Streamers","local":"transformers.TextStreamer","sections":[],"depth":2}],"depth":1}';function qw(M){return iw(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ew extends cw{constructor(f){super(),lw(this,f,qw,Cw,aw,{})}}export{Ew as component};
