import{s as Yw,n as Pw,o as Fw}from"../chunks/scheduler.9bc65507.js";import{S as Kw,i as Dw,g as i,s as n,r as d,m as r,H as c,A as Ow,h as p,f as a,c as l,j as v,u as g,x as o,n as h,B as u,k as _,y as m,a as e,v as f,d as y,t as w,w as b}from"../chunks/index.707bf1b6.js";import{C as M}from"../chunks/CodeBlock.54a9f38d.js";import{D as sb}from"../chunks/DocNotebookDropdown.3e6b3817.js";import{H as hn}from"../chunks/Heading.342b1fa6.js";function tb(Su){let is,hl,ol,cl,Ls,ul,zs,dl,Gs,Yu=`Large Language Models (LLMs) such as GPT3/4, <a href="https://huggingface.co/tiiuae/falcon-40b" rel="nofollow">Falcon</a>, and <a href="https://huggingface.co/meta-llama/Llama-2-70b-hf" rel="nofollow">Llama</a> are rapidly advancing in their ability to tackle human-centric tasks, establishing themselves as essential tools in modern knowledge-based industries.
Deploying these models in real-world tasks remains challenging, however:`,gl,Bs,Pu='<li>To exhibit near-human text understanding and generation capabilities, LLMs currently require to be composed of billions of parameters (see <a href="https://arxiv.org/abs/2001.08361" rel="nofollow">Kaplan et al</a>, <a href="https://arxiv.org/abs/2206.07682" rel="nofollow">Wei et. al</a>). This consequently amplifies the memory demands for inference.</li> <li>In many real-world tasks, LLMs need to be given extensive contextual information. This necessitates the model’s capability to manage very long input sequences during inference.</li>',fl,$s,Fu="The crux of these challenges lies in augmenting the computational and memory capabilities of LLMs, especially when handling expansive input sequences.",yl,Zs,Ku="In this guide, we will go over the effective techniques for efficient LLM deployment:",wl,Is,Du='<li><p><strong>Lower Precision</strong>: Research has shown that operating at reduced numerical precision, namely <a href="./main_classes/quantization.md">8-bit and 4-bit</a> can achieve computational advantages without a considerable decline in model performance.</p></li> <li><p><strong>Flash Attention:</strong> Flash Attention is a variation of the attention algorithm that not only provides a more memory-efficient approach but also realizes increased efficiency due to optimized GPU memory utilization.</p></li> <li><p><strong>Architectural Innovations:</strong> Considering that LLMs are always deployed in the same way during inference, namely autoregressive text generation with a long input context, specialized model architectures have been proposed that allow for more efficient inference. The most important advancement in model architectures hereby are <a href="https://arxiv.org/abs/2108.12409" rel="nofollow">Alibi</a>, <a href="https://arxiv.org/abs/2104.09864" rel="nofollow">Rotary embeddings</a>, <a href="https://arxiv.org/abs/1911.02150" rel="nofollow">Multi-Query Attention (MQA)</a> and <a href="(https://arxiv.org/abs/2305.13245)">Grouped-Query-Attention (GQA)</a>.</p></li>',bl,Hs,Ou="Throughout this guide, we will offer an analysis of auto-regressive generation from a tensor’s perspective. We delve into the pros and cons of adopting lower precision, provide a comprehensive exploration of the latest attention algorithms, and discuss improved LLM architectures. While doing so, we run practical examples showcasing each of the feature improvements.",vl,Ws,Ml,Qs,sd="Memory requirements of LLMs can be best understood by seeing the LLM as a set of weight matrices and vectors and the text inputs as a sequence of vectors. In the following, the definition <em>weights</em> will be used to signify all model weight matrices and vectors.",xl,Ns,td='At the time of writing this guide, LLMs consist of at least a couple billion parameters. Each parameter thereby is made of a decimal number, e.g. <code>4.5689</code> which is usually stored in either <a href="https://en.wikipedia.org/wiki/Single-precision_floating-point_format" rel="nofollow">float32</a>, <a href="https://en.wikipedia.org/wiki/Bfloat16_floating-point_format" rel="nofollow">bfloat16</a>, or <a href="https://en.wikipedia.org/wiki/Half-precision_floating-point_format" rel="nofollow">float16</a> format. This allows us to easily compute the memory requirement to load the LLM into memory:',kl,Rs,ad="<p><em>Loading the weights of a model having X billion parameters requires roughly 4</em> X GB of VRAM in float32 precision*</p>",Tl,qs,ed="Nowadays, models are however rarely trained in full float32 precision, but usually in bfloat16 precision or less frequently in float16 precision. Therefore the rule of thumb becomes:",_l,Xs,nd="<p><em>Loading the weights of a model having X billion parameters requires roughly 2</em> X GB of VRAM in bfloat16/float16 precision*</p>",jl,Vs,ld="For shorter text inputs (less than 1024 tokens), the memory requirement for inference is very much dominated by the memory requirement to load the weights. Therefore, for now, let’s assume that the memory requirement for inference is equal to the memory requirement to load the model into the GPU VRAM.",Ul,As,id="To give some examples of how much VRAM it roughly takes to load a model in bfloat16:",Jl,Es,pd='<li><strong>GPT3</strong> requires 2 * 175 GB = <strong>350 GB</strong> VRAM</li> <li><a href="https://huggingface.co/bigscience/bloom" rel="nofollow"><strong>Bloom</strong></a> requires 2 * 176 GB = <strong>352 GB</strong> VRAM</li> <li><a href="https://huggingface.co/meta-llama/Llama-2-70b-hf" rel="nofollow"><strong>Llama-2-70b</strong></a> requires 2 * 70 GB = <strong>140 GB</strong> VRAM</li> <li><a href="https://huggingface.co/tiiuae/falcon-40b" rel="nofollow"><strong>Falcon-40b</strong></a> requires 2 * 40 GB = <strong>80 GB</strong> VRAM</li> <li><a href="https://huggingface.co/mosaicml/mpt-30b" rel="nofollow"><strong>MPT-30b</strong></a> requires 2 * 30 GB = <strong>60 GB</strong> VRAM</li> <li><a href="https://huggingface.co/bigcode/starcoder" rel="nofollow"><strong>bigcode/starcoder</strong></a> requires 2 * 15.5 = <strong>31 GB</strong> VRAM</li>',Cl,Ss,md='As of writing this document, the largest GPU chip on the market is the A100 &amp; H100 offering 80GB of VRAM. Most of the models listed before require more than 80GB just to be loaded and therefore necessarily require <a href="https://huggingface.co/docs/transformers/perf_train_gpu_many#tensor-parallelism" rel="nofollow">tensor parallelism</a> and/or <a href="https://huggingface.co/docs/transformers/perf_train_gpu_many#naive-model-parallelism-vertical-and-pipeline-parallelism" rel="nofollow">pipeline parallelism</a>.',Ll,Ys,od='🤗 Transformers does not support tensor parallelism out of the box as it requires the model architecture to be written in a specific way. If you’re interested in writing models in a tensor-parallelism-friendly way, feel free to have a look at <a href="https://github.com/huggingface/text-generation-inference/tree/main/server/text_generation_server/models/custom_modeling" rel="nofollow">the text-generation-inference library</a>.',zl,Ps,rd=`Naive pipeline parallelism is supported out of the box. For this, simply load the model with <code>device=&quot;auto&quot;</code> which will automatically place the different layers on the available GPUs as explained <a href="https://huggingface.co/docs/accelerate/v0.22.0/en/concept_guides/big_model_inference" rel="nofollow">here</a>.
Note, however that while very effective, this naive pipeline parallelism does not tackle the issues of GPU idling. For this more advanced pipeline parallelism is required as explained <a href="https://huggingface.co/docs/transformers/v4.34.0/en/perf_train_gpu_many#naive-model-parallelism-vertical-and-pipeline-parallelism" rel="nofollow">here</a>.`,Gl,Fs,hd="If you have access to an 8 x 80GB A100 node, you could load BLOOM as follows",Bl,Ks,$l,Ds,Zl,Os,cd="By using <code>device_map=&quot;auto&quot;</code> the attention layers would be equally distributed over all available GPUs.",Il,st,ud='In this guide, we will use <a href="https://huggingface.co/bigcode/octocoder" rel="nofollow">bigcode/octocoder</a> as it can be run on a single 40 GB A100 GPU device chip. Note that all memory and speed optimizations that we will apply going forward, are equally applicable to models that require model or tensor parallelism.',Hl,tt,dd="Since the model is loaded in bfloat16 precision, using our rule of thumb above, we would expect the memory requirement to run inference with <code>bigcode/octocoder</code> to be around 31 GB VRAM. Let’s give it a try.",Wl,at,gd='We first load the model and tokenizer and then pass both to Transformers’ <a href="https://huggingface.co/docs/transformers/main_classes/pipelines" rel="nofollow">pipeline</a> object.',Ql,et,Nl,nt,Rl,lt,fd="<strong>Output</strong>:",ql,it,Xl,pt,yd="Nice, we can now directly use the result to convert bytes into Gigabytes.",Vl,mt,Al,ot,wd='Let’s call <a href="https://pytorch.org/docs/stable/generated/torch.cuda.max_memory_allocated.html" rel="nofollow"><code>torch.cuda.max_memory_allocated</code></a> to measure the peak GPU memory allocation.',El,rt,Sl,ht,bd="<strong>Output</strong>:",Yl,ct,Pl,ut,vd=`Close enough to our back-of-the-envelope computation! We can see the number is not exactly correct as going from bytes to kilobytes requires a multiplication of 1024 instead of 1000. Therefore the back-of-the-envelope formula can also be understood as an “at most X GB” computation.
Note that if we had tried to run the model in full float32 precision, a whopping 64 GB of VRAM would have been required.`,Fl,dt,Md='<p>Almost all models are trained in bfloat16 nowadays, there is no reason to run the model in full float32 precision if <a href="https://discuss.pytorch.org/t/bfloat16-native-support/117155/5" rel="nofollow">your GPU supports bfloat16</a>. Float32 won’t give better inference results than the precision that was used to train the model.</p>',Kl,gt,xd='If you are unsure in which format the model weights are stored on the Hub, you can always look into the checkpoint’s config under <code>&quot;torch_dtype&quot;</code>, <em>e.g.</em> <a href="https://huggingface.co/meta-llama/Llama-2-7b-hf/blob/6fdf2e60f86ff2481f2241aaee459f85b5b0bbb9/config.json#L21" rel="nofollow">here</a>. It is recommended to set the model to the same precision type as written in the config when loading with <code>from_pretrained(..., torch_dtype=...)</code> except when the original type is float32 in which case one can use both <code>float16</code> or <code>bfloat16</code> for inference.',Dl,ft,kd="Let’s define a <code>flush(...)</code> function to free all allocated memory so that we can accurately measure the peak allocated GPU memory.",Ol,yt,si,wt,Td="Let’s call it now for the next experiment.",ti,bt,ai,vt,_d="In the recent version of the accelerate library, you can also use an utility method called <code>release_memory()</code>",ei,Mt,ni,xt,jd=`Now what if your GPU does not have 32 GB of VRAM? It has been found that model weights can be quantized to 8-bit or 4-bits without a significant loss in performance (see <a href="https://arxiv.org/abs/2208.07339" rel="nofollow">Dettmers et al.</a>).
Model can be quantized to even 3 or 2 bits with an acceptable loss in performance as shown in the recent <a href="https://arxiv.org/abs/2210.17323" rel="nofollow">GPTQ paper</a> 🤯.`,li,kt,Ud=`Without going into too many details, quantization schemes aim at reducing the precision of weights while trying to keep the model’s inference results as accurate as possible (<em>a.k.a</em> as close as possible to bfloat16).
Note that quantization works especially well for text generation since all we care about is choosing the <em>set of most likely next tokens</em> and don’t really care about the exact values of the next token <em>logit</em> distribution.
All that matters is that the next token <em>logit</em> distribution stays roughly the same so that an <code>argmax</code> or <code>topk</code> operation gives the same results.`,ii,Tt,Jd="There are various quantization techniques, which we won’t discuss in detail here, but in general, all quantization techniques work as follows:",pi,_t,Cd='<li><ol><li>Quantize all weights to the target precision</li></ol></li> <li><ol start="2"><li>Load the quantized weights, and pass the input sequence of vectors in bfloat16 precision</li></ol></li> <li><ol start="3"><li>Dynamically dequantize weights to bfloat16 to perform the computation with their input vectors in bfloat16 precision</li></ol></li>',mi,z,Cc,cn,Ld="inputs-weight matrix",Lc,oi,xy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>X</mi></mrow><annotation encoding="application/x-tex"> X </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.07847em;">X</span></span></span></span>',ri,un,zd="inputs",zc,hi,ky='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>W</mi></mrow><annotation encoding="application/x-tex"> W </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">W</span></span></span></span>',ci,ui,Ty='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>Y</mi></mrow><annotation encoding="application/x-tex"> Y </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.22222em;">Y</span></span></span></span>',di,gi,dn,fi,_y='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mi>Y</mi><mo>=</mo><mi>X</mi><mo>∗</mo><mi>W</mi></mrow><annotation encoding="application/x-tex"> Y = X * W </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.22222em;">Y</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.07847em;">X</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">W</span></span></span></span></span>',yi,jt,Gd="are changed to",wi,gn,bi,jy='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mi>Y</mi><mo>=</mo><mi>X</mi><mo>∗</mo><mtext>dequantize</mtext><mo stretchy="false">(</mo><mi>W</mi><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex"> Y = X * \\text{dequantize}(W) </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.22222em;">Y</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.07847em;">X</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord text"><span class="mord">dequantize</span></span><span class="mopen">(</span><span class="mord mathnormal" style="margin-right:0.13889em;">W</span><span class="mclose">)</span></span></span></span></span>',vi,Ut,Bd="for every matrix multiplication. Dequantization and re-quantization is performed sequentially for all weight matrices as the inputs run through the network graph.",Mi,Jt,$d=`Therefore, inference time is often <strong>not</strong> reduced when using quantized weights, but rather increases.
Enough theory, let’s give it a try! To quantize the weights with Transformers, you need to make sure that
the <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow"><code>bitsandbytes</code></a> library is installed.`,xi,Ct,ki,Lt,Zd="We can then load models in 8-bit quantization by simply adding a <code>load_in_8bit=True</code> flag to <code>from_pretrained</code>.",Ti,zt,_i,Gt,Id="Now, let’s run our example again and measure the memory usage.",ji,Bt,Ui,$t,Hd="<strong>Output</strong>:",Ji,Zt,Ci,It,Wd="Nice, we’re getting the same result as before, so no loss in accuracy! Let’s look at how much memory was used this time.",Li,Ht,zi,Wt,Qd="<strong>Output</strong>:",Gi,Qt,Bi,Nt,Nd=`Significantly less! We’re down to just a bit over 15 GBs and could therefore run this model on consumer GPUs like the 4090.
We’re seeing a very nice gain in memory efficiency and more or less no degradation to the model’s output. However, we can also notice a slight slow-down during inference.`,$i,Rt,Rd="We delete the models and flush the memory again.",Zi,qt,Ii,Xt,Hi,Vt,qd="Let’s see what peak GPU memory consumption 4-bit quantization gives. Quantizing the model to 4-bit can be done with the same API as before - this time by passing <code>load_in_4bit=True</code> instead of <code>load_in_8bit=True</code>.",Wi,At,Qi,Et,Xd="<strong>Output</strong>:",Ni,St,Ri,Yt,Vd="We’re almost seeing the same output text as before - just the <code>python</code> is missing just before the code snippet. Let’s see how much memory was required.",qi,Pt,Xi,Ft,Ad="<strong>Output</strong>:",Vi,Kt,Ai,Dt,Ed="Just 9.5GB! That’s really not a lot for a >15 billion parameter model.",Ei,Ot,Sd="While we see very little degradation in accuracy for our model here, 4-bit quantization can in practice often lead to different results compared to 8-bit quantization or full <code>bfloat16</code> inference. It is up to the user to try it out.",Si,K,Gc,Yi,Uy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mtext>quantize</mtext></mrow><annotation encoding="application/x-tex"> \\text{quantize} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8623em;vertical-align:-0.1944em;"></span><span class="mord text"><span class="mord">quantize</span></span></span></span></span>',Pi,Fi,Jy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mtext>dequantize</mtext></mrow><annotation encoding="application/x-tex"> \\text{dequantize} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord text"><span class="mord">dequantize</span></span></span></span></span>',Ki,Di,sa,Oi,ta,sp,aa,Yd="Overall, we saw that running OctoCoder in 8-bit precision reduced the required GPU VRAM from 32G GPU VRAM to only 15GB and running the model in 4-bit precision further reduces the required GPU VRAM to just a bit over 9GB.",tp,ea,Pd="4-bit quantization allows the model to be run on GPUs such as RTX3090, V100, and T4 which are quite accessible for most people.",ap,na,Fd='For more information on quantization and to see how one can quantize models to require even less GPU VRAM memory than 4-bit, we recommend looking into the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#autogptq-integration%60" rel="nofollow"><code>AutoGPTQ</code></a> implementation.',ep,la,Kd="<p>As a conclusion, it is important to remember that model quantization trades improved memory efficiency against accuracy and in some cases inference time.</p>",np,ia,Dd="If GPU memory is not a constraint for your use case, there is often no need to look into quantization. However many GPUs simply can’t run LLMs without quantization methods and in this case, 4-bit and 8-bit quantization schemes are extremely useful tools.",lp,pa,Od=`For more in-detail usage information, we strongly recommend taking a look at the <a href="https://huggingface.co/docs/transformers/main_classes/quantization#general-usage" rel="nofollow">Transformers Quantization Docs</a>.
Next, let’s look into how we can improve computational and memory efficiency by using better algorithms and an improved model architecture.`,ip,ma,pp,oa,sg="Today’s top-performing LLMs share more or less the same fundamental architecture that consists of feed-forward layers, activation layers, layer normalization layers, and most crucially, self-attention layers.",mp,q,Bc,fn,tg="quadratically",$c,yn,ag="sequence length",Zc,op,Cy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>N</mi></mrow><annotation encoding="application/x-tex"> N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span></span></span></span>',rp,hp,X,Ic,cp,Ly='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">O</mi></mrow><annotation encoding="application/x-tex"> \\mathbf{O} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6861em;"></span><span class="mord mathbf">O</span></span></span></span>',up,dp,zy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">X</mi></mrow><annotation encoding="application/x-tex"> \\mathbf{X} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6861em;"></span><span class="mord mathbf">X</span></span></span></span>',gp,fp,Gy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>N</mi></mrow><annotation encoding="application/x-tex"> N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span></span></span></span>',yp,wp,wn,bp,By='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mtext mathvariant="bold">O</mtext><mo>=</mo><mtext>Attn</mtext><mo stretchy="false">(</mo><mi mathvariant="bold">X</mi><mo stretchy="false">)</mo><mo>=</mo><mi mathvariant="bold">V</mi><mo>×</mo><mtext>Softmax</mtext><mo stretchy="false">(</mo><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup><mo stretchy="false">)</mo><mtext> with </mtext><mi mathvariant="bold">Q</mi><mo>=</mo><msub><mi mathvariant="bold">W</mi><mi>q</mi></msub><mi mathvariant="bold">X</mi><mo separator="true">,</mo><mi mathvariant="bold">V</mi><mo>=</mo><msub><mi mathvariant="bold">W</mi><mi>v</mi></msub><mi mathvariant="bold">X</mi><mo separator="true">,</mo><mi mathvariant="bold">K</mi><mo>=</mo><msub><mi mathvariant="bold">W</mi><mi>k</mi></msub><mi mathvariant="bold">X</mi></mrow><annotation encoding="application/x-tex"> \\textbf{O} = \\text{Attn}(\\mathbf{X}) = \\mathbf{V} \\times \\text{Softmax}(\\mathbf{QK}^T) \\text{ with } \\mathbf{Q} = \\mathbf{W}_q \\mathbf{X}, \\mathbf{V} = \\mathbf{W}_v \\mathbf{X}, \\mathbf{K} = \\mathbf{W}_k \\mathbf{X} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6861em;"></span><span class="mord text"><span class="mord textbf">O</span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord text"><span class="mord">Attn</span></span><span class="mopen">(</span><span class="mord mathbf">X</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.7694em;vertical-align:-0.0833em;"></span><span class="mord mathbf" style="margin-right:0.01597em;">V</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.1673em;vertical-align:-0.25em;"></span><span class="mord text"><span class="mord">Softmax</span></span><span class="mopen">(</span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span><span class="mclose">)</span><span class="mord text"><span class="mord"> with </span></span><span class="mord mathbf">Q</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.9722em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathbf" style="margin-right:0.01597em;">W</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:-0.016em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.03588em;">q</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mord mathbf">X</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathbf" style="margin-right:0.01597em;">V</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.8805em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf" style="margin-right:0.01597em;">W</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:-0.016em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.03588em;">v</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord mathbf">X</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathbf">K</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.8361em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathbf" style="margin-right:0.01597em;">W</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:-0.016em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.03148em;">k</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord mathbf">X</span></span></span></span></span>',vp,C,Mp,$y='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">X</mi><mo>=</mo><mo stretchy="false">(</mo><msub><mi mathvariant="bold">x</mi><mn>1</mn></msub><mo separator="true">,</mo><mi mathvariant="normal">.</mi><mi mathvariant="normal">.</mi><mi mathvariant="normal">.</mi><msub><mi mathvariant="bold">x</mi><mi>N</mi></msub><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">  \\mathbf{X} = (\\mathbf{x}_1, ... \\mathbf{x}_{N}) </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6861em;"></span><span class="mord mathbf">X</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">(</span><span class="mord"><span class="mord mathbf">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord">...</span><span class="mord"><span class="mord mathbf">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.10903em;">N</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',xp,kp,Zy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">Q</mi></mrow><annotation encoding="application/x-tex"> \\mathbf{Q} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8805em;vertical-align:-0.1944em;"></span><span class="mord mathbf">Q</span></span></span></span>',Tp,_p,Iy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">K</mi></mrow><annotation encoding="application/x-tex"> \\mathbf{K} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6861em;"></span><span class="mord mathbf">K</span></span></span></span>',jp,Up,Hy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>N</mi></mrow><annotation encoding="application/x-tex"> N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span></span></span></span>',Jp,Cp,Wy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',Lp,zp,Qy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mi>N</mi><mn>2</mn></msup></mrow><annotation encoding="application/x-tex"> N^2 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8141em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span></span></span></span>',Gp,Bp,j,Hc,$p,Ny='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">Q</mi><msup><mi mathvariant="bold">K</mi><mi mathvariant="bold">T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK^T} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0377em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">Q</span><span class="mord"><span class="mord mathbf">K</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8433em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathbf mtight">T</span></span></span></span></span></span></span></span></span></span></span></span>',Zp,Ip,Ry='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mn>40</mn><mo>∗</mo><mn>2</mn><mo>∗</mo><msup><mi>N</mi><mn>2</mn></msup></mrow><annotation encoding="application/x-tex"> 40 * 2 * N^2 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">40</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">2</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.8141em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span></span></span></span>',Hp,Wp,qy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>N</mi><mo>=</mo><mn>1000</mn></mrow><annotation encoding="application/x-tex"> N=1000 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1000</span></span></span></span>',Qp,Np,Xy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>N</mi><mo>=</mo><mn>16000</mn></mrow><annotation encoding="application/x-tex"> N=16000 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">16000</span></span></span></span>',Rp,qp,Vy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>N</mi><mo>=</mo><mn>100</mn><mo separator="true">,</mo><mn>000</mn></mrow><annotation encoding="application/x-tex"> N=100,000 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.8389em;vertical-align:-0.1944em;"></span><span class="mord">100</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord">000</span></span></span></span>',Xp,Vp,Ay='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',Ap,Ep,ra,eg="Long story short, the default self-attention algorithm quickly becomes prohibitively memory-expensive for large input contexts.",Sp,ha,ng="As LLMs improve in text comprehension and generation, they are applied to increasingly complex tasks. While models once handled the translation or summarization of a few sentences, they now manage entire pages, demanding the capability to process extensive input lengths.",Yp,V,Wc,Pp,Ey='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>Q</mi><msup><mi>K</mi><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> QK^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0358em;vertical-align:-0.1944em;"></span><span class="mord mathnormal">Q</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.07153em;">K</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8413em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',Fp,rs,lg="Tri Dao et al.",Qc,bn,ig="Flash Attention",Nc,Kp,hs,Rc,Dp,Sy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">V</mi><mo>×</mo><mtext>Softmax</mtext><mo stretchy="false">(</mo><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex">\\mathbf{V} \\times \\text{Softmax}(\\mathbf{QK}^T</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7694em;vertical-align:-0.0833em;"></span><span class="mord mathbf" style="margin-right:0.01597em;">V</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.1673em;vertical-align:-0.25em;"></span><span class="mord text"><span class="mord">Softmax</span></span><span class="mopen">(</span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',Op,sm,vn,tm,Yy='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><msub><mtext mathvariant="bold">O</mtext><mi>i</mi></msub><mo>←</mo><msubsup><mi>s</mi><mrow><mi>i</mi><mi>j</mi></mrow><mi>a</mi></msubsup><mo>∗</mo><msub><mtext mathvariant="bold">O</mtext><mi>i</mi></msub><mo>+</mo><msubsup><mi>s</mi><mrow><mi>i</mi><mi>j</mi></mrow><mi>b</mi></msubsup><mo>∗</mo><msub><mi mathvariant="bold">V</mi><mi>j</mi></msub><mo>×</mo><mtext>Softmax</mtext><mo stretchy="false">(</mo><msubsup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mrow><mi>i</mi><mo separator="true">,</mo><mi>j</mi></mrow><mi>T</mi></msubsup><mo stretchy="false">)</mo><mtext> for multiple </mtext><mi>i</mi><mo separator="true">,</mo><mi>j</mi><mtext> iterations</mtext></mrow><annotation encoding="application/x-tex"> \\textbf{O}_i \\leftarrow s^a_{ij} * \\textbf{O}_i + s^b_{ij} * \\mathbf{V}_{j} \\times \\text{Softmax}(\\mathbf{QK}^T_{i,j}) \\text{ for multiple } i, j \\text{ iterations} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8361em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord text"><span class="mord textbf">O</span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">←</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.0975em;vertical-align:-0.3831em;"></span><span class="mord"><span class="mord mathnormal">s</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.7144em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">ij</span></span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">a</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3831em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.8361em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord text"><span class="mord textbf">O</span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.2822em;vertical-align:-0.3831em;"></span><span class="mord"><span class="mord mathnormal">s</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8991em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">ij</span></span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">b</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3831em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.9722em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathbf" style="margin-right:0.01597em;">V</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.016em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.3004em;vertical-align:-0.3831em;"></span><span class="mord text"><span class="mord">Softmax</span></span><span class="mopen">(</span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-2.453em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span><span class="mpunct mtight">,</span><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3831em;"><span></span></span></span></span></span></span><span class="mclose">)</span><span class="mord text"><span class="mord"> for multiple </span></span><span class="mord mathnormal">i</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span><span class="mord text"><span class="mord"> iterations</span></span></span></span></span></span>',am,$,qc,em,Py='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msubsup><mi>s</mi><mrow><mi>i</mi><mi>j</mi></mrow><mi>a</mi></msubsup></mrow><annotation encoding="application/x-tex"> s^a_{ij} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0592em;vertical-align:-0.3948em;"></span><span class="mord"><span class="mord mathnormal">s</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.6644em;"><span style="top:-2.4413em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">ij</span></span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">a</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3948em;"><span></span></span></span></span></span></span></span></span></span>',nm,lm,Fy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msubsup><mi>s</mi><mrow><mi>i</mi><mi>j</mi></mrow><mi>b</mi></msubsup></mrow><annotation encoding="application/x-tex"> s^b_{ij} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.2439em;vertical-align:-0.3948em;"></span><span class="mord"><span class="mord mathnormal">s</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8491em;"><span style="top:-2.4413em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">ij</span></span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">b</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3948em;"><span></span></span></span></span></span></span></span></span></span>',im,pm,Ky='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',mm,om,Dy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>j</mi></mrow><annotation encoding="application/x-tex"> j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span></span></span>',rm,hm,ca,pg='Please note that the whole Flash Attention is a bit more complex and is greatly simplified here as going in too much depth is out of scope for this guide. The reader is invited to take a look at the well-written <a href="https://arxiv.org/abs/2205.14135" rel="nofollow">Flash Attention paper</a> for more details.',cm,ua,mg="The main takeaway here is:",um,Mn,ps,Xc,xn,og="numerical identical",Vc,dm,Oy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>N</mi></mrow><annotation encoding="application/x-tex"> N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span></span></span></span>',gm,fm,da,rg='Looking at the formula, one would intuitively say that Flash Attention must be much slower compared to the default self-attention formula as more computation needs to be done. Indeed Flash Attention requires more FLOPs compared to normal attention as the softmax normalization statistics have to constantly be recomputed (see <a href="https://arxiv.org/abs/2205.14135" rel="nofollow">paper</a> for more details if interested)',ym,ga,hg="<p>However, Flash Attention is much faster in inference compared to default attention which comes from its ability to significantly reduce the demands on the slower, high-bandwidth memory of the GPU (VRAM), focusing instead on the faster on-chip memory (SRAM).</p>",wm,D,Ac,kn,cg="on-chip",Ec,bm,sw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">O</mi></mrow><annotation encoding="application/x-tex"> \\mathbf{O} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6861em;"></span><span class="mord mathbf">O</span></span></span></span>',vm,Mm,fa,ug="In practice, there is currently absolutely no reason to <strong>not</strong> use Flash Attention if available. The algorithm gives mathematically the same outputs, and is both faster and more memory-efficient.",xm,ya,dg="Let’s look at a practical example.",km,wa,gg=`Our OctoCoder model now gets a significantly longer input prompt which includes a so-called <em>system prompt</em>. System prompts are used to steer the LLM into a better assistant that is tailored to the users’ task.
In the following, we use a system prompt that will make OctoCoder a better coding assistant.`,Tm,ba,_m,va,fg=`For demonstration purposes, we duplicate the system prompt by ten so that the input length is long enough to observe Flash Attention’s memory savings.
We append the original text prompt <code>&quot;Question: Please write a function in Python that transforms bytes to Giga bytes.\\n\\nAnswer: Here&quot;</code>`,jm,Ma,Um,xa,yg="We instantiate our model again in bfloat16 precision.",Jm,ka,Cm,Ta,wg="Let’s now run the model just like before <em>without Flash Attention</em> and measure the peak GPU memory requirement and inference time.",Lm,_a,zm,ja,bg="<strong>Output</strong>:",Gm,Ua,Bm,Ja,vg="We’re getting the same output as before, however this time, the model repeats the answer multiple times until it’s 60 tokens cut-off. This is not surprising as we’ve repeated the system prompt ten times for demonstration purposes and thus cued the model to repeat itself.",$m,Ca,Mg="<strong>Note</strong> that the system prompt should not be repeated ten times in real-world applications - one time is enough!",Zm,La,xg="Let’s measure the peak GPU memory requirement.",Im,za,Hm,Ga,kg="<strong>Output</strong>:",Wm,Ba,Qm,$a,Tg="As we can see the peak GPU memory requirement is now significantly higher than in the beginning, which is largely due to the longer input sequence. Also the generation takes a little over a minute now.",Nm,Za,_g="We call <code>flush()</code> to free GPU memory for our next experiment.",Rm,Ia,qm,Ha,jg=`For comparison, let’s run the same function, but enable Flash Attention instead.
To do so, we convert the model to <a href="https://huggingface.co/docs/optimum/bettertransformer/overview" rel="nofollow">BetterTransformers</a> and by doing so enabling PyTorch’s <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention" rel="nofollow">SDPA self-attention</a> which in turn is based on Flash Attention.`,Xm,Wa,Vm,Qa,Ug="Now we run the exact same code snippet as before and under the hood Transformers will make use of Flash Attention.",Am,Na,Em,Ra,Jg="<strong>Output</strong>:",Sm,qa,Ym,Xa,Cg="We’re getting the exact same result as before, but can observe a very significant speed-up thanks to Flash Attention.",Pm,Va,Lg="Let’s measure the memory consumption one last time.",Fm,Aa,Km,Ea,zg="<strong>Output</strong>:",Dm,Sa,Om,Ya,Gg="And we’re almost back to our original 29GB peak GPU memory from the beginning.",so,Pa,Bg="We can observe that we only use roughly 100MB more GPU memory when passing a very long input sequence with Flash Attention compared to passing a short input sequence as done in the beginning.",to,Fa,ao,Ka,$g='For more information on how to use Flash Attention, please have a look at <a href="https://huggingface.co/docs/transformers/v4.34.0/en/perf_infer_gpu_one#flash-attention-2" rel="nofollow">this doc page</a>.',eo,Da,no,Oa,Zg="So far we have looked into improving computational and memory efficiency by:",lo,se,Ig="<li>Casting the weights to a lower precision format</li> <li>Replacing the self-attention algorithm with a more memory- and compute efficient version</li>",io,te,Hg="Let’s now look into how we can change the architecture of an LLM so that it is most effective and efficient for task that require long text inputs, <em>e.g.</em>:",po,ae,Wg="<li>Retrieval augmented Questions Answering,</li> <li>Summarization,</li> <li>Chat</li>",mo,ee,Qg="Note that <em>chat</em> not only requires the LLM to handle long text inputs, but it also necessitates that the LLM is able to efficiently handle the back-and-forth dialogue between user and assistant (such as ChatGPT).",oo,ne,Ng=`Once trained, the fundamental LLM architecture is difficult to change, so it is important to make considerations about the LLM’s tasks beforehand and accordingly optimize the model’s architecture.
There are two important components of the model architecture that quickly become memory and/or performance bottlenecks for large input sequences.`,ro,le,Rg="<li>The positional embeddings</li> <li>The key-value cache</li>",ho,ie,qg="Let’s go over each component in more detail",co,pe,uo,O,Sc,go,tw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mtext>Softmax</mtext><mo stretchy="false">(</mo><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex"> \\text{Softmax}(\\mathbf{QK}^T) </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1673em;vertical-align:-0.25em;"></span><span class="mord text"><span class="mord">Softmax</span></span><span class="mopen">(</span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',fo,Tn,Xg="“Hello”, “I”, “love”, “you”",Yc,yo,me,Vg='<img src="/blog/assets/163_optimize_llm/self_attn_tokens.png"/>',wo,oe,Ag="Each word token is given a probability mass at which it attends all other word tokens and, therefore is put into relation with all other word tokens. E.g. the word <em>“love”</em> attends to the word <em>“Hello”</em> with 5%, to <em>“I”</em> with 30%, and to itself with 65%.",bo,G,Pc,vo,aw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',Mo,xo,ew='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>O</mi><mo stretchy="false">(</mo><mn>1</mn><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex"> O(1) </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">O</span><span class="mopen">(</span><span class="mord">1</span><span class="mclose">)</span></span></span></span>',ko,_n,Eg="e.g.",Fc,jn,Sg="“Hello I love you”",Kc,Un,Yg="“You love I hello”",Dc,To,re,Pg=`For the LLM to understand sentence order, an additional <em>cue</em> is needed and is usually applied in the form of <em>positional encodings</em> (or also called <em>positional embeddings</em>).
Positional encodings, encode the position of each token into a numerical presentation that the LLM can leverage to better understand sentence order.`,_o,U,Oc,cs,Fg="<em>Attention Is All You Need</em>",su,jo,nw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">P</mi><mo>=</mo><msub><mi mathvariant="bold">p</mi><mn>1</mn></msub><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msub><mi mathvariant="bold">p</mi><mi>N</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{P} = \\mathbf{p}_1, \\ldots, \\mathbf{p}_N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6861em;"></span><span class="mord mathbf">P</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6389em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathbf">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.10903em;">N</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Uo,Jo,lw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">p</mi><mi>i</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{p}_i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6389em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Co,Lo,iw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',zo,Go,pw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mover accent="true"><mi mathvariant="bold">X</mi><mo>^</mo></mover><mo>=</mo><msub><mover accent="true"><mi mathvariant="bold">x</mi><mo>^</mo></mover><mn>1</mn></msub><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msub><mover accent="true"><mi mathvariant="bold">x</mi><mo>^</mo></mover><mi>N</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{\\hat{X}} = \\mathbf{\\hat{x}}_1, \\ldots, \\mathbf{\\hat{x}}_N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.9495em;"></span><span class="mord accent"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9495em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord mathbf">X</span></span><span style="top:-3.2551em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.2875em;"><span class="mord mathbf">^</span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.9023em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord accent"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.7079em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord mathbf">x</span></span><span style="top:-3.0134em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.2875em;"><span class="mord mathbf">^</span></span></span></span></span></span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord accent"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.7079em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord mathbf">x</span></span><span style="top:-3.0134em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.2875em;"><span class="mord mathbf">^</span></span></span></span></span></span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.10903em;">N</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Bo,$o,mw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">x</mi><mn>1</mn></msub><mo>+</mo><msub><mi mathvariant="bold">p</mi><mn>1</mn></msub><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msub><mi mathvariant="bold">x</mi><mi>N</mi></msub><mo>+</mo><msub><mi mathvariant="bold">p</mi><mi>N</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{x}_1 + \\mathbf{p}_1, \\ldots, \\mathbf{x}_N + \\mathbf{p}_N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7333em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathbf">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.7778em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathbf">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.10903em;">N</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6389em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.10903em;">N</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Zo,Io,ss,tu,us,Kg="Devlin et al.",au,Ho,ow='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">P</mi></mrow><annotation encoding="application/x-tex"> \\mathbf{P} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6861em;"></span><span class="mord mathbf">P</span></span></span></span>',Wo,Qo,he,Dg="Sinusoidal and learned position embeddings used to be the predominant methods to encode sentence order into LLMs, but a couple of problems related to these positional encodings were found:",No,ds,Q,eu,Jn,Og="i.e.",nu,Ro,rw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mn>0</mn><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><mi>N</mi></mrow><annotation encoding="application/x-tex"> 0, \\ldots, N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8778em;vertical-align:-0.1944em;"></span><span class="mord">0</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span></span></span></span>',qo,gs,sf="Huang et al.",lu,fs,tf="Su et al.",iu,pu,ce,mu,Xo,hw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>N</mi></mrow><annotation encoding="application/x-tex"> N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span></span></span></span>',Vo,Ao,ue,af="Recently, relative positional embeddings that can tackle the above mentioned problems have become more popular, most notably:",Eo,de,ef='<li><a href="https://arxiv.org/abs/2104.09864" rel="nofollow">Rotary Position Embedding (RoPE)</a></li> <li><a href="https://arxiv.org/abs/2108.12409" rel="nofollow">ALiBi</a></li>',So,A,ou,Cn,nf="RoPE",ru,Ln,lf="ALiBi",hu,Yo,cw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',Po,Fo,T,cu,zn,pf="RoPE",uu,Gn,mf="e.g.",du,Ko,uw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">q</mi><mi>i</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{q}_i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6389em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Do,Oo,dw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">x</mi><mi>j</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{x}_j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7305em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathbf">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span></span></span></span>',sr,tr,gw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>θ</mi><mo>∗</mo><mi>i</mi></mrow><annotation encoding="application/x-tex"> \\theta * i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',ar,er,fw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>θ</mi><mo>∗</mo><mi>j</mi></mrow><annotation encoding="application/x-tex"> \\theta * j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span></span></span>',nr,lr,yw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo separator="true">,</mo><mi>j</mi></mrow><annotation encoding="application/x-tex"> i, j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord mathnormal">i</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span></span></span>',ir,pr,Bn,mr,ww='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><msubsup><mover accent="true"><mi mathvariant="bold">q</mi><mo>^</mo></mover><mi>i</mi><mi>T</mi></msubsup><msub><mover accent="true"><mi mathvariant="bold">x</mi><mo>^</mo></mover><mi>j</mi></msub><mo>=</mo><msubsup><mi mathvariant="bold">q</mi><mi>i</mi><mi>T</mi></msubsup><msub><mi mathvariant="bold">R</mi><mrow><mi>θ</mi><mo separator="true">,</mo><mi>i</mi><mo>−</mo><mi>j</mi></mrow></msub><msub><mi mathvariant="bold">x</mi><mi>j</mi></msub><mi mathvariant="normal">.</mi></mrow><annotation encoding="application/x-tex"> \\mathbf{\\hat{q}}_i^T \\mathbf{\\hat{x}}_j = \\mathbf{{q}}_i^T \\mathbf{R}_{\\theta, i -j} \\mathbf{{x}}_j. </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.2252em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord accent"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.7079em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord mathbf">q</span></span><span style="top:-3.0134em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.2875em;"><span class="mord mathbf">^</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.1944em;"><span></span></span></span></span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.9391em;"><span style="top:-2.453em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span><span style="top:-3.1608em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span><span class="mord"><span class="mord accent"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.7079em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord mathbf">x</span></span><span style="top:-3.0134em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.2875em;"><span class="mord mathbf">^</span></span></span></span></span></span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.1774em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">q</span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8913em;"><span style="top:-2.453em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span><span class="mord"><span class="mord mathbf">R</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span><span class="mpunct mtight">,</span><span class="mord mathnormal mtight">i</span><span class="mbin mtight">−</span><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mord"><span class="mord"><span class="mord mathbf">x</span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mord">.</span></span></span></span></span>',or,F,rr,bw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">R</mi><mrow><mi>θ</mi><mo separator="true">,</mo><mi>i</mi><mo>−</mo><mi>j</mi></mrow></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{R}_{\\theta, i - j} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.9722em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathbf">R</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span><span class="mpunct mtight">,</span><span class="mord mathnormal mtight">i</span><span class="mbin mtight">−</span><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span></span></span></span>',hr,cr,vw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>θ</mi></mrow><annotation encoding="application/x-tex"> \\theta </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span></span></span></span>',ur,$n,of="not",gu,dr,Zn,L,fu,gr,Mw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">q</mi><mi>i</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{q}_i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6389em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',fr,yr,xw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">q</mi><mi>j</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{q}_j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7305em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathbf">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span></span></span></span>',wr,br,kw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo mathvariant="normal">≠</mo><mi>j</mi></mrow><annotation encoding="application/x-tex"> i \\ne j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel"><span class="mrel"><span class="mord vbox"><span class="thinbox"><span class="rlap"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="inner"><span class="mord"><span class="mrel"></span></span></span><span class="fix"></span></span></span></span></span><span class="mrel">=</span></span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span></span></span>',vr,Mr,Tw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo>−</mo><mi>j</mi></mrow><annotation encoding="application/x-tex"> i - j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7429em;vertical-align:-0.0833em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span></span></span>',xr,kr,_w='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',Tr,_r,jw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>j</mi></mrow><annotation encoding="application/x-tex"> j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span></span></span>',jr,Ur,ge,rf="<em>RoPE</em> is used in multiple of today’s most important LLMs, such as:",Jr,fe,hf='<li><a href="https://huggingface.co/tiiuae/falcon-40b" rel="nofollow"><strong>Falcon</strong></a></li> <li><a href="https://arxiv.org/abs/2302.13971" rel="nofollow"><strong>Llama</strong></a></li> <li><a href="https://arxiv.org/abs/2204.02311" rel="nofollow"><strong>PaLM</strong></a></li>',Cr,E,yu,In,cf="ALiBi",wu,Hn,uf="m",bu,Lr,Uw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',zr,Gr,ye,df='<img src="/blog/assets/163_optimize_llm/alibi.png"/>',Br,we,gf='As shown in the <a href="https://arxiv.org/abs/2108.12409" rel="nofollow">ALiBi</a> paper, this simple relative positional encoding allows the model to retain a high performance even at very long text input sequences.',$r,be,ff="<em>ALiBi</em> is used in multiple of today’s most important LLMs, such as:",Zr,ve,yf='<li><a href="https://huggingface.co/mosaicml/mpt-30b" rel="nofollow"><strong>MPT</strong></a></li> <li><a href="https://huggingface.co/bigscience/bloom" rel="nofollow"><strong>BLOOM</strong></a></li>',Ir,x,vu,Wn,wf="RoPE",Mu,Qn,bf="ALiBi",xu,Nn,vf="ALiBi",ku,Rn,Mf="RoPE",Tu,qn,xf="RoPE",_u,Hr,Jw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>θ</mi></mrow><annotation encoding="application/x-tex"> \\theta </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span></span></span></span>',Wr,Xn,kf="c.f",ju,ys,Tf="Press et al.",Uu,Qr,Cw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>θ</mi></mrow><annotation encoding="application/x-tex"> \\theta </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span></span></span></span>',Nr,Vn,_f="RoPE",Ju,ws,jf="here",Cu,Rr,bs,An,Uf="Both RoPE and ALiBi are relative positional embeddings that are <em>not</em> learned during training, but instead are based on the following intuitions:",Lu,ms,Me,zu,qr,Lw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>Q</mi><msup><mi>K</mi><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> QK^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0358em;vertical-align:-0.1944em;"></span><span class="mord mathnormal">Q</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.07153em;">K</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8413em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',Xr,Gu,En,Jf="The LLM should be incentivized to learn a constant <em>relative</em> distance positional encodings have to each other",Bu,Sn,Cf="The further text input tokens are from each other, the lower the probability of their query-value probability. Both RoPE and ALiBi lower the query-key probability of tokens far away from each other. RoPE by decreasing their vector product by increasing the angle between the query-key vectors. ALiBi by adding large negative numbers to the vector product",Vr,S,$u,Ar,zw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>N</mi><mn>1</mn></msub><mo>=</mo><mn>2048</mn></mrow><annotation encoding="application/x-tex"> N_1 = 2048 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8333em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:-0.109em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">2048</span></span></span></span>',Er,Sr,Gw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>N</mi><mn>1</mn></msub></mrow><annotation encoding="application/x-tex"> N_1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8333em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:-0.109em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Yr,Pr,Bw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>N</mi><mn>2</mn></msub><mo>=</mo><mn>8192</mn><mo>&gt;</mo><msub><mi>N</mi><mn>1</mn></msub></mrow><annotation encoding="application/x-tex"> N_2 = 8192 &gt; N_1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8333em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:-0.109em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6835em;vertical-align:-0.0391em;"></span><span class="mord">8192</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">&gt;</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.8333em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:-0.109em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Fr,Kr,xe,Dr,ke,Lf="Auto-regressive text generation with LLMs works by iteratively putting in an input sequence, sampling the next token, appending the next token to the input sequence, and continuing to do so until the LLM produces a token that signifies that the generation has finished.",Or,Te,zf='Please have a look at <a href="https://huggingface.co/docs/transformers/llm_tutorial#generate-text" rel="nofollow">Transformer’s Generate Text Tutorial</a> to get a more visual explanation of how auto-regressive generation works.',sh,_e,Gf="Let’s run a quick code snippet to show how auto-regressive works in practice. We will simply take the most likely next token via <code>torch.argmax</code>.",th,je,ah,Ue,Bf="<strong>Output</strong>:",eh,Je,nh,Ce,$f="As we can see every time we increase the text input tokens by the just sampled token.",lh,Le,Zf='With very few exceptions, LLMs are trained using the <a href="https://huggingface.co/docs/transformers/tasks/language_modeling#causal-language-modeling" rel="nofollow">causal language modeling objective</a> and therefore mask the upper triangle matrix of the attention score - this is why in the two diagrams above the attention scores are left blank (<em>a.k.a</em> have 0 probability). For a quick recap on causal language modeling you can refer to the <a href="https://jalammar.github.io/illustrated-gpt2/#part-2-illustrated-self-attention" rel="nofollow"><em>Illustrated Self Attention blog</em></a>.',ih,J,Zu,Yn,If="never",Iu,ph,$w='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">q</mi><mi>i</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{q}_i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6389em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',mh,oh,Zw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">k</mi><mi>j</mi></msub><mo separator="true">,</mo><msub><mi mathvariant="bold">v</mi><mi>j</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{k}_j, \\mathbf{v}_j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.9805em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathbf">k</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathbf" style="margin-right:0.01597em;">v</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.016em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span></span></span></span>',rh,hh,Iw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>j</mi><mo>&gt;</mo><mi>i</mi></mrow><annotation encoding="application/x-tex"> j &gt; i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">&gt;</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',ch,uh,Hw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">q</mi><mi>i</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{q}_i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6389em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',dh,gh,Ww='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">k</mi><mrow><mi>m</mi><mo>&lt;</mo><mi>i</mi></mrow></msub><mo separator="true">,</mo><msub><mi mathvariant="bold">v</mi><mrow><mi>m</mi><mo>&lt;</mo><mi>i</mi></mrow></msub><mtext> , for </mtext><mi>m</mi><mo>∈</mo><mo stretchy="false">{</mo><mn>0</mn><mo separator="true">,</mo><mo>…</mo><mi>i</mi><mo>−</mo><mn>1</mn><mo stretchy="false">}</mo></mrow><annotation encoding="application/x-tex"> \\mathbf{k}_{m &lt; i}, \\mathbf{v}_{m &lt; i} \\text{ , for } m \\in \\{0, \\ldots i - 1\\} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">k</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">m</span><span class="mrel mtight">&lt;</span><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.1774em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathbf" style="margin-right:0.01597em;">v</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.016em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">m</span><span class="mrel mtight">&lt;</span><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.1774em;"><span></span></span></span></span></span></span><span class="mord text"><span class="mord"> , for </span></span><span class="mord mathnormal">m</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">∈</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">{</span><span class="mord">0</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord">1</span><span class="mclose">}</span></span></span></span>',fh,yh,ze,Hf=`In the following, we will tell the LLM to make use of the key-value cache by retrieving and forwarding it for each forward pass.
In Transformers, we can retrieve the key-value cache by passing the <code>use_cache</code> flag to the <code>forward</code> call and can then pass it with the current token.`,wh,Ge,bh,Be,Wf="<strong>Output</strong>:",vh,$e,Mh,Ze,Qf="As one can see, when using the key-value cache the text input tokens are <em>not</em> increased in length, but remain a single input vector. The length of the key-value cache on the other hand is increased by one at every decoding step.",xh,Pn,N,Hu,kh,Qw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',Th,_h,Nw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">q</mi><mi>c</mi></msub><msup><mi mathvariant="bold">K</mi><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{q}_c\\mathbf{K}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0358em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">c</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord"><span class="mord mathbf">K</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8413em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',jh,Uh,Rw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">q</mi><mi>c</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{q}_c </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6389em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">c</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Jh,Fn,Nf="always",Wu,Ch,Ie,Rf="Using the key-value cache has two advantages:",Lh,vs,He,Qu,zh,qw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',Gh,Nu,Kn,qf="The maximum required memory is not increased quadratically with the number of generated tokens, but only increases linearly.",Bh,We,Xf='<p>One should <em>always</em> make use of the key-value cache as it leads to identical results and a significant speed-up for longer input sequences. Transformers has the key-value cache enabled by default when making use of the text pipeline or the <a href="https://huggingface.co/docs/transformers/main_classes/text_generation" rel="nofollow"><code>generate</code> method</a>.</p>',$h,Qe,Vf="Note that the key-value cache is especially useful for applications such as chat where multiple passes of auto-regressive decoding are required. Let’s look at an example.",Zh,Ne,Ih,Re,Af="In this chat, the LLM runs auto-regressive decoding twice:",Hh,qe,Ef='<li><ol><li>The first time, the key-value cache is empty and the input prompt is <code>&quot;User: How many people live in France?&quot;</code> and the model auto-regressively generates the text <code>&quot;Roughly 75 million people live in France&quot;</code> while increasing the key-value cache at every decoding step.</li></ol></li> <li><ol start="2"><li>The second time the input prompt is <code>&quot;User: How many people live in France? \\n Assistant: Roughly 75 million people live in France \\n User: And how many in Germany?&quot;</code>. Thanks to the cache, all key-value vectors for the first two sentences are already computed. Therefore the input prompt only consists of <code>&quot;User: And how many in Germany?&quot;</code>. While processing the shortened input prompt, it’s computed key-value vectors are concatenated to the key-value cache of the first decoding. The second Assistant’s answer <code>&quot;Germany has ca. 81 million inhabitants&quot;</code> is then auto-regressively generated with the key-value cache consisting of encoded key-value vectors of <code>&quot;User: How many people live in France? \\n Assistant: Roughly 75 million people live in France \\n User: And how many are in Germany?&quot;</code>.</li></ol></li>',Wh,Xe,Sf="Two things should be noted here:",Qh,Ve,Yf="<li>Keeping all the context is crucial for LLMs deployed in chat so that the LLM understands all the previous context of the conversation. E.g. for the example above the LLM needs to understand that the user refers to the population when asking <code>&quot;And how many are in Germany&quot;</code>.</li> <li>The key-value cache is extremely useful for chat as it allows us to continuously grow the encoded chat history instead of having to re-encode the chat history again from scratch (as e.g. would be the case when using an encoder-decoder architecture).</li>",Nh,ts,Ru,Rh,Xw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',qh,Xh,Vw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">x</mi><mi>i</mi></msub><mtext>, for </mtext><mi>i</mi><mo>∈</mo><mo stretchy="false">{</mo><mn>1</mn><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><mi>c</mi><mo>−</mo><mn>1</mn><mo stretchy="false">}</mo></mrow><annotation encoding="application/x-tex"> \\mathbf{x}_i \\text{, for } i \\in \\{1, \\ldots, c - 1\\} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord text"><span class="mord">, for </span></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">∈</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">{</span><span class="mord">1</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal">c</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord">1</span><span class="mclose">}</span></span></span></span>',Vh,Ah,Ae,Pf=`Let’s compute the number of float values that need to be stored in the key-value cache for the LLM <code>bigcode/octocoder</code> that we used before.
The number of float values amounts to two times the sequence length times the number of attention heads times the attention head dimension and times the number of layers.
Computing this for our LLM at a hypothetical input sequence length of 16000 gives:`,Eh,Ee,Sh,Se,Ff="<strong>Output</strong>:",Yh,Ye,Ph,Pe,Kf=`Roughly 8 billion float values! Storing 8 billion float values in <code>float16</code> precision requires around 15 GB of RAM which is circa half as much as the model weights themselves!
Researchers have proposed two methods that allow to significantly reduce the memory cost of storing the key-value cache:`,Fh,Fe,Df='<li><a href="https://arxiv.org/abs/1911.02150" rel="nofollow">Multi-Query-Attention (MQA)</a></li>',Kh,Ke,Of="Multi-Query-Attention was proposed in Noam Shazeer’s <em>Fast Transformer Decoding: One Write-Head is All You Need</em> paper. As the title says, Noam found out that instead of using <code>n_head</code> key-value projections weights, one can use a single head-value projection weight pair that is shared across all attention heads without that the model’s performance significantly degrades.",Dh,Dn,os,qu,Oh,Aw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">k</mi><mi>i</mi></msub><mo separator="true">,</mo><msub><mi mathvariant="bold">v</mi><mi>i</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{k}_i, \\mathbf{v}_i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">k</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathbf" style="margin-right:0.01597em;">v</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.016em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',sc,On,sy="n_head",Xu,tc,De,ty="As most LLMs use between 20 and 100 attention heads, MQA significantly reduces the memory consumption of the key-value cache. For the LLM used in this notebook we could therefore reduce the required memory consumption from 15 GB to less than 400 MB at an input sequence length of 16000.",ac,as,Vu,ec,Ew='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">q</mi><mi>c</mi></msub><msup><mi mathvariant="bold">K</mi><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{q}_c\\mathbf{K}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0358em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">c</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord"><span class="mord mathbf">K</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8413em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',nc,Ms,ay="Noam’s paper",Au,lc,xs,Eu,ic,Sw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',pc,mc,Oe,ey="MQA has seen wide adoption by the community and is now used by many of the most popular LLMs:",oc,sn,ny='<li><a href="https://huggingface.co/tiiuae/falcon-40b" rel="nofollow"><strong>Falcon</strong></a></li> <li><a href="https://arxiv.org/abs/2204.02311" rel="nofollow"><strong>PaLM</strong></a></li> <li><a href="https://huggingface.co/mosaicml/mpt-30b" rel="nofollow"><strong>MPT</strong></a></li> <li><a href="https://huggingface.co/bigscience/bloom" rel="nofollow"><strong>BLOOM</strong></a></li>',rc,tn,ly="Also, the checkpoint used in this notebook - <code>bigcode/octocoder</code> - makes use of MQA.",hc,ks,iy='<li><a href="https://arxiv.org/abs/2305.13245" rel="nofollow">Grouped-Query-Attention (GQA)</a></li>',cc,an,py="Grouped-Query-Attention, as proposed by Ainslie et al. from Google, found that using MQA can often lead to quality degradation compared to using vanilla multi-key-value head projections. The paper argues that more model performance can be kept by less drastically reducing the number of query head projection weights. Instead of using just a single key-value projection weight, <code>n &lt; n_head</code> key-value projection weights should be used. By choosing <code>n</code> to a significantly smaller value than <code>n_head</code>, such as 2,4 or 8 almost all of the memory and speed gains from MQA can be kept while sacrificing less model capacity and thus arguably less performance.",uc,en,my="Moreover, the authors of GQA found out that existing model checkpoints can be <em>uptrained</em> to have a GQA architecture with as little as 5% of the original pre-training compute. While 5% of the original pre-training compute can still be a massive amount, GQA <em>uptraining</em> allows existing checkpoints to be useful for longer input sequences.",dc,nn,oy=`GQA was only recently proposed which is why there is less adoption at the time of writing this notebook.
The most notable application of GQA is <a href="https://huggingface.co/meta-llama/Llama-2-70b-hf" rel="nofollow">Llama-v2</a>.`,gc,ln,ry="<p>As a conclusion, it is strongly recommended to make use of either GQA or MQA if the LLM is deployed with auto-regressive decoding and is required to handle large input sequences as is the case for example for chat.</p>",fc,pn,yc,mn,hy='The research community is constantly coming up with new, nifty ways to speed up inference time for ever-larger LLMs. As an example, one such promising research direction is <a href="https://arxiv.org/abs/2211.17192" rel="nofollow">speculative decoding</a> where “easy tokens” are generated by smaller, faster language models and only “hard tokens” are generated by the LLM itself. Going into more detail is out of the scope of this notebook, but can be read upon in this <a href="https://huggingface.co/blog/assisted-generation" rel="nofollow">nice blog post</a>.',wc,on,cy=`The reason massive LLMs such as GPT3/4, Llama-2-70b, Claude, PaLM can run so quickly in chat-interfaces such as <a href="https://huggingface.co/chat/" rel="nofollow">Hugging Face Chat</a> or ChatGPT is to a big part thanks to the above-mentioned improvements in precision, algorithms, and architecture.
Going forward, accelerators such as GPUs, TPUs, etc… will only get faster and allow for more memory, but one should nevertheless always make sure to use the best available algorithms and architectures to get the most bang for your buck 🤗`,bc,rl,vc;return Ls=new hn({props:{title:"Optimizing LLMs for Speed and Memory",local:"optimizing-llms-for-speed-and-memory",headingTag:"h1"}}),zs=new sb({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/llm_tutorial_optimization.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/llm_tutorial_optimization.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/llm_tutorial_optimization.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/llm_tutorial_optimization.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/llm_tutorial_optimization.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/llm_tutorial_optimization.ipynb"}]}}),Ws=new hn({props:{title:"1. Lower Precision",local:"1-lower-precision",headingTag:"h2"}}),Ks=new M({props:{code:"IXBpcCUyMGluc3RhbGwlMjB0cmFuc2Zvcm1lcnMlMjBhY2NlbGVyYXRlJTIwYml0c2FuZGJ5dGVzJTIwb3B0aW11bQ==",highlighted:"!pip install transformers accelerate bitsandbytes optimum",wrap:!1}}),Ds=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmlnc2NpZW5jZSUyRmJsb29tJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBwYWRfdG9rZW5faWQlM0QwKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloom&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, pad_token_id=<span class="hljs-number">0</span>)`,wrap:!1}}),et=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdjb2RlJTJGb2N0b2NvZGVyJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTIwcGFkX3Rva2VuX2lkJTNEMCklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiaWdjb2RlJTJGb2N0b2NvZGVyJTIyKSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, pipeline
<span class="hljs-keyword">import</span> torch

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigcode/octocoder&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>, pad_token_id=<span class="hljs-number">0</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigcode/octocoder&quot;</span>)

pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)`,wrap:!1}}),nt=new M({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyUXVlc3Rpb24lM0ElMjBQbGVhc2UlMjB3cml0ZSUyMGElMjBmdW5jdGlvbiUyMGluJTIwUHl0aG9uJTIwdGhhdCUyMHRyYW5zZm9ybXMlMjBieXRlcyUyMHRvJTIwR2lnYSUyMGJ5dGVzLiU1Q24lNUNuQW5zd2VyJTNBJTIyJTBBJTBBcmVzdWx0JTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDYwKSU1QjAlNUQlNUIlMjJnZW5lcmF0ZWRfdGV4dCUyMiU1RCU1Qmxlbihwcm9tcHQpJTNBJTVEJTBBcmVzdWx0",highlighted:`prompt = <span class="hljs-string">&quot;Question: Please write a function in Python that transforms bytes to Giga bytes.\\n\\nAnswer:&quot;</span>

result = pipe(prompt, max_new_tokens=<span class="hljs-number">60</span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>][<span class="hljs-built_in">len</span>(prompt):]
result`,wrap:!1}}),it=new M({props:{code:"SGVyZSUyMGlzJTIwYSUyMFB5dGhvbiUyMGZ1bmN0aW9uJTIwdGhhdCUyMHRyYW5zZm9ybXMlMjBieXRlcyUyMHRvJTIwR2lnYSUyMGJ5dGVzJTNBJTVDbiU1Q24lNjAlNjAlNjBweXRob24lNUNuZGVmJTIwYnl0ZXNfdG9fZ2lnYV9ieXRlcyhieXRlcyklM0ElNUNuJTIwJTIwJTIwJTIwcmV0dXJuJTIwYnl0ZXMlMjAlMkYlMjAxMDI0JTIwJTJGJTIwMTAyNCUyMCUyRiUyMDEwMjQlNUNuJTYwJTYwJTYwJTVDbiU1Q25UaGlzJTIwZnVuY3Rpb24lMjB0YWtlcyUyMGElMjBzaW5nbGU=",highlighted:'Here <span class="hljs-keyword">is</span> a Python <span class="hljs-keyword">function</span> <span class="hljs-literal">that</span> transforms bytes <span class="hljs-keyword">to</span> Giga bytes:<span class="hljs-string">\\n\\n```python\\ndef</span> bytes_to_giga_bytes(bytes):<span class="hljs-string">\\n</span>    <span class="hljs-keyword">return</span> bytes / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span><span class="hljs-string">\\n```\\n\\nThis</span> <span class="hljs-keyword">function</span> takes a single',wrap:!1}}),mt=new M({props:{code:"ZGVmJTIwYnl0ZXNfdG9fZ2lnYV9ieXRlcyhieXRlcyklM0ElMEElMjAlMjByZXR1cm4lMjBieXRlcyUyMCUyRiUyMDEwMjQlMjAlMkYlMjAxMDI0JTIwJTJGJTIwMTAyNA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">bytes_to_giga_bytes</span>(<span class="hljs-params"><span class="hljs-built_in">bytes</span></span>):
  <span class="hljs-keyword">return</span> <span class="hljs-built_in">bytes</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span>`,wrap:!1}}),rt=new M({props:{code:"Ynl0ZXNfdG9fZ2lnYV9ieXRlcyh0b3JjaC5jdWRhLm1heF9tZW1vcnlfYWxsb2NhdGVkKCkp",highlighted:"bytes_to_giga_bytes(torch.cuda.max_memory_allocated())",wrap:!1}}),ct=new M({props:{code:"MjkuMDI2MDY0ODcyNzQxNw==",highlighted:"29.0260648727417",wrap:!1}}),yt=new M({props:{code:"ZGVsJTIwcGlwZSUwQWRlbCUyMG1vZGVsJTBBJTBBaW1wb3J0JTIwZ2MlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRlZiUyMGZsdXNoKCklM0ElMEElMjAlMjBnYy5jb2xsZWN0KCklMEElMjAlMjB0b3JjaC5jdWRhLmVtcHR5X2NhY2hlKCklMEElMjAlMjB0b3JjaC5jdWRhLnJlc2V0X3BlYWtfbWVtb3J5X3N0YXRzKCk=",highlighted:`<span class="hljs-keyword">del</span> pipe
<span class="hljs-keyword">del</span> model

<span class="hljs-keyword">import</span> gc
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">def</span> <span class="hljs-title function_">flush</span>():
  gc.collect()
  torch.cuda.empty_cache()
  torch.cuda.reset_peak_memory_stats()`,wrap:!1}}),bt=new M({props:{code:"Zmx1c2goKQ==",highlighted:"flush()",wrap:!1}}),Mt=new M({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjByZWxlYXNlX21lbW9yeSUwQSUyMyUyMC4uLiUwQSUwQXJlbGVhc2VfbWVtb3J5KG1vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> release_memory
<span class="hljs-comment"># ...</span>

release_memory(model)`,wrap:!1}}),Ct=new M({props:{code:"IXBpcCUyMGluc3RhbGwlMjBiaXRzYW5kYnl0ZXM=",highlighted:"!pip install bitsandbytes",wrap:!1}}),zt=new M({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmlnY29kZSUyRm9jdG9jb2RlciUyMiUyQyUyMGxvYWRfaW5fOGJpdCUzRFRydWUlMkMlMjBwYWRfdG9rZW5faWQlM0QwKQ==",highlighted:'model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigcode/octocoder&quot;</span>, load_in_8bit=<span class="hljs-literal">True</span>, pad_token_id=<span class="hljs-number">0</span>)',wrap:!1}}),Bt=new M({props:{code:"cGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBcmVzdWx0JTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDYwKSU1QjAlNUQlNUIlMjJnZW5lcmF0ZWRfdGV4dCUyMiU1RCU1Qmxlbihwcm9tcHQpJTNBJTVEJTBBcmVzdWx0",highlighted:`pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)

result = pipe(prompt, max_new_tokens=<span class="hljs-number">60</span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>][<span class="hljs-built_in">len</span>(prompt):]
result`,wrap:!1}}),Zt=new M({props:{code:"SGVyZSUyMGlzJTIwYSUyMFB5dGhvbiUyMGZ1bmN0aW9uJTIwdGhhdCUyMHRyYW5zZm9ybXMlMjBieXRlcyUyMHRvJTIwR2lnYSUyMGJ5dGVzJTNBJTVDbiU1Q24lNjAlNjAlNjBweXRob24lNUNuZGVmJTIwYnl0ZXNfdG9fZ2lnYV9ieXRlcyhieXRlcyklM0ElNUNuJTIwJTIwJTIwJTIwcmV0dXJuJTIwYnl0ZXMlMjAlMkYlMjAxMDI0JTIwJTJGJTIwMTAyNCUyMCUyRiUyMDEwMjQlNUNuJTYwJTYwJTYwJTVDbiU1Q25UaGlzJTIwZnVuY3Rpb24lMjB0YWtlcyUyMGElMjBzaW5nbGU=",highlighted:'Here <span class="hljs-keyword">is</span> a Python <span class="hljs-keyword">function</span> <span class="hljs-literal">that</span> transforms bytes <span class="hljs-keyword">to</span> Giga bytes:<span class="hljs-string">\\n\\n```python\\ndef</span> bytes_to_giga_bytes(bytes):<span class="hljs-string">\\n</span>    <span class="hljs-keyword">return</span> bytes / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span><span class="hljs-string">\\n```\\n\\nThis</span> <span class="hljs-keyword">function</span> takes a single',wrap:!1}}),Ht=new M({props:{code:"Ynl0ZXNfdG9fZ2lnYV9ieXRlcyh0b3JjaC5jdWRhLm1heF9tZW1vcnlfYWxsb2NhdGVkKCkp",highlighted:"bytes_to_giga_bytes(torch.cuda.max_memory_allocated())",wrap:!1}}),Qt=new M({props:{code:"MTUuMjE5MjM0NDY2NTUyNzM0",highlighted:'<span class="hljs-attribute">15</span>.<span class="hljs-number">219234466552734</span>',wrap:!1}}),qt=new M({props:{code:"ZGVsJTIwbW9kZWwlMEFkZWwlMjBwaXBl",highlighted:`<span class="hljs-keyword">del</span> model
<span class="hljs-keyword">del</span> pipe`,wrap:!1}}),Xt=new M({props:{code:"Zmx1c2goKQ==",highlighted:"flush()",wrap:!1}}),At=new M({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmlnY29kZSUyRm9jdG9jb2RlciUyMiUyQyUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUlMkMlMjBwYWRfdG9rZW5faWQlM0QwKSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXJlc3VsdCUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbWF4X25ld190b2tlbnMlM0Q2MCklNUIwJTVEJTVCJTIyZ2VuZXJhdGVkX3RleHQlMjIlNUQlNUJsZW4ocHJvbXB0KSUzQSU1RCUwQXJlc3VsdA==",highlighted:`model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigcode/octocoder&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>, low_cpu_mem_usage=<span class="hljs-literal">True</span>, pad_token_id=<span class="hljs-number">0</span>)

pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)

result = pipe(prompt, max_new_tokens=<span class="hljs-number">60</span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>][<span class="hljs-built_in">len</span>(prompt):]
result`,wrap:!1}}),St=new M({props:{code:"SGVyZSUyMGlzJTIwYSUyMFB5dGhvbiUyMGZ1bmN0aW9uJTIwdGhhdCUyMHRyYW5zZm9ybXMlMjBieXRlcyUyMHRvJTIwR2lnYSUyMGJ5dGVzJTNBJTVDbiU1Q24lNjAlNjAlNjAlNUNuZGVmJTIwYnl0ZXNfdG9fZ2lnYWJ5dGVzKGJ5dGVzKSUzQSU1Q24lMjAlMjAlMjAlMjByZXR1cm4lMjBieXRlcyUyMCUyRiUyMDEwMjQlMjAlMkYlMjAxMDI0JTIwJTJGJTIwMTAyNCU1Q24lNjAlNjAlNjAlNUNuJTVDblRoaXMlMjBmdW5jdGlvbiUyMHRha2VzJTIwYSUyMHNpbmdsZSUyMGFyZ3VtZW50",highlighted:'Here <span class="hljs-keyword">is</span> a Python <span class="hljs-keyword">function</span> <span class="hljs-literal">that</span> transforms bytes <span class="hljs-keyword">to</span> Giga bytes:<span class="hljs-string">\\n\\n```\\ndef</span> bytes_to_gigabytes(bytes):<span class="hljs-string">\\n</span>    <span class="hljs-keyword">return</span> bytes / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span><span class="hljs-string">\\n```\\n\\nThis</span> <span class="hljs-keyword">function</span> takes a single argument',wrap:!1}}),Pt=new M({props:{code:"Ynl0ZXNfdG9fZ2lnYV9ieXRlcyh0b3JjaC5jdWRhLm1heF9tZW1vcnlfYWxsb2NhdGVkKCkp",highlighted:"bytes_to_giga_bytes(torch.cuda.max_memory_allocated())",wrap:!1}}),Kt=new M({props:{code:"OS41NDM1NzQzMzMxOTA5MTg=",highlighted:'<span class="hljs-attribute">9</span>.<span class="hljs-number">543574333190918</span>',wrap:!1}}),sa=new M({props:{code:"ZGVsJTIwbW9kZWwlMEFkZWwlMjBwaXBl",highlighted:`<span class="hljs-keyword">del</span> model
<span class="hljs-keyword">del</span> pipe`,wrap:!1}}),ta=new M({props:{code:"Zmx1c2goKQ==",highlighted:"flush()",wrap:!1}}),ma=new hn({props:{title:"2. Flash Attention",local:"2-flash-attention",headingTag:"h1"}}),ba=new M({props:{code:"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",highlighted:`system_prompt = <span class="hljs-string">&quot;&quot;&quot;Below are a series of dialogues between various people and an AI technical assistant.
The assistant tries to be helpful, polite, honest, sophisticated, emotionally aware, and humble but knowledgeable.
The assistant is happy to help with code questions and will do their best to understand exactly what is needed.
It also tries to avoid giving false or misleading information, and it caveats when it isn&#x27;t entirely sure about the right answer.
That said, the assistant is practical really does its best, and doesn&#x27;t let caution get too much in the way of being useful.

The Starcoder models are a series of 15.5B parameter models trained on 80+ programming languages from The Stack (v1.2) (excluding opt-out requests).
The model uses Multi Query Attention, was trained using the Fill-in-the-Middle objective, and with 8,192 tokens context window for a trillion tokens of heavily deduplicated data.

-----

Question: Write a function that takes two lists and returns a list that has alternating elements from each input list.

Answer: Sure. Here is a function that does that.

def alternating(list1, list2):
   results = []
   for i in range(len(list1)):
       results.append(list1[i])
       results.append(list2[i])
   return results

Question: Can you write some test cases for this function?

Answer: Sure, here are some tests.

assert alternating([10, 20, 30], [1, 2, 3]) == [10, 1, 20, 2, 30, 3]
assert alternating([True, False], [4, 5]) == [True, 4, False, 5]
assert alternating([], []) == []

Question: Modify the function so that it returns all input elements when the lists have uneven length. The elements from the longer list should be at the end.

Answer: Here is the modified function.

def alternating(list1, list2):
   results = []
   for i in range(min(len(list1), len(list2))):
       results.append(list1[i])
       results.append(list2[i])
   if len(list1) &gt; len(list2):
       results.extend(list1[i+1:])
   else:
       results.extend(list2[i+1:])
   return results

-----
&quot;&quot;&quot;</span>`,wrap:!1}}),Ma=new M({props:{code:"bG9uZ19wcm9tcHQlMjAlM0QlMjAxMCUyMColMjBzeXN0ZW1fcHJvbXB0JTIwJTJCJTIwcHJvbXB0",highlighted:'long_prompt = <span class="hljs-number">10</span> * system_prompt + prompt',wrap:!1}}),ka=new M({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmlnY29kZSUyRm9jdG9jb2RlciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiaWdjb2RlJTJGb2N0b2NvZGVyJTIyKSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKQ==",highlighted:`model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigcode/octocoder&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigcode/octocoder&quot;</span>)

pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)`,wrap:!1}}),_a=new M({props:{code:"aW1wb3J0JTIwdGltZSUwQSUwQXN0YXJ0X3RpbWUlMjAlM0QlMjB0aW1lLnRpbWUoKSUwQXJlc3VsdCUyMCUzRCUyMHBpcGUobG9uZ19wcm9tcHQlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDYwKSU1QjAlNUQlNUIlMjJnZW5lcmF0ZWRfdGV4dCUyMiU1RCU1Qmxlbihsb25nX3Byb21wdCklM0ElNUQlMEElMEFwcmludChmJTIyR2VuZXJhdGVkJTIwaW4lMjAlN0J0aW1lLnRpbWUoKSUyMC0lMjBzdGFydF90aW1lJTdEJTIwc2Vjb25kcy4lMjIpJTBBcmVzdWx0",highlighted:`<span class="hljs-keyword">import</span> time

start_time = time.time()
result = pipe(long_prompt, max_new_tokens=<span class="hljs-number">60</span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>][<span class="hljs-built_in">len</span>(long_prompt):]

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated in <span class="hljs-subst">{time.time() - start_time}</span> seconds.&quot;</span>)
result`,wrap:!1}}),Ua=new M({props:{code:"R2VuZXJhdGVkJTIwaW4lMjAxMC45Njg1NDAxOTE2NTAzOSUyMHNlY29uZHMuJTBBU3VyZS4lMjBIZXJlJTIwaXMlMjBhJTIwZnVuY3Rpb24lMjB0aGF0JTIwZG9lcyUyMHRoYXQuJTVDbiU1Q25kZWYlMjBieXRlc190b19naWdhKGJ5dGVzKSUzQSU1Q24lMjAlMjAlMjByZXR1cm4lMjBieXRlcyUyMCUyRiUyMDEwMjQlMjAlMkYlMjAxMDI0JTIwJTJGJTIwMTAyNCU1Q24lNUNuQW5zd2VyJTNBJTIwU3VyZS4lMjBIZXJlJTIwaXMlMjBhJTIwZnVuY3Rpb24lMjB0aGF0JTIwZG9lcyUyMHRoYXQuJTVDbiU1Q25kZWY=",highlighted:`Generated <span class="hljs-keyword">in</span> <span class="hljs-number">10.96854019165039</span> seconds.
Sure. Here <span class="hljs-keyword">is</span> a <span class="hljs-keyword">function</span> <span class="hljs-literal">that</span> does <span class="hljs-literal">that</span>.<span class="hljs-string">\\n\\ndef</span> bytes_to_giga(bytes):<span class="hljs-string">\\n</span>   <span class="hljs-keyword">return</span> bytes / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span><span class="hljs-string">\\n\\nAnswer:</span> Sure. Here <span class="hljs-keyword">is</span> a <span class="hljs-keyword">function</span> <span class="hljs-literal">that</span> does <span class="hljs-literal">that</span>.<span class="hljs-string">\\n\\ndef</span>`,wrap:!1}}),za=new M({props:{code:"Ynl0ZXNfdG9fZ2lnYV9ieXRlcyh0b3JjaC5jdWRhLm1heF9tZW1vcnlfYWxsb2NhdGVkKCkp",highlighted:"bytes_to_giga_bytes(torch.cuda.max_memory_allocated())",wrap:!1}}),Ba=new M({props:{code:"MzcuNjY4MTkzMzQwMzAxNTE0",highlighted:"37.668193340301514",wrap:!1}}),Ia=new M({props:{code:"Zmx1c2goKQ==",highlighted:"flush()",wrap:!1}}),Wa=new M({props:{code:"bW9kZWwudG9fYmV0dGVydHJhbnNmb3JtZXIoKQ==",highlighted:"model.to_bettertransformer()",wrap:!1}}),Na=new M({props:{code:"c3RhcnRfdGltZSUyMCUzRCUyMHRpbWUudGltZSgpJTBBd2l0aCUyMHRvcmNoLmJhY2tlbmRzLmN1ZGEuc2RwX2tlcm5lbChlbmFibGVfZmxhc2glM0RUcnVlJTJDJTIwZW5hYmxlX21hdGglM0RGYWxzZSUyQyUyMGVuYWJsZV9tZW1fZWZmaWNpZW50JTNERmFsc2UpJTNBJTBBJTIwJTIwJTIwJTIwcmVzdWx0JTIwJTNEJTIwcGlwZShsb25nX3Byb21wdCUyQyUyMG1heF9uZXdfdG9rZW5zJTNENjApJTVCMCU1RCU1QiUyMmdlbmVyYXRlZF90ZXh0JTIyJTVEJTVCbGVuKGxvbmdfcHJvbXB0KSUzQSU1RCUwQSUwQXByaW50KGYlMjJHZW5lcmF0ZWQlMjBpbiUyMCU3QnRpbWUudGltZSgpJTIwLSUyMHN0YXJ0X3RpbWUlN0QlMjBzZWNvbmRzLiUyMiklMEFyZXN1bHQ=",highlighted:`start_time = time.time()
<span class="hljs-keyword">with</span> torch.backends.cuda.sdp_kernel(enable_flash=<span class="hljs-literal">True</span>, enable_math=<span class="hljs-literal">False</span>, enable_mem_efficient=<span class="hljs-literal">False</span>):
    result = pipe(long_prompt, max_new_tokens=<span class="hljs-number">60</span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>][<span class="hljs-built_in">len</span>(long_prompt):]

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated in <span class="hljs-subst">{time.time() - start_time}</span> seconds.&quot;</span>)
result`,wrap:!1}}),qa=new M({props:{code:"R2VuZXJhdGVkJTIwaW4lMjAzLjAyMTE2MTc5NDY2MjQ3NTYlMjBzZWNvbmRzLiUwQSUyMFN1cmUuJTIwSGVyZSUyMGlzJTIwYSUyMGZ1bmN0aW9uJTIwdGhhdCUyMGRvZXMlMjB0aGF0LiU1Q24lNUNuZGVmJTIwYnl0ZXNfdG9fZ2lnYShieXRlcyklM0ElNUNuJTIwJTIwJTIwcmV0dXJuJTIwYnl0ZXMlMjAlMkYlMjAxMDI0JTIwJTJGJTIwMTAyNCUyMCUyRiUyMDEwMjQlNUNuJTVDbkFuc3dlciUzQSUyMFN1cmUuJTIwSGVyZSUyMGlzJTIwYSUyMGZ1bmN0aW9uJTIwdGhhdCUyMGRvZXMlMjB0aGF0LiU1Q24lNUNuZGVm",highlighted:`Generated <span class="hljs-keyword">in</span> <span class="hljs-number">3.0211617946624756</span> seconds.
 Sure. Here <span class="hljs-keyword">is</span> a <span class="hljs-keyword">function</span> <span class="hljs-literal">that</span> does <span class="hljs-literal">that</span>.<span class="hljs-string">\\n\\ndef</span> bytes_to_giga(bytes):<span class="hljs-string">\\n</span>   <span class="hljs-keyword">return</span> bytes / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span><span class="hljs-string">\\n\\nAnswer:</span> Sure. Here <span class="hljs-keyword">is</span> a <span class="hljs-keyword">function</span> <span class="hljs-literal">that</span> does <span class="hljs-literal">that</span>.<span class="hljs-string">\\n\\ndef</span>`,wrap:!1}}),Aa=new M({props:{code:"Ynl0ZXNfdG9fZ2lnYV9ieXRlcyh0b3JjaC5jdWRhLm1heF9tZW1vcnlfYWxsb2NhdGVkKCkp",highlighted:"bytes_to_giga_bytes(torch.cuda.max_memory_allocated())",wrap:!1}}),Sa=new M({props:{code:"MzIuNjE3MzMxOTgxNjU4OTM2",highlighted:'<span class="hljs-attribute">32</span>.<span class="hljs-number">617331981658936</span>',wrap:!1}}),Fa=new M({props:{code:"Zmx1c2goKQ==",highlighted:"flush()",wrap:!1}}),Da=new hn({props:{title:"3. Architectural Innovations",local:"3-architectural-innovations",headingTag:"h2"}}),pe=new hn({props:{title:"3.1 Improving positional embeddings of LLMs",local:"31-improving-positional-embeddings-of-llms",headingTag:"h3"}}),xe=new hn({props:{title:"3.2 The key-value cache",local:"32-the-key-value-cache",headingTag:"h3"}}),je=new M({props:{code:"aW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTVCJTIyaW5wdXRfaWRzJTIyJTVELnRvKCUyMmN1ZGElMjIpJTBBJTBBZm9yJTIwXyUyMGluJTIwcmFuZ2UoNSklM0ElMEElMjAlMjBuZXh0X2xvZ2l0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyklNUIlMjJsb2dpdHMlMjIlNUQlNUIlM0ElMkMlMjAtMSUzQSU1RCUwQSUyMCUyMG5leHRfdG9rZW5faWQlMjAlM0QlMjB0b3JjaC5hcmdtYXgobmV4dF9sb2dpdHMlMkNkaW0lM0QtMSklMEElMEElMjAlMjBpbnB1dF9pZHMlMjAlM0QlMjB0b3JjaC5jYXQoJTVCaW5wdXRfaWRzJTJDJTIwbmV4dF90b2tlbl9pZCU1RCUyQyUyMGRpbSUzRC0xKSUwQSUyMCUyMHByaW50KCUyMnNoYXBlJTIwb2YlMjBpbnB1dF9pZHMlMjIlMkMlMjBpbnB1dF9pZHMuc2hhcGUpJTBBJTBBZ2VuZXJhdGVkX3RleHQlMjAlM0QlMjB0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGlucHV0X2lkcyU1QiUzQSUyQyUyMC01JTNBJTVEKSUwQWdlbmVyYXRlZF90ZXh0",highlighted:`input_ids = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>].to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
  next_logits = model(input_ids)[<span class="hljs-string">&quot;logits&quot;</span>][:, -<span class="hljs-number">1</span>:]
  next_token_id = torch.argmax(next_logits,dim=-<span class="hljs-number">1</span>)

  input_ids = torch.cat([input_ids, next_token_id], dim=-<span class="hljs-number">1</span>)
  <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;shape of input_ids&quot;</span>, input_ids.shape)

generated_text = tokenizer.batch_decode(input_ids[:, -<span class="hljs-number">5</span>:])
generated_text`,wrap:!1}}),Je=new M({props:{code:"c2hhcGUlMjBvZiUyMGlucHV0X2lkcyUyMHRvcmNoLlNpemUoJTVCMSUyQyUyMDIxJTVEKSUwQXNoYXBlJTIwb2YlMjBpbnB1dF9pZHMlMjB0b3JjaC5TaXplKCU1QjElMkMlMjAyMiU1RCklMEFzaGFwZSUyMG9mJTIwaW5wdXRfaWRzJTIwdG9yY2guU2l6ZSglNUIxJTJDJTIwMjMlNUQpJTBBc2hhcGUlMjBvZiUyMGlucHV0X2lkcyUyMHRvcmNoLlNpemUoJTVCMSUyQyUyMDI0JTVEKSUwQXNoYXBlJTIwb2YlMjBpbnB1dF9pZHMlMjB0b3JjaC5TaXplKCU1QjElMkMlMjAyNSU1RCklMEElNUInJTIwSGVyZSUyMGlzJTIwYSUyMFB5dGhvbiUyMGZ1bmN0aW9uJyU1RA==",highlighted:`shape of input_ids torch<span class="hljs-selector-class">.Size</span>(<span class="hljs-selector-attr">[1, 21]</span>)
shape of input_ids torch<span class="hljs-selector-class">.Size</span>(<span class="hljs-selector-attr">[1, 22]</span>)
shape of input_ids torch<span class="hljs-selector-class">.Size</span>(<span class="hljs-selector-attr">[1, 23]</span>)
shape of input_ids torch<span class="hljs-selector-class">.Size</span>(<span class="hljs-selector-attr">[1, 24]</span>)
shape of input_ids torch<span class="hljs-selector-class">.Size</span>(<span class="hljs-selector-attr">[1, 25]</span>)
<span class="hljs-selector-attr">[<span class="hljs-string">&#x27; Here is a Python function&#x27;</span>]</span>`,wrap:!1}}),Ge=new M({props:{code:"cGFzdF9rZXlfdmFsdWVzJTIwJTNEJTIwTm9uZSUyMCUyMyUyMHBhc3Rfa2V5X3ZhbHVlcyUyMGlzJTIwdGhlJTIwa2V5LXZhbHVlJTIwY2FjaGUlMEFnZW5lcmF0ZWRfdG9rZW5zJTIwJTNEJTIwJTVCJTVEJTBBbmV4dF90b2tlbl9pZCUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSU1QiUyMmlucHV0X2lkcyUyMiU1RC50byglMjJjdWRhJTIyKSUwQSUwQWZvciUyMF8lMjBpbiUyMHJhbmdlKDUpJTNBJTBBJTIwJTIwbmV4dF9sb2dpdHMlMkMlMjBwYXN0X2tleV92YWx1ZXMlMjAlM0QlMjBtb2RlbChuZXh0X3Rva2VuX2lkJTJDJTIwcGFzdF9rZXlfdmFsdWVzJTNEcGFzdF9rZXlfdmFsdWVzJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSkudG9fdHVwbGUoKSUwQSUyMCUyMG5leHRfbG9naXRzJTIwJTNEJTIwbmV4dF9sb2dpdHMlNUIlM0ElMkMlMjAtMSUzQSU1RCUwQSUyMCUyMG5leHRfdG9rZW5faWQlMjAlM0QlMjB0b3JjaC5hcmdtYXgobmV4dF9sb2dpdHMlMkMlMjBkaW0lM0QtMSklMEElMEElMjAlMjBwcmludCglMjJzaGFwZSUyMG9mJTIwaW5wdXRfaWRzJTIyJTJDJTIwbmV4dF90b2tlbl9pZC5zaGFwZSklMEElMjAlMjBwcmludCglMjJsZW5ndGglMjBvZiUyMGtleS12YWx1ZSUyMGNhY2hlJTIyJTJDJTIwbGVuKHBhc3Rfa2V5X3ZhbHVlcyU1QjAlNUQlNUIwJTVEKSklMjAlMjAlMjMlMjBwYXN0X2tleV92YWx1ZXMlMjBhcmUlMjBvZiUyMHNoYXBlJTIwJTVCbnVtX2xheWVycyUyQyUyMDAlMjBmb3IlMjBrJTJDJTIwMSUyMGZvciUyMHYlMkMlMjBiYXRjaF9zaXplJTJDJTIwbGVuZ3RoJTJDJTIwaGlkZGVuX2RpbSU1RCUwQSUyMCUyMGdlbmVyYXRlZF90b2tlbnMuYXBwZW5kKG5leHRfdG9rZW5faWQuaXRlbSgpKSUwQSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfdG9rZW5zKSUwQWdlbmVyYXRlZF90ZXh0",highlighted:`past_key_values = <span class="hljs-literal">None</span> <span class="hljs-comment"># past_key_values is the key-value cache</span>
generated_tokens = []
next_token_id = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>].to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
  next_logits, past_key_values = model(next_token_id, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>).to_tuple()
  next_logits = next_logits[:, -<span class="hljs-number">1</span>:]
  next_token_id = torch.argmax(next_logits, dim=-<span class="hljs-number">1</span>)

  <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;shape of input_ids&quot;</span>, next_token_id.shape)
  <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;length of key-value cache&quot;</span>, <span class="hljs-built_in">len</span>(past_key_values[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>]))  <span class="hljs-comment"># past_key_values are of shape [num_layers, 0 for k, 1 for v, batch_size, length, hidden_dim]</span>
  generated_tokens.append(next_token_id.item())

generated_text = tokenizer.batch_decode(generated_tokens)
generated_text`,wrap:!1}}),$e=new M({props:{code:"c2hhcGUlMjBvZiUyMGlucHV0X2lkcyUyMHRvcmNoLlNpemUoJTVCMSUyQyUyMDElNUQpJTBBbGVuZ3RoJTIwb2YlMjBrZXktdmFsdWUlMjBjYWNoZSUyMDIwJTBBc2hhcGUlMjBvZiUyMGlucHV0X2lkcyUyMHRvcmNoLlNpemUoJTVCMSUyQyUyMDElNUQpJTBBbGVuZ3RoJTIwb2YlMjBrZXktdmFsdWUlMjBjYWNoZSUyMDIxJTBBc2hhcGUlMjBvZiUyMGlucHV0X2lkcyUyMHRvcmNoLlNpemUoJTVCMSUyQyUyMDElNUQpJTBBbGVuZ3RoJTIwb2YlMjBrZXktdmFsdWUlMjBjYWNoZSUyMDIyJTBBc2hhcGUlMjBvZiUyMGlucHV0X2lkcyUyMHRvcmNoLlNpemUoJTVCMSUyQyUyMDElNUQpJTBBbGVuZ3RoJTIwb2YlMjBrZXktdmFsdWUlMjBjYWNoZSUyMDIzJTBBc2hhcGUlMjBvZiUyMGlucHV0X2lkcyUyMHRvcmNoLlNpemUoJTVCMSUyQyUyMDElNUQpJTBBbGVuZ3RoJTIwb2YlMjBrZXktdmFsdWUlMjBjYWNoZSUyMDI0JTBBJTVCJyUyMEhlcmUnJTJDJTIwJyUyMGlzJyUyQyUyMCclMjBhJyUyQyUyMCclMjBQeXRob24nJTJDJTIwJyUyMGZ1bmN0aW9uJyU1RA==",highlighted:`<span class="hljs-attribute">shape</span> of input_ids torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">1</span>])
<span class="hljs-attribute">length</span> of key-value cache <span class="hljs-number">20</span>
<span class="hljs-attribute">shape</span> of input_ids torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">1</span>])
<span class="hljs-attribute">length</span> of key-value cache <span class="hljs-number">21</span>
<span class="hljs-attribute">shape</span> of input_ids torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">1</span>])
<span class="hljs-attribute">length</span> of key-value cache <span class="hljs-number">22</span>
<span class="hljs-attribute">shape</span> of input_ids torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">1</span>])
<span class="hljs-attribute">length</span> of key-value cache <span class="hljs-number">23</span>
<span class="hljs-attribute">shape</span> of input_ids torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">1</span>])
<span class="hljs-attribute">length</span> of key-value cache <span class="hljs-number">24</span><span class="hljs-meta">
[&#x27; Here&#x27;, &#x27; is&#x27;, &#x27; a&#x27;, &#x27; Python&#x27;, &#x27; function&#x27;]</span>`,wrap:!1}}),Ne=new M({props:{code:"VXNlciUzQSUyMEhvdyUyMG1hbnklMjBwZW9wbGUlMjBsaXZlJTIwaW4lMjBGcmFuY2UlM0YlMEFBc3Npc3RhbnQlM0ElMjBSb3VnaGx5JTIwNzUlMjBtaWxsaW9uJTIwcGVvcGxlJTIwbGl2ZSUyMGluJTIwRnJhbmNlJTBBVXNlciUzQSUyMEFuZCUyMGhvdyUyMG1hbnklMjBhcmUlMjBpbiUyMEdlcm1hbnklM0YlMEFBc3Npc3RhbnQlM0ElMjBHZXJtYW55JTIwaGFzJTIwY2EuJTIwODElMjBtaWxsaW9uJTIwaW5oYWJpdGFudHM=",highlighted:`<span class="hljs-symbol">User:</span> How many people live <span class="hljs-keyword">in</span> France?
<span class="hljs-symbol">Assistant:</span> Roughly <span class="hljs-number">75</span> million people live <span class="hljs-keyword">in</span> France
<span class="hljs-symbol">User:</span> <span class="hljs-keyword">And</span> how many are <span class="hljs-keyword">in</span> Germany?
<span class="hljs-symbol">Assistant:</span> Germany has ca. <span class="hljs-number">81</span> million inhabitants`,wrap:!1}}),Ee=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwbW9kZWwuY29uZmlnJTBBMiUyMColMjAxNl8wMDAlMjAqJTIwY29uZmlnLm5fbGF5ZXIlMjAqJTIwY29uZmlnLm5faGVhZCUyMColMjBjb25maWcubl9lbWJkJTIwJTJGJTJGJTIwY29uZmlnLm5faGVhZA==",highlighted:`config = model.config
<span class="hljs-number">2</span> * <span class="hljs-number">16_000</span> * config.n_layer * config.n_head * config.n_embd // config.n_head`,wrap:!1}}),Ye=new M({props:{code:"Nzg2NDMyMDAwMA==",highlighted:'<span class="hljs-number">7864320000</span>',wrap:!1}}),pn=new hn({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),{c(){is=i("meta"),hl=n(),ol=i("p"),cl=n(),d(Ls.$$.fragment),ul=n(),d(zs.$$.fragment),dl=n(),Gs=i("p"),Gs.innerHTML=Yu,gl=n(),Bs=i("ul"),Bs.innerHTML=Pu,fl=n(),$s=i("p"),$s.textContent=Fu,yl=n(),Zs=i("p"),Zs.textContent=Ku,wl=n(),Is=i("ol"),Is.innerHTML=Du,bl=n(),Hs=i("p"),Hs.textContent=Ou,vl=n(),d(Ws.$$.fragment),Ml=n(),Qs=i("p"),Qs.innerHTML=sd,xl=n(),Ns=i("p"),Ns.innerHTML=td,kl=n(),Rs=i("blockquote"),Rs.innerHTML=ad,Tl=n(),qs=i("p"),qs.textContent=ed,_l=n(),Xs=i("blockquote"),Xs.innerHTML=nd,jl=n(),Vs=i("p"),Vs.textContent=ld,Ul=n(),As=i("p"),As.textContent=id,Jl=n(),Es=i("ul"),Es.innerHTML=pd,Cl=n(),Ss=i("p"),Ss.innerHTML=md,Ll=n(),Ys=i("p"),Ys.innerHTML=od,zl=n(),Ps=i("p"),Ps.innerHTML=rd,Gl=n(),Fs=i("p"),Fs.textContent=hd,Bl=n(),d(Ks.$$.fragment),$l=n(),d(Ds.$$.fragment),Zl=n(),Os=i("p"),Os.innerHTML=cd,Il=n(),st=i("p"),st.innerHTML=ud,Hl=n(),tt=i("p"),tt.innerHTML=dd,Wl=n(),at=i("p"),at.innerHTML=gd,Ql=n(),d(et.$$.fragment),Nl=n(),d(nt.$$.fragment),Rl=n(),lt=i("p"),lt.innerHTML=fd,ql=n(),d(it.$$.fragment),Xl=n(),pt=i("p"),pt.textContent=yd,Vl=n(),d(mt.$$.fragment),Al=n(),ot=i("p"),ot.innerHTML=wd,El=n(),d(rt.$$.fragment),Sl=n(),ht=i("p"),ht.innerHTML=bd,Yl=n(),d(ct.$$.fragment),Pl=n(),ut=i("p"),ut.textContent=vd,Fl=n(),dt=i("blockquote"),dt.innerHTML=Md,Kl=n(),gt=i("p"),gt.innerHTML=xd,Dl=n(),ft=i("p"),ft.innerHTML=kd,Ol=n(),d(yt.$$.fragment),si=n(),wt=i("p"),wt.textContent=Td,ti=n(),d(bt.$$.fragment),ai=n(),vt=i("p"),vt.innerHTML=_d,ei=n(),d(Mt.$$.fragment),ni=n(),xt=i("p"),xt.innerHTML=jd,li=n(),kt=i("p"),kt.innerHTML=Ud,ii=n(),Tt=i("p"),Tt.textContent=Jd,pi=n(),_t=i("ul"),_t.innerHTML=Cd,mi=n(),z=i("p"),Cc=r("In a nutshell, this means that "),cn=i("em"),cn.textContent=Ld,Lc=r(" multiplications, with "),oi=new c(!1),ri=r(" being the "),un=i("em"),un.textContent=zd,zc=r(", "),hi=new c(!1),ci=r(" being a weight matrix and "),ui=new c(!1),di=r(" being the output:"),gi=n(),dn=i("p"),fi=new c(!1),yi=n(),jt=i("p"),jt.textContent=Gd,wi=n(),gn=i("p"),bi=new c(!1),vi=n(),Ut=i("p"),Ut.textContent=Bd,Mi=n(),Jt=i("p"),Jt.innerHTML=$d,xi=n(),d(Ct.$$.fragment),ki=n(),Lt=i("p"),Lt.innerHTML=Zd,Ti=n(),d(zt.$$.fragment),_i=n(),Gt=i("p"),Gt.textContent=Id,ji=n(),d(Bt.$$.fragment),Ui=n(),$t=i("p"),$t.innerHTML=Hd,Ji=n(),d(Zt.$$.fragment),Ci=n(),It=i("p"),It.textContent=Wd,Li=n(),d(Ht.$$.fragment),zi=n(),Wt=i("p"),Wt.innerHTML=Qd,Gi=n(),d(Qt.$$.fragment),Bi=n(),Nt=i("p"),Nt.textContent=Nd,$i=n(),Rt=i("p"),Rt.textContent=Rd,Zi=n(),d(qt.$$.fragment),Ii=n(),d(Xt.$$.fragment),Hi=n(),Vt=i("p"),Vt.innerHTML=qd,Wi=n(),d(At.$$.fragment),Qi=n(),Et=i("p"),Et.innerHTML=Xd,Ni=n(),d(St.$$.fragment),Ri=n(),Yt=i("p"),Yt.innerHTML=Vd,qi=n(),d(Pt.$$.fragment),Xi=n(),Ft=i("p"),Ft.innerHTML=Ad,Vi=n(),d(Kt.$$.fragment),Ai=n(),Dt=i("p"),Dt.textContent=Ed,Ei=n(),Ot=i("p"),Ot.innerHTML=Sd,Si=n(),K=i("p"),Gc=r("Also note that inference here was again a bit slower compared to 8-bit quantization which is due to the more aggressive quantization method used for 4-bit quantization leading to "),Yi=new c(!1),Pi=r(" and "),Fi=new c(!1),Ki=r(" taking longer during inference."),Di=n(),d(sa.$$.fragment),Oi=n(),d(ta.$$.fragment),sp=n(),aa=i("p"),aa.textContent=Yd,tp=n(),ea=i("p"),ea.textContent=Pd,ap=n(),na=i("p"),na.innerHTML=Fd,ep=n(),la=i("blockquote"),la.innerHTML=Kd,np=n(),ia=i("p"),ia.textContent=Dd,lp=n(),pa=i("p"),pa.innerHTML=Od,ip=n(),d(ma.$$.fragment),pp=n(),oa=i("p"),oa.textContent=sg,mp=n(),q=i("p"),Bc=r(`Self-attention layers are central to Large Language Models (LLMs) in that they enable the model to understand the contextual relationships between input tokens.
However, the peak GPU memory consumption for self-attention layers grows `),fn=i("em"),fn.textContent=tg,$c=r(" both in compute and memory complexity with number of input tokens (also called "),yn=i("em"),yn.textContent=ag,Zc=r(") that we denote in the following by "),op=new c(!1),rp=r(` .
While this is not really noticeable for shorter input sequences (of up to 1000 input tokens), it becomes a serious problem for longer input sequences (at around 16000 input tokens).`),hp=n(),X=i("p"),Ic=r("Let’s take a closer look. The formula to compute the output "),cp=new c(!1),up=r(" of a self-attention layer for an input "),dp=new c(!1),gp=r(" of length "),fp=new c(!1),yp=r(" is:"),wp=n(),wn=i("p"),bp=new c(!1),vp=n(),C=i("p"),Mp=new c(!1),xp=r(" is thereby the input sequence to the attention layer. The projections "),kp=new c(!1),Tp=r(" and "),_p=new c(!1),jp=r(" will each consist of "),Up=new c(!1),Jp=r(" vectors resulting in the "),Cp=new c(!1),Lp=r(" being of size "),zp=new c(!1),Gp=r(" ."),Bp=n(),j=i("p"),Hc=r(`LLMs usually have multiple attention heads, thus doing multiple self-attention computations in parallel.
Assuming, the LLM has 40 attention heads and runs in bfloat16 precision, we can calculate the memory requirement to store the `),$p=new c(!1),Zp=r(" matrices to be "),Ip=new c(!1),Hp=r(" bytes. For "),Wp=new c(!1),Qp=r(" only around 50 MB of VRAM are needed, however, for "),Np=new c(!1),Rp=r(" we would need 19 GB of VRAM, and for "),qp=new c(!1),Xp=r(" we would need almost 1TB just to store the "),Vp=new c(!1),Ap=r(" matrices."),Ep=n(),ra=i("p"),ra.textContent=eg,Sp=n(),ha=i("p"),ha.textContent=ng,Yp=n(),V=i("p"),Wc=r("How can we get rid of the exorbitant memory requirements for large input lengths? We need a new way to compute the self-attention mechanism that gets rid of the "),Pp=new c(!1),Fp=r(" matrix. "),rs=i("a"),rs.textContent=lg,Qc=r(" developed exactly such a new algorithm and called it "),bn=i("strong"),bn.textContent=ig,Nc=r("."),Kp=n(),hs=i("p"),Rc=r("In a nutshell, Flash Attention breaks the  "),Dp=new c(!1),Op=r(") computation apart and instead computes smaller chunks of the output by iterating over multiple softmax computation steps:"),sm=n(),vn=i("p"),tm=new c(!1),am=n(),$=i("p"),qc=r("with "),em=new c(!1),nm=r(" and "),lm=new c(!1),im=r(" being some softmax normalization statistics that need to be recomputed for every "),pm=new c(!1),mm=r(" and "),om=new c(!1),rm=r(" ."),hm=n(),ca=i("p"),ca.innerHTML=pg,cm=n(),ua=i("p"),ua.textContent=mg,um=n(),Mn=i("blockquote"),ps=i("p"),Xc=r("By keeping track of softmax normalization statistics and by using some smart mathematics, Flash Attention gives "),xn=i("strong"),xn.textContent=og,Vc=r(" outputs compared to the default self-attention layer at a memory cost that only increases linearly with "),dm=new c(!1),gm=r(" ."),fm=n(),da=i("p"),da.innerHTML=rg,ym=n(),ga=i("blockquote"),ga.innerHTML=hg,wm=n(),D=i("p"),Ac=r("Essentially, Flash Attention makes sure that all intermediate write and read operations can be done using the fast "),kn=i("em"),kn.textContent=cg,Ec=r(" SRAM memory instead of having to access the slower VRAM memory to compute the output vector "),bm=new c(!1),vm=r(" ."),Mm=n(),fa=i("p"),fa.innerHTML=ug,xm=n(),ya=i("p"),ya.textContent=dg,km=n(),wa=i("p"),wa.innerHTML=gg,Tm=n(),d(ba.$$.fragment),_m=n(),va=i("p"),va.innerHTML=fg,jm=n(),d(Ma.$$.fragment),Um=n(),xa=i("p"),xa.textContent=yg,Jm=n(),d(ka.$$.fragment),Cm=n(),Ta=i("p"),Ta.innerHTML=wg,Lm=n(),d(_a.$$.fragment),zm=n(),ja=i("p"),ja.innerHTML=bg,Gm=n(),d(Ua.$$.fragment),Bm=n(),Ja=i("p"),Ja.textContent=vg,$m=n(),Ca=i("p"),Ca.innerHTML=Mg,Zm=n(),La=i("p"),La.textContent=xg,Im=n(),d(za.$$.fragment),Hm=n(),Ga=i("p"),Ga.innerHTML=kg,Wm=n(),d(Ba.$$.fragment),Qm=n(),$a=i("p"),$a.textContent=Tg,Nm=n(),Za=i("p"),Za.innerHTML=_g,Rm=n(),d(Ia.$$.fragment),qm=n(),Ha=i("p"),Ha.innerHTML=jg,Xm=n(),d(Wa.$$.fragment),Vm=n(),Qa=i("p"),Qa.textContent=Ug,Am=n(),d(Na.$$.fragment),Em=n(),Ra=i("p"),Ra.innerHTML=Jg,Sm=n(),d(qa.$$.fragment),Ym=n(),Xa=i("p"),Xa.textContent=Cg,Pm=n(),Va=i("p"),Va.textContent=Lg,Fm=n(),d(Aa.$$.fragment),Km=n(),Ea=i("p"),Ea.innerHTML=zg,Dm=n(),d(Sa.$$.fragment),Om=n(),Ya=i("p"),Ya.textContent=Gg,so=n(),Pa=i("p"),Pa.textContent=Bg,to=n(),d(Fa.$$.fragment),ao=n(),Ka=i("p"),Ka.innerHTML=$g,eo=n(),d(Da.$$.fragment),no=n(),Oa=i("p"),Oa.textContent=Zg,lo=n(),se=i("ul"),se.innerHTML=Ig,io=n(),te=i("p"),te.innerHTML=Hg,po=n(),ae=i("ul"),ae.innerHTML=Wg,mo=n(),ee=i("p"),ee.innerHTML=Qg,oo=n(),ne=i("p"),ne.textContent=Ng,ro=n(),le=i("ul"),le.innerHTML=Rg,ho=n(),ie=i("p"),ie.textContent=qg,co=n(),d(pe.$$.fragment),uo=n(),O=i("p"),Sc=r(`Self-attention puts each token in relation to each other’s tokens.
As an example, the `),go=new c(!1),fo=r(" matrix of the text input sequence "),Tn=i("em"),Tn.textContent=Xg,Yc=r(" could look as follows:"),yo=n(),me=i("p"),me.innerHTML=Vg,wo=n(),oe=i("p"),oe.innerHTML=Ag,bo=n(),G=i("p"),Pc=r(`A LLM based on self-attention, but without position embeddings would have great difficulties in understanding the positions of the text inputs to each other.
This is because the probability score computed by `),vo=new c(!1),Mo=r(" relates each word token to each other word token in "),xo=new c(!1),ko=r(` computations regardless of their relative positional distance to each other.
Therefore, for the LLM without position embeddings each token appears to have the same distance to all other tokens, `),_n=i("em"),_n.textContent=Eg,Fc=r(" differentiating between "),jn=i("em"),jn.textContent=Sg,Kc=r(" and "),Un=i("em"),Un.textContent=Yg,Dc=r(" would be very challenging."),To=n(),re=i("p"),re.innerHTML=Pg,_o=n(),U=i("p"),Oc=r("The authors of the "),cs=i("a"),cs.innerHTML=Fg,su=r(" paper introduced sinusoidal positional embeddings "),jo=new c(!1),Uo=r(` .
where each vector `),Jo=new c(!1),Co=r(" is computed as a sinusoidal function of its position "),Lo=new c(!1),zo=r(` .
The positional encodings are then simply added to the input sequence vectors `),Go=new c(!1),Bo=r(" = "),$o=new c(!1),Zo=r(" thereby cueing the model to better learn sentence order."),Io=n(),ss=i("p"),tu=r("Instead of using fixed position embeddings, others (such as "),us=i("a"),us.textContent=Kg,au=r(`) used learned positional encodings for which the positional embeddings
`),Ho=new c(!1),Wo=r(" are learned during training."),Qo=n(),he=i("p"),he.textContent=Dg,No=n(),ds=i("ol"),Q=i("li"),eu=r("Sinusoidal and learned position embeddings are both absolute positional embeddings, "),Jn=i("em"),Jn.textContent=Og,nu=r(" encoding a unique embedding for each position id: "),Ro=new c(!1),qo=r(" . As shown by "),gs=i("a"),gs.textContent=sf,lu=r(" and "),fs=i("a"),fs.textContent=tf,iu=r(", absolute positional embeddings lead to poor LLM performance for long text inputs. For long text inputs, it is advantageous if the model learns the relative positional distance input tokens have to each other instead of their absolute position."),pu=n(),ce=i("li"),mu=r("When using learned position embeddings, the LLM has to be trained on a fixed input length "),Xo=new c(!1),Vo=r(", which makes it difficult to extrapolate to an input length longer than what it was trained on."),Ao=n(),ue=i("p"),ue.textContent=af,Eo=n(),de=i("ul"),de.innerHTML=ef,So=n(),A=i("p"),ou=r("Both "),Cn=i("em"),Cn.textContent=nf,ru=r(" and "),Ln=i("em"),Ln.textContent=lf,hu=r(" argue that it’s best to cue the LLM about sentence order directly in the self-attention algorithm as it’s there that word tokens are put into relation with each other. More specifically, sentence order should be cued by modifying the "),Yo=new c(!1),Po=r(" computation."),Fo=n(),T=i("p"),cu=r("Without going into too many details, "),zn=i("em"),zn.textContent=pf,uu=r(" notes that positional information can be encoded into query-key pairs, "),Gn=i("em"),Gn.textContent=mf,du=n(),Ko=new c(!1),Do=r(" and "),Oo=new c(!1),sr=r(" by rotating each vector by an angle "),tr=new c(!1),ar=r(" and "),er=new c(!1),nr=r(" respectively with "),lr=new c(!1),ir=r(" describing each vectors sentence position:"),pr=n(),Bn=i("p"),mr=new c(!1),or=n(),F=i("p"),rr=new c(!1),hr=r(" thereby represents a rotational matrix. "),cr=new c(!1),ur=r(" is "),$n=i("em"),$n.textContent=of,gu=r(" learned during training, but instead set to a pre-defined value that depends on the maximum input sequence length during training."),dr=n(),Zn=i("blockquote"),L=i("p"),fu=r("By doing so, the propability score between "),gr=new c(!1),fr=r(" and "),yr=new c(!1),wr=r(" is only affected if "),br=new c(!1),vr=r(" and solely depends on the relative distance "),Mr=new c(!1),xr=r(" regardless of each vector’s specific positions "),kr=new c(!1),Tr=r(" and "),_r=new c(!1),jr=r(" ."),Ur=n(),ge=i("p"),ge.innerHTML=rf,Jr=n(),fe=i("ul"),fe.innerHTML=hf,Cr=n(),E=i("p"),yu=r("As an alternative, "),In=i("em"),In.textContent=cf,wu=r(" proposes a much simpler relative position encoding scheme. The relative distance that input tokens have to each other is added as a negative integer scaled by a pre-defined value "),Hn=i("code"),Hn.textContent=uf,bu=r(" to each query-key entry of the "),Lr=new c(!1),zr=r(" matrix right before the softmax computation."),Gr=n(),ye=i("p"),ye.innerHTML=df,Br=n(),we=i("p"),we.innerHTML=gf,$r=n(),be=i("p"),be.innerHTML=ff,Zr=n(),ve=i("ul"),ve.innerHTML=yf,Ir=n(),x=i("p"),vu=r("Both "),Wn=i("em"),Wn.textContent=wf,Mu=r(" and "),Qn=i("em"),Qn.textContent=bf,xu=r(" position encodings can extrapolate to input lengths not seen during training whereas it has been shown that extrapolation works much better out-of-the-box for "),Nn=i("em"),Nn.textContent=vf,ku=r(" as compared to "),Rn=i("em"),Rn.textContent=Mf,Tu=r(`.
For ALiBi, one simply increases the values of the lower triangular position matrix to match the length of the input sequence.
For `),qn=i("em"),qn.textContent=xf,_u=r(", keeping the same "),Hr=new c(!1),Wr=r(" that was used during training leads to poor results when passing text inputs much longer than those seen during training, "),Xn=i("em"),Xn.textContent=kf,ju=n(),ys=i("a"),ys.textContent=Tf,Uu=r(". However, the community has found a couple of effective tricks that adapt "),Qr=new c(!1),Nr=r(", thereby allowing "),Vn=i("em"),Vn.textContent=_f,Ju=r(" position embeddings to work well for extrapolated text input sequences (see "),ws=i("a"),ws.textContent=jf,Cu=r(")."),Rr=n(),bs=i("blockquote"),An=i("p"),An.innerHTML=Uf,Lu=n(),ms=i("ul"),Me=i("li"),zu=r("Positional cues about the text inputs should be given directly to the "),qr=new c(!1),Xr=r(" matrix of the self-attention layer"),Gu=n(),En=i("li"),En.innerHTML=Jf,Bu=n(),Sn=i("li"),Sn.textContent=Cf,Vr=n(),S=i("p"),$u=r("In conclusion, LLMs that are intended to be deployed in tasks that require handling large text inputs are better trained with relative positional embeddings, such as RoPE and ALiBi. Also note that even if an LLM with RoPE and ALiBi has been trained only on a fixed length of say "),Ar=new c(!1),Er=r(" it can still be used in practice with text inputs much larger than "),Sr=new c(!1),Yr=r(", like "),Pr=new c(!1),Fr=r(" by extrapolating the positional embeddings."),Kr=n(),d(xe.$$.fragment),Dr=n(),ke=i("p"),ke.textContent=Lf,Or=n(),Te=i("p"),Te.innerHTML=zf,sh=n(),_e=i("p"),_e.innerHTML=Gf,th=n(),d(je.$$.fragment),ah=n(),Ue=i("p"),Ue.innerHTML=Bf,eh=n(),d(Je.$$.fragment),nh=n(),Ce=i("p"),Ce.textContent=$f,lh=n(),Le=i("p"),Le.innerHTML=Zf,ih=n(),J=i("p"),Zu=r("As a consequence, tokens "),Yn=i("em"),Yn.textContent=If,Iu=r(" depend on previous tokens, more specifically the "),ph=new c(!1),mh=r(" vector is never put in relation with any key, values vectors "),oh=new c(!1),rh=r(" if "),hh=new c(!1),ch=r(" . Instead "),uh=new c(!1),dh=r(" only attends to previous key-value vectors "),gh=new c(!1),fh=r(". In order to reduce unnecessary computation, one can therefore cache each layer’s key-value vectors for all previous timesteps."),yh=n(),ze=i("p"),ze.innerHTML=Hf,wh=n(),d(Ge.$$.fragment),bh=n(),Be=i("p"),Be.innerHTML=Wf,vh=n(),d($e.$$.fragment),Mh=n(),Ze=i("p"),Ze.innerHTML=Qf,xh=n(),Pn=i("blockquote"),N=i("p"),Hu=r("Making use of the key-value cache means that the "),kh=new c(!1),Th=r(" is essentially reduced to "),_h=new c(!1),jh=r(" with "),Uh=new c(!1),Jh=r(" being the query projection of the currently passed input token which is "),Fn=i("em"),Fn.textContent=Nf,Wu=r(" just a single vector."),Ch=n(),Ie=i("p"),Ie.textContent=Rf,Lh=n(),vs=i("ul"),He=i("li"),Qu=r("Significant increase in computational efficiency as less computations are performed compared to computing the full "),zh=new c(!1),Gh=r(" matrix. This leads to an increase in inference speed"),Nu=n(),Kn=i("li"),Kn.textContent=qf,Bh=n(),We=i("blockquote"),We.innerHTML=Xf,$h=n(),Qe=i("p"),Qe.textContent=Vf,Zh=n(),d(Ne.$$.fragment),Ih=n(),Re=i("p"),Re.textContent=Af,Hh=n(),qe=i("ul"),qe.innerHTML=Ef,Wh=n(),Xe=i("p"),Xe.textContent=Sf,Qh=n(),Ve=i("ol"),Ve.innerHTML=Yf,Nh=n(),ts=i("p"),Ru=r("There is however one catch. While the required peak memory for the "),Rh=new c(!1),qh=r(" matrix is significantly reduced, holding the key-value cache in memory can become very memory expensive for long input sequences or multi-turn chat. Remember that the key-value cache needs to store the key-value vectors for all previous input vectors "),Xh=new c(!1),Vh=r(" for all self-attention layers and for all attention heads."),Ah=n(),Ae=i("p"),Ae.innerHTML=Pf,Eh=n(),d(Ee.$$.fragment),Sh=n(),Se=i("p"),Se.innerHTML=Ff,Yh=n(),d(Ye.$$.fragment),Ph=n(),Pe=i("p"),Pe.innerHTML=Kf,Fh=n(),Fe=i("ol"),Fe.innerHTML=Df,Kh=n(),Ke=i("p"),Ke.innerHTML=Of,Dh=n(),Dn=i("blockquote"),os=i("p"),qu=r("By using a single head-value projection weight pair, the key value vectors "),Oh=new c(!1),sc=r(" have to be identical across all attention heads which in turn means that we only need to store 1 key-value projection pair in the cache instead of "),On=i("code"),On.textContent=sy,Xu=r(" ones."),tc=n(),De=i("p"),De.textContent=ty,ac=n(),as=i("p"),Vu=r(`In addition to memory savings, MQA also leads to improved computational efficiency as explained in the following.
In auto-regressive decoding, large key-value vectors need to be reloaded, concatenated with the current key-value vector pair to be then fed into the `),ec=new c(!1),nc=r(" computation at every step. For auto-regressive decoding, the required memory bandwidth for the constant reloading can become a serious time bottleneck. By reducing the size of the key-value vectors less memory needs to be accessed, thus reducing the memory bandwidth bottleneck. For more detail, please have a look at "),Ms=i("a"),Ms.textContent=ay,Au=r("."),lc=n(),xs=i("p"),Eu=r("The important part to understand here is that reducing the number of key-value attention heads to 1 only makes sense if a key-value cache is used. The peak memory consumption of the model for a single forward pass without key-value cache stays unchanged as every attention head still has a unique query vector so that each attention head still has a different "),ic=new c(!1),pc=r(" matrix."),mc=n(),Oe=i("p"),Oe.textContent=ey,oc=n(),sn=i("ul"),sn.innerHTML=ny,rc=n(),tn=i("p"),tn.innerHTML=ly,hc=n(),ks=i("ol"),ks.innerHTML=iy,cc=n(),an=i("p"),an.innerHTML=py,uc=n(),en=i("p"),en.innerHTML=my,dc=n(),nn=i("p"),nn.innerHTML=oy,gc=n(),ln=i("blockquote"),ln.innerHTML=ry,fc=n(),d(pn.$$.fragment),yc=n(),mn=i("p"),mn.innerHTML=hy,wc=n(),on=i("p"),on.innerHTML=cy,bc=n(),rl=i("p"),this.h()},l(s){const t=Ow("svelte-u9bgzb",document.head);is=p(t,"META",{name:!0,content:!0}),t.forEach(a),hl=l(s),ol=p(s,"P",{}),v(ol).forEach(a),cl=l(s),g(Ls.$$.fragment,s),ul=l(s),g(zs.$$.fragment,s),dl=l(s),Gs=p(s,"P",{"data-svelte-h":!0}),o(Gs)!=="svelte-1b2qao5"&&(Gs.innerHTML=Yu),gl=l(s),Bs=p(s,"UL",{"data-svelte-h":!0}),o(Bs)!=="svelte-xknchk"&&(Bs.innerHTML=Pu),fl=l(s),$s=p(s,"P",{"data-svelte-h":!0}),o($s)!=="svelte-1cl588t"&&($s.textContent=Fu),yl=l(s),Zs=p(s,"P",{"data-svelte-h":!0}),o(Zs)!=="svelte-f1zoss"&&(Zs.textContent=Ku),wl=l(s),Is=p(s,"OL",{"data-svelte-h":!0}),o(Is)!=="svelte-1d4b4yy"&&(Is.innerHTML=Du),bl=l(s),Hs=p(s,"P",{"data-svelte-h":!0}),o(Hs)!=="svelte-ihy2a8"&&(Hs.textContent=Ou),vl=l(s),g(Ws.$$.fragment,s),Ml=l(s),Qs=p(s,"P",{"data-svelte-h":!0}),o(Qs)!=="svelte-qqgdso"&&(Qs.innerHTML=sd),xl=l(s),Ns=p(s,"P",{"data-svelte-h":!0}),o(Ns)!=="svelte-ljb3iz"&&(Ns.innerHTML=td),kl=l(s),Rs=p(s,"BLOCKQUOTE",{"data-svelte-h":!0}),o(Rs)!=="svelte-4jkxwr"&&(Rs.innerHTML=ad),Tl=l(s),qs=p(s,"P",{"data-svelte-h":!0}),o(qs)!=="svelte-i58rjm"&&(qs.textContent=ed),_l=l(s),Xs=p(s,"BLOCKQUOTE",{"data-svelte-h":!0}),o(Xs)!=="svelte-z4szg9"&&(Xs.innerHTML=nd),jl=l(s),Vs=p(s,"P",{"data-svelte-h":!0}),o(Vs)!=="svelte-28orre"&&(Vs.textContent=ld),Ul=l(s),As=p(s,"P",{"data-svelte-h":!0}),o(As)!=="svelte-1jmd8j1"&&(As.textContent=id),Jl=l(s),Es=p(s,"UL",{"data-svelte-h":!0}),o(Es)!=="svelte-1th1pdf"&&(Es.innerHTML=pd),Cl=l(s),Ss=p(s,"P",{"data-svelte-h":!0}),o(Ss)!=="svelte-28fp1w"&&(Ss.innerHTML=md),Ll=l(s),Ys=p(s,"P",{"data-svelte-h":!0}),o(Ys)!=="svelte-189eose"&&(Ys.innerHTML=od),zl=l(s),Ps=p(s,"P",{"data-svelte-h":!0}),o(Ps)!=="svelte-2rsruz"&&(Ps.innerHTML=rd),Gl=l(s),Fs=p(s,"P",{"data-svelte-h":!0}),o(Fs)!=="svelte-g7zrz4"&&(Fs.textContent=hd),Bl=l(s),g(Ks.$$.fragment,s),$l=l(s),g(Ds.$$.fragment,s),Zl=l(s),Os=p(s,"P",{"data-svelte-h":!0}),o(Os)!=="svelte-z9gs9x"&&(Os.innerHTML=cd),Il=l(s),st=p(s,"P",{"data-svelte-h":!0}),o(st)!=="svelte-19462o4"&&(st.innerHTML=ud),Hl=l(s),tt=p(s,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-ppeb89"&&(tt.innerHTML=dd),Wl=l(s),at=p(s,"P",{"data-svelte-h":!0}),o(at)!=="svelte-81gnnp"&&(at.innerHTML=gd),Ql=l(s),g(et.$$.fragment,s),Nl=l(s),g(nt.$$.fragment,s),Rl=l(s),lt=p(s,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-jl1fz0"&&(lt.innerHTML=fd),ql=l(s),g(it.$$.fragment,s),Xl=l(s),pt=p(s,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-174suzs"&&(pt.textContent=yd),Vl=l(s),g(mt.$$.fragment,s),Al=l(s),ot=p(s,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-138fn6l"&&(ot.innerHTML=wd),El=l(s),g(rt.$$.fragment,s),Sl=l(s),ht=p(s,"P",{"data-svelte-h":!0}),o(ht)!=="svelte-jl1fz0"&&(ht.innerHTML=bd),Yl=l(s),g(ct.$$.fragment,s),Pl=l(s),ut=p(s,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-14j7eyl"&&(ut.textContent=vd),Fl=l(s),dt=p(s,"BLOCKQUOTE",{"data-svelte-h":!0}),o(dt)!=="svelte-1gvcuxd"&&(dt.innerHTML=Md),Kl=l(s),gt=p(s,"P",{"data-svelte-h":!0}),o(gt)!=="svelte-1urmxur"&&(gt.innerHTML=xd),Dl=l(s),ft=p(s,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-1uylvrd"&&(ft.innerHTML=kd),Ol=l(s),g(yt.$$.fragment,s),si=l(s),wt=p(s,"P",{"data-svelte-h":!0}),o(wt)!=="svelte-zicod6"&&(wt.textContent=Td),ti=l(s),g(bt.$$.fragment,s),ai=l(s),vt=p(s,"P",{"data-svelte-h":!0}),o(vt)!=="svelte-1prc48e"&&(vt.innerHTML=_d),ei=l(s),g(Mt.$$.fragment,s),ni=l(s),xt=p(s,"P",{"data-svelte-h":!0}),o(xt)!=="svelte-1xisv4k"&&(xt.innerHTML=jd),li=l(s),kt=p(s,"P",{"data-svelte-h":!0}),o(kt)!=="svelte-xkk23p"&&(kt.innerHTML=Ud),ii=l(s),Tt=p(s,"P",{"data-svelte-h":!0}),o(Tt)!=="svelte-171gpq5"&&(Tt.textContent=Jd),pi=l(s),_t=p(s,"UL",{"data-svelte-h":!0}),o(_t)!=="svelte-11ifrvi"&&(_t.innerHTML=Cd),mi=l(s),z=p(s,"P",{});var Y=v(z);Cc=h(Y,"In a nutshell, this means that "),cn=p(Y,"EM",{"data-svelte-h":!0}),o(cn)!=="svelte-1hxrv2n"&&(cn.textContent=Ld),Lc=h(Y," multiplications, with "),oi=u(Y,!1),ri=h(Y," being the "),un=p(Y,"EM",{"data-svelte-h":!0}),o(un)!=="svelte-9j42in"&&(un.textContent=zd),zc=h(Y,", "),hi=u(Y,!1),ci=h(Y," being a weight matrix and "),ui=u(Y,!1),di=h(Y," being the output:"),Y.forEach(a),gi=l(s),dn=p(s,"P",{});var uy=v(dn);fi=u(uy,!1),uy.forEach(a),yi=l(s),jt=p(s,"P",{"data-svelte-h":!0}),o(jt)!=="svelte-mfejh5"&&(jt.textContent=Gd),wi=l(s),gn=p(s,"P",{});var dy=v(gn);bi=u(dy,!1),dy.forEach(a),vi=l(s),Ut=p(s,"P",{"data-svelte-h":!0}),o(Ut)!=="svelte-12wl41q"&&(Ut.textContent=Bd),Mi=l(s),Jt=p(s,"P",{"data-svelte-h":!0}),o(Jt)!=="svelte-8mpqh2"&&(Jt.innerHTML=$d),xi=l(s),g(Ct.$$.fragment,s),ki=l(s),Lt=p(s,"P",{"data-svelte-h":!0}),o(Lt)!=="svelte-6n5flp"&&(Lt.innerHTML=Zd),Ti=l(s),g(zt.$$.fragment,s),_i=l(s),Gt=p(s,"P",{"data-svelte-h":!0}),o(Gt)!=="svelte-1yy92n4"&&(Gt.textContent=Id),ji=l(s),g(Bt.$$.fragment,s),Ui=l(s),$t=p(s,"P",{"data-svelte-h":!0}),o($t)!=="svelte-jl1fz0"&&($t.innerHTML=Hd),Ji=l(s),g(Zt.$$.fragment,s),Ci=l(s),It=p(s,"P",{"data-svelte-h":!0}),o(It)!=="svelte-12urs7j"&&(It.textContent=Wd),Li=l(s),g(Ht.$$.fragment,s),zi=l(s),Wt=p(s,"P",{"data-svelte-h":!0}),o(Wt)!=="svelte-jl1fz0"&&(Wt.innerHTML=Qd),Gi=l(s),g(Qt.$$.fragment,s),Bi=l(s),Nt=p(s,"P",{"data-svelte-h":!0}),o(Nt)!=="svelte-x8wynt"&&(Nt.textContent=Nd),$i=l(s),Rt=p(s,"P",{"data-svelte-h":!0}),o(Rt)!=="svelte-3uld8v"&&(Rt.textContent=Rd),Zi=l(s),g(qt.$$.fragment,s),Ii=l(s),g(Xt.$$.fragment,s),Hi=l(s),Vt=p(s,"P",{"data-svelte-h":!0}),o(Vt)!=="svelte-1sadlnz"&&(Vt.innerHTML=qd),Wi=l(s),g(At.$$.fragment,s),Qi=l(s),Et=p(s,"P",{"data-svelte-h":!0}),o(Et)!=="svelte-jl1fz0"&&(Et.innerHTML=Xd),Ni=l(s),g(St.$$.fragment,s),Ri=l(s),Yt=p(s,"P",{"data-svelte-h":!0}),o(Yt)!=="svelte-1scve2"&&(Yt.innerHTML=Vd),qi=l(s),g(Pt.$$.fragment,s),Xi=l(s),Ft=p(s,"P",{"data-svelte-h":!0}),o(Ft)!=="svelte-jl1fz0"&&(Ft.innerHTML=Ad),Vi=l(s),g(Kt.$$.fragment,s),Ai=l(s),Dt=p(s,"P",{"data-svelte-h":!0}),o(Dt)!=="svelte-1mhmf5k"&&(Dt.textContent=Ed),Ei=l(s),Ot=p(s,"P",{"data-svelte-h":!0}),o(Ot)!=="svelte-sad4qj"&&(Ot.innerHTML=Sd),Si=l(s),K=p(s,"P",{});var sl=v(K);Gc=h(sl,"Also note that inference here was again a bit slower compared to 8-bit quantization which is due to the more aggressive quantization method used for 4-bit quantization leading to "),Yi=u(sl,!1),Pi=h(sl," and "),Fi=u(sl,!1),Ki=h(sl," taking longer during inference."),sl.forEach(a),Di=l(s),g(sa.$$.fragment,s),Oi=l(s),g(ta.$$.fragment,s),sp=l(s),aa=p(s,"P",{"data-svelte-h":!0}),o(aa)!=="svelte-9e7sx8"&&(aa.textContent=Yd),tp=l(s),ea=p(s,"P",{"data-svelte-h":!0}),o(ea)!=="svelte-pphiln"&&(ea.textContent=Pd),ap=l(s),na=p(s,"P",{"data-svelte-h":!0}),o(na)!=="svelte-6h5u0r"&&(na.innerHTML=Fd),ep=l(s),la=p(s,"BLOCKQUOTE",{"data-svelte-h":!0}),o(la)!=="svelte-i1sgud"&&(la.innerHTML=Kd),np=l(s),ia=p(s,"P",{"data-svelte-h":!0}),o(ia)!=="svelte-68w1lt"&&(ia.textContent=Dd),lp=l(s),pa=p(s,"P",{"data-svelte-h":!0}),o(pa)!=="svelte-ei9u00"&&(pa.innerHTML=Od),ip=l(s),g(ma.$$.fragment,s),pp=l(s),oa=p(s,"P",{"data-svelte-h":!0}),o(oa)!=="svelte-649tnu"&&(oa.textContent=sg),mp=l(s),q=p(s,"P",{});var Ts=v(q);Bc=h(Ts,`Self-attention layers are central to Large Language Models (LLMs) in that they enable the model to understand the contextual relationships between input tokens.
However, the peak GPU memory consumption for self-attention layers grows `),fn=p(Ts,"EM",{"data-svelte-h":!0}),o(fn)!=="svelte-1jeo576"&&(fn.textContent=tg),$c=h(Ts," both in compute and memory complexity with number of input tokens (also called "),yn=p(Ts,"EM",{"data-svelte-h":!0}),o(yn)!=="svelte-1xe7eav"&&(yn.textContent=ag),Zc=h(Ts,") that we denote in the following by "),op=u(Ts,!1),rp=h(Ts,` .
While this is not really noticeable for shorter input sequences (of up to 1000 input tokens), it becomes a serious problem for longer input sequences (at around 16000 input tokens).`),Ts.forEach(a),hp=l(s),X=p(s,"P",{});var _s=v(X);Ic=h(_s,"Let’s take a closer look. The formula to compute the output "),cp=u(_s,!1),up=h(_s," of a self-attention layer for an input "),dp=u(_s,!1),gp=h(_s," of length "),fp=u(_s,!1),yp=h(_s," is:"),_s.forEach(a),wp=l(s),wn=p(s,"P",{});var gy=v(wn);bp=u(gy,!1),gy.forEach(a),vp=l(s),C=p(s,"P",{});var R=v(C);Mp=u(R,!1),xp=h(R," is thereby the input sequence to the attention layer. The projections "),kp=u(R,!1),Tp=h(R," and "),_p=u(R,!1),jp=h(R," will each consist of "),Up=u(R,!1),Jp=h(R," vectors resulting in the "),Cp=u(R,!1),Lp=h(R," being of size "),zp=u(R,!1),Gp=h(R," ."),R.forEach(a),Bp=l(s),j=p(s,"P",{});var Z=v(j);Hc=h(Z,`LLMs usually have multiple attention heads, thus doing multiple self-attention computations in parallel.
Assuming, the LLM has 40 attention heads and runs in bfloat16 precision, we can calculate the memory requirement to store the `),$p=u(Z,!1),Zp=h(Z," matrices to be "),Ip=u(Z,!1),Hp=h(Z," bytes. For "),Wp=u(Z,!1),Qp=h(Z," only around 50 MB of VRAM are needed, however, for "),Np=u(Z,!1),Rp=h(Z," we would need 19 GB of VRAM, and for "),qp=u(Z,!1),Xp=h(Z," we would need almost 1TB just to store the "),Vp=u(Z,!1),Ap=h(Z," matrices."),Z.forEach(a),Ep=l(s),ra=p(s,"P",{"data-svelte-h":!0}),o(ra)!=="svelte-bptbn2"&&(ra.textContent=eg),Sp=l(s),ha=p(s,"P",{"data-svelte-h":!0}),o(ha)!=="svelte-opmd8n"&&(ha.textContent=ng),Yp=l(s),V=p(s,"P",{});var js=v(V);Wc=h(js,"How can we get rid of the exorbitant memory requirements for large input lengths? We need a new way to compute the self-attention mechanism that gets rid of the "),Pp=u(js,!1),Fp=h(js," matrix. "),rs=p(js,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(rs)!=="svelte-1h13bsr"&&(rs.textContent=lg),Qc=h(js," developed exactly such a new algorithm and called it "),bn=p(js,"STRONG",{"data-svelte-h":!0}),o(bn)!=="svelte-eh0j4m"&&(bn.textContent=ig),Nc=h(js,"."),js.forEach(a),Kp=l(s),hs=p(s,"P",{});var Mc=v(hs);Rc=h(Mc,"In a nutshell, Flash Attention breaks the  "),Dp=u(Mc,!1),Op=h(Mc,") computation apart and instead computes smaller chunks of the output by iterating over multiple softmax computation steps:"),Mc.forEach(a),sm=l(s),vn=p(s,"P",{});var fy=v(vn);tm=u(fy,!1),fy.forEach(a),am=l(s),$=p(s,"P",{});var es=v($);qc=h(es,"with "),em=u(es,!1),nm=h(es," and "),lm=u(es,!1),im=h(es," being some softmax normalization statistics that need to be recomputed for every "),pm=u(es,!1),mm=h(es," and "),om=u(es,!1),rm=h(es," ."),es.forEach(a),hm=l(s),ca=p(s,"P",{"data-svelte-h":!0}),o(ca)!=="svelte-1q8406g"&&(ca.innerHTML=pg),cm=l(s),ua=p(s,"P",{"data-svelte-h":!0}),o(ua)!=="svelte-1ufr4xd"&&(ua.textContent=mg),um=l(s),Mn=p(s,"BLOCKQUOTE",{});var yy=v(Mn);ps=p(yy,"P",{});var tl=v(ps);Xc=h(tl,"By keeping track of softmax normalization statistics and by using some smart mathematics, Flash Attention gives "),xn=p(tl,"STRONG",{"data-svelte-h":!0}),o(xn)!=="svelte-1fh6qbl"&&(xn.textContent=og),Vc=h(tl," outputs compared to the default self-attention layer at a memory cost that only increases linearly with "),dm=u(tl,!1),gm=h(tl," ."),tl.forEach(a),yy.forEach(a),fm=l(s),da=p(s,"P",{"data-svelte-h":!0}),o(da)!=="svelte-1re0bhf"&&(da.innerHTML=rg),ym=l(s),ga=p(s,"BLOCKQUOTE",{"data-svelte-h":!0}),o(ga)!=="svelte-m261q0"&&(ga.innerHTML=hg),wm=l(s),D=p(s,"P",{});var al=v(D);Ac=h(al,"Essentially, Flash Attention makes sure that all intermediate write and read operations can be done using the fast "),kn=p(al,"EM",{"data-svelte-h":!0}),o(kn)!=="svelte-1g1d7vc"&&(kn.textContent=cg),Ec=h(al," SRAM memory instead of having to access the slower VRAM memory to compute the output vector "),bm=u(al,!1),vm=h(al," ."),al.forEach(a),Mm=l(s),fa=p(s,"P",{"data-svelte-h":!0}),o(fa)!=="svelte-1ew53wd"&&(fa.innerHTML=ug),xm=l(s),ya=p(s,"P",{"data-svelte-h":!0}),o(ya)!=="svelte-1uhed9l"&&(ya.textContent=dg),km=l(s),wa=p(s,"P",{"data-svelte-h":!0}),o(wa)!=="svelte-66kx9u"&&(wa.innerHTML=gg),Tm=l(s),g(ba.$$.fragment,s),_m=l(s),va=p(s,"P",{"data-svelte-h":!0}),o(va)!=="svelte-1qzrmrh"&&(va.innerHTML=fg),jm=l(s),g(Ma.$$.fragment,s),Um=l(s),xa=p(s,"P",{"data-svelte-h":!0}),o(xa)!=="svelte-1lfqnh1"&&(xa.textContent=yg),Jm=l(s),g(ka.$$.fragment,s),Cm=l(s),Ta=p(s,"P",{"data-svelte-h":!0}),o(Ta)!=="svelte-tc5wkn"&&(Ta.innerHTML=wg),Lm=l(s),g(_a.$$.fragment,s),zm=l(s),ja=p(s,"P",{"data-svelte-h":!0}),o(ja)!=="svelte-jl1fz0"&&(ja.innerHTML=bg),Gm=l(s),g(Ua.$$.fragment,s),Bm=l(s),Ja=p(s,"P",{"data-svelte-h":!0}),o(Ja)!=="svelte-sz1cee"&&(Ja.textContent=vg),$m=l(s),Ca=p(s,"P",{"data-svelte-h":!0}),o(Ca)!=="svelte-d2g4iy"&&(Ca.innerHTML=Mg),Zm=l(s),La=p(s,"P",{"data-svelte-h":!0}),o(La)!=="svelte-2il51v"&&(La.textContent=xg),Im=l(s),g(za.$$.fragment,s),Hm=l(s),Ga=p(s,"P",{"data-svelte-h":!0}),o(Ga)!=="svelte-jl1fz0"&&(Ga.innerHTML=kg),Wm=l(s),g(Ba.$$.fragment,s),Qm=l(s),$a=p(s,"P",{"data-svelte-h":!0}),o($a)!=="svelte-1uumitt"&&($a.textContent=Tg),Nm=l(s),Za=p(s,"P",{"data-svelte-h":!0}),o(Za)!=="svelte-bk1lpp"&&(Za.innerHTML=_g),Rm=l(s),g(Ia.$$.fragment,s),qm=l(s),Ha=p(s,"P",{"data-svelte-h":!0}),o(Ha)!=="svelte-i73wiy"&&(Ha.innerHTML=jg),Xm=l(s),g(Wa.$$.fragment,s),Vm=l(s),Qa=p(s,"P",{"data-svelte-h":!0}),o(Qa)!=="svelte-ncw8pe"&&(Qa.textContent=Ug),Am=l(s),g(Na.$$.fragment,s),Em=l(s),Ra=p(s,"P",{"data-svelte-h":!0}),o(Ra)!=="svelte-jl1fz0"&&(Ra.innerHTML=Jg),Sm=l(s),g(qa.$$.fragment,s),Ym=l(s),Xa=p(s,"P",{"data-svelte-h":!0}),o(Xa)!=="svelte-1onj0qe"&&(Xa.textContent=Cg),Pm=l(s),Va=p(s,"P",{"data-svelte-h":!0}),o(Va)!=="svelte-1b8rrkf"&&(Va.textContent=Lg),Fm=l(s),g(Aa.$$.fragment,s),Km=l(s),Ea=p(s,"P",{"data-svelte-h":!0}),o(Ea)!=="svelte-jl1fz0"&&(Ea.innerHTML=zg),Dm=l(s),g(Sa.$$.fragment,s),Om=l(s),Ya=p(s,"P",{"data-svelte-h":!0}),o(Ya)!=="svelte-gk4woy"&&(Ya.textContent=Gg),so=l(s),Pa=p(s,"P",{"data-svelte-h":!0}),o(Pa)!=="svelte-1lt2th7"&&(Pa.textContent=Bg),to=l(s),g(Fa.$$.fragment,s),ao=l(s),Ka=p(s,"P",{"data-svelte-h":!0}),o(Ka)!=="svelte-1hx5pt6"&&(Ka.innerHTML=$g),eo=l(s),g(Da.$$.fragment,s),no=l(s),Oa=p(s,"P",{"data-svelte-h":!0}),o(Oa)!=="svelte-1i10a94"&&(Oa.textContent=Zg),lo=l(s),se=p(s,"UL",{"data-svelte-h":!0}),o(se)!=="svelte-1ti1vbk"&&(se.innerHTML=Ig),io=l(s),te=p(s,"P",{"data-svelte-h":!0}),o(te)!=="svelte-jqprou"&&(te.innerHTML=Hg),po=l(s),ae=p(s,"UL",{"data-svelte-h":!0}),o(ae)!=="svelte-ig4ec7"&&(ae.innerHTML=Wg),mo=l(s),ee=p(s,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-awpy0j"&&(ee.innerHTML=Qg),oo=l(s),ne=p(s,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-152e8kl"&&(ne.textContent=Ng),ro=l(s),le=p(s,"UL",{"data-svelte-h":!0}),o(le)!=="svelte-k4f0dn"&&(le.innerHTML=Rg),ho=l(s),ie=p(s,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-wxdkvm"&&(ie.textContent=qg),co=l(s),g(pe.$$.fragment,s),uo=l(s),O=p(s,"P",{});var el=v(O);Sc=h(el,`Self-attention puts each token in relation to each other’s tokens.
As an example, the `),go=u(el,!1),fo=h(el," matrix of the text input sequence "),Tn=p(el,"EM",{"data-svelte-h":!0}),o(Tn)!=="svelte-13ogmf8"&&(Tn.textContent=Xg),Yc=h(el," could look as follows:"),el.forEach(a),yo=l(s),me=p(s,"P",{"data-svelte-h":!0}),o(me)!=="svelte-7ssrcl"&&(me.innerHTML=Vg),wo=l(s),oe=p(s,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-1xg4o0y"&&(oe.innerHTML=Ag),bo=l(s),G=p(s,"P",{});var P=v(G);Pc=h(P,`A LLM based on self-attention, but without position embeddings would have great difficulties in understanding the positions of the text inputs to each other.
This is because the probability score computed by `),vo=u(P,!1),Mo=h(P," relates each word token to each other word token in "),xo=u(P,!1),ko=h(P,` computations regardless of their relative positional distance to each other.
Therefore, for the LLM without position embeddings each token appears to have the same distance to all other tokens, `),_n=p(P,"EM",{"data-svelte-h":!0}),o(_n)!=="svelte-2dbwd4"&&(_n.textContent=Eg),Fc=h(P," differentiating between "),jn=p(P,"EM",{"data-svelte-h":!0}),o(jn)!=="svelte-1u1601v"&&(jn.textContent=Sg),Kc=h(P," and "),Un=p(P,"EM",{"data-svelte-h":!0}),o(Un)!=="svelte-16pe0y3"&&(Un.textContent=Yg),Dc=h(P," would be very challenging."),P.forEach(a),To=l(s),re=p(s,"P",{"data-svelte-h":!0}),o(re)!=="svelte-10v2cm"&&(re.innerHTML=Pg),_o=l(s),U=p(s,"P",{});var I=v(U);Oc=h(I,"The authors of the "),cs=p(I,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(cs)!=="svelte-507xi2"&&(cs.innerHTML=Fg),su=h(I," paper introduced sinusoidal positional embeddings "),jo=u(I,!1),Uo=h(I,` .
where each vector `),Jo=u(I,!1),Co=h(I," is computed as a sinusoidal function of its position "),Lo=u(I,!1),zo=h(I,` .
The positional encodings are then simply added to the input sequence vectors `),Go=u(I,!1),Bo=h(I," = "),$o=u(I,!1),Zo=h(I," thereby cueing the model to better learn sentence order."),I.forEach(a),Io=l(s),ss=p(s,"P",{});var nl=v(ss);tu=h(nl,"Instead of using fixed position embeddings, others (such as "),us=p(nl,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(us)!=="svelte-1j8obl2"&&(us.textContent=Kg),au=h(nl,`) used learned positional encodings for which the positional embeddings
`),Ho=u(nl,!1),Wo=h(nl," are learned during training."),nl.forEach(a),Qo=l(s),he=p(s,"P",{"data-svelte-h":!0}),o(he)!=="svelte-gfh3nk"&&(he.textContent=Dg),No=l(s),ds=p(s,"OL",{});var xc=v(ds);Q=p(xc,"LI",{});var ns=v(Q);eu=h(ns,"Sinusoidal and learned position embeddings are both absolute positional embeddings, "),Jn=p(ns,"EM",{"data-svelte-h":!0}),o(Jn)!=="svelte-1636wt6"&&(Jn.textContent=Og),nu=h(ns," encoding a unique embedding for each position id: "),Ro=u(ns,!1),qo=h(ns," . As shown by "),gs=p(ns,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(gs)!=="svelte-1elqrnk"&&(gs.textContent=sf),lu=h(ns," and "),fs=p(ns,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(fs)!=="svelte-sksjon"&&(fs.textContent=tf),iu=h(ns,", absolute positional embeddings lead to poor LLM performance for long text inputs. For long text inputs, it is advantageous if the model learns the relative positional distance input tokens have to each other instead of their absolute position."),ns.forEach(a),pu=l(xc),ce=p(xc,"LI",{});var kc=v(ce);mu=h(kc,"When using learned position embeddings, the LLM has to be trained on a fixed input length "),Xo=u(kc,!1),Vo=h(kc,", which makes it difficult to extrapolate to an input length longer than what it was trained on."),kc.forEach(a),xc.forEach(a),Ao=l(s),ue=p(s,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-pzlnat"&&(ue.textContent=af),Eo=l(s),de=p(s,"UL",{"data-svelte-h":!0}),o(de)!=="svelte-1q2i0ic"&&(de.innerHTML=ef),So=l(s),A=p(s,"P",{});var Us=v(A);ou=h(Us,"Both "),Cn=p(Us,"EM",{"data-svelte-h":!0}),o(Cn)!=="svelte-1koqbni"&&(Cn.textContent=nf),ru=h(Us," and "),Ln=p(Us,"EM",{"data-svelte-h":!0}),o(Ln)!=="svelte-4g6i8t"&&(Ln.textContent=lf),hu=h(Us," argue that it’s best to cue the LLM about sentence order directly in the self-attention algorithm as it’s there that word tokens are put into relation with each other. More specifically, sentence order should be cued by modifying the "),Yo=u(Us,!1),Po=h(Us," computation."),Us.forEach(a),Fo=l(s),T=p(s,"P",{});var B=v(T);cu=h(B,"Without going into too many details, "),zn=p(B,"EM",{"data-svelte-h":!0}),o(zn)!=="svelte-1koqbni"&&(zn.textContent=pf),uu=h(B," notes that positional information can be encoded into query-key pairs, "),Gn=p(B,"EM",{"data-svelte-h":!0}),o(Gn)!=="svelte-2dbwd4"&&(Gn.textContent=mf),du=l(B),Ko=u(B,!1),Do=h(B," and "),Oo=u(B,!1),sr=h(B," by rotating each vector by an angle "),tr=u(B,!1),ar=h(B," and "),er=u(B,!1),nr=h(B," respectively with "),lr=u(B,!1),ir=h(B," describing each vectors sentence position:"),B.forEach(a),pr=l(s),Bn=p(s,"P",{});var wy=v(Bn);mr=u(wy,!1),wy.forEach(a),or=l(s),F=p(s,"P",{});var rn=v(F);rr=u(rn,!1),hr=h(rn," thereby represents a rotational matrix. "),cr=u(rn,!1),ur=h(rn," is "),$n=p(rn,"EM",{"data-svelte-h":!0}),o($n)!=="svelte-r5iszh"&&($n.textContent=of),gu=h(rn," learned during training, but instead set to a pre-defined value that depends on the maximum input sequence length during training."),rn.forEach(a),dr=l(s),Zn=p(s,"BLOCKQUOTE",{});var by=v(Zn);L=p(by,"P",{});var H=v(L);fu=h(H,"By doing so, the propability score between "),gr=u(H,!1),fr=h(H," and "),yr=u(H,!1),wr=h(H," is only affected if "),br=u(H,!1),vr=h(H," and solely depends on the relative distance "),Mr=u(H,!1),xr=h(H," regardless of each vector’s specific positions "),kr=u(H,!1),Tr=h(H," and "),_r=u(H,!1),jr=h(H," ."),H.forEach(a),by.forEach(a),Ur=l(s),ge=p(s,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-1ct7c61"&&(ge.innerHTML=rf),Jr=l(s),fe=p(s,"UL",{"data-svelte-h":!0}),o(fe)!=="svelte-1ggqrue"&&(fe.innerHTML=hf),Cr=l(s),E=p(s,"P",{});var Js=v(E);yu=h(Js,"As an alternative, "),In=p(Js,"EM",{"data-svelte-h":!0}),o(In)!=="svelte-4g6i8t"&&(In.textContent=cf),wu=h(Js," proposes a much simpler relative position encoding scheme. The relative distance that input tokens have to each other is added as a negative integer scaled by a pre-defined value "),Hn=p(Js,"CODE",{"data-svelte-h":!0}),o(Hn)!=="svelte-1gskrin"&&(Hn.textContent=uf),bu=h(Js," to each query-key entry of the "),Lr=u(Js,!1),zr=h(Js," matrix right before the softmax computation."),Js.forEach(a),Gr=l(s),ye=p(s,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-1sb0gvf"&&(ye.innerHTML=df),Br=l(s),we=p(s,"P",{"data-svelte-h":!0}),o(we)!=="svelte-1stpbxv"&&(we.innerHTML=gf),$r=l(s),be=p(s,"P",{"data-svelte-h":!0}),o(be)!=="svelte-3uyjm"&&(be.innerHTML=ff),Zr=l(s),ve=p(s,"UL",{"data-svelte-h":!0}),o(ve)!=="svelte-l3k8fx"&&(ve.innerHTML=yf),Ir=l(s),x=p(s,"P",{});var k=v(x);vu=h(k,"Both "),Wn=p(k,"EM",{"data-svelte-h":!0}),o(Wn)!=="svelte-1koqbni"&&(Wn.textContent=wf),Mu=h(k," and "),Qn=p(k,"EM",{"data-svelte-h":!0}),o(Qn)!=="svelte-4g6i8t"&&(Qn.textContent=bf),xu=h(k," position encodings can extrapolate to input lengths not seen during training whereas it has been shown that extrapolation works much better out-of-the-box for "),Nn=p(k,"EM",{"data-svelte-h":!0}),o(Nn)!=="svelte-4g6i8t"&&(Nn.textContent=vf),ku=h(k," as compared to "),Rn=p(k,"EM",{"data-svelte-h":!0}),o(Rn)!=="svelte-1koqbni"&&(Rn.textContent=Mf),Tu=h(k,`.
For ALiBi, one simply increases the values of the lower triangular position matrix to match the length of the input sequence.
For `),qn=p(k,"EM",{"data-svelte-h":!0}),o(qn)!=="svelte-1koqbni"&&(qn.textContent=xf),_u=h(k,", keeping the same "),Hr=u(k,!1),Wr=h(k," that was used during training leads to poor results when passing text inputs much longer than those seen during training, "),Xn=p(k,"EM",{"data-svelte-h":!0}),o(Xn)!=="svelte-6ye6px"&&(Xn.textContent=kf),ju=l(k),ys=p(k,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(ys)!=="svelte-1wv3alf"&&(ys.textContent=Tf),Uu=h(k,". However, the community has found a couple of effective tricks that adapt "),Qr=u(k,!1),Nr=h(k,", thereby allowing "),Vn=p(k,"EM",{"data-svelte-h":!0}),o(Vn)!=="svelte-1koqbni"&&(Vn.textContent=_f),Ju=h(k," position embeddings to work well for extrapolated text input sequences (see "),ws=p(k,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(ws)!=="svelte-ax8fr8"&&(ws.textContent=jf),Cu=h(k,")."),k.forEach(a),Rr=l(s),bs=p(s,"BLOCKQUOTE",{});var Tc=v(bs);An=p(Tc,"P",{"data-svelte-h":!0}),o(An)!=="svelte-1bw79ap"&&(An.innerHTML=Uf),Lu=l(Tc),ms=p(Tc,"UL",{});var ll=v(ms);Me=p(ll,"LI",{});var _c=v(Me);zu=h(_c,"Positional cues about the text inputs should be given directly to the "),qr=u(_c,!1),Xr=h(_c," matrix of the self-attention layer"),_c.forEach(a),Gu=l(ll),En=p(ll,"LI",{"data-svelte-h":!0}),o(En)!=="svelte-lwsxvy"&&(En.innerHTML=Jf),Bu=l(ll),Sn=p(ll,"LI",{"data-svelte-h":!0}),o(Sn)!=="svelte-as1kp0"&&(Sn.textContent=Cf),ll.forEach(a),Tc.forEach(a),Vr=l(s),S=p(s,"P",{});var Cs=v(S);$u=h(Cs,"In conclusion, LLMs that are intended to be deployed in tasks that require handling large text inputs are better trained with relative positional embeddings, such as RoPE and ALiBi. Also note that even if an LLM with RoPE and ALiBi has been trained only on a fixed length of say "),Ar=u(Cs,!1),Er=h(Cs," it can still be used in practice with text inputs much larger than "),Sr=u(Cs,!1),Yr=h(Cs,", like "),Pr=u(Cs,!1),Fr=h(Cs," by extrapolating the positional embeddings."),Cs.forEach(a),Kr=l(s),g(xe.$$.fragment,s),Dr=l(s),ke=p(s,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-ph4j6j"&&(ke.textContent=Lf),Or=l(s),Te=p(s,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-583sqe"&&(Te.innerHTML=zf),sh=l(s),_e=p(s,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-809dal"&&(_e.innerHTML=Gf),th=l(s),g(je.$$.fragment,s),ah=l(s),Ue=p(s,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-jl1fz0"&&(Ue.innerHTML=Bf),eh=l(s),g(Je.$$.fragment,s),nh=l(s),Ce=p(s,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-1hvw6ou"&&(Ce.textContent=$f),lh=l(s),Le=p(s,"P",{"data-svelte-h":!0}),o(Le)!=="svelte-cclyh"&&(Le.innerHTML=Zf),ih=l(s),J=p(s,"P",{});var W=v(J);Zu=h(W,"As a consequence, tokens "),Yn=p(W,"EM",{"data-svelte-h":!0}),o(Yn)!=="svelte-1pjm1n8"&&(Yn.textContent=If),Iu=h(W," depend on previous tokens, more specifically the "),ph=u(W,!1),mh=h(W," vector is never put in relation with any key, values vectors "),oh=u(W,!1),rh=h(W," if "),hh=u(W,!1),ch=h(W," . Instead "),uh=u(W,!1),dh=h(W," only attends to previous key-value vectors "),gh=u(W,!1),fh=h(W,". In order to reduce unnecessary computation, one can therefore cache each layer’s key-value vectors for all previous timesteps."),W.forEach(a),yh=l(s),ze=p(s,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-1f21m0a"&&(ze.innerHTML=Hf),wh=l(s),g(Ge.$$.fragment,s),bh=l(s),Be=p(s,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-jl1fz0"&&(Be.innerHTML=Wf),vh=l(s),g($e.$$.fragment,s),Mh=l(s),Ze=p(s,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-sjvt58"&&(Ze.innerHTML=Qf),xh=l(s),Pn=p(s,"BLOCKQUOTE",{});var vy=v(Pn);N=p(vy,"P",{});var ls=v(N);Hu=h(ls,"Making use of the key-value cache means that the "),kh=u(ls,!1),Th=h(ls," is essentially reduced to "),_h=u(ls,!1),jh=h(ls," with "),Uh=u(ls,!1),Jh=h(ls," being the query projection of the currently passed input token which is "),Fn=p(ls,"EM",{"data-svelte-h":!0}),o(Fn)!=="svelte-x3mkar"&&(Fn.textContent=Nf),Wu=h(ls," just a single vector."),ls.forEach(a),vy.forEach(a),Ch=l(s),Ie=p(s,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-1xsdpw0"&&(Ie.textContent=Rf),Lh=l(s),vs=p(s,"UL",{});var jc=v(vs);He=p(jc,"LI",{});var Uc=v(He);Qu=h(Uc,"Significant increase in computational efficiency as less computations are performed compared to computing the full "),zh=u(Uc,!1),Gh=h(Uc," matrix. This leads to an increase in inference speed"),Uc.forEach(a),Nu=l(jc),Kn=p(jc,"LI",{"data-svelte-h":!0}),o(Kn)!=="svelte-1uy8i0e"&&(Kn.textContent=qf),jc.forEach(a),Bh=l(s),We=p(s,"BLOCKQUOTE",{"data-svelte-h":!0}),o(We)!=="svelte-ecu5gq"&&(We.innerHTML=Xf),$h=l(s),Qe=p(s,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-lkbxcr"&&(Qe.textContent=Vf),Zh=l(s),g(Ne.$$.fragment,s),Ih=l(s),Re=p(s,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-1nmendz"&&(Re.textContent=Af),Hh=l(s),qe=p(s,"UL",{"data-svelte-h":!0}),o(qe)!=="svelte-g7cmgx"&&(qe.innerHTML=Ef),Wh=l(s),Xe=p(s,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-cqzbwt"&&(Xe.textContent=Sf),Qh=l(s),Ve=p(s,"OL",{"data-svelte-h":!0}),o(Ve)!=="svelte-1bgwi27"&&(Ve.innerHTML=Yf),Nh=l(s),ts=p(s,"P",{});var il=v(ts);Ru=h(il,"There is however one catch. While the required peak memory for the "),Rh=u(il,!1),qh=h(il," matrix is significantly reduced, holding the key-value cache in memory can become very memory expensive for long input sequences or multi-turn chat. Remember that the key-value cache needs to store the key-value vectors for all previous input vectors "),Xh=u(il,!1),Vh=h(il," for all self-attention layers and for all attention heads."),il.forEach(a),Ah=l(s),Ae=p(s,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-hoekyy"&&(Ae.innerHTML=Pf),Eh=l(s),g(Ee.$$.fragment,s),Sh=l(s),Se=p(s,"P",{"data-svelte-h":!0}),o(Se)!=="svelte-jl1fz0"&&(Se.innerHTML=Ff),Yh=l(s),g(Ye.$$.fragment,s),Ph=l(s),Pe=p(s,"P",{"data-svelte-h":!0}),o(Pe)!=="svelte-19el5ck"&&(Pe.innerHTML=Kf),Fh=l(s),Fe=p(s,"OL",{"data-svelte-h":!0}),o(Fe)!=="svelte-179mx96"&&(Fe.innerHTML=Df),Kh=l(s),Ke=p(s,"P",{"data-svelte-h":!0}),o(Ke)!=="svelte-ritjb3"&&(Ke.innerHTML=Of),Dh=l(s),Dn=p(s,"BLOCKQUOTE",{});var My=v(Dn);os=p(My,"P",{});var pl=v(os);qu=h(pl,"By using a single head-value projection weight pair, the key value vectors "),Oh=u(pl,!1),sc=h(pl," have to be identical across all attention heads which in turn means that we only need to store 1 key-value projection pair in the cache instead of "),On=p(pl,"CODE",{"data-svelte-h":!0}),o(On)!=="svelte-6j0g1x"&&(On.textContent=sy),Xu=h(pl," ones."),pl.forEach(a),My.forEach(a),tc=l(s),De=p(s,"P",{"data-svelte-h":!0}),o(De)!=="svelte-16lijvq"&&(De.textContent=ty),ac=l(s),as=p(s,"P",{});var ml=v(as);Vu=h(ml,`In addition to memory savings, MQA also leads to improved computational efficiency as explained in the following.
In auto-regressive decoding, large key-value vectors need to be reloaded, concatenated with the current key-value vector pair to be then fed into the `),ec=u(ml,!1),nc=h(ml," computation at every step. For auto-regressive decoding, the required memory bandwidth for the constant reloading can become a serious time bottleneck. By reducing the size of the key-value vectors less memory needs to be accessed, thus reducing the memory bandwidth bottleneck. For more detail, please have a look at "),Ms=p(ml,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(Ms)!=="svelte-cg4wmi"&&(Ms.textContent=ay),Au=h(ml,"."),ml.forEach(a),lc=l(s),xs=p(s,"P",{});var Jc=v(xs);Eu=h(Jc,"The important part to understand here is that reducing the number of key-value attention heads to 1 only makes sense if a key-value cache is used. The peak memory consumption of the model for a single forward pass without key-value cache stays unchanged as every attention head still has a unique query vector so that each attention head still has a different "),ic=u(Jc,!1),pc=h(Jc," matrix."),Jc.forEach(a),mc=l(s),Oe=p(s,"P",{"data-svelte-h":!0}),o(Oe)!=="svelte-1q4ym7y"&&(Oe.textContent=ey),oc=l(s),sn=p(s,"UL",{"data-svelte-h":!0}),o(sn)!=="svelte-c4p3y"&&(sn.innerHTML=ny),rc=l(s),tn=p(s,"P",{"data-svelte-h":!0}),o(tn)!=="svelte-fzvfyw"&&(tn.innerHTML=ly),hc=l(s),ks=p(s,"OL",{start:!0,"data-svelte-h":!0}),o(ks)!=="svelte-e4z24x"&&(ks.innerHTML=iy),cc=l(s),an=p(s,"P",{"data-svelte-h":!0}),o(an)!=="svelte-jkms2s"&&(an.innerHTML=py),uc=l(s),en=p(s,"P",{"data-svelte-h":!0}),o(en)!=="svelte-1rn3bde"&&(en.innerHTML=my),dc=l(s),nn=p(s,"P",{"data-svelte-h":!0}),o(nn)!=="svelte-c4mo8y"&&(nn.innerHTML=oy),gc=l(s),ln=p(s,"BLOCKQUOTE",{"data-svelte-h":!0}),o(ln)!=="svelte-xhly52"&&(ln.innerHTML=ry),fc=l(s),g(pn.$$.fragment,s),yc=l(s),mn=p(s,"P",{"data-svelte-h":!0}),o(mn)!=="svelte-1r7m8vw"&&(mn.innerHTML=hy),wc=l(s),on=p(s,"P",{"data-svelte-h":!0}),o(on)!=="svelte-2w30uj"&&(on.innerHTML=cy),bc=l(s),rl=p(s,"P",{}),v(rl).forEach(a),this.h()},h(){_(is,"name","hf:doc:metadata"),_(is,"content",ab),oi.a=ri,hi.a=ci,ui.a=di,fi.a=null,bi.a=null,Yi.a=Pi,Fi.a=Ki,op.a=rp,cp.a=up,dp.a=gp,fp.a=yp,bp.a=null,Mp.a=xp,kp.a=Tp,_p.a=jp,Up.a=Jp,Cp.a=Lp,zp.a=Gp,$p.a=Zp,Ip.a=Hp,Wp.a=Qp,Np.a=Rp,qp.a=Xp,Vp.a=Ap,Pp.a=Fp,_(rs,"href","https://arxiv.org/abs/2205.14135"),_(rs,"rel","nofollow"),Dp.a=Op,tm.a=null,em.a=nm,lm.a=im,pm.a=mm,om.a=rm,dm.a=gm,bm.a=vm,go.a=fo,vo.a=Mo,xo.a=ko,_(cs,"href","https://arxiv.org/abs/1706.03762"),_(cs,"rel","nofollow"),jo.a=Uo,Jo.a=Co,Lo.a=zo,Go.a=Bo,$o.a=Zo,_(us,"href","https://arxiv.org/abs/1810.04805"),_(us,"rel","nofollow"),Ho.a=Wo,Ro.a=qo,_(gs,"href","https://arxiv.org/abs/2009.13658"),_(gs,"rel","nofollow"),_(fs,"href","https://arxiv.org/abs/2104.09864"),_(fs,"rel","nofollow"),Xo.a=Vo,Yo.a=Po,Ko.a=Do,Oo.a=sr,tr.a=ar,er.a=nr,lr.a=ir,mr.a=null,rr.a=hr,cr.a=ur,gr.a=fr,yr.a=wr,br.a=vr,Mr.a=xr,kr.a=Tr,_r.a=jr,Lr.a=zr,Hr.a=Wr,_(ys,"href","https://arxiv.org/abs/2108.12409"),_(ys,"rel","nofollow"),Qr.a=Nr,_(ws,"href","https://github.com/huggingface/transformers/pull/24653"),_(ws,"rel","nofollow"),qr.a=Xr,Ar.a=Er,Sr.a=Yr,Pr.a=Fr,ph.a=mh,oh.a=rh,hh.a=ch,uh.a=dh,gh.a=fh,kh.a=Th,_h.a=jh,Uh.a=Jh,zh.a=Gh,Rh.a=qh,Xh.a=Vh,Oh.a=sc,ec.a=nc,_(Ms,"href","https://arxiv.org/abs/1911.02150"),_(Ms,"rel","nofollow"),ic.a=pc,_(ks,"start","2")},m(s,t){m(document.head,is),e(s,hl,t),e(s,ol,t),e(s,cl,t),f(Ls,s,t),e(s,ul,t),f(zs,s,t),e(s,dl,t),e(s,Gs,t),e(s,gl,t),e(s,Bs,t),e(s,fl,t),e(s,$s,t),e(s,yl,t),e(s,Zs,t),e(s,wl,t),e(s,Is,t),e(s,bl,t),e(s,Hs,t),e(s,vl,t),f(Ws,s,t),e(s,Ml,t),e(s,Qs,t),e(s,xl,t),e(s,Ns,t),e(s,kl,t),e(s,Rs,t),e(s,Tl,t),e(s,qs,t),e(s,_l,t),e(s,Xs,t),e(s,jl,t),e(s,Vs,t),e(s,Ul,t),e(s,As,t),e(s,Jl,t),e(s,Es,t),e(s,Cl,t),e(s,Ss,t),e(s,Ll,t),e(s,Ys,t),e(s,zl,t),e(s,Ps,t),e(s,Gl,t),e(s,Fs,t),e(s,Bl,t),f(Ks,s,t),e(s,$l,t),f(Ds,s,t),e(s,Zl,t),e(s,Os,t),e(s,Il,t),e(s,st,t),e(s,Hl,t),e(s,tt,t),e(s,Wl,t),e(s,at,t),e(s,Ql,t),f(et,s,t),e(s,Nl,t),f(nt,s,t),e(s,Rl,t),e(s,lt,t),e(s,ql,t),f(it,s,t),e(s,Xl,t),e(s,pt,t),e(s,Vl,t),f(mt,s,t),e(s,Al,t),e(s,ot,t),e(s,El,t),f(rt,s,t),e(s,Sl,t),e(s,ht,t),e(s,Yl,t),f(ct,s,t),e(s,Pl,t),e(s,ut,t),e(s,Fl,t),e(s,dt,t),e(s,Kl,t),e(s,gt,t),e(s,Dl,t),e(s,ft,t),e(s,Ol,t),f(yt,s,t),e(s,si,t),e(s,wt,t),e(s,ti,t),f(bt,s,t),e(s,ai,t),e(s,vt,t),e(s,ei,t),f(Mt,s,t),e(s,ni,t),e(s,xt,t),e(s,li,t),e(s,kt,t),e(s,ii,t),e(s,Tt,t),e(s,pi,t),e(s,_t,t),e(s,mi,t),e(s,z,t),m(z,Cc),m(z,cn),m(z,Lc),oi.m(xy,z),m(z,ri),m(z,un),m(z,zc),hi.m(ky,z),m(z,ci),ui.m(Ty,z),m(z,di),e(s,gi,t),e(s,dn,t),fi.m(_y,dn),e(s,yi,t),e(s,jt,t),e(s,wi,t),e(s,gn,t),bi.m(jy,gn),e(s,vi,t),e(s,Ut,t),e(s,Mi,t),e(s,Jt,t),e(s,xi,t),f(Ct,s,t),e(s,ki,t),e(s,Lt,t),e(s,Ti,t),f(zt,s,t),e(s,_i,t),e(s,Gt,t),e(s,ji,t),f(Bt,s,t),e(s,Ui,t),e(s,$t,t),e(s,Ji,t),f(Zt,s,t),e(s,Ci,t),e(s,It,t),e(s,Li,t),f(Ht,s,t),e(s,zi,t),e(s,Wt,t),e(s,Gi,t),f(Qt,s,t),e(s,Bi,t),e(s,Nt,t),e(s,$i,t),e(s,Rt,t),e(s,Zi,t),f(qt,s,t),e(s,Ii,t),f(Xt,s,t),e(s,Hi,t),e(s,Vt,t),e(s,Wi,t),f(At,s,t),e(s,Qi,t),e(s,Et,t),e(s,Ni,t),f(St,s,t),e(s,Ri,t),e(s,Yt,t),e(s,qi,t),f(Pt,s,t),e(s,Xi,t),e(s,Ft,t),e(s,Vi,t),f(Kt,s,t),e(s,Ai,t),e(s,Dt,t),e(s,Ei,t),e(s,Ot,t),e(s,Si,t),e(s,K,t),m(K,Gc),Yi.m(Uy,K),m(K,Pi),Fi.m(Jy,K),m(K,Ki),e(s,Di,t),f(sa,s,t),e(s,Oi,t),f(ta,s,t),e(s,sp,t),e(s,aa,t),e(s,tp,t),e(s,ea,t),e(s,ap,t),e(s,na,t),e(s,ep,t),e(s,la,t),e(s,np,t),e(s,ia,t),e(s,lp,t),e(s,pa,t),e(s,ip,t),f(ma,s,t),e(s,pp,t),e(s,oa,t),e(s,mp,t),e(s,q,t),m(q,Bc),m(q,fn),m(q,$c),m(q,yn),m(q,Zc),op.m(Cy,q),m(q,rp),e(s,hp,t),e(s,X,t),m(X,Ic),cp.m(Ly,X),m(X,up),dp.m(zy,X),m(X,gp),fp.m(Gy,X),m(X,yp),e(s,wp,t),e(s,wn,t),bp.m(By,wn),e(s,vp,t),e(s,C,t),Mp.m($y,C),m(C,xp),kp.m(Zy,C),m(C,Tp),_p.m(Iy,C),m(C,jp),Up.m(Hy,C),m(C,Jp),Cp.m(Wy,C),m(C,Lp),zp.m(Qy,C),m(C,Gp),e(s,Bp,t),e(s,j,t),m(j,Hc),$p.m(Ny,j),m(j,Zp),Ip.m(Ry,j),m(j,Hp),Wp.m(qy,j),m(j,Qp),Np.m(Xy,j),m(j,Rp),qp.m(Vy,j),m(j,Xp),Vp.m(Ay,j),m(j,Ap),e(s,Ep,t),e(s,ra,t),e(s,Sp,t),e(s,ha,t),e(s,Yp,t),e(s,V,t),m(V,Wc),Pp.m(Ey,V),m(V,Fp),m(V,rs),m(V,Qc),m(V,bn),m(V,Nc),e(s,Kp,t),e(s,hs,t),m(hs,Rc),Dp.m(Sy,hs),m(hs,Op),e(s,sm,t),e(s,vn,t),tm.m(Yy,vn),e(s,am,t),e(s,$,t),m($,qc),em.m(Py,$),m($,nm),lm.m(Fy,$),m($,im),pm.m(Ky,$),m($,mm),om.m(Dy,$),m($,rm),e(s,hm,t),e(s,ca,t),e(s,cm,t),e(s,ua,t),e(s,um,t),e(s,Mn,t),m(Mn,ps),m(ps,Xc),m(ps,xn),m(ps,Vc),dm.m(Oy,ps),m(ps,gm),e(s,fm,t),e(s,da,t),e(s,ym,t),e(s,ga,t),e(s,wm,t),e(s,D,t),m(D,Ac),m(D,kn),m(D,Ec),bm.m(sw,D),m(D,vm),e(s,Mm,t),e(s,fa,t),e(s,xm,t),e(s,ya,t),e(s,km,t),e(s,wa,t),e(s,Tm,t),f(ba,s,t),e(s,_m,t),e(s,va,t),e(s,jm,t),f(Ma,s,t),e(s,Um,t),e(s,xa,t),e(s,Jm,t),f(ka,s,t),e(s,Cm,t),e(s,Ta,t),e(s,Lm,t),f(_a,s,t),e(s,zm,t),e(s,ja,t),e(s,Gm,t),f(Ua,s,t),e(s,Bm,t),e(s,Ja,t),e(s,$m,t),e(s,Ca,t),e(s,Zm,t),e(s,La,t),e(s,Im,t),f(za,s,t),e(s,Hm,t),e(s,Ga,t),e(s,Wm,t),f(Ba,s,t),e(s,Qm,t),e(s,$a,t),e(s,Nm,t),e(s,Za,t),e(s,Rm,t),f(Ia,s,t),e(s,qm,t),e(s,Ha,t),e(s,Xm,t),f(Wa,s,t),e(s,Vm,t),e(s,Qa,t),e(s,Am,t),f(Na,s,t),e(s,Em,t),e(s,Ra,t),e(s,Sm,t),f(qa,s,t),e(s,Ym,t),e(s,Xa,t),e(s,Pm,t),e(s,Va,t),e(s,Fm,t),f(Aa,s,t),e(s,Km,t),e(s,Ea,t),e(s,Dm,t),f(Sa,s,t),e(s,Om,t),e(s,Ya,t),e(s,so,t),e(s,Pa,t),e(s,to,t),f(Fa,s,t),e(s,ao,t),e(s,Ka,t),e(s,eo,t),f(Da,s,t),e(s,no,t),e(s,Oa,t),e(s,lo,t),e(s,se,t),e(s,io,t),e(s,te,t),e(s,po,t),e(s,ae,t),e(s,mo,t),e(s,ee,t),e(s,oo,t),e(s,ne,t),e(s,ro,t),e(s,le,t),e(s,ho,t),e(s,ie,t),e(s,co,t),f(pe,s,t),e(s,uo,t),e(s,O,t),m(O,Sc),go.m(tw,O),m(O,fo),m(O,Tn),m(O,Yc),e(s,yo,t),e(s,me,t),e(s,wo,t),e(s,oe,t),e(s,bo,t),e(s,G,t),m(G,Pc),vo.m(aw,G),m(G,Mo),xo.m(ew,G),m(G,ko),m(G,_n),m(G,Fc),m(G,jn),m(G,Kc),m(G,Un),m(G,Dc),e(s,To,t),e(s,re,t),e(s,_o,t),e(s,U,t),m(U,Oc),m(U,cs),m(U,su),jo.m(nw,U),m(U,Uo),Jo.m(lw,U),m(U,Co),Lo.m(iw,U),m(U,zo),Go.m(pw,U),m(U,Bo),$o.m(mw,U),m(U,Zo),e(s,Io,t),e(s,ss,t),m(ss,tu),m(ss,us),m(ss,au),Ho.m(ow,ss),m(ss,Wo),e(s,Qo,t),e(s,he,t),e(s,No,t),e(s,ds,t),m(ds,Q),m(Q,eu),m(Q,Jn),m(Q,nu),Ro.m(rw,Q),m(Q,qo),m(Q,gs),m(Q,lu),m(Q,fs),m(Q,iu),m(ds,pu),m(ds,ce),m(ce,mu),Xo.m(hw,ce),m(ce,Vo),e(s,Ao,t),e(s,ue,t),e(s,Eo,t),e(s,de,t),e(s,So,t),e(s,A,t),m(A,ou),m(A,Cn),m(A,ru),m(A,Ln),m(A,hu),Yo.m(cw,A),m(A,Po),e(s,Fo,t),e(s,T,t),m(T,cu),m(T,zn),m(T,uu),m(T,Gn),m(T,du),Ko.m(uw,T),m(T,Do),Oo.m(dw,T),m(T,sr),tr.m(gw,T),m(T,ar),er.m(fw,T),m(T,nr),lr.m(yw,T),m(T,ir),e(s,pr,t),e(s,Bn,t),mr.m(ww,Bn),e(s,or,t),e(s,F,t),rr.m(bw,F),m(F,hr),cr.m(vw,F),m(F,ur),m(F,$n),m(F,gu),e(s,dr,t),e(s,Zn,t),m(Zn,L),m(L,fu),gr.m(Mw,L),m(L,fr),yr.m(xw,L),m(L,wr),br.m(kw,L),m(L,vr),Mr.m(Tw,L),m(L,xr),kr.m(_w,L),m(L,Tr),_r.m(jw,L),m(L,jr),e(s,Ur,t),e(s,ge,t),e(s,Jr,t),e(s,fe,t),e(s,Cr,t),e(s,E,t),m(E,yu),m(E,In),m(E,wu),m(E,Hn),m(E,bu),Lr.m(Uw,E),m(E,zr),e(s,Gr,t),e(s,ye,t),e(s,Br,t),e(s,we,t),e(s,$r,t),e(s,be,t),e(s,Zr,t),e(s,ve,t),e(s,Ir,t),e(s,x,t),m(x,vu),m(x,Wn),m(x,Mu),m(x,Qn),m(x,xu),m(x,Nn),m(x,ku),m(x,Rn),m(x,Tu),m(x,qn),m(x,_u),Hr.m(Jw,x),m(x,Wr),m(x,Xn),m(x,ju),m(x,ys),m(x,Uu),Qr.m(Cw,x),m(x,Nr),m(x,Vn),m(x,Ju),m(x,ws),m(x,Cu),e(s,Rr,t),e(s,bs,t),m(bs,An),m(bs,Lu),m(bs,ms),m(ms,Me),m(Me,zu),qr.m(Lw,Me),m(Me,Xr),m(ms,Gu),m(ms,En),m(ms,Bu),m(ms,Sn),e(s,Vr,t),e(s,S,t),m(S,$u),Ar.m(zw,S),m(S,Er),Sr.m(Gw,S),m(S,Yr),Pr.m(Bw,S),m(S,Fr),e(s,Kr,t),f(xe,s,t),e(s,Dr,t),e(s,ke,t),e(s,Or,t),e(s,Te,t),e(s,sh,t),e(s,_e,t),e(s,th,t),f(je,s,t),e(s,ah,t),e(s,Ue,t),e(s,eh,t),f(Je,s,t),e(s,nh,t),e(s,Ce,t),e(s,lh,t),e(s,Le,t),e(s,ih,t),e(s,J,t),m(J,Zu),m(J,Yn),m(J,Iu),ph.m($w,J),m(J,mh),oh.m(Zw,J),m(J,rh),hh.m(Iw,J),m(J,ch),uh.m(Hw,J),m(J,dh),gh.m(Ww,J),m(J,fh),e(s,yh,t),e(s,ze,t),e(s,wh,t),f(Ge,s,t),e(s,bh,t),e(s,Be,t),e(s,vh,t),f($e,s,t),e(s,Mh,t),e(s,Ze,t),e(s,xh,t),e(s,Pn,t),m(Pn,N),m(N,Hu),kh.m(Qw,N),m(N,Th),_h.m(Nw,N),m(N,jh),Uh.m(Rw,N),m(N,Jh),m(N,Fn),m(N,Wu),e(s,Ch,t),e(s,Ie,t),e(s,Lh,t),e(s,vs,t),m(vs,He),m(He,Qu),zh.m(qw,He),m(He,Gh),m(vs,Nu),m(vs,Kn),e(s,Bh,t),e(s,We,t),e(s,$h,t),e(s,Qe,t),e(s,Zh,t),f(Ne,s,t),e(s,Ih,t),e(s,Re,t),e(s,Hh,t),e(s,qe,t),e(s,Wh,t),e(s,Xe,t),e(s,Qh,t),e(s,Ve,t),e(s,Nh,t),e(s,ts,t),m(ts,Ru),Rh.m(Xw,ts),m(ts,qh),Xh.m(Vw,ts),m(ts,Vh),e(s,Ah,t),e(s,Ae,t),e(s,Eh,t),f(Ee,s,t),e(s,Sh,t),e(s,Se,t),e(s,Yh,t),f(Ye,s,t),e(s,Ph,t),e(s,Pe,t),e(s,Fh,t),e(s,Fe,t),e(s,Kh,t),e(s,Ke,t),e(s,Dh,t),e(s,Dn,t),m(Dn,os),m(os,qu),Oh.m(Aw,os),m(os,sc),m(os,On),m(os,Xu),e(s,tc,t),e(s,De,t),e(s,ac,t),e(s,as,t),m(as,Vu),ec.m(Ew,as),m(as,nc),m(as,Ms),m(as,Au),e(s,lc,t),e(s,xs,t),m(xs,Eu),ic.m(Sw,xs),m(xs,pc),e(s,mc,t),e(s,Oe,t),e(s,oc,t),e(s,sn,t),e(s,rc,t),e(s,tn,t),e(s,hc,t),e(s,ks,t),e(s,cc,t),e(s,an,t),e(s,uc,t),e(s,en,t),e(s,dc,t),e(s,nn,t),e(s,gc,t),e(s,ln,t),e(s,fc,t),f(pn,s,t),e(s,yc,t),e(s,mn,t),e(s,wc,t),e(s,on,t),e(s,bc,t),e(s,rl,t),vc=!0},p:Pw,i(s){vc||(y(Ls.$$.fragment,s),y(zs.$$.fragment,s),y(Ws.$$.fragment,s),y(Ks.$$.fragment,s),y(Ds.$$.fragment,s),y(et.$$.fragment,s),y(nt.$$.fragment,s),y(it.$$.fragment,s),y(mt.$$.fragment,s),y(rt.$$.fragment,s),y(ct.$$.fragment,s),y(yt.$$.fragment,s),y(bt.$$.fragment,s),y(Mt.$$.fragment,s),y(Ct.$$.fragment,s),y(zt.$$.fragment,s),y(Bt.$$.fragment,s),y(Zt.$$.fragment,s),y(Ht.$$.fragment,s),y(Qt.$$.fragment,s),y(qt.$$.fragment,s),y(Xt.$$.fragment,s),y(At.$$.fragment,s),y(St.$$.fragment,s),y(Pt.$$.fragment,s),y(Kt.$$.fragment,s),y(sa.$$.fragment,s),y(ta.$$.fragment,s),y(ma.$$.fragment,s),y(ba.$$.fragment,s),y(Ma.$$.fragment,s),y(ka.$$.fragment,s),y(_a.$$.fragment,s),y(Ua.$$.fragment,s),y(za.$$.fragment,s),y(Ba.$$.fragment,s),y(Ia.$$.fragment,s),y(Wa.$$.fragment,s),y(Na.$$.fragment,s),y(qa.$$.fragment,s),y(Aa.$$.fragment,s),y(Sa.$$.fragment,s),y(Fa.$$.fragment,s),y(Da.$$.fragment,s),y(pe.$$.fragment,s),y(xe.$$.fragment,s),y(je.$$.fragment,s),y(Je.$$.fragment,s),y(Ge.$$.fragment,s),y($e.$$.fragment,s),y(Ne.$$.fragment,s),y(Ee.$$.fragment,s),y(Ye.$$.fragment,s),y(pn.$$.fragment,s),vc=!0)},o(s){w(Ls.$$.fragment,s),w(zs.$$.fragment,s),w(Ws.$$.fragment,s),w(Ks.$$.fragment,s),w(Ds.$$.fragment,s),w(et.$$.fragment,s),w(nt.$$.fragment,s),w(it.$$.fragment,s),w(mt.$$.fragment,s),w(rt.$$.fragment,s),w(ct.$$.fragment,s),w(yt.$$.fragment,s),w(bt.$$.fragment,s),w(Mt.$$.fragment,s),w(Ct.$$.fragment,s),w(zt.$$.fragment,s),w(Bt.$$.fragment,s),w(Zt.$$.fragment,s),w(Ht.$$.fragment,s),w(Qt.$$.fragment,s),w(qt.$$.fragment,s),w(Xt.$$.fragment,s),w(At.$$.fragment,s),w(St.$$.fragment,s),w(Pt.$$.fragment,s),w(Kt.$$.fragment,s),w(sa.$$.fragment,s),w(ta.$$.fragment,s),w(ma.$$.fragment,s),w(ba.$$.fragment,s),w(Ma.$$.fragment,s),w(ka.$$.fragment,s),w(_a.$$.fragment,s),w(Ua.$$.fragment,s),w(za.$$.fragment,s),w(Ba.$$.fragment,s),w(Ia.$$.fragment,s),w(Wa.$$.fragment,s),w(Na.$$.fragment,s),w(qa.$$.fragment,s),w(Aa.$$.fragment,s),w(Sa.$$.fragment,s),w(Fa.$$.fragment,s),w(Da.$$.fragment,s),w(pe.$$.fragment,s),w(xe.$$.fragment,s),w(je.$$.fragment,s),w(Je.$$.fragment,s),w(Ge.$$.fragment,s),w($e.$$.fragment,s),w(Ne.$$.fragment,s),w(Ee.$$.fragment,s),w(Ye.$$.fragment,s),w(pn.$$.fragment,s),vc=!1},d(s){s&&(a(hl),a(ol),a(cl),a(ul),a(dl),a(Gs),a(gl),a(Bs),a(fl),a($s),a(yl),a(Zs),a(wl),a(Is),a(bl),a(Hs),a(vl),a(Ml),a(Qs),a(xl),a(Ns),a(kl),a(Rs),a(Tl),a(qs),a(_l),a(Xs),a(jl),a(Vs),a(Ul),a(As),a(Jl),a(Es),a(Cl),a(Ss),a(Ll),a(Ys),a(zl),a(Ps),a(Gl),a(Fs),a(Bl),a($l),a(Zl),a(Os),a(Il),a(st),a(Hl),a(tt),a(Wl),a(at),a(Ql),a(Nl),a(Rl),a(lt),a(ql),a(Xl),a(pt),a(Vl),a(Al),a(ot),a(El),a(Sl),a(ht),a(Yl),a(Pl),a(ut),a(Fl),a(dt),a(Kl),a(gt),a(Dl),a(ft),a(Ol),a(si),a(wt),a(ti),a(ai),a(vt),a(ei),a(ni),a(xt),a(li),a(kt),a(ii),a(Tt),a(pi),a(_t),a(mi),a(z),a(gi),a(dn),a(yi),a(jt),a(wi),a(gn),a(vi),a(Ut),a(Mi),a(Jt),a(xi),a(ki),a(Lt),a(Ti),a(_i),a(Gt),a(ji),a(Ui),a($t),a(Ji),a(Ci),a(It),a(Li),a(zi),a(Wt),a(Gi),a(Bi),a(Nt),a($i),a(Rt),a(Zi),a(Ii),a(Hi),a(Vt),a(Wi),a(Qi),a(Et),a(Ni),a(Ri),a(Yt),a(qi),a(Xi),a(Ft),a(Vi),a(Ai),a(Dt),a(Ei),a(Ot),a(Si),a(K),a(Di),a(Oi),a(sp),a(aa),a(tp),a(ea),a(ap),a(na),a(ep),a(la),a(np),a(ia),a(lp),a(pa),a(ip),a(pp),a(oa),a(mp),a(q),a(hp),a(X),a(wp),a(wn),a(vp),a(C),a(Bp),a(j),a(Ep),a(ra),a(Sp),a(ha),a(Yp),a(V),a(Kp),a(hs),a(sm),a(vn),a(am),a($),a(hm),a(ca),a(cm),a(ua),a(um),a(Mn),a(fm),a(da),a(ym),a(ga),a(wm),a(D),a(Mm),a(fa),a(xm),a(ya),a(km),a(wa),a(Tm),a(_m),a(va),a(jm),a(Um),a(xa),a(Jm),a(Cm),a(Ta),a(Lm),a(zm),a(ja),a(Gm),a(Bm),a(Ja),a($m),a(Ca),a(Zm),a(La),a(Im),a(Hm),a(Ga),a(Wm),a(Qm),a($a),a(Nm),a(Za),a(Rm),a(qm),a(Ha),a(Xm),a(Vm),a(Qa),a(Am),a(Em),a(Ra),a(Sm),a(Ym),a(Xa),a(Pm),a(Va),a(Fm),a(Km),a(Ea),a(Dm),a(Om),a(Ya),a(so),a(Pa),a(to),a(ao),a(Ka),a(eo),a(no),a(Oa),a(lo),a(se),a(io),a(te),a(po),a(ae),a(mo),a(ee),a(oo),a(ne),a(ro),a(le),a(ho),a(ie),a(co),a(uo),a(O),a(yo),a(me),a(wo),a(oe),a(bo),a(G),a(To),a(re),a(_o),a(U),a(Io),a(ss),a(Qo),a(he),a(No),a(ds),a(Ao),a(ue),a(Eo),a(de),a(So),a(A),a(Fo),a(T),a(pr),a(Bn),a(or),a(F),a(dr),a(Zn),a(Ur),a(ge),a(Jr),a(fe),a(Cr),a(E),a(Gr),a(ye),a(Br),a(we),a($r),a(be),a(Zr),a(ve),a(Ir),a(x),a(Rr),a(bs),a(Vr),a(S),a(Kr),a(Dr),a(ke),a(Or),a(Te),a(sh),a(_e),a(th),a(ah),a(Ue),a(eh),a(nh),a(Ce),a(lh),a(Le),a(ih),a(J),a(yh),a(ze),a(wh),a(bh),a(Be),a(vh),a(Mh),a(Ze),a(xh),a(Pn),a(Ch),a(Ie),a(Lh),a(vs),a(Bh),a(We),a($h),a(Qe),a(Zh),a(Ih),a(Re),a(Hh),a(qe),a(Wh),a(Xe),a(Qh),a(Ve),a(Nh),a(ts),a(Ah),a(Ae),a(Eh),a(Sh),a(Se),a(Yh),a(Ph),a(Pe),a(Fh),a(Fe),a(Kh),a(Ke),a(Dh),a(Dn),a(tc),a(De),a(ac),a(as),a(lc),a(xs),a(mc),a(Oe),a(oc),a(sn),a(rc),a(tn),a(hc),a(ks),a(cc),a(an),a(uc),a(en),a(dc),a(nn),a(gc),a(ln),a(fc),a(yc),a(mn),a(wc),a(on),a(bc),a(rl)),a(is),b(Ls,s),b(zs,s),b(Ws,s),b(Ks,s),b(Ds,s),b(et,s),b(nt,s),b(it,s),b(mt,s),b(rt,s),b(ct,s),b(yt,s),b(bt,s),b(Mt,s),b(Ct,s),b(zt,s),b(Bt,s),b(Zt,s),b(Ht,s),b(Qt,s),b(qt,s),b(Xt,s),b(At,s),b(St,s),b(Pt,s),b(Kt,s),b(sa,s),b(ta,s),b(ma,s),b(ba,s),b(Ma,s),b(ka,s),b(_a,s),b(Ua,s),b(za,s),b(Ba,s),b(Ia,s),b(Wa,s),b(Na,s),b(qa,s),b(Aa,s),b(Sa,s),b(Fa,s),b(Da,s),b(pe,s),b(xe,s),b(je,s),b(Je,s),b(Ge,s),b($e,s),b(Ne,s),b(Ee,s),b(Ye,s),b(pn,s)}}}const ab='{"title":"Optimizing LLMs for Speed and Memory","local":"optimizing-llms-for-speed-and-memory","sections":[{"title":"1. Lower Precision","local":"1-lower-precision","sections":[],"depth":2}],"depth":1}';function eb(Su){return Fw(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ob extends Kw{constructor(is){super(),Dw(this,is,eb,tb,Yw,{})}}export{ob as component};
