import{s as As,n as Ns,o as Rs}from"../chunks/scheduler.56730f09.js";import{S as Gs,i as Ss,g as p,s as t,r as i,A as Fs,h as r,f as e,c as n,j as Qs,u as y,x as M,k as ks,y as xs,a as l,v as c,d as m,t as J,w as o}from"../chunks/index.61415d3e.js";import{C as h}from"../chunks/CodeBlock.e6fa6bff.js";import{H as Is}from"../chunks/Heading.9036b585.js";function zs(Cs){let T,x,S,z,j,E,U,fs="🤗 Transformersは、🤗 Transformersモデルのトレーニングを最適化する<code>Trainer</code>クラスを提供し、独自のトレーニングループを手動で記述せずにトレーニングを開始するのが簡単になります。<code>Trainer</code>はハイパーパラメーター検索のAPIも提供しています。このドキュメントでは、それを例示します。",D,u,L,w,bs=`<code>Trainer</code>は現在、4つのハイパーパラメーター検索バックエンドをサポートしています：
<a href="https://optuna.org/" rel="nofollow">optuna</a>、<a href="https://sigopt.com/" rel="nofollow">sigopt</a>、<a href="https://docs.ray.io/en/latest/tune/index.html" rel="nofollow">raytune</a>、および<a href="https://wandb.ai/site/sweeps" rel="nofollow">wandb</a>。`,P,d,gs="これらを使用する前に、ハイパーパラメーター検索バックエンドをインストールする必要があります。",K,I,O,C,ss,f,_s="ハイパーパラメータの検索スペースを定義し、異なるバックエンドには異なるフォーマットが必要です。",as,b,$s='Sigoptの場合、sigopt <a href="https://docs.sigopt.com/ai-module-api-references/api_reference/objects/object_parameter" rel="nofollow">object_parameter</a> を参照してください。それは以下のようなものです：',es,g,ls,_,qs='Optunaに関しては、<a href="https://optuna.readthedocs.io/en/stable/tutorial/10_key_features/002_configurations.html#sphx-glr-tutorial-10-key-features-002-configurations-py" rel="nofollow">object_parameter</a>をご覧ください。以下のようになります：',ts,$,ns,q,Xs='Optunaは、多目的のハイパーパラメータ最適化（HPO）を提供しています。 <code>hyperparameter_search</code> で <code>direction</code> を渡し、複数の目的関数値を返すための独自の <code>compute_objective</code> を定義することができます。 Pareto Front（<code>List[BestRun]</code>）は <code>hyperparameter_search</code> で返され、<a href="https://github.com/huggingface/transformers/blob/main/tests/trainer/test_trainer.py" rel="nofollow">test_trainer</a> のテストケース <code>TrainerHyperParameterMultiObjectOptunaIntegrationTest</code> を参照する必要があります。これは以下のようになります。',ps,X,rs,W,Ws='Ray Tuneに関して、<a href="https://docs.ray.io/en/latest/tune/api/search_space.html" rel="nofollow">object_parameter</a>を参照してください。以下のようになります：',Ms,B,is,Z,Bs='Wandbについては、<a href="https://docs.wandb.ai/guides/sweeps/configuration" rel="nofollow">object_parameter</a>をご覧ください。これは以下のようになります：',ys,Y,cs,V,Zs="<code>model_init</code> 関数を定義し、それを <code>Trainer</code> に渡す例を示します：",ms,v,Js,H,Ys="<code>Trainer</code> を <code>model_init</code> 関数、トレーニング引数、トレーニングデータセット、テストデータセット、および評価関数と共に作成してください:",os,Q,Ts,k,Vs="ハイパーパラメーターの探索を呼び出し、最良のトライアル パラメーターを取得します。バックエンドは <code>&quot;optuna&quot;</code> / <code>&quot;sigopt&quot;</code> / <code>&quot;wandb&quot;</code> / <code>&quot;ray&quot;</code> である可能性があります。方向は <code>&quot;minimize&quot;</code> または <code>&quot;maximize&quot;</code> であり、目標をより大きくするか小さくするかを示します。",hs,A,vs="<code>compute_objective</code> 関数を独自に定義することもできます。定義されていない場合、デフォルトの <code>compute_objective</code> が呼び出され、F1などの評価メトリックの合計が目標値として返されます。",js,N,Us,R,us,G,Hs="現在、DDP（Distributed Data Parallel）のためのハイパーパラメーター検索は、Optuna と SigOpt に対して有効になっています。ランクゼロプロセスのみが検索トライアルを生成し、他のランクに引数を渡します。",ws,F,ds;return j=new Is({props:{title:"Hyperparameter Search using Trainer API",local:"hyperparameter-search-using-trainer-api",headingTag:"h1"}}),u=new Is({props:{title:"Hyperparameter Search backend",local:"hyperparameter-search-backend",headingTag:"h2"}}),I=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMG9wdHVuYSUyRnNpZ29wdCUyRndhbmRiJTJGcmF5JTVCdHVuZSU1RCUyMA==",highlighted:"pip install optuna/sigopt/wandb/ray[tune] ",wrap:!1}}),C=new Is({props:{title:"How to enable Hyperparameter search in example",local:"how-to-enable-hyperparameter-search-in-example",headingTag:"h2"}}),g=new h({props:{code:"ZGVmJTIwc2lnb3B0X2hwX3NwYWNlKHRyaWFsKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMmJvdW5kcyUyMiUzQSUyMCU3QiUyMm1pbiUyMiUzQSUyMDFlLTYlMkMlMjAlMjJtYXglMjIlM0ElMjAxZS00JTdEJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMmxlYXJuaW5nX3JhdGUlMjIlMkMlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyZG91YmxlJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY2F0ZWdvcmljYWxfdmFsdWVzJTIyJTNBJTIwJTVCJTIyMTYlMjIlMkMlMjAlMjIzMiUyMiUyQyUyMCUyMjY0JTIyJTJDJTIwJTIyMTI4JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybmFtZSUyMiUzQSUyMCUyMnBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJjYXRlZ29yaWNhbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">sigopt_hp_space</span>(<span class="hljs-params">trial</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> [
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;bounds&quot;</span>: {<span class="hljs-string">&quot;min&quot;</span>: <span class="hljs-number">1e-6</span>, <span class="hljs-string">&quot;max&quot;</span>: <span class="hljs-number">1e-4</span>}, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;learning_rate&quot;</span>, <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;double&quot;</span>},
<span class="hljs-meta">... </span>        {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;categorical_values&quot;</span>: [<span class="hljs-string">&quot;16&quot;</span>, <span class="hljs-string">&quot;32&quot;</span>, <span class="hljs-string">&quot;64&quot;</span>, <span class="hljs-string">&quot;128&quot;</span>],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;per_device_train_batch_size&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;categorical&quot;</span>,
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    ]`,wrap:!1}}),$=new h({props:{code:"ZGVmJTIwb3B0dW5hX2hwX3NwYWNlKHRyaWFsKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxlYXJuaW5nX3JhdGUlMjIlM0ElMjB0cmlhbC5zdWdnZXN0X2Zsb2F0KCUyMmxlYXJuaW5nX3JhdGUlMjIlMkMlMjAxZS02JTJDJTIwMWUtNCUyQyUyMGxvZyUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIyJTNBJTIwdHJpYWwuc3VnZ2VzdF9jYXRlZ29yaWNhbCglMjJwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjIlMkMlMjAlNUIxNiUyQyUyMDMyJTJDJTIwNjQlMkMlMjAxMjglNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTdE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">optuna_hp_space</span>(<span class="hljs-params">trial</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;learning_rate&quot;</span>: trial.suggest_float(<span class="hljs-string">&quot;learning_rate&quot;</span>, <span class="hljs-number">1e-6</span>, <span class="hljs-number">1e-4</span>, log=<span class="hljs-literal">True</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;per_device_train_batch_size&quot;</span>: trial.suggest_categorical(<span class="hljs-string">&quot;per_device_train_batch_size&quot;</span>, [<span class="hljs-number">16</span>, <span class="hljs-number">32</span>, <span class="hljs-number">64</span>, <span class="hljs-number">128</span>]),
<span class="hljs-meta">... </span>    }`,wrap:!1}}),X=new h({props:{code:"YmVzdF90cmlhbHMlMjAlM0QlMjB0cmFpbmVyLmh5cGVycGFyYW1ldGVyX3NlYXJjaCglMEElMjAlMjAlMjAlMjBkaXJlY3Rpb24lM0QlNUIlMjJtaW5pbWl6ZSUyMiUyQyUyMCUyMm1heGltaXplJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwYmFja2VuZCUzRCUyMm9wdHVuYSUyMiUyQyUwQSUyMCUyMCUyMCUyMGhwX3NwYWNlJTNEb3B0dW5hX2hwX3NwYWNlJTJDJTBBJTIwJTIwJTIwJTIwbl90cmlhbHMlM0QyMCUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfb2JqZWN0aXZlJTNEY29tcHV0ZV9vYmplY3RpdmUlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>best_trials = trainer.hyperparameter_search(
<span class="hljs-meta">... </span>    direction=[<span class="hljs-string">&quot;minimize&quot;</span>, <span class="hljs-string">&quot;maximize&quot;</span>],
<span class="hljs-meta">... </span>    backend=<span class="hljs-string">&quot;optuna&quot;</span>,
<span class="hljs-meta">... </span>    hp_space=optuna_hp_space,
<span class="hljs-meta">... </span>    n_trials=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    compute_objective=compute_objective,
<span class="hljs-meta">... </span>)`,wrap:!1}}),B=new h({props:{code:"ZGVmJTIwcmF5X2hwX3NwYWNlKHRyaWFsKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxlYXJuaW5nX3JhdGUlMjIlM0ElMjB0dW5lLmxvZ3VuaWZvcm0oMWUtNiUyQyUyMDFlLTQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIyJTNBJTIwdHVuZS5jaG9pY2UoJTVCMTYlMkMlMjAzMiUyQyUyMDY0JTJDJTIwMTI4JTVEKSUyQyUwQSUyMCUyMCUyMCUyMCU3RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">ray_hp_space</span>(<span class="hljs-params">trial</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;learning_rate&quot;</span>: tune.loguniform(<span class="hljs-number">1e-6</span>, <span class="hljs-number">1e-4</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;per_device_train_batch_size&quot;</span>: tune.choice([<span class="hljs-number">16</span>, <span class="hljs-number">32</span>, <span class="hljs-number">64</span>, <span class="hljs-number">128</span>]),
<span class="hljs-meta">... </span>    }`,wrap:!1}}),Y=new h({props:{code:"ZGVmJTIwd2FuZGJfaHBfc3BhY2UodHJpYWwpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWV0aG9kJTIyJTNBJTIwJTIycmFuZG9tJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWV0cmljJTIyJTNBJTIwJTdCJTIybmFtZSUyMiUzQSUyMCUyMm9iamVjdGl2ZSUyMiUyQyUyMCUyMmdvYWwlMjIlM0ElMjAlMjJtaW5pbWl6ZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWFybmluZ19yYXRlJTIyJTNBJTIwJTdCJTIyZGlzdHJpYnV0aW9uJTIyJTNBJTIwJTIydW5pZm9ybSUyMiUyQyUyMCUyMm1pbiUyMiUzQSUyMDFlLTYlMkMlMjAlMjJtYXglMjIlM0ElMjAxZS00JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIyJTNBJTIwJTdCJTIydmFsdWVzJTIyJTNBJTIwJTVCMTYlMkMlMjAzMiUyQyUyMDY0JTJDJTIwMTI4JTVEJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">wandb_hp_space</span>(<span class="hljs-params">trial</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;method&quot;</span>: <span class="hljs-string">&quot;random&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;metric&quot;</span>: {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;objective&quot;</span>, <span class="hljs-string">&quot;goal&quot;</span>: <span class="hljs-string">&quot;minimize&quot;</span>},
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;learning_rate&quot;</span>: {<span class="hljs-string">&quot;distribution&quot;</span>: <span class="hljs-string">&quot;uniform&quot;</span>, <span class="hljs-string">&quot;min&quot;</span>: <span class="hljs-number">1e-6</span>, <span class="hljs-string">&quot;max&quot;</span>: <span class="hljs-number">1e-4</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;per_device_train_batch_size&quot;</span>: {<span class="hljs-string">&quot;values&quot;</span>: [<span class="hljs-number">16</span>, <span class="hljs-number">32</span>, <span class="hljs-number">64</span>, <span class="hljs-number">128</span>]},
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    }`,wrap:!1}}),v=new h({props:{code:"ZGVmJTIwbW9kZWxfaW5pdCh0cmlhbCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9hcmdzLm1vZGVsX25hbWVfb3JfcGF0aCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZyb21fdGYlM0Rib29sKCUyMi5ja3B0JTIyJTIwaW4lMjBtb2RlbF9hcmdzLm1vZGVsX25hbWVfb3JfcGF0aCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWclM0Rjb25maWclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjYWNoZV9kaXIlM0Rtb2RlbF9hcmdzLmNhY2hlX2RpciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldmlzaW9uJTNEbW9kZWxfYXJncy5tb2RlbF9yZXZpc2lvbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHVzZV9hdXRoX3Rva2VuJTNEVHJ1ZSUyMGlmJTIwbW9kZWxfYXJncy51c2VfYXV0aF90b2tlbiUyMGVsc2UlMjBOb25lJTJDJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">model_init</span>(<span class="hljs-params">trial</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> AutoModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>        model_args.model_name_or_path,
<span class="hljs-meta">... </span>        from_tf=<span class="hljs-built_in">bool</span>(<span class="hljs-string">&quot;.ckpt&quot;</span> <span class="hljs-keyword">in</span> model_args.model_name_or_path),
<span class="hljs-meta">... </span>        config=config,
<span class="hljs-meta">... </span>        cache_dir=model_args.cache_dir,
<span class="hljs-meta">... </span>        revision=model_args.model_revision,
<span class="hljs-meta">... </span>        use_auth_token=<span class="hljs-literal">True</span> <span class="hljs-keyword">if</span> model_args.use_auth_token <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>    )`,wrap:!1}}),Q=new h({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEc21hbGxfdHJhaW5fZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRHNtYWxsX2V2YWxfZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfbWV0cmljcyUzRGNvbXB1dGVfbWV0cmljcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2luaXQlM0Rtb2RlbF9pbml0JTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=<span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    train_dataset=small_train_dataset,
<span class="hljs-meta">... </span>    eval_dataset=small_eval_dataset,
<span class="hljs-meta">... </span>    compute_metrics=compute_metrics,
<span class="hljs-meta">... </span>    tokenizer=tokenizer,
<span class="hljs-meta">... </span>    model_init=model_init,
<span class="hljs-meta">... </span>    data_collator=data_collator,
<span class="hljs-meta">... </span>)`,wrap:!1}}),N=new h({props:{code:"YmVzdF90cmlhbCUyMCUzRCUyMHRyYWluZXIuaHlwZXJwYXJhbWV0ZXJfc2VhcmNoKCUwQSUyMCUyMCUyMCUyMGRpcmVjdGlvbiUzRCUyMm1heGltaXplJTIyJTJDJTBBJTIwJTIwJTIwJTIwYmFja2VuZCUzRCUyMm9wdHVuYSUyMiUyQyUwQSUyMCUyMCUyMCUyMGhwX3NwYWNlJTNEb3B0dW5hX2hwX3NwYWNlJTJDJTBBJTIwJTIwJTIwJTIwbl90cmlhbHMlM0QyMCUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfb2JqZWN0aXZlJTNEY29tcHV0ZV9vYmplY3RpdmUlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>best_trial = trainer.hyperparameter_search(
<span class="hljs-meta">... </span>    direction=<span class="hljs-string">&quot;maximize&quot;</span>,
<span class="hljs-meta">... </span>    backend=<span class="hljs-string">&quot;optuna&quot;</span>,
<span class="hljs-meta">... </span>    hp_space=optuna_hp_space,
<span class="hljs-meta">... </span>    n_trials=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    compute_objective=compute_objective,
<span class="hljs-meta">... </span>)`,wrap:!1}}),R=new Is({props:{title:"Hyperparameter search For DDP finetune",local:"hyperparameter-search-for-ddp-finetune",headingTag:"h2"}}),{c(){T=p("meta"),x=t(),S=p("p"),z=t(),i(j.$$.fragment),E=t(),U=p("p"),U.innerHTML=fs,D=t(),i(u.$$.fragment),L=t(),w=p("p"),w.innerHTML=bs,P=t(),d=p("p"),d.textContent=gs,K=t(),i(I.$$.fragment),O=t(),i(C.$$.fragment),ss=t(),f=p("p"),f.textContent=_s,as=t(),b=p("p"),b.innerHTML=$s,es=t(),i(g.$$.fragment),ls=t(),_=p("p"),_.innerHTML=qs,ts=t(),i($.$$.fragment),ns=t(),q=p("p"),q.innerHTML=Xs,ps=t(),i(X.$$.fragment),rs=t(),W=p("p"),W.innerHTML=Ws,Ms=t(),i(B.$$.fragment),is=t(),Z=p("p"),Z.innerHTML=Bs,ys=t(),i(Y.$$.fragment),cs=t(),V=p("p"),V.innerHTML=Zs,ms=t(),i(v.$$.fragment),Js=t(),H=p("p"),H.innerHTML=Ys,os=t(),i(Q.$$.fragment),Ts=t(),k=p("p"),k.innerHTML=Vs,hs=t(),A=p("p"),A.innerHTML=vs,js=t(),i(N.$$.fragment),Us=t(),i(R.$$.fragment),us=t(),G=p("p"),G.textContent=Hs,ws=t(),F=p("p"),this.h()},l(s){const a=Fs("svelte-u9bgzb",document.head);T=r(a,"META",{name:!0,content:!0}),a.forEach(e),x=n(s),S=r(s,"P",{}),Qs(S).forEach(e),z=n(s),y(j.$$.fragment,s),E=n(s),U=r(s,"P",{"data-svelte-h":!0}),M(U)!=="svelte-1fa5gao"&&(U.innerHTML=fs),D=n(s),y(u.$$.fragment,s),L=n(s),w=r(s,"P",{"data-svelte-h":!0}),M(w)!=="svelte-qejdn"&&(w.innerHTML=bs),P=n(s),d=r(s,"P",{"data-svelte-h":!0}),M(d)!=="svelte-1rdjjrk"&&(d.textContent=gs),K=n(s),y(I.$$.fragment,s),O=n(s),y(C.$$.fragment,s),ss=n(s),f=r(s,"P",{"data-svelte-h":!0}),M(f)!=="svelte-1r6943w"&&(f.textContent=_s),as=n(s),b=r(s,"P",{"data-svelte-h":!0}),M(b)!=="svelte-gv3yto"&&(b.innerHTML=$s),es=n(s),y(g.$$.fragment,s),ls=n(s),_=r(s,"P",{"data-svelte-h":!0}),M(_)!=="svelte-1aualad"&&(_.innerHTML=qs),ts=n(s),y($.$$.fragment,s),ns=n(s),q=r(s,"P",{"data-svelte-h":!0}),M(q)!=="svelte-pz664g"&&(q.innerHTML=Xs),ps=n(s),y(X.$$.fragment,s),rs=n(s),W=r(s,"P",{"data-svelte-h":!0}),M(W)!=="svelte-1jqrfse"&&(W.innerHTML=Ws),Ms=n(s),y(B.$$.fragment,s),is=n(s),Z=r(s,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-ewosm3"&&(Z.innerHTML=Bs),ys=n(s),y(Y.$$.fragment,s),cs=n(s),V=r(s,"P",{"data-svelte-h":!0}),M(V)!=="svelte-1esz949"&&(V.innerHTML=Zs),ms=n(s),y(v.$$.fragment,s),Js=n(s),H=r(s,"P",{"data-svelte-h":!0}),M(H)!=="svelte-17ec7i9"&&(H.innerHTML=Ys),os=n(s),y(Q.$$.fragment,s),Ts=n(s),k=r(s,"P",{"data-svelte-h":!0}),M(k)!=="svelte-wgkw6g"&&(k.innerHTML=Vs),hs=n(s),A=r(s,"P",{"data-svelte-h":!0}),M(A)!=="svelte-1dpfob5"&&(A.innerHTML=vs),js=n(s),y(N.$$.fragment,s),Us=n(s),y(R.$$.fragment,s),us=n(s),G=r(s,"P",{"data-svelte-h":!0}),M(G)!=="svelte-thou6i"&&(G.textContent=Hs),ws=n(s),F=r(s,"P",{}),Qs(F).forEach(e),this.h()},h(){ks(T,"name","hf:doc:metadata"),ks(T,"content",Es)},m(s,a){xs(document.head,T),l(s,x,a),l(s,S,a),l(s,z,a),c(j,s,a),l(s,E,a),l(s,U,a),l(s,D,a),c(u,s,a),l(s,L,a),l(s,w,a),l(s,P,a),l(s,d,a),l(s,K,a),c(I,s,a),l(s,O,a),c(C,s,a),l(s,ss,a),l(s,f,a),l(s,as,a),l(s,b,a),l(s,es,a),c(g,s,a),l(s,ls,a),l(s,_,a),l(s,ts,a),c($,s,a),l(s,ns,a),l(s,q,a),l(s,ps,a),c(X,s,a),l(s,rs,a),l(s,W,a),l(s,Ms,a),c(B,s,a),l(s,is,a),l(s,Z,a),l(s,ys,a),c(Y,s,a),l(s,cs,a),l(s,V,a),l(s,ms,a),c(v,s,a),l(s,Js,a),l(s,H,a),l(s,os,a),c(Q,s,a),l(s,Ts,a),l(s,k,a),l(s,hs,a),l(s,A,a),l(s,js,a),c(N,s,a),l(s,Us,a),c(R,s,a),l(s,us,a),l(s,G,a),l(s,ws,a),l(s,F,a),ds=!0},p:Ns,i(s){ds||(m(j.$$.fragment,s),m(u.$$.fragment,s),m(I.$$.fragment,s),m(C.$$.fragment,s),m(g.$$.fragment,s),m($.$$.fragment,s),m(X.$$.fragment,s),m(B.$$.fragment,s),m(Y.$$.fragment,s),m(v.$$.fragment,s),m(Q.$$.fragment,s),m(N.$$.fragment,s),m(R.$$.fragment,s),ds=!0)},o(s){J(j.$$.fragment,s),J(u.$$.fragment,s),J(I.$$.fragment,s),J(C.$$.fragment,s),J(g.$$.fragment,s),J($.$$.fragment,s),J(X.$$.fragment,s),J(B.$$.fragment,s),J(Y.$$.fragment,s),J(v.$$.fragment,s),J(Q.$$.fragment,s),J(N.$$.fragment,s),J(R.$$.fragment,s),ds=!1},d(s){s&&(e(x),e(S),e(z),e(E),e(U),e(D),e(L),e(w),e(P),e(d),e(K),e(O),e(ss),e(f),e(as),e(b),e(es),e(ls),e(_),e(ts),e(ns),e(q),e(ps),e(rs),e(W),e(Ms),e(is),e(Z),e(ys),e(cs),e(V),e(ms),e(Js),e(H),e(os),e(Ts),e(k),e(hs),e(A),e(js),e(Us),e(us),e(G),e(ws),e(F)),e(T),o(j,s),o(u,s),o(I,s),o(C,s),o(g,s),o($,s),o(X,s),o(B,s),o(Y,s),o(v,s),o(Q,s),o(N,s),o(R,s)}}}const Es='{"title":"Hyperparameter Search using Trainer API","local":"hyperparameter-search-using-trainer-api","sections":[{"title":"Hyperparameter Search backend","local":"hyperparameter-search-backend","sections":[],"depth":2},{"title":"How to enable Hyperparameter search in example","local":"how-to-enable-hyperparameter-search-in-example","sections":[],"depth":2},{"title":"Hyperparameter search For DDP finetune","local":"hyperparameter-search-for-ddp-finetune","sections":[],"depth":2}],"depth":1}';function Ds(Cs){return Rs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sa extends Gs{constructor(T){super(),Ss(this,T,Ds,zs,As,{})}}export{sa as component};
