import{s as Gl,n as Dl,o as Fl}from"../chunks/scheduler.7bc62968.js";import{S as Ll,i as Kl,g as i,s as n,r as p,A as Pl,h as o,f as t,c as a,j as Vl,u as r,x as M,k as Xl,y as ql,a as s,v as w,d as m,t as c,w as y}from"../chunks/index.2f8492b0.js";import{C as yl}from"../chunks/CodeBlock.bb61a5a9.js";import{H as u,E as Ol}from"../chunks/getInferenceSnippets.7ce1588a.js";function et(ul){let T,ue,ce,Te,h,he,J,Tl="MobileNet is a type of neural network architecture designed for mobile devices. It was developed by Google’s research team and first introduced in 2017. The primary goal of MobileNet is to provide high-performance, low-latency image classification and object detection on smartphones, tablets, and other resource-constrained devices.",Je,j,hl="MobileNet achieves this by using depthwise separable convolutions, which are a more efficient alternative to standard convolutions. Depthwise separable convolutions break down the computation into two separate steps: depthwise convolution followed by pointwise convolution. This results in a significant reduction of parameters and computational complexity, allowing MobileNet to run efficiently on mobile devices.",je,f,fe,U,Jl="By replacing regular convolutional layers with these depthwise separable convolutions and pointwise convolutions, MobileNet achieves high accuracy while minimizing computational overhead, making it well-suited for mobile devices and other resource-limited platforms. There are two types of convolutions used in MobileNet:",Ue,C,Ce,b,jl="In traditional convolutional layers, each filter applies its weight across all input channels simultaneously. Depthwise separable convolutions break this down into two steps: depthwise convolution followed by pointwise convolution.",be,d,fl="This step performs a convolution separately for each channel (a single color or feature) in the input image using a small filter (usually 3x3). The output of this step is the same size as the input but with fewer channels.",de,I,Ie,v,Ul="This type of convolution applies a single filter (usually 1x1) across all channels in both input and output layers. It has fewer parameters than regular convolution and can be seen as an alternative to fully connected layers, making it suitable for mobile devices that have limited computational resources.",ve,x,Cl="After depthwise convolution, this step combines the filtered outputs from previous steps using another 1x1 convolutional layer. This operation effectively aggregates the features learned by the depthwise convolutions into a smaller set of features, reducing the overall complexity while retaining important information.",xe,g,ge,A,bl="To better understand, let’s simplify it and explain:",Ae,B,Be,$,dl="Imagine you have a big, thick filter (like a sponge with many layers). This filter is applied over the entire image. It processes all parts of the image and all its features (like colors) at once. This requires a lot of work (computation) and a big filter (memory).",$e,k,ke,Z,Il="MobileNet does this process basic. It splits the big filter into two smaller, simpler steps:",Ze,E,vl=`<li><strong>Step 1 - Depthwise Convolution:</strong> First, it uses a thin filter (like a single layer of a sponge) for each feature of the image
separately (like processing each color individually). This is less work because each filter is small and simple.</li> <li><strong>Step 2 - Pointwise Convolution:</strong> Then, it uses another small filter (just a tiny dot) to mix these features back together. This step is like taking a summary of what the first filters found.</li>`,Ee,N,Ne,_,xl="MobileNet uses these two smaller steps instead of one big step, it’s like doing a lighter version of the work needed in regular convolutions. It’s more efficient, especially on devices that aren’t very powerful, like smartphones.",_e,S,gl="With smaller filters, MobileNet doesn’t need as much memory. It’s like needing a smaller box to store all your tools, making it easier to fit into smaller devices.",Se,H,He,W,We,R,Al="<li>Normal convolutions use a larger kernel (like 3x3 or 5x5) to look at a group of pixels in the image at once. It’s like observing a small patch of a picture to understand a part of the scene.</li> <li>These convolutions are good at understanding features like edges, corners, and textures by analyzing how pixels are arranged next to each other.</li>",Re,z,ze,Q,Bl="<li>A 1x1 convolution, looks at one pixel at a time. It doesn’t try to understand the arrangement of neighboring pixels.</li> <li>Even though it’s looking at one pixel, it considers all the information from different channels (like the RGB channels in a color image). It combines these channels to create a new version of that pixel.</li> <li>The 1x1 convolution can either increase or decrease the number of channels. This means it can simplify the information (by reducing channels) or create more complex information (by increasing channels).</li>",Qe,Y,Ye,V,$l="<li><strong>Area of Focus:</strong> Normal convolutions analyze a set of pixels together to understand patterns, whereas 1x1 convolutions focus on individual pixels, combining the information from different channels.</li> <li><strong>Purpose:</strong> Normal convolutions are used for detecting patterns and features in an image. In contrast, 1x1 convolutions are mainly used to alter the channel depth, helping in adjusting the complexity of the information for subsequent layers in a neural network for efficiency in weak devices.</li>",Ve,X,kl="MobileNet also employs techniques like channel-wise linear bottleneck layers, which improve model accuracy while reducing the number of parameters. The architecture is designed with optimizations for various hardware platforms, including CPUs, GPUs, and even specialized hardware such as Google’s Tensor Processing Units (TPUs).",Xe,G,Ge,D,Zl="Channel-wise linear bottleneck layers help to further reduce the number of parameters and computational cost while maintaining high accuracy in image classification tasks.",De,F,El="A channel-wise linear bottleneck layer consists of three main operations applied sequentially:",Fe,L,Nl="<li><strong>Depthwise convolution:</strong> This step performs a convolution separately for each channel (a single color or feature) in the input image using a small filter (usually 3x3). The output of this step is the same size as the input but with fewer channels.</li> <li><strong>Batch normalization:</strong> This operation normalizes the activation values across each channel, helping to stabilize the training process and improve generalization performance.</li> <li><strong>Activation function:</strong> Typically, a ReLU (Rectified Linear Unit) activation function is used after batch normalization to introduce non-linearity in the network.</li>",Le,K,Ke,P,_l="Some problems may occur during training. We will explain them first, then we explain what ReLU does to this problems.",Pe,q,qe,O,Sl="In deep neural networks, especially during backpropagation, the vanishing gradient problem can occur. This happens when gradients (which are used to update the network’s weights) become very small as they are passed back through the network’s layers. If these gradients become too small, they “vanish,” making it hard for the network to learn and adjust its weights effectively.",Oe,ee,Hl="ReLU has a linear, non-saturating form for positive values (where it simply outputs the input if it’s positive), it ensures that the gradients do not become too small, allowing for faster learning and more effective weight adjustments in the network.",el,le,ll,te,Wl="Without non-linearity, a neural network, no matter how many layers it has, would function as a linear model, incapable of learning complex patterns.",tl,se,Rl="Non-linear functions like ReLU enable neural networks to capture and learn complex relationships in the data.",sl,ne,nl,ae,zl="You can use Hugging Face transformers to infer with a variation of transformers models like below:",al,ie,il,oe,ol,Me,Ml,pe,Ql="You can find an example implementation of MobileNet for PyTorch below:",pl,re,rl,we,Yl='You can also find a pretrained MobileNet model checkpoint on this HuggingFace <a href="https://huggingface.co/google/mobilenet_v2_1.0_224" rel="nofollow">link</a>.',wl,me,ml,ye,cl;return h=new u({props:{title:"MobileNet",local:"mobilenet",headingTag:"h1"}}),f=new u({props:{title:"Convolution Types on MobileNet",local:"convolution-types-on-mobilenet",headingTag:"h2"}}),C=new u({props:{title:"Depthwise Seperable Convolutions",local:"depthwise-seperable-convolutions",headingTag:"h3"}}),I=new u({props:{title:"Pointwise Seperable Convolutions",local:"pointwise-seperable-convolutions",headingTag:"h3"}}),g=new u({props:{title:"Why Do We Use These Convolutions Instead of Regular Convolutions?",local:"why-do-we-use-these-convolutions-instead-of-regular-convolutions",headingTag:"h3"}}),B=new u({props:{title:"Regular Convolutions, a big, All-in-one Filter",local:"regular-convolutions-a-big-all-in-one-filter",headingTag:"h4"}}),k=new u({props:{title:"Depthwise Separable Convolutions - Two-Step, Lighter Process:",local:"depthwise-separable-convolutions---two-step-lighter-process",headingTag:"h4"}}),N=new u({props:{title:"What are these steps about?",local:"what-are-these-steps-about",headingTag:"h4"}}),H=new u({props:{title:"How Do 1x1 Convolutions Work Compared to Normal Convolutions?",local:"how-do-1x1-convolutions-work-compared-to-normal-convolutions",headingTag:"h3"}}),W=new u({props:{title:"Normal Convolutions",local:"normal-convolutions",headingTag:"h4"}}),z=new u({props:{title:"1x1 Convolutions",local:"1x1-convolutions",headingTag:"h4"}}),Y=new u({props:{title:"Key Differences",local:"key-differences",headingTag:"h4"}}),G=new u({props:{title:"Channel-wise Linear Bottleneck Layers",local:"channel-wise-linear-bottleneck-layers",headingTag:"h3"}}),K=new u({props:{title:"What does ReLU do?",local:"what-does-relu-do",headingTag:"h3"}}),q=new u({props:{title:"Vanishing Gradient Problem",local:"vanishing-gradient-problem",headingTag:"h4"}}),le=new u({props:{title:"Non-Linearity",local:"non-linearity",headingTag:"h4"}}),ne=new u({props:{title:"Inference",local:"inference",headingTag:"h3"}}),ie=new yl({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEElMjMlMjBpbml0aWFsaXplJTIwcHJvY2Vzc29yJTIwYW5kJTIwbW9kZWwlMEFwcmVwcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm1vYmlsZW5ldF92Ml8xLjBfMjI0JTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGbW9iaWxlbmV0X3YyXzEuMF8yMjQlMjIpJTBBJTBBJTIzJTIwcHJlcHJvY2VzcyUyMHRoZSUyMGlucHV0cyUwQWlucHV0cyUyMCUzRCUyMHByZXByb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwZ2V0JTIwdGhlJTIwb3V0cHV0JTIwYW5kJTIwdGhlJTIwY2xhc3MlMjBsYWJlbHMlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfY2xhc3NfaWR4JTIwJTNEJTIwbG9naXRzLmFyZ21heCgtMSkuaXRlbSgpJTBBcHJpbnQoJTIyUHJlZGljdGVkJTIwY2xhc3MlM0ElMjIlMkMlMjBtb2RlbC5jb25maWcuaWQybGFiZWwlNUJwcmVkaWN0ZWRfY2xhc3NfaWR4JTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForImageClassification
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-comment"># initialize processor and model</span>
preprocessor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/mobilenet_v2_1.0_224&quot;</span>)
model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;google/mobilenet_v2_1.0_224&quot;</span>)

<span class="hljs-comment"># preprocess the inputs</span>
inputs = preprocessor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-comment"># get the output and the class labels</span>
outputs = model(**inputs)
logits = outputs.logits

predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])`,wrap:!1}}),oe=new yl({props:{code:"UHJlZGljdGVkJTIwY2xhc3MlM0ElMjB0YWJieSUyQyUyMHRhYmJ5JTIwY2F0",highlighted:'Predicted <span class="hljs-keyword">class</span>: <span class="hljs-symbol">tabby, <span class="hljs-symbol">tabby</span></span> <span class="hljs-symbol">cat</span>',wrap:!1}}),Me=new u({props:{title:"Example Implementation using PyTorch",local:"example-implementation-using-pytorch",headingTag:"h3"}}),re=new yl({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">import</span> torch.nn.functional <span class="hljs-keyword">as</span> F


<span class="hljs-keyword">class</span> <span class="hljs-title class_">DepthwiseSeparableConv</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, in_channels, out_channels, stride</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.depthwise = nn.Conv2d(
            in_channels,
            in_channels,
            kernel_size=<span class="hljs-number">3</span>,
            stride=stride,
            padding=<span class="hljs-number">1</span>,
            groups=in_channels,
        )
        self.pointwise = nn.Conv2d(
            in_channels, out_channels, kernel_size=<span class="hljs-number">1</span>, stride=<span class="hljs-number">1</span>, padding=<span class="hljs-number">0</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        x = self.depthwise(x)
        x = self.pointwise(x)
        <span class="hljs-keyword">return</span> x


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MobileNet</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, num_classes=<span class="hljs-number">1000</span></span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.conv1 = nn.Conv2d(<span class="hljs-number">3</span>, <span class="hljs-number">32</span>, kernel_size=<span class="hljs-number">3</span>, stride=<span class="hljs-number">2</span>, padding=<span class="hljs-number">1</span>)

        <span class="hljs-comment"># MobileNet body</span>
        self.dw_conv2 = DepthwiseSeparableConv(<span class="hljs-number">32</span>, <span class="hljs-number">64</span>, <span class="hljs-number">1</span>)
        self.dw_conv3 = DepthwiseSeparableConv(<span class="hljs-number">64</span>, <span class="hljs-number">128</span>, <span class="hljs-number">2</span>)
        self.dw_conv4 = DepthwiseSeparableConv(<span class="hljs-number">128</span>, <span class="hljs-number">128</span>, <span class="hljs-number">1</span>)
        self.dw_conv5 = DepthwiseSeparableConv(<span class="hljs-number">128</span>, <span class="hljs-number">256</span>, <span class="hljs-number">2</span>)
        self.dw_conv6 = DepthwiseSeparableConv(<span class="hljs-number">256</span>, <span class="hljs-number">256</span>, <span class="hljs-number">1</span>)
        self.dw_conv7 = DepthwiseSeparableConv(<span class="hljs-number">256</span>, <span class="hljs-number">512</span>, <span class="hljs-number">2</span>)

        <span class="hljs-comment"># 5 depthwise separable convolutions with stride 1</span>
        self.dw_conv8 = DepthwiseSeparableConv(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">1</span>)
        self.dw_conv9 = DepthwiseSeparableConv(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">1</span>)
        self.dw_conv10 = DepthwiseSeparableConv(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">1</span>)
        self.dw_conv11 = DepthwiseSeparableConv(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">1</span>)
        self.dw_conv12 = DepthwiseSeparableConv(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">1</span>)

        self.dw_conv13 = DepthwiseSeparableConv(<span class="hljs-number">512</span>, <span class="hljs-number">1024</span>, <span class="hljs-number">2</span>)
        self.dw_conv14 = DepthwiseSeparableConv(<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>, <span class="hljs-number">1</span>)

        self.avg_pool = nn.AdaptiveAvgPool2d(<span class="hljs-number">1</span>)
        self.fc = nn.Linear(<span class="hljs-number">1024</span>, num_classes)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        x = self.conv1(x)
        x = F.relu(x)

        x = self.dw_conv2(x)
        x = F.relu(x)
        x = self.dw_conv3(x)
        x = F.relu(x)
        x = self.dw_conv4(x)
        x = F.relu(x)
        x = self.dw_conv5(x)
        x = F.relu(x)
        x = self.dw_conv6(x)
        x = F.relu(x)
        x = self.dw_conv7(x)
        x = F.relu(x)

        x = self.dw_conv8(x)
        x = F.relu(x)
        x = self.dw_conv9(x)
        x = F.relu(x)
        x = self.dw_conv10(x)
        x = F.relu(x)
        x = self.dw_conv11(x)
        x = F.relu(x)
        x = self.dw_conv12(x)
        x = F.relu(x)

        x = self.dw_conv13(x)
        x = F.relu(x)
        x = self.dw_conv14(x)
        x = F.relu(x)

        x = self.avg_pool(x)
        x = x.view(x.size(<span class="hljs-number">0</span>), -<span class="hljs-number">1</span>)
        x = self.fc(x)

        <span class="hljs-keyword">return</span> x


<span class="hljs-comment"># Create the model</span>
mobilenet = MobileNet(num_classes=<span class="hljs-number">1000</span>)
<span class="hljs-built_in">print</span>(mobilenet)`,wrap:!1}}),me=new Ol({props:{source:"https://github.com/huggingface/computer-vision-course/blob/main/chapters/en/unit2/cnns/mobilenet.mdx"}}),{c(){T=i("meta"),ue=n(),ce=i("p"),Te=n(),p(h.$$.fragment),he=n(),J=i("p"),J.textContent=Tl,Je=n(),j=i("p"),j.textContent=hl,je=n(),p(f.$$.fragment),fe=n(),U=i("p"),U.textContent=Jl,Ue=n(),p(C.$$.fragment),Ce=n(),b=i("p"),b.textContent=jl,be=n(),d=i("p"),d.textContent=fl,de=n(),p(I.$$.fragment),Ie=n(),v=i("p"),v.textContent=Ul,ve=n(),x=i("p"),x.textContent=Cl,xe=n(),p(g.$$.fragment),ge=n(),A=i("p"),A.textContent=bl,Ae=n(),p(B.$$.fragment),Be=n(),$=i("p"),$.textContent=dl,$e=n(),p(k.$$.fragment),ke=n(),Z=i("p"),Z.textContent=Il,Ze=n(),E=i("ul"),E.innerHTML=vl,Ee=n(),p(N.$$.fragment),Ne=n(),_=i("p"),_.textContent=xl,_e=n(),S=i("p"),S.textContent=gl,Se=n(),p(H.$$.fragment),He=n(),p(W.$$.fragment),We=n(),R=i("ul"),R.innerHTML=Al,Re=n(),p(z.$$.fragment),ze=n(),Q=i("ul"),Q.innerHTML=Bl,Qe=n(),p(Y.$$.fragment),Ye=n(),V=i("ul"),V.innerHTML=$l,Ve=n(),X=i("p"),X.textContent=kl,Xe=n(),p(G.$$.fragment),Ge=n(),D=i("p"),D.textContent=Zl,De=n(),F=i("p"),F.textContent=El,Fe=n(),L=i("ol"),L.innerHTML=Nl,Le=n(),p(K.$$.fragment),Ke=n(),P=i("p"),P.textContent=_l,Pe=n(),p(q.$$.fragment),qe=n(),O=i("p"),O.textContent=Sl,Oe=n(),ee=i("p"),ee.textContent=Hl,el=n(),p(le.$$.fragment),ll=n(),te=i("p"),te.textContent=Wl,tl=n(),se=i("p"),se.textContent=Rl,sl=n(),p(ne.$$.fragment),nl=n(),ae=i("p"),ae.textContent=zl,al=n(),p(ie.$$.fragment),il=n(),p(oe.$$.fragment),ol=n(),p(Me.$$.fragment),Ml=n(),pe=i("p"),pe.textContent=Ql,pl=n(),p(re.$$.fragment),rl=n(),we=i("p"),we.innerHTML=Yl,wl=n(),p(me.$$.fragment),ml=n(),ye=i("p"),this.h()},l(e){const l=Pl("svelte-u9bgzb",document.head);T=o(l,"META",{name:!0,content:!0}),l.forEach(t),ue=a(e),ce=o(e,"P",{}),Vl(ce).forEach(t),Te=a(e),r(h.$$.fragment,e),he=a(e),J=o(e,"P",{"data-svelte-h":!0}),M(J)!=="svelte-sijmec"&&(J.textContent=Tl),Je=a(e),j=o(e,"P",{"data-svelte-h":!0}),M(j)!=="svelte-174b0qn"&&(j.textContent=hl),je=a(e),r(f.$$.fragment,e),fe=a(e),U=o(e,"P",{"data-svelte-h":!0}),M(U)!=="svelte-1wb1rsu"&&(U.textContent=Jl),Ue=a(e),r(C.$$.fragment,e),Ce=a(e),b=o(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-ponep"&&(b.textContent=jl),be=a(e),d=o(e,"P",{"data-svelte-h":!0}),M(d)!=="svelte-161c9o7"&&(d.textContent=fl),de=a(e),r(I.$$.fragment,e),Ie=a(e),v=o(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-2y0hnt"&&(v.textContent=Ul),ve=a(e),x=o(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-1phmdq0"&&(x.textContent=Cl),xe=a(e),r(g.$$.fragment,e),ge=a(e),A=o(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-7o9nvi"&&(A.textContent=bl),Ae=a(e),r(B.$$.fragment,e),Be=a(e),$=o(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-1aqrp0c"&&($.textContent=dl),$e=a(e),r(k.$$.fragment,e),ke=a(e),Z=o(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-1n7p8h5"&&(Z.textContent=Il),Ze=a(e),E=o(e,"UL",{"data-svelte-h":!0}),M(E)!=="svelte-1erfm5m"&&(E.innerHTML=vl),Ee=a(e),r(N.$$.fragment,e),Ne=a(e),_=o(e,"P",{"data-svelte-h":!0}),M(_)!=="svelte-ucrnk0"&&(_.textContent=xl),_e=a(e),S=o(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-1q9jr09"&&(S.textContent=gl),Se=a(e),r(H.$$.fragment,e),He=a(e),r(W.$$.fragment,e),We=a(e),R=o(e,"UL",{"data-svelte-h":!0}),M(R)!=="svelte-141ia0e"&&(R.innerHTML=Al),Re=a(e),r(z.$$.fragment,e),ze=a(e),Q=o(e,"UL",{"data-svelte-h":!0}),M(Q)!=="svelte-1fof3jx"&&(Q.innerHTML=Bl),Qe=a(e),r(Y.$$.fragment,e),Ye=a(e),V=o(e,"UL",{"data-svelte-h":!0}),M(V)!=="svelte-20uax5"&&(V.innerHTML=$l),Ve=a(e),X=o(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-1wb1jef"&&(X.textContent=kl),Xe=a(e),r(G.$$.fragment,e),Ge=a(e),D=o(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-3ec6p4"&&(D.textContent=Zl),De=a(e),F=o(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-1jsp81n"&&(F.textContent=El),Fe=a(e),L=o(e,"OL",{"data-svelte-h":!0}),M(L)!=="svelte-123p5si"&&(L.innerHTML=Nl),Le=a(e),r(K.$$.fragment,e),Ke=a(e),P=o(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-iz02dd"&&(P.textContent=_l),Pe=a(e),r(q.$$.fragment,e),qe=a(e),O=o(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-1kof70t"&&(O.textContent=Sl),Oe=a(e),ee=o(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-1t9atje"&&(ee.textContent=Hl),el=a(e),r(le.$$.fragment,e),ll=a(e),te=o(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-17n9xro"&&(te.textContent=Wl),tl=a(e),se=o(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-1cfo99"&&(se.textContent=Rl),sl=a(e),r(ne.$$.fragment,e),nl=a(e),ae=o(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-gwdx3y"&&(ae.textContent=zl),al=a(e),r(ie.$$.fragment,e),il=a(e),r(oe.$$.fragment,e),ol=a(e),r(Me.$$.fragment,e),Ml=a(e),pe=o(e,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-10vxwno"&&(pe.textContent=Ql),pl=a(e),r(re.$$.fragment,e),rl=a(e),we=o(e,"P",{"data-svelte-h":!0}),M(we)!=="svelte-1fc7bef"&&(we.innerHTML=Yl),wl=a(e),r(me.$$.fragment,e),ml=a(e),ye=o(e,"P",{}),Vl(ye).forEach(t),this.h()},h(){Xl(T,"name","hf:doc:metadata"),Xl(T,"content",lt)},m(e,l){ql(document.head,T),s(e,ue,l),s(e,ce,l),s(e,Te,l),w(h,e,l),s(e,he,l),s(e,J,l),s(e,Je,l),s(e,j,l),s(e,je,l),w(f,e,l),s(e,fe,l),s(e,U,l),s(e,Ue,l),w(C,e,l),s(e,Ce,l),s(e,b,l),s(e,be,l),s(e,d,l),s(e,de,l),w(I,e,l),s(e,Ie,l),s(e,v,l),s(e,ve,l),s(e,x,l),s(e,xe,l),w(g,e,l),s(e,ge,l),s(e,A,l),s(e,Ae,l),w(B,e,l),s(e,Be,l),s(e,$,l),s(e,$e,l),w(k,e,l),s(e,ke,l),s(e,Z,l),s(e,Ze,l),s(e,E,l),s(e,Ee,l),w(N,e,l),s(e,Ne,l),s(e,_,l),s(e,_e,l),s(e,S,l),s(e,Se,l),w(H,e,l),s(e,He,l),w(W,e,l),s(e,We,l),s(e,R,l),s(e,Re,l),w(z,e,l),s(e,ze,l),s(e,Q,l),s(e,Qe,l),w(Y,e,l),s(e,Ye,l),s(e,V,l),s(e,Ve,l),s(e,X,l),s(e,Xe,l),w(G,e,l),s(e,Ge,l),s(e,D,l),s(e,De,l),s(e,F,l),s(e,Fe,l),s(e,L,l),s(e,Le,l),w(K,e,l),s(e,Ke,l),s(e,P,l),s(e,Pe,l),w(q,e,l),s(e,qe,l),s(e,O,l),s(e,Oe,l),s(e,ee,l),s(e,el,l),w(le,e,l),s(e,ll,l),s(e,te,l),s(e,tl,l),s(e,se,l),s(e,sl,l),w(ne,e,l),s(e,nl,l),s(e,ae,l),s(e,al,l),w(ie,e,l),s(e,il,l),w(oe,e,l),s(e,ol,l),w(Me,e,l),s(e,Ml,l),s(e,pe,l),s(e,pl,l),w(re,e,l),s(e,rl,l),s(e,we,l),s(e,wl,l),w(me,e,l),s(e,ml,l),s(e,ye,l),cl=!0},p:Dl,i(e){cl||(m(h.$$.fragment,e),m(f.$$.fragment,e),m(C.$$.fragment,e),m(I.$$.fragment,e),m(g.$$.fragment,e),m(B.$$.fragment,e),m(k.$$.fragment,e),m(N.$$.fragment,e),m(H.$$.fragment,e),m(W.$$.fragment,e),m(z.$$.fragment,e),m(Y.$$.fragment,e),m(G.$$.fragment,e),m(K.$$.fragment,e),m(q.$$.fragment,e),m(le.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(oe.$$.fragment,e),m(Me.$$.fragment,e),m(re.$$.fragment,e),m(me.$$.fragment,e),cl=!0)},o(e){c(h.$$.fragment,e),c(f.$$.fragment,e),c(C.$$.fragment,e),c(I.$$.fragment,e),c(g.$$.fragment,e),c(B.$$.fragment,e),c(k.$$.fragment,e),c(N.$$.fragment,e),c(H.$$.fragment,e),c(W.$$.fragment,e),c(z.$$.fragment,e),c(Y.$$.fragment,e),c(G.$$.fragment,e),c(K.$$.fragment,e),c(q.$$.fragment,e),c(le.$$.fragment,e),c(ne.$$.fragment,e),c(ie.$$.fragment,e),c(oe.$$.fragment,e),c(Me.$$.fragment,e),c(re.$$.fragment,e),c(me.$$.fragment,e),cl=!1},d(e){e&&(t(ue),t(ce),t(Te),t(he),t(J),t(Je),t(j),t(je),t(fe),t(U),t(Ue),t(Ce),t(b),t(be),t(d),t(de),t(Ie),t(v),t(ve),t(x),t(xe),t(ge),t(A),t(Ae),t(Be),t($),t($e),t(ke),t(Z),t(Ze),t(E),t(Ee),t(Ne),t(_),t(_e),t(S),t(Se),t(He),t(We),t(R),t(Re),t(ze),t(Q),t(Qe),t(Ye),t(V),t(Ve),t(X),t(Xe),t(Ge),t(D),t(De),t(F),t(Fe),t(L),t(Le),t(Ke),t(P),t(Pe),t(qe),t(O),t(Oe),t(ee),t(el),t(ll),t(te),t(tl),t(se),t(sl),t(nl),t(ae),t(al),t(il),t(ol),t(Ml),t(pe),t(pl),t(rl),t(we),t(wl),t(ml),t(ye)),t(T),y(h,e),y(f,e),y(C,e),y(I,e),y(g,e),y(B,e),y(k,e),y(N,e),y(H,e),y(W,e),y(z,e),y(Y,e),y(G,e),y(K,e),y(q,e),y(le,e),y(ne,e),y(ie,e),y(oe,e),y(Me,e),y(re,e),y(me,e)}}}const lt='{"title":"MobileNet","local":"mobilenet","sections":[{"title":"Convolution Types on MobileNet","local":"convolution-types-on-mobilenet","sections":[{"title":"Depthwise Seperable Convolutions","local":"depthwise-seperable-convolutions","sections":[],"depth":3},{"title":"Pointwise Seperable Convolutions","local":"pointwise-seperable-convolutions","sections":[],"depth":3},{"title":"Why Do We Use These Convolutions Instead of Regular Convolutions?","local":"why-do-we-use-these-convolutions-instead-of-regular-convolutions","sections":[{"title":"Regular Convolutions, a big, All-in-one Filter","local":"regular-convolutions-a-big-all-in-one-filter","sections":[],"depth":4},{"title":"Depthwise Separable Convolutions - Two-Step, Lighter Process:","local":"depthwise-separable-convolutions---two-step-lighter-process","sections":[],"depth":4},{"title":"What are these steps about?","local":"what-are-these-steps-about","sections":[],"depth":4}],"depth":3},{"title":"How Do 1x1 Convolutions Work Compared to Normal Convolutions?","local":"how-do-1x1-convolutions-work-compared-to-normal-convolutions","sections":[{"title":"Normal Convolutions","local":"normal-convolutions","sections":[],"depth":4},{"title":"1x1 Convolutions","local":"1x1-convolutions","sections":[],"depth":4},{"title":"Key Differences","local":"key-differences","sections":[],"depth":4}],"depth":3},{"title":"Channel-wise Linear Bottleneck Layers","local":"channel-wise-linear-bottleneck-layers","sections":[],"depth":3},{"title":"What does ReLU do?","local":"what-does-relu-do","sections":[{"title":"Vanishing Gradient Problem","local":"vanishing-gradient-problem","sections":[],"depth":4},{"title":"Non-Linearity","local":"non-linearity","sections":[],"depth":4}],"depth":3},{"title":"Inference","local":"inference","sections":[],"depth":3},{"title":"Example Implementation using PyTorch","local":"example-implementation-using-pytorch","sections":[],"depth":3}],"depth":2}],"depth":1}';function tt(ul){return Fl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ot extends Ll{constructor(T){super(),Kl(this,T,tt,et,Gl,{})}}export{ot as component};
