import{s as Ca,o as va,n as Ks}from"../chunks/scheduler.6062bdaf.js";import{S as ka,i as qa,g as i,s as n,r as h,A as Ga,h as o,f as e,c as l,j as $a,u as r,x as c,k as ke,y as Wa,a,v as m,d as j,t as g,w as M}from"../chunks/index.4bca734e.js";import{T as Ds}from"../chunks/Tip.b9ac1f03.js";import{C as y}from"../chunks/CodeBlock.cbbddafc.js";import{H as J,E as Za}from"../chunks/getInferenceSnippets.e6a3a5be.js";function Ba(b){let p,d='<strong>Hugging Face Jobs</strong> are available only to <a href="https://huggingface.co/pro" rel="nofollow">Pro users</a> and <a href="https://huggingface.co/enterprise" rel="nofollow">Team or Enterprise organizations</a>. Upgrade your plan to get started!';return{c(){p=i("p"),p.innerHTML=d},l(u){p=o(u,"P",{"data-svelte-h":!0}),c(p)!=="svelte-1esirrz"&&(p.innerHTML=d)},m(u,f){a(u,p,f)},p:Ks,d(u){u&&e(p)}}}function xa(b){let p,d='<strong>Important</strong>: Jobs have a default timeout (30 minutes), after which they will automatically stop. For long-running tasks like model training, make sure to set a custom timeout using the <code>timeout</code> parameter. See <a href="#configure-job-timeout">Configure Job Timeout</a> for details.';return{c(){p=i("p"),p.innerHTML=d},l(u){p=o(u,"P",{"data-svelte-h":!0}),c(p)!=="svelte-11q5en9"&&(p.innerHTML=d)},m(u,f){a(u,p,f)},p:Ks,d(u){u&&e(p)}}}function Ha(b){let p,d='For comprehensive guidance on running model training jobs with TRL on Hugging Face infrastructure, check out the <a href="https://huggingface.co/docs/trl/main/en/jobs_training" rel="nofollow">TRL Jobs Training documentation</a>. It covers fine-tuning recipes, hardware selection, and best practices for training models efficiently.';return{c(){p=i("p"),p.innerHTML=d},l(u){p=o(u,"P",{"data-svelte-h":!0}),c(p)!=="svelte-yddyik"&&(p.innerHTML=d)},m(u,f){a(u,p,f)},p:Ks,d(u){u&&e(p)}}}function Na(b){let p,d="If you don’t specify a timeout, a default timeout will be applied to your job. For long-running tasks like model training that may take hours, make sure to set an appropriate timeout to avoid unexpected job terminations.";return{c(){p=i("p"),p.textContent=d},l(u){p=o(u,"P",{"data-svelte-h":!0}),c(p)!=="svelte-aatfy2"&&(p.textContent=d)},m(u,f){a(u,p,f)},p:Ks,d(u){u&&e(p)}}}function Ea(b){let p,d='Looking for ready-to-use UV scripts? Check out the <a href="https://huggingface.co/uv-scripts" rel="nofollow">uv-scripts organization</a> on the Hugging Face Hub, which offers a community collection of UV scripts for tasks like model training, synthetic data generation, data processing, and more.';return{c(){p=i("p"),p.innerHTML=d},l(u){p=o(u,"P",{"data-svelte-h":!0}),c(p)!=="svelte-6wo56u"&&(p.innerHTML=d)},m(u,f){a(u,p,f)},p:Ks,d(u){u&&e(p)}}}function Ya(b){let p,d="Many inference frameworks provide optimized docker images. As uv is increasingly adopted in the Python ecosystem more of these will also have uv pre-installed meaning they will work when using hf jobs uv run.";return{c(){p=i("p"),p.textContent=d},l(u){p=o(u,"P",{"data-svelte-h":!0}),c(p)!=="svelte-1vtve2o"&&(p.textContent=d)},m(u,f){a(u,p,f)},p:Ks,d(u){u&&e(p)}}}function Ra(b){let p,d,u,f,v,st,k,qe=`The Hugging Face Hub provides compute for AI and data workflows via Jobs.
A job runs on Hugging Face infrastructure and are defined with a command to run (e.g. a python command), a Docker Image from Hugging Face Spaces or Docker Hub, and a hardware flavor (CPU, GPU, TPU). This guide will show you how to interact with Jobs on the Hub, especially:`,tt,q,Ge="<li>Run a job.</li> <li>Check job status.</li> <li>Select the hardware.</li> <li>Configure environment variables and secrets.</li> <li>Run UV scripts.</li>",et,G,We=`If you want to run and manage a job on the Hub, your machine must be logged in. If you are not, please refer to
<a href="../quick-start#authentication">this section</a>. In the rest of this guide, we will assume that your machine is logged in.`,at,T,nt,W,lt,Z,Ze='Use the <a href="./cli#hf-jobs"><code>hf jobs</code> CLI</a> to run Jobs from the command line, and pass <code>--flavor</code> to specify your hardware.',pt,B,Be="<code>hf jobs run</code> runs Jobs with a Docker image and a command with a familiar Docker-like interface. Think <code>docker run</code>, but for running code on any hardware:",it,x,ot,H,xe="Use <code>hf jobs uv run</code> to run local or remote UV scripts:",ct,N,ut,E,He='UV scripts are Python scripts that include their dependencies directly in the file using a special comment syntax defined in the <a href="https://docs.astral.sh/uv/guides/scripts/" rel="nofollow">UV documentation</a>.',ht,Y,Ne=`Now the rest of this guide will show you the python API.
If you would like to view all the available <code>hf jobs</code> commands and options instead, check out the <a href="./cli#hf-jobs">guide on the <code>hf jobs</code> command line interface</a>.`,rt,R,mt,Q,Ee="Run compute Jobs defined with a command and a Docker Image on Hugging Face infrastructure (including GPUs and TPUs).",jt,V,Ye=`You can only manage Jobs that you own (under your username namespace) or from organizations in which you have write permissions.
This feature is pay-as-you-go: you only pay for the seconds you use.`,gt,L,Re='<a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.run_job">run_job()</a> lets you run any command on Hugging Face’s infrastructure:',Mt,S,dt,w,yt,X,Qe=`<a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.run_job">run_job()</a> returns the <a href="/docs/huggingface_hub/main/en/package_reference/jobs#huggingface_hub.JobInfo">JobInfo</a> which has the URL of the Job on Hugging Face, where you can see the Job status and the logs.
Save the Job ID from <a href="/docs/huggingface_hub/main/en/package_reference/jobs#huggingface_hub.JobInfo">JobInfo</a> to manage the job:`,ft,A,bt,z,Ve='Jobs run in the background. The next section guides you through <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.inspect_job">inspect_job()</a> to know a jobs’ status and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.fetch_job_logs">fetch_job_logs()</a> to view the logs.',Jt,F,Tt,P,wt,D,Le='Check the status of multiple jobs to know when they’re all finished using a loop and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.inspect_job">inspect_job()</a>:',Ut,K,_t,O,It,ss,Se="There are numerous cases where running Jobs on GPUs are useful:",$t,ts,Xe="<li><strong>Model Training</strong>: Fine-tune or train models on GPUs (T4, A10G, A100) without managing infrastructure</li> <li><strong>Synthetic Data Generation</strong>: Generate large-scale datasets using LLMs on powerful hardware</li> <li><strong>Data Processing</strong>: Process massive datasets with high-CPU configurations for parallel workloads</li> <li><strong>Batch Inference</strong>: Run offline inference on thousands of samples using optimized GPU setups</li> <li><strong>Experiments &amp; Benchmarks</strong>: Run ML experiments on consistent hardware for reproducible results</li> <li><strong>Development &amp; Debugging</strong>: Test GPU code without local CUDA setup</li>",Ct,es,Ae="Run jobs on GPUs or TPUs with the <code>flavor</code> argument. For example, to run a PyTorch job on an A10G GPU:",vt,as,kt,ns,ze="Running this will show the following output!",qt,ls,Gt,ps,Fe='Use this to run a fine tuning script like <a href="https://github.com/huggingface/trl/blob/main/trl/scripts/sft.py" rel="nofollow">trl/scripts/sft.py</a> with UV:',Wt,is,Zt,U,Bt,os,Pe="Available <code>flavor</code> options:",xt,cs,De="<li>CPU: <code>cpu-basic</code>, <code>cpu-upgrade</code></li> <li>GPU: <code>t4-small</code>, <code>t4-medium</code>, <code>l4x1</code>, <code>l4x4</code>, <code>a10g-small</code>, <code>a10g-large</code>, <code>a10g-largex2</code>, <code>a10g-largex4</code>,<code>a100-large</code></li> <li>TPU: <code>v5e-1x1</code>, <code>v5e-2x2</code>, <code>v5e-2x4</code></li>",Ht,us,Ke='(updated in 07/2025 from Hugging Face <a href="https://huggingface.co/docs/hub/en/spaces-config-reference" rel="nofollow">suggested_hardware docs</a>)',Nt,hs,Oe="That’s it! You’re now running code on Hugging Face’s infrastructure.",Et,rs,Yt,ms,sa="Jobs have a default timeout (30 minutes), after which they will automatically stop. This is important to know when running long-running tasks like model training.",Rt,js,Qt,gs,ta="You can specify a custom timeout value using the <code>timeout</code> parameter when running a job. The timeout can be specified in two ways:",Vt,Ms,ea="<li><strong>As a number</strong> (interpreted as seconds):</li>",Lt,ds,St,_,aa="<li><strong>As a string with time units</strong>:</li>",Xt,ys,At,fs,na="Supported time units:",zt,bs,la="<li><code>s</code> - seconds</li> <li><code>m</code> - minutes</li> <li><code>h</code> - hours</li> <li><code>d</code> - days</li>",Ft,Js,Pt,Ts,pa="For UV jobs, you can also specify the timeout:",Dt,ws,Kt,I,Ot,Us,se,_s,ia="When running long tasks, it’s good practice to:",te,Is,oa="<li>Estimate your job’s expected duration and set a timeout with some buffer</li> <li>Monitor your job’s progress through the logs</li> <li>Check the job status to ensure it hasn’t timed out</li>",ee,$s,ae,Cs,ca='For more details about the timeout parameter, see the <a href="https://huggingface.co/docs/huggingface_hub/package_reference/hf_api#huggingface_hub.HfApi.run_job.timeout" rel="nofollow"><code>run_job</code> API reference</a>.',ne,vs,le,ks,ua="You can pass environment variables to your job using <code>env</code> and <code>secrets</code>:",pe,qs,ie,Gs,oe,Ws,ce,$,ue,Zs,ha="Run UV scripts (Python scripts with inline dependencies) on HF infrastructure:",he,Bs,re,xs,ra='UV scripts are Python scripts that include their dependencies directly in the file using a special comment syntax. This makes them perfect for self-contained tasks that don’t require complex project setups. Learn more about UV scripts in the <a href="https://docs.astral.sh/uv/guides/scripts/" rel="nofollow">UV documentation</a>.',me,Hs,je,Ns,ma="While UV scripts can specify their dependencies inline, ML workloads often have complex dependencies. Using pre-built Docker images with these libraries already installed can significantly speed up job startup and avoid dependency issues.",ge,Es,ja="By default, when you run <code>hf jobs uv run</code> the <code>astral-sh/uv:python3.12-bookworm</code> image is used. This image is based on the Python 3.12 Bookworm distribution with uv pre-installed.",Me,Ys,ga="You can specify a different image using the <code>--image</code> flag:",de,Rs,ye,Qs,Ma="The above command will run using the <code>vllm/vllm-openai:latest</code> image. This approach could be useful if you are using vLLM for synthetic data generation.",fe,C,be,Vs,Je,Ls,da="Schedule and manage jobs that will run on HF infrastructure.",Te,Ss,ya='Use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_scheduled_job">create_scheduled_job()</a> or <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_scheduled_uv_job">create_scheduled_uv_job()</a> with a schedule of <code>@annually</code>, <code>@yearly</code>, <code>@monthly</code>, <code>@weekly</code>, <code>@daily</code>, <code>@hourly</code>, or a CRON schedule expression (e.g., <code>&quot;0 9 * * 1&quot;</code> for 9 AM every Monday):',we,Xs,Ue,As,fa='Use the same parameters as <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.run_job">run_job()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.run_uv_job">run_uv_job()</a> to pass environment variables, secrets, timeout, etc.',_e,zs,ba='Manage scheduled jobs using <code>list_scheduled_jobs</code>, <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.inspect_scheduled_job">inspect_scheduled_job()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.suspend_scheduled_job">suspend_scheduled_job()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.resume_scheduled_job">resume_scheduled_job()</a>, and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.delete_scheduled_job">delete_scheduled_job()</a>:',Ie,Fs,$e,Ps,Ce,Os,ve;return v=new J({props:{title:"Run and manage Jobs",local:"run-and-manage-jobs",headingTag:"h1"}}),T=new Ds({props:{$$slots:{default:[Ba]},$$scope:{ctx:b}}}),W=new J({props:{title:"Jobs Command Line Interface",local:"jobs-command-line-interface",headingTag:"h2"}}),x=new y({props:{code:"aGYlMjBqb2JzJTIwcnVuJTIwcHl0aG9uJTNBMy4xMiUyMHB5dGhvbiUyMC1jJTIwJTIycHJpbnQoJ0hlbGxvJTIwd29ybGQhJyklMjIlMEFoZiUyMGpvYnMlMjBydW4lMjAtLWZsYXZvciUyMGExMGctc21hbGwlMjBweXRvcmNoJTJGcHl0b3JjaCUzQTIuNi4wLWN1ZGExMi40LWN1ZG5uOS1kZXZlbCUyMHB5dGhvbiUyMC1jJTIwJTIyaW1wb3J0JTIwdG9yY2glM0IlMjBwcmludCh0b3JjaC5jdWRhLmdldF9kZXZpY2VfbmFtZSgpKSUyMg==",highlighted:`&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> run python:3.12 python -c <span class="hljs-string">&quot;print(&#x27;Hello world!&#x27;)&quot;</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> run --flavor a10g-small pytorch/pytorch:2.6.0-cuda12.4-cudnn9-devel python -c <span class="hljs-string">&quot;import torch; print(torch.cuda.get_device_name())&quot;</span>`,wrap:!1}}),N=new y({props:{code:"aGYlMjBqb2JzJTIwdXYlMjBydW4lMjBteV9zY3JpcHQucHklMEFoZiUyMGpvYnMlMjB1diUyMHJ1biUyMC0tZmxhdm9yJTIwYTEwZy1zbWFsbCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRmh1Z2dpbmdmYWNlJTJGdHJsJTJGbWFpbiUyRnRybCUyRnNjcmlwdHMlMkZzZnQucHklMjIlMjA=",highlighted:`&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> uv run my_script.py
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> uv run --flavor a10g-small <span class="hljs-string">&quot;https://raw.githubusercontent.com/huggingface/trl/main/trl/scripts/sft.py&quot;</span> `,wrap:!1}}),R=new J({props:{title:"Run a Job",local:"run-a-job",headingTag:"h2"}}),S=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl9qb2IlMEFydW5fam9iKCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEJTIycHl0aG9uJTNBMy4xMiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNvbW1hbmQlM0QlNUIlMjJweXRob24lMjIlMkMlMjAlMjItYyUyMiUyQyUyMCUyMnByaW50KCdIZWxsbyUyMGZyb20lMjB0aGUlMjBjbG91ZCEnKSUyMiU1RCUyQyUwQSklMEElMEFydW5fam9iKCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEJTIycHl0b3JjaCUyRnB5dG9yY2glM0EyLjYuMC1jdWRhMTIuNC1jdWRubjktZGV2ZWwlMjIlMkMlMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTVCJTIycHl0aG9uJTIyJTJDJTIwJTIyLWMlMjIlMkMlMjAlMjJpbXBvcnQlMjB0b3JjaCUzQiUyMHByaW50KHRvcmNoLmN1ZGEuZ2V0X2RldmljZV9uYW1lKCkpJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZmxhdm9yJTNEJTIyYTEwZy1zbWFsbCUyMiUyQyUwQSklMEElMEFydW5fam9iKCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEJTIycHl0aG9uJTNBMy4xMiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNvbW1hbmQlM0QlNUIlMjJweXRob24lMjIlMkMlMjAlMjItYyUyMiUyQyUyMCUyMnByaW50KCdSdW5uaW5nJTIwaW4lMjBhbiUyMG9yZyUyMGFjY291bnQnKSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMG5hbWVzcGFjZSUzRCUyMm15LW9yZy1uYW1lJTIyJTJDJTBBKSUwQSUwQXJ1bl9qb2IoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlMjJoZi5jbyUyRnNwYWNlcyUyRmxob2VzdHElMkZkdWNrZGIlMjIlMkMlMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTVCJTIyZHVja2RiJTIyJTJDJTIwJTIyLWMlMjIlMkMlMjAlMjJzZWxlY3QlMjAnaGVsbG8lMjB3b3JsZCclMjIlNUQlMkMlMEEpJTBBJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl91dl9qb2IlMEFydW5fdXZfam9iKCUyMm15X3NjcmlwdC5weSUyMik=",highlighted:`<span class="hljs-comment"># Directly run Python code</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_job
<span class="hljs-meta">&gt;&gt;&gt; </span>run_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;python:3.12&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;print(&#x27;Hello from the cloud!&#x27;)&quot;</span>],
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># Use GPUs without any setup</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>run_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;pytorch/pytorch:2.6.0-cuda12.4-cudnn9-devel&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;import torch; print(torch.cuda.get_device_name())&quot;</span>],
<span class="hljs-meta">... </span>    flavor=<span class="hljs-string">&quot;a10g-small&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># Run in an organization account</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>run_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;python:3.12&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;print(&#x27;Running in an org account&#x27;)&quot;</span>],
<span class="hljs-meta">... </span>    namespace=<span class="hljs-string">&quot;my-org-name&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># Run from Hugging Face Spaces</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>run_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;hf.co/spaces/lhoestq/duckdb&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;duckdb&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;select &#x27;hello world&#x27;&quot;</span>],
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># Run a Python script with \`uv\` (experimental)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_uv_job
<span class="hljs-meta">&gt;&gt;&gt; </span>run_uv_job(<span class="hljs-string">&quot;my_script.py&quot;</span>)`,wrap:!1}}),w=new Ds({props:{warning:!0,$$slots:{default:[xa]},$$scope:{ctx:b}}}),A=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl9qb2IlMEFqb2IlMjAlM0QlMjBydW5fam9iKCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEJTIycHl0aG9uJTNBMy4xMiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNvbW1hbmQlM0QlNUIlMjJweXRob24lMjIlMkMlMjAlMjItYyUyMiUyQyUyMCUyMnByaW50KCdIZWxsbyUyMGZyb20lMjB0aGUlMjBjbG91ZCEnKSUyMiU1RCUwQSklMEFqb2IudXJsJTBBam9iLmlk",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_job
<span class="hljs-meta">&gt;&gt;&gt; </span>job = run_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;python:3.12&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;print(&#x27;Hello from the cloud!&#x27;)&quot;</span>]
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>job.url
https://huggingface.co/jobs/lhoestq/687f911eaea852de79c4a50a
<span class="hljs-meta">&gt;&gt;&gt; </span>job.<span class="hljs-built_in">id</span>
687f911eaea852de79c4a50a`,wrap:!1}}),F=new J({props:{title:"Check Job status",local:"check-job-status",headingTag:"h2"}}),P=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3Rfam9icyUwQWpvYnMlMjAlM0QlMjBsaXN0X2pvYnMoKSUwQWpvYnMlNUIwJTVEJTBBJTBBcnVubmluZ19qb2JzJTIwJTNEJTIwJTVCam9iJTIwZm9yJTIwam9iJTIwaW4lMjBsaXN0X2pvYnMoKSUyMGlmJTIwam9iLnN0YXR1cy5zdGFnZSUyMCUzRCUzRCUyMCUyMlJVTk5JTkclMjIlNUQlMEElMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwaW5zcGVjdF9qb2IlMEFpbnNwZWN0X2pvYihqb2JfaWQlM0Rqb2JfaWQpJTBBJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGZldGNoX2pvYl9sb2dzJTBBZm9yJTIwbG9nJTIwaW4lMjBmZXRjaF9qb2JfbG9ncyhqb2JfaWQlM0Rqb2JfaWQpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQobG9nKSUwQSUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBjYW5jZWxfam9iJTBBY2FuY2VsX2pvYihqb2JfaWQlM0Rqb2JfaWQp",highlighted:`<span class="hljs-comment"># List your jobs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_jobs
<span class="hljs-meta">&gt;&gt;&gt; </span>jobs = list_jobs()
<span class="hljs-meta">&gt;&gt;&gt; </span>jobs[<span class="hljs-number">0</span>]
JobInfo(<span class="hljs-built_in">id</span>=<span class="hljs-string">&#x27;687f911eaea852de79c4a50a&#x27;</span>, created_at=datetime.datetime(<span class="hljs-number">2025</span>, <span class="hljs-number">7</span>, <span class="hljs-number">22</span>, <span class="hljs-number">13</span>, <span class="hljs-number">24</span>, <span class="hljs-number">46</span>, <span class="hljs-number">909000</span>, tzinfo=datetime.timezone.utc), docker_image=<span class="hljs-string">&#x27;python:3.12&#x27;</span>, space_id=<span class="hljs-literal">None</span>, command=[<span class="hljs-string">&#x27;python&#x27;</span>, <span class="hljs-string">&#x27;-c&#x27;</span>, <span class="hljs-string">&quot;print(&#x27;Hello from the cloud!&#x27;)&quot;</span>], arguments=[], environment={}, secrets={}, flavor=<span class="hljs-string">&#x27;cpu-basic&#x27;</span>, status=JobStatus(stage=<span class="hljs-string">&#x27;COMPLETED&#x27;</span>, message=<span class="hljs-literal">None</span>), owner=JobOwner(<span class="hljs-built_in">id</span>=<span class="hljs-string">&#x27;5e9ecfc04957053f60648a3e&#x27;</span>, name=<span class="hljs-string">&#x27;lhoestq&#x27;</span>), endpoint=<span class="hljs-string">&#x27;https://huggingface.co&#x27;</span>, url=<span class="hljs-string">&#x27;https://huggingface.co/jobs/lhoestq/687f911eaea852de79c4a50a&#x27;</span>)

<span class="hljs-comment"># List your running jobs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>running_jobs = [job <span class="hljs-keyword">for</span> job <span class="hljs-keyword">in</span> list_jobs() <span class="hljs-keyword">if</span> job.status.stage == <span class="hljs-string">&quot;RUNNING&quot;</span>]

<span class="hljs-comment"># Inspect the status of a job</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> inspect_job
<span class="hljs-meta">&gt;&gt;&gt; </span>inspect_job(job_id=job_id)
JobInfo(<span class="hljs-built_in">id</span>=<span class="hljs-string">&#x27;687f911eaea852de79c4a50a&#x27;</span>, created_at=datetime.datetime(<span class="hljs-number">2025</span>, <span class="hljs-number">7</span>, <span class="hljs-number">22</span>, <span class="hljs-number">13</span>, <span class="hljs-number">24</span>, <span class="hljs-number">46</span>, <span class="hljs-number">909000</span>, tzinfo=datetime.timezone.utc), docker_image=<span class="hljs-string">&#x27;python:3.12&#x27;</span>, space_id=<span class="hljs-literal">None</span>, command=[<span class="hljs-string">&#x27;python&#x27;</span>, <span class="hljs-string">&#x27;-c&#x27;</span>, <span class="hljs-string">&quot;print(&#x27;Hello from the cloud!&#x27;)&quot;</span>], arguments=[], environment={}, secrets={}, flavor=<span class="hljs-string">&#x27;cpu-basic&#x27;</span>, status=JobStatus(stage=<span class="hljs-string">&#x27;COMPLETED&#x27;</span>, message=<span class="hljs-literal">None</span>), owner=JobOwner(<span class="hljs-built_in">id</span>=<span class="hljs-string">&#x27;5e9ecfc04957053f60648a3e&#x27;</span>, name=<span class="hljs-string">&#x27;lhoestq&#x27;</span>), endpoint=<span class="hljs-string">&#x27;https://huggingface.co&#x27;</span>, url=<span class="hljs-string">&#x27;https://huggingface.co/jobs/lhoestq/687f911eaea852de79c4a50a&#x27;</span>)

<span class="hljs-comment"># View logs from a job</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> fetch_job_logs
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> fetch_job_logs(job_id=job_id):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(log)
Hello <span class="hljs-keyword">from</span> the cloud!

<span class="hljs-comment"># Cancel a job</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> cancel_job
<span class="hljs-meta">&gt;&gt;&gt; </span>cancel_job(job_id=job_id)`,wrap:!1}}),K=new y({props:{code:"aW1wb3J0JTIwdGltZSUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBpbnNwZWN0X2pvYiUyQyUyMHJ1bl9qb2IlMEFqb2JzJTIwJTNEJTIwJTVCcnVuX2pvYihpbWFnZSUzRGltYWdlJTJDJTIwY29tbWFuZCUzRGNvbW1hbmQpJTIwZm9yJTIwY29tbWFuZCUyMGluJTIwY29tbWFuZHMlNUQlMEFmb3IlMjBqb2IlMjBpbiUyMGpvYnMlM0ElMEElMjAlMjAlMjAlMjB3aGlsZSUyMGluc3BlY3Rfam9iKGpvYl9pZCUzRGpvYi5pZCkuc3RhdHVzLnN0YWdlJTIwbm90JTIwaW4lMjAoJTIyQ09NUExFVEVEJTIyJTJDJTIwJTIyRVJST1IlMjIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGltZS5zbGVlcCgxMCk=",highlighted:`<span class="hljs-comment"># Run multiple jobs in parallel and wait for their completions</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> time
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> inspect_job, run_job
<span class="hljs-meta">&gt;&gt;&gt; </span>jobs = [run_job(image=image, command=command) <span class="hljs-keyword">for</span> command <span class="hljs-keyword">in</span> commands]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> job <span class="hljs-keyword">in</span> jobs:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">while</span> inspect_job(job_id=job.<span class="hljs-built_in">id</span>).status.stage <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> (<span class="hljs-string">&quot;COMPLETED&quot;</span>, <span class="hljs-string">&quot;ERROR&quot;</span>):
<span class="hljs-meta">... </span>        time.sleep(<span class="hljs-number">10</span>)`,wrap:!1}}),O=new J({props:{title:"Select the hardware",local:"select-the-hardware",headingTag:"h2"}}),as=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl9qb2IlMEFydW5fam9iKCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEJTIycHl0b3JjaCUyRnB5dG9yY2glM0EyLjYuMC1jdWRhMTIuNC1jdWRubjktZGV2ZWwlMjIlMkMlMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTVCJTIycHl0aG9uJTIyJTJDJTIwJTIyLWMlMjIlMkMlMjAlMjJpbXBvcnQlMjB0b3JjaCUzQiUyMHByaW50KGYnVGhpcyUyMGNvZGUlMjByYW4lMjB3aXRoJTIwdGhlJTIwZm9sbG93aW5nJTIwR1BVJTNBJTIwJTdCdG9yY2guY3VkYS5nZXRfZGV2aWNlX25hbWUoKSU3RCcpJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZmxhdm9yJTNEJTIyYTEwZy1zbWFsbCUyMiUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Use an A10G GPU to check PyTorch CUDA</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_job
<span class="hljs-meta">&gt;&gt;&gt; </span>run_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;pytorch/pytorch:2.6.0-cuda12.4-cudnn9-devel&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;import torch; print(f&#x27;This code ran with the following GPU: {torch.cuda.get_device_name()}&#x27;)&quot;</span>],
<span class="hljs-meta">... </span>    flavor=<span class="hljs-string">&quot;a10g-small&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),ls=new y({props:{code:"VGhpcyUyMGNvZGUlMjByYW4lMjB3aXRoJTIwdGhlJTIwZm9sbG93aW5nJTIwR1BVJTNBJTIwTlZJRElBJTIwQTEwRw==",highlighted:"This code ran with the following GPU: NVIDIA A10G",wrap:!1}}),is=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl91dl9qb2IlMEFydW5fdXZfam9iKCUwQSUyMCUyMCUyMCUyMCUyMnNmdC5weSUyMiUyQyUwQSUyMCUyMCUyMCUyMHNjcmlwdF9hcmdzJTNEJTVCJTIyLS1tb2RlbF9uYW1lX29yX3BhdGglMjIlMkMlMjAlMjJRd2VuJTJGUXdlbjItMC41QiUyMiUyQyUyMC4uLiU1RCUyQyUwQSUyMCUyMCUyMCUyMGRlcGVuZGVuY2llcyUzRCU1QiUyMnRybCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMkhGX1RPS0VOJTIyJTNBJTIwLi4uJTdEJTJDJTBBJTIwJTIwJTIwJTIwZmxhdm9yJTNEJTIyYTEwZy1zbWFsbCUyMiUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_uv_job
<span class="hljs-meta">&gt;&gt;&gt; </span>run_uv_job(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;sft.py&quot;</span>,
<span class="hljs-meta">... </span>    script_args=[<span class="hljs-string">&quot;--model_name_or_path&quot;</span>, <span class="hljs-string">&quot;Qwen/Qwen2-0.5B&quot;</span>, ...],
<span class="hljs-meta">... </span>    dependencies=[<span class="hljs-string">&quot;trl&quot;</span>],
<span class="hljs-meta">... </span>    env={<span class="hljs-string">&quot;HF_TOKEN&quot;</span>: ...},
<span class="hljs-meta">... </span>    flavor=<span class="hljs-string">&quot;a10g-small&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),U=new Ds({props:{$$slots:{default:[Ha]},$$scope:{ctx:b}}}),rs=new J({props:{title:"Configure Job Timeout",local:"configure-job-timeout",headingTag:"h2"}}),js=new J({props:{title:"Setting a custom timeout",local:"setting-a-custom-timeout",headingTag:"h3"}}),ds=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl9qb2IlMEFqb2IlMjAlM0QlMjBydW5fam9iKCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEJTIycHl0b3JjaCUyRnB5dG9yY2glM0EyLjYuMC1jdWRhMTIuNC1jdWRubjktZGV2ZWwlMjIlMkMlMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTVCJTIycHl0aG9uJTIyJTJDJTIwJTIydHJhaW5fbW9kZWwucHklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBmbGF2b3IlM0QlMjJhMTBnLWxhcmdlJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGltZW91dCUzRDcyMDAlMkMlMjAlMjAlMjMlMjAyJTIwaG91cnMlMjBpbiUyMHNlY29uZHMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_job
<span class="hljs-meta">&gt;&gt;&gt; </span>job = run_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;pytorch/pytorch:2.6.0-cuda12.4-cudnn9-devel&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;train_model.py&quot;</span>],
<span class="hljs-meta">... </span>    flavor=<span class="hljs-string">&quot;a10g-large&quot;</span>,
<span class="hljs-meta">... </span>    timeout=<span class="hljs-number">7200</span>,  <span class="hljs-comment"># 2 hours in seconds</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),ys=new y({props:{code:"JTIzJTIwVXNpbmclMjBkaWZmZXJlbnQlMjB0aW1lJTIwdW5pdHMlMEFqb2IlMjAlM0QlMjBydW5fam9iKCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEJTIycHl0b3JjaCUyRnB5dG9yY2glM0EyLjYuMC1jdWRhMTIuNC1jdWRubjktZGV2ZWwlMjIlMkMlMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTVCJTIycHl0aG9uJTIyJTJDJTIwJTIydHJhaW5fbW9kZWwucHklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBmbGF2b3IlM0QlMjJhMTBnLWxhcmdlJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGltZW91dCUzRCUyMjJoJTIyJTJDJTIwJTIwJTIzJTIwMiUyMGhvdXJzJTBBKSUwQSUwQSUyMyUyME90aGVyJTIwZXhhbXBsZXMlM0ElMEElMjMlMjB0aW1lb3V0JTNEJTIyMzBtJTIyJTIwJTIwJTIwJTIwJTIzJTIwMzAlMjBtaW51dGVzJTBBJTIzJTIwdGltZW91dCUzRCUyMjEuNWglMjIlMjAlMjAlMjAlMjMlMjAxLjUlMjBob3VycyUwQSUyMyUyMHRpbWVvdXQlM0QlMjIxZCUyMiUyMCUyMCUyMCUyMCUyMCUyMyUyMDElMjBkYXklMEElMjMlMjB0aW1lb3V0JTNEJTIyMzYwMHMlMjIlMjAlMjAlMjMlMjAzNjAwJTIwc2Vjb25kcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Using different time units</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>job = run_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;pytorch/pytorch:2.6.0-cuda12.4-cudnn9-devel&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;train_model.py&quot;</span>],
<span class="hljs-meta">... </span>    flavor=<span class="hljs-string">&quot;a10g-large&quot;</span>,
<span class="hljs-meta">... </span>    timeout=<span class="hljs-string">&quot;2h&quot;</span>,  <span class="hljs-comment"># 2 hours</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Other examples:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># timeout=&quot;30m&quot;    # 30 minutes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># timeout=&quot;1.5h&quot;   # 1.5 hours</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># timeout=&quot;1d&quot;     # 1 day</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># timeout=&quot;3600s&quot;  # 3600 seconds</span>`,wrap:!1}}),Js=new J({props:{title:"Using timeout with UV jobs",local:"using-timeout-with-uv-jobs",headingTag:"h3"}}),ws=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl91dl9qb2IlMEFqb2IlMjAlM0QlMjBydW5fdXZfam9iKCUwQSUyMCUyMCUyMCUyMCUyMnRyYWluaW5nX3NjcmlwdC5weSUyMiUyQyUwQSUyMCUyMCUyMCUyMGZsYXZvciUzRCUyMmExMGctbGFyZ2UlMjIlMkMlMEElMjAlMjAlMjAlMjB0aW1lb3V0JTNEJTIyOTBtJTIyJTJDJTIwJTIwJTIzJTIwOTAlMjBtaW51dGVzJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_uv_job
<span class="hljs-meta">&gt;&gt;&gt; </span>job = run_uv_job(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;training_script.py&quot;</span>,
<span class="hljs-meta">... </span>    flavor=<span class="hljs-string">&quot;a10g-large&quot;</span>,
<span class="hljs-meta">... </span>    timeout=<span class="hljs-string">&quot;90m&quot;</span>,  <span class="hljs-comment"># 90 minutes</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),I=new Ds({props:{warning:!0,$$slots:{default:[Na]},$$scope:{ctx:b}}}),Us=new J({props:{title:"Monitoring job duration",local:"monitoring-job-duration",headingTag:"h3"}}),$s=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGluc3BlY3Rfam9iJTJDJTIwZmV0Y2hfam9iX2xvZ3MlMEElMjMlMjBDaGVjayUyMGpvYiUyMHN0YXR1cyUwQWpvYl9pbmZvJTIwJTNEJTIwaW5zcGVjdF9qb2Ioam9iX2lkJTNEam9iLmlkKSUwQWlmJTIwam9iX2luZm8uc3RhdHVzLnN0YWdlJTIwJTNEJTNEJTIwJTIyRVJST1IlMjIlM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIySm9iJTIwZmFpbGVkJTNBJTIwJTdCam9iX2luZm8uc3RhdHVzLm1lc3NhZ2UlN0QlMjIpJTBBJTIwJTIwJTIwJTIwJTIzJTIwQ2hlY2slMjBsb2dzJTIwZm9yJTIwbW9yZSUyMGRldGFpbHMlMEElMjAlMjAlMjAlMjBmb3IlMjBsb2clMjBpbiUyMGZldGNoX2pvYl9sb2dzKGpvYl9pZCUzRGpvYi5pZCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChsb2cp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> inspect_job, fetch_job_logs
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Check job status</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>job_info = inspect_job(job_id=job.<span class="hljs-built_in">id</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> job_info.status.stage == <span class="hljs-string">&quot;ERROR&quot;</span>:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Job failed: <span class="hljs-subst">{job_info.status.message}</span>&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Check logs for more details</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> fetch_job_logs(job_id=job.<span class="hljs-built_in">id</span>):
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(log)`,wrap:!1}}),vs=new J({props:{title:"Pass Environment variables and Secrets",local:"pass-environment-variables-and-secrets",headingTag:"h2"}}),qs=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl9qb2IlMEFydW5fam9iKCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEJTIycHl0aG9uJTNBMy4xMiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNvbW1hbmQlM0QlNUIlMjJweXRob24lMjIlMkMlMjAlMjItYyUyMiUyQyUyMCUyMmltcG9ydCUyMG9zJTNCJTIwcHJpbnQob3MuZW52aXJvbiU1QidGT08nJTVEJTJDJTIwb3MuZW52aXJvbiU1QidCQVInJTVEKSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMkZPTyUyMiUzQSUyMCUyMmZvbyUyMiUyQyUyMCUyMkJBUiUyMiUzQSUyMCUyMmJhciUyMiU3RCUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Pass environment variables</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_job
<span class="hljs-meta">&gt;&gt;&gt; </span>run_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;python:3.12&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;import os; print(os.environ[&#x27;FOO&#x27;], os.environ[&#x27;BAR&#x27;])&quot;</span>],
<span class="hljs-meta">... </span>    env={<span class="hljs-string">&quot;FOO&quot;</span>: <span class="hljs-string">&quot;foo&quot;</span>, <span class="hljs-string">&quot;BAR&quot;</span>: <span class="hljs-string">&quot;bar&quot;</span>},
<span class="hljs-meta">... </span>)`,wrap:!1}}),Gs=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl9qb2IlMEFydW5fam9iKCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEJTIycHl0aG9uJTNBMy4xMiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNvbW1hbmQlM0QlNUIlMjJweXRob24lMjIlMkMlMjAlMjItYyUyMiUyQyUyMCUyMmltcG9ydCUyMG9zJTNCJTIwcHJpbnQob3MuZW52aXJvbiU1QidNWV9TRUNSRVQnJTVEKSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHNlY3JldHMlM0QlN0IlMjJNWV9TRUNSRVQlMjIlM0ElMjAlMjJwc3N3cmQlMjIlN0QlMkMlMEEp",highlighted:`<span class="hljs-comment"># Pass secrets - they will be encrypted server side</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_job
<span class="hljs-meta">&gt;&gt;&gt; </span>run_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;python:3.12&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;import os; print(os.environ[&#x27;MY_SECRET&#x27;])&quot;</span>],
<span class="hljs-meta">... </span>    secrets={<span class="hljs-string">&quot;MY_SECRET&quot;</span>: <span class="hljs-string">&quot;psswrd&quot;</span>},
<span class="hljs-meta">... </span>)`,wrap:!1}}),Ws=new J({props:{title:"UV Scripts (Experimental)",local:"uv-scripts-experimental",headingTag:"h3"}}),$=new Ds({props:{$$slots:{default:[Ea]},$$scope:{ctx:b}}}),Bs=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl91dl9qb2IlMEFydW5fdXZfam9iKCUyMm15X3NjcmlwdC5weSUyMiklMEElMEFydW5fdXZfam9iKCUyMm1sX3RyYWluaW5nLnB5JTIyJTJDJTIwZmxhdm9yJTNEJTIyZ3B1LXQ0LXNtYWxsJTIyKSUwQSUwQXJ1bl91dl9qb2IoJTIyaW5mZXJlbmNlLnB5JTIyJTJDJTIwZGVwZW5kZW5jaWVzJTNEJTVCJTIydHJhbnNmb3JtZXJzJTIyJTJDJTIwJTIydG9yY2glMjIlNUQpJTBBJTBBcnVuX3V2X2pvYiglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZ1c2VybmFtZSUyRnNjcmlwdHMlMkZyZXNvbHZlJTJGbWFpbiUyRmV4YW1wbGUucHklMjIpJTBBJTBBcnVuX3V2X2pvYiglMjJweXRob24lMjIlMkMlMjBzY3JpcHRfYXJncyUzRCU1QiUyMi1jJTIyJTJDJTIwJTIyaW1wb3J0JTIwbGlnaHRldmFsJTIyJTVEJTJDJTIwZGVwZW5kZW5jaWVzJTNEJTVCJTIybGlnaHRldmFsJTIyJTVEKQ==",highlighted:`<span class="hljs-comment"># Run a UV script (creates temporary repo)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_uv_job
<span class="hljs-meta">&gt;&gt;&gt; </span>run_uv_job(<span class="hljs-string">&quot;my_script.py&quot;</span>)

<span class="hljs-comment"># Run with GPU</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>run_uv_job(<span class="hljs-string">&quot;ml_training.py&quot;</span>, flavor=<span class="hljs-string">&quot;gpu-t4-small&quot;</span>)

<span class="hljs-comment"># Run with dependencies</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>run_uv_job(<span class="hljs-string">&quot;inference.py&quot;</span>, dependencies=[<span class="hljs-string">&quot;transformers&quot;</span>, <span class="hljs-string">&quot;torch&quot;</span>])

<span class="hljs-comment"># Run a script directly from a URL</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>run_uv_job(<span class="hljs-string">&quot;https://huggingface.co/datasets/username/scripts/resolve/main/example.py&quot;</span>)

<span class="hljs-comment"># Run a command</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>run_uv_job(<span class="hljs-string">&quot;python&quot;</span>, script_args=[<span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;import lighteval&quot;</span>], dependencies=[<span class="hljs-string">&quot;lighteval&quot;</span>])`,wrap:!1}}),Hs=new J({props:{title:"Docker Images for UV Scripts",local:"docker-images-for-uv-scripts",headingTag:"h4"}}),Rs=new y({props:{code:"aGYlMjBqb2JzJTIwdXYlMjBydW4lMjAlNUMlMEElMjAtLWZsYXZvciUyMGExMGctbGFyZ2UlMjAlNUMlMEElMjAtLWltYWdlJTIwdmxsbSUyRnZsbG0tb3BlbmFpJTNBbGF0ZXN0JTIwJTVDJTBBLi4u",highlighted:`hf <span class="hljs-built_in">jobs</span> uv run \\
 --flavor a10g-large \\
 --image vllm/vllm-openai:latest \\
...`,wrap:!1}}),C=new Ds({props:{$$slots:{default:[Ya]},$$scope:{ctx:b}}}),Vs=new J({props:{title:"Scheduled Jobs",local:"scheduled-jobs",headingTag:"h3"}}),Xs=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9zY2hlZHVsZWRfam9iJTBBY3JlYXRlX3NjaGVkdWxlZF9qb2IoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlMjJweXRob24lM0EzLjEyJTIyJTJDJTBBJTIwJTIwJTIwJTIwY29tbWFuZCUzRCU1QiUyMnB5dGhvbiUyMiUyQyUyMCUyMCUyMi1jJTIyJTJDJTIwJTIycHJpbnQoJ1RoaXMlMjBydW5zJTIwZXZlcnklMjBob3VyIScpJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwc2NoZWR1bGUlM0QlMjIlNDBob3VybHklMjIlMEEpJTBBJTBBY3JlYXRlX3NjaGVkdWxlZF9qb2IoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlMjJweXRob24lM0EzLjEyJTIyJTJDJTBBJTIwJTIwJTIwJTIwY29tbWFuZCUzRCU1QiUyMnB5dGhvbiUyMiUyQyUyMCUyMCUyMi1jJTIyJTJDJTIwJTIycHJpbnQoJ1RoaXMlMjBydW5zJTIwZXZlcnklMjA1JTIwbWludXRlcyEnKSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlJTNEJTIyKiUyRjUlMjAqJTIwKiUyMColMjAqJTIyJTBBKSUwQSUwQWNyZWF0ZV9zY2hlZHVsZWRfam9iKCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEJTIycHl0b3JjaCUyRnB5dG9yY2glM0EyLjYuMC1jdWRhMTIuNC1jdWRubjktZGV2ZWwlMjIlMkMlMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTVCJTIycHl0aG9uJTIyJTJDJTIwJTIwJTIyLWMlMjIlMkMlMjAnaW1wb3J0JTIwdG9yY2glM0IlMjBwcmludChmJTIyVGhpcyUyMGNvZGUlMjByYW4lMjB3aXRoJTIwdGhlJTIwZm9sbG93aW5nJTIwR1BVJTNBJTIwJTdCdG9yY2guY3VkYS5nZXRfZGV2aWNlX25hbWUoKSU3RCUyMiknJTVEJTJDJTBBJTIwJTIwJTIwJTIwc2NoZWR1bGUlM0QlMjIlNDBob3VybHklMjIlMkMlMEElMjAlMjAlMjAlMjBmbGF2b3IlM0QlMjJhMTBnLXNtYWxsJTIyJTJDJTBBKSUwQSUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBjcmVhdGVfc2NoZWR1bGVkX3V2X2pvYiUwQWNyZWF0ZV9zY2hlZHVsZWRfdXZfam9iKCUyMm15X3NjcmlwdC5weSUyMiUyQyUyMHNjaGVkdWxlJTNEJTIyJTQwaG91cmx5JTIyKQ==",highlighted:`<span class="hljs-comment"># Schedule a job that runs every hour</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_scheduled_job
<span class="hljs-meta">&gt;&gt;&gt; </span>create_scheduled_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;python:3.12&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;python&quot;</span>,  <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;print(&#x27;This runs every hour!&#x27;)&quot;</span>],
<span class="hljs-meta">... </span>    schedule=<span class="hljs-string">&quot;@hourly&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># Use the CRON syntax</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>create_scheduled_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;python:3.12&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;python&quot;</span>,  <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;print(&#x27;This runs every 5 minutes!&#x27;)&quot;</span>],
<span class="hljs-meta">... </span>    schedule=<span class="hljs-string">&quot;*/5 * * * *&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># Schedule with GPU</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>create_scheduled_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;pytorch/pytorch:2.6.0-cuda12.4-cudnn9-devel&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;python&quot;</span>,  <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&#x27;import torch; print(f&quot;This code ran with the following GPU: {torch.cuda.get_device_name()}&quot;)&#x27;</span>],
<span class="hljs-meta">... </span>    schedule=<span class="hljs-string">&quot;@hourly&quot;</span>,
<span class="hljs-meta">... </span>    flavor=<span class="hljs-string">&quot;a10g-small&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># Schedule a UV script</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_scheduled_uv_job
<span class="hljs-meta">&gt;&gt;&gt; </span>create_scheduled_uv_job(<span class="hljs-string">&quot;my_script.py&quot;</span>, schedule=<span class="hljs-string">&quot;@hourly&quot;</span>)`,wrap:!1}}),Fs=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3Rfc2NoZWR1bGVkX2pvYnMlMEFsaXN0X3NjaGVkdWxlZF9qb2JzKCklMEElMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwaW5zcGVjdF9zY2hlZHVsZWRfam9iJTBBaW5zcGVjdF9zY2hlZHVsZWRfam9iKHNjaGVkdWxlZF9qb2JfaWQpJTBBJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHN1c3BlbmRfc2NoZWR1bGVkX2pvYiUwQXN1c3BlbmRfc2NoZWR1bGVkX2pvYihzY2hlZHVsZWRfam9iX2lkKSUwQSUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjByZXN1bWVfc2NoZWR1bGVkX2pvYiUwQXJlc3VtZV9zY2hlZHVsZWRfam9iKHNjaGVkdWxlZF9qb2JfaWQpJTBBJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGRlbGV0ZV9zY2hlZHVsZWRfam9iJTBBZGVsZXRlX3NjaGVkdWxlZF9qb2Ioc2NoZWR1bGVkX2pvYl9pZCk=",highlighted:`<span class="hljs-comment"># List your active scheduled jobs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_scheduled_jobs
<span class="hljs-meta">&gt;&gt;&gt; </span>list_scheduled_jobs()

<span class="hljs-comment"># Inspect the status of a job</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> inspect_scheduled_job
<span class="hljs-meta">&gt;&gt;&gt; </span>inspect_scheduled_job(scheduled_job_id)

<span class="hljs-comment"># Suspend (pause) a scheduled job</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> suspend_scheduled_job
<span class="hljs-meta">&gt;&gt;&gt; </span>suspend_scheduled_job(scheduled_job_id)

<span class="hljs-comment"># Resume a scheduled job</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> resume_scheduled_job
<span class="hljs-meta">&gt;&gt;&gt; </span>resume_scheduled_job(scheduled_job_id)

<span class="hljs-comment"># Delete a scheduled job</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> delete_scheduled_job
<span class="hljs-meta">&gt;&gt;&gt; </span>delete_scheduled_job(scheduled_job_id)`,wrap:!1}}),Ps=new Za({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/jobs.md"}}),{c(){p=i("meta"),d=n(),u=i("p"),f=n(),h(v.$$.fragment),st=n(),k=i("p"),k.textContent=qe,tt=n(),q=i("ul"),q.innerHTML=Ge,et=n(),G=i("p"),G.innerHTML=We,at=n(),h(T.$$.fragment),nt=n(),h(W.$$.fragment),lt=n(),Z=i("p"),Z.innerHTML=Ze,pt=n(),B=i("p"),B.innerHTML=Be,it=n(),h(x.$$.fragment),ot=n(),H=i("p"),H.innerHTML=xe,ct=n(),h(N.$$.fragment),ut=n(),E=i("p"),E.innerHTML=He,ht=n(),Y=i("p"),Y.innerHTML=Ne,rt=n(),h(R.$$.fragment),mt=n(),Q=i("p"),Q.textContent=Ee,jt=n(),V=i("p"),V.textContent=Ye,gt=n(),L=i("p"),L.innerHTML=Re,Mt=n(),h(S.$$.fragment),dt=n(),h(w.$$.fragment),yt=n(),X=i("p"),X.innerHTML=Qe,ft=n(),h(A.$$.fragment),bt=n(),z=i("p"),z.innerHTML=Ve,Jt=n(),h(F.$$.fragment),Tt=n(),h(P.$$.fragment),wt=n(),D=i("p"),D.innerHTML=Le,Ut=n(),h(K.$$.fragment),_t=n(),h(O.$$.fragment),It=n(),ss=i("p"),ss.textContent=Se,$t=n(),ts=i("ul"),ts.innerHTML=Xe,Ct=n(),es=i("p"),es.innerHTML=Ae,vt=n(),h(as.$$.fragment),kt=n(),ns=i("p"),ns.textContent=ze,qt=n(),h(ls.$$.fragment),Gt=n(),ps=i("p"),ps.innerHTML=Fe,Wt=n(),h(is.$$.fragment),Zt=n(),h(U.$$.fragment),Bt=n(),os=i("p"),os.innerHTML=Pe,xt=n(),cs=i("ul"),cs.innerHTML=De,Ht=n(),us=i("p"),us.innerHTML=Ke,Nt=n(),hs=i("p"),hs.textContent=Oe,Et=n(),h(rs.$$.fragment),Yt=n(),ms=i("p"),ms.textContent=sa,Rt=n(),h(js.$$.fragment),Qt=n(),gs=i("p"),gs.innerHTML=ta,Vt=n(),Ms=i("ol"),Ms.innerHTML=ea,Lt=n(),h(ds.$$.fragment),St=n(),_=i("ol"),_.innerHTML=aa,Xt=n(),h(ys.$$.fragment),At=n(),fs=i("p"),fs.textContent=na,zt=n(),bs=i("ul"),bs.innerHTML=la,Ft=n(),h(Js.$$.fragment),Pt=n(),Ts=i("p"),Ts.textContent=pa,Dt=n(),h(ws.$$.fragment),Kt=n(),h(I.$$.fragment),Ot=n(),h(Us.$$.fragment),se=n(),_s=i("p"),_s.textContent=ia,te=n(),Is=i("ul"),Is.innerHTML=oa,ee=n(),h($s.$$.fragment),ae=n(),Cs=i("p"),Cs.innerHTML=ca,ne=n(),h(vs.$$.fragment),le=n(),ks=i("p"),ks.innerHTML=ua,pe=n(),h(qs.$$.fragment),ie=n(),h(Gs.$$.fragment),oe=n(),h(Ws.$$.fragment),ce=n(),h($.$$.fragment),ue=n(),Zs=i("p"),Zs.textContent=ha,he=n(),h(Bs.$$.fragment),re=n(),xs=i("p"),xs.innerHTML=ra,me=n(),h(Hs.$$.fragment),je=n(),Ns=i("p"),Ns.textContent=ma,ge=n(),Es=i("p"),Es.innerHTML=ja,Me=n(),Ys=i("p"),Ys.innerHTML=ga,de=n(),h(Rs.$$.fragment),ye=n(),Qs=i("p"),Qs.innerHTML=Ma,fe=n(),h(C.$$.fragment),be=n(),h(Vs.$$.fragment),Je=n(),Ls=i("p"),Ls.textContent=da,Te=n(),Ss=i("p"),Ss.innerHTML=ya,we=n(),h(Xs.$$.fragment),Ue=n(),As=i("p"),As.innerHTML=fa,_e=n(),zs=i("p"),zs.innerHTML=ba,Ie=n(),h(Fs.$$.fragment),$e=n(),h(Ps.$$.fragment),Ce=n(),Os=i("p"),this.h()},l(s){const t=Ga("svelte-u9bgzb",document.head);p=o(t,"META",{name:!0,content:!0}),t.forEach(e),d=l(s),u=o(s,"P",{}),$a(u).forEach(e),f=l(s),r(v.$$.fragment,s),st=l(s),k=o(s,"P",{"data-svelte-h":!0}),c(k)!=="svelte-t6wsly"&&(k.textContent=qe),tt=l(s),q=o(s,"UL",{"data-svelte-h":!0}),c(q)!=="svelte-q7wdvs"&&(q.innerHTML=Ge),et=l(s),G=o(s,"P",{"data-svelte-h":!0}),c(G)!=="svelte-7cmlg1"&&(G.innerHTML=We),at=l(s),r(T.$$.fragment,s),nt=l(s),r(W.$$.fragment,s),lt=l(s),Z=o(s,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-nb89vp"&&(Z.innerHTML=Ze),pt=l(s),B=o(s,"P",{"data-svelte-h":!0}),c(B)!=="svelte-khpb9d"&&(B.innerHTML=Be),it=l(s),r(x.$$.fragment,s),ot=l(s),H=o(s,"P",{"data-svelte-h":!0}),c(H)!=="svelte-2oc699"&&(H.innerHTML=xe),ct=l(s),r(N.$$.fragment,s),ut=l(s),E=o(s,"P",{"data-svelte-h":!0}),c(E)!=="svelte-1jtgrvk"&&(E.innerHTML=He),ht=l(s),Y=o(s,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-o9zjjm"&&(Y.innerHTML=Ne),rt=l(s),r(R.$$.fragment,s),mt=l(s),Q=o(s,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-q7l5as"&&(Q.textContent=Ee),jt=l(s),V=o(s,"P",{"data-svelte-h":!0}),c(V)!=="svelte-1rskhba"&&(V.textContent=Ye),gt=l(s),L=o(s,"P",{"data-svelte-h":!0}),c(L)!=="svelte-1t6shks"&&(L.innerHTML=Re),Mt=l(s),r(S.$$.fragment,s),dt=l(s),r(w.$$.fragment,s),yt=l(s),X=o(s,"P",{"data-svelte-h":!0}),c(X)!=="svelte-pv8bt6"&&(X.innerHTML=Qe),ft=l(s),r(A.$$.fragment,s),bt=l(s),z=o(s,"P",{"data-svelte-h":!0}),c(z)!=="svelte-amrg6a"&&(z.innerHTML=Ve),Jt=l(s),r(F.$$.fragment,s),Tt=l(s),r(P.$$.fragment,s),wt=l(s),D=o(s,"P",{"data-svelte-h":!0}),c(D)!=="svelte-7qiidc"&&(D.innerHTML=Le),Ut=l(s),r(K.$$.fragment,s),_t=l(s),r(O.$$.fragment,s),It=l(s),ss=o(s,"P",{"data-svelte-h":!0}),c(ss)!=="svelte-1egj941"&&(ss.textContent=Se),$t=l(s),ts=o(s,"UL",{"data-svelte-h":!0}),c(ts)!=="svelte-6zsta5"&&(ts.innerHTML=Xe),Ct=l(s),es=o(s,"P",{"data-svelte-h":!0}),c(es)!=="svelte-14jm2jm"&&(es.innerHTML=Ae),vt=l(s),r(as.$$.fragment,s),kt=l(s),ns=o(s,"P",{"data-svelte-h":!0}),c(ns)!=="svelte-130z5ko"&&(ns.textContent=ze),qt=l(s),r(ls.$$.fragment,s),Gt=l(s),ps=o(s,"P",{"data-svelte-h":!0}),c(ps)!=="svelte-s6s8yx"&&(ps.innerHTML=Fe),Wt=l(s),r(is.$$.fragment,s),Zt=l(s),r(U.$$.fragment,s),Bt=l(s),os=o(s,"P",{"data-svelte-h":!0}),c(os)!=="svelte-1hwnt8u"&&(os.innerHTML=Pe),xt=l(s),cs=o(s,"UL",{"data-svelte-h":!0}),c(cs)!=="svelte-13lveum"&&(cs.innerHTML=De),Ht=l(s),us=o(s,"P",{"data-svelte-h":!0}),c(us)!=="svelte-2bse8c"&&(us.innerHTML=Ke),Nt=l(s),hs=o(s,"P",{"data-svelte-h":!0}),c(hs)!=="svelte-u6u7ww"&&(hs.textContent=Oe),Et=l(s),r(rs.$$.fragment,s),Yt=l(s),ms=o(s,"P",{"data-svelte-h":!0}),c(ms)!=="svelte-2n3lu1"&&(ms.textContent=sa),Rt=l(s),r(js.$$.fragment,s),Qt=l(s),gs=o(s,"P",{"data-svelte-h":!0}),c(gs)!=="svelte-1fvqz69"&&(gs.innerHTML=ta),Vt=l(s),Ms=o(s,"OL",{"data-svelte-h":!0}),c(Ms)!=="svelte-g0lq88"&&(Ms.innerHTML=ea),Lt=l(s),r(ds.$$.fragment,s),St=l(s),_=o(s,"OL",{start:!0,"data-svelte-h":!0}),c(_)!=="svelte-11ooz1t"&&(_.innerHTML=aa),Xt=l(s),r(ys.$$.fragment,s),At=l(s),fs=o(s,"P",{"data-svelte-h":!0}),c(fs)!=="svelte-100e3nu"&&(fs.textContent=na),zt=l(s),bs=o(s,"UL",{"data-svelte-h":!0}),c(bs)!=="svelte-198b1xe"&&(bs.innerHTML=la),Ft=l(s),r(Js.$$.fragment,s),Pt=l(s),Ts=o(s,"P",{"data-svelte-h":!0}),c(Ts)!=="svelte-xy3irb"&&(Ts.textContent=pa),Dt=l(s),r(ws.$$.fragment,s),Kt=l(s),r(I.$$.fragment,s),Ot=l(s),r(Us.$$.fragment,s),se=l(s),_s=o(s,"P",{"data-svelte-h":!0}),c(_s)!=="svelte-yr7qor"&&(_s.textContent=ia),te=l(s),Is=o(s,"UL",{"data-svelte-h":!0}),c(Is)!=="svelte-17h393k"&&(Is.innerHTML=oa),ee=l(s),r($s.$$.fragment,s),ae=l(s),Cs=o(s,"P",{"data-svelte-h":!0}),c(Cs)!=="svelte-1llwhls"&&(Cs.innerHTML=ca),ne=l(s),r(vs.$$.fragment,s),le=l(s),ks=o(s,"P",{"data-svelte-h":!0}),c(ks)!=="svelte-cxmn16"&&(ks.innerHTML=ua),pe=l(s),r(qs.$$.fragment,s),ie=l(s),r(Gs.$$.fragment,s),oe=l(s),r(Ws.$$.fragment,s),ce=l(s),r($.$$.fragment,s),ue=l(s),Zs=o(s,"P",{"data-svelte-h":!0}),c(Zs)!=="svelte-qbe5en"&&(Zs.textContent=ha),he=l(s),r(Bs.$$.fragment,s),re=l(s),xs=o(s,"P",{"data-svelte-h":!0}),c(xs)!=="svelte-1dnltsa"&&(xs.innerHTML=ra),me=l(s),r(Hs.$$.fragment,s),je=l(s),Ns=o(s,"P",{"data-svelte-h":!0}),c(Ns)!=="svelte-140dfaq"&&(Ns.textContent=ma),ge=l(s),Es=o(s,"P",{"data-svelte-h":!0}),c(Es)!=="svelte-1koilcc"&&(Es.innerHTML=ja),Me=l(s),Ys=o(s,"P",{"data-svelte-h":!0}),c(Ys)!=="svelte-jmg8xs"&&(Ys.innerHTML=ga),de=l(s),r(Rs.$$.fragment,s),ye=l(s),Qs=o(s,"P",{"data-svelte-h":!0}),c(Qs)!=="svelte-1fornbv"&&(Qs.innerHTML=Ma),fe=l(s),r(C.$$.fragment,s),be=l(s),r(Vs.$$.fragment,s),Je=l(s),Ls=o(s,"P",{"data-svelte-h":!0}),c(Ls)!=="svelte-1hrxwrr"&&(Ls.textContent=da),Te=l(s),Ss=o(s,"P",{"data-svelte-h":!0}),c(Ss)!=="svelte-3nauxd"&&(Ss.innerHTML=ya),we=l(s),r(Xs.$$.fragment,s),Ue=l(s),As=o(s,"P",{"data-svelte-h":!0}),c(As)!=="svelte-oorag5"&&(As.innerHTML=fa),_e=l(s),zs=o(s,"P",{"data-svelte-h":!0}),c(zs)!=="svelte-d80cwp"&&(zs.innerHTML=ba),Ie=l(s),r(Fs.$$.fragment,s),$e=l(s),r(Ps.$$.fragment,s),Ce=l(s),Os=o(s,"P",{}),$a(Os).forEach(e),this.h()},h(){ke(p,"name","hf:doc:metadata"),ke(p,"content",Qa),ke(_,"start","2")},m(s,t){Wa(document.head,p),a(s,d,t),a(s,u,t),a(s,f,t),m(v,s,t),a(s,st,t),a(s,k,t),a(s,tt,t),a(s,q,t),a(s,et,t),a(s,G,t),a(s,at,t),m(T,s,t),a(s,nt,t),m(W,s,t),a(s,lt,t),a(s,Z,t),a(s,pt,t),a(s,B,t),a(s,it,t),m(x,s,t),a(s,ot,t),a(s,H,t),a(s,ct,t),m(N,s,t),a(s,ut,t),a(s,E,t),a(s,ht,t),a(s,Y,t),a(s,rt,t),m(R,s,t),a(s,mt,t),a(s,Q,t),a(s,jt,t),a(s,V,t),a(s,gt,t),a(s,L,t),a(s,Mt,t),m(S,s,t),a(s,dt,t),m(w,s,t),a(s,yt,t),a(s,X,t),a(s,ft,t),m(A,s,t),a(s,bt,t),a(s,z,t),a(s,Jt,t),m(F,s,t),a(s,Tt,t),m(P,s,t),a(s,wt,t),a(s,D,t),a(s,Ut,t),m(K,s,t),a(s,_t,t),m(O,s,t),a(s,It,t),a(s,ss,t),a(s,$t,t),a(s,ts,t),a(s,Ct,t),a(s,es,t),a(s,vt,t),m(as,s,t),a(s,kt,t),a(s,ns,t),a(s,qt,t),m(ls,s,t),a(s,Gt,t),a(s,ps,t),a(s,Wt,t),m(is,s,t),a(s,Zt,t),m(U,s,t),a(s,Bt,t),a(s,os,t),a(s,xt,t),a(s,cs,t),a(s,Ht,t),a(s,us,t),a(s,Nt,t),a(s,hs,t),a(s,Et,t),m(rs,s,t),a(s,Yt,t),a(s,ms,t),a(s,Rt,t),m(js,s,t),a(s,Qt,t),a(s,gs,t),a(s,Vt,t),a(s,Ms,t),a(s,Lt,t),m(ds,s,t),a(s,St,t),a(s,_,t),a(s,Xt,t),m(ys,s,t),a(s,At,t),a(s,fs,t),a(s,zt,t),a(s,bs,t),a(s,Ft,t),m(Js,s,t),a(s,Pt,t),a(s,Ts,t),a(s,Dt,t),m(ws,s,t),a(s,Kt,t),m(I,s,t),a(s,Ot,t),m(Us,s,t),a(s,se,t),a(s,_s,t),a(s,te,t),a(s,Is,t),a(s,ee,t),m($s,s,t),a(s,ae,t),a(s,Cs,t),a(s,ne,t),m(vs,s,t),a(s,le,t),a(s,ks,t),a(s,pe,t),m(qs,s,t),a(s,ie,t),m(Gs,s,t),a(s,oe,t),m(Ws,s,t),a(s,ce,t),m($,s,t),a(s,ue,t),a(s,Zs,t),a(s,he,t),m(Bs,s,t),a(s,re,t),a(s,xs,t),a(s,me,t),m(Hs,s,t),a(s,je,t),a(s,Ns,t),a(s,ge,t),a(s,Es,t),a(s,Me,t),a(s,Ys,t),a(s,de,t),m(Rs,s,t),a(s,ye,t),a(s,Qs,t),a(s,fe,t),m(C,s,t),a(s,be,t),m(Vs,s,t),a(s,Je,t),a(s,Ls,t),a(s,Te,t),a(s,Ss,t),a(s,we,t),m(Xs,s,t),a(s,Ue,t),a(s,As,t),a(s,_e,t),a(s,zs,t),a(s,Ie,t),m(Fs,s,t),a(s,$e,t),m(Ps,s,t),a(s,Ce,t),a(s,Os,t),ve=!0},p(s,[t]){const Ja={};t&2&&(Ja.$$scope={dirty:t,ctx:s}),T.$set(Ja);const Ta={};t&2&&(Ta.$$scope={dirty:t,ctx:s}),w.$set(Ta);const wa={};t&2&&(wa.$$scope={dirty:t,ctx:s}),U.$set(wa);const Ua={};t&2&&(Ua.$$scope={dirty:t,ctx:s}),I.$set(Ua);const _a={};t&2&&(_a.$$scope={dirty:t,ctx:s}),$.$set(_a);const Ia={};t&2&&(Ia.$$scope={dirty:t,ctx:s}),C.$set(Ia)},i(s){ve||(j(v.$$.fragment,s),j(T.$$.fragment,s),j(W.$$.fragment,s),j(x.$$.fragment,s),j(N.$$.fragment,s),j(R.$$.fragment,s),j(S.$$.fragment,s),j(w.$$.fragment,s),j(A.$$.fragment,s),j(F.$$.fragment,s),j(P.$$.fragment,s),j(K.$$.fragment,s),j(O.$$.fragment,s),j(as.$$.fragment,s),j(ls.$$.fragment,s),j(is.$$.fragment,s),j(U.$$.fragment,s),j(rs.$$.fragment,s),j(js.$$.fragment,s),j(ds.$$.fragment,s),j(ys.$$.fragment,s),j(Js.$$.fragment,s),j(ws.$$.fragment,s),j(I.$$.fragment,s),j(Us.$$.fragment,s),j($s.$$.fragment,s),j(vs.$$.fragment,s),j(qs.$$.fragment,s),j(Gs.$$.fragment,s),j(Ws.$$.fragment,s),j($.$$.fragment,s),j(Bs.$$.fragment,s),j(Hs.$$.fragment,s),j(Rs.$$.fragment,s),j(C.$$.fragment,s),j(Vs.$$.fragment,s),j(Xs.$$.fragment,s),j(Fs.$$.fragment,s),j(Ps.$$.fragment,s),ve=!0)},o(s){g(v.$$.fragment,s),g(T.$$.fragment,s),g(W.$$.fragment,s),g(x.$$.fragment,s),g(N.$$.fragment,s),g(R.$$.fragment,s),g(S.$$.fragment,s),g(w.$$.fragment,s),g(A.$$.fragment,s),g(F.$$.fragment,s),g(P.$$.fragment,s),g(K.$$.fragment,s),g(O.$$.fragment,s),g(as.$$.fragment,s),g(ls.$$.fragment,s),g(is.$$.fragment,s),g(U.$$.fragment,s),g(rs.$$.fragment,s),g(js.$$.fragment,s),g(ds.$$.fragment,s),g(ys.$$.fragment,s),g(Js.$$.fragment,s),g(ws.$$.fragment,s),g(I.$$.fragment,s),g(Us.$$.fragment,s),g($s.$$.fragment,s),g(vs.$$.fragment,s),g(qs.$$.fragment,s),g(Gs.$$.fragment,s),g(Ws.$$.fragment,s),g($.$$.fragment,s),g(Bs.$$.fragment,s),g(Hs.$$.fragment,s),g(Rs.$$.fragment,s),g(C.$$.fragment,s),g(Vs.$$.fragment,s),g(Xs.$$.fragment,s),g(Fs.$$.fragment,s),g(Ps.$$.fragment,s),ve=!1},d(s){s&&(e(d),e(u),e(f),e(st),e(k),e(tt),e(q),e(et),e(G),e(at),e(nt),e(lt),e(Z),e(pt),e(B),e(it),e(ot),e(H),e(ct),e(ut),e(E),e(ht),e(Y),e(rt),e(mt),e(Q),e(jt),e(V),e(gt),e(L),e(Mt),e(dt),e(yt),e(X),e(ft),e(bt),e(z),e(Jt),e(Tt),e(wt),e(D),e(Ut),e(_t),e(It),e(ss),e($t),e(ts),e(Ct),e(es),e(vt),e(kt),e(ns),e(qt),e(Gt),e(ps),e(Wt),e(Zt),e(Bt),e(os),e(xt),e(cs),e(Ht),e(us),e(Nt),e(hs),e(Et),e(Yt),e(ms),e(Rt),e(Qt),e(gs),e(Vt),e(Ms),e(Lt),e(St),e(_),e(Xt),e(At),e(fs),e(zt),e(bs),e(Ft),e(Pt),e(Ts),e(Dt),e(Kt),e(Ot),e(se),e(_s),e(te),e(Is),e(ee),e(ae),e(Cs),e(ne),e(le),e(ks),e(pe),e(ie),e(oe),e(ce),e(ue),e(Zs),e(he),e(re),e(xs),e(me),e(je),e(Ns),e(ge),e(Es),e(Me),e(Ys),e(de),e(ye),e(Qs),e(fe),e(be),e(Je),e(Ls),e(Te),e(Ss),e(we),e(Ue),e(As),e(_e),e(zs),e(Ie),e($e),e(Ce),e(Os)),e(p),M(v,s),M(T,s),M(W,s),M(x,s),M(N,s),M(R,s),M(S,s),M(w,s),M(A,s),M(F,s),M(P,s),M(K,s),M(O,s),M(as,s),M(ls,s),M(is,s),M(U,s),M(rs,s),M(js,s),M(ds,s),M(ys,s),M(Js,s),M(ws,s),M(I,s),M(Us,s),M($s,s),M(vs,s),M(qs,s),M(Gs,s),M(Ws,s),M($,s),M(Bs,s),M(Hs,s),M(Rs,s),M(C,s),M(Vs,s),M(Xs,s),M(Fs,s),M(Ps,s)}}}const Qa='{"title":"Run and manage Jobs","local":"run-and-manage-jobs","sections":[{"title":"Jobs Command Line Interface","local":"jobs-command-line-interface","sections":[],"depth":2},{"title":"Run a Job","local":"run-a-job","sections":[],"depth":2},{"title":"Check Job status","local":"check-job-status","sections":[],"depth":2},{"title":"Select the hardware","local":"select-the-hardware","sections":[],"depth":2},{"title":"Configure Job Timeout","local":"configure-job-timeout","sections":[{"title":"Setting a custom timeout","local":"setting-a-custom-timeout","sections":[],"depth":3},{"title":"Using timeout with UV jobs","local":"using-timeout-with-uv-jobs","sections":[],"depth":3},{"title":"Monitoring job duration","local":"monitoring-job-duration","sections":[],"depth":3}],"depth":2},{"title":"Pass Environment variables and Secrets","local":"pass-environment-variables-and-secrets","sections":[{"title":"UV Scripts (Experimental)","local":"uv-scripts-experimental","sections":[{"title":"Docker Images for UV Scripts","local":"docker-images-for-uv-scripts","sections":[],"depth":4}],"depth":3},{"title":"Scheduled Jobs","local":"scheduled-jobs","sections":[],"depth":3}],"depth":2}],"depth":1}';function Va(b){return va(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fa extends ka{constructor(p){super(),qa(this,p,Va,Ra,Ca,{})}}export{Fa as component};
