import{s as rf,o as cf,n as J}from"../chunks/scheduler.6062bdaf.js";import{S as pf,i as gf,g as b,s as r,r as g,m as je,A as uf,h as j,f as M,c,j as k,u,x as T,n as _e,k as q,y as l,a as I,v as m,d as h,t as d,w as f}from"../chunks/index.4bca734e.js";import{T as H}from"../chunks/Tip.b9ac1f03.js";import{D as A}from"../chunks/Docstring.887827b8.js";import{C as U}from"../chunks/CodeBlock.cbbddafc.js";import{E as w}from"../chunks/ExampleCodeBlock.433dd4d3.js";import{H as Bi,E as mf}from"../chunks/getInferenceSnippets.e6a3a5be.js";function hf(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmF1ZGlvX2NsYXNzaWZpY2F0aW9uKCUyMmF1ZGlvLmZsYWMlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.audio_classification(<span class="hljs-string">&quot;audio.flac&quot;</span>)
[
    AudioClassificationOutputElement(score=<span class="hljs-number">0.4976358711719513</span>, label=<span class="hljs-string">&#x27;hap&#x27;</span>),
    AudioClassificationOutputElement(score=<span class="hljs-number">0.3677836060523987</span>, label=<span class="hljs-string">&#x27;neu&#x27;</span>),
    ...
]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function df(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBYXVkaW9fb3V0cHV0JTIwJTNEJTIwY2xpZW50LmF1ZGlvX3RvX2F1ZGlvKCUyMmF1ZGlvLmZsYWMlMjIpJTBBZm9yJTIwaSUyQyUyMGl0ZW0lMjBpbiUyMGVudW1lcmF0ZShhdWRpb19vdXRwdXQpJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMG9wZW4oZiUyMm91dHB1dF8lN0JpJTdELmZsYWMlMjIlMkMlMjAlMjJ3YiUyMiklMjBhcyUyMGYlM0E=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_output = client.audio_to_audio(<span class="hljs-string">&quot;audio.flac&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, item <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(audio_output):
<span class="hljs-meta">&gt;&gt;&gt; </span>    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">f&quot;output_<span class="hljs-subst">{i}</span>.flac&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
            f.write(item.blob)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function ff(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmF1dG9tYXRpY19zcGVlY2hfcmVjb2duaXRpb24oJTIyaGVsbG9fd29ybGQuZmxhYyUyMikudGV4dA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.automatic_speech_recognition(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).text
<span class="hljs-string">&quot;hello world&quot;</span>`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function yf(_){let n,o=`The <code>client.chat_completion</code> method is aliased as <code>client.chat.completions.create</code> for compatibility with OpenAI’s client.
Inputs and outputs are strictly the same and using either syntax will yield the same results.
Check out the <a href="https://huggingface.co/docs/huggingface_hub/guides/inference#openai-compatibility" rel="nofollow">Inference guide</a>
for more details about OpenAI’s compatibility.`;return{c(){n=b("p"),n.innerHTML=o},l(t){n=j(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-9iksi9"&&(n.innerHTML=o)},m(t,s){I(t,n,s)},p:J,d(t){t&&M(n)}}}function Mf(_){let n;return{c(){n=je("You can pass provider-specific parameters to the model by using the `extra_body` argument.")},l(o){n=_e(o,"You can pass provider-specific parameters to the model by using the `extra_body` argument.")},m(o,t){I(o,n,t)},d(o){o&&M(n)}}}function bf(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyJTdEJTVEJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIpJTBBY2xpZW50LmNoYXRfY29tcGxldGlvbihtZXNzYWdlcyUyQyUyMG1heF90b2tlbnMlM0QxMDAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.chat_completion(messages, max_tokens=<span class="hljs-number">100</span>)
ChatCompletionOutput(
    choices=[
        ChatCompletionOutputComplete(
            finish_reason=<span class="hljs-string">&#x27;eos_token&#x27;</span>,
            index=<span class="hljs-number">0</span>,
            message=ChatCompletionOutputMessage(
                role=<span class="hljs-string">&#x27;assistant&#x27;</span>,
                content=<span class="hljs-string">&#x27;The capital of France is Paris.&#x27;</span>,
                name=<span class="hljs-literal">None</span>,
                tool_calls=<span class="hljs-literal">None</span>
            ),
            logprobs=<span class="hljs-literal">None</span>
        )
    ],
    created=<span class="hljs-number">1719907176</span>,
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&#x27;&#x27;</span>,
    model=<span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-8B-Instruct&#x27;</span>,
    <span class="hljs-built_in">object</span>=<span class="hljs-string">&#x27;text_completion&#x27;</span>,
    system_fingerprint=<span class="hljs-string">&#x27;2.0.4-sha-f426a33&#x27;</span>,
    usage=ChatCompletionOutputUsage(
        completion_tokens=<span class="hljs-number">8</span>,
        prompt_tokens=<span class="hljs-number">17</span>,
        total_tokens=<span class="hljs-number">25</span>
    )
)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function jf(_){let n,o="Example using streaming:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyJTdEJTVEJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIpJTBBZm9yJTIwdG9rZW4lMjBpbiUyMGNsaWVudC5jaGF0X2NvbXBsZXRpb24obWVzc2FnZXMlMkMlMjBtYXhfdG9rZW5zJTNEMTAlMkMlMjBzdHJlYW0lM0RUcnVlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KHRva2VuKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> client.chat_completion(messages, max_tokens=<span class="hljs-number">10</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27;The&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27; capital&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)
(...)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27; may&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1mc18uw"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function _f(_){let n,o="Example using OpenAI’s syntax:",t,s,i;return s=new U({props:{code:"JTIzJTIwaW5zdGVhZCUyMG9mJTIwJTYwZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSU2MCUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnQlMEElMEElMjMlMjBpbnN0ZWFkJTIwb2YlMjAlNjBjbGllbnQlMjAlM0QlMjBPcGVuQUkoLi4uKSU2MCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBiYXNlX3VybCUzRC4uLiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0QuLi4lMkMlMEEpJTBBJTBBb3V0cHV0JTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudC4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJDb3VudCUyMHRvJTIwMTAlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBzdHJlYW0lM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDEwMjQlMkMlMEEpJTBBJTBBZm9yJTIwY2h1bmslMjBpbiUyMG91dHB1dCUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGNodW5rLmNob2ljZXMlNUIwJTVELmRlbHRhLmNvbnRlbnQp",highlighted:`<span class="hljs-comment"># instead of \`from openai import OpenAI\`</span>
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

<span class="hljs-comment"># instead of \`client = OpenAI(...)\`</span>
client = InferenceClient(
    base_url=...,
    api_key=...,
)

output = client.chat.completions.create(
    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Count to 10&quot;</span>},
    ],
    stream=<span class="hljs-literal">True</span>,
    max_tokens=<span class="hljs-number">1024</span>,
)

<span class="hljs-keyword">for</span> chunk <span class="hljs-keyword">in</span> output:
    <span class="hljs-built_in">print</span>(chunk.choices[<span class="hljs-number">0</span>].delta.content)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-i0a0yp"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function If(_){let n,o;return n=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnRvZ2V0aGVyJTIyJTJDJTIwJTIwJTIzJTIwVXNlJTIwVG9nZXRoZXIlMjBBSSUyMHByb3ZpZGVyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMiUzQ3RvZ2V0aGVyX2FwaV9rZXklM0UlMjIlMkMlMjAlMjAlMjMlMjBQYXNzJTIweW91ciUyMFRvZ2V0aGVyJTIwQVBJJTIwa2V5JTIwZGlyZWN0bHklMEEpJTBBY2xpZW50LmNoYXRfY29tcGxldGlvbiglMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMHRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUzRiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMGV4dHJhX2JvZHklM0QlN0IlMjJzYWZldHlfbW9kZWwlMjIlM0ElMjAlMjJNZXRhLUxsYW1hJTJGTGxhbWEtR3VhcmQtN2IlMjIlN0QlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;together&quot;</span>,  <span class="hljs-comment"># Use Together AI provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;&lt;together_api_key&gt;&quot;</span>,  <span class="hljs-comment"># Pass your Together API key directly</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.chat_completion(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    messages=[{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}],
<span class="hljs-meta">... </span>    extra_body={<span class="hljs-string">&quot;safety_model&quot;</span>: <span class="hljs-string">&quot;Meta-Llama/Llama-Guard-7b&quot;</span>},
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function Tf(_){let n,o;return n=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnNhbWJhbm92YSUyMiUyQyUyMCUyMCUyMyUyMFVzZSUyMFNhbWJhbm92YSUyMHByb3ZpZGVyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMmhmXy4uLiUyMiUyQyUyMCUyMCUyMyUyMFBhc3MlMjB5b3VyJTIwSEYlMjB0b2tlbiUwQSklMEFjbGllbnQuY2hhdF9jb21wbGV0aW9uKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyJTdEJTVEJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;sambanova&quot;</span>,  <span class="hljs-comment"># Use Sambanova provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;hf_...&quot;</span>,  <span class="hljs-comment"># Pass your HF token</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.chat_completion(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    messages=[{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}],
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function Jf(_){let n,o="Example using Image + Text as input:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQWltYWdlX3VybCUyMCUzRCUyMmh0dHBzJTNBJTJGJTJGY2RuLmJyaXRhbm5pY2EuY29tJTJGNjElMkY5MzA2MS0wNTAtOTkxNDdEQ0UlMkZTdGF0dWUtb2YtTGliZXJ0eS1Jc2xhbmQtTmV3LVlvcmstQmF5LmpwZyUyMiUwQWltYWdlX3BhdGglMjAlM0QlMjAlMjIlMkZwYXRoJTJGdG8lMkZpbWFnZS5qcGVnJTIyJTBBd2l0aCUyMG9wZW4oaW1hZ2VfcGF0aCUyQyUyMCUyMnJiJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGJhc2U2NF9pbWFnZSUyMCUzRCUyMGJhc2U2NC5iNjRlbmNvZGUoZi5yZWFkKCkpLmRlY29kZSglMjJ1dGYtOCUyMiklMEFpbWFnZV91cmwlMjAlM0QlMjBmJTIyZGF0YSUzQWltYWdlJTJGanBlZyUzQmJhc2U2NCUyQyU3QmJhc2U2NF9pbWFnZSU3RCUyMiUwQSUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMy4yLTExQi1WaXNpb24tSW5zdHJ1Y3QlMjIpJTBBb3V0cHV0JTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmltYWdlX3VybCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmltYWdlX3VybCUyMiUzQSUyMCU3QiUyMnVybCUyMiUzQSUyMGltYWdlX3VybCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGV4dCUyMiUzQSUyMCUyMkRlc2NyaWJlJTIwdGhpcyUyMGltYWdlJTIwaW4lMjBvbmUlMjBzZW50ZW5jZS4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEEpJTBBb3V0cHV0",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

<span class="hljs-comment"># provide a remote URL</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_url =<span class="hljs-string">&quot;https://cdn.britannica.com/61/93061-050-99147DCE/Statue-of-Liberty-Island-New-York-Bay.jpg&quot;</span>
<span class="hljs-comment"># or a base64-encoded image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_path = <span class="hljs-string">&quot;/path/to/image.jpeg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(image_path, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    base64_image = base64.b64encode(f.read()).decode(<span class="hljs-string">&quot;utf-8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_url = <span class="hljs-string">f&quot;data:image/jpeg;base64,<span class="hljs-subst">{base64_image}</span>&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Llama-3.2-11B-Vision-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = client.chat.completions.create(
<span class="hljs-meta">... </span>    messages=[
<span class="hljs-meta">... </span>        {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;content&quot;</span>: [
<span class="hljs-meta">... </span>                {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;image_url&quot;</span>: {<span class="hljs-string">&quot;url&quot;</span>: image_url},
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Describe this image in one sentence.&quot;</span>,
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>            ],
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output
The image depicts the iconic Statue of Liberty situated <span class="hljs-keyword">in</span> New York Harbor, New York, on a clear day.`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1e6ij9p"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Uf(_){let n,o="Example using tools:",t,s,i;return s=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Don&#x27;t make assumptions about what values to plug into functions. Ask for clarification if a user request is ambiguous.&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weather like the next 3 days in San Francisco, CA?&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>tools = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;function&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_weather&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get the current weather&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;location&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;format&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;function&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_n_day_weather_forecast&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get an N-day weather forecast&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;location&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;format&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;num_days&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The number of days to forecast&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>, <span class="hljs-string">&quot;num_days&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.chat_completion(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    messages=messages,
<span class="hljs-meta">... </span>    tools=tools,
<span class="hljs-meta">... </span>    tool_choice=<span class="hljs-string">&quot;auto&quot;</span>,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.choices[<span class="hljs-number">0</span>].message.tool_calls[<span class="hljs-number">0</span>].function
ChatCompletionOutputFunctionDefinition(
    arguments={
        <span class="hljs-string">&#x27;location&#x27;</span>: <span class="hljs-string">&#x27;San Francisco, CA&#x27;</span>,
        <span class="hljs-string">&#x27;format&#x27;</span>: <span class="hljs-string">&#x27;fahrenheit&#x27;</span>,
        <span class="hljs-string">&#x27;num_days&#x27;</span>: <span class="hljs-number">3</span>
    },
    name=<span class="hljs-string">&#x27;get_n_day_weather_forecast&#x27;</span>,
    description=<span class="hljs-literal">None</span>
)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1ksikbz"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function wf(_){let n,o="Example using response_format:",t,s,i;return s=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park. What did I saw and when?&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>response_format = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;value&quot;</span>: {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;activity&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;animals_seen&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>, <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;maximum&quot;</span>: <span class="hljs-number">5</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;animals&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>, <span class="hljs-string">&quot;items&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}},
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;activity&quot;</span>, <span class="hljs-string">&quot;animals_seen&quot;</span>, <span class="hljs-string">&quot;animals&quot;</span>],
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.chat_completion(
<span class="hljs-meta">... </span>    messages=messages,
<span class="hljs-meta">... </span>    response_format=response_format,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.choices[<span class="hljs-number">0</span>].message.content
<span class="hljs-string">&#x27;{

y&quot;: &quot;bike ride&quot;,
&quot;: [&quot;puppy&quot;, &quot;cat&quot;, &quot;raccoon&quot;],
_seen&quot;: 3,
n&quot;: &quot;park&quot;}&#x27;</span>`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1klcxsv"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Cf(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmRvY3VtZW50X3F1ZXN0aW9uX2Fuc3dlcmluZyhpbWFnZSUzRCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzcGFjZXMlMkZpbXBpcmElMkZkb2NxdWVyeSUyRnJlc29sdmUlMkYyMzU5MjIzYzE4MzdhNzU4NzQwMmJkYTBmMjY0MzM4MmE2ZWVmZWFiJTJGaW52b2ljZS5wbmclMjIlMkMlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGludm9pY2UlMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.document_question_answering(image=<span class="hljs-string">&quot;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&quot;</span>, question=<span class="hljs-string">&quot;What is the invoice number?&quot;</span>)
[DocumentQuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;us-001&#x27;</span>, end=<span class="hljs-number">16</span>, score=<span class="hljs-number">0.9999666213989258</span>, start=<span class="hljs-number">16</span>)]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function xf(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmZlYXR1cmVfZXh0cmFjdGlvbiglMjJIaSUyQyUyMHdobyUyMGFyZSUyMHlvdSUzRiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.feature_extraction(<span class="hljs-string">&quot;Hi, who are you?&quot;</span>)
array([[ <span class="hljs-number">2.424802</span>  ,  <span class="hljs-number">2.93384</span>   ,  <span class="hljs-number">1.1750331</span> , ...,  <span class="hljs-number">1.240499</span>, -<span class="hljs-number">0.13776633</span>, -<span class="hljs-number">0.7889173</span> ],
[-<span class="hljs-number">0.42943227</span>, -<span class="hljs-number">0.6364878</span> , -<span class="hljs-number">1.693462</span>  , ...,  <span class="hljs-number">0.41978157</span>, -<span class="hljs-number">2.4336355</span> ,  <span class="hljs-number">0.6162071</span> ],
...,
[ <span class="hljs-number">0.28552425</span>, -<span class="hljs-number">0.928395</span>  , -<span class="hljs-number">1.2077185</span> , ...,  <span class="hljs-number">0.76810825</span>, -<span class="hljs-number">2.1069427</span> ,  <span class="hljs-number">0.6236161</span> ]], dtype=float32)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function $f(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmZpbGxfbWFzayglMjJUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjAlM0NtYXNrJTNFLiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.fill_mask(<span class="hljs-string">&quot;The goal of life is &lt;mask&gt;.&quot;</span>)
[
    FillMaskOutputElement(score=<span class="hljs-number">0.06897063553333282</span>, token=<span class="hljs-number">11098</span>, token_str=<span class="hljs-string">&#x27; happiness&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is happiness.&#x27;</span>),
    FillMaskOutputElement(score=<span class="hljs-number">0.06554922461509705</span>, token=<span class="hljs-number">45075</span>, token_str=<span class="hljs-string">&#x27; immortality&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is immortality.&#x27;</span>)
]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function vf(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLTcwQi1JbnN0cnVjdCUyMiklMEFjbGllbnQuZ2V0X2VuZHBvaW50X2luZm8oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.get_endpoint_info()
{
    <span class="hljs-string">&#x27;model_id&#x27;</span>: <span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-70B-Instruct&#x27;</span>,
    <span class="hljs-string">&#x27;model_sha&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;model_dtype&#x27;</span>: <span class="hljs-string">&#x27;torch.float16&#x27;</span>,
    <span class="hljs-string">&#x27;model_device_type&#x27;</span>: <span class="hljs-string">&#x27;cuda&#x27;</span>,
    <span class="hljs-string">&#x27;model_pipeline_tag&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;max_concurrent_requests&#x27;</span>: <span class="hljs-number">128</span>,
    <span class="hljs-string">&#x27;max_best_of&#x27;</span>: <span class="hljs-number">2</span>,
    <span class="hljs-string">&#x27;max_stop_sequences&#x27;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&#x27;max_input_length&#x27;</span>: <span class="hljs-number">8191</span>,
    <span class="hljs-string">&#x27;max_total_tokens&#x27;</span>: <span class="hljs-number">8192</span>,
    <span class="hljs-string">&#x27;waiting_served_ratio&#x27;</span>: <span class="hljs-number">0.3</span>,
    <span class="hljs-string">&#x27;max_batch_total_tokens&#x27;</span>: <span class="hljs-number">1259392</span>,
    <span class="hljs-string">&#x27;max_waiting_tokens&#x27;</span>: <span class="hljs-number">20</span>,
    <span class="hljs-string">&#x27;max_batch_size&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;validation_workers&#x27;</span>: <span class="hljs-number">32</span>,
    <span class="hljs-string">&#x27;max_client_batch_size&#x27;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&#x27;version&#x27;</span>: <span class="hljs-string">&#x27;2.0.2&#x27;</span>,
    <span class="hljs-string">&#x27;sha&#x27;</span>: <span class="hljs-string">&#x27;dccab72549635c7eb5ddb17f43f0b7cdff07c214&#x27;</span>,
    <span class="hljs-string">&#x27;docker_label&#x27;</span>: <span class="hljs-string">&#x27;sha-dccab72&#x27;</span>
}`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function kf(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMjJodHRwcyUzQSUyRiUyRmp6Z3UwYnVlaTUudXMtZWFzdC0xLmF3cy5lbmRwb2ludHMuaHVnZ2luZ2ZhY2UuY2xvdWQlMjIpJTBBY2xpZW50LmhlYWx0aF9jaGVjaygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;https://jzgu0buei5.us-east-1.aws.endpoints.huggingface.cloud&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.health_check()
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function qf(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX2NsYXNzaWZpY2F0aW9uKCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_classification(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
[ImageClassificationOutputElement(label=<span class="hljs-string">&#x27;Blenheim spaniel&#x27;</span>, score=<span class="hljs-number">0.9779096841812134</span>), ...]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Af(_){let n,o="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=b("p"),n.innerHTML=o},l(t){n=j(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-s2e3n9"&&(n.innerHTML=o)},m(t,s){I(t,n,s)},p:J,d(t){t&&M(n)}}}function Zf(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX3NlZ21lbnRhdGlvbiglMjJjYXQuanBnJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_segmentation(<span class="hljs-string">&quot;cat.jpg&quot;</span>)
[ImageSegmentationOutputElement(score=<span class="hljs-number">0.989008</span>, label=<span class="hljs-string">&#x27;LABEL_184&#x27;</span>, mask=&lt;PIL.PngImagePlugin.PngImageFile image mode=L size=400x300 at <span class="hljs-number">0x7FDD2B129CC0</span>&gt;), ...]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Ef(_){let n,o="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=b("p"),n.innerHTML=o},l(t){n=j(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-s2e3n9"&&(n.innerHTML=o)},m(t,s){I(t,n,s)},p:J,d(t){t&&M(n)}}}function Wf(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQuaW1hZ2VfdG9faW1hZ2UoJTIyY2F0LmpwZyUyMiUyQyUyMHByb21wdCUzRCUyMnR1cm4lMjB0aGUlMjBjYXQlMjBpbnRvJTIwYSUyMHRpZ2VyJTIyKSUwQWltYWdlLnNhdmUoJTIydGlnZXIuanBnJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.image_to_image(<span class="hljs-string">&quot;cat.jpg&quot;</span>, prompt=<span class="hljs-string">&quot;turn the cat into a tiger&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;tiger.jpg&quot;</span>)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Nf(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX3RvX3RleHQoJTIyY2F0LmpwZyUyMiklMEFjbGllbnQuaW1hZ2VfdG9fdGV4dCglMjJodHRwcyUzQSUyRiUyRnVwbG9hZC53aWtpbWVkaWEub3JnJTJGd2lraXBlZGlhJTJGY29tbW9ucyUyRnRodW1iJTJGNCUyRjQzJTJGQ3V0ZV9kb2cuanBnJTJGMzIwcHgtQ3V0ZV9kb2cuanBnJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_to_text(<span class="hljs-string">&quot;cat.jpg&quot;</span>)
<span class="hljs-string">&#x27;a cat standing in a grassy field &#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_to_text(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
<span class="hljs-string">&#x27;a dog laying on the grass next to a flower pot &#x27;</span>`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Gf(_){let n,o="Examples:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBdmlkZW8lMjAlM0QlMjBjbGllbnQuaW1hZ2VfdG9fdmlkZW8oJTIyY2F0LmpwZyUyMiUyQyUyMG1vZGVsJTNEJTIyV2FuLUFJJTJGV2FuMi4yLUkyVi1BMTRCJTIyJTJDJTIwcHJvbXB0JTNEJTIydHVybiUyMHRoZSUyMGNhdCUyMGludG8lMjBhJTIwdGlnZXIlMjIpJTBBd2l0aCUyMG9wZW4oJTIydGlnZXIubXA0JTIyJTJDJTIwJTIyd2IlMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwZi53cml0ZSh2aWRlbyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>video = client.image_to_video(<span class="hljs-string">&quot;cat.jpg&quot;</span>, model=<span class="hljs-string">&quot;Wan-AI/Wan2.2-I2V-A14B&quot;</span>, prompt=<span class="hljs-string">&quot;turn the cat into a tiger&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;tiger.mp4&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    f.write(video)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-kvfsh7"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Bf(_){let n,o="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=b("p"),n.innerHTML=o},l(t){n=j(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-s2e3n9"&&(n.innerHTML=o)},m(t,s){I(t,n,s)},p:J,d(t){t&&M(n)}}}function Vf(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50Lm9iamVjdF9kZXRlY3Rpb24oJTIycGVvcGxlLmpwZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.object_detection(<span class="hljs-string">&quot;people.jpg&quot;</span>)
[ObjectDetectionOutputElement(score=<span class="hljs-number">0.9486683011054993</span>, label=<span class="hljs-string">&#x27;person&#x27;</span>, box=ObjectDetectionBoundingBox(xmin=<span class="hljs-number">59</span>, ymin=<span class="hljs-number">39</span>, xmax=<span class="hljs-number">420</span>, ymax=<span class="hljs-number">510</span>)), ...]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Qf(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnF1ZXN0aW9uX2Fuc3dlcmluZyhxdWVzdGlvbiUzRCUyMldoYXQncyUyMG15JTIwbmFtZSUzRiUyMiUyQyUyMGNvbnRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMENsYXJhJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmtlbGV5LiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.question_answering(question=<span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>, context=<span class="hljs-string">&quot;My name is Clara and I live in Berkeley.&quot;</span>)
QuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;Clara&#x27;</span>, end=<span class="hljs-number">16</span>, score=<span class="hljs-number">0.9326565265655518</span>, start=<span class="hljs-number">11</span>)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Sf(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnNlbnRlbmNlX3NpbWlsYXJpdHkoJTBBJTIwJTIwJTIwJTIwJTIyTWFjaGluZSUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMGVhc3kuJTIyJTJDJTBBJTIwJTIwJTIwJTIwb3RoZXJfc2VudGVuY2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyRGVlcCUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMHN0cmFpZ2h0Zm9yd2FyZC4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJUaGlzJTIwaXMlMjBzbyUyMGRpZmZpY3VsdCUyQyUyMGxpa2UlMjByb2NrZXQlMjBzY2llbmNlLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBjYW4ndCUyMGJlbGlldmUlMjBob3clMjBtdWNoJTIwSSUyMHN0cnVnZ2xlZCUyMHdpdGglMjB0aGlzLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.sentence_similarity(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Machine learning is so easy.&quot;</span>,
<span class="hljs-meta">... </span>    other_sentences=[
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Deep learning is so straightforward.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;This is so difficult, like rocket science.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;I can&#x27;t believe how much I struggled with this.&quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>)
[<span class="hljs-number">0.7785726189613342</span>, <span class="hljs-number">0.45876261591911316</span>, <span class="hljs-number">0.2906220555305481</span>]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Yf(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnN1bW1hcml6YXRpb24oJTIyVGhlJTIwRWlmZmVsJTIwdG93ZXIuLi4lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.summarization(<span class="hljs-string">&quot;The Eiffel tower...&quot;</span>)
SummarizationOutput(generated_text=<span class="hljs-string">&quot;The Eiffel tower is one of the most famous landmarks in the world....&quot;</span>)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Rf(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBcXVlcnklMjAlM0QlMjAlMjJIb3clMjBtYW55JTIwc3RhcnMlMjBkb2VzJTIwdGhlJTIwdHJhbnNmb3JtZXJzJTIwcmVwb3NpdG9yeSUyMGhhdmUlM0YlMjIlMEF0YWJsZSUyMCUzRCUyMCU3QiUyMlJlcG9zaXRvcnklMjIlM0ElMjAlNUIlMjJUcmFuc2Zvcm1lcnMlMjIlMkMlMjAlMjJEYXRhc2V0cyUyMiUyQyUyMCUyMlRva2VuaXplcnMlMjIlNUQlMkMlMjAlMjJTdGFycyUyMiUzQSUyMCU1QiUyMjM2NTQyJTIyJTJDJTIwJTIyNDUxMiUyMiUyQyUyMCUyMjM5MzQlMjIlNUQlN0QlMEFjbGllbnQudGFibGVfcXVlc3Rpb25fYW5zd2VyaW5nKHRhYmxlJTJDJTIwcXVlcnklMkMlMjBtb2RlbCUzRCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>query = <span class="hljs-string">&quot;How many stars does the transformers repository have?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {<span class="hljs-string">&quot;Repository&quot;</span>: [<span class="hljs-string">&quot;Transformers&quot;</span>, <span class="hljs-string">&quot;Datasets&quot;</span>, <span class="hljs-string">&quot;Tokenizers&quot;</span>], <span class="hljs-string">&quot;Stars&quot;</span>: [<span class="hljs-string">&quot;36542&quot;</span>, <span class="hljs-string">&quot;4512&quot;</span>, <span class="hljs-string">&quot;3934&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>client.table_question_answering(table, query, model=<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
TableQuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;36542&#x27;</span>, coordinates=[[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>]], cells=[<span class="hljs-string">&#x27;36542&#x27;</span>], aggregator=<span class="hljs-string">&#x27;AVERAGE&#x27;</span>)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Xf(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBdGFibGUlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJmaXhlZF9hY2lkaXR5JTIyJTNBJTIwJTVCJTIyNy40JTIyJTJDJTIwJTIyNy44JTIyJTJDJTIwJTIyMTAuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnZvbGF0aWxlX2FjaWRpdHklMjIlM0ElMjAlNUIlMjIwLjclMjIlMkMlMjAlMjIwLjg4JTIyJTJDJTIwJTIyMC4zMiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNpdHJpY19hY2lkJTIyJTNBJTIwJTVCJTIyMCUyMiUyQyUyMCUyMjAlMjIlMkMlMjAlMjIwLjQ1JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVzaWR1YWxfc3VnYXIlMjIlM0ElMjAlNUIlMjIxLjklMjIlMkMlMjAlMjIyLjYlMjIlMkMlMjAlMjI2LjQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJjaGxvcmlkZXMlMjIlM0ElMjAlNUIlMjIwLjA3NiUyMiUyQyUyMCUyMjAuMDk4JTIyJTJDJTIwJTIyMC4wNzMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJmcmVlX3N1bGZ1cl9kaW94aWRlJTIyJTNBJTIwJTVCJTIyMTElMjIlMkMlMjAlMjIyNSUyMiUyQyUyMCUyMjUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJ0b3RhbF9zdWxmdXJfZGlveGlkZSUyMiUzQSUyMCU1QiUyMjM0JTIyJTJDJTIwJTIyNjclMjIlMkMlMjAlMjIxMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmRlbnNpdHklMjIlM0ElMjAlNUIlMjIwLjk5NzglMjIlMkMlMjAlMjIwLjk5NjglMjIlMkMlMjAlMjIwLjk5NzYlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJwSCUyMiUzQSUyMCU1QiUyMjMuNTElMjIlMkMlMjAlMjIzLjIlMjIlMkMlMjAlMjIzLjIzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyc3VscGhhdGVzJTIyJTNBJTIwJTVCJTIyMC41NiUyMiUyQyUyMCUyMjAuNjglMjIlMkMlMjAlMjIwLjgyJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyYWxjb2hvbCUyMiUzQSUyMCU1QiUyMjkuNCUyMiUyQyUyMCUyMjkuOCUyMiUyQyUyMCUyMjEyLjYlMjIlNUQlMkMlMEElN0QlMEFjbGllbnQudGFidWxhcl9jbGFzc2lmaWNhdGlvbih0YWJsZSUzRHRhYmxlJTJDJTIwbW9kZWwlM0QlMjJqdWxpZW4tYyUyRndpbmUtcXVhbGl0eSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;fixed_acidity&quot;</span>: [<span class="hljs-string">&quot;7.4&quot;</span>, <span class="hljs-string">&quot;7.8&quot;</span>, <span class="hljs-string">&quot;10.3&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;volatile_acidity&quot;</span>: [<span class="hljs-string">&quot;0.7&quot;</span>, <span class="hljs-string">&quot;0.88&quot;</span>, <span class="hljs-string">&quot;0.32&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;citric_acid&quot;</span>: [<span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0.45&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;residual_sugar&quot;</span>: [<span class="hljs-string">&quot;1.9&quot;</span>, <span class="hljs-string">&quot;2.6&quot;</span>, <span class="hljs-string">&quot;6.4&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;chlorides&quot;</span>: [<span class="hljs-string">&quot;0.076&quot;</span>, <span class="hljs-string">&quot;0.098&quot;</span>, <span class="hljs-string">&quot;0.073&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;free_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;11&quot;</span>, <span class="hljs-string">&quot;25&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;total_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;34&quot;</span>, <span class="hljs-string">&quot;67&quot;</span>, <span class="hljs-string">&quot;13&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;density&quot;</span>: [<span class="hljs-string">&quot;0.9978&quot;</span>, <span class="hljs-string">&quot;0.9968&quot;</span>, <span class="hljs-string">&quot;0.9976&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;pH&quot;</span>: [<span class="hljs-string">&quot;3.51&quot;</span>, <span class="hljs-string">&quot;3.2&quot;</span>, <span class="hljs-string">&quot;3.23&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;sulphates&quot;</span>: [<span class="hljs-string">&quot;0.56&quot;</span>, <span class="hljs-string">&quot;0.68&quot;</span>, <span class="hljs-string">&quot;0.82&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;alcohol&quot;</span>: [<span class="hljs-string">&quot;9.4&quot;</span>, <span class="hljs-string">&quot;9.8&quot;</span>, <span class="hljs-string">&quot;12.6&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>client.tabular_classification(table=table, model=<span class="hljs-string">&quot;julien-c/wine-quality&quot;</span>)
[<span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function zf(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBdGFibGUlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJIZWlnaHQlMjIlM0ElMjAlNUIlMjIxMS41MiUyMiUyQyUyMCUyMjEyLjQ4JTIyJTJDJTIwJTIyMTIuMzc3OCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMkxlbmd0aDElMjIlM0ElMjAlNUIlMjIyMy4yJTIyJTJDJTIwJTIyMjQlMjIlMkMlMjAlMjIyMy45JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyTGVuZ3RoMiUyMiUzQSUyMCU1QiUyMjI1LjQlMjIlMkMlMjAlMjIyNi4zJTIyJTJDJTIwJTIyMjYuNSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMkxlbmd0aDMlMjIlM0ElMjAlNUIlMjIzMCUyMiUyQyUyMCUyMjMxLjIlMjIlMkMlMjAlMjIzMS4xJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyU3BlY2llcyUyMiUzQSUyMCU1QiUyMkJyZWFtJTIyJTJDJTIwJTIyQnJlYW0lMjIlMkMlMjAlMjJCcmVhbSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMldpZHRoJTIyJTNBJTIwJTVCJTIyNC4wMiUyMiUyQyUyMCUyMjQuMzA1NiUyMiUyQyUyMCUyMjQuNjk2MSUyMiU1RCUyQyUwQSU3RCUwQWNsaWVudC50YWJ1bGFyX3JlZ3Jlc3Npb24odGFibGUlMkMlMjBtb2RlbCUzRCUyMnNjaWtpdC1sZWFybiUyRkZpc2gtV2VpZ2h0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Height&quot;</span>: [<span class="hljs-string">&quot;11.52&quot;</span>, <span class="hljs-string">&quot;12.48&quot;</span>, <span class="hljs-string">&quot;12.3778&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length1&quot;</span>: [<span class="hljs-string">&quot;23.2&quot;</span>, <span class="hljs-string">&quot;24&quot;</span>, <span class="hljs-string">&quot;23.9&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length2&quot;</span>: [<span class="hljs-string">&quot;25.4&quot;</span>, <span class="hljs-string">&quot;26.3&quot;</span>, <span class="hljs-string">&quot;26.5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length3&quot;</span>: [<span class="hljs-string">&quot;30&quot;</span>, <span class="hljs-string">&quot;31.2&quot;</span>, <span class="hljs-string">&quot;31.1&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Species&quot;</span>: [<span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Width&quot;</span>: [<span class="hljs-string">&quot;4.02&quot;</span>, <span class="hljs-string">&quot;4.3056&quot;</span>, <span class="hljs-string">&quot;4.6961&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>client.tabular_regression(table, model=<span class="hljs-string">&quot;scikit-learn/Fish-Weight&quot;</span>)
[<span class="hljs-number">110</span>, <span class="hljs-number">120</span>, <span class="hljs-number">130</span>]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Ff(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnRleHRfY2xhc3NpZmljYXRpb24oJTIySSUyMGxpa2UlMjB5b3UlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_classification(<span class="hljs-string">&quot;I like you&quot;</span>)
[
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;POSITIVE&#x27;</span>, score=<span class="hljs-number">0.9998695850372314</span>),
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;NEGATIVE&#x27;</span>, score=<span class="hljs-number">0.0001304351753788069</span>),
]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Hf(_){let n,o=`If you want to generate a response from chat messages, you should use the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">InferenceClient.chat_completion()</a> method.
It accepts a list of messages instead of a single text prompt and handles the chat templating for you.`;return{c(){n=b("p"),n.innerHTML=o},l(t){n=j(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-gq0ddh"&&(n.innerHTML=o)},m(t,s){I(t,n,s)},p:J,d(t){t&&M(n)}}}function Of(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMjJUaGUlMjBodWdnaW5nZmFjZV9odWIlMjBsaWJyYXJ5JTIwaXMlMjAlMjIlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEyKSUwQSUwQWZvciUyMHRva2VuJTIwaW4lMjBjbGllbnQudGV4dF9nZW5lcmF0aW9uKCUyMlRoZSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGxpYnJhcnklMjBpcyUyMCUyMiUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTIlMkMlMjBzdHJlYW0lM0RUcnVlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KHRva2VuKSUwQSUwQWNsaWVudC50ZXh0X2dlbmVyYXRpb24oJTIyVGhlJTIwaHVnZ2luZ2ZhY2VfaHViJTIwbGlicmFyeSUyMGlzJTIwJTIyJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMiUyQyUyMGRldGFpbHMlM0RUcnVlKSUwQSUwQWZvciUyMGRldGFpbHMlMjBpbiUyMGNsaWVudC50ZXh0X2dlbmVyYXRpb24oJTIyVGhlJTIwaHVnZ2luZ2ZhY2VfaHViJTIwbGlicmFyeSUyMGlzJTIwJTIyJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMiUyQyUyMGRldGFpbHMlM0RUcnVlJTJDJTIwc3RyZWFtJTNEVHJ1ZSklM0ElMEElMjAlMjAlMjAlMjBwcmludChkZXRhaWxzKSUwQSUwQXJlc3BvbnNlJTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJJJTIwc2F3JTIwYSUyMHB1cHB5JTIwYSUyMGNhdCUyMGFuZCUyMGElMjByYWNjb29uJTIwZHVyaW5nJTIwbXklMjBiaWtlJTIwcmlkZSUyMGluJTIwdGhlJTIwcGFyayUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci1vcnBvLTE0MWItQTM1Yi12MC4xJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QxMDAlMkMlMEElMjAlMjAlMjAlMjByZXBldGl0aW9uX3BlbmFsdHklM0QxLjMlMkMlMEElMjAlMjAlMjAlMjBncmFtbWFyJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmpzb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ2YWx1ZSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnByb3BlcnRpZXMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsb2NhdGlvbiUyMiUzQSUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJzdHJpbmclMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhY3Rpdml0eSUyMiUzQSUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJzdHJpbmclMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhbmltYWxzX3NlZW4lMjIlM0ElMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyaW50ZWdlciUyMiUyQyUyMCUyMm1pbmltdW0lMjIlM0ElMjAxJTJDJTIwJTIybWF4aW11bSUyMiUzQSUyMDUlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhbmltYWxzJTIyJTNBJTIwJTdCJTIydHlwZSUyMiUzQSUyMCUyMmFycmF5JTIyJTJDJTIwJTIyaXRlbXMlMjIlM0ElMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyc3RyaW5nJTIyJTdEJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycmVxdWlyZWQlMjIlM0ElMjAlNUIlMjJsb2NhdGlvbiUyMiUyQyUyMCUyMmFjdGl2aXR5JTIyJTJDJTIwJTIyYW5pbWFsc19zZWVuJTIyJTJDJTIwJTIyYW5pbWFscyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSklMEFqc29uLmxvYWRzKHJlc3BvbnNlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-comment"># Case 1: generate text</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>)
<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>

<span class="hljs-comment"># Case 2: iterate over the generated tokens. Useful for large generation.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
<span class="hljs-number">100</span>
%
<span class="hljs-built_in">open</span>
source
<span class="hljs-keyword">and</span>
built
to
be
easy
to
use
.

<span class="hljs-comment"># Case 3: get more details about the generation process.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>)
TextGenerationOutput(
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationDetails(
        finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>,
        generated_tokens=<span class="hljs-number">12</span>,
        seed=<span class="hljs-literal">None</span>,
        prefill=[
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">487</span>, text=<span class="hljs-string">&#x27;The&#x27;</span>, logprob=<span class="hljs-literal">None</span>),
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">53789</span>, text=<span class="hljs-string">&#x27; hugging&#x27;</span>, logprob=-<span class="hljs-number">13.171875</span>),
            (...)
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">204</span>, text=<span class="hljs-string">&#x27; &#x27;</span>, logprob=-<span class="hljs-number">7.0390625</span>)
        ],
        tokens=[
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>),
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>),
            (...)
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>, text=<span class="hljs-string">&#x27;.&#x27;</span>, logprob=-<span class="hljs-number">0.5703125</span>, special=<span class="hljs-literal">False</span>)
        ],
        best_of_sequences=<span class="hljs-literal">None</span>
    )
)

<span class="hljs-comment"># Case 4: iterate over the generated tokens with more details.</span>
<span class="hljs-comment"># Last object is more complete, containing the full generated text and the finish reason.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> details <span class="hljs-keyword">in</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(details)
...
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1314</span>, text=<span class="hljs-string">&#x27; open&#x27;</span>, logprob=-<span class="hljs-number">1.3359375</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3178</span>, text=<span class="hljs-string">&#x27; source&#x27;</span>, logprob=-<span class="hljs-number">0.28100586</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">273</span>, text=<span class="hljs-string">&#x27; and&#x27;</span>, logprob=-<span class="hljs-number">0.5961914</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3426</span>, text=<span class="hljs-string">&#x27; built&#x27;</span>, logprob=-<span class="hljs-number">1.9423828</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">1.4121094</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">314</span>, text=<span class="hljs-string">&#x27; be&#x27;</span>, logprob=-<span class="hljs-number">1.5224609</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1833</span>, text=<span class="hljs-string">&#x27; easy&#x27;</span>, logprob=-<span class="hljs-number">2.1132812</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">0.08520508</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">745</span>, text=<span class="hljs-string">&#x27; use&#x27;</span>, logprob=-<span class="hljs-number">0.39453125</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(
    <span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>,
    text=<span class="hljs-string">&#x27;.&#x27;</span>,
    logprob=-<span class="hljs-number">0.5703125</span>,
    special=<span class="hljs-literal">False</span>),
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationStreamOutputStreamDetails(finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>, generated_tokens=<span class="hljs-number">12</span>, seed=<span class="hljs-literal">None</span>)
)

<span class="hljs-comment"># Case 5: generate constrained output using grammar</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.text_generation(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;HuggingFaceH4/zephyr-orpo-141b-A35b-v0.1&quot;</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    repetition_penalty=<span class="hljs-number">1.3</span>,
<span class="hljs-meta">... </span>    grammar={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;value&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;activity&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;animals_seen&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>, <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;maximum&quot;</span>: <span class="hljs-number">5</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;animals&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>, <span class="hljs-string">&quot;items&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}},
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;activity&quot;</span>, <span class="hljs-string">&quot;animals_seen&quot;</span>, <span class="hljs-string">&quot;animals&quot;</span>],
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>json.loads(response)
{
    <span class="hljs-string">&quot;activity&quot;</span>: <span class="hljs-string">&quot;bike riding&quot;</span>,
    <span class="hljs-string">&quot;animals&quot;</span>: [<span class="hljs-string">&quot;puppy&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;raccoon&quot;</span>],
    <span class="hljs-string">&quot;animals_seen&quot;</span>: <span class="hljs-number">3</span>,
    <span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;park&quot;</span>
}`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Df(_){let n,o="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=b("p"),n.innerHTML=o},l(t){n=j(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-s2e3n9"&&(n.innerHTML=o)},m(t,s){I(t,n,s)},p:J,d(t){t&&M(n)}}}function Lf(_){let n;return{c(){n=je("You can pass provider-specific parameters to the model by using the `extra_body` argument.")},l(o){n=_e(o,"You can pass provider-specific parameters to the model by using the `extra_body` argument.")},m(o,t){I(o,n,t)},d(o){o&&M(n)}}}function Pf(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwY2xpZW50LnRleHRfdG9faW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyQW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMHRoZSUyMG1vb24uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIybG93JTIwcmVzb2x1dGlvbiUyQyUyMGJsdXJyeSUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUwQSklMEFpbWFnZS5zYXZlKCUyMmJldHRlcl9hc3Ryb25hdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>,
<span class="hljs-meta">... </span>    negative_prompt=<span class="hljs-string">&quot;low resolution, blurry&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;better_astronaut.png&quot;</span>)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Kf(_){let n,o;return n=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMmZhbC1haSUyMiUyQyUyMCUyMCUyMyUyMFVzZSUyMGZhbC5haSUyMHByb3ZpZGVyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMmZhbC1haS1hcGkta2V5JTIyJTJDJTIwJTIwJTIzJTIwUGFzcyUyMHlvdXIlMjBmYWwuYWklMjBBUEklMjBrZXklMEEpJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQudGV4dF90b19pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJBJTIwbWFqZXN0aWMlMjBsaW9uJTIwaW4lMjBhJTIwZmFudGFzeSUyMGZvcmVzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtc2NobmVsbCUyMiUyQyUwQSklMEFpbWFnZS5zYXZlKCUyMmxpb24ucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;fal-ai&quot;</span>,  <span class="hljs-comment"># Use fal.ai provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;fal-ai-api-key&quot;</span>,  <span class="hljs-comment"># Pass your fal.ai API key</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A majestic lion in a fantasy forest&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;lion.png&quot;</span>)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function ey(_){let n,o;return n=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUyMCUyMCUyMyUyMFVzZSUyMHJlcGxpY2F0ZSUyMHByb3ZpZGVyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMmhmXy4uLiUyMiUyQyUyMCUyMCUyMyUyMFBhc3MlMjB5b3VyJTIwSEYlMjB0b2tlbiUwQSklMEFpbWFnZSUyMCUzRCUyMGNsaWVudC50ZXh0X3RvX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMkFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjB0aGUlMjBtb29uLiUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBKSUwQWltYWdlLnNhdmUoJTIyYXN0cm9uYXV0LnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;replicate&quot;</span>,  <span class="hljs-comment"># Use replicate provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;hf_...&quot;</span>,  <span class="hljs-comment"># Pass your HF token</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function ny(_){let n,o;return n=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUyMCUyMCUyMyUyMFVzZSUyMHJlcGxpY2F0ZSUyMHByb3ZpZGVyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMmhmXy4uLiUyMiUyQyUyMCUyMCUyMyUyMFBhc3MlMjB5b3VyJTIwSEYlMjB0b2tlbiUwQSklMEFpbWFnZSUyMCUzRCUyMGNsaWVudC50ZXh0X3RvX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMkFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjB0aGUlMjBtb29uLiUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtc2NobmVsbCUyMiUyQyUwQSUyMCUyMCUyMCUyMGV4dHJhX2JvZHklM0QlN0IlMjJvdXRwdXRfcXVhbGl0eSUyMiUzQSUyMDEwMCU3RCUyQyUwQSklMEFpbWFnZS5zYXZlKCUyMmFzdHJvbmF1dC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;replicate&quot;</span>,  <span class="hljs-comment"># Use replicate provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;hf_...&quot;</span>,  <span class="hljs-comment"># Pass your HF token</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
<span class="hljs-meta">... </span>    extra_body={<span class="hljs-string">&quot;output_quality&quot;</span>: <span class="hljs-number">100</span>},
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function ty(_){let n;return{c(){n=je("You can pass provider-specific parameters to the model by using the `extra_body` argument.")},l(o){n=_e(o,"You can pass provider-specific parameters to the model by using the `extra_body` argument.")},m(o,t){I(o,n,t)},d(o){o&&M(n)}}}function sy(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBYXVkaW8lMjAlM0QlMjBjbGllbnQudGV4dF90b19zcGVlY2goJTIySGVsbG8lMjB3b3JsZCUyMiklMEFQYXRoKCUyMmhlbGxvX3dvcmxkLmZsYWMlMjIpLndyaXRlX2J5dGVzKGF1ZGlvKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>audio = client.text_to_speech(<span class="hljs-string">&quot;Hello world&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function ay(_){let n,o;return n=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0QlMjJ5b3VyLXJlcGxpY2F0ZS1hcGkta2V5JTIyJTJDJTIwJTIwJTIzJTIwUGFzcyUyMHlvdXIlMjBSZXBsaWNhdGUlMjBBUEklMjBrZXklMjBkaXJlY3RseSUwQSklMEFhdWRpbyUyMCUzRCUyMGNsaWVudC50ZXh0X3RvX3NwZWVjaCglMEElMjAlMjAlMjAlMjB0ZXh0JTNEJTIySGVsbG8lMjB3b3JsZCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyT3V0ZUFJJTJGT3V0ZVRUUy0wLjMtNTAwTSUyMiUyQyUwQSklMEFQYXRoKCUyMmhlbGxvX3dvcmxkLmZsYWMlMjIpLndyaXRlX2J5dGVzKGF1ZGlvKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;replicate&quot;</span>,
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;your-replicate-api-key&quot;</span>,  <span class="hljs-comment"># Pass your Replicate API key directly</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = client.text_to_speech(
<span class="hljs-meta">... </span>    text=<span class="hljs-string">&quot;Hello world&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;OuteAI/OuteTTS-0.3-500M&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function ly(_){let n,o;return n=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0QlMjJoZl8uLi4lMjIlMkMlMjAlMjAlMjMlMjBQYXNzJTIweW91ciUyMEhGJTIwdG9rZW4lMEEpJTBBYXVkaW8lMjAlM0RjbGllbnQudGV4dF90b19zcGVlY2goJTBBJTIwJTIwJTIwJTIwdGV4dCUzRCUyMkhlbGxvJTIwd29ybGQlMjIlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMk91dGVBSSUyRk91dGVUVFMtMC4zLTUwME0lMjIlMkMlMEEpJTBBUGF0aCglMjJoZWxsb193b3JsZC5mbGFjJTIyKS53cml0ZV9ieXRlcyhhdWRpbyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;replicate&quot;</span>,
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;hf_...&quot;</span>,  <span class="hljs-comment"># Pass your HF token</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio =client.text_to_speech(
<span class="hljs-meta">... </span>    text=<span class="hljs-string">&quot;Hello world&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;OuteAI/OuteTTS-0.3-500M&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function oy(_){let n,o;return n=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUyMCUyMCUyMyUyMFVzZSUyMHJlcGxpY2F0ZSUyMHByb3ZpZGVyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMmhmXy4uLiUyMiUyQyUyMCUyMCUyMyUyMFBhc3MlMjB5b3VyJTIwSEYlMjB0b2tlbiUwQSklMEFhdWRpbyUyMCUzRCUyMGNsaWVudC50ZXh0X3RvX3NwZWVjaCglMEElMjAlMjAlMjAlMjAlMjJIZWxsbyUyQyUyMG15JTIwbmFtZSUyMGlzJTIwS29yb3JvJTJDJTIwYW4lMjBhd2Vzb21lJTIwdGV4dC10by1zcGVlY2glMjBtb2RlbC4lMjIlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMmhleGdyYWQlMkZLb2tvcm8tODJNJTIyJTJDJTBBJTIwJTIwJTIwJTIwZXh0cmFfYm9keSUzRCU3QiUyMnZvaWNlJTIyJTNBJTIwJTIyYWZfbmljb2xlJTIyJTdEJTJDJTBBKSUwQVBhdGgoJTIyaGVsbG8uZmxhYyUyMikud3JpdGVfYnl0ZXMoYXVkaW8p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;replicate&quot;</span>,  <span class="hljs-comment"># Use replicate provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;hf_...&quot;</span>,  <span class="hljs-comment"># Pass your HF token</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = client.text_to_speech(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Hello, my name is Kororo, an awesome text-to-speech model.&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;hexgrad/Kokoro-82M&quot;</span>,
<span class="hljs-meta">... </span>    extra_body={<span class="hljs-string">&quot;voice&quot;</span>: <span class="hljs-string">&quot;af_nicole&quot;</span>},
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function iy(_){let n,o;return n=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWx5cmljcyUyMCUzRCUyMCcnJyUwQSU1QnZlcnNlJTVEJTBBSW4lMjB0aGUlMjB0b3duJTIwd2hlcmUlMjBJJTIwd2FzJTIwYm9ybiUwQUxpdmVkJTIwYSUyMG1hbiUyMHdobyUyMHNhaWxlZCUyMHRvJTIwc2VhJTBBQW5kJTIwaGUlMjB0b2xkJTIwdXMlMjBvZiUyMGhpcyUyMGxpZmUlMEFJbiUyMHRoZSUyMGxhbmQlMjBvZiUyMHN1Ym1hcmluZXMlMEFTbyUyMHdlJTIwc2FpbGVkJTIwb24lMjB0byUyMHRoZSUyMHN1biUwQSdUaWwlMjB3ZSUyMGZvdW5kJTIwYSUyMHNlYSUyMG9mJTIwZ3JlZW4lMEFBbmQlMjB3ZSUyMGxpdmVkJTIwYmVuZWF0aCUyMHRoZSUyMHdhdmVzJTBBSW4lMjBvdXIlMjB5ZWxsb3clMjBzdWJtYXJpbmUlMEElMEElNUJjaG9ydXMlNUQlMEFXZSUyMGFsbCUyMGxpdmUlMjBpbiUyMGElMjB5ZWxsb3clMjBzdWJtYXJpbmUlMEFZZWxsb3clMjBzdWJtYXJpbmUlMkMlMjB5ZWxsb3clMjBzdWJtYXJpbmUlMEFXZSUyMGFsbCUyMGxpdmUlMjBpbiUyMGElMjB5ZWxsb3clMjBzdWJtYXJpbmUlMEFZZWxsb3clMjBzdWJtYXJpbmUlMkMlMjB5ZWxsb3clMjBzdWJtYXJpbmUlMEEnJyclMEFnZW5yZXMlMjAlM0QlMjAlMjJwYXZhcm90dGktc3R5bGUlMjB0ZW5vciUyMHZvaWNlJTIyJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUwQSUyMCUyMCUyMCUyMHByb3ZpZGVyJTNEJTIyZmFsLWFpJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJtLWEtcCUyRll1RS1zMS03Qi1hbm5lYWwtZW4tY290JTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRC4uLiUyQyUwQSklMEFhdWRpbyUyMCUzRCUyMGNsaWVudC50ZXh0X3RvX3NwZWVjaChseXJpY3MlMkMlMjBleHRyYV9ib2R5JTNEJTdCJTIyZ2VucmVzJTIyJTNBJTIwZ2VucmVzJTdEKSUwQXdpdGglMjBvcGVuKCUyMm91dHB1dC5tcDMlMjIlMkMlMjAlMjJ3YiUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjBmLndyaXRlKGF1ZGlvKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>lyrics = <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>[verse]
<span class="hljs-meta">... </span>In the town where I was born
<span class="hljs-meta">... </span>Lived a man who sailed to sea
<span class="hljs-meta">... </span>And he told us of his life
<span class="hljs-meta">... </span>In the land of submarines
<span class="hljs-meta">... </span>So we sailed on to the sun
<span class="hljs-meta">... </span>&#x27;Til we found a sea of green
<span class="hljs-meta">... </span>And we lived beneath the waves
<span class="hljs-meta">... </span>In our yellow submarine

<span class="hljs-meta">... </span>[chorus]
<span class="hljs-meta">... </span>We all live in a yellow submarine
<span class="hljs-meta">... </span>Yellow submarine, yellow submarine
<span class="hljs-meta">... </span>We all live in a yellow submarine
<span class="hljs-meta">... </span>Yellow submarine, yellow submarine
<span class="hljs-meta">... </span>&#x27;&#x27;&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>genres = <span class="hljs-string">&quot;pavarotti-style tenor voice&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;fal-ai&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;m-a-p/YuE-s1-7B-anneal-en-cot&quot;</span>,
<span class="hljs-meta">... </span>    api_key=...,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = client.text_to_speech(lyrics, extra_body={<span class="hljs-string">&quot;genres&quot;</span>: genres})
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;output.mp3&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    f.write(audio)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function ry(_){let n;return{c(){n=je("You can pass provider-specific parameters to the model by using the `extra_body` argument.")},l(o){n=_e(o,"You can pass provider-specific parameters to the model by using the `extra_body` argument.")},m(o,t){I(o,n,t)},d(o){o&&M(n)}}}function cy(_){let n,o;return n=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMmZhbC1haSUyMiUyQyUyMCUyMCUyMyUyMFVzaW5nJTIwZmFsLmFpJTIwcHJvdmlkZXIlMEElMjAlMjAlMjAlMjBhcGlfa2V5JTNEJTIyZmFsLWFpLWFwaS1rZXklMjIlMkMlMjAlMjAlMjMlMjBQYXNzJTIweW91ciUyMGZhbC5haSUyMEFQSSUyMGtleSUwQSklMEF2aWRlbyUyMCUzRCUyMGNsaWVudC50ZXh0X3RvX3ZpZGVvKCUwQSUyMCUyMCUyMCUyMCUyMkElMjBtYWplc3RpYyUyMGxpb24lMjBydW5uaW5nJTIwaW4lMjBhJTIwZmFudGFzeSUyMGZvcmVzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIydGVuY2VudCUyRkh1bnl1YW5WaWRlbyUyMiUyQyUwQSklMEF3aXRoJTIwb3BlbiglMjJsaW9uLm1wNCUyMiUyQyUyMCUyMndiJTIyKSUyMGFzJTIwZmlsZSUzQSUwQSUyMCUyMCUyMCUyMGZpbGUud3JpdGUodmlkZW8p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;fal-ai&quot;</span>,  <span class="hljs-comment"># Using fal.ai provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;fal-ai-api-key&quot;</span>,  <span class="hljs-comment"># Pass your fal.ai API key</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = client.text_to_video(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A majestic lion running in a fantasy forest&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;tencent/HunyuanVideo&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;lion.mp4&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> file:
<span class="hljs-meta">... </span>    file.write(video)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function py(_){let n,o;return n=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUyMCUyMCUyMyUyMFVzaW5nJTIwcmVwbGljYXRlJTIwcHJvdmlkZXIlMEElMjAlMjAlMjAlMjBhcGlfa2V5JTNEJTIyaGZfLi4uJTIyJTJDJTIwJTIwJTIzJTIwUGFzcyUyMHlvdXIlMjBIRiUyMHRva2VuJTBBKSUwQXZpZGVvJTIwJTNEJTIwY2xpZW50LnRleHRfdG9fdmlkZW8oJTBBJTIwJTIwJTIwJTIwJTIyQSUyMGNhdCUyMHJ1bm5pbmclMjBpbiUyMGElMjBwYXJrJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJnZW5tbyUyRm1vY2hpLTEtcHJldmlldyUyMiUyQyUwQSklMEF3aXRoJTIwb3BlbiglMjJjYXQubXA0JTIyJTJDJTIwJTIyd2IlMjIpJTIwYXMlMjBmaWxlJTNBJTBBJTIwJTIwJTIwJTIwZmlsZS53cml0ZSh2aWRlbyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;replicate&quot;</span>,  <span class="hljs-comment"># Using replicate provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;hf_...&quot;</span>,  <span class="hljs-comment"># Pass your HF token</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = client.text_to_video(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A cat running in a park&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;genmo/mochi-1-preview&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;cat.mp4&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> file:
<span class="hljs-meta">... </span>    file.write(video)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function gy(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnRva2VuX2NsYXNzaWZpY2F0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.token_classification(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>)
[
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9971321225166321</span>,
        word=<span class="hljs-string">&#x27;Sarah Jessica Parker&#x27;</span>,
        start=<span class="hljs-number">11</span>,
        end=<span class="hljs-number">31</span>,
    ),
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9773476123809814</span>,
        word=<span class="hljs-string">&#x27;Jessica&#x27;</span>,
        start=<span class="hljs-number">52</span>,
        end=<span class="hljs-number">59</span>,
    )
]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function uy(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwV29sZmdhbmclMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwQmVybGluJTIyKSUwQWNsaWVudC50cmFuc2xhdGlvbiglMjJNeSUyMG5hbWUlMjBpcyUyMFdvbGZnYW5nJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmxpbiUyMiUyQyUyMG1vZGVsJTNEJTIySGVsc2lua2ktTkxQJTJGb3B1cy1tdC1lbi1mciUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>)
<span class="hljs-string">&#x27;Mein Name ist Wolfgang und ich lebe in Berlin.&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>, model=<span class="hljs-string">&quot;Helsinki-NLP/opus-mt-en-fr&quot;</span>)
TranslationOutput(translation_text=<span class="hljs-string">&#x27;Je m&#x27;</span>appelle Wolfgang et je vis à Berlin.<span class="hljs-string">&#x27;)</span>`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function my(_){let n,o="Specifying languages:",t,s,i;return s=new U({props:{code:"Y2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMiUyQyUyMG1vZGVsJTNEJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJlbl9YWCUyMiUyQyUyMHRndF9sYW5nJTNEJTIyZnJfWFglMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>, model=<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;en_XX&quot;</span>, tgt_lang=<span class="hljs-string">&quot;fr_XX&quot;</span>)
<span class="hljs-string">&quot;Mon nom est Sarah Jessica Parker mais vous pouvez m&#x27;appeler Jessica&quot;</span>`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-mhcj6c"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function hy(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnZpc3VhbF9xdWVzdGlvbl9hbnN3ZXJpbmcoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZtaXNoaWclMkZzYW1wbGVfaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGclMjIlMkMlMEElMjAlMjAlMjAlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGFuaW1hbCUyMGRvaW5nJTNGJTIyJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.visual_question_answering(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;https://huggingface.co/datasets/mishig/sample_images/resolve/main/tiger.jpg&quot;</span>,
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the animal doing?&quot;</span>
<span class="hljs-meta">... </span>)
[
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.778609573841095</span>, answer=<span class="hljs-string">&#x27;laying down&#x27;</span>),
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.6957435607910156</span>, answer=<span class="hljs-string">&#x27;sitting&#x27;</span>),
]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function dy(_){let n,o="Example with <code>multi_label=False</code>:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBdGV4dCUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjJBJTIwbmV3JTIwbW9kZWwlMjBvZmZlcnMlMjBhbiUyMGV4cGxhbmF0aW9uJTIwZm9yJTIwaG93JTIwdGhlJTIwR2FsaWxlYW4lMjBzYXRlbGxpdGVzJTIwZm9ybWVkJTIwYXJvdW5kJTIwdGhlJTIwc29sYXIlMjBzeXN0ZW0ncyUyMiUwQSUyMCUyMCUyMCUyMCUyMmxhcmdlc3QlMjB3b3JsZC4lMjBLb25zdGFudGluJTIwQmF0eWdpbiUyMGRpZCUyMG5vdCUyMHNldCUyMG91dCUyMHRvJTIwc29sdmUlMjBvbmUlMjBvZiUyMHRoZSUyMHNvbGFyJTIwc3lzdGVtJ3MlMjBtb3N0JTIwcHV6emxpbmclMjIlMEElMjAlMjAlMjAlMjAlMjIlMjBteXN0ZXJpZXMlMjB3aGVuJTIwaGUlMjB3ZW50JTIwZm9yJTIwYSUyMHJ1biUyMHVwJTIwYSUyMGhpbGwlMjBpbiUyME5pY2UlMkMlMjBGcmFuY2UuJTIyJTBBKSUwQWxhYmVscyUyMCUzRCUyMCU1QiUyMnNwYWNlJTIwJTI2JTIwY29zbW9zJTIyJTJDJTIwJTIyc2NpZW50aWZpYyUyMGRpc2NvdmVyeSUyMiUyQyUyMCUyMm1pY3JvYmlvbG9neSUyMiUyQyUyMCUyMnJvYm90cyUyMiUyQyUyMCUyMmFyY2hlb2xvZ3klMjIlNUQlMEFjbGllbnQuemVyb19zaG90X2NsYXNzaWZpY2F0aW9uKHRleHQlMkMlMjBsYWJlbHMpJTBBY2xpZW50Lnplcm9fc2hvdF9jbGFzc2lmaWNhdGlvbih0ZXh0JTJDJTIwbGFiZWxzJTJDJTIwbXVsdGlfbGFiZWwlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A new model offers an explanation for how the Galilean satellites formed around the solar system&#x27;s&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;largest world. Konstantin Batygin did not set out to solve one of the solar system&#x27;s most puzzling&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot; mysteries when he went for a run up a hill in Nice, France.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [<span class="hljs-string">&quot;space &amp; cosmos&quot;</span>, <span class="hljs-string">&quot;scientific discovery&quot;</span>, <span class="hljs-string">&quot;microbiology&quot;</span>, <span class="hljs-string">&quot;robots&quot;</span>, <span class="hljs-string">&quot;archeology&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_classification(text, labels)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.7961668968200684</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.18570658564567566</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.00730885099619627</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.006258360575884581</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.004559356719255447</span>),
]
<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_classification(text, labels, multi_label=<span class="hljs-literal">True</span>)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.9829297661781311</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.755190908908844</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.0005462635890580714</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.00047131875180639327</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.00030448526376858354</span>),
]`,wrap:!1}}),{c(){n=b("p"),n.innerHTML=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-90ztrp"&&(n.innerHTML=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function fy(_){let n,o="Example with <code>multi_label=True</code> and a custom <code>hypothesis_template</code>:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50Lnplcm9fc2hvdF9jbGFzc2lmaWNhdGlvbiglMEElMjAlMjAlMjB0ZXh0JTNEJTIySSUyMHJlYWxseSUyMGxpa2UlMjBvdXIlMjBkaW5uZXIlMjBhbmQlMjBJJ20lMjB2ZXJ5JTIwaGFwcHkuJTIwSSUyMGRvbid0JTIwbGlrZSUyMHRoZSUyMHdlYXRoZXIlMjB0aG91Z2guJTIyJTJDJTBBJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIycG9zaXRpdmUlMjIlMkMlMjAlMjJuZWdhdGl2ZSUyMiUyQyUyMCUyMnBlc3NpbWlzdGljJTIyJTJDJTIwJTIyb3B0aW1pc3RpYyUyMiU1RCUyQyUwQSUyMCUyMCUyMG11bHRpX2xhYmVsJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMGh5cG90aGVzaXNfdGVtcGxhdGUlM0QlMjJUaGlzJTIwdGV4dCUyMGlzJTIwJTdCJTdEJTIwdG93YXJkcyUyMHRoZSUyMHdlYXRoZXIlMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_classification(
<span class="hljs-meta">... </span>   text=<span class="hljs-string">&quot;I really like our dinner and I&#x27;m very happy. I don&#x27;t like the weather though.&quot;</span>,
<span class="hljs-meta">... </span>   labels=[<span class="hljs-string">&quot;positive&quot;</span>, <span class="hljs-string">&quot;negative&quot;</span>, <span class="hljs-string">&quot;pessimistic&quot;</span>, <span class="hljs-string">&quot;optimistic&quot;</span>],
<span class="hljs-meta">... </span>   multi_label=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>   hypothesis_template=<span class="hljs-string">&quot;This text is {} towards the weather&quot;</span>
<span class="hljs-meta">... </span>)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;negative&#x27;</span>, score=<span class="hljs-number">0.9231801629066467</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;pessimistic&#x27;</span>, score=<span class="hljs-number">0.8760990500450134</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;optimistic&#x27;</span>, score=<span class="hljs-number">0.0008674879791215062</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;positive&#x27;</span>, score=<span class="hljs-number">0.0005250611575320363</span>)
]`,wrap:!1}}),{c(){n=b("p"),n.innerHTML=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1qklg9x"&&(n.innerHTML=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function yy(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBY2xpZW50Lnplcm9fc2hvdF9pbWFnZV9jbGFzc2lmaWNhdGlvbiglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRnVwbG9hZC53aWtpbWVkaWEub3JnJTJGd2lraXBlZGlhJTJGY29tbW9ucyUyRnRodW1iJTJGNCUyRjQzJTJGQ3V0ZV9kb2cuanBnJTJGMzIwcHgtQ3V0ZV9kb2cuanBnJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIyZG9nJTIyJTJDJTIwJTIyY2F0JTIyJTJDJTIwJTIyaG9yc2UlMjIlNUQlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_image_classification(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>,
<span class="hljs-meta">... </span>    labels=[<span class="hljs-string">&quot;dog&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;horse&quot;</span>],
<span class="hljs-meta">... </span>)
[ZeroShotImageClassificationOutputElement(label=<span class="hljs-string">&#x27;dog&#x27;</span>, score=<span class="hljs-number">0.956</span>),...]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function My(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmF1ZGlvX2NsYXNzaWZpY2F0aW9uKCUyMmF1ZGlvLmZsYWMlMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.audio_classification(<span class="hljs-string">&quot;audio.flac&quot;</span>)
[
    AudioClassificationOutputElement(score=<span class="hljs-number">0.4976358711719513</span>, label=<span class="hljs-string">&#x27;hap&#x27;</span>),
    AudioClassificationOutputElement(score=<span class="hljs-number">0.3677836060523987</span>, label=<span class="hljs-string">&#x27;neu&#x27;</span>),
    ...
]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function by(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF1ZGlvX291dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xpZW50LmF1ZGlvX3RvX2F1ZGlvKCUyMmF1ZGlvLmZsYWMlMjIpJTBBYXN5bmMlMjBmb3IlMjBpJTJDJTIwaXRlbSUyMGluJTIwZW51bWVyYXRlKGF1ZGlvX291dHB1dCklM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwb3BlbihmJTIyb3V0cHV0XyU3QmklN0QuZmxhYyUyMiUyQyUyMCUyMndiJTIyKSUyMGFzJTIwZiUzQQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_output = <span class="hljs-keyword">await</span> client.audio_to_audio(<span class="hljs-string">&quot;audio.flac&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> i, item <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(audio_output):
<span class="hljs-meta">&gt;&gt;&gt; </span>    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">f&quot;output_<span class="hljs-subst">{i}</span>.flac&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
            f.write(item.blob)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function jy(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmF1dG9tYXRpY19zcGVlY2hfcmVjb2duaXRpb24oJTIyaGVsbG9fd29ybGQuZmxhYyUyMikudGV4dA==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.automatic_speech_recognition(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).text
<span class="hljs-string">&quot;hello world&quot;</span>`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function _y(_){let n,o=`The <code>client.chat_completion</code> method is aliased as <code>client.chat.completions.create</code> for compatibility with OpenAI’s client.
Inputs and outputs are strictly the same and using either syntax will yield the same results.
Check out the <a href="https://huggingface.co/docs/huggingface_hub/guides/inference#openai-compatibility" rel="nofollow">Inference guide</a>
for more details about OpenAI’s compatibility.`;return{c(){n=b("p"),n.innerHTML=o},l(t){n=j(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-9iksi9"&&(n.innerHTML=o)},m(t,s){I(t,n,s)},p:J,d(t){t&&M(n)}}}function Iy(_){let n;return{c(){n=je("You can pass provider-specific parameters to the model by using the `extra_body` argument.")},l(o){n=_e(o,"You can pass provider-specific parameters to the model by using the `extra_body` argument.")},m(o,t){I(o,n,t)},d(o){o&&M(n)}}}function Ty(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMjIlN0QlNUQlMEFjbGllbnQlMjAlM0QlMjBBc3luY0luZmVyZW5jZUNsaWVudCglMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLThCLUluc3RydWN0JTIyKSUwQWF3YWl0JTIwY2xpZW50LmNoYXRfY29tcGxldGlvbihtZXNzYWdlcyUyQyUyMG1heF90b2tlbnMlM0QxMDAp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.chat_completion(messages, max_tokens=<span class="hljs-number">100</span>)
ChatCompletionOutput(
    choices=[
        ChatCompletionOutputComplete(
            finish_reason=<span class="hljs-string">&#x27;eos_token&#x27;</span>,
            index=<span class="hljs-number">0</span>,
            message=ChatCompletionOutputMessage(
                role=<span class="hljs-string">&#x27;assistant&#x27;</span>,
                content=<span class="hljs-string">&#x27;The capital of France is Paris.&#x27;</span>,
                name=<span class="hljs-literal">None</span>,
                tool_calls=<span class="hljs-literal">None</span>
            ),
            logprobs=<span class="hljs-literal">None</span>
        )
    ],
    created=<span class="hljs-number">1719907176</span>,
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&#x27;&#x27;</span>,
    model=<span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-8B-Instruct&#x27;</span>,
    <span class="hljs-built_in">object</span>=<span class="hljs-string">&#x27;text_completion&#x27;</span>,
    system_fingerprint=<span class="hljs-string">&#x27;2.0.4-sha-f426a33&#x27;</span>,
    usage=ChatCompletionOutputUsage(
        completion_tokens=<span class="hljs-number">8</span>,
        prompt_tokens=<span class="hljs-number">17</span>,
        total_tokens=<span class="hljs-number">25</span>
    )
)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Jy(_){let n,o="Example using streaming:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMjIlN0QlNUQlMEFjbGllbnQlMjAlM0QlMjBBc3luY0luZmVyZW5jZUNsaWVudCglMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLThCLUluc3RydWN0JTIyKSUwQWFzeW5jJTIwZm9yJTIwdG9rZW4lMjBpbiUyMGF3YWl0JTIwY2xpZW50LmNoYXRfY29tcGxldGlvbihtZXNzYWdlcyUyQyUyMG1heF90b2tlbnMlM0QxMCUyQyUyMHN0cmVhbSUzRFRydWUpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQodG9rZW4p",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.chat_completion(messages, max_tokens=<span class="hljs-number">10</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27;The&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27; capital&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)
(...)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27; may&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1mc18uw"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Uy(_){let n,o="Example using OpenAI’s syntax:",t,s,i;return s=new U({props:{code:"JTIzJTIwTXVzdCUyMGJlJTIwcnVuJTIwaW4lMjBhbiUyMGFzeW5jJTIwY29udGV4dCUwQSUyMyUyMGluc3RlYWQlMjBvZiUyMCU2MGZyb20lMjBvcGVuYWklMjBpbXBvcnQlMjBPcGVuQUklNjAlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwQXN5bmNJbmZlcmVuY2VDbGllbnQlMEElMEElMjMlMjBpbnN0ZWFkJTIwb2YlMjAlNjBjbGllbnQlMjAlM0QlMjBPcGVuQUkoLi4uKSU2MCUwQWNsaWVudCUyMCUzRCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50KCUwQSUyMCUyMCUyMCUyMGJhc2VfdXJsJTNELi4uJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRC4uLiUyQyUwQSklMEElMEFvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsaWVudC5jaGF0LmNvbXBsZXRpb25zLmNyZWF0ZSglMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQ291bnQlMjB0byUyMDEwJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwc3RyZWFtJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QxMDI0JTJDJTBBKSUwQSUwQWZvciUyMGNodW5rJTIwaW4lMjBvdXRwdXQlM0ElMEElMjAlMjAlMjAlMjBwcmludChjaHVuay5jaG9pY2VzJTVCMCU1RC5kZWx0YS5jb250ZW50KQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-comment"># instead of \`from openai import OpenAI\`</span>
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient

<span class="hljs-comment"># instead of \`client = OpenAI(...)\`</span>
client = AsyncInferenceClient(
    base_url=...,
    api_key=...,
)

output = <span class="hljs-keyword">await</span> client.chat.completions.create(
    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Count to 10&quot;</span>},
    ],
    stream=<span class="hljs-literal">True</span>,
    max_tokens=<span class="hljs-number">1024</span>,
)

<span class="hljs-keyword">for</span> chunk <span class="hljs-keyword">in</span> output:
    <span class="hljs-built_in">print</span>(chunk.choices[<span class="hljs-number">0</span>].delta.content)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-i0a0yp"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function wy(_){let n,o;return n=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnRvZ2V0aGVyJTIyJTJDJTIwJTIwJTIzJTIwVXNlJTIwVG9nZXRoZXIlMjBBSSUyMHByb3ZpZGVyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMiUzQ3RvZ2V0aGVyX2FwaV9rZXklM0UlMjIlMkMlMjAlMjAlMjMlMjBQYXNzJTIweW91ciUyMFRvZ2V0aGVyJTIwQVBJJTIwa2V5JTIwZGlyZWN0bHklMEEpJTBBY2xpZW50LmNoYXRfY29tcGxldGlvbiglMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMHRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUzRiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMGV4dHJhX2JvZHklM0QlN0IlMjJzYWZldHlfbW9kZWwlMjIlM0ElMjAlMjJNZXRhLUxsYW1hJTJGTGxhbWEtR3VhcmQtN2IlMjIlN0QlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;together&quot;</span>,  <span class="hljs-comment"># Use Together AI provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;&lt;together_api_key&gt;&quot;</span>,  <span class="hljs-comment"># Pass your Together API key directly</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.chat_completion(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    messages=[{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}],
<span class="hljs-meta">... </span>    extra_body={<span class="hljs-string">&quot;safety_model&quot;</span>: <span class="hljs-string">&quot;Meta-Llama/Llama-Guard-7b&quot;</span>},
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function Cy(_){let n,o;return n=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnNhbWJhbm92YSUyMiUyQyUyMCUyMCUyMyUyMFVzZSUyMFNhbWJhbm92YSUyMHByb3ZpZGVyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMmhmXy4uLiUyMiUyQyUyMCUyMCUyMyUyMFBhc3MlMjB5b3VyJTIwSEYlMjB0b2tlbiUwQSklMEFjbGllbnQuY2hhdF9jb21wbGV0aW9uKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyJTdEJTVEJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;sambanova&quot;</span>,  <span class="hljs-comment"># Use Sambanova provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;hf_...&quot;</span>,  <span class="hljs-comment"># Pass your HF token</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.chat_completion(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    messages=[{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}],
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function xy(_){let n,o="Example using Image + Text as input:",t,s,i;return s=new U({props:{code:"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",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient

<span class="hljs-comment"># provide a remote URL</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_url =<span class="hljs-string">&quot;https://cdn.britannica.com/61/93061-050-99147DCE/Statue-of-Liberty-Island-New-York-Bay.jpg&quot;</span>
<span class="hljs-comment"># or a base64-encoded image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_path = <span class="hljs-string">&quot;/path/to/image.jpeg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(image_path, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    base64_image = base64.b64encode(f.read()).decode(<span class="hljs-string">&quot;utf-8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_url = <span class="hljs-string">f&quot;data:image/jpeg;base64,<span class="hljs-subst">{base64_image}</span>&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Llama-3.2-11B-Vision-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = <span class="hljs-keyword">await</span> client.chat.completions.create(
<span class="hljs-meta">... </span>    messages=[
<span class="hljs-meta">... </span>        {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;content&quot;</span>: [
<span class="hljs-meta">... </span>                {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;image_url&quot;</span>: {<span class="hljs-string">&quot;url&quot;</span>: image_url},
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Describe this image in one sentence.&quot;</span>,
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>            ],
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output
The image depicts the iconic Statue of Liberty situated <span class="hljs-keyword">in</span> New York Harbor, New York, on a clear day.`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1e6ij9p"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function $y(_){let n,o="Example using tools:",t,s,i;return s=new U({props:{code:"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",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Don&#x27;t make assumptions about what values to plug into functions. Ask for clarification if a user request is ambiguous.&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weather like the next 3 days in San Francisco, CA?&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>tools = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;function&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_weather&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get the current weather&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;location&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;format&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;function&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_n_day_weather_forecast&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get an N-day weather forecast&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;location&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;format&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;num_days&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The number of days to forecast&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>, <span class="hljs-string">&quot;num_days&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>response = <span class="hljs-keyword">await</span> client.chat_completion(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    messages=messages,
<span class="hljs-meta">... </span>    tools=tools,
<span class="hljs-meta">... </span>    tool_choice=<span class="hljs-string">&quot;auto&quot;</span>,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.choices[<span class="hljs-number">0</span>].message.tool_calls[<span class="hljs-number">0</span>].function
ChatCompletionOutputFunctionDefinition(
    arguments={
        <span class="hljs-string">&#x27;location&#x27;</span>: <span class="hljs-string">&#x27;San Francisco, CA&#x27;</span>,
        <span class="hljs-string">&#x27;format&#x27;</span>: <span class="hljs-string">&#x27;fahrenheit&#x27;</span>,
        <span class="hljs-string">&#x27;num_days&#x27;</span>: <span class="hljs-number">3</span>
    },
    name=<span class="hljs-string">&#x27;get_n_day_weather_forecast&#x27;</span>,
    description=<span class="hljs-literal">None</span>
)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1ksikbz"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function vy(_){let n,o="Example using response_format:",t,s,i;return s=new U({props:{code:"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",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park. What did I saw and when?&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>response_format = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;value&quot;</span>: {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;activity&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;animals_seen&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>, <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;maximum&quot;</span>: <span class="hljs-number">5</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;animals&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>, <span class="hljs-string">&quot;items&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}},
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;activity&quot;</span>, <span class="hljs-string">&quot;animals_seen&quot;</span>, <span class="hljs-string">&quot;animals&quot;</span>],
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>response = <span class="hljs-keyword">await</span> client.chat_completion(
<span class="hljs-meta">... </span>    messages=messages,
<span class="hljs-meta">... </span>    response_format=response_format,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.choices[<span class="hljs-number">0</span>].message.content
<span class="hljs-string">&#x27;{

y&quot;: &quot;bike ride&quot;,
&quot;: [&quot;puppy&quot;, &quot;cat&quot;, &quot;raccoon&quot;],
_seen&quot;: 3,
n&quot;: &quot;park&quot;}&#x27;</span>`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1klcxsv"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function ky(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmRvY3VtZW50X3F1ZXN0aW9uX2Fuc3dlcmluZyhpbWFnZSUzRCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzcGFjZXMlMkZpbXBpcmElMkZkb2NxdWVyeSUyRnJlc29sdmUlMkYyMzU5MjIzYzE4MzdhNzU4NzQwMmJkYTBmMjY0MzM4MmE2ZWVmZWFiJTJGaW52b2ljZS5wbmclMjIlMkMlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGludm9pY2UlMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.document_question_answering(image=<span class="hljs-string">&quot;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&quot;</span>, question=<span class="hljs-string">&quot;What is the invoice number?&quot;</span>)
[DocumentQuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;us-001&#x27;</span>, end=<span class="hljs-number">16</span>, score=<span class="hljs-number">0.9999666213989258</span>, start=<span class="hljs-number">16</span>)]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function qy(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmZlYXR1cmVfZXh0cmFjdGlvbiglMjJIaSUyQyUyMHdobyUyMGFyZSUyMHlvdSUzRiUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.feature_extraction(<span class="hljs-string">&quot;Hi, who are you?&quot;</span>)
array([[ <span class="hljs-number">2.424802</span>  ,  <span class="hljs-number">2.93384</span>   ,  <span class="hljs-number">1.1750331</span> , ...,  <span class="hljs-number">1.240499</span>, -<span class="hljs-number">0.13776633</span>, -<span class="hljs-number">0.7889173</span> ],
[-<span class="hljs-number">0.42943227</span>, -<span class="hljs-number">0.6364878</span> , -<span class="hljs-number">1.693462</span>  , ...,  <span class="hljs-number">0.41978157</span>, -<span class="hljs-number">2.4336355</span> ,  <span class="hljs-number">0.6162071</span> ],
...,
[ <span class="hljs-number">0.28552425</span>, -<span class="hljs-number">0.928395</span>  , -<span class="hljs-number">1.2077185</span> , ...,  <span class="hljs-number">0.76810825</span>, -<span class="hljs-number">2.1069427</span> ,  <span class="hljs-number">0.6236161</span> ]], dtype=float32)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Ay(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmZpbGxfbWFzayglMjJUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjAlM0NtYXNrJTNFLiUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.fill_mask(<span class="hljs-string">&quot;The goal of life is &lt;mask&gt;.&quot;</span>)
[
    FillMaskOutputElement(score=<span class="hljs-number">0.06897063553333282</span>, token=<span class="hljs-number">11098</span>, token_str=<span class="hljs-string">&#x27; happiness&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is happiness.&#x27;</span>),
    FillMaskOutputElement(score=<span class="hljs-number">0.06554922461509705</span>, token=<span class="hljs-number">45075</span>, token_str=<span class="hljs-string">&#x27; immortality&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is immortality.&#x27;</span>)
]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Zy(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy03MEItSW5zdHJ1Y3QlMjIpJTBBYXdhaXQlMjBjbGllbnQuZ2V0X2VuZHBvaW50X2luZm8oKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.get_endpoint_info()
{
    <span class="hljs-string">&#x27;model_id&#x27;</span>: <span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-70B-Instruct&#x27;</span>,
    <span class="hljs-string">&#x27;model_sha&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;model_dtype&#x27;</span>: <span class="hljs-string">&#x27;torch.float16&#x27;</span>,
    <span class="hljs-string">&#x27;model_device_type&#x27;</span>: <span class="hljs-string">&#x27;cuda&#x27;</span>,
    <span class="hljs-string">&#x27;model_pipeline_tag&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;max_concurrent_requests&#x27;</span>: <span class="hljs-number">128</span>,
    <span class="hljs-string">&#x27;max_best_of&#x27;</span>: <span class="hljs-number">2</span>,
    <span class="hljs-string">&#x27;max_stop_sequences&#x27;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&#x27;max_input_length&#x27;</span>: <span class="hljs-number">8191</span>,
    <span class="hljs-string">&#x27;max_total_tokens&#x27;</span>: <span class="hljs-number">8192</span>,
    <span class="hljs-string">&#x27;waiting_served_ratio&#x27;</span>: <span class="hljs-number">0.3</span>,
    <span class="hljs-string">&#x27;max_batch_total_tokens&#x27;</span>: <span class="hljs-number">1259392</span>,
    <span class="hljs-string">&#x27;max_waiting_tokens&#x27;</span>: <span class="hljs-number">20</span>,
    <span class="hljs-string">&#x27;max_batch_size&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;validation_workers&#x27;</span>: <span class="hljs-number">32</span>,
    <span class="hljs-string">&#x27;max_client_batch_size&#x27;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&#x27;version&#x27;</span>: <span class="hljs-string">&#x27;2.0.2&#x27;</span>,
    <span class="hljs-string">&#x27;sha&#x27;</span>: <span class="hljs-string">&#x27;dccab72549635c7eb5ddb17f43f0b7cdff07c214&#x27;</span>,
    <span class="hljs-string">&#x27;docker_label&#x27;</span>: <span class="hljs-string">&#x27;sha-dccab72&#x27;</span>
}`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Ey(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoJTIyaHR0cHMlM0ElMkYlMkZqemd1MGJ1ZWk1LnVzLWVhc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTIyKSUwQWF3YWl0JTIwY2xpZW50LmhlYWx0aF9jaGVjaygp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;https://jzgu0buei5.us-east-1.aws.endpoints.huggingface.cloud&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.health_check()
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Wy(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmltYWdlX2NsYXNzaWZpY2F0aW9uKCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_classification(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
[ImageClassificationOutputElement(label=<span class="hljs-string">&#x27;Blenheim spaniel&#x27;</span>, score=<span class="hljs-number">0.9779096841812134</span>), ...]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Ny(_){let n,o="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=b("p"),n.innerHTML=o},l(t){n=j(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-s2e3n9"&&(n.innerHTML=o)},m(t,s){I(t,n,s)},p:J,d(t){t&&M(n)}}}function Gy(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmltYWdlX3NlZ21lbnRhdGlvbiglMjJjYXQuanBnJTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_segmentation(<span class="hljs-string">&quot;cat.jpg&quot;</span>)
[ImageSegmentationOutputElement(score=<span class="hljs-number">0.989008</span>, label=<span class="hljs-string">&#x27;LABEL_184&#x27;</span>, mask=&lt;PIL.PngImagePlugin.PngImageFile image mode=L size=400x300 at <span class="hljs-number">0x7FDD2B129CC0</span>&gt;), ...]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function By(_){let n,o="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=b("p"),n.innerHTML=o},l(t){n=j(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-s2e3n9"&&(n.innerHTML=o)},m(t,s){I(t,n,s)},p:J,d(t){t&&M(n)}}}function Vy(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQuaW1hZ2VfdG9faW1hZ2UoJTIyY2F0LmpwZyUyMiUyQyUyMHByb21wdCUzRCUyMnR1cm4lMjB0aGUlMjBjYXQlMjBpbnRvJTIwYSUyMHRpZ2VyJTIyKSUwQWltYWdlLnNhdmUoJTIydGlnZXIuanBnJTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.image_to_image(<span class="hljs-string">&quot;cat.jpg&quot;</span>, prompt=<span class="hljs-string">&quot;turn the cat into a tiger&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;tiger.jpg&quot;</span>)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Qy(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmltYWdlX3RvX3RleHQoJTIyY2F0LmpwZyUyMiklMEFhd2FpdCUyMGNsaWVudC5pbWFnZV90b190ZXh0KCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_to_text(<span class="hljs-string">&quot;cat.jpg&quot;</span>)
<span class="hljs-string">&#x27;a cat standing in a grassy field &#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_to_text(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
<span class="hljs-string">&#x27;a dog laying on the grass next to a flower pot &#x27;</span>`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Sy(_){let n,o="Examples:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXZpZGVvJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQuaW1hZ2VfdG9fdmlkZW8oJTIyY2F0LmpwZyUyMiUyQyUyMG1vZGVsJTNEJTIyV2FuLUFJJTJGV2FuMi4yLUkyVi1BMTRCJTIyJTJDJTIwcHJvbXB0JTNEJTIydHVybiUyMHRoZSUyMGNhdCUyMGludG8lMjBhJTIwdGlnZXIlMjIpJTBBd2l0aCUyMG9wZW4oJTIydGlnZXIubXA0JTIyJTJDJTIwJTIyd2IlMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwZi53cml0ZSh2aWRlbyk=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>video = <span class="hljs-keyword">await</span> client.image_to_video(<span class="hljs-string">&quot;cat.jpg&quot;</span>, model=<span class="hljs-string">&quot;Wan-AI/Wan2.2-I2V-A14B&quot;</span>, prompt=<span class="hljs-string">&quot;turn the cat into a tiger&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;tiger.mp4&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    f.write(video)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-kvfsh7"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Yy(_){let n,o="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=b("p"),n.innerHTML=o},l(t){n=j(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-s2e3n9"&&(n.innerHTML=o)},m(t,s){I(t,n,s)},p:J,d(t){t&&M(n)}}}function Ry(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50Lm9iamVjdF9kZXRlY3Rpb24oJTIycGVvcGxlLmpwZyUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.object_detection(<span class="hljs-string">&quot;people.jpg&quot;</span>)
[ObjectDetectionOutputElement(score=<span class="hljs-number">0.9486683011054993</span>, label=<span class="hljs-string">&#x27;person&#x27;</span>, box=ObjectDetectionBoundingBox(xmin=<span class="hljs-number">59</span>, ymin=<span class="hljs-number">39</span>, xmax=<span class="hljs-number">420</span>, ymax=<span class="hljs-number">510</span>)), ...]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Xy(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnF1ZXN0aW9uX2Fuc3dlcmluZyhxdWVzdGlvbiUzRCUyMldoYXQncyUyMG15JTIwbmFtZSUzRiUyMiUyQyUyMGNvbnRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMENsYXJhJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmtlbGV5LiUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.question_answering(question=<span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>, context=<span class="hljs-string">&quot;My name is Clara and I live in Berkeley.&quot;</span>)
QuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;Clara&#x27;</span>, end=<span class="hljs-number">16</span>, score=<span class="hljs-number">0.9326565265655518</span>, start=<span class="hljs-number">11</span>)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function zy(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnNlbnRlbmNlX3NpbWlsYXJpdHkoJTBBJTIwJTIwJTIwJTIwJTIyTWFjaGluZSUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMGVhc3kuJTIyJTJDJTBBJTIwJTIwJTIwJTIwb3RoZXJfc2VudGVuY2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyRGVlcCUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMHN0cmFpZ2h0Zm9yd2FyZC4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJUaGlzJTIwaXMlMjBzbyUyMGRpZmZpY3VsdCUyQyUyMGxpa2UlMjByb2NrZXQlMjBzY2llbmNlLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBjYW4ndCUyMGJlbGlldmUlMjBob3clMjBtdWNoJTIwSSUyMHN0cnVnZ2xlZCUyMHdpdGglMjB0aGlzLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.sentence_similarity(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Machine learning is so easy.&quot;</span>,
<span class="hljs-meta">... </span>    other_sentences=[
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Deep learning is so straightforward.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;This is so difficult, like rocket science.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;I can&#x27;t believe how much I struggled with this.&quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>)
[<span class="hljs-number">0.7785726189613342</span>, <span class="hljs-number">0.45876261591911316</span>, <span class="hljs-number">0.2906220555305481</span>]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Fy(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnN1bW1hcml6YXRpb24oJTIyVGhlJTIwRWlmZmVsJTIwdG93ZXIuLi4lMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.summarization(<span class="hljs-string">&quot;The Eiffel tower...&quot;</span>)
SummarizationOutput(generated_text=<span class="hljs-string">&quot;The Eiffel tower is one of the most famous landmarks in the world....&quot;</span>)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Hy(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXF1ZXJ5JTIwJTNEJTIwJTIySG93JTIwbWFueSUyMHN0YXJzJTIwZG9lcyUyMHRoZSUyMHRyYW5zZm9ybWVycyUyMHJlcG9zaXRvcnklMjBoYXZlJTNGJTIyJTBBdGFibGUlMjAlM0QlMjAlN0IlMjJSZXBvc2l0b3J5JTIyJTNBJTIwJTVCJTIyVHJhbnNmb3JtZXJzJTIyJTJDJTIwJTIyRGF0YXNldHMlMjIlMkMlMjAlMjJUb2tlbml6ZXJzJTIyJTVEJTJDJTIwJTIyU3RhcnMlMjIlM0ElMjAlNUIlMjIzNjU0MiUyMiUyQyUyMCUyMjQ1MTIlMjIlMkMlMjAlMjIzOTM0JTIyJTVEJTdEJTBBYXdhaXQlMjBjbGllbnQudGFibGVfcXVlc3Rpb25fYW5zd2VyaW5nKHRhYmxlJTJDJTIwcXVlcnklMkMlMjBtb2RlbCUzRCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>query = <span class="hljs-string">&quot;How many stars does the transformers repository have?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {<span class="hljs-string">&quot;Repository&quot;</span>: [<span class="hljs-string">&quot;Transformers&quot;</span>, <span class="hljs-string">&quot;Datasets&quot;</span>, <span class="hljs-string">&quot;Tokenizers&quot;</span>], <span class="hljs-string">&quot;Stars&quot;</span>: [<span class="hljs-string">&quot;36542&quot;</span>, <span class="hljs-string">&quot;4512&quot;</span>, <span class="hljs-string">&quot;3934&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.table_question_answering(table, query, model=<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
TableQuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;36542&#x27;</span>, coordinates=[[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>]], cells=[<span class="hljs-string">&#x27;36542&#x27;</span>], aggregator=<span class="hljs-string">&#x27;AVERAGE&#x27;</span>)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Oy(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXRhYmxlJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyZml4ZWRfYWNpZGl0eSUyMiUzQSUyMCU1QiUyMjcuNCUyMiUyQyUyMCUyMjcuOCUyMiUyQyUyMCUyMjEwLjMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJ2b2xhdGlsZV9hY2lkaXR5JTIyJTNBJTIwJTVCJTIyMC43JTIyJTJDJTIwJTIyMC44OCUyMiUyQyUyMCUyMjAuMzIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJjaXRyaWNfYWNpZCUyMiUzQSUyMCU1QiUyMjAlMjIlMkMlMjAlMjIwJTIyJTJDJTIwJTIyMC40NSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnJlc2lkdWFsX3N1Z2FyJTIyJTNBJTIwJTVCJTIyMS45JTIyJTJDJTIwJTIyMi42JTIyJTJDJTIwJTIyNi40JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY2hsb3JpZGVzJTIyJTNBJTIwJTVCJTIyMC4wNzYlMjIlMkMlMjAlMjIwLjA5OCUyMiUyQyUyMCUyMjAuMDczJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyZnJlZV9zdWxmdXJfZGlveGlkZSUyMiUzQSUyMCU1QiUyMjExJTIyJTJDJTIwJTIyMjUlMjIlMkMlMjAlMjI1JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIydG90YWxfc3VsZnVyX2Rpb3hpZGUlMjIlM0ElMjAlNUIlMjIzNCUyMiUyQyUyMCUyMjY3JTIyJTJDJTIwJTIyMTMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJkZW5zaXR5JTIyJTNBJTIwJTVCJTIyMC45OTc4JTIyJTJDJTIwJTIyMC45OTY4JTIyJTJDJTIwJTIyMC45OTc2JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycEglMjIlM0ElMjAlNUIlMjIzLjUxJTIyJTJDJTIwJTIyMy4yJTIyJTJDJTIwJTIyMy4yMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnN1bHBoYXRlcyUyMiUzQSUyMCU1QiUyMjAuNTYlMjIlMkMlMjAlMjIwLjY4JTIyJTJDJTIwJTIyMC44MiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmFsY29ob2wlMjIlM0ElMjAlNUIlMjI5LjQlMjIlMkMlMjAlMjI5LjglMjIlMkMlMjAlMjIxMi42JTIyJTVEJTJDJTBBJTdEJTBBYXdhaXQlMjBjbGllbnQudGFidWxhcl9jbGFzc2lmaWNhdGlvbih0YWJsZSUzRHRhYmxlJTJDJTIwbW9kZWwlM0QlMjJqdWxpZW4tYyUyRndpbmUtcXVhbGl0eSUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;fixed_acidity&quot;</span>: [<span class="hljs-string">&quot;7.4&quot;</span>, <span class="hljs-string">&quot;7.8&quot;</span>, <span class="hljs-string">&quot;10.3&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;volatile_acidity&quot;</span>: [<span class="hljs-string">&quot;0.7&quot;</span>, <span class="hljs-string">&quot;0.88&quot;</span>, <span class="hljs-string">&quot;0.32&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;citric_acid&quot;</span>: [<span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0.45&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;residual_sugar&quot;</span>: [<span class="hljs-string">&quot;1.9&quot;</span>, <span class="hljs-string">&quot;2.6&quot;</span>, <span class="hljs-string">&quot;6.4&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;chlorides&quot;</span>: [<span class="hljs-string">&quot;0.076&quot;</span>, <span class="hljs-string">&quot;0.098&quot;</span>, <span class="hljs-string">&quot;0.073&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;free_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;11&quot;</span>, <span class="hljs-string">&quot;25&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;total_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;34&quot;</span>, <span class="hljs-string">&quot;67&quot;</span>, <span class="hljs-string">&quot;13&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;density&quot;</span>: [<span class="hljs-string">&quot;0.9978&quot;</span>, <span class="hljs-string">&quot;0.9968&quot;</span>, <span class="hljs-string">&quot;0.9976&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;pH&quot;</span>: [<span class="hljs-string">&quot;3.51&quot;</span>, <span class="hljs-string">&quot;3.2&quot;</span>, <span class="hljs-string">&quot;3.23&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;sulphates&quot;</span>: [<span class="hljs-string">&quot;0.56&quot;</span>, <span class="hljs-string">&quot;0.68&quot;</span>, <span class="hljs-string">&quot;0.82&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;alcohol&quot;</span>: [<span class="hljs-string">&quot;9.4&quot;</span>, <span class="hljs-string">&quot;9.8&quot;</span>, <span class="hljs-string">&quot;12.6&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.tabular_classification(table=table, model=<span class="hljs-string">&quot;julien-c/wine-quality&quot;</span>)
[<span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Dy(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXRhYmxlJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIySGVpZ2h0JTIyJTNBJTIwJTVCJTIyMTEuNTIlMjIlMkMlMjAlMjIxMi40OCUyMiUyQyUyMCUyMjEyLjM3NzglMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJMZW5ndGgxJTIyJTNBJTIwJTVCJTIyMjMuMiUyMiUyQyUyMCUyMjI0JTIyJTJDJTIwJTIyMjMuOSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMkxlbmd0aDIlMjIlM0ElMjAlNUIlMjIyNS40JTIyJTJDJTIwJTIyMjYuMyUyMiUyQyUyMCUyMjI2LjUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJMZW5ndGgzJTIyJTNBJTIwJTVCJTIyMzAlMjIlMkMlMjAlMjIzMS4yJTIyJTJDJTIwJTIyMzEuMSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMlNwZWNpZXMlMjIlM0ElMjAlNUIlMjJCcmVhbSUyMiUyQyUyMCUyMkJyZWFtJTIyJTJDJTIwJTIyQnJlYW0lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJXaWR0aCUyMiUzQSUyMCU1QiUyMjQuMDIlMjIlMkMlMjAlMjI0LjMwNTYlMjIlMkMlMjAlMjI0LjY5NjElMjIlNUQlMkMlMEElN0QlMEFhd2FpdCUyMGNsaWVudC50YWJ1bGFyX3JlZ3Jlc3Npb24odGFibGUlMkMlMjBtb2RlbCUzRCUyMnNjaWtpdC1sZWFybiUyRkZpc2gtV2VpZ2h0JTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Height&quot;</span>: [<span class="hljs-string">&quot;11.52&quot;</span>, <span class="hljs-string">&quot;12.48&quot;</span>, <span class="hljs-string">&quot;12.3778&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length1&quot;</span>: [<span class="hljs-string">&quot;23.2&quot;</span>, <span class="hljs-string">&quot;24&quot;</span>, <span class="hljs-string">&quot;23.9&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length2&quot;</span>: [<span class="hljs-string">&quot;25.4&quot;</span>, <span class="hljs-string">&quot;26.3&quot;</span>, <span class="hljs-string">&quot;26.5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length3&quot;</span>: [<span class="hljs-string">&quot;30&quot;</span>, <span class="hljs-string">&quot;31.2&quot;</span>, <span class="hljs-string">&quot;31.1&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Species&quot;</span>: [<span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Width&quot;</span>: [<span class="hljs-string">&quot;4.02&quot;</span>, <span class="hljs-string">&quot;4.3056&quot;</span>, <span class="hljs-string">&quot;4.6961&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.tabular_regression(table, model=<span class="hljs-string">&quot;scikit-learn/Fish-Weight&quot;</span>)
[<span class="hljs-number">110</span>, <span class="hljs-number">120</span>, <span class="hljs-number">130</span>]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Ly(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnRleHRfY2xhc3NpZmljYXRpb24oJTIySSUyMGxpa2UlMjB5b3UlMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.text_classification(<span class="hljs-string">&quot;I like you&quot;</span>)
[
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;POSITIVE&#x27;</span>, score=<span class="hljs-number">0.9998695850372314</span>),
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;NEGATIVE&#x27;</span>, score=<span class="hljs-number">0.0001304351753788069</span>),
]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Py(_){let n,o=`If you want to generate a response from chat messages, you should use the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">InferenceClient.chat_completion()</a> method.
It accepts a list of messages instead of a single text prompt and handles the chat templating for you.`;return{c(){n=b("p"),n.innerHTML=o},l(t){n=j(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-gq0ddh"&&(n.innerHTML=o)},m(t,s){I(t,n,s)},p:J,d(t){t&&M(n)}}}function Ky(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"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",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-comment"># Case 1: generate text</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>)
<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>

<span class="hljs-comment"># Case 2: iterate over the generated tokens. Useful for large generation.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
<span class="hljs-number">100</span>
%
<span class="hljs-built_in">open</span>
source
<span class="hljs-keyword">and</span>
built
to
be
easy
to
use
.

<span class="hljs-comment"># Case 3: get more details about the generation process.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>)
TextGenerationOutput(
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationDetails(
        finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>,
        generated_tokens=<span class="hljs-number">12</span>,
        seed=<span class="hljs-literal">None</span>,
        prefill=[
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">487</span>, text=<span class="hljs-string">&#x27;The&#x27;</span>, logprob=<span class="hljs-literal">None</span>),
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">53789</span>, text=<span class="hljs-string">&#x27; hugging&#x27;</span>, logprob=-<span class="hljs-number">13.171875</span>),
            (...)
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">204</span>, text=<span class="hljs-string">&#x27; &#x27;</span>, logprob=-<span class="hljs-number">7.0390625</span>)
        ],
        tokens=[
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>),
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>),
            (...)
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>, text=<span class="hljs-string">&#x27;.&#x27;</span>, logprob=-<span class="hljs-number">0.5703125</span>, special=<span class="hljs-literal">False</span>)
        ],
        best_of_sequences=<span class="hljs-literal">None</span>
    )
)

<span class="hljs-comment"># Case 4: iterate over the generated tokens with more details.</span>
<span class="hljs-comment"># Last object is more complete, containing the full generated text and the finish reason.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> details <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(details)
...
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1314</span>, text=<span class="hljs-string">&#x27; open&#x27;</span>, logprob=-<span class="hljs-number">1.3359375</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3178</span>, text=<span class="hljs-string">&#x27; source&#x27;</span>, logprob=-<span class="hljs-number">0.28100586</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">273</span>, text=<span class="hljs-string">&#x27; and&#x27;</span>, logprob=-<span class="hljs-number">0.5961914</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3426</span>, text=<span class="hljs-string">&#x27; built&#x27;</span>, logprob=-<span class="hljs-number">1.9423828</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">1.4121094</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">314</span>, text=<span class="hljs-string">&#x27; be&#x27;</span>, logprob=-<span class="hljs-number">1.5224609</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1833</span>, text=<span class="hljs-string">&#x27; easy&#x27;</span>, logprob=-<span class="hljs-number">2.1132812</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">0.08520508</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">745</span>, text=<span class="hljs-string">&#x27; use&#x27;</span>, logprob=-<span class="hljs-number">0.39453125</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(
    <span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>,
    text=<span class="hljs-string">&#x27;.&#x27;</span>,
    logprob=-<span class="hljs-number">0.5703125</span>,
    special=<span class="hljs-literal">False</span>),
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationStreamOutputStreamDetails(finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>, generated_tokens=<span class="hljs-number">12</span>, seed=<span class="hljs-literal">None</span>)
)

<span class="hljs-comment"># Case 5: generate constrained output using grammar</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>response = <span class="hljs-keyword">await</span> client.text_generation(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;HuggingFaceH4/zephyr-orpo-141b-A35b-v0.1&quot;</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    repetition_penalty=<span class="hljs-number">1.3</span>,
<span class="hljs-meta">... </span>    grammar={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;value&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;activity&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;animals_seen&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>, <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;maximum&quot;</span>: <span class="hljs-number">5</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;animals&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>, <span class="hljs-string">&quot;items&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}},
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;activity&quot;</span>, <span class="hljs-string">&quot;animals_seen&quot;</span>, <span class="hljs-string">&quot;animals&quot;</span>],
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>json.loads(response)
{
    <span class="hljs-string">&quot;activity&quot;</span>: <span class="hljs-string">&quot;bike riding&quot;</span>,
    <span class="hljs-string">&quot;animals&quot;</span>: [<span class="hljs-string">&quot;puppy&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;raccoon&quot;</span>],
    <span class="hljs-string">&quot;animals_seen&quot;</span>: <span class="hljs-number">3</span>,
    <span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;park&quot;</span>
}`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function eM(_){let n,o="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=b("p"),n.innerHTML=o},l(t){n=j(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-s2e3n9"&&(n.innerHTML=o)},m(t,s){I(t,n,s)},p:J,d(t){t&&M(n)}}}function nM(_){let n;return{c(){n=je("You can pass provider-specific parameters to the model by using the `extra_body` argument.")},l(o){n=_e(o,"You can pass provider-specific parameters to the model by using the `extra_body` argument.")},m(o,t){I(o,n,t)},d(o){o&&M(n)}}}function tM(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0QlMjJsb3clMjByZXNvbHV0aW9uJTJDJTIwYmx1cnJ5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMi0xJTIyJTJDJTBBKSUwQWltYWdlLnNhdmUoJTIyYmV0dGVyX2FzdHJvbmF1dC5wbmclMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>,
<span class="hljs-meta">... </span>    negative_prompt=<span class="hljs-string">&quot;low resolution, blurry&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;better_astronaut.png&quot;</span>)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function sM(_){let n,o;return n=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMmZhbC1haSUyMiUyQyUyMCUyMCUyMyUyMFVzZSUyMGZhbC5haSUyMHByb3ZpZGVyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMmZhbC1haS1hcGkta2V5JTIyJTJDJTIwJTIwJTIzJTIwUGFzcyUyMHlvdXIlMjBmYWwuYWklMjBBUEklMjBrZXklMEEpJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQudGV4dF90b19pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJBJTIwbWFqZXN0aWMlMjBsaW9uJTIwaW4lMjBhJTIwZmFudGFzeSUyMGZvcmVzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtc2NobmVsbCUyMiUyQyUwQSklMEFpbWFnZS5zYXZlKCUyMmxpb24ucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;fal-ai&quot;</span>,  <span class="hljs-comment"># Use fal.ai provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;fal-ai-api-key&quot;</span>,  <span class="hljs-comment"># Pass your fal.ai API key</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A majestic lion in a fantasy forest&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;lion.png&quot;</span>)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function aM(_){let n,o;return n=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUyMCUyMCUyMyUyMFVzZSUyMHJlcGxpY2F0ZSUyMHByb3ZpZGVyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMmhmXy4uLiUyMiUyQyUyMCUyMCUyMyUyMFBhc3MlMjB5b3VyJTIwSEYlMjB0b2tlbiUwQSklMEFpbWFnZSUyMCUzRCUyMGNsaWVudC50ZXh0X3RvX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMkFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjB0aGUlMjBtb29uLiUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBKSUwQWltYWdlLnNhdmUoJTIyYXN0cm9uYXV0LnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;replicate&quot;</span>,  <span class="hljs-comment"># Use replicate provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;hf_...&quot;</span>,  <span class="hljs-comment"># Pass your HF token</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function lM(_){let n,o;return n=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUyMCUyMCUyMyUyMFVzZSUyMHJlcGxpY2F0ZSUyMHByb3ZpZGVyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMmhmXy4uLiUyMiUyQyUyMCUyMCUyMyUyMFBhc3MlMjB5b3VyJTIwSEYlMjB0b2tlbiUwQSklMEFpbWFnZSUyMCUzRCUyMGNsaWVudC50ZXh0X3RvX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMkFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjB0aGUlMjBtb29uLiUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtc2NobmVsbCUyMiUyQyUwQSUyMCUyMCUyMCUyMGV4dHJhX2JvZHklM0QlN0IlMjJvdXRwdXRfcXVhbGl0eSUyMiUzQSUyMDEwMCU3RCUyQyUwQSklMEFpbWFnZS5zYXZlKCUyMmFzdHJvbmF1dC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;replicate&quot;</span>,  <span class="hljs-comment"># Use replicate provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;hf_...&quot;</span>,  <span class="hljs-comment"># Pass your HF token</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
<span class="hljs-meta">... </span>    extra_body={<span class="hljs-string">&quot;output_quality&quot;</span>: <span class="hljs-number">100</span>},
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function oM(_){let n;return{c(){n=je("You can pass provider-specific parameters to the model by using the `extra_body` argument.")},l(o){n=_e(o,"You can pass provider-specific parameters to the model by using the `extra_body` argument.")},m(o,t){I(o,n,t)},d(o){o&&M(n)}}}function iM(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWF1ZGlvJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19zcGVlY2goJTIySGVsbG8lMjB3b3JsZCUyMiklMEFQYXRoKCUyMmhlbGxvX3dvcmxkLmZsYWMlMjIpLndyaXRlX2J5dGVzKGF1ZGlvKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>audio = <span class="hljs-keyword">await</span> client.text_to_speech(<span class="hljs-string">&quot;Hello world&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function rM(_){let n,o;return n=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0QlMjJ5b3VyLXJlcGxpY2F0ZS1hcGkta2V5JTIyJTJDJTIwJTIwJTIzJTIwUGFzcyUyMHlvdXIlMjBSZXBsaWNhdGUlMjBBUEklMjBrZXklMjBkaXJlY3RseSUwQSklMEFhdWRpbyUyMCUzRCUyMGNsaWVudC50ZXh0X3RvX3NwZWVjaCglMEElMjAlMjAlMjAlMjB0ZXh0JTNEJTIySGVsbG8lMjB3b3JsZCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyT3V0ZUFJJTJGT3V0ZVRUUy0wLjMtNTAwTSUyMiUyQyUwQSklMEFQYXRoKCUyMmhlbGxvX3dvcmxkLmZsYWMlMjIpLndyaXRlX2J5dGVzKGF1ZGlvKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;replicate&quot;</span>,
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;your-replicate-api-key&quot;</span>,  <span class="hljs-comment"># Pass your Replicate API key directly</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = client.text_to_speech(
<span class="hljs-meta">... </span>    text=<span class="hljs-string">&quot;Hello world&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;OuteAI/OuteTTS-0.3-500M&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function cM(_){let n,o;return n=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0QlMjJoZl8uLi4lMjIlMkMlMjAlMjAlMjMlMjBQYXNzJTIweW91ciUyMEhGJTIwdG9rZW4lMEEpJTBBYXVkaW8lMjAlM0RjbGllbnQudGV4dF90b19zcGVlY2goJTBBJTIwJTIwJTIwJTIwdGV4dCUzRCUyMkhlbGxvJTIwd29ybGQlMjIlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMk91dGVBSSUyRk91dGVUVFMtMC4zLTUwME0lMjIlMkMlMEEpJTBBUGF0aCglMjJoZWxsb193b3JsZC5mbGFjJTIyKS53cml0ZV9ieXRlcyhhdWRpbyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;replicate&quot;</span>,
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;hf_...&quot;</span>,  <span class="hljs-comment"># Pass your HF token</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio =client.text_to_speech(
<span class="hljs-meta">... </span>    text=<span class="hljs-string">&quot;Hello world&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;OuteAI/OuteTTS-0.3-500M&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function pM(_){let n,o;return n=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUyMCUyMCUyMyUyMFVzZSUyMHJlcGxpY2F0ZSUyMHByb3ZpZGVyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMmhmXy4uLiUyMiUyQyUyMCUyMCUyMyUyMFBhc3MlMjB5b3VyJTIwSEYlMjB0b2tlbiUwQSklMEFhdWRpbyUyMCUzRCUyMGNsaWVudC50ZXh0X3RvX3NwZWVjaCglMEElMjAlMjAlMjAlMjAlMjJIZWxsbyUyQyUyMG15JTIwbmFtZSUyMGlzJTIwS29yb3JvJTJDJTIwYW4lMjBhd2Vzb21lJTIwdGV4dC10by1zcGVlY2glMjBtb2RlbC4lMjIlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMmhleGdyYWQlMkZLb2tvcm8tODJNJTIyJTJDJTBBJTIwJTIwJTIwJTIwZXh0cmFfYm9keSUzRCU3QiUyMnZvaWNlJTIyJTNBJTIwJTIyYWZfbmljb2xlJTIyJTdEJTJDJTBBKSUwQVBhdGgoJTIyaGVsbG8uZmxhYyUyMikud3JpdGVfYnl0ZXMoYXVkaW8p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;replicate&quot;</span>,  <span class="hljs-comment"># Use replicate provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;hf_...&quot;</span>,  <span class="hljs-comment"># Pass your HF token</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = client.text_to_speech(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Hello, my name is Kororo, an awesome text-to-speech model.&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;hexgrad/Kokoro-82M&quot;</span>,
<span class="hljs-meta">... </span>    extra_body={<span class="hljs-string">&quot;voice&quot;</span>: <span class="hljs-string">&quot;af_nicole&quot;</span>},
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function gM(_){let n,o;return n=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWx5cmljcyUyMCUzRCUyMCcnJyUwQSU1QnZlcnNlJTVEJTBBSW4lMjB0aGUlMjB0b3duJTIwd2hlcmUlMjBJJTIwd2FzJTIwYm9ybiUwQUxpdmVkJTIwYSUyMG1hbiUyMHdobyUyMHNhaWxlZCUyMHRvJTIwc2VhJTBBQW5kJTIwaGUlMjB0b2xkJTIwdXMlMjBvZiUyMGhpcyUyMGxpZmUlMEFJbiUyMHRoZSUyMGxhbmQlMjBvZiUyMHN1Ym1hcmluZXMlMEFTbyUyMHdlJTIwc2FpbGVkJTIwb24lMjB0byUyMHRoZSUyMHN1biUwQSdUaWwlMjB3ZSUyMGZvdW5kJTIwYSUyMHNlYSUyMG9mJTIwZ3JlZW4lMEFBbmQlMjB3ZSUyMGxpdmVkJTIwYmVuZWF0aCUyMHRoZSUyMHdhdmVzJTBBSW4lMjBvdXIlMjB5ZWxsb3clMjBzdWJtYXJpbmUlMEElMEElNUJjaG9ydXMlNUQlMEFXZSUyMGFsbCUyMGxpdmUlMjBpbiUyMGElMjB5ZWxsb3clMjBzdWJtYXJpbmUlMEFZZWxsb3clMjBzdWJtYXJpbmUlMkMlMjB5ZWxsb3clMjBzdWJtYXJpbmUlMEFXZSUyMGFsbCUyMGxpdmUlMjBpbiUyMGElMjB5ZWxsb3clMjBzdWJtYXJpbmUlMEFZZWxsb3clMjBzdWJtYXJpbmUlMkMlMjB5ZWxsb3clMjBzdWJtYXJpbmUlMEEnJyclMEFnZW5yZXMlMjAlM0QlMjAlMjJwYXZhcm90dGktc3R5bGUlMjB0ZW5vciUyMHZvaWNlJTIyJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUwQSUyMCUyMCUyMCUyMHByb3ZpZGVyJTNEJTIyZmFsLWFpJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJtLWEtcCUyRll1RS1zMS03Qi1hbm5lYWwtZW4tY290JTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRC4uLiUyQyUwQSklMEFhdWRpbyUyMCUzRCUyMGNsaWVudC50ZXh0X3RvX3NwZWVjaChseXJpY3MlMkMlMjBleHRyYV9ib2R5JTNEJTdCJTIyZ2VucmVzJTIyJTNBJTIwZ2VucmVzJTdEKSUwQXdpdGglMjBvcGVuKCUyMm91dHB1dC5tcDMlMjIlMkMlMjAlMjJ3YiUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjBmLndyaXRlKGF1ZGlvKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>lyrics = <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>[verse]
<span class="hljs-meta">... </span>In the town where I was born
<span class="hljs-meta">... </span>Lived a man who sailed to sea
<span class="hljs-meta">... </span>And he told us of his life
<span class="hljs-meta">... </span>In the land of submarines
<span class="hljs-meta">... </span>So we sailed on to the sun
<span class="hljs-meta">... </span>&#x27;Til we found a sea of green
<span class="hljs-meta">... </span>And we lived beneath the waves
<span class="hljs-meta">... </span>In our yellow submarine

<span class="hljs-meta">... </span>[chorus]
<span class="hljs-meta">... </span>We all live in a yellow submarine
<span class="hljs-meta">... </span>Yellow submarine, yellow submarine
<span class="hljs-meta">... </span>We all live in a yellow submarine
<span class="hljs-meta">... </span>Yellow submarine, yellow submarine
<span class="hljs-meta">... </span>&#x27;&#x27;&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>genres = <span class="hljs-string">&quot;pavarotti-style tenor voice&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;fal-ai&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;m-a-p/YuE-s1-7B-anneal-en-cot&quot;</span>,
<span class="hljs-meta">... </span>    api_key=...,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = client.text_to_speech(lyrics, extra_body={<span class="hljs-string">&quot;genres&quot;</span>: genres})
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;output.mp3&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    f.write(audio)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function uM(_){let n;return{c(){n=je("You can pass provider-specific parameters to the model by using the `extra_body` argument.")},l(o){n=_e(o,"You can pass provider-specific parameters to the model by using the `extra_body` argument.")},m(o,t){I(o,n,t)},d(o){o&&M(n)}}}function mM(_){let n,o;return n=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMmZhbC1haSUyMiUyQyUyMCUyMCUyMyUyMFVzaW5nJTIwZmFsLmFpJTIwcHJvdmlkZXIlMEElMjAlMjAlMjAlMjBhcGlfa2V5JTNEJTIyZmFsLWFpLWFwaS1rZXklMjIlMkMlMjAlMjAlMjMlMjBQYXNzJTIweW91ciUyMGZhbC5haSUyMEFQSSUyMGtleSUwQSklMEF2aWRlbyUyMCUzRCUyMGNsaWVudC50ZXh0X3RvX3ZpZGVvKCUwQSUyMCUyMCUyMCUyMCUyMkElMjBtYWplc3RpYyUyMGxpb24lMjBydW5uaW5nJTIwaW4lMjBhJTIwZmFudGFzeSUyMGZvcmVzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIydGVuY2VudCUyRkh1bnl1YW5WaWRlbyUyMiUyQyUwQSklMEF3aXRoJTIwb3BlbiglMjJsaW9uLm1wNCUyMiUyQyUyMCUyMndiJTIyKSUyMGFzJTIwZmlsZSUzQSUwQSUyMCUyMCUyMCUyMGZpbGUud3JpdGUodmlkZW8p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;fal-ai&quot;</span>,  <span class="hljs-comment"># Using fal.ai provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;fal-ai-api-key&quot;</span>,  <span class="hljs-comment"># Pass your fal.ai API key</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = client.text_to_video(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A majestic lion running in a fantasy forest&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;tencent/HunyuanVideo&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;lion.mp4&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> file:
<span class="hljs-meta">... </span>    file.write(video)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function hM(_){let n,o;return n=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUyMCUyMCUyMyUyMFVzaW5nJTIwcmVwbGljYXRlJTIwcHJvdmlkZXIlMEElMjAlMjAlMjAlMjBhcGlfa2V5JTNEJTIyaGZfLi4uJTIyJTJDJTIwJTIwJTIzJTIwUGFzcyUyMHlvdXIlMjBIRiUyMHRva2VuJTBBKSUwQXZpZGVvJTIwJTNEJTIwY2xpZW50LnRleHRfdG9fdmlkZW8oJTBBJTIwJTIwJTIwJTIwJTIyQSUyMGNhdCUyMHJ1bm5pbmclMjBpbiUyMGElMjBwYXJrJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJnZW5tbyUyRm1vY2hpLTEtcHJldmlldyUyMiUyQyUwQSklMEF3aXRoJTIwb3BlbiglMjJjYXQubXA0JTIyJTJDJTIwJTIyd2IlMjIpJTIwYXMlMjBmaWxlJTNBJTBBJTIwJTIwJTIwJTIwZmlsZS53cml0ZSh2aWRlbyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;replicate&quot;</span>,  <span class="hljs-comment"># Using replicate provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;hf_...&quot;</span>,  <span class="hljs-comment"># Pass your HF token</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = client.text_to_video(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A cat running in a park&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;genmo/mochi-1-preview&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;cat.mp4&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> file:
<span class="hljs-meta">... </span>    file.write(video)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function dM(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnRva2VuX2NsYXNzaWZpY2F0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.token_classification(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>)
[
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9971321225166321</span>,
        word=<span class="hljs-string">&#x27;Sarah Jessica Parker&#x27;</span>,
        start=<span class="hljs-number">11</span>,
        end=<span class="hljs-number">31</span>,
    ),
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9773476123809814</span>,
        word=<span class="hljs-string">&#x27;Jessica&#x27;</span>,
        start=<span class="hljs-number">52</span>,
        end=<span class="hljs-number">59</span>,
    )
]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function fM(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwV29sZmdhbmclMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwQmVybGluJTIyKSUwQWF3YWl0JTIwY2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwV29sZmdhbmclMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwQmVybGluJTIyJTJDJTIwbW9kZWwlM0QlMjJIZWxzaW5raS1OTFAlMkZvcHVzLW10LWVuLWZyJTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>)
<span class="hljs-string">&#x27;Mein Name ist Wolfgang und ich lebe in Berlin.&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>, model=<span class="hljs-string">&quot;Helsinki-NLP/opus-mt-en-fr&quot;</span>)
TranslationOutput(translation_text=<span class="hljs-string">&#x27;Je m&#x27;</span>appelle Wolfgang et je vis à Berlin.<span class="hljs-string">&#x27;)</span>`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function yM(_){let n,o="Specifying languages:",t,s,i;return s=new U({props:{code:"Y2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMiUyQyUyMG1vZGVsJTNEJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJlbl9YWCUyMiUyQyUyMHRndF9sYW5nJTNEJTIyZnJfWFglMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>, model=<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;en_XX&quot;</span>, tgt_lang=<span class="hljs-string">&quot;fr_XX&quot;</span>)
<span class="hljs-string">&quot;Mon nom est Sarah Jessica Parker mais vous pouvez m&#x27;appeler Jessica&quot;</span>`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-mhcj6c"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function MM(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnZpc3VhbF9xdWVzdGlvbl9hbnN3ZXJpbmcoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZtaXNoaWclMkZzYW1wbGVfaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGclMjIlMkMlMEElMjAlMjAlMjAlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGFuaW1hbCUyMGRvaW5nJTNGJTIyJTBBKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.visual_question_answering(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;https://huggingface.co/datasets/mishig/sample_images/resolve/main/tiger.jpg&quot;</span>,
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the animal doing?&quot;</span>
<span class="hljs-meta">... </span>)
[
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.778609573841095</span>, answer=<span class="hljs-string">&#x27;laying down&#x27;</span>),
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.6957435607910156</span>, answer=<span class="hljs-string">&#x27;sitting&#x27;</span>),
]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function bM(_){let n,o="Example with <code>multi_label=False</code>:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXRleHQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIyQSUyMG5ldyUyMG1vZGVsJTIwb2ZmZXJzJTIwYW4lMjBleHBsYW5hdGlvbiUyMGZvciUyMGhvdyUyMHRoZSUyMEdhbGlsZWFuJTIwc2F0ZWxsaXRlcyUyMGZvcm1lZCUyMGFyb3VuZCUyMHRoZSUyMHNvbGFyJTIwc3lzdGVtJ3MlMjIlMEElMjAlMjAlMjAlMjAlMjJsYXJnZXN0JTIwd29ybGQuJTIwS29uc3RhbnRpbiUyMEJhdHlnaW4lMjBkaWQlMjBub3QlMjBzZXQlMjBvdXQlMjB0byUyMHNvbHZlJTIwb25lJTIwb2YlMjB0aGUlMjBzb2xhciUyMHN5c3RlbSdzJTIwbW9zdCUyMHB1enpsaW5nJTIyJTBBJTIwJTIwJTIwJTIwJTIyJTIwbXlzdGVyaWVzJTIwd2hlbiUyMGhlJTIwd2VudCUyMGZvciUyMGElMjBydW4lMjB1cCUyMGElMjBoaWxsJTIwaW4lMjBOaWNlJTJDJTIwRnJhbmNlLiUyMiUwQSklMEFsYWJlbHMlMjAlM0QlMjAlNUIlMjJzcGFjZSUyMCUyNiUyMGNvc21vcyUyMiUyQyUyMCUyMnNjaWVudGlmaWMlMjBkaXNjb3ZlcnklMjIlMkMlMjAlMjJtaWNyb2Jpb2xvZ3klMjIlMkMlMjAlMjJyb2JvdHMlMjIlMkMlMjAlMjJhcmNoZW9sb2d5JTIyJTVEJTBBYXdhaXQlMjBjbGllbnQuemVyb19zaG90X2NsYXNzaWZpY2F0aW9uKHRleHQlMkMlMjBsYWJlbHMpJTBBYXdhaXQlMjBjbGllbnQuemVyb19zaG90X2NsYXNzaWZpY2F0aW9uKHRleHQlMkMlMjBsYWJlbHMlMkMlMjBtdWx0aV9sYWJlbCUzRFRydWUp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A new model offers an explanation for how the Galilean satellites formed around the solar system&#x27;s&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;largest world. Konstantin Batygin did not set out to solve one of the solar system&#x27;s most puzzling&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot; mysteries when he went for a run up a hill in Nice, France.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [<span class="hljs-string">&quot;space &amp; cosmos&quot;</span>, <span class="hljs-string">&quot;scientific discovery&quot;</span>, <span class="hljs-string">&quot;microbiology&quot;</span>, <span class="hljs-string">&quot;robots&quot;</span>, <span class="hljs-string">&quot;archeology&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_classification(text, labels)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.7961668968200684</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.18570658564567566</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.00730885099619627</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.006258360575884581</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.004559356719255447</span>),
]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_classification(text, labels, multi_label=<span class="hljs-literal">True</span>)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.9829297661781311</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.755190908908844</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.0005462635890580714</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.00047131875180639327</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.00030448526376858354</span>),
]`,wrap:!1}}),{c(){n=b("p"),n.innerHTML=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-90ztrp"&&(n.innerHTML=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function jM(_){let n,o="Example with <code>multi_label=True</code> and a custom <code>hypothesis_template</code>:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50Lnplcm9fc2hvdF9jbGFzc2lmaWNhdGlvbiglMEElMjAlMjAlMjB0ZXh0JTNEJTIySSUyMHJlYWxseSUyMGxpa2UlMjBvdXIlMjBkaW5uZXIlMjBhbmQlMjBJJ20lMjB2ZXJ5JTIwaGFwcHkuJTIwSSUyMGRvbid0JTIwbGlrZSUyMHRoZSUyMHdlYXRoZXIlMjB0aG91Z2guJTIyJTJDJTBBJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIycG9zaXRpdmUlMjIlMkMlMjAlMjJuZWdhdGl2ZSUyMiUyQyUyMCUyMnBlc3NpbWlzdGljJTIyJTJDJTIwJTIyb3B0aW1pc3RpYyUyMiU1RCUyQyUwQSUyMCUyMCUyMG11bHRpX2xhYmVsJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMGh5cG90aGVzaXNfdGVtcGxhdGUlM0QlMjJUaGlzJTIwdGV4dCUyMGlzJTIwJTdCJTdEJTIwdG93YXJkcyUyMHRoZSUyMHdlYXRoZXIlMjIlMEEp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_classification(
<span class="hljs-meta">... </span>   text=<span class="hljs-string">&quot;I really like our dinner and I&#x27;m very happy. I don&#x27;t like the weather though.&quot;</span>,
<span class="hljs-meta">... </span>   labels=[<span class="hljs-string">&quot;positive&quot;</span>, <span class="hljs-string">&quot;negative&quot;</span>, <span class="hljs-string">&quot;pessimistic&quot;</span>, <span class="hljs-string">&quot;optimistic&quot;</span>],
<span class="hljs-meta">... </span>   multi_label=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>   hypothesis_template=<span class="hljs-string">&quot;This text is {} towards the weather&quot;</span>
<span class="hljs-meta">... </span>)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;negative&#x27;</span>, score=<span class="hljs-number">0.9231801629066467</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;pessimistic&#x27;</span>, score=<span class="hljs-number">0.8760990500450134</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;optimistic&#x27;</span>, score=<span class="hljs-number">0.0008674879791215062</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;positive&#x27;</span>, score=<span class="hljs-number">0.0005250611575320363</span>)
]`,wrap:!1}}),{c(){n=b("p"),n.innerHTML=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1qklg9x"&&(n.innerHTML=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function _M(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWF3YWl0JTIwY2xpZW50Lnplcm9fc2hvdF9pbWFnZV9jbGFzc2lmaWNhdGlvbiglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRnVwbG9hZC53aWtpbWVkaWEub3JnJTJGd2lraXBlZGlhJTJGY29tbW9ucyUyRnRodW1iJTJGNCUyRjQzJTJGQ3V0ZV9kb2cuanBnJTJGMzIwcHgtQ3V0ZV9kb2cuanBnJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIyZG9nJTIyJTJDJTIwJTIyY2F0JTIyJTJDJTIwJTIyaG9yc2UlMjIlNUQlMkMlMEEp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_image_classification(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>,
<span class="hljs-meta">... </span>    labels=[<span class="hljs-string">&quot;dog&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;horse&quot;</span>],
<span class="hljs-meta">... </span>)
[ZeroShotImageClassificationOutputElement(label=<span class="hljs-string">&#x27;dog&#x27;</span>, score=<span class="hljs-number">0.956</span>),...]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function IM(_){let n,o="Example:",t,s,i;return s=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub.inference_api <span class="hljs-keyword">import</span> InferenceApi

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Mask-fill example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs=<span class="hljs-string">&quot;The goal of life is [MASK].&quot;</span>)
[{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;the goal of life is life.&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.10933292657136917</span>, <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">2166</span>, <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;life&#x27;</span>}]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Question Answering example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;deepset/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;question&quot;</span>: <span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;My name is Clara and I live in Berkeley.&quot;</span>,
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs)
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9326569437980652</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">11</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">16</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;Clara&#x27;</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Zero-shot example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;typeform/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-string">&quot;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = {<span class="hljs-string">&quot;candidate_labels&quot;</span>: [<span class="hljs-string">&quot;refund&quot;</span>, <span class="hljs-string">&quot;legal&quot;</span>, <span class="hljs-string">&quot;faq&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs, params)
{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;refund&#x27;</span>, <span class="hljs-string">&#x27;faq&#x27;</span>, <span class="hljs-string">&#x27;legal&#x27;</span>], <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.9378499388694763</span>, <span class="hljs-number">0.04914155602455139</span>, <span class="hljs-number">0.013008488342165947</span>]}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Overriding configured task</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>, task=<span class="hljs-string">&quot;feature-extraction&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Text-to-image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(<span class="hljs-string">&quot;cat&quot;</span>)
&lt;PIL.PngImagePlugin.PngImageFile image (...)&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Return as raw response to parse the output yourself</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;mio/amadeus&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response = inference(<span class="hljs-string">&quot;hello world&quot;</span>, raw_response=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.headers
{<span class="hljs-string">&quot;Content-Type&quot;</span>: <span class="hljs-string">&quot;audio/flac&quot;</span>, ...}
<span class="hljs-meta">&gt;&gt;&gt; </span>response.content <span class="hljs-comment"># raw bytes from server</span>
<span class="hljs-string">b&#x27;(...)&#x27;</span>`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){I(e,n,p),I(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function TM(_){let n,o,t,s,i,e,p,dm=`Inference is the process of using a trained model to make predictions on new data. Because this process can be compute-intensive, running on a dedicated or external service can be an interesting option.
The <code>huggingface_hub</code> library provides a unified interface to run inference across multiple services for models hosted on the Hugging Face Hub:`,Vi,fa,fm='<li><a href="https://huggingface.co/docs/inference-providers/index" rel="nofollow">Inference Providers</a>: a streamlined, unified access to hundreds of machine learning models, powered by our serverless inference partners. This new approach builds on our previous Serverless Inference API, offering more models, improved performance, and greater reliability thanks to world-class providers. Refer to the <a href="https://huggingface.co/docs/inference-providers/index#partners" rel="nofollow">documentation</a> for a list of supported providers.</li> <li><a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a>: a product to easily deploy models to production. Inference is run by Hugging Face in a dedicated, fully managed infrastructure on a cloud provider of your choice.</li> <li>Local endpoints: you can also run inference with local inference servers like <a href="https://github.com/ggerganov/llama.cpp" rel="nofollow">llama.cpp</a>, <a href="https://ollama.com/" rel="nofollow">Ollama</a>, <a href="https://github.com/vllm-project/vllm" rel="nofollow">vLLM</a>, <a href="https://docs.litellm.ai/docs/simple_proxy" rel="nofollow">LiteLLM</a>, or <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">Text Generation Inference (TGI)</a> by connecting the client to these local endpoints.</li>',Qi,ya,ym=`These services can be called with the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> object. Please refer to <a href="../guides/inference">this guide</a>
for more information on how to use it.`,Si,Ma,Yi,x,ba,tr,Rl,Mm="Initialize a new Inference Client.",sr,Xl,bm=`<a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> aims to provide a unified experience to perform inference. The client can be used
seamlessly with either the (free) Inference API, self-hosted Inference Endpoints, or third-party Inference Providers.`,ar,Be,ja,lr,zl,jm="Perform audio classification on the provided audio content.",or,lt,ir,Ve,_a,rr,Fl,_m="Performs multiple tasks related to audio-to-audio depending on the model (eg: speech enhancement, source separation).",cr,ot,pr,Qe,Ia,gr,Hl,Im="Perform automatic speech recognition (ASR or audio-to-text) on the given audio content.",ur,it,mr,Z,Ta,hr,Ol,Tm="A method for completing conversations using a specified language model.",dr,rt,fr,ct,yr,pt,Mr,gt,br,ut,jr,Dl,Jm="Example using a third-party provider directly with extra (provider-specific) parameters. Usage will be billed on your Together AI account.",_r,mt,Ir,Ll,Um="Example using a third-party provider through Hugging Face Routing. Usage will be billed on your Hugging Face account.",Tr,ht,Jr,dt,Ur,ft,wr,yt,Cr,Se,Ja,xr,Pl,wm="Answer questions on document images.",$r,Mt,vr,Ye,Ua,kr,Kl,Cm="Generate embeddings for a given text.",qr,bt,Ar,Re,wa,Zr,eo,xm="Fill in a hole with a missing word (token to be precise).",Er,jt,Wr,se,Ca,Nr,no,$m="Get information about the deployed endpoint.",Gr,to,vm=`This endpoint is only available on endpoints powered by Text-Generation-Inference (TGI) or Text-Embedding-Inference (TEI).
Endpoints powered by <code>transformers</code> return an empty payload.`,Br,_t,Vr,ae,xa,Qr,so,km="Check the health of the deployed endpoint.",Sr,ao,qm="Health check is only available with Inference Endpoints powered by Text-Generation-Inference (TGI) or Text-Embedding-Inference (TEI).",Yr,It,Rr,Xe,$a,Xr,lo,Am="Perform image classification on the given image using the specified model.",zr,Tt,Fr,le,va,Hr,oo,Zm="Perform image segmentation on the given image using the specified model.",Or,Jt,Dr,Ut,Lr,oe,ka,Pr,io,Em="Perform image-to-image translation using a specified model.",Kr,wt,ec,Ct,nc,ie,qa,tc,ro,Wm="Takes an input image and return text.",sc,co,Nm=`Models can have very different outputs depending on your use case (image captioning, optical character recognition
(OCR), Pix2Struct, etc). Please have a look to the model card to learn more about a model’s specificities.`,ac,xt,lc,ze,Aa,oc,po,Gm="Generate a video from an input image.",ic,$t,rc,re,Za,cc,go,Bm="Perform object detection on the given image using the specified model.",pc,vt,gc,kt,uc,Fe,Ea,mc,uo,Vm="Retrieve the answer to a question from a given text.",hc,qt,dc,He,Wa,fc,mo,Qm="Compute the semantic similarity between a sentence and a list of other sentences by comparing their embeddings.",yc,At,Mc,Oe,Na,bc,ho,Sm="Generate a summary of a given text using a specified model.",jc,Zt,_c,De,Ga,Ic,fo,Ym="Retrieve the answer to a question from information given in a table.",Tc,Et,Jc,Le,Ba,Uc,yo,Rm="Classifying a target category (a group) based on a set of attributes.",wc,Wt,Cc,Pe,Va,xc,Mo,Xm="Predicting a numerical target value given a set of attributes/features in a table.",$c,Nt,vc,Ke,Qa,kc,bo,zm="Perform text classification (e.g. sentiment-analysis) on the given text.",qc,Gt,Ac,ce,Sa,Zc,jo,Fm="Given a prompt, generate the following text.",Ec,Bt,Wc,Vt,Nc,S,Ya,Gc,_o,Hm="Generate an image based on a given text using a specified model.",Bc,Qt,Vc,St,Qc,Yt,Sc,Rt,Yc,Io,Om="Example using a third-party provider through Hugging Face Routing. Usage will be billed on your Hugging Face account.",Rc,Xt,Xc,To,Dm="Example using Replicate provider with extra parameters",zc,zt,Fc,G,Ra,Hc,Jo,Lm="Synthesize an audio of a voice pronouncing a given text.",Oc,Ft,Dc,Ht,Lc,Uo,Pm="Example using a third-party provider directly. Usage will be billed on your Replicate account.",Pc,Ot,Kc,wo,Km="Example using a third-party provider through Hugging Face Routing. Usage will be billed on your Hugging Face account.",ep,Dt,np,Lt,tp,Co,eh="Example music-gen using “YuE-s1-7B-anneal-en-cot” on fal.ai",sp,Pt,ap,z,Xa,lp,xo,nh="Generate a video based on a given text.",op,Kt,ip,$o,th="Example:",rp,vo,sh="Example using a third-party provider directly. Usage will be billed on your fal.ai account.",cp,es,pp,ko,ah="Example using a third-party provider through Hugging Face Routing. Usage will be billed on your Hugging Face account.",gp,ns,up,en,za,mp,qo,lh=`Perform token classification on the given text.
Usually used for sentence parsing, either grammatical, or Named Entity Recognition (NER) to understand keywords contained within text.`,hp,ts,dp,P,Fa,fp,Ao,oh="Convert text from one language to another.",yp,Zo,ih=`Check out <a href="https://huggingface.co/tasks/translation" rel="nofollow">https://huggingface.co/tasks/translation</a> for more information on how to choose the best model for
your specific use case. Source and target languages usually depend on the model.
However, it is possible to specify source and target languages for certain models. If you are working with one of these models,
you can use <code>src_lang</code> and <code>tgt_lang</code> arguments to pass the relevant information.`,Mp,ss,bp,as,jp,nn,Ha,_p,Eo,rh="Answering open-ended questions based on an image.",Ip,ls,Tp,pe,Oa,Jp,Wo,ch="Provide as input a text and a set of candidate labels to classify the input text.",Up,os,wp,is,Cp,tn,Da,xp,No,ph="Provide input image and text labels to predict text labels for the image.",$p,rs,Ri,La,Xi,Pa,gh=`An async version of the client is also provided, based on <code>asyncio</code> and <code>aiohttp</code>.
To use it, you can either install <code>aiohttp</code> directly or use the <code>[inference]</code> extra:`,zi,Ka,Fi,C,el,vp,Go,uh="Initialize a new Inference Client.",kp,Bo,mh=`<a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> aims to provide a unified experience to perform inference. The client can be used
seamlessly with either the (free) Inference API, self-hosted Inference Endpoints, or third-party Inference Providers.`,qp,sn,nl,Ap,Vo,hh="Perform audio classification on the provided audio content.",Zp,cs,Ep,an,tl,Wp,Qo,dh="Performs multiple tasks related to audio-to-audio depending on the model (eg: speech enhancement, source separation).",Np,ps,Gp,ln,sl,Bp,So,fh="Perform automatic speech recognition (ASR or audio-to-text) on the given audio content.",Vp,gs,Qp,E,al,Sp,Yo,yh="A method for completing conversations using a specified language model.",Yp,us,Rp,ms,Xp,hs,zp,ds,Fp,fs,Hp,Ro,Mh="Example using a third-party provider directly with extra (provider-specific) parameters. Usage will be billed on your Together AI account.",Op,ys,Dp,Xo,bh="Example using a third-party provider through Hugging Face Routing. Usage will be billed on your Hugging Face account.",Lp,Ms,Pp,bs,Kp,js,eg,_s,ng,ge,ll,tg,zo,jh="Close all open sessions.",sg,Fo,_h=`By default, ‘aiohttp.ClientSession’ objects are closed automatically when a call is completed. However, if you
are streaming data from the server and you stop before the stream is complete, you must call this method to
close the session properly.`,ag,Ho,Ih="Another possibility is to use an async context (e.g. <code>async with AsyncInferenceClient(): ...</code>).",lg,on,ol,og,Oo,Th="Answer questions on document images.",ig,Is,rg,rn,il,cg,Do,Jh="Generate embeddings for a given text.",pg,Ts,gg,cn,rl,ug,Lo,Uh="Fill in a hole with a missing word (token to be precise).",mg,Js,hg,ue,cl,dg,Po,wh="Get information about the deployed endpoint.",fg,Ko,Ch=`This endpoint is only available on endpoints powered by Text-Generation-Inference (TGI) or Text-Embedding-Inference (TEI).
Endpoints powered by <code>transformers</code> return an empty payload.`,yg,Us,Mg,me,pl,bg,ei,xh="Check the health of the deployed endpoint.",jg,ni,$h="Health check is only available with Inference Endpoints powered by Text-Generation-Inference (TGI) or Text-Embedding-Inference (TEI).",_g,ws,Ig,pn,gl,Tg,ti,vh="Perform image classification on the given image using the specified model.",Jg,Cs,Ug,he,ul,wg,si,kh="Perform image segmentation on the given image using the specified model.",Cg,xs,xg,$s,$g,de,ml,vg,ai,qh="Perform image-to-image translation using a specified model.",kg,vs,qg,ks,Ag,fe,hl,Zg,li,Ah="Takes an input image and return text.",Eg,oi,Zh=`Models can have very different outputs depending on your use case (image captioning, optical character recognition
(OCR), Pix2Struct, etc). Please have a look to the model card to learn more about a model’s specificities.`,Wg,qs,Ng,gn,dl,Gg,ii,Eh="Generate a video from an input image.",Bg,As,Vg,ye,fl,Qg,ri,Wh="Perform object detection on the given image using the specified model.",Sg,Zs,Yg,Es,Rg,un,yl,Xg,ci,Nh="Retrieve the answer to a question from a given text.",zg,Ws,Fg,mn,Ml,Hg,pi,Gh="Compute the semantic similarity between a sentence and a list of other sentences by comparing their embeddings.",Og,Ns,Dg,hn,bl,Lg,gi,Bh="Generate a summary of a given text using a specified model.",Pg,Gs,Kg,dn,jl,eu,ui,Vh="Retrieve the answer to a question from information given in a table.",nu,Bs,tu,fn,_l,su,mi,Qh="Classifying a target category (a group) based on a set of attributes.",au,Vs,lu,yn,Il,ou,hi,Sh="Predicting a numerical target value given a set of attributes/features in a table.",iu,Qs,ru,Mn,Tl,cu,di,Yh="Perform text classification (e.g. sentiment-analysis) on the given text.",pu,Ss,gu,Me,Jl,uu,fi,Rh="Given a prompt, generate the following text.",mu,Ys,hu,Rs,du,Y,Ul,fu,yi,Xh="Generate an image based on a given text using a specified model.",yu,Xs,Mu,zs,bu,Fs,ju,Hs,_u,Mi,zh="Example using a third-party provider through Hugging Face Routing. Usage will be billed on your Hugging Face account.",Iu,Os,Tu,bi,Fh="Example using Replicate provider with extra parameters",Ju,Ds,Uu,B,wl,wu,ji,Hh="Synthesize an audio of a voice pronouncing a given text.",Cu,Ls,xu,Ps,$u,_i,Oh="Example using a third-party provider directly. Usage will be billed on your Replicate account.",vu,Ks,ku,Ii,Dh="Example using a third-party provider through Hugging Face Routing. Usage will be billed on your Hugging Face account.",qu,ea,Au,na,Zu,Ti,Lh="Example music-gen using “YuE-s1-7B-anneal-en-cot” on fal.ai",Eu,ta,Wu,F,Cl,Nu,Ji,Ph="Generate a video based on a given text.",Gu,sa,Bu,Ui,Kh="Example:",Vu,wi,ed="Example using a third-party provider directly. Usage will be billed on your fal.ai account.",Qu,aa,Su,Ci,nd="Example using a third-party provider through Hugging Face Routing. Usage will be billed on your Hugging Face account.",Yu,la,Ru,bn,xl,Xu,xi,td=`Perform token classification on the given text.
Usually used for sentence parsing, either grammatical, or Named Entity Recognition (NER) to understand keywords contained within text.`,zu,oa,Fu,K,$l,Hu,$i,sd="Convert text from one language to another.",Ou,vi,ad=`Check out <a href="https://huggingface.co/tasks/translation" rel="nofollow">https://huggingface.co/tasks/translation</a> for more information on how to choose the best model for
your specific use case. Source and target languages usually depend on the model.
However, it is possible to specify source and target languages for certain models. If you are working with one of these models,
you can use <code>src_lang</code> and <code>tgt_lang</code> arguments to pass the relevant information.`,Du,ia,Lu,ra,Pu,jn,vl,Ku,ki,ld="Answering open-ended questions based on an image.",em,ca,nm,be,kl,tm,qi,od="Provide as input a text and a set of candidate labels to classify the input text.",sm,pa,am,ga,lm,_n,ql,om,Ai,id="Provide input image and text labels to predict text labels for the image.",im,ua,Hi,Al,Oi,In,Zl,rm,Zi,rd="Error raised when a model is unavailable or the request times out.",Di,El,Li,Wl,cd=`<code>InferenceAPI</code> is the legacy way to call the Inference API. The interface is more simplistic and requires knowing
the input parameters and output format for each task. It also lacks the ability to connect to other services like
Inference Endpoints or AWS SageMaker. <code>InferenceAPI</code> will soon be deprecated so we recommend using <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
whenever possible. Check out <a href="../guides/inference#legacy-inferenceapi-client">this guide</a> to learn how to switch from
<code>InferenceAPI</code> to <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> in your scripts.`,Pi,L,Nl,cm,Ei,pd="Client to configure requests and make calls to the HuggingFace Inference API.",pm,ma,gm,ha,Gl,um,Wi,gd="Inits headers and API call information.",mm,da,Bl,hm,Ni,ud="Make a call to the Inference API.",Ki,Vl,er,Gi,nr;return i=new Bi({props:{title:"Inference",local:"inference",headingTag:"h1"}}),Ma=new Bi({props:{title:"Inference Client",local:"huggingface_hub.InferenceClient",headingTag:"h2"}}),ba=new A({props:{name:"class huggingface_hub.InferenceClient",anchor:"huggingface_hub.InferenceClient",parameters:[{name:"model",val:": typing.Optional[str] = None"},{name:"provider",val:": typing.Union[typing.Literal['black-forest-labs', 'cerebras', 'cohere', 'fal-ai', 'featherless-ai', 'fireworks-ai', 'groq', 'hf-inference', 'hyperbolic', 'nebius', 'novita', 'nscale', 'openai', 'replicate', 'sambanova', 'together'], typing.Literal['auto'], NoneType] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"timeout",val:": typing.Optional[float] = None"},{name:"headers",val:": typing.Optional[typing.Dict[str, str]] = None"},{name:"cookies",val:": typing.Optional[typing.Dict[str, str]] = None"},{name:"proxies",val:": typing.Optional[typing.Any] = None"},{name:"bill_to",val:": typing.Optional[str] = None"},{name:"base_url",val:": typing.Optional[str] = None"},{name:"api_key",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.model",description:`<strong>model</strong> (<code>str</code>, <code>optional</code>) &#x2014;
The model to run inference with. Can be a model id hosted on the Hugging Face Hub, e.g. <code>meta-llama/Meta-Llama-3-8B-Instruct</code>
or a URL to a deployed Inference Endpoint. Defaults to None, in which case a recommended model is
automatically selected for the task.
Note: for better compatibility with OpenAI&#x2019;s client, <code>model</code> has been aliased as <code>base_url</code>. Those 2
arguments are mutually exclusive. If a URL is passed as <code>model</code> or <code>base_url</code> for chat completion, the <code>(/v1)/chat/completions</code> suffix path will be appended to the URL.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.provider",description:"<strong>provider</strong> (<code>str</code>, <em>optional</em>) &#x2014;\nName of the provider to use for inference. Can be <code>&quot;black-forest-labs&quot;</code>, <code>&quot;cerebras&quot;</code>, <code>&quot;cohere&quot;</code>, <code>&quot;fal-ai&quot;</code>, <code>&quot;featherless-ai&quot;</code>, <code>&quot;fireworks-ai&quot;</code>, <code>&quot;groq&quot;</code>, <code>&quot;hf-inference&quot;</code>, <code>&quot;hyperbolic&quot;</code>, <code>&quot;nebius&quot;</code>, <code>&quot;novita&quot;</code>, <code>&quot;nscale&quot;</code>, <code>&quot;openai&quot;</code>, <code>&quot;replicate&quot;</code>, &#x201C;sambanova&#x201D;<code>or</code>&#x201C;together&#x201D;<code>. Defaults to &quot;auto&quot; i.e. the first of the providers available for the model, sorted by the user&apos;s order in https://hf.co/settings/inference-providers. If model is a URL or </code>base_url<code>is passed, then</code>provider` is not used.",name:"provider"},{anchor:"huggingface_hub.InferenceClient.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Hugging Face token. Will default to the locally saved token if not provided.
Note: for better compatibility with OpenAI&#x2019;s client, <code>token</code> has been aliased as <code>api_key</code>. Those 2
arguments are mutually exclusive and have the exact same behavior.`,name:"token"},{anchor:"huggingface_hub.InferenceClient.timeout",description:`<strong>timeout</strong> (<code>float</code>, <code>optional</code>) &#x2014;
The maximum number of seconds to wait for a response from the server. Defaults to None, meaning it will loop until the server is available.`,name:"timeout"},{anchor:"huggingface_hub.InferenceClient.headers",description:`<strong>headers</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional headers to send to the server. By default only the authorization and user-agent headers are sent.
Values in this dictionary will override the default values.`,name:"headers"},{anchor:"huggingface_hub.InferenceClient.bill_to",description:`<strong>bill_to</strong> (<code>str</code>, <code>optional</code>) &#x2014;
The billing account to use for the requests. By default the requests are billed on the user&#x2019;s account.
Requests can only be billed to an organization the user is a member of, and which has subscribed to Enterprise Hub.`,name:"bill_to"},{anchor:"huggingface_hub.InferenceClient.cookies",description:`<strong>cookies</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional cookies to send to the server.`,name:"cookies"},{anchor:"huggingface_hub.InferenceClient.proxies",description:`<strong>proxies</strong> (<code>Any</code>, <code>optional</code>) &#x2014;
Proxies to use for the request.`,name:"proxies"},{anchor:"huggingface_hub.InferenceClient.base_url",description:`<strong>base_url</strong> (<code>str</code>, <code>optional</code>) &#x2014;
Base URL to run inference. This is a duplicated argument from <code>model</code> to make <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
follow the same pattern as <code>openai.OpenAI</code> client. Cannot be used if <code>model</code> is set. Defaults to None.`,name:"base_url"},{anchor:"huggingface_hub.InferenceClient.api_key",description:`<strong>api_key</strong> (<code>str</code>, <code>optional</code>) &#x2014;
Token to use for authentication. This is a duplicated argument from <code>token</code> to make <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
follow the same pattern as <code>openai.OpenAI</code> client. Cannot be used if <code>token</code> is set. Defaults to None.`,name:"api_key"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L118"}}),ja=new A({props:{name:"audio_classification",anchor:"huggingface_hub.InferenceClient.audio_classification",parameters:[{name:"audio",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path, ForwardRef('Image'), bytearray, memoryview]"},{name:"model",val:": typing.Optional[str] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"function_to_apply",val:": typing.Optional[ForwardRef('AudioClassificationOutputTransform')] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.audio_classification.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content to classify. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.InferenceClient.audio_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for audio classification. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio classification will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.audio_classification.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When specified, limits the output to the top K most probable classes.`,name:"top_k"},{anchor:"huggingface_hub.InferenceClient.audio_classification.function_to_apply",description:`<strong>function_to_apply</strong> (<code>&quot;AudioClassificationOutputTransform&quot;</code>, <em>optional</em>) &#x2014;
The function to apply to the model outputs in order to retrieve the scores.`,name:"function_to_apply"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L285",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.AudioClassificationOutputElement"
>AudioClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),lt=new w({props:{anchor:"huggingface_hub.InferenceClient.audio_classification.example",$$slots:{default:[hf]},$$scope:{ctx:_}}}),_a=new A({props:{name:"audio_to_audio",anchor:"huggingface_hub.InferenceClient.audio_to_audio",parameters:[{name:"audio",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path, ForwardRef('Image'), bytearray, memoryview]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.audio_to_audio.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content for the model. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.InferenceClient.audio_to_audio.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model can be any model which takes an audio file and returns another audio file. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio_to_audio will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L342",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.AudioToAudioOutputElement"
>AudioToAudioOutputElement</a> items containing audios label, content-type, and audio content in blob.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioToAudioOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>HTTPError</code></p>
`}}),ot=new w({props:{anchor:"huggingface_hub.InferenceClient.audio_to_audio.example",$$slots:{default:[df]},$$scope:{ctx:_}}}),Ia=new A({props:{name:"automatic_speech_recognition",anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition",parameters:[{name:"audio",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path, ForwardRef('Image'), bytearray, memoryview]"},{name:"model",val:": typing.Optional[str] = None"},{name:"extra_body",val:": typing.Optional[typing.Dict] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The content to transcribe. It can be raw audio bytes, local audio file, or a URL to an audio file.`,name:"audio"},{anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for ASR. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for ASR will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition.extra_body",description:`<strong>extra_body</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Additional provider-specific parameters to pass to the model. Refer to the provider&#x2019;s documentation
for supported parameters.`,name:"extra_body"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L394",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An item containing the transcribed text and optionally the timestamp chunks.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.AutomaticSpeechRecognitionOutput"
>AutomaticSpeechRecognitionOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),it=new w({props:{anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition.example",$$slots:{default:[ff]},$$scope:{ctx:_}}}),Ta=new A({props:{name:"chat_completion",anchor:"huggingface_hub.InferenceClient.chat_completion",parameters:[{name:"messages",val:": typing.List[typing.Union[typing.Dict, huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputMessage]]"},{name:"model",val:": typing.Optional[str] = None"},{name:"stream",val:": bool = False"},{name:"frequency_penalty",val:": typing.Optional[float] = None"},{name:"logit_bias",val:": typing.Optional[typing.List[float]] = None"},{name:"logprobs",val:": typing.Optional[bool] = None"},{name:"max_tokens",val:": typing.Optional[int] = None"},{name:"n",val:": typing.Optional[int] = None"},{name:"presence_penalty",val:": typing.Optional[float] = None"},{name:"response_format",val:": typing.Union[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputResponseFormatText, huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputResponseFormatJSONSchema, huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputResponseFormatJSONObject, NoneType] = None"},{name:"seed",val:": typing.Optional[int] = None"},{name:"stop",val:": typing.Optional[typing.List[str]] = None"},{name:"stream_options",val:": typing.Optional[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputStreamOptions] = None"},{name:"temperature",val:": typing.Optional[float] = None"},{name:"tool_choice",val:": typing.Union[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputToolChoiceClass, ForwardRef('ChatCompletionInputToolChoiceEnum'), NoneType] = None"},{name:"tool_prompt",val:": typing.Optional[str] = None"},{name:"tools",val:": typing.Optional[typing.List[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputTool]] = None"},{name:"top_logprobs",val:": typing.Optional[int] = None"},{name:"top_p",val:": typing.Optional[float] = None"},{name:"extra_body",val:": typing.Optional[typing.Dict] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.chat_completion.messages",description:`<strong>messages</strong> (List of <a href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionInputMessage">ChatCompletionInputMessage</a>) &#x2014;
Conversation history consisting of roles and content pairs.`,name:"messages"},{anchor:"huggingface_hub.InferenceClient.chat_completion.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for chat-completion. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for chat-based text-generation will be used.
See <a href="https://huggingface.co/tasks/text-generation" rel="nofollow">https://huggingface.co/tasks/text-generation</a> for more details.
If <code>model</code> is a model ID, it is passed to the server as the <code>model</code> parameter. If you want to define a
custom URL while setting <code>model</code> in the request payload, you must set <code>base_url</code> when initializing <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.chat_completion.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Penalizes new tokens based on their existing frequency
in the text so far. Range: [-2.0, 2.0]. Defaults to 0.0.`,name:"frequency_penalty"},{anchor:"huggingface_hub.InferenceClient.chat_completion.logit_bias",description:`<strong>logit_bias</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Adjusts the likelihood of specific tokens appearing in the generated output.`,name:"logit_bias"},{anchor:"huggingface_hub.InferenceClient.chat_completion.logprobs",description:`<strong>logprobs</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return log probabilities of the output tokens or not. If true, returns the log
probabilities of each output token returned in the content of message.`,name:"logprobs"},{anchor:"huggingface_hub.InferenceClient.chat_completion.max_tokens",description:`<strong>max_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of tokens allowed in the response. Defaults to 100.`,name:"max_tokens"},{anchor:"huggingface_hub.InferenceClient.chat_completion.n",description:`<strong>n</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of completions to generate for each prompt.`,name:"n"},{anchor:"huggingface_hub.InferenceClient.chat_completion.presence_penalty",description:`<strong>presence_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the
text so far, increasing the model&#x2019;s likelihood to talk about new topics.`,name:"presence_penalty"},{anchor:"huggingface_hub.InferenceClient.chat_completion.response_format",description:`<strong>response_format</strong> (<code>ChatCompletionInputGrammarType()</code>, <em>optional</em>) &#x2014;
Grammar constraints. Can be either a JSONSchema or a regex.`,name:"response_format"},{anchor:"huggingface_hub.InferenceClient.chat_completion.seed",description:`<strong>seed</strong> (Optional<code>int</code>, <em>optional</em>) &#x2014;
Seed for reproducible control flow. Defaults to None.`,name:"seed"},{anchor:"huggingface_hub.InferenceClient.chat_completion.stop",description:`<strong>stop</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Up to four strings which trigger the end of the response.
Defaults to None.`,name:"stop"},{anchor:"huggingface_hub.InferenceClient.chat_completion.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Enable realtime streaming of responses. Defaults to False.`,name:"stream"},{anchor:"huggingface_hub.InferenceClient.chat_completion.stream_options",description:`<strong>stream_options</strong> (<a href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionInputStreamOptions">ChatCompletionInputStreamOptions</a>, <em>optional</em>) &#x2014;
Options for streaming completions.`,name:"stream_options"},{anchor:"huggingface_hub.InferenceClient.chat_completion.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Controls randomness of the generations. Lower values ensure
less random completions. Range: [0, 2]. Defaults to 1.0.`,name:"temperature"},{anchor:"huggingface_hub.InferenceClient.chat_completion.top_logprobs",description:`<strong>top_logprobs</strong> (<code>int</code>, <em>optional</em>) &#x2014;
An integer between 0 and 5 specifying the number of most likely tokens to return at each token
position, each with an associated log probability. logprobs must be set to true if this parameter is
used.`,name:"top_logprobs"},{anchor:"huggingface_hub.InferenceClient.chat_completion.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Fraction of the most likely next words to sample from.
Must be between 0 and 1. Defaults to 1.0.`,name:"top_p"},{anchor:"huggingface_hub.InferenceClient.chat_completion.tool_choice",description:`<strong>tool_choice</strong> (<a href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionInputToolChoiceClass">ChatCompletionInputToolChoiceClass</a> or <code>ChatCompletionInputToolChoiceEnum()</code>, <em>optional</em>) &#x2014;
The tool to use for the completion. Defaults to &#x201C;auto&#x201D;.`,name:"tool_choice"},{anchor:"huggingface_hub.InferenceClient.chat_completion.tool_prompt",description:`<strong>tool_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A prompt to be appended before the tools.`,name:"tool_prompt"},{anchor:"huggingface_hub.InferenceClient.chat_completion.tools",description:`<strong>tools</strong> (List of <a href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionInputTool">ChatCompletionInputTool</a>, <em>optional</em>) &#x2014;
A list of tools the model may call. Currently, only functions are supported as a tool. Use this to
provide a list of functions the model may generate JSON inputs for.`,name:"tools"},{anchor:"huggingface_hub.InferenceClient.chat_completion.extra_body",description:`<strong>extra_body</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Additional provider-specific parameters to pass to the model. Refer to the provider&#x2019;s documentation
for supported parameters.`,name:"extra_body"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L520",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code>, the generated text is returned as a <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> (default).</li>
<li>if <code>stream=True</code>, the generated text is returned token by token as a sequence of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> or Iterable of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),rt=new H({props:{$$slots:{default:[yf]},$$scope:{ctx:_}}}),ct=new H({props:{$$slots:{default:[Mf]},$$scope:{ctx:_}}}),pt=new w({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example",$$slots:{default:[bf]},$$scope:{ctx:_}}}),gt=new w({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-2",$$slots:{default:[jf]},$$scope:{ctx:_}}}),ut=new w({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-3",$$slots:{default:[_f]},$$scope:{ctx:_}}}),mt=new w({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-4",$$slots:{default:[If]},$$scope:{ctx:_}}}),ht=new w({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-5",$$slots:{default:[Tf]},$$scope:{ctx:_}}}),dt=new w({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-6",$$slots:{default:[Jf]},$$scope:{ctx:_}}}),ft=new w({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-7",$$slots:{default:[Uf]},$$scope:{ctx:_}}}),yt=new w({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-8",$$slots:{default:[wf]},$$scope:{ctx:_}}}),Ja=new A({props:{name:"document_question_answering",anchor:"huggingface_hub.InferenceClient.document_question_answering",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path, ForwardRef('Image'), bytearray, memoryview]"},{name:"question",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"doc_stride",val:": typing.Optional[int] = None"},{name:"handle_impossible_answer",val:": typing.Optional[bool] = None"},{name:"lang",val:": typing.Optional[str] = None"},{name:"max_answer_len",val:": typing.Optional[int] = None"},{name:"max_question_len",val:": typing.Optional[int] = None"},{name:"max_seq_len",val:": typing.Optional[int] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"word_boxes",val:": typing.Optional[typing.List[typing.Union[typing.List[float], str]]] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.document_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the document question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended document question answering model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.doc_stride",description:`<strong>doc_stride</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If the words in the document are too long to fit with the question for the model, it will be split in
several chunks with some overlap. This argument controls the size of that overlap.`,name:"doc_stride"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.handle_impossible_answer",description:`<strong>handle_impossible_answer</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to accept impossible as an answer`,name:"handle_impossible_answer"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.lang",description:`<strong>lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Language to use while running OCR. Defaults to english.`,name:"lang"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.max_answer_len",description:`<strong>max_answer_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of predicted answers (e.g., only answers with a shorter length are considered).`,name:"max_answer_len"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.max_question_len",description:`<strong>max_question_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the question after tokenization. It will be truncated if needed.`,name:"max_question_len"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.max_seq_len",description:`<strong>max_seq_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the total sentence (context + question) in tokens of each chunk passed to the
model. The context will be split in several chunks (using doc_stride as overlap) if needed.`,name:"max_seq_len"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of answers to return (will be chosen by order of likelihood). Can return less than top_k
answers if there are not enough options available within the context.`,name:"top_k"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.word_boxes",description:`<strong>word_boxes</strong> (<code>List[Union[List[float], str</code>, <em>optional</em>) &#x2014;
A list of words and bounding boxes (normalized 0-&gt;1000). If provided, the inference will skip the OCR
step and use the provided bounding boxes instead.`,name:"word_boxes"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L926",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.DocumentQuestionAnsweringOutputElement"
>DocumentQuestionAnsweringOutputElement</a> items containing the predicted label, associated probability, word ids, and page number.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[DocumentQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Mt=new w({props:{anchor:"huggingface_hub.InferenceClient.document_question_answering.example",$$slots:{default:[Cf]},$$scope:{ctx:_}}}),Ua=new A({props:{name:"feature_extraction",anchor:"huggingface_hub.InferenceClient.feature_extraction",parameters:[{name:"text",val:": str"},{name:"normalize",val:": typing.Optional[bool] = None"},{name:"prompt_name",val:": typing.Optional[str] = None"},{name:"truncate",val:": typing.Optional[bool] = None"},{name:"truncation_direction",val:": typing.Optional[typing.Literal['Left', 'Right']] = None"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.feature_extraction.text",description:`<strong>text</strong> (<em>str</em>) &#x2014;
The text to embed.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.model",description:`<strong>model</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The model to use for the feature extraction task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended feature extraction model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.normalize",description:`<strong>normalize</strong> (<em>bool</em>, <em>optional</em>) &#x2014;
Whether to normalize the embeddings or not.
Only available on server powered by Text-Embedding-Inference.`,name:"normalize"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.prompt_name",description:`<strong>prompt_name</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The name of the prompt that should be used by for encoding. If not set, no prompt will be applied.
Must be a key in the <em>Sentence Transformers</em> configuration <em>prompts</em> dictionary.
For example if <code>prompt_name</code> is &#x201C;query&#x201D; and the <code>prompts</code> is {&#x201C;query&#x201D;: &#x201C;query: &#x201D;,&#x2026;},
then the sentence &#x201C;What is the capital of France?&#x201D; will be encoded as &#x201C;query: What is the capital of France?&#x201D;
because the prompt text will be prepended before any text to encode.`,name:"prompt_name"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.truncate",description:`<strong>truncate</strong> (<em>bool</em>, <em>optional</em>) &#x2014;
Whether to truncate the embeddings or not.
Only available on server powered by Text-Embedding-Inference.`,name:"truncate"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.truncation_direction",description:`<strong>truncation_direction</strong> (<em>Literal[&#x201C;Left&#x201D;, &#x201C;Right&#x201D;]</em>, <em>optional</em>) &#x2014;
Which side of the input should be truncated when <em>truncate=True</em> is passed.`,name:"truncation_direction"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1013",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text as a float32 numpy array.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><em>np.ndarray</em></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>[<em>InferenceTimeoutError</em>] —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>[<em>InferenceTimeoutError</em>] or <code>HTTPError</code></p>
`}}),bt=new w({props:{anchor:"huggingface_hub.InferenceClient.feature_extraction.example",$$slots:{default:[xf]},$$scope:{ctx:_}}}),wa=new A({props:{name:"fill_mask",anchor:"huggingface_hub.InferenceClient.fill_mask",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"targets",val:": typing.Optional[typing.List[str]] = None"},{name:"top_k",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.fill_mask.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
a string to be filled from, must contain the [MASK] token (check model card for exact name of the mask).`,name:"text"},{anchor:"huggingface_hub.InferenceClient.fill_mask.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the fill mask task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended fill mask model will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.fill_mask.targets",description:`<strong>targets</strong> (<code>List[str</code>, <em>optional</em>) &#x2014;
When passed, the model will limit the scores to the passed targets instead of looking up in the whole
vocabulary. If the provided targets are not in the model vocab, they will be tokenized and the first
resulting token will be used (with a warning, and that might be slower).`,name:"targets"},{anchor:"huggingface_hub.InferenceClient.fill_mask.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When passed, overrides the number of predictions to return.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1086",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.FillMaskOutputElement"
>FillMaskOutputElement</a> items containing the predicted label, associated
probability, token reference, and completed text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[FillMaskOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),jt=new w({props:{anchor:"huggingface_hub.InferenceClient.fill_mask.example",$$slots:{default:[$f]},$$scope:{ctx:_}}}),Ca=new A({props:{name:"get_endpoint_info",anchor:"huggingface_hub.InferenceClient.get_endpoint_info",parameters:[{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.get_endpoint_info.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L3272",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Information about the endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),_t=new w({props:{anchor:"huggingface_hub.InferenceClient.get_endpoint_info.example",$$slots:{default:[vf]},$$scope:{ctx:_}}}),xa=new A({props:{name:"health_check",anchor:"huggingface_hub.InferenceClient.health_check",parameters:[{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.health_check.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
URL of the Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L3330",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if everything is working fine.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),It=new w({props:{anchor:"huggingface_hub.InferenceClient.health_check.example",$$slots:{default:[kf]},$$scope:{ctx:_}}}),$a=new A({props:{name:"image_classification",anchor:"huggingface_hub.InferenceClient.image_classification",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path, ForwardRef('Image'), bytearray, memoryview]"},{name:"model",val:": typing.Optional[str] = None"},{name:"function_to_apply",val:": typing.Optional[ForwardRef('ImageClassificationOutputTransform')] = None"},{name:"top_k",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO, PIL.Image.Image]</code>) &#x2014;
The image to classify. It can be raw bytes, an image file, a URL to an online image, or a PIL Image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image classification. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image classification will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.image_classification.function_to_apply",description:`<strong>function_to_apply</strong> (<code>&quot;ImageClassificationOutputTransform&quot;</code>, <em>optional</em>) &#x2014;
The function to apply to the model outputs in order to retrieve the scores.`,name:"function_to_apply"},{anchor:"huggingface_hub.InferenceClient.image_classification.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When specified, limits the output to the top K most probable classes.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1142",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ImageClassificationOutputElement"
>ImageClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Tt=new w({props:{anchor:"huggingface_hub.InferenceClient.image_classification.example",$$slots:{default:[qf]},$$scope:{ctx:_}}}),va=new A({props:{name:"image_segmentation",anchor:"huggingface_hub.InferenceClient.image_segmentation",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path, ForwardRef('Image'), bytearray, memoryview]"},{name:"model",val:": typing.Optional[str] = None"},{name:"mask_threshold",val:": typing.Optional[float] = None"},{name:"overlap_mask_area_threshold",val:": typing.Optional[float] = None"},{name:"subtask",val:": typing.Optional[ForwardRef('ImageSegmentationSubtask')] = None"},{name:"threshold",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_segmentation.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO, PIL.Image.Image]</code>) &#x2014;
The image to segment. It can be raw bytes, an image file, a URL to an online image, or a PIL Image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_segmentation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image segmentation. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image segmentation will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.image_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"huggingface_hub.InferenceClient.image_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Mask overlap threshold to eliminate small, disconnected segments.`,name:"overlap_mask_area_threshold"},{anchor:"huggingface_hub.InferenceClient.image_segmentation.subtask",description:`<strong>subtask</strong> (<code>&quot;ImageSegmentationSubtask&quot;</code>, <em>optional</em>) &#x2014;
Segmentation task to be performed, depending on model capabilities.`,name:"subtask"},{anchor:"huggingface_hub.InferenceClient.image_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Probability threshold to filter out predicted masks.`,name:"threshold"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1192",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ImageSegmentationOutputElement"
>ImageSegmentationOutputElement</a> items containing the segmented masks and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageSegmentationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Jt=new H({props:{warning:!0,$$slots:{default:[Af]},$$scope:{ctx:_}}}),Ut=new w({props:{anchor:"huggingface_hub.InferenceClient.image_segmentation.example",$$slots:{default:[Zf]},$$scope:{ctx:_}}}),ka=new A({props:{name:"image_to_image",anchor:"huggingface_hub.InferenceClient.image_to_image",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path, ForwardRef('Image'), bytearray, memoryview]"},{name:"prompt",val:": typing.Optional[str] = None"},{name:"negative_prompt",val:": typing.Optional[str] = None"},{name:"num_inference_steps",val:": typing.Optional[int] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"model",val:": typing.Optional[str] = None"},{name:"target_size",val:": typing.Optional[huggingface_hub.inference._generated.types.image_to_image.ImageToImageTargetSize] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_to_image.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO, PIL.Image.Image]</code>) &#x2014;
The input image for translation. It can be raw bytes, an image file, a URL to an online image, or a PIL Image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The text prompt to guide the image generation.`,name:"prompt"},{anchor:"huggingface_hub.InferenceClient.image_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
One prompt to guide what NOT to include in image generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.InferenceClient.image_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
For diffusion models. The number of denoising steps. More denoising steps usually lead to a higher
quality image at the expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.InferenceClient.image_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
For diffusion models. A higher guidance scale value encourages the model to generate images closely
linked to the text prompt at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"huggingface_hub.InferenceClient.image_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.image_to_image.target_size",description:`<strong>target_size</strong> (<code>ImageToImageTargetSize</code>, <em>optional</em>) &#x2014;
The size in pixel of the output image.`,name:"target_size"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1262",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The translated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),wt=new H({props:{warning:!0,$$slots:{default:[Ef]},$$scope:{ctx:_}}}),Ct=new w({props:{anchor:"huggingface_hub.InferenceClient.image_to_image.example",$$slots:{default:[Wf]},$$scope:{ctx:_}}}),qa=new A({props:{name:"image_to_text",anchor:"huggingface_hub.InferenceClient.image_to_text",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path, ForwardRef('Image'), bytearray, memoryview]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_to_text.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO, PIL.Image.Image]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, a URL to an online image, or a PIL Image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_to_text.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1418",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ImageToTextOutput"
>ImageToTextOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),xt=new w({props:{anchor:"huggingface_hub.InferenceClient.image_to_text.example",$$slots:{default:[Nf]},$$scope:{ctx:_}}}),Aa=new A({props:{name:"image_to_video",anchor:"huggingface_hub.InferenceClient.image_to_video",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path, ForwardRef('Image'), bytearray, memoryview]"},{name:"model",val:": typing.Optional[str] = None"},{name:"prompt",val:": typing.Optional[str] = None"},{name:"negative_prompt",val:": typing.Optional[str] = None"},{name:"num_frames",val:": typing.Optional[float] = None"},{name:"num_inference_steps",val:": typing.Optional[int] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"seed",val:": typing.Optional[int] = None"},{name:"target_size",val:": typing.Optional[huggingface_hub.inference._generated.types.image_to_video.ImageToVideoTargetSize] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_to_video.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO, PIL.Image.Image]</code>) &#x2014;
The input image to generate a video from. It can be raw bytes, an image file, a URL to an online image, or a PIL Image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_to_video.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.image_to_video.prompt",description:`<strong>prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The text prompt to guide the video generation.`,name:"prompt"},{anchor:"huggingface_hub.InferenceClient.image_to_video.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
One prompt to guide what NOT to include in video generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.InferenceClient.image_to_video.num_frames",description:`<strong>num_frames</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The num_frames parameter determines how many video frames are generated.`,name:"num_frames"},{anchor:"huggingface_hub.InferenceClient.image_to_video.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
For diffusion models. The number of denoising steps. More denoising steps usually lead to a higher
quality image at the expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.InferenceClient.image_to_video.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
For diffusion models. A higher guidance scale value encourages the model to generate videos closely
linked to the text prompt at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"huggingface_hub.InferenceClient.image_to_video.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The seed to use for the video generation.`,name:"seed"},{anchor:"huggingface_hub.InferenceClient.image_to_video.target_size",description:`<strong>target_size</strong> (<code>ImageToVideoTargetSize</code>, <em>optional</em>) &#x2014;
The size in pixel of the output video frames.`,name:"target_size"},{anchor:"huggingface_hub.InferenceClient.image_to_video.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality video at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.InferenceClient.image_to_video.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Seed for the random number generator.`,name:"seed"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1339",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated video.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bytes</code></p>
`}}),$t=new w({props:{anchor:"huggingface_hub.InferenceClient.image_to_video.example",$$slots:{default:[Gf]},$$scope:{ctx:_}}}),Za=new A({props:{name:"object_detection",anchor:"huggingface_hub.InferenceClient.object_detection",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path, ForwardRef('Image'), bytearray, memoryview]"},{name:"model",val:": typing.Optional[str] = None"},{name:"threshold",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.object_detection.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO, PIL.Image.Image]</code>) &#x2014;
The image to detect objects on. It can be raw bytes, an image file, a URL to an online image, or a PIL Image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.object_detection.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for object detection. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for object detection (DETR) will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The probability necessary to make a prediction.`,name:"threshold"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1464",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ObjectDetectionOutputElement"
>ObjectDetectionOutputElement</a> items containing the bounding boxes and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ObjectDetectionOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If the request output is not a List.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code> or <code>ValueError</code></p>
`}}),vt=new H({props:{warning:!0,$$slots:{default:[Bf]},$$scope:{ctx:_}}}),kt=new w({props:{anchor:"huggingface_hub.InferenceClient.object_detection.example",$$slots:{default:[Vf]},$$scope:{ctx:_}}}),Ea=new A({props:{name:"question_answering",anchor:"huggingface_hub.InferenceClient.question_answering",parameters:[{name:"question",val:": str"},{name:"context",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"align_to_words",val:": typing.Optional[bool] = None"},{name:"doc_stride",val:": typing.Optional[int] = None"},{name:"handle_impossible_answer",val:": typing.Optional[bool] = None"},{name:"max_answer_len",val:": typing.Optional[int] = None"},{name:"max_question_len",val:": typing.Optional[int] = None"},{name:"max_seq_len",val:": typing.Optional[int] = None"},{name:"top_k",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.InferenceClient.question_answering.context",description:`<strong>context</strong> (<code>str</code>) &#x2014;
The context of the question.`,name:"context"},{anchor:"huggingface_hub.InferenceClient.question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.question_answering.align_to_words",description:`<strong>align_to_words</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Attempts to align the answer to real words. Improves quality on space separated languages. Might hurt
on non-space-separated languages (like Japanese or Chinese)`,name:"align_to_words"},{anchor:"huggingface_hub.InferenceClient.question_answering.doc_stride",description:`<strong>doc_stride</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If the context is too long to fit with the question for the model, it will be split in several chunks
with some overlap. This argument controls the size of that overlap.`,name:"doc_stride"},{anchor:"huggingface_hub.InferenceClient.question_answering.handle_impossible_answer",description:`<strong>handle_impossible_answer</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to accept impossible as an answer.`,name:"handle_impossible_answer"},{anchor:"huggingface_hub.InferenceClient.question_answering.max_answer_len",description:`<strong>max_answer_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of predicted answers (e.g., only answers with a shorter length are considered).`,name:"max_answer_len"},{anchor:"huggingface_hub.InferenceClient.question_answering.max_question_len",description:`<strong>max_question_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the question after tokenization. It will be truncated if needed.`,name:"max_question_len"},{anchor:"huggingface_hub.InferenceClient.question_answering.max_seq_len",description:`<strong>max_seq_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the total sentence (context + question) in tokens of each chunk passed to the
model. The context will be split in several chunks (using docStride as overlap) if needed.`,name:"max_seq_len"},{anchor:"huggingface_hub.InferenceClient.question_answering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of answers to return (will be chosen by order of likelihood). Note that we return less than
topk answers if there are not enough options available within the context.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1515",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>When top_k is 1 or not provided, it returns a single <code>QuestionAnsweringOutputElement</code>.
When top_k is greater than 1, it returns a list of <code>QuestionAnsweringOutputElement</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Union[<code>QuestionAnsweringOutputElement</code>, List<a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.QuestionAnsweringOutputElement"
>QuestionAnsweringOutputElement</a>]</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),qt=new w({props:{anchor:"huggingface_hub.InferenceClient.question_answering.example",$$slots:{default:[Qf]},$$scope:{ctx:_}}}),Wa=new A({props:{name:"sentence_similarity",anchor:"huggingface_hub.InferenceClient.sentence_similarity",parameters:[{name:"sentence",val:": str"},{name:"other_sentences",val:": typing.List[str]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.sentence_similarity.sentence",description:`<strong>sentence</strong> (<code>str</code>) &#x2014;
The main sentence to compare to others.`,name:"sentence"},{anchor:"huggingface_hub.InferenceClient.sentence_similarity.other_sentences",description:`<strong>other_sentences</strong> (<code>List[str]</code>) &#x2014;
The list of sentences to compare to.`,name:"other_sentences"},{anchor:"huggingface_hub.InferenceClient.sentence_similarity.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the sentence similarity task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended sentence similarity model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1599",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[float]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),At=new w({props:{anchor:"huggingface_hub.InferenceClient.sentence_similarity.example",$$slots:{default:[Sf]},$$scope:{ctx:_}}}),Na=new A({props:{name:"summarization",anchor:"huggingface_hub.InferenceClient.summarization",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"clean_up_tokenization_spaces",val:": typing.Optional[bool] = None"},{name:"generate_parameters",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"truncation",val:": typing.Optional[ForwardRef('SummarizationTruncationStrategy')] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.summarization.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to summarize.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.summarization.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for summarization will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.summarization.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to clean up the potential extra spaces in the text output.`,name:"clean_up_tokenization_spaces"},{anchor:"huggingface_hub.InferenceClient.summarization.generate_parameters",description:`<strong>generate_parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parametrization of the text generation algorithm.`,name:"generate_parameters"},{anchor:"huggingface_hub.InferenceClient.summarization.truncation",description:`<strong>truncation</strong> (<code>&quot;SummarizationTruncationStrategy&quot;</code>, <em>optional</em>) &#x2014;
The truncation strategy to use.`,name:"truncation"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1652",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated summary text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.SummarizationOutput"
>SummarizationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Zt=new w({props:{anchor:"huggingface_hub.InferenceClient.summarization.example",$$slots:{default:[Yf]},$$scope:{ctx:_}}}),Ga=new A({props:{name:"table_question_answering",anchor:"huggingface_hub.InferenceClient.table_question_answering",parameters:[{name:"table",val:": typing.Dict[str, typing.Any]"},{name:"query",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"padding",val:": typing.Optional[ForwardRef('Padding')] = None"},{name:"sequential",val:": typing.Optional[bool] = None"},{name:"truncation",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.table_question_answering.table",description:`<strong>table</strong> (<code>str</code>) &#x2014;
A table of data represented as a dict of lists where entries are headers and the lists are all the
values, all lists must have the same size.`,name:"table"},{anchor:"huggingface_hub.InferenceClient.table_question_answering.query",description:`<strong>query</strong> (<code>str</code>) &#x2014;
The query in plain text that you want to ask the table.`,name:"query"},{anchor:"huggingface_hub.InferenceClient.table_question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the table-question-answering task. Can be a model ID hosted on the Hugging Face
Hub or a URL to a deployed Inference Endpoint.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.table_question_answering.padding",description:`<strong>padding</strong> (<code>&quot;Padding&quot;</code>, <em>optional</em>) &#x2014;
Activates and controls padding.`,name:"padding"},{anchor:"huggingface_hub.InferenceClient.table_question_answering.sequential",description:`<strong>sequential</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to do inference sequentially or as a batch. Batching is faster, but models like SQA require the
inference to be done sequentially to extract relations within sequences, given their conversational
nature.`,name:"sequential"},{anchor:"huggingface_hub.InferenceClient.table_question_answering.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Activates and controls truncation.`,name:"truncation"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1710",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a table question answering output containing the answer, coordinates, cells and the aggregator used.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TableQuestionAnsweringOutputElement"
>TableQuestionAnsweringOutputElement</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Et=new w({props:{anchor:"huggingface_hub.InferenceClient.table_question_answering.example",$$slots:{default:[Rf]},$$scope:{ctx:_}}}),Ba=new A({props:{name:"tabular_classification",anchor:"huggingface_hub.InferenceClient.tabular_classification",parameters:[{name:"table",val:": typing.Dict[str, typing.Any]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.tabular_classification.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes to classify.`,name:"table"},{anchor:"huggingface_hub.InferenceClient.tabular_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1772",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of labels, one per row in the initial table.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Wt=new w({props:{anchor:"huggingface_hub.InferenceClient.tabular_classification.example",$$slots:{default:[Xf]},$$scope:{ctx:_}}}),Va=new A({props:{name:"tabular_regression",anchor:"huggingface_hub.InferenceClient.tabular_regression",parameters:[{name:"table",val:": typing.Dict[str, typing.Any]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.tabular_regression.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes stored in a table. The attributes used to predict the target can be both numerical and categorical.`,name:"table"},{anchor:"huggingface_hub.InferenceClient.tabular_regression.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular regression task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular regression model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1827",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of predicted numerical target values.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Nt=new w({props:{anchor:"huggingface_hub.InferenceClient.tabular_regression.example",$$slots:{default:[zf]},$$scope:{ctx:_}}}),Qa=new A({props:{name:"text_classification",anchor:"huggingface_hub.InferenceClient.text_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"function_to_apply",val:": typing.Optional[ForwardRef('TextClassificationOutputTransform')] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.text_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the text classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended text classification model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.text_classification.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When specified, limits the output to the top K most probable classes.`,name:"top_k"},{anchor:"huggingface_hub.InferenceClient.text_classification.function_to_apply",description:`<strong>function_to_apply</strong> (<code>&quot;TextClassificationOutputTransform&quot;</code>, <em>optional</em>) &#x2014;
The function to apply to the model outputs in order to retrieve the scores.`,name:"function_to_apply"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1877",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TextClassificationOutputElement"
>TextClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TextClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Gt=new w({props:{anchor:"huggingface_hub.InferenceClient.text_classification.example",$$slots:{default:[Ff]},$$scope:{ctx:_}}}),Sa=new A({props:{name:"text_generation",anchor:"huggingface_hub.InferenceClient.text_generation",parameters:[{name:"prompt",val:": str"},{name:"details",val:": typing.Optional[bool] = None"},{name:"stream",val:": typing.Optional[bool] = None"},{name:"model",val:": typing.Optional[str] = None"},{name:"adapter_id",val:": typing.Optional[str] = None"},{name:"best_of",val:": typing.Optional[int] = None"},{name:"decoder_input_details",val:": typing.Optional[bool] = None"},{name:"do_sample",val:": typing.Optional[bool] = None"},{name:"frequency_penalty",val:": typing.Optional[float] = None"},{name:"grammar",val:": typing.Optional[huggingface_hub.inference._generated.types.text_generation.TextGenerationInputGrammarType] = None"},{name:"max_new_tokens",val:": typing.Optional[int] = None"},{name:"repetition_penalty",val:": typing.Optional[float] = None"},{name:"return_full_text",val:": typing.Optional[bool] = None"},{name:"seed",val:": typing.Optional[int] = None"},{name:"stop",val:": typing.Optional[typing.List[str]] = None"},{name:"stop_sequences",val:": typing.Optional[typing.List[str]] = None"},{name:"temperature",val:": typing.Optional[float] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"top_n_tokens",val:": typing.Optional[int] = None"},{name:"top_p",val:": typing.Optional[float] = None"},{name:"truncate",val:": typing.Optional[int] = None"},{name:"typical_p",val:": typing.Optional[float] = None"},{name:"watermark",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_generation.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
Input text.`,name:"prompt"},{anchor:"huggingface_hub.InferenceClient.text_generation.details",description:`<strong>details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns a string. Pass <code>details=True</code> if you want a detailed output (tokens,
probabilities, seed, finish reason, etc.). Only available for models running on with the
<code>text-generation-inference</code> backend.`,name:"details"},{anchor:"huggingface_hub.InferenceClient.text_generation.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns the full generated text. Pass <code>stream=True</code> if you want a stream of
tokens to be returned. Only available for models running on with the <code>text-generation-inference</code>
backend.`,name:"stream"},{anchor:"huggingface_hub.InferenceClient.text_generation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.text_generation.adapter_id",description:`<strong>adapter_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Lora adapter id.`,name:"adapter_id"},{anchor:"huggingface_hub.InferenceClient.text_generation.best_of",description:`<strong>best_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Generate best_of sequences and return the one if the highest token logprobs.`,name:"best_of"},{anchor:"huggingface_hub.InferenceClient.text_generation.decoder_input_details",description:`<strong>decoder_input_details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Return the decoder input token logprobs and ids. You must set <code>details=True</code> as well for it to be taken
into account. Defaults to <code>False</code>.`,name:"decoder_input_details"},{anchor:"huggingface_hub.InferenceClient.text_generation.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Activate logits sampling`,name:"do_sample"},{anchor:"huggingface_hub.InferenceClient.text_generation.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in
the text so far, decreasing the model&#x2019;s likelihood to repeat the same line verbatim.`,name:"frequency_penalty"},{anchor:"huggingface_hub.InferenceClient.text_generation.grammar",description:`<strong>grammar</strong> (<a href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TextGenerationInputGrammarType">TextGenerationInputGrammarType</a>, <em>optional</em>) &#x2014;
Grammar constraints. Can be either a JSONSchema or a regex.`,name:"grammar"},{anchor:"huggingface_hub.InferenceClient.text_generation.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of generated tokens. Defaults to 100.`,name:"max_new_tokens"},{anchor:"huggingface_hub.InferenceClient.text_generation.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"},{anchor:"huggingface_hub.InferenceClient.text_generation.return_full_text",description:`<strong>return_full_text</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to prepend the prompt to the generated text`,name:"return_full_text"},{anchor:"huggingface_hub.InferenceClient.text_generation.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Random sampling seed`,name:"seed"},{anchor:"huggingface_hub.InferenceClient.text_generation.stop",description:`<strong>stop</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Stop generating tokens if a member of <code>stop</code> is generated.`,name:"stop"},{anchor:"huggingface_hub.InferenceClient.text_generation.stop_sequences",description:`<strong>stop_sequences</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Deprecated argument. Use <code>stop</code> instead.`,name:"stop_sequences"},{anchor:"huggingface_hub.InferenceClient.text_generation.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"},{anchor:"huggingface_hub.InferenceClient.text_generation.top_n_tokens",description:`<strong>top_n_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Return information about the <code>top_n_tokens</code> most likely tokens at each generation step, instead of
just the sampled token.`,name:"top_n_tokens"},{anchor:"huggingface_hub.InferenceClient.text_generation.top_k",description:"<strong>top_k</strong> (<code>int</code>, *optional`) &#x2014;\nThe number of highest probability vocabulary tokens to keep for top-k-filtering.",name:"top_k"},{anchor:"huggingface_hub.InferenceClient.text_generation.top_p",description:"<strong>top_p</strong> (<code>float</code>, *optional<code>) -- If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to </code>top_p` or\nhigher are kept for generation.",name:"top_p"},{anchor:"huggingface_hub.InferenceClient.text_generation.truncate",description:"<strong>truncate</strong> (<code>int</code>, *optional`) &#x2014;\nTruncate inputs tokens to the given size.",name:"truncate"},{anchor:"huggingface_hub.InferenceClient.text_generation.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, *optional\`) &#x2014;
Typical Decoding mass
See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language Generation</a> for more information`,name:"typical_p"},{anchor:"huggingface_hub.InferenceClient.text_generation.watermark",description:`<strong>watermark</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Watermarking with <a href="https://arxiv.org/abs/2301.10226" rel="nofollow">A Watermark for Large Language Models</a>`,name:"watermark"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2085",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code> and <code>details=False</code>, the generated text is returned as a <code>str</code> (default)</li>
<li>if <code>stream=True</code> and <code>details=False</code>, the generated text is returned token by token as a <code>Iterable[str]</code></li>
<li>if <code>stream=False</code> and <code>details=True</code>, the generated text is returned with more details as a <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TextGenerationOutput"
>TextGenerationOutput</a></li>
<li>if <code>details=True</code> and <code>stream=True</code>, the generated text is returned token by token as a iterable of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TextGenerationStreamOutput"
>TextGenerationStreamOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Union[str, TextGenerationOutput, Iterable[str], Iterable[TextGenerationStreamOutput]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValidationError</code> —
If input values are not valid. No HTTP call is made to the server.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValidationError</code> or <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Bt=new H({props:{$$slots:{default:[Hf]},$$scope:{ctx:_}}}),Vt=new w({props:{anchor:"huggingface_hub.InferenceClient.text_generation.example",$$slots:{default:[Of]},$$scope:{ctx:_}}}),Ya=new A({props:{name:"text_to_image",anchor:"huggingface_hub.InferenceClient.text_to_image",parameters:[{name:"prompt",val:": str"},{name:"negative_prompt",val:": typing.Optional[str] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": typing.Optional[int] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"model",val:": typing.Optional[str] = None"},{name:"scheduler",val:": typing.Optional[str] = None"},{name:"seed",val:": typing.Optional[int] = None"},{name:"extra_body",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
The prompt to generate an image from.`,name:"prompt"},{anchor:"huggingface_hub.InferenceClient.text_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
One prompt to guide what NOT to include in image generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.InferenceClient.text_to_image.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The height in pixels of the output image`,name:"height"},{anchor:"huggingface_hub.InferenceClient.text_to_image.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The width in pixels of the output image`,name:"width"},{anchor:"huggingface_hub.InferenceClient.text_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.InferenceClient.text_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
prompt, but values too high may cause saturation and other artifacts.`,name:"guidance_scale"},{anchor:"huggingface_hub.InferenceClient.text_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended text-to-image model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.text_to_image.scheduler",description:`<strong>scheduler</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Override the scheduler with a compatible one.`,name:"scheduler"},{anchor:"huggingface_hub.InferenceClient.text_to_image.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Seed for the random number generator.`,name:"seed"},{anchor:"huggingface_hub.InferenceClient.text_to_image.extra_body",description:`<strong>extra_body</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional provider-specific parameters to pass to the model. Refer to the provider&#x2019;s documentation
for supported parameters.`,name:"extra_body"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2427",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Qt=new H({props:{warning:!0,$$slots:{default:[Df]},$$scope:{ctx:_}}}),St=new H({props:{$$slots:{default:[Lf]},$$scope:{ctx:_}}}),Yt=new w({props:{anchor:"huggingface_hub.InferenceClient.text_to_image.example",$$slots:{default:[Pf]},$$scope:{ctx:_}}}),Rt=new w({props:{anchor:"huggingface_hub.InferenceClient.text_to_image.example-2",$$slots:{default:[Kf]},$$scope:{ctx:_}}}),Xt=new w({props:{anchor:"huggingface_hub.InferenceClient.text_to_image.example-3",$$slots:{default:[ey]},$$scope:{ctx:_}}}),zt=new w({props:{anchor:"huggingface_hub.InferenceClient.text_to_image.example-4",$$slots:{default:[ny]},$$scope:{ctx:_}}}),Ra=new A({props:{name:"text_to_speech",anchor:"huggingface_hub.InferenceClient.text_to_speech",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"do_sample",val:": typing.Optional[bool] = None"},{name:"early_stopping",val:": typing.Union[bool, ForwardRef('TextToSpeechEarlyStoppingEnum'), NoneType] = None"},{name:"epsilon_cutoff",val:": typing.Optional[float] = None"},{name:"eta_cutoff",val:": typing.Optional[float] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"max_new_tokens",val:": typing.Optional[int] = None"},{name:"min_length",val:": typing.Optional[int] = None"},{name:"min_new_tokens",val:": typing.Optional[int] = None"},{name:"num_beam_groups",val:": typing.Optional[int] = None"},{name:"num_beams",val:": typing.Optional[int] = None"},{name:"penalty_alpha",val:": typing.Optional[float] = None"},{name:"temperature",val:": typing.Optional[float] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"top_p",val:": typing.Optional[float] = None"},{name:"typical_p",val:": typing.Optional[float] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"extra_body",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_to_speech.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The text to synthesize.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended text-to-speech model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use sampling instead of greedy decoding when generating new tokens.`,name:"do_sample"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.early_stopping",description:`<strong>early_stopping</strong> (<code>Union[bool, &quot;TextToSpeechEarlyStoppingEnum&quot;]</code>, <em>optional</em>) &#x2014;
Controls the stopping condition for beam-based methods.`,name:"early_stopping"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.epsilon_cutoff",description:`<strong>epsilon_cutoff</strong> (<code>float</code>, <em>optional</em>) &#x2014;
If set to float strictly between 0 and 1, only tokens with a conditional probability greater than
epsilon_cutoff will be sampled. In the paper, suggested values range from 3e-4 to 9e-4, depending on
the size of the model. See <a href="https://hf.co/papers/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more details.`,name:"epsilon_cutoff"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.eta_cutoff",description:`<strong>eta_cutoff</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Eta sampling is a hybrid of locally typical sampling and epsilon sampling. If set to float strictly
between 0 and 1, a token is only considered if it is greater than either eta_cutoff or sqrt(eta_cutoff)<ul>
<li>exp(-entropy(softmax(next_token_logits))). The latter term is intuitively the expected next token
probability, scaled by sqrt(eta_cutoff). In the paper, suggested values range from 3e-4 to 2e-3,
depending on the size of the model. See <a href="https://hf.co/papers/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more details.</li>
</ul>`,name:"eta_cutoff"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length (in tokens) of the generated text, including the input.`,name:"max_length"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum number of tokens to generate. Takes precedence over max_length.`,name:"max_new_tokens"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.min_length",description:`<strong>min_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum length (in tokens) of the generated text, including the input.`,name:"min_length"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum number of tokens to generate. Takes precedence over min_length.`,name:"min_new_tokens"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of groups to divide num_beams into in order to ensure diversity among different groups of beams.
See <a href="https://hf.co/papers/1610.02424" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.num_beams",description:`<strong>num_beams</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of beams to use for beam search.`,name:"num_beams"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.penalty_alpha",description:`<strong>penalty_alpha</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value balances the model confidence and the degeneration penalty in contrastive search decoding.`,name:"penalty_alpha"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value used to modulate the next token probabilities.`,name:"temperature"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
If set to float &lt; 1, only the smallest set of most probable tokens with probabilities that add up to
top_p or higher are kept for generation.`,name:"top_p"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Local typicality measures how similar the conditional probability of predicting a target token next is
to the expected conditional probability of predicting a random token next, given the partial text
already generated. If set to float &lt; 1, the smallest set of the most locally typical tokens with
probabilities that add up to typical_p or higher are kept for generation. See <a href="https://hf.co/papers/2202.00666" rel="nofollow">this
paper</a> for more details.`,name:"typical_p"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the model should use the past last key/values attentions to speed up decoding`,name:"use_cache"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.extra_body",description:`<strong>extra_body</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional provider-specific parameters to pass to the model. Refer to the provider&#x2019;s documentation
for supported parameters.`,name:"extra_body"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2667",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated audio.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bytes</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Ft=new H({props:{$$slots:{default:[ty]},$$scope:{ctx:_}}}),Ht=new w({props:{anchor:"huggingface_hub.InferenceClient.text_to_speech.example",$$slots:{default:[sy]},$$scope:{ctx:_}}}),Ot=new w({props:{anchor:"huggingface_hub.InferenceClient.text_to_speech.example-2",$$slots:{default:[ay]},$$scope:{ctx:_}}}),Dt=new w({props:{anchor:"huggingface_hub.InferenceClient.text_to_speech.example-3",$$slots:{default:[ly]},$$scope:{ctx:_}}}),Lt=new w({props:{anchor:"huggingface_hub.InferenceClient.text_to_speech.example-4",$$slots:{default:[oy]},$$scope:{ctx:_}}}),Pt=new w({props:{anchor:"huggingface_hub.InferenceClient.text_to_speech.example-5",$$slots:{default:[iy]},$$scope:{ctx:_}}}),Xa=new A({props:{name:"text_to_video",anchor:"huggingface_hub.InferenceClient.text_to_video",parameters:[{name:"prompt",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"negative_prompt",val:": typing.Optional[typing.List[str]] = None"},{name:"num_frames",val:": typing.Optional[float] = None"},{name:"num_inference_steps",val:": typing.Optional[int] = None"},{name:"seed",val:": typing.Optional[int] = None"},{name:"extra_body",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_to_video.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
The prompt to generate a video from.`,name:"prompt"},{anchor:"huggingface_hub.InferenceClient.text_to_video.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended text-to-video model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.text_to_video.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A higher guidance scale value encourages the model to generate videos closely linked to the text
prompt, but values too high may cause saturation and other artifacts.`,name:"guidance_scale"},{anchor:"huggingface_hub.InferenceClient.text_to_video.negative_prompt",description:`<strong>negative_prompt</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
One or several prompt to guide what NOT to include in video generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.InferenceClient.text_to_video.num_frames",description:`<strong>num_frames</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The num_frames parameter determines how many video frames are generated.`,name:"num_frames"},{anchor:"huggingface_hub.InferenceClient.text_to_video.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality video at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.InferenceClient.text_to_video.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Seed for the random number generator.`,name:"seed"},{anchor:"huggingface_hub.InferenceClient.text_to_video.extra_body",description:`<strong>extra_body</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional provider-specific parameters to pass to the model. Refer to the provider&#x2019;s documentation
for supported parameters.`,name:"extra_body"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2570",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated video.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bytes</code></p>
`}}),Kt=new H({props:{$$slots:{default:[ry]},$$scope:{ctx:_}}}),es=new w({props:{anchor:"huggingface_hub.InferenceClient.text_to_video.example",$$slots:{default:[cy]},$$scope:{ctx:_}}}),ns=new w({props:{anchor:"huggingface_hub.InferenceClient.text_to_video.example-2",$$slots:{default:[py]},$$scope:{ctx:_}}}),za=new A({props:{name:"token_classification",anchor:"huggingface_hub.InferenceClient.token_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"aggregation_strategy",val:": typing.Optional[ForwardRef('TokenClassificationAggregationStrategy')] = None"},{name:"ignore_labels",val:": typing.Optional[typing.List[str]] = None"},{name:"stride",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.token_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.token_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the token classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended token classification model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.token_classification.aggregation_strategy",description:`<strong>aggregation_strategy</strong> (<code>&quot;TokenClassificationAggregationStrategy&quot;</code>, <em>optional</em>) &#x2014;
The strategy used to fuse tokens based on model predictions`,name:"aggregation_strategy"},{anchor:"huggingface_hub.InferenceClient.token_classification.ignore_labels",description:`<strong>ignore_labels</strong> (<code>List[str</code>, <em>optional</em>) &#x2014;
A list of labels to ignore`,name:"ignore_labels"},{anchor:"huggingface_hub.InferenceClient.token_classification.stride",description:`<strong>stride</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of overlapping tokens between chunks when splitting the input text.`,name:"stride"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2876",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TokenClassificationOutputElement"
>TokenClassificationOutputElement</a> items containing the entity group, confidence score, word, start and end index.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TokenClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),ts=new w({props:{anchor:"huggingface_hub.InferenceClient.token_classification.example",$$slots:{default:[gy]},$$scope:{ctx:_}}}),Fa=new A({props:{name:"translation",anchor:"huggingface_hub.InferenceClient.translation",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"src_lang",val:": typing.Optional[str] = None"},{name:"tgt_lang",val:": typing.Optional[str] = None"},{name:"clean_up_tokenization_spaces",val:": typing.Optional[bool] = None"},{name:"truncation",val:": typing.Optional[ForwardRef('TranslationTruncationStrategy')] = None"},{name:"generate_parameters",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.translation.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be translated.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.translation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the translation task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended translation model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.translation.src_lang",description:`<strong>src_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The source language of the text. Required for models that can translate from multiple languages.`,name:"src_lang"},{anchor:"huggingface_hub.InferenceClient.translation.tgt_lang",description:`<strong>tgt_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Target language to translate to. Required for models that can translate to multiple languages.`,name:"tgt_lang"},{anchor:"huggingface_hub.InferenceClient.translation.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to clean up the potential extra spaces in the text output.`,name:"clean_up_tokenization_spaces"},{anchor:"huggingface_hub.InferenceClient.translation.truncation",description:`<strong>truncation</strong> (<code>&quot;TranslationTruncationStrategy&quot;</code>, <em>optional</em>) &#x2014;
The truncation strategy to use.`,name:"truncation"},{anchor:"huggingface_hub.InferenceClient.translation.generate_parameters",description:`<strong>generate_parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parametrization of the text generation algorithm.`,name:"generate_parameters"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2951",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated translated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TranslationOutput"
>TranslationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If only one of the <code>src_lang</code> and <code>tgt_lang</code> arguments are provided.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code> or <code>ValueError</code></p>
`}}),ss=new w({props:{anchor:"huggingface_hub.InferenceClient.translation.example",$$slots:{default:[uy]},$$scope:{ctx:_}}}),as=new w({props:{anchor:"huggingface_hub.InferenceClient.translation.example-2",$$slots:{default:[my]},$$scope:{ctx:_}}}),Ha=new A({props:{name:"visual_question_answering",anchor:"huggingface_hub.InferenceClient.visual_question_answering",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path, ForwardRef('Image'), bytearray, memoryview]"},{name:"question",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"top_k",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.visual_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO, PIL.Image.Image]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, a URL to an online image, or a PIL Image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.visual_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.InferenceClient.visual_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the visual question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended visual question answering model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.visual_question_answering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of answers to return (will be chosen by order of likelihood). Note that we return less than
topk answers if there are not enough options available within the context.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L3040",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.VisualQuestionAnsweringOutputElement"
>VisualQuestionAnsweringOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[VisualQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>HTTPError</code></p>
`}}),ls=new w({props:{anchor:"huggingface_hub.InferenceClient.visual_question_answering.example",$$slots:{default:[hy]},$$scope:{ctx:_}}}),Oa=new A({props:{name:"zero_shot_classification",anchor:"huggingface_hub.InferenceClient.zero_shot_classification",parameters:[{name:"text",val:": str"},{name:"candidate_labels",val:": typing.List[str]"},{name:"multi_label",val:": typing.Optional[bool] = False"},{name:"hypothesis_template",val:": typing.Optional[str] = None"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to classify.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.candidate_labels",description:`<strong>candidate_labels</strong> (<code>List[str]</code>) &#x2014;
The set of possible class labels to classify the text into.`,name:"candidate_labels"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
(deprecated) List of strings. Each string is the verbalization of a possible label for the input text.`,name:"labels"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.multi_label",description:`<strong>multi_label</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether multiple candidate labels can be true. If false, the scores are normalized such that the sum of
the label likelihoods for each sequence is 1. If true, the labels are considered independent and
probabilities are normalized for each candidate.`,name:"multi_label"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.hypothesis_template",description:`<strong>hypothesis_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The sentence used in conjunction with <code>candidate_labels</code> to attempt the text classification by
replacing the placeholder with the candidate labels.`,name:"hypothesis_template"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. If not provided, the default recommended zero-shot classification model will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L3099",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ZeroShotClassificationOutputElement"
>ZeroShotClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),os=new w({props:{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.example",$$slots:{default:[dy]},$$scope:{ctx:_}}}),is=new w({props:{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.example-2",$$slots:{default:[fy]},$$scope:{ctx:_}}}),Da=new A({props:{name:"zero_shot_image_classification",anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path, ForwardRef('Image'), bytearray, memoryview]"},{name:"candidate_labels",val:": typing.List[str]"},{name:"model",val:": typing.Optional[str] = None"},{name:"hypothesis_template",val:": typing.Optional[str] = None"},{name:"labels",val:": typing.List[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO, PIL.Image.Image]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, a URL to an online image, or a PIL Image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.candidate_labels",description:`<strong>candidate_labels</strong> (<code>List[str]</code>) &#x2014;
The candidate labels for this image`,name:"candidate_labels"},{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
(deprecated) List of string possible labels. There must be at least 2 labels.`,name:"labels"},{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. If not provided, the default recommended zero-shot image classification model will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.hypothesis_template",description:`<strong>hypothesis_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The sentence used in conjunction with <code>candidate_labels</code> to attempt the image classification by
replacing the placeholder with the candidate labels.`,name:"hypothesis_template"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L3205",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ZeroShotImageClassificationOutputElement"
>ZeroShotImageClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),rs=new w({props:{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.example",$$slots:{default:[yy]},$$scope:{ctx:_}}}),La=new Bi({props:{title:"Async Inference Client",local:"huggingface_hub.AsyncInferenceClient",headingTag:"h2"}}),Ka=new U({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMGh1Z2dpbmdmYWNlX2h1YiU1QmluZmVyZW5jZSU1RCUwQSUyMyUyMG9yJTBBJTIzJTIwcGlwJTIwaW5zdGFsbCUyMGFpb2h0dHA=",highlighted:`pip install --upgrade huggingface_hub[inference]
<span class="hljs-comment"># or</span>
<span class="hljs-comment"># pip install aiohttp</span>`,wrap:!1}}),el=new A({props:{name:"class huggingface_hub.AsyncInferenceClient",anchor:"huggingface_hub.AsyncInferenceClient",parameters:[{name:"model",val:": typing.Optional[str] = None"},{name:"provider",val:": typing.Union[typing.Literal['black-forest-labs', 'cerebras', 'cohere', 'fal-ai', 'featherless-ai', 'fireworks-ai', 'groq', 'hf-inference', 'hyperbolic', 'nebius', 'novita', 'nscale', 'openai', 'replicate', 'sambanova', 'together'], typing.Literal['auto'], NoneType] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"timeout",val:": typing.Optional[float] = None"},{name:"headers",val:": typing.Optional[typing.Dict[str, str]] = None"},{name:"cookies",val:": typing.Optional[typing.Dict[str, str]] = None"},{name:"trust_env",val:": bool = False"},{name:"proxies",val:": typing.Optional[typing.Any] = None"},{name:"bill_to",val:": typing.Optional[str] = None"},{name:"base_url",val:": typing.Optional[str] = None"},{name:"api_key",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.model",description:`<strong>model</strong> (<code>str</code>, <code>optional</code>) &#x2014;
The model to run inference with. Can be a model id hosted on the Hugging Face Hub, e.g. <code>meta-llama/Meta-Llama-3-8B-Instruct</code>
or a URL to a deployed Inference Endpoint. Defaults to None, in which case a recommended model is
automatically selected for the task.
Note: for better compatibility with OpenAI&#x2019;s client, <code>model</code> has been aliased as <code>base_url</code>. Those 2
arguments are mutually exclusive. If a URL is passed as <code>model</code> or <code>base_url</code> for chat completion, the <code>(/v1)/chat/completions</code> suffix path will be appended to the URL.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.provider",description:"<strong>provider</strong> (<code>str</code>, <em>optional</em>) &#x2014;\nName of the provider to use for inference. Can be <code>&quot;black-forest-labs&quot;</code>, <code>&quot;cerebras&quot;</code>, <code>&quot;cohere&quot;</code>, <code>&quot;fal-ai&quot;</code>, <code>&quot;featherless-ai&quot;</code>, <code>&quot;fireworks-ai&quot;</code>, <code>&quot;groq&quot;</code>, <code>&quot;hf-inference&quot;</code>, <code>&quot;hyperbolic&quot;</code>, <code>&quot;nebius&quot;</code>, <code>&quot;novita&quot;</code>, <code>&quot;nscale&quot;</code>, <code>&quot;openai&quot;</code>, <code>&quot;replicate&quot;</code>, &#x201C;sambanova&#x201D;<code>or</code>&#x201C;together&#x201D;<code>. Defaults to &quot;auto&quot; i.e. the first of the providers available for the model, sorted by the user&apos;s order in https://hf.co/settings/inference-providers. If model is a URL or </code>base_url<code>is passed, then</code>provider` is not used.",name:"provider"},{anchor:"huggingface_hub.AsyncInferenceClient.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Hugging Face token. Will default to the locally saved token if not provided.
Note: for better compatibility with OpenAI&#x2019;s client, <code>token</code> has been aliased as <code>api_key</code>. Those 2
arguments are mutually exclusive and have the exact same behavior.`,name:"token"},{anchor:"huggingface_hub.AsyncInferenceClient.timeout",description:`<strong>timeout</strong> (<code>float</code>, <code>optional</code>) &#x2014;
The maximum number of seconds to wait for a response from the server. Defaults to None, meaning it will loop until the server is available.`,name:"timeout"},{anchor:"huggingface_hub.AsyncInferenceClient.headers",description:`<strong>headers</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional headers to send to the server. By default only the authorization and user-agent headers are sent.
Values in this dictionary will override the default values.`,name:"headers"},{anchor:"huggingface_hub.AsyncInferenceClient.bill_to",description:`<strong>bill_to</strong> (<code>str</code>, <code>optional</code>) &#x2014;
The billing account to use for the requests. By default the requests are billed on the user&#x2019;s account.
Requests can only be billed to an organization the user is a member of, and which has subscribed to Enterprise Hub.`,name:"bill_to"},{anchor:"huggingface_hub.AsyncInferenceClient.cookies",description:`<strong>cookies</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional cookies to send to the server.`,name:"cookies"},{anchor:"huggingface_hub.AsyncInferenceClient.trust_env",description:`<strong>trust_env</strong> (&#x2018;bool&#x2019;, &#x2018;optional&#x2019;) &#x2014;
Trust environment settings for proxy configuration if the parameter is <code>True</code> (<code>False</code> by default).`,name:"trust_env"},{anchor:"huggingface_hub.AsyncInferenceClient.proxies",description:`<strong>proxies</strong> (<code>Any</code>, <code>optional</code>) &#x2014;
Proxies to use for the request.`,name:"proxies"},{anchor:"huggingface_hub.AsyncInferenceClient.base_url",description:`<strong>base_url</strong> (<code>str</code>, <code>optional</code>) &#x2014;
Base URL to run inference. This is a duplicated argument from <code>model</code> to make <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
follow the same pattern as <code>openai.OpenAI</code> client. Cannot be used if <code>model</code> is set. Defaults to None.`,name:"base_url"},{anchor:"huggingface_hub.AsyncInferenceClient.api_key",description:`<strong>api_key</strong> (<code>str</code>, <code>optional</code>) &#x2014;
Token to use for authentication. This is a duplicated argument from <code>token</code> to make <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
follow the same pattern as <code>openai.OpenAI</code> client. Cannot be used if <code>token</code> is set. Defaults to None.`,name:"api_key"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L106"}}),nl=new A({props:{name:"audio_classification",anchor:"huggingface_hub.AsyncInferenceClient.audio_classification",parameters:[{name:"audio",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path, ForwardRef('Image'), bytearray, memoryview]"},{name:"model",val:": typing.Optional[str] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"function_to_apply",val:": typing.Optional[ForwardRef('AudioClassificationOutputTransform')] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content to classify. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for audio classification. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio classification will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When specified, limits the output to the top K most probable classes.`,name:"top_k"},{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.function_to_apply",description:`<strong>function_to_apply</strong> (<code>&quot;AudioClassificationOutputTransform&quot;</code>, <em>optional</em>) &#x2014;
The function to apply to the model outputs in order to retrieve the scores.`,name:"function_to_apply"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L316",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.AudioClassificationOutputElement"
>AudioClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),cs=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.example",$$slots:{default:[My]},$$scope:{ctx:_}}}),tl=new A({props:{name:"audio_to_audio",anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio",parameters:[{name:"audio",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path, ForwardRef('Image'), bytearray, memoryview]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content for the model. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model can be any model which takes an audio file and returns another audio file. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio_to_audio will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L374",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.AudioToAudioOutputElement"
>AudioToAudioOutputElement</a> items containing audios label, content-type, and audio content in blob.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioToAudioOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>aiohttp.ClientResponseError</code></p>
`}}),ps=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio.example",$$slots:{default:[by]},$$scope:{ctx:_}}}),sl=new A({props:{name:"automatic_speech_recognition",anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition",parameters:[{name:"audio",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path, ForwardRef('Image'), bytearray, memoryview]"},{name:"model",val:": typing.Optional[str] = None"},{name:"extra_body",val:": typing.Optional[typing.Dict] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The content to transcribe. It can be raw audio bytes, local audio file, or a URL to an audio file.`,name:"audio"},{anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for ASR. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for ASR will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition.extra_body",description:`<strong>extra_body</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Additional provider-specific parameters to pass to the model. Refer to the provider&#x2019;s documentation
for supported parameters.`,name:"extra_body"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L427",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An item containing the transcribed text and optionally the timestamp chunks.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.AutomaticSpeechRecognitionOutput"
>AutomaticSpeechRecognitionOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),gs=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition.example",$$slots:{default:[jy]},$$scope:{ctx:_}}}),al=new A({props:{name:"chat_completion",anchor:"huggingface_hub.AsyncInferenceClient.chat_completion",parameters:[{name:"messages",val:": typing.List[typing.Union[typing.Dict, huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputMessage]]"},{name:"model",val:": typing.Optional[str] = None"},{name:"stream",val:": bool = False"},{name:"frequency_penalty",val:": typing.Optional[float] = None"},{name:"logit_bias",val:": typing.Optional[typing.List[float]] = None"},{name:"logprobs",val:": typing.Optional[bool] = None"},{name:"max_tokens",val:": typing.Optional[int] = None"},{name:"n",val:": typing.Optional[int] = None"},{name:"presence_penalty",val:": typing.Optional[float] = None"},{name:"response_format",val:": typing.Union[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputResponseFormatText, huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputResponseFormatJSONSchema, huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputResponseFormatJSONObject, NoneType] = None"},{name:"seed",val:": typing.Optional[int] = None"},{name:"stop",val:": typing.Optional[typing.List[str]] = None"},{name:"stream_options",val:": typing.Optional[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputStreamOptions] = None"},{name:"temperature",val:": typing.Optional[float] = None"},{name:"tool_choice",val:": typing.Union[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputToolChoiceClass, ForwardRef('ChatCompletionInputToolChoiceEnum'), NoneType] = None"},{name:"tool_prompt",val:": typing.Optional[str] = None"},{name:"tools",val:": typing.Optional[typing.List[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputTool]] = None"},{name:"top_logprobs",val:": typing.Optional[int] = None"},{name:"top_p",val:": typing.Optional[float] = None"},{name:"extra_body",val:": typing.Optional[typing.Dict] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.messages",description:`<strong>messages</strong> (List of <a href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionInputMessage">ChatCompletionInputMessage</a>) &#x2014;
Conversation history consisting of roles and content pairs.`,name:"messages"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for chat-completion. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for chat-based text-generation will be used.
See <a href="https://huggingface.co/tasks/text-generation" rel="nofollow">https://huggingface.co/tasks/text-generation</a> for more details.
If <code>model</code> is a model ID, it is passed to the server as the <code>model</code> parameter. If you want to define a
custom URL while setting <code>model</code> in the request payload, you must set <code>base_url</code> when initializing <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Penalizes new tokens based on their existing frequency
in the text so far. Range: [-2.0, 2.0]. Defaults to 0.0.`,name:"frequency_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.logit_bias",description:`<strong>logit_bias</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Adjusts the likelihood of specific tokens appearing in the generated output.`,name:"logit_bias"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.logprobs",description:`<strong>logprobs</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return log probabilities of the output tokens or not. If true, returns the log
probabilities of each output token returned in the content of message.`,name:"logprobs"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.max_tokens",description:`<strong>max_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of tokens allowed in the response. Defaults to 100.`,name:"max_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.n",description:`<strong>n</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of completions to generate for each prompt.`,name:"n"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.presence_penalty",description:`<strong>presence_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the
text so far, increasing the model&#x2019;s likelihood to talk about new topics.`,name:"presence_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.response_format",description:`<strong>response_format</strong> (<code>ChatCompletionInputGrammarType()</code>, <em>optional</em>) &#x2014;
Grammar constraints. Can be either a JSONSchema or a regex.`,name:"response_format"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.seed",description:`<strong>seed</strong> (Optional<code>int</code>, <em>optional</em>) &#x2014;
Seed for reproducible control flow. Defaults to None.`,name:"seed"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.stop",description:`<strong>stop</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Up to four strings which trigger the end of the response.
Defaults to None.`,name:"stop"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Enable realtime streaming of responses. Defaults to False.`,name:"stream"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.stream_options",description:`<strong>stream_options</strong> (<a href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionInputStreamOptions">ChatCompletionInputStreamOptions</a>, <em>optional</em>) &#x2014;
Options for streaming completions.`,name:"stream_options"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Controls randomness of the generations. Lower values ensure
less random completions. Range: [0, 2]. Defaults to 1.0.`,name:"temperature"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.top_logprobs",description:`<strong>top_logprobs</strong> (<code>int</code>, <em>optional</em>) &#x2014;
An integer between 0 and 5 specifying the number of most likely tokens to return at each token
position, each with an associated log probability. logprobs must be set to true if this parameter is
used.`,name:"top_logprobs"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Fraction of the most likely next words to sample from.
Must be between 0 and 1. Defaults to 1.0.`,name:"top_p"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.tool_choice",description:`<strong>tool_choice</strong> (<a href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionInputToolChoiceClass">ChatCompletionInputToolChoiceClass</a> or <code>ChatCompletionInputToolChoiceEnum()</code>, <em>optional</em>) &#x2014;
The tool to use for the completion. Defaults to &#x201C;auto&#x201D;.`,name:"tool_choice"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.tool_prompt",description:`<strong>tool_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A prompt to be appended before the tools.`,name:"tool_prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.tools",description:`<strong>tools</strong> (List of <a href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionInputTool">ChatCompletionInputTool</a>, <em>optional</em>) &#x2014;
A list of tools the model may call. Currently, only functions are supported as a tool. Use this to
provide a list of functions the model may generate JSON inputs for.`,name:"tools"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.extra_body",description:`<strong>extra_body</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Additional provider-specific parameters to pass to the model. Refer to the provider&#x2019;s documentation
for supported parameters.`,name:"extra_body"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L554",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code>, the generated text is returned as a <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> (default).</li>
<li>if <code>stream=True</code>, the generated text is returned token by token as a sequence of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> or Iterable of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),us=new H({props:{$$slots:{default:[_y]},$$scope:{ctx:_}}}),ms=new H({props:{$$slots:{default:[Iy]},$$scope:{ctx:_}}}),hs=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example",$$slots:{default:[Ty]},$$scope:{ctx:_}}}),ds=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-2",$$slots:{default:[Jy]},$$scope:{ctx:_}}}),fs=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-3",$$slots:{default:[Uy]},$$scope:{ctx:_}}}),ys=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-4",$$slots:{default:[wy]},$$scope:{ctx:_}}}),Ms=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-5",$$slots:{default:[Cy]},$$scope:{ctx:_}}}),bs=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-6",$$slots:{default:[xy]},$$scope:{ctx:_}}}),js=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-7",$$slots:{default:[$y]},$$scope:{ctx:_}}}),_s=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-8",$$slots:{default:[vy]},$$scope:{ctx:_}}}),ll=new A({props:{name:"close",anchor:"huggingface_hub.AsyncInferenceClient.close",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L305"}}),ol=new A({props:{name:"document_question_answering",anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path, ForwardRef('Image'), bytearray, memoryview]"},{name:"question",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"doc_stride",val:": typing.Optional[int] = None"},{name:"handle_impossible_answer",val:": typing.Optional[bool] = None"},{name:"lang",val:": typing.Optional[str] = None"},{name:"max_answer_len",val:": typing.Optional[int] = None"},{name:"max_question_len",val:": typing.Optional[int] = None"},{name:"max_seq_len",val:": typing.Optional[int] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"word_boxes",val:": typing.Optional[typing.List[typing.Union[typing.List[float], str]]] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the document question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended document question answering model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.doc_stride",description:`<strong>doc_stride</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If the words in the document are too long to fit with the question for the model, it will be split in
several chunks with some overlap. This argument controls the size of that overlap.`,name:"doc_stride"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.handle_impossible_answer",description:`<strong>handle_impossible_answer</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to accept impossible as an answer`,name:"handle_impossible_answer"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.lang",description:`<strong>lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Language to use while running OCR. Defaults to english.`,name:"lang"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.max_answer_len",description:`<strong>max_answer_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of predicted answers (e.g., only answers with a shorter length are considered).`,name:"max_answer_len"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.max_question_len",description:`<strong>max_question_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the question after tokenization. It will be truncated if needed.`,name:"max_question_len"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.max_seq_len",description:`<strong>max_seq_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the total sentence (context + question) in tokens of each chunk passed to the
model. The context will be split in several chunks (using doc_stride as overlap) if needed.`,name:"max_seq_len"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of answers to return (will be chosen by order of likelihood). Can return less than top_k
answers if there are not enough options available within the context.`,name:"top_k"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.word_boxes",description:`<strong>word_boxes</strong> (<code>List[Union[List[float], str</code>, <em>optional</em>) &#x2014;
A list of words and bounding boxes (normalized 0-&gt;1000). If provided, the inference will skip the OCR
step and use the provided bounding boxes instead.`,name:"word_boxes"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L966",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.DocumentQuestionAnsweringOutputElement"
>DocumentQuestionAnsweringOutputElement</a> items containing the predicted label, associated probability, word ids, and page number.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[DocumentQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Is=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.example",$$slots:{default:[ky]},$$scope:{ctx:_}}}),il=new A({props:{name:"feature_extraction",anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction",parameters:[{name:"text",val:": str"},{name:"normalize",val:": typing.Optional[bool] = None"},{name:"prompt_name",val:": typing.Optional[str] = None"},{name:"truncate",val:": typing.Optional[bool] = None"},{name:"truncation_direction",val:": typing.Optional[typing.Literal['Left', 'Right']] = None"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.text",description:`<strong>text</strong> (<em>str</em>) &#x2014;
The text to embed.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.model",description:`<strong>model</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The model to use for the feature extraction task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended feature extraction model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.normalize",description:`<strong>normalize</strong> (<em>bool</em>, <em>optional</em>) &#x2014;
Whether to normalize the embeddings or not.
Only available on server powered by Text-Embedding-Inference.`,name:"normalize"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.prompt_name",description:`<strong>prompt_name</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The name of the prompt that should be used by for encoding. If not set, no prompt will be applied.
Must be a key in the <em>Sentence Transformers</em> configuration <em>prompts</em> dictionary.
For example if <code>prompt_name</code> is &#x201C;query&#x201D; and the <code>prompts</code> is {&#x201C;query&#x201D;: &#x201C;query: &#x201D;,&#x2026;},
then the sentence &#x201C;What is the capital of France?&#x201D; will be encoded as &#x201C;query: What is the capital of France?&#x201D;
because the prompt text will be prepended before any text to encode.`,name:"prompt_name"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.truncate",description:`<strong>truncate</strong> (<em>bool</em>, <em>optional</em>) &#x2014;
Whether to truncate the embeddings or not.
Only available on server powered by Text-Embedding-Inference.`,name:"truncate"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.truncation_direction",description:`<strong>truncation_direction</strong> (<em>Literal[&#x201C;Left&#x201D;, &#x201C;Right&#x201D;]</em>, <em>optional</em>) &#x2014;
Which side of the input should be truncated when <em>truncate=True</em> is passed.`,name:"truncation_direction"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1054",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text as a float32 numpy array.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><em>np.ndarray</em></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>[<em>InferenceTimeoutError</em>] —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>[<em>InferenceTimeoutError</em>] or <code>aiohttp.ClientResponseError</code></p>
`}}),Ts=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.example",$$slots:{default:[qy]},$$scope:{ctx:_}}}),rl=new A({props:{name:"fill_mask",anchor:"huggingface_hub.AsyncInferenceClient.fill_mask",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"targets",val:": typing.Optional[typing.List[str]] = None"},{name:"top_k",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
a string to be filled from, must contain the [MASK] token (check model card for exact name of the mask).`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the fill mask task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended fill mask model will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.targets",description:`<strong>targets</strong> (<code>List[str</code>, <em>optional</em>) &#x2014;
When passed, the model will limit the scores to the passed targets instead of looking up in the whole
vocabulary. If the provided targets are not in the model vocab, they will be tokenized and the first
resulting token will be used (with a warning, and that might be slower).`,name:"targets"},{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When passed, overrides the number of predictions to return.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1128",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.FillMaskOutputElement"
>FillMaskOutputElement</a> items containing the predicted label, associated
probability, token reference, and completed text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[FillMaskOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Js=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.example",$$slots:{default:[Ay]},$$scope:{ctx:_}}}),cl=new A({props:{name:"get_endpoint_info",anchor:"huggingface_hub.AsyncInferenceClient.get_endpoint_info",parameters:[{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.get_endpoint_info.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L3378",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Information about the endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),Us=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.get_endpoint_info.example",$$slots:{default:[Zy]},$$scope:{ctx:_}}}),pl=new A({props:{name:"health_check",anchor:"huggingface_hub.AsyncInferenceClient.health_check",parameters:[{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.health_check.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
URL of the Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L3438",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if everything is working fine.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),ws=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.health_check.example",$$slots:{default:[Ey]},$$scope:{ctx:_}}}),gl=new A({props:{name:"image_classification",anchor:"huggingface_hub.AsyncInferenceClient.image_classification",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path, ForwardRef('Image'), bytearray, memoryview]"},{name:"model",val:": typing.Optional[str] = None"},{name:"function_to_apply",val:": typing.Optional[ForwardRef('ImageClassificationOutputTransform')] = None"},{name:"top_k",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO, PIL.Image.Image]</code>) &#x2014;
The image to classify. It can be raw bytes, an image file, a URL to an online image, or a PIL Image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image classification. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image classification will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.function_to_apply",description:`<strong>function_to_apply</strong> (<code>&quot;ImageClassificationOutputTransform&quot;</code>, <em>optional</em>) &#x2014;
The function to apply to the model outputs in order to retrieve the scores.`,name:"function_to_apply"},{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When specified, limits the output to the top K most probable classes.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1185",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ImageClassificationOutputElement"
>ImageClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Cs=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.example",$$slots:{default:[Wy]},$$scope:{ctx:_}}}),ul=new A({props:{name:"image_segmentation",anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path, ForwardRef('Image'), bytearray, memoryview]"},{name:"model",val:": typing.Optional[str] = None"},{name:"mask_threshold",val:": typing.Optional[float] = None"},{name:"overlap_mask_area_threshold",val:": typing.Optional[float] = None"},{name:"subtask",val:": typing.Optional[ForwardRef('ImageSegmentationSubtask')] = None"},{name:"threshold",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO, PIL.Image.Image]</code>) &#x2014;
The image to segment. It can be raw bytes, an image file, a URL to an online image, or a PIL Image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image segmentation. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image segmentation will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Mask overlap threshold to eliminate small, disconnected segments.`,name:"overlap_mask_area_threshold"},{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.subtask",description:`<strong>subtask</strong> (<code>&quot;ImageSegmentationSubtask&quot;</code>, <em>optional</em>) &#x2014;
Segmentation task to be performed, depending on model capabilities.`,name:"subtask"},{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Probability threshold to filter out predicted masks.`,name:"threshold"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1236",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ImageSegmentationOutputElement"
>ImageSegmentationOutputElement</a> items containing the segmented masks and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageSegmentationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),xs=new H({props:{warning:!0,$$slots:{default:[Ny]},$$scope:{ctx:_}}}),$s=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.example",$$slots:{default:[Gy]},$$scope:{ctx:_}}}),ml=new A({props:{name:"image_to_image",anchor:"huggingface_hub.AsyncInferenceClient.image_to_image",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path, ForwardRef('Image'), bytearray, memoryview]"},{name:"prompt",val:": typing.Optional[str] = None"},{name:"negative_prompt",val:": typing.Optional[str] = None"},{name:"num_inference_steps",val:": typing.Optional[int] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"model",val:": typing.Optional[str] = None"},{name:"target_size",val:": typing.Optional[huggingface_hub.inference._generated.types.image_to_image.ImageToImageTargetSize] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO, PIL.Image.Image]</code>) &#x2014;
The input image for translation. It can be raw bytes, an image file, a URL to an online image, or a PIL Image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The text prompt to guide the image generation.`,name:"prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
One prompt to guide what NOT to include in image generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
For diffusion models. The number of denoising steps. More denoising steps usually lead to a higher
quality image at the expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
For diffusion models. A higher guidance scale value encourages the model to generate images closely
linked to the text prompt at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.target_size",description:`<strong>target_size</strong> (<code>ImageToImageTargetSize</code>, <em>optional</em>) &#x2014;
The size in pixel of the output image.`,name:"target_size"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1307",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The translated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),vs=new H({props:{warning:!0,$$slots:{default:[By]},$$scope:{ctx:_}}}),ks=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.example",$$slots:{default:[Vy]},$$scope:{ctx:_}}}),hl=new A({props:{name:"image_to_text",anchor:"huggingface_hub.AsyncInferenceClient.image_to_text",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path, ForwardRef('Image'), bytearray, memoryview]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_to_text.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO, PIL.Image.Image]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, a URL to an online image, or a PIL Image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_text.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1465",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ImageToTextOutput"
>ImageToTextOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),qs=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_to_text.example",$$slots:{default:[Qy]},$$scope:{ctx:_}}}),dl=new A({props:{name:"image_to_video",anchor:"huggingface_hub.AsyncInferenceClient.image_to_video",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path, ForwardRef('Image'), bytearray, memoryview]"},{name:"model",val:": typing.Optional[str] = None"},{name:"prompt",val:": typing.Optional[str] = None"},{name:"negative_prompt",val:": typing.Optional[str] = None"},{name:"num_frames",val:": typing.Optional[float] = None"},{name:"num_inference_steps",val:": typing.Optional[int] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"seed",val:": typing.Optional[int] = None"},{name:"target_size",val:": typing.Optional[huggingface_hub.inference._generated.types.image_to_video.ImageToVideoTargetSize] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_to_video.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO, PIL.Image.Image]</code>) &#x2014;
The input image to generate a video from. It can be raw bytes, an image file, a URL to an online image, or a PIL Image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_video.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_video.prompt",description:`<strong>prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The text prompt to guide the video generation.`,name:"prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_video.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
One prompt to guide what NOT to include in video generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_video.num_frames",description:`<strong>num_frames</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The num_frames parameter determines how many video frames are generated.`,name:"num_frames"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_video.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
For diffusion models. The number of denoising steps. More denoising steps usually lead to a higher
quality image at the expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_video.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
For diffusion models. A higher guidance scale value encourages the model to generate videos closely
linked to the text prompt at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_video.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The seed to use for the video generation.`,name:"seed"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_video.target_size",description:`<strong>target_size</strong> (<code>ImageToVideoTargetSize</code>, <em>optional</em>) &#x2014;
The size in pixel of the output video frames.`,name:"target_size"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_video.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality video at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_video.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Seed for the random number generator.`,name:"seed"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1385",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated video.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bytes</code></p>
`}}),As=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_to_video.example",$$slots:{default:[Sy]},$$scope:{ctx:_}}}),fl=new A({props:{name:"object_detection",anchor:"huggingface_hub.AsyncInferenceClient.object_detection",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path, ForwardRef('Image'), bytearray, memoryview]"},{name:"model",val:": typing.Optional[str] = None"},{name:"threshold",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.object_detection.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO, PIL.Image.Image]</code>) &#x2014;
The image to detect objects on. It can be raw bytes, an image file, a URL to an online image, or a PIL Image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.object_detection.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for object detection. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for object detection (DETR) will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The probability necessary to make a prediction.`,name:"threshold"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1512",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ObjectDetectionOutputElement"
>ObjectDetectionOutputElement</a> items containing the bounding boxes and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ObjectDetectionOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If the request output is not a List.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code> or <code>ValueError</code></p>
`}}),Zs=new H({props:{warning:!0,$$slots:{default:[Yy]},$$scope:{ctx:_}}}),Es=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.object_detection.example",$$slots:{default:[Ry]},$$scope:{ctx:_}}}),yl=new A({props:{name:"question_answering",anchor:"huggingface_hub.AsyncInferenceClient.question_answering",parameters:[{name:"question",val:": str"},{name:"context",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"align_to_words",val:": typing.Optional[bool] = None"},{name:"doc_stride",val:": typing.Optional[int] = None"},{name:"handle_impossible_answer",val:": typing.Optional[bool] = None"},{name:"max_answer_len",val:": typing.Optional[int] = None"},{name:"max_question_len",val:": typing.Optional[int] = None"},{name:"max_seq_len",val:": typing.Optional[int] = None"},{name:"top_k",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.context",description:`<strong>context</strong> (<code>str</code>) &#x2014;
The context of the question.`,name:"context"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.align_to_words",description:`<strong>align_to_words</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Attempts to align the answer to real words. Improves quality on space separated languages. Might hurt
on non-space-separated languages (like Japanese or Chinese)`,name:"align_to_words"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.doc_stride",description:`<strong>doc_stride</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If the context is too long to fit with the question for the model, it will be split in several chunks
with some overlap. This argument controls the size of that overlap.`,name:"doc_stride"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.handle_impossible_answer",description:`<strong>handle_impossible_answer</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to accept impossible as an answer.`,name:"handle_impossible_answer"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.max_answer_len",description:`<strong>max_answer_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of predicted answers (e.g., only answers with a shorter length are considered).`,name:"max_answer_len"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.max_question_len",description:`<strong>max_question_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the question after tokenization. It will be truncated if needed.`,name:"max_question_len"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.max_seq_len",description:`<strong>max_seq_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the total sentence (context + question) in tokens of each chunk passed to the
model. The context will be split in several chunks (using docStride as overlap) if needed.`,name:"max_seq_len"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of answers to return (will be chosen by order of likelihood). Note that we return less than
topk answers if there are not enough options available within the context.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1564",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>When top_k is 1 or not provided, it returns a single <code>QuestionAnsweringOutputElement</code>.
When top_k is greater than 1, it returns a list of <code>QuestionAnsweringOutputElement</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Union[<code>QuestionAnsweringOutputElement</code>, List<a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.QuestionAnsweringOutputElement"
>QuestionAnsweringOutputElement</a>]</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ws=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.example",$$slots:{default:[Xy]},$$scope:{ctx:_}}}),Ml=new A({props:{name:"sentence_similarity",anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity",parameters:[{name:"sentence",val:": str"},{name:"other_sentences",val:": typing.List[str]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.sentence",description:`<strong>sentence</strong> (<code>str</code>) &#x2014;
The main sentence to compare to others.`,name:"sentence"},{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.other_sentences",description:`<strong>other_sentences</strong> (<code>List[str]</code>) &#x2014;
The list of sentences to compare to.`,name:"other_sentences"},{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the sentence similarity task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended sentence similarity model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1649",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[float]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ns=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.example",$$slots:{default:[zy]},$$scope:{ctx:_}}}),bl=new A({props:{name:"summarization",anchor:"huggingface_hub.AsyncInferenceClient.summarization",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"clean_up_tokenization_spaces",val:": typing.Optional[bool] = None"},{name:"generate_parameters",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"truncation",val:": typing.Optional[ForwardRef('SummarizationTruncationStrategy')] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.summarization.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to summarize.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.summarization.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for summarization will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.summarization.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to clean up the potential extra spaces in the text output.`,name:"clean_up_tokenization_spaces"},{anchor:"huggingface_hub.AsyncInferenceClient.summarization.generate_parameters",description:`<strong>generate_parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parametrization of the text generation algorithm.`,name:"generate_parameters"},{anchor:"huggingface_hub.AsyncInferenceClient.summarization.truncation",description:`<strong>truncation</strong> (<code>&quot;SummarizationTruncationStrategy&quot;</code>, <em>optional</em>) &#x2014;
The truncation strategy to use.`,name:"truncation"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1703",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated summary text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.SummarizationOutput"
>SummarizationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Gs=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.summarization.example",$$slots:{default:[Fy]},$$scope:{ctx:_}}}),jl=new A({props:{name:"table_question_answering",anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering",parameters:[{name:"table",val:": typing.Dict[str, typing.Any]"},{name:"query",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"padding",val:": typing.Optional[ForwardRef('Padding')] = None"},{name:"sequential",val:": typing.Optional[bool] = None"},{name:"truncation",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.table",description:`<strong>table</strong> (<code>str</code>) &#x2014;
A table of data represented as a dict of lists where entries are headers and the lists are all the
values, all lists must have the same size.`,name:"table"},{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.query",description:`<strong>query</strong> (<code>str</code>) &#x2014;
The query in plain text that you want to ask the table.`,name:"query"},{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the table-question-answering task. Can be a model ID hosted on the Hugging Face
Hub or a URL to a deployed Inference Endpoint.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.padding",description:`<strong>padding</strong> (<code>&quot;Padding&quot;</code>, <em>optional</em>) &#x2014;
Activates and controls padding.`,name:"padding"},{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.sequential",description:`<strong>sequential</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to do inference sequentially or as a batch. Batching is faster, but models like SQA require the
inference to be done sequentially to extract relations within sequences, given their conversational
nature.`,name:"sequential"},{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Activates and controls truncation.`,name:"truncation"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1762",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a table question answering output containing the answer, coordinates, cells and the aggregator used.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TableQuestionAnsweringOutputElement"
>TableQuestionAnsweringOutputElement</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Bs=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.example",$$slots:{default:[Hy]},$$scope:{ctx:_}}}),_l=new A({props:{name:"tabular_classification",anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification",parameters:[{name:"table",val:": typing.Dict[str, typing.Any]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes to classify.`,name:"table"},{anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1825",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of labels, one per row in the initial table.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Vs=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification.example",$$slots:{default:[Oy]},$$scope:{ctx:_}}}),Il=new A({props:{name:"tabular_regression",anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression",parameters:[{name:"table",val:": typing.Dict[str, typing.Any]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes stored in a table. The attributes used to predict the target can be both numerical and categorical.`,name:"table"},{anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular regression task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular regression model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1881",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of predicted numerical target values.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Qs=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression.example",$$slots:{default:[Dy]},$$scope:{ctx:_}}}),Tl=new A({props:{name:"text_classification",anchor:"huggingface_hub.AsyncInferenceClient.text_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"function_to_apply",val:": typing.Optional[ForwardRef('TextClassificationOutputTransform')] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the text classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended text classification model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When specified, limits the output to the top K most probable classes.`,name:"top_k"},{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.function_to_apply",description:`<strong>function_to_apply</strong> (<code>&quot;TextClassificationOutputTransform&quot;</code>, <em>optional</em>) &#x2014;
The function to apply to the model outputs in order to retrieve the scores.`,name:"function_to_apply"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1932",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TextClassificationOutputElement"
>TextClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TextClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ss=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.example",$$slots:{default:[Ly]},$$scope:{ctx:_}}}),Jl=new A({props:{name:"text_generation",anchor:"huggingface_hub.AsyncInferenceClient.text_generation",parameters:[{name:"prompt",val:": str"},{name:"details",val:": typing.Optional[bool] = None"},{name:"stream",val:": typing.Optional[bool] = None"},{name:"model",val:": typing.Optional[str] = None"},{name:"adapter_id",val:": typing.Optional[str] = None"},{name:"best_of",val:": typing.Optional[int] = None"},{name:"decoder_input_details",val:": typing.Optional[bool] = None"},{name:"do_sample",val:": typing.Optional[bool] = None"},{name:"frequency_penalty",val:": typing.Optional[float] = None"},{name:"grammar",val:": typing.Optional[huggingface_hub.inference._generated.types.text_generation.TextGenerationInputGrammarType] = None"},{name:"max_new_tokens",val:": typing.Optional[int] = None"},{name:"repetition_penalty",val:": typing.Optional[float] = None"},{name:"return_full_text",val:": typing.Optional[bool] = None"},{name:"seed",val:": typing.Optional[int] = None"},{name:"stop",val:": typing.Optional[typing.List[str]] = None"},{name:"stop_sequences",val:": typing.Optional[typing.List[str]] = None"},{name:"temperature",val:": typing.Optional[float] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"top_n_tokens",val:": typing.Optional[int] = None"},{name:"top_p",val:": typing.Optional[float] = None"},{name:"truncate",val:": typing.Optional[int] = None"},{name:"typical_p",val:": typing.Optional[float] = None"},{name:"watermark",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
Input text.`,name:"prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.details",description:`<strong>details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns a string. Pass <code>details=True</code> if you want a detailed output (tokens,
probabilities, seed, finish reason, etc.). Only available for models running on with the
<code>text-generation-inference</code> backend.`,name:"details"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns the full generated text. Pass <code>stream=True</code> if you want a stream of
tokens to be returned. Only available for models running on with the <code>text-generation-inference</code>
backend.`,name:"stream"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.adapter_id",description:`<strong>adapter_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Lora adapter id.`,name:"adapter_id"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.best_of",description:`<strong>best_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Generate best_of sequences and return the one if the highest token logprobs.`,name:"best_of"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.decoder_input_details",description:`<strong>decoder_input_details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Return the decoder input token logprobs and ids. You must set <code>details=True</code> as well for it to be taken
into account. Defaults to <code>False</code>.`,name:"decoder_input_details"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Activate logits sampling`,name:"do_sample"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in
the text so far, decreasing the model&#x2019;s likelihood to repeat the same line verbatim.`,name:"frequency_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.grammar",description:`<strong>grammar</strong> (<a href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TextGenerationInputGrammarType">TextGenerationInputGrammarType</a>, <em>optional</em>) &#x2014;
Grammar constraints. Can be either a JSONSchema or a regex.`,name:"grammar"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of generated tokens. Defaults to 100.`,name:"max_new_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.return_full_text",description:`<strong>return_full_text</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to prepend the prompt to the generated text`,name:"return_full_text"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Random sampling seed`,name:"seed"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.stop",description:`<strong>stop</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Stop generating tokens if a member of <code>stop</code> is generated.`,name:"stop"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.stop_sequences",description:`<strong>stop_sequences</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Deprecated argument. Use <code>stop</code> instead.`,name:"stop_sequences"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.top_n_tokens",description:`<strong>top_n_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Return information about the <code>top_n_tokens</code> most likely tokens at each generation step, instead of
just the sampled token.`,name:"top_n_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.top_k",description:"<strong>top_k</strong> (<code>int</code>, *optional`) &#x2014;\nThe number of highest probability vocabulary tokens to keep for top-k-filtering.",name:"top_k"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.top_p",description:"<strong>top_p</strong> (<code>float</code>, *optional<code>) -- If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to </code>top_p` or\nhigher are kept for generation.",name:"top_p"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.truncate",description:"<strong>truncate</strong> (<code>int</code>, *optional`) &#x2014;\nTruncate inputs tokens to the given size.",name:"truncate"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, *optional\`) &#x2014;
Typical Decoding mass
See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language Generation</a> for more information`,name:"typical_p"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.watermark",description:`<strong>watermark</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Watermarking with <a href="https://arxiv.org/abs/2301.10226" rel="nofollow">A Watermark for Large Language Models</a>`,name:"watermark"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L2141",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code> and <code>details=False</code>, the generated text is returned as a <code>str</code> (default)</li>
<li>if <code>stream=True</code> and <code>details=False</code>, the generated text is returned token by token as a <code>Iterable[str]</code></li>
<li>if <code>stream=False</code> and <code>details=True</code>, the generated text is returned with more details as a <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TextGenerationOutput"
>TextGenerationOutput</a></li>
<li>if <code>details=True</code> and <code>stream=True</code>, the generated text is returned token by token as a iterable of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TextGenerationStreamOutput"
>TextGenerationStreamOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Union[str, TextGenerationOutput, Iterable[str], Iterable[TextGenerationStreamOutput]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValidationError</code> —
If input values are not valid. No HTTP call is made to the server.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValidationError</code> or <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ys=new H({props:{$$slots:{default:[Py]},$$scope:{ctx:_}}}),Rs=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.example",$$slots:{default:[Ky]},$$scope:{ctx:_}}}),Ul=new A({props:{name:"text_to_image",anchor:"huggingface_hub.AsyncInferenceClient.text_to_image",parameters:[{name:"prompt",val:": str"},{name:"negative_prompt",val:": typing.Optional[str] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": typing.Optional[int] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"model",val:": typing.Optional[str] = None"},{name:"scheduler",val:": typing.Optional[str] = None"},{name:"seed",val:": typing.Optional[int] = None"},{name:"extra_body",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
The prompt to generate an image from.`,name:"prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
One prompt to guide what NOT to include in image generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The height in pixels of the output image`,name:"height"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The width in pixels of the output image`,name:"width"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
prompt, but values too high may cause saturation and other artifacts.`,name:"guidance_scale"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended text-to-image model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.scheduler",description:`<strong>scheduler</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Override the scheduler with a compatible one.`,name:"scheduler"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Seed for the random number generator.`,name:"seed"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.extra_body",description:`<strong>extra_body</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional provider-specific parameters to pass to the model. Refer to the provider&#x2019;s documentation
for supported parameters.`,name:"extra_body"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L2484",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Xs=new H({props:{warning:!0,$$slots:{default:[eM]},$$scope:{ctx:_}}}),zs=new H({props:{$$slots:{default:[nM]},$$scope:{ctx:_}}}),Fs=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.example",$$slots:{default:[tM]},$$scope:{ctx:_}}}),Hs=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.example-2",$$slots:{default:[sM]},$$scope:{ctx:_}}}),Os=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.example-3",$$slots:{default:[aM]},$$scope:{ctx:_}}}),Ds=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.example-4",$$slots:{default:[lM]},$$scope:{ctx:_}}}),wl=new A({props:{name:"text_to_speech",anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"do_sample",val:": typing.Optional[bool] = None"},{name:"early_stopping",val:": typing.Union[bool, ForwardRef('TextToSpeechEarlyStoppingEnum'), NoneType] = None"},{name:"epsilon_cutoff",val:": typing.Optional[float] = None"},{name:"eta_cutoff",val:": typing.Optional[float] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"max_new_tokens",val:": typing.Optional[int] = None"},{name:"min_length",val:": typing.Optional[int] = None"},{name:"min_new_tokens",val:": typing.Optional[int] = None"},{name:"num_beam_groups",val:": typing.Optional[int] = None"},{name:"num_beams",val:": typing.Optional[int] = None"},{name:"penalty_alpha",val:": typing.Optional[float] = None"},{name:"temperature",val:": typing.Optional[float] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"top_p",val:": typing.Optional[float] = None"},{name:"typical_p",val:": typing.Optional[float] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"extra_body",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The text to synthesize.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended text-to-speech model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use sampling instead of greedy decoding when generating new tokens.`,name:"do_sample"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.early_stopping",description:`<strong>early_stopping</strong> (<code>Union[bool, &quot;TextToSpeechEarlyStoppingEnum&quot;]</code>, <em>optional</em>) &#x2014;
Controls the stopping condition for beam-based methods.`,name:"early_stopping"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.epsilon_cutoff",description:`<strong>epsilon_cutoff</strong> (<code>float</code>, <em>optional</em>) &#x2014;
If set to float strictly between 0 and 1, only tokens with a conditional probability greater than
epsilon_cutoff will be sampled. In the paper, suggested values range from 3e-4 to 9e-4, depending on
the size of the model. See <a href="https://hf.co/papers/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more details.`,name:"epsilon_cutoff"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.eta_cutoff",description:`<strong>eta_cutoff</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Eta sampling is a hybrid of locally typical sampling and epsilon sampling. If set to float strictly
between 0 and 1, a token is only considered if it is greater than either eta_cutoff or sqrt(eta_cutoff)<ul>
<li>exp(-entropy(softmax(next_token_logits))). The latter term is intuitively the expected next token
probability, scaled by sqrt(eta_cutoff). In the paper, suggested values range from 3e-4 to 2e-3,
depending on the size of the model. See <a href="https://hf.co/papers/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more details.</li>
</ul>`,name:"eta_cutoff"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length (in tokens) of the generated text, including the input.`,name:"max_length"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum number of tokens to generate. Takes precedence over max_length.`,name:"max_new_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.min_length",description:`<strong>min_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum length (in tokens) of the generated text, including the input.`,name:"min_length"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum number of tokens to generate. Takes precedence over min_length.`,name:"min_new_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of groups to divide num_beams into in order to ensure diversity among different groups of beams.
See <a href="https://hf.co/papers/1610.02424" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.num_beams",description:`<strong>num_beams</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of beams to use for beam search.`,name:"num_beams"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.penalty_alpha",description:`<strong>penalty_alpha</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value balances the model confidence and the degeneration penalty in contrastive search decoding.`,name:"penalty_alpha"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value used to modulate the next token probabilities.`,name:"temperature"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
If set to float &lt; 1, only the smallest set of most probable tokens with probabilities that add up to
top_p or higher are kept for generation.`,name:"top_p"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Local typicality measures how similar the conditional probability of predicting a target token next is
to the expected conditional probability of predicting a random token next, given the partial text
already generated. If set to float &lt; 1, the smallest set of the most locally typical tokens with
probabilities that add up to typical_p or higher are kept for generation. See <a href="https://hf.co/papers/2202.00666" rel="nofollow">this
paper</a> for more details.`,name:"typical_p"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the model should use the past last key/values attentions to speed up decoding`,name:"use_cache"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.extra_body",description:`<strong>extra_body</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional provider-specific parameters to pass to the model. Refer to the provider&#x2019;s documentation
for supported parameters.`,name:"extra_body"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L2725",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated audio.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bytes</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ls=new H({props:{$$slots:{default:[oM]},$$scope:{ctx:_}}}),Ps=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.example",$$slots:{default:[iM]},$$scope:{ctx:_}}}),Ks=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.example-2",$$slots:{default:[rM]},$$scope:{ctx:_}}}),ea=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.example-3",$$slots:{default:[cM]},$$scope:{ctx:_}}}),na=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.example-4",$$slots:{default:[pM]},$$scope:{ctx:_}}}),ta=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.example-5",$$slots:{default:[gM]},$$scope:{ctx:_}}}),Cl=new A({props:{name:"text_to_video",anchor:"huggingface_hub.AsyncInferenceClient.text_to_video",parameters:[{name:"prompt",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"negative_prompt",val:": typing.Optional[typing.List[str]] = None"},{name:"num_frames",val:": typing.Optional[float] = None"},{name:"num_inference_steps",val:": typing.Optional[int] = None"},{name:"seed",val:": typing.Optional[int] = None"},{name:"extra_body",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_to_video.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
The prompt to generate a video from.`,name:"prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_video.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended text-to-video model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_video.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A higher guidance scale value encourages the model to generate videos closely linked to the text
prompt, but values too high may cause saturation and other artifacts.`,name:"guidance_scale"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_video.negative_prompt",description:`<strong>negative_prompt</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
One or several prompt to guide what NOT to include in video generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_video.num_frames",description:`<strong>num_frames</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The num_frames parameter determines how many video frames are generated.`,name:"num_frames"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_video.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality video at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_video.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Seed for the random number generator.`,name:"seed"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_video.extra_body",description:`<strong>extra_body</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional provider-specific parameters to pass to the model. Refer to the provider&#x2019;s documentation
for supported parameters.`,name:"extra_body"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L2628",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated video.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bytes</code></p>
`}}),sa=new H({props:{$$slots:{default:[uM]},$$scope:{ctx:_}}}),aa=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_video.example",$$slots:{default:[mM]},$$scope:{ctx:_}}}),la=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_video.example-2",$$slots:{default:[hM]},$$scope:{ctx:_}}}),xl=new A({props:{name:"token_classification",anchor:"huggingface_hub.AsyncInferenceClient.token_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"aggregation_strategy",val:": typing.Optional[ForwardRef('TokenClassificationAggregationStrategy')] = None"},{name:"ignore_labels",val:": typing.Optional[typing.List[str]] = None"},{name:"stride",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the token classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended token classification model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.aggregation_strategy",description:`<strong>aggregation_strategy</strong> (<code>&quot;TokenClassificationAggregationStrategy&quot;</code>, <em>optional</em>) &#x2014;
The strategy used to fuse tokens based on model predictions`,name:"aggregation_strategy"},{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.ignore_labels",description:`<strong>ignore_labels</strong> (<code>List[str</code>, <em>optional</em>) &#x2014;
A list of labels to ignore`,name:"ignore_labels"},{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.stride",description:`<strong>stride</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of overlapping tokens between chunks when splitting the input text.`,name:"stride"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L2935",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TokenClassificationOutputElement"
>TokenClassificationOutputElement</a> items containing the entity group, confidence score, word, start and end index.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TokenClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),oa=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.example",$$slots:{default:[dM]},$$scope:{ctx:_}}}),$l=new A({props:{name:"translation",anchor:"huggingface_hub.AsyncInferenceClient.translation",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"src_lang",val:": typing.Optional[str] = None"},{name:"tgt_lang",val:": typing.Optional[str] = None"},{name:"clean_up_tokenization_spaces",val:": typing.Optional[bool] = None"},{name:"truncation",val:": typing.Optional[ForwardRef('TranslationTruncationStrategy')] = None"},{name:"generate_parameters",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.translation.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be translated.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the translation task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended translation model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.src_lang",description:`<strong>src_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The source language of the text. Required for models that can translate from multiple languages.`,name:"src_lang"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.tgt_lang",description:`<strong>tgt_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Target language to translate to. Required for models that can translate to multiple languages.`,name:"tgt_lang"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to clean up the potential extra spaces in the text output.`,name:"clean_up_tokenization_spaces"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.truncation",description:`<strong>truncation</strong> (<code>&quot;TranslationTruncationStrategy&quot;</code>, <em>optional</em>) &#x2014;
The truncation strategy to use.`,name:"truncation"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.generate_parameters",description:`<strong>generate_parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parametrization of the text generation algorithm.`,name:"generate_parameters"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L3011",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated translated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TranslationOutput"
>TranslationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If only one of the <code>src_lang</code> and <code>tgt_lang</code> arguments are provided.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code> or <code>ValueError</code></p>
`}}),ia=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.translation.example",$$slots:{default:[fM]},$$scope:{ctx:_}}}),ra=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.translation.example-2",$$slots:{default:[yM]},$$scope:{ctx:_}}}),vl=new A({props:{name:"visual_question_answering",anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path, ForwardRef('Image'), bytearray, memoryview]"},{name:"question",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"top_k",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO, PIL.Image.Image]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, a URL to an online image, or a PIL Image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the visual question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended visual question answering model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of answers to return (will be chosen by order of likelihood). Note that we return less than
topk answers if there are not enough options available within the context.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L3101",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.VisualQuestionAnsweringOutputElement"
>VisualQuestionAnsweringOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[VisualQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>aiohttp.ClientResponseError</code></p>
`}}),ca=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.example",$$slots:{default:[MM]},$$scope:{ctx:_}}}),kl=new A({props:{name:"zero_shot_classification",anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification",parameters:[{name:"text",val:": str"},{name:"candidate_labels",val:": typing.List[str]"},{name:"multi_label",val:": typing.Optional[bool] = False"},{name:"hypothesis_template",val:": typing.Optional[str] = None"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to classify.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.candidate_labels",description:`<strong>candidate_labels</strong> (<code>List[str]</code>) &#x2014;
The set of possible class labels to classify the text into.`,name:"candidate_labels"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
(deprecated) List of strings. Each string is the verbalization of a possible label for the input text.`,name:"labels"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.multi_label",description:`<strong>multi_label</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether multiple candidate labels can be true. If false, the scores are normalized such that the sum of
the label likelihoods for each sequence is 1. If true, the labels are considered independent and
probabilities are normalized for each candidate.`,name:"multi_label"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.hypothesis_template",description:`<strong>hypothesis_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The sentence used in conjunction with <code>candidate_labels</code> to attempt the text classification by
replacing the placeholder with the candidate labels.`,name:"hypothesis_template"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. If not provided, the default recommended zero-shot classification model will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L3161",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ZeroShotClassificationOutputElement"
>ZeroShotClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),pa=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.example",$$slots:{default:[bM]},$$scope:{ctx:_}}}),ga=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.example-2",$$slots:{default:[jM]},$$scope:{ctx:_}}}),ql=new A({props:{name:"zero_shot_image_classification",anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path, ForwardRef('Image'), bytearray, memoryview]"},{name:"candidate_labels",val:": typing.List[str]"},{name:"model",val:": typing.Optional[str] = None"},{name:"hypothesis_template",val:": typing.Optional[str] = None"},{name:"labels",val:": typing.List[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO, PIL.Image.Image]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, a URL to an online image, or a PIL Image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.candidate_labels",description:`<strong>candidate_labels</strong> (<code>List[str]</code>) &#x2014;
The candidate labels for this image`,name:"candidate_labels"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
(deprecated) List of string possible labels. There must be at least 2 labels.`,name:"labels"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. If not provided, the default recommended zero-shot image classification model will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.hypothesis_template",description:`<strong>hypothesis_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The sentence used in conjunction with <code>candidate_labels</code> to attempt the image classification by
replacing the placeholder with the candidate labels.`,name:"hypothesis_template"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L3269",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ZeroShotImageClassificationOutputElement"
>ZeroShotImageClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ua=new w({props:{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.example",$$slots:{default:[_M]},$$scope:{ctx:_}}}),Al=new Bi({props:{title:"InferenceTimeoutError",local:"huggingface_hub.InferenceTimeoutError",headingTag:"h2"}}),Zl=new A({props:{name:"class huggingface_hub.InferenceTimeoutError",anchor:"huggingface_hub.InferenceTimeoutError",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/errors.py#L92"}}),El=new Bi({props:{title:"InferenceAPI",local:"huggingface_hub.InferenceApi",headingTag:"h2"}}),Nl=new A({props:{name:"class huggingface_hub.InferenceApi",anchor:"huggingface_hub.InferenceApi",parameters:[{name:"repo_id",val:": str"},{name:"task",val:": typing.Optional[str] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"gpu",val:": bool = False"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference_api.py#L46"}}),ma=new w({props:{anchor:"huggingface_hub.InferenceApi.example",$$slots:{default:[IM]},$$scope:{ctx:_}}}),Gl=new A({props:{name:"__init__",anchor:"huggingface_hub.InferenceApi.__init__",parameters:[{name:"repo_id",val:": str"},{name:"task",val:": typing.Optional[str] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"gpu",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.InferenceApi.__init__.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
Id of repository (e.g. <em>user/bert-base-uncased</em>).`,name:"repo_id"},{anchor:"huggingface_hub.InferenceApi.__init__.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>, defaults <code>None</code>) &#x2014;
Whether to force a task instead of using task specified in the
repository.`,name:"task"},{anchor:"huggingface_hub.InferenceApi.__init__.token",description:`<strong>token</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The API token to use as HTTP bearer authorization. This is not
the authentication token. You can find the token in
<a href="https://huggingface.co/settings/token" rel="nofollow">https://huggingface.co/settings/token</a>. Alternatively, you can
find both your organizations and personal API tokens using
<em>HfApi().whoami(token)</em>.`,name:"token"},{anchor:"huggingface_hub.InferenceApi.__init__.gpu",description:`<strong>gpu</strong> (<em>bool</em>, <em>optional</em>, defaults <em>False</em>) &#x2014;
Whether to use GPU instead of CPU for inference(requires Startup
plan at least).`,name:"gpu"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference_api.py#L93"}}),Bl=new A({props:{name:"__call__",anchor:"huggingface_hub.InferenceApi.__call__",parameters:[{name:"inputs",val:": typing.Union[str, typing.Dict, typing.List[str], typing.List[typing.List[str]], NoneType] = None"},{name:"params",val:": typing.Optional[typing.Dict] = None"},{name:"data",val:": typing.Optional[bytes] = None"},{name:"raw_response",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.InferenceApi.__call__.inputs",description:`<strong>inputs</strong> (<code>str</code> or <code>Dict</code> or <code>List[str]</code> or <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
Inputs for the prediction.`,name:"inputs"},{anchor:"huggingface_hub.InferenceApi.__call__.params",description:`<strong>params</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Additional parameters for the models. Will be sent as <code>parameters</code> in the
payload.`,name:"params"},{anchor:"huggingface_hub.InferenceApi.__call__.data",description:`<strong>data</strong> (<code>bytes</code>, <em>optional</em>) &#x2014;
Bytes content of the request. In this case, leave <code>inputs</code> and <code>params</code> empty.`,name:"data"},{anchor:"huggingface_hub.InferenceApi.__call__.raw_response",description:`<strong>raw_response</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, the raw <code>Response</code> object is returned. You can parse its content
as preferred. By default, the content is parsed into a more practical format
(json dictionary or PIL Image for example).`,name:"raw_response"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference_api.py#L158"}}),Vl=new mf({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/package_reference/inference_client.md"}}),{c(){n=b("meta"),o=r(),t=b("p"),s=r(),g(i.$$.fragment),e=r(),p=b("p"),p.innerHTML=dm,Vi=r(),fa=b("ol"),fa.innerHTML=fm,Qi=r(),ya=b("p"),ya.innerHTML=ym,Si=r(),g(Ma.$$.fragment),Yi=r(),x=b("div"),g(ba.$$.fragment),tr=r(),Rl=b("p"),Rl.textContent=Mm,sr=r(),Xl=b("p"),Xl.innerHTML=bm,ar=r(),Be=b("div"),g(ja.$$.fragment),lr=r(),zl=b("p"),zl.textContent=jm,or=r(),g(lt.$$.fragment),ir=r(),Ve=b("div"),g(_a.$$.fragment),rr=r(),Fl=b("p"),Fl.textContent=_m,cr=r(),g(ot.$$.fragment),pr=r(),Qe=b("div"),g(Ia.$$.fragment),gr=r(),Hl=b("p"),Hl.textContent=Im,ur=r(),g(it.$$.fragment),mr=r(),Z=b("div"),g(Ta.$$.fragment),hr=r(),Ol=b("p"),Ol.textContent=Tm,dr=r(),g(rt.$$.fragment),fr=r(),g(ct.$$.fragment),yr=r(),g(pt.$$.fragment),Mr=r(),g(gt.$$.fragment),br=r(),g(ut.$$.fragment),jr=r(),Dl=b("p"),Dl.textContent=Jm,_r=r(),g(mt.$$.fragment),Ir=r(),Ll=b("p"),Ll.textContent=Um,Tr=r(),g(ht.$$.fragment),Jr=r(),g(dt.$$.fragment),Ur=r(),g(ft.$$.fragment),wr=r(),g(yt.$$.fragment),Cr=r(),Se=b("div"),g(Ja.$$.fragment),xr=r(),Pl=b("p"),Pl.textContent=wm,$r=r(),g(Mt.$$.fragment),vr=r(),Ye=b("div"),g(Ua.$$.fragment),kr=r(),Kl=b("p"),Kl.textContent=Cm,qr=r(),g(bt.$$.fragment),Ar=r(),Re=b("div"),g(wa.$$.fragment),Zr=r(),eo=b("p"),eo.textContent=xm,Er=r(),g(jt.$$.fragment),Wr=r(),se=b("div"),g(Ca.$$.fragment),Nr=r(),no=b("p"),no.textContent=$m,Gr=r(),to=b("p"),to.innerHTML=vm,Br=r(),g(_t.$$.fragment),Vr=r(),ae=b("div"),g(xa.$$.fragment),Qr=r(),so=b("p"),so.textContent=km,Sr=r(),ao=b("p"),ao.textContent=qm,Yr=r(),g(It.$$.fragment),Rr=r(),Xe=b("div"),g($a.$$.fragment),Xr=r(),lo=b("p"),lo.textContent=Am,zr=r(),g(Tt.$$.fragment),Fr=r(),le=b("div"),g(va.$$.fragment),Hr=r(),oo=b("p"),oo.textContent=Zm,Or=r(),g(Jt.$$.fragment),Dr=r(),g(Ut.$$.fragment),Lr=r(),oe=b("div"),g(ka.$$.fragment),Pr=r(),io=b("p"),io.textContent=Em,Kr=r(),g(wt.$$.fragment),ec=r(),g(Ct.$$.fragment),nc=r(),ie=b("div"),g(qa.$$.fragment),tc=r(),ro=b("p"),ro.textContent=Wm,sc=r(),co=b("p"),co.textContent=Nm,ac=r(),g(xt.$$.fragment),lc=r(),ze=b("div"),g(Aa.$$.fragment),oc=r(),po=b("p"),po.textContent=Gm,ic=r(),g($t.$$.fragment),rc=r(),re=b("div"),g(Za.$$.fragment),cc=r(),go=b("p"),go.textContent=Bm,pc=r(),g(vt.$$.fragment),gc=r(),g(kt.$$.fragment),uc=r(),Fe=b("div"),g(Ea.$$.fragment),mc=r(),uo=b("p"),uo.textContent=Vm,hc=r(),g(qt.$$.fragment),dc=r(),He=b("div"),g(Wa.$$.fragment),fc=r(),mo=b("p"),mo.textContent=Qm,yc=r(),g(At.$$.fragment),Mc=r(),Oe=b("div"),g(Na.$$.fragment),bc=r(),ho=b("p"),ho.textContent=Sm,jc=r(),g(Zt.$$.fragment),_c=r(),De=b("div"),g(Ga.$$.fragment),Ic=r(),fo=b("p"),fo.textContent=Ym,Tc=r(),g(Et.$$.fragment),Jc=r(),Le=b("div"),g(Ba.$$.fragment),Uc=r(),yo=b("p"),yo.textContent=Rm,wc=r(),g(Wt.$$.fragment),Cc=r(),Pe=b("div"),g(Va.$$.fragment),xc=r(),Mo=b("p"),Mo.textContent=Xm,$c=r(),g(Nt.$$.fragment),vc=r(),Ke=b("div"),g(Qa.$$.fragment),kc=r(),bo=b("p"),bo.textContent=zm,qc=r(),g(Gt.$$.fragment),Ac=r(),ce=b("div"),g(Sa.$$.fragment),Zc=r(),jo=b("p"),jo.textContent=Fm,Ec=r(),g(Bt.$$.fragment),Wc=r(),g(Vt.$$.fragment),Nc=r(),S=b("div"),g(Ya.$$.fragment),Gc=r(),_o=b("p"),_o.textContent=Hm,Bc=r(),g(Qt.$$.fragment),Vc=r(),g(St.$$.fragment),Qc=r(),g(Yt.$$.fragment),Sc=je(`
Example using a third-party provider directly. Usage will be billed on your fal.ai account.
`),g(Rt.$$.fragment),Yc=r(),Io=b("p"),Io.textContent=Om,Rc=r(),g(Xt.$$.fragment),Xc=r(),To=b("p"),To.textContent=Dm,zc=r(),g(zt.$$.fragment),Fc=r(),G=b("div"),g(Ra.$$.fragment),Hc=r(),Jo=b("p"),Jo.textContent=Lm,Oc=r(),g(Ft.$$.fragment),Dc=r(),g(Ht.$$.fragment),Lc=r(),Uo=b("p"),Uo.textContent=Pm,Pc=r(),g(Ot.$$.fragment),Kc=r(),wo=b("p"),wo.textContent=Km,ep=r(),g(Dt.$$.fragment),np=je(`
Example using Replicate provider with extra parameters
`),g(Lt.$$.fragment),tp=r(),Co=b("p"),Co.textContent=eh,sp=r(),g(Pt.$$.fragment),ap=r(),z=b("div"),g(Xa.$$.fragment),lp=r(),xo=b("p"),xo.textContent=nh,op=r(),g(Kt.$$.fragment),ip=r(),$o=b("p"),$o.textContent=th,rp=r(),vo=b("p"),vo.textContent=sh,cp=r(),g(es.$$.fragment),pp=r(),ko=b("p"),ko.textContent=ah,gp=r(),g(ns.$$.fragment),up=r(),en=b("div"),g(za.$$.fragment),mp=r(),qo=b("p"),qo.textContent=lh,hp=r(),g(ts.$$.fragment),dp=r(),P=b("div"),g(Fa.$$.fragment),fp=r(),Ao=b("p"),Ao.textContent=oh,yp=r(),Zo=b("p"),Zo.innerHTML=ih,Mp=r(),g(ss.$$.fragment),bp=r(),g(as.$$.fragment),jp=r(),nn=b("div"),g(Ha.$$.fragment),_p=r(),Eo=b("p"),Eo.textContent=rh,Ip=r(),g(ls.$$.fragment),Tp=r(),pe=b("div"),g(Oa.$$.fragment),Jp=r(),Wo=b("p"),Wo.textContent=ch,Up=r(),g(os.$$.fragment),wp=r(),g(is.$$.fragment),Cp=r(),tn=b("div"),g(Da.$$.fragment),xp=r(),No=b("p"),No.textContent=ph,$p=r(),g(rs.$$.fragment),Ri=r(),g(La.$$.fragment),Xi=r(),Pa=b("p"),Pa.innerHTML=gh,zi=r(),g(Ka.$$.fragment),Fi=r(),C=b("div"),g(el.$$.fragment),vp=r(),Go=b("p"),Go.textContent=uh,kp=r(),Bo=b("p"),Bo.innerHTML=mh,qp=r(),sn=b("div"),g(nl.$$.fragment),Ap=r(),Vo=b("p"),Vo.textContent=hh,Zp=r(),g(cs.$$.fragment),Ep=r(),an=b("div"),g(tl.$$.fragment),Wp=r(),Qo=b("p"),Qo.textContent=dh,Np=r(),g(ps.$$.fragment),Gp=r(),ln=b("div"),g(sl.$$.fragment),Bp=r(),So=b("p"),So.textContent=fh,Vp=r(),g(gs.$$.fragment),Qp=r(),E=b("div"),g(al.$$.fragment),Sp=r(),Yo=b("p"),Yo.textContent=yh,Yp=r(),g(us.$$.fragment),Rp=r(),g(ms.$$.fragment),Xp=r(),g(hs.$$.fragment),zp=r(),g(ds.$$.fragment),Fp=r(),g(fs.$$.fragment),Hp=r(),Ro=b("p"),Ro.textContent=Mh,Op=r(),g(ys.$$.fragment),Dp=r(),Xo=b("p"),Xo.textContent=bh,Lp=r(),g(Ms.$$.fragment),Pp=r(),g(bs.$$.fragment),Kp=r(),g(js.$$.fragment),eg=r(),g(_s.$$.fragment),ng=r(),ge=b("div"),g(ll.$$.fragment),tg=r(),zo=b("p"),zo.textContent=jh,sg=r(),Fo=b("p"),Fo.textContent=_h,ag=r(),Ho=b("p"),Ho.innerHTML=Ih,lg=r(),on=b("div"),g(ol.$$.fragment),og=r(),Oo=b("p"),Oo.textContent=Th,ig=r(),g(Is.$$.fragment),rg=r(),rn=b("div"),g(il.$$.fragment),cg=r(),Do=b("p"),Do.textContent=Jh,pg=r(),g(Ts.$$.fragment),gg=r(),cn=b("div"),g(rl.$$.fragment),ug=r(),Lo=b("p"),Lo.textContent=Uh,mg=r(),g(Js.$$.fragment),hg=r(),ue=b("div"),g(cl.$$.fragment),dg=r(),Po=b("p"),Po.textContent=wh,fg=r(),Ko=b("p"),Ko.innerHTML=Ch,yg=r(),g(Us.$$.fragment),Mg=r(),me=b("div"),g(pl.$$.fragment),bg=r(),ei=b("p"),ei.textContent=xh,jg=r(),ni=b("p"),ni.textContent=$h,_g=r(),g(ws.$$.fragment),Ig=r(),pn=b("div"),g(gl.$$.fragment),Tg=r(),ti=b("p"),ti.textContent=vh,Jg=r(),g(Cs.$$.fragment),Ug=r(),he=b("div"),g(ul.$$.fragment),wg=r(),si=b("p"),si.textContent=kh,Cg=r(),g(xs.$$.fragment),xg=r(),g($s.$$.fragment),$g=r(),de=b("div"),g(ml.$$.fragment),vg=r(),ai=b("p"),ai.textContent=qh,kg=r(),g(vs.$$.fragment),qg=r(),g(ks.$$.fragment),Ag=r(),fe=b("div"),g(hl.$$.fragment),Zg=r(),li=b("p"),li.textContent=Ah,Eg=r(),oi=b("p"),oi.textContent=Zh,Wg=r(),g(qs.$$.fragment),Ng=r(),gn=b("div"),g(dl.$$.fragment),Gg=r(),ii=b("p"),ii.textContent=Eh,Bg=r(),g(As.$$.fragment),Vg=r(),ye=b("div"),g(fl.$$.fragment),Qg=r(),ri=b("p"),ri.textContent=Wh,Sg=r(),g(Zs.$$.fragment),Yg=r(),g(Es.$$.fragment),Rg=r(),un=b("div"),g(yl.$$.fragment),Xg=r(),ci=b("p"),ci.textContent=Nh,zg=r(),g(Ws.$$.fragment),Fg=r(),mn=b("div"),g(Ml.$$.fragment),Hg=r(),pi=b("p"),pi.textContent=Gh,Og=r(),g(Ns.$$.fragment),Dg=r(),hn=b("div"),g(bl.$$.fragment),Lg=r(),gi=b("p"),gi.textContent=Bh,Pg=r(),g(Gs.$$.fragment),Kg=r(),dn=b("div"),g(jl.$$.fragment),eu=r(),ui=b("p"),ui.textContent=Vh,nu=r(),g(Bs.$$.fragment),tu=r(),fn=b("div"),g(_l.$$.fragment),su=r(),mi=b("p"),mi.textContent=Qh,au=r(),g(Vs.$$.fragment),lu=r(),yn=b("div"),g(Il.$$.fragment),ou=r(),hi=b("p"),hi.textContent=Sh,iu=r(),g(Qs.$$.fragment),ru=r(),Mn=b("div"),g(Tl.$$.fragment),cu=r(),di=b("p"),di.textContent=Yh,pu=r(),g(Ss.$$.fragment),gu=r(),Me=b("div"),g(Jl.$$.fragment),uu=r(),fi=b("p"),fi.textContent=Rh,mu=r(),g(Ys.$$.fragment),hu=r(),g(Rs.$$.fragment),du=r(),Y=b("div"),g(Ul.$$.fragment),fu=r(),yi=b("p"),yi.textContent=Xh,yu=r(),g(Xs.$$.fragment),Mu=r(),g(zs.$$.fragment),bu=r(),g(Fs.$$.fragment),ju=je(`
Example using a third-party provider directly. Usage will be billed on your fal.ai account.
`),g(Hs.$$.fragment),_u=r(),Mi=b("p"),Mi.textContent=zh,Iu=r(),g(Os.$$.fragment),Tu=r(),bi=b("p"),bi.textContent=Fh,Ju=r(),g(Ds.$$.fragment),Uu=r(),B=b("div"),g(wl.$$.fragment),wu=r(),ji=b("p"),ji.textContent=Hh,Cu=r(),g(Ls.$$.fragment),xu=r(),g(Ps.$$.fragment),$u=r(),_i=b("p"),_i.textContent=Oh,vu=r(),g(Ks.$$.fragment),ku=r(),Ii=b("p"),Ii.textContent=Dh,qu=r(),g(ea.$$.fragment),Au=je(`
Example using Replicate provider with extra parameters
`),g(na.$$.fragment),Zu=r(),Ti=b("p"),Ti.textContent=Lh,Eu=r(),g(ta.$$.fragment),Wu=r(),F=b("div"),g(Cl.$$.fragment),Nu=r(),Ji=b("p"),Ji.textContent=Ph,Gu=r(),g(sa.$$.fragment),Bu=r(),Ui=b("p"),Ui.textContent=Kh,Vu=r(),wi=b("p"),wi.textContent=ed,Qu=r(),g(aa.$$.fragment),Su=r(),Ci=b("p"),Ci.textContent=nd,Yu=r(),g(la.$$.fragment),Ru=r(),bn=b("div"),g(xl.$$.fragment),Xu=r(),xi=b("p"),xi.textContent=td,zu=r(),g(oa.$$.fragment),Fu=r(),K=b("div"),g($l.$$.fragment),Hu=r(),$i=b("p"),$i.textContent=sd,Ou=r(),vi=b("p"),vi.innerHTML=ad,Du=r(),g(ia.$$.fragment),Lu=r(),g(ra.$$.fragment),Pu=r(),jn=b("div"),g(vl.$$.fragment),Ku=r(),ki=b("p"),ki.textContent=ld,em=r(),g(ca.$$.fragment),nm=r(),be=b("div"),g(kl.$$.fragment),tm=r(),qi=b("p"),qi.textContent=od,sm=r(),g(pa.$$.fragment),am=r(),g(ga.$$.fragment),lm=r(),_n=b("div"),g(ql.$$.fragment),om=r(),Ai=b("p"),Ai.textContent=id,im=r(),g(ua.$$.fragment),Hi=r(),g(Al.$$.fragment),Oi=r(),In=b("div"),g(Zl.$$.fragment),rm=r(),Zi=b("p"),Zi.textContent=rd,Di=r(),g(El.$$.fragment),Li=r(),Wl=b("p"),Wl.innerHTML=cd,Pi=r(),L=b("div"),g(Nl.$$.fragment),cm=r(),Ei=b("p"),Ei.textContent=pd,pm=r(),g(ma.$$.fragment),gm=r(),ha=b("div"),g(Gl.$$.fragment),um=r(),Wi=b("p"),Wi.textContent=gd,mm=r(),da=b("div"),g(Bl.$$.fragment),hm=r(),Ni=b("p"),Ni.textContent=ud,Ki=r(),g(Vl.$$.fragment),er=r(),Gi=b("p"),this.h()},l(a){const y=uf("svelte-u9bgzb",document.head);n=j(y,"META",{name:!0,content:!0}),y.forEach(M),o=c(a),t=j(a,"P",{}),k(t).forEach(M),s=c(a),u(i.$$.fragment,a),e=c(a),p=j(a,"P",{"data-svelte-h":!0}),T(p)!=="svelte-zsbuba"&&(p.innerHTML=dm),Vi=c(a),fa=j(a,"OL",{"data-svelte-h":!0}),T(fa)!=="svelte-113kt9p"&&(fa.innerHTML=fm),Qi=c(a),ya=j(a,"P",{"data-svelte-h":!0}),T(ya)!=="svelte-s9duup"&&(ya.innerHTML=ym),Si=c(a),u(Ma.$$.fragment,a),Yi=c(a),x=j(a,"DIV",{class:!0});var v=k(x);u(ba.$$.fragment,v),tr=c(v),Rl=j(v,"P",{"data-svelte-h":!0}),T(Rl)!=="svelte-1p4u01l"&&(Rl.textContent=Mm),sr=c(v),Xl=j(v,"P",{"data-svelte-h":!0}),T(Xl)!=="svelte-1pw8cnp"&&(Xl.innerHTML=bm),ar=c(v),Be=j(v,"DIV",{class:!0});var Tn=k(Be);u(ja.$$.fragment,Tn),lr=c(Tn),zl=j(Tn,"P",{"data-svelte-h":!0}),T(zl)!=="svelte-1hs5qib"&&(zl.textContent=jm),or=c(Tn),u(lt.$$.fragment,Tn),Tn.forEach(M),ir=c(v),Ve=j(v,"DIV",{class:!0});var Jn=k(Ve);u(_a.$$.fragment,Jn),rr=c(Jn),Fl=j(Jn,"P",{"data-svelte-h":!0}),T(Fl)!=="svelte-z9e742"&&(Fl.textContent=_m),cr=c(Jn),u(ot.$$.fragment,Jn),Jn.forEach(M),pr=c(v),Qe=j(v,"DIV",{class:!0});var Un=k(Qe);u(Ia.$$.fragment,Un),gr=c(Un),Hl=j(Un,"P",{"data-svelte-h":!0}),T(Hl)!=="svelte-lahnll"&&(Hl.textContent=Im),ur=c(Un),u(it.$$.fragment,Un),Un.forEach(M),mr=c(v),Z=j(v,"DIV",{class:!0});var W=k(Z);u(Ta.$$.fragment,W),hr=c(W),Ol=j(W,"P",{"data-svelte-h":!0}),T(Ol)!=="svelte-5o70yf"&&(Ol.textContent=Tm),dr=c(W),u(rt.$$.fragment,W),fr=c(W),u(ct.$$.fragment,W),yr=c(W),u(pt.$$.fragment,W),Mr=c(W),u(gt.$$.fragment,W),br=c(W),u(ut.$$.fragment,W),jr=c(W),Dl=j(W,"P",{"data-svelte-h":!0}),T(Dl)!=="svelte-m78oie"&&(Dl.textContent=Jm),_r=c(W),u(mt.$$.fragment,W),Ir=c(W),Ll=j(W,"P",{"data-svelte-h":!0}),T(Ll)!=="svelte-gzqu78"&&(Ll.textContent=Um),Tr=c(W),u(ht.$$.fragment,W),Jr=c(W),u(dt.$$.fragment,W),Ur=c(W),u(ft.$$.fragment,W),wr=c(W),u(yt.$$.fragment,W),W.forEach(M),Cr=c(v),Se=j(v,"DIV",{class:!0});var wn=k(Se);u(Ja.$$.fragment,wn),xr=c(wn),Pl=j(wn,"P",{"data-svelte-h":!0}),T(Pl)!=="svelte-qs8cmr"&&(Pl.textContent=wm),$r=c(wn),u(Mt.$$.fragment,wn),wn.forEach(M),vr=c(v),Ye=j(v,"DIV",{class:!0});var Cn=k(Ye);u(Ua.$$.fragment,Cn),kr=c(Cn),Kl=j(Cn,"P",{"data-svelte-h":!0}),T(Kl)!=="svelte-1axtrg9"&&(Kl.textContent=Cm),qr=c(Cn),u(bt.$$.fragment,Cn),Cn.forEach(M),Ar=c(v),Re=j(v,"DIV",{class:!0});var xn=k(Re);u(wa.$$.fragment,xn),Zr=c(xn),eo=j(xn,"P",{"data-svelte-h":!0}),T(eo)!=="svelte-1lnjtsz"&&(eo.textContent=xm),Er=c(xn),u(jt.$$.fragment,xn),xn.forEach(M),Wr=c(v),se=j(v,"DIV",{class:!0});var Ie=k(se);u(Ca.$$.fragment,Ie),Nr=c(Ie),no=j(Ie,"P",{"data-svelte-h":!0}),T(no)!=="svelte-s2la9t"&&(no.textContent=$m),Gr=c(Ie),to=j(Ie,"P",{"data-svelte-h":!0}),T(to)!=="svelte-1xhka28"&&(to.innerHTML=vm),Br=c(Ie),u(_t.$$.fragment,Ie),Ie.forEach(M),Vr=c(v),ae=j(v,"DIV",{class:!0});var Te=k(ae);u(xa.$$.fragment,Te),Qr=c(Te),so=j(Te,"P",{"data-svelte-h":!0}),T(so)!=="svelte-1m9sgvu"&&(so.textContent=km),Sr=c(Te),ao=j(Te,"P",{"data-svelte-h":!0}),T(ao)!=="svelte-j9r8wf"&&(ao.textContent=qm),Yr=c(Te),u(It.$$.fragment,Te),Te.forEach(M),Rr=c(v),Xe=j(v,"DIV",{class:!0});var $n=k(Xe);u($a.$$.fragment,$n),Xr=c($n),lo=j($n,"P",{"data-svelte-h":!0}),T(lo)!=="svelte-u63854"&&(lo.textContent=Am),zr=c($n),u(Tt.$$.fragment,$n),$n.forEach(M),Fr=c(v),le=j(v,"DIV",{class:!0});var Je=k(le);u(va.$$.fragment,Je),Hr=c(Je),oo=j(Je,"P",{"data-svelte-h":!0}),T(oo)!=="svelte-k6f11e"&&(oo.textContent=Zm),Or=c(Je),u(Jt.$$.fragment,Je),Dr=c(Je),u(Ut.$$.fragment,Je),Je.forEach(M),Lr=c(v),oe=j(v,"DIV",{class:!0});var Ue=k(oe);u(ka.$$.fragment,Ue),Pr=c(Ue),io=j(Ue,"P",{"data-svelte-h":!0}),T(io)!=="svelte-7cx5l1"&&(io.textContent=Em),Kr=c(Ue),u(wt.$$.fragment,Ue),ec=c(Ue),u(Ct.$$.fragment,Ue),Ue.forEach(M),nc=c(v),ie=j(v,"DIV",{class:!0});var we=k(ie);u(qa.$$.fragment,we),tc=c(we),ro=j(we,"P",{"data-svelte-h":!0}),T(ro)!=="svelte-1tnfouk"&&(ro.textContent=Wm),sc=c(we),co=j(we,"P",{"data-svelte-h":!0}),T(co)!=="svelte-qrqo93"&&(co.textContent=Nm),ac=c(we),u(xt.$$.fragment,we),we.forEach(M),lc=c(v),ze=j(v,"DIV",{class:!0});var vn=k(ze);u(Aa.$$.fragment,vn),oc=c(vn),po=j(vn,"P",{"data-svelte-h":!0}),T(po)!=="svelte-1fbad7h"&&(po.textContent=Gm),ic=c(vn),u($t.$$.fragment,vn),vn.forEach(M),rc=c(v),re=j(v,"DIV",{class:!0});var Ce=k(re);u(Za.$$.fragment,Ce),cc=c(Ce),go=j(Ce,"P",{"data-svelte-h":!0}),T(go)!=="svelte-fzfwfh"&&(go.textContent=Bm),pc=c(Ce),u(vt.$$.fragment,Ce),gc=c(Ce),u(kt.$$.fragment,Ce),Ce.forEach(M),uc=c(v),Fe=j(v,"DIV",{class:!0});var kn=k(Fe);u(Ea.$$.fragment,kn),mc=c(kn),uo=j(kn,"P",{"data-svelte-h":!0}),T(uo)!=="svelte-1mibg86"&&(uo.textContent=Vm),hc=c(kn),u(qt.$$.fragment,kn),kn.forEach(M),dc=c(v),He=j(v,"DIV",{class:!0});var qn=k(He);u(Wa.$$.fragment,qn),fc=c(qn),mo=j(qn,"P",{"data-svelte-h":!0}),T(mo)!=="svelte-1nuhgbh"&&(mo.textContent=Qm),yc=c(qn),u(At.$$.fragment,qn),qn.forEach(M),Mc=c(v),Oe=j(v,"DIV",{class:!0});var An=k(Oe);u(Na.$$.fragment,An),bc=c(An),ho=j(An,"P",{"data-svelte-h":!0}),T(ho)!=="svelte-1uepm2o"&&(ho.textContent=Sm),jc=c(An),u(Zt.$$.fragment,An),An.forEach(M),_c=c(v),De=j(v,"DIV",{class:!0});var Zn=k(De);u(Ga.$$.fragment,Zn),Ic=c(Zn),fo=j(Zn,"P",{"data-svelte-h":!0}),T(fo)!=="svelte-77a94i"&&(fo.textContent=Ym),Tc=c(Zn),u(Et.$$.fragment,Zn),Zn.forEach(M),Jc=c(v),Le=j(v,"DIV",{class:!0});var En=k(Le);u(Ba.$$.fragment,En),Uc=c(En),yo=j(En,"P",{"data-svelte-h":!0}),T(yo)!=="svelte-61sxmo"&&(yo.textContent=Rm),wc=c(En),u(Wt.$$.fragment,En),En.forEach(M),Cc=c(v),Pe=j(v,"DIV",{class:!0});var Wn=k(Pe);u(Va.$$.fragment,Wn),xc=c(Wn),Mo=j(Wn,"P",{"data-svelte-h":!0}),T(Mo)!=="svelte-hzldyu"&&(Mo.textContent=Xm),$c=c(Wn),u(Nt.$$.fragment,Wn),Wn.forEach(M),vc=c(v),Ke=j(v,"DIV",{class:!0});var Nn=k(Ke);u(Qa.$$.fragment,Nn),kc=c(Nn),bo=j(Nn,"P",{"data-svelte-h":!0}),T(bo)!=="svelte-b4yzyj"&&(bo.textContent=zm),qc=c(Nn),u(Gt.$$.fragment,Nn),Nn.forEach(M),Ac=c(v),ce=j(v,"DIV",{class:!0});var xe=k(ce);u(Sa.$$.fragment,xe),Zc=c(xe),jo=j(xe,"P",{"data-svelte-h":!0}),T(jo)!=="svelte-qakvx8"&&(jo.textContent=Fm),Ec=c(xe),u(Bt.$$.fragment,xe),Wc=c(xe),u(Vt.$$.fragment,xe),xe.forEach(M),Nc=c(v),S=j(v,"DIV",{class:!0});var R=k(S);u(Ya.$$.fragment,R),Gc=c(R),_o=j(R,"P",{"data-svelte-h":!0}),T(_o)!=="svelte-9lmcnw"&&(_o.textContent=Hm),Bc=c(R),u(Qt.$$.fragment,R),Vc=c(R),u(St.$$.fragment,R),Qc=c(R),u(Yt.$$.fragment,R),Sc=_e(R,`
Example using a third-party provider directly. Usage will be billed on your fal.ai account.
`),u(Rt.$$.fragment,R),Yc=c(R),Io=j(R,"P",{"data-svelte-h":!0}),T(Io)!=="svelte-gzqu78"&&(Io.textContent=Om),Rc=c(R),u(Xt.$$.fragment,R),Xc=c(R),To=j(R,"P",{"data-svelte-h":!0}),T(To)!=="svelte-q7xnhs"&&(To.textContent=Dm),zc=c(R),u(zt.$$.fragment,R),R.forEach(M),Fc=c(v),G=j(v,"DIV",{class:!0});var V=k(G);u(Ra.$$.fragment,V),Hc=c(V),Jo=j(V,"P",{"data-svelte-h":!0}),T(Jo)!=="svelte-12mjzdy"&&(Jo.textContent=Lm),Oc=c(V),u(Ft.$$.fragment,V),Dc=c(V),u(Ht.$$.fragment,V),Lc=c(V),Uo=j(V,"P",{"data-svelte-h":!0}),T(Uo)!=="svelte-6wr902"&&(Uo.textContent=Pm),Pc=c(V),u(Ot.$$.fragment,V),Kc=c(V),wo=j(V,"P",{"data-svelte-h":!0}),T(wo)!=="svelte-gzqu78"&&(wo.textContent=Km),ep=c(V),u(Dt.$$.fragment,V),np=_e(V,`
Example using Replicate provider with extra parameters
`),u(Lt.$$.fragment,V),tp=c(V),Co=j(V,"P",{"data-svelte-h":!0}),T(Co)!=="svelte-ecr35g"&&(Co.textContent=eh),sp=c(V),u(Pt.$$.fragment,V),V.forEach(M),ap=c(v),z=j(v,"DIV",{class:!0});var O=k(z);u(Xa.$$.fragment,O),lp=c(O),xo=j(O,"P",{"data-svelte-h":!0}),T(xo)!=="svelte-17lryks"&&(xo.textContent=nh),op=c(O),u(Kt.$$.fragment,O),ip=c(O),$o=j(O,"P",{"data-svelte-h":!0}),T($o)!=="svelte-11lpom8"&&($o.textContent=th),rp=c(O),vo=j(O,"P",{"data-svelte-h":!0}),T(vo)!=="svelte-vt1ppo"&&(vo.textContent=sh),cp=c(O),u(es.$$.fragment,O),pp=c(O),ko=j(O,"P",{"data-svelte-h":!0}),T(ko)!=="svelte-gzqu78"&&(ko.textContent=ah),gp=c(O),u(ns.$$.fragment,O),O.forEach(M),up=c(v),en=j(v,"DIV",{class:!0});var Gn=k(en);u(za.$$.fragment,Gn),mp=c(Gn),qo=j(Gn,"P",{"data-svelte-h":!0}),T(qo)!=="svelte-1araal"&&(qo.textContent=lh),hp=c(Gn),u(ts.$$.fragment,Gn),Gn.forEach(M),dp=c(v),P=j(v,"DIV",{class:!0});var ee=k(P);u(Fa.$$.fragment,ee),fp=c(ee),Ao=j(ee,"P",{"data-svelte-h":!0}),T(Ao)!=="svelte-1v3lqck"&&(Ao.textContent=oh),yp=c(ee),Zo=j(ee,"P",{"data-svelte-h":!0}),T(Zo)!=="svelte-jwmjgr"&&(Zo.innerHTML=ih),Mp=c(ee),u(ss.$$.fragment,ee),bp=c(ee),u(as.$$.fragment,ee),ee.forEach(M),jp=c(v),nn=j(v,"DIV",{class:!0});var Bn=k(nn);u(Ha.$$.fragment,Bn),_p=c(Bn),Eo=j(Bn,"P",{"data-svelte-h":!0}),T(Eo)!=="svelte-1jbp6ey"&&(Eo.textContent=rh),Ip=c(Bn),u(ls.$$.fragment,Bn),Bn.forEach(M),Tp=c(v),pe=j(v,"DIV",{class:!0});var $e=k(pe);u(Oa.$$.fragment,$e),Jp=c($e),Wo=j($e,"P",{"data-svelte-h":!0}),T(Wo)!=="svelte-1c9xuqj"&&(Wo.textContent=ch),Up=c($e),u(os.$$.fragment,$e),wp=c($e),u(is.$$.fragment,$e),$e.forEach(M),Cp=c(v),tn=j(v,"DIV",{class:!0});var Vn=k(tn);u(Da.$$.fragment,Vn),xp=c(Vn),No=j(Vn,"P",{"data-svelte-h":!0}),T(No)!=="svelte-108ipf8"&&(No.textContent=ph),$p=c(Vn),u(rs.$$.fragment,Vn),Vn.forEach(M),v.forEach(M),Ri=c(a),u(La.$$.fragment,a),Xi=c(a),Pa=j(a,"P",{"data-svelte-h":!0}),T(Pa)!=="svelte-nn0rvx"&&(Pa.innerHTML=gh),zi=c(a),u(Ka.$$.fragment,a),Fi=c(a),C=j(a,"DIV",{class:!0});var $=k(C);u(el.$$.fragment,$),vp=c($),Go=j($,"P",{"data-svelte-h":!0}),T(Go)!=="svelte-1p4u01l"&&(Go.textContent=uh),kp=c($),Bo=j($,"P",{"data-svelte-h":!0}),T(Bo)!=="svelte-1pw8cnp"&&(Bo.innerHTML=mh),qp=c($),sn=j($,"DIV",{class:!0});var Qn=k(sn);u(nl.$$.fragment,Qn),Ap=c(Qn),Vo=j(Qn,"P",{"data-svelte-h":!0}),T(Vo)!=="svelte-1hs5qib"&&(Vo.textContent=hh),Zp=c(Qn),u(cs.$$.fragment,Qn),Qn.forEach(M),Ep=c($),an=j($,"DIV",{class:!0});var Sn=k(an);u(tl.$$.fragment,Sn),Wp=c(Sn),Qo=j(Sn,"P",{"data-svelte-h":!0}),T(Qo)!=="svelte-z9e742"&&(Qo.textContent=dh),Np=c(Sn),u(ps.$$.fragment,Sn),Sn.forEach(M),Gp=c($),ln=j($,"DIV",{class:!0});var Yn=k(ln);u(sl.$$.fragment,Yn),Bp=c(Yn),So=j(Yn,"P",{"data-svelte-h":!0}),T(So)!=="svelte-lahnll"&&(So.textContent=fh),Vp=c(Yn),u(gs.$$.fragment,Yn),Yn.forEach(M),Qp=c($),E=j($,"DIV",{class:!0});var N=k(E);u(al.$$.fragment,N),Sp=c(N),Yo=j(N,"P",{"data-svelte-h":!0}),T(Yo)!=="svelte-5o70yf"&&(Yo.textContent=yh),Yp=c(N),u(us.$$.fragment,N),Rp=c(N),u(ms.$$.fragment,N),Xp=c(N),u(hs.$$.fragment,N),zp=c(N),u(ds.$$.fragment,N),Fp=c(N),u(fs.$$.fragment,N),Hp=c(N),Ro=j(N,"P",{"data-svelte-h":!0}),T(Ro)!=="svelte-m78oie"&&(Ro.textContent=Mh),Op=c(N),u(ys.$$.fragment,N),Dp=c(N),Xo=j(N,"P",{"data-svelte-h":!0}),T(Xo)!=="svelte-gzqu78"&&(Xo.textContent=bh),Lp=c(N),u(Ms.$$.fragment,N),Pp=c(N),u(bs.$$.fragment,N),Kp=c(N),u(js.$$.fragment,N),eg=c(N),u(_s.$$.fragment,N),N.forEach(M),ng=c($),ge=j($,"DIV",{class:!0});var ve=k(ge);u(ll.$$.fragment,ve),tg=c(ve),zo=j(ve,"P",{"data-svelte-h":!0}),T(zo)!=="svelte-vcr7iw"&&(zo.textContent=jh),sg=c(ve),Fo=j(ve,"P",{"data-svelte-h":!0}),T(Fo)!=="svelte-1jtca0b"&&(Fo.textContent=_h),ag=c(ve),Ho=j(ve,"P",{"data-svelte-h":!0}),T(Ho)!=="svelte-1sz3ulv"&&(Ho.innerHTML=Ih),ve.forEach(M),lg=c($),on=j($,"DIV",{class:!0});var Rn=k(on);u(ol.$$.fragment,Rn),og=c(Rn),Oo=j(Rn,"P",{"data-svelte-h":!0}),T(Oo)!=="svelte-qs8cmr"&&(Oo.textContent=Th),ig=c(Rn),u(Is.$$.fragment,Rn),Rn.forEach(M),rg=c($),rn=j($,"DIV",{class:!0});var Xn=k(rn);u(il.$$.fragment,Xn),cg=c(Xn),Do=j(Xn,"P",{"data-svelte-h":!0}),T(Do)!=="svelte-1axtrg9"&&(Do.textContent=Jh),pg=c(Xn),u(Ts.$$.fragment,Xn),Xn.forEach(M),gg=c($),cn=j($,"DIV",{class:!0});var zn=k(cn);u(rl.$$.fragment,zn),ug=c(zn),Lo=j(zn,"P",{"data-svelte-h":!0}),T(Lo)!=="svelte-1lnjtsz"&&(Lo.textContent=Uh),mg=c(zn),u(Js.$$.fragment,zn),zn.forEach(M),hg=c($),ue=j($,"DIV",{class:!0});var ke=k(ue);u(cl.$$.fragment,ke),dg=c(ke),Po=j(ke,"P",{"data-svelte-h":!0}),T(Po)!=="svelte-s2la9t"&&(Po.textContent=wh),fg=c(ke),Ko=j(ke,"P",{"data-svelte-h":!0}),T(Ko)!=="svelte-1xhka28"&&(Ko.innerHTML=Ch),yg=c(ke),u(Us.$$.fragment,ke),ke.forEach(M),Mg=c($),me=j($,"DIV",{class:!0});var qe=k(me);u(pl.$$.fragment,qe),bg=c(qe),ei=j(qe,"P",{"data-svelte-h":!0}),T(ei)!=="svelte-1m9sgvu"&&(ei.textContent=xh),jg=c(qe),ni=j(qe,"P",{"data-svelte-h":!0}),T(ni)!=="svelte-j9r8wf"&&(ni.textContent=$h),_g=c(qe),u(ws.$$.fragment,qe),qe.forEach(M),Ig=c($),pn=j($,"DIV",{class:!0});var Fn=k(pn);u(gl.$$.fragment,Fn),Tg=c(Fn),ti=j(Fn,"P",{"data-svelte-h":!0}),T(ti)!=="svelte-u63854"&&(ti.textContent=vh),Jg=c(Fn),u(Cs.$$.fragment,Fn),Fn.forEach(M),Ug=c($),he=j($,"DIV",{class:!0});var Ae=k(he);u(ul.$$.fragment,Ae),wg=c(Ae),si=j(Ae,"P",{"data-svelte-h":!0}),T(si)!=="svelte-k6f11e"&&(si.textContent=kh),Cg=c(Ae),u(xs.$$.fragment,Ae),xg=c(Ae),u($s.$$.fragment,Ae),Ae.forEach(M),$g=c($),de=j($,"DIV",{class:!0});var Ze=k(de);u(ml.$$.fragment,Ze),vg=c(Ze),ai=j(Ze,"P",{"data-svelte-h":!0}),T(ai)!=="svelte-7cx5l1"&&(ai.textContent=qh),kg=c(Ze),u(vs.$$.fragment,Ze),qg=c(Ze),u(ks.$$.fragment,Ze),Ze.forEach(M),Ag=c($),fe=j($,"DIV",{class:!0});var Ee=k(fe);u(hl.$$.fragment,Ee),Zg=c(Ee),li=j(Ee,"P",{"data-svelte-h":!0}),T(li)!=="svelte-1tnfouk"&&(li.textContent=Ah),Eg=c(Ee),oi=j(Ee,"P",{"data-svelte-h":!0}),T(oi)!=="svelte-qrqo93"&&(oi.textContent=Zh),Wg=c(Ee),u(qs.$$.fragment,Ee),Ee.forEach(M),Ng=c($),gn=j($,"DIV",{class:!0});var Hn=k(gn);u(dl.$$.fragment,Hn),Gg=c(Hn),ii=j(Hn,"P",{"data-svelte-h":!0}),T(ii)!=="svelte-1fbad7h"&&(ii.textContent=Eh),Bg=c(Hn),u(As.$$.fragment,Hn),Hn.forEach(M),Vg=c($),ye=j($,"DIV",{class:!0});var We=k(ye);u(fl.$$.fragment,We),Qg=c(We),ri=j(We,"P",{"data-svelte-h":!0}),T(ri)!=="svelte-fzfwfh"&&(ri.textContent=Wh),Sg=c(We),u(Zs.$$.fragment,We),Yg=c(We),u(Es.$$.fragment,We),We.forEach(M),Rg=c($),un=j($,"DIV",{class:!0});var On=k(un);u(yl.$$.fragment,On),Xg=c(On),ci=j(On,"P",{"data-svelte-h":!0}),T(ci)!=="svelte-1mibg86"&&(ci.textContent=Nh),zg=c(On),u(Ws.$$.fragment,On),On.forEach(M),Fg=c($),mn=j($,"DIV",{class:!0});var Dn=k(mn);u(Ml.$$.fragment,Dn),Hg=c(Dn),pi=j(Dn,"P",{"data-svelte-h":!0}),T(pi)!=="svelte-1nuhgbh"&&(pi.textContent=Gh),Og=c(Dn),u(Ns.$$.fragment,Dn),Dn.forEach(M),Dg=c($),hn=j($,"DIV",{class:!0});var Ln=k(hn);u(bl.$$.fragment,Ln),Lg=c(Ln),gi=j(Ln,"P",{"data-svelte-h":!0}),T(gi)!=="svelte-1uepm2o"&&(gi.textContent=Bh),Pg=c(Ln),u(Gs.$$.fragment,Ln),Ln.forEach(M),Kg=c($),dn=j($,"DIV",{class:!0});var Pn=k(dn);u(jl.$$.fragment,Pn),eu=c(Pn),ui=j(Pn,"P",{"data-svelte-h":!0}),T(ui)!=="svelte-77a94i"&&(ui.textContent=Vh),nu=c(Pn),u(Bs.$$.fragment,Pn),Pn.forEach(M),tu=c($),fn=j($,"DIV",{class:!0});var Kn=k(fn);u(_l.$$.fragment,Kn),su=c(Kn),mi=j(Kn,"P",{"data-svelte-h":!0}),T(mi)!=="svelte-61sxmo"&&(mi.textContent=Qh),au=c(Kn),u(Vs.$$.fragment,Kn),Kn.forEach(M),lu=c($),yn=j($,"DIV",{class:!0});var et=k(yn);u(Il.$$.fragment,et),ou=c(et),hi=j(et,"P",{"data-svelte-h":!0}),T(hi)!=="svelte-hzldyu"&&(hi.textContent=Sh),iu=c(et),u(Qs.$$.fragment,et),et.forEach(M),ru=c($),Mn=j($,"DIV",{class:!0});var nt=k(Mn);u(Tl.$$.fragment,nt),cu=c(nt),di=j(nt,"P",{"data-svelte-h":!0}),T(di)!=="svelte-b4yzyj"&&(di.textContent=Yh),pu=c(nt),u(Ss.$$.fragment,nt),nt.forEach(M),gu=c($),Me=j($,"DIV",{class:!0});var Ne=k(Me);u(Jl.$$.fragment,Ne),uu=c(Ne),fi=j(Ne,"P",{"data-svelte-h":!0}),T(fi)!=="svelte-qakvx8"&&(fi.textContent=Rh),mu=c(Ne),u(Ys.$$.fragment,Ne),hu=c(Ne),u(Rs.$$.fragment,Ne),Ne.forEach(M),du=c($),Y=j($,"DIV",{class:!0});var X=k(Y);u(Ul.$$.fragment,X),fu=c(X),yi=j(X,"P",{"data-svelte-h":!0}),T(yi)!=="svelte-9lmcnw"&&(yi.textContent=Xh),yu=c(X),u(Xs.$$.fragment,X),Mu=c(X),u(zs.$$.fragment,X),bu=c(X),u(Fs.$$.fragment,X),ju=_e(X,`
Example using a third-party provider directly. Usage will be billed on your fal.ai account.
`),u(Hs.$$.fragment,X),_u=c(X),Mi=j(X,"P",{"data-svelte-h":!0}),T(Mi)!=="svelte-gzqu78"&&(Mi.textContent=zh),Iu=c(X),u(Os.$$.fragment,X),Tu=c(X),bi=j(X,"P",{"data-svelte-h":!0}),T(bi)!=="svelte-q7xnhs"&&(bi.textContent=Fh),Ju=c(X),u(Ds.$$.fragment,X),X.forEach(M),Uu=c($),B=j($,"DIV",{class:!0});var Q=k(B);u(wl.$$.fragment,Q),wu=c(Q),ji=j(Q,"P",{"data-svelte-h":!0}),T(ji)!=="svelte-12mjzdy"&&(ji.textContent=Hh),Cu=c(Q),u(Ls.$$.fragment,Q),xu=c(Q),u(Ps.$$.fragment,Q),$u=c(Q),_i=j(Q,"P",{"data-svelte-h":!0}),T(_i)!=="svelte-6wr902"&&(_i.textContent=Oh),vu=c(Q),u(Ks.$$.fragment,Q),ku=c(Q),Ii=j(Q,"P",{"data-svelte-h":!0}),T(Ii)!=="svelte-gzqu78"&&(Ii.textContent=Dh),qu=c(Q),u(ea.$$.fragment,Q),Au=_e(Q,`
Example using Replicate provider with extra parameters
`),u(na.$$.fragment,Q),Zu=c(Q),Ti=j(Q,"P",{"data-svelte-h":!0}),T(Ti)!=="svelte-ecr35g"&&(Ti.textContent=Lh),Eu=c(Q),u(ta.$$.fragment,Q),Q.forEach(M),Wu=c($),F=j($,"DIV",{class:!0});var D=k(F);u(Cl.$$.fragment,D),Nu=c(D),Ji=j(D,"P",{"data-svelte-h":!0}),T(Ji)!=="svelte-17lryks"&&(Ji.textContent=Ph),Gu=c(D),u(sa.$$.fragment,D),Bu=c(D),Ui=j(D,"P",{"data-svelte-h":!0}),T(Ui)!=="svelte-11lpom8"&&(Ui.textContent=Kh),Vu=c(D),wi=j(D,"P",{"data-svelte-h":!0}),T(wi)!=="svelte-vt1ppo"&&(wi.textContent=ed),Qu=c(D),u(aa.$$.fragment,D),Su=c(D),Ci=j(D,"P",{"data-svelte-h":!0}),T(Ci)!=="svelte-gzqu78"&&(Ci.textContent=nd),Yu=c(D),u(la.$$.fragment,D),D.forEach(M),Ru=c($),bn=j($,"DIV",{class:!0});var tt=k(bn);u(xl.$$.fragment,tt),Xu=c(tt),xi=j(tt,"P",{"data-svelte-h":!0}),T(xi)!=="svelte-1araal"&&(xi.textContent=td),zu=c(tt),u(oa.$$.fragment,tt),tt.forEach(M),Fu=c($),K=j($,"DIV",{class:!0});var ne=k(K);u($l.$$.fragment,ne),Hu=c(ne),$i=j(ne,"P",{"data-svelte-h":!0}),T($i)!=="svelte-1v3lqck"&&($i.textContent=sd),Ou=c(ne),vi=j(ne,"P",{"data-svelte-h":!0}),T(vi)!=="svelte-jwmjgr"&&(vi.innerHTML=ad),Du=c(ne),u(ia.$$.fragment,ne),Lu=c(ne),u(ra.$$.fragment,ne),ne.forEach(M),Pu=c($),jn=j($,"DIV",{class:!0});var st=k(jn);u(vl.$$.fragment,st),Ku=c(st),ki=j(st,"P",{"data-svelte-h":!0}),T(ki)!=="svelte-1jbp6ey"&&(ki.textContent=ld),em=c(st),u(ca.$$.fragment,st),st.forEach(M),nm=c($),be=j($,"DIV",{class:!0});var Ge=k(be);u(kl.$$.fragment,Ge),tm=c(Ge),qi=j(Ge,"P",{"data-svelte-h":!0}),T(qi)!=="svelte-1c9xuqj"&&(qi.textContent=od),sm=c(Ge),u(pa.$$.fragment,Ge),am=c(Ge),u(ga.$$.fragment,Ge),Ge.forEach(M),lm=c($),_n=j($,"DIV",{class:!0});var at=k(_n);u(ql.$$.fragment,at),om=c(at),Ai=j(at,"P",{"data-svelte-h":!0}),T(Ai)!=="svelte-108ipf8"&&(Ai.textContent=id),im=c(at),u(ua.$$.fragment,at),at.forEach(M),$.forEach(M),Hi=c(a),u(Al.$$.fragment,a),Oi=c(a),In=j(a,"DIV",{class:!0});var Ql=k(In);u(Zl.$$.fragment,Ql),rm=c(Ql),Zi=j(Ql,"P",{"data-svelte-h":!0}),T(Zi)!=="svelte-2793d9"&&(Zi.textContent=rd),Ql.forEach(M),Di=c(a),u(El.$$.fragment,a),Li=c(a),Wl=j(a,"P",{"data-svelte-h":!0}),T(Wl)!=="svelte-t9bv3o"&&(Wl.innerHTML=cd),Pi=c(a),L=j(a,"DIV",{class:!0});var te=k(L);u(Nl.$$.fragment,te),cm=c(te),Ei=j(te,"P",{"data-svelte-h":!0}),T(Ei)!=="svelte-xkrgz1"&&(Ei.textContent=pd),pm=c(te),u(ma.$$.fragment,te),gm=c(te),ha=j(te,"DIV",{class:!0});var Sl=k(ha);u(Gl.$$.fragment,Sl),um=c(Sl),Wi=j(Sl,"P",{"data-svelte-h":!0}),T(Wi)!=="svelte-1ruvvxs"&&(Wi.textContent=gd),Sl.forEach(M),mm=c(te),da=j(te,"DIV",{class:!0});var Yl=k(da);u(Bl.$$.fragment,Yl),hm=c(Yl),Ni=j(Yl,"P",{"data-svelte-h":!0}),T(Ni)!=="svelte-ss15d2"&&(Ni.textContent=ud),Yl.forEach(M),te.forEach(M),Ki=c(a),u(Vl.$$.fragment,a),er=c(a),Gi=j(a,"P",{}),k(Gi).forEach(M),this.h()},h(){q(n,"name","hf:doc:metadata"),q(n,"content",JM),q(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(en,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(nn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(sn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(an,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ln,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(on,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(rn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(pn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(gn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(fn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(yn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(bn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(jn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(_n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(In,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ha,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(da,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(a,y){l(document.head,n),I(a,o,y),I(a,t,y),I(a,s,y),m(i,a,y),I(a,e,y),I(a,p,y),I(a,Vi,y),I(a,fa,y),I(a,Qi,y),I(a,ya,y),I(a,Si,y),m(Ma,a,y),I(a,Yi,y),I(a,x,y),m(ba,x,null),l(x,tr),l(x,Rl),l(x,sr),l(x,Xl),l(x,ar),l(x,Be),m(ja,Be,null),l(Be,lr),l(Be,zl),l(Be,or),m(lt,Be,null),l(x,ir),l(x,Ve),m(_a,Ve,null),l(Ve,rr),l(Ve,Fl),l(Ve,cr),m(ot,Ve,null),l(x,pr),l(x,Qe),m(Ia,Qe,null),l(Qe,gr),l(Qe,Hl),l(Qe,ur),m(it,Qe,null),l(x,mr),l(x,Z),m(Ta,Z,null),l(Z,hr),l(Z,Ol),l(Z,dr),m(rt,Z,null),l(Z,fr),m(ct,Z,null),l(Z,yr),m(pt,Z,null),l(Z,Mr),m(gt,Z,null),l(Z,br),m(ut,Z,null),l(Z,jr),l(Z,Dl),l(Z,_r),m(mt,Z,null),l(Z,Ir),l(Z,Ll),l(Z,Tr),m(ht,Z,null),l(Z,Jr),m(dt,Z,null),l(Z,Ur),m(ft,Z,null),l(Z,wr),m(yt,Z,null),l(x,Cr),l(x,Se),m(Ja,Se,null),l(Se,xr),l(Se,Pl),l(Se,$r),m(Mt,Se,null),l(x,vr),l(x,Ye),m(Ua,Ye,null),l(Ye,kr),l(Ye,Kl),l(Ye,qr),m(bt,Ye,null),l(x,Ar),l(x,Re),m(wa,Re,null),l(Re,Zr),l(Re,eo),l(Re,Er),m(jt,Re,null),l(x,Wr),l(x,se),m(Ca,se,null),l(se,Nr),l(se,no),l(se,Gr),l(se,to),l(se,Br),m(_t,se,null),l(x,Vr),l(x,ae),m(xa,ae,null),l(ae,Qr),l(ae,so),l(ae,Sr),l(ae,ao),l(ae,Yr),m(It,ae,null),l(x,Rr),l(x,Xe),m($a,Xe,null),l(Xe,Xr),l(Xe,lo),l(Xe,zr),m(Tt,Xe,null),l(x,Fr),l(x,le),m(va,le,null),l(le,Hr),l(le,oo),l(le,Or),m(Jt,le,null),l(le,Dr),m(Ut,le,null),l(x,Lr),l(x,oe),m(ka,oe,null),l(oe,Pr),l(oe,io),l(oe,Kr),m(wt,oe,null),l(oe,ec),m(Ct,oe,null),l(x,nc),l(x,ie),m(qa,ie,null),l(ie,tc),l(ie,ro),l(ie,sc),l(ie,co),l(ie,ac),m(xt,ie,null),l(x,lc),l(x,ze),m(Aa,ze,null),l(ze,oc),l(ze,po),l(ze,ic),m($t,ze,null),l(x,rc),l(x,re),m(Za,re,null),l(re,cc),l(re,go),l(re,pc),m(vt,re,null),l(re,gc),m(kt,re,null),l(x,uc),l(x,Fe),m(Ea,Fe,null),l(Fe,mc),l(Fe,uo),l(Fe,hc),m(qt,Fe,null),l(x,dc),l(x,He),m(Wa,He,null),l(He,fc),l(He,mo),l(He,yc),m(At,He,null),l(x,Mc),l(x,Oe),m(Na,Oe,null),l(Oe,bc),l(Oe,ho),l(Oe,jc),m(Zt,Oe,null),l(x,_c),l(x,De),m(Ga,De,null),l(De,Ic),l(De,fo),l(De,Tc),m(Et,De,null),l(x,Jc),l(x,Le),m(Ba,Le,null),l(Le,Uc),l(Le,yo),l(Le,wc),m(Wt,Le,null),l(x,Cc),l(x,Pe),m(Va,Pe,null),l(Pe,xc),l(Pe,Mo),l(Pe,$c),m(Nt,Pe,null),l(x,vc),l(x,Ke),m(Qa,Ke,null),l(Ke,kc),l(Ke,bo),l(Ke,qc),m(Gt,Ke,null),l(x,Ac),l(x,ce),m(Sa,ce,null),l(ce,Zc),l(ce,jo),l(ce,Ec),m(Bt,ce,null),l(ce,Wc),m(Vt,ce,null),l(x,Nc),l(x,S),m(Ya,S,null),l(S,Gc),l(S,_o),l(S,Bc),m(Qt,S,null),l(S,Vc),m(St,S,null),l(S,Qc),m(Yt,S,null),l(S,Sc),m(Rt,S,null),l(S,Yc),l(S,Io),l(S,Rc),m(Xt,S,null),l(S,Xc),l(S,To),l(S,zc),m(zt,S,null),l(x,Fc),l(x,G),m(Ra,G,null),l(G,Hc),l(G,Jo),l(G,Oc),m(Ft,G,null),l(G,Dc),m(Ht,G,null),l(G,Lc),l(G,Uo),l(G,Pc),m(Ot,G,null),l(G,Kc),l(G,wo),l(G,ep),m(Dt,G,null),l(G,np),m(Lt,G,null),l(G,tp),l(G,Co),l(G,sp),m(Pt,G,null),l(x,ap),l(x,z),m(Xa,z,null),l(z,lp),l(z,xo),l(z,op),m(Kt,z,null),l(z,ip),l(z,$o),l(z,rp),l(z,vo),l(z,cp),m(es,z,null),l(z,pp),l(z,ko),l(z,gp),m(ns,z,null),l(x,up),l(x,en),m(za,en,null),l(en,mp),l(en,qo),l(en,hp),m(ts,en,null),l(x,dp),l(x,P),m(Fa,P,null),l(P,fp),l(P,Ao),l(P,yp),l(P,Zo),l(P,Mp),m(ss,P,null),l(P,bp),m(as,P,null),l(x,jp),l(x,nn),m(Ha,nn,null),l(nn,_p),l(nn,Eo),l(nn,Ip),m(ls,nn,null),l(x,Tp),l(x,pe),m(Oa,pe,null),l(pe,Jp),l(pe,Wo),l(pe,Up),m(os,pe,null),l(pe,wp),m(is,pe,null),l(x,Cp),l(x,tn),m(Da,tn,null),l(tn,xp),l(tn,No),l(tn,$p),m(rs,tn,null),I(a,Ri,y),m(La,a,y),I(a,Xi,y),I(a,Pa,y),I(a,zi,y),m(Ka,a,y),I(a,Fi,y),I(a,C,y),m(el,C,null),l(C,vp),l(C,Go),l(C,kp),l(C,Bo),l(C,qp),l(C,sn),m(nl,sn,null),l(sn,Ap),l(sn,Vo),l(sn,Zp),m(cs,sn,null),l(C,Ep),l(C,an),m(tl,an,null),l(an,Wp),l(an,Qo),l(an,Np),m(ps,an,null),l(C,Gp),l(C,ln),m(sl,ln,null),l(ln,Bp),l(ln,So),l(ln,Vp),m(gs,ln,null),l(C,Qp),l(C,E),m(al,E,null),l(E,Sp),l(E,Yo),l(E,Yp),m(us,E,null),l(E,Rp),m(ms,E,null),l(E,Xp),m(hs,E,null),l(E,zp),m(ds,E,null),l(E,Fp),m(fs,E,null),l(E,Hp),l(E,Ro),l(E,Op),m(ys,E,null),l(E,Dp),l(E,Xo),l(E,Lp),m(Ms,E,null),l(E,Pp),m(bs,E,null),l(E,Kp),m(js,E,null),l(E,eg),m(_s,E,null),l(C,ng),l(C,ge),m(ll,ge,null),l(ge,tg),l(ge,zo),l(ge,sg),l(ge,Fo),l(ge,ag),l(ge,Ho),l(C,lg),l(C,on),m(ol,on,null),l(on,og),l(on,Oo),l(on,ig),m(Is,on,null),l(C,rg),l(C,rn),m(il,rn,null),l(rn,cg),l(rn,Do),l(rn,pg),m(Ts,rn,null),l(C,gg),l(C,cn),m(rl,cn,null),l(cn,ug),l(cn,Lo),l(cn,mg),m(Js,cn,null),l(C,hg),l(C,ue),m(cl,ue,null),l(ue,dg),l(ue,Po),l(ue,fg),l(ue,Ko),l(ue,yg),m(Us,ue,null),l(C,Mg),l(C,me),m(pl,me,null),l(me,bg),l(me,ei),l(me,jg),l(me,ni),l(me,_g),m(ws,me,null),l(C,Ig),l(C,pn),m(gl,pn,null),l(pn,Tg),l(pn,ti),l(pn,Jg),m(Cs,pn,null),l(C,Ug),l(C,he),m(ul,he,null),l(he,wg),l(he,si),l(he,Cg),m(xs,he,null),l(he,xg),m($s,he,null),l(C,$g),l(C,de),m(ml,de,null),l(de,vg),l(de,ai),l(de,kg),m(vs,de,null),l(de,qg),m(ks,de,null),l(C,Ag),l(C,fe),m(hl,fe,null),l(fe,Zg),l(fe,li),l(fe,Eg),l(fe,oi),l(fe,Wg),m(qs,fe,null),l(C,Ng),l(C,gn),m(dl,gn,null),l(gn,Gg),l(gn,ii),l(gn,Bg),m(As,gn,null),l(C,Vg),l(C,ye),m(fl,ye,null),l(ye,Qg),l(ye,ri),l(ye,Sg),m(Zs,ye,null),l(ye,Yg),m(Es,ye,null),l(C,Rg),l(C,un),m(yl,un,null),l(un,Xg),l(un,ci),l(un,zg),m(Ws,un,null),l(C,Fg),l(C,mn),m(Ml,mn,null),l(mn,Hg),l(mn,pi),l(mn,Og),m(Ns,mn,null),l(C,Dg),l(C,hn),m(bl,hn,null),l(hn,Lg),l(hn,gi),l(hn,Pg),m(Gs,hn,null),l(C,Kg),l(C,dn),m(jl,dn,null),l(dn,eu),l(dn,ui),l(dn,nu),m(Bs,dn,null),l(C,tu),l(C,fn),m(_l,fn,null),l(fn,su),l(fn,mi),l(fn,au),m(Vs,fn,null),l(C,lu),l(C,yn),m(Il,yn,null),l(yn,ou),l(yn,hi),l(yn,iu),m(Qs,yn,null),l(C,ru),l(C,Mn),m(Tl,Mn,null),l(Mn,cu),l(Mn,di),l(Mn,pu),m(Ss,Mn,null),l(C,gu),l(C,Me),m(Jl,Me,null),l(Me,uu),l(Me,fi),l(Me,mu),m(Ys,Me,null),l(Me,hu),m(Rs,Me,null),l(C,du),l(C,Y),m(Ul,Y,null),l(Y,fu),l(Y,yi),l(Y,yu),m(Xs,Y,null),l(Y,Mu),m(zs,Y,null),l(Y,bu),m(Fs,Y,null),l(Y,ju),m(Hs,Y,null),l(Y,_u),l(Y,Mi),l(Y,Iu),m(Os,Y,null),l(Y,Tu),l(Y,bi),l(Y,Ju),m(Ds,Y,null),l(C,Uu),l(C,B),m(wl,B,null),l(B,wu),l(B,ji),l(B,Cu),m(Ls,B,null),l(B,xu),m(Ps,B,null),l(B,$u),l(B,_i),l(B,vu),m(Ks,B,null),l(B,ku),l(B,Ii),l(B,qu),m(ea,B,null),l(B,Au),m(na,B,null),l(B,Zu),l(B,Ti),l(B,Eu),m(ta,B,null),l(C,Wu),l(C,F),m(Cl,F,null),l(F,Nu),l(F,Ji),l(F,Gu),m(sa,F,null),l(F,Bu),l(F,Ui),l(F,Vu),l(F,wi),l(F,Qu),m(aa,F,null),l(F,Su),l(F,Ci),l(F,Yu),m(la,F,null),l(C,Ru),l(C,bn),m(xl,bn,null),l(bn,Xu),l(bn,xi),l(bn,zu),m(oa,bn,null),l(C,Fu),l(C,K),m($l,K,null),l(K,Hu),l(K,$i),l(K,Ou),l(K,vi),l(K,Du),m(ia,K,null),l(K,Lu),m(ra,K,null),l(C,Pu),l(C,jn),m(vl,jn,null),l(jn,Ku),l(jn,ki),l(jn,em),m(ca,jn,null),l(C,nm),l(C,be),m(kl,be,null),l(be,tm),l(be,qi),l(be,sm),m(pa,be,null),l(be,am),m(ga,be,null),l(C,lm),l(C,_n),m(ql,_n,null),l(_n,om),l(_n,Ai),l(_n,im),m(ua,_n,null),I(a,Hi,y),m(Al,a,y),I(a,Oi,y),I(a,In,y),m(Zl,In,null),l(In,rm),l(In,Zi),I(a,Di,y),m(El,a,y),I(a,Li,y),I(a,Wl,y),I(a,Pi,y),I(a,L,y),m(Nl,L,null),l(L,cm),l(L,Ei),l(L,pm),m(ma,L,null),l(L,gm),l(L,ha),m(Gl,ha,null),l(ha,um),l(ha,Wi),l(L,mm),l(L,da),m(Bl,da,null),l(da,hm),l(da,Ni),I(a,Ki,y),m(Vl,a,y),I(a,er,y),I(a,Gi,y),nr=!0},p(a,[y]){const v={};y&2&&(v.$$scope={dirty:y,ctx:a}),lt.$set(v);const Tn={};y&2&&(Tn.$$scope={dirty:y,ctx:a}),ot.$set(Tn);const Jn={};y&2&&(Jn.$$scope={dirty:y,ctx:a}),it.$set(Jn);const Un={};y&2&&(Un.$$scope={dirty:y,ctx:a}),rt.$set(Un);const W={};y&2&&(W.$$scope={dirty:y,ctx:a}),ct.$set(W);const wn={};y&2&&(wn.$$scope={dirty:y,ctx:a}),pt.$set(wn);const Cn={};y&2&&(Cn.$$scope={dirty:y,ctx:a}),gt.$set(Cn);const xn={};y&2&&(xn.$$scope={dirty:y,ctx:a}),ut.$set(xn);const Ie={};y&2&&(Ie.$$scope={dirty:y,ctx:a}),mt.$set(Ie);const Te={};y&2&&(Te.$$scope={dirty:y,ctx:a}),ht.$set(Te);const $n={};y&2&&($n.$$scope={dirty:y,ctx:a}),dt.$set($n);const Je={};y&2&&(Je.$$scope={dirty:y,ctx:a}),ft.$set(Je);const Ue={};y&2&&(Ue.$$scope={dirty:y,ctx:a}),yt.$set(Ue);const we={};y&2&&(we.$$scope={dirty:y,ctx:a}),Mt.$set(we);const vn={};y&2&&(vn.$$scope={dirty:y,ctx:a}),bt.$set(vn);const Ce={};y&2&&(Ce.$$scope={dirty:y,ctx:a}),jt.$set(Ce);const kn={};y&2&&(kn.$$scope={dirty:y,ctx:a}),_t.$set(kn);const qn={};y&2&&(qn.$$scope={dirty:y,ctx:a}),It.$set(qn);const An={};y&2&&(An.$$scope={dirty:y,ctx:a}),Tt.$set(An);const Zn={};y&2&&(Zn.$$scope={dirty:y,ctx:a}),Jt.$set(Zn);const En={};y&2&&(En.$$scope={dirty:y,ctx:a}),Ut.$set(En);const Wn={};y&2&&(Wn.$$scope={dirty:y,ctx:a}),wt.$set(Wn);const Nn={};y&2&&(Nn.$$scope={dirty:y,ctx:a}),Ct.$set(Nn);const xe={};y&2&&(xe.$$scope={dirty:y,ctx:a}),xt.$set(xe);const R={};y&2&&(R.$$scope={dirty:y,ctx:a}),$t.$set(R);const V={};y&2&&(V.$$scope={dirty:y,ctx:a}),vt.$set(V);const O={};y&2&&(O.$$scope={dirty:y,ctx:a}),kt.$set(O);const Gn={};y&2&&(Gn.$$scope={dirty:y,ctx:a}),qt.$set(Gn);const ee={};y&2&&(ee.$$scope={dirty:y,ctx:a}),At.$set(ee);const Bn={};y&2&&(Bn.$$scope={dirty:y,ctx:a}),Zt.$set(Bn);const $e={};y&2&&($e.$$scope={dirty:y,ctx:a}),Et.$set($e);const Vn={};y&2&&(Vn.$$scope={dirty:y,ctx:a}),Wt.$set(Vn);const $={};y&2&&($.$$scope={dirty:y,ctx:a}),Nt.$set($);const Qn={};y&2&&(Qn.$$scope={dirty:y,ctx:a}),Gt.$set(Qn);const Sn={};y&2&&(Sn.$$scope={dirty:y,ctx:a}),Bt.$set(Sn);const Yn={};y&2&&(Yn.$$scope={dirty:y,ctx:a}),Vt.$set(Yn);const N={};y&2&&(N.$$scope={dirty:y,ctx:a}),Qt.$set(N);const ve={};y&2&&(ve.$$scope={dirty:y,ctx:a}),St.$set(ve);const Rn={};y&2&&(Rn.$$scope={dirty:y,ctx:a}),Yt.$set(Rn);const Xn={};y&2&&(Xn.$$scope={dirty:y,ctx:a}),Rt.$set(Xn);const zn={};y&2&&(zn.$$scope={dirty:y,ctx:a}),Xt.$set(zn);const ke={};y&2&&(ke.$$scope={dirty:y,ctx:a}),zt.$set(ke);const qe={};y&2&&(qe.$$scope={dirty:y,ctx:a}),Ft.$set(qe);const Fn={};y&2&&(Fn.$$scope={dirty:y,ctx:a}),Ht.$set(Fn);const Ae={};y&2&&(Ae.$$scope={dirty:y,ctx:a}),Ot.$set(Ae);const Ze={};y&2&&(Ze.$$scope={dirty:y,ctx:a}),Dt.$set(Ze);const Ee={};y&2&&(Ee.$$scope={dirty:y,ctx:a}),Lt.$set(Ee);const Hn={};y&2&&(Hn.$$scope={dirty:y,ctx:a}),Pt.$set(Hn);const We={};y&2&&(We.$$scope={dirty:y,ctx:a}),Kt.$set(We);const On={};y&2&&(On.$$scope={dirty:y,ctx:a}),es.$set(On);const Dn={};y&2&&(Dn.$$scope={dirty:y,ctx:a}),ns.$set(Dn);const Ln={};y&2&&(Ln.$$scope={dirty:y,ctx:a}),ts.$set(Ln);const Pn={};y&2&&(Pn.$$scope={dirty:y,ctx:a}),ss.$set(Pn);const Kn={};y&2&&(Kn.$$scope={dirty:y,ctx:a}),as.$set(Kn);const et={};y&2&&(et.$$scope={dirty:y,ctx:a}),ls.$set(et);const nt={};y&2&&(nt.$$scope={dirty:y,ctx:a}),os.$set(nt);const Ne={};y&2&&(Ne.$$scope={dirty:y,ctx:a}),is.$set(Ne);const X={};y&2&&(X.$$scope={dirty:y,ctx:a}),rs.$set(X);const Q={};y&2&&(Q.$$scope={dirty:y,ctx:a}),cs.$set(Q);const D={};y&2&&(D.$$scope={dirty:y,ctx:a}),ps.$set(D);const tt={};y&2&&(tt.$$scope={dirty:y,ctx:a}),gs.$set(tt);const ne={};y&2&&(ne.$$scope={dirty:y,ctx:a}),us.$set(ne);const st={};y&2&&(st.$$scope={dirty:y,ctx:a}),ms.$set(st);const Ge={};y&2&&(Ge.$$scope={dirty:y,ctx:a}),hs.$set(Ge);const at={};y&2&&(at.$$scope={dirty:y,ctx:a}),ds.$set(at);const Ql={};y&2&&(Ql.$$scope={dirty:y,ctx:a}),fs.$set(Ql);const te={};y&2&&(te.$$scope={dirty:y,ctx:a}),ys.$set(te);const Sl={};y&2&&(Sl.$$scope={dirty:y,ctx:a}),Ms.$set(Sl);const Yl={};y&2&&(Yl.$$scope={dirty:y,ctx:a}),bs.$set(Yl);const md={};y&2&&(md.$$scope={dirty:y,ctx:a}),js.$set(md);const hd={};y&2&&(hd.$$scope={dirty:y,ctx:a}),_s.$set(hd);const dd={};y&2&&(dd.$$scope={dirty:y,ctx:a}),Is.$set(dd);const fd={};y&2&&(fd.$$scope={dirty:y,ctx:a}),Ts.$set(fd);const yd={};y&2&&(yd.$$scope={dirty:y,ctx:a}),Js.$set(yd);const Md={};y&2&&(Md.$$scope={dirty:y,ctx:a}),Us.$set(Md);const bd={};y&2&&(bd.$$scope={dirty:y,ctx:a}),ws.$set(bd);const jd={};y&2&&(jd.$$scope={dirty:y,ctx:a}),Cs.$set(jd);const _d={};y&2&&(_d.$$scope={dirty:y,ctx:a}),xs.$set(_d);const Id={};y&2&&(Id.$$scope={dirty:y,ctx:a}),$s.$set(Id);const Td={};y&2&&(Td.$$scope={dirty:y,ctx:a}),vs.$set(Td);const Jd={};y&2&&(Jd.$$scope={dirty:y,ctx:a}),ks.$set(Jd);const Ud={};y&2&&(Ud.$$scope={dirty:y,ctx:a}),qs.$set(Ud);const wd={};y&2&&(wd.$$scope={dirty:y,ctx:a}),As.$set(wd);const Cd={};y&2&&(Cd.$$scope={dirty:y,ctx:a}),Zs.$set(Cd);const xd={};y&2&&(xd.$$scope={dirty:y,ctx:a}),Es.$set(xd);const $d={};y&2&&($d.$$scope={dirty:y,ctx:a}),Ws.$set($d);const vd={};y&2&&(vd.$$scope={dirty:y,ctx:a}),Ns.$set(vd);const kd={};y&2&&(kd.$$scope={dirty:y,ctx:a}),Gs.$set(kd);const qd={};y&2&&(qd.$$scope={dirty:y,ctx:a}),Bs.$set(qd);const Ad={};y&2&&(Ad.$$scope={dirty:y,ctx:a}),Vs.$set(Ad);const Zd={};y&2&&(Zd.$$scope={dirty:y,ctx:a}),Qs.$set(Zd);const Ed={};y&2&&(Ed.$$scope={dirty:y,ctx:a}),Ss.$set(Ed);const Wd={};y&2&&(Wd.$$scope={dirty:y,ctx:a}),Ys.$set(Wd);const Nd={};y&2&&(Nd.$$scope={dirty:y,ctx:a}),Rs.$set(Nd);const Gd={};y&2&&(Gd.$$scope={dirty:y,ctx:a}),Xs.$set(Gd);const Bd={};y&2&&(Bd.$$scope={dirty:y,ctx:a}),zs.$set(Bd);const Vd={};y&2&&(Vd.$$scope={dirty:y,ctx:a}),Fs.$set(Vd);const Qd={};y&2&&(Qd.$$scope={dirty:y,ctx:a}),Hs.$set(Qd);const Sd={};y&2&&(Sd.$$scope={dirty:y,ctx:a}),Os.$set(Sd);const Yd={};y&2&&(Yd.$$scope={dirty:y,ctx:a}),Ds.$set(Yd);const Rd={};y&2&&(Rd.$$scope={dirty:y,ctx:a}),Ls.$set(Rd);const Xd={};y&2&&(Xd.$$scope={dirty:y,ctx:a}),Ps.$set(Xd);const zd={};y&2&&(zd.$$scope={dirty:y,ctx:a}),Ks.$set(zd);const Fd={};y&2&&(Fd.$$scope={dirty:y,ctx:a}),ea.$set(Fd);const Hd={};y&2&&(Hd.$$scope={dirty:y,ctx:a}),na.$set(Hd);const Od={};y&2&&(Od.$$scope={dirty:y,ctx:a}),ta.$set(Od);const Dd={};y&2&&(Dd.$$scope={dirty:y,ctx:a}),sa.$set(Dd);const Ld={};y&2&&(Ld.$$scope={dirty:y,ctx:a}),aa.$set(Ld);const Pd={};y&2&&(Pd.$$scope={dirty:y,ctx:a}),la.$set(Pd);const Kd={};y&2&&(Kd.$$scope={dirty:y,ctx:a}),oa.$set(Kd);const ef={};y&2&&(ef.$$scope={dirty:y,ctx:a}),ia.$set(ef);const nf={};y&2&&(nf.$$scope={dirty:y,ctx:a}),ra.$set(nf);const tf={};y&2&&(tf.$$scope={dirty:y,ctx:a}),ca.$set(tf);const sf={};y&2&&(sf.$$scope={dirty:y,ctx:a}),pa.$set(sf);const af={};y&2&&(af.$$scope={dirty:y,ctx:a}),ga.$set(af);const lf={};y&2&&(lf.$$scope={dirty:y,ctx:a}),ua.$set(lf);const of={};y&2&&(of.$$scope={dirty:y,ctx:a}),ma.$set(of)},i(a){nr||(h(i.$$.fragment,a),h(Ma.$$.fragment,a),h(ba.$$.fragment,a),h(ja.$$.fragment,a),h(lt.$$.fragment,a),h(_a.$$.fragment,a),h(ot.$$.fragment,a),h(Ia.$$.fragment,a),h(it.$$.fragment,a),h(Ta.$$.fragment,a),h(rt.$$.fragment,a),h(ct.$$.fragment,a),h(pt.$$.fragment,a),h(gt.$$.fragment,a),h(ut.$$.fragment,a),h(mt.$$.fragment,a),h(ht.$$.fragment,a),h(dt.$$.fragment,a),h(ft.$$.fragment,a),h(yt.$$.fragment,a),h(Ja.$$.fragment,a),h(Mt.$$.fragment,a),h(Ua.$$.fragment,a),h(bt.$$.fragment,a),h(wa.$$.fragment,a),h(jt.$$.fragment,a),h(Ca.$$.fragment,a),h(_t.$$.fragment,a),h(xa.$$.fragment,a),h(It.$$.fragment,a),h($a.$$.fragment,a),h(Tt.$$.fragment,a),h(va.$$.fragment,a),h(Jt.$$.fragment,a),h(Ut.$$.fragment,a),h(ka.$$.fragment,a),h(wt.$$.fragment,a),h(Ct.$$.fragment,a),h(qa.$$.fragment,a),h(xt.$$.fragment,a),h(Aa.$$.fragment,a),h($t.$$.fragment,a),h(Za.$$.fragment,a),h(vt.$$.fragment,a),h(kt.$$.fragment,a),h(Ea.$$.fragment,a),h(qt.$$.fragment,a),h(Wa.$$.fragment,a),h(At.$$.fragment,a),h(Na.$$.fragment,a),h(Zt.$$.fragment,a),h(Ga.$$.fragment,a),h(Et.$$.fragment,a),h(Ba.$$.fragment,a),h(Wt.$$.fragment,a),h(Va.$$.fragment,a),h(Nt.$$.fragment,a),h(Qa.$$.fragment,a),h(Gt.$$.fragment,a),h(Sa.$$.fragment,a),h(Bt.$$.fragment,a),h(Vt.$$.fragment,a),h(Ya.$$.fragment,a),h(Qt.$$.fragment,a),h(St.$$.fragment,a),h(Yt.$$.fragment,a),h(Rt.$$.fragment,a),h(Xt.$$.fragment,a),h(zt.$$.fragment,a),h(Ra.$$.fragment,a),h(Ft.$$.fragment,a),h(Ht.$$.fragment,a),h(Ot.$$.fragment,a),h(Dt.$$.fragment,a),h(Lt.$$.fragment,a),h(Pt.$$.fragment,a),h(Xa.$$.fragment,a),h(Kt.$$.fragment,a),h(es.$$.fragment,a),h(ns.$$.fragment,a),h(za.$$.fragment,a),h(ts.$$.fragment,a),h(Fa.$$.fragment,a),h(ss.$$.fragment,a),h(as.$$.fragment,a),h(Ha.$$.fragment,a),h(ls.$$.fragment,a),h(Oa.$$.fragment,a),h(os.$$.fragment,a),h(is.$$.fragment,a),h(Da.$$.fragment,a),h(rs.$$.fragment,a),h(La.$$.fragment,a),h(Ka.$$.fragment,a),h(el.$$.fragment,a),h(nl.$$.fragment,a),h(cs.$$.fragment,a),h(tl.$$.fragment,a),h(ps.$$.fragment,a),h(sl.$$.fragment,a),h(gs.$$.fragment,a),h(al.$$.fragment,a),h(us.$$.fragment,a),h(ms.$$.fragment,a),h(hs.$$.fragment,a),h(ds.$$.fragment,a),h(fs.$$.fragment,a),h(ys.$$.fragment,a),h(Ms.$$.fragment,a),h(bs.$$.fragment,a),h(js.$$.fragment,a),h(_s.$$.fragment,a),h(ll.$$.fragment,a),h(ol.$$.fragment,a),h(Is.$$.fragment,a),h(il.$$.fragment,a),h(Ts.$$.fragment,a),h(rl.$$.fragment,a),h(Js.$$.fragment,a),h(cl.$$.fragment,a),h(Us.$$.fragment,a),h(pl.$$.fragment,a),h(ws.$$.fragment,a),h(gl.$$.fragment,a),h(Cs.$$.fragment,a),h(ul.$$.fragment,a),h(xs.$$.fragment,a),h($s.$$.fragment,a),h(ml.$$.fragment,a),h(vs.$$.fragment,a),h(ks.$$.fragment,a),h(hl.$$.fragment,a),h(qs.$$.fragment,a),h(dl.$$.fragment,a),h(As.$$.fragment,a),h(fl.$$.fragment,a),h(Zs.$$.fragment,a),h(Es.$$.fragment,a),h(yl.$$.fragment,a),h(Ws.$$.fragment,a),h(Ml.$$.fragment,a),h(Ns.$$.fragment,a),h(bl.$$.fragment,a),h(Gs.$$.fragment,a),h(jl.$$.fragment,a),h(Bs.$$.fragment,a),h(_l.$$.fragment,a),h(Vs.$$.fragment,a),h(Il.$$.fragment,a),h(Qs.$$.fragment,a),h(Tl.$$.fragment,a),h(Ss.$$.fragment,a),h(Jl.$$.fragment,a),h(Ys.$$.fragment,a),h(Rs.$$.fragment,a),h(Ul.$$.fragment,a),h(Xs.$$.fragment,a),h(zs.$$.fragment,a),h(Fs.$$.fragment,a),h(Hs.$$.fragment,a),h(Os.$$.fragment,a),h(Ds.$$.fragment,a),h(wl.$$.fragment,a),h(Ls.$$.fragment,a),h(Ps.$$.fragment,a),h(Ks.$$.fragment,a),h(ea.$$.fragment,a),h(na.$$.fragment,a),h(ta.$$.fragment,a),h(Cl.$$.fragment,a),h(sa.$$.fragment,a),h(aa.$$.fragment,a),h(la.$$.fragment,a),h(xl.$$.fragment,a),h(oa.$$.fragment,a),h($l.$$.fragment,a),h(ia.$$.fragment,a),h(ra.$$.fragment,a),h(vl.$$.fragment,a),h(ca.$$.fragment,a),h(kl.$$.fragment,a),h(pa.$$.fragment,a),h(ga.$$.fragment,a),h(ql.$$.fragment,a),h(ua.$$.fragment,a),h(Al.$$.fragment,a),h(Zl.$$.fragment,a),h(El.$$.fragment,a),h(Nl.$$.fragment,a),h(ma.$$.fragment,a),h(Gl.$$.fragment,a),h(Bl.$$.fragment,a),h(Vl.$$.fragment,a),nr=!0)},o(a){d(i.$$.fragment,a),d(Ma.$$.fragment,a),d(ba.$$.fragment,a),d(ja.$$.fragment,a),d(lt.$$.fragment,a),d(_a.$$.fragment,a),d(ot.$$.fragment,a),d(Ia.$$.fragment,a),d(it.$$.fragment,a),d(Ta.$$.fragment,a),d(rt.$$.fragment,a),d(ct.$$.fragment,a),d(pt.$$.fragment,a),d(gt.$$.fragment,a),d(ut.$$.fragment,a),d(mt.$$.fragment,a),d(ht.$$.fragment,a),d(dt.$$.fragment,a),d(ft.$$.fragment,a),d(yt.$$.fragment,a),d(Ja.$$.fragment,a),d(Mt.$$.fragment,a),d(Ua.$$.fragment,a),d(bt.$$.fragment,a),d(wa.$$.fragment,a),d(jt.$$.fragment,a),d(Ca.$$.fragment,a),d(_t.$$.fragment,a),d(xa.$$.fragment,a),d(It.$$.fragment,a),d($a.$$.fragment,a),d(Tt.$$.fragment,a),d(va.$$.fragment,a),d(Jt.$$.fragment,a),d(Ut.$$.fragment,a),d(ka.$$.fragment,a),d(wt.$$.fragment,a),d(Ct.$$.fragment,a),d(qa.$$.fragment,a),d(xt.$$.fragment,a),d(Aa.$$.fragment,a),d($t.$$.fragment,a),d(Za.$$.fragment,a),d(vt.$$.fragment,a),d(kt.$$.fragment,a),d(Ea.$$.fragment,a),d(qt.$$.fragment,a),d(Wa.$$.fragment,a),d(At.$$.fragment,a),d(Na.$$.fragment,a),d(Zt.$$.fragment,a),d(Ga.$$.fragment,a),d(Et.$$.fragment,a),d(Ba.$$.fragment,a),d(Wt.$$.fragment,a),d(Va.$$.fragment,a),d(Nt.$$.fragment,a),d(Qa.$$.fragment,a),d(Gt.$$.fragment,a),d(Sa.$$.fragment,a),d(Bt.$$.fragment,a),d(Vt.$$.fragment,a),d(Ya.$$.fragment,a),d(Qt.$$.fragment,a),d(St.$$.fragment,a),d(Yt.$$.fragment,a),d(Rt.$$.fragment,a),d(Xt.$$.fragment,a),d(zt.$$.fragment,a),d(Ra.$$.fragment,a),d(Ft.$$.fragment,a),d(Ht.$$.fragment,a),d(Ot.$$.fragment,a),d(Dt.$$.fragment,a),d(Lt.$$.fragment,a),d(Pt.$$.fragment,a),d(Xa.$$.fragment,a),d(Kt.$$.fragment,a),d(es.$$.fragment,a),d(ns.$$.fragment,a),d(za.$$.fragment,a),d(ts.$$.fragment,a),d(Fa.$$.fragment,a),d(ss.$$.fragment,a),d(as.$$.fragment,a),d(Ha.$$.fragment,a),d(ls.$$.fragment,a),d(Oa.$$.fragment,a),d(os.$$.fragment,a),d(is.$$.fragment,a),d(Da.$$.fragment,a),d(rs.$$.fragment,a),d(La.$$.fragment,a),d(Ka.$$.fragment,a),d(el.$$.fragment,a),d(nl.$$.fragment,a),d(cs.$$.fragment,a),d(tl.$$.fragment,a),d(ps.$$.fragment,a),d(sl.$$.fragment,a),d(gs.$$.fragment,a),d(al.$$.fragment,a),d(us.$$.fragment,a),d(ms.$$.fragment,a),d(hs.$$.fragment,a),d(ds.$$.fragment,a),d(fs.$$.fragment,a),d(ys.$$.fragment,a),d(Ms.$$.fragment,a),d(bs.$$.fragment,a),d(js.$$.fragment,a),d(_s.$$.fragment,a),d(ll.$$.fragment,a),d(ol.$$.fragment,a),d(Is.$$.fragment,a),d(il.$$.fragment,a),d(Ts.$$.fragment,a),d(rl.$$.fragment,a),d(Js.$$.fragment,a),d(cl.$$.fragment,a),d(Us.$$.fragment,a),d(pl.$$.fragment,a),d(ws.$$.fragment,a),d(gl.$$.fragment,a),d(Cs.$$.fragment,a),d(ul.$$.fragment,a),d(xs.$$.fragment,a),d($s.$$.fragment,a),d(ml.$$.fragment,a),d(vs.$$.fragment,a),d(ks.$$.fragment,a),d(hl.$$.fragment,a),d(qs.$$.fragment,a),d(dl.$$.fragment,a),d(As.$$.fragment,a),d(fl.$$.fragment,a),d(Zs.$$.fragment,a),d(Es.$$.fragment,a),d(yl.$$.fragment,a),d(Ws.$$.fragment,a),d(Ml.$$.fragment,a),d(Ns.$$.fragment,a),d(bl.$$.fragment,a),d(Gs.$$.fragment,a),d(jl.$$.fragment,a),d(Bs.$$.fragment,a),d(_l.$$.fragment,a),d(Vs.$$.fragment,a),d(Il.$$.fragment,a),d(Qs.$$.fragment,a),d(Tl.$$.fragment,a),d(Ss.$$.fragment,a),d(Jl.$$.fragment,a),d(Ys.$$.fragment,a),d(Rs.$$.fragment,a),d(Ul.$$.fragment,a),d(Xs.$$.fragment,a),d(zs.$$.fragment,a),d(Fs.$$.fragment,a),d(Hs.$$.fragment,a),d(Os.$$.fragment,a),d(Ds.$$.fragment,a),d(wl.$$.fragment,a),d(Ls.$$.fragment,a),d(Ps.$$.fragment,a),d(Ks.$$.fragment,a),d(ea.$$.fragment,a),d(na.$$.fragment,a),d(ta.$$.fragment,a),d(Cl.$$.fragment,a),d(sa.$$.fragment,a),d(aa.$$.fragment,a),d(la.$$.fragment,a),d(xl.$$.fragment,a),d(oa.$$.fragment,a),d($l.$$.fragment,a),d(ia.$$.fragment,a),d(ra.$$.fragment,a),d(vl.$$.fragment,a),d(ca.$$.fragment,a),d(kl.$$.fragment,a),d(pa.$$.fragment,a),d(ga.$$.fragment,a),d(ql.$$.fragment,a),d(ua.$$.fragment,a),d(Al.$$.fragment,a),d(Zl.$$.fragment,a),d(El.$$.fragment,a),d(Nl.$$.fragment,a),d(ma.$$.fragment,a),d(Gl.$$.fragment,a),d(Bl.$$.fragment,a),d(Vl.$$.fragment,a),nr=!1},d(a){a&&(M(o),M(t),M(s),M(e),M(p),M(Vi),M(fa),M(Qi),M(ya),M(Si),M(Yi),M(x),M(Ri),M(Xi),M(Pa),M(zi),M(Fi),M(C),M(Hi),M(Oi),M(In),M(Di),M(Li),M(Wl),M(Pi),M(L),M(Ki),M(er),M(Gi)),M(n),f(i,a),f(Ma,a),f(ba),f(ja),f(lt),f(_a),f(ot),f(Ia),f(it),f(Ta),f(rt),f(ct),f(pt),f(gt),f(ut),f(mt),f(ht),f(dt),f(ft),f(yt),f(Ja),f(Mt),f(Ua),f(bt),f(wa),f(jt),f(Ca),f(_t),f(xa),f(It),f($a),f(Tt),f(va),f(Jt),f(Ut),f(ka),f(wt),f(Ct),f(qa),f(xt),f(Aa),f($t),f(Za),f(vt),f(kt),f(Ea),f(qt),f(Wa),f(At),f(Na),f(Zt),f(Ga),f(Et),f(Ba),f(Wt),f(Va),f(Nt),f(Qa),f(Gt),f(Sa),f(Bt),f(Vt),f(Ya),f(Qt),f(St),f(Yt),f(Rt),f(Xt),f(zt),f(Ra),f(Ft),f(Ht),f(Ot),f(Dt),f(Lt),f(Pt),f(Xa),f(Kt),f(es),f(ns),f(za),f(ts),f(Fa),f(ss),f(as),f(Ha),f(ls),f(Oa),f(os),f(is),f(Da),f(rs),f(La,a),f(Ka,a),f(el),f(nl),f(cs),f(tl),f(ps),f(sl),f(gs),f(al),f(us),f(ms),f(hs),f(ds),f(fs),f(ys),f(Ms),f(bs),f(js),f(_s),f(ll),f(ol),f(Is),f(il),f(Ts),f(rl),f(Js),f(cl),f(Us),f(pl),f(ws),f(gl),f(Cs),f(ul),f(xs),f($s),f(ml),f(vs),f(ks),f(hl),f(qs),f(dl),f(As),f(fl),f(Zs),f(Es),f(yl),f(Ws),f(Ml),f(Ns),f(bl),f(Gs),f(jl),f(Bs),f(_l),f(Vs),f(Il),f(Qs),f(Tl),f(Ss),f(Jl),f(Ys),f(Rs),f(Ul),f(Xs),f(zs),f(Fs),f(Hs),f(Os),f(Ds),f(wl),f(Ls),f(Ps),f(Ks),f(ea),f(na),f(ta),f(Cl),f(sa),f(aa),f(la),f(xl),f(oa),f($l),f(ia),f(ra),f(vl),f(ca),f(kl),f(pa),f(ga),f(ql),f(ua),f(Al,a),f(Zl),f(El,a),f(Nl),f(ma),f(Gl),f(Bl),f(Vl,a)}}}const JM='{"title":"Inference","local":"inference","sections":[{"title":"Inference Client","local":"huggingface_hub.InferenceClient","sections":[],"depth":2},{"title":"Async Inference Client","local":"huggingface_hub.AsyncInferenceClient","sections":[],"depth":2},{"title":"InferenceTimeoutError","local":"huggingface_hub.InferenceTimeoutError","sections":[],"depth":2},{"title":"InferenceAPI","local":"huggingface_hub.InferenceApi","sections":[],"depth":2}],"depth":1}';function UM(_){return cf(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class AM extends pf{constructor(n){super(),gf(this,n,UM,TM,rf,{})}}export{AM as component};
