import{s as Es,o as xs,n as W}from"../chunks/scheduler.6062bdaf.js";import{S as Ss,i as Vs,g as o,s as l,r as p,A as Ys,h as d,f as n,c as a,j as Ns,u,x as c,k as Qs,y as Hs,a as s,v as h,d as M,t as g,w as f}from"../chunks/index.4bca734e.js";import{T as q}from"../chunks/Tip.b9ac1f03.js";import{C as T}from"../chunks/CodeBlock.cbbddafc.js";import{H as I,E as Ls}from"../chunks/getInferenceSnippets.e6a3a5be.js";function Xs(w){let i,y=`<a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> is a Python client making HTTP calls to our APIs. If you want to make the HTTP calls directly using
your preferred tool (curl, postman,…), please refer to the <a href="https://huggingface.co/docs/inference-providers/index" rel="nofollow">Inference Providers</a> documentation
or to the <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a> documentation pages.`,r,m,U=`For web development, a <a href="https://huggingface.co/docs/huggingface.js/inference/README" rel="nofollow">JS client</a> has been released.
If you are interested in game development, you might have a look at our <a href="https://github.com/huggingface/unity-api" rel="nofollow">C# project</a>.`;return{c(){i=o("p"),i.innerHTML=y,r=l(),m=o("p"),m.innerHTML=U},l(J){i=d(J,"P",{"data-svelte-h":!0}),c(i)!=="svelte-938qx5"&&(i.innerHTML=y),r=a(J),m=d(J,"P",{"data-svelte-h":!0}),c(m)!=="svelte-22w7rm"&&(m.innerHTML=U)},m(J,j){s(J,i,j),s(J,r,j),s(J,m,j)},p:W,d(J){J&&(n(i),n(r),n(m))}}}function zs(w){let i,y=`The API is designed to be simple. Not all parameters and options are available or described for the end user. Check out
<a href="https://huggingface.co/docs/api-inference/detailed_parameters" rel="nofollow">this page</a> if you are interested in learning more about
all the parameters available for each task.`;return{c(){i=o("p"),i.innerHTML=y},l(r){i=d(r,"P",{"data-svelte-h":!0}),c(i)!=="svelte-1o4uc5e"&&(i.innerHTML=y)},m(r,m){s(r,i,m)},p:W,d(r){r&&n(i)}}}function Rs(w){let i,y=`When using the “hf-inference” provider, each task comes with a recommended model from the 1M+ models available on the Hub.
However, this recommendation can change over time, so it’s best to explicitly set a model once you’ve decided which one to use.
For third-party providers, you must always specify a model that is compatible with that provider.`,r,m,U='Visit the <a href="https://huggingface.co/models?inference=warm" rel="nofollow">Models</a> page on the Hub to explore models available through Inference Providers.';return{c(){i=o("p"),i.textContent=y,r=l(),m=o("p"),m.innerHTML=U},l(J){i=d(J,"P",{"data-svelte-h":!0}),c(i)!=="svelte-1pxsrsl"&&(i.textContent=y),r=a(J),m=d(J,"P",{"data-svelte-h":!0}),c(m)!=="svelte-hp7lk2"&&(m.innerHTML=U)},m(J,j){s(J,i,j),s(J,r,j),s(J,m,j)},p:W,d(J){J&&(n(i),n(r),n(m))}}}function Fs(w){let i,y='Similarily to the OpenAI Python client, <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> can be used to run Chat Completion inference with any OpenAI REST API-compatible endpoint.';return{c(){i=o("p"),i.innerHTML=y},l(r){i=d(r,"P",{"data-svelte-h":!0}),c(i)!=="svelte-142y7rx"&&(i.innerHTML=y)},m(r,m){s(r,i,m)},p:W,d(r){r&&n(i)}}}function Ps(w){let i,y='Check out the <a href="https://huggingface.co/tasks" rel="nofollow">Tasks</a> page to learn more about each task.';return{c(){i=o("p"),i.innerHTML=y},l(r){i=d(r,"P",{"data-svelte-h":!0}),c(i)!=="svelte-1odjvkm"&&(i.innerHTML=y)},m(r,m){s(r,i,m)},p:W,d(r){r&&n(i)}}}function Os(w){let i,y='<code>InferenceClient.chat.completions.create</code> is simply an alias for <code>InferenceClient.chat_completion</code>. Check out the package reference of <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">chat_completion()</a> for more details. <code>base_url</code> and <code>api_key</code> parameters when instantiating the client are also aliases for <code>model</code> and <code>token</code>. These aliases have been defined to reduce friction when switching from <code>OpenAI</code> to <code>InferenceClient</code>.';return{c(){i=o("p"),i.innerHTML=y},l(r){i=d(r,"P",{"data-svelte-h":!0}),c(i)!=="svelte-1dpcgfo"&&(i.innerHTML=y)},m(r,m){s(r,i,m)},p:W,d(r){r&&n(i)}}}function Ds(w){let i,y="Please refer to the providers’ documentation to verify which models are supported by them for Function/Tool Calling.";return{c(){i=o("p"),i.textContent=y},l(r){i=d(r,"P",{"data-svelte-h":!0}),c(i)!=="svelte-14o87w3"&&(i.textContent=y)},m(r,m){s(r,i,m)},p:W,d(r){r&&n(i)}}}function Ks(w){let i,y="Please refer to the providers’ documentation to verify which models are supported by them for Structured Outputs and JSON Mode.";return{c(){i=o("p"),i.textContent=y},l(r){i=d(r,"P",{"data-svelte-h":!0}),c(i)!=="svelte-1q9cfbb"&&(i.textContent=y)},m(r,m){s(r,i,m)},p:W,d(r){r&&n(i)}}}function el(w){let i,y,r,m,U,J,j,Sn=`Inference is the process of using a trained model to make predictions on new data. Because this process can be compute-intensive, running on a dedicated or external service can be an interesting option.
The <code>huggingface_hub</code> library provides a unified interface to run inference across multiple services for models hosted on the Hugging Face Hub:`,it,B,Vn='<li><a href="https://huggingface.co/docs/inference-providers/index" rel="nofollow">Inference Providers</a>: a streamlined, unified access to hundreds of machine learning models, powered by our serverless inference partners. This new approach builds on our previous Serverless Inference API, offering more models, improved performance, and greater reliability thanks to world-class providers. Refer to the <a href="https://huggingface.co/docs/inference-providers/index#partners" rel="nofollow">documentation</a> for a list of supported providers.</li> <li><a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a>: a product to easily deploy models to production. Inference is run by Hugging Face in a dedicated, fully managed infrastructure on a cloud provider of your choice.</li> <li>Local endpoints: you can also run inference with local inference servers like <a href="https://github.com/ggerganov/llama.cpp" rel="nofollow">llama.cpp</a>, <a href="https://ollama.com/" rel="nofollow">Ollama</a>, <a href="https://github.com/vllm-project/vllm" rel="nofollow">vLLM</a>, <a href="https://docs.litellm.ai/docs/simple_proxy" rel="nofollow">LiteLLM</a>, or <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">Text Generation Inference (TGI)</a> by connecting the client to these local endpoints.</li>',ot,G,Yn=`These services can all be called from the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> object. It acts as a replacement for the legacy
<a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceApi">InferenceApi</a> client, adding specific support for tasks and third-party providers.
Learn how to migrate to the new client in the <a href="#legacy-inferenceapi-client">Legacy InferenceAPI client</a> section.`,dt,C,ct,N,rt,Q,Hn="Let’s get started with a text-to-image task:",pt,E,ut,x,Ln=`In the example above, we initialized an <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> with a third-party provider, <a href="https://replicate.com/" rel="nofollow">Replicate</a>. When using a provider, you must specify the model you want to use. The model id must be the id of the model on the Hugging Face Hub, not the id of the model from the third-party provider.
In our example, we generated an image from a text prompt. The returned value is a <code>PIL.Image</code> object that can be saved to a file. For more details, check out the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_to_image">text_to_image()</a> documentation.`,ht,S,Xn='Let’s now see an example using the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">chat_completion()</a> API. This task uses an LLM to generate a response from a list of messages:',Mt,V,gt,Y,zn='In the example above, we used a third-party provider (<a href="https://www.together.ai/" rel="nofollow">Together AI</a>) and specified which model we want to use (<code>&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</code>). We then gave a list of messages to complete (here, a single question) and passed an additional parameter to the API (<code>max_token=100</code>). The output is a <code>ChatCompletionOutput</code> object that follows the OpenAI specification. The generated content can be accessed with <code>output.choices[0].message.content</code>. For more details, check out the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">chat_completion()</a> documentation.',ft,b,mt,H,yt,L,Rn='If you want to use a specific provider, you can specify it when initializing the client. The default value is “auto” which will select the first of the providers available for the model, sorted by the user’s order in <a href="https://hf.co/settings/inference-providers" rel="nofollow">https://hf.co/settings/inference-providers</a>. Refer to the <a href="#supported-providers-and-tasks">Supported providers and tasks</a> section for a list of supported providers.',Jt,X,Tt,z,wt,R,Fn="What if you want to use a specific model? You can specify it either as a parameter or directly at an instance level:",It,F,jt,_,Ut,P,Ct,O,Pn=`The examples we saw above use inference providers. While these prove to be very useful for prototyping
and testing things quickly. Once you’re ready to deploy your model to production, you’ll need to use a dedicated infrastructure.
That’s where <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a> comes into play. It allows you to deploy
any model and expose it as a private API. Once deployed, you’ll get a URL that you can connect to using exactly the same
code as before, changing only the <code>model</code> parameter:`,bt,D,_t,K,On="Note that you cannot specify both a URL and a provider - they are mutually exclusive. URLs are used to connect directly to deployed endpoints.",$t,ee,At,te,Dn='You can use <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> to run chat completion with local inference servers (llama.cpp, vllm, litellm server, TGI, mlx, etc.) running on your own machine. The API should be OpenAI API-compatible.',vt,ne,Zt,$,kt,se,qt,le,Kn="Authentication can be done in two ways:",Wt,ae,es="<strong>Routed through Hugging Face</strong> : Use Hugging Face as a proxy to access third-party providers. The calls will be routed through Hugging Face’s infrastructure using our provider keys, and the usage will be billed directly to your Hugging Face account.",Bt,ie,ts='You can authenticate using a <a href="https://huggingface.co/docs/hub/security-tokens" rel="nofollow">User Access Token</a>. You can provide your Hugging Face token directly using the <code>api_key</code> parameter:',Gt,oe,Nt,de,ns='If you <em>don’t</em> pass an <code>api_key</code>, the client will attempt to find and use a token stored locally on your machine. This typically happens if you’ve previously logged in. See the <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">Authentication Guide</a> for details on login.',Qt,ce,Et,re,ss="<strong>Direct access to provider</strong>: Use your own API key to interact directly with the provider’s service:",xt,pe,St,ue,ls='For more details, refer to the <a href="https://huggingface.co/docs/inference-providers/pricing#routed-requests-vs-direct-calls" rel="nofollow">Inference Providers pricing documentation</a>.',Vt,he,Yt,Me,as='<a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>’s goal is to provide the easiest interface to run inference on Hugging Face models, on any provider. It has a simple API that supports the most common tasks. Here is a table showing which providers support which tasks:',Ht,ge,is='<thead><tr><th>Task</th> <th>Black Forest Labs</th> <th>Cerebras</th> <th>Cohere</th> <th>fal-ai</th> <th>Featherless AI</th> <th>Fireworks AI</th> <th>Groq</th> <th>HF Inference</th> <th>Hyperbolic</th> <th>Nebius AI Studio</th> <th>Novita AI</th> <th>Replicate</th> <th>Sambanova</th> <th>Together</th></tr></thead> <tbody><tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.audio_classification">audio_classification()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.audio_to_audio">audio_to_audio()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.automatic_speech_recognition">automatic_speech_recognition()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">chat_completion()</a></td> <td>❌</td> <td>✅</td> <td>✅</td> <td>❌</td> <td>✅</td> <td>✅</td> <td>✅</td> <td>✅</td> <td>✅</td> <td>✅</td> <td>✅</td> <td>❌</td> <td>✅</td> <td>✅</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.document_question_answering">document_question_answering()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.feature_extraction">feature_extraction()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.fill_mask">fill_mask()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_classification">image_classification()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_segmentation">image_segmentation()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_to_image">image_to_image()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_to_video">image_to_video()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_to_text">image_to_text()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.object_detection">object_detection()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.question_answering">question_answering()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.sentence_similarity">sentence_similarity()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.summarization">summarization()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.table_question_answering">table_question_answering()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_classification">text_classification()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_generation">text_generation()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>✅</td> <td>✅</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>✅</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_to_image">text_to_image()</a></td> <td>✅</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>✅</td> <td>✅</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>✅</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_to_speech">text_to_speech()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_to_video">text_to_video()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.tabular_classification">tabular_classification()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.tabular_regression">tabular_regression()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.token_classification">token_classification()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.translation">translation()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.visual_question_answering">visual_question_answering()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.zero_shot_image_classification">zero_shot_image_classification()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.zero_shot_classification">zero_shot_classification()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr></tbody>',Lt,A,Xt,fe,zt,me,os='The <code>chat_completion</code> task follows <a href="https://github.com/openai/openai-python" rel="nofollow">OpenAI’s Python client</a> syntax. What does it mean for you? It means that if you are used to play with <code>OpenAI</code>’s APIs you will be able to switch to <code>huggingface_hub.InferenceClient</code> to work with open-source models by updating just 2 line of code!',Rt,ye,Ft,Je,ds='And that’s it! The only required changes are to replace <code>from openai import OpenAI</code> by <code>from huggingface_hub import InferenceClient</code> and <code>client = OpenAI(...)</code> by <code>client = InferenceClient(...)</code>. You can choose any LLM model from the Hugging Face Hub by passing its model id as <code>model</code> parameter. <a href="https://huggingface.co/models?pipeline_tag=text-generation&amp;other=conversational,text-generation-inference&amp;sort=trending" rel="nofollow">Here is a list</a> of supported models. For authentication, you should pass a valid <a href="https://huggingface.co/settings/tokens" rel="nofollow">User Access Token</a> as <code>api_key</code> or authenticate using <code>huggingface_hub</code> (see the <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">authentication guide</a>).',Pt,Te,cs='All input parameters and output format are strictly the same. In particular, you can pass <code>stream=True</code> to receive tokens as they are generated. You can also use the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.AsyncInferenceClient">AsyncInferenceClient</a> to run inference using <code>asyncio</code>:',Ot,we,Dt,Ie,rs='You might wonder why using <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> instead of OpenAI’s client? There are a few reasons for that:',Kt,je,ps='<li><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> is configured for Hugging Face services. You don’t need to provide a <code>base_url</code> to run models with Inference Providers. You also don’t need to provide a <code>token</code> or <code>api_key</code> if your machine is already correctly logged in.</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> is tailored for both Text-Generation-Inference (TGI) and <code>transformers</code> frameworks, meaning you are assured it will always be on-par with the latest updates.</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> is integrated with our Inference Endpoints service, making it easier to launch an Inference Endpoint, check its status and run inference on it. Check out the <a href="./inference_endpoints.md">Inference Endpoints</a> guide for more details.</li>',en,v,tn,Ue,nn,Ce,us=`Function calling allows LLMs to interact with external tools, such as defined functions or APIs. This enables users to easily build applications tailored to specific use cases and real-world tasks.
<code>InferenceClient</code> implements the same tool calling interface as the OpenAI Chat Completions API. Here is a simple example of tool calling using <a href="https://nebius.com/" rel="nofollow">Nebius</a> as the inference provider:`,sn,be,ln,Z,an,_e,on,$e,hs="InferenceClient supports JSON mode for syntactically valid JSON responses and Structured Outputs for schema-enforced responses. JSON mode provides machine-readable data without strict structure, while Structured Outputs guarantee both valid JSON and adherence to a predefined schema for reliable downstream processing.",dn,Ae,Ms='We follow the OpenAI API specs for both JSON mode and Structured Outputs. You can enable them via the <code>response_format</code> argument. Here is an example of Structured Outputs using <a href="https://www.cerebras.ai/" rel="nofollow">Cerebras</a> as the inference provider:',cn,ve,rn,k,pn,Ze,un,ke,gs=`An async version of the client is also provided, based on <code>asyncio</code> and <code>aiohttp</code>. You can either install <code>aiohttp</code>
directly or use the <code>[inference]</code> extra:`,hn,qe,Mn,We,fs=`After installation all async API endpoints are available via <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.AsyncInferenceClient">AsyncInferenceClient</a>. Its initialization and APIs are
strictly the same as the sync-only version.`,gn,Be,fn,Ge,ms='For more information about the <code>asyncio</code> module, please refer to the <a href="https://docs.python.org/3/library/asyncio.html" rel="nofollow">official documentation</a>.',mn,Ne,yn,Qe,ys='The <code>huggingface_hub</code> library now includes an experimental <a href="/docs/huggingface_hub/main/en/package_reference/mcp#huggingface_hub.MCPClient">MCPClient</a>, designed to empower Large Language Models (LLMs) with the ability to interact with external Tools via the <a href="https://modelcontextprotocol.io" rel="nofollow">Model Context Protocol</a> (MCP). This client extends an <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.AsyncInferenceClient">AsyncInferenceClient</a> to seamlessly integrate Tool usage.',Jn,Ee,Js='The <a href="/docs/huggingface_hub/main/en/package_reference/mcp#huggingface_hub.MCPClient">MCPClient</a> connects to MCP servers (either local <code>stdio</code> scripts or remote <code>http</code>/<code>sse</code> services) that expose tools. It feeds these tools to an LLM (via <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.AsyncInferenceClient">AsyncInferenceClient</a>). If the LLM decides to use a tool, <a href="/docs/huggingface_hub/main/en/package_reference/mcp#huggingface_hub.MCPClient">MCPClient</a> manages the execution request to the MCP server and relays the Tool’s output back to the LLM, often streaming results in real-time.',Tn,xe,Ts='In the following example, we use <a href="https://huggingface.co/Qwen/Qwen2.5-72B-Instruct" rel="nofollow">Qwen/Qwen2.5-72B-Instruct</a> model via <a href="https://nebius.com/" rel="nofollow">Nebius</a> inference provider. We then add a remote MCP server, in this case, an SSE server which made the Flux image generation tool available to the LLM.',wn,Se,In,Ve,ws='For even simpler development, we offer a higher-level <a href="/docs/huggingface_hub/main/en/package_reference/mcp#huggingface_hub.Agent">Agent</a> class. This ‘Tiny Agent’ simplifies creating conversational Agents by managing the chat loop and state, essentially acting as a wrapper around <a href="/docs/huggingface_hub/main/en/package_reference/mcp#huggingface_hub.MCPClient">MCPClient</a>. It’s designed to be a simple while loop built right on top of an <a href="/docs/huggingface_hub/main/en/package_reference/mcp#huggingface_hub.MCPClient">MCPClient</a>. You can run these Agents directly from the command line:',jn,Ye,Un,He,Is="When launched, the Agent will load, list the Tools it has discovered from its connected MCP servers, and then it’s ready for your prompts!",Cn,Le,bn,Xe,js='In the above section, we saw the main aspects of <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>. Let’s dive into some more advanced tips.',_n,ze,$n,Re,Us='As an HF user, you get monthly credits to run inference through various providers on the Hub. The amount of credits you get depends on your type of account (Free or PRO or Enterprise Hub). You get charged for every inference request, depending on the provider’s pricing table. By default, the requests are billed to your personal account. However, it is possible to set the billing so that requests are charged to an organization you are part of by simply passing <code>bill_to=&quot;&lt;your_org_name&gt;&quot;</code> to <code>InferenceClient</code>. For this to work, your organization must be subscribed to Enterprise Hub. For more details about billing, check out <a href="https://huggingface.co/docs/api-inference/pricing#features-using-inference-providers" rel="nofollow">this guide</a>.',An,Fe,vn,Pe,Cs="Note that it is NOT possible to charge another user or an organization you are not part of. If you want to grant someone else some credits, you must create a joint organization with them.",Zn,Oe,kn,De,bs='Inference calls can take a significant amount of time. By default, <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> will wait “indefinitely” until the inference complete. If you want more control in your workflow, you can set the <code>timeout</code> parameter to a specific value in seconds. If the timeout delay expires, an <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError">InferenceTimeoutError</a> is raised, which you can catch in your code:',qn,Ke,Wn,et,Bn,tt,_s=`Some tasks require binary inputs, for example, when dealing with images or audio files. In this case, <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
tries to be as permissive as possible and accept different types:`,Gn,nt,$s=`<li>raw <code>bytes</code></li> <li>a file-like object, opened as binary (<code>with open(&quot;audio.flac&quot;, &quot;rb&quot;) as f: ...</code>)</li> <li>a path (<code>str</code> or <code>Path</code>) pointing to a local file</li> <li>a URL (<code>str</code>) pointing to a remote file (e.g. <code>https://...</code>). In this case, the file will be downloaded locally before
being sent to the API.</li>`,Nn,st,Qn,lt,En,at,xn;return U=new I({props:{title:"Run Inference on servers",local:"run-inference-on-servers",headingTag:"h1"}}),C=new q({props:{$$slots:{default:[Xs]},$$scope:{ctx:w}}}),N=new I({props:{title:"Getting started",local:"getting-started",headingTag:"h2"}}),E=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQXJlcGxpY2F0ZV9jbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoJTBBcmVwbGljYXRlX2ltYWdlJTIwJTNEJTIwcmVwbGljYXRlX2NsaWVudC50ZXh0X3RvX2ltYWdlKCUwQXJlcGxpY2F0ZV9pbWFnZS5zYXZlKCUyMmZseWluZ19jYXIucG5nJTIyKSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

<span class="hljs-comment"># Example with an external provider (e.g. replicate)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>replicate_client = InferenceClient(
    provider=<span class="hljs-string">&quot;replicate&quot;</span>,
    api_key=<span class="hljs-string">&quot;my_replicate_api_key&quot;</span>,
)
<span class="hljs-meta">&gt;&gt;&gt; </span>replicate_image = replicate_client.text_to_image(
    <span class="hljs-string">&quot;A flying car crossing a futuristic cityscape.&quot;</span>,
    model=<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
)
<span class="hljs-meta">&gt;&gt;&gt; </span>replicate_image.save(<span class="hljs-string">&quot;flying_car.png&quot;</span>)
`,wrap:!1}}),V=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUwQWNsaWVudC5jaGF0X2NvbXBsZXRpb24obWVzc2FnZXMlMkMlMjBtYXhfdG9rZW5zJTNEMTAwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>,
    }
]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
    provider=<span class="hljs-string">&quot;together&quot;</span>,
    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
    api_key=<span class="hljs-string">&quot;my_together_api_key&quot;</span>,
)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.chat_completion(messages, max_tokens=<span class="hljs-number">100</span>)
ChatCompletionOutput(
    choices=[
        ChatCompletionOutputComplete(
            finish_reason=<span class="hljs-string">&quot;eos_token&quot;</span>,
            index=<span class="hljs-number">0</span>,
            message=ChatCompletionOutputMessage(
                role=<span class="hljs-string">&quot;assistant&quot;</span>, content=<span class="hljs-string">&quot;The capital of France is Paris.&quot;</span>, name=<span class="hljs-literal">None</span>, tool_calls=<span class="hljs-literal">None</span>
            ),
            logprobs=<span class="hljs-literal">None</span>,
        )
    ],
    created=<span class="hljs-number">1719907176</span>,
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;&quot;</span>,
    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
    <span class="hljs-built_in">object</span>=<span class="hljs-string">&quot;text_completion&quot;</span>,
    system_fingerprint=<span class="hljs-string">&quot;2.0.4-sha-f426a33&quot;</span>,
    usage=ChatCompletionOutputUsage(completion_tokens=<span class="hljs-number">8</span>, prompt_tokens=<span class="hljs-number">17</span>, total_tokens=<span class="hljs-number">25</span>),
)`,wrap:!1}}),b=new q({props:{warning:!0,$$slots:{default:[zs]},$$scope:{ctx:w}}}),H=new I({props:{title:"Using a specific provider",local:"using-a-specific-provider",headingTag:"h3"}}),X=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUyMGFwaV9rZXklM0QlMjJteV9yZXBsaWNhdGVfYXBpX2tleSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(provider=<span class="hljs-string">&quot;replicate&quot;</span>, api_key=<span class="hljs-string">&quot;my_replicate_api_key&quot;</span>)`,wrap:!1}}),z=new I({props:{title:"Using a specific model",local:"using-a-specific-model",headingTag:"h3"}}),F=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChwcm92aWRlciUzRCUyMnRvZ2V0aGVyJTIyJTJDJTIwbW9kZWwlM0QlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMy4xLThCLUluc3RydWN0JTIyKSUwQWNsaWVudC50ZXh0X3RvX2ltYWdlKC4uLiklMEFjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQocHJvdmlkZXIlM0QlMjJ0b2dldGhlciUyMiklMEFjbGllbnQudGV4dF90b19pbWFnZSguLi4lMkMlMjBtb2RlbCUzRCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjEtOEItSW5zdHJ1Y3QlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-comment"># Initialize client for a specific model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(provider=<span class="hljs-string">&quot;together&quot;</span>, model=<span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(...)
<span class="hljs-comment"># Or use a generic client but pass your model as an argument</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(provider=<span class="hljs-string">&quot;together&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(..., model=<span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>)`,wrap:!1}}),_=new q({props:{$$slots:{default:[Rs]},$$scope:{ctx:w}}}),P=new I({props:{title:"Using Inference Endpoints",local:"using-inference-endpoints",headingTag:"h3"}}),D=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRCUyMmh0dHBzJTNBJTJGJTJGdXUxNDlyZXo2Z3c5ZWhlai5ldS13ZXN0LTEuYXdzLmVuZHBvaW50cy5odWdnaW5nZmFjZS5jbG91ZCUyRmRlZXBmbG95ZC1pZiUyMiklMEFjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoKSUwQWNsaWVudC50ZXh0X3RvX2ltYWdlKC4uLiUyQyUyMG1vZGVsJTNEJTIyaHR0cHMlM0ElMkYlMkZ1dTE0OXJlejZndzllaGVqLmV1LXdlc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGZGVlcGZsb3lkLWlmJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(model=<span class="hljs-string">&quot;https://uu149rez6gw9ehej.eu-west-1.aws.endpoints.huggingface.cloud/deepfloyd-if&quot;</span>)
<span class="hljs-comment"># or</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(..., model=<span class="hljs-string">&quot;https://uu149rez6gw9ehej.eu-west-1.aws.endpoints.huggingface.cloud/deepfloyd-if&quot;</span>)`,wrap:!1}}),ee=new I({props:{title:"Using local endpoints",local:"using-local-endpoints",headingTag:"h3"}}),ne=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRCUyMmh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E4MDgwJTIyKSUwQSUwQXJlc3BvbnNlJTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyJTdEJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDEwMCUwQSklMEFwcmludChyZXNwb25zZS5jaG9pY2VzJTVCMCU1RC5tZXNzYWdlLmNvbnRlbnQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(model=<span class="hljs-string">&quot;http://localhost:8080&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.chat.completions.create(
<span class="hljs-meta">... </span>    messages=[
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">100</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(response.choices[<span class="hljs-number">0</span>].message.content)`,wrap:!1}}),$=new q({props:{$$slots:{default:[Fs]},$$scope:{ctx:w}}}),se=new I({props:{title:"Authentication",local:"authentication",headingTag:"h3"}}),oe=new T({props:{code:"Y2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
    provider=<span class="hljs-string">&quot;replicate&quot;</span>,
    api_key=<span class="hljs-string">&quot;hf_****&quot;</span>  <span class="hljs-comment"># Your HF token</span>
)`,wrap:!1}}),ce=new T({props:{code:"Y2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
    provider=<span class="hljs-string">&quot;replicate&quot;</span>,
    token=<span class="hljs-string">&quot;hf_****&quot;</span>  <span class="hljs-comment"># Your HF token</span>
)`,wrap:!1}}),pe=new T({props:{code:"Y2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
    provider=<span class="hljs-string">&quot;replicate&quot;</span>,
    api_key=<span class="hljs-string">&quot;r8_****&quot;</span>  <span class="hljs-comment"># Your Replicate API key</span>
)`,wrap:!1}}),he=new I({props:{title:"Supported providers and tasks",local:"supported-providers-and-tasks",headingTag:"h2"}}),A=new q({props:{$$slots:{default:[Ps]},$$scope:{ctx:w}}}),fe=new I({props:{title:"OpenAI compatibility",local:"openai-compatibility",headingTag:"h2"}}),ye=new T({props:{code:"LSUyMGZyb20lMjBvcGVuYWklMjBpbXBvcnQlMjBPcGVuQUklMEElMkIlMjBmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwSW5mZXJlbmNlQ2xpZW50JTBBJTBBLSUyMGNsaWVudCUyMCUzRCUyME9wZW5BSSglMEElMkIlMjBjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoJTBBJTIwJTIwJTIwJTIwYmFzZV91cmwlM0QuLi4lMkMlMEElMjAlMjAlMjAlMjBhcGlfa2V5JTNELi4uJTJDJTBBKSUwQSUwQSUwQW91dHB1dCUyMCUzRCUyMGNsaWVudC5jaGF0LmNvbXBsZXRpb25zLmNyZWF0ZSglMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQ291bnQlMjB0byUyMDEwJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwc3RyZWFtJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QxMDI0JTJDJTBBKSUwQSUwQWZvciUyMGNodW5rJTIwaW4lMjBvdXRwdXQlM0ElMEElMjAlMjAlMjAlMjBwcmludChjaHVuay5jaG9pY2VzJTVCMCU1RC5kZWx0YS5jb250ZW50KQ==",highlighted:`<span class="hljs-deletion">- from openai import OpenAI</span>
<span class="hljs-addition">+ from huggingface_hub import InferenceClient</span>

<span class="hljs-deletion">- client = OpenAI(</span>
<span class="hljs-addition">+ client = InferenceClient(</span>
    base_url=...,
    api_key=...,
)


output = client.chat.completions.create(
    model=&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;,
    messages=[
        {&quot;role&quot;: &quot;system&quot;, &quot;content&quot;: &quot;You are a helpful assistant.&quot;},
        {&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;Count to 10&quot;},
    ],
    stream=True,
    max_tokens=1024,
)

for chunk in output:
    print(chunk.choices[0].delta.content)`,wrap:!1}}),we=new T({props:{code:"aW1wb3J0JTIwYXN5bmNpbyUwQS0lMjBmcm9tJTIwb3BlbmFpJTIwaW1wb3J0JTIwQXN5bmNPcGVuQUklMEElMkIlMjBmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwQXN5bmNJbmZlcmVuY2VDbGllbnQlMEElMEEtJTIwY2xpZW50JTIwJTNEJTIwQXN5bmNPcGVuQUkoKSUwQSUyQiUyMGNsaWVudCUyMCUzRCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50KCklMEElMEFhc3luYyUyMGRlZiUyMG1haW4oKSUzQSUwQSUyMCUyMCUyMCUyMHN0cmVhbSUyMCUzRCUyMGF3YWl0JTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTNEJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyU2F5JTIwdGhpcyUyMGlzJTIwYSUyMHRlc3QlMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdHJlYW0lM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZm9yJTIwY2h1bmslMjBpbiUyMHN0cmVhbSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGNodW5rLmNob2ljZXMlNUIwJTVELmRlbHRhLmNvbnRlbnQlMjBvciUyMCUyMiUyMiUyQyUyMGVuZCUzRCUyMiUyMiklMEElMEFhc3luY2lvLnJ1bihtYWluKCkp",highlighted:`import asyncio
<span class="hljs-deletion">- from openai import AsyncOpenAI</span>
<span class="hljs-addition">+ from huggingface_hub import AsyncInferenceClient</span>

<span class="hljs-deletion">- client = AsyncOpenAI()</span>
<span class="hljs-addition">+ client = AsyncInferenceClient()</span>

async def main():
    stream = await client.chat.completions.create(
        model=&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;,
        messages=[{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;Say this is a test&quot;}],
        stream=True,
    )
    async for chunk in stream:
        print(chunk.choices[0].delta.content or &quot;&quot;, end=&quot;&quot;)

asyncio.run(main())`,wrap:!1}}),v=new q({props:{$$slots:{default:[Os]},$$scope:{ctx:w}}}),Ue=new I({props:{title:"Function Calling",local:"function-calling",headingTag:"h2"}}),be=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

tools = [
        {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
            <span class="hljs-string">&quot;function&quot;</span>: {
                <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
                <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get current temperature for a given location.&quot;</span>,
                <span class="hljs-string">&quot;parameters&quot;</span>: {
                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
                    <span class="hljs-string">&quot;properties&quot;</span>: {
                        <span class="hljs-string">&quot;location&quot;</span>: {
                            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
                            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;City and country e.g. Paris, France&quot;</span>
                        }
                    },
                    <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>],
                },
            }
        }
]

client = InferenceClient(provider=<span class="hljs-string">&quot;nebius&quot;</span>)

response = client.chat.completions.create(
    model=<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>,
    messages=[
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weather like the next 3 days in London, UK?&quot;</span>
    }
    ],
    tools=tools,
    tool_choice=<span class="hljs-string">&quot;auto&quot;</span>,
)

<span class="hljs-built_in">print</span>(response.choices[<span class="hljs-number">0</span>].message.tool_calls[<span class="hljs-number">0</span>].function.arguments)
`,wrap:!1}}),Z=new q({props:{$$slots:{default:[Ds]},$$scope:{ctx:w}}}),_e=new I({props:{title:"Structured Outputs & JSON Mode",local:"structured-outputs--json-mode",headingTag:"h2"}}),ve=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

json_schema = {
    <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;book&quot;</span>,
    <span class="hljs-string">&quot;schema&quot;</span>: {
        <span class="hljs-string">&quot;properties&quot;</span>: {
            <span class="hljs-string">&quot;name&quot;</span>: {
                <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;Name&quot;</span>,
                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            },
            <span class="hljs-string">&quot;authors&quot;</span>: {
                <span class="hljs-string">&quot;items&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
                <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;Authors&quot;</span>,
                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>,
            },
        },
        <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;name&quot;</span>, <span class="hljs-string">&quot;authors&quot;</span>],
        <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;Book&quot;</span>,
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
    },
    <span class="hljs-string">&quot;strict&quot;</span>: <span class="hljs-literal">True</span>,
}

client = InferenceClient(provider=<span class="hljs-string">&quot;cerebras&quot;</span>)


completion = client.chat.completions.create(
    model=<span class="hljs-string">&quot;Qwen/Qwen3-32B&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Extract the books information.&quot;</span>},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I recently read &#x27;The Great Gatsby&#x27; by F. Scott Fitzgerald.&quot;</span>},
    ],
    response_format={
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json_schema&quot;</span>,
        <span class="hljs-string">&quot;json_schema&quot;</span>: json_schema,
    },
)

<span class="hljs-built_in">print</span>(completion.choices[<span class="hljs-number">0</span>].message)`,wrap:!1}}),k=new q({props:{$$slots:{default:[Ks]},$$scope:{ctx:w}}}),Ze=new I({props:{title:"Async client",local:"async-client",headingTag:"h2"}}),qe=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMGh1Z2dpbmdmYWNlX2h1YiU1QmluZmVyZW5jZSU1RCUwQSUyMyUyMG9yJTBBJTIzJTIwcGlwJTIwaW5zdGFsbCUyMGFpb2h0dHA=",highlighted:`pip install --upgrade huggingface_hub[inference]
<span class="hljs-comment"># or</span>
<span class="hljs-comment"># pip install aiohttp</span>`,wrap:!1}}),Be=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKSUwQSUwQWFzeW5jJTIwZm9yJTIwdG9rZW4lMjBpbiUyMGF3YWl0JTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMjJUaGUlMjBIdWdnaW5nZmFjZSUyMEh1YiUyMGlzJTIyJTJDJTIwc3RyZWFtJTNEVHJ1ZSklM0ElMEElMjAlMjAlMjAlMjBwcmludCh0b2tlbiUyQyUyMGVuZCUzRCUyMiUyMik=",highlighted:`<span class="hljs-comment"># Code must be run in an asyncio concurrent context.</span>
<span class="hljs-comment"># $ python -m asyncio</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The Huggingface Hub is&quot;</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token, end=<span class="hljs-string">&quot;&quot;</span>)
 a platform <span class="hljs-keyword">for</span> sharing <span class="hljs-keyword">and</span> discussing ML-related content.`,wrap:!1}}),Ne=new I({props:{title:"MCP Client",local:"mcp-client",headingTag:"h2"}}),Se=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> os

<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ChatCompletionInputMessage, ChatCompletionStreamOutput, MCPClient


<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">with</span> MCPClient(
        provider=<span class="hljs-string">&quot;nebius&quot;</span>,
        model=<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>,
        api_key=os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>],
    ) <span class="hljs-keyword">as</span> client:
        <span class="hljs-keyword">await</span> client.add_mcp_server(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;sse&quot;</span>, url=<span class="hljs-string">&quot;https://evalstate-flux1-schnell.hf.space/gradio_api/mcp/sse&quot;</span>)

        messages = [
            {
                <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
                <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Generate a picture of a cat on the moon&quot;</span>,
            }
        ]

        <span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> chunk <span class="hljs-keyword">in</span> client.process_single_turn_with_tools(messages):
            <span class="hljs-comment"># Log messages</span>
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(chunk, ChatCompletionStreamOutput):
                delta = chunk.choices[<span class="hljs-number">0</span>].delta
                <span class="hljs-keyword">if</span> delta.content:
                    <span class="hljs-built_in">print</span>(delta.content, end=<span class="hljs-string">&quot;&quot;</span>)

            <span class="hljs-comment"># Or tool calls</span>
            <span class="hljs-keyword">elif</span> <span class="hljs-built_in">isinstance</span>(chunk, ChatCompletionInputMessage):
                <span class="hljs-built_in">print</span>(
                    <span class="hljs-string">f&quot;\\nCalled tool &#x27;<span class="hljs-subst">{chunk.name}</span>&#x27;. Result: &#x27;<span class="hljs-subst">{chunk.content <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(chunk.content) &lt; <span class="hljs-number">1000</span> <span class="hljs-keyword">else</span> chunk.content[:<span class="hljs-number">1000</span>] + <span class="hljs-string">&#x27;...&#x27;</span>}</span>&#x27;&quot;</span>
                )


<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    <span class="hljs-keyword">import</span> asyncio

    asyncio.run(main())`,wrap:!1}}),Ye=new T({props:{code:"JTIzJTIwaW5zdGFsbCUyMGxhdGVzdCUyMHZlcnNpb24lMjBvZiUyMGh1Z2dpbmdmYWNlX2h1YiUyMHdpdGglMjB0aGUlMjBtY3AlMjBleHRyYSUwQXBpcCUyMGluc3RhbGwlMjAtVSUyMGh1Z2dpbmdmYWNlX2h1YiU1Qm1jcCU1RCUwQSUyMyUyMFJ1biUyMGFuJTIwYWdlbnQlMjB0aGF0JTIwdXNlcyUyMHRoZSUyMEZsdXglMjBpbWFnZSUyMGdlbmVyYXRpb24lMjB0b29sJTBBdGlueS1hZ2VudHMlMjBydW4lMjBqdWxpZW4tYyUyRmZsdXgtc2NobmVsbC1nZW5lcmF0b3IlMEE=",highlighted:`<span class="hljs-comment"># install latest version of huggingface_hub with the mcp extra</span>
pip install -U huggingface_hub[mcp]
<span class="hljs-comment"># Run an agent that uses the Flux image generation tool</span>
tiny-agents run julien-c/flux-schnell-generator
`,wrap:!1}}),Le=new I({props:{title:"Advanced tips",local:"advanced-tips",headingTag:"h2"}}),ze=new I({props:{title:"Billing",local:"billing",headingTag:"h3"}}),Fe=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChwcm92aWRlciUzRCUyMmZhbC1haSUyMiUyQyUyMGJpbGxfdG8lM0QlMjJvcGVuYWklMjIpJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQudGV4dF90b19pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJBJTIwbWFqZXN0aWMlMjBsaW9uJTIwaW4lMjBhJTIwZmFudGFzeSUyMGZvcmVzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtc2NobmVsbCUyMiUyQyUwQSklMEFpbWFnZS5zYXZlKCUyMmxpb24ucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(provider=<span class="hljs-string">&quot;fal-ai&quot;</span>, bill_to=<span class="hljs-string">&quot;openai&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A majestic lion in a fantasy forest&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;lion.png&quot;</span>)`,wrap:!1}}),Oe=new I({props:{title:"Timeout",local:"timeout",headingTag:"h3"}}),Ke=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUyQyUyMEluZmVyZW5jZVRpbWVvdXRFcnJvciUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCh0aW1lb3V0JTNEMzApJTBBdHJ5JTNBJTBBJTIwJTIwJTIwJTIwY2xpZW50LnRleHRfdG9faW1hZ2UoLi4uKSUwQWV4Y2VwdCUyMEluZmVyZW5jZVRpbWVvdXRFcnJvciUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMkluZmVyZW5jZSUyMHRpbWVkJTIwb3V0JTIwYWZ0ZXIlMjAzMHMuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient, InferenceTimeoutError
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(timeout=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">try</span>:
<span class="hljs-meta">... </span>    client.text_to_image(...)
<span class="hljs-meta">... </span><span class="hljs-keyword">except</span> InferenceTimeoutError:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Inference timed out after 30s.&quot;</span>)`,wrap:!1}}),et=new I({props:{title:"Binary inputs",local:"binary-inputs",headingTag:"h3"}}),st=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX2NsYXNzaWZpY2F0aW9uKCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_classification(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9779096841812134</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Blenheim spaniel&#x27;</span>}, ...]`,wrap:!1}}),lt=new Ls({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/inference.md"}}),{c(){i=o("meta"),y=l(),r=o("p"),m=l(),p(U.$$.fragment),J=l(),j=o("p"),j.innerHTML=Sn,it=l(),B=o("ol"),B.innerHTML=Vn,ot=l(),G=o("p"),G.innerHTML=Yn,dt=l(),p(C.$$.fragment),ct=l(),p(N.$$.fragment),rt=l(),Q=o("p"),Q.textContent=Hn,pt=l(),p(E.$$.fragment),ut=l(),x=o("p"),x.innerHTML=Ln,ht=l(),S=o("p"),S.innerHTML=Xn,Mt=l(),p(V.$$.fragment),gt=l(),Y=o("p"),Y.innerHTML=zn,ft=l(),p(b.$$.fragment),mt=l(),p(H.$$.fragment),yt=l(),L=o("p"),L.innerHTML=Rn,Jt=l(),p(X.$$.fragment),Tt=l(),p(z.$$.fragment),wt=l(),R=o("p"),R.textContent=Fn,It=l(),p(F.$$.fragment),jt=l(),p(_.$$.fragment),Ut=l(),p(P.$$.fragment),Ct=l(),O=o("p"),O.innerHTML=Pn,bt=l(),p(D.$$.fragment),_t=l(),K=o("p"),K.textContent=On,$t=l(),p(ee.$$.fragment),At=l(),te=o("p"),te.innerHTML=Dn,vt=l(),p(ne.$$.fragment),Zt=l(),p($.$$.fragment),kt=l(),p(se.$$.fragment),qt=l(),le=o("p"),le.textContent=Kn,Wt=l(),ae=o("p"),ae.innerHTML=es,Bt=l(),ie=o("p"),ie.innerHTML=ts,Gt=l(),p(oe.$$.fragment),Nt=l(),de=o("p"),de.innerHTML=ns,Qt=l(),p(ce.$$.fragment),Et=l(),re=o("p"),re.innerHTML=ss,xt=l(),p(pe.$$.fragment),St=l(),ue=o("p"),ue.innerHTML=ls,Vt=l(),p(he.$$.fragment),Yt=l(),Me=o("p"),Me.innerHTML=as,Ht=l(),ge=o("table"),ge.innerHTML=is,Lt=l(),p(A.$$.fragment),Xt=l(),p(fe.$$.fragment),zt=l(),me=o("p"),me.innerHTML=os,Rt=l(),p(ye.$$.fragment),Ft=l(),Je=o("p"),Je.innerHTML=ds,Pt=l(),Te=o("p"),Te.innerHTML=cs,Ot=l(),p(we.$$.fragment),Dt=l(),Ie=o("p"),Ie.innerHTML=rs,Kt=l(),je=o("ol"),je.innerHTML=ps,en=l(),p(v.$$.fragment),tn=l(),p(Ue.$$.fragment),nn=l(),Ce=o("p"),Ce.innerHTML=us,sn=l(),p(be.$$.fragment),ln=l(),p(Z.$$.fragment),an=l(),p(_e.$$.fragment),on=l(),$e=o("p"),$e.textContent=hs,dn=l(),Ae=o("p"),Ae.innerHTML=Ms,cn=l(),p(ve.$$.fragment),rn=l(),p(k.$$.fragment),pn=l(),p(Ze.$$.fragment),un=l(),ke=o("p"),ke.innerHTML=gs,hn=l(),p(qe.$$.fragment),Mn=l(),We=o("p"),We.innerHTML=fs,gn=l(),p(Be.$$.fragment),fn=l(),Ge=o("p"),Ge.innerHTML=ms,mn=l(),p(Ne.$$.fragment),yn=l(),Qe=o("p"),Qe.innerHTML=ys,Jn=l(),Ee=o("p"),Ee.innerHTML=Js,Tn=l(),xe=o("p"),xe.innerHTML=Ts,wn=l(),p(Se.$$.fragment),In=l(),Ve=o("p"),Ve.innerHTML=ws,jn=l(),p(Ye.$$.fragment),Un=l(),He=o("p"),He.textContent=Is,Cn=l(),p(Le.$$.fragment),bn=l(),Xe=o("p"),Xe.innerHTML=js,_n=l(),p(ze.$$.fragment),$n=l(),Re=o("p"),Re.innerHTML=Us,An=l(),p(Fe.$$.fragment),vn=l(),Pe=o("p"),Pe.textContent=Cs,Zn=l(),p(Oe.$$.fragment),kn=l(),De=o("p"),De.innerHTML=bs,qn=l(),p(Ke.$$.fragment),Wn=l(),p(et.$$.fragment),Bn=l(),tt=o("p"),tt.innerHTML=_s,Gn=l(),nt=o("ul"),nt.innerHTML=$s,Nn=l(),p(st.$$.fragment),Qn=l(),p(lt.$$.fragment),En=l(),at=o("p"),this.h()},l(e){const t=Ys("svelte-u9bgzb",document.head);i=d(t,"META",{name:!0,content:!0}),t.forEach(n),y=a(e),r=d(e,"P",{}),Ns(r).forEach(n),m=a(e),u(U.$$.fragment,e),J=a(e),j=d(e,"P",{"data-svelte-h":!0}),c(j)!=="svelte-zsbuba"&&(j.innerHTML=Sn),it=a(e),B=d(e,"OL",{"data-svelte-h":!0}),c(B)!=="svelte-113kt9p"&&(B.innerHTML=Vn),ot=a(e),G=d(e,"P",{"data-svelte-h":!0}),c(G)!=="svelte-1vbf08n"&&(G.innerHTML=Yn),dt=a(e),u(C.$$.fragment,e),ct=a(e),u(N.$$.fragment,e),rt=a(e),Q=d(e,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-8lplub"&&(Q.textContent=Hn),pt=a(e),u(E.$$.fragment,e),ut=a(e),x=d(e,"P",{"data-svelte-h":!0}),c(x)!=="svelte-181xjky"&&(x.innerHTML=Ln),ht=a(e),S=d(e,"P",{"data-svelte-h":!0}),c(S)!=="svelte-1d6dn6"&&(S.innerHTML=Xn),Mt=a(e),u(V.$$.fragment,e),gt=a(e),Y=d(e,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-19dgkah"&&(Y.innerHTML=zn),ft=a(e),u(b.$$.fragment,e),mt=a(e),u(H.$$.fragment,e),yt=a(e),L=d(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-1uw3jfu"&&(L.innerHTML=Rn),Jt=a(e),u(X.$$.fragment,e),Tt=a(e),u(z.$$.fragment,e),wt=a(e),R=d(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-1npu22n"&&(R.textContent=Fn),It=a(e),u(F.$$.fragment,e),jt=a(e),u(_.$$.fragment,e),Ut=a(e),u(P.$$.fragment,e),Ct=a(e),O=d(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-iygc0l"&&(O.innerHTML=Pn),bt=a(e),u(D.$$.fragment,e),_t=a(e),K=d(e,"P",{"data-svelte-h":!0}),c(K)!=="svelte-1yhw21f"&&(K.textContent=On),$t=a(e),u(ee.$$.fragment,e),At=a(e),te=d(e,"P",{"data-svelte-h":!0}),c(te)!=="svelte-76vbgt"&&(te.innerHTML=Dn),vt=a(e),u(ne.$$.fragment,e),Zt=a(e),u($.$$.fragment,e),kt=a(e),u(se.$$.fragment,e),qt=a(e),le=d(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-ifnzw0"&&(le.textContent=Kn),Wt=a(e),ae=d(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-s1ttf4"&&(ae.innerHTML=es),Bt=a(e),ie=d(e,"P",{"data-svelte-h":!0}),c(ie)!=="svelte-vhv07e"&&(ie.innerHTML=ts),Gt=a(e),u(oe.$$.fragment,e),Nt=a(e),de=d(e,"P",{"data-svelte-h":!0}),c(de)!=="svelte-jlpf96"&&(de.innerHTML=ns),Qt=a(e),u(ce.$$.fragment,e),Et=a(e),re=d(e,"P",{"data-svelte-h":!0}),c(re)!=="svelte-zxs6jj"&&(re.innerHTML=ss),xt=a(e),u(pe.$$.fragment,e),St=a(e),ue=d(e,"P",{"data-svelte-h":!0}),c(ue)!=="svelte-1sxee5g"&&(ue.innerHTML=ls),Vt=a(e),u(he.$$.fragment,e),Yt=a(e),Me=d(e,"P",{"data-svelte-h":!0}),c(Me)!=="svelte-qhknp8"&&(Me.innerHTML=as),Ht=a(e),ge=d(e,"TABLE",{"data-svelte-h":!0}),c(ge)!=="svelte-1me42hz"&&(ge.innerHTML=is),Lt=a(e),u(A.$$.fragment,e),Xt=a(e),u(fe.$$.fragment,e),zt=a(e),me=d(e,"P",{"data-svelte-h":!0}),c(me)!=="svelte-bmxago"&&(me.innerHTML=os),Rt=a(e),u(ye.$$.fragment,e),Ft=a(e),Je=d(e,"P",{"data-svelte-h":!0}),c(Je)!=="svelte-94ddrt"&&(Je.innerHTML=ds),Pt=a(e),Te=d(e,"P",{"data-svelte-h":!0}),c(Te)!=="svelte-1wef96y"&&(Te.innerHTML=cs),Ot=a(e),u(we.$$.fragment,e),Dt=a(e),Ie=d(e,"P",{"data-svelte-h":!0}),c(Ie)!=="svelte-u2g99k"&&(Ie.innerHTML=rs),Kt=a(e),je=d(e,"OL",{"data-svelte-h":!0}),c(je)!=="svelte-zypjkb"&&(je.innerHTML=ps),en=a(e),u(v.$$.fragment,e),tn=a(e),u(Ue.$$.fragment,e),nn=a(e),Ce=d(e,"P",{"data-svelte-h":!0}),c(Ce)!=="svelte-1msz1zo"&&(Ce.innerHTML=us),sn=a(e),u(be.$$.fragment,e),ln=a(e),u(Z.$$.fragment,e),an=a(e),u(_e.$$.fragment,e),on=a(e),$e=d(e,"P",{"data-svelte-h":!0}),c($e)!=="svelte-1azpgbc"&&($e.textContent=hs),dn=a(e),Ae=d(e,"P",{"data-svelte-h":!0}),c(Ae)!=="svelte-3p40p5"&&(Ae.innerHTML=Ms),cn=a(e),u(ve.$$.fragment,e),rn=a(e),u(k.$$.fragment,e),pn=a(e),u(Ze.$$.fragment,e),un=a(e),ke=d(e,"P",{"data-svelte-h":!0}),c(ke)!=="svelte-1gqwj00"&&(ke.innerHTML=gs),hn=a(e),u(qe.$$.fragment,e),Mn=a(e),We=d(e,"P",{"data-svelte-h":!0}),c(We)!=="svelte-1bdjfju"&&(We.innerHTML=fs),gn=a(e),u(Be.$$.fragment,e),fn=a(e),Ge=d(e,"P",{"data-svelte-h":!0}),c(Ge)!=="svelte-q492az"&&(Ge.innerHTML=ms),mn=a(e),u(Ne.$$.fragment,e),yn=a(e),Qe=d(e,"P",{"data-svelte-h":!0}),c(Qe)!=="svelte-1th564v"&&(Qe.innerHTML=ys),Jn=a(e),Ee=d(e,"P",{"data-svelte-h":!0}),c(Ee)!=="svelte-nzyq5x"&&(Ee.innerHTML=Js),Tn=a(e),xe=d(e,"P",{"data-svelte-h":!0}),c(xe)!=="svelte-puwxdd"&&(xe.innerHTML=Ts),wn=a(e),u(Se.$$.fragment,e),In=a(e),Ve=d(e,"P",{"data-svelte-h":!0}),c(Ve)!=="svelte-1epk0qj"&&(Ve.innerHTML=ws),jn=a(e),u(Ye.$$.fragment,e),Un=a(e),He=d(e,"P",{"data-svelte-h":!0}),c(He)!=="svelte-e0mc18"&&(He.textContent=Is),Cn=a(e),u(Le.$$.fragment,e),bn=a(e),Xe=d(e,"P",{"data-svelte-h":!0}),c(Xe)!=="svelte-2b1sa3"&&(Xe.innerHTML=js),_n=a(e),u(ze.$$.fragment,e),$n=a(e),Re=d(e,"P",{"data-svelte-h":!0}),c(Re)!=="svelte-6rcpvw"&&(Re.innerHTML=Us),An=a(e),u(Fe.$$.fragment,e),vn=a(e),Pe=d(e,"P",{"data-svelte-h":!0}),c(Pe)!=="svelte-1hpvtqi"&&(Pe.textContent=Cs),Zn=a(e),u(Oe.$$.fragment,e),kn=a(e),De=d(e,"P",{"data-svelte-h":!0}),c(De)!=="svelte-t8yvyu"&&(De.innerHTML=bs),qn=a(e),u(Ke.$$.fragment,e),Wn=a(e),u(et.$$.fragment,e),Bn=a(e),tt=d(e,"P",{"data-svelte-h":!0}),c(tt)!=="svelte-4hhs15"&&(tt.innerHTML=_s),Gn=a(e),nt=d(e,"UL",{"data-svelte-h":!0}),c(nt)!=="svelte-1o9a3e0"&&(nt.innerHTML=$s),Nn=a(e),u(st.$$.fragment,e),Qn=a(e),u(lt.$$.fragment,e),En=a(e),at=d(e,"P",{}),Ns(at).forEach(n),this.h()},h(){Qs(i,"name","hf:doc:metadata"),Qs(i,"content",tl)},m(e,t){Hs(document.head,i),s(e,y,t),s(e,r,t),s(e,m,t),h(U,e,t),s(e,J,t),s(e,j,t),s(e,it,t),s(e,B,t),s(e,ot,t),s(e,G,t),s(e,dt,t),h(C,e,t),s(e,ct,t),h(N,e,t),s(e,rt,t),s(e,Q,t),s(e,pt,t),h(E,e,t),s(e,ut,t),s(e,x,t),s(e,ht,t),s(e,S,t),s(e,Mt,t),h(V,e,t),s(e,gt,t),s(e,Y,t),s(e,ft,t),h(b,e,t),s(e,mt,t),h(H,e,t),s(e,yt,t),s(e,L,t),s(e,Jt,t),h(X,e,t),s(e,Tt,t),h(z,e,t),s(e,wt,t),s(e,R,t),s(e,It,t),h(F,e,t),s(e,jt,t),h(_,e,t),s(e,Ut,t),h(P,e,t),s(e,Ct,t),s(e,O,t),s(e,bt,t),h(D,e,t),s(e,_t,t),s(e,K,t),s(e,$t,t),h(ee,e,t),s(e,At,t),s(e,te,t),s(e,vt,t),h(ne,e,t),s(e,Zt,t),h($,e,t),s(e,kt,t),h(se,e,t),s(e,qt,t),s(e,le,t),s(e,Wt,t),s(e,ae,t),s(e,Bt,t),s(e,ie,t),s(e,Gt,t),h(oe,e,t),s(e,Nt,t),s(e,de,t),s(e,Qt,t),h(ce,e,t),s(e,Et,t),s(e,re,t),s(e,xt,t),h(pe,e,t),s(e,St,t),s(e,ue,t),s(e,Vt,t),h(he,e,t),s(e,Yt,t),s(e,Me,t),s(e,Ht,t),s(e,ge,t),s(e,Lt,t),h(A,e,t),s(e,Xt,t),h(fe,e,t),s(e,zt,t),s(e,me,t),s(e,Rt,t),h(ye,e,t),s(e,Ft,t),s(e,Je,t),s(e,Pt,t),s(e,Te,t),s(e,Ot,t),h(we,e,t),s(e,Dt,t),s(e,Ie,t),s(e,Kt,t),s(e,je,t),s(e,en,t),h(v,e,t),s(e,tn,t),h(Ue,e,t),s(e,nn,t),s(e,Ce,t),s(e,sn,t),h(be,e,t),s(e,ln,t),h(Z,e,t),s(e,an,t),h(_e,e,t),s(e,on,t),s(e,$e,t),s(e,dn,t),s(e,Ae,t),s(e,cn,t),h(ve,e,t),s(e,rn,t),h(k,e,t),s(e,pn,t),h(Ze,e,t),s(e,un,t),s(e,ke,t),s(e,hn,t),h(qe,e,t),s(e,Mn,t),s(e,We,t),s(e,gn,t),h(Be,e,t),s(e,fn,t),s(e,Ge,t),s(e,mn,t),h(Ne,e,t),s(e,yn,t),s(e,Qe,t),s(e,Jn,t),s(e,Ee,t),s(e,Tn,t),s(e,xe,t),s(e,wn,t),h(Se,e,t),s(e,In,t),s(e,Ve,t),s(e,jn,t),h(Ye,e,t),s(e,Un,t),s(e,He,t),s(e,Cn,t),h(Le,e,t),s(e,bn,t),s(e,Xe,t),s(e,_n,t),h(ze,e,t),s(e,$n,t),s(e,Re,t),s(e,An,t),h(Fe,e,t),s(e,vn,t),s(e,Pe,t),s(e,Zn,t),h(Oe,e,t),s(e,kn,t),s(e,De,t),s(e,qn,t),h(Ke,e,t),s(e,Wn,t),h(et,e,t),s(e,Bn,t),s(e,tt,t),s(e,Gn,t),s(e,nt,t),s(e,Nn,t),h(st,e,t),s(e,Qn,t),h(lt,e,t),s(e,En,t),s(e,at,t),xn=!0},p(e,[t]){const As={};t&2&&(As.$$scope={dirty:t,ctx:e}),C.$set(As);const vs={};t&2&&(vs.$$scope={dirty:t,ctx:e}),b.$set(vs);const Zs={};t&2&&(Zs.$$scope={dirty:t,ctx:e}),_.$set(Zs);const ks={};t&2&&(ks.$$scope={dirty:t,ctx:e}),$.$set(ks);const qs={};t&2&&(qs.$$scope={dirty:t,ctx:e}),A.$set(qs);const Ws={};t&2&&(Ws.$$scope={dirty:t,ctx:e}),v.$set(Ws);const Bs={};t&2&&(Bs.$$scope={dirty:t,ctx:e}),Z.$set(Bs);const Gs={};t&2&&(Gs.$$scope={dirty:t,ctx:e}),k.$set(Gs)},i(e){xn||(M(U.$$.fragment,e),M(C.$$.fragment,e),M(N.$$.fragment,e),M(E.$$.fragment,e),M(V.$$.fragment,e),M(b.$$.fragment,e),M(H.$$.fragment,e),M(X.$$.fragment,e),M(z.$$.fragment,e),M(F.$$.fragment,e),M(_.$$.fragment,e),M(P.$$.fragment,e),M(D.$$.fragment,e),M(ee.$$.fragment,e),M(ne.$$.fragment,e),M($.$$.fragment,e),M(se.$$.fragment,e),M(oe.$$.fragment,e),M(ce.$$.fragment,e),M(pe.$$.fragment,e),M(he.$$.fragment,e),M(A.$$.fragment,e),M(fe.$$.fragment,e),M(ye.$$.fragment,e),M(we.$$.fragment,e),M(v.$$.fragment,e),M(Ue.$$.fragment,e),M(be.$$.fragment,e),M(Z.$$.fragment,e),M(_e.$$.fragment,e),M(ve.$$.fragment,e),M(k.$$.fragment,e),M(Ze.$$.fragment,e),M(qe.$$.fragment,e),M(Be.$$.fragment,e),M(Ne.$$.fragment,e),M(Se.$$.fragment,e),M(Ye.$$.fragment,e),M(Le.$$.fragment,e),M(ze.$$.fragment,e),M(Fe.$$.fragment,e),M(Oe.$$.fragment,e),M(Ke.$$.fragment,e),M(et.$$.fragment,e),M(st.$$.fragment,e),M(lt.$$.fragment,e),xn=!0)},o(e){g(U.$$.fragment,e),g(C.$$.fragment,e),g(N.$$.fragment,e),g(E.$$.fragment,e),g(V.$$.fragment,e),g(b.$$.fragment,e),g(H.$$.fragment,e),g(X.$$.fragment,e),g(z.$$.fragment,e),g(F.$$.fragment,e),g(_.$$.fragment,e),g(P.$$.fragment,e),g(D.$$.fragment,e),g(ee.$$.fragment,e),g(ne.$$.fragment,e),g($.$$.fragment,e),g(se.$$.fragment,e),g(oe.$$.fragment,e),g(ce.$$.fragment,e),g(pe.$$.fragment,e),g(he.$$.fragment,e),g(A.$$.fragment,e),g(fe.$$.fragment,e),g(ye.$$.fragment,e),g(we.$$.fragment,e),g(v.$$.fragment,e),g(Ue.$$.fragment,e),g(be.$$.fragment,e),g(Z.$$.fragment,e),g(_e.$$.fragment,e),g(ve.$$.fragment,e),g(k.$$.fragment,e),g(Ze.$$.fragment,e),g(qe.$$.fragment,e),g(Be.$$.fragment,e),g(Ne.$$.fragment,e),g(Se.$$.fragment,e),g(Ye.$$.fragment,e),g(Le.$$.fragment,e),g(ze.$$.fragment,e),g(Fe.$$.fragment,e),g(Oe.$$.fragment,e),g(Ke.$$.fragment,e),g(et.$$.fragment,e),g(st.$$.fragment,e),g(lt.$$.fragment,e),xn=!1},d(e){e&&(n(y),n(r),n(m),n(J),n(j),n(it),n(B),n(ot),n(G),n(dt),n(ct),n(rt),n(Q),n(pt),n(ut),n(x),n(ht),n(S),n(Mt),n(gt),n(Y),n(ft),n(mt),n(yt),n(L),n(Jt),n(Tt),n(wt),n(R),n(It),n(jt),n(Ut),n(Ct),n(O),n(bt),n(_t),n(K),n($t),n(At),n(te),n(vt),n(Zt),n(kt),n(qt),n(le),n(Wt),n(ae),n(Bt),n(ie),n(Gt),n(Nt),n(de),n(Qt),n(Et),n(re),n(xt),n(St),n(ue),n(Vt),n(Yt),n(Me),n(Ht),n(ge),n(Lt),n(Xt),n(zt),n(me),n(Rt),n(Ft),n(Je),n(Pt),n(Te),n(Ot),n(Dt),n(Ie),n(Kt),n(je),n(en),n(tn),n(nn),n(Ce),n(sn),n(ln),n(an),n(on),n($e),n(dn),n(Ae),n(cn),n(rn),n(pn),n(un),n(ke),n(hn),n(Mn),n(We),n(gn),n(fn),n(Ge),n(mn),n(yn),n(Qe),n(Jn),n(Ee),n(Tn),n(xe),n(wn),n(In),n(Ve),n(jn),n(Un),n(He),n(Cn),n(bn),n(Xe),n(_n),n($n),n(Re),n(An),n(vn),n(Pe),n(Zn),n(kn),n(De),n(qn),n(Wn),n(Bn),n(tt),n(Gn),n(nt),n(Nn),n(Qn),n(En),n(at)),n(i),f(U,e),f(C,e),f(N,e),f(E,e),f(V,e),f(b,e),f(H,e),f(X,e),f(z,e),f(F,e),f(_,e),f(P,e),f(D,e),f(ee,e),f(ne,e),f($,e),f(se,e),f(oe,e),f(ce,e),f(pe,e),f(he,e),f(A,e),f(fe,e),f(ye,e),f(we,e),f(v,e),f(Ue,e),f(be,e),f(Z,e),f(_e,e),f(ve,e),f(k,e),f(Ze,e),f(qe,e),f(Be,e),f(Ne,e),f(Se,e),f(Ye,e),f(Le,e),f(ze,e),f(Fe,e),f(Oe,e),f(Ke,e),f(et,e),f(st,e),f(lt,e)}}}const tl='{"title":"Run Inference on servers","local":"run-inference-on-servers","sections":[{"title":"Getting started","local":"getting-started","sections":[{"title":"Using a specific provider","local":"using-a-specific-provider","sections":[],"depth":3},{"title":"Using a specific model","local":"using-a-specific-model","sections":[],"depth":3},{"title":"Using Inference Endpoints","local":"using-inference-endpoints","sections":[],"depth":3},{"title":"Using local endpoints","local":"using-local-endpoints","sections":[],"depth":3},{"title":"Authentication","local":"authentication","sections":[],"depth":3}],"depth":2},{"title":"Supported providers and tasks","local":"supported-providers-and-tasks","sections":[],"depth":2},{"title":"OpenAI compatibility","local":"openai-compatibility","sections":[],"depth":2},{"title":"Function Calling","local":"function-calling","sections":[],"depth":2},{"title":"Structured Outputs & JSON Mode","local":"structured-outputs--json-mode","sections":[],"depth":2},{"title":"Async client","local":"async-client","sections":[],"depth":2},{"title":"MCP Client","local":"mcp-client","sections":[],"depth":2},{"title":"Advanced tips","local":"advanced-tips","sections":[{"title":"Billing","local":"billing","sections":[],"depth":3},{"title":"Timeout","local":"timeout","sections":[],"depth":3},{"title":"Binary inputs","local":"binary-inputs","sections":[],"depth":3}],"depth":2}],"depth":1}';function nl(w){return xs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dl extends Ss{constructor(i){super(),Vs(this,i,nl,el,Es,{})}}export{dl as component};
