import{s as mq,o as _q,n as U}from"../chunks/scheduler.6062bdaf.js";import{S as bq,i as yq,g as c,s,r as h,A as vq,h as l,f as p,c as r,j,u as f,x as d,k as M,y as n,a as $,v as m,d as _,t as b,w as y,m as xq,n as $q}from"../chunks/index.4bca734e.js";import{T as I}from"../chunks/Tip.b9ac1f03.js";import{D as q}from"../chunks/Docstring.887827b8.js";import{C as H}from"../chunks/CodeBlock.cbbddafc.js";import{E as C}from"../chunks/ExampleCodeBlock.433dd4d3.js";import{H as R,E as wq}from"../chunks/getInferenceSnippets.e6a3a5be.js";function kq(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGFkZF9jb2xsZWN0aW9uX2l0ZW0lMEFjb2xsZWN0aW9uJTIwJTNEJTIwYWRkX2NvbGxlY3Rpb25faXRlbSglMEElMjAlMjAlMjAlMjBjb2xsZWN0aW9uX3NsdWclM0QlMjJkYXZhbnN0cmllbiUyRmNsaW1hdGUtNjRmOTlkYzJhNTA2N2Y2YjY1NTMxYmFiJTIyJTJDJTBBJTIwJTIwJTIwJTIwaXRlbV9pZCUzRCUyMnBpZXJyZS1sb2ljJTJGY2xpbWF0ZS1uZXdzLWFydGljbGVzJTIyJTJDJTBBJTIwJTIwJTIwJTIwaXRlbV90eXBlJTNEJTIyZGF0YXNldCUyMiUwQSklMEFjb2xsZWN0aW9uLml0ZW1zJTVCLTElNUQuaXRlbV9pZCUwQSUwQWFkZF9jb2xsZWN0aW9uX2l0ZW0oJTBBJTIwJTIwJTIwJTIwY29sbGVjdGlvbl9zbHVnJTNEJTIyZGF2YW5zdHJpZW4lMkZjbGltYXRlLTY0Zjk5ZGMyYTUwNjdmNmI2NTUzMWJhYiUyMiUyQyUwQSUyMCUyMCUyMCUyMGl0ZW1faWQlM0QlMjJkYXRhc2V0cyUyRmNsaW1hdGVfZmV2ZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBpdGVtX3R5cGUlM0QlMjJkYXRhc2V0JTIyJTBBJTIwJTIwJTIwJTIwbm90ZSUzRCUyMlRoaXMlMjBkYXRhc2V0JTIwYWRvcHRzJTIwdGhlJTIwRkVWRVIlMjBtZXRob2RvbG9neSUyMHRoYXQlMjBjb25zaXN0cyUyMG9mJTIwMSUyQzUzNSUyMHJlYWwtd29ybGQlMjBjbGFpbXMlMjByZWdhcmRpbmclMjBjbGltYXRlLWNoYW5nZSUyMGNvbGxlY3RlZCUyMG9uJTIwdGhlJTIwaW50ZXJuZXQuJTIyJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> add_collection_item
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = add_collection_item(
<span class="hljs-meta">... </span>    collection_slug=<span class="hljs-string">&quot;davanstrien/climate-64f99dc2a5067f6b65531bab&quot;</span>,
<span class="hljs-meta">... </span>    item_id=<span class="hljs-string">&quot;pierre-loic/climate-news-articles&quot;</span>,
<span class="hljs-meta">... </span>    item_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.items[-<span class="hljs-number">1</span>].item_id
<span class="hljs-string">&quot;pierre-loic/climate-news-articles&quot;</span>
<span class="hljs-comment"># ^item got added to the collection on last position</span>

<span class="hljs-comment"># Add item with a note</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>add_collection_item(
<span class="hljs-meta">... </span>    collection_slug=<span class="hljs-string">&quot;davanstrien/climate-64f99dc2a5067f6b65531bab&quot;</span>,
<span class="hljs-meta">... </span>    item_id=<span class="hljs-string">&quot;datasets/climate_fever&quot;</span>,
<span class="hljs-meta">... </span>    item_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>    note=<span class="hljs-string">&quot;This dataset adopts the FEVER methodology that consists of 1,535 real-world claims regarding climate-change collected on the internet.&quot;</span>
<span class="hljs-meta">... </span>)
(...)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function Tq(T){let t,u="Check if the user has access to a repository:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGF1dGhfY2hlY2slMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViLnV0aWxzJTIwaW1wb3J0JTIwR2F0ZWRSZXBvRXJyb3IlMkMlMjBSZXBvc2l0b3J5Tm90Rm91bmRFcnJvciUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> auth_check
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub.utils <span class="hljs-keyword">import</span> GatedRepoError, RepositoryNotFoundError

<span class="hljs-keyword">try</span>:
    auth_check(<span class="hljs-string">&quot;user/my-cool-model&quot;</span>)
<span class="hljs-keyword">except</span> GatedRepoError:
    <span class="hljs-comment"># Handle gated repository error</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;You do not have permission to access this gated repository.&quot;</span>)
<span class="hljs-keyword">except</span> RepositoryNotFoundError:
    <span class="hljs-comment"># Handle repository not found error</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The repository was not found or you do not have access.&quot;</span>)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-12u7bhh"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function jq(T){let t,u="Examples:",i,a,g;return a=new H({props:{code:"bmV3X3RpdGxlJTIwJTNEJTIwJTIyTmV3JTIwdGl0bGUlMkMlMjBmaXhpbmclMjBhJTIwdHlwbyUyMiUwQUhmQXBpKCkucmVuYW1lX2Rpc2N1c3Npb24oJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMnVzZXJuYW1lJTJGcmVwb19uYW1lJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGlzY3Vzc2lvbl9udW0lM0QzNCUwQSUyMCUyMCUyMCUyMG5ld190aXRsZSUzRG5ld190aXRsZSUwQSklMEE=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>new_title = <span class="hljs-string">&quot;New title, fixing a typo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>HfApi().rename_discussion(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/repo_name&quot;</span>,
<span class="hljs-meta">... </span>    discussion_num=<span class="hljs-number">34</span>
<span class="hljs-meta">... </span>    new_title=new_title
<span class="hljs-meta">... </span>)
<span class="hljs-comment"># DiscussionStatusChange(id=&#x27;deadbeef0000000&#x27;, type=&#x27;status-change&#x27;, ...)</span>
`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-kvfsh7"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function Mq(T){let t,u="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){t=c("p"),t.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-182te9i"&&(t.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1oggadp"&&(a.innerHTML=g)},m(e,v){$(e,t,v),$(e,i,v),$(e,a,v)},p:U,d(e){e&&(p(t),p(i),p(a))}}}function qq(T){let t,u="Examples:",i,a,g;return a=new H({props:{code:"JTBBY29tbWVudCUyMCUzRCUyMCUyMiUyMiUyMiUwQUhlbGxvJTIwJTQwb3RoZXJ1c2VyISUwQSUyMyUyMFRoaXMlMjBpcyUyMGElMjB0aXRsZSUwQSoqVGhpcyUyMGlzJTIwYm9sZCoqJTJDJTIwKnRoaXMlMjBpcyUyMGl0YWxpYyolMjBhbmQlMjB+dGhpcyUyMGlzJTIwc3RyaWtldGhyb3VnaH4lMEFBbmQlMjAlNUJ0aGlzJTVEKGh0dHAlM0ElMkYlMkZ1cmwpJTIwaXMlMjBhJTIwbGluayUwQSUyMiUyMiUyMiUwQSUwQUhmQXBpKCkuY29tbWVudF9kaXNjdXNzaW9uKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJ1c2VybmFtZSUyRnJlcG9fbmFtZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGRpc2N1c3Npb25fbnVtJTNEMzQlMEElMjAlMjAlMjAlMjBjb21tZW50JTNEY29tbWVudCUwQSklMEE=",highlighted:`
<span class="hljs-meta">&gt;&gt;&gt; </span>comment = <span class="hljs-string">&quot;&quot;&quot;
<span class="hljs-meta">... </span>Hello @otheruser!
...
<span class="hljs-meta">... </span># This is a title
...
<span class="hljs-meta">... </span>**This is bold**, *this is italic* and ~this is strikethrough~
<span class="hljs-meta">... </span>And [this](http://url) is a link
<span class="hljs-meta">... </span>&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>HfApi().comment_discussion(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/repo_name&quot;</span>,
<span class="hljs-meta">... </span>    discussion_num=<span class="hljs-number">34</span>
<span class="hljs-meta">... </span>    comment=comment
<span class="hljs-meta">... </span>)
<span class="hljs-comment"># DiscussionComment(id=&#x27;deadbeef0000000&#x27;, type=&#x27;comment&#x27;, ...)</span>
`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-kvfsh7"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function Uq(T){let t,u="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){t=c("p"),t.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-182te9i"&&(t.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1oggadp"&&(a.innerHTML=g)},m(e,v){$(e,t,v),$(e,i,v),$(e,a,v)},p:U,d(e){e&&(p(t),p(i),p(a))}}}function Hq(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9jb2xsZWN0aW9uJTBBY29sbGVjdGlvbiUyMCUzRCUyMGNyZWF0ZV9jb2xsZWN0aW9uKCUwQSUyMCUyMCUyMCUyMHRpdGxlJTNEJTIySUNDViUyMDIwMjMlMjIlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMlBvcnRmb2xpbyUyMG9mJTIwbW9kZWxzJTJDJTIwcGFwZXJzJTIwYW5kJTIwZGVtb3MlMjBJJTIwcHJlc2VudGVkJTIwYXQlMjBJQ0NWJTIwMjAyMyUyMiUyQyUwQSklMEFjb2xsZWN0aW9uLnNsdWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_collection
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = create_collection(
<span class="hljs-meta">... </span>    title=<span class="hljs-string">&quot;ICCV 2023&quot;</span>,
<span class="hljs-meta">... </span>    description=<span class="hljs-string">&quot;Portfolio of models, papers and demos I presented at ICCV 2023&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.slug
<span class="hljs-string">&quot;username/iccv-2023-64f9a55bb3115b4f513ec026&quot;</span>`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function Cq(T){let t,u=`The input list of <code>CommitOperation</code> will be mutated during the commit process. Do not reuse the same objects
for multiple commits.`;return{c(){t=c("p"),t.innerHTML=u},l(i){t=l(i,"P",{"data-svelte-h":!0}),d(t)!=="svelte-1i3qk8u"&&(t.innerHTML=u)},m(i,a){$(i,t,a)},p:U,d(i){i&&p(t)}}}function Iq(T){let t,u=`<code>create_commit</code> assumes that the repo already exists on the Hub. If you get a
Client error 404, please make sure you are authenticated and that <code>repo_id</code> and
<code>repo_type</code> are set correctly. If repo does not exist, create it first using
<a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a>.`;return{c(){t=c("p"),t.innerHTML=u},l(i){t=l(i,"P",{"data-svelte-h":!0}),d(t)!=="svelte-f4qclq"&&(t.innerHTML=u)},m(i,a){$(i,t,a)},p:U,d(i){i&&p(t)}}}function Jq(T){let t,u="<code>create_commit</code> is limited to 25k LFS files and a 1GB payload for regular files.";return{c(){t=c("p"),t.innerHTML=u},l(i){t=l(i,"P",{"data-svelte-h":!0}),d(t)!=="svelte-yun5lq"&&(t.innerHTML=u)},m(i,a){$(i,t,a)},p:U,d(i){i&&p(t)}}}function Nq(T){let t,u="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){t=c("p"),t.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-182te9i"&&(t.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1oggadp"&&(a.innerHTML=g)},m(e,v){$(e,t,v),$(e,i,v),$(e,a,v)},p:U,d(e){e&&(p(t),p(i),p(a))}}}function Aq(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWVuZHBvaW50JTIwJTNEJTIwYXBpLmNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwJTIybXktZW5kcG9pbnQtbmFtZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9zaXRvcnklM0QlMjJncHQyJTIyJTJDJTBBJTIwJTIwJTIwJTIwZnJhbWV3b3JrJTNEJTIycHl0b3JjaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvciUzRCUyMmNwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMHZlbmRvciUzRCUyMmF3cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlZ2lvbiUzRCUyMnVzLWVhc3QtMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHR5cGUlM0QlMjJwcm90ZWN0ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV9zaXplJTNEJTIyeDIlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV90eXBlJTNEJTIyaW50ZWwtaWNsJTIyJTJDJTBBKSUwQWVuZHBvaW50JTBBJTBBZW5kcG9pbnQuY2xpZW50LnRleHRfZ2VuZXJhdGlvbiguLi4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = api.create_inference_endpoint(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;my-endpoint-name&quot;</span>,
<span class="hljs-meta">... </span>    repository=<span class="hljs-string">&quot;gpt2&quot;</span>,
<span class="hljs-meta">... </span>    framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
<span class="hljs-meta">... </span>    accelerator=<span class="hljs-string">&quot;cpu&quot;</span>,
<span class="hljs-meta">... </span>    vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>    region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    instance_size=<span class="hljs-string">&quot;x2&quot;</span>,
<span class="hljs-meta">... </span>    instance_type=<span class="hljs-string">&quot;intel-icl&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, status=<span class="hljs-string">&quot;pending&quot;</span>,...)

<span class="hljs-comment"># Run inference on the endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client.text_generation(...)
<span class="hljs-string">&quot;...&quot;</span>`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function Eq(T){let t,u;return t=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWVuZHBvaW50JTIwJTNEJTIwYXBpLmNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwJTIyYXdzLXplcGh5ci03Yi1iZXRhLTA0ODYlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvc2l0b3J5JTNEJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci03Yi1iZXRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwZnJhbWV3b3JrJTNEJTIycHl0b3JjaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvciUzRCUyMmdwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMHZlbmRvciUzRCUyMmF3cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlZ2lvbiUzRCUyMnVzLWVhc3QtMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHR5cGUlM0QlMjJwcm90ZWN0ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV9zaXplJTNEJTIyeDElMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV90eXBlJTNEJTIybnZpZGlhLWExMGclMjIlMkMlMEElMjAlMjAlMjAlMjBlbnYlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfQkFUQ0hfUFJFRklMTF9UT0tFTlMlMjIlM0ElMjAlMjIyMDQ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTUFYX0lOUFVUX0xFTkdUSCUyMiUzQSUyMCUyMjEwMjQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfVE9UQUxfVE9LRU5TJTIyJTNBJTIwJTIyMTUxMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1PREVMX0lEJTIyJTNBJTIwJTIyJTJGcmVwb3NpdG9yeSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMGN1c3RvbV9pbWFnZSUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhlYWx0aF9yb3V0ZSUyMiUzQSUyMCUyMiUyRmhlYWx0aCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVybCUyMiUzQSUyMCUyMmdoY3IuaW8lMkZodWdnaW5nZmFjZSUyRnRleHQtZ2VuZXJhdGlvbi1pbmZlcmVuY2UlM0ExLjEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMHNlY3JldHMlM0QlN0IlMjJNWV9TRUNSRVRfS0VZJTIyJTNBJTIwJTIyc2VjcmV0X3ZhbHVlJTIyJTdEJTJDJTBBJTIwJTIwJTIwdGFncyUzRCU1QiUyMmRldiUyMiUyQyUyMCUyMnRleHQtZ2VuZXJhdGlvbiUyMiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Start an Inference Endpoint running Zephyr-7b-beta on TGI</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = api.create_inference_endpoint(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;aws-zephyr-7b-beta-0486&quot;</span>,
<span class="hljs-meta">... </span>    repository=<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>,
<span class="hljs-meta">... </span>    framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
<span class="hljs-meta">... </span>    accelerator=<span class="hljs-string">&quot;gpu&quot;</span>,
<span class="hljs-meta">... </span>    vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>    region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    instance_size=<span class="hljs-string">&quot;x1&quot;</span>,
<span class="hljs-meta">... </span>    instance_type=<span class="hljs-string">&quot;nvidia-a10g&quot;</span>,
<span class="hljs-meta">... </span>    env={
<span class="hljs-meta">... </span>          <span class="hljs-string">&quot;MAX_BATCH_PREFILL_TOKENS&quot;</span>: <span class="hljs-string">&quot;2048&quot;</span>,
<span class="hljs-meta">... </span>          <span class="hljs-string">&quot;MAX_INPUT_LENGTH&quot;</span>: <span class="hljs-string">&quot;1024&quot;</span>,
<span class="hljs-meta">... </span>          <span class="hljs-string">&quot;MAX_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;1512&quot;</span>,
<span class="hljs-meta">... </span>          <span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;/repository&quot;</span>
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    custom_image={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;health_route&quot;</span>: <span class="hljs-string">&quot;/health&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;ghcr.io/huggingface/text-generation-inference:1.1.0&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>   secrets={<span class="hljs-string">&quot;MY_SECRET_KEY&quot;</span>: <span class="hljs-string">&quot;secret_value&quot;</span>},
<span class="hljs-meta">... </span>   tags=[<span class="hljs-string">&quot;dev&quot;</span>, <span class="hljs-string">&quot;text-generation&quot;</span>],
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){h(t.$$.fragment)},l(i){f(t.$$.fragment,i)},m(i,a){m(t,i,a),u=!0},p:U,i(i){u||(_(t.$$.fragment,i),u=!0)},o(i){b(t.$$.fragment,i),u=!1},d(i){y(t,i)}}}function Dq(T){let t,u;return t=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWVuZHBvaW50JTIwJTNEJTIwYXBpLmNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwJTIyZmluYmVydC1jbGFzc2lmaWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb3NpdG9yeSUzRCUyMlByb3N1c0FJJTJGZmluYmVydCUyMiUyQyUwQSUyMCUyMCUyMCUyMGZyYW1ld29yayUzRCUyMnB5dG9yY2glMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrJTNEJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMG1pbl9yZXBsaWNhJTNEMCUyQyUwQSUyMCUyMCUyMCUyMHNjYWxlX3RvX3plcm9fdGltZW91dCUzRDE1JTJDJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IlM0QlMjJjcHUlMjIlMkMlMEElMjAlMjAlMjAlMjB2ZW5kb3IlM0QlMjJhd3MlMjIlMkMlMEElMjAlMjAlMjAlMjByZWdpb24lM0QlMjJ1cy1lYXN0LTElMjIlMkMlMEElMjAlMjAlMjAlMjB0eXBlJTNEJTIycHJvdGVjdGVkJTIyJTJDJTBBJTIwJTIwJTIwJTIwaW5zdGFuY2Vfc2l6ZSUzRCUyMngyJTIyJTJDJTBBJTIwJTIwJTIwJTIwaW5zdGFuY2VfdHlwZSUzRCUyMmludGVsLWljbCUyMiUyQyUwQSklMEFlbmRwb2ludC53YWl0KHRpbWVvdXQlM0QzMDApJTBBZW5kcG9pbnQuY2xpZW50LnRleHRfZ2VuZXJhdGlvbiguLi4p",highlighted:`<span class="hljs-comment"># Start an Inference Endpoint running ProsusAI/finbert while scaling to zero in 15 minutes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = api.create_inference_endpoint(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;finbert-classifier&quot;</span>,
<span class="hljs-meta">... </span>    repository=<span class="hljs-string">&quot;ProsusAI/finbert&quot;</span>,
<span class="hljs-meta">... </span>    framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;text-classification&quot;</span>,
<span class="hljs-meta">... </span>    min_replica=<span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>    scale_to_zero_timeout=<span class="hljs-number">15</span>,
<span class="hljs-meta">... </span>    accelerator=<span class="hljs-string">&quot;cpu&quot;</span>,
<span class="hljs-meta">... </span>    vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>    region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    instance_size=<span class="hljs-string">&quot;x2&quot;</span>,
<span class="hljs-meta">... </span>    instance_type=<span class="hljs-string">&quot;intel-icl&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait(timeout=<span class="hljs-number">300</span>)
<span class="hljs-comment"># Run inference on the endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client.text_generation(...)
TextClassificationOutputElement(label=<span class="hljs-string">&#x27;positive&#x27;</span>, score=<span class="hljs-number">0.8983615040779114</span>)`,wrap:!1}}),{c(){h(t.$$.fragment)},l(i){f(t.$$.fragment,i)},m(i,a){m(t,i,a),u=!0},p:U,i(i){u||(_(t.$$.fragment,i),u=!0)},o(i){b(t.$$.fragment,i),u=!1},d(i){y(t,i)}}}function Rq(T){let t,u=`<code>create_inference_endpoint_from_catalog</code> is experimental. Its API is subject to change in the future. Please provide feedback
if you have any suggestions or requests.`;return{c(){t=c("p"),t.innerHTML=u},l(i){t=l(i,"P",{"data-svelte-h":!0}),d(t)!=="svelte-1bm6hf4"&&(t.innerHTML=u)},m(i,a){$(i,t,a)},p:U,d(i){i&&p(t)}}}function Gq(T){let t,u="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){t=c("p"),t.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-182te9i"&&(t.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1oggadp"&&(a.innerHTML=g)},m(e,v){$(e,t,v),$(e,i,v),$(e,a,v)},p:U,d(e){e&&(p(t),p(i),p(a))}}}function Zq(T){let t,u="Create your first scheduled Job:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9zY2hlZHVsZWRfam9iJTBBY3JlYXRlX3NjaGVkdWxlZF9qb2IoaW1hZ2UlM0QlMjJweXRob24lM0EzLjEyJTIyJTJDJTIwY29tbWFuZCUzRCU1QiUyMnB5dGhvbiUyMiUyQyUyMCUyMi1jJTIyJTIwJTJDJTIycHJpbnQoJ0hlbGxvJTIwZnJvbSUyMEhGJTIwY29tcHV0ZSEnKSUyMiU1RCUyQyUyMHNjaGVkdWxlJTNEJTIyJTQwaG91cmx5JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_scheduled_job
<span class="hljs-meta">&gt;&gt;&gt; </span>create_scheduled_job(image=<span class="hljs-string">&quot;python:3.12&quot;</span>, command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span> ,<span class="hljs-string">&quot;print(&#x27;Hello from HF compute!&#x27;)&quot;</span>], schedule=<span class="hljs-string">&quot;@hourly&quot;</span>)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-1n2fn9b"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function Fq(T){let t,u="Use a CRON schedule expression:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9zY2hlZHVsZWRfam9iJTBBY3JlYXRlX3NjaGVkdWxlZF9qb2IoaW1hZ2UlM0QlMjJweXRob24lM0EzLjEyJTIyJTJDJTIwY29tbWFuZCUzRCU1QiUyMnB5dGhvbiUyMiUyQyUyMCUyMi1jJTIyJTIwJTJDJTIycHJpbnQoJ3RoaXMlMjBydW5zJTIwZXZlcnklMjA1bWluJyklMjIlNUQlMkMlMjBzY2hlZHVsZSUzRCUyMiolMkY1JTIwKiUyMColMjAqJTIwKiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_scheduled_job
<span class="hljs-meta">&gt;&gt;&gt; </span>create_scheduled_job(image=<span class="hljs-string">&quot;python:3.12&quot;</span>, command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span> ,<span class="hljs-string">&quot;print(&#x27;this runs every 5min&#x27;)&quot;</span>], schedule=<span class="hljs-string">&quot;*/5 * * * *&quot;</span>)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-1ax4n75"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function Sq(T){let t,u="Create a scheduled GPU Job:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9zY2hlZHVsZWRfam9iJTBBaW1hZ2UlMjAlM0QlMjAlMjJweXRvcmNoJTJGcHl0b3JjaCUzQTIuNi4wLWN1ZGExMi40LWN1ZG5uOS1kZXZlbCUyMiUwQWNvbW1hbmQlMjAlM0QlMjAlNUIlMjJweXRob24lMjIlMkMlMjAlMjItYyUyMiUyQyUyMCUyMmltcG9ydCUyMHRvcmNoJTNCJTIwcHJpbnQoZiUyMlRoaXMlMjBjb2RlJTIwcmFuJTIwd2l0aCUyMHRoZSUyMGZvbGxvd2luZyUyMEdQVSUzQSUyMCU3QnRvcmNoLmN1ZGEuZ2V0X2RldmljZV9uYW1lKCklN0QlMjIpJTIyJTVEJTBBY3JlYXRlX3NjaGVkdWxlZF9qb2IoaW1hZ2UlMkMlMjBjb21tYW5kJTJDJTIwZmxhdm9yJTNEJTIyYTEwZy1zbWFsbCUyMiUyQyUyMHNjaGVkdWxlJTNEJTIyJTQwaG91cmx5JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_scheduled_job
<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-string">&quot;pytorch/pytorch:2.6.0-cuda12.4-cudnn9-devel&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>command = [<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;import torch; print(f&quot;</span>This code ran <span class="hljs-keyword">with</span> the following GPU: {torch.cuda.get_device_name()}<span class="hljs-string">&quot;)&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>create_scheduled_job(image, command, flavor=<span class="hljs-string">&quot;a10g-small&quot;</span>, schedule=<span class="hljs-string">&quot;@hourly&quot;</span>)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-l75qip"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function Lq(T){let t,u="Schedule a script from a URL:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9zY2hlZHVsZWRfdXZfam9iJTBBc2NyaXB0JTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGaHVnZ2luZ2ZhY2UlMkZ0cmwlMkZyZWZzJTJGaGVhZHMlMkZtYWluJTJGdHJsJTJGc2NyaXB0cyUyRnNmdC5weSUyMiUwQXNjcmlwdF9hcmdzJTIwJTNEJTIwJTVCJTIyLS1tb2RlbF9uYW1lX29yX3BhdGglMjIlMkMlMjAlMjJRd2VuJTJGUXdlbjItMC41QiUyMiUyQyUyMCUyMi0tZGF0YXNldF9uYW1lJTIyJTJDJTIwJTIydHJsLWxpYiUyRkNhcHliYXJhJTIyJTJDJTIwJTIyLS1wdXNoX3RvX2h1YiUyMiU1RCUwQWNyZWF0ZV9zY2hlZHVsZWRfdXZfam9iKHNjcmlwdCUyQyUyMHNjcmlwdF9hcmdzJTNEc2NyaXB0X2FyZ3MlMkMlMjBkZXBlbmRlbmNpZXMlM0QlNUIlMjJ0cmwlMjIlNUQlMkMlMjBmbGF2b3IlM0QlMjJhMTBnLXNtYWxsJTIyJTJDJTIwc2NoZWR1bGUlM0QlMjIlNDB3ZWVrbHklMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_scheduled_uv_job
<span class="hljs-meta">&gt;&gt;&gt; </span>script = <span class="hljs-string">&quot;https://raw.githubusercontent.com/huggingface/trl/refs/heads/main/trl/scripts/sft.py&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>script_args = [<span class="hljs-string">&quot;--model_name_or_path&quot;</span>, <span class="hljs-string">&quot;Qwen/Qwen2-0.5B&quot;</span>, <span class="hljs-string">&quot;--dataset_name&quot;</span>, <span class="hljs-string">&quot;trl-lib/Capybara&quot;</span>, <span class="hljs-string">&quot;--push_to_hub&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>create_scheduled_uv_job(script, script_args=script_args, dependencies=[<span class="hljs-string">&quot;trl&quot;</span>], flavor=<span class="hljs-string">&quot;a10g-small&quot;</span>, schedule=<span class="hljs-string">&quot;@weekly&quot;</span>)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-q3fkmx"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function Wq(T){let t,u="Schedule a local script:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9zY2hlZHVsZWRfdXZfam9iJTBBc2NyaXB0JTIwJTNEJTIwJTIybXlfc2Z0LnB5JTIyJTBBc2NyaXB0X2FyZ3MlMjAlM0QlMjAlNUIlMjItLW1vZGVsX25hbWVfb3JfcGF0aCUyMiUyQyUyMCUyMlF3ZW4lMkZRd2VuMi0wLjVCJTIyJTJDJTIwJTIyLS1kYXRhc2V0X25hbWUlMjIlMkMlMjAlMjJ0cmwtbGliJTJGQ2FweWJhcmElMjIlMkMlMjAlMjItLXB1c2hfdG9faHViJTIyJTVEJTBBY3JlYXRlX3NjaGVkdWxlZF91dl9qb2Ioc2NyaXB0JTJDJTIwc2NyaXB0X2FyZ3MlM0RzY3JpcHRfYXJncyUyQyUyMGRlcGVuZGVuY2llcyUzRCU1QiUyMnRybCUyMiU1RCUyQyUyMGZsYXZvciUzRCUyMmExMGctc21hbGwlMjIlMkMlMjBzY2hlZHVsZSUzRCUyMiU0MHdlZWtseSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_scheduled_uv_job
<span class="hljs-meta">&gt;&gt;&gt; </span>script = <span class="hljs-string">&quot;my_sft.py&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>script_args = [<span class="hljs-string">&quot;--model_name_or_path&quot;</span>, <span class="hljs-string">&quot;Qwen/Qwen2-0.5B&quot;</span>, <span class="hljs-string">&quot;--dataset_name&quot;</span>, <span class="hljs-string">&quot;trl-lib/Capybara&quot;</span>, <span class="hljs-string">&quot;--push_to_hub&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>create_scheduled_uv_job(script, script_args=script_args, dependencies=[<span class="hljs-string">&quot;trl&quot;</span>], flavor=<span class="hljs-string">&quot;a10g-small&quot;</span>, schedule=<span class="hljs-string">&quot;@weekly&quot;</span>)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-n7nqq"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function Vq(T){let t,u="Schedule a command:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9zY2hlZHVsZWRfdXZfam9iJTBBc2NyaXB0JTIwJTNEJTIwJTIybGlnaHRldmFsJTIyJTBBc2NyaXB0X2FyZ3MlM0QlMjAlNUIlMjJlbmRwb2ludCUyMiUyQyUyMCUyMmluZmVyZW5jZS1wcm92aWRlcnMlMjIlMkMlMjAlMjJtb2RlbF9uYW1lJTNEb3BlbmFpJTJGZ3B0LW9zcy0yMGIlMkNwcm92aWRlciUzRGF1dG8lMjIlMkMlMjAlMjJsaWdodGV2YWwlN0Nnc204ayU3QzAlN0MwJTIyJTVEJTBBY3JlYXRlX3NjaGVkdWxlZF91dl9qb2Ioc2NyaXB0JTJDJTIwc2NyaXB0X2FyZ3MlM0RzY3JpcHRfYXJncyUyQyUyMGRlcGVuZGVuY2llcyUzRCU1QiUyMmxpZ2h0ZXZhbCUyMiU1RCUyQyUyMGZsYXZvciUzRCUyMmExMGctc21hbGwlMjIlMkMlMjBzY2hlZHVsZSUzRCUyMiU0MHdlZWtseSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_scheduled_uv_job
<span class="hljs-meta">&gt;&gt;&gt; </span>script = <span class="hljs-string">&quot;lighteval&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>script_args= [<span class="hljs-string">&quot;endpoint&quot;</span>, <span class="hljs-string">&quot;inference-providers&quot;</span>, <span class="hljs-string">&quot;model_name=openai/gpt-oss-20b,provider=auto&quot;</span>, <span class="hljs-string">&quot;lighteval|gsm8k|0|0&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>create_scheduled_uv_job(script, script_args=script_args, dependencies=[<span class="hljs-string">&quot;lighteval&quot;</span>], flavor=<span class="hljs-string">&quot;a10g-small&quot;</span>, schedule=<span class="hljs-string">&quot;@weekly&quot;</span>)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-l2cd0v"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function Bq(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV93ZWJob29rJTBBcGF5bG9hZCUyMCUzRCUyMGNyZWF0ZV93ZWJob29rKCUwQSUyMCUyMCUyMCUyMHdhdGNoZWQlM0QlNUIlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMm5hbWUlMjIlM0ElMjAlMjJqdWxpZW4tYyUyMiU3RCUyQyUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJvcmclMjIlMkMlMjAlMjJuYW1lJTIyJTNBJTIwJTIySHVnZ2luZ0ZhY2VINCUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMHVybCUzRCUyMmh0dHBzJTNBJTJGJTJGd2ViaG9vay5zaXRlJTJGYTIxNzZlODItNTcyMC00M2VlLTllMDYtZjkxY2I0YzkxNTQ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwZG9tYWlucyUzRCU1QiUyMnJlcG8lMjIlMkMlMjAlMjJkaXNjdXNzaW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwc2VjcmV0JTNEJTIybXktc2VjcmV0JTIyJTJDJTBBKSUwQXByaW50KHBheWxvYWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_webhook
<span class="hljs-meta">&gt;&gt;&gt; </span>payload = create_webhook(
<span class="hljs-meta">... </span>    watched=[{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;julien-c&quot;</span>}, {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;org&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;HuggingFaceH4&quot;</span>}],
<span class="hljs-meta">... </span>    url=<span class="hljs-string">&quot;https://webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
<span class="hljs-meta">... </span>    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
<span class="hljs-meta">... </span>    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(payload)
WebhookInfo(
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
    url=<span class="hljs-string">&quot;https://webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
    watched=[WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;user&quot;</span>, name=<span class="hljs-string">&quot;julien-c&quot;</span>), WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;org&quot;</span>, name=<span class="hljs-string">&quot;HuggingFaceH4&quot;</span>)],
    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
    disabled=<span class="hljs-literal">False</span>,
)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function Pq(T){let t,u="Raises the following errors:",i,a,g=`<li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError">RevisionNotFoundError</a>
If the revision to download from cannot be found.</li>`;return{c(){t=c("p"),t.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-182te9i"&&(t.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-117o2wk"&&(a.innerHTML=g)},m(e,v){$(e,t,v),$(e,i,v),$(e,a,v)},p:U,d(e){e&&(p(t),p(i),p(a))}}}function Yq(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGRlbGV0ZV9jb2xsZWN0aW9uJTBBY29sbGVjdGlvbiUyMCUzRCUyMGRlbGV0ZV9jb2xsZWN0aW9uKCUyMnVzZXJuYW1lJTJGdXNlbGVzcy1jb2xsZWN0aW9uLTY0ZjlhNTViYjMxMTViNGY1MTNlYzAyNiUyMiUyQyUyMG1pc3Npbmdfb2slM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> delete_collection
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = delete_collection(<span class="hljs-string">&quot;username/useless-collection-64f9a55bb3115b4f513ec026&quot;</span>, missing_ok=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function Xq(T){let t,u="This is a non-revertible action. A deleted collection cannot be restored.";return{c(){t=c("p"),t.textContent=u},l(i){t=l(i,"P",{"data-svelte-h":!0}),d(t)!=="svelte-1k7dttx"&&(t.textContent=u)},m(i,a){$(i,t,a)},p:U,d(i){i&&p(t)}}}function Qq(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9jb2xsZWN0aW9uJTJDJTIwZGVsZXRlX2NvbGxlY3Rpb25faXRlbSUwQSUwQWNvbGxlY3Rpb24lMjAlM0QlMjBnZXRfY29sbGVjdGlvbiglMjJUaGVCbG9rZSUyRnJlY2VudC1tb2RlbHMtNjRmOWE1NWJiMzExNWI0ZjUxM2VjMDI2JTIyKSUwQSUwQWRlbGV0ZV9jb2xsZWN0aW9uX2l0ZW0oJTBBJTIwJTIwJTIwJTIwY29sbGVjdGlvbl9zbHVnJTNEJTIyVGhlQmxva2UlMkZyZWNlbnQtbW9kZWxzLTY0ZjlhNTViYjMxMTViNGY1MTNlYzAyNiUyMiUyQyUwQSUyMCUyMCUyMCUyMGl0ZW1fb2JqZWN0X2lkJTNEY29sbGVjdGlvbi5pdGVtcyU1Qi0xJTVELml0ZW1fb2JqZWN0X2lkJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_collection, delete_collection_item

<span class="hljs-comment"># Get collection first</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = get_collection(<span class="hljs-string">&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</span>)

<span class="hljs-comment"># Delete item based on its ID</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>delete_collection_item(
<span class="hljs-meta">... </span>    collection_slug=<span class="hljs-string">&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</span>,
<span class="hljs-meta">... </span>    item_object_id=collection.items[-<span class="hljs-number">1</span>].item_object_id,
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function zq(T){let t,u="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError">RevisionNotFoundError</a>
If the revision to download from cannot be found.</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.EntryNotFoundError">EntryNotFoundError</a>
If the file to download cannot be found.</li>`;return{c(){t=c("p"),t.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-182te9i"&&(t.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1hfnpzg"&&(a.innerHTML=g)},m(e,v){$(e,t,v),$(e,i,v),$(e,a,v)},p:U,d(e){e&&(p(t),p(i),p(a))}}}function Oq(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGRlbGV0ZV93ZWJob29rJTBBZGVsZXRlX3dlYmhvb2soJTIyNjU0YmJiYzE2ZjJlYzE0ZDc3ZjEwOWNjJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> delete_webhook
<span class="hljs-meta">&gt;&gt;&gt; </span>delete_webhook(<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function Kq(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGRpc2FibGVfd2ViaG9vayUwQWRpc2FibGVkX3dlYmhvb2slMjAlM0QlMjBkaXNhYmxlX3dlYmhvb2soJTIyNjU0YmJiYzE2ZjJlYzE0ZDc3ZjEwOWNjJTIyKSUwQWRpc2FibGVkX3dlYmhvb2s=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> disable_webhook
<span class="hljs-meta">&gt;&gt;&gt; </span>disabled_webhook = disable_webhook(<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>disabled_webhook
WebhookInfo(
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
    url=<span class="hljs-string">&quot;https://webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
    watched=[WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;user&quot;</span>, name=<span class="hljs-string">&quot;julien-c&quot;</span>), WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;org&quot;</span>, name=<span class="hljs-string">&quot;HuggingFaceH4&quot;</span>)],
    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
    disabled=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function eU(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGR1cGxpY2F0ZV9zcGFjZSUwQSUwQWR1cGxpY2F0ZV9zcGFjZSglMjJtdWx0aW1vZGFsYXJ0JTJGZHJlYW1ib290aC10cmFpbmluZyUyMiklMEElMEFkdXBsaWNhdGVfc3BhY2UoJTIybXVsdGltb2RhbGFydCUyRmRyZWFtYm9vdGgtdHJhaW5pbmclMjIlMkMlMjB0b19pZCUzRCUyMm15LWRyZWFtYm9vdGglMjIlMkMlMjBwcml2YXRlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> duplicate_space

<span class="hljs-comment"># Duplicate a Space to your account</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>duplicate_space(<span class="hljs-string">&quot;multimodalart/dreambooth-training&quot;</span>)
RepoUrl(<span class="hljs-string">&#x27;https://huggingface.co/spaces/nateraw/dreambooth-training&#x27;</span>,...)

<span class="hljs-comment"># Can set custom destination id and visibility flag.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>duplicate_space(<span class="hljs-string">&quot;multimodalart/dreambooth-training&quot;</span>, to_id=<span class="hljs-string">&quot;my-dreambooth&quot;</span>, private=<span class="hljs-literal">True</span>)
RepoUrl(<span class="hljs-string">&#x27;https://huggingface.co/spaces/nateraw/my-dreambooth&#x27;</span>,...)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function tU(T){let t,u="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){t=c("p"),t.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-182te9i"&&(t.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1oggadp"&&(a.innerHTML=g)},m(e,v){$(e,t,v),$(e,i,v),$(e,a,v)},p:U,d(e){e&&(p(t),p(i),p(a))}}}function nU(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGVuYWJsZV93ZWJob29rJTBBZW5hYmxlZF93ZWJob29rJTIwJTNEJTIwZW5hYmxlX3dlYmhvb2soJTIyNjU0YmJiYzE2ZjJlYzE0ZDc3ZjEwOWNjJTIyKSUwQWVuYWJsZWRfd2ViaG9vaw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> enable_webhook
<span class="hljs-meta">&gt;&gt;&gt; </span>enabled_webhook = enable_webhook(<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>enabled_webhook
WebhookInfo(
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
    url=<span class="hljs-string">&quot;https://webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
    watched=[WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;user&quot;</span>, name=<span class="hljs-string">&quot;julien-c&quot;</span>), WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;org&quot;</span>, name=<span class="hljs-string">&quot;HuggingFaceH4&quot;</span>)],
    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
    disabled=<span class="hljs-literal">False</span>,
)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function oU(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGZldGNoX2pvYl9sb2dzJTJDJTIwcnVuX2pvYiUwQWpvYiUyMCUzRCUyMHJ1bl9qb2IoaW1hZ2UlM0QlMjJweXRob24lM0EzLjEyJTIyJTJDJTIwY29tbWFuZCUzRCU1QiUyMnB5dGhvbiUyMiUyQyUyMCUyMi1jJTIyJTIwJTJDJTIycHJpbnQoJ0hlbGxvJTIwZnJvbSUyMEhGJTIwY29tcHV0ZSEnKSUyMiU1RCklMEFmb3IlMjBsb2clMjBpbiUyMGZldGNoX2pvYl9sb2dzKGpvYi5pZCklM0ElMEElMjAlMjAlMjAlMjBwcmludChsb2cp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> fetch_job_logs, run_job
<span class="hljs-meta">&gt;&gt;&gt; </span>job = run_job(image=<span class="hljs-string">&quot;python:3.12&quot;</span>, command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span> ,<span class="hljs-string">&quot;print(&#x27;Hello from HF compute!&#x27;)&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> fetch_job_logs(job.<span class="hljs-built_in">id</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(log)
Hello <span class="hljs-keyword">from</span> HF compute!`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function aU(T){let t,u="Examples:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGZpbGVfZXhpc3RzJTBBZmlsZV9leGlzdHMoJTIyYmlnY29kZSUyRnN0YXJjb2RlciUyMiUyQyUyMCUyMmNvbmZpZy5qc29uJTIyKSUwQWZpbGVfZXhpc3RzKCUyMmJpZ2NvZGUlMkZzdGFyY29kZXIlMjIlMkMlMjAlMjJub3QtYS1maWxlJTIyKSUwQWZpbGVfZXhpc3RzKCUyMmJpZ2NvZGUlMkZub3QtYS1yZXBvJTIyJTJDJTIwJTIyY29uZmlnLmpzb24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> file_exists
<span class="hljs-meta">&gt;&gt;&gt; </span>file_exists(<span class="hljs-string">&quot;bigcode/starcoder&quot;</span>, <span class="hljs-string">&quot;config.json&quot;</span>)
<span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>file_exists(<span class="hljs-string">&quot;bigcode/starcoder&quot;</span>, <span class="hljs-string">&quot;not-a-file&quot;</span>)
<span class="hljs-literal">False</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>file_exists(<span class="hljs-string">&quot;bigcode/not-a-repo&quot;</span>, <span class="hljs-string">&quot;config.json&quot;</span>)
<span class="hljs-literal">False</span>`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-kvfsh7"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function sU(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9jb2xsZWN0aW9uJTBBY29sbGVjdGlvbiUyMCUzRCUyMGdldF9jb2xsZWN0aW9uKCUyMlRoZUJsb2tlJTJGcmVjZW50LW1vZGVscy02NGY5YTU1YmIzMTE1YjRmNTEzZWMwMjYlMjIpJTBBY29sbGVjdGlvbi50aXRsZSUwQWxlbihjb2xsZWN0aW9uLml0ZW1zKSUwQWNvbGxlY3Rpb24uaXRlbXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_collection
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = get_collection(<span class="hljs-string">&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.title
<span class="hljs-string">&#x27;Recent models&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(collection.items)
<span class="hljs-number">37</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.items[<span class="hljs-number">0</span>]
CollectionItem(
    item_object_id=<span class="hljs-string">&#x27;651446103cd773a050bf64c2&#x27;</span>,
    item_id=<span class="hljs-string">&#x27;TheBloke/U-Amethyst-20B-AWQ&#x27;</span>,
    item_type=<span class="hljs-string">&#x27;model&#x27;</span>,
    position=<span class="hljs-number">88</span>,
    note=<span class="hljs-literal">None</span>
)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function rU(T){let t,u="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){t=c("p"),t.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-182te9i"&&(t.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1oggadp"&&(a.innerHTML=g)},m(e,v){$(e,t,v),$(e,i,v),$(e,a,v)},p:U,d(e){e&&(p(t),p(i),p(a))}}}function iU(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWVuZHBvaW50JTIwJTNEJTIwYXBpLmdldF9pbmZlcmVuY2VfZW5kcG9pbnQoJTIybXktdGV4dC10by1pbWFnZSUyMiklMEFlbmRwb2ludCUwQSUwQWVuZHBvaW50LnN0YXR1cyUwQWVuZHBvaW50LnVybCUwQSUwQWVuZHBvaW50LmNsaWVudC50ZXh0X3RvX2ltYWdlKC4uLik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = api.get_inference_endpoint(<span class="hljs-string">&quot;my-text-to-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-text-to-image&#x27;</span>, ...)

<span class="hljs-comment"># Get status</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.status
<span class="hljs-string">&#x27;running&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.url
<span class="hljs-string">&#x27;https://my-text-to-image.region.vendor.endpoints.huggingface.cloud&#x27;</span>

<span class="hljs-comment"># Run inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client.text_to_image(...)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function cU(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9wYXRoc19pbmZvJTBBcGF0aHNfaW5mbyUyMCUzRCUyMGdldF9wYXRoc19pbmZvKCUyMmFsbGVuYWklMkZjNCUyMiUyQyUyMCU1QiUyMlJFQURNRS5tZCUyMiUyQyUyMCUyMmVuJTIyJTVEJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiklMEFwYXRoc19pbmZv",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_paths_info
<span class="hljs-meta">&gt;&gt;&gt; </span>paths_info = get_paths_info(<span class="hljs-string">&quot;allenai/c4&quot;</span>, [<span class="hljs-string">&quot;README.md&quot;</span>, <span class="hljs-string">&quot;en&quot;</span>], repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>paths_info
[
    RepoFile(path=<span class="hljs-string">&#x27;README.md&#x27;</span>, size=<span class="hljs-number">2379</span>, blob_id=<span class="hljs-string">&#x27;f84cb4c97182890fc1dbdeaf1a6a468fd27b4fff&#x27;</span>, lfs=<span class="hljs-literal">None</span>, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>),
    RepoFolder(path=<span class="hljs-string">&#x27;en&#x27;</span>, tree_id=<span class="hljs-string">&#x27;dc943c4c40f53d02b31ced1defa7e5f438d5862e&#x27;</span>, last_commit=<span class="hljs-literal">None</span>)
]`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function lU(T){let t,u="Collecting all discussions of a repo in a list:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9yZXBvX2Rpc2N1c3Npb25zJTBBZGlzY3Vzc2lvbnNfbGlzdCUyMCUzRCUyMGxpc3QoZ2V0X3JlcG9fZGlzY3Vzc2lvbnMocmVwb19pZCUzRCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_repo_discussions
<span class="hljs-meta">&gt;&gt;&gt; </span>discussions_list = <span class="hljs-built_in">list</span>(get_repo_discussions(repo_id=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>))`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-1p6axsk"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function pU(T){let t,u="Iterating over discussions of a repo:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9yZXBvX2Rpc2N1c3Npb25zJTBBZm9yJTIwZGlzY3Vzc2lvbiUyMGluJTIwZ2V0X3JlcG9fZGlzY3Vzc2lvbnMocmVwb19pZCUzRCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGRpc2N1c3Npb24ubnVtJTJDJTIwZGlzY3Vzc2lvbi50aXRsZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_repo_discussions
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> discussion <span class="hljs-keyword">in</span> get_repo_discussions(repo_id=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(discussion.num, discussion.title)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-121l6g4"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function dU(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"bWV0YWRhdGElMjAlM0QlMjBnZXRfc2FmZXRlbnNvcnNfbWV0YWRhdGEoJTIyYmlnc2NpZW5jZSUyRmJsb29tei01NjBtJTIyKSUwQW1ldGFkYXRhJTBBbWV0YWRhdGEuZmlsZXNfbWV0YWRhdGElNUIlMjJtb2RlbC5zYWZldGVuc29ycyUyMiU1RC5tZXRhZGF0YSUwQSUwQW1ldGFkYXRhJTIwJTNEJTIwZ2V0X3NhZmV0ZW5zb3JzX21ldGFkYXRhKCUyMmJpZ3NjaWVuY2UlMkZibG9vbSUyMiklMEFtZXRhZGF0YSUwQWxlbihtZXRhZGF0YS5maWxlc19tZXRhZGF0YSklMEElMEFnZXRfc2FmZXRlbnNvcnNfbWV0YWRhdGEoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIp",highlighted:`<span class="hljs-comment"># Parse repo with single weights file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata = get_safetensors_metadata(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata
SafetensorsRepoMetadata(
    metadata=<span class="hljs-literal">None</span>,
    sharded=<span class="hljs-literal">False</span>,
    weight_map={<span class="hljs-string">&#x27;h.0.input_layernorm.bias&#x27;</span>: <span class="hljs-string">&#x27;model.safetensors&#x27;</span>, ...},
    files_metadata={<span class="hljs-string">&#x27;model.safetensors&#x27;</span>: SafetensorsFileMetadata(...)}
)
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata.files_metadata[<span class="hljs-string">&quot;model.safetensors&quot;</span>].metadata
{<span class="hljs-string">&#x27;format&#x27;</span>: <span class="hljs-string">&#x27;pt&#x27;</span>}

<span class="hljs-comment"># Parse repo with sharded model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata = get_safetensors_metadata(<span class="hljs-string">&quot;bigscience/bloom&quot;</span>)
Parse safetensors files: <span class="hljs-number">100</span>%|██████████████████████████████████████████| <span class="hljs-number">72</span>/<span class="hljs-number">72</span> [<span class="hljs-number">00</span>:<span class="hljs-number">12</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>,  <span class="hljs-number">5.78</span>it/s]
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata
SafetensorsRepoMetadata(metadata={<span class="hljs-string">&#x27;total_size&#x27;</span>: <span class="hljs-number">352494542848</span>}, sharded=<span class="hljs-literal">True</span>, weight_map={...}, files_metadata={...})
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(metadata.files_metadata)
<span class="hljs-number">72</span>  <span class="hljs-comment"># All safetensors files have been fetched</span>

<span class="hljs-comment"># Parse repo with sharded model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>get_safetensors_metadata(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
NotASafetensorsRepoError: <span class="hljs-string">&#x27;runwayml/stable-diffusion-v1-5&#x27;</span> <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> a safetensors repo. Couldn<span class="hljs-string">&#x27;t find &#x27;</span>model.safetensors.index.json<span class="hljs-string">&#x27; or &#x27;</span>model.safetensors<span class="hljs-string">&#x27; files.</span>`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function gU(T){let t,u=`This method is deprecated and will be removed in version 1.0. Permissions are more complex than when
<code>get_token_permission</code> was first introduced. OAuth and fine-grain tokens allows for more detailed permissions.
If you need to know the permissions associated with a token, please use <code>whoami</code> and check the <code>&#39;auth&#39;</code> key.`;return{c(){t=c("p"),t.innerHTML=u},l(i){t=l(i,"P",{"data-svelte-h":!0}),d(t)!=="svelte-1uyfywd"&&(t.innerHTML=u)},m(i,a){$(i,t,a)},p:U,d(i){i&&p(t)}}}function uU(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF93ZWJob29rJTBBd2ViaG9vayUyMCUzRCUyMGdldF93ZWJob29rKCUyMjY1NGJiYmMxNmYyZWMxNGQ3N2YxMDljYyUyMiklMEFwcmludCh3ZWJob29rKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_webhook
<span class="hljs-meta">&gt;&gt;&gt; </span>webhook = get_webhook(<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(webhook)
WebhookInfo(
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
    watched=[WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;user&quot;</span>, name=<span class="hljs-string">&quot;julien-c&quot;</span>), WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;org&quot;</span>, name=<span class="hljs-string">&quot;HuggingFaceH4&quot;</span>)],
    url=<span class="hljs-string">&quot;https://webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
    disabled=<span class="hljs-literal">False</span>,
)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function hU(T){let t,u;return t=new H({props:{code:"JTVCJTIwJTIwOTYlNUQlMjAlMjAuJTBBJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwJTVCJTIwMTYwJTVEJTIwJTIwbW9kZWxzLS1qdWxpZW4tYy0tRXNwZXJCRVJUby1zbWFsbCUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMCU1QiUyMDE2MCU1RCUyMCUyMGJsb2JzJTBBJTIwJTIwJTIwJTIwJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwJTVCMzIxTSU1RCUyMCUyMDQwMzQ1MGUyMzRkNjU5NDNhN2RjZjdlMDVhNzcxY2UzYzkyZmFhODRkZDA3ZGI0YWMyMGY1OTIwMzdhMWU0YmQlMEElMjAlMjAlMjAlMjAlRTIlOTQlODIlMjAlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjAlNUIlMjAzOTglNUQlMjAlMjA3Y2IxOGRjOWJhZmJmY2Y3NDYyOWE0Yjc2MGFmMWIxNjA5NTdhODNlJTBBJTIwJTIwJTIwJTIwJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwJTVCMS40SyU1RCUyMCUyMGQ3ZWRmNmJkMmE2ODFmYjAxNzVmNzczNTI5OTgzMWVlMWIyMmI4MTIlMEElMjAlMjAlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjAlNUIlMjAlMjA5NiU1RCUyMCUyMHJlZnMlMEElMjAlMjAlMjAlMjAlRTIlOTQlODIlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjAlNUIlMjAlMjA0MCU1RCUyMCUyMG1haW4lMEElMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjAlNUIlMjAxMjglNUQlMjAlMjBzbmFwc2hvdHMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjAlNUIlMjAxMjglNUQlMjAlMjAyNDM5ZjYwZWYzM2EwZDQ2ZDg1ZGE1MDAxZDUyYWVkYTViMDBjZTlmJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwJTVCJTIwJTIwNTIlNUQlMjAlMjBSRUFETUUubWQlMjAtJTNFJTIwLi4lMkYuLiUyRmJsb2JzJTJGZDdlZGY2YmQyYTY4MWZiMDE3NWY3NzM1Mjk5ODMxZWUxYjIyYjgxMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCVFMiU5NCU4MiUyMCUyMCUyMCVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMCU1QiUyMCUyMDc2JTVEJTIwJTIwcHl0b3JjaF9tb2RlbC5iaW4lMjAtJTNFJTIwLi4lMkYuLiUyRmJsb2JzJTJGNDAzNDUwZTIzNGQ2NTk0M2E3ZGNmN2UwNWE3NzFjZTNjOTJmYWE4NGRkMDdkYjRhYzIwZjU5MjAzN2ExZTRiZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMCU1QiUyMDEyOCU1RCUyMCUyMGJiYzc3YzgxMzJhZjFjYzVjZjY3OGRhM2YxZGRmMmRlNDM2MDZkNDglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjAlNUIlMjAlMjA1MiU1RCUyMCUyMFJFQURNRS5tZCUyMC0lM0UlMjAuLiUyRi4uJTJGYmxvYnMlMkY3Y2IxOGRjOWJhZmJmY2Y3NDYyOWE0Yjc2MGFmMWIxNjA5NTdhODNlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwJTVCJTIwJTIwNzYlNUQlMjAlMjBweXRvcmNoX21vZGVsLmJpbiUyMC0lM0UlMjAuLiUyRi4uJTJGYmxvYnMlMkY0MDM0NTBlMjM0ZDY1OTQzYTdkY2Y3ZTA1YTc3MWNlM2M5MmZhYTg0ZGQwN2RiNGFjMjBmNTkyMDM3YTFlNGJk",highlighted:`<span class="hljs-selector-attr">[  96]</span>  .
└── <span class="hljs-selector-attr">[ 160]</span>  models<span class="hljs-attr">--julien-c--EsperBERTo-small</span>
    ├── <span class="hljs-selector-attr">[ 160]</span>  blobs
    │   ├── <span class="hljs-selector-attr">[321M]</span>  <span class="hljs-number">403450</span>e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd
    │   ├── <span class="hljs-selector-attr">[ 398]</span>  <span class="hljs-number">7</span>cb18dc9bafbfcf74629a4b760af1b160957a83e
    │   └── <span class="hljs-selector-attr">[1.4K]</span>  d7edf6bd2a681fb0175f7735299831ee1b22b812
    ├── <span class="hljs-selector-attr">[  96]</span>  refs
    │   └── <span class="hljs-selector-attr">[  40]</span>  <span class="hljs-selector-tag">main</span>
    └── <span class="hljs-selector-attr">[ 128]</span>  snapshots
        ├── <span class="hljs-selector-attr">[ 128]</span>  <span class="hljs-number">2439</span>f60ef33a0d46d85da5001d52aeda5b00ce9f
        │   ├── <span class="hljs-selector-attr">[  52]</span>  README<span class="hljs-selector-class">.md</span> -&gt; ../../blobs/d7edf6bd2a681fb0175f7735299831ee1b22b812
        │   └── <span class="hljs-selector-attr">[  76]</span>  pytorch_model<span class="hljs-selector-class">.bin</span> -&gt; ../../blobs/<span class="hljs-number">403450</span>e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd
        └── <span class="hljs-selector-attr">[ 128]</span>  bbc77c8132af1cc5cf678da3f1ddf2de43606d48
            ├── <span class="hljs-selector-attr">[  52]</span>  README<span class="hljs-selector-class">.md</span> -&gt; ../../blobs/<span class="hljs-number">7</span>cb18dc9bafbfcf74629a4b760af1b160957a83e
            └── <span class="hljs-selector-attr">[  76]</span>  pytorch_model<span class="hljs-selector-class">.bin</span> -&gt; ../../blobs/<span class="hljs-number">403450</span>e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd`,wrap:!1}}),{c(){h(t.$$.fragment)},l(i){f(t.$$.fragment,i)},m(i,a){m(t,i,a),u=!0},p:U,i(i){u||(_(t.$$.fragment,i),u=!0)},o(i){b(t.$$.fragment,i),u=!1},d(i){y(t,i)}}}function fU(T){let t;return{c(){t=xq("Hidden comments' content cannot be retrieved anymore. Hiding a comment is irreversible.")},l(u){t=$q(u,"Hidden comments' content cannot be retrieved anymore. Hiding a comment is irreversible.")},m(u,i){$(u,t,i)},d(u){u&&p(t)}}}function mU(T){let t,u="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){t=c("p"),t.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-182te9i"&&(t.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1oggadp"&&(a.innerHTML=g)},m(e,v){$(e,t,v),$(e,i,v),$(e,a,v)},p:U,d(e){e&&(p(t),p(i),p(a))}}}function _U(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGluc3BlY3Rfam9iJTJDJTIwcnVuX2pvYiUwQWpvYiUyMCUzRCUyMHJ1bl9qb2IoaW1hZ2UlM0QlMjJweXRob24lM0EzLjEyJTIyJTJDJTIwY29tbWFuZCUzRCU1QiUyMnB5dGhvbiUyMiUyQyUyMCUyMi1jJTIyJTIwJTJDJTIycHJpbnQoJ0hlbGxvJTIwZnJvbSUyMEhGJTIwY29tcHV0ZSEnKSUyMiU1RCklMEFpbnNwZWN0X2pvYihqb2IuaWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> inspect_job, run_job
<span class="hljs-meta">&gt;&gt;&gt; </span>job = run_job(image=<span class="hljs-string">&quot;python:3.12&quot;</span>, command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span> ,<span class="hljs-string">&quot;print(&#x27;Hello from HF compute!&#x27;)&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>inspect_job(job.<span class="hljs-built_in">id</span>)
JobInfo(
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&#x27;68780d00bbe36d38803f645f&#x27;</span>,
    created_at=datetime.datetime(<span class="hljs-number">2025</span>, <span class="hljs-number">7</span>, <span class="hljs-number">16</span>, <span class="hljs-number">20</span>, <span class="hljs-number">35</span>, <span class="hljs-number">12</span>, <span class="hljs-number">808000</span>, tzinfo=datetime.timezone.utc),
    docker_image=<span class="hljs-string">&#x27;python:3.12&#x27;</span>,
    space_id=<span class="hljs-literal">None</span>,
    command=[<span class="hljs-string">&#x27;python&#x27;</span>, <span class="hljs-string">&#x27;-c&#x27;</span>, <span class="hljs-string">&quot;print(&#x27;Hello from HF compute!&#x27;)&quot;</span>],
    arguments=[],
    environment={},
    secrets={},
    flavor=<span class="hljs-string">&#x27;cpu-basic&#x27;</span>,
    status=JobStatus(stage=<span class="hljs-string">&#x27;RUNNING&#x27;</span>, message=<span class="hljs-literal">None</span>)
)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function bU(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGluc3BlY3Rfam9iJTJDJTIwY3JlYXRlX3NjaGVkdWxlZF9qb2IlMEFzY2hlZHVsZWRfam9iJTIwJTNEJTIwY3JlYXRlX3NjaGVkdWxlZF9qb2IoaW1hZ2UlM0QlMjJweXRob24lM0EzLjEyJTIyJTJDJTIwY29tbWFuZCUzRCU1QiUyMnB5dGhvbiUyMiUyQyUyMCUyMi1jJTIyJTIwJTJDJTIycHJpbnQoJ0hlbGxvJTIwZnJvbSUyMEhGJTIwY29tcHV0ZSEnKSUyMiU1RCUyQyUyMHNjaGVkdWxlJTNEJTIyJTQwaG91cmx5JTIyKSUwQWluc3BlY3Rfc2NoZWR1bGVkX2pvYihzY2hlZHVsZWRfam9iLmlkKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> inspect_job, create_scheduled_job
<span class="hljs-meta">&gt;&gt;&gt; </span>scheduled_job = create_scheduled_job(image=<span class="hljs-string">&quot;python:3.12&quot;</span>, command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span> ,<span class="hljs-string">&quot;print(&#x27;Hello from HF compute!&#x27;)&quot;</span>], schedule=<span class="hljs-string">&quot;@hourly&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inspect_scheduled_job(scheduled_job.<span class="hljs-built_in">id</span>)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function yU(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfYWNjZXB0ZWRfYWNjZXNzX3JlcXVlc3RzJTBBJTBBcmVxdWVzdHMlMjAlM0QlMjBsaXN0X2FjY2VwdGVkX2FjY2Vzc19yZXF1ZXN0cyglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03YiUyMiklMEFsZW4ocmVxdWVzdHMpJTBBcmVxdWVzdHMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_accepted_access_requests

<span class="hljs-meta">&gt;&gt;&gt; </span>requests = list_accepted_access_requests(<span class="hljs-string">&quot;meta-llama/Llama-2-7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(requests)
<span class="hljs-number">411</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>requests[<span class="hljs-number">0</span>]
[
    AccessRequest(
        username=<span class="hljs-string">&#x27;clem&#x27;</span>,
        fullname=<span class="hljs-string">&#x27;Clem 🤗&#x27;</span>,
        email=<span class="hljs-string">&#x27;***&#x27;</span>,
        timestamp=datetime.datetime(<span class="hljs-number">2023</span>, <span class="hljs-number">11</span>, <span class="hljs-number">23</span>, <span class="hljs-number">18</span>, <span class="hljs-number">4</span>, <span class="hljs-number">53</span>, <span class="hljs-number">828000</span>, tzinfo=datetime.timezone.utc),
        status=<span class="hljs-string">&#x27;accepted&#x27;</span>,
        fields=<span class="hljs-literal">None</span>,
    ),
    ...
]`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function vU(T){let t,u=`When listing collections, the item list per collection is truncated to 4 items maximum. To retrieve all items
from a collection, you must use <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.get_collection">get_collection()</a>.`;return{c(){t=c("p"),t.innerHTML=u},l(i){t=l(i,"P",{"data-svelte-h":!0}),d(t)!=="svelte-m77nml"&&(t.innerHTML=u)},m(i,a){$(i,t,a)},p:U,d(i){i&&p(t)}}}function xU(T){let t,u="Example usage with the <code>filter</code> argument:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS5saXN0X2RhdGFzZXRzKCklMEElMEElMEFhcGkubGlzdF9kYXRhc2V0cyhmaWx0ZXIlM0QlMjJ0YXNrX2NhdGVnb3JpZXMlM0F0ZXh0LWNsYXNzaWZpY2F0aW9uJTIyKSUwQSUwQSUwQWFwaS5saXN0X2RhdGFzZXRzKCUwQSUyMCUyMCUyMCUyMGZpbHRlciUzRCglMjJsYW5ndWFnZSUzQXJ1JTIyJTJDJTIwJTIydGFza19pZHMlM0FsYW5ndWFnZS1tb2RlbGluZyUyMiklMEEpJTBBJTBBYXBpLmxpc3RfZGF0YXNldHModGFncyUzRCUyMmZpZnR5b25lJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># List all datasets</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_datasets()


<span class="hljs-comment"># List only the text classification datasets</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_datasets(<span class="hljs-built_in">filter</span>=<span class="hljs-string">&quot;task_categories:text-classification&quot;</span>)


<span class="hljs-comment"># List only the datasets in russian for language modeling</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_datasets(
<span class="hljs-meta">... </span>    <span class="hljs-built_in">filter</span>=(<span class="hljs-string">&quot;language:ru&quot;</span>, <span class="hljs-string">&quot;task_ids:language-modeling&quot;</span>)
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># List FiftyOne datasets (identified by the tag &quot;fiftyone&quot; in dataset card)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_datasets(tags=<span class="hljs-string">&quot;fiftyone&quot;</span>)`,wrap:!1}}),{c(){t=c("p"),t.innerHTML=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-1lrmw6w"&&(t.innerHTML=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function $U(T){let t,u="Example usage with the <code>search</code> argument:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS5saXN0X2RhdGFzZXRzKHNlYXJjaCUzRCUyMnRleHQlMjIpJTBBJTBBYXBpLmxpc3RfZGF0YXNldHMoc2VhcmNoJTNEJTIydGV4dCUyMiUyQyUyMGF1dGhvciUzRCUyMmdvb2dsZSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># List all datasets with &quot;text&quot; in their name</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_datasets(search=<span class="hljs-string">&quot;text&quot;</span>)

<span class="hljs-comment"># List all datasets with &quot;text&quot; in their name made by google</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_datasets(search=<span class="hljs-string">&quot;text&quot;</span>, author=<span class="hljs-string">&quot;google&quot;</span>)`,wrap:!1}}),{c(){t=c("p"),t.innerHTML=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-1oyacuq"&&(t.innerHTML=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function wU(T){let t,u=`<code>list_inference_catalog</code> is experimental. Its API is subject to change in the future. Please provide feedback
if you have any suggestions or requests.`;return{c(){t=c("p"),t.innerHTML=u},l(i){t=l(i,"P",{"data-svelte-h":!0}),d(t)!=="svelte-jn3ftn"&&(t.innerHTML=u)},m(i,a){$(i,t,a)},p:U,d(i){i&&p(t)}}}function kU(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWFwaS5saXN0X2luZmVyZW5jZV9lbmRwb2ludHMoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_inference_endpoints()
[InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint&#x27;</span>, ...), ...]`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function TU(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWxmc19maWxlcyUyMCUzRCUyMGFwaS5saXN0X2xmc19maWxlcyglMjJ1c2VybmFtZSUyRm15LWNvb2wtcmVwbyUyMiklMEElMEFsZnNfZmlsZXNfdG9fZGVsZXRlJTIwJTNEJTIwKGxmc19maWxlJTIwZm9yJTIwbGZzX2ZpbGUlMjBpbiUyMGxmc19maWxlcyUyMGlmJTIwbGZzX2ZpbGUuZmlsZW5hbWUuc3RhcnRzd2l0aCglMjJjaGVja3BvaW50cyUyRiUyMikpJTBBJTBBYXBpLnBlcm1hbmVudGx5X2RlbGV0ZV9sZnNfZmlsZXMoJTIydXNlcm5hbWUlMkZteS1jb29sLXJlcG8lMjIlMkMlMjBsZnNfZmlsZXNfdG9fZGVsZXRlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>lfs_files = api.list_lfs_files(<span class="hljs-string">&quot;username/my-cool-repo&quot;</span>)

<span class="hljs-comment"># Filter files files to delete based on a combination of \`filename\`, \`pushed_at\`, \`ref\` or \`size\`.</span>
<span class="hljs-comment"># e.g. select only LFS files in the &quot;checkpoints&quot; folder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>lfs_files_to_delete = (lfs_file <span class="hljs-keyword">for</span> lfs_file <span class="hljs-keyword">in</span> lfs_files <span class="hljs-keyword">if</span> lfs_file.filename.startswith(<span class="hljs-string">&quot;checkpoints/&quot;</span>))

<span class="hljs-comment"># Permanently delete LFS files</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.permanently_delete_lfs_files(<span class="hljs-string">&quot;username/my-cool-repo&quot;</span>, lfs_files_to_delete)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function jU(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfbGlrZWRfcmVwb3MlMEElMEFsaWtlcyUyMCUzRCUyMGxpc3RfbGlrZWRfcmVwb3MoJTIyanVsaWVuLWMlMjIpJTBBJTBBbGlrZXMudXNlciUwQSUwQWxpa2VzLm1vZGVscw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_liked_repos

<span class="hljs-meta">&gt;&gt;&gt; </span>likes = list_liked_repos(<span class="hljs-string">&quot;julien-c&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>likes.user
<span class="hljs-string">&quot;julien-c&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>likes.models
[<span class="hljs-string">&quot;osanseviero/streamlit_1.15&quot;</span>, <span class="hljs-string">&quot;Xhaheen/ChatGPT_HF&quot;</span>, ...]`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function MU(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS5saXN0X21vZGVscygpJTBBJTBBYXBpLmxpc3RfbW9kZWxzKGZpbHRlciUzRCUyMnRleHQtY2xhc3NpZmljYXRpb24lMjIpJTBBJTBBYXBpLmxpc3RfbW9kZWxzKGZpbHRlciUzRCUyMmtlcmFzLWh1YiUyMiklMEElMEFhcGkubGlzdF9tb2RlbHMoaW5mZXJlbmNlX3Byb3ZpZGVyJTNEJTIyY29oZXJlJTIyKSUwQSUwQWFwaS5saXN0X21vZGVscyhzZWFyY2glM0QlMjJiZXJ0JTIyKSUwQSUwQWFwaS5saXN0X21vZGVscyhzZWFyY2glM0QlMjJiZXJ0JTIyJTJDJTIwYXV0aG9yJTNEJTIyZ29vZ2xlJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># List all models</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_models()

<span class="hljs-comment"># List text classification models</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_models(<span class="hljs-built_in">filter</span>=<span class="hljs-string">&quot;text-classification&quot;</span>)

<span class="hljs-comment"># List models from the KerasHub library</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_models(<span class="hljs-built_in">filter</span>=<span class="hljs-string">&quot;keras-hub&quot;</span>)

<span class="hljs-comment"># List models served by Cohere</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_models(inference_provider=<span class="hljs-string">&quot;cohere&quot;</span>)

<span class="hljs-comment"># List models with &quot;bert&quot; in their name</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_models(search=<span class="hljs-string">&quot;bert&quot;</span>)

<span class="hljs-comment"># List models with &quot;bert&quot; in their name and pushed by google</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_models(search=<span class="hljs-string">&quot;bert&quot;</span>, author=<span class="hljs-string">&quot;google&quot;</span>)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function qU(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS5saXN0X3BhcGVycyhxdWVyeSUzRCUyMmF0dGVudGlvbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># List all papers with &quot;attention&quot; in their title</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_papers(query=<span class="hljs-string">&quot;attention&quot;</span>)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function UU(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfcGVuZGluZ19hY2Nlc3NfcmVxdWVzdHMlMkMlMjBhY2NlcHRfYWNjZXNzX3JlcXVlc3QlMEElMEFyZXF1ZXN0cyUyMCUzRCUyMGxpc3RfcGVuZGluZ19hY2Nlc3NfcmVxdWVzdHMoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2IlMjIpJTBBbGVuKHJlcXVlc3RzKSUwQXJlcXVlc3RzJTVCMCU1RCUwQSUwQWFjY2VwdF9hY2Nlc3NfcmVxdWVzdCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03YiUyMiUyQyUyMCUyMmNsZW0lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_pending_access_requests, accept_access_request

<span class="hljs-comment"># List pending requests</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>requests = list_pending_access_requests(<span class="hljs-string">&quot;meta-llama/Llama-2-7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(requests)
<span class="hljs-number">411</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>requests[<span class="hljs-number">0</span>]
[
    AccessRequest(
        username=<span class="hljs-string">&#x27;clem&#x27;</span>,
        fullname=<span class="hljs-string">&#x27;Clem 🤗&#x27;</span>,
        email=<span class="hljs-string">&#x27;***&#x27;</span>,
        timestamp=datetime.datetime(<span class="hljs-number">2023</span>, <span class="hljs-number">11</span>, <span class="hljs-number">23</span>, <span class="hljs-number">18</span>, <span class="hljs-number">4</span>, <span class="hljs-number">53</span>, <span class="hljs-number">828000</span>, tzinfo=datetime.timezone.utc),
        status=<span class="hljs-string">&#x27;pending&#x27;</span>,
        fields=<span class="hljs-literal">None</span>,
    ),
    ...
]

<span class="hljs-comment"># Accept Clem&#x27;s request</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>accept_access_request(<span class="hljs-string">&quot;meta-llama/Llama-2-7b&quot;</span>, <span class="hljs-string">&quot;clem&quot;</span>)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function HU(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfcmVqZWN0ZWRfYWNjZXNzX3JlcXVlc3RzJTBBJTBBcmVxdWVzdHMlMjAlM0QlMjBsaXN0X3JlamVjdGVkX2FjY2Vzc19yZXF1ZXN0cyglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03YiUyMiklMEFsZW4ocmVxdWVzdHMpJTBBcmVxdWVzdHMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_rejected_access_requests

<span class="hljs-meta">&gt;&gt;&gt; </span>requests = list_rejected_access_requests(<span class="hljs-string">&quot;meta-llama/Llama-2-7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(requests)
<span class="hljs-number">411</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>requests[<span class="hljs-number">0</span>]
[
    AccessRequest(
        username=<span class="hljs-string">&#x27;clem&#x27;</span>,
        fullname=<span class="hljs-string">&#x27;Clem 🤗&#x27;</span>,
        email=<span class="hljs-string">&#x27;***&#x27;</span>,
        timestamp=datetime.datetime(<span class="hljs-number">2023</span>, <span class="hljs-number">11</span>, <span class="hljs-number">23</span>, <span class="hljs-number">18</span>, <span class="hljs-number">4</span>, <span class="hljs-number">53</span>, <span class="hljs-number">828000</span>, tzinfo=datetime.timezone.utc),
        status=<span class="hljs-string">&#x27;rejected&#x27;</span>,
        fields=<span class="hljs-literal">None</span>,
    ),
    ...
]`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function CU(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWluaXRpYWxfY29tbWl0JTIwJTNEJTIwYXBpLmxpc3RfcmVwb19jb21taXRzKCUyMmdwdDIlMjIpJTVCLTElNUQlMEElMEFpbml0aWFsX2NvbW1pdCUwQSUwQWFwaS5jcmVhdGVfYnJhbmNoKCUyMmdwdDIlMjIlMkMlMjAlMjJuZXdfZW1wdHlfYnJhbmNoJTIyJTJDJTIwcmV2aXNpb24lM0Rpbml0aWFsX2NvbW1pdC5jb21taXRfaWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># Commits are sorted by date (last commit first)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>initial_commit = api.list_repo_commits(<span class="hljs-string">&quot;gpt2&quot;</span>)[-<span class="hljs-number">1</span>]

<span class="hljs-comment"># Initial commit is always a system commit containing the \`.gitattributes\` file.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>initial_commit
GitCommitInfo(
    commit_id=<span class="hljs-string">&#x27;9b865efde13a30c13e0a33e536cf3e4a5a9d71d8&#x27;</span>,
    authors=[<span class="hljs-string">&#x27;system&#x27;</span>],
    created_at=datetime.datetime(<span class="hljs-number">2019</span>, <span class="hljs-number">2</span>, <span class="hljs-number">18</span>, <span class="hljs-number">10</span>, <span class="hljs-number">36</span>, <span class="hljs-number">15</span>, tzinfo=datetime.timezone.utc),
    title=<span class="hljs-string">&#x27;initial commit&#x27;</span>,
    message=<span class="hljs-string">&#x27;&#x27;</span>,
    formatted_title=<span class="hljs-literal">None</span>,
    formatted_message=<span class="hljs-literal">None</span>
)

<span class="hljs-comment"># Create an empty branch by deriving from initial commit</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_branch(<span class="hljs-string">&quot;gpt2&quot;</span>, <span class="hljs-string">&quot;new_empty_branch&quot;</span>, revision=initial_commit.commit_id)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function IU(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWFwaS5saXN0X3JlcG9fcmVmcyglMjJncHQyJTIyKSUwQSUwQWFwaS5saXN0X3JlcG9fcmVmcyglMjJiaWdjb2RlJTJGdGhlLXN0YWNrJTIyJTJDJTIwcmVwb190eXBlJTNEJ2RhdGFzZXQnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_repo_refs(<span class="hljs-string">&quot;gpt2&quot;</span>)
GitRefs(branches=[GitRefInfo(name=<span class="hljs-string">&#x27;main&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/heads/main&#x27;</span>, target_commit=<span class="hljs-string">&#x27;e7da7f221d5bf496a48136c0cd264e630fe9fcc8&#x27;</span>)], converts=[], tags=[])

<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_repo_refs(<span class="hljs-string">&quot;bigcode/the-stack&quot;</span>, repo_type=<span class="hljs-string">&#x27;dataset&#x27;</span>)
GitRefs(
    branches=[
        GitRefInfo(name=<span class="hljs-string">&#x27;main&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/heads/main&#x27;</span>, target_commit=<span class="hljs-string">&#x27;18edc1591d9ce72aa82f56c4431b3c969b210ae3&#x27;</span>),
        GitRefInfo(name=<span class="hljs-string">&#x27;v1.1.a1&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/heads/v1.1.a1&#x27;</span>, target_commit=<span class="hljs-string">&#x27;f9826b862d1567f3822d3d25649b0d6d22ace714&#x27;</span>)
    ],
    converts=[],
    tags=[
        GitRefInfo(name=<span class="hljs-string">&#x27;v1.0&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/tags/v1.0&#x27;</span>, target_commit=<span class="hljs-string">&#x27;c37a8cd1e382064d8aced5e05543c5f7753834da&#x27;</span>)
    ]
)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function JU(T){let t,u;return t=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfcmVwb190cmVlJTBBcmVwb190cmVlJTIwJTNEJTIwbGlzdF9yZXBvX3RyZWUoJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIpJTBBcmVwb190cmVlJTBBbGlzdChyZXBvX3RyZWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_repo_tree
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_tree = list_repo_tree(<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_tree
&lt;generator <span class="hljs-built_in">object</span> HfApi.list_repo_tree at <span class="hljs-number">0x7fa4088e1ac0</span>&gt;
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(repo_tree)
[
    RepoFile(path=<span class="hljs-string">&#x27;.gitattributes&#x27;</span>, size=<span class="hljs-number">391</span>, blob_id=<span class="hljs-string">&#x27;ae8c63daedbd4206d7d40126955d4e6ab1c80f8f&#x27;</span>, lfs=<span class="hljs-literal">None</span>, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>),
    RepoFile(path=<span class="hljs-string">&#x27;README.md&#x27;</span>, size=<span class="hljs-number">391</span>, blob_id=<span class="hljs-string">&#x27;43bd404b159de6fba7c2f4d3264347668d43af25&#x27;</span>, lfs=<span class="hljs-literal">None</span>, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>),
    RepoFile(path=<span class="hljs-string">&#x27;config.json&#x27;</span>, size=<span class="hljs-number">554</span>, blob_id=<span class="hljs-string">&#x27;2f9618c3a19b9a61add74f70bfb121335aeef666&#x27;</span>, lfs=<span class="hljs-literal">None</span>, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>),
    RepoFile(
        path=<span class="hljs-string">&#x27;flax_model.msgpack&#x27;</span>, size=<span class="hljs-number">497764107</span>, blob_id=<span class="hljs-string">&#x27;8095a62ccb4d806da7666fcda07467e2d150218e&#x27;</span>,
        lfs={<span class="hljs-string">&#x27;size&#x27;</span>: <span class="hljs-number">497764107</span>, <span class="hljs-string">&#x27;sha256&#x27;</span>: <span class="hljs-string">&#x27;d88b0d6a6ff9c3f8151f9d3228f57092aaea997f09af009eefd7373a77b5abb9&#x27;</span>, <span class="hljs-string">&#x27;pointer_size&#x27;</span>: <span class="hljs-number">134</span>}, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>
    ),
    RepoFile(path=<span class="hljs-string">&#x27;merges.txt&#x27;</span>, size=<span class="hljs-number">456318</span>, blob_id=<span class="hljs-string">&#x27;226b0752cac7789c48f0cb3ec53eda48b7be36cc&#x27;</span>, lfs=<span class="hljs-literal">None</span>, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>),
    RepoFile(
        path=<span class="hljs-string">&#x27;pytorch_model.bin&#x27;</span>, size=<span class="hljs-number">548123560</span>, blob_id=<span class="hljs-string">&#x27;64eaa9c526867e404b68f2c5d66fd78e27026523&#x27;</span>,
        lfs={<span class="hljs-string">&#x27;size&#x27;</span>: <span class="hljs-number">548123560</span>, <span class="hljs-string">&#x27;sha256&#x27;</span>: <span class="hljs-string">&#x27;9be78edb5b928eba33aa88f431551348f7466ba9f5ef3daf1d552398722a5436&#x27;</span>, <span class="hljs-string">&#x27;pointer_size&#x27;</span>: <span class="hljs-number">134</span>}, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>
    ),
    RepoFile(path=<span class="hljs-string">&#x27;vocab.json&#x27;</span>, size=<span class="hljs-number">898669</span>, blob_id=<span class="hljs-string">&#x27;b00361fece0387ca34b4b8b8539ed830d644dbeb&#x27;</span>, lfs=<span class="hljs-literal">None</span>, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>)]
]`,wrap:!1}}),{c(){h(t.$$.fragment)},l(i){f(t.$$.fragment,i)},m(i,a){m(t,i,a),u=!0},p:U,i(i){u||(_(t.$$.fragment,i),u=!0)},o(i){b(t.$$.fragment,i),u=!1},d(i){y(t,i)}}}function NU(T){let t,u;return t=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfcmVwb190cmVlJTBBcmVwb190cmVlJTIwJTNEJTIwbGlzdF9yZXBvX3RyZWUoJTIycHJvbXB0aGVybyUyRm9wZW5qb3VybmV5LXY0JTIyJTJDJTIwZXhwYW5kJTNEVHJ1ZSklMEFsaXN0KHJlcG9fdHJlZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_repo_tree
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_tree = list_repo_tree(<span class="hljs-string">&quot;prompthero/openjourney-v4&quot;</span>, expand=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(repo_tree)
[
    RepoFolder(
        path=<span class="hljs-string">&#x27;feature_extractor&#x27;</span>,
        tree_id=<span class="hljs-string">&#x27;aa536c4ea18073388b5b0bc791057a7296a00398&#x27;</span>,
        last_commit={
            <span class="hljs-string">&#x27;oid&#x27;</span>: <span class="hljs-string">&#x27;47b62b20b20e06b9de610e840282b7e6c3d51190&#x27;</span>,
            <span class="hljs-string">&#x27;title&#x27;</span>: <span class="hljs-string">&#x27;Upload diffusers weights (#48)&#x27;</span>,
            <span class="hljs-string">&#x27;date&#x27;</span>: datetime.datetime(<span class="hljs-number">2023</span>, <span class="hljs-number">3</span>, <span class="hljs-number">21</span>, <span class="hljs-number">9</span>, <span class="hljs-number">5</span>, <span class="hljs-number">27</span>, tzinfo=datetime.timezone.utc)
        }
    ),
    RepoFolder(
        path=<span class="hljs-string">&#x27;safety_checker&#x27;</span>,
        tree_id=<span class="hljs-string">&#x27;65aef9d787e5557373fdf714d6c34d4fcdd70440&#x27;</span>,
        last_commit={
            <span class="hljs-string">&#x27;oid&#x27;</span>: <span class="hljs-string">&#x27;47b62b20b20e06b9de610e840282b7e6c3d51190&#x27;</span>,
            <span class="hljs-string">&#x27;title&#x27;</span>: <span class="hljs-string">&#x27;Upload diffusers weights (#48)&#x27;</span>,
            <span class="hljs-string">&#x27;date&#x27;</span>: datetime.datetime(<span class="hljs-number">2023</span>, <span class="hljs-number">3</span>, <span class="hljs-number">21</span>, <span class="hljs-number">9</span>, <span class="hljs-number">5</span>, <span class="hljs-number">27</span>, tzinfo=datetime.timezone.utc)
        }
    ),
    RepoFile(
        path=<span class="hljs-string">&#x27;model_index.json&#x27;</span>,
        size=<span class="hljs-number">582</span>,
        blob_id=<span class="hljs-string">&#x27;d3d7c1e8c3e78eeb1640b8e2041ee256e24c9ee1&#x27;</span>,
        lfs=<span class="hljs-literal">None</span>,
        last_commit={
            <span class="hljs-string">&#x27;oid&#x27;</span>: <span class="hljs-string">&#x27;b195ed2d503f3eb29637050a886d77bd81d35f0e&#x27;</span>,
            <span class="hljs-string">&#x27;title&#x27;</span>: <span class="hljs-string">&#x27;Fix deprecation warning by changing \`CLIPFeatureExtractor\` to \`CLIPImageProcessor\`. (#54)&#x27;</span>,
            <span class="hljs-string">&#x27;date&#x27;</span>: datetime.datetime(<span class="hljs-number">2023</span>, <span class="hljs-number">5</span>, <span class="hljs-number">15</span>, <span class="hljs-number">21</span>, <span class="hljs-number">41</span>, <span class="hljs-number">59</span>, tzinfo=datetime.timezone.utc)
        },
        security={
            <span class="hljs-string">&#x27;safe&#x27;</span>: <span class="hljs-literal">True</span>,
            <span class="hljs-string">&#x27;av_scan&#x27;</span>: {<span class="hljs-string">&#x27;virusFound&#x27;</span>: <span class="hljs-literal">False</span>, <span class="hljs-string">&#x27;virusNames&#x27;</span>: <span class="hljs-literal">None</span>},
            <span class="hljs-string">&#x27;pickle_import_scan&#x27;</span>: <span class="hljs-literal">None</span>
        }
    )
    ...
]`,wrap:!1}}),{c(){h(t.$$.fragment)},l(i){f(t.$$.fragment,i)},m(i,a){m(t,i,a),u=!0},p:U,i(i){u||(_(t.$$.fragment,i),u=!0)},o(i){b(t.$$.fragment,i),u=!1},d(i){y(t,i)}}}function AU(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3Rfd2ViaG9va3MlMEF3ZWJob29rcyUyMCUzRCUyMGxpc3Rfd2ViaG9va3MoKSUwQWxlbih3ZWJob29rcyklMEF3ZWJob29rcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_webhooks
<span class="hljs-meta">&gt;&gt;&gt; </span>webhooks = list_webhooks()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(webhooks)
<span class="hljs-number">2</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>webhooks[<span class="hljs-number">0</span>]
WebhookInfo(
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
    watched=[WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;user&quot;</span>, name=<span class="hljs-string">&quot;julien-c&quot;</span>), WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;org&quot;</span>, name=<span class="hljs-string">&quot;HuggingFaceH4&quot;</span>)],
    url=<span class="hljs-string">&quot;https://webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
    disabled=<span class="hljs-literal">False</span>,
)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function EU(T){let t,u="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){t=c("p"),t.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-182te9i"&&(t.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1oggadp"&&(a.innerHTML=g)},m(e,v){$(e,t,v),$(e,i,v),$(e,a,v)},p:U,d(e){e&&(p(t),p(i),p(a))}}}function DU(T){let t,u="Raises the following errors:",i,a,g=`<li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError">RevisionNotFoundError</a>
If the revision to download from cannot be found.</li>`;return{c(){t=c("p"),t.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-182te9i"&&(t.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-117o2wk"&&(a.innerHTML=g)},m(e,v){$(e,t,v),$(e,i,v),$(e,a,v)},p:U,d(e){e&&(p(t),p(i),p(a))}}}function RU(T){let t,u="Raises the following errors:",i,a,g=`<li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){t=c("p"),t.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-182te9i"&&(t.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-hjndn0"&&(a.innerHTML=g)},m(e,v){$(e,t,v),$(e,i,v),$(e,a,v)},p:U,d(e){e&&(p(t),p(i),p(a))}}}function GU(T){let t,u=`This is a permanent action that will affect all commits referencing the deleted files and might corrupt your
repository. This is a non-revertible operation. Use it only if you know what you are doing.`;return{c(){t=c("p"),t.textContent=u},l(i){t=l(i,"P",{"data-svelte-h":!0}),d(t)!=="svelte-1tduvyk"&&(t.textContent=u)},m(i,a){$(i,t,a)},p:U,d(i){i&&p(t)}}}function ZU(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWxmc19maWxlcyUyMCUzRCUyMGFwaS5saXN0X2xmc19maWxlcyglMjJ1c2VybmFtZSUyRm15LWNvb2wtcmVwbyUyMiklMEElMEFsZnNfZmlsZXNfdG9fZGVsZXRlJTIwJTNEJTIwKGxmc19maWxlJTIwZm9yJTIwbGZzX2ZpbGUlMjBpbiUyMGxmc19maWxlcyUyMGlmJTIwbGZzX2ZpbGUuZmlsZW5hbWUuc3RhcnRzd2l0aCglMjJjaGVja3BvaW50cyUyRiUyMikpJTBBJTBBYXBpLnBlcm1hbmVudGx5X2RlbGV0ZV9sZnNfZmlsZXMoJTIydXNlcm5hbWUlMkZteS1jb29sLXJlcG8lMjIlMkMlMjBsZnNfZmlsZXNfdG9fZGVsZXRlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>lfs_files = api.list_lfs_files(<span class="hljs-string">&quot;username/my-cool-repo&quot;</span>)

<span class="hljs-comment"># Filter files files to delete based on a combination of \`filename\`, \`pushed_at\`, \`ref\` or \`size\`.</span>
<span class="hljs-comment"># e.g. select only LFS files in the &quot;checkpoints&quot; folder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>lfs_files_to_delete = (lfs_file <span class="hljs-keyword">for</span> lfs_file <span class="hljs-keyword">in</span> lfs_files <span class="hljs-keyword">if</span> lfs_file.filename.startswith(<span class="hljs-string">&quot;checkpoints/&quot;</span>))

<span class="hljs-comment"># Permanently delete LFS files</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.permanently_delete_lfs_files(<span class="hljs-string">&quot;username/my-cool-repo&quot;</span>, lfs_files_to_delete)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function FU(T){let t,u=`This is a power-user method. You shouldn’t need to call it directly to make a normal commit.
Use <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a> directly instead.`;return{c(){t=c("p"),t.innerHTML=u},l(i){t=l(i,"P",{"data-svelte-h":!0}),d(t)!=="svelte-1vdjdxz"&&(t.innerHTML=u)},m(i,a){$(i,t,a)},p:U,d(i){i&&p(t)}}}function SU(T){let t,u=`Commit operations will be mutated during the process. In particular, the attached <code>path_or_fileobj</code> will be
removed after the upload to save memory (and replaced by an empty <code>bytes</code> object). Do not reuse the same
objects except to pass them to <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a>. If you don’t want to remove the attached content from the
commit operation object, pass <code>free_memory=False</code>.`;return{c(){t=c("p"),t.innerHTML=u},l(i){t=l(i,"P",{"data-svelte-h":!0}),d(t)!=="svelte-xfsqok"&&(t.innerHTML=u)},m(i,a){$(i,t,a)},p:U,d(i){i&&p(t)}}}function LU(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMENvbW1pdE9wZXJhdGlvbkFkZCUyQyUyMHByZXVwbG9hZF9sZnNfZmlsZXMlMkMlMjBjcmVhdGVfY29tbWl0JTJDJTIwY3JlYXRlX3JlcG8lMEElMEFyZXBvX2lkJTIwJTNEJTIwY3JlYXRlX3JlcG8oJTIydGVzdF9wcmV1cGxvYWQlMjIpLnJlcG9faWQlMEElMEFvcGVyYXRpb25zJTIwJTNEJTIwJTVCJTVEJTIwJTIzJTIwTGlzdCUyMG9mJTIwYWxsJTIwJTYwQ29tbWl0T3BlcmF0aW9uQWRkJTYwJTIwb2JqZWN0cyUyMHRoYXQlMjB3aWxsJTIwYmUlMjBnZW5lcmF0ZWQlMEFmb3IlMjBpJTIwaW4lMjByYW5nZSg1KSUzQSUwQSUyMCUyMCUyMCUyMGNvbnRlbnQlMjAlM0QlMjAuLi4lMjAlMjMlMjBnZW5lcmF0ZSUyMGJpbmFyeSUyMGNvbnRlbnQlMEElMjAlMjAlMjAlMjBhZGRpdGlvbiUyMCUzRCUyMENvbW1pdE9wZXJhdGlvbkFkZChwYXRoX2luX3JlcG8lM0RmJTIyc2hhcmRfJTdCaSU3RF9vZl81LmJpbiUyMiUyQyUyMHBhdGhfb3JfZmlsZW9iaiUzRGNvbnRlbnQpJTBBJTIwJTIwJTIwJTIwcHJldXBsb2FkX2xmc19maWxlcyhyZXBvX2lkJTJDJTIwYWRkaXRpb25zJTNEJTVCYWRkaXRpb24lNUQpJTIwJTIzJTIwdXBsb2FkJTIwJTJCJTIwZnJlZSUyMG1lbW9yeSUwQSUyMCUyMCUyMCUyMG9wZXJhdGlvbnMuYXBwZW5kKGFkZGl0aW9uKSUwQSUwQWNyZWF0ZV9jb21taXQocmVwb19pZCUyQyUyMG9wZXJhdGlvbnMlM0RvcGVyYXRpb25zJTJDJTIwY29tbWl0X21lc3NhZ2UlM0QlMjJDb21taXQlMjBhbGwlMjBzaGFyZHMlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> CommitOperationAdd, preupload_lfs_files, create_commit, create_repo

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = create_repo(<span class="hljs-string">&quot;test_preupload&quot;</span>).repo_id

<span class="hljs-comment"># Generate and preupload LFS files one by one</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>operations = [] <span class="hljs-comment"># List of all \`CommitOperationAdd\` objects that will be generated</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
<span class="hljs-meta">... </span>    content = ... <span class="hljs-comment"># generate binary content</span>
<span class="hljs-meta">... </span>    addition = CommitOperationAdd(path_in_repo=<span class="hljs-string">f&quot;shard_<span class="hljs-subst">{i}</span>_of_5.bin&quot;</span>, path_or_fileobj=content)
<span class="hljs-meta">... </span>    preupload_lfs_files(repo_id, additions=[addition]) <span class="hljs-comment"># upload + free memory</span>
<span class="hljs-meta">... </span>    operations.append(addition)

<span class="hljs-comment"># Create commit</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>create_commit(repo_id, operations=operations, commit_message=<span class="hljs-string">&quot;Commit all shards&quot;</span>)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function WU(T){let t,u="Examples:",i,a,g;return a=new H({props:{code:"bmV3X3RpdGxlJTIwJTNEJTIwJTIyTmV3JTIwdGl0bGUlMkMlMjBmaXhpbmclMjBhJTIwdHlwbyUyMiUwQUhmQXBpKCkucmVuYW1lX2Rpc2N1c3Npb24oJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMnVzZXJuYW1lJTJGcmVwb19uYW1lJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGlzY3Vzc2lvbl9udW0lM0QzNCUwQSUyMCUyMCUyMCUyMG5ld190aXRsZSUzRG5ld190aXRsZSUwQSklMEE=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>new_title = <span class="hljs-string">&quot;New title, fixing a typo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>HfApi().rename_discussion(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/repo_name&quot;</span>,
<span class="hljs-meta">... </span>    discussion_num=<span class="hljs-number">34</span>
<span class="hljs-meta">... </span>    new_title=new_title
<span class="hljs-meta">... </span>)
<span class="hljs-comment"># DiscussionTitleChange(id=&#x27;deadbeef0000000&#x27;, type=&#x27;title-change&#x27;, ...)</span>
`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-kvfsh7"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function VU(T){let t,u="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){t=c("p"),t.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-182te9i"&&(t.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1oggadp"&&(a.innerHTML=g)},m(e,v){$(e,t,v),$(e,i,v),$(e,a,v)},p:U,d(e){e&&(p(t),p(i),p(a))}}}function BU(T){let t,u="Examples:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJlcG9fZXhpc3RzJTBBcmVwb19leGlzdHMoJTIyZ29vZ2xlJTJGZ2VtbWEtN2IlMjIpJTBBcmVwb19leGlzdHMoJTIyZ29vZ2xlJTJGbm90LWEtcmVwbyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> repo_exists
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_exists(<span class="hljs-string">&quot;google/gemma-7b&quot;</span>)
<span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_exists(<span class="hljs-string">&quot;google/not-a-repo&quot;</span>)
<span class="hljs-literal">False</span>`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-kvfsh7"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function PU(T){let t,u="Raises the following errors:",i,a,g=`<li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError">RevisionNotFoundError</a>
If the revision to download from cannot be found.</li>`;return{c(){t=c("p"),t.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-182te9i"&&(t.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-117o2wk"&&(a.innerHTML=g)},m(e,v){$(e,t,v),$(e,i,v),$(e,a,v)},p:U,d(e){e&&(p(t),p(i),p(a))}}}function YU(T){let t,u='It is also possible to request hardware directly when creating the Space repo! See <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a> for details.';return{c(){t=c("p"),t.innerHTML=u},l(i){t=l(i,"P",{"data-svelte-h":!0}),d(t)!=="svelte-752acu"&&(t.innerHTML=u)},m(i,a){$(i,t,a)},p:U,d(i){i&&p(t)}}}function XU(T){let t,u=`It is not possible to decrease persistent storage after its granted. To do so, you must delete it
via <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.delete_space_storage">delete_space_storage()</a>.`;return{c(){t=c("p"),t.innerHTML=u},l(i){t=l(i,"P",{"data-svelte-h":!0}),d(t)!=="svelte-w6dccp"&&(t.innerHTML=u)},m(i,a){$(i,t,a)},p:U,d(i){i&&p(t)}}}function QU(T){let t,u="Examples:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJldmlzaW9uX2V4aXN0cyUwQXJldmlzaW9uX2V4aXN0cyglMjJnb29nbGUlMkZnZW1tYS03YiUyMiUyQyUyMCUyMmZsb2F0MTYlMjIpJTBBcmV2aXNpb25fZXhpc3RzKCUyMmdvb2dsZSUyRmdlbW1hLTdiJTIyJTJDJTIwJTIybm90LWEtcmV2aXNpb24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> revision_exists
<span class="hljs-meta">&gt;&gt;&gt; </span>revision_exists(<span class="hljs-string">&quot;google/gemma-7b&quot;</span>, <span class="hljs-string">&quot;float16&quot;</span>)
<span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>revision_exists(<span class="hljs-string">&quot;google/gemma-7b&quot;</span>, <span class="hljs-string">&quot;not-a-revision&quot;</span>)
<span class="hljs-literal">False</span>`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-kvfsh7"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function zU(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWZ1dHVyZSUyMCUzRCUyMGFwaS5ydW5fYXNfZnV0dXJlKGFwaS53aG9hbWkpJTIwJTIzJTIwaW5zdGFudCUwQWZ1dHVyZS5kb25lKCklMEFmdXR1cmUucmVzdWx0KCklMjAlMjMlMjB3YWl0JTIwdW50aWwlMjBjb21wbGV0ZSUyMGFuZCUyMHJldHVybiUyMHJlc3VsdCUwQWZ1dHVyZS5kb25lKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>future = api.run_as_future(api.whoami) <span class="hljs-comment"># instant</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>future.done()
<span class="hljs-literal">False</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>future.result() <span class="hljs-comment"># wait until complete and return result</span>
(...)
<span class="hljs-meta">&gt;&gt;&gt; </span>future.done()
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function OU(T){let t,u="Run your first Job:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl9qb2IlMEFydW5fam9iKGltYWdlJTNEJTIycHl0aG9uJTNBMy4xMiUyMiUyQyUyMGNvbW1hbmQlM0QlNUIlMjJweXRob24lMjIlMkMlMjAlMjItYyUyMiUyMCUyQyUyMnByaW50KCdIZWxsbyUyMGZyb20lMjBIRiUyMGNvbXB1dGUhJyklMjIlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_job
<span class="hljs-meta">&gt;&gt;&gt; </span>run_job(image=<span class="hljs-string">&quot;python:3.12&quot;</span>, command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span> ,<span class="hljs-string">&quot;print(&#x27;Hello from HF compute!&#x27;)&quot;</span>])`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-1t6yql5"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function KU(T){let t,u="Run a GPU Job:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl9qb2IlMEFpbWFnZSUyMCUzRCUyMCUyMnB5dG9yY2glMkZweXRvcmNoJTNBMi42LjAtY3VkYTEyLjQtY3Vkbm45LWRldmVsJTIyJTBBY29tbWFuZCUyMCUzRCUyMCU1QiUyMnB5dGhvbiUyMiUyQyUyMCUyMi1jJTIyJTJDJTIwJTIyaW1wb3J0JTIwdG9yY2glM0IlMjBwcmludChmJTIyVGhpcyUyMGNvZGUlMjByYW4lMjB3aXRoJTIwdGhlJTIwZm9sbG93aW5nJTIwR1BVJTNBJTIwJTdCdG9yY2guY3VkYS5nZXRfZGV2aWNlX25hbWUoKSU3RCUyMiklMjIlNUQlMEFydW5fam9iKGltYWdlJTNEaW1hZ2UlMkMlMjBjb21tYW5kJTNEY29tbWFuZCUyQyUyMGZsYXZvciUzRCUyMmExMGctc21hbGwlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_job
<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-string">&quot;pytorch/pytorch:2.6.0-cuda12.4-cudnn9-devel&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>command = [<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;import torch; print(f&quot;</span>This code ran <span class="hljs-keyword">with</span> the following GPU: {torch.cuda.get_device_name()}<span class="hljs-string">&quot;)&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>run_job(image=image, command=command, flavor=<span class="hljs-string">&quot;a10g-small&quot;</span>)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-1b2mkbl"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function eH(T){let t,u="Run a script from a URL:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl91dl9qb2IlMEFzY3JpcHQlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZodWdnaW5nZmFjZSUyRnRybCUyRnJlZnMlMkZoZWFkcyUyRm1haW4lMkZ0cmwlMkZzY3JpcHRzJTJGc2Z0LnB5JTIyJTBBc2NyaXB0X2FyZ3MlMjAlM0QlMjAlNUIlMjItLW1vZGVsX25hbWVfb3JfcGF0aCUyMiUyQyUyMCUyMlF3ZW4lMkZRd2VuMi0wLjVCJTIyJTJDJTIwJTIyLS1kYXRhc2V0X25hbWUlMjIlMkMlMjAlMjJ0cmwtbGliJTJGQ2FweWJhcmElMjIlMkMlMjAlMjItLXB1c2hfdG9faHViJTIyJTVEJTBBcnVuX3V2X2pvYihzY3JpcHQlMkMlMjBzY3JpcHRfYXJncyUzRHNjcmlwdF9hcmdzJTJDJTIwZGVwZW5kZW5jaWVzJTNEJTVCJTIydHJsJTIyJTVEJTJDJTIwZmxhdm9yJTNEJTIyYTEwZy1zbWFsbCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_uv_job
<span class="hljs-meta">&gt;&gt;&gt; </span>script = <span class="hljs-string">&quot;https://raw.githubusercontent.com/huggingface/trl/refs/heads/main/trl/scripts/sft.py&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>script_args = [<span class="hljs-string">&quot;--model_name_or_path&quot;</span>, <span class="hljs-string">&quot;Qwen/Qwen2-0.5B&quot;</span>, <span class="hljs-string">&quot;--dataset_name&quot;</span>, <span class="hljs-string">&quot;trl-lib/Capybara&quot;</span>, <span class="hljs-string">&quot;--push_to_hub&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>run_uv_job(script, script_args=script_args, dependencies=[<span class="hljs-string">&quot;trl&quot;</span>], flavor=<span class="hljs-string">&quot;a10g-small&quot;</span>)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-1cabkub"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function tH(T){let t,u="Run a local script:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl91dl9qb2IlMEFzY3JpcHQlMjAlM0QlMjAlMjJteV9zZnQucHklMjIlMEFzY3JpcHRfYXJncyUyMCUzRCUyMCU1QiUyMi0tbW9kZWxfbmFtZV9vcl9wYXRoJTIyJTJDJTIwJTIyUXdlbiUyRlF3ZW4yLTAuNUIlMjIlMkMlMjAlMjItLWRhdGFzZXRfbmFtZSUyMiUyQyUyMCUyMnRybC1saWIlMkZDYXB5YmFyYSUyMiUyQyUyMCUyMi0tcHVzaF90b19odWIlMjIlNUQlMEFydW5fdXZfam9iKHNjcmlwdCUyQyUyMHNjcmlwdF9hcmdzJTNEc2NyaXB0X2FyZ3MlMkMlMjBkZXBlbmRlbmNpZXMlM0QlNUIlMjJ0cmwlMjIlNUQlMkMlMjBmbGF2b3IlM0QlMjJhMTBnLXNtYWxsJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_uv_job
<span class="hljs-meta">&gt;&gt;&gt; </span>script = <span class="hljs-string">&quot;my_sft.py&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>script_args = [<span class="hljs-string">&quot;--model_name_or_path&quot;</span>, <span class="hljs-string">&quot;Qwen/Qwen2-0.5B&quot;</span>, <span class="hljs-string">&quot;--dataset_name&quot;</span>, <span class="hljs-string">&quot;trl-lib/Capybara&quot;</span>, <span class="hljs-string">&quot;--push_to_hub&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>run_uv_job(script, script_args=script_args, dependencies=[<span class="hljs-string">&quot;trl&quot;</span>], flavor=<span class="hljs-string">&quot;a10g-small&quot;</span>)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-18unv7m"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function nH(T){let t,u="Run a command:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl91dl9qb2IlMEFzY3JpcHQlMjAlM0QlMjAlMjJsaWdodGV2YWwlMjIlMEFzY3JpcHRfYXJncyUzRCUyMCU1QiUyMmVuZHBvaW50JTIyJTJDJTIwJTIyaW5mZXJlbmNlLXByb3ZpZGVycyUyMiUyQyUyMCUyMm1vZGVsX25hbWUlM0RvcGVuYWklMkZncHQtb3NzLTIwYiUyQ3Byb3ZpZGVyJTNEYXV0byUyMiUyQyUyMCUyMmxpZ2h0ZXZhbCU3Q2dzbThrJTdDMCU3QzAlMjIlNUQlMEFydW5fdXZfam9iKHNjcmlwdCUyQyUyMHNjcmlwdF9hcmdzJTNEc2NyaXB0X2FyZ3MlMkMlMjBkZXBlbmRlbmNpZXMlM0QlNUIlMjJsaWdodGV2YWwlMjIlNUQlMkMlMjBmbGF2b3IlM0QlMjJhMTBnLXNtYWxsJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_uv_job
<span class="hljs-meta">&gt;&gt;&gt; </span>script = <span class="hljs-string">&quot;lighteval&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>script_args= [<span class="hljs-string">&quot;endpoint&quot;</span>, <span class="hljs-string">&quot;inference-providers&quot;</span>, <span class="hljs-string">&quot;model_name=openai/gpt-oss-20b,provider=auto&quot;</span>, <span class="hljs-string">&quot;lighteval|gsm8k|0|0&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>run_uv_job(script, script_args=script_args, dependencies=[<span class="hljs-string">&quot;lighteval&quot;</span>], flavor=<span class="hljs-string">&quot;a10g-small&quot;</span>)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-ko0f2l"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function oH(T){let t,u='It is also possible to set a custom sleep time when requesting hardware with <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.request_space_hardware">request_space_hardware()</a>.';return{c(){t=c("p"),t.innerHTML=u},l(i){t=l(i,"P",{"data-svelte-h":!0}),d(t)!=="svelte-1k7k0vb"&&(t.innerHTML=u)},m(i,a){$(i,t,a)},p:U,d(i){i&&p(t)}}}function aH(T){let t,u="Raises the following errors:",i,a,g=`<li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError">RevisionNotFoundError</a>
If the revision to download from cannot be found.</li>`;return{c(){t=c("p"),t.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-182te9i"&&(t.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-117o2wk"&&(a.innerHTML=g)},m(e,v){$(e,t,v),$(e,i,v),$(e,a,v)},p:U,d(e){e&&(p(t),p(i),p(a))}}}function sH(T){let t,u="Once squashed, the commit history cannot be retrieved. This is a non-revertible operation.";return{c(){t=c("p"),t.textContent=u},l(i){t=l(i,"P",{"data-svelte-h":!0}),d(t)!=="svelte-16nd2e3"&&(t.textContent=u)},m(i,a){$(i,t,a)},p:U,d(i){i&&p(t)}}}function rH(T){let t,u=`Once the history of a branch has been squashed, it is not possible to merge it back into another branch since
their history will have diverged.`;return{c(){t=c("p"),t.textContent=u},l(i){t=l(i,"P",{"data-svelte-h":!0}),d(t)!=="svelte-qbmppr"&&(t.textContent=u)},m(i,a){$(i,t,a)},p:U,d(i){i&&p(t)}}}function iH(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQXJlcG9faWQlMjAlM0QlMjBhcGkuY3JlYXRlX3JlcG8oJTIydGVzdC1zcXVhc2glMjIpLnJlcG9faWQlMEElMEFhcGkudXBsb2FkX2ZpbGUocmVwb19pZCUzRHJlcG9faWQlMkMlMjBwYXRoX2luX3JlcG8lM0QlMjJmaWxlLnR4dCUyMiUyQyUyMHBhdGhfb3JfZmlsZW9iaiUzRGIlMjJjb250ZW50JTIyKSUwQWFwaS51cGxvYWRfZmlsZShyZXBvX2lkJTNEcmVwb19pZCUyQyUyMHBhdGhfaW5fcmVwbyUzRCUyMmxmcy5iaW4lMjIlMkMlMjBwYXRoX29yX2ZpbGVvYmolM0RiJTIyY29udGVudCUyMiklMEFhcGkudXBsb2FkX2ZpbGUocmVwb19pZCUzRHJlcG9faWQlMkMlMjBwYXRoX2luX3JlcG8lM0QlMjJmaWxlLnR4dCUyMiUyQyUyMHBhdGhfb3JfZmlsZW9iaiUzRGIlMjJhbm90aGVyX2NvbnRlbnQlMjIpJTBBJTBBYXBpLnN1cGVyX3NxdWFzaF9oaXN0b3J5KHJlcG9faWQlM0RyZXBvX2lkKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># Create repo</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = api.create_repo(<span class="hljs-string">&quot;test-squash&quot;</span>).repo_id

<span class="hljs-comment"># Make a lot of commits.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_file(repo_id=repo_id, path_in_repo=<span class="hljs-string">&quot;file.txt&quot;</span>, path_or_fileobj=<span class="hljs-string">b&quot;content&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_file(repo_id=repo_id, path_in_repo=<span class="hljs-string">&quot;lfs.bin&quot;</span>, path_or_fileobj=<span class="hljs-string">b&quot;content&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_file(repo_id=repo_id, path_in_repo=<span class="hljs-string">&quot;file.txt&quot;</span>, path_or_fileobj=<span class="hljs-string">b&quot;another_content&quot;</span>)

<span class="hljs-comment"># Squash history</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.super_squash_history(repo_id=repo_id)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function cH(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfbGlrZWRfcmVwb3MlMkMlMjB1bmxpa2UlMEElMjJncHQyJTIyJTIwaW4lMjBsaXN0X2xpa2VkX3JlcG9zKCkubW9kZWxzJTIwJTIzJTIwd2UlMjBhc3N1bWUlMjB5b3UlMjBoYXZlJTIwYWxyZWFkeSUyMGxpa2VkJTIwZ3B0MiUwQXVubGlrZSglMjJncHQyJTIyKSUwQSUyMmdwdDIlMjIlMjBpbiUyMGxpc3RfbGlrZWRfcmVwb3MoKS5tb2RlbHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_liked_repos, unlike
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">&quot;gpt2&quot;</span> <span class="hljs-keyword">in</span> list_liked_repos().models <span class="hljs-comment"># we assume you have already liked gpt2</span>
<span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>unlike(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">&quot;gpt2&quot;</span> <span class="hljs-keyword">in</span> list_liked_repos().models
<span class="hljs-literal">False</span>`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function lH(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9jb2xsZWN0aW9uJTJDJTIwdXBkYXRlX2NvbGxlY3Rpb25faXRlbSUwQSUwQWNvbGxlY3Rpb24lMjAlM0QlMjBnZXRfY29sbGVjdGlvbiglMjJUaGVCbG9rZSUyRnJlY2VudC1tb2RlbHMtNjRmOWE1NWJiMzExNWI0ZjUxM2VjMDI2JTIyKSUwQSUwQXVwZGF0ZV9jb2xsZWN0aW9uX2l0ZW0oJTBBJTIwJTIwJTIwJTIwY29sbGVjdGlvbl9zbHVnJTNEJTIyVGhlQmxva2UlMkZyZWNlbnQtbW9kZWxzLTY0ZjlhNTViYjMxMTViNGY1MTNlYzAyNiUyMiUyQyUwQSUyMCUyMCUyMCUyMGl0ZW1fb2JqZWN0X2lkJTNEY29sbGVjdGlvbi5pdGVtcyU1Qi0xJTVELml0ZW1fb2JqZWN0X2lkJTJDJTBBJTIwJTIwJTIwJTIwbm90ZSUzRCUyMk5ld2x5JTIwdXBkYXRlZCUyMG1vZGVsISUyMiUwQSUyMCUyMCUyMCUyMHBvc2l0aW9uJTNEMCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_collection, update_collection_item

<span class="hljs-comment"># Get collection first</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = get_collection(<span class="hljs-string">&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</span>)

<span class="hljs-comment"># Update item based on its ID (add note + update position)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>update_collection_item(
<span class="hljs-meta">... </span>    collection_slug=<span class="hljs-string">&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</span>,
<span class="hljs-meta">... </span>    item_object_id=collection.items[-<span class="hljs-number">1</span>].item_object_id,
<span class="hljs-meta">... </span>    note=<span class="hljs-string">&quot;Newly updated model!&quot;</span>
<span class="hljs-meta">... </span>    position=<span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function pH(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHVwZGF0ZV9jb2xsZWN0aW9uX21ldGFkYXRhJTBBY29sbGVjdGlvbiUyMCUzRCUyMHVwZGF0ZV9jb2xsZWN0aW9uX21ldGFkYXRhKCUwQSUyMCUyMCUyMCUyMGNvbGxlY3Rpb25fc2x1ZyUzRCUyMnVzZXJuYW1lJTJGaWNjdi0yMDIzLTY0ZjlhNTViYjMxMTViNGY1MTNlYzAyNiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRpdGxlJTNEJTIySUNDViUyME9jdC4lMjAyMDIzJTIyJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJQb3J0Zm9saW8lMjBvZiUyMG1vZGVscyUyQyUyMGRhdGFzZXRzJTJDJTIwcGFwZXJzJTIwYW5kJTIwZGVtb3MlMjBJJTIwcHJlc2VudGVkJTIwYXQlMjBJQ0NWJTIwT2N0LiUyMDIwMjMlMjIlMkMlMEElMjAlMjAlMjAlMjBwcml2YXRlJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjB0aGVtZSUzRCUyMnBpbmslMjIlMkMlMEEpJTBBY29sbGVjdGlvbi5zbHVn",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> update_collection_metadata
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = update_collection_metadata(
<span class="hljs-meta">... </span>    collection_slug=<span class="hljs-string">&quot;username/iccv-2023-64f9a55bb3115b4f513ec026&quot;</span>,
<span class="hljs-meta">... </span>    title=<span class="hljs-string">&quot;ICCV Oct. 2023&quot;</span>
<span class="hljs-meta">... </span>    description=<span class="hljs-string">&quot;Portfolio of models, datasets, papers and demos I presented at ICCV Oct. 2023&quot;</span>,
<span class="hljs-meta">... </span>    private=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    theme=<span class="hljs-string">&quot;pink&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.slug
<span class="hljs-string">&quot;username/iccv-oct-2023-64f9a55bb3115b4f513ec026&quot;</span>
<span class="hljs-comment"># ^collection slug got updated but not the trailing ID</span>`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function dH(T){let t,u="Raises the following errors:",i,a,g=`<li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){t=c("p"),t.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-182te9i"&&(t.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-hjndn0"&&(a.innerHTML=g)},m(e,v){$(e,t,v),$(e,i,v),$(e,a,v)},p:U,d(e){e&&(p(t),p(i),p(a))}}}function gH(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHVwZGF0ZV93ZWJob29rJTBBdXBkYXRlZF9wYXlsb2FkJTIwJTNEJTIwdXBkYXRlX3dlYmhvb2soJTBBJTIwJTIwJTIwJTIwd2ViaG9va19pZCUzRCUyMjY1NGJiYmMxNmYyZWMxNGQ3N2YxMDljYyUyMiUyQyUwQSUyMCUyMCUyMCUyMHVybCUzRCUyMmh0dHBzJTNBJTJGJTJGbmV3LndlYmhvb2suc2l0ZSUyRmEyMTc2ZTgyLTU3MjAtNDNlZS05ZTA2LWY5MWNiNGM5MTU0OCUyMiUyQyUwQSUyMCUyMCUyMCUyMHdhdGNoZWQlM0QlNUIlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMm5hbWUlMjIlM0ElMjAlMjJqdWxpZW4tYyUyMiU3RCUyQyUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJvcmclMjIlMkMlMjAlMjJuYW1lJTIyJTNBJTIwJTIySHVnZ2luZ0ZhY2VINCUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMGRvbWFpbnMlM0QlNUIlMjJyZXBvJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwc2VjcmV0JTNEJTIybXktc2VjcmV0JTIyJTJDJTBBKSUwQXByaW50KHVwZGF0ZWRfcGF5bG9hZCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> update_webhook
<span class="hljs-meta">&gt;&gt;&gt; </span>updated_payload = update_webhook(
<span class="hljs-meta">... </span>    webhook_id=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
<span class="hljs-meta">... </span>    url=<span class="hljs-string">&quot;https://new.webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
<span class="hljs-meta">... </span>    watched=[{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;julien-c&quot;</span>}, {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;org&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;HuggingFaceH4&quot;</span>}],
<span class="hljs-meta">... </span>    domains=[<span class="hljs-string">&quot;repo&quot;</span>],
<span class="hljs-meta">... </span>    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(updated_payload)
WebhookInfo(
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
    url=<span class="hljs-string">&quot;https://new.webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
    watched=[WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;user&quot;</span>, name=<span class="hljs-string">&quot;julien-c&quot;</span>), WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;org&quot;</span>, name=<span class="hljs-string">&quot;HuggingFaceH4&quot;</span>)],
    domains=[<span class="hljs-string">&quot;repo&quot;</span>],
    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
    disabled=<span class="hljs-literal">False</span>,`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function uH(T){let t,u="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError">RevisionNotFoundError</a>
If the revision to download from cannot be found.</li>`;return{c(){t=c("p"),t.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-182te9i"&&(t.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-qqcg2t"&&(a.innerHTML=g)},m(e,v){$(e,t,v),$(e,i,v),$(e,a,v)},p:U,d(e){e&&(p(t),p(i),p(a))}}}function hH(T){let t,u=`<code>upload_file</code> assumes that the repo already exists on the Hub. If you get a
Client error 404, please make sure you are authenticated and that <code>repo_id</code> and
<code>repo_type</code> are set correctly. If repo does not exist, create it first using
<a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a>.`;return{c(){t=c("p"),t.innerHTML=u},l(i){t=l(i,"P",{"data-svelte-h":!0}),d(t)!=="svelte-gqeru2"&&(t.innerHTML=u)},m(i,a){$(i,t,a)},p:U,d(i){i&&p(t)}}}function fH(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHVwbG9hZF9maWxlJTBBJTBBd2l0aCUyMG9wZW4oJTIyLiUyRmxvY2FsJTJGZmlsZXBhdGglMjIlMkMlMjAlMjJyYiUyMiklMjBhcyUyMGZvYmolM0ElMEElMjAlMjAlMjAlMjB1cGxvYWRfZmlsZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwYXRoX29yX2ZpbGVvYmolM0RmaWxlb2JqJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGF0aF9pbl9yZXBvJTNEJTIycmVtb3RlJTJGZmlsZSUyRnBhdGguaDUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteS1kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRva2VuJTNEJTIybXlfdG9rZW4lMjIlMkMlMEElMjAlMjAlMjAlMjApJTBBJTBBdXBsb2FkX2ZpbGUoJTBBJTIwJTIwJTIwJTIwcGF0aF9vcl9maWxlb2JqJTNEJTIyLiU1QyU1Q2xvY2FsJTVDJTVDZmlsZSU1QyU1Q3BhdGglMjIlMkMlMEElMjAlMjAlMjAlMjBwYXRoX2luX3JlcG8lM0QlMjJyZW1vdGUlMkZmaWxlJTJGcGF0aC5oNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJ1c2VybmFtZSUyRm15LW1vZGVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW4lM0QlMjJteV90b2tlbiUyMiUyQyUwQSklMEElMEF1cGxvYWRfZmlsZSglMEElMjAlMjAlMjAlMjBwYXRoX29yX2ZpbGVvYmolM0QlMjIuJTVDJTVDbG9jYWwlNUMlNUNmaWxlJTVDJTVDcGF0aCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhdGhfaW5fcmVwbyUzRCUyMnJlbW90ZSUyRmZpbGUlMkZwYXRoLmg1JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMnVzZXJuYW1lJTJGbXktbW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjB0b2tlbiUzRCUyMm15X3Rva2VuJTIyJTJDJTBBJTIwJTIwJTIwJTIwY3JlYXRlX3ByJTNEVHJ1ZSUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> upload_file

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;./local/filepath&quot;</span>, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> fobj:
<span class="hljs-meta">... </span>    upload_file(
<span class="hljs-meta">... </span>        path_or_fileobj=fileobj,
<span class="hljs-meta">... </span>        path_in_repo=<span class="hljs-string">&quot;remote/file/path.h5&quot;</span>,
<span class="hljs-meta">... </span>        repo_id=<span class="hljs-string">&quot;username/my-dataset&quot;</span>,
<span class="hljs-meta">... </span>        repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
<span class="hljs-meta">... </span>        token=<span class="hljs-string">&quot;my_token&quot;</span>,
<span class="hljs-meta">... </span>    )
<span class="hljs-string">&quot;https://huggingface.co/datasets/username/my-dataset/blob/main/remote/file/path.h5&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>upload_file(
<span class="hljs-meta">... </span>    path_or_fileobj=<span class="hljs-string">&quot;.\\\\local\\\\file\\\\path&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;remote/file/path.h5&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-model&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-string">&quot;my_token&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-string">&quot;https://huggingface.co/username/my-model/blob/main/remote/file/path.h5&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>upload_file(
<span class="hljs-meta">... </span>    path_or_fileobj=<span class="hljs-string">&quot;.\\\\local\\\\file\\\\path&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;remote/file/path.h5&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-model&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-string">&quot;my_token&quot;</span>,
<span class="hljs-meta">... </span>    create_pr=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-string">&quot;https://huggingface.co/username/my-model/blob/refs%2Fpr%2F1/remote/file/path.h5&quot;</span>`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function mH(T){let t,u="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li>`;return{c(){t=c("p"),t.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-182te9i"&&(t.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1l6tbi1"&&(a.innerHTML=g)},m(e,v){$(e,t,v),$(e,i,v),$(e,a,v)},p:U,d(e){e&&(p(t),p(i),p(a))}}}function _H(T){let t,u=`<code>upload_folder</code> assumes that the repo already exists on the Hub. If you get a Client error 404, please make
sure you are authenticated and that <code>repo_id</code> and <code>repo_type</code> are set correctly. If repo does not exist, create
it first using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a>.`;return{c(){t=c("p"),t.innerHTML=u},l(i){t=l(i,"P",{"data-svelte-h":!0}),d(t)!=="svelte-1ofwh3e"&&(t.innerHTML=u)},m(i,a){$(i,t,a)},p:U,d(i){i&&p(t)}}}function bH(T){let t,u='When dealing with a large folder (thousands of files or hundreds of GB), we recommend using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.upload_large_folder">upload_large_folder()</a> instead.';return{c(){t=c("p"),t.innerHTML=u},l(i){t=l(i,"P",{"data-svelte-h":!0}),d(t)!=="svelte-1n31r9o"&&(t.innerHTML=u)},m(i,a){$(i,t,a)},p:U,d(i){i&&p(t)}}}function yH(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"dXBsb2FkX2ZvbGRlciglMEElMjAlMjAlMjAlMjBmb2xkZXJfcGF0aCUzRCUyMmxvY2FsJTJGY2hlY2twb2ludHMlMjIlMkMlMEElMjAlMjAlMjAlMjBwYXRoX2luX3JlcG8lM0QlMjJyZW1vdGUlMkZleHBlcmltZW50JTJGY2hlY2twb2ludHMlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteS1kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0b2tlbiUzRCUyMm15X3Rva2VuJTIyJTJDJTBBJTIwJTIwJTIwJTIwaWdub3JlX3BhdHRlcm5zJTNEJTIyKiolMkZsb2dzJTJGKi50eHQlMjIlMkMlMEEpJTBBJTBBdXBsb2FkX2ZvbGRlciglMEElMjAlMjAlMjAlMjBmb2xkZXJfcGF0aCUzRCUyMmxvY2FsJTJGY2hlY2twb2ludHMlMjIlMkMlMEElMjAlMjAlMjAlMjBwYXRoX2luX3JlcG8lM0QlMjJyZW1vdGUlMkZleHBlcmltZW50JTJGY2hlY2twb2ludHMlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteS1kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0b2tlbiUzRCUyMm15X3Rva2VuJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVsZXRlX3BhdHRlcm5zJTNEJTIyKiolMkZsb2dzJTJGKi50eHQlMjIlMkMlMEEpJTBBJTBBdXBsb2FkX2ZvbGRlciglMEElMjAlMjAlMjAlMjBmb2xkZXJfcGF0aCUzRCUyMmxvY2FsJTJGY2hlY2twb2ludHMlMjIlMkMlMEElMjAlMjAlMjAlMjBwYXRoX2luX3JlcG8lM0QlMjJyZW1vdGUlMkZleHBlcmltZW50JTJGY2hlY2twb2ludHMlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteS1kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0b2tlbiUzRCUyMm15X3Rva2VuJTIyJTJDJTBBJTIwJTIwJTIwJTIwY3JlYXRlX3ByJTNEVHJ1ZSUyQyUwQSklMEE=",highlighted:`<span class="hljs-comment"># Upload checkpoints folder except the log files</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>upload_folder(
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;local/checkpoints&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;remote/experiment/checkpoints&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-dataset&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;datasets&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-string">&quot;my_token&quot;</span>,
<span class="hljs-meta">... </span>    ignore_patterns=<span class="hljs-string">&quot;**/logs/*.txt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-comment"># &quot;https://huggingface.co/datasets/username/my-dataset/tree/main/remote/experiment/checkpoints&quot;</span>

<span class="hljs-comment"># Upload checkpoints folder including logs while deleting existing logs from the repo</span>
<span class="hljs-comment"># Useful if you don&#x27;t know exactly which log files have already being pushed</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>upload_folder(
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;local/checkpoints&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;remote/experiment/checkpoints&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-dataset&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;datasets&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-string">&quot;my_token&quot;</span>,
<span class="hljs-meta">... </span>    delete_patterns=<span class="hljs-string">&quot;**/logs/*.txt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-string">&quot;https://huggingface.co/datasets/username/my-dataset/tree/main/remote/experiment/checkpoints&quot;</span>

<span class="hljs-comment"># Upload checkpoints folder while creating a PR</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>upload_folder(
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;local/checkpoints&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;remote/experiment/checkpoints&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-dataset&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;datasets&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-string">&quot;my_token&quot;</span>,
<span class="hljs-meta">... </span>    create_pr=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-string">&quot;https://huggingface.co/datasets/username/my-dataset/tree/refs%2Fpr%2F1/remote/experiment/checkpoints&quot;</span>
`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function vH(T){let t,u="A few things to keep in mind:",i,a,g='<li>Repository limits still apply: <a href="https://huggingface.co/docs/hub/repositories-recommendations" rel="nofollow">https://huggingface.co/docs/hub/repositories-recommendations</a></li> <li>Do not start several processes in parallel.</li> <li>You can interrupt and resume the process at any time.</li> <li>Do not upload the same folder to several repositories. If you need to do so, you must delete the local <code>.cache/.huggingface/</code> folder first.</li>';return{c(){t=c("p"),t.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-vnn6d1"&&(t.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1iweq7b"&&(a.innerHTML=g)},m(e,v){$(e,t,v),$(e,i,v),$(e,a,v)},p:U,d(e){e&&(p(t),p(i),p(a))}}}function xH(T){let t,u='While being much more robust to upload large folders, <code>upload_large_folder</code> is more limited than <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> feature-wise. In practice:',i,a,g='<li>you cannot set a custom <code>path_in_repo</code>. If you want to upload to a subfolder, you need to set the proper structure locally.</li> <li>you cannot set a custom <code>commit_message</code> and <code>commit_description</code> since multiple commits are created.</li> <li>you cannot delete from the repo while uploading. Please make a separate commit first.</li> <li>you cannot create a PR directly. Please create a PR first (from the UI or using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_pull_request">create_pull_request()</a>) and then commit to it by passing <code>revision</code>.</li>';return{c(){t=c("p"),t.innerHTML=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-1n7ws7"&&(t.innerHTML=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-gxpink"&&(a.innerHTML=g)},m(e,v){$(e,t,v),$(e,i,v),$(e,a,v)},p:U,d(e){e&&(p(t),p(i),p(a))}}}function $H(T){let t,u=`Most attributes of this class are optional. This is because the data returned by the Hub depends on the query made.
In general, the more specific the query, the more information is returned. On the contrary, when listing datasets
using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_datasets">list_datasets()</a> only a subset of the attributes are returned.`;return{c(){t=c("p"),t.innerHTML=u},l(i){t=l(i,"P",{"data-svelte-h":!0}),d(t)!=="svelte-fx9t9d"&&(t.innerHTML=u)},m(i,a){$(i,t,a)},p:U,d(i){i&&p(t)}}}function wH(T){let t,u=`Most attributes of this class are optional. This is because the data returned by the Hub depends on the query made.
In general, the more specific the query, the more information is returned. On the contrary, when listing models
using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_models">list_models()</a> only a subset of the attributes are returned.`;return{c(){t=c("p"),t.innerHTML=u},l(i){t=l(i,"P",{"data-svelte-h":!0}),d(t)!=="svelte-1bvqy32"&&(t.innerHTML=u)},m(i,a){$(i,t,a)},p:U,d(i){i&&p(t)}}}function kH(T){let t,u=`All attributes of this class are optional except <code>rfilename</code>. This is because only the file names are returned when
listing repositories on the Hub (with <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_models">list_models()</a>, <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_datasets">list_datasets()</a> or <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_spaces">list_spaces()</a>). If you need more
information like file size, blob id or lfs details, you must request them specifically from one repo at a time
(using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.model_info">model_info()</a>, <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.dataset_info">dataset_info()</a> or <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.space_info">space_info()</a>) as it adds more constraints on the backend server to
retrieve these.`;return{c(){t=c("p"),t.innerHTML=u},l(i){t=l(i,"P",{"data-svelte-h":!0}),d(t)!=="svelte-1y8shbz"&&(t.innerHTML=u)},m(i,a){$(i,t,a)},p:U,d(i){i&&p(t)}}}function TH(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"UmVwb1VybCgnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmdwdDInKSUwQSUwQVJlcG9VcmwoJ2h0dHBzJTNBJTJGJTJGaHViLWNpLmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZkdW1teV91c2VyJTJGZHVtbXlfZGF0YXNldCclMkMlMjBlbmRwb2ludCUzRCdodHRwcyUzQSUyRiUyRmh1Yi1jaS5odWdnaW5nZmFjZS5jbycpJTBBJTBBUmVwb1VybCgnaGYlM0ElMkYlMkZkYXRhc2V0cyUyRm15LXVzZXIlMkZteS1kYXRhc2V0JyklMEElMEFIZkFwaS5jcmVhdGVfcmVwbyglMjJkdW1teV9tb2RlbCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>RepoUrl(<span class="hljs-string">&#x27;https://huggingface.co/gpt2&#x27;</span>)
RepoUrl(<span class="hljs-string">&#x27;https://huggingface.co/gpt2&#x27;</span>, endpoint=<span class="hljs-string">&#x27;https://huggingface.co&#x27;</span>, repo_type=<span class="hljs-string">&#x27;model&#x27;</span>, repo_id=<span class="hljs-string">&#x27;gpt2&#x27;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>RepoUrl(<span class="hljs-string">&#x27;https://hub-ci.huggingface.co/datasets/dummy_user/dummy_dataset&#x27;</span>, endpoint=<span class="hljs-string">&#x27;https://hub-ci.huggingface.co&#x27;</span>)
RepoUrl(<span class="hljs-string">&#x27;https://hub-ci.huggingface.co/datasets/dummy_user/dummy_dataset&#x27;</span>, endpoint=<span class="hljs-string">&#x27;https://hub-ci.huggingface.co&#x27;</span>, repo_type=<span class="hljs-string">&#x27;dataset&#x27;</span>, repo_id=<span class="hljs-string">&#x27;dummy_user/dummy_dataset&#x27;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>RepoUrl(<span class="hljs-string">&#x27;hf://datasets/my-user/my-dataset&#x27;</span>)
RepoUrl(<span class="hljs-string">&#x27;hf://datasets/my-user/my-dataset&#x27;</span>, endpoint=<span class="hljs-string">&#x27;https://huggingface.co&#x27;</span>, repo_type=<span class="hljs-string">&#x27;dataset&#x27;</span>, repo_id=<span class="hljs-string">&#x27;user/dataset&#x27;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>HfApi.create_repo(<span class="hljs-string">&quot;dummy_model&quot;</span>)
RepoUrl(<span class="hljs-string">&#x27;https://huggingface.co/Wauplin/dummy_model&#x27;</span>, endpoint=<span class="hljs-string">&#x27;https://huggingface.co&#x27;</span>, repo_type=<span class="hljs-string">&#x27;model&#x27;</span>, repo_id=<span class="hljs-string">&#x27;Wauplin/dummy_model&#x27;</span>)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function jH(T){let t,u=`Most attributes of this class are optional. This is because the data returned by the Hub depends on the query made.
In general, the more specific the query, the more information is returned. On the contrary, when listing spaces
using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_spaces">list_spaces()</a> only a subset of the attributes are returned.`;return{c(){t=c("p"),t.innerHTML=u},l(i){t=l(i,"P",{"data-svelte-h":!0}),d(t)!=="svelte-vi95sv"&&(t.innerHTML=u)},m(i,a){$(i,t,a)},p:U,d(i){i&&p(t)}}}function MH(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"b3BlcmF0aW9uJTIwJTNEJTIwQ29tbWl0T3BlcmF0aW9uQWRkKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhdGhfaW5fcmVwbyUzRCUyMnJlbW90ZSUyRmRpciUyRndlaWdodHMuaDUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjBwYXRoX29yX2ZpbGVvYmolM0QlMjIuJTJGbG9jYWwlMkZ3ZWlnaHRzLmg1JTIyJTJDJTBBKSUwQSUwQXdpdGglMjBvcGVyYXRpb24uYXNfZmlsZSgpJTIwYXMlMjBmaWxlJTNBJTBBJTIwJTIwJTIwJTIwY29udGVudCUyMCUzRCUyMGZpbGUucmVhZCgpJTBBJTBBd2l0aCUyMG9wZXJhdGlvbi5hc19maWxlKHdpdGhfdHFkbSUzRFRydWUpJTIwYXMlMjBmaWxlJTNBJTBBJTIwJTIwJTIwJTIwd2hpbGUlMjBUcnVlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YSUyMCUzRCUyMGZpbGUucmVhZCgxMDI0KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbm90JTIwZGF0YSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBd2l0aCUyMG9wZXJhdGlvbi5hc19maWxlKHdpdGhfdHFkbSUzRFRydWUpJTIwYXMlMjBmaWxlJTNBJTBBJTIwJTIwJTIwJTIwcmVxdWVzdHMucHV0KC4uLiUyQyUyMGRhdGElM0RmaWxlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>operation = CommitOperationAdd(
<span class="hljs-meta">... </span>       path_in_repo=<span class="hljs-string">&quot;remote/dir/weights.h5&quot;</span>,
<span class="hljs-meta">... </span>       path_or_fileobj=<span class="hljs-string">&quot;./local/weights.h5&quot;</span>,
<span class="hljs-meta">... </span>)
CommitOperationAdd(path_in_repo=<span class="hljs-string">&#x27;remote/dir/weights.h5&#x27;</span>, path_or_fileobj=<span class="hljs-string">&#x27;./local/weights.h5&#x27;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> operation.as_file() <span class="hljs-keyword">as</span> file:
<span class="hljs-meta">... </span>    content = file.read()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> operation.as_file(with_tqdm=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> file:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">while</span> <span class="hljs-literal">True</span>:
<span class="hljs-meta">... </span>        data = file.read(<span class="hljs-number">1024</span>)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> data:
<span class="hljs-meta">... </span>             <span class="hljs-keyword">break</span>
config.json: <span class="hljs-number">100</span>%|█████████████████████████| <span class="hljs-number">8.19</span>k/<span class="hljs-number">8.19</span>k [<span class="hljs-number">00</span>:02&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">3.72</span>kB/s]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> operation.as_file(with_tqdm=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> file:
<span class="hljs-meta">... </span>    requests.put(..., data=file)
config.json: <span class="hljs-number">100</span>%|█████████████████████████| <span class="hljs-number">8.19</span>k/<span class="hljs-number">8.19</span>k [<span class="hljs-number">00</span>:02&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">3.72</span>kB/s]`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function qH(T){let t,u="Example:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMENvbW1pdFNjaGVkdWxlciUwQSUwQWNzdl9wYXRoJTIwJTNEJTIwUGF0aCglMjJ3YXRjaGVkX2ZvbGRlciUyRmRhdGEuY3N2JTIyKSUwQUNvbW1pdFNjaGVkdWxlcihyZXBvX2lkJTNEJTIydGVzdF9zY2hlZHVsZXIlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyJTJDJTIwZm9sZGVyX3BhdGglM0Rjc3ZfcGF0aC5wYXJlbnQlMkMlMjBldmVyeSUzRDEwKSUwQSUwQXdpdGglMjBjc3ZfcGF0aC5vcGVuKCUyMmElMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwZi53cml0ZSglMjJmaXJzdCUyMGxpbmUlMjIpJTBBJTBBd2l0aCUyMGNzdl9wYXRoLm9wZW4oJTIyYSUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjBmLndyaXRlKCUyMnNlY29uZCUyMGxpbmUlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> CommitScheduler

<span class="hljs-comment"># Scheduler uploads every 10 minutes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>csv_path = Path(<span class="hljs-string">&quot;watched_folder/data.csv&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>CommitScheduler(repo_id=<span class="hljs-string">&quot;test_scheduler&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, folder_path=csv_path.parent, every=<span class="hljs-number">10</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> csv_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;a&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;first line&quot;</span>)

<span class="hljs-comment"># Some time later (...)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> csv_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;a&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;second line&quot;</span>)`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-11lpom8"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function UH(T){let t,u="Example using a context manager:",i,a,g;return a=new H({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMENvbW1pdFNjaGVkdWxlciUwQSUwQXdpdGglMjBDb21taXRTY2hlZHVsZXIocmVwb19pZCUzRCUyMnRlc3Rfc2NoZWR1bGVyJTIyJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUyMGZvbGRlcl9wYXRoJTNEJTIyd2F0Y2hlZF9mb2xkZXIlMjIlMkMlMjBldmVyeSUzRDEwKSUyMGFzJTIwc2NoZWR1bGVyJTNBJTBBJTIwJTIwJTIwJTIwY3N2X3BhdGglMjAlM0QlMjBQYXRoKCUyMndhdGNoZWRfZm9sZGVyJTJGZGF0YS5jc3YlMjIpJTBBJTIwJTIwJTIwJTIwd2l0aCUyMGNzdl9wYXRoLm9wZW4oJTIyYSUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmLndyaXRlKCUyMmZpcnN0JTIwbGluZSUyMiklMEElMjAlMjAlMjAlMjAoLi4uKSUwQSUyMCUyMCUyMCUyMHdpdGglMjBjc3ZfcGF0aC5vcGVuKCUyMmElMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZi53cml0ZSglMjJzZWNvbmQlMjBsaW5lJTIyKSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> CommitScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> CommitScheduler(repo_id=<span class="hljs-string">&quot;test_scheduler&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, folder_path=<span class="hljs-string">&quot;watched_folder&quot;</span>, every=<span class="hljs-number">10</span>) <span class="hljs-keyword">as</span> scheduler:
<span class="hljs-meta">... </span>    csv_path = Path(<span class="hljs-string">&quot;watched_folder/data.csv&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> csv_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;a&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>        f.write(<span class="hljs-string">&quot;first line&quot;</span>)
<span class="hljs-meta">... </span>    (...)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> csv_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;a&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>        f.write(<span class="hljs-string">&quot;second line&quot;</span>)

<span class="hljs-comment"># Scheduler is now stopped and last commit have been triggered</span>`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,i=s(),h(a.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),d(t)!=="svelte-k44prv"&&(t.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,v){$(e,t,v),$(e,i,v),m(a,e,v),g=!0},p:U,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(t),p(i)),y(a,e)}}}function HH(T){let t,u=`This method is not meant to be called directly. It is run in the background by the scheduler, respecting a
queue mechanism to avoid concurrent commits. Making a direct call to the method might lead to concurrency
issues.`;return{c(){t=c("p"),t.textContent=u},l(i){t=l(i,"P",{"data-svelte-h":!0}),d(t)!=="svelte-1oh5a50"&&(t.textContent=u)},m(i,a){$(i,t,a)},p:U,d(i){i&&p(t)}}}function CH(T){let t,u,i,a,g,e,v,ck="아래는 허깅 페이스 Hub의 API를 위한 파이썬 래퍼인 <code>HfApi</code> 클래스에 대한 문서입니다.",qf,kr,lk="<code>HfApi</code>의 모든 메서드는 패키지의 루트에서 직접 접근할 수 있습니다. 두 접근 방식은 아래에서 자세히 설명합니다.",Uf,Tr,pk=`루트 메서드를 사용하는 것이 더 간단하지만 <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> 클래스를 사용하면 더 유연하게 사용할 수 있습니다.
특히 모든 HTTP 호출에서 재사용할 토큰을 전달할 수 있습니다.
이 방식은 토큰이 머신에 유지되지 않기 때문에 <code>hf auth login</code> 또는 <a href="/docs/huggingface_hub/main/ko/package_reference/login#huggingface_hub.login">login()</a>를 사용하는 방식과는 다르며,
다른 엔드포인트를 제공하거나 사용자정의 에이전트를 구성할 수도 있습니다.`,Hf,jr,Cf,Mr,If,w,qr,Hm,cp,dk="Client to interact with the Hugging Face Hub via HTTP.",Cm,lp,gk=`The client is initialized with some high-level settings used in all requests
made to the Hub (HF endpoint, authentication, user agents…). Using the <code>HfApi</code>
client is preferred but not mandatory as all of its public methods are exposed
directly at the root of <code>huggingface_hub</code>.`,Im,Ge,Ur,Jm,pp,uk="Accept an access request from a user for a given gated repo.",Nm,dp,hk=`Once the request is accepted, the user will be able to download any file of the repo and access the community
tab. If the approval mode is automatic, you don’t have to accept requests manually. An accepted request can be
cancelled or rejected at any time using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.cancel_access_request">cancel_access_request()</a> and <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.reject_access_request">reject_access_request()</a>.`,Am,gp,fk='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',Em,Ze,Hr,Dm,up,mk="Add an item to a collection on the Hub.",Rm,hp,_k='Returns: <a href="/docs/huggingface_hub/main/ko/package_reference/collections#huggingface_hub.Collection">Collection</a>',Gm,Zo,Zm,on,Cr,Fm,fp,bk="Adds or updates a secret in a Space.",Sm,mp,yk=`Secrets allow to set secret keys or tokens to a Space without hardcoding them.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets</a>.`,Lm,an,Ir,Wm,_p,vk="Adds or updates a variable in a Space.",Vm,bp,xk=`Variables allow to set environment variables to a Space without hardcoding them.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables</a>`,Bm,G,Jr,Pm,yp,$k="Check if the provided user token has access to a specific repository on the Hugging Face Hub.",Ym,vp,wk=`This method verifies whether the user, authenticated via the provided token, has access to the specified
repository. If the repository is not found or if the user lacks the required permissions to access it,
the method raises an appropriate exception.`,Xm,xp,kk="Example:",Qm,Fo,zm,$p,Tk="In this example:",Om,wp,jk=`<li>If the user has access, the method completes successfully.</li> <li>If the repository is gated or does not exist, appropriate exceptions are raised, allowing the user
to handle them accordingly.</li>`,Km,Fe,Nr,e_,kp,Mk="Cancel an access request from a user for a given gated repo.",t_,Tp,qk="A cancelled request will go back to the pending list and the user will lose access to the repo.",n_,jp,Uk='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',o_,So,Ar,a_,Mp,Hk="Cancel a compute Job on Hugging Face infrastructure.",s_,Se,Er,r_,qp,Ck="Closes or re-opens a Discussion or Pull Request.",i_,Lo,c_,Wo,l_,Le,Dr,p_,Up,Ik="Creates a new comment on the given Discussion.",d_,Vo,g_,Bo,u_,Po,Rr,h_,Hp,Jk=`Create a new branch for a repo on the Hub, starting from the specified revision (defaults to <code>main</code>).
To find a revision suiting your needs, you can use <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_repo_refs">list_repo_refs()</a> or <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_repo_commits">list_repo_commits()</a>.`,f_,We,Gr,m_,Cp,Nk="Create a new Collection on the Hub.",__,Ip,Ak='Returns: <a href="/docs/huggingface_hub/main/ko/package_reference/collections#huggingface_hub.Collection">Collection</a>',b_,Yo,y_,de,Zr,v_,Jp,Ek="Creates a commit in the given repo, deleting & uploading files as needed.",x_,Xo,$_,Qo,w_,zo,k_,L,Fr,T_,Np,Dk="Creates a Discussion or Pull Request.",j_,Ap,Rk="Pull Requests created programmatically will be in <code>&quot;draft&quot;</code> status.",M_,Ep,Gk='Creating a Pull Request with changes can also be done at once with <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_commit">HfApi.create_commit()</a>.',q_,Dp,Zk='Returns: <a href="/docs/huggingface_hub/main/ko/package_reference/community#huggingface_hub.DiscussionWithDetails">DiscussionWithDetails</a>',U_,Oo,H_,ge,Sr,C_,Rp,Fk="Create a new Inference Endpoint.",I_,Ko,J_,ea,N_,ta,A_,Ve,Lr,E_,Gp,Sk="Create a new Inference Endpoint from a model in the Hugging Face Inference Catalog.",D_,Zp,Lk=`The goal of the Inference Catalog is to provide a curated list of models that are optimized for inference
and for which default configurations have been tested. See <a href="https://endpoints.huggingface.co/catalog" rel="nofollow">https://endpoints.huggingface.co/catalog</a> for a list
of available models in the catalog.`,R_,na,G_,W,Wr,Z_,Fp,Wk="Creates a Pull Request . Pull Requests created programmatically will be in <code>&quot;draft&quot;</code> status.",F_,Sp,Vk='Creating a Pull Request with changes can also be done at once with <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_commit">HfApi.create_commit()</a>;',S_,Lp,Bk='This is a wrapper around <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_discussion">HfApi.create_discussion()</a>.',L_,Wp,Pk='Returns: <a href="/docs/huggingface_hub/main/ko/package_reference/community#huggingface_hub.DiscussionWithDetails">DiscussionWithDetails</a>',W_,oa,V_,aa,Vr,B_,Vp,Yk="Create an empty repo on the HuggingFace Hub.",P_,V,Br,Y_,Bp,Xk="Create scheduled compute Jobs on Hugging Face infrastructure.",X_,Pp,Qk="Example:",Q_,sa,z_,ra,O_,ia,K_,B,Pr,eb,Yp,zk="Run a UV script Job on Hugging Face infrastructure.",tb,Xp,Ok="Example:",nb,ca,ob,la,ab,pa,sb,da,Yr,rb,Qp,Kk="Tag a given commit of a repo on the Hub.",ib,sn,Xr,cb,zp,eT="Create a new webhook.",lb,ga,pb,Be,Qr,db,Op,tT="Get info on one specific dataset on huggingface.co.",gb,Kp,nT="Dataset can be private if you pass an acceptable token.",ub,ua,hb,ha,zr,fb,ed,oT="Delete a branch from a repo on the Hub.",mb,Pe,Or,_b,td,aT="Delete a collection on the Hub.",bb,fa,yb,ma,vb,rn,Kr,xb,nd,sT="Delete an item from a collection.",$b,_a,wb,cn,ei,kb,od,rT="Deletes a file in the given repo.",Tb,ba,jb,ln,ti,Mb,ad,iT="Delete files from a repository on the Hub.",qb,sd,cT=`If a folder path is provided, the entire folder is deleted as well as
all files it contained.`,Ub,pn,ni,Hb,rd,lT="Deletes a folder in the given repo.",Cb,id,pT='Simple wrapper around <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a> method.',Ib,Ye,oi,Jb,cd,dT="Delete an Inference Endpoint.",Nb,ld,gT=`This operation is not reversible. If you don’t want to be charged for an Inference Endpoint, it is preferable
to pause it with <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.pause_inference_endpoint">pause_inference_endpoint()</a> or scale it to zero with <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.scale_to_zero_inference_endpoint">scale_to_zero_inference_endpoint()</a>.`,Ab,pd,uT='For convenience, you can also delete an Inference Endpoint using <a href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.delete">InferenceEndpoint.delete()</a>.',Eb,ya,ai,Db,dd,hT="Delete a repo from the HuggingFace Hub. CAUTION: this is irreversible.",Rb,va,si,Gb,gd,fT="Delete a scheduled compute Job on Hugging Face infrastructure.",Zb,dn,ri,Fb,ud,mT="Deletes a secret from a Space.",Sb,hd,_T=`Secrets allow to set secret keys or tokens to a Space without hardcoding them.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets</a>.`,Lb,xa,ii,Wb,fd,bT="Delete persistent storage for a Space.",Vb,gn,ci,Bb,md,yT="Deletes a variable from a Space.",Pb,_d,vT=`Variables allow to set environment variables to a Space without hardcoding them.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables</a>`,Yb,$a,li,Xb,bd,xT="Delete a tag from a repo on the Hub.",Qb,un,pi,zb,yd,$T="Delete a webhook.",Ob,wa,Kb,hn,di,ey,vd,wT="Disable a webhook (makes it “disabled”).",ty,ka,ny,Xe,gi,oy,xd,kT="Duplicate a Space.",ay,$d,TT=`Programmatically duplicate a Space. The new Space will be created in your account and will be in the same state
as the original Space (running or paused). You can duplicate a Space no matter the current state of a Space.`,sy,Ta,ry,fn,ui,iy,wd,jT="Edits a comment on a Discussion / Pull Request.",cy,ja,ly,mn,hi,py,kd,MT="Enable a webhook (makes it “active”).",dy,Ma,gy,_n,fi,uy,Td,qT="Fetch all the logs from a compute Job on Hugging Face infrastructure.",hy,qa,fy,bn,mi,my,jd,UT="Checks if a file exists in a repository on the Hugging Face Hub.",_y,Ua,by,Qe,_i,yy,Md,HT="Gets information about a Collection on the Hub.",vy,qd,CT='Returns: <a href="/docs/huggingface_hub/main/ko/package_reference/collections#huggingface_hub.Collection">Collection</a>',xy,Ha,$y,Ca,bi,wy,Ud,IT="List all valid dataset tags as a nested namespace object.",ky,ze,yi,Ty,Hd,JT="Fetches a Discussion’s / Pull Request ‘s details from the Hub.",jy,Cd,NT='Returns: <a href="/docs/huggingface_hub/main/ko/package_reference/community#huggingface_hub.DiscussionWithDetails">DiscussionWithDetails</a>',My,Ia,qy,Ja,vi,Uy,Id,AT=`Returns the repository name for a given model ID and optional
organization.`,Hy,Na,xi,Cy,Jd,ET="Fetch metadata of a file versioned on the Hub for a given url.",Iy,yn,$i,Jy,Nd,DT="Get information about an Inference Endpoint.",Ny,Aa,Ay,Ea,wi,Ey,Ad,RT="List all valid model tags as a nested namespace object",Dy,vn,ki,Ry,Ed,GT="Get information about a repo’s paths.",Gy,Da,Zy,ue,Ti,Fy,Dd,ZT="Fetches Discussions and Pull Requests for the given repo.",Sy,Rd,FT="Example:",Ly,Ra,Wy,Ga,Vy,P,ji,By,Gd,ST="Parse metadata for a safetensors repo on the Hub.",Py,Zd,LT=`We first check if the repo has a single safetensors file or a sharded safetensors repo. If it’s a single
safetensors file, we parse the metadata from this file. If it’s a sharded safetensors repo, we parse the
metadata from the index file and then parse the metadata from each shard.`,Yy,Fd,WT='To parse metadata from a single safetensors file, use <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.parse_safetensors_file_metadata">parse_safetensors_file_metadata()</a>.',Xy,Sd,VT='For more details regarding the safetensors format, check out <a href="https://huggingface.co/docs/safetensors/index#format" rel="nofollow">https://huggingface.co/docs/safetensors/index#format</a>.',Qy,Za,zy,Fa,Mi,Oy,Ld,BT="Gets runtime information about a Space.",Ky,xn,qi,ev,Wd,PT="Gets all variables from a Space.",tv,Vd,YT=`Variables allow to set environment variables to a Space without hardcoding them.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables</a>`,nv,Oe,Ui,ov,Bd,XT="Check if a given <code>token</code> is valid and return its permissions.",av,Sa,sv,Pd,QT='For more details about tokens, please refer to <a href="https://huggingface.co/docs/hub/security-tokens#what-are-user-access-tokens" rel="nofollow">https://huggingface.co/docs/hub/security-tokens#what-are-user-access-tokens</a>.',rv,La,Hi,iv,Yd,zT="Get an overview of a user on the Hub.",cv,$n,Ci,lv,Xd,OT="Get a webhook by its id.",pv,Wa,dv,Ke,Ii,gv,Qd,KT="Grant access to a user for a given gated repo.",uv,zd,e0=`Granting access don’t require for the user to send an access request by themselves. The user is automatically
added to the accepted list meaning they can download the files You can revoke the granted access at any time
using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.cancel_access_request">cancel_access_request()</a> or <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.reject_access_request">reject_access_request()</a>.`,hv,Od,t0='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',fv,Y,Ji,mv,Kd,n0="Download a given file if it’s not already present in the local cache.",_v,eg,o0="The new cache file layout looks like this:",bv,tg,a0=`<li>The cache directory contains one subfolder per repo_id (namespaced by repo type)</li> <li>inside each repo folder:<ul><li>refs is a list of the latest known revision =&gt; commit_hash pairs</li> <li>blobs contains the actual file blobs (identified by their git-sha or sha256, depending on
whether they’re LFS files or not)</li> <li>snapshots contains one subfolder per commit, each “commit” contains the subset of the files
that have been resolved at that particular commit. Each filename is a symlink to the blob
at that particular commit.</li></ul></li>`,yv,Va,vv,ng,s0=`If <code>local_dir</code> is provided, the file structure from the repo will be replicated in this location. When using this
option, the <code>cache_dir</code> will not be used and a <code>.cache/huggingface/</code> folder will be created at the root of <code>local_dir</code>
to store some metadata related to the downloaded files. While this mechanism is not as robust as the main
cache-system, it’s optimized for regularly pulling the latest version of a repository.`,xv,et,Ni,$v,og,r0="Hides a comment on a Discussion / Pull Request.",wv,Ba,kv,Pa,Tv,wn,Ai,jv,ag,i0="Inspect a compute Job on Hugging Face infrastructure.",Mv,Ya,qv,kn,Ei,Uv,sg,c0="Inspect a scheduled compute Job on Hugging Face infrastructure.",Hv,Xa,Cv,he,Di,Iv,rg,l0="Get accepted access requests for a given gated repo.",Jv,ig,p0=`An accepted request means the user has requested access to the repo and the request has been accepted. The user
can download any file of the repo. If the approval mode is automatic, this list should contains by default all
requests. Accepted requests can be cancelled or rejected at any time using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.cancel_access_request">cancel_access_request()</a> and
<a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.reject_access_request">reject_access_request()</a>. A cancelled request will go back to the pending list while a rejected request will
go to the rejected list. In both cases, the user will lose access to the repo.`,Nv,cg,d0='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',Av,Qa,Ev,Tn,Ri,Dv,lg,g0="List collections on the Huggingface Hub, given some filters.",Rv,za,Gv,tt,Gi,Zv,pg,u0="List datasets hosted on the Huggingface Hub, given some filters.",Fv,Oa,Sv,Ka,Lv,fe,Zi,Wv,dg,h0="List models available in the Hugging Face Inference Catalog.",Vv,gg,f0=`The goal of the Inference Catalog is to provide a curated list of models that are optimized for inference
and for which default configurations have been tested. See <a href="https://endpoints.huggingface.co/catalog" rel="nofollow">https://endpoints.huggingface.co/catalog</a> for a list
of available models in the catalog.`,Bv,ug,m0='Use <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_inference_endpoint_from_catalog">create_inference_endpoint_from_catalog()</a> to deploy a model from the catalog.',Pv,es,Yv,jn,Fi,Xv,hg,_0="Lists all inference endpoints for the given namespace.",Qv,ts,zv,ns,Si,Ov,fg,b0="List compute Jobs on Hugging Face infrastructure.",Kv,nt,Li,ex,mg,y0="List all LFS files in a repo on the Hub.",tx,_g,v0=`This is primarily useful to count how much storage a repo is using and to eventually clean up large files
with <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.permanently_delete_lfs_files">permanently_delete_lfs_files()</a>. Note that this would be a permanent action that will affect all commits
referencing this deleted files and that cannot be undone.`,nx,os,ox,me,Wi,ax,bg,x0="List all public repos liked by a user on huggingface.co.",sx,yg,$0=`This list is public so token is optional. If <code>user</code> is not passed, it defaults to
the logged in user.`,rx,vg,w0='See also <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.unlike">unlike()</a>.',ix,as,cx,Mn,Vi,lx,xg,k0="List models hosted on the Huggingface Hub, given some filters.",px,ss,dx,rs,Bi,gx,$g,T0="List of members of an organization on the Hub.",ux,qn,Pi,hx,wg,j0="List daily papers on the Hugging Face Hub given a search query.",fx,is,mx,_e,Yi,_x,kg,M0="Get pending access requests for a given gated repo.",bx,Tg,q0=`A pending request means the user has requested access to the repo but the request has not been processed yet.
If the approval mode is automatic, this list should be empty. Pending requests can be accepted or rejected
using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.accept_access_request">accept_access_request()</a> and <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.reject_access_request">reject_access_request()</a>.`,yx,jg,U0='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',vx,cs,xx,be,Xi,$x,Mg,H0="Get rejected access requests for a given gated repo.",wx,qg,C0=`A rejected request means the user has requested access to the repo and the request has been explicitly rejected
by a repo owner (either you or another user from your organization). The user cannot download any file of the
repo. Rejected requests can be accepted or cancelled at any time using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.accept_access_request">accept_access_request()</a> and
<a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.cancel_access_request">cancel_access_request()</a>. A cancelled request will go back to the pending list while an accepted request will
go to the accepted list.`,kx,Ug,I0='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',Tx,ls,jx,ot,Qi,Mx,Hg,J0="Get the list of commits of a given revision for a repo on the Hub.",qx,Cg,N0="Commits are sorted by date (last commit first).",Ux,ps,Hx,ds,zi,Cx,Ig,A0="Get the list of files in a given repo.",Ix,Un,Oi,Jx,Jg,E0="List all users who liked a given repo on the hugging Face Hub.",Nx,Ng,D0='See also <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_liked_repos">list_liked_repos()</a>.',Ax,Hn,Ki,Ex,Ag,R0="Get the list of refs of a given repo (both tags and branches).",Dx,gs,Rx,Z,ec,Gx,Eg,G0="List a repo tree’s files and folders and get information about them.",Zx,Dg,Z0="Examples:",Fx,Rg,F0="Get information about a repo’s tree.",Sx,us,Lx,Gg,S0="Get even more information about a repo’s tree (last commit and files’ security scan results)",Wx,hs,Vx,fs,tc,Bx,Zg,L0="List scheduled compute Jobs on Hugging Face infrastructure.",Px,ms,nc,Yx,Fg,W0="List spaces hosted on the Huggingface Hub, given some filters.",Xx,_s,oc,Qx,Sg,V0="Get the list of followers of a user on the Hub.",zx,bs,ac,Ox,Lg,B0="Get the list of users followed by a user on the Hub.",Kx,Cn,sc,e$,Wg,P0="List all configured webhooks.",t$,ys,n$,In,rc,o$,Vg,Y0="Merges a Pull Request.",a$,vs,s$,at,ic,r$,Bg,X0="Get info on one specific model on huggingface.co",i$,Pg,Q0="Model can be private if you pass an acceptable token or are logged in.",c$,xs,l$,st,cc,p$,Yg,z0="Moving a repository from namespace1/repo_name1 to namespace2/repo_name2",d$,Xg,O0=`Note there are certain limitations. For more information about moving
repositories, please see
<a href="https://hf.co/docs/hub/repositories-settings#renaming-or-transferring-a-repo" rel="nofollow">https://hf.co/docs/hub/repositories-settings#renaming-or-transferring-a-repo</a>.`,g$,$s,u$,ws,lc,h$,Qg,K0="Get information for a paper on the Hub.",f$,rt,pc,m$,zg,ej="Parse metadata from a safetensors file on the Hub.",_$,Og,tj='To parse metadata from all safetensors files in a repo at once, use <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.get_safetensors_metadata">get_safetensors_metadata()</a>.',b$,Kg,nj='For more details regarding the safetensors format, check out <a href="https://huggingface.co/docs/safetensors/index#format" rel="nofollow">https://huggingface.co/docs/safetensors/index#format</a>.',y$,it,dc,v$,eu,oj="Pause an Inference Endpoint.",x$,tu,aj=`A paused Inference Endpoint will not be charged. It can be resumed at any time using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.resume_inference_endpoint">resume_inference_endpoint()</a>.
This is different than scaling the Inference Endpoint to zero with <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.scale_to_zero_inference_endpoint">scale_to_zero_inference_endpoint()</a>, which
would be automatically restarted when a request is made to it.`,$$,nu,sj='For convenience, you can also pause an Inference Endpoint using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.pause_inference_endpoint">pause_inference_endpoint()</a>.',w$,ct,gc,k$,ou,rj="Pause your Space.",T$,au,ij=`A paused Space stops executing until manually restarted by its owner. This is different from the sleeping
state in which free Spaces go after 48h of inactivity. Paused time is not billed to your account, no matter the
hardware you’ve selected. To restart your Space, use <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.restart_space">restart_space()</a> and go to your Space settings page.`,j$,su,cj='For more details, please visit <a href="https://huggingface.co/docs/hub/spaces-gpus#pause" rel="nofollow">the docs</a>.',M$,lt,uc,q$,ru,lj="Permanently delete LFS files from a repo on the Hub.",U$,ks,H$,Ts,C$,X,hc,I$,iu,pj="Pre-upload LFS files to S3 in preparation on a future commit.",J$,cu,dj=`This method is useful if you are generating the files to upload on-the-fly and you don’t want to store them
in memory before uploading them all at once.`,N$,js,A$,Ms,E$,qs,D$,pt,fc,R$,lu,gj="Reject an access request from a user for a given gated repo.",G$,pu,uj=`A rejected request will go to the rejected list. The user cannot download any file of the repo. Rejected
requests can be accepted or cancelled at any time using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.accept_access_request">accept_access_request()</a> and <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.cancel_access_request">cancel_access_request()</a>.
A cancelled request will go back to the pending list while an accepted request will go to the accepted list.`,Z$,du,hj='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',F$,dt,mc,S$,gu,fj="Renames a Discussion.",L$,Us,W$,Hs,V$,Jn,_c,B$,uu,mj="Checks if a repository exists on the Hugging Face Hub.",P$,Cs,Y$,Nn,bc,X$,hu,_j="Get the info object for a given repo of a given type.",Q$,Is,z$,An,yc,O$,fu,bj="Request new hardware for a Space.",K$,Js,e2,En,vc,t2,mu,yj="Request persistent storage for a Space.",n2,Ns,o2,gt,xc,a2,_u,vj="Restart your Space.",s2,bu,xj=`This is the only way to programmatically restart a Space if you’ve put it on Pause (see <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.pause_space">pause_space()</a>). You
must be the owner of the Space to restart it. If you are using an upgraded hardware, your account will be
billed as soon as the Space is restarted. You can trigger a restart no matter the current state of a Space.`,r2,yu,$j='For more details, please visit <a href="https://huggingface.co/docs/hub/spaces-gpus#pause" rel="nofollow">the docs</a>.',i2,Dn,$c,c2,vu,wj="Resume an Inference Endpoint.",l2,xu,kj='For convenience, you can also resume an Inference Endpoint using <a href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.resume">InferenceEndpoint.resume()</a>.',p2,As,wc,d2,$u,Tj="Resume (unpause) a scheduled compute Job on Hugging Face infrastructure.",g2,Rn,kc,u2,wu,jj="Checks if a specific revision exists on a repo on the Hugging Face Hub.",h2,Es,f2,ye,Tc,m2,ku,Mj="Run a method in the background and return a Future instance.",_2,Tu,qj=`The main goal is to run methods without blocking the main thread (e.g. to push data during a training).
Background jobs are queued to preserve order but are not ran in parallel. If you need to speed-up your scripts
by parallelizing lots of call to the API, you must setup and use your own <a href="https://docs.python.org/3/library/concurrent.futures.html#threadpoolexecutor" rel="nofollow">ThreadPoolExecutor</a>.`,b2,ju,Uj=`Note: Most-used methods like <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a>, <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> and <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a> have a <code>run_as_future: bool</code>
argument to directly call them in the background. This is equivalent to calling <code>api.run_as_future(...)</code> on them
but less verbose.`,y2,Ds,v2,ve,jc,x2,Mu,Hj="Run compute Jobs on Hugging Face infrastructure.",$2,qu,Cj="Example:",w2,Rs,k2,Gs,T2,Q,Mc,j2,Uu,Ij="Run a UV script Job on Hugging Face infrastructure.",M2,Hu,Jj="Example:",q2,Zs,U2,Fs,H2,Ss,C2,ut,qc,I2,Cu,Nj="Scale Inference Endpoint to zero.",J2,Iu,Aj=`An Inference Endpoint scaled to zero will not be charged. It will be resume on the next request to it, with a
cold start delay. This is different than pausing the Inference Endpoint with <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.pause_inference_endpoint">pause_inference_endpoint()</a>, which
would require a manual resume with <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.resume_inference_endpoint">resume_inference_endpoint()</a>.`,N2,Ju,Ej='For convenience, you can also scale an Inference Endpoint to zero using <a href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.scale_to_zero">InferenceEndpoint.scale_to_zero()</a>.',A2,ht,Uc,E2,Nu,Dj="Set a custom sleep time for a Space running on upgraded hardware..",D2,Au,Rj=`Your Space will go to sleep after X seconds of inactivity. You are not billed when your Space is in “sleep”
mode. If a new visitor lands on your Space, it will “wake it up”. Only upgraded hardware can have a
configurable sleep time. To know more about the sleep stage, please refer to
<a href="https://huggingface.co/docs/hub/spaces-gpus#sleep-time" rel="nofollow">https://huggingface.co/docs/hub/spaces-gpus#sleep-time</a>.`,R2,Ls,G2,xe,Hc,Z2,Eu,Gj="Download repo files.",F2,Du,Zj=`Download a whole snapshot of a repo’s files at the specified revision. This is useful when you want all files from
a repo, because you don’t know which ones you will need a priori. All files are nested inside a folder in order
to keep their actual filename relative to that folder. You can also filter which files to download using
<code>allow_patterns</code> and <code>ignore_patterns</code>.`,S2,Ru,Fj=`If <code>local_dir</code> is provided, the file structure from the repo will be replicated in this location. When using this
option, the <code>cache_dir</code> will not be used and a <code>.cache/huggingface/</code> folder will be created at the root of <code>local_dir</code>
to store some metadata related to the downloaded files.While this mechanism is not as robust as the main
cache-system, it’s optimized for regularly pulling the latest version of a repository.`,L2,Gu,Sj=`An alternative would be to clone the repo but this requires git and git-lfs to be installed and properly
configured. It is also not possible to filter which files to download when cloning a repository using git.`,W2,ft,Cc,V2,Zu,Lj="Get info on one specific Space on huggingface.co.",B2,Fu,Wj="Space can be private if you pass an acceptable token.",P2,Ws,Y2,z,Ic,X2,Su,Vj="Squash commit history on a branch for a repo on the Hub.",Q2,Lu,Bj=`Squashing the repo history is useful when you know you’ll make hundreds of commits and you don’t want to
clutter the history. Squashing commits can only be performed from the head of a branch.`,z2,Vs,O2,Bs,K2,Ps,e1,Ys,Jc,t1,Wu,Pj="Suspend (pause) a scheduled compute Job on Hugging Face infrastructure.",n1,$e,Nc,o1,Vu,Yj="Unlike a given repo on the Hub (e.g. remove from favorite list).",a1,Bu,Xj="To prevent spam usage, it is not possible to <code>like</code> a repository from a script.",s1,Pu,Qj='See also <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_liked_repos">list_liked_repos()</a>.',r1,Xs,i1,Gn,Ac,c1,Yu,zj="Update an item in a collection.",l1,Qs,p1,we,Ec,d1,Xu,Oj="Update metadata of a collection on the Hub.",g1,Qu,Kj="All arguments are optional. Only provided metadata will be updated.",u1,zu,eM='Returns: <a href="/docs/huggingface_hub/main/ko/package_reference/collections#huggingface_hub.Collection">Collection</a>',h1,zs,f1,mt,Dc,m1,Ou,tM="Update an Inference Endpoint.",_1,Ku,nM=`This method allows the update of either the compute configuration, the deployed model, the route, or any combination.
All arguments are optional but at least one must be provided.`,b1,eh,oM='For convenience, you can also update an Inference Endpoint using <a href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.update">InferenceEndpoint.update()</a>.',y1,Zn,Rc,v1,th,aM="Update the settings of a repository, including gated access and visibility.",x1,nh,sM=`To give more control over how repos are used, the Hub allows repo authors to enable
access requests for their repos, and also to set the visibility of the repo to private.`,$1,_t,Gc,w1,oh,rM="Update the visibility setting of a repository.",k1,ah,iM="Deprecated. Use <code>update_repo_settings</code> instead.",T1,Os,j1,Fn,Zc,M1,sh,cM="Update an existing webhook.",q1,Ks,U1,ke,Fc,H1,rh,lM=`Upload a local file (up to 50 GB) to the given repo. The upload is done
through a HTTP post request, and doesn’t require git or git-lfs to be
installed.`,C1,er,I1,tr,J1,nr,N1,N,Sc,A1,ih,pM=`Upload a local folder to the given repo. The upload is done through a HTTP requests, and doesn’t require git or
git-lfs to be installed.`,E1,ch,dM=`The structure of the folder will be preserved. Files with the same name already present in the repository will
be overwritten. Others will be left untouched.`,D1,lh,gM=`Use the <code>allow_patterns</code> and <code>ignore_patterns</code> arguments to specify which files to upload. These parameters
accept either a single pattern or a list of patterns. Patterns are Standard Wildcards (globbing patterns) as
documented <a href="https://tldp.org/LDP/GNU-Linux-Tools-Summary/html/x11655.htm" rel="nofollow">here</a>. If both <code>allow_patterns</code> and
<code>ignore_patterns</code> are provided, both constraints apply. By default, all files from the folder are uploaded.`,R1,ph,uM=`Use the <code>delete_patterns</code> argument to specify remote files you want to delete. Input type is the same as for
<code>allow_patterns</code> (see above). If <code>path_in_repo</code> is also provided, the patterns are matched against paths
relative to this folder. For example, <code>upload_folder(..., path_in_repo=&quot;experiment&quot;, delete_patterns=&quot;logs/*&quot;)</code>
will delete any remote file under <code>./experiment/logs/</code>. Note that the <code>.gitattributes</code> file will not be deleted
even if it matches the patterns.`,G1,dh,hM=`Any <code>.git/</code> folder present in any subdirectory will be ignored. However, please be aware that the <code>.gitignore</code>
file is not taken into account.`,Z1,gh,fM="Uses <code>HfApi.create_commit</code> under the hood.",F1,or,S1,ar,L1,sr,W1,rr,V1,J,Lc,B1,uh,mM="Upload a large folder to the Hub in the most resilient way possible.",P1,hh,_M=`Several workers are started to upload files in an optimized way. Before being committed to a repo, files must be
hashed and be pre-uploaded if they are LFS files. Workers will perform these tasks for each file in the folder.
At each step, some metadata information about the upload process is saved in the folder under <code>.cache/.huggingface/</code>
to be able to resume the process if interrupted. The whole process might result in several commits.`,Y1,ir,X1,cr,Q1,fh,bM="<strong>Technical details:</strong>",z1,mh,yM="<code>upload_large_folder</code> process is as follow:",O1,_h,vM=`<li>(Check parameters and setup.)</li> <li>Create repo if missing.</li> <li>List local files to upload.</li> <li>Run validation checks and display warnings if repository limits might be exceeded:<ul><li>Warns if the total number of files exceeds 100k (recommended limit).</li> <li>Warns if any folder contains more than 10k files (recommended limit).</li> <li>Warns about files larger than 20GB (recommended) or 50GB (hard limit).</li></ul></li> <li>Start workers. Workers can perform the following tasks:<ul><li>Hash a file.</li> <li>Get upload mode (regular or LFS) for a list of files.</li> <li>Pre-upload an LFS file.</li> <li>Commit a bunch of files.
Once a worker finishes a task, it will move on to the next task based on the priority list (see below) until
all files are uploaded and committed.</li></ul></li> <li>While workers are up, regularly print a report to sys.stdout.</li>`,K1,bh,xM="Order of priority:",ew,yh,$M="<li>Commit if more than 5 minutes since last commit attempt (and at least 1 file).</li> <li>Commit if at least 150 files are ready to commit.</li> <li>Get upload mode if at least 10 files have been hashed.</li> <li>Pre-upload LFS file if at least 1 file and no worker is pre-uploading.</li> <li>Hash file if at least 1 file and no worker is hashing.</li> <li>Get upload mode if at least 1 file and no worker is getting upload mode.</li> <li>Pre-upload LFS file if at least 1 file (exception: if hf_transfer is enabled, only 1 worker can preupload LFS at a time).</li> <li>Hash file if at least 1 file to hash.</li> <li>Get upload mode if at least 1 file to get upload mode.</li> <li>Commit if at least 1 file to commit and at least 1 min since last commit attempt.</li> <li>Commit if at least 1 file to commit and all other queues are empty.</li>",tw,vh,wM="Special rules:",nw,xh,kM="<li>If <code>hf_transfer</code> is enabled, only 1 LFS uploader at a time. Otherwise the CPU would be bloated by <code>hf_transfer</code>.</li> <li>Only one worker can commit at a time.</li> <li>If no tasks are available, the worker waits for 10 seconds before checking again.</li>",ow,lr,Wc,aw,$h,TM="Call HF API to know “whoami”.",Jf,Vc,Nf,Bc,Af,zn,Pc,sw,wh,jM="Data structure containing information about a user access request.",Ef,Yc,Df,yt,Xc,rw,kh,MM="Data structure containing information about a newly created commit.",iw,Th,qM=`Returned by any method that creates a commit on the Hub: <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a>, <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a>, <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a>,
<a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.delete_file">delete_file()</a>, <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.delete_folder">delete_folder()</a>. It inherits from <code>str</code> for backward compatibility but using methods specific
to <code>str</code> is deprecated.`,Rf,Qc,Gf,vt,zc,cw,jh,UM='Contains information about a dataset on the Hub. This object is returned by <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.dataset_info">dataset_info()</a> and <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_datasets">list_datasets()</a>.',lw,pr,Zf,Oc,Ff,On,Kc,pw,Mh,HM="Contains information about a git reference for a repo on the Hub.",Sf,el,Lf,Kn,tl,dw,qh,CM='Contains information about a git commit for a repo on the Hub. Check out <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_repo_commits">list_repo_commits()</a> for more details.',Wf,nl,Vf,xt,ol,gw,Uh,IM="Contains information about all git references for a repo on the Hub.",uw,Hh,JM='Object is returned by <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_repo_refs">list_repo_refs()</a>.',Bf,al,Pf,$t,sl,hw,Ch,NM='Contains information about a model on the Hub. This object is returned by <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.model_info">model_info()</a> and <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_models">list_models()</a>.',fw,dr,Yf,rl,Xf,wt,il,mw,Ih,AM="Contains basic information about a repo file inside a repo on the Hub.",_w,gr,Qf,cl,zf,eo,ll,bw,Jh,EM="Contains information about a file on the Hub.",Of,pl,Kf,K,dl,yw,Nh,DM="Subclass of <code>str</code> describing a repo URL on the Hub.",vw,Ah,RM=`<code>RepoUrl</code> is returned by <code>HfApi.create_repo</code>. It inherits from <code>str</code> for backward
compatibility. At initialization, the URL is parsed to populate properties:`,xw,Eh,GM="<li>endpoint (<code>str</code>)</li> <li>namespace (<code>Optional[str]</code>)</li> <li>repo_name (<code>str</code>)</li> <li>repo_id (<code>str</code>)</li> <li>repo_type (<code>Literal[&quot;model&quot;, &quot;dataset&quot;, &quot;space&quot;]</code>)</li> <li>url (<code>str</code>)</li>",$w,ur,em,gl,tm,ee,ul,ww,Dh,ZM="Metadata for a Safetensors repo.",kw,Rh,FM=`A repo is considered to be a Safetensors repo if it contains either a ‘model.safetensors’ weight file (non-shared
model) or a ‘model.safetensors.index.json’ index file (sharded model) at its root.`,Tw,Gh,SM='This class is returned by <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.get_safetensors_metadata">get_safetensors_metadata()</a>.',jw,Zh,LM='For more details regarding the safetensors format, check out <a href="https://huggingface.co/docs/safetensors/index#format" rel="nofollow">https://huggingface.co/docs/safetensors/index#format</a>.',nm,hl,om,Te,fl,Mw,Fh,WM="Metadata for a Safetensors file hosted on the Hub.",qw,Sh,VM='This class is returned by <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.parse_safetensors_file_metadata">parse_safetensors_file_metadata()</a>.',Uw,Lh,BM='For more details regarding the safetensors format, check out <a href="https://huggingface.co/docs/safetensors/index#format" rel="nofollow">https://huggingface.co/docs/safetensors/index#format</a>.',am,ml,sm,kt,_l,Hw,Wh,PM='Contains information about a Space on the Hub. This object is returned by <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.space_info">space_info()</a> and <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_spaces">list_spaces()</a>.',Cw,hr,rm,bl,im,Tt,yl,Iw,Vh,YM="Information about a tensor.",Jw,Bh,XM='For more details regarding the safetensors format, check out <a href="https://huggingface.co/docs/safetensors/index#format" rel="nofollow">https://huggingface.co/docs/safetensors/index#format</a>.',cm,vl,lm,to,xl,Nw,Ph,QM="Contains information about a user on the Hub.",pm,$l,dm,no,wl,Aw,Yh,zM="Contains information about a user likes on the Hub.",gm,kl,um,Tl,OM="<code>CommitOperation()</code>에 지원되는 값은 다음과 같습니다:",hm,je,jl,Ew,Xh,KM="Data structure holding necessary info to upload a file to a repository on the Hub.",Dw,Sn,Ml,Rw,Qh,eq=`A context manager that yields a file-like object allowing to read the underlying
data behind <code>path_or_fileobj</code>.`,Gw,fr,Zw,Ln,ql,Fw,zh,tq="The base64-encoded content of <code>path_or_fileobj</code>",Sw,Oh,nq="Returns: <code>bytes</code>",fm,oo,Ul,Lw,Kh,oq=`Data structure holding necessary info to delete a file or a folder from a repository
on the Hub.`,mm,te,Hl,Ww,ef,aq="Data structure holding necessary info to copy a file in a repository on the Hub.",Vw,tf,sq="Limitations:",Bw,nf,rq="<li>Only LFS files can be copied. To copy a regular file, you need to download it locally and re-upload it</li> <li>Cross-repository copies are not supported.</li>",Pw,of,iq='Note: you can combine a <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitOperationCopy">CommitOperationCopy</a> and a <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitOperationDelete">CommitOperationDelete</a> to rename an LFS file on the Hub.',_m,Cl,bm,D,Il,Yw,af,cq="Scheduler to upload a local folder to the Hub at regular intervals (e.g. push to hub every 5 minutes).",Xw,sf,lq=`The recommended way to use the scheduler is to use it as a context manager. This ensures that the scheduler is
properly stopped and the last commit is triggered when the script ends. The scheduler can also be stopped manually
with the <code>stop</code> method. Checkout the <a href="https://huggingface.co/docs/huggingface_hub/guides/upload#scheduled-uploads" rel="nofollow">upload guide</a>
to learn more about how to use it.`,Qw,mr,zw,_r,Ow,bt,Jl,Kw,rf,pq="Push folder to the Hub and return the commit info.",ek,br,tk,cf,dq=`The default behavior of <code>push_to_hub</code> is to assume an append-only folder. It lists all files in the folder and
uploads only changed files. If no changes are found, the method returns without committing anything. If you want
to change this behavior, you can inherit from <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitScheduler">CommitScheduler</a> and override this method. This can be useful
for example to compress data together in a single file before committing. For more details and examples, check
out our <a href="https://huggingface.co/docs/huggingface_hub/main/en/guides/upload#scheduled-uploads" rel="nofollow">integration guide</a>.`,nk,Wn,Nl,ok,lf,gq="Stop the scheduler.",ak,pf,uq="A stopped scheduler cannot be restarted. Mostly for tests purposes.",sk,Vn,Al,rk,df,hq="Trigger a <code>push_to_hub</code> and return a future.",ik,gf,fq=`This method is automatically called every <code>every</code> minutes. You can also call it manually to trigger a commit
immediately, without waiting for the next scheduled commit.`,ym,El,vm,Mf,xm;return g=new R({props:{title:"HfApi Client",local:"hfapi-client",headingTag:"h1"}}),jr=new H({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTJDJTIwbGlzdF9tb2RlbHMlMEElMEElMjMlMjAlRUIlQTMlQTglRUQlOEElQjglMjAlRUIlQTklOTQlRUMlODQlOUMlRUIlOTMlOUMlRUIlQTUlQkMlMjAlRUMlODIlQUMlRUMlOUElQTklRUQlOTUlOTglRUMlODQlQjglRUMlOUElOTQuJTBBbW9kZWxzJTIwJTNEJTIwbGlzdF9tb2RlbHMoKSUwQSUwQSUyMyUyMCVFQiU5OCU5MCVFQiU4QSU5NCUyMEhmQXBpJTIwY2xpZW50JUVCJUE1JUJDJTIwJUVBJUI1JUFDJUVDJTg0JUIxJUVEJTk1JTk4JUVDJTg0JUI4JUVDJTlBJTk0LiUwQWhmX2FwaSUyMCUzRCUyMEhmQXBpKCUwQSUyMCUyMCUyMCUyMGVuZHBvaW50JTNEJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyMiUyQyUyMCUyMyUyMCVFQiVCOSU4NCVFQSVCMyVCNSVFQSVCMCU5QyUyMEh1YiUyMCVFQyU5NyU5NCVFQiU5MyU5QyVFRCU4RiVBQyVFQyU5RCVCOCVFRCU4QSVCOCVFQiVBNSVCQyUyMCVFQyVBNyU4MCVFQyVBMCU5NSVFRCU5NSVBMCUyMCVFQyU4OCU5OCUyMCVFQyU5RSU4OCVFQyU4QSVCNSVFQiU4QiU4OCVFQiU4QiVBNC4lMEElMjAlMjAlMjAlMjB0b2tlbiUzRCUyMmhmX3h4eCUyMiUyQyUyMCUyMyUyMCVFRCU4NiVBMCVFRCU4MSVCMCVFQyU5RCU4MCUyMCVFQiVBOCVCOCVFQyU4QiVBMCVFQyU5NyU5MCUyMCVFQyU5QyVBMCVFQyVBNyU4MCVFQiU5MCU5OCVFQyVBNyU4MCUyMCVFQyU5NSU4QSVFQyU4QSVCNSVFQiU4QiU4OCVFQiU4QiVBNC4lMEEpJTBBbW9kZWxzJTIwJTNEJTIwaGZfYXBpLmxpc3RfbW9kZWxzKCk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi, list_models

<span class="hljs-comment"># 루트 메서드를 사용하세요.</span>
models = list_models()

<span class="hljs-comment"># 또는 HfApi client를 구성하세요.</span>
hf_api = HfApi(
    endpoint=<span class="hljs-string">&quot;https://huggingface.co&quot;</span>, <span class="hljs-comment"># 비공개 Hub 엔드포인트를 지정할 수 있습니다.</span>
    token=<span class="hljs-string">&quot;hf_xxx&quot;</span>, <span class="hljs-comment"># 토큰은 머신에 유지되지 않습니다.</span>
)
models = hf_api.list_models()`,wrap:!1}}),Mr=new R({props:{title:"HfApi",local:"huggingface_hub.HfApi ][ huggingface_hub.HfApi",headingTag:"h2"}}),qr=new q({props:{name:"class huggingface_hub.HfApi",anchor:"huggingface_hub.HfApi",parameters:[{name:"endpoint",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"},{name:"library_name",val:": Optional[str] = None"},{name:"library_version",val:": Optional[str] = None"},{name:"user_agent",val:": Union[Dict, str, None] = None"},{name:"headers",val:": Optional[Dict[str, str]] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.endpoint",description:`<strong>endpoint</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Endpoint of the Hub. Defaults to <a href="https://huggingface.co" rel="nofollow">https://huggingface.co</a>.`,name:"endpoint"},{anchor:"huggingface_hub.HfApi.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.library_name",description:`<strong>library_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The name of the library that is making the HTTP request. Will be added to
the user-agent header. Example: <code>&quot;transformers&quot;</code>.`,name:"library_name"},{anchor:"huggingface_hub.HfApi.library_version",description:`<strong>library_version</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The version of the library that is making the HTTP request. Will be added
to the user-agent header. Example: <code>&quot;4.24.0&quot;</code>.`,name:"library_version"},{anchor:"huggingface_hub.HfApi.user_agent",description:`<strong>user_agent</strong> (<code>str</code>, <code>dict</code>, <em>optional</em>) &#x2014;
The user agent info in the form of a dictionary or a single string. It will
be completed with information about the installed packages.`,name:"user_agent"},{anchor:"huggingface_hub.HfApi.headers",description:`<strong>headers</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional headers to be sent with each request. Example: <code>{&quot;X-My-Header&quot;: &quot;value&quot;}</code>.
Headers passed here are taking precedence over the default headers.`,name:"headers"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1675"}}),Ur=new q({props:{name:"accept_access_request",anchor:"huggingface_hub.HfApi.accept_access_request",parameters:[{name:"repo_id",val:": str"},{name:"user",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.accept_access_request.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to accept access request for.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.accept_access_request.user",description:`<strong>user</strong> (<code>str</code>) &#x2014;
The username of the user which access request should be accepted.`,name:"user"},{anchor:"huggingface_hub.HfApi.accept_access_request.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to accept access request for. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.accept_access_request.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8995",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user does not exist on the Hub.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user access request cannot be found.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user access request is already in the accepted list.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Hr=new q({props:{name:"add_collection_item",anchor:"huggingface_hub.HfApi.add_collection_item",parameters:[{name:"collection_slug",val:": str"},{name:"item_id",val:": str"},{name:"item_type",val:": CollectionItemType_T"},{name:"note",val:": Optional[str] = None"},{name:"exists_ok",val:": bool = False"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.add_collection_item.collection_slug",description:`<strong>collection_slug</strong> (<code>str</code>) &#x2014;
Slug of the collection to update. Example: <code>&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</code>.`,name:"collection_slug"},{anchor:"huggingface_hub.HfApi.add_collection_item.item_id",description:`<strong>item_id</strong> (<code>str</code>) &#x2014;
ID of the item to add to the collection. It can be the ID of a repo on the Hub (e.g. <code>&quot;facebook/bart-large-mnli&quot;</code>)
or a paper id (e.g. <code>&quot;2307.09288&quot;</code>).`,name:"item_id"},{anchor:"huggingface_hub.HfApi.add_collection_item.item_type",description:`<strong>item_type</strong> (<code>str</code>) &#x2014;
Type of the item to add. Can be one of <code>&quot;model&quot;</code>, <code>&quot;dataset&quot;</code>, <code>&quot;space&quot;</code> or <code>&quot;paper&quot;</code>.`,name:"item_type"},{anchor:"huggingface_hub.HfApi.add_collection_item.note",description:`<strong>note</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A note to attach to the item in the collection. The maximum size for a note is 500 characters.`,name:"note"},{anchor:"huggingface_hub.HfApi.add_collection_item.exists_ok",description:`<strong>exists_ok</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, do not raise an error if item already exists.`,name:"exists_ok"},{anchor:"huggingface_hub.HfApi.add_collection_item.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8547",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the item you try to add to the collection does not exist on the Hub.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 409 if the item you try to add to the collection is already in the collection (and exists_ok=False)</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Zo=new C({props:{anchor:"huggingface_hub.HfApi.add_collection_item.example",$$slots:{default:[kq]},$$scope:{ctx:T}}}),Cr=new q({props:{name:"add_space_secret",anchor:"huggingface_hub.HfApi.add_space_secret",parameters:[{name:"repo_id",val:": str"},{name:"key",val:": str"},{name:"value",val:": str"},{name:"description",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.add_space_secret.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.add_space_secret.key",description:`<strong>key</strong> (<code>str</code>) &#x2014;
Secret key. Example: <code>&quot;GITHUB_API_KEY&quot;</code>`,name:"key"},{anchor:"huggingface_hub.HfApi.add_space_secret.value",description:`<strong>value</strong> (<code>str</code>) &#x2014;
Secret value. Example: <code>&quot;your_github_api_key&quot;</code>.`,name:"value"},{anchor:"huggingface_hub.HfApi.add_space_secret.description",description:`<strong>description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Secret description. Example: <code>&quot;Github API key to access the Github API&quot;</code>.`,name:"description"},{anchor:"huggingface_hub.HfApi.add_space_secret.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6996"}}),Ir=new q({props:{name:"add_space_variable",anchor:"huggingface_hub.HfApi.add_space_variable",parameters:[{name:"repo_id",val:": str"},{name:"key",val:": str"},{name:"value",val:": str"},{name:"description",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.add_space_variable.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.add_space_variable.key",description:`<strong>key</strong> (<code>str</code>) &#x2014;
Variable key. Example: <code>&quot;MODEL_REPO_ID&quot;</code>`,name:"key"},{anchor:"huggingface_hub.HfApi.add_space_variable.value",description:`<strong>value</strong> (<code>str</code>) &#x2014;
Variable value. Example: <code>&quot;the_model_repo_id&quot;</code>.`,name:"value"},{anchor:"huggingface_hub.HfApi.add_space_variable.description",description:`<strong>description</strong> (<code>str</code>) &#x2014;
Description of the variable. Example: <code>&quot;Model Repo ID of the implemented model&quot;</code>.`,name:"description"},{anchor:"huggingface_hub.HfApi.add_space_variable.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7084"}}),Jr=new q({props:{name:"auth_check",anchor:"huggingface_hub.HfApi.auth_check",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.auth_check.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository to check for access. Format should be <code>&quot;user/repo_name&quot;</code>.
Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.auth_check.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repository. Should be one of <code>&quot;model&quot;</code>, <code>&quot;dataset&quot;</code>, or <code>&quot;space&quot;</code>.
If not specified, the default is <code>&quot;model&quot;</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.auth_check.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9903",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>
<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
Raised if the repository does not exist, is private, or the user does not have access. This can
occur if the <code>repo_id</code> or <code>repo_type</code> is incorrect or if the repository is private but the user
is not authenticated.</p>
</li>
<li>
<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.GatedRepoError"
>GatedRepoError</a> —
Raised if the repository exists but is gated and the user is not authorized to access it.</p>
</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.GatedRepoError"
>GatedRepoError</a></p>
`}}),Fo=new C({props:{anchor:"huggingface_hub.HfApi.auth_check.example",$$slots:{default:[Tq]},$$scope:{ctx:T}}}),Nr=new q({props:{name:"cancel_access_request",anchor:"huggingface_hub.HfApi.cancel_access_request",parameters:[{name:"repo_id",val:": str"},{name:"user",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.cancel_access_request.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to cancel access request for.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.cancel_access_request.user",description:`<strong>user</strong> (<code>str</code>) &#x2014;
The username of the user which access request should be cancelled.`,name:"user"},{anchor:"huggingface_hub.HfApi.cancel_access_request.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to cancel access request for. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.cancel_access_request.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8955",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user does not exist on the Hub.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user access request cannot be found.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user access request is already in the pending list.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Ar=new q({props:{name:"cancel_job",anchor:"huggingface_hub.HfApi.cancel_job",parameters:[{name:"job_id",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.cancel_job.job_id",description:`<strong>job_id</strong> (<code>str</code>) &#x2014;
ID of the Job.`,name:"job_id"},{anchor:"huggingface_hub.HfApi.cancel_job.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Job is running. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.cancel_job.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L10225"}}),Er=new q({props:{name:"change_discussion_status",anchor:"huggingface_hub.HfApi.change_discussion_status",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"new_status",val:": Literal['open', 'closed']"},{name:"token",val:": Union[bool, str, None] = None"},{name:"comment",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.change_discussion_status.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.change_discussion_status.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.change_discussion_status.new_status",description:`<strong>new_status</strong> (<code>str</code>) &#x2014;
The new status for the discussion, either <code>&quot;open&quot;</code> or <code>&quot;closed&quot;</code>.`,name:"new_status"},{anchor:"huggingface_hub.HfApi.change_discussion_status.comment",description:`<strong>comment</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional comment to post with the status change.`,name:"comment"},{anchor:"huggingface_hub.HfApi.change_discussion_status.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.change_discussion_status.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6738",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the status change event</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/community#huggingface_hub.DiscussionStatusChange"
>DiscussionStatusChange</a></p>
`}}),Lo=new C({props:{anchor:"huggingface_hub.HfApi.change_discussion_status.example",$$slots:{default:[jq]},$$scope:{ctx:T}}}),Wo=new I({props:{$$slots:{default:[Mq]},$$scope:{ctx:T}}}),Dr=new q({props:{name:"comment_discussion",anchor:"huggingface_hub.HfApi.comment_discussion",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"comment",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.comment_discussion.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.comment_discussion.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.comment_discussion.comment",description:`<strong>comment</strong> (<code>str</code>) &#x2014;
The content of the comment to create. Comments support markdown formatting.`,name:"comment"},{anchor:"huggingface_hub.HfApi.comment_discussion.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.comment_discussion.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6589",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the newly created comment</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/community#huggingface_hub.DiscussionComment"
>DiscussionComment</a></p>
`}}),Vo=new C({props:{anchor:"huggingface_hub.HfApi.comment_discussion.example",$$slots:{default:[qq]},$$scope:{ctx:T}}}),Bo=new I({props:{$$slots:{default:[Uq]},$$scope:{ctx:T}}}),Rr=new q({props:{name:"create_branch",anchor:"huggingface_hub.HfApi.create_branch",parameters:[{name:"repo_id",val:": str"},{name:"branch",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"exist_ok",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_branch.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository in which the branch will be created.
Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_branch.branch",description:`<strong>branch</strong> (<code>str</code>) &#x2014;
The name of the branch to create.`,name:"branch"},{anchor:"huggingface_hub.HfApi.create_branch.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to create the branch from. It can be a branch name or
the OID/SHA of a commit, as a hexadecimal string. Defaults to the head
of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.create_branch.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.create_branch.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if creating a branch on a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if tagging a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.create_branch.exist_ok",description:`<strong>exist_ok</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, do not raise an error if branch already exists.`,name:"exist_ok"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5930",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private
but not authenticated or repo does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a> —
If invalid reference for a branch. Ex: <code>refs/pr/5</code> or ‘refs/foo/bar’.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
If the branch already exists on the repo (error 409) and <code>exist_ok</code> is
set to <code>False</code>.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a></p>
`}}),Gr=new q({props:{name:"create_collection",anchor:"huggingface_hub.HfApi.create_collection",parameters:[{name:"title",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"description",val:": Optional[str] = None"},{name:"private",val:": bool = False"},{name:"exists_ok",val:": bool = False"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_collection.title",description:`<strong>title</strong> (<code>str</code>) &#x2014;
Title of the collection to create. Example: <code>&quot;Recent models&quot;</code>.`,name:"title"},{anchor:"huggingface_hub.HfApi.create_collection.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Namespace of the collection to create (username or org). Will default to the owner name.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.create_collection.description",description:`<strong>description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Description of the collection to create.`,name:"description"},{anchor:"huggingface_hub.HfApi.create_collection.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the collection should be private or not. Defaults to <code>False</code> (i.e. public collection).`,name:"private"},{anchor:"huggingface_hub.HfApi.create_collection.exists_ok",description:`<strong>exists_ok</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, do not raise an error if collection already exists.`,name:"exists_ok"},{anchor:"huggingface_hub.HfApi.create_collection.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8370"}}),Yo=new C({props:{anchor:"huggingface_hub.HfApi.create_collection.example",$$slots:{default:[Hq]},$$scope:{ctx:T}}}),Zr=new q({props:{name:"create_commit",anchor:"huggingface_hub.HfApi.create_commit",parameters:[{name:"repo_id",val:": str"},{name:"operations",val:": Iterable[CommitOperation]"},{name:"commit_message",val:": str"},{name:"commit_description",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"num_threads",val:": int = 5"},{name:"parent_commit",val:": Optional[str] = None"},{name:"run_as_future",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_commit.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository in which the commit will be created, for example:
<code>&quot;username/custom_transformers&quot;</code>`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_commit.operations",description:`<strong>operations</strong> (<code>Iterable</code> of <code>CommitOperation()</code>) &#x2014;
An iterable of operations to include in the commit, either:</p>
<ul>
<li><a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitOperationAdd">CommitOperationAdd</a> to upload a file</li>
<li><a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitOperationDelete">CommitOperationDelete</a> to delete a file</li>
<li><a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitOperationCopy">CommitOperationCopy</a> to copy a file</li>
</ul>
<p>Operation objects will be mutated to include information relative to the upload. Do not reuse the
same objects for multiple commits.`,name:"operations"},{anchor:"huggingface_hub.HfApi.create_commit.commit_message",description:`<strong>commit_message</strong> (<code>str</code>) &#x2014;
The summary (first line) of the commit that will be created.`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.create_commit.commit_description",description:`<strong>commit_description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The description of the commit that will be created`,name:"commit_description"},{anchor:"huggingface_hub.HfApi.create_commit.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.create_commit.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.create_commit.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.create_commit.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request with that commit. Defaults to <code>False</code>.
If <code>revision</code> is not set, PR is opened against the <code>&quot;main&quot;</code> branch. If
<code>revision</code> is set and is a branch, PR is opened against this branch. If
<code>revision</code> is set and is not a branch name (example: a commit oid), an
<code>RevisionNotFoundError</code> is returned by the server.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.create_commit.num_threads",description:`<strong>num_threads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of concurrent threads for uploading files. Defaults to 5.
Setting it to 2 means at most 2 files will be uploaded concurrently.`,name:"num_threads"},{anchor:"huggingface_hub.HfApi.create_commit.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string.
Shorthands (7 first characters) are also supported. If specified and <code>create_pr</code> is <code>False</code>,
the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>. If specified and <code>create_pr</code>
is <code>True</code>, the pull request will be created from <code>parent_commit</code>. Specifying <code>parent_commit</code>
ensures the repo has not changed before committing the changes, and can be especially useful
if the repo is updated / committed to concurrently.`,name:"parent_commit"},{anchor:"huggingface_hub.HfApi.create_commit.run_as_future",description:`<strong>run_as_future</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to run this method in the background. Background jobs are run sequentially without
blocking the main thread. Passing <code>run_as_future=True</code> will return a <a href="https://docs.python.org/3/library/concurrent.futures.html#future-objects" rel="nofollow">Future</a>
object. Defaults to <code>False</code>.`,name:"run_as_future"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L4071",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Instance of <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitInfo"
>CommitInfo</a> containing information about the newly created commit (commit hash, commit
url, pr url, commit message,…). If <code>run_as_future=True</code> is passed, returns a Future object which will
contain the result when executed.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitInfo"
>CommitInfo</a> or <code>Future</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If commit message is empty.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If parent commit is not a valid commit OID.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If a README.md file with an invalid metadata section is committed. In this case, the commit will fail
early, before trying to upload any file.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If <code>create_pr</code> is <code>True</code> and revision is neither <code>None</code> nor <code>"main"</code>.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private
but not authenticated or repo does not exist.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a></p>
`}}),Xo=new I({props:{warning:!0,$$slots:{default:[Cq]},$$scope:{ctx:T}}}),Qo=new I({props:{warning:!0,$$slots:{default:[Iq]},$$scope:{ctx:T}}}),zo=new I({props:{warning:!0,$$slots:{default:[Jq]},$$scope:{ctx:T}}}),Fr=new q({props:{name:"create_discussion",anchor:"huggingface_hub.HfApi.create_discussion",parameters:[{name:"repo_id",val:": str"},{name:"title",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"description",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"pull_request",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_discussion.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_discussion.title",description:`<strong>title</strong> (<code>str</code>) &#x2014;
The title of the discussion. It can be up to 200 characters long,
and must be at least 3 characters long. Leading and trailing whitespaces
will be stripped.`,name:"title"},{anchor:"huggingface_hub.HfApi.create_discussion.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.create_discussion.description",description:`<strong>description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional description for the Pull Request.
Defaults to <code>&quot;Discussion opened with the huggingface_hub Python library&quot;</code>`,name:"description"},{anchor:"huggingface_hub.HfApi.create_discussion.pull_request",description:`<strong>pull_request</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to create a Pull Request or discussion. If <code>True</code>, creates a Pull Request.
If <code>False</code>, creates a discussion. Defaults to <code>False</code>.`,name:"pull_request"},{anchor:"huggingface_hub.HfApi.create_discussion.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6410"}}),Oo=new I({props:{$$slots:{default:[Nq]},$$scope:{ctx:T}}}),Sr=new q({props:{name:"create_inference_endpoint",anchor:"huggingface_hub.HfApi.create_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"repository",val:": str"},{name:"framework",val:": str"},{name:"accelerator",val:": str"},{name:"instance_size",val:": str"},{name:"instance_type",val:": str"},{name:"region",val:": str"},{name:"vendor",val:": str"},{name:"account_id",val:": Optional[str] = None"},{name:"min_replica",val:": int = 1"},{name:"max_replica",val:": int = 1"},{name:"scale_to_zero_timeout",val:": Optional[int] = None"},{name:"revision",val:": Optional[str] = None"},{name:"task",val:": Optional[str] = None"},{name:"custom_image",val:": Optional[Dict] = None"},{name:"env",val:": Optional[Dict[str, str]] = None"},{name:"secrets",val:": Optional[Dict[str, str]] = None"},{name:"type",val:": InferenceEndpointType = <InferenceEndpointType.PROTECTED: 'protected'>"},{name:"domain",val:": Optional[str] = None"},{name:"path",val:": Optional[str] = None"},{name:"cache_http_responses",val:": Optional[bool] = None"},{name:"tags",val:": Optional[List[str]] = None"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The unique name for the new Inference Endpoint.`,name:"name"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.repository",description:`<strong>repository</strong> (<code>str</code>) &#x2014;
The name of the model repository associated with the Inference Endpoint (e.g. <code>&quot;gpt2&quot;</code>).`,name:"repository"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.framework",description:`<strong>framework</strong> (<code>str</code>) &#x2014;
The machine learning framework used for the model (e.g. <code>&quot;custom&quot;</code>).`,name:"framework"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.accelerator",description:`<strong>accelerator</strong> (<code>str</code>) &#x2014;
The hardware accelerator to be used for inference (e.g. <code>&quot;cpu&quot;</code>).`,name:"accelerator"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.instance_size",description:`<strong>instance_size</strong> (<code>str</code>) &#x2014;
The size or type of the instance to be used for hosting the model (e.g. <code>&quot;x4&quot;</code>).`,name:"instance_size"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.instance_type",description:`<strong>instance_type</strong> (<code>str</code>) &#x2014;
The cloud instance type where the Inference Endpoint will be deployed (e.g. <code>&quot;intel-icl&quot;</code>).`,name:"instance_type"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.region",description:`<strong>region</strong> (<code>str</code>) &#x2014;
The cloud region in which the Inference Endpoint will be created (e.g. <code>&quot;us-east-1&quot;</code>).`,name:"region"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.vendor",description:`<strong>vendor</strong> (<code>str</code>) &#x2014;
The cloud provider or vendor where the Inference Endpoint will be hosted (e.g. <code>&quot;aws&quot;</code>).`,name:"vendor"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.account_id",description:`<strong>account_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The account ID used to link a VPC to a private Inference Endpoint (if applicable).`,name:"account_id"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.min_replica",description:`<strong>min_replica</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum number of replicas (instances) to keep running for the Inference Endpoint. To enable
scaling to zero, set this value to 0 and adjust <code>scale_to_zero_timeout</code> accordingly. Defaults to 1.`,name:"min_replica"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.max_replica",description:`<strong>max_replica</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum number of replicas (instances) to scale to for the Inference Endpoint. Defaults to 1.`,name:"max_replica"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.scale_to_zero_timeout",description:`<strong>scale_to_zero_timeout</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The duration in minutes before an inactive endpoint is scaled to zero, or no scaling to zero if
set to None and <code>min_replica</code> is not 0. Defaults to None.`,name:"scale_to_zero_timeout"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The specific model revision to deploy on the Inference Endpoint (e.g. <code>&quot;6c0e6080953db56375760c0471a8c5f2929baf11&quot;</code>).`,name:"revision"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The task on which to deploy the model (e.g. <code>&quot;text-classification&quot;</code>).`,name:"task"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.custom_image",description:`<strong>custom_image</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A custom Docker image to use for the Inference Endpoint. This is useful if you want to deploy an
Inference Endpoint running on the <code>text-generation-inference</code> (TGI) framework (see examples).`,name:"custom_image"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.env",description:`<strong>env</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
Non-secret environment variables to inject in the container environment.`,name:"env"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.secrets",description:`<strong>secrets</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
Secret values to inject in the container environment.`,name:"secrets"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.type",description:"<strong>type</strong> ([`InferenceEndpointType]<code>, *optional*) -- The type of the Inference Endpoint, which can be </code>&#x201C;protected&#x201D;<code>(default),</code>&#x201C;public&#x201D;<code>or</code>&#x201C;private&#x201D;`.",name:"type"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.domain",description:`<strong>domain</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The custom domain for the Inference Endpoint deployment, if setup the inference endpoint will be available at this domain (e.g. <code>&quot;my-new-domain.cool-website.woof&quot;</code>).`,name:"domain"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.path",description:`<strong>path</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The custom path to the deployed model, should start with a <code>/</code> (e.g. <code>&quot;/models/google-bert/bert-base-uncased&quot;</code>).`,name:"path"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.cache_http_responses",description:`<strong>cache_http_responses</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to cache HTTP responses from the Inference Endpoint. Defaults to <code>False</code>.`,name:"cache_http_responses"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.tags",description:`<strong>tags</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of tags to associate with the Inference Endpoint.`,name:"tags"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Inference Endpoint will be created. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7613",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the updated Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),Ko=new C({props:{anchor:"huggingface_hub.HfApi.create_inference_endpoint.example",$$slots:{default:[Aq]},$$scope:{ctx:T}}}),ea=new C({props:{anchor:"huggingface_hub.HfApi.create_inference_endpoint.example-2",$$slots:{default:[Eq]},$$scope:{ctx:T}}}),ta=new C({props:{anchor:"huggingface_hub.HfApi.create_inference_endpoint.example-3",$$slots:{default:[Dq]},$$scope:{ctx:T}}}),Lr=new q({props:{name:"create_inference_endpoint_from_catalog",anchor:"huggingface_hub.HfApi.create_inference_endpoint_from_catalog",parameters:[{name:"repo_id",val:": str"},{name:"name",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"},{name:"namespace",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_inference_endpoint_from_catalog.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The ID of the model in the catalog to deploy as an Inference Endpoint.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint_from_catalog.name",description:`<strong>name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The unique name for the new Inference Endpoint. If not provided, a random name will be generated.`,name:"name"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint_from_catalog.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).`,name:"token"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint_from_catalog.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Inference Endpoint will be created. Defaults to the current user&#x2019;s namespace.`,name:"namespace"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7842",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the new Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),na=new I({props:{warning:!0,$$slots:{default:[Rq]},$$scope:{ctx:T}}}),Wr=new q({props:{name:"create_pull_request",anchor:"huggingface_hub.HfApi.create_pull_request",parameters:[{name:"repo_id",val:": str"},{name:"title",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"description",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_pull_request.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_pull_request.title",description:`<strong>title</strong> (<code>str</code>) &#x2014;
The title of the discussion. It can be up to 200 characters long,
and must be at least 3 characters long. Leading and trailing whitespaces
will be stripped.`,name:"title"},{anchor:"huggingface_hub.HfApi.create_pull_request.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.create_pull_request.description",description:`<strong>description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional description for the Pull Request.
Defaults to <code>&quot;Discussion opened with the huggingface_hub Python library&quot;</code>`,name:"description"},{anchor:"huggingface_hub.HfApi.create_pull_request.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6502"}}),oa=new I({props:{$$slots:{default:[Gq]},$$scope:{ctx:T}}}),Vr=new q({props:{name:"create_repo",anchor:"huggingface_hub.HfApi.create_repo",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[str, bool, None] = None"},{name:"private",val:": Optional[bool] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"exist_ok",val:": bool = False"},{name:"resource_group_id",val:": Optional[str] = None"},{name:"space_sdk",val:": Optional[str] = None"},{name:"space_hardware",val:": Optional[SpaceHardware] = None"},{name:"space_storage",val:": Optional[SpaceStorage] = None"},{name:"space_sleep_time",val:": Optional[int] = None"},{name:"space_secrets",val:": Optional[List[Dict[str, str]]] = None"},{name:"space_variables",val:": Optional[List[Dict[str, str]]] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_repo.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_repo.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.create_repo.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to make the repo private. If <code>None</code> (default), the repo will be public unless the organization&#x2019;s default is private. This value is ignored if the repo already exists.`,name:"private"},{anchor:"huggingface_hub.HfApi.create_repo.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.create_repo.exist_ok",description:`<strong>exist_ok</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, do not raise an error if repo already exists.`,name:"exist_ok"},{anchor:"huggingface_hub.HfApi.create_repo.resource_group_id",description:`<strong>resource_group_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Resource group in which to create the repo. Resource groups is only available for Enterprise Hub organizations and
allow to define which members of the organization can access the resource. The ID of a resource group
can be found in the URL of the resource&#x2019;s page on the Hub (e.g. <code>&quot;66670e5163145ca562cb1988&quot;</code>).
To learn more about resource groups, see <a href="https://huggingface.co/docs/hub/en/security-resource-groups" rel="nofollow">https://huggingface.co/docs/hub/en/security-resource-groups</a>.`,name:"resource_group_id"},{anchor:"huggingface_hub.HfApi.create_repo.space_sdk",description:`<strong>space_sdk</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Choice of SDK to use if repo_type is &#x201C;space&#x201D;. Can be &#x201C;streamlit&#x201D;, &#x201C;gradio&#x201D;, &#x201C;docker&#x201D;, or &#x201C;static&#x201D;.`,name:"space_sdk"},{anchor:"huggingface_hub.HfApi.create_repo.space_hardware",description:`<strong>space_hardware</strong> (<code>SpaceHardware</code> or <code>str</code>, <em>optional</em>) &#x2014;
Choice of Hardware if repo_type is &#x201C;space&#x201D;. See <a href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceHardware">SpaceHardware</a> for a complete list.`,name:"space_hardware"},{anchor:"huggingface_hub.HfApi.create_repo.space_storage",description:`<strong>space_storage</strong> (<code>SpaceStorage</code> or <code>str</code>, <em>optional</em>) &#x2014;
Choice of persistent storage tier. Example: <code>&quot;small&quot;</code>. See <a href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceStorage">SpaceStorage</a> for a complete list.`,name:"space_storage"},{anchor:"huggingface_hub.HfApi.create_repo.space_sleep_time",description:`<strong>space_sleep_time</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of seconds of inactivity to wait before a Space is put to sleep. Set to <code>-1</code> if you don&#x2019;t want
your Space to sleep (default behavior for upgraded hardware). For free hardware, you can&#x2019;t configure
the sleep time (value is fixed to 48 hours of inactivity).
See <a href="https://huggingface.co/docs/hub/spaces-gpus#sleep-time" rel="nofollow">https://huggingface.co/docs/hub/spaces-gpus#sleep-time</a> for more details.`,name:"space_sleep_time"},{anchor:"huggingface_hub.HfApi.create_repo.space_secrets",description:`<strong>space_secrets</strong> (<code>List[Dict[str, str]]</code>, <em>optional</em>) &#x2014;
A list of secret keys to set in your Space. Each item is in the form <code>{&quot;key&quot;: ..., &quot;value&quot;: ..., &quot;description&quot;: ...}</code> where description is optional.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets</a>.`,name:"space_secrets"},{anchor:"huggingface_hub.HfApi.create_repo.space_variables",description:`<strong>space_variables</strong> (<code>List[Dict[str, str]]</code>, <em>optional</em>) &#x2014;
A list of public environment variables to set in your Space. Each item is in the form <code>{&quot;key&quot;: ..., &quot;value&quot;: ..., &quot;description&quot;: ...}</code> where description is optional.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables</a>.`,name:"space_variables"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3637",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>URL to the newly created repo. Value is a subclass of <code>str</code> containing
attributes like <code>endpoint</code>, <code>repo_type</code> and <code>repo_id</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.RepoUrl"
>RepoUrl</a></p>
`}}),Br=new q({props:{name:"create_scheduled_job",anchor:"huggingface_hub.HfApi.create_scheduled_job",parameters:[{name:"image",val:": str"},{name:"command",val:": List[str]"},{name:"schedule",val:": str"},{name:"suspend",val:": Optional[bool] = None"},{name:"concurrency",val:": Optional[bool] = None"},{name:"env",val:": Optional[Dict[str, Any]] = None"},{name:"secrets",val:": Optional[Dict[str, Any]] = None"},{name:"flavor",val:": Optional[SpaceHardware] = None"},{name:"timeout",val:": Optional[Union[int, float, str]] = None"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_scheduled_job.image",description:`<strong>image</strong> (<code>str</code>) &#x2014;
The Docker image to use.
Examples: <code>&quot;ubuntu&quot;</code>, <code>&quot;python:3.12&quot;</code>, <code>&quot;pytorch/pytorch:2.6.0-cuda12.4-cudnn9-devel&quot;</code>.
Example with an image from a Space: <code>&quot;hf.co/spaces/lhoestq/duckdb&quot;</code>.`,name:"image"},{anchor:"huggingface_hub.HfApi.create_scheduled_job.command",description:`<strong>command</strong> (<code>List[str]</code>) &#x2014;
The command to run. Example: <code>[&quot;echo&quot;, &quot;hello&quot;]</code>.`,name:"command"},{anchor:"huggingface_hub.HfApi.create_scheduled_job.schedule",description:`<strong>schedule</strong> (<code>str</code>) &#x2014;
One of &#x201C;@annually&#x201D;, &#x201C;@yearly&#x201D;, &#x201C;@monthly&#x201D;, &#x201C;@weekly&#x201D;, &#x201C;@daily&#x201D;, &#x201C;@hourly&#x201D;, or a
CRON schedule expression (e.g., &#x2018;0 9 * * 1&#x2019; for 9 AM every Monday).`,name:"schedule"},{anchor:"huggingface_hub.HfApi.create_scheduled_job.suspend",description:`<strong>suspend</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If True, the scheduled Job is suspended (paused).  Defaults to False.`,name:"suspend"},{anchor:"huggingface_hub.HfApi.create_scheduled_job.concurrency",description:`<strong>concurrency</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If True, multiple instances of this Job can run concurrently. Defaults to False.`,name:"concurrency"},{anchor:"huggingface_hub.HfApi.create_scheduled_job.env",description:`<strong>env</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Defines the environment variables for the Job.`,name:"env"},{anchor:"huggingface_hub.HfApi.create_scheduled_job.secrets",description:`<strong>secrets</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Defines the secret environment variables for the Job.`,name:"secrets"},{anchor:"huggingface_hub.HfApi.create_scheduled_job.flavor",description:`<strong>flavor</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Flavor for the hardware, as in Hugging Face Spaces. See <a href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceHardware">SpaceHardware</a> for possible values.
Defaults to <code>&quot;cpu-basic&quot;</code>.`,name:"flavor"},{anchor:"huggingface_hub.HfApi.create_scheduled_job.timeout",description:`<strong>timeout</strong> (<code>Union[int, float, str]</code>, <em>optional</em>) &#x2014;
Max duration for the Job: int/float with s (seconds, default), m (minutes), h (hours) or d (days).
Example: <code>300</code> or <code>&quot;5m&quot;</code> for 5 minutes.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.create_scheduled_job.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Job will be created. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.create_scheduled_job.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L10369"}}),sa=new C({props:{anchor:"huggingface_hub.HfApi.create_scheduled_job.example",$$slots:{default:[Zq]},$$scope:{ctx:T}}}),ra=new C({props:{anchor:"huggingface_hub.HfApi.create_scheduled_job.example-2",$$slots:{default:[Fq]},$$scope:{ctx:T}}}),ia=new C({props:{anchor:"huggingface_hub.HfApi.create_scheduled_job.example-3",$$slots:{default:[Sq]},$$scope:{ctx:T}}}),Pr=new q({props:{name:"create_scheduled_uv_job",anchor:"huggingface_hub.HfApi.create_scheduled_uv_job",parameters:[{name:"script",val:": str"},{name:"script_args",val:": Optional[List[str]] = None"},{name:"schedule",val:": str"},{name:"suspend",val:": Optional[bool] = None"},{name:"concurrency",val:": Optional[bool] = None"},{name:"dependencies",val:": Optional[List[str]] = None"},{name:"python",val:": Optional[str] = None"},{name:"image",val:": Optional[str] = None"},{name:"env",val:": Optional[Dict[str, Any]] = None"},{name:"secrets",val:": Optional[Dict[str, Any]] = None"},{name:"flavor",val:": Optional[SpaceHardware] = None"},{name:"timeout",val:": Optional[Union[int, float, str]] = None"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"},{name:"_repo",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.script",description:`<strong>script</strong> (<code>str</code>) &#x2014;
Path or URL of the UV script, or a command.`,name:"script"},{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.script_args",description:`<strong>script_args</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Arguments to pass to the script, or a command.`,name:"script_args"},{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.schedule",description:`<strong>schedule</strong> (<code>str</code>) &#x2014;
One of &#x201C;@annually&#x201D;, &#x201C;@yearly&#x201D;, &#x201C;@monthly&#x201D;, &#x201C;@weekly&#x201D;, &#x201C;@daily&#x201D;, &#x201C;@hourly&#x201D;, or a
CRON schedule expression (e.g., &#x2018;0 9 * * 1&#x2019; for 9 AM every Monday).`,name:"schedule"},{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.suspend",description:`<strong>suspend</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If True, the scheduled Job is suspended (paused).  Defaults to False.`,name:"suspend"},{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.concurrency",description:`<strong>concurrency</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If True, multiple instances of this Job can run concurrently. Defaults to False.`,name:"concurrency"},{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.dependencies",description:`<strong>dependencies</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Dependencies to use to run the UV script.`,name:"dependencies"},{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.python",description:`<strong>python</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Use a specific Python version. Default is 3.12.`,name:"python"},{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.image",description:`<strong>image</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201C;ghcr.io/astral-sh/uv &#x2014;python3.12-bookworm&#x201D;):
Use a custom Docker image with <code>uv</code> installed.`,name:"image"},{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.env",description:`<strong>env</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Defines the environment variables for the Job.`,name:"env"},{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.secrets",description:`<strong>secrets</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Defines the secret environment variables for the Job.`,name:"secrets"},{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.flavor",description:`<strong>flavor</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Flavor for the hardware, as in Hugging Face Spaces. See <a href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceHardware">SpaceHardware</a> for possible values.
Defaults to <code>&quot;cpu-basic&quot;</code>.`,name:"flavor"},{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.timeout",description:`<strong>timeout</strong> (<code>Union[int, float, str]</code>, <em>optional</em>) &#x2014;
Max duration for the Job: int/float with s (seconds, default), m (minutes), h (hours) or d (days).
Example: <code>300</code> or <code>&quot;5m&quot;</code> for 5 minutes.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Job will be created. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L10641"}}),ca=new C({props:{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.example",$$slots:{default:[Lq]},$$scope:{ctx:T}}}),la=new C({props:{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.example-2",$$slots:{default:[Wq]},$$scope:{ctx:T}}}),pa=new C({props:{anchor:"huggingface_hub.HfApi.create_scheduled_uv_job.example-3",$$slots:{default:[Vq]},$$scope:{ctx:T}}}),Yr=new q({props:{name:"create_tag",anchor:"huggingface_hub.HfApi.create_tag",parameters:[{name:"repo_id",val:": str"},{name:"tag",val:": str"},{name:"tag_message",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"exist_ok",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_tag.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository in which a commit will be tagged.
Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_tag.tag",description:`<strong>tag</strong> (<code>str</code>) &#x2014;
The name of the tag to create.`,name:"tag"},{anchor:"huggingface_hub.HfApi.create_tag.tag_message",description:`<strong>tag_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The description of the tag to create.`,name:"tag_message"},{anchor:"huggingface_hub.HfApi.create_tag.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to tag. It can be a branch name or the OID/SHA of a
commit, as a hexadecimal string. Shorthands (7 first characters) are
also supported. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.create_tag.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.create_tag.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if tagging a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if tagging a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.create_tag.exist_ok",description:`<strong>exist_ok</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, do not raise an error if tag already exists.`,name:"exist_ok"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6062",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private
but not authenticated or repo does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If revision is not found (error 404) on the repo.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
If the branch already exists on the repo (error 409) and <code>exist_ok</code> is
set to <code>False</code>.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a></p>
`}}),Xr=new q({props:{name:"create_webhook",anchor:"huggingface_hub.HfApi.create_webhook",parameters:[{name:"url",val:": str"},{name:"watched",val:": List[Union[Dict, WebhookWatchedItem]]"},{name:"domains",val:": Optional[List[constants.WEBHOOK_DOMAIN_T]] = None"},{name:"secret",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_webhook.url",description:`<strong>url</strong> (<code>str</code>) &#x2014;
URL to send the payload to.`,name:"url"},{anchor:"huggingface_hub.HfApi.create_webhook.watched",description:`<strong>watched</strong> (<code>List[WebhookWatchedItem]</code>) &#x2014;
List of <code>WebhookWatchedItem</code> to be watched by the webhook. It can be users, orgs, models, datasets or spaces.
Watched items can also be provided as plain dictionaries.`,name:"watched"},{anchor:"huggingface_hub.HfApi.create_webhook.domains",description:`<strong>domains</strong> (<code>List[Literal[&quot;repo&quot;, &quot;discussion&quot;]]</code>, optional) &#x2014;
List of domains to watch. It can be &#x201C;repo&#x201D;, &#x201C;discussion&#x201D; or both.`,name:"domains"},{anchor:"huggingface_hub.HfApi.create_webhook.secret",description:`<strong>secret</strong> (<code>str</code>, optional) &#x2014;
A secret to sign the payload with.`,name:"secret"},{anchor:"huggingface_hub.HfApi.create_webhook.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9274",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Info about the newly created webhook.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>WebhookInfo</code></p>
`}}),ga=new C({props:{anchor:"huggingface_hub.HfApi.create_webhook.example",$$slots:{default:[Bq]},$$scope:{ctx:T}}}),Qr=new q({props:{name:"dataset_info",anchor:"huggingface_hub.HfApi.dataset_info",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"timeout",val:": Optional[float] = None"},{name:"files_metadata",val:": bool = False"},{name:"expand",val:": Optional[List[ExpandDatasetProperty_T]] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.dataset_info.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.dataset_info.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the dataset repository from which to get the
information.`,name:"revision"},{anchor:"huggingface_hub.HfApi.dataset_info.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Whether to set a timeout for the request to the Hub.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.dataset_info.files_metadata",description:`<strong>files_metadata</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to retrieve metadata for files in the repository
(size, LFS metadata, etc). Defaults to <code>False</code>.`,name:"files_metadata"},{anchor:"huggingface_hub.HfApi.dataset_info.expand",description:`<strong>expand</strong> (<code>List[ExpandDatasetProperty_T]</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>files_metadata</code> is passed.
Possible values are <code>&quot;author&quot;</code>, <code>&quot;cardData&quot;</code>, <code>&quot;citation&quot;</code>, <code>&quot;createdAt&quot;</code>, <code>&quot;disabled&quot;</code>, <code>&quot;description&quot;</code>, <code>&quot;downloads&quot;</code>, <code>&quot;downloadsAllTime&quot;</code>, <code>&quot;gated&quot;</code>, <code>&quot;lastModified&quot;</code>, <code>&quot;likes&quot;</code>, <code>&quot;paperswithcode_id&quot;</code>, <code>&quot;private&quot;</code>, <code>&quot;siblings&quot;</code>, <code>&quot;sha&quot;</code>, <code>&quot;tags&quot;</code>, <code>&quot;trendingScore&quot;</code>,<code>&quot;usedStorage&quot;</code>, <code>&quot;resourceGroup&quot;</code> and <code>&quot;xetEnabled&quot;</code>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.dataset_info.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2653",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The dataset repository information.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.DatasetInfo"
>hf_api.DatasetInfo</a></p>
`}}),ua=new I({props:{$$slots:{default:[Pq]},$$scope:{ctx:T}}}),zr=new q({props:{name:"delete_branch",anchor:"huggingface_hub.HfApi.delete_branch",parameters:[{name:"repo_id",val:": str"},{name:"branch",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_branch.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository in which a branch will be deleted.
Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_branch.branch",description:`<strong>branch</strong> (<code>str</code>) &#x2014;
The name of the branch to delete.`,name:"branch"},{anchor:"huggingface_hub.HfApi.delete_branch.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.delete_branch.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if creating a branch on a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if tagging a model. Default is <code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6010",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private
but not authenticated or repo does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
If trying to delete a protected branch. Ex: <code>main</code> cannot be deleted.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
If trying to delete a branch that does not exist.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a></p>
`}}),Or=new q({props:{name:"delete_collection",anchor:"huggingface_hub.HfApi.delete_collection",parameters:[{name:"collection_slug",val:": str"},{name:"missing_ok",val:": bool = False"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_collection.collection_slug",description:`<strong>collection_slug</strong> (<code>str</code>) &#x2014;
Slug of the collection to delete. Example: <code>&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</code>.`,name:"collection_slug"},{anchor:"huggingface_hub.HfApi.delete_collection.missing_ok",description:`<strong>missing_ok</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, do not raise an error if collection doesn&#x2019;t exists.`,name:"missing_ok"},{anchor:"huggingface_hub.HfApi.delete_collection.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8506"}}),fa=new C({props:{anchor:"huggingface_hub.HfApi.delete_collection.example",$$slots:{default:[Yq]},$$scope:{ctx:T}}}),ma=new I({props:{warning:!0,$$slots:{default:[Xq]},$$scope:{ctx:T}}}),Kr=new q({props:{name:"delete_collection_item",anchor:"huggingface_hub.HfApi.delete_collection_item",parameters:[{name:"collection_slug",val:": str"},{name:"item_object_id",val:": str"},{name:"missing_ok",val:": bool = False"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_collection_item.collection_slug",description:`<strong>collection_slug</strong> (<code>str</code>) &#x2014;
Slug of the collection to update. Example: <code>&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</code>.`,name:"collection_slug"},{anchor:"huggingface_hub.HfApi.delete_collection_item.item_object_id",description:`<strong>item_object_id</strong> (<code>str</code>) &#x2014;
ID of the item in the collection. This is not the id of the item on the Hub (repo_id or paper id).
It must be retrieved from a <a href="/docs/huggingface_hub/main/ko/package_reference/collections#huggingface_hub.CollectionItem">CollectionItem</a> object. Example: <code>collection.items[0].item_object_id</code>.`,name:"item_object_id"},{anchor:"huggingface_hub.HfApi.delete_collection_item.missing_ok",description:`<strong>missing_ok</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, do not raise an error if item doesn&#x2019;t exists.`,name:"missing_ok"},{anchor:"huggingface_hub.HfApi.delete_collection_item.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8682"}}),_a=new C({props:{anchor:"huggingface_hub.HfApi.delete_collection_item.example",$$slots:{default:[Qq]},$$scope:{ctx:T}}}),ei=new q({props:{name:"delete_file",anchor:"huggingface_hub.HfApi.delete_file",parameters:[{name:"path_in_repo",val:": str"},{name:"repo_id",val:": str"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"commit_message",val:": Optional[str] = None"},{name:"commit_description",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"parent_commit",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_file.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>) &#x2014;
Relative filepath in the repo, for example:
<code>&quot;checkpoints/1fec34a/weights.bin&quot;</code>`,name:"path_in_repo"},{anchor:"huggingface_hub.HfApi.delete_file.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository from which the file will be deleted, for example:
<code>&quot;username/custom_transformers&quot;</code>`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_file.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.delete_file.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if the file is in a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if in a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.delete_file.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.delete_file.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The summary / title / first line of the generated commit. Defaults to
<code>f&quot;Delete {path_in_repo} with huggingface_hub&quot;</code>.`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.delete_file.commit_description",description:`<strong>commit_description</strong> (<code>str</code> <em>optional</em>) &#x2014;
The description of the generated commit`,name:"commit_description"},{anchor:"huggingface_hub.HfApi.delete_file.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request with that commit. Defaults to <code>False</code>.
If <code>revision</code> is not set, PR is opened against the <code>&quot;main&quot;</code> branch. If
<code>revision</code> is set and is a branch, PR is opened against this branch. If
<code>revision</code> is set and is not a branch name (example: a commit oid), an
<code>RevisionNotFoundError</code> is returned by the server.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.delete_file.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string. Shorthands (7 first characters) are also supported.
If specified and <code>create_pr</code> is <code>False</code>, the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>.
If specified and <code>create_pr</code> is <code>True</code>, the pull request will be created from <code>parent_commit</code>.
Specifying <code>parent_commit</code> ensures the repo has not changed before committing the changes, and can be
especially useful if the repo is updated / committed to concurrently.`,name:"parent_commit"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5023"}}),ba=new I({props:{$$slots:{default:[zq]},$$scope:{ctx:T}}}),ti=new q({props:{name:"delete_files",anchor:"huggingface_hub.HfApi.delete_files",parameters:[{name:"repo_id",val:": str"},{name:"delete_patterns",val:": List[str]"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"commit_message",val:": Optional[str] = None"},{name:"commit_description",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"parent_commit",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_files.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository from which the folder will be deleted, for example:
<code>&quot;username/custom_transformers&quot;</code>`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_files.delete_patterns",description:`<strong>delete_patterns</strong> (<code>List[str]</code>) &#x2014;
List of files or folders to delete. Each string can either be
a file path, a folder path or a Unix shell-style wildcard.
E.g. <code>[&quot;file.txt&quot;, &quot;folder/&quot;, &quot;data/*.parquet&quot;]</code>`,name:"delete_patterns"},{anchor:"huggingface_hub.HfApi.delete_files.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.
to the stored token.`,name:"token"},{anchor:"huggingface_hub.HfApi.delete_files.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Type of the repo to delete files from. Can be <code>&quot;model&quot;</code>,
<code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code>. Defaults to <code>&quot;model&quot;</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.delete_files.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.delete_files.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The summary (first line) of the generated commit. Defaults to
<code>f&quot;Delete files using huggingface_hub&quot;</code>.`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.delete_files.commit_description",description:`<strong>commit_description</strong> (<code>str</code> <em>optional</em>) &#x2014;
The description of the generated commit.`,name:"commit_description"},{anchor:"huggingface_hub.HfApi.delete_files.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request with that commit. Defaults to <code>False</code>.
If <code>revision</code> is not set, PR is opened against the <code>&quot;main&quot;</code> branch. If
<code>revision</code> is set and is a branch, PR is opened against this branch. If
<code>revision</code> is set and is not a branch name (example: a commit oid), an
<code>RevisionNotFoundError</code> is returned by the server.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.delete_files.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string. Shorthands (7 first characters) are also supported.
If specified and <code>create_pr</code> is <code>False</code>, the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>.
If specified and <code>create_pr</code> is <code>True</code>, the pull request will be created from <code>parent_commit</code>.
Specifying <code>parent_commit</code> ensures the repo has not changed before committing the changes, and can be
especially useful if the repo is updated / committed to concurrently.`,name:"parent_commit"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5113"}}),ni=new q({props:{name:"delete_folder",anchor:"huggingface_hub.HfApi.delete_folder",parameters:[{name:"path_in_repo",val:": str"},{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"commit_message",val:": Optional[str] = None"},{name:"commit_description",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"parent_commit",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_folder.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>) &#x2014;
Relative folder path in the repo, for example: <code>&quot;checkpoints/1fec34a&quot;</code>.`,name:"path_in_repo"},{anchor:"huggingface_hub.HfApi.delete_folder.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository from which the folder will be deleted, for example:
<code>&quot;username/custom_transformers&quot;</code>`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_folder.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.
to the stored token.`,name:"token"},{anchor:"huggingface_hub.HfApi.delete_folder.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if the folder is in a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if in a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.delete_folder.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.delete_folder.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The summary / title / first line of the generated commit. Defaults to
<code>f&quot;Delete folder {path_in_repo} with huggingface_hub&quot;</code>.`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.delete_folder.commit_description",description:`<strong>commit_description</strong> (<code>str</code> <em>optional</em>) &#x2014;
The description of the generated commit.`,name:"commit_description"},{anchor:"huggingface_hub.HfApi.delete_folder.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request with that commit. Defaults to <code>False</code>.
If <code>revision</code> is not set, PR is opened against the <code>&quot;main&quot;</code> branch. If
<code>revision</code> is set and is a branch, PR is opened against this branch. If
<code>revision</code> is set and is not a branch name (example: a commit oid), an
<code>RevisionNotFoundError</code> is returned by the server.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.delete_folder.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string. Shorthands (7 first characters) are also supported.
If specified and <code>create_pr</code> is <code>False</code>, the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>.
If specified and <code>create_pr</code> is <code>True</code>, the pull request will be created from <code>parent_commit</code>.
Specifying <code>parent_commit</code> ensures the repo has not changed before committing the changes, and can be
especially useful if the repo is updated / committed to concurrently.`,name:"parent_commit"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5189"}}),oi=new q({props:{name:"delete_inference_endpoint",anchor:"huggingface_hub.HfApi.delete_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The name of the Inference Endpoint to delete.`,name:"name"},{anchor:"huggingface_hub.HfApi.delete_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace in which the Inference Endpoint is located. Defaults to the current user.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.delete_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8114"}}),ai=new q({props:{name:"delete_repo",anchor:"huggingface_hub.HfApi.delete_repo",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"missing_ok",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_repo.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_repo.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.delete_repo.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.delete_repo.missing_ok",description:`<strong>missing_ok</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, do not raise an error if repo does not exist.`,name:"missing_ok"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3786",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If the repository to delete from cannot be found and <code>missing_ok</code> is set to False (default).</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a></p>
`}}),si=new q({props:{name:"delete_scheduled_job",anchor:"huggingface_hub.HfApi.delete_scheduled_job",parameters:[{name:"scheduled_job_id",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_scheduled_job.scheduled_job_id",description:`<strong>scheduled_job_id</strong> (<code>str</code>) &#x2014;
ID of the scheduled Job.`,name:"scheduled_job_id"},{anchor:"huggingface_hub.HfApi.delete_scheduled_job.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the scheduled Job is. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.delete_scheduled_job.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L10553"}}),ri=new q({props:{name:"delete_space_secret",anchor:"huggingface_hub.HfApi.delete_space_secret",parameters:[{name:"repo_id",val:": str"},{name:"key",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_space_secret.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_space_secret.key",description:`<strong>key</strong> (<code>str</code>) &#x2014;
Secret key. Example: <code>&quot;GITHUB_API_KEY&quot;</code>.`,name:"key"},{anchor:"huggingface_hub.HfApi.delete_space_secret.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7036"}}),ii=new q({props:{name:"delete_space_storage",anchor:"huggingface_hub.HfApi.delete_space_storage",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_space_storage.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the Space to update. Example: <code>&quot;open-llm-leaderboard/open_llm_leaderboard&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_space_storage.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7520",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about a Space including Space stage and hardware.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>BadRequestError</code> —
If space has no persistent storage.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>BadRequestError</code></p>
`}}),ci=new q({props:{name:"delete_space_variable",anchor:"huggingface_hub.HfApi.delete_space_variable",parameters:[{name:"repo_id",val:": str"},{name:"key",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_space_variable.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_space_variable.key",description:`<strong>key</strong> (<code>str</code>) &#x2014;
Variable key. Example: <code>&quot;MODEL_REPO_ID&quot;</code>`,name:"key"},{anchor:"huggingface_hub.HfApi.delete_space_variable.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7125"}}),li=new q({props:{name:"delete_tag",anchor:"huggingface_hub.HfApi.delete_tag",parameters:[{name:"repo_id",val:": str"},{name:"tag",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_tag.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository in which a tag will be deleted.
Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_tag.tag",description:`<strong>tag</strong> (<code>str</code>) &#x2014;
The name of the tag to delete.`,name:"tag"},{anchor:"huggingface_hub.HfApi.delete_tag.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.delete_tag.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if tagging a dataset or space, <code>None</code> or
<code>&quot;model&quot;</code> if tagging a model. Default is <code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6136",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private
but not authenticated or repo does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If tag is not found.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a></p>
`}}),pi=new q({props:{name:"delete_webhook",anchor:"huggingface_hub.HfApi.delete_webhook",parameters:[{name:"webhook_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_webhook.webhook_id",description:`<strong>webhook_id</strong> (<code>str</code>) &#x2014;
The unique identifier of the webhook to delete.`,name:"webhook_id"},{anchor:"huggingface_hub.HfApi.delete_webhook.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9528",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>None</code></p>
`}}),wa=new C({props:{anchor:"huggingface_hub.HfApi.delete_webhook.example",$$slots:{default:[Oq]},$$scope:{ctx:T}}}),di=new q({props:{name:"disable_webhook",anchor:"huggingface_hub.HfApi.disable_webhook",parameters:[{name:"webhook_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.disable_webhook.webhook_id",description:`<strong>webhook_id</strong> (<code>str</code>) &#x2014;
The unique identifier of the webhook to disable.`,name:"webhook_id"},{anchor:"huggingface_hub.HfApi.disable_webhook.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9477",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Info about the disabled webhook.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>WebhookInfo</code></p>
`}}),ka=new C({props:{anchor:"huggingface_hub.HfApi.disable_webhook.example",$$slots:{default:[Kq]},$$scope:{ctx:T}}}),gi=new q({props:{name:"duplicate_space",anchor:"huggingface_hub.HfApi.duplicate_space",parameters:[{name:"from_id",val:": str"},{name:"to_id",val:": Optional[str] = None"},{name:"private",val:": Optional[bool] = None"},{name:"token",val:": Union[bool, str, None] = None"},{name:"exist_ok",val:": bool = False"},{name:"hardware",val:": Optional[SpaceHardware] = None"},{name:"storage",val:": Optional[SpaceStorage] = None"},{name:"sleep_time",val:": Optional[int] = None"},{name:"secrets",val:": Optional[List[Dict[str, str]]] = None"},{name:"variables",val:": Optional[List[Dict[str, str]]] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.duplicate_space.from_id",description:`<strong>from_id</strong> (<code>str</code>) &#x2014;
ID of the Space to duplicate. Example: <code>&quot;pharma/CLIP-Interrogator&quot;</code>.`,name:"from_id"},{anchor:"huggingface_hub.HfApi.duplicate_space.to_id",description:`<strong>to_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
ID of the new Space. Example: <code>&quot;dog/CLIP-Interrogator&quot;</code>. If not provided, the new Space will have the same
name as the original Space, but in your account.`,name:"to_id"},{anchor:"huggingface_hub.HfApi.duplicate_space.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the new Space should be private or not. Defaults to the same privacy as the original Space.`,name:"private"},{anchor:"huggingface_hub.HfApi.duplicate_space.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.duplicate_space.exist_ok",description:`<strong>exist_ok</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, do not raise an error if repo already exists.`,name:"exist_ok"},{anchor:"huggingface_hub.HfApi.duplicate_space.hardware",description:`<strong>hardware</strong> (<code>SpaceHardware</code> or <code>str</code>, <em>optional</em>) &#x2014;
Choice of Hardware. Example: <code>&quot;t4-medium&quot;</code>. See <a href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceHardware">SpaceHardware</a> for a complete list.`,name:"hardware"},{anchor:"huggingface_hub.HfApi.duplicate_space.storage",description:`<strong>storage</strong> (<code>SpaceStorage</code> or <code>str</code>, <em>optional</em>) &#x2014;
Choice of persistent storage tier. Example: <code>&quot;small&quot;</code>. See <a href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceStorage">SpaceStorage</a> for a complete list.`,name:"storage"},{anchor:"huggingface_hub.HfApi.duplicate_space.sleep_time",description:`<strong>sleep_time</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of seconds of inactivity to wait before a Space is put to sleep. Set to <code>-1</code> if you don&#x2019;t want
your Space to sleep (default behavior for upgraded hardware). For free hardware, you can&#x2019;t configure
the sleep time (value is fixed to 48 hours of inactivity).
See <a href="https://huggingface.co/docs/hub/spaces-gpus#sleep-time" rel="nofollow">https://huggingface.co/docs/hub/spaces-gpus#sleep-time</a> for more details.`,name:"sleep_time"},{anchor:"huggingface_hub.HfApi.duplicate_space.secrets",description:`<strong>secrets</strong> (<code>List[Dict[str, str]]</code>, <em>optional</em>) &#x2014;
A list of secret keys to set in your Space. Each item is in the form <code>{&quot;key&quot;: ..., &quot;value&quot;: ..., &quot;description&quot;: ...}</code> where description is optional.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets</a>.`,name:"secrets"},{anchor:"huggingface_hub.HfApi.duplicate_space.variables",description:`<strong>variables</strong> (<code>List[Dict[str, str]]</code>, <em>optional</em>) &#x2014;
A list of public environment variables to set in your Space. Each item is in the form <code>{&quot;key&quot;: ..., &quot;value&quot;: ..., &quot;description&quot;: ...}</code> where description is optional.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables</a>.`,name:"variables"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7363",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>URL to the newly created repo. Value is a subclass of <code>str</code> containing
attributes like <code>endpoint</code>, <code>repo_type</code> and <code>repo_id</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.RepoUrl"
>RepoUrl</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If one of <code>from_id</code> or <code>to_id</code> cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
If the HuggingFace API returned an error</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <code>HTTPError</code></p>
`}}),Ta=new C({props:{anchor:"huggingface_hub.HfApi.duplicate_space.example",$$slots:{default:[eU]},$$scope:{ctx:T}}}),ui=new q({props:{name:"edit_discussion_comment",anchor:"huggingface_hub.HfApi.edit_discussion_comment",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"comment_id",val:": str"},{name:"new_content",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.edit_discussion_comment.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.edit_discussion_comment.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.edit_discussion_comment.comment_id",description:`<strong>comment_id</strong> (<code>str</code>) &#x2014;
The ID of the comment to edit.`,name:"comment_id"},{anchor:"huggingface_hub.HfApi.edit_discussion_comment.new_content",description:`<strong>new_content</strong> (<code>str</code>) &#x2014;
The new content of the comment. Comments support markdown formatting.`,name:"new_content"},{anchor:"huggingface_hub.HfApi.edit_discussion_comment.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.edit_discussion_comment.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6872",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the edited comment</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/community#huggingface_hub.DiscussionComment"
>DiscussionComment</a></p>
`}}),ja=new I({props:{$$slots:{default:[tU]},$$scope:{ctx:T}}}),hi=new q({props:{name:"enable_webhook",anchor:"huggingface_hub.HfApi.enable_webhook",parameters:[{name:"webhook_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.enable_webhook.webhook_id",description:`<strong>webhook_id</strong> (<code>str</code>) &#x2014;
The unique identifier of the webhook to enable.`,name:"webhook_id"},{anchor:"huggingface_hub.HfApi.enable_webhook.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9426",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Info about the enabled webhook.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>WebhookInfo</code></p>
`}}),Ma=new C({props:{anchor:"huggingface_hub.HfApi.enable_webhook.example",$$slots:{default:[nU]},$$scope:{ctx:T}}}),fi=new q({props:{name:"fetch_job_logs",anchor:"huggingface_hub.HfApi.fetch_job_logs",parameters:[{name:"job_id",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.fetch_job_logs.job_id",description:`<strong>job_id</strong> (<code>str</code>) &#x2014;
ID of the Job.`,name:"job_id"},{anchor:"huggingface_hub.HfApi.fetch_job_logs.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Job is running. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.fetch_job_logs.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L10050"}}),qa=new C({props:{anchor:"huggingface_hub.HfApi.fetch_job_logs.example",$$slots:{default:[oU]},$$scope:{ctx:T}}}),mi=new q({props:{name:"file_exists",anchor:"huggingface_hub.HfApi.file_exists",parameters:[{name:"repo_id",val:": str"},{name:"filename",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.file_exists.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.file_exists.filename",description:`<strong>filename</strong> (<code>str</code>) &#x2014;
The name of the file to check, for example:
<code>&quot;config.json&quot;</code>`,name:"filename"},{anchor:"huggingface_hub.HfApi.file_exists.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if getting repository info from a dataset or a space,
<code>None</code> or <code>&quot;model&quot;</code> if getting repository info from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.file_exists.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the repository from which to get the information. Defaults to <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.file_exists.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2964",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if the file exists, False otherwise.</p>
`}}),Ua=new C({props:{anchor:"huggingface_hub.HfApi.file_exists.example",$$slots:{default:[aU]},$$scope:{ctx:T}}}),_i=new q({props:{name:"get_collection",anchor:"huggingface_hub.HfApi.get_collection",parameters:[{name:"collection_slug",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_collection.collection_slug",description:`<strong>collection_slug</strong> (<code>str</code>) &#x2014;
Slug of the collection of the Hub. Example: <code>&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</code>.`,name:"collection_slug"},{anchor:"huggingface_hub.HfApi.get_collection.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8331"}}),Ha=new C({props:{anchor:"huggingface_hub.HfApi.get_collection.example",$$slots:{default:[sU]},$$scope:{ctx:T}}}),bi=new q({props:{name:"get_dataset_tags",anchor:"huggingface_hub.HfApi.get_dataset_tags",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1849"}}),yi=new q({props:{name:"get_discussion_details",anchor:"huggingface_hub.HfApi.get_discussion_details",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_discussion_details.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.get_discussion_details.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.get_discussion_details.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.get_discussion_details.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6331"}}),Ia=new I({props:{$$slots:{default:[rU]},$$scope:{ctx:T}}}),vi=new q({props:{name:"get_full_repo_name",anchor:"huggingface_hub.HfApi.get_full_repo_name",parameters:[{name:"model_id",val:": str"},{name:"organization",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_full_repo_name.model_id",description:`<strong>model_id</strong> (<code>str</code>) &#x2014;
The name of the model.`,name:"model_id"},{anchor:"huggingface_hub.HfApi.get_full_repo_name.organization",description:`<strong>organization</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If passed, the repository name will be in the organization
namespace instead of the user namespace.`,name:"organization"},{anchor:"huggingface_hub.HfApi.get_full_repo_name.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6185",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The repository name in the user’s namespace
({username}/{model_id}) if no organization is passed, and under the
organization namespace ({organization}/{model_id}) otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),xi=new q({props:{name:"get_hf_file_metadata",anchor:"huggingface_hub.HfApi.get_hf_file_metadata",parameters:[{name:"url",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"proxies",val:": Optional[Dict] = None"},{name:"timeout",val:": Optional[float] = 10"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_hf_file_metadata.url",description:`<strong>url</strong> (<code>str</code>) &#x2014;
File url, for example returned by <code>hf_hub_url()</code>.`,name:"url"},{anchor:"huggingface_hub.HfApi.get_hf_file_metadata.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.get_hf_file_metadata.proxies",description:`<strong>proxies</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary mapping protocol to the URL of the proxy passed to <code>requests.request</code>.`,name:"proxies"},{anchor:"huggingface_hub.HfApi.get_hf_file_metadata.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>, defaults to 10) &#x2014;
How many seconds to wait for the server to send metadata before giving up.`,name:"timeout"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5380",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>HfFileMetadata</code> object containing metadata such as location, etag, size and commit_hash.</p>
`}}),$i=new q({props:{name:"get_inference_endpoint",anchor:"huggingface_hub.HfApi.get_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The name of the Inference Endpoint to retrieve information about.`,name:"name"},{anchor:"huggingface_hub.HfApi.get_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace in which the Inference Endpoint is located. Defaults to the current user.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.get_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7930",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the requested Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),Aa=new C({props:{anchor:"huggingface_hub.HfApi.get_inference_endpoint.example",$$slots:{default:[iU]},$$scope:{ctx:T}}}),wi=new q({props:{name:"get_model_tags",anchor:"huggingface_hub.HfApi.get_model_tags",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1840"}}),ki=new q({props:{name:"get_paths_info",anchor:"huggingface_hub.HfApi.get_paths_info",parameters:[{name:"repo_id",val:": str"},{name:"paths",val:": Union[List[str], str]"},{name:"expand",val:": bool = False"},{name:"revision",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_paths_info.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.get_paths_info.paths",description:`<strong>paths</strong> (<code>Union[List[str], str]</code>, <em>optional</em>) &#x2014;
The paths to get information about. If a path do not exist, it is ignored without raising
an exception.`,name:"paths"},{anchor:"huggingface_hub.HfApi.get_paths_info.expand",description:`<strong>expand</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to fetch more information about the paths (e.g. last commit and files&#x2019; security scan results). This
operation is more expensive for the server so only 50 results are returned per page (instead of 1000).
As pagination is implemented in <code>huggingface_hub</code>, this is transparent for you except for the time it
takes to get the results.`,name:"expand"},{anchor:"huggingface_hub.HfApi.get_paths_info.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the repository from which to get the information. Defaults to <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.get_paths_info.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repository from which to get the information (<code>&quot;model&quot;</code>, <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code>.
Defaults to <code>&quot;model&quot;</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.get_paths_info.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3349",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The information about the paths, as a list of <code>RepoFile</code> and <code>RepoFolder</code> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Union[RepoFile, RepoFolder]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private but not authenticated or repo
does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If revision is not found (error 404) on the repo.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a></p>
`}}),Da=new C({props:{anchor:"huggingface_hub.HfApi.get_paths_info.example",$$slots:{default:[cU]},$$scope:{ctx:T}}}),Ti=new q({props:{name:"get_repo_discussions",anchor:"huggingface_hub.HfApi.get_repo_discussions",parameters:[{name:"repo_id",val:": str"},{name:"author",val:": Optional[str] = None"},{name:"discussion_type",val:": Optional[constants.DiscussionTypeFilter] = None"},{name:"discussion_status",val:": Optional[constants.DiscussionStatusFilter] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_repo_discussions.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.get_repo_discussions.author",description:`<strong>author</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass a value to filter by discussion author. <code>None</code> means no filter.
Default is <code>None</code>.`,name:"author"},{anchor:"huggingface_hub.HfApi.get_repo_discussions.discussion_type",description:`<strong>discussion_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;pull_request&quot;</code> to fetch only pull requests, <code>&quot;discussion&quot;</code>
to fetch only discussions. Set to <code>&quot;all&quot;</code> or <code>None</code> to fetch both.
Default is <code>None</code>.`,name:"discussion_type"},{anchor:"huggingface_hub.HfApi.get_repo_discussions.discussion_status",description:`<strong>discussion_status</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;open&quot;</code> (respectively <code>&quot;closed&quot;</code>) to fetch only open
(respectively closed) discussions. Set to <code>&quot;all&quot;</code> or <code>None</code>
to fetch both.
Default is <code>None</code>.`,name:"discussion_status"},{anchor:"huggingface_hub.HfApi.get_repo_discussions.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if fetching from a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if fetching from a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.get_repo_discussions.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6223",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An iterator of <a
  href="/docs/huggingface_hub/main/ko/package_reference/community#huggingface_hub.Discussion"
>Discussion</a> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterator[Discussion]</code></p>
`}}),Ra=new C({props:{anchor:"huggingface_hub.HfApi.get_repo_discussions.example",$$slots:{default:[lU]},$$scope:{ctx:T}}}),Ga=new C({props:{anchor:"huggingface_hub.HfApi.get_repo_discussions.example-2",$$slots:{default:[pU]},$$scope:{ctx:T}}}),ji=new q({props:{name:"get_safetensors_metadata",anchor:"huggingface_hub.HfApi.get_safetensors_metadata",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_safetensors_metadata.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A user or an organization name and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.get_safetensors_metadata.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if the file is in a dataset or space, <code>None</code> or <code>&quot;model&quot;</code> if in a
model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.get_safetensors_metadata.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to fetch the file from. Can be a branch name, a tag, or a commit hash. Defaults to the
head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.get_safetensors_metadata.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5687",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information related to safetensors repo.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>SafetensorsRepoMetadata</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>NotASafetensorsRepoError</code> —
If the repo is not a safetensors repo i.e. doesn’t have either a
<code>model.safetensors</code> or a <code>model.safetensors.index.json</code> file.</li>
<li><code>SafetensorsParsingError</code> —
If a safetensors file header couldn’t be parsed correctly.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>NotASafetensorsRepoError</code> or <code>SafetensorsParsingError</code></p>
`}}),Za=new C({props:{anchor:"huggingface_hub.HfApi.get_safetensors_metadata.example",$$slots:{default:[dU]},$$scope:{ctx:T}}}),Mi=new q({props:{name:"get_space_runtime",anchor:"huggingface_hub.HfApi.get_space_runtime",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_space_runtime.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.get_space_runtime.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7153",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about a Space including Space stage and hardware.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`}}),qi=new q({props:{name:"get_space_variables",anchor:"huggingface_hub.HfApi.get_space_variables",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_space_variables.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to query. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.get_space_variables.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7061"}}),Ui=new q({props:{name:"get_token_permission",anchor:"huggingface_hub.HfApi.get_token_permission",parameters:[{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_token_permission.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1800",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Permission granted by the token (“read” or “write”). Returns <code>None</code> if no
token passed, if token is invalid or if role is not returned by the server. This typically happens when the token is an OAuth token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Literal["read", "write", "fineGrained", None]</code></p>
`}}),Sa=new I({props:{warning:!0,$$slots:{default:[gU]},$$scope:{ctx:T}}}),Hi=new q({props:{name:"get_user_overview",anchor:"huggingface_hub.HfApi.get_user_overview",parameters:[{name:"username",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_user_overview.username",description:`<strong>username</strong> (<code>str</code>) &#x2014;
Username of the user to get an overview of.`,name:"username"},{anchor:"huggingface_hub.HfApi.get_user_overview.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9727",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.User"
>User</a> object with the user’s overview.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>User</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 If the user does not exist on the Hub.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Ci=new q({props:{name:"get_webhook",anchor:"huggingface_hub.HfApi.get_webhook",parameters:[{name:"webhook_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_webhook.webhook_id",description:`<strong>webhook_id</strong> (<code>str</code>) &#x2014;
The unique identifier of the webhook to get.`,name:"webhook_id"},{anchor:"huggingface_hub.HfApi.get_webhook.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9173",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Info about the webhook.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>WebhookInfo</code></p>
`}}),Wa=new C({props:{anchor:"huggingface_hub.HfApi.get_webhook.example",$$slots:{default:[uU]},$$scope:{ctx:T}}}),Ii=new q({props:{name:"grant_access",anchor:"huggingface_hub.HfApi.grant_access",parameters:[{name:"repo_id",val:": str"},{name:"user",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.grant_access.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to grant access to.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.grant_access.user",description:`<strong>user</strong> (<code>str</code>) &#x2014;
The username of the user to grant access.`,name:"user"},{anchor:"huggingface_hub.HfApi.grant_access.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to grant access to. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.grant_access.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9118",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the user already has access to the repo.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user does not exist on the Hub.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Ji=new q({props:{name:"hf_hub_download",anchor:"huggingface_hub.HfApi.hf_hub_download",parameters:[{name:"repo_id",val:": str"},{name:"filename",val:": str"},{name:"subfolder",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"cache_dir",val:": Union[str, Path, None] = None"},{name:"local_dir",val:": Union[str, Path, None] = None"},{name:"force_download",val:": bool = False"},{name:"proxies",val:": Optional[Dict] = None"},{name:"etag_timeout",val:": float = 10"},{name:"token",val:": Union[bool, str, None] = None"},{name:"local_files_only",val:": bool = False"},{name:"resume_download",val:": Optional[bool] = None"},{name:"force_filename",val:": Optional[str] = None"},{name:"local_dir_use_symlinks",val:": Union[bool, Literal['auto']] = 'auto'"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.hf_hub_download.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A user or an organization name and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.hf_hub_download.filename",description:`<strong>filename</strong> (<code>str</code>) &#x2014;
The name of the file in the repo.`,name:"filename"},{anchor:"huggingface_hub.HfApi.hf_hub_download.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional value corresponding to a folder inside the repository.`,name:"subfolder"},{anchor:"huggingface_hub.HfApi.hf_hub_download.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if downloading from a dataset or space,
<code>None</code> or <code>&quot;model&quot;</code> if downloading from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.hf_hub_download.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional Git revision id which can be a branch name, a tag, or a
commit hash.`,name:"revision"},{anchor:"huggingface_hub.HfApi.hf_hub_download.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code>, <code>Path</code>, <em>optional</em>) &#x2014;
Path to the folder where cached files are stored.`,name:"cache_dir"},{anchor:"huggingface_hub.HfApi.hf_hub_download.local_dir",description:`<strong>local_dir</strong> (<code>str</code> or <code>Path</code>, <em>optional</em>) &#x2014;
If provided, the downloaded file will be placed under this directory.`,name:"local_dir"},{anchor:"huggingface_hub.HfApi.hf_hub_download.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the file should be downloaded even if it already exists in
the local cache.`,name:"force_download"},{anchor:"huggingface_hub.HfApi.hf_hub_download.proxies",description:`<strong>proxies</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary mapping protocol to the URL of the proxy passed to
<code>requests.request</code>.`,name:"proxies"},{anchor:"huggingface_hub.HfApi.hf_hub_download.etag_timeout",description:`<strong>etag_timeout</strong> (<code>float</code>, <em>optional</em>, defaults to <code>10</code>) &#x2014;
When fetching ETag, how many seconds to wait for the server to send
data before giving up which is passed to <code>requests.request</code>.`,name:"etag_timeout"},{anchor:"huggingface_hub.HfApi.hf_hub_download.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.hf_hub_download.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, avoid downloading the file and return the path to the
local cached file if it exists.`,name:"local_files_only"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5422",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Local path of file or if networking is off, last version of file cached on disk.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If the revision to download from cannot be found.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.EntryNotFoundError"
>EntryNotFoundError</a> —
If the file to download cannot be found.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.LocalEntryNotFoundError"
>LocalEntryNotFoundError</a> —
If network is disabled or unavailable and file is not found in cache.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#EnvironmentError"
  rel="nofollow"
><code>EnvironmentError</code></a> —
If <code>token=True</code> but the token cannot be found.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#OSError"
  rel="nofollow"
><code>OSError</code></a> —
If ETag cannot be determined.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If some parameter value is invalid.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.EntryNotFoundError"
>EntryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.LocalEntryNotFoundError"
>LocalEntryNotFoundError</a> or <code>EnvironmentError</code> or <code>OSError</code> or <code>ValueError</code></p>
`}}),Va=new C({props:{anchor:"huggingface_hub.HfApi.hf_hub_download.example",$$slots:{default:[hU]},$$scope:{ctx:T}}}),Ni=new q({props:{name:"hide_discussion_comment",anchor:"huggingface_hub.HfApi.hide_discussion_comment",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"comment_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.hide_discussion_comment.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.hide_discussion_comment.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.hide_discussion_comment.comment_id",description:`<strong>comment_id</strong> (<code>str</code>) &#x2014;
The ID of the comment to edit.`,name:"comment_id"},{anchor:"huggingface_hub.HfApi.hide_discussion_comment.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.hide_discussion_comment.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6932",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the hidden comment</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/community#huggingface_hub.DiscussionComment"
>DiscussionComment</a></p>
`}}),Ba=new I({props:{warning:!0,$$slots:{default:[fU]},$$scope:{ctx:T}}}),Pa=new I({props:{$$slots:{default:[mU]},$$scope:{ctx:T}}}),Ai=new q({props:{name:"inspect_job",anchor:"huggingface_hub.HfApi.inspect_job",parameters:[{name:"job_id",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.inspect_job.job_id",description:`<strong>job_id</strong> (<code>str</code>) &#x2014;
ID of the Job.`,name:"job_id"},{anchor:"huggingface_hub.HfApi.inspect_job.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Job is running. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.inspect_job.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L10174"}}),Ya=new C({props:{anchor:"huggingface_hub.HfApi.inspect_job.example",$$slots:{default:[_U]},$$scope:{ctx:T}}}),Ei=new q({props:{name:"inspect_scheduled_job",anchor:"huggingface_hub.HfApi.inspect_scheduled_job",parameters:[{name:"scheduled_job_id",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.inspect_scheduled_job.scheduled_job_id",description:`<strong>scheduled_job_id</strong> (<code>str</code>) &#x2014;
ID of the scheduled Job.`,name:"scheduled_job_id"},{anchor:"huggingface_hub.HfApi.inspect_scheduled_job.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the scheduled Job is. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.inspect_scheduled_job.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L10514"}}),Xa=new C({props:{anchor:"huggingface_hub.HfApi.inspect_scheduled_job.example",$$slots:{default:[bU]},$$scope:{ctx:T}}}),Di=new q({props:{name:"list_accepted_access_requests",anchor:"huggingface_hub.HfApi.list_accepted_access_requests",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_accepted_access_requests.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to get access requests for.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_accepted_access_requests.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to get access requests for. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_accepted_access_requests.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8802",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <code>AccessRequest</code> objects. Each time contains a <code>username</code>, <code>email</code>,
<code>status</code> and <code>timestamp</code> attribute. If the gated repo has a custom form, the <code>fields</code> attribute will
be populated with user’s answers.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AccessRequest]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Qa=new C({props:{anchor:"huggingface_hub.HfApi.list_accepted_access_requests.example",$$slots:{default:[yU]},$$scope:{ctx:T}}}),Ri=new q({props:{name:"list_collections",anchor:"huggingface_hub.HfApi.list_collections",parameters:[{name:"owner",val:": Union[List[str], str, None] = None"},{name:"item",val:": Union[List[str], str, None] = None"},{name:"sort",val:": Optional[Literal['lastModified', 'trending', 'upvotes']] = None"},{name:"limit",val:": Optional[int] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_collections.owner",description:`<strong>owner</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
Filter by owner&#x2019;s username.`,name:"owner"},{anchor:"huggingface_hub.HfApi.list_collections.item",description:`<strong>item</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
Filter collections containing a particular items. Example: <code>&quot;models/teknium/OpenHermes-2.5-Mistral-7B&quot;</code>, <code>&quot;datasets/squad&quot;</code> or <code>&quot;papers/2311.12983&quot;</code>.`,name:"item"},{anchor:"huggingface_hub.HfApi.list_collections.sort",description:`<strong>sort</strong> (<code>Literal[&quot;lastModified&quot;, &quot;trending&quot;, &quot;upvotes&quot;]</code>, <em>optional</em>) &#x2014;
Sort collections by last modified, trending or upvotes.`,name:"sort"},{anchor:"huggingface_hub.HfApi.list_collections.limit",description:`<strong>limit</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of collections to be returned.`,name:"limit"},{anchor:"huggingface_hub.HfApi.list_collections.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8272",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an iterable of <a
  href="/docs/huggingface_hub/main/ko/package_reference/collections#huggingface_hub.Collection"
>Collection</a> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[Collection]</code></p>
`}}),za=new I({props:{warning:!0,$$slots:{default:[vU]},$$scope:{ctx:T}}}),Gi=new q({props:{name:"list_datasets",anchor:"huggingface_hub.HfApi.list_datasets",parameters:[{name:"filter",val:": Union[str, Iterable[str], None] = None"},{name:"author",val:": Optional[str] = None"},{name:"benchmark",val:": Optional[Union[str, List[str]]] = None"},{name:"dataset_name",val:": Optional[str] = None"},{name:"gated",val:": Optional[bool] = None"},{name:"language_creators",val:": Optional[Union[str, List[str]]] = None"},{name:"language",val:": Optional[Union[str, List[str]]] = None"},{name:"multilinguality",val:": Optional[Union[str, List[str]]] = None"},{name:"size_categories",val:": Optional[Union[str, List[str]]] = None"},{name:"task_categories",val:": Optional[Union[str, List[str]]] = None"},{name:"task_ids",val:": Optional[Union[str, List[str]]] = None"},{name:"search",val:": Optional[str] = None"},{name:"sort",val:": Optional[Union[Literal['last_modified'], str]] = None"},{name:"direction",val:": Optional[Literal[-1]] = None"},{name:"limit",val:": Optional[int] = None"},{name:"expand",val:": Optional[List[ExpandDatasetProperty_T]] = None"},{name:"full",val:": Optional[bool] = None"},{name:"token",val:": Union[bool, str, None] = None"},{name:"tags",val:": Optional[Union[str, List[str]]] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_datasets.filter",description:`<strong>filter</strong> (<code>str</code> or <code>Iterable[str]</code>, <em>optional</em>) &#x2014;
A string or list of string to filter datasets on the hub.`,name:"filter"},{anchor:"huggingface_hub.HfApi.list_datasets.author",description:`<strong>author</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string which identify the author of the returned datasets.`,name:"author"},{anchor:"huggingface_hub.HfApi.list_datasets.benchmark",description:`<strong>benchmark</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings that can be used to identify datasets on
the Hub by their official benchmark.`,name:"benchmark"},{anchor:"huggingface_hub.HfApi.list_datasets.dataset_name",description:`<strong>dataset_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string or list of strings that can be used to identify datasets on
the Hub by its name, such as <code>SQAC</code> or <code>wikineural</code>`,name:"dataset_name"},{anchor:"huggingface_hub.HfApi.list_datasets.gated",description:`<strong>gated</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
A boolean to filter datasets on the Hub that are gated or not. By default, all datasets are returned.
If <code>gated=True</code> is passed, only gated datasets are returned.
If <code>gated=False</code> is passed, only non-gated datasets are returned.`,name:"gated"},{anchor:"huggingface_hub.HfApi.list_datasets.language_creators",description:`<strong>language_creators</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings that can be used to identify datasets on
the Hub with how the data was curated, such as <code>crowdsourced</code> or
<code>machine_generated</code>.`,name:"language_creators"},{anchor:"huggingface_hub.HfApi.list_datasets.language",description:`<strong>language</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings representing a two-character language to
filter datasets by on the Hub.`,name:"language"},{anchor:"huggingface_hub.HfApi.list_datasets.multilinguality",description:`<strong>multilinguality</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings representing a filter for datasets that
contain multiple languages.`,name:"multilinguality"},{anchor:"huggingface_hub.HfApi.list_datasets.size_categories",description:`<strong>size_categories</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings that can be used to identify datasets on
the Hub by the size of the dataset such as <code>100K&lt;n&lt;1M</code> or
<code>1M&lt;n&lt;10M</code>.`,name:"size_categories"},{anchor:"huggingface_hub.HfApi.list_datasets.tags",description:`<strong>tags</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
Deprecated. Pass tags in <code>filter</code> to filter datasets by tags.`,name:"tags"},{anchor:"huggingface_hub.HfApi.list_datasets.task_categories",description:`<strong>task_categories</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings that can be used to identify datasets on
the Hub by the designed task, such as <code>audio_classification</code> or
<code>named_entity_recognition</code>.`,name:"task_categories"},{anchor:"huggingface_hub.HfApi.list_datasets.task_ids",description:`<strong>task_ids</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings that can be used to identify datasets on
the Hub by the specific task such as <code>speech_emotion_recognition</code> or
<code>paraphrase</code>.`,name:"task_ids"},{anchor:"huggingface_hub.HfApi.list_datasets.search",description:`<strong>search</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string that will be contained in the returned datasets.`,name:"search"},{anchor:"huggingface_hub.HfApi.list_datasets.sort",description:`<strong>sort</strong> (<code>Literal[&quot;last_modified&quot;]</code> or <code>str</code>, <em>optional</em>) &#x2014;
The key with which to sort the resulting models. Possible values are &#x201C;last_modified&#x201D;, &#x201C;trending_score&#x201D;,
&#x201C;created_at&#x201D;, &#x201C;downloads&#x201D; and &#x201C;likes&#x201D;.`,name:"sort"},{anchor:"huggingface_hub.HfApi.list_datasets.direction",description:`<strong>direction</strong> (<code>Literal[-1]</code> or <code>int</code>, <em>optional</em>) &#x2014;
Direction in which to sort. The value <code>-1</code> sorts by descending
order while all other values sort by ascending order.`,name:"direction"},{anchor:"huggingface_hub.HfApi.list_datasets.limit",description:`<strong>limit</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The limit on the number of datasets fetched. Leaving this option
to <code>None</code> fetches all datasets.`,name:"limit"},{anchor:"huggingface_hub.HfApi.list_datasets.expand",description:`<strong>expand</strong> (<code>List[ExpandDatasetProperty_T]</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>full</code> is passed.
Possible values are <code>&quot;author&quot;</code>, <code>&quot;cardData&quot;</code>, <code>&quot;citation&quot;</code>, <code>&quot;createdAt&quot;</code>, <code>&quot;disabled&quot;</code>, <code>&quot;description&quot;</code>, <code>&quot;downloads&quot;</code>, <code>&quot;downloadsAllTime&quot;</code>, <code>&quot;gated&quot;</code>, <code>&quot;lastModified&quot;</code>, <code>&quot;likes&quot;</code>, <code>&quot;paperswithcode_id&quot;</code>, <code>&quot;private&quot;</code>, <code>&quot;siblings&quot;</code>, <code>&quot;sha&quot;</code>, <code>&quot;tags&quot;</code>, <code>&quot;trendingScore&quot;</code>, <code>&quot;usedStorage&quot;</code>, <code>&quot;resourceGroup&quot;</code> and <code>&quot;xetEnabled&quot;</code>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.list_datasets.full",description:`<strong>full</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to fetch all dataset data, including the <code>last_modified</code>,
the <code>card_data</code> and  the files. Can contain useful information such as the
PapersWithCode ID.`,name:"full"},{anchor:"huggingface_hub.HfApi.list_datasets.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2086",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an iterable of <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.DatasetInfo"
>huggingface_hub.hf_api.DatasetInfo</a> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[DatasetInfo]</code></p>
`}}),Oa=new C({props:{anchor:"huggingface_hub.HfApi.list_datasets.example",$$slots:{default:[xU]},$$scope:{ctx:T}}}),Ka=new C({props:{anchor:"huggingface_hub.HfApi.list_datasets.example-2",$$slots:{default:[$U]},$$scope:{ctx:T}}}),Zi=new q({props:{name:"list_inference_catalog",anchor:"huggingface_hub.HfApi.list_inference_catalog",parameters:[{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_inference_catalog.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7897",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of model IDs available in the catalog.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List<code>str</code></p>
`}}),es=new I({props:{warning:!0,$$slots:{default:[wU]},$$scope:{ctx:T}}}),Fi=new q({props:{name:"list_inference_endpoints",anchor:"huggingface_hub.HfApi.list_inference_endpoints",parameters:[{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_inference_endpoints.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace to list endpoints for. Defaults to the current user. Set to <code>&quot;*&quot;</code> to list all endpoints
from all namespaces (i.e. personal namespace and all orgs the user belongs to).`,name:"namespace"},{anchor:"huggingface_hub.HfApi.list_inference_endpoints.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7555",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of all inference endpoints for the given namespace.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List<a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),ts=new C({props:{anchor:"huggingface_hub.HfApi.list_inference_endpoints.example",$$slots:{default:[kU]},$$scope:{ctx:T}}}),Si=new q({props:{name:"list_jobs",anchor:"huggingface_hub.HfApi.list_jobs",parameters:[{name:"timeout",val:": Optional[int] = None"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_jobs.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Whether to set a timeout for the request to the Hub.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.list_jobs.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace from where it lists the jobs. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.list_jobs.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L10142"}}),Li=new q({props:{name:"list_lfs_files",anchor:"huggingface_hub.HfApi.list_lfs_files",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_lfs_files.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository for which you are listing LFS files.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_lfs_files.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Type of repository. Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if listing from a dataset or space, <code>None</code> or
<code>&quot;model&quot;</code> if listing from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_lfs_files.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3512",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An iterator of <code>LFSFileInfo</code> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[LFSFileInfo]</code></p>
`}}),os=new C({props:{anchor:"huggingface_hub.HfApi.list_lfs_files.example",$$slots:{default:[TU]},$$scope:{ctx:T}}}),Wi=new q({props:{name:"list_liked_repos",anchor:"huggingface_hub.HfApi.list_liked_repos",parameters:[{name:"user",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_liked_repos.user",description:`<strong>user</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of the user for which you want to fetch the likes.`,name:"user"},{anchor:"huggingface_hub.HfApi.list_liked_repos.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2460",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>object containing the user name and 3 lists of repo ids (1 for
models, 1 for datasets and 1 for Spaces).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.UserLikes"
>UserLikes</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If <code>user</code> is not passed and no token found (either from argument or from machine).</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),as=new C({props:{anchor:"huggingface_hub.HfApi.list_liked_repos.example",$$slots:{default:[jU]},$$scope:{ctx:T}}}),Vi=new q({props:{name:"list_models",anchor:"huggingface_hub.HfApi.list_models",parameters:[{name:"filter",val:": Union[str, Iterable[str], None] = None"},{name:"author",val:": Optional[str] = None"},{name:"apps",val:": Optional[Union[str, List[str]]] = None"},{name:"gated",val:": Optional[bool] = None"},{name:"inference",val:": Optional[Literal['warm']] = None"},{name:"inference_provider",val:": Optional[Union[Literal['all'], 'PROVIDER_T', List['PROVIDER_T']]] = None"},{name:"model_name",val:": Optional[str] = None"},{name:"trained_dataset",val:": Optional[Union[str, List[str]]] = None"},{name:"search",val:": Optional[str] = None"},{name:"pipeline_tag",val:": Optional[str] = None"},{name:"emissions_thresholds",val:": Optional[Tuple[float, float]] = None"},{name:"sort",val:": Union[Literal['last_modified'], str, None] = None"},{name:"direction",val:": Optional[Literal[-1]] = None"},{name:"limit",val:": Optional[int] = None"},{name:"expand",val:": Optional[List[ExpandModelProperty_T]] = None"},{name:"full",val:": Optional[bool] = None"},{name:"cardData",val:": bool = False"},{name:"fetch_config",val:": bool = False"},{name:"token",val:": Union[bool, str, None] = None"},{name:"language",val:": Optional[Union[str, List[str]]] = None"},{name:"library",val:": Optional[Union[str, List[str]]] = None"},{name:"tags",val:": Optional[Union[str, List[str]]] = None"},{name:"task",val:": Optional[Union[str, List[str]]] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_models.filter",description:`<strong>filter</strong> (<code>str</code> or <code>Iterable[str]</code>, <em>optional</em>) &#x2014;
A string or list of string to filter models on the Hub.
Models can be filtered by library, language, task, tags, and more.`,name:"filter"},{anchor:"huggingface_hub.HfApi.list_models.author",description:`<strong>author</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string which identify the author (user or organization) of the
returned models.`,name:"author"},{anchor:"huggingface_hub.HfApi.list_models.apps",description:`<strong>apps</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings to filter models on the Hub that
support the specified apps. Example values include <code>&quot;ollama&quot;</code> or <code>[&quot;ollama&quot;, &quot;vllm&quot;]</code>.`,name:"apps"},{anchor:"huggingface_hub.HfApi.list_models.gated",description:`<strong>gated</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
A boolean to filter models on the Hub that are gated or not. By default, all models are returned.
If <code>gated=True</code> is passed, only gated models are returned.
If <code>gated=False</code> is passed, only non-gated models are returned.`,name:"gated"},{anchor:"huggingface_hub.HfApi.list_models.inference",description:`<strong>inference</strong> (<code>Literal[&quot;warm&quot;]</code>, <em>optional</em>) &#x2014;
If &#x201C;warm&#x201D;, filter models on the Hub currently served by at least one provider.`,name:"inference"},{anchor:"huggingface_hub.HfApi.list_models.inference_provider",description:`<strong>inference_provider</strong> (<code>Literal[&quot;all&quot;]</code> or <code>str</code>, <em>optional</em>) &#x2014;
A string to filter models on the Hub that are served by a specific provider.
Pass <code>&quot;all&quot;</code> to get all models served by at least one provider.`,name:"inference_provider"},{anchor:"huggingface_hub.HfApi.list_models.library",description:`<strong>library</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
Deprecated. Pass a library name in <code>filter</code> to filter models by library.`,name:"library"},{anchor:"huggingface_hub.HfApi.list_models.language",description:`<strong>language</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
Deprecated. Pass a language in <code>filter</code> to filter models by language.`,name:"language"},{anchor:"huggingface_hub.HfApi.list_models.model_name",description:`<strong>model_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string that contain complete or partial names for models on the
Hub, such as &#x201C;bert&#x201D; or &#x201C;bert-base-cased&#x201D;`,name:"model_name"},{anchor:"huggingface_hub.HfApi.list_models.task",description:`<strong>task</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
Deprecated. Pass a task in <code>filter</code> to filter models by task.`,name:"task"},{anchor:"huggingface_hub.HfApi.list_models.trained_dataset",description:`<strong>trained_dataset</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string tag or a list of string tags of the trained dataset for a
model on the Hub.`,name:"trained_dataset"},{anchor:"huggingface_hub.HfApi.list_models.tags",description:`<strong>tags</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
Deprecated. Pass tags in <code>filter</code> to filter models by tags.`,name:"tags"},{anchor:"huggingface_hub.HfApi.list_models.search",description:`<strong>search</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string that will be contained in the returned model ids.`,name:"search"},{anchor:"huggingface_hub.HfApi.list_models.pipeline_tag",description:`<strong>pipeline_tag</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string pipeline tag to filter models on the Hub by, such as <code>summarization</code>.`,name:"pipeline_tag"},{anchor:"huggingface_hub.HfApi.list_models.emissions_thresholds",description:`<strong>emissions_thresholds</strong> (<code>Tuple</code>, <em>optional</em>) &#x2014;
A tuple of two ints or floats representing a minimum and maximum
carbon footprint to filter the resulting models with in grams.`,name:"emissions_thresholds"},{anchor:"huggingface_hub.HfApi.list_models.sort",description:`<strong>sort</strong> (<code>Literal[&quot;last_modified&quot;]</code> or <code>str</code>, <em>optional</em>) &#x2014;
The key with which to sort the resulting models. Possible values are &#x201C;last_modified&#x201D;, &#x201C;trending_score&#x201D;,
&#x201C;created_at&#x201D;, &#x201C;downloads&#x201D; and &#x201C;likes&#x201D;.`,name:"sort"},{anchor:"huggingface_hub.HfApi.list_models.direction",description:`<strong>direction</strong> (<code>Literal[-1]</code> or <code>int</code>, <em>optional</em>) &#x2014;
Direction in which to sort. The value <code>-1</code> sorts by descending
order while all other values sort by ascending order.`,name:"direction"},{anchor:"huggingface_hub.HfApi.list_models.limit",description:`<strong>limit</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The limit on the number of models fetched. Leaving this option
to <code>None</code> fetches all models.`,name:"limit"},{anchor:"huggingface_hub.HfApi.list_models.expand",description:`<strong>expand</strong> (<code>List[ExpandModelProperty_T]</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>full</code>, <code>cardData</code> or <code>fetch_config</code> are passed.
Possible values are <code>&quot;author&quot;</code>, <code>&quot;cardData&quot;</code>, <code>&quot;config&quot;</code>, <code>&quot;createdAt&quot;</code>, <code>&quot;disabled&quot;</code>, <code>&quot;downloads&quot;</code>, <code>&quot;downloadsAllTime&quot;</code>, <code>&quot;gated&quot;</code>, <code>&quot;gguf&quot;</code>, <code>&quot;inference&quot;</code>, <code>&quot;inferenceProviderMapping&quot;</code>, <code>&quot;lastModified&quot;</code>, <code>&quot;library_name&quot;</code>, <code>&quot;likes&quot;</code>, <code>&quot;mask_token&quot;</code>, <code>&quot;model-index&quot;</code>, <code>&quot;pipeline_tag&quot;</code>, <code>&quot;private&quot;</code>, <code>&quot;safetensors&quot;</code>, <code>&quot;sha&quot;</code>, <code>&quot;siblings&quot;</code>, <code>&quot;spaces&quot;</code>, <code>&quot;tags&quot;</code>, <code>&quot;transformersInfo&quot;</code>, <code>&quot;trendingScore&quot;</code>, <code>&quot;widgetData&quot;</code>, <code>&quot;resourceGroup&quot;</code> and <code>&quot;xetEnabled&quot;</code>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.list_models.full",description:`<strong>full</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to fetch all model data, including the <code>last_modified</code>,
the <code>sha</code>, the files and the <code>tags</code>. This is set to <code>True</code> by
default when using a filter.`,name:"full"},{anchor:"huggingface_hub.HfApi.list_models.cardData",description:`<strong>cardData</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to grab the metadata for the model as well. Can contain
useful information such as carbon emissions, metrics, and
datasets trained on.`,name:"cardData"},{anchor:"huggingface_hub.HfApi.list_models.fetch_config",description:`<strong>fetch_config</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to fetch the model configs as well. This is not included
in <code>full</code> due to its size.`,name:"fetch_config"},{anchor:"huggingface_hub.HfApi.list_models.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1858",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an iterable of <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.ModelInfo"
>huggingface_hub.hf_api.ModelInfo</a> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[ModelInfo]</code></p>
`}}),ss=new C({props:{anchor:"huggingface_hub.HfApi.list_models.example",$$slots:{default:[MU]},$$scope:{ctx:T}}}),Bi=new q({props:{name:"list_organization_members",anchor:"huggingface_hub.HfApi.list_organization_members",parameters:[{name:"organization",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_organization_members.organization",description:`<strong>organization</strong> (<code>str</code>) &#x2014;
Name of the organization to get the members of.`,name:"organization"},{anchor:"huggingface_hub.HfApi.list_organization_members.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9753",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.User"
>User</a> objects with the members of the organization.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[User]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 If the organization does not exist on the Hub.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Pi=new q({props:{name:"list_papers",anchor:"huggingface_hub.HfApi.list_papers",parameters:[{name:"query",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_papers.query",description:`<strong>query</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A search query string to find papers.
If provided, returns papers that match the query.`,name:"query"},{anchor:"huggingface_hub.HfApi.list_papers.token",description:`<strong>token</strong> (Union[bool, str, None], <em>optional</em>) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9837",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an iterable of <code>huggingface_hub.hf_api.PaperInfo</code> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[PaperInfo]</code></p>
`}}),is=new C({props:{anchor:"huggingface_hub.HfApi.list_papers.example",$$slots:{default:[qU]},$$scope:{ctx:T}}}),Yi=new q({props:{name:"list_pending_access_requests",anchor:"huggingface_hub.HfApi.list_pending_access_requests",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_pending_access_requests.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to get access requests for.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_pending_access_requests.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to get access requests for. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_pending_access_requests.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8738",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <code>AccessRequest</code> objects. Each time contains a <code>username</code>, <code>email</code>,
<code>status</code> and <code>timestamp</code> attribute. If the gated repo has a custom form, the <code>fields</code> attribute will
be populated with user’s answers.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AccessRequest]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),cs=new C({props:{anchor:"huggingface_hub.HfApi.list_pending_access_requests.example",$$slots:{default:[UU]},$$scope:{ctx:T}}}),Xi=new q({props:{name:"list_rejected_access_requests",anchor:"huggingface_hub.HfApi.list_rejected_access_requests",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_rejected_access_requests.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to get access requests for.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_rejected_access_requests.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to get access requests for. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_rejected_access_requests.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8864",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <code>AccessRequest</code> objects. Each time contains a <code>username</code>, <code>email</code>,
<code>status</code> and <code>timestamp</code> attribute. If the gated repo has a custom form, the <code>fields</code> attribute will
be populated with user’s answers.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AccessRequest]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),ls=new C({props:{anchor:"huggingface_hub.HfApi.list_rejected_access_requests.example",$$slots:{default:[HU]},$$scope:{ctx:T}}}),Qi=new q({props:{name:"list_repo_commits",anchor:"huggingface_hub.HfApi.list_repo_commits",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"},{name:"revision",val:": Optional[str] = None"},{name:"formatted",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_repo_commits.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_repo_commits.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if listing commits from a dataset or a Space, <code>None</code> or <code>&quot;model&quot;</code> if
listing from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_repo_commits.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.list_repo_commits.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.list_repo_commits.formatted",description:`<strong>formatted</strong> (<code>bool</code>) &#x2014;
Whether to return the HTML-formatted title and description of the commits. Defaults to False.`,name:"formatted"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3263",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list of objects containing information about the commits for a repo on the Hub.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List[<a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.GitCommitInfo"
>GitCommitInfo</a>]</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private but not authenticated or repo
does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If revision is not found (error 404) on the repo.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a></p>
`}}),ps=new C({props:{anchor:"huggingface_hub.HfApi.list_repo_commits.example",$$slots:{default:[CU]},$$scope:{ctx:T}}}),zi=new q({props:{name:"list_repo_files",anchor:"huggingface_hub.HfApi.list_repo_files",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_repo_files.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_repo_files.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the repository from which to get the information.`,name:"revision"},{anchor:"huggingface_hub.HfApi.list_repo_files.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to
a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_repo_files.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3022",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the list of files in a given repository.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[str]</code></p>
`}}),Oi=new q({props:{name:"list_repo_likers",anchor:"huggingface_hub.HfApi.list_repo_likers",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_repo_likers.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository to retrieve . Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_repo_likers.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.list_repo_likers.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2536",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an iterable of <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.User"
>huggingface_hub.hf_api.User</a> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[User]</code></p>
`}}),Ki=new q({props:{name:"list_repo_refs",anchor:"huggingface_hub.HfApi.list_repo_refs",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"include_pull_requests",val:": bool = False"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_repo_refs.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_repo_refs.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if listing refs from a dataset or a Space,
<code>None</code> or <code>&quot;model&quot;</code> if listing from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_repo_refs.include_pull_requests",description:`<strong>include_pull_requests</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to include refs from pull requests in the list. Defaults to <code>False</code>.`,name:"include_pull_requests"},{anchor:"huggingface_hub.HfApi.list_repo_refs.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3191",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>object containing all information about branches and tags for a
repo on the Hub.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.GitRefs"
>GitRefs</a></p>
`}}),gs=new C({props:{anchor:"huggingface_hub.HfApi.list_repo_refs.example",$$slots:{default:[IU]},$$scope:{ctx:T}}}),ec=new q({props:{name:"list_repo_tree",anchor:"huggingface_hub.HfApi.list_repo_tree",parameters:[{name:"repo_id",val:": str"},{name:"path_in_repo",val:": Optional[str] = None"},{name:"recursive",val:": bool = False"},{name:"expand",val:": bool = False"},{name:"revision",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_repo_tree.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_repo_tree.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Relative path of the tree (folder) in the repo, for example:
<code>&quot;checkpoints/1fec34a/results&quot;</code>. Will default to the root tree (folder) of the repository.`,name:"path_in_repo"},{anchor:"huggingface_hub.HfApi.list_repo_tree.recursive",description:`<strong>recursive</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to list tree&#x2019;s files and folders recursively.`,name:"recursive"},{anchor:"huggingface_hub.HfApi.list_repo_tree.expand",description:`<strong>expand</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to fetch more information about the tree&#x2019;s files and folders (e.g. last commit and files&#x2019; security scan results). This
operation is more expensive for the server so only 50 results are returned per page (instead of 1000).
As pagination is implemented in <code>huggingface_hub</code>, this is transparent for you except for the time it
takes to get the results.`,name:"expand"},{anchor:"huggingface_hub.HfApi.list_repo_tree.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the repository from which to get the tree. Defaults to <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.list_repo_tree.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repository from which to get the tree (<code>&quot;model&quot;</code>, <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code>.
Defaults to <code>&quot;model&quot;</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_repo_tree.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3059",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The information about the tree’s files and folders, as an iterable of <code>RepoFile</code> and <code>RepoFolder</code> objects. The order of the files and folders is
not guaranteed.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[Union[RepoFile, RepoFolder]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private but not authenticated or repo
does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If revision is not found (error 404) on the repo.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.EntryNotFoundError"
>EntryNotFoundError</a> —
If the tree (folder) does not exist (error 404) on the repo.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.EntryNotFoundError"
>EntryNotFoundError</a></p>
`}}),us=new C({props:{anchor:"huggingface_hub.HfApi.list_repo_tree.example",$$slots:{default:[JU]},$$scope:{ctx:T}}}),hs=new C({props:{anchor:"huggingface_hub.HfApi.list_repo_tree.example-2",$$slots:{default:[NU]},$$scope:{ctx:T}}}),tc=new q({props:{name:"list_scheduled_jobs",anchor:"huggingface_hub.HfApi.list_scheduled_jobs",parameters:[{name:"timeout",val:": Optional[int] = None"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_scheduled_jobs.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Whether to set a timeout for the request to the Hub.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.list_scheduled_jobs.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace from where it lists the jobs. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.list_scheduled_jobs.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L10482"}}),nc=new q({props:{name:"list_spaces",anchor:"huggingface_hub.HfApi.list_spaces",parameters:[{name:"filter",val:": Union[str, Iterable[str], None] = None"},{name:"author",val:": Optional[str] = None"},{name:"search",val:": Optional[str] = None"},{name:"datasets",val:": Union[str, Iterable[str], None] = None"},{name:"models",val:": Union[str, Iterable[str], None] = None"},{name:"linked",val:": bool = False"},{name:"sort",val:": Union[Literal['last_modified'], str, None] = None"},{name:"direction",val:": Optional[Literal[-1]] = None"},{name:"limit",val:": Optional[int] = None"},{name:"expand",val:": Optional[List[ExpandSpaceProperty_T]] = None"},{name:"full",val:": Optional[bool] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_spaces.filter",description:`<strong>filter</strong> (<code>str</code> or <code>Iterable</code>, <em>optional</em>) &#x2014;
A string tag or list of tags that can be used to identify Spaces on the Hub.`,name:"filter"},{anchor:"huggingface_hub.HfApi.list_spaces.author",description:`<strong>author</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string which identify the author of the returned Spaces.`,name:"author"},{anchor:"huggingface_hub.HfApi.list_spaces.search",description:`<strong>search</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string that will be contained in the returned Spaces.`,name:"search"},{anchor:"huggingface_hub.HfApi.list_spaces.datasets",description:`<strong>datasets</strong> (<code>str</code> or <code>Iterable</code>, <em>optional</em>) &#x2014;
Whether to return Spaces that make use of a dataset.
The name of a specific dataset can be passed as a string.`,name:"datasets"},{anchor:"huggingface_hub.HfApi.list_spaces.models",description:`<strong>models</strong> (<code>str</code> or <code>Iterable</code>, <em>optional</em>) &#x2014;
Whether to return Spaces that make use of a model.
The name of a specific model can be passed as a string.`,name:"models"},{anchor:"huggingface_hub.HfApi.list_spaces.linked",description:`<strong>linked</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return Spaces that make use of either a model or a dataset.`,name:"linked"},{anchor:"huggingface_hub.HfApi.list_spaces.sort",description:`<strong>sort</strong> (<code>Literal[&quot;last_modified&quot;]</code> or <code>str</code>, <em>optional</em>) &#x2014;
The key with which to sort the resulting models. Possible values are &#x201C;last_modified&#x201D;, &#x201C;trending_score&#x201D;,
&#x201C;created_at&#x201D; and &#x201C;likes&#x201D;.`,name:"sort"},{anchor:"huggingface_hub.HfApi.list_spaces.direction",description:`<strong>direction</strong> (<code>Literal[-1]</code> or <code>int</code>, <em>optional</em>) &#x2014;
Direction in which to sort. The value <code>-1</code> sorts by descending
order while all other values sort by ascending order.`,name:"direction"},{anchor:"huggingface_hub.HfApi.list_spaces.limit",description:`<strong>limit</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The limit on the number of Spaces fetched. Leaving this option
to <code>None</code> fetches all Spaces.`,name:"limit"},{anchor:"huggingface_hub.HfApi.list_spaces.expand",description:`<strong>expand</strong> (<code>List[ExpandSpaceProperty_T]</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>full</code> is passed.
Possible values are <code>&quot;author&quot;</code>, <code>&quot;cardData&quot;</code>, <code>&quot;datasets&quot;</code>, <code>&quot;disabled&quot;</code>, <code>&quot;lastModified&quot;</code>, <code>&quot;createdAt&quot;</code>, <code>&quot;likes&quot;</code>, <code>&quot;models&quot;</code>, <code>&quot;private&quot;</code>, <code>&quot;runtime&quot;</code>, <code>&quot;sdk&quot;</code>, <code>&quot;siblings&quot;</code>, <code>&quot;sha&quot;</code>, <code>&quot;subdomain&quot;</code>, <code>&quot;tags&quot;</code>, <code>&quot;trendingScore&quot;</code>, <code>&quot;usedStorage&quot;</code>, <code>&quot;resourceGroup&quot;</code> and <code>&quot;xetEnabled&quot;</code>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.list_spaces.full",description:`<strong>full</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to fetch all Spaces data, including the <code>last_modified</code>, <code>siblings</code>
and <code>card_data</code> fields.`,name:"full"},{anchor:"huggingface_hub.HfApi.list_spaces.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2299",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an iterable of <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.SpaceInfo"
>huggingface_hub.hf_api.SpaceInfo</a> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[SpaceInfo]</code></p>
`}}),oc=new q({props:{name:"list_user_followers",anchor:"huggingface_hub.HfApi.list_user_followers",parameters:[{name:"username",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_user_followers.username",description:`<strong>username</strong> (<code>str</code>) &#x2014;
Username of the user to get the followers of.`,name:"username"},{anchor:"huggingface_hub.HfApi.list_user_followers.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9781",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.User"
>User</a> objects with the followers of the user.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[User]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 If the user does not exist on the Hub.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),ac=new q({props:{name:"list_user_following",anchor:"huggingface_hub.HfApi.list_user_following",parameters:[{name:"username",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_user_following.username",description:`<strong>username</strong> (<code>str</code>) &#x2014;
Username of the user to get the users followed by.`,name:"username"},{anchor:"huggingface_hub.HfApi.list_user_following.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9809",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.User"
>User</a> objects with the users followed by the user.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[User]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 If the user does not exist on the Hub.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),sc=new q({props:{name:"list_webhooks",anchor:"huggingface_hub.HfApi.list_webhooks",parameters:[{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_webhooks.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9224",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of webhook info objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[WebhookInfo]</code></p>
`}}),ys=new C({props:{anchor:"huggingface_hub.HfApi.list_webhooks.example",$$slots:{default:[AU]},$$scope:{ctx:T}}}),rc=new q({props:{name:"merge_pull_request",anchor:"huggingface_hub.HfApi.merge_pull_request",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"token",val:": Union[bool, str, None] = None"},{name:"comment",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.merge_pull_request.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.merge_pull_request.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.merge_pull_request.comment",description:`<strong>comment</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional comment to post with the status change.`,name:"comment"},{anchor:"huggingface_hub.HfApi.merge_pull_request.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.merge_pull_request.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6816",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the status change event</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/community#huggingface_hub.DiscussionStatusChange"
>DiscussionStatusChange</a></p>
`}}),vs=new I({props:{$$slots:{default:[EU]},$$scope:{ctx:T}}}),ic=new q({props:{name:"model_info",anchor:"huggingface_hub.HfApi.model_info",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"timeout",val:": Optional[float] = None"},{name:"securityStatus",val:": Optional[bool] = None"},{name:"files_metadata",val:": bool = False"},{name:"expand",val:": Optional[List[ExpandModelProperty_T]] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.model_info.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.model_info.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the model repository from which to get the
information.`,name:"revision"},{anchor:"huggingface_hub.HfApi.model_info.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Whether to set a timeout for the request to the Hub.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.model_info.securityStatus",description:`<strong>securityStatus</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to retrieve the security status from the model
repository as well. The security status will be returned in the <code>security_repo_status</code> field.`,name:"securityStatus"},{anchor:"huggingface_hub.HfApi.model_info.files_metadata",description:`<strong>files_metadata</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to retrieve metadata for files in the repository
(size, LFS metadata, etc). Defaults to <code>False</code>.`,name:"files_metadata"},{anchor:"huggingface_hub.HfApi.model_info.expand",description:`<strong>expand</strong> (<code>List[ExpandModelProperty_T]</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>securityStatus</code> or <code>files_metadata</code> are passed.
Possible values are <code>&quot;author&quot;</code>, <code>&quot;baseModels&quot;</code>, <code>&quot;cardData&quot;</code>, <code>&quot;childrenModelCount&quot;</code>, <code>&quot;config&quot;</code>, <code>&quot;createdAt&quot;</code>, <code>&quot;disabled&quot;</code>, <code>&quot;downloads&quot;</code>, <code>&quot;downloadsAllTime&quot;</code>, <code>&quot;gated&quot;</code>, <code>&quot;gguf&quot;</code>, <code>&quot;inference&quot;</code>, <code>&quot;inferenceProviderMapping&quot;</code>, <code>&quot;lastModified&quot;</code>, <code>&quot;library_name&quot;</code>, <code>&quot;likes&quot;</code>, <code>&quot;mask_token&quot;</code>, <code>&quot;model-index&quot;</code>, <code>&quot;pipeline_tag&quot;</code>, <code>&quot;private&quot;</code>, <code>&quot;safetensors&quot;</code>, <code>&quot;sha&quot;</code>, <code>&quot;siblings&quot;</code>, <code>&quot;spaces&quot;</code>, <code>&quot;tags&quot;</code>, <code>&quot;transformersInfo&quot;</code>, <code>&quot;trendingScore&quot;</code>, <code>&quot;widgetData&quot;</code>, <code>&quot;usedStorage&quot;</code>, <code>&quot;resourceGroup&quot;</code> and <code>&quot;xetEnabled&quot;</code>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.model_info.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2575",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The model repository information.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.ModelInfo"
>huggingface_hub.hf_api.ModelInfo</a></p>
`}}),xs=new I({props:{$$slots:{default:[DU]},$$scope:{ctx:T}}}),cc=new q({props:{name:"move_repo",anchor:"huggingface_hub.HfApi.move_repo",parameters:[{name:"from_id",val:": str"},{name:"to_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.move_repo.from_id",description:`<strong>from_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>. Original repository identifier.`,name:"from_id"},{anchor:"huggingface_hub.HfApi.move_repo.to_id",description:`<strong>to_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>. Final repository identifier.`,name:"to_id"},{anchor:"huggingface_hub.HfApi.move_repo.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.move_repo.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3972"}}),$s=new I({props:{$$slots:{default:[RU]},$$scope:{ctx:T}}}),lc=new q({props:{name:"paper_info",anchor:"huggingface_hub.HfApi.paper_info",parameters:[{name:"id",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.paper_info.id",description:`<strong>id</strong> (<code>str</code>, <strong>optional</strong>) &#x2014;
ArXiv id of the paper.`,name:"id"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9883",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>PaperInfo</code> object.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PaperInfo</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 If the paper does not exist on the Hub.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),pc=new q({props:{name:"parse_safetensors_file_metadata",anchor:"huggingface_hub.HfApi.parse_safetensors_file_metadata",parameters:[{name:"repo_id",val:": str"},{name:"filename",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.parse_safetensors_file_metadata.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A user or an organization name and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.parse_safetensors_file_metadata.filename",description:`<strong>filename</strong> (<code>str</code>) &#x2014;
The name of the file in the repo.`,name:"filename"},{anchor:"huggingface_hub.HfApi.parse_safetensors_file_metadata.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if the file is in a dataset or space, <code>None</code> or <code>&quot;model&quot;</code> if in a
model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.parse_safetensors_file_metadata.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to fetch the file from. Can be a branch name, a tag, or a commit hash. Defaults to the
head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.parse_safetensors_file_metadata.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5827",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information related to a safetensors file.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>SafetensorsFileMetadata</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>NotASafetensorsRepoError</code> —
If the repo is not a safetensors repo i.e. doesn’t have either a
<code>model.safetensors</code> or a <code>model.safetensors.index.json</code> file.</li>
<li><code>SafetensorsParsingError</code> —
If a safetensors file header couldn’t be parsed correctly.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>NotASafetensorsRepoError</code> or <code>SafetensorsParsingError</code></p>
`}}),dc=new q({props:{name:"pause_inference_endpoint",anchor:"huggingface_hub.HfApi.pause_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.pause_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The name of the Inference Endpoint to pause.`,name:"name"},{anchor:"huggingface_hub.HfApi.pause_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace in which the Inference Endpoint is located. Defaults to the current user.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.pause_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8142",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the paused Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),gc=new q({props:{name:"pause_space",anchor:"huggingface_hub.HfApi.pause_space",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.pause_space.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the Space to pause. Example: <code>&quot;Salesforce/BLIP2&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.pause_space.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7278",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about your Space including <code>stage=PAUSED</code> and requested hardware.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If your Space is not found (error 404). Most probably wrong repo_id or your space is private but you
are not authenticated.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
403 Forbidden: only the owner of a Space can pause it. If you want to manage a Space that you don’t
own, either ask the owner by opening a Discussion or duplicate the Space.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a> —
If your Space is a static Space. Static Spaces are always running and never billed. If you want to hide
a static Space, you can set it to private.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a></p>
`}}),uc=new q({props:{name:"permanently_delete_lfs_files",anchor:"huggingface_hub.HfApi.permanently_delete_lfs_files",parameters:[{name:"repo_id",val:": str"},{name:"lfs_files",val:": Iterable[LFSFileInfo]"},{name:"rewrite_history",val:": bool = True"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.permanently_delete_lfs_files.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository for which you are listing LFS files.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.permanently_delete_lfs_files.lfs_files",description:`<strong>lfs_files</strong> (<code>Iterable[LFSFileInfo]</code>) &#x2014;
An iterable of <code>LFSFileInfo</code> items to permanently delete from the repo. Use <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_lfs_files">list_lfs_files()</a> to list
all LFS files from a repo.`,name:"lfs_files"},{anchor:"huggingface_hub.HfApi.permanently_delete_lfs_files.rewrite_history",description:`<strong>rewrite_history</strong> (<code>bool</code>, <em>optional</em>, default to <code>True</code>) &#x2014;
Whether to rewrite repository history to remove file pointers referencing the deleted LFS files (recommended).`,name:"rewrite_history"},{anchor:"huggingface_hub.HfApi.permanently_delete_lfs_files.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Type of repository. Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if listing from a dataset or space, <code>None</code> or
<code>&quot;model&quot;</code> if listing from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.permanently_delete_lfs_files.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3566"}}),ks=new I({props:{warning:!0,$$slots:{default:[GU]},$$scope:{ctx:T}}}),Ts=new C({props:{anchor:"huggingface_hub.HfApi.permanently_delete_lfs_files.example",$$slots:{default:[ZU]},$$scope:{ctx:T}}}),hc=new q({props:{name:"preupload_lfs_files",anchor:"huggingface_hub.HfApi.preupload_lfs_files",parameters:[{name:"repo_id",val:": str"},{name:"additions",val:": Iterable[CommitOperationAdd]"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"num_threads",val:": int = 5"},{name:"free_memory",val:": bool = True"},{name:"gitignore_content",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.preupload_lfs_files.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository in which you will commit the files, for example: <code>&quot;username/custom_transformers&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.operations",description:`<strong>operations</strong> (<code>Iterable</code> of <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitOperationAdd">CommitOperationAdd</a>) &#x2014;
The list of files to upload. Warning: the objects in this list will be mutated to include information
relative to the upload. Do not reuse the same objects for multiple commits.`,name:"operations"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of repository to upload to (e.g. <code>&quot;model&quot;</code> -default-, <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code>).`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not you plan to create a Pull Request with that commit. Defaults to <code>False</code>.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.num_threads",description:`<strong>num_threads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of concurrent threads for uploading files. Defaults to 5.
Setting it to 2 means at most 2 files will be uploaded concurrently.`,name:"num_threads"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.gitignore_content",description:`<strong>gitignore_content</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The content of the <code>.gitignore</code> file to know which files should be ignored. The order of priority
is to first check if <code>gitignore_content</code> is passed, then check if the <code>.gitignore</code> file is present
in the list of files to commit and finally default to the <code>.gitignore</code> file already hosted on the Hub
(if any).`,name:"gitignore_content"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L4367"}}),js=new I({props:{warning:!0,$$slots:{default:[FU]},$$scope:{ctx:T}}}),Ms=new I({props:{warning:!0,$$slots:{default:[SU]},$$scope:{ctx:T}}}),qs=new C({props:{anchor:"huggingface_hub.HfApi.preupload_lfs_files.example",$$slots:{default:[LU]},$$scope:{ctx:T}}}),fc=new q({props:{name:"reject_access_request",anchor:"huggingface_hub.HfApi.reject_access_request",parameters:[{name:"repo_id",val:": str"},{name:"user",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"rejection_reason",val:": Optional[str]"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.reject_access_request.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to reject access request for.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.reject_access_request.user",description:`<strong>user</strong> (<code>str</code>) &#x2014;
The username of the user which access request should be rejected.`,name:"user"},{anchor:"huggingface_hub.HfApi.reject_access_request.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to reject access request for. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.reject_access_request.rejection_reason",description:`<strong>rejection_reason</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Optional rejection reason that will be visible to the user (max 200 characters).`,name:"rejection_reason"},{anchor:"huggingface_hub.HfApi.reject_access_request.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9037",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user does not exist on the Hub.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user access request cannot be found.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user access request is already in the rejected list.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),mc=new q({props:{name:"rename_discussion",anchor:"huggingface_hub.HfApi.rename_discussion",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"new_title",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.rename_discussion.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.rename_discussion.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.rename_discussion.new_title",description:`<strong>new_title</strong> (<code>str</code>) &#x2014;
The new title for the discussion`,name:"new_title"},{anchor:"huggingface_hub.HfApi.rename_discussion.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.rename_discussion.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6668",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the title change event</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/community#huggingface_hub.DiscussionTitleChange"
>DiscussionTitleChange</a></p>
`}}),Us=new C({props:{anchor:"huggingface_hub.HfApi.rename_discussion.example",$$slots:{default:[WU]},$$scope:{ctx:T}}}),Hs=new I({props:{$$slots:{default:[VU]},$$scope:{ctx:T}}}),_c=new q({props:{name:"repo_exists",anchor:"huggingface_hub.HfApi.repo_exists",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.repo_exists.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.repo_exists.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if getting repository info from a dataset or a space,
<code>None</code> or <code>&quot;model&quot;</code> if getting repository info from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.repo_exists.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2873",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if the repository exists, False otherwise.</p>
`}}),Cs=new C({props:{anchor:"huggingface_hub.HfApi.repo_exists.example",$$slots:{default:[BU]},$$scope:{ctx:T}}}),bc=new q({props:{name:"repo_info",anchor:"huggingface_hub.HfApi.repo_info",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"timeout",val:": Optional[float] = None"},{name:"files_metadata",val:": bool = False"},{name:"expand",val:": Optional[Union[ExpandModelProperty_T, ExpandDatasetProperty_T, ExpandSpaceProperty_T]] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.repo_info.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.repo_info.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the repository from which to get the
information.`,name:"revision"},{anchor:"huggingface_hub.HfApi.repo_info.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if getting repository info from a dataset or a space,
<code>None</code> or <code>&quot;model&quot;</code> if getting repository info from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.repo_info.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Whether to set a timeout for the request to the Hub.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.repo_info.expand",description:`<strong>expand</strong> (<code>ExpandModelProperty_T</code> or <code>ExpandDatasetProperty_T</code> or <code>ExpandSpaceProperty_T</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>files_metadata</code> is passed.
For an exhaustive list of available properties, check out <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.model_info">model_info()</a>, <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.dataset_info">dataset_info()</a> or <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.space_info">space_info()</a>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.repo_info.files_metadata",description:`<strong>files_metadata</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to retrieve metadata for files in the repository
(size, LFS metadata, etc). Defaults to <code>False</code>.`,name:"files_metadata"},{anchor:"huggingface_hub.HfApi.repo_info.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2799",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The repository information, as a
<a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.DatasetInfo"
>huggingface_hub.hf_api.DatasetInfo</a>, <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.ModelInfo"
>huggingface_hub.hf_api.ModelInfo</a>
or <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.SpaceInfo"
>huggingface_hub.hf_api.SpaceInfo</a> object.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Union[SpaceInfo, DatasetInfo, ModelInfo]</code></p>
`}}),Is=new I({props:{$$slots:{default:[PU]},$$scope:{ctx:T}}}),yc=new q({props:{name:"request_space_hardware",anchor:"huggingface_hub.HfApi.request_space_hardware",parameters:[{name:"repo_id",val:": str"},{name:"hardware",val:": SpaceHardware"},{name:"token",val:": Union[bool, str, None] = None"},{name:"sleep_time",val:": Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.request_space_hardware.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.request_space_hardware.hardware",description:`<strong>hardware</strong> (<code>str</code> or <a href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceHardware">SpaceHardware</a>) &#x2014;
Hardware on which to run the Space. Example: <code>&quot;t4-medium&quot;</code>.`,name:"hardware"},{anchor:"huggingface_hub.HfApi.request_space_hardware.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.request_space_hardware.sleep_time",description:`<strong>sleep_time</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of seconds of inactivity to wait before a Space is put to sleep. Set to <code>-1</code> if you don&#x2019;t want
your Space to sleep (default behavior for upgraded hardware). For free hardware, you can&#x2019;t configure
the sleep time (value is fixed to 48 hours of inactivity).
See <a href="https://huggingface.co/docs/hub/spaces-gpus#sleep-time" rel="nofollow">https://huggingface.co/docs/hub/spaces-gpus#sleep-time</a> for more details.`,name:"sleep_time"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7174",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about a Space including Space stage and hardware.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`}}),Js=new I({props:{$$slots:{default:[YU]},$$scope:{ctx:T}}}),vc=new q({props:{name:"request_space_storage",anchor:"huggingface_hub.HfApi.request_space_storage",parameters:[{name:"repo_id",val:": str"},{name:"storage",val:": SpaceStorage"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.request_space_storage.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the Space to update. Example: <code>&quot;open-llm-leaderboard/open_llm_leaderboard&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.request_space_storage.storage",description:`<strong>storage</strong> (<code>str</code> or <a href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceStorage">SpaceStorage</a>) &#x2014;
Storage tier. Either &#x2018;small&#x2019;, &#x2018;medium&#x2019;, or &#x2018;large&#x2019;.`,name:"storage"},{anchor:"huggingface_hub.HfApi.request_space_storage.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7481",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about a Space including Space stage and hardware.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`}}),Ns=new I({props:{$$slots:{default:[XU]},$$scope:{ctx:T}}}),xc=new q({props:{name:"restart_space",anchor:"huggingface_hub.HfApi.restart_space",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"factory_reboot",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.restart_space.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the Space to restart. Example: <code>&quot;Salesforce/BLIP2&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.restart_space.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.restart_space.factory_reboot",description:`<strong>factory_reboot</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, the Space will be rebuilt from scratch without caching any requirements.`,name:"factory_reboot"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7317",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about your Space.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If your Space is not found (error 404). Most probably wrong repo_id or your space is private but you
are not authenticated.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
403 Forbidden: only the owner of a Space can restart it. If you want to restart a Space that you don’t
own, either ask the owner by opening a Discussion or duplicate the Space.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a> —
If your Space is a static Space. Static Spaces are always running and never billed. If you want to hide
a static Space, you can set it to private.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a></p>
`}}),$c=new q({props:{name:"resume_inference_endpoint",anchor:"huggingface_hub.HfApi.resume_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"running_ok",val:": bool = True"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.resume_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The name of the Inference Endpoint to resume.`,name:"name"},{anchor:"huggingface_hub.HfApi.resume_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace in which the Inference Endpoint is located. Defaults to the current user.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.resume_inference_endpoint.running_ok",description:`<strong>running_ok</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, the method will not raise an error if the Inference Endpoint is already running. Defaults to
<code>True</code>.`,name:"running_ok"},{anchor:"huggingface_hub.HfApi.resume_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8177",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the resumed Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),wc=new q({props:{name:"resume_scheduled_job",anchor:"huggingface_hub.HfApi.resume_scheduled_job",parameters:[{name:"scheduled_job_id",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.resume_scheduled_job.scheduled_job_id",description:`<strong>scheduled_job_id</strong> (<code>str</code>) &#x2014;
ID of the scheduled Job.`,name:"scheduled_job_id"},{anchor:"huggingface_hub.HfApi.resume_scheduled_job.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the scheduled Job is. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.resume_scheduled_job.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L10612"}}),kc=new q({props:{name:"revision_exists",anchor:"huggingface_hub.HfApi.revision_exists",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.revision_exists.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.revision_exists.revision",description:`<strong>revision</strong> (<code>str</code>) &#x2014;
The revision of the repository to check.`,name:"revision"},{anchor:"huggingface_hub.HfApi.revision_exists.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if getting repository info from a dataset or a space,
<code>None</code> or <code>&quot;model&quot;</code> if getting repository info from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.revision_exists.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2917",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if the repository and the revision exists, False otherwise.</p>
`}}),Es=new C({props:{anchor:"huggingface_hub.HfApi.revision_exists.example",$$slots:{default:[QU]},$$scope:{ctx:T}}}),Tc=new q({props:{name:"run_as_future",anchor:"huggingface_hub.HfApi.run_as_future",parameters:[{name:"fn",val:": Callable[..., R]"},{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.HfApi.run_as_future.fn",description:`<strong>fn</strong> (<code>Callable</code>) &#x2014;
The method to run in the background.`,name:"fn"},{anchor:"huggingface_hub.HfApi.run_as_future.*args,",description:`<strong>*args,</strong> **kwargs &#x2014;
Arguments with which the method will be called.`,name:"*args,"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1723",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a <a
  href="https://docs.python.org/3/library/concurrent.futures.html#future-objects"
  rel="nofollow"
>Future</a> instance to
get the result of the task.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Future</code></p>
`}}),Ds=new C({props:{anchor:"huggingface_hub.HfApi.run_as_future.example",$$slots:{default:[zU]},$$scope:{ctx:T}}}),jc=new q({props:{name:"run_job",anchor:"huggingface_hub.HfApi.run_job",parameters:[{name:"image",val:": str"},{name:"command",val:": List[str]"},{name:"env",val:": Optional[Dict[str, Any]] = None"},{name:"secrets",val:": Optional[Dict[str, Any]] = None"},{name:"flavor",val:": Optional[SpaceHardware] = None"},{name:"timeout",val:": Optional[Union[int, float, str]] = None"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.run_job.image",description:`<strong>image</strong> (<code>str</code>) &#x2014;
The Docker image to use.
Examples: <code>&quot;ubuntu&quot;</code>, <code>&quot;python:3.12&quot;</code>, <code>&quot;pytorch/pytorch:2.6.0-cuda12.4-cudnn9-devel&quot;</code>.
Example with an image from a Space: <code>&quot;hf.co/spaces/lhoestq/duckdb&quot;</code>.`,name:"image"},{anchor:"huggingface_hub.HfApi.run_job.command",description:`<strong>command</strong> (<code>List[str]</code>) &#x2014;
The command to run. Example: <code>[&quot;echo&quot;, &quot;hello&quot;]</code>.`,name:"command"},{anchor:"huggingface_hub.HfApi.run_job.env",description:`<strong>env</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Defines the environment variables for the Job.`,name:"env"},{anchor:"huggingface_hub.HfApi.run_job.secrets",description:`<strong>secrets</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Defines the secret environment variables for the Job.`,name:"secrets"},{anchor:"huggingface_hub.HfApi.run_job.flavor",description:`<strong>flavor</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Flavor for the hardware, as in Hugging Face Spaces. See <a href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceHardware">SpaceHardware</a> for possible values.
Defaults to <code>&quot;cpu-basic&quot;</code>.`,name:"flavor"},{anchor:"huggingface_hub.HfApi.run_job.timeout",description:`<strong>timeout</strong> (<code>Union[int, float, str]</code>, <em>optional</em>) &#x2014;
Max duration for the Job: int/float with s (seconds, default), m (minutes), h (hours) or d (days).
Example: <code>300</code> or <code>&quot;5m&quot;</code> for 5 minutes.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.run_job.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Job will be created. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.run_job.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9967"}}),Rs=new C({props:{anchor:"huggingface_hub.HfApi.run_job.example",$$slots:{default:[OU]},$$scope:{ctx:T}}}),Gs=new C({props:{anchor:"huggingface_hub.HfApi.run_job.example-2",$$slots:{default:[KU]},$$scope:{ctx:T}}}),Mc=new q({props:{name:"run_uv_job",anchor:"huggingface_hub.HfApi.run_uv_job",parameters:[{name:"script",val:": str"},{name:"script_args",val:": Optional[List[str]] = None"},{name:"dependencies",val:": Optional[List[str]] = None"},{name:"python",val:": Optional[str] = None"},{name:"image",val:": Optional[str] = None"},{name:"env",val:": Optional[Dict[str, Any]] = None"},{name:"secrets",val:": Optional[Dict[str, Any]] = None"},{name:"flavor",val:": Optional[SpaceHardware] = None"},{name:"timeout",val:": Optional[Union[int, float, str]] = None"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"},{name:"_repo",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.run_uv_job.script",description:`<strong>script</strong> (<code>str</code>) &#x2014;
Path or URL of the UV script, or a command.`,name:"script"},{anchor:"huggingface_hub.HfApi.run_uv_job.script_args",description:`<strong>script_args</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Arguments to pass to the script or command.`,name:"script_args"},{anchor:"huggingface_hub.HfApi.run_uv_job.dependencies",description:`<strong>dependencies</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Dependencies to use to run the UV script.`,name:"dependencies"},{anchor:"huggingface_hub.HfApi.run_uv_job.python",description:`<strong>python</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Use a specific Python version. Default is 3.12.`,name:"python"},{anchor:"huggingface_hub.HfApi.run_uv_job.image",description:`<strong>image</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201C;ghcr.io/astral-sh/uv &#x2014;python3.12-bookworm&#x201D;):
Use a custom Docker image with <code>uv</code> installed.`,name:"image"},{anchor:"huggingface_hub.HfApi.run_uv_job.env",description:`<strong>env</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Defines the environment variables for the Job.`,name:"env"},{anchor:"huggingface_hub.HfApi.run_uv_job.secrets",description:`<strong>secrets</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Defines the secret environment variables for the Job.`,name:"secrets"},{anchor:"huggingface_hub.HfApi.run_uv_job.flavor",description:`<strong>flavor</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Flavor for the hardware, as in Hugging Face Spaces. See <a href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceHardware">SpaceHardware</a> for possible values.
Defaults to <code>&quot;cpu-basic&quot;</code>.`,name:"flavor"},{anchor:"huggingface_hub.HfApi.run_uv_job.timeout",description:`<strong>timeout</strong> (<code>Union[int, float, str]</code>, <em>optional</em>) &#x2014;
Max duration for the Job: int/float with s (seconds, default), m (minutes), h (hours) or d (days).
Example: <code>300</code> or <code>&quot;5m&quot;</code> for 5 minutes.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.run_uv_job.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Job will be created. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.run_uv_job.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L10254"}}),Zs=new C({props:{anchor:"huggingface_hub.HfApi.run_uv_job.example",$$slots:{default:[eH]},$$scope:{ctx:T}}}),Fs=new C({props:{anchor:"huggingface_hub.HfApi.run_uv_job.example-2",$$slots:{default:[tH]},$$scope:{ctx:T}}}),Ss=new C({props:{anchor:"huggingface_hub.HfApi.run_uv_job.example-3",$$slots:{default:[nH]},$$scope:{ctx:T}}}),qc=new q({props:{name:"scale_to_zero_inference_endpoint",anchor:"huggingface_hub.HfApi.scale_to_zero_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.scale_to_zero_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The name of the Inference Endpoint to scale to zero.`,name:"name"},{anchor:"huggingface_hub.HfApi.scale_to_zero_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace in which the Inference Endpoint is located. Defaults to the current user.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.scale_to_zero_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8223",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the scaled-to-zero Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),Uc=new q({props:{name:"set_space_sleep_time",anchor:"huggingface_hub.HfApi.set_space_sleep_time",parameters:[{name:"repo_id",val:": str"},{name:"sleep_time",val:": int"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.set_space_sleep_time.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.set_space_sleep_time.sleep_time",description:`<strong>sleep_time</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of seconds of inactivity to wait before a Space is put to sleep. Set to <code>-1</code> if you don&#x2019;t want
your Space to pause (default behavior for upgraded hardware). For free hardware, you can&#x2019;t configure
the sleep time (value is fixed to 48 hours of inactivity).
See <a href="https://huggingface.co/docs/hub/spaces-gpus#sleep-time" rel="nofollow">https://huggingface.co/docs/hub/spaces-gpus#sleep-time</a> for more details.`,name:"sleep_time"},{anchor:"huggingface_hub.HfApi.set_space_sleep_time.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7227",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about a Space including Space stage and hardware.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`}}),Ls=new I({props:{$$slots:{default:[oH]},$$scope:{ctx:T}}}),Hc=new q({props:{name:"snapshot_download",anchor:"huggingface_hub.HfApi.snapshot_download",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"cache_dir",val:": Union[str, Path, None] = None"},{name:"local_dir",val:": Union[str, Path, None] = None"},{name:"proxies",val:": Optional[Dict] = None"},{name:"etag_timeout",val:": float = 10"},{name:"force_download",val:": bool = False"},{name:"token",val:": Union[bool, str, None] = None"},{name:"local_files_only",val:": bool = False"},{name:"allow_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"ignore_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"max_workers",val:": int = 8"},{name:"tqdm_class",val:": Optional[Type[base_tqdm]] = None"},{name:"local_dir_use_symlinks",val:": Union[bool, Literal['auto']] = 'auto'"},{name:"resume_download",val:": Optional[bool] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.snapshot_download.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A user or an organization name and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.snapshot_download.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if downloading from a dataset or space,
<code>None</code> or <code>&quot;model&quot;</code> if downloading from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.snapshot_download.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional Git revision id which can be a branch name, a tag, or a
commit hash.`,name:"revision"},{anchor:"huggingface_hub.HfApi.snapshot_download.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code>, <code>Path</code>, <em>optional</em>) &#x2014;
Path to the folder where cached files are stored.`,name:"cache_dir"},{anchor:"huggingface_hub.HfApi.snapshot_download.local_dir",description:`<strong>local_dir</strong> (<code>str</code> or <code>Path</code>, <em>optional</em>) &#x2014;
If provided, the downloaded files will be placed under this directory.`,name:"local_dir"},{anchor:"huggingface_hub.HfApi.snapshot_download.proxies",description:`<strong>proxies</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary mapping protocol to the URL of the proxy passed to
<code>requests.request</code>.`,name:"proxies"},{anchor:"huggingface_hub.HfApi.snapshot_download.etag_timeout",description:`<strong>etag_timeout</strong> (<code>float</code>, <em>optional</em>, defaults to <code>10</code>) &#x2014;
When fetching ETag, how many seconds to wait for the server to send
data before giving up which is passed to <code>requests.request</code>.`,name:"etag_timeout"},{anchor:"huggingface_hub.HfApi.snapshot_download.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the file should be downloaded even if it already exists in the local cache.`,name:"force_download"},{anchor:"huggingface_hub.HfApi.snapshot_download.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.snapshot_download.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, avoid downloading the file and return the path to the
local cached file if it exists.`,name:"local_files_only"},{anchor:"huggingface_hub.HfApi.snapshot_download.allow_patterns",description:`<strong>allow_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, only files matching at least one pattern are downloaded.`,name:"allow_patterns"},{anchor:"huggingface_hub.HfApi.snapshot_download.ignore_patterns",description:`<strong>ignore_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, files matching any of the patterns are not downloaded.`,name:"ignore_patterns"},{anchor:"huggingface_hub.HfApi.snapshot_download.max_workers",description:`<strong>max_workers</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of concurrent threads to download files (1 thread = 1 file download).
Defaults to 8.`,name:"max_workers"},{anchor:"huggingface_hub.HfApi.snapshot_download.tqdm_class",description:`<strong>tqdm_class</strong> (<code>tqdm</code>, <em>optional</em>) &#x2014;
If provided, overwrites the default behavior for the progress bar. Passed
argument must inherit from <code>tqdm.auto.tqdm</code> or at least mimic its behavior.
Note that the <code>tqdm_class</code> is not passed to each individual download.
Defaults to the custom HF progress bar that can be disabled by setting
<code>HF_HUB_DISABLE_PROGRESS_BARS</code> environment variable.`,name:"tqdm_class"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5562",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>folder path of the repo snapshot.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If the revision to download from cannot be found.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#EnvironmentError"
  rel="nofollow"
><code>EnvironmentError</code></a> —
If <code>token=True</code> and the token cannot be found.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#OSError"
  rel="nofollow"
><code>OSError</code></a> — if
ETag cannot be determined.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
if some parameter value is invalid.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> or <code>EnvironmentError</code> or <code>OSError</code> or <code>ValueError</code></p>
`}}),Cc=new q({props:{name:"space_info",anchor:"huggingface_hub.HfApi.space_info",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"timeout",val:": Optional[float] = None"},{name:"files_metadata",val:": bool = False"},{name:"expand",val:": Optional[List[ExpandSpaceProperty_T]] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.space_info.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.space_info.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the space repository from which to get the
information.`,name:"revision"},{anchor:"huggingface_hub.HfApi.space_info.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Whether to set a timeout for the request to the Hub.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.space_info.files_metadata",description:`<strong>files_metadata</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to retrieve metadata for files in the repository
(size, LFS metadata, etc). Defaults to <code>False</code>.`,name:"files_metadata"},{anchor:"huggingface_hub.HfApi.space_info.expand",description:`<strong>expand</strong> (<code>List[ExpandSpaceProperty_T]</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>full</code> is passed.
Possible values are <code>&quot;author&quot;</code>, <code>&quot;cardData&quot;</code>, <code>&quot;createdAt&quot;</code>, <code>&quot;datasets&quot;</code>, <code>&quot;disabled&quot;</code>, <code>&quot;lastModified&quot;</code>, <code>&quot;likes&quot;</code>, <code>&quot;models&quot;</code>, <code>&quot;private&quot;</code>, <code>&quot;runtime&quot;</code>, <code>&quot;sdk&quot;</code>, <code>&quot;siblings&quot;</code>, <code>&quot;sha&quot;</code>, <code>&quot;subdomain&quot;</code>, <code>&quot;tags&quot;</code>, <code>&quot;trendingScore&quot;</code>, <code>&quot;usedStorage&quot;</code>, <code>&quot;resourceGroup&quot;</code> and <code>&quot;xetEnabled&quot;</code>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.space_info.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2726",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The space repository information.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.SpaceInfo"
>SpaceInfo</a></p>
`}}),Ws=new I({props:{$$slots:{default:[aH]},$$scope:{ctx:T}}}),Ic=new q({props:{name:"super_squash_history",anchor:"huggingface_hub.HfApi.super_squash_history",parameters:[{name:"repo_id",val:": str"},{name:"branch",val:": Optional[str] = None"},{name:"commit_message",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.super_squash_history.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.super_squash_history.branch",description:`<strong>branch</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The branch to squash. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"branch"},{anchor:"huggingface_hub.HfApi.super_squash_history.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The commit message to use for the squashed commit.`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.super_squash_history.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if listing commits from a dataset or a Space, <code>None</code> or <code>&quot;model&quot;</code> if
listing from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.super_squash_history.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3426",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private but not authenticated or repo
does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If the branch to squash cannot be found.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a> —
If invalid reference for a branch. You cannot squash history on tags.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a></p>
`}}),Vs=new I({props:{warning:!0,$$slots:{default:[sH]},$$scope:{ctx:T}}}),Bs=new I({props:{warning:!0,$$slots:{default:[rH]},$$scope:{ctx:T}}}),Ps=new C({props:{anchor:"huggingface_hub.HfApi.super_squash_history.example",$$slots:{default:[iH]},$$scope:{ctx:T}}}),Jc=new q({props:{name:"suspend_scheduled_job",anchor:"huggingface_hub.HfApi.suspend_scheduled_job",parameters:[{name:"scheduled_job_id",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.suspend_scheduled_job.scheduled_job_id",description:`<strong>scheduled_job_id</strong> (<code>str</code>) &#x2014;
ID of the scheduled Job.`,name:"scheduled_job_id"},{anchor:"huggingface_hub.HfApi.suspend_scheduled_job.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the scheduled Job is. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.suspend_scheduled_job.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L10583"}}),Nc=new q({props:{name:"unlike",anchor:"huggingface_hub.HfApi.unlike",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.unlike.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository to unlike. Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.unlike.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.unlike.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if unliking a dataset or space, <code>None</code> or
<code>&quot;model&quot;</code> if unliking a model. Default is <code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2409",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private
but not authenticated or repo does not exist.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a></p>
`}}),Xs=new C({props:{anchor:"huggingface_hub.HfApi.unlike.example",$$slots:{default:[cH]},$$scope:{ctx:T}}}),Ac=new q({props:{name:"update_collection_item",anchor:"huggingface_hub.HfApi.update_collection_item",parameters:[{name:"collection_slug",val:": str"},{name:"item_object_id",val:": str"},{name:"note",val:": Optional[str] = None"},{name:"position",val:": Optional[int] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.update_collection_item.collection_slug",description:`<strong>collection_slug</strong> (<code>str</code>) &#x2014;
Slug of the collection to update. Example: <code>&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</code>.`,name:"collection_slug"},{anchor:"huggingface_hub.HfApi.update_collection_item.item_object_id",description:`<strong>item_object_id</strong> (<code>str</code>) &#x2014;
ID of the item in the collection. This is not the id of the item on the Hub (repo_id or paper id).
It must be retrieved from a <a href="/docs/huggingface_hub/main/ko/package_reference/collections#huggingface_hub.CollectionItem">CollectionItem</a> object. Example: <code>collection.items[0].item_object_id</code>.`,name:"item_object_id"},{anchor:"huggingface_hub.HfApi.update_collection_item.note",description:`<strong>note</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A note to attach to the item in the collection. The maximum size for a note is 500 characters.`,name:"note"},{anchor:"huggingface_hub.HfApi.update_collection_item.position",description:`<strong>position</strong> (<code>int</code>, <em>optional</em>) &#x2014;
New position of the item in the collection.`,name:"position"},{anchor:"huggingface_hub.HfApi.update_collection_item.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8629"}}),Qs=new C({props:{anchor:"huggingface_hub.HfApi.update_collection_item.example",$$slots:{default:[lH]},$$scope:{ctx:T}}}),Ec=new q({props:{name:"update_collection_metadata",anchor:"huggingface_hub.HfApi.update_collection_metadata",parameters:[{name:"collection_slug",val:": str"},{name:"title",val:": Optional[str] = None"},{name:"description",val:": Optional[str] = None"},{name:"position",val:": Optional[int] = None"},{name:"private",val:": Optional[bool] = None"},{name:"theme",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.update_collection_metadata.collection_slug",description:`<strong>collection_slug</strong> (<code>str</code>) &#x2014;
Slug of the collection to update. Example: <code>&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</code>.`,name:"collection_slug"},{anchor:"huggingface_hub.HfApi.update_collection_metadata.title",description:`<strong>title</strong> (<code>str</code>) &#x2014;
Title of the collection to update.`,name:"title"},{anchor:"huggingface_hub.HfApi.update_collection_metadata.description",description:`<strong>description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Description of the collection to update.`,name:"description"},{anchor:"huggingface_hub.HfApi.update_collection_metadata.position",description:`<strong>position</strong> (<code>int</code>, <em>optional</em>) &#x2014;
New position of the collection in the list of collections of the user.`,name:"position"},{anchor:"huggingface_hub.HfApi.update_collection_metadata.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the collection should be private or not.`,name:"private"},{anchor:"huggingface_hub.HfApi.update_collection_metadata.theme",description:`<strong>theme</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Theme of the collection on the Hub.`,name:"theme"},{anchor:"huggingface_hub.HfApi.update_collection_metadata.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8438"}}),zs=new C({props:{anchor:"huggingface_hub.HfApi.update_collection_metadata.example",$$slots:{default:[pH]},$$scope:{ctx:T}}}),Dc=new q({props:{name:"update_inference_endpoint",anchor:"huggingface_hub.HfApi.update_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"accelerator",val:": Optional[str] = None"},{name:"instance_size",val:": Optional[str] = None"},{name:"instance_type",val:": Optional[str] = None"},{name:"min_replica",val:": Optional[int] = None"},{name:"max_replica",val:": Optional[int] = None"},{name:"scale_to_zero_timeout",val:": Optional[int] = None"},{name:"repository",val:": Optional[str] = None"},{name:"framework",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"task",val:": Optional[str] = None"},{name:"custom_image",val:": Optional[Dict] = None"},{name:"env",val:": Optional[Dict[str, str]] = None"},{name:"secrets",val:": Optional[Dict[str, str]] = None"},{name:"domain",val:": Optional[str] = None"},{name:"path",val:": Optional[str] = None"},{name:"cache_http_responses",val:": Optional[bool] = None"},{name:"tags",val:": Optional[List[str]] = None"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.update_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The name of the Inference Endpoint to update.`,name:"name"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.accelerator",description:`<strong>accelerator</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The hardware accelerator to be used for inference (e.g. <code>&quot;cpu&quot;</code>).`,name:"accelerator"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.instance_size",description:`<strong>instance_size</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The size or type of the instance to be used for hosting the model (e.g. <code>&quot;x4&quot;</code>).`,name:"instance_size"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.instance_type",description:`<strong>instance_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The cloud instance type where the Inference Endpoint will be deployed (e.g. <code>&quot;intel-icl&quot;</code>).`,name:"instance_type"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.min_replica",description:`<strong>min_replica</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum number of replicas (instances) to keep running for the Inference Endpoint.`,name:"min_replica"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.max_replica",description:`<strong>max_replica</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum number of replicas (instances) to scale to for the Inference Endpoint.`,name:"max_replica"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.scale_to_zero_timeout",description:`<strong>scale_to_zero_timeout</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The duration in minutes before an inactive endpoint is scaled to zero.`,name:"scale_to_zero_timeout"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.repository",description:`<strong>repository</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The name of the model repository associated with the Inference Endpoint (e.g. <code>&quot;gpt2&quot;</code>).`,name:"repository"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The machine learning framework used for the model (e.g. <code>&quot;custom&quot;</code>).`,name:"framework"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The specific model revision to deploy on the Inference Endpoint (e.g. <code>&quot;6c0e6080953db56375760c0471a8c5f2929baf11&quot;</code>).`,name:"revision"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The task on which to deploy the model (e.g. <code>&quot;text-classification&quot;</code>).`,name:"task"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.custom_image",description:`<strong>custom_image</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A custom Docker image to use for the Inference Endpoint. This is useful if you want to deploy an
Inference Endpoint running on the <code>text-generation-inference</code> (TGI) framework (see examples).`,name:"custom_image"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.env",description:`<strong>env</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
Non-secret environment variables to inject in the container environment`,name:"env"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.secrets",description:`<strong>secrets</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
Secret values to inject in the container environment.`,name:"secrets"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.domain",description:`<strong>domain</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The custom domain for the Inference Endpoint deployment, if setup the inference endpoint will be available at this domain (e.g. <code>&quot;my-new-domain.cool-website.woof&quot;</code>).`,name:"domain"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.path",description:`<strong>path</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The custom path to the deployed model, should start with a <code>/</code> (e.g. <code>&quot;/models/google-bert/bert-base-uncased&quot;</code>).`,name:"path"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.cache_http_responses",description:`<strong>cache_http_responses</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to cache HTTP responses from the Inference Endpoint.`,name:"cache_http_responses"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.tags",description:`<strong>tags</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of tags to associate with the Inference Endpoint.`,name:"tags"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Inference Endpoint will be updated. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7977",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the updated Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),Rc=new q({props:{name:"update_repo_settings",anchor:"huggingface_hub.HfApi.update_repo_settings",parameters:[{name:"repo_id",val:": str"},{name:"gated",val:": Optional[Literal['auto', 'manual', False]] = None"},{name:"private",val:": Optional[bool] = None"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"xet_enabled",val:": Optional[bool] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.update_repo_settings.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated by a /.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.update_repo_settings.gated",description:`<strong>gated</strong> (<code>Literal[&quot;auto&quot;, &quot;manual&quot;, False]</code>, <em>optional</em>) &#x2014;
The gated status for the repository. If set to <code>None</code> (default), the <code>gated</code> setting of the repository won&#x2019;t be updated.<ul>
<li>&#x201C;auto&#x201D;: The repository is gated, and access requests are automatically approved or denied based on predefined criteria.</li>
<li>&#x201C;manual&#x201D;: The repository is gated, and access requests require manual approval.</li>
<li>False : The repository is not gated, and anyone can access it.</li>
</ul>`,name:"gated"},{anchor:"huggingface_hub.HfApi.update_repo_settings.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the repository should be private.`,name:"private"},{anchor:"huggingface_hub.HfApi.update_repo_settings.token",description:`<strong>token</strong> (<code>Union[str, bool, None]</code>, <em>optional</em>) &#x2014;
A valid user access token (string). Defaults to the locally saved token,
which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass False.`,name:"token"},{anchor:"huggingface_hub.HfApi.update_repo_settings.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repository to update settings from (<code>&quot;model&quot;</code>, <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code>).
Defaults to <code>&quot;model&quot;</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.update_repo_settings.xet_enabled",description:`<strong>xet_enabled</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the repository should be enabled for Xet Storage.`,name:"xet_enabled"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3891",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If gated is not one of “auto”, “manual”, or False.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If repo_type is not one of the values in constants.REPO_TYPES.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
If the request to the Hugging Face Hub API fails.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a></p>
`}}),Gc=new q({props:{name:"update_repo_visibility",anchor:"huggingface_hub.HfApi.update_repo_visibility",parameters:[{name:"repo_id",val:": str"},{name:"private",val:": bool = False"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.update_repo_visibility.repo_id",description:`<strong>repo_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A namespace (user or an organization) and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.update_repo_visibility.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the repository should be private.`,name:"private"},{anchor:"huggingface_hub.HfApi.update_repo_visibility.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.update_repo_visibility.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3836",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The HTTP response in json.</p>
`}}),Os=new I({props:{$$slots:{default:[dH]},$$scope:{ctx:T}}}),Zc=new q({props:{name:"update_webhook",anchor:"huggingface_hub.HfApi.update_webhook",parameters:[{name:"webhook_id",val:": str"},{name:"url",val:": Optional[str] = None"},{name:"watched",val:": Optional[List[Union[Dict, WebhookWatchedItem]]] = None"},{name:"domains",val:": Optional[List[constants.WEBHOOK_DOMAIN_T]] = None"},{name:"secret",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.update_webhook.webhook_id",description:`<strong>webhook_id</strong> (<code>str</code>) &#x2014;
The unique identifier of the webhook to be updated.`,name:"webhook_id"},{anchor:"huggingface_hub.HfApi.update_webhook.url",description:`<strong>url</strong> (<code>str</code>, optional) &#x2014;
The URL to which the payload will be sent.`,name:"url"},{anchor:"huggingface_hub.HfApi.update_webhook.watched",description:`<strong>watched</strong> (<code>List[WebhookWatchedItem]</code>, optional) &#x2014;
List of items to watch. It can be users, orgs, models, datasets, or spaces.
Refer to <code>WebhookWatchedItem</code> for more details. Watched items can also be provided as plain dictionaries.`,name:"watched"},{anchor:"huggingface_hub.HfApi.update_webhook.domains",description:`<strong>domains</strong> (<code>List[Literal[&quot;repo&quot;, &quot;discussion&quot;]]</code>, optional) &#x2014;
The domains to watch. This can include &#x201C;repo&#x201D;, &#x201C;discussion&#x201D;, or both.`,name:"domains"},{anchor:"huggingface_hub.HfApi.update_webhook.secret",description:`<strong>secret</strong> (<code>str</code>, optional) &#x2014;
A secret to sign the payload with, providing an additional layer of security.`,name:"secret"},{anchor:"huggingface_hub.HfApi.update_webhook.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9347",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Info about the updated webhook.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>WebhookInfo</code></p>
`}}),Ks=new C({props:{anchor:"huggingface_hub.HfApi.update_webhook.example",$$slots:{default:[gH]},$$scope:{ctx:T}}}),Fc=new q({props:{name:"upload_file",anchor:"huggingface_hub.HfApi.upload_file",parameters:[{name:"path_or_fileobj",val:": Union[str, Path, bytes, BinaryIO]"},{name:"path_in_repo",val:": str"},{name:"repo_id",val:": str"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"commit_message",val:": Optional[str] = None"},{name:"commit_description",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"parent_commit",val:": Optional[str] = None"},{name:"run_as_future",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.upload_file.path_or_fileobj",description:`<strong>path_or_fileobj</strong> (<code>str</code>, <code>Path</code>, <code>bytes</code>, or <code>IO</code>) &#x2014;
Path to a file on the local machine or binary data stream /
fileobj / buffer.`,name:"path_or_fileobj"},{anchor:"huggingface_hub.HfApi.upload_file.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>) &#x2014;
Relative filepath in the repo, for example:
<code>&quot;checkpoints/1fec34a/weights.bin&quot;</code>`,name:"path_in_repo"},{anchor:"huggingface_hub.HfApi.upload_file.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository to which the file will be uploaded, for example:
<code>&quot;username/custom_transformers&quot;</code>`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.upload_file.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.upload_file.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.upload_file.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.upload_file.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The summary / title / first line of the generated commit`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.upload_file.commit_description",description:`<strong>commit_description</strong> (<code>str</code> <em>optional</em>) &#x2014;
The description of the generated commit`,name:"commit_description"},{anchor:"huggingface_hub.HfApi.upload_file.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request with that commit. Defaults to <code>False</code>.
If <code>revision</code> is not set, PR is opened against the <code>&quot;main&quot;</code> branch. If
<code>revision</code> is set and is a branch, PR is opened against this branch. If
<code>revision</code> is set and is not a branch name (example: a commit oid), an
<code>RevisionNotFoundError</code> is returned by the server.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.upload_file.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string. Shorthands (7 first characters) are also supported.
If specified and <code>create_pr</code> is <code>False</code>, the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>.
If specified and <code>create_pr</code> is <code>True</code>, the pull request will be created from <code>parent_commit</code>.
Specifying <code>parent_commit</code> ensures the repo has not changed before committing the changes, and can be
especially useful if the repo is updated / committed to concurrently.`,name:"parent_commit"},{anchor:"huggingface_hub.HfApi.upload_file.run_as_future",description:`<strong>run_as_future</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to run this method in the background. Background jobs are run sequentially without
blocking the main thread. Passing <code>run_as_future=True</code> will return a <a href="https://docs.python.org/3/library/concurrent.futures.html#future-objects" rel="nofollow">Future</a>
object. Defaults to <code>False</code>.`,name:"run_as_future"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L4582",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Instance of <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitInfo"
>CommitInfo</a> containing information about the newly created commit (commit hash, commit
url, pr url, commit message,…). If <code>run_as_future=True</code> is passed, returns a Future object which will
contain the result when executed.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitInfo"
>CommitInfo</a> or <code>Future</code></p>
`}}),er=new I({props:{$$slots:{default:[uH]},$$scope:{ctx:T}}}),tr=new I({props:{warning:!0,$$slots:{default:[hH]},$$scope:{ctx:T}}}),nr=new C({props:{anchor:"huggingface_hub.HfApi.upload_file.example",$$slots:{default:[fH]},$$scope:{ctx:T}}}),Sc=new q({props:{name:"upload_folder",anchor:"huggingface_hub.HfApi.upload_folder",parameters:[{name:"repo_id",val:": str"},{name:"folder_path",val:": Union[str, Path]"},{name:"path_in_repo",val:": Optional[str] = None"},{name:"commit_message",val:": Optional[str] = None"},{name:"commit_description",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"parent_commit",val:": Optional[str] = None"},{name:"allow_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"ignore_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"delete_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"run_as_future",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.upload_folder.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository to which the file will be uploaded, for example:
<code>&quot;username/custom_transformers&quot;</code>`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.upload_folder.folder_path",description:`<strong>folder_path</strong> (<code>str</code> or <code>Path</code>) &#x2014;
Path to the folder to upload on the local file system`,name:"folder_path"},{anchor:"huggingface_hub.HfApi.upload_folder.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Relative path of the directory in the repo, for example:
<code>&quot;checkpoints/1fec34a/results&quot;</code>. Will default to the root folder of the repository.`,name:"path_in_repo"},{anchor:"huggingface_hub.HfApi.upload_folder.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.upload_folder.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.upload_folder.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.upload_folder.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The summary / title / first line of the generated commit. Defaults to:
<code>f&quot;Upload {path_in_repo} with huggingface_hub&quot;</code>`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.upload_folder.commit_description",description:`<strong>commit_description</strong> (<code>str</code> <em>optional</em>) &#x2014;
The description of the generated commit`,name:"commit_description"},{anchor:"huggingface_hub.HfApi.upload_folder.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request with that commit. Defaults to <code>False</code>. If <code>revision</code> is not
set, PR is opened against the <code>&quot;main&quot;</code> branch. If <code>revision</code> is set and is a branch, PR is opened
against this branch. If <code>revision</code> is set and is not a branch name (example: a commit oid), an
<code>RevisionNotFoundError</code> is returned by the server.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.upload_folder.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string. Shorthands (7 first characters) are also supported.
If specified and <code>create_pr</code> is <code>False</code>, the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>.
If specified and <code>create_pr</code> is <code>True</code>, the pull request will be created from <code>parent_commit</code>.
Specifying <code>parent_commit</code> ensures the repo has not changed before committing the changes, and can be
especially useful if the repo is updated / committed to concurrently.`,name:"parent_commit"},{anchor:"huggingface_hub.HfApi.upload_folder.allow_patterns",description:`<strong>allow_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, only files matching at least one pattern are uploaded.`,name:"allow_patterns"},{anchor:"huggingface_hub.HfApi.upload_folder.ignore_patterns",description:`<strong>ignore_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, files matching any of the patterns are not uploaded.`,name:"ignore_patterns"},{anchor:"huggingface_hub.HfApi.upload_folder.delete_patterns",description:`<strong>delete_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, remote files matching any of the patterns will be deleted from the repo while committing
new files. This is useful if you don&#x2019;t know which files have already been uploaded.
Note: to avoid discrepancies the <code>.gitattributes</code> file is not deleted even if it matches the pattern.`,name:"delete_patterns"},{anchor:"huggingface_hub.HfApi.upload_folder.run_as_future",description:`<strong>run_as_future</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to run this method in the background. Background jobs are run sequentially without
blocking the main thread. Passing <code>run_as_future=True</code> will return a <a href="https://docs.python.org/3/library/concurrent.futures.html#future-objects" rel="nofollow">Future</a>
object. Defaults to <code>False</code>.`,name:"run_as_future"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L4790",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Instance of <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitInfo"
>CommitInfo</a> containing information about the newly created commit (commit hash, commit
url, pr url, commit message,…). If <code>run_as_future=True</code> is passed, returns a Future object which will
contain the result when executed.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitInfo"
>CommitInfo</a> or <code>Future</code></p>
`}}),or=new I({props:{$$slots:{default:[mH]},$$scope:{ctx:T}}}),ar=new I({props:{warning:!0,$$slots:{default:[_H]},$$scope:{ctx:T}}}),sr=new I({props:{$$slots:{default:[bH]},$$scope:{ctx:T}}}),rr=new C({props:{anchor:"huggingface_hub.HfApi.upload_folder.example",$$slots:{default:[yH]},$$scope:{ctx:T}}}),Lc=new q({props:{name:"upload_large_folder",anchor:"huggingface_hub.HfApi.upload_large_folder",parameters:[{name:"repo_id",val:": str"},{name:"folder_path",val:": Union[str, Path]"},{name:"repo_type",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"private",val:": Optional[bool] = None"},{name:"allow_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"ignore_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"num_workers",val:": Optional[int] = None"},{name:"print_report",val:": bool = True"},{name:"print_report_every",val:": int = 60"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.upload_large_folder.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository to which the file will be uploaded.
E.g. <code>&quot;HuggingFaceTB/smollm-corpus&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.upload_large_folder.folder_path",description:`<strong>folder_path</strong> (<code>str</code> or <code>Path</code>) &#x2014;
Path to the folder to upload on the local file system.`,name:"folder_path"},{anchor:"huggingface_hub.HfApi.upload_large_folder.repo_type",description:`<strong>repo_type</strong> (<code>str</code>) &#x2014;
Type of the repository. Must be one of <code>&quot;model&quot;</code>, <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code>.
Unlike in all other <code>HfApi</code> methods, <code>repo_type</code> is explicitly required here. This is to avoid
any mistake when uploading a large folder to the Hub, and therefore prevent from having to re-upload
everything.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.upload_large_folder.revision",description:`<strong>revision</strong> (<code>str</code>, <code>optional</code>) &#x2014;
The branch to commit to. If not provided, the <code>main</code> branch will be used.`,name:"revision"},{anchor:"huggingface_hub.HfApi.upload_large_folder.private",description:`<strong>private</strong> (<code>bool</code>, <code>optional</code>) &#x2014;
Whether the repository should be private.
If <code>None</code> (default), the repo will be public unless the organization&#x2019;s default is private.`,name:"private"},{anchor:"huggingface_hub.HfApi.upload_large_folder.allow_patterns",description:`<strong>allow_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, only files matching at least one pattern are uploaded.`,name:"allow_patterns"},{anchor:"huggingface_hub.HfApi.upload_large_folder.ignore_patterns",description:`<strong>ignore_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, files matching any of the patterns are not uploaded.`,name:"ignore_patterns"},{anchor:"huggingface_hub.HfApi.upload_large_folder.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of workers to start. Defaults to <code>os.cpu_count() - 2</code> (minimum 2).
A higher number of workers may speed up the process if your machine allows it. However, on machines with a
slower connection, it is recommended to keep the number of workers low to ensure better resumability.
Indeed, partially uploaded files will have to be completely re-uploaded if the process is interrupted.`,name:"num_workers"},{anchor:"huggingface_hub.HfApi.upload_large_folder.print_report",description:`<strong>print_report</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to print a report of the upload progress. Defaults to True.
Report is printed to <code>sys.stdout</code> every X seconds (60 by defaults) and overwrites the previous report.`,name:"print_report"},{anchor:"huggingface_hub.HfApi.upload_large_folder.print_report_every",description:`<strong>print_report_every</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Frequency at which the report is printed. Defaults to 60 seconds.`,name:"print_report_every"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5257"}}),ir=new I({props:{$$slots:{default:[vH]},$$scope:{ctx:T}}}),cr=new I({props:{warning:!0,$$slots:{default:[xH]},$$scope:{ctx:T}}}),Wc=new q({props:{name:"whoami",anchor:"huggingface_hub.HfApi.whoami",parameters:[{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.whoami.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1763"}}),Vc=new R({props:{title:"API Dataclasses",local:"api-dataclasses",headingTag:"h2"}}),Bc=new R({props:{title:"AccessRequest",local:"huggingface_hub.hf_api.AccessRequest ][ huggingface_hub.hf_api.AccessRequest",headingTag:"h3"}}),Pc=new q({props:{name:"class huggingface_hub.hf_api.AccessRequest",anchor:"huggingface_hub.hf_api.AccessRequest",parameters:[{name:"username",val:": str"},{name:"fullname",val:": str"},{name:"email",val:": Optional[str]"},{name:"timestamp",val:": datetime"},{name:"status",val:": Literal['pending', 'accepted', 'rejected']"},{name:"fields",val:": Optional[Dict[str, Any]] = None"}],parametersDescription:[{anchor:"huggingface_hub.hf_api.AccessRequest.username",description:`<strong>username</strong> (<code>str</code>) &#x2014;
Username of the user who requested access.`,name:"username"},{anchor:"huggingface_hub.hf_api.AccessRequest.fullname",description:`<strong>fullname</strong> (<code>str</code>) &#x2014;
Fullname of the user who requested access.`,name:"fullname"},{anchor:"huggingface_hub.hf_api.AccessRequest.email",description:`<strong>email</strong> (<code>Optional[str]</code>) &#x2014;
Email of the user who requested access.
Can only be <code>None</code> in the /accepted list if the user was granted access manually.`,name:"email"},{anchor:"huggingface_hub.hf_api.AccessRequest.timestamp",description:`<strong>timestamp</strong> (<code>datetime</code>) &#x2014;
Timestamp of the request.`,name:"timestamp"},{anchor:"huggingface_hub.hf_api.AccessRequest.status",description:`<strong>status</strong> (<code>Literal[&quot;pending&quot;, &quot;accepted&quot;, &quot;rejected&quot;]</code>) &#x2014;
Status of the request. Can be one of <code>[&quot;pending&quot;, &quot;accepted&quot;, &quot;rejected&quot;]</code>.`,name:"status"},{anchor:"huggingface_hub.hf_api.AccessRequest.fields",description:`<strong>fields</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional fields filled by the user in the gate form.`,name:"fields"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L465"}}),Yc=new R({props:{title:"CommitInfo",local:"huggingface_hub.CommitInfo ][ huggingface_hub.CommitInfo",headingTag:"h3"}}),Xc=new q({props:{name:"class huggingface_hub.CommitInfo",anchor:"huggingface_hub.CommitInfo",parameters:[{name:"*args",val:""},{name:"commit_url",val:": str"},{name:"_url",val:": Optional[str] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.CommitInfo.commit_url",description:`<strong>commit_url</strong> (<code>str</code>) &#x2014;
Url where to find the commit.`,name:"commit_url"},{anchor:"huggingface_hub.CommitInfo.commit_message",description:`<strong>commit_message</strong> (<code>str</code>) &#x2014;
The summary (first line) of the commit that has been created.`,name:"commit_message"},{anchor:"huggingface_hub.CommitInfo.commit_description",description:`<strong>commit_description</strong> (<code>str</code>) &#x2014;
Description of the commit that has been created. Can be empty.`,name:"commit_description"},{anchor:"huggingface_hub.CommitInfo.oid",description:`<strong>oid</strong> (<code>str</code>) &#x2014;
Commit hash id. Example: <code>&quot;91c54ad1727ee830252e457677f467be0bfd8a57&quot;</code>.`,name:"oid"},{anchor:"huggingface_hub.CommitInfo.pr_url",description:`<strong>pr_url</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Url to the PR that has been created, if any. Populated when <code>create_pr=True</code>
is passed.`,name:"pr_url"},{anchor:"huggingface_hub.CommitInfo.pr_revision",description:`<strong>pr_revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Revision of the PR that has been created, if any. Populated when
<code>create_pr=True</code> is passed. Example: <code>&quot;refs/pr/1&quot;</code>.`,name:"pr_revision"},{anchor:"huggingface_hub.CommitInfo.pr_num",description:`<strong>pr_num</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of the PR discussion that has been created, if any. Populated when
<code>create_pr=True</code> is passed. Can be passed as <code>discussion_num</code> in
<a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.get_discussion_details">get_discussion_details()</a>. Example: <code>1</code>.`,name:"pr_num"},{anchor:"huggingface_hub.CommitInfo.repo_url",description:`<strong>repo_url</strong> (<code>RepoUrl</code>) &#x2014;
Repo URL of the commit containing info like repo_id, repo_type, etc.`,name:"repo_url"},{anchor:"huggingface_hub.CommitInfo._url",description:`<strong>_url</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Legacy url for <code>str</code> compatibility. Can be the url to the uploaded file on the Hub (if returned by
<a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a>), to the uploaded folder on the Hub (if returned by <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a>) or to the commit on
the Hub (if returned by <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a>). Defaults to <code>commit_url</code>. It is deprecated to use this
attribute. Please use <code>commit_url</code> instead.`,name:"_url"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L385"}}),Qc=new R({props:{title:"DatasetInfo",local:"huggingface_hub.hf_api.DatasetInfo ][ huggingface_hub.DatasetInfo",headingTag:"h3"}}),zc=new q({props:{name:"class huggingface_hub.DatasetInfo",anchor:"huggingface_hub.DatasetInfo",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.DatasetInfo.id",description:`<strong>id</strong> (<code>str</code>) &#x2014;
ID of dataset.`,name:"id"},{anchor:"huggingface_hub.DatasetInfo.author",description:`<strong>author</strong> (<code>str</code>) &#x2014;
Author of the dataset.`,name:"author"},{anchor:"huggingface_hub.DatasetInfo.sha",description:`<strong>sha</strong> (<code>str</code>) &#x2014;
Repo SHA at this particular revision.`,name:"sha"},{anchor:"huggingface_hub.DatasetInfo.created_at",description:`<strong>created_at</strong> (<code>datetime</code>, <em>optional</em>) &#x2014;
Date of creation of the repo on the Hub. Note that the lowest value is <code>2022-03-02T23:29:04.000Z</code>,
corresponding to the date when we began to store creation dates.`,name:"created_at"},{anchor:"huggingface_hub.DatasetInfo.last_modified",description:`<strong>last_modified</strong> (<code>datetime</code>, <em>optional</em>) &#x2014;
Date of last commit to the repo.`,name:"last_modified"},{anchor:"huggingface_hub.DatasetInfo.private",description:`<strong>private</strong> (<code>bool</code>) &#x2014;
Is the repo private.`,name:"private"},{anchor:"huggingface_hub.DatasetInfo.disabled",description:`<strong>disabled</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Is the repo disabled.`,name:"disabled"},{anchor:"huggingface_hub.DatasetInfo.gated",description:`<strong>gated</strong> (<code>Literal[&quot;auto&quot;, &quot;manual&quot;, False]</code>, <em>optional</em>) &#x2014;
Is the repo gated.
If so, whether there is manual or automatic approval.`,name:"gated"},{anchor:"huggingface_hub.DatasetInfo.downloads",description:`<strong>downloads</strong> (<code>int</code>) &#x2014;
Number of downloads of the dataset over the last 30 days.`,name:"downloads"},{anchor:"huggingface_hub.DatasetInfo.downloads_all_time",description:`<strong>downloads_all_time</strong> (<code>int</code>) &#x2014;
Cumulated number of downloads of the model since its creation.`,name:"downloads_all_time"},{anchor:"huggingface_hub.DatasetInfo.likes",description:`<strong>likes</strong> (<code>int</code>) &#x2014;
Number of likes of the dataset.`,name:"likes"},{anchor:"huggingface_hub.DatasetInfo.tags",description:`<strong>tags</strong> (<code>List[str]</code>) &#x2014;
List of tags of the dataset.`,name:"tags"},{anchor:"huggingface_hub.DatasetInfo.card_data",description:`<strong>card_data</strong> (<code>DatasetCardData</code>, <em>optional</em>) &#x2014;
Model Card Metadata  as a <a href="/docs/huggingface_hub/main/ko/package_reference/cards#huggingface_hub.DatasetCardData">huggingface_hub.repocard_data.DatasetCardData</a> object.`,name:"card_data"},{anchor:"huggingface_hub.DatasetInfo.siblings",description:`<strong>siblings</strong> (<code>List[RepoSibling]</code>) &#x2014;
List of <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.hf_api.RepoSibling">huggingface_hub.hf_api.RepoSibling</a> objects that constitute the dataset.`,name:"siblings"},{anchor:"huggingface_hub.DatasetInfo.paperswithcode_id",description:`<strong>paperswithcode_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Papers with code ID of the dataset.`,name:"paperswithcode_id"},{anchor:"huggingface_hub.DatasetInfo.trending_score",description:`<strong>trending_score</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Trending score of the dataset.`,name:"trending_score"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L946"}}),pr=new I({props:{$$slots:{default:[$H]},$$scope:{ctx:T}}}),Oc=new R({props:{title:"GitRefInfo",local:"huggingface_hub.GitRefInfo ][ huggingface_hub.GitRefInfo",headingTag:"h3"}}),Kc=new q({props:{name:"class huggingface_hub.GitRefInfo",anchor:"huggingface_hub.GitRefInfo",parameters:[{name:"name",val:": str"},{name:"ref",val:": str"},{name:"target_commit",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.GitRefInfo.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
Name of the reference (e.g. tag name or branch name).`,name:"name"},{anchor:"huggingface_hub.GitRefInfo.ref",description:`<strong>ref</strong> (<code>str</code>) &#x2014;
Full git ref on the Hub (e.g. <code>&quot;refs/heads/main&quot;</code> or <code>&quot;refs/tags/v1.0&quot;</code>).`,name:"ref"},{anchor:"huggingface_hub.GitRefInfo.target_commit",description:`<strong>target_commit</strong> (<code>str</code>) &#x2014;
OID of the target commit for the ref (e.g. <code>&quot;e7da7f221d5bf496a48136c0cd264e630fe9fcc8&quot;</code>)`,name:"target_commit"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1304"}}),el=new R({props:{title:"GitCommitInfo",local:"huggingface_hub.GitCommitInfo ][ huggingface_hub.GitCommitInfo",headingTag:"h3"}}),tl=new q({props:{name:"class huggingface_hub.GitCommitInfo",anchor:"huggingface_hub.GitCommitInfo",parameters:[{name:"commit_id",val:": str"},{name:"authors",val:": List[str]"},{name:"created_at",val:": datetime"},{name:"title",val:": str"},{name:"message",val:": str"},{name:"formatted_title",val:": Optional[str]"},{name:"formatted_message",val:": Optional[str]"}],parametersDescription:[{anchor:"huggingface_hub.GitCommitInfo.commit_id",description:`<strong>commit_id</strong> (<code>str</code>) &#x2014;
OID of the commit (e.g. <code>&quot;e7da7f221d5bf496a48136c0cd264e630fe9fcc8&quot;</code>)`,name:"commit_id"},{anchor:"huggingface_hub.GitCommitInfo.authors",description:`<strong>authors</strong> (<code>List[str]</code>) &#x2014;
List of authors of the commit.`,name:"authors"},{anchor:"huggingface_hub.GitCommitInfo.created_at",description:`<strong>created_at</strong> (<code>datetime</code>) &#x2014;
Datetime when the commit was created.`,name:"created_at"},{anchor:"huggingface_hub.GitCommitInfo.title",description:`<strong>title</strong> (<code>str</code>) &#x2014;
Title of the commit. This is a free-text value entered by the authors.`,name:"title"},{anchor:"huggingface_hub.GitCommitInfo.message",description:`<strong>message</strong> (<code>str</code>) &#x2014;
Description of the commit. This is a free-text value entered by the authors.`,name:"message"},{anchor:"huggingface_hub.GitCommitInfo.formatted_title",description:`<strong>formatted_title</strong> (<code>str</code>) &#x2014;
Title of the commit formatted as HTML. Only returned if <code>formatted=True</code> is set.`,name:"formatted_title"},{anchor:"huggingface_hub.GitCommitInfo.formatted_message",description:`<strong>formatted_message</strong> (<code>str</code>) &#x2014;
Description of the commit formatted as HTML. Only returned if <code>formatted=True</code> is set.`,name:"formatted_message"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1349"}}),nl=new R({props:{title:"GitRefs",local:"huggingface_hub.GitRefs ][ huggingface_hub.GitRefs",headingTag:"h3"}}),ol=new q({props:{name:"class huggingface_hub.GitRefs",anchor:"huggingface_hub.GitRefs",parameters:[{name:"branches",val:": List[GitRefInfo]"},{name:"converts",val:": List[GitRefInfo]"},{name:"tags",val:": List[GitRefInfo]"},{name:"pull_requests",val:": Optional[List[GitRefInfo]] = None"}],parametersDescription:[{anchor:"huggingface_hub.GitRefs.branches",description:`<strong>branches</strong> (<code>List[GitRefInfo]</code>) &#x2014;
A list of <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.GitRefInfo">GitRefInfo</a> containing information about branches on the repo.`,name:"branches"},{anchor:"huggingface_hub.GitRefs.converts",description:`<strong>converts</strong> (<code>List[GitRefInfo]</code>) &#x2014;
A list of <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.GitRefInfo">GitRefInfo</a> containing information about &#x201C;convert&#x201D; refs on the repo.
Converts are refs used (internally) to push preprocessed data in Dataset repos.`,name:"converts"},{anchor:"huggingface_hub.GitRefs.tags",description:`<strong>tags</strong> (<code>List[GitRefInfo]</code>) &#x2014;
A list of <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.GitRefInfo">GitRefInfo</a> containing information about tags on the repo.`,name:"tags"},{anchor:"huggingface_hub.GitRefs.pull_requests",description:`<strong>pull_requests</strong> (<code>List[GitRefInfo]</code>, <em>optional</em>) &#x2014;
A list of <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.GitRefInfo">GitRefInfo</a> containing information about pull requests on the repo.
Only returned if <code>include_prs=True</code> is set.`,name:"pull_requests"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1323"}}),al=new R({props:{title:"ModelInfo",local:"huggingface_hub.hf_api.ModelInfo ][ huggingface_hub.ModelInfo",headingTag:"h3"}}),sl=new q({props:{name:"class huggingface_hub.ModelInfo",anchor:"huggingface_hub.ModelInfo",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.ModelInfo.id",description:`<strong>id</strong> (<code>str</code>) &#x2014;
ID of model.`,name:"id"},{anchor:"huggingface_hub.ModelInfo.author",description:`<strong>author</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Author of the model.`,name:"author"},{anchor:"huggingface_hub.ModelInfo.sha",description:`<strong>sha</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Repo SHA at this particular revision.`,name:"sha"},{anchor:"huggingface_hub.ModelInfo.created_at",description:`<strong>created_at</strong> (<code>datetime</code>, <em>optional</em>) &#x2014;
Date of creation of the repo on the Hub. Note that the lowest value is <code>2022-03-02T23:29:04.000Z</code>,
corresponding to the date when we began to store creation dates.`,name:"created_at"},{anchor:"huggingface_hub.ModelInfo.last_modified",description:`<strong>last_modified</strong> (<code>datetime</code>, <em>optional</em>) &#x2014;
Date of last commit to the repo.`,name:"last_modified"},{anchor:"huggingface_hub.ModelInfo.private",description:`<strong>private</strong> (<code>bool</code>) &#x2014;
Is the repo private.`,name:"private"},{anchor:"huggingface_hub.ModelInfo.disabled",description:`<strong>disabled</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Is the repo disabled.`,name:"disabled"},{anchor:"huggingface_hub.ModelInfo.downloads",description:`<strong>downloads</strong> (<code>int</code>) &#x2014;
Number of downloads of the model over the last 30 days.`,name:"downloads"},{anchor:"huggingface_hub.ModelInfo.downloads_all_time",description:`<strong>downloads_all_time</strong> (<code>int</code>) &#x2014;
Cumulated number of downloads of the model since its creation.`,name:"downloads_all_time"},{anchor:"huggingface_hub.ModelInfo.gated",description:`<strong>gated</strong> (<code>Literal[&quot;auto&quot;, &quot;manual&quot;, False]</code>, <em>optional</em>) &#x2014;
Is the repo gated.
If so, whether there is manual or automatic approval.`,name:"gated"},{anchor:"huggingface_hub.ModelInfo.gguf",description:`<strong>gguf</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
GGUF information of the model.`,name:"gguf"},{anchor:"huggingface_hub.ModelInfo.inference",description:`<strong>inference</strong> (<code>Literal[&quot;warm&quot;]</code>, <em>optional</em>) &#x2014;
Status of the model on Inference Providers. Warm if the model is served by at least one provider.`,name:"inference"},{anchor:"huggingface_hub.ModelInfo.inference_provider_mapping",description:`<strong>inference_provider_mapping</strong> (<code>List[InferenceProviderMapping]</code>, <em>optional</em>) &#x2014;
A list of <code>InferenceProviderMapping</code> ordered after the user&#x2019;s provider order.`,name:"inference_provider_mapping"},{anchor:"huggingface_hub.ModelInfo.likes",description:`<strong>likes</strong> (<code>int</code>) &#x2014;
Number of likes of the model.`,name:"likes"},{anchor:"huggingface_hub.ModelInfo.library_name",description:`<strong>library_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Library associated with the model.`,name:"library_name"},{anchor:"huggingface_hub.ModelInfo.tags",description:`<strong>tags</strong> (<code>List[str]</code>) &#x2014;
List of tags of the model. Compared to <code>card_data.tags</code>, contains extra tags computed by the Hub
(e.g. supported libraries, model&#x2019;s arXiv).`,name:"tags"},{anchor:"huggingface_hub.ModelInfo.pipeline_tag",description:`<strong>pipeline_tag</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pipeline tag associated with the model.`,name:"pipeline_tag"},{anchor:"huggingface_hub.ModelInfo.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mask token used by the model.`,name:"mask_token"},{anchor:"huggingface_hub.ModelInfo.widget_data",description:`<strong>widget_data</strong> (<code>Any</code>, <em>optional</em>) &#x2014;
Widget data associated with the model.`,name:"widget_data"},{anchor:"huggingface_hub.ModelInfo.model_index",description:`<strong>model_index</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Model index for evaluation.`,name:"model_index"},{anchor:"huggingface_hub.ModelInfo.config",description:`<strong>config</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Model configuration.`,name:"config"},{anchor:"huggingface_hub.ModelInfo.transformers_info",description:`<strong>transformers_info</strong> (<code>TransformersInfo</code>, <em>optional</em>) &#x2014;
Transformers-specific info (auto class, processor, etc.) associated with the model.`,name:"transformers_info"},{anchor:"huggingface_hub.ModelInfo.trending_score",description:`<strong>trending_score</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Trending score of the model.`,name:"trending_score"},{anchor:"huggingface_hub.ModelInfo.card_data",description:`<strong>card_data</strong> (<code>ModelCardData</code>, <em>optional</em>) &#x2014;
Model Card Metadata  as a <a href="/docs/huggingface_hub/main/ko/package_reference/cards#huggingface_hub.ModelCardData">huggingface_hub.repocard_data.ModelCardData</a> object.`,name:"card_data"},{anchor:"huggingface_hub.ModelInfo.siblings",description:`<strong>siblings</strong> (<code>List[RepoSibling]</code>) &#x2014;
List of <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.hf_api.RepoSibling">huggingface_hub.hf_api.RepoSibling</a> objects that constitute the model.`,name:"siblings"},{anchor:"huggingface_hub.ModelInfo.spaces",description:`<strong>spaces</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of spaces using the model.`,name:"spaces"},{anchor:"huggingface_hub.ModelInfo.safetensors",description:`<strong>safetensors</strong> (<code>SafeTensorsInfo</code>, <em>optional</em>) &#x2014;
Model&#x2019;s safetensors information.`,name:"safetensors"},{anchor:"huggingface_hub.ModelInfo.security_repo_status",description:`<strong>security_repo_status</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Model&#x2019;s security scan status.`,name:"security_repo_status"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L747"}}),dr=new I({props:{$$slots:{default:[wH]},$$scope:{ctx:T}}}),rl=new R({props:{title:"RepoSibling",local:"huggingface_hub.hf_api.RepoSibling ][ huggingface_hub.hf_api.RepoSibling",headingTag:"h3"}}),il=new q({props:{name:"class huggingface_hub.hf_api.RepoSibling",anchor:"huggingface_hub.hf_api.RepoSibling",parameters:[{name:"rfilename",val:": str"},{name:"size",val:": Optional[int] = None"},{name:"blob_id",val:": Optional[str] = None"},{name:"lfs",val:": Optional[BlobLfsInfo] = None"}],parametersDescription:[{anchor:"huggingface_hub.hf_api.RepoSibling.rfilename",description:`<strong>rfilename</strong> (str) &#x2014;
file name, relative to the repo root.`,name:"rfilename"},{anchor:"huggingface_hub.hf_api.RepoSibling.size",description:`<strong>size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The file&#x2019;s size, in bytes. This attribute is defined when <code>files_metadata</code> argument of <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.repo_info">repo_info()</a> is set
to <code>True</code>. It&#x2019;s <code>None</code> otherwise.`,name:"size"},{anchor:"huggingface_hub.hf_api.RepoSibling.blob_id",description:`<strong>blob_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The file&#x2019;s git OID. This attribute is defined when <code>files_metadata</code> argument of <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.repo_info">repo_info()</a> is set to
<code>True</code>. It&#x2019;s <code>None</code> otherwise.`,name:"blob_id"},{anchor:"huggingface_hub.hf_api.RepoSibling.lfs",description:`<strong>lfs</strong> (<code>BlobLfsInfo</code>, <em>optional</em>) &#x2014;
The file&#x2019;s LFS metadata. This attribute is defined when<code>files_metadata</code> argument of <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.repo_info">repo_info()</a> is set to
<code>True</code> and the file is stored with Git LFS. It&#x2019;s <code>None</code> otherwise.`,name:"lfs"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L598"}}),gr=new I({props:{$$slots:{default:[kH]},$$scope:{ctx:T}}}),cl=new R({props:{title:"RepoFile",local:"huggingface_hub.hf_api.RepoFile ][ huggingface_hub.hf_api.RepoFile",headingTag:"h3"}}),ll=new q({props:{name:"class huggingface_hub.hf_api.RepoFile",anchor:"huggingface_hub.hf_api.RepoFile",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.hf_api.RepoFile.path",description:`<strong>path</strong> (str) &#x2014;
file path relative to the repo root.`,name:"path"},{anchor:"huggingface_hub.hf_api.RepoFile.size",description:`<strong>size</strong> (<code>int</code>) &#x2014;
The file&#x2019;s size, in bytes.`,name:"size"},{anchor:"huggingface_hub.hf_api.RepoFile.blob_id",description:`<strong>blob_id</strong> (<code>str</code>) &#x2014;
The file&#x2019;s git OID.`,name:"blob_id"},{anchor:"huggingface_hub.hf_api.RepoFile.lfs",description:`<strong>lfs</strong> (<code>BlobLfsInfo</code>) &#x2014;
The file&#x2019;s LFS metadata.`,name:"lfs"},{anchor:"huggingface_hub.hf_api.RepoFile.last_commit",description:`<strong>last_commit</strong> (<code>LastCommitInfo</code>, <em>optional</em>) &#x2014;
The file&#x2019;s last commit metadata. Only defined if <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_repo_tree">list_repo_tree()</a> and <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.get_paths_info">get_paths_info()</a>
are called with <code>expand=True</code>.`,name:"last_commit"},{anchor:"huggingface_hub.hf_api.RepoFile.security",description:`<strong>security</strong> (<code>BlobSecurityInfo</code>, <em>optional</em>) &#x2014;
The file&#x2019;s security scan metadata. Only defined if <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_repo_tree">list_repo_tree()</a> and <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.get_paths_info">get_paths_info()</a>
are called with <code>expand=True</code>.`,name:"security"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L633"}}),pl=new R({props:{title:"RepoUrl",local:"huggingface_hub.RepoUrl ][ huggingface_hub.RepoUrl",headingTag:"h3"}}),dl=new q({props:{name:"class huggingface_hub.RepoUrl",anchor:"huggingface_hub.RepoUrl",parameters:[{name:"url",val:": Any"},{name:"endpoint",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.RepoUrl.url",description:`<strong>url</strong> (<code>Any</code>) &#x2014;
String value of the repo url.`,name:"url"},{anchor:"huggingface_hub.RepoUrl.endpoint",description:`<strong>endpoint</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Endpoint of the Hub. Defaults to <a href="https://huggingface.co" rel="nofollow">https://huggingface.co</a>.`,name:"endpoint"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L536",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If URL cannot be parsed.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If <code>repo_type</code> is unknown.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),ur=new C({props:{anchor:"huggingface_hub.RepoUrl.example",$$slots:{default:[TH]},$$scope:{ctx:T}}}),gl=new R({props:{title:"SafetensorsRepoMetadata",local:"huggingface_hub.utils.SafetensorsRepoMetadata ][ huggingface_hub.utils.SafetensorsRepoMetadata",headingTag:"h3"}}),ul=new q({props:{name:"class huggingface_hub.utils.SafetensorsRepoMetadata",anchor:"huggingface_hub.utils.SafetensorsRepoMetadata",parameters:[{name:"metadata",val:": typing.Optional[typing.Dict]"},{name:"sharded",val:": bool"},{name:"weight_map",val:": typing.Dict[str, str]"},{name:"files_metadata",val:": typing.Dict[str, huggingface_hub.utils._safetensors.SafetensorsFileMetadata]"}],parametersDescription:[{anchor:"huggingface_hub.utils.SafetensorsRepoMetadata.metadata",description:`<strong>metadata</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
The metadata contained in the &#x2018;model.safetensors.index.json&#x2019; file, if it exists. Only populated for sharded
models.`,name:"metadata"},{anchor:"huggingface_hub.utils.SafetensorsRepoMetadata.sharded",description:`<strong>sharded</strong> (<code>bool</code>) &#x2014;
Whether the repo contains a sharded model or not.`,name:"sharded"},{anchor:"huggingface_hub.utils.SafetensorsRepoMetadata.weight_map",description:`<strong>weight_map</strong> (<code>Dict[str, str]</code>) &#x2014;
A map of all weights. Keys are tensor names and values are filenames of the files containing the tensors.`,name:"weight_map"},{anchor:"huggingface_hub.utils.SafetensorsRepoMetadata.files_metadata",description:`<strong>files_metadata</strong> (<code>Dict[str, SafetensorsFileMetadata]</code>) &#x2014;
A map of all files metadata. Keys are filenames and values are the metadata of the corresponding file, as
a <code>SafetensorsFileMetadata</code> object.`,name:"files_metadata"},{anchor:"huggingface_hub.utils.SafetensorsRepoMetadata.parameter_count",description:`<strong>parameter_count</strong> (<code>Dict[str, int]</code>) &#x2014;
A map of the number of parameters per data type. Keys are data types and values are the number of parameters
of that data type.`,name:"parameter_count"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/utils/_safetensors.py#L74"}}),hl=new R({props:{title:"SafetensorsFileMetadata",local:"huggingface_hub.utils.SafetensorsFileMetadata ][ huggingface_hub.utils.SafetensorsFileMetadata",headingTag:"h3"}}),fl=new q({props:{name:"class huggingface_hub.utils.SafetensorsFileMetadata",anchor:"huggingface_hub.utils.SafetensorsFileMetadata",parameters:[{name:"metadata",val:": typing.Dict[str, str]"},{name:"tensors",val:": typing.Dict[str, huggingface_hub.utils._safetensors.TensorInfo]"}],parametersDescription:[{anchor:"huggingface_hub.utils.SafetensorsFileMetadata.metadata",description:`<strong>metadata</strong> (<code>Dict</code>) &#x2014;
The metadata contained in the file.`,name:"metadata"},{anchor:"huggingface_hub.utils.SafetensorsFileMetadata.tensors",description:`<strong>tensors</strong> (<code>Dict[str, TensorInfo]</code>) &#x2014;
A map of all tensors. Keys are tensor names and values are information about the corresponding tensor, as a
<code>TensorInfo</code> object.`,name:"tensors"},{anchor:"huggingface_hub.utils.SafetensorsFileMetadata.parameter_count",description:`<strong>parameter_count</strong> (<code>Dict[str, int]</code>) &#x2014;
A map of the number of parameters per data type. Keys are data types and values are the number of parameters
of that data type.`,name:"parameter_count"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/utils/_safetensors.py#L44"}}),ml=new R({props:{title:"SpaceInfo",local:"huggingface_hub.hf_api.SpaceInfo ][ huggingface_hub.SpaceInfo",headingTag:"h3"}}),_l=new q({props:{name:"class huggingface_hub.SpaceInfo",anchor:"huggingface_hub.SpaceInfo",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.SpaceInfo.id",description:`<strong>id</strong> (<code>str</code>) &#x2014;
ID of the Space.`,name:"id"},{anchor:"huggingface_hub.SpaceInfo.author",description:`<strong>author</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Author of the Space.`,name:"author"},{anchor:"huggingface_hub.SpaceInfo.sha",description:`<strong>sha</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Repo SHA at this particular revision.`,name:"sha"},{anchor:"huggingface_hub.SpaceInfo.created_at",description:`<strong>created_at</strong> (<code>datetime</code>, <em>optional</em>) &#x2014;
Date of creation of the repo on the Hub. Note that the lowest value is <code>2022-03-02T23:29:04.000Z</code>,
corresponding to the date when we began to store creation dates.`,name:"created_at"},{anchor:"huggingface_hub.SpaceInfo.last_modified",description:`<strong>last_modified</strong> (<code>datetime</code>, <em>optional</em>) &#x2014;
Date of last commit to the repo.`,name:"last_modified"},{anchor:"huggingface_hub.SpaceInfo.private",description:`<strong>private</strong> (<code>bool</code>) &#x2014;
Is the repo private.`,name:"private"},{anchor:"huggingface_hub.SpaceInfo.gated",description:`<strong>gated</strong> (<code>Literal[&quot;auto&quot;, &quot;manual&quot;, False]</code>, <em>optional</em>) &#x2014;
Is the repo gated.
If so, whether there is manual or automatic approval.`,name:"gated"},{anchor:"huggingface_hub.SpaceInfo.disabled",description:`<strong>disabled</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Is the Space disabled.`,name:"disabled"},{anchor:"huggingface_hub.SpaceInfo.host",description:`<strong>host</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Host URL of the Space.`,name:"host"},{anchor:"huggingface_hub.SpaceInfo.subdomain",description:`<strong>subdomain</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Subdomain of the Space.`,name:"subdomain"},{anchor:"huggingface_hub.SpaceInfo.likes",description:`<strong>likes</strong> (<code>int</code>) &#x2014;
Number of likes of the Space.`,name:"likes"},{anchor:"huggingface_hub.SpaceInfo.tags",description:`<strong>tags</strong> (<code>List[str]</code>) &#x2014;
List of tags of the Space.`,name:"tags"},{anchor:"huggingface_hub.SpaceInfo.siblings",description:`<strong>siblings</strong> (<code>List[RepoSibling]</code>) &#x2014;
List of <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.hf_api.RepoSibling">huggingface_hub.hf_api.RepoSibling</a> objects that constitute the Space.`,name:"siblings"},{anchor:"huggingface_hub.SpaceInfo.card_data",description:`<strong>card_data</strong> (<code>SpaceCardData</code>, <em>optional</em>) &#x2014;
Space Card Metadata  as a <a href="/docs/huggingface_hub/main/ko/package_reference/cards#huggingface_hub.SpaceCardData">huggingface_hub.repocard_data.SpaceCardData</a> object.`,name:"card_data"},{anchor:"huggingface_hub.SpaceInfo.runtime",description:`<strong>runtime</strong> (<code>SpaceRuntime</code>, <em>optional</em>) &#x2014;
Space runtime information as a <a href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceRuntime">huggingface_hub.hf_api.SpaceRuntime</a> object.`,name:"runtime"},{anchor:"huggingface_hub.SpaceInfo.sdk",description:`<strong>sdk</strong> (<code>str</code>, <em>optional</em>) &#x2014;
SDK used by the Space.`,name:"sdk"},{anchor:"huggingface_hub.SpaceInfo.models",description:`<strong>models</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of models used by the Space.`,name:"models"},{anchor:"huggingface_hub.SpaceInfo.datasets",description:`<strong>datasets</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of datasets used by the Space.`,name:"datasets"},{anchor:"huggingface_hub.SpaceInfo.trending_score",description:`<strong>trending_score</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Trending score of the Space.`,name:"trending_score"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1065"}}),hr=new I({props:{$$slots:{default:[jH]},$$scope:{ctx:T}}}),bl=new R({props:{title:"TensorInfo",local:"huggingface_hub.utils.TensorInfo ][ huggingface_hub.utils.TensorInfo",headingTag:"h3"}}),yl=new q({props:{name:"class huggingface_hub.utils.TensorInfo",anchor:"huggingface_hub.utils.TensorInfo",parameters:[{name:"dtype",val:": typing.Literal['F64', 'F32', 'F16', 'BF16', 'I64', 'I32', 'I16', 'I8', 'U8', 'BOOL']"},{name:"shape",val:": typing.List[int]"},{name:"data_offsets",val:": typing.Tuple[int, int]"}],parametersDescription:[{anchor:"huggingface_hub.utils.TensorInfo.dtype",description:`<strong>dtype</strong> (<code>str</code>) &#x2014;
The data type of the tensor (&#x201C;F64&#x201D;, &#x201C;F32&#x201D;, &#x201C;F16&#x201D;, &#x201C;BF16&#x201D;, &#x201C;I64&#x201D;, &#x201C;I32&#x201D;, &#x201C;I16&#x201D;, &#x201C;I8&#x201D;, &#x201C;U8&#x201D;, &#x201C;BOOL&#x201D;).`,name:"dtype"},{anchor:"huggingface_hub.utils.TensorInfo.shape",description:`<strong>shape</strong> (<code>List[int]</code>) &#x2014;
The shape of the tensor.`,name:"shape"},{anchor:"huggingface_hub.utils.TensorInfo.data_offsets",description:`<strong>data_offsets</strong> (<code>Tuple[int, int]</code>) &#x2014;
The offsets of the data in the file as a tuple <code>[BEGIN, END]</code>.`,name:"data_offsets"},{anchor:"huggingface_hub.utils.TensorInfo.parameter_count",description:`<strong>parameter_count</strong> (<code>int</code>) &#x2014;
The number of parameters in the tensor.`,name:"parameter_count"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/utils/_safetensors.py#L14"}}),vl=new R({props:{title:"User",local:"huggingface_hub.User ][ huggingface_hub.User",headingTag:"h3"}}),xl=new q({props:{name:"class huggingface_hub.User",anchor:"huggingface_hub.User",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.User.username",description:`<strong>username</strong> (<code>str</code>) &#x2014;
Name of the user on the Hub (unique).`,name:"username"},{anchor:"huggingface_hub.User.fullname",description:`<strong>fullname</strong> (<code>str</code>) &#x2014;
User&#x2019;s full name.`,name:"fullname"},{anchor:"huggingface_hub.User.avatar_url",description:`<strong>avatar_url</strong> (<code>str</code>) &#x2014;
URL of the user&#x2019;s avatar.`,name:"avatar_url"},{anchor:"huggingface_hub.User.details",description:`<strong>details</strong> (<code>str</code>, <em>optional</em>) &#x2014;
User&#x2019;s details.`,name:"details"},{anchor:"huggingface_hub.User.is_following",description:`<strong>is_following</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the authenticated user is following this user.`,name:"is_following"},{anchor:"huggingface_hub.User.is_pro",description:`<strong>is_pro</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the user is a pro user.`,name:"is_pro"},{anchor:"huggingface_hub.User.num_models",description:`<strong>num_models</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of models created by the user.`,name:"num_models"},{anchor:"huggingface_hub.User.num_datasets",description:`<strong>num_datasets</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of datasets created by the user.`,name:"num_datasets"},{anchor:"huggingface_hub.User.num_spaces",description:`<strong>num_spaces</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of spaces created by the user.`,name:"num_spaces"},{anchor:"huggingface_hub.User.num_discussions",description:`<strong>num_discussions</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of discussions initiated by the user.`,name:"num_discussions"},{anchor:"huggingface_hub.User.num_papers",description:`<strong>num_papers</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of papers authored by the user.`,name:"num_papers"},{anchor:"huggingface_hub.User.num_upvotes",description:`<strong>num_upvotes</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of upvotes received by the user.`,name:"num_upvotes"},{anchor:"huggingface_hub.User.num_likes",description:`<strong>num_likes</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of likes given by the user.`,name:"num_likes"},{anchor:"huggingface_hub.User.num_following",description:`<strong>num_following</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of users this user is following.`,name:"num_following"},{anchor:"huggingface_hub.User.num_followers",description:`<strong>num_followers</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of users following this user.`,name:"num_followers"},{anchor:"huggingface_hub.User.orgs",description:`<strong>orgs</strong> (list of <code>Organization</code>) &#x2014;
List of organizations the user is part of.`,name:"orgs"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1437"}}),$l=new R({props:{title:"UserLikes",local:"huggingface_hub.UserLikes ][ huggingface_hub.UserLikes",headingTag:"h3"}}),wl=new q({props:{name:"class huggingface_hub.UserLikes",anchor:"huggingface_hub.UserLikes",parameters:[{name:"user",val:": str"},{name:"total",val:": int"},{name:"datasets",val:": List[str]"},{name:"models",val:": List[str]"},{name:"spaces",val:": List[str]"}],parametersDescription:[{anchor:"huggingface_hub.UserLikes.user",description:`<strong>user</strong> (<code>str</code>) &#x2014;
Name of the user for which we fetched the likes.`,name:"user"},{anchor:"huggingface_hub.UserLikes.total",description:`<strong>total</strong> (<code>int</code>) &#x2014;
Total number of likes.`,name:"total"},{anchor:"huggingface_hub.UserLikes.datasets",description:`<strong>datasets</strong> (<code>List[str]</code>) &#x2014;
List of datasets liked by the user (as repo_ids).`,name:"datasets"},{anchor:"huggingface_hub.UserLikes.models",description:`<strong>models</strong> (<code>List[str]</code>) &#x2014;
List of models liked by the user (as repo_ids).`,name:"models"},{anchor:"huggingface_hub.UserLikes.spaces",description:`<strong>spaces</strong> (<code>List[str]</code>) &#x2014;
List of spaces liked by the user (as repo_ids).`,name:"spaces"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1382"}}),kl=new R({props:{title:"CommitOperation",local:"huggingface_hub.CommitOperationAdd ][ huggingface_hub.CommitOperationAdd",headingTag:"h2"}}),jl=new q({props:{name:"class huggingface_hub.CommitOperationAdd",anchor:"huggingface_hub.CommitOperationAdd",parameters:[{name:"path_in_repo",val:": str"},{name:"path_or_fileobj",val:": typing.Union[str, pathlib.Path, bytes, typing.BinaryIO]"}],parametersDescription:[{anchor:"huggingface_hub.CommitOperationAdd.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>) &#x2014;
Relative filepath in the repo, for example: <code>&quot;checkpoints/1fec34a/weights.bin&quot;</code>`,name:"path_in_repo"},{anchor:"huggingface_hub.CommitOperationAdd.path_or_fileobj",description:`<strong>path_or_fileobj</strong> (<code>str</code>, <code>Path</code>, <code>bytes</code>, or <code>BinaryIO</code>) &#x2014;
Either:<ul>
<li>a path to a local file (as <code>str</code> or <code>pathlib.Path</code>) to upload</li>
<li>a buffer of bytes (<code>bytes</code>) holding the content of the file to upload</li>
<li>a &#x201C;file object&#x201D; (subclass of <code>io.BufferedIOBase</code>), typically obtained
with <code>open(path, &quot;rb&quot;)</code>. It must support <code>seek()</code> and <code>tell()</code> methods.</li>
</ul>`,name:"path_or_fileobj"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_api.py#L124",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If <code>path_or_fileobj</code> is not one of <code>str</code>, <code>Path</code>, <code>bytes</code> or <code>io.BufferedIOBase</code>.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If <code>path_or_fileobj</code> is a <code>str</code> or <code>Path</code> but not a path to an existing file.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If <code>path_or_fileobj</code> is a <code>io.BufferedIOBase</code> but it doesn’t support both
<code>seek()</code> and <code>tell()</code>.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),Ml=new q({props:{name:"as_file",anchor:"huggingface_hub.CommitOperationAdd.as_file",parameters:[{name:"with_tqdm",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.CommitOperationAdd.as_file.with_tqdm",description:`<strong>with_tqdm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If True, iterating over the file object will display a progress bar. Only
works if the file-like object is a path to a file. Pure bytes and buffers
are not supported.`,name:"with_tqdm"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_api.py#L206"}}),fr=new C({props:{anchor:"huggingface_hub.CommitOperationAdd.as_file.example",$$slots:{default:[MH]},$$scope:{ctx:T}}}),ql=new q({props:{name:"b64content",anchor:"huggingface_hub.CommitOperationAdd.b64content",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_api.py#L256"}}),Ul=new q({props:{name:"class huggingface_hub.CommitOperationDelete",anchor:"huggingface_hub.CommitOperationDelete",parameters:[{name:"path_in_repo",val:": str"},{name:"is_folder",val:": typing.Union[bool, typing.Literal['auto']] = 'auto'"}],parametersDescription:[{anchor:"huggingface_hub.CommitOperationDelete.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>) &#x2014;
Relative filepath in the repo, for example: <code>&quot;checkpoints/1fec34a/weights.bin&quot;</code>
for a file or <code>&quot;checkpoints/1fec34a/&quot;</code> for a folder.`,name:"path_in_repo"},{anchor:"huggingface_hub.CommitOperationDelete.is_folder",description:`<strong>is_folder</strong> (<code>bool</code> or <code>Literal[&quot;auto&quot;]</code>, <em>optional</em>) &#x2014;
Whether the Delete Operation applies to a folder or not. If &#x201C;auto&#x201D;, the path
type (file or folder) is guessed automatically by looking if path ends with
a &#x201D;/&#x201D; (folder) or not (file). To explicitly set the path type, you can set
<code>is_folder=True</code> or <code>is_folder=False</code>.`,name:"is_folder"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_api.py#L57"}}),Hl=new q({props:{name:"class huggingface_hub.CommitOperationCopy",anchor:"huggingface_hub.CommitOperationCopy",parameters:[{name:"src_path_in_repo",val:": str"},{name:"path_in_repo",val:": str"},{name:"src_revision",val:": typing.Optional[str] = None"},{name:"_src_oid",val:": typing.Optional[str] = None"},{name:"_dest_oid",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.CommitOperationCopy.src_path_in_repo",description:`<strong>src_path_in_repo</strong> (<code>str</code>) &#x2014;
Relative filepath in the repo of the file to be copied, e.g. <code>&quot;checkpoints/1fec34a/weights.bin&quot;</code>.`,name:"src_path_in_repo"},{anchor:"huggingface_hub.CommitOperationCopy.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>) &#x2014;
Relative filepath in the repo where to copy the file, e.g. <code>&quot;checkpoints/1fec34a/weights_copy.bin&quot;</code>.`,name:"path_in_repo"},{anchor:"huggingface_hub.CommitOperationCopy.src_revision",description:`<strong>src_revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision of the file to be copied. Can be any valid git revision.
Default to the target commit revision.`,name:"src_revision"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_api.py#L88"}}),Cl=new R({props:{title:"CommitScheduler",local:"huggingface_hub.CommitScheduler ][ huggingface_hub.CommitScheduler",headingTag:"h2"}}),Il=new q({props:{name:"class huggingface_hub.CommitScheduler",anchor:"huggingface_hub.CommitScheduler",parameters:[{name:"repo_id",val:": str"},{name:"folder_path",val:": typing.Union[str, pathlib.Path]"},{name:"every",val:": typing.Union[int, float] = 5"},{name:"path_in_repo",val:": typing.Optional[str] = None"},{name:"repo_type",val:": typing.Optional[str] = None"},{name:"revision",val:": typing.Optional[str] = None"},{name:"private",val:": typing.Optional[bool] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"allow_patterns",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"ignore_patterns",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"squash_history",val:": bool = False"},{name:"hf_api",val:": typing.Optional[ForwardRef('HfApi')] = None"}],parametersDescription:[{anchor:"huggingface_hub.CommitScheduler.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to commit to.`,name:"repo_id"},{anchor:"huggingface_hub.CommitScheduler.folder_path",description:`<strong>folder_path</strong> (<code>str</code> or <code>Path</code>) &#x2014;
Path to the local folder to upload regularly.`,name:"folder_path"},{anchor:"huggingface_hub.CommitScheduler.every",description:`<strong>every</strong> (<code>int</code> or <code>float</code>, <em>optional</em>) &#x2014;
The number of minutes between each commit. Defaults to 5 minutes.`,name:"every"},{anchor:"huggingface_hub.CommitScheduler.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Relative path of the directory in the repo, for example: <code>&quot;checkpoints/&quot;</code>. Defaults to the root folder
of the repository.`,name:"path_in_repo"},{anchor:"huggingface_hub.CommitScheduler.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to commit to. Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.CommitScheduler.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the repo to commit to. Defaults to <code>main</code>.`,name:"revision"},{anchor:"huggingface_hub.CommitScheduler.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to make the repo private. If <code>None</code> (default), the repo will be public unless the organization&#x2019;s default is private. This value is ignored if the repo already exists.`,name:"private"},{anchor:"huggingface_hub.CommitScheduler.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use to commit to the repo. Defaults to the token saved on the machine.`,name:"token"},{anchor:"huggingface_hub.CommitScheduler.allow_patterns",description:`<strong>allow_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, only files matching at least one pattern are uploaded.`,name:"allow_patterns"},{anchor:"huggingface_hub.CommitScheduler.ignore_patterns",description:`<strong>ignore_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, files matching any of the patterns are not uploaded.`,name:"ignore_patterns"},{anchor:"huggingface_hub.CommitScheduler.squash_history",description:`<strong>squash_history</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to squash the history of the repo after each commit. Defaults to <code>False</code>. Squashing commits is
useful to avoid degraded performances on the repo when it grows too large.`,name:"squash_history"},{anchor:"huggingface_hub.CommitScheduler.hf_api",description:`<strong>hf_api</strong> (<code>HfApi</code>, <em>optional</em>) &#x2014;
The <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> client to use to commit to the Hub. Can be set with custom settings (user agent, token,&#x2026;).`,name:"hf_api"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_scheduler.py#L29"}}),mr=new C({props:{anchor:"huggingface_hub.CommitScheduler.example",$$slots:{default:[qH]},$$scope:{ctx:T}}}),_r=new C({props:{anchor:"huggingface_hub.CommitScheduler.example-2",$$slots:{default:[UH]},$$scope:{ctx:T}}}),Jl=new q({props:{name:"push_to_hub",anchor:"huggingface_hub.CommitScheduler.push_to_hub",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_scheduler.py#L204"}}),br=new I({props:{warning:!0,$$slots:{default:[HH]},$$scope:{ctx:T}}}),Nl=new q({props:{name:"stop",anchor:"huggingface_hub.CommitScheduler.stop",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_scheduler.py#L157"}}),Al=new q({props:{name:"trigger",anchor:"huggingface_hub.CommitScheduler.trigger",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_scheduler.py#L181"}}),El=new wq({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/ko/package_reference/hf_api.md"}}),{c(){t=c("meta"),u=s(),i=c("p"),a=s(),h(g.$$.fragment),e=s(),v=c("p"),v.innerHTML=ck,qf=s(),kr=c("p"),kr.innerHTML=lk,Uf=s(),Tr=c("p"),Tr.innerHTML=pk,Hf=s(),h(jr.$$.fragment),Cf=s(),h(Mr.$$.fragment),If=s(),w=c("div"),h(qr.$$.fragment),Hm=s(),cp=c("p"),cp.textContent=dk,Cm=s(),lp=c("p"),lp.innerHTML=gk,Im=s(),Ge=c("div"),h(Ur.$$.fragment),Jm=s(),pp=c("p"),pp.textContent=uk,Nm=s(),dp=c("p"),dp.innerHTML=hk,Am=s(),gp=c("p"),gp.innerHTML=fk,Em=s(),Ze=c("div"),h(Hr.$$.fragment),Dm=s(),up=c("p"),up.textContent=mk,Rm=s(),hp=c("p"),hp.innerHTML=_k,Gm=s(),h(Zo.$$.fragment),Zm=s(),on=c("div"),h(Cr.$$.fragment),Fm=s(),fp=c("p"),fp.textContent=bk,Sm=s(),mp=c("p"),mp.innerHTML=yk,Lm=s(),an=c("div"),h(Ir.$$.fragment),Wm=s(),_p=c("p"),_p.textContent=vk,Vm=s(),bp=c("p"),bp.innerHTML=xk,Bm=s(),G=c("div"),h(Jr.$$.fragment),Pm=s(),yp=c("p"),yp.textContent=$k,Ym=s(),vp=c("p"),vp.textContent=wk,Xm=s(),xp=c("p"),xp.textContent=kk,Qm=s(),h(Fo.$$.fragment),zm=s(),$p=c("p"),$p.textContent=Tk,Om=s(),wp=c("ul"),wp.innerHTML=jk,Km=s(),Fe=c("div"),h(Nr.$$.fragment),e_=s(),kp=c("p"),kp.textContent=Mk,t_=s(),Tp=c("p"),Tp.textContent=qk,n_=s(),jp=c("p"),jp.innerHTML=Uk,o_=s(),So=c("div"),h(Ar.$$.fragment),a_=s(),Mp=c("p"),Mp.textContent=Hk,s_=s(),Se=c("div"),h(Er.$$.fragment),r_=s(),qp=c("p"),qp.textContent=Ck,i_=s(),h(Lo.$$.fragment),c_=s(),h(Wo.$$.fragment),l_=s(),Le=c("div"),h(Dr.$$.fragment),p_=s(),Up=c("p"),Up.textContent=Ik,d_=s(),h(Vo.$$.fragment),g_=s(),h(Bo.$$.fragment),u_=s(),Po=c("div"),h(Rr.$$.fragment),h_=s(),Hp=c("p"),Hp.innerHTML=Jk,f_=s(),We=c("div"),h(Gr.$$.fragment),m_=s(),Cp=c("p"),Cp.textContent=Nk,__=s(),Ip=c("p"),Ip.innerHTML=Ak,b_=s(),h(Yo.$$.fragment),y_=s(),de=c("div"),h(Zr.$$.fragment),v_=s(),Jp=c("p"),Jp.textContent=Ek,x_=s(),h(Xo.$$.fragment),$_=s(),h(Qo.$$.fragment),w_=s(),h(zo.$$.fragment),k_=s(),L=c("div"),h(Fr.$$.fragment),T_=s(),Np=c("p"),Np.textContent=Dk,j_=s(),Ap=c("p"),Ap.innerHTML=Rk,M_=s(),Ep=c("p"),Ep.innerHTML=Gk,q_=s(),Dp=c("p"),Dp.innerHTML=Zk,U_=s(),h(Oo.$$.fragment),H_=s(),ge=c("div"),h(Sr.$$.fragment),C_=s(),Rp=c("p"),Rp.textContent=Fk,I_=s(),h(Ko.$$.fragment),J_=s(),h(ea.$$.fragment),N_=s(),h(ta.$$.fragment),A_=s(),Ve=c("div"),h(Lr.$$.fragment),E_=s(),Gp=c("p"),Gp.textContent=Sk,D_=s(),Zp=c("p"),Zp.innerHTML=Lk,R_=s(),h(na.$$.fragment),G_=s(),W=c("div"),h(Wr.$$.fragment),Z_=s(),Fp=c("p"),Fp.innerHTML=Wk,F_=s(),Sp=c("p"),Sp.innerHTML=Vk,S_=s(),Lp=c("p"),Lp.innerHTML=Bk,L_=s(),Wp=c("p"),Wp.innerHTML=Pk,W_=s(),h(oa.$$.fragment),V_=s(),aa=c("div"),h(Vr.$$.fragment),B_=s(),Vp=c("p"),Vp.textContent=Yk,P_=s(),V=c("div"),h(Br.$$.fragment),Y_=s(),Bp=c("p"),Bp.textContent=Xk,X_=s(),Pp=c("p"),Pp.textContent=Qk,Q_=s(),h(sa.$$.fragment),z_=s(),h(ra.$$.fragment),O_=s(),h(ia.$$.fragment),K_=s(),B=c("div"),h(Pr.$$.fragment),eb=s(),Yp=c("p"),Yp.textContent=zk,tb=s(),Xp=c("p"),Xp.textContent=Ok,nb=s(),h(ca.$$.fragment),ob=s(),h(la.$$.fragment),ab=s(),h(pa.$$.fragment),sb=s(),da=c("div"),h(Yr.$$.fragment),rb=s(),Qp=c("p"),Qp.textContent=Kk,ib=s(),sn=c("div"),h(Xr.$$.fragment),cb=s(),zp=c("p"),zp.textContent=eT,lb=s(),h(ga.$$.fragment),pb=s(),Be=c("div"),h(Qr.$$.fragment),db=s(),Op=c("p"),Op.textContent=tT,gb=s(),Kp=c("p"),Kp.textContent=nT,ub=s(),h(ua.$$.fragment),hb=s(),ha=c("div"),h(zr.$$.fragment),fb=s(),ed=c("p"),ed.textContent=oT,mb=s(),Pe=c("div"),h(Or.$$.fragment),_b=s(),td=c("p"),td.textContent=aT,bb=s(),h(fa.$$.fragment),yb=s(),h(ma.$$.fragment),vb=s(),rn=c("div"),h(Kr.$$.fragment),xb=s(),nd=c("p"),nd.textContent=sT,$b=s(),h(_a.$$.fragment),wb=s(),cn=c("div"),h(ei.$$.fragment),kb=s(),od=c("p"),od.textContent=rT,Tb=s(),h(ba.$$.fragment),jb=s(),ln=c("div"),h(ti.$$.fragment),Mb=s(),ad=c("p"),ad.textContent=iT,qb=s(),sd=c("p"),sd.textContent=cT,Ub=s(),pn=c("div"),h(ni.$$.fragment),Hb=s(),rd=c("p"),rd.textContent=lT,Cb=s(),id=c("p"),id.innerHTML=pT,Ib=s(),Ye=c("div"),h(oi.$$.fragment),Jb=s(),cd=c("p"),cd.textContent=dT,Nb=s(),ld=c("p"),ld.innerHTML=gT,Ab=s(),pd=c("p"),pd.innerHTML=uT,Eb=s(),ya=c("div"),h(ai.$$.fragment),Db=s(),dd=c("p"),dd.textContent=hT,Rb=s(),va=c("div"),h(si.$$.fragment),Gb=s(),gd=c("p"),gd.textContent=fT,Zb=s(),dn=c("div"),h(ri.$$.fragment),Fb=s(),ud=c("p"),ud.textContent=mT,Sb=s(),hd=c("p"),hd.innerHTML=_T,Lb=s(),xa=c("div"),h(ii.$$.fragment),Wb=s(),fd=c("p"),fd.textContent=bT,Vb=s(),gn=c("div"),h(ci.$$.fragment),Bb=s(),md=c("p"),md.textContent=yT,Pb=s(),_d=c("p"),_d.innerHTML=vT,Yb=s(),$a=c("div"),h(li.$$.fragment),Xb=s(),bd=c("p"),bd.textContent=xT,Qb=s(),un=c("div"),h(pi.$$.fragment),zb=s(),yd=c("p"),yd.textContent=$T,Ob=s(),h(wa.$$.fragment),Kb=s(),hn=c("div"),h(di.$$.fragment),ey=s(),vd=c("p"),vd.textContent=wT,ty=s(),h(ka.$$.fragment),ny=s(),Xe=c("div"),h(gi.$$.fragment),oy=s(),xd=c("p"),xd.textContent=kT,ay=s(),$d=c("p"),$d.textContent=TT,sy=s(),h(Ta.$$.fragment),ry=s(),fn=c("div"),h(ui.$$.fragment),iy=s(),wd=c("p"),wd.textContent=jT,cy=s(),h(ja.$$.fragment),ly=s(),mn=c("div"),h(hi.$$.fragment),py=s(),kd=c("p"),kd.textContent=MT,dy=s(),h(Ma.$$.fragment),gy=s(),_n=c("div"),h(fi.$$.fragment),uy=s(),Td=c("p"),Td.textContent=qT,hy=s(),h(qa.$$.fragment),fy=s(),bn=c("div"),h(mi.$$.fragment),my=s(),jd=c("p"),jd.textContent=UT,_y=s(),h(Ua.$$.fragment),by=s(),Qe=c("div"),h(_i.$$.fragment),yy=s(),Md=c("p"),Md.textContent=HT,vy=s(),qd=c("p"),qd.innerHTML=CT,xy=s(),h(Ha.$$.fragment),$y=s(),Ca=c("div"),h(bi.$$.fragment),wy=s(),Ud=c("p"),Ud.textContent=IT,ky=s(),ze=c("div"),h(yi.$$.fragment),Ty=s(),Hd=c("p"),Hd.textContent=JT,jy=s(),Cd=c("p"),Cd.innerHTML=NT,My=s(),h(Ia.$$.fragment),qy=s(),Ja=c("div"),h(vi.$$.fragment),Uy=s(),Id=c("p"),Id.textContent=AT,Hy=s(),Na=c("div"),h(xi.$$.fragment),Cy=s(),Jd=c("p"),Jd.textContent=ET,Iy=s(),yn=c("div"),h($i.$$.fragment),Jy=s(),Nd=c("p"),Nd.textContent=DT,Ny=s(),h(Aa.$$.fragment),Ay=s(),Ea=c("div"),h(wi.$$.fragment),Ey=s(),Ad=c("p"),Ad.textContent=RT,Dy=s(),vn=c("div"),h(ki.$$.fragment),Ry=s(),Ed=c("p"),Ed.textContent=GT,Gy=s(),h(Da.$$.fragment),Zy=s(),ue=c("div"),h(Ti.$$.fragment),Fy=s(),Dd=c("p"),Dd.textContent=ZT,Sy=s(),Rd=c("p"),Rd.textContent=FT,Ly=s(),h(Ra.$$.fragment),Wy=s(),h(Ga.$$.fragment),Vy=s(),P=c("div"),h(ji.$$.fragment),By=s(),Gd=c("p"),Gd.textContent=ST,Py=s(),Zd=c("p"),Zd.textContent=LT,Yy=s(),Fd=c("p"),Fd.innerHTML=WT,Xy=s(),Sd=c("p"),Sd.innerHTML=VT,Qy=s(),h(Za.$$.fragment),zy=s(),Fa=c("div"),h(Mi.$$.fragment),Oy=s(),Ld=c("p"),Ld.textContent=BT,Ky=s(),xn=c("div"),h(qi.$$.fragment),ev=s(),Wd=c("p"),Wd.textContent=PT,tv=s(),Vd=c("p"),Vd.innerHTML=YT,nv=s(),Oe=c("div"),h(Ui.$$.fragment),ov=s(),Bd=c("p"),Bd.innerHTML=XT,av=s(),h(Sa.$$.fragment),sv=s(),Pd=c("p"),Pd.innerHTML=QT,rv=s(),La=c("div"),h(Hi.$$.fragment),iv=s(),Yd=c("p"),Yd.textContent=zT,cv=s(),$n=c("div"),h(Ci.$$.fragment),lv=s(),Xd=c("p"),Xd.textContent=OT,pv=s(),h(Wa.$$.fragment),dv=s(),Ke=c("div"),h(Ii.$$.fragment),gv=s(),Qd=c("p"),Qd.textContent=KT,uv=s(),zd=c("p"),zd.innerHTML=e0,hv=s(),Od=c("p"),Od.innerHTML=t0,fv=s(),Y=c("div"),h(Ji.$$.fragment),mv=s(),Kd=c("p"),Kd.textContent=n0,_v=s(),eg=c("p"),eg.textContent=o0,bv=s(),tg=c("ul"),tg.innerHTML=a0,yv=s(),h(Va.$$.fragment),vv=s(),ng=c("p"),ng.innerHTML=s0,xv=s(),et=c("div"),h(Ni.$$.fragment),$v=s(),og=c("p"),og.textContent=r0,wv=s(),h(Ba.$$.fragment),kv=s(),h(Pa.$$.fragment),Tv=s(),wn=c("div"),h(Ai.$$.fragment),jv=s(),ag=c("p"),ag.textContent=i0,Mv=s(),h(Ya.$$.fragment),qv=s(),kn=c("div"),h(Ei.$$.fragment),Uv=s(),sg=c("p"),sg.textContent=c0,Hv=s(),h(Xa.$$.fragment),Cv=s(),he=c("div"),h(Di.$$.fragment),Iv=s(),rg=c("p"),rg.textContent=l0,Jv=s(),ig=c("p"),ig.innerHTML=p0,Nv=s(),cg=c("p"),cg.innerHTML=d0,Av=s(),h(Qa.$$.fragment),Ev=s(),Tn=c("div"),h(Ri.$$.fragment),Dv=s(),lg=c("p"),lg.textContent=g0,Rv=s(),h(za.$$.fragment),Gv=s(),tt=c("div"),h(Gi.$$.fragment),Zv=s(),pg=c("p"),pg.textContent=u0,Fv=s(),h(Oa.$$.fragment),Sv=s(),h(Ka.$$.fragment),Lv=s(),fe=c("div"),h(Zi.$$.fragment),Wv=s(),dg=c("p"),dg.textContent=h0,Vv=s(),gg=c("p"),gg.innerHTML=f0,Bv=s(),ug=c("p"),ug.innerHTML=m0,Pv=s(),h(es.$$.fragment),Yv=s(),jn=c("div"),h(Fi.$$.fragment),Xv=s(),hg=c("p"),hg.textContent=_0,Qv=s(),h(ts.$$.fragment),zv=s(),ns=c("div"),h(Si.$$.fragment),Ov=s(),fg=c("p"),fg.textContent=b0,Kv=s(),nt=c("div"),h(Li.$$.fragment),ex=s(),mg=c("p"),mg.textContent=y0,tx=s(),_g=c("p"),_g.innerHTML=v0,nx=s(),h(os.$$.fragment),ox=s(),me=c("div"),h(Wi.$$.fragment),ax=s(),bg=c("p"),bg.textContent=x0,sx=s(),yg=c("p"),yg.innerHTML=$0,rx=s(),vg=c("p"),vg.innerHTML=w0,ix=s(),h(as.$$.fragment),cx=s(),Mn=c("div"),h(Vi.$$.fragment),lx=s(),xg=c("p"),xg.textContent=k0,px=s(),h(ss.$$.fragment),dx=s(),rs=c("div"),h(Bi.$$.fragment),gx=s(),$g=c("p"),$g.textContent=T0,ux=s(),qn=c("div"),h(Pi.$$.fragment),hx=s(),wg=c("p"),wg.textContent=j0,fx=s(),h(is.$$.fragment),mx=s(),_e=c("div"),h(Yi.$$.fragment),_x=s(),kg=c("p"),kg.textContent=M0,bx=s(),Tg=c("p"),Tg.innerHTML=q0,yx=s(),jg=c("p"),jg.innerHTML=U0,vx=s(),h(cs.$$.fragment),xx=s(),be=c("div"),h(Xi.$$.fragment),$x=s(),Mg=c("p"),Mg.textContent=H0,wx=s(),qg=c("p"),qg.innerHTML=C0,kx=s(),Ug=c("p"),Ug.innerHTML=I0,Tx=s(),h(ls.$$.fragment),jx=s(),ot=c("div"),h(Qi.$$.fragment),Mx=s(),Hg=c("p"),Hg.textContent=J0,qx=s(),Cg=c("p"),Cg.textContent=N0,Ux=s(),h(ps.$$.fragment),Hx=s(),ds=c("div"),h(zi.$$.fragment),Cx=s(),Ig=c("p"),Ig.textContent=A0,Ix=s(),Un=c("div"),h(Oi.$$.fragment),Jx=s(),Jg=c("p"),Jg.textContent=E0,Nx=s(),Ng=c("p"),Ng.innerHTML=D0,Ax=s(),Hn=c("div"),h(Ki.$$.fragment),Ex=s(),Ag=c("p"),Ag.textContent=R0,Dx=s(),h(gs.$$.fragment),Rx=s(),Z=c("div"),h(ec.$$.fragment),Gx=s(),Eg=c("p"),Eg.textContent=G0,Zx=s(),Dg=c("p"),Dg.textContent=Z0,Fx=s(),Rg=c("p"),Rg.textContent=F0,Sx=s(),h(us.$$.fragment),Lx=s(),Gg=c("p"),Gg.textContent=S0,Wx=s(),h(hs.$$.fragment),Vx=s(),fs=c("div"),h(tc.$$.fragment),Bx=s(),Zg=c("p"),Zg.textContent=L0,Px=s(),ms=c("div"),h(nc.$$.fragment),Yx=s(),Fg=c("p"),Fg.textContent=W0,Xx=s(),_s=c("div"),h(oc.$$.fragment),Qx=s(),Sg=c("p"),Sg.textContent=V0,zx=s(),bs=c("div"),h(ac.$$.fragment),Ox=s(),Lg=c("p"),Lg.textContent=B0,Kx=s(),Cn=c("div"),h(sc.$$.fragment),e$=s(),Wg=c("p"),Wg.textContent=P0,t$=s(),h(ys.$$.fragment),n$=s(),In=c("div"),h(rc.$$.fragment),o$=s(),Vg=c("p"),Vg.textContent=Y0,a$=s(),h(vs.$$.fragment),s$=s(),at=c("div"),h(ic.$$.fragment),r$=s(),Bg=c("p"),Bg.textContent=X0,i$=s(),Pg=c("p"),Pg.textContent=Q0,c$=s(),h(xs.$$.fragment),l$=s(),st=c("div"),h(cc.$$.fragment),p$=s(),Yg=c("p"),Yg.textContent=z0,d$=s(),Xg=c("p"),Xg.innerHTML=O0,g$=s(),h($s.$$.fragment),u$=s(),ws=c("div"),h(lc.$$.fragment),h$=s(),Qg=c("p"),Qg.textContent=K0,f$=s(),rt=c("div"),h(pc.$$.fragment),m$=s(),zg=c("p"),zg.textContent=ej,_$=s(),Og=c("p"),Og.innerHTML=tj,b$=s(),Kg=c("p"),Kg.innerHTML=nj,y$=s(),it=c("div"),h(dc.$$.fragment),v$=s(),eu=c("p"),eu.textContent=oj,x$=s(),tu=c("p"),tu.innerHTML=aj,$$=s(),nu=c("p"),nu.innerHTML=sj,w$=s(),ct=c("div"),h(gc.$$.fragment),k$=s(),ou=c("p"),ou.textContent=rj,T$=s(),au=c("p"),au.innerHTML=ij,j$=s(),su=c("p"),su.innerHTML=cj,M$=s(),lt=c("div"),h(uc.$$.fragment),q$=s(),ru=c("p"),ru.textContent=lj,U$=s(),h(ks.$$.fragment),H$=s(),h(Ts.$$.fragment),C$=s(),X=c("div"),h(hc.$$.fragment),I$=s(),iu=c("p"),iu.textContent=pj,J$=s(),cu=c("p"),cu.textContent=dj,N$=s(),h(js.$$.fragment),A$=s(),h(Ms.$$.fragment),E$=s(),h(qs.$$.fragment),D$=s(),pt=c("div"),h(fc.$$.fragment),R$=s(),lu=c("p"),lu.textContent=gj,G$=s(),pu=c("p"),pu.innerHTML=uj,Z$=s(),du=c("p"),du.innerHTML=hj,F$=s(),dt=c("div"),h(mc.$$.fragment),S$=s(),gu=c("p"),gu.textContent=fj,L$=s(),h(Us.$$.fragment),W$=s(),h(Hs.$$.fragment),V$=s(),Jn=c("div"),h(_c.$$.fragment),B$=s(),uu=c("p"),uu.textContent=mj,P$=s(),h(Cs.$$.fragment),Y$=s(),Nn=c("div"),h(bc.$$.fragment),X$=s(),hu=c("p"),hu.textContent=_j,Q$=s(),h(Is.$$.fragment),z$=s(),An=c("div"),h(yc.$$.fragment),O$=s(),fu=c("p"),fu.textContent=bj,K$=s(),h(Js.$$.fragment),e2=s(),En=c("div"),h(vc.$$.fragment),t2=s(),mu=c("p"),mu.textContent=yj,n2=s(),h(Ns.$$.fragment),o2=s(),gt=c("div"),h(xc.$$.fragment),a2=s(),_u=c("p"),_u.textContent=vj,s2=s(),bu=c("p"),bu.innerHTML=xj,r2=s(),yu=c("p"),yu.innerHTML=$j,i2=s(),Dn=c("div"),h($c.$$.fragment),c2=s(),vu=c("p"),vu.textContent=wj,l2=s(),xu=c("p"),xu.innerHTML=kj,p2=s(),As=c("div"),h(wc.$$.fragment),d2=s(),$u=c("p"),$u.textContent=Tj,g2=s(),Rn=c("div"),h(kc.$$.fragment),u2=s(),wu=c("p"),wu.textContent=jj,h2=s(),h(Es.$$.fragment),f2=s(),ye=c("div"),h(Tc.$$.fragment),m2=s(),ku=c("p"),ku.textContent=Mj,_2=s(),Tu=c("p"),Tu.innerHTML=qj,b2=s(),ju=c("p"),ju.innerHTML=Uj,y2=s(),h(Ds.$$.fragment),v2=s(),ve=c("div"),h(jc.$$.fragment),x2=s(),Mu=c("p"),Mu.textContent=Hj,$2=s(),qu=c("p"),qu.textContent=Cj,w2=s(),h(Rs.$$.fragment),k2=s(),h(Gs.$$.fragment),T2=s(),Q=c("div"),h(Mc.$$.fragment),j2=s(),Uu=c("p"),Uu.textContent=Ij,M2=s(),Hu=c("p"),Hu.textContent=Jj,q2=s(),h(Zs.$$.fragment),U2=s(),h(Fs.$$.fragment),H2=s(),h(Ss.$$.fragment),C2=s(),ut=c("div"),h(qc.$$.fragment),I2=s(),Cu=c("p"),Cu.textContent=Nj,J2=s(),Iu=c("p"),Iu.innerHTML=Aj,N2=s(),Ju=c("p"),Ju.innerHTML=Ej,A2=s(),ht=c("div"),h(Uc.$$.fragment),E2=s(),Nu=c("p"),Nu.textContent=Dj,D2=s(),Au=c("p"),Au.innerHTML=Rj,R2=s(),h(Ls.$$.fragment),G2=s(),xe=c("div"),h(Hc.$$.fragment),Z2=s(),Eu=c("p"),Eu.textContent=Gj,F2=s(),Du=c("p"),Du.innerHTML=Zj,S2=s(),Ru=c("p"),Ru.innerHTML=Fj,L2=s(),Gu=c("p"),Gu.textContent=Sj,W2=s(),ft=c("div"),h(Cc.$$.fragment),V2=s(),Zu=c("p"),Zu.textContent=Lj,B2=s(),Fu=c("p"),Fu.textContent=Wj,P2=s(),h(Ws.$$.fragment),Y2=s(),z=c("div"),h(Ic.$$.fragment),X2=s(),Su=c("p"),Su.textContent=Vj,Q2=s(),Lu=c("p"),Lu.textContent=Bj,z2=s(),h(Vs.$$.fragment),O2=s(),h(Bs.$$.fragment),K2=s(),h(Ps.$$.fragment),e1=s(),Ys=c("div"),h(Jc.$$.fragment),t1=s(),Wu=c("p"),Wu.textContent=Pj,n1=s(),$e=c("div"),h(Nc.$$.fragment),o1=s(),Vu=c("p"),Vu.textContent=Yj,a1=s(),Bu=c("p"),Bu.innerHTML=Xj,s1=s(),Pu=c("p"),Pu.innerHTML=Qj,r1=s(),h(Xs.$$.fragment),i1=s(),Gn=c("div"),h(Ac.$$.fragment),c1=s(),Yu=c("p"),Yu.textContent=zj,l1=s(),h(Qs.$$.fragment),p1=s(),we=c("div"),h(Ec.$$.fragment),d1=s(),Xu=c("p"),Xu.textContent=Oj,g1=s(),Qu=c("p"),Qu.textContent=Kj,u1=s(),zu=c("p"),zu.innerHTML=eM,h1=s(),h(zs.$$.fragment),f1=s(),mt=c("div"),h(Dc.$$.fragment),m1=s(),Ou=c("p"),Ou.textContent=tM,_1=s(),Ku=c("p"),Ku.textContent=nM,b1=s(),eh=c("p"),eh.innerHTML=oM,y1=s(),Zn=c("div"),h(Rc.$$.fragment),v1=s(),th=c("p"),th.textContent=aM,x1=s(),nh=c("p"),nh.textContent=sM,$1=s(),_t=c("div"),h(Gc.$$.fragment),w1=s(),oh=c("p"),oh.textContent=rM,k1=s(),ah=c("p"),ah.innerHTML=iM,T1=s(),h(Os.$$.fragment),j1=s(),Fn=c("div"),h(Zc.$$.fragment),M1=s(),sh=c("p"),sh.textContent=cM,q1=s(),h(Ks.$$.fragment),U1=s(),ke=c("div"),h(Fc.$$.fragment),H1=s(),rh=c("p"),rh.textContent=lM,C1=s(),h(er.$$.fragment),I1=s(),h(tr.$$.fragment),J1=s(),h(nr.$$.fragment),N1=s(),N=c("div"),h(Sc.$$.fragment),A1=s(),ih=c("p"),ih.textContent=pM,E1=s(),ch=c("p"),ch.textContent=dM,D1=s(),lh=c("p"),lh.innerHTML=gM,R1=s(),ph=c("p"),ph.innerHTML=uM,G1=s(),dh=c("p"),dh.innerHTML=hM,Z1=s(),gh=c("p"),gh.innerHTML=fM,F1=s(),h(or.$$.fragment),S1=s(),h(ar.$$.fragment),L1=s(),h(sr.$$.fragment),W1=s(),h(rr.$$.fragment),V1=s(),J=c("div"),h(Lc.$$.fragment),B1=s(),uh=c("p"),uh.textContent=mM,P1=s(),hh=c("p"),hh.innerHTML=_M,Y1=s(),h(ir.$$.fragment),X1=s(),h(cr.$$.fragment),Q1=s(),fh=c("p"),fh.innerHTML=bM,z1=s(),mh=c("p"),mh.innerHTML=yM,O1=s(),_h=c("ol"),_h.innerHTML=vM,K1=s(),bh=c("p"),bh.textContent=xM,ew=s(),yh=c("ol"),yh.innerHTML=$M,tw=s(),vh=c("p"),vh.textContent=wM,nw=s(),xh=c("ul"),xh.innerHTML=kM,ow=s(),lr=c("div"),h(Wc.$$.fragment),aw=s(),$h=c("p"),$h.textContent=TM,Jf=s(),h(Vc.$$.fragment),Nf=s(),h(Bc.$$.fragment),Af=s(),zn=c("div"),h(Pc.$$.fragment),sw=s(),wh=c("p"),wh.textContent=jM,Ef=s(),h(Yc.$$.fragment),Df=s(),yt=c("div"),h(Xc.$$.fragment),rw=s(),kh=c("p"),kh.textContent=MM,iw=s(),Th=c("p"),Th.innerHTML=qM,Rf=s(),h(Qc.$$.fragment),Gf=s(),vt=c("div"),h(zc.$$.fragment),cw=s(),jh=c("p"),jh.innerHTML=UM,lw=s(),h(pr.$$.fragment),Zf=s(),h(Oc.$$.fragment),Ff=s(),On=c("div"),h(Kc.$$.fragment),pw=s(),Mh=c("p"),Mh.textContent=HM,Sf=s(),h(el.$$.fragment),Lf=s(),Kn=c("div"),h(tl.$$.fragment),dw=s(),qh=c("p"),qh.innerHTML=CM,Wf=s(),h(nl.$$.fragment),Vf=s(),xt=c("div"),h(ol.$$.fragment),gw=s(),Uh=c("p"),Uh.textContent=IM,uw=s(),Hh=c("p"),Hh.innerHTML=JM,Bf=s(),h(al.$$.fragment),Pf=s(),$t=c("div"),h(sl.$$.fragment),hw=s(),Ch=c("p"),Ch.innerHTML=NM,fw=s(),h(dr.$$.fragment),Yf=s(),h(rl.$$.fragment),Xf=s(),wt=c("div"),h(il.$$.fragment),mw=s(),Ih=c("p"),Ih.textContent=AM,_w=s(),h(gr.$$.fragment),Qf=s(),h(cl.$$.fragment),zf=s(),eo=c("div"),h(ll.$$.fragment),bw=s(),Jh=c("p"),Jh.textContent=EM,Of=s(),h(pl.$$.fragment),Kf=s(),K=c("div"),h(dl.$$.fragment),yw=s(),Nh=c("p"),Nh.innerHTML=DM,vw=s(),Ah=c("p"),Ah.innerHTML=RM,xw=s(),Eh=c("ul"),Eh.innerHTML=GM,$w=s(),h(ur.$$.fragment),em=s(),h(gl.$$.fragment),tm=s(),ee=c("div"),h(ul.$$.fragment),ww=s(),Dh=c("p"),Dh.textContent=ZM,kw=s(),Rh=c("p"),Rh.textContent=FM,Tw=s(),Gh=c("p"),Gh.innerHTML=SM,jw=s(),Zh=c("p"),Zh.innerHTML=LM,nm=s(),h(hl.$$.fragment),om=s(),Te=c("div"),h(fl.$$.fragment),Mw=s(),Fh=c("p"),Fh.textContent=WM,qw=s(),Sh=c("p"),Sh.innerHTML=VM,Uw=s(),Lh=c("p"),Lh.innerHTML=BM,am=s(),h(ml.$$.fragment),sm=s(),kt=c("div"),h(_l.$$.fragment),Hw=s(),Wh=c("p"),Wh.innerHTML=PM,Cw=s(),h(hr.$$.fragment),rm=s(),h(bl.$$.fragment),im=s(),Tt=c("div"),h(yl.$$.fragment),Iw=s(),Vh=c("p"),Vh.textContent=YM,Jw=s(),Bh=c("p"),Bh.innerHTML=XM,cm=s(),h(vl.$$.fragment),lm=s(),to=c("div"),h(xl.$$.fragment),Nw=s(),Ph=c("p"),Ph.textContent=QM,pm=s(),h($l.$$.fragment),dm=s(),no=c("div"),h(wl.$$.fragment),Aw=s(),Yh=c("p"),Yh.textContent=zM,gm=s(),h(kl.$$.fragment),um=s(),Tl=c("p"),Tl.innerHTML=OM,hm=s(),je=c("div"),h(jl.$$.fragment),Ew=s(),Xh=c("p"),Xh.textContent=KM,Dw=s(),Sn=c("div"),h(Ml.$$.fragment),Rw=s(),Qh=c("p"),Qh.innerHTML=eq,Gw=s(),h(fr.$$.fragment),Zw=s(),Ln=c("div"),h(ql.$$.fragment),Fw=s(),zh=c("p"),zh.innerHTML=tq,Sw=s(),Oh=c("p"),Oh.innerHTML=nq,fm=s(),oo=c("div"),h(Ul.$$.fragment),Lw=s(),Kh=c("p"),Kh.textContent=oq,mm=s(),te=c("div"),h(Hl.$$.fragment),Ww=s(),ef=c("p"),ef.textContent=aq,Vw=s(),tf=c("p"),tf.textContent=sq,Bw=s(),nf=c("ul"),nf.innerHTML=rq,Pw=s(),of=c("p"),of.innerHTML=iq,_m=s(),h(Cl.$$.fragment),bm=s(),D=c("div"),h(Il.$$.fragment),Yw=s(),af=c("p"),af.textContent=cq,Xw=s(),sf=c("p"),sf.innerHTML=lq,Qw=s(),h(mr.$$.fragment),zw=s(),h(_r.$$.fragment),Ow=s(),bt=c("div"),h(Jl.$$.fragment),Kw=s(),rf=c("p"),rf.textContent=pq,ek=s(),h(br.$$.fragment),tk=s(),cf=c("p"),cf.innerHTML=dq,nk=s(),Wn=c("div"),h(Nl.$$.fragment),ok=s(),lf=c("p"),lf.textContent=gq,ak=s(),pf=c("p"),pf.textContent=uq,sk=s(),Vn=c("div"),h(Al.$$.fragment),rk=s(),df=c("p"),df.innerHTML=hq,ik=s(),gf=c("p"),gf.innerHTML=fq,ym=s(),h(El.$$.fragment),vm=s(),Mf=c("p"),this.h()},l(o){const x=vq("svelte-u9bgzb",document.head);t=l(x,"META",{name:!0,content:!0}),x.forEach(p),u=r(o),i=l(o,"P",{}),j(i).forEach(p),a=r(o),f(g.$$.fragment,o),e=r(o),v=l(o,"P",{"data-svelte-h":!0}),d(v)!=="svelte-6ncsww"&&(v.innerHTML=ck),qf=r(o),kr=l(o,"P",{"data-svelte-h":!0}),d(kr)!=="svelte-fytuye"&&(kr.innerHTML=lk),Uf=r(o),Tr=l(o,"P",{"data-svelte-h":!0}),d(Tr)!=="svelte-zpec9f"&&(Tr.innerHTML=pk),Hf=r(o),f(jr.$$.fragment,o),Cf=r(o),f(Mr.$$.fragment,o),If=r(o),w=l(o,"DIV",{class:!0});var k=j(w);f(qr.$$.fragment,k),Hm=r(k),cp=l(k,"P",{"data-svelte-h":!0}),d(cp)!=="svelte-868tea"&&(cp.textContent=dk),Cm=r(k),lp=l(k,"P",{"data-svelte-h":!0}),d(lp)!=="svelte-mq1mm2"&&(lp.innerHTML=gk),Im=r(k),Ge=l(k,"DIV",{class:!0});var jt=j(Ge);f(Ur.$$.fragment,jt),Jm=r(jt),pp=l(jt,"P",{"data-svelte-h":!0}),d(pp)!=="svelte-nwim5u"&&(pp.textContent=uk),Nm=r(jt),dp=l(jt,"P",{"data-svelte-h":!0}),d(dp)!=="svelte-jkya6j"&&(dp.innerHTML=hk),Am=r(jt),gp=l(jt,"P",{"data-svelte-h":!0}),d(gp)!=="svelte-xxbgtf"&&(gp.innerHTML=fk),jt.forEach(p),Em=r(k),Ze=l(k,"DIV",{class:!0});var Mt=j(Ze);f(Hr.$$.fragment,Mt),Dm=r(Mt),up=l(Mt,"P",{"data-svelte-h":!0}),d(up)!=="svelte-pl69v6"&&(up.textContent=mk),Rm=r(Mt),hp=l(Mt,"P",{"data-svelte-h":!0}),d(hp)!=="svelte-17aw16u"&&(hp.innerHTML=_k),Gm=r(Mt),f(Zo.$$.fragment,Mt),Mt.forEach(p),Zm=r(k),on=l(k,"DIV",{class:!0});var ao=j(on);f(Cr.$$.fragment,ao),Fm=r(ao),fp=l(ao,"P",{"data-svelte-h":!0}),d(fp)!=="svelte-p5bez4"&&(fp.textContent=bk),Sm=r(ao),mp=l(ao,"P",{"data-svelte-h":!0}),d(mp)!=="svelte-eb77qn"&&(mp.innerHTML=yk),ao.forEach(p),Lm=r(k),an=l(k,"DIV",{class:!0});var so=j(an);f(Ir.$$.fragment,so),Wm=r(so),_p=l(so,"P",{"data-svelte-h":!0}),d(_p)!=="svelte-1ck64b0"&&(_p.textContent=vk),Vm=r(so),bp=l(so,"P",{"data-svelte-h":!0}),d(bp)!=="svelte-xt39ay"&&(bp.innerHTML=xk),so.forEach(p),Bm=r(k),G=l(k,"DIV",{class:!0});var F=j(G);f(Jr.$$.fragment,F),Pm=r(F),yp=l(F,"P",{"data-svelte-h":!0}),d(yp)!=="svelte-1ryj8c0"&&(yp.textContent=$k),Ym=r(F),vp=l(F,"P",{"data-svelte-h":!0}),d(vp)!=="svelte-vnh51y"&&(vp.textContent=wk),Xm=r(F),xp=l(F,"P",{"data-svelte-h":!0}),d(xp)!=="svelte-11lpom8"&&(xp.textContent=kk),Qm=r(F),f(Fo.$$.fragment,F),zm=r(F),$p=l(F,"P",{"data-svelte-h":!0}),d($p)!=="svelte-15bi1il"&&($p.textContent=Tk),Om=r(F),wp=l(F,"UL",{"data-svelte-h":!0}),d(wp)!=="svelte-1cixf91"&&(wp.innerHTML=jk),F.forEach(p),Km=r(k),Fe=l(k,"DIV",{class:!0});var qt=j(Fe);f(Nr.$$.fragment,qt),e_=r(qt),kp=l(qt,"P",{"data-svelte-h":!0}),d(kp)!=="svelte-1v3ljxo"&&(kp.textContent=Mk),t_=r(qt),Tp=l(qt,"P",{"data-svelte-h":!0}),d(Tp)!=="svelte-zq4mwt"&&(Tp.textContent=qk),n_=r(qt),jp=l(qt,"P",{"data-svelte-h":!0}),d(jp)!=="svelte-xxbgtf"&&(jp.innerHTML=Uk),qt.forEach(p),o_=r(k),So=l(k,"DIV",{class:!0});var Dl=j(So);f(Ar.$$.fragment,Dl),a_=r(Dl),Mp=l(Dl,"P",{"data-svelte-h":!0}),d(Mp)!=="svelte-a2pb7d"&&(Mp.textContent=Hk),Dl.forEach(p),s_=r(k),Se=l(k,"DIV",{class:!0});var Ut=j(Se);f(Er.$$.fragment,Ut),r_=r(Ut),qp=l(Ut,"P",{"data-svelte-h":!0}),d(qp)!=="svelte-16mfbn3"&&(qp.textContent=Ck),i_=r(Ut),f(Lo.$$.fragment,Ut),c_=r(Ut),f(Wo.$$.fragment,Ut),Ut.forEach(p),l_=r(k),Le=l(k,"DIV",{class:!0});var Ht=j(Le);f(Dr.$$.fragment,Ht),p_=r(Ht),Up=l(Ht,"P",{"data-svelte-h":!0}),d(Up)!=="svelte-1xtlk3i"&&(Up.textContent=Ik),d_=r(Ht),f(Vo.$$.fragment,Ht),g_=r(Ht),f(Bo.$$.fragment,Ht),Ht.forEach(p),u_=r(k),Po=l(k,"DIV",{class:!0});var Rl=j(Po);f(Rr.$$.fragment,Rl),h_=r(Rl),Hp=l(Rl,"P",{"data-svelte-h":!0}),d(Hp)!=="svelte-1eopmb2"&&(Hp.innerHTML=Jk),Rl.forEach(p),f_=r(k),We=l(k,"DIV",{class:!0});var Ct=j(We);f(Gr.$$.fragment,Ct),m_=r(Ct),Cp=l(Ct,"P",{"data-svelte-h":!0}),d(Cp)!=="svelte-8lce12"&&(Cp.textContent=Nk),__=r(Ct),Ip=l(Ct,"P",{"data-svelte-h":!0}),d(Ip)!=="svelte-17aw16u"&&(Ip.innerHTML=Ak),b_=r(Ct),f(Yo.$$.fragment,Ct),Ct.forEach(p),y_=r(k),de=l(k,"DIV",{class:!0});var Me=j(de);f(Zr.$$.fragment,Me),v_=r(Me),Jp=l(Me,"P",{"data-svelte-h":!0}),d(Jp)!=="svelte-pth6mb"&&(Jp.textContent=Ek),x_=r(Me),f(Xo.$$.fragment,Me),$_=r(Me),f(Qo.$$.fragment,Me),w_=r(Me),f(zo.$$.fragment,Me),Me.forEach(p),k_=r(k),L=l(k,"DIV",{class:!0});var ne=j(L);f(Fr.$$.fragment,ne),T_=r(ne),Np=l(ne,"P",{"data-svelte-h":!0}),d(Np)!=="svelte-1g87pq3"&&(Np.textContent=Dk),j_=r(ne),Ap=l(ne,"P",{"data-svelte-h":!0}),d(Ap)!=="svelte-1gunwzz"&&(Ap.innerHTML=Rk),M_=r(ne),Ep=l(ne,"P",{"data-svelte-h":!0}),d(Ep)!=="svelte-1bbedq1"&&(Ep.innerHTML=Gk),q_=r(ne),Dp=l(ne,"P",{"data-svelte-h":!0}),d(Dp)!=="svelte-zi6kpu"&&(Dp.innerHTML=Zk),U_=r(ne),f(Oo.$$.fragment,ne),ne.forEach(p),H_=r(k),ge=l(k,"DIV",{class:!0});var qe=j(ge);f(Sr.$$.fragment,qe),C_=r(qe),Rp=l(qe,"P",{"data-svelte-h":!0}),d(Rp)!=="svelte-aoy5wl"&&(Rp.textContent=Fk),I_=r(qe),f(Ko.$$.fragment,qe),J_=r(qe),f(ea.$$.fragment,qe),N_=r(qe),f(ta.$$.fragment,qe),qe.forEach(p),A_=r(k),Ve=l(k,"DIV",{class:!0});var It=j(Ve);f(Lr.$$.fragment,It),E_=r(It),Gp=l(It,"P",{"data-svelte-h":!0}),d(Gp)!=="svelte-1mk48gz"&&(Gp.textContent=Sk),D_=r(It),Zp=l(It,"P",{"data-svelte-h":!0}),d(Zp)!=="svelte-s9x0iz"&&(Zp.innerHTML=Lk),R_=r(It),f(na.$$.fragment,It),It.forEach(p),G_=r(k),W=l(k,"DIV",{class:!0});var oe=j(W);f(Wr.$$.fragment,oe),Z_=r(oe),Fp=l(oe,"P",{"data-svelte-h":!0}),d(Fp)!=="svelte-1hp36yr"&&(Fp.innerHTML=Wk),F_=r(oe),Sp=l(oe,"P",{"data-svelte-h":!0}),d(Sp)!=="svelte-194f5ee"&&(Sp.innerHTML=Vk),S_=r(oe),Lp=l(oe,"P",{"data-svelte-h":!0}),d(Lp)!=="svelte-14j81b7"&&(Lp.innerHTML=Bk),L_=r(oe),Wp=l(oe,"P",{"data-svelte-h":!0}),d(Wp)!=="svelte-zi6kpu"&&(Wp.innerHTML=Pk),W_=r(oe),f(oa.$$.fragment,oe),oe.forEach(p),V_=r(k),aa=l(k,"DIV",{class:!0});var Gl=j(aa);f(Vr.$$.fragment,Gl),B_=r(Gl),Vp=l(Gl,"P",{"data-svelte-h":!0}),d(Vp)!=="svelte-12go647"&&(Vp.textContent=Yk),Gl.forEach(p),P_=r(k),V=l(k,"DIV",{class:!0});var ae=j(V);f(Br.$$.fragment,ae),Y_=r(ae),Bp=l(ae,"P",{"data-svelte-h":!0}),d(Bp)!=="svelte-254b6u"&&(Bp.textContent=Xk),X_=r(ae),Pp=l(ae,"P",{"data-svelte-h":!0}),d(Pp)!=="svelte-11lpom8"&&(Pp.textContent=Qk),Q_=r(ae),f(sa.$$.fragment,ae),z_=r(ae),f(ra.$$.fragment,ae),O_=r(ae),f(ia.$$.fragment,ae),ae.forEach(p),K_=r(k),B=l(k,"DIV",{class:!0});var se=j(B);f(Pr.$$.fragment,se),eb=r(se),Yp=l(se,"P",{"data-svelte-h":!0}),d(Yp)!=="svelte-13uq06b"&&(Yp.textContent=zk),tb=r(se),Xp=l(se,"P",{"data-svelte-h":!0}),d(Xp)!=="svelte-11lpom8"&&(Xp.textContent=Ok),nb=r(se),f(ca.$$.fragment,se),ob=r(se),f(la.$$.fragment,se),ab=r(se),f(pa.$$.fragment,se),se.forEach(p),sb=r(k),da=l(k,"DIV",{class:!0});var Zl=j(da);f(Yr.$$.fragment,Zl),rb=r(Zl),Qp=l(Zl,"P",{"data-svelte-h":!0}),d(Qp)!=="svelte-14fvvbg"&&(Qp.textContent=Kk),Zl.forEach(p),ib=r(k),sn=l(k,"DIV",{class:!0});var ro=j(sn);f(Xr.$$.fragment,ro),cb=r(ro),zp=l(ro,"P",{"data-svelte-h":!0}),d(zp)!=="svelte-1g6e2ay"&&(zp.textContent=eT),lb=r(ro),f(ga.$$.fragment,ro),ro.forEach(p),pb=r(k),Be=l(k,"DIV",{class:!0});var Jt=j(Be);f(Qr.$$.fragment,Jt),db=r(Jt),Op=l(Jt,"P",{"data-svelte-h":!0}),d(Op)!=="svelte-15pbnj8"&&(Op.textContent=tT),gb=r(Jt),Kp=l(Jt,"P",{"data-svelte-h":!0}),d(Kp)!=="svelte-1fg5f6l"&&(Kp.textContent=nT),ub=r(Jt),f(ua.$$.fragment,Jt),Jt.forEach(p),hb=r(k),ha=l(k,"DIV",{class:!0});var Fl=j(ha);f(zr.$$.fragment,Fl),fb=r(Fl),ed=l(Fl,"P",{"data-svelte-h":!0}),d(ed)!=="svelte-1n7quvg"&&(ed.textContent=oT),Fl.forEach(p),mb=r(k),Pe=l(k,"DIV",{class:!0});var Nt=j(Pe);f(Or.$$.fragment,Nt),_b=r(Nt),td=l(Nt,"P",{"data-svelte-h":!0}),d(td)!=="svelte-1s6a009"&&(td.textContent=aT),bb=r(Nt),f(fa.$$.fragment,Nt),yb=r(Nt),f(ma.$$.fragment,Nt),Nt.forEach(p),vb=r(k),rn=l(k,"DIV",{class:!0});var io=j(rn);f(Kr.$$.fragment,io),xb=r(io),nd=l(io,"P",{"data-svelte-h":!0}),d(nd)!=="svelte-gmiayq"&&(nd.textContent=sT),$b=r(io),f(_a.$$.fragment,io),io.forEach(p),wb=r(k),cn=l(k,"DIV",{class:!0});var co=j(cn);f(ei.$$.fragment,co),kb=r(co),od=l(co,"P",{"data-svelte-h":!0}),d(od)!=="svelte-l8j8qy"&&(od.textContent=rT),Tb=r(co),f(ba.$$.fragment,co),co.forEach(p),jb=r(k),ln=l(k,"DIV",{class:!0});var lo=j(ln);f(ti.$$.fragment,lo),Mb=r(lo),ad=l(lo,"P",{"data-svelte-h":!0}),d(ad)!=="svelte-eigln8"&&(ad.textContent=iT),qb=r(lo),sd=l(lo,"P",{"data-svelte-h":!0}),d(sd)!=="svelte-11xoqkr"&&(sd.textContent=cT),lo.forEach(p),Ub=r(k),pn=l(k,"DIV",{class:!0});var po=j(pn);f(ni.$$.fragment,po),Hb=r(po),rd=l(po,"P",{"data-svelte-h":!0}),d(rd)!=="svelte-1gp9ysc"&&(rd.textContent=lT),Cb=r(po),id=l(po,"P",{"data-svelte-h":!0}),d(id)!=="svelte-1xdeyn5"&&(id.innerHTML=pT),po.forEach(p),Ib=r(k),Ye=l(k,"DIV",{class:!0});var At=j(Ye);f(oi.$$.fragment,At),Jb=r(At),cd=l(At,"P",{"data-svelte-h":!0}),d(cd)!=="svelte-xvin3w"&&(cd.textContent=dT),Nb=r(At),ld=l(At,"P",{"data-svelte-h":!0}),d(ld)!=="svelte-w611kl"&&(ld.innerHTML=gT),Ab=r(At),pd=l(At,"P",{"data-svelte-h":!0}),d(pd)!=="svelte-txc80x"&&(pd.innerHTML=uT),At.forEach(p),Eb=r(k),ya=l(k,"DIV",{class:!0});var Sl=j(ya);f(ai.$$.fragment,Sl),Db=r(Sl),dd=l(Sl,"P",{"data-svelte-h":!0}),d(dd)!=="svelte-17rezgl"&&(dd.textContent=hT),Sl.forEach(p),Rb=r(k),va=l(k,"DIV",{class:!0});var Ll=j(va);f(si.$$.fragment,Ll),Gb=r(Ll),gd=l(Ll,"P",{"data-svelte-h":!0}),d(gd)!=="svelte-rjrkh7"&&(gd.textContent=fT),Ll.forEach(p),Zb=r(k),dn=l(k,"DIV",{class:!0});var go=j(dn);f(ri.$$.fragment,go),Fb=r(go),ud=l(go,"P",{"data-svelte-h":!0}),d(ud)!=="svelte-1lh7ib8"&&(ud.textContent=mT),Sb=r(go),hd=l(go,"P",{"data-svelte-h":!0}),d(hd)!=="svelte-eb77qn"&&(hd.innerHTML=_T),go.forEach(p),Lb=r(k),xa=l(k,"DIV",{class:!0});var Wl=j(xa);f(ii.$$.fragment,Wl),Wb=r(Wl),fd=l(Wl,"P",{"data-svelte-h":!0}),d(fd)!=="svelte-2wnalp"&&(fd.textContent=bT),Wl.forEach(p),Vb=r(k),gn=l(k,"DIV",{class:!0});var uo=j(gn);f(ci.$$.fragment,uo),Bb=r(uo),md=l(uo,"P",{"data-svelte-h":!0}),d(md)!=="svelte-idifvk"&&(md.textContent=yT),Pb=r(uo),_d=l(uo,"P",{"data-svelte-h":!0}),d(_d)!=="svelte-xt39ay"&&(_d.innerHTML=vT),uo.forEach(p),Yb=r(k),$a=l(k,"DIV",{class:!0});var Vl=j($a);f(li.$$.fragment,Vl),Xb=r(Vl),bd=l(Vl,"P",{"data-svelte-h":!0}),d(bd)!=="svelte-1k595hs"&&(bd.textContent=xT),Vl.forEach(p),Qb=r(k),un=l(k,"DIV",{class:!0});var ho=j(un);f(pi.$$.fragment,ho),zb=r(ho),yd=l(ho,"P",{"data-svelte-h":!0}),d(yd)!=="svelte-odm3i5"&&(yd.textContent=$T),Ob=r(ho),f(wa.$$.fragment,ho),ho.forEach(p),Kb=r(k),hn=l(k,"DIV",{class:!0});var fo=j(hn);f(di.$$.fragment,fo),ey=r(fo),vd=l(fo,"P",{"data-svelte-h":!0}),d(vd)!=="svelte-u3qpxi"&&(vd.textContent=wT),ty=r(fo),f(ka.$$.fragment,fo),fo.forEach(p),ny=r(k),Xe=l(k,"DIV",{class:!0});var Et=j(Xe);f(gi.$$.fragment,Et),oy=r(Et),xd=l(Et,"P",{"data-svelte-h":!0}),d(xd)!=="svelte-106oizm"&&(xd.textContent=kT),ay=r(Et),$d=l(Et,"P",{"data-svelte-h":!0}),d($d)!=="svelte-1tfv4hv"&&($d.textContent=TT),sy=r(Et),f(Ta.$$.fragment,Et),Et.forEach(p),ry=r(k),fn=l(k,"DIV",{class:!0});var mo=j(fn);f(ui.$$.fragment,mo),iy=r(mo),wd=l(mo,"P",{"data-svelte-h":!0}),d(wd)!=="svelte-13117mw"&&(wd.textContent=jT),cy=r(mo),f(ja.$$.fragment,mo),mo.forEach(p),ly=r(k),mn=l(k,"DIV",{class:!0});var _o=j(mn);f(hi.$$.fragment,_o),py=r(_o),kd=l(_o,"P",{"data-svelte-h":!0}),d(kd)!=="svelte-isyqd"&&(kd.textContent=MT),dy=r(_o),f(Ma.$$.fragment,_o),_o.forEach(p),gy=r(k),_n=l(k,"DIV",{class:!0});var bo=j(_n);f(fi.$$.fragment,bo),uy=r(bo),Td=l(bo,"P",{"data-svelte-h":!0}),d(Td)!=="svelte-idzq2w"&&(Td.textContent=qT),hy=r(bo),f(qa.$$.fragment,bo),bo.forEach(p),fy=r(k),bn=l(k,"DIV",{class:!0});var yo=j(bn);f(mi.$$.fragment,yo),my=r(yo),jd=l(yo,"P",{"data-svelte-h":!0}),d(jd)!=="svelte-sivey2"&&(jd.textContent=UT),_y=r(yo),f(Ua.$$.fragment,yo),yo.forEach(p),by=r(k),Qe=l(k,"DIV",{class:!0});var Dt=j(Qe);f(_i.$$.fragment,Dt),yy=r(Dt),Md=l(Dt,"P",{"data-svelte-h":!0}),d(Md)!=="svelte-1niezvm"&&(Md.textContent=HT),vy=r(Dt),qd=l(Dt,"P",{"data-svelte-h":!0}),d(qd)!=="svelte-17aw16u"&&(qd.innerHTML=CT),xy=r(Dt),f(Ha.$$.fragment,Dt),Dt.forEach(p),$y=r(k),Ca=l(k,"DIV",{class:!0});var Bl=j(Ca);f(bi.$$.fragment,Bl),wy=r(Bl),Ud=l(Bl,"P",{"data-svelte-h":!0}),d(Ud)!=="svelte-1o179eo"&&(Ud.textContent=IT),Bl.forEach(p),ky=r(k),ze=l(k,"DIV",{class:!0});var Rt=j(ze);f(yi.$$.fragment,Rt),Ty=r(Rt),Hd=l(Rt,"P",{"data-svelte-h":!0}),d(Hd)!=="svelte-1av5ht1"&&(Hd.textContent=JT),jy=r(Rt),Cd=l(Rt,"P",{"data-svelte-h":!0}),d(Cd)!=="svelte-zi6kpu"&&(Cd.innerHTML=NT),My=r(Rt),f(Ia.$$.fragment,Rt),Rt.forEach(p),qy=r(k),Ja=l(k,"DIV",{class:!0});var Pl=j(Ja);f(vi.$$.fragment,Pl),Uy=r(Pl),Id=l(Pl,"P",{"data-svelte-h":!0}),d(Id)!=="svelte-1a5sg0y"&&(Id.textContent=AT),Pl.forEach(p),Hy=r(k),Na=l(k,"DIV",{class:!0});var Yl=j(Na);f(xi.$$.fragment,Yl),Cy=r(Yl),Jd=l(Yl,"P",{"data-svelte-h":!0}),d(Jd)!=="svelte-13tt6xv"&&(Jd.textContent=ET),Yl.forEach(p),Iy=r(k),yn=l(k,"DIV",{class:!0});var vo=j(yn);f($i.$$.fragment,vo),Jy=r(vo),Nd=l(vo,"P",{"data-svelte-h":!0}),d(Nd)!=="svelte-oj23bg"&&(Nd.textContent=DT),Ny=r(vo),f(Aa.$$.fragment,vo),vo.forEach(p),Ay=r(k),Ea=l(k,"DIV",{class:!0});var Xl=j(Ea);f(wi.$$.fragment,Xl),Ey=r(Xl),Ad=l(Xl,"P",{"data-svelte-h":!0}),d(Ad)!=="svelte-d99h9l"&&(Ad.textContent=RT),Xl.forEach(p),Dy=r(k),vn=l(k,"DIV",{class:!0});var xo=j(vn);f(ki.$$.fragment,xo),Ry=r(xo),Ed=l(xo,"P",{"data-svelte-h":!0}),d(Ed)!=="svelte-fasffe"&&(Ed.textContent=GT),Gy=r(xo),f(Da.$$.fragment,xo),xo.forEach(p),Zy=r(k),ue=l(k,"DIV",{class:!0});var Ue=j(ue);f(Ti.$$.fragment,Ue),Fy=r(Ue),Dd=l(Ue,"P",{"data-svelte-h":!0}),d(Dd)!=="svelte-1ipows8"&&(Dd.textContent=ZT),Sy=r(Ue),Rd=l(Ue,"P",{"data-svelte-h":!0}),d(Rd)!=="svelte-11lpom8"&&(Rd.textContent=FT),Ly=r(Ue),f(Ra.$$.fragment,Ue),Wy=r(Ue),f(Ga.$$.fragment,Ue),Ue.forEach(p),Vy=r(k),P=l(k,"DIV",{class:!0});var re=j(P);f(ji.$$.fragment,re),By=r(re),Gd=l(re,"P",{"data-svelte-h":!0}),d(Gd)!=="svelte-1d865z6"&&(Gd.textContent=ST),Py=r(re),Zd=l(re,"P",{"data-svelte-h":!0}),d(Zd)!=="svelte-vb94yg"&&(Zd.textContent=LT),Yy=r(re),Fd=l(re,"P",{"data-svelte-h":!0}),d(Fd)!=="svelte-1vhvhde"&&(Fd.innerHTML=WT),Xy=r(re),Sd=l(re,"P",{"data-svelte-h":!0}),d(Sd)!=="svelte-ndzof3"&&(Sd.innerHTML=VT),Qy=r(re),f(Za.$$.fragment,re),re.forEach(p),zy=r(k),Fa=l(k,"DIV",{class:!0});var Ql=j(Fa);f(Mi.$$.fragment,Ql),Oy=r(Ql),Ld=l(Ql,"P",{"data-svelte-h":!0}),d(Ld)!=="svelte-130dnbj"&&(Ld.textContent=BT),Ql.forEach(p),Ky=r(k),xn=l(k,"DIV",{class:!0});var $o=j(xn);f(qi.$$.fragment,$o),ev=r($o),Wd=l($o,"P",{"data-svelte-h":!0}),d(Wd)!=="svelte-20b1wq"&&(Wd.textContent=PT),tv=r($o),Vd=l($o,"P",{"data-svelte-h":!0}),d(Vd)!=="svelte-xt39ay"&&(Vd.innerHTML=YT),$o.forEach(p),nv=r(k),Oe=l(k,"DIV",{class:!0});var Gt=j(Oe);f(Ui.$$.fragment,Gt),ov=r(Gt),Bd=l(Gt,"P",{"data-svelte-h":!0}),d(Bd)!=="svelte-1vu5uho"&&(Bd.innerHTML=XT),av=r(Gt),f(Sa.$$.fragment,Gt),sv=r(Gt),Pd=l(Gt,"P",{"data-svelte-h":!0}),d(Pd)!=="svelte-65kopl"&&(Pd.innerHTML=QT),Gt.forEach(p),rv=r(k),La=l(k,"DIV",{class:!0});var zl=j(La);f(Hi.$$.fragment,zl),iv=r(zl),Yd=l(zl,"P",{"data-svelte-h":!0}),d(Yd)!=="svelte-i5g6s6"&&(Yd.textContent=zT),zl.forEach(p),cv=r(k),$n=l(k,"DIV",{class:!0});var wo=j($n);f(Ci.$$.fragment,wo),lv=r(wo),Xd=l(wo,"P",{"data-svelte-h":!0}),d(Xd)!=="svelte-1qqa7u0"&&(Xd.textContent=OT),pv=r(wo),f(Wa.$$.fragment,wo),wo.forEach(p),dv=r(k),Ke=l(k,"DIV",{class:!0});var Zt=j(Ke);f(Ii.$$.fragment,Zt),gv=r(Zt),Qd=l(Zt,"P",{"data-svelte-h":!0}),d(Qd)!=="svelte-19fc6id"&&(Qd.textContent=KT),uv=r(Zt),zd=l(Zt,"P",{"data-svelte-h":!0}),d(zd)!=="svelte-fnfmvb"&&(zd.innerHTML=e0),hv=r(Zt),Od=l(Zt,"P",{"data-svelte-h":!0}),d(Od)!=="svelte-xxbgtf"&&(Od.innerHTML=t0),Zt.forEach(p),fv=r(k),Y=l(k,"DIV",{class:!0});var ie=j(Y);f(Ji.$$.fragment,ie),mv=r(ie),Kd=l(ie,"P",{"data-svelte-h":!0}),d(Kd)!=="svelte-gsbehr"&&(Kd.textContent=n0),_v=r(ie),eg=l(ie,"P",{"data-svelte-h":!0}),d(eg)!=="svelte-1rkm1l0"&&(eg.textContent=o0),bv=r(ie),tg=l(ie,"UL",{"data-svelte-h":!0}),d(tg)!=="svelte-1t8qnom"&&(tg.innerHTML=a0),yv=r(ie),f(Va.$$.fragment,ie),vv=r(ie),ng=l(ie,"P",{"data-svelte-h":!0}),d(ng)!=="svelte-mwwpv9"&&(ng.innerHTML=s0),ie.forEach(p),xv=r(k),et=l(k,"DIV",{class:!0});var Ft=j(et);f(Ni.$$.fragment,Ft),$v=r(Ft),og=l(Ft,"P",{"data-svelte-h":!0}),d(og)!=="svelte-1ia1m9g"&&(og.textContent=r0),wv=r(Ft),f(Ba.$$.fragment,Ft),kv=r(Ft),f(Pa.$$.fragment,Ft),Ft.forEach(p),Tv=r(k),wn=l(k,"DIV",{class:!0});var ko=j(wn);f(Ai.$$.fragment,ko),jv=r(ko),ag=l(ko,"P",{"data-svelte-h":!0}),d(ag)!=="svelte-1eaf7r1"&&(ag.textContent=i0),Mv=r(ko),f(Ya.$$.fragment,ko),ko.forEach(p),qv=r(k),kn=l(k,"DIV",{class:!0});var To=j(kn);f(Ei.$$.fragment,To),Uv=r(To),sg=l(To,"P",{"data-svelte-h":!0}),d(sg)!=="svelte-zmo2i"&&(sg.textContent=c0),Hv=r(To),f(Xa.$$.fragment,To),To.forEach(p),Cv=r(k),he=l(k,"DIV",{class:!0});var He=j(he);f(Di.$$.fragment,He),Iv=r(He),rg=l(He,"P",{"data-svelte-h":!0}),d(rg)!=="svelte-1a7k7d"&&(rg.textContent=l0),Jv=r(He),ig=l(He,"P",{"data-svelte-h":!0}),d(ig)!=="svelte-ajfhh0"&&(ig.innerHTML=p0),Nv=r(He),cg=l(He,"P",{"data-svelte-h":!0}),d(cg)!=="svelte-xxbgtf"&&(cg.innerHTML=d0),Av=r(He),f(Qa.$$.fragment,He),He.forEach(p),Ev=r(k),Tn=l(k,"DIV",{class:!0});var jo=j(Tn);f(Ri.$$.fragment,jo),Dv=r(jo),lg=l(jo,"P",{"data-svelte-h":!0}),d(lg)!=="svelte-1rbvjim"&&(lg.textContent=g0),Rv=r(jo),f(za.$$.fragment,jo),jo.forEach(p),Gv=r(k),tt=l(k,"DIV",{class:!0});var St=j(tt);f(Gi.$$.fragment,St),Zv=r(St),pg=l(St,"P",{"data-svelte-h":!0}),d(pg)!=="svelte-f61qi5"&&(pg.textContent=u0),Fv=r(St),f(Oa.$$.fragment,St),Sv=r(St),f(Ka.$$.fragment,St),St.forEach(p),Lv=r(k),fe=l(k,"DIV",{class:!0});var Ce=j(fe);f(Zi.$$.fragment,Ce),Wv=r(Ce),dg=l(Ce,"P",{"data-svelte-h":!0}),d(dg)!=="svelte-5021cf"&&(dg.textContent=h0),Vv=r(Ce),gg=l(Ce,"P",{"data-svelte-h":!0}),d(gg)!=="svelte-s9x0iz"&&(gg.innerHTML=f0),Bv=r(Ce),ug=l(Ce,"P",{"data-svelte-h":!0}),d(ug)!=="svelte-1vlqxmj"&&(ug.innerHTML=m0),Pv=r(Ce),f(es.$$.fragment,Ce),Ce.forEach(p),Yv=r(k),jn=l(k,"DIV",{class:!0});var Mo=j(jn);f(Fi.$$.fragment,Mo),Xv=r(Mo),hg=l(Mo,"P",{"data-svelte-h":!0}),d(hg)!=="svelte-omx1g3"&&(hg.textContent=_0),Qv=r(Mo),f(ts.$$.fragment,Mo),Mo.forEach(p),zv=r(k),ns=l(k,"DIV",{class:!0});var Ol=j(ns);f(Si.$$.fragment,Ol),Ov=r(Ol),fg=l(Ol,"P",{"data-svelte-h":!0}),d(fg)!=="svelte-2krbhz"&&(fg.textContent=b0),Ol.forEach(p),Kv=r(k),nt=l(k,"DIV",{class:!0});var Lt=j(nt);f(Li.$$.fragment,Lt),ex=r(Lt),mg=l(Lt,"P",{"data-svelte-h":!0}),d(mg)!=="svelte-1wmqeve"&&(mg.textContent=y0),tx=r(Lt),_g=l(Lt,"P",{"data-svelte-h":!0}),d(_g)!=="svelte-11exy9j"&&(_g.innerHTML=v0),nx=r(Lt),f(os.$$.fragment,Lt),Lt.forEach(p),ox=r(k),me=l(k,"DIV",{class:!0});var Ie=j(me);f(Wi.$$.fragment,Ie),ax=r(Ie),bg=l(Ie,"P",{"data-svelte-h":!0}),d(bg)!=="svelte-lufmym"&&(bg.textContent=x0),sx=r(Ie),yg=l(Ie,"P",{"data-svelte-h":!0}),d(yg)!=="svelte-517n25"&&(yg.innerHTML=$0),rx=r(Ie),vg=l(Ie,"P",{"data-svelte-h":!0}),d(vg)!=="svelte-4np1w2"&&(vg.innerHTML=w0),ix=r(Ie),f(as.$$.fragment,Ie),Ie.forEach(p),cx=r(k),Mn=l(k,"DIV",{class:!0});var qo=j(Mn);f(Vi.$$.fragment,qo),lx=r(qo),xg=l(qo,"P",{"data-svelte-h":!0}),d(xg)!=="svelte-7xr8du"&&(xg.textContent=k0),px=r(qo),f(ss.$$.fragment,qo),qo.forEach(p),dx=r(k),rs=l(k,"DIV",{class:!0});var Kl=j(rs);f(Bi.$$.fragment,Kl),gx=r(Kl),$g=l(Kl,"P",{"data-svelte-h":!0}),d($g)!=="svelte-1lk5pt4"&&($g.textContent=T0),Kl.forEach(p),ux=r(k),qn=l(k,"DIV",{class:!0});var Uo=j(qn);f(Pi.$$.fragment,Uo),hx=r(Uo),wg=l(Uo,"P",{"data-svelte-h":!0}),d(wg)!=="svelte-1qh0k4h"&&(wg.textContent=j0),fx=r(Uo),f(is.$$.fragment,Uo),Uo.forEach(p),mx=r(k),_e=l(k,"DIV",{class:!0});var Je=j(_e);f(Yi.$$.fragment,Je),_x=r(Je),kg=l(Je,"P",{"data-svelte-h":!0}),d(kg)!=="svelte-1tc2fi9"&&(kg.textContent=M0),bx=r(Je),Tg=l(Je,"P",{"data-svelte-h":!0}),d(Tg)!=="svelte-1vz216g"&&(Tg.innerHTML=q0),yx=r(Je),jg=l(Je,"P",{"data-svelte-h":!0}),d(jg)!=="svelte-xxbgtf"&&(jg.innerHTML=U0),vx=r(Je),f(cs.$$.fragment,Je),Je.forEach(p),xx=r(k),be=l(k,"DIV",{class:!0});var Ne=j(be);f(Xi.$$.fragment,Ne),$x=r(Ne),Mg=l(Ne,"P",{"data-svelte-h":!0}),d(Mg)!=="svelte-eo3dek"&&(Mg.textContent=H0),wx=r(Ne),qg=l(Ne,"P",{"data-svelte-h":!0}),d(qg)!=="svelte-rh9cjt"&&(qg.innerHTML=C0),kx=r(Ne),Ug=l(Ne,"P",{"data-svelte-h":!0}),d(Ug)!=="svelte-xxbgtf"&&(Ug.innerHTML=I0),Tx=r(Ne),f(ls.$$.fragment,Ne),Ne.forEach(p),jx=r(k),ot=l(k,"DIV",{class:!0});var Wt=j(ot);f(Qi.$$.fragment,Wt),Mx=r(Wt),Hg=l(Wt,"P",{"data-svelte-h":!0}),d(Hg)!=="svelte-1vpgi7z"&&(Hg.textContent=J0),qx=r(Wt),Cg=l(Wt,"P",{"data-svelte-h":!0}),d(Cg)!=="svelte-11ohrqa"&&(Cg.textContent=N0),Ux=r(Wt),f(ps.$$.fragment,Wt),Wt.forEach(p),Hx=r(k),ds=l(k,"DIV",{class:!0});var ep=j(ds);f(zi.$$.fragment,ep),Cx=r(ep),Ig=l(ep,"P",{"data-svelte-h":!0}),d(Ig)!=="svelte-wnw53w"&&(Ig.textContent=A0),ep.forEach(p),Ix=r(k),Un=l(k,"DIV",{class:!0});var Ho=j(Un);f(Oi.$$.fragment,Ho),Jx=r(Ho),Jg=l(Ho,"P",{"data-svelte-h":!0}),d(Jg)!=="svelte-b4yhj"&&(Jg.textContent=E0),Nx=r(Ho),Ng=l(Ho,"P",{"data-svelte-h":!0}),d(Ng)!=="svelte-cotkoa"&&(Ng.innerHTML=D0),Ho.forEach(p),Ax=r(k),Hn=l(k,"DIV",{class:!0});var Co=j(Hn);f(Ki.$$.fragment,Co),Ex=r(Co),Ag=l(Co,"P",{"data-svelte-h":!0}),d(Ag)!=="svelte-12l2ojn"&&(Ag.textContent=R0),Dx=r(Co),f(gs.$$.fragment,Co),Co.forEach(p),Rx=r(k),Z=l(k,"DIV",{class:!0});var S=j(Z);f(ec.$$.fragment,S),Gx=r(S),Eg=l(S,"P",{"data-svelte-h":!0}),d(Eg)!=="svelte-ihiuvu"&&(Eg.textContent=G0),Zx=r(S),Dg=l(S,"P",{"data-svelte-h":!0}),d(Dg)!=="svelte-kvfsh7"&&(Dg.textContent=Z0),Fx=r(S),Rg=l(S,"P",{"data-svelte-h":!0}),d(Rg)!=="svelte-cs4ah2"&&(Rg.textContent=F0),Sx=r(S),f(us.$$.fragment,S),Lx=r(S),Gg=l(S,"P",{"data-svelte-h":!0}),d(Gg)!=="svelte-1pnedrv"&&(Gg.textContent=S0),Wx=r(S),f(hs.$$.fragment,S),S.forEach(p),Vx=r(k),fs=l(k,"DIV",{class:!0});var tp=j(fs);f(tc.$$.fragment,tp),Bx=r(tp),Zg=l(tp,"P",{"data-svelte-h":!0}),d(Zg)!=="svelte-e35pw6"&&(Zg.textContent=L0),tp.forEach(p),Px=r(k),ms=l(k,"DIV",{class:!0});var np=j(ms);f(nc.$$.fragment,np),Yx=r(np),Fg=l(np,"P",{"data-svelte-h":!0}),d(Fg)!=="svelte-uowooj"&&(Fg.textContent=W0),np.forEach(p),Xx=r(k),_s=l(k,"DIV",{class:!0});var op=j(_s);f(oc.$$.fragment,op),Qx=r(op),Sg=l(op,"P",{"data-svelte-h":!0}),d(Sg)!=="svelte-apiozp"&&(Sg.textContent=V0),op.forEach(p),zx=r(k),bs=l(k,"DIV",{class:!0});var ap=j(bs);f(ac.$$.fragment,ap),Ox=r(ap),Lg=l(ap,"P",{"data-svelte-h":!0}),d(Lg)!=="svelte-1qehg6u"&&(Lg.textContent=B0),ap.forEach(p),Kx=r(k),Cn=l(k,"DIV",{class:!0});var Io=j(Cn);f(sc.$$.fragment,Io),e$=r(Io),Wg=l(Io,"P",{"data-svelte-h":!0}),d(Wg)!=="svelte-zuangp"&&(Wg.textContent=P0),t$=r(Io),f(ys.$$.fragment,Io),Io.forEach(p),n$=r(k),In=l(k,"DIV",{class:!0});var Jo=j(In);f(rc.$$.fragment,Jo),o$=r(Jo),Vg=l(Jo,"P",{"data-svelte-h":!0}),d(Vg)!=="svelte-tnvivq"&&(Vg.textContent=Y0),a$=r(Jo),f(vs.$$.fragment,Jo),Jo.forEach(p),s$=r(k),at=l(k,"DIV",{class:!0});var Vt=j(at);f(ic.$$.fragment,Vt),r$=r(Vt),Bg=l(Vt,"P",{"data-svelte-h":!0}),d(Bg)!=="svelte-1qa90id"&&(Bg.textContent=X0),i$=r(Vt),Pg=l(Vt,"P",{"data-svelte-h":!0}),d(Pg)!=="svelte-1knrefm"&&(Pg.textContent=Q0),c$=r(Vt),f(xs.$$.fragment,Vt),Vt.forEach(p),l$=r(k),st=l(k,"DIV",{class:!0});var Bt=j(st);f(cc.$$.fragment,Bt),p$=r(Bt),Yg=l(Bt,"P",{"data-svelte-h":!0}),d(Yg)!=="svelte-3q13qo"&&(Yg.textContent=z0),d$=r(Bt),Xg=l(Bt,"P",{"data-svelte-h":!0}),d(Xg)!=="svelte-1p5ibr4"&&(Xg.innerHTML=O0),g$=r(Bt),f($s.$$.fragment,Bt),Bt.forEach(p),u$=r(k),ws=l(k,"DIV",{class:!0});var sp=j(ws);f(lc.$$.fragment,sp),h$=r(sp),Qg=l(sp,"P",{"data-svelte-h":!0}),d(Qg)!=="svelte-15c9e8d"&&(Qg.textContent=K0),sp.forEach(p),f$=r(k),rt=l(k,"DIV",{class:!0});var Pt=j(rt);f(pc.$$.fragment,Pt),m$=r(Pt),zg=l(Pt,"P",{"data-svelte-h":!0}),d(zg)!=="svelte-cs1v9f"&&(zg.textContent=ej),_$=r(Pt),Og=l(Pt,"P",{"data-svelte-h":!0}),d(Og)!=="svelte-hmt9ht"&&(Og.innerHTML=tj),b$=r(Pt),Kg=l(Pt,"P",{"data-svelte-h":!0}),d(Kg)!=="svelte-ndzof3"&&(Kg.innerHTML=nj),Pt.forEach(p),y$=r(k),it=l(k,"DIV",{class:!0});var Yt=j(it);f(dc.$$.fragment,Yt),v$=r(Yt),eu=l(Yt,"P",{"data-svelte-h":!0}),d(eu)!=="svelte-16tls2x"&&(eu.textContent=oj),x$=r(Yt),tu=l(Yt,"P",{"data-svelte-h":!0}),d(tu)!=="svelte-80m3eg"&&(tu.innerHTML=aj),$$=r(Yt),nu=l(Yt,"P",{"data-svelte-h":!0}),d(nu)!=="svelte-5ptavr"&&(nu.innerHTML=sj),Yt.forEach(p),w$=r(k),ct=l(k,"DIV",{class:!0});var Xt=j(ct);f(gc.$$.fragment,Xt),k$=r(Xt),ou=l(Xt,"P",{"data-svelte-h":!0}),d(ou)!=="svelte-keb9bv"&&(ou.textContent=rj),T$=r(Xt),au=l(Xt,"P",{"data-svelte-h":!0}),d(au)!=="svelte-15wjl3y"&&(au.innerHTML=ij),j$=r(Xt),su=l(Xt,"P",{"data-svelte-h":!0}),d(su)!=="svelte-12do56u"&&(su.innerHTML=cj),Xt.forEach(p),M$=r(k),lt=l(k,"DIV",{class:!0});var Qt=j(lt);f(uc.$$.fragment,Qt),q$=r(Qt),ru=l(Qt,"P",{"data-svelte-h":!0}),d(ru)!=="svelte-10xq13g"&&(ru.textContent=lj),U$=r(Qt),f(ks.$$.fragment,Qt),H$=r(Qt),f(Ts.$$.fragment,Qt),Qt.forEach(p),C$=r(k),X=l(k,"DIV",{class:!0});var ce=j(X);f(hc.$$.fragment,ce),I$=r(ce),iu=l(ce,"P",{"data-svelte-h":!0}),d(iu)!=="svelte-13c8xg2"&&(iu.textContent=pj),J$=r(ce),cu=l(ce,"P",{"data-svelte-h":!0}),d(cu)!=="svelte-5htwml"&&(cu.textContent=dj),N$=r(ce),f(js.$$.fragment,ce),A$=r(ce),f(Ms.$$.fragment,ce),E$=r(ce),f(qs.$$.fragment,ce),ce.forEach(p),D$=r(k),pt=l(k,"DIV",{class:!0});var zt=j(pt);f(fc.$$.fragment,zt),R$=r(zt),lu=l(zt,"P",{"data-svelte-h":!0}),d(lu)!=="svelte-1o1ui5j"&&(lu.textContent=gj),G$=r(zt),pu=l(zt,"P",{"data-svelte-h":!0}),d(pu)!=="svelte-ptggg8"&&(pu.innerHTML=uj),Z$=r(zt),du=l(zt,"P",{"data-svelte-h":!0}),d(du)!=="svelte-xxbgtf"&&(du.innerHTML=hj),zt.forEach(p),F$=r(k),dt=l(k,"DIV",{class:!0});var Ot=j(dt);f(mc.$$.fragment,Ot),S$=r(Ot),gu=l(Ot,"P",{"data-svelte-h":!0}),d(gu)!=="svelte-vjmct2"&&(gu.textContent=fj),L$=r(Ot),f(Us.$$.fragment,Ot),W$=r(Ot),f(Hs.$$.fragment,Ot),Ot.forEach(p),V$=r(k),Jn=l(k,"DIV",{class:!0});var No=j(Jn);f(_c.$$.fragment,No),B$=r(No),uu=l(No,"P",{"data-svelte-h":!0}),d(uu)!=="svelte-1h0ufuc"&&(uu.textContent=mj),P$=r(No),f(Cs.$$.fragment,No),No.forEach(p),Y$=r(k),Nn=l(k,"DIV",{class:!0});var Ao=j(Nn);f(bc.$$.fragment,Ao),X$=r(Ao),hu=l(Ao,"P",{"data-svelte-h":!0}),d(hu)!=="svelte-1my46uo"&&(hu.textContent=_j),Q$=r(Ao),f(Is.$$.fragment,Ao),Ao.forEach(p),z$=r(k),An=l(k,"DIV",{class:!0});var Eo=j(An);f(yc.$$.fragment,Eo),O$=r(Eo),fu=l(Eo,"P",{"data-svelte-h":!0}),d(fu)!=="svelte-5pcxuz"&&(fu.textContent=bj),K$=r(Eo),f(Js.$$.fragment,Eo),Eo.forEach(p),e2=r(k),En=l(k,"DIV",{class:!0});var Do=j(En);f(vc.$$.fragment,Do),t2=r(Do),mu=l(Do,"P",{"data-svelte-h":!0}),d(mu)!=="svelte-10aqzwl"&&(mu.textContent=yj),n2=r(Do),f(Ns.$$.fragment,Do),Do.forEach(p),o2=r(k),gt=l(k,"DIV",{class:!0});var Kt=j(gt);f(xc.$$.fragment,Kt),a2=r(Kt),_u=l(Kt,"P",{"data-svelte-h":!0}),d(_u)!=="svelte-38gi4y"&&(_u.textContent=vj),s2=r(Kt),bu=l(Kt,"P",{"data-svelte-h":!0}),d(bu)!=="svelte-zwgc7q"&&(bu.innerHTML=xj),r2=r(Kt),yu=l(Kt,"P",{"data-svelte-h":!0}),d(yu)!=="svelte-12do56u"&&(yu.innerHTML=$j),Kt.forEach(p),i2=r(k),Dn=l(k,"DIV",{class:!0});var Ro=j(Dn);f($c.$$.fragment,Ro),c2=r(Ro),vu=l(Ro,"P",{"data-svelte-h":!0}),d(vu)!=="svelte-o2dz8s"&&(vu.textContent=wj),l2=r(Ro),xu=l(Ro,"P",{"data-svelte-h":!0}),d(xu)!=="svelte-1drucw9"&&(xu.innerHTML=kj),Ro.forEach(p),p2=r(k),As=l(k,"DIV",{class:!0});var rp=j(As);f(wc.$$.fragment,rp),d2=r(rp),$u=l(rp,"P",{"data-svelte-h":!0}),d($u)!=="svelte-1772xvt"&&($u.textContent=Tj),rp.forEach(p),g2=r(k),Rn=l(k,"DIV",{class:!0});var Go=j(Rn);f(kc.$$.fragment,Go),u2=r(Go),wu=l(Go,"P",{"data-svelte-h":!0}),d(wu)!=="svelte-kx7a2l"&&(wu.textContent=jj),h2=r(Go),f(Es.$$.fragment,Go),Go.forEach(p),f2=r(k),ye=l(k,"DIV",{class:!0});var Ae=j(ye);f(Tc.$$.fragment,Ae),m2=r(Ae),ku=l(Ae,"P",{"data-svelte-h":!0}),d(ku)!=="svelte-i4rj9b"&&(ku.textContent=Mj),_2=r(Ae),Tu=l(Ae,"P",{"data-svelte-h":!0}),d(Tu)!=="svelte-15iw2gd"&&(Tu.innerHTML=qj),b2=r(Ae),ju=l(Ae,"P",{"data-svelte-h":!0}),d(ju)!=="svelte-1f3ta7h"&&(ju.innerHTML=Uj),y2=r(Ae),f(Ds.$$.fragment,Ae),Ae.forEach(p),v2=r(k),ve=l(k,"DIV",{class:!0});var Ee=j(ve);f(jc.$$.fragment,Ee),x2=r(Ee),Mu=l(Ee,"P",{"data-svelte-h":!0}),d(Mu)!=="svelte-1o4vhqw"&&(Mu.textContent=Hj),$2=r(Ee),qu=l(Ee,"P",{"data-svelte-h":!0}),d(qu)!=="svelte-11lpom8"&&(qu.textContent=Cj),w2=r(Ee),f(Rs.$$.fragment,Ee),k2=r(Ee),f(Gs.$$.fragment,Ee),Ee.forEach(p),T2=r(k),Q=l(k,"DIV",{class:!0});var le=j(Q);f(Mc.$$.fragment,le),j2=r(le),Uu=l(le,"P",{"data-svelte-h":!0}),d(Uu)!=="svelte-13uq06b"&&(Uu.textContent=Ij),M2=r(le),Hu=l(le,"P",{"data-svelte-h":!0}),d(Hu)!=="svelte-11lpom8"&&(Hu.textContent=Jj),q2=r(le),f(Zs.$$.fragment,le),U2=r(le),f(Fs.$$.fragment,le),H2=r(le),f(Ss.$$.fragment,le),le.forEach(p),C2=r(k),ut=l(k,"DIV",{class:!0});var en=j(ut);f(qc.$$.fragment,en),I2=r(en),Cu=l(en,"P",{"data-svelte-h":!0}),d(Cu)!=="svelte-6vx93v"&&(Cu.textContent=Nj),J2=r(en),Iu=l(en,"P",{"data-svelte-h":!0}),d(Iu)!=="svelte-153amg4"&&(Iu.innerHTML=Aj),N2=r(en),Ju=l(en,"P",{"data-svelte-h":!0}),d(Ju)!=="svelte-dx5ct"&&(Ju.innerHTML=Ej),en.forEach(p),A2=r(k),ht=l(k,"DIV",{class:!0});var tn=j(ht);f(Uc.$$.fragment,tn),E2=r(tn),Nu=l(tn,"P",{"data-svelte-h":!0}),d(Nu)!=="svelte-h8ye5s"&&(Nu.textContent=Dj),D2=r(tn),Au=l(tn,"P",{"data-svelte-h":!0}),d(Au)!=="svelte-1u14fwi"&&(Au.innerHTML=Rj),R2=r(tn),f(Ls.$$.fragment,tn),tn.forEach(p),G2=r(k),xe=l(k,"DIV",{class:!0});var De=j(xe);f(Hc.$$.fragment,De),Z2=r(De),Eu=l(De,"P",{"data-svelte-h":!0}),d(Eu)!=="svelte-t9d1pp"&&(Eu.textContent=Gj),F2=r(De),Du=l(De,"P",{"data-svelte-h":!0}),d(Du)!=="svelte-xxyl9g"&&(Du.innerHTML=Zj),S2=r(De),Ru=l(De,"P",{"data-svelte-h":!0}),d(Ru)!=="svelte-1v8h65f"&&(Ru.innerHTML=Fj),L2=r(De),Gu=l(De,"P",{"data-svelte-h":!0}),d(Gu)!=="svelte-k7g81c"&&(Gu.textContent=Sj),De.forEach(p),W2=r(k),ft=l(k,"DIV",{class:!0});var nn=j(ft);f(Cc.$$.fragment,nn),V2=r(nn),Zu=l(nn,"P",{"data-svelte-h":!0}),d(Zu)!=="svelte-1lgtcoe"&&(Zu.textContent=Lj),B2=r(nn),Fu=l(nn,"P",{"data-svelte-h":!0}),d(Fu)!=="svelte-zugpyn"&&(Fu.textContent=Wj),P2=r(nn),f(Ws.$$.fragment,nn),nn.forEach(p),Y2=r(k),z=l(k,"DIV",{class:!0});var pe=j(z);f(Ic.$$.fragment,pe),X2=r(pe),Su=l(pe,"P",{"data-svelte-h":!0}),d(Su)!=="svelte-1j5taqn"&&(Su.textContent=Vj),Q2=r(pe),Lu=l(pe,"P",{"data-svelte-h":!0}),d(Lu)!=="svelte-1oloczu"&&(Lu.textContent=Bj),z2=r(pe),f(Vs.$$.fragment,pe),O2=r(pe),f(Bs.$$.fragment,pe),K2=r(pe),f(Ps.$$.fragment,pe),pe.forEach(p),e1=r(k),Ys=l(k,"DIV",{class:!0});var ip=j(Ys);f(Jc.$$.fragment,ip),t1=r(ip),Wu=l(ip,"P",{"data-svelte-h":!0}),d(Wu)!=="svelte-1lxxeyj"&&(Wu.textContent=Pj),ip.forEach(p),n1=r(k),$e=l(k,"DIV",{class:!0});var Re=j($e);f(Nc.$$.fragment,Re),o1=r(Re),Vu=l(Re,"P",{"data-svelte-h":!0}),d(Vu)!=="svelte-z82c1y"&&(Vu.textContent=Yj),a1=r(Re),Bu=l(Re,"P",{"data-svelte-h":!0}),d(Bu)!=="svelte-w9m9bs"&&(Bu.innerHTML=Xj),s1=r(Re),Pu=l(Re,"P",{"data-svelte-h":!0}),d(Pu)!=="svelte-cotkoa"&&(Pu.innerHTML=Qj),r1=r(Re),f(Xs.$$.fragment,Re),Re.forEach(p),i1=r(k),Gn=l(k,"DIV",{class:!0});var uf=j(Gn);f(Ac.$$.fragment,uf),c1=r(uf),Yu=l(uf,"P",{"data-svelte-h":!0}),d(Yu)!=="svelte-klf1wz"&&(Yu.textContent=zj),l1=r(uf),f(Qs.$$.fragment,uf),uf.forEach(p),p1=r(k),we=l(k,"DIV",{class:!0});var Bn=j(we);f(Ec.$$.fragment,Bn),d1=r(Bn),Xu=l(Bn,"P",{"data-svelte-h":!0}),d(Xu)!=="svelte-6tdefx"&&(Xu.textContent=Oj),g1=r(Bn),Qu=l(Bn,"P",{"data-svelte-h":!0}),d(Qu)!=="svelte-sjutdt"&&(Qu.textContent=Kj),u1=r(Bn),zu=l(Bn,"P",{"data-svelte-h":!0}),d(zu)!=="svelte-17aw16u"&&(zu.innerHTML=eM),h1=r(Bn),f(zs.$$.fragment,Bn),Bn.forEach(p),f1=r(k),mt=l(k,"DIV",{class:!0});var yr=j(mt);f(Dc.$$.fragment,yr),m1=r(yr),Ou=l(yr,"P",{"data-svelte-h":!0}),d(Ou)!=="svelte-tgkk8q"&&(Ou.textContent=tM),_1=r(yr),Ku=l(yr,"P",{"data-svelte-h":!0}),d(Ku)!=="svelte-1yeoh0w"&&(Ku.textContent=nM),b1=r(yr),eh=l(yr,"P",{"data-svelte-h":!0}),d(eh)!=="svelte-1xddutv"&&(eh.innerHTML=oM),yr.forEach(p),y1=r(k),Zn=l(k,"DIV",{class:!0});var hf=j(Zn);f(Rc.$$.fragment,hf),v1=r(hf),th=l(hf,"P",{"data-svelte-h":!0}),d(th)!=="svelte-1xslq7e"&&(th.textContent=aM),x1=r(hf),nh=l(hf,"P",{"data-svelte-h":!0}),d(nh)!=="svelte-zgmljc"&&(nh.textContent=sM),hf.forEach(p),$1=r(k),_t=l(k,"DIV",{class:!0});var vr=j(_t);f(Gc.$$.fragment,vr),w1=r(vr),oh=l(vr,"P",{"data-svelte-h":!0}),d(oh)!=="svelte-1icdi1y"&&(oh.textContent=rM),k1=r(vr),ah=l(vr,"P",{"data-svelte-h":!0}),d(ah)!=="svelte-1b93kvt"&&(ah.innerHTML=iM),T1=r(vr),f(Os.$$.fragment,vr),vr.forEach(p),j1=r(k),Fn=l(k,"DIV",{class:!0});var ff=j(Fn);f(Zc.$$.fragment,ff),M1=r(ff),sh=l(ff,"P",{"data-svelte-h":!0}),d(sh)!=="svelte-1a9paom"&&(sh.textContent=cM),q1=r(ff),f(Ks.$$.fragment,ff),ff.forEach(p),U1=r(k),ke=l(k,"DIV",{class:!0});var Pn=j(ke);f(Fc.$$.fragment,Pn),H1=r(Pn),rh=l(Pn,"P",{"data-svelte-h":!0}),d(rh)!=="svelte-kukbcr"&&(rh.textContent=lM),C1=r(Pn),f(er.$$.fragment,Pn),I1=r(Pn),f(tr.$$.fragment,Pn),J1=r(Pn),f(nr.$$.fragment,Pn),Pn.forEach(p),N1=r(k),N=l(k,"DIV",{class:!0});var E=j(N);f(Sc.$$.fragment,E),A1=r(E),ih=l(E,"P",{"data-svelte-h":!0}),d(ih)!=="svelte-1nvey1d"&&(ih.textContent=pM),E1=r(E),ch=l(E,"P",{"data-svelte-h":!0}),d(ch)!=="svelte-1vu0l4l"&&(ch.textContent=dM),D1=r(E),lh=l(E,"P",{"data-svelte-h":!0}),d(lh)!=="svelte-adrskp"&&(lh.innerHTML=gM),R1=r(E),ph=l(E,"P",{"data-svelte-h":!0}),d(ph)!=="svelte-1m6fudm"&&(ph.innerHTML=uM),G1=r(E),dh=l(E,"P",{"data-svelte-h":!0}),d(dh)!=="svelte-nojwu3"&&(dh.innerHTML=hM),Z1=r(E),gh=l(E,"P",{"data-svelte-h":!0}),d(gh)!=="svelte-90ewc6"&&(gh.innerHTML=fM),F1=r(E),f(or.$$.fragment,E),S1=r(E),f(ar.$$.fragment,E),L1=r(E),f(sr.$$.fragment,E),W1=r(E),f(rr.$$.fragment,E),E.forEach(p),V1=r(k),J=l(k,"DIV",{class:!0});var A=j(J);f(Lc.$$.fragment,A),B1=r(A),uh=l(A,"P",{"data-svelte-h":!0}),d(uh)!=="svelte-1a1ittk"&&(uh.textContent=mM),P1=r(A),hh=l(A,"P",{"data-svelte-h":!0}),d(hh)!=="svelte-3l9535"&&(hh.innerHTML=_M),Y1=r(A),f(ir.$$.fragment,A),X1=r(A),f(cr.$$.fragment,A),Q1=r(A),fh=l(A,"P",{"data-svelte-h":!0}),d(fh)!=="svelte-8c4beu"&&(fh.innerHTML=bM),z1=r(A),mh=l(A,"P",{"data-svelte-h":!0}),d(mh)!=="svelte-25734v"&&(mh.innerHTML=yM),O1=r(A),_h=l(A,"OL",{"data-svelte-h":!0}),d(_h)!=="svelte-1lqi3gd"&&(_h.innerHTML=vM),K1=r(A),bh=l(A,"P",{"data-svelte-h":!0}),d(bh)!=="svelte-59ei85"&&(bh.textContent=xM),ew=r(A),yh=l(A,"OL",{"data-svelte-h":!0}),d(yh)!=="svelte-1igkyl7"&&(yh.innerHTML=$M),tw=r(A),vh=l(A,"P",{"data-svelte-h":!0}),d(vh)!=="svelte-w718ua"&&(vh.textContent=wM),nw=r(A),xh=l(A,"UL",{"data-svelte-h":!0}),d(xh)!=="svelte-c57nbb"&&(xh.innerHTML=kM),A.forEach(p),ow=r(k),lr=l(k,"DIV",{class:!0});var $m=j(lr);f(Wc.$$.fragment,$m),aw=r($m),$h=l($m,"P",{"data-svelte-h":!0}),d($h)!=="svelte-l7gr50"&&($h.textContent=TM),$m.forEach(p),k.forEach(p),Jf=r(o),f(Vc.$$.fragment,o),Nf=r(o),f(Bc.$$.fragment,o),Af=r(o),zn=l(o,"DIV",{class:!0});var wm=j(zn);f(Pc.$$.fragment,wm),sw=r(wm),wh=l(wm,"P",{"data-svelte-h":!0}),d(wh)!=="svelte-frgpd7"&&(wh.textContent=jM),wm.forEach(p),Ef=r(o),f(Yc.$$.fragment,o),Df=r(o),yt=l(o,"DIV",{class:!0});var mf=j(yt);f(Xc.$$.fragment,mf),rw=r(mf),kh=l(mf,"P",{"data-svelte-h":!0}),d(kh)!=="svelte-n4j72f"&&(kh.textContent=MM),iw=r(mf),Th=l(mf,"P",{"data-svelte-h":!0}),d(Th)!=="svelte-92iwcm"&&(Th.innerHTML=qM),mf.forEach(p),Rf=r(o),f(Qc.$$.fragment,o),Gf=r(o),vt=l(o,"DIV",{class:!0});var _f=j(vt);f(zc.$$.fragment,_f),cw=r(_f),jh=l(_f,"P",{"data-svelte-h":!0}),d(jh)!=="svelte-1g7on68"&&(jh.innerHTML=UM),lw=r(_f),f(pr.$$.fragment,_f),_f.forEach(p),Zf=r(o),f(Oc.$$.fragment,o),Ff=r(o),On=l(o,"DIV",{class:!0});var km=j(On);f(Kc.$$.fragment,km),pw=r(km),Mh=l(km,"P",{"data-svelte-h":!0}),d(Mh)!=="svelte-1dp8z99"&&(Mh.textContent=HM),km.forEach(p),Sf=r(o),f(el.$$.fragment,o),Lf=r(o),Kn=l(o,"DIV",{class:!0});var Tm=j(Kn);f(tl.$$.fragment,Tm),dw=r(Tm),qh=l(Tm,"P",{"data-svelte-h":!0}),d(qh)!=="svelte-17whmxr"&&(qh.innerHTML=CM),Tm.forEach(p),Wf=r(o),f(nl.$$.fragment,o),Vf=r(o),xt=l(o,"DIV",{class:!0});var bf=j(xt);f(ol.$$.fragment,bf),gw=r(bf),Uh=l(bf,"P",{"data-svelte-h":!0}),d(Uh)!=="svelte-8pkqdq"&&(Uh.textContent=IM),uw=r(bf),Hh=l(bf,"P",{"data-svelte-h":!0}),d(Hh)!=="svelte-1c8qold"&&(Hh.innerHTML=JM),bf.forEach(p),Bf=r(o),f(al.$$.fragment,o),Pf=r(o),$t=l(o,"DIV",{class:!0});var yf=j($t);f(sl.$$.fragment,yf),hw=r(yf),Ch=l(yf,"P",{"data-svelte-h":!0}),d(Ch)!=="svelte-1yho2x9"&&(Ch.innerHTML=NM),fw=r(yf),f(dr.$$.fragment,yf),yf.forEach(p),Yf=r(o),f(rl.$$.fragment,o),Xf=r(o),wt=l(o,"DIV",{class:!0});var vf=j(wt);f(il.$$.fragment,vf),mw=r(vf),Ih=l(vf,"P",{"data-svelte-h":!0}),d(Ih)!=="svelte-pzc88f"&&(Ih.textContent=AM),_w=r(vf),f(gr.$$.fragment,vf),vf.forEach(p),Qf=r(o),f(cl.$$.fragment,o),zf=r(o),eo=l(o,"DIV",{class:!0});var jm=j(eo);f(ll.$$.fragment,jm),bw=r(jm),Jh=l(jm,"P",{"data-svelte-h":!0}),d(Jh)!=="svelte-1eicjbk"&&(Jh.textContent=EM),jm.forEach(p),Of=r(o),f(pl.$$.fragment,o),Kf=r(o),K=l(o,"DIV",{class:!0});var Yn=j(K);f(dl.$$.fragment,Yn),yw=r(Yn),Nh=l(Yn,"P",{"data-svelte-h":!0}),d(Nh)!=="svelte-1v78htg"&&(Nh.innerHTML=DM),vw=r(Yn),Ah=l(Yn,"P",{"data-svelte-h":!0}),d(Ah)!=="svelte-murgw9"&&(Ah.innerHTML=RM),xw=r(Yn),Eh=l(Yn,"UL",{"data-svelte-h":!0}),d(Eh)!=="svelte-1mrng5l"&&(Eh.innerHTML=GM),$w=r(Yn),f(ur.$$.fragment,Yn),Yn.forEach(p),em=r(o),f(gl.$$.fragment,o),tm=r(o),ee=l(o,"DIV",{class:!0});var Xn=j(ee);f(ul.$$.fragment,Xn),ww=r(Xn),Dh=l(Xn,"P",{"data-svelte-h":!0}),d(Dh)!=="svelte-ovnxfi"&&(Dh.textContent=ZM),kw=r(Xn),Rh=l(Xn,"P",{"data-svelte-h":!0}),d(Rh)!=="svelte-afv8fv"&&(Rh.textContent=FM),Tw=r(Xn),Gh=l(Xn,"P",{"data-svelte-h":!0}),d(Gh)!=="svelte-1pzb93s"&&(Gh.innerHTML=SM),jw=r(Xn),Zh=l(Xn,"P",{"data-svelte-h":!0}),d(Zh)!=="svelte-ndzof3"&&(Zh.innerHTML=LM),Xn.forEach(p),nm=r(o),f(hl.$$.fragment,o),om=r(o),Te=l(o,"DIV",{class:!0});var xr=j(Te);f(fl.$$.fragment,xr),Mw=r(xr),Fh=l(xr,"P",{"data-svelte-h":!0}),d(Fh)!=="svelte-2ejdv8"&&(Fh.textContent=WM),qw=r(xr),Sh=l(xr,"P",{"data-svelte-h":!0}),d(Sh)!=="svelte-1t8oovk"&&(Sh.innerHTML=VM),Uw=r(xr),Lh=l(xr,"P",{"data-svelte-h":!0}),d(Lh)!=="svelte-ndzof3"&&(Lh.innerHTML=BM),xr.forEach(p),am=r(o),f(ml.$$.fragment,o),sm=r(o),kt=l(o,"DIV",{class:!0});var xf=j(kt);f(_l.$$.fragment,xf),Hw=r(xf),Wh=l(xf,"P",{"data-svelte-h":!0}),d(Wh)!=="svelte-7afg0a"&&(Wh.innerHTML=PM),Cw=r(xf),f(hr.$$.fragment,xf),xf.forEach(p),rm=r(o),f(bl.$$.fragment,o),im=r(o),Tt=l(o,"DIV",{class:!0});var $f=j(Tt);f(yl.$$.fragment,$f),Iw=r($f),Vh=l($f,"P",{"data-svelte-h":!0}),d(Vh)!=="svelte-by9v9h"&&(Vh.textContent=YM),Jw=r($f),Bh=l($f,"P",{"data-svelte-h":!0}),d(Bh)!=="svelte-ndzof3"&&(Bh.innerHTML=XM),$f.forEach(p),cm=r(o),f(vl.$$.fragment,o),lm=r(o),to=l(o,"DIV",{class:!0});var Mm=j(to);f(xl.$$.fragment,Mm),Nw=r(Mm),Ph=l(Mm,"P",{"data-svelte-h":!0}),d(Ph)!=="svelte-f10xp"&&(Ph.textContent=QM),Mm.forEach(p),pm=r(o),f($l.$$.fragment,o),dm=r(o),no=l(o,"DIV",{class:!0});var qm=j(no);f(wl.$$.fragment,qm),Aw=r(qm),Yh=l(qm,"P",{"data-svelte-h":!0}),d(Yh)!=="svelte-s36het"&&(Yh.textContent=zM),qm.forEach(p),gm=r(o),f(kl.$$.fragment,o),um=r(o),Tl=l(o,"P",{"data-svelte-h":!0}),d(Tl)!=="svelte-141kvtu"&&(Tl.innerHTML=OM),hm=r(o),je=l(o,"DIV",{class:!0});var $r=j(je);f(jl.$$.fragment,$r),Ew=r($r),Xh=l($r,"P",{"data-svelte-h":!0}),d(Xh)!=="svelte-1nyzeix"&&(Xh.textContent=KM),Dw=r($r),Sn=l($r,"DIV",{class:!0});var wf=j(Sn);f(Ml.$$.fragment,wf),Rw=r(wf),Qh=l(wf,"P",{"data-svelte-h":!0}),d(Qh)!=="svelte-1d7s5nc"&&(Qh.innerHTML=eq),Gw=r(wf),f(fr.$$.fragment,wf),wf.forEach(p),Zw=r($r),Ln=l($r,"DIV",{class:!0});var kf=j(Ln);f(ql.$$.fragment,kf),Fw=r(kf),zh=l(kf,"P",{"data-svelte-h":!0}),d(zh)!=="svelte-1o44akx"&&(zh.innerHTML=tq),Sw=r(kf),Oh=l(kf,"P",{"data-svelte-h":!0}),d(Oh)!=="svelte-huzhzj"&&(Oh.innerHTML=nq),kf.forEach(p),$r.forEach(p),fm=r(o),oo=l(o,"DIV",{class:!0});var Um=j(oo);f(Ul.$$.fragment,Um),Lw=r(Um),Kh=l(Um,"P",{"data-svelte-h":!0}),d(Kh)!=="svelte-1cij9yu"&&(Kh.textContent=oq),Um.forEach(p),mm=r(o),te=l(o,"DIV",{class:!0});var Qn=j(te);f(Hl.$$.fragment,Qn),Ww=r(Qn),ef=l(Qn,"P",{"data-svelte-h":!0}),d(ef)!=="svelte-bx32lj"&&(ef.textContent=aq),Vw=r(Qn),tf=l(Qn,"P",{"data-svelte-h":!0}),d(tf)!=="svelte-1a6nwfz"&&(tf.textContent=sq),Bw=r(Qn),nf=l(Qn,"UL",{"data-svelte-h":!0}),d(nf)!=="svelte-1wreq5n"&&(nf.innerHTML=rq),Pw=r(Qn),of=l(Qn,"P",{"data-svelte-h":!0}),d(of)!=="svelte-fipu1x"&&(of.innerHTML=iq),Qn.forEach(p),_m=r(o),f(Cl.$$.fragment,o),bm=r(o),D=l(o,"DIV",{class:!0});var O=j(D);f(Il.$$.fragment,O),Yw=r(O),af=l(O,"P",{"data-svelte-h":!0}),d(af)!=="svelte-1wfz9hx"&&(af.textContent=cq),Xw=r(O),sf=l(O,"P",{"data-svelte-h":!0}),d(sf)!=="svelte-10g22je"&&(sf.innerHTML=lq),Qw=r(O),f(mr.$$.fragment,O),zw=r(O),f(_r.$$.fragment,O),Ow=r(O),bt=l(O,"DIV",{class:!0});var wr=j(bt);f(Jl.$$.fragment,wr),Kw=r(wr),rf=l(wr,"P",{"data-svelte-h":!0}),d(rf)!=="svelte-e95u7k"&&(rf.textContent=pq),ek=r(wr),f(br.$$.fragment,wr),tk=r(wr),cf=l(wr,"P",{"data-svelte-h":!0}),d(cf)!=="svelte-ulgg79"&&(cf.innerHTML=dq),wr.forEach(p),nk=r(O),Wn=l(O,"DIV",{class:!0});var Tf=j(Wn);f(Nl.$$.fragment,Tf),ok=r(Tf),lf=l(Tf,"P",{"data-svelte-h":!0}),d(lf)!=="svelte-t1x1k0"&&(lf.textContent=gq),ak=r(Tf),pf=l(Tf,"P",{"data-svelte-h":!0}),d(pf)!=="svelte-1jdo3t2"&&(pf.textContent=uq),Tf.forEach(p),sk=r(O),Vn=l(O,"DIV",{class:!0});var jf=j(Vn);f(Al.$$.fragment,jf),rk=r(jf),df=l(jf,"P",{"data-svelte-h":!0}),d(df)!=="svelte-m2dnyn"&&(df.innerHTML=hq),ik=r(jf),gf=l(jf,"P",{"data-svelte-h":!0}),d(gf)!=="svelte-aasb0o"&&(gf.innerHTML=fq),jf.forEach(p),O.forEach(p),ym=r(o),f(El.$$.fragment,o),vm=r(o),Mf=l(o,"P",{}),j(Mf).forEach(p),this.h()},h(){M(t,"name","hf:doc:metadata"),M(t,"content",IH),M(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(on,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(an,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(So,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Po,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(aa,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(da,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(sn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ha,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(rn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ln,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ya,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(va,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xa,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(gn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($a,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(fn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(bn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ca,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ja,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Na,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(yn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ea,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(vn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Fa,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(La,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(wn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(kn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(jn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ns,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(rs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(qn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ds,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(fs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ms,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_s,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(bs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(In,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(at,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ws,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(it,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(dt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Jn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Nn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(An,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(En,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(As,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Rn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ht,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ys,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Gn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Fn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(lr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(yt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(On,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Kn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(eo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(kt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(to,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(no,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Sn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ln,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(oo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Wn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Vn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(o,x){n(document.head,t),$(o,u,x),$(o,i,x),$(o,a,x),m(g,o,x),$(o,e,x),$(o,v,x),$(o,qf,x),$(o,kr,x),$(o,Uf,x),$(o,Tr,x),$(o,Hf,x),m(jr,o,x),$(o,Cf,x),m(Mr,o,x),$(o,If,x),$(o,w,x),m(qr,w,null),n(w,Hm),n(w,cp),n(w,Cm),n(w,lp),n(w,Im),n(w,Ge),m(Ur,Ge,null),n(Ge,Jm),n(Ge,pp),n(Ge,Nm),n(Ge,dp),n(Ge,Am),n(Ge,gp),n(w,Em),n(w,Ze),m(Hr,Ze,null),n(Ze,Dm),n(Ze,up),n(Ze,Rm),n(Ze,hp),n(Ze,Gm),m(Zo,Ze,null),n(w,Zm),n(w,on),m(Cr,on,null),n(on,Fm),n(on,fp),n(on,Sm),n(on,mp),n(w,Lm),n(w,an),m(Ir,an,null),n(an,Wm),n(an,_p),n(an,Vm),n(an,bp),n(w,Bm),n(w,G),m(Jr,G,null),n(G,Pm),n(G,yp),n(G,Ym),n(G,vp),n(G,Xm),n(G,xp),n(G,Qm),m(Fo,G,null),n(G,zm),n(G,$p),n(G,Om),n(G,wp),n(w,Km),n(w,Fe),m(Nr,Fe,null),n(Fe,e_),n(Fe,kp),n(Fe,t_),n(Fe,Tp),n(Fe,n_),n(Fe,jp),n(w,o_),n(w,So),m(Ar,So,null),n(So,a_),n(So,Mp),n(w,s_),n(w,Se),m(Er,Se,null),n(Se,r_),n(Se,qp),n(Se,i_),m(Lo,Se,null),n(Se,c_),m(Wo,Se,null),n(w,l_),n(w,Le),m(Dr,Le,null),n(Le,p_),n(Le,Up),n(Le,d_),m(Vo,Le,null),n(Le,g_),m(Bo,Le,null),n(w,u_),n(w,Po),m(Rr,Po,null),n(Po,h_),n(Po,Hp),n(w,f_),n(w,We),m(Gr,We,null),n(We,m_),n(We,Cp),n(We,__),n(We,Ip),n(We,b_),m(Yo,We,null),n(w,y_),n(w,de),m(Zr,de,null),n(de,v_),n(de,Jp),n(de,x_),m(Xo,de,null),n(de,$_),m(Qo,de,null),n(de,w_),m(zo,de,null),n(w,k_),n(w,L),m(Fr,L,null),n(L,T_),n(L,Np),n(L,j_),n(L,Ap),n(L,M_),n(L,Ep),n(L,q_),n(L,Dp),n(L,U_),m(Oo,L,null),n(w,H_),n(w,ge),m(Sr,ge,null),n(ge,C_),n(ge,Rp),n(ge,I_),m(Ko,ge,null),n(ge,J_),m(ea,ge,null),n(ge,N_),m(ta,ge,null),n(w,A_),n(w,Ve),m(Lr,Ve,null),n(Ve,E_),n(Ve,Gp),n(Ve,D_),n(Ve,Zp),n(Ve,R_),m(na,Ve,null),n(w,G_),n(w,W),m(Wr,W,null),n(W,Z_),n(W,Fp),n(W,F_),n(W,Sp),n(W,S_),n(W,Lp),n(W,L_),n(W,Wp),n(W,W_),m(oa,W,null),n(w,V_),n(w,aa),m(Vr,aa,null),n(aa,B_),n(aa,Vp),n(w,P_),n(w,V),m(Br,V,null),n(V,Y_),n(V,Bp),n(V,X_),n(V,Pp),n(V,Q_),m(sa,V,null),n(V,z_),m(ra,V,null),n(V,O_),m(ia,V,null),n(w,K_),n(w,B),m(Pr,B,null),n(B,eb),n(B,Yp),n(B,tb),n(B,Xp),n(B,nb),m(ca,B,null),n(B,ob),m(la,B,null),n(B,ab),m(pa,B,null),n(w,sb),n(w,da),m(Yr,da,null),n(da,rb),n(da,Qp),n(w,ib),n(w,sn),m(Xr,sn,null),n(sn,cb),n(sn,zp),n(sn,lb),m(ga,sn,null),n(w,pb),n(w,Be),m(Qr,Be,null),n(Be,db),n(Be,Op),n(Be,gb),n(Be,Kp),n(Be,ub),m(ua,Be,null),n(w,hb),n(w,ha),m(zr,ha,null),n(ha,fb),n(ha,ed),n(w,mb),n(w,Pe),m(Or,Pe,null),n(Pe,_b),n(Pe,td),n(Pe,bb),m(fa,Pe,null),n(Pe,yb),m(ma,Pe,null),n(w,vb),n(w,rn),m(Kr,rn,null),n(rn,xb),n(rn,nd),n(rn,$b),m(_a,rn,null),n(w,wb),n(w,cn),m(ei,cn,null),n(cn,kb),n(cn,od),n(cn,Tb),m(ba,cn,null),n(w,jb),n(w,ln),m(ti,ln,null),n(ln,Mb),n(ln,ad),n(ln,qb),n(ln,sd),n(w,Ub),n(w,pn),m(ni,pn,null),n(pn,Hb),n(pn,rd),n(pn,Cb),n(pn,id),n(w,Ib),n(w,Ye),m(oi,Ye,null),n(Ye,Jb),n(Ye,cd),n(Ye,Nb),n(Ye,ld),n(Ye,Ab),n(Ye,pd),n(w,Eb),n(w,ya),m(ai,ya,null),n(ya,Db),n(ya,dd),n(w,Rb),n(w,va),m(si,va,null),n(va,Gb),n(va,gd),n(w,Zb),n(w,dn),m(ri,dn,null),n(dn,Fb),n(dn,ud),n(dn,Sb),n(dn,hd),n(w,Lb),n(w,xa),m(ii,xa,null),n(xa,Wb),n(xa,fd),n(w,Vb),n(w,gn),m(ci,gn,null),n(gn,Bb),n(gn,md),n(gn,Pb),n(gn,_d),n(w,Yb),n(w,$a),m(li,$a,null),n($a,Xb),n($a,bd),n(w,Qb),n(w,un),m(pi,un,null),n(un,zb),n(un,yd),n(un,Ob),m(wa,un,null),n(w,Kb),n(w,hn),m(di,hn,null),n(hn,ey),n(hn,vd),n(hn,ty),m(ka,hn,null),n(w,ny),n(w,Xe),m(gi,Xe,null),n(Xe,oy),n(Xe,xd),n(Xe,ay),n(Xe,$d),n(Xe,sy),m(Ta,Xe,null),n(w,ry),n(w,fn),m(ui,fn,null),n(fn,iy),n(fn,wd),n(fn,cy),m(ja,fn,null),n(w,ly),n(w,mn),m(hi,mn,null),n(mn,py),n(mn,kd),n(mn,dy),m(Ma,mn,null),n(w,gy),n(w,_n),m(fi,_n,null),n(_n,uy),n(_n,Td),n(_n,hy),m(qa,_n,null),n(w,fy),n(w,bn),m(mi,bn,null),n(bn,my),n(bn,jd),n(bn,_y),m(Ua,bn,null),n(w,by),n(w,Qe),m(_i,Qe,null),n(Qe,yy),n(Qe,Md),n(Qe,vy),n(Qe,qd),n(Qe,xy),m(Ha,Qe,null),n(w,$y),n(w,Ca),m(bi,Ca,null),n(Ca,wy),n(Ca,Ud),n(w,ky),n(w,ze),m(yi,ze,null),n(ze,Ty),n(ze,Hd),n(ze,jy),n(ze,Cd),n(ze,My),m(Ia,ze,null),n(w,qy),n(w,Ja),m(vi,Ja,null),n(Ja,Uy),n(Ja,Id),n(w,Hy),n(w,Na),m(xi,Na,null),n(Na,Cy),n(Na,Jd),n(w,Iy),n(w,yn),m($i,yn,null),n(yn,Jy),n(yn,Nd),n(yn,Ny),m(Aa,yn,null),n(w,Ay),n(w,Ea),m(wi,Ea,null),n(Ea,Ey),n(Ea,Ad),n(w,Dy),n(w,vn),m(ki,vn,null),n(vn,Ry),n(vn,Ed),n(vn,Gy),m(Da,vn,null),n(w,Zy),n(w,ue),m(Ti,ue,null),n(ue,Fy),n(ue,Dd),n(ue,Sy),n(ue,Rd),n(ue,Ly),m(Ra,ue,null),n(ue,Wy),m(Ga,ue,null),n(w,Vy),n(w,P),m(ji,P,null),n(P,By),n(P,Gd),n(P,Py),n(P,Zd),n(P,Yy),n(P,Fd),n(P,Xy),n(P,Sd),n(P,Qy),m(Za,P,null),n(w,zy),n(w,Fa),m(Mi,Fa,null),n(Fa,Oy),n(Fa,Ld),n(w,Ky),n(w,xn),m(qi,xn,null),n(xn,ev),n(xn,Wd),n(xn,tv),n(xn,Vd),n(w,nv),n(w,Oe),m(Ui,Oe,null),n(Oe,ov),n(Oe,Bd),n(Oe,av),m(Sa,Oe,null),n(Oe,sv),n(Oe,Pd),n(w,rv),n(w,La),m(Hi,La,null),n(La,iv),n(La,Yd),n(w,cv),n(w,$n),m(Ci,$n,null),n($n,lv),n($n,Xd),n($n,pv),m(Wa,$n,null),n(w,dv),n(w,Ke),m(Ii,Ke,null),n(Ke,gv),n(Ke,Qd),n(Ke,uv),n(Ke,zd),n(Ke,hv),n(Ke,Od),n(w,fv),n(w,Y),m(Ji,Y,null),n(Y,mv),n(Y,Kd),n(Y,_v),n(Y,eg),n(Y,bv),n(Y,tg),n(Y,yv),m(Va,Y,null),n(Y,vv),n(Y,ng),n(w,xv),n(w,et),m(Ni,et,null),n(et,$v),n(et,og),n(et,wv),m(Ba,et,null),n(et,kv),m(Pa,et,null),n(w,Tv),n(w,wn),m(Ai,wn,null),n(wn,jv),n(wn,ag),n(wn,Mv),m(Ya,wn,null),n(w,qv),n(w,kn),m(Ei,kn,null),n(kn,Uv),n(kn,sg),n(kn,Hv),m(Xa,kn,null),n(w,Cv),n(w,he),m(Di,he,null),n(he,Iv),n(he,rg),n(he,Jv),n(he,ig),n(he,Nv),n(he,cg),n(he,Av),m(Qa,he,null),n(w,Ev),n(w,Tn),m(Ri,Tn,null),n(Tn,Dv),n(Tn,lg),n(Tn,Rv),m(za,Tn,null),n(w,Gv),n(w,tt),m(Gi,tt,null),n(tt,Zv),n(tt,pg),n(tt,Fv),m(Oa,tt,null),n(tt,Sv),m(Ka,tt,null),n(w,Lv),n(w,fe),m(Zi,fe,null),n(fe,Wv),n(fe,dg),n(fe,Vv),n(fe,gg),n(fe,Bv),n(fe,ug),n(fe,Pv),m(es,fe,null),n(w,Yv),n(w,jn),m(Fi,jn,null),n(jn,Xv),n(jn,hg),n(jn,Qv),m(ts,jn,null),n(w,zv),n(w,ns),m(Si,ns,null),n(ns,Ov),n(ns,fg),n(w,Kv),n(w,nt),m(Li,nt,null),n(nt,ex),n(nt,mg),n(nt,tx),n(nt,_g),n(nt,nx),m(os,nt,null),n(w,ox),n(w,me),m(Wi,me,null),n(me,ax),n(me,bg),n(me,sx),n(me,yg),n(me,rx),n(me,vg),n(me,ix),m(as,me,null),n(w,cx),n(w,Mn),m(Vi,Mn,null),n(Mn,lx),n(Mn,xg),n(Mn,px),m(ss,Mn,null),n(w,dx),n(w,rs),m(Bi,rs,null),n(rs,gx),n(rs,$g),n(w,ux),n(w,qn),m(Pi,qn,null),n(qn,hx),n(qn,wg),n(qn,fx),m(is,qn,null),n(w,mx),n(w,_e),m(Yi,_e,null),n(_e,_x),n(_e,kg),n(_e,bx),n(_e,Tg),n(_e,yx),n(_e,jg),n(_e,vx),m(cs,_e,null),n(w,xx),n(w,be),m(Xi,be,null),n(be,$x),n(be,Mg),n(be,wx),n(be,qg),n(be,kx),n(be,Ug),n(be,Tx),m(ls,be,null),n(w,jx),n(w,ot),m(Qi,ot,null),n(ot,Mx),n(ot,Hg),n(ot,qx),n(ot,Cg),n(ot,Ux),m(ps,ot,null),n(w,Hx),n(w,ds),m(zi,ds,null),n(ds,Cx),n(ds,Ig),n(w,Ix),n(w,Un),m(Oi,Un,null),n(Un,Jx),n(Un,Jg),n(Un,Nx),n(Un,Ng),n(w,Ax),n(w,Hn),m(Ki,Hn,null),n(Hn,Ex),n(Hn,Ag),n(Hn,Dx),m(gs,Hn,null),n(w,Rx),n(w,Z),m(ec,Z,null),n(Z,Gx),n(Z,Eg),n(Z,Zx),n(Z,Dg),n(Z,Fx),n(Z,Rg),n(Z,Sx),m(us,Z,null),n(Z,Lx),n(Z,Gg),n(Z,Wx),m(hs,Z,null),n(w,Vx),n(w,fs),m(tc,fs,null),n(fs,Bx),n(fs,Zg),n(w,Px),n(w,ms),m(nc,ms,null),n(ms,Yx),n(ms,Fg),n(w,Xx),n(w,_s),m(oc,_s,null),n(_s,Qx),n(_s,Sg),n(w,zx),n(w,bs),m(ac,bs,null),n(bs,Ox),n(bs,Lg),n(w,Kx),n(w,Cn),m(sc,Cn,null),n(Cn,e$),n(Cn,Wg),n(Cn,t$),m(ys,Cn,null),n(w,n$),n(w,In),m(rc,In,null),n(In,o$),n(In,Vg),n(In,a$),m(vs,In,null),n(w,s$),n(w,at),m(ic,at,null),n(at,r$),n(at,Bg),n(at,i$),n(at,Pg),n(at,c$),m(xs,at,null),n(w,l$),n(w,st),m(cc,st,null),n(st,p$),n(st,Yg),n(st,d$),n(st,Xg),n(st,g$),m($s,st,null),n(w,u$),n(w,ws),m(lc,ws,null),n(ws,h$),n(ws,Qg),n(w,f$),n(w,rt),m(pc,rt,null),n(rt,m$),n(rt,zg),n(rt,_$),n(rt,Og),n(rt,b$),n(rt,Kg),n(w,y$),n(w,it),m(dc,it,null),n(it,v$),n(it,eu),n(it,x$),n(it,tu),n(it,$$),n(it,nu),n(w,w$),n(w,ct),m(gc,ct,null),n(ct,k$),n(ct,ou),n(ct,T$),n(ct,au),n(ct,j$),n(ct,su),n(w,M$),n(w,lt),m(uc,lt,null),n(lt,q$),n(lt,ru),n(lt,U$),m(ks,lt,null),n(lt,H$),m(Ts,lt,null),n(w,C$),n(w,X),m(hc,X,null),n(X,I$),n(X,iu),n(X,J$),n(X,cu),n(X,N$),m(js,X,null),n(X,A$),m(Ms,X,null),n(X,E$),m(qs,X,null),n(w,D$),n(w,pt),m(fc,pt,null),n(pt,R$),n(pt,lu),n(pt,G$),n(pt,pu),n(pt,Z$),n(pt,du),n(w,F$),n(w,dt),m(mc,dt,null),n(dt,S$),n(dt,gu),n(dt,L$),m(Us,dt,null),n(dt,W$),m(Hs,dt,null),n(w,V$),n(w,Jn),m(_c,Jn,null),n(Jn,B$),n(Jn,uu),n(Jn,P$),m(Cs,Jn,null),n(w,Y$),n(w,Nn),m(bc,Nn,null),n(Nn,X$),n(Nn,hu),n(Nn,Q$),m(Is,Nn,null),n(w,z$),n(w,An),m(yc,An,null),n(An,O$),n(An,fu),n(An,K$),m(Js,An,null),n(w,e2),n(w,En),m(vc,En,null),n(En,t2),n(En,mu),n(En,n2),m(Ns,En,null),n(w,o2),n(w,gt),m(xc,gt,null),n(gt,a2),n(gt,_u),n(gt,s2),n(gt,bu),n(gt,r2),n(gt,yu),n(w,i2),n(w,Dn),m($c,Dn,null),n(Dn,c2),n(Dn,vu),n(Dn,l2),n(Dn,xu),n(w,p2),n(w,As),m(wc,As,null),n(As,d2),n(As,$u),n(w,g2),n(w,Rn),m(kc,Rn,null),n(Rn,u2),n(Rn,wu),n(Rn,h2),m(Es,Rn,null),n(w,f2),n(w,ye),m(Tc,ye,null),n(ye,m2),n(ye,ku),n(ye,_2),n(ye,Tu),n(ye,b2),n(ye,ju),n(ye,y2),m(Ds,ye,null),n(w,v2),n(w,ve),m(jc,ve,null),n(ve,x2),n(ve,Mu),n(ve,$2),n(ve,qu),n(ve,w2),m(Rs,ve,null),n(ve,k2),m(Gs,ve,null),n(w,T2),n(w,Q),m(Mc,Q,null),n(Q,j2),n(Q,Uu),n(Q,M2),n(Q,Hu),n(Q,q2),m(Zs,Q,null),n(Q,U2),m(Fs,Q,null),n(Q,H2),m(Ss,Q,null),n(w,C2),n(w,ut),m(qc,ut,null),n(ut,I2),n(ut,Cu),n(ut,J2),n(ut,Iu),n(ut,N2),n(ut,Ju),n(w,A2),n(w,ht),m(Uc,ht,null),n(ht,E2),n(ht,Nu),n(ht,D2),n(ht,Au),n(ht,R2),m(Ls,ht,null),n(w,G2),n(w,xe),m(Hc,xe,null),n(xe,Z2),n(xe,Eu),n(xe,F2),n(xe,Du),n(xe,S2),n(xe,Ru),n(xe,L2),n(xe,Gu),n(w,W2),n(w,ft),m(Cc,ft,null),n(ft,V2),n(ft,Zu),n(ft,B2),n(ft,Fu),n(ft,P2),m(Ws,ft,null),n(w,Y2),n(w,z),m(Ic,z,null),n(z,X2),n(z,Su),n(z,Q2),n(z,Lu),n(z,z2),m(Vs,z,null),n(z,O2),m(Bs,z,null),n(z,K2),m(Ps,z,null),n(w,e1),n(w,Ys),m(Jc,Ys,null),n(Ys,t1),n(Ys,Wu),n(w,n1),n(w,$e),m(Nc,$e,null),n($e,o1),n($e,Vu),n($e,a1),n($e,Bu),n($e,s1),n($e,Pu),n($e,r1),m(Xs,$e,null),n(w,i1),n(w,Gn),m(Ac,Gn,null),n(Gn,c1),n(Gn,Yu),n(Gn,l1),m(Qs,Gn,null),n(w,p1),n(w,we),m(Ec,we,null),n(we,d1),n(we,Xu),n(we,g1),n(we,Qu),n(we,u1),n(we,zu),n(we,h1),m(zs,we,null),n(w,f1),n(w,mt),m(Dc,mt,null),n(mt,m1),n(mt,Ou),n(mt,_1),n(mt,Ku),n(mt,b1),n(mt,eh),n(w,y1),n(w,Zn),m(Rc,Zn,null),n(Zn,v1),n(Zn,th),n(Zn,x1),n(Zn,nh),n(w,$1),n(w,_t),m(Gc,_t,null),n(_t,w1),n(_t,oh),n(_t,k1),n(_t,ah),n(_t,T1),m(Os,_t,null),n(w,j1),n(w,Fn),m(Zc,Fn,null),n(Fn,M1),n(Fn,sh),n(Fn,q1),m(Ks,Fn,null),n(w,U1),n(w,ke),m(Fc,ke,null),n(ke,H1),n(ke,rh),n(ke,C1),m(er,ke,null),n(ke,I1),m(tr,ke,null),n(ke,J1),m(nr,ke,null),n(w,N1),n(w,N),m(Sc,N,null),n(N,A1),n(N,ih),n(N,E1),n(N,ch),n(N,D1),n(N,lh),n(N,R1),n(N,ph),n(N,G1),n(N,dh),n(N,Z1),n(N,gh),n(N,F1),m(or,N,null),n(N,S1),m(ar,N,null),n(N,L1),m(sr,N,null),n(N,W1),m(rr,N,null),n(w,V1),n(w,J),m(Lc,J,null),n(J,B1),n(J,uh),n(J,P1),n(J,hh),n(J,Y1),m(ir,J,null),n(J,X1),m(cr,J,null),n(J,Q1),n(J,fh),n(J,z1),n(J,mh),n(J,O1),n(J,_h),n(J,K1),n(J,bh),n(J,ew),n(J,yh),n(J,tw),n(J,vh),n(J,nw),n(J,xh),n(w,ow),n(w,lr),m(Wc,lr,null),n(lr,aw),n(lr,$h),$(o,Jf,x),m(Vc,o,x),$(o,Nf,x),m(Bc,o,x),$(o,Af,x),$(o,zn,x),m(Pc,zn,null),n(zn,sw),n(zn,wh),$(o,Ef,x),m(Yc,o,x),$(o,Df,x),$(o,yt,x),m(Xc,yt,null),n(yt,rw),n(yt,kh),n(yt,iw),n(yt,Th),$(o,Rf,x),m(Qc,o,x),$(o,Gf,x),$(o,vt,x),m(zc,vt,null),n(vt,cw),n(vt,jh),n(vt,lw),m(pr,vt,null),$(o,Zf,x),m(Oc,o,x),$(o,Ff,x),$(o,On,x),m(Kc,On,null),n(On,pw),n(On,Mh),$(o,Sf,x),m(el,o,x),$(o,Lf,x),$(o,Kn,x),m(tl,Kn,null),n(Kn,dw),n(Kn,qh),$(o,Wf,x),m(nl,o,x),$(o,Vf,x),$(o,xt,x),m(ol,xt,null),n(xt,gw),n(xt,Uh),n(xt,uw),n(xt,Hh),$(o,Bf,x),m(al,o,x),$(o,Pf,x),$(o,$t,x),m(sl,$t,null),n($t,hw),n($t,Ch),n($t,fw),m(dr,$t,null),$(o,Yf,x),m(rl,o,x),$(o,Xf,x),$(o,wt,x),m(il,wt,null),n(wt,mw),n(wt,Ih),n(wt,_w),m(gr,wt,null),$(o,Qf,x),m(cl,o,x),$(o,zf,x),$(o,eo,x),m(ll,eo,null),n(eo,bw),n(eo,Jh),$(o,Of,x),m(pl,o,x),$(o,Kf,x),$(o,K,x),m(dl,K,null),n(K,yw),n(K,Nh),n(K,vw),n(K,Ah),n(K,xw),n(K,Eh),n(K,$w),m(ur,K,null),$(o,em,x),m(gl,o,x),$(o,tm,x),$(o,ee,x),m(ul,ee,null),n(ee,ww),n(ee,Dh),n(ee,kw),n(ee,Rh),n(ee,Tw),n(ee,Gh),n(ee,jw),n(ee,Zh),$(o,nm,x),m(hl,o,x),$(o,om,x),$(o,Te,x),m(fl,Te,null),n(Te,Mw),n(Te,Fh),n(Te,qw),n(Te,Sh),n(Te,Uw),n(Te,Lh),$(o,am,x),m(ml,o,x),$(o,sm,x),$(o,kt,x),m(_l,kt,null),n(kt,Hw),n(kt,Wh),n(kt,Cw),m(hr,kt,null),$(o,rm,x),m(bl,o,x),$(o,im,x),$(o,Tt,x),m(yl,Tt,null),n(Tt,Iw),n(Tt,Vh),n(Tt,Jw),n(Tt,Bh),$(o,cm,x),m(vl,o,x),$(o,lm,x),$(o,to,x),m(xl,to,null),n(to,Nw),n(to,Ph),$(o,pm,x),m($l,o,x),$(o,dm,x),$(o,no,x),m(wl,no,null),n(no,Aw),n(no,Yh),$(o,gm,x),m(kl,o,x),$(o,um,x),$(o,Tl,x),$(o,hm,x),$(o,je,x),m(jl,je,null),n(je,Ew),n(je,Xh),n(je,Dw),n(je,Sn),m(Ml,Sn,null),n(Sn,Rw),n(Sn,Qh),n(Sn,Gw),m(fr,Sn,null),n(je,Zw),n(je,Ln),m(ql,Ln,null),n(Ln,Fw),n(Ln,zh),n(Ln,Sw),n(Ln,Oh),$(o,fm,x),$(o,oo,x),m(Ul,oo,null),n(oo,Lw),n(oo,Kh),$(o,mm,x),$(o,te,x),m(Hl,te,null),n(te,Ww),n(te,ef),n(te,Vw),n(te,tf),n(te,Bw),n(te,nf),n(te,Pw),n(te,of),$(o,_m,x),m(Cl,o,x),$(o,bm,x),$(o,D,x),m(Il,D,null),n(D,Yw),n(D,af),n(D,Xw),n(D,sf),n(D,Qw),m(mr,D,null),n(D,zw),m(_r,D,null),n(D,Ow),n(D,bt),m(Jl,bt,null),n(bt,Kw),n(bt,rf),n(bt,ek),m(br,bt,null),n(bt,tk),n(bt,cf),n(D,nk),n(D,Wn),m(Nl,Wn,null),n(Wn,ok),n(Wn,lf),n(Wn,ak),n(Wn,pf),n(D,sk),n(D,Vn),m(Al,Vn,null),n(Vn,rk),n(Vn,df),n(Vn,ik),n(Vn,gf),$(o,ym,x),m(El,o,x),$(o,vm,x),$(o,Mf,x),xm=!0},p(o,[x]){const k={};x&2&&(k.$$scope={dirty:x,ctx:o}),Zo.$set(k);const jt={};x&2&&(jt.$$scope={dirty:x,ctx:o}),Fo.$set(jt);const Mt={};x&2&&(Mt.$$scope={dirty:x,ctx:o}),Lo.$set(Mt);const ao={};x&2&&(ao.$$scope={dirty:x,ctx:o}),Wo.$set(ao);const so={};x&2&&(so.$$scope={dirty:x,ctx:o}),Vo.$set(so);const F={};x&2&&(F.$$scope={dirty:x,ctx:o}),Bo.$set(F);const qt={};x&2&&(qt.$$scope={dirty:x,ctx:o}),Yo.$set(qt);const Dl={};x&2&&(Dl.$$scope={dirty:x,ctx:o}),Xo.$set(Dl);const Ut={};x&2&&(Ut.$$scope={dirty:x,ctx:o}),Qo.$set(Ut);const Ht={};x&2&&(Ht.$$scope={dirty:x,ctx:o}),zo.$set(Ht);const Rl={};x&2&&(Rl.$$scope={dirty:x,ctx:o}),Oo.$set(Rl);const Ct={};x&2&&(Ct.$$scope={dirty:x,ctx:o}),Ko.$set(Ct);const Me={};x&2&&(Me.$$scope={dirty:x,ctx:o}),ea.$set(Me);const ne={};x&2&&(ne.$$scope={dirty:x,ctx:o}),ta.$set(ne);const qe={};x&2&&(qe.$$scope={dirty:x,ctx:o}),na.$set(qe);const It={};x&2&&(It.$$scope={dirty:x,ctx:o}),oa.$set(It);const oe={};x&2&&(oe.$$scope={dirty:x,ctx:o}),sa.$set(oe);const Gl={};x&2&&(Gl.$$scope={dirty:x,ctx:o}),ra.$set(Gl);const ae={};x&2&&(ae.$$scope={dirty:x,ctx:o}),ia.$set(ae);const se={};x&2&&(se.$$scope={dirty:x,ctx:o}),ca.$set(se);const Zl={};x&2&&(Zl.$$scope={dirty:x,ctx:o}),la.$set(Zl);const ro={};x&2&&(ro.$$scope={dirty:x,ctx:o}),pa.$set(ro);const Jt={};x&2&&(Jt.$$scope={dirty:x,ctx:o}),ga.$set(Jt);const Fl={};x&2&&(Fl.$$scope={dirty:x,ctx:o}),ua.$set(Fl);const Nt={};x&2&&(Nt.$$scope={dirty:x,ctx:o}),fa.$set(Nt);const io={};x&2&&(io.$$scope={dirty:x,ctx:o}),ma.$set(io);const co={};x&2&&(co.$$scope={dirty:x,ctx:o}),_a.$set(co);const lo={};x&2&&(lo.$$scope={dirty:x,ctx:o}),ba.$set(lo);const po={};x&2&&(po.$$scope={dirty:x,ctx:o}),wa.$set(po);const At={};x&2&&(At.$$scope={dirty:x,ctx:o}),ka.$set(At);const Sl={};x&2&&(Sl.$$scope={dirty:x,ctx:o}),Ta.$set(Sl);const Ll={};x&2&&(Ll.$$scope={dirty:x,ctx:o}),ja.$set(Ll);const go={};x&2&&(go.$$scope={dirty:x,ctx:o}),Ma.$set(go);const Wl={};x&2&&(Wl.$$scope={dirty:x,ctx:o}),qa.$set(Wl);const uo={};x&2&&(uo.$$scope={dirty:x,ctx:o}),Ua.$set(uo);const Vl={};x&2&&(Vl.$$scope={dirty:x,ctx:o}),Ha.$set(Vl);const ho={};x&2&&(ho.$$scope={dirty:x,ctx:o}),Ia.$set(ho);const fo={};x&2&&(fo.$$scope={dirty:x,ctx:o}),Aa.$set(fo);const Et={};x&2&&(Et.$$scope={dirty:x,ctx:o}),Da.$set(Et);const mo={};x&2&&(mo.$$scope={dirty:x,ctx:o}),Ra.$set(mo);const _o={};x&2&&(_o.$$scope={dirty:x,ctx:o}),Ga.$set(_o);const bo={};x&2&&(bo.$$scope={dirty:x,ctx:o}),Za.$set(bo);const yo={};x&2&&(yo.$$scope={dirty:x,ctx:o}),Sa.$set(yo);const Dt={};x&2&&(Dt.$$scope={dirty:x,ctx:o}),Wa.$set(Dt);const Bl={};x&2&&(Bl.$$scope={dirty:x,ctx:o}),Va.$set(Bl);const Rt={};x&2&&(Rt.$$scope={dirty:x,ctx:o}),Ba.$set(Rt);const Pl={};x&2&&(Pl.$$scope={dirty:x,ctx:o}),Pa.$set(Pl);const Yl={};x&2&&(Yl.$$scope={dirty:x,ctx:o}),Ya.$set(Yl);const vo={};x&2&&(vo.$$scope={dirty:x,ctx:o}),Xa.$set(vo);const Xl={};x&2&&(Xl.$$scope={dirty:x,ctx:o}),Qa.$set(Xl);const xo={};x&2&&(xo.$$scope={dirty:x,ctx:o}),za.$set(xo);const Ue={};x&2&&(Ue.$$scope={dirty:x,ctx:o}),Oa.$set(Ue);const re={};x&2&&(re.$$scope={dirty:x,ctx:o}),Ka.$set(re);const Ql={};x&2&&(Ql.$$scope={dirty:x,ctx:o}),es.$set(Ql);const $o={};x&2&&($o.$$scope={dirty:x,ctx:o}),ts.$set($o);const Gt={};x&2&&(Gt.$$scope={dirty:x,ctx:o}),os.$set(Gt);const zl={};x&2&&(zl.$$scope={dirty:x,ctx:o}),as.$set(zl);const wo={};x&2&&(wo.$$scope={dirty:x,ctx:o}),ss.$set(wo);const Zt={};x&2&&(Zt.$$scope={dirty:x,ctx:o}),is.$set(Zt);const ie={};x&2&&(ie.$$scope={dirty:x,ctx:o}),cs.$set(ie);const Ft={};x&2&&(Ft.$$scope={dirty:x,ctx:o}),ls.$set(Ft);const ko={};x&2&&(ko.$$scope={dirty:x,ctx:o}),ps.$set(ko);const To={};x&2&&(To.$$scope={dirty:x,ctx:o}),gs.$set(To);const He={};x&2&&(He.$$scope={dirty:x,ctx:o}),us.$set(He);const jo={};x&2&&(jo.$$scope={dirty:x,ctx:o}),hs.$set(jo);const St={};x&2&&(St.$$scope={dirty:x,ctx:o}),ys.$set(St);const Ce={};x&2&&(Ce.$$scope={dirty:x,ctx:o}),vs.$set(Ce);const Mo={};x&2&&(Mo.$$scope={dirty:x,ctx:o}),xs.$set(Mo);const Ol={};x&2&&(Ol.$$scope={dirty:x,ctx:o}),$s.$set(Ol);const Lt={};x&2&&(Lt.$$scope={dirty:x,ctx:o}),ks.$set(Lt);const Ie={};x&2&&(Ie.$$scope={dirty:x,ctx:o}),Ts.$set(Ie);const qo={};x&2&&(qo.$$scope={dirty:x,ctx:o}),js.$set(qo);const Kl={};x&2&&(Kl.$$scope={dirty:x,ctx:o}),Ms.$set(Kl);const Uo={};x&2&&(Uo.$$scope={dirty:x,ctx:o}),qs.$set(Uo);const Je={};x&2&&(Je.$$scope={dirty:x,ctx:o}),Us.$set(Je);const Ne={};x&2&&(Ne.$$scope={dirty:x,ctx:o}),Hs.$set(Ne);const Wt={};x&2&&(Wt.$$scope={dirty:x,ctx:o}),Cs.$set(Wt);const ep={};x&2&&(ep.$$scope={dirty:x,ctx:o}),Is.$set(ep);const Ho={};x&2&&(Ho.$$scope={dirty:x,ctx:o}),Js.$set(Ho);const Co={};x&2&&(Co.$$scope={dirty:x,ctx:o}),Ns.$set(Co);const S={};x&2&&(S.$$scope={dirty:x,ctx:o}),Es.$set(S);const tp={};x&2&&(tp.$$scope={dirty:x,ctx:o}),Ds.$set(tp);const np={};x&2&&(np.$$scope={dirty:x,ctx:o}),Rs.$set(np);const op={};x&2&&(op.$$scope={dirty:x,ctx:o}),Gs.$set(op);const ap={};x&2&&(ap.$$scope={dirty:x,ctx:o}),Zs.$set(ap);const Io={};x&2&&(Io.$$scope={dirty:x,ctx:o}),Fs.$set(Io);const Jo={};x&2&&(Jo.$$scope={dirty:x,ctx:o}),Ss.$set(Jo);const Vt={};x&2&&(Vt.$$scope={dirty:x,ctx:o}),Ls.$set(Vt);const Bt={};x&2&&(Bt.$$scope={dirty:x,ctx:o}),Ws.$set(Bt);const sp={};x&2&&(sp.$$scope={dirty:x,ctx:o}),Vs.$set(sp);const Pt={};x&2&&(Pt.$$scope={dirty:x,ctx:o}),Bs.$set(Pt);const Yt={};x&2&&(Yt.$$scope={dirty:x,ctx:o}),Ps.$set(Yt);const Xt={};x&2&&(Xt.$$scope={dirty:x,ctx:o}),Xs.$set(Xt);const Qt={};x&2&&(Qt.$$scope={dirty:x,ctx:o}),Qs.$set(Qt);const ce={};x&2&&(ce.$$scope={dirty:x,ctx:o}),zs.$set(ce);const zt={};x&2&&(zt.$$scope={dirty:x,ctx:o}),Os.$set(zt);const Ot={};x&2&&(Ot.$$scope={dirty:x,ctx:o}),Ks.$set(Ot);const No={};x&2&&(No.$$scope={dirty:x,ctx:o}),er.$set(No);const Ao={};x&2&&(Ao.$$scope={dirty:x,ctx:o}),tr.$set(Ao);const Eo={};x&2&&(Eo.$$scope={dirty:x,ctx:o}),nr.$set(Eo);const Do={};x&2&&(Do.$$scope={dirty:x,ctx:o}),or.$set(Do);const Kt={};x&2&&(Kt.$$scope={dirty:x,ctx:o}),ar.$set(Kt);const Ro={};x&2&&(Ro.$$scope={dirty:x,ctx:o}),sr.$set(Ro);const rp={};x&2&&(rp.$$scope={dirty:x,ctx:o}),rr.$set(rp);const Go={};x&2&&(Go.$$scope={dirty:x,ctx:o}),ir.$set(Go);const Ae={};x&2&&(Ae.$$scope={dirty:x,ctx:o}),cr.$set(Ae);const Ee={};x&2&&(Ee.$$scope={dirty:x,ctx:o}),pr.$set(Ee);const le={};x&2&&(le.$$scope={dirty:x,ctx:o}),dr.$set(le);const en={};x&2&&(en.$$scope={dirty:x,ctx:o}),gr.$set(en);const tn={};x&2&&(tn.$$scope={dirty:x,ctx:o}),ur.$set(tn);const De={};x&2&&(De.$$scope={dirty:x,ctx:o}),hr.$set(De);const nn={};x&2&&(nn.$$scope={dirty:x,ctx:o}),fr.$set(nn);const pe={};x&2&&(pe.$$scope={dirty:x,ctx:o}),mr.$set(pe);const ip={};x&2&&(ip.$$scope={dirty:x,ctx:o}),_r.$set(ip);const Re={};x&2&&(Re.$$scope={dirty:x,ctx:o}),br.$set(Re)},i(o){xm||(_(g.$$.fragment,o),_(jr.$$.fragment,o),_(Mr.$$.fragment,o),_(qr.$$.fragment,o),_(Ur.$$.fragment,o),_(Hr.$$.fragment,o),_(Zo.$$.fragment,o),_(Cr.$$.fragment,o),_(Ir.$$.fragment,o),_(Jr.$$.fragment,o),_(Fo.$$.fragment,o),_(Nr.$$.fragment,o),_(Ar.$$.fragment,o),_(Er.$$.fragment,o),_(Lo.$$.fragment,o),_(Wo.$$.fragment,o),_(Dr.$$.fragment,o),_(Vo.$$.fragment,o),_(Bo.$$.fragment,o),_(Rr.$$.fragment,o),_(Gr.$$.fragment,o),_(Yo.$$.fragment,o),_(Zr.$$.fragment,o),_(Xo.$$.fragment,o),_(Qo.$$.fragment,o),_(zo.$$.fragment,o),_(Fr.$$.fragment,o),_(Oo.$$.fragment,o),_(Sr.$$.fragment,o),_(Ko.$$.fragment,o),_(ea.$$.fragment,o),_(ta.$$.fragment,o),_(Lr.$$.fragment,o),_(na.$$.fragment,o),_(Wr.$$.fragment,o),_(oa.$$.fragment,o),_(Vr.$$.fragment,o),_(Br.$$.fragment,o),_(sa.$$.fragment,o),_(ra.$$.fragment,o),_(ia.$$.fragment,o),_(Pr.$$.fragment,o),_(ca.$$.fragment,o),_(la.$$.fragment,o),_(pa.$$.fragment,o),_(Yr.$$.fragment,o),_(Xr.$$.fragment,o),_(ga.$$.fragment,o),_(Qr.$$.fragment,o),_(ua.$$.fragment,o),_(zr.$$.fragment,o),_(Or.$$.fragment,o),_(fa.$$.fragment,o),_(ma.$$.fragment,o),_(Kr.$$.fragment,o),_(_a.$$.fragment,o),_(ei.$$.fragment,o),_(ba.$$.fragment,o),_(ti.$$.fragment,o),_(ni.$$.fragment,o),_(oi.$$.fragment,o),_(ai.$$.fragment,o),_(si.$$.fragment,o),_(ri.$$.fragment,o),_(ii.$$.fragment,o),_(ci.$$.fragment,o),_(li.$$.fragment,o),_(pi.$$.fragment,o),_(wa.$$.fragment,o),_(di.$$.fragment,o),_(ka.$$.fragment,o),_(gi.$$.fragment,o),_(Ta.$$.fragment,o),_(ui.$$.fragment,o),_(ja.$$.fragment,o),_(hi.$$.fragment,o),_(Ma.$$.fragment,o),_(fi.$$.fragment,o),_(qa.$$.fragment,o),_(mi.$$.fragment,o),_(Ua.$$.fragment,o),_(_i.$$.fragment,o),_(Ha.$$.fragment,o),_(bi.$$.fragment,o),_(yi.$$.fragment,o),_(Ia.$$.fragment,o),_(vi.$$.fragment,o),_(xi.$$.fragment,o),_($i.$$.fragment,o),_(Aa.$$.fragment,o),_(wi.$$.fragment,o),_(ki.$$.fragment,o),_(Da.$$.fragment,o),_(Ti.$$.fragment,o),_(Ra.$$.fragment,o),_(Ga.$$.fragment,o),_(ji.$$.fragment,o),_(Za.$$.fragment,o),_(Mi.$$.fragment,o),_(qi.$$.fragment,o),_(Ui.$$.fragment,o),_(Sa.$$.fragment,o),_(Hi.$$.fragment,o),_(Ci.$$.fragment,o),_(Wa.$$.fragment,o),_(Ii.$$.fragment,o),_(Ji.$$.fragment,o),_(Va.$$.fragment,o),_(Ni.$$.fragment,o),_(Ba.$$.fragment,o),_(Pa.$$.fragment,o),_(Ai.$$.fragment,o),_(Ya.$$.fragment,o),_(Ei.$$.fragment,o),_(Xa.$$.fragment,o),_(Di.$$.fragment,o),_(Qa.$$.fragment,o),_(Ri.$$.fragment,o),_(za.$$.fragment,o),_(Gi.$$.fragment,o),_(Oa.$$.fragment,o),_(Ka.$$.fragment,o),_(Zi.$$.fragment,o),_(es.$$.fragment,o),_(Fi.$$.fragment,o),_(ts.$$.fragment,o),_(Si.$$.fragment,o),_(Li.$$.fragment,o),_(os.$$.fragment,o),_(Wi.$$.fragment,o),_(as.$$.fragment,o),_(Vi.$$.fragment,o),_(ss.$$.fragment,o),_(Bi.$$.fragment,o),_(Pi.$$.fragment,o),_(is.$$.fragment,o),_(Yi.$$.fragment,o),_(cs.$$.fragment,o),_(Xi.$$.fragment,o),_(ls.$$.fragment,o),_(Qi.$$.fragment,o),_(ps.$$.fragment,o),_(zi.$$.fragment,o),_(Oi.$$.fragment,o),_(Ki.$$.fragment,o),_(gs.$$.fragment,o),_(ec.$$.fragment,o),_(us.$$.fragment,o),_(hs.$$.fragment,o),_(tc.$$.fragment,o),_(nc.$$.fragment,o),_(oc.$$.fragment,o),_(ac.$$.fragment,o),_(sc.$$.fragment,o),_(ys.$$.fragment,o),_(rc.$$.fragment,o),_(vs.$$.fragment,o),_(ic.$$.fragment,o),_(xs.$$.fragment,o),_(cc.$$.fragment,o),_($s.$$.fragment,o),_(lc.$$.fragment,o),_(pc.$$.fragment,o),_(dc.$$.fragment,o),_(gc.$$.fragment,o),_(uc.$$.fragment,o),_(ks.$$.fragment,o),_(Ts.$$.fragment,o),_(hc.$$.fragment,o),_(js.$$.fragment,o),_(Ms.$$.fragment,o),_(qs.$$.fragment,o),_(fc.$$.fragment,o),_(mc.$$.fragment,o),_(Us.$$.fragment,o),_(Hs.$$.fragment,o),_(_c.$$.fragment,o),_(Cs.$$.fragment,o),_(bc.$$.fragment,o),_(Is.$$.fragment,o),_(yc.$$.fragment,o),_(Js.$$.fragment,o),_(vc.$$.fragment,o),_(Ns.$$.fragment,o),_(xc.$$.fragment,o),_($c.$$.fragment,o),_(wc.$$.fragment,o),_(kc.$$.fragment,o),_(Es.$$.fragment,o),_(Tc.$$.fragment,o),_(Ds.$$.fragment,o),_(jc.$$.fragment,o),_(Rs.$$.fragment,o),_(Gs.$$.fragment,o),_(Mc.$$.fragment,o),_(Zs.$$.fragment,o),_(Fs.$$.fragment,o),_(Ss.$$.fragment,o),_(qc.$$.fragment,o),_(Uc.$$.fragment,o),_(Ls.$$.fragment,o),_(Hc.$$.fragment,o),_(Cc.$$.fragment,o),_(Ws.$$.fragment,o),_(Ic.$$.fragment,o),_(Vs.$$.fragment,o),_(Bs.$$.fragment,o),_(Ps.$$.fragment,o),_(Jc.$$.fragment,o),_(Nc.$$.fragment,o),_(Xs.$$.fragment,o),_(Ac.$$.fragment,o),_(Qs.$$.fragment,o),_(Ec.$$.fragment,o),_(zs.$$.fragment,o),_(Dc.$$.fragment,o),_(Rc.$$.fragment,o),_(Gc.$$.fragment,o),_(Os.$$.fragment,o),_(Zc.$$.fragment,o),_(Ks.$$.fragment,o),_(Fc.$$.fragment,o),_(er.$$.fragment,o),_(tr.$$.fragment,o),_(nr.$$.fragment,o),_(Sc.$$.fragment,o),_(or.$$.fragment,o),_(ar.$$.fragment,o),_(sr.$$.fragment,o),_(rr.$$.fragment,o),_(Lc.$$.fragment,o),_(ir.$$.fragment,o),_(cr.$$.fragment,o),_(Wc.$$.fragment,o),_(Vc.$$.fragment,o),_(Bc.$$.fragment,o),_(Pc.$$.fragment,o),_(Yc.$$.fragment,o),_(Xc.$$.fragment,o),_(Qc.$$.fragment,o),_(zc.$$.fragment,o),_(pr.$$.fragment,o),_(Oc.$$.fragment,o),_(Kc.$$.fragment,o),_(el.$$.fragment,o),_(tl.$$.fragment,o),_(nl.$$.fragment,o),_(ol.$$.fragment,o),_(al.$$.fragment,o),_(sl.$$.fragment,o),_(dr.$$.fragment,o),_(rl.$$.fragment,o),_(il.$$.fragment,o),_(gr.$$.fragment,o),_(cl.$$.fragment,o),_(ll.$$.fragment,o),_(pl.$$.fragment,o),_(dl.$$.fragment,o),_(ur.$$.fragment,o),_(gl.$$.fragment,o),_(ul.$$.fragment,o),_(hl.$$.fragment,o),_(fl.$$.fragment,o),_(ml.$$.fragment,o),_(_l.$$.fragment,o),_(hr.$$.fragment,o),_(bl.$$.fragment,o),_(yl.$$.fragment,o),_(vl.$$.fragment,o),_(xl.$$.fragment,o),_($l.$$.fragment,o),_(wl.$$.fragment,o),_(kl.$$.fragment,o),_(jl.$$.fragment,o),_(Ml.$$.fragment,o),_(fr.$$.fragment,o),_(ql.$$.fragment,o),_(Ul.$$.fragment,o),_(Hl.$$.fragment,o),_(Cl.$$.fragment,o),_(Il.$$.fragment,o),_(mr.$$.fragment,o),_(_r.$$.fragment,o),_(Jl.$$.fragment,o),_(br.$$.fragment,o),_(Nl.$$.fragment,o),_(Al.$$.fragment,o),_(El.$$.fragment,o),xm=!0)},o(o){b(g.$$.fragment,o),b(jr.$$.fragment,o),b(Mr.$$.fragment,o),b(qr.$$.fragment,o),b(Ur.$$.fragment,o),b(Hr.$$.fragment,o),b(Zo.$$.fragment,o),b(Cr.$$.fragment,o),b(Ir.$$.fragment,o),b(Jr.$$.fragment,o),b(Fo.$$.fragment,o),b(Nr.$$.fragment,o),b(Ar.$$.fragment,o),b(Er.$$.fragment,o),b(Lo.$$.fragment,o),b(Wo.$$.fragment,o),b(Dr.$$.fragment,o),b(Vo.$$.fragment,o),b(Bo.$$.fragment,o),b(Rr.$$.fragment,o),b(Gr.$$.fragment,o),b(Yo.$$.fragment,o),b(Zr.$$.fragment,o),b(Xo.$$.fragment,o),b(Qo.$$.fragment,o),b(zo.$$.fragment,o),b(Fr.$$.fragment,o),b(Oo.$$.fragment,o),b(Sr.$$.fragment,o),b(Ko.$$.fragment,o),b(ea.$$.fragment,o),b(ta.$$.fragment,o),b(Lr.$$.fragment,o),b(na.$$.fragment,o),b(Wr.$$.fragment,o),b(oa.$$.fragment,o),b(Vr.$$.fragment,o),b(Br.$$.fragment,o),b(sa.$$.fragment,o),b(ra.$$.fragment,o),b(ia.$$.fragment,o),b(Pr.$$.fragment,o),b(ca.$$.fragment,o),b(la.$$.fragment,o),b(pa.$$.fragment,o),b(Yr.$$.fragment,o),b(Xr.$$.fragment,o),b(ga.$$.fragment,o),b(Qr.$$.fragment,o),b(ua.$$.fragment,o),b(zr.$$.fragment,o),b(Or.$$.fragment,o),b(fa.$$.fragment,o),b(ma.$$.fragment,o),b(Kr.$$.fragment,o),b(_a.$$.fragment,o),b(ei.$$.fragment,o),b(ba.$$.fragment,o),b(ti.$$.fragment,o),b(ni.$$.fragment,o),b(oi.$$.fragment,o),b(ai.$$.fragment,o),b(si.$$.fragment,o),b(ri.$$.fragment,o),b(ii.$$.fragment,o),b(ci.$$.fragment,o),b(li.$$.fragment,o),b(pi.$$.fragment,o),b(wa.$$.fragment,o),b(di.$$.fragment,o),b(ka.$$.fragment,o),b(gi.$$.fragment,o),b(Ta.$$.fragment,o),b(ui.$$.fragment,o),b(ja.$$.fragment,o),b(hi.$$.fragment,o),b(Ma.$$.fragment,o),b(fi.$$.fragment,o),b(qa.$$.fragment,o),b(mi.$$.fragment,o),b(Ua.$$.fragment,o),b(_i.$$.fragment,o),b(Ha.$$.fragment,o),b(bi.$$.fragment,o),b(yi.$$.fragment,o),b(Ia.$$.fragment,o),b(vi.$$.fragment,o),b(xi.$$.fragment,o),b($i.$$.fragment,o),b(Aa.$$.fragment,o),b(wi.$$.fragment,o),b(ki.$$.fragment,o),b(Da.$$.fragment,o),b(Ti.$$.fragment,o),b(Ra.$$.fragment,o),b(Ga.$$.fragment,o),b(ji.$$.fragment,o),b(Za.$$.fragment,o),b(Mi.$$.fragment,o),b(qi.$$.fragment,o),b(Ui.$$.fragment,o),b(Sa.$$.fragment,o),b(Hi.$$.fragment,o),b(Ci.$$.fragment,o),b(Wa.$$.fragment,o),b(Ii.$$.fragment,o),b(Ji.$$.fragment,o),b(Va.$$.fragment,o),b(Ni.$$.fragment,o),b(Ba.$$.fragment,o),b(Pa.$$.fragment,o),b(Ai.$$.fragment,o),b(Ya.$$.fragment,o),b(Ei.$$.fragment,o),b(Xa.$$.fragment,o),b(Di.$$.fragment,o),b(Qa.$$.fragment,o),b(Ri.$$.fragment,o),b(za.$$.fragment,o),b(Gi.$$.fragment,o),b(Oa.$$.fragment,o),b(Ka.$$.fragment,o),b(Zi.$$.fragment,o),b(es.$$.fragment,o),b(Fi.$$.fragment,o),b(ts.$$.fragment,o),b(Si.$$.fragment,o),b(Li.$$.fragment,o),b(os.$$.fragment,o),b(Wi.$$.fragment,o),b(as.$$.fragment,o),b(Vi.$$.fragment,o),b(ss.$$.fragment,o),b(Bi.$$.fragment,o),b(Pi.$$.fragment,o),b(is.$$.fragment,o),b(Yi.$$.fragment,o),b(cs.$$.fragment,o),b(Xi.$$.fragment,o),b(ls.$$.fragment,o),b(Qi.$$.fragment,o),b(ps.$$.fragment,o),b(zi.$$.fragment,o),b(Oi.$$.fragment,o),b(Ki.$$.fragment,o),b(gs.$$.fragment,o),b(ec.$$.fragment,o),b(us.$$.fragment,o),b(hs.$$.fragment,o),b(tc.$$.fragment,o),b(nc.$$.fragment,o),b(oc.$$.fragment,o),b(ac.$$.fragment,o),b(sc.$$.fragment,o),b(ys.$$.fragment,o),b(rc.$$.fragment,o),b(vs.$$.fragment,o),b(ic.$$.fragment,o),b(xs.$$.fragment,o),b(cc.$$.fragment,o),b($s.$$.fragment,o),b(lc.$$.fragment,o),b(pc.$$.fragment,o),b(dc.$$.fragment,o),b(gc.$$.fragment,o),b(uc.$$.fragment,o),b(ks.$$.fragment,o),b(Ts.$$.fragment,o),b(hc.$$.fragment,o),b(js.$$.fragment,o),b(Ms.$$.fragment,o),b(qs.$$.fragment,o),b(fc.$$.fragment,o),b(mc.$$.fragment,o),b(Us.$$.fragment,o),b(Hs.$$.fragment,o),b(_c.$$.fragment,o),b(Cs.$$.fragment,o),b(bc.$$.fragment,o),b(Is.$$.fragment,o),b(yc.$$.fragment,o),b(Js.$$.fragment,o),b(vc.$$.fragment,o),b(Ns.$$.fragment,o),b(xc.$$.fragment,o),b($c.$$.fragment,o),b(wc.$$.fragment,o),b(kc.$$.fragment,o),b(Es.$$.fragment,o),b(Tc.$$.fragment,o),b(Ds.$$.fragment,o),b(jc.$$.fragment,o),b(Rs.$$.fragment,o),b(Gs.$$.fragment,o),b(Mc.$$.fragment,o),b(Zs.$$.fragment,o),b(Fs.$$.fragment,o),b(Ss.$$.fragment,o),b(qc.$$.fragment,o),b(Uc.$$.fragment,o),b(Ls.$$.fragment,o),b(Hc.$$.fragment,o),b(Cc.$$.fragment,o),b(Ws.$$.fragment,o),b(Ic.$$.fragment,o),b(Vs.$$.fragment,o),b(Bs.$$.fragment,o),b(Ps.$$.fragment,o),b(Jc.$$.fragment,o),b(Nc.$$.fragment,o),b(Xs.$$.fragment,o),b(Ac.$$.fragment,o),b(Qs.$$.fragment,o),b(Ec.$$.fragment,o),b(zs.$$.fragment,o),b(Dc.$$.fragment,o),b(Rc.$$.fragment,o),b(Gc.$$.fragment,o),b(Os.$$.fragment,o),b(Zc.$$.fragment,o),b(Ks.$$.fragment,o),b(Fc.$$.fragment,o),b(er.$$.fragment,o),b(tr.$$.fragment,o),b(nr.$$.fragment,o),b(Sc.$$.fragment,o),b(or.$$.fragment,o),b(ar.$$.fragment,o),b(sr.$$.fragment,o),b(rr.$$.fragment,o),b(Lc.$$.fragment,o),b(ir.$$.fragment,o),b(cr.$$.fragment,o),b(Wc.$$.fragment,o),b(Vc.$$.fragment,o),b(Bc.$$.fragment,o),b(Pc.$$.fragment,o),b(Yc.$$.fragment,o),b(Xc.$$.fragment,o),b(Qc.$$.fragment,o),b(zc.$$.fragment,o),b(pr.$$.fragment,o),b(Oc.$$.fragment,o),b(Kc.$$.fragment,o),b(el.$$.fragment,o),b(tl.$$.fragment,o),b(nl.$$.fragment,o),b(ol.$$.fragment,o),b(al.$$.fragment,o),b(sl.$$.fragment,o),b(dr.$$.fragment,o),b(rl.$$.fragment,o),b(il.$$.fragment,o),b(gr.$$.fragment,o),b(cl.$$.fragment,o),b(ll.$$.fragment,o),b(pl.$$.fragment,o),b(dl.$$.fragment,o),b(ur.$$.fragment,o),b(gl.$$.fragment,o),b(ul.$$.fragment,o),b(hl.$$.fragment,o),b(fl.$$.fragment,o),b(ml.$$.fragment,o),b(_l.$$.fragment,o),b(hr.$$.fragment,o),b(bl.$$.fragment,o),b(yl.$$.fragment,o),b(vl.$$.fragment,o),b(xl.$$.fragment,o),b($l.$$.fragment,o),b(wl.$$.fragment,o),b(kl.$$.fragment,o),b(jl.$$.fragment,o),b(Ml.$$.fragment,o),b(fr.$$.fragment,o),b(ql.$$.fragment,o),b(Ul.$$.fragment,o),b(Hl.$$.fragment,o),b(Cl.$$.fragment,o),b(Il.$$.fragment,o),b(mr.$$.fragment,o),b(_r.$$.fragment,o),b(Jl.$$.fragment,o),b(br.$$.fragment,o),b(Nl.$$.fragment,o),b(Al.$$.fragment,o),b(El.$$.fragment,o),xm=!1},d(o){o&&(p(u),p(i),p(a),p(e),p(v),p(qf),p(kr),p(Uf),p(Tr),p(Hf),p(Cf),p(If),p(w),p(Jf),p(Nf),p(Af),p(zn),p(Ef),p(Df),p(yt),p(Rf),p(Gf),p(vt),p(Zf),p(Ff),p(On),p(Sf),p(Lf),p(Kn),p(Wf),p(Vf),p(xt),p(Bf),p(Pf),p($t),p(Yf),p(Xf),p(wt),p(Qf),p(zf),p(eo),p(Of),p(Kf),p(K),p(em),p(tm),p(ee),p(nm),p(om),p(Te),p(am),p(sm),p(kt),p(rm),p(im),p(Tt),p(cm),p(lm),p(to),p(pm),p(dm),p(no),p(gm),p(um),p(Tl),p(hm),p(je),p(fm),p(oo),p(mm),p(te),p(_m),p(bm),p(D),p(ym),p(vm),p(Mf)),p(t),y(g,o),y(jr,o),y(Mr,o),y(qr),y(Ur),y(Hr),y(Zo),y(Cr),y(Ir),y(Jr),y(Fo),y(Nr),y(Ar),y(Er),y(Lo),y(Wo),y(Dr),y(Vo),y(Bo),y(Rr),y(Gr),y(Yo),y(Zr),y(Xo),y(Qo),y(zo),y(Fr),y(Oo),y(Sr),y(Ko),y(ea),y(ta),y(Lr),y(na),y(Wr),y(oa),y(Vr),y(Br),y(sa),y(ra),y(ia),y(Pr),y(ca),y(la),y(pa),y(Yr),y(Xr),y(ga),y(Qr),y(ua),y(zr),y(Or),y(fa),y(ma),y(Kr),y(_a),y(ei),y(ba),y(ti),y(ni),y(oi),y(ai),y(si),y(ri),y(ii),y(ci),y(li),y(pi),y(wa),y(di),y(ka),y(gi),y(Ta),y(ui),y(ja),y(hi),y(Ma),y(fi),y(qa),y(mi),y(Ua),y(_i),y(Ha),y(bi),y(yi),y(Ia),y(vi),y(xi),y($i),y(Aa),y(wi),y(ki),y(Da),y(Ti),y(Ra),y(Ga),y(ji),y(Za),y(Mi),y(qi),y(Ui),y(Sa),y(Hi),y(Ci),y(Wa),y(Ii),y(Ji),y(Va),y(Ni),y(Ba),y(Pa),y(Ai),y(Ya),y(Ei),y(Xa),y(Di),y(Qa),y(Ri),y(za),y(Gi),y(Oa),y(Ka),y(Zi),y(es),y(Fi),y(ts),y(Si),y(Li),y(os),y(Wi),y(as),y(Vi),y(ss),y(Bi),y(Pi),y(is),y(Yi),y(cs),y(Xi),y(ls),y(Qi),y(ps),y(zi),y(Oi),y(Ki),y(gs),y(ec),y(us),y(hs),y(tc),y(nc),y(oc),y(ac),y(sc),y(ys),y(rc),y(vs),y(ic),y(xs),y(cc),y($s),y(lc),y(pc),y(dc),y(gc),y(uc),y(ks),y(Ts),y(hc),y(js),y(Ms),y(qs),y(fc),y(mc),y(Us),y(Hs),y(_c),y(Cs),y(bc),y(Is),y(yc),y(Js),y(vc),y(Ns),y(xc),y($c),y(wc),y(kc),y(Es),y(Tc),y(Ds),y(jc),y(Rs),y(Gs),y(Mc),y(Zs),y(Fs),y(Ss),y(qc),y(Uc),y(Ls),y(Hc),y(Cc),y(Ws),y(Ic),y(Vs),y(Bs),y(Ps),y(Jc),y(Nc),y(Xs),y(Ac),y(Qs),y(Ec),y(zs),y(Dc),y(Rc),y(Gc),y(Os),y(Zc),y(Ks),y(Fc),y(er),y(tr),y(nr),y(Sc),y(or),y(ar),y(sr),y(rr),y(Lc),y(ir),y(cr),y(Wc),y(Vc,o),y(Bc,o),y(Pc),y(Yc,o),y(Xc),y(Qc,o),y(zc),y(pr),y(Oc,o),y(Kc),y(el,o),y(tl),y(nl,o),y(ol),y(al,o),y(sl),y(dr),y(rl,o),y(il),y(gr),y(cl,o),y(ll),y(pl,o),y(dl),y(ur),y(gl,o),y(ul),y(hl,o),y(fl),y(ml,o),y(_l),y(hr),y(bl,o),y(yl),y(vl,o),y(xl),y($l,o),y(wl),y(kl,o),y(jl),y(Ml),y(fr),y(ql),y(Ul),y(Hl),y(Cl,o),y(Il),y(mr),y(_r),y(Jl),y(br),y(Nl),y(Al),y(El,o)}}}const IH='{"title":"HfApi Client","local":"hfapi-client","sections":[{"title":"HfApi","local":"huggingface_hub.HfApi ][ huggingface_hub.HfApi","sections":[],"depth":2},{"title":"API Dataclasses","local":"api-dataclasses","sections":[{"title":"AccessRequest","local":"huggingface_hub.hf_api.AccessRequest ][ huggingface_hub.hf_api.AccessRequest","sections":[],"depth":3},{"title":"CommitInfo","local":"huggingface_hub.CommitInfo ][ huggingface_hub.CommitInfo","sections":[],"depth":3},{"title":"DatasetInfo","local":"huggingface_hub.hf_api.DatasetInfo ][ huggingface_hub.DatasetInfo","sections":[],"depth":3},{"title":"GitRefInfo","local":"huggingface_hub.GitRefInfo ][ huggingface_hub.GitRefInfo","sections":[],"depth":3},{"title":"GitCommitInfo","local":"huggingface_hub.GitCommitInfo ][ huggingface_hub.GitCommitInfo","sections":[],"depth":3},{"title":"GitRefs","local":"huggingface_hub.GitRefs ][ huggingface_hub.GitRefs","sections":[],"depth":3},{"title":"ModelInfo","local":"huggingface_hub.hf_api.ModelInfo ][ huggingface_hub.ModelInfo","sections":[],"depth":3},{"title":"RepoSibling","local":"huggingface_hub.hf_api.RepoSibling ][ huggingface_hub.hf_api.RepoSibling","sections":[],"depth":3},{"title":"RepoFile","local":"huggingface_hub.hf_api.RepoFile ][ huggingface_hub.hf_api.RepoFile","sections":[],"depth":3},{"title":"RepoUrl","local":"huggingface_hub.RepoUrl ][ huggingface_hub.RepoUrl","sections":[],"depth":3},{"title":"SafetensorsRepoMetadata","local":"huggingface_hub.utils.SafetensorsRepoMetadata ][ huggingface_hub.utils.SafetensorsRepoMetadata","sections":[],"depth":3},{"title":"SafetensorsFileMetadata","local":"huggingface_hub.utils.SafetensorsFileMetadata ][ huggingface_hub.utils.SafetensorsFileMetadata","sections":[],"depth":3},{"title":"SpaceInfo","local":"huggingface_hub.hf_api.SpaceInfo ][ huggingface_hub.SpaceInfo","sections":[],"depth":3},{"title":"TensorInfo","local":"huggingface_hub.utils.TensorInfo ][ huggingface_hub.utils.TensorInfo","sections":[],"depth":3},{"title":"User","local":"huggingface_hub.User ][ huggingface_hub.User","sections":[],"depth":3},{"title":"UserLikes","local":"huggingface_hub.UserLikes ][ huggingface_hub.UserLikes","sections":[],"depth":3}],"depth":2},{"title":"CommitOperation","local":"huggingface_hub.CommitOperationAdd ][ huggingface_hub.CommitOperationAdd","sections":[],"depth":2},{"title":"CommitScheduler","local":"huggingface_hub.CommitScheduler ][ huggingface_hub.CommitScheduler","sections":[],"depth":2}],"depth":1}';function JH(T){return _q(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class FH extends bq{constructor(t){super(),yq(this,t,JH,CH,mq,{})}}export{FH as component};
