import{s as fs,o as gs,n as _l}from"../chunks/scheduler.f7e1785c.js";import{S as bs,i as Bs,g as i,s as a,r as y,A as _s,h as p,f as s,c as M,j as ms,u as T,x as r,k as As,y as Es,a as e,v as w,d as c,t as u,w as U}from"../chunks/index.d8354395.js";import{T as bl}from"../chunks/Tip.d2769a7f.js";import{C as m}from"../chunks/CodeBlock.191e5103.js";import{H as Bl,E as vs}from"../chunks/getInferenceSnippets.ce3094f0.js";function Zs(I){let n,J="If you’re using uv, you can create a <code>.env</code> file in the root of the project and you won’t need to use <code>load_dotenv()</code> if you use <code>uv run</code> to run the server.";return{c(){n=i("p"),n.innerHTML=J},l(j){n=p(j,"P",{"data-svelte-h":!0}),r(n)!=="svelte-8cy2ai"&&(n.innerHTML=J)},m(j,o){e(j,n,o)},p:_l,d(j){j&&s(n)}}}function $s(I){let n,J="All MCP tools must return strings, not Python objects. That’s why we use <code>json.dumps()</code> to convert our results to JSON strings. This ensures reliable data exchange between the MCP server and client.";return{c(){n=i("p"),n.innerHTML=J},l(j){n=p(j,"P",{"data-svelte-h":!0}),r(n)!=="svelte-h8nfmk"&&(n.innerHTML=J)},m(j,o){e(j,n,o)},p:_l,d(j){j&&s(n)}}}function Rs(I){let n,J="The extensive logging might seem overkill, but it helps with debugging and monitoring when the server is running. Remember, your application will autonomously reacting to events from the Hub, so you won’t be able to see the logs in real time.";return{c(){n=i("p"),n.textContent=J},l(j){n=p(j,"P",{"data-svelte-h":!0}),r(n)!=="svelte-1at818h"&&(n.textContent=J)},m(j,o){e(j,n,o)},p:_l,d(j){j&&s(n)}}}function Gs(I){let n,J="Always check the current state before making changes. This prevents duplicate work and provides better user feedback. It’s especially important when creating pull requests, as duplicate PRs can clutter the repository.";return{c(){n=i("p"),n.textContent=J},l(j){n=p(j,"P",{"data-svelte-h":!0}),r(n)!=="svelte-vu75i9"&&(n.textContent=J)},m(j,o){e(j,n,o)},p:_l,d(j){j&&s(n)}}}function ks(I){let n,J="Clear, detailed PR descriptions are essential for automated pull requests. They help repository maintainers understand what’s happening and make informed decisions about whether to merge the changes.",j,o,h="Also, it’s good practice to clearly state that the PR is created by an automated tool. This helps repository maintainers understand how to deal with the PR.";return{c(){n=i("p"),n.textContent=J,j=a(),o=i("p"),o.textContent=h},l(d){n=p(d,"P",{"data-svelte-h":!0}),r(n)!=="svelte-l2z0wl"&&(n.textContent=J),j=M(d),o=p(d,"P",{"data-svelte-h":!0}),r(o)!=="svelte-13yd2bp"&&(o.textContent=h)},m(d,C){e(d,n,C),e(d,j,C),e(d,o,C)},p:_l,d(d){d&&(s(n),s(j),s(o))}}}function Ns(I){let n,J="Whilst building this application, it’s easy to accidentally create an infinite loop of PRs. This is because the <code>create_commit</code> function with <code>create_pr=True</code> will create a PR for every commit. If the PR is not merged, the <code>create_commit</code> function will be called again, and again, and again…",j,o,h="We’ve added checks to prevent this, but it’s something to be aware of.";return{c(){n=i("p"),n.innerHTML=J,j=a(),o=i("p"),o.textContent=h},l(d){n=p(d,"P",{"data-svelte-h":!0}),r(n)!=="svelte-14e0bs9"&&(n.innerHTML=J),j=M(d),o=p(d,"P",{"data-svelte-h":!0}),r(o)!=="svelte-1o86mp7"&&(o.textContent=h)},m(d,C){e(d,n,C),e(d,j,C),e(d,o,C)},p:_l,d(d){d&&(s(n),s(j),s(o))}}}function qs(I){let n,J="The MCP server runs as a separate process from your main application. This isolation provides better error handling and allows the server to be reused by multiple clients or applications.";return{c(){n=i("p"),n.textContent=J},l(j){n=p(j,"P",{"data-svelte-h":!0}),r(n)!=="svelte-naehyy"&&(n.textContent=J)},m(j,o){e(j,n,o)},p:_l,d(j){j&&s(n)}}}function Qs(I){let n,J,j,o,h,d,C,kt="The MCP server is the heart of our Pull Request Agent. It provides the tools that our agent will use to interact with the Hugging Face Hub, specifically for reading and updating model repository tags. In this section, we’ll build the server using FastMCP and the Hugging Face Hub Python SDK.",vl,v,Zl,Z,Nt="Our MCP server provides two essential tools:",$l,$,qt="<thead><tr><th>Tool</th> <th>Description</th></tr></thead> <tbody><tr><td><code>get_current_tags</code></td> <td>Retrieves existing tags from a model repository</td></tr> <tr><td><code>add_new_tag</code></td> <td>Adds a new tag to a repository via pull request</td></tr></tbody>",Rl,R,Qt="These tools abstract the complexity of Hub API interactions and provide a clean interface for our agent to work with.",Gl,G,Xt='<img src="https://huggingface.co/datasets/mcp-course/images/resolve/main/unit3/architecture.png" alt="MCP Server Tools"/>',kl,k,Nl,N,Ht="Let’s create our <code>mcp_server.py</code> file step by step. We’ll build this incrementally so you understand each component and how they work together.",ql,q,Ql,Q,Wt="First, let’s set up all the necessary imports and configuration.",Xl,X,Hl,H,Vt="The imports above give us everything we need to build our MCP server. <code>FastMCP</code> provides the server framework, while the <code>huggingface_hub</code> imports give us the tools to interact with model repositories.",Wl,W,St="The <code>load_dotenv()</code> call automatically loads environment variables from a <code>.env</code> file, making it easy to manage secrets like API tokens during development.",Vl,A,Sl,V,xt="Next, we’ll configure our server with the necessary credentials and create the FastMCP instance:",xl,S,Fl,x,Ft="This configuration block does three important things:",Yl,F,Yt="<li>Retrieves the Hugging Face token from environment variables</li> <li>Creates an authenticated API client (only if a token is available)</li> <li>Initializes our FastMCP server with a descriptive name</li>",zl,Y,zt="The conditional creation of <code>hf_api</code> ensures our server can start even without a token, which is useful for testing the basic structure.",Pl,z,Ll,P,Pt="Now let’s implement our first tool - <code>get_current_tags</code>. This tool retrieves the existing tags from a model repository:",Kl,L,Dl,K,Lt="The function starts with validation - checking if we have an authenticated API client. Notice how we return JSON strings instead of Python objects. This is crucial for MCP communication.",Ol,f,lt,D,Kt="Let’s continue with the main logic of the <code>get_current_tags</code> function:",tt,O,st,ll,Dt="This implementation follows a clear pattern:",et,tl,Ot="<li><strong>Fetch data</strong> using the Hugging Face Hub API</li> <li><strong>Process the response</strong> to extract tag information</li> <li><strong>Structure the result</strong> in a consistent JSON format</li> <li><strong>Handle errors gracefully</strong> with detailed error messages</li>",nt,g,at,sl,Mt,el,ls="Now for the more complex tool - <code>add_new_tag</code>. This tool adds a new tag to a repository by creating a pull request. Let’s start with the initial setup and validation:",it,nl,pt,al,ts="Similar to our first tool, we start with validation. Now let’s fetch the current repository state to check if the tag already exists:",jt,Ml,rt,il,ss="This section demonstrates an important principle: <strong>validate before acting</strong>. We check if the tag already exists to avoid creating unnecessary pull requests.",ot,b,Jt,pl,es="Next, we’ll prepare the updated tag list and handle the model card:",yt,jl,Tt,rl,ns="This section handles model card management. We try to load an existing model card first, but create a new one if none exists. This ensures our tool works with any repository, even if it’s empty.",wt,ol,as="The model card (<code>README.md</code>) contains the repository metadata, including tags. By updating the model card data and creating a pull request, we’re following the standard Hugging Face workflow for metadata changes.",ct,Jl,Ms="Now for the pull request creation - the main part of our tool:",ut,yl,Ut,Tl,is="We create a detailed pull request description that explains what’s changing and why. This transparency is crucial for repository maintainers who will review the PR.",dt,B,It,wl,ps="Finally, we create the commit and pull request:",Ct,cl,ht,ul,js="The <code>create_commit</code> function with <code>create_pr=True</code> is the key to our automation. It creates a commit with the updated <code>README.md</code> file and automatically opens a pull request for review.",mt,Ul,rs="Don’t forget the error handling for this complex operation:",At,dl,ft,Il,os="The comprehensive error handling includes the full traceback, which is invaluable for debugging when things go wrong.",gt,Cl,Js="Emojis in log messages might seem silly, but they make scanning logs much faster. 🔧 for function calls, 📡 for API requests, ✅ for success, and ❌ for errors create visual patterns that help you quickly find what you’re looking for.",bt,_,Bt,hl,_t,ml,ys="Now that we have our MCP server implemented with robust tagging tools, we need to:",Et,Al,Ts="<li><strong>Create the MCP Client</strong> - Build the interface between our agent and MCP server</li> <li><strong>Implement Webhook Handling</strong> - Listen for Hub discussion events</li> <li><strong>Integrate Agent Logic</strong> - Connect webhooks with MCP tool calls</li> <li><strong>Test the Complete System</strong> - Validate end-to-end functionality</li>",vt,fl,ws="In the next section, we’ll create the MCP client that will allow our webhook handler to interact with these tools intelligently.",Zt,E,$t,gl,Rt,El,Gt;return h=new Bl({props:{title:"Creating the MCP Server",local:"creating-the-mcp-server",headingTag:"h1"}}),v=new Bl({props:{title:"Understanding the MCP Server Architecture",local:"understanding-the-mcp-server-architecture",headingTag:"h2"}}),k=new Bl({props:{title:"Complete MCP Server Implementation",local:"complete-mcp-server-implementation",headingTag:"h2"}}),q=new Bl({props:{title:"1. Imports and Configuration",local:"1-imports-and-configuration",headingTag:"h3"}}),X=new m({props:{code:"JTIzISUyRnVzciUyRmJpbiUyRmVudiUyMHB5dGhvbjMlMEElMjIlMjIlMjIlMEFTaW1wbGlmaWVkJTIwTUNQJTIwU2VydmVyJTIwZm9yJTIwSHVnZ2luZ0ZhY2UlMjBIdWIlMjBUYWdnaW5nJTIwT3BlcmF0aW9ucyUyMHVzaW5nJTIwRmFzdE1DUCUwQSUyMiUyMiUyMiUwQSUwQWltcG9ydCUyMG9zJTBBaW1wb3J0JTIwanNvbiUwQWZyb20lMjBmYXN0bWNwJTIwaW1wb3J0JTIwRmFzdE1DUCUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBIZkFwaSUyQyUyMG1vZGVsX2luZm8lMkMlMjBNb2RlbENhcmQlMkMlMjBNb2RlbENhcmREYXRhJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1Yi51dGlscyUyMGltcG9ydCUyMEhmSHViSFRUUEVycm9yJTBBZnJvbSUyMGRvdGVudiUyMGltcG9ydCUyMGxvYWRfZG90ZW52JTBBJTBBbG9hZF9kb3RlbnYoKQ==",highlighted:`<span class="hljs-comment">#!/usr/bin/env python3</span>
<span class="hljs-string">&quot;&quot;&quot;
Simplified MCP Server for HuggingFace Hub Tagging Operations using FastMCP
&quot;&quot;&quot;</span>

<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">from</span> fastmcp <span class="hljs-keyword">import</span> FastMCP
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi, model_info, ModelCard, ModelCardData
<span class="hljs-keyword">from</span> huggingface_hub.utils <span class="hljs-keyword">import</span> HfHubHTTPError
<span class="hljs-keyword">from</span> dotenv <span class="hljs-keyword">import</span> load_dotenv

load_dotenv()`,wrap:!1}}),A=new bl({props:{$$slots:{default:[Zs]},$$scope:{ctx:I}}}),S=new m({props:{code:"JTIzJTIwQ29uZmlndXJhdGlvbiUwQUhGX1RPS0VOJTIwJTNEJTIwb3MuZ2V0ZW52KCUyMkhGX1RPS0VOJTIyKSUwQSUwQSUyMyUyMEluaXRpYWxpemUlMjBIRiUyMEFQSSUyMGNsaWVudCUwQWhmX2FwaSUyMCUzRCUyMEhmQXBpKHRva2VuJTNESEZfVE9LRU4pJTIwaWYlMjBIRl9UT0tFTiUyMGVsc2UlMjBOb25lJTBBJTBBJTIzJTIwQ3JlYXRlJTIwdGhlJTIwRmFzdE1DUCUyMHNlcnZlciUwQW1jcCUyMCUzRCUyMEZhc3RNQ1AoJTIyaGYtdGFnZ2luZy1ib3QlMjIp",highlighted:`<span class="hljs-comment"># Configuration</span>
HF_TOKEN = os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)

<span class="hljs-comment"># Initialize HF API client</span>
hf_api = HfApi(token=HF_TOKEN) <span class="hljs-keyword">if</span> HF_TOKEN <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>

<span class="hljs-comment"># Create the FastMCP server</span>
mcp = FastMCP(<span class="hljs-string">&quot;hf-tagging-bot&quot;</span>)`,wrap:!1}}),z=new Bl({props:{title:"2. Get Current Tags Tool",local:"2-get-current-tags-tool",headingTag:"h3"}}),L=new m({props:{code:"JTQwbWNwLnRvb2woKSUwQWRlZiUyMGdldF9jdXJyZW50X3RhZ3MocmVwb19pZCUzQSUyMHN0ciklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyR2V0JTIwY3VycmVudCUyMHRhZ3MlMjBmcm9tJTIwYSUyMEh1Z2dpbmdGYWNlJTIwbW9kZWwlMjByZXBvc2l0b3J5JTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiVGMCU5RiU5NCVBNyUyMGdldF9jdXJyZW50X3RhZ3MlMjBjYWxsZWQlMjB3aXRoJTIwcmVwb19pZCUzQSUyMCU3QnJlcG9faWQlN0QlMjIpJTBBJTBBJTIwJTIwJTIwJTIwaWYlMjBub3QlMjBoZl9hcGklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlcnJvcl9yZXN1bHQlMjAlM0QlMjAlN0IlMjJlcnJvciUyMiUzQSUyMCUyMkhGJTIwdG9rZW4lMjBub3QlMjBjb25maWd1cmVkJTIyJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwanNvbl9zdHIlMjAlM0QlMjBqc29uLmR1bXBzKGVycm9yX3Jlc3VsdCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIyJUUyJTlEJThDJTIwTm8lMjBIRiUyMEFQSSUyMHRva2VuJTIwLSUyMHJldHVybmluZyUzQSUyMCU3Qmpzb25fc3RyJTdEJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGpzb25fc3Ry",highlighted:`<span class="hljs-meta">@mcp.tool()</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_tags</span>(<span class="hljs-params">repo_id: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Get current tags from a HuggingFace model repository&quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🔧 get_current_tags called with repo_id: <span class="hljs-subst">{repo_id}</span>&quot;</span>)

    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> hf_api:
        error_result = {<span class="hljs-string">&quot;error&quot;</span>: <span class="hljs-string">&quot;HF token not configured&quot;</span>}
        json_str = json.dumps(error_result)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;❌ No HF API token - returning: <span class="hljs-subst">{json_str}</span>&quot;</span>)
        <span class="hljs-keyword">return</span> json_str`,wrap:!1}}),f=new bl({props:{$$slots:{default:[$s]},$$scope:{ctx:I}}}),O=new m({props:{code:"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",highlighted:`    <span class="hljs-keyword">try</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📡 Fetching model info for: <span class="hljs-subst">{repo_id}</span>&quot;</span>)
        info = model_info(repo_id=repo_id, token=HF_TOKEN)
        current_tags = info.tags <span class="hljs-keyword">if</span> info.tags <span class="hljs-keyword">else</span> []
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🏷️ Found <span class="hljs-subst">{<span class="hljs-built_in">len</span>(current_tags)}</span> tags: <span class="hljs-subst">{current_tags}</span>&quot;</span>)

        result = {
            <span class="hljs-string">&quot;status&quot;</span>: <span class="hljs-string">&quot;success&quot;</span>,
            <span class="hljs-string">&quot;repo_id&quot;</span>: repo_id,
            <span class="hljs-string">&quot;current_tags&quot;</span>: current_tags,
            <span class="hljs-string">&quot;count&quot;</span>: <span class="hljs-built_in">len</span>(current_tags),
        }
        json_str = json.dumps(result)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;✅ get_current_tags returning: <span class="hljs-subst">{json_str}</span>&quot;</span>)
        <span class="hljs-keyword">return</span> json_str

    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;❌ Error in get_current_tags: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>)
        error_result = {<span class="hljs-string">&quot;status&quot;</span>: <span class="hljs-string">&quot;error&quot;</span>, <span class="hljs-string">&quot;repo_id&quot;</span>: repo_id, <span class="hljs-string">&quot;error&quot;</span>: <span class="hljs-built_in">str</span>(e)}
        json_str = json.dumps(error_result)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;❌ get_current_tags error returning: <span class="hljs-subst">{json_str}</span>&quot;</span>)
        <span class="hljs-keyword">return</span> json_str`,wrap:!1}}),g=new bl({props:{$$slots:{default:[Rs]},$$scope:{ctx:I}}}),sl=new Bl({props:{title:"3. Add New Tag Tool",local:"3-add-new-tag-tool",headingTag:"h3"}}),nl=new m({props:{code:"JTQwbWNwLnRvb2woKSUwQWRlZiUyMGFkZF9uZXdfdGFnKHJlcG9faWQlM0ElMjBzdHIlMkMlMjBuZXdfdGFnJTNBJTIwc3RyKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJBZGQlMjBhJTIwbmV3JTIwdGFnJTIwdG8lMjBhJTIwSHVnZ2luZ0ZhY2UlMjBtb2RlbCUyMHJlcG9zaXRvcnklMjB2aWElMjBQUiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlRjAlOUYlOTQlQTclMjBhZGRfbmV3X3RhZyUyMGNhbGxlZCUyMHdpdGglMjByZXBvX2lkJTNBJTIwJTdCcmVwb19pZCU3RCUyQyUyMG5ld190YWclM0ElMjAlN0JuZXdfdGFnJTdEJTIyKSUwQSUwQSUyMCUyMCUyMCUyMGlmJTIwbm90JTIwaGZfYXBpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXJyb3JfcmVzdWx0JTIwJTNEJTIwJTdCJTIyZXJyb3IlMjIlM0ElMjAlMjJIRiUyMHRva2VuJTIwbm90JTIwY29uZmlndXJlZCUyMiU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGpzb25fc3RyJTIwJTNEJTIwanNvbi5kdW1wcyhlcnJvcl9yZXN1bHQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiVFMiU5RCU4QyUyME5vJTIwSEYlMjBBUEklMjB0b2tlbiUyMC0lMjByZXR1cm5pbmclM0ElMjAlN0Jqc29uX3N0ciU3RCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBqc29uX3N0cg==",highlighted:`<span class="hljs-meta">@mcp.tool()</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">add_new_tag</span>(<span class="hljs-params">repo_id: <span class="hljs-built_in">str</span>, new_tag: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Add a new tag to a HuggingFace model repository via PR&quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🔧 add_new_tag called with repo_id: <span class="hljs-subst">{repo_id}</span>, new_tag: <span class="hljs-subst">{new_tag}</span>&quot;</span>)

    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> hf_api:
        error_result = {<span class="hljs-string">&quot;error&quot;</span>: <span class="hljs-string">&quot;HF token not configured&quot;</span>}
        json_str = json.dumps(error_result)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;❌ No HF API token - returning: <span class="hljs-subst">{json_str}</span>&quot;</span>)
        <span class="hljs-keyword">return</span> json_str`,wrap:!1}}),Ml=new m({props:{code:"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",highlighted:`    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Get current model info and tags</span>
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📡 Fetching current model info for: <span class="hljs-subst">{repo_id}</span>&quot;</span>)
        info = model_info(repo_id=repo_id, token=HF_TOKEN)
        current_tags = info.tags <span class="hljs-keyword">if</span> info.tags <span class="hljs-keyword">else</span> []
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🏷️ Current tags: <span class="hljs-subst">{current_tags}</span>&quot;</span>)

        <span class="hljs-comment"># Check if tag already exists</span>
        <span class="hljs-keyword">if</span> new_tag <span class="hljs-keyword">in</span> current_tags:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;⚠️ Tag &#x27;<span class="hljs-subst">{new_tag}</span>&#x27; already exists in <span class="hljs-subst">{current_tags}</span>&quot;</span>)
            result = {
                <span class="hljs-string">&quot;status&quot;</span>: <span class="hljs-string">&quot;already_exists&quot;</span>,
                <span class="hljs-string">&quot;repo_id&quot;</span>: repo_id,
                <span class="hljs-string">&quot;tag&quot;</span>: new_tag,
                <span class="hljs-string">&quot;message&quot;</span>: <span class="hljs-string">f&quot;Tag &#x27;<span class="hljs-subst">{new_tag}</span>&#x27; already exists&quot;</span>,
            }
            json_str = json.dumps(result)
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🏷️ add_new_tag (already exists) returning: <span class="hljs-subst">{json_str}</span>&quot;</span>)
            <span class="hljs-keyword">return</span> json_str`,wrap:!1}}),b=new bl({props:{$$slots:{default:[Gs]},$$scope:{ctx:I}}}),jl=new m({props:{code:"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",highlighted:`        <span class="hljs-comment"># Add the new tag to existing tags</span>
        updated_tags = current_tags + [new_tag]
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🆕 Will update tags from <span class="hljs-subst">{current_tags}</span> to <span class="hljs-subst">{updated_tags}</span>&quot;</span>)

        <span class="hljs-comment"># Create model card content with updated tags</span>
        <span class="hljs-keyword">try</span>:
            <span class="hljs-comment"># Load existing model card</span>
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📄 Loading existing model card...&quot;</span>)
            card = ModelCard.load(repo_id, token=HF_TOKEN)
            <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> <span class="hljs-built_in">hasattr</span>(card, <span class="hljs-string">&quot;data&quot;</span>) <span class="hljs-keyword">or</span> card.data <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
                card.data = ModelCardData()
        <span class="hljs-keyword">except</span> HfHubHTTPError:
            <span class="hljs-comment"># Create new model card if none exists</span>
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📄 Creating new model card (none exists)&quot;</span>)
            card = ModelCard(<span class="hljs-string">&quot;&quot;</span>)
            card.data = ModelCardData()

        <span class="hljs-comment"># Update tags - create new ModelCardData with updated tags</span>
        card_dict = card.data.to_dict()
        card_dict[<span class="hljs-string">&quot;tags&quot;</span>] = updated_tags
        card.data = ModelCardData(**card_dict)`,wrap:!1}}),yl=new m({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwQ3JlYXRlJTIwYSUyMHB1bGwlMjByZXF1ZXN0JTIwd2l0aCUyMHRoZSUyMHVwZGF0ZWQlMjBtb2RlbCUyMGNhcmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcl90aXRsZSUyMCUzRCUyMGYlMjJBZGQlMjAnJTdCbmV3X3RhZyU3RCclMjB0YWclMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcl9kZXNjcmlwdGlvbiUyMCUzRCUyMGYlMjIlMjIlMjIlMEElMjMlMjMlMjBBZGQlMjB0YWclM0ElMjAlN0JuZXdfdGFnJTdEJTBBJTBBVGhpcyUyMFBSJTIwYWRkcyUyMHRoZSUyMCU2MCU3Qm5ld190YWclN0QlNjAlMjB0YWclMjB0byUyMHRoZSUyMG1vZGVsJTIwcmVwb3NpdG9yeS4lMEElMEEqKkNoYW5nZXMlM0EqKiUwQS0lMjBBZGRlZCUyMCU2MCU3Qm5ld190YWclN0QlNjAlMjB0byUyMG1vZGVsJTIwdGFncyUwQS0lMjBVcGRhdGVkJTIwZnJvbSUyMCU3QmxlbihjdXJyZW50X3RhZ3MpJTdEJTIwdG8lMjAlN0JsZW4odXBkYXRlZF90YWdzKSU3RCUyMHRhZ3MlMEElMEEqKkN1cnJlbnQlMjB0YWdzJTNBKiolMjAlN0IlMjIlMkMlMjAlMjIuam9pbihjdXJyZW50X3RhZ3MpJTIwaWYlMjBjdXJyZW50X3RhZ3MlMjBlbHNlJTIwJTIyTm9uZSUyMiU3RCUwQSoqTmV3JTIwdGFncyUzQSoqJTIwJTdCJTIyJTJDJTIwJTIyLmpvaW4odXBkYXRlZF90YWdzKSU3RCUwQSUwQSVGMCU5RiVBNCU5NiUyMFRoaXMlMjBpcyUyMGElMjBwdWxsJTIwcmVxdWVzdCUyMGNyZWF0ZWQlMjBieSUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwVGFnZ2luZyUyMEJvdC4lMEElMjIlMjIlMjIlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIyJUYwJTlGJTlBJTgwJTIwQ3JlYXRpbmclMjBQUiUyMHdpdGglMjB0aXRsZSUzQSUyMCU3QnByX3RpdGxlJTdEJTIyKQ==",highlighted:`        <span class="hljs-comment"># Create a pull request with the updated model card</span>
        pr_title = <span class="hljs-string">f&quot;Add &#x27;<span class="hljs-subst">{new_tag}</span>&#x27; tag&quot;</span>
        pr_description = <span class="hljs-string">f&quot;&quot;&quot;
## Add tag: <span class="hljs-subst">{new_tag}</span>

This PR adds the \`<span class="hljs-subst">{new_tag}</span>\` tag to the model repository.

**Changes:**
- Added \`<span class="hljs-subst">{new_tag}</span>\` to model tags
- Updated from <span class="hljs-subst">{<span class="hljs-built_in">len</span>(current_tags)}</span> to <span class="hljs-subst">{<span class="hljs-built_in">len</span>(updated_tags)}</span> tags

**Current tags:** <span class="hljs-subst">{<span class="hljs-string">&quot;, &quot;</span>.join(current_tags) <span class="hljs-keyword">if</span> current_tags <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;None&quot;</span>}</span>
**New tags:** <span class="hljs-subst">{<span class="hljs-string">&quot;, &quot;</span>.join(updated_tags)}</span>

🤖 This is a pull request created by the Hugging Face Hub Tagging Bot.
&quot;&quot;&quot;</span>

        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🚀 Creating PR with title: <span class="hljs-subst">{pr_title}</span>&quot;</span>)`,wrap:!1}}),B=new bl({props:{$$slots:{default:[ks]},$$scope:{ctx:I}}}),cl=new m({props:{code:"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",highlighted:`        <span class="hljs-comment"># Create commit with updated model card using CommitOperationAdd</span>
        <span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> CommitOperationAdd

        commit_info = hf_api.create_commit(
            repo_id=repo_id,
            operations=[
                CommitOperationAdd(
                    path_in_repo=<span class="hljs-string">&quot;README.md&quot;</span>, path_or_fileobj=<span class="hljs-built_in">str</span>(card).encode(<span class="hljs-string">&quot;utf-8&quot;</span>)
                )
            ],
            commit_message=pr_title,
            commit_description=pr_description,
            token=HF_TOKEN,
            create_pr=<span class="hljs-literal">True</span>,
        )

        <span class="hljs-comment"># Extract PR URL from commit info</span>
        pr_url_attr = commit_info.pr_url
        pr_url = pr_url_attr <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(commit_info, <span class="hljs-string">&quot;pr_url&quot;</span>) <span class="hljs-keyword">else</span> <span class="hljs-built_in">str</span>(commit_info)

        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;✅ PR created successfully! URL: <span class="hljs-subst">{pr_url}</span>&quot;</span>)

        result = {
            <span class="hljs-string">&quot;status&quot;</span>: <span class="hljs-string">&quot;success&quot;</span>,
            <span class="hljs-string">&quot;repo_id&quot;</span>: repo_id,
            <span class="hljs-string">&quot;tag&quot;</span>: new_tag,
            <span class="hljs-string">&quot;pr_url&quot;</span>: pr_url,
            <span class="hljs-string">&quot;previous_tags&quot;</span>: current_tags,
            <span class="hljs-string">&quot;new_tags&quot;</span>: updated_tags,
            <span class="hljs-string">&quot;message&quot;</span>: <span class="hljs-string">f&quot;Created PR to add tag &#x27;<span class="hljs-subst">{new_tag}</span>&#x27;&quot;</span>,
        }
        json_str = json.dumps(result)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;✅ add_new_tag success returning: <span class="hljs-subst">{json_str}</span>&quot;</span>)
        <span class="hljs-keyword">return</span> json_str`,wrap:!1}}),dl=new m({props:{code:"JTIwJTIwJTIwJTIwZXhjZXB0JTIwRXhjZXB0aW9uJTIwYXMlMjBlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiVFMiU5RCU4QyUyMEVycm9yJTIwaW4lMjBhZGRfbmV3X3RhZyUzQSUyMCU3QnN0cihlKSU3RCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIyJUUyJTlEJThDJTIwRXJyb3IlMjB0eXBlJTNBJTIwJTdCdHlwZShlKSU3RCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbXBvcnQlMjB0cmFjZWJhY2slMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIyJUUyJTlEJThDJTIwVHJhY2ViYWNrJTNBJTIwJTdCdHJhY2ViYWNrLmZvcm1hdF9leGMoKSU3RCUyMiklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlcnJvcl9yZXN1bHQlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGF0dXMlMjIlM0ElMjAlMjJlcnJvciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlcG9faWQlMjIlM0ElMjByZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGFnJTIyJTNBJTIwbmV3X3RhZyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVycm9yJTIyJTNBJTIwc3RyKGUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwanNvbl9zdHIlMjAlM0QlMjBqc29uLmR1bXBzKGVycm9yX3Jlc3VsdCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIyJUUyJTlEJThDJTIwYWRkX25ld190YWclMjBlcnJvciUyMHJldHVybmluZyUzQSUyMCU3Qmpzb25fc3RyJTdEJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGpzb25fc3Ry",highlighted:`    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;❌ Error in add_new_tag: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;❌ Error type: <span class="hljs-subst">{<span class="hljs-built_in">type</span>(e)}</span>&quot;</span>)
        <span class="hljs-keyword">import</span> traceback
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;❌ Traceback: <span class="hljs-subst">{traceback.format_exc()}</span>&quot;</span>)

        error_result = {
            <span class="hljs-string">&quot;status&quot;</span>: <span class="hljs-string">&quot;error&quot;</span>,
            <span class="hljs-string">&quot;repo_id&quot;</span>: repo_id,
            <span class="hljs-string">&quot;tag&quot;</span>: new_tag,
            <span class="hljs-string">&quot;error&quot;</span>: <span class="hljs-built_in">str</span>(e),
        }
        json_str = json.dumps(error_result)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;❌ add_new_tag error returning: <span class="hljs-subst">{json_str}</span>&quot;</span>)
        <span class="hljs-keyword">return</span> json_str`,wrap:!1}}),_=new bl({props:{$$slots:{default:[Ns]},$$scope:{ctx:I}}}),hl=new Bl({props:{title:"Next Steps",local:"next-steps",headingTag:"h2"}}),E=new bl({props:{$$slots:{default:[qs]},$$scope:{ctx:I}}}),gl=new vs({props:{source:"https://github.com/huggingface/mcp-course/blob/main/units/en/unit3_1/creating-the-mcp-server.mdx"}}),{c(){n=i("meta"),J=a(),j=i("p"),o=a(),y(h.$$.fragment),d=a(),C=i("p"),C.textContent=kt,vl=a(),y(v.$$.fragment),Zl=a(),Z=i("p"),Z.textContent=Nt,$l=a(),$=i("table"),$.innerHTML=qt,Rl=a(),R=i("p"),R.textContent=Qt,Gl=a(),G=i("p"),G.innerHTML=Xt,kl=a(),y(k.$$.fragment),Nl=a(),N=i("p"),N.innerHTML=Ht,ql=a(),y(q.$$.fragment),Ql=a(),Q=i("p"),Q.textContent=Wt,Xl=a(),y(X.$$.fragment),Hl=a(),H=i("p"),H.innerHTML=Vt,Wl=a(),W=i("p"),W.innerHTML=St,Vl=a(),y(A.$$.fragment),Sl=a(),V=i("p"),V.textContent=xt,xl=a(),y(S.$$.fragment),Fl=a(),x=i("p"),x.textContent=Ft,Yl=a(),F=i("ol"),F.innerHTML=Yt,zl=a(),Y=i("p"),Y.innerHTML=zt,Pl=a(),y(z.$$.fragment),Ll=a(),P=i("p"),P.innerHTML=Pt,Kl=a(),y(L.$$.fragment),Dl=a(),K=i("p"),K.textContent=Lt,Ol=a(),y(f.$$.fragment),lt=a(),D=i("p"),D.innerHTML=Kt,tt=a(),y(O.$$.fragment),st=a(),ll=i("p"),ll.textContent=Dt,et=a(),tl=i("ol"),tl.innerHTML=Ot,nt=a(),y(g.$$.fragment),at=a(),y(sl.$$.fragment),Mt=a(),el=i("p"),el.innerHTML=ls,it=a(),y(nl.$$.fragment),pt=a(),al=i("p"),al.textContent=ts,jt=a(),y(Ml.$$.fragment),rt=a(),il=i("p"),il.innerHTML=ss,ot=a(),y(b.$$.fragment),Jt=a(),pl=i("p"),pl.textContent=es,yt=a(),y(jl.$$.fragment),Tt=a(),rl=i("p"),rl.textContent=ns,wt=a(),ol=i("p"),ol.innerHTML=as,ct=a(),Jl=i("p"),Jl.textContent=Ms,ut=a(),y(yl.$$.fragment),Ut=a(),Tl=i("p"),Tl.textContent=is,dt=a(),y(B.$$.fragment),It=a(),wl=i("p"),wl.textContent=ps,Ct=a(),y(cl.$$.fragment),ht=a(),ul=i("p"),ul.innerHTML=js,mt=a(),Ul=i("p"),Ul.textContent=rs,At=a(),y(dl.$$.fragment),ft=a(),Il=i("p"),Il.textContent=os,gt=a(),Cl=i("p"),Cl.textContent=Js,bt=a(),y(_.$$.fragment),Bt=a(),y(hl.$$.fragment),_t=a(),ml=i("p"),ml.textContent=ys,Et=a(),Al=i("ol"),Al.innerHTML=Ts,vt=a(),fl=i("p"),fl.textContent=ws,Zt=a(),y(E.$$.fragment),$t=a(),y(gl.$$.fragment),Rt=a(),El=i("p"),this.h()},l(l){const t=_s("svelte-u9bgzb",document.head);n=p(t,"META",{name:!0,content:!0}),t.forEach(s),J=M(l),j=p(l,"P",{}),ms(j).forEach(s),o=M(l),T(h.$$.fragment,l),d=M(l),C=p(l,"P",{"data-svelte-h":!0}),r(C)!=="svelte-uvjoow"&&(C.textContent=kt),vl=M(l),T(v.$$.fragment,l),Zl=M(l),Z=p(l,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-rspfcm"&&(Z.textContent=Nt),$l=M(l),$=p(l,"TABLE",{"data-svelte-h":!0}),r($)!=="svelte-1p7818e"&&($.innerHTML=qt),Rl=M(l),R=p(l,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1ca0hup"&&(R.textContent=Qt),Gl=M(l),G=p(l,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1fb34pj"&&(G.innerHTML=Xt),kl=M(l),T(k.$$.fragment,l),Nl=M(l),N=p(l,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1eluyaj"&&(N.innerHTML=Ht),ql=M(l),T(q.$$.fragment,l),Ql=M(l),Q=p(l,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-oahagw"&&(Q.textContent=Wt),Xl=M(l),T(X.$$.fragment,l),Hl=M(l),H=p(l,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1gu0b91"&&(H.innerHTML=Vt),Wl=M(l),W=p(l,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1bq6ctf"&&(W.innerHTML=St),Vl=M(l),T(A.$$.fragment,l),Sl=M(l),V=p(l,"P",{"data-svelte-h":!0}),r(V)!=="svelte-18ddhqu"&&(V.textContent=xt),xl=M(l),T(S.$$.fragment,l),Fl=M(l),x=p(l,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1l74eyb"&&(x.textContent=Ft),Yl=M(l),F=p(l,"OL",{"data-svelte-h":!0}),r(F)!=="svelte-g7kq79"&&(F.innerHTML=Yt),zl=M(l),Y=p(l,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1bebu4l"&&(Y.innerHTML=zt),Pl=M(l),T(z.$$.fragment,l),Ll=M(l),P=p(l,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1bxgraq"&&(P.innerHTML=Pt),Kl=M(l),T(L.$$.fragment,l),Dl=M(l),K=p(l,"P",{"data-svelte-h":!0}),r(K)!=="svelte-2sryu1"&&(K.textContent=Lt),Ol=M(l),T(f.$$.fragment,l),lt=M(l),D=p(l,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1i6wv7j"&&(D.innerHTML=Kt),tt=M(l),T(O.$$.fragment,l),st=M(l),ll=p(l,"P",{"data-svelte-h":!0}),r(ll)!=="svelte-1rirk6u"&&(ll.textContent=Dt),et=M(l),tl=p(l,"OL",{"data-svelte-h":!0}),r(tl)!=="svelte-11qcjr4"&&(tl.innerHTML=Ot),nt=M(l),T(g.$$.fragment,l),at=M(l),T(sl.$$.fragment,l),Mt=M(l),el=p(l,"P",{"data-svelte-h":!0}),r(el)!=="svelte-2o9hbl"&&(el.innerHTML=ls),it=M(l),T(nl.$$.fragment,l),pt=M(l),al=p(l,"P",{"data-svelte-h":!0}),r(al)!=="svelte-1ak2j0g"&&(al.textContent=ts),jt=M(l),T(Ml.$$.fragment,l),rt=M(l),il=p(l,"P",{"data-svelte-h":!0}),r(il)!=="svelte-1uivw0h"&&(il.innerHTML=ss),ot=M(l),T(b.$$.fragment,l),Jt=M(l),pl=p(l,"P",{"data-svelte-h":!0}),r(pl)!=="svelte-msey30"&&(pl.textContent=es),yt=M(l),T(jl.$$.fragment,l),Tt=M(l),rl=p(l,"P",{"data-svelte-h":!0}),r(rl)!=="svelte-1kdlnhk"&&(rl.textContent=ns),wt=M(l),ol=p(l,"P",{"data-svelte-h":!0}),r(ol)!=="svelte-10h6um9"&&(ol.innerHTML=as),ct=M(l),Jl=p(l,"P",{"data-svelte-h":!0}),r(Jl)!=="svelte-11alcrg"&&(Jl.textContent=Ms),ut=M(l),T(yl.$$.fragment,l),Ut=M(l),Tl=p(l,"P",{"data-svelte-h":!0}),r(Tl)!=="svelte-i1wizk"&&(Tl.textContent=is),dt=M(l),T(B.$$.fragment,l),It=M(l),wl=p(l,"P",{"data-svelte-h":!0}),r(wl)!=="svelte-1inz0c2"&&(wl.textContent=ps),Ct=M(l),T(cl.$$.fragment,l),ht=M(l),ul=p(l,"P",{"data-svelte-h":!0}),r(ul)!=="svelte-1h6ylhu"&&(ul.innerHTML=js),mt=M(l),Ul=p(l,"P",{"data-svelte-h":!0}),r(Ul)!=="svelte-4necmz"&&(Ul.textContent=rs),At=M(l),T(dl.$$.fragment,l),ft=M(l),Il=p(l,"P",{"data-svelte-h":!0}),r(Il)!=="svelte-936lbc"&&(Il.textContent=os),gt=M(l),Cl=p(l,"P",{"data-svelte-h":!0}),r(Cl)!=="svelte-12xaqb8"&&(Cl.textContent=Js),bt=M(l),T(_.$$.fragment,l),Bt=M(l),T(hl.$$.fragment,l),_t=M(l),ml=p(l,"P",{"data-svelte-h":!0}),r(ml)!=="svelte-14cp6w2"&&(ml.textContent=ys),Et=M(l),Al=p(l,"OL",{"data-svelte-h":!0}),r(Al)!=="svelte-1vffloe"&&(Al.innerHTML=Ts),vt=M(l),fl=p(l,"P",{"data-svelte-h":!0}),r(fl)!=="svelte-lcr1e1"&&(fl.textContent=ws),Zt=M(l),T(E.$$.fragment,l),$t=M(l),T(gl.$$.fragment,l),Rt=M(l),El=p(l,"P",{}),ms(El).forEach(s),this.h()},h(){As(n,"name","hf:doc:metadata"),As(n,"content",Xs)},m(l,t){Es(document.head,n),e(l,J,t),e(l,j,t),e(l,o,t),w(h,l,t),e(l,d,t),e(l,C,t),e(l,vl,t),w(v,l,t),e(l,Zl,t),e(l,Z,t),e(l,$l,t),e(l,$,t),e(l,Rl,t),e(l,R,t),e(l,Gl,t),e(l,G,t),e(l,kl,t),w(k,l,t),e(l,Nl,t),e(l,N,t),e(l,ql,t),w(q,l,t),e(l,Ql,t),e(l,Q,t),e(l,Xl,t),w(X,l,t),e(l,Hl,t),e(l,H,t),e(l,Wl,t),e(l,W,t),e(l,Vl,t),w(A,l,t),e(l,Sl,t),e(l,V,t),e(l,xl,t),w(S,l,t),e(l,Fl,t),e(l,x,t),e(l,Yl,t),e(l,F,t),e(l,zl,t),e(l,Y,t),e(l,Pl,t),w(z,l,t),e(l,Ll,t),e(l,P,t),e(l,Kl,t),w(L,l,t),e(l,Dl,t),e(l,K,t),e(l,Ol,t),w(f,l,t),e(l,lt,t),e(l,D,t),e(l,tt,t),w(O,l,t),e(l,st,t),e(l,ll,t),e(l,et,t),e(l,tl,t),e(l,nt,t),w(g,l,t),e(l,at,t),w(sl,l,t),e(l,Mt,t),e(l,el,t),e(l,it,t),w(nl,l,t),e(l,pt,t),e(l,al,t),e(l,jt,t),w(Ml,l,t),e(l,rt,t),e(l,il,t),e(l,ot,t),w(b,l,t),e(l,Jt,t),e(l,pl,t),e(l,yt,t),w(jl,l,t),e(l,Tt,t),e(l,rl,t),e(l,wt,t),e(l,ol,t),e(l,ct,t),e(l,Jl,t),e(l,ut,t),w(yl,l,t),e(l,Ut,t),e(l,Tl,t),e(l,dt,t),w(B,l,t),e(l,It,t),e(l,wl,t),e(l,Ct,t),w(cl,l,t),e(l,ht,t),e(l,ul,t),e(l,mt,t),e(l,Ul,t),e(l,At,t),w(dl,l,t),e(l,ft,t),e(l,Il,t),e(l,gt,t),e(l,Cl,t),e(l,bt,t),w(_,l,t),e(l,Bt,t),w(hl,l,t),e(l,_t,t),e(l,ml,t),e(l,Et,t),e(l,Al,t),e(l,vt,t),e(l,fl,t),e(l,Zt,t),w(E,l,t),e(l,$t,t),w(gl,l,t),e(l,Rt,t),e(l,El,t),Gt=!0},p(l,[t]){const cs={};t&2&&(cs.$$scope={dirty:t,ctx:l}),A.$set(cs);const us={};t&2&&(us.$$scope={dirty:t,ctx:l}),f.$set(us);const Us={};t&2&&(Us.$$scope={dirty:t,ctx:l}),g.$set(Us);const ds={};t&2&&(ds.$$scope={dirty:t,ctx:l}),b.$set(ds);const Is={};t&2&&(Is.$$scope={dirty:t,ctx:l}),B.$set(Is);const Cs={};t&2&&(Cs.$$scope={dirty:t,ctx:l}),_.$set(Cs);const hs={};t&2&&(hs.$$scope={dirty:t,ctx:l}),E.$set(hs)},i(l){Gt||(c(h.$$.fragment,l),c(v.$$.fragment,l),c(k.$$.fragment,l),c(q.$$.fragment,l),c(X.$$.fragment,l),c(A.$$.fragment,l),c(S.$$.fragment,l),c(z.$$.fragment,l),c(L.$$.fragment,l),c(f.$$.fragment,l),c(O.$$.fragment,l),c(g.$$.fragment,l),c(sl.$$.fragment,l),c(nl.$$.fragment,l),c(Ml.$$.fragment,l),c(b.$$.fragment,l),c(jl.$$.fragment,l),c(yl.$$.fragment,l),c(B.$$.fragment,l),c(cl.$$.fragment,l),c(dl.$$.fragment,l),c(_.$$.fragment,l),c(hl.$$.fragment,l),c(E.$$.fragment,l),c(gl.$$.fragment,l),Gt=!0)},o(l){u(h.$$.fragment,l),u(v.$$.fragment,l),u(k.$$.fragment,l),u(q.$$.fragment,l),u(X.$$.fragment,l),u(A.$$.fragment,l),u(S.$$.fragment,l),u(z.$$.fragment,l),u(L.$$.fragment,l),u(f.$$.fragment,l),u(O.$$.fragment,l),u(g.$$.fragment,l),u(sl.$$.fragment,l),u(nl.$$.fragment,l),u(Ml.$$.fragment,l),u(b.$$.fragment,l),u(jl.$$.fragment,l),u(yl.$$.fragment,l),u(B.$$.fragment,l),u(cl.$$.fragment,l),u(dl.$$.fragment,l),u(_.$$.fragment,l),u(hl.$$.fragment,l),u(E.$$.fragment,l),u(gl.$$.fragment,l),Gt=!1},d(l){l&&(s(J),s(j),s(o),s(d),s(C),s(vl),s(Zl),s(Z),s($l),s($),s(Rl),s(R),s(Gl),s(G),s(kl),s(Nl),s(N),s(ql),s(Ql),s(Q),s(Xl),s(Hl),s(H),s(Wl),s(W),s(Vl),s(Sl),s(V),s(xl),s(Fl),s(x),s(Yl),s(F),s(zl),s(Y),s(Pl),s(Ll),s(P),s(Kl),s(Dl),s(K),s(Ol),s(lt),s(D),s(tt),s(st),s(ll),s(et),s(tl),s(nt),s(at),s(Mt),s(el),s(it),s(pt),s(al),s(jt),s(rt),s(il),s(ot),s(Jt),s(pl),s(yt),s(Tt),s(rl),s(wt),s(ol),s(ct),s(Jl),s(ut),s(Ut),s(Tl),s(dt),s(It),s(wl),s(Ct),s(ht),s(ul),s(mt),s(Ul),s(At),s(ft),s(Il),s(gt),s(Cl),s(bt),s(Bt),s(_t),s(ml),s(Et),s(Al),s(vt),s(fl),s(Zt),s($t),s(Rt),s(El)),s(n),U(h,l),U(v,l),U(k,l),U(q,l),U(X,l),U(A,l),U(S,l),U(z,l),U(L,l),U(f,l),U(O,l),U(g,l),U(sl,l),U(nl,l),U(Ml,l),U(b,l),U(jl,l),U(yl,l),U(B,l),U(cl,l),U(dl,l),U(_,l),U(hl,l),U(E,l),U(gl,l)}}}const Xs='{"title":"Creating the MCP Server","local":"creating-the-mcp-server","sections":[{"title":"Understanding the MCP Server Architecture","local":"understanding-the-mcp-server-architecture","sections":[],"depth":2},{"title":"Complete MCP Server Implementation","local":"complete-mcp-server-implementation","sections":[{"title":"1. Imports and Configuration","local":"1-imports-and-configuration","sections":[],"depth":3},{"title":"2. Get Current Tags Tool","local":"2-get-current-tags-tool","sections":[],"depth":3},{"title":"3. Add New Tag Tool","local":"3-add-new-tag-tool","sections":[],"depth":3}],"depth":2},{"title":"Next Steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Hs(I){return gs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ys extends bs{constructor(n){super(),Bs(this,n,Hs,Qs,fs,{})}}export{Ys as component};
