import{s as Zs,o as Cs,n as yl}from"../chunks/scheduler.c57aa7ef.js";import{S as Us,i as Ls,g as i,s,r as p,A as Ws,h as o,f as a,c as n,j as ks,u as d,x as r,k as Js,y as Bs,a as l,v as m,d as f,t as h,w as u}from"../chunks/index.394f8801.js";import{T as gl}from"../chunks/Tip.23dfb1a9.js";import{C as w}from"../chunks/CodeBlock.b5488637.js";import{H as y,E as Fs}from"../chunks/getInferenceSnippets.06058b63.js";function Gs(T){let c,b='Starting from PEFT version v0.12.0, PEFT automatically promotes the dtype of adapter weights from <code>torch.float16</code> and <code>torch.bfloat16</code> to <code>torch.float32</code> where appropriate. To <em>prevent</em> this behavior, you can pass <code>autocast_adapter_dtype=False</code> to <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">~get_peft_model()</a>, to <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.from_pretrained">from_pretrained()</a>, and to <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.load_adapter">load_adapter()</a>.';return{c(){c=i("p"),c.innerHTML=b},l(g){c=o(g,"P",{"data-svelte-h":!0}),r(c)!=="svelte-10wrxii"&&(c.innerHTML=b)},m(g,M){l(g,c,M)},p:yl,d(g){g&&a(c)}}}function Is(T){let c,b="As an example, when loading a model that is using the DeBERTa architecture for sequence classification, you’ll see a warning that the following weights are newly initialized: <code>[&#39;classifier.bias&#39;, &#39;classifier.weight&#39;, &#39;pooler.dense.bias&#39;, &#39;pooler.dense.weight&#39;]</code>. From this, it follows that the <code>classifier</code> and <code>pooler</code> layers should be added to: <code>modules_to_save=[&quot;classifier&quot;, &quot;pooler&quot;]</code>.";return{c(){c=i("p"),c.innerHTML=b},l(g){c=o(g,"P",{"data-svelte-h":!0}),r(c)!=="svelte-1r4u1vb"&&(c.innerHTML=b)},m(g,M){l(g,c,M)},p:yl,d(g){g&&a(c)}}}function Rs(T){let c,b="If this option works well across different use cases, it may become the default for adapter loading in the future.";return{c(){c=i("p"),c.textContent=b},l(g){c=o(g,"P",{"data-svelte-h":!0}),r(c)!=="svelte-18nkf7o"&&(c.textContent=b)},m(g,M){l(g,c,M)},p:yl,d(g){g&&a(c)}}}function Hs(T){let c,b,g,M,x,bt,j,wl="If you encounter any issue when using PEFT, please check the following list of common issues and their solutions.",Mt,k,Tt,J,bl="Examples often rely on the most recent package versions, so please ensure they’re up-to-date. In particular, check the following package versions:",_t,Z,Ml="<li><code>peft</code></li> <li><code>transformers</code></li> <li><code>accelerate</code></li> <li><code>torch</code></li>",$t,C,Tl="In general, you can update the package version by running this command inside your Python environment:",vt,U,xt,L,_l="Installing PEFT from source is useful for keeping up with the latest developments:",jt,W,kt,B,Jt,F,Zt,G,$l='This error probably occurred because the model was loaded with <code>torch_dtype=torch.float16</code> and then used in an automatic mixed precision (AMP) context, e.g. by setting <code>fp16=True</code> in the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> class from 🤗 Transformers. The reason is that when using AMP, trainable weights should never use fp16. To make this work without loading the whole model in fp32, add the following to your code:',Ct,I,Ut,R,vl='Alternatively, you can use the <a href="/docs/peft/main/en/package_reference/peft_model#peft.cast_mixed_precision_params">cast_mixed_precision_params()</a> function to correctly cast the weights:',Lt,H,Wt,_,Bt,X,Ft,V,xl="Most PEFT methods, like LoRA, work by adding trainable adapter weights. By default, those weights are stored in float32 dtype (fp32), i.e. at a relatively high precision. Therefore, even if the base model is loaded in float16 (fp16) or bfloat16 (bf16), the adapter weights are float32. When the adapter results are calculated during the forward pass, the input will typically be in the dtype of the base model, thus it will be upcast to float32 if necessary, then cast back to the original dtype.",Gt,E,jl='If you prefer to have the adapter weights in the lower precision of the base model, i.e. in float16 or bfloat16, you can pass <code>autocast_adapter_dtype=False</code> when creating the model (<a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">~get_peft_model()</a>) or loading the model (<a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.from_pretrained">from_pretrained()</a>). There are some advantages and disadvantages to this:',It,P,kl="Advantages of half precision adapter:",Rt,z,Jl="<li>computation slightly faster</li> <li>slightly less memory</li> <li>smaller file size of checkpoint (half the size)</li>",Ht,Y,Zl="Disadvantages of half precision adapter:",Xt,q,Cl="<li>slightly worse loss</li> <li>higher risk of overflow or underflow</li>",Vt,N,Ul="Note that for most use cases, overall runtime and memory cost will be determined by the size of the base model and by the dataset, while the dtype of the PEFT adapter will only have a small impact.",Et,Q,Pt,S,Ll='There can be several reasons for getting a poor result from a loaded PEFT model which are listed below. If you’re still unable to troubleshoot the problem, see if anyone else had a similar <a href="https://github.com/huggingface/peft/issues" rel="nofollow">issue</a> on GitHub, and if you can’t find any, open a new issue.',zt,A,Wl="When opening an issue, it helps a lot if you provide a minimal code example that reproduces the issue. Also, please report if the loaded model performs at the same level as the model did before fine-tuning, if it performs at a random level, or if it is only slightly worse than expected. This information helps us identify the problem more quickly.",Yt,D,qt,K,Bl="If your model outputs are not exactly the same as previous runs, there could be an issue with random elements. For example:",Nt,O,Fl='<li>please ensure it is in <code>.eval()</code> mode, which is important, for instance, if the model uses dropout</li> <li>if you use <a href="https://huggingface.co/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate" rel="nofollow">generate</a> on a language model, there could be random sampling, so obtaining the same result requires setting a random seed</li> <li>if you used quantization and merged the weights, small deviations are expected due to rounding errors</li>',Qt,ee,St,te,Gl='Please ensure that you load the model correctly. A common error is trying to load a <em>trained</em> model with <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> which is incorrect. Instead, the loading code should look like this:',At,ae,Dt,le,Kt,se,Il="For some tasks, it is important to correctly configure <code>modules_to_save</code> in the config to account for randomly initialized layers.",Ot,ne,Rl="As an example, this is necessary if you use LoRA to fine-tune a language model for sequence classification because 🤗 Transformers adds a randomly initialized classification head on top of the model. If you do not add this layer to <code>modules_to_save</code>, the classification head won’t be saved. The next time you load the model, you’ll get a <em>different</em> randomly initialized classification head, resulting in completely different results.",ea,ie,Hl="PEFT tries to correctly guess the <code>modules_to_save</code> if you provide the <code>task_type</code> argument in the config. This should work for transformers models that follow the standard naming scheme. It is always a good idea to double check though because we can’t guarantee all models follow the naming scheme.",ta,oe,Xl="When you load a transformers model that has randomly initialized layers, you should see a warning along the lines of:",aa,re,la,pe,Vl="The mentioned layers should be added to <code>modules_to_save</code> in the config to avoid the described problem.",sa,$,na,de,ia,me,El="For many language fine-tuning tasks, extending the model’s vocabulary is necessary since new tokens are being introduced. This requires extending the embedding layer to account for the new tokens and, depending on the fine-tuning method, also storing the embedding layer in addition to the adapter weights when saving the adapter. There are a few ways of achieving this ordered by parameter effectiveness:",oa,fe,Pl='<li><a href="../package_reference/trainable_tokens">trainable tokens</a>, train only the specified tokens, optionally store only the updated values</li> <li>training an adapter on the embedding matrix, optionally store only the updated values</li> <li>full-finetuning of the embedding layer</li>',ra,he,pa,ue,zl='Let’s start with trainable tokens, in this case its <a href="../developer_guides/lora#efficiently-train-tokens-alongside-lora">LoRA integration</a>.  If you’re interested in only training the new embeddings and nothing else, refer to the <a href="../package_reference/trainable_tokens">standalone documentation</a>.',da,ce,Yl="To enable selective token training of the embedding layer, you’ll need to supply the token ids of your newly added tokens via the <code>trainable_token_indices</code> parameter.  Optionally you can specify which layer to target if there is more than one embedding layer. For a Mistral model this could look like this:",ma,ge,fa,ye,ql="If your model uses tied weights (such as the <code>lm_head</code>), trainable tokens will try to resolve those and keep them updated as well, so in that case there should be no need for adding <code>modules_to_save=[&quot;lm_head&quot;]</code>. This only works if the model uses the Transformers convention for tying weights.",ha,we,Nl=`Saving the model with <code>model.save_pretrained</code> may save the full embedding matrix instead of
only the difference as a precaution because the embedding matrix was resized. To save space you can disable this behavior by setting <code>save_embedding_layers=False</code> when calling <code>save_pretrained</code>. This is safe to do as long as you don’t modify the embedding matrix through other means as well, as such changes will be not tracked by trainable tokens.`,ua,be,ca,Me,Ql="Prepare the embedding layer by adding it to the <code>target_modules</code> of your adapter config. For example, the Mistral config could look like this:",ga,Te,ya,_e,Sl="Once added to <code>target_modules</code>, PEFT automatically stores the embedding layer when saving the adapter if the model has the <code>get_input_embeddings</code> and <code>get_output_embeddings</code>. This is generally the case for Transformers models.",wa,$e,Al="If the model’s embedding layer doesn’t follow the Transformer’s naming scheme but nevertheless implements <code>get_input_embeddings</code>, you can still save it by manually passing <code>save_embedding_layers=True</code> when saving the adapter:",ba,ve,Ma,xe,Dl="For inference, load the base model first and resize it the same way you did before you trained the model. After you’ve resized the base model, you can load the PEFT checkpoint.",Ta,je,Kl='For a complete example, please check out <a href="https://github.com/huggingface/peft/blob/main/examples/causal_language_modeling/peft_lora_clm_with_additional_tokens.ipynb" rel="nofollow">this notebook</a>.',_a,ke,$a,Je,Ol="Full fine-tuning is more costly in terms of VRAM or storage space but if all else fails, you can fall back to this and see if it works for you. Achieve it by adding the name of the embedding layer to <code>modules_to_save</code>. Note that you need to add tied layers as well, e.g. <code>lm_head</code>. Example for a Mistral model with LoRA:",va,Ze,xa,Ce,ja,Ue,es="When you load your PEFT model which has been trained on a task (for example, classification), you may get a warning like:",ka,Le,ts="<p>Some weights of LlamaForSequenceClassification were not initialized from the model checkpoint at meta-llama/Llama-3.2-1B and are newly initialized: [‘score.weight’]. You should probably TRAIN this model on a down-stream task to be able to use it for predictions and inference.</p>",Ja,We,as="Although this looks scary, it is most likely nothing to worry about. This warning comes from Transformers, and it isn’t a PEFT specific warning. It lets you know that a randomly initialized classification head (<code>score</code>) is attached to the base model, and the head must be trained to produce sensible predictions.",Za,Be,ls="When you get this warning <em>before</em> training the model, PEFT automatically takes care of making the classification head trainable if you correctly passed the <code>task_type</code> argument to the PEFT config.",Ca,Fe,Ua,Ge,ss="If your classification head does not follow the usual naming conventions from Transformers (which is rare), you have to explicitly tell PEFT the name of the head in <code>modules_to_save</code>.",La,Ie,Wa,Re,ns="To check the name of the classification head, print the model and it should be the last module.",Ba,He,is="If you get this warning from your inference code, i.e. <em>after</em> training the model, when you load the PEFT model, you always have to load the Transformers model first. Since Transformers does not know that you will load PEFT weights afterwards, it still gives the warning.",Fa,Xe,os="As always, it is best practice to ensure the model works correctly for inference by running some validation on it.",Ga,Ve,Ia,Ee,rs='Sometimes a PEFT model can end up in a bad state, especially when handling multiple adapters. There can be some confusion around what adapters exist, which one is active, which one is merged, etc. To help investigate this issue, call the <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.get_layer_status">get_layer_status()</a> and the <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.get_model_status">get_model_status()</a> methods.',Ra,Pe,ps='The <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.get_layer_status">get_layer_status()</a> method gives you a detailed overview of each targeted layer’s active, merged, and available adapters.',Ha,ze,Xa,Ye,ds="In the model state output, you should look out for entries that say <code>&quot;irregular&quot;</code>. This means PEFT detected an inconsistent state in the model. For instance, if <code>merged_adapters=&quot;irregular&quot;</code>, it means that for at least one adapter, it was merged on some target modules but not on others. The inference results will most likely be incorrect as a result.",Va,qe,ms="The best way to resolve this issue is to reload the whole model and adapter checkpoint(s). Ensure that you don’t perform any incorrect operations on the model, e.g. manually merging adapters on some modules but not others.",Ea,Ne,fs="Convert the layer status into a pandas <code>DataFrame</code> for an easier visual inspection.",Pa,Qe,za,Se,hs='It is possible to get this information for non-PEFT models if they are using PEFT layers under the hood, but some information like the <code>base_model_type</code> or the <code>peft_types</code> cannot be determined in that case. As an example, you can call this on a <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">diffusers</a> model like so:',Ya,Ae,qa,De,Na,Ke,Qa,Oe,us='Loading adapters like LoRA weights should generally be fast compared to loading the base model. However, there can be use cases where the adapter weights are quite large or where users need to load a large number of adapters — the loading time can add up in this case. The reason for this is that the adapter weights are first initialized and then overridden by the loaded weights, which is wasteful. To speed up the loading time, you can pass the <code>low_cpu_mem_usage=True</code> argument to <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.from_pretrained">from_pretrained()</a> and <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.load_adapter">load_adapter()</a>.',Sa,v,Aa,et,Da,tt,Ka,at,cs="When loading a trained PEFT model where the base model uses batch norm (e.g. <code>torch.nn.BatchNorm1d</code> or <code>torch.nn.BatchNorm2d</code>), you may find that you cannot reproduce the exact same outputs. This is because the batch norm layers keep track of running stats during training, but these stats are not part of the PEFT checkpoint. Therefore, when you load the PEFT model, the running stats of the base model will be used (i.e. from before training with PEFT).",Oa,lt,gs="Depending on your use case, this may not be a big deal. If, however, you need your outputs to be 100% reproducible, you can achieve this by adding the batch norm layers to <code>modules_to_save</code>. Below is an example of this using resnet and LoRA. Notice that we set <code>modules_to_save=[&quot;classifier&quot;, &quot;normalization&quot;]</code>. We need the <code>&quot;classifier&quot;</code> argument because our task is image classification, and we add the <code>&quot;normalization&quot;</code> argument to ensure that the batch norm layers are saved in the PEFT checkpoint.",el,st,tl,nt,ys="Depending on the type of model you use, the batch norm layers could have different names than <code>&quot;normalization&quot;</code>, so please ensure that the name matches your model architecture.",al,it,ll,ot,sl,rt,ws="When you encounter an error like the one shown below, it means the adapter you’re trying to load was trained with a more recent version of PEFT than the version you have installed on your system.",nl,pt,il,dt,bs="The best way to resolve this issue is to install the latest PEFT version:",ol,mt,rl,ft,Ms="If the adapter was trained from a source install of PEFT (an unreleased version of PEFT), then you also need to install PEFT from source.",pl,ht,dl,ut,Ts="If it is not possible for you to upgrade PEFT, there is a workaround you can try.",ml,ct,_s="Assume the error message says that the unknown keyword argument is named <code>foobar</code>. Search inside the <code>adapter_config.json</code> of this PEFT adapter for the <code>foobar</code> entry and delete it from the file. Then save the file and try loading the model again.",fl,gt,$s="This solution works most of the time. As long as it is the default value for <code>foobar</code>, it can be ignored. However, when it is set to some other value, you will get incorrect results. Upgrading PEFT is the recommended solution.",hl,yt,ul,wt,cl;return x=new y({props:{title:"Troubleshooting",local:"troubleshooting",headingTag:"h1"}}),k=new y({props:{title:"Examples don’t work",local:"examples-dont-work",headingTag:"h2"}}),U=new w({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwLVUlMjAlM0NwYWNrYWdlX25hbWUlM0U=",highlighted:"python -m pip install -U &lt;package_name&gt;",wrap:!1}}),W=new w({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwZ2l0JTJCaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZwZWZ0",highlighted:"python -m pip install git+https://github.com/huggingface/peft",wrap:!1}}),B=new y({props:{title:"Dtype-related issues",local:"dtype-related-issues",headingTag:"h2"}}),F=new y({props:{title:"ValueError: Attempting to unscale FP16 gradients",local:"valueerror-attempting-to-unscale-fp16-gradients",headingTag:"h3"}}),I=new w({props:{code:"cGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKC4uLiklMEElMEElMjMlMjBhZGQlMjB0aGlzJTNBJTBBZm9yJTIwcGFyYW0lMjBpbiUyMG1vZGVsLnBhcmFtZXRlcnMoKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwcGFyYW0ucmVxdWlyZXNfZ3JhZCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhcmFtLmRhdGElMjAlM0QlMjBwYXJhbS5kYXRhLmZsb2F0KCklMEElMEElMjMlMjBwcm9jZWVkJTIwYXMlMjB1c3VhbCUwQXRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKG1vZGVsJTNEcGVmdF9tb2RlbCUyQyUyMGZwMTYlM0RUcnVlJTJDJTIwLi4uKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`peft_model = get_peft_model(...)

<span class="hljs-comment"># add this:</span>
<span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> model.parameters():
    <span class="hljs-keyword">if</span> param.requires_grad:
        param.data = param.data.<span class="hljs-built_in">float</span>()

<span class="hljs-comment"># proceed as usual</span>
trainer = Trainer(model=peft_model, fp16=<span class="hljs-literal">True</span>, ...)
trainer.train()`,wrap:!1}}),H=new w({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBjYXN0X21peGVkX3ByZWNpc2lvbl9wYXJhbXMlMEElMEFwZWZ0X21vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwoLi4uKSUwQWNhc3RfbWl4ZWRfcHJlY2lzaW9uX3BhcmFtcyhwZWZ0X21vZGVsJTJDJTIwZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQSUwQSUyMyUyMHByb2NlZWQlMjBhcyUyMHVzdWFsJTBBdHJhaW5lciUyMCUzRCUyMFRyYWluZXIobW9kZWwlM0RwZWZ0X21vZGVsJTJDJTIwZnAxNiUzRFRydWUlMkMlMjAuLi4pJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> cast_mixed_precision_params

peft_model = get_peft_model(...)
cast_mixed_precision_params(peft_model, dtype=torch.float16)

<span class="hljs-comment"># proceed as usual</span>
trainer = Trainer(model=peft_model, fp16=<span class="hljs-literal">True</span>, ...)
trainer.train()`,wrap:!1}}),_=new gl({props:{$$slots:{default:[Gs]},$$scope:{ctx:T}}}),X=new y({props:{title:"Selecting the dtype of the adapter",local:"selecting-the-dtype-of-the-adapter",headingTag:"h3"}}),Q=new y({props:{title:"Bad results from a loaded PEFT model",local:"bad-results-from-a-loaded-peft-model",headingTag:"h2"}}),D=new y({props:{title:"Random deviations",local:"random-deviations",headingTag:"h3"}}),ee=new y({props:{title:"Incorrectly loaded model",local:"incorrectly-loaded-model",headingTag:"h3"}}),ae=new w({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMkMlMjBQZWZ0Q29uZmlnJTBBJTBBYmFzZV9tb2RlbCUyMCUzRCUyMC4uLiUyMCUyMCUyMyUyMHRvJTIwbG9hZCUyMHRoZSUyMGJhc2UlMjBtb2RlbCUyQyUyMHVzZSUyMHRoZSUyMHNhbWUlMjBjb2RlJTIwYXMlMjB3aGVuJTIweW91JTIwdHJhaW5lZCUyMGl0JTBBY29uZmlnJTIwJTNEJTIwUGVmdENvbmZpZy5mcm9tX3ByZXRyYWluZWQocGVmdF9tb2RlbF9pZCklMEFwZWZ0X21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel, PeftConfig

base_model = ...  <span class="hljs-comment"># to load the base model, use the same code as when you trained it</span>
config = PeftConfig.from_pretrained(peft_model_id)
peft_model = PeftModel.from_pretrained(base_model, peft_model_id)`,wrap:!1}}),le=new y({props:{title:"Randomly initialized layers",local:"randomly-initialized-layers",headingTag:"h3"}}),re=new w({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMCUzQ01PREVMJTNFJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwJTNDSUQlM0UlMjBhbmQlMjBhcmUlMjBuZXdseSUyMGluaXRpYWxpemVkJTNBJTIwJTVCJTNDTEFZRVJfTkFNRVMlM0UlNUQuJTBBWW91JTIwc2hvdWxkJTIwcHJvYmFibHklMjBUUkFJTiUyMHRoaXMlMjBtb2RlbCUyMG9uJTIwYSUyMGRvd24tc3RyZWFtJTIwdGFzayUyMHRvJTIwYmUlMjBhYmxlJTIwdG8lMjB1c2UlMjBpdCUyMGZvciUyMHByZWRpY3Rpb25zJTIwYW5kJTIwaW5mZXJlbmNlLg==",highlighted:`<span class="hljs-keyword">Some</span> weights <span class="hljs-keyword">of</span> &lt;MODEL&gt; were <span class="hljs-keyword">not</span> initialized <span class="hljs-keyword">from</span> the model <span class="hljs-keyword">checkpoint</span> at &lt;ID&gt; <span class="hljs-keyword">and</span> are newly initialized: [&lt;LAYER_NAMES&gt;].
You should probably TRAIN this model <span class="hljs-keyword">on</span> a down-stream task <span class="hljs-keyword">to</span> be able <span class="hljs-keyword">to</span> use it <span class="hljs-keyword">for</span> predictions <span class="hljs-keyword">and</span> inference.`,wrap:!1}}),$=new gl({props:{$$slots:{default:[Is]},$$scope:{ctx:T}}}),de=new y({props:{title:"Extending the vocabulary",local:"extending-the-vocabulary",headingTag:"h3"}}),he=new y({props:{title:"Using trainable tokens",local:"using-trainable-tokens",headingTag:"h4"}}),ge=new w({props:{code:"bmV3X3Rva2VucyUyMCUzRCUyMCU1QiclM0N0aGluayUzRSclMkMlMjAnJTNDJTJGdGhpbmslM0UnJTVEJTBBdG9rZW5pemVyLmFkZF90b2tlbnMobmV3X3Rva2VucyklMEFiYXNlX21vZGVsLnJlc2l6ZV90b2tlbl9lbWJlZGRpbmdzKGxlbih0b2tlbml6ZXIpKSUwQSUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjB0cmFpbmFibGVfdG9rZW5faW5kaWNlcyUzRCU3QidlbWJlZF90b2tlbnMnJTNBJTIwdG9rZW5pemVyLmNvbnZlcnRfdG9rZW5zX3RvX2lkcyhuZXdfdG9rZW5zKSU3RCUyQyUwQSk=",highlighted:`new_tokens = [<span class="hljs-string">&#x27;&lt;think&gt;&#x27;</span>, <span class="hljs-string">&#x27;&lt;/think&gt;&#x27;</span>]
tokenizer.add_tokens(new_tokens)
base_model.resize_token_embeddings(<span class="hljs-built_in">len</span>(tokenizer))

lora_config = LoraConfig(
    ...,
    trainable_token_indices={<span class="hljs-string">&#x27;embed_tokens&#x27;</span>: tokenizer.convert_tokens_to_ids(new_tokens)},
)`,wrap:!1}}),be=new y({props:{title:"Using an adapter, e.g. LoRA",local:"using-an-adapter-eg-lora",headingTag:"h4"}}),Te=new w({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyguLi4lMkMlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMmVtYmVkX3Rva2VucyUyMiUyQyUyMCUyMmxtX2hlYWQlMjIlMkMlMjAlMjJxX3Byb2olMjIlMkMlMjAlMjJ2X3Byb2olMjIlNUQp",highlighted:'config = LoraConfig(..., target_modules=[<span class="hljs-string">&quot;embed_tokens&quot;</span>, <span class="hljs-string">&quot;lm_head&quot;</span>, <span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>])',wrap:!1}}),ve=new w({props:{code:"bW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbCguLi4pJTBBJTIzJTIwdHJhaW4lMjB0aGUlMjBtb2RlbCUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJteV9hZGFwdGVyJTIyJTJDJTIwc2F2ZV9lbWJlZGRpbmdfbGF5ZXJzJTNEVHJ1ZSk=",highlighted:`model = get_peft_model(...)
<span class="hljs-comment"># train the model</span>
model.save_pretrained(<span class="hljs-string">&quot;my_adapter&quot;</span>, save_embedding_layers=<span class="hljs-literal">True</span>)`,wrap:!1}}),ke=new y({props:{title:"Full fine-tuning",local:"full-fine-tuning",headingTag:"h4"}}),Ze=new w({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyguLi4lMkMlMjBtb2R1bGVzX3RvX3NhdmUlM0QlNUIlMjJlbWJlZF90b2tlbnMlMjIlMkMlMjAlMjJsbV9oZWFkJTIyJTVEJTJDJTIwdGFyZ2V0X21vZHVsZXMlM0QlNUIlMjJxX3Byb2olMjIlMkMlMjAlMjJ2X3Byb2olMjIlNUQp",highlighted:'config = LoraConfig(..., modules_to_save=[<span class="hljs-string">&quot;embed_tokens&quot;</span>, <span class="hljs-string">&quot;lm_head&quot;</span>], target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>])',wrap:!1}}),Ce=new y({props:{title:"Getting a warning about “weights not being initialized from the model checkpoint”",local:"getting-a-warning-about-weights-not-being-initialized-from-the-model-checkpoint",headingTag:"h3"}}),Fe=new w({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwVGFza1R5cGUlMEElMEFsb3JhX2NvbmZpZyUyMCUzRCUyMExvcmFDb25maWcoLi4uJTJDJTIwdGFza190eXBlJTNEVGFza1R5cGUuU0VRX0NMUyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, TaskType

lora_config = LoraConfig(..., task_type=TaskType.SEQ_CLS)`,wrap:!1}}),Ie=new w({props:{code:"bG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiUyQyUyMG1vZHVsZXNfdG9fc2F2ZSUzRCU1QiUyMm5hbWUtb2YtY2xhc3NpZmljYXRpb24taGVhZCUyMiU1RCk=",highlighted:'lora_config = LoraConfig(..., modules_to_save=[<span class="hljs-string">&quot;name-of-classification-head&quot;</span>])',wrap:!1}}),Ve=new y({props:{title:"Check layer and model status",local:"check-layer-and-model-status",headingTag:"h3"}}),ze=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwZ2V0X3BlZnRfbW9kZWwlMkMlMjBMb3JhQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJnb29nbGUlMkZmbGFuLXQ1LXNtYWxsJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBMb3JhQ29uZmlnKCkpJTBBJTBBbW9kZWwuZ2V0X2xheWVyX3N0YXR1cygpJTBBJTBBbW9kZWwuZ2V0X21vZGVsX3N0YXR1cygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model, LoraConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;google/flan-t5-small&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = get_peft_model(model, LoraConfig())

<span class="hljs-meta">&gt;&gt;&gt; </span>model.get_layer_status()
[TunerLayerStatus(name=<span class="hljs-string">&#x27;model.encoder.block.0.layer.0.SelfAttention.q&#x27;</span>,
                  module_type=<span class="hljs-string">&#x27;lora.Linear&#x27;</span>,
                  enabled=<span class="hljs-literal">True</span>,
                  active_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>],
                  merged_adapters=[],
                  requires_grad={<span class="hljs-string">&#x27;default&#x27;</span>: <span class="hljs-literal">True</span>},
                  available_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>]),
 TunerLayerStatus(name=<span class="hljs-string">&#x27;model.encoder.block.0.layer.0.SelfAttention.v&#x27;</span>,
                  module_type=<span class="hljs-string">&#x27;lora.Linear&#x27;</span>,
                  enabled=<span class="hljs-literal">True</span>,
                  active_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>],
                  merged_adapters=[],
                  requires_grad={<span class="hljs-string">&#x27;default&#x27;</span>: <span class="hljs-literal">True</span>},
                  available_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>]),
...]

<span class="hljs-meta">&gt;&gt;&gt; </span>model.get_model_status()
TunerModelStatus(
    base_model_type=<span class="hljs-string">&#x27;T5Model&#x27;</span>,
    adapter_model_type=<span class="hljs-string">&#x27;LoraModel&#x27;</span>,
    peft_types={<span class="hljs-string">&#x27;default&#x27;</span>: <span class="hljs-string">&#x27;LORA&#x27;</span>},
    trainable_params=<span class="hljs-number">344064</span>,
    total_params=<span class="hljs-number">60855680</span>,
    num_adapter_layers=<span class="hljs-number">48</span>,
    enabled=<span class="hljs-literal">True</span>,
    active_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>],
    merged_adapters=[],
    requires_grad={<span class="hljs-string">&#x27;default&#x27;</span>: <span class="hljs-literal">True</span>},
    available_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>],
)`,wrap:!1}}),Qe=new w({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwYXNkaWN0JTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQWRmJTIwJTNEJTIwcGQuRGF0YUZyYW1lKGFzZGljdChsYXllciklMjBmb3IlMjBsYXllciUyMGluJTIwbW9kZWwuZ2V0X2xheWVyX3N0YXR1cygpKQ==",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> asdict
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

df = pd.DataFrame(asdict(layer) <span class="hljs-keyword">for</span> layer <span class="hljs-keyword">in</span> model.get_layer_status())`,wrap:!1}}),Ae=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMGdldF9tb2RlbF9zdGF0dXMlMkMlMjBnZXRfbGF5ZXJfc3RhdHVzJTBBJTBBcGF0aCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBbG9yYV9pZCUyMCUzRCUyMCUyMnRha3VtYTEwNCUyRmxvcmEtdGVzdC10ZXh0LWVuY29kZXItbG9yYS10YXJnZXQlMjIlMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHBhdGglMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZS5sb2FkX2xvcmFfd2VpZ2h0cyhsb3JhX2lkJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyYWRhcHRlci0xJTIyKSUwQXBpcGUubG9hZF9sb3JhX3dlaWdodHMobG9yYV9pZCUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmFkYXB0ZXItMiUyMiklMEFwaXBlLnNldF9sb3JhX2RldmljZSglNUIlMjJhZGFwdGVyLTIlMjIlNUQlMkMlMjAlMjJjdWRhJTIyKSUwQWdldF9sYXllcl9zdGF0dXMocGlwZS50ZXh0X2VuY29kZXIpJTBBJTBBZ2V0X21vZGVsX3N0YXR1cyhwaXBlLnVuZXQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_model_status, get_layer_status

<span class="hljs-meta">&gt;&gt;&gt; </span>path = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>lora_id = <span class="hljs-string">&quot;takuma104/lora-test-text-encoder-lora-target&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(path, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.load_lora_weights(lora_id, adapter_name=<span class="hljs-string">&quot;adapter-1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.load_lora_weights(lora_id, adapter_name=<span class="hljs-string">&quot;adapter-2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.set_lora_device([<span class="hljs-string">&quot;adapter-2&quot;</span>], <span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>get_layer_status(pipe.text_encoder)
[TunerLayerStatus(name=<span class="hljs-string">&#x27;text_model.encoder.layers.0.self_attn.k_proj&#x27;</span>,
                  module_type=<span class="hljs-string">&#x27;lora.Linear&#x27;</span>,
                  enabled=<span class="hljs-literal">True</span>,
                  active_adapters=[<span class="hljs-string">&#x27;adapter-2&#x27;</span>],
                  merged_adapters=[],
                  requires_grad={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: <span class="hljs-literal">False</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>: <span class="hljs-literal">True</span>},
                  available_adapters=[<span class="hljs-string">&#x27;adapter-1&#x27;</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>],
                  devices={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: [<span class="hljs-string">&#x27;cpu&#x27;</span>], <span class="hljs-string">&#x27;adapter-2&#x27;</span>: [<span class="hljs-string">&#x27;cuda&#x27;</span>]}),
 TunerLayerStatus(name=<span class="hljs-string">&#x27;text_model.encoder.layers.0.self_attn.v_proj&#x27;</span>,
                  module_type=<span class="hljs-string">&#x27;lora.Linear&#x27;</span>,
                  enabled=<span class="hljs-literal">True</span>,
                  active_adapters=[<span class="hljs-string">&#x27;adapter-2&#x27;</span>],
                  merged_adapters=[],
                  requires_grad={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: <span class="hljs-literal">False</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>: <span class="hljs-literal">True</span>},
                  devices={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: [<span class="hljs-string">&#x27;cpu&#x27;</span>], <span class="hljs-string">&#x27;adapter-2&#x27;</span>: [<span class="hljs-string">&#x27;cuda&#x27;</span>]}),
...]

<span class="hljs-meta">&gt;&gt;&gt; </span>get_model_status(pipe.unet)
TunerModelStatus(
    base_model_type=<span class="hljs-string">&#x27;other&#x27;</span>,
    adapter_model_type=<span class="hljs-string">&#x27;None&#x27;</span>,
    peft_types={},
    trainable_params=<span class="hljs-number">797184</span>,
    total_params=<span class="hljs-number">861115332</span>,
    num_adapter_layers=<span class="hljs-number">128</span>,
    enabled=<span class="hljs-literal">True</span>,
    active_adapters=[<span class="hljs-string">&#x27;adapter-2&#x27;</span>],
    merged_adapters=[],
    requires_grad={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: <span class="hljs-literal">False</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>: <span class="hljs-literal">True</span>},
    available_adapters=[<span class="hljs-string">&#x27;adapter-1&#x27;</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>],
    devices={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: [<span class="hljs-string">&#x27;cpu&#x27;</span>], <span class="hljs-string">&#x27;adapter-2&#x27;</span>: [<span class="hljs-string">&#x27;cuda&#x27;</span>]},
)`,wrap:!1}}),De=new y({props:{title:"Speed",local:"speed",headingTag:"h2"}}),Ke=new y({props:{title:"Loading adapter weights is slow",local:"loading-adapter-weights-is-slow",headingTag:"h3"}}),v=new gl({props:{$$slots:{default:[Rs]},$$scope:{ctx:T}}}),et=new y({props:{title:"Reproducibility",local:"reproducibility",headingTag:"h2"}}),tt=new y({props:{title:"Models using batch norm",local:"models-using-batch-norm",headingTag:"h3"}}),st=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMExvcmFDb25maWclMkMlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIybWljcm9zb2Z0JTJGcmVzbmV0LTE4JTIyJTBBYmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKHNlbGYubW9kZWxfaWQpJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMmNvbnZvbHV0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kdWxlc190b19zYXZlJTNEJTVCJTIyY2xhc3NpZmllciUyMiUyQyUyMCUyMm5vcm1hbGl6YXRpb24lMjIlNUQlMkMlMEEpJTJD",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

model_id = <span class="hljs-string">&quot;microsoft/resnet-18&quot;</span>
base_model = AutoModelForImageClassification.from_pretrained(self.model_id)
config = LoraConfig(
    target_modules=[<span class="hljs-string">&quot;convolution&quot;</span>],
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>, <span class="hljs-string">&quot;normalization&quot;</span>],
),`,wrap:!1}}),it=new y({props:{title:"Version mismatch",local:"version-mismatch",headingTag:"h2"}}),ot=new y({props:{title:"Error while loading the config because of an unexpected keyword argument",local:"error-while-loading-the-config-because-of-an-unexpected-keyword-argument",headingTag:"h3"}}),pt=new w({props:{code:"VHlwZUVycm9yJTNBJTIwTG9yYUNvbmZpZy5fX2luaXRfXygpJTIwZ290JTIwYW4lMjB1bmV4cGVjdGVkJTIwa2V5d29yZCUyMGFyZ3VtZW50JTIwJTNDYXJndW1lbnQtbmFtZSUzRQ==",highlighted:'TypeError: LoraConfig.__init__() got an unexpected keyword <span class="hljs-variable language_">argument</span> &lt;<span class="hljs-variable language_">argument</span>-name&gt;',wrap:!1}}),mt=new w({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwLVUlMjBQRUZU",highlighted:"python -m pip install -U PEFT",wrap:!1}}),ht=new w({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwLVUlMjBnaXQlMkJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRnBlZnQuZ2l0",highlighted:"python -m pip install -U git+https://github.com/huggingface/peft.git",wrap:!1}}),yt=new Fs({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/troubleshooting.md"}}),{c(){c=i("meta"),b=s(),g=i("p"),M=s(),p(x.$$.fragment),bt=s(),j=i("p"),j.textContent=wl,Mt=s(),p(k.$$.fragment),Tt=s(),J=i("p"),J.textContent=bl,_t=s(),Z=i("ul"),Z.innerHTML=Ml,$t=s(),C=i("p"),C.textContent=Tl,vt=s(),p(U.$$.fragment),xt=s(),L=i("p"),L.textContent=_l,jt=s(),p(W.$$.fragment),kt=s(),p(B.$$.fragment),Jt=s(),p(F.$$.fragment),Zt=s(),G=i("p"),G.innerHTML=$l,Ct=s(),p(I.$$.fragment),Ut=s(),R=i("p"),R.innerHTML=vl,Lt=s(),p(H.$$.fragment),Wt=s(),p(_.$$.fragment),Bt=s(),p(X.$$.fragment),Ft=s(),V=i("p"),V.textContent=xl,Gt=s(),E=i("p"),E.innerHTML=jl,It=s(),P=i("p"),P.textContent=kl,Rt=s(),z=i("ul"),z.innerHTML=Jl,Ht=s(),Y=i("p"),Y.textContent=Zl,Xt=s(),q=i("ul"),q.innerHTML=Cl,Vt=s(),N=i("p"),N.textContent=Ul,Et=s(),p(Q.$$.fragment),Pt=s(),S=i("p"),S.innerHTML=Ll,zt=s(),A=i("p"),A.textContent=Wl,Yt=s(),p(D.$$.fragment),qt=s(),K=i("p"),K.textContent=Bl,Nt=s(),O=i("ol"),O.innerHTML=Fl,Qt=s(),p(ee.$$.fragment),St=s(),te=i("p"),te.innerHTML=Gl,At=s(),p(ae.$$.fragment),Dt=s(),p(le.$$.fragment),Kt=s(),se=i("p"),se.innerHTML=Il,Ot=s(),ne=i("p"),ne.innerHTML=Rl,ea=s(),ie=i("p"),ie.innerHTML=Hl,ta=s(),oe=i("p"),oe.textContent=Xl,aa=s(),p(re.$$.fragment),la=s(),pe=i("p"),pe.innerHTML=Vl,sa=s(),p($.$$.fragment),na=s(),p(de.$$.fragment),ia=s(),me=i("p"),me.textContent=El,oa=s(),fe=i("ul"),fe.innerHTML=Pl,ra=s(),p(he.$$.fragment),pa=s(),ue=i("p"),ue.innerHTML=zl,da=s(),ce=i("p"),ce.innerHTML=Yl,ma=s(),p(ge.$$.fragment),fa=s(),ye=i("p"),ye.innerHTML=ql,ha=s(),we=i("p"),we.innerHTML=Nl,ua=s(),p(be.$$.fragment),ca=s(),Me=i("p"),Me.innerHTML=Ql,ga=s(),p(Te.$$.fragment),ya=s(),_e=i("p"),_e.innerHTML=Sl,wa=s(),$e=i("p"),$e.innerHTML=Al,ba=s(),p(ve.$$.fragment),Ma=s(),xe=i("p"),xe.textContent=Dl,Ta=s(),je=i("p"),je.innerHTML=Kl,_a=s(),p(ke.$$.fragment),$a=s(),Je=i("p"),Je.innerHTML=Ol,va=s(),p(Ze.$$.fragment),xa=s(),p(Ce.$$.fragment),ja=s(),Ue=i("p"),Ue.textContent=es,ka=s(),Le=i("blockquote"),Le.innerHTML=ts,Ja=s(),We=i("p"),We.innerHTML=as,Za=s(),Be=i("p"),Be.innerHTML=ls,Ca=s(),p(Fe.$$.fragment),Ua=s(),Ge=i("p"),Ge.innerHTML=ss,La=s(),p(Ie.$$.fragment),Wa=s(),Re=i("p"),Re.textContent=ns,Ba=s(),He=i("p"),He.innerHTML=is,Fa=s(),Xe=i("p"),Xe.textContent=os,Ga=s(),p(Ve.$$.fragment),Ia=s(),Ee=i("p"),Ee.innerHTML=rs,Ra=s(),Pe=i("p"),Pe.innerHTML=ps,Ha=s(),p(ze.$$.fragment),Xa=s(),Ye=i("p"),Ye.innerHTML=ds,Va=s(),qe=i("p"),qe.textContent=ms,Ea=s(),Ne=i("p"),Ne.innerHTML=fs,Pa=s(),p(Qe.$$.fragment),za=s(),Se=i("p"),Se.innerHTML=hs,Ya=s(),p(Ae.$$.fragment),qa=s(),p(De.$$.fragment),Na=s(),p(Ke.$$.fragment),Qa=s(),Oe=i("p"),Oe.innerHTML=us,Sa=s(),p(v.$$.fragment),Aa=s(),p(et.$$.fragment),Da=s(),p(tt.$$.fragment),Ka=s(),at=i("p"),at.innerHTML=cs,Oa=s(),lt=i("p"),lt.innerHTML=gs,el=s(),p(st.$$.fragment),tl=s(),nt=i("p"),nt.innerHTML=ys,al=s(),p(it.$$.fragment),ll=s(),p(ot.$$.fragment),sl=s(),rt=i("p"),rt.textContent=ws,nl=s(),p(pt.$$.fragment),il=s(),dt=i("p"),dt.textContent=bs,ol=s(),p(mt.$$.fragment),rl=s(),ft=i("p"),ft.textContent=Ms,pl=s(),p(ht.$$.fragment),dl=s(),ut=i("p"),ut.textContent=Ts,ml=s(),ct=i("p"),ct.innerHTML=_s,fl=s(),gt=i("p"),gt.innerHTML=$s,hl=s(),p(yt.$$.fragment),ul=s(),wt=i("p"),this.h()},l(e){const t=Ws("svelte-u9bgzb",document.head);c=o(t,"META",{name:!0,content:!0}),t.forEach(a),b=n(e),g=o(e,"P",{}),ks(g).forEach(a),M=n(e),d(x.$$.fragment,e),bt=n(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-wwms7a"&&(j.textContent=wl),Mt=n(e),d(k.$$.fragment,e),Tt=n(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-18nlz3r"&&(J.textContent=bl),_t=n(e),Z=o(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-ccv654"&&(Z.innerHTML=Ml),$t=n(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1cuqjyb"&&(C.textContent=Tl),vt=n(e),d(U.$$.fragment,e),xt=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-h5ykrw"&&(L.textContent=_l),jt=n(e),d(W.$$.fragment,e),kt=n(e),d(B.$$.fragment,e),Jt=n(e),d(F.$$.fragment,e),Zt=n(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-oa0e54"&&(G.innerHTML=$l),Ct=n(e),d(I.$$.fragment,e),Ut=n(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-p7trz1"&&(R.innerHTML=vl),Lt=n(e),d(H.$$.fragment,e),Wt=n(e),d(_.$$.fragment,e),Bt=n(e),d(X.$$.fragment,e),Ft=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1w3ww7i"&&(V.textContent=xl),Gt=n(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-wkpq53"&&(E.innerHTML=jl),It=n(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-3n96y7"&&(P.textContent=kl),Rt=n(e),z=o(e,"UL",{"data-svelte-h":!0}),r(z)!=="svelte-1ghjkcl"&&(z.innerHTML=Jl),Ht=n(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1yqgo19"&&(Y.textContent=Zl),Xt=n(e),q=o(e,"UL",{"data-svelte-h":!0}),r(q)!=="svelte-pdypmd"&&(q.innerHTML=Cl),Vt=n(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1gmj2pd"&&(N.textContent=Ul),Et=n(e),d(Q.$$.fragment,e),Pt=n(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-ns8zue"&&(S.innerHTML=Ll),zt=n(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-lfc2ft"&&(A.textContent=Wl),Yt=n(e),d(D.$$.fragment,e),qt=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-16feh"&&(K.textContent=Bl),Nt=n(e),O=o(e,"OL",{"data-svelte-h":!0}),r(O)!=="svelte-1fvhlks"&&(O.innerHTML=Fl),Qt=n(e),d(ee.$$.fragment,e),St=n(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-q1qqrd"&&(te.innerHTML=Gl),At=n(e),d(ae.$$.fragment,e),Dt=n(e),d(le.$$.fragment,e),Kt=n(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-5heszj"&&(se.innerHTML=Il),Ot=n(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-c4824l"&&(ne.innerHTML=Rl),ea=n(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1ou3c35"&&(ie.innerHTML=Hl),ta=n(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1g4txs2"&&(oe.textContent=Xl),aa=n(e),d(re.$$.fragment,e),la=n(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1fbeum6"&&(pe.innerHTML=Vl),sa=n(e),d($.$$.fragment,e),na=n(e),d(de.$$.fragment,e),ia=n(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1ftgm9w"&&(me.textContent=El),oa=n(e),fe=o(e,"UL",{"data-svelte-h":!0}),r(fe)!=="svelte-1cu50cp"&&(fe.innerHTML=Pl),ra=n(e),d(he.$$.fragment,e),pa=n(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-p4bcqv"&&(ue.innerHTML=zl),da=n(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-ffklcx"&&(ce.innerHTML=Yl),ma=n(e),d(ge.$$.fragment,e),fa=n(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-12n0r5k"&&(ye.innerHTML=ql),ha=n(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1r5fwm9"&&(we.innerHTML=Nl),ua=n(e),d(be.$$.fragment,e),ca=n(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1bq6qvj"&&(Me.innerHTML=Ql),ga=n(e),d(Te.$$.fragment,e),ya=n(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1lr155g"&&(_e.innerHTML=Sl),wa=n(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1kaw5hl"&&($e.innerHTML=Al),ba=n(e),d(ve.$$.fragment,e),Ma=n(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-nkv7o7"&&(xe.textContent=Dl),Ta=n(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-a0ibfa"&&(je.innerHTML=Kl),_a=n(e),d(ke.$$.fragment,e),$a=n(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-u2918x"&&(Je.innerHTML=Ol),va=n(e),d(Ze.$$.fragment,e),xa=n(e),d(Ce.$$.fragment,e),ja=n(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-q2uzbp"&&(Ue.textContent=es),ka=n(e),Le=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(Le)!=="svelte-ray7nl"&&(Le.innerHTML=ts),Ja=n(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1cejahg"&&(We.innerHTML=as),Za=n(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-m24cow"&&(Be.innerHTML=ls),Ca=n(e),d(Fe.$$.fragment,e),Ua=n(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1c6v178"&&(Ge.innerHTML=ss),La=n(e),d(Ie.$$.fragment,e),Wa=n(e),Re=o(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-f59lgd"&&(Re.textContent=ns),Ba=n(e),He=o(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-k7fvy1"&&(He.innerHTML=is),Fa=n(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-16spx00"&&(Xe.textContent=os),Ga=n(e),d(Ve.$$.fragment,e),Ia=n(e),Ee=o(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-1f0hxdh"&&(Ee.innerHTML=rs),Ra=n(e),Pe=o(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-1ygf8mz"&&(Pe.innerHTML=ps),Ha=n(e),d(ze.$$.fragment,e),Xa=n(e),Ye=o(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-1gb1r7d"&&(Ye.innerHTML=ds),Va=n(e),qe=o(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-19sfzdf"&&(qe.textContent=ms),Ea=n(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-18r4lni"&&(Ne.innerHTML=fs),Pa=n(e),d(Qe.$$.fragment,e),za=n(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-17rnlhh"&&(Se.innerHTML=hs),Ya=n(e),d(Ae.$$.fragment,e),qa=n(e),d(De.$$.fragment,e),Na=n(e),d(Ke.$$.fragment,e),Qa=n(e),Oe=o(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-1hc62kc"&&(Oe.innerHTML=us),Sa=n(e),d(v.$$.fragment,e),Aa=n(e),d(et.$$.fragment,e),Da=n(e),d(tt.$$.fragment,e),Ka=n(e),at=o(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-yt67c7"&&(at.innerHTML=cs),Oa=n(e),lt=o(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-wblxho"&&(lt.innerHTML=gs),el=n(e),d(st.$$.fragment,e),tl=n(e),nt=o(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-1e3stb1"&&(nt.innerHTML=ys),al=n(e),d(it.$$.fragment,e),ll=n(e),d(ot.$$.fragment,e),sl=n(e),rt=o(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-5zz36e"&&(rt.textContent=ws),nl=n(e),d(pt.$$.fragment,e),il=n(e),dt=o(e,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-1dqw1qx"&&(dt.textContent=bs),ol=n(e),d(mt.$$.fragment,e),rl=n(e),ft=o(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-1k207nl"&&(ft.textContent=Ms),pl=n(e),d(ht.$$.fragment,e),dl=n(e),ut=o(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-1jt6x31"&&(ut.textContent=Ts),ml=n(e),ct=o(e,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-1a81pzz"&&(ct.innerHTML=_s),fl=n(e),gt=o(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-1wt4m5g"&&(gt.innerHTML=$s),hl=n(e),d(yt.$$.fragment,e),ul=n(e),wt=o(e,"P",{}),ks(wt).forEach(a),this.h()},h(){Js(c,"name","hf:doc:metadata"),Js(c,"content",Xs)},m(e,t){Bs(document.head,c),l(e,b,t),l(e,g,t),l(e,M,t),m(x,e,t),l(e,bt,t),l(e,j,t),l(e,Mt,t),m(k,e,t),l(e,Tt,t),l(e,J,t),l(e,_t,t),l(e,Z,t),l(e,$t,t),l(e,C,t),l(e,vt,t),m(U,e,t),l(e,xt,t),l(e,L,t),l(e,jt,t),m(W,e,t),l(e,kt,t),m(B,e,t),l(e,Jt,t),m(F,e,t),l(e,Zt,t),l(e,G,t),l(e,Ct,t),m(I,e,t),l(e,Ut,t),l(e,R,t),l(e,Lt,t),m(H,e,t),l(e,Wt,t),m(_,e,t),l(e,Bt,t),m(X,e,t),l(e,Ft,t),l(e,V,t),l(e,Gt,t),l(e,E,t),l(e,It,t),l(e,P,t),l(e,Rt,t),l(e,z,t),l(e,Ht,t),l(e,Y,t),l(e,Xt,t),l(e,q,t),l(e,Vt,t),l(e,N,t),l(e,Et,t),m(Q,e,t),l(e,Pt,t),l(e,S,t),l(e,zt,t),l(e,A,t),l(e,Yt,t),m(D,e,t),l(e,qt,t),l(e,K,t),l(e,Nt,t),l(e,O,t),l(e,Qt,t),m(ee,e,t),l(e,St,t),l(e,te,t),l(e,At,t),m(ae,e,t),l(e,Dt,t),m(le,e,t),l(e,Kt,t),l(e,se,t),l(e,Ot,t),l(e,ne,t),l(e,ea,t),l(e,ie,t),l(e,ta,t),l(e,oe,t),l(e,aa,t),m(re,e,t),l(e,la,t),l(e,pe,t),l(e,sa,t),m($,e,t),l(e,na,t),m(de,e,t),l(e,ia,t),l(e,me,t),l(e,oa,t),l(e,fe,t),l(e,ra,t),m(he,e,t),l(e,pa,t),l(e,ue,t),l(e,da,t),l(e,ce,t),l(e,ma,t),m(ge,e,t),l(e,fa,t),l(e,ye,t),l(e,ha,t),l(e,we,t),l(e,ua,t),m(be,e,t),l(e,ca,t),l(e,Me,t),l(e,ga,t),m(Te,e,t),l(e,ya,t),l(e,_e,t),l(e,wa,t),l(e,$e,t),l(e,ba,t),m(ve,e,t),l(e,Ma,t),l(e,xe,t),l(e,Ta,t),l(e,je,t),l(e,_a,t),m(ke,e,t),l(e,$a,t),l(e,Je,t),l(e,va,t),m(Ze,e,t),l(e,xa,t),m(Ce,e,t),l(e,ja,t),l(e,Ue,t),l(e,ka,t),l(e,Le,t),l(e,Ja,t),l(e,We,t),l(e,Za,t),l(e,Be,t),l(e,Ca,t),m(Fe,e,t),l(e,Ua,t),l(e,Ge,t),l(e,La,t),m(Ie,e,t),l(e,Wa,t),l(e,Re,t),l(e,Ba,t),l(e,He,t),l(e,Fa,t),l(e,Xe,t),l(e,Ga,t),m(Ve,e,t),l(e,Ia,t),l(e,Ee,t),l(e,Ra,t),l(e,Pe,t),l(e,Ha,t),m(ze,e,t),l(e,Xa,t),l(e,Ye,t),l(e,Va,t),l(e,qe,t),l(e,Ea,t),l(e,Ne,t),l(e,Pa,t),m(Qe,e,t),l(e,za,t),l(e,Se,t),l(e,Ya,t),m(Ae,e,t),l(e,qa,t),m(De,e,t),l(e,Na,t),m(Ke,e,t),l(e,Qa,t),l(e,Oe,t),l(e,Sa,t),m(v,e,t),l(e,Aa,t),m(et,e,t),l(e,Da,t),m(tt,e,t),l(e,Ka,t),l(e,at,t),l(e,Oa,t),l(e,lt,t),l(e,el,t),m(st,e,t),l(e,tl,t),l(e,nt,t),l(e,al,t),m(it,e,t),l(e,ll,t),m(ot,e,t),l(e,sl,t),l(e,rt,t),l(e,nl,t),m(pt,e,t),l(e,il,t),l(e,dt,t),l(e,ol,t),m(mt,e,t),l(e,rl,t),l(e,ft,t),l(e,pl,t),m(ht,e,t),l(e,dl,t),l(e,ut,t),l(e,ml,t),l(e,ct,t),l(e,fl,t),l(e,gt,t),l(e,hl,t),m(yt,e,t),l(e,ul,t),l(e,wt,t),cl=!0},p(e,[t]){const vs={};t&2&&(vs.$$scope={dirty:t,ctx:e}),_.$set(vs);const xs={};t&2&&(xs.$$scope={dirty:t,ctx:e}),$.$set(xs);const js={};t&2&&(js.$$scope={dirty:t,ctx:e}),v.$set(js)},i(e){cl||(f(x.$$.fragment,e),f(k.$$.fragment,e),f(U.$$.fragment,e),f(W.$$.fragment,e),f(B.$$.fragment,e),f(F.$$.fragment,e),f(I.$$.fragment,e),f(H.$$.fragment,e),f(_.$$.fragment,e),f(X.$$.fragment,e),f(Q.$$.fragment,e),f(D.$$.fragment,e),f(ee.$$.fragment,e),f(ae.$$.fragment,e),f(le.$$.fragment,e),f(re.$$.fragment,e),f($.$$.fragment,e),f(de.$$.fragment,e),f(he.$$.fragment,e),f(ge.$$.fragment,e),f(be.$$.fragment,e),f(Te.$$.fragment,e),f(ve.$$.fragment,e),f(ke.$$.fragment,e),f(Ze.$$.fragment,e),f(Ce.$$.fragment,e),f(Fe.$$.fragment,e),f(Ie.$$.fragment,e),f(Ve.$$.fragment,e),f(ze.$$.fragment,e),f(Qe.$$.fragment,e),f(Ae.$$.fragment,e),f(De.$$.fragment,e),f(Ke.$$.fragment,e),f(v.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(st.$$.fragment,e),f(it.$$.fragment,e),f(ot.$$.fragment,e),f(pt.$$.fragment,e),f(mt.$$.fragment,e),f(ht.$$.fragment,e),f(yt.$$.fragment,e),cl=!0)},o(e){h(x.$$.fragment,e),h(k.$$.fragment,e),h(U.$$.fragment,e),h(W.$$.fragment,e),h(B.$$.fragment,e),h(F.$$.fragment,e),h(I.$$.fragment,e),h(H.$$.fragment,e),h(_.$$.fragment,e),h(X.$$.fragment,e),h(Q.$$.fragment,e),h(D.$$.fragment,e),h(ee.$$.fragment,e),h(ae.$$.fragment,e),h(le.$$.fragment,e),h(re.$$.fragment,e),h($.$$.fragment,e),h(de.$$.fragment,e),h(he.$$.fragment,e),h(ge.$$.fragment,e),h(be.$$.fragment,e),h(Te.$$.fragment,e),h(ve.$$.fragment,e),h(ke.$$.fragment,e),h(Ze.$$.fragment,e),h(Ce.$$.fragment,e),h(Fe.$$.fragment,e),h(Ie.$$.fragment,e),h(Ve.$$.fragment,e),h(ze.$$.fragment,e),h(Qe.$$.fragment,e),h(Ae.$$.fragment,e),h(De.$$.fragment,e),h(Ke.$$.fragment,e),h(v.$$.fragment,e),h(et.$$.fragment,e),h(tt.$$.fragment,e),h(st.$$.fragment,e),h(it.$$.fragment,e),h(ot.$$.fragment,e),h(pt.$$.fragment,e),h(mt.$$.fragment,e),h(ht.$$.fragment,e),h(yt.$$.fragment,e),cl=!1},d(e){e&&(a(b),a(g),a(M),a(bt),a(j),a(Mt),a(Tt),a(J),a(_t),a(Z),a($t),a(C),a(vt),a(xt),a(L),a(jt),a(kt),a(Jt),a(Zt),a(G),a(Ct),a(Ut),a(R),a(Lt),a(Wt),a(Bt),a(Ft),a(V),a(Gt),a(E),a(It),a(P),a(Rt),a(z),a(Ht),a(Y),a(Xt),a(q),a(Vt),a(N),a(Et),a(Pt),a(S),a(zt),a(A),a(Yt),a(qt),a(K),a(Nt),a(O),a(Qt),a(St),a(te),a(At),a(Dt),a(Kt),a(se),a(Ot),a(ne),a(ea),a(ie),a(ta),a(oe),a(aa),a(la),a(pe),a(sa),a(na),a(ia),a(me),a(oa),a(fe),a(ra),a(pa),a(ue),a(da),a(ce),a(ma),a(fa),a(ye),a(ha),a(we),a(ua),a(ca),a(Me),a(ga),a(ya),a(_e),a(wa),a($e),a(ba),a(Ma),a(xe),a(Ta),a(je),a(_a),a($a),a(Je),a(va),a(xa),a(ja),a(Ue),a(ka),a(Le),a(Ja),a(We),a(Za),a(Be),a(Ca),a(Ua),a(Ge),a(La),a(Wa),a(Re),a(Ba),a(He),a(Fa),a(Xe),a(Ga),a(Ia),a(Ee),a(Ra),a(Pe),a(Ha),a(Xa),a(Ye),a(Va),a(qe),a(Ea),a(Ne),a(Pa),a(za),a(Se),a(Ya),a(qa),a(Na),a(Qa),a(Oe),a(Sa),a(Aa),a(Da),a(Ka),a(at),a(Oa),a(lt),a(el),a(tl),a(nt),a(al),a(ll),a(sl),a(rt),a(nl),a(il),a(dt),a(ol),a(rl),a(ft),a(pl),a(dl),a(ut),a(ml),a(ct),a(fl),a(gt),a(hl),a(ul),a(wt)),a(c),u(x,e),u(k,e),u(U,e),u(W,e),u(B,e),u(F,e),u(I,e),u(H,e),u(_,e),u(X,e),u(Q,e),u(D,e),u(ee,e),u(ae,e),u(le,e),u(re,e),u($,e),u(de,e),u(he,e),u(ge,e),u(be,e),u(Te,e),u(ve,e),u(ke,e),u(Ze,e),u(Ce,e),u(Fe,e),u(Ie,e),u(Ve,e),u(ze,e),u(Qe,e),u(Ae,e),u(De,e),u(Ke,e),u(v,e),u(et,e),u(tt,e),u(st,e),u(it,e),u(ot,e),u(pt,e),u(mt,e),u(ht,e),u(yt,e)}}}const Xs='{"title":"Troubleshooting","local":"troubleshooting","sections":[{"title":"Examples don’t work","local":"examples-dont-work","sections":[],"depth":2},{"title":"Dtype-related issues","local":"dtype-related-issues","sections":[{"title":"ValueError: Attempting to unscale FP16 gradients","local":"valueerror-attempting-to-unscale-fp16-gradients","sections":[],"depth":3},{"title":"Selecting the dtype of the adapter","local":"selecting-the-dtype-of-the-adapter","sections":[],"depth":3}],"depth":2},{"title":"Bad results from a loaded PEFT model","local":"bad-results-from-a-loaded-peft-model","sections":[{"title":"Random deviations","local":"random-deviations","sections":[],"depth":3},{"title":"Incorrectly loaded model","local":"incorrectly-loaded-model","sections":[],"depth":3},{"title":"Randomly initialized layers","local":"randomly-initialized-layers","sections":[],"depth":3},{"title":"Extending the vocabulary","local":"extending-the-vocabulary","sections":[{"title":"Using trainable tokens","local":"using-trainable-tokens","sections":[],"depth":4},{"title":"Using an adapter, e.g. LoRA","local":"using-an-adapter-eg-lora","sections":[],"depth":4},{"title":"Full fine-tuning","local":"full-fine-tuning","sections":[],"depth":4}],"depth":3},{"title":"Getting a warning about “weights not being initialized from the model checkpoint”","local":"getting-a-warning-about-weights-not-being-initialized-from-the-model-checkpoint","sections":[],"depth":3},{"title":"Check layer and model status","local":"check-layer-and-model-status","sections":[],"depth":3}],"depth":2},{"title":"Speed","local":"speed","sections":[{"title":"Loading adapter weights is slow","local":"loading-adapter-weights-is-slow","sections":[],"depth":3}],"depth":2},{"title":"Reproducibility","local":"reproducibility","sections":[{"title":"Models using batch norm","local":"models-using-batch-norm","sections":[],"depth":3}],"depth":2},{"title":"Version mismatch","local":"version-mismatch","sections":[{"title":"Error while loading the config because of an unexpected keyword argument","local":"error-while-loading-the-config-because-of-an-unexpected-keyword-argument","sections":[],"depth":3}],"depth":2}],"depth":1}';function Vs(T){return Cs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ns extends Us{constructor(c){super(),Ls(this,c,Vs,Hs,Zs,{})}}export{Ns as component};
