import{s as kt,o as Ft,n as $t}from"../chunks/scheduler.c57aa7ef.js";import{S as Rt,i as Wt,g as d,s as l,r as g,A as It,h as m,f as a,c as o,j as pt,u as y,x as u,k as rt,y as i,a as s,v as b,d as T,t as J,w as _}from"../chunks/index.394f8801.js";import{D as Bt}from"../chunks/Docstring.658fa394.js";import{C as gt}from"../chunks/CodeBlock.b5488637.js";import{E as xt}from"../chunks/ExampleCodeBlock.9876687a.js";import{H as dt,E as Vt}from"../chunks/getInferenceSnippets.06058b63.js";function Xt(N){let p,G="Example:",j,w,f;return w=new gt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMFBlZnRNb2RlbCUwQWZyb20lMjBwZWZ0LnV0aWxzLmhvdHN3YXAlMjBpbXBvcnQlMjBob3Rzd2FwX2FkYXB0ZXIlMEElMEFtb2RlbF9pZCUyMCUzRCUyMC4uLiUwQWlucHV0cyUyMCUzRCUyMC4uLiUwQWRldmljZSUyMCUzRCUyMC4uLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKS50byhkZXZpY2UpJTBBJTBBJTIzJTIwbG9hZCUyMGxvcmElMjAwJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKG1vZGVsJTJDJTIwJTIycGF0aC1hZGFwdGVyLTAlMjIpJTBBbW9kZWwlMjAlM0QlMjB0b3JjaC5jb21waWxlKG1vZGVsKSUyMCUyMCUyMyUyMG9wdGlvbmFsbHklMjBjb21waWxlJTIwdGhlJTIwbW9kZWwlMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dF9hZGFwdGVyXzAlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBJTBBJTIzJTIwcmVwbGFjZSUyMHRoZSUyMCUyMmRlZmF1bHQlMjIlMjBsb3JhJTIwYWRhcHRlciUyMHdpdGglMjB0aGUlMjBuZXclMjBvbmUlMEFob3Rzd2FwX2FkYXB0ZXIobW9kZWwlMkMlMjAlMjJwYXRoLWFkYXB0ZXItMSUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmRlZmF1bHQlMjIlMkMlMjB0b3JjaF9kZXZpY2UlM0RkZXZpY2UpJTBBd2l0aCUyMHRvcmNoLmluZmVyZW5jZV9tb2RlKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRfYWRhcHRlcl8xJTIwJTNEJTIwbW9kZWwoaW5wdXRzKS5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> peft.utils.hotswap <span class="hljs-keyword">import</span> hotswap_adapter

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = ...
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = ...
<span class="hljs-meta">&gt;&gt;&gt; </span>device = ...
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(model_id).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load lora 0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PeftModel.from_pretrained(model, <span class="hljs-string">&quot;path-adapter-0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = torch.<span class="hljs-built_in">compile</span>(model)  <span class="hljs-comment"># optionally compile the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    output_adapter_0 = model(inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># replace the &quot;default&quot; lora adapter with the new one</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hotswap_adapter(model, <span class="hljs-string">&quot;path-adapter-1&quot;</span>, adapter_name=<span class="hljs-string">&quot;default&quot;</span>, torch_device=device)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    output_adapter_1 = model(inputs).logits`,wrap:!1}}),{c(){p=d("p"),p.textContent=G,j=l(),g(w.$$.fragment)},l(n){p=m(n,"P",{"data-svelte-h":!0}),u(p)!=="svelte-11lpom8"&&(p.textContent=G),j=o(n),y(w.$$.fragment,n)},m(n,M){s(n,p,M),s(n,j,M),b(w,n,M),f=!0},p:$t,i(n){f||(T(w.$$.fragment,n),f=!0)},o(n){J(w.$$.fragment,n),f=!1},d(n){n&&(a(p),a(j)),_(w,n)}}}function Et(N){let p,G,j,w,f,n,M,yt="The idea of hotswapping an adapter is the following: We can already load multiple adapters, e.g. two LoRAs, at the same time. But sometimes, we want to load one LoRA and then replace its weights in-place with the LoRA weights of another adapter. This is now possible the <code>hotswap_adapter</code> function.",S,U,bt="In general, this should be faster than deleting one adapter and loading the adapter in its place, which would be the how to achieve the same final outcome without hotswapping. Another advantage of hotswapping is that it prevents re-compilation in case the PEFT model is already compiled using <code>torch.compile</code>. This can save quite a lot of time.",P,C,q,B,K,k,D,F,O,$,tt,R,Tt="Hotswapping works with transformers models and diffusers models. However, there are some caveats:",et,W,Jt="<li>Right now, only LoRA is properly supported.</li> <li>It only works for the same PEFT method, so no swapping LoRA and LoHa, for example.</li> <li>The adapter that is being swapped in must target the same layers as the previous adapter or a subset of those layers. It cannot target new layers. Therefore, if possible, start with the adapter that targets most layers.</li>",at,r,I,mt,X,_t="Substitute old adapter data with new adapter data, keeping the rest the same.",it,E,jt="As of now, only LoRA is supported.",ct,H,Zt=`This function is useful when you want to replace the loaded adapter with a new adapter. The adapter name will
remain the same, but the weights and other parameters will be swapped out.`,ht,Q,vt=`If the adapters are incomptabile, e.g. targeting different layers or having different alpha values, an error will
be raised.`,wt,Z,st,h,x,ft,L,Gt="Swap out the adapter weights from the model with the weights from state_dict.",ut,A,Ut="As of now, only LoRA is supported.",Mt,Y,Ct=`This is a low-level function that assumes that the adapters have been checked for compatibility and that the
state_dict has been correctly mapped to work with PEFT. For a high level function that performs this work for you,
use <code>hotswap_adapter</code> instead.`,lt,V,ot,z,nt;return f=new dt({props:{title:"Hotswapping adapters",local:"hotswapping-adapters",headingTag:"h1"}}),C=new dt({props:{title:"Example without torch.compile",local:"example-without-torchcompile",headingTag:"h2"}}),B=new gt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMFBlZnRNb2RlbCUwQWZyb20lMjBwZWZ0LnV0aWxzLmhvdHN3YXAlMjBpbXBvcnQlMjBob3Rzd2FwX2FkYXB0ZXIlMEElMEFtb2RlbF9pZCUyMCUzRCUyMC4uLiUwQWlucHV0cyUyMCUzRCUyMC4uLiUwQWRldmljZSUyMCUzRCUyMC4uLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKS50byhkZXZpY2UpJTBBJTBBJTIzJTIwbG9hZCUyMGxvcmElMjAwJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKG1vZGVsJTJDJTIwJTNDcGF0aC1hZGFwdGVyLTAlM0UpJTBBd2l0aCUyMHRvcmNoLmluZmVyZW5jZV9tb2RlKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRfYWRhcHRlcl8wJTIwJTNEJTIwbW9kZWwoaW5wdXRzKSUwQSUwQSUyMyUyMHJlcGxhY2UlMjB0aGUlMjAlMjJkZWZhdWx0JTIyJTIwbG9yYSUyMGFkYXB0ZXIlMjB3aXRoJTIwdGhlJTIwbmV3JTIwb25lJTBBaG90c3dhcF9hZGFwdGVyKG1vZGVsJTJDJTIwJTNDcGF0aC1hZGFwdGVyLTElM0UlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJkZWZhdWx0JTIyJTJDJTIwdG9yY2hfZGV2aWNlJTNEZGV2aWNlKSUwQXdpdGglMjB0b3JjaC5pbmZlcmVuY2VfbW9kZSgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2FkYXB0ZXJfMSUyMCUzRCUyMG1vZGVsKGlucHV0cykubG9naXRz",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel
<span class="hljs-keyword">from</span> peft.utils.hotswap <span class="hljs-keyword">import</span> hotswap_adapter

model_id = ...
inputs = ...
device = ...
model = AutoModelForCausalLM.from_pretrained(model_id).to(device)

<span class="hljs-comment"># load lora 0</span>
model = PeftModel.from_pretrained(model, &lt;path-adapter-<span class="hljs-number">0</span>&gt;)
<span class="hljs-keyword">with</span> torch.inference_mode():
    output_adapter_0 = model(inputs)

<span class="hljs-comment"># replace the &quot;default&quot; lora adapter with the new one</span>
hotswap_adapter(model, &lt;path-adapter-<span class="hljs-number">1</span>&gt;, adapter_name=<span class="hljs-string">&quot;default&quot;</span>, torch_device=device)
<span class="hljs-keyword">with</span> torch.inference_mode():
    output_adapter_1 = model(inputs).logits`,wrap:!1}}),k=new dt({props:{title:"Example with torch.compile",local:"example-with-torchcompile",headingTag:"h2"}}),F=new gt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMFBlZnRNb2RlbCUwQWZyb20lMjBwZWZ0LnV0aWxzLmhvdHN3YXAlMjBpbXBvcnQlMjBob3Rzd2FwX2FkYXB0ZXIlMkMlMjBwcmVwYXJlX21vZGVsX2Zvcl9jb21waWxlZF9ob3Rzd2FwJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAuLi4lMEFpbnB1dHMlMjAlM0QlMjAuLi4lMEFkZXZpY2UlMjAlM0QlMjAuLi4lMEFtYXhfcmFuayUyMCUzRCUyMC4uLiUyMCUyMCUyMyUyMG1heGltdW0lMjByYW5rJTIwYW1vbmclMjBhbGwlMjBMb1JBJTIwYWRhcHRlcnMlMjB0aGF0JTIwd2lsbCUyMGJlJTIwdXNlZCUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKS50byhkZXZpY2UpJTBBJTBBJTIzJTIwbG9hZCUyMGxvcmElMjAwJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKG1vZGVsJTJDJTIwJTNDcGF0aC1hZGFwdGVyLTAlM0UpJTBBJTIzJTIwUHJlcGFyZSUyMHRoZSUyMG1vZGVsJTIwdG8lMjBhbGxvdyUyMGhvdHN3YXBwaW5nJTIwZXZlbiUyMGlmJTIwcmFua3MlMkZzY2FsaW5ncyUyMG9mJTIwMm5kJTIwYWRhcHRlciUyMGRpZmZlci4lMEElMjMlMjBZb3UlMjBjYW4lMjBza2lwJTIwdGhpcyUyMHN0ZXAlMjBpZiUyMGFsbCUyMHJhbmtzJTIwYW5kJTIwc2NhbGluZ3MlMjBhcmUlMjBpZGVudGljYWwuJTBBcHJlcGFyZV9tb2RlbF9mb3JfY29tcGlsZWRfaG90c3dhcChtb2RlbCUyQyUyMHRhcmdldF9yYW5rJTNEbWF4X3JhbmspJTBBbW9kZWwlMjAlM0QlMjB0b3JjaC5jb21waWxlKG1vZGVsKSUwQXdpdGglMjB0b3JjaC5pbmZlcmVuY2VfbW9kZSgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2FkYXB0ZXJfMCUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEElMEElMjMlMjByZXBsYWNlJTIwdGhlJTIwJTIyZGVmYXVsdCUyMiUyMGxvcmElMjBhZGFwdGVyJTIwd2l0aCUyMHRoZSUyMG5ldyUyMG9uZSUwQWhvdHN3YXBfYWRhcHRlcihtb2RlbCUyQyUyMCUzQ3BhdGgtYWRhcHRlci0xJTNFJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyZGVmYXVsdCUyMiUyQyUyMHRvcmNoX2RldmljZSUzRGRldmljZSklMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dF9hZGFwdGVyXzElMjAlM0QlMjBtb2RlbChpbnB1dHMpLmxvZ2l0cw==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel
<span class="hljs-keyword">from</span> peft.utils.hotswap <span class="hljs-keyword">import</span> hotswap_adapter, prepare_model_for_compiled_hotswap

model_id = ...
inputs = ...
device = ...
max_rank = ...  <span class="hljs-comment"># maximum rank among all LoRA adapters that will be used</span>
model = AutoModelForCausalLM.from_pretrained(model_id).to(device)

<span class="hljs-comment"># load lora 0</span>
model = PeftModel.from_pretrained(model, &lt;path-adapter-<span class="hljs-number">0</span>&gt;)
<span class="hljs-comment"># Prepare the model to allow hotswapping even if ranks/scalings of 2nd adapter differ.</span>
<span class="hljs-comment"># You can skip this step if all ranks and scalings are identical.</span>
prepare_model_for_compiled_hotswap(model, target_rank=max_rank)
model = torch.<span class="hljs-built_in">compile</span>(model)
<span class="hljs-keyword">with</span> torch.inference_mode():
    output_adapter_0 = model(inputs)

<span class="hljs-comment"># replace the &quot;default&quot; lora adapter with the new one</span>
hotswap_adapter(model, &lt;path-adapter-<span class="hljs-number">1</span>&gt;, adapter_name=<span class="hljs-string">&quot;default&quot;</span>, torch_device=device)
<span class="hljs-keyword">with</span> torch.inference_mode():
    output_adapter_1 = model(inputs).logits`,wrap:!1}}),$=new dt({props:{title:"Caveats",local:"peft.utils.hotswap.hotswap_adapter",headingTag:"h2"}}),I=new Bt({props:{name:"peft.utils.hotswap.hotswap_adapter",anchor:"peft.utils.hotswap.hotswap_adapter",parameters:[{name:"model",val:""},{name:"model_name_or_path",val:""},{name:"adapter_name",val:""},{name:"torch_device",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"peft.utils.hotswap.hotswap_adapter.model",description:`<strong>model</strong> (<a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">~PeftModel</a>) &#x2014;
The PEFT model with the loaded adapter.`,name:"model"},{anchor:"peft.utils.hotswap.hotswap_adapter.model_name_or_path",description:`<strong>model_name_or_path</strong> (<code>str</code>) &#x2014;
The name or path of the model to load the new adapter from.`,name:"model_name_or_path"},{anchor:"peft.utils.hotswap.hotswap_adapter.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>) &#x2014;
The name of the adapter to swap, e.g. <code>&quot;default&quot;</code>. The name will stay the same after swapping.`,name:"adapter_name"},{anchor:"peft.utils.hotswap.hotswap_adapter.torch_device",description:`<strong>torch_device</strong> &#x2014; (<code>str</code>, <em>optional</em>, defaults to None):
The device to load the new adapter onto.`,name:"torch_device"},{anchor:"peft.utils.hotswap.hotswap_adapter.*kwargs",description:`*<strong>*kwargs</strong> (<code>optional</code>) &#x2014;
Additional keyword arguments used for loading the config and weights.`,name:"*kwargs"}],source:"https://github.com/huggingface/peft/blob/main/src/peft/utils/hotswap.py#L545"}}),Z=new xt({props:{anchor:"peft.utils.hotswap.hotswap_adapter.example",$$slots:{default:[Xt]},$$scope:{ctx:N}}}),x=new Bt({props:{name:"peft.utils.hotswap.hotswap_adapter_from_state_dict",anchor:"peft.utils.hotswap.hotswap_adapter_from_state_dict",parameters:[{name:"model",val:": torch.nn.Module"},{name:"state_dict",val:": dict[str, torch.Tensor]"},{name:"adapter_name",val:": str"},{name:"config",val:": LoraConfig"},{name:"parameter_prefix",val:": str = 'lora_'"}],parametersDescription:[{anchor:"peft.utils.hotswap.hotswap_adapter_from_state_dict.model",description:`<strong>model</strong> (<code>nn.Module</code>) &#x2014;
The model with the loaded adapter.`,name:"model"},{anchor:"peft.utils.hotswap.hotswap_adapter_from_state_dict.state_dict",description:`<strong>state_dict</strong> (<code>dict[str, torch.Tensor]</code>) &#x2014;
The state dict of the new adapter, which needs to be compatible (targeting same modules etc.).`,name:"state_dict"},{anchor:"peft.utils.hotswap.hotswap_adapter_from_state_dict.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>) &#x2014;
The name of the adapter that should be hot-swapped, e.g. <code>&quot;default&quot;</code>. The name will remain the same after
swapping.`,name:"adapter_name"},{anchor:"peft.utils.hotswap.hotswap_adapter_from_state_dict.config",description:`<strong>config</strong> (<code>LoraConfig</code>) &#x2014;
The config of the LoRA adapter. This is used to determine the scaling and rank of the adapter.`,name:"config"},{anchor:"peft.utils.hotswap.hotswap_adapter_from_state_dict.parameter_prefix",description:`<strong>parameter_prefix</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;lora_&quot;</code>) &#x2014;
The prefix used to identify the adapter&#x2019;s keys in the state dict. For LoRA, this would be <code>&quot;lora_&quot;</code> (the
default).`,name:"parameter_prefix"}],source:"https://github.com/huggingface/peft/blob/main/src/peft/utils/hotswap.py#L369",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>RuntimeError</code> —
If the old and the new adapter are not compatible, a RuntimeError is raised.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>RuntimeError</code></p>
`}}),V=new Vt({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/package_reference/hotswap.md"}}),{c(){p=d("meta"),G=l(),j=d("p"),w=l(),g(f.$$.fragment),n=l(),M=d("p"),M.innerHTML=yt,S=l(),U=d("p"),U.innerHTML=bt,P=l(),g(C.$$.fragment),q=l(),g(B.$$.fragment),K=l(),g(k.$$.fragment),D=l(),g(F.$$.fragment),O=l(),g($.$$.fragment),tt=l(),R=d("p"),R.textContent=Tt,et=l(),W=d("ul"),W.innerHTML=Jt,at=l(),r=d("div"),g(I.$$.fragment),mt=l(),X=d("p"),X.textContent=_t,it=l(),E=d("p"),E.textContent=jt,ct=l(),H=d("p"),H.textContent=Zt,ht=l(),Q=d("p"),Q.textContent=vt,wt=l(),g(Z.$$.fragment),st=l(),h=d("div"),g(x.$$.fragment),ft=l(),L=d("p"),L.textContent=Gt,ut=l(),A=d("p"),A.textContent=Ut,Mt=l(),Y=d("p"),Y.innerHTML=Ct,lt=l(),g(V.$$.fragment),ot=l(),z=d("p"),this.h()},l(t){const e=It("svelte-u9bgzb",document.head);p=m(e,"META",{name:!0,content:!0}),e.forEach(a),G=o(t),j=m(t,"P",{}),pt(j).forEach(a),w=o(t),y(f.$$.fragment,t),n=o(t),M=m(t,"P",{"data-svelte-h":!0}),u(M)!=="svelte-1r4koev"&&(M.innerHTML=yt),S=o(t),U=m(t,"P",{"data-svelte-h":!0}),u(U)!=="svelte-2f3tnn"&&(U.innerHTML=bt),P=o(t),y(C.$$.fragment,t),q=o(t),y(B.$$.fragment,t),K=o(t),y(k.$$.fragment,t),D=o(t),y(F.$$.fragment,t),O=o(t),y($.$$.fragment,t),tt=o(t),R=m(t,"P",{"data-svelte-h":!0}),u(R)!=="svelte-1904uk3"&&(R.textContent=Tt),et=o(t),W=m(t,"UL",{"data-svelte-h":!0}),u(W)!=="svelte-1ybjwin"&&(W.innerHTML=Jt),at=o(t),r=m(t,"DIV",{class:!0});var c=pt(r);y(I.$$.fragment,c),mt=o(c),X=m(c,"P",{"data-svelte-h":!0}),u(X)!=="svelte-9ihruw"&&(X.textContent=_t),it=o(c),E=m(c,"P",{"data-svelte-h":!0}),u(E)!=="svelte-10f33xj"&&(E.textContent=jt),ct=o(c),H=m(c,"P",{"data-svelte-h":!0}),u(H)!=="svelte-rl33pg"&&(H.textContent=Zt),ht=o(c),Q=m(c,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-1e6bpeq"&&(Q.textContent=vt),wt=o(c),y(Z.$$.fragment,c),c.forEach(a),st=o(t),h=m(t,"DIV",{class:!0});var v=pt(h);y(x.$$.fragment,v),ft=o(v),L=m(v,"P",{"data-svelte-h":!0}),u(L)!=="svelte-1sueth6"&&(L.textContent=Gt),ut=o(v),A=m(v,"P",{"data-svelte-h":!0}),u(A)!=="svelte-10f33xj"&&(A.textContent=Ut),Mt=o(v),Y=m(v,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-1dqtnq6"&&(Y.innerHTML=Ct),v.forEach(a),lt=o(t),y(V.$$.fragment,t),ot=o(t),z=m(t,"P",{}),pt(z).forEach(a),this.h()},h(){rt(p,"name","hf:doc:metadata"),rt(p,"content",Ht),rt(r,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),rt(h,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,e){i(document.head,p),s(t,G,e),s(t,j,e),s(t,w,e),b(f,t,e),s(t,n,e),s(t,M,e),s(t,S,e),s(t,U,e),s(t,P,e),b(C,t,e),s(t,q,e),b(B,t,e),s(t,K,e),b(k,t,e),s(t,D,e),b(F,t,e),s(t,O,e),b($,t,e),s(t,tt,e),s(t,R,e),s(t,et,e),s(t,W,e),s(t,at,e),s(t,r,e),b(I,r,null),i(r,mt),i(r,X),i(r,it),i(r,E),i(r,ct),i(r,H),i(r,ht),i(r,Q),i(r,wt),b(Z,r,null),s(t,st,e),s(t,h,e),b(x,h,null),i(h,ft),i(h,L),i(h,ut),i(h,A),i(h,Mt),i(h,Y),s(t,lt,e),b(V,t,e),s(t,ot,e),s(t,z,e),nt=!0},p(t,[e]){const c={};e&2&&(c.$$scope={dirty:e,ctx:t}),Z.$set(c)},i(t){nt||(T(f.$$.fragment,t),T(C.$$.fragment,t),T(B.$$.fragment,t),T(k.$$.fragment,t),T(F.$$.fragment,t),T($.$$.fragment,t),T(I.$$.fragment,t),T(Z.$$.fragment,t),T(x.$$.fragment,t),T(V.$$.fragment,t),nt=!0)},o(t){J(f.$$.fragment,t),J(C.$$.fragment,t),J(B.$$.fragment,t),J(k.$$.fragment,t),J(F.$$.fragment,t),J($.$$.fragment,t),J(I.$$.fragment,t),J(Z.$$.fragment,t),J(x.$$.fragment,t),J(V.$$.fragment,t),nt=!1},d(t){t&&(a(G),a(j),a(w),a(n),a(M),a(S),a(U),a(P),a(q),a(K),a(D),a(O),a(tt),a(R),a(et),a(W),a(at),a(r),a(st),a(h),a(lt),a(ot),a(z)),a(p),_(f,t),_(C,t),_(B,t),_(k,t),_(F,t),_($,t),_(I),_(Z),_(x),_(V,t)}}}const Ht='{"title":"Hotswapping adapters","local":"hotswapping-adapters","sections":[{"title":"Example without torch.compile","local":"example-without-torchcompile","sections":[],"depth":2},{"title":"Example with torch.compile","local":"example-with-torchcompile","sections":[],"depth":2},{"title":"Caveats","local":"peft.utils.hotswap.hotswap_adapter","sections":[],"depth":2}],"depth":1}';function Qt(N){return Ft(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pt extends Rt{constructor(p){super(),Wt(this,p,Qt,Et,kt,{})}}export{Pt as component};
