import{s as ea,n as ta,o as aa}from"../chunks/scheduler.c57aa7ef.js";import{S as ra,i as na,g as n,s as a,r as c,A as sa,h as s,f as o,c as r,j as b,u as m,x as l,k as v,y as t,a as $,v as f,d as g,t as h,w as _}from"../chunks/index.394f8801.js";import{D as y}from"../chunks/Docstring.658fa394.js";import{H as Lt,E as oa}from"../chunks/getInferenceSnippets.06058b63.js";function da(Pt){let M,Ee,Me,Ie,F,je,q,Dt="A tuner (or adapter) is a module that can be plugged into a <code>torch.nn.Module</code>. <code>BaseTuner</code> base class for other tuners and provides shared methods and attributes for preparing an adapter configuration and replacing a target module with the adapter module. <code>BaseTunerLayer</code> is a base class for adapter layers. It offers methods and attributes for managing adapters such as activating and disabling adapters.",He,V,Fe,d,A,Re,ee,Mt=`A base tuner model that provides the common methods and attributes for all tuners that are injectable into a
torch.nn.Module`,Ge,te,kt="For adding a new Tuner class, one needs to overwrite the following methods:",Je,ae,Et=`<li><strong>_prepare_adapter_config</strong>:
A private method to eventually prepare the adapter config, for example in case the field <code>target_modules</code> is
missing.</li> <li><strong>_create_and_replace</strong>:
A private method to create and replace the target module with the adapter module.</li> <li><strong>_check_target_module_exists</strong>:
A private helper method to check if the passed module’s key name matches any of the target modules in the
adapter_config.</li>`,Ke,re,It="The easiest is to check what is done in the <code>peft.tuners.lora.LoraModel</code> class.",Qe,k,N,Xe,ne,jt="Disable all adapters in-place.",Ye,E,U,Ze,se,Ht="Enable all adapters in-place",et,I,O,tt,oe,Ft=`This method gets the config from a model in dictionary form. If model has not attribute config, then this
method returns a default config.`,at,w,S,rt,de,qt=`Creates adapter layers and replaces the target modules with the adapter layers. This method is called under the
hood by <code>peft.mapping.get_peft_model</code> if a non-prompt tuning adapter class is passed.`,nt,le,Vt="The corresponding PEFT config is directly retrieved from the <code>peft_config</code> attribute of the BaseTuner class.",st,C,W,ot,ie,At="This method merges the adapter layers into the base model.",dt,ue,Nt=`Merging adapters can lead to a speed up of the forward pass. A copy of the adapter weights is still kept in
memory, which is required to unmerge the adapters. In order to merge the adapter weights without keeping them
in memory, please call <code>merge_and_unload</code>.`,lt,B,z,it,pe,Ut="Sets the active adapter(s) on auxiliary modules.",ut,ce,Ot=`If the subclass (e.g. <code>LoraModel</code>) supports auxiliary modules like <code>modules_to_save</code>, it should call this
method in <code>set_adapter</code> to ensure that those auxiliary modules are being set correctly.`,pt,j,R,ct,me,St="This method unmerges all merged adapter layers from the base model.",qe,G,Ve,p,J,mt,fe,Wt="A tuner layer mixin that provides the common methods and attributes for all tuners.",ft,x,K,gt,ge,zt="Delete an adapter from the layer",ht,he,Rt="This should be called on all adapter layers, or else we will get an inconsistent state.",_t,_e,Gt=`This method will also set a new active adapter if the deleted adapter was an active adapter. It is important
that the new adapter is chosen in a deterministic way, so that the same adapter is chosen on all layers.`,bt,L,Q,vt,be,Jt="Toggle the enabling and disabling of adapters",$t,ve,Kt="Takes care of setting the requires_grad flag for the adapter weights.",yt,P,X,xt,$e,Qt="(Recursively) get the base_layer.",Tt,ye,Xt="This is necessary for the case that the tuner layer wraps another tuner layer.",wt,D,Y,Ct,xe,Yt="Set the active adapter(s).",Bt,Te,Zt=`Additionally, this function will set the specified adapter to trainable (i.e., requires_grad=True) unless
inference_mode is True.`,Ae,Z,Ne,ke,Ue;return F=new Lt({props:{title:"Tuners",local:"tuners",headingTag:"h1"}}),V=new Lt({props:{title:"BaseTuner",local:"peft.tuners.tuners_utils.BaseTuner",headingTag:"h2"}}),A=new y({props:{name:"class peft.tuners.tuners_utils.BaseTuner",anchor:"peft.tuners.tuners_utils.BaseTuner",parameters:[{name:"model",val:""},{name:"peft_config",val:": Union[PeftConfig, dict[str, PeftConfig]]"},{name:"adapter_name",val:": str"},{name:"low_cpu_mem_usage",val:": bool = False"},{name:"state_dict",val:": Optional[dict[str, torch.Tensor]] = None"}],parametersDescription:[{anchor:"peft.tuners.tuners_utils.BaseTuner.model",description:`<strong>model</strong> (<code>torch.nn.Module</code>) &#x2014;
The model to which the adapter tuner layers will be attached.`,name:"model"},{anchor:"peft.tuners.tuners_utils.BaseTuner.forward",description:`<strong>forward</strong> (<code>Callable</code>) &#x2014;
The forward method of the model.`,name:"forward"},{anchor:"peft.tuners.tuners_utils.BaseTuner.peft_config",description:`<strong>peft_config</strong> (<code>Union[</code>PeftConfig<code>, dict[str, PeftConfig]]</code>) &#x2014;
The adapter configuration object, it should be a dictionary of <code>str</code> to <code>PeftConfig</code> objects. One can also
pass a PeftConfig object and a new adapter will be created with the default name <code>adapter</code> or create a new
dictionary with a key <code>adapter_name</code> and a value of that peft config.`,name:"peft_config"},{anchor:"peft.tuners.tuners_utils.BaseTuner.config",description:`<strong>config</strong> (<code>dict[str, Any]</code>) &#x2014;
The model configuration object, it should be a dictionary of <code>str</code> to <code>Any</code> objects.`,name:"config"},{anchor:"peft.tuners.tuners_utils.BaseTuner.targeted_module_names",description:`<strong>targeted_module_names</strong> (<code>list[str]</code>) &#x2014;
The list of module names that were actually adapted. Can be useful to inspect if you want to quickly
double-check that the <code>config.target_modules</code> were specified correctly.`,name:"targeted_module_names"},{anchor:"peft.tuners.tuners_utils.BaseTuner.targeted_parameter_names",description:`<strong>targeted_parameter_names</strong> (<code>list[str]</code>) &#x2014;
The list of parameter names that were actually adapted. Can be useful to inspect if you want to quickly
double-check that the <code>config.target_parameters</code> were specified correctly.`,name:"targeted_parameter_names"}],source:"https://github.com/huggingface/peft/blob/main/src/peft/tuners/tuners_utils.py#L146"}}),N=new y({props:{name:"disable_adapter_layers",anchor:"peft.tuners.tuners_utils.BaseTuner.disable_adapter_layers",parameters:[],source:"https://github.com/huggingface/peft/blob/main/src/peft/tuners/tuners_utils.py#L336"}}),U=new y({props:{name:"enable_adapter_layers",anchor:"peft.tuners.tuners_utils.BaseTuner.enable_adapter_layers",parameters:[],source:"https://github.com/huggingface/peft/blob/main/src/peft/tuners/tuners_utils.py#L343"}}),O=new y({props:{name:"get_model_config",anchor:"peft.tuners.tuners_utils.BaseTuner.get_model_config",parameters:[{name:"model",val:": nn.Module"}],parametersDescription:[{anchor:"peft.tuners.tuners_utils.BaseTuner.get_model_config.model",description:`<strong>model</strong> (<code>nn.Module</code>) &#x2014;
Model to get the config from.`,name:"model"},{anchor:"peft.tuners.tuners_utils.BaseTuner.get_model_config.default",description:`<strong>default</strong> (<code>dict|None</code>, <em>optional</em>) &#x2014;:
What to return if model does not have a config attribute.`,name:"default"}],source:"https://github.com/huggingface/peft/blob/main/src/peft/tuners/tuners_utils.py#L870"}}),S=new y({props:{name:"inject_adapter",anchor:"peft.tuners.tuners_utils.BaseTuner.inject_adapter",parameters:[{name:"model",val:": nn.Module"},{name:"adapter_name",val:": str"},{name:"autocast_adapter_dtype",val:": bool = True"},{name:"low_cpu_mem_usage",val:": bool = False"},{name:"state_dict",val:": Optional[dict[str, torch.Tensor]] = None"}],parametersDescription:[{anchor:"peft.tuners.tuners_utils.BaseTuner.inject_adapter.model",description:`<strong>model</strong> (<code>nn.Module</code>) &#x2014;
The model to be tuned.`,name:"model"},{anchor:"peft.tuners.tuners_utils.BaseTuner.inject_adapter.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>) &#x2014;
The adapter name.`,name:"adapter_name"},{anchor:"peft.tuners.tuners_utils.BaseTuner.inject_adapter.autocast_adapter_dtype",description:`<strong>autocast_adapter_dtype</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to autocast the adapter dtype. Defaults to <code>True</code>.`,name:"autocast_adapter_dtype"},{anchor:"peft.tuners.tuners_utils.BaseTuner.inject_adapter.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <code>optional</code>, defaults to <code>False</code>) &#x2014;
Create empty adapter weights on meta device. Useful to speed up the loading process.`,name:"low_cpu_mem_usage"},{anchor:"peft.tuners.tuners_utils.BaseTuner.inject_adapter.state_dict",description:`<strong>state_dict</strong> (<code>dict</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If a state_dict is passed here, the adapters will be injected based on the entries of the state_dict.
This can be useful when the exact <code>target_modules</code> of the PEFT method is unknown, for instance because
the checkpoint was created without meta data. Note that the values from the state_dict are not used,
only the keys are used to determine the correct layers that should be adapted.`,name:"state_dict"}],source:"https://github.com/huggingface/peft/blob/main/src/peft/tuners/tuners_utils.py#L449"}}),W=new y({props:{name:"merge_adapter",anchor:"peft.tuners.tuners_utils.BaseTuner.merge_adapter",parameters:[{name:"adapter_names",val:": Optional[list[str]] = None"},{name:"safe_merge",val:": bool = False"}],parametersDescription:[{anchor:"peft.tuners.tuners_utils.BaseTuner.merge_adapter.adapter_names",description:`<strong>adapter_names</strong> (<code>list[str]</code>, <em>optional</em>) &#x2014;
The list of adapter names that should be merged. If <code>None</code>, all active adapters will be merged.
Defaults to <code>None</code>.`,name:"adapter_names"},{anchor:"peft.tuners.tuners_utils.BaseTuner.merge_adapter.safe_merge",description:`<strong>safe_merge</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, the merge operation will be performed in a copy of the original weights and check for NaNs
before merging the weights. This is useful if you want to check if the merge operation will produce
NaNs. Defaults to <code>False</code>.`,name:"safe_merge"}],source:"https://github.com/huggingface/peft/blob/main/src/peft/tuners/tuners_utils.py#L804"}}),z=new y({props:{name:"set_auxiliary_adapters",anchor:"peft.tuners.tuners_utils.BaseTuner.set_auxiliary_adapters",parameters:[{name:"adapter_name",val:": str | list[str]"},{name:"inference_mode",val:": bool"}],parametersDescription:[{anchor:"peft.tuners.tuners_utils.BaseTuner.set_auxiliary_adapters.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code> or <code>list[str]</code>) &#x2014;
The name(s) of the adapter(s) to be set as active. The adapters must be loaded first.`,name:"adapter_name"},{anchor:"peft.tuners.tuners_utils.BaseTuner.set_auxiliary_adapters.inference_mode",description:`<strong>inference_mode</strong> (bool, optional) &#x2014;
Whether the activated adapter should be frozen (i.e. <code>requires_grad=False</code>). Default is False.`,name:"inference_mode"}],source:"https://github.com/huggingface/peft/blob/main/src/peft/tuners/tuners_utils.py#L842"}}),R=new y({props:{name:"unmerge_adapter",anchor:"peft.tuners.tuners_utils.BaseTuner.unmerge_adapter",parameters:[],source:"https://github.com/huggingface/peft/blob/main/src/peft/tuners/tuners_utils.py#L833"}}),G=new Lt({props:{title:"BaseTunerLayer",local:"peft.tuners.tuners_utils.BaseTunerLayer",headingTag:"h2"}}),J=new y({props:{name:"class peft.tuners.tuners_utils.BaseTunerLayer",anchor:"peft.tuners.tuners_utils.BaseTunerLayer",parameters:[],parametersDescription:[{anchor:"peft.tuners.tuners_utils.BaseTunerLayer.is_pluggable",description:`<strong>is_pluggable</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the adapter layer can be plugged to any pytorch module`,name:"is_pluggable"},{anchor:"peft.tuners.tuners_utils.BaseTunerLayer.active_adapters",description:`<strong>active_adapters</strong> (Union[List<code>str</code>, <code>str</code>], <em>optional</em>) &#x2014;
The name of the active adapter.`,name:"active_adapters"}],source:"https://github.com/huggingface/peft/blob/main/src/peft/tuners/tuners_utils.py#L902"}}),K=new y({props:{name:"delete_adapter",anchor:"peft.tuners.tuners_utils.BaseTunerLayer.delete_adapter",parameters:[{name:"adapter_name",val:": str"}],parametersDescription:[{anchor:"peft.tuners.tuners_utils.BaseTunerLayer.delete_adapter.adapter_name",description:"<strong>adapter_name</strong> (<code>str</code>) &#x2014; The name of the adapter to delete",name:"adapter_name"}],source:"https://github.com/huggingface/peft/blob/main/src/peft/tuners/tuners_utils.py#L1054"}}),Q=new y({props:{name:"enable_adapters",anchor:"peft.tuners.tuners_utils.BaseTunerLayer.enable_adapters",parameters:[{name:"enabled",val:": bool"}],parametersDescription:[{anchor:"peft.tuners.tuners_utils.BaseTunerLayer.enable_adapters.enabled",description:"<strong>enabled</strong> (bool) &#x2014; True to enable adapters, False to disable adapters",name:"enabled"}],source:"https://github.com/huggingface/peft/blob/main/src/peft/tuners/tuners_utils.py#L997"}}),X=new y({props:{name:"get_base_layer",anchor:"peft.tuners.tuners_utils.BaseTunerLayer.get_base_layer",parameters:[],source:"https://github.com/huggingface/peft/blob/main/src/peft/tuners/tuners_utils.py#L927"}}),Y=new y({props:{name:"set_adapter",anchor:"peft.tuners.tuners_utils.BaseTunerLayer.set_adapter",parameters:[{name:"adapter_names",val:": str | list[str]"},{name:"inference_mode",val:": bool = False"}],parametersDescription:[{anchor:"peft.tuners.tuners_utils.BaseTunerLayer.set_adapter.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code> or <code>list[str]</code>) &#x2014;
The name(s) of the adapter(s) to set as active.`,name:"adapter_name"},{anchor:"peft.tuners.tuners_utils.BaseTunerLayer.set_adapter.inference_mode",description:`<strong>inference_mode</strong> (bool, optional) &#x2014;
Whether the activated adapter should be frozen (i.e. <code>requires_grad=False</code>). Default is False.`,name:"inference_mode"}],source:"https://github.com/huggingface/peft/blob/main/src/peft/tuners/tuners_utils.py#L1015"}}),Z=new oa({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/package_reference/tuners.md"}}),{c(){M=n("meta"),Ee=a(),Me=n("p"),Ie=a(),c(F.$$.fragment),je=a(),q=n("p"),q.innerHTML=Dt,He=a(),c(V.$$.fragment),Fe=a(),d=n("div"),c(A.$$.fragment),Re=a(),ee=n("p"),ee.textContent=Mt,Ge=a(),te=n("p"),te.textContent=kt,Je=a(),ae=n("ul"),ae.innerHTML=Et,Ke=a(),re=n("p"),re.innerHTML=It,Qe=a(),k=n("div"),c(N.$$.fragment),Xe=a(),ne=n("p"),ne.textContent=jt,Ye=a(),E=n("div"),c(U.$$.fragment),Ze=a(),se=n("p"),se.textContent=Ht,et=a(),I=n("div"),c(O.$$.fragment),tt=a(),oe=n("p"),oe.textContent=Ft,at=a(),w=n("div"),c(S.$$.fragment),rt=a(),de=n("p"),de.innerHTML=qt,nt=a(),le=n("p"),le.innerHTML=Vt,st=a(),C=n("div"),c(W.$$.fragment),ot=a(),ie=n("p"),ie.textContent=At,dt=a(),ue=n("p"),ue.innerHTML=Nt,lt=a(),B=n("div"),c(z.$$.fragment),it=a(),pe=n("p"),pe.textContent=Ut,ut=a(),ce=n("p"),ce.innerHTML=Ot,pt=a(),j=n("div"),c(R.$$.fragment),ct=a(),me=n("p"),me.textContent=St,qe=a(),c(G.$$.fragment),Ve=a(),p=n("div"),c(J.$$.fragment),mt=a(),fe=n("p"),fe.textContent=Wt,ft=a(),x=n("div"),c(K.$$.fragment),gt=a(),ge=n("p"),ge.textContent=zt,ht=a(),he=n("p"),he.textContent=Rt,_t=a(),_e=n("p"),_e.textContent=Gt,bt=a(),L=n("div"),c(Q.$$.fragment),vt=a(),be=n("p"),be.textContent=Jt,$t=a(),ve=n("p"),ve.textContent=Kt,yt=a(),P=n("div"),c(X.$$.fragment),xt=a(),$e=n("p"),$e.textContent=Qt,Tt=a(),ye=n("p"),ye.textContent=Xt,wt=a(),D=n("div"),c(Y.$$.fragment),Ct=a(),xe=n("p"),xe.textContent=Yt,Bt=a(),Te=n("p"),Te.textContent=Zt,Ae=a(),c(Z.$$.fragment),Ne=a(),ke=n("p"),this.h()},l(e){const u=sa("svelte-u9bgzb",document.head);M=s(u,"META",{name:!0,content:!0}),u.forEach(o),Ee=r(e),Me=s(e,"P",{}),b(Me).forEach(o),Ie=r(e),m(F.$$.fragment,e),je=r(e),q=s(e,"P",{"data-svelte-h":!0}),l(q)!=="svelte-dsnslo"&&(q.innerHTML=Dt),He=r(e),m(V.$$.fragment,e),Fe=r(e),d=s(e,"DIV",{class:!0});var i=b(d);m(A.$$.fragment,i),Re=r(i),ee=s(i,"P",{"data-svelte-h":!0}),l(ee)!=="svelte-1k0hvlq"&&(ee.textContent=Mt),Ge=r(i),te=s(i,"P",{"data-svelte-h":!0}),l(te)!=="svelte-fkgwsm"&&(te.textContent=kt),Je=r(i),ae=s(i,"UL",{"data-svelte-h":!0}),l(ae)!=="svelte-uumdnf"&&(ae.innerHTML=Et),Ke=r(i),re=s(i,"P",{"data-svelte-h":!0}),l(re)!=="svelte-1sc4mfu"&&(re.innerHTML=It),Qe=r(i),k=s(i,"DIV",{class:!0});var Oe=b(k);m(N.$$.fragment,Oe),Xe=r(Oe),ne=s(Oe,"P",{"data-svelte-h":!0}),l(ne)!=="svelte-1hrol74"&&(ne.textContent=jt),Oe.forEach(o),Ye=r(i),E=s(i,"DIV",{class:!0});var Se=b(E);m(U.$$.fragment,Se),Ze=r(Se),se=s(Se,"P",{"data-svelte-h":!0}),l(se)!=="svelte-1l6xdbj"&&(se.textContent=Ht),Se.forEach(o),et=r(i),I=s(i,"DIV",{class:!0});var We=b(I);m(O.$$.fragment,We),tt=r(We),oe=s(We,"P",{"data-svelte-h":!0}),l(oe)!=="svelte-wp66wq"&&(oe.textContent=Ft),We.forEach(o),at=r(i),w=s(i,"DIV",{class:!0});var we=b(w);m(S.$$.fragment,we),rt=r(we),de=s(we,"P",{"data-svelte-h":!0}),l(de)!=="svelte-1ybn6sj"&&(de.innerHTML=qt),nt=r(we),le=s(we,"P",{"data-svelte-h":!0}),l(le)!=="svelte-fvf2kw"&&(le.innerHTML=Vt),we.forEach(o),st=r(i),C=s(i,"DIV",{class:!0});var Ce=b(C);m(W.$$.fragment,Ce),ot=r(Ce),ie=s(Ce,"P",{"data-svelte-h":!0}),l(ie)!=="svelte-kun7ud"&&(ie.textContent=At),dt=r(Ce),ue=s(Ce,"P",{"data-svelte-h":!0}),l(ue)!=="svelte-1f1s101"&&(ue.innerHTML=Nt),Ce.forEach(o),lt=r(i),B=s(i,"DIV",{class:!0});var Be=b(B);m(z.$$.fragment,Be),it=r(Be),pe=s(Be,"P",{"data-svelte-h":!0}),l(pe)!=="svelte-4dpw8p"&&(pe.textContent=Ut),ut=r(Be),ce=s(Be,"P",{"data-svelte-h":!0}),l(ce)!=="svelte-y2ktyw"&&(ce.innerHTML=Ot),Be.forEach(o),pt=r(i),j=s(i,"DIV",{class:!0});var ze=b(j);m(R.$$.fragment,ze),ct=r(ze),me=s(ze,"P",{"data-svelte-h":!0}),l(me)!=="svelte-2eloeq"&&(me.textContent=St),ze.forEach(o),i.forEach(o),qe=r(e),m(G.$$.fragment,e),Ve=r(e),p=s(e,"DIV",{class:!0});var T=b(p);m(J.$$.fragment,T),mt=r(T),fe=s(T,"P",{"data-svelte-h":!0}),l(fe)!=="svelte-1fdxdjn"&&(fe.textContent=Wt),ft=r(T),x=s(T,"DIV",{class:!0});var H=b(x);m(K.$$.fragment,H),gt=r(H),ge=s(H,"P",{"data-svelte-h":!0}),l(ge)!=="svelte-950rwb"&&(ge.textContent=zt),ht=r(H),he=s(H,"P",{"data-svelte-h":!0}),l(he)!=="svelte-1nnxg1l"&&(he.textContent=Rt),_t=r(H),_e=s(H,"P",{"data-svelte-h":!0}),l(_e)!=="svelte-1vxxy19"&&(_e.textContent=Gt),H.forEach(o),bt=r(T),L=s(T,"DIV",{class:!0});var Le=b(L);m(Q.$$.fragment,Le),vt=r(Le),be=s(Le,"P",{"data-svelte-h":!0}),l(be)!=="svelte-2or2k8"&&(be.textContent=Jt),$t=r(Le),ve=s(Le,"P",{"data-svelte-h":!0}),l(ve)!=="svelte-ujp0ui"&&(ve.textContent=Kt),Le.forEach(o),yt=r(T),P=s(T,"DIV",{class:!0});var Pe=b(P);m(X.$$.fragment,Pe),xt=r(Pe),$e=s(Pe,"P",{"data-svelte-h":!0}),l($e)!=="svelte-6rdpda"&&($e.textContent=Qt),Tt=r(Pe),ye=s(Pe,"P",{"data-svelte-h":!0}),l(ye)!=="svelte-dptqqh"&&(ye.textContent=Xt),Pe.forEach(o),wt=r(T),D=s(T,"DIV",{class:!0});var De=b(D);m(Y.$$.fragment,De),Ct=r(De),xe=s(De,"P",{"data-svelte-h":!0}),l(xe)!=="svelte-8teaja"&&(xe.textContent=Yt),Bt=r(De),Te=s(De,"P",{"data-svelte-h":!0}),l(Te)!=="svelte-1020tdh"&&(Te.textContent=Zt),De.forEach(o),T.forEach(o),Ae=r(e),m(Z.$$.fragment,e),Ne=r(e),ke=s(e,"P",{}),b(ke).forEach(o),this.h()},h(){v(M,"name","hf:doc:metadata"),v(M,"content",la),v(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,u){t(document.head,M),$(e,Ee,u),$(e,Me,u),$(e,Ie,u),f(F,e,u),$(e,je,u),$(e,q,u),$(e,He,u),f(V,e,u),$(e,Fe,u),$(e,d,u),f(A,d,null),t(d,Re),t(d,ee),t(d,Ge),t(d,te),t(d,Je),t(d,ae),t(d,Ke),t(d,re),t(d,Qe),t(d,k),f(N,k,null),t(k,Xe),t(k,ne),t(d,Ye),t(d,E),f(U,E,null),t(E,Ze),t(E,se),t(d,et),t(d,I),f(O,I,null),t(I,tt),t(I,oe),t(d,at),t(d,w),f(S,w,null),t(w,rt),t(w,de),t(w,nt),t(w,le),t(d,st),t(d,C),f(W,C,null),t(C,ot),t(C,ie),t(C,dt),t(C,ue),t(d,lt),t(d,B),f(z,B,null),t(B,it),t(B,pe),t(B,ut),t(B,ce),t(d,pt),t(d,j),f(R,j,null),t(j,ct),t(j,me),$(e,qe,u),f(G,e,u),$(e,Ve,u),$(e,p,u),f(J,p,null),t(p,mt),t(p,fe),t(p,ft),t(p,x),f(K,x,null),t(x,gt),t(x,ge),t(x,ht),t(x,he),t(x,_t),t(x,_e),t(p,bt),t(p,L),f(Q,L,null),t(L,vt),t(L,be),t(L,$t),t(L,ve),t(p,yt),t(p,P),f(X,P,null),t(P,xt),t(P,$e),t(P,Tt),t(P,ye),t(p,wt),t(p,D),f(Y,D,null),t(D,Ct),t(D,xe),t(D,Bt),t(D,Te),$(e,Ae,u),f(Z,e,u),$(e,Ne,u),$(e,ke,u),Ue=!0},p:ta,i(e){Ue||(g(F.$$.fragment,e),g(V.$$.fragment,e),g(A.$$.fragment,e),g(N.$$.fragment,e),g(U.$$.fragment,e),g(O.$$.fragment,e),g(S.$$.fragment,e),g(W.$$.fragment,e),g(z.$$.fragment,e),g(R.$$.fragment,e),g(G.$$.fragment,e),g(J.$$.fragment,e),g(K.$$.fragment,e),g(Q.$$.fragment,e),g(X.$$.fragment,e),g(Y.$$.fragment,e),g(Z.$$.fragment,e),Ue=!0)},o(e){h(F.$$.fragment,e),h(V.$$.fragment,e),h(A.$$.fragment,e),h(N.$$.fragment,e),h(U.$$.fragment,e),h(O.$$.fragment,e),h(S.$$.fragment,e),h(W.$$.fragment,e),h(z.$$.fragment,e),h(R.$$.fragment,e),h(G.$$.fragment,e),h(J.$$.fragment,e),h(K.$$.fragment,e),h(Q.$$.fragment,e),h(X.$$.fragment,e),h(Y.$$.fragment,e),h(Z.$$.fragment,e),Ue=!1},d(e){e&&(o(Ee),o(Me),o(Ie),o(je),o(q),o(He),o(Fe),o(d),o(qe),o(Ve),o(p),o(Ae),o(Ne),o(ke)),o(M),_(F,e),_(V,e),_(A),_(N),_(U),_(O),_(S),_(W),_(z),_(R),_(G,e),_(J),_(K),_(Q),_(X),_(Y),_(Z,e)}}}const la='{"title":"Tuners","local":"tuners","sections":[{"title":"BaseTuner","local":"peft.tuners.tuners_utils.BaseTuner","sections":[],"depth":2},{"title":"BaseTunerLayer","local":"peft.tuners.tuners_utils.BaseTunerLayer","sections":[],"depth":2}],"depth":1}';function ia(Pt){return aa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fa extends ra{constructor(M){super(),na(this,M,ia,da,ea,{})}}export{fa as component};
