import{s as At,a as ft,n as gt,o as Ct}from"../chunks/scheduler.1f027d5a.js";import{S as bt,i as $t,e as i,s as a,c as o,h as Bt,a as M,d as t,b as n,f as Xe,g as p,j as d,k as h,l as Zt,m as s,n as r,t as c,o as j,p as u}from"../chunks/index.5cb6ce42.js";import{C as qt}from"../chunks/CopyLLMTxtMenu.f7108191.js";import{D as Gt,C as J}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as y,E as Et}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function kt(He){let m,ql,Bl,Gl,U,El,I,kl,f,Vl,A,Se='<em>Authored by: <a href="https://huggingface.co/davidberenstein1957" rel="nofollow">David Berenstein</a> and <a href="https://huggingface.co/sdiazlor" rel="nofollow">Sara Han Díaz</a></em>',Wl,g,Ye='<li><strong>Libraries</strong>: <a href="https://github.com/argilla-io/argilla" rel="nofollow">argilla</a>, <a href="https://github.com/huggingface/huggingface_hub" rel="nofollow">hf-inference-endpoints</a></li> <li><strong>Components</strong>: <a href="https://distilabel.argilla.io/dev/components-gallery/steps/loaddatafromdicts/" rel="nofollow">LoadDataFromDicts</a>, <a href="https://distilabel.argilla.io/latest/components-gallery/tasks/ultrafeedback/" rel="nofollow">UltraFeedback</a>, <a href="https://distilabel.argilla.io/latest/components-gallery/steps/groupcolumns/" rel="nofollow">KeepColumns</a>, <a href="https://distilabel.argilla.io/latest/components-gallery/steps/textgenerationtoargilla/" rel="nofollow">PreferenceToArgilla</a>, <a href="https://distilabel.argilla.io/latest/components-gallery/llms/inferenceendpointsllm/" rel="nofollow">InferenceEndpointsLLM</a>, <a href="https://distilabel.argilla.io/latest/sections/how_to_guides/basic/step/global_step/" rel="nofollow">GlobalStep</a></li>',vl,C,ze='In this tutorial, we’ll use distilabel to clean a dataset using the LLMs as judges by providing AI feedback on the quality of the data. <a href="https://github.com/argilla-io/distilabel" rel="nofollow">distilabel</a> is a synthetic data and AI feedback framework for engineers who need fast, reliable and scalable pipelines based on verified research papers. Check the documentation <a href="https://distilabel.argilla.io/latest/" rel="nofollow">here</a>.',_l,b,Le='To evaluate the responses, we will use the <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">serverless HF Inference API</a> integrated with distilabel. This is free but rate-limited, allowing you to test and evaluate over 150,000 public models, or your own private models, via simple HTTP requests, with fast inference hosted on Hugging Face shared infrastructure. If you need more compute power, you can deploy your own inference endpoint with <a href="https://huggingface.co/docs/inference-endpoints/guides/create_endpoint" rel="nofollow">Hugging Face Inference Endpoints</a>.',Ql,$,De='Finally, to further curate the data, we will use <a href="https://github.com/argilla-io/argilla" rel="nofollow">Argilla</a>, which allows us to provide human feedback on the data quality. Argilla is a collaboration tool for AI engineers and domain experts who need to build high-quality datasets for their projects. Check the documentation <a href="https://docs.argilla.io/latest/" rel="nofollow">here</a>.',Nl,B,Rl,Z,xl,q,Pe="To complete this tutorial, you need to install the distilabel SDK and a few third-party libraries via pip.",Fl,G,Xl,E,Hl,k,Ke="Let’s make the required imports:",Sl,V,Yl,W,Oe="You’ll need an <code>HF_TOKEN</code> to use the HF Inference Endpoints. Login to use it directly within this notebook.",zl,v,Ll,_,Dl,Q,lt='You can skip this step or replace it with any other data evaluation tool, but the quality of your model will suffer from a lack of data quality, so we do recommend looking at your data. If you already deployed Argilla, you can skip this step. Otherwise, you can quickly deploy Argilla following <a href="https://docs.argilla.io/latest/getting_started/quickstart/" rel="nofollow">this guide</a>.',Pl,N,et="Along with that, you will need to install Argilla as a distilabel extra.",Kl,R,Ol,x,le,F,tt='In this case, we will clean a preference dataset, so we will use the <a href="https://huggingface.co/datasets/Intel/orca_dpo_pairs" rel="nofollow"><code>Intel/orca_dpo_pairs</code></a> dataset from the Hugging Face Hub.',ee,w,st,te,X,se,H,at="Next, we will shuffle the <code>chosen</code> and <code>rejected</code> columns to avoid any bias in the dataset.",ae,S,ne,Y,ie,z,Me,L,nt='A step is a block in a distilabel pipeline used to manipulate, generate, or evaluate data, among other tasks. A set of predefined steps is provided, but you can also create your <a href="https://distilabel.argilla.io/latest/sections/how_to_guides/basic/step/#defining-custom-steps" rel="nofollow">own custom steps</a>. Instead of preprocessing the data as in the previous section, it is possible to use a custom step to shuffle the columns. This step should be in a separate module to be imported and used in the pipeline. In this case, the pipeline would start by loading the <code>orca_dpo_pairs</code> dataset using the <code>LoadDataFromHub</code> step and then applying the <code>ShuffleStep</code>.',oe,D,pe,P,re,K,ce,O,it="To clean an existing preference dataset, we will need to define a <code>Pipeline</code> with all the necessary steps. However, a similar workflow can be used to clean an SFT dataset. Below, we will go over each step in detail.",je,ll,ue,el,Mt="We will use the dataset we just shuffled as source data.",de,tl,ot="<li>Component: <code>LoadDataFromDicts</code></li> <li>Input columns: <code>system</code>, <code>question</code>, <code>chosen</code>, <code>rejected</code>, <code>generations</code> and <code>order</code>, the same keys as in the loaded list of dictionaries.</li> <li>Output columns: <code>system</code>, <code>instruction</code>, <code>chosen</code>, <code>rejected</code>, <code>generations</code> and <code>order</code>. We will use <code>output_mappings</code> to rename the columns.</li>",Je,sl,ye,al,we,nl,pt='To evaluate the quality of the responses, we will use <a href="https://huggingface.co/meta-llama/Meta-Llama-3.1-70B-Instruct" rel="nofollow"><code>meta-llama/Meta-Llama-3.1-70B-Instruct</code></a>, applying the <code>UltraFeedback</code> task that judges the responses according to different dimensions (helpfulness, honesty, instruction-following, truthfulness). For an SFT dataset, you can use <a href="../papers/prometheus.md"><code>PrometheusEval</code></a> instead.',Te,il,rt="<li>Component: <code>UltraFeedback</code> task with LLMs using <code>InferenceEndpointsLLM</code></li> <li>Input columns: <code>instruction</code>, <code>generations</code></li> <li>Output columns: <code>ratings</code>, <code>rationales</code>, <code>distilabel_metadata</code>, <code>model_name</code></li>",he,Ml,ct='For your use case and to improve the results, you can use any <a href="https://distilabel.argilla.io/latest/components-gallery/llms/" rel="nofollow">other LLM of your choice</a>.',me,ol,Ue,pl,Ie,rl,jt="We will get rid of the unneeded columns.",fe,cl,ut="<li>Component: <code>KeepColumns</code></li> <li>Input columns: <code>system</code>, <code>instruction</code>, <code>chosen</code>, <code>rejected</code>, <code>generations</code>, <code>ratings</code>, <code>rationales</code>, <code>distilabel_metadata</code> and <code>model_name</code></li> <li>Output columns: <code>instruction</code>, <code>chosen</code>, <code>rejected</code>, <code>generations</code> and <code>order</code></li>",Ae,jl,ge,ul,Ce,dl,dt="You can use Argilla to further curate your data.",be,Jl,Jt="<li>Component: <code>PreferenceToArgilla</code> step</li> <li>Input columns: <code>instruction</code>, <code>generations</code>, <code>generation_models</code>, <code>ratings</code></li> <li>Output columns: <code>instruction</code>, <code>generations</code>, <code>generation_models</code>, <code>ratings</code></li>",$e,yl,Be,wl,Ze,Tl,yt="Below, you can see the full pipeline definition:",qe,hl,Ge,ml,wt="Let’s now run the pipeline and clean our preference dataset.",Ee,Ul,ke,Il,Tt='Let’s check it! If you have loaded the data to Argilla, you can <a href="https://docs.argilla.io/latest/how_to_guides/annotate/" rel="nofollow">start annotating in the Argilla UI</a>.',Ve,fl,ht='You can push the dataset to the Hub for sharing with the community and <a href="https://huggingface.co/docs/hub/datasets-viewer-embed" rel="nofollow">embed it to explore the data</a>.',We,Al,ve,T,mt,_e,gl,Qe,Cl,Ut="In this tutorial, we showcased the detailed steps to build a pipeline for cleaning a preference dataset using distilabel. However, you can customize this pipeline for your own use cases, such as cleaning an SFT dataset or adding custom steps.",Ne,bl,It="We used a preference dataset as our starting point and shuffled the data to avoid any bias. Next, we evaluated the responses using a model through the serverless Hugging Face Inference API, following the UltraFeedback standards. Finally, we kept the needed columns and used Argilla for further curation.",Re,$l,xe,Zl,Fe;return U=new Gt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/clean_dataset_judges_distilabel.ipynb"}]}}),I=new qt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),f=new y({props:{title:"Clean an Existing Preference Dataset with LLMs as Judges",local:"clean-an-existing-preference-dataset-with-llms-as-judges",headingTag:"h1"}}),B=new y({props:{title:"Getting Started",local:"getting-started",headingTag:"h2"}}),Z=new y({props:{title:"Install the dependencies",local:"install-the-dependencies",headingTag:"h3"}}),G=new J({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJkaXN0aWxhYmVsJTVCaGYtaW5mZXJlbmNlLWVuZHBvaW50cyU1RCUyMg==",highlighted:'!pip install <span class="hljs-string">&quot;distilabel[hf-inference-endpoints]&quot;</span>',wrap:!1}}),E=new J({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJ0cmFuc2Zvcm1lcnN+JTNENC4wJTIyJTIwJTIydG9yY2h+JTNEMi4wJTIy",highlighted:'!pip install <span class="hljs-string">&quot;transformers~=4.0&quot;</span> <span class="hljs-string">&quot;torch~=2.0&quot;</span>',wrap:!1}}),V=new J({props:{code:"aW1wb3J0JTIwcmFuZG9tJTBBJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZnJvbSUyMGRpc3RpbGFiZWwubGxtcyUyMGltcG9ydCUyMEluZmVyZW5jZUVuZHBvaW50c0xMTSUwQWZyb20lMjBkaXN0aWxhYmVsLnBpcGVsaW5lJTIwaW1wb3J0JTIwUGlwZWxpbmUlMEFmcm9tJTIwZGlzdGlsYWJlbC5zdGVwcyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBLZWVwQ29sdW1ucyUyQyUwQSUyMCUyMCUyMCUyMExvYWREYXRhRnJvbURpY3RzJTJDJTBBJTIwJTIwJTIwJTIwUHJlZmVyZW5jZVRvQXJnaWxsYSUyQyUwQSklMEFmcm9tJTIwZGlzdGlsYWJlbC5zdGVwcy50YXNrcyUyMGltcG9ydCUyMFVsdHJhRmVlZGJhY2s=",highlighted:`<span class="hljs-keyword">import</span> random

<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-keyword">from</span> distilabel.llms <span class="hljs-keyword">import</span> InferenceEndpointsLLM
<span class="hljs-keyword">from</span> distilabel.pipeline <span class="hljs-keyword">import</span> Pipeline
<span class="hljs-keyword">from</span> distilabel.steps <span class="hljs-keyword">import</span> (
    KeepColumns,
    LoadDataFromDicts,
    PreferenceToArgilla,
)
<span class="hljs-keyword">from</span> distilabel.steps.tasks <span class="hljs-keyword">import</span> UltraFeedback`,wrap:!1}}),v=new J({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbG9naW4lMEElMEFsb2dpbih0b2tlbiUzRG9zLmdldGVudiglMjJIRl9UT0tFTiUyMiklMkMlMjBhZGRfdG9fZ2l0X2NyZWRlbnRpYWwlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login

login(token=os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>), add_to_git_credential=<span class="hljs-literal">True</span>)`,wrap:!1}}),_=new y({props:{title:"(optional) Deploy Argilla",local:"optional-deploy-argilla",headingTag:"h3"}}),R=new J({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJkaXN0aWxhYmVsJTVCYXJnaWxsYSUyQyUyMGhmLWluZmVyZW5jZS1lbmRwb2ludHMlNUQlMjI=",highlighted:'!pip install <span class="hljs-string">&quot;distilabel[argilla, hf-inference-endpoints]&quot;</span>',wrap:!1}}),x=new y({props:{title:"The dataset",local:"the-dataset",headingTag:"h2"}}),X=new J({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJJbnRlbCUyRm9yY2FfZHBvX3BhaXJzJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiU1QiUzQTIwJTVEJTIyKQ==",highlighted:'dataset = load_dataset(<span class="hljs-string">&quot;Intel/orca_dpo_pairs&quot;</span>, split=<span class="hljs-string">&quot;train[:20]&quot;</span>)',wrap:!1}}),S=new J({props:{code:"ZGVmJTIwc2h1ZmZsZV9hbmRfdHJhY2soY2hvc2VuJTJDJTIwcmVqZWN0ZWQpJTNBJTBBJTIwJTIwJTIwJTIwcGFpciUyMCUzRCUyMCU1QmNob3NlbiUyQyUyMHJlamVjdGVkJTVEJTBBJTIwJTIwJTIwJTIwcmFuZG9tLnNodWZmbGUocGFpciklMEElMjAlMjAlMjAlMjBvcmRlciUyMCUzRCUyMCU1QiUyMmNob3NlbiUyMiUyMGlmJTIweCUyMCUzRCUzRCUyMGNob3NlbiUyMGVsc2UlMjAlMjJyZWplY3RlZCUyMiUyMGZvciUyMHglMjBpbiUyMHBhaXIlNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJnZW5lcmF0aW9ucyUyMiUzQSUyMHBhaXIlMkMlMjAlMjJvcmRlciUyMiUzQSUyMG9yZGVyJTdEJTBBJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKGxhbWJkYSUyMHglM0ElMjBzaHVmZmxlX2FuZF90cmFjayh4JTVCJTIyY2hvc2VuJTIyJTVEJTJDJTIweCU1QiUyMnJlamVjdGVkJTIyJTVEKSk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">shuffle_and_track</span>(<span class="hljs-params">chosen, rejected</span>):
    pair = [chosen, rejected]
    random.shuffle(pair)
    order = [<span class="hljs-string">&quot;chosen&quot;</span> <span class="hljs-keyword">if</span> x == chosen <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;rejected&quot;</span> <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> pair]
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;generations&quot;</span>: pair, <span class="hljs-string">&quot;order&quot;</span>: order}

dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> x: shuffle_and_track(x[<span class="hljs-string">&quot;chosen&quot;</span>], x[<span class="hljs-string">&quot;rejected&quot;</span>]))`,wrap:!1}}),Y=new J({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQudG9fbGlzdCgp",highlighted:"dataset = dataset.to_list()",wrap:!1}}),z=new y({props:{title:"(optional) Create a custom step",local:"optional-create-a-custom-step",headingTag:"h3"}}),D=new J({props:{code:"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",highlighted:`<span class="hljs-comment"># &quot;shuffle_step.py&quot;</span>
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> TYPE_CHECKING, <span class="hljs-type">List</span>
<span class="hljs-keyword">from</span> distilabel.steps <span class="hljs-keyword">import</span> GlobalStep, StepInput

<span class="hljs-keyword">if</span> TYPE_CHECKING:
    <span class="hljs-keyword">from</span> distilabel.steps.typing <span class="hljs-keyword">import</span> StepOutput
    
<span class="hljs-keyword">import</span> random

<span class="hljs-keyword">class</span> <span class="hljs-title class_">ShuffleStep</span>(<span class="hljs-title class_ inherited__">GlobalStep</span>):
<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">inputs</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-type">List</span>[<span class="hljs-built_in">str</span>]:
        <span class="hljs-keyword">return</span> [<span class="hljs-string">&quot;instruction&quot;</span>, <span class="hljs-string">&quot;chosen&quot;</span>, <span class="hljs-string">&quot;rejected&quot;</span>]

<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">outputs</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-type">List</span>[<span class="hljs-built_in">str</span>]:
        <span class="hljs-keyword">return</span> [<span class="hljs-string">&quot;instruction&quot;</span>, <span class="hljs-string">&quot;generations&quot;</span>, <span class="hljs-string">&quot;order&quot;</span>]

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">process</span>(<span class="hljs-params">self, inputs: StepInput</span>) -&gt; <span class="hljs-string">&quot;StepOutput&quot;</span>:
        outputs = []

        <span class="hljs-keyword">for</span> <span class="hljs-built_in">input</span> <span class="hljs-keyword">in</span> inputs:
            chosen = <span class="hljs-built_in">input</span>[<span class="hljs-string">&quot;chosen&quot;</span>]
            rejected = <span class="hljs-built_in">input</span>[<span class="hljs-string">&quot;rejected&quot;</span>]
            pair = [chosen, rejected]
            random.shuffle(pair)
            order = [<span class="hljs-string">&quot;chosen&quot;</span> <span class="hljs-keyword">if</span> x == chosen <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;rejected&quot;</span> <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> pair]
            
            outputs.append({<span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-built_in">input</span>[<span class="hljs-string">&quot;instruction&quot;</span>], <span class="hljs-string">&quot;generations&quot;</span>: pair, <span class="hljs-string">&quot;order&quot;</span>: order})

        <span class="hljs-keyword">yield</span> outputs`,wrap:!1}}),P=new J({props:{code:"ZnJvbSUyMHNodWZmbGVfc3RlcCUyMGltcG9ydCUyMFNodWZmbGVTdGVw",highlighted:'<span class="hljs-keyword">from</span> shuffle_step <span class="hljs-keyword">import</span> ShuffleStep',wrap:!1}}),K=new y({props:{title:"Define the pipeline",local:"define-the-pipeline",headingTag:"h2"}}),ll=new y({props:{title:"Load the dataset",local:"load-the-dataset",headingTag:"h3"}}),sl=new J({props:{code:"bG9hZF9kYXRhc2V0JTIwJTNEJTIwTG9hZERhdGFGcm9tRGljdHMoJTBBJTIwJTIwJTIwJTIwZGF0YSUzRGRhdGFzZXQlNUIlM0ExJTVEJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0X21hcHBpbmdzJTNEJTdCJTIycXVlc3Rpb24lMjIlM0ElMjAlMjJpbnN0cnVjdGlvbiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMHBpcGVsaW5lJTNEUGlwZWxpbmUobmFtZSUzRCUyMnNob3djYXNlLXBpcGVsaW5lJTIyKSUyQyUwQSklMEFsb2FkX2RhdGFzZXQubG9hZCgpJTBBbmV4dChsb2FkX2RhdGFzZXQucHJvY2VzcygpKQ==",highlighted:`load_dataset = LoadDataFromDicts(
    data=dataset[:<span class="hljs-number">1</span>],
    output_mappings={<span class="hljs-string">&quot;question&quot;</span>: <span class="hljs-string">&quot;instruction&quot;</span>},
    pipeline=Pipeline(name=<span class="hljs-string">&quot;showcase-pipeline&quot;</span>),
)
load_dataset.load()
<span class="hljs-built_in">next</span>(load_dataset.process())`,wrap:!1}}),al=new y({props:{title:"Evaluate the responses",local:"evaluate-the-responses",headingTag:"h3"}}),ol=new J({props:{code:"ZXZhbHVhdGVfcmVzcG9uc2VzJTIwJTNEJTIwVWx0cmFGZWVkYmFjayglMEElMjAlMjAlMjAlMjBhc3BlY3QlM0QlMjJvdmVyYWxsLXJhdGluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMGxsbSUzREluZmVyZW5jZUVuZHBvaW50c0xMTSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMuMS03MEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b2tlbml6ZXJfaWQlM0QlMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLjEtNzBCLUluc3RydWN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ2VuZXJhdGlvbl9rd2FyZ3MlM0QlN0IlMjJtYXhfbmV3X3Rva2VucyUyMiUzQSUyMDUxMiUyQyUyMCUyMnRlbXBlcmF0dXJlJTIyJTNBJTIwMC43JTdEJTJDJTBBJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMHBpcGVsaW5lJTNEUGlwZWxpbmUobmFtZSUzRCUyMnNob3djYXNlLXBpcGVsaW5lJTIyKSUyQyUwQSklMEFldmFsdWF0ZV9yZXNwb25zZXMubG9hZCgpJTBBbmV4dCglMEElMjAlMjAlMjAlMjBldmFsdWF0ZV9yZXNwb25zZXMucHJvY2VzcyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnN0cnVjdGlvbiUyMiUzQSUyMCUyMldoYXQncyUyMHRoZSUyMGNhcGl0YWwlMjBvZiUyMFNwYWluJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZ2VuZXJhdGlvbnMlMjIlM0ElMjAlNUIlMjJNYWRyaWQlMjIlMkMlMjAlMjJCYXJjZWxvbmElMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjApJTBBKQ==",highlighted:`evaluate_responses = UltraFeedback(
    aspect=<span class="hljs-string">&quot;overall-rating&quot;</span>,
    llm=InferenceEndpointsLLM(
        model_id=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-70B-Instruct&quot;</span>,
        tokenizer_id=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-70B-Instruct&quot;</span>,
        generation_kwargs={<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>},
    ),
    pipeline=Pipeline(name=<span class="hljs-string">&quot;showcase-pipeline&quot;</span>),
)
evaluate_responses.load()
<span class="hljs-built_in">next</span>(
    evaluate_responses.process(
        [
            {
                <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the capital of Spain?&quot;</span>,
                <span class="hljs-string">&quot;generations&quot;</span>: [<span class="hljs-string">&quot;Madrid&quot;</span>, <span class="hljs-string">&quot;Barcelona&quot;</span>],
            }
        ]
    )
)`,wrap:!1}}),pl=new y({props:{title:"Keep only the required columns",local:"keep-only-the-required-columns",headingTag:"h3"}}),jl=new J({props:{code:"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",highlighted:`keep_columns = KeepColumns(
    columns=[
        <span class="hljs-string">&quot;instruction&quot;</span>,
        <span class="hljs-string">&quot;generations&quot;</span>,
        <span class="hljs-string">&quot;order&quot;</span>,
        <span class="hljs-string">&quot;ratings&quot;</span>,
        <span class="hljs-string">&quot;rationales&quot;</span>,
        <span class="hljs-string">&quot;model_name&quot;</span>,
    ],
    pipeline=Pipeline(name=<span class="hljs-string">&quot;showcase-pipeline&quot;</span>),
)
keep_columns.load()
<span class="hljs-built_in">next</span>(
    keep_columns.process(
        [
            {
                <span class="hljs-string">&quot;system&quot;</span>: <span class="hljs-string">&quot;&quot;</span>,
                <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the capital of Spain?&quot;</span>,
                <span class="hljs-string">&quot;chosen&quot;</span>: <span class="hljs-string">&quot;Madrid&quot;</span>,
                <span class="hljs-string">&quot;rejected&quot;</span>: <span class="hljs-string">&quot;Barcelona&quot;</span>,
                <span class="hljs-string">&quot;generations&quot;</span>: [<span class="hljs-string">&quot;Madrid&quot;</span>, <span class="hljs-string">&quot;Barcelona&quot;</span>],
                <span class="hljs-string">&quot;order&quot;</span>: [<span class="hljs-string">&quot;chosen&quot;</span>, <span class="hljs-string">&quot;rejected&quot;</span>],
                <span class="hljs-string">&quot;ratings&quot;</span>: [<span class="hljs-number">5</span>, <span class="hljs-number">1</span>],
                <span class="hljs-string">&quot;rationales&quot;</span>: [<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;&quot;</span>],
                <span class="hljs-string">&quot;model_name&quot;</span>: <span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-70B-Instruct&quot;</span>,
            }
        ]
    )
)`,wrap:!1}}),ul=new y({props:{title:"(Optional) Further data curation",local:"optional-further-data-curation",headingTag:"h3"}}),yl=new J({props:{code:"dG9fYXJnaWxsYSUyMCUzRCUyMFByZWZlcmVuY2VUb0FyZ2lsbGEoJTBBJTIwJTIwJTIwJTIwZGF0YXNldF9uYW1lJTNEJTIyY2xlYW5lZC1kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwZGF0YXNldF93b3Jrc3BhY2UlM0QlMjJhcmdpbGxhJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpX3VybCUzRCUyMmh0dHBzJTNBJTJGJTJGJTVCeW91ci1vd25lci1uYW1lJTVELSU1QnlvdXItc3BhY2UtbmFtZSU1RC5oZi5zcGFjZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0QlMjIlNUJ5b3VyLWFwaS1rZXklNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBudW1fZ2VuZXJhdGlvbnMlM0QyJTBBKQ==",highlighted:`to_argilla = PreferenceToArgilla(
    dataset_name=<span class="hljs-string">&quot;cleaned-dataset&quot;</span>,
    dataset_workspace=<span class="hljs-string">&quot;argilla&quot;</span>,
    api_url=<span class="hljs-string">&quot;https://[your-owner-name]-[your-space-name].hf.space&quot;</span>,
    api_key=<span class="hljs-string">&quot;[your-api-key]&quot;</span>,
    num_generations=<span class="hljs-number">2</span>
)`,wrap:!1}}),wl=new y({props:{title:"Run the pipeline",local:"run-the-pipeline",headingTag:"h2"}}),hl=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">with</span> Pipeline(name=<span class="hljs-string">&quot;clean-dataset&quot;</span>) <span class="hljs-keyword">as</span> pipeline:

    load_dataset = LoadDataFromDicts(
        data=dataset, output_mappings={<span class="hljs-string">&quot;question&quot;</span>: <span class="hljs-string">&quot;instruction&quot;</span>}
    )

    evaluate_responses = UltraFeedback(
        aspect=<span class="hljs-string">&quot;overall-rating&quot;</span>,
        llm=InferenceEndpointsLLM(
            model_id=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-70B-Instruct&quot;</span>,
            tokenizer_id=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-70B-Instruct&quot;</span>,
            generation_kwargs={<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>},
        ),
    )

    keep_columns = KeepColumns(
        columns=[
            <span class="hljs-string">&quot;instruction&quot;</span>,
            <span class="hljs-string">&quot;generations&quot;</span>,
            <span class="hljs-string">&quot;order&quot;</span>,
            <span class="hljs-string">&quot;ratings&quot;</span>,
            <span class="hljs-string">&quot;rationales&quot;</span>,
            <span class="hljs-string">&quot;model_name&quot;</span>,
        ]
    )

    to_argilla = PreferenceToArgilla(
        dataset_name=<span class="hljs-string">&quot;cleaned-dataset&quot;</span>,
        dataset_workspace=<span class="hljs-string">&quot;argilla&quot;</span>,
        api_url=<span class="hljs-string">&quot;https://[your-owner-name]-[your-space-name].hf.space&quot;</span>,
        api_key=<span class="hljs-string">&quot;[your-api-key]&quot;</span>,
        num_generations=<span class="hljs-number">2</span>,
    )

    load_dataset.connect(evaluate_responses)
    evaluate_responses.connect(keep_columns)
    keep_columns.connect(to_argilla)`,wrap:!1}}),Ul=new J({props:{code:"ZGlzdGlzZXQlMjAlM0QlMjBwaXBlbGluZS5ydW4oKQ==",highlighted:"distiset = pipeline.run()",wrap:!1}}),Al=new J({props:{code:"ZGlzdGlzZXQucHVzaF90b19odWIoJTIyJTVCeW91ci1vd25lci1uYW1lJTVEJTJGZXhhbXBsZS1jbGVhbmVkLXByZWZlcmVuY2UtZGF0YXNldCUyMik=",highlighted:'distiset.push_to_hub(<span class="hljs-string">&quot;[your-owner-name]/example-cleaned-preference-dataset&quot;</span>)',wrap:!1}}),gl=new y({props:{title:"Conclusions",local:"conclusions",headingTag:"h2"}}),$l=new Et({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/clean_dataset_judges_distilabel.md"}}),{c(){m=i("meta"),ql=a(),Bl=i("p"),Gl=a(),o(U.$$.fragment),El=a(),o(I.$$.fragment),kl=a(),o(f.$$.fragment),Vl=a(),A=i("p"),A.innerHTML=Se,Wl=a(),g=i("ul"),g.innerHTML=Ye,vl=a(),C=i("p"),C.innerHTML=ze,_l=a(),b=i("p"),b.innerHTML=Le,Ql=a(),$=i("p"),$.innerHTML=De,Nl=a(),o(B.$$.fragment),Rl=a(),o(Z.$$.fragment),xl=a(),q=i("p"),q.textContent=Pe,Fl=a(),o(G.$$.fragment),Xl=a(),o(E.$$.fragment),Hl=a(),k=i("p"),k.textContent=Ke,Sl=a(),o(V.$$.fragment),Yl=a(),W=i("p"),W.innerHTML=Oe,zl=a(),o(v.$$.fragment),Ll=a(),o(_.$$.fragment),Dl=a(),Q=i("p"),Q.innerHTML=lt,Pl=a(),N=i("p"),N.textContent=et,Kl=a(),o(R.$$.fragment),Ol=a(),o(x.$$.fragment),le=a(),F=i("p"),F.innerHTML=tt,ee=a(),w=i("iframe"),te=a(),o(X.$$.fragment),se=a(),H=i("p"),H.innerHTML=at,ae=a(),o(S.$$.fragment),ne=a(),o(Y.$$.fragment),ie=a(),o(z.$$.fragment),Me=a(),L=i("p"),L.innerHTML=nt,oe=a(),o(D.$$.fragment),pe=a(),o(P.$$.fragment),re=a(),o(K.$$.fragment),ce=a(),O=i("p"),O.innerHTML=it,je=a(),o(ll.$$.fragment),ue=a(),el=i("p"),el.textContent=Mt,de=a(),tl=i("ul"),tl.innerHTML=ot,Je=a(),o(sl.$$.fragment),ye=a(),o(al.$$.fragment),we=a(),nl=i("p"),nl.innerHTML=pt,Te=a(),il=i("ul"),il.innerHTML=rt,he=a(),Ml=i("p"),Ml.innerHTML=ct,me=a(),o(ol.$$.fragment),Ue=a(),o(pl.$$.fragment),Ie=a(),rl=i("p"),rl.textContent=jt,fe=a(),cl=i("ul"),cl.innerHTML=ut,Ae=a(),o(jl.$$.fragment),ge=a(),o(ul.$$.fragment),Ce=a(),dl=i("p"),dl.textContent=dt,be=a(),Jl=i("ul"),Jl.innerHTML=Jt,$e=a(),o(yl.$$.fragment),Be=a(),o(wl.$$.fragment),Ze=a(),Tl=i("p"),Tl.textContent=yt,qe=a(),o(hl.$$.fragment),Ge=a(),ml=i("p"),ml.textContent=wt,Ee=a(),o(Ul.$$.fragment),ke=a(),Il=i("p"),Il.innerHTML=Tt,Ve=a(),fl=i("p"),fl.innerHTML=ht,We=a(),o(Al.$$.fragment),ve=a(),T=i("iframe"),_e=a(),o(gl.$$.fragment),Qe=a(),Cl=i("p"),Cl.textContent=Ut,Ne=a(),bl=i("p"),bl.textContent=It,Re=a(),o($l.$$.fragment),xe=a(),Zl=i("p"),this.h()},l(l){const e=Bt("svelte-u9bgzb",document.head);m=M(e,"META",{name:!0,content:!0}),e.forEach(t),ql=n(l),Bl=M(l,"P",{}),Xe(Bl).forEach(t),Gl=n(l),p(U.$$.fragment,l),El=n(l),p(I.$$.fragment,l),kl=n(l),p(f.$$.fragment,l),Vl=n(l),A=M(l,"P",{"data-svelte-h":!0}),d(A)!=="svelte-gisfdz"&&(A.innerHTML=Se),Wl=n(l),g=M(l,"UL",{"data-svelte-h":!0}),d(g)!=="svelte-mbqi7c"&&(g.innerHTML=Ye),vl=n(l),C=M(l,"P",{"data-svelte-h":!0}),d(C)!=="svelte-1upfgij"&&(C.innerHTML=ze),_l=n(l),b=M(l,"P",{"data-svelte-h":!0}),d(b)!=="svelte-13wpfbf"&&(b.innerHTML=Le),Ql=n(l),$=M(l,"P",{"data-svelte-h":!0}),d($)!=="svelte-1tx7tfk"&&($.innerHTML=De),Nl=n(l),p(B.$$.fragment,l),Rl=n(l),p(Z.$$.fragment,l),xl=n(l),q=M(l,"P",{"data-svelte-h":!0}),d(q)!=="svelte-3bna4r"&&(q.textContent=Pe),Fl=n(l),p(G.$$.fragment,l),Xl=n(l),p(E.$$.fragment,l),Hl=n(l),k=M(l,"P",{"data-svelte-h":!0}),d(k)!=="svelte-1efpmun"&&(k.textContent=Ke),Sl=n(l),p(V.$$.fragment,l),Yl=n(l),W=M(l,"P",{"data-svelte-h":!0}),d(W)!=="svelte-a7dt3m"&&(W.innerHTML=Oe),zl=n(l),p(v.$$.fragment,l),Ll=n(l),p(_.$$.fragment,l),Dl=n(l),Q=M(l,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-104zazh"&&(Q.innerHTML=lt),Pl=n(l),N=M(l,"P",{"data-svelte-h":!0}),d(N)!=="svelte-nd7qbb"&&(N.textContent=et),Kl=n(l),p(R.$$.fragment,l),Ol=n(l),p(x.$$.fragment,l),le=n(l),F=M(l,"P",{"data-svelte-h":!0}),d(F)!=="svelte-n55nu"&&(F.innerHTML=tt),ee=n(l),w=M(l,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Xe(w).forEach(t),te=n(l),p(X.$$.fragment,l),se=n(l),H=M(l,"P",{"data-svelte-h":!0}),d(H)!=="svelte-tyuym6"&&(H.innerHTML=at),ae=n(l),p(S.$$.fragment,l),ne=n(l),p(Y.$$.fragment,l),ie=n(l),p(z.$$.fragment,l),Me=n(l),L=M(l,"P",{"data-svelte-h":!0}),d(L)!=="svelte-82wvvi"&&(L.innerHTML=nt),oe=n(l),p(D.$$.fragment,l),pe=n(l),p(P.$$.fragment,l),re=n(l),p(K.$$.fragment,l),ce=n(l),O=M(l,"P",{"data-svelte-h":!0}),d(O)!=="svelte-1torx5s"&&(O.innerHTML=it),je=n(l),p(ll.$$.fragment,l),ue=n(l),el=M(l,"P",{"data-svelte-h":!0}),d(el)!=="svelte-1tymi5a"&&(el.textContent=Mt),de=n(l),tl=M(l,"UL",{"data-svelte-h":!0}),d(tl)!=="svelte-62eraq"&&(tl.innerHTML=ot),Je=n(l),p(sl.$$.fragment,l),ye=n(l),p(al.$$.fragment,l),we=n(l),nl=M(l,"P",{"data-svelte-h":!0}),d(nl)!=="svelte-z2q9he"&&(nl.innerHTML=pt),Te=n(l),il=M(l,"UL",{"data-svelte-h":!0}),d(il)!=="svelte-1lich0g"&&(il.innerHTML=rt),he=n(l),Ml=M(l,"P",{"data-svelte-h":!0}),d(Ml)!=="svelte-wb9t0n"&&(Ml.innerHTML=ct),me=n(l),p(ol.$$.fragment,l),Ue=n(l),p(pl.$$.fragment,l),Ie=n(l),rl=M(l,"P",{"data-svelte-h":!0}),d(rl)!=="svelte-yp3cey"&&(rl.textContent=jt),fe=n(l),cl=M(l,"UL",{"data-svelte-h":!0}),d(cl)!=="svelte-hoflav"&&(cl.innerHTML=ut),Ae=n(l),p(jl.$$.fragment,l),ge=n(l),p(ul.$$.fragment,l),Ce=n(l),dl=M(l,"P",{"data-svelte-h":!0}),d(dl)!=="svelte-1x55czc"&&(dl.textContent=dt),be=n(l),Jl=M(l,"UL",{"data-svelte-h":!0}),d(Jl)!=="svelte-sera5w"&&(Jl.innerHTML=Jt),$e=n(l),p(yl.$$.fragment,l),Be=n(l),p(wl.$$.fragment,l),Ze=n(l),Tl=M(l,"P",{"data-svelte-h":!0}),d(Tl)!=="svelte-z5tzhe"&&(Tl.textContent=yt),qe=n(l),p(hl.$$.fragment,l),Ge=n(l),ml=M(l,"P",{"data-svelte-h":!0}),d(ml)!=="svelte-io3h18"&&(ml.textContent=wt),Ee=n(l),p(Ul.$$.fragment,l),ke=n(l),Il=M(l,"P",{"data-svelte-h":!0}),d(Il)!=="svelte-1gqov0s"&&(Il.innerHTML=Tt),Ve=n(l),fl=M(l,"P",{"data-svelte-h":!0}),d(fl)!=="svelte-1cen2j5"&&(fl.innerHTML=ht),We=n(l),p(Al.$$.fragment,l),ve=n(l),T=M(l,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Xe(T).forEach(t),_e=n(l),p(gl.$$.fragment,l),Qe=n(l),Cl=M(l,"P",{"data-svelte-h":!0}),d(Cl)!=="svelte-ct6t5z"&&(Cl.textContent=Ut),Ne=n(l),bl=M(l,"P",{"data-svelte-h":!0}),d(bl)!=="svelte-u277as"&&(bl.textContent=It),Re=n(l),p($l.$$.fragment,l),xe=n(l),Zl=M(l,"P",{}),Xe(Zl).forEach(t),this.h()},h(){h(m,"name","hf:doc:metadata"),h(m,"content",Vt),ft(w.src,st="https://huggingface.co/datasets/Intel/orca_dpo_pairs/embed/viewer/default/train")||h(w,"src",st),h(w,"frameborder","0"),h(w,"width","100%"),h(w,"height","560px"),ft(T.src,mt="https://huggingface.co/datasets/distilabel-internal-testing/example-cleaned-preference-dataset/embed/viewer/default/train")||h(T,"src",mt),h(T,"frameborder","0"),h(T,"width","100%"),h(T,"height","560px")},m(l,e){Zt(document.head,m),s(l,ql,e),s(l,Bl,e),s(l,Gl,e),r(U,l,e),s(l,El,e),r(I,l,e),s(l,kl,e),r(f,l,e),s(l,Vl,e),s(l,A,e),s(l,Wl,e),s(l,g,e),s(l,vl,e),s(l,C,e),s(l,_l,e),s(l,b,e),s(l,Ql,e),s(l,$,e),s(l,Nl,e),r(B,l,e),s(l,Rl,e),r(Z,l,e),s(l,xl,e),s(l,q,e),s(l,Fl,e),r(G,l,e),s(l,Xl,e),r(E,l,e),s(l,Hl,e),s(l,k,e),s(l,Sl,e),r(V,l,e),s(l,Yl,e),s(l,W,e),s(l,zl,e),r(v,l,e),s(l,Ll,e),r(_,l,e),s(l,Dl,e),s(l,Q,e),s(l,Pl,e),s(l,N,e),s(l,Kl,e),r(R,l,e),s(l,Ol,e),r(x,l,e),s(l,le,e),s(l,F,e),s(l,ee,e),s(l,w,e),s(l,te,e),r(X,l,e),s(l,se,e),s(l,H,e),s(l,ae,e),r(S,l,e),s(l,ne,e),r(Y,l,e),s(l,ie,e),r(z,l,e),s(l,Me,e),s(l,L,e),s(l,oe,e),r(D,l,e),s(l,pe,e),r(P,l,e),s(l,re,e),r(K,l,e),s(l,ce,e),s(l,O,e),s(l,je,e),r(ll,l,e),s(l,ue,e),s(l,el,e),s(l,de,e),s(l,tl,e),s(l,Je,e),r(sl,l,e),s(l,ye,e),r(al,l,e),s(l,we,e),s(l,nl,e),s(l,Te,e),s(l,il,e),s(l,he,e),s(l,Ml,e),s(l,me,e),r(ol,l,e),s(l,Ue,e),r(pl,l,e),s(l,Ie,e),s(l,rl,e),s(l,fe,e),s(l,cl,e),s(l,Ae,e),r(jl,l,e),s(l,ge,e),r(ul,l,e),s(l,Ce,e),s(l,dl,e),s(l,be,e),s(l,Jl,e),s(l,$e,e),r(yl,l,e),s(l,Be,e),r(wl,l,e),s(l,Ze,e),s(l,Tl,e),s(l,qe,e),r(hl,l,e),s(l,Ge,e),s(l,ml,e),s(l,Ee,e),r(Ul,l,e),s(l,ke,e),s(l,Il,e),s(l,Ve,e),s(l,fl,e),s(l,We,e),r(Al,l,e),s(l,ve,e),s(l,T,e),s(l,_e,e),r(gl,l,e),s(l,Qe,e),s(l,Cl,e),s(l,Ne,e),s(l,bl,e),s(l,Re,e),r($l,l,e),s(l,xe,e),s(l,Zl,e),Fe=!0},p:gt,i(l){Fe||(c(U.$$.fragment,l),c(I.$$.fragment,l),c(f.$$.fragment,l),c(B.$$.fragment,l),c(Z.$$.fragment,l),c(G.$$.fragment,l),c(E.$$.fragment,l),c(V.$$.fragment,l),c(v.$$.fragment,l),c(_.$$.fragment,l),c(R.$$.fragment,l),c(x.$$.fragment,l),c(X.$$.fragment,l),c(S.$$.fragment,l),c(Y.$$.fragment,l),c(z.$$.fragment,l),c(D.$$.fragment,l),c(P.$$.fragment,l),c(K.$$.fragment,l),c(ll.$$.fragment,l),c(sl.$$.fragment,l),c(al.$$.fragment,l),c(ol.$$.fragment,l),c(pl.$$.fragment,l),c(jl.$$.fragment,l),c(ul.$$.fragment,l),c(yl.$$.fragment,l),c(wl.$$.fragment,l),c(hl.$$.fragment,l),c(Ul.$$.fragment,l),c(Al.$$.fragment,l),c(gl.$$.fragment,l),c($l.$$.fragment,l),Fe=!0)},o(l){j(U.$$.fragment,l),j(I.$$.fragment,l),j(f.$$.fragment,l),j(B.$$.fragment,l),j(Z.$$.fragment,l),j(G.$$.fragment,l),j(E.$$.fragment,l),j(V.$$.fragment,l),j(v.$$.fragment,l),j(_.$$.fragment,l),j(R.$$.fragment,l),j(x.$$.fragment,l),j(X.$$.fragment,l),j(S.$$.fragment,l),j(Y.$$.fragment,l),j(z.$$.fragment,l),j(D.$$.fragment,l),j(P.$$.fragment,l),j(K.$$.fragment,l),j(ll.$$.fragment,l),j(sl.$$.fragment,l),j(al.$$.fragment,l),j(ol.$$.fragment,l),j(pl.$$.fragment,l),j(jl.$$.fragment,l),j(ul.$$.fragment,l),j(yl.$$.fragment,l),j(wl.$$.fragment,l),j(hl.$$.fragment,l),j(Ul.$$.fragment,l),j(Al.$$.fragment,l),j(gl.$$.fragment,l),j($l.$$.fragment,l),Fe=!1},d(l){l&&(t(ql),t(Bl),t(Gl),t(El),t(kl),t(Vl),t(A),t(Wl),t(g),t(vl),t(C),t(_l),t(b),t(Ql),t($),t(Nl),t(Rl),t(xl),t(q),t(Fl),t(Xl),t(Hl),t(k),t(Sl),t(Yl),t(W),t(zl),t(Ll),t(Dl),t(Q),t(Pl),t(N),t(Kl),t(Ol),t(le),t(F),t(ee),t(w),t(te),t(se),t(H),t(ae),t(ne),t(ie),t(Me),t(L),t(oe),t(pe),t(re),t(ce),t(O),t(je),t(ue),t(el),t(de),t(tl),t(Je),t(ye),t(we),t(nl),t(Te),t(il),t(he),t(Ml),t(me),t(Ue),t(Ie),t(rl),t(fe),t(cl),t(Ae),t(ge),t(Ce),t(dl),t(be),t(Jl),t($e),t(Be),t(Ze),t(Tl),t(qe),t(Ge),t(ml),t(Ee),t(ke),t(Il),t(Ve),t(fl),t(We),t(ve),t(T),t(_e),t(Qe),t(Cl),t(Ne),t(bl),t(Re),t(xe),t(Zl)),t(m),u(U,l),u(I,l),u(f,l),u(B,l),u(Z,l),u(G,l),u(E,l),u(V,l),u(v,l),u(_,l),u(R,l),u(x,l),u(X,l),u(S,l),u(Y,l),u(z,l),u(D,l),u(P,l),u(K,l),u(ll,l),u(sl,l),u(al,l),u(ol,l),u(pl,l),u(jl,l),u(ul,l),u(yl,l),u(wl,l),u(hl,l),u(Ul,l),u(Al,l),u(gl,l),u($l,l)}}}const Vt='{"title":"Clean an Existing Preference Dataset with LLMs as Judges","local":"clean-an-existing-preference-dataset-with-llms-as-judges","sections":[{"title":"Getting Started","local":"getting-started","sections":[{"title":"Install the dependencies","local":"install-the-dependencies","sections":[],"depth":3},{"title":"(optional) Deploy Argilla","local":"optional-deploy-argilla","sections":[],"depth":3}],"depth":2},{"title":"The dataset","local":"the-dataset","sections":[{"title":"(optional) Create a custom step","local":"optional-create-a-custom-step","sections":[],"depth":3}],"depth":2},{"title":"Define the pipeline","local":"define-the-pipeline","sections":[{"title":"Load the dataset","local":"load-the-dataset","sections":[],"depth":3},{"title":"Evaluate the responses","local":"evaluate-the-responses","sections":[],"depth":3},{"title":"Keep only the required columns","local":"keep-only-the-required-columns","sections":[],"depth":3},{"title":"(Optional) Further data curation","local":"optional-further-data-curation","sections":[],"depth":3}],"depth":2},{"title":"Run the pipeline","local":"run-the-pipeline","sections":[],"depth":2},{"title":"Conclusions","local":"conclusions","sections":[],"depth":2}],"depth":1}';function Wt(He){return Ct(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xt extends bt{constructor(m){super(),$t(this,m,Wt,kt,At,{})}}export{xt as component};
