import{s as qe,n as Le,o as De}from"../chunks/scheduler.1f027d5a.js";import{S as Ke,i as Oe,e as d,s as a,c as p,h as Pe,a as J,d as s,b as n,f as He,g as i,j as h,k as Se,l as ls,m as t,n as o,t as r,o as c,p as m}from"../chunks/index.5cb6ce42.js";import{C as es}from"../chunks/CopyLLMTxtMenu.f7108191.js";import{D as ss,C as M}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as wl,E as ts}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function as(Ie){let y,Tl,Ul,fl,u,jl,w,gl,U,Il,b,Re='<em>Authored by: <a href="https://github.com/MrzEsma" rel="nofollow">Mohammadreza Esmaeiliyan</a></em>',Rl,T,_e='In this notebook, we have attempted to fine-tune a large language model with no added complexity. The model has been optimized for use on a customer-level GPU to generate Persian product catalogs and produce structured output in JSON format. It is particularly effective for creating structured outputs from the unstructured titles and descriptions of products on Iranian platforms with user-generated content, such as <a href="https://basalam.com" rel="nofollow">Basalam</a>, <a href="https://divar.ir/" rel="nofollow">Divar</a>, <a href="https://www.digikala.com/" rel="nofollow">Digikala</a>, and others.',_l,f,Ze='You can see a fine-tuned LLM with this code on <a href="https://huggingface.co/BaSalam/Llama2-7b-entity-attr-v1" rel="nofollow">our HF account</a>. Additionally, one of the fastest open-source inference engines, <a href="https://github.com/vllm-project/vllm" rel="nofollow">Vllm</a>, is employed for inference.',Zl,j,Ce="Let’s get started!",Cl,g,Xl,I,Xe='The <code>peft</code> library, or parameter efficient fine tuning, has been created to fine-tune LLMs more efficiently. If we were to open and fine-tune the upper layers of the network traditionally like all neural networks, it would require a lot of processing and also a significant amount of VRAM. With the methods developed in recent papers, this library has been implemented for efficient fine-tuning of LLMs. Read more about peft here: <a href="https://huggingface.co/blog/peft" rel="nofollow">Hugging Face PEFT</a>.',Bl,R,Gl,_,Ql,Z,Vl,C,Be="LoRA (Low-Rank Adaptation) stores changes in weights by constructing and adding a low-rank matrix to each model layer. This method opens only these layers for fine-tuning, without changing the original model weights or requiring lengthy training. The resulting weights are lightweight and can be produced multiple times, allowing for the fine-tuning of multiple tasks with an LLM loaded into RAM.",Wl,X,Ge='Read about LoRA <a href="https://lightning.ai/pages/community/tutorial/lora-llm/" rel="nofollow">here at Lightning AI</a>. For other efficient training methods, see <a href="https://huggingface.co/docs/transformers/perf_train_gpu_one" rel="nofollow">Hugging Face Docs on Performance Training</a> and <a href="https://huggingface.co/docs/trl/main/en/sft_trainer#enhance-models-performances-using-neftune" rel="nofollow">SFT Trainer Enhancement</a>.',kl,B,Fl,G,Qe="QLoRA (Quantized Low-Rank Adaptation) is an efficient fine-tuning approach that enables large language models to run on smaller GPUs by using 4-bit quantization. This method preserves the full performance of 16-bit fine-tuning while reducing memory usage, making it possible to fine-tune models with up to 65 billion parameters on a single 48GB GPU. QLoRA combines 4-bit NormalFloat data types, double quantization, and paged optimizers to manage memory efficiently. It allows fine-tuning of models with low-rank adapters, significantly enhancing accessibility for AI model development.",Nl,Q,Ve='Read about QLoRA <a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">here at Hugging Face</a>.',$l,V,El,W,vl,k,Yl,F,Al,N,We="The LoraConfig object is used to configure the LoRA (Low-Rank Adaptation) settings for the model when using the Peft library. This can help to reduce the number of parameters that need to be fine-tuned, which can lead to faster training and lower memory usage. Here’s a breakdown of the parameters:",zl,$,ke="<li><code>r</code>: The rank of the low-rank matrices used in LoRA. This parameter controls the dimensionality of the low-rank adaptation and directly impacts the model’s capacity to adapt and the computational cost.</li> <li><code>lora_alpha</code>: This parameter controls the scaling factor for the low-rank adaptation matrices. A higher alpha value can increase the model’s capacity to learn new tasks.</li> <li><code>lora_dropout</code>: The dropout rate for LoRA. This can help to prevent overfitting during fine-tuning. In this case, it’s set to 0.1.</li> <li><code>bias</code>: Specifies whether to add a bias term to the low-rank matrices. In this case, it’s set to “none”, which means that no bias term will be added.</li> <li><code>task_type</code>: Defines the type of task for which the model is being fine-tuned. Here, “CAUSAL_LM” indicates that the task is a causal language modeling task, which predicts the next word in a sequence.</li> <li><code>target_modules</code>: Specifies the modules in the model to which LoRA will be applied. In this case, it’s set to <code>[&quot;q_proj&quot;, &quot;v_proj&quot;, &#39;k_proj&#39;]</code>, which are the query, value, and key projection layers in the model’s attention mechanism.</li>",xl,E,Hl,v,Fe="This block configures the settings for using BitsAndBytes (bnb), a library that provides efficient memory management and compression techniques for PyTorch models. Specifically, it defines how the model weights will be loaded and quantized in 4-bit precision, which is useful for reducing memory usage and potentially speeding up inference.",Sl,Y,Ne="<li><code>load_in_4bit</code>: A boolean that determines whether to load the model in 4-bit precision.</li> <li><code>bnb_4bit_quant_type</code>: Specifies the type of 4-bit quantization to use. Here, it’s set to 4-bit NormalFloat (NF4) quantization type, which is a new data type introduced in QLoRA. This type is information-theoretically optimal for normally distributed weights, providing an efficient way to quantize the model for fine-tuning.</li> <li><code>bnb_4bit_compute_dtype</code>: Sets the data type used for computations involving the quantized model. In QLoRA, it’s set to “float16”, which is commonly used for mixed-precision training to balance performance and precision.</li> <li><code>bnb_4bit_use_double_quant</code>: This boolean parameter indicates whether to use double quantization. Setting it to False means that only single quantization will be used, which is typically faster but might be slightly less accurate.</li>",ql,A,$e=`Why we have two data type (quant_type and compute_type)?
QLoRA employs two distinct data types: one for storing base model weights (in here 4-bit NormalFloat) and another for computational operations (16-bit). During the forward and backward passes, QLoRA dequantizes the weights from the storage format to the computational format. However, it only calculates gradients for the LoRA parameters, which utilize 16-bit bfloat. This approach ensures that weights are decompressed only when necessary, maintaining low memory usage throughout both training and inference phases.`,Ll,z,Dl,x,Kl,H,Ol,S,Ee='Regarding the chat template, we will briefly explain that to understand the structure of the conversation between the user and the model during model training, a series of reserved phrases are created to separate the user’s message and the model’s response. This ensures that the model precisely understands where each message comes from and maintains a sense of the conversational structure. Typically, adhering to a chat template helps increase accuracy in the intended task. However, when there is a distribution shift between the fine-tuning dataset and the model, using a specific chat template can be even more helpful. For further reading, visit <a href="https://huggingface.co/blog/chat-templates" rel="nofollow">Hugging Face Blog on Chat Templates</a>.',Pl,q,le,L,ee,D,se,K,ve=`The <code>SFTTrainer</code> is then instantiated to handle supervised fine-tuning (SFT) of the model. This trainer is specifically designed for SFT and includes additional parameters such as <code>formatting_func</code> and <code>packing</code> which are not typically found in standard trainers.
<code>formatting_func</code>: A custom function to format training examples by combining instruction and response templates.
<code>packing</code>: Disables packing multiple samples into one sequence, which is not a standard parameter in the typical Trainer class.`,te,O,ae,P,ne,ll,pe,el,ie,sl,oe,tl,re,al,ce,nl,me,pl,Me,il,Ye="Here, we merged the adapter with the base model and push the merged model on the hub. You can just push the adapter in the hub and avoid pushing the heavy base model file in this way:",de,ol,Je,rl,Ae="And then you load the model in this way:",he,cl,ye,ml,ue,Ml,ze=`The <code>vllm</code> library is one of the fastest inference engines for LLMs. For a comparative overview of available options, you can use this blog: <a href="https://medium.com/@gsuresh957/7-frameworks-for-serving-llms-5044b533ee88" rel="nofollow">7 Frameworks for Serving LLMs</a>.
In this example, we are inferring version 1 of our fine-tuned model on this task.`,we,dl,Ue,Jl,be,hl,Te,yl,xe='In this blog, you can read about the best practices for fine-tuning LLMs <a href="https://magazine.sebastianraschka.com/p/practical-tips-for-finetuning-llms?r=1h0eu9&amp;utm_campaign=post&amp;utm_medium=web" rel="nofollow">Sebastian Raschka’s Magazine</a>.',fe,ul,je,bl,ge;return u=new ss({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/fine_tuning_llm_to_generate_persian_product_catalogs_in_json_format.ipynb"}]}}),w=new es({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),U=new wl({props:{title:"Fine-tuning LLM to Generate Persian Product Catalogs in JSON Format",local:"fine-tuning-llm-to-generate-persian-product-catalogs-in-json-format",headingTag:"h1"}}),g=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwKCUwQSUyMCUyMCUyMCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTBBJTIwJTIwJTIwJTIwQXV0b1Rva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTBBKSUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwTG9yYUNvbmZpZyUyQyUyMFBlZnRNb2RlbCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRUcmFpbmVyJTJDJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoModelForCausalLM,
    AutoTokenizer,
    BitsAndBytesConfig,
    TrainingArguments,
)
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, PeftModel
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, DataCollatorForCompletionOnlyLM`,wrap:!1}}),R=new wl({props:{title:"Set hyperparameters",local:"set-hyperparameters",headingTag:"h2"}}),_=new M({props:{code:"JTIzJTIwR2VuZXJhbCUyMHBhcmFtZXRlcnMlMEFtb2RlbF9uYW1lJTIwJTNEJTIwJTIyTm91c1Jlc2VhcmNoJTJGTGxhbWEtMi03Yi1jaGF0LWhmJTIyJTIwJTIwJTIzJTIwVGhlJTIwbW9kZWwlMjB0aGF0JTIweW91JTIwd2FudCUyMHRvJTIwdHJhaW4lMjBmcm9tJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBodWIlMEFkYXRhc2V0X25hbWUlMjAlM0QlMjAlMjJCYVNhbGFtJTJGZW50aXR5LWF0dHJpYnV0ZS1kYXRhc2V0LUdQVC0zLjUtZ2VuZXJhdGVkLXYxJTIyJTIwJTIwJTIzJTIwVGhlJTIwaW5zdHJ1Y3Rpb24lMjBkYXRhc2V0JTIwdG8lMjB1c2UlMEFuZXdfbW9kZWwlMjAlM0QlMjAlMjJsbGFtYS1wZXJzaWFuLWNhdGFsb2ctZ2VuZXJhdG9yJTIyJTIwJTIwJTIzJTIwVGhlJTIwbmFtZSUyMGZvciUyMGZpbmUtdHVuZWQlMjBMb1JBJTIwQWRhcHRvcg==",highlighted:`<span class="hljs-comment"># General parameters</span>
model_name = <span class="hljs-string">&quot;NousResearch/Llama-2-7b-chat-hf&quot;</span>  <span class="hljs-comment"># The model that you want to train from the Hugging Face hub</span>
dataset_name = <span class="hljs-string">&quot;BaSalam/entity-attribute-dataset-GPT-3.5-generated-v1&quot;</span>  <span class="hljs-comment"># The instruction dataset to use</span>
new_model = <span class="hljs-string">&quot;llama-persian-catalog-generator&quot;</span>  <span class="hljs-comment"># The name for fine-tuned LoRA Adaptor</span>`,wrap:!1}}),Z=new M({props:{code:"JTIzJTIwTG9SQSUyMHBhcmFtZXRlcnMlMEFsb3JhX3IlMjAlM0QlMjA2NCUwQWxvcmFfYWxwaGElMjAlM0QlMjBsb3JhX3IlMjAqJTIwMiUwQWxvcmFfZHJvcG91dCUyMCUzRCUyMDAuMSUwQXRhcmdldF9tb2R1bGVzJTIwJTNEJTIwJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIydl9wcm9qJTIyJTJDJTIwJ2tfcHJvaiclNUQ=",highlighted:`<span class="hljs-comment"># LoRA parameters</span>
lora_r = <span class="hljs-number">64</span>
lora_alpha = lora_r * <span class="hljs-number">2</span>
lora_dropout = <span class="hljs-number">0.1</span>
target_modules = [<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&#x27;k_proj&#x27;</span>]`,wrap:!1}}),B=new M({props:{code:"JTIzJTIwUUxvUkElMjBwYXJhbWV0ZXJzJTBBbG9hZF9pbl80Yml0JTIwJTNEJTIwVHJ1ZSUwQWJuYl80Yml0X2NvbXB1dGVfZHR5cGUlMjAlM0QlMjAlMjJmbG9hdDE2JTIyJTBBYm5iXzRiaXRfcXVhbnRfdHlwZSUyMCUzRCUyMCUyMm5mNCUyMiUwQWJuYl80Yml0X3VzZV9kb3VibGVfcXVhbnQlMjAlM0QlMjBGYWxzZQ==",highlighted:`<span class="hljs-comment"># QLoRA parameters</span>
load_in_4bit = <span class="hljs-literal">True</span>
bnb_4bit_compute_dtype = <span class="hljs-string">&quot;float16&quot;</span>
bnb_4bit_quant_type = <span class="hljs-string">&quot;nf4&quot;</span>
bnb_4bit_use_double_quant = <span class="hljs-literal">False</span>`,wrap:!1}}),V=new M({props:{code:"JTIzJTIwVHJhaW5pbmdBcmd1bWVudHMlMjBwYXJhbWV0ZXJzJTBBbnVtX3RyYWluX2Vwb2NocyUyMCUzRCUyMDElMEFmcDE2JTIwJTNEJTIwRmFsc2UlMEFiZjE2JTIwJTNEJTIwRmFsc2UlMEFwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjAlM0QlMjA0JTBBZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTIwJTNEJTIwMSUwQWdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjAlM0QlMjBUcnVlJTBBbGVhcm5pbmdfcmF0ZSUyMCUzRCUyMDAuMDAwMTUlMEF3ZWlnaHRfZGVjYXklMjAlM0QlMjAwLjAxJTBBb3B0aW0lMjAlM0QlMjAlMjJwYWdlZF9hZGFtd18zMmJpdCUyMiUwQWxyX3NjaGVkdWxlcl90eXBlJTIwJTNEJTIwJTIyY29zaW5lJTIyJTBBbWF4X3N0ZXBzJTIwJTNEJTIwLTElMEF3YXJtdXBfcmF0aW8lMjAlM0QlMjAwLjAzJTBBZ3JvdXBfYnlfbGVuZ3RoJTIwJTNEJTIwVHJ1ZSUwQXNhdmVfc3RlcHMlMjAlM0QlMjAwJTBBbG9nZ2luZ19zdGVwcyUyMCUzRCUyMDI1JTBBJTBBJTIzJTIwU0ZUJTIwcGFyYW1ldGVycyUwQW1heF9zZXFfbGVuZ3RoJTIwJTNEJTIwTm9uZSUwQXBhY2tpbmclMjAlM0QlMjBGYWxzZSUwQWRldmljZV9tYXAlMjAlM0QlMjAlN0IlMjIlMjIlM0ElMjAwJTdEJTBBJTBBJTIzJTIwRGF0YXNldCUyMHBhcmFtZXRlcnMlMEF1c2Vfc3BlY2lhbF90ZW1wbGF0ZSUyMCUzRCUyMFRydWUlMEFyZXNwb25zZV90ZW1wbGF0ZSUyMCUzRCUyMCclMjAlMjMlMjMlMjMlMjBBbnN3ZXIlM0EnJTBBaW5zdHJ1Y3Rpb25fcHJvbXB0X3RlbXBsYXRlJTIwJTNEJTIwJyUyMiUyMyUyMyUyMyUyMEh1bWFuJTNBJTIyJyUwQXVzZV9sbGFtYV9saWtlX21vZGVsJTIwJTNEJTIwVHJ1ZQ==",highlighted:`<span class="hljs-comment"># TrainingArguments parameters</span>
num_train_epochs = <span class="hljs-number">1</span>
fp16 = <span class="hljs-literal">False</span>
bf16 = <span class="hljs-literal">False</span>
per_device_train_batch_size = <span class="hljs-number">4</span>
gradient_accumulation_steps = <span class="hljs-number">1</span>
gradient_checkpointing = <span class="hljs-literal">True</span>
learning_rate = <span class="hljs-number">0.00015</span>
weight_decay = <span class="hljs-number">0.01</span>
optim = <span class="hljs-string">&quot;paged_adamw_32bit&quot;</span>
lr_scheduler_type = <span class="hljs-string">&quot;cosine&quot;</span>
max_steps = -<span class="hljs-number">1</span>
warmup_ratio = <span class="hljs-number">0.03</span>
group_by_length = <span class="hljs-literal">True</span>
save_steps = <span class="hljs-number">0</span>
logging_steps = <span class="hljs-number">25</span>

<span class="hljs-comment"># SFT parameters</span>
max_seq_length = <span class="hljs-literal">None</span>
packing = <span class="hljs-literal">False</span>
device_map = {<span class="hljs-string">&quot;&quot;</span>: <span class="hljs-number">0</span>}

<span class="hljs-comment"># Dataset parameters</span>
use_special_template = <span class="hljs-literal">True</span>
response_template = <span class="hljs-string">&#x27; ### Answer:&#x27;</span>
instruction_prompt_template = <span class="hljs-string">&#x27;&quot;### Human:&quot;&#x27;</span>
use_llama_like_model = <span class="hljs-literal">True</span>`,wrap:!1}}),W=new wl({props:{title:"Model Training",local:"model-training",headingTag:"h2"}}),k=new M({props:{code:"JTIzJTIwTG9hZCUyMGRhdGFzZXQlMjAoeW91JTIwY2FuJTIwcHJvY2VzcyUyMGl0JTIwaGVyZSklMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KGRhdGFzZXRfbmFtZSUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBcGVyY2VudF9vZl90cmFpbl9kYXRhc2V0JTIwJTNEJTIwMC45NSUwQW90aGVyX2NvbHVtbnMlMjAlM0QlMjAlNUJpJTIwZm9yJTIwaSUyMGluJTIwZGF0YXNldC5jb2x1bW5fbmFtZXMlMjBpZiUyMGklMjBub3QlMjBpbiUyMCU1QidpbnN0cnVjdGlvbiclMkMlMjAnb3V0cHV0JyU1RCU1RCUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbW92ZV9jb2x1bW5zKG90aGVyX2NvbHVtbnMpJTBBc3BsaXRfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQudHJhaW5fdGVzdF9zcGxpdCh0cmFpbl9zaXplJTNEaW50KGRhdGFzZXQubnVtX3Jvd3MlMjAqJTIwcGVyY2VudF9vZl90cmFpbl9kYXRhc2V0KSUyQyUyMHNlZWQlM0QxOSUyQyUyMHNodWZmbGUlM0RGYWxzZSklMEF0cmFpbl9kYXRhc2V0JTIwJTNEJTIwc3BsaXRfZGF0YXNldCU1QiUyMnRyYWluJTIyJTVEJTBBZXZhbF9kYXRhc2V0JTIwJTNEJTIwc3BsaXRfZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlMEFwcmludChmJTIyU2l6ZSUyMG9mJTIwdGhlJTIwdHJhaW4lMjBzZXQlM0ElMjAlN0JsZW4odHJhaW5fZGF0YXNldCklN0QuJTIwU2l6ZSUyMG9mJTIwdGhlJTIwdmFsaWRhdGlvbiUyMHNldCUzQSUyMCU3QmxlbihldmFsX2RhdGFzZXQpJTdEJTIyKQ==",highlighted:`<span class="hljs-comment"># Load dataset (you can process it here)</span>
dataset = load_dataset(dataset_name, split=<span class="hljs-string">&quot;train&quot;</span>)
percent_of_train_dataset = <span class="hljs-number">0.95</span>
other_columns = [i <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> dataset.column_names <span class="hljs-keyword">if</span> i <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&#x27;instruction&#x27;</span>, <span class="hljs-string">&#x27;output&#x27;</span>]]
dataset = dataset.remove_columns(other_columns)
split_dataset = dataset.train_test_split(train_size=<span class="hljs-built_in">int</span>(dataset.num_rows * percent_of_train_dataset), seed=<span class="hljs-number">19</span>, shuffle=<span class="hljs-literal">False</span>)
train_dataset = split_dataset[<span class="hljs-string">&quot;train&quot;</span>]
eval_dataset = split_dataset[<span class="hljs-string">&quot;test&quot;</span>]
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Size of the train set: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(train_dataset)}</span>. Size of the validation set: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(eval_dataset)}</span>&quot;</span>)`,wrap:!1}}),F=new M({props:{code:"JTIzJTIwTG9hZCUyMExvUkElMjBjb25maWd1cmF0aW9uJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0Rsb3JhX3IlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEbG9yYV9hbHBoYSUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRGxvcmFfZHJvcG91dCUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFyZ2V0X21vZHVsZXMlM0R0YXJnZXRfbW9kdWxlcyUwQSk=",highlighted:`<span class="hljs-comment"># Load LoRA configuration</span>
peft_config = LoraConfig(
    r=lora_r,
    lora_alpha=lora_alpha,
    lora_dropout=lora_dropout,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
    target_modules=target_modules
)`,wrap:!1}}),E=new M({props:{code:"JTIzJTIwTG9hZCUyMFFMb1JBJTIwY29uZmlndXJhdGlvbiUwQWNvbXB1dGVfZHR5cGUlMjAlM0QlMjBnZXRhdHRyKHRvcmNoJTJDJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSklMEElMEFibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRGxvYWRfaW5fNGJpdCUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3F1YW50X3R5cGUlM0RibmJfNGJpdF9xdWFudF90eXBlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRGNvbXB1dGVfZHR5cGUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF91c2VfZG91YmxlX3F1YW50JTNEYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Load QLoRA configuration</span>
compute_dtype = <span class="hljs-built_in">getattr</span>(torch, bnb_4bit_compute_dtype)

bnb_config = BitsAndBytesConfig(
    load_in_4bit=load_in_4bit,
    bnb_4bit_quant_type=bnb_4bit_quant_type,
    bnb_4bit_compute_dtype=compute_dtype,
    bnb_4bit_use_double_quant=bnb_4bit_use_double_quant,
)`,wrap:!1}}),z=new M({props:{code:"JTIzJTIwTG9hZCUyMGJhc2UlMjBtb2RlbCUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWUlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEYm5iX2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0RkZXZpY2VfbWFwJTBBKSUwQW1vZGVsLmNvbmZpZy51c2VfY2FjaGUlMjAlM0QlMjBGYWxzZQ==",highlighted:`<span class="hljs-comment"># Load base model</span>
model = AutoModelForCausalLM.from_pretrained(
    model_name,
    quantization_config=bnb_config,
    device_map=device_map
)
model.config.use_cache = <span class="hljs-literal">False</span>`,wrap:!1}}),x=new M({props:{code:"JTIzJTIwU2V0JTIwdHJhaW5pbmclMjBwYXJhbWV0ZXJzJTBBdHJhaW5pbmdfYXJndW1lbnRzJTIwJTNEJTIwVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRG5ld19tb2RlbCUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbl9lcG9jaHMlM0RudW1fdHJhaW5fZXBvY2hzJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTNEcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTJDJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNEZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwb3B0aW0lM0RvcHRpbSUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RlcHMlM0RzYXZlX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRGxvZ2dpbmdfc3RlcHMlMkMlMEElMjAlMjAlMjAlMjBsZWFybmluZ19yYXRlJTNEbGVhcm5pbmdfcmF0ZSUyQyUwQSUyMCUyMCUyMCUyMHdlaWdodF9kZWNheSUzRHdlaWdodF9kZWNheSUyQyUwQSUyMCUyMCUyMCUyMGZwMTYlM0RmcDE2JTJDJTBBJTIwJTIwJTIwJTIwYmYxNiUzRGJmMTYlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0RtYXhfc3RlcHMlMkMlMEElMjAlMjAlMjAlMjB3YXJtdXBfcmF0aW8lM0R3YXJtdXBfcmF0aW8lMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9jaGVja3BvaW50aW5nJTNEZ3JhZGllbnRfY2hlY2twb2ludGluZyUyQyUwQSUyMCUyMCUyMCUyMGdyb3VwX2J5X2xlbmd0aCUzRGdyb3VwX2J5X2xlbmd0aCUyQyUwQSUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlcl90eXBlJTNEbHJfc2NoZWR1bGVyX3R5cGUlMEEp",highlighted:`<span class="hljs-comment"># Set training parameters</span>
training_arguments = TrainingArguments(
    output_dir=new_model,
    num_train_epochs=num_train_epochs,
    per_device_train_batch_size=per_device_train_batch_size,
    gradient_accumulation_steps=gradient_accumulation_steps,
    optim=optim,
    save_steps=save_steps,
    logging_steps=logging_steps,
    learning_rate=learning_rate,
    weight_decay=weight_decay,
    fp16=fp16,
    bf16=bf16,
    max_steps=max_steps,
    warmup_ratio=warmup_ratio,
    gradient_checkpointing=gradient_checkpointing,
    group_by_length=group_by_length,
    lr_scheduler_type=lr_scheduler_type
)`,wrap:!1}}),H=new M({props:{code:"JTIzJTIwTG9hZCUyMHRva2VuaXplciUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWUlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTBBdG9rZW5pemVyLnBhZF90b2tlbiUyMCUzRCUyMHRva2VuaXplci5lb3NfdG9rZW4lMEF0b2tlbml6ZXIucGFkZGluZ19zaWRlJTIwJTNEJTIwJTIycmlnaHQlMjIlMjAlMjAlMjMlMjBGaXglMjB3ZWlyZCUyMG92ZXJmbG93JTIwaXNzdWUlMjB3aXRoJTIwZnAxNiUyMHRyYWluaW5nJTBBaWYlMjBub3QlMjB0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUzQSUwQSUyMCUyMCUyMCUyMHRva2VuaXplci5jaGF0X3RlbXBsYXRlJTIwJTNEJTIwJTIyJTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlN0IlN0InJTNDJTdDaW1fc3RhcnQlN0MlM0UnJTIwJTJCJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUyQiUyMCclNUNuJyUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTNDJTdDaW1fZW5kJTdDJTNFJyUyMCUyQiUyMCclNUNuJyU3RCU3RCU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RCUyMg==",highlighted:`<span class="hljs-comment"># Load tokenizer</span>
tokenizer = AutoTokenizer.from_pretrained(model_name, trust_remote_code=<span class="hljs-literal">True</span>)
tokenizer.pad_token = tokenizer.eos_token
tokenizer.padding_side = <span class="hljs-string">&quot;right&quot;</span>  <span class="hljs-comment"># Fix weird overflow issue with fp16 training</span>
<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> tokenizer.chat_template:
    tokenizer.chat_template = <span class="hljs-string">&quot;{% for message in messages %}{{&#x27;&lt;|im_start|&gt;&#x27; + message[&#x27;role&#x27;] + &#x27;\\n&#x27; + message[&#x27;content&#x27;] + &#x27;&lt;|im_end|&gt;&#x27; + &#x27;\\n&#x27;}}{% endfor %}&quot;</span>`,wrap:!1}}),q=new M({props:{code:"ZGVmJTIwc3BlY2lhbF9mb3JtYXR0aW5nX3Byb21wdHMoZXhhbXBsZSklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRfdGV4dHMlMjAlM0QlMjAlNUIlNUQlMEElMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oZXhhbXBsZSU1QidpbnN0cnVjdGlvbiclNUQpKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRleHQlMjAlM0QlMjBmJTIyJTdCaW5zdHJ1Y3Rpb25fcHJvbXB0X3RlbXBsYXRlJTdEJTdCZXhhbXBsZSU1QidpbnN0cnVjdGlvbiclNUQlNUJpJTVEJTdEJTVDbiU3QnJlc3BvbnNlX3RlbXBsYXRlJTdEJTIwJTdCZXhhbXBsZSU1QidvdXRwdXQnJTVEJTVCaSU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dF90ZXh0cy5hcHBlbmQodGV4dCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBvdXRwdXRfdGV4dHMlMEElMEElMEFkZWYlMjBub3JtYWxfZm9ybWF0dGluZ19wcm9tcHRzKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0X3RleHRzJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UobGVuKGV4YW1wbGUlNUInaW5zdHJ1Y3Rpb24nJTVEKSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjaGF0X3RlbXAlMjAlM0QlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMGV4YW1wbGUlNUInaW5zdHJ1Y3Rpb24nJTVEJTVCaSU1RCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwZXhhbXBsZSU1QidvdXRwdXQnJTVEJTVCaSU1RCU3RCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRleHQlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShjaGF0X3RlbXAlMkMlMjB0b2tlbml6ZSUzREZhbHNlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dF90ZXh0cy5hcHBlbmQodGV4dCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBvdXRwdXRfdGV4dHM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">special_formatting_prompts</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&#x27;instruction&#x27;</span>])):
        text = <span class="hljs-string">f&quot;<span class="hljs-subst">{instruction_prompt_template}</span><span class="hljs-subst">{example[<span class="hljs-string">&#x27;instruction&#x27;</span>][i]}</span>\\n<span class="hljs-subst">{response_template}</span> <span class="hljs-subst">{example[<span class="hljs-string">&#x27;output&#x27;</span>][i]}</span>&quot;</span>
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts


<span class="hljs-keyword">def</span> <span class="hljs-title function_">normal_formatting_prompts</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&#x27;instruction&#x27;</span>])):
        chat_temp = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: example[<span class="hljs-string">&#x27;instruction&#x27;</span>][i]},
                     {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: example[<span class="hljs-string">&#x27;output&#x27;</span>][i]}]
        text = tokenizer.apply_chat_template(chat_temp, tokenize=<span class="hljs-literal">False</span>)
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts`,wrap:!1}}),L=new M({props:{code:"aWYlMjB1c2Vfc3BlY2lhbF90ZW1wbGF0ZSUzQSUwQSUyMCUyMCUyMCUyMGZvcm1hdHRpbmdfZnVuYyUyMCUzRCUyMHNwZWNpYWxfZm9ybWF0dGluZ19wcm9tcHRzJTBBJTIwJTIwJTIwJTIwaWYlMjB1c2VfbGxhbWFfbGlrZV9tb2RlbCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlc3BvbnNlX3RlbXBsYXRlX2lkcyUyMCUzRCUyMHRva2VuaXplci5lbmNvZGUocmVzcG9uc2VfdGVtcGxhdGUlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSklNUIyJTNBJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JGb3JDb21wbGV0aW9uT25seUxNKHJlc3BvbnNlX3RlbXBsYXRlJTNEcmVzcG9uc2VfdGVtcGxhdGVfaWRzJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb2xsYXRvciUyMCUzRCUyMERhdGFDb2xsYXRvckZvckNvbXBsZXRpb25Pbmx5TE0ocmVzcG9uc2VfdGVtcGxhdGUlM0RyZXNwb25zZV90ZW1wbGF0ZSUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciklMEFlbHNlJTNBJTBBJTIwJTIwJTIwJTIwZm9ybWF0dGluZ19mdW5jJTIwJTNEJTIwbm9ybWFsX2Zvcm1hdHRpbmdfcHJvbXB0cw==",highlighted:`<span class="hljs-keyword">if</span> use_special_template:
    formatting_func = special_formatting_prompts
    <span class="hljs-keyword">if</span> use_llama_like_model:
        response_template_ids = tokenizer.encode(response_template, add_special_tokens=<span class="hljs-literal">False</span>)[<span class="hljs-number">2</span>:]
        collator = DataCollatorForCompletionOnlyLM(response_template=response_template_ids, tokenizer=tokenizer)
    <span class="hljs-keyword">else</span>:
        collator = DataCollatorForCompletionOnlyLM(response_template=response_template, tokenizer=tokenizer)
<span class="hljs-keyword">else</span>:
    formatting_func = normal_formatting_prompts`,wrap:!1}}),D=new M({props:{code:"dHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEZXZhbF9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwcGVmdF9jb25maWclM0RwZWZ0X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMGZvcm1hdHRpbmdfZnVuYyUzRGZvcm1hdHRpbmdfZnVuYyUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRvciUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNEbWF4X3NlcV9sZW5ndGglMkMlMEElMjAlMjAlMjAlMjBwcm9jZXNzaW5nX2NsYXNzJTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3VtZW50cyUyQyUwQSUyMCUyMCUyMCUyMHBhY2tpbmclM0RwYWNraW5nJTBBKQ==",highlighted:`trainer = SFTTrainer(
    model=model,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
    peft_config=peft_config,
    formatting_func=formatting_func,
    data_collator=collator,
    max_seq_length=max_seq_length,
    processing_class=tokenizer,
    args=training_arguments,
    packing=packing
)`,wrap:!1}}),O=new M({props:{code:"JTIzJTIwVHJhaW4lMjBtb2RlbCUwQXRyYWluZXIudHJhaW4oKSUwQSUwQSUyMyUyMFNhdmUlMjBmaW5lJTIwdHVuZWQlMjBMb3JhJTIwQWRhcHRvciUyMCUwQXRyYWluZXIubW9kZWwuc2F2ZV9wcmV0cmFpbmVkKG5ld19tb2RlbCk=",highlighted:`<span class="hljs-comment"># Train model</span>
trainer.train()

<span class="hljs-comment"># Save fine tuned Lora Adaptor </span>
trainer.model.save_pretrained(new_model)`,wrap:!1}}),P=new wl({props:{title:"Inference",local:"inference",headingTag:"h2"}}),ll=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBnYyUwQSUwQSUwQWRlZiUyMGNsZWFyX2hhcmR3YXJlcygpJTNBJTBBJTIwJTIwJTIwJTIwdG9yY2guY2xlYXJfYXV0b2Nhc3RfY2FjaGUoKSUwQSUyMCUyMCUyMCUyMHRvcmNoLmN1ZGEuaXBjX2NvbGxlY3QoKSUwQSUyMCUyMCUyMCUyMHRvcmNoLmN1ZGEuZW1wdHlfY2FjaGUoKSUwQSUyMCUyMCUyMCUyMGdjLmNvbGxlY3QoKSUwQSUwQSUwQWNsZWFyX2hhcmR3YXJlcygpJTBBY2xlYXJfaGFyZHdhcmVzKCk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> gc


<span class="hljs-keyword">def</span> <span class="hljs-title function_">clear_hardwares</span>():
    torch.clear_autocast_cache()
    torch.cuda.ipc_collect()
    torch.cuda.empty_cache()
    gc.collect()


clear_hardwares()
clear_hardwares()`,wrap:!1}}),el=new M({props:{code:"ZGVmJTIwZ2VuZXJhdGUobW9kZWwlMkMlMjBwcm9tcHQlM0ElMjBzdHIlMkMlMjBrd2FyZ3MpJTNBJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVkX3Byb21wdCUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCdwdCcpLnRvKG1vZGVsLmRldmljZSklMEElMEElMjAlMjAlMjAlMjBwcm9tcHRfbGVuZ3RoJTIwJTNEJTIwbGVuKHRva2VuaXplZF9wcm9tcHQuZ2V0KCdpbnB1dF9pZHMnKSU1QjAlNUQpJTBBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLmN1ZGEuYW1wLmF1dG9jYXN0KCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRfdG9rZW5zJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKip0b2tlbml6ZWRfcHJvbXB0JTJDJTIwKiprd2FyZ3MpJTIwaWYlMjBrd2FyZ3MlMjBlbHNlJTIwbW9kZWwuZ2VuZXJhdGUoKip0b2tlbml6ZWRfcHJvbXB0KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dCUyMCUzRCUyMHRva2VuaXplci5kZWNvZGUob3V0cHV0X3Rva2VucyU1QjAlNUQlNUJwcm9tcHRfbGVuZ3RoJTNBJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwb3V0cHV0",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate</span>(<span class="hljs-params">model, prompt: <span class="hljs-built_in">str</span>, kwargs</span>):
    tokenized_prompt = tokenizer(prompt, return_tensors=<span class="hljs-string">&#x27;pt&#x27;</span>).to(model.device)

    prompt_length = <span class="hljs-built_in">len</span>(tokenized_prompt.get(<span class="hljs-string">&#x27;input_ids&#x27;</span>)[<span class="hljs-number">0</span>])

    <span class="hljs-keyword">with</span> torch.cuda.amp.autocast():
        output_tokens = model.generate(**tokenized_prompt, **kwargs) <span class="hljs-keyword">if</span> kwargs <span class="hljs-keyword">else</span> model.generate(**tokenized_prompt)
        output = tokenizer.decode(output_tokens[<span class="hljs-number">0</span>][prompt_length:], skip_special_tokens=<span class="hljs-literal">True</span>)

    <span class="hljs-keyword">return</span> output`,wrap:!1}}),sl=new M({props:{code:"YmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChuZXdfbW9kZWwlMkMlMjByZXR1cm5fZGljdCUzRFRydWUlMkMlMjBkZXZpY2VfbWFwJTNEJ2F1dG8nJTJDJTIwdG9rZW4lM0QnJyklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChuZXdfbW9kZWwlMkMlMjBtYXhfbGVuZ3RoJTNEbWF4X3NlcV9sZW5ndGgpJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBuZXdfbW9kZWwpJTBBZGVsJTIwYmFzZV9tb2RlbA==",highlighted:`base_model = AutoModelForCausalLM.from_pretrained(new_model, return_dict=<span class="hljs-literal">True</span>, device_map=<span class="hljs-string">&#x27;auto&#x27;</span>, token=<span class="hljs-string">&#x27;&#x27;</span>)
tokenizer = AutoTokenizer.from_pretrained(new_model, max_length=max_seq_length)
model = PeftModel.from_pretrained(base_model, new_model)
<span class="hljs-keyword">del</span> base_model`,wrap:!1}}),tl=new M({props:{code:"c2FtcGxlJTIwJTNEJTIwZXZhbF9kYXRhc2V0JTVCMCU1RCUwQWlmJTIwdXNlX3NwZWNpYWxfdGVtcGxhdGUlM0ElMEElMjAlMjAlMjAlMjBwcm9tcHQlMjAlM0QlMjBmJTIyJTdCaW5zdHJ1Y3Rpb25fcHJvbXB0X3RlbXBsYXRlJTdEJTdCc2FtcGxlJTVCJ2luc3RydWN0aW9uJyU1RCU3RCU1Q24lN0JyZXNwb25zZV90ZW1wbGF0ZSU3RCUyMiUwQWVsc2UlM0ElMEElMjAlMjAlMjAlMjBjaGF0X3RlbXAlMjAlM0QlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMHNhbXBsZSU1QidpbnN0cnVjdGlvbiclNUQlN0QlNUQlMEElMjAlMjAlMjAlMjBwcm9tcHQlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShjaGF0X3RlbXAlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSk=",highlighted:`sample = eval_dataset[<span class="hljs-number">0</span>]
<span class="hljs-keyword">if</span> use_special_template:
    prompt = <span class="hljs-string">f&quot;<span class="hljs-subst">{instruction_prompt_template}</span><span class="hljs-subst">{sample[<span class="hljs-string">&#x27;instruction&#x27;</span>]}</span>\\n<span class="hljs-subst">{response_template}</span>&quot;</span>
<span class="hljs-keyword">else</span>:
    chat_temp = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: sample[<span class="hljs-string">&#x27;instruction&#x27;</span>]}]
    prompt = tokenizer.apply_chat_template(chat_temp, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>)`,wrap:!1}}),al=new M({props:{code:"Z2VuX2t3YXJncyUyMCUzRCUyMCU3QiUyMm1heF9uZXdfdG9rZW5zJTIyJTNBJTIwMTAyNCU3RCUwQWdlbmVyYXRlZF90ZXh0cyUyMCUzRCUyMGdlbmVyYXRlKG1vZGVsJTNEbW9kZWwlMkMlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMjBrd2FyZ3MlM0RnZW5fa3dhcmdzKSUwQXByaW50KGdlbmVyYXRlZF90ZXh0cyk=",highlighted:`gen_kwargs = {<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">1024</span>}
generated_texts = generate(model=model, prompt=prompt, kwargs=gen_kwargs)
<span class="hljs-built_in">print</span>(generated_texts)`,wrap:!1}}),nl=new wl({props:{title:"Merge to base model",local:"merge-to-base-model",headingTag:"h2"}}),pl=new M({props:{code:"Y2xlYXJfaGFyZHdhcmVzKCklMEFtZXJnZWRfbW9kZWwlMjAlM0QlMjBtb2RlbC5tZXJnZV9hbmRfdW5sb2FkKCklMEFjbGVhcl9oYXJkd2FyZXMoKSUwQWRlbCUyMG1vZGVsJTBBYWRhcHRlcl9tb2RlbF9uYW1lJTIwJTNEJTIwJ3lvdXJfaGZfYWNjb3VudCUyRnlvdXJfZGVzaXJlZF9uYW1lJyUwQW1lcmdlZF9tb2RlbC5wdXNoX3RvX2h1YihhZGFwdGVyX21vZGVsX25hbWUp",highlighted:`clear_hardwares()
merged_model = model.merge_and_unload()
clear_hardwares()
<span class="hljs-keyword">del</span> model
adapter_model_name = <span class="hljs-string">&#x27;your_hf_account/your_desired_name&#x27;</span>
merged_model.push_to_hub(adapter_model_name)`,wrap:!1}}),ol=new M({props:{code:"bW9kZWwucHVzaF90b19odWIoYWRhcHRlcl9tb2RlbF9uYW1lKQ==",highlighted:'model.push<span class="hljs-constructor">_to_hub(<span class="hljs-params">adapter_model_name</span>)</span>',wrap:!1}}),cl=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwUGVmdENvbmZpZy5mcm9tX3ByZXRyYWluZWQoYWRhcHRlcl9tb2RlbF9uYW1lKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNvbmZpZy5iYXNlX21vZGVsX25hbWVfb3JfcGF0aCUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSUyQyUyMGxvYWRfaW5fOGJpdCUzRFRydWUlMkMlMjBkZXZpY2VfbWFwJTNEJ2F1dG8nKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKGNvbmZpZy5iYXNlX21vZGVsX25hbWVfb3JfcGF0aCklMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwTG9yYSUyMG1vZGVsJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKG1vZGVsJTJDJTIwYWRhcHRlcl9tb2RlbF9uYW1lKQ==",highlighted:`config = <span class="hljs-module-access"><span class="hljs-module"><span class="hljs-identifier">PeftConfig</span>.</span></span>from<span class="hljs-constructor">_pretrained(<span class="hljs-params">adapter_model_name</span>)</span>
model = <span class="hljs-module-access"><span class="hljs-module"><span class="hljs-identifier">AutoModelForCausalLM</span>.</span></span>from<span class="hljs-constructor">_pretrained(<span class="hljs-params">config</span>.<span class="hljs-params">base_model_name_or_path</span>, <span class="hljs-params">return_dict</span>=True, <span class="hljs-params">load_in_8bit</span>=True, <span class="hljs-params">device_map</span>=&#x27;<span class="hljs-params">auto</span>&#x27;)</span>
tokenizer = <span class="hljs-module-access"><span class="hljs-module"><span class="hljs-identifier">AutoTokenizer</span>.</span></span>from<span class="hljs-constructor">_pretrained(<span class="hljs-params">config</span>.<span class="hljs-params">base_model_name_or_path</span>)</span>

# Load the Lora model
model = <span class="hljs-module-access"><span class="hljs-module"><span class="hljs-identifier">PeftModel</span>.</span></span>from<span class="hljs-constructor">_pretrained(<span class="hljs-params">model</span>, <span class="hljs-params">adapter_model_name</span>)</span>`,wrap:!1}}),ml=new wl({props:{title:"Fast Inference with Vllm",local:"fast-inference-with-vllm",headingTag:"h2"}}),dl=new M({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> vllm <span class="hljs-keyword">import</span> LLM, SamplingParams

prompt = <span class="hljs-string">&quot;&quot;&quot;### Question: here is a product title from a Iranian marketplace.  \\n         give me the Product Entity and Attributes of this product in Persian language.\\n         give the output in this json format: {&#x27;attributes&#x27;: {&#x27;attribute_name&#x27; : &lt;attribute value&gt;, ...}, &#x27;product_entity&#x27;: &#x27;&lt;product entity&gt;&#x27;}.\\n         Don&#x27;t make assumptions about what values to plug into json. Just give Json not a single word more.\\n         \\nproduct title:&quot;&quot;&quot;</span>
user_prompt_template = <span class="hljs-string">&#x27;### Question: &#x27;</span>
response_template = <span class="hljs-string">&#x27; ### Answer:&#x27;</span>

llm = LLM(model=<span class="hljs-string">&#x27;BaSalam/Llama2-7b-entity-attr-v1&#x27;</span>, gpu_memory_utilization=<span class="hljs-number">0.9</span>, trust_remote_code=<span class="hljs-literal">True</span>)

product = <span class="hljs-string">&#x27;مانتو اسپرت پانیذ قد جلوی کار حدودا 85 سانتی متر قد پشت کار حدودا 88 سانتی متر&#x27;</span>
sampling_params = SamplingParams(temperature=<span class="hljs-number">0.0</span>, max_tokens=<span class="hljs-number">75</span>)
prompt = <span class="hljs-string">f&#x27;<span class="hljs-subst">{user_prompt_template}</span> <span class="hljs-subst">{prompt}</span><span class="hljs-subst">{product}</span>\\n <span class="hljs-subst">{response_template}</span>&#x27;</span>
outputs = llm.generate(prompt, sampling_params)

<span class="hljs-built_in">print</span>(outputs[<span class="hljs-number">0</span>].outputs[<span class="hljs-number">0</span>].text)`,wrap:!1}}),Jl=new wl({props:{title:"Example Output",local:"example-output",headingTag:"h3"}}),hl=new M({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyYXR0cmlidXRlcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMiVEOSU4MiVEOCVBRiUyMCVEOCVBQyVEOSU4NCVEOSU4OCVEQiU4QyUyMCVEQSVBOSVEOCVBNyVEOCVCMSUyMiUzQSUyMCUyMjg1JTIwJUQ4JUIzJUQ4JUE3JUQ5JTg2JUQ4JUFBJURCJThDJTIwJUQ5JTg1JUQ4JUFBJUQ4JUIxJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJUQ5JTgyJUQ4JUFGJTIwJUQ5JUJFJUQ4JUI0JUQ4JUFBJTIwJURBJUE5JUQ4JUE3JUQ4JUIxJTIyJTNBJTIwJTIyODglMjAlRDglQjMlRDglQTclRDklODYlRDglQUElREIlOEMlMjAlRDklODUlRDglQUElRDglQjElMjIlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJwcm9kdWN0X2VudGl0eSUyMiUzQSUyMCUyMiVEOSU4NSVEOCVBNyVEOSU4NiVEOCVBQSVEOSU4OCUyMCVEOCVBNyVEOCVCMyVEOSVCRSVEOCVCMSVEOCVBQSUyMiUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;attributes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;قد جلوی کار&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;85 سانتی متر&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;قد پشت کار&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;88 سانتی متر&quot;</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;product_entity&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;مانتو اسپرت&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ul=new ts({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/fine_tuning_llm_to_generate_persian_product_catalogs_in_json_format.md"}}),{c(){y=d("meta"),Tl=a(),Ul=d("p"),fl=a(),p(u.$$.fragment),jl=a(),p(w.$$.fragment),gl=a(),p(U.$$.fragment),Il=a(),b=d("p"),b.innerHTML=Re,Rl=a(),T=d("p"),T.innerHTML=_e,_l=a(),f=d("p"),f.innerHTML=Ze,Zl=a(),j=d("p"),j.textContent=Ce,Cl=a(),p(g.$$.fragment),Xl=a(),I=d("p"),I.innerHTML=Xe,Bl=a(),p(R.$$.fragment),Gl=a(),p(_.$$.fragment),Ql=a(),p(Z.$$.fragment),Vl=a(),C=d("p"),C.textContent=Be,Wl=a(),X=d("p"),X.innerHTML=Ge,kl=a(),p(B.$$.fragment),Fl=a(),G=d("p"),G.textContent=Qe,Nl=a(),Q=d("p"),Q.innerHTML=Ve,$l=a(),p(V.$$.fragment),El=a(),p(W.$$.fragment),vl=a(),p(k.$$.fragment),Yl=a(),p(F.$$.fragment),Al=a(),N=d("p"),N.textContent=We,zl=a(),$=d("ul"),$.innerHTML=ke,xl=a(),p(E.$$.fragment),Hl=a(),v=d("p"),v.textContent=Fe,Sl=a(),Y=d("ul"),Y.innerHTML=Ne,ql=a(),A=d("p"),A.textContent=$e,Ll=a(),p(z.$$.fragment),Dl=a(),p(x.$$.fragment),Kl=a(),p(H.$$.fragment),Ol=a(),S=d("p"),S.innerHTML=Ee,Pl=a(),p(q.$$.fragment),le=a(),p(L.$$.fragment),ee=a(),p(D.$$.fragment),se=a(),K=d("p"),K.innerHTML=ve,te=a(),p(O.$$.fragment),ae=a(),p(P.$$.fragment),ne=a(),p(ll.$$.fragment),pe=a(),p(el.$$.fragment),ie=a(),p(sl.$$.fragment),oe=a(),p(tl.$$.fragment),re=a(),p(al.$$.fragment),ce=a(),p(nl.$$.fragment),me=a(),p(pl.$$.fragment),Me=a(),il=d("p"),il.textContent=Ye,de=a(),p(ol.$$.fragment),Je=a(),rl=d("p"),rl.textContent=Ae,he=a(),p(cl.$$.fragment),ye=a(),p(ml.$$.fragment),ue=a(),Ml=d("p"),Ml.innerHTML=ze,we=a(),p(dl.$$.fragment),Ue=a(),p(Jl.$$.fragment),be=a(),p(hl.$$.fragment),Te=a(),yl=d("p"),yl.innerHTML=xe,fe=a(),p(ul.$$.fragment),je=a(),bl=d("p"),this.h()},l(l){const e=Pe("svelte-u9bgzb",document.head);y=J(e,"META",{name:!0,content:!0}),e.forEach(s),Tl=n(l),Ul=J(l,"P",{}),He(Ul).forEach(s),fl=n(l),i(u.$$.fragment,l),jl=n(l),i(w.$$.fragment,l),gl=n(l),i(U.$$.fragment,l),Il=n(l),b=J(l,"P",{"data-svelte-h":!0}),h(b)!=="svelte-o7dign"&&(b.innerHTML=Re),Rl=n(l),T=J(l,"P",{"data-svelte-h":!0}),h(T)!=="svelte-1g3gbfg"&&(T.innerHTML=_e),_l=n(l),f=J(l,"P",{"data-svelte-h":!0}),h(f)!=="svelte-mfhn7k"&&(f.innerHTML=Ze),Zl=n(l),j=J(l,"P",{"data-svelte-h":!0}),h(j)!=="svelte-4b3xjd"&&(j.textContent=Ce),Cl=n(l),i(g.$$.fragment,l),Xl=n(l),I=J(l,"P",{"data-svelte-h":!0}),h(I)!=="svelte-19vh6bq"&&(I.innerHTML=Xe),Bl=n(l),i(R.$$.fragment,l),Gl=n(l),i(_.$$.fragment,l),Ql=n(l),i(Z.$$.fragment,l),Vl=n(l),C=J(l,"P",{"data-svelte-h":!0}),h(C)!=="svelte-yzu4o4"&&(C.textContent=Be),Wl=n(l),X=J(l,"P",{"data-svelte-h":!0}),h(X)!=="svelte-18s82z4"&&(X.innerHTML=Ge),kl=n(l),i(B.$$.fragment,l),Fl=n(l),G=J(l,"P",{"data-svelte-h":!0}),h(G)!=="svelte-di718e"&&(G.textContent=Qe),Nl=n(l),Q=J(l,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-1dycqr8"&&(Q.innerHTML=Ve),$l=n(l),i(V.$$.fragment,l),El=n(l),i(W.$$.fragment,l),vl=n(l),i(k.$$.fragment,l),Yl=n(l),i(F.$$.fragment,l),Al=n(l),N=J(l,"P",{"data-svelte-h":!0}),h(N)!=="svelte-1lg9t6r"&&(N.textContent=We),zl=n(l),$=J(l,"UL",{"data-svelte-h":!0}),h($)!=="svelte-k2o7br"&&($.innerHTML=ke),xl=n(l),i(E.$$.fragment,l),Hl=n(l),v=J(l,"P",{"data-svelte-h":!0}),h(v)!=="svelte-d6vihj"&&(v.textContent=Fe),Sl=n(l),Y=J(l,"UL",{"data-svelte-h":!0}),h(Y)!=="svelte-14qvpe"&&(Y.innerHTML=Ne),ql=n(l),A=J(l,"P",{"data-svelte-h":!0}),h(A)!=="svelte-x1g2ni"&&(A.textContent=$e),Ll=n(l),i(z.$$.fragment,l),Dl=n(l),i(x.$$.fragment,l),Kl=n(l),i(H.$$.fragment,l),Ol=n(l),S=J(l,"P",{"data-svelte-h":!0}),h(S)!=="svelte-ozzu3c"&&(S.innerHTML=Ee),Pl=n(l),i(q.$$.fragment,l),le=n(l),i(L.$$.fragment,l),ee=n(l),i(D.$$.fragment,l),se=n(l),K=J(l,"P",{"data-svelte-h":!0}),h(K)!=="svelte-eg8qz8"&&(K.innerHTML=ve),te=n(l),i(O.$$.fragment,l),ae=n(l),i(P.$$.fragment,l),ne=n(l),i(ll.$$.fragment,l),pe=n(l),i(el.$$.fragment,l),ie=n(l),i(sl.$$.fragment,l),oe=n(l),i(tl.$$.fragment,l),re=n(l),i(al.$$.fragment,l),ce=n(l),i(nl.$$.fragment,l),me=n(l),i(pl.$$.fragment,l),Me=n(l),il=J(l,"P",{"data-svelte-h":!0}),h(il)!=="svelte-qsgsjj"&&(il.textContent=Ye),de=n(l),i(ol.$$.fragment,l),Je=n(l),rl=J(l,"P",{"data-svelte-h":!0}),h(rl)!=="svelte-suuhef"&&(rl.textContent=Ae),he=n(l),i(cl.$$.fragment,l),ye=n(l),i(ml.$$.fragment,l),ue=n(l),Ml=J(l,"P",{"data-svelte-h":!0}),h(Ml)!=="svelte-1d85zth"&&(Ml.innerHTML=ze),we=n(l),i(dl.$$.fragment,l),Ue=n(l),i(Jl.$$.fragment,l),be=n(l),i(hl.$$.fragment,l),Te=n(l),yl=J(l,"P",{"data-svelte-h":!0}),h(yl)!=="svelte-cd8kji"&&(yl.innerHTML=xe),fe=n(l),i(ul.$$.fragment,l),je=n(l),bl=J(l,"P",{}),He(bl).forEach(s),this.h()},h(){Se(y,"name","hf:doc:metadata"),Se(y,"content",ns)},m(l,e){ls(document.head,y),t(l,Tl,e),t(l,Ul,e),t(l,fl,e),o(u,l,e),t(l,jl,e),o(w,l,e),t(l,gl,e),o(U,l,e),t(l,Il,e),t(l,b,e),t(l,Rl,e),t(l,T,e),t(l,_l,e),t(l,f,e),t(l,Zl,e),t(l,j,e),t(l,Cl,e),o(g,l,e),t(l,Xl,e),t(l,I,e),t(l,Bl,e),o(R,l,e),t(l,Gl,e),o(_,l,e),t(l,Ql,e),o(Z,l,e),t(l,Vl,e),t(l,C,e),t(l,Wl,e),t(l,X,e),t(l,kl,e),o(B,l,e),t(l,Fl,e),t(l,G,e),t(l,Nl,e),t(l,Q,e),t(l,$l,e),o(V,l,e),t(l,El,e),o(W,l,e),t(l,vl,e),o(k,l,e),t(l,Yl,e),o(F,l,e),t(l,Al,e),t(l,N,e),t(l,zl,e),t(l,$,e),t(l,xl,e),o(E,l,e),t(l,Hl,e),t(l,v,e),t(l,Sl,e),t(l,Y,e),t(l,ql,e),t(l,A,e),t(l,Ll,e),o(z,l,e),t(l,Dl,e),o(x,l,e),t(l,Kl,e),o(H,l,e),t(l,Ol,e),t(l,S,e),t(l,Pl,e),o(q,l,e),t(l,le,e),o(L,l,e),t(l,ee,e),o(D,l,e),t(l,se,e),t(l,K,e),t(l,te,e),o(O,l,e),t(l,ae,e),o(P,l,e),t(l,ne,e),o(ll,l,e),t(l,pe,e),o(el,l,e),t(l,ie,e),o(sl,l,e),t(l,oe,e),o(tl,l,e),t(l,re,e),o(al,l,e),t(l,ce,e),o(nl,l,e),t(l,me,e),o(pl,l,e),t(l,Me,e),t(l,il,e),t(l,de,e),o(ol,l,e),t(l,Je,e),t(l,rl,e),t(l,he,e),o(cl,l,e),t(l,ye,e),o(ml,l,e),t(l,ue,e),t(l,Ml,e),t(l,we,e),o(dl,l,e),t(l,Ue,e),o(Jl,l,e),t(l,be,e),o(hl,l,e),t(l,Te,e),t(l,yl,e),t(l,fe,e),o(ul,l,e),t(l,je,e),t(l,bl,e),ge=!0},p:Le,i(l){ge||(r(u.$$.fragment,l),r(w.$$.fragment,l),r(U.$$.fragment,l),r(g.$$.fragment,l),r(R.$$.fragment,l),r(_.$$.fragment,l),r(Z.$$.fragment,l),r(B.$$.fragment,l),r(V.$$.fragment,l),r(W.$$.fragment,l),r(k.$$.fragment,l),r(F.$$.fragment,l),r(E.$$.fragment,l),r(z.$$.fragment,l),r(x.$$.fragment,l),r(H.$$.fragment,l),r(q.$$.fragment,l),r(L.$$.fragment,l),r(D.$$.fragment,l),r(O.$$.fragment,l),r(P.$$.fragment,l),r(ll.$$.fragment,l),r(el.$$.fragment,l),r(sl.$$.fragment,l),r(tl.$$.fragment,l),r(al.$$.fragment,l),r(nl.$$.fragment,l),r(pl.$$.fragment,l),r(ol.$$.fragment,l),r(cl.$$.fragment,l),r(ml.$$.fragment,l),r(dl.$$.fragment,l),r(Jl.$$.fragment,l),r(hl.$$.fragment,l),r(ul.$$.fragment,l),ge=!0)},o(l){c(u.$$.fragment,l),c(w.$$.fragment,l),c(U.$$.fragment,l),c(g.$$.fragment,l),c(R.$$.fragment,l),c(_.$$.fragment,l),c(Z.$$.fragment,l),c(B.$$.fragment,l),c(V.$$.fragment,l),c(W.$$.fragment,l),c(k.$$.fragment,l),c(F.$$.fragment,l),c(E.$$.fragment,l),c(z.$$.fragment,l),c(x.$$.fragment,l),c(H.$$.fragment,l),c(q.$$.fragment,l),c(L.$$.fragment,l),c(D.$$.fragment,l),c(O.$$.fragment,l),c(P.$$.fragment,l),c(ll.$$.fragment,l),c(el.$$.fragment,l),c(sl.$$.fragment,l),c(tl.$$.fragment,l),c(al.$$.fragment,l),c(nl.$$.fragment,l),c(pl.$$.fragment,l),c(ol.$$.fragment,l),c(cl.$$.fragment,l),c(ml.$$.fragment,l),c(dl.$$.fragment,l),c(Jl.$$.fragment,l),c(hl.$$.fragment,l),c(ul.$$.fragment,l),ge=!1},d(l){l&&(s(Tl),s(Ul),s(fl),s(jl),s(gl),s(Il),s(b),s(Rl),s(T),s(_l),s(f),s(Zl),s(j),s(Cl),s(Xl),s(I),s(Bl),s(Gl),s(Ql),s(Vl),s(C),s(Wl),s(X),s(kl),s(Fl),s(G),s(Nl),s(Q),s($l),s(El),s(vl),s(Yl),s(Al),s(N),s(zl),s($),s(xl),s(Hl),s(v),s(Sl),s(Y),s(ql),s(A),s(Ll),s(Dl),s(Kl),s(Ol),s(S),s(Pl),s(le),s(ee),s(se),s(K),s(te),s(ae),s(ne),s(pe),s(ie),s(oe),s(re),s(ce),s(me),s(Me),s(il),s(de),s(Je),s(rl),s(he),s(ye),s(ue),s(Ml),s(we),s(Ue),s(be),s(Te),s(yl),s(fe),s(je),s(bl)),s(y),m(u,l),m(w,l),m(U,l),m(g,l),m(R,l),m(_,l),m(Z,l),m(B,l),m(V,l),m(W,l),m(k,l),m(F,l),m(E,l),m(z,l),m(x,l),m(H,l),m(q,l),m(L,l),m(D,l),m(O,l),m(P,l),m(ll,l),m(el,l),m(sl,l),m(tl,l),m(al,l),m(nl,l),m(pl,l),m(ol,l),m(cl,l),m(ml,l),m(dl,l),m(Jl,l),m(hl,l),m(ul,l)}}}const ns='{"title":"Fine-tuning LLM to Generate Persian Product Catalogs in JSON Format","local":"fine-tuning-llm-to-generate-persian-product-catalogs-in-json-format","sections":[{"title":"Set hyperparameters","local":"set-hyperparameters","sections":[],"depth":2},{"title":"Model Training","local":"model-training","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2},{"title":"Merge to base model","local":"merge-to-base-model","sections":[],"depth":2},{"title":"Fast Inference with Vllm","local":"fast-inference-with-vllm","sections":[{"title":"Example Output","local":"example-output","sections":[],"depth":3}],"depth":2}],"depth":1}';function ps(Ie){return De(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ms extends Ke{constructor(y){super(),Oe(this,y,ps,as,qe,{})}}export{Ms as component};
